; main_program t7_extend
;
; Extend the F10.7 dataset into the future by patching on the data
; with similar phase from two solar cycles ago.
;
; B. Knapp, 93.01.21
;           98.06.10, IDL v. 5 compliance
;
  t7,1947045L,1993024L,f,t,1
  n = n_elements(f)
  recent = f[n-5844:n-1]         ;16 years, to include more than a full cycle
;
  rmin = 1e38
  for j=n-8766,n-7305 do begin   ;24 to 20 years ago
     r = total( (f[j-5843:j]-recent)^2 )   ;j aligns with n-1
     if r lt rmin then begin
        rmin=r
        jmin=j
     endif
  endfor
  print,' RMS Residual =',sqrt(rmin/n), $
        '; period =',(n-jmin-1)/365.25,' years'
  print,' '
;
  fx = [f,f[jmin+1:jmin+1461]]
  tx=(findgen(n+1461)+days(1900000L,1947045L))/365.25
;
  get_dev,dev
;
  plot,tx,fx,title='"Extended" F10.7 Dataset', $
     xtitle='years since 1900 Jan 1', ytitle='10^-22 W/m^2'
  ans=' '
  if dev eq 0 then read,' CR...',ans
;
  fxs = smooth(fx,91)
  plot,tx,fxs,title='"Extended" F10.7 Dataset, 91-day smooth'
  ans=' '
  if dev eq 0 then read,' CR...',ans
;
  pick = where( (93.0 le tx) and (tx le 96) )
  plot,tx[pick],fxs[pick],title='"Extended" F10.7 Dataset, 91-day smooth', $
     xtitle='years since 1900 Jan 1', ytitle='10^-22 W/m^2', $
     xrange=[93,96]

  ans=' '
  if dev eq 0 then read,' CR...',ans
;  
  send_plots,dev
  end





