;-----------------------------------------------------------------------
pro update_select_zplevs_text,stateptr,utlatptr
  state = *stateptr
  levs = *state.levs
  revlevs = reverse(levs)
  utlat = *utlatptr
  select_zplevs_list = widget_info(utlat.tlb,find_by_uname='SELECT_ZPLEVS')
  indices = widget_info(select_zplevs_list,/list_select)
  select_zplevs_text = widget_info(utlat.tlb,find_by_uname='SELECT_ZPLEVS_TEXT')
  nzplevs = n_elements(indices)
  *utlat.zplevs = revlevs[indices]
  npline = 6 ; number of levels to show per line
  nlines = nzplevs/npline
  if (nzplevs mod npline gt 0) then nlines = nlines+1
  lines = strarr(nlines)
  nzp = nzplevs
  i0 = 0
  for i=0,nlines-1 do begin
    if (nzp ge npline) then nfline = npline else nfline = nzp
    i1 = i0+nfline-1
    for ii=i0,i1 do lines[i] = lines[i]+string(format="(f6.2)",$
      revlevs[indices[ii]])+', '
    i0 = i0+nfline
    nzp = nzp-nfline
  endfor
  newlines = strarr(nlines+1)
  newlines[0] = string(format="('There are ',i3,' zp levels currently selected:')",$
    nzplevs)
  for i=1,nlines do newlines[i] = lines[i-1]
  widget_control,select_zplevs_text,set_value=newlines
  *utlatptr = utlat ; updates utlat.zplevs, set above 
end
;-----------------------------------------------------------------------
pro update_select_lons_text,stateptr,utlatptr
  state = *stateptr
  lons = *state.lons
  utlat = *utlatptr
  select_lons_list = widget_info(utlat.tlb,find_by_uname='SELECT_LONS')
  indices = widget_info(select_lons_list,/list_select)
  select_lons_text = widget_info(utlat.tlb,find_by_uname='SELECT_LONS_TEXT')
  nslons = n_elements(indices)
  *utlat.slons = lons[indices]
  npline = 5 ; number of lons to show per line
  nlines = nslons/npline
  if (nslons mod npline gt 0) then nlines = nlines+1
  lines = strarr(nlines)
  nslon = nslons
  i0 = 0
  for i=0,nlines-1 do begin
    if (nslon ge npline) then nfline = npline else nfline = nslon
    i1 = i0+nfline-1
    for ii=i0,i1 do lines[i] = lines[i]+string(format="(f7.2)",$
      lons[indices[ii]])+', '
    i0 = i0+nfline
    nslon = nslon-nfline
  endfor
  newlines = strarr(nlines+1)
  newlines[0] = string(format="('There are ',i3,' longitudes currently selected:')",$
    nslons)
  for i=1,nlines do newlines[i] = lines[i-1]
  widget_control,select_lons_text,set_value=newlines
  *utlatptr = utlat ; updates utlat.slons, set above 
end
;-----------------------------------------------------------------------
pro cancel_utlat_event,event
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  widget_control,event.top,/destroy
  state.utlat_tlb = -1
  *stateptr = state
end
;-----------------------------------------------------------------------
pro select_zplevs_event,event
  widget_control,event.top,get_uvalue=stateptr
  widget_control,event.id,get_uvalue=utlatptr
  state = *stateptr
  utlat = *utlatptr
  zplevs = *utlat.zplevs
; indices = widget_info(event.id,/list_select)
  update_select_zplevs_text,stateptr,utlatptr
end
;-----------------------------------------------------------------------
pro select_lons_event,event
  widget_control,event.top,get_uvalue=stateptr
  widget_control,event.id,get_uvalue=utlatptr
  state = *stateptr
  utlat = *utlatptr
  slons = *utlat.slons
; indices = widget_info(event.id,/list_select)
  update_select_lons_text,stateptr,utlatptr
end
;-----------------------------------------------------------------------
pro select_lats_event,event
  widget_control,event.id,get_uvalue=utlatptr
  utlat = *utlatptr
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  lats = *state.lats
  uname = widget_info(event.id,/uname)
  ilat0 = ixfind_simple(lats,utlat.lat0)
  ilat1 = ixfind_simple(lats,utlat.lat1)
  case uname of
    'SELECT_SLAT': begin
      lat0 = lats[event.index]
      if (lat0 ge utlat.lat1) then begin
        print,'>>> Southern-most latitude must be less than northern-most'
        print,format=$
          "('Selected south latitude = ',f6.2,' Current north latitude = ',f6.2)",$
          lat0,utlat.lat1
        print,'Reverting to former southern-most latitude ',utlat.lat0
        widget_control,event.id,set_list_select=ilat0
      endif else begin
        utlat.lat0 = lat0
        id = widget_info(event.top,find_by_uname='SELECT_SLAT_TEXT')
        text = string(format="('Select southern-most latitude (',f6.2,')')",utlat.lat0)
        widget_control,id,set_value=text
      endelse
      print,'Selected southern-most latitude ',lat0
    end
    'SELECT_NLAT': begin
      lat1 = lats[event.index]
      if (lat1 le utlat.lat0) then begin
        print,'>>> Northern-most latitude must be greater than southern-most'
        print,format=$
          "('Selected north latitude = ',f6.2,' Current south latitude = ',f6.2)",$
          lat1,utlat.lat0
        print,'Reverting to former northern-most latitude ',utlat.lat1
        widget_control,event.id,set_list_select=ilat1
      endif else begin
        utlat.lat1 = lat1
        id = widget_info(event.top,find_by_uname='SELECT_NLAT_TEXT')
        text = string(format="('Select northern-most latitude (',f6.2,')')",utlat.lat1)
        widget_control,id,set_value=text
      endelse
      print,'Selected northern-most latitude ',lat1
    end
  endcase
  ilat0 = ixfind_simple(*state.lats,utlat.lat0)
  ilat1 = ixfind_simple(*state.lats,utlat.lat1)
  nlats = ilat1-ilat0+1
  glats = fltarr(nlats)
  glats[*] = lats[ilat0:ilat1]
  *utlat.lats = glats
  *utlatptr = utlat
; print,'select_lats_event: nlat=',n_elements(glats),' lats=' 
; print,*utlat.lats
end
;-----------------------------------------------------------------------
pro plt_utlat_event,event
  print,'Make ut vs lat plots..'
  
  widget_control,event.id,get_uvalue=utlatptr
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
; Re-read ps output file:
; id = widget_info(state.tlb,find_by_uname='SET_PS_OUTFILE')
; set_ps_outfile,id,stateptr
  open_ps_file,stateptr
  widget_control,/hourglass
  pltutlat,stateptr,utlatptr
end
;-----------------------------------------------------------------------
pro help_utlat_event,event
  widget_control,event.id,get_uvalue=utlatptr
  utlat = *utlatptr
  display_help,utlat.tlb,'UTLAT'
end
;-----------------------------------------------------------------------
pro mkutlat,stateptr
  state = *stateptr  ; should be read only
  lats = *state.lats
  nlat = n_elements(lats)
  lons = *state.lons
  nlon = n_elements(lons)
  levs = reverse(*state.levs)
  nlev = n_elements(levs)
  default_zplevs = [levs[1],levs[nlev/2],levs[nlev-1]] ; note levs are reversed
  nzplevs = n_elements(default_zplevs)
  default_slons = [-180.,-90.,0.,90.]
  utlat = {                         $
    tlb:0,                          $ top level base
    zplevs:ptr_new(/allocate_heap), $ zp levels at which to plot ut vs lat
    slons:ptr_new(/allocate_heap),  $
    lat0:lats[0],                   $ first (southern most) latitude to plot
    lat1:lats[nlat-1],              $ last (northern most) latitude to plot
    lats:ptr_new(/allocate_heap)    $ latitudes to plot (lat0 to lat1)
  }
  utlatptr = ptr_new(utlat)
;
; tlb for utlat:
;
  utlat_base = widget_base(column=1,uvalue=stateptr,$
    uname='UTLAT_BASE',title='Plot ut vs latitude',$
    group_leader=state.tlb)
  utlat.tlb = utlat_base
  state.utlat_tlb = utlat_base
  *utlatptr = utlat
  *stateptr = state
;
; Select pressure levels:
;
  select_zplevs_base = widget_base(utlat_base,column=2,frame=3,$
    uname='SELECT_ZPLEVS_BASE',uvalue=utlatptr)

  label = widget_label(select_zplevs_base,value='Select zp levels')
  zplist = strarr(nlev)
  select_indices = intarr(nzplevs)
  for k=0,nlev-1 do zplist[k] = string(format="(f6.2)",levs[k])
  for k=0,nzplevs-1 do select_indices[k] = ixfind_simple(levs,default_zplevs[k])
  list = widget_list(select_zplevs_base,value=zplist,ysize=10,xsize=12,$
    uvalue=utlatptr,event_pro='select_zplevs_event',uname ='SELECT_ZPLEVS',$
    /multiple)
  widget_control,list,set_list_select=select_indices

  *utlat.zplevs = default_zplevs
  label = widget_label(select_zplevs_base,value='Zp levels currently selected:')
  text = strarr(nzplevs)
  for k=0,nzplevs-1 do $
    text[k] = string(format="(f6.2,', ')", default_zplevs[k])
  widget = widget_text(select_zplevs_base,value=text,$
    uname='SELECT_ZPLEVS_TEXT',xsize=50,ysize=10)
;
; Select longitudes (later this will include a local times option)
;
  *utlat.slons = default_slons
  select_lons_base = widget_base(utlat_base,column=2,frame=3,$
    uname='SELECT_LONS_BASE',uvalue=utlatptr)
;
  label = widget_label(select_lons_base,value='Select longitudes')
  lonlist = strarr(nlon)
  for i=0,nlon-1 do lonlist[i] = string(format="(f7.2)",lons[i])
  list = widget_list(select_lons_base,value=lonlist,ysize=10,xsize=12,$
    uvalue=utlatptr,event_pro='select_lons_event',$
    uname ='SELECT_LONS',/multiple)
  nslons = n_elements(default_slons)
  select_indices = intarr(nslons)
  for i=0,nslons-1 do select_indices[i] = ixfind_simple(lons,default_slons[i])
  widget_control,list,set_list_select=select_indices

  label = widget_label(select_lons_base,value='Longitudes currently selected:')
  text = strarr(nslons)
  for i=0,nslons-1 do $
    text[i] = string(format="(f7.2,', ')", default_slons[i])
  widget = widget_text(select_lons_base,value=text,$
    uname='SELECT_LONS_TEXT',xsize=50,ysize=10)
;
; Select first,last latitudes:
;
  select_lats_base = widget_base(utlat_base,uvalue=stateptr,col=2)
;
  list_base = widget_base(select_lats_base,row=2,frame=3)
  text = string(format="('Select southern-most latitude (',f6.2,')')",utlat.lat0)
  label = widget_label(list_base,value=text,uname='SELECT_SLAT_TEXT')
  list = strarr(nlat)
  for j=0,nlat-1 do list[j] = string(format="(f6.2)",lats[j])
  list = widget_list(list_base,value=list,ysize=10,xsize=12,$
    uvalue=utlatptr,event_pro='select_lats_event',uname ='SELECT_SLAT')
  ilat0 = ixfind(lats,utlat.lat0,lats[1]-lats[0])
  widget_control,list,set_list_select=ilat0
;
  list_base = widget_base(select_lats_base,row=2,frame=3)
  text = string(format="('Select northern-most latitude (',f6.2,')')",utlat.lat1)
  label = widget_label(list_base,value=text,uname='SELECT_NLAT_TEXT')
  list = strarr(nlat)
  for j=0,nlat-1 do list[j] = string(format="(f6.2)",lats[j])
  list = widget_list(list_base,value=list,ysize=10,xsize=12,$
    uvalue=utlatptr,event_pro='select_lats_event',uname ='SELECT_NLAT')
  ilat1 = ixfind(lats,utlat.lat1,lats[1]-lats[0])
  widget_control,list,set_list_select=ilat1
;
; Cancel and plot buttons:
;
  button_base = widget_base(utlat_base,row=1,uvalue=stateptr)
  button = widget_button(button_base,value='CANCEL',$
    event_pro='cancel_utlat_event')
  button = widget_button(button_base,value='Make Ut vs Latitude Plots',$
    event_pro='plt_utlat_event',uvalue=utlatptr)
;
; Display help:
  button = widget_button(button_base,value='Help',uvalue=utlatptr,$
    event_pro='help_utlat_event')
;
; Realize tlb and hand off to xmanager:
;
  *stateptr = state
  *utlatptr = utlat
  widget_control,utlat_base,/realize
  xmanager,'Xutproc',utlat_base,/no_block
end
