pro pltutlat,stateptr,utlatptr
  utlat = *utlatptr
  state = *stateptr
  sfields = *state.sfields
  nfields = n_elements(sfields)
  f_units = strarr(nfields)
  f_units[*] = ""

  lats = *state.lats
  lons = *state.lons
  levs = *state.levs

  zplevs = *utlat.zplevs
  nzplev = n_elements(zplevs)
  print,'pltutlat: nzplev=',nzplev,' zplevs=' & print,zplevs

  slons = *utlat.slons
  nslon = n_elements(slons)
  print,'pltutlat: nslon=',nslon,' slons=' & print,slons

  ilat0 = ixfind_simple(lats,utlat.lat0)
  ilat1 = ixfind_simple(lats,utlat.lat1)
  ylats = lats[ilat0:ilat1]
  nlats = n_elements(ylats)
;
; Indices into mtimes of mtime_beg and mtime_end, and
; number of times to plot:
;
  mtimes = *state.mtimes
  ntimes_total = state.ntimes
  for i=0,ntimes_total-1 do begin
    if (array_equal(mtimes[*,i],state.mtime_beg)) then begin
      it0 = i
      break
    endif
  endfor
  for i=0,ntimes_total-1 do begin
    if (array_equal(mtimes[*,i],state.mtime_end)) then begin
      it1 = i
      break
    endif
  endfor
  ntime_plot = it1-it0+1
  mtime_plot = intarr(3,ntime_plot)
  for it=it0,it1 do mtime_plot[*,it-it0] = mtimes[*,it]
  for it=1,ntime_plot-1 do begin
    deltamin = mtime_to_mins(mtime_plot[*,it])-mtime_to_mins(mtime_plot[*,it-1])
    if deltamin ne 0 then break
  endfor
  print,format=$
    "('Reading ',i5,' times: ',i3,',',i3,',',i3,' to ',i3,',',i3,',',i3,' by ',i4)",$
    ntime_plot,mtime_plot[*,0],mtime_plot[*,ntime_plot-1],deltamin
;
; Allocate utlat array:
;
  futlat = dblarr(nlats,nslon,nzplev,ntime_plot,nfields)
  years = intarr(ntime_plot)    ; integer years
  decyears = fltarr(ntime_plot) ; decimal years
;
; Read from files:
;
  files = *state.files
  ifile0 = state.ifile_beg
  ifile1 = state.ifile_end
  itime0_plot = 0
  for ifile=ifile0,ifile1 do begin
    ncid = ncdf_open(files[ifile],/nowrite)

    id = ncdf_varid(ncid,'mtime')
    ncdf_varget,ncid,id,mtime_file
    ntime_file = n_elements(mtime_file)/3

    ncdf_attget,ncid,'missing_value',missing,/global

    itime0_file = 0 & itime1_file = ntime_file-1
    for i=0,ntime_file-1 do begin
      if (array_equal(mtime_file[*,i],state.mtime_beg)) then itime0_file=i
      if (array_equal(mtime_file[*,i],state.mtime_end)) then itime1_file=i
    endfor
    ntime_file = itime1_file-itime0_file+1
    itime1_plot = itime0_plot+ntime_file-1

    print,format=$
      "(/,'File ',a,' (',i3,' of ',i3,')')",$
      file_basename(files[ifile]),ifile+1,ifile1-ifile0+1
    print,format=$
      "('Reading ',i4,' mtimes: ',3(i3,','),' to ',3(i3,','),' by ',i5,')')",$
      ntime_file,mtime_plot[*,itime0_plot],mtime_plot[*,itime1_plot],deltamin
;
; Get years:
    id = ncdf_varid(ncid,'year') 
    if (id eq -1) then print,'>>> WARNING: could not find year variable'
    ncdf_varget,ncid,id,var
    years[itime0_plot:itime1_plot] = fix(var[itime0_file:itime1_file])
;
; Loop over variables in current file:
    finfo = ncdf_inquire(ncid)
    found = intarr(nfields) & found[*] = 0
    for ivar=0,finfo.nvars-1 do begin
      vinfo = ncdf_varinq(ncid,ivar)
;
; Check for selected field: 
      for ifld=0,nfields-1 do begin
        if (vinfo.name eq sfields[ifld]) then begin
          for iatt=0,vinfo.natts-1 do begin
            attname = ncdf_attname(ncid,ivar,iatt)
            if (attname eq "units") then begin
              ncdf_attget,ncid,ivar,attname,units
              f_units[ifld]=string(units)
            endif
          endfor
          found[ifld] = 1
          ncdf_varget,ncid,ivar,var ; (lon,lat,lev,time)
;
; Location (lat,lon) loop:
; futlat = dblarr(nlats,nslon,nzplev,ntime_plot,nfields)
;
          for k=0,nzplev-1 do begin
            klev = ixfind_simple(levs,zplevs[k])
            for i=0,nslon-1 do begin
              ilon = ixfind_simple(lons,slons[i])
              futlat[*,i,k,itime0_plot:itime1_plot,ifld] = $
                var[ilon,ilat0:ilat1,klev,itime0_file:itime1_file]
            endfor ; i=0,nslon-1
          endfor ; k=0,nzplev-1

          print,format=$
            "('Read field ',a8,' min,max=',2e12.4)",$
            sfields[ifld],min(futlat[*,*,*,itime0_plot:itime1_plot,ifld]),$
                          max(futlat[*,*,*,itime0_plot:itime1_plot,ifld])

        endif ; is selected field
      endfor ; ifld=0,nfields-1
    endfor ; ivar=0,finfo.nvars-1
;
; Should not be necessary to check for this, but you never know:
    for ivar=0,nfields-1 do begin
      if (found[ivar] eq 0) then print,format=$
        "('(Field ',a,' was not found)')",fields[ivar]
    endfor
    itime0_plot = itime0_plot+ntime_file
    ncdf_close,ncid
  endfor ; ifile=ifile0,ifile1
;
; Insure consistent delta-time (minutes) between all histories.
; If a deltamin between 2 histories is zero (duplicate history),
; then the arrays are shifted to overwrite the 1st history of the
; duplicate pair, and ntimes is decremented.  Duplicate secondary
; histories can occur between the end of one file and the beginning
; of the next when the model is restarted.  If deltamin is inconsistent
; w/ deltamin0 and deltamin is non-zero, then this is a fatal
; (the history write frequency was apparently changed mid-run).
;
  dtimeloop:
  for i=1,ntime_plot-1 do begin
    deltamin = mtime_to_mins(mtime_plot[*,i])-mtime_to_mins(mtime_plot[*,i-1])
    if (deltamin eq 0) then begin
      print,format=$
        "(/,'Warning: duplicate history: i=',i3,',mtime[*,i]=',3i4,' mtime[*,i-1]=',3i4)",$
        i,mtime_plot[*,i],mtime_plot[*,i-1]
      print,format=$
        "('(Duplicate histories are corrected by shifting arrays)')"
      mtime_plot[*,i:ntime_plot-1] = shift(mtime_plot[*,i:ntime_plot-1],0,-1)
      years[i:ntime_plot-1] = shift(years[i:ntime_plot-1],-1)
      decyears[i:ntime_plot-1] = shift(decyears[i:ntime_plot-1],-1)
;
; The shift function does not work if there are any degenerate dimensions
;   (i.e., dimensioned 1). Since nfields, nlons, and nzplevs can be degenerate
;   (only one chosen by the user), loop over these to avoid problems
;   w/ shift function:
; futlat = dblarr(nlats,nslon,nzplev,ntime_plot,nfields)
;
      for ifld=0,nfields-1 do begin
        for k=0,nzplev-1 do begin
          for i=0,nslon-1 do begin
            futlat[*,i,k,i:ntime_plot-1,ifld] = $
              shift(futlat[*,i,k,i:ntime_plot-1,ifld],0,0,-1)
          endfor
        endfor
      endfor
      ntime_plot = ntime_plot-1
      goto,dtimeloop ; check for another one
    endif
  endfor
;
; Set output device (as of 12/4/07 only PS and X are implemented,
; (but see non-gui utproc.pro for jpg)
;
  print,format="(/,'Contouring ut vs latitude:')"
; set_output_device,stateptr
;
; Number of contour levels, and load default color table:
  nlevels = 12 ; number of contour levels
  loadct,33,ncolors=nlevels,bottom=3 ; Blue-Red

  iframe = 0
  ijpg = 0
  ps = 0 & if (state.device eq 'PS') then ps = 1
  jpg = 0 & if (state.device eq 'JPG') then jpg = 1
;
; Field plot loop:
; futlat = dblarr(nlats,nslon,nzplev,ntime_plot,nfields)
;
for ifld=0,nfields-1 do begin
  if (found[ifld] eq 0) then begin
    print,'Skipping field ',fields[ifld],' because it was not found.'
    continue ; field was not found
  endif
  utlat = dblarr(ntime_plot,nlats)
  for k=0,nzplev-1 do begin
    for i=0,nslon-1 do begin
      for j=0,nlats-1 do begin
        for it=0,ntime_plot-1 do begin
          utlat[it,j] = futlat[j,i,k,it,ifld]
        endfor
      endfor
      funits = f_units[ifld]
      if (f_units[ifld] eq 'CM') then begin
        utlat = utlat/1.e5          ; cm to km (e.g., Z)
        funits = 'KM'
      endif
      if (f_units[ifld] eq 'CM/S') then begin
        utlat = utlat/100.
        funits = 'M/S'
      endif
;
; Main title and y-axis title:
;
      title = sfields[ifld]+' ('+funits+'):  ZP level = '+ $
        string(format="(f6.2)",zplevs[k])+' Longitude = '+ $
        string(format="(f7.2)",slons[i])
      ytitle = "Latitude"
;
; Use IDL procedures timegen, julday, and label_date
; (setting nxticks does not appear to work w/ label_date)
;
      time = timeaxis(years[0:ntime_plot-1],mtime_plot[*,0:ntime_plot-1],$
        deltamin,xtitle,nxticks)
      filelabel = "Files " + file_basename(files[ifile0]) + " to " + $
                             file_basename(files[ifile1])
;
; Contour:
      utcontour,utlat,time,ylats,slons[i],nlevels,xtitle,ytitle,$
        title,filelabel,missing,jpg=jpg,ps=ps
      if (title ne '') then begin
        iframe = iframe+1

        if (state.device eq 'PS') then begin
          print,format="('Frame ',i4,': ',a,' (ps file ',a,')')",$
            iframe,title,strcompress(state.ps_outfile,/remove_all)
        endif else if (state.device eq 'X') then begin
          print,format="('Frame ',i4,': ',a,' (X display)')",iframe,title
        endif else begin
          print,format="('Frame ',i4,': ',a,' (unknown output device)')",$
            iframe,title
        endelse

      endif
    endfor ; i=0,nslon-1
  endfor ; k=0,nzplev-1
endfor ; ifld=0,nfields-1
end
