function mkclevels,fmin,fmax,cmin,cmax,cint
;
; Set up contour min,max,interval. Args fmin,fmax are input,
; args cmin,cmax,cint are intent inout.
;
;print,'Enter mkclevels: fmin,max=',fmin,fmax,' cmin,max=',cmin,cmax,$
;  ' cint=',cint
;
; Check for valid fmin,fmax (e.g., all data missing)
;
if fmin ge fmax then begin
  print,'>>> WARNING mkclevels: fmin ge fmax: fmin=',fmin,' fmax=',fmax
  return,[0.]
endif
;
; Default number of levels:
;
;nlevdef = 12
nlevdef = 10
;
; If cmin >= cmax and cint <= 0, do not use cmin,cmax, or cint:
;
if cmin ge cmax and cint le 0. then begin
  nlevels = nlevdef
  levels = fltarr(nlevels)
  conint = (fmax-fmin) / (nlevels-1)
  for i=0,nlevels-1 do levels(i) = fmin+i*conint
  if cmin eq cmax then begin
    cmin=fmin & cmax=fmax
  endif
  cint = conint
; print,'mkclevels: cmin,max,int=',cmin,cmax,cint,' levels=' & print,levels
  return,levels
endif
;
; If cmin < cmax but cint <= 0, then use cmin and cmax, but not cint:
;
if cmin lt cmax and cint le 0. then begin
  nlevels = nlevdef
  levels = fltarr(nlevels)
  cint = (cmax-cmin) / (nlevels-1)
  for i=0,nlevels-1 do levels(i) = cmin+i*cint
; print,'mkclevels: cmin,max,int=',cmin,cmax,cint,' levels=' & print,levels
  return,levels
endif
;
; If cmin >= cmax and cint > 0, then use cint but not cmin or cmax:
;
if cmin ge cmax and cint gt 0. then begin
  nlevels = fix((fmax-fmin)/cint+.5) ; +.5 is to get nearest int
  if nlevels gt 59 then begin
    cintold = cint
    while nlevels gt 59 do begin
      cint = cint+.01*cint
      nlevels = fix((fmax-fmin)/cint+.5) ; +.5 is to get nearest int
    end
    print,'WARNING: had to increase cint from ',cintold,' to ',cint,$
      ' to avoid > 60 levels'
  endif
  if cmin+float(nlevels)*cint le cmax then nlevels = nlevels+1
  levels = fltarr(nlevels)
  for i=0,nlevels-1 do levels(i) = fmin+i*cint
  if cmin eq cmax then begin
    cmin = fmin & cmax = fmax
  endif
; print,'mkclevels: cmin,max,int=',cmin,cmax,cint,' levels=' & print,levels
  return,levels
endif
;
; If cmin < cmax and cint > 0, then use cmin, cmax, and cint:
;
if cmin lt cmax and cint gt 0. then begin
  nlevels = fix((cmax-cmin)/cint+.5) ; +.5 is to get nearest int
  if nlevels gt 59 then begin
    cintold = cint
    while nlevels gt 59 do begin
      cint = cint+.01*cint
      nlevels = fix((fmax-fmin)/cint+.5) ; +.5 is to get nearest int
    end
    print,'WARNING: had to increase cint from ',cintold,' to ',cint,$
      ' to avoid > 60 levels: nlevels now =',nlevels
  endif
  if cmin+float(nlevels)*cint le cmax then nlevels = nlevels+1
  levels = fltarr(nlevels)
  for i=0,nlevels-1 do levels(i) = cmin+i*cint
; print,'mkclevels: cmin,max,int=',cmin,cmax,cint,' levels=' & print,levels
  return,levels
endif
end

