;-----------------------------------------------------------------------
pro update_field,sfield,stateptr
  state = *stateptr
    case sfield.model of
      'TGCM': begin
        fields_tgcm = *state.fields_tgcm
        for ii=0,n_elements(fields_tgcm)-1 do begin
          if (fields_tgcm[ii].name eq sfield.name) then begin
            fields_tgcm[ii].cmin = sfield.cmin
            fields_tgcm[ii].cmax = sfield.cmax
            fields_tgcm[ii].cint = sfield.cint
          endif
        endfor
        *state.fields_tgcm = fields_tgcm
      end
      'MSIS': begin
        fields_msis = *state.fields_msis
        for ii=0,n_elements(fields_msis)-1 do begin
          if (fields_msis[ii].name eq sfield.name) then begin
            fields_msis[ii].cmin = sfield.cmin
            fields_msis[ii].cmax = sfield.cmax
            fields_msis[ii].cint = sfield.cint
          endif
        endfor
        *state.fields_msis = fields_msis
      end
    endcase
  *stateptr = state
end
;-----------------------------------------------------------------------
pro restore_previous_event,event
  widget_control,event.id,get_uvalue=prev_values
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  fields = *state.sfields
  nf = n_elements(fields)
  for i=0,nf-1 do begin
    print,'restore_previous: Field ',fields[i].name,' previous cmin,cmax,cint=',$
      prev_values[0,i],prev_values[1,i],prev_values[2,i]
  endfor
  for i=0,nf-1 do begin
    fields[i].cmin = prev_values[0,i]
    fields[i].cmax = prev_values[1,i]
    fields[i].cint = prev_values[2,i]
  endfor
  options_table = widget_info(event.top,find_by_uname='OPTIONS_TABLE')
  widget_control,options_table,set_value=prev_values
  *state.sfields = fields
  *stateptr = state
end
;-----------------------------------------------------------------------
pro restore_defaults_event,event
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  sfields = *state.sfields
  nf = n_elements(sfields)
  for i=0,nf-1 do begin
    sfields[i].cmin = 0.
    sfields[i].cmax = 0.
    sfields[i].cint = 0.
  endfor
  values = fltarr(3,nf) & values[*,*] = 0.
  options_table = widget_info(event.top,find_by_uname='OPTIONS_TABLE')
  widget_control,options_table,set_value=values
  *state.sfields = sfields
  *stateptr = state
  for i=0,nf-1 do begin
    update_field,sfields[i],stateptr
  endfor
  print,'Restored default cmin=cmax=cint=0.'
end
;-----------------------------------------------------------------------
pro close_event,event
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  widget_control,event.top,/destroy
  state.opts_tlb = 0
  *stateptr = state
end
;-----------------------------------------------------------------------
pro opts_table_event,event
  widget_control,event.top,get_uvalue=stateptr
  state = *stateptr
  widget_control,event.id,get_value=opt_value,/use_table_select
  if (event.type eq 8) then begin
    print,'>>> Invalid entry in options table: option values must be numeric'
    return
  endif
  sfields = *state.sfields
  case event.x of
    0: begin
      sfields[event.y].cmin = opt_value
      print,'Set contour minimum of field ',sfields[event.y].name,' to ',opt_value
    end
    1: begin
      sfields[event.y].cmax = opt_value
      print,'Set contour maximum of field ',sfields[event.y].name,' to ',opt_value
    end
    2: begin
      sfields[event.y].cint = opt_value
      print,'Set contour interval of field ',sfields[event.y].name,' to ',opt_value
    end
  endcase
  *state.sfields = sfields
  *stateptr = state
  field = sfields[event.y]
  update_field,field,stateptr
end
;-----------------------------------------------------------------------
pro options_table,stateptr
  state = *stateptr
;
; Top level base for options table and commands:
;
  opts_tlb = widget_base(title='Options Table',row=2,$
    uname='OPTIONS_TABLE_BASE',uvalue=stateptr)
  state.opts_tlb = opts_tlb
  
  sfields = *state.sfields

; nf = n_elements(sfields)
; for i=0,nf-1 do begin
;   print,'options_table: Field ',sfields[i].name,' i=',i,' cmin,cmax,cint=',$
;     sfields[i].cmin,',',sfields[i].cmax,',',sfields[i].cint
; endfor

  nfields = n_elements(sfields)
  sfield_names = sfields.name
  for i=0,nfields-1 do begin
    if sfields[i].model eq 'MSIS' then sfield_names[i] = sfield_names[i]+' (MSIS)'
    if sfields[i].model eq 'HWM'  then sfield_names[i] = sfield_names[i]+' (HWM)'
    if sfields[i].model eq 'IRI'  then sfield_names[i] = sfield_names[i]+' (IRI)'
  endfor
  if (nfields eq 1) then begin
    name = sfield_names
    sfield_names = strarr(1)
    sfield_names[0] = name
  endif

  sfield_cmin = sfields.cmin
; help,sfield_cmin & print,'sfield_cmin=',sfield_cmin
  sfield_cmax = sfields.cmax
  sfield_cint = sfields.cint
;
; Options are column labels:
;
  opt_labels = ['Contour Minimum','Contour Maximum','Contour Interval']
  nopts = n_elements(opt_labels)
;
; Set table values from field structures:
;
  opt_table_values = fltarr(nopts,nfields)
  opt_table_values[0,*] = sfield_cmin
  opt_table_values[1,*] = sfield_cmax
  opt_table_values[2,*] = sfield_cint

; for i=0,nfields-1 do begin
;   print,'Options Table setup: Field ',sfield_names[i],' cmin,cmax,cint=',$
;     opt_table_values[0,i],opt_table_values[1,i],opt_table_values[2,i]
; endfor

  table = widget_table(opts_tlb,/editable,row_labels=sfield_names,ysize=nfields,$
    column_labels=opt_labels,column_widths=100,xsize=nopts,value=opt_table_values,$
    event_pro='opts_table_event',uname='OPTIONS_TABLE')

  controls_base = widget_base(opts_tlb,col=3)

  button = widget_button(controls_base,value='RESTORE PREVIOUS',uvalue=stateptr,$
    event_pro='restore_previous_event',uname='RESTORE_PREVIOUS')
  widget_control,button,set_uvalue=opt_table_values

  button = widget_button(controls_base,value='RESTORE DEFAULTS',uvalue=stateptr,$
    event_pro='restore_defaults_event',uname='RESTORE_DEFAULTS')
  button = widget_button(controls_base,value='CLOSE',uvalue=stateptr,$
    event_pro='close_event',uname='CLOSE')

  *stateptr = state
  widget_control,opts_tlb,/realize
  widget_control,opts_tlb,set_uvalue=stateptr
  xmanager,'Options Table',opts_tlb,/no_block
end
