 
      SUBROUTINE LEXWRT (lu,COMMENT, PNAME, IOF5, ARR, ITM, NAR, IX,
     +  MDAY1)
C
C  LEXWRT writes out the lexical read parameters from the GETNDCS job.
c   to unit lu
C
C   COMMENT = the comment about the parameter to follow
C   PNAME = the parameter name of the lexical read
C   IOF5 = the number of digits seen past the decimal point in the
C          format of F5.IOF5  (is generally 0, 1, or 2).
C   ITM(IX,NAR) = the mid-point time of the measurement (year,
C                 month/day, UThr/min, csec)
C   ARR = the array of the parameter in question
C   NAR = the number of points in the arrays ARR and ITM
C   IX = the first dimension of ITM (usually 4)
C   LEXADD = the number to be added to the day for the purposes of the
C            lexical write.  (If 0, the day of the lexical day is the
C            same as the day of the month.  Could also be arranged so
C            the lexical day starts at 1 or that the lexical day is
C            the day number of the year.)
! MDAY1 replaces LEXADD. MDAY1 is 1st model day to use. It is incremented
! according to itm(2,i)
C
      CHARACTER *(*) COMMENT,PNAME
      CHARACTER *80 ALINE
      DIMENSION ARR(NAR), ITM(IX,NAR)
      DIMENSION NDT(1000), NHR(1000), NMIN(1000), AREV(1000)
      DATA TMISS/-32766.9/
C
      IF (NAR .GT. 1000) THEN
       WRITE (6,"(1X,'LEXWRT:  Need to increase dimension to NAR=',I5)")
     |  NAR
       STOP
      ENDIF
      IF (IOF5 .LT. 0 .OR. IOF5 .GT. 2) THEN
       WRITE (6,"(1X,'LEXWRT:  Need to change IOF5 to 0,1,2.  =',I5)")
     |  IOF5
       STOP
      ENDIF
      NAREV = 0
      idayp = mod(itm(2,1),100)
      mday = mday1
      DO 100 I=1,NAR
         IF (ARR(I) .LT. TMISS) GO TO 100
           NAREV = NAREV + 1
           AREV(NAREV) = ARR(I)
           iday = mod(itm(2,i),100)
           if (iday.gt.idayp) then
!            write(6,"('lexwrt: iday=',i4,' idayp=',i4,
!    +         ' increment mday from ',i4,' to ',i4)") 
!    +         iday,idayp,mday,mday+(iday-idayp)  
             mday = mday+(iday-idayp)
           endif
           ndt(narev) = mday
           idayp = mod(itm(2,i),100)
           NHR(NAREV)=ITM(3,I)/100
C          NHR represents the UT hour
           NMIN(NAREV)=MOD(ITM(3,I),100)
C          NMIN represents the UT minute
  100 CONTINUE
      IF (NAREV .LE. 0) RETURN
      NC = LEN(COMMENT)
      WRITE(lu,"(A)") COMMENT(1:NC)
      NP = LEN(PNAME)
      WRITE(lu,"(1X,A)") PNAME(1:NP)
      NLIN = (NAREV+3) / 4
      NLAST = NAREV - (NLIN-1)*4
      NINTW = NAREV - NLAST
      NW =  NLAST * 16
      IF (IOF5 .EQ. 0) THEN
        IF (NLIN-1 .GT. 0) THEN
          DO 110 NL=1,NLIN-1
          I1 = 1 + (NL-1)*4
          I2 = I1 + 3
  110     WRITE(lu,"(1X,4(I3,',',2(I2,','),F5.0,',') )")
     |     (NDT(I),NHR(I),NMIN(I),AREV(I),I=I1,I2)
        ENDIF
        WRITE (ALINE,"(1X,4(I3,',',2(I2,','),F5.0,',') )")
     |     (NDT(I),NHR(I),NMIN(I),AREV(I),I=1+NINTW,NAREV)
      ENDIF
      IF (IOF5 .EQ. 1) THEN
        IF (NLIN-1 .GT. 0) THEN
          DO 120 NL=1,NLIN-1
          I1 = 1 + (NL-1)*4
          I2 = I1 + 3
  120     WRITE(lu,"(1X,4(I3,',',2(I2,','),F5.1,',') )")
     |     (NDT(I),NHR(I),NMIN(I),AREV(I),I=I1,I2)
        ENDIF
        WRITE (ALINE,"(1X,4(I3,',',2(I2,','),F5.1,',') )")
     |     (NDT(I),NHR(I),NMIN(I),AREV(I),I=1+NINTW,NAREV)
      ENDIF
      IF (IOF5 .EQ. 2) THEN
        IF (NLIN-1 .GT. 0) THEN
          DO 130 NL=1,NLIN-1
          I1 = 1 + (NL-1)*4
          I2 = I1 + 3
  130     WRITE(lu,"(1X,4(I3,',',2(I2,','),F5.2,',') )")
     |     (NDT(I),NHR(I),NMIN(I),AREV(I),I=I1,I2)
        ENDIF
        WRITE (ALINE,"(1X,4(I3,',',2(I2,','),F5.2,',') )")
     |     (NDT(I),NHR(I),NMIN(I),AREV(I),I=1+NINTW,NAREV)
      ENDIF
      WRITE (lu,"(A)") ALINE(1:NW)
      RETURN
      END
