c
      subroutine wrdata(x,n,flab,comm,lu)
c
c This writes a data statement of x(n) to unit lu, using
c flab as the variable name.
c (B.Foster 2/92)
c 1/18/93: Modified from ~/glbmeans/glbmeans.f to include comment field
c          comm, and to cover case where leftover=1
c
      dimension x(n)
      character*(*) flab,comm
      character*72 dline
c
      num = n/5
      leftover = mod(n,5)
      write(lu,"('C')")
c     write(lu,"('C Data statement for ',a)") flab
      if (lenstr(comm).gt.0) then
        write(lu,"('C ',a)") comm
        write(lu,"('C')")
      endif
      write(lu,"('      DATA ',a,' /')") flab
      do i=1,num
        i1 = (i-1)*5+1
        write(lu,"('     +',5(e12.5,','))") (x(ii),ii=i1,i1+4)
      enddo
      if (leftover.gt.0) then
        if (leftover.gt.1) then
          i1 = (num-1)*5+1
          write(lu,"('     +',5(e12.5,','))") (x(ii),ii=i1,i1+4)
          write(dline,"('(''     +'',',I1,'(E12.5,'',''),E12.5,
     +      ''/'')')") leftover-1
          write(lu,dline) (x(ii),ii=num*5+1,n)
        else
          write(lu,"('     +',e12.5,'/')") x(n)
        endif
      else
        i1 = (num-1)*5+1
        write(lu,"('     +',4(e12.5,','),e12.5,'/')")
     +    (x(ii),ii=i1,i1+4)
      endif
      return
      end
