
      subroutine getinp
      include 'rdgpi.h'
      character*8 dates(2)
      namelist/input/ mssfile,iyds,dates,sendcgm,sendlex,iflex,ifplt
      data dates /'        ','        '/ ! mo/da/yr (beg), mo/da/yr (end)
      data mssfile
     +  /'                                                        '/
      data ifplt/nflds*0/, iflex/nflds*0/
      integer,external :: rmcomments
!
! Remove comments from input file:
      write(6,"(/20('-'),' Input file: ',20('-'))")
      luin = rmcomments(5,';',1)
      write(6,"(18('-'),' End input file ',18('-'))")
c
      call clearstr(sendcgm)
      read(luin,input)
c
      lmss = lenstr(mssfile)
      if (lmss.le.0) then
        write(6,"('getinp: need mssfile (mss path to data file)')")
        stop 'mssfile'
      endif
c
      ldates0 = lenstr(dates(1))
      ldates1 = lenstr(dates(2))
      if (ldates0.gt.0.and.ldates1.gt.0) then
        read(dates(1),"(i2,1x,i2,1x,i2)") mo,id,iy
        iyd0 = idate2iyd(mo,id,iy)
        if (iyd0.le.0) then
          write(6,"('>>> bad beginning date=',a,
     +   ' (must be 8-char string mo/id/iy)')") dates(1)
          stop 'dates'
        endif
        read(dates(2),"(i2,1x,i2,1x,i2)") mo,id,iy
        iyd1 = idate2iyd(mo,id,iy)
        if (iyd1.le.0) then
          write(6,"('>>> bad ending date=',a,
     +   ' (must be char string mo/id/iy)')") dates(1)
          stop 'dates'
        endif
        iyds(1) = iyd0
        iyds(2) = iyd1
      endif
      if (iyds(1).le.0.and.iyds(2).le.0) then
        write(6,"('>>> must provide either dates or iyds')")
        stop 'iyd/dates'
      endif
c
      call iyd2date(iyds(1),imo,ida,iyr)
      idates(1,1) = imo
      idates(2,1) = ida
      idates(3,1) = iyr
      call iyd2date(iyds(2),imo,ida,iyr)
      idates(1,2) = imo
      idates(2,2) = ida
      idates(3,2) = iyr
c
      ipltline = 0
      do i=1,nflds
        if (ifplt(i).gt.0) ipltline = 1
      enddo
      iwrlex = 0
      do i=1,nflds
        if (iflex(i).gt.0) iwrlex = 1
      enddo
c
c Report to stdout:
c
      write(6,"(/72('-'))")
      write(6,"('Inputs for rdgpi (',a,' ',a,'):')") date(),clock()
      write(6,"('mssfile=',a)") mssfile(1:lmss)
      if (ldates0.gt.0.and.ldates1.gt.0) then
        write(6,"('dates ',a,', ',a)") dates(1)(1:ldates0),
     +    dates(2)(1:ldates1)
        write(6,"('  (iyds=',i5,', ',i5,')')") iyds
      else
        write(6,"('iyds=',i5,', ',i5)") iyds
        write(6,"('  (dates ',i2,'/',i2,'/',i2,' to ',
     +    i2,'/',i2,'/',i2,')')") idates
      endif
      write(6,"('ifplt = ',10i3)") ifplt
      if (lenstr(sendcgm).gt.0) write(6,"('sendcgm = ',a)")
     +  sendcgm(1:lenstr(sendcgm))
      write(6,"('iflex = ',10i3)") iflex
      if (lenstr(sendlex).gt.0) write(6,"('sendlex = ',a)")
     +  sendlex(1:lenstr(sendlex))
      write(6,"(72('-')/)")
      return
      end
!-------------------------------------------------------------------
      integer function rmcomments(lu,comcharin,echo)
!
! Read input lines from unit lu. If current line contains the comment
!   character comcharin, strip the line from position of comchar to end,
!   and write any remaining line to a new unit. If no comment in current 
!   line, write entire line to new unit. 
! Return new unit, rewound (e.g., ready to be read by namelist).
! If echo > 0, echo output lines to stdout.
! If comcharin is ' ', then default comment char is ';'
!
! Args:
      integer,intent(in) :: lu,echo
      character(len=1),intent(in) :: comcharin
! Local:
      character(len=1) :: comchar
      logical isopen
      integer :: ios,compos,nline
      character*80 line
      integer,external :: nextlu
!
      if (lu <= 0) then
        write(6,"('>>> rmcomments: bad input lu=',i5)") lu
        rmcomments = -1
        return
      endif
      if (len_trim(comcharin) > 0) then
        comchar = comcharin
      else
        comchar = ';'
        write(6,"('rmcomments: using default semicolon as ',
     +    'comment character.')")
      endif
      inquire(unit=lu,opened=isopen)
      if (.not.isopen) then
        open(unit=lu,iostat=ios)
        if (ios /= 0) then
          write(6,"('>>> WARNING rmcomments: error openeing input',
     +      ' file with unit lu=',i2,' ios=',i5)") lu,ios
          rmcomments = -1
          return
        endif
      endif
      rmcomments = nextlu()
      rewind lu
      nline = 0
      read_loop: do
        line = ' '
        read(lu,"(a)",iostat=ios) line
        if (ios > 0) then
          write(6,"('>>> rmcomments: error reading from input',
     +      ' unit lu=',i3,' at line ',i5)") lu,nline
          return
        endif
        if (ios < 0) exit read_loop	! eof
        nline = nline+1
        compos = index(line,comchar)
        if (compos == 0) then
          write(rmcomments,"(a)") line
          if (echo > 0) write(6,"(a)") line(1:len_trim(line))
        else
          if (compos > 1) then
            if (len_trim(line(1:compos-1)) > 0) then
              write(rmcomments,"(a)") line(1:compos-1)
              if (echo > 0) write(6,"(a)") line(1:compos-1)
            endif
          endif
        endif
      enddo read_loop  
      rewind rmcomments
      return      
      end function rmcomments
