c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      subroutine iyd2date(iyd,imo,ida,iyr)
c
c Convert given iyd (yyddd) to date, returning month, day, and
c   2-digit year in imo,ida,iyr:
c
      dimension ndmon(12)
c                 J  F  M  A  M  J  J  A  S  O  N  D
      data ndmon/31,28,31,30,31,30,31,31,30,31,30,31/
c
      imo = 0
      ida = 0
      iyr = 0
      if (ichiyd(iyd).ne.0) then
        write(6,"('iyd2date: bad iyd=',i5)") iyd
        return
      endif
      iyr = iyd/1000
      ndmon(2) = 28
      if (mod(iyr,4).eq.0) ndmon(2) = 29
      iday = iyd-iyr*1000
      id = 0
      do m=1,12
        id = id+ndmon(m)
        if (id.eq.iday) then
          id = ndmon(m)
          goto 100
        endif
        if (id.gt.iday) then
          id = ndmon(m)-id+iday
          goto 100
        endif
      enddo
      write(6,"('>>> iyd2date: could not find date for iyd=',i5)") iyd
      imo = 0
      ida = 0
      iyr = 0
      return
 100  continue
      imo = m
      ida = id
      return
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      function idate2iyd(imo,ida,iyr)
      dimension ndmon(12)
c                 J  F  M  A  M  J  J  A  S  O  N  D
      data ndmon/31,28,31,30,31,30,31,31,30,31,30,31/
c
c given iyr,imo,ida, convert to iyd (yyddd):
c
      if (ichdate(imo,ida,iyr).ne.0) then
        write(6,"('>>> idate2iyd: bad idate iyr,imo,ida=',3i3)")
     +    iyr,imo,ida
        idate2iyd = 0
        return
      endif
      ndmon(2) = 28
      if (mod(iyr,4).eq.0) ndmon(2) = 29
      iday = 0
      do i=1,imo-1
        iday = iday+ndmon(i)
      enddo
      idate2iyd = iyr*1000+iday+ida
      return
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      subroutine inciyd(iyd,ndays)
c
c Increment iyd (yyddd) by ndays (ndays may be +/-):
c
      if (ndays.eq.0) then
        write(6,"('>>> inciyd: ndays=',i2,' -- returning')") ndays
        return
      endif
      if (ichiyd(iyd).ne.0) then
        write(6,"('>>> inciyd: bad iyd=',i6)") iyd
        return
      endif
      leap = 0
      iyr = iyd/1000
      if (mod(iyr,4).eq.0) leap = 1
      iday = iyd-iyr*1000
      inc = 1
      if (ndays.lt.0) inc = -1
      do i=1,abs(ndays)
        iday = iday+inc
        if (leap.le.0.and.iday.gt.365) then
          iday = 1
          iyr = iyr+1
        endif
        if (leap.gt.0.and.iday.gt.366) then
          iday = 1
          iyr = iyr+1
        endif
        if (iday.lt.1) then
          iyr = iyr-1
          if (mod(iyr,4).eq.0) then
            iday = 366
          else
            iday = 365
          endif
        endif
      enddo
      iyd = iyr*1000+iday
      return
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      function iyddif(iyd0,iyd1)
      dimension ndmon(12)
c                 J  F  M  A  M  J  J  A  S  O  N  D
      data ndmon/31,28,31,30,31,30,31,31,30,31,30,31/
c
c Return number of days from iyd0 to iyd1:
c
      if (iyd0.eq.iyd1) then
        iyddif = 0
        return
      endif
      if (iyd0.gt.iyd1) then
        write(6,"('iyddif: iyd0 > iyd1 (iyd0,1=',2i6,')')")
     +    iyd0,iyd1
        iyddif = -1
        return 
      endif
      if (ichiyd(iyd0).ne.0) then
        write(6,"('>>> iyddif: bad iyd0=',i6)") iyd0
        iyddif = -1
        return
      endif
      if (ichiyd(iyd1).ne.0) then
        write(6,"('>>> iyddif: bad iyd1=',i6)") iyd1
        iyddif = -1
        return
      endif
      iyr0 = iyd0/1000
      iyr1 = iyd1/1000
      iyddif = 0
      if (iyr1.gt.iyr0) then
        do i=iyr0,iyr1-1
          if (mod(i,4).ne.0) then
            iyddif = iyddif+365
          else
            iyddif = iyddif+366
          endif
        enddo
      endif
      ida0 = iyd0-iyr0*1000
      ida1 = iyd1-iyr1*1000
      iyddif = iyddif+(ida1-ida0)
      return
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      function ichdate(im,id,iy)
      dimension ndmon(12)
c                 J  F  M  A  M  J  J  A  S  O  N  D
      data ndmon/31,28,31,30,31,30,31,31,30,31,30,31/
c
c Check validity of date im/id/iy
c
      ichdate = 0
      if (im.lt.1.or.im.gt.12) then
        write(6,"('>>> ichdate: bad month=',i3)") im
        ichdate = 1
        return
      endif
      if (iy.lt.1.or.iy.gt.1999) then
        write(6,"('>>> ichdate: bad year=',i3)") iy
        ichdate = 1
        return
      endif
      ndmon(2) = 28
      if (mod(iy,4).eq.0) ndmon(2) = 29
      if (id.lt.1.or.id.gt.ndmon(im)) then
        write(6 ,"('>>> ichdate: bad day=',i4,' (month=',i2,')')")
     +    id,im
        ichdate = 1
        return
      endif
      return
      end 
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
      function ichiyd(iyd)
      dimension ndmon(12)
c                 J  F  M  A  M  J  J  A  S  O  N  D
      data ndmon/31,28,31,30,31,30,31,31,30,31,30,31/
c
c Check validity of yyddd iyd:
c
      ichiyd = 0
      iyr = iyd/1000
      if (iyr.lt.1.or.iyr.gt.99) then
        write(6,"('>>> ichiyd: bad year=',i4)") iyr
        ichiyd = 1
        return
      endif
      iday = iyd-iyr*1000
      leap = 0
      ndmon(2) = 28
      if (mod(iyr,4).eq.0) then
        leap = 1 
        ndmon(2) = 29
      endif
      if (iday.lt.1.or.(leap.le.0.and.iday.gt.365).or.
     +                 (leap.gt.0.and.iday.gt.366)) then
        write(6,"('>>> ichiyd: bad iday=',i5,' (iyr=',i2,')')") 
     +    iday,iyr
        ichiyd = 1
        return
      endif
      return
      end
