c
c Global header file for flxproc:
c
      parameter
     + (imx=73,			! number of longitudes 
     +  glon1=-180., 		! first geographic longitude
     +  dlon=5.,		! delta longitude (deg)
     +  jmx=36,			! number of latitudes
     +  glat1=-87.5,		! first geographic latitude
     +  dlat=5.,		! delta latitude (deg)		
     +  mxflds=34,		! max number of fields available on gcm hist
     +  spval=1.e36,		! special value (float)
     +  ispval=999999,		! special value (int)
     +  zmflag=999.)		! zonal mean flag
c
c Geographic grid (vertical dimension determined by rdtgcm, including
c kmx, zp1, and dzp):
c
      pointer(pgcmzp,gcmzp(1)), (pgcmpmb,gcmpmb(1))
      common/grid/ 
     +  gcmlon(imx),		! geographic longitudes (deg)
     +  gcmlat(jmx), 		! geographic latitudes (deg)
     +  kmx,			! number of vertical pressure levels
     +  zp1,			! first (lowest) pressure level
     +  dzp,			! delta zp
     +  p0,			! standard pressure (for t21 or maccm)
     +  pgcmzp,			! pointer to 1d array of pressure levels
     +  pgcmpmb			! pointer to 1d array of millibar pressures
c
c Fields from history (returned by rdtgcm), and related flags:
c
      pointer(pfhist,fhist(1))
      character*8 flab8
      character*56 flab
      common/flds/
     +  pfhist,			! pointer to fields from current history
				!  (imx,kmx,jmx,nfhist) returned by rdtgcm 
     +  nfhist,			! number of fields in current history
				!  also returned by rdtgcm, max mxfhist
     +  ixfhist(mxflds),	! indices to each field in fhist, 
				!  0 if not defined (returned by rdtgcm)
     +  ifproc(mxflds),		! fields to be processed at current model time
     +  logplt(mxflds),        ! plot log10 or do not
     +  flab8(mxflds)		! 8-char field labels
c
c Field indices: 
c   The first mxfhist fields (ixt->ixn2) are from the history, fields
c   mxfhist+1->mxfproc are derived in the processor from the history fields.
c (This common also explicitly in setflab.f)
c
c (note: NEW FIELDS SHOULD BE ADDED IN BEFORE IXE6300, i.e., emissions
c   fields are always last because they are read separately (iemis in 
c   namelist) and added onto the end of ifields)
c
      common/findex/
     +  ixt    ,ixu    ,ixv    ,ixo2   ,ixox   ,ixn4s  ,ixnoz  ,ixco ,
     +  ixco2  ,ixh2o  ,ixh2   ,ixhox  ,ixop   ,ixch4  ,ixo21d ,ixno2,
     +  ixno   ,ixo3   ,ixo1   ,ixoh   ,ixho2  ,ixh    ,ixn2d  ,ixti ,
     +  ixte   ,ixne   ,ixo2p  ,ixw    ,ixz    ,ixepot ,ixui   ,ixvi ,
     +  ixwi   ,ixn2
      integer ixtgcm(mxflds)
      equivalence (ixtgcm,ixt)
c
c User input:
c ifields(mxfproc) = fields requested by user
c (these are read in both sut and mut code)
c
      parameter(mxhvols=50,mxtms=241)
      character*32 histvols
      character*152 sendcgm,senddat
      common/inp_hist/
     +  histvols(mxhvols),	! history volumes (mss paths)
     +  nhvols,			! number of volumes given by user
     +  ivol,			! index to vol with current history
     +  mtimes(3,mxtms),	! model times (day,hr,min)
     +  ntms,			! number of model times given by user
     +  ifields(mxflds)		! fields requested by user
c
      common/inp_plt/
     +  icolor,			! color fill contours
     +  ibox_clabs,		! box contour line labels
     +  sendcgm,		! path to which cgm file is to be rcp'd
     +  senddat,		! path to which ascii data file is to be rcp'd
     +  ipltlat,		! make lat slices flag
     +  flats(jmx),		! selected latitudes for lat slices
     +  flat_zprange(2,jmx),	! zp range for y-axes of lat slices
     +  ilat_log10,		! log10 flag for lat slices
     +  ipltlon,		! make lon slices flag
     +  flons(imx),		! selected longitudes for lon slices
     +  flon_zprange(2,imx),	! zp range for y-axes of lon slices
     +  ilon_log10,		! log10 flag for lon slices
     +  iden,ionvel,modelhts
c
c Other:
c
      logical isdyn,istimes,issech
      character*80 tmpdir
      character*8 model
      integer gkswid
      common/msc/
     +  luhist,			! fortran logical unit for histories
     +  gkswid,			! gks workstation id (used in mkrgb in plt.a)
     +  isdyn,			! logical true if is dynamo history
     +  istimes,		! logical true if is timesgcm history
     +  issech,			! logical true if is a secondary history
     +  tmpdir,			! temporary dir to store history files 
     +  ut,			! ut at current history (from mtimes(3,it))
     +  model,			! model string (tigcm, tiegcm, or time-gcm)
     +  iframe,			! current frame number
     +  ncgmwid,		! ncgm workstation id (hlu package)
     +  iyd,			! yyddd of current history (emiss only)
     +  f107a,			! f10.7a flux of current history (emiss only)
     +  f107d 			! f10.7d flux of current history (emiss only)
c
c Coupled parameters:
c
      pointer (pcplzp,cplzp(1))
      common/cpl/
     +  ncplzp,			! total number of coupled levels for plots
     +  pcplzp,			! pointer to coupled levels (zp)
     +  ixfcpl(mxflds)		! indices to coupled fields (0 if not cpld)
				! if ixfcpl(ip) > 0, then it is index to ccmf
c
c End main header file for flxproc
c
