c
      subroutine getinp
      include "flxproc.h"
      include "ccm.h"
      namelist/input_sut/ histvols,mtimes,ifields,ccmlsd,icolor,
     +  ibox_clabs,ipltlat,flats,flat_zprange,ilat_log10,iden,ionvel,
     +  sendcgm,modelhts,ipltlon,flons,flon_zprange,ilon_log10
c
      read(5,input_sut,end=900)
c
c History volumes:
c
      nhvols = 0
      do i=1,mxhvols
        if (lenstr(histvols(i)).gt.0) nhvols = nhvols+1
      enddo
      if (nhvols.le.0) then
        write(6,"(/72('-'))")
        write(6,"('ERROR: you must provide at least one history ',
     +    'volume name mss path')")
        write(6,"('For example:')")
        write(6,"(' histvols = ''/ROBLE/RGR95/VOLNAME''')")
        write(6,"(72('-')/)")
        stop 'histvols'
      endif
      if (nhvols.gt.mxhvols) then
        write(6,"(/72('-'))")
        write(6,"('WARNING: too many history volumes nhvols=',i4)")
     +    nhvols
        nhvols = mxhvols
        write(6,"('Will use only the first ',i4,' volumes')") nhvols
        write(6,"(72('-')/)")
      endif
c
c Model times:
c
      ntms = 0
      do it=1,mxtms
        do i=1,3
          if (mtimes(i,it).ne.ispval) ntms = ntms+1
        enddo
      enddo
      if (mod(ntms,3).ne.0) then
        write(6,"(/72('-'))")
        write(6,"('ERROR: model times (mtimes) must be in integer ',
     +    'triplets (day,hour,minute)')")
        write(6,"('i.e., mod(ntms,3) must = 0')")
        write(6,"('Program read ',i4,' values for ntms')") ntms
        write(6,"(72('-')/)")
        stop 'mtimes'
      endif
      ntms = ntms/3
c
c Field flags:
c
      do ip=1,mxflds
        ixfhist(ip) = ifields(ip)
      enddo
c
c Check latitude slice zprange(s):
c
      if (ipltlat.gt.0) then
        nzprange = 0
        do j=1,jmx
          if (flat_zprange(1,j).ne.spval) nzprange = nzprange+1 
          if (flat_zprange(2,j).ne.spval) nzprange = nzprange+1 
        enddo
        if (nzprange.gt.0) then
          if (mod(nzprange,2).ne.0) then
            write(6,"(/'>>> flat_zprange must be *pairs* of floats: ',
     +        'I got ',i2,' values.')") nzprange
            stop 'flat_zprange'
          endif
          nzprange = nzprange/2
          do i=1,nzprange
            if (flat_zprange(1,i).ge.flat_zprange(2,i)) then
              write(6,"('>>> bad flat_zprange = ',2f9.3,' -- skipping ',
     +          'this range')")
              flat_zprange(1,i) = spval
              flat_zprange(2,i) = spval
              nzprange = nzprange-1
            endif
          enddo
          if (nzprange.le.0) then
            write(6,"('>>> no valid zpranges read -- default to ',
     +        'model range')")
            flat_zprange(1,1) = 99.
            flat_zprange(2,1) = 99.
            nzprange = 1
          endif
        else
          flat_zprange(1,1) = 99.
          flat_zprange(2,1) = 99.
          nzprange = 1
        endif
c
c Check selected latitudes:
c
        nlats = 0
        do j=1,jmx
          if (flats(j).ne.spval) then
            if (flats(j).lt.-90..or.flats(j).gt.90.) then
              write(6,"('>>> bad flats=',f10.2,' -- skipping this ',
     +          'lat slice')") flats(j)
              flats(j) = spval
            endif
          else
            nlats = nlats+1
          endif
        enddo
      endif	! ipltlat.gt.0
c
c Check longitude slice zprange(s):
c
      if (ipltlon.gt.0) then
        nzprange = 0
        do j=1,jmx
          if (flon_zprange(1,j).ne.spval) nzprange = nzprange+1 
          if (flon_zprange(2,j).ne.spval) nzprange = nzprange+1 
        enddo
        if (nzprange.gt.0) then
          if (mod(nzprange,2).ne.0) then
            write(6,"(/'>>> flon_zprange must be *pairs* of floats: ',
     +        'I got ',i2,' values.')") nzprange
            stop 'flon_zprange'
          endif
          nzprange = nzprange/2
          do i=1,nzprange
            if (flon_zprange(1,i).ge.flon_zprange(2,i)) then
              write(6,"('>>> bad flon_zprange = ',2f9.3,' -- skipping ',
     +          'this range')")
              flon_zprange(1,i) = spval
              flon_zprange(2,i) = spval
              nzprange = nzprange-1
            endif
          enddo
          if (nzprange.le.0) then
            write(6,"('>>> no valid zpranges read -- default to ',
     +        'model range')")
            flon_zprange(1,1) = 99.
            flon_zprange(2,1) = 99.
            nzprange = 1
          endif
        else
          flon_zprange(1,1) = 99.
          flon_zprange(2,1) = 99.
          nzprange = 1
        endif
c
c Check selected longitudes:
c
        nlons = 0
        do i=1,imx
          if (flons(i).ne.spval) then
            if (flons(i).lt.-180..or.flons(i).gt.180.) then
              write(6,"('>>> bad flons=',f10.2,' -- skipping this ',
     +          'lat slice')") flons(i)
              flons(i) = spval
            endif
          else
            nlons = nlons+1
          endif
        enddo
      endif	! ipltlon.gt.0
c
      return
 900  continue
      write(6,"('>>> getinp encountered EOF on stdin')")
      stop 'eof'
      end
