!
      subroutine wrlab6(tlabs,toffset,tlabchsz,
     +                  blabs,boffset,blabchsz, vp, ihq)
      use plt,only: wrlab
      use input
      implicit none
!
! This routine crashes for unknown reason when outplt='ps', unless
! it is compiled w/ -G1 (see Makefile).
!
! Draw 3 top labels above the plot, and 3 bottom labels below the plot:
!
! Args:
      character(len=*),intent(in) :: tlabs(3), blabs(3)
      real,intent(in) :: tlabchsz(3), blabchsz(3), vp(4)
      real,intent(in) :: toffset,boffset
      integer,intent(in) :: ihq
!
! Locals:
      real :: space_inbetween=.04
      real :: xmid,toff,boff,space_between,fac
      real :: tlabsz(3),blabsz(3)
      integer :: i
!
      call pcsetc('FC','$')
      xmid = .5*(vp(1)+vp(2))
      toff = toffset*(vp(4)-vp(3))
      boff = boffset*(vp(4)-vp(3))
      space_between = space_inbetween*(vp(2)-vp(1))
      tlabsz = tlabchsz
      blabsz = blabchsz
!
! Three top labels:
!
      do i=1,3
        if (len_trim(tlabs(i)) > 0 .and.
     +      iwr_label(i) > 0)
     +    call wrlab(trim(tlabs(i)),xmid,vp(4)+toff+
     +      (3-i)*space_between,tlabsz(i), vp, ihq)
      enddo
!
! Three bottom labels:
!
      do i=1,3
        if (len_trim(blabs(i)) > 0 .and.
     +      iwr_label(i+3) > 0)
     +    call wrlab(trim(blabs(i)),xmid,vp(3)-boff-
     +      (i-1)*space_between,blabsz(i), vp, ihq)
      enddo
      return
      end subroutine wrlab6
