      real function gettime(lon,lat,precdays,iupdn)
      use proc
      use input
      implicit none
!
! Args:
      real,intent(in) :: lat, lon ! lat/lon point to get requested time
      integer,intent(in) :: iupdn ! flag for upleg (1) or downleg (2)
      integer,intent(in) :: precdays  ! number of days to precess sat track
!
! Locals:
      integer :: i,j
      real :: lt,ut
!
      if(lat .gt. latmax .or. lat .lt. latmin) then
        gettime = spval
      else
        if (iupdn == 1) then
!          lt = -12./pi*acos(lat/latmax)+loctime0
!     +         +  prec_rate/60.*precdays
          lt = -12./pi*acos(  (lat-0.5*(latmax+latmin))
     +                         /(0.5*(latmax-latmin))   )
     +          +  loctime0+prec_rate/60.*precdays
        else
!          lt = +12./pi*acos(lat/latmax)+loctime0
!     +         +  prec_rate/60.*precdays
          lt = +12./pi*acos(  (lat-0.5*(latmax+latmin))
     +                         /(0.5*(latmax-latmin))   )
     +          +  loctime0+prec_rate/60.*precdays
        endif
        gettime = lt - lon/15.
        if(gettime .lt.  0.) gettime = gettime + 24.
        if(gettime .gt. 24.) gettime = gettime - 24.
      endif
!
      return
      end function gettime
