!
      module hdr3rec
      implicit none
!
! New history header output format, starting with tgcm23:
! (s.a. /home/tgcm/tgcm23/hdr.h)
!
! This is a 3-record header, 64-bit integers
!   in record 1, chars in record 2, and 64-bit reals
!   in record 3. It is written with 3 fortran unformatted
!   binary write statements. The post-processor can
!   read these headers from either unicos/Cray or irix/SGI
!   platforms.
! Note 1st word of record 1 is < 0 to enable post-processor
!   to distinguish histories with this new header format.
!
! lheader: length of int and real records (words)
      integer,parameter :: lheader=512 
!
! Record 1 (64-bit ints):
      integer(kind=8) ::! Word
     |  nthhist,        ! 1     -nth hist on file (< 0 to flag post-proc)
     |  lenhdi,         ! 2     length of record 1 (# integer words)
     |  lenhdc,         ! 3     length of record 2 (# character words)
     |  lenhdr,         ! 4     length of record 3 (# real words)
     |  iteration,      ! 5     time iteration number
     |  ncalyear,       ! 6     calendar year of current history (e.g., 2001)
     |  ncalday,        ! 7     calendar day of current history (1-366)
     |  mday,           ! 8     model day of current history (0-366)
     |  mhour,          ! 9     model hour of current history (0-23)
     |  mmin,           ! 10    model minute of current history (0-59)
     |  mtime_start(3), ! 11-13 model start time this run (day,hr,min)
     |  mtime_stop(3),  ! 14-16 model stop time this run (day,hr,min)
     |  nfreq_hist(3),  ! 17-19 frequency of history writes this run
     |  nfreq_save(3),  ! 20-22 frequency of history file saves this run
     |  nstep_secs,     ! 23    time step (seconds)
     |  ndifhor,        ! 24    0/1 flag for horizontal diffusion
     |  nuivi,          ! 25    0/1 flag for ion velocities
     |  npower,         ! 26    0/1 flag for hemispheric power
     |  naurora,        ! 27    0/1 flag for aurora
     |  ndispose,       ! 28    0/1 flag for disposal of hist files to mss
     |  ntideann,       ! 29    0/1 flag for annual tides
     |  ntide3m3,       ! 30     amp/phase of 2-day (3,3) wave
     |  nlon,           ! 31    number of longitudes
     |  nlat,           ! 32    number of latitudes
     |  nzp,            ! 33    number of log pressure levels
     |  nfields,        ! 34    number of fields on current history
     |  ndynamo,        ! 35    0/1 flag for presence of dynamo
     |  ntimegcm,       ! 36    0/1 flag for time-gcm (vs tigcm, tiegcm)
     |  nflxcplr,       ! 37    0/1 flag for flux coupled ccm/time-gcm run
     |  lensech,        ! 38    length of secondary history buffer
     |  nsrc_start(3),  ! 39-41 source volume start time
     |  npad(lheader-41)! 42-512 unused as of 2/99 (471 words, zeroed)
!
! Record 1 common:
      common/hdr1_int/
     |  nthhist,lenhdi,lenhdc,lenhdr,iteration,ncalyear,ncalday,
     |  mday,mhour,mmin,mtime_start,mtime_stop,nfreq_hist,nfreq_save,
     |  nstep_secs,ndifhor,nuivi,npower,naurora,ndispose,ntideann,
     |  ntide3m3,nlon,nlat,nzp,nfields,ndynamo,ntimegcm,nflxcplr,
     |  lensech,npad
!
! Record 2 (characters):
!
! (mxfields is dimension of cfields (<= nfields). Only cfields(1-nfields)
!  is written (nfields is read from integer header record 1)
!
      integer,parameter :: mxfields = 100, mxclen = 1024
      character(len=80) :: clabel    ! 1 -10 run label
      character(len=80) :: coutput   ! 11-20 mss path of output history file
      character(len=80) :: cmagvol   ! 21-30 mss path of mag data file
      character(len=80) :: csource   ! 31-40 mss path of source history file
      character(len=80) :: camivol   ! 41-50 mss path of amie data file
      character(len=8)  :: crdate    ! 51    run date
      character(len=8)  :: cversion  ! 52    model version name (e.g. tgcm23) 
      character(len=8)  :: cfields(mxfields) ! 53->53+nfields-1 field names
!
! Record 2 common:
      common/hdr2_char/
     |  clabel,coutput,cmagvol,csource,camivol,crdate,cversion,cfields
!
! Record 3 (64-bit reals):
      real ::           ! Word
     |  rmag(2,2),      ! 1-4  coords of south and north magnetic poles (deg)
     |  rsdtide(10),    ! 5-14 semi-diurnal tide: 5 amps (cm), 5 phases (hrs)
     |  rdtide(2),      ! 15-16 diurnal tide (amp,phase)
     |  rtide3m3(2),    ! 17-18 2-day (3,3) wave (amp,phase)
     |  rhp,            ! 19   hemispheric power (gw)
     |  rcp,            ! 20   cross-tail potential (kv)
     |  rby,            ! 21   imf in by direction
     |  f107d,          ! 22   daily f10.7 cm flux
     |  f107m,          ! 23   81-day mean f10.7 cm flux
     |  zpt,            ! 24   Zp pressure at top level of model
     |  zpb,            ! 25   Zp pressure at bottom level of model
     |  rcolfac,        ! 26   collision factor (input)
     |  rpad(lheader-26)! 27-512 unused as of 2/99 (486 words, zeroed)
!
! Record 3 common:
      common/hdr3_real/ rmag,rsdtide,rdtide,rhp,rcp,rby,f107d,f107m,
     |  zpt,zpb,rpad
!
! Equivalences for i/o routines:
!
      integer(kind=8) :: intheader(lheader)
      equivalence(intheader,nthhist)
      character(len=mxclen) :: cheader
      equivalence(cheader,clabel)
      real :: rheader(lheader)
      equivalence(rheader,rmag)
!
      end module hdr3rec
