!
      subroutine pltmxy(x,y,npts,nxcurve,multix,xlab,ylab,
     +  linelab,chsize,vp,ilog,scalefac,spval)
      implicit none
!
! Plot x as function of y:
!  If multix > 0, multiple curves in x(npts,nxcurve) are drawn.
! (typically the field is on the x-axis, zp/ht on the y-axis)
!
! Args:
      integer,intent(in) :: npts,nxcurve,multix,ilog
      real,intent(in) :: x(npts,nxcurve),y(npts),vp(4),chsize,spval,
     |  scalefac
      character(len=*),intent(in) :: xlab,ylab,linelab(nxcurve)
!
! Locals:
      real :: xx(npts,nxcurve),xmin,xmax
      real :: fmin,fmax,charsize,vpw
      integer :: i,j,logset,nnans
      real,parameter :: chsize_def=.03 	! default char size
      character(len=32) :: dashpat
!
! Externals:
      character(len=16) :: agdshn
!
      xx(:,:) = x(:,:)	! transfer to local array
!
! Check for nans on both axes:
!     subroutine check_nans(f,id1,id2,id3,name,n_total,ispval,spval,
!    |  iprint,ifatal)
!
      call check_nans(xx,npts,nxcurve,1,'XX',nnans,0,0.,0,0)
!     if (nnans == npts*nxcurve) then
      if (nnans > 0) then
        write(6,"('>>> WARNING pltmxy: ',i8,' of ',i8,' values on',
     |    ' x-axis are NaNs -- no plot made.')") nnans,npts*nxcurve
        return
      endif
      call check_nans(y,npts,1,1,'Y',nnans,0,0.,0,0)
!     if (nnans == npts) then
      if (nnans > 0) then
        write(6,"('>>> WARNING pltmxy: ',i8,' of ',i8,' values on',
     |    ' y-axis are NaNs -- no plot made.')") nnans,npts
        return
      endif
!
! Scale data if requested:
      if (scalefac /= 1.) then
        xx = merge(xx,xx*scalefac,xx==spval)
!       write(6,"('pltmxy: scaled data by scalefac=',e12.4)") scalefac
      endif
!
! ilog = 0 -> linear axis, linear field
! ilog = 1 -> linear axis, log10 field
! ilog = 2 -> log10 axis, linear field
!
      if (ilog==1) call log10f(xx,npts*nxcurve,1.e-20,spval)
      if (all(xx==spval)) then
        write(6,"(/'>>> pltmxy: all values are missing (ilog=',i2,
     +    ') (probably all values were <= 0. prior to log10)')")  
     +    ilog
        return
      endif
!
! Check for sufficient relief on x-axis:
      call fminmax(xx,npts*nxcurve,xmin,xmax)
      if (xmin >= xmax .or. abs(xmax-xmin).le.1.e-30) then
        write(6,"('>>> pltmxy: Not enough difference in field ',
     +    'on x-axis: xmin,xmax=',2e20.12)") xmin,xmax
        return
      endif
!
! logset = 1 -> x and y axes are linear
! logset = 2 -> x linear, y log
! logset = 3 -> y linear, x log
! logset = 4 -> x and y axes are log
!
      logset = 1
      if (ilog==2) logset = 3
!
! Scale char size:
      vpw = vp(2)-vp(1)
      charsize = chsize_def
      if (chsize > 0.) charsize = chsize
      charsize = charsize*vpw
!
! Viewport:
      call agsetf('SET.',2.)
      call set(vp(1),vp(2),vp(3),vp(4),xmin,xmax,y(1),y(npts),logset)
!
! x-axis:
      call agsetc("LABEL/NAME.","B")
      if (len_trim(xlab) > 0) then
        call agsetr("AXIS/BOTTOM/CONTROL.",1.)
        call agseti("LINE/NUMBER.",-100)
        call agsetf("LINE/CHARACTER.",charsize)
        call agseti("LINE/MAX.",len_trim(xlab))
        call agsetc("LINE/TEXT.",xlab)
        call agsetf ('AXIS/BOTTOM/NUMERIC/WIDTH/MANTISSA.',charsize)
      else
        call agsetr("LABEL/DEF/SUPPRESSION.",1.)
        call agsetr("AXIS/BOTTOM/CONTROL.",-1.)
        call agsetc("LABEL/NAME.","T")
        call agsetr("AXIS/TOP/CONTROL.",-1.)
      endif
!
! y-axis:
      call agsetc("LABEL/NAME.","L")
      if (len_trim(ylab) > 0) then
        call agseti("LINE/NUMBER.",100)
        call agsetf("LINE/CHARACTER.",charsize)
        call agseti("LINE/MAX.",len_trim(ylab))
        call agsetc("LINE/TEXT.",ylab)
        call agsetf ('AXIS/LEFT/NUMERIC/WIDTH/MANTISSA.',charsize)
      else
        call agsetr("LABEL/DEF/SUPPRESSION.",1.)
        call agsetr("AXIS/LEFT/CONTROL.",-1.)
        call agsetc("LABEL/NAME.","R")
        call agsetr("AXIS/TOP/CONTROL.",-1.)
      endif
!
! Disable top title:
      call agsetc("LABEL/NAME.","T")
      call agsetr("LABEL/DEF/SUPPRESSION.",1.)
!
! Set up dash patterns if necessary:
      if (multix > 0) then
        call agsetr('DASH/CHARACTER.',charsize)
        call agseti('DASH/SELECTOR.',nxcurve)
        call agseti('DASH/LENGTH.',len(dashpat))
        do i=1,nxcurve
          write(dashpat,"('$$$$$$$$$$$$$$$$$$$$$$''',a,'''')")
     +      linelab(i)
          call agsetc(agdshn(i),dashpat) 
        enddo
      endif
!
! Draw background:
      call agstup(xx,1,0,npts*nxcurve,1, y,1,0,npts,1)
      call agback
!
! Draw curve(s):
      do i=1,nxcurve
!
! 5/10/05 btf: removed this (not sure why it was here):
!       do j=1,npts-1
!         if((xx(j  ,i) .gt. 0.75*xmax .and.
!    +        xx(j+1,i) .lt. 0.25*xmax) .or.
!    +       (xx(j  ,i) .lt. 0.25*xmax .and.
!    +        xx(j+1,i) .gt. 0.75*xmax)) xx(j,i)=spval
!       enddo
        call agcurv(xx(1,i),1,y,1,npts,i)
      enddo
      end subroutine pltmxy
!---------------------------------------------------------------------
      subroutine pltxmy(x,y,npts,nycurve,multiy,xlab,ylab,
     +  linelab,chsize,vp,ilog,scalefac,spval)
      implicit none
!
! Plot y as function of x:
!  If multiy > 0, multiple curves in y(npts,nycurve) are drawn.
! (typically the field is on the y-axis, ut on the x-axis)
!
! Args:
      integer,intent(in) :: npts,nycurve,multiy,ilog
      real,intent(in) :: x(npts),y(npts,nycurve),vp(4),chsize,spval,
     |  scalefac
      character*(*),intent(in) :: xlab,ylab,linelab(nycurve)
!
! Locals:
      integer :: i,logset,nnans
      real :: yy(npts,nycurve),vpw,ymin,ymax,charsize
      real,parameter :: chsize_def=.04 	! default char size
      character(len=32) :: dashpat
!
! Externals:
      character(len=16) :: agdshn
!
      yy(:,:) = y(:,:)	! transfer to local array
!
! Check for nans on both axes:
!     subroutine check_nans(f,id1,id2,id3,name,n_total,ispval,spval,
!    |  iprint,ifatal)
!
      call check_nans(yy,npts,nycurve,1,'YY',nnans,0,0.,0,0)
!     if (nnans == npts*nycurve) then
      if (nnans > 0) then
        write(6,"('>>> WARNING pltxmy: ',i8,' of ',i8,' values on',
     |    ' y-axis are NaNs -- no plot made.')") nnans,npts*nycurve
        return
      endif
      call check_nans(x,npts,1,1,'X',nnans,0,0.,0,0)
!     if (nnans == npts) then
      if (nnans > 0) then
        write(6,"('>>> WARNING pltxmy: ',i8,' of ',i8,' values on',
     |    ' x-axis are NaNs -- no plot made.')") nnans,npts
        return
      endif
!
! Scale data if requested:
      if (scalefac /= 1.) then
        yy = merge(yy,yy*scalefac,yy==spval)
!       write(6,"('pltxmy: scaled data by scalefac=',e12.4)") scalefac
      endif
!
! ilog = 0 -> linear axis, linear field
! ilog = 1 -> linear axis, log10 field
! ilog = 2 -> log10 axis, linear field
!
      if (ilog==1) call log10f(yy,npts*nycurve,1.e-20,spval)
      if (all(yy==spval)) then
        write(6,"(/'>>> pltxmy: all values are missing (ilog=',i2,
     +    ') (probably all values were <= 0. prior to log10)')")  
     +    ilog
        return
      endif
!
! Check for sufficient relief on y-axis:
      call fminmax(yy,npts*nycurve,ymin,ymax)
      if (ymin >= ymax .or. abs(ymax-ymin).le.1.e-30) then
        write(6,"('>>> pltxmy: Not enough difference in field ',
     +    'on y-axis: ymin,ymax=',2e20.12)") ymin,ymax
        return
      endif
!
! logset = 1 -> x and y axes are linear
! logset = 2 -> x linear, y log
! logset = 3 -> y linear, x log
! logset = 4 -> x and y axes are log
!
      logset = 1
      if (ilog==2) logset = 2
!
! Scale char size:
      vpw = vp(2)-vp(1)
      charsize = chsize_def
      if (chsize > 0.) charsize = chsize
      charsize = charsize*vpw
!
! Viewport:
      call agsetf('SET.',2.)
      call set(vp(1),vp(2),vp(3),vp(4),x(1),x(npts),ymin,ymax,logset)
!
! x-axis:
      call agsetc("LABEL/NAME.","B")
      if (len_trim(xlab) > 0) then
        call agsetr("AXIS/BOTTOM/CONTROL.",1.)
        call agseti("LINE/NUMBER.",-100)
        call agsetf("LINE/CHARACTER.",charsize)
        call agseti("LINE/MAX.",len_trim(xlab))
        call agsetc("LINE/TEXT.",xlab)
        call agsetf ('AXIS/BOTTOM/NUMERIC/WIDTH/MANTISSA.',charsize)
      else
        call agsetr("LABEL/DEF/SUPPRESSION.",1.)
        call agsetr("AXIS/BOTTOM/CONTROL.",-1.)
        call agsetc("LABEL/NAME.","T")
        call agsetr("AXIS/TOP/CONTROL.",-1.)
      endif
!
! y-axis:
      if (len_trim(ylab) > 0) then 
        call agsetc("LABEL/NAME.","L")
        call agseti("LINE/NUMBER.",100)
        call agsetf("LINE/CHARACTER.",charsize)
        call agseti("LINE/MAX.",len_trim(ylab))
        call agsetc("LINE/TEXT.",ylab)
        call agsetf ('AXIS/LEFT/NUMERIC/WIDTH/MANTISSA.',charsize)
      else
        call agsetr("LABEL/DEF/SUPPRESSION.",1.)
        call agsetr("AXIS/LEFT/CONTROL.",-1.)
        call agsetc("LABEL/NAME.","R")
        call agsetr("AXIS/TOP/CONTROL.",-1.)
      endif
!
! Disable top title:
      call agsetc("LABEL/NAME.","T")
      call agsetr("LABEL/DEF/SUPPRESSION.",1.)
!
! Set up dash patterns if necessary:
      if (multiy > 0) then
        call agsetr('DASH/CHARACTER.',charsize)
        call agseti('DASH/SELECTOR.',nycurve)
        call agseti('DASH/LENGTH.',len(dashpat))
        do i=1,nycurve
          write(dashpat,"('$$$$$$$$$$$$$$$$$$$$$$''',a,'''')")
     +      linelab(i)
          call agsetc(agdshn(i),dashpat) 
        enddo
      endif
!
! Draw background:
      call agstup(x,1,0,npts,1, yy,1,0,npts*nycurve,1)
      call agback
!
! Draw curve(s):
      do i=1,nycurve
        call agcurv(x,1,yy(1,i),1,npts,i)
      enddo
      end subroutine pltxmy
