!
      subroutine qadglb(flds,nflds,h)
!
! Make "quick and dirty" global contours:
!
      use proc
      use fields,only: field,oh_alt 
      use hist,only: history 
      use input,only: ibohv_watts 
      implicit none
!
! Args:
      integer,intent(in) :: nflds
      type(field),intent(in) :: flds(nflds)
      type(history),intent(in) :: h
!
! Locals:
      integer :: log,i,k,ixz
      real fmin,fmax,fglb(nlon,nlat)
      character(len=80) title
      integer,external :: ixfindc
!
      ixz = ixfindc(flds%fname8,nflds,'Z       ')
      log = 0
      do i=1,nflds
        if (flds(i)%requested.and.associated(flds(i)%data)) then 
!
! Height dependent fields:
!
          if (flds(i)%nlev /= 1) then
!
! Loop through selected pressures:
!
            do k=1,flds(i)%nlev,10
              if (trim(flds(i)%type) /= 'OH-VIB' .and.
     +            trim(flds(i)%type) /= 'OH-BAND') then
                write(title,"(a,' (',a,') ZP=',f5.1,' UT=',f4.1)")
     +            trim(flds(i)%fname56),trim(flds(i)%units),
     +            gcmlev(k),h%ut
              else
                write(title,"(a,' (',a,') HT=',f5.1,' UT=',f4.1)")
     +            trim(flds(i)%fname56),trim(flds(i)%units),
     +            oh_alt(k),h%ut
              endif
              call fminmax(flds(i)%data(:,:,k),nlon*nlat,
     +          fmin,fmax)
              call mkcon(flds(i)%data(:,:,k),nlon,nlat,0.,log,
     +          'LONGITUDE','LATITUDE',title)
              iframe = iframe+1
              if (flds(i)%type /= 'OH-VIB' .and.
     +            flds(i)%type /= 'OH-BAND') then
                write(6,"('Frame ',i3,': ',a,' ZP=',
     +            f5.1,' UT=',f5.2,' min,max=',2e12.4)") 
     +            iframe,flds(i)%fname8,gcmlev(k),h%ut,fmin,fmax
              else
                write(6,"('Frame ',i3,': ',a,' HT=',
     +            f5.1,' UT=',f5.2,' min,max=',2e12.4)") 
     +            iframe,flds(i)%fname8,oh_alt(k),h%ut,fmin,fmax
              endif
            enddo
!
! Height-integrated emissions:
!
            if (trim(flds(i)%type) == 'EMISSION') then
              write(title,"(a,' (RAYLEIGHS) (HT-INTEG) UT=',f4.1)")
     +          trim(flds(i)%fname56),h%ut
              call glb_integ(flds(i)%data,flds(ixz)%data,fglb,
     +          nlon,npress,nlat)
              fglb = fglb*1.e-6	! rayleighs
              call fminmax(fglb,nlon*nlat,fmin,fmax)
              call mkcon(fglb,nlon,nlat,0.,log,'LONGITUDE','LATITUDE',
     +          title)
              iframe = iframe+1
              write(6,"('Frame ',i3,': ',a,' HT-INTEG',
     +          ' UT=',f5.2,' min,max=',2e12.4)") 
     +          iframe,flds(i)%fname8,h%ut,fmin,fmax
            endif
!
! Height-integrated OH vibrational states and emission bands:
!
            if (trim(flds(i)%type) == 'OH-VIB' .or.
     +          trim(flds(i)%type) == 'OH-BAND') then
              call glb_integ(flds(i)%data,flds(ixz)%data,fglb,
     +          nlon,npress,nlat)
              if (ibohv_watts <= 0) then
                fglb = fglb * 1.e-9	! KR
                write(title,"(a,' (KILO-RAYLEIGHS) (HT-INTEG) ',
     +            'UT=',f4.1)")
     +            trim(flds(i)%fname56),h%ut
              else
                fglb = fglb / (4.*pi)	! watts/cm2-str
                write(title,"(a,' (WATTS/CM2-STR) (HT-INTEG) ',
     +            'UT=',f4.1)")
     +            trim(flds(i)%fname56),h%ut
              endif
              call fminmax(fglb,nlon*nlat,fmin,fmax)
              call mkcon(fglb,nlon,nlat,0.,log,'LONGITUDE','LATITUDE',
     +          title)
              iframe = iframe+1
              write(6,"('Frame ',i3,': ',a,' HT-INTEG',
     +          ' UT=',f5.2,' min,max=',2e12.4)") 
     +          iframe,flds(i)%fname8,h%ut,fmin,fmax
            endif
!
! Height-independent fields:
!
          else	! height independent field
            write(title,"(a,' (',a,') UT=',f4.1)")
     +        trim(flds(i)%fname56),trim(flds(i)%units),h%ut
            call fminmax(flds(i)%data(:,:,1),nlon*nlat,
     +        fmin,fmax)
            call mkcon(flds(i)%data(:,:,1),nlon,nlat,0.,log,
     +        'LONGITUDE','LATITUDE',title)
            iframe = iframe+1
            write(6,"('Frame ',i3,': ',a,' UT=',f5.2,
     +        ' min,max=',2e12.4)") 
     +        iframe,flds(i)%fname8,h%ut,fmin,fmax
          endif 	! flds(i)%nlev
        endif	! requested and associated
      enddo		! i=1,nflds
      return
      end
