!
      subroutine scrub_hvols(hvols,nvols,mxdisk,tmpdir)
      implicit none
!
! Args:
      integer,intent(in) :: mxdisk,nvols
      character(len=*),intent(in) :: hvols(nvols),tmpdir
!
! Locals:
      integer,parameter :: mxlen=120
      integer :: i,ndisk,lenhvol,nrm,stat
      character(len=mxlen) :: diskfiles(nvols)
      character(len=mxlen*2) :: diskfile
      logical :: exists
!
! Externals:
      character(len=mxlen),external :: mkflnm
      integer,external :: iunlink
!
! Count files on disk:
      ndisk = 0
      vols_loop: do i=1,size(hvols) 
        lenhvol = len_trim(hvols(i))
        if (lenhvol == 0) cycle vols_loop
        if (lenhvol > mxlen) then
          write(6,"('>>> WARNING scrub_hvols: history volume ',
     +      ' path name too long=',i5)") len_trim(hvols(i))
          cycle vols_loop
        endif
        diskfile = mkflnm(hvols(i),.false.)
        inquire(file=diskfile,exist=exists)
        if (exists) then
          ndisk = ndisk+1
          diskfiles(ndisk) = diskfile
        endif
      enddo vols_loop
      if (ndisk <= mxdisk) then
        write(6,"('scrub_hvols: no disk files removed:',
     +    ' ndisk=',i3,' mxdisk=',i3)") ndisk,mxdisk
        return
      endif
!
! Need to remove files:
      nrm = 0
      rm_loop: do i=1,ndisk-mxdisk
!
! Remove from cwd:
        stat = iunlink(diskfiles(i),1)
        if (stat /= 0) then	! error
          write(6,"('>>> scrub_hvols: error unlinking disk file ',
     +      a,' stat=',i5)") trim(diskfiles(i)),stat
        else
          nrm = nrm+1
          write(6,"('scrub_hvols: removed disk file ',a)") 
     +      trim(diskfiles(i))
        endif
!
! Remove from tmpdir (tmpdir/diskfile exists, it was just a link
! of diskfile, so do not increment nrm)
!
        if (len_trim(tmpdir) > 0) then
          diskfile = trim(tmpdir)//'/'//trim(diskfiles(i))
          stat = iunlink(diskfile,1)
          if (stat /= 0) then	! error
            write(6,"('>>> scrub_hvols: error unlinking disk file ',
     +        a,' stat=',i5)") trim(diskfile),stat
          else
            write(6,"('scrub_hvols: removed disk file ',a)") 
     +        trim(diskfile)
          endif
        endif
      enddo rm_loop
!
      if (nrm > 0) then
!       write(6,"('Exit scrub_hvols: removed ',i3,' history volume',
!    +    ' disk files.')") nrm
      else
        write(6,"('WARNING scrub_hvols: no history volumes removed',
     +    ' from disk (should have removed ',i3,' files)')")
     +    ndisk-mxdisk
      endif
      return
      end subroutine scrub_hvols
