c
      subroutine fset_known
c
c Initialize non-data components of known fields:
c (flds_known(i)%npress will be set after number of levels is known
c  from reading history header summary)
c
      use fields
      use input,only: iden,ionvel,ie6300,ie5577
      use gfactors,only: nstate,enames,exsp
      implicit none
      integer :: i,ier,nf,hi,lo,istat
      integer :: n=1,mxneed,nneed
      character(len=8),allocatable :: fneed(:)
      integer,external :: addstrele
      integer,parameter :: ndunits=4, len_units=16
      character(len=len_units),save :: dunits(ndunits) = 
     +  (/'MMR     ','CM3     ','CM3-MR  ','GM/CM3  '/)
      character(len=8) :: na_names(mxnaf) =
     + (/'NaS     ','NaO     ','NaO3    ','NaO2    ','NaOH    ',
     +   'NaCO3   ','NaHCO3  ','NaS+    ','NaN2+   ','NaCO2+  ',
     +   'NaH2O+  ','NaO+    ','NaEMIS  '/)
c
c Initialize to blanks and spval, all known:
c
      do i=1,mxfknown
        call fldinit(flds_known(i))
        flds_known(i)%known = .TRUE.
      enddo
c
      write(
     +flds_known(n)%fname56,"('NEUTRAL TEMPERATURE')") 
      flds_known(n)%fname8 =  'TN      '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'DEG K           '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('NEUTRAL ZONAL WIND')") 
      flds_known(n)%fname8 =  'UN      '
      flds_known(n)%type   =  'VECTOR          '
      flds_known(n)%units  =  'M/S             '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('NEUTRAL MERIDIONAL WIND')") 
      flds_known(n)%fname8 =  'VN      '
      flds_known(n)%type   =  'VECTOR          '
      flds_known(n)%units  =  'M/S             '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('MOLECULAR OXYGEN')") 
      flds_known(n)%fname8 =  'O2      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  32.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('OX GROUP (O+O3)')") 
      flds_known(n)%fname8 =  'OX      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  16.
      allocate(flds_known(n)%fcomponents(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fcomponents for ox')
      flds_known(n)%fcomponents(1) = 'O1      '
      flds_known(n)%fcomponents(2) = 'O3      '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('N4S')") 
      flds_known(n)%fname8 =  'N4S     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  14.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('NO GROUP (NO+NO2)')") 
      flds_known(n)%fname8 =  'NOZ     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  30.
      allocate(flds_known(n)%fcomponents(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fcomponents for noz')
      flds_known(n)%fcomponents(1) = 'NO      '
      flds_known(n)%fcomponents(2) = 'NO2     '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('CARBON MONOXIDE (CO)')") 
      flds_known(n)%fname8 =  'CO      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  28.
      n = n+1
c
c Note CO2 is derived if history is from mtgcm (see getflds.f)
      write(
     +flds_known(n)%fname56,"('CARBON DIOXIDE (CO2)')") 
      flds_known(n)%fname8 =  'CO2     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  44.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('WATER VAPOR (H2O)')") 
      flds_known(n)%fname8 =  'H2O     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  18.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('MOLECULAR HYDROGEN (H2)')") 
      flds_known(n)%fname8 =  'H2      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  2.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('HYDROGEN GROUP (OH+HO2+H)')")
      flds_known(n)%fname8 =  'HOX     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  17.
      allocate(flds_known(n)%fcomponents(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fcomponents for hox')
      flds_known(n)%fcomponents(1) = 'OH      '
      flds_known(n)%fcomponents(2) = 'HO2     '
      flds_known(n)%fcomponents(3) = 'H       '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('O+ ION')")
      flds_known(n)%fname8 =  'O+      '
      flds_known(n)%type   =  'DENSITY         '
      n = n+1
c
! OP is an alias for O+ (The name "O+" is not allowed on netcdf histories)
! Both "O+" and "OP" are known to the processor:
      write(
     +flds_known(n)%fname56,"('O+ ION')")
      flds_known(n)%fname8 =  'O+      '
      flds_known(n)%type   =  'DENSITY         '
      n = n+1

      write(
     +flds_known(n)%fname56,"('O+ ION')")
      flds_known(n)%fname8 =  'OP      '
      flds_known(n)%type   =  'DENSITY         '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('METHANE (CH4)')")
      flds_known(n)%fname8 =  'CH4     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  16.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('ARGON (AR)')")
      flds_known(n)%fname8 =  'AR      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  40.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('HELIUM (HE)')")
      flds_known(n)%fname8 =  'HE      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  4.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('TOTAL SODIUM')")
      flds_known(n)%fname8 =  'NAT     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  23.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('O21D')")
      flds_known(n)%fname8 =  'O21D    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  32.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('NITROGEN DIOXIDE (NO2)')")
      flds_known(n)%fname8 =  'NO2     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  46.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('NITRIC OXIDE')")
      flds_known(n)%fname8 =  'NO      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  30.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('OZONE')")
      flds_known(n)%fname8 =  'O3      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  48.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('ATOMIC OXYGEN')")
      flds_known(n)%fname8 =  'O1      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  16.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('OH')")
      flds_known(n)%fname8 =  'OH      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  17.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('HO2')")
      flds_known(n)%fname8 =  'HO2     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  33.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('HYDROGEN (H)')")
      flds_known(n)%fname8 =  'H       '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  1.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('N2D')")
      flds_known(n)%fname8 =  'N2D     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  14.
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('ION TEMPERATURE')")
      flds_known(n)%fname8 =  'TI      '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'DEG K           '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('ELECTRON TEMPERATURE')")
      flds_known(n)%fname8 =  'TE      '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'DEG K           '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('ELECTRON DENSITY')")
      flds_known(n)%fname8 =  'NE      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%zptype =  'FULL            '
      n = n+1
c
! O2P is an alias for O2+ (The plus sign '+' is not allowed in netcdf vars)
! Both "O2+" and "O2P" are known to the processor:
      write(
     +flds_known(n)%fname56,"('O2+ ION')")
      flds_known(n)%fname8 =  'O2+     '
      flds_known(n)%type   =  'DENSITY         '
      n = n+1
!
      write(
     +flds_known(n)%fname56,"('O2+ ION')")
      flds_known(n)%fname8 =  'O2P     '
      flds_known(n)%type   =  'DENSITY         '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('VERTICAL WIND (PLUS UP)')")
      flds_known(n)%fname8 =  'W       '
      flds_known(n)%type   =  'VECTOR          '
      flds_known(n)%units  =  'M/S             '
      flds_known(n)%zptype =  'FULL            '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('GEOPOTENTIAL HEIGHT')")
      flds_known(n)%fname8 =  'Z       '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'KM              '
      flds_known(n)%zptype =  'FULL            '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('GEOPOTENTIAL HEIGHT (with gravity)')")
      flds_known(n)%fname8 =  'ZG      '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'KM              '
      flds_known(n)%zptype =  'FULL            '
      n = n+1
c
      write(
     +flds_known(n)%fname56,"('ELECTRIC POTENTIAL')")
      flds_known(n)%fname8 =  'POTEN   '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'VOLTS           '
      flds_known(n)%zptype =  'FULL            '
      n = n+1
!
! jtgcm primary history fields: h3p, hp, h2v1, h2v2, h2v3, h2v4, h2p, morph
!
      write(
     +flds_known(n)%fname56,"('H3+ ION')")
      flds_known(n)%fname8 =  'H3P     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  3.
      n = n+1
!
      write(
     +flds_known(n)%fname56,"('H+ ION')")
      flds_known(n)%fname8 =  'HP      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  1.
      n = n+1
!
      write(flds_known(n)%fname56,
     |  "('MOLECULAR HYDROGEN VIBRATIONAL STATE 1')")
      flds_known(n)%fname8 =  'H2V1    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  2.2
      n = n+1
!
      write(flds_known(n)%fname56,
     |  "('MOLECULAR HYDROGEN VIBRATIONAL STATE 2')")
      flds_known(n)%fname8 =  'H2V2    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  2.2
      n = n+1
!
      write(flds_known(n)%fname56,
     |  "('MOLECULAR HYDROGEN VIBRATIONAL STATE 3')")
      flds_known(n)%fname8 =  'H2V3    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  2.2
      n = n+1
!
      write(flds_known(n)%fname56,
     |  "('MOLECULAR HYDROGEN VIBRATIONAL STATE 4')")
      flds_known(n)%fname8 =  'H2V4    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  2.2
      n = n+1
!
! H2+ is always CM-3 (like NE)
      write(
     +flds_known(n)%fname56,"('H2+ ION')")
      flds_known(n)%fname8 =  'H2P     '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'MMR             '
      flds_known(n)%wt     =  2.2
      n = n+1
!
      write(
     +flds_known(n)%fname56,"('MORPHOLOGY')")
      flds_known(n)%fname8 =  'MORPH   '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  '                '
      n = n+1
!
! Begin derived fields:
!
! Ion velocity labels depend on ionvel flag:
!     ionvel = 0 -> read from history (underived)
!     ionvel = 1 -> ExB only
!     ionvel = 2 -> ExB+unvn  (total ion velocity)
!     ionvel = 3 -> ExB+unvn, with E=0 (set electric potential = 0)
!     ionvel = 4 -> ExB+unvn, with un,vn,wn = 0
!
! Zonal ion drifts (UI):
      select case (ionvel)
      case (0)
        write(flds_known(n)%fname56,"('ZONAL ION VELOCITY (UI)')")
        flds_known(n)%units  =  '                '
      case (1)
        write(flds_known(n)%fname56,"('ZONAL ExB DRIFT (UI)')")
        flds_known(n)%units  =  'M/S             '
      case (2)
        write(flds_known(n)%fname56,"('ZONAL ION VELOCITY (UI)')")
        flds_known(n)%units  =  'M/S             '
      case (3)
        write(flds_known(n)%fname56,"('ZONAL ION VELOCITY (UI) ',
     +    'DUE TO NEUTRAL WIND')")
        flds_known(n)%units  =  'M/S             '
      case (4)
        write(flds_known(n)%fname56,"('ZONAL ION VELOCITY (UI) ',
     +    'DUE TO ELECTRIC FIELD')")
        flds_known(n)%units  =  'M/S             '
      end select
      flds_known(n)%fname8 =  'UI      '
      flds_known(n)%type   =  'VECTOR          '
      n = n+1
!
! Meridional ion drifts (VI):
      select case (ionvel)
      case (0)
        write(flds_known(n)%fname56,"('MERIDIONAL ION VELOCITY (VI)')")
        flds_known(n)%units  =  '                '
      case (1)
        write(flds_known(n)%fname56,"('MERIDIONAL ExB DRIFT (VI)')")
        flds_known(n)%units  =  'M/S             '
      case (2)
        write(flds_known(n)%fname56,"('MERIDIONAL ION VELOCITY (VI)')")
        flds_known(n)%units  =  'M/S             '
      case (3)
        write(flds_known(n)%fname56,"('MERIDIONAL ION VELOCITY (VI) ',
     +    'DUE TO NEUTRAL WIND')")
        flds_known(n)%units  =  'M/S             '
      case (4)
        write(flds_known(n)%fname56,"('MERIDIONAL ION VELOCITY (VI) ',
     +    'DUE TO ELECTRIC FIELD')")
        flds_known(n)%units  =  'M/S             '
      end select
      flds_known(n)%fname8 =  'VI      '
      flds_known(n)%type   =  'VECTOR          '
      n = n+1
!
! Vertical ion drifts (WI):
      select case (ionvel)
      case (0)
        write(flds_known(n)%fname56,"('VERTICAL ION VELOCITY (WI)')")
        flds_known(n)%units  =  '                '
      case (1)
        write(flds_known(n)%fname56,"('VERTICAL ExB DRIFT (WI)')")
        flds_known(n)%units  =  'M/S             '
      case (2)
        write(flds_known(n)%fname56,"('VERTICAL ION VELOCITY (WI)')")
        flds_known(n)%units  =  'M/S             '
      case (3)
        write(flds_known(n)%fname56,"('VERTICAL ION VELOCITY (WI) ',
     +    'DUE TO NEUTRAL WIND')")
        flds_known(n)%units  =  'M/S             '
      case (4)
        write(flds_known(n)%fname56,"('VERTICAL ION VELOCITY (WI) ',
     +    'DUE TO ELECTRIC FIELD')")
        flds_known(n)%units  =  'M/S             '
      end select
      flds_known(n)%fname8 =  'WI      '
      flds_known(n)%type   =  'VECTOR          '
      n = n+1
!
! Dependencies for ion drifts:
!
      do i=n-3,n-1
        if (ionvel == 0) then
          flds_known(i)%derived = .FALSE.
        elseif (ionvel == 1) then
          allocate(flds_known(i)%fneed(1),stat=ier)
          write(flds_known(i)%fneed(1),"('POTEN   ')")
          flds_known(i)%derived = .TRUE.
        else
          allocate(flds_known(i)%fneed(6),stat=ier)
          write(flds_known(i)%fneed(1),"('POTEN   ')")
          write(flds_known(i)%fneed(2),"('UN      ')")
          write(flds_known(i)%fneed(3),"('VN      ')")
          write(flds_known(i)%fneed(4),"('W       ')")
          write(flds_known(i)%fneed(5),"('O2      ')")
          write(flds_known(i)%fneed(6),"('O1      ')")
          flds_known(i)%derived = .TRUE.
        endif
      enddo
!
! UI+VI vector sum (vector arrow plots):
! This is always a derived field. If ionvel==0, then UI,VI are
! read from the history.
!
      select case (ionvel)
      case (0)
        write(flds_known(n)%fname56,"('UI+VI ION VELOCITY')")
        flds_known(n)%units  =  '                '
      case (1)
        write(flds_known(n)%fname56,"('UI+VI ExB DRIFT')")
        flds_known(n)%units  =  'M/S             '
      case (2)
        write(flds_known(n)%fname56,"('UI+VI ION VELOCITY')")
        flds_known(n)%units  =  'M/S             '
      case (3)
        write(flds_known(n)%fname56,"('UI+VI ION VELOCITY ',
     +    'DUE TO NEUTRAL WIND')")
        flds_known(n)%units  =  'M/S             '
      case (4)
        write(flds_known(n)%fname56,"('UI+VI ION VELOCITY ',
     +    'DUE TO ELECTRIC FIELD')")
        flds_known(n)%units  =  'M/S             '
      end select
      flds_known(n)%fname8 =  'UIVI    '
      flds_known(n)%type   =  'VECTOR          '
!
! If ionvel==0, then use UI,VI from the history (underived).
      if (ionvel == 0) then
        allocate(flds_known(n)%fneed(2),stat=ier)
        write(flds_known(n)%fneed(1),"('UI      ')")
        write(flds_known(n)%fneed(2),"('VI      ')")
      elseif (ionvel == 1) then
        allocate(flds_known(n)%fneed(3),stat=ier)
        write(flds_known(n)%fneed(1),"('POTEN   ')")
        write(flds_known(n)%fneed(2),"('UI      ')")
        write(flds_known(n)%fneed(3),"('VI      ')")
      elseif (ionvel > 1) then
        allocate(flds_known(n)%fneed(8),stat=ier)
        write(flds_known(n)%fneed(1),"('POTEN   ')")
        write(flds_known(n)%fneed(2),"('UN      ')")
        write(flds_known(n)%fneed(3),"('VN      ')")
        write(flds_known(n)%fneed(4),"('W       ')")
        write(flds_known(n)%fneed(5),"('O2      ')")
        write(flds_known(n)%fneed(6),"('O1      ')")
        write(flds_known(n)%fneed(7),"('UI      ')")
        write(flds_known(n)%fneed(8),"('VI      ')")
      endif
      flds_known(n)%derived = .TRUE.
      n = n+1
c
c N2 = (1-o2-o1):
      write(flds_known(n)%fname56,"('MOLECULAR NITROGEN')")
      flds_known(n)%fname8 =  'N2      '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%wt     =  28.
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for n2')
      write(flds_known(n)%fneed(1),"('O2      ')") 
      write(flds_known(n)%fneed(2),"('O1      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! RHO = o2+o1+n2 (will use 1-o2-o1 for n2):
! (for mtgcm or vtgcm, rho = co2+n2+co+o)
! (for jtgcm, rho = h+he+h2, where h2=1-h-he)
!
      write(flds_known(n)%fname56,"('TOTAL DENSITY (O2+O1+N2)')")
      flds_known(n)%fname8 =  'RHO     '
      flds_known(n)%type   =  'DENSITY         '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for rho')
      write(flds_known(n)%fneed(1),"('O2      ')") 
      write(flds_known(n)%fneed(2),"('O1      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! UN+VN vectors:
      write(flds_known(n)%fname56,"('UN+VN VELOCITY')")
      flds_known(n)%fname8 =  'UNVN    '
      flds_known(n)%type   =  'VECTOR          '
      flds_known(n)%units  =  'M/S             '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for unvn')
      write(flds_known(n)%fneed(1),"('UN      ')") 
      write(flds_known(n)%fneed(2),"('VN      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! FOF2 (height-independent): 
      write(flds_known(n)%fname56,"('FOF2')")
      flds_known(n)%fname8 =  'FOF2    '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'MHz             '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for fof2')
      write(flds_known(n)%fneed(1),"('NE      ')") 
      write(flds_known(n)%fneed(2),"('Z       ')") 
      flds_known(n)%derived = .TRUE.
      flds_known(n)%vtype = 'HT-INDEP'
      flds_known(n)%nlev = 1
      flds_known(n)%blev = 0.
      flds_known(n)%dlev = 0.
      n = n+1
!
! HMF2 (height-independent): 
      write(flds_known(n)%fname56,"('HMF2')")
      flds_known(n)%fname8 =  'HMF2    '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'KM              '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for hmf2')
      write(flds_known(n)%fneed(1),"('NE      ')") 
      write(flds_known(n)%fneed(2),"('Z       ')") 
      flds_known(n)%derived = .TRUE.
      flds_known(n)%vtype = 'HT-INDEP'
      flds_known(n)%nlev = 1
      flds_known(n)%blev = 0.
      flds_known(n)%dlev = 0.
      n = n+1
!
! For jtgcm: h2, he/h2, h/h2
!
! H2 (1-He-H). H2 is made a derived field in sub setjtgcm (getflds.f)
!     write(flds_known(n)%fname56,"('MOLECULAR HYDROGEN')")
!     flds_known(n)%fname8 =  'H2      '
!     flds_known(n)%type   =  'DENSITY         '
!     flds_known(n)%wt     =  2.2
!     allocate(flds_known(n)%fneed(2),stat=ier)
!     if (ier /= 0) call allocerr(ier,'allocating fneed for h2')
!     write(flds_known(n)%fneed(1),"('HE      ')") 
!     write(flds_known(n)%fneed(2),"('H       ')") 
!     flds_known(n)%derived = .TRUE.
!     n = n+1
!
! HE/H2 (HE/(1-HE-H)):
      write(flds_known(n)%fname56,"('RATIO HE/H2')")
      flds_known(n)%fname8 =  'HE/H2   '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =   ' '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for HE/H2')
      write(flds_known(n)%fneed(1),"('HE      ')") 
      write(flds_known(n)%fneed(2),"('H       ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! H/H2 (H/(1-HE-H)):
      write(flds_known(n)%fname56,"('RATIO H/H2')")
      flds_known(n)%fname8 =  'H/H2    '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =   ' '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for H/H2')
      write(flds_known(n)%fneed(1),"('HE      ')") 
      write(flds_known(n)%fneed(2),"('H       ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1


!---------------------- begin emissions fields ------------------- 
!
! Emission fields (E6300, E5577, EO200, EOH83, ECO215u, ENO53u)
!
! E6300 redline:
      if (ie6300 <= 0) then
        write(flds_known(n)%fname56,"('REDLINE EMISSION (E6300)')")
      else
        write(flds_known(n)%fname56,
     +    "('REDLINE EMISSION (E6300+SR63)')")
      endif
      flds_known(n)%fname8 =  'E6300   '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
      allocate(flds_known(n)%fneed(6),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for e6300')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('O2      ')") 
      write(flds_known(n)%fneed(3),"('O1      ')") 
      write(flds_known(n)%fneed(4),"('TE      ')") 
      write(flds_known(n)%fneed(5),"('O2+     ')") 
      write(flds_known(n)%fneed(6),"('NE      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! E5577 greenline (see also e5577lab in fields.f):
      write(flds_known(n)%fname56,"('GREENLINE EMISSION (E5577)')")
      flds_known(n)%fname8 =  'E5577   '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
!
! Default ie5577(5)=(/1,0,0,0,0/)
!
! ie5577(1) > 0 -> o1 recombination (original)
!   (need tn,o2,o,n2)
! ie5577(2) > 0 -> dissociative recombination of o2+
!   (need te,o2p,ne,o21d)
! ie5577(3) > 0 -> photoelectron impact
!   (need tn,z,o2,o,n2,o21d and solred)
! ie5577(4) > 0 -> airglow
!   (need tn,z,o2,o,n2,o21d and solred)
! ie5577(5) > 0 -> photo dissoc of o2 by solar lyman-beta
!   (need tn,z,o2,o,n2,o21d and solred) (glyb returned by solred)
! This boils down to max 9 fields:
!    'TN      ','O2      ','O1      ','N2      ','TE      ',
!    'O2+     ','NE      ','O21D    ','Z       '
! However, if O21D is not available, use 1.e-20 (see sub mkderived).
! Therefore, o21d is not included in the dependency list.
!
!     mxneed = 9
      mxneed = 5
      allocate(fneed(mxneed),stat=ier)
      if (ier /= 0) call allocerr(ier,
     +  'allocating fneed(mxneed) for e5577')
      fneed=' ' 
      do i=1,5
        select case (i)
          case (1) 
            if (ie5577(i)>0) then
              istat = addstrele(fneed,mxneed,'TN      ')
              istat = addstrele(fneed,mxneed,'O2      ')
              istat = addstrele(fneed,mxneed,'O1      ')
              istat = addstrele(fneed,mxneed,'N2      ')
            endif
          case (2)
            if (ie5577(i)>0) then
              istat = addstrele(fneed,mxneed,'TE      ')
              istat = addstrele(fneed,mxneed,'O2+     ')
              istat = addstrele(fneed,mxneed,'NE      ')
!             istat = addstrele(fneed,mxneed,'O21D    ')
            endif
          case (3)
            if (ie5577(i)>0) then
              istat = addstrele(fneed,mxneed,'TN      ')
              istat = addstrele(fneed,mxneed,'Z       ')
              istat = addstrele(fneed,mxneed,'O2      ')
              istat = addstrele(fneed,mxneed,'O1      ')
              istat = addstrele(fneed,mxneed,'N2      ')
!             istat = addstrele(fneed,mxneed,'O21D    ')
            endif
          case (4)
            if (ie5577(i)>0) then
              istat = addstrele(fneed,mxneed,'TN      ')
              istat = addstrele(fneed,mxneed,'Z       ')
              istat = addstrele(fneed,mxneed,'O2      ')
              istat = addstrele(fneed,mxneed,'O1      ')
              istat = addstrele(fneed,mxneed,'N2      ')
!             istat = addstrele(fneed,mxneed,'O21D    ')
            endif
          case (5)
            if (ie5577(i)>0) then
              istat = addstrele(fneed,mxneed,'TN      ')
              istat = addstrele(fneed,mxneed,'Z       ')
              istat = addstrele(fneed,mxneed,'O2      ')
              istat = addstrele(fneed,mxneed,'O1      ')
              istat = addstrele(fneed,mxneed,'N2      ')
!             istat = addstrele(fneed,mxneed,'O21D    ')
            endif
        end select
      enddo
      nneed = 0
      do i=1,mxneed
        if (len_trim(fneed(i))>0) nneed = nneed+1
      enddo
      if (nneed > 0) then
        allocate(flds_known(n)%fneed(nneed),stat=ier)
        if (ier /= 0) call allocerr(ier,'allocating fneed for e5577')
        do i=1,mxneed
          if (len_trim(fneed(i))>0) flds_known(n)%fneed(i) = fneed(i)
        enddo
        flds_known(n)%derived = .TRUE.
      else
        write(6,"('>>> fset_known WARNING: no dependencies for ',
     +    'E5577?  ie5577=',5i3)") ie5577
      endif
!     write(6,"('fset_known: n=',i2,' field ',a,' nneed=',i2,
!    +  ' fneed=',/(8a8))") n,flds_known(n)%fname8,nneed,
!    +  flds_known(n)%fneed
      deallocate(fneed)
      n = n+1
!
! EO200 emission:
      write(flds_known(n)%fname56,"('O2 ATMOS (0-0) BAND EMISSION')")
      flds_known(n)%fname8 =  'EO200   '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for eo200')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('O2      ')") 
      write(flds_known(n)%fneed(3),"('O1      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! EOH83 emission:
      write(flds_known(n)%fname56,"('OH ATMOS (8-3) BAND EMISSION')")
      flds_known(n)%fname8 =  'EOH83   '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for eoh83')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('O2      ')") 
      write(flds_known(n)%fneed(3),"('O1      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! ECO215u emission:
      write(flds_known(n)%fname56,"('ECO2-15u 15 MICRON CO2 EMISSION')")
      flds_known(n)%fname8 =  'ECO215u '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for eco215u')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('O1      ')") 
      write(flds_known(n)%fneed(3),"('CO2     ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! ENO53u emission:
      write(flds_known(n)%fname56,"('ENO-5.3u 5.3 MICRON NO EMISSION')")
      flds_known(n)%fname8 =  'ENO53u  '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for eco215u')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('O1      ')") 
      write(flds_known(n)%fneed(3),"('NO      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! ENO non-derived is on vtgcm histories only:
      write(flds_known(n)%fname56,"('NO EMISSION')")
      flds_known(n)%fname8 =  'ENO     '
      flds_known(n)%type   =  'EMISSION        '
      flds_known(n)%units  =  'PHOTONS/CM3/SEC '
      n = n+1
!
!---------------------- begin Strickland's excited states ------------
!
! Excitation rates derived from g-factor calculations, after Strickland 
! (JGR Vol 102, No. A7, pp 14485-14498, July 1, 1997) (see gfac.f)
!
! State names from gfac.f: 
! (Processor field names are E-[state name])
!
!     character(len=8) :: enames(nstate)=
!    + (/'1085E   ','1085S   ','1134N   ','1134N2  ','1200N   ',
!    +   '1200N2  ','1304    ','1356    ','1493N   ','1493N2  ',
!    +   '5577    ','6300    ','834E    ','834SOL  ','989     ',
!    +   'N22PG   ','N2C4    ','N2LBH   ','N2VK    ','OPLS2D  ',
!    +   'OPLS2P  '/)
!
      do i=1,nstate
        flds_known(n)%fname8 = 'E-' // trim(enames(i))
        flds_known(n)%type   =  'EXCITED-STATE   '
        flds_known(n)%units  =  'CM3/SEC         ' ! vol excitation rate
        allocate(flds_known(n)%fneed(2),stat=ier)
        if (ier /= 0) call allocerr(ier,'allocating fneed for e-state')
        if (trim(exsp(i))=='N2') then
          write(flds_known(n)%fneed(1),"('N2      ')") 
        else
          write(flds_known(n)%fneed(1),"('O1      ')") 
        endif
        write(flds_known(n)%fneed(2),"('RHO     ')") 
        flds_known(n)%derived = .TRUE.
        select case (enames(i))
        case ('N2LBH   ')
          write(flds_known(n)%fname56,
     +    "('N2 LYMAN-BIRGE-HOPFIELD (125-240 nm)')")
        case ('N22PG   ')
          write(flds_known(n)%fname56,
     +      "('N2 SECOND POSITIVE GROUP (280-460 nm)')")
        case ('N2VK    ')
          write(flds_known(n)%fname56,
     +      "('N2(a) VEGARD-KAPLAN (150-690 nm)')")
        case ('N2C4    ')
          write(flds_known(n)%fname56,
     +      "('N2 CAROLL-YOSHINO (90-110 nm)')")
        case ('1493N   ')
          write(flds_known(n)%fname56,
     +      "('N EXCITATION RATE (149.3 nm)')")
        case ('1493N2  ')
          write(flds_known(n)%fname56,
     +      "('N2 EXCITATION RATE (149.3 nm)')")
        case ('1134N   ')
          write(flds_known(n)%fname56,
     +      "('N EXCITATION RATE (113.4 nm)')")
        case ('1134N2  ')
          write(flds_known(n)%fname56,
     +      "('N2 EXCITATION RATE (113.4 nm)')")
        case ('1200N   ')
          write(flds_known(n)%fname56,
     +      "('N EXCITATION RATE (120.0 nm)')")
        case ('1200N2  ')
          write(flds_known(n)%fname56,
     +      "('N2 EXCITATION RATE (120.0 nm)')")
        case ('1085E   ')
          write(flds_known(n)%fname56,
     +      "('N2-E EXCITATION RATE (108.5 nm)')")
        case ('1085S   ')	! was changed from 1085SOL
          write(flds_known(n)%fname56,
     +      "('N2-SOL EXCITATION RATE (108.5 nm)')")
        case ('989     ')
          write(flds_known(n)%fname56,
     +      "('O EXCITATION RATE (989.0 nm)')")
        case ('1304    ')
          write(flds_known(n)%fname56,
     +      "('O EXCITATION RATE (130.4 nm triplet feature)')")
        case ('1356    ')
          write(flds_known(n)%fname56,
     +      "('O EXCITATION RATE (135.6 nm)')")
        case ('5577    ')
          write(flds_known(n)%fname56,
     +      "('O EXCITATION RATE (557.7 nm)')")
        case ('6300    ')
          write(flds_known(n)%fname56,
     +      "('O EXCITATION RATE (630.0 nm)')")
        case ('834E    ')
          write(flds_known(n)%fname56,
     +      "('O-E EXCITATION RATE (83.4 nm)')")
        case ('834SOL  ')
          write(flds_known(n)%fname56,
     +      "('O-SOL EXCITATION RATE (83.4 nm)')")
        case ('OPLS2D  ')
          write(flds_known(n)%fname56,
     +      "('O (OPLS2D) EXCITATION RATE (372.6 nm)')")
        case ('OPLS2P  ')
          write(flds_known(n)%fname56,
     +      "('O (OPLS2P) EXCITATION RATE (247.0 nm)')")
        case default 
          write(flds_known(n)%fname56,"(a)") flds_known(n)%fname8
        end select
        n = n+1
      enddo
!
!------------------ begin OH vib levels and emissions ----------------
!
! Note OH-V and OH-B fields are calculated in height only 
!   (see vtype, nlev, blev, dlev)
!
! 10 vibrational levels of OH (0-9) (first is ground state, level 0):
! OH vibrational states are dependent on t, o2, o, n2, h, o3, ho2, oh:
!
      do i=0,nohvlev-1
        write(flds_known(n)%fname56,"('OH VIBRATIONAL LEVEL ',i1)") i
        write(flds_known(n)%fname8,"('OHV-',i1)") i
        flds_known(n)%type   =  'OH-VIB          '
        flds_known(n)%units  =  'CM-3            '
        allocate(flds_known(n)%fneed(7),stat=ier)
        if (ier /= 0) call allocerr(ier,'allocating fneed for OH-VIB')
        write(flds_known(n)%fneed(1),"('TN      ')") 
        write(flds_known(n)%fneed(2),"('O2      ')") 
        write(flds_known(n)%fneed(3),"('O1      ')") 
        write(flds_known(n)%fneed(4),"('H       ')") 
        write(flds_known(n)%fneed(5),"('O3      ')") 
        write(flds_known(n)%fneed(6),"('HO2     ')") 
        write(flds_known(n)%fneed(7),"('OH      ')") 
        flds_known(n)%derived = .TRUE.
        flds_known(n)%vtype = 'HEIGHT  '
        flds_known(n)%nlev = nohalt
        flds_known(n)%blev = oh_kmbot
        flds_known(n)%dlev = 1.
        n = n+1
        if (n > mxfknown) then
          write(6,"('>>> fset_known: too many known fields: ',
     +      'mxfknown=',i3,' (making OH-VIB)')") mxfknown
          stop 'mxfknown'
        endif
      enddo 
!
! There are 39 (nohband) OH band emissions:
!     1-0 2-1 3-2 4-3 5-4 6-5 7-6 8-7 9-8
!         2-0 3-1 4-2 5-3 6-4 7-5 8-6 9-7
!             3-0 4-1 5-2 6-3 7-4 8-5 9-6
!                 4-0 5-1 6-2 7-3 8-4 9-5
!                     5-0 6-1 7-2 8-3 9-4
!                         6-0 7-1 8-2 9-3
! OH band emissions are dependent on t, o2, o, n2, h, o3, ho2, oh:
!
      do hi=9,1,-1
        loloop: do lo=0,hi-1
          if (hi > 5 .and. lo < hi-6) cycle loloop
          write(flds_known(n)%fname56,"('OH EMISSION BAND ',
     +      i1,'-',i1)") hi,lo
          write(flds_known(n)%fname8,"('OHB-',2i1)") hi,lo
          flds_known(n)%type   =  'OH-BAND         '
          flds_known(n)%units  =  'PHOTONS/CM3/SEC '
          allocate(flds_known(n)%fneed(7),stat=ier)
          if (ier /= 0) call allocerr(ier,
     +      'allocating fneed for OH-BAND')
          write(flds_known(n)%fneed(1),"('TN      ')") 
          write(flds_known(n)%fneed(2),"('O2      ')") 
          write(flds_known(n)%fneed(3),"('O1      ')") 
          write(flds_known(n)%fneed(4),"('H       ')") 
          write(flds_known(n)%fneed(5),"('O3      ')") 
          write(flds_known(n)%fneed(6),"('HO2     ')") 
          write(flds_known(n)%fneed(7),"('OH      ')") 
          flds_known(n)%derived = .TRUE.
          flds_known(n)%vtype = 'HEIGHT  '
          flds_known(n)%nlev = nohalt
          flds_known(n)%blev = oh_kmbot
          flds_known(n)%dlev = 1.
          n = n+1
          if (n > mxfknown) then
            write(6,"('>>> fset_known: too many known fields: ',
     +        'mxfknown=',i3,' (making OH-BAND)')") mxfknown
            stop 'mxfknown'
          endif
        enddo loloop
      enddo	! hi=9,1,-1
!------------------ end OH vib levels and emissions ----------------
! ----------------- begin NA partitions -------------------------
!
! The following 13 (mxnaf) fields are partitioned from NAT by napart.f:
!   (see local na_names(mxnaf))
!     'NaS     ','NaO     ','NaO3    ','NaO2    ','NaOH    ',
!     'NaCO3   ','NaHCO3  ','NaS+    ','NaN2+   ','NaCO2+  ',
!     'NaH2O+  ','NaO+    ','NaEMIS  '
! These have the following 13 dependencies:
!   TN, O2, H2O, CO2, H, H2, O1, O3, NE, O2+ [NO+], O+, N2 NAT 
!   (If NO+ is not available on histories, napart will use 
!    NO+ = (Ne - O+ - O2+))
!   (NAT is "total sodium" from the history)
!
      if (n+mxnaf > mxfknown) then
        write(6,"('>>> fset_known: too many known fields: ',
     +    '(setting NA partitions)')")
        stop 'mxfknown'
      endif
      do i=1,mxnaf
        flds_known(n)%fname8(1:8) = na_names(i)
        write(flds_known(n)%fname56,"(a,' (Sodium sp.)')")
     +    trim(na_names(i))
        flds_known(n)%type   =  'DENSITY         '
        if (trim(flds_known(n)%fname8)=='NaEMIS')
     +    flds_known(n)%type   =  'EMISSION        '
! its only coicidental that number of Na dependencies == mxnaf == 13
        allocate(flds_known(n)%fneed(13),stat=ier)
        if (ier /= 0) then
          write(6,"('>>> fset_known: error allocating dependencies',
     +      ' for na partition: i=',i2,' (',a,')')") i,na_names(i)
          call allocerr(ier,'allocating fneed for Na')
        endif
!
! Note the order of these dependencies is critical for napart call
! from getna.
!   TN, O2, H2O, CO2, H, H2, O1, O3, NE, O2+ O+, N2 NAT 
!
        write(flds_known(n)%fneed(1), "('TN      ')") 
        write(flds_known(n)%fneed(2), "('O2      ')") 
        write(flds_known(n)%fneed(3), "('H2O     ')") 
        write(flds_known(n)%fneed(4), "('CO2     ')") 
        write(flds_known(n)%fneed(5), "('H       ')") 
        write(flds_known(n)%fneed(6), "('H2      ')") 
        write(flds_known(n)%fneed(7), "('O1      ')") 
        write(flds_known(n)%fneed(8), "('O3      ')") 
        write(flds_known(n)%fneed(9), "('NE      ')") 
        write(flds_known(n)%fneed(10),"('O2+     ')") 
        write(flds_known(n)%fneed(11),"('O+      ')") 
        write(flds_known(n)%fneed(12),"('N2      ')") 
        write(flds_known(n)%fneed(13),"('NAT     ')") 
        flds_known(n)%derived = .TRUE.
        n = n+1
      enddo
!
! ------------------- end NA partitions -------------------------
!
! O/CO2:
      write(flds_known(n)%fname56,"('RATIO O/CO2')")
      flds_known(n)%fname8 =  'O/CO2   '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =  '                '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for O/CO2')
      write(flds_known(n)%fneed(1),"('O1      ')") 
      write(flds_known(n)%fneed(2),"('CO2     ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! O/N2:
      write(flds_known(n)%fname56,"('RATIO O/N2')")
      flds_known(n)%fname8 =  'O/N2    '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =  '                '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for O/N2')
      write(flds_known(n)%fneed(1),"('O1      ')") 
      write(flds_known(n)%fneed(2),"('N2      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! N2/O:
      write(flds_known(n)%fname56,"('RATIO N2/O')")
      flds_known(n)%fname8 =  'N2/O    '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =  '                '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for N2/O')
      write(flds_known(n)%fneed(1),"('O1      ')") 
      write(flds_known(n)%fneed(2),"('N2      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! O/O2+N2:
      write(flds_known(n)%fname56,"('RATIO O/O2+N2')")
      flds_known(n)%fname8 =  'O/O2+N2 '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =  '                '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for O/O2+N2')
      write(flds_known(n)%fneed(1),"('O1      ')") 
      write(flds_known(n)%fneed(2),"('O2      ')") 
      write(flds_known(n)%fneed(3),"('N2      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! O/O2:
      write(flds_known(n)%fname56,"('RATIO O/O2')")
      flds_known(n)%fname8 =  'O/O2 '
      flds_known(n)%type   =  'RATIO           '
      flds_known(n)%units  =  '                '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for O/O2')
      write(flds_known(n)%fneed(1),"('O1      ')") 
      write(flds_known(n)%fneed(2),"('O2      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! Eliassen-palm flux vectors (for Hanli Liu gravity waves) (s.a. epflux.f):
!
! EP flux Y:
      write(flds_known(n)%fname56,"('ELIASSEN-PALM FLUX VECTOR (Y)')")
      flds_known(n)%fname8 =  'EPVY    '
      flds_known(n)%type   =  'EPFLUX          '
      flds_known(n)%units  =  'M^2/SEC^2       '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for EPVY')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('UN      ')") 
      write(flds_known(n)%fneed(3),"('VN      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! EP flux Z:
      write(flds_known(n)%fname56,"('ELIASSEN-PALM FLUX VECTOR (Z)')")
      flds_known(n)%fname8 =  'EPVZ    '
      flds_known(n)%type   =  'EPFLUX          '
      flds_known(n)%units  =  'M^2/SEC^2       '
      allocate(flds_known(n)%fneed(4),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for EPVZ')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('UN      ')") 
      write(flds_known(n)%fneed(3),"('VN      ')") 
      write(flds_known(n)%fneed(4),"('W       ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! EP flux divergence (Y and Z forcing):
      write(flds_known(n)%fname56,
     +  "('ELIASSEN-PALM FLUX FORCING (DIV)')")
      flds_known(n)%fname8 =  'EPVDIV  '
      flds_known(n)%type   =  'EPFLUX          '
      flds_known(n)%units  =  'M/SEC/DAY       '
      allocate(flds_known(n)%fneed(5),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for EPVDIV')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('UN      ')") 
      write(flds_known(n)%fneed(3),"('VN      ')") 
      write(flds_known(n)%fneed(4),"('W       ')") 
      write(flds_known(n)%fneed(5),"('RHO     ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! EPVYZ: vectors EPVY+EPVZ (vector arrow plots, lon slices only)
!
      write(flds_known(n)%fname56,"('EPY+EPZ VECTORS')")
      flds_known(n)%fname8 =  'EPVYZ   '
      flds_known(n)%type   =  'EPFLUX          '
      flds_known(n)%units  =  'M^2/SEC^2       '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for epvyz')
      write(flds_known(n)%fneed(1),"('EPVY    ')") 
      write(flds_known(n)%fneed(2),"('EPVZ    ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! EPVYZMAG: vectors EPVY+EPVZ (contour magnitudes)
!
      write(flds_known(n)%fname56,"('EPY+EPZ VECTOR MAGNITUDE')")
      flds_known(n)%fname8 =  'EPVYZMAG'
      flds_known(n)%type   =  'EPFLUX          '
      flds_known(n)%units  =  'M^2/SEC^2       '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for epvyzmag')
      write(flds_known(n)%fneed(1),"('EPVY    ')") 
      write(flds_known(n)%fneed(2),"('EPVZ    ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! QBARY:
!
      write(flds_known(n)%fname56,"('QBARY')")
      flds_known(n)%fname8 =  'QBARY   '
      flds_known(n)%type   =  'QBARY           '
      flds_known(n)%units  =  'm-1/s-1         '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for qbary')
      write(flds_known(n)%fneed(1),"('TN      ')") 
      write(flds_known(n)%fneed(2),"('UN      ')") 
      write(flds_known(n)%fneed(3),"('RHO     ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! QH: horizontal component of QBARY:
!
      write(flds_known(n)%fname56,
     +  "('QH (HORIZONTAL COMPONENT OF QBARY)')")
      flds_known(n)%fname8 =  'QH      '
      flds_known(n)%type   =  'QBARY           '
      flds_known(n)%units  =  'm-1/s-1         '
      allocate(flds_known(n)%fneed(1),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for qh')
      write(flds_known(n)%fneed(1),"('QBARY   ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! QV: vertical component of QBARY:
!
      write(flds_known(n)%fname56,
     +  "('QV (VERTICAL COMPONENT OF QBARY)')")
      flds_known(n)%fname8 =  'QV      '
      flds_known(n)%type   =  'QBARY           '
      flds_known(n)%units  =  'm-1/s-1         '
      allocate(flds_known(n)%fneed(1),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for qv')
      write(flds_known(n)%fneed(1),"('QBARY   ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! HTOT: 2*h2o+h+oh+ho2+4*ch4+2*h2
! (always vol mix ratio -- see sub denconvert and dunits below)
!
      write(flds_known(n)%fname56,"('HYDROGEN ', 
     +  '(2*H2O+H+OH+HO2+4*CH4+2*H2)')")
      flds_known(n)%fname8 =  'HTOT    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'CM3-MR          '
      allocate(flds_known(n)%fneed(6),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for htot')
      write(flds_known(n)%fneed(1),"('H2O     ')")
      write(flds_known(n)%fneed(2),"('H       ')")
      write(flds_known(n)%fneed(3),"('OH      ')")
      write(flds_known(n)%fneed(4),"('HO2     ')")
      write(flds_known(n)%fneed(5),"('CH4     ')")
      write(flds_known(n)%fneed(6),"('H2      ')")
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! CTOT: CO+CO2+CH4 volume mixing ratio:
! (always vol mix ratio -- see sub denconvert)
!
      write(flds_known(n)%fname56,"('TOTAL CARBON (CO+CO2+CH4)')")
      flds_known(n)%fname8 =  'CTOT    '
      flds_known(n)%type   =  'DENSITY         '
      flds_known(n)%units  =  'CM3-MR          '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for htot')
      write(flds_known(n)%fneed(1),"('CO      ')")
      write(flds_known(n)%fneed(2),"('CO2     ')")
      write(flds_known(n)%fneed(3),"('CH4     ')")
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! Pressure (mb): Will use p=nkT over 3d grid (field 151).
!
      write(flds_known(n)%fname56,"('PRESSURE')")
      flds_known(n)%fname8 =  'PMB     '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'Mb              '
      allocate(flds_known(n)%fneed(3),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for pmb')
      write(flds_known(n)%fneed(1),"('O2      ')") 
      write(flds_known(n)%fneed(2),"('O1      ')") 
      write(flds_known(n)%fneed(3),"('TN      ')") 
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! Neutral temperature freeze point:
!
      write(flds_known(n)%fname56,
     |  "('NEUTRAL TEMPERATURE FROST POINT')")
      flds_known(n)%fname8 =  'TNFP    '
      flds_known(n)%type   =  'SCALAR          '
      flds_known(n)%units  =  'deg K           '
      allocate(flds_known(n)%fneed(2),stat=ier)
      if (ier /= 0) call allocerr(ier,'allocating fneed for tnfp')
      write(flds_known(n)%fneed(1),"('H2O     ')")
      write(flds_known(n)%fneed(2),"('TN      ')")
      flds_known(n)%derived = .TRUE.
      n = n+1
!
! End definitions of known fields:
      nfknown = n-1
      write(6,"('There are ',i4,' fields known to the processor,',
     |  ' (mxfknown=',i4,')')") nfknown,mxfknown
!
! Set density units according to iden input flag:
! (note non-derived DENSITY fields w/ wt==0. are in cm-3 on history,
!  i.e., O+, O2+, and NE) (HTOT and CTOT are always vol mix ratio)
!     character(len=len_units),save :: dunits(ndunits) = 
!    +  (/'MMR     ','CM3     ','CM3-MR  ','GM/CM3  '/)
!
      do i=1,nfknown
        if (trim(flds_known(i)%type) == 'DENSITY'.and.
     +    (flds_known(i)%fname8 /= 'HTOT    '.and.
     +     flds_known(i)%fname8 /= 'CTOT    ')) then
          if (flds_known(i)%wt > 0.) then
            flds_known(i)%units = dunits(iden+1)
          else
            flds_known(i)%units = dunits(2)
          endif
        endif
      enddo 
!     call printfields_table(flds_known,nfknown)
      return
      end
