c
      subroutine sendms(dskfile,msspath)
      character*(*) dskfile,msspath
      character*80 msserr
      integer,parameter :: mxlen=1024
      character(len=mxlen) :: dcs_output
c
c Send local file dskfile to mss at msspath. This is a simple
c version of putms.
c
c If both args are zero-length, give error msg and return:
c
      lmsspath = len_trim(msspath)
c
c If msspath not given (zero-length), file is disposed by msrcp
c to /USER/dskfile, where USER will be the upper-case name of the 
c user, i.e., their MSS root directory:
c
      if (lmsspath.le.0) then
        write(6,"(/'>>> sendms: zero length msspath -- ',
     +    'will dispose mss /USER/',a,', where ',/12x,
     +    ' USER is your MSS root directory (your login ',
     +    'name in upper case).')") trim(dskfile)
        call msrcp(ier,trim(dskfile),dcs_output)
        if (ier.ne.0) then
          write(6,"('>>> error ',i4,' from msrcp of ',
     +      'local file ',a,' (zero-length msspath)')")
     +      ier,trim(dskfile)
        else
          write(6,"('Wrote local file ',a,' to mss (under /USER,',
     +      ' where USER is your login name in upper case)')")
     +      trim(dskfile)
          write(6,"('(A retention period of 30 days was used)')")
        endif
        return
      endif
c
c Both dskfile and msspath were given:
c
      call msrcp(ier,trim(dskfile)//' mss:'//trim(msspath),
     |  dcs_output)
      if (ier.ne.0) then
        write(6,"('>>> sendms: error ',i4,' from msrcp of ',
     |    'local file ',a,' to mss file ',a)")
     |    ier,trim(dskfile),trim(msspath)
      else
        write(6,"('Successful msrcp of ',a,' to mss:',a)")
     |    trim(dskfile),trim(msspath)
      endif
      return
      end
