!
      subroutine setloctype(usrlat,usrlon,ut,glat,glon,slt,
     +  ixlat,ixlon,loctype)
!
! On input:
!   usrlat,usrlon: user's requested location:
!     If user wants lat,lon,       then usrlat==lat, usrlon==lon
!     If user wants global means,  then usrlat==usrlon==zmflag
!     If user wants zonal means,   then usrlat==lat, usrlon==zmflag
!     If user wants local time xx, then usrlat==lat, usrlon=='LTxx'
! On output:
!   If global means: loctype=='gm ', glat==glon==zmflag, slt==spval
!   If zonal  means: loctype=='zm ', glat==lat, glon==zmflag, slt==spval
!   If local time xx:loctype=='slt', glat==lat, glon==lon at slt xx
!   If lat,lon      :loctype=='lon', glat==lat, glon==lon
!   If glat is a latitude, ixlat is index to glat in gcmlat(nlat)
!   If glon is a longitude,ixlon is index to glon in gcmlon(nlat)
!
      use proc
!
! Args:
      real(kind=8),intent(in) :: usrlat,usrlon
      real,intent(in) :: ut
      real,intent(out) :: glat,glon,slt
      integer,intent(out) :: ixlat,ixlon
      character(len=3),intent(out) :: loctype
!
! Locals:
      real :: tmpslt
!
! Externals:
      real,external :: fslt
      integer,external :: ixfind
      logical,external :: isslt
!
      loctype = '   '
      ixlat = 0 ; ixlon = 0
      glat = spval ; glon = spval ; slt = spval
!
! Global means:
      if (usrlat==real(zmflag,kind(usrlat)).and.
     |    usrlon==real(zmflag,kind(usrlon))) then
        loctype = 'gm '
        glat = zmflag
        glon = zmflag
!
! Zonal means:
      elseif (usrlon==real(zmflag,kind(usrlon))) then
        loctype = 'zm '
        glon = zmflag
!
! Regular longitude or local time:
      else
        if (isslt(usrlon,tmpslt)) then	! is local time
          loctype = 'slt'
          glon = fslt(tmpslt,ut,dum,3)
          ixlon = ixfind(gcmlon,nlon,glon,dlon)
          glon = gcmlon(ixlon)
          slt = tmpslt
        else				! is regular longitude
          loctype = 'lon'
          glon = real(usrlon,kind(glon))
          ixlon = ixfind(gcmlon,nlon,glon,dlon)
          slt = fslt(dum,ut,glon,1)
        endif
      endif
!
! Set latitude if not global means:
      if (loctype /= 'gm ') then
        glat = real(usrlat,kind(glat))
        ixlat = ixfind(gcmlat,nlat,glat,dlat)
      endif
      end subroutine setloctype
