!
      subroutine opnwrk(appid,
     +  flnm_cgm,   iwk_cgm,   igks_cgm,
     +  flnm_ps,    iwk_ps,    igks_ps,  psmode, 
     +              iwk_x11,   igks_x11, icolor)
      implicit none
!
! Open gks and ncarg workstations via hlu lib.
!
! On input:
!   flnm_cgm = file name for cgm metacode
!   flnm_ps = file name for ps
!   if iwk_cgm > 0 -> make cgm workstation
!   if iwk_ps > 0 -> make ps workstation
!   if icolor > 0 -> ps workstations set for color
!   if psmode = 'land' -> ps workstation will be in landscape mode
!   if psmode = 'port' -> ps workstation will be in portrait mode
! On output:
!   appid is ncarg application id
!   if iwk_cgm was > 0 on input, then:
!     iwk_cgm = ncarg workstation id for cgm
!     igks_cgm = gks workstation for cgm
!   if iwk_ps was > 0 on input, then:
!     iwk_ps = ncarg workstation id for ps
!     igks_ps = gks workstation for ps
!
! Args:
      character(len=*),intent(in) :: flnm_cgm,flnm_ps,psmode
      integer,intent(out) :: appid
      integer,intent(out) ::   igks_cgm, igks_ps, igks_x11
      integer,intent(inout) :: iwk_cgm,  iwk_ps,  iwk_x11
      integer,intent(in) :: icolor
      external NhlFAppClass
      external NhlFNcgmWorkstationClass
      external NhlFPSWorkstationClass
      external NhlFXWorkstationClass
!
! Locals:
      integer :: list,glist,ier
!
! Create resource list and application:
!
      call NhlFInitialize
      call NhlFRLCreate(list,'setrl')
      call NhlFRLCLear(list)
      call NhlFRLSetString(list,'appDefaultParent','True',ier)
      call NhlFRLSetString(list,'appUsrDir','./',ier)
      call NhlFCreate(appid,'tgcmproc',NhlFAppClass,0,0,ier)
!
! Init:
!
      igks_cgm = 0
      igks_ps = 0
!
! Create ncgm workstation iwk_cgm, and get igks_cgm:
!
      call NhlFRLCreate(glist,'getrl')
      if (iwk_cgm > 0) then
        call NhlFRLCLear(list)
        call NhlFRLSetString(list,'wkMetaName',trim(flnm_cgm),ier)
        call NhlFCreate(iwk_cgm,'wrksta_cgm',NhlFNcgmWorkstationClass,
     +    0,list,ier)
        call NhlFRLClear(glist)
        call NhlFRLGetInteger(glist,'wkGksWorkId',igks_cgm,ier)
        call NhlFGetValues(iwk_cgm,glist,ier)
        write(6,"('Opened ',a,': iwk_cgm=',i3,' igks_cgm=',
     +    i3)") trim(flnm_cgm),iwk_cgm,igks_cgm
        if (igks_cgm==0) then
          write(6,"('Error opening gks: igks_cgm=',i2)") igks_cgm
        endif
      endif
!
! Create ps workstation iwk_ps, and get igks_ps:
! (Landscape or portrait according to psmode)
! (the PSResolution setting is to overcome a roundoff bug in ncarg4 that
!  affects positioning, found by Fred Clare and Jeff Boote)
!
      if (iwk_ps > 0) then
        call NhlFRLCLear(list)
        call NhlFRLSetString(list,'wkPSFileName',trim(flnm_ps),ier)
        call NhlFRLSetInteger(list,'wkPSResolution',1799,ier)
        if (trim(psmode).eq.'land') then
          call NhlFRLSetString(list,'wkOrientation','landscape',ier)
        else
          call NhlFRLSetString(list,'wkOrientation','portrait',ier)
        endif
!
! 5/8/96: use color ps driver only (bug in monochrome ps driver 
!         results in solid black contour line label boxes)
!
!       if (icolor <= 0) then
!         call NhlFRLSetString(list,'wkVisualType','monochrome',ier)
!       else
          call NhlFRLSetString(list,'wkVisualType','color',ier)
!       endif
!
! Default position on the page is a centered square at
!   lx,ly=36,126, ux,uy=576,666
!
        call NhlFCreate(iwk_ps,'wrksta_ps',
     +    NhlFPSWorkstationClass,0,list,ier)
        call NhlFRLClear(glist)
        call NhlFRLGetInteger(glist,'wkGksWorkId',igks_ps,ier)
        call NhlFGetValues(iwk_ps,glist,ier)
        write(6,"('Opened ',a,' iwk_ps=',i3,
     +    ' igks_ps=',i3,' icolor=',i1,' psmode=',a)")
     +    trim(flnm_ps),iwk_ps,igks_ps,icolor,trim(psmode)
      endif
!
! X11 workstation:
!
      if (iwk_x11 > 0) then
        call NhlFRLClear(list)
        call NhlFRLSetstring(list,'wkPause','True',ier)
        call NhlFCreate(iwk_x11,'wrksta_x11',NhlFXWorkstationClass,
     +    0,list,ier)
        call NhlFRLClear(glist)
        call NhlFRLGetInteger(glist,'wkGksWorkId',igks_x11,ier)
        call NhlFGetValues(iwk_x11,glist,ier)
        write(6,"('Opened X11 workstation: iwk_x11=',i3,' igks_x11=',
     +    i3)") iwk_x11,igks_x11
      endif
      return
      end
