
      module proc_lat
      implicit none
      contains
!-----------------------------------------------------------------------
      subroutine proclat(flat,fproc,f,nf,h,imx,kmx,lat,modelhts,iprint)
!
! Processing for "new" history file format (11/05 and later for tiegcm):
!
      use hist,only: history	! use only history type-def
      use fields,only: field	! use only field type-def
      use netcdf_module,only: tlbc,ulbc,vlbc
!
! Args:
      type(history),intent(in) :: h	! the current history
      integer,intent(in) :: nf		! number of field structs
      type(field),intent(inout) :: f(nf)	! field structs
      integer,intent(in) :: imx,kmx	! number of lons and zp levels
      real,intent(inout) :: flat(imx,kmx,h%nflds)   ! the current lat slice
      character(len=8),intent(in) :: fproc(h%nflds) ! fields to be processed
      integer,intent(in) :: lat		! current lat index
      integer,intent(in) :: modelhts	! heights flag (from input)
      integer,intent(in) :: iprint	! print flag (currently levels 0 or 1)
!
! Local:
      integer :: i,ix,ixproc,ixf,k,ixo1,ixo2,ixt,ixz
      real :: raw_tn(imx,kmx),raw_o1(imx,kmx),raw_o2(imx,kmx),
     |        raw_z(imx,kmx)
      real,parameter :: eps=1.e-12
!     real :: pzps(kmx)		! scale heights
!
! Externals:
      integer,external :: ixfindc
!
! Define needed field indices in flat:
! (these fields were confirmed on the history by verify_hist)
!
      ixo1 = ixfindc(h%fnames,h%nflds,'O1      ')
      where(flat(:,:,ixo1) < 0.) flat(:,:,ixo1) = eps
      raw_o1(:,:) = flat(:,:,ixo1)
      ixo2 = ixfindc(h%fnames,h%nflds,'O2      ')
      raw_o2(:,:) = flat(:,:,ixo2)
      ixt  = ixfindc(h%fnames,h%nflds,'TN      ')
      raw_tn(:,:) = flat(:,:,ixt)
      ixz  = ixfindc(h%fnames,h%nflds,'Z       ')
      raw_z(:,:) = flat(:,:,ixz)
!
      fields_loop: do ix=1,h%nflds
        ixproc = ixfindc(fproc,h%nflds,h%fnames(ix))
        ixf    = ixfindc(f%fname8,nf,h%fnames(ix))
!       write(6,"('proclat: field ',a,' ix=',i3,' ixproc=',i3,' ixf=',
!    |    i3)") h%fnames(ix),ix,ixproc,ixf
     
        if (ixproc == 0) cycle fields_loop
!
! Select on field to be processed:
!
        select case (h%fnames(ix))
!
! For TN,UN,VN, the default behavior is to shift to interfaces, and use 
!   TLBC,ULBC,VLBC for the bottom interface boundary. If this is overridden
!   by user request (zptype_req), then leave them at midpoints.
!   (assume values at kmx are missing, do not change them)
! If switching zptype is requested for other fields (including derived), 
!   it will be done later by sub set_zptype (getflds.F).
!
          case ('TN      ')
            if (ixf==0.or.
     |        (ixf>0.and.trim(f(ixf)%zptype_req)=='INTERFACES')) then
              do k=kmx-1,2,-1
                flat(:,k,ix) = 0.5*(flat(:,k,ix)+flat(:,k-1,ix))
              enddo
              flat(:,1,ix) = tlbc(:,lat)
              if (lat==1) write(6,"('proclat interp TN to interfaces')")
            else ! leave at midpoints
              f(ixf)%zptype = 'MIDPOINTS'
              f(ixf)%lev = h%lev 
              if (lat==1) write(6,"('proclat leaving TN at midpoints')")
            endif
!
! For UN, use ULBC for bottom boundary, and shift to interfaces:
! (assume values at kmx are missing, do not change them)
          case ('UN      ')
            if (ixf==0.or.
     |        (ixf>0.and.trim(f(ixf)%zptype_req)=='INTERFACES')) then
              do k=kmx-1,2,-1
                flat(:,k,ix) = 0.5*(flat(:,k,ix)+flat(:,k-1,ix))*.01
              enddo
              flat(:,1,ix) = ulbc(:,lat)*.01
              if (lat==1) write(6,"('proclat interp UN to interfaces')")
            else ! leave at midpoints
              f(ixf)%zptype = 'MIDPOINTS'
              f(ixf)%lev = h%lev 
              flat(:,:,ix) = flat(:,:,ix)*.01 ! cm to m
              if (lat==1) write(6,"('proclat leaving UN at midpoints')")
            endif
!
! For VN, use VLBC for bottom boundary, and shift to interfaces:
! (assume values at kmx are missing, do not change them)
          case ('VN      ')
            if (ixf==0.or.
     |        (ixf>0.and.trim(f(ixf)%zptype_req)=='INTERFACES')) then
              do k=kmx-1,2,-1
                flat(:,k,ix) = 0.5*(flat(:,k,ix)+flat(:,k-1,ix))*.01
              enddo
              flat(:,1,ix) = vlbc(:,lat)*.01
              if (lat==1) write(6,"('proclat interp VN to interfaces')")
            else ! leave at midpoints
              f(ixf)%zptype = 'MIDPOINTS'
              f(ixf)%lev = h%lev 
              flat(:,:,ix) = flat(:,:,ix)*.01 ! cm to m
              if (lat==1) write(6,"('proclat leaving VN at midpoints')")
            endif
!
! W = vertical velocity:
!         case ('W       ')
!           do i=1,imx
!             do k=2,kmx-1
!               pzps(k) = raw_z(i,k+1)-raw_z(i,k-1)
!             enddo
!             pzps(1) = 4.*raw_z(i,2)-3.*raw_z(i,1)-raw_z(i,3)
!             pzps(kmx) = 3.*raw_z(i,kmx)-4.*raw_z(i,kmx-1)+
!    |          raw_z(i,kmx-2)
!             flat(i,:,ix) = flat(i,:,ix)*pzps(:)
!           enddo
!           flat(imx,:,ix) = flat(1,:,ix)       ! force periodic point
!           flat(:,:,ix) = flat(:,:,ix) * .01   ! cm/s to m/s
!
! Recalculate Z using varying gravity if requested. Convert from cm to km.
          case ('Z       ')
            if (modelhts > 0) then	          ! use heights on history
              flat(:,:,ix) = flat(:,:,ix) * 1.e-5 ! cm to km
            else
              call calchts ! recalculate using varying gravity
            endif
!
! ZG is geopotential with varying gravity (only on new histories):
          case ('ZG      ')
            flat(:,:,ix) = flat(:,:,ix) * 1.e-5
          case default
        end select
      enddo fields_loop
      return	! return from proclat
!
! Subroutines internal to proclat:
      contains
!-------------------------------------------------------------------
      subroutine calchts
!
! Calculate heights from mean mass, with gravity varying w/ height:
! 5/25/05 btf: new sub calchts from liying (lqian), to include
!              latitudinally varying gravity (sub glatf). This
!              is included in tgcmproc1.7.
!
      real :: g0,r0,c2
      real :: g(kmx),xmas(kmx),dz
      real :: ftn(kmx),fo2(kmx),fo1(kmx),fn2(kmx)
      real,parameter :: dgtr=1.74533E-2
      real,parameter :: boltz=1.38e-16
      integer :: i
!
! Calculate latitude dependent g0 (at Earth surface) and Earth radius r0
      c2 = cos(2.*dgtr*lat)
      g0 = 980.616*(1.-.0026373*C2)
      r0 = 2.*g0/(3.085462e-6 + 2.27e-9*c2)
      dz=(h%zpt-h%zpb)/float(kmx-1)
      do i=1,imx
!
! Process t,o2,o1,n2 and store in locals ftn,fo2,fo1,fn2:
! ftn,fo1,fo2,fn2 are values at model midpoint
	ftn(:)=raw_tn(i,:)
	fo1(:)=raw_o1(i,:)
	fo2(:)=raw_o2(i,:)
        fn2(:) = max(.00001,(1.-fo2(:)-fo1(:)))
!
! Get mean mass and calculate new heights:
! Note bottom boundary has already been read from the history. 
! xmas and g are values at model midpoint as well
!
        xmas(:) = 1./(fo1(:)/16.+fo2(:)/32.+fn2(:)/28.)*1.66e-24
        g(1)=g0*(r0/(r0+0.5*(flat(i,1,ix)+flat(i,2,ix))))**2
        do k=2,kmx
          flat(i,k,ix) = flat(i,k-1,ix) + boltz*dz*
     +      ftn(k-1) / (xmas(k-1)*g(k-1))
          g(k)=g0*(r0/(r0+0.5*(flat(i,k,ix)+flat(i,k+1,ix))))**2
        enddo
        flat(i,:,ix) = flat(i,:,ix) * 1.e-5 ! cm to km
      enddo 
      return
      end subroutine calchts
      end subroutine proclat
!-------------------------------------------------------------------
      end module proc_lat
