c
      subroutine addfsech(fname,f,idim1,idim2,ndim2,ilat)
      implicit none
      include "params.h"
      include "cons.h"
      include "sechis.h"
c
c Add latitude slice of diagnostic history field f to secondary 
c   histories direct access save file (attached to lusech1).
c
c On input:
c   fname = character name of field to be added (<= 8 chars)
c   real f(idim1,idim2) = field values
c   idim1,idim2 = dimension of f (should be zimxp,zkmxp)
c   ndim2 = number of 2nd dimension values (starting at 1) defined in f 
c     (if ndim2 < idim2, then f(:,ndim2+1:idim2) is given spval)
c   ilat = j index of current latitude
c
c On output:
c   If it's time to write a secondary history (ihissech==0), and fname 
c     is found in secflds (requested secondary histories list), then
c     field f is written to direct access file connected to unit lusech1.
c     The record number to this file is (ixfsech-1)*zjmx+ilat, where
c       ixfsech is index to diagnostic (non-primary) fields in secflds.
c     (e.g., if SECFLDS=TN,O2,QSOLAR,W,QTOTAL then ixfsech=1 for QSOLAR, 
c      and ixfsech=2 for QTOTAL)
c   If fname is not found in secflds or ihissech > 0, this routine does 
c     NOT write to lusech1.
c   If field was written to lusech1, then secflds_hist(i) is defined
c     with secflds(i).
c
! Args:
      integer,intent(in) :: idim1,idim2,ndim2,ilat
      character(len=*),intent(in) :: fname
      real,intent(in) :: f(idim1,idim2)
!
! Local:
      integer :: lfname,ixfsech,i,isecflds,irec
      integer,external :: ixfindc,ixfindr
      real :: f2d(idim1,idim2)
c
c Return if not time to write a secondary history (note ihissech was
c decremented in advnce before main j-loop):
c
      if (ihissech.gt.0) return
c
c Check inputs:
c
      lfname = len_trim(fname)
      if (lfname.eq.0) then
        write(6,"('>>> addfsech: zero length field name -- returning')")
        return
      elseif (lfname.gt.8) then
        write(6,"('>>> WARNING addfsech: fname should be <= 8 chars')")
        lfname = 8
      endif
      if (ilat.lt.1.or.ilat.gt.zjmx) then
        write(6,"('>>> WARNING addfsech: bad ilat=',i5,
     +    ' -- returning')") ilat
        return
      endif
      if (idim1.ne.zimxp.or.idim2.ne.zkmxp) then
        write(6,"('>>> WARNING addfsech: bad idim1=',i3,
     +    ' or bad idim2=',i3,/'  (idim1 must equal zimxp=',i3,
     +    ' and idim2 must equal zkmxp=',i3)") idim1,idim2,
     +    zimxp,zkmxp
        return
      endif
c
c Do nothing if fname not in list of requested secondary history fields:
c
      ixfsech = ixfindc(secflds,mxfsech,fname(1:lfname))
      if (ixfsech.le.0) then
        if (ilat.eq.1)
     +    write(6,"('Note addfsech: skipping field ',a,' (not found',
     +      ' in SECFLDS)')") fname
        return
      endif
c
c Pad 2nd dimension of f(idim1,idim2) w/ spval if necessary:
! 5/00: use local f2d rather than writing into input array.
c
      f2d = f
      if (ndim2.gt.0.and.ndim2.lt.idim2) then
        do i=ndim2+1,idim2
          f2d(:,i) = spval
        enddo
      endif
c
c ixfsech will be index to field on lusech1 (nth non-primary field in
c secflds), and irec will be record number on lusech1:
c
      ixfsech = 0
      do i=1,nfsech
        if (ixfindr(fproc_names,nfproc,secflds(i)).eq.0) then
          ixfsech = ixfsech+1
          isecflds = i
          if (fname(1:lfname).eq.secflds(i)(1:len_trim(secflds(i)))) 
     +      goto 100
        endif 
      enddo
      if (ilat.eq.1)
     +  write(6,"('>>> WARNING addfsech: field ',a,' not found ',
     +    'in SECFLDS')") fname(1:lfname)
 100  continue
      irec = (ixfsech-1)*zjmx+ilat	! record on lusech1
      write(lusech1,rec=irec) f2d
c
c Add field name to secflds_hist:
c
      secflds_hist(isecflds) = secflds(isecflds)
c
c     do i=1,idim2
c       write(6,"('idim1=',i2,' idim2=',i2,' ndim2=',i2,
c    +    ' i=',i2,' j=',i2,' f2d(:,i)=',/(6e12.4))") 
c    +    idim1,idim2,ndim2,i,ilat,f2d(:,i) 
c     enddo
c     if (ilat.eq.1) then
c       call fminmax(f,idim1*idim2,fmin,fmax)
c       write(6,"('Add ',a,' to secondary history: j=',i2,
c    +    ' min,max=',2e12.4)") fname,ilat,fmin,fmax
c       write(6,"('addfsech: wrote field ',a,' to secondary fields',
c    +    ' file: ixfsech=',i3,' irec=',i3)") fname,ixfsech,irec
c     endif
      return
      end
