!
      subroutine dynamics(lat,ixtime)
      implicit none
!
! Dynamics driver: called from advnce in the main multi-tasked
!   latitude loop. The f-array is private to each processor
!   (blnk.h is task common).
! These routines use f(:,njm2-njm1-nj-njp1-nmp2) from previous
!   iteration and output f(:,njnp). nj is pointer to current
!   latitude fields (lat is current latitude index).
!
! Args:
      integer,intent(in) :: lat,ixtime
!
!     write(6,"('dynamics: lat=',i3)") lat
!
      include "params.h"
      include "buff.h"
      include "blnk.h" ! debug only
      include "index.h" ! debug only
C     ****
C     ****    CALL TO BNDCMP SHOULD LEAD CALLS IN DYNAMICS SECTION OF
C     ****      ADVNCE TO ENSURE THAT MATRICES B(ZIMXP,2,2) AND VECTORS
C     ****      FB(ZIMXP,2) ARE AVAILABLE WHEN NEEDED
C     ****
      CALL BNDCMP
C     ****
C     ****    CALCULATE W AT N*DT
C     ****
      CALL SWDOT
C     ****
C     ****     CALCULATE ION DRIFT VELOCITY
C     ****
      CALL VDRIFT2
C     ****     CALCULATE CP, KT, AND KM
      CALL CPKTKM
C     ****      CLEAR NQO2P, NQOP, NQN2P, NQNOP, NQNP
!     NQPK=NQO2P
!     DO 1 I=1,5*LEN3
!     F(I,NQPK)=0.
!   1 CONTINUE
      call clearnq
C     ****     CALCULATE COLUMN NUMBER DENSITIES
      CALL CHAPMN
C     ****     CALCULATE SOLAR HEATING
C     ****     CALCULATE REACTION RATES
C     call altv
      CALL RATES
      CALL QRJ
C     ****     CALCULATE BACKGROUND (NIGHT-TIME) IONIZATION
      CALL QINITE
C     ****     ADD IONIZATION DUE TO SOLAR X-RAYS
      CALL XRAY
C     ****     GENERATE AURORAL FIELDS, UI, VI, WI.  FIELDS RETURNED
C     ****     IN T1 THRU T7
      CALL HEELIS
C     ****     CALCULATE AURORAL ADDITIONS TO IONIZATION RATES
      CALL ORORA
C     ****     SOLVE FOR N(O+)
C     ****     SET FLUX AT UPPER BOUNDARY
      CALL OPFLUX
      CALL OPLUS
C     ****     COMPUTE ELECTRON DENSITY, N(E), AND ION NUMBER DENSITIES,
C     ****     N(O2+), N(N2+), N(NO+), N(N+)
      CALL ELDEN
C     ****     ION-DRAG PARAMETERS, LXX, LYY, LXY (IN DIPOLE COORDINATE
C     ****     SYSTEM)
      CALL LAMDAS
C     ****     ROTATE LAMDAS TO GEOGRAPHIC SYSTEM
      CALL ROTATE
C     ****     ELECTRON PRODUCTION OF N4S AND N2D
      CALL QTIEFF
C     ****     ODD NITROGEN CHEMISTRY
      CALL CMPN2D
      CALL CMPN4S
      CALL CMPNO
      CALL CMPO2O
C     ****     HEATING AND O2 DISSOCIATION DUE TO ODD NITROGEN AND ION
C     ****     CHEMISTRY
      CALL QJNNO
      CALL QJION
C     ****     CALCULATE ELECTRON AND ION TEMPERATURES
      CALL SETTEI
C     ****     CALCULATE IMPLICIT AND EXPLICIT COOLING TERMS IN NWTI
C     ****     AND NWTE
      CALL NEWTON
C     ****     ADD IN O3P COOLING
      CALL NEWTO3P
C     ****     CALCULATE FLF, FPH, NQDH, NKMH, NPSDH, NPSDH2
C     ****     AT (N-1)*DT
!
! hdif3 uses kld terms calculated in hdif2, and
! defines nflh,nfph,nqdh,npsdh,npsdh2 in f-array
!
      call hdif3(lat,ixtime)
!
C     ****     ADVANCE T, U, V BY ONE TIME STEP
      CALL DT
      CALL DUV
C     ****     COMPOSITION OF MAJOR SPECIES
      CALL COMP
      end subroutine dynamics
!-----------------------------------------------------------------------
      subroutine clearnq
!
! Called from dynamics after CPKTKM, before CHAPMN.
!
      include "params.h"
      include "blnk.h"
      include "cons.h"
      include "index.h"
C     ****      CLEAR NQO2P, NQOP, NQN2P, NQNOP, NQNP
      NQPK=NQO2P
      DO 1 I=1,5*LEN3
      F(I,NQPK)=0.
    1 CONTINUE
      end subroutine clearnq
!-------------------------------------------------------------------
