      SUBROUTINE FILTER(NX,NLEV,KUTJ)
      implicit none
C     ****         SUBROUTINE TO REMOVE LONGITUDINAL WAVES OF PROGNOSTIC
C     ****         VARIABLES BY FFTS.
      include "params.h"
      include "blnk.h"
      include "vscr.h"
      include "buff.h"
      include "rfft.h"
      include "cons.h"
      include "phys.h"
!
! Args:
      integer,intent(in) :: nx,nlev,kutj
      real :: fx(zimx+2,2*zkmxp),wfft((zimx+1)*2*zkmxp)
!
! Local:
      integer :: n1,n2,n,nxk,i
C     ****
C     ****
      N1 = 2*KUTJ+3
      N2 = IMAX+2
      IF(N1.GT.N2) RETURN
      DO 100 N=1,NLEV
      NXK = NX+N-1
C     ****                   SET UP ARRAY OF SEQUENCE TO BE TRANSFORMED
      DO 100 I=1,IMAX
      FX(I,N) = F(I+2,NXK)
  100 CONTINUE
      DO 101 I=IMAX+1,IMAXP2
      DO 101 N=1,NLEV
      FX(I,N)=0.
  101 CONTINUE
C     ****                   CALL FFT ROUTINE FOR FORWARD TRANSFORM
      CALL FFT991(FX,WFFT,TRIGS,IFAX,1,IMAXP2,IMAX,NLEV,-1)
C     ****                   REMOVE WAVE NUMBERS GREATER THAN KUTJ
      DO 200 N = 1,NLEV
      DO 200 I=N1,N2
      FX(I,N) = 0.0
  200 CONTINUE
      CALL FFT991(FX,WFFT,TRIGS,IFAX,1,IMAXP2,IMAX,NLEV,1)
C     ****                   STORE SMOOTHED FIELD IN SCM BUFFER
      DO 230 N=1,NLEV
      NXK=NX+N-1
      DO 230 I=1,IMAX
      F(I+2,NXK) = FX(I,N)
  230 CONTINUE
      RETURN
      END
C
