      SUBROUTINE FILTER2(NX,NLEV,KUTJ)
      implicit none
C     ****         SUBROUTINE TO REMOVE LONGITUDINAL WAVES OF PROGNOSTIC
C     ****         VARIABLES BY FFTS.
      include "params.h"
      include "blnk.h"
      include "vscr.h"
      include "buff.h"
      include "rfft.h"
      include "cons.h"
      include "phys.h"
!
! Args:
      integer,intent(in) :: nx,nlev,kutj
!
! Local:
      integer :: NN(ZIMX/4),n,nxk,i
      real :: fx(zimx+2,2*zkmxp),wfft((zimx+1)*2*zkmxp)
C     ****
C     ****     ARRAY GIVING POWER OF SMOOTHER CORRESPONDING  TO EACH
C     ****       CUTOFF FREQUENCY
C     ****
C     DATA NN/91,40,23,15,10,8,6,5,4,3,3,3,2,2,2,2,1,1/
      DATA NN/45,20,11,7,5,4,3,2,2,1,1,1,1,1,1,1,1,1/
C     DATA NN/22,10,5,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1/
C     ****
C     ****                   SET UP ARRAY OF SEQUENCE TO BE TRANSFORMED
C     ****
      IF(KUTJ.GT.18)RETURN
      DO 100 N=1,NLEV
      NXK = NX+N-1
      DO 100 I=1,IMAX
      FX(I,N) = F(I+2,NXK)
  100 CONTINUE
      DO 101 I=IMAX+1,IMAXP2
      DO 101 N=1,NLEV
      FX(I,N)=0.
  101 CONTINUE
C     ****
C     ****                   CALL FFT ROUTINE FOR FORWARD TRANSFORM
C     ****
      CALL FFT991(FX,WFFT,TRIGS,IFAX,1,IMAXP2,IMAX,NLEV,-1)
C     ****
C     ****                   MULTIPLY BY SMOOTHING FUNCTION
C     ****
      DO 200 I = 1,IMAX
        DO 200 N=1,NLEV
          FX(I+2,N) = FX(I+2,N)*COS(((I+1)/2)*C(1)/2.)**(2*NN(KUTJ))
  200 CONTINUE
C     ****
C     ****                   CALL FFT ROUTINE FOR REVERSE TRANSFORM
C     ****
      CALL FFT991(FX,WFFT,TRIGS,IFAX,1,IMAXP2,IMAX,NLEV,+1)
C     ****                   STORE SMOOTHED FIELD IN SCM BUFFER
      DO 230 N=1,NLEV
      NXK=NX+N-1
      DO 230 I=1,IMAX
      F(I+2,NXK) = FX(I,N)
  230 CONTINUE
      RETURN
      END
C
