      SUBROUTINE NEW(TR,RNU)
      implicit none
C     ****
C     ****     CALCULATES FACTORS FOR NU MATRIX AND RETURNS IN MATRIX
C     ****     RNU
C     ****
C     ****     TR = .5*(TI+TN)
C     ****
      include "params.h"
      include "blnk.h"
      include "cons.h"
      include "index.h"
      include "buff.h"
      include "phys.h"
      real :: rmn4s,rmn2d,rmno,brn2d,colfac
      COMMON/MASS/RMN4S,RMN2D,RMNO,BRN2D,COLFAC
!
! Args:
      real,intent(in) :: TR(ZIMXP,ZKMXP)
      real,intent(out) :: RNU(ZIMXP,ZKMXP,3,3)
!
! Local:
      integer :: i
C     ****
C     ****     SET MATRIX
C     ****
      DO 1 I=1,LEN2
C     ****          O2+    -    O2
      RNU(I,1,1,1)=2.59E-11*SQRT(TR(I,1))*(1.-0.073*ALOG10(TR(I,1)))**2
C     ****          O+     -    O2
      RNU(I,1,2,1)=6.64E-10
C     ****          NO+    -    O2
      RNU(I,1,3,1)=4.27E-10
C     ****          O2+    -     O
      RNU(I,1,1,2)=2.31E-10
C     ****          O+     -     O
      RNU(I,1,2,2)=3.67E-11*SQRT(TR(I,1))*(1.-0.064*ALOG10(TR(I,1)))**
     |2*COLFAC
C     RNU(I,1,2,2)=3.0E-11*SQRT(TR(I,1))*(1.-0.135*ALOG10(TR(I,1)*
C    1             0.001))**2
C     ****          NO+    -     O
      RNU(I,1,3,2)=2.44E-10
C     ****          O2+    -    N2
      RNU(I,1,1,3)=4.13E-10
C     ****          O+     -    N2
      RNU(I,1,2,3)=6.82E-10
C     ****          NO+    -    N2
      RNU(I,1,3,3)=4.34E-10
    1 CONTINUE
      RETURN
      END
C
