c
c Common for secondary histories option:
c Secondary histories are like regular histories but contain selected 
c   fields at the current time step. They can be used with all post-model 
c   processors, but cannot be used to restart the model.
c Fields on secondary histories may be primary fields (i.e., are also
c   on primary histories), or diagnostic fields (defined by user in 
c   model mods with calls to sub addfsech)
c (lusech > 0 if writing secondary histories during this run)
c (lusech1 is direct access unit for saving diagnostic fields) 
c
! mxfsech: max number of secondary history fields
      integer,parameter :: mxfsech=nfproc
      integer secout(3,20),     ! secondary output volumes (3-part mss paths
c
c secsave,secstart,secstop are in model time (day,hr,min):
c
     +        sechist(3),       ! secondary hist write freq (user input)
     +        secsave(3),       ! secondary vol dispose freq (user input)
     +        secstart(3),      ! secondary hist start (user input)
     +        secstop(3)        ! secondary hist stop (user input)
c
c secflds(mxfsech) = fields requested by the user (SECFLDS input)
c secflds_hist(mxfsech) = fields actually written to secondary histories
c   (i.e., if a field was requested in secflds(i), but addfsech was never
c    called for that field, then secflds_hist(i) is blank, and post-proc
c    will not find it).
c
      character*8 
     +        secflds(mxfsech), ! names of requested secondary hist fields
     +        secflds_hist(mxfsech)! secondary fields written to hist
      integer itapsech,         ! number of files written
     +        mtapsech,         ! number of output file names given (secout)
     +        ifilsech,         ! number of sec hist written to current file
     +        mfilsech,         ! number of secondary hist that fill mss file
     +        ihissech,         ! secondary hist disk write flag
     +        mhissech,         ! secondary hist disk write freq (steps)
     +        isavsech,         ! secondary hist mss file write flag
     +        msavsech,         ! secondary hist mss file write freq (steps)
     +        isecstart,        ! iter to start writing sec hist
     +        isecstop,         ! iter to stop writing sec hist
     +        nfsech            ! number of fields requested by user
      integer lusech,           ! secondary hist unit
     +        lusech1,		! diagnostic fields save unit
     +        lbsech,           ! secondary hist buffer length
     +        labsech(3,20)     ! mss output path names (from secout above)
      character*80 volinfo_sech
      common/sechis/ secout,sechist,secsave,secstart,secstop,lusech,
     +  lusech1,
     +  itapsech,mtapsech,ifilsech,mfilsech,ihissech,mhissech,isavsech,
     +  msavsech,lbsech,labsech,isecstart,isecstop,secflds,
     +  secflds_hist,volinfo_sech,nfsech
c
