!
      SUBROUTINE FLOWV3(ihem)
      implicit none
C     ****
C     ****     TRANSFORM TO AURORAL CIRCLE COORDINATES
C     ****
      include "params.h"
      include "cflowv3.h"
      include "cons.h"
      include "phys.h"
      include "ioncr.h"
      real :: cosofa,sinofa,aslona,pi,pi2
      COMMON /OVALPOS/ COSOFA(2),SINOFA(2),ASLONA(2),PI,PI2
!     real :: rlatm,rlonm,dipmag,decmag,sndec,csdec,sn2dec,sncsdc,
!    |  rlatmp,rlonmp,dlons
!     COMMON/TRGM/RLATM(ZIMXP,ZJMX),RLONM(ZIMXP,ZJMX),
!    1  DIPMAG(ZIMXP,ZJMX),DECMAG(ZIMXP,ZJMX),SNDEC(ZIMXP,ZJMX),
!    2  CSDEC(ZIMXP,ZJMX),SN2DEC(ZIMXP,ZJMX),SNCSDC(ZIMXP,ZJMX),
!    3  RLATMP(ZJMX),RLONMP(ZJMX),DLONS(ZJMX)
      include "trgm.h"
!
! Args:
      integer,intent(out) :: ihem
!
! Local:
      real :: dlat(zimx),dlon(zimx),ratio(zimx)
      integer :: iflag(zimx),i,imaxd2,n
      real :: PSI(8),e,pih,ofda,ofdc,sinth0,sinthr1
      real :: PHDPMX(2),PHDMMX(2),PHNPMX(2),PHNMMX(2),
     1  COSOFC(2),SINOFC(2),ASLONC(2)
!
! dlat,dlon, ratio, and iflag are local.
!   rlatm, rlonm are in regular common /TRGM/ (trgm.h) defined by magdyn.f
!     (magdyn is called by start)
!   dlons is also in /TRGM/ and is defined in sun.f
!     (sun is called by advnce before main latitude loop)
!
      do i=1,imax
        dlat(i) = rlatm(i+2,j)
        dlon(i) = rlonm(i+2,j)-dlons(j)
        ratio(i) = 1.
        iflag(i) = 1
      enddo
!
      if (istar==0) then
        istar = 1
        PI=4.*ATAN(1.)
        PI2=2.*PI
        PIH=.5*PI
        DO N=1,2
          OFDA = SQRT(OFFA(N)**2 + DSKOFA(N)**2)
          COSOFA(N) = COS(OFDA)
          SINOFA(N) = SIN(OFDA)
          ASLONA(N) = ASIN(DSKOFA(N)/OFDA)
          OFDC = SQRT(OFFC(N)**2 + DSKOFC(N)**2)
          COSOFC(N) = COS(OFDC)
          SINOFC(N) = SIN(OFDC)
          ASLONC(N) = ASIN(DSKOFC(N)/OFDC)
          IF(PHIN(N).LT.PHID(N))PHIN(N)=PHIN(N)+PI2
          PHDPMX(N)=.5*AMIN1(PI,(PHIN(N)-PHID(N)))
          PHNPMX(N)=.5*AMIN1(PI,(PHID(N)-PHIN(N)+PI2))
          PHNMMX(N)=PHDPMX(N)
          PHDMMX(N)=PHNPMX(N)
        enddo
      endif
C     ****               SET IHEM = 1,2  FOR  S,N HEMISPHERE
      IMAXD2 = MAX0(1,IMAX/2)
      IHEM = IFIX(DLAT(IMAXD2)*2./3.1416 + 2.)
C     ****
C     ****     TRANSFORM TO AURORAL CIRCLE CORDINATES
C     ****       I.E. CALCULATE COLAT AND ALON FOR POLHT AND AURHT
C     ****
!
! Define colat and alon (taskcommon in cflowv3.h) for polht and aurht:
!
      DO 8 I=1,IMAX
        SINLAT(I)=SIN(ABS(DLAT(I)))
        COSLAT(I)=COS(DLAT(I))
        SINLON(I) = SIN(DLON(I)+ASLONA(IHEM))
        COSLON(I) = COS(DLON(I)+ASLONA(IHEM))
        COLAT(I) = COSOFA(IHEM)*SINLAT(I) - SINOFA(IHEM)*COSLAT(I)*
     1    COSLON(I)
        COLAT(I) = ACOS(COLAT(I)) * SQRT(RATIO(I))
        ALON(I) = AMOD(ATAN2(+SINLON(I)*COSLAT(I),SINLAT(I)*
     1    SINOFA(IHEM)+COSOFA(IHEM)*COSLAT(I)*COSLON(I)) -
     2    ASLONA(IHEM)+3.*PI,PI2) - PI
    8 CONTINUE
      RETURN
      END
C
