!
      SUBROUTINE RATES
      use input_module,only: f107
      use init_module,only: sfeps
! CDIR$ VFUNCTION EXPHF
      implicit none
!
! Calculate temperature-dependent reaction rates.
! This defines processor-private taskcommon /rates_priv/ (crates.h)
! (see sub rate below for temperature-independent rates)
!
      include "params.h"
      include "fcom.h"
      include "vscr.h"
      include "cons.h"
      include "index.h"
      include "buff.h"
      include "phys.h"
      include "crates.h"
! 
! Local:
      integer :: ntek,ntik,ntk,nno2k,nnvo2k,i
!
      NTEK=NJ+NTE
      NTIK=NJ+NTI
      NTK=NJ+NT
      NNO2K=NNO2
      NNVO2K=NNVO2
      DO 1 I=1,LEN2
C     ****
C     ****     S15 = T1/300.    S14 = T2/300.    S13 = TR/300.
C     ****
      S15(I,1)=(0.667*F(I,NTIK)+0.333*F(I,NTK))/300.
      S14(I,1)=(0.6363*F(I,NTIK)+0.3637*F(I,NTK))/300.
      S13(I,1)=.5*(F(I,NTIK)+F(I,NTK))/300.
C     ****
C     ****     K1   (ASSUMES T1/300 IN S15)
C     ****
!     RK1(I,1,1)=(((9.65E-16*S15(I,1)-5.17E-14)*S15(I,1)+1.073E-12)*
!    1S15(I,1)-7.74E-12)*S15(I,1)+2.82E-11 ! original tgcm13mt
C     ****
C     **** NEW RATE COEFFICIENT FOR O+ + O2 -> O + O2+
C     ****
C     RK1(I,1,1)=1.7E-11*(300./F(I,NTK))**0.77+8.54E-11*exp(-3467./
C    1         F(I,NTK))
C     **** NEW RATE COEFFICIENT FOR O+ + O2 -> O + O2+ (HIERL)
C     ****
! 13mt snoe mod:
      RK1(I,1,1)=1.6E-11*S15(I,1)**(-0.52)+5.5E-11*exp(-22.85/S15(I,1))
C     ****
C     ****     K2   (ASSUMES T2/300 IN S14)
C     ****
      RK2(I,1)=(8.6E-14*S14(I,1)-5.92E-13)*S14(I,1)+1.533E-12
C     ****
C     **** NEW RATE COEFFICIENT FOR O+ + N2 -> N + NO+
C     ****
! See also sub altv (altv.f). Tvib is output of sub altv, if it
! is called (see dynamics.f).
!
      TVIB(I,1) = F(I,NTK)
      S5(I,1) = exp(-3353./TVIB(I,1))
      RK2(I,1) = (((((270.*S5(I,1)+220.)*S5(I,1)+85.)*S5(I,1)+38.)
     1           *S5(I,1)+1.)*RK2(I,1)*S5(I,1)+RK2(I,1))
     2           *(1.-S5(I,1))
C     ****
C     ****     K3   (ASSUMES TR/300 IN S13)
C     ****
      if (300.*S13(I,1)-1500.>=0.) then
        RK3(I,1)=5.2E-11*S13(I,1)**0.2
      else
        RK3(I,1)=1.4E-10*S13(I,1)**(-0.44)
      endif
C     ****
C     ****     K4 THRU K10
C     ****
      RK19(I,1) = 4.0E-8*SQRT(300./F(I,NTEK))
      RK20(I,1) = 1.5E-7*SQRT(300./F(I,NTEK))
      RK25(I,1) = 6.6E-8*SQRT(300./F(I,NTEK))
      RKM12(I,1) = 9.59E-34*exp(480./F(I,NTK))
C     ****
C     ****     RATES ALF1 THRU ALF3 (INVOLVE ELECTRON TEMPERATURE AND
C     ****     ASSUME NTEK HAS APPROPRIATE VALUE)
C     ****
      RA1(I,1)=4.2E-7*(300./F(I,NTEK))**0.85
      if (F(I,NTEK) >= 1200.) then
        RA2(I,1)=1.6E-7*(300./F(I,NTEK))**0.55
      else
        RA2(I,1)=2.7E-7*(300./F(I,NTEK))**0.7
      endif
      RA3(I,1)=1.8E-7*(300./F(I,NTEK))**0.39
      BETA1(I,1) = 1.5E-11*exp(-3600./F(I,NTK))
C     BETA3(I,1) = 1.6E-10*exp(-460./F(I,NTK))
      BETA3(I,1) = 2.5E-10*SQRT(F(I,NTK)/300.)*exp(-600./
     1             F(I,NTK))
      BETA5(I,1)=3.6E-10*SQRT(F(I,NTEK)/300.)
      BETA8(I,1)=4.5E-6*(1.+0.11*(f107-65.)/165.)*
     |  exp(-1.E-8*F(I,NNO2K)**0.38)*sfeps

      BETA9(I,1)=2.91E11*(1.+0.2*(f107-65.)/100.)*2.E-18*
     |  exp(-8.E-21*F(I,NNO2K))*sfeps

      BETA9N(I,1)=5.E9*(1.+0.2*(f107-65.)/100.)*2.E-18*
     |  exp(-8.E-21*F(I,NNVO2K))*sfeps
      BETA17(I,1)=1.E-32*SQRT(300./F(I,NTEK))
    1 CONTINUE
      DO 2 I=1,LEN1
      BETA8(I,KMAXP1)=4.5E-6*(1.+0.11*(f107-65.)/165.)*
     |  exp(-1.E-8*F(I,NNO2K+KMAX)**0.38)
      BETA9(I,KMAXP1)=2.91E11*(1.+0.2*(f107-65.)/100.)*2.E-18*
     |  exp(-8.E-21*F(I,NNO2K+KMAX))
      BETA9N(I,KMAXP1)=5.E9*(1.+0.2*(f107-65.)/100.)*2.E-18*
     |  exp(-8.E-21*F(I,NNVO2K+KMAX))
    2 CONTINUE
      RETURN
      END
!-----------------------------------------------------------------------
      subroutine rate
      implicit none
!
! Set temperature-independent reaction rates, defining shared
!   common /rates_share/ (crates.h)
! This is called once per run from con.f.
!
      include "params.h"
      include "cons.h"
      include "crates.h"
!
! Local:
      integer :: i
!
      do i=1,len2
        RK4(I,1)=1.0E-10
        RK5(I,1)=4.4E-10
        RK6(I,1)=4.0E-10
        RK7(I,1)=2.0E-10
        RK8(I,1)=1.0E-12
        RK9(I,1)=6.0E-11
        RK10(I,1)=1.3E-10
        RK16(I,1) = 4.8E-10
        RK17(I,1) = 1.0E-10
        RK18(I,1) = 4.0E-10
        RK21(I,1) = 0.047
        RK22(I,1) = 0.171
        RK23(I,1) = 8.E-10
        RK24(I,1) = 5.0E-12
        RK26(I,1) = 7.E-10
        RK27(I,1) = 7.7E-5
        BETA2(I,1)=5.0E-12
C       BETA4(I,1) = 6.9E-13
        BETA4(I,1) = 5.0E-13
        BETA6(I,1)=7.0E-11
        BETA7(I,1)=1.06E-5
      enddo
      end subroutine rate
