!
      module timing_module
      implicit none
!
! f90 intrinsic system_clock returns current clock count, number of
! clock counts per second, and max possible value of the count.
!
      integer :: icount1, icount_rate1, icount_max1,
     |           icount2, icount_rate2, icount_max2
      real :: elapsed_secs, elapsed_secs_total=0.
      contains
!-----------------------------------------------------------------------
      subroutine start_timing
      call system_clock(icount1,icount_rate1,icount_max1)
      end subroutine start_timing
!-----------------------------------------------------------------------
      subroutine end_timing(tsecs)
      real,intent(out) :: tsecs
!
      call system_clock(icount2,icount_rate2,icount_max2)
      if (icount2 < icount1) then
        icount2 = icount2+icount_max2
      endif
      icount2 = icount2 - icount1
      elapsed_secs = real(icount2) / real(icount_rate2)
      tsecs = elapsed_secs
      elapsed_secs_total = elapsed_secs_total+elapsed_secs
      end subroutine end_timing
      end module timing_module
