!
      subroutine allocdata
!
! Allocate msc data. Main fields are not allocated here, see
! init_fields in fields.F. This is not in field.F in order to
! avoid circular module dependencies.
!
      use params_module,only: nlevp1,nlonp4,nlat
      use fields_module,only: f4d,f3d,nf4d,nf3d,foutput
      use mpi_module,only: lon0,lon1,lat0,lat1,mytid
      use chemrates_module,only: alloc_tdep
      use qrj_module,only: alloc_q
      use mgw_module,only: alloc_gw
      use comp_meta_module,only: alloc_meta
      use compdat_module,only: comp_dat
      use hox_module,only: alloc_hox
      use n4s_module,only: alloc_n4s
      use noz_module,only: alloc_noz
      use ch4_module,only: alloc_ch4
      use co2_module,only: alloc_co2
      use co_module,only: alloc_co
      use h2o_module,only: alloc_h2o
      use h2_module,only: alloc_h2
      use ar_module,only: alloc_ar
      use uv_bndry,only: alloc_uvbnd
      use gswm_module,only: alloc_gswm
      use magpres_g,only: alloc_pg
!
      use pdynamo_module,only: alloc_pdyn
      use gswm_module,only: alloc_gswm
      implicit none
!
! Local:
      integer :: i,istat,nlons,nlats,len
!
! Allocate temperature-dependent chemical reaction rates:
      call alloc_tdep
!
! Allocate ionization rates (qrj module):
      call alloc_q(lon0,lon1,lat0,lat1)
!
! Allocate J(mag.pressure,gravity (magpres_g module):
      call alloc_pg(lon0,lon1,lat0,lat1)
!
! Allocate arrays for gravity wave parameterization:
      call alloc_gw(lon0,lon1,lat0,lat1)
!
! Allocate arrays for comp_meta:
      call alloc_meta(lon0,lon1,lat0,lat1)
!
! Allocate for minor species modules:
      call alloc_hox(lon0,lon1,lat0,lat1)
      call alloc_n4s(lon0,lon1,lat0,lat1)
      call alloc_noz(lon0,lon1,lat0,lat1)
      call alloc_ch4(lon0,lon1,lat0,lat1)
      call alloc_co2(lon0,lon1,lat0,lat1)
      call alloc_co (lon0,lon1,lat0,lat1)
      call alloc_h2o(lon0,lon1,lat0,lat1)
      call alloc_h2 (lon0,lon1,lat0,lat1)
      call alloc_ar (lon0,lon1,lat0,lat1)
!
! Allocate t,u,v lower boundary:
      call alloc_uvbnd(lon0,lon1,lat0,lat1)
!
! Set minor species data:
      call comp_dat
!
! Allocate for gswm:
      call alloc_gswm(lon0,lon1,lat0,lat1)
!
! Allocate needed fields for parallel dynamo (pdynamo.F):
        call alloc_pdyn
!
! We are not doing parallel i/o to netcdf output histories, so when
! it comes time to write a history, the task subdomains are gathered
! to the root task (see call mp_gather2root in advance), and only
! the root task writes to the file. Here we allocate the full 3d grid
! for all history fields on the root task. This is where the data
! will be gathered and written by the root when a history is written.
!
! The pointer is declared in fields.F:
!     real,pointer :: foutput(:,:,:,:) ! (nlevp1,nlonp4,nlat,nf4d)
!
#ifdef MPI
      if (mytid==0) then
        allocate(foutput(nlevp1,nlonp4,nlat,nf4d),stat=istat)
        if (istat /= 0) then
          write(6,"('>>> allocdata: error allocating 3d data for ',
     |      'all fields on root task: nlevp1=',i3,' nlonp4=',i3,
     |      ' nlat=',i3,' nf4d=',i3,' istat=',i3)")
     |      nlevp1,nlonp4,nlat,nf4d,istat
          call shutdown('allocate foutput on root task for mpi job')
        else
          write(6,"('Allocated 3d data for all fields on root task:')")
          len = nlevp1*nlonp4*nlat*nf4d
          write(6,"('  nlevp1*nlonp4*nlat*nf4d = ',i3,'*',i3,'*',
     |      i3,'*',i3,' = ',i8,' words *8 = ',i10,' bytes.')")
     |      nlevp1,nlonp4,nlat,nf4d,len,len*8
        endif    
        foutput = 0.
      endif 
#else
      allocate(foutput(nlevp1,nlonp4,nlat,nf4d),stat=istat)
      if (istat /= 0) then
        write(6,"('>>> allocdata: error allocating 3d data for ',
     |    'all fields on root task: nlevp1=',i3,' nlonp4=',i3,
     |    ' nlat=',i3,' nf4d=',i3,' istat=',i3)")
     |    nlevp1,nlonp4,nlat,nf4d,istat
        call shutdown('allocate foutput')
      else
        write(6,"('Allocated 3d data for all fields on root task:')")
        len = nlevp1*nlonp4*nlat*nf4d
        write(6,"('  nlevp1*nlonp4*nlat*nf4d = ',i3,'*',i3,'*',
     |    i3,'*',i3,' = ',i8,' words *8 = ',i10,' bytes.')")
     |    nlevp1,nlonp4,nlat,nf4d,len,len*8
      endif    
#endif
      end subroutine allocdata
