!
      module comp_meta_module
      use addfld_module,only: addfld
      implicit none
!
! Ratios for partitioning hox are allocated in sub alloc_meta below.
      real,dimension(:,:,:),allocatable :: ! (nlevp1,lon0:lon1,lat0:lat1)
     |  oh_h,      ! oh/h  (ratio1)
     |  ho2_h,     ! ho2/h (ratio2)
     |  h_hox,     ! h/hox (ratio3)
     |  rmtru_hox, ! "true" mass of hox
     |  rmtru_ox,  ! "true" mass of ox (see comp_ox.F)
     |  ch3, ch3o2, ch3ooh, ch3o, ch2o, cho
!
      contains
!-----------------------------------------------------------------------
      subroutine comp_meta(barm,xnmbar,o2,o1,ox,o3,h2o,h2,ch4,co,co2,no,
     |  n4s,ne,n2o,op,o2p,n2p,nop,n2d,o1d,o21s,o21d,h2o2,lev0,lev1,lon0,
     |  lon1,lat)
!
! Calculate n(2d), o(1d), o2(1delta), o2(1sigma), assuming
!   photochemical equilibrium. Ratios oh/h, ho2/h and h/hox and rmtru_hox
!   for partitioning hox are also calculated.
!
      use params_module,only: spval
      use qrj_module,only: pdn2,pdo3d,pdo2d,pd762,pdn2o,pdco2d,pdho2
      use cons_module,only: brn2d,
     |  rmassinv_o1 ,rmassinv_no ,rmassinv_o2,rmassinv_o3 ,rmassinv_n2d,
     |  rmassinv_co2,rmassinv_h2o,rmassinv_h2,rmassinv_ch4,rmassinv_o3 ,
     |  rmassinv_n2 ,rmassinv_n4s,rmassinv_co,rmass_n2d,
     |  rmass_o1,rmass_o2,rmass_h,rmass_oh, rmass_ho2
      use chemrates_module,only: rk3,rk10,ra1,ra2,ra3,beta2,beta4,beta5,
     |  beta6,beta7,beta8,beta10,rkm1,rkm2a,rkm3,rkm4,rkm5a,rkm5b,rkm6,
     |  rkm7a,rkm8,rkm9,rkm10,rkm11,rkm13,rkm14,rkm15,rkm16,rkm17,rkm25,
     |  rkm26,rkm29,rkm33,rkm34,rkm36,rkm37,rkm42,gam15,a1d,asg,adl
      implicit none
!
! Args:
      integer,intent(in) :: lev0,lev1,lon0,lon1,lat
      real,dimension(lev0:lev1,lon0-2:lon1+2),intent(in) ::
     |  barm,xnmbar,o2,o1,ox,o3,h2o,h2,ch4,co,co2,no,n4s,ne,n2o,op,o2p,
     |  n2p,nop
      real,dimension(lev0:lev1,lon0-2:lon1+2),intent(out) ::
     |  n2d,   ! n2d output
     |  o1d,   ! o(1delta) output
     |  o21s,  ! o2(1sigma) output
     |  o21d,  ! o2(1delta) output
     |  h2o2   ! h2o2 output
!
! Local:
      integer :: k,i,i0,i1,nk,nkm1
      real,dimension(lev0:lev1,lon0:lon1) ::
     |  n2dprod,   ! n2d production
     |  n2dloss,   ! n2d loss
     |  o1dprod,   ! o1d production
     |  o1dloss,   ! o1d loss
     |  barmm,     ! barm at midpoints
     |  pdo3dm,    ! pdo3d at midpoints
     |  pdo2dm,    ! pdo2d at midpoints
     |  pd762m,    ! pd762 at midpoints
     |  pdn2om,    ! pdn2o at midpoints
     |  pdco2dm,   ! pdco2d at midpoints
     |  o21sprod,  ! o2(1sigma) production
     |  o21sloss,  ! o2(1sigma) loss
     |  o21dprod,  ! o2(1delta) production
     |  o21dloss,  ! o2(1delta) loss
     |  e5200,     ! e5200 output
     |  e6300s,    ! e6300 output
     |  ro1dn2d,   ! ro1dn2d output
     |  xo1d,      ! o1d number density
     |  xn2d,      ! n2d number density
     |  hwork      ! work array for hox partitioning
      real ::
     |  psn2       ! n2 mass mixing ratio
!
! Exec:
      i0 = lon0 ; i1 = lon1 ; nk = lev1-lev0+1 ; nkm1 = nk-1
!
      do i=lon0,lon1
        do k=lev0,lev1-1
          n2dprod(k,i) = 0.5*(pdn2(k,i,lat)+pdn2(k+1,i,lat))*brn2d       ! s2
        enddo ! k=lev0,lev1-1
      enddo ! i=lon0,lon1
!
!     call addfld('XNMBAR' ,' ',' ',xnmbar(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('O2_META',' ',' ',o2(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('O1_META',' ',' ',o1(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('NO_META',' ',' ',no(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
! beta5 (chemrates.F) does not have lev1:
!     call addfld('BETA5'  ,' ',' ',beta5 (lev0:nkm1,i0:i1,lat),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('NE_META',' ',' ',ne(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
! op top level is not valid:
!     call addfld('OP_META',' ',' ',op(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!
      do i=lon0,lon1
        do k=lev0,lev1-1
!
! n2d production:
          n2dprod(k,i) = n2dprod(k,i)+rk3(k,i,lat)*n2p(k,i)*xnmbar(k,i)* ! s2
     |      o1(k,i)*rmassinv_o1+(ra1(k,i,lat)*nop(k,i)*0.85+
     |      ra3(k,i,lat)*n2p(k,i)*0.9)*sqrt(ne(k,i)*ne(k+1,i))
!
! n2d loss:
          n2dloss(k,i) = xnmbar(k,i)*(beta2*o2(k,i)*rmassinv_o2+         ! s3
     |      beta4*o1(k,i)*rmassinv_o1+beta6*no(k,i)*rmassinv_no)+
     |      beta7+beta5(k,i,lat)*sqrt(ne(k,i)*ne(k+1,i))+
     |      rk10*op(k,i)
!
! Update n2d:
          n2d(k,i) = rmass_n2d*n2dprod(k,i)/(n2dloss(k,i)*xnmbar(k,i))
	  xn2d(k,i) = n2dprod(k,i)/n2dloss(k,i)
	  e5200(k,i) = beta7*xn2d(k,i)
        enddo ! k=lev0,lev1-1
      enddo ! i=lon0,lon1
!
!     call addfld('N2DPROD',' ',' ',n2dprod(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('N2DLOSS',' ',' ',n2dloss(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('XN2D',' ',' ',xn2d(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('E5200',' ',' ',e5200(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!
! Metastable for o(1d), o2(1delta), and o2(1sigma) (midpoints)
      do i=lon0,lon1
        do k=lev0,lev1-1
          pdo3dm(k,i) = 0.5*(pdo3d(k,i,lat)+pdo3d(k+1,i,lat))    ! s2
          pdo2dm(k,i) = 0.5*(pdo2d(k,i,lat)+pdo2d(k+1,i,lat))    ! s3
          pd762m(k,i) = 0.5*(pd762(k,i,lat)+pd762(k+1,i,lat))    ! s10
          pdn2om(k,i) = 0.5*(pdn2o(k,i,lat)+pdn2o(k+1,i,lat))    ! s11
          pdco2dm(k,i) = 0.5*(pdco2d(k,i,lat)+pdco2d(k+1,i,lat)) ! s12
        enddo ! k=lev0,lev1-1
      enddo ! i=lon0,lon1
!
! Save only up to lev1-1 (entire field is init to spval by addfld.F)
!     call addfld('PDO3DM',' ',' ',pdo3dm(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('PDO2DM',' ',' ',pdo2dm(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('PD762M',' ',' ',pd762m(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('PDN2OM',' ',' ',pdn2om(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('PDCO2DM',' ',' ',pdco2dm(lev0:lev1-1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)

      do i=lon0,lon1
        do k=lev0,lev1-1
!
! o(1d) production:
!
          o1dprod(k,i) = xnmbar(k,i)*                            ! s4
     |      (pdo2dm(k,i)*o2 (k,i)*rmassinv_o2+
     |       pdo3dm(k,i)*o3 (k,i)*rmassinv_o3+
     |       beta2      *n2d(k,i)*rmassinv_n2d*
     |       o2(k,i)*rmassinv_o2*0.1*xnmbar(k,i))+
     |      0.85*ra2(k,i,lat)*o2p(k,i)*
     |      sqrt(ne(k,i)*ne(k+1,i))+n2o(k,i)*xnmbar(k,i)/
     |      (0.5*(barm(k,i)+barm(k+1,i)))*pdn2om(k,i)+
     |      pdco2dm(k,i)*co2(k,i)*xnmbar(k,i)*rmassinv_co2
!
! o(1d) loss:
!
          psn2 = (1.-ox(k,i)-o2(k,i))
          o1dloss(k,i) = xnmbar(k,i)*                            ! s5
     |      (rkm2a(k,i,lat) *o2 (k,i) *rmassinv_o2  +
     |       rkm1 (k,i,lat) *psn2     *rmassinv_n2  +
     |       rkm3           *h2o(k,i) *rmassinv_h2o +
     |       rkm4           *h2 (k,i) *rmassinv_h2  + 
     |       (rkm5a+rkm5b)  *ch4(k,i) *rmassinv_ch4 +
     |       rkm6 (k,i,lat) *co2(k,i) *rmassinv_co2 +
     |       rkm7a          *o3 (k,i) *rmassinv_o3  + 
     |       rkm8           *o1 (k,i) *rmassinv_o1  +
     |       gam15          *co2(k,i) *rmassinv_co2)+
     |       a1d
!
! Psi o(1delta) output (was xno1d in tgcm24):
!
          o1d(k,i) = rmass_o1*o1dprod(k,i)/(o1dloss(k,i)*xnmbar(k,i))
          if (o1d(k,i) < 1.e-60) o1d(k,i) = 1.e-60
	  xo1d(k,i) = o1dprod(k,i)/o1dloss(k,i)
	  e6300s(k,i) = a1d*xo1d(k,i)
	  ro1dn2d(k,i) = e6300s(k,i)/e5200(k,i)
!
! o2(1sigma) production:
!
          o21sprod(k,i) =                                  ! s6
     |      (rkm2a(k,i,lat)*o1d(k,i)*rmassinv_o1*
     |       o2(k,i)*rmassinv_o2*xnmbar(k,i)*0.75+
     |       pd762m(k,i)*o2(k,i)*rmassinv_o2)*xnmbar(k,i)
!
! o2(1sigma) loss:
!
          o21sloss(k,i) = xnmbar(k,i)*                     ! s13
     |      (rkm13 * psn2     * rmassinv_n2 +
     |       rkm14 * co2(k,i) * rmassinv_co2+
     |       rkm15 * o3 (k,i) * rmassinv_o3 +
     |       rkm16 * o1 (k,i) * rmassinv_o1 +
     |       rkm17 * o2 (k,i) * rmassinv_o2 )
!
! PSI o2(1sigma):
!
          o21s(k,i) = rmass_o2*o21sprod(k,i)/((o21sloss(k,i)+asg)*  ! xno21s
     |      xnmbar(k,i))
          if (o21s(k,i) < 1.e-60) o21s(k,i) = 1.e-60
!
! o2(1delta) production:
!
          o21dprod(k,i) = xnmbar(k,i)*                     ! s8
     |      0.9*pdo3dm(k,i)*o3(k,i)*rmassinv_o3+
     |      o21sloss(k,i)*o21s(k,i)*rmassinv_o2*xnmbar(k,i)
!
! o2(1delta) loss:
!
          o21dloss(k,i) = xnmbar(k,i)*                     ! s9
     |      (rkm9(k,i,lat) *o2(k,i)*rmassinv_o2+
     |       rkm10         *psn2   *rmassinv_n2+
     |       rkm11         *o1(k,i)*rmassinv_o1)+adl
!
! o2(1delta):
!
          o21d(k,i) = rmass_o2*o21dprod(k,i)/(o21dloss(k,i)*xnmbar(k,i)) ! xno21d
          if (o21d(k,i) < 1.e-60) o21d(k,i) = 1.e-60
        enddo ! k=lev0,lev1-1
!
! Set top level using log interpolation.
        n2d (lev1,i) = n2d (lev1-1,i)**2 / n2d (lev1-2,i)
        o1d (lev1,i) = o21d(lev1-1,i)**2 / o1d (lev1-2,i)
        o21s(lev1,i) = o21s(lev1-1,i)**2 / o21s(lev1-2,i)
        o21d(lev1,i) = o21d(lev1-1,i)**2 / o21d(lev1-2,i)
      enddo ! i=lon0,lon1
!
! Save up to lev1-1 (top level will be spval)
!     call addfld('O1DPROD' ,' ',' ',o1dprod(lev0:nkm1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O1DLOSS' ,' ',' ',o1dloss(lev0:nkm1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O1D_META',' ',' ',o1d(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O21SPROD',' ',' ',o21sprod(lev0:nkm1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O21SLOSS',' ',' ',o21sloss(lev0:nkm1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O21S'    ,' ',' ',o21s(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O21DPROD',' ',' ',o21dprod(lev0:nkm1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O21DLOSS',' ',' ',o21dloss(lev0:nkm1,:),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('O21DMETA',' ',' ',o21d(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('XO1D',' ',' ',xo1d(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('E6300S',' ',' ',e6300s(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)
!     call addfld('RO1DN2D',' ',' ',ro1dn2d(lev0:nkm1,i0:i1),
!    |  'lev',lev0,lev1-1,'lon',i0,i1,lat)

      do i=lon0,lon1
        do k=lev0,lev1-1
!
! Partitioning of hox:
!   oh_h  = oh/h  ratio (s7)
!   ho2_h = ho2/h ratio (s8)
!   h_hox = h/hox number density ratio (s9)
! 
          barmm(k,i) = 0.5*(barm(k,i)+barm(k+1,i))                  ! s11
!
          hwork(k,i) =                                              ! s13
     |      (rkm26 (k,i,lat)*o1(k,i)*rmassinv_o1+
     |       rkm34 (k,i,lat)*o3(k,i)*rmassinv_o3+
     |       beta10(k,i,lat)*no(k,i)*rmassinv_no)*xnmbar(k,i)+
     |       (pdho2(k,i,lat)+pdho2(k+1,i,lat))*0.5
!
! oh/h ratio:
!
          oh_h(k,i,lat) = (rkm36(k,i,lat)*o2(k,i)*rmassinv_o2*      ! s7,ratio1
     |      xnmbar(k,i)*xnmbar(k,i) / barmm(k,i)+
     |        rkm37(k,i,lat)*o3 (k,i)*rmassinv_o3*xnmbar(k,i)) /
     |      ((rkm25(k,i,lat)*o1 (k,i)*rmassinv_o1+
     |        rkm33(k,i,lat)*h2 (k,i)*rmassinv_h2+
     |        beta8         *n4s(k,i)*rmassinv_n4s+
     |        rkm42(k,i,lat)*co (k,i)*rmassinv_co)*xnmbar(k,i))
!
! ho2/h ratio:
!
          ho2_h(k,i,lat) = (rkm36(k,i,lat)*o2(k,i)*rmassinv_o2*     ! s8,ratio2
     |      xnmbar(k,i)*xnmbar(k,i) / barmm(k,i)) / hwork(k,i)+
     |      (rkm29(k,i,lat)*o3(k,i)*rmassinv_o3)*xnmbar(k,i)*
     |      oh_h(k,i,lat) / hwork(k,i) 
!
! h/hox ratio:
!
          h_hox(k,i,lat) = 1./(1.+oh_h(k,i,lat)+ho2_h(k,i,lat))     ! s9,ratio3
!
! rmtru_hox:
!
          rmtru_hox(k,i,lat) = h_hox(k,i,lat)*(rmass_h+oh_h(k,i,lat)*  ! s10
     |      rmass_oh+ho2_h(k,i,lat)*rmass_ho2)
!
! Set minimums (these appear to take effect above about zp -15, and above
! about zp -10 for h_hox):
!
          if (oh_h (k,i,lat) < 1.e-6) oh_h (k,i,lat) = 1.e-6
          if (ho2_h(k,i,lat) < 1.e-6) ho2_h(k,i,lat) = 1.e-6
          if (h_hox(k,i,lat) < 1.e-6) h_hox(k,i,lat) = 1.e-6
          if (rmtru_hox(k,i,lat) < 1.) rmtru_hox(k,i,lat) = 1.
!
! h2o2 (Note: tgcm24 contains a commented calculation of h2o2 (see
!             /home/tgcm/tgcm24/cmpmeta.F), but it is not used, and 
!             h2o2 is set to 1.e-60.
!
          h2o2(k,i) = 1.e-60                                        ! xnh2o2
!
! Same for CHxxx species (tgcm24 has expressions for these, but they
! are not used). For now, these are use associated from fields module
! rather than passed in through argument list.
!
          ch3   (k,i,lat) = 1.e-60
          ch3o2 (k,i,lat) = 1.e-60
          ch3ooh(k,i,lat) = 1.e-60
          ch3o  (k,i,lat) = 1.e-60
          ch2o  (k,i,lat) = 1.e-60
          cho   (k,i,lat) = 1.e-60
        enddo ! k=lev0,lev1-1
      enddo ! i=lon0,lon1

!     call addfld('O3_META' ,' ',' ' ,o3(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('O1_META' ,' ',' ' ,o1(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('H2_META' ,' ',' ' ,h2(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('N4S_META',' ',' ',n4s(:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('CO_META' ,' ',' ',co (:,i0:i1),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('RKM36',' ',' ',rkm36(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('RKM37',' ',' ',rkm37(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('RKM25',' ',' ',rkm25(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('RKM33',' ',' ',rkm33(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('RKM42',' ',' ',rkm42(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('HWORK',' ',' ',hwork         ,
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('OH_H' ,' ',' ',oh_h (:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('HO2_H',' ',' ',ho2_h(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('H_HOX',' ',' ',h_hox(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)
!     call addfld('RMTRU',' ',' ',rmtru_hox(:,:,lat),
!    |  'lev',lev0,lev1,'lon',i0,i1,lat)

      end subroutine comp_meta
!-----------------------------------------------------------------------
      subroutine alloc_meta(lon0,lon1,lat0,lat1)
!
! Allocate module data (called from allocdata.F).
!
      use params_module,only: nlevp1
!
! Args:
      integer,intent(in) :: lon0,lon1,lat0,lat1
!
! Local:
      integer :: istat

      allocate(oh_h(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' oh_h: stat=',i3)") istat

      allocate(ho2_h(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' ho2_h: stat=',i3)") istat

      allocate(h_hox(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' h_hox: stat=',i3)") istat

      allocate(rmtru_hox(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' rmtru_hox: stat=',i3)") istat

      allocate(rmtru_ox(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' rmtru_ox: stat=',i3)") istat

! ch3, ch3o2, ch3ooh, ch3o, ch2o, cho

      allocate(ch3(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' ch3: stat=',i3)") istat
      allocate(ch3o2(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' ch3o2: stat=',i3)") istat
      allocate(ch3ooh(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' ch3ooh: stat=',i3)") istat
      allocate(ch3o(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' ch3o: stat=',i3)") istat
      allocate(ch2o(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' ch2o: stat=',i3)") istat
      allocate(cho(nlevp1,lon0:lon1,lat0:lat1),stat=istat)
      if (istat /= 0) write(6,"('>>> alloc_meta: error allocating',
     |  ' cho: stat=',i3)") istat

      end subroutine alloc_meta
!-----------------------------------------------------------------------
      end module comp_meta_module
