!
      subroutine comp_solgar(n2o,cl,clo,lev0,lev1,lon0,lon1,lat)
!
! Transfer imported solomon-garcia species to 3-d fields at
! current latitude (these are redundant in longitude).
! The rwxxx arrays were imported by solgar.F.
!
      use solgar_module,only: rwn2o,rwcl,rwclo ! (nlat,nlevp1)
      use addfld_module,only: addfld
      implicit none
!
! Args:
      integer,intent(in) :: lev0,lev1,lon0,lon1,lat
      real,dimension(lev0:lev1,lon0-2:lon1+2),intent(out) ::
     |  n2o,cl,clo
!
! Local:
      integer :: k,i,nk
!
      do k=lev0,lev1
        n2o(k,lon0:lon1) = rwn2o(lat,k)
        cl (k,lon0:lon1) = rwcl (lat,k)
        clo(k,lon0:lon1) = rwclo(lat,k)
      enddo ! k=lev0,lev1
!
!     nk = lev1-lev0+1
!     call addfld('N2O_SG',' ',' ',n2o(:,lon0:lon1),
!    |  'lev',lev0,lev1,'lon',lon0,lon1,lat)
!     call addfld('CL_SG' ,' ',' ',cl (:,lon0:lon1),
!    |  'lev',lev0,lev1,'lon',lon0,lon1,lat)
!     call addfld('CLO_SG',' ',' ',clo(:,lon0:lon1),
!    |  'lev',lev0,lev1,'lon',lon0,lon1,lat)
!
      end subroutine comp_solgar
