!
      subroutine dfact(t,lon0,lon1,lat)
      use cons_module,only: hor,pi,dtr
      use params_module,only: glat
      implicit none
!
! Args:
      integer,intent(in) :: lon0,lon1,lat
      real,intent(out) :: t(lon0:lon1)
!
! Local:
      integer :: i
      real :: rlat,fack
!
      rlat = glat(lat)*dtr
!
!  T3 = A = .5*(1.+SIN(PI*(ABS(RLATM)-PI/6.)/(PI/3.)))
!            FOR  ABS(RLATM).LT.PI/3.
!       A = 1.    FOR  ABS(RLATM).GE.PI/3
!
      fack = 1.
      if (abs(rlat) < pi/4.5) fack = .5*(1.+sin(pi*(abs(rlat)-
     |  pi/9.)/(pi/4.5)))
!
! fack not used since tgcm22mt (~ Jan, 01):
!
      do i=lon0,lon1
!       t(i) = hor(lat)+fack
        t(i) = hor(lat)
      enddo ! i=lon0,lon1
      end subroutine dfact
