!
      module gw_share
      use params_module,only: pcols=>nlonp4, pver=>nlev, nlon,nlat
!
! Parameters and declarations for gravity wave parameterization,
! shared between timegcm1 mgw module and cam gw_drag module.
!
! Number of constituents for cam module:
      integer,parameter ::
     |  pcnst=1,   ! number of advected constituents (including water vapor)
     |  pnats=1    ! number of non-advected constituents
!
      integer,parameter ::
     |  pgwv = 6  ! number of waves allowed
!    |  pgwv = 5  ! number of waves allowed
!    |  pgwv = 4  ! number of waves allowed
!
! Pressures are set by set_gw_params (mgw.F):
! 1/5/05 btf: add +1 to z dimension to cover transfer in mgw.
      real :: pmid(pcols,pver+1)        ! midpoint pressures
      real :: pdel(pcols,pver+1)        ! delta pressure
      real :: rpdel(pcols,pver+1)       ! 1./pdel
      real :: pint(pcols,0:pver+1)      ! interface pressures
      real :: lnpint(pcols,0:pver+1)    ! log(pint)
      real :: hypi(0:pver+1)            ! interface pressures
!
! Year dependent coefficients
!
      real ::  usorla,ulsorla,faca,faca1,facnh,facsh,
     |         facoron,facoros,uth,wspnh, wspsh
!
! (see also CAMROOT/models/csm_share/shr_const_mod.F90)
      real,parameter ::
     |  cpair = 1004.64,     ! specific heat of dry air (constant p)
     |  cpwv = 1810.0,
     |  cpvir = cpwv/cpair-1.,  ! specific humidity factor for specific heat
     |  grav = 9.8,
     |  rair = 287.04,       ! gas constant for dry air
     |  prndtl = 4.,
     |  prndtlt = 3.,
     |  prndtlm = 3.,
     |  pr_num = 3.,         ! prandtl number as in waccm/vertical_diffusion.F90
     |  km_fac = 3.55E-7     ! molecular viscosity constant
!
! Tendencies structure to be returned by gw_intr:
!     type physics_ptend
!       character*24 :: name ! name of parameterization which produced tendencies.
!       logical :: 
!    |    ls,                ! true if dsdt is returned
!    |    lu,                ! true if dudt is returned
!    |    lv,                ! true if dvdt is returned
!    |    lq(pcnst+pnats)    ! true if dqdt() is returned
!       integer ::              
!    |    top_level, ! top level index for which nonzero tendencies have been set
!    |    bot_level  ! bottom level index for which nonzero tendencies have been set
!       real,dimension(pcols,pver) ::
!    |    s,                 ! heating rate (J/kg/s)
!    |    u,                 ! u momentum tendency (m/s/s)
!    |    v                  ! v momentum tendency (m/s/s)
!       real,dimension(pcols,pver,pcnst+pnats) ::
!    |    q                  ! consituent tendencies (kg/kg/s)
!     end type physics_ptend
!     type(physics_ptend) :: ptend
!
! Orography data (see orogdat.F) 
! As of 7/04, these data can be used with 5.0 deg horizontal resolution only:
      real ::
     |  orog(nlon+1,nlat),
     |  sghdat(nlon+1,nlat)
      contains
!-----------------------------------------------------------------------
      function swap2d(fin,id1,id2)
!
! Return array like input fin(id1,id2), but dimensioned (id2,id1),
!   i.e., swap the dimension positions.
!
! Interface for routine calling swap2d, if needed:
!     function swap2d(fin,id1,id2)
!       implicit none
!       integer,intent(in) :: id1,id2
!       real,intent(in) :: fin(id1,id2)
!       real :: swap2d(id2,id1) ! function result
!     end function swap2d
!
      implicit none
!
! Args:
      integer,intent(in) :: id1,id2
      real,intent(in) :: fin(id1,id2)
!
! Function result:
      real :: swap2d(id2,id1) ! function result
!
! Local: 
      integer :: n1,n2
!
      do n2=1,id2
        do n1=1,id1
          swap2d(n2,n1) = fin(n1,n2)
        enddo
      enddo
      end function swap2d
!-----------------------------------------------------------------------
      function invert2d(fin,id1,id2,iwhichdim)
!
! Return array like input fin(id1,id2), but with values of one of the 
!   dimensions in reversed order. This is used to invert vertical dimensions
!   from tgcm convention (bot->top) to ccm convention (top->bot), 
!   or vice-versa. 
! If iwhichdim==1, invert 1st dimension
! If iwhichdim==2, invert 2nd dimension
! Result array is dimensioned same as input array fin(id1,id2).
!
! Interface for routine calling invert2d, if needed:
!     function invert2d(fin,id1,id2,iwhichdim)
!       implicit none
!       integer,intent(in) :: id1,id2,iwhichdim
!       real,intent(in) :: fin(id1,id2)
!       real :: invert2d(id1,id2) ! function result
!     end function invert2d
!
      implicit none
!
! Args:
      integer,intent(in) :: id1,id2,iwhichdim
      real,intent(in) :: fin(id1,id2)
!
! Function result:
      real :: invert2d(id1,id2) ! function result
!
! Local:
      integer :: n1,n2
! 
      if (iwhichdim==1) then
        do n2=1,id2
          do n1=1,id1
            invert2d(n1,n2) = fin(id1-n1+1,n2)
          enddo
        enddo
      elseif (iwhichdim==2) then
        do n2=1,id2
          do n1=1,id1
            invert2d(n1,n2) = fin(n1,id2-n2+1)
          enddo
        enddo
      else
        write(6,"('>>> invert2d: bad iwhichdim=',i3,
     |    ' -- must be 1 or 2')") iwhichdim
      endif
      end function invert2d
!-----------------------------------------------------------------------
      end module gw_share
