!
! defs.h contains preprocessor macros for the 3d grid.
!
#include <defs.h>
!
      module params_module
!
! Geographic grid parameters:
      integer,parameter :: 
     |  nlat = NLAT,                 ! number of latitudes
     |  nlon = NLON,                 ! number of longitudes
     |  nlev = NLEV,                 ! number of midpoint levels
     |  nilev = NLEV,                ! number of interface levels
     |  nlonp4 = nlon+4,             ! includes periodic points in lon
     |  nlevp1 = nlev+1,
     |  nilevp1 = nilev+1,
     |  nlonp1=nlon+1, nlatp1=nlat+1,
     |  nlonp2=nlon+2, nlatp2=nlat+2
      real,parameter ::
     |  glat1 = GLAT1,               ! first latitude
     |  dlat  = DLAT,                ! delta latitude
     |  glon1 = GLON1,               ! first longitude
     |  dlon  = DLON,                ! delta longitude
     |  dlev  = (ZITOP-ZIBOT)/NLEV,  ! delta level
     |  dz    = dlev,                ! delta level (alias for dlev)
     |  zmtop = ZMTOP,               ! top midpoint level
     |  zmbot = ZMBOT,               ! bottom midpoint level
     |  zitop = ZITOP,               ! top interface level
     |  zibot = ZIBOT                ! bottom interface level
      real :: glon(nlon),glat(nlat),zpmid(nlevp1),zpint(nlevp1)
      real,parameter ::
     |  spval = 1.e36
      integer,parameter ::
     |  ispval = 999
      real :: hres,vres     ! hres=5.0 or 2.5, vres=0.5 or 0.25
!
! Magnetic grid:
      integer,parameter ::
     |  nmlat = 97,         ! number of magnetic latitudes
     |  nmlon = 80,         ! number of magnetic longitudes
     |  nmlonp1=nmlon+1,
     |  nmlonp2=nmlon+2,
     |  nmlatp1=nmlat+1,
     |  nmlath=(nmlat+1)/2, ! index to magnetic equator
!
! timegcm: nmlev=nlevp1, tiegcm: nmlev=nlev 
     |  nmlev   = nlevp1,   ! number of midpoint levels of mag fields (1,nlev)
     |  nimlev  = nmlev,    ! number of interface levels of mag fields (1,nlev)
     |  nmlevp1 = nlevp1,   !
     |  nimlevp1= nimlev+1  !
      real,parameter :: dmlev = dlev
      real :: gmlon(nmlonp1),gmlat(nmlat),zpmag(nmlev),zpimag(nmlev)
!
! zp k-index at which upward dynamo integrals begin (zp -8.):
#if (NLEV==48)
      integer,parameter :: kbotdyn = 19
#elif (NLEV==96)
      integer,parameter :: kbotdyn = 37
#endif
!
! Magnetospheric grid:
      integer,parameter ::
     |  nmagphrlat = 31,
     |  nmagphrlon = 40
      real,parameter ::
     |  magphrlat1 = 71.97, magphrlat2 = 10.14,
     |  magphrlon1 = -180.
!
! Model version name (see modules hist_mod and input_mod).
      character(len=24),parameter :: 
     |  tgcm_version = 'timegcm_trunk           '
!
! tgcm_name is either "tiegcm" or "time-gcm"
      character(len=16),parameter :: tgcm_name    = 'time-gcm        '
!
      integer,parameter ::
     |  mxday=367,         ! max allowed calendar day
     |  mxhvols = 500,     ! max number of output history files
     |  mxseries = 10,     ! max number of time series for primary histories
     |  mxseries_sech = 50,! max number of secondary history time series
     |  mxfsech = 200,     ! max number of fields on secondary histories
     |  mxind_time = 100,  ! max number of time-dependent solar index points
!
! ntndown = number of pressure levels for tndown (tn lower boundary)
! (ntndown = 18 corresponds to zp -21.5 to -17.25 by .25)
!
     | ntndown=18
!
      end module params_module
