/* This version of wrxdrc.c is a temporary routine for
   use on dataproc.  It should be merged with the Cray
   version at some point.  2-1-2001  CSH     */

/* Write xdr data */

#if defined(__sgi)
#include <fortran.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/rpc.h>

/* file handle and xdr stream */
FILE *file;
XDR xdrs;
#define MAXFILES 100
short numfiles=0;
struct xdrfile {
  char *flnm;
  int nframes;
};
static struct xdrfile files[MAXFILES];

/*--------------------------------------------------------------------*/

bool_t xdr_counted_string(char **p)
{
	int input;
	short length;
	XDR *xdrloc;

	xdrloc = &xdrs;
  	input = (xdrloc->x_op == XDR_DECODE);

	if (!input) length = strlen(*p);
	if (!xdr_short(xdrloc, &length)) return(FALSE);

	if (input)
	{
		*p = malloc((unsigned) (length + 1));
		*p[length] = '\0';
	}
	return(length ? xdr_string(xdrloc, p, length) : TRUE);
}

/*--------------------------------------------------------------------*/
/* 
   Main C function to write an xdr file -- this is called from fortran 90
   as follows:
      integer,external :: wrxdrc
      istat = wrxdrc(flnm(1:len_trim(flnm)),hdr1,hdr2,hdr3,hdr4,
     +  f,nx,ny,xx,yy,xlabel,ylabel,mtime,iclose) 
*/

int wrxdrc_(char *flnm, char *hdr1, char *hdr2, char *hdr3, char *hdr4,
	   float *f2d, int *nx, int *ny, float *xx, float *yy,
	   char *xlab, char *ylab, int *mtime, int *iclose)
{
	int slen,istat,n,clen;
	u_int fsize = sizeof(float);
	u_int maxsize;
	char *cflnm, *cstr;
	short frsize,iframe,ifile;
	static int firstrun = 1;

/* Open file and create xdr stream: */
        cflnm = flnm;
        slen = 12;
	strcpy(cflnm+slen,"\0");
	if ((file = fopen(cflnm,"a"))==NULL) {
	  printf("wrxdrc: cannot open file %s\n",cflnm);
	  exit(1);
	}
	xdrstdio_create(&xdrs, file, XDR_ENCODE);
	ifile = 0;

/* Init files if first call: */
	if (firstrun == 1) {
          files[ifile].flnm=cflnm;
	  files[ifile].nframes=0;
	  printf("WRXDR: Opened file %s to receive xdr data (file #%d).\n",
	    cflnm,ifile);
        }

/* Check for new file name: */
	for (n=0; n < MAXFILES; n++) {
	  if (strcmp(files[n].flnm,cflnm)==0) { ifile = n; }
	}
	if (ifile > 0) {	/* new file */
	  numfiles++;
	  if (numfiles > MAXFILES) {
	    printf(">>> WRXDR: too many xdr files = %d (increase MAXFILES)\n",
	      MAXFILES);
	    exit(1);
	  }
	  ifile = numfiles;
	  files[ifile].nframes = 0;
	  files[ifile].flnm = cflnm;
	  printf("WRXDR: Opened file %s to receive xdr data (file #%d).\n",
	    cflnm,ifile);
	}

/* Write dummy integer for later use in frame sizing: */ 
	frsize = 0;
	(void) xdr_short(&xdrs, &frsize);

/* If iclose flag is set, write number of frames to end of file, 
   destroy stream, close file, and return:	*/
	if (*iclose > 0) {
	  iframe = files[ifile].nframes;
	  (void) xdr_short(&xdrs,&iframe);
	  (void) fclose(file);
  	  xdr_destroy(&xdrs);
	  printf("WRXDR: Closed xdr file %s (nframes=%d)\n",
	    cflnm,iframe);
	  return(1);
	}

/* Convert fortran header strings and write each to the file: */
        cstr = hdr1;
	slen = 80;
	strcpy(cstr+slen, "\0");
  	(void) xdr_counted_string(&cstr);

        cstr = hdr2;
	slen = 80;
	strcpy(cstr+slen, "\0");
	(void) xdr_counted_string(&cstr);

        cstr = hdr3;
	slen = 80;
	strcpy(cstr+slen, "\0");
	(void) xdr_counted_string(&cstr);

        cstr = hdr4;
	slen = 80;
	strcpy(cstr+slen, "\0");
	(void) xdr_counted_string(&cstr);

/* Write nx: */
	(void) xdr_int(&xdrs, nx);
/* Write xlab: */
        cstr = xlab;
	slen = 80;
	strcpy(cstr+slen, "\0");
	(void) xdr_counted_string(&cstr);
/* Write xx(nx) */
	for (n=0; n < *nx; n++) {
	  (void) xdr_float(&xdrs,(xx+n));
	}

/* Write ny: */
	(void) xdr_int(&xdrs, ny);
/* Write ylab: */
        cstr = ylab;
	slen = 80;
	strcpy(cstr+slen, "\0");
	(void) xdr_counted_string(&cstr);
/* Write yy(ny) */
	for (n=0; n < *ny; n++) {
	  (void) xdr_float(&xdrs,(yy+n));
	}
/* Write model time (day,hr,min) (this added 4/8/97) */
	for (n=0; n < 3; n++) {
	  (void) xdr_int(&xdrs, (mtime+n));
	}
/* Write data f2d(nx,ny) (may be 1d or 2d): */
	if (*nx > 1 && *ny > 1)
	  for (n=0; n < *nx * *ny; n++) {
	    (void) xdr_float(&xdrs,(f2d+n));
	  }
	else if (*nx == 1 && *ny > 1)
	  for (n=0; n < *ny; n++) {
	    (void) xdr_float(&xdrs,(f2d+n));
	  }
	else if (*ny == 1 && *nx > 1)
	  for (n=0; n < *nx; n++) {
	    (void) xdr_float(&xdrs,(f2d+n));
	  }

/* Report to stdout and close file: */
	files[ifile].nframes++;

  	printf("WRXDR: Wrote frame %d to file %s.\n",
	files[ifile].nframes,cflnm);

	(void) fclose(file);
	xdr_destroy(&xdrs);
	firstrun = 0;
	return(1);
}
