!
      subroutine allocdata
!
! Allocate msc data. Main fields are not allocated here, see
! init_fields in fields.F. This is not in field.F in order to
! avoid circular module dependencies.
!
      use params_module,only: nlevp1,nlonp4,nlat,nmlonp1,nmlat,nmlev
      use fields_module,only: f4d,f3d,nf4d,nf3d,foutput
      use mpi_module,only: lon0,lon1,lat0,lat1,mytid
      use chemrates_module,only: alloc_tdep
      use qrj_module,only: alloc_q
      use efield_module,only: alloc_e
      use mgw_module,only: alloc_gw
      use comp_meta_module,only: alloc_meta
      use compdat_module,only: comp_dat
      use hox_module,only: alloc_hox
      use n4s_module,only: alloc_n4s
      use noz_module,only: alloc_noz
      use ch4_module,only: alloc_ch4
      use co2_module,only: alloc_co2
      use co_module,only: alloc_co
      use h2o_module,only: alloc_h2o
      use h2_module,only: alloc_h2
      use uv_bndry,only: alloc_uvbnd
      use magpres_g_module,only: alloc_pg
      use dynamo_module,only: zpotenm3d
      implicit none
!
! Local:
      integer :: i,istat,nlons,nlats,len
!
! Allocate temperature-dependent chemical reaction rates:
      call alloc_tdep
!
! Allocate ionization rates (qrj module):
      call alloc_q(lon0,lon1,lat0,lat1)
!
! Allocate J(mag.pressure,gravity (magpres_g module):
      call alloc_pg(lon0,lon1,lat0,lat1)
!
! Allocate electric field (efield module):
      call alloc_e(lon0,lon1,lat0,lat1)
!
! Allocate arrays for gravity wave parameterization:
      call alloc_gw(lon0,lon1,lat0,lat1)
!
! Allocate arrays for comp_meta:
      call alloc_meta(lon0,lon1,lat0,lat1)
!
! Allocate for minor species modules:
      call alloc_hox(lon0,lon1,lat0,lat1)
      call alloc_n4s(lon0,lon1,lat0,lat1)
      call alloc_noz(lon0,lon1,lat0,lat1)
      call alloc_ch4(lon0,lon1,lat0,lat1)
      call alloc_co2(lon0,lon1,lat0,lat1)
      call alloc_co (lon0,lon1,lat0,lat1)
      call alloc_h2o(lon0,lon1,lat0,lat1)
      call alloc_h2 (lon0,lon1,lat0,lat1)
!
! Allocate t,u,v lower boundary:
      call alloc_uvbnd(lon0,lon1,lat0,lat1)
!
! Set minor species data:
      call comp_dat
!
! Allocate geopotential height on mag grid (dynamo module):
! real,allocatable(:,:,:),save :: zpotenm3d ! (nmlonp1,nmlat,nmlev)
!
! If this allocation is limited to master task only, then
! the init to zero in advance must also be done by task0 only.
!
!     if (mytid==0) then 

        allocate(zpotenm3d(nmlonp1,nmlat,nmlev),stat=istat)
        if (istat /= 0)
     |    write(6,"('>>> allocdata: error allocating zpotenm3d:',
     |      ' istat=',i3)") istat
        write(6,"('allocdata: allocated zpotenm3d: nmlonp1,nmlat,nmlev='
     |    ,3i5)") nmlonp1,nmlat,nmlev
        zpotenm3d = 0.

!     endif
!
! We are not doing parallel i/o to netcdf output histories, so when
! it comes time to write a history, the task subdomains are gathered
! to the root task (see call mp_gather2root in advance), and only
! the root task writes to the file. Here we allocate the full 3d grid
! for all history fields on the root task. This is where the data
! will be gathered and written by the root when a history is written.
!
! The pointer is declared in fields.F:
!     real,pointer :: foutput(:,:,:,:) ! (nlevp1,nlonp4,nlat,nf4d)
!
#ifdef MPI
      if (mytid==0) then
        allocate(foutput(nlevp1,nlonp4,nlat,nf4d),stat=istat)
        if (istat /= 0) then
          write(6,"('>>> allocdata: error allocating 3d data for ',
     |      'all fields on root task: nlevp1=',i3,' nlonp4=',i3,
     |      ' nlat=',i3,' nf4d=',i3,' istat=',i3)")
     |      nlevp1,nlonp4,nlat,nf4d,istat
        else
          write(6,"('Allocated 3d data for all fields on root task:')")
          len = nlevp1*nlonp4*nlat*nf4d
          write(6,"('  nlevp1*nlonp4*nlat*nf4d = ',i3,'*',i3,'*',
     |      i3,'*',i3,' = ',i8,' words *8 = ',i10,' bytes.')")
     |      nlevp1,nlonp4,nlat,nf4d,len,len*8
        endif    
      endif 
#else
      allocate(foutput(nlevp1,nlonp4,nlat,nf4d),stat=istat)
      if (istat /= 0) then
        write(6,"('>>> allocdata: error allocating 3d data for ',
     |    'all fields on root task: nlevp1=',i3,' nlonp4=',i3,
     |    ' nlat=',i3,' nf4d=',i3,' istat=',i3)")
     |    nlevp1,nlonp4,nlat,nf4d,istat
      else
        write(6,"('Allocated 3d data for all fields on root task:')")
        len = nlevp1*nlonp4*nlat*nf4d
        write(6,"('  nlevp1*nlonp4*nlat*nf4d = ',i3,'*',i3,'*',
     |    i3,'*',i3,' = ',i8,' words *8 = ',i10,' bytes.')")
     |    nlevp1,nlonp4,nlat,nf4d,len,len*8
      endif    
#endif
      foutput = 0.
      end subroutine allocdata
