!
#include <defs.h>
      module compdat_module
      use params_module,only: nlevp1
      use addfld_module,only: addfld
      implicit none
!
      real,dimension(nlevp1),save ::
     |  war,wch4,wco,wco2,wh2,wh2o,whe,whox,wn4s,wnat,wnoz
      contains
!-----------------------------------------------------------------------
      subroutine comp_dat
!
! Regular resolution (DZ = 0.50), with upper boundary at ZP +7:
! #define ZBOT -17. 
! #define ZTOP 7.
! #define NLEV 48
!
#if (NLEV==48)
      war=0.
      wch4=0.
      wco=0.
      wco2=0.
      wh2=0.
      wh2o=0.
      whe=0.
      whox=0.
      wn4s=0.
      wnat=0.
      wnoz=0.
!
! Double resolution (DZ = 0.25), with upper boundary at ZP +7:
! #define ZBOT -17. 
! #define ZTOP 7.
! #define NLEV 96
!
#elif (NLEV==96)
!
! 3/8/01:
! Data for double vertical resolution received from Roble (glbmdkibo)
! These are not available for Argon, Helium, or Sodium, so cmpar, cmphe,
! and cmpnat are not called from dynamics.
!
      war = 0.
!
      WCH4 = (/
     + 0.37138E-06, 0.34469E-06, 0.32097E-06, 0.29936E-06, 0.27951E-06,
     + 0.26126E-06, 0.24451E-06, 0.22939E-06, 0.21632E-06, 0.20551E-06,
     + 0.19689E-06, 0.19023E-06, 0.18522E-06, 0.18121E-06, 0.17763E-06,
     + 0.17434E-06, 0.17113E-06, 0.16780E-06, 0.16412E-06, 0.15987E-06,
     + 0.15485E-06, 0.14884E-06, 0.14166E-06, 0.13318E-06, 0.12346E-06,
     + 0.11268E-06, 0.10121E-06, 0.89539E-07, 0.78132E-07, 0.67404E-07,
     + 0.57651E-07, 0.49035E-07, 0.41603E-07, 0.35235E-07, 0.29780E-07,
     + 0.25168E-07, 0.21306E-07, 0.18100E-07, 0.15457E-07, 0.13298E-07,
     + 0.11555E-07, 0.10010E-07, 0.85099E-08, 0.71202E-08, 0.58896E-08,
     + 0.48397E-08, 0.39636E-08, 0.32322E-08, 0.26057E-08, 0.20456E-08,
     + 0.15266E-08, 0.10489E-08, 0.64145E-09, 0.34021E-09, 0.15527E-09,
     + 0.61856E-10, 0.22208E-10, 0.74853E-11, 0.24711E-11, 0.83091E-12,
     + 0.29430E-12, 0.11277E-12, 0.47650E-13, 0.22459E-13, 0.11862E-13,
     + 0.70153E-14, 0.46216E-14, 0.33637E-14, 0.26743E-14, 0.22905E-14,
     + 0.20809E-14, 0.19749E-14, 0.19317E-14, 0.19267E-14, 0.19442E-14,
     + 0.19740E-14, 0.20098E-14, 0.20473E-14, 0.20839E-14, 0.21181E-14,
     + 0.21492E-14, 0.21769E-14, 0.22012E-14, 0.22223E-14, 0.22403E-14,
     + 0.22557E-14, 0.22688E-14, 0.22798E-14, 0.22891E-14, 0.22968E-14,
     + 0.23033E-14, 0.23088E-14, 0.23133E-14, 0.23171E-14, 0.23202E-14,
     + 0.23228E-14, 0.23250E-14/)
      WCO = (/
     + 0.11432E-07, 0.24337E-07, 0.34078E-07, 0.42550E-07, 0.50417E-07,
     + 0.57948E-07, 0.65553E-07, 0.73611E-07, 0.82272E-07, 0.91968E-07,
     + 0.10352E-06, 0.11763E-06, 0.13470E-06, 0.15677E-06, 0.18665E-06,
     + 0.22623E-06, 0.27774E-06, 0.34377E-06, 0.42733E-06, 0.53194E-06,
     + 0.66167E-06, 0.82123E-06, 0.10158E-05, 0.12505E-05, 0.15295E-05,
     + 0.18554E-05, 0.22287E-05, 0.26470E-05, 0.31049E-05, 0.35946E-05,
     + 0.41076E-05, 0.46364E-05, 0.51744E-05, 0.57251E-05, 0.62938E-05,
     + 0.68795E-05, 0.74832E-05, 0.81073E-05, 0.87561E-05, 0.94349E-05,
     + 0.10150E-04, 0.11008E-04, 0.12133E-04, 0.13550E-04, 0.15247E-04,
     + 0.17172E-04, 0.19241E-04, 0.21368E-04, 0.23479E-04, 0.25521E-04,
     + 0.27465E-04, 0.29292E-04, 0.30992E-04, 0.32556E-04, 0.33965E-04,
     + 0.35174E-04, 0.36141E-04, 0.36834E-04, 0.37222E-04, 0.37282E-04,
     + 0.36998E-04, 0.36369E-04, 0.35411E-04, 0.34152E-04, 0.32631E-04,
     + 0.30892E-04, 0.28983E-04, 0.26950E-04, 0.24839E-04, 0.22695E-04,
     + 0.20560E-04, 0.18471E-04, 0.16460E-04, 0.14554E-04, 0.12775E-04,
     + 0.11135E-04, 0.96438E-05, 0.83033E-05, 0.71114E-05, 0.60619E-05,
     + 0.51457E-05, 0.43520E-05, 0.36691E-05, 0.30850E-05, 0.25877E-05,
     + 0.21663E-05, 0.18105E-05, 0.15110E-05, 0.12595E-05, 0.10488E-05,
     + 0.87262E-06, 0.72553E-06, 0.60288E-06, 0.50072E-06, 0.41570E-06,
     + 0.34500E-06, 0.28625E-06/)
      WCO2 = (/
     + 0.53351E-03, 0.53356E-03, 0.53367E-03, 0.53373E-03, 0.53369E-03,
     + 0.53358E-03, 0.53340E-03, 0.53318E-03, 0.53294E-03, 0.53270E-03,
     + 0.53247E-03, 0.53227E-03, 0.53209E-03, 0.53193E-03, 0.53177E-03,
     + 0.53160E-03, 0.53141E-03, 0.53121E-03, 0.53097E-03, 0.53068E-03,
     + 0.53034E-03, 0.52993E-03, 0.52942E-03, 0.52882E-03, 0.52810E-03,
     + 0.52724E-03, 0.52623E-03, 0.52506E-03, 0.52373E-03, 0.52223E-03,
     + 0.52058E-03, 0.51876E-03, 0.51677E-03, 0.51454E-03, 0.51199E-03,
     + 0.50905E-03, 0.50564E-03, 0.50164E-03, 0.49693E-03, 0.49136E-03,
     + 0.48477E-03, 0.47576E-03, 0.46235E-03, 0.44331E-03, 0.41789E-03,
     + 0.38632E-03, 0.34995E-03, 0.31090E-03, 0.27142E-03, 0.23339E-03,
     + 0.19803E-03, 0.16602E-03, 0.13755E-03, 0.11258E-03, 0.90922E-04,
     + 0.72372E-04, 0.56683E-04, 0.43586E-04, 0.32822E-04, 0.24146E-04,
     + 0.17316E-04, 0.12082E-04, 0.81897E-05, 0.53849E-05, 0.34292E-05,
     + 0.21118E-05, 0.12569E-05, 0.72444E-06, 0.40678E-06, 0.22469E-06,
     + 0.12354E-06, 0.68393E-07, 0.38475E-07, 0.22121E-07, 0.13027E-07,
     + 0.78522E-08, 0.48316E-08, 0.30234E-08, 0.19164E-08, 0.12258E-08,
     + 0.78891E-09, 0.50959E-09, 0.32979E-09, 0.21358E-09, 0.13831E-09,
     + 0.89516E-10, 0.57888E-10, 0.37401E-10, 0.24141E-10, 0.15568E-10,
     + 0.10031E-10, 0.64590E-11, 0.41560E-11, 0.26726E-11, 0.17178E-11,
     + 0.11037E-11, 0.70889E-12/)
      WH2 = (/
     + 0.34643E-07, 0.34615E-07, 0.34650E-07, 0.34762E-07, 0.34959E-07,
     + 0.35251E-07, 0.35654E-07, 0.36182E-07, 0.36856E-07, 0.37697E-07,
     + 0.38730E-07, 0.39969E-07, 0.41409E-07, 0.43184E-07, 0.45471E-07,
     + 0.48356E-07, 0.51937E-07, 0.56332E-07, 0.61683E-07, 0.68161E-07,
     + 0.75968E-07, 0.85330E-07, 0.96462E-07, 0.10950E-06, 0.12439E-06,
     + 0.14084E-06, 0.15823E-06, 0.17569E-06, 0.19232E-06, 0.20751E-06,
     + 0.22098E-06, 0.23268E-06, 0.24265E-06, 0.25113E-06, 0.25833E-06,
     + 0.26439E-06, 0.26946E-06, 0.27370E-06, 0.27728E-06, 0.28036E-06,
     + 0.28309E-06, 0.28581E-06, 0.28879E-06, 0.29195E-06, 0.29510E-06,
     + 0.29792E-06, 0.29993E-06, 0.30047E-06, 0.29864E-06, 0.29333E-06,
     + 0.28321E-06, 0.26690E-06, 0.24346E-06, 0.21319E-06, 0.17826E-06,
     + 0.14237E-06, 0.10930E-06, 0.81599E-07, 0.60075E-07, 0.44251E-07,
     + 0.33025E-07, 0.25207E-07, 0.19779E-07, 0.15973E-07, 0.13246E-07,
     + 0.11236E-07, 0.97099E-08, 0.85310E-08, 0.76242E-08, 0.69529E-08,
     + 0.65009E-08, 0.62630E-08, 0.62423E-08, 0.64503E-08, 0.69087E-08,
     + 0.76510E-08, 0.87244E-08, 0.10192E-07, 0.12134E-07, 0.14656E-07,
     + 0.17887E-07, 0.21992E-07, 0.27177E-07, 0.33699E-07, 0.41879E-07,
     + 0.52119E-07, 0.64919E-07, 0.80902E-07, 0.10085E-06, 0.12572E-06,
     + 0.15674E-06, 0.19540E-06, 0.24358E-06, 0.30362E-06, 0.37843E-06,
     + 0.47163E-06, 0.58773E-06/)
      WH2O = (/
     + 0.27438E-05, 0.27872E-05, 0.28222E-05, 0.28506E-05, 0.28737E-05,
     + 0.28919E-05, 0.29059E-05, 0.29154E-05, 0.29197E-05, 0.29183E-05,
     + 0.29116E-05, 0.28998E-05, 0.28837E-05, 0.28621E-05, 0.28334E-05,
     + 0.27971E-05, 0.27526E-05, 0.26993E-05, 0.26367E-05, 0.25636E-05,
     + 0.24791E-05, 0.23815E-05, 0.22697E-05, 0.21428E-05, 0.20012E-05,
     + 0.18465E-05, 0.16814E-05, 0.15096E-05, 0.13366E-05, 0.11696E-05,
     + 0.10148E-05, 0.87594E-06, 0.75456E-06, 0.64911E-06, 0.55751E-06,
     + 0.47888E-06, 0.41199E-06, 0.35551E-06, 0.30811E-06, 0.26861E-06,
     + 0.23603E-06, 0.20648E-06, 0.17723E-06, 0.14967E-06, 0.12496E-06,
     + 0.10381E-06, 0.86374E-07, 0.72362E-07, 0.61245E-07, 0.52429E-07,
     + 0.45372E-07, 0.39623E-07, 0.34827E-07, 0.30704E-07, 0.27054E-07,
     + 0.23748E-07, 0.20698E-07, 0.17847E-07, 0.15172E-07, 0.12680E-07,
     + 0.10395E-07, 0.83486E-08, 0.65627E-08, 0.50469E-08, 0.37952E-08,
     + 0.27903E-08, 0.20078E-08, 0.14195E-08, 0.99365E-09, 0.69619E-09,
     + 0.49427E-09, 0.35964E-09, 0.27055E-09, 0.21152E-09, 0.17212E-09,
     + 0.14551E-09, 0.12728E-09, 0.11455E-09, 0.10545E-09, 0.98763E-10,
     + 0.93661E-10, 0.89604E-10, 0.86236E-10, 0.83318E-10, 0.80698E-10,
     + 0.78276E-10, 0.75989E-10, 0.73799E-10, 0.71681E-10, 0.69622E-10,
     + 0.67613E-10, 0.65652E-10, 0.63736E-10, 0.61865E-10, 0.60038E-10,
     + 0.58255E-10, 0.56518E-10/)
!
      whe = 0.
!
       WHOX = (/
     + 0.11301E-09, 0.84572E-10, 0.77170E-10, 0.91189E-10, 0.12118E-09,
     + 0.16506E-09, 0.21294E-09, 0.26173E-09, 0.32378E-09, 0.40981E-09,
     + 0.51691E-09, 0.63255E-09, 0.74379E-09, 0.84454E-09, 0.93420E-09,
     + 0.10145E-08, 0.10894E-08, 0.11637E-08, 0.12425E-08, 0.13310E-08,
     + 0.14346E-08, 0.15623E-08, 0.17296E-08, 0.19608E-08, 0.23154E-08,
     + 0.29537E-08, 0.39710E-08, 0.50592E-08, 0.64752E-08, 0.87582E-08,
     + 0.11594E-07, 0.14486E-07, 0.17144E-07, 0.19481E-07, 0.21502E-07,
     + 0.23224E-07, 0.24691E-07, 0.25964E-07, 0.27104E-07, 0.28178E-07,
     + 0.29257E-07, 0.30520E-07, 0.32179E-07, 0.34385E-07, 0.37312E-07,
     + 0.41178E-07, 0.46280E-07, 0.53022E-07, 0.61947E-07, 0.73768E-07,
     + 0.89365E-07, 0.10972E-06, 0.13566E-06, 0.16745E-06, 0.20432E-06,
     + 0.24455E-06, 0.28622E-06, 0.32808E-06, 0.36994E-06, 0.41262E-06,
     + 0.45757E-06, 0.50668E-06, 0.56214E-06, 0.62648E-06, 0.70277E-06,
     + 0.79478E-06, 0.90721E-06, 0.10460E-05, 0.12187E-05, 0.14348E-05,
     + 0.17065E-05, 0.20490E-05, 0.24819E-05, 0.30298E-05, 0.37241E-05,
     + 0.46044E-05, 0.57210E-05, 0.71372E-05, 0.89336E-05, 0.11212E-04,
     + 0.14100E-04, 0.17761E-04, 0.22400E-04, 0.28277E-04, 0.35722E-04,
     + 0.45151E-04, 0.57091E-04, 0.72209E-04, 0.91349E-04, 0.11558E-03,
     + 0.14625E-03, 0.18508E-03, 0.23422E-03, 0.29641E-03, 0.37513E-03,
     + 0.47476E-03, 0.60086E-03/)
      WN4S = (/
     + 0.16840E-16, 0.47228E-16, 0.11302E-15, 0.23710E-15, 0.42523E-15,
     + 0.69921E-15, 0.11241E-14, 0.17748E-14, 0.27075E-14, 0.40267E-14,
     + 0.60082E-14, 0.93173E-14, 0.15273E-13, 0.25976E-13, 0.45200E-13,
     + 0.80777E-13, 0.14847E-12, 0.27928E-12, 0.53371E-12, 0.10264E-11,
     + 0.19618E-11, 0.36689E-11, 0.65907E-11, 0.11161E-10, 0.17580E-10,
     + 0.26071E-10, 0.38897E-10, 0.63582E-10, 0.11453E-09, 0.21302E-09,
     + 0.39001E-09, 0.69314E-09, 0.11987E-08, 0.20496E-08, 0.35086E-08,
     + 0.60202E-08, 0.10297E-07, 0.17432E-07, 0.29011E-07, 0.47064E-07,
     + 0.73193E-07, 0.11061E-06, 0.16075E-06, 0.22018E-06, 0.28446E-06,
     + 0.34926E-06, 0.41125E-06, 0.46900E-06, 0.52411E-06, 0.58179E-06,
     + 0.65129E-06, 0.75147E-06, 0.95180E-06, 0.15007E-05, 0.26777E-05,
     + 0.46813E-05, 0.83379E-05, 0.15829E-04, 0.31455E-04, 0.62779E-04,
     + 0.12090E-03, 0.21877E-03, 0.36766E-03, 0.57332E-03, 0.83413E-03,
     + 0.11417E-02, 0.14838E-02, 0.18468E-02, 0.22185E-02, 0.25895E-02,
     + 0.29536E-02, 0.33071E-02, 0.36488E-02, 0.39789E-02, 0.42981E-02,
     + 0.46077E-02, 0.49090E-02, 0.52030E-02, 0.54911E-02, 0.57743E-02,
     + 0.60538E-02, 0.63306E-02, 0.66057E-02, 0.68802E-02, 0.71551E-02,
     + 0.74313E-02, 0.77098E-02, 0.79913E-02, 0.82767E-02, 0.85667E-02,
     + 0.88622E-02, 0.91637E-02, 0.94720E-02, 0.97875E-02, 0.10111E-01,
     + 0.10443E-01, 0.10784E-01/)
!
      wnat = 0.
!
      WNOZ = (/
     + 0.10610E-07, 0.98177E-08, 0.92662E-08, 0.88711E-08, 0.86049E-08,
     + 0.83640E-08, 0.80425E-08, 0.76366E-08, 0.72246E-08, 0.68329E-08,
     + 0.64815E-08, 0.61979E-08, 0.59781E-08, 0.57930E-08, 0.56140E-08,
     + 0.54291E-08, 0.52327E-08, 0.50237E-08, 0.48051E-08, 0.45839E-08,
     + 0.43713E-08, 0.41831E-08, 0.40401E-08, 0.39672E-08, 0.39935E-08,
     + 0.41500E-08, 0.44659E-08, 0.49733E-08, 0.57311E-08, 0.68581E-08,
     + 0.85664E-08, 0.11215E-07, 0.15409E-07, 0.22287E-07, 0.33843E-07,
     + 0.53263E-07, 0.85539E-07, 0.13842E-06, 0.22353E-06, 0.35702E-06,
     + 0.55831E-06, 0.88661E-06, 0.14332E-05, 0.22970E-05, 0.36045E-05,
     + 0.54992E-05, 0.81206E-05, 0.11586E-04, 0.15993E-04, 0.21439E-04,
     + 0.28041E-04, 0.35918E-04, 0.45325E-04, 0.56981E-04, 0.70254E-04,
     + 0.82102E-04, 0.90521E-04, 0.95517E-04, 0.97605E-04, 0.97741E-04,
     + 0.96888E-04, 0.95581E-04, 0.93879E-04, 0.91614E-04, 0.88607E-04,
     + 0.84738E-04, 0.79958E-04, 0.74282E-04, 0.67828E-04, 0.60845E-04,
     + 0.53682E-04, 0.46688E-04, 0.40134E-04, 0.34179E-04, 0.28889E-04,
     + 0.24265E-04, 0.20272E-04, 0.16855E-04, 0.13954E-04, 0.11507E-04,
     + 0.94552E-05, 0.77445E-05, 0.63251E-05, 0.51529E-05, 0.41885E-05,
     + 0.33981E-05, 0.27523E-05, 0.22261E-05, 0.17983E-05, 0.14512E-05,
     + 0.11701E-05, 0.94277E-06, 0.75915E-06, 0.61098E-06, 0.49153E-06,
     + 0.39529E-06, 0.31780E-06/)
#endif
      end subroutine comp_dat
      end module compdat_module
