!
      subroutine qtieff(lev0,lev1,lon0,lon1,lat)
!
! Calculates electron production of n4s and n2d in pdn2:
!
      use qrj_module,only: pdn2
      use chemrates_module,only: disn2p
      use addfld_module,only: addfld
      implicit none
!
! Args:
      integer,intent(in) :: lev0,lev1,lon0,lon1,lat
!
! Local:
      integer :: k,i,nlevs
!
      do i=lon0,lon1
        do k=lev0,lev1
!         qtef(k,i,lat) = qtef(k,i,lat)+1.57*qn2p(k,i,lat) ! tgcm15/tiegcm1
          pdn2(k,i,lat) = pdn2(k,i,lat)+1.57*disn2p(k,i,lat)+1.0e-3
        enddo ! k=lev0,lev1
      enddo ! i=lon0,lon1
!
!     nlevs = lev1-lev0+1
!     call addfld('DISN2P',' ',' ',disn2p(lev0:lev1,lon0:lon1,lat),
!    |  'lev',1,nlevs,'lon',lon0,lon1,lat)
!     call addfld('QTEF'  ,' ',' ',pdn2(lev0:lev1,lon0:lon1,lat),
!    |  'lev',1,nlevs,'lon',lon0,lon1,lat)

      end subroutine qtieff
