!
      program tgcm
!
! Main program for tgcm models.
!
      use input_module,only: input,dynamo,step,dispose,cwd,
     |  potential_model
      use dispose_module,only: init_dispose
      use fields_module,only: itp
      use init_module,only: init,iyear
      use hist_module,only: nstep
      use advance_module,only: advance
      use lbc,only: init_lbc
      use qrj_module,only: init_qrj
      use heatnirco2_module,only: heatnirco2_init
      use magfield_module,only: magfield
      use apex_module,only: apxparm
      use timing_module,only: timer,timer_report,init_timer
      use mgw_module,only: set_gw_params
      use mpi_module,only: mytid,ntask,mpi_timing
#ifdef MPI
      use mpi_module,only: mp_init,mp_close,mp_distribute,
     |  report_mpi_timing
#endif
      implicit none
!
! Local:
!     integer :: ier,icount_tgcm,icount_apex,nsecs
      real :: cpu1,cpu2
      integer :: ier,nsecs
      real :: 
     |  time0,     time1,
     |  time0_apx, time1_apx,
     |  time0_run, time1_run,
     |  time0_init,time1_init
!
#ifndef IRIX
      call cpu_time(cpu1)
#endif
!
! Report starting time and other info to stdout:
      call startup_message
!
! Initialize timing (must be called after mp_init):
      call init_timer
!
! Initialize MPI:
#ifdef MPI
      call mp_init
#endif
!
! Init timing for the run, get cwd, get user input,
!   set up 2d decomposition.
!
      call timer(time0_run,time1_run,'RUN',0,0)    ! start run timing
      call timer(time0_init,time1_init,'INIT',0,0) ! start init timing
      call getcwd(cwd)
      write(6,"('Current working directory (cwd) = ',a,/)") trim(cwd)
      call input(mytid,ntask) ! get user input (mpi)
      if (mytid==0) call init_dispose(dispose)
#ifdef MPI
      call mp_distribute
#endif
!
! Do initialization:
      call init
!
! Initialization for qrj:
! (These are not in init_module so as to avoid circular dependency between
!  init_module and qrj_module)
! 10/10/06 btf: new qrj does not have init_euvac or init_sigmas
      call init_qrj
!     call init_euvac
!     call init_sigmas
      call heatnirco2_init
!
! Init for gw (moved from sub init to avoid long compilations when
! gw files are modified):
      call set_gw_params
      call orogdat
!
! Read source history:
      call readsource(ier)
!
! Call apex code if doing new dynamo (should eliminate some of the
! magfield calls if this is set).
      if (dynamo > 0.or.
     |   (dynamo <= 0 .and.trim(potential_model) /= 'NONE')) then
        call timer(time0_apx,time1_apx,'apxparm',0,0)
        write(6,"('tgcm: dynamo=',i2,' -- calling apxparm: iyear=',
     |    i5)") dynamo,iyear
        call apxparm(real(iyear))
        call timer(time0_apx,time1_apx,'apxparm',1,0)
        write(6,"('Time in apxparm = ',f6.3,' (secs)')") time1_apx
      endif
!
! Read magnetic data file and set magnetic field parameters:
! (data file not read if dynamo > 0, since in this case apxparm
!  was called above)
! btf 6/15/04: magvol is no longer used, but magfield must be
!              called to define mag field and phim3d from source history.
!
      call magfield(dynamo)
!
! Set several lower boundary parameters (including Hough mode functions):
      call init_lbc ! lbc module
!
      call timer(time0_init,time1_init,'INIT',1,0) ! end init timing
!
! Advance the model (timing in main time-step loop is done in advance):
      call advance
!
! Report to stdout:
      write(6,"(' ')")
#ifdef MPI
      write(6,"('MPI run with ntask = ',i3)") ntask
#endif
      write(6,"('nstep=',i5,' step=',i5)") nstep,step
      nsecs = nstep*step
      write(6,"('Model simulation time = ',i8,' secs ',/,
     |  '  (minutes=',f8.2,', hours=',f8.2,', days=',f10.6,')')") 
     |  nsecs,float(nsecs)/60.,float(nsecs)/3600.,
     |  float(nsecs)/(24.*3600.)
!
! End timing:
!
#ifndef IRIX
      call cpu_time(cpu2)
      write(6,"('Cpu time for run = ',f10.2)") cpu2-cpu1
#endif
      call timer(time0_run,time1_run,'RUN',1,0) ! end total run timing
!
! Finalize mpi:
!
#ifdef MPI
      call mp_close
      if (mpi_timing) call report_mpi_timing
#endif
      call timer_report
!
      call final_message
      write(6,"('NORMAL EXIT')")
      end program tgcm
!-----------------------------------------------------------------------
      subroutine startup_message
!
! Print startup message to stdout including date and time, host node,
!   operating system, and current working directory. Subroutines called
!   are in util.F.
! getcwd does not work here, because it requires mpi_barrier, and mpi
!   is not started yet. Getcwd is called by main tgcm above.
!
      use params_module,only: tgcm_version
      character(len=8) ::
     |  rundate,           ! current local date
     |  runtime            ! current local time
      character(len=16) ::
     |  host,              ! host machine
     |  system,            ! operating system of host (from pre-proc macros)
     |  logname            ! user login name
!     character(len=120) :: cwd  ! current working directory
!
      call datetime(rundate,runtime) 
      call gethostsname(host)
      call setosys(system)
!     call getcwd(cwd)
      logname = ' '
      call getenv('LOGNAME',logname)
      if (len_trim(logname)==0) logname = "unknown"
      write(6,"(/,72('='))")
      write(6,"('Begin execution of ',a,' at ',a,'  ',a)")
     |  trim(tgcm_version),rundate,runtime
      write(6,"('  Host    = ',a)") trim(host)
      write(6,"('  System  = ',a)") trim(system)
      write(6,"('  Logname = ',a)") trim(logname)
!     write(6,"('  Cwd     = ',a)") trim(cwd)
      write(6,"  (72('='),/)")
      end subroutine startup_message
!-----------------------------------------------------------------------
      subroutine final_message
!
! Print end-of-execution message to stdout with date and time:
!
      use params_module,only: tgcm_version
      character(len=8) ::
     |  rundate,           ! current local date
     |  runtime            ! current local time
      call datetime(rundate,runtime) 
      write(6,"('End execution of ',a,' at ',a,'  ',a)")
     |  trim(tgcm_version),rundate,runtime
      end subroutine final_message
