c
      subroutine orogdat
!
! Orography data for gw_drag. Data is declared in mgw.F.
! This is called once per run from main tgcm.F.
!
! 4/2/93 (bf): These data statements for orography were made from
! ~roble/thunder/old/thunder.data for use in timesgcm gravity waves
! (see ~foster/timesgcm/thunder)
!
! 7/30/04 btf: convert to array constructors and use mgw module for timegcm.
!   Note this data is good for 5.0 deg horizontal resolution only.
!
      use gw_share,only: orog,sghdat
      implicit none
      integer :: i
!
! This data for 5 deg res only:
!
#if (NLAT==36)
#if (NLON==72)
      write(6,"('orogdat: initializing orog and sghdat for ',
     |  'gravity wave parameterization..')")
      OROG(:,1) = (/
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04, 0.25600E+04,
     | 0.25600E+04, 0.25600E+04, 0.25600E+04/)
      OROG(:,2) = (/
     | 0.10950E+04, 0.94000E+03, 0.93500E+03, 0.93100E+03, 0.92700E+03,
     | 0.92300E+03, 0.10310E+04, 0.11400E+04, 0.11790E+04, 0.12180E+04,
     | 0.13500E+04, 0.14810E+04, 0.16430E+04, 0.18050E+04, 0.19780E+04,
     | 0.21510E+04, 0.22170E+04, 0.22830E+04, 0.22540E+04, 0.22250E+04,
     | 0.20580E+04, 0.18910E+04, 0.18130E+04, 0.17330E+04, 0.17460E+04,
     | 0.17600E+04, 0.17180E+04, 0.16760E+04, 0.17220E+04, 0.17680E+04,
     | 0.18910E+04, 0.20150E+04, 0.21640E+04, 0.23140E+04, 0.24050E+04,
     | 0.24940E+04, 0.25940E+04, 0.26950E+04, 0.26950E+04, 0.27860E+04,
     | 0.28780E+04, 0.29250E+04, 0.29710E+04, 0.30330E+04, 0.30950E+04,
     | 0.31680E+04, 0.32410E+04, 0.32900E+04, 0.33380E+04, 0.34010E+04,
     | 0.34650E+04, 0.35550E+04, 0.36460E+04, 0.36200E+04, 0.35930E+04,
     | 0.35040E+04, 0.34150E+04, 0.33600E+04, 0.33060E+04, 0.32420E+04,
     | 0.31780E+04, 0.31240E+04, 0.30700E+04, 0.29390E+04, 0.28080E+04,
     | 0.26800E+04, 0.25510E+04, 0.24300E+04, 0.23100E+04, 0.20140E+04,
     | 0.17180E+04, 0.14850E+04, 0.12510E+04/)
      OROG(:,3) = (/
     | 0.10200E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.30000E+01,
     | 0.34000E+02, 0.23900E+03, 0.51500E+03, 0.71600E+03, 0.10110E+04,
     | 0.13420E+04, 0.15660E+04, 0.16940E+04, 0.16350E+04, 0.16580E+04,
     | 0.17250E+04, 0.17650E+04, 0.18630E+04, 0.18700E+04, 0.18200E+04,
     | 0.15240E+04, 0.12280E+04, 0.10770E+04, 0.92600E+03, 0.79900E+03,
     | 0.62500E+03, 0.53200E+03, 0.43600E+03, 0.46000E+03, 0.50600E+03,
     | 0.67900E+03, 0.10400E+04, 0.14860E+04, 0.18790E+04, 0.21700E+04,
     | 0.24110E+04, 0.26120E+04, 0.27800E+04, 0.27800E+04, 0.30110E+04,
     | 0.31460E+04, 0.32200E+04, 0.33110E+04, 0.34280E+04, 0.35050E+04,
     | 0.35450E+04, 0.35610E+04, 0.35170E+04, 0.34360E+04, 0.33470E+04,
     | 0.32650E+04, 0.33070E+04, 0.34060E+04, 0.34670E+04, 0.35830E+04,
     | 0.36490E+04, 0.37000E+04, 0.36350E+04, 0.35330E+04, 0.34100E+04,
     | 0.33030E+04, 0.32340E+04, 0.31650E+04, 0.30370E+04, 0.28360E+04,
     | 0.26670E+04, 0.25200E+04, 0.23580E+04, 0.21700E+04, 0.17560E+04,
     | 0.11760E+04, 0.61500E+03, 0.20500E+03/)
      OROG(:,4) = (/
     | 0.10000E+01, 0.50000E+01, 0.50000E+01, 0.50000E+01, 0.50000E+01,
     | 0.34000E+02, 0.12700E+03, 0.29500E+03, 0.48600E+03, 0.77300E+03,
     | 0.10370E+04, 0.12010E+04, 0.12010E+04, 0.93000E+03, 0.79500E+03,
     | 0.71000E+03, 0.70500E+03, 0.75800E+03, 0.88100E+03, 0.91000E+03,
     | 0.79500E+03, 0.67700E+03, 0.75200E+03, 0.96600E+03, 0.93200E+03,
     | 0.17500E+03, 0.85000E+02, 0.31000E+02, 0.10000E+02, 0.11000E+02,
     | 0.62000E+02, 0.30000E+03, 0.60400E+03, 0.87200E+03, 0.12350E+04,
     | 0.16340E+04, 0.19460E+04, 0.21650E+04, 0.21650E+04, 0.23860E+04,
     | 0.24640E+04, 0.25250E+04, 0.25860E+04, 0.26800E+04, 0.28250E+04,
     | 0.30040E+04, 0.31810E+04, 0.32600E+04, 0.31640E+04, 0.28070E+04,
     | 0.24990E+04, 0.21490E+04, 0.19210E+04, 0.24200E+04, 0.29890E+04,
     | 0.33380E+04, 0.35240E+04, 0.34680E+04, 0.33590E+04, 0.32390E+04,
     | 0.31630E+04, 0.31340E+04, 0.31050E+04, 0.30680E+04, 0.29160E+04,
     | 0.27140E+04, 0.25980E+04, 0.24230E+04, 0.21840E+04, 0.19010E+04,
     | 0.12480E+04, 0.55900E+03, 0.63000E+02/)
      OROG(:,5) = (/
     | 0.10000E+01, 0.50000E+01, 0.50000E+01, 0.50000E+01, 0.30000E+01,
     | 0.00000E+00, 0.00000E+00, 0.50000E+01, 0.50000E+01, 0.70000E+01,
     | 0.43000E+02, 0.84000E+02, 0.90000E+02, 0.10000E+02, 0.50000E+01,
     | 0.50000E+01, 0.50000E+01, 0.50000E+01, 0.71000E+02, 0.10000E+03,
     | 0.10600E+03, 0.10900E+03, 0.25000E+03, 0.52900E+03, 0.88000E+03,
     | 0.14500E+03, 0.80000E+01, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.28000E+02, 0.17700E+03,
     | 0.41800E+03, 0.62100E+03, 0.76500E+03, 0.76500E+03, 0.83200E+03,
     | 0.85300E+03, 0.87200E+03, 0.88000E+03, 0.90500E+03, 0.10200E+04,
     | 0.11990E+04, 0.14000E+04, 0.16600E+04, 0.18780E+04, 0.16960E+04,
     | 0.13840E+04, 0.84600E+03, 0.57000E+03, 0.10150E+04, 0.16460E+04,
     | 0.21090E+04, 0.22740E+04, 0.22300E+04, 0.21260E+04, 0.19910E+04,
     | 0.18340E+04, 0.17470E+04, 0.17100E+04, 0.17580E+04, 0.17640E+04,
     | 0.17520E+04, 0.16520E+04, 0.13130E+04, 0.10690E+04, 0.95700E+03,
     | 0.64100E+03, 0.32900E+03, 0.63000E+02/)
      OROG(:,6) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.30000E+01, 0.50000E+01, 0.25700E+03,
     | 0.10000E+03, 0.30000E+01, 0.50000E+01, 0.50000E+01, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.50000E+01, 0.50000E+01, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.50000E+01, 0.50000E+01, 0.50000E+01,
     | 0.50000E+01, 0.50000E+01, 0.12700E+03, 0.34500E+03, 0.40200E+03,
     | 0.28400E+03, 0.47000E+02, 0.50000E+01, 0.37000E+02, 0.24000E+03,
     | 0.50700E+03, 0.62400E+03, 0.61200E+03, 0.55400E+03, 0.46700E+03,
     | 0.32900E+03, 0.24200E+03, 0.20500E+03, 0.25200E+03, 0.30000E+03,
     | 0.40700E+03, 0.36400E+03, 0.11700E+03, 0.50000E+01, 0.50000E+01,
     | 0.50000E+01, 0.00000E+00, 0.00000E+00/)
      OROG(:,7) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.50000E+01,
     | 0.50000E+01, 0.50000E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,8) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.15000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,9) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.20000E+03, 0.41000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,10) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.20000E+03, 0.91000E+03, 0.15000E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.50000E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,11) = (/
     | 0.14500E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.19000E+04, 0.20000E+03,
     | 0.45000E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.50000E+01, 0.41500E+03, 0.50000E+01, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,12) = (/
     | 0.14500E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.28750E+04, 0.66000E+03,
     | 0.85000E+02, 0.13000E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.45000E+03, 0.60000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.50000E+01, 0.16000E+03, 0.35000E+02, 0.00000E+00,
     | 0.55000E+02, 0.40000E+02, 0.42500E+03, 0.55500E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,13) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.30250E+04, 0.16000E+04,
     | 0.13500E+03, 0.28000E+03, 0.37500E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.50000E+01, 0.10700E+04, 0.13000E+04, 0.76500E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.15500E+03, 0.48500E+03, 0.33500E+03, 0.25000E+03,
     | 0.18500E+03, 0.90000E+02, 0.17500E+03, 0.80000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,14) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.26250E+04, 0.27250E+04,
     | 0.21500E+03, 0.28500E+03, 0.75000E+03, 0.50000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.35500E+03, 0.12800E+04, 0.13150E+04, 0.13600E+04,
     | 0.50000E+01, 0.00000E+00, 0.47500E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.19500E+03, 0.62500E+03, 0.44000E+03, 0.52000E+03,
     | 0.35500E+03, 0.18000E+03, 0.32500E+03, 0.30000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,15) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.28250E+04, 0.29450E+04,
     | 0.24000E+03, 0.43000E+03, 0.74500E+03, 0.10600E+04, 0.13000E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.97500E+03, 0.13350E+04, 0.12400E+04, 0.12250E+04,
     | 0.14500E+03, 0.00000E+00, 0.62500E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.45000E+02, 0.30000E+03, 0.32000E+03, 0.53000E+03,
     | 0.28500E+03, 0.14500E+03, 0.33000E+03, 0.50000E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,16) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.17700E+04, 0.26600E+04, 0.13900E+04,
     | 0.38000E+03, 0.59500E+03, 0.74000E+03, 0.10150E+04, 0.42500E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.13750E+04, 0.14250E+04, 0.12750E+04, 0.12800E+04,
     | 0.69000E+03, 0.60000E+02, 0.15000E+03, 0.50000E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.18000E+03, 0.26000E+03,
     | 0.65000E+02, 0.20000E+02, 0.12000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,17) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.25450E+04, 0.12000E+04, 0.13000E+03,
     | 0.36000E+03, 0.43000E+03, 0.53500E+03, 0.70000E+03, 0.64000E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.11500E+04, 0.12000E+04, 0.11000E+04, 0.13000E+04,
     | 0.11500E+04, 0.60000E+02, 0.00000E+00, 0.50000E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.37500E+03, 0.50000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,18) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.11250E+04, 0.99500E+03, 0.20500E+03, 0.13000E+03,
     | 0.15000E+03, 0.18000E+03, 0.22500E+03, 0.27000E+03, 0.35000E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.75000E+03, 0.69000E+03, 0.77500E+03, 0.14000E+04,
     | 0.16500E+04, 0.65000E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.10500E+03,
     | 0.00000E+00, 0.60000E+02, 0.18500E+03, 0.00000E+00, 0.00000E+00,
     | 0.37000E+03, 0.47500E+03, 0.50000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,19) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.11250E+04, 0.94500E+03, 0.41500E+03, 0.40000E+03,
     | 0.37500E+03, 0.30500E+03, 0.60000E+02, 0.25000E+02, 0.50000E+01,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.21500E+03, 0.70000E+03, 0.48000E+03, 0.59500E+03, 0.13000E+04,
     | 0.16000E+04, 0.31000E+03, 0.50000E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.41500E+03, 0.10500E+03,
     | 0.00000E+00, 0.66000E+03, 0.18500E+03, 0.00000E+00, 0.00000E+00,
     | 0.37000E+03, 0.10000E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,20) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.60000E+02, 0.17150E+04, 0.85000E+03, 0.60500E+03,
     | 0.45000E+03, 0.25500E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.13000E+03, 0.15000E+03, 0.12500E+03, 0.12500E+03, 0.12500E+03,
     | 0.66000E+03, 0.85000E+03, 0.61500E+03, 0.57000E+03, 0.79000E+03,
     | 0.15000E+04, 0.14400E+04, 0.55000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.12500E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.51000E+03, 0.00000E+00,
     | 0.00000E+00, 0.60000E+03, 0.00000E+00, 0.30000E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,21) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.41000E+03, 0.60000E+02, 0.99000E+03, 0.50000E+03, 0.25000E+03,
     | 0.12500E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.30000E+02,
     | 0.26000E+03, 0.34000E+03, 0.31000E+03, 0.31000E+03, 0.34000E+03,
     | 0.69500E+03, 0.68500E+03, 0.72500E+03, 0.80000E+03, 0.49000E+03,
     | 0.14500E+04, 0.17400E+04, 0.50000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.20000E+03, 0.17000E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.19500E+03, 0.18500E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.30500E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,22) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.61500E+03, 0.45000E+03, 0.18500E+03,
     | 0.41000E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.80000E+02,
     | 0.26000E+03, 0.38000E+03, 0.38500E+03, 0.38500E+03, 0.45000E+03,
     | 0.50000E+03, 0.31000E+03, 0.53500E+03, 0.95000E+03, 0.47500E+03,
     | 0.75000E+03, 0.10200E+04, 0.10000E+04, 0.40000E+03, 0.60000E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.56500E+03, 0.41000E+03,
     | 0.00000E+00, 0.00000E+00, 0.95000E+02, 0.48500E+03, 0.38000E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.50000E+01, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,23) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.67500E+03, 0.12300E+04, 0.45000E+03, 0.18500E+03,
     | 0.00000E+00, 0.25000E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.11000E+03,
     | 0.26000E+03, 0.31000E+03, 0.39000E+03, 0.39000E+03, 0.83500E+03,
     | 0.80500E+03, 0.67500E+03, 0.81000E+03, 0.77500E+03, 0.40500E+03,
     | 0.50000E+03, 0.10700E+04, 0.14000E+04, 0.49500E+03, 0.24500E+03,
     | 0.00000E+00, 0.00000E+00, 0.10000E+02, 0.63000E+03, 0.69500E+03,
     | 0.27000E+03, 0.12500E+03, 0.34500E+03, 0.15350E+04, 0.84500E+03,
     | 0.15000E+03, 0.60000E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,24) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.50000E+01,
     | 0.16500E+03, 0.15000E+04, 0.86000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.25000E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.60000E+02,
     | 0.50500E+03, 0.42000E+03, 0.40000E+03, 0.40000E+03, 0.95000E+03,
     | 0.93000E+03, 0.90500E+03, 0.74500E+03, 0.44000E+03, 0.32000E+03,
     | 0.40000E+03, 0.10450E+04, 0.65000E+03, 0.32000E+03, 0.68500E+03,
     | 0.62500E+03, 0.62500E+03, 0.26500E+03, 0.51500E+03, 0.10550E+04,
     | 0.15150E+04, 0.15250E+04, 0.16500E+04, 0.30250E+04, 0.15450E+04,
     | 0.68500E+03, 0.54000E+03, 0.25000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,26) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.35500E+03,
     | 0.10150E+04, 0.16200E+04, 0.51500E+03, 0.75000E+02, 0.65000E+02,
     | 0.12000E+03, 0.50000E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.37500E+03, 0.66500E+03, 0.68500E+03, 0.68500E+03, 0.51000E+03,
     | 0.50500E+03, 0.36000E+03, 0.12000E+03, 0.11500E+03, 0.14000E+03,
     | 0.18000E+03, 0.74000E+03, 0.49500E+03, 0.12500E+04, 0.13000E+04,
     | 0.13150E+04, 0.16750E+04, 0.14550E+04, 0.15500E+04, 0.28500E+04,
     | 0.37600E+04, 0.40350E+04, 0.39600E+04, 0.39200E+04, 0.18950E+04,
     | 0.91000E+03, 0.61000E+03, 0.31500E+03, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,27) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.11000E+04, 0.13500E+04,
     | 0.18500E+04, 0.19200E+04, 0.64500E+03, 0.25500E+03, 0.15500E+03,
     | 0.35500E+03, 0.50500E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.60500E+03, 0.48000E+03, 0.48000E+03, 0.16000E+03,
     | 0.12500E+03, 0.50000E+01, 0.00000E+00, 0.00000E+00, 0.53000E+03,
     | 0.66500E+03, 0.11000E+04, 0.13950E+04, 0.19250E+04, 0.16250E+04,
     | 0.12900E+04, 0.16500E+04, 0.27250E+04, 0.35250E+04, 0.36300E+04,
     | 0.40200E+04, 0.45350E+04, 0.46350E+04, 0.38200E+04, 0.20750E+04,
     | 0.11650E+04, 0.38000E+03, 0.70000E+02, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.50000E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,28) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.20750E+04, 0.21250E+04,
     | 0.22550E+04, 0.21000E+04, 0.82000E+03, 0.37500E+03, 0.22000E+03,
     | 0.36500E+03, 0.62000E+03, 0.29000E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.75500E+03, 0.35500E+03, 0.35500E+03, 0.10500E+03,
     | 0.50000E+01, 0.00000E+00, 0.50000E+03, 0.27000E+03, 0.53000E+03,
     | 0.63500E+03, 0.81000E+03, 0.20100E+04, 0.90500E+03, 0.88500E+03,
     | 0.64500E+03, 0.69500E+03, 0.19500E+04, 0.34250E+04, 0.29050E+04,
     | 0.23800E+04, 0.26000E+04, 0.29850E+04, 0.25000E+04, 0.16950E+04,
     | 0.14300E+04, 0.87000E+03, 0.17000E+03, 0.25000E+03, 0.37500E+03,
     | 0.50000E+01, 0.50000E+03, 0.90000E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,28) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.14750E+04, 0.21500E+04,
     | 0.19600E+04, 0.14750E+04, 0.77000E+03, 0.38500E+03, 0.25000E+03,
     | 0.25000E+03, 0.25000E+03, 0.50500E+03, 0.90000E+02, 0.25000E+02,
     | 0.50000E+01, 0.50000E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.52000E+03, 0.40500E+03, 0.40500E+03, 0.35500E+03,
     | 0.63000E+03, 0.46500E+03, 0.74000E+03, 0.81000E+03, 0.20000E+02,
     | 0.55000E+02, 0.10000E+03, 0.87500E+03, 0.10000E+02, 0.15500E+03,
     | 0.14500E+03, 0.19000E+03, 0.67000E+03, 0.16850E+04, 0.22650E+04,
     | 0.18100E+04, 0.17750E+04, 0.21100E+04, 0.22300E+04, 0.15450E+04,
     | 0.14300E+04, 0.11200E+04, 0.71500E+03, 0.54000E+03, 0.54000E+03,
     | 0.30500E+03, 0.00000E+00, 0.90000E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      OROG(:,29) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.11250E+04, 0.14950E+04, 0.17150E+04,
     | 0.11000E+04, 0.79500E+03, 0.52500E+03, 0.37000E+03, 0.25500E+03,
     | 0.18500E+03, 0.13500E+03, 0.41500E+03, 0.59000E+03, 0.37500E+03,
     | 0.27000E+03, 0.50000E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.70000E+02, 0.10500E+03, 0.10500E+03, 0.25500E+03,
     | 0.69000E+03, 0.53500E+03, 0.35500E+03, 0.73000E+03, 0.14000E+03,
     | 0.18500E+03, 0.22000E+03, 0.14500E+03, 0.12000E+03, 0.32000E+03,
     | 0.30000E+03, 0.21500E+03, 0.38000E+03, 0.61500E+03, 0.10200E+04,
     | 0.12750E+04, 0.17250E+04, 0.23050E+04, 0.24600E+04, 0.13500E+04,
     | 0.14050E+04, 0.11500E+04, 0.92500E+03, 0.55500E+03, 0.53500E+03,
     | 0.80500E+03, 0.13000E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.10500E+03, 0.00000E+00, 0.00000E+00/)
      OROG(:,30) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.60000E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.12500E+03, 0.82500E+03, 0.18750E+04, 0.13850E+04, 0.95500E+03,
     | 0.60000E+03, 0.48500E+03, 0.35500E+03, 0.29500E+03, 0.15500E+03,
     | 0.70000E+02, 0.10000E+02, 0.35500E+03, 0.72000E+03, 0.61500E+03,
     | 0.26500E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.50000E+01, 0.19500E+03, 0.50000E+02, 0.50000E+02, 0.50000E+01,
     | 0.16500E+03, 0.14500E+03, 0.11500E+03, 0.22000E+03, 0.21000E+03,
     | 0.26000E+03, 0.20500E+03, 0.21500E+03, 0.20500E+03, 0.35500E+03,
     | 0.41500E+03, 0.18000E+03, 0.18000E+03, 0.17000E+03, 0.21500E+03,
     | 0.43000E+03, 0.77500E+03, 0.13000E+04, 0.11800E+04, 0.76500E+03,
     | 0.10600E+04, 0.12750E+04, 0.92000E+03, 0.72000E+03, 0.82000E+03,
     | 0.88000E+03, 0.13500E+03, 0.00000E+00, 0.00000E+00, 0.50000E+01,
     | 0.63000E+03, 0.00000E+00, 0.00000E+00/)
      OROG(:,31) = (/
     | 0.13100E+03, 0.50000E+01, 0.50000E+01, 0.50000E+01, 0.22000E+02,
     | 0.16600E+03, 0.42800E+03, 0.75000E+03, 0.98600E+03, 0.10100E+04,
     | 0.10300E+04, 0.16650E+04, 0.12200E+04, 0.59500E+03, 0.40700E+03,
     | 0.35100E+03, 0.34700E+03, 0.26300E+03, 0.17400E+03, 0.25000E+02,
     | 0.10000E+02, 0.10000E+02, 0.16500E+03, 0.25000E+03, 0.28200E+03,
     | 0.00000E+00, 0.00000E+00, 0.52600E+03, 0.86900E+03, 0.32600E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.13000E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.61000E+03, 0.30400E+03, 0.16000E+02, 0.88000E+02, 0.18000E+03,
     | 0.22500E+03, 0.14300E+03, 0.15200E+03, 0.17300E+03, 0.25800E+03,
     | 0.46400E+03, 0.16200E+03, 0.10800E+03, 0.10000E+03, 0.12300E+03,
     | 0.15000E+03, 0.29500E+03, 0.45800E+03, 0.48000E+03, 0.65000E+03,
     | 0.68900E+03, 0.75800E+03, 0.66900E+03, 0.57000E+03, 0.57600E+03,
     | 0.63000E+03, 0.73300E+03, 0.80700E+03, 0.75900E+03, 0.48600E+03,
     | 0.80100E+03, 0.35500E+03, 0.32100E+03/)
      OROG(:,32) = (/
     | 0.60600E+03, 0.27000E+03, 0.90000E+02, 0.10000E+02, 0.31000E+02,
     | 0.51600E+03, 0.80500E+03, 0.12000E+04, 0.14930E+04, 0.15550E+04,
     | 0.11900E+04, 0.10400E+04, 0.61000E+03, 0.29500E+03, 0.22700E+03,
     | 0.24600E+03, 0.22200E+03, 0.12800E+03, 0.15200E+03, 0.13500E+03,
     | 0.98000E+02, 0.10000E+02, 0.12000E+03, 0.53500E+03, 0.35900E+03,
     | 0.50000E+01, 0.25000E+02, 0.10510E+04, 0.21120E+04, 0.15810E+04,
     | 0.92900E+03, 0.31900E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.51000E+03, 0.46200E+03, 0.27100E+03, 0.16500E+03, 0.18500E+03,
     | 0.22500E+03, 0.15200E+03, 0.82000E+02, 0.93000E+02, 0.17000E+03,
     | 0.36900E+03, 0.25100E+03, 0.15200E+03, 0.12000E+03, 0.13300E+03,
     | 0.15300E+03, 0.42500E+03, 0.89300E+03, 0.56900E+03, 0.58700E+03,
     | 0.53900E+03, 0.33200E+03, 0.26400E+03, 0.33000E+03, 0.85100E+03,
     | 0.10220E+04, 0.15670E+04, 0.13090E+04, 0.94900E+03, 0.66400E+03,
     | 0.64100E+03, 0.80700E+03, 0.68100E+03/)
      OROG(:,33) = (/
     | 0.48000E+03, 0.27000E+03, 0.90000E+02, 0.10000E+02, 0.14000E+02,
     | 0.36000E+03, 0.44200E+03, 0.45500E+03, 0.51200E+03, 0.55000E+03,
     | 0.29000E+03, 0.20500E+03, 0.15700E+03, 0.15500E+03, 0.14900E+03,
     | 0.11100E+03, 0.70000E+02, 0.51000E+02, 0.14100E+03, 0.13500E+03,
     | 0.23800E+03, 0.23800E+03, 0.30700E+03, 0.52300E+03, 0.34700E+03,
     | 0.10000E+02, 0.36100E+03, 0.14360E+04, 0.25400E+04, 0.27740E+04,
     | 0.24590E+04, 0.13740E+04, 0.42000E+03, 0.51000E+02, 0.50000E+01,
     | 0.20000E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.23200E+03, 0.25400E+03, 0.10700E+03, 0.95000E+02,
     | 0.13000E+03, 0.94000E+02, 0.17000E+02, 0.25000E+02, 0.12000E+03,
     | 0.12500E+03, 0.15500E+03, 0.98000E+02, 0.65000E+02, 0.75000E+02,
     | 0.14700E+03, 0.40900E+03, 0.77500E+03, 0.43400E+03, 0.39500E+03,
     | 0.38900E+03, 0.25400E+03, 0.22900E+03, 0.30900E+03, 0.78600E+03,
     | 0.77200E+03, 0.87400E+03, 0.55200E+03, 0.19400E+03, 0.18800E+03,
     | 0.37000E+03, 0.45700E+03, 0.36500E+03/)
      OROG(:,34) = (/
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.24000E+02, 0.85000E+02, 0.72000E+02,
     | 0.16000E+02, 0.15000E+02, 0.43000E+02, 0.74000E+02, 0.13500E+03,
     | 0.43300E+03, 0.40600E+03, 0.25700E+03, 0.13100E+03, 0.35400E+03,
     | 0.60000E+03, 0.11560E+04, 0.19390E+04, 0.24620E+04, 0.27440E+04,
     | 0.27270E+04, 0.20640E+04, 0.96300E+03, 0.21400E+03, 0.17000E+02,
     | 0.70000E+01, 0.50000E+01, 0.50000E+01, 0.50000E+01, 0.10000E+01,
     | 0.00000E+00, 0.13000E+02, 0.31000E+02, 0.38000E+02, 0.50000E+01,
     | 0.50000E+01, 0.50000E+01, 0.80000E+01, 0.20000E+02, 0.83000E+02,
     | 0.10000E+02, 0.39000E+02, 0.24000E+02, 0.10000E+02, 0.10000E+02,
     | 0.60000E+02, 0.15900E+03, 0.15000E+03, 0.19400E+03, 0.17500E+03,
     | 0.99000E+02, 0.59000E+02, 0.95000E+02, 0.99000E+02, 0.66000E+02,
     | 0.10000E+02, 0.40000E+02, 0.55000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02/)
      OROG(:,35) = (/
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.12000E+02, 0.25000E+02, 0.13000E+02,
     | 0.10000E+02, 0.15000E+02, 0.16000E+02, 0.30000E+02, 0.13500E+03,
     | 0.47000E+03, 0.53300E+03, 0.36500E+03, 0.36300E+03, 0.57600E+03,
     | 0.80000E+03, 0.10490E+04, 0.12830E+04, 0.14200E+04, 0.14790E+04,
     | 0.14250E+04, 0.12100E+04, 0.64500E+03, 0.16800E+03, 0.17000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.60000E+01,
     | 0.50000E+01, 0.17000E+02, 0.36000E+02, 0.43000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.39000E+02, 0.21000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.79000E+02, 0.62000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02/)
      OROG(:,36) = (/
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.18800E+03, 0.36500E+03, 0.31000E+03, 0.25500E+03, 0.23200E+03,
     | 0.21000E+03, 0.23500E+03, 0.26000E+03, 0.26000E+03, 0.26000E+03,
     | 0.23200E+03, 0.20500E+03, 0.10700E+03, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02, 0.10000E+02,
     | 0.10000E+02, 0.10000E+02, 0.10000E+02/)
c
c
c 8/2/00 (rr): These data statements for orography surface roughness
c made from the ccm3 surface roughness data but adapted to our grid
c to be used in mgw.f
c
      SGHDAT(:,1) = (/
     | 0.20045E+03, 0.23063E+03, 0.28813E+03, 0.23356E+03, 0.22100E+03,
     | 0.21929E+03, 0.30604E+03, 0.21608E+03, 0.16737E+03, 0.18240E+03,
     | 0.19818E+03, 0.17827E+03, 0.14547E+03, 0.12361E+03, 0.10756E+03,
     | 0.10401E+03, 0.11426E+03, 0.13284E+03, 0.21953E+03, 0.30481E+03,
     | 0.34576E+03, 0.32652E+03, 0.28885E+03, 0.25693E+03, 0.23730E+03,
     | 0.24227E+03, 0.24125E+03, 0.20260E+03, 0.15206E+03, 0.12296E+03,
     | 0.10411E+03, 0.90178E+02, 0.75633E+02, 0.49375E+02, 0.34612E+02,
     | 0.33011E+02, 0.29754E+02, 0.33038E+02, 0.39933E+02, 0.40274E+02,
     | 0.43434E+02, 0.52131E+02, 0.67165E+02, 0.72351E+02, 0.68682E+02,
     | 0.59489E+02, 0.53593E+02, 0.57231E+02, 0.60265E+02, 0.66975E+02,
     | 0.73104E+02, 0.73721E+02, 0.74578E+02, 0.72266E+02, 0.65867E+02,
     | 0.55459E+02, 0.50504E+02, 0.49421E+02, 0.48451E+02, 0.44000E+02,
     | 0.43485E+02, 0.46988E+02, 0.52407E+02, 0.58732E+02, 0.65277E+02,
     | 0.71090E+02, 0.84652E+02, 0.11153E+03, 0.13188E+03, 0.16089E+03,
     | 0.17014E+03, 0.16831E+03, 0.20045E+03/)
      SGHDAT(:,2) = (/
     | 0.44086E+02, 0.52634E+02, 0.57558E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.29713E+03, 0.30602E+03, 0.31220E+03, 0.29290E+03,
     | 0.24999E+03, 0.24612E+03, 0.20126E+03, 0.12885E+03, 0.11857E+03,
     | 0.12067E+03, 0.11170E+03, 0.99857E+02, 0.15850E+03, 0.22447E+03,
     | 0.16861E+03, 0.16114E+03, 0.20889E+03, 0.23214E+03, 0.23034E+03,
     | 0.27042E+03, 0.27601E+03, 0.25594E+03, 0.21491E+03, 0.21986E+03,
     | 0.22474E+03, 0.17199E+03, 0.97430E+02, 0.48320E+02, 0.19208E+02,
     | 0.25079E+02, 0.43920E+02, 0.62657E+02, 0.56522E+02, 0.56336E+02,
     | 0.62388E+02, 0.63632E+02, 0.79735E+02, 0.85797E+02, 0.93558E+02,
     | 0.10109E+03, 0.11559E+03, 0.12847E+03, 0.14340E+03, 0.15498E+03,
     | 0.14401E+03, 0.12126E+03, 0.10879E+03, 0.90992E+02, 0.79826E+02,
     | 0.53678E+02, 0.44547E+02, 0.40066E+02, 0.26164E+02, 0.17234E+02,
     | 0.22652E+02, 0.33201E+02, 0.48558E+02, 0.53697E+02, 0.70336E+02,
     | 0.89894E+02, 0.15353E+03, 0.31108E+03, 0.48573E+03, 0.19947E+03,
     | 0.30865E+02, 0.32702E+02, 0.44086E+02/)
      SGHDAT(:,3) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.63915E+02, 0.17398E+03, 0.21241E+03, 0.26816E+03,
     | 0.26767E+03, 0.25275E+03, 0.19112E+03, 0.15387E+03, 0.16495E+03,
     | 0.20185E+03, 0.23124E+03, 0.22060E+03, 0.22701E+03, 0.30384E+03,
     | 0.20693E+03, 0.11758E+03, 0.16144E+03, 0.20035E+02, 0.00000E+00,
     | 0.26214E+02, 0.60259E+02, 0.53966E+02, 0.00000E+00, 0.35046E+02,
     | 0.13381E+03, 0.24305E+03, 0.18174E+03, 0.17358E+03, 0.14378E+03,
     | 0.13205E+03, 0.14588E+03, 0.13999E+03, 0.14890E+03, 0.13645E+03,
     | 0.17533E+03, 0.11633E+03, 0.11360E+03, 0.10488E+03, 0.11045E+03,
     | 0.10256E+03, 0.10046E+03, 0.11821E+03, 0.16985E+03, 0.24179E+03,
     | 0.25482E+03, 0.16008E+03, 0.95992E+02, 0.75429E+02, 0.68611E+02,
     | 0.46754E+02, 0.49888E+02, 0.56776E+02, 0.40193E+02, 0.33151E+02,
     | 0.28595E+02, 0.38241E+02, 0.63522E+02, 0.50580E+02, 0.54126E+02,
     | 0.61462E+02, 0.98810E+02, 0.20356E+03, 0.39902E+03, 0.10608E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,4) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.12068E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.41875E+02, 0.10329E+03, 0.11925E+03, 0.11348E+03,
     | 0.80719E+02, 0.95245E+02, 0.36048E+03, 0.41117E+03, 0.10975E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.15012E+03, 0.21440E+03,
     | 0.33463E+03, 0.35918E+03, 0.45986E+03, 0.50130E+03, 0.45135E+03,
     | 0.42614E+03, 0.43862E+03, 0.41738E+03, 0.32141E+03, 0.31597E+03,
     | 0.18222E+03, 0.15613E+03, 0.15956E+03, 0.21165E+03, 0.28627E+03,
     | 0.31951E+03, 0.29850E+03, 0.22507E+03, 0.19032E+03, 0.19887E+03,
     | 0.19712E+03, 0.18519E+03, 0.16003E+03, 0.14983E+03, 0.15632E+03,
     | 0.16666E+03, 0.17827E+03, 0.18374E+03, 0.15009E+03, 0.15155E+03,
     | 0.14882E+03, 0.16435E+03, 0.21158E+03, 0.38726E+03, 0.50160E+03,
     | 0.24794E+03, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,5) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.25470E+03, 0.33211E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.45776E+02,
     | 0.18645E+03, 0.20840E+03, 0.22808E+03, 0.23137E+03, 0.18628E+03,
     | 0.19832E+02, 0.00000E+00, 0.97551E+02, 0.23743E+03, 0.27005E+03,
     | 0.28234E+03, 0.25473E+03, 0.23042E+03, 0.22605E+03, 0.20757E+03,
     | 0.24024E+03, 0.26177E+03, 0.24126E+03, 0.23688E+03, 0.24711E+03,
     | 0.20824E+03, 0.72704E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,6) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,7) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,8) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.52415E+02, 0.17939E+03, 0.57031E+01, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,9) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.97782E+02, 0.22772E+03, 0.19895E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.77317E+02, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,10) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.28124E+02, 0.27641E+03, 0.17242E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.12692E+03, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,11) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.12427E+03, 0.50215E+03, 0.20434E+03, 0.56759E+02,
     | 0.12813E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.15375E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.51324E+01,
     | 0.18031E+03, 0.14921E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,12) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.86809E+03, 0.40675E+03, 0.81166E+02,
     | 0.64916E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.18899E+03, 0.23033E+03, 0.94083E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.60999E+02, 0.51228E+02, 0.44731E+02, 0.74186E+02, 0.10180E+03,
     | 0.99486E+02, 0.20612E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,13) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.11387E+04, 0.76197E+03, 0.17905E+03,
     | 0.13219E+03, 0.18516E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.81145E+02,
     | 0.17245E+03, 0.16509E+03, 0.27598E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.63374E+02,
     | 0.52668E+02, 0.54247E+02, 0.78937E+02, 0.76090E+02, 0.57642E+02,
     | 0.62892E+02, 0.15238E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,14) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.59694E+03, 0.72280E+03, 0.20525E+03,
     | 0.11606E+03, 0.15956E+03, 0.21312E+03, 0.21925E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.15517E+03,
     | 0.12970E+03, 0.10866E+03, 0.20885E+03, 0.77711E+02, 0.00000E+00,
     | 0.25326E+03, 0.69275E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.44529E+02,
     | 0.78113E+02, 0.50774E+02, 0.70855E+02, 0.74448E+02, 0.65757E+02,
     | 0.10469E+03, 0.66871E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,15) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.77517E+02, 0.10672E+04, 0.70229E+03, 0.21176E+03,
     | 0.11663E+03, 0.13507E+03, 0.15336E+03, 0.14472E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.23049E+03,
     | 0.75921E+02, 0.10070E+03, 0.22672E+03, 0.21522E+03, 0.25791E+02,
     | 0.22135E+03, 0.86571E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.73399E+02, 0.78972E+02, 0.54165E+02, 0.70020E+02,
     | 0.14460E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,16) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.12382E+04, 0.95082E+03, 0.35163E+03, 0.88940E+02,
     | 0.94815E+02, 0.12710E+03, 0.14229E+03, 0.14684E+03, 0.13181E+01,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.32358E+03,
     | 0.10105E+03, 0.10377E+03, 0.19888E+03, 0.27748E+03, 0.12828E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.17277E+02, 0.66106E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,17) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.34620E+03, 0.64996E+03, 0.24011E+03, 0.45469E+02, 0.60181E+02,
     | 0.72586E+02, 0.71639E+02, 0.97106E+02, 0.14100E+03, 0.66550E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.22961E+03,
     | 0.11429E+03, 0.15746E+03, 0.25268E+03, 0.29097E+03, 0.31189E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.15969E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.28431E+03,
     | 0.49171E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,18) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.44733E+03, 0.42431E+03, 0.37918E+02, 0.11020E+03, 0.56909E+02,
     | 0.56199E+02, 0.50223E+02, 0.33813E+02, 0.46174E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.43408E+02, 0.10864E+03,
     | 0.67016E+02, 0.17673E+03, 0.28673E+03, 0.31683E+03, 0.26068E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.80115E+02, 0.12155E+03, 0.12292E+02, 0.11517E+03,
     | 0.13841E+03, 0.00000E+00, 0.36765E+02, 0.20036E+03, 0.24242E+03,
     | 0.10405E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,19) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.23715E+03, 0.63584E+03, 0.24473E+03, 0.27689E+03, 0.17500E+03,
     | 0.91580E+02, 0.23003E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.13511E+03, 0.11029E+03,
     | 0.52982E+02, 0.97867E+02, 0.23338E+03, 0.36425E+03, 0.33626E+03,
     | 0.10048E+03, 0.92544E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.13751E+03, 0.00000E+00, 0.12916E+02, 0.22296E+03,
     | 0.70126E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,20) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.62325E+03, 0.45642E+03, 0.29039E+03, 0.17171E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.12575E+02, 0.10334E+03,
     | 0.72118E+02, 0.95431E+02, 0.11635E+03, 0.22257E+03, 0.16900E+03,
     | 0.90361E+02, 0.94978E+02, 0.15569E+03, 0.37766E+03, 0.45599E+03,
     | 0.26760E+03, 0.82175E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.56154E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.88373E+01, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,21) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.21098E+03,
     | 0.00000E+00, 0.41727E+01, 0.93379E+01, 0.52453E+01, 0.12324E+01,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.52849E+02, 0.92209E+02,
     | 0.48752E+02, 0.51072E+02, 0.80524E+02, 0.11455E+03, 0.89079E+02,
     | 0.11024E+03, 0.14821E+03, 0.12157E+03, 0.33486E+03, 0.52163E+03,
     | 0.77172E+01, 0.48458E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.12734E+03, 0.88515E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.15282E+03, 0.17897E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,22) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.44407E+03, 0.40691E+03, 0.32782E+03, 0.58257E+02,
     | 0.00000E+00, 0.00000E+00, 0.11038E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.33390E+02, 0.55063E+02,
     | 0.44631E+02, 0.58601E+02, 0.10531E+03, 0.13858E+03, 0.12906E+03,
     | 0.14334E+03, 0.12013E+03, 0.83457E+02, 0.18728E+03, 0.16681E+03,
     | 0.42382E+03, 0.24095E+03, 0.10483E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.11786E+03, 0.11973E+03, 0.00000E+00, 0.00000E+00,
     | 0.15386E+03, 0.29384E+03, 0.20225E+03, 0.00000E+00, 0.00000E+00,
     | 0.30215E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,23) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.36464E+03, 0.47831E+03, 0.00000E+00, 0.00000E+00, 0.60895E+01,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.46509E+02, 0.68351E+02,
     | 0.51876E+02, 0.80440E+02, 0.17591E+03, 0.15707E+03, 0.18149E+03,
     | 0.18380E+03, 0.10699E+03, 0.10237E+03, 0.15982E+03, 0.17479E+03,
     | 0.17110E+03, 0.12589E+03, 0.19515E+03, 0.12807E+03, 0.00000E+00,
     | 0.61632E+02, 0.11636E+03, 0.16889E+03, 0.33705E+03, 0.40639E+03,
     | 0.51046E+03, 0.44853E+03, 0.32294E+03, 0.15436E+03, 0.96439E+02,
     | 0.13201E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,24) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.10611E+02, 0.31652E+03,
     | 0.37464E+03, 0.24384E+03, 0.16381E+02, 0.60339E+01, 0.00000E+00,
     | 0.12390E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.13672E+03,
     | 0.16924E+03, 0.95358E+02, 0.15747E+03, 0.13669E+03, 0.12886E+03,
     | 0.93672E+02, 0.71951E+02, 0.15175E+03, 0.30194E+03, 0.19509E+03,
     | 0.13707E+03, 0.16898E+03, 0.31371E+03, 0.43543E+03, 0.40684E+03,
     | 0.35333E+03, 0.30035E+03, 0.75448E+03, 0.10808E+04, 0.11074E+04,
     | 0.98893E+03, 0.73256E+03, 0.45568E+03, 0.23471E+03, 0.19221E+03,
     | 0.11644E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,25) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.20095E+02, 0.32422E+03, 0.32787E+03,
     | 0.25861E+03, 0.15029E+03, 0.58538E+02, 0.42581E+02, 0.12701E+03,
     | 0.81711E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.14601E+03,
     | 0.40902E+03, 0.25148E+03, 0.23765E+03, 0.17399E+03, 0.78283E+02,
     | 0.93931E+01, 0.93931E+01, 0.00000E+00, 0.14034E+03, 0.21248E+03,
     | 0.35116E+03, 0.51700E+03, 0.43138E+03, 0.43216E+03, 0.50572E+03,
     | 0.72761E+03, 0.81668E+03, 0.82646E+03, 0.70624E+03, 0.49115E+03,
     | 0.66817E+03, 0.59689E+03, 0.54385E+03, 0.31253E+03, 0.21987E+03,
     | 0.11892E+03, 0.00000E+00, 0.70680E+01, 0.43368E+02, 0.12630E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,26) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.44373E+03, 0.40178E+03, 0.36740E+03,
     | 0.30240E+03, 0.13451E+03, 0.63023E+02, 0.53837E+02, 0.13821E+03,
     | 0.16456E+03, 0.57525E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.28255E+03, 0.20518E+02, 0.22056E+02, 0.94640E+01, 0.00000E+00,
     | 0.32593E+02, 0.32593E+02, 0.32906E+03, 0.40773E+03, 0.48193E+03,
     | 0.56617E+03, 0.16721E+03, 0.23931E+03, 0.34475E+03, 0.48591E+03,
     | 0.90853E+03, 0.90679E+03, 0.90400E+03, 0.86879E+03, 0.78287E+03,
     | 0.68295E+03, 0.63545E+03, 0.37055E+03, 0.24541E+03, 0.30568E+03,
     | 0.80645E+02, 0.88416E+02, 0.29980E+01, 0.18395E+02, 0.19201E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,27) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.17960E+03, 0.33882E+03, 0.34306E+03, 0.36418E+03,
     | 0.25034E+03, 0.11478E+03, 0.53611E+02, 0.51282E+02, 0.60091E+02,
     | 0.11408E+03, 0.14328E+03, 0.72002E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.31700E+02,
     | 0.30708E+03, 0.43320E+03, 0.26947E+03, 0.15981E+03, 0.33627E+03,
     | 0.42650E+03, 0.34405E+03, 0.14642E+03, 0.11796E+03, 0.31994E+03,
     | 0.78079E+03, 0.14649E+03, 0.14536E+03, 0.97405E+02, 0.21701E+03,
     | 0.70969E+03, 0.87172E+03, 0.89621E+03, 0.71843E+03, 0.66242E+03,
     | 0.52593E+03, 0.34021E+03, 0.18747E+03, 0.15002E+03, 0.23593E+03,
     | 0.23785E+03, 0.20940E+03, 0.21430E+03, 0.15279E+03, 0.42967E+02,
     | 0.68075E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,28) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.18166E+03, 0.38147E+03, 0.34673E+03, 0.28608E+03,
     | 0.17340E+03, 0.89314E+02, 0.56637E+02, 0.77877E+02, 0.71886E+02,
     | 0.75239E+02, 0.11449E+03, 0.14950E+03, 0.11846E+03, 0.00000E+00,
     | 0.27856E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.10106E+02, 0.19268E+03, 0.34018E+03, 0.40922E+03, 0.31553E+03,
     | 0.29072E+03, 0.26921E+03, 0.10148E+03, 0.90226E+02, 0.23841E+03,
     | 0.27740E+03, 0.56148E+02, 0.42066E+02, 0.52936E+02, 0.82393E+02,
     | 0.22910E+03, 0.33958E+03, 0.50504E+03, 0.57375E+03, 0.54863E+03,
     | 0.47902E+03, 0.35226E+03, 0.22243E+03, 0.18328E+03, 0.14763E+03,
     | 0.15623E+03, 0.12644E+03, 0.19908E+03, 0.29431E+03, 0.18540E+03,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,29) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.78810E+02, 0.35107E+03, 0.34749E+03, 0.26679E+03, 0.10491E+03,
     | 0.78971E+02, 0.64517E+02, 0.42730E+02, 0.57084E+02, 0.45638E+02,
     | 0.33989E+02, 0.73074E+02, 0.10408E+03, 0.13254E+03, 0.12418E+03,
     | 0.38215E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.20068E+02, 0.43812E+02, 0.63846E+02, 0.11630E+03, 0.10746E+03,
     | 0.12157E+03, 0.94735E+02, 0.34519E+02, 0.27582E+02, 0.34650E+02,
     | 0.37140E+02, 0.41249E+02, 0.63075E+02, 0.74413E+02, 0.45193E+02,
     | 0.54580E+02, 0.88789E+02, 0.13003E+03, 0.27827E+03, 0.36226E+03,
     | 0.37554E+03, 0.32470E+03, 0.25810E+03, 0.29968E+03, 0.21023E+03,
     | 0.17016E+03, 0.16982E+03, 0.27145E+03, 0.63917E+03, 0.41912E+03,
     | 0.00000E+00, 0.00000E+00, 0.27678E+02, 0.12191E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,30) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.36982E+01, 0.32939E+02,
     | 0.45857E+02, 0.42847E+02, 0.21564E+02, 0.46602E+02, 0.32136E+03,
     | 0.36168E+03, 0.30225E+03, 0.20835E+03, 0.13378E+03, 0.84388E+02,
     | 0.53592E+02, 0.37323E+02, 0.40392E+02, 0.27985E-12, 0.00000E+00,
     | 0.00000E+00, 0.76428E+02, 0.92961E+02, 0.10945E+03, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.25698E+02, 0.82169E-12, 0.50861E+02, 0.36310E+02, 0.78450E+02,
     | 0.00000E+00, 0.30518E+02, 0.37993E+02, 0.33546E+02, 0.27745E+02,
     | 0.26334E+02, 0.32917E+02, 0.51224E+02, 0.83120E+02, 0.28878E+02,
     | 0.21437E+02, 0.21172E+02, 0.23002E+02, 0.66175E+02, 0.12930E+03,
     | 0.19463E+03, 0.14513E+03, 0.14468E+03, 0.27162E+03, 0.25787E+03,
     | 0.22361E+03, 0.18921E+03, 0.24730E+03, 0.42000E+03, 0.17460E+03,
     | 0.54483E+02, 0.24764E+02, 0.20076E+02, 0.28585E+03, 0.20431E+02,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,31) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.34320E+02, 0.15065E+03,
     | 0.34090E+03, 0.48802E+03, 0.43136E+03, 0.39067E+03, 0.29077E+03,
     | 0.31243E+03, 0.30310E+03, 0.15706E+03, 0.97889E+02, 0.76742E+02,
     | 0.48765E+02, 0.45336E+02, 0.45549E+02, 0.31882E-12, 0.00000E+00,
     | 0.00000E+00, 0.95543E+01, 0.30874E+02, 0.19978E+02, 0.00000E+00,
     | 0.00000E+00, 0.70831E+02, 0.37807E+03, 0.91907E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.49821E+02, 0.33591E+03, 0.17017E+03,
     | 0.43374E+01, 0.35286E+02, 0.49073E+02, 0.45128E+02, 0.39514E+02,
     | 0.29646E+02, 0.32925E+02, 0.66974E+02, 0.13800E+03, 0.50645E+02,
     | 0.12931E+02, 0.10545E+02, 0.19031E+02, 0.34728E+02, 0.93794E+02,
     | 0.10931E+03, 0.93279E+02, 0.92480E+02, 0.10029E+03, 0.10689E+03,
     | 0.10133E+03, 0.11642E+03, 0.18738E+03, 0.22605E+03, 0.39408E+03,
     | 0.39191E+03, 0.23644E+03, 0.21454E+03, 0.25049E+03, 0.23009E+03,
     | 0.21119E+03, 0.15359E+03, 0.90930E-12/)
      SGHDAT(:,32) = (/
     | 0.17494E+03, 0.33495E+02, 0.14135E+02, 0.48391E+02, 0.18257E+03,
     | 0.26640E+03, 0.33992E+03, 0.32490E+03, 0.27772E+03, 0.26274E+03,
     | 0.29234E+03, 0.17817E+03, 0.12112E+03, 0.97807E+02, 0.91759E+02,
     | 0.59076E+02, 0.54726E+02, 0.74599E+02, 0.91404E+02, 0.11266E+03,
     | 0.34864E+02, 0.58035E+02, 0.22809E+03, 0.96393E+02, 0.00000E+00,
     | 0.80485E+02, 0.30976E+03, 0.25128E+03, 0.39859E+03, 0.34217E+03,
     | 0.35278E+03, 0.00000E+00, 0.65025E+02, 0.27124E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.10736E+03,
     | 0.16020E+03, 0.10074E+03, 0.87413E+02, 0.78224E+02, 0.14478E+02,
     | 0.98812E+01, 0.12859E+02, 0.64150E+02, 0.13376E+03, 0.12556E+03,
     | 0.36971E+02, 0.17832E+02, 0.21510E+02, 0.54846E+02, 0.15225E+03,
     | 0.17489E+03, 0.13590E+03, 0.11044E+03, 0.11064E+03, 0.70922E+02,
     | 0.57101E+02, 0.15590E+03, 0.24955E+03, 0.21558E+03, 0.27236E+03,
     | 0.29715E+03, 0.19816E+03, 0.13547E+03, 0.17403E+03, 0.20068E+03,
     | 0.18002E+03, 0.18262E+03, 0.17494E+03/)
      SGHDAT(:,34) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.23003E+02, 0.89382E+02, 0.49936E+02, 0.42403E+02,
     | 0.24951E+02, 0.32502E+02, 0.65647E+02, 0.79511E-12, 0.19843E+03,
     | 0.23696E+03, 0.11410E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.21641E+03, 0.28374E+03, 0.12767E+03, 0.16008E+03, 0.23200E+03,
     | 0.34553E+03, 0.36678E+03, 0.97717E+02, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.39716E+02, 0.48666E+02, 0.00000E+00,
     | 0.91522E+01, 0.10225E+02, 0.13160E+02, 0.33246E+02, 0.13462E+03,
     | 0.17027E+03, 0.12672E+03, 0.11461E+03, 0.14060E+03, 0.39312E+02,
     | 0.28005E+02, 0.59411E+02, 0.90769E+02, 0.70610E+02, 0.85547E+02,
     | 0.80172E+02, 0.44767E+02, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,35) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.46444E+02, 0.27522E+02,
     | 0.00000E+00, 0.24425E+02, 0.17474E+03, 0.25154E+03, 0.24461E+03,
     | 0.29829E+03, 0.10420E+03, 0.12464E+03, 0.43585E+03, 0.43417E+03,
     | 0.26858E+03, 0.17127E+03, 0.13666E+03, 0.14051E+03, 0.17756E+03,
     | 0.25228E+03, 0.29781E+03, 0.18480E+03, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.10594E+03,
     | 0.44809E+02, 0.46391E+01, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.26078E+02, 0.35948E+02, 0.85168E+02, 0.87859E+02, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,35) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.26351E+03,
     | 0.42529E+03, 0.44500E+03, 0.38246E+03, 0.32622E+03, 0.00000E+00,
     | 0.00000E+00, 0.28921E+03, 0.31887E+03, 0.28176E+03, 0.30059E+03,
     | 0.25729E+03, 0.17006E+03, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
      SGHDAT(:,36) = (/
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00,
     | 0.00000E+00, 0.00000E+00, 0.00000E+00/)
#else
!
! Orography available only on 5 deg grid:
!
      orog = 0.
      sghdat = 0.
#endif

#else
!
! Orography available only on 5 deg grid:
!
      orog = 0.
      sghdat = 0.
#endif

      end subroutine orogdat
