      module sgwht_module
      use params_module,only: pcols=>nlonp4, pver=>nlev, nlon,nlat
      use init_module,only: glon, glat
      use cons_module,only: dtr,grav
      use cons_module,only: pi
      use init_module,only: iday,uthr
      implicit none

      real, parameter ::
     |      gwshtmax = 0. ,         ! J/s/kg
     |      lonpeak = -110.8,          ! -110 degrees
     |      latpeak = 81.3,         ! 81 degrees
     |      zpeak   = 1.2e7,       ! in cm, 177 km
     |      parw  = 4.444e5,   ! in m, 4.5*zonalw=1000km
     |      perw  = 4.444e5,   ! in m, 4.5*meridw=1000km
     |      zw      = 1.333e6,   ! in cm, 4.5*zw=60km
     |      pdir = 0,    ! propagation direction (from east, in degree)
     |      timebeguth = 0.0,       ! UT time the forcing begins (hour)
     |      timeenduth = 0.25         ! UT time the forcing ends
!     |      zw      = 6.667e5,   ! in cm, 4.5*zw=30km, case C
      integer, parameter ::
     |      doy = 274                    ! Day of year of occurence

      contains

      subroutine secondary_gwht(z,lev0,lev1,lon0,lon1,lat,gwsht)

      integer,intent(in) :: lev0,lev1,lon0,lon1,lat
      real,dimension(lev0:lev1,lon0-2:lon1+2),intent(in) :: z
      real,dimension(lev0:lev1,lon0:lon1),intent(out):: gwsht

      integer :: k,i,i0,i1,nk,nkm1,nlevs,nlons
      real :: tfac,zfac,fdir,zfacexp
      real :: wrkx,wrky,wrk1,wrk2,facpar,facper
      real, dimension(lon0:lon1):: gwsht0

      i0 = lon0
      i1 = lon1

      tfac = 0.
      zfac = 0.
      gwsht(:,:) = 0.

      if (iday .eq. doy) then
         if ((uthr.gt.timebeguth).and.(uthr.lt.timeenduth)) then
            fdir = pdir*dtr     ! forcing direction, in radian
            
            wrky = (glat(lat)-latpeak)/180.*pi*6.37e6
            do i=i0,i1
               wrkx = (glon(i)-lonpeak)/360.*2.*pi*6.37e6
     |              * cos(glat(lat)*dtr)
               wrk1 = wrkx*cos(fdir)+wrky*sin(fdir)
               wrk2 = -wrkx*sin(fdir)+wrky*cos(fdir)
               facpar = exp(-(wrk1/parw)**2./2.)
               facper = exp(-(wrk2/perw)**2./2.)
               gwsht0(i) = gwshtmax * facpar * facper
     |              * cos(fdir)
            enddo

!            tfac = sin(pi*(uthr-timebeguth)/(timeenduth-timebeguth))**2.
            tfac = 1.
            do i=i0,i1
               do k=lev0,lev1
                  zfacexp = -((z(k,i)-zpeak)/zw)**2./2.
                  if (zfacexp .gt. -10) then
                     zfac = exp(zfacexp)
                  else
                     zfac = 0
                  endif
                  gwsht(k,i) = gwsht0(i) * tfac * zfac !heating rate (J/s/kg)
               enddo
            enddo
         endif
      endif

      return
      end subroutine secondary_gwht
      end module sgwht_module
