#include <defs.h>
      module he_coef0_dres
!
! This software is part of the NCAR TIE-GCM.  Use is governed by the 
! Open Source Academic Research License Agreement contained in the file 
! tiegcmlicense.txt.
!
! Associated Legendre functions, normalized by: 
! (-1)^M * sqrt((N+1/2)*(N-M)!/(N+M)!) for Helium at 2.5-deg resolution, 
! obtained from Eric Sutton (eric.sutton.5@us.af.mil) on MMM DD, YYYY.
!
      integer :: lat
!
#if (NLAT==72 && NLON==144)
! Data statements are used only if 2.5-deg resolution.
!
      real,dimension(72,0:70,0:71) :: pmn
!
!     Pmn Basis Set pmn(lat,m,n)
      data (pmn(lat, 0, 0), lat = 1,72)/
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01/
      data (pmn(lat, 0, 1), lat = 1,72)/
     |   1.2244534152782d+00, 1.2221225986088d+00, 1.2174654021121d+00,
     |   1.2104906910262d+00, 1.2012117421102d+00, 1.1896462183707d+00,
     |   1.1758161354394d+00, 1.1597478196653d+00, 1.1414718580007d+00,
     |   1.1210230397774d+00, 1.0984402904831d+00, 1.0737665976646d+00,
     |   1.0470489290985d+00, 1.0183381433855d+00, 9.8768889313802d-01,
     |   9.5515952094589d-01, 9.2081194831792d-01, 8.8471155781079d-01,
     |   8.4692706856966d-01, 8.0753040551732d-01, 7.6659656244104d-01,
     |   7.2420345923766d-01, 6.8043179358859d-01, 6.3536488734720d-01,
     |   5.8908852793097d-01, 5.4169080502022d-01, 4.9326194287443d-01,
     |   4.4389412858519d-01, 3.9368133659290d-01, 3.4271914980102d-01,
     |   2.9110457762861d-01, 2.3893587134739d-01, 1.8631233705482d-01,
     |   1.3333414663937d-01, 8.0102147097579d-02, 2.6717668566076d-02,
     |  -2.6717668566076d-02,-8.0102147097579d-02,-1.3333414663937d-01,
     |  -1.8631233705482d-01,-2.3893587134739d-01,-2.9110457762861d-01,
     |  -3.4271914980102d-01,-3.9368133659290d-01,-4.4389412858519d-01,
     |  -4.9326194287443d-01,-5.4169080502022d-01,-5.8908852793097d-01,
     |  -6.3536488734720d-01,-6.8043179358859d-01,-7.2420345923766d-01,
     |  -7.6659656244104d-01,-8.0753040551732d-01,-8.4692706856966d-01,
     |  -8.8471155781079d-01,-9.2081194831792d-01,-9.5515952094589d-01,
     |  -9.8768889313802d-01,-1.0183381433855d+00,-1.0470489290985d+00,
     |  -1.0737665976646d+00,-1.0984402904831d+00,-1.1210230397774d+00,
     |  -1.1414718580007d+00,-1.1597478196653d+00,-1.1758161354394d+00,
     |  -1.1896462183707d+00,-1.2012117421102d+00,-1.2104906910262d+00,
     |  -1.2174654021121d+00,-1.2221225986088d+00,-1.2244534152782d+00/
      data (pmn(lat, 1, 1), lat = 1,72)/
     |   1.8892244620565d-02, 5.6640771400301d-02, 9.4281479252422d-02,
     |   1.3174271695018d-01, 1.6895317489845d-01, 2.0584202087564d-01,
     |   2.4233903486679d-01, 2.7837474273142d-01, 3.1388054845148d-01,
     |   3.4878886470776d-01, 3.8303324153620d-01, 4.1654849281919d-01,
     |   4.4927082037103d-01, 4.8113793538142d-01, 5.1208917698571d-01,
     |   5.4206562773636d-01, 5.7101022575562d-01, 5.9886787335605d-01,
     |   6.2558554192213d-01, 6.5111237285320d-01, 6.7539977437573d-01,
     |   6.9840151404053d-01, 7.2007380672880d-01, 7.4037539799965d-01,
     |   7.5926764262022d-01, 7.7671457812910d-01, 7.9268299329295d-01,
     |   8.0714249132591d-01, 8.2006554775165d-01, 8.3142756279777d-01,
     |   8.4120690822284d-01, 8.4938496848704d-01, 8.5594617618784d-01,
     |   8.6087804169346d-01, 8.6417117691762d-01, 8.6581931319023d-01,
     |   8.6581931319023d-01, 8.6417117691762d-01, 8.6087804169346d-01,
     |   8.5594617618784d-01, 8.4938496848704d-01, 8.4120690822284d-01,
     |   8.3142756279777d-01, 8.2006554775165d-01, 8.0714249132591d-01,
     |   7.9268299329295d-01, 7.7671457812910d-01, 7.5926764262022d-01,
     |   7.4037539799965d-01, 7.2007380672880d-01, 6.9840151404053d-01,
     |   6.7539977437573d-01, 6.5111237285320d-01, 6.2558554192213d-01,
     |   5.9886787335605d-01, 5.7101022575562d-01, 5.4206562773636d-01,
     |   5.1208917698571d-01, 4.8113793538142d-01, 4.4927082037103d-01,
     |   4.1654849281919d-01, 3.8303324153620d-01, 3.4878886470776d-01,
     |   3.1388054845148d-01, 2.7837474273142d-01, 2.4233903486679d-01,
     |   2.0584202087564d-01, 1.6895317489845d-01, 1.3174271695018d-01,
     |   9.4281479252422d-02, 5.6640771400301d-02, 1.8892244620565d-02/
      data (pmn(lat, 0, 2), lat = 1,72)/
     |   1.5800101597233d+00, 1.5709936836752d+00, 1.5530293524062d+00,
     |   1.5262538853242d+00, 1.4908710599013d+00, 1.4471501608036d+00,
     |   1.3954239304727d+00, 1.3360860367546d+00, 1.2695880768497d+00,
     |   1.1964361403854d+00, 1.1171869577685d+00, 1.0324436631307d+00,
     |   9.4285120411363d-01, 8.4909143342780d-01, 7.5187791954184d-01,
     |   6.5195051599552d-01, 5.5006973066766d-01, 4.4701093785191d-01,
     |   3.4355847719019d-01, 2.4049968437443d-01, 1.3861889904657d-01,
     |   3.8691495500260d-02,-5.8522018385708d-02,-1.5228178907153d-01,
     |  -2.4187424808860d-01,-3.2661754272637d-01,-4.0586672534327d-01,
     |  -4.7901866180761d-01,-5.4551662171255d-01,-6.0485451543065d-01,
     |  -6.5658074576151d-01,-7.0030164485917d-01,-7.3568447028209d-01,
     |  -7.6245993736406d-01,-7.8042426863313d-01,-7.8944074468117d-01,
     |  -7.8944074468117d-01,-7.8042426863313d-01,-7.6245993736406d-01,
     |  -7.3568447028209d-01,-7.0030164485917d-01,-6.5658074576151d-01,
     |  -6.0485451543065d-01,-5.4551662171255d-01,-4.7901866180761d-01,
     |  -4.0586672534327d-01,-3.2661754272637d-01,-2.4187424808860d-01,
     |  -1.5228178907153d-01,-5.8522018385708d-02, 3.8691495500260d-02,
     |   1.3861889904657d-01, 2.4049968437443d-01, 3.4355847719018d-01,
     |   4.4701093785191d-01, 5.5006973066766d-01, 6.5195051599552d-01,
     |   7.5187791954184d-01, 8.4909143342780d-01, 9.4285120411363d-01,
     |   1.0324436631307d+00, 1.1171869577685d+00, 1.1964361403854d+00,
     |   1.2695880768497d+00, 1.3360860367546d+00, 1.3954239304727d+00,
     |   1.4471501608036d+00, 1.4908710599013d+00, 1.5262538853242d+00,
     |   1.5530293524062d+00, 1.5709936836752d+00, 1.5800101597233d+00/
      data (pmn(lat, 1, 2), lat = 1,72)/
     |   4.2234290209426d-02, 1.2638144217803d-01, 2.0956675506046d-01,
     |   2.9115713839701d-01, 3.7053164010487d-01, 4.4708617229841d-01,
     |   5.2023810876275d-01, 5.8943071909105d-01, 6.5413740573907d-01,
     |   7.1386571175044d-01, 7.6816106865150d-01, 8.1661025599178d-01,
     |   8.5884454620120d-01, 8.9454251082953d-01, 9.2343246681090d-01,
     |   9.4529454413607d-01, 9.5996235919592d-01, 9.6732428106117d-01,
     |   9.6732428106117d-01, 9.5996235919592d-01, 9.4529454413607d-01,
     |   9.2343246681090d-01, 8.9454251082953d-01, 8.5884454620120d-01,
     |   8.1661025599178d-01, 7.6816106865149d-01, 7.1386571175044d-01,
     |   6.5413740573907d-01, 5.8943071909105d-01, 5.2023810876275d-01,
     |   4.4708617229841d-01, 3.7053164010487d-01, 2.9115713839701d-01,
     |   2.0956675506046d-01, 1.2638144217803d-01, 4.2234290209429d-02,
     |  -4.2234290209429d-02,-1.2638144217803d-01,-2.0956675506046d-01,
     |  -2.9115713839701d-01,-3.7053164010487d-01,-4.4708617229841d-01,
     |  -5.2023810876275d-01,-5.8943071909105d-01,-6.5413740573907d-01,
     |  -7.1386571175044d-01,-7.6816106865149d-01,-8.1661025599178d-01,
     |  -8.5884454620120d-01,-8.9454251082953d-01,-9.2343246681090d-01,
     |  -9.4529454413607d-01,-9.5996235919592d-01,-9.6732428106117d-01,
     |  -9.6732428106117d-01,-9.5996235919592d-01,-9.4529454413608d-01,
     |  -9.2343246681090d-01,-8.9454251082953d-01,-8.5884454620120d-01,
     |  -8.1661025599178d-01,-7.6816106865150d-01,-7.1386571175044d-01,
     |  -6.5413740573907d-01,-5.8943071909105d-01,-5.2023810876275d-01,
     |  -4.4708617229841d-01,-3.7053164010487d-01,-2.9115713839701d-01,
     |  -2.0956675506046d-01,-1.2638144217803d-01,-4.2234290209426d-02/
      data (pmn(lat, 2, 2), lat = 1,72)/
     |   4.6077774534299d-04, 4.1417386779661d-03, 1.1475646207890d-02,
     |   2.2406684870477d-02, 3.6851662861164d-02, 5.4700645175325d-02,
     |   7.5817790280039d-02, 1.0004238395018d-01, 1.2719006240071d-01,
     |   1.5705421540639d-01, 1.8940755873040d-01, 2.2400386389455d-01,
     |   2.6057983212672d-01, 2.9885709822349d-01, 3.3854434907742d-01,
     |   3.7933954074570d-01, 4.2093219718691d-01, 4.6300577317121d-01,
     |   5.0524006338064d-01, 5.4731363936494d-01, 5.8890629580616d-01,
     |   6.2970148747443d-01, 6.6938873832836d-01, 7.0766600442513d-01,
     |   7.4424197265730d-01, 7.7883827782145d-01, 8.1119162114546d-01,
     |   8.4105577415115d-01, 8.6820345260167d-01, 8.9242804627181d-01,
     |   9.1354519137653d-01, 9.3139417369069d-01, 9.4583915168138d-01,
     |   9.5677019034396d-01, 9.6410409787389d-01, 9.6778505880651d-01,
     |   9.6778505880651d-01, 9.6410409787389d-01, 9.5677019034396d-01,
     |   9.4583915168138d-01, 9.3139417369069d-01, 9.1354519137653d-01,
     |   8.9242804627181d-01, 8.6820345260167d-01, 8.4105577415115d-01,
     |   8.1119162114546d-01, 7.7883827782145d-01, 7.4424197265730d-01,
     |   7.0766600442513d-01, 6.6938873832836d-01, 6.2970148747443d-01,
     |   5.8890629580616d-01, 5.4731363936494d-01, 5.0524006338064d-01,
     |   4.6300577317121d-01, 4.2093219718691d-01, 3.7933954074570d-01,
     |   3.3854434907742d-01, 2.9885709822349d-01, 2.6057983212672d-01,
     |   2.2400386389455d-01, 1.8940755873040d-01, 1.5705421540639d-01,
     |   1.2719006240071d-01, 1.0004238395018d-01, 7.5817790280039d-02,
     |   5.4700645175325d-02, 3.6851662861164d-02, 2.2406684870477d-02,
     |   1.1475646207890d-02, 4.1417386779661d-03, 4.6077774534299d-04/
      data (pmn(lat, 0, 3), lat = 1,72)/
     |   1.8681582485243d+00, 1.8468594424738d+00, 1.8046059557036d+00,
     |   1.7420801894434d+00, 1.6602912219706d+00, 1.5605576586516d+00,
     |   1.4444852240963d+00, 1.3139394795375d+00, 1.1710141318827d+00,
     |   1.0179954762438d+00, 8.5732357983467d-01, 6.9155087081478d-01,
     |   5.2329883998888d-01, 3.5521359549693d-01, 1.8992103018644d-01,
     |   2.9982367922631d-02,-1.2214915145465d-01,-2.6416970836236d-01,
     |  -3.9396375293544d-01,-5.0963960407665d-01,-6.0956119012512d-01,
     |  -6.9237538924437d-01,-7.5703450297193d-01,-8.0281347969367d-01,
     |  -8.2932159468265d-01,-8.3650838823537d-01,-8.2466376172467d-01,
     |  -7.9441223138648d-01,-7.4670143965579d-01,-6.8278512215462d-01,
     |  -6.0420082332973d-01,-5.1274274361677d-01,-4.1043018433167d-01,
     |  -2.9947213183542d-01,-1.8222858859328d-01,-6.1169314426057d-02,
     |   6.1169314426056d-02, 1.8222858859328d-01, 2.9947213183542d-01,
     |   4.1043018433167d-01, 5.1274274361677d-01, 6.0420082332973d-01,
     |   6.8278512215462d-01, 7.4670143965579d-01, 7.9441223138648d-01,
     |   8.2466376172467d-01, 8.3650838823538d-01, 8.2932159468265d-01,
     |   8.0281347969367d-01, 7.5703450297193d-01, 6.9237538924437d-01,
     |   6.0956119012512d-01, 5.0963960407665d-01, 3.9396375293544d-01,
     |   2.6416970836236d-01, 1.2214915145465d-01,-2.9982367922630d-02,
     |  -1.8992103018644d-01,-3.5521359549693d-01,-5.2329883998887d-01,
     |  -6.9155087081478d-01,-8.5732357983467d-01,-1.0179954762437d+00,
     |  -1.1710141318827d+00,-1.3139394795375d+00,-1.4444852240963d+00,
     |  -1.5605576586516d+00,-1.6602912219706d+00,-1.7420801894434d+00,
     |  -1.8046059557036d+00,-1.8468594424738d+00,-1.8681582485243d+00/
      data (pmn(lat, 1, 3), lat = 1,72)/
     |   7.0646256884359d-02, 2.1079717719319d-01, 3.4754272221515d-01,
     |   4.7867699361874d-01, 6.0208946529768d-01, 7.1580084147048d-01,
     |   8.1799667109021d-01, 9.0705814389241d-01, 9.8158954162731d-01,
     |   1.0404418752486d+00, 1.0827323040841d+00, 1.1078590051788d+00,
     |   1.1155112388411d+00, 1.1056744386093d+00, 1.0786302389797d+00,
     |   1.0349514408434d+00, 9.7549200118551d-01, 9.0137221872341d-01,
     |   8.1395936935011d-01, 7.1484412308695d-01, 6.0581314641799d-01,
     |   4.8881835913159d-01, 3.6594337202236d-01, 2.3936768002648d-01,
     |   1.1132922375224d-01,-1.5914039732299d-02,-1.4012289905856d-01,
     |  -2.5911532018880d-01,-3.7080388971884d-01,-4.7323162898125d-01,
     |  -5.6460556597332d-01,-6.4332749051825d-01,-7.0802136628404d-01,
     |  -7.5755693050657d-01,-7.9106907751378d-01,-8.0797269430906d-01,
     |  -8.0797269430906d-01,-7.9106907751378d-01,-7.5755693050657d-01,
     |  -7.0802136628404d-01,-6.4332749051825d-01,-5.6460556597332d-01,
     |  -4.7323162898126d-01,-3.7080388971884d-01,-2.5911532018880d-01,
     |  -1.4012289905856d-01,-1.5914039732299d-02, 1.1132922375224d-01,
     |   2.3936768002648d-01, 3.6594337202236d-01, 4.8881835913159d-01,
     |   6.0581314641799d-01, 7.1484412308695d-01, 8.1395936935011d-01,
     |   9.0137221872341d-01, 9.7549200118551d-01, 1.0349514408434d+00,
     |   1.0786302389797d+00, 1.1056744386093d+00, 1.1155112388411d+00,
     |   1.1078590051788d+00, 1.0827323040841d+00, 1.0404418752486d+00,
     |   9.8158954162731d-01, 9.0705814389241d-01, 8.1799667109021d-01,
     |   7.1580084147048d-01, 6.0208946529768d-01, 4.7867699361874d-01,
     |   3.4754272221515d-01, 2.1079717719319d-01, 7.0646256884359d-02/
      data (pmn(lat, 2, 3), lat = 1,72)/
     |   1.2188132102727d-03, 1.0934548595603d-02, 3.0181246288381d-02,
     |   5.8592556932246d-02, 9.5626893725880d-02, 1.4057680469726d-01,
     |   1.9258121785546d-01, 2.5064034943472d-01, 3.1363301981330d-01,
     |   3.8033608042855d-01, 4.4944561882514d-01, 5.1959957848583d-01,
     |   5.8940140582382d-01, 6.5744431907939d-01, 7.2233578316253d-01,
     |   7.8272177090022d-01, 8.3731039474439d-01, 8.8489450371261d-01,
     |   9.2437285798405d-01, 9.5476951785798d-01, 9.7525111428407d-01,
     |   9.8514170437241d-01, 9.8393495656590d-01, 9.7130345580417d-01,
     |   9.4710496824349d-01, 9.1138555708029d-01, 8.6437949486724d-01,
     |   8.0650597248880d-01, 7.3836265974085d-01, 6.6071622629926d-01,
     |   5.7448998384384d-01, 4.8074885933744d-01, 3.8068195510338d-01,
     |   2.7558299261562d-01, 1.6682897311096d-01, 5.5857418629699d-02,
     |  -5.5857418629699d-02,-1.6682897311096d-01,-2.7558299261562d-01,
     |  -3.8068195510337d-01,-4.8074885933744d-01,-5.7448998384384d-01,
     |  -6.6071622629926d-01,-7.3836265974085d-01,-8.0650597248880d-01,
     |  -8.6437949486724d-01,-9.1138555708029d-01,-9.4710496824349d-01,
     |  -9.7130345580417d-01,-9.8393495656590d-01,-9.8514170437241d-01,
     |  -9.7525111428408d-01,-9.5476951785798d-01,-9.2437285798405d-01,
     |  -8.8489450371261d-01,-8.3731039474439d-01,-7.8272177090022d-01,
     |  -7.2233578316253d-01,-6.5744431907939d-01,-5.8940140582382d-01,
     |  -5.1959957848583d-01,-4.4944561882514d-01,-3.8033608042855d-01,
     |  -3.1363301981331d-01,-2.5064034943472d-01,-1.9258121785546d-01,
     |  -1.4057680469726d-01,-9.5626893725880d-02,-5.8592556932246d-02,
     |  -3.0181246288381d-02,-1.0934548595603d-02,-1.2188132102727d-03/
      data (pmn(lat, 3, 3), lat = 1,72)/
     |   1.0857199518147d-05, 2.9258672398563d-04, 1.3494173866679d-03,
     |   3.6816880262426d-03, 7.7654425262321d-03, 1.4043302432631d-02,
     |   2.2915918011808d-02, 3.4734145880501d-02, 4.9792088891804d-02,
     |   6.8321119188086d-02, 9.0484988486455d-02, 1.1637611103312d-01,
     |   1.4601308456849d-01, 1.7933949342899d-01, 2.1622401593747d-01,
     |   2.5646183587782d-01, 2.9977733549342d-01, 3.4582802547613d-01,
     |   3.9420964619868d-01, 4.4446235435140d-01, 4.9607789051864d-01,
     |   5.4850760638889d-01, 6.0117121552482d-01, 6.5346611917733d-01,
     |   7.0477714872414d-01, 7.5448655911870d-01, 8.0198410337210d-01,
     |   8.4667701663334d-01, 8.8799973990862d-01, 9.2542321784077d-01,
     |   9.5846361218301d-01, 9.8669028252204d-01, 1.0097328982650d+00,
     |   1.0272875606905d+00, 1.0391218307214d+00, 1.0450785767211d+00,
     |   1.0450785767211d+00, 1.0391218307214d+00, 1.0272875606905d+00,
     |   1.0097328982650d+00, 9.8669028252204d-01, 9.5846361218301d-01,
     |   9.2542321784077d-01, 8.8799973990862d-01, 8.4667701663334d-01,
     |   8.0198410337210d-01, 7.5448655911870d-01, 7.0477714872414d-01,
     |   6.5346611917733d-01, 6.0117121552482d-01, 5.4850760638889d-01,
     |   4.9607789051864d-01, 4.4446235435140d-01, 3.9420964619868d-01,
     |   3.4582802547613d-01, 2.9977733549342d-01, 2.5646183587782d-01,
     |   2.1622401593747d-01, 1.7933949342899d-01, 1.4601308456849d-01,
     |   1.1637611103312d-01, 9.0484988486455d-02, 6.8321119188086d-02,
     |   4.9792088891804d-02, 3.4734145880501d-02, 2.2915918011808d-02,
     |   1.4043302432631d-02, 7.7654425262321d-03, 3.6816880262426d-03,
     |   1.3494173866679d-03, 2.9258672398563d-04, 1.0857199518147d-05/
      data (pmn(lat, 0, 4), lat = 1,72)/
     |   2.1162748780797d+00, 2.0761196854644d+00, 1.9969146067607d+00,
     |   1.8808375444545d+00, 1.7310745630989d+00, 1.5517256766444d+00,
     |   1.3476836998506d+00, 1.1244898187271d+00, 8.8817023618212d-01,
     |   6.4505881817702d-01, 4.0161108543698d-01, 1.6421515345045d-01,
     |  -6.0994688691745d-02,-2.6831615474340d-01,-4.5264354172379d-01,
     |  -6.0961377968499d-01,-7.3572958231517d-01,-8.2845602819405d-01,
     |  -8.8628771181386d-01,-9.0878449914253d-01,-8.9657487730942d-01,
     |  -8.5132687292053d-01,-7.7568749863045d-01,-6.7319264298295d-01,
     |  -5.4815021515751d-01,-4.0550016689467d-01,-2.5065571390097d-01,
     |  -8.9330647205875d-02, 7.2641955982874d-02, 2.2949405510872d-01,
     |   3.7570434828264d-01, 5.0617178352727d-01, 6.1637556344209d-01,
     |   7.0251674348599d-01, 7.6163708924564d-01, 7.9171155518051d-01,
     |   7.9171155518051d-01, 7.6163708924564d-01, 7.0251674348599d-01,
     |   6.1637556344209d-01, 5.0617178352727d-01, 3.7570434828264d-01,
     |   2.2949405510872d-01, 7.2641955982875d-02,-8.9330647205875d-02,
     |  -2.5065571390097d-01,-4.0550016689467d-01,-5.4815021515751d-01,
     |  -6.7319264298295d-01,-7.7568749863045d-01,-8.5132687292053d-01,
     |  -8.9657487730942d-01,-9.0878449914253d-01,-8.8628771181386d-01,
     |  -8.2845602819405d-01,-7.3572958231517d-01,-6.0961377968499d-01,
     |  -4.5264354172379d-01,-2.6831615474339d-01,-6.0994688691747d-02,
     |   1.6421515345045d-01, 4.0161108543698d-01, 6.4505881817702d-01,
     |   8.8817023618212d-01, 1.1244898187271d+00, 1.3476836998506d+00,
     |   1.5517256766444d+00, 1.7310745630989d+00, 1.8808375444545d+00,
     |   1.9969146067607d+00, 2.0761196854644d+00, 2.1162748780797d+00/
      data (pmn(lat, 1, 4), lat = 1,72)/
     |   1.0336630481978d-01, 3.0725268346525d-01, 5.0268460907983d-01,
     |   6.8430403695067d-01, 8.4716148659381d-01, 9.8686209928351d-01,
     |   1.0996949612748d+00, 1.1827417953576d+00, 1.2339617491228d+00,
     |   1.2522497332389d+00, 1.2374665651041d+00, 1.1904400281104d+00,
     |   1.1129368384560d+00, 1.0076063932122d+00, 8.7789802839625d-01,
     |   7.2795431818249d-01, 5.6248367171714d-01, 3.8661611028762d-01,
     |   2.0574661581349d-01, 2.5370816359949d-02,-1.4908199573994d-01,
     |  -3.1241343949468d-01,-4.5981321702206d-01,-5.8700411181472d-01,
     |  -6.9037041663450d-01,-7.6706590048731d-01,-8.1509804857452d-01,
     |  -8.3338603269061d-01,-8.2179067023386d-01,-7.8111548347002d-01,
     |  -7.1307885098722d-01,-6.2025812364043d-01,-5.0600743094027d-01,
     |  -3.7435170484260d-01,-2.2986017189194d-01,-7.7503189654352d-02,
     |   7.7503189654352d-02, 2.2986017189194d-01, 3.7435170484260d-01,
     |   5.0600743094027d-01, 6.2025812364043d-01, 7.1307885098722d-01,
     |   7.8111548347002d-01, 8.2179067023386d-01, 8.3338603269061d-01,
     |   8.1509804857452d-01, 7.6706590048731d-01, 6.9037041663450d-01,
     |   5.8700411181472d-01, 4.5981321702206d-01, 3.1241343949468d-01,
     |   1.4908199573994d-01,-2.5370816359949d-02,-2.0574661581349d-01,
     |  -3.8661611028762d-01,-5.6248367171714d-01,-7.2795431818249d-01,
     |  -8.7789802839625d-01,-1.0076063932122d+00,-1.1129368384560d+00,
     |  -1.1904400281104d+00,-1.2374665651041d+00,-1.2522497332389d+00,
     |  -1.2339617491228d+00,-1.1827417953576d+00,-1.0996949612748d+00,
     |  -9.8686209928351d-01,-8.4716148659381d-01,-6.8430403695067d-01,
     |  -5.0268460907983d-01,-3.0725268346525d-01,-1.0336630481978d-01/
      data (pmn(lat, 2, 4), lat = 1,72)/
     |   2.3929420885512d-03, 2.1413704442020d-02, 5.8804694173456d-02,
     |   1.1328516002813d-01, 1.8298415028628d-01, 2.6549900145699d-01,
     |   3.5797051021510d-01, 4.5717248801834d-01, 5.5961295694296d-01,
     |   6.6164388782997d-01, 7.5957611873057d-01, 8.4979593089927d-01,
     |   9.2887970611639d-01, 9.9370314457565d-01, 1.0415416852850d+00,
     |   1.0701590359742d+00, 1.0778810788466d+00, 1.0636528612476d+00,
     |   1.0270768930154d+00, 9.6843153935351d-01, 8.8866890230318d-01,
     |   7.8939220693998d-01, 6.7281333133892d-01, 5.4169172322522d-01,
     |   3.9925651269395d-01, 2.4911414222679d-01, 9.5144276894290d-02,
     |  -5.8612884323585d-02,-2.0807451163206d-01,-3.4923471646469d-01,
     |  -4.7828219345497d-01,-5.9171238885721d-01,-6.8643081490944d-01,
     |  -7.5984439510721d-01,-8.0993808529849d-01,-8.3533445900794d-01,
     |  -8.3533445900794d-01,-8.0993808529849d-01,-7.5984439510721d-01,
     |  -6.8643081490944d-01,-5.9171238885721d-01,-4.7828219345497d-01,
     |  -3.4923471646469d-01,-2.0807451163206d-01,-5.8612884323585d-02,
     |   9.5144276894290d-02, 2.4911414222679d-01, 3.9925651269395d-01,
     |   5.4169172322522d-01, 6.7281333133892d-01, 7.8939220693998d-01,
     |   8.8866890230318d-01, 9.6843153935351d-01, 1.0270768930154d+00,
     |   1.0636528612476d+00, 1.0778810788466d+00, 1.0701590359742d+00,
     |   1.0415416852850d+00, 9.9370314457565d-01, 9.2887970611639d-01,
     |   8.4979593089927d-01, 7.5957611873057d-01, 6.6164388782997d-01,
     |   5.5961295694296d-01, 4.5717248801834d-01, 3.5797051021510d-01,
     |   2.6549900145699d-01, 1.8298415028628d-01, 1.1328516002813d-01,
     |   5.8804694173456d-02, 2.1413704442020d-02, 2.3929420885512d-03/
      data (pmn(lat, 3, 4), lat = 1,72)/
     |   3.2563847396020d-05, 8.7588082005063d-04, 4.0241907183740d-03,
     |   1.0916516216065d-02, 2.2848695176637d-02, 4.0922551355776d-02,
     |   6.6001271251069d-02, 9.8672427769573d-02, 1.3921985602557d-01,
     |   1.8760531397743d-01, 2.4346055907420d-01, 3.0609015080377d-01,
     |   3.7448495781353d-01, 4.4734601721581d-01, 5.2311807289745d-01,
     |   6.0003181891987d-01, 6.7615360261180d-01, 7.4944110802272d-01,
     |   8.1780335118508d-01, 8.7916317993336d-01, 9.3152038712152d-01,
     |   9.7301351957569d-01, 1.0019784968814d+00, 1.0170022432294d+00,
     |   1.0169696793820d+00, 1.0011026160614d+00, 9.6898932885732d-01,
     |   9.2060387090546d-01, 8.5631448475672d-01, 7.7688079982931d-01,
     |   6.8343983677165d-01, 5.7748117484223d-01, 4.6081196289430d-01,
     |   3.3551275892002d-01, 2.0388545814161d-01, 6.8394807009758d-02,
     |  -6.8394807009758d-02,-2.0388545814161d-01,-3.3551275892002d-01,
     |  -4.6081196289430d-01,-5.7748117484223d-01,-6.8343983677165d-01,
     |  -7.7688079982931d-01,-8.5631448475672d-01,-9.2060387090546d-01,
     |  -9.6898932885732d-01,-1.0011026160614d+00,-1.0169696793820d+00,
     |  -1.0170022432294d+00,-1.0019784968814d+00,-9.7301351957569d-01,
     |  -9.3152038712152d-01,-8.7916317993336d-01,-8.1780335118509d-01,
     |  -7.4944110802272d-01,-6.7615360261180d-01,-6.0003181891987d-01,
     |  -5.2311807289745d-01,-4.4734601721581d-01,-3.7448495781353d-01,
     |  -3.0609015080377d-01,-2.4346055907420d-01,-1.8760531397743d-01,
     |  -1.3921985602557d-01,-9.8672427769573d-02,-6.6001271251069d-02,
     |  -4.0922551355776d-02,-2.2848695176637d-02,-1.0916516216065d-02,
     |  -4.0241907183740d-03,-8.7588082005063d-04,-3.2563847396020d-05/
      data (pmn(lat, 4, 4), lat = 1,72)/
     |   2.5121583357771d-07, 2.0296885663873d-05, 1.5581824874200d-04,
     |   5.9404484338321d-04, 1.6068605796336d-03, 3.5403721460977d-03,
     |   6.8015244445460d-03, 1.1842191564959d-02, 1.9141253662258d-02,
     |   2.9185236232220d-02, 4.2448136660845d-02, 5.9371092033142d-02,
     |   8.0342551115715d-02, 1.0567960187014d-01, 1.3561107413353d-01,
     |   1.7026298615675d-01, 2.0964683504494d-01, 2.5365114686518d-01,
     |   3.0203660481704d-01, 3.5443496634957d-01, 4.1035186570945d-01,
     |   4.6917348059128d-01, 5.3017692390932d-01, 5.9254410779710d-01,
     |   6.5537872023464d-01, 7.1772585845259d-01, 7.7859378040755d-01,
     |   8.3697716869474d-01, 8.9188125231837d-01, 9.4234610228444d-01,
     |   9.8747040793785d-01, 1.0264340526377d+00, 1.0585188394286d+00,
     |   1.0831267688818d+00, 1.0997953407166d+00, 1.1082094360987d+00,
     |   1.1082094360987d+00, 1.0997953407166d+00, 1.0831267688818d+00,
     |   1.0585188394286d+00, 1.0264340526377d+00, 9.8747040793785d-01,
     |   9.4234610228444d-01, 8.9188125231837d-01, 8.3697716869474d-01,
     |   7.7859378040755d-01, 7.1772585845259d-01, 6.5537872023464d-01,
     |   5.9254410779710d-01, 5.3017692390932d-01, 4.6917348059128d-01,
     |   4.1035186570945d-01, 3.5443496634957d-01, 3.0203660481704d-01,
     |   2.5365114686518d-01, 2.0964683504494d-01, 1.7026298615675d-01,
     |   1.3561107413353d-01, 1.0567960187014d-01, 8.0342551115715d-02,
     |   5.9371092033142d-02, 4.2448136660845d-02, 2.9185236232221d-02,
     |   1.9141253662259d-02, 1.1842191564959d-02, 6.8015244445460d-03,
     |   3.5403721460977d-03, 1.6068605796336d-03, 5.9404484338321d-04,
     |   1.5581824874200d-04, 2.0296885663873d-05, 2.5121583357771d-07/
      data (pmn(lat, 0, 5), lat = 1,72)/
     |   2.3368434108042d+00, 2.2704516427149d+00, 2.1404362834766d+00,
     |   1.9522082197570d+00, 1.7135759643839d+00, 1.4343923824290d+00,
     |   1.1261096897010d+00, 8.0126344757181d-01, 4.7290956310670d-01,
     |   1.5404045805453d-01,-1.4299250651873d-01,-4.0702361397230d-01,
     |  -6.2855925549977d-01,-8.0018393130592d-01,-9.1686728134614d-01,
     |  -9.7615833592889d-01,-9.7825851694319d-01,-9.2597064981803d-01,
     |  -8.2452709325736d-01,-6.8130578166657d-01,-5.0544823507888d-01,
     |  -3.0739817486805d-01,-9.8383074400660d-02, 1.1013640168740d-01,
     |   3.0702268074938d-01, 4.8199671984350d-01, 6.2612711343169d-01,
     |   7.3224968002612d-01, 7.9529772963408d-01, 8.1252754367261d-01,
     |   7.8362865888034d-01, 7.1071409518840d-01, 5.9819143999473d-01,
     |   4.5252142276726d-01, 2.8187601188791d-01, 9.5712883134118d-02,
     |  -9.5712883134117d-02,-2.8187601188791d-01,-4.5252142276726d-01,
     |  -5.9819143999473d-01,-7.1071409518840d-01,-7.8362865888034d-01,
     |  -8.1252754367261d-01,-7.9529772963408d-01,-7.3224968002612d-01,
     |  -6.2612711343169d-01,-4.8199671984351d-01,-3.0702268074938d-01,
     |  -1.1013640168740d-01, 9.8383074400660d-02, 3.0739817486805d-01,
     |   5.0544823507888d-01, 6.8130578166657d-01, 8.2452709325736d-01,
     |   9.2597064981803d-01, 9.7825851694319d-01, 9.7615833592889d-01,
     |   9.1686728134614d-01, 8.0018393130592d-01, 6.2855925549977d-01,
     |   4.0702361397230d-01, 1.4299250651873d-01,-1.5404045805453d-01,
     |  -4.7290956310670d-01,-8.0126344757181d-01,-1.1261096897010d+00,
     |  -1.4343923824290d+00,-1.7135759643839d+00,-1.9522082197570d+00,
     |  -2.1404362834766d+00,-2.2704516427149d+00,-2.3368434108042d+00/
      data (pmn(lat, 1, 5), lat = 1,72)/
     |   1.3987535260753d-01, 4.1379046586357d-01, 6.7046335854522d-01,
     |   8.9926873003438d-01, 1.0908429480985d+00, 1.2375055793596d+00,
     |   1.3336025031511d+00, 1.3757546960626d+00, 1.3630012168129d+00,
     |   1.2968299016869d+00, 1.1810945640993d+00, 1.0218228281284d+00,
     |   8.2692386286400d-01, 6.0580997942358d-01, 3.6895008379448d-01,
     |   1.2737615602705d-01,-1.0783389997660d-01,-3.2607262391199d-01,
     |  -5.1769425919885d-01,-6.7445781934034d-01,-7.8990120318354d-01,
     |  -8.5962891068213d-01,-8.8150004195892d-01,-8.5570801947262d-01,
     |  -7.8474862988463d-01,-6.7327829391965d-01,-5.2786968700955d-01,
     |  -3.5667670341596d-01,-1.6902505091104d-01, 2.5051721569637d-02,
     |   2.1530839108171d-01, 3.9179254766996d-01, 5.4533316140440d-01,
     |   6.6798977949970d-01, 7.5344081005910d-01, 7.9729228105642d-01,
     |   7.9729228105642d-01, 7.5344081005910d-01, 6.6798977949970d-01,
     |   5.4533316140440d-01, 3.9179254766996d-01, 2.1530839108171d-01,
     |   2.5051721569638d-02,-1.6902505091104d-01,-3.5667670341596d-01,
     |  -5.2786968700955d-01,-6.7327829391965d-01,-7.8474862988463d-01,
     |  -8.5570801947262d-01,-8.8150004195892d-01,-8.5962891068213d-01,
     |  -7.8990120318354d-01,-6.7445781934034d-01,-5.1769425919885d-01,
     |  -3.2607262391199d-01,-1.0783389997660d-01, 1.2737615602705d-01,
     |   3.6895008379448d-01, 6.0580997942358d-01, 8.2692386286400d-01,
     |   1.0218228281284d+00, 1.1810945640993d+00, 1.2968299016869d+00,
     |   1.3630012168129d+00, 1.3757546960626d+00, 1.3336025031511d+00,
     |   1.2375055793596d+00, 1.0908429480985d+00, 8.9926873003438d-01,
     |   6.7046335854522d-01, 4.1379046586357d-01, 1.3987535260753d-01/
      data (pmn(lat, 2, 5), lat = 1,72)/
     |   4.0394605446650d-03, 3.6033100766175d-02, 9.8320294695865d-02,
     |   1.8758390455503d-01, 2.9905183488525d-01, 4.2673041987701d-01,
     |   5.6369792163052d-01, 7.0244407049468d-01, 8.3523936219961d-01,
     |   9.5451638533039d-01, 1.0532448556265d+00, 1.1252823093930d+00,
     |   1.1656835442845d+00, 1.1709538383205d+00, 1.1392336353429d+00,
     |   1.0704056313800d+00, 9.6611887769336d-01, 8.2972845807731d-01,
     |   6.6615331325420d-01, 4.8165868338233d-01, 2.8357323565882d-01,
     |   7.9954066896327d-02,-1.2078472772393d-01,-3.1026246787145d-01,
     |  -4.8052289547327d-01,-6.2440732229547d-01,-7.3589227095574d-01,
     |  -8.1037560579510d-01,-8.4489755189917d-01,-8.3828604793318d-01,
     |  -7.9121942754599d-01,-7.0620330730451d-01,-5.8746259296396d-01,
     |  -4.4075350969891d-01,-2.7310432689332d-01,-9.2496806180698d-02,
     |   9.2496806180697d-02, 2.7310432689332d-01, 4.4075350969891d-01,
     |   5.8746259296396d-01, 7.0620330730451d-01, 7.9121942754599d-01,
     |   8.3828604793318d-01, 8.4489755189917d-01, 8.1037560579510d-01,
     |   7.3589227095574d-01, 6.2440732229547d-01, 4.8052289547327d-01,
     |   3.1026246787145d-01, 1.2078472772393d-01,-7.9954066896327d-02,
     |  -2.8357323565881d-01,-4.8165868338233d-01,-6.6615331325420d-01,
     |  -8.2972845807731d-01,-9.6611887769336d-01,-1.0704056313800d+00,
     |  -1.1392336353429d+00,-1.1709538383205d+00,-1.1656835442845d+00,
     |  -1.1252823093930d+00,-1.0532448556265d+00,-9.5451638533039d-01,
     |  -8.3523936219961d-01,-7.0244407049468d-01,-5.6369792163052d-01,
     |  -4.2673041987701d-01,-2.9905183488525d-01,-1.8758390455503d-01,
     |  -9.8320294695865d-02,-3.6033100766175d-02,-4.0394605446650d-03/
      data (pmn(lat, 3, 5), lat = 1,72)/
     |   7.1979957213484d-05, 1.9314611156835d-03, 8.8316738941395d-03,
     |   2.3785759523407d-02, 4.9304570342153d-02, 8.7232277215453d-02,
     |   1.3861635520210d-01, 2.0361882144079d-01, 2.8147358411367d-01,
     |   3.7049250478428d-01, 4.6812038658119d-01, 5.7103669228099d-01,
     |   6.7529948503413d-01, 7.7652498149040d-01, 8.7009431384824d-01,
     |   9.5137770068140d-01, 1.0159652943276d+00, 1.0598935511690d+00,
     |   1.0798560820705d+00, 1.0733885800374d+00, 1.0390185621276d+00,
     |   9.7637225027145d-01, 8.8623287703409d-01, 7.7054694571619d-01,
     |   6.3237739419624d-01, 4.7580509464966d-01, 3.0578254962639d-01,
     |   1.2794590416226d-01,-5.1606623343744d-02,-2.2656017596608d-01,
     |  -3.9064167757917d-01,-5.3787969268272d-01,-6.6285405513318d-01,
     |  -7.6092400881791d-01,-8.2842454171970d-01,-8.6282201389692d-01,
     |  -8.6282201389692d-01,-8.2842454171970d-01,-7.6092400881791d-01,
     |  -6.6285405513318d-01,-5.3787969268273d-01,-3.9064167757917d-01,
     |  -2.2656017596608d-01,-5.1606623343746d-02, 1.2794590416226d-01,
     |   3.0578254962639d-01, 4.7580509464966d-01, 6.3237739419624d-01,
     |   7.7054694571619d-01, 8.8623287703409d-01, 9.7637225027145d-01,
     |   1.0390185621276d+00, 1.0733885800374d+00, 1.0798560820705d+00,
     |   1.0598935511690d+00, 1.0159652943276d+00, 9.5137770068140d-01,
     |   8.7009431384824d-01, 7.7652498149040d-01, 6.7529948503413d-01,
     |   5.7103669228099d-01, 4.6812038658119d-01, 3.7049250478428d-01,
     |   2.8147358411367d-01, 2.0361882144079d-01, 1.3861635520210d-01,
     |   8.7232277215454d-02, 4.9304570342153d-02, 2.3785759523407d-02,
     |   8.8316738941395d-03, 1.9314611156835d-03, 7.1979957213484d-05/
      data (pmn(lat, 4, 5), lat = 1,72)/
     |   8.3299038503490d-07, 6.7173022965394d-05, 5.1371903763555d-04,
     |   1.9472934244449d-03, 5.2269515973664d-03, 1.1405582145228d-02,
     |   2.1656905022042d-02, 3.7191728250942d-02, 5.9167919754880d-02,
     |   8.8598927451881d-02, 1.2626581846623d-01, 1.7263769949991d-01,
     |   2.2780502924412d-01, 2.9142975604552d-01, 3.6271543668466d-01,
     |   4.4039955158124d-01, 5.2276917248171d-01, 6.0770001104643d-01,
     |   6.9271773454369d-01, 7.7507933280252d-01, 8.5187131171385d-01,
     |   9.2012062172473d-01, 9.7691354721795d-01, 1.0195173181168d+00,
     |   1.0454989820137d+00, 1.0528361057719d+00, 1.0400141601401d+00,
     |   1.0061059677034d+00, 9.5082934030428d-01, 8.7457996330945d-01,
     |   7.7843765840746d-01, 6.6414532474003d-01, 5.3406106634294d-01,
     |   3.9108520630227d-01, 2.3856500953995d-01, 8.0180934739171d-02,
     |  -8.0180934739171d-02,-2.3856500953995d-01,-3.9108520630227d-01,
     |  -5.3406106634294d-01,-6.6414532474003d-01,-7.7843765840746d-01,
     |  -8.7457996330945d-01,-9.5082934030428d-01,-1.0061059677034d+00,
     |  -1.0400141601401d+00,-1.0528361057719d+00,-1.0454989820137d+00,
     |  -1.0195173181168d+00,-9.7691354721795d-01,-9.2012062172473d-01,
     |  -8.5187131171385d-01,-7.7507933280252d-01,-6.9271773454369d-01,
     |  -6.0770001104643d-01,-5.2276917248171d-01,-4.4039955158124d-01,
     |  -3.6271543668466d-01,-2.9142975604552d-01,-2.2780502924412d-01,
     |  -1.7263769949991d-01,-1.2626581846623d-01,-8.8598927451881d-02,
     |  -5.9167919754880d-02,-3.7191728250942d-02,-2.1656905022042d-02,
     |  -1.1405582145228d-02,-5.2269515973664d-03,-1.9472934244449d-03,
     |  -5.1371903763555d-04,-6.7173022965394d-05,-8.3299038503490d-07/
      data (pmn(lat, 5, 5), lat = 1,72)/
     |   5.7477289514788d-09, 1.3922725978101d-06, 1.7791412035232d-05,
     |   9.4778876637011d-05, 3.2878368952449d-04, 8.8256898823663d-04,
     |   1.9961599969338d-03, 3.9923409346033d-03, 7.2761307112520d-03,
     |   1.2327969044462d-02, 1.9690684225814d-02, 2.9950654371259d-02,
     |   4.3713898669276d-02, 6.1578127656658d-02, 8.4102027142514d-02,
     |   1.1177323649791d-01, 1.4497659886711d-01, 1.8396430195567d-01,
     |   2.2882949053653d-01, 2.7948481657254d-01, 3.3564720449937d-01,
     |   3.9682985589147d-01, 4.6234221074519d-01, 5.3129823588975d-01,
     |   6.0263304049054d-01, 6.7512744139086d-01, 7.4743973472720d-01,
     |   8.1814359203201d-01, 8.8577070487928d-01, 9.4885656604015d-01,
     |   1.0059876084752d+00, 1.0558478344999d+00, 1.0972630607605d+00,
     |   1.1292409810826d+00, 1.1510054058215d+00, 1.1620232663138d+00,
     |   1.1620232663138d+00, 1.1510054058215d+00, 1.1292409810826d+00,
     |   1.0972630607605d+00, 1.0558478344999d+00, 1.0059876084752d+00,
     |   9.4885656604015d-01, 8.8577070487928d-01, 8.1814359203201d-01,
     |   7.4743973472720d-01, 6.7512744139086d-01, 6.0263304049054d-01,
     |   5.3129823588975d-01, 4.6234221074519d-01, 3.9682985589147d-01,
     |   3.3564720449937d-01, 2.7948481657254d-01, 2.2882949053653d-01,
     |   1.8396430195568d-01, 1.4497659886711d-01, 1.1177323649791d-01,
     |   8.4102027142514d-02, 6.1578127656658d-02, 4.3713898669276d-02,
     |   2.9950654371259d-02, 1.9690684225814d-02, 1.2327969044462d-02,
     |   7.2761307112520d-03, 3.9923409346033d-03, 1.9961599969338d-03,
     |   8.8256898823664d-04, 3.2878368952449d-04, 9.4778876637011d-05,
     |   1.7791412035232d-05, 1.3922725978101d-06, 5.7477289514788d-09/
      data (pmn(lat, 0, 6), lat = 1,72)/
     |   2.5367839097333d+00, 2.4360990805492d+00, 2.2406330820477d+00,
     |   1.9618145321158d+00, 1.6158647348188d+00, 1.2227604097917d+00,
     |   8.0496016326143d-01, 3.8597898396235d-01,-1.1095078805364d-02,
     |  -3.6504435113523d-01,-6.5783039147367d-01,-8.7568292999037d-01,
     |  -1.0098986070058d+00,-1.0572989553350d+00,-1.0203201298430d+00,
     |  -9.0673170993007d-01,-7.2900680395207d-01,-5.0338898314102d-01,
     |  -2.4872169291114d-01, 1.4878623144082d-02, 2.6741444071248d-01,
     |   4.9036909686952d-01, 6.6794644551306d-01, 7.8810489226313d-01,
     |   8.4331709305514d-01, 8.3100584486190d-01, 7.5362923926541d-01,
     |   6.1841243942378d-01, 4.3674781139802d-01, 2.2330792242240d-01,
     |  -5.0644463005138d-03,-2.3060997624832d-01,-4.3596125039375d-01,
     |  -6.0541356408152d-01,-7.2606865099264d-01,-7.8877098493253d-01,
     |  -7.8877098493253d-01,-7.2606865099264d-01,-6.0541356408152d-01,
     |  -4.3596125039375d-01,-2.3060997624832d-01,-5.0644463005134d-03,
     |   2.2330792242240d-01, 4.3674781139801d-01, 6.1841243942378d-01,
     |   7.5362923926541d-01, 8.3100584486190d-01, 8.4331709305514d-01,
     |   7.8810489226313d-01, 6.6794644551306d-01, 4.9036909686952d-01,
     |   2.6741444071249d-01, 1.4878623144083d-02,-2.4872169291113d-01,
     |  -5.0338898314102d-01,-7.2900680395207d-01,-9.0673170993007d-01,
     |  -1.0203201298430d+00,-1.0572989553350d+00,-1.0098986070058d+00,
     |  -8.7568292999037d-01,-6.5783039147367d-01,-3.6504435113523d-01,
     |  -1.1095078805368d-02, 3.8597898396235d-01, 8.0496016326143d-01,
     |   1.2227604097917d+00, 1.6158647348188d+00, 1.9618145321158d+00,
     |   2.2406330820477d+00, 2.4360990805492d+00, 2.5367839097333d+00/
      data (pmn(lat, 1, 6), lat = 1,72)/
     |   1.7979195750294d-01, 5.2882399741487d-01, 8.4687753492434d-01,
     |   1.1155123679439d+00, 1.3194522185732d+00, 1.4475524441784d+00,
     |   1.4934940984688d+00, 1.4561588926579d+00, 1.3396610612079d+00,
     |   1.1530351800118d+00, 9.0960205703685d-01, 6.2605635540966d-01,
     |   3.2133816082503d-01, 1.5365017152863d-02,-2.7228993668349d-01,
     |  -5.2368479780024d-01,-7.2367449489307d-01,-8.6087750075495d-01,
     |  -9.2837980725580d-01,-9.2413039097042d-01,-8.5100353248735d-01,
     |  -7.1652609585816d-01,-5.3229067560720d-01,-3.1309682442305d-01,
     |  -7.5880936339279d-02, 1.6149046819944d-01, 3.8148028615006d-01,
     |   5.6810616734608d-01, 7.0804730382045d-01, 7.9155680671984d-01,
     |   8.1311745893035d-01, 7.7179652581311d-01, 6.7127620876920d-01,
     |   5.1955880023723d-01, 3.2836810133752d-01, 1.1228965100210d-01,
     |  -1.1228965100210d-01,-3.2836810133752d-01,-5.1955880023723d-01,
     |  -6.7127620876920d-01,-7.7179652581311d-01,-8.1311745893035d-01,
     |  -7.9155680671984d-01,-7.0804730382045d-01,-5.6810616734608d-01,
     |  -3.8148028615006d-01,-1.6149046819944d-01, 7.5880936339278d-02,
     |   3.1309682442305d-01, 5.3229067560720d-01, 7.1652609585816d-01,
     |   8.5100353248735d-01, 9.2413039097042d-01, 9.2837980725580d-01,
     |   8.6087750075495d-01, 7.2367449489307d-01, 5.2368479780025d-01,
     |   2.7228993668349d-01,-1.5365017152863d-02,-3.2133816082503d-01,
     |  -6.2605635540966d-01,-9.0960205703685d-01,-1.1530351800118d+00,
     |  -1.3396610612079d+00,-1.4561588926579d+00,-1.4934940984688d+00,
     |  -1.4475524441784d+00,-1.3194522185732d+00,-1.1155123679439d+00,
     |  -8.4687753492434d-01,-5.2882399741487d-01,-1.7979195750294d-01/
      data (pmn(lat, 2, 6), lat = 1,72)/
     |   6.2073598283019d-03, 5.5160189257366d-02, 1.4935518614070d-01,
     |   2.8163073785347d-01, 4.4187583177005d-01, 6.1773892418088d-01,
     |   7.9549531975910d-01, 9.6101330775785d-01, 1.1007524456560d+00,
     |   1.2027250868988d+00, 1.2573546759434d+00, 1.2581713178026d+00,
     |   1.2022961960921d+00, 1.0906808095221d+00, 9.2808374041614d-01,
     |   7.2278561791262d-01, 4.8606086776613d-01, 2.3144152549149d-01,
     |  -2.6177310516317d-02,-2.7152987282106d-01,-4.9000262944795d-01,
     |  -6.6861812246929d-01,-7.9691266432526d-01,-8.6764789081001d-01,
     |  -8.7730734257774d-01,-8.2634376066342d-01,-7.1915965084925d-01,
     |  -5.6382175064202d-01,-3.7152809197428d-01,-1.5586316392038d-01,
     |   6.8108901600518d-02, 2.8485215409661d-01, 4.7939977526321d-01,
     |   6.3835795645816d-01, 7.5080494686110d-01, 8.0902455626005d-01,
     |   8.0902455626005d-01, 7.5080494686110d-01, 6.3835795645816d-01,
     |   4.7939977526321d-01, 2.8485215409661d-01, 6.8108901600518d-02,
     |  -1.5586316392038d-01,-3.7152809197428d-01,-5.6382175064202d-01,
     |  -7.1915965084925d-01,-8.2634376066341d-01,-8.7730734257774d-01,
     |  -8.6764789081001d-01,-7.9691266432526d-01,-6.6861812246929d-01,
     |  -4.9000262944796d-01,-2.7152987282107d-01,-2.6177310516319d-02,
     |   2.3144152549149d-01, 4.8606086776613d-01, 7.2278561791262d-01,
     |   9.2808374041614d-01, 1.0906808095221d+00, 1.2022961960921d+00,
     |   1.2581713178026d+00, 1.2573546759434d+00, 1.2027250868988d+00,
     |   1.1007524456560d+00, 9.6101330775785d-01, 7.9549531975910d-01,
     |   6.1773892418088d-01, 4.4187583177005d-01, 2.8163073785347d-01,
     |   1.4935518614070d-01, 5.5160189257366d-02, 6.2073598283019d-03/
      data (pmn(lat, 3, 6), lat = 1,72)/
     |   1.3548539527162d-04, 3.6251346940883d-03, 1.6481009824372d-02,
     |   4.4002909857941d-02, 9.0148454964500d-02, 1.5713949331132d-01,
     |   2.4519952647000d-01, 3.5244302987015d-01, 4.7492673010502d-01,
     |   6.0686132681992d-01, 7.4097061844061d-01, 8.6897431168538d-01,
     |   9.8216171152089d-01, 1.0720166396761d+00, 1.1308498024392d+00,
     |   1.1523937226147d+00, 1.1323173595144d+00, 1.0686225440131d+00,
     |   9.6189202608434d-01, 8.1536875850715d-01, 6.3485736138693d-01,
     |   4.2845076144071d-01, 2.0609695833653d-01,-2.0968078818743d-02,
     |  -2.4088599658299d-01,-4.4189766390619d-01,-6.1307407540643d-01,
     |  -7.4500867212133d-01,-8.3042525247665d-01,-8.6466078179837d-01,
     |  -8.4599029702831d-01,-7.7577122637509d-01,-6.5839613114060d-01,
     |  -5.0105535140344d-01,-3.1332346631313d-01,-1.0659503253347d-01,
     |   1.0659503253347d-01, 3.1332346631313d-01, 5.0105535140344d-01,
     |   6.5839613114060d-01, 7.7577122637509d-01, 8.4599029702831d-01,
     |   8.6466078179837d-01, 8.3042525247665d-01, 7.4500867212133d-01,
     |   6.1307407540643d-01, 4.4189766390619d-01, 2.4088599658299d-01,
     |   2.0968078818744d-02,-2.0609695833653d-01,-4.2845076144071d-01,
     |  -6.3485736138693d-01,-8.1536875850715d-01,-9.6189202608434d-01,
     |  -1.0686225440131d+00,-1.1323173595144d+00,-1.1523937226147d+00,
     |  -1.1308498024392d+00,-1.0720166396761d+00,-9.8216171152089d-01,
     |  -8.6897431168538d-01,-7.4097061844061d-01,-6.0686132681992d-01,
     |  -4.7492673010502d-01,-3.5244302987015d-01,-2.4519952647000d-01,
     |  -1.5713949331132d-01,-9.0148454964500d-02,-4.4002909857941d-02,
     |  -1.6481009824372d-02,-3.6251346940883d-03,-1.3548539527162d-04/
      data (pmn(lat, 4, 6), lat = 1,72)/
     |   2.0243065655318d-06, 1.6286875012861d-04, 1.2398689462997d-03,
     |   4.6674266816575d-03, 1.2412549972809d-02, 2.6769590974897d-02,
     |   5.0112391217597d-02, 8.4623548943205d-02, 1.3202262326012d-01,
     |   1.9331560048000d-01, 2.6858682118796d-01, 3.5685186923322d-01,
     |   4.5598583371168d-01, 5.6273614886011d-01, 6.7282325144165d-01,
     |   7.8112598327282d-01, 8.8194244807061d-01, 9.6931134399118d-01,
     |   1.0373740402525d+00, 1.0807541911569d+00, 1.0949297416802d+00,
     |   1.0765719303166d+00, 1.0238273772945d+00, 9.3652248188917d-01,
     |   8.1627395023985d-01, 6.6649504271522d-01, 4.9229369354510d-01,
     |   3.0026558437525d-01, 9.8192088814099d-02,-1.0534070903019d-01,
     |  -3.0138040491526d-01,-4.8107857446688d-01,-6.3616510677938d-01,
     |  -7.5939809223888d-01,-8.4496200631714d-01,-8.8878990688976d-01,
     |  -8.8878990688976d-01,-8.4496200631714d-01,-7.5939809223888d-01,
     |  -6.3616510677938d-01,-4.8107857446688d-01,-3.0138040491526d-01,
     |  -1.0534070903019d-01, 9.8192088814098d-02, 3.0026558437525d-01,
     |   4.9229369354510d-01, 6.6649504271522d-01, 8.1627395023985d-01,
     |   9.3652248188917d-01, 1.0238273772945d+00, 1.0765719303166d+00,
     |   1.0949297416802d+00, 1.0807541911569d+00, 1.0373740402525d+00,
     |   9.6931134399118d-01, 8.8194244807061d-01, 7.8112598327282d-01,
     |   6.7282325144165d-01, 5.6273614886011d-01, 4.5598583371168d-01,
     |   3.5685186923322d-01, 2.6858682118796d-01, 1.9331560048000d-01,
     |   1.3202262326013d-01, 8.4623548943206d-02, 5.0112391217597d-02,
     |   2.6769590974898d-02, 1.2412549972809d-02, 4.6674266816575d-03,
     |   1.2398689462997d-03, 1.6286875012861d-04, 2.0243065655318d-06/
      data (pmn(lat, 5, 6), lat = 1,72)/
     |   2.0718799765137d-08, 5.0091622276669d-06, 6.3766575241544d-05,
     |   3.3775287735921d-04, 1.1626684299616d-03, 3.0909539734097d-03,
     |   6.9097257488951d-03, 1.3630670924290d-02, 2.4450725371886d-02,
     |   4.0684793902771d-02, 6.3674172334671d-02, 9.4676512526666d-02,
     |   1.3474497085119d-01, 1.8460545814629d-01, 2.4454156122021d-01,
     |   3.1429667183459d-01, 3.9300212591578d-01, 4.7913875979341d-01,
     |   5.7053731486248d-01, 6.6442069227713d-01, 7.5748833369374d-01,
     |   8.4604016419738d-01, 9.2613477156300d-01, 9.9377400175120d-01,
     |   1.0451040984958d+00, 1.0766220521127d+00, 1.0853750587391d+00,
     |   1.0691409902082d+00, 1.0265785507023d+00, 9.5733731171798d-01,
     |   8.6211998487342d-01, 7.4269198184667d-01, 6.0183635585453d-01,
     |   4.4325542843439d-01, 2.7142357552357d-01, 9.1398575787873d-02,
     |  -9.1398575787873d-02,-2.7142357552357d-01,-4.4325542843439d-01,
     |  -6.0183635585453d-01,-7.4269198184667d-01,-8.6211998487342d-01,
     |  -9.5733731171798d-01,-1.0265785507023d+00,-1.0691409902082d+00,
     |  -1.0853750587391d+00,-1.0766220521127d+00,-1.0451040984958d+00,
     |  -9.9377400175120d-01,-9.2613477156300d-01,-8.4604016419738d-01,
     |  -7.5748833369374d-01,-6.6442069227713d-01,-5.7053731486248d-01,
     |  -4.7913875979341d-01,-3.9300212591578d-01,-3.1429667183459d-01,
     |  -2.4454156122021d-01,-1.8460545814629d-01,-1.3474497085119d-01,
     |  -9.4676512526666d-02,-6.3674172334671d-02,-4.0684793902771d-02,
     |  -2.4450725371886d-02,-1.3630670924290d-02,-6.9097257488951d-03,
     |  -3.0909539734098d-03,-1.1626684299616d-03,-3.3775287735921d-04,
     |  -6.3766575241544d-05,-5.0091622276669d-06,-2.0718799765137d-08/
      data (pmn(lat, 6, 6), lat = 1,72)/
     |   1.3050593468086d-10, 9.4777196133585d-08, 2.0159846779526d-06,
     |   1.5006817259265d-05, 6.6761647196096d-05, 2.1833990725930d-04,
     |   5.8139212303459d-04, 1.3356967579114d-03, 2.7448291452982d-03,
     |   5.1677865586144d-03, 9.0645801803142d-03, 1.4994165643827d-02,
     |   2.3603596141254d-02, 3.5607911453184d-02, 5.1760979060182d-02,
     |   7.2818229881862d-02, 9.9492928506529d-02, 1.3240823425620d-01,
     |   1.7204779785456d-01, 2.1870795952281d-01, 2.7245473949279d-01,
     |   3.3308872559398d-01, 4.0012066334000d-01, 4.7276005492724d-01,
     |   5.4991840172647d-01, 6.3022791938388d-01, 7.1207566448991d-01,
     |   7.9365209246224d-01, 8.7301217633396d-01, 9.4814641316273d-01,
     |   1.0170583816803d+00, 1.0778450362157d+00, 1.1287756611846d+00,
     |   1.1683653872967d+00, 1.1954393898495d+00, 1.2091843404148d+00,
     |   1.2091843404148d+00, 1.1954393898495d+00, 1.1683653872967d+00,
     |   1.1287756611846d+00, 1.0778450362157d+00, 1.0170583816803d+00,
     |   9.4814641316273d-01, 8.7301217633396d-01, 7.9365209246224d-01,
     |   7.1207566448991d-01, 6.3022791938388d-01, 5.4991840172647d-01,
     |   4.7276005492724d-01, 4.0012066334000d-01, 3.3308872559398d-01,
     |   2.7245473949280d-01, 2.1870795952281d-01, 1.7204779785456d-01,
     |   1.3240823425620d-01, 9.9492928506530d-02, 7.2818229881862d-02,
     |   5.1760979060182d-02, 3.5607911453184d-02, 2.3603596141254d-02,
     |   1.4994165643827d-02, 9.0645801803142d-03, 5.1677865586144d-03,
     |   2.7448291452982d-03, 1.3356967579114d-03, 5.8139212303459d-04,
     |   2.1833990725930d-04, 6.6761647196096d-05, 1.5006817259265d-05,
     |   2.0159846779526d-06, 9.4777196133585d-08, 1.3050593468086d-10/
      data (pmn(lat, 0, 7), lat = 1,72)/
     |   2.7203940411978d+00, 2.5767912484618d+00, 2.3008317213975d+00,
     |   1.9140401982521d+00, 1.4463717405909d+00, 9.3364734563180d-01,
     |   4.1450203195786d-01,-7.2883287353154d-02,-4.9397662680749d-01,
     |  -8.2073493524586d-01,-1.0338411990502d+00,-1.1241462740251d+00,
     |  -1.0931959462983d+00,-9.5280703126724d-01,-7.2374242403983d-01,
     |  -4.3361603689410d-01,-1.1422711255832d-01, 2.0142672992095d-01,
     |   4.8218165452934d-01, 7.0150769785040d-01, 8.3982376758388d-01,
     |   8.8612187576471d-01, 8.3876087792434d-01, 7.0536833843008d-01,
     |   5.0187257722573d-01, 2.5076771449885d-01,-2.1214864510580d-02,
     |  -2.8580126367582d-01,-5.1597635598579d-01,-6.8862408321292d-01,
     |  -7.8675659573641d-01,-8.0112279504940d-01,-7.3104709520078d-01,
     |  -5.8442326947136d-01,-3.7686910361092d-01,-1.3012762334452d-01,
     |   1.3012762334452d-01, 3.7686910361092d-01, 5.8442326947136d-01,
     |   7.3104709520078d-01, 8.0112279504940d-01, 7.8675659573641d-01,
     |   6.8862408321292d-01, 5.1597635598579d-01, 2.8580126367582d-01,
     |   2.1214864510581d-02,-2.5076771449885d-01,-5.0187257722572d-01,
     |  -7.0536833843008d-01,-8.3876087792434d-01,-8.8612187576471d-01,
     |  -8.3982376758388d-01,-7.0150769785040d-01,-4.8218165452934d-01,
     |  -2.0142672992095d-01, 1.1422711255832d-01, 4.3361603689410d-01,
     |   7.2374242403983d-01, 9.5280703126724d-01, 1.0931959462983d+00,
     |   1.1241462740251d+00, 1.0338411990502d+00, 8.2073493524586d-01,
     |   4.9397662680749d-01, 7.2883287353156d-02,-4.1450203195786d-01,
     |  -9.3364734563179d-01,-1.4463717405909d+00,-1.9140401982521d+00,
     |  -2.3008317213975d+00,-2.5767912484618d+00,-2.7203940411978d+00/
      data (pmn(lat, 1, 7), lat = 1,72)/
     |   2.2281862505971d-01, 6.5098346403658d-01, 1.0282348704475d+00,
     |   1.3255088786214d+00, 1.5206010077556d+00, 1.6000369101690d+00,
     |   1.5601658587903d+00, 1.4073822254011d+00, 1.1574591256739d+00,
     |   8.3405868869891d-01, 4.6655760473362d-01, 8.7387941355584d-02,
     |  -2.7086388758782d-01,-5.7833654282677d-01,-8.1049168167387d-01,
     |  -9.5019780066474d-01,-9.8911588099122d-01,-9.2826781089387d-01,
     |  -7.7774423555171d-01,-5.5558774148778d-01,-2.8596280383979d-01,
     |   3.2112391331341d-03, 2.8293971289019d-01, 5.2589297507696d-01,
     |   7.0895222934223d-01, 8.1532535840106d-01, 8.3603908488020d-01,
     |   7.7067331227607d-01, 6.2727525346930d-01, 4.2146820256343d-01,
     |   1.7484533443365d-01,-8.7194311815557d-02,-3.3795870201069d-01,
     |  -5.5208352496344d-01,-7.0801043484744d-01,-7.9008672153626d-01,
     |  -7.9008672153626d-01,-7.0801043484744d-01,-5.5208352496344d-01,
     |  -3.3795870201069d-01,-8.7194311815557d-02, 1.7484533443365d-01,
     |   4.2146820256343d-01, 6.2727525346930d-01, 7.7067331227607d-01,
     |   8.3603908488020d-01, 8.1532535840106d-01, 7.0895222934223d-01,
     |   5.2589297507696d-01, 2.8293971289019d-01, 3.2112391331341d-03,
     |  -2.8596280383979d-01,-5.5558774148778d-01,-7.7774423555171d-01,
     |  -9.2826781089387d-01,-9.8911588099122d-01,-9.5019780066474d-01,
     |  -8.1049168167387d-01,-5.7833654282677d-01,-2.7086388758783d-01,
     |   8.7387941355584d-02, 4.6655760473362d-01, 8.3405868869891d-01,
     |   1.1574591256739d+00, 1.4073822254011d+00, 1.5601658587903d+00,
     |   1.6000369101690d+00, 1.5206010077556d+00, 1.3255088786214d+00,
     |   1.0282348704475d+00, 6.5098346403658d-01, 2.2281862505971d-01/
      data (pmn(lat, 2, 7), lat = 1,72)/
     |   8.9407891287086d-03, 7.9096296384942d-02, 2.1224054979710d-01,
     |   3.9471807739000d-01, 6.0767757786592d-01, 8.2885906515356d-01,
     |   1.0347085530458d+00, 1.2026228849318d+00, 1.3131149763586d+00,
     |   1.3516968881424d+00, 1.3103041304103d+00, 1.1881270120076d+00,
     |   9.9176976930466d-01, 7.3472054657102d-01, 4.3617927970628d-01,
     |   1.1935022416551d-01,-1.9064427102649d-01,-4.6903673788661d-01,
     |  -6.9366465437019d-01,-8.4698968866793d-01,-9.1769921416115d-01,
     |  -9.0174151408450d-01,-8.0269821400961d-01,-6.3145857746500d-01,
     |  -4.0522472849555d-01,-1.4593866652597d-01, 1.2172460472841d-01,
     |   3.7261335039714d-01, 5.8339714937505d-01, 7.3469509962643d-01,
     |   8.1283813441042d-01, 8.1110307581533d-01, 7.3030473724678d-01,
     |   5.7869158803766d-01, 3.7115474458338d-01, 1.2782341870776d-01,
     |  -1.2782341870776d-01,-3.7115474458338d-01,-5.7869158803766d-01,
     |  -7.3030473724678d-01,-8.1110307581533d-01,-8.1283813441042d-01,
     |  -7.3469509962643d-01,-5.8339714937505d-01,-3.7261335039714d-01,
     |  -1.2172460472841d-01, 1.4593866652597d-01, 4.0522472849554d-01,
     |   6.3145857746500d-01, 8.0269821400961d-01, 9.0174151408450d-01,
     |   9.1769921416116d-01, 8.4698968866793d-01, 6.9366465437019d-01,
     |   4.6903673788661d-01, 1.9064427102650d-01,-1.1935022416551d-01,
     |  -4.3617927970628d-01,-7.3472054657102d-01,-9.9176976930466d-01,
     |  -1.1881270120076d+00,-1.3103041304103d+00,-1.3516968881424d+00,
     |  -1.3131149763586d+00,-1.2026228849318d+00,-1.0347085530458d+00,
     |  -8.2885906515356d-01,-6.0767757786592d-01,-3.9471807739000d-01,
     |  -2.1224054979710d-01,-7.9096296384942d-02,-8.9407891287086d-03/
      data (pmn(lat, 3, 7), lat = 1,72)/
     |   2.3001466190586d-04, 6.1338933098151d-03, 2.7699663587210d-02,
     |   7.3204913264228d-02, 1.4791489156627d-01, 2.5332067803050d-01,
     |   3.8676847219353d-01, 5.4152303827382d-01, 7.0726594692059d-01,
     |   8.7098653105369d-01, 1.0181844833338d+00, 1.1342714986557d+00,
     |   1.2060383463839d+00, 1.2230453072262d+00, 1.1787989187925d+00,
     |   1.0715960714749d+00, 9.0494608106695d-01, 6.8751974942348d-01,
     |   4.3261808283811d-01, 1.5719822891086d-01,-1.1946386439964d-01,
     |  -3.7735950175034d-01,-5.9744257631803d-01,-7.6328248762472d-01,
     |  -8.6252450116379d-01,-8.8802277362974d-01,-8.3853913085000d-01,
     |  -7.1893858564680d-01,-5.3985712081027d-01,-3.1686441209635d-01,
     |  -6.9189642706510d-02, 1.8188178694921d-01, 4.1480265780293d-01,
     |   6.0959349490116d-01, 7.4954732490816d-01, 8.2265996924086d-01,
     |   8.2265996924086d-01, 7.4954732490816d-01, 6.0959349490116d-01,
     |   4.1480265780293d-01, 1.8188178694921d-01,-6.9189642706510d-02,
     |  -3.1686441209635d-01,-5.3985712081026d-01,-7.1893858564680d-01,
     |  -8.3853913085000d-01,-8.8802277362974d-01,-8.6252450116379d-01,
     |  -7.6328248762473d-01,-5.9744257631803d-01,-3.7735950175034d-01,
     |  -1.1946386439964d-01, 1.5719822891085d-01, 4.3261808283811d-01,
     |   6.8751974942348d-01, 9.0494608106695d-01, 1.0715960714749d+00,
     |   1.1787989187925d+00, 1.2230453072262d+00, 1.2060383463839d+00,
     |   1.1342714986557d+00, 1.0181844833338d+00, 8.7098653105369d-01,
     |   7.0726594692059d-01, 5.4152303827382d-01, 3.8676847219353d-01,
     |   2.5332067803050d-01, 1.4791489156627d-01, 7.3204913264228d-02,
     |   2.7699663587210d-02, 6.1338933098151d-03, 2.3001466190586d-04/
      data (pmn(lat, 4, 7), lat = 1,72)/
     |   4.1623752527938d-06, 3.3399742262589d-04, 2.5290193128437d-03,
     |   9.4435554204429d-03, 2.4841654489652d-02, 5.2839612249092d-02,
     |   9.7261641213282d-02, 1.6098061541619d-01, 2.4531915005083d-01,
     |   3.4958196836395d-01, 4.7077890259041d-01, 6.0358002118822d-01,
     |   7.4052193428690d-01, 8.7245942592432d-01, 9.8923157918575d-01,
     |   1.0804889192661d+00, 1.1366100276987d+00, 1.1496244014284d+00,
     |   1.1140542850583d+00, 1.0275923319721d+00, 8.9154402754429d-01,
     |   7.1098286463094d-01, 4.9459066216812d-01, 2.5418300632342d-01,
     |   3.9480894443422d-03,-2.4054635474963d-01,-4.6350121246470d-01,
     |  -6.5009672387475d-01,-7.8766546229377d-01,-8.6672815834571d-01,
     |  -8.8180266466118d-01,-8.3191406616117d-01,-7.2075818194415d-01,
     |  -5.5649939637992d-01,-3.5121440494401d-01,-1.2002338003826d-01,
     |   1.2002338003825d-01, 3.5121440494401d-01, 5.5649939637992d-01,
     |   7.2075818194415d-01, 8.3191406616117d-01, 8.8180266466118d-01,
     |   8.6672815834571d-01, 7.8766546229377d-01, 6.5009672387475d-01,
     |   4.6350121246470d-01, 2.4054635474963d-01,-3.9480894443408d-03,
     |  -2.5418300632342d-01,-4.9459066216812d-01,-7.1098286463094d-01,
     |  -8.9154402754429d-01,-1.0275923319721d+00,-1.1140542850583d+00,
     |  -1.1496244014284d+00,-1.1366100276987d+00,-1.0804889192661d+00,
     |  -9.8923157918575d-01,-8.7245942592432d-01,-7.4052193428690d-01,
     |  -6.0358002118822d-01,-4.7077890259041d-01,-3.4958196836395d-01,
     |  -2.4531915005083d-01,-1.6098061541619d-01,-9.7261641213282d-02,
     |  -5.2839612249093d-02,-2.4841654489652d-02,-9.4435554204429d-03,
     |  -2.5290193128437d-03,-3.3399742262589d-04,-4.1623752527938d-06/
      data (pmn(lat, 5, 7), lat = 1,72)/
     |   5.4499632984216d-08, 1.3147050091593d-05, 1.6661702283458d-04,
     |   8.7660966129779d-04, 2.9905088102876d-03, 7.8603495266184d-03,
     |   1.7330797661708d-02, 3.3635223023372d-02, 5.9204272785838d-02,
     |   9.6402104297291d-02, 1.4721493666261d-01, 2.1292381204102d-01,
     |   2.9379761298685d-01, 3.8884294414881d-01, 4.9564428252742d-01,
     |   6.1032102389202d-01, 7.2761825086899d-01, 8.4113607426249d-01,
     |   9.4368933724755d-01, 1.0277765372533d+00, 1.0861252462136d+00,
     |   1.1122722326734d+00, 1.1011308397769d+00, 1.0494965863362d+00,
     |   9.5644470900351d-01, 8.2358033568248d-01, 6.5511267026592d-01,
     |   4.5773812588348d-01, 2.4033264239612d-01, 1.3469161227276d-02,
     |  -2.1120895762499d-01,-4.2171520964537d-01,-6.0649531869220d-01,
     |  -7.5519309386895d-01,-8.5934882416582d-01,-9.1297670863096d-01,
     |  -9.1297670863096d-01,-8.5934882416582d-01,-7.5519309386895d-01,
     |  -6.0649531869220d-01,-4.2171520964537d-01,-2.1120895762499d-01,
     |   1.3469161227275d-02, 2.4033264239612d-01, 4.5773812588348d-01,
     |   6.5511267026592d-01, 8.2358033568248d-01, 9.5644470900351d-01,
     |   1.0494965863362d+00, 1.1011308397769d+00, 1.1122722326734d+00,
     |   1.0861252462136d+00, 1.0277765372533d+00, 9.4368933724755d-01,
     |   8.4113607426249d-01, 7.2761825086899d-01, 6.1032102389202d-01,
     |   4.9564428252742d-01, 3.8884294414881d-01, 2.9379761298685d-01,
     |   2.1292381204102d-01, 1.4721493666261d-01, 9.6402104297291d-02,
     |   5.9204272785838d-02, 3.3635223023372d-02, 1.7330797661708d-02,
     |   7.8603495266185d-03, 2.9905088102876d-03, 8.7660966129779d-04,
     |   1.6661702283458d-04, 1.3147050091593d-05, 5.4499632984216d-08/
      data (pmn(lat, 6, 7), lat = 1,72)/
     |   5.0532702882750d-10, 3.6628457610350d-07, 7.7614677152186d-06,
     |   5.7444710890140d-05, 2.5359846020068d-04, 8.2139291012352d-04,
     |   2.1617653879421d-03, 4.8985938908329d-03, 9.9078751491138d-03,
     |   1.8319731596719d-02, 3.1486482707661d-02, 5.0913411023286d-02,
     |   7.8152909764594d-02, 1.1466701642240d-01, 1.6166747392122d-01,
     |   2.1994597895740d-01, 2.8970978259093d-01, 3.7043899298059d-01,
     |   4.6078160348217d-01, 5.5850037922956d-01, 6.6048237745456d-01,
     |   7.6281728940709d-01, 8.6094533708274d-01, 9.4986959185964d-01,
     |   1.0244218141741d+00, 1.0795657614047d+00, 1.1107178542987d+00,
     |   1.1140625265796d+00, 1.0868387832292d+00, 1.0275755879979d+00,
     |   9.3625665561235d-01, 8.1439984271317d-01, 6.6504227030689d-01,
     |   4.9262910667337d-01, 3.0281104995337d-01, 1.0216239658339d-01,
     |  -1.0216239658339d-01,-3.0281104995337d-01,-4.9262910667337d-01,
     |  -6.6504227030689d-01,-8.1439984271317d-01,-9.3625665561235d-01,
     |  -1.0275755879979d+00,-1.0868387832292d+00,-1.1140625265796d+00,
     |  -1.1107178542987d+00,-1.0795657614047d+00,-1.0244218141741d+00,
     |  -9.4986959185965d-01,-8.6094533708274d-01,-7.6281728940709d-01,
     |  -6.6048237745456d-01,-5.5850037922956d-01,-4.6078160348217d-01,
     |  -3.7043899298059d-01,-2.8970978259093d-01,-2.1994597895741d-01,
     |  -1.6166747392122d-01,-1.1466701642240d-01,-7.8152909764594d-02,
     |  -5.0913411023286d-02,-3.1486482707661d-02,-1.8319731596719d-02,
     |  -9.9078751491139d-03,-4.8985938908329d-03,-2.1617653879421d-03,
     |  -8.2139291012352d-04,-2.5359846020068d-04,-5.7444710890140d-05,
     |  -7.7614677152186d-06,-3.6628457610350d-07,-5.0532702882750d-10/
      data (pmn(lat, 7, 7), lat = 1,72)/
     |   2.9468959484535d-12, 6.4162901655554d-09, 2.2717712279738d-07,
     |   2.3630134293620d-06, 1.3481691365079d-05, 5.3717790168887d-05,
     |   1.6840054682548d-04, 4.4441497090653d-04, 1.0297473886745d-03,
     |   2.1543594168087d-03, 4.1498761976399d-03, 7.4651553820386d-03,
     |   1.2674690633921d-02, 2.0477035422382d-02, 3.1681012987685d-02,
     |   4.7178373819386d-02, 6.7902705717813d-02, 9.4775697594070d-02,
     |   1.2864319011776d-01, 1.7020468765156d-01, 2.1994103189480d-01,
     |   2.7804563728035d-01, 3.4436497509703d-01, 4.1835381484050d-01,
     |   4.9905007442749d-01, 5.8507302489071d-01, 6.7464711026916d-01,
     |   7.6565188587972d-01, 8.5569668189473d-01, 9.4221671463974d-01,
     |   1.0225856496092d+00, 1.0942382127571d+00, 1.1547954728605d+00,
     |   1.2021849672502d+00, 1.2347479641635d+00, 1.2513268495393d+00,
     |   1.2513268495393d+00, 1.2347479641635d+00, 1.2021849672502d+00,
     |   1.1547954728605d+00, 1.0942382127571d+00, 1.0225856496092d+00,
     |   9.4221671463974d-01, 8.5569668189473d-01, 7.6565188587972d-01,
     |   6.7464711026916d-01, 5.8507302489071d-01, 4.9905007442749d-01,
     |   4.1835381484050d-01, 3.4436497509703d-01, 2.7804563728035d-01,
     |   2.1994103189480d-01, 1.7020468765156d-01, 1.2864319011776d-01,
     |   9.4775697594070d-02, 6.7902705717813d-02, 4.7178373819386d-02,
     |   3.1681012987685d-02, 2.0477035422382d-02, 1.2674690633921d-02,
     |   7.4651553820386d-03, 4.1498761976399d-03, 2.1543594168087d-03,
     |   1.0297473886745d-03, 4.4441497090653d-04, 1.6840054682548d-04,
     |   5.3717790168888d-05, 1.3481691365079d-05, 2.3630134293620d-06,
     |   2.2717712279738d-07, 6.4162901655554d-09, 2.9468959484535d-12/
      data (pmn(lat, 0, 8), lat = 1,72)/
     |   2.8905509549660d+00, 2.6949317709927d+00, 2.3233905532828d+00,
     |   1.8131372372949d+00, 1.2147779599473d+00, 5.8674086022237d-01,
     |  -1.1114521585875d-02,-5.2397177917262d-01,-9.0787830380507d-01,
     |  -1.1342551961052d+00,-1.1925968647663d+00,-1.0910755614485d+00,
     |  -8.5501274849893d-01,-5.2342834840633d-01,-1.4410108105517d-01,
     |   2.3225789033057d-01, 5.5801959572477d-01, 7.9412930225736d-01,
     |   9.1443718436897d-01, 9.0837621795315d-01, 7.8170032932847d-01,
     |   5.5523235823666d-01, 2.6181136091691d-01,-5.8156706473090d-02,
     |  -3.6197746800810d-01,-6.1011532229722d-01,-7.7113702985772d-01,
     |  -8.2554944280159d-01,-7.6807202350928d-01,-6.0808261891248d-01,
     |  -3.6820321089403d-01,-8.1222975486999d-02, 2.1423928510906d-01,
     |   4.7877739095494d-01, 6.7730439901654d-01, 7.8357852491901d-01,
     |   7.8357852491901d-01, 6.7730439901654d-01, 4.7877739095494d-01,
     |   2.1423928510906d-01,-8.1222975486998d-02,-3.6820321089403d-01,
     |  -6.0808261891248d-01,-7.6807202350928d-01,-8.2554944280159d-01,
     |  -7.7113702985772d-01,-6.1011532229722d-01,-3.6197746800810d-01,
     |  -5.8156706473091d-02, 2.6181136091691d-01, 5.5523235823666d-01,
     |   7.8170032932847d-01, 9.0837621795315d-01, 9.1443718436897d-01,
     |   7.9412930225736d-01, 5.5801959572477d-01, 2.3225789033057d-01,
     |  -1.4410108105517d-01,-5.2342834840633d-01,-8.5501274849893d-01,
     |  -1.0910755614485d+00,-1.1925968647663d+00,-1.1342551961052d+00,
     |  -9.0787830380508d-01,-5.2397177917262d-01,-1.1114521585875d-02,
     |   5.8674086022237d-01, 1.2147779599473d+00, 1.8131372372949d+00,
     |   2.3233905532828d+00, 2.6949317709927d+00, 2.8905509549660d+00/
      data (pmn(lat, 1, 8), lat = 1,72)/
     |   2.6871295971243d-01, 7.7903508091522d-01, 1.2110538610017d+00,
     |   1.5222465549281d+00, 1.6834347809741d+00, 1.6819149511343d+00,
     |   1.5226963961538d+00, 1.2277142267270d+00, 8.3312120592502d-01,
     |   3.8498701348957d-01,-6.6082271038578d-02,-4.7076859852501d-01,
     |  -7.8662716231901d-01,-9.8278306949207d-01,-1.0432006364971d+00,
     |  -9.6816011089812d-01,-7.7379238249517d-01,-4.8975415918628d-01,
     |  -1.5534634758380d-01, 1.8543928424037d-01, 4.8933728694418d-01,
     |   7.1903278472200d-01, 8.4756646157253d-01, 8.6139952383691d-01,
     |   7.6178544304443d-01, 5.6430420826794d-01, 2.9663960112320d-01,
     |  -5.1066626302958d-03,-3.0109401246014d-01,-5.5282779370455d-01,
     |  -7.2801705032647d-01,-8.0460512494850d-01,-7.7347871146948d-01,
     |  -6.3952697258371d-01,-4.2092797084287d-01,-1.4675968487403d-01,
     |   1.4675968487402d-01, 4.2092797084287d-01, 6.3952697258371d-01,
     |   7.7347871146948d-01, 8.0460512494850d-01, 7.2801705032647d-01,
     |   5.5282779370455d-01, 3.0109401246014d-01, 5.1066626302968d-03,
     |  -2.9663960112320d-01,-5.6430420826794d-01,-7.6178544304443d-01,
     |  -8.6139952383691d-01,-8.4756646157253d-01,-7.1903278472200d-01,
     |  -4.8933728694419d-01,-1.8543928424037d-01, 1.5534634758380d-01,
     |   4.8975415918628d-01, 7.7379238249517d-01, 9.6816011089812d-01,
     |   1.0432006364971d+00, 9.8278306949207d-01, 7.8662716231901d-01,
     |   4.7076859852501d-01, 6.6082271038578d-02,-3.8498701348956d-01,
     |  -8.3312120592502d-01,-1.2277142267270d+00,-1.5226963961538d+00,
     |  -1.6819149511343d+00,-1.6834347809741d+00,-1.5222465549281d+00,
     |  -1.2110538610017d+00,-7.7903508091522d-01,-2.6871295971243d-01/
      data (pmn(lat, 2, 8), lat = 1,72)/
     |   1.2280138751142d-02, 1.0808483769554d-01, 2.8703237530357d-01,
     |   5.2535194534456d-01, 7.9108159901711d-01, 1.0479975868818d+00,
     |   1.2600792251677d+00, 1.3959680846899d+00, 1.4328804693686d+00,
     |   1.3594976713370d+00, 1.1774814705800d+00, 9.0142796479835d-01,
     |   5.5726109945970d-01, 1.7925551089009d-01,-1.9395620985901d-01,
     |  -5.2391394431487d-01,-7.7685502933011d-01,-9.2769082652558d-01,
     |  -9.6295748624150d-01,-8.8238660790284d-01,-6.9890728270976d-01,
     |  -4.3707950310701d-01,-1.3014742214754d-01, 1.8393326977545d-01,
     |   4.6701648867287d-01, 6.8529248165147d-01, 8.1327702500290d-01,
     |   8.3678523456467d-01, 7.5453490608520d-01, 5.7818979655921d-01,
     |   3.3084149855736d-01, 4.4116841839631d-02,-2.4573662785423d-01,
     |  -5.0231156427848d-01,-6.9350708427065d-01,-7.9545916705858d-01,
     |  -7.9545916705858d-01,-6.9350708427065d-01,-5.0231156427848d-01,
     |  -2.4573662785423d-01, 4.4116841839630d-02, 3.3084149855736d-01,
     |   5.7818979655921d-01, 7.5453490608520d-01, 8.3678523456467d-01,
     |   8.1327702500290d-01, 6.8529248165147d-01, 4.6701648867288d-01,
     |   1.8393326977545d-01,-1.3014742214754d-01,-4.3707950310701d-01,
     |  -6.9890728270976d-01,-8.8238660790284d-01,-9.6295748624150d-01,
     |  -9.2769082652558d-01,-7.7685502933011d-01,-5.2391394431487d-01,
     |  -1.9395620985901d-01, 1.7925551089009d-01, 5.5726109945970d-01,
     |   9.0142796479835d-01, 1.1774814705800d+00, 1.3594976713370d+00,
     |   1.4328804693686d+00, 1.3959680846899d+00, 1.2600792251677d+00,
     |   1.0479975868818d+00, 7.9108159901711d-01, 5.2535194534456d-01,
     |   2.8703237530357d-01, 1.0808483769554d-01, 1.2280138751142d-02/
      data (pmn(lat, 3, 8), lat = 1,72)/
     |   3.6302698395289d-04, 9.6440591682368d-03, 4.3216448160483d-02,
     |   1.1287947084718d-01, 2.2445944749699d-01, 3.7657878401389d-01,
     |   5.6040500920248d-01, 7.6043009457900d-01, 9.5619832991164d-01,
     |   1.1247782250779d+00, 1.2436756611370d+00, 1.2938242056460d+00,
     |   1.2622720369896d+00, 1.1442157150600d+00, 9.4410572275615d-01,
     |   6.7565850690012d-01, 3.6074152585406d-01, 2.7235636647167d-02,
     |  -2.9389376158155d-01,-5.7198468038280d-01,-7.8013159840245d-01,
     |  -8.9829458307638d-01,-9.1568950327445d-01,-8.3216392585368d-01,
     |  -6.5837923777596d-01,-4.1475829624641d-01,-1.2930307453173d-01,
     |   1.6547894795201d-01, 4.3619360438352d-01, 6.5231067730598d-01,
     |   7.8961385034610d-01, 8.3294916353838d-01, 7.7795019419011d-01,
     |   6.3153545438336d-01, 4.1111532011929d-01, 1.4259554640527d-01,
     |  -1.4259554640527d-01,-4.1111532011929d-01,-6.3153545438336d-01,
     |  -7.7795019419011d-01,-8.3294916353837d-01,-7.8961385034610d-01,
     |  -6.5231067730598d-01,-4.3619360438352d-01,-1.6547894795201d-01,
     |   1.2930307453173d-01, 4.1475829624640d-01, 6.5837923777596d-01,
     |   8.3216392585368d-01, 9.1568950327445d-01, 8.9829458307638d-01,
     |   7.8013159840245d-01, 5.7198468038280d-01, 2.9389376158155d-01,
     |  -2.7235636647166d-02,-3.6074152585406d-01,-6.7565850690012d-01,
     |  -9.4410572275615d-01,-1.1442157150600d+00,-1.2622720369896d+00,
     |  -1.2938242056460d+00,-1.2436756611370d+00,-1.1247782250779d+00,
     |  -9.5619832991164d-01,-7.6043009457900d-01,-5.6040500920248d-01,
     |  -3.7657878401389d-01,-2.2445944749699d-01,-1.1287947084718d-01,
     |  -4.3216448160483d-02,-9.6440591682368d-03,-3.6302698395289d-04/
      data (pmn(lat, 4, 8), lat = 1,72)/
     |   7.6721181717407d-06, 6.1374946191488d-04, 4.6188408309660d-03,
     |   1.7087448904496d-02, 4.4387716954051d-02, 9.2916765568573d-02,
     |   1.6770571617777d-01, 2.7111278412213d-01, 4.0180699433557d-01,
     |   5.5421184716694d-01, 7.1852153576178d-01, 8.8132902586166d-01,
     |   1.0268245874751d+00, 1.1384454249292d+00, 1.2007919086077d+00,
     |   1.2015821505775d+00, 1.1334003463305d+00, 9.9500817801536d-01,
     |   7.9203170081948d-01, 5.3690394551822d-01, 2.4802827886756d-01,
     |  -5.1780543613731d-02,-3.3743268443150d-01,-5.8405850754278d-01,
     |  -7.6959473719751d-01,-8.7717384406172d-01,-8.9704259616296d-01,
     |  -8.2778149920873d-01,-6.7667007910394d-01,-4.5913556191986d-01,
     |  -1.9732402955378d-01, 8.2068055286635d-02, 3.5047939563118d-01,
     |   5.8040331227867d-01, 7.4822858744789d-01, 8.3669472839290d-01,
     |   8.3669472839290d-01, 7.4822858744789d-01, 5.8040331227867d-01,
     |   3.5047939563118d-01, 8.2068055286636d-02,-1.9732402955378d-01,
     |  -4.5913556191986d-01,-6.7667007910394d-01,-8.2778149920873d-01,
     |  -8.9704259616296d-01,-8.7717384406172d-01,-7.6959473719751d-01,
     |  -5.8405850754278d-01,-3.3743268443150d-01,-5.1780543613731d-02,
     |   2.4802827886755d-01, 5.3690394551822d-01, 7.9203170081948d-01,
     |   9.9500817801536d-01, 1.1334003463305d+00, 1.2015821505775d+00,
     |   1.2007919086077d+00, 1.1384454249292d+00, 1.0268245874751d+00,
     |   8.8132902586166d-01, 7.1852153576178d-01, 5.5421184716694d-01,
     |   4.0180699433557d-01, 2.7111278412213d-01, 1.6770571617777d-01,
     |   9.2916765568574d-02, 4.4387716954051d-02, 1.7087448904496d-02,
     |   4.6188408309660d-03, 6.1374946191488d-04, 7.6721181717407d-06/
      data (pmn(lat, 5, 8), lat = 1,72)/
     |   1.2073845933708d-07, 2.9052008943630d-05, 3.6631132356513d-04,
     |   1.9124515308717d-03, 6.4569287191322d-03, 1.6750437181071d-02,
     |   3.6346652038633d-02, 6.9214641213321d-02, 1.1916060736456d-01,
     |   1.8913102350856d-01, 2.8049387214422d-01, 3.9240688387730d-01,
     |   5.2137925009251d-01, 6.6111596887878d-01, 8.0270342401020d-01,
     |   9.3515441104599d-01, 1.0462854049972d+00, 1.1238540057960d+00,
     |   1.1568459169443d+00, 1.1367736361787d+00, 1.0588371526051d+00,
     |   9.2280249105378d-01, 7.3347700491293d-01, 5.0069886057262d-01,
     |   2.3880822485930d-01,-3.4376186219592d-02,-2.9899563735020d-01,
     |  -5.3487623414051d-01,-7.2337474272999d-01,-8.4916047644081d-01,
     |  -9.0174860244658d-01,-8.7662068640573d-01,-7.7580713153331d-01,
     |  -6.0785941657878d-01,-3.8720204238902d-01,-1.3291814875965d-01,
     |   1.3291814875965d-01, 3.8720204238902d-01, 6.0785941657878d-01,
     |   7.7580713153331d-01, 8.7662068640573d-01, 9.0174860244658d-01,
     |   8.4916047644081d-01, 7.2337474273000d-01, 5.3487623414051d-01,
     |   2.9899563735020d-01, 3.4376186219594d-02,-2.3880822485930d-01,
     |  -5.0069886057262d-01,-7.3347700491293d-01,-9.2280249105378d-01,
     |  -1.0588371526051d+00,-1.1367736361787d+00,-1.1568459169443d+00,
     |  -1.1238540057960d+00,-1.0462854049972d+00,-9.3515441104599d-01,
     |  -8.0270342401020d-01,-6.6111596887878d-01,-5.2137925009251d-01,
     |  -3.9240688387730d-01,-2.8049387214422d-01,-1.8913102350856d-01,
     |  -1.1916060736456d-01,-6.9214641213321d-02,-3.6346652038633d-02,
     |  -1.6750437181071d-02,-6.4569287191322d-03,-1.9124515308717d-03,
     |  -3.6631132356513d-04,-2.9052008943630d-05,-1.2073845933708d-07/
      data (pmn(lat, 6, 8), lat = 1,72)/
     |   1.4229257773268d-09, 1.0291586833197d-06, 2.1712532164749d-05,
     |   1.5964606592220d-04, 6.9858504279229d-04, 2.2376366145942d-03,
     |   5.8101416567371d-03, 1.2957699454014d-02, 2.5728308059779d-02,
     |   4.6576622349608d-02, 7.8157822708892d-02, 1.2302282293943d-01,
     |   1.8323935145868d-01, 2.5997845906047d-01, 3.5311700847891d-01,
     |   4.6091187784547d-01, 5.7979982827782d-01, 7.0436795822079d-01,
     |   8.2752402308607d-01, 9.4087514057809d-01, 1.0352997517526d+00,
     |   1.1016738596071d+00, 1.1316913750539d+00, 1.1187025376661d+00,
     |   1.0584860091469d+00, 9.4987073870232d-01, 7.9513347347776d-01,
     |   6.0011618196696d-01, 3.7403301175429d-01, 1.2896620652201d-01,
     |  -1.2091842825068d-01,-3.6037672725748d-01,-5.7422822784126d-01,
     |  -7.4853513859599d-01,-8.7171188683474d-01,-9.3546318478453d-01,
     |  -9.3546318478453d-01,-8.7171188683474d-01,-7.4853513859599d-01,
     |  -5.7422822784126d-01,-3.6037672725748d-01,-1.2091842825068d-01,
     |   1.2896620652201d-01, 3.7403301175429d-01, 6.0011618196696d-01,
     |   7.9513347347776d-01, 9.4987073870231d-01, 1.0584860091469d+00,
     |   1.1187025376661d+00, 1.1316913750539d+00, 1.1016738596071d+00,
     |   1.0352997517526d+00, 9.4087514057809d-01, 8.2752402308607d-01,
     |   7.0436795822079d-01, 5.7979982827782d-01, 4.6091187784547d-01,
     |   3.5311700847891d-01, 2.5997845906047d-01, 1.8323935145868d-01,
     |   1.2302282293943d-01, 7.8157822708892d-02, 4.6576622349608d-02,
     |   2.5728308059780d-02, 1.2957699454014d-02, 5.8101416567371d-03,
     |   2.2376366145943d-03, 6.9858504279229d-04, 1.5964606592220d-04,
     |   2.1712532164749d-05, 1.0291586833197d-06, 1.4229257773268d-09/
      data (pmn(lat, 7, 8), lat = 1,72)/
     |   1.2147471805753d-11, 2.6398399801383d-08, 9.3110799199917d-07,
     |   9.6295606962894d-06, 5.4518359700055d-05, 2.1513684631124d-04,
     |   6.6659452785170d-04, 1.7351262351130d-03, 3.9570791691912d-03,
     |   8.1303928198536d-03, 1.5345831532341d-02, 2.6985320024498d-02,
     |   4.4676914900330d-02, 7.0200131222796d-02, 1.0534115133733d-01,
     |   1.5170423591908d-01, 2.1049261190612d-01, 2.8227831853887d-01,
     |   3.6678506710337d-01, 4.6271036882379d-01, 5.6761250780669d-01,
     |   6.7788419942285d-01, 7.8882815433726d-01, 8.9484079526948d-01,
     |   9.8969988797335d-01, 1.0669409156804d+00, 1.1202968242004d+00,
     |   1.1441674495649d+00, 1.1340795144991d+00, 1.0870962738841d+00,
     |   1.0021380676381d+00, 8.8018114970599d-01, 7.2431172806885d-01,
     |   5.3962431440303d-01, 3.3296708743198d-01, 1.1255068759185d-01,
     |  -1.1255068759185d-01,-3.3296708743198d-01,-5.3962431440303d-01,
     |  -7.2431172806885d-01,-8.8018114970599d-01,-1.0021380676381d+00,
     |  -1.0870962738841d+00,-1.1340795144991d+00,-1.1441674495649d+00,
     |  -1.1202968242004d+00,-1.0669409156804d+00,-9.8969988797335d-01,
     |  -8.9484079526948d-01,-7.8882815433726d-01,-6.7788419942285d-01,
     |  -5.6761250780669d-01,-4.6271036882379d-01,-3.6678506710337d-01,
     |  -2.8227831853887d-01,-2.1049261190612d-01,-1.5170423591908d-01,
     |  -1.0534115133733d-01,-7.0200131222796d-02,-4.4676914900330d-02,
     |  -2.6985320024498d-02,-1.5345831532341d-02,-8.1303928198536d-03,
     |  -3.9570791691913d-03,-1.7351262351131d-03,-6.6659452785170d-04,
     |  -2.1513684631124d-04,-5.4518359700055d-05,-9.6295606962894d-06,
     |  -9.3110799199917d-07,-2.6398399801383d-08,-1.2147471805753d-11/
      data (pmn(lat, 8, 8), lat = 1,72)/
     |   6.6264694428594d-14, 4.3256063394095d-10, 2.5493227431132d-08,
     |   3.7053278712452d-07, 2.7110939983984d-06, 1.3160912843391d-05,
     |   4.8573646627577d-05, 1.4724899754367d-04, 3.8470598228924d-04,
     |   8.9436461525573d-04, 1.8919316572052d-03, 3.7011633821431d-03,
     |   6.7776543707249d-03, 1.1726557015551d-02, 1.9309831954320d-02,
     |   3.0438880420767d-02, 4.6149266568885d-02, 6.7555675838708d-02,
     |   9.5787169917356d-02, 1.3190501351791d-01, 1.7680763181130d-01,
     |   2.3112934841146d-01, 2.9514119038348d-01, 3.6866299785329d-01,
     |   4.5099617079229d-01, 5.4088553769363d-01, 6.3651705217699d-01,
     |   7.3555542888206d-01, 8.3522262932891d-01, 9.3241458811912d-01,
     |   1.0238500646080d+00, 1.1062423635354d+00, 1.1764822154135d+00,
     |   1.2318186103914d+00, 1.2700240158602d+00, 1.2895312466442d+00,
     |   1.2895312466442d+00, 1.2700240158602d+00, 1.2318186103914d+00,
     |   1.1764822154135d+00, 1.1062423635354d+00, 1.0238500646080d+00,
     |   9.3241458811912d-01, 8.3522262932891d-01, 7.3555542888206d-01,
     |   6.3651705217699d-01, 5.4088553769363d-01, 4.5099617079229d-01,
     |   3.6866299785329d-01, 2.9514119038348d-01, 2.3112934841146d-01,
     |   1.7680763181130d-01, 1.3190501351791d-01, 9.5787169917356d-02,
     |   6.7555675838708d-02, 4.6149266568885d-02, 3.0438880420767d-02,
     |   1.9309831954320d-02, 1.1726557015551d-02, 6.7776543707249d-03,
     |   3.7011633821431d-03, 1.8919316572052d-03, 8.9436461525573d-04,
     |   3.8470598228925d-04, 1.4724899754368d-04, 4.8573646627577d-05,
     |   1.3160912843391d-05, 2.7110939983984d-06, 3.7053278712452d-07,
     |   2.5493227431132d-08, 4.3256063394095d-10, 6.6264694428594d-14/
      data (pmn(lat, 0, 9), lat = 1,72)/
     |   3.0492866262255d+00, 2.7921656961578d+00, 2.3102499948196d+00,
     |   1.6637071632390d+00, 9.3222573682233d-01, 2.0406028911106d-01,
     |  -4.3598060442515d-01,-9.1788349923733d-01,-1.1955059879962d+00,
     |  -1.2521141983112d+00,-1.1016448694032d+00,-7.8558680992721d-01,
     |  -3.6601757334568d-01, 8.4113813960358d-02, 4.9198006919631d-01,
     |   7.9550360389987d-01, 9.5206091939376d-01, 9.4401927965094d-01,
     |   7.8035726985407d-01, 4.9422180044604d-01, 1.3688856105470d-01,
     |  -2.3087205762919d-01,-5.4864605931524d-01,-7.6590565227562d-01,
     |  -8.4975547724022d-01,-7.8973159835247d-01,-5.9896288023086d-01,
     |  -3.1157798500463d-01, 2.3173918072300d-02, 3.4911467837613d-01,
     |   6.1231720185541d-01, 7.6980971915470d-01, 7.9642882012113d-01,
     |   6.8874872224035d-01, 4.6548298880569d-01, 1.6431571463705d-01,
     |  -1.6431571463704d-01,-4.6548298880569d-01,-6.8874872224035d-01,
     |  -7.9642882012113d-01,-7.6980971915470d-01,-6.1231720185541d-01,
     |  -3.4911467837613d-01,-2.3173918072303d-02, 3.1157798500463d-01,
     |   5.9896288023086d-01, 7.8973159835247d-01, 8.4975547724022d-01,
     |   7.6590565227562d-01, 5.4864605931524d-01, 2.3087205762919d-01,
     |  -1.3688856105470d-01,-4.9422180044604d-01,-7.8035726985407d-01,
     |  -9.4401927965094d-01,-9.5206091939376d-01,-7.9550360389987d-01,
     |  -4.9198006919631d-01,-8.4113813960357d-02, 3.6601757334568d-01,
     |   7.8558680992721d-01, 1.1016448694032d+00, 1.2521141983112d+00,
     |   1.1955059879962d+00, 9.1788349923733d-01, 4.3598060442515d-01,
     |  -2.0406028911105d-01,-9.3222573682233d-01,-1.6637071632390d+00,
     |  -2.3102499948196d+00,-2.7921656961578d+00,-3.0492866262255d+00/
      data (pmn(lat, 1, 9), lat = 1,72)/
     |   3.1727080820232d-01, 9.1183580393358d-01, 1.3920225795427d+00,
     |   1.6992809163879d+00, 1.7989198811376d+00, 1.6846742333474d+00,
     |   1.3791874836380d+00, 9.3037085736248d-01, 4.0420211988637d-01,
     |  -1.2495351317215d-01,-5.8506315352495d-01,-9.1660985820798d-01,
     |  -1.0807586526151d+00,-1.0643382955703d+00,-8.8095774981393d-01,
     |  -5.6815889425127d-01,-1.8109847013840d-01, 2.1623628298288d-01,
     |   5.6091864097258d-01, 8.0057364848154d-01, 9.0104526261069d-01,
     |   8.5111150336054d-01, 6.6358380313889d-01, 3.7268652041952d-01,
     |   2.8182082903990d-02,-3.1280042127365d-01,-5.9493472299898d-01,
     |  -7.7342837659404d-01,-8.2096289408953d-01,-7.3178245401858d-01,
     |  -5.2232386526006d-01,-2.2832426219349d-01, 1.0110705926795d-01,
     |   4.1149518713963d-01, 6.5180736330867d-01, 7.8266545932797d-01,
     |   7.8266545932797d-01, 6.5180736330867d-01, 4.1149518713963d-01,
     |   1.0110705926795d-01,-2.2832426219348d-01,-5.2232386526006d-01,
     |  -7.3178245401858d-01,-8.2096289408953d-01,-7.7342837659404d-01,
     |  -5.9493472299898d-01,-3.1280042127365d-01, 2.8182082903988d-02,
     |   3.7268652041952d-01, 6.6358380313889d-01, 8.5111150336054d-01,
     |   9.0104526261069d-01, 8.0057364848154d-01, 5.6091864097258d-01,
     |   2.1623628298288d-01,-1.8109847013840d-01,-5.6815889425127d-01,
     |  -8.8095774981393d-01,-1.0643382955703d+00,-1.0807586526151d+00,
     |  -9.1660985820798d-01,-5.8506315352495d-01,-1.2495351317216d-01,
     |   4.0420211988637d-01, 9.3037085736247d-01, 1.3791874836380d+00,
     |   1.6846742333474d+00, 1.7989198811376d+00, 1.6992809163879d+00,
     |   1.3920225795427d+00, 9.1183580393358d-01, 3.1727080820232d-01/
      data (pmn(lat, 2, 9), lat = 1,72)/
     |   1.6262699103655d-02, 1.4231599485723d-01, 3.7352542036139d-01,
     |   6.7131562760426d-01, 9.8538088425372d-01, 1.2614558514434d+00,
     |   1.4497255320577d+00, 1.5125925407235d+00, 1.4306166421519d+00,
     |   1.2057184192236d+00, 8.6115387929656d-01, 4.3825673094198d-01,
     |  -9.5644708688869d-03,-4.2467060081018d-01,-7.5369462418461d-01,
     |  -9.5541982905337d-01,-1.0068456474222d+00,-9.0652800686589d-01,
     |  -6.7469429600278d-01,-3.5012154051123d-01, 1.5743981853484d-02,
     |   3.6653106827504d-01, 6.4937724985585d-01, 8.2277593945602d-01,
     |   8.6265388203101d-01, 7.6576789210304d-01, 5.4991987744825d-01,
     |   2.5097440527232d-01,-8.2850415782765d-02,-3.9853427763829d-01,
     |  -6.4648583505334d-01,-7.8819124466216d-01,-8.0211050075275d-01,
     |  -6.8692332605134d-01,-4.6163455101361d-01,-1.6253144462635d-01,
     |   1.6253144462635d-01, 4.6163455101361d-01, 6.8692332605134d-01,
     |   8.0211050075275d-01, 7.8819124466216d-01, 6.4648583505334d-01,
     |   3.9853427763829d-01, 8.2850415782768d-02,-2.5097440527232d-01,
     |  -5.4991987744825d-01,-7.6576789210304d-01,-8.6265388203101d-01,
     |  -8.2277593945602d-01,-6.4937724985585d-01,-3.6653106827504d-01,
     |  -1.5743981853488d-02, 3.5012154051123d-01, 6.7469429600278d-01,
     |   9.0652800686589d-01, 1.0068456474222d+00, 9.5541982905338d-01,
     |   7.5369462418461d-01, 4.2467060081018d-01, 9.5644708688908d-03,
     |  -4.3825673094198d-01,-8.6115387929656d-01,-1.2057184192236d+00,
     |  -1.4306166421519d+00,-1.5125925407235d+00,-1.4497255320577d+00,
     |  -1.2614558514434d+00,-9.8538088425372d-01,-6.7131562760426d-01,
     |  -3.7352542036139d-01,-1.4231599485723d-01,-1.6262699103655d-02/
      data (pmn(lat, 3, 9), lat = 1,72)/
     |   5.4246733154013d-04, 1.4349125566770d-02, 6.3743167042262d-02,
     |   1.6429217882574d-01, 3.2078167499992d-01, 5.2557049364933d-01,
     |   7.5909346030056d-01, 9.9247280176182d-01, 1.1918566227471d+00,
     |   1.3238168735738d+00, 1.3609560417227d+00, 1.2868209471122d+00,
     |   1.0993127515554d+00, 8.1200190159616d-01, 4.5307240238977d-01,
     |   6.1983604915785d-02,-3.1570623681348d-01,-6.3461714187317d-01,
     |  -8.5600335945004d-01,-9.5342013945925d-01,-9.1673447795011d-01,
     |  -7.5384753941945d-01,-4.8983018830831d-01,-1.6355634602876d-01,
     |   1.7770586248605d-01, 4.8497483518977d-01, 7.1453970282975d-01,
     |   8.3422470637616d-01, 8.2800802349480d-01, 6.9830590276171d-01,
     |   4.6557396463342d-01, 1.6527250073113d-01,-1.5736725810740d-01,
     |  -4.5401196363607d-01,-6.8035139860776d-01,-8.0263143424462d-01,
     |  -8.0263143424462d-01,-6.8035139860776d-01,-4.5401196363607d-01,
     |  -1.5736725810740d-01, 1.6527250073113d-01, 4.6557396463342d-01,
     |   6.9830590276171d-01, 8.2800802349480d-01, 8.3422470637616d-01,
     |   7.1453970282975d-01, 4.8497483518977d-01, 1.7770586248605d-01,
     |  -1.6355634602876d-01,-4.8983018830831d-01,-7.5384753941945d-01,
     |  -9.1673447795011d-01,-9.5342013945925d-01,-8.5600335945004d-01,
     |  -6.3461714187317d-01,-3.1570623681348d-01, 6.1983604915783d-02,
     |   4.5307240238977d-01, 8.1200190159616d-01, 1.0993127515554d+00,
     |   1.2868209471122d+00, 1.3609560417227d+00, 1.3238168735738d+00,
     |   1.1918566227471d+00, 9.9247280176182d-01, 7.5909346030056d-01,
     |   5.2557049364933d-01, 3.2078167499992d-01, 1.6429217882574d-01,
     |   6.3743167042262d-02, 1.4349125566770d-02, 5.4246733154013d-04/
      data (pmn(lat, 4, 9), lat = 1,72)/
     |   1.3072787545859d-05, 1.0422003933959d-03, 7.7890690167664d-03,
     |   2.8514268089249d-02, 7.3021148026398d-02, 1.5008809190803d-01,
     |   2.6484368587923d-01, 4.1659234100870d-01, 5.9753737665302d-01,
     |   7.9270991273359d-01, 9.8121649155052d-01, 1.1386970301637d+00,
     |   1.2406730741433d+00, 1.2662990843937d+00, 1.2019349515671d+00,
     |   1.0439534471624d+00, 8.0028536590566d-01, 4.9037651693906d-01,
     |   1.4346014344009d-01,-2.0469816083136d-01,-5.1618689366864d-01,
     |  -7.5588278937795d-01,-8.9624315378436d-01,-9.2126097288869d-01,
     |  -8.2898494295760d-01,-6.3219555136061d-01,-3.5708269426160d-01,
     |  -4.0053727596566d-02, 2.7692798073610d-01, 5.5185514177323d-01,
     |   7.4828700593744d-01, 8.4027870094679d-01, 8.1593438206618d-01,
     |   6.7907430770408d-01, 4.4876611666298d-01, 1.5676878432217d-01,
     |  -1.5676878432217d-01,-4.4876611666298d-01,-6.7907430770408d-01,
     |  -8.1593438206618d-01,-8.4027870094679d-01,-7.4828700593744d-01,
     |  -5.5185514177323d-01,-2.7692798073611d-01, 4.0053727596565d-02,
     |   3.5708269426160d-01, 6.3219555136061d-01, 8.2898494295760d-01,
     |   9.2126097288869d-01, 8.9624315378436d-01, 7.5588278937795d-01,
     |   5.1618689366865d-01, 2.0469816083136d-01,-1.4346014344009d-01,
     |  -4.9037651693906d-01,-8.0028536590566d-01,-1.0439534471624d+00,
     |  -1.2019349515671d+00,-1.2662990843937d+00,-1.2406730741433d+00,
     |  -1.1386970301637d+00,-9.8121649155052d-01,-7.9270991273359d-01,
     |  -5.9753737665303d-01,-4.1659234100870d-01,-2.6484368587923d-01,
     |  -1.5008809190803d-01,-7.3021148026398d-02,-2.8514268089249d-02,
     |  -7.7890690167664d-03,-1.0422003933959d-03,-1.3072787545859d-05/
      data (pmn(lat, 5, 9), lat = 1,72)/
     |   2.3871347121914d-07, 5.7274939731464d-05, 7.1802686546275d-04,
     |   3.7162240111120d-03, 1.2400468849722d-02, 3.1692960725160d-02,
     |   6.7526623286719d-02, 1.2581564948544d-01, 2.1111631781619d-01,
     |   3.2521315847558d-01, 4.6590530019384d-01, 6.2626034938149d-01,
     |   7.9454737162011d-01, 9.5496344804359d-01, 1.0891439892229d+00,
     |   1.1783146807516d+00, 1.2058238925574d+00, 1.1597086595303d+00,
     |   1.0349105230434d+00, 8.3477813004187d-01, 5.7157140099841d-01,
     |   2.6580828444667d-01,-5.5547191802494d-02,-3.6188994592983d-01,
     |  -6.2245466798415d-01,-8.1004187026179d-01,-9.0450179426323d-01,
     |  -8.9549891476040d-01,-7.8415767350697d-01,-5.8332676925463d-01,
     |  -3.1637708432954d-01,-1.4643056323916d-02, 2.8619802768209d-01,
     |   5.5036583611643d-01, 7.4630197951294d-01, 8.5052641714771d-01,
     |   8.5052641714771d-01, 7.4630197951294d-01, 5.5036583611643d-01,
     |   2.8619802768209d-01,-1.4643056323915d-02,-3.1637708432954d-01,
     |  -5.8332676925463d-01,-7.8415767350697d-01,-8.9549891476040d-01,
     |  -9.0450179426323d-01,-8.1004187026179d-01,-6.2245466798415d-01,
     |  -3.6188994592984d-01,-5.5547191802494d-02, 2.6580828444667d-01,
     |   5.7157140099841d-01, 8.3477813004187d-01, 1.0349105230434d+00,
     |   1.1597086595303d+00, 1.2058238925574d+00, 1.1783146807516d+00,
     |   1.0891439892229d+00, 9.5496344804359d-01, 7.9454737162011d-01,
     |   6.2626034938149d-01, 4.6590530019384d-01, 3.2521315847558d-01,
     |   2.1111631781619d-01, 1.2581564948544d-01, 6.7526623286719d-02,
     |   3.1692960725160d-02, 1.2400468849722d-02, 3.7162240111120d-03,
     |   7.1802686546275d-04, 5.7274939731464d-05, 2.3871347121914d-07/
      data (pmn(lat, 6, 9), lat = 1,72)/
     |   3.3626888597507d-09, 2.4261750758799d-06, 5.0934658203056d-05,
     |   3.7173772295891d-04, 1.6105041156306d-03, 5.0939199158602d-03,
     |   1.3025131965110d-02, 2.8524254317737d-02, 5.5447015124349d-02,
     |   9.7953466015197d-02, 1.5984818703338d-01, 2.4376504733962d-01,
     |   3.5031389638609d-01, 4.7733483580572d-01, 6.1941145046303d-01,
     |   7.6777446813124d-01, 9.1068278374600d-01, 1.0343047839966d+00,
     |   1.1240481205755d+00, 1.1662114961391d+00, 1.1497693233247d+00,
     |   1.0680598629655d+00, 9.2013741108042d-01, 7.1157292806964d-01,
     |   4.5454396290713d-01, 1.6713769720883d-01,-1.2810989534436d-01,
     |  -4.0631355910969d-01,-6.4276061771680d-01,-8.1557204002482d-01,
     |  -9.0818723367398d-01,-9.1136498936990d-01,-8.2444143837637d-01,
     |  -6.5566957162746d-01,-4.2157353368362d-01,-1.4537065195377d-01,
     |   1.4537065195377d-01, 4.2157353368362d-01, 6.5566957162745d-01,
     |   8.2444143837637d-01, 9.1136498936990d-01, 9.0818723367398d-01,
     |   8.1557204002482d-01, 6.4276061771680d-01, 4.0631355910969d-01,
     |   1.2810989534436d-01,-1.6713769720883d-01,-4.5454396290713d-01,
     |  -7.1157292806964d-01,-9.2013741108042d-01,-1.0680598629655d+00,
     |  -1.1497693233247d+00,-1.1662114961391d+00,-1.1240481205755d+00,
     |  -1.0343047839966d+00,-9.1068278374600d-01,-7.6777446813124d-01,
     |  -6.1941145046303d-01,-4.7733483580572d-01,-3.5031389638609d-01,
     |  -2.4376504733962d-01,-1.5984818703338d-01,-9.7953466015198d-02,
     |  -5.5447015124349d-02,-2.8524254317737d-02,-1.3025131965110d-02,
     |  -5.0939199158603d-03,-1.6105041156306d-03,-3.7173772295891d-04,
     |  -5.0934658203056d-05,-2.4261750758799d-06,-3.3626888597507d-09/
      data (pmn(lat, 7, 9), lat = 1,72)/
     |   3.6313402782340d-11, 7.8745810661109d-08, 2.7655575617568d-06,
     |   2.8416863155151d-05, 1.5949194847378d-04, 6.2252386742140d-04,
     |   1.9034466283848d-03, 4.8776127265211d-03, 1.0923638599075d-02,
     |   2.1983179298616d-02, 4.0529088199394d-02, 6.9413134354437d-02,
     |   1.1158098429904d-01, 1.6966444138042d-01, 2.4548564708137d-01,
     |   3.3953098426164d-01, 4.5046955156128d-01, 5.7479864451496d-01,
     |   7.0669424680958d-01, 8.3812737761376d-01, 9.5927848050010d-01,
     |   1.0592449943845d+00, 1.1269964783727d+00, 1.1524927651375d+00,
     |   1.1278493362291d+00, 1.0484154976169d+00, 9.1362855915893d-01,
     |   7.2752258848102d-01, 4.9880252590188d-01, 2.4044024301464d-01,
     |  -3.1196785406301d-02,-2.9761779726947d-01,-5.3976541301978d-01,
     |  -7.3970194362504d-01,-8.8224994899493d-01,-9.5641150597381d-01,
     |  -9.5641150597381d-01,-8.8224994899493d-01,-7.3970194362504d-01,
     |  -5.3976541301978d-01,-2.9761779726947d-01,-3.1196785406300d-02,
     |   2.4044024301464d-01, 4.9880252590188d-01, 7.2752258848102d-01,
     |   9.1362855915892d-01, 1.0484154976169d+00, 1.1278493362291d+00,
     |   1.1524927651375d+00, 1.1269964783727d+00, 1.0592449943845d+00,
     |   9.5927848050010d-01, 8.3812737761376d-01, 7.0669424680958d-01,
     |   5.7479864451496d-01, 4.5046955156128d-01, 3.3953098426164d-01,
     |   2.4548564708137d-01, 1.6966444138042d-01, 1.1158098429904d-01,
     |   6.9413134354437d-02, 4.0529088199394d-02, 2.1983179298616d-02,
     |   1.0923638599075d-02, 4.8776127265212d-03, 1.9034466283848d-03,
     |   6.2252386742140d-04, 1.5949194847378d-04, 2.8416863155151d-05,
     |   2.7655575617568d-06, 7.8745810661109d-08, 3.6313402782340d-11/
      data (pmn(lat, 8, 9), lat = 1,72)/
     |   2.8877237017728d-13, 1.8814511155684d-09, 1.1046192814289d-07,
     |   1.5963174756220d-06, 1.1590317030823d-05, 5.5723067054956d-05,
     |   2.0326906784044d-04, 6.0778094841013d-04, 1.5628788697467d-03,
     |   3.5682914377777d-03, 7.3962753276002d-03, 1.4144230256677d-02,
     |   2.5256755842737d-02, 4.2500466950820d-02, 6.7878124687207d-02,
     |   1.0347507610908d-01, 1.5124008762199d-01, 2.1271333415173d-01,
     |   2.8872509071962d-01, 3.7909788132849d-01, 4.8239083233240d-01,
     |   5.9572641958722d-01, 7.1473589517425d-01, 8.3365034007423d-01,
     |   9.4555019970483d-01, 1.0427687412228d+00, 1.1174261306226d+00,
     |   1.1620531085429d+00, 1.1702489225611d+00, 1.1373093312279d+00,
     |   1.0607586154133d+00, 9.4072527323593d-01, 7.8011414204872d-01,
     |   5.8454684094799d-01, 3.6206559782668d-01, 1.2262008110520d-01,
     |  -1.2262008110520d-01,-3.6206559782668d-01,-5.8454684094799d-01,
     |  -7.8011414204872d-01,-9.4072527323593d-01,-1.0607586154133d+00,
     |  -1.1373093312279d+00,-1.1702489225611d+00,-1.1620531085429d+00,
     |  -1.1174261306226d+00,-1.0427687412228d+00,-9.4555019970483d-01,
     |  -8.3365034007424d-01,-7.1473589517425d-01,-5.9572641958722d-01,
     |  -4.8239083233240d-01,-3.7909788132849d-01,-2.8872509071962d-01,
     |  -2.1271333415173d-01,-1.5124008762199d-01,-1.0347507610908d-01,
     |  -6.7878124687207d-02,-4.2500466950820d-02,-2.5256755842737d-02,
     |  -1.4144230256677d-02,-7.3962753276002d-03,-3.5682914377777d-03,
     |  -1.5628788697468d-03,-6.0778094841013d-04,-2.0326906784044d-04,
     |  -5.5723067054957d-05,-1.1590317030823d-05,-1.5963174756220d-06,
     |  -1.1046192814289d-07,-1.8814511155684d-09,-2.8877237017728d-13/
      data (pmn(lat, 9, 9), lat = 1,72)/
     |   1.4851683178191d-15, 2.9066053509160d-11, 2.8514195607584d-09,
     |   5.7911281464213d-08, 5.4340152025627d-07, 3.2138822883805d-06,
     |   1.3964776814451d-05, 4.8628636410388d-05, 1.4325284598155d-04,
     |   3.7007277441150d-04, 8.5970969885522d-04, 1.8290001471831d-03,
     |   3.6124142505124d-03, 6.6934501911391d-03, 1.1730972255163d-02,
     |   1.9574490213805d-02, 3.1262132923046d-02, 4.7995749173188d-02,
     |   7.1089254729412d-02, 1.0188896887306d-01, 1.4166802343455d-01,
     |   1.9150061955960d-01, 2.5212548937958d-01, 3.2381088652959d-01,
     |   4.0623530367639d-01, 4.9839851776381d-01, 5.9857627561533d-01,
     |   7.0432893842789d-01, 8.1256990911427d-01, 9.1969408572488d-01,
     |   1.0217604987087d+00, 1.1147173814974d+00, 1.1946528920773d+00,
     |   1.2580511754289d+00, 1.3020319060616d+00, 1.3245521297797d+00,
     |   1.3245521297797d+00, 1.3020319060616d+00, 1.2580511754289d+00,
     |   1.1946528920773d+00, 1.1147173814974d+00, 1.0217604987087d+00,
     |   9.1969408572488d-01, 8.1256990911427d-01, 7.0432893842789d-01,
     |   5.9857627561533d-01, 4.9839851776381d-01, 4.0623530367640d-01,
     |   3.2381088652959d-01, 2.5212548937958d-01, 1.9150061955960d-01,
     |   1.4166802343455d-01, 1.0188896887306d-01, 7.1089254729412d-02,
     |   4.7995749173188d-02, 3.1262132923046d-02, 1.9574490213805d-02,
     |   1.1730972255163d-02, 6.6934501911391d-03, 3.6124142505124d-03,
     |   1.8290001471831d-03, 8.5970969885522d-04, 3.7007277441150d-04,
     |   1.4325284598155d-04, 4.8628636410388d-05, 1.3964776814451d-05,
     |   3.2138822883805d-06, 5.4340152025627d-07, 5.7911281464213d-08,
     |   2.8514195607584d-09, 2.9066053509160d-11, 1.4851683178191d-15/
      data (pmn(lat, 0,10), lat = 1,72)/
     |   3.1980947933547d+00, 2.8696808011820d+00, 2.2632186080462d+00,
     |   1.4709043823003d+00, 6.1120415271627d-01,-1.9098455946287d-01,
     |  -8.2496137889155d-01,-1.2120429270927d+00,-1.3175093939739d+00,
     |  -1.1546932670053d+00,-7.8065129757849d-01,-2.8437059159141d-01,
     |   2.3022142066896d-01, 6.6328348123763d-01, 9.3666029453034d-01,
     |   1.0069236695376d+00, 8.7162028860457d-01, 5.6778229824740d-01,
     |   1.6319847129166d-01,-2.5773236392844d-01,-6.1078101896809d-01,
     |  -8.2808788252793d-01,-8.7074868556412d-01,-7.3549498244289d-01,
     |  -4.5433931891197d-01,-8.7410197087276d-02, 2.8950661998782d-01,
     |   6.0021928440425d-01, 7.8317728331930d-01, 8.0340188903954d-01,
     |   6.5902573546342d-01, 3.8123602206861d-01, 2.7705532387479d-02,
     |  -3.2914191734348d-01,-6.1669164650212d-01,-7.7664886538974d-01,
     |  -7.7664886538974d-01,-6.1669164650213d-01,-3.2914191734348d-01,
     |   2.7705532387478d-02, 3.8123602206861d-01, 6.5902573546342d-01,
     |   8.0340188903954d-01, 7.8317728331930d-01, 6.0021928440425d-01,
     |   2.8950661998782d-01,-8.7410197087274d-02,-4.5433931891196d-01,
     |  -7.3549498244289d-01,-8.7074868556412d-01,-8.2808788252793d-01,
     |  -6.1078101896810d-01,-2.5773236392844d-01, 1.6319847129165d-01,
     |   5.6778229824740d-01, 8.7162028860457d-01, 1.0069236695376d+00,
     |   9.3666029453034d-01, 6.6328348123763d-01, 2.3022142066896d-01,
     |  -2.8437059159141d-01,-7.8065129757849d-01,-1.1546932670053d+00,
     |  -1.3175093939739d+00,-1.2120429270927d+00,-8.2496137889155d-01,
     |  -1.9098455946287d-01, 6.1120415271627d-01, 1.4709043823003d+00,
     |   2.2632186080462d+00, 2.8696808011820d+00, 3.1980947933547d+00/
      data (pmn(lat, 1,10), lat = 1,72)/
     |   3.6831571518573d-01, 1.0483065938646d+00, 1.5679868941160d+00,
     |   1.8508179899820d+00, 1.8601156555213d+00, 1.6047482049455d+00,
     |   1.1368508706426d+00, 5.4203449437176d-01,-7.6090678204111d-02,
     |  -6.1425131975931d-01,-9.8739874663265d-01,-1.1429604590436d+00,
     |  -1.0689674870765d+00,-7.9471477218204d-01,-3.8398878852891d-01,
     |   7.7749755381387d-02, 4.9975879601172d-01, 8.0290117013021d-01,
     |   9.3390591780311d-01, 8.7442719026345d-01, 6.4333435074973d-01,
     |   2.9195469900411d-01,-1.0668823633093d-01,-4.7248991282939d-01,
     |  -7.3389315868353d-01,-8.4154333030437d-01,-7.7740286637576d-01,
     |  -5.5765724638053d-01,-2.2894960307452d-01, 1.4123854148487d-01,
     |   4.7813112811482d-01, 7.1446316382328d-01, 8.0366682643719d-01,
     |   7.2889185996653d-01, 5.0613547434173d-01, 1.8090544129868d-01,
     |  -1.8090544129868d-01,-5.0613547434172d-01,-7.2889185996653d-01,
     |  -8.0366682643719d-01,-7.1446316382328d-01,-4.7813112811481d-01,
     |  -1.4123854148487d-01, 2.2894960307452d-01, 5.5765724638053d-01,
     |   7.7740286637576d-01, 8.4154333030437d-01, 7.3389315868353d-01,
     |   4.7248991282939d-01, 1.0668823633093d-01,-2.9195469900411d-01,
     |  -6.4333435074973d-01,-8.7442719026345d-01,-9.3390591780311d-01,
     |  -8.0290117013022d-01,-4.9975879601173d-01,-7.7749755381389d-02,
     |   3.8398878852891d-01, 7.9471477218204d-01, 1.0689674870765d+00,
     |   1.1429604590436d+00, 9.8739874663265d-01, 6.1425131975931d-01,
     |   7.6090678204115d-02,-5.4203449437175d-01,-1.1368508706426d+00,
     |  -1.6047482049455d+00,-1.8601156555213d+00,-1.8508179899820d+00,
     |  -1.5679868941160d+00,-1.0483065938646d+00,-3.6831571518573d-01/
      data (pmn(lat, 2,10), lat = 1,72)/
     |   2.0923110543922d-02, 1.8192976885970d-01, 4.7126554818125d-01,
     |   8.2974277183828d-01, 1.1828466099319d+00, 1.4548449490456d+00,
     |   1.5831892407043d+00, 1.5305149299196d+00, 1.2919964907112d+00,
     |   8.9667697990651d-01, 4.0251385700174d-01,-1.1394774525555d-01,
     |  -5.7136415029052d-01,-8.9829209150245d-01,-1.0460783690407d+00,
     |  -9.9756082213712d-01,-7.6998312222971d-01,-4.1160339668297d-01,
     |   7.3516741918937d-03, 4.0768857625201d-01, 7.1577828878910d-01,
     |   8.7691798906842d-01, 8.6505503758604d-01, 6.8709576220078d-01,
     |   3.8104115380635d-01, 8.3484264801091d-03,-3.5800546632486d-01,
     |  -6.4748630346303d-01,-8.0535247998069d-01,-8.0288402442001d-01,
     |  -6.4258356920583d-01,-3.5739964026012d-01,-4.1555521053970d-03,
     |   3.4753819184239d-01, 6.2875987520790d-01, 7.8456674262804d-01,
     |   7.8456674262804d-01, 6.2875987520790d-01, 3.4753819184239d-01,
     |  -4.1555521053961d-03,-3.5739964026012d-01,-6.4258356920583d-01,
     |  -8.0288402442001d-01,-8.0535247998069d-01,-6.4748630346303d-01,
     |  -3.5800546632486d-01, 8.3484264801072d-03, 3.8104115380634d-01,
     |   6.8709576220078d-01, 8.6505503758604d-01, 8.7691798906842d-01,
     |   7.1577828878910d-01, 4.0768857625201d-01, 7.3516741918956d-03,
     |  -4.1160339668296d-01,-7.6998312222971d-01,-9.9756082213712d-01,
     |  -1.0460783690407d+00,-8.9829209150245d-01,-5.7136415029053d-01,
     |  -1.1394774525555d-01, 4.0251385700174d-01, 8.9667697990650d-01,
     |   1.2919964907112d+00, 1.5305149299196d+00, 1.5831892407043d+00,
     |   1.4548449490456d+00, 1.1828466099319d+00, 8.2974277183828d-01,
     |   4.7126554818125d-01, 1.8192976885970d-01, 2.0923110543922d-02/
      data (pmn(lat, 3,10), lat = 1,72)/
     |   7.7673085310441d-04, 2.0447642243088d-02, 8.9956727154650d-02,
     |   2.2842005578958d-01, 4.3688761625357d-01, 6.9668391823852d-01,
     |   9.7197157466189d-01, 1.2161179841563d+00, 1.3806783189435d+00,
     |   1.4252642828151d+00, 1.3263548194913d+00, 1.0832667176419d+00,
     |   7.2001294184430d-01, 2.8254075976668d-01,-1.6828284022171d-01,
     |  -5.6675006258374d-01,-8.5365781045212d-01,-9.8684264337948d-01,
     |  -9.4893578863205d-01,-7.5084835069836d-01,-4.3026266440736d-01,
     |  -4.5317608990794d-02, 3.3543525899532d-01, 6.4502783013112d-01,
     |   8.2986805093277d-01, 8.5918898320772d-01, 7.3042502132212d-01,
     |   4.6951864770713d-01, 1.2608235260687d-01,-2.3571898294752d-01,
     |  -5.4891349411832d-01,-7.5595747504966d-01,-8.1922701362317d-01,
     |  -7.2784776556922d-01,-4.9961269326909d-01,-1.7763682414287d-01,
     |   1.7763682414287d-01, 4.9961269326909d-01, 7.2784776556922d-01,
     |   8.1922701362317d-01, 7.5595747504966d-01, 5.4891349411832d-01,
     |   2.3571898294752d-01,-1.2608235260687d-01,-4.6951864770713d-01,
     |  -7.3042502132212d-01,-8.5918898320772d-01,-8.2986805093277d-01,
     |  -6.4502783013112d-01,-3.3543525899532d-01, 4.5317608990794d-02,
     |   4.3026266440736d-01, 7.5084835069836d-01, 9.4893578863205d-01,
     |   9.8684264337948d-01, 8.5365781045213d-01, 5.6675006258374d-01,
     |   1.6828284022171d-01,-2.8254075976668d-01,-7.2001294184429d-01,
     |  -1.0832667176419d+00,-1.3263548194913d+00,-1.4252642828151d+00,
     |  -1.3806783189435d+00,-1.2161179841563d+00,-9.7197157466189d-01,
     |  -6.9668391823852d-01,-4.3688761625357d-01,-2.2842005578958d-01,
     |  -8.9956727154650d-02,-2.0447642243088d-02,-7.7673085310441d-04/
      data (pmn(lat, 4,10), lat = 1,72)/
     |   2.0983728380796d-05, 1.6665016451180d-03, 1.2359178053540d-02,
     |   4.4715859597207d-02, 1.1269042681043d-01, 2.2689112200351d-01,
     |   3.9018907304193d-01, 5.9469269741049d-01, 8.2091256774649d-01,
     |   1.0395085926270d+00, 1.2154798919642d+00, 1.3141327505916d+00,
     |   1.3077497003772d+00, 1.1816694343890d+00, 9.3852212489562d-01,
     |   5.9964963642552d-01, 2.0322823602460d-01,-2.0078480304826d-01,
     |  -5.5815201300971d-01,-8.1908037213133d-01,-9.4666129575799d-01,
     |  -9.2350300785783d-01,-7.5529923850150d-01,-4.7058506045012d-01,
     |  -1.1659032565738d-01, 2.4820388713421d-01, 5.6359662404031d-01,
     |   7.7767659253222d-01, 8.5558013061041d-01, 7.8545499108806d-01,
     |   5.8055311800456d-01, 2.7704036935551d-01,-7.2141872463346d-02,
     |  -4.0633202367848d-01,-6.6756898855087d-01,-8.1057656050958d-01,
     |  -8.1057656050958d-01,-6.6756898855087d-01,-4.0633202367848d-01,
     |  -7.2141872463347d-02, 2.7704036935551d-01, 5.8055311800456d-01,
     |   7.8545499108806d-01, 8.5558013061041d-01, 7.7767659253222d-01,
     |   5.6359662404031d-01, 2.4820388713422d-01,-1.1659032565737d-01,
     |  -4.7058506045012d-01,-7.5529923850150d-01,-9.2350300785783d-01,
     |  -9.4666129575800d-01,-8.1908037213133d-01,-5.5815201300971d-01,
     |  -2.0078480304826d-01, 2.0322823602460d-01, 5.9964963642552d-01,
     |   9.3852212489562d-01, 1.1816694343890d+00, 1.3077497003772d+00,
     |   1.3141327505916d+00, 1.2154798919642d+00, 1.0395085926270d+00,
     |   8.2091256774650d-01, 5.9469269741049d-01, 3.9018907304193d-01,
     |   2.2689112200351d-01, 1.1269042681043d-01, 4.4715859597207d-02,
     |   1.2359178053540d-02, 1.6665016451180d-03, 2.0983728380796d-05/
      data (pmn(lat, 5,10), lat = 1,72)/
     |   4.3450832324798d-07, 1.0392119857914d-04, 1.2944919374711d-03,
     |   6.6350543940206d-03, 2.1851077189193d-02, 5.4918322788914d-02,
     |   1.1462169012780d-01, 2.0832154685660d-01, 3.3939327346302d-01,
     |   5.0494272912558d-01, 6.9441007112408d-01, 8.8954746629289d-01,
     |   1.0660115983472d+00, 1.1964936542265d+00, 1.2549790350501d+00,
     |   1.2214532601501d+00, 1.0862086755258d+00, 8.5289826809467d-01,
     |   5.3963957639352d-01, 1.7777331888304d-01,-1.9172099489229d-01,
     |  -5.2372608829412d-01,-7.7560532522633d-01,-9.1388917181178d-01,
     |  -9.1990485446034d-01,-7.9334506162552d-01,-5.5307511083123d-01,
     |  -2.3491742538692d-01, 1.1334561745300d-01, 4.3903090780434d-01,
     |   6.9258623216660d-01, 8.3531050442840d-01, 8.4549861058643d-01,
     |   7.2198177532490d-01, 4.8444776790178d-01, 1.7044888391404d-01,
     |  -1.7044888391404d-01,-4.8444776790178d-01,-7.2198177532490d-01,
     |  -8.4549861058643d-01,-8.3531050442840d-01,-6.9258623216660d-01,
     |  -4.3903090780435d-01,-1.1334561745301d-01, 2.3491742538692d-01,
     |   5.5307511083123d-01, 7.9334506162552d-01, 9.1990485446034d-01,
     |   9.1388917181179d-01, 7.7560532522633d-01, 5.2372608829412d-01,
     |   1.9172099489230d-01,-1.7777331888304d-01,-5.3963957639352d-01,
     |  -8.5289826809467d-01,-1.0862086755258d+00,-1.2214532601501d+00,
     |  -1.2549790350501d+00,-1.1964936542265d+00,-1.0660115983472d+00,
     |  -8.8954746629289d-01,-6.9441007112408d-01,-5.0494272912558d-01,
     |  -3.3939327346302d-01,-2.0832154685660d-01,-1.1462169012780d-01,
     |  -5.4918322788915d-02,-2.1851077189193d-02,-6.6350543940206d-03,
     |  -1.2944919374711d-03,-1.0392119857914d-04,-4.3450832324798d-07/
      data (pmn(lat, 6,10), lat = 1,72)/
     |   7.0680864179184d-09, 5.0857368571366d-06, 1.0618606937373d-04,
     |   7.6859408378258d-04, 3.2928980280563d-03, 1.0268966892354d-02,
     |   2.5807966453566d-02, 5.5365555108271d-02, 1.0505305923189d-01,
     |   1.8045650614591d-01, 2.8511974692201d-01, 4.1896661480270d-01,
     |   5.7700889591347d-01, 7.4869061274603d-01, 9.1814647747186d-01,
     |   1.0655105696005d+00, 1.1692224808427d+00, 1.2090758803473d+00,
     |   1.1695775948197d+00, 1.0430707994997d+00, 8.3205139718140d-01,
     |   5.5018455205394d-01, 2.2170263249967d-01,-1.2088784527447d-01,
     |  -4.4058341960741d-01,-7.0067343317233d-01,-8.6986798370341d-01,
     |  -9.2698790179654d-01,-8.6446268099437d-01,-6.9003066725193d-01,
     |  -4.2629101362939d-01,-1.0808032485271d-01, 2.2201300933054d-01,
     |   5.1938298959389d-01, 7.4356408289933d-01, 8.6390447472919d-01,
     |   8.6390447472919d-01, 7.4356408289933d-01, 5.1938298959389d-01,
     |   2.2201300933054d-01,-1.0808032485271d-01,-4.2629101362939d-01,
     |  -6.9003066725193d-01,-8.6446268099437d-01,-9.2698790179654d-01,
     |  -8.6986798370341d-01,-7.0067343317233d-01,-4.4058341960741d-01,
     |  -1.2088784527448d-01, 2.2170263249967d-01, 5.5018455205394d-01,
     |   8.3205139718139d-01, 1.0430707994997d+00, 1.1695775948197d+00,
     |   1.2090758803473d+00, 1.1692224808427d+00, 1.0655105696005d+00,
     |   9.1814647747186d-01, 7.4869061274603d-01, 5.7700889591348d-01,
     |   4.1896661480270d-01, 2.8511974692201d-01, 1.8045650614591d-01,
     |   1.0505305923189d-01, 5.5365555108271d-02, 2.5807966453566d-02,
     |   1.0268966892354d-02, 3.2928980280563d-03, 7.6859408378258d-04,
     |   1.0618606937373d-04, 5.0857368571366d-06, 7.0680864179184d-09/
      data (pmn(lat, 7,10), lat = 1,72)/
     |   9.0851984063335d-11, 1.9654407009315d-07, 6.8697080258260d-06,
     |   7.0080756222186d-05, 3.8953885554254d-04, 1.5019304025979d-03,
     |   4.5244895624709d-03, 1.1391344196256d-02, 2.4992835537873d-02,
     |   4.9122949619693d-02, 8.8161133922036d-02, 1.4646109728682d-01,
     |   2.2748352258769d-01, 3.3277969242782d-01, 4.6099374548703d-01,
     |   6.0708774288101d-01, 7.6199440545329d-01, 9.1286185292322d-01,
     |   1.0439752650546d+00, 1.1383324167103d+00, 1.1797304942915d+00,
     |   1.1551113959079d+00, 1.0568330369226d+00, 8.8450252880010d-01,
     |   6.4603378381185d-01, 3.5767785656290d-01, 4.2909560204715d-02,
     |  -2.6978028569588d-01,-5.4996656627380d-01,-7.6887661515879d-01,
     |  -9.0301258645006d-01,-9.3730638287149d-01,-8.6734579188799d-01,
     |  -7.0032417012780d-01,-4.5453642530988d-01,-1.5744631959653d-01,
     |   1.5744631959653d-01, 4.5453642530988d-01, 7.0032417012780d-01,
     |   8.6734579188799d-01, 9.3730638287149d-01, 9.0301258645006d-01,
     |   7.6887661515879d-01, 5.4996656627380d-01, 2.6978028569589d-01,
     |  -4.2909560204715d-02,-3.5767785656290d-01,-6.4603378381185d-01,
     |  -8.8450252880010d-01,-1.0568330369226d+00,-1.1551113959079d+00,
     |  -1.1797304942915d+00,-1.1383324167103d+00,-1.0439752650546d+00,
     |  -9.1286185292322d-01,-7.6199440545329d-01,-6.0708774288101d-01,
     |  -4.6099374548703d-01,-3.3277969242782d-01,-2.2748352258769d-01,
     |  -1.4646109728682d-01,-8.8161133922036d-02,-4.9122949619693d-02,
     |  -2.4992835537874d-02,-1.1391344196256d-02,-4.5244895624709d-03,
     |  -1.5019304025979d-03,-3.8953885554254d-04,-7.0080756222186d-05,
     |  -6.8697080258260d-06,-1.9654407009315d-07,-9.0851984063335d-11/
      data (pmn(lat, 8,10), lat = 1,72)/
     |   9.1053131957393d-13, 5.9198748162311d-09, 3.4608934988167d-07,
     |   4.9695520552599d-06, 3.5774014194528d-05, 1.7014305095138d-04,
     |   6.1258243386504d-04, 1.8035575017075d-03, 4.5554876082349d-03,
     |   1.0190294196502d-02, 2.0639082142225d-02, 3.8456905185048d-02,
     |   6.6707791365515d-02, 1.0868918356432d-01, 1.6749013773013d-01,
     |   2.4541082060636d-01, 3.4330656217032d-01, 4.5995102060036d-01,
     |   5.9153281429097d-01, 7.3140241614237d-01, 8.7016788681847d-01,
     |   9.9619931314875d-01, 1.0965465915042d+00, 1.1582108857800d+00,
     |   1.1696465580942d+00, 1.1223183600802d+00, 1.0121079833519d+00,
     |   8.4036177581106d-01, 6.1440047468843d-01, 3.4737021072376d-01,
     |   5.7394935203150d-02,-2.3391707821398d-01,-5.0346923409313d-01,
     |  -7.2895636821363d-01,-8.9116151690770d-01,-9.7599043412257d-01,
     |  -9.7599043412258d-01,-8.9116151690770d-01,-7.2895636821363d-01,
     |  -5.0346923409313d-01,-2.3391707821398d-01, 5.7394935203150d-02,
     |   3.4737021072375d-01, 6.1440047468843d-01, 8.4036177581106d-01,
     |   1.0121079833519d+00, 1.1223183600802d+00, 1.1696465580942d+00,
     |   1.1582108857800d+00, 1.0965465915042d+00, 9.9619931314875d-01,
     |   8.7016788681847d-01, 7.3140241614237d-01, 5.9153281429097d-01,
     |   4.5995102060036d-01, 3.4330656217032d-01, 2.4541082060636d-01,
     |   1.6749013773013d-01, 1.0868918356432d-01, 6.6707791365516d-02,
     |   3.8456905185048d-02, 2.0639082142225d-02, 1.0190294196502d-02,
     |   4.5554876082349d-03, 1.8035575017075d-03, 6.1258243386504d-04,
     |   1.7014305095138d-04, 3.5774014194528d-05, 4.9695520552599d-06,
     |   3.4608934988167d-07, 5.9198748162311d-09, 9.1053131957393d-13/
      data (pmn(lat, 9,10), lat = 1,72)/
     |   6.8042766171551d-15, 1.3291220452219d-10, 1.2989181062275d-08,
     |   2.6229417560217d-07, 2.4423305157965d-06, 1.4305788910137d-05,
     |   6.1438051356589d-05, 2.1101808345530d-04, 6.1183241945732d-04,
     |   1.5522643819996d-03, 3.5333958810649d-03, 7.3483130255466d-03,
     |   1.4152349384422d-02, 2.5503868767928d-02, 4.3352904144371d-02,
     |   6.9956872764605d-02, 1.0770939070498d-01, 1.5887973024245d-01,
     |   2.2527551576113d-01, 3.0785773411457d-01, 4.0635229783272d-01,
     |   5.1891329299691d-01, 6.4189703572567d-01, 7.6980135978371d-01,
     |   8.9541063015316d-01, 1.0101647825046d+00, 1.1047426651011d+00,
     |   1.1698197543482d+00, 1.1969322809631d+00, 1.1793583419774d+00,
     |   1.1129154241963d+00, 9.9657536180061d-01, 8.3281275915478d-01,
     |   6.2763002485574d-01, 3.9023821979868d-01, 1.3241330672833d-01,
     |  -1.3241330672833d-01,-3.9023821979868d-01,-6.2763002485574d-01,
     |  -8.3281275915478d-01,-9.9657536180061d-01,-1.1129154241963d+00,
     |  -1.1793583419774d+00,-1.1969322809631d+00,-1.1698197543482d+00,
     |  -1.1047426651011d+00,-1.0101647825046d+00,-8.9541063015316d-01,
     |  -7.6980135978371d-01,-6.4189703572567d-01,-5.1891329299691d-01,
     |  -4.0635229783273d-01,-3.0785773411457d-01,-2.2527551576114d-01,
     |  -1.5887973024245d-01,-1.0770939070498d-01,-6.9956872764605d-02,
     |  -4.3352904144371d-02,-2.5503868767928d-02,-1.4152349384422d-02,
     |  -7.3483130255466d-03,-3.5333958810649d-03,-1.5522643819996d-03,
     |  -6.1183241945733d-04,-2.1101808345530d-04,-6.1438051356589d-05,
     |  -1.4305788910138d-05,-2.4423305157965d-06,-2.6229417560217d-07,
     |  -1.2989181062275d-08,-1.3291220452219d-10,-6.8042766171551d-15/
      data (pmn(lat,10,10), lat = 1,72)/
     |   3.3198866367850d-17, 1.9479564625159d-12, 3.1809110899400d-10,
     |   9.0272154692195d-09, 1.0863036135508d-07, 7.8275891222859d-07,
     |   4.0042519059804d-06, 1.6017175650935d-05, 5.3202455779351d-05,
     |   1.5272627703649d-04, 3.8962992955458d-04, 9.0145349255794d-04,
     |   1.9203030745779d-03, 3.8105148113790d-03, 7.1079378631519d-03,
     |   1.2554700240814d-02, 2.1121585175862d-02, 3.4009309042301d-02,
     |   5.2620465075958d-02, 7.8495928902133d-02, 1.1321312118897d-01,
     |   1.5824841665512d-01, 2.1481162745756d-01, 2.8366610313992d-01,
     |   3.6495269312767d-01, 4.5803874535240d-01, 5.6141376703040d-01,
     |   6.7265095205399d-01, 7.8844848011604d-01, 9.0475674462454d-01,
     |   1.0169883015486d+00, 1.1202974873022d+00, 1.2099076223355d+00,
     |   1.2814567591584d+00, 1.3313290897494d+00, 1.3569390544675d+00,
     |   1.3569390544675d+00, 1.3313290897494d+00, 1.2814567591584d+00,
     |   1.2099076223355d+00, 1.1202974873022d+00, 1.0169883015486d+00,
     |   9.0475674462454d-01, 7.8844848011604d-01, 6.7265095205400d-01,
     |   5.6141376703040d-01, 4.5803874535240d-01, 3.6495269312767d-01,
     |   2.8366610313992d-01, 2.1481162745756d-01, 1.5824841665512d-01,
     |   1.1321312118897d-01, 7.8495928902133d-02, 5.2620465075958d-02,
     |   3.4009309042301d-02, 2.1121585175862d-02, 1.2554700240814d-02,
     |   7.1079378631518d-03, 3.8105148113790d-03, 1.9203030745779d-03,
     |   9.0145349255794d-04, 3.8962992955458d-04, 1.5272627703649d-04,
     |   5.3202455779351d-05, 1.6017175650935d-05, 4.0042519059804d-06,
     |   7.8275891222860d-07, 1.0863036135508d-07, 9.0272154692195d-09,
     |   3.1809110899400d-10, 1.9479564625159d-12, 3.3198866367850d-17/
      data (pmn(lat, 0,11), lat = 1,72)/
     |   3.3381082587518d+00, 2.9283808448335d+00, 2.1841305353426d+00,
     |   1.2404963557125d+00, 2.6525241770705d-01,-5.7474385302527d-01,
     |  -1.1462954715077d+00,-1.3749842792245d+00,-1.2575539252402d+00,
     |  -8.5923670340264d-01,-2.9695797505775d-01, 2.8764241362423d-01,
     |   7.5932835802220d-01, 1.0177279603396d+00, 1.0170807471272d+00,
     |   7.7326836835142d-01, 3.5701503867500d-01,-1.2478147323954d-01,
     |  -5.5505251063692d-01,-8.3384749974903d-01,-9.0073239247075d-01,
     |  -7.4737823589534d-01,-4.1775870599919d-01, 3.7506956749491d-03,
     |   4.1332779368508d-01, 7.1266217042841d-01, 8.3204776863584d-01,
     |   7.4628064143845d-01, 4.7978881549866d-01, 9.9974985030613d-02,
     |  -2.9949192373283d-01,-6.2137995482355d-01,-7.8818140696983d-01,
     |  -7.6048973022815d-01,-5.4616796377414d-01,-1.9820143524131d-01,
     |   1.9820143524131d-01, 5.4616796377414d-01, 7.6048973022815d-01,
     |   7.8818140696983d-01, 6.2137995482355d-01, 2.9949192373283d-01,
     |  -9.9974985030612d-02,-4.7978881549866d-01,-7.4628064143845d-01,
     |  -8.3204776863584d-01,-7.1266217042841d-01,-4.1332779368508d-01,
     |  -3.7506956749509d-03, 4.1775870599919d-01, 7.4737823589534d-01,
     |   9.0073239247075d-01, 8.3384749974903d-01, 5.5505251063692d-01,
     |   1.2478147323954d-01,-3.5701503867500d-01,-7.7326836835143d-01,
     |  -1.0170807471272d+00,-1.0177279603396d+00,-7.5932835802220d-01,
     |  -2.8764241362423d-01, 2.9695797505775d-01, 8.5923670340264d-01,
     |   1.2575539252402d+00, 1.3749842792245d+00, 1.1462954715077d+00,
     |   5.7474385302528d-01,-2.6525241770705d-01,-1.2404963557125d+00,
     |  -2.1841305353426d+00,-2.9283808448335d+00,-3.3381082587518d+00/
      data (pmn(lat, 1,11), lat = 1,72)/
     |   4.2169196396729d-01, 1.1874161678659d+00, 1.7359546436378d+00,
     |   1.9718071024039d+00, 1.8623966950640d+00, 1.4436804272733d+00,
     |   8.1139803495992d-01, 9.9981951271493d-02,-5.4621287318638d-01,
     |  -1.0030997603024d+00,-1.1919901225461d+00,-1.0943745481836d+00,
     |  -7.5340140444118d-01,-2.6204797405792d-01, 2.5911421247842d-01,
     |   6.8943502165986d-01, 9.3480110923029d-01, 9.4749903698872d-01,
     |   7.3509678974106d-01, 3.5665085918097d-01,-9.2583315576434d-02,
     |  -5.0420282441378d-01,-7.8206258580025d-01,-8.6420109758581d-01,
     |  -7.3635504809733d-01,-4.3413828921895d-01,-3.3603477129283d-02,
     |   3.6742571922690d-01, 6.7277649061257d-01, 8.1059277508546d-01,
     |   7.4997934073495d-01, 5.0781349517752d-01, 1.4423543149066d-01,
     |  -2.5202484110443d-01,-5.8496614333965d-01,-7.7423288876628d-01,
     |  -7.7423288876628d-01,-5.8496614333965d-01,-2.5202484110443d-01,
     |   1.4423543149066d-01, 5.0781349517752d-01, 7.4997934073495d-01,
     |   8.1059277508546d-01, 6.7277649061257d-01, 3.6742571922690d-01,
     |  -3.3603477129283d-02,-4.3413828921895d-01,-7.3635504809733d-01,
     |  -8.6420109758581d-01,-7.8206258580025d-01,-5.0420282441378d-01,
     |  -9.2583315576440d-02, 3.5665085918097d-01, 7.3509678974106d-01,
     |   9.4749903698872d-01, 9.3480110923029d-01, 6.8943502165987d-01,
     |   2.5911421247842d-01,-2.6204797405792d-01,-7.5340140444117d-01,
     |  -1.0943745481836d+00,-1.1919901225461d+00,-1.0030997603024d+00,
     |  -5.4621287318639d-01, 9.9981951271489d-02, 8.1139803495992d-01,
     |   1.4436804272733d+00, 1.8623966950640d+00, 1.9718071024039d+00,
     |   1.7359546436378d+00, 1.1874161678659d+00, 4.2169196396729d-01/
      data (pmn(lat, 2,11), lat = 1,72)/
     |   2.6293689109829d-02, 2.2701815949622d-01, 5.7956239690572d-01,
     |   9.9720223770961d-01, 1.3750763526155d+00, 1.6140475957707d+00,
     |   1.6433868835851d+00, 1.4371859768707d+00, 1.0208101496638d+00,
     |   4.6593206489665d-01,-1.2475679635101d-01,-6.3975440602977d-01,
     |  -9.8293232562285d-01,-1.0943201188241d+00,-9.6288636848757d-01,
     |  -6.2851211700010d-01,-1.7277321749140d-01, 2.9935488157479d-01,
     |   6.8274336042819d-01, 8.9510148993636d-01, 8.9460052855844d-01,
     |   6.8825624617012d-01, 3.2929731742606d-01,-9.5767053679808d-02,
     |  -4.8735756906027d-01,-7.5567771425394d-01,-8.4101732244148d-01,
     |  -7.2693583069259d-01,-4.4340546324596d-01,-5.9297246565322d-02,
     |   3.3397823760001d-01, 6.4385995023192d-01, 7.9811532948693d-01,
     |   7.6147575060730d-01, 5.4362781525467d-01, 1.9675687003154d-01,
     |  -1.9675687003154d-01,-5.4362781525466d-01,-7.6147575060730d-01,
     |  -7.9811532948693d-01,-6.4385995023193d-01,-3.3397823760000d-01,
     |   5.9297246565321d-02, 4.4340546324596d-01, 7.2693583069259d-01,
     |   8.4101732244148d-01, 7.5567771425394d-01, 4.8735756906027d-01,
     |   9.5767053679810d-02,-3.2929731742606d-01,-6.8825624617012d-01,
     |  -8.9460052855844d-01,-8.9510148993636d-01,-6.8274336042819d-01,
     |  -2.9935488157479d-01, 1.7277321749139d-01, 6.2851211700010d-01,
     |   9.6288636848757d-01, 1.0943201188241d+00, 9.8293232562285d-01,
     |   6.3975440602977d-01, 1.2475679635101d-01,-4.6593206489664d-01,
     |  -1.0208101496638d+00,-1.4371859768707d+00,-1.6433868835851d+00,
     |  -1.6140475957707d+00,-1.3750763526155d+00,-9.9720223770961d-01,
     |  -5.7956239690572d-01,-2.2701815949622d-01,-2.6293689109829d-02/
      data (pmn(lat, 3,11), lat = 1,72)/
     |   1.0746311530521d-03, 2.8141168660605d-02, 1.2248205354221d-01,
     |   3.0589366532208d-01, 5.7169969618951d-01, 8.8408085239831d-01,
     |   1.1849881411390d+00, 1.4071557223818d+00, 1.4902327141827d+00,
     |   1.3962387969965d+00, 1.1206131506682d+00, 6.9606555375079d-01,
     |   1.8804574955574d-01,-3.1744012644845d-01,-7.3115564884152d-01,
     |  -9.7935282179136d-01,-1.0197275096104d+00,-8.5098744840282d-01,
     |  -5.1377006026233d-01,-8.2540400269826d-02, 3.4989695171818d-01,
     |   6.9197482371783d-01, 8.7278640912205d-01, 8.5710297555324d-01,
     |   6.5267379931818d-01, 3.0817912079068d-01,-9.7736307072361d-02,
     |  -4.7394837297122d-01,-7.3700812663576d-01,-8.2951777261248d-01,
     |  -7.3266857143744d-01,-4.7017291215745d-01,-1.0273256222160d-01,
     |   2.8571170503032d-01, 6.0687591133335d-01, 7.8795617531418d-01,
     |   7.8795617531418d-01, 6.0687591133335d-01, 2.8571170503032d-01,
     |  -1.0273256222160d-01,-4.7017291215744d-01,-7.3266857143745d-01,
     |  -8.2951777261248d-01,-7.3700812663577d-01,-4.7394837297122d-01,
     |  -9.7736307072361d-02, 3.0817912079067d-01, 6.5267379931818d-01,
     |   8.5710297555324d-01, 8.7278640912205d-01, 6.9197482371783d-01,
     |   3.4989695171818d-01,-8.2540400269825d-02,-5.1377006026232d-01,
     |  -8.5098744840282d-01,-1.0197275096104d+00,-9.7935282179136d-01,
     |  -7.3115564884151d-01,-3.1744012644845d-01, 1.8804574955574d-01,
     |   6.9606555375079d-01, 1.1206131506682d+00, 1.3962387969965d+00,
     |   1.4902327141827d+00, 1.4071557223818d+00, 1.1849881411390d+00,
     |   8.8408085239832d-01, 5.7169969618951d-01, 3.0589366532208d-01,
     |   1.2248205354221d-01, 2.8141168660605d-02, 1.0746311530521d-03/
      data (pmn(lat, 4,11), lat = 1,72)/
     |   3.2129654221973d-05, 2.5409825032993d-03, 1.8684835151637d-02,
     |   6.6728215832186d-02, 1.6519102239971d-01, 3.2498224401535d-01,
     |   5.4280115964342d-01, 7.9782271234813d-01, 1.0529233034185d+00,
     |   1.2605916656481d+00, 1.3724707354623d+00, 1.3504816442092d+00,
     |   1.1769395509304d+00, 8.6113091416060d-01, 4.4049215368320d-01,
     |  -2.4324262082371d-02,-4.5983898272395d-01,-7.9364713102668d-01,
     |  -9.6898896025404d-01,-9.5685352842120d-01,-7.6288021687224d-01,
     |  -4.2735099570069d-01,-1.8010013794662d-02, 3.8300409334884d-01,
     |   6.9551542907027d-01, 8.5758053222823d-01, 8.3823149866285d-01,
     |   6.4393767535576d-01, 3.1732586586204d-01,-7.1668067902962d-02,
     |  -4.4042312171609d-01,-7.1098489116328d-01,-8.2648546715004d-01,
     |  -7.6314192856710d-01,-5.3526612324957d-01,-1.9219865698036d-01,
     |   1.9219865698036d-01, 5.3526612324956d-01, 7.6314192856710d-01,
     |   8.2648546715004d-01, 7.1098489116328d-01, 4.4042312171609d-01,
     |   7.1668067902964d-02,-3.1732586586204d-01,-6.4393767535576d-01,
     |  -8.3823149866285d-01,-8.5758053222823d-01,-6.9551542907027d-01,
     |  -3.8300409334885d-01, 1.8010013794662d-02, 4.2735099570069d-01,
     |   7.6288021687224d-01, 9.5685352842120d-01, 9.6898896025404d-01,
     |   7.9364713102668d-01, 4.5983898272396d-01, 2.4324262082372d-02,
     |  -4.4049215368320d-01,-8.6113091416060d-01,-1.1769395509304d+00,
     |  -1.3504816442092d+00,-1.3724707354623d+00,-1.2605916656481d+00,
     |  -1.0529233034185d+00,-7.9782271234813d-01,-5.4280115964342d-01,
     |  -3.2498224401535d-01,-1.6519102239971d-01,-6.6728215832186d-02,
     |  -1.8684835151637d-02,-2.5409825032993d-03,-3.2129654221973d-05/
      data (pmn(lat, 5,11), lat = 1,72)/
     |   7.4224485003494d-07, 1.7690189997033d-04, 2.1880762752196d-03,
     |   1.1095546234304d-02, 3.6011926858617d-02, 8.8833179125141d-02,
     |   1.8116183031209d-01, 3.2012275046271d-01, 5.0420657183187d-01,
     |   7.2042581930254d-01, 9.4387751354528d-01, 1.1403006533942d+00,
     |   1.2715058280470d+00, 1.3028029324732d+00, 1.2109464659018d+00,
     |   9.9081623637036d-01, 6.5915003380412d-01, 2.5414931762737d-01,
     |  -1.6940103222017d-01,-5.4889129003706d-01,-8.2501498480467d-01,
     |  -9.5312984213311d-01,-9.1251654064244d-01,-7.1149846276822d-01,
     |  -3.8713961779363d-01, 6.9566356829251d-04, 3.7997648139620d-01,
     |   6.7987811269068d-01, 8.4430275211508d-01, 8.4284161424287d-01,
     |   6.7691691459249d-01, 3.7976894110786d-01, 1.0177883389851d-02,
     |  -3.5891846410936d-01,-6.5469665061333d-01,-8.1878233524604d-01,
     |  -8.1878233524604d-01,-6.5469665061333d-01,-3.5891846410936d-01,
     |   1.0177883389850d-02, 3.7976894110786d-01, 6.7691691459249d-01,
     |   8.4284161424287d-01, 8.4430275211508d-01, 6.7987811269068d-01,
     |   3.7997648139620d-01, 6.9566356829407d-04,-3.8713961779362d-01,
     |  -7.1149846276822d-01,-9.1251654064244d-01,-9.5312984213311d-01,
     |  -8.2501498480467d-01,-5.4889129003706d-01,-1.6940103222017d-01,
     |   2.5414931762737d-01, 6.5915003380412d-01, 9.9081623637036d-01,
     |   1.2109464659018d+00, 1.3028029324732d+00, 1.2715058280470d+00,
     |   1.1403006533942d+00, 9.4387751354528d-01, 7.2042581930254d-01,
     |   5.0420657183187d-01, 3.2012275046271d-01, 1.8116183031209d-01,
     |   8.8833179125142d-02, 3.6011926858617d-02, 1.1095546234304d-02,
     |   2.1880762752196d-03, 1.7690189997033d-04, 7.4224485003494d-07/
      data (pmn(lat, 6,11), lat = 1,72)/
     |   1.3634308865486d-08, 9.7809901193518d-06, 2.0299114611119d-04,
     |   1.4559284198847d-03, 6.1611301601413d-03, 1.8914154949088d-02,
     |   4.6627365289233d-02, 9.7742432309963d-02, 1.8046009724290d-01,
     |   3.0022006208788d-01, 4.5696077306360d-01, 6.4288121233352d-01,
     |   8.4144818558998d-01, 1.0282158230915d+00, 1.1736709101747d+00,
     |   1.2478570302576d+00, 1.2260644514981d+00, 1.0945140603224d+00,
     |   8.5480953848209d-01, 5.2603949605949d-01, 1.4378130935126d-01,
     |  -2.4416833625955d-01,-5.8484455997234d-01,-8.2883399123994d-01,
     |  -9.3911178467545d-01,-8.9829637118321d-01,-7.1281432675486d-01,
     |  -4.1298008545401d-01,-4.8738988277706d-02, 3.1834459538495d-01,
     |   6.2551633939796d-01, 8.1981882019284d-01, 8.6760344664999d-01,
     |   7.6075564410441d-01, 5.1840296783158d-01, 1.8371003974739d-01,
     |  -1.8371003974739d-01,-5.1840296783158d-01,-7.6075564410441d-01,
     |  -8.6760344664999d-01,-8.1981882019284d-01,-6.2551633939796d-01,
     |  -3.1834459538495d-01, 4.8738988277703d-02, 4.1298008545401d-01,
     |   7.1281432675486d-01, 8.9829637118321d-01, 9.3911178467545d-01,
     |   8.2883399123995d-01, 5.8484455997234d-01, 2.4416833625955d-01,
     |  -1.4378130935125d-01,-5.2603949605949d-01,-8.5480953848209d-01,
     |  -1.0945140603224d+00,-1.2260644514981d+00,-1.2478570302576d+00,
     |  -1.1736709101747d+00,-1.0282158230915d+00,-8.4144818558998d-01,
     |  -6.4288121233352d-01,-4.5696077306360d-01,-3.0022006208788d-01,
     |  -1.8046009724290d-01,-9.7742432309963d-02,-4.6627365289233d-02,
     |  -1.8914154949088d-02,-6.1611301601413d-03,-1.4559284198847d-03,
     |  -2.0299114611119d-04,-9.7809901193518d-06,-1.3634308865486d-08/
      data (pmn(lat, 7,11), lat = 1,72)/
     |   2.0162891196558d-10, 4.3505028630968d-07, 1.5126221882878d-05,
     |   1.5308607564046d-04, 8.4184917246311d-04, 3.2021356911371d-03,
     |   9.4878995587832d-03, 2.3421699028240d-02, 5.0216092282671d-02,
     |   9.6099488196494d-02, 1.6726359388977d-01, 2.6830244524736d-01,
     |   4.0038492763137d-01, 5.5954817312727d-01, 7.3557339861509d-01,
     |   9.1187630059209d-01, 1.0667009449844d+00, 1.1756662499286d+00,
     |   1.2154205659402d+00, 1.1678735566343d+00, 1.0242620844376d+00,
     |   7.8822511024374d-01, 4.7714528337700d-01, 1.2126243723836d-01,
     |  -2.3955875861979d-01,-5.6108448716404d-01,-8.0124991027619d-01,
     |  -9.2692919097626d-01,-9.1975643695975d-01,-7.7990359971804d-01,
     |  -5.2702216203045d-01,-1.9802320456704d-01, 1.5807717172886d-01,
     |   4.8748558456348d-01, 7.3995686212336d-01, 8.7673083981555d-01,
     |   8.7673083981555d-01, 7.3995686212336d-01, 4.8748558456348d-01,
     |   1.5807717172886d-01,-1.9802320456703d-01,-5.2702216203045d-01,
     |  -7.7990359971804d-01,-9.1975643695975d-01,-9.2692919097626d-01,
     |  -8.0124991027619d-01,-5.6108448716405d-01,-2.3955875861979d-01,
     |   1.2126243723836d-01, 4.7714528337700d-01, 7.8822511024374d-01,
     |   1.0242620844376d+00, 1.1678735566343d+00, 1.2154205659402d+00,
     |   1.1756662499286d+00, 1.0667009449844d+00, 9.1187630059209d-01,
     |   7.3557339861508d-01, 5.5954817312727d-01, 4.0038492763137d-01,
     |   2.6830244524736d-01, 1.6726359388977d-01, 9.6099488196494d-02,
     |   5.0216092282672d-02, 2.3421699028240d-02, 9.4878995587832d-03,
     |   3.2021356911371d-03, 8.4184917246311d-04, 1.5308607564046d-04,
     |   1.5126221882878d-05, 4.3505028630968d-07, 2.0162891196558d-10/
      data (pmn(lat, 8,11), lat = 1,72)/
     |   2.3973916800202d-12, 1.5550512709213d-08, 9.0487820543989d-07,
     |   1.2902009211279d-05, 9.2001384512128d-05, 4.3236259924122d-04,
     |   1.5342286444626d-03, 4.4400289407944d-03, 1.0992654132241d-02,
     |   2.4031323429344d-02, 4.7416525590152d-02, 8.5779027565680d-02,
     |   1.4392588344105d-01, 2.2590687802176d-01, 3.3383632111855d-01,
     |   4.6665790452272d-01, 6.1911066543052d-01, 7.8117958427917d-01,
     |   9.3827980187247d-01, 1.0723256003063d+00, 1.1636851562085d+00,
     |   1.1938441607509d+00, 1.1484297740329d+00, 1.0201181198009d+00,
     |   8.1089589895160d-01, 5.3318971397905d-01, 2.0951769129381d-01,
     |  -1.2946039767183d-01,-4.4835115062309d-01,-7.1148453487977d-01,
     |  -8.8779645674732d-01,-9.5539424418386d-01,-9.0506610049715d-01,
     |  -7.4212832829071d-01,-4.8624798787932d-01,-1.6919430724726d-01,
     |   1.6919430724726d-01, 4.8624798787932d-01, 7.4212832829071d-01,
     |   9.0506610049715d-01, 9.5539424418386d-01, 8.8779645674732d-01,
     |   7.1148453487977d-01, 4.4835115062310d-01, 1.2946039767183d-01,
     |  -2.0951769129381d-01,-5.3318971397905d-01,-8.1089589895160d-01,
     |  -1.0201181198009d+00,-1.1484297740329d+00,-1.1938441607509d+00,
     |  -1.1636851562085d+00,-1.0723256003063d+00,-9.3827980187247d-01,
     |  -7.8117958427917d-01,-6.1911066543052d-01,-4.6665790452272d-01,
     |  -3.3383632111855d-01,-2.2590687802176d-01,-1.4392588344105d-01,
     |  -8.5779027565680d-02,-4.7416525590152d-02,-2.4031323429344d-02,
     |  -1.0992654132241d-02,-4.4400289407945d-03,-1.5342286444626d-03,
     |  -4.3236259924123d-04,-9.2001384512128d-05,-1.2902009211279d-05,
     |  -9.0487820543989d-07,-1.5550512709213d-08,-2.3973916800202d-12/
      data (pmn(lat, 9,11), lat = 1,72)/
     |   2.2512438013511d-14, 4.3882865834156d-10, 4.2705765626469d-08,
     |   8.5692738305992d-07, 7.9117513026693d-06, 4.5849659222490d-05,
     |   1.9437336243149d-04, 6.5747989040246d-04, 1.8728802585329d-03,
     |   4.6565494436834d-03, 1.0360105273701d-02, 2.1000070273895d-02,
     |   3.9303728130044d-02, 6.8612312351084d-02, 1.1259336757756d-01,
     |   1.7474202295219d-01, 2.5769325281622d-01, 3.6241734534706d-01,
     |   4.8741873136897d-01, 6.2809247223986d-01, 7.7640243743491d-01,
     |   9.2102343962626d-01, 1.0480349391694d+00, 1.1421717739963d+00,
     |   1.1885396351312d+00, 1.1746064263449d+00, 1.0922038475008d+00,
     |   9.3923344975679d-01, 7.2077968105641d-01, 4.4939267184474d-01,
     |   1.4440987950081d-01,-1.6967661650077d-01,-4.6565301908738d-01,
     |  -7.1653046643820d-01,-8.9862513952809d-01,-9.9435382250005d-01,
     |  -9.9435382250006d-01,-8.9862513952809d-01,-7.1653046643821d-01,
     |  -4.6565301908738d-01,-1.6967661650077d-01, 1.4440987950081d-01,
     |   4.4939267184474d-01, 7.2077968105641d-01, 9.3923344975679d-01,
     |   1.0922038475008d+00, 1.1746064263449d+00, 1.1885396351312d+00,
     |   1.1421717739963d+00, 1.0480349391694d+00, 9.2102343962626d-01,
     |   7.7640243743492d-01, 6.2809247223986d-01, 4.8741873136897d-01,
     |   3.6241734534706d-01, 2.5769325281622d-01, 1.7474202295220d-01,
     |   1.1259336757756d-01, 6.8612312351084d-02, 3.9303728130045d-02,
     |   2.1000070273895d-02, 1.0360105273701d-02, 4.6565494436835d-03,
     |   1.8728802585329d-03, 6.5747989040246d-04, 1.9437336243149d-04,
     |   4.5849659222490d-05, 7.9117513026693d-06, 8.5692738305992d-07,
     |   4.2705765626469d-08, 4.3882865834156d-10, 2.2512438013511d-14/
      data (pmn(lat,10,11), lat = 1,72)/
     |   1.5917828072831d-16, 9.3220689178340d-12, 1.5164442441907d-09,
     |   4.2789139335152d-08, 5.1096256296596d-07, 3.6463985734855d-06,
     |   1.8436526206811d-05, 7.2739077928369d-05, 2.3780182140287d-04,
     |   6.7041942959596d-04, 1.6758959551216d-03, 3.7902818350735d-03,
     |   7.8732681439327d-03, 1.5194763811499d-02, 2.7490464691033d-02,
     |   4.6957021901677d-02, 7.6158037342801d-02, 1.1781966890781d-01,
     |   1.7450946384647d-01, 2.4821287515331d-01, 3.3984580985368d-01,
     |   4.4876425464198d-01, 5.7234866213734d-01, 7.0574683875482d-01,
     |   8.4185137691846d-01, 9.7156524007024d-01, 1.0843736503066d+00,
     |   1.1691963484375d+00, 1.2154481454612d+00, 1.2141951381686d+00,
     |   1.1592664853985d+00, 1.0481730893281d+00, 8.8269794354017d-01,
     |   6.6905778796338d-01, 4.1758786268318d-01, 1.4196366043075d-01,
     |  -1.4196366043075d-01,-4.1758786268318d-01,-6.6905778796338d-01,
     |  -8.8269794354017d-01,-1.0481730893281d+00,-1.1592664853985d+00,
     |  -1.2141951381686d+00,-1.2154481454612d+00,-1.1691963484375d+00,
     |  -1.0843736503066d+00,-9.7156524007024d-01,-8.4185137691846d-01,
     |  -7.0574683875482d-01,-5.7234866213734d-01,-4.4876425464198d-01,
     |  -3.3984580985368d-01,-2.4821287515331d-01,-1.7450946384647d-01,
     |  -1.1781966890781d-01,-7.6158037342801d-02,-4.6957021901677d-02,
     |  -2.7490464691032d-02,-1.5194763811499d-02,-7.8732681439328d-03,
     |  -3.7902818350735d-03,-1.6758959551216d-03,-6.7041942959596d-04,
     |  -2.3780182140287d-04,-7.2739077928369d-05,-1.8436526206811d-05,
     |  -3.6463985734856d-06,-5.1096256296596d-07,-4.2789139335152d-08,
     |  -1.5164442441907d-09,-9.3220689178340d-12,-1.5917828072831d-16/
      data (pmn(lat,11,11), lat = 1,72)/
     |   7.4050630458026d-19, 1.3026578213189d-13, 3.5407875051500d-11,
     |   1.4041140023391d-09, 2.1669032820613d-08, 1.9023218836321d-07,
     |   1.1456889141508d-06, 5.2642646308841d-06, 1.9715964527409d-05,
     |   6.2892422386842d-05, 1.7620195460108d-04, 4.4333379551185d-04,
     |   1.0185912373357d-03, 2.1645877693911d-03, 4.2974532965833d-03,
     |   8.0348942157134d-03, 1.4239421330077d-02, 2.4046438929092d-02,
     |   3.8865416947258d-02, 6.0342740112750d-02, 9.0277520140520d-02,
     |   1.3048677316359d-01, 1.8262353485715d-01, 2.4795985151661d-01,
     |   3.2715488605043d-01, 4.2003513413107d-01, 5.2541751347164d-01,
     |   6.4100573939711d-01, 7.6338537089827d-01, 8.8813337978007d-01,
     |   1.0100450246946d+00, 1.1234658581228d+00, 1.2227019780339d+00,
     |   1.3024694110001d+00, 1.3583357918765d+00, 1.3871057025744d+00,
     |   1.3871057025744d+00, 1.3583357918765d+00, 1.3024694110001d+00,
     |   1.2227019780339d+00, 1.1234658581228d+00, 1.0100450246946d+00,
     |   8.8813337978007d-01, 7.6338537089827d-01, 6.4100573939711d-01,
     |   5.2541751347164d-01, 4.2003513413108d-01, 3.2715488605043d-01,
     |   2.4795985151661d-01, 1.8262353485715d-01, 1.3048677316359d-01,
     |   9.0277520140521d-02, 6.0342740112750d-02, 3.8865416947258d-02,
     |   2.4046438929092d-02, 1.4239421330077d-02, 8.0348942157134d-03,
     |   4.2974532965833d-03, 2.1645877693911d-03, 1.0185912373357d-03,
     |   4.4333379551185d-04, 1.7620195460108d-04, 6.2892422386843d-05,
     |   1.9715964527409d-05, 5.2642646308841d-06, 1.1456889141508d-06,
     |   1.9023218836321d-07, 2.1669032820613d-08, 1.4041140023391d-09,
     |   3.5407875051500d-11, 1.3026578213189d-13, 7.4050630458026d-19/
      data (pmn(lat, 0,12), lat = 1,72)/
     |   3.4702077589760d+00, 2.9689913540113d+00, 2.0749338247979d+00,
     |   9.7884063737756d-01,-9.1445724840563d-02,-9.2455998784032d-01,
     |  -1.3739924094093d+00,-1.3895233457177d+00,-1.0243373973865d+00,
     |  -4.1668827199714d-01, 2.4857592186496d-01, 7.8834719756504d-01,
     |   1.0669306693580d+00, 1.0275568506130d+00, 7.0219879804495d-01,
     |   1.9798242502713d-01,-3.3539436402556d-01,-7.4799489170082d-01,
     |  -9.3021091428004d-01,-8.4085782602917d-01,-5.1571786716997d-01,
     |  -5.4871556937082d-02, 4.0710715992031d-01, 7.3950472371822d-01,
     |   8.5168118894748d-01, 7.1728202035381d-01, 3.8007245370903d-01,
     |  -5.9827323600128d-02,-4.7512851026918d-01,-7.4763150306773d-01,
     |  -8.0138106386141d-01,-6.2353893100799d-01,-2.6730351049041d-01,
     |   1.6375585267894d-01, 5.4541345918101d-01, 7.6813729564911d-01,
     |   7.6813729564911d-01, 5.4541345918101d-01, 1.6375585267894d-01,
     |  -2.6730351049041d-01,-6.2353893100799d-01,-8.0138106386141d-01,
     |  -7.4763150306773d-01,-4.7512851026918d-01,-5.9827323600130d-02,
     |   3.8007245370903d-01, 7.1728202035381d-01, 8.5168118894748d-01,
     |   7.3950472371822d-01, 4.0710715992031d-01,-5.4871556937082d-02,
     |  -5.1571786716996d-01,-8.4085782602917d-01,-9.3021091428004d-01,
     |  -7.4799489170082d-01,-3.3539436402557d-01, 1.9798242502713d-01,
     |   7.0219879804495d-01, 1.0275568506130d+00, 1.0669306693580d+00,
     |   7.8834719756504d-01, 2.4857592186496d-01,-4.1668827199714d-01,
     |  -1.0243373973865d+00,-1.3895233457177d+00,-1.3739924094093d+00,
     |  -9.2455998784033d-01,-9.1445724840563d-02, 9.7884063737756d-01,
     |   2.0749338247979d+00, 2.9689913540113d+00, 3.4702077589760d+00/
      data (pmn(lat, 1,12), lat = 1,72)/
     |   4.7725978323851d-01, 1.3281710503066d+00, 1.8931086508418d+00,
     |   2.0580311352040d+00, 1.8036038354108d+00, 1.2080137781538d+00,
     |   4.2576248939277d-01,-3.5191593342178d-01,-9.4476321134659d-01,
     |  -1.2271621942233d+00,-1.1568211244934d+00,-7.8157107829278d-01,
     |  -2.2312389032763d-01, 3.5740659910959d-01, 8.0281397250952d-01,
     |   1.0004647517636d+00, 9.0981357003198d-01, 5.6996331780473d-01,
     |   8.5881314731522d-02,-4.0244607732748d-01,-7.5921660178998d-01,
     |  -8.8965044705469d-01,-7.6462227108777d-01,-4.2674327013256d-01,
     |   2.3314320624638d-02, 4.5608821151445d-01, 7.4987618980156d-01,
     |   8.2441426620556d-01, 6.6248177618870d-01, 3.1367487722256d-01,
     |  -1.2043951921151d-01,-5.1544828758130d-01,-7.5926720192058d-01,
     |  -7.8354571379941d-01,-5.8260022345024d-01,-2.1468312630741d-01,
     |   2.1468312630741d-01, 5.8260022345024d-01, 7.8354571379941d-01,
     |   7.5926720192058d-01, 5.1544828758130d-01, 1.2043951921151d-01,
     |  -3.1367487722256d-01,-6.6248177618870d-01,-8.2441426620556d-01,
     |  -7.4987618980156d-01,-4.5608821151445d-01,-2.3314320624641d-02,
     |   4.2674327013256d-01, 7.6462227108777d-01, 8.8965044705469d-01,
     |   7.5921660178998d-01, 4.0244607732748d-01,-8.5881314731520d-02,
     |  -5.6996331780473d-01,-9.0981357003197d-01,-1.0004647517636d+00,
     |  -8.0281397250952d-01,-3.5740659910958d-01, 2.2312389032763d-01,
     |   7.8157107829278d-01, 1.1568211244934d+00, 1.2271621942233d+00,
     |   9.4476321134660d-01, 3.5191593342179d-01,-4.2576248939277d-01,
     |  -1.2080137781538d+00,-1.8036038354108d+00,-2.0580311352040d+00,
     |  -1.8931086508418d+00,-1.3281710503066d+00,-4.7725978323851d-01/
      data (pmn(lat, 2,12), lat = 1,72)/
     |   3.2404671452544d-02, 2.7762685006299d-01, 6.9750329249988d-01,
     |   1.1697946903395d+00, 1.5533699649895d+00, 1.7261727300576d+00,
     |   1.6183027949795d+00, 1.2314360266447d+00, 6.3942542599182d-01,
     |  -3.0092783678906d-02,-6.2824493699918d-01,-1.0230474724689d+00,
     |  -1.1330961452330d+00,-9.4800135237672d-01,-5.3028469187146d-01,
     |   1.6363681964222d-03, 5.0476439037094d-01, 8.4879235361119d-01,
     |   9.4948166071667d-01, 7.8941958391183d-01, 4.2085253471983d-01,
     |  -4.9903960739265d-02,-4.9208186348085d-01,-7.8602545591044d-01,
     |  -8.5513234228728d-01,-6.8567588276523d-01,-3.2935568663271d-01,
     |   1.1188347257144d-01, 5.1444686573057d-01, 7.6720553095895d-01,
     |   8.0181831026988d-01, 6.1105077298284d-01, 2.5019956731667d-01,
     |  -1.7864566236893d-01,-5.5509785272710d-01,-7.7386406980256d-01,
     |  -7.7386406980256d-01,-5.5509785272710d-01,-1.7864566236893d-01,
     |   2.5019956731667d-01, 6.1105077298284d-01, 8.0181831026988d-01,
     |   7.6720553095895d-01, 5.1444686573058d-01, 1.1188347257144d-01,
     |  -3.2935568663270d-01,-6.8567588276522d-01,-8.5513234228728d-01,
     |  -7.8602545591044d-01,-4.9208186348085d-01,-4.9903960739265d-02,
     |   4.2085253471982d-01, 7.8941958391182d-01, 9.4948166071667d-01,
     |   8.4879235361120d-01, 5.0476439037094d-01, 1.6363681964245d-03,
     |  -5.3028469187147d-01,-9.4800135237672d-01,-1.1330961452330d+00,
     |  -1.0230474724689d+00,-6.2824493699918d-01,-3.0092783678910d-02,
     |   6.3942542599182d-01, 1.2314360266447d+00, 1.6183027949795d+00,
     |   1.7261727300576d+00, 1.5533699649895d+00, 1.1697946903395d+00,
     |   6.9750329249988d-01, 2.7762685006299d-01, 3.2404671452544d-02/
      data (pmn(lat, 3,12), lat = 1,72)/
     |   1.4453717535313d-03, 3.7632288671195d-02, 1.6187598841186d-01,
     |   3.9694943362789d-01, 7.2301896551956d-01, 1.0799054057215d+00,
     |   1.3819211088853d+00, 1.5413770280027d+00, 1.4942966958767d+00,
     |   1.2210802818667d+00, 7.5607206103514d-01, 1.8289236005132d-01,
     |  -3.8377331265161d-01,-8.2551367537570d-01,-1.0496494378690d+00,
     |  -1.0130506249468d+00,-7.3388309617865d-01,-2.8793086679304d-01,
     |   2.0983674109032d-01, 6.3388173644581d-01, 8.7958806630531d-01,
     |   8.8948380758892d-01, 6.6736499008376d-01, 2.7661735680533d-01,
     |  -1.7684416019577d-01,-5.7256476216249d-01,-8.0713942171600d-01,
     |  -8.2112412273814d-01,-6.1422244718168d-01,-2.4479569980447d-01,
     |   1.8611467170360d-01, 5.6197232700563d-01, 7.8190127561094d-01,
     |   7.8753439122133d-01, 5.7843446930896d-01, 2.1201186460470d-01,
     |  -2.1201186460470d-01,-5.7843446930896d-01,-7.8753439122133d-01,
     |  -7.8190127561094d-01,-5.6197232700563d-01,-1.8611467170360d-01,
     |   2.4479569980447d-01, 6.1422244718167d-01, 8.2112412273814d-01,
     |   8.0713942171600d-01, 5.7256476216249d-01, 1.7684416019577d-01,
     |  -2.7661735680533d-01,-6.6736499008376d-01,-8.8948380758892d-01,
     |  -8.7958806630531d-01,-6.3388173644581d-01,-2.0983674109033d-01,
     |   2.8793086679304d-01, 7.3388309617864d-01, 1.0130506249468d+00,
     |   1.0496494378690d+00, 8.2551367537570d-01, 3.8377331265162d-01,
     |  -1.8289236005132d-01,-7.5607206103514d-01,-1.2210802818667d+00,
     |  -1.4942966958767d+00,-1.5413770280027d+00,-1.3819211088853d+00,
     |  -1.0799054057215d+00,-7.2301896551956d-01,-3.9694943362789d-01,
     |  -1.6187598841186d-01,-3.7632288671195d-02,-1.4453717535313d-03/
      data (pmn(lat, 4,12), lat = 1,72)/
     |   4.7345526275095d-05, 3.7271693893656d-03, 2.7153232585584d-02,
     |   9.5594234859102d-02, 2.3202931779408d-01, 4.4483690378953d-01,
     |   7.1890489517580d-01, 1.0135460186092d+00, 1.2686779467816d+00,
     |   1.4182713385258d+00, 1.4077810404201d+00, 1.2108278300919d+00,
     |   8.4024198764638d-01, 3.4981556679984d-01,-1.7455105436127d-01,
     |  -6.3278757061408d-01,-9.3358964215747d-01,-1.0166833219987d+00,
     |  -8.6862317230221d-01,-5.2774830738476d-01,-7.6558790728019d-02,
     |   3.7703127231689d-01, 7.2518846387042d-01, 8.8616163793561d-01,
     |   8.2425577785355d-01, 5.5863617059444d-01, 1.5857231732939d-01,
     |  -2.7384944479328d-01,-6.2930534646515d-01,-8.1870158598202d-01,
     |  -7.9558140086178d-01,-5.6775946065890d-01,-1.9518580571358d-01,
     |   2.2545398722817d-01, 5.8550067260510d-01, 7.9213476654200d-01,
     |   7.9213476654200d-01, 5.8550067260510d-01, 2.2545398722817d-01,
     |  -1.9518580571358d-01,-5.6775946065890d-01,-7.9558140086178d-01,
     |  -8.1870158598202d-01,-6.2930534646515d-01,-2.7384944479328d-01,
     |   1.5857231732939d-01, 5.5863617059444d-01, 8.2425577785355d-01,
     |   8.8616163793561d-01, 7.2518846387042d-01, 3.7703127231689d-01,
     |  -7.6558790728012d-02,-5.2774830738476d-01,-8.6862317230221d-01,
     |  -1.0166833219987d+00,-9.3358964215747d-01,-6.3278757061408d-01,
     |  -1.7455105436127d-01, 3.4981556679984d-01, 8.4024198764637d-01,
     |   1.2108278300919d+00, 1.4077810404201d+00, 1.4182713385258d+00,
     |   1.2686779467816d+00, 1.0135460186092d+00, 7.1890489517580d-01,
     |   4.4483690378953d-01, 2.3202931779408d-01, 9.5594234859102d-02,
     |   2.7153232585584d-02, 3.7271693893656d-03, 4.7345526275095d-05/
      data (pmn(lat, 5,12), lat = 1,72)/
     |   1.2053743107786d-06, 2.8618518910963d-04, 3.5125751944880d-03,
     |   1.7603689307845d-02, 5.6225265360396d-02, 1.3585450611221d-01,
     |   2.6998630925236d-01, 4.6218508312510d-01, 7.0036927249940d-01,
     |   9.5466154296821d-01, 1.1803146322398d+00, 1.3258275442880d+00,
     |   1.3447793399502d+00, 1.2085892924370d+00, 9.1677419436470d-01,
     |   5.0155719211597d-01, 2.4880799178321d-02,-4.3227587177365d-01,
     |  -7.8634221120905d-01,-9.6975277733237d-01,-9.4723952456493d-01,
     |  -7.2562762573044d-01,-3.5431061988935d-01, 8.4246997367575d-02,
     |   4.9217929281423d-01, 7.7814808699815d-01, 8.7840383196358d-01,
     |   7.7187531613289d-01, 4.8548731222774d-01, 8.8194038392682d-02,
     |  -3.2505810121819d-01,-6.5573709827745d-01,-8.2517839553507d-01,
     |  -7.9342816087231d-01,-5.6887861697734d-01,-2.0630137942297d-01,
     |   2.0630137942297d-01, 5.6887861697734d-01, 7.9342816087231d-01,
     |   8.2517839553507d-01, 6.5573709827745d-01, 3.2505810121819d-01,
     |  -8.8194038392681d-02,-4.8548731222774d-01,-7.7187531613289d-01,
     |  -8.7840383196358d-01,-7.7814808699815d-01,-4.9217929281423d-01,
     |  -8.4246997367576d-02, 3.5431061988935d-01, 7.2562762573044d-01,
     |   9.4723952456493d-01, 9.6975277733237d-01, 7.8634221120906d-01,
     |   4.3227587177365d-01,-2.4880799178318d-02,-5.0155719211597d-01,
     |  -9.1677419436470d-01,-1.2085892924370d+00,-1.3447793399502d+00,
     |  -1.3258275442880d+00,-1.1803146322398d+00,-9.5466154296821d-01,
     |  -7.0036927249940d-01,-4.6218508312510d-01,-2.6998630925236d-01,
     |  -1.3585450611221d-01,-5.6225265360396d-02,-1.7603689307845d-02,
     |  -3.5125751944880d-03,-2.8618518910963d-04,-1.2053743107786d-06/
      data (pmn(lat, 6,12), lat = 1,72)/
     |   2.4610623295895d-08, 1.7597495756125d-05, 3.6281296977684d-04,
     |   2.5763350972291d-03, 1.0755607033077d-02, 3.2451773101433d-02,
     |   7.8308516672642d-02, 1.5996987012128d-01, 2.8639410086056d-01,
     |   4.5938555582753d-01, 6.6966812001459d-01, 8.9497659066282d-01,
     |   1.1013351528749d+00, 1.2479586865196d+00, 1.2952210273642d+00,
     |   1.2141482998440d+00, 9.9520458189236d-01, 6.5397493316433d-01,
     |   2.3182336436561d-01,-2.0935050768651d-01,-5.9773686612746d-01,
     |  -8.6569696252482d-01,-9.6432363612385d-01,-8.7511205317002d-01,
     |  -6.1578803193765d-01,-2.3851814845439d-01, 1.7958300717386d-01,
     |   5.5191805649214d-01, 8.0061719833747d-01, 8.7347043428948d-01,
     |   7.5568843461643d-01, 4.7365943932710d-01, 8.9636486152529d-02,
     |  -3.1164156286181d-01,-6.4150851820872d-01,-8.2697884898285d-01,
     |  -8.2697884898285d-01,-6.4150851820872d-01,-3.1164156286181d-01,
     |   8.9636486152528d-02, 4.7365943932710d-01, 7.5568843461643d-01,
     |   8.7347043428948d-01, 8.0061719833747d-01, 5.5191805649215d-01,
     |   1.7958300717387d-01,-2.3851814845439d-01,-6.1578803193765d-01,
     |  -8.7511205317002d-01,-9.6432363612385d-01,-8.6569696252482d-01,
     |  -5.9773686612746d-01,-2.0935050768651d-01, 2.3182336436561d-01,
     |   6.5397493316433d-01, 9.9520458189235d-01, 1.2141482998440d+00,
     |   1.2952210273642d+00, 1.2479586865196d+00, 1.1013351528749d+00,
     |   8.9497659066282d-01, 6.6966812001459d-01, 4.5938555582754d-01,
     |   2.8639410086057d-01, 1.5996987012128d-01, 7.8308516672642d-02,
     |   3.2451773101434d-02, 1.0755607033077d-02, 2.5763350972291d-03,
     |   3.6281296977684d-04, 1.7597495756125d-05, 2.4610623295895d-08/
      data (pmn(lat, 7,12), lat = 1,72)/
     |   4.0963365144416d-10, 8.8133170410848d-07, 3.0467152663917d-05,
     |   3.0567280505314d-04, 1.6613175621867d-03, 6.2255194310218d-03,
     |   1.8112013842475d-02, 4.3743970923660d-02, 9.1402244551603d-02,
     |   1.6974193119788d-01, 2.8532454294514d-01, 4.3959082725227d-01,
     |   6.2603449384938d-01, 8.2850800304033d-01, 1.0215096337067d+00,
     |   1.1729429464972d+00, 1.2492625219022d+00, 1.2222536774014d+00,
     |   1.0761127966397d+00, 8.1317211599709d-01, 4.5667199666686d-01,
     |   4.9459841533817d-02,-3.5168409478545d-01,-6.8539748281284d-01,
     |  -8.9712683830097d-01,-9.5027684361689d-01,-8.3467006394817d-01,
     |  -5.7026168249050d-01,-2.0495368676262d-01, 1.9341858308656d-01,
     |   5.4956584567008d-01, 7.9527667748791d-01, 8.8302818353344d-01,
     |   7.9578375211968d-01, 5.5081420430235d-01, 1.9660718775188d-01,
     |  -1.9660718775188d-01,-5.5081420430235d-01,-7.9578375211968d-01,
     |  -8.8302818353344d-01,-7.9527667748791d-01,-5.4956584567007d-01,
     |  -1.9341858308656d-01, 2.0495368676262d-01, 5.7026168249050d-01,
     |   8.3467006394816d-01, 9.5027684361689d-01, 8.9712683830097d-01,
     |   6.8539748281284d-01, 3.5168409478545d-01,-4.9459841533817d-02,
     |  -4.5667199666685d-01,-8.1317211599709d-01,-1.0761127966397d+00,
     |  -1.2222536774014d+00,-1.2492625219022d+00,-1.1729429464972d+00,
     |  -1.0215096337067d+00,-8.2850800304033d-01,-6.2603449384938d-01,
     |  -4.3959082725227d-01,-2.8532454294514d-01,-1.6974193119788d-01,
     |  -9.1402244551603d-02,-4.3743970923660d-02,-1.8112013842475d-02,
     |  -6.2255194310218d-03,-1.6613175621867d-03,-3.0567280505314d-04,
     |  -3.0467152663917d-05,-8.8133170410848d-07,-4.0963365144416d-10/
      data (pmn(lat, 8,12), lat = 1,72)/
     |   5.5871747369848d-12, 3.6148786932841d-08, 2.0927722170372d-06,
     |   2.9610201923298d-05, 2.0896455105436d-04, 9.6922515886398d-04,
     |   3.3846901459684d-03, 9.6107338825833d-03, 2.3271452137538d-02,
     |   4.9585484087746d-02, 9.5003420551163d-02, 1.6620207184411d-01,
     |   2.6843792218772d-01, 4.0347453734330d-01, 5.6751106776073d-01,
     |   7.4968363063125d-01, 9.3172752638770d-01, 1.0892418340980d+00,
     |   1.1946958313430d+00, 1.2219111037952d+00, 1.1513335667671d+00,
     |   9.7508305987734d-01, 7.0063297311349d-01, 3.5209082364491d-01,
     |  -3.1571192104190d-02,-4.0140685689267d-01,-7.0591124717334d-01,
     |  -8.9975492366333d-01,-9.5222661023497d-01,-8.5368429162123d-01,
     |  -6.1858538541323d-01,-2.8426337655354d-01, 9.4569873490356d-02,
     |   4.5475562847341d-01, 7.3548684327083d-01, 8.8897776607342d-01,
     |   8.8897776607342d-01, 7.3548684327083d-01, 4.5475562847341d-01,
     |   9.4569873490357d-02,-2.8426337655354d-01,-6.1858538541323d-01,
     |  -8.5368429162123d-01,-9.5222661023497d-01,-8.9975492366333d-01,
     |  -7.0591124717334d-01,-4.0140685689267d-01,-3.1571192104193d-02,
     |   3.5209082364491d-01, 7.0063297311349d-01, 9.7508305987734d-01,
     |   1.1513335667671d+00, 1.2219111037952d+00, 1.1946958313430d+00,
     |   1.0892418340980d+00, 9.3172752638770d-01, 7.4968363063125d-01,
     |   5.6751106776072d-01, 4.0347453734330d-01, 2.6843792218772d-01,
     |   1.6620207184411d-01, 9.5003420551163d-02, 4.9585484087747d-02,
     |   2.3271452137539d-02, 9.6107338825833d-03, 3.3846901459684d-03,
     |   9.6922515886400d-04, 2.0896455105436d-04, 2.9610201923298d-05,
     |   2.0927722170372d-06, 3.6148786932841d-08, 5.5871747369848d-12/
      data (pmn(lat, 9,12), lat = 1,72)/
     |   6.2080269744967d-14, 1.2073483223158d-09, 1.1695831219521d-07,
     |   2.3306855077559d-06, 2.1319475188088d-05, 1.2210889623112d-04,
     |   5.1034560347572d-04, 1.6974335474137d-03, 4.7415030000807d-03,
     |   1.1526928636684d-02, 2.4999111404754d-02, 4.9233633393145d-02,
     |   8.9208252273734d-02, 1.5017723045363d-01, 2.3662485673245d-01,
     |   3.5088931024491d-01, 4.9167553788644d-01, 6.5278278536743d-01,
     |   8.2242299930959d-01, 9.8347260213472d-01, 1.1148715037169d+00,
     |   1.1941722288125d+00, 1.2009849319534d+00, 1.1208148886368d+00,
     |   9.4860840017402d-01, 6.9126377507250d-01, 3.6845725441029d-01,
     |   1.1378749939357d-02,-3.4066662420517d-01,-6.4542374204414d-01,
     |  -8.6387318800357d-01,-9.6642842186571d-01,-9.3805223049724d-01,
     |  -7.8132654399821d-01,-5.1683165596470d-01,-1.8065286489211d-01,
     |   1.8065286489211d-01, 5.1683165596470d-01, 7.8132654399821d-01,
     |   9.3805223049723d-01, 9.6642842186571d-01, 8.6387318800357d-01,
     |   6.4542374204414d-01, 3.4066662420517d-01,-1.1378749939356d-02,
     |  -3.6845725441029d-01,-6.9126377507250d-01,-9.4860840017402d-01,
     |  -1.1208148886368d+00,-1.2009849319534d+00,-1.1941722288125d+00,
     |  -1.1148715037169d+00,-9.8347260213472d-01,-8.2242299930959d-01,
     |  -6.5278278536743d-01,-4.9167553788644d-01,-3.5088931024491d-01,
     |  -2.3662485673245d-01,-1.5017723045363d-01,-8.9208252273734d-02,
     |  -4.9233633393145d-02,-2.4999111404754d-02,-1.1526928636684d-02,
     |  -4.7415030000807d-03,-1.6974335474137d-03,-5.1034560347572d-04,
     |  -1.2210889623113d-04,-2.1319475188088d-05,-2.3306855077559d-06,
     |  -1.1695831219521d-07,-1.2073483223158d-09,-6.2080269744967d-14/
      data (pmn(lat,10,12), lat = 1,72)/
     |   5.5026701062449d-16, 3.2158743406328d-11, 5.2095839119814d-09,
     |   1.4607769298885d-07, 1.7297513776295d-06, 1.2213921836309d-05,
     |   6.0967019090017d-05, 2.3692313870029d-04, 7.6109972182420d-04,
     |   2.1031925701459d-03, 5.1398778331848d-03, 1.1333279026063d-02,
     |   2.2884862579755d-02, 4.2799494448545d-02, 7.4784933796407d-02,
     |   1.2292142560481d-01, 1.9106866269605d-01, 2.8203189890619d-01,
     |   3.9657730628615d-01, 5.3245459542654d-01, 6.8363478009972d-01,
     |   8.3998564341511d-01, 9.8757500899658d-01, 1.1097095947994d+00,
     |   1.1886937610310d+00, 1.2081477662902d+00, 1.1555871943023d+00,
     |   1.0248645862726d+00, 8.1803746528458d-01, 5.4626972174378d-01,
     |   2.2949633858244d-01,-1.0523156735999d-01,-4.2658440149961d-01,
     |  -7.0262460806103d-01,-9.0479595902835d-01,-1.0116359463862d+00,
     |  -1.0116359463862d+00,-9.0479595902835d-01,-7.0262460806103d-01,
     |  -4.2658440149961d-01,-1.0523156736000d-01, 2.2949633858244d-01,
     |   5.4626972174378d-01, 8.1803746528458d-01, 1.0248645862726d+00,
     |   1.1555871943023d+00, 1.2081477662902d+00, 1.1886937610310d+00,
     |   1.1097095947994d+00, 9.8757500899658d-01, 8.3998564341511d-01,
     |   6.8363478009973d-01, 5.3245459542654d-01, 3.9657730628615d-01,
     |   2.8203189890619d-01, 1.9106866269605d-01, 1.2292142560481d-01,
     |   7.4784933796407d-02, 4.2799494448545d-02, 2.2884862579755d-02,
     |   1.1333279026063d-02, 5.1398778331848d-03, 2.1031925701459d-03,
     |   7.6109972182421d-04, 2.3692313870029d-04, 6.0967019090017d-05,
     |   1.2213921836309d-05, 1.7297513776295d-06, 1.4607769298885d-07,
     |   5.2095839119814d-09, 3.2158743406328d-11, 5.5026701062449d-16/
      data (pmn(lat,11,12), lat = 1,72)/
     |   3.7016504206631d-18, 6.4993436546482d-13, 1.7598711308964d-10,
     |   6.9388611811041d-09, 1.0626334215516d-07, 9.2390263794912d-07,
     |   5.4995923760100d-06, 2.4924453943098d-05, 9.1877170450229d-05,
     |   2.8783078080153d-04, 7.9015365043243d-04, 1.9434130011730d-03,
     |   4.3540287008088d-03, 8.9989447670522d-03, 1.7328290115606d-02,
     |   3.1331446610638d-02, 5.3528818957086d-02, 8.6851404491235d-02,
     |   1.3437971618725d-01, 1.9893366582507d-01, 2.8253409433260d-01,
     |   3.8579043977731d-01, 5.0730099907724d-01, 6.4317470032136d-01,
     |   7.8678912943680d-01, 9.2888394660398d-01, 1.0580508217226d+00,
     |   1.1616243135784d+00, 1.2269109272090d+00, 1.2426274399593d+00,
     |   1.2003672649207d+00, 1.0958865801765d+00, 9.3000782599812d-01,
     |   7.0897887182930d-01, 4.4419705667012d-01, 1.5129775716223d-01,
     |  -1.5129775716222d-01,-4.4419705667012d-01,-7.0897887182930d-01,
     |  -9.3000782599812d-01,-1.0958865801765d+00,-1.2003672649207d+00,
     |  -1.2426274399593d+00,-1.2269109272090d+00,-1.1616243135784d+00,
     |  -1.0580508217226d+00,-9.2888394660398d-01,-7.8678912943680d-01,
     |  -6.4317470032136d-01,-5.0730099907724d-01,-3.8579043977731d-01,
     |  -2.8253409433261d-01,-1.9893366582507d-01,-1.3437971618725d-01,
     |  -8.6851404491235d-02,-5.3528818957086d-02,-3.1331446610638d-02,
     |  -1.7328290115606d-02,-8.9989447670522d-03,-4.3540287008088d-03,
     |  -1.9434130011730d-03,-7.9015365043243d-04,-2.8783078080153d-04,
     |  -9.1877170450230d-05,-2.4924453943098d-05,-5.4995923760100d-06,
     |  -9.2390263794914d-07,-1.0626334215516d-07,-6.9388611811041d-09,
     |  -1.7598711308964d-10,-6.4993436546482d-13,-3.7016504206631d-18/
      data (pmn(lat,12,12), lat = 1,72)/
     |   1.6487168347386d-20, 8.6954740350917d-15, 3.9342323369211d-12,
     |   2.1800313438933d-10, 4.3145910318737d-09, 4.6147884037365d-08,
     |   3.2720794216184d-07, 1.7270356133876d-06, 7.2931674109257d-06,
     |   2.5852032048844d-05, 7.9539148861662d-05, 2.1763571081677d-04,
     |   5.3931425563555d-04, 1.2273786152556d-03, 2.5935254527483d-03,
     |   5.1329352377861d-03, 9.5823047341742d-03, 1.6971316693129d-02,
     |   2.8653902976979d-02, 4.6303596741719d-02, 7.1857860741335d-02,
     |   1.0740028046258d-01, 1.5497709285410d-01, 2.1635508082491d-01,
     |   2.9273999075309d-01, 3.8448626229003d-01, 4.9083761508688d-01,
     |   6.0974167694895d-01, 7.3777876621972d-01, 8.7023463197312d-01,
     |   1.0013302033434d+00, 1.1246003171975d+00, 1.2333911352578d+00,
     |   1.3214262043349d+00, 1.3833773897928d+00, 1.4153719290576d+00,
     |   1.4153719290576d+00, 1.3833773897928d+00, 1.3214262043349d+00,
     |   1.2333911352578d+00, 1.1246003171975d+00, 1.0013302033434d+00,
     |   8.7023463197312d-01, 7.3777876621972d-01, 6.0974167694895d-01,
     |   4.9083761508688d-01, 3.8448626229003d-01, 2.9273999075309d-01,
     |   2.1635508082491d-01, 1.5497709285410d-01, 1.0740028046258d-01,
     |   7.1857860741336d-02, 4.6303596741720d-02, 2.8653902976979d-02,
     |   1.6971316693129d-02, 9.5823047341743d-03, 5.1329352377861d-03,
     |   2.5935254527483d-03, 1.2273786152556d-03, 5.3931425563556d-04,
     |   2.1763571081677d-04, 7.9539148861662d-05, 2.5852032048844d-05,
     |   7.2931674109258d-06, 1.7270356133877d-06, 3.2720794216184d-07,
     |   4.6147884037366d-08, 4.3145910318737d-09, 2.1800313438933d-10,
     |   3.9342323369211d-12, 8.6954740350917d-15, 1.6487168347386d-20/
      data (pmn(lat, 0,13), lat = 1,72)/
     |   3.5950921407301d+00, 2.9921273041363d+00, 1.9377384550225d+00,
     |   6.9280924002589d-01,-4.4453105314936d-01,-1.2199812559606d+00,
     |  -1.4898074553343d+00,-1.2544547632093d+00,-6.5025256466727d-01,
     |   9.7112515461849d-02, 7.4254819212234d-01, 1.0936279380216d+00,
     |   1.0634875551096d+00, 6.8964137925730d-01, 1.1451928493533d-01,
     |  -4.6478948003985d-01,-8.6101346812037d-01,-9.5505199130947d-01,
     |  -7.3043016924450d-01,-2.7405697778467d-01, 2.5572610497262d-01,
     |   6.8263022074560d-01, 8.6983097525455d-01, 7.6295165395053d-01,
     |   4.0531100088442d-01,-7.8731858549013d-02,-5.2623546907234d-01,
     |  -7.8971193951567d-01,-7.8507462897205d-01,-5.1809622181378d-01,
     |  -8.1141625489730d-02, 3.7834707544616d-01, 7.0701673179122d-01,
     |   7.9621634261111d-01, 6.1752892049899d-01, 2.3171578523824d-01,
     |  -2.3171578523824d-01,-6.1752892049899d-01,-7.9621634261111d-01,
     |  -7.0701673179122d-01,-3.7834707544616d-01, 8.1141625489731d-02,
     |   5.1809622181378d-01, 7.8507462897205d-01, 7.8971193951567d-01,
     |   5.2623546907234d-01, 7.8731858549015d-02,-4.0531100088442d-01,
     |  -7.6295165395053d-01,-8.6983097525455d-01,-6.8263022074560d-01,
     |  -2.5572610497262d-01, 2.7405697778467d-01, 7.3043016924450d-01,
     |   9.5505199130947d-01, 8.6101346812037d-01, 4.6478948003985d-01,
     |  -1.1451928493533d-01,-6.8964137925730d-01,-1.0634875551096d+00,
     |  -1.0936279380216d+00,-7.4254819212234d-01,-9.7112515461854d-02,
     |   6.5025256466727d-01, 1.2544547632093d+00, 1.4898074553343d+00,
     |   1.2199812559606d+00, 4.4453105314936d-01,-6.9280924002589d-01,
     |  -1.9377384550225d+00,-2.9921273041363d+00,-3.5950921407301d+00/
      data (pmn(lat, 1,13), lat = 1,72)/
     |   5.3489192971486d-01, 1.4696095945827d+00, 2.0368244796435d+00,
     |   2.1061866186511d+00, 1.6841109079089d+00, 9.0890185915336d-01,
     |   8.2462008789208d-03,-7.6790875270036d-01,-1.2189792478680d+00,
     |  -1.2487698644328d+00,-8.8814199692709d-01,-2.7955455124312d-01,
     |   3.7075573337732d-01, 8.5761686700042d-01, 1.0387234591627d+00,
     |   8.7480590604320d-01, 4.3668029142410d-01,-1.2185323347787d-01,
     |  -6.1577043991595d-01,-8.8839793878604d-01,-8.5999473261501d-01,
     |  -5.5045659249812d-01,-6.9738138372141d-02, 4.2011234098941d-01,
     |   7.5854699965072d-01, 8.3831458468064d-01, 6.3895749446931d-01,
     |   2.3164756049511d-01,-2.4567009195449d-01,-6.3433596184170d-01,
     |  -8.0706934813108d-01,-7.0918269321313d-01,-3.7569908521445d-01,
     |   8.0942250842675d-02, 5.0836134353963d-01, 7.6454481446959d-01,
     |   7.6454481446959d-01, 5.0836134353963d-01, 8.0942250842677d-02,
     |  -3.7569908521445d-01,-7.0918269321313d-01,-8.0706934813108d-01,
     |  -6.3433596184170d-01,-2.4567009195449d-01, 2.3164756049511d-01,
     |   6.3895749446931d-01, 8.3831458468064d-01, 7.5854699965073d-01,
     |   4.2011234098941d-01,-6.9738138372141d-02,-5.5045659249812d-01,
     |  -8.5999473261501d-01,-8.8839793878604d-01,-6.1577043991595d-01,
     |  -1.2185323347788d-01, 4.3668029142410d-01, 8.7480590604321d-01,
     |   1.0387234591627d+00, 8.5761686700042d-01, 3.7075573337732d-01,
     |  -2.7955455124312d-01,-8.8814199692709d-01,-1.2487698644328d+00,
     |  -1.2189792478680d+00,-7.6790875270037d-01, 8.2462008789208d-03,
     |   9.0890185915335d-01, 1.6841109079089d+00, 2.1061866186511d+00,
     |   2.0368244796435d+00, 1.4696095945827d+00, 5.3489192971486d-01/
      data (pmn(lat, 2,13), lat = 1,72)/
     |   3.9284404117612d-02, 3.3375661513971d-01, 8.2396885001648d-01,
     |   1.3432597551202d+00, 1.7091196511301d+00, 1.7804465877136d+00,
     |   1.5022787373156d+00, 9.2417789060528d-01, 1.8657653028287d-01,
     |  -5.2072136866542d-01,-1.0151353883633d+00,-1.1756476832891d+00,
     |  -9.7829900235636d-01,-5.0212711460992d-01, 9.6026484218340d-02,
     |   6.2984996579999d-01, 9.4001194229031d-01, 9.4136797304114d-01,
     |   6.4660361359946d-01, 1.5943333133696d-01,-3.6003461647011d-01,
     |  -7.4657898048636d-01,-8.8159637059063d-01,-7.2917578103201d-01,
     |  -3.4552006185061d-01, 1.4079572316070d-01, 5.7106199658887d-01,
     |   8.0751586078009d-01, 7.7699249858308d-01, 4.9340450019656d-01,
     |   5.2151302781297d-02,-4.0147195685187d-01,-7.1955388643194d-01,
     |  -7.9930608798274d-01,-6.1598314255815d-01,-2.3051266960816d-01,
     |   2.3051266960815d-01, 6.1598314255815d-01, 7.9930608798274d-01,
     |   7.1955388643194d-01, 4.0147195685187d-01,-5.2151302781297d-02,
     |  -4.9340450019656d-01,-7.7699249858308d-01,-8.0751586078009d-01,
     |  -5.7106199658887d-01,-1.4079572316070d-01, 3.4552006185060d-01,
     |   7.2917578103201d-01, 8.8159637059063d-01, 7.4657898048636d-01,
     |   3.6003461647012d-01,-1.5943333133696d-01,-6.4660361359946d-01,
     |  -9.4136797304114d-01,-9.4001194229031d-01,-6.2984996579999d-01,
     |  -9.6026484218337d-02, 5.0212711460993d-01, 9.7829900235635d-01,
     |   1.1756476832891d+00, 1.0151353883633d+00, 5.2072136866542d-01,
     |  -1.8657653028286d-01,-9.2417789060527d-01,-1.5022787373156d+00,
     |  -1.7804465877136d+00,-1.7091196511301d+00,-1.3432597551202d+00,
     |  -8.2396885001648d-01,-3.3375661513971d-01,-3.9284404117612d-02/
      data (pmn(lat, 3,13), lat = 1,72)/
     |   1.8985200910142d-03, 4.9122679825430d-02, 2.0861234358715d-01,
     |   5.0139349243704d-01, 8.8754236531517d-01, 1.2746498047335d+00,
     |   1.5456756732361d+00, 1.5974627415691d+00, 1.3774128014304d+00,
     |   9.0606333715601d-01, 2.7751944911511d-01,-3.6340206207052d-01,
     |  -8.6103782457752d-01,-1.0938894154566d+00,-1.0109738089324d+00,
     |  -6.4807192633078d-01,-1.1843125486506d-01, 4.1972609856841d-01,
     |   8.0936051340428d-01, 9.4059375102216d-01, 7.8258828129122d-01,
     |   3.9162499963882d-01,-1.0708327215428d-01,-5.5827067333775d-01,
     |  -8.2427255204108d-01,-8.2685259963874d-01,-5.7041583412139d-01,
     |  -1.3958280586591d-01, 3.2797075942548d-01, 6.8486546937502d-01,
     |   8.2003675482924d-01, 6.9311829756785d-01, 3.4655204533859d-01,
     |  -1.0825065812964d-01,-5.2627884082831d-01,-7.7470055621422d-01,
     |  -7.7470055621422d-01,-5.2627884082831d-01,-1.0825065812964d-01,
     |   3.4655204533858d-01, 6.9311829756785d-01, 8.2003675482924d-01,
     |   6.8486546937502d-01, 3.2797075942548d-01,-1.3958280586591d-01,
     |  -5.7041583412139d-01,-8.2685259963874d-01,-8.2427255204108d-01,
     |  -5.5827067333775d-01,-1.0708327215428d-01, 3.9162499963882d-01,
     |   7.8258828129122d-01, 9.4059375102216d-01, 8.0936051340428d-01,
     |   4.1972609856841d-01,-1.1843125486506d-01,-6.4807192633078d-01,
     |  -1.0109738089324d+00,-1.0938894154566d+00,-8.6103782457752d-01,
     |  -3.6340206207052d-01, 2.7751944911511d-01, 9.0606333715601d-01,
     |   1.3774128014304d+00, 1.5974627415691d+00, 1.5456756732361d+00,
     |   1.2746498047335d+00, 8.8754236531517d-01, 5.0139349243704d-01,
     |   2.0861234358715d-01, 4.9122679825430d-02, 1.8985200910142d-03/
      data (pmn(lat, 4,13), lat = 1,72)/
     |   6.7581081200097d-05, 5.2937255063005d-03, 3.8177385950562d-02,
     |   1.3232297831037d-01, 3.1428892917522d-01, 5.8550795146479d-01,
     |   9.1175711618869d-01, 1.2252446469767d+00, 1.4401186147724d+00,
     |   1.4774248321410d+00, 1.2918616702823d+00, 8.9139447853066d-01,
     |   3.4244406741441d-01,-2.4245744156712d-01,-7.3219854859296d-01,
     |  -1.0124543259071d+00,-1.0186014026396d+00,-7.5607008315468d-01,
     |  -3.0137133635546d-01, 2.1736933083722d-01, 6.5536851015887d-01,
     |   8.9178067169078d-01, 8.6409289674530d-01, 5.8603857098766d-01,
     |   1.4346641279307d-01,-3.3090074062463d-01,-6.9655203032378d-01,
     |  -8.4662145082856d-01,-7.3935301477772d-01,-4.1017516973705d-01,
     |   3.9276667400297d-02, 4.7194010901236d-01, 7.5668748921029d-01,
     |   8.0783358454913d-01, 6.1088569761506d-01, 2.2676638924962d-01,
     |  -2.2676638924962d-01,-6.1088569761505d-01,-8.0783358454913d-01,
     |  -7.5668748921029d-01,-4.7194010901236d-01,-3.9276667400296d-02,
     |   4.1017516973705d-01, 7.3935301477772d-01, 8.4662145082856d-01,
     |   6.9655203032378d-01, 3.3090074062463d-01,-1.4346641279307d-01,
     |  -5.8603857098766d-01,-8.6409289674530d-01,-8.9178067169078d-01,
     |  -6.5536851015888d-01,-2.1736933083722d-01, 3.0137133635546d-01,
     |   7.5607008315468d-01, 1.0186014026396d+00, 1.0124543259071d+00,
     |   7.3219854859295d-01, 2.4245744156712d-01,-3.4244406741440d-01,
     |  -8.9139447853066d-01,-1.2918616702823d+00,-1.4774248321410d+00,
     |  -1.4401186147724d+00,-1.2252446469767d+00,-9.1175711618869d-01,
     |  -5.8550795146479d-01,-3.1428892917522d-01,-1.3232297831037d-01,
     |  -3.8177385950562d-02,-5.2937255063005d-03,-6.7581081200097d-05/
      data (pmn(lat, 5,13), lat = 1,72)/
     |   1.8780235392260d-06, 4.4404455195374d-04, 5.4046211886882d-03,
     |   2.6741068409439d-02, 8.3922616286545d-02, 1.9820893586603d-01,
     |   3.8275144057430d-01, 6.3225314907342d-01, 9.1663079348744d-01,
     |   1.1822830252282d+00, 1.3622553293225d+00, 1.3935160643791d+00,
     |   1.2367456760473d+00, 8.9249975980174d-01, 4.0798043821592d-01,
     |  -1.2901645954119d-01,-6.0872337692375d-01,-9.2638591177038d-01,
     |  -1.0104377040091d+00,-8.4372136636521d-01,-4.7107391719729d-01,
     |   9.8114880368745d-03, 4.7259421766075d-01, 7.9540827335934d-01,
     |   8.9385102354008d-01, 7.4445627285211d-01, 3.9168928771359d-01,
     |  -6.3948182420218d-02,-4.9371984951118d-01,-7.7671708371112d-01,
     |  -8.3399973717294d-01,-6.5102214725096d-01,-2.8180272373271d-01,
     |   1.6649954505876d-01, 5.6428323863825d-01, 7.9670851939593d-01,
     |   7.9670851939593d-01, 5.6428323863825d-01, 1.6649954505876d-01,
     |  -2.8180272373271d-01,-6.5102214725096d-01,-8.3399973717294d-01,
     |  -7.7671708371112d-01,-4.9371984951118d-01,-6.3948182420219d-02,
     |   3.9168928771359d-01, 7.4445627285211d-01, 8.9385102354008d-01,
     |   7.9540827335934d-01, 4.7259421766075d-01, 9.8114880368745d-03,
     |  -4.7107391719728d-01,-8.4372136636521d-01,-1.0104377040091d+00,
     |  -9.2638591177038d-01,-6.0872337692375d-01,-1.2901645954119d-01,
     |   4.0798043821592d-01, 8.9249975980174d-01, 1.2367456760473d+00,
     |   1.3935160643791d+00, 1.3622553293225d+00, 1.1822830252282d+00,
     |   9.1663079348744d-01, 6.3225314907342d-01, 3.8275144057430d-01,
     |   1.9820893586603d-01, 8.3922616286545d-02, 2.6741068409439d-02,
     |   5.4046211886882d-03, 4.4404455195374d-04, 1.8780235392260d-06/
      data (pmn(lat, 6,13), lat = 1,72)/
     |   4.2118244655952d-08, 3.0009434142144d-05, 6.1430373305583d-04,
     |   4.3149728023119d-03, 1.7749443499697d-02, 5.2546038572047d-02,
     |   1.2384255143246d-01, 2.4582699877695d-01, 4.2513402413626d-01,
     |   6.5414794882572d-01, 9.0690621710144d-01, 1.1399984102204d+00,
     |   1.2995831039975d+00, 1.3337181967752d+00, 1.2072126525645d+00,
     |   9.1484186294832d-01, 4.8857194397492d-01,-4.3761168172481d-03,
     |  -4.7344368967087d-01,-8.2456318579456d-01,-9.8324408553134d-01,
     |  -9.1481315766173d-01,-6.3593501615239d-01,-2.1351562094543d-01,
     |   2.4964297641759d-01, 6.3939012623848d-01, 8.5889218852404d-01,
     |   8.5385658358692d-01, 6.2734872188793d-01, 2.3982439742782d-01,
     |  -2.0607755527724d-01,-5.9225260396884d-01,-8.1636269552936d-01,
     |  -8.1919353888411d-01,-6.0066169869403d-01,-2.2000651723294d-01,
     |   2.2000651723293d-01, 6.0066169869402d-01, 8.1919353888411d-01,
     |   8.1636269552936d-01, 5.9225260396885d-01, 2.0607755527724d-01,
     |  -2.3982439742782d-01,-6.2734872188792d-01,-8.5385658358692d-01,
     |  -8.5889218852404d-01,-6.3939012623848d-01,-2.4964297641759d-01,
     |   2.1351562094543d-01, 6.3593501615239d-01, 9.1481315766173d-01,
     |   9.8324408553134d-01, 8.2456318579456d-01, 4.7344368967087d-01,
     |   4.3761168172494d-03,-4.8857194397492d-01,-9.1484186294832d-01,
     |  -1.2072126525645d+00,-1.3337181967752d+00,-1.2995831039975d+00,
     |  -1.1399984102204d+00,-9.0690621710144d-01,-6.5414794882572d-01,
     |  -4.2513402413626d-01,-2.4582699877695d-01,-1.2384255143246d-01,
     |  -5.2546038572047d-02,-1.7749443499697d-02,-4.3149728023119d-03,
     |  -6.1430373305583d-04,-3.0009434142144d-05,-4.2118244655952d-08/
      data (pmn(lat, 7,13), lat = 1,72)/
     |   7.7692461942549d-10, 1.6663860883222d-06, 5.7247628456555d-05,
     |   5.6895010263728d-04, 3.0528862482078d-03, 1.1255033227096d-02,
     |   3.2093707415996d-02, 7.5662899510956d-02, 1.5363049705924d-01,
     |   2.7584208398998d-01, 4.4567307696374d-01, 6.5540805452206d-01,
     |   8.8336666641258d-01, 1.0944010653678d+00, 1.2446792176657d+00,
     |   1.2904705773269d+00, 1.1992874235883d+00, 9.6063582430271d-01,
     |   5.9319922197119d-01, 1.4575746100251d-01,-3.0948301354635d-01,
     |  -6.9050702141791d-01,-9.2337760319982d-01,-9.6019879091467d-01,
     |  -7.9246984102533d-01,-4.5592062220803d-01,-2.4848428059853d-02,
     |   4.0338926301344d-01, 7.3042130683209d-01, 8.8021468293257d-01,
     |   8.1786566340076d-01, 5.5887208366403d-01, 1.6619911713585d-01,
     |  -2.6447747271086d-01,-6.2789758089324d-01,-8.3501992705736d-01,
     |  -8.3501992705736d-01,-6.2789758089324d-01,-2.6447747271086d-01,
     |   1.6619911713585d-01, 5.5887208366402d-01, 8.1786566340076d-01,
     |   8.8021468293257d-01, 7.3042130683210d-01, 4.0338926301344d-01,
     |  -2.4848428059852d-02,-4.5592062220803d-01,-7.9246984102533d-01,
     |  -9.6019879091467d-01,-9.2337760319982d-01,-6.9050702141791d-01,
     |  -3.0948301354636d-01, 1.4575746100251d-01, 5.9319922197119d-01,
     |   9.6063582430271d-01, 1.1992874235883d+00, 1.2904705773269d+00,
     |   1.2446792176657d+00, 1.0944010653678d+00, 8.8336666641258d-01,
     |   6.5540805452206d-01, 4.4567307696374d-01, 2.7584208398998d-01,
     |   1.5363049705924d-01, 7.5662899510956d-02, 3.2093707415996d-02,
     |   1.1255033227096d-02, 3.0528862482078d-03, 5.6895010263728d-04,
     |   5.7247628456555d-05, 1.6663860883222d-06, 7.7692461942549d-10/
      data (pmn(lat, 8,13), lat = 1,72)/
     |   1.1895411163720d-11, 7.6751040130199d-08, 4.4188353767699d-06,
     |   6.1999948980986d-05, 4.3263276194829d-04, 1.9781099633151d-03,
     |   6.7879435659381d-03, 1.8875389832058d-02, 4.4595989320364d-02,
     |   9.2347722461654d-02, 1.7119323643109d-01, 2.8832790922835d-01,
     |   4.4574990870732d-01, 6.3694150441095d-01, 8.4467585164947d-01,
     |   1.0410669308991d+00, 1.1906035559178d+00, 1.2561888388315d+00,
     |   1.2073052050471d+00, 1.0285927749571d+00, 7.2663802606590d-01,
     |   3.3282982481174d-01,-9.9176376380157d-02,-5.0164312562893d-01,
     |  -8.0539258353014d-01,-9.5439509500325d-01,-9.1898841776700d-01,
     |  -7.0439321898599d-01,-3.5204233894099d-01, 6.7188410042721d-02,
     |   4.6683134770175d-01, 7.6293813120219d-01, 8.9242631561855d-01,
     |   8.2738011447314d-01, 5.8182424210431d-01, 2.0918265000797d-01,
     |  -2.0918265000797d-01,-5.8182424210431d-01,-8.2738011447314d-01,
     |  -8.9242631561855d-01,-7.6293813120219d-01,-4.6683134770175d-01,
     |  -6.7188410042723d-02, 3.5204233894099d-01, 7.0439321898599d-01,
     |   9.1898841776700d-01, 9.5439509500326d-01, 8.0539258353014d-01,
     |   5.0164312562894d-01, 9.9176376380157d-02,-3.3282982481174d-01,
     |  -7.2663802606590d-01,-1.0285927749571d+00,-1.2073052050471d+00,
     |  -1.2561888388315d+00,-1.1906035559178d+00,-1.0410669308991d+00,
     |  -8.4467585164947d-01,-6.3694150441095d-01,-4.4574990870733d-01,
     |  -2.8832790922835d-01,-1.7119323643109d-01,-9.2347722461655d-02,
     |  -4.4595989320364d-02,-1.8875389832058d-02,-6.7879435659381d-03,
     |  -1.9781099633151d-03,-4.3263276194829d-04,-6.1999948980986d-05,
     |  -4.4188353767699d-06,-7.6751040130199d-08,-1.1895411163720d-11/
      data (pmn(lat, 9,13), lat = 1,72)/
     |   1.5125593910615d-13, 2.9343700334988d-09, 2.8284745645193d-07,
     |   5.5942629539075d-06, 5.0657960394461d-05, 2.8646369024357d-04,
     |   1.1787750804300d-03, 3.8489134979090d-03, 1.0522059226839d-02,
     |   2.4952012497978d-02, 5.2598793268440d-02, 1.0029481750879d-01,
     |   1.7518955983478d-01, 2.8292893694719d-01, 4.2528154843482d-01,
     |   5.9770509229425d-01, 7.8756034656573d-01, 9.7373332818600d-01,
     |   1.1282559371291d+00, 1.2201177591782d+00, 1.2209047426893d+00,
     |   1.1113156512832d+00, 8.8715949796580d-01, 5.6328017888596d-01,
     |   1.7408280599832d-01,-2.3005077848541d-01,-5.9028014522983d-01,
     |  -8.4961238935456d-01,-9.6404556389819d-01,-9.1218215384136d-01,
     |  -7.0106128975313d-01,-3.6662527299919d-01, 3.1668334665328d-02,
     |   4.2129297717101d-01, 7.3018923206639d-01, 9.0065082475034d-01,
     |   9.0065082475034d-01, 7.3018923206639d-01, 4.2129297717101d-01,
     |   3.1668334665329d-02,-3.6662527299919d-01,-7.0106128975313d-01,
     |  -9.1218215384136d-01,-9.6404556389819d-01,-8.4961238935456d-01,
     |  -5.9028014522983d-01,-2.3005077848541d-01, 1.7408280599832d-01,
     |   5.6328017888596d-01, 8.8715949796580d-01, 1.1113156512832d+00,
     |   1.2209047426893d+00, 1.2201177591782d+00, 1.1282559371291d+00,
     |   9.7373332818600d-01, 7.8756034656573d-01, 5.9770509229426d-01,
     |   4.2528154843482d-01, 2.8292893694719d-01, 1.7518955983478d-01,
     |   1.0029481750879d-01, 5.2598793268440d-02, 2.4952012497978d-02,
     |   1.0522059226839d-02, 3.8489134979090d-03, 1.1787750804300d-03,
     |   2.8646369024357d-04, 5.0657960394461d-05, 5.5942629539075d-06,
     |   2.8284745645193d-07, 2.9343700334988d-09, 1.5125593910615d-13/
      data (pmn(lat,10,13), lat = 1,72)/
     |   1.5829474013225d-15, 9.2302551929024d-11, 1.4885216066637d-08,
     |   4.1455062387416d-07, 4.8641283837707d-06, 3.3952012581890d-05,
     |   1.6711813748386d-04, 6.3876774287770d-04, 2.0129007293466d-03,
     |   5.4410411315706d-03, 1.2968201225268d-02, 2.7798202903806d-02,
     |   5.4380328522065d-02, 9.8157799515364d-02, 1.6484734390388d-01,
     |   2.5920947067194d-01, 3.8341347353560d-01, 5.3527028303715d-01,
     |   7.0675312548402d-01, 8.8329729132938d-01, 1.0443225301447d+00,
     |   1.1652366821058d+00, 1.2208757754801d+00, 1.1899709041688d+00,
     |   1.0598913232816d+00, 8.3069091972834d-01, 5.1745992052449d-01,
     |   1.5019366359458d-01,-2.2918210246341d-01,-5.7242016246436d-01,
     |  -8.3239406489889d-01,-9.7109708699289d-01,-9.6668430744473d-01,
     |  -8.1812009883774d-01,-5.4638697715640d-01,-1.9185257622772d-01,
     |   1.9185257622772d-01, 5.4638697715640d-01, 8.1812009883774d-01,
     |   9.6668430744472d-01, 9.7109708699289d-01, 8.3239406489889d-01,
     |   5.7242016246436d-01, 2.2918210246342d-01,-1.5019366359458d-01,
     |  -5.1745992052449d-01,-8.3069091972834d-01,-1.0598913232816d+00,
     |  -1.1899709041688d+00,-1.2208757754801d+00,-1.1652366821058d+00,
     |  -1.0443225301447d+00,-8.8329729132938d-01,-7.0675312548402d-01,
     |  -5.3527028303715d-01,-3.8341347353560d-01,-2.5920947067194d-01,
     |  -1.6484734390388d-01,-9.8157799515363d-02,-5.4380328522065d-02,
     |  -2.7798202903806d-02,-1.2968201225268d-02,-5.4410411315707d-03,
     |  -2.0129007293466d-03,-6.3876774287770d-04,-1.6711813748386d-04,
     |  -3.3952012581891d-05,-4.8641283837707d-06,-4.1455062387416d-07,
     |  -1.4885216066637d-08,-9.2302551929024d-11,-1.5829474013225d-15/
      data (pmn(lat,11,13), lat = 1,72)/
     |   1.3322506001952d-17, 2.3343361862704d-12, 6.2947323825713d-10,
     |   2.4664801940304d-08, 3.7457893225542d-07, 3.2226714861704d-06,
     |   1.8940294038526d-05, 8.4558238026583d-05, 3.0632644860588d-04,
     |   9.4078624962819d-04, 2.5253507991569d-03, 6.0569078115593d-03,
     |   1.3194722152894d-02, 2.6435368360180d-02, 4.9180557770982d-02,
     |   8.5604738255052d-02, 1.4023954752471d-01, 2.1723388827347d-01,
     |   3.1932091794881d-01, 4.4661574508146d-01, 5.9545956490102d-01,
     |   7.5759095495263d-01, 9.1993735236371d-01, 1.0652619920580d+00,
     |   1.1737715908383d+00, 1.2256043898102d+00, 1.2039111129628d+00,
     |   1.0980588358372d+00, 9.0637694338878d-01, 6.3786200765875d-01,
     |   3.1238009828585d-01,-4.0861146767888d-02,-3.8649170974808d-01,
     |  -6.8741088032960d-01,-9.0980730327842d-01,-1.0279522400115d+00,
     |  -1.0279522400115d+00,-9.0980730327842d-01,-6.8741088032960d-01,
     |  -3.8649170974808d-01,-4.0861146767889d-02, 3.1238009828585d-01,
     |   6.3786200765875d-01, 9.0637694338877d-01, 1.0980588358372d+00,
     |   1.2039111129628d+00, 1.2256043898102d+00, 1.1737715908383d+00,
     |   1.0652619920580d+00, 9.1993735236371d-01, 7.5759095495263d-01,
     |   5.9545956490102d-01, 4.4661574508146d-01, 3.1932091794881d-01,
     |   2.1723388827347d-01, 1.4023954752472d-01, 8.5604738255052d-02,
     |   4.9180557770981d-02, 2.6435368360180d-02, 1.3194722152894d-02,
     |   6.0569078115593d-03, 2.5253507991569d-03, 9.4078624962820d-04,
     |   3.0632644860589d-04, 8.4558238026584d-05, 1.8940294038526d-05,
     |   3.2226714861705d-06, 3.7457893225542d-07, 2.4664801940304d-08,
     |   6.2947323825713d-10, 2.3343361862704d-12, 1.3322506001952d-17/
      data (pmn(lat,12,13), lat = 1,72)/
     |   8.5649452649914d-20, 4.5086268184571d-14, 2.0321365378654d-11,
     |   1.1195936956651d-09, 2.1988492605855d-08, 2.3291951311259d-07,
     |   1.6322982112781d-06, 8.4976944376761d-06, 3.5319751882269d-05,
     |   1.2295479688310d-04, 3.7067529871700d-04, 9.9146251861095d-04,
     |   2.3957700399783d-03, 5.3028191507077d-03, 1.0867932617412d-02,
     |   2.0800699808916d-02, 3.7434943037224d-02, 6.3702062103621d-02,
     |   1.0295941163504d-01, 1.5863896337272d-01, 2.3371005834326d-01,
     |   3.2999112738071d-01, 4.4739215092342d-01, 5.8321214792188d-01,
     |   7.3164241161662d-01, 8.8362611622653d-01, 1.0271921671321d+00,
     |   1.1483163118468d+00, 1.2322738454347d+00, 1.2653509249201d+00,
     |   1.2366949957201d+00, 1.1400287644940d+00, 9.7494179532679d-01,
     |   7.4751610360568d-01, 4.7013337497360d-01, 1.6043731627704d-01,
     |  -1.6043731627703d-01,-4.7013337497360d-01,-7.4751610360568d-01,
     |  -9.7494179532679d-01,-1.1400287644940d+00,-1.2366949957201d+00,
     |  -1.2653509249201d+00,-1.2322738454347d+00,-1.1483163118468d+00,
     |  -1.0271921671321d+00,-8.8362611622653d-01,-7.3164241161662d-01,
     |  -5.8321214792188d-01,-4.4739215092342d-01,-3.2999112738071d-01,
     |  -2.3371005834326d-01,-1.5863896337272d-01,-1.0295941163504d-01,
     |  -6.3702062103621d-02,-3.7434943037224d-02,-2.0800699808916d-02,
     |  -1.0867932617412d-02,-5.3028191507077d-03,-2.3957700399784d-03,
     |  -9.9146251861095d-04,-3.7067529871700d-04,-1.2295479688310d-04,
     |  -3.5319751882270d-05,-8.4976944376761d-06,-1.6322982112781d-06,
     |  -2.3291951311259d-07,-2.1988492605855d-08,-1.1195936956651d-09,
     |  -2.0321365378654d-11,-4.5086268184571d-14,-8.5649452649914d-20/
      data (pmn(lat,13,13), lat = 1,72)/
     |   3.6651707257319d-22, 5.7954478000244d-16, 4.3646655219753d-13,
     |   3.3795115101887d-11, 8.5776944129773d-10, 1.1177647409346d-08,
     |   9.3306475913103d-08, 5.6571240013872d-07, 2.6936747907562d-06,
     |   1.0610158542835d-05, 3.5849407443487d-05, 1.0667442289565d-04,
     |   2.8511146986742d-04, 6.9488466710253d-04, 1.5627902317874d-03,
     |   3.2740268058007d-03, 6.4384071976198d-03, 1.1959447861268d-02,
     |   2.1092840348132d-02, 3.5476049462963d-02, 5.7108370896534d-02,
     |   8.8262284484486d-02, 1.3131341612998d-01, 1.8848797732345d-01,
     |   2.6154204990263d-01, 3.5140412883097d-01, 4.5782758302138d-01,
     |   5.7910947179456d-01, 7.1193328022376d-01, 8.5138374998743d-01,
     |   9.9116218192834d-01, 1.1240026861285d+00, 1.2422581515763d+00,
     |   1.3385947631670d+00, 1.4067114634941d+00, 1.4419905806501d+00,
     |   1.4419905806501d+00, 1.4067114634941d+00, 1.3385947631670d+00,
     |   1.2422581515763d+00, 1.1240026861285d+00, 9.9116218192834d-01,
     |   8.5138374998743d-01, 7.1193328022376d-01, 5.7910947179456d-01,
     |   4.5782758302138d-01, 3.5140412883098d-01, 2.6154204990263d-01,
     |   1.8848797732345d-01, 1.3131341612998d-01, 8.8262284484486d-02,
     |   5.7108370896535d-02, 3.5476049462963d-02, 2.1092840348132d-02,
     |   1.1959447861268d-02, 6.4384071976199d-03, 3.2740268058007d-03,
     |   1.5627902317874d-03, 6.9488466710253d-04, 2.8511146986742d-04,
     |   1.0667442289565d-04, 3.5849407443487d-05, 1.0610158542835d-05,
     |   2.6936747907563d-06, 5.6571240013873d-07, 9.3306475913103d-08,
     |   1.1177647409346d-08, 8.5776944129773d-10, 3.3795115101887d-11,
     |   4.3646655219753d-13, 5.7954478000244d-16, 3.6651707257319d-22/
      data (pmn(lat, 0,14), lat = 1,72)/
     |   3.7133254202773d+00, 2.9983380302646d+00, 1.7748391453846d+00,
     |   3.8967778071715d-01,-7.7996768514377d-01,-1.4438719244433d+00,
     |  -1.4846213246710d+00,-9.8458125835400d-01,-1.8686584079974d-01,
     |   5.9439377539319d-01, 1.0824914559694d+00, 1.1279747452198d+00,
     |   7.5017668729648d-01, 1.1843837133062d-01,-5.1768136385372d-01,
     |  -9.2250433591186d-01,-9.5843385642637d-01,-6.3083881794177d-01,
     |  -7.9253699495823d-02, 4.7977753676379d-01, 8.3569620221306d-01,
     |   8.6165380871009d-01, 5.5873910608311d-01, 5.1512644501488d-02,
     |  -4.6211675217536d-01,-7.8695519959782d-01,-8.0372000377285d-01,
     |  -5.1224466909693d-01,-2.9208964854539d-02, 4.5793605863404d-01,
     |   7.6291500156830d-01, 7.7113208193673d-01, 4.8230111391689d-01,
     |   9.4800097201711d-03,-4.6474399535172d-01,-7.5811241614997d-01,
     |  -7.5811241614997d-01,-4.6474399535172d-01, 9.4800097201696d-03,
     |   4.8230111391689d-01, 7.7113208193673d-01, 7.6291500156830d-01,
     |   4.5793605863404d-01,-2.9208964854535d-02,-5.1224466909693d-01,
     |  -8.0372000377285d-01,-7.8695519959782d-01,-4.6211675217536d-01,
     |   5.1512644501486d-02, 5.5873910608311d-01, 8.6165380871009d-01,
     |   8.3569620221306d-01, 4.7977753676380d-01,-7.9253699495821d-02,
     |  -6.3083881794177d-01,-9.5843385642637d-01,-9.2250433591187d-01,
     |  -5.1768136385372d-01, 1.1843837133062d-01, 7.5017668729647d-01,
     |   1.1279747452198d+00, 1.0824914559694d+00, 5.9439377539319d-01,
     |  -1.8686584079973d-01,-9.8458125835400d-01,-1.4846213246710d+00,
     |  -1.4438719244433d+00,-7.7996768514377d-01, 3.8967778071715d-01,
     |   1.7748391453846d+00, 2.9983380302646d+00, 3.7133254202773d+00/
      data (pmn(lat, 1,14), lat = 1,72)/
     |   5.9447118155637d-01, 1.6107986054484d+00, 2.1646904059583d+00,
     |   2.1139485319876d+00, 1.5068003754670d+00, 5.6145953778409d-01,
     |  -4.0976751761283d-01,-1.1052983039054d+00,-1.3320894479466d+00,
     |  -1.0636342219817d+00,-4.3969628556668d-01, 2.9020288782528d-01,
     |   8.5820010177126d-01, 1.0716081092904d+00, 8.7599767012263d-01,
     |   3.6695974538187d-01,-2.5164479897733d-01,-7.4617090926783d-01,
     |  -9.3911765450212d-01,-7.7145146403804d-01,-3.1966718013720d-01,
     |   2.3714539371028d-01, 6.8674922487657d-01, 8.6333547819686d-01,
     |   7.0779996163995d-01, 2.8703096124399d-01,-2.3398057971092d-01,
     |  -6.5592218138979d-01,-8.2051746210795d-01,-6.6927161923169d-01,
     |  -2.6399263693780d-01, 2.3804868102687d-01, 6.4450870442773d-01,
     |   8.0096230500573d-01, 6.4904553537448d-01, 2.4803806060814d-01,
     |  -2.4803806060814d-01,-6.4904553537448d-01,-8.0096230500573d-01,
     |  -6.4450870442773d-01,-2.3804868102687d-01, 2.6399263693781d-01,
     |   6.6927161923168d-01, 8.2051746210795d-01, 6.5592218138979d-01,
     |   2.3398057971092d-01,-2.8703096124399d-01,-7.0779996163995d-01,
     |  -8.6333547819686d-01,-6.8674922487657d-01,-2.3714539371028d-01,
     |   3.1966718013719d-01, 7.7145146403804d-01, 9.3911765450212d-01,
     |   7.4617090926783d-01, 2.5164479897734d-01,-3.6695974538187d-01,
     |  -8.7599767012263d-01,-1.0716081092904d+00,-8.5820010177126d-01,
     |  -2.9020288782528d-01, 4.3969628556668d-01, 1.0636342219817d+00,
     |   1.3320894479466d+00, 1.1052983039054d+00, 4.0976751761283d-01,
     |  -5.6145953778408d-01,-1.5068003754670d+00,-2.1139485319876d+00,
     |  -2.1646904059583d+00,-1.6107986054484d+00,-5.9447118155637d-01/
      data (pmn(lat, 2,14), lat = 1,72)/
     |   4.6959492955202d-02, 3.9536458649433d-01, 9.5765045518880d-01,
     |   1.5130918343779d+00, 1.8341993791600d+00, 1.7689863199309d+00,
     |   1.2967857189999d+00, 5.3776314282655d-01,-2.8726407204013d-01,
     |  -9.3246277796134d-01,-1.2113281651080d+00,-1.0600297842856d+00,
     |  -5.5765071640747d-01, 1.0339713467375d-01, 6.8584074061404d-01,
     |   9.9033417665871d-01, 9.2323845133973d-01, 5.2577274570553d-01,
     |  -4.5036381663600d-02,-5.7589852131138d-01,-8.7528283609793d-01,
     |  -8.4167334242796d-01,-4.9778494446839d-01, 2.0890045355902d-02,
     |   5.1818238722700d-01, 8.1035876334712d-01, 7.9329765830712d-01,
     |   4.7932906688693d-01,-9.2758478298214d-03,-4.8718442683952d-01,
     |  -7.7553229957684d-01,-7.6826420015365d-01,-4.7085784344291d-01,
     |   2.6390475720353d-03, 4.7287232866490d-01, 7.6249900623376d-01,
     |   7.6249900623376d-01, 4.7287232866490d-01, 2.6390475720368d-03,
     |  -4.7085784344291d-01,-7.6826420015365d-01,-7.7553229957684d-01,
     |  -4.8718442683952d-01,-9.2758478298255d-03, 4.7932906688693d-01,
     |   7.9329765830711d-01, 8.1035876334712d-01, 5.1818238722701d-01,
     |   2.0890045355904d-02,-4.9778494446839d-01,-8.4167334242796d-01,
     |  -8.7528283609793d-01,-5.7589852131138d-01,-4.5036381663603d-02,
     |   5.2577274570553d-01, 9.2323845133973d-01, 9.9033417665871d-01,
     |   6.8584074061404d-01, 1.0339713467375d-01,-5.5765071640747d-01,
     |  -1.0600297842856d+00,-1.2113281651080d+00,-9.3246277796134d-01,
     |  -2.8726407204014d-01, 5.3776314282654d-01, 1.2967857189999d+00,
     |   1.7689863199309d+00, 1.8341993791600d+00, 1.5130918343779d+00,
     |   9.5765045518880d-01, 3.9536458649433d-01, 4.6959492955202d-02/
      data (pmn(lat, 3,14), lat = 1,72)/
     |   2.4439835307482d-03, 6.2811233833066d-02, 2.6306827574711d-01,
     |   6.1857811746657d-01, 1.0609353569961d+00, 1.4576577515182d+00,
     |   1.6597542361484d+00, 1.5597464565682d+00, 1.1382088367789d+00,
     |   4.8052147459861d-01,-2.4392403684836d-01,-8.3415260083182d-01,
     |  -1.1239388452085d+00,-1.0387258724962d+00,-6.2258854581738d-01,
     |  -2.4970177387483d-02, 5.4892937262036d-01, 9.0726578904285d-01,
     |   9.3620595212360d-01, 6.3753586124590d-01, 1.2604975836162d-01,
     |  -4.1229295214094d-01,-7.8659860221336d-01,-8.6820836332093d-01,
     |  -6.3508988002144d-01,-1.7791402299372d-01, 3.3401953498001d-01,
     |   7.1452426161384d-01, 8.2764088041036d-01, 6.3603293156746d-01,
     |   2.1342157246808d-01,-2.8316855274593d-01,-6.7109294979474d-01,
     |  -8.0869581389508d-01,-6.4669786755383d-01,-2.4579848893495d-01,
     |   2.4579848893495d-01, 6.4669786755382d-01, 8.0869581389508d-01,
     |   6.7109294979474d-01, 2.8316855274593d-01,-2.1342157246808d-01,
     |  -6.3603293156746d-01,-8.2764088041036d-01,-7.1452426161385d-01,
     |  -3.3401953498002d-01, 1.7791402299372d-01, 6.3508988002144d-01,
     |   8.6820836332093d-01, 7.8659860221336d-01, 4.1229295214094d-01,
     |  -1.2604975836161d-01,-6.3753586124590d-01,-9.3620595212360d-01,
     |  -9.0726578904285d-01,-5.4892937262037d-01, 2.4970177387481d-02,
     |   6.2258854581738d-01, 1.0387258724962d+00, 1.1239388452085d+00,
     |   8.3415260083182d-01, 2.4392403684836d-01,-4.8052147459860d-01,
     |  -1.1382088367789d+00,-1.5597464565682d+00,-1.6597542361484d+00,
     |  -1.4576577515182d+00,-1.0609353569961d+00,-6.1857811746657d-01,
     |  -2.6306827574711d-01,-6.2811233833066d-02,-2.4439835307482d-03/
      data (pmn(lat, 4,14), lat = 1,72)/
     |   9.3905038070048d-05, 7.3163131785538d-03, 5.2189495899184d-02,
     |   1.7784672852560d-01, 4.1250686721177d-01, 7.4446527393500d-01,
     |   1.1117954066398d+00, 1.4134067127346d+00, 1.5396180736409d+00,
     |   1.4121449737825d+00, 1.0186341273239d+00, 4.2764490224092d-01,
     |  -2.2374121764016d-01,-7.6782001048239d-01,-1.0582137216138d+00,
     |  -1.0184935406628d+00,-6.7022336723107d-01,-1.2956091133612d-01,
     |   4.2786410011802d-01, 8.2296185845243d-01, 9.3158289075648d-01,
     |   7.2542721110418d-01, 2.8115921305211d-01,-2.4585028367826d-01,
     |  -6.7454278290822d-01,-8.5995668325889d-01,-7.4255849631877d-01,
     |  -3.6805612285238d-01, 1.2921121352352d-01, 5.7356007128986d-01,
     |   8.0946345095699d-01, 7.5580032280218d-01, 4.3389534357780d-01,
     |  -4.0443658087925d-02,-4.9805738955571d-01,-7.7625273690492d-01,
     |  -7.7625273690492d-01,-4.9805738955571d-01,-4.0443658087927d-02,
     |   4.3389534357780d-01, 7.5580032280218d-01, 8.0946345095699d-01,
     |   5.7356007128986d-01, 1.2921121352352d-01,-3.6805612285238d-01,
     |  -7.4255849631877d-01,-8.5995668325889d-01,-6.7454278290823d-01,
     |  -2.4585028367826d-01, 2.8115921305211d-01, 7.2542721110418d-01,
     |   9.3158289075648d-01, 8.2296185845243d-01, 4.2786410011802d-01,
     |  -1.2956091133612d-01,-6.7022336723106d-01,-1.0184935406628d+00,
     |  -1.0582137216138d+00,-7.6782001048239d-01,-2.2374121764017d-01,
     |   4.2764490224092d-01, 1.0186341273239d+00, 1.4121449737825d+00,
     |   1.5396180736409d+00, 1.4134067127346d+00, 1.1117954066398d+00,
     |   7.4446527393501d-01, 4.1250686721177d-01, 1.7784672852560d-01,
     |   5.2189495899184d-02, 7.3163131785538d-03, 9.3905038070048d-05/
      data (pmn(lat, 5,14), lat = 1,72)/
     |   2.8263920650033d-06, 6.6530114867459d-04, 8.0246613245785d-03,
     |   3.9157170074686d-02, 1.2056056885155d-01, 2.7770977258093d-01,
     |   5.1946752027248d-01, 8.2432363587346d-01, 1.1358747165185d+00,
     |   1.3721086244116d+00, 1.4478330128322d+00, 1.3039359949918d+00,
     |   9.3336208591476d-01, 3.9343866856481d-01,-2.0205775304596d-01,
     |  -7.1102270777971d-01,-1.0039189078522d+00,-1.0047185891520d+00,
     |  -7.1799363714092d-01,-2.3194776601526d-01, 3.0525989031478d-01,
     |   7.2959100518882d-01, 9.1202086612241d-01, 7.9971348429309d-01,
     |   4.3354257586107d-01,-6.4509161526906d-02,-5.3060897200005d-01,
     |  -8.1248124990094d-01,-8.1942898753548d-01,-5.5225838738292d-01,
     |  -1.0290968757324d-01, 3.7632186830957d-01, 7.2383506977697d-01,
     |   8.2297477089436d-01, 6.4122599393579d-01, 2.4108940839537d-01,
     |  -2.4108940839537d-01,-6.4122599393579d-01,-8.2297477089436d-01,
     |  -7.2383506977697d-01,-3.7632186830957d-01, 1.0290968757324d-01,
     |   5.5225838738292d-01, 8.1942898753548d-01, 8.1248124990095d-01,
     |   5.3060897200005d-01, 6.4509161526908d-02,-4.3354257586106d-01,
     |  -7.9971348429309d-01,-9.1202086612241d-01,-7.2959100518882d-01,
     |  -3.0525989031479d-01, 2.3194776601525d-01, 7.1799363714092d-01,
     |   1.0047185891520d+00, 1.0039189078522d+00, 7.1102270777972d-01,
     |   2.0205775304596d-01,-3.9343866856482d-01,-9.3336208591476d-01,
     |  -1.3039359949918d+00,-1.4478330128322d+00,-1.3721086244116d+00,
     |  -1.1358747165185d+00,-8.2432363587346d-01,-5.1946752027248d-01,
     |  -2.7770977258093d-01,-1.2056056885155d-01,-3.9157170074686d-02,
     |  -8.0246613245785d-03,-6.6530114867459d-04,-2.8263920650033d-06/
      data (pmn(lat, 6,14), lat = 1,72)/
     |   6.8984352824194d-08, 4.8964119440209d-05, 9.9460595609995d-04,
     |   6.9045466799640d-03, 2.7948935762822d-02, 8.1043753532768d-02,
     |   1.8612143948550d-01, 3.5786957703563d-01, 5.9530087132571d-01,
     |   8.7344284183175d-01, 1.1417546975746d+00, 1.3321700354520d+00,
     |   1.3763289827443d+00, 1.2277425082304d+00, 8.8181200284154d-01,
     |   3.8607989106079d-01,-1.6465730729135d-01,-6.4917178096176d-01,
     |  -9.5189364709748d-01,-9.9712783235452d-01,-7.7450048101275d-01,
     |  -3.4657126632243d-01, 1.6535098838001d-01, 6.1429206158559d-01,
     |   8.7030945553157d-01, 8.5980994192787d-01, 5.8888543337232d-01,
     |   1.4264151619429d-01,-3.4007912617045d-01,-7.0925589675852d-01,
     |  -8.5041407426316d-01,-7.2071733778718d-01,-3.6274581762660d-01,
     |   1.0873113945732d-01, 5.4303127433077d-01, 8.0144488552283d-01,
     |   8.0144488552283d-01, 5.4303127433077d-01, 1.0873113945732d-01,
     |  -3.6274581762660d-01,-7.2071733778718d-01,-8.5041407426316d-01,
     |  -7.0925589675852d-01,-3.4007912617045d-01, 1.4264151619429d-01,
     |   5.8888543337232d-01, 8.5980994192787d-01, 8.7030945553157d-01,
     |   6.1429206158560d-01, 1.6535098838001d-01,-3.4657126632243d-01,
     |  -7.7450048101274d-01,-9.9712783235452d-01,-9.5189364709748d-01,
     |  -6.4917178096176d-01,-1.6465730729135d-01, 3.8607989106079d-01,
     |   8.8181200284155d-01, 1.2277425082304d+00, 1.3763289827443d+00,
     |   1.3321700354520d+00, 1.1417546975746d+00, 8.7344284183176d-01,
     |   5.9530087132572d-01, 3.5786957703563d-01, 1.8612143948550d-01,
     |   8.1043753532769d-02, 2.7948935762822d-02, 6.9045466799640d-03,
     |   9.9460595609995d-04, 4.8964119440209d-05, 6.8984352824194d-08/
      data (pmn(lat, 7,14), lat = 1,72)/
     |   1.3940415037403d-09, 2.9800336229422d-06, 1.0169027131731d-04,
     |   1.0003607045968d-03, 5.2938160408150d-03, 1.9173289546409d-02,
     |   5.3485911289597d-02, 1.2278960831754d-01, 2.4151601475768d-01,
     |   4.1753169944182d-01, 6.4485496981917d-01, 8.9839783680648d-01,
     |   1.1337495095293d+00, 1.2938972015526d+00, 1.3225777667727d+00,
     |   1.1813400856064d+00, 8.6532681676421d-01, 4.1215274287197d-01,
     |  -1.0045021971162d-01,-5.6950171177319d-01,-8.9146595852883d-01,
     |  -9.9046466225171d-01,-8.4174297743741d-01,-4.8267194196313d-01,
     |  -6.7096199987007d-03, 4.5933154716037d-01, 7.8912707414483d-01,
     |   8.9235346642577d-01, 7.4131170089789d-01, 3.8024765241178d-01,
     |  -8.6136887053606d-02,-5.2225533247089d-01,-8.0093079342732d-01,
     |  -8.4083515593656d-01,-6.3078003326464d-01,-2.3336088422446d-01,
     |   2.3336088422446d-01, 6.3078003326464d-01, 8.4083515593656d-01,
     |   8.0093079342732d-01, 5.2225533247089d-01, 8.6136887053605d-02,
     |  -3.8024765241178d-01,-7.4131170089789d-01,-8.9235346642578d-01,
     |  -7.8912707414483d-01,-4.5933154716037d-01, 6.7096199986976d-03,
     |   4.8267194196313d-01, 8.4174297743741d-01, 9.9046466225171d-01,
     |   8.9146595852884d-01, 5.6950171177319d-01, 1.0045021971162d-01,
     |  -4.1215274287197d-01,-8.6532681676421d-01,-1.1813400856064d+00,
     |  -1.3225777667727d+00,-1.2938972015526d+00,-1.1337495095293d+00,
     |  -8.9839783680648d-01,-6.4485496981917d-01,-4.1753169944182d-01,
     |  -2.4151601475768d-01,-1.2278960831754d-01,-5.3485911289597d-02,
     |  -1.9173289546409d-02,-5.2938160408150d-03,-1.0003607045968d-03,
     |  -1.0169027131731d-04,-2.9800336229422d-06,-1.3940415037403d-09/
      data (pmn(lat, 8,14), lat = 1,72)/
     |   2.3597798005842d-11, 1.5180536329819d-07, 8.6879601898769d-06,
     |   1.2080226712778d-04, 8.3271612040049d-04, 3.7486591495650d-03,
     |   1.2620501421792d-02, 3.4299970329041d-02, 7.8875761094648d-02,
     |   1.5823691115686d-01, 2.8268906484580d-01, 4.5601401802587d-01,
     |   6.7026715425976d-01, 9.0227952425441d-01, 1.1139026858420d+00,
     |   1.2573015609927d+00, 1.2851448653703d+00, 1.1637528578889d+00,
     |   8.8573719103608d-01, 4.7802219965699d-01, 1.7723704710821d-03,
     |  -4.5732591072130d-01,-8.0721536372236d-01,-9.7203446395053d-01,
     |  -9.1316133451745d-01,-6.4249627132418d-01,-2.2334902180996d-01,
     |   2.4250409065691d-01, 6.3909086489768d-01, 8.6582907717491d-01,
     |   8.6444983476945d-01, 6.3556882858246d-01, 2.3980264885378d-01,
     |  -2.1745347105930d-01,-6.1381943511114d-01,-8.4282637957726d-01,
     |  -8.4282637957726d-01,-6.1381943511114d-01,-2.1745347105930d-01,
     |   2.3980264885378d-01, 6.3556882858246d-01, 8.6444983476945d-01,
     |   8.6582907717491d-01, 6.3909086489768d-01, 2.4250409065691d-01,
     |  -2.2334902180996d-01,-6.4249627132418d-01,-9.1316133451745d-01,
     |  -9.7203446395053d-01,-8.0721536372236d-01,-4.5732591072130d-01,
     |   1.7723704710750d-03, 4.7802219965699d-01, 8.8573719103608d-01,
     |   1.1637528578889d+00, 1.2851448653703d+00, 1.2573015609927d+00,
     |   1.1139026858420d+00, 9.0227952425441d-01, 6.7026715425976d-01,
     |   4.5601401802587d-01, 2.8268906484580d-01, 1.5823691115686d-01,
     |   7.8875761094649d-02, 3.4299970329041d-02, 1.2620501421792d-02,
     |   3.7486591495651d-03, 8.3271612040049d-04, 1.2080226712778d-04,
     |   8.6879601898769d-06, 1.5180536329819d-07, 2.3597798005842d-11/
      data (pmn(lat, 9,14), lat = 1,72)/
     |   3.3609631152876d-13, 6.5028912707561d-09, 6.2346805018642d-07,
     |   1.2231623779431d-05, 1.0955814533717d-04, 6.1101680107349d-04,
     |   2.4721304635520d-03, 7.9109228680758d-03, 2.1121718165254d-02,
     |   4.8734407100339d-02, 9.9541490196940d-02, 1.8305733509947d-01,
     |   3.0675845851832d-01, 4.7235082214572d-01, 6.7198077884121d-01,
     |   8.8573237897037d-01, 1.0818113929480d+00, 1.2203675332196d+00,
     |   1.2609745412939d+00, 1.1725852596572d+00, 9.4366564153764d-01,
     |   5.8959214956344d-01, 1.5458228234897d-01,-2.9348929757135d-01,
     |  -6.7524862095389d-01,-9.1677435407400d-01,-9.6747213254263d-01,
     |  -8.1422179505868d-01,-4.8763059238588d-01,-5.7961263864848d-02,
     |   3.7909884885540d-01, 7.2388967638257d-01, 8.9635919049001d-01,
     |   8.5580644776028d-01, 6.1154820222909d-01, 2.2147003449367d-01,
     |  -2.2147003449367d-01,-6.1154820222909d-01,-8.5580644776028d-01,
     |  -8.9635919049001d-01,-7.2388967638257d-01,-3.7909884885540d-01,
     |   5.7961263864847d-02, 4.8763059238588d-01, 8.1422179505868d-01,
     |   9.6747213254263d-01, 9.1677435407400d-01, 6.7524862095389d-01,
     |   2.9348929757135d-01,-1.5458228234897d-01,-5.8959214956344d-01,
     |  -9.4366564153763d-01,-1.1725852596572d+00,-1.2609745412939d+00,
     |  -1.2203675332196d+00,-1.0818113929480d+00,-8.8573237897037d-01,
     |  -6.7198077884120d-01,-4.7235082214572d-01,-3.0675845851832d-01,
     |  -1.8305733509947d-01,-9.9541490196940d-02,-4.8734407100339d-02,
     |  -2.1121718165254d-02,-7.9109228680758d-03,-2.4721304635520d-03,
     |  -6.1101680107350d-04,-1.0955814533717d-04,-1.2231623779431d-05,
     |  -6.2346805018642d-07,-6.5028912707561d-09,-3.3609631152876d-13/
      data (pmn(lat,10,14), lat = 1,72)/
     |   4.0172389511479d-15, 2.3367970900064d-10, 3.7501373621722d-08,
     |   1.0367588411668d-06, 1.2045180355932d-05, 8.3032748619092d-05,
     |   4.0253903698186d-04, 1.5111184372637d-03, 4.6628491890790d-03,
     |   1.2302739564337d-02, 2.8523432055779d-02, 5.9254318334137d-02,
     |   1.1187644573176d-01, 1.9400596485685d-01, 3.1137998853114d-01,
     |   4.6509359056308d-01, 6.4879714802003d-01, 8.4674487536543d-01,
     |   1.0336540901216d+00, 1.1770963767316d+00, 1.2425881183522d+00,
     |   1.2007800429439d+00, 1.0353624928834d+00, 7.4975305928525d-01,
     |   3.7053826848010d-01,-5.3880673109232d-02,-4.5997792908315d-01,
     |  -7.8033866063771d-01,-9.5733932086324d-01,-9.5625819457065d-01,
     |  -7.7459088974003d-01,-4.4497092264695d-01,-3.0463555712232d-02,
     |   3.8720048284997d-01, 7.2411107904130d-01, 9.1177119602761d-01,
     |   9.1177119602761d-01, 7.2411107904130d-01, 3.8720048284997d-01,
     |  -3.0463555712231d-02,-4.4497092264695d-01,-7.7459088974003d-01,
     |  -9.5625819457065d-01,-9.5733932086324d-01,-7.8033866063771d-01,
     |  -4.5997792908315d-01,-5.3880673109234d-02, 3.7053826848010d-01,
     |   7.4975305928525d-01, 1.0353624928834d+00, 1.2007800429439d+00,
     |   1.2425881183522d+00, 1.1770963767316d+00, 1.0336540901216d+00,
     |   8.4674487536543d-01, 6.4879714802003d-01, 4.6509359056308d-01,
     |   3.1137998853114d-01, 1.9400596485685d-01, 1.1187644573176d-01,
     |   5.9254318334137d-02, 2.8523432055779d-02, 1.2302739564337d-02,
     |   4.6628491890791d-03, 1.5111184372637d-03, 4.0253903698186d-04,
     |   8.3032748619093d-05, 1.2045180355932d-05, 1.0367588411668d-06,
     |   3.7501373621722d-08, 2.3367970900064d-10, 4.0172389511479d-15/
      data (pmn(lat,11,14), lat = 1,72)/
     |   3.9846650805076d-17, 6.9663214500164d-12, 1.8701663846458d-09,
     |   7.2788185661398d-08, 1.0954866671148d-06, 9.3183029253072d-06,
     |   5.4014501594559d-05, 2.3724092253589d-04, 8.4331061117288d-04,
     |   2.5343368977443d-03, 6.6373577536914d-03, 1.5483457092604d-02,
     |   3.2696298284698d-02, 6.3266489301840d-02, 1.1321937888942d-01,
     |   1.8871799967046d-01, 2.9455771023108d-01, 4.3219681983078d-01,
     |   5.9768864822985d-01, 7.8006883951083d-01, 9.6083088408767d-01,
     |   1.1150308692408d+00, 1.2142777944287d+00, 1.2314240671958d+00,
     |   1.1462663137460d+00, 9.5113397274651d-01, 6.5502235595365d-01,
     |   2.8502107040266d-01,-1.1577326893009d-01,-4.9395430859688d-01,
     |  -7.9436435180225d-01,-9.7000184907733d-01,-9.9128987587677d-01,
     |  -8.5267829346450d-01,-5.7499599555872d-01,-2.0281843086534d-01,
     |   2.0281843086534d-01, 5.7499599555872d-01, 8.5267829346450d-01,
     |   9.9128987587677d-01, 9.7000184907733d-01, 7.9436435180225d-01,
     |   4.9395430859688d-01, 1.1577326893009d-01,-2.8502107040266d-01,
     |  -6.5502235595365d-01,-9.5113397274651d-01,-1.1462663137460d+00,
     |  -1.2314240671958d+00,-1.2142777944287d+00,-1.1150308692408d+00,
     |  -9.6083088408768d-01,-7.8006883951084d-01,-5.9768864822985d-01,
     |  -4.3219681983078d-01,-2.9455771023108d-01,-1.8871799967046d-01,
     |  -1.1321937888942d-01,-6.3266489301840d-02,-3.2696298284698d-02,
     |  -1.5483457092604d-02,-6.6373577536914d-03,-2.5343368977443d-03,
     |  -8.4331061117289d-04,-2.3724092253590d-04,-5.4014501594559d-05,
     |  -9.3183029253074d-06,-1.0954866671148d-06,-7.2788185661398d-08,
     |  -1.8701663846458d-09,-6.9663214500164d-12,-3.9846650805076d-17/
      data (pmn(lat,12,14), lat = 1,72)/
     |   3.1996470133273d-19, 1.6808558287326d-13, 7.5448790863976d-11,
     |   4.1311329953484d-09, 8.0463105203086d-08, 8.4346204220599d-07,
     |   5.8366099846975d-06, 2.9934969136813d-05, 1.2229046788014d-04,
     |   4.1740447356847d-04, 1.2306426146084d-03, 3.2104988973878d-03,
     |   7.5450238290080d-03, 1.6192714906627d-02, 3.2072720762955d-02,
     |   5.9115582637876d-02, 1.0205890205266d-01, 1.6588791347729d-01,
     |   2.5487919062022d-01, 3.7130539890611d-01, 5.1398376406430d-01,
     |   6.7697005878658d-01, 8.4877453147100d-01, 1.0124698608681d+00,
     |   1.1469523032698d+00, 1.2294092872185d+00, 1.2387730620635d+00,
     |   1.1596596278366d+00, 9.8607732908812d-01, 7.2410722059702d-01,
     |   3.9284975041502d-01, 2.3201626266081d-02,-3.4557035604122d-01,
     |  -6.7103729993819d-01,-9.1377358863572d-01,-1.0434015827254d+00,
     |  -1.0434015827254d+00,-9.1377358863572d-01,-6.7103729993819d-01,
     |  -3.4557035604122d-01, 2.3201626266080d-02, 3.9284975041502d-01,
     |   7.2410722059702d-01, 9.8607732908812d-01, 1.1596596278366d+00,
     |   1.2387730620635d+00, 1.2294092872185d+00, 1.1469523032698d+00,
     |   1.0124698608681d+00, 8.4877453147100d-01, 6.7697005878658d-01,
     |   5.1398376406430d-01, 3.7130539890611d-01, 2.5487919062022d-01,
     |   1.6588791347729d-01, 1.0205890205266d-01, 5.9115582637876d-02,
     |   3.2072720762955d-02, 1.6192714906627d-02, 7.5450238290081d-03,
     |   3.2104988973878d-03, 1.2306426146084d-03, 4.1740447356848d-04,
     |   1.2229046788014d-04, 2.9934969136814d-05, 5.8366099846975d-06,
     |   8.4346204220601d-07, 8.0463105203086d-08, 4.1311329953484d-09,
     |   7.5448790863976d-11, 1.6808558287326d-13, 3.1996470133273d-19/
      data (pmn(lat,13,14), lat = 1,72)/
     |   1.9732851402322d-21, 3.1142619724271d-15, 2.3364740703416d-12,
     |   1.7987414943441d-10, 4.5304726023999d-09, 5.8468453095387d-08,
     |   4.8239697072109d-07, 2.8847795619381d-06, 1.3519596813356d-05,
     |   5.2298566053795d-05, 1.7314573780795d-04, 5.0364388045704d-04,
     |   1.3126079655390d-03, 3.1114162069047d-03, 6.7869434009444d-03,
     |   1.3750278968445d-02, 2.6067702482194d-02, 4.6522838030944d-02,
     |   7.8547876470423d-02, 1.2596430787824d-01, 1.9249524599402d-01,
     |   2.8105358440677d-01, 3.9286837200175d-01, 5.2657499687441d-01,
     |   6.7744720916675d-01, 8.3697347173042d-01, 9.9296269576828d-01,
     |   1.1302992469774d+00, 1.2323597090437d+00, 1.2829717625643d+00,
     |   1.2686654924367d+00, 1.1808699568685d+00, 1.0176696862451d+00,
     |   7.8477268190898d-01, 4.9545310366761d-01, 1.6940036861782d-01,
     |  -1.6940036861782d-01,-4.9545310366761d-01,-7.8477268190898d-01,
     |  -1.0176696862451d+00,-1.1808699568685d+00,-1.2686654924367d+00,
     |  -1.2829717625643d+00,-1.2323597090437d+00,-1.1302992469774d+00,
     |  -9.9296269576828d-01,-8.3697347173042d-01,-6.7744720916675d-01,
     |  -5.2657499687441d-01,-3.9286837200175d-01,-2.8105358440677d-01,
     |  -1.9249524599402d-01,-1.2596430787824d-01,-7.8547876470423d-02,
     |  -4.6522838030944d-02,-2.6067702482194d-02,-1.3750278968445d-02,
     |  -6.7869434009443d-03,-3.1114162069047d-03,-1.3126079655391d-03,
     |  -5.0364388045704d-04,-1.7314573780795d-04,-5.2298566053795d-05,
     |  -1.3519596813356d-05,-2.8847795619382d-06,-4.8239697072109d-07,
     |  -5.8468453095389d-08,-4.5304726023999d-09,-1.7987414943441d-10,
     |  -2.3364740703416d-12,-3.1142619724271d-15,-1.9732851402322d-21/
      data (pmn(lat,14,14), lat = 1,72)/
     |   8.1370525548698d-24, 3.8574962229643d-17, 4.8357819226684d-14,
     |   5.2320260449822d-12, 1.7030456092440d-10, 2.7037952113296d-09,
     |   2.6572016437454d-08, 1.8506098893095d-07, 9.9357102119815d-07,
     |   4.3488440727546d-06, 1.6136442658031d-05, 5.2217397272517d-05,
     |   1.5052625376755d-04, 3.9289063836712d-04, 9.4044983956977d-04,
     |   2.0855636658253d-03, 4.3202778404716d-03, 8.4164994054865d-03,
     |   1.5506404905473d-02, 2.7144419066104d-02, 4.5326275506807d-02,
     |   7.2438539885867d-02, 1.1111570975094d-01, 1.6399287690714d-01,
     |   2.3335965122401d-01, 3.2074335527266d-01, 4.2647231790475d-01,
     |   5.4928815107846d-01, 6.8608387702390d-01, 8.3183870901841d-01,
     |   9.7979880449224d-01, 1.1219184026107d+00, 1.2495328062531d+00,
     |   1.3541915629563d+00, 1.4285457556339d+00, 1.4671652906314d+00,
     |   1.4671652906314d+00, 1.4285457556339d+00, 1.3541915629563d+00,
     |   1.2495328062531d+00, 1.1219184026107d+00, 9.7979880449224d-01,
     |   8.3183870901841d-01, 6.8608387702390d-01, 5.4928815107846d-01,
     |   4.2647231790475d-01, 3.2074335527266d-01, 2.3335965122401d-01,
     |   1.6399287690714d-01, 1.1111570975094d-01, 7.2438539885867d-02,
     |   4.5326275506807d-02, 2.7144419066104d-02, 1.5506404905473d-02,
     |   8.4164994054865d-03, 4.3202778404716d-03, 2.0855636658253d-03,
     |   9.4044983956977d-04, 3.9289063836711d-04, 1.5052625376755d-04,
     |   5.2217397272517d-05, 1.6136442658031d-05, 4.3488440727546d-06,
     |   9.9357102119816d-07, 1.8506098893095d-07, 2.6572016437454d-08,
     |   2.7037952113297d-09, 1.7030456092440d-10, 5.2320260449822d-12,
     |   4.8357819226684d-14, 3.8574962229643d-17, 8.1370525548698d-24/
      data (pmn(lat, 0,15), lat = 1,72)/
     |   3.8253693961263d+00, 2.9881378794694d+00, 1.5887214033109d+00,
     |   7.6990725803985d-02,-1.0845437960659d+00,-1.5833466661907d+00,
     |  -1.3591067864775d+00,-6.0906510091798d-01, 3.0217877832021d-01,
     |   9.9038570947396d-01, 1.1980258250144d+00, 8.8303422128629d-01,
     |   2.1838203634853d-01,-4.9285177445262d-01,-9.4902739814000d-01,
     |  -9.7326629405587d-01,-5.7929224501583d-01, 4.4246606034026d-02,
     |   6.2094125997263d-01, 9.0640656926157d-01, 7.8983522202690d-01,
     |   3.3575574615663d-01,-2.4940993826430d-01,-7.0959738179210d-01,
     |  -8.4964325528851d-01,-6.1699758835385d-01,-1.2075260162694d-01,
     |   4.1866937056773d-01, 7.6637184844534d-01, 7.7428403170923d-01,
     |   4.4361503100324d-01,-7.7664603942686d-02,-5.6041790692795d-01,
     |  -7.9421890111117d-01,-6.7833738460750d-01,-2.6479274530172d-01,
     |   2.6479274530172d-01, 6.7833738460750d-01, 7.9421890111117d-01,
     |   5.6041790692795d-01, 7.7664603942688d-02,-4.4361503100324d-01,
     |  -7.7428403170923d-01,-7.6637184844534d-01,-4.1866937056773d-01,
     |   1.2075260162694d-01, 6.1699758835385d-01, 8.4964325528851d-01,
     |   7.0959738179210d-01, 2.4940993826430d-01,-3.3575574615663d-01,
     |  -7.8983522202690d-01,-9.0640656926157d-01,-6.2094125997264d-01,
     |  -4.4246606034027d-02, 5.7929224501582d-01, 9.7326629405587d-01,
     |   9.4902739814000d-01, 4.9285177445262d-01,-2.1838203634852d-01,
     |  -8.8303422128629d-01,-1.1980258250144d+00,-9.9038570947397d-01,
     |  -3.0217877832022d-01, 6.0906510091798d-01, 1.3591067864775d+00,
     |   1.5833466661907d+00, 1.0845437960659d+00,-7.6990725803985d-02,
     |  -1.5887214033109d+00,-2.9881378794694d+00,-3.8253693961263d+00/
      data (pmn(lat, 1,15), lat = 1,72)/
     |   6.5588845578685d-01, 1.7508317152550d+00, 2.2745279323678d+00,
     |   2.0800162722150d+00, 1.2769461032608d+00, 1.8388661725290d-01,
     |  -7.9635472423997d-01,-1.3290637040196d+00,-1.2685122060709d+00,
     |  -7.0191006685447d-01, 9.7899199808711d-02, 7.8919365107257d-01,
     |   1.0991616234719d+00, 9.2759581832190d-01, 3.7678472947944d-01,
     |  -3.0125907866875d-01,-8.1559807009855d-01,-9.5799414332751d-01,
     |  -6.8537909178809d-01,-1.3083067110609d-01, 4.5893765618665d-01,
     |   8.3124188787646d-01, 8.3407209538250d-01, 4.7724091382417d-01,
     |  -7.6332253881281d-02,-5.8378084532926d-01,-8.2758406613838d-01,
     |  -7.0784770814393d-01,-2.8276657676819d-01, 2.5898884730134d-01,
     |   6.8116459041007d-01, 8.0204413496476d-01, 5.7202358824386d-01,
     |   9.3766067144130d-02,-4.2319401655013d-01,-7.5351522636103d-01,
     |  -7.5351522636103d-01,-4.2319401655014d-01, 9.3766067144128d-02,
     |   5.7202358824386d-01, 8.0204413496476d-01, 6.8116459041007d-01,
     |   2.5898884730135d-01,-2.8276657676818d-01,-7.0784770814393d-01,
     |  -8.2758406613838d-01,-5.8378084532926d-01,-7.6332253881284d-02,
     |   4.7724091382417d-01, 8.3407209538250d-01, 8.3124188787646d-01,
     |   4.5893765618666d-01,-1.3083067110609d-01,-6.8537909178808d-01,
     |  -9.5799414332751d-01,-8.1559807009855d-01,-3.0125907866875d-01,
     |   3.7678472947944d-01, 9.2759581832191d-01, 1.0991616234719d+00,
     |   7.8919365107257d-01, 9.7899199808711d-02,-7.0191006685446d-01,
     |  -1.2685122060709d+00,-1.3290637040196d+00,-7.9635472423997d-01,
     |   1.8388661725289d-01, 1.2769461032608d+00, 2.0800162722150d+00,
     |   2.2745279323678d+00, 1.7508317152550d+00, 6.5588845578685d-01/
      data (pmn(lat, 2,15), lat = 1,72)/
     |   5.5454923102881d-02, 4.6236546491351d-01, 1.0970696627812d+00,
     |   1.6746622084007d+00, 1.9213382839112d+00, 1.6874082266055d+00,
     |   1.0106049117033d+00, 1.0403703057236d-01,-7.2633048397113d-01,
     |  -1.2013427563844d+00,-1.1773127434137d+00,-7.0024716988825d-01,
     |   1.5528668600568d-02, 6.7489139565701d-01, 1.0196249948743d+00,
     |   9.2868500925995d-01, 4.6115378910531d-01,-1.7416799422498d-01,
     |  -7.0860309534379d-01,-9.2508141795063d-01,-7.4539550804200d-01,
     |  -2.5814856641413d-01, 3.2270566092482d-01, 7.5011620313442d-01,
     |   8.4777671096680d-01, 5.8226246630006d-01, 7.4050783775533d-02,
     |  -4.5611061378182d-01,-7.8202889953795d-01,-7.6774415202533d-01,
     |  -4.2386655196522d-01, 9.8672673484370d-02, 5.7418161862299d-01,
     |   7.9888026187277d-01, 6.7758565570049d-01, 2.6377147018457d-01,
     |  -2.6377147018456d-01,-6.7758565570049d-01,-7.9888026187277d-01,
     |  -5.7418161862299d-01,-9.8672673484372d-02, 4.2386655196522d-01,
     |   7.6774415202533d-01, 7.8202889953795d-01, 4.5611061378182d-01,
     |  -7.4050783775531d-02,-5.8226246630006d-01,-8.4777671096680d-01,
     |  -7.5011620313442d-01,-3.2270566092482d-01, 2.5814856641413d-01,
     |   7.4539550804199d-01, 9.2508141795063d-01, 7.0860309534379d-01,
     |   1.7416799422498d-01,-4.6115378910531d-01,-9.2868500925995d-01,
     |  -1.0196249948743d+00,-6.7489139565701d-01,-1.5528668600576d-02,
     |   7.0024716988825d-01, 1.1773127434137d+00, 1.2013427563844d+00,
     |   7.2633048397114d-01,-1.0403703057236d-01,-1.0106049117033d+00,
     |  -1.6874082266055d+00,-1.9213382839112d+00,-1.6746622084007d+00,
     |  -1.0970696627812d+00,-4.6236546491351d-01,-5.5454923102881d-02/
      data (pmn(lat, 3,15), lat = 1,72)/
     |   3.0919870020657d-03, 7.8892227615660d-02, 3.2551215063882d-01,
     |   7.4739154047255d-01, 1.2379578903514d+00, 1.6177364027180d+00,
     |   1.7097715722045d+00, 1.4205168250228d+00, 7.9091219955759d-01,
     |  -6.0466064144578d-03,-7.2299727257449d-01,-1.1296691325798d+00,
     |  -1.1018247579508d+00,-6.7137521070437d-01,-1.6367825099705d-02,
     |   6.0639559176372d-01, 9.6004173763323d-01, 9.1857272738500d-01,
     |   5.1383434668484d-01,-8.0194582897261d-02,-6.1927708984712d-01,
     |  -8.8781151438391d-01,-7.8478731287176d-01,-3.6227798112762d-01,
     |   1.9860168360459d-01, 6.6383301742336d-01, 8.4314756376602d-01,
     |   6.6749144507155d-01, 2.1575769685227d-01,-3.1970809143864d-01,
     |  -7.1408325988015d-01,-8.0373788082588d-01,-5.5378294300161d-01,
     |  -7.1686066623245d-02, 4.3840876538983d-01, 7.6143323640953d-01,
     |   7.6143323640954d-01, 4.3840876538984d-01,-7.1686066623244d-02,
     |  -5.5378294300161d-01,-8.0373788082588d-01,-7.1408325988015d-01,
     |  -3.1970809143865d-01, 2.1575769685226d-01, 6.6749144507155d-01,
     |   8.4314756376602d-01, 6.6383301742336d-01, 1.9860168360460d-01,
     |  -3.6227798112762d-01,-7.8478731287176d-01,-8.8781151438391d-01,
     |  -6.1927708984712d-01,-8.0194582897263d-02, 5.1383434668483d-01,
     |   9.1857272738500d-01, 9.6004173763323d-01, 6.0639559176372d-01,
     |  -1.6367825099709d-02,-6.7137521070437d-01,-1.1018247579508d+00,
     |  -1.1296691325798d+00,-7.2299727257449d-01,-6.0466064144636d-03,
     |   7.9091219955758d-01, 1.4205168250228d+00, 1.7097715722045d+00,
     |   1.6177364027180d+00, 1.2379578903514d+00, 7.4739154047255d-01,
     |   3.2551215063882d-01, 7.8892227615660d-02, 3.0919870020657d-03/
      data (pmn(lat, 4,15), lat = 1,72)/
     |   1.2750900732288d-04, 9.8773810518440d-03, 6.9633482416547d-02,
     |   2.3297722991064d-01, 5.2656673553935d-01, 9.1753506379968d-01,
     |   1.3070803604447d+00, 1.5574371463246d+00, 1.5439864420793d+00,
     |   1.2115867492431d+00, 6.1013664696836d-01,-1.0880818799076d-01,
     |  -7.3723795397486d-01,-1.0829745594912d+00,-1.0418242116223d+00,
     |  -6.4059878036884d-01,-3.2185457672723d-02, 5.5773272991624d-01,
     |   9.1332329282833d-01, 9.0922868263681d-01, 5.5764297395870d-01,
     |   2.8538189579789d-03,-5.3529094992291d-01,-8.4727589954129d-01,
     |  -8.1556426135317d-01,-4.5979191964199d-01, 7.2399181590332d-02,
     |   5.6521703842355d-01, 8.2135450635495d-01, 7.4075192440858d-01,
     |   3.5997485331103d-01,-1.6348981633951d-01,-6.1555667187159d-01,
     |  -8.1244321613846d-01,-6.7502529739934d-01,-2.6061766391067d-01,
     |   2.6061766391067d-01, 6.7502529739934d-01, 8.1244321613846d-01,
     |   6.1555667187159d-01, 1.6348981633951d-01,-3.5997485331103d-01,
     |  -7.4075192440858d-01,-8.2135450635495d-01,-5.6521703842355d-01,
     |  -7.2399181590333d-02, 4.5979191964199d-01, 8.1556426135317d-01,
     |   8.4727589954129d-01, 5.3529094992291d-01,-2.8538189579789d-03,
     |  -5.5764297395869d-01,-9.0922868263681d-01,-9.1332329282833d-01,
     |  -5.5773272991624d-01, 3.2185457672718d-02, 6.4059878036883d-01,
     |   1.0418242116223d+00, 1.0829745594913d+00, 7.3723795397487d-01,
     |   1.0880818799076d-01,-6.1013664696836d-01,-1.2115867492431d+00,
     |  -1.5439864420793d+00,-1.5574371463246d+00,-1.3070803604447d+00,
     |  -9.1753506379968d-01,-5.2656673553935d-01,-2.3297722991064d-01,
     |  -6.9633482416547d-02,-9.8773810518440d-03,-1.2750900732288d-04/
      data (pmn(lat, 5,15), lat = 1,72)/
     |   4.1301964196010d-06, 9.6755720538864d-04, 1.1557445882968d-02,
     |   5.5557720694178d-02, 1.6754431147429d-01, 3.7552706804199d-01,
     |   6.7811911523046d-01, 1.0285027708368d+00, 1.3362859764796d+00,
     |   1.4913047808059d+00, 1.4033400851684d+00, 1.0430533084007d+00,
     |   4.6639424723914d-01,-1.9071390604188d-01,-7.4969695125537d-01,
     |  -1.0478231517314d+00,-9.9713594577805d-01,-6.2088564303600d-01,
     |  -5.1521930050383d-02, 5.1171020391172d-01, 8.7182978224137d-01,
     |   9.0493801932890d-01, 6.0601592253268d-01, 9.1499739350074d-02,
     |  -4.4350826605066d-01,-7.9809170600029d-01,-8.4115856829873d-01,
     |  -5.6096750430741d-01,-6.9265372196893d-02, 4.4192198328702d-01,
     |   7.7446033030463d-01, 8.0068074691917d-01, 5.1266111681937d-01,
     |   2.4987184748388d-02,-4.7017182477650d-01,-7.7822103454644d-01,
     |  -7.7822103454644d-01,-4.7017182477650d-01, 2.4987184748386d-02,
     |   5.1266111681937d-01, 8.0068074691917d-01, 7.7446033030463d-01,
     |   4.4192198328703d-01,-6.9265372196888d-02,-5.6096750430741d-01,
     |  -8.4115856829873d-01,-7.9809170600029d-01,-4.4350826605066d-01,
     |   9.1499739350072d-02, 6.0601592253268d-01, 9.0493801932890d-01,
     |   8.7182978224137d-01, 5.1171020391172d-01,-5.1521930050381d-02,
     |  -6.2088564303600d-01,-9.9713594577805d-01,-1.0478231517314d+00,
     |  -7.4969695125537d-01,-1.9071390604188d-01, 4.6639424723914d-01,
     |   1.0430533084007d+00, 1.4033400851684d+00, 1.4913047808059d+00,
     |   1.3362859764796d+00, 1.0285027708368d+00, 6.7811911523046d-01,
     |   3.7552706804199d-01, 1.6754431147429d-01, 5.5557720694178d-02,
     |   1.1557445882968d-02, 9.6755720538864d-04, 4.1301964196010d-06/
      data (pmn(lat, 6,15), lat = 1,72)/
     |   1.0889282396286d-07, 7.6974474745456d-05, 1.5506736738562d-03,
     |   1.0629239529516d-02, 4.2285456610934d-02, 1.1988373043253d-01,
     |   2.6761281233426d-01, 4.9672220296321d-01, 7.9091981722337d-01,
     |   1.0987046945872d+00, 1.3392194018892d+00, 1.4233456122478d+00,
     |   1.2849673047169d+00, 9.1149885222398d-01, 3.6077828103560d-01,
     |  -2.4524864278861d-01,-7.5167246067888d-01,-1.0184242364269d+00,
     |  -9.6885127429455d-01,-6.2095292060628d-01,-8.7914917768503d-02,
     |   4.5495684929610d-01, 8.2731385793652d-01, 9.0552932043378d-01,
     |   6.6685197575160d-01, 1.9901929157547d-01,-3.2950904303991d-01,
     |  -7.2905473319579d-01,-8.5690825434531d-01,-6.6929744878693d-01,
     |  -2.3767221111405d-01, 2.7724066225051d-01, 6.8449271721919d-01,
     |   8.3345053615199d-01, 6.6964488284802d-01, 2.5503278815599d-01,
     |  -2.5503278815599d-01,-6.6964488284802d-01,-8.3345053615199d-01,
     |  -6.8449271721919d-01,-2.7724066225052d-01, 2.3767221111405d-01,
     |   6.6929744878693d-01, 8.5690825434531d-01, 7.2905473319580d-01,
     |   3.2950904303992d-01,-1.9901929157547d-01,-6.6685197575160d-01,
     |  -9.0552932043378d-01,-8.2731385793652d-01,-4.5495684929610d-01,
     |   8.7914917768495d-02, 6.2095292060627d-01, 9.6885127429455d-01,
     |   1.0184242364269d+00, 7.5167246067888d-01, 2.4524864278862d-01,
     |  -3.6077828103561d-01,-9.1149885222398d-01,-1.2849673047169d+00,
     |  -1.4233456122478d+00,-1.3392194018892d+00,-1.0987046945872d+00,
     |  -7.9091981722338d-01,-4.9672220296321d-01,-2.6761281233426d-01,
     |  -1.1988373043253d-01,-4.2285456610934d-02,-1.0629239529516d-02,
     |  -1.5506736738562d-03,-7.6974474745456d-05,-1.0889282396286d-07/
      data (pmn(lat, 7,15), lat = 1,72)/
     |   2.3890764220437d-09, 5.0888517714750d-06, 1.7240123326816d-04,
     |   1.6774259819882d-03, 8.7449541503932d-03, 3.1069613077290d-02,
     |   8.4624765647030d-02, 1.8869229525355d-01, 3.5828662556237d-01,
     |   5.9361453523643d-01, 8.7068967710270d-01, 1.1383297291499d+00,
     |   1.3255422109236d+00, 1.3597629195190d+00, 1.1916935662098d+00,
     |   8.1851438725985d-01, 2.9595490295917d-01,-2.6783910437891d-01,
     |  -7.3789167278443d-01,-9.9139175260511d-01,-9.5803333848873d-01,
     |  -6.4747208445479d-01,-1.5268608704019d-01, 3.7437384679125d-01,
     |   7.6874604078124d-01, 9.0561929419296d-01, 7.4262758101112d-01,
     |   3.3593503065118d-01,-1.7673083439948d-01,-6.2148342445893d-01,
     |  -8.4718095172103d-01,-7.7755773757478d-01,-4.3812202265018d-01,
     |   5.2108631438902d-02, 5.2164012444931d-01, 8.0620232172154d-01,
     |   8.0620232172154d-01, 5.2164012444931d-01, 5.2108631438903d-02,
     |  -4.3812202265018d-01,-7.7755773757478d-01,-8.4718095172103d-01,
     |  -6.2148342445893d-01,-1.7673083439948d-01, 3.3593503065117d-01,
     |   7.4262758101112d-01, 9.0561929419296d-01, 7.6874604078124d-01,
     |   3.7437384679125d-01,-1.5268608704019d-01,-6.4747208445479d-01,
     |  -9.5803333848873d-01,-9.9139175260511d-01,-7.3789167278443d-01,
     |  -2.6783910437891d-01, 2.9595490295916d-01, 8.1851438725985d-01,
     |   1.1916935662098d+00, 1.3597629195190d+00, 1.3255422109236d+00,
     |   1.1383297291499d+00, 8.7068967710270d-01, 5.9361453523643d-01,
     |   3.5828662556237d-01, 1.8869229525355d-01, 8.4624765647030d-02,
     |   3.1069613077290d-02, 8.7449541503932d-03, 1.6774259819882d-03,
     |   1.7240123326816d-04, 5.0888517714750d-06, 2.3890764220437d-09/
      data (pmn(lat, 8,15), lat = 1,72)/
     |   4.4207496520195d-11, 2.8348479190278d-07, 1.6120508555407d-05,
     |   2.2198157916329d-04, 1.5101617550768d-03, 6.6850763250433d-03,
     |   2.2045211281968d-02, 5.8436638409436d-02, 1.3044389513167d-01,
     |   2.5265194487995d-01, 4.3301407781883d-01, 6.6499031185016d-01,
     |   9.2157641590523d-01, 1.1548008273950d+00, 1.3031737578556d+00,
     |   1.3069861980808d+00, 1.1280471122479d+00, 7.6769060132514d-01,
     |   2.7598623160854d-01,-2.5318726534555d-01,-7.0238178504833d-01,
     |  -9.6193025105442d-01,-9.6350664510748d-01,-7.0488078817268d-01,
     |  -2.5647231678608d-01, 2.5448323221095d-01, 6.7906594303234d-01,
     |   8.9111273728981d-01, 8.2699304581842d-01, 5.0733356658538d-01,
     |   3.2591337701958d-02,-4.4722417182000d-01,-7.7965347572219d-01,
     |  -8.5868669707844d-01,-6.5936612910627d-01,-2.4640130113721d-01,
     |   2.4640130113721d-01, 6.5936612910627d-01, 8.5868669707844d-01,
     |   7.7965347572219d-01, 4.4722417182000d-01,-3.2591337701959d-02,
     |  -5.0733356658538d-01,-8.2699304581842d-01,-8.9111273728981d-01,
     |  -6.7906594303234d-01,-2.5448323221095d-01, 2.5647231678608d-01,
     |   7.0488078817267d-01, 9.6350664510748d-01, 9.6193025105442d-01,
     |   7.0238178504833d-01, 2.5318726534555d-01,-2.7598623160854d-01,
     |  -7.6769060132514d-01,-1.1280471122479d+00,-1.3069861980808d+00,
     |  -1.3031737578556d+00,-1.1548008273950d+00,-9.2157641590523d-01,
     |  -6.6499031185016d-01,-4.3301407781883d-01,-2.5265194487995d-01,
     |  -1.3044389513168d-01,-5.8436638409436d-02,-2.2045211281968d-02,
     |  -6.6850763250433d-03,-1.5101617550768d-03,-2.2198157916329d-04,
     |  -1.6120508555407d-05,-2.8348479190278d-07,-4.4207496520195d-11/
      data (pmn(lat, 9,15), lat = 1,72)/
     |   6.9473715375737d-13, 1.3403565714126d-08, 1.2777010857728d-06,
     |   2.4849519707088d-05, 2.1997515059463d-04, 1.2086346898746d-03,
     |   4.8013744306549d-03, 1.5031749789739d-02, 3.9111152187984d-02,
     |   8.7562849549012d-02, 1.7269951900640d-01, 3.0496674466744d-01,
     |   4.8750951643726d-01, 7.1039592221562d-01, 9.4680211151754d-01,
     |   1.1536233429448d+00, 1.2781048064966d+00, 1.2702396355096d+00,
     |   1.0983651208776d+00, 7.6343616562715d-01, 3.0674431871584d-01,
     |  -1.9305851878960d-01,-6.3492573262575d-01,-9.1979984117678d-01,
     |  -9.7821126731162d-01,-7.9284624947763d-01,-4.0834467899694d-01,
     |   7.6203650467949d-02, 5.3149130462267d-01, 8.3294486095345d-01,
     |   8.9645018017845d-01, 7.0392969250509d-01, 3.1037917518736d-01,
     |  -1.7062090411111d-01,-5.9926368791850d-01,-8.5035683414508d-01,
     |  -8.5035683414508d-01,-5.9926368791850d-01,-1.7062090411111d-01,
     |   3.1037917518736d-01, 7.0392969250509d-01, 8.9645018017845d-01,
     |   8.3294486095345d-01, 5.3149130462267d-01, 7.6203650467951d-02,
     |  -4.0834467899693d-01,-7.9284624947763d-01,-9.7821126731162d-01,
     |  -9.1979984117678d-01,-6.3492573262575d-01,-1.9305851878960d-01,
     |   3.0674431871583d-01, 7.6343616562715d-01, 1.0983651208776d+00,
     |   1.2702396355096d+00, 1.2781048064966d+00, 1.1536233429448d+00,
     |   9.4680211151754d-01, 7.1039592221562d-01, 4.8750951643726d-01,
     |   3.0496674466744d-01, 1.7269951900640d-01, 8.7562849549013d-02,
     |   3.9111152187985d-02, 1.5031749789739d-02, 4.8013744306549d-03,
     |   1.2086346898747d-03, 2.1997515059463d-04, 2.4849519707088d-05,
     |   1.2777010857728d-06, 1.3403565714126d-08, 6.9473715375737d-13/
      data (pmn(lat,10,15), lat = 1,72)/
     |   9.2843937989977d-15, 5.3866335436677d-10, 8.5995398639528d-08,
     |   2.3587350803745d-06, 2.7114399645141d-05, 1.8441302009423d-04,
     |   8.7946916560521d-04, 3.2376149578563d-03, 9.7643828333698d-03,
     |   2.5089907656319d-02, 5.6427731726421d-02, 1.1321524850781d-01,
     |   2.0543373787256d-01, 3.4042664830842d-01, 5.1862966781381d-01,
     |   7.2933155555352d-01, 9.4811780274246d-01, 1.1377035571210d+00,
     |   1.2532418330793d+00, 1.2519310965401d+00, 1.1051525048367d+00,
     |   8.0996677414939d-01, 3.9617106941233d-01,-7.4331333240229d-02,
     |  -5.1730857575642d-01,-8.4395313245336d-01,-9.8272449477667d-01,
     |  -8.9951220070120d-01,-6.1004943878049d-01,-1.8009721630373d-01,
     |   2.8790055859302d-01, 6.7908458050464d-01, 8.9531778517824d-01,
     |   8.8128584141687d-01, 6.4008115394459d-01, 2.3349667423351d-01,
     |  -2.3349667423351d-01,-6.4008115394458d-01,-8.8128584141687d-01,
     |  -8.9531778517824d-01,-6.7908458050464d-01,-2.8790055859301d-01,
     |   1.8009721630373d-01, 6.1004943878049d-01, 8.9951220070120d-01,
     |   9.8272449477667d-01, 8.4395313245336d-01, 5.1730857575642d-01,
     |   7.4331333240230d-02,-3.9617106941233d-01,-8.0996677414939d-01,
     |  -1.1051525048367d+00,-1.2519310965401d+00,-1.2532418330793d+00,
     |  -1.1377035571210d+00,-9.4811780274246d-01,-7.2933155555353d-01,
     |  -5.1862966781381d-01,-3.4042664830842d-01,-2.0543373787257d-01,
     |  -1.1321524850781d-01,-5.6427731726421d-02,-2.5089907656319d-02,
     |  -9.7643828333698d-03,-3.2376149578563d-03,-8.7946916560521d-04,
     |  -1.8441302009423d-04,-2.7114399645141d-05,-2.3587350803745d-06,
     |  -8.5995398639528d-08,-5.3866335436677d-10,-9.2843937989977d-15/
      data (pmn(lat,11,15), lat = 1,72)/
     |   1.0500286257714d-16, 1.8313772688871d-11, 4.8930255202098d-09,
     |   1.8907087946664d-07, 2.8181161315234d-06, 2.3679235474936d-05,
     |   1.3522947114071d-04, 5.8355384321669d-04, 2.0321035646683d-03,
     |   5.9641299674609d-03, 1.5204143787347d-02, 3.4399828978217d-02,
     |   7.0176801703829d-02, 1.3060727461526d-01, 2.2369558235353d-01,
     |   3.5482460648142d-01, 5.2350715622731d-01, 7.2024162584346d-01,
     |   9.2461128681856d-01, 1.1058067501432d+00, 1.2263672382172d+00,
     |   1.2491339663659d+00, 1.1463570403828d+00, 9.0890348522620d-01,
     |   5.5294019903687d-01, 1.2160507996337d-01,-3.1986323678300d-01,
     |  -6.9544768324834d-01,-9.3416239843594d-01,-9.8680608687462d-01,
     |  -8.3936655937260d-01,-5.1919873430529d-01,-9.1678987605924d-02,
     |   3.5257738594579d-01, 7.1730312810670d-01, 9.2236683885123d-01,
     |   9.2236683885123d-01, 7.1730312810670d-01, 3.5257738594579d-01,
     |  -9.1678987605923d-02,-5.1919873430529d-01,-8.3936655937260d-01,
     |  -9.8680608687462d-01,-9.3416239843595d-01,-6.9544768324834d-01,
     |  -3.1986323678300d-01, 1.2160507996337d-01, 5.5294019903686d-01,
     |   9.0890348522620d-01, 1.1463570403828d+00, 1.2491339663659d+00,
     |   1.2263672382172d+00, 1.1058067501432d+00, 9.2461128681856d-01,
     |   7.2024162584346d-01, 5.2350715622731d-01, 3.5482460648142d-01,
     |   2.2369558235353d-01, 1.3060727461526d-01, 7.0176801703829d-02,
     |   3.4399828978217d-02, 1.5204143787347d-02, 5.9641299674609d-03,
     |   2.0321035646683d-03, 5.8355384321669d-04, 1.3522947114071d-04,
     |   2.3679235474936d-05, 2.8181161315234d-06, 1.8907087946664d-07,
     |   4.8930255202098d-09, 1.8313772688871d-11, 1.0500286257714d-16/
      data (pmn(lat,12,15), lat = 1,72)/
     |   9.9216957024011d-19, 5.2006682281986d-13, 2.3241562608517d-10,
     |   1.2641402202478d-08, 2.4403268491052d-07, 2.5294799833678d-06,
     |   1.7266356728124d-05, 8.7139669404087d-05, 3.4938455154537d-04,
     |   1.1672482879163d-03, 3.3588170658972d-03, 8.5260148494734d-03,
     |   1.9432300065744d-02, 4.0301571028172d-02, 7.6837827627098d-02,
     |   1.3573421792535d-01, 2.2349179733447d-01, 3.4452573105020d-01,
     |   4.9878685931064d-01, 6.7941156826844d-01, 8.7113741948473d-01,
     |   1.0502792452992d+00, 1.1868707949344d+00, 1.2491265045721d+00,
     |   1.2097412290454d+00, 1.0528813516928d+00, 7.8023432420762d-01,
     |   4.1436728746140d-01,-1.9904265702080d-03,-4.1130300192430d-01,
     |  -7.5066972362127d-01,-9.6367521333419d-01,-1.0121556216169d+00,
     |  -8.8514604246835d-01,-6.0272754035278d-01,-2.1357121241277d-01,
     |   2.1357121241277d-01, 6.0272754035278d-01, 8.8514604246835d-01,
     |   1.0121556216169d+00, 9.6367521333419d-01, 7.5066972362127d-01,
     |   4.1130300192430d-01, 1.9904265702118d-03,-4.1436728746139d-01,
     |  -7.8023432420762d-01,-1.0528813516928d+00,-1.2097412290454d+00,
     |  -1.2491265045721d+00,-1.1868707949344d+00,-1.0502792452992d+00,
     |  -8.7113741948473d-01,-6.7941156826844d-01,-4.9878685931064d-01,
     |  -3.4452573105021d-01,-2.2349179733447d-01,-1.3573421792535d-01,
     |  -7.6837827627098d-02,-4.0301571028172d-02,-1.9432300065744d-02,
     |  -8.5260148494734d-03,-3.3588170658972d-03,-1.1672482879163d-03,
     |  -3.4938455154537d-04,-8.7139669404087d-05,-1.7266356728124d-05,
     |  -2.5294799833678d-06,-2.4403268491052d-07,-1.2641402202478d-08,
     |  -2.3241562608517d-10,-5.2006682281986d-13,-9.9216957024011d-19/
      data (pmn(lat,13,15), lat = 1,72)/
     |   7.6317645575073d-21, 1.2019973671278d-14, 8.9811459681557d-12,
     |   6.8716787466937d-10, 1.7165212665052d-08, 2.1923502876914d-07,
     |   1.7861770191867d-06, 1.0524112486892d-05, 4.8481631271251d-05,
     |   1.8390398749357d-04, 5.9552497487610d-04, 1.6898183420469d-03,
     |   4.2840350157021d-03, 9.8484908775849d-03, 2.0767043293014d-02,
     |   4.0530312936055d-02, 7.3735749280368d-02, 1.2575242741568d-01,
     |   2.0193737808059d-01, 3.0637683223008d-01, 4.4026534367182d-01,
     |   6.0020149100968d-01, 7.7682396495752d-01, 9.5428031932299d-01,
     |   1.1109646553794d+00, 1.2217594022918d+00, 1.2616908804549d+00,
     |   1.2105235214150d+00, 1.0574713058977d+00, 8.0500320674092d-01,
     |   4.7074487616339d-01, 8.6761849832942d-02,-3.0398839020098d-01,
     |  -6.5363174089309d-01,-9.1679327699859d-01,-1.0580688006639d+00,
     |  -1.0580688006639d+00,-9.1679327699859d-01,-6.5363174089309d-01,
     |  -3.0398839020098d-01, 8.6761849832940d-02, 4.7074487616339d-01,
     |   8.0500320674092d-01, 1.0574713058977d+00, 1.2105235214150d+00,
     |   1.2616908804549d+00, 1.2217594022918d+00, 1.1109646553794d+00,
     |   9.5428031932299d-01, 7.7682396495752d-01, 6.0020149100968d-01,
     |   4.4026534367183d-01, 3.0637683223008d-01, 2.0193737808059d-01,
     |   1.2575242741568d-01, 7.3735749280368d-02, 4.0530312936055d-02,
     |   2.0767043293014d-02, 9.8484908775848d-03, 4.2840350157022d-03,
     |   1.6898183420469d-03, 5.9552497487610d-04, 1.8390398749357d-04,
     |   4.8481631271251d-05, 1.0524112486892d-05, 1.7861770191867d-06,
     |   2.1923502876914d-07, 1.7165212665052d-08, 6.8716787466937d-10,
     |   8.9811459681557d-12, 1.2019973671278d-14, 7.6317645575073d-21/
      data (pmn(lat,14,15), lat = 1,72)/
     |   4.5294409824826d-23, 2.1431644745489d-16, 2.6764464168061d-13,
     |   2.8791650949449d-11, 9.2999596701934d-10, 1.4622675429329d-08,
     |   1.4203623291541d-07, 9.7569405933656d-07, 5.1558389423825d-06,
     |   2.2162747178251d-05, 8.0578554207355d-05, 2.5489442007341d-04,
     |   7.1649711752176d-04, 1.8188584806461d-03, 4.2227077382838d-03,
     |   9.0559617289971d-03, 1.8084972009076d-02, 3.3850759351828d-02,
     |   5.9702477150603d-02, 9.9649391819681d-02, 1.5796181641766d-01,
     |   2.3848743363655d-01, 3.4371246317252d-01, 4.7367821611162d-01,
     |   6.2494464300928d-01, 7.8984950276604d-01, 9.5632095720045d-01,
     |   1.1084467868308d+00, 1.2278837656519d+00, 1.2960230190907d+00,
     |   1.2966452021062d+00, 1.2186467769672d+00, 1.0583382533678d+00,
     |   8.2083658859900d-01, 5.2020381142740d-01, 1.7820210083248d-01,
     |  -1.7820210083248d-01,-5.2020381142740d-01,-8.2083658859899d-01,
     |  -1.0583382533678d+00,-1.2186467769672d+00,-1.2966452021062d+00,
     |  -1.2960230190907d+00,-1.2278837656519d+00,-1.1084467868308d+00,
     |  -9.5632095720045d-01,-7.8984950276604d-01,-6.2494464300928d-01,
     |  -4.7367821611162d-01,-3.4371246317252d-01,-2.3848743363655d-01,
     |  -1.5796181641766d-01,-9.9649391819681d-02,-5.9702477150604d-02,
     |  -3.3850759351828d-02,-1.8084972009076d-02,-9.0559617289971d-03,
     |  -4.2227077382838d-03,-1.8188584806461d-03,-7.1649711752177d-04,
     |  -2.5489442007341d-04,-8.0578554207355d-05,-2.2162747178251d-05,
     |  -5.1558389423826d-06,-9.7569405933657d-07,-1.4203623291541d-07,
     |  -1.4622675429329d-08,-9.2999596701934d-10,-2.8791650949449d-11,
     |  -2.6764464168061d-13,-2.1431644745489d-16,-4.5294409824826d-23/
      data (pmn(lat,15,15), lat = 1,72)/
     |   1.8044309563017d-25, 2.5646272756114d-18, 5.3515881469478d-15,
     |   8.0907000524524d-13, 3.3773978617195d-11, 6.5327707693808d-10,
     |   7.5585323163527d-09, 6.0469210050084d-08, 3.6606053230390d-07,
     |   1.7804346412794d-06, 7.2549404619323d-06, 2.5531149948533d-05,
     |   7.9379809745114d-05, 2.2188649445109d-04, 5.6528937368954d-04,
     |   1.3269816262665d-03, 2.8956438927920d-03, 5.9163260582442d-03,
     |   1.1386425555529d-02, 2.0745604184575d-02, 3.5933583801657d-02,
     |   5.9383316366956d-02, 9.3916536033681d-02, 1.4251696057498d-01,
     |   2.0797457573585d-01, 2.9242110397386d-01, 3.9680759413641d-01,
     |   5.2040328531936d-01, 6.6041262691656d-01, 8.1180763539259d-01,
     |   9.6745177029955d-01, 1.1185500733629d+00, 1.2554045747944d+00,
     |   1.3683945064620d+00, 1.4490504965748d+00, 1.4910626825892d+00,
     |   1.4910626825892d+00, 1.4490504965748d+00, 1.3683945064620d+00,
     |   1.2554045747944d+00, 1.1185500733629d+00, 9.6745177029955d-01,
     |   8.1180763539259d-01, 6.6041262691657d-01, 5.2040328531936d-01,
     |   3.9680759413641d-01, 2.9242110397386d-01, 2.0797457573585d-01,
     |   1.4251696057499d-01, 9.3916536033681d-02, 5.9383316366956d-02,
     |   3.5933583801657d-02, 2.0745604184575d-02, 1.1386425555529d-02,
     |   5.9163260582442d-03, 2.8956438927920d-03, 1.3269816262665d-03,
     |   5.6528937368953d-04, 2.2188649445109d-04, 7.9379809745115d-05,
     |   2.5531149948533d-05, 7.2549404619323d-06, 1.7804346412795d-06,
     |   3.6606053230391d-07, 6.0469210050085d-08, 7.5585323163527d-09,
     |   6.5327707693810d-10, 3.3773978617195d-11, 8.0907000524524d-13,
     |   5.3515881469478d-15, 2.5646272756114d-18, 1.8044309563017d-25/
      data (pmn(lat, 0,16), lat = 1,72)/
     |   3.9316068869092d+00, 2.9620275680810d+00, 1.3820558450630d+00,
     |  -2.3758901355323d-01,-1.3463499409964d+00,-1.6304709993534d+00,
     |  -1.1236246956100d+00,-1.6827326067104d-01, 7.4986932487340d-01,
     |   1.2177035300389d+00, 1.0653395038757d+00, 4.1955252566599d-01,
     |  -3.7701478512513d-01,-9.3762861089728d-01,-1.0122122380162d+00,
     |  -5.9476267116361d-01, 8.7853895022767d-02, 6.9477438958183d-01,
     |   9.3761758566630d-01, 7.1487713730836d-01, 1.5251741812828d-01,
     |  -4.6483454379687d-01,-8.3577086027190d-01,-7.8739682504641d-01,
     |  -3.5479066430276d-01, 2.4149264839004d-01, 7.0655621508746d-01,
     |   8.1561435643336d-01, 5.2165461908811d-01,-2.4844265531895d-02,
     |  -5.5218730743085d-01,-8.0147244034291d-01,-6.5275565985808d-01,
     |  -1.8232444934243d-01, 3.7608785530753d-01, 7.4661626847118d-01,
     |   7.4661626847118d-01, 3.7608785530753d-01,-1.8232444934242d-01,
     |  -6.5275565985808d-01,-8.0147244034291d-01,-5.5218730743085d-01,
     |  -2.4844265531896d-02, 5.2165461908811d-01, 8.1561435643336d-01,
     |   7.0655621508746d-01, 2.4149264839004d-01,-3.5479066430276d-01,
     |  -7.8739682504641d-01,-8.3577086027190d-01,-4.6483454379687d-01,
     |   1.5251741812827d-01, 7.1487713730836d-01, 9.3761758566630d-01,
     |   6.9477438958183d-01, 8.7853895022772d-02,-5.9476267116361d-01,
     |  -1.0122122380162d+00,-9.3762861089728d-01,-3.7701478512514d-01,
     |   4.1955252566599d-01, 1.0653395038757d+00, 1.2177035300389d+00,
     |   7.4986932487340d-01,-1.6827326067104d-01,-1.1236246956100d+00,
     |  -1.6304709993534d+00,-1.3463499409964d+00,-2.3758901355323d-01,
     |   1.3820558450630d+00, 2.9620275680810d+00, 3.9316068869092d+00/
      data (pmn(lat, 1,16), lat = 1,72)/
     |   7.1904136585597d-01, 1.8888289688170d+00, 2.3644116827769d+00,
     |   2.0041384082875d+00, 1.0020060325809d+00,-2.0358706725244d-01,
     |  -1.1216430788200d+00,-1.4156856904374d+00,-1.0361821889675d+00,
     |  -2.2340244972273d-01, 6.1547139095910d-01, 1.0957038884912d+00,
     |   1.0241083864581d+00, 4.7341151735222d-01,-2.6721490283597d-01,
     |  -8.3747037955115d-01,-9.7660664435350d-01,-6.4005520908214d-01,
     |  -1.0362978451869d-02, 5.9851612876403d-01, 8.9496629649011d-01,
     |   7.4739000014024d-01, 2.4152324431980d-01,-3.6727305277556d-01,
     |  -7.8119419663343d-01,-8.0413091816904d-01,-4.3365996629111d-01,
     |   1.4193324374870d-01, 6.3829920305290d-01, 8.1429403632530d-01,
     |   5.8822134658815d-01, 7.5401577804747d-02,-4.7008588086093d-01,
     |  -7.8035378259109d-01,-7.0435164242773d-01,-2.8091175070941d-01,
     |   2.8091175070941d-01, 7.0435164242773d-01, 7.8035378259109d-01,
     |   4.7008588086093d-01,-7.5401577804746d-02,-5.8822134658815d-01,
     |  -8.1429403632531d-01,-6.3829920305290d-01,-1.4193324374871d-01,
     |   4.3365996629111d-01, 8.0413091816904d-01, 7.8119419663343d-01,
     |   3.6727305277557d-01,-2.4152324431980d-01,-7.4739000014024d-01,
     |  -8.9496629649011d-01,-5.9851612876404d-01, 1.0362978451865d-02,
     |   6.4005520908214d-01, 9.7660664435350d-01, 8.3747037955115d-01,
     |   2.6721490283597d-01,-4.7341151735222d-01,-1.0241083864581d+00,
     |  -1.0957038884912d+00,-6.1547139095910d-01, 2.2340244972272d-01,
     |   1.0361821889675d+00, 1.4156856904374d+00, 1.1216430788200d+00,
     |   2.0358706725245d-01,-1.0020060325809d+00,-2.0041384082875d+00,
     |  -2.3644116827769d+00,-1.8888289688170d+00,-7.1904136585597d-01/
      data (pmn(lat, 2,16), lat = 1,72)/
     |   6.4794156729864d-02, 5.3463273683209d-01, 1.2405994436025d+00,
     |   1.8233447224237d+00, 1.9644630064781d+00, 1.5352318375403d+00,
     |   6.5939266296272d-01,-3.3871877489357d-01,-1.0769587413742d+00,
     |  -1.2840030162591d+00,-9.1736981085790d-01,-1.7801157121941d-01,
     |   5.8382623172581d-01, 1.0273320424715d+00, 9.7159662227497d-01,
     |   4.6995473784679d-01,-2.2372253992403d-01,-7.7872354593868d-01,
     |  -9.4229130811988d-01,-6.5363303150365d-01,-6.5654219722256d-02,
     |   5.3325451071407d-01, 8.5850322664229d-01, 7.6318125086366d-01,
     |   3.0393744926920d-01,-2.9065236839942d-01,-7.3239351809630d-01,
     |  -8.1191147737725d-01,-4.9721046422782d-01, 5.3824833176897d-02,
     |   5.7174810747326d-01, 8.0626091570013d-01, 6.4636226944177d-01,
     |   1.7259629807150d-01,-3.8309730677160d-01,-7.5012247291759d-01,
     |  -7.5012247291759d-01,-3.8309730677160d-01, 1.7259629807150d-01,
     |   6.4636226944177d-01, 8.0626091570013d-01, 5.7174810747325d-01,
     |   5.3824833176898d-02,-4.9721046422781d-01,-8.1191147737726d-01,
     |  -7.3239351809631d-01,-2.9065236839942d-01, 3.0393744926920d-01,
     |   7.6318125086366d-01, 8.5850322664229d-01, 5.3325451071407d-01,
     |  -6.5654219722248d-02,-6.5363303150365d-01,-9.4229130811989d-01,
     |  -7.7872354593868d-01,-2.2372253992403d-01, 4.6995473784679d-01,
     |   9.7159662227497d-01, 1.0273320424715d+00, 5.8382623172582d-01,
     |  -1.7801157121941d-01,-9.1736981085790d-01,-1.2840030162591d+00,
     |  -1.0769587413742d+00,-3.3871877489357d-01, 6.5939266296272d-01,
     |   1.5352318375403d+00, 1.9644630064781d+00, 1.8233447224237d+00,
     |   1.2405994436025d+00, 5.3463273683209d-01, 6.4794156729864d-02/
      data (pmn(lat, 3,16), lat = 1,72)/
     |   3.8530519498143d-03, 9.7553546603925d-02, 3.9609305377581d-01,
     |   8.8626158971512d-01, 1.4126393528576d+00, 1.7438403623067d+00,
     |   1.6848806276625d+00, 1.1815658772802d+00, 3.6473400016031d-01,
     |  -4.9060948145746d-01,-1.0763167371302d+00,-1.1834902029888d+00,
     |  -7.9581528603040d-01,-9.9874315530189d-02, 5.9420260934713d-01,
     |   9.8735350964049d-01, 9.2135577956791d-01, 4.4534268394802d-01,
     |  -2.1079176461335d-01,-7.4358514346972d-01,-9.1459353821474d-01,
     |  -6.5709390893595d-01,-1.0264552228600d-01, 4.8360452311812d-01,
     |   8.2794128288731d-01, 7.7500099723483d-01, 3.5787207643613d-01,
     |  -2.2043227463644d-01,-6.8447485181304d-01,-8.1654600574783d-01,
     |  -5.5831484304046d-01,-3.6633437298496d-02, 4.9800635817500d-01,
     |   7.9083512535388d-01, 7.0346950362430d-01, 2.7900170817922d-01,
     |  -2.7900170817922d-01,-7.0346950362430d-01,-7.9083512535389d-01,
     |  -4.9800635817500d-01, 3.6633437298494d-02, 5.5831484304046d-01,
     |   8.1654600574783d-01, 6.8447485181305d-01, 2.2043227463644d-01,
     |  -3.5787207643613d-01,-7.7500099723483d-01,-8.2794128288731d-01,
     |  -4.8360452311812d-01, 1.0264552228600d-01, 6.5709390893595d-01,
     |   9.1459353821474d-01, 7.4358514346972d-01, 2.1079176461335d-01,
     |  -4.4534268394802d-01,-9.2135577956791d-01,-9.8735350964049d-01,
     |  -5.9420260934713d-01, 9.9874315530191d-02, 7.9581528603039d-01,
     |   1.1834902029888d+00, 1.0763167371302d+00, 4.9060948145746d-01,
     |  -3.6473400016030d-01,-1.1815658772802d+00,-1.6848806276625d+00,
     |  -1.7438403623067d+00,-1.4126393528576d+00,-8.8626158971512d-01,
     |  -3.9609305377581d-01,-9.7553546603925d-02,-3.8530519498143d-03/
      data (pmn(lat, 4,16), lat = 1,72)/
     |   1.6971111959999d-04, 1.3065878369537d-02, 9.0956812635963d-02,
     |   2.9836255085558d-01, 6.5561558153492d-01, 1.0989508880523d+00,
     |   1.4840143557851d+00, 1.6378179567160d+00, 1.4383152830377d+00,
     |   8.8383965876641d-01, 1.1575679369237d-01,-6.2265596996770d-01,
     |  -1.0785251625478d+00,-1.0947376008573d+00,-6.8119384608507d-01,
     |  -1.7577455873316d-02, 6.1722373466013d-01, 9.6076455159645d-01,
     |   8.7801527173867d-01, 4.1848030208816d-01,-2.0673151991538d-01,
     |  -7.1865260080227d-01,-8.9387350398311d-01,-6.6273984786590d-01,
     |  -1.3840570475692d-01, 4.3620075620957d-01, 7.9939032522783d-01,
     |   7.8932895213405d-01, 4.1645715455800d-01,-1.4300368916903d-01,
     |  -6.2914399350665d-01,-8.1822233073143d-01,-6.2525578109088d-01,
     |  -1.4234829193730d-01, 4.0464936469649d-01, 7.6099367647522d-01,
     |   7.6099367647522d-01, 4.0464936469649d-01,-1.4234829193730d-01,
     |  -6.2525578109088d-01,-8.1822233073143d-01,-6.2914399350665d-01,
     |  -1.4300368916903d-01, 4.1645715455800d-01, 7.8932895213405d-01,
     |   7.9939032522783d-01, 4.3620075620957d-01,-1.3840570475692d-01,
     |  -6.6273984786590d-01,-8.9387350398311d-01,-7.1865260080227d-01,
     |  -2.0673151991539d-01, 4.1848030208815d-01, 8.7801527173867d-01,
     |   9.6076455159645d-01, 6.1722373466013d-01,-1.7577455873314d-02,
     |  -6.8119384608507d-01,-1.0947376008573d+00,-1.0785251625479d+00,
     |  -6.2265596996770d-01, 1.1575679369237d-01, 8.8383965876641d-01,
     |   1.4383152830377d+00, 1.6378179567160d+00, 1.4840143557851d+00,
     |   1.0989508880523d+00, 6.5561558153492d-01, 2.9836255085558d-01,
     |   9.0956812635963d-02, 1.3065878369537d-02, 1.6971111959999d-04/
      data (pmn(lat, 5,16), lat = 1,72)/
     |   5.8841580299742d-06, 1.3714175779889d-03, 1.6211982043969d-02,
     |   7.6689131491681d-02, 2.2614192084498d-01, 4.9196812411070d-01,
     |   8.5441999989195d-01, 1.2313245732001d+00, 1.4934518964338d+00,
     |   1.5106148652142d+00, 1.2115612354844d+00, 6.3016696212788d-01,
     |  -8.7353874660738d-02,-7.2422401782053d-01,-1.0717484146866d+00,
     |  -1.0139404352696d+00,-5.8117992581464d-01, 5.3424455753206d-02,
     |   6.3769216116423d-01, 9.4024515882978d-01, 8.4538186021310d-01,
     |   4.0189074621534d-01,-1.9673228010832d-01,-6.9389060854581d-01,
     |  -8.7924664639149d-01,-6.7880103234937d-01,-1.8624782424958d-01,
     |   3.7859375637193d-01, 7.6649749998518d-01, 8.0840014928422d-01,
     |   4.8952395612946d-01,-4.4810201699701d-02,-5.5434788070065d-01,
     |  -8.1114644496950d-01,-7.0118255265326d-01,-2.7502760243875d-01,
     |   2.7502760243875d-01, 7.0118255265326d-01, 8.1114644496950d-01,
     |   5.5434788070066d-01, 4.4810201699702d-02,-4.8952395612946d-01,
     |  -8.0840014928422d-01,-7.6649749998518d-01,-3.7859375637193d-01,
     |   1.8624782424958d-01, 6.7880103234937d-01, 8.7924664639149d-01,
     |   6.9389060854581d-01, 1.9673228010832d-01,-4.0189074621534d-01,
     |  -8.4538186021310d-01,-9.4024515882978d-01,-6.3769216116424d-01,
     |  -5.3424455753208d-02, 5.8117992581464d-01, 1.0139404352696d+00,
     |   1.0717484146866d+00, 7.2422401782053d-01, 8.7353874660745d-02,
     |  -6.3016696212788d-01,-1.2115612354844d+00,-1.5106148652142d+00,
     |  -1.4934518964338d+00,-1.2313245732001d+00,-8.5441999989195d-01,
     |  -4.9196812411070d-01,-2.2614192084498d-01,-7.6689131491681d-02,
     |  -1.6211982043969d-02,-1.3714175779889d-03,-5.8841580299742d-06/
      data (pmn(lat, 6,16), lat = 1,72)/
     |   1.6655219577581d-07, 1.1721900527185d-04, 2.3405797322524d-03,
     |   1.5827249441112d-02, 6.1797750679717d-02, 1.7097670289002d-01,
     |   3.6999842124482d-01, 6.6044404529586d-01, 1.0009742224732d+00,
     |   1.3049857963576d+00, 1.4611686253567d+00, 1.3737660293743d+00,
     |   1.0080455695410d+00, 4.2038412695004d-01,-2.4447811847432d-01,
     |  -7.9417107342209d-01,-1.0558524861676d+00,-9.4453943600522d-01,
     |  -5.0355554792958d-01, 1.0301645140307d-01, 6.4710992068556d-01,
     |   9.2277700010348d-01, 8.2765427459426d-01, 4.0562456370986d-01,
     |  -1.6884358936338d-01,-6.6030586326982d-01,-8.6841956842071d-01,
     |  -7.1083118081737d-01,-2.5771753515565d-01, 2.9739527522476d-01,
     |   7.1901245209159d-01, 8.2922693739380d-01, 5.8319627006406d-01,
     |   8.8154310991776d-02,-4.4246813737101d-01,-7.8041519861589d-01,
     |  -7.8041519861589d-01,-4.4246813737101d-01, 8.8154310991774d-02,
     |   5.8319627006406d-01, 8.2922693739380d-01, 7.1901245209159d-01,
     |   2.9739527522476d-01,-2.5771753515565d-01,-7.1083118081737d-01,
     |  -8.6841956842071d-01,-6.6030586326982d-01,-1.6884358936339d-01,
     |   4.0562456370986d-01, 8.2765427459426d-01, 9.2277700010348d-01,
     |   6.4710992068557d-01, 1.0301645140307d-01,-5.0355554792957d-01,
     |  -9.4453943600522d-01,-1.0558524861676d+00,-7.9417107342210d-01,
     |  -2.4447811847432d-01, 4.2038412695004d-01, 1.0080455695410d+00,
     |   1.3737660293743d+00, 1.4611686253567d+00, 1.3049857963576d+00,
     |   1.0009742224732d+00, 6.6044404529586d-01, 3.6999842124482d-01,
     |   1.7097670289002d-01, 6.1797750679717d-02, 1.5827249441112d-02,
     |   2.3405797322524d-03, 1.1721900527185d-04, 1.6655219577581d-07/
      data (pmn(lat, 7,16), lat = 1,72)/
     |   3.9386014608274d-09, 8.3574064439426d-06, 2.8095661357316d-04,
     |   2.7016520150219d-03, 1.3859952301096d-02, 4.8231138947908d-02,
     |   1.2800085235573d-01, 2.7643537256514d-01, 5.0477897059073d-01,
     |   7.9719215233119d-01, 1.1016937347961d+00, 1.3349448141162d+00,
     |   1.4040451911819d+00, 1.2406951381523d+00, 8.3552602729025d-01,
     |   2.5709321608182d-01,-3.5650000612625d-01,-8.3551647310405d-01,
     |  -1.0355409937682d+00,-8.9297695003980d-01,-4.5620741284872d-01,
     |   1.2312903673248d-01, 6.3938060090040d-01, 9.0652108397249d-01,
     |   8.2859719661622d-01, 4.3862939205305d-01,-1.1130532786197d-01,
     |  -6.0706932875421d-01,-8.5546061216994d-01,-7.6063237985473d-01,
     |  -3.6291713511932d-01, 1.7647692376272d-01, 6.3965043136285d-01,
     |   8.3967691674041d-01, 6.9629456419841d-01, 2.6863693112713d-01,
     |  -2.6863693112713d-01,-6.9629456419841d-01,-8.3967691674041d-01,
     |  -6.3965043136285d-01,-1.7647692376272d-01, 3.6291713511932d-01,
     |   7.6063237985473d-01, 8.5546061216994d-01, 6.0706932875422d-01,
     |   1.1130532786197d-01,-4.3862939205305d-01,-8.2859719661622d-01,
     |  -9.0652108397249d-01,-6.3938060090040d-01,-1.2312903673248d-01,
     |   4.5620741284872d-01, 8.9297695003980d-01, 1.0355409937682d+00,
     |   8.3551647310405d-01, 3.5650000612625d-01,-2.5709321608182d-01,
     |  -8.3552602729025d-01,-1.2406951381523d+00,-1.4040451911819d+00,
     |  -1.3349448141162d+00,-1.1016937347961d+00,-7.9719215233120d-01,
     |  -5.0477897059074d-01,-2.7643537256514d-01,-1.2800085235573d-01,
     |  -4.8231138947909d-02,-1.3859952301096d-02,-2.7016520150219d-03,
     |  -2.8095661357316d-04,-8.3574064439426d-06,-3.9386014608274d-09/
      data (pmn(lat, 8,16), lat = 1,72)/
     |   7.8967588077676d-11, 5.0467082302468d-07, 2.8502684775368d-05,
     |   3.8842699511818d-04, 2.6054613844271d-03, 1.1326948542260d-02,
     |   3.6525330256970d-02, 9.4223909436338d-02, 2.0357926095501d-01,
     |   3.7922920415686d-01, 6.2029756751825d-01, 9.0030790166426d-01,
     |   1.1638723378214d+00, 1.3349855155035d+00, 1.3377538706458d+00,
     |   1.1246452332286d+00, 7.0229939076763d-01, 1.4326543427300d-01,
     |  -4.2468775449907d-01,-8.5228625109777d-01,-1.0165341660218d+00,
     |  -8.6621162062092d-01,-4.4709394021256d-01, 1.0544140763296d-01,
     |   6.0725678903609d-01, 8.8741933352474d-01, 8.4946791116765d-01,
     |   5.0862427734983d-01,-1.0680900384073d-02,-5.1807254776557d-01,
     |  -8.2654202992297d-01,-8.2223933917349d-01,-5.0801646374133d-01,
     |  -3.3675191718787d-03, 5.0005566568999d-01, 8.1089310050945d-01,
     |   8.1089310050945d-01, 5.0005566569000d-01,-3.3675191718772d-03,
     |  -5.0801646374133d-01,-8.2223933917349d-01,-8.2654202992297d-01,
     |  -5.1807254776557d-01,-1.0680900384077d-02, 5.0862427734982d-01,
     |   8.4946791116764d-01, 8.8741933352474d-01, 6.0725678903610d-01,
     |   1.0544140763296d-01,-4.4709394021256d-01,-8.6621162062092d-01,
     |  -1.0165341660218d+00,-8.5228625109777d-01,-4.2468775449907d-01,
     |   1.4326543427300d-01, 7.0229939076763d-01, 1.1246452332286d+00,
     |   1.3377538706458d+00, 1.3349855155035d+00, 1.1638723378214d+00,
     |   9.0030790166426d-01, 6.2029756751825d-01, 3.7922920415686d-01,
     |   2.0357926095501d-01, 9.4223909436338d-02, 3.6525330256970d-02,
     |   1.1326948542260d-02, 2.6054613844271d-03, 3.8842699511818d-04,
     |   2.8502684775368d-05, 5.0467082302468d-07, 7.8967588077676d-11/
      data (pmn(lat, 9,16), lat = 1,72)/
     |   1.3541046339113d-12, 2.6045087157072d-08, 2.4675517086495d-06,
     |   4.7545716251590d-05, 4.1562015699914d-04, 2.2472283761495d-03,
     |   8.7527832940251d-03, 2.6759842638088d-02, 6.7694567331466d-02,
     |   1.4662133705559d-01, 2.7816870589700d-01, 4.6931468691192d-01,
     |   7.1084527386892d-01, 9.7105080347594d-01, 1.1958436110288d+00,
     |   1.3181870138332d+00, 1.2765089166273d+00, 1.0376117848365d+00,
     |   6.1620685870653d-01, 8.2382717707036d-02,-4.4892982675899d-01,
     |  -8.4653000080054d-01,-1.0024479780793d+00,-8.6969537265391d-01,
     |  -4.8418445854976d-01, 3.9281152385240d-02, 5.3854983301143d-01,
     |   8.5466237269111d-01, 8.8491876108230d-01, 6.1963040622653d-01,
     |   1.4833078169905d-01,-3.6843994445561d-01,-7.5320748604866d-01,
     |  -8.7303510237979d-01,-6.8652942788860d-01,-2.5915749467710d-01,
     |   2.5915749467709d-01, 6.8652942788860d-01, 8.7303510237979d-01,
     |   7.5320748604866d-01, 3.6843994445561d-01,-1.4833078169905d-01,
     |  -6.1963040622653d-01,-8.8491876108230d-01,-8.5466237269111d-01,
     |  -5.3854983301143d-01,-3.9281152385243d-02, 4.8418445854975d-01,
     |   8.6969537265391d-01, 1.0024479780793d+00, 8.4653000080054d-01,
     |   4.4892982675900d-01,-8.2382717707034d-02,-6.1620685870653d-01,
     |  -1.0376117848365d+00,-1.2765089166273d+00,-1.3181870138332d+00,
     |  -1.1958436110288d+00,-9.7105080347594d-01,-7.1084527386892d-01,
     |  -4.6931468691192d-01,-2.7816870589700d-01,-1.4662133705559d-01,
     |  -6.7694567331466d-02,-2.6759842638088d-02,-8.7527832940251d-03,
     |  -2.2472283761495d-03,-4.1562015699914d-04,-4.7545716251590d-05,
     |  -2.4675517086495d-06,-2.6045087157072d-08,-1.3541046339113d-12/
      data (pmn(lat,10,16), lat = 1,72)/
     |   1.9933812123710d-14, 1.1533181953097d-09, 1.8309858230375d-07,
     |   4.9799628789817d-06, 5.6598614979705d-05, 3.7942449561274d-04,
     |   1.7777922781779d-03, 6.4079426064881d-03, 1.8852024964098d-02,
     |   4.7061267845891d-02, 1.0236161700388d-01, 1.9760093858402d-01,
     |   3.4291832771836d-01, 5.3959228394511d-01, 7.7371244060250d-01,
     |   1.0124576326936d+00, 1.2058952870243d+00, 1.2960138106576d+00,
     |   1.2322533898859d+00, 9.8983516428458d-01, 5.8488181194601d-01,
     |   7.9866324880605d-02,-4.2501714057472d-01,-8.1467455492850d-01,
     |  -9.9099817404883d-01,-9.0442207042683d-01,-5.7431060448654d-01,
     |  -8.9732170116486d-02, 4.1199086968514d-01, 7.8406065381802d-01,
     |   9.1487978567513d-01, 7.6415759278090d-01, 3.7786686927593d-01,
     |  -1.2404126684309d-01,-5.8423865227318d-01,-8.5759190031152d-01,
     |  -8.5759190031152d-01,-5.8423865227318d-01,-1.2404126684309d-01,
     |   3.7786686927593d-01, 7.6415759278090d-01, 9.1487978567513d-01,
     |   7.8406065381802d-01, 4.1199086968514d-01,-8.9732170116485d-02,
     |  -5.7431060448654d-01,-9.0442207042683d-01,-9.9099817404883d-01,
     |  -8.1467455492850d-01,-4.2501714057472d-01, 7.9866324880605d-02,
     |   5.8488181194601d-01, 9.8983516428458d-01, 1.2322533898859d+00,
     |   1.2960138106576d+00, 1.2058952870243d+00, 1.0124576326936d+00,
     |   7.7371244060250d-01, 5.3959228394511d-01, 3.4291832771836d-01,
     |   1.9760093858402d-01, 1.0236161700388d-01, 4.7061267845891d-02,
     |   1.8852024964098d-02, 6.4079426064881d-03, 1.7777922781779d-03,
     |   3.7942449561275d-04, 5.6598614979705d-05, 4.9799628789817d-06,
     |   1.8309858230375d-07, 1.1533181953097d-09, 1.9933812123710d-14/
      data (pmn(lat,11,16), lat = 1,72)/
     |   2.5167281873690d-16, 4.3783323539000d-11, 1.1638339986202d-08,
     |   4.4626192965843d-07, 6.5828955640462d-06, 5.4591030778088d-05,
     |   3.0681186080435d-04, 1.2990171940379d-03, 4.4240051792257d-03,
     |   1.2654647118484d-02, 3.1322905927614d-02, 6.8524753885386d-02,
     |   1.3453973406740d-01, 2.3970502552375d-01, 3.9059008464522d-01,
     |   5.8506064173012d-01, 8.0768517318110d-01, 1.0275460071840d+00,
     |   1.2004657791691d+00, 1.2767079436640d+00, 1.2134533860578d+00,
     |   9.8928342462080d-01, 6.1628403078008d-01, 1.4501180255128d-01,
     |  -3.4110822116117d-01,-7.4247499451278d-01,-9.6791044775647d-01,
     |  -9.6071647568423d-01,-7.1819780321766d-01,-2.9766165912332d-01,
     |   1.9455662326811d-01, 6.2936703072738d-01, 8.8973753500367d-01,
     |   9.0401189072069d-01, 6.6750313307345d-01, 2.4528523167605d-01,
     |  -2.4528523167605d-01,-6.6750313307345d-01,-9.0401189072069d-01,
     |  -8.8973753500367d-01,-6.2936703072738d-01,-1.9455662326811d-01,
     |   2.9766165912332d-01, 7.1819780321766d-01, 9.6071647568423d-01,
     |   9.6791044775647d-01, 7.4247499451278d-01, 3.4110822116117d-01,
     |  -1.4501180255128d-01,-6.1628403078008d-01,-9.8928342462080d-01,
     |  -1.2134533860578d+00,-1.2767079436640d+00,-1.2004657791691d+00,
     |  -1.0275460071840d+00,-8.0768517318110d-01,-5.8506064173013d-01,
     |  -3.9059008464522d-01,-2.3970502552375d-01,-1.3453973406740d-01,
     |  -6.8524753885386d-02,-3.1322905927614d-02,-1.2654647118484d-02,
     |  -4.4240051792257d-03,-1.2990171940379d-03,-3.0681186080435d-04,
     |  -5.4591030778089d-05,-6.5828955640462d-06,-4.4626192965843d-07,
     |  -1.1638339986202d-08,-4.3783323539000d-11,-2.5167281873690d-16/
      data (pmn(lat,12,16), lat = 1,72)/
     |   2.7075957478050d-18, 1.4159177846519d-12, 6.2979532951265d-10,
     |   3.4013022322701d-08, 6.5035957562785d-07, 6.6604435995727d-06,
     |   4.4803504486411d-05, 2.2222430995924d-04, 8.7319016466659d-04,
     |   2.8502880753564d-03, 7.9878786421084d-03, 1.9678705220210d-02,
     |   4.3363503140972d-02, 8.6584173848971d-02, 1.5817880717076d-01,
     |   2.6629695763638d-01, 4.1524154060323d-01, 6.0166409727087d-01,
     |   8.1120325834558d-01, 1.0170245825092d+00, 1.1816485852081d+00,
     |   1.2628011950009d+00, 1.2228466910628d+00, 1.0399632674075d+00,
     |   7.1806867967472d-01, 2.9209835777847d-01,-1.7408629041616d-01,
     |  -5.9812787318504d-01,-8.9647914957413d-01,-1.0047356937063d+00,
     |  -8.9562256880970d-01,-5.8924009195310d-01,-1.5184874344341d-01,
     |   3.1751654834551d-01, 7.0981584161141d-01, 9.3246798670796d-01,
     |   9.3246798670796d-01, 7.0981584161141d-01, 3.1751654834551d-01,
     |  -1.5184874344341d-01,-5.8924009195310d-01,-8.9562256880970d-01,
     |  -1.0047356937063d+00,-8.9647914957413d-01,-5.9812787318504d-01,
     |  -1.7408629041616d-01, 2.9209835777847d-01, 7.1806867967472d-01,
     |   1.0399632674075d+00, 1.2228466910628d+00, 1.2628011950009d+00,
     |   1.1816485852081d+00, 1.0170245825093d+00, 8.1120325834558d-01,
     |   6.0166409727087d-01, 4.1524154060323d-01, 2.6629695763639d-01,
     |   1.5817880717076d-01, 8.6584173848971d-02, 4.3363503140972d-02,
     |   1.9678705220210d-02, 7.9878786421084d-03, 2.8502880753564d-03,
     |   8.7319016466660d-04, 2.2222430995924d-04, 4.4803504486411d-05,
     |   6.6604435995729d-06, 6.5035957562785d-07, 3.4013022322701d-08,
     |   6.2979532951265d-10, 1.4159177846519d-12, 2.7075957478050d-18/
      data (pmn(lat,13,16), lat = 1,72)/
     |   2.4474922520910d-20, 3.8463947279259d-14, 2.8614414127182d-11,
     |   2.1749888797931d-09, 5.3852610516073d-08, 6.8019150132243d-07,
     |   5.4674048425908d-06, 3.1703973537649d-05, 1.4337347645775d-04,
     |   5.3245666468125d-04, 1.6833237648108d-03, 4.6491810677742d-03,
     |   1.1435545572737d-02, 2.5416943018388d-02, 5.1619955603411d-02,
     |   9.6621770292151d-02, 1.6779000478618d-01, 2.7167859841983d-01,
     |   4.1162098450008d-01, 5.8489823656682d-01, 7.8021604896646d-01,
     |   9.7646223621364d-01, 1.1436929346557d+00, 1.2469221044291d+00,
     |   1.2525847036691d+00, 1.1366606506566d+00, 8.9264451343259d-01,
     |   5.3712094558975d-01, 1.1088825349032d-01,-3.2557125364689d-01,
     |  -7.0209585420259d-01,-9.5259317961526d-01,-1.0295356828522d+00,
     |  -9.1564920227983d-01,-6.2964021594946d-01,-2.2412846351720d-01,
     |   2.2412846351720d-01, 6.2964021594946d-01, 9.1564920227983d-01,
     |   1.0295356828522d+00, 9.5259317961526d-01, 7.0209585420259d-01,
     |   3.2557125364689d-01,-1.1088825349032d-01,-5.3712094558975d-01,
     |  -8.9264451343259d-01,-1.1366606506566d+00,-1.2525847036691d+00,
     |  -1.2469221044291d+00,-1.1436929346557d+00,-9.7646223621364d-01,
     |  -7.8021604896646d-01,-5.8489823656682d-01,-4.1162098450008d-01,
     |  -2.7167859841983d-01,-1.6779000478618d-01,-9.6621770292152d-02,
     |  -5.1619955603411d-02,-2.5416943018388d-02,-1.1435545572737d-02,
     |  -4.6491810677742d-03,-1.6833237648108d-03,-5.3245666468126d-04,
     |  -1.4337347645775d-04,-3.1703973537649d-05,-5.4674048425908d-06,
     |  -6.8019150132245d-07,-5.3852610516073d-08,-2.1749888797931d-09,
     |  -2.8614414127182d-11,-3.8463947279259d-14,-2.4474922520910d-20/
      data (pmn(lat,14,16), lat = 1,72)/
     |   1.8094896471353d-22, 8.5444518140702d-16, 1.0627170211991d-12,
     |   1.1362164324927d-10, 3.6400185818102d-09, 5.6643895442198d-08,
     |   5.4335424496169d-07, 3.6777484677413d-06, 1.9104950094534d-05,
     |   8.0538287224783d-05, 2.8644228541548d-04, 8.8403033501020d-04,
     |   2.4176530132881d-03, 5.9532655988154d-03, 1.3363917623698d-02,
     |   2.7615958890790d-02, 5.2940254520146d-02, 9.4726836938396d-02,
     |   1.5897287650864d-01, 2.5116935019825d-01, 3.7464392875865d-01,
     |   5.2857259970796d-01, 7.0608483911129d-01, 8.9304580738369d-01,
     |   1.0681270200676d+00, 1.2046189125255d+00, 1.2740884546537d+00,
     |   1.2515011159752d+00, 1.1209277840793d+00, 8.8059472339197d-01,
     |   5.4594662530242d-01, 1.4965619590995d-01,-2.6189109899352d-01,
     |  -6.3530529266556d-01,-9.1895149831425d-01,-1.0720269456362d+00,
     |  -1.0720269456362d+00,-9.1895149831425d-01,-6.3530529266556d-01,
     |  -2.6189109899352d-01, 1.4965619590995d-01, 5.4594662530242d-01,
     |   8.8059472339197d-01, 1.1209277840793d+00, 1.2515011159752d+00,
     |   1.2740884546537d+00, 1.2046189125255d+00, 1.0681270200676d+00,
     |   8.9304580738369d-01, 7.0608483911129d-01, 5.2857259970796d-01,
     |   3.7464392875866d-01, 2.5116935019825d-01, 1.5897287650864d-01,
     |   9.4726836938396d-02, 5.2940254520147d-02, 2.7615958890790d-02,
     |   1.3363917623698d-02, 5.9532655988154d-03, 2.4176530132881d-03,
     |   8.8403033501020d-04, 2.8644228541548d-04, 8.0538287224784d-05,
     |   1.9104950094534d-05, 3.6777484677413d-06, 5.4335424496169d-07,
     |   5.6643895442199d-08, 3.6400185818102d-09, 1.1362164324927d-10,
     |   1.0627170211991d-12, 8.5444518140702d-16, 1.8094896471353d-22/
      data (pmn(lat,15,16), lat = 1,72)/
     |   1.0363199921862d-24, 1.4701118289422d-17, 3.0559810148080d-14,
     |   4.5936605020799d-12, 1.9028875881020d-10, 3.6452438688402d-09,
     |   4.1685808611374d-08, 3.2893432869848d-07, 1.9598798873298d-06,
     |   9.3616395282789d-06, 3.7378480920065d-05, 1.2858538415496d-04,
     |   3.8984177073322d-04, 1.0598251481705d-03, 2.6187999991090d-03,
     |   5.9450041074656d-03, 1.2506259547971d-02, 2.4550771371590d-02,
     |   4.5231893129037d-02, 7.8577156991954d-02, 1.2920482768262d-01,
     |   2.0171415870021d-01, 2.9973537684759d-01, 4.2471842566306d-01,
     |   5.7464833496596d-01, 7.4297040799945d-01, 9.1805547456315d-01,
     |   1.0835046279319d+00, 1.2194711636601d+00, 1.3049769595505d+00,
     |   1.3209600970541d+00, 1.2535686605239d+00, 1.0970758648350d+00,
     |   8.5578377457602d-01, 5.4442620087095d-01, 1.8685546299110d-01,
     |  -1.8685546299110d-01,-5.4442620087095d-01,-8.5578377457602d-01,
     |  -1.0970758648350d+00,-1.2535686605239d+00,-1.3209600970541d+00,
     |  -1.3049769595505d+00,-1.2194711636601d+00,-1.0835046279319d+00,
     |  -9.1805547456315d-01,-7.4297040799945d-01,-5.7464833496596d-01,
     |  -4.2471842566306d-01,-2.9973537684759d-01,-2.0171415870021d-01,
     |  -1.2920482768262d-01,-7.8577156991955d-02,-4.5231893129038d-02,
     |  -2.4550771371590d-02,-1.2506259547971d-02,-5.9450041074656d-03,
     |  -2.6187999991089d-03,-1.0598251481705d-03,-3.8984177073323d-04,
     |  -1.2858538415496d-04,-3.7378480920065d-05,-9.3616395282790d-06,
     |  -1.9598798873298d-06,-3.2893432869849d-07,-4.1685808611374d-08,
     |  -3.6452438688403d-09,-1.9028875881020d-10,-4.5936605020799d-12,
     |  -3.0559810148080d-14,-1.4701118289422d-17,-1.0363199921862d-24/
      data (pmn(lat,16,16), lat = 1,72)/
     |   3.9973776366812d-27, 1.7033534141906d-19, 5.9164393941622d-16,
     |   1.2498677597794d-13, 6.6911371287443d-12, 1.5768224892403d-10,
     |   2.1478907973029d-09, 1.9738560309042d-08, 1.3473134918358d-07,
     |   7.2818209506204d-07, 3.2585295792944d-06, 1.2470598378834d-05,
     |   4.1818612121358d-05, 1.2518486294759d-04, 3.3944371186891d-04,
     |   8.4346706302452d-04, 1.9388329237285d-03, 4.1546502107807d-03,
     |   8.3526726873546d-03, 1.5839205183956d-02, 2.8458551649130d-02,
     |   4.8631869967845d-02, 7.9299496235928d-02, 1.2372853760891d-01,
     |   1.8516397194055d-01, 2.6633087624136d-01, 3.6883392895920d-01,
     |   4.9254009483046d-01, 6.3506076796091d-01, 7.9145986853683d-01,
     |   9.5429687861715d-01, 1.1140671042937d+00, 1.2600318185279d+00,
     |   1.3813518114805d+00, 1.4683671031262d+00, 1.5138209779859d+00,
     |   1.5138209779859d+00, 1.4683671031262d+00, 1.3813518114805d+00,
     |   1.2600318185279d+00, 1.1140671042937d+00, 9.5429687861715d-01,
     |   7.9145986853683d-01, 6.3506076796091d-01, 4.9254009483046d-01,
     |   3.6883392895920d-01, 2.6633087624136d-01, 1.8516397194055d-01,
     |   1.2372853760891d-01, 7.9299496235928d-02, 4.8631869967845d-02,
     |   2.8458551649130d-02, 1.5839205183957d-02, 8.3526726873547d-03,
     |   4.1546502107807d-03, 1.9388329237285d-03, 8.4346706302453d-04,
     |   3.3944371186891d-04, 1.2518486294759d-04, 4.1818612121359d-05,
     |   1.2470598378834d-05, 3.2585295792944d-06, 7.2818209506205d-07,
     |   1.3473134918358d-07, 1.9738560309042d-08, 2.1478907973029d-09,
     |   1.5768224892403d-10, 6.6911371287443d-12, 1.2498677597794d-13,
     |   5.9164393941622d-16, 1.7033534141906d-19, 3.9973776366812d-27/
      data (pmn(lat, 0,17), lat = 1,72)/
     |   4.0323586882779d+00, 2.9205092625100d+00, 1.1576839768417d+00,
     |  -5.4643951637711d-01,-1.5552135551981d+00,-1.5826848024743d+00,
     |  -7.9735545068236d-01, 2.9055092054123d-01, 1.0949678792109d+00,
     |   1.2377506808168d+00, 7.1202852488249d-01,-1.4773591593756d-01,
     |  -8.6274417528908d-01,-1.0656655667648d+00,-6.8279954507694d-01,
     |   4.6029591443520d-02, 7.1137153451994d-01, 9.5907664006838d-01,
     |   6.7521269081943d-01, 3.5837511857655d-02,-5.9903343687859d-01,
     |  -8.8525896477006d-01,-6.7883320984488d-01,-1.0697041640135d-01,
     |   5.0853767601868d-01, 8.3055854048978d-01, 6.8963947909223d-01,
     |   1.7227082588227d-01,-4.3119893826283d-01,-7.8822552052821d-01,
     |  -7.0602049402817d-01,-2.3491480631784d-01, 3.6193629792309d-01,
     |   7.5458221326514d-01, 7.2754860406581d-01, 2.9736812659306d-01,
     |  -2.9736812659306d-01,-7.2754860406581d-01,-7.5458221326514d-01,
     |  -3.6193629792309d-01, 2.3491480631784d-01, 7.0602049402817d-01,
     |   7.8822552052822d-01, 4.3119893826284d-01,-1.7227082588227d-01,
     |  -6.8963947909223d-01,-8.3055854048978d-01,-5.0853767601868d-01,
     |   1.0697041640135d-01, 6.7883320984488d-01, 8.8525896477006d-01,
     |   5.9903343687860d-01,-3.5837511857652d-02,-6.7521269081943d-01,
     |  -9.5907664006838d-01,-7.1137153451994d-01,-4.6029591443524d-02,
     |   6.8279954507694d-01, 1.0656655667648d+00, 8.6274417528909d-01,
     |   1.4773591593756d-01,-7.1202852488249d-01,-1.2377506808168d+00,
     |  -1.0949678792109d+00,-2.9055092054124d-01, 7.9735545068236d-01,
     |   1.5826848024743d+00, 1.5552135551981d+00, 5.4643951637711d-01,
     |  -1.1576839768417d+00,-2.9205092625100d+00,-4.0323586882779d+00/
      data (pmn(lat, 1,17), lat = 1,72)/
     |   7.8383309749830d-01, 2.0239372525326d+00, 2.4326878291361d+00,
     |   1.8871147649787d+00, 6.9133157868736d-01,-5.7987573242041d-01,
     |  -1.3602480621530d+00,-1.3557592400007d+00,-6.6567413034820d-01,
     |   2.9229431399091d-01, 1.0075528412591d+00, 1.1347048054903d+00,
     |   6.5434641973663d-01,-1.3916097299801d-01,-8.0827027087523d-01,
     |  -1.0067516023572d+00,-6.5495334429565d-01, 3.1924282018062d-02,
     |   6.7091301158775d-01, 9.2109390960828d-01, 6.6295813497514d-01,
     |   5.3925752080426d-02,-5.6521649225471d-01,-8.5871945493739d-01,
     |  -6.7614970972575d-01,-1.2855885602355d-01, 4.7768024423609d-01,
     |   8.1074666144457d-01, 6.9360213534744d-01, 1.9737387155914d-01,
     |  -4.0106244972246d-01,-7.7245085272347d-01,-7.1513569167331d-01,
     |  -2.6388075958505d-01, 3.3086941881687d-01, 7.4111655386370d-01,
     |   7.4111655386370d-01, 3.3086941881688d-01,-2.6388075958505d-01,
     |  -7.1513569167331d-01,-7.7245085272347d-01,-4.0106244972246d-01,
     |   1.9737387155914d-01, 6.9360213534743d-01, 8.1074666144458d-01,
     |   4.7768024423610d-01,-1.2855885602355d-01,-6.7614970972575d-01,
     |  -8.5871945493739d-01,-5.6521649225471d-01, 5.3925752080426d-02,
     |   6.6295813497513d-01, 9.2109390960828d-01, 6.7091301158775d-01,
     |   3.1924282018063d-02,-6.5495334429564d-01,-1.0067516023572d+00,
     |  -8.0827027087522d-01,-1.3916097299801d-01, 6.5434641973663d-01,
     |   1.1347048054903d+00, 1.0075528412591d+00, 2.9229431399092d-01,
     |  -6.6567413034820d-01,-1.3557592400007d+00,-1.3602480621530d+00,
     |  -5.7987573242042d-01, 6.9133157868736d-01, 1.8871147649787d+00,
     |   2.4326878291361d+00, 2.0239372525326d+00, 7.8383309749830d-01/
      data (pmn(lat, 2,17), lat = 1,72)/
     |   7.4999213647781d-02, 6.1199993594522d-01, 1.3864871372104d+00,
     |   1.9546421612051d+00, 1.9589949100395d+00, 1.3160527516037d+00,
     |   2.6465539357861d-01,-7.4964121395611d-01,-1.2949182669475d+00,
     |  -1.1656163389001d+00,-4.8000551512492d-01, 3.8547065650065d-01,
     |   9.8927037694371d-01, 1.0452751930708d+00, 5.5859466545710d-01,
     |  -1.9006875598400d-01,-7.9937514501387d-01,-9.5840098562983d-01,
     |  -6.0375792841805d-01, 5.6703249355616d-02, 6.6203449104280d-01,
     |   8.9270177574841d-01, 6.3774133937629d-01, 4.7549309661663d-02,
     |  -5.5275845851400d-01,-8.4055843573249d-01,-6.6779451400492d-01,
     |  -1.3667123622081d-01, 4.5962256178439d-01, 7.9741317314960d-01,
     |   6.9708176626811d-01, 2.1806141864756d-01,-3.7575081072250d-01,
     |  -7.6037533888466d-01,-7.2745034031509d-01,-2.9648974139840d-01,
     |   2.9648974139840d-01, 7.2745034031509d-01, 7.6037533888466d-01,
     |   3.7575081072250d-01,-2.1806141864756d-01,-6.9708176626811d-01,
     |  -7.9741317314960d-01,-4.5962256178439d-01, 1.3667123622081d-01,
     |   6.6779451400492d-01, 8.4055843573249d-01, 5.5275845851400d-01,
     |  -4.7549309661661d-02,-6.3774133937629d-01,-8.9270177574841d-01,
     |  -6.6203449104280d-01,-5.6703249355619d-02, 6.0375792841805d-01,
     |   9.5840098562983d-01, 7.9937514501387d-01, 1.9006875598400d-01,
     |  -5.5859466545710d-01,-1.0452751930708d+00,-9.8927037694371d-01,
     |  -3.8547065650065d-01, 4.8000551512492d-01, 1.1656163389001d+00,
     |   1.2949182669475d+00, 7.4964121395611d-01,-2.6465539357861d-01,
     |  -1.3160527516036d+00,-1.9589949100395d+00,-1.9546421612051d+00,
     |  -1.3864871372104d+00,-6.1199993594522d-01,-7.4999213647781d-02/
      data (pmn(lat, 3,17), lat = 1,72)/
     |   4.7379763659193d-03, 1.1897496351103d-01, 4.7483209150449d-01,
     |   1.0331732685842d+00, 1.5784959559546d+00, 1.8257855648051d+00,
     |   1.5789780143136d+00, 8.5476608398632d-01,-9.8904843653459d-02,
     |  -9.0601176361946d-01,-1.2390343027819d+00,-9.7998126432510d-01,
     |  -2.8220021872337d-01, 5.0136023405718d-01, 9.8957730534493d-01,
     |   9.5874964313489d-01, 4.4880041071477d-01,-2.6334411090602d-01,
     |  -8.0884798097326d-01,-9.1573014766208d-01,-5.4465576876930d-01,
     |   9.6879171813520d-02, 6.6738151047805d-01, 8.7108875509971d-01,
     |   6.1060901193828d-01, 3.3684349944691d-02,-5.4871289461073d-01,
     |  -8.2840787057676d-01,-6.6217936942870d-01,-1.4500914478417d-01,
     |   4.4311991380701d-01, 7.8760052626347d-01, 7.0653138264387d-01,
     |   2.4640268434181d-01,-3.4407904616895d-01,-7.4753502119071d-01,
     |  -7.4753502119071d-01,-3.4407904616895d-01, 2.4640268434181d-01,
     |   7.0653138264387d-01, 7.8760052626347d-01, 4.4311991380701d-01,
     |  -1.4500914478417d-01,-6.6217936942870d-01,-8.2840787057676d-01,
     |  -5.4871289461073d-01, 3.3684349944689d-02, 6.1060901193828d-01,
     |   8.7108875509971d-01, 6.6738151047805d-01, 9.6879171813520d-02,
     |  -5.4465576876929d-01,-9.1573014766208d-01,-8.0884798097327d-01,
     |  -2.6334411090603d-01, 4.4880041071477d-01, 9.5874964313489d-01,
     |   9.8957730534493d-01, 5.0136023405718d-01,-2.8220021872337d-01,
     |  -9.7998126432510d-01,-1.2390343027819d+00,-9.0601176361947d-01,
     |  -9.8904843653466d-02, 8.5476608398631d-01, 1.5789780143136d+00,
     |   1.8257855648051d+00, 1.5784959559546d+00, 1.0331732685842d+00,
     |   4.7483209150449d-01, 1.1897496351103d-01, 4.7379763659193d-03/
      data (pmn(lat, 4,17), lat = 1,72)/
     |   2.2195938885177d-04, 1.6976898694962d-02, 1.1660175430422d-01,
     |   3.7444601655220d-01, 7.9801011770079d-01, 1.2815214922031d+00,
     |   1.6282926513309d+00, 1.6383893182040d+00, 1.2190668374593d+00,
     |   4.5692647710219d-01,-3.9431761703350d-01,-1.0144484463587d+00,
     |  -1.1620481377336d+00,-7.9332357572541d-01,-9.1999597996426d-02,
     |   6.1001341424287d-01, 9.8656910806442d-01, 8.7186875042883d-01,
     |   3.3893782715344d-01,-3.3829621753364d-01,-8.2172032570931d-01,
     |  -8.7690798659352d-01,-4.8817301828832d-01, 1.3693578431236d-01,
     |   6.7559299588378d-01, 8.5490498092541d-01, 5.9008811879778d-01,
     |   2.5329709057922d-02,-5.4294537773999d-01,-8.2029907391628d-01,
     |  -6.6621606032053d-01,-1.6545449689608d-01, 4.1761866391858d-01,
     |   7.7753803528602d-01, 7.2694420995843d-01, 2.9379211043359d-01,
     |  -2.9379211043359d-01,-7.2694420995843d-01,-7.7753803528603d-01,
     |  -4.1761866391858d-01, 1.6545449689608d-01, 6.6621606032054d-01,
     |   8.2029907391628d-01, 5.4294537773999d-01,-2.5329709057920d-02,
     |  -5.9008811879778d-01,-8.5490498092541d-01,-6.7559299588378d-01,
     |  -1.3693578431236d-01, 4.8817301828832d-01, 8.7690798659352d-01,
     |   8.2172032570932d-01, 3.3829621753364d-01,-3.3893782715343d-01,
     |  -8.7186875042883d-01,-9.8656910806442d-01,-6.1001341424288d-01,
     |   9.1999597996431d-02, 7.9332357572541d-01, 1.1620481377336d+00,
     |   1.0144484463587d+00, 3.9431761703350d-01,-4.5692647710218d-01,
     |  -1.2190668374593d+00,-1.6383893182040d+00,-1.6282926513309d+00,
     |  -1.2815214922031d+00,-7.9801011770079d-01,-3.7444601655220d-01,
     |  -1.1660175430422d-01,-1.6976898694962d-02,-2.2195938885177d-04/
      data (pmn(lat, 5,17), lat = 1,72)/
     |   8.1995312733366d-06, 1.9006966953815d-03, 2.2220915690183d-02,
     |   1.0331927012906d-01, 2.9739315845029d-01, 6.2628660409611d-01,
     |   1.0417457317051d+00, 1.4165556066415d+00, 1.5832073745919d+00,
     |   1.4098319058229d+00, 8.7799462922947d-01, 1.1887836647399d-01,
     |  -6.1976887457174d-01,-1.0699725864020d+00,-1.0626764322108d+00,
     |  -6.1251947349002d-01, 7.7131242516433d-02, 6.9783961357635d-01,
     |   9.7356942210117d-01, 7.8810581291059d-01, 2.4024423926533d-01,
     |  -4.0238430500766d-01,-8.3095377237895d-01,-8.4387986100727d-01,
     |  -4.4375745398462d-01, 1.6528207752676d-01, 6.7915931128544d-01,
     |   8.4457371579534d-01, 5.8419122356298d-01, 3.3919209353296d-02,
     |  -5.2639221089360d-01,-8.1410846651637d-01,-6.8593824673373d-01,
     |  -2.0954289020476d-01, 3.7139729555847d-01, 7.6095046735338d-01,
     |   7.6095046735338d-01, 3.7139729555847d-01,-2.0954289020476d-01,
     |  -6.8593824673372d-01,-8.1410846651637d-01,-5.2639221089359d-01,
     |   3.3919209353294d-02, 5.8419122356298d-01, 8.4457371579535d-01,
     |   6.7915931128544d-01, 1.6528207752676d-01,-4.4375745398461d-01,
     |  -8.4387986100727d-01,-8.3095377237895d-01,-4.0238430500766d-01,
     |   2.4024423926532d-01, 7.8810581291058d-01, 9.7356942210117d-01,
     |   6.9783961357635d-01, 7.7131242516438d-02,-6.1251947349001d-01,
     |  -1.0626764322108d+00,-1.0699725864020d+00,-6.1976887457174d-01,
     |   1.1887836647399d-01, 8.7799462922947d-01, 1.4098319058229d+00,
     |   1.5832073745920d+00, 1.4165556066415d+00, 1.0417457317051d+00,
     |   6.2628660409611d-01, 2.9739315845029d-01, 1.0331927012906d-01,
     |   2.2220915690183d-02, 1.9006966953815d-03, 8.1995312733366d-06/
      data (pmn(lat, 6,17), lat = 1,72)/
     |   2.4788134198135d-07, 1.7364869813246d-04, 3.4347729699797d-03,
     |   2.2891612670983d-02, 8.7604065661573d-02, 2.3606016905335d-01,
     |   4.9380769217117d-01, 8.4406765124858d-01, 1.2096261681750d+00,
     |   1.4635030952587d+00, 1.4730705422122d+00, 1.1630926555715d+00,
     |   5.6813348011632d-01,-1.5631816182396d-01,-7.7872934021518d-01,
     |  -1.0803485074424d+00,-9.5134223822869d-01,-4.4873289629581d-01,
     |   2.1596866406086d-01, 7.6039380461728d-01, 9.5253593944254d-01,
     |   7.1505921624404d-01, 1.6273153206954d-01,-4.4762969110319d-01,
     |  -8.3426499521781d-01,-8.2119247967219d-01,-4.2080412079514d-01,
     |   1.7191119722236d-01, 6.7206013378843d-01, 8.4097834568901d-01,
     |   6.0064489043633d-01, 7.0951028497765d-02,-4.8866618534443d-01,
     |  -8.0531202189611d-01,-7.2534375308320d-01,-2.8907264343887d-01,
     |   2.8907264343886d-01, 7.2534375308320d-01, 8.0531202189611d-01,
     |   4.8866618534444d-01,-7.0951028497763d-02,-6.0064489043633d-01,
     |  -8.4097834568901d-01,-6.7206013378844d-01,-1.7191119722236d-01,
     |   4.2080412079514d-01, 8.2119247967219d-01, 8.3426499521781d-01,
     |   4.4762969110319d-01,-1.6273153206954d-01,-7.1505921624404d-01,
     |  -9.5253593944254d-01,-7.6039380461728d-01,-2.1596866406087d-01,
     |   4.4873289629581d-01, 9.5134223822868d-01, 1.0803485074424d+00,
     |   7.7872934021517d-01, 1.5631816182396d-01,-5.6813348011632d-01,
     |  -1.1630926555715d+00,-1.4730705422122d+00,-1.4635030952587d+00,
     |  -1.2096261681750d+00,-8.4406765124858d-01,-4.9380769217117d-01,
     |  -2.3606016905336d-01,-8.7604065661573d-02,-2.2891612670983d-02,
     |  -3.4347729699797d-03,-1.7364869813246d-04,-2.4788134198135d-07/
      data (pmn(lat, 7,17), lat = 1,72)/
     |   6.2806556565607d-09, 1.3273011111579d-05, 4.4255577519492d-04,
     |   4.2024492991549d-03, 2.1191328573391d-02, 7.2114685229068d-02,
     |   1.8607429184994d-01, 3.8804150665419d-01, 6.7850282763808d-01,
     |   1.0149434301789d+00, 1.3083860168335d+00, 1.4442016797102d+00,
     |   1.3251681467449d+00, 9.2123885626074d-01, 3.0218179902401d-01,
     |  -3.6786497434910d-01,-8.8004110164305d-01,-1.0597200247993d+00,
     |  -8.4275880303303d-01,-3.1331877198485d-01, 3.1897029951597d-01,
     |   7.9865128699789d-01, 9.2993440688095d-01, 6.6223497912617d-01,
     |   1.1570176227515d-01,-4.6808492911312d-01,-8.3117165048710d-01,
     |  -8.1418134700613d-01,-4.2883287065788d-01, 1.4635367685991d-01,
     |   6.4677233861967d-01, 8.4282849196531d-01, 6.4580609172904d-01,
     |   1.4911523673088d-01,-4.1485609962612d-01,-7.8271107533136d-01,
     |  -7.8271107533136d-01,-4.1485609962612d-01, 1.4911523673088d-01,
     |   6.4580609172904d-01, 8.4282849196531d-01, 6.4677233861967d-01,
     |   1.4635367685991d-01,-4.2883287065788d-01,-8.1418134700613d-01,
     |  -8.3117165048710d-01,-4.6808492911313d-01, 1.1570176227515d-01,
     |   6.6223497912617d-01, 9.2993440688095d-01, 7.9865128699789d-01,
     |   3.1897029951598d-01,-3.1331877198485d-01,-8.4275880303302d-01,
     |  -1.0597200247993d+00,-8.8004110164305d-01,-3.6786497434911d-01,
     |   3.0218179902401d-01, 9.2123885626074d-01, 1.3251681467449d+00,
     |   1.4442016797102d+00, 1.3083860168335d+00, 1.0149434301789d+00,
     |   6.7850282763808d-01, 3.8804150665419d-01, 1.8607429184994d-01,
     |   7.2114685229068d-02, 2.1191328573391d-02, 4.2024492991549d-03,
     |   4.4255577519492d-04, 1.3273011111579d-05, 6.2806556565607d-09/
      data (pmn(lat, 8,17), lat = 1,72)/
     |   1.3548130806506d-10, 8.6272292414818d-07, 4.8371216108742d-05,
     |   6.5192506336257d-04, 4.3074304050435d-03, 1.8366113885795d-02,
     |   5.7810377842547d-02, 1.4479385090468d-01, 3.0184831293710d-01,
     |   5.3845815683054d-01, 8.3543948124033d-01, 1.1356390482421d+00,
     |   1.3498028405105d+00, 1.3814162563975d+00, 1.1651468801836d+00,
     |   7.0434560816323d-01, 8.9085033081166d-02,-5.1905152133575d-01,
     |  -9.3627452317096d-01,-1.0246893740556d+00,-7.5217094501916d-01,
     |  -2.1629992759264d-01, 3.8295168819156d-01, 8.1580934326869d-01,
     |   9.1351042000760d-01, 6.3948358660974d-01, 1.0860006312938d-01,
     |  -4.5700450431462d-01,-8.1951391286432d-01,-8.2643380921248d-01,
     |  -4.7710078267642d-01, 7.5532164879774d-02, 5.9017414780803d-01,
     |   8.4201350164202d-01, 7.2130070563512d-01, 2.8193419827305d-01,
     |  -2.8193419827305d-01,-7.2130070563512d-01,-8.4201350164202d-01,
     |  -5.9017414780803d-01,-7.5532164879776d-02, 4.7710078267642d-01,
     |   8.2643380921248d-01, 8.1951391286432d-01, 4.5700450431462d-01,
     |  -1.0860006312938d-01,-6.3948358660974d-01,-9.1351042000760d-01,
     |  -8.1580934326869d-01,-3.8295168819156d-01, 2.1629992759264d-01,
     |   7.5217094501915d-01, 1.0246893740556d+00, 9.3627452317096d-01,
     |   5.1905152133575d-01,-8.9085033081161d-02,-7.0434560816323d-01,
     |  -1.1651468801836d+00,-1.3814162563975d+00,-1.3498028405105d+00,
     |  -1.1356390482421d+00,-8.3543948124033d-01,-5.3845815683054d-01,
     |  -3.0184831293710d-01,-1.4479385090468d-01,-5.7810377842547d-02,
     |  -1.8366113885795d-02,-4.3074304050435d-03,-6.5192506336257d-04,
     |  -4.8371216108742d-05,-8.6272292414818d-07,-1.3548130806506d-10/
      data (pmn(lat, 9,17), lat = 1,72)/
     |   2.5130157160452d-12, 4.8179153760521d-08, 4.5348284383477d-06,
     |   8.6516286847986d-05, 7.4617711913033d-04, 3.9657630670485d-03,
     |   1.5121982846978d-02, 4.5061469806788d-02, 1.1055424210946d-01,
     |   2.3090473924033d-01, 4.1957475096672d-01, 6.7235885681755d-01,
     |   9.5689976164970d-01, 1.2102263422681d+00, 1.3497394684856d+00,
     |   1.2981580040092d+00, 1.0158805184746d+00, 5.2822652766867d-01,
     |  -6.6380031875220d-02,-6.1606946302065d-01,-9.6111676139095d-01,
     |  -9.9138983311975d-01,-6.9356286862274d-01,-1.6670722686957d-01,
     |   4.0460707816492d-01, 8.1367323207520d-01, 9.0909898895600d-01,
     |   6.5567037510223d-01, 1.5228046759535d-01,-4.0322723565243d-01,
     |  -7.9062923479485d-01,-8.5545204752403d-01,-5.7250922003374d-01,
     |  -5.7675878630574d-02, 4.7825375030849d-01, 8.1546252331002d-01,
     |   8.1546252331002d-01, 4.7825375030849d-01,-5.7675878630572d-02,
     |  -5.7250922003374d-01,-8.5545204752403d-01,-7.9062923479485d-01,
     |  -4.0322723565243d-01, 1.5228046759535d-01, 6.5567037510223d-01,
     |   9.0909898895600d-01, 8.1367323207520d-01, 4.0460707816492d-01,
     |  -1.6670722686957d-01,-6.9356286862274d-01,-9.9138983311975d-01,
     |  -9.6111676139095d-01,-6.1606946302065d-01,-6.6380031875223d-02,
     |   5.2822652766867d-01, 1.0158805184746d+00, 1.2981580040092d+00,
     |   1.3497394684856d+00, 1.2102263422681d+00, 9.5689976164970d-01,
     |   6.7235885681755d-01, 4.1957475096672d-01, 2.3090473924033d-01,
     |   1.1055424210947d-01, 4.5061469806788d-02, 1.5121982846978d-02,
     |   3.9657630670485d-03, 7.4617711913033d-04, 8.6516286847986d-05,
     |   4.5348284383477d-06, 4.8179153760521d-08, 2.5130157160452d-12/
      data (pmn(lat,10,17), lat = 1,72)/
     |   4.0303290842448d-14, 2.3249761108582d-09, 3.6692590491819d-07,
     |   9.8905149210870d-06, 1.1105221150467d-04, 7.3305937891871d-04,
     |   3.3702513180844d-03, 1.1874755845823d-02, 3.4008742929924d-02,
     |   8.2265496962807d-02, 1.7247640244662d-01, 3.1897347716540d-01,
     |   5.2640779602635d-01, 7.8047313145683d-01, 1.0418021792965d+00,
     |   1.2478835890843d+00, 1.3260092251193d+00, 1.2160511450341d+00,
     |   8.9667893864065d-01, 4.0482729264278d-01,-1.6185660634139d-01,
     |  -6.6515588853694d-01,-9.6616479044335d-01,-9.7301700206524d-01,
     |  -6.7894899368091d-01,-1.7415543240528d-01, 3.7687949846456d-01,
     |   7.8794624075747d-01, 9.1628694632892d-01, 7.1623528996804d-01,
     |   2.5963606236992d-01,-2.8701894720835d-01,-7.2219430351752d-01,
     |  -8.8413158381857d-01,-7.1236222606895d-01,-2.7165397387862d-01,
     |   2.7165397387862d-01, 7.1236222606894d-01, 8.8413158381857d-01,
     |   7.2219430351752d-01, 2.8701894720835d-01,-2.5963606236993d-01,
     |  -7.1623528996804d-01,-9.1628694632892d-01,-7.8794624075748d-01,
     |  -3.7687949846456d-01, 1.7415543240528d-01, 6.7894899368090d-01,
     |   9.7301700206524d-01, 9.6616479044335d-01, 6.6515588853694d-01,
     |   1.6185660634140d-01,-4.0482729264277d-01,-8.9667893864065d-01,
     |  -1.2160511450341d+00,-1.3260092251193d+00,-1.2478835890843d+00,
     |  -1.0418021792965d+00,-7.8047313145683d-01,-5.2640779602635d-01,
     |  -3.1897347716540d-01,-1.7247640244662d-01,-8.2265496962808d-02,
     |  -3.4008742929925d-02,-1.1874755845823d-02,-3.3702513180844d-03,
     |  -7.3305937891872d-04,-1.1105221150467d-04,-9.8905149210870d-06,
     |  -3.6692590491819d-07,-2.3249761108582d-09,-4.0303290842448d-14/
      data (pmn(lat,11,17), lat = 1,72)/
     |   5.5971933486357d-16, 9.7111159478195d-11, 2.5673996727247d-08,
     |   9.7640016099882d-07, 1.4244583860797d-05, 1.1648233160802d-04,
     |   6.4352269256908d-04, 2.6694574971886d-03, 8.8755610603202d-03,
     |   2.4689895314333d-02, 5.9177615844830d-02, 1.2475862516033d-01,
     |   2.3474050626415d-01, 3.9818497513480d-01, 6.1283856852234d-01,
     |   8.5840473321189d-01, 1.0935815139909d+00, 1.2601970858827d+00,
     |   1.2959464365367d+00, 1.1539153662544d+00, 8.2338576314381d-01,
     |   3.4401041768491d-01,-1.9415447697718d-01,-6.6848131220158d-01,
     |  -9.5686919920193d-01,-9.7687032241829d-01,-7.1745378055007d-01,
     |  -2.5057403237688d-01, 2.8447810464565d-01, 7.2153406073950d-01,
     |   9.2074857222912d-01, 8.1647812354837d-01, 4.4221471979934d-01,
     |  -7.7778877666241d-02,-5.6876283403400d-01,-8.6452519533998d-01,
     |  -8.6452519533998d-01,-5.6876283403400d-01,-7.7778877666242d-02,
     |   4.4221471979934d-01, 8.1647812354837d-01, 9.2074857222912d-01,
     |   7.2153406073950d-01, 2.8447810464566d-01,-2.5057403237688d-01,
     |  -7.1745378055006d-01,-9.7687032241829d-01,-9.5686919920193d-01,
     |  -6.6848131220158d-01,-1.9415447697718d-01, 3.4401041768491d-01,
     |   8.2338576314380d-01, 1.1539153662544d+00, 1.2959464365367d+00,
     |   1.2601970858827d+00, 1.0935815139909d+00, 8.5840473321189d-01,
     |   6.1283856852234d-01, 3.9818497513480d-01, 2.3474050626415d-01,
     |   1.2475862516033d-01, 5.9177615844830d-02, 2.4689895314333d-02,
     |   8.8755610603203d-03, 2.6694574971886d-03, 6.4352269256908d-04,
     |   1.1648233160803d-04, 1.4244583860797d-05, 9.7640016099882d-07,
     |   2.5673996727247d-08, 9.7111159478195d-11, 5.5971933486357d-16/
      data (pmn(lat,12,17), lat = 1,72)/
     |   6.7133562696917d-18, 3.5019581511669d-12, 1.5498803287443d-09,
     |   8.3073347817979d-08, 1.5723663583423d-06, 1.5897064535724d-05,
     |   1.0527411731245d-04, 5.1252875188739d-04, 1.9705910979863d-03,
     |   6.2731296091251d-03, 1.7082808029149d-02, 4.0731100491619d-02,
     |   8.6482252407157d-02, 1.6554940132017d-01, 2.8826747197875d-01,
     |   4.5938714544015d-01, 6.7240770203030d-01, 9.0490396236689d-01,
     |   1.1174114190399d+00, 1.2580988385707d+00, 1.2739386691653d+00,
     |   1.1266426824462d+00, 8.0906117233879d-01, 3.5615907235138d-01,
     |  -1.5493668998303d-01,-6.1861443492340d-01,-9.2650435324975d-01,
     |  -9.9879352298421d-01,-8.1143301230453d-01,-4.0941221747327d-01,
     |   1.0020702596611d-01, 5.7548984180783d-01, 8.8000885620652d-01,
     |   9.2415505178523d-01, 6.9388259679272d-01, 2.5685479783639d-01,
     |  -2.5685479783639d-01,-6.9388259679271d-01,-9.2415505178523d-01,
     |  -8.8000885620652d-01,-5.7548984180783d-01,-1.0020702596611d-01,
     |   4.0941221747327d-01, 8.1143301230453d-01, 9.9879352298421d-01,
     |   9.2650435324975d-01, 6.1861443492340d-01, 1.5493668998304d-01,
     |  -3.5615907235138d-01,-8.0906117233879d-01,-1.1266426824462d+00,
     |  -1.2739386691653d+00,-1.2580988385707d+00,-1.1174114190399d+00,
     |  -9.0490396236689d-01,-6.7240770203030d-01,-4.5938714544015d-01,
     |  -2.8826747197875d-01,-1.6554940132017d-01,-8.6482252407157d-02,
     |  -4.0731100491619d-02,-1.7082808029149d-02,-6.2731296091251d-03,
     |  -1.9705910979864d-03,-5.1252875188740d-04,-1.0527411731245d-04,
     |  -1.5897064535725d-05,-1.5723663583423d-06,-8.3073347817979d-08,
     |  -1.5498803287443d-09,-3.5019581511669d-12,-6.7133562696917d-18/
      data (pmn(lat,13,17), lat = 1,72)/
     |   6.9008643599671d-20, 1.0820085024633d-13, 8.0120671450644d-11,
     |   6.0474862585524d-09, 1.4833306635189d-07, 1.8514136022904d-06,
     |   1.4668516193705d-05, 8.3617542127232d-05, 3.7069819832548d-04,
     |   1.3456214319897d-03, 4.1450121965131d-03, 1.1116807471626d-02,
     |   2.6454509213500d-02, 5.6654407601584d-02, 1.1036073767824d-01,
     |   1.9710981749151d-01, 3.2466238667508d-01, 4.9507935581510d-01,
     |   7.0037621782358d-01, 9.1925794930830d-01, 1.1167590261787d+00,
     |   1.2482858690241d+00, 1.2684609849048d+00, 1.1434885407318d+00,
     |   8.6401205471621d-01, 4.5431498338909d-01,-2.6148693917066d-02,
     |  -4.9124769168628d-01,-8.4615086546247d-01,-1.0109595008119d+00,
     |  -9.4362638450966d-01,-6.5505536769560d-01,-2.1086033665982d-01,
     |   2.8210352015358d-01, 7.0169751214252d-01, 9.4210484312630d-01,
     |   9.4210484312630d-01, 7.0169751214252d-01, 2.8210352015358d-01,
     |  -2.1086033665982d-01,-6.5505536769560d-01,-9.4362638450966d-01,
     |  -1.0109595008119d+00,-8.4615086546248d-01,-4.9124769168628d-01,
     |  -2.6148693917067d-02, 4.5431498338909d-01, 8.6401205471620d-01,
     |   1.1434885407318d+00, 1.2684609849048d+00, 1.2482858690241d+00,
     |   1.1167590261787d+00, 9.1925794930831d-01, 7.0037621782358d-01,
     |   4.9507935581510d-01, 3.2466238667509d-01, 1.9710981749151d-01,
     |   1.1036073767824d-01, 5.6654407601584d-02, 2.6454509213500d-02,
     |   1.1116807471626d-02, 4.1450121965131d-03, 1.3456214319897d-03,
     |   3.7069819832549d-04, 8.3617542127233d-05, 1.4668516193705d-05,
     |   1.8514136022905d-06, 1.4833306635189d-07, 6.0474862585524d-09,
     |   8.0120671450644d-11, 1.0820085024633d-13, 6.9008643599671d-20/
      data (pmn(lat,14,17), lat = 1,72)/
     |   5.9887505869854d-22, 2.8217998500201d-15, 3.4944462359526d-12,
     |   3.7118224044500d-10, 1.1787622652075d-08, 1.8141868159905d-07,
     |   1.7171188457011d-06, 1.1440240631726d-05, 5.8349839753568d-05,
     |   2.4087383554018d-04, 8.3658078474303d-04, 2.5138283125062d-03,
     |   6.6724069538924d-03, 1.5891866241082d-02, 3.4376305927921d-02,
     |   6.8170701471950d-02, 1.2483378030171d-01, 2.1225465639940d-01,
     |   3.3645771655005d-01, 4.9857140539687d-01, 6.9158299406292d-01,
     |   8.9791958056492d-01, 1.0890894313126d+00, 1.2284098269325d+00,
     |   1.2771664361135d+00, 1.2034970366034d+00, 9.9215462541805d-01,
     |   6.5248290978877d-01, 2.2181405803479d-01,-2.3771733886578d-01,
     |  -6.4934339254992d-01,-9.3718462255438d-01,-1.0436577263538d+00,
     |  -9.4429842483688d-01,-6.5578455167638d-01,-2.3450517769051d-01,
     |   2.3450517769051d-01, 6.5578455167638d-01, 9.4429842483688d-01,
     |   1.0436577263538d+00, 9.3718462255438d-01, 6.4934339254992d-01,
     |   2.3771733886579d-01,-2.2181405803479d-01,-6.5248290978877d-01,
     |  -9.9215462541805d-01,-1.2034970366034d+00,-1.2771664361135d+00,
     |  -1.2284098269325d+00,-1.0890894313126d+00,-8.9791958056492d-01,
     |  -6.9158299406292d-01,-4.9857140539687d-01,-3.3645771655005d-01,
     |  -2.1225465639940d-01,-1.2483378030171d-01,-6.8170701471950d-02,
     |  -3.4376305927921d-02,-1.5891866241082d-02,-6.6724069538924d-03,
     |  -2.5138283125062d-03,-8.3658078474303d-04,-2.4087383554019d-04,
     |  -5.8349839753569d-05,-1.1440240631726d-05,-1.7171188457011d-06,
     |  -1.8141868159906d-07,-1.1787622652075d-08,-3.7118224044500d-10,
     |  -3.4944462359526d-12,-2.8217998500201d-15,-5.9887505869854d-22/
      data (pmn(lat,15,17), lat = 1,72)/
     |   4.2679674209232d-24, 6.0422439248235d-17, 1.2509382801641d-13,
     |   1.8689175143611d-11, 7.6786841555808d-10, 1.4558694473174d-08,
     |   1.6442373861410d-07, 1.2784904851990d-06, 7.4890858762825d-06,
     |   3.5085064443883d-05, 1.3704915911226d-04, 4.6003273148338d-04,
     |   1.3571265780882d-03, 3.5794452197847d-03, 8.5537276280277d-03,
     |   1.8714929120379d-02, 3.7802845367851d-02, 7.0964228508273d-02,
     |   1.2445550487042d-01, 2.0475361852570d-01, 3.1698548292936d-01,
     |   4.6278713646682d-01, 6.3796883429081d-01, 8.3061556192746d-01,
     |   1.0203899596714d+00, 1.1797289755589d+00, 1.2772881684767d+00,
     |   1.2834235335787d+00, 1.1768387323820d+00, 9.5096301085831d-01,
     |   6.1837019782018d-01, 2.1174764413179d-01,-2.1940474844802d-01,
     |  -6.1615503676435d-01,-9.2032225898551d-01,-1.0853392392831d+00,
     |  -1.0853392392831d+00,-9.2032225898551d-01,-6.1615503676436d-01,
     |  -2.1940474844803d-01, 2.1174764413178d-01, 6.1837019782018d-01,
     |   9.5096301085831d-01, 1.1768387323820d+00, 1.2834235335787d+00,
     |   1.2772881684767d+00, 1.1797289755589d+00, 1.0203899596714d+00,
     |   8.3061556192746d-01, 6.3796883429081d-01, 4.6278713646682d-01,
     |   3.1698548292936d-01, 2.0475361852570d-01, 1.2445550487042d-01,
     |   7.0964228508273d-02, 3.7802845367851d-02, 1.8714929120379d-02,
     |   8.5537276280277d-03, 3.5794452197847d-03, 1.3571265780882d-03,
     |   4.6003273148338d-04, 1.3704915911226d-04, 3.5085064443883d-05,
     |   7.4890858762826d-06, 1.2784904851990d-06, 1.6442373861410d-07,
     |   1.4558694473174d-08, 7.6786841555808d-10, 1.8689175143611d-11,
     |   1.2509382801641d-13, 6.0422439248235d-17, 4.2679674209232d-24/
      data (pmn(lat,16,17), lat = 1,72)/
     |   2.3643177246597d-26, 1.0055598692602d-18, 3.4794086680451d-15,
     |   7.3082586996937d-13, 3.8824680632650d-11, 9.0612690633542d-10,
     |   1.2199443093674d-08, 1.1057766889840d-07, 7.4288614756205d-07,
     |   3.9431466313427d-06, 1.7289662453903d-05, 6.4682318033875d-05,
     |   2.1150711670440d-04, 6.1578941878849d-04, 1.6194827651737d-03,
     |   3.8916379511339d-03, 8.6238208229701d-03, 1.7755158720676d-02,
     |   3.4171171603680d-02, 6.1784659984394d-02, 1.0538239239696d-01,
     |   1.7012571237180d-01, 2.6064141164552d-01, 3.7973574778623d-01,
     |   5.2689666066058d-01, 6.9688541327588d-01, 8.7881379739150d-01,
     |   1.0561105546570d+00, 1.2076706266712d+00, 1.3102545092724d+00,
     |   1.3419024034320d+00, 1.2858227294498d+00, 1.1339959887149d+00,
     |   8.8968051657797d-01, 5.6815547496653d-01, 1.9537161655937d-01,
     |  -1.9537161655937d-01,-5.6815547496653d-01,-8.8968051657797d-01,
     |  -1.1339959887149d+00,-1.2858227294498d+00,-1.3419024034320d+00,
     |  -1.3102545092724d+00,-1.2076706266712d+00,-1.0561105546570d+00,
     |  -8.7881379739150d-01,-6.9688541327588d-01,-5.2689666066058d-01,
     |  -3.7973574778623d-01,-2.6064141164552d-01,-1.7012571237180d-01,
     |  -1.0538239239696d-01,-6.1784659984394d-02,-3.4171171603680d-02,
     |  -1.7755158720676d-02,-8.6238208229702d-03,-3.8916379511339d-03,
     |  -1.6194827651737d-03,-6.1578941878849d-04,-2.1150711670440d-04,
     |  -6.4682318033875d-05,-1.7289662453903d-05,-3.9431466313427d-06,
     |  -7.4288614756206d-07,-1.1057766889840d-07,-1.2199443093674d-08,
     |  -9.0612690633544d-10,-3.8824680632650d-11,-7.3082586996937d-13,
     |  -3.4794086680451d-15,-1.0055598692602d-18,-2.3643177246597d-26/
      data (pmn(lat,17,17), lat = 1,72)/
     |   8.8475427693204d-29, 1.1303107466487d-20, 6.5350774650166d-17,
     |   1.9290994326172d-14, 1.3244336905311d-12, 3.8026011420919d-11,
     |   6.0981696636918d-10, 6.4373812920541d-09, 4.9544676098335d-08,
     |   2.9755451149841d-07, 1.4622514660608d-06, 6.0857876168237d-06,
     |   2.2011100658580d-05, 7.0564350814649d-05, 2.0364666248204d-04,
     |   5.3565347889962d-04, 1.2970245714936d-03, 2.9149386124678d-03,
     |   6.1217571655738d-03, 1.2082401544364d-02, 2.2518405570914d-02,
     |   3.9791478237075d-02, 6.6897728825853d-02, 1.0732126694465d-01,
     |   1.6470823461081d-01, 2.4235216646961d-01, 3.4252662669432d-01,
     |   4.6575307683894d-01, 6.1013759110220d-01, 7.7093408666872d-01,
     |   9.4048151901204d-01, 1.1086127109624d+00, 1.2635484525635d+00,
     |   1.3931884455771d+00, 1.4866144679051d+00, 1.5355562155712d+00,
     |   1.5355562155712d+00, 1.4866144679051d+00, 1.3931884455771d+00,
     |   1.2635484525635d+00, 1.1086127109624d+00, 9.4048151901204d-01,
     |   7.7093408666872d-01, 6.1013759110220d-01, 4.6575307683894d-01,
     |   3.4252662669432d-01, 2.4235216646961d-01, 1.6470823461081d-01,
     |   1.0732126694465d-01, 6.6897728825853d-02, 3.9791478237075d-02,
     |   2.2518405570914d-02, 1.2082401544364d-02, 6.1217571655739d-03,
     |   2.9149386124678d-03, 1.2970245714936d-03, 5.3565347889962d-04,
     |   2.0364666248203d-04, 7.0564350814649d-05, 2.2011100658581d-05,
     |   6.0857876168237d-06, 1.4622514660608d-06, 2.9755451149841d-07,
     |   4.9544676098335d-08, 6.4373812920542d-09, 6.0981696636918d-10,
     |   3.8026011420920d-11, 1.3244336905311d-12, 1.9290994326172d-14,
     |   6.5350774650166d-17, 1.1303107466487d-20, 8.8475427693204d-29/
      data (pmn(lat, 0,18), lat = 1,72)/
     |   4.1278962044601d+00, 2.8640972866516d+00, 9.1859757904668d-01,
     |  -8.4214263903251d-01,-1.7030710457793d+00,-1.4429229799408d+00,
     |  -4.0673395082487d-01, 7.1833163750274d-01, 1.2903453799692d+00,
     |   1.0472199984866d+00, 2.1131578693196d-01,-6.7852024502975d-01,
     |  -1.0975388355471d+00,-8.3378078741389d-01,-8.8595487368813d-02,
     |   6.6655830797912d-01, 9.8140410895257d-01, 6.9026325115717d-01,
     |  -4.1849951275201d-03,-6.6767017607468d-01,-9.0213335940826d-01,
     |  -5.8166406961923d-01, 8.1821953018919d-02, 6.7648969031121d-01,
     |   8.4382030510539d-01, 4.9290585558747d-01,-1.5130357550598d-01,
     |  -6.9082568288677d-01,-7.9878075700578d-01,-4.1612108868003d-01,
     |   2.1672041590080d-01, 7.0988607822418d-01, 7.6286164304273d-01,
     |   3.4656759129417d-01,-2.8097425459898d-01,-7.3368208578773d-01,
     |  -7.3368208578773d-01,-2.8097425459898d-01, 3.4656759129416d-01,
     |   7.6286164304273d-01, 7.0988607822419d-01, 2.1672041590079d-01,
     |  -4.1612108868003d-01,-7.9878075700578d-01,-6.9082568288677d-01,
     |  -1.5130357550598d-01, 4.9290585558747d-01, 8.4382030510538d-01,
     |   6.7648969031121d-01, 8.1821953018919d-02,-5.8166406961923d-01,
     |  -9.0213335940826d-01,-6.6767017607468d-01,-4.1849951275241d-03,
     |   6.9026325115717d-01, 9.8140410895257d-01, 6.6655830797912d-01,
     |  -8.8595487368817d-02,-8.3378078741389d-01,-1.0975388355471d+00,
     |  -6.7852024502975d-01, 2.1131578693196d-01, 1.0472199984866d+00,
     |   1.2903453799692d+00, 7.1833163750274d-01,-4.0673395082487d-01,
     |  -1.4429229799408d+00,-1.7030710457793d+00,-8.4214263903251d-01,
     |   9.1859757904668d-01, 2.8640972866516d+00, 4.1278962044601d+00/
      data (pmn(lat, 1,18), lat = 1,72)/
     |   8.5017151979844d-01, 2.1553313160921d+00, 2.4779904126217d+00,
     |   1.7307751815620d+00, 3.5580415989908d-01,-9.2426408868302d-01,
     |  -1.4933572159717d+00,-1.1551113458148d+00,-2.0623044834749d-01,
     |   7.5907255420111d-01, 1.1940056202015d+00, 8.9641107041989d-01,
     |   9.6150969085376d-02,-7.0502964814151d-01,-1.0379857498353d+00,
     |  -7.3476943526666d-01,-9.5135190952506d-03, 6.8614054798072d-01,
     |   9.3932838091493d-01, 6.1761630000347d-01,-6.3955253765324d-02,
     |  -6.8343718275528d-01,-8.7025288984109d-01,-5.2477381286938d-01,
     |   1.2988870356573d-01, 6.9016554025811d-01, 8.1881366243329d-01,
     |   4.4645949842748d-01,-1.9178978416146d-01,-7.0358939320346d-01,
     |  -7.7901355403775d-01,-3.7713605162020d-01, 2.5218953757296d-01,
     |   7.2272154451124d-01, 7.4758252377442d-01, 3.1324447971036d-01,
     |  -3.1324447971035d-01,-7.4758252377442d-01,-7.2272154451124d-01,
     |  -2.5218953757297d-01, 3.7713605162020d-01, 7.7901355403775d-01,
     |   7.0358939320346d-01, 1.9178978416147d-01,-4.4645949842748d-01,
     |  -8.1881366243329d-01,-6.9016554025812d-01,-1.2988870356573d-01,
     |   5.2477381286938d-01, 8.7025288984109d-01, 6.8343718275528d-01,
     |   6.3955253765335d-02,-6.1761630000347d-01,-9.3932838091493d-01,
     |  -6.8614054798072d-01, 9.5135190952455d-03, 7.3476943526666d-01,
     |   1.0379857498353d+00, 7.0502964814151d-01,-9.6150969085368d-02,
     |  -8.9641107041989d-01,-1.1940056202015d+00,-7.5907255420111d-01,
     |   2.0623044834748d-01, 1.1551113458148d+00, 1.4933572159717d+00,
     |   9.2426408868303d-01,-3.5580415989908d-01,-1.7307751815620d+00,
     |  -2.4779904126217d+00,-2.1553313160921d+00,-8.5017151979844d-01/
      data (pmn(lat, 2,18), lat = 1,72)/
     |   8.6090738507049d-02, 6.9426197737357d-01, 1.5328789113373d+00,
     |   2.0643103162064d+00, 1.9020897279400d+00, 1.0374706044187d+00,
     |  -1.4779057843727d-01,-1.0895319989475d+00,-1.3516563068048d+00,
     |  -8.6317961414286d-01, 5.0680040729024d-02, 8.5773881875501d-01,
     |   1.1179486785733d+00, 7.2178224624629d-01,-6.4691379095647d-02,
     |  -7.6781622198404d-01,-9.8546299974042d-01,-6.1454781587143d-01,
     |   1.0173044563207d-01, 7.2837959223582d-01, 8.9921533438757d-01,
     |   5.2901858122648d-01,-1.4513309048920d-01,-7.1301617742868d-01,
     |  -8.3856932520234d-01,-4.5743709764038d-01, 1.9082650577596d-01,
     |   7.1168612546563d-01, 7.9406516239007d-01, 3.9509939015283d-01,
     |  -2.3803290540604d-01,-7.2010765578305d-01,-7.6089191198291d-01,
     |  -3.3900029460132d-01, 2.8711414147366d-01, 7.3657817209464d-01,
     |   7.3657817209464d-01, 2.8711414147366d-01,-3.3900029460132d-01,
     |  -7.6089191198291d-01,-7.2010765578305d-01,-2.3803290540603d-01,
     |   3.9509939015283d-01, 7.9406516239007d-01, 7.1168612546564d-01,
     |   1.9082650577596d-01,-4.5743709764038d-01,-8.3856932520234d-01,
     |  -7.1301617742869d-01,-1.4513309048920d-01, 5.2901858122648d-01,
     |   8.9921533438757d-01, 7.2837959223582d-01, 1.0173044563208d-01,
     |  -6.1454781587143d-01,-9.8546299974042d-01,-7.6781622198405d-01,
     |  -6.4691379095643d-02, 7.2178224624630d-01, 1.1179486785733d+00,
     |   8.5773881875501d-01, 5.0680040729024d-02,-8.6317961414286d-01,
     |  -1.3516563068048d+00,-1.0895319989475d+00,-1.4779057843727d-01,
     |   1.0374706044187d+00, 1.9020897279400d+00, 2.0643103162064d+00,
     |   1.5328789113373d+00, 6.9426197737357d-01, 8.6090738507049d-02/
      data (pmn(lat, 3,18), lat = 1,72)/
     |   5.7578157163052d-03, 1.4332647691025d-01, 5.6161560860396d-01,
     |   1.1857000256812d+00, 1.7287820647284d+00, 1.8549479402583d+00,
     |   1.3915733295057d+00, 4.6156191963124d-01,-5.5102265655037d-01,
     |  -1.1916609439970d+00,-1.1786657443574d+00,-5.6055799466105d-01,
     |   3.0530610514793d-01, 9.4493792350519d-01, 1.0248930486591d+00,
     |   5.3036560958166d-01,-2.3564259535981d-01,-8.3030088750722d-01,
     |  -9.2365177361732d-01,-4.8189028533255d-01, 2.2182192420140d-01,
     |   7.7213830230582d-01, 8.5425599779567d-01, 4.3347214390712d-01,
     |  -2.3105176972254d-01,-7.4348776318071d-01,-8.0535032153836d-01,
     |  -3.8871523738903d-01, 2.5174838316884d-01, 7.3289521855156d-01,
     |   7.7092643982748d-01, 3.4811710374061d-01,-2.7924225986209d-01,
     |  -7.3511241266895d-01,-7.4791273070163d-01,-3.1159627369112d-01,
     |   3.1159627369111d-01, 7.4791273070163d-01, 7.3511241266895d-01,
     |   2.7924225986209d-01,-3.4811710374061d-01,-7.7092643982748d-01,
     |  -7.3289521855156d-01,-2.5174838316884d-01, 3.8871523738903d-01,
     |   8.0535032153836d-01, 7.4348776318071d-01, 2.3105176972254d-01,
     |  -4.3347214390712d-01,-8.5425599779567d-01,-7.7213830230582d-01,
     |  -2.2182192420141d-01, 4.8189028533255d-01, 9.2365177361732d-01,
     |   8.3030088750722d-01, 2.3564259535982d-01,-5.3036560958166d-01,
     |  -1.0248930486591d+00,-9.4493792350519d-01,-3.0530610514794d-01,
     |   5.6055799466105d-01, 1.1786657443574d+00, 1.1916609439970d+00,
     |   5.5102265655037d-01,-4.6156191963123d-01,-1.3915733295057d+00,
     |  -1.8549479402583d+00,-1.7287820647284d+00,-1.1857000256812d+00,
     |  -5.6161560860396d-01,-1.4332647691025d-01,-5.7578157163052d-03/
      data (pmn(lat, 4,18), lat = 1,72)/
     |   2.8583482145913d-04, 2.1711255660112d-02, 1.4699619677937d-01,
     |   4.6142863759613d-01, 9.5129684932125d-01, 1.4569124522536d+00,
     |   1.7260181561795d+00, 1.5484921502820d+00, 8.9588476159699d-01,
     |  -2.3516000815686d-02,-8.4056197903384d-01,-1.2029783007406d+00,
     |  -9.6188806432019d-01,-2.6121960980398d-01, 5.2694762926139d-01,
     |   9.9302720161221d-01, 9.0563307879053d-01, 3.3363527784612d-01,
     |  -3.9469414261986d-01,-8.7455370965117d-01,-8.4855151927339d-01,
     |  -3.4681126016118d-01, 3.3497412374870d-01, 8.0634732275242d-01,
     |   8.0429110997680d-01, 3.4047717100514d-01,-3.0959559981784d-01,
     |  -7.6805438010747d-01,-7.7302588069893d-01,-3.2811883249448d-01,
     |   3.0249432084279d-01, 7.4949540378335d-01, 7.5358229215768d-01,
     |   3.1547734797467d-01,-3.0590354660027d-01,-7.4548982769471d-01,
     |  -7.4548982769471d-01,-3.0590354660028d-01, 3.1547734797466d-01,
     |   7.5358229215768d-01, 7.4949540378335d-01, 3.0249432084279d-01,
     |  -3.2811883249448d-01,-7.7302588069893d-01,-7.6805438010747d-01,
     |  -3.0959559981784d-01, 3.4047717100513d-01, 8.0429110997679d-01,
     |   8.0634732275242d-01, 3.3497412374870d-01,-3.4681126016118d-01,
     |  -8.4855151927339d-01,-8.7455370965117d-01,-3.9469414261987d-01,
     |   3.3363527784612d-01, 9.0563307879052d-01, 9.9302720161221d-01,
     |   5.2694762926139d-01,-2.6121960980398d-01,-9.6188806432018d-01,
     |  -1.2029783007406d+00,-8.4056197903384d-01,-2.3516000815691d-02,
     |   8.9588476159698d-01, 1.5484921502820d+00, 1.7260181561795d+00,
     |   1.4569124522537d+00, 9.5129684932125d-01, 4.6142863759613d-01,
     |   1.4699619677937d-01, 2.1711255660112d-02, 2.8583482145913d-04/
      data (pmn(lat, 5,18), lat = 1,72)/
     |   1.1205668411096d-05, 2.5826081950378d-03, 2.9839314433016d-02,
     |   1.3621492073954d-01, 3.8201711100823d-01, 7.7653795688433d-01,
     |   1.2312736266603d+00, 1.5664531908420d+00, 1.5848955801550d+00,
     |   1.1825467442188d+00, 4.3331713118110d-01,-4.1009420976072d-01,
     |  -1.0157677495073d+00,-1.1308953775816d+00,-7.1714905615039d-01,
     |   1.4696554836674d-02, 6.9894241264557d-01, 9.9592996738281d-01,
     |   7.6660685370171d-01, 1.4591034916510d-01,-5.2818116373859d-01,
     |  -8.9504058731789d-01,-7.6501762141406d-01,-2.2068128073277d-01,
     |   4.3062322684918d-01, 8.2752270351354d-01, 7.5456097049801d-01,
     |   2.6035608151944d-01,-3.7184343639063d-01,-7.8458119280752d-01,
     |  -7.4744467333052d-01,-2.8595003880136d-01, 3.3439963019374d-01,
     |   7.5959156139417d-01, 7.4820783830250d-01, 3.0819124907568d-01,
     |  -3.0819124907568d-01,-7.4820783830250d-01,-7.5959156139417d-01,
     |  -3.3439963019374d-01, 2.8595003880136d-01, 7.4744467333053d-01,
     |   7.8458119280752d-01, 3.7184343639063d-01,-2.6035608151944d-01,
     |  -7.5456097049801d-01,-8.2752270351354d-01,-4.3062322684918d-01,
     |   2.2068128073277d-01, 7.6501762141406d-01, 8.9504058731789d-01,
     |   5.2818116373859d-01,-1.4591034916510d-01,-7.6660685370171d-01,
     |  -9.9592996738281d-01,-6.9894241264557d-01,-1.4696554836678d-02,
     |   7.1714905615039d-01, 1.1308953775816d+00, 1.0157677495073d+00,
     |   4.1009420976072d-01,-4.3331713118110d-01,-1.1825467442188d+00,
     |  -1.5848955801550d+00,-1.5664531908420d+00,-1.2312736266603d+00,
     |  -7.7653795688434d-01,-3.8201711100823d-01,-1.3621492073954d-01,
     |  -2.9839314433016d-02,-2.5826081950378d-03,-1.1205668411096d-05/
      data (pmn(lat, 6,18), lat = 1,72)/
     |   3.6021328938567d-07, 2.5110017328101d-04, 4.9172473973172d-03,
     |   3.2269025768624d-02, 1.2086408752216d-01, 3.1653527715913d-01,
     |   6.3808316952966d-01, 1.0394034115589d+00, 1.3971984363025d+00,
     |   1.5454108811072d+00, 1.3513809988207d+00, 7.9891448956611d-01,
     |   2.9503163290089d-02,-6.9281920472366d-01,-1.0890476115256d+00,
     |  -9.9844872614045d-01,-4.6882461923905d-01, 2.5004918139417d-01,
     |   8.1643952409945d-01, 9.6090150772087d-01, 6.2205095776379d-01,
     |  -1.9214941852421d-02,-6.2969209862413d-01,-8.9498076967371d-01,
     |  -6.8332964581486d-01,-1.1485558020586d-01, 5.0248428838996d-01,
     |   8.3758566122220d-01, 7.1385623434443d-01, 2.0386853568668d-01,
     |  -4.1084966578206d-01,-7.9361320931262d-01,-7.3642508595216d-01,
     |  -2.7339681353661d-01, 3.3853069090934d-01, 7.6114969927642d-01,
     |   7.6114969927642d-01, 3.3853069090934d-01,-2.7339681353661d-01,
     |  -7.3642508595216d-01,-7.9361320931262d-01,-4.1084966578206d-01,
     |   2.0386853568667d-01, 7.1385623434443d-01, 8.3758566122220d-01,
     |   5.0248428838996d-01,-1.1485558020586d-01,-6.8332964581486d-01,
     |  -8.9498076967371d-01,-6.2969209862413d-01,-1.9214941852421d-02,
     |   6.2205095776379d-01, 9.6090150772087d-01, 8.1643952409945d-01,
     |   2.5004918139418d-01,-4.6882461923905d-01,-9.9844872614045d-01,
     |  -1.0890476115256d+00,-6.9281920472366d-01, 2.9503163290081d-02,
     |   7.9891448956611d-01, 1.3513809988207d+00, 1.5454108811072d+00,
     |   1.3971984363025d+00, 1.0394034115589d+00, 6.3808316952966d-01,
     |   3.1653527715913d-01, 1.2086408752216d-01, 3.2269025768624d-02,
     |   4.9172473973172d-03, 2.5110017328101d-04, 3.6021328938567d-07/
      data (pmn(lat, 7,18), lat = 1,72)/
     |   9.7299995255568d-09, 2.0474219961362d-05, 6.7673573198265d-04,
     |   6.3408942536838d-03, 3.1392269767303d-02, 1.0429716198322d-01,
     |   2.6103978444575d-01, 5.2392946690475d-01, 8.7294438660624d-01,
     |   1.2273670348582d+00, 1.4566575242029d+00, 1.4271205986959d+00,
     |   1.0695686372578d+00, 4.3492191309036d-01,-2.9767628213592d-01,
     |  -8.7688471994165d-01,-1.0831604164881d+00,-8.3468528573309d-01,
     |  -2.4030051710521d-01, 4.3503143267399d-01, 8.8453084087112d-01,
     |   9.0300475355820d-01, 4.8866601600361d-01,-1.5121053873124d-01,
     |  -6.9888091313344d-01,-8.8315257493169d-01,-6.1632277254024d-01,
     |  -3.9847232198948d-02, 5.4709267453328d-01, 8.4128791126818d-01,
     |   6.9259480700528d-01, 1.8224470806803d-01,-4.1955091870246d-01,
     |  -7.9537874069877d-01,-7.4765264799355d-01,-3.0278803928277d-01,
     |   3.0278803928277d-01, 7.4765264799355d-01, 7.9537874069877d-01,
     |   4.1955091870246d-01,-1.8224470806803d-01,-6.9259480700528d-01,
     |  -8.4128791126818d-01,-5.4709267453328d-01, 3.9847232198947d-02,
     |   6.1632277254024d-01, 8.8315257493169d-01, 6.9888091313344d-01,
     |   1.5121053873125d-01,-4.8866601600361d-01,-9.0300475355820d-01,
     |  -8.8453084087112d-01,-4.3503143267400d-01, 2.4030051710520d-01,
     |   8.3468528573309d-01, 1.0831604164881d+00, 8.7688471994166d-01,
     |   2.9767628213592d-01,-4.3492191309037d-01,-1.0695686372578d+00,
     |  -1.4271205986959d+00,-1.4566575242029d+00,-1.2273670348582d+00,
     |  -8.7294438660625d-01,-5.2392946690475d-01,-2.6103978444575d-01,
     |  -1.0429716198322d-01,-3.1392269767303d-02,-6.3408942536838d-03,
     |  -6.7673573198265d-04,-2.0474219961362d-05,-9.7299995255568d-09/
      data (pmn(lat, 8,18), lat = 1,72)/
     |   2.2450504419529d-10, 1.4241565144319d-06, 7.9235551367651d-05,
     |   1.0553979795697d-03, 6.8620006965653d-03, 2.8656812494891d-02,
     |   8.7886306190481d-02, 2.1318319464009d-01, 4.2731970397213d-01,
     |   7.2638891235502d-01, 1.0612120420239d+00, 1.3352163916000d+00,
     |   1.4289249786283d+00, 1.2484185618405d+00, 7.7929940713962d-01,
     |   1.1811933330283d-01,-5.4230606516923d-01,-9.7790709564040d-01,
     |  -1.0266173749104d+00,-6.6830894191661d-01,-4.9403197806547d-02,
     |   5.6779940628897d-01, 9.1522231515202d-01, 8.4066447808831d-01,
     |   3.8244594889869d-01,-2.4290877500078d-01,-7.3913590166050d-01,
     |  -8.7066904325082d-01,-5.7737939275451d-01,-5.8021770668034d-03,
     |   5.6108457424497d-01, 8.4281495260520d-01, 7.0077648801996d-01,
     |   2.0789702812015d-01,-3.8728454626189d-01,-7.8502607274086d-01,
     |  -7.8502607274086d-01,-3.8728454626190d-01, 2.0789702812015d-01,
     |   7.0077648801996d-01, 8.4281495260520d-01, 5.6108457424496d-01,
     |  -5.8021770668008d-03,-5.7737939275451d-01,-8.7066904325083d-01,
     |  -7.3913590166050d-01,-2.4290877500079d-01, 3.8244594889869d-01,
     |   8.4066447808830d-01, 9.1522231515202d-01, 5.6779940628897d-01,
     |  -4.9403197806537d-02,-6.6830894191661d-01,-1.0266173749104d+00,
     |  -9.7790709564041d-01,-5.4230606516924d-01, 1.1811933330282d-01,
     |   7.7929940713963d-01, 1.2484185618405d+00, 1.4289249786283d+00,
     |   1.3352163916000d+00, 1.0612120420239d+00, 7.2638891235502d-01,
     |   4.2731970397213d-01, 2.1318319464009d-01, 8.7886306190481d-02,
     |   2.8656812494892d-02, 6.8620006965653d-03, 1.0553979795697d-03,
     |   7.9235551367651d-05, 1.4241565144319d-06, 2.2450504419529d-10/
      data (pmn(lat, 9,18), lat = 1,72)/
     |   4.4733880576074d-12, 8.5468763440989d-08, 7.9891288304504d-06,
     |   1.5082090555328d-04, 1.2822951610440d-03, 6.6911351990201d-03,
     |   2.4939924697595d-02, 7.2288896081496d-02, 1.7154570695606d-01,
     |   3.4426493412764d-01, 5.9619529150800d-01, 9.0104319065819d-01,
     |   1.1921291518912d+00, 1.3716828811736d+00, 1.3412780478050d+00,
     |   1.0457998126995d+00, 5.1265614024280d-01,-1.3563754176523d-01,
     |  -7.0963584976037d-01,-1.0184297540815d+00,-9.4897059173159d-01,
     |  -5.2398499658146d-01, 9.2529802244617d-02, 6.5235253074540d-01,
     |   9.2359541051883d-01, 7.9230110587386d-01, 3.1763785558729d-01,
     |  -2.8867881292462d-01,-7.5391447645415d-01,-8.6750297500366d-01,
     |  -5.7913119887124d-01,-2.4324760002171d-02, 5.3682938613994d-01,
     |   8.4077663565886d-01, 7.4476940181167d-01, 2.9495109864676d-01,
     |  -2.9495109864676d-01,-7.4476940181167d-01,-8.4077663565886d-01,
     |  -5.3682938613994d-01, 2.4324760002169d-02, 5.7913119887124d-01,
     |   8.6750297500366d-01, 7.5391447645415d-01, 2.8867881292463d-01,
     |  -3.1763785558729d-01,-7.9230110587386d-01,-9.2359541051883d-01,
     |  -6.5235253074540d-01,-9.2529802244617d-02, 5.2398499658146d-01,
     |   9.4897059173158d-01, 1.0184297540815d+00, 7.0963584976037d-01,
     |   1.3563754176523d-01,-5.1265614024280d-01,-1.0457998126995d+00,
     |  -1.3412780478050d+00,-1.3716828811736d+00,-1.1921291518912d+00,
     |  -9.0104319065819d-01,-5.9619529150800d-01,-3.4426493412764d-01,
     |  -1.7154570695606d-01,-7.2288896081496d-02,-2.4939924697595d-02,
     |  -6.6911351990202d-03,-1.2822951610440d-03,-1.5082090555328d-04,
     |  -7.9891288304504d-06,-8.5468763440989d-08,-4.4733880576074d-12/
      data (pmn(lat,10,18), lat = 1,72)/
     |   7.7494735590147d-14, 4.4564970045474d-09, 6.9891286631746d-07,
     |   1.8660510790439d-05, 2.0683593848062d-04, 1.3430305016187d-03,
     |   6.0506268718972d-03, 2.0804086560049d-02, 5.7875415034672d-02,
     |   1.3527604476010d-01, 2.7237801799037d-01, 4.8020911838415d-01,
     |   7.4853290057425d-01, 1.0354981076428d+00, 1.2675484617343d+00,
     |   1.3552428571194d+00, 1.2241827811571d+00, 8.5156998463628d-01,
     |   2.9236377986100d-01,-3.2095887195485d-01,-8.1246942090491d-01,
     |  -1.0233719961540d+00,-8.7724050794410d-01,-4.2131049321803d-01,
     |   1.7867666253816d-01, 6.9446892795218d-01, 9.2355582559594d-01,
     |   7.7393601391689d-01, 3.0745903641667d-01,-2.8070372920529d-01,
     |  -7.4146458515364d-01,-8.7788269585395d-01,-6.3168356323825d-01,
     |  -1.1078494290729d-01, 4.5622833201922d-01, 8.1987675859002d-01,
     |   8.1987675859002d-01, 4.5622833201923d-01,-1.1078494290729d-01,
     |  -6.3168356323825d-01,-8.7788269585395d-01,-7.4146458515364d-01,
     |  -2.8070372920530d-01, 3.0745903641666d-01, 7.7393601391689d-01,
     |   9.2355582559594d-01, 6.9446892795218d-01, 1.7867666253817d-01,
     |  -4.2131049321803d-01,-8.7724050794410d-01,-1.0233719961540d+00,
     |  -8.1246942090492d-01,-3.2095887195485d-01, 2.9236377986100d-01,
     |   8.5156998463628d-01, 1.2241827811571d+00, 1.3552428571194d+00,
     |   1.2675484617343d+00, 1.0354981076428d+00, 7.4853290057425d-01,
     |   4.8020911838415d-01, 2.7237801799037d-01, 1.3527604476011d-01,
     |   5.7875415034673d-02, 2.0804086560049d-02, 6.0506268718972d-03,
     |   1.3430305016187d-03, 2.0683593848062d-04, 1.8660510790439d-05,
     |   6.9891286631746d-07, 4.4564970045474d-09, 7.7494735590147d-14/
      data (pmn(lat,11,18), lat = 1,72)/
     |   1.1709330463538d-15, 2.0257597766496d-10, 5.3249227252680d-08,
     |   2.0075477244771d-06, 2.8945519459326d-05, 2.3318543247626d-04,
     |   1.2648864643417d-03, 5.1332020833636d-03, 1.6631534267934d-02,
     |   4.4888913276456d-02, 1.0387998519495d-01, 2.1025413613098d-01,
     |   3.7727077615039d-01, 6.0531333372254d-01, 8.7202115820659d-01,
     |   1.1272916404869d+00, 1.2986268320522d+00, 1.3094147613545d+00,
     |   1.1070884261386d+00, 6.9182757089721d-01, 1.3281173834885d-01,
     |  -4.3917694330776d-01,-8.6609279483159d-01,-1.0155846839917d+00,
     |  -8.3386906076924d-01,-3.7605549373065d-01, 2.0254943933506d-01,
     |   6.9605403494856d-01, 9.2278135643156d-01, 7.9669057331987d-01,
     |   3.6534164692591d-01,-2.0393798955780d-01,-6.8715350079203d-01,
     |  -8.9219923033625d-01,-7.3694370074932d-01,-2.8391129733614d-01,
     |   2.8391129733614d-01, 7.3694370074932d-01, 8.9219923033625d-01,
     |   6.8715350079203d-01, 2.0393798955780d-01,-3.6534164692591d-01,
     |  -7.9669057331987d-01,-9.2278135643156d-01,-6.9605403494856d-01,
     |  -2.0254943933506d-01, 3.7605549373065d-01, 8.3386906076924d-01,
     |   1.0155846839917d+00, 8.6609279483159d-01, 4.3917694330776d-01,
     |  -1.3281173834884d-01,-6.9182757089721d-01,-1.1070884261386d+00,
     |  -1.3094147613545d+00,-1.2986268320522d+00,-1.1272916404869d+00,
     |  -8.7202115820659d-01,-6.0531333372254d-01,-3.7727077615039d-01,
     |  -2.1025413613098d-01,-1.0387998519495d-01,-4.4888913276456d-02,
     |  -1.6631534267934d-02,-5.1332020833637d-03,-1.2648864643417d-03,
     |  -2.3318543247626d-04,-2.8945519459326d-05,-2.0075477244771d-06,
     |  -5.3249227252680d-08,-2.0257597766496d-10,-1.1709330463538d-15/
      data (pmn(lat,12,18), lat = 1,72)/
     |   1.5429377519858d-17, 8.0273599688340d-12, 3.5339146969592d-09,
     |   1.8790496700062d-07, 3.5183553526061d-06, 3.5088000614388d-05,
     |   2.2851052925296d-04, 1.0905768301101d-03, 4.0963788085943d-03,
     |   1.2692280589471d-02, 3.3503553270194d-02, 7.7081127876391d-02,
     |   1.5709980594985d-01, 2.8692249952428d-01, 4.7321843103757d-01,
     |   7.0788538592069d-01, 9.6135831604560d-01, 1.1815017872749d+00,
     |   1.3016425760730d+00, 1.2584354905974d+00, 1.0157906286651d+00,
     |   5.8677274962189d-01, 4.3489715257414d-02,-4.9276007392976d-01,
     |  -8.8231775196333d-01,-1.0114799202392d+00,-8.3542495301683d-01,
     |  -4.0253378502264d-01, 1.5238364642449d-01, 6.4757564130877d-01,
     |   9.1505590082069d-01, 8.6113719395378d-01, 5.0338422950582d-01,
     |  -3.1897009584494d-02,-5.5286006206351d-01,-8.7115808397640d-01,
     |  -8.7115808397640d-01,-5.5286006206351d-01,-3.1897009584496d-02,
     |   5.0338422950582d-01, 8.6113719395378d-01, 9.1505590082069d-01,
     |   6.4757564130878d-01, 1.5238364642449d-01,-4.0253378502264d-01,
     |  -8.3542495301683d-01,-1.0114799202392d+00,-8.8231775196333d-01,
     |  -4.9276007392976d-01, 4.3489715257414d-02, 5.8677274962189d-01,
     |   1.0157906286651d+00, 1.2584354905974d+00, 1.3016425760730d+00,
     |   1.1815017872749d+00, 9.6135831604560d-01, 7.0788538592070d-01,
     |   4.7321843103757d-01, 2.8692249952428d-01, 1.5709980594985d-01,
     |   7.7081127876391d-02, 3.3503553270194d-02, 1.2692280589471d-02,
     |   4.0963788085944d-03, 1.0905768301101d-03, 2.2851052925296d-04,
     |   3.5088000614389d-05, 3.5183553526061d-06, 1.8790496700062d-07,
     |   3.5339146969592d-09, 8.0273599688340d-12, 1.5429377519858d-17/
      data (pmn(lat,13,18), lat = 1,72)/
     |   1.7661731223114d-19, 2.7624584923130d-13, 2.0355063397987d-10,
     |   1.5250256063595d-08, 3.7034085545315d-07, 4.5643770662391d-06,
     |   3.5611222905202d-05, 1.9932954084075d-04, 8.6506152103406d-04,
     |   3.0640074850382d-03, 9.1771504289700d-03, 2.3840153177325d-02,
     |   5.4717431479415d-02, 1.1247930662987d-01, 2.0915816092074d-01,
     |   3.5431101511196d-01, 5.4922034249510d-01, 7.8059425065658d-01,
     |   1.0164115261165d+00, 1.2070014700812d+00, 1.2935427581263d+00,
     |   1.2237722628193d+00, 9.7141179449849d-01, 5.5292419215813d-01,
     |   3.4210165176951d-02,-4.7820149462000d-01,-8.6210311218141d-01,
     |  -1.0150667759139d+00,-8.8948203607321d-01,-5.1437334721506d-01,
     |   5.8367501366881d-03, 5.1812789313525d-01, 8.6648487045303d-01,
     |   9.4186721429055d-01, 7.1927888307721d-01, 2.6822167097841d-01,
     |  -2.6822167097841d-01,-7.1927888307721d-01,-9.4186721429055d-01,
     |  -8.6648487045303d-01,-5.1812789313525d-01,-5.8367501366869d-03,
     |   5.1437334721505d-01, 8.8948203607321d-01, 1.0150667759139d+00,
     |   8.6210311218141d-01, 4.7820149462000d-01,-3.4210165176948d-02,
     |  -5.5292419215812d-01,-9.7141179449849d-01,-1.2237722628193d+00,
     |  -1.2935427581263d+00,-1.2070014700812d+00,-1.0164115261165d+00,
     |  -7.8059425065658d-01,-5.4922034249510d-01,-3.5431101511196d-01,
     |  -2.0915816092074d-01,-1.1247930662987d-01,-5.4717431479415d-02,
     |  -2.3840153177325d-02,-9.1771504289700d-03,-3.0640074850382d-03,
     |  -8.6506152103407d-04,-1.9932954084075d-04,-3.5611222905202d-05,
     |  -4.5643770662392d-06,-3.7034085545315d-07,-1.5250256063595d-08,
     |  -2.0355063397987d-10,-2.7624584923130d-13,-1.7661731223114d-19/
      data (pmn(lat,14,18), lat = 1,72)/
     |   1.7411012148560d-21, 8.1850345870618d-15, 1.0089730181888d-11,
     |   1.0643466805920d-09, 3.3487717119221d-08, 5.0938593416386d-07,
     |   4.7531187558735d-06, 3.1138017324350d-05, 1.5573377845524d-04,
     |   6.2858377252603d-04, 2.1280054953025d-03, 6.2122914255542d-03,
     |   1.5961932239578d-02, 3.6655973076740d-02, 7.6116833706765d-02,
     |   1.4418027475990d-01, 2.5074732902947d-01, 4.0219176607268d-01,
     |   5.9656553216488d-01, 8.1891425421788d-01, 1.0387359714543d+00,
     |   1.2117426832111d+00, 1.2872739970656d+00, 1.2209506584838d+00,
     |   9.8988671958813d-01, 6.0584117556930d-01, 1.2103472702507d-01,
     |  -3.7736692570209d-01,-7.8492759199814d-01,-1.0063817718261d+00,
     |  -9.8367107825045d-01,-7.1663001321794d-01,-2.6861662264817d-01,
     |   2.4641648272241d-01, 6.9299344241154d-01, 9.5130643075199d-01,
     |   9.5130643075199d-01, 6.9299344241154d-01, 2.4641648272242d-01,
     |  -2.6861662264817d-01,-7.1663001321794d-01,-9.8367107825045d-01,
     |  -1.0063817718261d+00,-7.8492759199814d-01,-3.7736692570209d-01,
     |   1.2103472702507d-01, 6.0584117556929d-01, 9.8988671958813d-01,
     |   1.2209506584838d+00, 1.2872739970656d+00, 1.2117426832111d+00,
     |   1.0387359714543d+00, 8.1891425421788d-01, 5.9656553216489d-01,
     |   4.0219176607268d-01, 2.5074732902947d-01, 1.4418027475990d-01,
     |   7.6116833706764d-02, 3.6655973076740d-02, 1.5961932239579d-02,
     |   6.2122914255542d-03, 2.1280054953025d-03, 6.2858377252603d-04,
     |   1.5573377845524d-04, 3.1138017324350d-05, 4.7531187558735d-06,
     |   5.0938593416388d-07, 3.3487717119221d-08, 1.0643466805920d-09,
     |   1.0089730181888d-11, 8.1850345870618d-15, 1.7411012148560d-21/
      data (pmn(lat,15,18), lat = 1,72)/
     |   1.4550167457952d-23, 2.0554832569176d-16, 4.2372516501472d-13,
     |   6.2896310001692d-11, 2.5618122833027d-09, 4.8042592140258d-08,
     |   5.3543056153851d-07, 4.0985307965379d-06, 2.3575861238366d-05,
     |   1.0817694653758d-04, 4.1273119749386d-04, 1.3492412149983d-03,
     |   3.8643291443684d-03, 9.8618422168458d-03, 2.2719103975783d-02,
     |   4.7726692121544d-02, 9.2146437089895d-02, 1.6449963839882d-01,
     |   2.7275717551215d-01, 4.2137442759362d-01, 6.0759191949464d-01,
     |   8.1799013161940d-01, 1.0267201410461d+00, 1.1968665750647d+00,
     |   1.2858458835414d+00, 1.2546057054845d+00, 1.0789351547043d+00,
     |   7.5990926473574d-01, 3.2993288857055d-01,-1.4857298509082d-01,
     |  -5.9303971419755d-01,-9.1783846083111d-01,-1.0547275059701d+00,
     |  -9.7119201741984d-01,-6.8120458747117d-01,-2.4471430819941d-01,
     |   2.4471430819941d-01, 6.8120458747117d-01, 9.7119201741984d-01,
     |   1.0547275059701d+00, 9.1783846083111d-01, 5.9303971419755d-01,
     |   1.4857298509082d-01,-3.2993288857055d-01,-7.5990926473574d-01,
     |  -1.0789351547043d+00,-1.2546057054845d+00,-1.2858458835414d+00,
     |  -1.1968665750647d+00,-1.0267201410461d+00,-8.1799013161940d-01,
     |  -6.0759191949464d-01,-4.2137442759363d-01,-2.7275717551215d-01,
     |  -1.6449963839882d-01,-9.2146437089895d-02,-4.7726692121544d-02,
     |  -2.2719103975783d-02,-9.8618422168458d-03,-3.8643291443684d-03,
     |  -1.3492412149983d-03,-4.1273119749386d-04,-1.0817694653758d-04,
     |  -2.3575861238366d-05,-4.0985307965380d-06,-5.3543056153851d-07,
     |  -4.8042592140259d-08,-2.5618122833027d-09,-6.2896310001692d-11,
     |  -4.2372516501472d-13,-2.0554832569176d-16,-1.4550167457952d-23/
      data (pmn(lat,16,18), lat = 1,72)/
     |   1.0020460820498d-25, 4.2531774393184d-18, 1.4657317912400d-14,
     |   3.0599782105309d-12, 1.6123801571913d-10, 3.7246632721774d-09,
     |   4.9526604058642d-08, 4.4238694411484d-07, 2.9221140177395d-06,
     |   1.5213285881215d-05, 6.5266615339003d-05, 2.3827553730970d-04,
     |   7.5824318135310d-04, 2.1420484945168d-03, 5.4490399754580d-03,
     |   1.2622553018460d-02, 2.6864557324985d-02, 5.2906091292327d-02,
     |   9.6958179055225d-02, 1.6609281271133d-01, 2.6686005022213d-01,
     |   4.0312786542028d-01, 5.7342629738726d-01, 7.6841775462153d-01,
     |   9.6937857498677d-01, 1.1486213285654d+00, 1.2725080923678d+00,
     |   1.3070930216118d+00, 1.2256091017267d+00, 1.0162175325563d+00,
     |   6.8795881208882d-01, 2.7292123663302d-01,-1.7663961488661d-01,
     |  -5.9626631356598d-01,-9.2097026244034d-01,-1.0980606870045d+00,
     |  -1.0980606870045d+00,-9.2097026244034d-01,-5.9626631356598d-01,
     |  -1.7663961488661d-01, 2.7292123663302d-01, 6.8795881208882d-01,
     |   1.0162175325563d+00, 1.2256091017267d+00, 1.3070930216118d+00,
     |   1.2725080923678d+00, 1.1486213285654d+00, 9.6937857498677d-01,
     |   7.6841775462153d-01, 5.7342629738726d-01, 4.0312786542028d-01,
     |   2.6686005022213d-01, 1.6609281271133d-01, 9.6958179055226d-02,
     |   5.2906091292327d-02, 2.6864557324985d-02, 1.2622553018460d-02,
     |   5.4490399754580d-03, 2.1420484945168d-03, 7.5824318135311d-04,
     |   2.3827553730970d-04, 6.5266615339003d-05, 1.5213285881215d-05,
     |   2.9221140177396d-06, 4.4238694411484d-07, 4.9526604058642d-08,
     |   3.7246632721775d-09, 1.6123801571913d-10, 3.0599782105309d-12,
     |   1.4657317912400d-14, 4.2531774393184d-18, 1.0020460820498d-25/
      data (pmn(lat,17,18), lat = 1,72)/
     |   5.3804694534415d-28, 6.8606910727553d-20, 3.9515055909727d-16,
     |   1.1597684756553d-13, 7.9014177023507d-12, 2.2467452656343d-10,
     |   3.5611818500887d-09, 3.7079001521900d-08, 2.8087781294508d-07,
     |   1.6566711541379d-06, 7.9772600955272d-06, 3.2455022507605d-05,
     |   1.1446269559219d-04, 3.5688853304953d-04, 9.9897058265131d-04,
     |   2.5410608870273d-03, 5.9316344955094d-03, 1.2808148272545d-02,
     |   2.5750006576744d-02, 4.8458211484222d-02, 8.5735312814398d-02,
     |   1.4312183663594d-01, 2.2607430496654d-01, 3.3866025719113d-01,
     |   4.8189354627342d-01, 6.5200901803906d-01, 8.3912600284687d-01,
     |   1.0268106529182d+00, 1.1929653841539d+00, 1.3122326900633d+00,
     |   1.3597358032836d+00, 1.3155775124765d+00, 1.1691998373564d+00,
     |   9.2258519736575d-01, 5.9142236672784d-01, 2.0376027161634d-01,
     |  -2.0376027161634d-01,-5.9142236672784d-01,-9.2258519736575d-01,
     |  -1.1691998373564d+00,-1.3155775124765d+00,-1.3597358032836d+00,
     |  -1.3122326900633d+00,-1.1929653841539d+00,-1.0268106529182d+00,
     |  -8.3912600284687d-01,-6.5200901803906d-01,-4.8189354627342d-01,
     |  -3.3866025719113d-01,-2.2607430496654d-01,-1.4312183663594d-01,
     |  -8.5735312814399d-02,-4.8458211484222d-02,-2.5750006576744d-02,
     |  -1.2808148272545d-02,-5.9316344955094d-03,-2.5410608870273d-03,
     |  -9.9897058265131d-04,-3.5688853304953d-04,-1.1446269559219d-04,
     |  -3.2455022507605d-05,-7.9772600955272d-06,-1.6566711541380d-06,
     |  -2.8087781294509d-07,-3.7079001521900d-08,-3.5611818500887d-09,
     |  -2.2467452656344d-10,-7.9014177023507d-12,-1.1597684756553d-13,
     |  -3.9515055909727d-16,-6.8606910727553d-20,-5.3804694534415d-28/
      data (pmn(lat,18,18), lat = 1,72)/
     |   1.9567043519615d-30, 7.4945575035663d-22, 7.2126707529570d-18,
     |   2.9750906904077d-15, 2.6194828347169d-13, 9.1629178138819d-12,
     |   1.7299830860221d-10, 2.0977708301684d-09, 1.8204567950621d-08,
     |   1.2149212567424d-07, 6.5565822139521d-07, 2.9675725113439d-06,
     |   1.1576278126277d-05, 3.9744215650342d-05, 1.2207925603885d-04,
     |   3.3990282918387d-04, 8.6698397327294d-04, 2.0435224291470d-03,
     |   4.4831346321676d-03, 9.2093333419034d-03, 1.7803997636685d-02,
     |   3.2532259318313d-02, 5.6390684600586d-02, 9.3015805217245d-02,
     |   1.4639599117524d-01, 2.2035724947853d-01, 3.1784315144537d-01,
     |   4.4007320226603d-01, 5.8572711590482d-01, 7.5034440071571d-01,
     |   9.2613026421454d-01, 1.1023091305709d+00, 1.2660688868329d+00,
     |   1.4040108836880d+00, 1.5038936031272d+00, 1.5563668405523d+00,
     |   1.5563668405523d+00, 1.5038936031272d+00, 1.4040108836880d+00,
     |   1.2660688868329d+00, 1.1023091305709d+00, 9.2613026421454d-01,
     |   7.5034440071572d-01, 5.8572711590482d-01, 4.4007320226603d-01,
     |   3.1784315144537d-01, 2.2035724947853d-01, 1.4639599117524d-01,
     |   9.3015805217245d-02, 5.6390684600586d-02, 3.2532259318313d-02,
     |   1.7803997636685d-02, 9.2093333419034d-03, 4.4831346321677d-03,
     |   2.0435224291470d-03, 8.6698397327295d-04, 3.3990282918387d-04,
     |   1.2207925603885d-04, 3.9744215650342d-05, 1.1576278126277d-05,
     |   2.9675725113439d-06, 6.5565822139521d-07, 1.2149212567424d-07,
     |   1.8204567950621d-08, 2.0977708301684d-09, 1.7299830860221d-10,
     |   9.1629178138822d-12, 2.6194828347169d-13, 2.9750906904077d-15,
     |   7.2126707529570d-18, 7.4945575035663d-22, 1.9567043519615d-30/
      data (pmn(lat, 0,19), lat = 1,72)/
     |   4.2184510292193d+00, 2.7933256936629d+00, 6.6791322655593d-01,
     |  -1.1176450879758d+00,-1.7842619781669d+00,-1.2194253699337d+00,
     |   1.6687728691588d-02, 1.0693861818181d+00, 1.3093799092842d+00,
     |   6.7860139205181d-01,-3.3314123444822d-01,-1.0415999081671d+00,
     |  -1.0131697383360d+00,-3.2033885656055d-01, 5.3998134654968d-01,
     |   9.9328548872364d-01, 7.6380659691263d-01, 3.7782636040613d-02,
     |  -6.8102536327374d-01,-9.1598508480797d-01,-5.2988463668909d-01,
     |   1.9764507246941d-01, 7.6974426957706d-01, 8.0862109229682d-01,
     |   3.0289725893386d-01,-3.9472903698136d-01,-8.1149859033105d-01,
     |  -6.7286722913309d-01,-8.2125475063987d-02, 5.5545185712321d-01,
     |   8.0903552454770d-01, 5.1181198438741d-01,-1.2993280806650d-01,
     |  -6.7917874543548d-01,-7.6431785708707d-01,-3.2937918885513d-01,
     |   3.2937918885513d-01, 7.6431785708707d-01, 6.7917874543548d-01,
     |   1.2993280806650d-01,-5.1181198438741d-01,-8.0903552454770d-01,
     |  -5.5545185712322d-01, 8.2125475063981d-02, 6.7286722913309d-01,
     |   8.1149859033105d-01, 3.9472903698136d-01,-3.0289725893385d-01,
     |  -8.0862109229682d-01,-7.6974426957706d-01,-1.9764507246941d-01,
     |   5.2988463668909d-01, 9.1598508480797d-01, 6.8102536327374d-01,
     |  -3.7782636040611d-02,-7.6380659691262d-01,-9.9328548872365d-01,
     |  -5.3998134654968d-01, 3.2033885656055d-01, 1.0131697383360d+00,
     |   1.0415999081671d+00, 3.3314123444822d-01,-6.7860139205180d-01,
     |  -1.3093799092842d+00,-1.0693861818181d+00,-1.6687728691588d-02,
     |   1.2194253699337d+00, 1.7842619781669d+00, 1.1176450879758d+00,
     |  -6.6791322655593d-01,-2.7933256936629d+00,-4.2184510292193d+00/
      data (pmn(lat, 1,19), lat = 1,72)/
     |   9.1796847337399d-01, 2.2822152076240d+00, 2.4992550712011d+00,
     |   1.5379350119258d+00, 7.4123303900435d-03,-1.2176158851908d+00,
     |  -1.5102939527539d+00,-8.3429922672356d-01, 2.8077785139340d-01,
     |   1.0987628512334d+00, 1.1365391213245d+00, 4.3888188111523d-01,
     |  -4.8969614486086d-01,-1.0344976881076d+00,-8.6772497719899d-01,
     |  -1.4063202095593d-01, 6.4055519070250d-01, 9.6039798101849d-01,
     |   6.2963508331855d-01,-1.0569086428673d-01,-7.4302475041387d-01,
     |  -8.6300681726488d-01,-4.0283074069951d-01, 3.1357311024333d-01,
     |   8.0114931471672d-01, 7.3968398780808d-01, 1.8261228289323d-01,
     |  -4.8668539176778d-01,-8.1694553828020d-01,-5.9152978873798d-01,
     |   3.0308087494367d-02, 6.2505449856989d-01, 7.9185828750077d-01,
     |   4.2137404750698d-01,-2.3293974443617d-01,-7.2734730699805d-01,
     |  -7.2734730699805d-01,-2.3293974443617d-01, 4.2137404750698d-01,
     |   7.9185828750077d-01, 6.2505449856989d-01, 3.0308087494365d-02,
     |  -5.9152978873798d-01,-8.1694553828020d-01,-4.8668539176778d-01,
     |   1.8261228289323d-01, 7.3968398780808d-01, 8.0114931471672d-01,
     |   3.1357311024334d-01,-4.0283074069951d-01,-8.6300681726488d-01,
     |  -7.4302475041388d-01,-1.0569086428674d-01, 6.2963508331855d-01,
     |   9.6039798101849d-01, 6.4055519070250d-01,-1.4063202095593d-01,
     |  -8.6772497719899d-01,-1.0344976881076d+00,-4.8969614486086d-01,
     |   4.3888188111523d-01, 1.1365391213245d+00, 1.0987628512334d+00,
     |   2.8077785139341d-01,-8.3429922672355d-01,-1.5102939527539d+00,
     |  -1.2176158851908d+00, 7.4123303900435d-03, 1.5379350119258d+00,
     |   2.4992550712011d+00, 2.2822152076240d+00, 9.1796847337399d-01/
      data (pmn(lat, 2,19), lat = 1,72)/
     |   9.8088057347224d-02, 7.8117658311565d-01, 1.6778454861700d+00,
     |   2.1484767470976d+00, 1.7928093583536d+00, 7.1077296085319d-01,
     |  -5.4975564481721d-01,-1.3250392258218d+00,-1.2385660022800d+00,
     |  -4.2351740021230d-01, 5.7110061013711d-01, 1.1266444828021d+00,
     |   9.3283193254025d-01, 1.6191994375455d-01,-6.6314587384872d-01,
     |  -1.0139348478339d+00,-6.9068778039258d-01, 6.5320232732858d-02,
     |   7.4482830098948d-01, 9.0887037509704d-01, 4.6993971664438d-01,
     |  -2.6326092160754d-01,-7.9946643457022d-01,-7.9118349923613d-01,
     |  -2.5848400591055d-01, 4.3329558730972d-01, 8.2190823245098d-01,
     |   6.5517582039394d-01, 5.3815296536325d-02,-5.7465553091332d-01,
     |  -8.1041009561550d-01,-5.0037439765446d-01, 1.4281361456604d-01,
     |   6.8572033444117d-01, 7.6476662525541d-01, 3.2861680366452d-01,
     |  -3.2861680366451d-01,-7.6476662525541d-01,-6.8572033444117d-01,
     |  -1.4281361456604d-01, 5.0037439765446d-01, 8.1041009561550d-01,
     |   5.7465553091332d-01,-5.3815296536319d-02,-6.5517582039394d-01,
     |  -8.2190823245098d-01,-4.3329558730972d-01, 2.5848400591054d-01,
     |   7.9118349923613d-01, 7.9946643457022d-01, 2.6326092160754d-01,
     |  -4.6993971664437d-01,-9.0887037509704d-01,-7.4482830098948d-01,
     |  -6.5320232732860d-02, 6.9068778039257d-01, 1.0139348478339d+00,
     |   6.6314587384872d-01,-1.6191994375455d-01,-9.3283193254025d-01,
     |  -1.1266444828021d+00,-5.7110061013711d-01, 4.2351740021230d-01,
     |   1.2385660022800d+00, 1.3250392258218d+00, 5.4975564481721d-01,
     |  -7.1077296085318d-01,-1.7928093583536d+00,-2.1484767470976d+00,
     |  -1.6778454861700d+00,-7.8117658311565d-01,-9.8088057347224d-02/
      data (pmn(lat, 3,19), lat = 1,72)/
     |   6.9238646169225d-03, 1.7076671468463d-01, 6.5619042757414d-01,
     |   1.3410481123413d+00, 1.8567653536074d+00, 1.8249015241164d+00,
     |   1.1282318610531d+00, 3.1380609932353d-02,-9.4103827491659d-01,
     |  -1.3037051366678d+00,-9.0306966359473d-01,-1.6465733647921d-02,
     |   8.1026705091002d-01, 1.0901374585841d+00, 6.8528774787213d-01,
     |  -1.1992026571165d-01,-8.0687036184770d-01,-9.5140687150532d-01,
     |  -4.8551603243112d-01, 2.7111408977336d-01, 8.2499883841983d-01,
     |   8.2768399328809d-01, 2.9449070329582d-01,-4.1454743183590d-01,
     |  -8.3475325423687d-01,-6.9943294608362d-01,-1.0878467297239d-01,
     |   5.4197932164265d-01, 8.2508104039004d-01, 5.6004042067292d-01,
     |  -7.1486386716572d-02,-6.4897457700603d-01,-7.9153509551373d-01,
     |  -4.0808836903503d-01, 2.4454980040363d-01, 7.3270961951130d-01,
     |   7.3270961951130d-01, 2.4454980040363d-01,-4.0808836903503d-01,
     |  -7.9153509551373d-01,-6.4897457700603d-01,-7.1486386716571d-02,
     |   5.6004042067292d-01, 8.2508104039004d-01, 5.4197932164266d-01,
     |  -1.0878467297239d-01,-6.9943294608362d-01,-8.3475325423687d-01,
     |  -4.1454743183590d-01, 2.9449070329582d-01, 8.2768399328809d-01,
     |   8.2499883841984d-01, 2.7111408977337d-01,-4.8551603243112d-01,
     |  -9.5140687150532d-01,-8.0687036184771d-01,-1.1992026571166d-01,
     |   6.8528774787213d-01, 1.0901374585841d+00, 8.1026705091002d-01,
     |  -1.6465733647921d-02,-9.0306966359473d-01,-1.3037051366678d+00,
     |  -9.4103827491660d-01, 3.1380609932347d-02, 1.1282318610531d+00,
     |   1.8249015241164d+00, 1.8567653536074d+00, 1.3410481123413d+00,
     |   6.5619042757414d-01, 1.7076671468463d-01, 6.9238646169225d-03/
      data (pmn(lat, 4,19), lat = 1,72)/
     |   3.6305428109223d-04, 2.7374993567249d-02, 1.8254418956849d-01,
     |   5.5923639389595d-01, 1.1122292211394d+00, 1.6160308637517d+00,
     |   1.7648919152666d+00, 1.3647114539369d+00, 4.9175367256260d-01,
     |  -4.9975353979689d-01,-1.1484986908956d+00,-1.1451791857791d+00,
     |  -5.2276848698521d-01, 3.4705417096520d-01, 9.6085100743895d-01,
     |   9.7543363023623d-01, 4.0852717892195d-01,-3.7669946538245d-01,
     |  -8.9624586755157d-01,-8.4188489544301d-01,-2.6665929271486d-01,
     |   4.5521417682846d-01, 8.6750229451779d-01, 7.1892847289835d-01,
     |   1.1734538897783d-01,-5.4469546908068d-01,-8.4355273259840d-01,
     |  -5.9457426221150d-01, 3.3347988329592d-02, 6.3037715037478d-01,
     |   8.1151879666429d-01, 4.6406164649381d-01,-1.8207777235908d-01,
     |  -7.0526652887079d-01,-7.6596262450848d-01,-3.2628438941279d-01,
     |   3.2628438941278d-01, 7.6596262450848d-01, 7.0526652887079d-01,
     |   1.8207777235908d-01,-4.6406164649381d-01,-8.1151879666429d-01,
     |  -6.3037715037478d-01,-3.3347988329598d-02, 5.9457426221149d-01,
     |   8.4355273259840d-01, 5.4469546908068d-01,-1.1734538897783d-01,
     |  -7.1892847289835d-01,-8.6750229451779d-01,-4.5521417682846d-01,
     |   2.6665929271485d-01, 8.4188489544301d-01, 8.9624586755157d-01,
     |   3.7669946538246d-01,-4.0852717892194d-01,-9.7543363023623d-01,
     |  -9.6085100743894d-01,-3.4705417096520d-01, 5.2276848698520d-01,
     |   1.1451791857791d+00, 1.1484986908956d+00, 4.9975353979690d-01,
     |  -4.9175367256259d-01,-1.3647114539369d+00,-1.7648919152666d+00,
     |  -1.6160308637517d+00,-1.1122292211394d+00,-5.5923639389595d-01,
     |  -1.8254418956849d-01,-2.7374993567249d-02,-3.6305428109223d-04/
      data (pmn(lat, 5,19), lat = 1,72)/
     |   1.5051618240605d-05, 3.4479346815550d-03, 3.9342835613156d-02,
     |   1.7611642960474d-01, 4.8032340527500d-01, 9.3949705862899d-01,
     |   1.4123427261066d+00, 1.6633842930948d+00, 1.4846147244921d+00,
     |   8.3922581279300d-01,-6.8912345652928d-02,-8.6347154311671d-01,
     |  -1.1824590745088d+00,-8.8318389346223d-01,-1.4033212871660d-01,
     |   6.3368831853185d-01, 1.0122000168036d+00, 7.9600353103480d-01,
     |   1.2912961756391d-01,-5.8541011095291d-01,-9.2435249208689d-01,
     |  -6.9609727613913d-01,-5.3344418653325d-02, 6.0307009955043d-01,
     |   8.7112142675701d-01, 5.9390408131906d-01,-4.6513142577907d-02,
     |  -6.4545799260333d-01,-8.2942525446563d-01,-4.8875808001665d-01,
     |   1.5600389314609d-01, 6.9506608631933d-01, 7.8846545975268d-01,
     |   3.8003084368178d-01,-2.6841988891480d-01,-7.4380797034052d-01,
     |  -7.4380797034052d-01,-2.6841988891480d-01, 3.8003084368178d-01,
     |   7.8846545975268d-01, 6.9506608631933d-01, 1.5600389314609d-01,
     |  -4.8875808001665d-01,-8.2942525446563d-01,-6.4545799260333d-01,
     |  -4.6513142577908d-02, 5.9390408131905d-01, 8.7112142675701d-01,
     |   6.0307009955043d-01,-5.3344418653325d-02,-6.9609727613913d-01,
     |  -9.2435249208689d-01,-5.8541011095291d-01, 1.2912961756391d-01,
     |   7.9600353103480d-01, 1.0122000168036d+00, 6.3368831853185d-01,
     |  -1.4033212871661d-01,-8.8318389346223d-01,-1.1824590745088d+00,
     |  -8.6347154311671d-01,-6.8912345652928d-02, 8.3922581279299d-01,
     |   1.4846147244921d+00, 1.6633842930948d+00, 1.4123427261066d+00,
     |   9.3949705862900d-01, 4.8032340527500d-01, 1.7611642960474d-01,
     |   3.9342835613156d-02, 3.4479346815550d-03, 1.5051618240605d-05/
      data (pmn(lat, 6,19), lat = 1,72)/
     |   5.1251757071303d-07, 3.5541431111147d-04, 6.8865845518621d-03,
     |   4.4456429291888d-02, 1.6273122921953d-01, 4.1329524567569d-01,
     |   8.0011677059151d-01, 1.2351821391573d+00, 1.5419067758683d+00,
     |   1.5263297098325d+00, 1.0900958733824d+00, 3.2013831258132d-01,
     |  -5.1140373515045d-01,-1.0584972865104d+00,-1.0767824370254d+00,
     |  -5.6723307128261d-01, 2.0261988153812d-01, 8.2650705773530d-01,
     |   9.7503405523355d-01, 5.7940814875437d-01,-1.2610501113792d-01,
     |  -7.3449152126948d-01,-8.9886021237520d-01,-5.3351702005763d-01,
     |   1.3644560819557d-01, 7.0897355486023d-01, 8.4457893440913d-01,
     |   4.6884060603411d-01,-1.8431687270984d-01,-7.1546718399747d-01,
     |  -8.0262546347305d-01,-3.9674280627488d-01, 2.4952831123442d-01,
     |   7.3751771312732d-01, 7.6742394088315d-01, 3.2223749602687d-01,
     |  -3.2223749602687d-01,-7.6742394088315d-01,-7.3751771312732d-01,
     |  -2.4952831123442d-01, 3.9674280627488d-01, 8.0262546347305d-01,
     |   7.1546718399747d-01, 1.8431687270985d-01,-4.6884060603411d-01,
     |  -8.4457893440913d-01,-7.0897355486023d-01,-1.3644560819557d-01,
     |   5.3351702005763d-01, 8.9886021237520d-01, 7.3449152126948d-01,
     |   1.2610501113793d-01,-5.7940814875437d-01,-9.7503405523355d-01,
     |  -8.2650705773530d-01,-2.0261988153813d-01, 5.6723307128260d-01,
     |   1.0767824370254d+00, 1.0584972865104d+00, 5.1140373515046d-01,
     |  -3.2013831258132d-01,-1.0900958733824d+00,-1.5263297098325d+00,
     |  -1.5419067758683d+00,-1.2351821391573d+00,-8.0011677059151d-01,
     |  -4.1329524567570d-01,-1.6273122921953d-01,-4.4456429291888d-02,
     |  -6.8865845518621d-03,-3.5541431111147d-04,-5.1251757071303d-07/
      data (pmn(lat, 7,19), lat = 1,72)/
     |   1.4695849803053d-08, 3.0783231907908d-05, 1.0081383785836d-03,
     |   9.3131407762037d-03, 4.5213143858690d-02, 1.4640366405259d-01,
     |   3.5455434923477d-01, 6.8239504765220d-01, 1.0772762077372d+00,
     |   1.4101721926687d+00, 1.5129463958293d+00, 1.2595472507534d+00,
     |   6.5318044555034d-01,-1.3527387708029d-01,-8.1573892201101d-01,
     |  -1.1061497651916d+00,-8.7920591188278d-01,-2.4647001126710d-01,
     |   4.7783614596803d-01, 9.2737315638259d-01, 8.7455684628591d-01,
     |   3.5682620683080d-01,-3.3773637019805d-01,-8.2499569805348d-01,
     |  -8.3759028978877d-01,-3.7614834461457d-01, 2.8989554352702d-01,
     |   7.7582010093610d-01, 8.0318191703890d-01, 3.6124183885896d-01,
     |  -2.8694284463817d-01,-7.5880718671972d-01,-7.7727163234632d-01,
     |  -3.3399754510276d-01, 3.0597444732842d-01, 7.6148589801880d-01,
     |   7.6148589801880d-01, 3.0597444732842d-01,-3.3399754510276d-01,
     |  -7.7727163234632d-01,-7.5880718671972d-01,-2.8694284463817d-01,
     |   3.6124183885896d-01, 8.0318191703890d-01, 7.7582010093610d-01,
     |   2.8989554352702d-01,-3.7614834461457d-01,-8.3759028978876d-01,
     |  -8.2499569805348d-01,-3.3773637019805d-01, 3.5682620683080d-01,
     |   8.7455684628590d-01, 9.2737315638259d-01, 4.7783614596804d-01,
     |  -2.4647001126710d-01,-8.7920591188278d-01,-1.1061497651916d+00,
     |  -8.1573892201100d-01,-1.3527387708029d-01, 6.5318044555033d-01,
     |   1.2595472507534d+00, 1.5129463958293d+00, 1.4101721926687d+00,
     |   1.0772762077372d+00, 6.8239504765220d-01, 3.5455434923477d-01,
     |   1.4640366405259d-01, 4.5213143858690d-02, 9.3131407762037d-03,
     |   1.0081383785836d-03, 3.0783231907908d-05, 1.4695849803053d-08/
      data (pmn(lat, 8,19), lat = 1,72)/
     |   3.6093150576980d-10, 2.2803576362287d-06, 1.2584027753734d-04,
     |   1.6553751678732d-03, 1.0580460199150d-02, 4.3216269694194d-02,
     |   1.2888468127054d-01, 3.0195813732325d-01, 5.7974140271397d-01,
     |   9.3371172581394d-01, 1.2727864646859d+00, 1.4586805217440d+00,
     |   1.3595420066980d+00, 9.2366180791469d-01, 2.3450105926051d-01,
     |  -4.9260130412341d-01,-9.8670622152481d-01,-1.0444261351851d+00,
     |  -6.4009903596251d-01, 4.0760712238371d-02, 6.7472763866745d-01,
     |   9.5368686196986d-01, 7.4255493054639d-01, 1.5555086478614d-01,
     |  -4.9676504132845d-01,-8.6840343975536d-01,-7.6342197210118d-01,
     |  -2.4420725274485d-01, 4.0031298824548d-01, 8.1265542514025d-01,
     |   7.6517150355795d-01, 2.8782899287617d-01,-3.4791065755518d-01,
     |  -7.8173331692204d-01,-7.6823070785420d-01,-3.1620248576563d-01,
     |   3.1620248576563d-01, 7.6823070785420d-01, 7.8173331692204d-01,
     |   3.4791065755519d-01,-2.8782899287617d-01,-7.6517150355796d-01,
     |  -8.1265542514025d-01,-4.0031298824548d-01, 2.4420725274485d-01,
     |   7.6342197210118d-01, 8.6840343975536d-01, 4.9676504132845d-01,
     |  -1.5555086478614d-01,-7.4255493054639d-01,-9.5368686196986d-01,
     |  -6.7472763866746d-01,-4.0760712238374d-02, 6.4009903596251d-01,
     |   1.0444261351851d+00, 9.8670622152481d-01, 4.9260130412342d-01,
     |  -2.3450105926051d-01,-9.2366180791469d-01,-1.3595420066980d+00,
     |  -1.4586805217440d+00,-1.2727864646859d+00,-9.3371172581394d-01,
     |  -5.7974140271397d-01,-3.0195813732325d-01,-1.2888468127054d-01,
     |  -4.3216269694195d-02,-1.0580460199150d-02,-1.6553751678732d-03,
     |  -1.2584027753734d-04,-2.2803576362287d-06,-3.6093150576980d-10/
      data (pmn(lat, 9,19), lat = 1,72)/
     |   7.6815805092106d-12, 1.4623277788429d-07, 1.3569236510262d-05,
     |   2.5332231880791d-04, 2.1212882106911d-03, 1.0854694957488d-02,
     |   3.9484756481807d-02, 1.1108472141058d-01, 2.5423857956037d-01,
     |   4.8827785558685d-01, 8.0127134227907d-01, 1.1321598920186d+00,
     |   1.3726577742513d+00, 1.3990171387128d+00, 1.1282328434537d+00,
     |   5.7495388336699d-01,-1.2400383836598d-01,-7.4187698158403d-01,
     |  -1.0487355934745d+00,-9.1856656843434d-01,-4.0328393437912d-01,
     |   2.7153856599937d-01, 7.9873852005996d-01, 9.3220730893555d-01,
     |   6.1060481819163d-01,-4.6334515783277d-03,-6.0357732702173d-01,
     |  -8.8229611206201d-01,-6.9989271663236d-01,-1.5455753940071d-01,
     |   4.6500197919858d-01, 8.3046338762763d-01, 7.4838550069350d-01,
     |   2.6451026191585d-01,-3.5972681976480d-01,-7.8730457235419d-01,
     |  -7.8730457235419d-01,-3.5972681976480d-01, 2.6451026191585d-01,
     |   7.4838550069350d-01, 8.3046338762764d-01, 4.6500197919858d-01,
     |  -1.5455753940071d-01,-6.9989271663236d-01,-8.8229611206201d-01,
     |  -6.0357732702173d-01,-4.6334515783306d-03, 6.1060481819163d-01,
     |   9.3220730893555d-01, 7.9873852005996d-01, 2.7153856599937d-01,
     |  -4.0328393437911d-01,-9.1856656843434d-01,-1.0487355934745d+00,
     |  -7.4187698158403d-01,-1.2400383836598d-01, 5.7495388336699d-01,
     |   1.1282328434537d+00, 1.3990171387128d+00, 1.3726577742513d+00,
     |   1.1321598920186d+00, 8.0127134227907d-01, 4.8827785558685d-01,
     |   2.5423857956037d-01, 1.1108472141058d-01, 3.9484756481807d-02,
     |   1.0854694957489d-02, 2.1212882106911d-03, 2.5332231880791d-04,
     |   1.3569236510262d-05, 1.4623277788429d-07, 7.6815805092106d-12/
      data (pmn(lat,10,19), lat = 1,72)/
     |   1.4275877492233d-13, 8.1826093285991d-09, 1.2747814803320d-06,
     |   3.3694185812720d-05, 3.6839407421154d-04, 2.3505327549605d-03,
     |   1.0362801406095d-02, 3.4708641021219d-02, 9.3573617389097d-02,
     |   2.1069172749949d-01, 4.0573417781869d-01, 6.7800742544873d-01,
     |   9.8990029973214d-01, 1.2612192013952d+00, 1.3847475547939d+00,
     |   1.2648674349142d+00, 8.6740864260421d-01, 2.5720584953704d-01,
     |  -4.0150208498906d-01,-8.9348200536444d-01,-1.0374698184155d+00,
     |  -7.7239018279207d-01,-2.0113383852370d-01, 4.3761321220217d-01,
     |   8.6603226426234d-01, 8.9253299036948d-01, 5.0604021827679d-01,
     |  -1.1098999955858d-01,-6.6367233262688d-01,-8.8511317832257d-01,
     |  -6.6829012250013d-01,-1.2202250788436d-01, 4.8029816840421d-01,
     |   8.3624848587039d-01, 7.6679186078850d-01, 3.0770975225640d-01,
     |  -3.0770975225640d-01,-7.6679186078850d-01,-8.3624848587039d-01,
     |  -4.8029816840421d-01, 1.2202250788436d-01, 6.6829012250014d-01,
     |   8.8511317832257d-01, 6.6367233262689d-01, 1.1098999955858d-01,
     |  -5.0604021827678d-01,-8.9253299036948d-01,-8.6603226426234d-01,
     |  -4.3761321220217d-01, 2.0113383852370d-01, 7.7239018279207d-01,
     |   1.0374698184155d+00, 8.9348200536444d-01, 4.0150208498906d-01,
     |  -2.5720584953704d-01,-8.6740864260421d-01,-1.2648674349142d+00,
     |  -1.3847475547939d+00,-1.2612192013952d+00,-9.8990029973214d-01,
     |  -6.7800742544873d-01,-4.0573417781869d-01,-2.1069172749950d-01,
     |  -9.3573617389098d-02,-3.4708641021219d-02,-1.0362801406095d-02,
     |  -2.3505327549606d-03,-3.6839407421154d-04,-3.3694185812720d-05,
     |  -1.2747814803320d-06,-8.1826093285991d-09,-1.4275877492233d-13/
      data (pmn(lat,11,19), lat = 1,72)/
     |   2.3271021836561d-15, 4.0138298619061d-10, 1.0486823181427d-07,
     |   3.9173826833224d-06, 5.5782805429088d-05, 4.4231008008225d-04,
     |   2.3528971770307d-03, 9.3272614851988d-03, 2.9391775789210d-02,
     |   7.6778241346507d-02, 1.7099844637462d-01, 3.3087911706292d-01,
     |   5.6297264719606d-01, 8.4754315345291d-01, 1.1294060058801d+00,
     |   1.3223684815950d+00, 1.3323965336534d+00, 1.0958908679562d+00,
     |   6.1906226479263d-01,-1.7422920393963d-03,-5.9552493859874d-01,
     |  -9.7074289432150d-01,-9.9137135066662d-01,-6.4289933972866d-01,
     |  -5.4516284666627d-02, 5.4053376422584d-01, 8.9654952759295d-01,
     |   8.6185534275054d-01, 4.5114175590383d-01,-1.5383209420355d-01,
     |  -6.8095846844321d-01,-8.9021454436305d-01,-6.8562976609747d-01,
     |  -1.6265932008672d-01, 4.3398437028257d-01, 8.2411545640597d-01,
     |   8.2411545640597d-01, 4.3398437028257d-01,-1.6265932008672d-01,
     |  -6.8562976609747d-01,-8.9021454436305d-01,-6.8095846844321d-01,
     |  -1.5383209420355d-01, 4.5114175590383d-01, 8.6185534275054d-01,
     |   8.9654952759295d-01, 5.4053376422585d-01,-5.4516284666623d-02,
     |  -6.4289933972866d-01,-9.9137135066662d-01,-9.7074289432150d-01,
     |  -5.9552493859875d-01,-1.7422920393983d-03, 6.1906226479263d-01,
     |   1.0958908679562d+00, 1.3323965336534d+00, 1.3223684815950d+00,
     |   1.1294060058800d+00, 8.4754315345291d-01, 5.6297264719606d-01,
     |   3.3087911706292d-01, 1.7099844637462d-01, 7.6778241346508d-02,
     |   2.9391775789210d-02, 9.3272614851988d-03, 2.3528971770307d-03,
     |   4.4231008008226d-04, 5.5782805429088d-05, 3.9173826833224d-06,
     |   1.0486823181427d-07, 4.0138298619061d-10, 2.3271021836561d-15/
      data (pmn(lat,12,19), lat = 1,72)/
     |   3.3324265528534d-17, 1.7289163586616d-11, 7.5687366618614d-09,
     |   3.9904701743152d-07, 7.3868278194233d-06, 7.2605461139064d-05,
     |   4.6451163891150d-04, 2.1702930738532d-03, 7.9506360866633d-03,
     |   2.3926940427960d-02, 6.1062879902670d-02, 1.3510825703115d-01,
     |   2.6319397697070d-01, 4.5603771322451d-01, 7.0695988800071d-01,
     |   9.8197265150887d-01, 1.2174090547290d+00, 1.3308909989655d+00,
     |   1.2468277304133d+00, 9.3013575969438d-01, 4.1479919080378d-01,
     |  -1.8843347075308d-01,-7.1552654378297d-01,-1.0016105395032d+00,
     |  -9.4541134025572d-01,-5.5889295066496d-01, 2.3096107377756d-02,
     |   5.8402344902888d-01, 9.0642359254590d-01, 8.6089946596614d-01,
     |   4.6452066544050d-01,-1.2005376692489d-01,-6.4857260182550d-01,
     |  -8.9743844870002d-01,-7.6034274526727d-01,-2.9594695978222d-01,
     |   2.9594695978222d-01, 7.6034274526727d-01, 8.9743844870002d-01,
     |   6.4857260182550d-01, 1.2005376692490d-01,-4.6452066544050d-01,
     |  -8.6089946596614d-01,-9.0642359254590d-01,-5.8402344902888d-01,
     |  -2.3096107377757d-02, 5.5889295066496d-01, 9.4541134025571d-01,
     |   1.0016105395032d+00, 7.1552654378297d-01, 1.8843347075308d-01,
     |  -4.1479919080378d-01,-9.3013575969438d-01,-1.2468277304134d+00,
     |  -1.3308909989655d+00,-1.2174090547290d+00,-9.8197265150887d-01,
     |  -7.0695988800071d-01,-4.5603771322451d-01,-2.6319397697070d-01,
     |  -1.3510825703115d-01,-6.1062879902670d-02,-2.3926940427960d-02,
     |  -7.9506360866634d-03,-2.1702930738532d-03,-4.6451163891150d-04,
     |  -7.2605461139066d-05,-7.3868278194233d-06,-3.9904701743152d-07,
     |  -7.5687366618614d-09,-1.7289163586616d-11,-3.3324265528534d-17/
      data (pmn(lat,13,19), lat = 1,72)/
     |   4.1862367490321d-19, 6.5307370372204d-13, 4.7871972907916d-10,
     |   3.5585719940702d-08, 8.5508168879386d-07, 1.0398507186670d-05,
     |   7.9814353589166d-05, 4.3814759273653d-04, 1.8587013613571d-03,
     |   6.4122421109773d-03, 1.8632938373753d-02, 4.6756448843140d-02,
     |   1.0315107304555d-01, 2.0265652552300d-01, 3.5774357352700d-01,
     |   5.7057748977373d-01, 8.2409561199528d-01, 1.0762809557464d+00,
     |   1.2626000405577d+00, 1.3098747201660d+00, 1.1604625600797d+00,
     |   7.9986686771582d-01, 2.7646454369281d-01,-2.9817159272540d-01,
     |  -7.7436050585588d-01,-1.0107223031107d+00,-9.2706078576373d-01,
     |  -5.4265847411126d-01, 1.8705406873952d-02, 5.6424552273810d-01,
     |   8.9878380772431d-01, 8.9839788748917d-01, 5.6134959584929d-01,
     |   1.3544108452868d-02,-5.3655665005716d-01,-8.7749651313091d-01,
     |  -8.7749651313091d-01,-5.3655665005716d-01, 1.3544108452867d-02,
     |   5.6134959584929d-01, 8.9839788748917d-01, 8.9878380772431d-01,
     |   5.6424552273810d-01, 1.8705406873957d-02,-5.4265847411126d-01,
     |  -9.2706078576373d-01,-1.0107223031107d+00,-7.7436050585588d-01,
     |  -2.9817159272540d-01, 2.7646454369281d-01, 7.9986686771582d-01,
     |   1.1604625600797d+00, 1.3098747201660d+00, 1.2626000405577d+00,
     |   1.0762809557464d+00, 8.2409561199528d-01, 5.7057748977374d-01,
     |   3.5774357352700d-01, 2.0265652552300d-01, 1.0315107304555d-01,
     |   4.6756448843140d-02, 1.8632938373753d-02, 6.4122421109773d-03,
     |   1.8587013613572d-03, 4.3814759273653d-04, 7.9814353589166d-05,
     |   1.0398507186670d-05, 8.5508168879386d-07, 3.5585719940702d-08,
     |   4.7871972907916d-10, 6.5307370372204d-13, 4.1862367490321d-19/
      data (pmn(lat,14,19), lat = 1,72)/
     |   4.5908858350113d-21, 2.1530004856824d-14, 2.6411799016772d-11,
     |   2.7658264042113d-09, 8.6169974428751d-08, 1.2945502804855d-06,
     |   1.1898239495552d-05, 7.6560263215712d-05, 3.7498333169690d-04,
     |   1.4775160448357d-03, 4.8662986044873d-03, 1.3769520604031d-02,
     |   3.4151460116972d-02, 7.5357392847303d-02, 1.4956817063956d-01,
     |   2.6914631643963d-01, 4.4144731069119d-01, 6.6183109927182d-01,
     |   9.0715360222458d-01, 1.1332303465975d+00, 1.2797348579062d+00,
     |   1.2840984565225d+00, 1.1023856422965d+00, 7.3102438068901d-01,
     |   2.2059697254191d-01,-3.2651805910309d-01,-7.7828922247826d-01,
     |  -1.0111114634076d+00,-9.5236871867276d-01,-6.1179626378990d-01,
     |  -8.7703863759773d-02, 4.5788861813137d-01, 8.4948723851758d-01,
     |   9.5728508529298d-01, 7.4374401128124d-01, 2.7939992395798d-01,
     |  -2.7939992395798d-01,-7.4374401128124d-01,-9.5728508529298d-01,
     |  -8.4948723851758d-01,-4.5788861813138d-01, 8.7703863759775d-02,
     |   6.1179626378990d-01, 9.5236871867275d-01, 1.0111114634076d+00,
     |   7.7828922247826d-01, 3.2651805910309d-01,-2.2059697254191d-01,
     |  -7.3102438068900d-01,-1.1023856422965d+00,-1.2840984565225d+00,
     |  -1.2797348579062d+00,-1.1332303465975d+00,-9.0715360222459d-01,
     |  -6.6183109927182d-01,-4.4144731069120d-01,-2.6914631643963d-01,
     |  -1.4956817063956d-01,-7.5357392847303d-02,-3.4151460116972d-02,
     |  -1.3769520604031d-02,-4.8662986044873d-03,-1.4775160448357d-03,
     |  -3.7498333169691d-04,-7.6560263215712d-05,-1.1898239495552d-05,
     |  -1.2945502804856d-06,-8.6169974428751d-08,-2.7658264042113d-09,
     |  -2.6411799016772d-11,-2.1530004856824d-14,-4.5908858350113d-21/
      data (pmn(lat,15,19), lat = 1,72)/
     |   4.3539771673115d-23, 6.1368993376899d-16, 1.2593520834249d-12,
     |   1.8565849093563d-10, 7.4927989832283d-09, 1.3889456645923d-07,
     |   1.5263205892588d-06, 1.1490380262031d-05, 6.4828373998897d-05,
     |   2.9092927451799d-04, 1.0823320802850d-03, 3.4388453878309d-03,
     |   9.5388930414069d-03, 2.3485890802795d-02, 5.1976343486311d-02,
     |   1.0438739647078d-01, 1.9162037273064d-01, 3.2315322254886d-01,
     |   5.0229617623728d-01, 7.2058557739692d-01, 9.5330120903725d-01,
     |   1.1587302388094d+00, 1.2834648347794d+00, 1.2744156973318d+00,
     |   1.0956002965500d+00, 7.4499440330471d-01, 2.6507451629834d-01,
     |  -2.5875184071930d-01,-7.1444366337520d-01,-9.9189005400203d-01,
     |  -1.0160688651622d+00,-7.7397098219842d-01,-3.2503427198050d-01,
     |   2.1052659709885d-01, 6.8374567706420d-01, 9.6010005748116d-01,
     |   9.6010005748116d-01, 6.8374567706420d-01, 2.1052659709885d-01,
     |  -3.2503427198050d-01,-7.7397098219842d-01,-1.0160688651622d+00,
     |  -9.9189005400203d-01,-7.1444366337520d-01,-2.5875184071930d-01,
     |   2.6507451629834d-01, 7.4499440330471d-01, 1.0956002965500d+00,
     |   1.2744156973318d+00, 1.2834648347794d+00, 1.1587302388094d+00,
     |   9.5330120903725d-01, 7.2058557739692d-01, 5.0229617623728d-01,
     |   3.2315322254886d-01, 1.9162037273064d-01, 1.0438739647078d-01,
     |   5.1976343486311d-02, 2.3485890802795d-02, 9.5388930414070d-03,
     |   3.4388453878309d-03, 1.0823320802850d-03, 2.9092927451800d-04,
     |   6.4828373998898d-05, 1.1490380262032d-05, 1.5263205892588d-06,
     |   1.3889456645923d-07, 7.4927989832283d-09, 1.8565849093563d-10,
     |   1.2593520834249d-12, 6.1368993376899d-16, 4.3539771673115d-23/
      data (pmn(lat,16,19), lat = 1,72)/
     |   3.5129907352088d-25, 1.4879135815981d-17, 5.1057990123313d-14,
     |   1.0590902124752d-11, 5.5326484631698d-10, 1.2642383871741d-08,
     |   1.6590363423996d-07, 1.4590199910135d-06, 9.4650633257488d-06,
     |   4.8271817739937d-05, 2.0231295966399d-04, 7.1948315774247d-04,
     |   2.2234077138046d-03, 6.0794812393741d-03, 1.4914715012223d-02,
     |   3.3187634337242d-02, 6.7550306199695d-02, 1.2659447416120d-01,
     |   2.1952742817483d-01, 3.5349267415633d-01, 5.2969638561507d-01,
     |   7.3916256264809d-01, 9.5960194152568d-01, 1.1552110161269d+00,
     |   1.2808967329156d+00, 1.2913105185295d+00, 1.1533581190454d+00,
     |   8.5906447432306d-01, 4.3455639070241d-01,-5.8859942187159d-02,
     |  -5.3374834670629d-01,-8.9490926086646d-01,-1.0629323587045d+00,
     |  -9.9641811189154d-01,-7.0593906943823d-01,-2.5476715068937d-01,
     |   2.5476715068937d-01, 7.0593906943823d-01, 9.9641811189154d-01,
     |   1.0629323587045d+00, 8.9490926086646d-01, 5.3374834670629d-01,
     |   5.8859942187161d-02,-4.3455639070241d-01,-8.5906447432306d-01,
     |  -1.1533581190454d+00,-1.2913105185295d+00,-1.2808967329156d+00,
     |  -1.1552110161269d+00,-9.5960194152568d-01,-7.3916256264809d-01,
     |  -5.2969638561508d-01,-3.5349267415633d-01,-2.1952742817483d-01,
     |  -1.2659447416120d-01,-6.7550306199695d-02,-3.3187634337242d-02,
     |  -1.4914715012223d-02,-6.0794812393741d-03,-2.2234077138046d-03,
     |  -7.1948315774247d-04,-2.0231295966399d-04,-4.8271817739938d-05,
     |  -9.4650633257489d-06,-1.4590199910135d-06,-1.6590363423996d-07,
     |  -1.2642383871741d-08,-5.5326484631698d-10,-1.0590902124752d-11,
     |  -5.1057990123313d-14,-1.4879135815981d-17,-3.5129907352088d-25/
      data (pmn(lat,17,19), lat = 1,72)/
     |   2.3430349010626d-27, 2.9816239976911d-19, 1.7103956178791d-15,
     |   4.9896368376024d-13, 3.3718564458648d-11, 9.4900998631572d-10,
     |   1.4856945298607d-08, 1.5244786129634d-07, 1.1354722032567d-06,
     |   6.5694794609674d-06, 3.0953410539636d-05, 1.2290445665689d-04,
     |   4.2187906575975d-04, 1.2765181241293d-03, 3.4566883826989d-03,
     |   8.4775804482717d-03, 1.9010291706504d-02, 3.9274590849465d-02,
     |   7.5210352177087d-02, 1.3414431642353d-01, 2.2366832547271d-01,
     |   3.4958214119688d-01, 5.1305037141057d-01, 7.0753180550375d-01,
     |   9.1643297392761d-01, 1.1126339673189d+00, 1.2608624559965d+00,
     |   1.3232766147019d+00, 1.2676491099294d+00, 1.0764893910888d+00,
     |   7.5467883159956d-01, 3.3308063832459d-01,-1.3369244358836d-01,
     |  -5.7571456718692d-01,-9.2095239822264d-01,-1.1102394030370d+00,
     |  -1.1102394030370d+00,-9.2095239822264d-01,-5.7571456718692d-01,
     |  -1.3369244358836d-01, 3.3308063832459d-01, 7.5467883159956d-01,
     |   1.0764893910888d+00, 1.2676491099294d+00, 1.3232766147019d+00,
     |   1.2608624559965d+00, 1.1126339673189d+00, 9.1643297392762d-01,
     |   7.0753180550375d-01, 5.1305037141057d-01, 3.4958214119688d-01,
     |   2.2366832547271d-01, 1.3414431642353d-01, 7.5210352177087d-02,
     |   3.9274590849465d-02, 1.9010291706504d-02, 8.4775804482718d-03,
     |   3.4566883826989d-03, 1.2765181241293d-03, 4.2187906575975d-04,
     |   1.2290445665689d-04, 3.0953410539636d-05, 6.5694794609675d-06,
     |   1.1354722032567d-06, 1.5244786129634d-07, 1.4856945298607d-08,
     |   9.4900998631575d-10, 3.3718564458648d-11, 4.9896368376024d-13,
     |   1.7103956178791d-15, 2.9816239976911d-19, 2.3430349010626d-27/
      data (pmn(lat,18,19), lat = 1,72)/
     |   1.2216706824050d-29, 4.6703286729712d-21, 4.4775393377825d-17,
     |   1.8363198842155d-14, 1.6044337897547d-12, 5.5582527765221d-11,
     |   1.0372129886961d-09, 1.2405328836055d-08, 1.0595763570424d-07,
     |   6.9446336955593d-07, 3.6723210288614d-06, 1.6247924917465d-05,
     |   6.1804856630100d-05, 2.0637287567983d-04, 6.1482103543987d-04,
     |   1.6554549336935d-03, 4.0706961771777d-03, 9.2186597009884d-03,
     |   1.9360406370182d-02, 3.7920473411794d-02, 6.9593883116115d-02,
     |   1.2013277091423d-01, 1.9564945351095d-01, 3.0134683493392d-01,
     |   4.3974045723293d-01, 6.0864699265036d-01, 7.9942392450682d-01,
     |   9.9607261022115d-01, 1.1757820625296d+00, 1.3112505755330d+00,
     |   1.3746995330256d+00, 1.3429858406172d+00, 1.2027784099050d+00,
     |   9.5454967495164d-01, 6.1425392934610d-01, 2.1202994533727d-01,
     |  -2.1202994533727d-01,-6.1425392934610d-01,-9.5454967495164d-01,
     |  -1.2027784099050d+00,-1.3429858406172d+00,-1.3746995330256d+00,
     |  -1.3112505755330d+00,-1.1757820625296d+00,-9.9607261022115d-01,
     |  -7.9942392450681d-01,-6.0864699265036d-01,-4.3974045723293d-01,
     |  -3.0134683493392d-01,-1.9564945351095d-01,-1.2013277091423d-01,
     |  -6.9593883116116d-02,-3.7920473411795d-02,-1.9360406370183d-02,
     |  -9.2186597009884d-03,-4.0706961771777d-03,-1.6554549336935d-03,
     |  -6.1482103543987d-04,-2.0637287567983d-04,-6.1804856630101d-05,
     |  -1.6247924917465d-05,-3.6723210288614d-06,-6.9446336955594d-07,
     |  -1.0595763570424d-07,-1.2405328836055d-08,-1.0372129886961d-09,
     |  -5.5582527765223d-11,-1.6044337897547d-12,-1.8363198842155d-14,
     |  -4.4775393377825d-17,-4.6703286729712d-21,-1.2216706824050d-29/
      data (pmn(lat,19,19), lat = 1,72)/
     |   4.3243281690587d-32, 4.9657520335980d-23, 7.9548568568462d-19,
     |   4.5849721095876d-16, 5.1771623915966d-14, 2.2063667379144d-12,
     |   4.9042782737946d-11, 6.8312116998813d-10, 6.6842802873008d-09,
     |   4.9570193659294d-08, 2.9378109864609d-07, 1.4460282598034d-06,
     |   6.0839696441007d-06, 2.2369352043654d-05, 7.3130298247214d-05,
     |   2.1553436413704d-04, 5.7911501947469d-04, 1.4315954123398d-03,
     |   3.2807894358751d-03, 7.0144563125674d-03, 1.4066573269594d-02,
     |   2.6578426803011d-02, 4.7500070476417d-02, 8.0559841416440d-02,
     |   1.3002712200149d-01, 2.0021595031166d-01, 2.9472859401019d-01,
     |   4.1551337510684d-01, 5.6189319221470d-01, 7.2978500792133d-01,
     |   9.1134912397657d-01, 1.0952615691692d+00, 1.2676917556466d+00,
     |   1.4139106911525d+00, 1.5202911331458d+00, 1.5763371538136d+00,
     |   1.5763371538136d+00, 1.5202911331458d+00, 1.4139106911525d+00,
     |   1.2676917556466d+00, 1.0952615691692d+00, 9.1134912397657d-01,
     |   7.2978500792133d-01, 5.6189319221470d-01, 4.1551337510684d-01,
     |   2.9472859401019d-01, 2.0021595031166d-01, 1.3002712200149d-01,
     |   8.0559841416440d-02, 4.7500070476417d-02, 2.6578426803011d-02,
     |   1.4066573269594d-02, 7.0144563125674d-03, 3.2807894358751d-03,
     |   1.4315954123398d-03, 5.7911501947469d-04, 2.1553436413704d-04,
     |   7.3130298247213d-05, 2.2369352043653d-05, 6.0839696441008d-06,
     |   1.4460282598034d-06, 2.9378109864609d-07, 4.9570193659295d-08,
     |   6.6842802873009d-09, 6.8312116998814d-10, 4.9042782737946d-11,
     |   2.2063667379144d-12, 5.1771623915966d-14, 4.5849721095876d-16,
     |   7.9548568568462d-19, 4.9657520335980d-23, 4.3243281690587d-32/
      data (pmn(lat, 0,20), lat = 1,72)/
     |   4.3042223297031d+00, 2.7087535299135d+00, 4.0884311078778d-01,
     |  -1.3664131790450d+00,-1.7957332810195d+00,-9.2524618392833d-01,
     |   4.3877977988316d-01, 1.3062790910369d+00, 1.1495529472358d+00,
     |   1.9461964288617d-01,-8.0870674037752d-01,-1.1472830105664d+00,
     |  -6.3422431729849d-01, 3.0127140150287d-01, 9.5925635887795d-01,
     |   8.8223082277797d-01, 1.6672417688556d-01,-6.3571800180829d-01,
     |  -9.3739634132453d-01,-5.3983160427515d-01, 2.3903669748425d-01,
     |   8.1534954189029d-01, 7.7320196804900d-01, 1.6220723017679d-01,
     |  -5.5255952329360d-01,-8.4198175287429d-01,-5.0214375547606d-01,
     |   2.0325610834051d-01, 7.4602750636093d-01, 7.2690107772885d-01,
     |   1.6774471974717d-01,-5.1027334649717d-01,-8.0240669687312d-01,
     |  -4.9441321465870d-01, 1.8103743552264d-01, 7.1934062520833d-01,
     |   7.1934062520833d-01, 1.8103743552265d-01,-4.9441321465870d-01,
     |  -8.0240669687312d-01,-5.1027334649717d-01, 1.6774471974717d-01,
     |   7.2690107772884d-01, 7.4602750636093d-01, 2.0325610834051d-01,
     |  -5.0214375547606d-01,-8.4198175287429d-01,-5.5255952329360d-01,
     |   1.6220723017679d-01, 7.7320196804900d-01, 8.1534954189029d-01,
     |   2.3903669748426d-01,-5.3983160427515d-01,-9.3739634132453d-01,
     |  -6.3571800180830d-01, 1.6672417688556d-01, 8.8223082277797d-01,
     |   9.5925635887795d-01, 3.0127140150286d-01,-6.3422431729848d-01,
     |  -1.1472830105664d+00,-8.0870674037752d-01, 1.9461964288617d-01,
     |   1.1495529472358d+00, 1.3062790910369d+00, 4.3877977988316d-01,
     |  -9.2524618392832d-01,-1.7957332810195d+00,-1.3664131790450d+00,
     |   4.0884311078778d-01, 2.7087535299135d+00, 4.3042223297031d+00/
      data (pmn(lat, 1,20), lat = 1,72)/
     |   9.8713919417183d-01, 2.4038239911516d+00, 2.4957297990193d+00,
     |   1.3123280948762d+00,-3.4121453855227d-01,-1.4434950116365d+00,
     |  -1.4094337081174d+00,-4.2653648384965d-01, 7.3007548943613d-01,
     |   1.2543146219637d+00, 8.4669275462898d-01,-1.2603807993005d-01,
     |  -9.3422185475231d-01,-1.0169648442184d+00,-3.6297871574261d-01,
     |   5.1513525053766d-01, 9.7360716348964d-01, 7.0274639464111d-01,
     |  -6.7613135804744d-02,-7.5705813059160d-01,-8.6707830192754d-01,
     |  -3.3819954515363d-01, 4.2214244539574d-01, 8.5037281187582d-01,
     |   6.4153613013860d-01,-3.5173025727266d-02,-6.7149929703718d-01,
     |  -7.9953214143567d-01,-3.3392015224527d-01, 3.7215251073633d-01,
     |   7.9335554233072d-01, 6.2121100426451d-01,-1.1017261731606d-02,
     |  -6.3081456877179d-01,-7.7800516168769d-01,-3.4497645771993d-01,
     |   3.4497645771993d-01, 7.7800516168769d-01, 6.3081456877179d-01,
     |   1.1017261731608d-02,-6.2121100426451d-01,-7.9335554233072d-01,
     |  -3.7215251073633d-01, 3.3392015224526d-01, 7.9953214143567d-01,
     |   6.7149929703718d-01, 3.5173025727270d-02,-6.4153613013860d-01,
     |  -8.5037281187582d-01,-4.2214244539574d-01, 3.3819954515363d-01,
     |   8.6707830192753d-01, 7.5705813059160d-01, 6.7613135804749d-02,
     |  -7.0274639464111d-01,-9.7360716348964d-01,-5.1513525053767d-01,
     |   3.6297871574262d-01, 1.0169648442184d+00, 9.3422185475231d-01,
     |   1.2603807993005d-01,-8.4669275462898d-01,-1.2543146219637d+00,
     |  -7.3007548943614d-01, 4.2653648384964d-01, 1.4094337081174d+00,
     |   1.4434950116365d+00, 3.4121453855227d-01,-1.3123280948762d+00,
     |  -2.4957297990193d+00,-2.4038239911516d+00,-9.8713919417183d-01/
      data (pmn(lat, 2,20), lat = 1,72)/
     |   1.1100922560071d-01, 8.7246581112122d-01, 1.8194088485688d+00,
     |   2.2037513223597d+00, 1.6322181243502d+00, 3.5039045375619d-01,
     |  -9.1285700617272d-01,-1.4323187971793d+00,-9.6864788981551d-01,
     |   8.3774702965497d-02, 9.7859404070233d-01, 1.1275508153593d+00,
     |   4.8513608891435d-01,-4.5087774770562d-01,-1.0099749371538d+00,
     |  -8.2155155244122d-01,-5.8520598943023d-02, 7.0904890221186d-01,
     |   9.3330458515450d-01, 4.7617453749994d-01,-3.0768341894098d-01,
     |  -8.4155582835227d-01,-7.4745687291638d-01,-1.1211620486340d-01,
     |   5.8830959119511d-01, 8.4229687544169d-01, 4.7444011932733d-01,
     |  -2.3415707756018d-01,-7.5889845126294d-01,-7.1802686719062d-01,
     |  -1.4915484629538d-01, 5.2358031457135d-01, 8.0415815875221d-01,
     |   4.8883645214318d-01,-1.8645833582667d-01,-7.2179583781717d-01,
     |  -7.2179583781717d-01,-1.8645833582667d-01, 4.8883645214318d-01,
     |   8.0415815875220d-01, 5.2358031457135d-01,-1.4915484629538d-01,
     |  -7.1802686719062d-01,-7.5889845126295d-01,-2.3415707756019d-01,
     |   4.7444011932733d-01, 8.4229687544169d-01, 5.8830959119512d-01,
     |  -1.1211620486340d-01,-7.4745687291638d-01,-8.4155582835227d-01,
     |  -3.0768341894099d-01, 4.7617453749994d-01, 9.3330458515450d-01,
     |   7.0904890221187d-01,-5.8520598943018d-02,-8.2155155244122d-01,
     |  -1.0099749371538d+00,-4.5087774770561d-01, 4.8513608891434d-01,
     |   1.1275508153593d+00, 9.7859404070233d-01, 8.3774702965503d-02,
     |  -9.6864788981551d-01,-1.4323187971793d+00,-9.1285700617272d-01,
     |   3.5039045375617d-01, 1.6322181243502d+00, 2.2037513223597d+00,
     |   1.8194088485688d+00, 8.7246581112122d-01, 1.1100922560071d-01/
      data (pmn(lat, 3,20), lat = 1,72)/
     |   8.2476391419572d-03, 2.0144140788692d-01, 7.5816119114715d-01,
     |   1.4961130755973d+00, 1.9560144456606d+00, 1.7319532623260d+00,
     |   8.0053404723712d-01,-4.0091145948509d-01,-1.2232730429360d+00,
     |  -1.2229304241169d+00,-4.6066296022584d-01, 5.3068633913686d-01,
     |   1.0958932561720d+00, 8.8921017127513d-01, 9.3939660513776d-02,
     |  -7.1885292086569d-01,-9.9141766663265d-01,-5.6052297783447d-01,
     |   2.4358064407064d-01, 8.4280109909978d-01, 8.2271085797239d-01,
     |   2.1852318179895d-01,-5.2236038712090d-01,-8.6784572995225d-01,
     |  -5.8117718739424d-01, 1.1700077612077d-01, 7.1577516836044d-01,
     |   7.8548416544776d-01, 2.8488579441986d-01,-4.1508936031423d-01,
     |  -8.0435407191458d-01,-6.0373070502643d-01, 3.5402561499310d-02,
     |   6.4437931869567d-01, 7.7935206377001d-01, 3.4354279395106d-01,
     |  -3.4354279395106d-01,-7.7935206377001d-01,-6.4437931869567d-01,
     |  -3.5402561499312d-02, 6.0373070502643d-01, 8.0435407191458d-01,
     |   4.1508936031423d-01,-2.8488579441985d-01,-7.8548416544776d-01,
     |  -7.1577516836044d-01,-1.1700077612077d-01, 5.8117718739423d-01,
     |   8.6784572995225d-01, 5.2236038712090d-01,-2.1852318179895d-01,
     |  -8.2271085797238d-01,-8.4280109909978d-01,-2.4358064407065d-01,
     |   5.6052297783447d-01, 9.9141766663265d-01, 7.1885292086570d-01,
     |  -9.3939660513781d-02,-8.8921017127514d-01,-1.0958932561720d+00,
     |  -5.3068633913686d-01, 4.6066296022584d-01, 1.2229304241169d+00,
     |   1.2232730429360d+00, 4.0091145948509d-01,-8.0053404723712d-01,
     |  -1.7319532623260d+00,-1.9560144456606d+00,-1.4961130755973d+00,
     |  -7.5816119114715d-01,-2.0144140788692d-01,-8.2476391419572d-03/
      data (pmn(lat, 4,20), lat = 1,72)/
     |   4.5547311743609d-04, 3.4078835936500d-02, 2.2361635465925d-01,
     |   6.6749362900861d-01, 1.2768232901062d+00, 1.7494947483608d+00,
     |   1.7353791050393d+00, 1.0919888576650d+00, 4.1349571843265d-02,
     |  -9.0996974592599d-01,-1.2632418974001d+00,-8.4847645630222d-01,
     |   4.7764620017720d-02, 8.4948655924183d-01, 1.0554306974922d+00,
     |   5.6151604415574d-01,-2.7685778119672d-01,-8.8817177898177d-01,
     |  -8.7087796314530d-01,-2.6011265895487d-01, 5.0607446239467d-01,
     |   8.9531591142941d-01, 6.4925544613535d-01,-4.3492379659795d-02,
     |  -6.8733060501874d-01,-8.3132865303642d-01,-3.8436223933449d-01,
     |   3.2660710900458d-01, 7.9318409345099d-01, 6.8734856030742d-01,
     |   9.1782074199314d-02,-5.6308801720822d-01,-8.0843091920009d-01,
     |  -4.7145500494826d-01, 2.0299779583937d-01, 7.2931047264479d-01,
     |   7.2931047264479d-01, 2.0299779583937d-01,-4.7145500494826d-01,
     |  -8.0843091920009d-01,-5.6308801720822d-01, 9.1782074199316d-02,
     |   6.8734856030742d-01, 7.9318409345099d-01, 3.2660710900458d-01,
     |  -3.8436223933448d-01,-8.3132865303642d-01,-6.8733060501874d-01,
     |  -4.3492379659798d-02, 6.4925544613535d-01, 8.9531591142941d-01,
     |   5.0607446239468d-01,-2.6011265895487d-01,-8.7087796314530d-01,
     |  -8.8817177898177d-01,-2.7685778119673d-01, 5.6151604415574d-01,
     |   1.0554306974922d+00, 8.4948655924183d-01, 4.7764620017731d-02,
     |  -8.4847645630222d-01,-1.2632418974001d+00,-9.0996974592599d-01,
     |   4.1349571843256d-02, 1.0919888576650d+00, 1.7353791050393d+00,
     |   1.7494947483608d+00, 1.2768232901062d+00, 6.6749362900861d-01,
     |   2.2361635465925d-01, 3.4078835936500d-02, 4.5547311743609d-04/
      data (pmn(lat, 5,20), lat = 1,72)/
     |   1.9907755404561d-05, 4.5311751691844d-03, 5.1025274136565d-02,
     |   2.2371015825232d-01, 5.9213190498107d-01, 1.1106509182219d+00,
     |   1.5730266380787d+00, 1.6916589027730d+00, 1.2779773128486d+00,
     |   4.0787376088024d-01,-5.5939368147414d-01,-1.1545942737029d+00,
     |  -1.0753124721946d+00,-3.8951965965622d-01, 4.8089593209460d-01,
     |   1.0058596588101d+00, 8.7500444423437d-01, 1.9498192051320d-01,
     |  -5.7947810482036d-01,-9.4243245809348d-01,-6.6843015835930d-01,
     |   4.1891519346667d-02, 7.0108557879738d-01, 8.6592449399743d-01,
     |   4.3612719440044d-01,-2.8215136073186d-01,-7.9054685795506d-01,
     |  -7.4249589744893d-01,-1.8002066132741d-01, 4.9935723856366d-01,
     |   8.2134136441846d-01, 5.6493605546712d-01,-8.5526602239225d-02,
     |  -6.7144429931414d-01,-7.8178493028352d-01,-3.4059576995525d-01,
     |   3.4059576995524d-01, 7.8178493028352d-01, 6.7144429931415d-01,
     |   8.5526602239226d-02,-5.6493605546712d-01,-8.2134136441846d-01,
     |  -4.9935723856367d-01, 1.8002066132740d-01, 7.4249589744893d-01,
     |   7.9054685795506d-01, 2.8215136073186d-01,-4.3612719440044d-01,
     |  -8.6592449399743d-01,-7.0108557879738d-01,-4.1891519346667d-02,
     |   6.6843015835930d-01, 9.4243245809348d-01, 5.7947810482037d-01,
     |  -1.9498192051320d-01,-8.7500444423437d-01,-1.0058596588101d+00,
     |  -4.8089593209459d-01, 3.8951965965622d-01, 1.0753124721946d+00,
     |   1.1545942737029d+00, 5.5939368147414d-01,-4.0787376088023d-01,
     |  -1.2779773128486d+00,-1.6916589027730d+00,-1.5730266380787d+00,
     |  -1.1106509182219d+00,-5.9213190498107d-01,-2.2371015825232d-01,
     |  -5.1025274136565d-02,-4.5311751691844d-03,-1.9907755404561d-05/
      data (pmn(lat, 6,20), lat = 1,72)/
     |   7.1564146744370d-07, 4.9355948851357d-04, 9.4568300446898d-03,
     |   5.9995175784368d-02, 2.1429642494544d-01, 5.2655670867228d-01,
     |   9.7529418761145d-01, 1.4175762133432d+00, 1.6222130400015d+00,
     |   1.3909484667493d+00, 7.0494033807169d-01,-2.0639352179299d-01,
     |  -9.4569062839864d-01,-1.1555004179573d+00,-7.3676895245128d-01,
     |   6.5951143258021d-02, 7.8561580620069d-01, 1.0026242930628d+00,
     |   6.0107414288954d-01,-1.5508369890716d-01,-7.8417464684888d-01,
     |  -8.9116795102675d-01,-4.2031746519358d-01, 3.1012137375408d-01,
     |   8.1724460672413d-01, 7.7146213912085d-01, 2.1311861197750d-01,
     |  -4.7697749628426d-01,-8.3423239045920d-01,-6.2240316159686d-01,
     |   8.8193419521928d-03, 6.2716356523761d-01, 8.1206406661802d-01,
     |   4.4022509277369d-01,-2.3153069329483d-01,-7.4236467792351d-01,
     |  -7.4236467792351d-01,-2.3153069329483d-01, 4.4022509277368d-01,
     |   8.1206406661802d-01, 6.2716356523762d-01, 8.8193419521910d-03,
     |  -6.2240316159686d-01,-8.3423239045920d-01,-4.7697749628427d-01,
     |   2.1311861197750d-01, 7.7146213912085d-01, 8.1724460672413d-01,
     |   3.1012137375408d-01,-4.2031746519358d-01,-8.9116795102675d-01,
     |  -7.8417464684888d-01,-1.5508369890716d-01, 6.0107414288953d-01,
     |   1.0026242930628d+00, 7.8561580620070d-01, 6.5951143258024d-02,
     |  -7.3676895245129d-01,-1.1555004179573d+00,-9.4569062839865d-01,
     |  -2.0639352179299d-01, 7.0494033807169d-01, 1.3909484667493d+00,
     |   1.6222130400015d+00, 1.4175762133432d+00, 9.7529418761145d-01,
     |   5.2655670867228d-01, 2.1429642494544d-01, 5.9995175784368d-02,
     |   9.4568300446898d-03, 4.9355948851357d-04, 7.1564146744370d-07/
      data (pmn(lat, 7,20), lat = 1,72)/
     |   2.1702311123421d-08, 4.5242349475726d-05, 1.4673199329098d-03,
     |   1.3353275802223d-02, 6.3491836862975d-02, 2.0001405635817d-01,
     |   4.6744688835950d-01, 8.5921000725528d-01, 1.2766101061163d+00,
     |   1.5368196468692d+00, 1.4504962997906d+00, 9.4057877217426d-01,
     |   1.3035139328406d-01,-6.7171057003776d-01,-1.1086616732369d+00,
     |  -9.7098240612119d-01,-3.3587084546359d-01, 4.4838884977523d-01,
     |   9.4375094109717d-01, 8.7333087077303d-01, 2.9050370906154d-01,
     |  -4.4585787029388d-01,-8.8546960098012d-01,-7.6341085211651d-01,
     |  -1.6626458832939d-01, 5.2140949568715d-01, 8.6087601769151d-01,
     |   6.3970477164732d-01, 8.0710091850795d-03,-6.1919275395923d-01,
     |  -8.3294467443933d-01,-4.9683549813614d-01, 1.6401820830136d-01,
     |   7.1177626996301d-01, 7.8473084849605d-01, 3.3596190944239d-01,
     |  -3.3596190944239d-01,-7.8473084849605d-01,-7.1177626996301d-01,
     |  -1.6401820830137d-01, 4.9683549813614d-01, 8.3294467443933d-01,
     |   6.1919275395923d-01,-8.0710091850739d-03,-6.3970477164732d-01,
     |  -8.6087601769151d-01,-5.2140949568715d-01, 1.6626458832939d-01,
     |   7.6341085211651d-01, 8.8546960098012d-01, 4.4585787029388d-01,
     |  -2.9050370906153d-01,-8.7333087077303d-01,-9.4375094109717d-01,
     |  -4.4838884977523d-01, 3.3587084546358d-01, 9.7098240612119d-01,
     |   1.1086616732369d+00, 6.7171057003776d-01,-1.3035139328405d-01,
     |  -9.4057877217426d-01,-1.4504962997906d+00,-1.5368196468692d+00,
     |  -1.2766101061163d+00,-8.5921000725528d-01,-4.6744688835950d-01,
     |  -2.0001405635817d-01,-6.3491836862975d-02,-1.3353275802223d-02,
     |  -1.4673199329098d-03,-4.5242349475726d-05,-2.1702311123421d-08/
      data (pmn(lat, 8,20), lat = 1,72)/
     |   5.6499293756042d-10, 3.5544670619290d-06, 1.9446979814150d-04,
     |   2.5246489178401d-03, 1.5846480362332d-02, 6.3213005864336d-02,
     |   1.8294879158866d-01, 4.1277700173060d-01, 7.5579963350832d-01,
     |   1.1454874478041d+00, 1.4399665488515d+00, 1.4683865920236d+00,
     |   1.1213346442396d+00, 4.3983374438957d-01,-3.5871818160493d-01,
     |  -9.5497191057311d-01,-1.0816171051004d+00,-6.7801704345882d-01,
     |   5.0423170261894d-02, 7.2004800463789d-01, 9.7020082021190d-01,
     |   6.6825296532640d-01,-5.8295485532809d-03,-6.5596086655359d-01,
     |  -8.9974672382012d-01,-5.9747562106098d-01, 6.0780802469172d-02,
     |   6.6860909601230d-01, 8.5213437755599d-01, 5.0182471141779d-01,
     |  -1.5855052986145d-01,-7.1162960160723d-01,-8.0900871255209d-01,
     |  -3.9140982473425d-01, 2.7368341891079d-01, 7.6188550231695d-01,
     |   7.6188550231695d-01, 2.7368341891079d-01,-3.9140982473424d-01,
     |  -8.0900871255209d-01,-7.1162960160723d-01,-1.5855052986145d-01,
     |   5.0182471141779d-01, 8.5213437755599d-01, 6.6860909601230d-01,
     |   6.0780802469174d-02,-5.9747562106098d-01,-8.9974672382012d-01,
     |  -6.5596086655359d-01,-5.8295485532809d-03, 6.6825296532640d-01,
     |   9.7020082021191d-01, 7.2004800463789d-01, 5.0423170261899d-02,
     |  -6.7801704345882d-01,-1.0816171051004d+00,-9.5497191057311d-01,
     |  -3.5871818160493d-01, 4.3983374438957d-01, 1.1213346442396d+00,
     |   1.4683865920236d+00, 1.4399665488515d+00, 1.1454874478041d+00,
     |   7.5579963350832d-01, 4.1277700173060d-01, 1.8294879158866d-01,
     |   6.3213005864337d-02, 1.5846480362332d-02, 2.5246489178401d-03,
     |   1.9446979814150d-04, 3.5544670619290d-06, 5.6499293756042d-10/
      data (pmn(lat, 9,20), lat = 1,72)/
     |   1.2782213742800d-11, 2.4240402376995d-07, 2.2320134879054d-05,
     |   4.1181200731035d-04, 3.3934045757350d-03, 1.7006853853285d-02,
     |   6.0273291586816d-02, 1.6421264653805d-01, 3.6132336810544d-01,
     |   6.6108828048515d-01, 1.0209570748822d+00, 1.3336622143141d+00,
     |   1.4516130742370d+00, 1.2515597482372d+00, 7.1425416716309d-01,
     |  -2.7486918891120d-02,-7.1432497160594d-01,-1.0660533581287d+00,
     |  -9.2380213838674d-01,-3.5158047050263d-01, 3.7074928220032d-01,
     |   8.7624612794345d-01, 9.0225562336255d-01, 4.3936252200025d-01,
     |  -2.5332738677722d-01,-7.8597304720600d-01,-8.5750565271685d-01,
     |  -4.3123922682711d-01, 2.3984150481961d-01, 7.5872020311693d-01,
     |   8.1860179472616d-01, 3.8672097839277d-01,-2.7454451829314d-01,
     |  -7.6472110812395d-01,-7.8718253817079d-01,-3.2933979975700d-01,
     |   3.2933979975699d-01, 7.8718253817079d-01, 7.6472110812395d-01,
     |   2.7454451829315d-01,-3.8672097839277d-01,-8.1860179472616d-01,
     |  -7.5872020311694d-01,-2.3984150481962d-01, 4.3123922682711d-01,
     |   8.5750565271685d-01, 7.8597304720600d-01, 2.5332738677722d-01,
     |  -4.3936252200025d-01,-9.0225562336255d-01,-8.7624612794345d-01,
     |  -3.7074928220033d-01, 3.5158047050262d-01, 9.2380213838674d-01,
     |   1.0660533581287d+00, 7.1432497160595d-01, 2.7486918891122d-02,
     |  -7.1425416716309d-01,-1.2515597482372d+00,-1.4516130742370d+00,
     |  -1.3336622143141d+00,-1.0209570748822d+00,-6.6108828048515d-01,
     |  -3.6132336810544d-01,-1.6421264653805d-01,-6.0273291586816d-02,
     |  -1.7006853853285d-02,-3.3934045757350d-03,-4.1181200731035d-04,
     |  -2.2320134879054d-05,-2.4240402376995d-07,-1.2782213742800d-11/
      data (pmn(lat,10,20), lat = 1,72)/
     |   2.5341661484385d-13, 1.4474905973019d-08, 2.2393326580648d-06,
     |   5.8561664666965d-05, 6.3107711261143d-04, 3.9524390386095d-03,
     |   1.7027718301026d-02, 5.5451818712028d-02, 1.4451732902129d-01,
     |   3.1240298500228d-01, 5.7267197109692d-01, 9.0084252797663d-01,
     |   1.2188269478548d+00, 1.4043153642520d+00, 1.3335950296252d+00,
     |   9.4673559460039d-01, 3.0363138902849d-01,-4.0718075009078d-01,
     |  -9.2805184034077d-01,-1.0449369139935d+00,-7.0146926313696d-01,
     |  -4.9613448371406d-02, 6.0334860033281d-01, 9.3779005270529d-01,
     |   7.8624856876257d-01, 2.2949484802879d-01,-4.3628213056043d-01,
     |  -8.5277001897431d-01,-7.9439416900729d-01,-2.9620200903270d-01,
     |   3.6129845154130d-01, 8.0700107897383d-01, 7.8890912034176d-01,
     |   3.1895719130746d-01,-3.3217188915904d-01,-7.8950891686365d-01,
     |  -7.8950891686365d-01,-3.3217188915904d-01, 3.1895719130746d-01,
     |   7.8890912034176d-01, 8.0700107897383d-01, 3.6129845154130d-01,
     |  -2.9620200903270d-01,-7.9439416900728d-01,-8.5277001897431d-01,
     |  -4.3628213056043d-01, 2.2949484802878d-01, 7.8624856876257d-01,
     |   9.3779005270529d-01, 6.0334860033281d-01,-4.9613448371406d-02,
     |  -7.0146926313695d-01,-1.0449369139935d+00,-9.2805184034078d-01,
     |  -4.0718075009078d-01, 3.0363138902848d-01, 9.4673559460039d-01,
     |   1.3335950296252d+00, 1.4043153642520d+00, 1.2188269478548d+00,
     |   9.0084252797663d-01, 5.7267197109692d-01, 3.1240298500228d-01,
     |   1.4451732902129d-01, 5.5451818712028d-02, 1.7027718301026d-02,
     |   3.9524390386096d-03, 6.3107711261143d-04, 5.8561664666965d-05,
     |   2.2393326580648d-06, 1.4474905973019d-08, 2.5341661484385d-13/
      data (pmn(lat,11,20), lat = 1,72)/
     |   4.4265193398617d-15, 7.6106896308274d-10, 1.9757263247502d-07,
     |   7.3090030493397d-06, 1.0271717133498d-04, 8.0087509306700d-04,
     |   4.1728373525538d-03, 1.6132668539754d-02, 4.9341625338585d-02,
     |   1.2441379065941d-01, 2.6573067418004d-01, 4.8919716026898d-01,
     |   7.8386865802899d-01, 1.0960764570263d+00, 1.3290767683404d+00,
     |   1.3683045000778d+00, 1.1302930300374d+00, 6.1674349406856d-01,
     |  -5.6036706815801d-02,-6.7819897574042d-01,-1.0220341021741d+00,
     |  -9.4539309613449d-01,-4.7296422127707d-01, 1.9310037281530d-01,
     |   7.5135303179696d-01, 9.3948816927776d-01, 6.6667298314230d-01,
     |   6.8233067080943d-02,-5.5377113627583d-01,-8.8088251958603d-01,
     |  -7.4416953457798d-01,-2.1665957969843d-01, 4.2119160154852d-01,
     |   8.2868350308163d-01, 7.8744767633025d-01, 3.2022890312485d-01,
     |  -3.2022890312484d-01,-7.8744767633025d-01,-8.2868350308163d-01,
     |  -4.2119160154853d-01, 2.1665957969843d-01, 7.4416953457799d-01,
     |   8.8088251958604d-01, 5.5377113627583d-01,-6.8233067080940d-02,
     |  -6.6667298314230d-01,-9.3948816927776d-01,-7.5135303179696d-01,
     |  -1.9310037281530d-01, 4.7296422127707d-01, 9.4539309613449d-01,
     |   1.0220341021741d+00, 6.7819897574042d-01, 5.6036706815806d-02,
     |  -6.1674349406856d-01,-1.1302930300374d+00,-1.3683045000778d+00,
     |  -1.3290767683404d+00,-1.0960764570263d+00,-7.8386865802899d-01,
     |  -4.8919716026898d-01,-2.6573067418004d-01,-1.2441379065941d-01,
     |  -4.9341625338585d-02,-1.6132668539755d-02,-4.1728373525538d-03,
     |  -8.0087509306702d-04,-1.0271717133498d-04,-7.3090030493397d-06,
     |  -1.9757263247502d-07,-7.6106896308274d-10,-4.4265193398617d-15/
      data (pmn(lat,12,20), lat = 1,72)/
     |   6.8311081847040d-17, 3.5336990891091d-11, 1.5378525878566d-08,
     |   8.0358633570773d-07, 1.4696676812784d-05, 1.4225042625769d-04,
     |   8.9307131839889d-04, 4.0792271919405d-03, 1.4549252002181d-02,
     |   4.2433389995169d-02, 1.0440057631469d-01, 2.2133511706106d-01,
     |   4.1008655791511d-01, 6.6958015806441d-01, 9.6623433840317d-01,
     |   1.2279018492879d+00, 1.3558045268615d+00, 1.2576393434441d+00,
     |   8.9330463157515d-01, 3.1308290116927d-01,-3.3559753891504d-01,
     |  -8.4715310062785d-01,-1.0356515297549d+00,-8.2104653213913d-01,
     |  -2.8135743515357d-01, 3.6251129606128d-01, 8.3291807782988d-01,
     |   9.1913994423816d-01, 5.8048713183582d-01,-2.5538926702142d-02,
     |  -6.1090799449373d-01,-8.9312525267355d-01,-7.3444656220587d-01,
     |  -2.1326326199779d-01, 4.1153347519228d-01, 8.2816712372329d-01,
     |   8.2816712372329d-01, 4.1153347519228d-01,-2.1326326199779d-01,
     |  -7.3444656220587d-01,-8.9312525267355d-01,-6.1090799449373d-01,
     |  -2.5538926702145d-02, 5.8048713183582d-01, 9.1913994423816d-01,
     |   8.3291807782988d-01, 3.6251129606128d-01,-2.8135743515357d-01,
     |  -8.2104653213912d-01,-1.0356515297549d+00,-8.4715310062785d-01,
     |  -3.3559753891505d-01, 3.1308290116926d-01, 8.9330463157515d-01,
     |   1.2576393434441d+00, 1.3558045268615d+00, 1.2279018492879d+00,
     |   9.6623433840317d-01, 6.6958015806441d-01, 4.1008655791511d-01,
     |   2.2133511706106d-01, 1.0440057631469d-01, 4.2433389995170d-02,
     |   1.4549252002181d-02, 4.0792271919405d-03, 8.9307131839889d-04,
     |   1.4225042625769d-04, 1.4696676812784d-05, 8.0358633570773d-07,
     |   1.5378525878566d-08, 3.5336990891091d-11, 6.8311081847040d-17/
      data (pmn(lat,13,20), lat = 1,72)/
     |   9.3163046674986d-19, 1.4494344873896d-12, 1.0566703513892d-09,
     |   7.7900130956634d-08, 1.8510626654955d-06, 2.2193841099070d-05,
     |   1.6742505488902d-04, 9.0028596020459d-04, 3.7275179545056d-03,
     |   1.2501240097117d-02, 3.5160047282929d-02, 8.4971556216544d-02,
     |   1.7950120213552d-01, 3.3538161641458d-01, 5.5831075299496d-01,
     |   8.3071484004368d-01, 1.1030389460291d+00, 1.2963656448768d+00,
     |   1.3216733421631d+00, 1.1139170828150d+00, 6.6963013321216d-01,
     |   6.9919191368700d-02,-5.2815706068009d-01,-9.3761129781157d-01,
     |  -1.0127644864009d+00,-7.1720143645771d-01,-1.5497158881757d-01,
     |   4.5669785800161d-01, 8.6945549809392d-01, 9.0905638906633d-01,
     |   5.5645097220924d-01,-3.6118293603498d-02,-6.0689458359220d-01,
     |  -9.0003097460273d-01,-7.8262002665847d-01,-3.0777603102740d-01,
     |   3.0777603102740d-01, 7.8262002665846d-01, 9.0003097460273d-01,
     |   6.0689458359220d-01, 3.6118293603501d-02,-5.5645097220924d-01,
     |  -9.0905638906633d-01,-8.6945549809392d-01,-4.5669785800161d-01,
     |   1.5497158881757d-01, 7.1720143645771d-01, 1.0127644864009d+00,
     |   9.3761129781157d-01, 5.2815706068009d-01,-6.9919191368700d-02,
     |  -6.6963013321215d-01,-1.1139170828150d+00,-1.3216733421631d+00,
     |  -1.2963656448768d+00,-1.1030389460291d+00,-8.3071484004368d-01,
     |  -5.5831075299495d-01,-3.3538161641458d-01,-1.7950120213552d-01,
     |  -8.4971556216544d-02,-3.5160047282929d-02,-1.2501240097117d-02,
     |  -3.7275179545056d-03,-9.0028596020459d-04,-1.6742505488902d-04,
     |  -2.2193841099071d-05,-1.8510626654955d-06,-7.7900130956634d-08,
     |  -1.0566703513892d-09,-1.4494344873896d-12,-9.3163046674986d-19/
      data (pmn(lat,14,20), lat = 1,72)/
     |   1.1201653185758d-20, 5.2399298617625d-14, 6.3953141125228d-11,
     |   6.6456903833216d-09, 2.0491001599680d-07, 3.0382250818529d-06,
     |   2.7480693492734d-05, 1.7349062925137d-04, 8.3101956444271d-04,
     |   3.1911706134371d-03, 1.0204477492326d-02, 2.7916843681111d-02,
     |   6.6629611817852d-02, 1.4071826872523d-01, 2.6563289962430d-01,
     |   4.5116513168194d-01, 6.9182331045210d-01, 9.5772171839813d-01,
     |   1.1914904316963d+00, 1.3166223687028d+00, 1.2592086312163d+00,
     |   9.7862863928120d-01, 4.9599645993777d-01,-9.4147827757902d-02,
     |  -6.4007816565432d-01,-9.7787438058025d-01,-9.9215580747294d-01,
     |  -6.6872936878479d-01,-1.1396392729403d-01, 4.7345244473591d-01,
     |   8.7289122004924d-01, 9.2853718123273d-01, 6.1609714827353d-01,
     |   5.8488256156599d-02,-5.1987972734433d-01,-8.8354906902122d-01,
     |  -8.8354906902122d-01,-5.1987972734433d-01, 5.8488256156597d-02,
     |   6.1609714827353d-01, 9.2853718123273d-01, 8.7289122004924d-01,
     |   4.7345244473591d-01,-1.1396392729402d-01,-6.6872936878479d-01,
     |  -9.9215580747294d-01,-9.7787438058025d-01,-6.4007816565432d-01,
     |  -9.4147827757904d-02, 4.9599645993777d-01, 9.7862863928120d-01,
     |   1.2592086312163d+00, 1.3166223687028d+00, 1.1914904316963d+00,
     |   9.5772171839814d-01, 6.9182331045210d-01, 4.5116513168194d-01,
     |   2.6563289962430d-01, 1.4071826872523d-01, 6.6629611817853d-02,
     |   2.7916843681111d-02, 1.0204477492326d-02, 3.1911706134372d-03,
     |   8.3101956444272d-04, 1.7349062925137d-04, 2.7480693492734d-05,
     |   3.0382250818530d-06, 2.0491001599680d-07, 6.6456903833216d-09,
     |   6.3953141125228d-11, 5.2399298617625d-14, 1.1201653185758d-20/
      data (pmn(lat,15,20), lat = 1,72)/
     |   1.1807707346904d-22, 1.6603261744964d-15, 3.3908955933457d-12,
     |   4.9630459065749d-10, 1.9836492647525d-08, 3.6323163943406d-07,
     |   3.9325263734550d-06, 2.9086140842142d-05, 1.6075941122053d-04,
     |   7.0454964222788d-04, 2.5512374488090d-03, 7.8613582069918d-03,
     |   2.1064388024414d-02, 4.9876422806077d-02, 1.0561957002032d-01,
     |   2.0179439003145d-01, 3.4997338354538d-01, 5.5296480686408d-01,
     |   7.9682749211676d-01, 1.0451343354099d+00, 1.2398310661605d+00,
     |   1.3120233749747d+00, 1.2026192737540d+00, 8.8777721431155d-01,
     |   3.9966665988691d-01,-1.6824591313287d-01,-6.7853227767589d-01,
     |  -9.8866527726095d-01,-1.0003536255279d+00,-7.0112540830116d-01,
     |  -1.7968231070779d-01, 3.9532038985946d-01, 8.2931067339208d-01,
     |   9.7053275342794d-01, 7.6732403202659d-01, 2.9040182753355d-01,
     |  -2.9040182753355d-01,-7.6732403202659d-01,-9.7053275342794d-01,
     |  -8.2931067339208d-01,-3.9532038985946d-01, 1.7968231070779d-01,
     |   7.0112540830116d-01, 1.0003536255279d+00, 9.8866527726095d-01,
     |   6.7853227767589d-01, 1.6824591313287d-01,-3.9966665988690d-01,
     |  -8.8777721431155d-01,-1.2026192737540d+00,-1.3120233749747d+00,
     |  -1.2398310661605d+00,-1.0451343354099d+00,-7.9682749211676d-01,
     |  -5.5296480686408d-01,-3.4997338354539d-01,-2.0179439003145d-01,
     |  -1.0561957002032d-01,-4.9876422806077d-02,-2.1064388024414d-02,
     |  -7.8613582069918d-03,-2.5512374488090d-03,-7.0454964222789d-04,
     |  -1.6075941122053d-04,-2.9086140842142d-05,-3.9325263734550d-06,
     |  -3.6323163943407d-07,-1.9836492647525d-08,-4.9630459065749d-10,
     |  -3.3908955933457d-12,-1.6603261744964d-15,-1.1807707346904d-22/
      data (pmn(lat,16,20), lat = 1,72)/
     |   1.0802798505023d-24, 4.5652339449332d-17, 1.5595359802134d-13,
     |   3.2130657262924d-11, 1.6632801799194d-09, 3.7572757435982d-08,
     |   4.8623450547753d-07, 4.2062052858306d-06, 2.6769208002430d-05,
     |   1.3355812597594d-04, 5.4597366338492d-04, 1.8877941341592d-03,
     |   5.6525045481610d-03, 1.4918956596032d-02, 3.5182376380145d-02,
     |   7.4901872631385d-02, 1.4508895296705d-01, 2.5717248523100d-01,
     |   4.1870779924738d-01, 6.2737177432041d-01, 8.6494256955563d-01,
     |   1.0940919546984d+00, 1.2610874574393d+00, 1.3062978530330d+00,
     |   1.1816540720214d+00, 8.7069915447432d-01, 4.0404728446949d-01,
     |  -1.3739279333902d-01,-6.3621610468633d-01,-9.6834864356300d-01,
     |  -1.0411456717707d+00,-8.2710355775827d-01,-3.8004228182226d-01,
     |   1.7449852211075d-01, 6.7399301716630d-01, 9.6851111536214d-01,
     |   9.6851111536214d-01, 6.7399301716630d-01, 1.7449852211075d-01,
     |  -3.8004228182226d-01,-8.2710355775827d-01,-1.0411456717707d+00,
     |  -9.6834864356300d-01,-6.3621610468633d-01,-1.3739279333902d-01,
     |   4.0404728446949d-01, 8.7069915447432d-01, 1.1816540720214d+00,
     |   1.3062978530330d+00, 1.2610874574393d+00, 1.0940919546984d+00,
     |   8.6494256955564d-01, 6.2737177432041d-01, 4.1870779924739d-01,
     |   2.5717248523101d-01, 1.4508895296705d-01, 7.4901872631386d-02,
     |   3.5182376380145d-02, 1.4918956596032d-02, 5.6525045481611d-03,
     |   1.8877941341592d-03, 5.4597366338492d-04, 1.3355812597594d-04,
     |   2.6769208002431d-05, 4.2062052858306d-06, 4.8623450547753d-07,
     |   3.7572757435983d-08, 1.6632801799194d-09, 3.2130657262924d-11,
     |   1.5595359802134d-13, 4.5652339449332d-17, 1.0802798505023d-24/
      data (pmn(lat,17,20), lat = 1,72)/
     |   8.4345859255715d-27, 1.0710708627064d-18, 6.1181180423776d-15,
     |   1.7734228276960d-12, 1.1881906797119d-10, 3.3082119737456d-09,
     |   5.1116799470229d-08, 5.1646514764779d-07, 3.7784727315924d-06,
     |   2.1417934593004d-05, 9.8603225096059d-05, 3.8145747607902d-04,
     |   1.2718590655300d-03, 3.7258608919264d-03, 9.7333566067362d-03,
     |   2.2939390484354d-02, 4.9218271532357d-02, 9.6820060050954d-02,
     |   1.7556611436575d-01, 2.9461452856110d-01, 4.5867271896772d-01,
     |   6.6322204851610d-01, 8.9016985707980d-01, 1.1059950649346d+00,
     |   1.2644577974932d+00, 1.3149829117801d+00, 1.2159432196982d+00,
     |   9.4978262068264d-01, 5.3513775159731d-01, 3.0796200304432d-02,
     |  -4.7197667232947d-01,-8.6872170258186d-01,-1.0684439375863d+00,
     |  -1.0200563414604d+00,-7.3002236843700d-01,-2.6467363636252d-01,
     |   2.6467363636252d-01, 7.3002236843700d-01, 1.0200563414604d+00,
     |   1.0684439375863d+00, 8.6872170258186d-01, 4.7197667232947d-01,
     |  -3.0796200304431d-02,-5.3513775159731d-01,-9.4978262068264d-01,
     |  -1.2159432196982d+00,-1.3149829117801d+00,-1.2644577974932d+00,
     |  -1.1059950649346d+00,-8.9016985707980d-01,-6.6322204851610d-01,
     |  -4.5867271896773d-01,-2.9461452856110d-01,-1.7556611436575d-01,
     |  -9.6820060050954d-02,-4.9218271532358d-02,-2.2939390484354d-02,
     |  -9.7333566067361d-03,-3.7258608919264d-03,-1.2718590655300d-03,
     |  -3.8145747607902d-04,-9.8603225096059d-05,-2.1417934593004d-05,
     |  -3.7784727315925d-06,-5.1646514764780d-07,-5.1116799470229d-08,
     |  -3.3082119737457d-09,-1.1881906797119d-10,-1.7734228276960d-12,
     |  -6.1181180423776d-15,-1.0710708627064d-18,-8.4345859255715d-27/
      data (pmn(lat,18,20), lat = 1,72)/
     |   5.4586063119505d-29, 2.0825906551584d-20, 1.9886105254229d-16,
     |   8.1064322399457d-14, 7.0255403976922d-12, 2.4091400748043d-10,
     |   4.4404411344975d-09, 5.2341204064747d-08, 4.3959877723983d-07,
     |   2.8264174087684d-06, 1.4625797623169d-05, 6.3160422097506d-05,
     |   2.3385760128175d-04, 7.5788389308494d-04, 2.1845972068571d-03,
     |   5.6722998616035d-03, 1.3401410568864d-02, 2.9044137497632d-02,
     |   5.8116225395457d-02, 1.0792027321744d-01, 1.8672972465517d-01,
     |   3.0193754344706d-01, 4.5716189642830d-01, 6.4875110128557d-01,
     |   8.6264592661961d-01, 1.0729277079568d+00, 1.2433643602960d+00,
     |   1.3327020755032d+00, 1.3033683427440d+00, 1.1319260489641d+00,
     |   8.1851579793139d-01, 3.9214533089726d-01,-9.0648452197807d-02,
     |  -5.5456684933454d-01,-9.2031895839783d-01,-1.1219176949447d+00,
     |  -1.1219176949447d+00,-9.2031895839784d-01,-5.5456684933454d-01,
     |  -9.0648452197808d-02, 3.9214533089726d-01, 8.1851579793139d-01,
     |   1.1319260489641d+00, 1.3033683427440d+00, 1.3327020755032d+00,
     |   1.2433643602960d+00, 1.0729277079568d+00, 8.6264592661961d-01,
     |   6.4875110128557d-01, 4.5716189642830d-01, 3.0193754344706d-01,
     |   1.8672972465517d-01, 1.0792027321744d-01, 5.8116225395457d-02,
     |   2.9044137497632d-02, 1.3401410568864d-02, 5.6722998616035d-03,
     |   2.1845972068571d-03, 7.5788389308494d-04, 2.3385760128176d-04,
     |   6.3160422097506d-05, 1.4625797623169d-05, 2.8264174087685d-06,
     |   4.3959877723984d-07, 5.2341204064748d-08, 4.4404411344975d-09,
     |   2.4091400748044d-10, 7.0255403976922d-12, 8.1064322399457d-14,
     |   1.9886105254229d-16, 2.0825906551584d-20, 5.4586063119505d-29/
      data (pmn(lat,19,20), lat = 1,72)/
     |   2.7682621227633d-31, 3.1728248826140d-22, 5.0633190765037d-18,
     |   2.9016461567448d-15, 3.2513045767297d-13, 1.3722771405747d-11,
     |   3.0148160521246d-10, 4.1419762842052d-09, 3.9890195080911d-08,
     |   2.9052362400599d-07, 1.6871224472465d-06, 8.1176994749159d-06,
     |   3.3304300329690d-05, 1.1909450247131d-04, 3.7762767392389d-04,
     |   1.0763133584735d-03, 2.7879313367670d-03, 6.6216816552189d-03,
     |   1.4526823845086d-02, 2.9614144904779d-02, 5.6376937304717d-02,
     |   1.0063201409053d-01, 1.6897604888236d-01, 2.6760123405563d-01,
     |   4.0046154092285d-01, 5.6701746409528d-01, 7.6005703012385d-01,
     |   9.6429675979617d-01, 1.1564980255250d+00, 1.3076141392232d+00,
     |   1.3870116665791d+00, 1.3681871374369d+00, 1.2348140954148d+00,
     |   9.8562035263867d-01, 6.3667415221449d-01, 2.2018816330158d-01,
     |  -2.2018816330158d-01,-6.3667415221449d-01,-9.8562035263867d-01,
     |  -1.2348140954148d+00,-1.3681871374368d+00,-1.3870116665791d+00,
     |  -1.3076141392232d+00,-1.1564980255250d+00,-9.6429675979617d-01,
     |  -7.6005703012385d-01,-5.6701746409528d-01,-4.0046154092285d-01,
     |  -2.6760123405563d-01,-1.6897604888236d-01,-1.0063201409053d-01,
     |  -5.6376937304718d-02,-2.9614144904779d-02,-1.4526823845086d-02,
     |  -6.6216816552190d-03,-2.7879313367670d-03,-1.0763133584735d-03,
     |  -3.7762767392388d-04,-1.1909450247131d-04,-3.3304300329690d-05,
     |  -8.1176994749159d-06,-1.6871224472465d-06,-2.9052362400599d-07,
     |  -3.9890195080911d-08,-4.1419762842052d-09,-3.0148160521246d-10,
     |  -1.3722771405747d-11,-3.2513045767297d-13,-2.9016461567448d-15,
     |  -5.0633190765037d-18,-3.1728248826140d-22,-2.7682621227633d-31/
      data (pmn(lat,20,20), lat = 1,72)/
     |   9.5506626691869d-34, 3.2881035769295d-24, 8.7677883586473d-20,
     |   7.0614618136651d-17, 1.0225615204124d-14, 5.3093705876468d-13,
     |   1.3894079498525d-11, 2.2230993620429d-10, 2.4527334635768d-09,
     |   2.0212243795930d-08, 1.3155023173551d-07, 7.0416372544136d-07,
     |   3.1954097209659d-06, 1.2582133986412d-05, 4.3779847326601d-05,
     |   1.3658395782940d-04, 3.8658056399994d-04, 1.0022651154617d-03,
     |   2.3993652347985d-03, 5.3392623866887d-03, 1.1106584494843d-02,
     |   2.1700300322995d-02, 3.9985503438732d-02, 6.9727144919074d-02,
     |   1.1541443853970d-01, 1.8179897500661d-01, 2.7311975487757d-01,
     |   3.9207262463880d-01, 5.3868345655642d-01, 7.0933380245410d-01,
     |   8.9622883368954d-01, 1.0875612403195d+00, 1.2685027791699d+00,
     |   1.4229672665353d+00, 1.5358819643310d+00, 1.5955399469690d+00,
     |   1.5955399469690d+00, 1.5358819643310d+00, 1.4229672665353d+00,
     |   1.2685027791699d+00, 1.0875612403195d+00, 8.9622883368954d-01,
     |   7.0933380245410d-01, 5.3868345655642d-01, 3.9207262463880d-01,
     |   2.7311975487757d-01, 1.8179897500661d-01, 1.1541443853970d-01,
     |   6.9727144919075d-02, 3.9985503438732d-02, 2.1700300322995d-02,
     |   1.1106584494843d-02, 5.3392623866888d-03, 2.3993652347985d-03,
     |   1.0022651154617d-03, 3.8658056399994d-04, 1.3658395782940d-04,
     |   4.3779847326600d-05, 1.2582133986412d-05, 3.1954097209660d-06,
     |   7.0416372544136d-07, 1.3155023173551d-07, 2.0212243795930d-08,
     |   2.4527334635769d-09, 2.2230993620429d-10, 1.3894079498525d-11,
     |   5.3093705876470d-13, 1.0225615204124d-14, 7.0614618136651d-17,
     |   8.7677883586473d-20, 3.2881035769295d-24, 9.5506626691869d-34/
      data (pmn(lat, 0,21), lat = 1,72)/
     |   4.3853826182382d+00, 2.6109683588214d+00, 1.4466310218247d-01,
     |  -1.5825771041713d+00,-1.7371451200503d+00,-5.7749071021480d-01,
     |   8.2557387577600d-01, 1.4037914666039d+00, 8.3275936024410d-01,
     |  -3.2244693265115d-01,-1.1170519133923d+00,-9.6950694221980d-01,
     |  -7.0905186294757d-02, 8.2120217414466d-01, 1.0067385814690d+00,
     |   3.8237179423570d-01,-5.1320012554999d-01,-9.5596291792336d-01,
     |  -6.1503093077616d-01, 2.0434210138495d-01, 8.2905257045176d-01,
     |   7.6632393190102d-01, 8.9125794485521d-02,-6.4039476330577d-01,
     |  -8.3430522678191d-01,-3.4984636069532d-01, 4.0716337366068d-01,
     |   8.2018051275155d-01, 5.6159726619316d-01,-1.4876730793696d-01,
     |  -7.2934054281432d-01,-7.1086920436466d-01,-1.1412385475624d-01,
     |   5.7157856422361d-01, 7.8801419297543d-01, 3.6076453318678d-01,
     |  -3.6076453318678d-01,-7.8801419297543d-01,-5.7157856422361d-01,
     |   1.1412385475624d-01, 7.1086920436465d-01, 7.2934054281432d-01,
     |   1.4876730793696d-01,-5.6159726619315d-01,-8.2018051275155d-01,
     |  -4.0716337366068d-01, 3.4984636069532d-01, 8.3430522678191d-01,
     |   6.4039476330577d-01,-8.9125794485521d-02,-7.6632393190102d-01,
     |  -8.2905257045177d-01,-2.0434210138495d-01, 6.1503093077616d-01,
     |   9.5596291792336d-01, 5.1320012555000d-01,-3.8237179423569d-01,
     |  -1.0067385814690d+00,-8.2120217414466d-01, 7.0905186294747d-02,
     |   9.6950694221980d-01, 1.1170519133923d+00, 3.2244693265116d-01,
     |  -8.3275936024409d-01,-1.4037914666039d+00,-8.2557387577600d-01,
     |   5.7749071021479d-01, 1.7371451200503d+00, 1.5825771041713d+00,
     |  -1.4466310218247d-01,-2.6109683588214d+00,-4.3853826182382d+00/
      data (pmn(lat, 1,21), lat = 1,72)/
     |   1.0576018426447d+00, 2.5194256478740d+00, 2.4669824546430d+00,
     |   1.0585185321387d+00,-6.7729827340403d-01,-1.5891343914997d+00,
     |  -1.1983968080162d+00, 2.5737626308636d-02, 1.0812782362847d+00,
     |   1.1994664784209d+00, 3.8360537420210d-01,-6.6003370317062d-01,
     |  -1.1090621717690d+00,-6.5818418142771d-01, 2.8170592435120d-01,
     |   9.4479620731817d-01, 8.2474123931650d-01, 5.5828238204261d-02,
     |  -7.2317043789792d-01,-8.9349507915784d-01,-3.4341422990893d-01,
     |   4.6262933708666d-01, 8.7225467664984d-01, 5.6950729093888d-01,
     |  -1.8341018371846d-01,-7.7075909594579d-01,-7.2394534585078d-01,
     |  -9.3412608635196d-02, 6.0202101376798d-01, 7.9993365382519d-01,
     |   3.4715469024478d-01,-3.8240885907500d-01,-7.9514388798889d-01,
     |  -5.5880384342345d-01, 1.3106474030287d-01, 7.1221965907671d-01,
     |   7.1221965907671d-01, 1.3106474030288d-01,-5.5880384342345d-01,
     |  -7.9514388798889d-01,-3.8240885907500d-01, 3.4715469024478d-01,
     |   7.9993365382519d-01, 6.0202101376798d-01,-9.3412608635193d-02,
     |  -7.2394534585078d-01,-7.7075909594580d-01,-1.8341018371846d-01,
     |   5.6950729093888d-01, 8.7225467664984d-01, 4.6262933708666d-01,
     |  -3.4341422990892d-01,-8.9349507915785d-01,-7.2317043789792d-01,
     |   5.5828238204259d-02, 8.2474123931650d-01, 9.4479620731817d-01,
     |   2.8170592435119d-01,-6.5818418142771d-01,-1.1090621717690d+00,
     |  -6.6003370317062d-01, 3.8360537420210d-01, 1.1994664784209d+00,
     |   1.0812782362847d+00, 2.5737626308643d-02,-1.1983968080162d+00,
     |  -1.5891343914997d+00,-6.7729827340403d-01, 1.0585185321387d+00,
     |   2.4669824546430d+00, 2.5194256478740d+00, 1.0576018426447d+00/
      data (pmn(lat, 2,21), lat = 1,72)/
     |   1.2487106916773d-01, 9.6781769554345d-01, 1.9555696562215d+00,
     |   2.2273257869158d+00, 1.4233987600214d+00,-2.6847753658159d-02,
     |  -1.2107672365484d+00,-1.3997695696808d+00,-5.7528456006905d-01,
     |   5.7734748235371d-01, 1.1920148476128d+00, 8.5942425137616d-01,
     |  -9.9372681588788d-02,-9.1484112241245d-01,-9.7309808406030d-01,
     |  -2.7342844581629d-01, 6.0201078372777d-01, 9.6347711323795d-01,
     |   5.5181058703821d-01,-2.7785450818377d-01,-8.5655451364155d-01,
     |  -7.3635619067643d-01,-3.4970909765385d-02, 6.7401143065423d-01,
     |   8.2673389136282d-01, 3.1516190653046d-01,-4.3775189303120d-01,
     |  -8.2534901347497d-01,-5.4376026823134d-01, 1.7083259028830d-01,
     |   7.3884580771399d-01, 7.0531971887086d-01, 1.0295928155153d-01,
     |  -5.7852661239694d-01,-7.8892434693318d-01,-3.6009877663991d-01,
     |   3.6009877663990d-01, 7.8892434693317d-01, 5.7852661239694d-01,
     |  -1.0295928155153d-01,-7.0531971887086d-01,-7.3884580771399d-01,
     |  -1.7083259028831d-01, 5.4376026823133d-01, 8.2534901347497d-01,
     |   4.3775189303120d-01,-3.1516190653045d-01,-8.2673389136282d-01,
     |  -6.7401143065423d-01, 3.4970909765385d-02, 7.3635619067643d-01,
     |   8.5655451364155d-01, 2.7785450818378d-01,-5.5181058703821d-01,
     |  -9.6347711323795d-01,-6.0201078372777d-01, 2.7342844581629d-01,
     |   9.7309808406030d-01, 9.1484112241244d-01, 9.9372681588798d-02,
     |  -8.5942425137616d-01,-1.1920148476128d+00,-5.7734748235372d-01,
     |   5.7528456006904d-01, 1.3997695696808d+00, 1.2107672365484d+00,
     |   2.6847753658175d-02,-1.4233987600214d+00,-2.2273257869158d+00,
     |  -1.9555696562215d+00,-9.6781769554345d-01,-1.2487106916773d-01/
      data (pmn(lat, 3,21), lat = 1,72)/
     |   9.7408596699245d-03, 2.3548194081429d-01, 8.6698986391936d-01,
     |   1.6475471056242d+00, 2.0206869238743d+00, 1.5755370502881d+00,
     |   4.2553454423009d-01,-7.9826910069978d-01,-1.3631164365318d+00,
     |  -9.5893284668115d-01, 6.7492682016990d-02, 9.5635901391749d-01,
     |   1.0832405921206d+00, 4.0459814157966d-01,-5.3153456492512d-01,
     |  -1.0127471093433d+00,-6.9976456330339d-01, 1.3245491470722d-01,
     |   8.2528442701923d-01, 8.5176143870265d-01, 2.1614452268310d-01,
     |  -5.6579002106779d-01,-8.8044900745754d-01,-4.9538692367980d-01,
     |   2.6917275682718d-01, 8.0324519283060d-01, 6.9103343378112d-01,
     |   3.3699975142433d-02,-6.3923101916099d-01,-7.9410736099090d-01,
     |  -3.1480807652990d-01, 4.1036243009269d-01, 8.0159215211211d-01,
     |   5.4938116394737d-01,-1.4132428250436d-01,-7.1680843175438d-01,
     |  -7.1680843175438d-01,-1.4132428250437d-01, 5.4938116394737d-01,
     |   8.0159215211211d-01, 4.1036243009269d-01,-3.1480807652990d-01,
     |  -7.9410736099091d-01,-6.3923101916099d-01, 3.3699975142430d-02,
     |   6.9103343378112d-01, 8.0324519283060d-01, 2.6917275682718d-01,
     |  -4.9538692367979d-01,-8.8044900745754d-01,-5.6579002106779d-01,
     |   2.1614452268308d-01, 8.5176143870265d-01, 8.2528442701923d-01,
     |   1.3245491470723d-01,-6.9976456330339d-01,-1.0127471093433d+00,
     |  -5.3153456492511d-01, 4.0459814157966d-01, 1.0832405921206d+00,
     |   9.5635901391749d-01, 6.7492682016990d-02,-9.5893284668115d-01,
     |  -1.3631164365318d+00,-7.9826910069979d-01, 4.2553454423009d-01,
     |   1.5755370502880d+00, 2.0206869238743d+00, 1.6475471056242d+00,
     |   8.6698986391936d-01, 2.3548194081429d-01, 9.7408596699245d-03/
      data (pmn(lat, 4,21), lat = 1,72)/
     |   5.6508756564696d-04, 4.1937575369283d-02, 2.7054033309962d-01,
     |   7.8550366862696d-01, 1.4404517094872d+00, 1.8481622637038d+00,
     |   1.6317464948945d+00, 7.4393049009053d-01,-4.1232679002589d-01,
     |  -1.1975943479127d+00,-1.1612249872812d+00,-3.7207988050476d-01,
     |   6.0494263963114d-01, 1.0921878930827d+00, 7.7452510976204d-01,
     |  -8.1661718694008d-02,-8.3169917670030d-01,-9.3074371676392d-01,
     |  -3.3202066135904d-01, 4.9097709771646d-01, 9.1131191549254d-01,
     |   6.2391043079445d-01,-1.3119230386830d-01,-7.6351478989304d-01,
     |  -7.9045890295739d-01,-2.0521730875917d-01, 5.2666229294548d-01,
     |   8.3453983173955d-01, 4.8599937999428d-01,-2.3743481329736d-01,
     |  -7.6554337194076d-01,-6.8691891499035d-01,-6.8747165945414d-02,
     |   5.9938848927863d-01, 7.9154648792784d-01, 3.5806759514773d-01,
     |  -3.5806759514772d-01,-7.9154648792784d-01,-5.9938848927864d-01,
     |   6.8747165945412d-02, 6.8691891499035d-01, 7.6554337194076d-01,
     |   2.3743481329737d-01,-4.8599937999428d-01,-8.3453983173955d-01,
     |  -5.2666229294548d-01, 2.0521730875917d-01, 7.9045890295738d-01,
     |   7.6351478989304d-01, 1.3119230386830d-01,-6.2391043079445d-01,
     |  -9.1131191549254d-01,-4.9097709771647d-01, 3.3202066135904d-01,
     |   9.3074371676392d-01, 8.3169917670031d-01, 8.1661718694013d-02,
     |  -7.7452510976204d-01,-1.0921878930827d+00,-6.0494263963115d-01,
     |   3.7207988050476d-01, 1.1612249872812d+00, 1.1975943479127d+00,
     |   4.1232679002589d-01,-7.4393049009052d-01,-1.6317464948945d+00,
     |  -1.8481622637038d+00,-1.4404517094872d+00,-7.8550366862696d-01,
     |  -2.7054033309962d-01,-4.1937575369283d-02,-5.6508756564696d-04/
      data (pmn(lat, 5,21), lat = 1,72)/
     |   2.5967437383082d-05, 5.8706679122250d-03, 6.5195496423468d-02,
     |   2.7959947546504d-01, 7.1670574139959d-01, 1.2842751247035d+00,
     |   1.7008915961917d+00, 1.6393915347916d+00, 9.7193169024268d-01,
     |  -6.8107776307326d-02,-9.6412591865786d-01,-1.2230491008180d+00,
     |  -7.1365257201117d-01, 2.1374707316019d-01, 9.3827501647040d-01,
     |   9.8315372145325d-01, 3.4519355231042d-01,-5.0361664453720d-01,
     |  -9.5366467130411d-01,-6.9559207006729d-01, 6.0223347605899d-02,
     |   7.4496438357179d-01, 8.5502469273573d-01, 3.2354986670228d-01,
     |  -4.3661483708600d-01,-8.4899127950511d-01,-6.0907826280684d-01,
     |   8.9488782110766d-02, 7.0776629002177d-01, 7.7492730002046d-01,
     |   2.4636224541163d-01,-4.6605261167439d-01,-8.1284022011322d-01,
     |  -5.2935181862081d-01, 1.6233920509793d-01, 7.2623933178789d-01,
     |   7.2623933178790d-01, 1.6233920509793d-01,-5.2935181862081d-01,
     |  -8.1284022011322d-01,-4.6605261167439d-01, 2.4636224541164d-01,
     |   7.7492730002046d-01, 7.0776629002177d-01, 8.9488782110769d-02,
     |  -6.0907826280683d-01,-8.4899127950511d-01,-4.3661483708601d-01,
     |   3.2354986670228d-01, 8.5502469273573d-01, 7.4496438357179d-01,
     |   6.0223347605911d-02,-6.9559207006729d-01,-9.5366467130411d-01,
     |  -5.0361664453720d-01, 3.4519355231042d-01, 9.8315372145325d-01,
     |   9.3827501647039d-01, 2.1374707316019d-01,-7.1365257201116d-01,
     |  -1.2230491008180d+00,-9.6412591865786d-01,-6.8107776307332d-02,
     |   9.7193169024267d-01, 1.6393915347915d+00, 1.7008915961917d+00,
     |   1.2842751247035d+00, 7.1670574139959d-01, 2.7959947546504d-01,
     |   6.5195496423468d-02, 5.8706679122250d-03, 2.5967437383082d-05/
      data (pmn(lat, 6,21), lat = 1,72)/
     |   9.8257045908478d-07, 6.7375846737767d-04, 1.2758165930420d-02,
     |   7.9462675543010d-02, 2.7652517497966d-01, 6.5570661028009d-01,
     |   1.1570792953035d+00, 1.5710987533783d+00, 1.6195568157704d+00,
     |   1.1369043105475d+00, 2.3396242462143d-01,-6.9622235037622d-01,
     |  -1.1777378282355d+00,-9.5084703455294d-01,-1.6776843076341d-01,
     |   6.7197224365006d-01, 1.0306497090575d+00, 6.8834191158821d-01,
     |  -1.0339469988340d-01,-7.9012217889682d-01,-8.9854429091393d-01,
     |  -3.6828503899937d-01, 4.0757333000545d-01, 8.6676287279934d-01,
     |   6.8430901254258d-01, 6.1432561486571d-03,-6.6166501714464d-01,
     |  -8.2740030368116d-01,-3.7599979712531d-01, 3.4883927562141d-01,
     |   8.0335751021099d-01, 6.5022182681364d-01, 9.3456476073617d-03,
     |  -6.3417865777727d-01,-7.9553618899239d-01,-3.5456398812416d-01,
     |   3.5456398812416d-01, 7.9553618899239d-01, 6.3417865777727d-01,
     |  -9.3456476073595d-03,-6.5022182681364d-01,-8.0335751021099d-01,
     |  -3.4883927562142d-01, 3.7599979712531d-01, 8.2740030368116d-01,
     |   6.6166501714464d-01,-6.1432561486539d-03,-6.8430901254257d-01,
     |  -8.6676287279934d-01,-4.0757333000545d-01, 3.6828503899937d-01,
     |   8.9854429091393d-01, 7.9012217889683d-01, 1.0339469988340d-01,
     |  -6.8834191158821d-01,-1.0306497090575d+00,-6.7197224365006d-01,
     |   1.6776843076342d-01, 9.5084703455294d-01, 1.1777378282355d+00,
     |   6.9622235037622d-01,-2.3396242462143d-01,-1.1369043105475d+00,
     |  -1.6195568157704d+00,-1.5710987533783d+00,-1.1570792953035d+00,
     |  -6.5570661028010d-01,-2.7652517497966d-01,-7.9462675543010d-02,
     |  -1.2758165930420d-02,-6.7375846737767d-04,-9.8257045908478d-07/
      data (pmn(lat, 7,21), lat = 1,72)/
     |   3.1411724973257d-08, 6.5154600460842d-05, 2.0915896087766d-03,
     |   1.8735405174551d-02, 8.7137243826453d-02, 2.6655069671024d-01,
     |   5.9943406524547d-01, 1.0474130046948d+00, 1.4528702813524d+00,
     |   1.5819990452845d+00, 1.2555992449197d+00, 4.9732106599097d-01,
     |  -4.1267068165939d-01,-1.0500278470929d+00,-1.0855603650158d+00,
     |  -5.0685056682202d-01, 3.3805450728333d-01, 9.3179385390254d-01,
     |   9.0923640046131d-01, 2.9972755677794d-01,-4.8334453037932d-01,
     |  -9.1364970563425d-01,-7.0769213865885d-01,-2.0166107504586d-02,
     |   6.6263450688349d-01, 8.6280821501639d-01, 4.4724422256712d-01,
     |  -2.7916060633612d-01,-7.9254127647295d-01,-7.2638355014491d-01,
     |  -1.3475126363204d-01, 5.4839570524232d-01, 8.2521270450403d-01,
     |   4.9619271457574d-01,-1.9517334796923d-01,-7.4107121060372d-01,
     |  -7.4107121060372d-01,-1.9517334796923d-01, 4.9619271457574d-01,
     |   8.2521270450403d-01, 5.4839570524233d-01,-1.3475126363204d-01,
     |  -7.2638355014491d-01,-7.9254127647296d-01,-2.7916060633613d-01,
     |   4.4724422256712d-01, 8.6280821501639d-01, 6.6263450688349d-01,
     |  -2.0166107504583d-02,-7.0769213865885d-01,-9.1364970563425d-01,
     |  -4.8334453037933d-01, 2.9972755677794d-01, 9.0923640046131d-01,
     |   9.3179385390254d-01, 3.3805450728334d-01,-5.0685056682202d-01,
     |  -1.0855603650158d+00,-1.0500278470929d+00,-4.1267068165940d-01,
     |   4.9732106599097d-01, 1.2555992449197d+00, 1.5819990452845d+00,
     |   1.4528702813524d+00, 1.0474130046948d+00, 5.9943406524547d-01,
     |   2.6655069671024d-01, 8.7137243826453d-02, 1.8735405174551d-02,
     |   2.0915896087766d-03, 6.5154600460842d-05, 3.1411724973257d-08/
      data (pmn(lat, 8,21), lat = 1,72)/
     |   8.6371676010054d-10, 5.4095697751447d-06, 2.9329651858327d-04,
     |   3.7550469750384d-03, 2.3121206036875d-02, 8.9940573640602d-02,
     |   2.5205871605470d-01, 5.4592906340768d-01, 9.4859493497350d-01,
     |   1.3417505052593d+00, 1.5310917875539d+00, 1.3379658430580d+00,
     |   7.2536003772265d-01,-1.2477381352742d-01,-8.5803944193326d-01,
     |  -1.1222470281219d+00,-7.8043609794737d-01,-2.3807485450324d-02,
     |   7.0992655760162d-01, 9.8626267789202d-01, 6.4437161343813d-01,
     |  -9.0882032197894d-02,-7.4309128263209d-01,-8.9008284070245d-01,
     |  -4.4342117833898d-01, 2.8938566899303d-01, 8.0970918783963d-01,
     |   7.6611679273916d-01, 1.9550227337373d-01,-5.0190863290126d-01,
     |  -8.4000132214056d-01,-5.8554597434302d-01, 7.8743848520181d-02,
     |   6.8277733689679d-01, 8.0024786093966d-01, 3.4939013857443d-01,
     |  -3.4939013857443d-01,-8.0024786093966d-01,-6.8277733689679d-01,
     |  -7.8743848520183d-02, 5.8554597434302d-01, 8.4000132214056d-01,
     |   5.0190863290127d-01,-1.9550227337372d-01,-7.6611679273916d-01,
     |  -8.0970918783963d-01,-2.8938566899304d-01, 4.4342117833897d-01,
     |   8.9008284070245d-01, 7.4309128263209d-01, 9.0882032197894d-02,
     |  -6.4437161343813d-01,-9.8626267789202d-01,-7.0992655760163d-01,
     |   2.3807485450322d-02, 7.8043609794736d-01, 1.1222470281219d+00,
     |   8.5803944193325d-01, 1.2477381352741d-01,-7.2536003772264d-01,
     |  -1.3379658430580d+00,-1.5310917875539d+00,-1.3417505052593d+00,
     |  -9.4859493497351d-01,-5.4592906340769d-01,-2.5205871605470d-01,
     |  -8.9940573640604d-02,-2.3121206036875d-02,-3.7550469750384d-03,
     |  -2.9329651858327d-04,-5.4095697751447d-06,-8.6371676010054d-10/
      data (pmn(lat, 9,21), lat = 1,72)/
     |   2.0687177348323d-11, 3.9074262658181d-07, 3.5687895288028d-05,
     |   6.5032841793697d-04, 5.2684536368545d-03, 2.5827936544352d-02,
     |   8.9026206766003d-02, 2.3431220606414d-01, 4.9393325702534d-01,
     |   8.5644138837126d-01, 1.2343433708255d+00, 1.4684666791786d+00,
     |   1.3895181810983d+00, 9.2005748753269d-01, 1.5950366471354d-01,
     |  -6.1574032661041d-01,-1.0659222896651d+00,-9.7086461450029d-01,
     |  -3.7708826366738d-01, 3.9494422729872d-01, 9.1216061309607d-01,
     |   8.7821375621307d-01, 3.1978855456115d-01,-4.1702139191981d-01,
     |  -8.7318501517735d-01,-7.6470715609846d-01,-1.6767076343690d-01,
     |   5.2620695822292d-01, 8.6240273994761d-01, 6.2260859501247d-01,
     |  -2.9044834656226d-02,-6.5389667562914d-01,-8.3215061315192d-01,
     |  -4.4568561591594d-01, 2.4163202994742d-01, 7.6229655044816d-01,
     |   7.6229655044816d-01, 2.4163202994742d-01,-4.4568561591594d-01,
     |  -8.3215061315192d-01,-6.5389667562914d-01,-2.9044834656224d-02,
     |   6.2260859501247d-01, 8.6240273994761d-01, 5.2620695822293d-01,
     |  -1.6767076343690d-01,-7.6470715609846d-01,-8.7318501517735d-01,
     |  -4.1702139191981d-01, 3.1978855456115d-01, 8.7821375621307d-01,
     |   9.1216061309607d-01, 3.9494422729872d-01,-3.7708826366738d-01,
     |  -9.7086461450029d-01,-1.0659222896651d+00,-6.1574032661041d-01,
     |   1.5950366471354d-01, 9.2005748753269d-01, 1.3895181810983d+00,
     |   1.4684666791786d+00, 1.2343433708255d+00, 8.5644138837126d-01,
     |   4.9393325702535d-01, 2.3431220606414d-01, 8.9026206766003d-02,
     |   2.5827936544352d-02, 5.2684536368545d-03, 6.5032841793697d-04,
     |   3.5687895288028d-05, 3.9074262658181d-07, 2.0687177348323d-11/
      data (pmn(lat,10,21), lat = 1,72)/
     |   4.3547627907796d-13, 2.4783396438521d-08, 3.8059795925215d-06,
     |   9.8421876246150d-05, 1.0445347659954d-03, 6.4144356308860d-03,
     |   2.6964405144223d-02, 8.5210046138825d-02, 2.1409950846456d-01,
     |   4.4267212304155d-01, 7.6824502252567d-01, 1.1280580253206d+00,
     |   1.3943204379167d+00, 1.4128168957241d+00, 1.0815697130319d+00,
     |   4.3308625508882d-01,-3.3523339615085d-01,-9.2211194735658d-01,
     |  -1.0637894989669d+00,-6.8660227149444d-01, 2.3447213535109d-02,
     |   6.9400946183202d-01, 9.6027133920118d-01, 6.7519768927266d-01,
     |   6.9498558238839d-03,-6.4824631348250d-01,-8.9792029397011d-01,
     |  -5.9345999656646d-01, 7.3031084387188d-02, 6.8326980351653d-01,
     |   8.5345100554448d-01, 4.7815812932521d-01,-2.0015814733022d-01,
     |  -7.4465374228433d-01,-8.0459963622780d-01,-3.4222007243691d-01,
     |   3.4222007243691d-01, 8.0459963622780d-01, 7.4465374228433d-01,
     |   2.0015814733022d-01,-4.7815812932521d-01,-8.5345100554448d-01,
     |  -6.8326980351654d-01,-7.3031084387194d-02, 5.9345999656646d-01,
     |   8.9792029397011d-01, 6.4824631348250d-01,-6.9498558238798d-03,
     |  -6.7519768927266d-01,-9.6027133920118d-01,-6.9400946183202d-01,
     |  -2.3447213535120d-02, 6.8660227149444d-01, 1.0637894989669d+00,
     |   9.2211194735658d-01, 3.3523339615085d-01,-4.3308625508882d-01,
     |  -1.0815697130319d+00,-1.4128168957241d+00,-1.3943204379167d+00,
     |  -1.1280580253206d+00,-7.6824502252567d-01,-4.4267212304155d-01,
     |  -2.1409950846456d-01,-8.5210046138825d-02,-2.6964405144223d-02,
     |  -6.4144356308861d-03,-1.0445347659954d-03,-9.8421876246150d-05,
     |  -3.8059795925215d-06,-2.4783396438521d-08,-4.3547627907796d-13/
      data (pmn(lat,11,21), lat = 1,72)/
     |   8.1058531025737d-15, 1.3890214867875d-09, 3.5816838392161d-07,
     |   1.3115237846209d-05, 1.8177299869333d-04, 1.3922804415915d-03,
     |   7.0962988714818d-03, 2.6712123411896d-02, 7.9123038838975d-02,
     |   1.9201577519535d-01, 3.9174475924687d-01, 6.8228523637164d-01,
     |   1.0209821584390d+00, 1.3081554616790d+00, 1.4084627775955d+00,
     |   1.2082220587707d+00, 6.8829485195126d-01,-2.8763739030317d-02,
     |  -6.9791910173359d-01,-1.0478862660449d+00,-9.1765581639866d-01,
     |  -3.6036238798861d-01, 3.5523490748919d-01, 8.6546792836142d-01,
     |   9.0171319387628d-01, 4.4535195997715d-01,-2.4880369743137d-01,
     |  -7.8696604094715d-01,-8.6013736588625d-01,-4.2775205816030d-01,
     |   2.5248077008577d-01, 7.7360592322779d-01, 8.2262398844703d-01,
     |   3.7123659439258d-01,-3.0461877146822d-01,-7.9161366225620d-01,
     |  -7.9161366225620d-01,-3.0461877146822d-01, 3.7123659439257d-01,
     |   8.2262398844703d-01, 7.7360592322779d-01, 2.5248077008577d-01,
     |  -4.2775205816030d-01,-8.6013736588624d-01,-7.8696604094715d-01,
     |  -2.4880369743137d-01, 4.4535195997715d-01, 9.0171319387627d-01,
     |   8.6546792836142d-01, 3.5523490748919d-01,-3.6036238798861d-01,
     |  -9.1765581639865d-01,-1.0478862660449d+00,-6.9791910173360d-01,
     |  -2.8763739030319d-02, 6.8829485195126d-01, 1.2082220587708d+00,
     |   1.4084627775955d+00, 1.3081554616790d+00, 1.0209821584390d+00,
     |   6.8228523637164d-01, 3.9174475924687d-01, 1.9201577519535d-01,
     |   7.9123038838976d-02, 2.6712123411896d-02, 7.0962988714818d-03,
     |   1.3922804415916d-03, 1.8177299869333d-04, 1.3115237846209d-05,
     |   3.5816838392161d-07, 1.3890214867875d-09, 8.1058531025737d-15/
      data (pmn(lat,12,21), lat = 1,72)/
     |   1.3390666006336d-16, 6.9056008518871d-11, 2.9867002417305d-08,
     |   1.5460520461438d-06, 2.7917762223806d-05, 2.6586579930511d-04,
     |   1.6361137987447d-03, 7.2954342028874d-03, 2.5286793495102d-02,
     |   7.1303575412790d-02, 1.6860165173655d-01, 3.4107165380842d-01,
     |   5.9759285484118d-01, 9.1185405523186d-01, 1.2092860614721d+00,
     |   1.3758567077679d+00, 1.2967279422765d+00, 9.1596440757071d-01,
     |   2.8955302332630d-01,-4.0381008862775d-01,-9.1615792410384d-01,
     |  -1.0367666581087d+00,-7.0430628321306d-01,-6.1318025206498d-02,
     |   5.9192979439874d-01, 9.3548291674620d-01, 7.9478577274669d-01,
     |   2.4229683834946d-01,-4.2902824029788d-01,-8.5667100508230d-01,
     |  -8.0661911286341d-01,-3.0748191750740d-01, 3.6005954384966d-01,
     |   8.1831317373064d-01, 8.0680718388089d-01, 3.3252464252303d-01,
     |  -3.3252464252303d-01,-8.0680718388089d-01,-8.1831317373064d-01,
     |  -3.6005954384967d-01, 3.0748191750739d-01, 8.0661911286341d-01,
     |   8.5667100508231d-01, 4.2902824029788d-01,-2.4229683834946d-01,
     |  -7.9478577274669d-01,-9.3548291674620d-01,-5.9192979439874d-01,
     |   6.1318025206495d-02, 7.0430628321306d-01, 1.0367666581087d+00,
     |   9.1615792410384d-01, 4.0381008862775d-01,-2.8955302332629d-01,
     |  -9.1596440757071d-01,-1.2967279422765d+00,-1.3758567077679d+00,
     |  -1.2092860614720d+00,-9.1185405523186d-01,-5.9759285484118d-01,
     |  -3.4107165380842d-01,-1.6860165173655d-01,-7.1303575412790d-02,
     |  -2.5286793495102d-02,-7.2954342028875d-03,-1.6361137987447d-03,
     |  -2.6586579930512d-04,-2.7917762223806d-05,-1.5460520461438d-06,
     |  -2.9867002417305d-08,-6.9056008518871d-11,-1.3390666006336d-16/
      data (pmn(lat,13,21), lat = 1,72)/
     |   1.9661895413048d-18, 3.0502632400363d-12, 2.2109511296442d-09,
     |   1.6158296172329d-07, 3.7946429942763d-06, 4.4821843247696d-05,
     |   3.3198586465469d-04, 1.7464231225298d-03, 7.0460639045856d-03,
     |   2.2926678006449d-02, 6.2252324658648d-02, 1.4441723997167d-01,
     |   2.9087298464028d-01, 5.1384638917602d-01, 8.0010933426656d-01,
     |   1.0972663914626d+00, 1.3138929054157d+00, 1.3426288630606d+00,
     |   1.1050689308701d+00, 6.0233920057372d-01,-5.5852605878425d-02,
     |  -6.6874286907662d-01,-1.0145639335641d+00,-9.4981714619977d-01,
     |  -4.9086223802127d-01, 1.7045123188608d-01, 7.3818034540041d-01,
     |   9.4651933722628d-01, 6.9342137732883d-01, 1.0162881342600d-01,
     |  -5.3299608220488d-01,-8.8728431261136d-01,-7.7824135537470d-01,
     |  -2.6256266490868d-01, 3.8889117878879d-01, 8.3202615374938d-01,
     |   8.3202615374938d-01, 3.8889117878879d-01,-2.6256266490867d-01,
     |  -7.7824135537470d-01,-8.8728431261136d-01,-5.3299608220488d-01,
     |   1.0162881342599d-01, 6.9342137732882d-01, 9.4651933722628d-01,
     |   7.3818034540041d-01, 1.7045123188608d-01,-4.9086223802126d-01,
     |  -9.4981714619977d-01,-1.0145639335641d+00,-6.6874286907662d-01,
     |  -5.5852605878435d-02, 6.0233920057372d-01, 1.1050689308701d+00,
     |   1.3426288630606d+00, 1.3138929054157d+00, 1.0972663914626d+00,
     |   8.0010933426656d-01, 5.1384638917602d-01, 2.9087298464028d-01,
     |   1.4441723997167d-01, 6.2252324658648d-02, 2.2926678006449d-02,
     |   7.0460639045857d-03, 1.7464231225298d-03, 3.3198586465469d-04,
     |   4.4821843247697d-05, 3.7946429942763d-06, 1.6158296172329d-07,
     |   2.2109511296442d-09, 3.0502632400363d-12, 1.9661895413048d-18/
      data (pmn(lat,14,21), lat = 1,72)/
     |   2.5642756050805d-20, 1.1963226299243d-13, 1.4522947672392d-10,
     |   1.4969642226892d-08, 4.5654969260071d-07, 6.6761625420323d-06,
     |   5.9372198043672d-05, 3.6733763849807d-04, 1.7183667695082d-03,
     |   6.4197322773589d-03, 1.9888098035067d-02, 5.2462609253146d-02,
     |   1.2008069569430d-01, 2.4165913420829d-01, 4.3133595303351d-01,
     |   6.8598009457400d-01, 9.7231404616643d-01, 1.2216972701307d+00,
     |   1.3410224854796d+00, 1.2429159268639d+00, 8.8809851306268d-01,
     |   3.2194098140683d-01,-3.1705413724039d-01,-8.3144976533371d-01,
     |  -1.0372340197559d+00,-8.4734413195346d-01,-3.2618311991541d-01,
     |   3.1862694719189d-01, 8.1424560112630d-01, 9.4158895510535d-01,
     |   6.4058669549937d-01, 4.7208506522317d-02,-5.6252373540349d-01,
     |  -9.0014290607229d-01,-8.0382951670205d-01,-3.1941162819910d-01,
     |   3.1941162819910d-01, 8.0382951670205d-01, 9.0014290607229d-01,
     |   5.6252373540350d-01,-4.7208506522316d-02,-6.4058669549937d-01,
     |  -9.4158895510535d-01,-8.1424560112631d-01,-3.1862694719189d-01,
     |   3.2618311991541d-01, 8.4734413195346d-01, 1.0372340197559d+00,
     |   8.3144976533371d-01, 3.1705413724039d-01,-3.2194098140683d-01,
     |  -8.8809851306267d-01,-1.2429159268639d+00,-1.3410224854796d+00,
     |  -1.2216972701307d+00,-9.7231404616644d-01,-6.8598009457400d-01,
     |  -4.3133595303351d-01,-2.4165913420829d-01,-1.2008069569430d-01,
     |  -5.2462609253146d-02,-1.9888098035067d-02,-6.4197322773589d-03,
     |  -1.7183667695082d-03,-3.6733763849808d-04,-5.9372198043672d-05,
     |  -6.6761625420325d-06,-4.5654969260071d-07,-1.4969642226892d-08,
     |  -1.4522947672392d-10,-1.1963226299243d-13,-2.5642756050805d-20/
      data (pmn(lat,15,21), lat = 1,72)/
     |   2.9610642494255d-22, 4.1532559833027d-15, 8.4397063936885d-12,
     |   1.2259317142403d-09, 4.8500793431453d-08, 8.7671332430615d-07,
     |   9.3435268961275d-06, 6.7827093691231d-05, 3.6677915711319d-04,
     |   1.5674148674977d-03, 5.5140871883684d-03, 1.6440523856612d-02,
     |   4.2432569433281d-02, 9.6281536461348d-02, 1.9421795340590d-01,
     |   3.5095254781185d-01, 5.7061885685816d-01, 8.3575298239037d-01,
     |   1.0994767944432d+00, 1.2876721543015d+00, 1.3160897083993d+00,
     |   1.1212821030444d+00, 6.9577812431017d-01, 1.1127714331297d-01,
     |  -4.8628869288319d-01,-9.1671398501677d-01,-1.0312629596153d+00,
     |  -7.7916715098526d-01,-2.4340805736218d-01, 3.7695486424567d-01,
     |   8.3830921358850d-01, 9.5184281742972d-01, 6.6762444561309d-01,
     |   1.0288360822440d-01,-5.0285625907466d-01,-8.8932576800902d-01,
     |  -8.8932576800902d-01,-5.0285625907467d-01, 1.0288360822440d-01,
     |   6.6762444561309d-01, 9.5184281742972d-01, 8.3830921358850d-01,
     |   3.7695486424567d-01,-2.4340805736217d-01,-7.7916715098526d-01,
     |  -1.0312629596153d+00,-9.1671398501677d-01,-4.8628869288319d-01,
     |   1.1127714331297d-01, 6.9577812431017d-01, 1.1212821030444d+00,
     |   1.3160897083993d+00, 1.2876721543015d+00, 1.0994767944432d+00,
     |   8.3575298239037d-01, 5.7061885685816d-01, 3.5095254781186d-01,
     |   1.9421795340590d-01, 9.6281536461348d-02, 4.2432569433282d-02,
     |   1.6440523856612d-02, 5.5140871883684d-03, 1.5674148674977d-03,
     |   3.6677915711320d-04, 6.7827093691231d-05, 9.3435268961275d-06,
     |   8.7671332430618d-07, 4.8500793431453d-08, 1.2259317142403d-09,
     |   8.4397063936885d-12, 4.1532559833027d-15, 2.9610642494255d-22/
      data (pmn(lat,16,21), lat = 1,72)/
     |   3.0086158848736d-24, 1.2684422643856d-16, 4.3127135626120d-13,
     |   8.8222391184420d-11, 4.5233864340056d-09, 1.0095223106353d-07,
     |   1.2873599781056d-06, 1.0943938457034d-05, 6.8250150208284d-05,
     |   3.3266166961796d-04, 1.3241984398945d-03, 4.4427466007586d-03,
     |   1.2857964702338d-02, 3.2661490105460d-02, 7.3770118364334d-02,
     |   1.4958309705134d-01, 2.7416564383527d-01, 4.5620663217204d-01,
     |   6.9045378438924d-01, 9.4948893335455d-01, 1.1805690764366d+00,
     |   1.3123843868683d+00, 1.2738676681039d+00, 1.0218078911517d+00,
     |   5.6792998720691d-01,-7.4517230249892d-03,-5.6612015723816d-01,
     |  -9.4955776067600d-01,-1.0338840400341d+00,-7.8197006606725d-01,
     |  -2.6946981064747d-01, 3.3091936144397d-01, 8.0622650477342d-01,
     |   9.8172367204198d-01, 7.9006006002618d-01, 3.0123817272186d-01,
     |  -3.0123817272186d-01,-7.9006006002618d-01,-9.8172367204198d-01,
     |  -8.0622650477342d-01,-3.3091936144398d-01, 2.6946981064747d-01,
     |   7.8197006606725d-01, 1.0338840400341d+00, 9.4955776067600d-01,
     |   5.6612015723816d-01, 7.4517230249918d-03,-5.6792998720691d-01,
     |  -1.0218078911517d+00,-1.2738676681039d+00,-1.3123843868683d+00,
     |  -1.1805690764366d+00,-9.4948893335455d-01,-6.9045378438924d-01,
     |  -4.5620663217204d-01,-2.7416564383527d-01,-1.4958309705135d-01,
     |  -7.3770118364334d-02,-3.2661490105460d-02,-1.2857964702338d-02,
     |  -4.4427466007586d-03,-1.3241984398945d-03,-3.3266166961796d-04,
     |  -6.8250150208285d-05,-1.0943938457034d-05,-1.2873599781056d-06,
     |  -1.0095223106354d-07,-4.5233864340056d-09,-8.8222391184420d-11,
     |  -4.3127135626120d-13,-1.2684422643856d-16,-3.0086158848736d-24/
      data (pmn(lat,17,21), lat = 1,72)/
     |   2.6616274955921d-26, 3.3723753867963d-18, 1.9177781024870d-14,
     |   5.5217005509609d-12, 3.6662883524943d-10, 1.0092289502859d-08,
     |   1.5380158521354d-07, 1.5287789274563d-06, 1.0974473953950d-05,
     |   6.0870460792452d-05, 2.7340537543196d-04, 1.0286933012271d-03,
     |   3.3245381547673d-03, 9.4051752538151d-03, 2.3630906079963d-02,
     |   5.3320940820012d-02, 1.0896671573376d-01, 2.0294982669847d-01,
     |   3.4598450739756d-01, 5.4119507484780d-01, 7.7705212818821d-01,
     |   1.0219228501440d+00, 1.2239231711989d+00, 1.3191735039640d+00,
     |   1.2489802221889d+00, 9.8237737943747d-01, 5.3643958869022d-01,
     |  -1.5023241127944d-02,-5.5164521407842d-01,-9.3659365739083d-01,
     |  -1.0592366010368d+00,-8.7606858245061d-01,-4.3358059932669d-01,
     |   1.3839098370327d-01, 6.6377117409208d-01, 9.7656305781973d-01,
     |   9.7656305781973d-01, 6.6377117409208d-01, 1.3839098370327d-01,
     |  -4.3358059932669d-01,-8.7606858245061d-01,-1.0592366010368d+00,
     |  -9.3659365739083d-01,-5.5164521407842d-01,-1.5023241127947d-02,
     |   5.3643958869022d-01, 9.8237737943747d-01, 1.2489802221889d+00,
     |   1.3191735039640d+00, 1.2239231711989d+00, 1.0219228501440d+00,
     |   7.7705212818822d-01, 5.4119507484780d-01, 3.4598450739757d-01,
     |   2.0294982669847d-01, 1.0896671573376d-01, 5.3320940820012d-02,
     |   2.3630906079963d-02, 9.4051752538151d-03, 3.3245381547673d-03,
     |   1.0286933012271d-03, 2.7340537543196d-04, 6.0870460792452d-05,
     |   1.0974473953950d-05, 1.5287789274563d-06, 1.5380158521354d-07,
     |   1.0092289502860d-08, 3.6662883524943d-10, 5.5217005509609d-12,
     |   1.9177781024870d-14, 3.3723753867963d-18, 2.6616274955921d-26/
      data (pmn(lat,18,21), lat = 1,72)/
     |   2.0150299374630d-28, 7.6716506708806d-20, 7.2945814406399d-16,
     |   2.9547271997881d-13, 2.5389922531378d-11, 8.6134124974590d-10,
     |   1.5670514138029d-08, 1.8189705897689d-07, 1.5007404869785d-06,
     |   9.4547084459439d-06, 4.7811614868329d-05, 2.0120215629202d-04,
     |   7.2377481462329d-04, 2.2714955653153d-03, 6.3184751847433d-03,
     |   1.5771087500886d-02, 3.5666950304361d-02, 7.3640280109525d-02,
     |   1.3961791335029d-01, 2.4412497008349d-01, 3.9480295877717d-01,
     |   5.9138481896563d-01, 8.2034636000335d-01, 1.0514135264290d+00,
     |   1.2385033469302d+00, 1.3269965740682d+00, 1.2673147509530d+00,
     |   1.0320351603645d+00, 6.3125122102864d-01, 1.1985433837852d-01,
     |  -4.0818232462310d-01,-8.3957419909487d-01,-1.0714203838444d+00,
     |  -1.0421791582897d+00,-7.5348519757878d-01,-2.7444256035255d-01,
     |   2.7444256035255d-01, 7.5348519757877d-01, 1.0421791582897d+00,
     |   1.0714203838444d+00, 8.3957419909487d-01, 4.0818232462310d-01,
     |  -1.1985433837852d-01,-6.3125122102864d-01,-1.0320351603645d+00,
     |  -1.2673147509530d+00,-1.3269965740682d+00,-1.2385033469302d+00,
     |  -1.0514135264290d+00,-8.2034636000335d-01,-5.9138481896563d-01,
     |  -3.9480295877717d-01,-2.4412497008349d-01,-1.3961791335029d-01,
     |  -7.3640280109526d-02,-3.5666950304361d-02,-1.5771087500886d-02,
     |  -6.3184751847433d-03,-2.2714955653153d-03,-7.2377481462329d-04,
     |  -2.0120215629202d-04,-4.7811614868329d-05,-9.4547084459440d-06,
     |  -1.5007404869786d-06,-1.8189705897689d-07,-1.5670514138029d-08,
     |  -8.6134124974593d-10,-2.5389922531378d-11,-2.9547271997881d-13,
     |  -7.2945814406399d-16,-7.6716506708806d-20,-2.0150299374630d-28/
      data (pmn(lat,19,21), lat = 1,72)/
     |   1.2675233708757d-30, 1.4498594387773d-21, 2.3044821469986d-17,
     |   1.3126842920589d-14, 1.4590127784445d-12, 6.0956599011522d-11,
     |   1.3227827266952d-09, 1.7911417201373d-08, 1.6962818000853d-07,
     |   1.2119939990040d-06, 6.8878905653074d-06, 3.2350000633632d-05,
     |   1.2919999555452d-04, 4.4845692116233d-04, 1.3760013504859d-03,
     |   3.7824717747984d-03, 9.4152770357976d-03, 2.1405045324526d-02,
     |   4.4752365927975d-02, 8.6520298387477d-02, 1.5534192213354d-01,
     |   2.5985365051998d-01, 4.0587787690896d-01, 5.9263674357654d-01,
     |   8.0889724429789d-01, 1.0305028321176d+00, 1.2209299773152d+00,
     |   1.3360555356950d+00, 1.3331712624804d+00, 1.1826870733048d+00,
     |   8.7947117720447d-01, 4.5004830684728d-01,-4.7582972948498d-02,
     |  -5.3288305011169d-01,-9.1911463333882d-01,-1.1331329520403d+00,
     |  -1.1331329520403d+00,-9.1911463333883d-01,-5.3288305011169d-01,
     |  -4.7582972948499d-02, 4.5004830684728d-01, 8.7947117720447d-01,
     |   1.1826870733048d+00, 1.3331712624804d+00, 1.3360555356950d+00,
     |   1.2209299773152d+00, 1.0305028321176d+00, 8.0889724429789d-01,
     |   5.9263674357655d-01, 4.0587787690896d-01, 2.5985365051998d-01,
     |   1.5534192213354d-01, 8.6520298387477d-02, 4.4752365927975d-02,
     |   2.1405045324526d-02, 9.4152770357976d-03, 3.7824717747984d-03,
     |   1.3760013504858d-03, 4.4845692116233d-04, 1.2919999555452d-04,
     |   3.2350000633632d-05, 6.8878905653074d-06, 1.2119939990040d-06,
     |   1.6962818000853d-07, 1.7911417201373d-08, 1.3227827266952d-09,
     |   6.0956599011524d-11, 1.4590127784445d-12, 1.3126842920589d-14,
     |   2.3044821469986d-17, 1.4498594387773d-21, 1.2675233708757d-30/
      data (pmn(lat,20,21), lat = 1,72)/
     |   6.2612979579267d-33, 2.1515372161298d-23, 5.7152506879874d-19,
     |   4.5766180292985d-16, 6.5765422281657d-14, 3.3818120424096d-12,
     |   8.7469731488582d-11, 1.3804193456951d-09, 1.4990087345220d-08,
     |   1.2131588332157d-07, 7.7367162674747d-07, 4.0482948603822d-06,
     |   1.7913569262711d-05, 6.8601705870446d-05, 2.3151706652192d-04,
     |   6.9849644569283d-04, 1.9058975843440d-03, 4.7475868020279d-03,
     |   1.0880052067600d-02, 2.3084939765050d-02, 4.5586472817124d-02,
     |   8.4142408190372d-02, 1.4567189328012d-01, 2.3719945749659d-01,
     |   3.6402340420409d-01, 5.2726809414318d-01, 7.2130562910894d-01,
     |   9.3182534517471d-01, 1.1354475118390d+00, 1.3016002584593d+00,
     |   1.3968717844327d+00, 1.3913092570208d+00, 1.2653819490752d+00,
     |   1.0158390271231d+00, 6.5870444802401d-01, 2.2824161849691d-01,
     |  -2.2824161849691d-01,-6.5870444802401d-01,-1.0158390271231d+00,
     |  -1.2653819490752d+00,-1.3913092570208d+00,-1.3968717844327d+00,
     |  -1.3016002584593d+00,-1.1354475118390d+00,-9.3182534517471d-01,
     |  -7.2130562910894d-01,-5.2726809414318d-01,-3.6402340420409d-01,
     |  -2.3719945749659d-01,-1.4567189328012d-01,-8.4142408190372d-02,
     |  -4.5586472817124d-02,-2.3084939765050d-02,-1.0880052067600d-02,
     |  -4.7475868020279d-03,-1.9058975843440d-03,-6.9849644569284d-04,
     |  -2.3151706652192d-04,-6.8601705870446d-05,-1.7913569262711d-05,
     |  -4.0482948603822d-06,-7.7367162674747d-07,-1.2131588332157d-07,
     |  -1.4990087345220d-08,-1.3804193456951d-09,-8.7469731488582d-11,
     |  -3.3818120424097d-12,-6.5765422281657d-14,-4.5766180292985d-16,
     |  -5.7152506879874d-19,-2.1515372161298d-23,-6.2612979579267d-33/
      data (pmn(lat,21,21), lat = 1,72)/
     |   2.1081233429216d-35, 2.1759734895064d-25, 9.6581822618407d-21,
     |   1.0869265106532d-17, 2.0185278884837d-15, 1.2768974729604d-13,
     |   3.9339796072256d-12, 7.2304887314612d-11, 8.9948455407368d-10,
     |   8.2367539005299d-09, 5.8871762000051d-08, 3.4270320593994d-07,
     |   1.6773114649452d-06, 7.0729869501979d-06, 2.6193817101481d-05,
     |   8.6502869401522d-05, 2.5790683505592d-04, 7.0128182143373d-04,
     |   1.7537271112757d-03, 4.0617778124448d-03, 8.7643636108853d-03,
     |   1.7707198973579d-02, 3.3640197176071d-02, 6.0316038915991d-02,
     |   1.0238444636333d-01, 1.6498020453962d-01, 2.5294820715412d-01,
     |   3.6973935718962d-01, 5.1613243966808d-01, 6.8905521634527d-01,
     |   8.8084743393218d-01, 1.0792877387147d+00, 1.2685769910727d+00,
     |   1.4312499720200d+00, 1.5507313559485d+00, 1.6140385448993d+00,
     |   1.6140385448993d+00, 1.5507313559485d+00, 1.4312499720200d+00,
     |   1.2685769910727d+00, 1.0792877387147d+00, 8.8084743393218d-01,
     |   6.8905521634527d-01, 5.1613243966808d-01, 3.6973935718962d-01,
     |   2.5294820715412d-01, 1.6498020453962d-01, 1.0238444636333d-01,
     |   6.0316038915991d-02, 3.3640197176071d-02, 1.7707198973579d-02,
     |   8.7643636108854d-03, 4.0617778124448d-03, 1.7537271112757d-03,
     |   7.0128182143374d-04, 2.5790683505592d-04, 8.6502869401522d-05,
     |   2.6193817101481d-05, 7.0729869501979d-06, 1.6773114649452d-06,
     |   3.4270320593994d-07, 5.8871762000051d-08, 8.2367539005300d-09,
     |   8.9948455407370d-10, 7.2304887314613d-11, 3.9339796072256d-12,
     |   1.2768974729604d-13, 2.0185278884837d-15, 1.0869265106532d-17,
     |   9.6581822618407d-21, 2.1759734895064d-25, 2.1081233429216d-35/
      data (pmn(lat, 0,22), lat = 1,72)/
     |   4.4620823216104d+00, 2.5005884430730d+00,-1.2132115296879d-01,
     |  -1.7610609493730d+00,-1.6108740423561d+00,-1.9632276719731d-01,
     |   1.1459838733590d+00, 1.3515861595035d+00, 4.0229369266068d-01,
     |  -7.8475083657224d-01,-1.1944621541622d+00,-5.5223433190678d-01,
     |   5.1303624127197d-01, 1.0639775804049d+00, 6.6405785225811d-01,
     |  -2.8599544529447d-01,-9.3821761941132d-01,-7.4501556569608d-01,
     |   8.7035832599654d-02, 8.0923982276171d-01, 7.9853613313567d-01,
     |   9.0665296367089d-02,-6.7421575255476d-01,-8.2647904968503d-01,
     |  -2.4980213675157d-01, 5.3261672476786d-01, 8.3003909627996d-01,
     |   3.9111443692956d-01,-3.8510050910922d-01,-8.1015670551378d-01,
     |  -5.1436730783691d-01, 2.3299044286894d-01, 7.6771406859311d-01,
     |   6.1884547037337d-01,-7.7991433397348d-02,-7.0362274186446d-01,
     |  -7.0362274186446d-01,-7.7991433397351d-02, 6.1884547037336d-01,
     |   7.6771406859311d-01, 2.3299044286895d-01,-5.1436730783691d-01,
     |  -8.1015670551378d-01,-3.8510050910923d-01, 3.9111443692956d-01,
     |   8.3003909627996d-01, 5.3261672476786d-01,-2.4980213675157d-01,
     |  -8.2647904968503d-01,-6.7421575255476d-01, 9.0665296367089d-02,
     |   7.9853613313567d-01, 8.0923982276171d-01, 8.7035832599659d-02,
     |  -7.4501556569608d-01,-9.3821761941132d-01,-2.8599544529447d-01,
     |   6.6405785225811d-01, 1.0639775804049d+00, 5.1303624127198d-01,
     |  -5.5223433190678d-01,-1.1944621541622d+00,-7.8475083657224d-01,
     |   4.0229369266067d-01, 1.3515861595035d+00, 1.1459838733590d+00,
     |  -1.9632276719730d-01,-1.6108740423561d+00,-1.7610609493730d+00,
     |  -1.2132115296879d-01, 2.5005884430730d+00, 4.4620823216104d+00/
      data (pmn(lat, 1,22), lat = 1,72)/
     |   1.1292771159040d+00, 2.6283230855145d+00, 2.4129048130896d+00,
     |   7.8179316560614d-01,-9.8841075914521d-01,-1.6461964636556d+00,
     |  -8.9350024690520d-01, 4.7528547140528d-01, 1.2870637006813d+00,
     |   9.4325539387582d-01,-1.5800418681653d-01,-1.0322080879236d+00,
     |  -9.6362145566782d-01,-7.8481935336640d-02, 8.1766429333037d-01,
     |   9.5971127907397d-01, 2.6757564866838d-01,-6.2197395033435d-01,
     |  -9.3333180786603d-01,-4.2215812953652d-01, 4.3677692186050d-01,
     |   8.8571292163373d-01, 5.4783918999638d-01,-2.5895950346865d-01,
     |  -8.1806094309308d-01,-6.4715484007070d-01, 8.7862680761538d-02,
     |   7.3170646097672d-01, 7.2122185362452d-01, 7.5912420738663d-02,
     |  -6.2813982453951d-01,-7.7048828328928d-01,-2.3109128751255d-01,
     |   5.0900190104435d-01, 7.9510362235906d-01, 3.7604842247600d-01,
     |  -3.7604842247600d-01,-7.9510362235906d-01,-5.0900190104436d-01,
     |   2.3109128751255d-01, 7.7048828328928d-01, 6.2813982453951d-01,
     |  -7.5912420738660d-02,-7.2122185362451d-01,-7.3170646097672d-01,
     |  -8.7862680761540d-02, 6.4715484007070d-01, 8.1806094309308d-01,
     |   2.5895950346865d-01,-5.4783918999638d-01,-8.8571292163373d-01,
     |  -4.3677692186051d-01, 4.2215812953651d-01, 9.3333180786603d-01,
     |   6.2197395033435d-01,-2.6757564866837d-01,-9.5971127907397d-01,
     |  -8.1766429333037d-01, 7.8481935336643d-02, 9.6362145566781d-01,
     |   1.0322080879236d+00, 1.5800418681653d-01,-9.4325539387581d-01,
     |  -1.2870637006813d+00,-4.7528547140529d-01, 8.9350024690520d-01,
     |   1.6461964636556d+00, 9.8841075914521d-01,-7.8179316560614d-01,
     |  -2.4129048130896d+00,-2.6283230855145d+00,-1.1292771159040d+00/
      data (pmn(lat, 2,22), lat = 1,72)/
     |   1.3968921982750d-01, 1.0668880020635d+00, 2.0843350134599d+00,
     |   2.2170598414930d+00, 1.1713865426243d+00,-4.0261694132345d-01,
     |  -1.4213483240390d+00,-1.2295303167681d+00,-1.0824148059589d-01,
     |   9.7728329065768d-01, 1.1682862007435d+00, 3.8571455662651d-01,
     |  -6.5552335848332d-01,-1.0765504150394d+00,-5.6602836307167d-01,
     |   3.9309048055603d-01, 9.6725881652594d-01, 6.8861042999651d-01,
     |  -1.6680505986124d-01,-8.4382593097496d-01,-7.6888943719611d-01,
     |  -3.2989045882203d-02, 7.0816287948630d-01, 8.1411807847286d-01,
     |   2.1031468249892d-01,-5.6210383769646d-01,-8.2824021714090d-01,
     |  -3.6654039875629d-01, 4.0767430299017d-01, 8.1373374884492d-01,
     |   5.0169375220019d-01,-2.4710572244915d-01,-7.7240448318937d-01,
     |  -6.1510598345087d-01, 8.2788695377637d-02, 7.0574843212289d-01,
     |   7.0574843212289d-01, 8.2788695377639d-02,-6.1510598345087d-01,
     |  -7.7240448318937d-01,-2.4710572244915d-01, 5.0169375220020d-01,
     |   8.1373374884492d-01, 4.0767430299018d-01,-3.6654039875629d-01,
     |  -8.2824021714090d-01,-5.6210383769647d-01, 2.1031468249892d-01,
     |   8.1411807847286d-01, 7.0816287948630d-01,-3.2989045882203d-02,
     |  -7.6888943719611d-01,-8.4382593097496d-01,-1.6680505986125d-01,
     |   6.8861042999651d-01, 9.6725881652594d-01, 3.9309048055604d-01,
     |  -5.6602836307167d-01,-1.0765504150394d+00,-6.5552335848333d-01,
     |   3.8571455662651d-01, 1.1682862007435d+00, 9.7728329065769d-01,
     |  -1.0824148059588d-01,-1.2295303167681d+00,-1.4213483240390d+00,
     |  -4.0261694132347d-01, 1.1713865426243d+00, 2.2170598414930d+00,
     |   2.0843350134599d+00, 1.0668880020635d+00, 1.3968921982750d-01/
      data (pmn(lat, 3,22), lat = 1,72)/
     |   1.1415434191024d-02, 2.7300398320890d-01, 9.8199742188452d-01,
     |   1.7918356557946d+00, 2.0458053276629d+00, 1.3584372529877d+00,
     |   2.4745672265554d-02,-1.1251201070918d+00,-1.3419931210384d+00,
     |  -5.4970825026433d-01, 5.8242350252254d-01, 1.1620967500245d+00,
     |   7.7422385877957d-01,-2.0941989190077d-01,-9.5902178291374d-01,
     |  -8.7592786195534d-01,-7.1342609226689d-02, 7.5313488148755d-01,
     |   9.0849307347562d-01, 2.9146540475827d-01,-5.4891057693379d-01,
     |  -8.9357569862047d-01,-4.6538129358483d-01, 3.4836607929907d-01,
     |   8.4196693286906d-01, 6.0015144957125d-01,-1.5340544187726d-01,
     |  -7.6012574486900d-01,-6.9934561473709d-01,-3.3787102753435d-02,
     |   6.5260801343669d-01, 7.6477145125489d-01, 2.1074711962066d-01,
     |  -5.2308448134341d-01,-7.9730702283610d-01,-3.7479487602789d-01,
     |   3.7479487602789d-01, 7.9730702283610d-01, 5.2308448134341d-01,
     |  -2.1074711962066d-01,-7.6477145125489d-01,-6.5260801343669d-01,
     |   3.3787102753432d-02, 6.9934561473709d-01, 7.6012574486901d-01,
     |   1.5340544187727d-01,-6.0015144957125d-01,-8.4196693286906d-01,
     |  -3.4836607929908d-01, 4.6538129358483d-01, 8.9357569862047d-01,
     |   5.4891057693380d-01,-2.9146540475827d-01,-9.0849307347562d-01,
     |  -7.5313488148755d-01, 7.1342609226683d-02, 8.7592786195534d-01,
     |   9.5902178291373d-01, 2.0941989190076d-01,-7.7422385877956d-01,
     |  -1.1620967500245d+00,-5.8242350252254d-01, 5.4970825026433d-01,
     |   1.3419931210384d+00, 1.1251201070918d+00,-2.4745672265554d-02,
     |  -1.3584372529877d+00,-2.0458053276629d+00,-1.7918356557946d+00,
     |  -9.8199742188452d-01,-2.7300398320890d-01,-1.1415434191024d-02/
      data (pmn(lat, 4,22), lat = 1,72)/
     |   6.9403692238623d-04, 5.1069408377090d-02, 3.2359142831195d-01,
     |   9.1223760168995d-01, 1.5979740448300d+00, 1.9036905746790d+00,
     |   1.4528725420267d+00, 3.4221695554956d-01,-8.2269114094161d-01,
     |  -1.3204541813260d+00,-8.5653516424416d-01, 1.8377017760461d-01,
     |   1.0039199716585d+00, 9.9846010932272d-01, 2.1637320868414d-01,
     |  -6.9009245466569d-01,-9.9507596316467d-01,-4.8039837734408d-01,
     |   4.0259099414407d-01, 9.1793708027349d-01, 6.5461774908269d-01,
     |  -1.4368340919892d-01,-7.9639441161601d-01,-7.6198087324441d-01,
     |  -8.6891765487172d-02, 6.4540286497206d-01, 8.1503302127213d-01,
     |   2.8896247900103d-01,-4.7422825047294d-01,-8.2131904328493d-01,
     |  -4.6162193891077d-01, 2.8966772441030d-01, 7.8583752192161d-01,
     |   6.0336536857627d-01,-9.7397205829895d-02,-7.1222910635636d-01,
     |  -7.1222910635637d-01,-9.7397205829897d-02, 6.0336536857627d-01,
     |   7.8583752192161d-01, 2.8966772441030d-01,-4.6162193891078d-01,
     |  -8.2131904328493d-01,-4.7422825047294d-01, 2.8896247900103d-01,
     |   8.1503302127212d-01, 6.4540286497207d-01,-8.6891765487167d-02,
     |  -7.6198087324440d-01,-7.9639441161601d-01,-1.4368340919892d-01,
     |   6.5461774908268d-01, 9.1793708027349d-01, 4.0259099414408d-01,
     |  -4.8039837734408d-01,-9.9507596316467d-01,-6.9009245466569d-01,
     |   2.1637320868414d-01, 9.9846010932272d-01, 1.0039199716586d+00,
     |   1.8377017760461d-01,-8.5653516424416d-01,-1.3204541813260d+00,
     |  -8.2269114094162d-01, 3.4221695554955d-01, 1.4528725420267d+00,
     |   1.9036905746790d+00, 1.5979740448300d+00, 9.1223760168995d-01,
     |   3.2359142831195d-01, 5.1069408377090d-02, 6.9403692238623d-04/
      data (pmn(lat, 5,22), lat = 1,72)/
     |   3.3448686265894d-05, 7.5086864827375d-03, 8.2173778303030d-02,
     |   3.4427511090660d-01, 8.5270223277193d-01, 1.4535976683026d+00,
     |   1.7838925696949d+00, 1.5001833370114d+00, 5.8528805054188d-01,
     |  -5.3479649605513d-01,-1.2174899016060d+00,-1.0500663452820d+00,
     |  -1.8020596476134d-01, 7.5339949160982d-01, 1.0739692951831d+00,
     |   5.7108359442390d-01,-3.3982880851158d-01,-9.4141624110035d-01,
     |  -7.7608414670686d-01,-1.7268295201995d-03, 7.4406596752406d-01,
     |   8.6266892660268d-01, 2.7609134760727d-01,-5.1901393648596d-01,
     |  -8.6616742261122d-01,-4.8957193195092d-01, 2.8480268239061d-01,
     |   8.0713453607074d-01, 6.4666087874538d-01,-5.2808525437415d-02,
     |  -6.9894844201775d-01,-7.5013115129169d-01,-1.6858264426548d-01,
     |   5.5135145772843d-01, 8.0152585333411d-01, 3.7222742228717d-01,
     |  -3.7222742228716d-01,-8.0152585333411d-01,-5.5135145772843d-01,
     |   1.6858264426548d-01, 7.5013115129169d-01, 6.9894844201775d-01,
     |   5.2808525437418d-02,-6.4666087874538d-01,-8.0713453607074d-01,
     |  -2.8480268239061d-01, 4.8957193195092d-01, 8.6616742261122d-01,
     |   5.1901393648596d-01,-2.7609134760727d-01,-8.6266892660268d-01,
     |  -7.4406596752407d-01, 1.7268295201965d-03, 7.7608414670686d-01,
     |   9.4141624110035d-01, 3.3982880851159d-01,-5.7108359442390d-01,
     |  -1.0739692951831d+00,-7.5339949160981d-01, 1.8020596476133d-01,
     |   1.0500663452820d+00, 1.2174899016060d+00, 5.3479649605514d-01,
     |  -5.8528805054187d-01,-1.5001833370114d+00,-1.7838925696949d+00,
     |  -1.4535976683026d+00,-8.5270223277193d-01,-3.4427511090660d-01,
     |  -8.2173778303030d-02,-7.5086864827375d-03,-3.3448686265894d-05/
      data (pmn(lat, 6,22), lat = 1,72)/
     |   1.3287081583758d-06, 9.0561789816410d-04, 1.6937341950078d-02,
     |   1.0346149319512d-01, 3.5019013838160d-01, 7.9917769711321d-01,
     |   1.3371612349932d+00, 1.6798345815444d+00, 1.5211336821171d+00,
     |   7.7716671112418d-01,-2.6609860039820d-01,-1.0629793092566d+00,
     |  -1.1505266242323d+00,-4.9208558476616d-01, 4.5271418543043d-01,
     |   1.0234445360826d+00, 8.2786355542170d-01, 3.4670258066272d-02,
     |  -7.4732341793737d-01,-9.2822327876496d-01,-3.8774304086985d-01,
     |   4.3510679835371d-01, 8.8927192706802d-01, 6.2558829011652d-01,
     |  -1.3000585127007d-01,-7.6280640162041d-01,-7.6611121735968d-01,
     |  -1.4811652709695d-01, 5.7979681184254d-01, 8.2284646185222d-01,
     |   3.8805350228744d-01,-3.6108509540473d-01,-8.0594216195584d-01,
     |  -5.8199388473548d-01, 1.2249424503345d-01, 7.2339434579464d-01,
     |   7.2339434579464d-01, 1.2249424503346d-01,-5.8199388473548d-01,
     |  -8.0594216195584d-01,-3.6108509540473d-01, 3.8805350228744d-01,
     |   8.2284646185222d-01, 5.7979681184255d-01,-1.4811652709695d-01,
     |  -7.6611121735968d-01,-7.6280640162042d-01,-1.3000585127008d-01,
     |   6.2558829011652d-01, 8.8927192706802d-01, 4.3510679835371d-01,
     |  -3.8774304086984d-01,-9.2822327876496d-01,-7.4732341793737d-01,
     |   3.4670258066270d-02, 8.2786355542170d-01, 1.0234445360826d+00,
     |   4.5271418543043d-01,-4.9208558476616d-01,-1.1505266242323d+00,
     |  -1.0629793092566d+00,-2.6609860039820d-01, 7.7716671112417d-01,
     |   1.5211336821171d+00, 1.6798345815443d+00, 1.3371612349932d+00,
     |   7.9917769711322d-01, 3.5019013838160d-01, 1.0346149319512d-01,
     |   1.6937341950078d-02, 9.0561789816410d-04, 1.3287081583758d-06/
      data (pmn(lat, 7,22), lat = 1,72)/
     |   4.4651159387614d-08, 9.2128591133632d-05, 2.9258622873533d-03,
     |   2.5774755905330d-02, 1.1710552443503d-01, 3.4715182720605d-01,
     |   7.4887064806974d-01, 1.2373558598612d+00, 1.5862832810834d+00,
     |   1.5256186063490d+00, 9.3253221602835d-01,-1.5826917712809d-02,
     |  -8.7371886725265d-01,-1.1733500593943d+00,-7.4380977082824d-01,
     |   1.3196682989142d-01, 8.7008288035470d-01, 9.7368801830368d-01,
     |   3.8751268177698d-01,-4.5173569383803d-01,-9.2698941789580d-01,
     |  -6.9602381864141d-01, 5.1377629212610d-02, 7.3716141115186d-01,
     |   8.3756295908731d-01, 2.8630064706045d-01,-4.7625399372321d-01,
     |  -8.4959280011231d-01,-5.4532689249522d-01, 1.8709735964884d-01,
     |   7.6082758446728d-01, 7.1975689773471d-01, 1.0164418311573d-01,
     |  -5.9394342935287d-01,-8.0735157752023d-01,-3.6821664779781d-01,
     |   3.6821664779781d-01, 8.0735157752023d-01, 5.9394342935287d-01,
     |  -1.0164418311572d-01,-7.1975689773471d-01,-7.6082758446728d-01,
     |  -1.8709735964884d-01, 5.4532689249522d-01, 8.4959280011231d-01,
     |   4.7625399372321d-01,-2.8630064706045d-01,-8.3756295908731d-01,
     |  -7.3716141115187d-01,-5.1377629212610d-02, 6.9602381864141d-01,
     |   9.2698941789580d-01, 4.5173569383803d-01,-3.8751268177698d-01,
     |  -9.7368801830368d-01,-8.7008288035470d-01,-1.3196682989142d-01,
     |   7.4380977082824d-01, 1.1733500593943d+00, 8.7371886725266d-01,
     |   1.5826917712809d-02,-9.3253221602835d-01,-1.5256186063490d+00,
     |  -1.5862832810834d+00,-1.2373558598612d+00,-7.4887064806974d-01,
     |  -3.4715182720606d-01,-1.1710552443503d-01,-2.5774755905330d-02,
     |  -2.9258622873533d-03,-9.2128591133632d-05,-4.4651159387614d-08/
      data (pmn(lat, 8,22), lat = 1,72)/
     |   1.2926685615499d-09, 8.0583275129460d-06, 4.3277285003306d-04,
     |   5.4602373187162d-03, 3.2945648892015d-02, 1.2477509521098d-01,
     |   3.3782208882750d-01, 6.9989972251413d-01, 1.1474677763439d+00,
     |   1.4990930168446d+00, 1.5181947955252d+00, 1.0603487527863d+00,
     |   2.1803798382410d-01,-6.5924727478907d-01,-1.1291911409549d+00,
     |  -9.3072639308677d-01,-1.8586421845764d-01, 6.3606464032354d-01,
     |   1.0036822966373d+00, 6.8109841994785d-01,-9.7278404797882d-02,
     |  -7.7863431714808d-01,-8.8034282605545d-01,-3.4002864502806d-01,
     |   4.3526903462216d-01, 8.6776062721912d-01, 6.3963681340516d-01,
     |  -6.7642417036821d-02,-7.1091549644078d-01,-7.9955771803575d-01,
     |  -2.7117553064963d-01, 4.6114537584313d-01, 8.2870788597565d-01,
     |   5.4804869968967d-01,-1.5930830312277d-01,-7.3986347040782d-01,
     |  -7.3986347040782d-01,-1.5930830312277d-01, 5.4804869968966d-01,
     |   8.2870788597565d-01, 4.6114537584314d-01,-2.7117553064964d-01,
     |  -7.9955771803575d-01,-7.1091549644078d-01,-6.7642417036824d-02,
     |   6.3963681340516d-01, 8.6776062721912d-01, 4.3526903462217d-01,
     |  -3.4002864502806d-01,-8.8034282605545d-01,-7.7863431714808d-01,
     |  -9.7278404797893d-02, 6.8109841994785d-01, 1.0036822966373d+00,
     |   6.3606464032355d-01,-1.8586421845764d-01,-9.3072639308677d-01,
     |  -1.1291911409549d+00,-6.5924727478907d-01, 2.1803798382409d-01,
     |   1.0603487527863d+00, 1.5181947955252d+00, 1.4990930168446d+00,
     |   1.1474677763439d+00, 6.9989972251413d-01, 3.3782208882750d-01,
     |   1.2477509521098d-01, 3.2945648892015d-02, 5.4602373187162d-03,
     |   4.3277285003306d-04, 8.0583275129460d-06, 1.2926685615499d-09/
      data (pmn(lat, 9,22), lat = 1,72)/
     |   3.2662915333279d-11, 6.1435074225176d-07, 5.5634694030373d-05,
     |   1.0006670712701d-03, 7.9624984051834d-03, 3.8133250712079d-02,
     |   1.2760228564959d-01, 3.2358449629145d-01, 6.5095775514495d-01,
     |   1.0631337400075d+00, 1.4148700621656d+00, 1.5005236289410d+00,
     |   1.1656416390183d+00, 4.3702428181196d-01,-4.2537859089941d-01,
     |  -1.0250255710144d+00,-1.0487493444919d+00,-4.8116611832439d-01,
     |   3.4333977288608d-01, 9.1873392979230d-01, 8.8395924646528d-01,
     |   2.7025834564677d-01,-5.0408834358963d-01,-9.0909658585684d-01,
     |  -6.6946038917843d-01, 3.7132119962742d-02, 7.0111157820351d-01,
     |   8.4490910545162d-01, 3.6994580431414d-01,-3.6950293667730d-01,
     |  -8.2568834301548d-01,-6.6245524056343d-01,-5.5390529990214d-03,
     |   6.5089028344659d-01, 8.1407952484239d-01, 3.6254372659814d-01,
     |  -3.6254372659814d-01,-8.1407952484239d-01,-6.5089028344659d-01,
     |   5.5390529990198d-03, 6.6245524056342d-01, 8.2568834301548d-01,
     |   3.6950293667730d-01,-3.6994580431413d-01,-8.4490910545162d-01,
     |  -7.0111157820351d-01,-3.7132119962745d-02, 6.6946038917843d-01,
     |   9.0909658585684d-01, 5.0408834358963d-01,-2.7025834564677d-01,
     |  -8.8395924646528d-01,-9.1873392979230d-01,-3.4333977288609d-01,
     |   4.8116611832439d-01, 1.0487493444919d+00, 1.0250255710144d+00,
     |   4.2537859089940d-01,-4.3702428181196d-01,-1.1656416390183d+00,
     |  -1.5005236289410d+00,-1.4148700621656d+00,-1.0631337400075d+00,
     |  -6.5095775514496d-01,-3.2358449629145d-01,-1.2760228564959d-01,
     |  -3.8133250712080d-02,-7.9624984051834d-03,-1.0006670712701d-03,
     |  -5.5634694030373d-05,-6.1435074225176d-07,-3.2662915333279d-11/
      data (pmn(lat,10,22), lat = 1,72)/
     |   7.2713341979722d-13, 4.1223986413034d-08, 6.2820530865906d-06,
     |   1.6054981263486d-04, 1.6766736804252d-03, 1.0084352083554d-02,
     |   4.1300587303231d-02, 1.2638252058539d-01, 3.0525564409390d-01,
     |   6.0112972590231d-01, 9.8132895156256d-01, 1.3307357049597d+00,
     |   1.4725483375394d+00, 1.2505754148461d+00, 6.4137257477827d-01,
     |  -1.7646943471084d-01,-8.6553907171493d-01,-1.0932646406977d+00,
     |  -7.3510234397598d-01, 1.5377869986309d-02, 7.2546839413352d-01,
     |   9.7018349513709d-01, 6.0193481682572d-01,-1.3953941957921d-01,
     |  -7.6871781415371d-01,-8.7017514860515d-01,-3.8107345414843d-01,
     |   3.5905830388936d-01, 8.3695991608014d-01, 7.2162472862808d-01,
     |   9.8671209808784d-02,-5.8730691195958d-01,-8.4719919437535d-01,
     |  -4.9687015386352d-01, 2.0980766019109d-01, 7.6268203078521d-01,
     |   7.6268203078522d-01, 2.0980766019109d-01,-4.9687015386351d-01,
     |  -8.4719919437535d-01,-5.8730691195958d-01, 9.8671209808785d-02,
     |   7.2162472862808d-01, 8.3695991608014d-01, 3.5905830388936d-01,
     |  -3.8107345414843d-01,-8.7017514860515d-01,-7.6871781415371d-01,
     |  -1.3953941957922d-01, 6.0193481682572d-01, 9.7018349513709d-01,
     |   7.2546839413353d-01, 1.5377869986311d-02,-7.3510234397598d-01,
     |  -1.0932646406977d+00,-8.6553907171493d-01,-1.7646943471085d-01,
     |   6.4137257477827d-01, 1.2505754148461d+00, 1.4725483375394d+00,
     |   1.3307357049597d+00, 9.8132895156256d-01, 6.0112972590231d-01,
     |   3.0525564409391d-01, 1.2638252058539d-01, 4.1300587303231d-02,
     |   1.0084352083554d-02, 1.6766736804252d-03, 1.6054981263486d-04,
     |   6.2820530865906d-06, 4.1223986413034d-08, 7.2713341979722d-13/
      data (pmn(lat,11,22), lat = 1,72)/
     |   1.4356277292018d-14, 2.4514951874283d-09, 6.2768547740900d-07,
     |   2.2738676617529d-05, 3.1057765001732d-04, 2.3346099647573d-03,
     |   1.1624857271859d-02, 4.2531358813357d-02, 1.2172447896908d-01,
     |   2.8340386731249d-01, 5.4980417791797d-01, 8.9988175399781d-01,
     |   1.2441952709026d+00, 1.4331229231179d+00, 1.3151166729367d+00,
     |   8.2960717718729d-01, 8.2976444336229d-02,-6.5462540847028d-01,
     |  -1.0591557286518d+00,-9.2809454943323d-01,-3.2082329282433d-01,
     |   4.3795272029702d-01, 9.2088725139579d-01, 8.4666963256431d-01,
     |   2.6230007878217d-01,-4.6934298647322d-01,-8.8711939833986d-01,
     |  -7.2564882568146d-01,-9.3631902824308d-02, 5.9011294243876d-01,
     |   8.7054856550447d-01, 5.6156671996930d-01,-1.2537613558357d-01,
     |  -7.2181472494844d-01,-8.2056308003009d-01,-3.5486048668605d-01,
     |   3.5486048668605d-01, 8.2056308003009d-01, 7.2181472494844d-01,
     |   1.2537613558357d-01,-5.6156671996930d-01,-8.7054856550447d-01,
     |  -5.9011294243876d-01, 9.3631902824302d-02, 7.2564882568146d-01,
     |   8.8711939833986d-01, 4.6934298647322d-01,-2.6230007878217d-01,
     |  -8.4666963256430d-01,-9.2088725139579d-01,-4.3795272029702d-01,
     |   3.2082329282432d-01, 9.2809454943323d-01, 1.0591557286518d+00,
     |   6.5462540847028d-01,-8.2976444336223d-02,-8.2960717718729d-01,
     |  -1.3151166729367d+00,-1.4331229231179d+00,-1.2441952709026d+00,
     |  -8.9988175399781d-01,-5.4980417791797d-01,-2.8340386731249d-01,
     |  -1.2172447896908d-01,-4.2531358813357d-02,-1.1624857271859d-02,
     |  -2.3346099647573d-03,-3.1057765001732d-04,-2.2738676617529d-05,
     |  -6.2768547740900d-07,-2.4514951874283d-09,-1.4356277292018d-14/
      data (pmn(lat,12,22), lat = 1,72)/
     |   2.5248681740741d-16, 1.2978805721421d-10, 5.5769767610106d-08,
     |   2.8585259388539d-06, 5.0931033624677d-05, 4.7679225264220d-04,
     |   2.8727539124307d-03, 1.2486278613057d-02, 4.1977018636321d-02,
     |   1.1414833408009d-01, 2.5851474644497d-01, 4.9664133868036d-01,
     |   8.1724704993972d-01, 1.1531005856343d+00, 1.3804115649929d+00,
     |   1.3574802204644d+00, 9.9826741850372d-01, 3.4703916060106d-01,
     |  -3.9701531475280d-01,-9.4172999834530d-01,-1.0394172473971d+00,
     |  -6.3300649195157d-01, 8.0594660279777d-02, 7.2804797708965d-01,
     |   9.5470685537112d-01, 6.3210201486498d-01,-5.1928806025647d-02,
     |  -6.9048460400338d-01,-8.9738161540822d-01,-5.4687719277948d-01,
     |   1.4080034336572d-01, 7.3140587434663d-01, 8.4980838349080d-01,
     |   4.2134666513927d-01,-2.7707294437548d-01,-7.9360181195856d-01,
     |  -7.9360181195856d-01,-2.7707294437548d-01, 4.2134666513927d-01,
     |   8.4980838349080d-01, 7.3140587434663d-01, 1.4080034336572d-01,
     |  -5.4687719277948d-01,-8.9738161540822d-01,-6.9048460400338d-01,
     |  -5.1928806025648d-02, 6.3210201486498d-01, 9.5470685537112d-01,
     |   7.2804797708965d-01, 8.0594660279777d-02,-6.3300649195157d-01,
     |  -1.0394172473971d+00,-9.4172999834530d-01,-3.9701531475280d-01,
     |   3.4703916060106d-01, 9.9826741850372d-01, 1.3574802204644d+00,
     |   1.3804115649929d+00, 1.1531005856343d+00, 8.1724704993973d-01,
     |   4.9664133868036d-01, 2.5851474644497d-01, 1.1414833408009d-01,
     |   4.1977018636321d-02, 1.2486278613057d-02, 2.8727539124307d-03,
     |   4.7679225264222d-04, 5.0931033624677d-05, 2.8585259388539d-06,
     |   5.5769767610106d-08, 1.2978805721421d-10, 2.5248681740741d-16/
      data (pmn(lat,13,22), lat = 1,72)/
     |   3.9650413857301d-18, 6.1327771988971d-12, 4.4185389781563d-09,
     |   3.1998186732453d-07, 7.4221880499451d-06, 8.6300299161380d-05,
     |   6.2695702669266d-04, 3.2223175795147d-03, 1.2647336255468d-02,
     |   3.9840836577220d-02, 1.0415055106002d-01, 2.3109000248887d-01,
     |   4.4157776701972d-01, 7.3242458311553d-01, 1.0556982499313d+00,
     |   1.3122210524083d+00, 1.3745059550975d+00, 1.1417601751151d+00,
     |   6.0730677345477d-01,-1.0008969107865d-01,-7.3854253707783d-01,
     |  -1.0481425745452d+00,-8.8285329347375d-01,-3.0846452477835d-01,
     |   4.0077644309138d-01, 8.8505690843556d-01, 8.8771844300181d-01,
     |   4.0565048956607d-01,-2.9399407146700d-01,-8.1449708332253d-01,
     |  -8.5570213188095d-01,-3.9386435283723d-01, 2.9739823713256d-01,
     |   8.0534960967353d-01, 8.2493320181607d-01, 3.4461093890938d-01,
     |  -3.4461093890938d-01,-8.2493320181607d-01,-8.0534960967353d-01,
     |  -2.9739823713256d-01, 3.9386435283723d-01, 8.5570213188095d-01,
     |   8.1449708332254d-01, 2.9399407146701d-01,-4.0565048956607d-01,
     |  -8.8771844300181d-01,-8.8505690843556d-01,-4.0077644309138d-01,
     |   3.0846452477835d-01, 8.8285329347375d-01, 1.0481425745452d+00,
     |   7.3854253707784d-01, 1.0008969107865d-01,-6.0730677345477d-01,
     |  -1.1417601751151d+00,-1.3745059550975d+00,-1.3122210524083d+00,
     |  -1.0556982499313d+00,-7.3242458311553d-01,-4.4157776701972d-01,
     |  -2.3109000248887d-01,-1.0415055106002d-01,-3.9840836577221d-02,
     |  -1.2647336255468d-02,-3.2223175795147d-03,-6.2695702669266d-04,
     |  -8.6300299161382d-05,-7.4221880499451d-06,-3.1998186732453d-07,
     |  -4.4185389781563d-09,-6.1327771988971d-12,-3.9650413857301d-18/
      data (pmn(lat,14,22), lat = 1,72)/
     |   5.5627733933937d-20, 2.5879731488449d-13, 3.1240899107869d-10,
     |   3.1928970086899d-08, 9.6266365273819d-07, 1.3873293138866d-05,
     |   1.2119391417133d-04, 7.3398864153516d-04, 3.3482634796055d-03,
     |   1.2147506713286d-02, 3.6374388940891d-02, 9.2247172932169d-02,
     |   2.0171368296489d-01, 3.8485475152015d-01, 6.4496798045956d-01,
     |   9.5076126212657d-01, 1.2263634289500d+00, 1.3620914454430d+00,
     |   1.2523938981040d+00, 8.5199839657819d-01, 2.2413315229999d-01,
     |  -4.5218395330858d-01,-9.3584913993689d-01,-1.0270685022855d+00,
     |  -6.7467884189803d-01,-2.6529996949376d-02, 6.1818005840784d-01,
     |   9.4551411900125d-01, 7.8854092886639d-01, 2.2547916316756d-01,
     |  -4.4879148289379d-01,-8.7335042913759d-01,-8.1712977459130d-01,
     |  -3.1052616727102d-01, 3.6607519942133d-01, 8.3569087681707d-01,
     |   8.3569087681707d-01, 3.6607519942133d-01,-3.1052616727101d-01,
     |  -8.1712977459130d-01,-8.7335042913759d-01,-4.4879148289379d-01,
     |   2.2547916316756d-01, 7.8854092886639d-01, 9.4551411900125d-01,
     |   6.1818005840784d-01,-2.6529996949373d-02,-6.7467884189802d-01,
     |  -1.0270685022855d+00,-9.3584913993689d-01,-4.5218395330858d-01,
     |   2.2413315229998d-01, 8.5199839657819d-01, 1.2523938981040d+00,
     |   1.3620914454430d+00, 1.2263634289500d+00, 9.5076126212658d-01,
     |   6.4496798045956d-01, 3.8485475152015d-01, 2.0171368296489d-01,
     |   9.2247172932169d-02, 3.6374388940891d-02, 1.2147506713286d-02,
     |   3.3482634796055d-03, 7.3398864153516d-04, 1.2119391417133d-04,
     |   1.3873293138866d-05, 9.6266365273819d-07, 3.1928970086899d-08,
     |   3.1240899107869d-10, 2.5879731488449d-13, 5.5627733933937d-20/
      data (pmn(lat,15,22), lat = 1,72)/
     |   6.9619285878222d-22, 9.7393840621060d-15, 1.9687127967697d-11,
     |   2.8370340221415d-09, 1.1104271315818d-07, 1.9801484859239d-06,
     |   2.0756192498084d-05, 1.4772670391000d-04, 7.8055723883259d-04,
     |   3.2473542550349d-03, 1.1076602603461d-02, 3.1876437217040d-02,
     |   7.9001216325906d-02, 1.7109798235585d-01, 3.2705929604794d-01,
     |   5.5505297869572d-01, 8.3780127889671d-01, 1.1211141333112d+00,
     |   1.3157986243726d+00, 1.3207315965520d+00, 1.0654427458029d+00,
     |   5.5700210492515d-01,-9.4012023996394d-02,-6.9157880298954d-01,
     |  -1.0216968716542d+00,-9.4726437050855d-01,-4.8607621283761d-01,
     |   1.7400065553069d-01, 7.4321494677519d-01, 9.5910931661542d-01,
     |   7.1653406663938d-01, 1.2934832399710d-01,-5.1583033831051d-01,
     |  -8.9792704828238d-01,-8.2401965622135d-01,-3.3086527242641d-01,
     |   3.3086527242641d-01, 8.2401965622135d-01, 8.9792704828238d-01,
     |   5.1583033831051d-01,-1.2934832399710d-01,-7.1653406663938d-01,
     |  -9.5910931661542d-01,-7.4321494677519d-01,-1.7400065553069d-01,
     |   4.8607621283761d-01, 9.4726437050855d-01, 1.0216968716542d+00,
     |   6.9157880298955d-01, 9.4012023996394d-02,-5.5700210492515d-01,
     |  -1.0654427458029d+00,-1.3207315965520d+00,-1.3157986243726d+00,
     |  -1.1211141333112d+00,-8.3780127889671d-01,-5.5505297869572d-01,
     |  -3.2705929604794d-01,-1.7109798235585d-01,-7.9001216325906d-02,
     |  -3.1876437217040d-02,-1.1076602603461d-02,-3.2473542550350d-03,
     |  -7.8055723883260d-04,-1.4772670391000d-04,-2.0756192498084d-05,
     |  -1.9801484859239d-06,-1.1104271315818d-07,-2.8370340221415d-09,
     |  -1.9687127967697d-11,-9.7393840621060d-15,-6.9619285878222d-22/
      data (pmn(lat,16,22), lat = 1,72)/
     |   7.7432124089243d-24, 3.2565177235944d-16, 1.1017471470947d-12,
     |   2.2369826376902d-10, 1.1354775740921d-08, 2.5021041408531d-07,
     |   3.1416752064457d-06, 2.6220720953954d-05, 1.6004685625091d-04,
     |   7.6100466320386d-04, 2.9446135692333d-03, 9.5656975972655d-03,
     |   2.6689086863461d-02, 6.5035400640285d-02, 1.4011026176540d-01,
     |   2.6916419031272d-01, 4.6357771328597d-01, 7.1735008070965d-01,
     |   9.9580544935382d-01, 1.2317467202538d+00, 1.3364667887327d+00,
     |   1.2282402413701d+00, 8.7166663698470d-01, 3.1150820469133d-01,
     |  -3.1932598729923d-01,-8.3127797144059d-01,-1.0455209983734d+00,
     |  -8.7294397444664d-01,-3.6775771054687d-01, 2.7636372580433d-01,
     |   7.9593725292394d-01, 9.6861045028575d-01, 7.1593924584305d-01,
     |   1.4668279744934d-01,-4.8551248071037d-01,-8.9483729813257d-01,
     |  -8.9483729813257d-01,-4.8551248071037d-01, 1.4668279744934d-01,
     |   7.1593924584305d-01, 9.6861045028575d-01, 7.9593725292394d-01,
     |   2.7636372580433d-01,-3.6775771054686d-01,-8.7294397444664d-01,
     |  -1.0455209983734d+00,-8.3127797144059d-01,-3.1932598729924d-01,
     |   3.1150820469133d-01, 8.7166663698470d-01, 1.2282402413701d+00,
     |   1.3364667887327d+00, 1.2317467202538d+00, 9.9580544935383d-01,
     |   7.1735008070965d-01, 4.6357771328598d-01, 2.6916419031272d-01,
     |   1.4011026176539d-01, 6.5035400640284d-02, 2.6689086863461d-02,
     |   9.5656975972655d-03, 2.9446135692333d-03, 7.6100466320386d-04,
     |   1.6004685625091d-04, 2.6220720953954d-05, 3.1416752064457d-06,
     |   2.5021041408532d-07, 1.1354775740921d-08, 2.2369826376902d-10,
     |   1.1017471470947d-12, 3.2565177235944d-16, 7.7432124089243d-24/
      data (pmn(lat,17,22), lat = 1,72)/
     |   7.6022170619367d-26, 9.6098577352855d-18, 5.4393738721512d-14,
     |   1.5551094533253d-11, 1.0228212095181d-09, 2.7820619022990d-08,
     |   4.1785312376743d-07, 4.0825150194695d-06, 2.8725166455130d-05,
     |   1.5569816715421d-04, 6.8123024424494d-04, 2.4881843041826d-03,
     |   7.7767421789376d-03, 2.1187846520172d-02, 5.1028467930380d-02,
     |   1.0977614069073d-01, 2.1254837418604d-01, 3.7226106388547d-01,
     |   5.9127815485468d-01, 8.5155794649043d-01, 1.1078764340087d+00,
     |   1.2900667603193d+00, 1.3186207332062d+00, 1.1327798147607d+00,
     |   7.2284146174184d-01, 1.5240214945510d-01,-4.4411315081847d-01,
     |  -8.9565479782269d-01,-1.0535522489479d+00,-8.5408013345574d-01,
     |  -3.5652929865529d-01, 2.6513514312111d-01, 7.8048554537613d-01,
     |   9.9096222029322d-01, 8.1198907839042d-01, 3.1191852065805d-01,
     |  -3.1191852065805d-01,-8.1198907839042d-01,-9.9096222029322d-01,
     |  -7.8048554537614d-01,-2.6513514312111d-01, 3.5652929865529d-01,
     |   8.5408013345574d-01, 1.0535522489479d+00, 8.9565479782270d-01,
     |   4.4411315081847d-01,-1.5240214945510d-01,-7.2284146174184d-01,
     |  -1.1327798147607d+00,-1.3186207332062d+00,-1.2900667603193d+00,
     |  -1.1078764340087d+00,-8.5155794649043d-01,-5.9127815485468d-01,
     |  -3.7226106388547d-01,-2.1254837418604d-01,-1.0977614069073d-01,
     |  -5.1028467930380d-02,-2.1187846520172d-02,-7.7767421789376d-03,
     |  -2.4881843041826d-03,-6.8123024424494d-04,-1.5569816715421d-04,
     |  -2.8725166455130d-05,-4.0825150194695d-06,-4.1785312376743d-07,
     |  -2.7820619022991d-08,-1.0228212095181d-09,-1.5551094533253d-11,
     |  -5.4393738721512d-14,-9.6098577352855d-18,-7.6022170619367d-26/
      data (pmn(lat,18,22), lat = 1,72)/
     |   6.5167917706735d-28, 2.4756123564781d-19, 2.3435364218545d-15,
     |   9.4295551546713d-13, 8.0305580694915d-11, 2.6937353972664d-09,
     |   4.8340691134190d-08, 5.5210509298578d-07, 4.4703101611716d-06,
     |   2.7563105629531d-05, 1.3602015191630d-04, 5.5686365320939d-04,
     |   1.9423097612100d-03, 5.8891160583928d-03, 1.5763021556861d-02,
     |   3.7691596267709d-02, 8.1248942441781d-02, 1.5897168710356d-01,
     |   2.8368978231899d-01, 4.6308222953680d-01, 6.9208740695022d-01,
     |   9.4559155373481d-01, 1.1753944279298d+00, 1.3156443899665d+00,
     |   1.2988093596749d+00, 1.0798529004685d+00, 6.6109563755993d-01,
     |   1.0686063644536d-01,-4.6201677549697d-01,-8.9742941032482d-01,
     |  -1.0706821616911d+00,-9.2092005775906d-01,-4.8559888179215d-01,
     |   1.0225733715869d-01, 6.5311298578168d-01, 9.8427746980127d-01,
     |   9.8427746980127d-01, 6.5311298578168d-01, 1.0225733715870d-01,
     |  -4.8559888179215d-01,-9.2092005775906d-01,-1.0706821616911d+00,
     |  -8.9742941032483d-01,-4.6201677549698d-01, 1.0686063644536d-01,
     |   6.6109563755993d-01, 1.0798529004685d+00, 1.2988093596748d+00,
     |   1.3156443899665d+00, 1.1753944279298d+00, 9.4559155373481d-01,
     |   6.9208740695022d-01, 4.6308222953680d-01, 2.8368978231899d-01,
     |   1.5897168710356d-01, 8.1248942441781d-02, 3.7691596267709d-02,
     |   1.5763021556860d-02, 5.8891160583927d-03, 1.9423097612100d-03,
     |   5.5686365320939d-04, 1.3602015191630d-04, 2.7563105629531d-05,
     |   4.4703101611717d-06, 5.5210509298579d-07, 4.8340691134190d-08,
     |   2.6937353972665d-09, 8.0305580694915d-11, 9.4295551546713d-13,
     |   2.3435364218545d-15, 2.4756123564781d-19, 6.5167917706735d-28/
      data (pmn(lat,19,22), lat = 1,72)/
     |   4.7923177322138d-30, 5.4702234924333d-21, 8.6581891801581d-17,
     |   4.9007710796169d-14, 5.4010163761243d-12, 2.2325034161657d-10,
     |   4.7822573809543d-09, 6.3772660899103d-08, 5.9335148141229d-07,
     |   4.1545826851160d-06, 2.3076740483157d-05, 1.0563458761445d-04,
     |   4.0995961126254d-04, 1.3783319956228d-03, 4.0822449343759d-03,
     |   1.0790836468347d-02, 2.5721187476489d-02, 5.5733513076249d-02,
     |   1.1047138751131d-01, 2.0124486892067d-01, 3.3802096711160d-01,
     |   5.2441679465186d-01, 7.5161206632995d-01, 9.9332512248495d-01,
     |   1.2048276107233d+00, 1.3286944133522d+00, 1.3081671788851d+00,
     |   1.1059040035762d+00, 7.2257465358050d-01, 2.0784787986641d-01,
     |  -3.4277857460904d-01,-8.0774187473901d-01,-1.0720080790079d+00,
     |  -1.0628528840046d+00,-7.7635518083071d-01,-2.8408176221937d-01,
     |   2.8408176221937d-01, 7.7635518083071d-01, 1.0628528840046d+00,
     |   1.0720080790079d+00, 8.0774187473901d-01, 3.4277857460904d-01,
     |  -2.0784787986640d-01,-7.2257465358049d-01,-1.1059040035762d+00,
     |  -1.3081671788851d+00,-1.3286944133522d+00,-1.2048276107233d+00,
     |  -9.9332512248495d-01,-7.5161206632995d-01,-5.2441679465186d-01,
     |  -3.3802096711161d-01,-2.0124486892067d-01,-1.1047138751131d-01,
     |  -5.5733513076249d-02,-2.5721187476489d-02,-1.0790836468347d-02,
     |  -4.0822449343759d-03,-1.3783319956228d-03,-4.0995961126254d-04,
     |  -1.0563458761445d-04,-2.3076740483157d-05,-4.1545826851161d-06,
     |  -5.9335148141230d-07,-6.3772660899103d-08,-4.7822573809543d-09,
     |  -2.2325034161658d-10,-5.4010163761243d-12,-4.9007710796169d-14,
     |  -8.6581891801581d-17,-5.4702234924333d-21,-4.7923177322138d-30/
      data (pmn(lat,20,22), lat = 1,72)/
     |   2.9345246488376d-32, 1.0063643892232d-22, 2.6625876818829d-18,
     |   2.1193229389291d-15, 3.0209525830542d-13, 1.5377429607616d-11,
     |   3.9287453868301d-10, 6.1110734216986d-09, 6.5258766597205d-08,
     |   5.1815731670498d-07, 3.2340532709969d-06, 1.6519412778772d-05,
     |   7.1164072848870d-05, 2.6455847747953d-04, 8.6406038586344d-04,
     |   2.5145709670221d-03, 6.5944746989081d-03, 1.5726416899134d-02,
     |   3.4354236170478d-02, 6.9145865143188d-02, 1.2881956179142d-01,
     |   2.2291503919912d-01, 3.5916612156276d-01, 5.3956314874570d-01,
     |   7.5588472284226d-01, 9.8621529199602d-01, 1.1943836949953d+00,
     |   1.3339804045108d+00, 1.3574538147727d+00, 1.2289406911291d+00,
     |   9.3755967265709d-01, 5.0673416018685d-01,-4.5628077458030d-03,
     |  -5.1071691065729d-01,-9.1737933014007d-01,-1.1439183754751d+00,
     |  -1.1439183754751d+00,-9.1737933014007d-01,-5.1071691065729d-01,
     |  -4.5628077458041d-03, 5.0673416018685d-01, 9.3755967265709d-01,
     |   1.2289406911291d+00, 1.3574538147727d+00, 1.3339804045108d+00,
     |   1.1943836949953d+00, 9.8621529199603d-01, 7.5588472284226d-01,
     |   5.3956314874570d-01, 3.5916612156276d-01, 2.2291503919912d-01,
     |   1.2881956179143d-01, 6.9145865143188d-02, 3.4354236170479d-02,
     |   1.5726416899134d-02, 6.5944746989081d-03, 2.5145709670221d-03,
     |   8.6406038586344d-04, 2.6455847747953d-04, 7.1164072848871d-05,
     |   1.6519412778772d-05, 3.2340532709969d-06, 5.1815731670499d-07,
     |   6.5258766597207d-08, 6.1110734216987d-09, 3.9287453868301d-10,
     |   1.5377429607617d-11, 3.0209525830542d-13, 2.1193229389291d-15,
     |   2.6625876818829d-18, 1.0063643892232d-22, 2.9345246488376d-32/
      data (pmn(lat,21,22), lat = 1,72)/
     |   1.4138355952468d-34, 1.4565620891783d-24, 6.4403971992551d-20,
     |   7.2064646869849d-17, 1.3280516028778d-14, 8.3202137421922d-13,
     |   2.5335655626828d-11, 4.5929513545811d-10, 5.6236663495738d-09,
     |   5.0574460202234d-08, 3.5419637807400d-07, 2.0155272979463d-06,
     |   9.6192523882981d-06, 3.9450771017331d-05, 1.4170317726841d-04,
     |   4.5255050115709d-04, 1.3007517694035d-03, 3.3982467448358d-03,
     |   8.1352079135969d-03, 1.7965349641313d-02, 3.6800005353210d-02,
     |   7.0237830673722d-02, 1.2537292496469d-01, 2.0990203568926d-01,
     |   3.3035066000893d-01, 4.8949011822627d-01, 6.8339192387344d-01,
     |   8.9895035824842d-01, 1.1129268235711d+00, 1.2934600629969d+00,
     |   1.4044631722566d+00, 1.4124699781892d+00, 1.2945507211751d+00,
     |   1.0452435692049d+00, 6.8036404278554d-01, 2.3619629849780d-01,
     |  -2.3619629849780d-01,-6.8036404278554d-01,-1.0452435692049d+00,
     |  -1.2945507211751d+00,-1.4124699781892d+00,-1.4044631722566d+00,
     |  -1.2934600629969d+00,-1.1129268235711d+00,-8.9895035824842d-01,
     |  -6.8339192387344d-01,-4.8949011822627d-01,-3.3035066000893d-01,
     |  -2.0990203568927d-01,-1.2537292496469d-01,-7.0237830673722d-02,
     |  -3.6800005353210d-02,-1.7965349641313d-02,-8.1352079135970d-03,
     |  -3.3982467448358d-03,-1.3007517694035d-03,-4.5255050115709d-04,
     |  -1.4170317726841d-04,-3.9450771017331d-05,-9.6192523882982d-06,
     |  -2.0155272979463d-06,-3.5419637807400d-07,-5.0574460202235d-08,
     |  -5.6236663495739d-09,-4.5929513545812d-10,-2.5335655626828d-11,
     |  -8.3202137421925d-13,-1.3280516028778d-14,-7.2064646869849d-17,
     |  -6.4403971992551d-20,-1.4565620891783d-24,-1.4138355952468d-34/
      data (pmn(lat,22,22), lat = 1,72)/
     |   4.6508128569367d-37, 1.4392361084643d-26, 1.0633373568279d-21,
     |   1.6721532766538d-18, 3.9824506091095d-16, 3.0693000847845d-14,
     |   1.1132809180709d-12, 2.3504270103128d-11, 3.2969123380282d-10,
     |   3.3548104609036d-09, 2.6332542087966d-08, 1.6669901036555d-07,
     |   8.7997678507426d-07, 3.9739440107727d-06, 1.5663675405796d-05,
     |   5.4755994392440d-05, 1.7197131995157d-04, 4.9042531980638d-04,
     |   1.2811441738079d-03, 3.0883136291234d-03, 6.9124274345610d-03,
     |   1.4441234711201d-02, 2.8286865992501d-02, 5.2147570366721d-02,
     |   9.0777488949923d-02, 1.4963823642416d-01, 2.3414259815900d-01,
     |   3.4849389928402d-01, 4.9426403444629d-01, 6.6900248280896d-01,
     |   8.6527232026707d-01, 1.0705109187271d+00, 1.2679804955560d+00,
     |   1.4388198098486d+00, 1.5648965475085d+00, 1.6318884097844d+00,
     |   1.6318884097844d+00, 1.5648965475085d+00, 1.4388198098486d+00,
     |   1.2679804955560d+00, 1.0705109187271d+00, 8.6527232026707d-01,
     |   6.6900248280896d-01, 4.9426403444629d-01, 3.4849389928402d-01,
     |   2.3414259815900d-01, 1.4963823642416d-01, 9.0777488949923d-02,
     |   5.2147570366721d-02, 2.8286865992501d-02, 1.4441234711201d-02,
     |   6.9124274345611d-03, 3.0883136291234d-03, 1.2811441738079d-03,
     |   4.9042531980638d-04, 1.7197131995157d-04, 5.4755994392441d-05,
     |   1.5663675405796d-05, 3.9739440107727d-06, 8.7997678507427d-07,
     |   1.6669901036555d-07, 2.6332542087966d-08, 3.3548104609036d-09,
     |   3.2969123380283d-10, 2.3504270103128d-11, 1.1132809180709d-12,
     |   3.0693000847846d-14, 3.9824506091095d-16, 1.6721532766538d-18,
     |   1.0633373568279d-21, 1.4392361084643d-26, 4.6508128569367d-37/
      data (pmn(lat, 0,23), lat = 1,72)/
     |   4.5344534398994d+00, 2.3782638711523d+00,-3.8580940302071d-01,
     |  -1.8976951592125d+00,-1.4219130519409d+00, 1.9620040967009d-01,
     |   1.3742912735295d+00, 1.1552880720493d+00,-8.3073104390950d-02,
     |  -1.1137893803507d+00,-1.0249782906889d+00, 1.4398596931240d-03,
     |   9.4790098759339d-01, 9.4769169476168d-01, 6.4037919514692d-02,
     |  -8.2836159857275d-01,-8.9723390346275d-01,-1.2010649619069d-01,
     |   7.3538883185423d-01, 8.6253899912738d-01, 1.7033798571327d-01,
     |  -6.5914358632462d-01,-8.3809911817168d-01,-2.1689896990551d-01,
     |   5.9407631024764d-01, 8.2088341642783d-01, 2.6126067026208d-01,
     |  -5.3675604211000d-01,-8.0912410680407d-01,-3.0453297498927d-01,
     |   4.8489865376243d-01, 8.0177170708413d-01, 3.4764569176502d-01,
     |  -4.3687942613137d-01,-7.9823087074662d-01,-3.9146410662887d-01,
     |   3.9146410662887d-01, 7.9823087074662d-01, 4.3687942613137d-01,
     |  -3.4764569176502d-01,-8.0177170708413d-01,-4.8489865376243d-01,
     |   3.0453297498927d-01, 8.0912410680407d-01, 5.3675604211001d-01,
     |  -2.6126067026208d-01,-8.2088341642783d-01,-5.9407631024764d-01,
     |   2.1689896990551d-01, 8.3809911817168d-01, 6.5914358632462d-01,
     |  -1.7033798571326d-01,-8.6253899912738d-01,-7.3538883185424d-01,
     |   1.2010649619069d-01, 8.9723390346275d-01, 8.2836159857275d-01,
     |  -6.4037919514698d-02,-9.4769169476168d-01,-9.4790098759340d-01,
     |  -1.4398596931240d-03, 1.0249782906889d+00, 1.1137893803507d+00,
     |   8.3073104390961d-02,-1.1552880720493d+00,-1.3742912735295d+00,
     |  -1.9620040967011d-01, 1.4219130519409d+00, 1.8976951592125d+00,
     |   3.8580940302071d-01,-2.3782638711523d+00,-4.5344534398994d+00/
      data (pmn(lat, 1,23), lat = 1,72)/
     |   1.2020879259874d+00, 2.7298561961746d+00, 2.3337130255839d+00,
     |   4.8803713967646d-01,-1.2629604492878d+00,-1.6112808920493d+00,
     |  -5.1850997404685d-01, 8.7502740608404d-01, 1.3196035047623d+00,
     |   5.2858369582600d-01,-6.6720054654862d-01,-1.1512238061315d+00,
     |  -5.3980371778135d-01, 5.2753734725507d-01, 1.0380509195364d+00,
     |   5.5325686653416d-01,-4.2205304328405d-01,-9.5504565554127d-01,
     |  -5.6861605473165d-01, 3.3634441338913d-01, 8.9055759432770d-01,
     |   5.8560609275420d-01,-2.6303857344330d-01,-8.3834295232205d-01,
     |  -6.0411690545504d-01, 1.9784320746665d-01, 7.9472056951937d-01,
     |   6.2417951389997d-01,-1.3799371841326d-01,-7.5736564334892d-01,
     |  -6.4594370176476d-01, 8.1540539208458d-02, 7.2473265712010d-01,
     |   6.6967250021568d-01,-2.6977710306854d-02,-6.9575404813606d-01,
     |  -6.9575404813606d-01,-2.6977710306856d-02, 6.6967250021568d-01,
     |   7.2473265712010d-01, 8.1540539208461d-02,-6.4594370176476d-01,
     |  -7.5736564334892d-01,-1.3799371841327d-01, 6.2417951389997d-01,
     |   7.9472056951937d-01, 1.9784320746665d-01,-6.0411690545504d-01,
     |  -8.3834295232205d-01,-2.6303857344330d-01, 5.8560609275420d-01,
     |   8.9055759432771d-01, 3.3634441338913d-01,-5.6861605473165d-01,
     |  -9.5504565554127d-01,-4.2205304328406d-01, 5.5325686653416d-01,
     |   1.0380509195364d+00, 5.2753734725507d-01,-5.3980371778134d-01,
     |  -1.1512238061315d+00,-6.6720054654862d-01, 5.2858369582599d-01,
     |   1.3196035047623d+00, 8.7502740608404d-01,-5.1850997404685d-01,
     |  -1.6112808920493d+00,-1.2629604492878d+00, 4.8803713967646d-01,
     |   2.3337130255839d+00, 2.7298561961746d+00, 1.2020879259874d+00/
      data (pmn(lat, 2,23), lat = 1,72)/
     |   1.5547814598713d-01, 1.1693020993019d+00, 2.2037462883121d+00,
     |   2.1715515214903d+00, 8.8302324016292d-01,-7.5810716289191d-01,
     |  -1.5284951329644d+00,-9.3755563449864d-01, 3.7261027757567d-01,
     |   1.2182596374601d+00, 9.1146032922466d-01,-1.8039496184209d-01,
     |  -1.0254855788353d+00,-8.8208310454489d-01, 5.6579001334418d-02,
     |   8.8865377800134d-01, 8.5782182993025d-01, 3.5244479454577d-02,
     |  -7.8314543149008d-01,-8.3895103232715d-01,-1.0969349289334d-01,
     |   6.9695894523717d-01, 8.2463296548553d-01, 1.7390927242789d-01,
     |  -6.2341990427699d-01,-8.1405416587983d-01,-2.3191398581804d-01,
     |   5.5843117230115d-01, 8.0659916002672d-01, 2.8626037897317d-01,
     |  -4.9925901068532d-01,-8.0184495405648d-01,-3.3876443902760d-01,
     |   4.4392757874520d-01, 7.9953008893297d-01, 3.9088053890794d-01,
     |  -3.9088053890794d-01,-7.9953008893297d-01,-4.4392757874520d-01,
     |   3.3876443902760d-01, 8.0184495405647d-01, 4.9925901068532d-01,
     |  -2.8626037897317d-01,-8.0659916002672d-01,-5.5843117230115d-01,
     |   2.3191398581803d-01, 8.1405416587983d-01, 6.2341990427699d-01,
     |  -1.7390927242788d-01,-8.2463296548553d-01,-6.9695894523717d-01,
     |   1.0969349289333d-01, 8.3895103232715d-01, 7.8314543149009d-01,
     |  -3.5244479454575d-02,-8.5782182993024d-01,-8.8865377800135d-01,
     |  -5.6579001334412d-02, 8.8208310454489d-01, 1.0254855788353d+00,
     |   1.8039496184209d-01,-9.1146032922466d-01,-1.2182596374601d+00,
     |  -3.7261027757568d-01, 9.3755563449863d-01, 1.5284951329644d+00,
     |   7.5810716289193d-01,-8.8302324016292d-01,-2.1715515214903d+00,
     |  -2.2037462883121d+00,-1.1693020993019d+00,-1.5547814598713d-01/
      data (pmn(lat, 3,23), lat = 1,72)/
     |   1.3283442013096d-02, 3.1410621047484d-01, 1.1023677305448d+00,
     |   1.9253814888542d+00, 2.0275089848642d+00, 1.0868216505904d+00,
     |  -3.7728912123941d-01,-1.3510289504933d+00,-1.1604055638947d+00,
     |  -5.6557715304361d-02, 9.8603272802216d-01, 1.0991448430605d+00,
     |   2.5248503291329d-01,-7.5545169878369d-01,-1.0286371041410d+00,
     |  -3.6573781828056d-01, 5.9104145174790d-01, 9.6484007265372d-01,
     |   4.4235853442809d-01,-4.6352130996060d-01,-9.0888452907845d-01,
     |  -5.0026674862487d-01, 3.5832318391942d-01, 8.5947339635425d-01,
     |   5.4777735271995d-01,-2.6728798288518d-01,-8.1509474392616d-01,
     |  -5.8928700988439d-01, 1.8536910323256d-01, 7.7441795974310d-01,
     |   6.2739226388554d-01,-1.0914202245725d-01,-7.3630819796463d-01,
     |  -6.6379840737372d-01, 3.6047081066644d-02, 6.9975798460643d-01,
     |   6.9975798460643d-01, 3.6047081066646d-02,-6.6379840737372d-01,
     |  -7.3630819796464d-01,-1.0914202245725d-01, 6.2739226388554d-01,
     |   7.7441795974311d-01, 1.8536910323256d-01,-5.8928700988439d-01,
     |  -8.1509474392616d-01,-2.6728798288519d-01, 5.4777735271995d-01,
     |   8.5947339635425d-01, 3.5832318391942d-01,-5.0026674862487d-01,
     |  -9.0888452907846d-01,-4.6352130996060d-01, 4.4235853442809d-01,
     |   9.6484007265372d-01, 5.9104145174791d-01,-3.6573781828056d-01,
     |  -1.0286371041410d+00,-7.5545169878369d-01, 2.5248503291328d-01,
     |   1.0991448430605d+00, 9.8603272802216d-01,-5.6557715304352d-02,
     |  -1.1604055638947d+00,-1.3510289504933d+00,-3.7728912123941d-01,
     |   1.0868216505904d+00, 2.0275089848642d+00, 1.9253814888542d+00,
     |   1.1023677305448d+00, 3.1410621047484d-01, 1.3283442013096d-02/
      data (pmn(lat, 4,23), lat = 1,72)/
     |   8.4460550345632d-04, 6.1595219101748d-02, 3.8298360841306d-01,
     |   1.0463319575794d+00, 1.7438997107894d+00, 1.9090907607265d+00,
     |   1.2027454216455d+00,-8.4882453700432d-02,-1.1451344118332d+00,
     |  -1.2581972086107d+00,-4.0024737752230d-01, 6.9868979389332d-01,
     |   1.1385990112608d+00, 5.9504691315975d-01,-4.1911555102165d-01,
     |  -1.0112383076334d+00,-6.8856026837019d-01, 2.2479506969914d-01,
     |   8.9682271603247d-01, 7.3864184994611d-01,-7.8043758162224d-02,
     |  -7.9553037320715d-01,-7.6738261975705d-01,-4.0211391812664d-02,
     |   7.0446795534751d-01, 7.8453052342787d-01, 1.4059573589644d-01,
     |  -6.2069416105067d-01,-7.9482089508445d-01,-2.2956508660903d-01,
     |   5.4166419653262d-01, 8.0068192242892d-01, 3.1137992768216d-01,
     |  -4.6515750820700d-01,-8.0334961866707d-01,-3.8910371825508d-01,
     |   3.8910371825508d-01, 8.0334961866707d-01, 4.6515750820700d-01,
     |  -3.1137992768216d-01,-8.0068192242892d-01,-5.4166419653262d-01,
     |   2.2956508660903d-01, 7.9482089508445d-01, 6.2069416105068d-01,
     |  -1.4059573589644d-01,-7.8453052342787d-01,-7.0446795534752d-01,
     |   4.0211391812660d-02, 7.6738261975705d-01, 7.9553037320715d-01,
     |   7.8043758162237d-02,-7.3864184994611d-01,-8.9682271603248d-01,
     |  -2.2479506969914d-01, 6.8856026837018d-01, 1.0112383076334d+00,
     |   4.1911555102164d-01,-5.9504691315975d-01,-1.1385990112608d+00,
     |  -6.9868979389332d-01, 4.0024737752230d-01, 1.2581972086107d+00,
     |   1.1451344118332d+00, 8.4882453700439d-02,-1.2027454216455d+00,
     |  -1.9090907607265d+00,-1.7438997107894d+00,-1.0463319575794d+00,
     |  -3.8298360841306d-01,-6.1595219101748d-02,-8.4460550345632d-04/
      data (pmn(lat, 5,23), lat = 1,72)/
     |   4.2595892463996d-05, 9.4915071229800d-03, 1.0228757620851d-01,
     |   4.1808576258104d-01, 9.9814571591913d-01, 1.6110481411118d+00,
     |   1.8113436361154d+00, 1.2744188618311d+00, 1.4774350782324d-01,
     |  -9.3480883649964d-01,-1.2749248446551d+00,-6.6565740720169d-01,
     |   3.9642545842041d-01, 1.0699927271695d+00, 8.3808581924555d-01,
     |  -6.8537918430561d-02,-8.6779421692902d-01,-8.9062014983957d-01,
     |  -1.4789928737683d-01, 6.9166908436219d-01, 8.9396757202335d-01,
     |   3.0169759040818d-01,-5.3885108493062d-01,-8.7437478489288d-01,
     |  -4.1783083633538d-01, 4.0347981965941d-01, 8.4265742710852d-01,
     |   5.0998182278255d-01,-2.8033801456559d-01,-8.0342699122176d-01,
     |  -5.8611967380519d-01, 1.6519987099477d-01, 7.5844652151052d-01,
     |   6.5110146507375d-01,-5.4579933316585d-02,-7.0794449096539d-01,
     |  -7.0794449096539d-01,-5.4579933316587d-02, 6.5110146507375d-01,
     |   7.5844652151052d-01, 1.6519987099477d-01,-5.8611967380519d-01,
     |  -8.0342699122176d-01,-2.8033801456559d-01, 5.0998182278255d-01,
     |   8.4265742710852d-01, 4.0347981965942d-01,-4.1783083633538d-01,
     |  -8.7437478489288d-01,-5.3885108493062d-01, 3.0169759040818d-01,
     |   8.9396757202335d-01, 6.9166908436219d-01,-1.4789928737682d-01,
     |  -8.9062014983958d-01,-8.6779421692902d-01,-6.8537918430566d-02,
     |   8.3808581924555d-01, 1.0699927271695d+00, 3.9642545842042d-01,
     |  -6.6565740720169d-01,-1.2749248446551d+00,-9.3480883649965d-01,
     |   1.4774350782323d-01, 1.2744188618311d+00, 1.8113436361154d+00,
     |   1.6110481411118d+00, 9.9814571591913d-01, 4.1808576258104d-01,
     |   1.0228757620851d-01, 9.4915071229800d-03, 4.2595892463996d-05/
      data (pmn(lat, 6,23), lat = 1,72)/
     |   1.7721759757706d-06, 1.2002593267293d-03, 2.2157830903124d-02,
     |   1.3260595402270d-01, 4.3580205099523d-01, 9.5436518040543d-01,
     |   1.5057745135670d+00, 1.7289115148018d+00, 1.3223383517566d+00,
     |   3.4031691527866d-01,-7.2748851956880d-01,-1.2364120062734d+00,
     |  -8.6351659437136d-01, 1.0017548393948d-01, 9.2339064842423d-01,
     |   9.8350152525122d-01, 2.6201902098264d-01,-6.3414292428520d-01,
     |  -9.6734131368441d-01,-4.8019163714285d-01, 3.9282233680971d-01,
     |   8.9993690816755d-01, 6.1710908650288d-01,-1.9163542108770d-01,
     |  -8.1151489978735d-01,-7.0492088101176d-01, 2.0349134295273d-02,
     |   7.1341408361613d-01, 7.6074675881947d-01, 1.2925679794189d-01,
     |  -6.0960229194790d-01,-7.9393234502550d-01,-2.6325434865504d-01,
     |   5.0080222002819d-01, 8.0944226716473d-01, 3.8605193953542d-01,
     |  -3.8605193953542d-01,-8.0944226716473d-01,-5.0080222002819d-01,
     |   2.6325434865503d-01, 7.9393234502550d-01, 6.0960229194790d-01,
     |  -1.2925679794189d-01,-7.6074675881947d-01,-7.1341408361613d-01,
     |  -2.0349134295274d-02, 7.0492088101176d-01, 8.1151489978736d-01,
     |   1.9163542108771d-01,-6.1710908650288d-01,-8.9993690816755d-01,
     |  -3.9282233680972d-01, 4.8019163714285d-01, 9.6734131368441d-01,
     |   6.3414292428520d-01,-2.6201902098264d-01,-9.8350152525122d-01,
     |  -9.2339064842422d-01,-1.0017548393947d-01, 8.6351659437135d-01,
     |   1.2364120062734d+00, 7.2748851956880d-01,-3.4031691527865d-01,
     |  -1.3223383517566d+00,-1.7289115148018d+00,-1.5057745135670d+00,
     |  -9.5436518040544d-01,-4.3580205099523d-01,-1.3260595402270d-01,
     |  -2.2157830903124d-02,-1.2002593267293d-03,-1.7721759757706d-06/
      data (pmn(lat, 7,23), lat = 1,72)/
     |   6.2442265545722d-08, 1.2812761783384d-04, 4.0235078633959d-03,
     |   3.4827588710979d-02, 1.5436907061634d-01, 4.4253696141175d-01,
     |   9.1256385350211d-01, 1.4170482154948d+00, 1.6573886741761d+00,
     |   1.3567187986650d+00, 5.0596088878528d-01,-5.2409318794230d-01,
     |  -1.1572167954243d+00,-1.0028431534691d+00,-1.7871101856736d-01,
     |   7.2048834800811d-01, 1.0367041836446d+00, 5.4904008619338d-01,
     |  -3.4243326742415d-01,-9.2352742090523d-01,-7.3689727501125d-01,
     |   4.5403319421335d-02, 7.6425784271577d-01, 8.2281031812619d-01,
     |   1.8614591836162d-01,-5.9291803122735d-01,-8.4775561576598d-01,
     |  -3.6852821153269d-01, 4.2083696973717d-01, 8.3284340010399d-01,
     |   5.1371147814050d-01,-2.5104745462873d-01,-7.8884793143712d-01,
     |  -6.2957307985980d-01, 8.3409377661189d-02, 7.2070090861586d-01,
     |   7.2070090861586d-01, 8.3409377661191d-02,-6.2957307985980d-01,
     |  -7.8884793143712d-01,-2.5104745462874d-01, 5.1371147814050d-01,
     |   8.3284340010399d-01, 4.2083696973717d-01,-3.6852821153269d-01,
     |  -8.4775561576598d-01,-5.9291803122736d-01, 1.8614591836161d-01,
     |   8.2281031812619d-01, 7.6425784271577d-01, 4.5403319421335d-02,
     |  -7.3689727501124d-01,-9.2352742090523d-01,-3.4243326742415d-01,
     |   5.4904008619338d-01, 1.0367041836446d+00, 7.2048834800812d-01,
     |  -1.7871101856737d-01,-1.0028431534691d+00,-1.1572167954243d+00,
     |  -5.2409318794230d-01, 5.0596088878528d-01, 1.3567187986650d+00,
     |   1.6573886741761d+00, 1.4170482154948d+00, 9.1256385350211d-01,
     |   4.4253696141175d-01, 1.5436907061634d-01, 3.4827588710979d-02,
     |   4.0235078633959d-03, 1.2812761783384d-04, 6.2442265545722d-08/
      data (pmn(lat, 8,23), lat = 1,72)/
     |   1.8980199393191d-09, 1.1774192255633d-05, 6.2606628516909d-04,
     |   7.7784635475612d-03, 4.5939631458271d-02, 1.6911589606900d-01,
     |   4.4124219083154d-01, 8.7101983547140d-01, 1.3382815913955d+00,
     |   1.5931822868337d+00, 1.3826386365338d+00, 6.5322331874017d-01,
     |  -3.2317860537351d-01,-1.0450483902599d+00,-1.0895455660057d+00,
     |  -4.3296791427370d-01, 4.7742058201256d-01, 1.0035648364571d+00,
     |   7.7483177853316d-01,-2.2204216433401d-02,-7.7010683823463d-01,
     |  -8.9162185388067d-01,-3.0474685072566d-01, 5.0818632943763d-01,
     |   8.8708454136487d-01, 5.3099532704132d-01,-2.5512249458155d-01,
     |  -8.1350144129678d-01,-6.8160715224994d-01, 2.1529939219921d-02,
     |   6.9716580147714d-01, 7.7366809148627d-01, 1.9061986212133d-01,
     |  -5.5116372540640d-01,-8.1734973598076d-01,-3.8157684250266d-01,
     |   3.8157684250266d-01, 8.1734973598076d-01, 5.5116372540640d-01,
     |  -1.9061986212133d-01,-7.7366809148627d-01,-6.9716580147713d-01,
     |  -2.1529939219924d-02, 6.8160715224993d-01, 8.1350144129678d-01,
     |   2.5512249458155d-01,-5.3099532704132d-01,-8.8708454136487d-01,
     |  -5.0818632943763d-01, 3.0474685072566d-01, 8.9162185388067d-01,
     |   7.7010683823464d-01, 2.2204216433403d-02,-7.7483177853316d-01,
     |  -1.0035648364571d+00,-4.7742058201256d-01, 4.3296791427370d-01,
     |   1.0895455660057d+00, 1.0450483902599d+00, 3.2317860537352d-01,
     |  -6.5322331874017d-01,-1.3826386365338d+00,-1.5931822868337d+00,
     |  -1.3382815913956d+00,-8.7101983547140d-01,-4.4124219083154d-01,
     |  -1.6911589606900d-01,-4.5939631458271d-02,-7.7784635475612d-03,
     |  -6.2606628516909d-04,-1.1774192255633d-05,-1.8980199393191d-09/
      data (pmn(lat, 9,23), lat = 1,72)/
     |   5.0439496660932d-11, 9.4453930855969d-07, 8.4776145748139d-05,
     |   1.5040734163950d-03, 1.1744245869234d-02, 5.4870293135470d-02,
     |   1.7789900907562d-01, 4.3342677461834d-01, 8.2844716818761d-01,
     |   1.2651000082720d+00, 1.5332186123588d+00, 1.4022980809826d+00,
     |   7.8740284468604d-01,-1.2278249122670d-01,-9.0352126598126d-01,
     |  -1.1263689300144d+00,-6.5627190437434d-01, 2.0748172190876d-01,
     |   8.8978405748265d-01, 9.2457261291444d-01, 2.9769927025793d-01,
     |  -5.2359569849531d-01,-9.2559797907367d-01,-6.1120612644760d-01,
     |   1.6619150624024d-01, 7.9395297707885d-01, 7.7978843671733d-01,
     |   1.4358813539526d-01,-5.9676543182085d-01,-8.4202743153262d-01,
     |  -3.9761789719076d-01, 3.6758421763862d-01, 8.2331394794393d-01,
     |   5.9589760048672d-01,-1.2391154596013d-01,-7.3869460461309d-01,
     |  -7.3869460461309d-01,-1.2391154596013d-01, 5.9589760048671d-01,
     |   8.2331394794393d-01, 3.6758421763862d-01,-3.9761789719077d-01,
     |  -8.4202743153262d-01,-5.9676543182085d-01, 1.4358813539526d-01,
     |   7.7978843671733d-01, 7.9395297707885d-01, 1.6619150624025d-01,
     |  -6.1120612644760d-01,-9.2559797907367d-01,-5.2359569849531d-01,
     |   2.9769927025792d-01, 9.2457261291444d-01, 8.8978405748265d-01,
     |   2.0748172190876d-01,-6.5627190437434d-01,-1.1263689300144d+00,
     |  -9.0352126598126d-01,-1.2278249122670d-01, 7.8740284468603d-01,
     |   1.4022980809826d+00, 1.5332186123588d+00, 1.2651000082720d+00,
     |   8.2844716818762d-01, 4.3342677461834d-01, 1.7789900907562d-01,
     |   5.4870293135471d-02, 1.1744245869234d-02, 1.5040734163950d-03,
     |   8.4776145748139d-05, 9.4453930855969d-07, 5.0439496660932d-11/
      data (pmn(lat,10,23), lat = 1,72)/
     |   1.1833844825557d-12, 6.6822870064104d-08, 1.0101021310718d-05,
     |   2.5498041557283d-04, 2.6181360743583d-03, 1.5404687087063d-02,
     |   6.1368097182030d-02, 1.8144095047310d-01, 4.1992705067234d-01,
     |   7.8383885363015d-01, 1.1943221396672d+00, 1.4747024642483d+00,
     |   1.4160705900009d+00, 9.1132727914191d-01, 7.8639497825829d-02,
     |  -7.3395790003326d-01,-1.1133143643767d+00,-8.4142364634195d-01,
     |  -7.6468168667705d-02, 7.0164937090128d-01, 9.8505320705189d-01,
     |   5.8731993938193d-01,-2.0729780225421d-01,-8.2858717866233d-01,
     |  -8.2784642675941d-01,-2.1335573608172d-01, 5.4738181039943d-01,
     |   8.7595850070843d-01, 5.2511514888310d-01,-2.2747605192205d-01,
     |  -7.9209674027962d-01,-7.2736470794041d-01,-8.8177777067916d-02,
     |   6.1645032237371d-01, 8.2631868308568d-01, 3.7544102926953d-01,
     |  -3.7544102926952d-01,-8.2631868308568d-01,-6.1645032237371d-01,
     |   8.8177777067914d-02, 7.2736470794041d-01, 7.9209674027962d-01,
     |   2.2747605192205d-01,-5.2511514888310d-01,-8.7595850070843d-01,
     |  -5.4738181039943d-01, 2.1335573608172d-01, 8.2784642675941d-01,
     |   8.2858717866233d-01, 2.0729780225421d-01,-5.8731993938193d-01,
     |  -9.8505320705189d-01,-7.0164937090128d-01, 7.6468168667700d-02,
     |   8.4142364634195d-01, 1.1133143643767d+00, 7.3395790003327d-01,
     |  -7.8639497825834d-02,-9.1132727914191d-01,-1.4160705900009d+00,
     |  -1.4747024642483d+00,-1.1943221396672d+00,-7.8383885363016d-01,
     |  -4.1992705067234d-01,-1.8144095047310d-01,-6.1368097182030d-02,
     |  -1.5404687087063d-02,-2.6181360743583d-03,-2.5498041557283d-04,
     |  -1.0101021310718d-05,-6.6822870064104d-08,-1.1833844825557d-12/
      data (pmn(lat,11,23), lat = 1,72)/
     |   2.4685116194427d-14, 4.1998489056455d-09, 1.0674172005066d-06,
     |   3.8235462408608d-05, 5.1428301394756d-04, 3.7901316923283d-03,
     |   1.8412174709515d-02, 6.5354548125605d-02, 1.8027265242728d-01,
     |   4.0125446968268d-01, 7.3638602100699d-01, 1.1234554446053d+00,
     |   1.4149518718840d+00, 1.4230095605313d+00, 1.0257647230035d+00,
     |   2.8161092473680d-01,-5.3671585379607d-01,-1.0482837012016d+00,
     |  -9.7932981563174d-01,-3.5989387180272d-01, 4.4772943744397d-01,
     |   9.4498057527252d-01, 8.1454058732755d-01, 1.4656710185848d-01,
     |  -6.0196517517487d-01,-9.1180871649398d-01,-5.6811062469548d-01,
     |   1.7725260592782d-01, 7.7968974725719d-01, 7.9779261175157d-01,
     |   2.2212810431951d-01,-5.1344485892912d-01,-8.5464583313410d-01,
     |  -5.4500564940457d-01, 1.7820632748216d-01, 7.6301547534651d-01,
     |   7.6301547534652d-01, 1.7820632748216d-01,-5.4500564940456d-01,
     |  -8.5464583313410d-01,-5.1344485892913d-01, 2.2212810431951d-01,
     |   7.9779261175157d-01, 7.7968974725720d-01, 1.7725260592782d-01,
     |  -5.6811062469548d-01,-9.1180871649398d-01,-6.0196517517487d-01,
     |   1.4656710185847d-01, 8.1454058732755d-01, 9.4498057527252d-01,
     |   4.4772943744398d-01,-3.5989387180272d-01,-9.7932981563174d-01,
     |  -1.0482837012016d+00,-5.3671585379607d-01, 2.8161092473680d-01,
     |   1.0257647230035d+00, 1.4230095605313d+00, 1.4149518718840d+00,
     |   1.1234554446053d+00, 7.3638602100699d-01, 4.0125446968268d-01,
     |   1.8027265242729d-01, 6.5354548125605d-02, 1.8412174709515d-02,
     |   3.7901316923283d-03, 5.1428301394756d-04, 3.8235462408608d-05,
     |   1.0674172005066d-06, 4.1998489056455d-09, 2.4685116194427d-14/
      data (pmn(lat,12,23), lat = 1,72)/
     |   4.6008295541822d-16, 2.3570276493907d-10, 1.0059380657267d-07,
     |   5.1029370332034d-06, 8.9650957669382d-05, 8.2428308085095d-04,
     |   4.8567840781142d-03, 2.0544885103774d-02, 6.6853408998500d-02,
     |   1.7483128450216d-01, 3.7777891351062d-01, 6.8544836456633d-01,
     |   1.0504455734013d+00, 1.3513042356839d+00, 1.4211039106151d+00,
     |   1.1296014007460d+00, 4.8511685834176d-01,-3.1234719034204d-01,
     |  -9.2795626974658d-01,-1.0586046408584d+00,-6.2477409116998d-01,
     |   1.4130304705707d-01, 7.9691396646875d-01, 9.4548654059397d-01,
     |   4.9473193409653d-01,-2.6382712276058d-01,-8.2988034166906d-01,
     |  -8.2461204002884d-01,-2.5457308184065d-01, 4.8298210075998d-01,
     |   8.7092626624633d-01, 6.3653548516924d-01,-5.0751929697679d-02,
     |  -6.9646367719987d-01,-8.3514550493719d-01,-3.6727591188634d-01,
     |   3.6727591188634d-01, 8.3514550493719d-01, 6.9646367719987d-01,
     |   5.0751929697680d-02,-6.3653548516924d-01,-8.7092626624633d-01,
     |  -4.8298210075998d-01, 2.5457308184064d-01, 8.2461204002884d-01,
     |   8.2988034166906d-01, 2.6382712276059d-01,-4.9473193409652d-01,
     |  -9.4548654059397d-01,-7.9691396646875d-01,-1.4130304705707d-01,
     |   6.2477409116998d-01, 1.0586046408584d+00, 9.2795626974659d-01,
     |   3.1234719034204d-01,-4.8511685834176d-01,-1.1296014007460d+00,
     |  -1.4211039106151d+00,-1.3513042356839d+00,-1.0504455734013d+00,
     |  -6.8544836456633d-01,-3.7777891351062d-01,-1.7483128450216d-01,
     |  -6.6853408998500d-02,-2.0544885103774d-02,-4.8567840781142d-03,
     |  -8.2428308085096d-04,-8.9650957669382d-05,-5.1029370332034d-06,
     |  -1.0059380657267d-07,-2.3570276493907d-10,-4.6008295541822d-16/
      data (pmn(lat,13,23), lat = 1,72)/
     |   7.6854943047170d-18, 1.1850024220861d-11, 8.4839655912104d-09,
     |   6.0853737757665d-07, 1.3933530325911d-05, 1.5934976806303d-04,
     |   1.1342663679844d-03, 5.6879633908015d-03, 2.1680080631486d-02,
     |   6.5968373486286d-02, 1.6553042735912d-01, 3.4984321244196d-01,
     |   6.3056339738263d-01, 9.7357285201312d-01, 1.2810949259044d+00,
     |   1.4074345367417d+00, 1.2198885714370d+00, 6.8607156630710d-01,
     |  -6.2790148167674d-02,-7.4901864893002d-01,-1.0658498551778d+00,
     |  -8.4823958035558d-01,-1.9666445609244d-01, 5.4100762761072d-01,
     |   9.4728214266922d-01, 7.8212016247037d-01, 1.4467806030650d-01,
     |  -5.6929238778307d-01,-9.0719069589359d-01,-6.5182976569392d-01,
     |   2.8265268386995d-02, 6.8147810725265d-01, 8.7074226488925d-01,
     |   4.6928672145561d-01,-2.4954399537851d-01,-7.9546229241145d-01,
     |  -7.9546229241145d-01,-2.4954399537851d-01, 4.6928672145561d-01,
     |   8.7074226488925d-01, 6.8147810725265d-01, 2.8265268386993d-02,
     |  -6.5182976569392d-01,-9.0719069589359d-01,-5.6929238778307d-01,
     |   1.4467806030649d-01, 7.8212016247037d-01, 9.4728214266922d-01,
     |   5.4100762761073d-01,-1.9666445609244d-01,-8.4823958035558d-01,
     |  -1.0658498551778d+00,-7.4901864893002d-01,-6.2790148167679d-02,
     |   6.8607156630710d-01, 1.2198885714370d+00, 1.4074345367417d+00,
     |   1.2810949259044d+00, 9.7357285201312d-01, 6.3056339738263d-01,
     |   3.4984321244196d-01, 1.6553042735912d-01, 6.5968373486286d-02,
     |   2.1680080631486d-02, 5.6879633908015d-03, 1.1342663679844d-03,
     |   1.5934976806304d-04, 1.3933530325911d-05, 6.0853737757665d-07,
     |   8.4839655912104d-09, 1.1850024220861d-11, 7.6854943047170d-18/
      data (pmn(lat,14,23), lat = 1,72)/
     |   1.1522723347433d-19, 5.3450625266602d-13, 6.4144710969694d-10,
     |   6.4975917453707d-08, 1.9355858372899d-06, 2.7470279438143d-05,
     |   2.3550343974204d-04, 1.3944688443672d-03, 6.1937970284741d-03,
     |   2.1779613566248d-02, 6.2879928939332d-02, 1.5281363915052d-01,
     |   3.1784867326187d-01, 5.7148890079880d-01, 8.9145128161818d-01,
     |   1.2017186750353d+00, 1.3783307168947d+00, 1.2918537491307d+00,
     |   8.7875946790127d-01, 2.0728993482753d-01,-5.0991761743090d-01,
     |  -9.8686487793405d-01,-1.0020579437561d+00,-5.3439878767830d-01,
     |   1.9064215600398d-01, 7.9427927741231d-01, 9.4459080464500d-01,
     |   5.5385138788879d-01,-1.5288246929785d-01,-7.5646993717845d-01,
     |  -8.9165808542061d-01,-4.7529496560091d-01, 2.3365647433675d-01,
     |   7.8998832360252d-01, 8.4188234777756d-01, 3.5650003506435d-01,
     |  -3.5650003506435d-01,-8.4188234777756d-01,-7.8998832360252d-01,
     |  -2.3365647433675d-01, 4.7529496560091d-01, 8.9165808542061d-01,
     |   7.5646993717845d-01, 1.5288246929786d-01,-5.5385138788879d-01,
     |  -9.4459080464500d-01,-7.9427927741231d-01,-1.9064215600398d-01,
     |   5.3439878767830d-01, 1.0020579437561d+00, 9.8686487793405d-01,
     |   5.0991761743091d-01,-2.0728993482753d-01,-8.7875946790126d-01,
     |  -1.2918537491307d+00,-1.3783307168947d+00,-1.2017186750353d+00,
     |  -8.9145128161818d-01,-5.7148890079879d-01,-3.1784867326188d-01,
     |  -1.5281363915052d-01,-6.2879928939332d-02,-2.1779613566248d-02,
     |  -6.1937970284742d-03,-1.3944688443672d-03,-2.3550343974204d-04,
     |  -2.7470279438144d-05,-1.9355858372899d-06,-6.4975917453707d-08,
     |  -6.4144710969694d-10,-5.3450625266602d-13,-1.1522723347433d-19/
      data (pmn(lat,15,23), lat = 1,72)/
     |   1.5501382744150d-21, 2.1626260067053d-14, 4.3474932313851d-11,
     |   6.2130062682970d-09, 2.4046147288839d-07, 4.2272450894320d-06,
     |   4.3544032849415d-05, 3.0352041956888d-04, 1.5649152462014d-03,
     |   6.3274593954699d-03, 2.0882188211092d-02, 5.7849293058269d-02,
     |   1.3719747694877d-01, 2.8232867874502d-01, 5.0827534989872d-01,
     |   8.0311220578214d-01, 1.1107924547579d+00, 1.3296108279631d+00,
     |   1.3389869499773d+00, 1.0543168363982d+00, 4.8898786714909d-01,
     |  -2.1329766570090d-01,-8.0919222188733d-01,-1.0537017547382d+00,
     |  -8.2694097168304d-01,-2.2045438606198d-01, 4.7880729514106d-01,
     |   9.1823956146881d-01, 8.6502174666506d-01, 3.4415010951510d-01,
     |  -3.5974973781698d-01,-8.5196908285491d-01,-8.5123490442044d-01,
     |  -3.5712570734137d-01, 3.4310432699209d-01, 8.3916225883405d-01,
     |   8.3916225883405d-01, 3.4310432699209d-01,-3.5712570734137d-01,
     |  -8.5123490442044d-01,-8.5196908285491d-01,-3.5974973781698d-01,
     |   3.4415010951510d-01, 8.6502174666506d-01, 9.1823956146881d-01,
     |   4.7880729514106d-01,-2.2045438606198d-01,-8.2694097168304d-01,
     |  -1.0537017547382d+00,-8.0919222188733d-01,-2.1329766570090d-01,
     |   4.8898786714908d-01, 1.0543168363982d+00, 1.3389869499773d+00,
     |   1.3296108279631d+00, 1.1107924547579d+00, 8.0311220578214d-01,
     |   5.0827534989872d-01, 2.8232867874502d-01, 1.3719747694877d-01,
     |   5.7849293058269d-02, 2.0882188211092d-02, 6.3274593954700d-03,
     |   1.5649152462014d-03, 3.0352041956888d-04, 4.3544032849415d-05,
     |   4.2272450894321d-06, 2.4046147288839d-07, 6.2130062682970d-09,
     |   4.3474932313851d-11, 2.1626260067053d-14, 1.5501382744150d-21/
      data (pmn(lat,16,23), lat = 1,72)/
     |   1.8672706536283d-23, 7.8328344649771d-16, 2.6363123799047d-12,
     |   5.3110194991084d-10, 2.6675679896345d-08, 5.8002130133849d-07,
     |   7.1651713371166d-06, 5.8653075678305d-05, 3.4997545120952d-04,
     |   1.6209506071371d-03, 6.0855882110815d-03, 1.9098145655680d-02,
     |   5.1223131741950d-02, 1.1930572573722d-01, 2.4401583563700d-01,
     |   4.4136372814330d-01, 7.0816442352010d-01, 1.0064427679792d+00,
     |   1.2569929901035d+00, 1.3533466843577d+00, 1.2004207241020d+00,
     |   7.6759559325514d-01, 1.3082053492712d-01,-5.2646871118835d-01,
     |  -9.7012658983514d-01,-1.0162345502545d+00,-6.3113907603039d-01,
     |   2.6608925442755d-02, 6.5877870547063d-01, 9.6237319805911d-01,
     |   7.8403066775766d-01, 2.0979560386722d-01,-4.6715447450720d-01,
     |  -8.9352476082554d-01,-8.4323425730002d-01,-3.4214716336525d-01,
     |   3.4214716336525d-01, 8.4323425730002d-01, 8.9352476082554d-01,
     |   4.6715447450720d-01,-2.0979560386722d-01,-7.8403066775766d-01,
     |  -9.6237319805911d-01,-6.5877870547063d-01,-2.6608925442757d-02,
     |   6.3113907603039d-01, 1.0162345502545d+00, 9.7012658983514d-01,
     |   5.2646871118835d-01,-1.3082053492712d-01,-7.6759559325514d-01,
     |  -1.2004207241020d+00,-1.3533466843577d+00,-1.2569929901035d+00,
     |  -1.0064427679792d+00,-7.0816442352011d-01,-4.4136372814330d-01,
     |  -2.4401583563700d-01,-1.1930572573722d-01,-5.1223131741950d-02,
     |  -1.9098145655680d-02,-6.0855882110815d-03,-1.6209506071371d-03,
     |  -3.4997545120952d-04,-5.8653075678305d-05,-7.1651713371166d-06,
     |  -5.8002130133851d-07,-2.6675679896345d-08,-5.3110194991084d-10,
     |  -2.6363123799047d-12,-7.8328344649771d-16,-1.8672706536283d-23/
      data (pmn(lat,17,23), lat = 1,72)/
     |   2.0054194571735d-25, 2.5288543078257d-17, 1.4243995669837d-13,
     |   4.0423922007384d-11, 2.6324860207843d-09, 7.0710310034252d-08,
     |   1.0459376186301d-06, 1.0035433798784d-05, 6.9133080071658d-05,
     |   3.6569686103083d-04, 1.5560850410002d-03, 5.5064231810873d-03,
     |   1.6603450063293d-02, 4.3434465447091d-02, 9.9892830852852d-02,
     |   2.0390002177653d-01, 3.7169874888393d-01, 6.0702032629376d-01,
     |   8.8773592272689d-01, 1.1567633843936d+00, 1.3262744196734d+00,
     |   1.3014825174825d+00, 1.0213438812694d+00, 5.0134306492115d-01,
     |  -1.4490113194277d-01,-7.2567376372055d-01,-1.0365066688121d+00,
     |  -9.4950274305430d-01,-4.8546139248659d-01, 1.7314653455405d-01,
     |   7.4664030783299d-01, 9.7914110739970d-01, 7.6105845920720d-01,
     |   1.8984280021008d-01,-4.6787358485605d-01,-9.0009454280632d-01,
     |  -9.0009454280632d-01,-4.6787358485605d-01, 1.8984280021008d-01,
     |   7.6105845920720d-01, 9.7914110739970d-01, 7.4664030783299d-01,
     |   1.7314653455405d-01,-4.8546139248658d-01,-9.4950274305430d-01,
     |  -1.0365066688121d+00,-7.2567376372055d-01,-1.4490113194277d-01,
     |   5.0134306492115d-01, 1.0213438812694d+00, 1.3014825174825d+00,
     |   1.3262744196734d+00, 1.1567633843936d+00, 8.8773592272689d-01,
     |   6.0702032629376d-01, 3.7169874888393d-01, 2.0390002177653d-01,
     |   9.9892830852852d-02, 4.3434465447091d-02, 1.6603450063293d-02,
     |   5.5064231810873d-03, 1.5560850410002d-03, 3.6569686103084d-04,
     |   6.9133080071659d-05, 1.0035433798784d-05, 1.0459376186301d-06,
     |   7.0710310034254d-08, 2.6324860207843d-09, 4.0423922007384d-11,
     |   1.4243995669837d-13, 2.5288543078257d-17, 2.0054194571735d-25/
      data (pmn(lat,18,23), lat = 1,72)/
     |   1.9065943988612d-27, 7.2261151988624d-19, 6.8089962692096d-15,
     |   2.7206342116896d-12, 2.2953595518456d-10, 7.6088141998912d-09,
     |   1.3459441398705d-07, 1.5112545260033d-06, 1.1996317662040d-05,
     |   7.2302852595984d-05, 3.4768300460519d-04, 1.3823274362624d-03,
     |   4.6650714624349d-03, 1.3630025106622d-02, 3.4995281805724d-02,
     |   7.9850983045655d-02, 1.6326702320357d-01, 3.0083734101744d-01,
     |   5.0116343574622d-01, 7.5524936503792d-01, 1.0267754131870d+00,
     |   1.2497401784743d+00, 1.3397985603704d+00, 1.2211551081596d+00,
     |   8.6267166307135d-01, 3.0842931645631d-01,-3.1531574172695d-01,
     |  -8.2881535229372d-01,-1.0600606768188d+00,-9.1732528362522d-01,
     |  -4.4040508629758d-01, 1.9837558425632d-01, 7.5232043241454d-01,
     |   9.9834495121517d-01, 8.3314457472819d-01, 3.2245139928702d-01,
     |  -3.2245139928701d-01,-8.3314457472819d-01,-9.9834495121517d-01,
     |  -7.5232043241454d-01,-1.9837558425632d-01, 4.4040508629758d-01,
     |   9.1732528362522d-01, 1.0600606768188d+00, 8.2881535229372d-01,
     |   3.1531574172695d-01,-3.0842931645630d-01,-8.6267166307135d-01,
     |  -1.2211551081596d+00,-1.3397985603704d+00,-1.2497401784743d+00,
     |  -1.0267754131870d+00,-7.5524936503793d-01,-5.0116343574623d-01,
     |  -3.0083734101744d-01,-1.6326702320357d-01,-7.9850983045656d-02,
     |  -3.4995281805723d-02,-1.3630025106622d-02,-4.6650714624349d-03,
     |  -1.3823274362624d-03,-3.4768300460519d-04,-7.2302852595985d-05,
     |  -1.1996317662040d-05,-1.5112545260033d-06,-1.3459441398705d-07,
     |  -7.6088141998915d-09,-2.2953595518456d-10,-2.7206342116896d-12,
     |  -6.8089962692096d-15,-7.2261151988624d-19,-1.9065943988612d-27/
      data (pmn(lat,19,23), lat = 1,72)/
     |   1.5865875953335d-29, 1.8070557694378d-20, 2.8476348585085d-16,
     |   1.6011953233934d-13, 1.7490147091068d-11, 7.1489275955603d-10,
     |   1.5106915217041d-08, 1.9824292649043d-07, 1.8104060943705d-06,
     |   1.2408428561601d-05, 6.7273786796067d-05, 2.9966333725225d-04,
     |   1.1279711948640d-03, 3.6651380951980d-03, 1.0449917188188d-02,
     |   2.6476061640614d-02, 6.0192062647737d-02, 1.2369939285142d-01,
     |   2.3101686164482d-01, 3.9340418470235d-01, 6.1173460868245d-01,
     |   8.6779547349067d-01, 1.1185230653490d+00, 1.2982400210109d+00,
     |   1.3325641522321d+00, 1.1632688034883d+00, 7.7716915214696d-01,
     |   2.2698027926575d-01,-3.6850546928550d-01,-8.5162584885885d-01,
     |  -1.0758251421317d+00,-9.6172307042730d-01,-5.3605539524441d-01,
     |   6.6146094972873d-02, 6.4204865399465d-01, 9.9167418314496d-01,
     |   9.9167418314496d-01, 6.4204865399465d-01, 6.6146094972875d-02,
     |  -5.3605539524441d-01,-9.6172307042730d-01,-1.0758251421317d+00,
     |  -8.5162584885885d-01,-3.6850546928550d-01, 2.2698027926575d-01,
     |   7.7716915214696d-01, 1.1632688034883d+00, 1.3325641522321d+00,
     |   1.2982400210109d+00, 1.1185230653490d+00, 8.6779547349067d-01,
     |   6.1173460868246d-01, 3.9340418470235d-01, 2.3101686164482d-01,
     |   1.2369939285142d-01, 6.0192062647737d-02, 2.6476061640614d-02,
     |   1.0449917188188d-02, 3.6651380951980d-03, 1.1279711948640d-03,
     |   2.9966333725225d-04, 6.7273786796067d-05, 1.2408428561601d-05,
     |   1.8104060943705d-06, 1.9824292649043d-07, 1.5106915217041d-08,
     |   7.1489275955605d-10, 1.7490147091068d-11, 1.6011953233934d-13,
     |   2.8476348585085d-16, 1.8070557694378d-20, 1.5865875953335d-29/
      data (pmn(lat,20,23), lat = 1,72)/
     |   1.1351175152138d-31, 3.8846492968674d-22, 1.0234885787453d-17,
     |   8.0954083842016d-15, 1.1442326101166d-12, 5.7627578751167d-11,
     |   1.4534491397660d-09, 2.2266683496182d-08, 2.3362781235147d-07,
     |   1.8180488827226d-06, 1.1091898734186d-05, 5.5228085617888d-05,
     |   2.3123159043264d-04, 8.3281827656423d-04, 2.6261748229527d-03,
     |   7.3513390190825d-03, 1.8467576046766d-02, 4.1993490988282d-02,
     |   8.7013559332458d-02, 1.6512796133035d-01, 2.8802633728939d-01,
     |   4.6273517899418d-01, 6.8507364264647d-01, 9.3328010616720d-01,
     |   1.1650394846202d+00, 1.3213650970172d+00, 1.3392377503027d+00,
     |   1.1715589849694d+00, 8.0887453734237d-01, 2.9437614483675d-01,
     |  -2.7613892099949d-01,-7.7347904778658d-01,-1.0703430767940d+00,
     |  -1.0821385580934d+00,-7.9865730945266d-01,-2.9359827044921d-01,
     |   2.9359827044920d-01, 7.9865730945266d-01, 1.0821385580934d+00,
     |   1.0703430767940d+00, 7.7347904778658d-01, 2.7613892099949d-01,
     |  -2.9437614483675d-01,-8.0887453734237d-01,-1.1715589849694d+00,
     |  -1.3392377503027d+00,-1.3213650970172d+00,-1.1650394846202d+00,
     |  -9.3328010616720d-01,-6.8507364264647d-01,-4.6273517899418d-01,
     |  -2.8802633728940d-01,-1.6512796133035d-01,-8.7013559332458d-02,
     |  -4.1993490988282d-02,-1.8467576046766d-02,-7.3513390190825d-03,
     |  -2.6261748229526d-03,-8.3281827656423d-04,-2.3123159043264d-04,
     |  -5.5228085617888d-05,-1.1091898734186d-05,-1.8180488827226d-06,
     |  -2.3362781235147d-07,-2.2266683496182d-08,-1.4534491397660d-09,
     |  -5.7627578751169d-11,-1.1442326101166d-12,-8.0954083842016d-15,
     |  -1.0234885787453d-17,-3.8846492968674d-22,-1.1351175152138d-31/
      data (pmn(lat,21,23), lat = 1,72)/
     |   6.7755547950254d-34, 6.9664216243786d-24, 3.0680275940977d-19,
     |   3.4123864694837d-16, 6.2380980366679d-14, 3.8687376784175d-12,
     |   1.1636987937304d-10, 2.0793373346349d-09, 2.5037900544456d-08,
     |   2.2092200376749d-07, 1.5143348110553d-06, 8.4125169629398d-06,
     |   3.9090109867341d-05, 1.5564194384475d-04, 5.4108924533308d-04,
     |   1.6670416343266d-03, 4.6059103247824d-03, 1.1521903317851d-02,
     |   2.6297627381812d-02, 5.5103055264936d-02, 1.0651801570375d-01,
     |   1.9066968474250d-01, 3.1688839365614d-01, 4.8975639446712d-01,
     |   7.0415168384958d-01, 9.4079214391951d-01, 1.1644638144673d+00,
     |   1.3270772187327d+00, 1.3766008970613d+00, 1.2708609915849d+00,
     |   9.9280699013594d-01, 5.6215749399136d-01, 3.8352646046421d-02,
     |  -4.8811686116888d-01,-9.1514884856091d-01,-1.1543035808175d+00,
     |  -1.1543035808175d+00,-9.1514884856091d-01,-4.8811686116888d-01,
     |   3.8352646046420d-02, 5.6215749399135d-01, 9.9280699013594d-01,
     |   1.2708609915849d+00, 1.3766008970613d+00, 1.3270772187327d+00,
     |   1.1644638144673d+00, 9.4079214391951d-01, 7.0415168384959d-01,
     |   4.8975639446712d-01, 3.1688839365614d-01, 1.9066968474250d-01,
     |   1.0651801570376d-01, 5.5103055264936d-02, 2.6297627381813d-02,
     |   1.1521903317851d-02, 4.6059103247825d-03, 1.6670416343266d-03,
     |   5.4108924533308d-04, 1.5564194384475d-04, 3.9090109867342d-05,
     |   8.4125169629398d-06, 1.5143348110553d-06, 2.2092200376749d-07,
     |   2.5037900544456d-08, 2.0793373346349d-09, 1.1636987937304d-10,
     |   3.8687376784176d-12, 6.2380980366679d-14, 3.4123864694837d-16,
     |   3.0680275940977d-19, 6.9664216243786d-24, 6.7755547950254d-34/
      data (pmn(lat,22,23), lat = 1,72)/
     |   3.1876778942447d-36, 9.8457798456666d-26, 7.2465450987849d-21,
     |   1.1330285089490d-17, 2.6777699688166d-15, 2.0439039324084d-13,
     |   7.3273591717175d-12, 1.5258562938157d-10, 2.1065700630587d-09,
     |   2.1051634758978d-08, 1.6190957796957d-07, 1.0019503723041d-06,
     |   5.1575267769954d-06, 2.2652547756786d-05, 8.6599850891460d-05,
     |   2.9275942050565d-04, 8.8640106688081d-04, 2.4287224334763d-03,
     |   6.0736158376996d-03, 1.3959940943804d-02, 2.9662021960377d-02,
     |   5.8542089718212d-02, 1.0773894797831d-01, 1.8546441271818d-01,
     |   2.9933812224057d-01, 4.5372984233628d-01, 6.4648930079169d-01,
     |   8.6592021782115d-01, 1.0891987537208d+00, 1.2834217671169d+00,
     |   1.4099546535180d+00, 1.4317782334993d+00, 1.3223836962245d+00,
     |   1.0738684763545d+00, 7.0167029166815d-01, 2.4405758834321d-01,
     |  -2.4405758834321d-01,-7.0167029166815d-01,-1.0738684763545d+00,
     |  -1.3223836962245d+00,-1.4317782334993d+00,-1.4099546535180d+00,
     |  -1.2834217671169d+00,-1.0891987537208d+00,-8.6592021782115d-01,
     |  -6.4648930079169d-01,-4.5372984233628d-01,-2.9933812224057d-01,
     |  -1.8546441271818d-01,-1.0773894797831d-01,-5.8542089718212d-02,
     |  -2.9662021960377d-02,-1.3959940943804d-02,-6.0736158376997d-03,
     |  -2.4287224334763d-03,-8.8640106688082d-04,-2.9275942050565d-04,
     |  -8.6599850891459d-05,-2.2652547756786d-05,-5.1575267769955d-06,
     |  -1.0019503723041d-06,-1.6190957796957d-07,-2.1051634758978d-08,
     |  -2.1065700630588d-09,-1.5258562938157d-10,-7.3273591717175d-12,
     |  -2.0439039324085d-13,-2.6777699688166d-15,-1.1330285089490d-17,
     |  -7.2465450987849d-21,-9.8457798456666d-26,-3.1876778942447d-36/
      data (pmn(lat,23,23), lat = 1,72)/
     |   1.0255381153657d-38, 9.5148202285509d-28, 1.1701373472795d-22,
     |   2.5712368366270d-19, 7.8533714095406d-17, 7.3741636224483d-15,
     |   3.1489627305510d-13, 7.6368802260863d-12, 1.2078449393055d-10,
     |   1.3657461387879d-09, 1.1772498242493d-08, 8.1047191581837d-08,
     |   4.6144379353540d-07, 2.2316738559153d-06, 9.3622159268797d-06,
     |   3.4643592492047d-05, 1.1461442813314d-04, 3.4280194794127d-04,
     |   9.3545756274312d-04, 2.3470196606385d-03, 5.4491765353393d-03,
     |   1.1771962777010d-02, 2.3773943587091d-02, 4.5063553934428d-02,
     |   8.0447478961229d-02, 1.3565737810507d-01, 2.1663037688835d-01,
     |   3.2831049973154d-01, 4.7309347488465d-01, 6.4921945947664d-01,
     |   8.4956189120423d-01, 1.0612923987990d+00, 1.2667718696180d+00,
     |   1.4457307571552d+00, 1.5784280527100d+00, 1.6491384156783d+00,
     |   1.6491384156783d+00, 1.5784280527100d+00, 1.4457307571552d+00,
     |   1.2667718696180d+00, 1.0612923987990d+00, 8.4956189120423d-01,
     |   6.4921945947665d-01, 4.7309347488465d-01, 3.2831049973155d-01,
     |   2.1663037688835d-01, 1.3565737810507d-01, 8.0447478961229d-02,
     |   4.5063553934428d-02, 2.3773943587091d-02, 1.1771962777010d-02,
     |   5.4491765353394d-03, 2.3470196606385d-03, 9.3545756274313d-04,
     |   3.4280194794127d-04, 1.1461442813314d-04, 3.4643592492047d-05,
     |   9.3622159268797d-06, 2.2316738559153d-06, 4.6144379353541d-07,
     |   8.1047191581837d-08, 1.1772498242493d-08, 1.3657461387879d-09,
     |   1.2078449393055d-10, 7.6368802260864d-12, 3.1489627305510d-13,
     |   7.3741636224486d-15, 7.8533714095406d-17, 2.5712368366270d-19,
     |   1.1701373472795d-22, 9.5148202285509d-28, 1.0255381153657d-38/
      data (pmn(lat, 0,24), lat = 1,72)/
     |   4.6026125067013d+00, 2.2446768377404d+00,-6.4554259680534d-01,
     |  -1.9893086331108d+00,-1.1776723096031d+00, 5.7739925330746d-01,
     |   1.4921975815044d+00, 8.3586706784900d-01,-5.5711741876169d-01,
     |  -1.2537199121402d+00,-6.4366594967391d-01, 5.5476916354703d-01,
     |   1.1073457132763d+00, 5.1161354662858d-01,-5.6080700951446d-01,
     |  -1.0057713282897d+00,-4.1062379634561d-01, 5.7154638868409d-01,
     |   9.2980370456701d-01, 3.2792066255433d-01,-5.8536073035450d-01,
     |  -8.7001378565455d-01,-2.5681497140234d-01, 6.0150106450225d-01,
     |   8.2117098733177d-01, 1.9335030477623d-01,-6.1965704157649d-01,
     |  -7.8011915010310d-01,-1.3494800672176d-01, 6.3977499975326d-01,
     |   7.4483433968508d-01, 7.9772966715055d-02,-6.6198175416565d-01,
     |  -7.1396015814542d-01,-2.6397994083433d-02, 6.8656053262916d-01,
     |   6.8656053262917d-01,-2.6397994083430d-02,-7.1396015814542d-01,
     |  -6.6198175416565d-01, 7.9772966715052d-02, 7.4483433968508d-01,
     |   6.3977499975326d-01,-1.3494800672175d-01,-7.8011915010310d-01,
     |  -6.1965704157649d-01, 1.9335030477622d-01, 8.2117098733177d-01,
     |   6.0150106450225d-01,-2.5681497140234d-01,-8.7001378565455d-01,
     |  -5.8536073035451d-01, 3.2792066255433d-01, 9.2980370456701d-01,
     |   5.7154638868410d-01,-4.1062379634560d-01,-1.0057713282897d+00,
     |  -5.6080700951445d-01, 5.1161354662858d-01, 1.1073457132763d+00,
     |   5.5476916354703d-01,-6.4366594967391d-01,-1.2537199121402d+00,
     |  -5.5711741876170d-01, 8.3586706784899d-01, 1.4921975815044d+00,
     |   5.7739925330748d-01,-1.1776723096031d+00,-1.9893086331108d+00,
     |  -6.4554259680534d-01, 2.2446768377404d+00, 4.6026125067013d+00/
      data (pmn(lat, 1,24), lat = 1,72)/
     |   1.2759591313760d+00, 2.8234039149305d+00, 2.2299444139575d+00,
     |   1.8359536255965d-01,-1.4906477385107d+00,-1.4861495801995d+00,
     |  -1.0279148866546d-01, 1.1830021292129d+00, 1.1743762850620d+00,
     |   2.5067600363753d-02,-1.0395731993241d+00,-9.8778523786165d-01,
     |   3.9994639318719d-02, 9.5631187402827d-01, 8.5773578850689d-01,
     |  -9.6140139312733d-02,-9.0260645012614d-01,-7.5874279855769d-01,
     |   1.4635413944854d-01, 8.6595738610129d-01, 6.7881703632515d-01,
     |  -1.9266099364781d-01,-8.4027078394609d-01,-6.1144240770455d-01,
     |   2.3648773928505d-01, 8.2223904717347d-01, 5.5270191831637d-01,
     |  -2.7891626311893d-01,-8.0995113419008d-01,-5.0005012647968d-01,
     |   3.2083980580161d-01, 8.0227989861382d-01, 4.5171921819744d-01,
     |  -3.6306702559859d-01,-7.9858868208252d-01,-4.0640200175235d-01,
     |   4.0640200175235d-01, 7.9858868208252d-01, 3.6306702559860d-01,
     |  -4.5171921819744d-01,-8.0227989861382d-01,-3.2083980580161d-01,
     |   5.0005012647968d-01, 8.0995113419008d-01, 2.7891626311894d-01,
     |  -5.5270191831636d-01,-8.2223904717348d-01,-2.3648773928506d-01,
     |   6.1144240770455d-01, 8.4027078394609d-01, 1.9266099364781d-01,
     |  -6.7881703632514d-01,-8.6595738610129d-01,-1.4635413944854d-01,
     |   7.5874279855769d-01, 9.0260645012614d-01, 9.6140139312737d-02,
     |  -8.5773578850689d-01,-9.5631187402827d-01,-3.9994639318731d-02,
     |   9.8778523786165d-01, 1.0395731993241d+00,-2.5067600363744d-02,
     |  -1.1743762850620d+00,-1.1830021292129d+00, 1.0279148866546d-01,
     |   1.4861495801995d+00, 1.4906477385107d+00,-1.8359536255965d-01,
     |  -2.2299444139575d+00,-2.8234039149305d+00,-1.2759591313760d+00/
      data (pmn(lat, 2,24), lat = 1,72)/
     |   1.7225117957022d-01, 1.2746569450150d+00, 2.3119066338498d+00,
     |   2.0901900242139d+00, 5.6673575311256d-01,-1.0750829383636d+00,
     |  -1.5235336245520d+00,-5.5223820363419d-01, 8.0503435966106d-01,
     |   1.2604740740578d+00, 4.7233259983518d-01,-7.0295150700631d-01,
     |  -1.1038054670943d+00,-3.9541434498811d-01, 6.5741771786767d-01,
     |   9.9765481432360d-01, 3.2713357213984d-01,-6.3732443570231d-01,
     |  -9.1989873711609d-01,-2.6635823350557d-01, 6.3089651125372d-01,
     |   8.5991394230443d-01, 2.1132519285659d-01,-6.3285136263761d-01,
     |  -8.1193197822814d-01,-1.6051046248590d-01, 6.4058233118542d-01,
     |   7.7255171334734d-01, 1.1268710713767d-01,-6.5276439401282d-01,
     |  -7.3965789877879d-01,-6.6854554429037d-02, 6.6877410159013d-01,
     |   7.1190107163319d-01, 2.2161232048654d-02,-6.8843292516083d-01,
     |  -6.8843292516083d-01, 2.2161232048652d-02, 7.1190107163319d-01,
     |   6.6877410159014d-01,-6.6854554429034d-02,-7.3965789877879d-01,
     |  -6.5276439401282d-01, 1.1268710713767d-01, 7.7255171334734d-01,
     |   6.4058233118542d-01,-1.6051046248590d-01,-8.1193197822813d-01,
     |  -6.3285136263761d-01, 2.1132519285659d-01, 8.5991394230443d-01,
     |   6.3089651125373d-01,-2.6635823350556d-01,-9.1989873711609d-01,
     |  -6.3732443570231d-01, 3.2713357213984d-01, 9.9765481432361d-01,
     |   6.5741771786767d-01,-3.9541434498812d-01,-1.1038054670943d+00,
     |  -7.0295150700631d-01, 4.7233259983518d-01, 1.2604740740578d+00,
     |   8.0503435966107d-01,-5.5223820363418d-01,-1.5235336245520d+00,
     |  -1.0750829383636d+00, 5.6673575311256d-01, 2.0901900242139d+00,
     |   2.3119066338498d+00, 1.2746569450150d+00, 1.7225117957022d-01/
      data (pmn(lat, 3,24), lat = 1,72)/
     |   1.5357117814684d-02, 3.5886911767858d-01, 1.2271535836564d+00,
     |   2.0445940816554d+00, 1.9632702755638d+00, 7.7007488088521d-01,
     |  -7.5472978403337d-01,-1.4539790444389d+00,-8.3856788988815d-01,
     |   4.4499941062504d-01, 1.2002629176480d+00, 7.8081415912572d-01,
     |  -3.3866945193189d-01,-1.0566503862801d+00,-7.1346640705622d-01,
     |   3.0047548809688d-01, 9.6686192727784d-01, 6.5202770953791d-01,
     |  -2.9137379174942d-01,-9.0720541444516d-01,-5.9799594313657d-01,
     |   2.9678996890559d-01, 8.6626974522734d-01, 5.5047095985687d-01,
     |  -3.1038934318038d-01,-8.3799395972173d-01,-5.0829983389059d-01,
     |   3.2916079275105d-01, 8.1895168041025d-01, 4.7050455302833d-01,
     |  -3.5162321531918d-01,-8.0715917201505d-01,-4.3634384426915d-01,
     |   3.7708333228907d-01, 8.0151141246484d-01, 4.0530267807366d-01,
     |  -4.0530267807366d-01,-8.0151141246484d-01,-3.7708333228908d-01,
     |   4.3634384426915d-01, 8.0715917201505d-01, 3.5162321531918d-01,
     |  -4.7050455302833d-01,-8.1895168041025d-01,-3.2916079275106d-01,
     |   5.0829983389059d-01, 8.3799395972173d-01, 3.1038934318039d-01,
     |  -5.5047095985687d-01,-8.6626974522734d-01,-2.9678996890559d-01,
     |   5.9799594313657d-01, 9.0720541444516d-01, 2.9137379174942d-01,
     |  -6.5202770953791d-01,-9.6686192727784d-01,-3.0047548809688d-01,
     |   7.1346640705623d-01, 1.0566503862801d+00, 3.3866945193190d-01,
     |  -7.8081415912572d-01,-1.2002629176480d+00,-4.4499941062505d-01,
     |   8.3856788988814d-01, 1.4539790444389d+00, 7.5472978403337d-01,
     |  -7.7007488088519d-01,-1.9632702755638d+00,-2.0445940816554d+00,
     |  -1.2271535836564d+00,-3.5886911767858d-01,-1.5357117814684d-02/
      data (pmn(lat, 4,24), lat = 1,72)/
     |   1.0192243873933d-03, 7.3637816122284d-02, 4.4886102730778d-01,
     |   1.1860957830871d+00, 1.8725781958765d+00, 1.8592436689891d+00,
     |   8.9058644196986d-01,-5.0478937136750d-01,-1.3426953813362d+00,
     |  -1.0166474620456d+00, 1.2749584826766d-01, 1.0586885403495d+00,
     |   9.7132642712303d-01, 6.1343313476778d-03,-9.0152967296495d-01,
     |  -9.1009578224936d-01,-5.6001687004998d-02, 8.0910059572247d-01,
     |   8.5556297800089d-01, 7.0854354282327d-02,-7.5286216829893d-01,
     |  -8.1044427374814d-01,-6.9179112082099d-02, 7.1872397564377d-01,
     |   7.7392925889598d-01, 5.9073743631062d-02,-6.9918313778799d-01,
     |  -7.4481061482210d-01,-4.4474253924771d-02, 6.9001961519966d-01,
     |   7.2213229753186d-01, 2.7467985583581d-02,-6.8879528036550d-01,
     |  -7.0530555932243d-01,-9.2752599171469d-03, 6.9412468036203d-01,
     |   6.9412468036203d-01,-9.2752599171446d-03,-7.0530555932243d-01,
     |  -6.8879528036550d-01, 2.7467985583578d-02, 7.2213229753186d-01,
     |   6.9001961519966d-01,-4.4474253924764d-02,-7.4481061482210d-01,
     |  -6.9918313778800d-01, 5.9073743631058d-02, 7.7392925889598d-01,
     |   7.1872397564378d-01,-6.9179112082099d-02,-8.1044427374814d-01,
     |  -7.5286216829894d-01, 7.0854354282325d-02, 8.5556297800089d-01,
     |   8.0910059572248d-01,-5.6001687004990d-02,-9.1009578224936d-01,
     |  -9.0152967296494d-01, 6.1343313476817d-03, 9.7132642712302d-01,
     |   1.0586885403495d+00, 1.2749584826766d-01,-1.0166474620456d+00,
     |  -1.3426953813362d+00,-5.0478937136750d-01, 8.9058644196986d-01,
     |   1.8592436689891d+00, 1.8725781958765d+00, 1.1860957830871d+00,
     |   4.4886102730778d-01, 7.3637816122284d-02, 1.0192243873933d-03/
      data (pmn(lat, 5,24), lat = 1,72)/
     |   5.3681537573753d-05, 1.1869445579859d-02, 1.2586677234154d-01,
     |   5.0120989549213d-01, 1.1504255611984d+00, 1.7485844681934d+00,
     |   1.7748867752917d+00, 9.6999719006648d-01,-3.0260497649265d-01,
     |  -1.2155665499026d+00,-1.1226312580699d+00,-1.4515776850680d-01,
     |   8.7271951087803d-01, 1.0669623281728d+00, 3.0994193567613d-01,
     |  -6.7922026457002d-01,-9.9471947311792d-01,-3.7574972162863d-01,
     |   5.6544114069380d-01, 9.3408156415417d-01, 4.0138973084574d-01,
     |  -4.9622634341302d-01,-8.8757833791481d-01,-4.0937900729433d-01,
     |   4.5356445740460d-01, 8.5343054205605d-01, 4.0959826022818d-01,
     |  -4.2763659863214d-01,-8.2959522263880d-01,-4.0692908218302d-01,
     |   4.1273798763944d-01, 8.1452167269521d-01, 4.0412629650396d-01,
     |  -4.0533390202164d-01,-8.0722209103278d-01,-4.0305711728572d-01,
     |   4.0305711728572d-01, 8.0722209103278d-01, 4.0533390202164d-01,
     |  -4.0412629650396d-01,-8.1452167269521d-01,-4.1273798763944d-01,
     |   4.0692908218302d-01, 8.2959522263880d-01, 4.2763659863214d-01,
     |  -4.0959826022818d-01,-8.5343054205605d-01,-4.5356445740460d-01,
     |   4.0937900729433d-01, 8.8757833791481d-01, 4.9622634341302d-01,
     |  -4.0138973084573d-01,-9.3408156415417d-01,-5.6544114069381d-01,
     |   3.7574972162863d-01, 9.9471947311792d-01, 6.7922026457003d-01,
     |  -3.0994193567613d-01,-1.0669623281728d+00,-8.7271951087804d-01,
     |   1.4515776850680d-01, 1.1226312580699d+00, 1.2155665499026d+00,
     |   3.0260497649266d-01,-9.6999719006648d-01,-1.7748867752917d+00,
     |  -1.7485844681935d+00,-1.1504255611984d+00,-5.0120989549213d-01,
     |  -1.2586677234154d-01,-1.1869445579859d-02,-5.3681537573753d-05/
      data (pmn(lat, 6,24), lat = 1,72)/
     |   2.3341327210334d-06, 1.5704505256417d-03, 2.8599676388294d-02,
     |   1.6750640883227d-01, 5.3354212571997d-01, 1.1175957247247d+00,
     |   1.6521878751632d+00, 1.7060813385558d+00, 1.0284921189174d+00,
     |  -1.3159293112993d-01,-1.0821181431205d+00,-1.1787584852499d+00,
     |  -3.7741525231329d-01, 6.6264721520462d-01, 1.0864561172514d+00,
     |   5.6357211268895d-01,-4.1859851176343d-01,-9.8057283200610d-01,
     |  -6.3631295946668d-01, 2.7163834695161d-01, 8.9437100931275d-01,
     |   6.6512327985234d-01,-1.7862256154600d-01,-8.2905170867351d-01,
     |  -6.7646350874033d-01, 1.1669142303740d-01, 7.8077866951408d-01,
     |   6.8166074134834d-01,-7.3090612017205d-02,-7.4572594966995d-01,
     |  -6.8613653656750d-01, 4.0154169170033d-02, 7.2086420005805d-01,
     |   6.9287208822062d-01,-1.2804509402640d-02,-7.0387072995729d-01,
     |  -7.0387072995729d-01,-1.2804509402642d-02, 6.9287208822062d-01,
     |   7.2086420005805d-01, 4.0154169170036d-02,-6.8613653656750d-01,
     |  -7.4572594966995d-01,-7.3090612017213d-02, 6.8166074134833d-01,
     |   7.8077866951408d-01, 1.1669142303740d-01,-6.7646350874032d-01,
     |  -8.2905170867351d-01,-1.7862256154600d-01, 6.6512327985234d-01,
     |   8.9437100931275d-01, 2.7163834695161d-01,-6.3631295946668d-01,
     |  -9.8057283200610d-01,-4.1859851176344d-01, 5.6357211268895d-01,
     |   1.0864561172514d+00, 6.6264721520462d-01,-3.7741525231328d-01,
     |  -1.1787584852499d+00,-1.0821181431205d+00,-1.3159293112994d-01,
     |   1.0284921189174d+00, 1.7060813385558d+00, 1.6521878751632d+00,
     |   1.1175957247247d+00, 5.3354212571997d-01, 1.6750640883227d-01,
     |   2.8599676388294d-02, 1.5704505256417d-03, 2.3341327210334d-06/
      data (pmn(lat, 7,24), lat = 1,72)/
     |   8.6034729664131d-08, 1.7552301943507d-04, 5.4471780577521d-03,
     |   4.6289730857600d-02, 1.9987851357727d-01, 5.5287215526311d-01,
     |   1.0856799196816d+00, 1.5728151716477d+00, 1.6493824818491d+00,
     |   1.0766410952575d+00, 1.9923426386164d-02,-9.4477603390309d-01,
     |  -1.1980102228846d+00,-5.7457891721481d-01, 4.3946733921278d-01,
     |   1.0432009358133d+00, 7.6287962255169d-01,-1.4058640057322d-01,
     |  -8.8093078892190d-01,-8.2305592262273d-01,-4.1035645699172d-02,
     |   7.4927976734951d-01, 8.3644065959070d-01, 1.5819215065009d-01,
     |  -6.4694500008547d-01,-8.3332508435285d-01,-2.3945511523939d-01,
     |   5.6687286610129d-01, 8.2586419148490d-01, 3.0086275761162d-01,
     |  -5.0244395203889d-01,-8.1917590047461d-01,-3.5208515043562d-01,
     |   4.4821715795262d-01, 8.1542938758405d-01, 3.9956587832325d-01,
     |  -3.9956587832325d-01,-8.1542938758405d-01,-4.4821715795262d-01,
     |   3.5208515043562d-01, 8.1917590047460d-01, 5.0244395203889d-01,
     |  -3.0086275761162d-01,-8.2586419148490d-01,-5.6687286610129d-01,
     |   2.3945511523938d-01, 8.3332508435285d-01, 6.4694500008547d-01,
     |  -1.5819215065009d-01,-8.3644065959070d-01,-7.4927976734951d-01,
     |   4.1035645699159d-02, 8.2305592262273d-01, 8.8093078892190d-01,
     |   1.4058640057323d-01,-7.6287962255168d-01,-1.0432009358133d+00,
     |  -4.3946733921278d-01, 5.7457891721482d-01, 1.1980102228846d+00,
     |   9.4477603390309d-01,-1.9923426386164d-02,-1.0766410952574d+00,
     |  -1.6493824818491d+00,-1.5728151716477d+00,-1.0856799196816d+00,
     |  -5.5287215526311d-01,-1.9987851357727d-01,-4.6289730857600d-02,
     |  -5.4471780577521d-03,-1.7552301943507d-04,-8.6034729664131d-08/
      data (pmn(lat, 8,24), lat = 1,72)/
     |   2.7389812868104d-09, 1.6904337112643d-05, 8.8953563017508d-04,
     |   1.0875094093451d-02, 6.2796579288722d-02, 2.2430966976212d-01,
     |   5.6247959511105d-01, 1.0532587113519d+00, 1.5042250273067d+00,
     |   1.6019868731077d+00, 1.1202043328158d+00, 1.6014839903508d-01,
     |  -8.0279878705917d-01,-1.1872813534809d+00,-7.4058587835499d-01,
     |   2.0942147667504d-01, 9.4610233323421d-01, 9.0495927603126d-01,
     |   1.3825748528807d-01,-7.0836876861753d-01,-9.2557517729514d-01,
     |  -3.4385606296021d-01, 5.1637843675550d-01, 8.9727142208112d-01,
     |   4.7207002595869d-01,-3.6485440359411d-01,-8.5400511560510d-01,
     |  -5.5805549209608d-01, 2.4229970955547d-01, 8.0789831975575d-01,
     |   6.2111093504788d-01,-1.3847403640929d-01,-7.6260903497744d-01,
     |  -6.7226640030626d-01, 4.5048962971060d-02, 7.1810362744714d-01,
     |   7.1810362744714d-01, 4.5048962971062d-02,-6.7226640030626d-01,
     |  -7.6260903497744d-01,-1.3847403640929d-01, 6.2111093504789d-01,
     |   8.0789831975575d-01, 2.4229970955548d-01,-5.5805549209608d-01,
     |  -8.5400511560510d-01,-3.6485440359412d-01, 4.7207002595868d-01,
     |   8.9727142208112d-01, 5.1637843675550d-01,-3.4385606296021d-01,
     |  -9.2557517729513d-01,-7.0836876861753d-01, 1.3825748528806d-01,
     |   9.0495927603126d-01, 9.4610233323421d-01, 2.0942147667505d-01,
     |  -7.4058587835499d-01,-1.1872813534809d+00,-8.0279878705918d-01,
     |   1.6014839903508d-01, 1.1202043328158d+00, 1.6019868731077d+00,
     |   1.5042250273067d+00, 1.0532587113519d+00, 5.6247959511105d-01,
     |   2.2430966976213d-01, 6.2796579288722d-02, 1.0875094093451d-02,
     |   8.8953563017508d-04, 1.6904337112643d-05, 2.7389812868104d-09/
      data (pmn(lat, 9,24), lat = 1,72)/
     |   7.6345421531989d-11, 1.4231018221845d-06, 1.2654300432810d-04,
     |   2.2130996627250d-03, 1.6940696902459d-02, 7.7106113387958d-02,
     |   2.4171951246131d-01, 5.6404482454444d-01, 1.0192182442985d+00,
     |   1.4422901360762d+00, 1.5614811284765d+00, 1.1622454059719d+00,
     |   2.9482734514926d-01,-6.5404917087845d-01,-1.1493720401504d+00,
     |  -8.7719810458892d-01,-2.3156260341719d-02, 8.0094586695018d-01,
     |   9.8633723703772d-01, 4.0286940628778d-01,-4.7560341101371d-01,
     |  -9.3610556568942d-01,-6.0876924877560d-01, 2.1855446906800d-01,
     |   8.3700908308205d-01, 7.2057241136098d-01,-1.8597363427805d-02,
     |  -7.2650823357711d-01,-7.8101258093299d-01,-1.4141942090669d-01,
     |   6.1582861000597d-01, 8.1231570836556d-01, 2.7564927826991d-01,
     |  -5.0622361448828d-01,-8.2563619971777d-01,-3.9466418024430d-01,
     |   3.9466418024429d-01, 8.2563619971777d-01, 5.0622361448828d-01,
     |  -2.7564927826990d-01,-8.1231570836555d-01,-6.1582861000597d-01,
     |   1.4141942090668d-01, 7.8101258093299d-01, 7.2650823357711d-01,
     |   1.8597363427807d-02,-7.2057241136098d-01,-8.3700908308205d-01,
     |  -2.1855446906801d-01, 6.0876924877560d-01, 9.3610556568942d-01,
     |   4.7560341101372d-01,-4.0286940628777d-01,-9.8633723703772d-01,
     |  -8.0094586695018d-01, 2.3156260341712d-02, 8.7719810458892d-01,
     |   1.1493720401504d+00, 6.5404917087844d-01,-2.9482734514925d-01,
     |  -1.1622454059719d+00,-1.5614811284765d+00,-1.4422901360762d+00,
     |  -1.0192182442985d+00,-5.6404482454444d-01,-2.4171951246131d-01,
     |  -7.7106113387959d-02,-1.6940696902459d-02,-2.2130996627250d-03,
     |  -1.2654300432810d-04,-1.4231018221845d-06,-7.6345421531989d-11/
      data (pmn(lat,10,24), lat = 1,72)/
     |   1.8820224984883d-12, 1.0583057542811d-07, 1.5862869133172d-05,
     |   3.9527967256085d-04, 3.9872103456539d-03, 2.2923095880350d-02,
     |   8.8678403570041d-02, 2.5271737593083d-01, 5.5846949935257d-01,
     |   9.8261231455987d-01, 1.3839651318427d+00, 1.5256025047999d+00,
     |   1.2040996841365d+00, 4.2785298563115d-01,-4.9587588680370d-01,
     |  -1.0842375156311d+00,-9.8369940294714d-01,-2.5391285451730d-01,
     |   6.1191160729212d-01, 1.0023655330185d+00, 6.3752230428422d-01,
     |  -1.9721081260640d-01,-8.4962668707366d-01,-8.0726142127181d-01,
     |  -1.1432238783699d-01, 6.5446770496700d-01, 8.6242279722160d-01,
     |   3.4263174060763d-01,-4.5785174973839d-01,-8.5488626655676d-01,
     |  -5.1186686209399d-01, 2.6968410791593d-01, 8.0976631794112d-01,
     |   6.3983801351914d-01,-8.8969640105664d-02,-7.3753006715558d-01,
     |  -7.3753006715558d-01,-8.8969640105667d-02, 6.3983801351914d-01,
     |   8.0976631794112d-01, 2.6968410791593d-01,-5.1186686209399d-01,
     |  -8.5488626655676d-01,-4.5785174973840d-01, 3.4263174060763d-01,
     |   8.6242279722160d-01, 6.5446770496700d-01,-1.1432238783698d-01,
     |  -8.0726142127180d-01,-8.4962668707366d-01,-1.9721081260640d-01,
     |   6.3752230428421d-01, 1.0023655330185d+00, 6.1191160729212d-01,
     |  -2.5391285451730d-01,-9.8369940294714d-01,-1.0842375156311d+00,
     |  -4.9587588680369d-01, 4.2785298563115d-01, 1.2040996841365d+00,
     |   1.5256025047999d+00, 1.3839651318427d+00, 9.8261231455987d-01,
     |   5.5846949935257d-01, 2.5271737593083d-01, 8.8678403570041d-02,
     |   2.2923095880350d-02, 3.9872103456539d-03, 3.9527967256085d-04,
     |   1.5862869133172d-05, 1.0583057542811d-07, 1.8820224984883d-12/
      data (pmn(lat,11,24), lat = 1,72)/
     |   4.1337084197798d-14, 7.0061245157296d-09, 1.7669493165886d-06,
     |   6.2551582120632d-05, 8.2790237524329d-04, 5.9757114296858d-03,
     |   2.8281660207046d-02, 9.7203991935234d-02, 2.5771885568189d-01,
     |   5.4624416341196d-01, 9.4257850283720d-01, 1.3267528643931d+00,
     |   1.4920420393874d+00, 1.2458043456494d+00, 5.6156122706565d-01,
     |  -3.2565662085065d-01,-9.8983545409517d-01,-1.0567754107063d+00,
     |  -4.7701026707550d-01, 3.8322050284472d-01, 9.4750657481557d-01,
     |   8.2437059835554d-01, 1.0814525278200d-01,-6.6556096222224d-01,
     |  -9.1058754816762d-01,-4.4352575301505d-01, 3.6183186912073d-01,
     |   8.6157202819669d-01, 6.5636925588331d-01,-8.0856380980387d-02,
     |  -7.4143794625706d-01,-7.8026045454771d-01,-1.6860984458126d-01,
     |   5.7976349214399d-01, 8.3704870766562d-01, 3.8809787996809d-01,
     |  -3.8809787996808d-01,-8.3704870766562d-01,-5.7976349214399d-01,
     |   1.6860984458125d-01, 7.8026045454771d-01, 7.4143794625706d-01,
     |   8.0856380980390d-02,-6.5636925588330d-01,-8.6157202819669d-01,
     |  -3.6183186912074d-01, 4.4352575301505d-01, 9.1058754816762d-01,
     |   6.6556096222224d-01,-1.0814525278200d-01,-8.2437059835554d-01,
     |  -9.4750657481558d-01,-3.8322050284472d-01, 4.7701026707550d-01,
     |   1.0567754107063d+00, 9.8983545409518d-01, 3.2565662085066d-01,
     |  -5.6156122706565d-01,-1.2458043456494d+00,-1.4920420393874d+00,
     |  -1.3267528643931d+00,-9.4257850283720d-01,-5.4624416341196d-01,
     |  -2.5771885568189d-01,-9.7203991935234d-02,-2.8281660207046d-02,
     |  -5.9757114296859d-03,-8.2790237524329d-04,-6.2551582120632d-05,
     |  -1.7669493165886d-06,-7.0061245157296d-09,-4.1337084197798d-14/
      data (pmn(lat,12,24), lat = 1,72)/
     |   8.1330793340946d-16, 4.1519467252331d-10, 1.7594175152494d-07,
     |   8.8291102699978d-06, 1.5284557419392d-04, 1.3789576795730d-03,
     |   7.9358843794379d-03, 3.2618423604605d-02, 1.0251115172911d-01,
     |   2.5703437462071d-01, 5.2763769588278d-01, 8.9829415871663d-01,
     |   1.2684107184254d+00, 1.4582876609076d+00, 1.2862519413059d+00,
     |   6.9679156220311d-01,-1.4126770875449d-01,-8.6282151466004d-01,
     |  -1.0905071471701d+00,-6.8388289110853d-01, 1.2100967549084d-01,
     |   8.1649211464314d-01, 9.4285240245799d-01, 4.1529953323927d-01,
     |  -3.9105465476801d-01,-8.9210396533746d-01,-7.2055213862554d-01,
     |  -9.8663628507333d-03, 6.9507364407387d-01, 8.5078203506889d-01,
     |   3.3925576579673d-01,-4.3378425301769d-01,-8.5497214182226d-01,
     |  -5.9013355525076d-01, 1.4682981201749d-01, 7.6327797022776d-01,
     |   7.6327797022776d-01, 1.4682981201750d-01,-5.9013355525076d-01,
     |  -8.5497214182226d-01,-4.3378425301769d-01, 3.3925576579673d-01,
     |   8.5078203506889d-01, 6.9507364407388d-01,-9.8663628507304d-03,
     |  -7.2055213862554d-01,-8.9210396533746d-01,-3.9105465476802d-01,
     |   4.1529953323927d-01, 9.4285240245799d-01, 8.1649211464314d-01,
     |   1.2100967549085d-01,-6.8388289110853d-01,-1.0905071471701d+00,
     |  -8.6282151466004d-01,-1.4126770875450d-01, 6.9679156220311d-01,
     |   1.2862519413059d+00, 1.4582876609076d+00, 1.2684107184254d+00,
     |   8.9829415871663d-01, 5.2763769588278d-01, 2.5703437462071d-01,
     |   1.0251115172911d-01, 3.2618423604605d-02, 7.9358843794379d-03,
     |   1.3789576795730d-03, 1.5284557419392d-04, 8.8291102699978d-06,
     |   1.7594175152494d-07, 4.1519467252331d-10, 8.1330793340946d-16/
      data (pmn(lat,13,24), lat = 1,72)/
     |   1.4386269916799d-17, 2.2109249865874d-11, 1.5724975304054d-08,
     |   1.1166840255511d-06, 2.5223465698545d-05, 2.8349612561363d-04,
     |   1.9750556285222d-03, 9.6498422522724d-03, 3.5653053399652d-02,
     |   1.0453329535587d-01, 2.5093606365265d-01, 5.0281284379997d-01,
     |   8.4896600023734d-01, 1.2067923414352d+00, 1.4215066838766d+00,
     |   1.3231951979214d+00, 8.3276161790099d-01, 5.8372498811167d-02,
     |  -6.9929660603016d-01,-1.0765496068740d+00,-8.6215857521848d-01,
     |  -1.6447104037557d-01, 6.0652678950834d-01, 9.7034907248876d-01,
     |   6.9051539613666d-01,-4.5728471953876d-02,-7.3259966598351d-01,
     |  -8.8892141098039d-01,-4.0513580066787d-01, 3.6545996689426d-01,
     |   8.5576672343998d-01, 7.0279327439588d-01, 2.3224067687396d-02,
     |  -6.6883961715775d-01,-8.4841259066034d-01,-3.7947934674648d-01,
     |   3.7947934674648d-01, 8.4841259066034d-01, 6.6883961715775d-01,
     |  -2.3224067687394d-02,-7.0279327439588d-01,-8.5576672343998d-01,
     |  -3.6545996689427d-01, 4.0513580066787d-01, 8.8892141098039d-01,
     |   7.3259966598351d-01, 4.5728471953879d-02,-6.9051539613665d-01,
     |  -9.7034907248876d-01,-6.0652678950834d-01, 1.6447104037557d-01,
     |   8.6215857521847d-01, 1.0765496068740d+00, 6.9929660603016d-01,
     |  -5.8372498811164d-02,-8.3276161790098d-01,-1.3231951979214d+00,
     |  -1.4215066838766d+00,-1.2067923414352d+00,-8.4896600023734d-01,
     |  -5.0281284379997d-01,-2.5093606365265d-01,-1.0453329535587d-01,
     |  -3.5653053399652d-02,-9.6498422522724d-03,-1.9750556285222d-03,
     |  -2.8349612561363d-04,-2.5223465698545d-05,-1.1166840255511d-06,
     |  -1.5724975304054d-08,-2.2109249865874d-11,-1.4386269916799d-17/
      data (pmn(lat,14,24), lat = 1,72)/
     |   2.2926123906203d-19, 1.0602346355536d-12, 1.2645647969670d-09,
     |   1.2690752291422d-07, 3.7331269778295d-06, 5.2136720612859d-05,
     |   4.3821715744690d-04, 2.5337503878898d-03, 1.0940524014045d-02,
     |   3.7210441347973d-02, 1.0330285468421d-01, 2.3971301285097d-01,
     |   4.7191363693988d-01, 7.9385353914164d-01, 1.1397841841237d+00,
     |   1.3784772503993d+00, 1.3531806507182d+00, 9.6679506790501d-01,
     |   2.7259455827712d-01,-4.9579333259489d-01,-1.0046771472096d+00,
     |  -9.9486341079505d-01,-4.5635297220647d-01, 3.2078549284462d-01,
     |   8.8479153018617d-01, 8.9075243339399d-01, 3.3268862073613d-01,
     |  -4.2943656145786d-01,-8.9125553154024d-01,-7.4137860354129d-01,
     |  -8.3347230553984d-02, 6.2484824308333d-01, 8.8570681353279d-01,
     |   5.1505818549703d-01,-2.2204405827956d-01,-7.9718822731489d-01,
     |  -7.9718822731489d-01,-2.2204405827957d-01, 5.1505818549703d-01,
     |   8.8570681353279d-01, 6.2484824308333d-01,-8.3347230553985d-02,
     |  -7.4137860354129d-01,-8.9125553154024d-01,-4.2943656145787d-01,
     |   3.3268862073613d-01, 8.9075243339399d-01, 8.8479153018617d-01,
     |   3.2078549284463d-01,-4.5635297220647d-01,-9.9486341079505d-01,
     |  -1.0046771472097d+00,-4.9579333259489d-01, 2.7259455827711d-01,
     |   9.6679506790501d-01, 1.3531806507182d+00, 1.3784772503993d+00,
     |   1.1397841841237d+00, 7.9385353914164d-01, 4.7191363693989d-01,
     |   2.3971301285097d-01, 1.0330285468421d-01, 3.7210441347973d-02,
     |   1.0940524014045d-02, 2.5337503878899d-03, 4.3821715744690d-04,
     |   5.2136720612860d-05, 3.7331269778295d-06, 1.2690752291422d-07,
     |   1.2645647969670d-09, 1.0602346355536d-12, 2.2926123906203d-19/
      data (pmn(lat,15,24), lat = 1,72)/
     |   3.2936354904262d-21, 4.5818781159981d-14, 9.1580247794144d-11,
     |   1.2974245164101d-08, 4.9626926249388d-07, 8.5947835269903d-06,
     |   8.6924993119619d-05, 5.9274478632975d-04, 2.9779552692961d-03,
     |   1.1681555234522d-02, 3.7216608729645d-02, 9.8957935253839d-02,
     |   2.2372212966710d-01, 4.3514747959586d-01, 7.3233071402549d-01,
     |   1.0653272703976d+00, 1.3255917263048d+00, 1.3714787892822d+00,
     |   1.0939521236540d+00, 4.9805177057676d-01,-2.5068381830206d-01,
     |  -8.6398692094673d-01,-1.0602559899223d+00,-7.2858627298623d-01,
     |  -2.6637550175522d-02, 6.7015467861906d-01, 9.6599422757411d-01,
     |   6.8350166298023d-01,-9.5254514113220d-03,-6.8473471135531d-01,
     |  -9.1487077896792d-01,-5.5136170485368d-01, 1.6924068309370d-01,
     |   7.7241041850572d-01, 8.5770605354117d-01, 3.6820275158622d-01,
     |  -3.6820275158622d-01,-8.5770605354117d-01,-7.7241041850572d-01,
     |  -1.6924068309371d-01, 5.5136170485368d-01, 9.1487077896792d-01,
     |   6.8473471135531d-01, 9.5254514113283d-03,-6.8350166298023d-01,
     |  -9.6599422757410d-01,-6.7015467861907d-01, 2.6637550175517d-02,
     |   7.2858627298622d-01, 1.0602559899223d+00, 8.6398692094673d-01,
     |   2.5068381830207d-01,-4.9805177057676d-01,-1.0939521236540d+00,
     |  -1.3714787892822d+00,-1.3255917263048d+00,-1.0653272703976d+00,
     |  -7.3233071402549d-01,-4.3514747959586d-01,-2.2372212966710d-01,
     |  -9.8957935253839d-02,-3.7216608729645d-02,-1.1681555234522d-02,
     |  -2.9779552692961d-03,-5.9274478632975d-04,-8.6924993119619d-05,
     |  -8.5947835269905d-06,-4.9626926249388d-07,-1.2974245164101d-08,
     |  -9.1580247794144d-11,-4.5818781159981d-14,-3.2936354904262d-21/
      data (pmn(lat,16,24), lat = 1,72)/
     |   4.2618233550813d-23, 1.7829435320530d-15, 5.9685056891554d-12,
     |   1.1925984658140d-09, 5.9243750533203d-08, 1.2702712781967d-06,
     |   1.5426053120011d-05, 1.2372590923332d-04, 7.2078535219828d-04,
     |   3.2467777233384d-03, 1.1804075641488d-02, 3.5699070162362d-02,
     |   9.1755182223346d-02, 2.0343857242733d-01, 3.9287389213929d-01,
     |   6.6399206249801d-01, 9.8153163332570d-01, 1.2589707373970d+00,
     |   1.3720927150920d+00, 1.2066473740857d+00, 7.2758384643178d-01,
     |   3.3832973203248d-02,-6.4515539728874d-01,-1.0329324887763d+00,
     |  -9.4402676472650d-01,-4.0458389357133d-01, 3.2578602193679d-01,
     |   8.6723727532307d-01, 9.2253562708815d-01, 4.5608451674429d-01,
     |  -2.6721497847941d-01,-8.2377037570524d-01,-8.8068637524903d-01,
     |  -4.0233675550308d-01, 3.1999770411729d-01, 8.4244301953115d-01,
     |   8.4244301953115d-01, 3.1999770411730d-01,-4.0233675550308d-01,
     |  -8.8068637524903d-01,-8.2377037570524d-01,-2.6721497847941d-01,
     |   4.5608451674429d-01, 9.2253562708814d-01, 8.6723727532307d-01,
     |   3.2578602193679d-01,-4.0458389357133d-01,-9.4402676472649d-01,
     |  -1.0329324887763d+00,-6.4515539728874d-01, 3.3832973203248d-02,
     |   7.2758384643177d-01, 1.2066473740857d+00, 1.3720927150920d+00,
     |   1.2589707373970d+00, 9.8153163332571d-01, 6.6399206249801d-01,
     |   3.9287389213929d-01, 2.0343857242733d-01, 9.1755182223347d-02,
     |   3.5699070162362d-02, 1.1804075641488d-02, 3.2467777233384d-03,
     |   7.2078535219829d-04, 1.2372590923332d-04, 1.5426053120011d-05,
     |   1.2702712781967d-06, 5.9243750533203d-08, 1.1925984658140d-09,
     |   5.9685056891554d-12, 1.7829435320530d-15, 4.2618233550813d-23/
      data (pmn(lat,17,24), lat = 1,72)/
     |   4.9540389266423d-25, 6.2312289206947d-17, 3.4919193919363d-13,
     |   9.8338114295793d-11, 6.3378354384979d-09, 1.6801584018258d-07,
     |   2.4457666218484d-06, 2.3023384658160d-05, 1.5510981014833d-04,
     |   7.9961870631032d-04, 3.3033392676570d-03, 1.1301075938169d-02,
     |   3.2788366935482d-02, 8.2084413345025d-02, 1.7950632660856d-01,
     |   3.4570473653432d-01, 5.8880873251104d-01, 8.8689961843899d-01,
     |   1.1747426712613d+00, 1.3479589647455d+00, 1.2944076603937d+00,
     |   9.4898419916648d-01, 3.4909687120351d-01,-3.4419351645161d-01,
     |  -8.8719220433346d-01,-1.0546149618654d+00,-7.5873497425070d-01,
     |  -1.2017865529708d-01, 5.6330069344180d-01, 9.5224531375454d-01,
     |   8.4292746630996d-01, 2.8810994963268d-01,-4.1680918050883d-01,
     |  -8.8706743739637d-01,-8.6151321400180d-01,-3.5326639399728d-01,
     |   3.5326639399728d-01, 8.6151321400180d-01, 8.8706743739637d-01,
     |   4.1680918050883d-01,-2.8810994963268d-01,-8.4292746630996d-01,
     |  -9.5224531375454d-01,-5.6330069344181d-01, 1.2017865529708d-01,
     |   7.5873497425070d-01, 1.0546149618654d+00, 8.8719220433346d-01,
     |   3.4419351645161d-01,-3.4909687120351d-01,-9.4898419916648d-01,
     |  -1.2944076603937d+00,-1.3479589647455d+00,-1.1747426712613d+00,
     |  -8.8689961843899d-01,-5.8880873251104d-01,-3.4570473653432d-01,
     |  -1.7950632660855d-01,-8.2084413345025d-02,-3.2788366935482d-02,
     |  -1.1301075938169d-02,-3.3033392676570d-03,-7.9961870631033d-04,
     |  -1.5510981014833d-04,-2.3023384658160d-05,-2.4457666218484d-06,
     |  -1.6801584018258d-07,-6.3378354384979d-09,-9.8338114295793d-11,
     |  -3.4919193919363d-13,-6.2312289206947d-17,-4.9540389266423d-25/
      data (pmn(lat,18,24), lat = 1,72)/
     |   5.1490353304053d-27, 1.9468230551419d-18, 1.8255988642078d-14,
     |   7.2414345955495d-12, 6.0498647779033d-10, 1.9807446352790d-08,
     |   3.4513488644203d-07, 3.8065315305740d-06, 2.9592482773466d-05,
     |   1.7412337359305d-04, 8.1465462558687d-04, 3.1396129157421d-03,
     |   1.0228596257899d-02, 2.8717523496484d-02, 7.0480353278503d-02,
     |   1.5278541955529d-01, 2.9461338152841d-01, 5.0733381007697d-01,
     |   7.8067417141115d-01, 1.0695550166840d+00, 1.2914959994573d+00,
     |   1.3440277266000d+00, 1.1439740924047d+00, 6.7687003253281d-01,
     |   3.1972916007487d-02,-6.0393595938990d-01,-1.0061094055223d+00,
     |  -1.0086836891909d+00,-5.9525674007472d-01, 6.8632417496678d-02,
     |   6.9124672903326d-01, 9.8373896484796d-01, 8.0300714118335d-01,
     |   2.3232472858275d-01,-4.4996356295748d-01,-9.0510828387870d-01,
     |  -9.0510828387870d-01,-4.4996356295748d-01, 2.3232472858275d-01,
     |   8.0300714118335d-01, 9.8373896484796d-01, 6.9124672903326d-01,
     |   6.8632417496681d-02,-5.9525674007472d-01,-1.0086836891909d+00,
     |  -1.0061094055223d+00,-6.0393595938990d-01, 3.1972916007483d-02,
     |   6.7687003253281d-01, 1.1439740924047d+00, 1.3440277266000d+00,
     |   1.2914959994573d+00, 1.0695550166840d+00, 7.8067417141115d-01,
     |   5.0733381007698d-01, 2.9461338152841d-01, 1.5278541955529d-01,
     |   7.0480353278502d-02, 2.8717523496484d-02, 1.0228596257900d-02,
     |   3.1396129157421d-03, 8.1465462558687d-04, 1.7412337359305d-04,
     |   2.9592482773467d-05, 3.8065315305741d-06, 3.4513488644203d-07,
     |   1.9807446352791d-08, 6.0498647779033d-10, 7.2414345955495d-12,
     |   1.8255988642078d-14, 1.9468230551419d-18, 5.1490353304053d-27/
      data (pmn(lat,19,24), lat = 1,72)/
     |   4.7493956461196d-29, 5.3969993317542d-20, 8.4658765601231d-16,
     |   4.7274451185016d-13, 5.1160950445282d-11, 2.0667634643184d-09,
     |   4.3056370250973d-08, 5.5556394681334d-07, 4.9750249192314d-06,
     |   3.3339529606895d-05, 1.7618513340392d-04, 7.6241665668154d-04,
     |   2.7779197809202d-03, 8.7024908964768d-03, 2.3815793944719d-02,
     |   5.7625295534365d-02, 1.2438703912640d-01, 2.4104030588905d-01,
     |   4.2094294635628d-01, 6.6331416464631d-01, 9.4137967089328d-01,
     |   1.1956921043923d+00, 1.3405163826304d+00, 1.2879875175334d+00,
     |   9.8638264881435d-01, 4.5827973422626d-01,-1.8226190291566d-01,
     |  -7.5085817507818d-01,-1.0541927321087d+00,-9.7167695795886d-01,
     |  -5.2071387702620d-01, 1.3101085355144d-01, 7.2194756715701d-01,
     |   1.0039616032620d+00, 8.5355705112423d-01, 3.3284446033091d-01,
     |  -3.3284446033091d-01,-8.5355705112423d-01,-1.0039616032620d+00,
     |  -7.2194756715701d-01,-1.3101085355144d-01, 5.2071387702620d-01,
     |   9.7167695795886d-01, 1.0541927321087d+00, 7.5085817507818d-01,
     |   1.8226190291566d-01,-4.5827973422626d-01,-9.8638264881434d-01,
     |  -1.2879875175334d+00,-1.3405163826304d+00,-1.1956921043923d+00,
     |  -9.4137967089328d-01,-6.6331416464631d-01,-4.2094294635628d-01,
     |  -2.4104030588905d-01,-1.2438703912640d-01,-5.7625295534366d-02,
     |  -2.3815793944719d-02,-8.7024908964768d-03,-2.7779197809202d-03,
     |  -7.6241665668154d-04,-1.7618513340392d-04,-3.3339529606895d-05,
     |  -4.9750249192315d-06,-5.5556394681335d-07,-4.3056370250973d-08,
     |  -2.0667634643184d-09,-5.1160950445282d-11,-4.7274451185016d-13,
     |  -8.4658765601231d-16,-5.3969993317542d-20,-4.7493956461196d-29/
      data (pmn(lat,20,24), lat = 1,72)/
     |   3.8429801907166d-31, 1.3122999220906d-21, 3.4424449576352d-17,
     |   2.7049776857999d-14, 3.7896771690877d-12, 1.8874746263427d-10,
     |   4.6966107276428d-09, 7.0812383067607d-08, 7.2935260099701d-07,
     |   5.5566598141462d-06, 3.3096285506773d-05, 1.6039400120485d-04,
     |   6.5151174539209d-04, 2.2685339250486d-03, 6.8891352933380d-03,
     |   1.8492541940327d-02, 4.4334391095015d-02, 9.5681360789048d-02,
     |   1.8696869430502d-01, 3.3207155830058d-01, 5.3706160758883d-01,
     |   7.9063361055101d-01, 1.0559198810082d+00, 1.2693509951357d+00,
     |   1.3517750996747d+00, 1.2330166880619d+00, 8.8407949552219d-01,
     |   3.4425546104522d-01,-2.7217914125535d-01,-7.9991683722493d-01,
     |  -1.0750080255429d+00,-9.9855200254517d-01,-5.8491604277790d-01,
     |   3.0101409377664d-02, 6.3060598071667d-01, 9.9877141049560d-01,
     |   9.9877141049560d-01, 6.3060598071667d-01, 3.0101409377666d-02,
     |  -5.8491604277790d-01,-9.9855200254517d-01,-1.0750080255429d+00,
     |  -7.9991683722493d-01,-2.7217914125535d-01, 3.4425546104522d-01,
     |   8.8407949552218d-01, 1.2330166880619d+00, 1.3517750996747d+00,
     |   1.2693509951357d+00, 1.0559198810082d+00, 7.9063361055101d-01,
     |   5.3706160758884d-01, 3.3207155830058d-01, 1.8696869430502d-01,
     |   9.5681360789049d-02, 4.4334391095015d-02, 1.8492541940327d-02,
     |   6.8891352933380d-03, 2.2685339250486d-03, 6.5151174539209d-04,
     |   1.6039400120485d-04, 3.3096285506773d-05, 5.5566598141463d-06,
     |   7.2935260099703d-07, 7.0812383067608d-08, 4.6966107276428d-09,
     |   1.8874746263427d-10, 3.7896771690877d-12, 2.7049776857999d-14,
     |   3.4424449576352d-17, 1.3122999220906d-21, 3.8429801907166d-31/
      data (pmn(lat,21,24), lat = 1,72)/
     |   2.6787170424544d-33, 2.7484561976587d-23, 1.2053914291406d-18,
     |   1.3322956840835d-15, 2.4151182892915d-13, 1.4820094678382d-11,
     |   4.4009405800320d-10, 7.7455265126631d-09, 9.1644465151572d-08,
     |   7.9258653478733d-07, 5.3112039725612d-06, 2.8764766212916d-05,
     |   1.2992420694668d-04, 5.0126965638159d-04, 1.6829013282925d-03,
     |   4.9885133569759d-03, 1.3206919766284d-02, 3.1513400444844d-02,
     |   6.8256019801040d-02, 1.3492572944520d-01, 2.4437118172575d-01,
     |   4.0649345402979d-01, 6.2152651142429d-01, 8.7255110756471d-01,
     |   1.1205644412898d+00, 1.3062270341355d+00, 1.3612848243810d+00,
     |   1.2292389866956d+00, 8.8999309376824d-01, 3.7909689278094d-01,
     |  -2.0860104332706d-01,-7.3702132481509d-01,-1.0665522871184d+00,
     |  -1.1000926310228d+00,-8.2041431262562d-01,-3.0299841947575d-01,
     |   3.0299841947575d-01, 8.2041431262562d-01, 1.1000926310228d+00,
     |   1.0665522871184d+00, 7.3702132481509d-01, 2.0860104332706d-01,
     |  -3.7909689278094d-01,-8.8999309376824d-01,-1.2292389866956d+00,
     |  -1.3612848243810d+00,-1.3062270341355d+00,-1.1205644412898d+00,
     |  -8.7255110756471d-01,-6.2152651142429d-01,-4.0649345402979d-01,
     |  -2.4437118172575d-01,-1.3492572944520d-01,-6.8256019801040d-02,
     |  -3.1513400444844d-02,-1.3206919766284d-02,-4.9885133569759d-03,
     |  -1.6829013282925d-03,-5.0126965638159d-04,-1.2992420694668d-04,
     |  -2.8764766212916d-05,-5.3112039725612d-06,-7.9258653478734d-07,
     |  -9.1644465151573d-08,-7.7455265126631d-09,-4.4009405800320d-10,
     |  -1.4820094678383d-11,-2.4151182892915d-13,-1.3322956840835d-15,
     |  -1.2053914291406d-18,-2.7484561976587d-23,-2.6787170424544d-33/
      data (pmn(lat,22,24), lat = 1,72)/
     |   1.5605568776592d-35, 4.8105167840538d-25, 3.5264828282393d-20,
     |   5.4808254892546d-17, 1.2849508711826d-14, 9.7091235150555d-13,
     |   3.4383609151087d-11, 7.0575722482251d-10, 9.5824906782408d-09,
     |   9.3958485141671d-08, 7.0731729834536d-07, 4.2733900178453d-06,
     |   2.1418320113137d-05, 9.1335737535035d-05, 3.3798621340101d-04,
     |   1.1023759716785d-03, 3.2088257291872d-03, 8.4199142558136d-03,
     |   2.0078634783406d-02, 4.3798295188179d-02, 8.7846608323679d-02,
     |   1.6265613596423d-01, 2.7883411546469d-01, 4.4332620700611d-01,
     |   6.5411126370126d-01, 8.9484601291938d-01, 1.1318285168804d+00,
     |   1.3159041867581d+00, 1.3909845064425d+00, 1.3086256485744d+00,
     |   1.0452479689265d+00, 6.1628158286568d-01, 8.1110453971395d-02,
     |  -4.6512671862427d-01,-9.1245544229761d-01,-1.1643150978472d+00,
     |  -1.1643150978472d+00,-9.1245544229761d-01,-4.6512671862427d-01,
     |   8.1110453971393d-02, 6.1628158286568d-01, 1.0452479689265d+00,
     |   1.3086256485744d+00, 1.3909845064425d+00, 1.3159041867581d+00,
     |   1.1318285168804d+00, 8.9484601291938d-01, 6.5411126370126d-01,
     |   4.4332620700611d-01, 2.7883411546469d-01, 1.6265613596423d-01,
     |   8.7846608323680d-02, 4.3798295188179d-02, 2.0078634783406d-02,
     |   8.4199142558136d-03, 3.2088257291872d-03, 1.1023759716785d-03,
     |   3.3798621340101d-04, 9.1335737535035d-05, 2.1418320113137d-05,
     |   4.2733900178453d-06, 7.0731729834536d-07, 9.3958485141672d-08,
     |   9.5824906782410d-09, 7.0575722482251d-10, 3.4383609151087d-11,
     |   9.7091235150559d-13, 1.2849508711826d-14, 5.4808254892546d-17,
     |   3.5264828282393d-20, 4.8105167840538d-25, 1.5605568776592d-35/
      data (pmn(lat,23,24), lat = 1,72)/
     |   7.1770584554600d-38, 6.6461137876495d-27, 8.1422771265768d-22,
     |   1.7789180665333d-18, 5.3917297560119d-16, 5.0139847493194d-14,
     |   2.1162128476525d-12, 5.0621143869985d-11, 7.8800469181427d-10,
     |   8.7505818287693d-09, 7.3909029414036d-08, 4.9739368934324d-07,
     |   2.7614564371924d-06, 1.2988982970345d-05, 5.2850759627535d-05,
     |   1.8912600156198d-04, 6.0320182707352d-04, 1.7333944132166d-03,
     |   4.5281678243699d-03, 1.0832483138397d-02, 2.3875372482804d-02,
     |   4.8726126191560d-02, 9.2456667649324d-02, 1.6364436689199d-01,
     |   2.7086033707761d-01, 4.1999806856445d-01, 6.1073017050242d-01,
     |   8.3294549429450d-01, 1.0644963952374d+00, 1.2716930886456d+00,
     |   1.4135021333803d+00, 1.4493351308447d+00, 1.3489393843549d+00,
     |   1.1017453258620d+00, 7.2263893738315d-01, 2.5183035460871d-01,
     |  -2.5183035460871d-01,-7.2263893738315d-01,-1.1017453258620d+00,
     |  -1.3489393843549d+00,-1.4493351308447d+00,-1.4135021333803d+00,
     |  -1.2716930886456d+00,-1.0644963952374d+00,-8.3294549429450d-01,
     |  -6.1073017050242d-01,-4.1999806856445d-01,-2.7086033707761d-01,
     |  -1.6364436689199d-01,-9.2456667649324d-02,-4.8726126191560d-02,
     |  -2.3875372482805d-02,-1.0832483138397d-02,-4.5281678243699d-03,
     |  -1.7333944132166d-03,-6.0320182707353d-04,-1.8912600156198d-04,
     |  -5.2850759627534d-05,-1.2988982970345d-05,-2.7614564371924d-06,
     |  -4.9739368934324d-07,-7.3909029414036d-08,-8.7505818287695d-09,
     |  -7.8800469181428d-10,-5.0621143869986d-11,-2.1162128476525d-12,
     |  -5.0139847493196d-14,-5.3917297560119d-16,-1.7789180665333d-18,
     |  -8.1422771265768d-22,-6.6461137876495d-27,-7.1770584554600d-38/
      data (pmn(lat,24,24), lat = 1,72)/
     |   2.2603836433736d-40, 6.2874788372703d-29, 1.2870932670168d-23,
     |   3.9519868124290d-20, 1.5479940388484d-17, 1.7708981993644d-15,
     |   8.9030268711209d-14, 2.4802336629087d-12, 4.4230553732580d-11,
     |   5.5574988609797d-10, 5.2608011899350d-09, 3.9386766417416d-08,
     |   2.4186543695623d-07, 1.2527001100597d-06, 5.5933376902180d-06,
     |   2.1908950829784d-05, 7.6353678897013d-05, 2.3950858580355d-04,
     |   6.8274351405611d-04, 1.7828691304334d-03, 4.2937680362520d-03,
     |   9.5918160644745d-03, 1.9972159736331d-02, 3.8924604459394d-02,
     |   7.1261362323237d-02, 1.2292824040581d-01, 2.0033908485504d-01,
     |   3.0915891379540d-01, 4.5262893622218d-01, 6.2974211173247d-01,
     |   8.3376688715117d-01, 1.0516867791610d+00, 1.2650032942188d+00,
     |   1.4520308402084d+00, 1.5913706993219d+00, 1.6658318721546d+00,
     |   1.6658318721546d+00, 1.5913706993219d+00, 1.4520308402084d+00,
     |   1.2650032942188d+00, 1.0516867791610d+00, 8.3376688715117d-01,
     |   6.2974211173248d-01, 4.5262893622218d-01, 3.0915891379540d-01,
     |   2.0033908485504d-01, 1.2292824040581d-01, 7.1261362323237d-02,
     |   3.8924604459395d-02, 1.9972159736331d-02, 9.5918160644745d-03,
     |   4.2937680362521d-03, 1.7828691304334d-03, 6.8274351405611d-04,
     |   2.3950858580355d-04, 7.6353678897014d-05, 2.1908950829785d-05,
     |   5.5933376902180d-06, 1.2527001100597d-06, 2.4186543695624d-07,
     |   3.9386766417416d-08, 5.2608011899350d-09, 5.5574988609798d-10,
     |   4.4230553732581d-11, 2.4802336629087d-12, 8.9030268711209d-14,
     |   1.7708981993645d-15, 1.5479940388484d-17, 3.9519868124290d-20,
     |   1.2870932670168d-23, 6.2874788372703d-29, 2.2603836433736d-40/
      data (pmn(lat, 0,25), lat = 1,72)/
     |   4.6666630067160d+00, 2.1005412348200d+00,-8.9733874200297d-01,
     |  -2.0337981695880d+00,-8.8768801460650d-01, 9.2527625909659d-01,
     |   1.4902803852111d+00, 4.2739105048718d-01,-9.5519340251061d-01,
     |  -1.1808210524569d+00,-1.2934621517710d-01, 9.7112748179845d-01,
     |   9.4507015742351d-01,-9.7095764484823d-02,-9.6837766122044d-01,
     |  -7.4008142115838d-01, 2.7992604509549d-01, 9.4567240587734d-01,
     |   5.5028423875679d-01,-4.3021394133410d-01,-9.0297635563903d-01,
     |  -3.6953448603900d-01, 5.5281295376703d-01, 8.4086316625814d-01,
     |   1.9570361702825d-01,-6.4989829276932d-01,-7.6029492598601d-01,
     |  -2.8611421222711d-02, 7.2240000154485d-01, 6.6252175504493d-01,
     |  -1.3090449968859d-01,-7.7066571241289d-01,-5.4901713597604d-01,
     |   2.8146473369558d-01, 7.9479212537616d-01, 4.2141925647330d-01,
     |  -4.2141925647330d-01,-7.9479212537616d-01,-2.8146473369558d-01,
     |   5.4901713597604d-01, 7.7066571241289d-01, 1.3090449968859d-01,
     |  -6.6252175504493d-01,-7.2240000154485d-01, 2.8611421222708d-02,
     |   7.6029492598601d-01, 6.4989829276933d-01,-1.9570361702825d-01,
     |  -8.4086316625814d-01,-5.5281295376703d-01, 3.6953448603900d-01,
     |   9.0297635563903d-01, 4.3021394133410d-01,-5.5028423875678d-01,
     |  -9.4567240587735d-01,-2.7992604509549d-01, 7.4008142115838d-01,
     |   9.6837766122044d-01, 9.7095764484819d-02,-9.4507015742350d-01,
     |  -9.7112748179845d-01, 1.2934621517710d-01, 1.1808210524569d+00,
     |   9.5519340251061d-01,-4.2739105048717d-01,-1.4902803852111d+00,
     |  -9.2527625909661d-01, 8.8768801460650d-01, 2.0337981695880d+00,
     |   8.9733874200297d-01,-2.1005412348200d+00,-4.6666630067160d+00/
      data (pmn(lat, 1,25), lat = 1,72)/
     |   1.3508173118163d+00, 2.9083862401957d+00, 2.1024505851568d+00,
     |  -1.2487696457507d-01,-1.6628715579968d+00,-1.2776552652255d+00,
     |   3.2099497027746d-01, 1.3668040821056d+00, 8.7083501064525d-01,
     |  -4.8263976619968d-01,-1.1986836036636d+00,-5.8191114346782d-01,
     |   6.0820097597283d-01, 1.0637335762011d+00, 3.4626611091615d-01,
     |  -7.0327506579591d-01,-9.3601486147821d-01,-1.4183866278726d-01,
     |   7.7112017319112d-01, 8.0628959715214d-01,-4.0226483542727d-02,
     |  -8.1355763431874d-01,-6.7119467523070d-01, 2.0351899810022d-01,
     |   8.3171857509779d-01, 5.2993794259259d-01,-3.4921471943651d-01,
     |  -8.2644878126138d-01,-3.8302668555362d-01, 4.7730170584421d-01,
     |   7.9852048481445d-01, 2.3168578383230d-01,-5.8717890726741d-01,
     |  -7.4873768628526d-01,-7.7546824902618d-02, 6.7797658394709d-01,
     |   6.7797658394709d-01,-7.7546824902615d-02,-7.4873768628526d-01,
     |  -5.8717890726741d-01, 2.3168578383230d-01, 7.9852048481445d-01,
     |   4.7730170584421d-01,-3.8302668555362d-01,-8.2644878126138d-01,
     |  -3.4921471943651d-01, 5.2993794259259d-01, 8.3171857509779d-01,
     |   2.0351899810022d-01,-6.7119467523070d-01,-8.1355763431874d-01,
     |  -4.0226483542741d-02, 8.0628959715214d-01, 7.7112017319113d-01,
     |  -1.4183866278726d-01,-9.3601486147821d-01,-7.0327506579591d-01,
     |   3.4626611091616d-01, 1.0637335762011d+00, 6.0820097597284d-01,
     |  -5.8191114346782d-01,-1.1986836036636d+00,-4.8263976619969d-01,
     |   8.7083501064524d-01, 1.3668040821056d+00, 3.2099497027746d-01,
     |  -1.2776552652255d+00,-1.6628715579968d+00,-1.2487696457507d-01,
     |   2.1024505851568d+00, 2.9083862401957d+00, 1.3508173118163d+00/
      data (pmn(lat, 2,25), lat = 1,72)/
     |   1.9002053969449d-01, 1.3825231838822d+00, 2.4070078756769d+00,
     |   1.9731895431001d+00, 2.3224736944902d-01,-1.3369307481382d+00,
     |  -1.4060533977201d+00,-1.1170034459360d-01, 1.1326061663508d+00,
     |   1.0964626902284d+00,-6.1427364413513d-02,-1.0559601825204d+00,
     |  -8.6778059248112d-01, 2.2232401965775d-01, 1.0069741787926d+00,
     |   6.7237695264001d-01,-3.6421430650874d-01,-9.5877172007292d-01,
     |  -4.9313534245958d-01, 4.8643212724886d-01, 9.0183220188095d-01,
     |   3.2323687484358d-01,-5.8890115796617d-01,-8.3245684737235d-01,
     |  -1.6015536235668d-01, 6.7143298198841d-01, 7.4939479194993d-01,
     |   3.4048867999253d-03,-7.3372929657261d-01,-6.5261301824956d-01,
     |   1.4645817332612d-01, 7.7547488783277d-01, 5.4276316378035d-01,
     |  -2.8834129553824d-01,-7.9641704513315d-01,-4.2090680653834d-01,
     |   4.2090680653834d-01, 7.9641704513315d-01, 2.8834129553824d-01,
     |  -5.4276316378035d-01,-7.7547488783277d-01,-1.4645817332612d-01,
     |   6.5261301824956d-01, 7.3372929657261d-01,-3.4048867999222d-03,
     |  -7.4939479194993d-01,-6.7143298198841d-01, 1.6015536235668d-01,
     |   8.3245684737235d-01, 5.8890115796617d-01,-3.2323687484358d-01,
     |  -9.0183220188095d-01,-4.8643212724886d-01, 4.9313534245958d-01,
     |   9.5877172007292d-01, 3.6421430650874d-01,-6.7237695264001d-01,
     |  -1.0069741787926d+00,-2.2232401965775d-01, 8.6778059248111d-01,
     |   1.0559601825204d+00, 6.1427364413513d-02,-1.0964626902284d+00,
     |  -1.1326061663508d+00, 1.1170034459359d-01, 1.4060533977201d+00,
     |   1.3369307481382d+00,-2.3224736944902d-01,-1.9731895431001d+00,
     |  -2.4070078756769d+00,-1.3825231838822d+00,-1.9002053969449d-01/
      data (pmn(lat, 3,25), lat = 1,72)/
     |   1.7648836002700d-02, 4.0735393289102d-01, 1.3552848459754d+00,
     |   2.1459821495128d+00, 1.8520651552992d+00, 4.2043535501376d-01,
     |  -1.0823514503608d+00,-1.4229091465080d+00,-4.1446224187877d-01,
     |   8.7691495205864d-01, 1.1827666805179d+00, 2.8033064901969d-01,
     |  -8.3549561806632d-01,-1.0145861656202d+00,-1.3087117759792d-01,
     |   8.3750592464849d-01, 8.7345571470198d-01,-1.5587292123338d-02,
     |  -8.4792059727109d-01,-7.4154979693817d-01, 1.5443758522545d-01,
     |   8.5343784930801d-01, 6.1125300628948d-01,-2.8377242172308d-01,
     |  -8.4814689807875d-01,-4.7939027076719d-01, 4.0227211568058d-01,
     |   8.2922012480747d-01, 3.4495582487829d-01,-5.0876448422608d-01,
     |  -7.9534764940534d-01,-2.0809074140584d-01, 6.0216725045223d-01,
     |   7.4608188899434d-01, 6.9559418988175d-02,-6.8152647770938d-01,
     |  -6.8152647770938d-01, 6.9559418988172d-02, 7.4608188899433d-01,
     |   6.0216725045223d-01,-2.0809074140583d-01,-7.9534764940534d-01,
     |  -5.0876448422609d-01, 3.4495582487829d-01, 8.2922012480747d-01,
     |   4.0227211568058d-01,-4.7939027076719d-01,-8.4814689807875d-01,
     |  -2.8377242172308d-01, 6.1125300628948d-01, 8.5343784930801d-01,
     |   1.5443758522546d-01,-7.4154979693817d-01,-8.4792059727109d-01,
     |  -1.5587292123341d-02, 8.7345571470198d-01, 8.3750592464850d-01,
     |  -1.3087117759793d-01,-1.0145861656202d+00,-8.3549561806632d-01,
     |   2.8033064901969d-01, 1.1827666805179d+00, 8.7691495205865d-01,
     |  -4.1446224187876d-01,-1.4229091465080d+00,-1.0823514503608d+00,
     |   4.2043535501375d-01, 1.8520651552992d+00, 2.1459821495128d+00,
     |   1.3552848459754d+00, 4.0735393289102d-01, 1.7648836002700d-02/
      data (pmn(lat, 4,25), lat = 1,72)/
     |   1.2204729488251d-03, 8.7321126801028d-02, 5.2129021952811d-01,
     |   1.3295273739918d+00, 1.9784098028581d+00, 1.7513423327183d+00,
     |   5.3056482511528d-01,-8.8349470737572d-01,-1.3910891169323d+00,
     |  -6.2819870796482d-01, 6.3144014647287d-01, 1.1822921282022d+00,
     |   5.4479044613613d-01,-5.8405960727098d-01,-1.0540960013797d+00,
     |  -4.2765328266602d-01, 6.0251153235698d-01, 9.5940167200201d-01,
     |   3.0263391554399d-01,-6.4319297334968d-01,-8.7661967803913d-01,
     |  -1.7610723776392d-01, 6.8868229450300d-01, 7.9545791510608d-01,
     |   5.0376046876341d-02,-7.3073996213477d-01,-7.1086442084246d-01,
     |   7.3178464154330d-02, 7.6498678279500d-01, 6.2044909196329d-01,
     |  -1.9337579283723d-01,-7.8894509598601d-01,-5.2329338013274d-01,
     |   3.0910336204324d-01, 8.0123618385686d-01, 4.1934887882486d-01,
     |  -4.1934887882486d-01,-8.0123618385686d-01,-3.0910336204324d-01,
     |   5.2329338013274d-01, 7.8894509598601d-01, 1.9337579283722d-01,
     |  -6.2044909196329d-01,-7.6498678279500d-01,-7.3178464154333d-02,
     |   7.1086442084246d-01, 7.3073996213478d-01,-5.0376046876335d-02,
     |  -7.9545791510608d-01,-6.8868229450300d-01, 1.7610723776392d-01,
     |   8.7661967803913d-01, 6.4319297334969d-01,-3.0263391554398d-01,
     |  -9.5940167200201d-01,-6.0251153235698d-01, 4.2765328266602d-01,
     |   1.0540960013797d+00, 5.8405960727097d-01,-5.4479044613612d-01,
     |  -1.1822921282022d+00,-6.3144014647287d-01, 6.2819870796481d-01,
     |   1.3910891169323d+00, 8.8349470737572d-01,-5.3056482511528d-01,
     |  -1.7513423327183d+00,-1.9784098028581d+00,-1.3295273739918d+00,
     |  -5.2129021952811d-01,-8.7321126801028d-02,-1.2204729488251d-03/
      data (pmn(lat, 5,25), lat = 1,72)/
     |   6.7007933653032d-05, 1.4696861819958d-02, 1.5323844540443d-01,
     |   5.9362968762895d-01, 1.3063216953792d+00, 1.8580836140027d+00,
     |   1.6693771106650d+00, 6.0236530567663d-01,-7.2306056752931d-01,
     |  -1.3375094039306d+00,-7.8214294269257d-01, 4.0476396040465d-01,
     |   1.1269330982129d+00, 7.4240561770772d-01,-3.2650512438884d-01,
     |  -1.0126390546053d+00,-6.6000765785187d-01, 3.3511607126606d-01,
     |   9.4562548313395d-01, 5.6646006531034d-01,-3.7965959245988d-01,
     |  -8.9999580509394d-01,-4.6845513735100d-01, 4.3941692761643d-01,
     |   8.6232372381240d-01, 3.6756738723097d-01,-5.0451229101565d-01,
     |  -8.2539819892494d-01,-2.6437255128553d-01, 5.6962465751181d-01,
     |   7.8529975079657d-01, 1.5938955914313d-01,-6.3164961111400d-01,
     |  -7.4001430250212d-01,-5.3261438348327d-02, 6.8875640903858d-01,
     |   6.8875640903858d-01,-5.3261438348324d-02,-7.4001430250212d-01,
     |  -6.3164961111400d-01, 1.5938955914313d-01, 7.8529975079657d-01,
     |   5.6962465751181d-01,-2.6437255128552d-01,-8.2539819892494d-01,
     |  -5.0451229101565d-01, 3.6756738723097d-01, 8.6232372381239d-01,
     |   4.3941692761644d-01,-4.6845513735100d-01,-8.9999580509394d-01,
     |  -3.7965959245989d-01, 5.6646006531033d-01, 9.4562548313395d-01,
     |   3.3511607126606d-01,-6.6000765785187d-01,-1.0126390546053d+00,
     |  -3.2650512438883d-01, 7.4240561770773d-01, 1.1269330982129d+00,
     |   4.0476396040465d-01,-7.8214294269257d-01,-1.3375094039306d+00,
     |  -7.2306056752931d-01, 6.0236530567662d-01, 1.6693771106650d+00,
     |   1.8580836140027d+00, 1.3063216953792d+00, 5.9362968762895d-01,
     |   1.5323844540443d-01, 1.4696861819958d-02, 6.7007933653032d-05/
      data (pmn(lat, 6,25), lat = 1,72)/
     |   3.0391143148502d-06, 2.0307359122062d-03, 3.6459004882876d-02,
     |   2.0875139727553d-01, 6.4319934531669d-01, 1.2841575952949d+00,
     |   1.7653420516416d+00, 1.6032519190554d+00, 6.5553091203087d-01,
     |  -5.8753690866525d-01,-1.2734766074268d+00,-8.9548610253452d-01,
     |   1.9667431779012d-01, 1.0349748144408d+00, 8.8372727242509d-01,
     |  -7.5631490304935d-02,-9.0960028256356d-01,-8.2651761720399d-01,
     |   5.8488169200153d-02, 8.4786775922731d-01, 7.6128681867911d-01,
     |  -8.7502138642649d-02,-8.1992249813348d-01,-6.9476013444607d-01,
     |   1.3921562907408d-01, 8.0940689852004d-01, 6.2742064797602d-01,
     |  -2.0267484415555d-01,-8.0717276417216d-01,-5.5875326683534d-01,
     |   2.7210300334320d-01, 8.0801496170079d-01, 4.8845204599691d-01,
     |  -3.4413451351421d-01,-8.0907391412480d-01,-4.1668151850540d-01,
     |   4.1668151850540d-01, 8.0907391412480d-01, 3.4413451351422d-01,
     |  -4.8845204599691d-01,-8.0801496170079d-01,-2.7210300334319d-01,
     |   5.5875326683534d-01, 8.0717276417217d-01, 2.0267484415555d-01,
     |  -6.2742064797602d-01,-8.0940689852005d-01,-1.3921562907408d-01,
     |   6.9476013444607d-01, 8.1992249813348d-01, 8.7502138642649d-02,
     |  -7.6128681867911d-01,-8.4786775922731d-01,-5.8488169200158d-02,
     |   8.2651761720399d-01, 9.0960028256356d-01, 7.5631490304940d-02,
     |  -8.8372727242510d-01,-1.0349748144408d+00,-1.9667431779013d-01,
     |   8.9548610253452d-01, 1.2734766074268d+00, 5.8753690866526d-01,
     |  -6.5553091203086d-01,-1.6032519190554d+00,-1.7653420516416d+00,
     |  -1.2841575952949d+00,-6.4319934531669d-01,-2.0875139727553d-01,
     |  -3.6459004882876d-02,-2.0307359122062d-03,-3.0391143148502d-06/
      data (pmn(lat, 7,25), lat = 1,72)/
     |   1.1694355038904d-07, 2.3715170664067d-04, 7.2695898611150d-03,
     |   6.0593563945490d-02, 2.5451850479739d-01, 6.7764423421748d-01,
     |   1.2617669551740d+00, 1.6902482153483d+00, 1.5505286571051d+00,
     |   7.0081135043730d-01,-4.6691619895687d-01,-1.2030993078623d+00,
     |  -9.8026742295862d-01, 4.1220647709825d-03, 9.1626451001771d-01,
     |   9.7672262519434d-01, 1.6172072916356d-01,-7.5858879993028d-01,
     |  -9.2766326762279d-01,-2.1015870500419d-01, 6.8073846226025d-01,
     |   8.7760994569604d-01, 2.0643415878159d-01,-6.4890526660868d-01,
     |  -8.3362229730722d-01,-1.7692234871393d-01, 6.4382093088846d-01,
     |   7.9514687706020d-01, 1.3362359541028d-01,-6.5447746882436d-01,
     |  -7.6060789876623d-01,-8.2736087675803d-02, 6.7443993848705d-01,
     |   7.2893957234460d-01, 2.7976910999465d-02,-6.9994489941058d-01,
     |  -6.9994489941058d-01, 2.7976910999462d-02, 7.2893957234460d-01,
     |   6.7443993848706d-01,-8.2736087675800d-02,-7.6060789876623d-01,
     |  -6.5447746882436d-01, 1.3362359541027d-01, 7.9514687706020d-01,
     |   6.4382093088846d-01,-1.7692234871392d-01,-8.3362229730722d-01,
     |  -6.4890526660868d-01, 2.0643415878159d-01, 8.7760994569604d-01,
     |   6.8073846226026d-01,-2.1015870500418d-01,-9.2766326762279d-01,
     |  -7.5858879993028d-01, 1.6172072916355d-01, 9.7672262519434d-01,
     |   9.1626451001770d-01, 4.1220647709787d-03,-9.8026742295861d-01,
     |  -1.2030993078623d+00,-4.6691619895687d-01, 7.0081135043729d-01,
     |   1.5505286571051d+00, 1.6902482153483d+00, 1.2617669551740d+00,
     |   6.7764423421749d-01, 2.5451850479739d-01, 6.0593563945490d-02,
     |   7.2695898611150d-03, 2.3715170664067d-04, 1.1694355038904d-07/
      data (pmn(lat, 8,25), lat = 1,72)/
     |   3.8906422365336d-09, 2.3884437900652d-05, 1.2432452150917d-03,
     |   1.4944855657190d-02, 8.4273556362119d-02, 2.9155990289856d-01,
     |   7.0062738337031d-01, 1.2382148568540d+00, 1.6271313957946d+00,
     |   1.5093188242651d+00, 7.4452194729539d-01,-3.5371809605595d-01,
     |  -1.1269254830575d+00,-1.0435567553225d+00,-1.7626141344886d-01,
     |   7.7557862632330d-01, 1.0261854886365d+00, 3.8100658199477d-01,
     |  -5.6929004457610d-01,-9.6367059951072d-01,-4.5636757889500d-01,
     |   4.5816544174360d-01, 9.0876213457337d-01, 4.7671041084911d-01,
     |  -4.0355557785660d-01,-8.6900767331407d-01,-4.7204317545581d-01,
     |   3.8267119764634d-01, 8.4268499309594d-01, 4.5572026676107d-01,
     |  -3.8220302738518d-01,-8.2693504589659d-01,-4.3454559218526d-01,
     |   3.9402392886862d-01, 8.1960625649895d-01, 4.1279017159586d-01,
     |  -4.1279017159586d-01,-8.1960625649895d-01,-3.9402392886863d-01,
     |   4.3454559218526d-01, 8.2693504589659d-01, 3.8220302738518d-01,
     |  -4.5572026676107d-01,-8.4268499309594d-01,-3.8267119764634d-01,
     |   4.7204317545581d-01, 8.6900767331407d-01, 4.0355557785660d-01,
     |  -4.7671041084911d-01,-9.0876213457337d-01,-4.5816544174360d-01,
     |   4.5636757889498d-01, 9.6367059951072d-01, 5.6929004457611d-01,
     |  -3.8100658199476d-01,-1.0261854886365d+00,-7.7557862632331d-01,
     |   1.7626141344886d-01, 1.0435567553225d+00, 1.1269254830575d+00,
     |   3.5371809605595d-01,-7.4452194729539d-01,-1.5093188242651d+00,
     |  -1.6271313957947d+00,-1.2382148568540d+00,-7.0062738337031d-01,
     |  -2.9155990289856d-01,-8.4273556362119d-02,-1.4944855657190d-02,
     |  -1.2432452150917d-03,-2.3884437900652d-05,-3.8906422365336d-09/
      data (pmn(lat, 9,25), lat = 1,72)/
     |   1.1347258774548d-10, 2.1050543963072d-06, 1.8536907072846d-04,
     |   3.1935961882359d-03, 2.3941559380536d-02, 1.0600313942425d-01,
     |   3.2060923988306d-01, 7.1408173453486d-01, 1.2127679917659d+00,
     |   1.5723872076820d+00, 1.4780858502472d+00, 7.9055318914484d-01,
     |  -2.4219076705760d-01,-1.0435711601795d+00,-1.0888424523487d+00,
     |  -3.4703059273550d-01, 6.1479891243544d-01, 1.0338936145151d+00,
     |   5.7772660075706d-01,-3.4938773179022d-01,-9.3385577430934d-01,
     |  -6.6610115543411d-01, 1.9483745125697d-01, 8.5034139119185d-01,
     |   6.9773836218758d-01,-1.0584900534665d-01,-7.9090065662530d-01,
     |  -7.0704057347973d-01, 5.4911354312565d-02, 7.5187436817833d-01,
     |   7.0882178834707d-01,-2.5595113428301d-02,-7.2822245810109d-01,
     |  -7.1024122025555d-01, 7.3897157882653d-03, 7.1556093111143d-01,
     |   7.1556093111144d-01, 7.3897157882681d-03,-7.1024122025555d-01,
     |  -7.2822245810109d-01,-2.5595113428304d-02, 7.0882178834707d-01,
     |   7.5187436817834d-01, 5.4911354312572d-02,-7.0704057347972d-01,
     |  -7.9090065662530d-01,-1.0584900534666d-01, 6.9773836218757d-01,
     |   8.5034139119185d-01, 1.9483745125697d-01,-6.6610115543411d-01,
     |  -9.3385577430934d-01,-3.4938773179023d-01, 5.7772660075706d-01,
     |   1.0338936145151d+00, 6.1479891243545d-01,-3.4703059273549d-01,
     |  -1.0888424523487d+00,-1.0435711601795d+00,-2.4219076705761d-01,
     |   7.9055318914484d-01, 1.4780858502472d+00, 1.5723872076820d+00,
     |   1.2127679917659d+00, 7.1408173453486d-01, 3.2060923988306d-01,
     |   1.0600313942425d-01, 2.3941559380536d-02, 3.1935961882359d-03,
     |   1.8536907072846d-04, 2.1050543963072d-06, 1.1347258774548d-10/
      data (pmn(lat,10,25), lat = 1,72)/
     |   2.9313334891164d-12, 1.6412029387385d-07, 2.4383971526552d-05,
     |   5.9945094562253d-04, 5.9350339527262d-03, 3.3299411063601d-02,
     |   1.2487423574171d-01, 3.4213538997122d-01, 7.1907443956527d-01,
     |   1.1847755259574d+00, 1.5234407149141d+00, 1.4554294552198d+00,
     |   8.4130886883751d-01,-1.2778128203223d-01,-9.5047211114210d-01,
     |  -1.1168382020891d+00,-5.0930618077034d-01, 4.3442318926172d-01,
     |   9.9904049959985d-01, 7.4597226847064d-01,-1.0645361146099d-01,
     |  -8.3697082136200d-01,-8.2422703088041d-01,-9.1821731841965d-02,
     |   7.0115673923234d-01, 8.4315885757062d-01, 2.1486375686166d-01,
     |  -5.9791258853617d-01,-8.4194280409342d-01,-2.9629135643602d-01,
     |   5.2022796434573d-01, 8.3624740848157d-01, 3.5621856367953d-01,
     |  -4.5947195119936d-01,-8.3230590567096d-01,-4.0749552266483d-01,
     |   4.0749552266483d-01, 8.3230590567096d-01, 4.5947195119936d-01,
     |  -3.5621856367953d-01,-8.3624740848157d-01,-5.2022796434573d-01,
     |   2.9629135643602d-01, 8.4194280409342d-01, 5.9791258853617d-01,
     |  -2.1486375686166d-01,-8.4315885757062d-01,-7.0115673923235d-01,
     |   9.1821731841962d-02, 8.2422703088041d-01, 8.3697082136200d-01,
     |   1.0645361146100d-01,-7.4597226847064d-01,-9.9904049959986d-01,
     |  -4.3442318926173d-01, 5.0930618077034d-01, 1.1168382020891d+00,
     |   9.5047211114209d-01, 1.2778128203223d-01,-8.4130886883750d-01,
     |  -1.4554294552198d+00,-1.5234407149141d+00,-1.1847755259574d+00,
     |  -7.1907443956528d-01,-3.4213538997122d-01,-1.2487423574171d-01,
     |  -3.3299411063602d-02,-5.9350339527262d-03,-5.9945094562253d-04,
     |  -2.4383971526552d-05,-1.6412029387385d-07,-2.9313334891164d-12/
      data (pmn(lat,11,25), lat = 1,72)/
     |   6.7592529951748d-14, 1.1410545203277d-08, 2.8546575006649d-06,
     |   9.9820863842253d-05, 1.2990808009479d-03, 9.1736817676151d-03,
     |   4.2236282514301d-02, 1.4027554501411d-01, 3.5642671054836d-01,
     |   7.1618654747548d-01, 1.1535787682595d+00, 1.4781907429922d+00,
     |   1.4398874954166d+00, 8.9812921311633d-01,-6.8376512355860d-03,
     |  -8.4425823471311d-01,-1.1259126456523d+00,-6.6229309509946d-01,
     |   2.3478703924083d-01, 9.1884486743356d-01, 8.7745880134711d-01,
     |   1.5014189618178d-01,-6.7240643389236d-01,-9.1390039012992d-01,
     |  -3.7947267412961d-01, 4.6565495535206d-01, 8.8678287566552d-01,
     |   5.1989740666933d-01,-3.0189738317587d-01,-8.3999914055235d-01,
     |  -6.1226726598169d-01, 1.6922742390874d-01, 7.8877326282740d-01,
     |   6.7996538379476d-01,-5.4476386079989d-02,-7.3634424170528d-01,
     |  -7.3634424170528d-01,-5.4476386079992d-02, 6.7996538379476d-01,
     |   7.8877326282740d-01, 1.6922742390874d-01,-6.1226726598170d-01,
     |  -8.3999914055235d-01,-3.0189738317587d-01, 5.1989740666933d-01,
     |   8.8678287566552d-01, 4.6565495535206d-01,-3.7947267412961d-01,
     |  -9.1390039012992d-01,-6.7240643389236d-01, 1.5014189618178d-01,
     |   8.7745880134711d-01, 9.1884486743356d-01, 2.3478703924083d-01,
     |  -6.6229309509945d-01,-1.1259126456523d+00,-8.4425823471312d-01,
     |  -6.8376512355801d-03, 8.9812921311633d-01, 1.4398874954166d+00,
     |   1.4781907429922d+00, 1.1535787682595d+00, 7.1618654747548d-01,
     |   3.5642671054837d-01, 1.4027554501411d-01, 4.2236282514301d-02,
     |   9.1736817676153d-03, 1.2990808009479d-03, 9.9820863842253d-05,
     |   2.8546575006649d-06, 1.1410545203277d-08, 6.7592529951748d-14/
      data (pmn(lat,12,25), lat = 1,72)/
     |   1.3991761993335d-15, 7.1166083223362d-10, 2.9934255012795d-07,
     |   1.4852769121097d-05, 2.5319053849847d-04, 2.2393157537842d-03,
     |   1.2571375364970d-02, 5.0121126349425d-02, 1.5177388192228d-01,
     |   3.6366061780935d-01, 7.0569811732291d-01, 1.1184445864690d+00,
     |   1.4346770071613d+00, 1.4297504087400d+00, 9.6143186852111d-01,
     |   1.2349275877173d-01,-7.2099883690718d-01,-1.1123023451381d+00,
     |  -8.0277682025056d-01, 1.7262509699192d-02, 7.8942164918805d-01,
     |   9.6097385404699d-01, 4.0725550596248d-01,-4.4230803769454d-01,
     |  -9.1712887901197d-01,-6.3890618905220d-01, 1.5779183582836d-01,
     |   8.0590683483237d-01, 7.6057596978188d-01, 6.5851982128095d-02,
     |  -6.7598090723578d-01,-8.2128294635348d-01,-2.4635248997237d-01,
     |   5.4111052581485d-01, 8.4634517330487d-01, 4.0052808230072d-01,
     |  -4.0052808230072d-01,-8.4634517330487d-01,-5.4111052581486d-01,
     |   2.4635248997237d-01, 8.2128294635348d-01, 6.7598090723578d-01,
     |  -6.5851982128092d-02,-7.6057596978188d-01,-8.0590683483237d-01,
     |  -1.5779183582836d-01, 6.3890618905220d-01, 9.1712887901197d-01,
     |   4.4230803769454d-01,-4.0725550596248d-01,-9.6097385404699d-01,
     |  -7.8942164918805d-01,-1.7262509699194d-02, 8.0277682025056d-01,
     |   1.1123023451381d+00, 7.2099883690718d-01,-1.2349275877172d-01,
     |  -9.6143186852112d-01,-1.4297504087400d+00,-1.4346770071613d+00,
     |  -1.1184445864690d+00,-7.0569811732291d-01,-3.6366061780935d-01,
     |  -1.5177388192228d-01,-5.0121126349425d-02,-1.2571375364970d-02,
     |  -2.2393157537843d-03,-2.5319053849847d-04,-1.4852769121097d-05,
     |  -2.9934255012795d-07,-7.1166083223362d-10,-1.3991761993335d-15/
      data (pmn(lat,13,25), lat = 1,72)/
     |   2.6106689662991d-17, 3.9984929248512d-11, 2.8244012877056d-08,
     |   1.9848504739530d-06, 4.4201088667489d-05, 4.8782379649020d-04,
     |   3.3226226666595d-03, 1.5793706908876d-02, 5.6452847260016d-02,
     |   1.5906651795418d-01, 3.6395636789669d-01, 6.8769012815997d-01,
     |   1.0785200538495d+00, 1.3908628238251d+00, 1.4228798505314d+00,
     |   1.0306725342997d+00, 2.6518080574434d-01,-5.7647034514268d-01,
     |  -1.0702484739826d+00,-9.2455322362423d-01,-2.1437643895990d-01,
     |   6.0710544481835d-01, 9.8238405176122d-01, 6.4601680096779d-01,
     |  -1.5473007764875d-01,-8.1705228963352d-01,-8.3309733774961d-01,
     |  -1.9396390729805d-01, 5.8793038059462d-01, 8.8088799322850d-01,
     |   4.4835063272121d-01,-3.4969099455278d-01,-8.4865000784814d-01,
     |  -6.3229593327416d-01, 1.1568370877246d-01, 7.6345608565907d-01,
     |   7.6345608565907d-01, 1.1568370877246d-01,-6.3229593327415d-01,
     |  -8.4865000784814d-01,-3.4969099455278d-01, 4.4835063272121d-01,
     |   8.8088799322851d-01, 5.8793038059462d-01,-1.9396390729805d-01,
     |  -8.3309733774960d-01,-8.1705228963352d-01,-1.5473007764875d-01,
     |   6.4601680096779d-01, 9.8238405176122d-01, 6.0710544481835d-01,
     |  -2.1437643895989d-01,-9.2455322362423d-01,-1.0702484739826d+00,
     |  -5.7647034514268d-01, 2.6518080574433d-01, 1.0306725342997d+00,
     |   1.4228798505314d+00, 1.3908628238251d+00, 1.0785200538495d+00,
     |   6.8769012815997d-01, 3.6395636789669d-01, 1.5906651795418d-01,
     |   5.6452847260016d-02, 1.5793706908876d-02, 3.3226226666595d-03,
     |   4.8782379649021d-04, 4.4201088667489d-05, 1.9848504739530d-06,
     |   2.8244012877056d-08, 3.9984929248512d-11, 2.6106689662991d-17/
      data (pmn(lat,14,25), lat = 1,72)/
     |   4.4023172755482d-19, 2.0294146357716d-12, 2.4050681036575d-09,
     |   2.3902973841718d-07, 6.9392943778656d-06, 9.5296297177888d-05,
     |   7.8451568682731d-04, 4.4236443698095d-03, 1.8537689572231d-02,
     |   6.0850566195435d-02, 1.6196638370128d-01, 3.5741921640753d-01,
     |   6.6211359010047d-01, 1.0328108695527d+00, 1.3444894316736d+00,
     |   1.4165291865920d+00, 1.1041723277054d+00, 4.1904118559506d-01,
     |  -4.0656908753328d-01,-9.9220958767539d-01,-1.0178383591303d+00,
     |  -4.5230531175878d-01, 3.7048902179765d-01, 9.2556884192390d-01,
     |   8.4023787920170d-01, 1.7215740671138d-01,-6.0267993594350d-01,
     |  -9.1864426358882d-01,-5.4155766100499d-01, 2.4092514938149d-01,
     |   8.2636021537691d-01, 7.6018986790296d-01, 9.6117746026880d-02,
     |  -6.3916355504407d-01,-8.6042420274176d-01,-3.9148225563530d-01,
     |   3.9148225563530d-01, 8.6042420274176d-01, 6.3916355504407d-01,
     |  -9.6117746026878d-02,-7.6018986790296d-01,-8.2636021537691d-01,
     |  -2.4092514938149d-01, 5.4155766100499d-01, 9.1864426358882d-01,
     |   6.0267993594350d-01,-1.7215740671138d-01,-8.4023787920169d-01,
     |  -9.2556884192390d-01,-3.7048902179765d-01, 4.5230531175878d-01,
     |   1.0178383591303d+00, 9.9220958767540d-01, 4.0656908753329d-01,
     |  -4.1904118559506d-01,-1.1041723277054d+00,-1.4165291865920d+00,
     |  -1.3444894316736d+00,-1.0328108695527d+00,-6.6211359010047d-01,
     |  -3.5741921640753d-01,-1.6196638370128d-01,-6.0850566195435d-02,
     |  -1.8537689572231d-02,-4.4236443698095d-03,-7.8451568682731d-04,
     |  -9.5296297177891d-05,-6.9392943778656d-06,-2.3902973841718d-07,
     |  -2.4050681036575d-09,-2.0294146357716d-12,-4.4023172755482d-19/
      data (pmn(lat,15,25), lat = 1,72)/
     |   6.7178615210439d-21, 9.3175984948965d-14, 1.8512155965305d-10,
     |   2.5989062834569d-08, 9.8194886310392d-07, 1.6742077011618d-05,
     |   1.6609892672678d-04, 1.1067645905529d-03, 5.4102660285468d-03,
     |   2.0550987983358d-02, 6.3052925790017d-02, 1.6040509173043d-01,
     |   3.4418415870037d-01, 6.2885320941179d-01, 9.8019122135400d-01,
     |   1.2929901416614d+00, 1.4071746529663d+00, 1.1788407440406d+00,
     |   5.8424698074023d-01,-2.0799311583296d-01,-8.6934691349902d-01,
     |  -1.0688186997993d+00,-6.8271433118425d-01, 8.3460904362363d-02,
     |   7.7490247163269d-01, 9.5597522084214d-01, 5.0521391532479d-01,
     |  -2.7682228200937d-01,-8.5173920669831d-01,-8.1474661634704d-01,
     |  -1.9247804545349d-01, 5.6248979711921d-01, 8.9498372138982d-01,
     |   5.5866511064425d-01,-1.9458676183308d-01,-7.9877573780217d-01,
     |  -7.9877573780218d-01,-1.9458676183308d-01, 5.5866511064425d-01,
     |   8.9498372138982d-01, 5.6248979711921d-01,-1.9247804545349d-01,
     |  -8.1474661634704d-01,-8.5173920669831d-01,-2.7682228200937d-01,
     |   5.0521391532479d-01, 9.5597522084214d-01, 7.7490247163269d-01,
     |   8.3460904362366d-02,-6.8271433118425d-01,-1.0688186997993d+00,
     |  -8.6934691349903d-01,-2.0799311583296d-01, 5.8424698074023d-01,
     |   1.1788407440406d+00, 1.4071746529663d+00, 1.2929901416614d+00,
     |   9.8019122135400d-01, 6.2885320941179d-01, 3.4418415870037d-01,
     |   1.6040509173043d-01, 6.3052925790017d-02, 2.0550987983358d-02,
     |   5.4102660285468d-03, 1.1067645905529d-03, 1.6609892672678d-04,
     |   1.6742077011618d-05, 9.8194886310392d-07, 2.5989062834569d-08,
     |   1.8512155965305d-10, 9.3175984948965d-14, 6.7178615210439d-21/
      data (pmn(lat,16,25), lat = 1,72)/
     |   9.2768629989895d-23, 3.8701231959223d-15, 1.2882596222329d-11,
     |   2.5522678147433d-09, 1.2533508722819d-07, 2.6483329098891d-06,
     |   3.1589971293855d-05, 2.4799683883381d-04, 1.4087208612377d-03,
     |   6.1613557795800d-03, 2.1647330238342d-02, 6.2923683747908d-02,
     |   1.5444763931393d-01, 3.2446603857298d-01, 5.8780362259282d-01,
     |   9.1945787189522d-01, 1.2334737971786d+00, 1.3903830551687d+00,
     |   1.2498290495297d+00, 7.5761881944500d-01, 2.0674051270190d-02,
     |  -6.9255019110054d-01,-1.0596707455734d+00,-8.8379753858086d-01,
     |  -2.4057126416560d-01, 5.2013050365956d-01, 9.5369758484639d-01,
     |   7.9216583826621d-01, 1.3265279098201d-01,-6.0142845456522d-01,
     |  -9.2584095194844d-01,-6.2174080952506d-01, 1.0451918746319d-01,
     |   7.5278434563527d-01, 8.7245136106238d-01, 3.7972872284634d-01,
     |  -3.7972872284634d-01,-8.7245136106238d-01,-7.5278434563527d-01,
     |  -1.0451918746319d-01, 6.2174080952506d-01, 9.2584095194844d-01,
     |   6.0142845456522d-01,-1.3265279098201d-01,-7.9216583826621d-01,
     |  -9.5369758484639d-01,-5.2013050365956d-01, 2.4057126416560d-01,
     |   8.8379753858086d-01, 1.0596707455734d+00, 6.9255019110054d-01,
     |  -2.0674051270180d-02,-7.5761881944500d-01,-1.2498290495297d+00,
     |  -1.3903830551687d+00,-1.2334737971786d+00,-9.1945787189522d-01,
     |  -5.8780362259281d-01,-3.2446603857298d-01,-1.5444763931393d-01,
     |  -6.2923683747908d-02,-2.1647330238342d-02,-6.1613557795801d-03,
     |  -1.4087208612377d-03,-2.4799683883381d-04,-3.1589971293855d-05,
     |  -2.6483329098892d-06,-1.2533508722819d-07,-2.5522678147433d-09,
     |  -1.2882596222329d-11,-3.8701231959223d-15,-9.2768629989895d-23/
      data (pmn(lat,17,25), lat = 1,72)/
     |   1.1576640321271d-24, 1.4522665329924d-16, 8.0951622895802d-13,
     |   2.2614668203620d-10, 1.4417899990214d-08, 3.7700238188391d-07,
     |   5.3966094905538d-06, 4.9795192541289d-05, 3.2769363021880d-04,
     |   1.6439523508195d-03, 6.5816420424753d-03, 2.1719523976050d-02,
     |   6.0461226332322d-02, 1.4431584851235d-01, 2.9862101503062d-01,
     |   5.3897180564251d-01, 8.4944603795716d-01, 1.1628049970766d+00,
     |   1.3607669466762d+00, 1.3101786104465d+00, 9.3270712810404d-01,
     |   2.7735344582194d-01,-4.5435484356402d-01,-9.6962182583824d-01,
     |  -1.0242656601551d+00,-5.7344389538486d-01, 1.6451726863388d-01,
     |   7.9533245814536d-01, 9.6117358071711d-01, 5.6000535790261d-01,
     |  -1.7242244617467d-01,-7.8936719299999d-01,-9.0561941638547d-01,
     |  -4.4613835101695d-01, 2.9677436386360d-01, 8.4553702817762d-01,
     |   8.4553702817762d-01, 2.9677436386360d-01,-4.4613835101694d-01,
     |  -9.0561941638547d-01,-7.8936719299999d-01,-1.7242244617467d-01,
     |   5.6000535790260d-01, 9.6117358071711d-01, 7.9533245814536d-01,
     |   1.6451726863389d-01,-5.7344389538486d-01,-1.0242656601551d+00,
     |  -9.6962182583824d-01,-4.5435484356402d-01, 2.7735344582194d-01,
     |   9.3270712810404d-01, 1.3101786104465d+00, 1.3607669466762d+00,
     |   1.1628049970766d+00, 8.4944603795717d-01, 5.3897180564251d-01,
     |   2.9862101503062d-01, 1.4431584851235d-01, 6.0461226332322d-02,
     |   2.1719523976050d-02, 6.5816420424753d-03, 1.6439523508195d-03,
     |   3.2769363021881d-04, 4.9795192541290d-05, 5.3966094905538d-06,
     |   3.7700238188392d-07, 1.4417899990214d-08, 2.2614668203620d-10,
     |   8.0951622895802d-13, 1.4522665329924d-16, 1.1576640321271d-24/
      data (pmn(lat,18,25), lat = 1,72)/
     |   1.3015537652955d-26, 4.9087737251232d-18, 4.5799836132418d-14,
     |   1.8029328438361d-11, 1.4909201993749d-09, 4.8184901671921d-08,
     |   8.2644802092669d-07, 8.9455488971377d-06, 6.8035492285207d-05,
     |   3.9031117549787d-04, 1.7738648015333d-03, 6.6136836722645d-03,
     |   2.0749898399480d-02, 5.5809544793445d-02, 1.3041793808672d-01,
     |   2.6722170077055d-01, 4.8261559185566d-01, 7.6922778524576d-01,
     |   1.0778251622077d+00, 1.3121126335801d+00, 1.3505869001343d+00,
     |   1.0987668561652d+00, 5.5427593722373d-01,-1.5215014889944d-01,
     |  -7.7792865340165d-01,-1.0636298409002d+00,-8.6701663540766d-01,
     |  -2.6341801334294d-01, 4.5905850055612d-01, 9.2967014993494d-01,
     |   8.9317315993502d-01, 3.6390953577716d-01,-3.6508309536229d-01,
     |  -8.7867770852067d-01,-8.7889307041100d-01,-3.6423112115456d-01,
     |   3.6423112115456d-01, 8.7889307041100d-01, 8.7867770852067d-01,
     |   3.6508309536229d-01,-3.6390953577715d-01,-8.9317315993502d-01,
     |  -9.2967014993494d-01,-4.5905850055612d-01, 2.6341801334293d-01,
     |   8.6701663540766d-01, 1.0636298409002d+00, 7.7792865340166d-01,
     |   1.5215014889944d-01,-5.5427593722373d-01,-1.0987668561652d+00,
     |  -1.3505869001343d+00,-1.3121126335801d+00,-1.0778251622077d+00,
     |  -7.6922778524576d-01,-4.8261559185566d-01,-2.6722170077055d-01,
     |  -1.3041793808672d-01,-5.5809544793445d-02,-2.0749898399480d-02,
     |  -6.6136836722645d-03,-1.7738648015333d-03,-3.9031117549787d-04,
     |  -6.8035492285208d-05,-8.9455488971378d-06,-8.2644802092669d-07,
     |  -4.8184901671923d-08,-1.4909201993749d-09,-1.8029328438361d-11,
     |  -4.5799836132418d-14,-4.9087737251232d-18,-1.3015537652955d-26/
      data (pmn(lat,19,25), lat = 1,72)/
     |   1.3117373942849d-28, 1.4870510822116d-19, 2.3214975999283d-15,
     |   1.2870305174632d-12, 1.3793924325688d-10, 5.5044853191665d-09,
     |   1.1297677326238d-07, 1.4322168920883d-06, 1.2563913899278d-05,
     |   8.2223272255278d-05, 4.2292118440528d-04, 1.7748429066749d-03,
     |   6.2463603902587d-03, 1.8816923356735d-02, 4.9267421827692d-02,
     |   1.1337996908135d-01, 2.3114378778213d-01, 4.1942221142339d-01,
     |   6.7841218553129d-01, 9.7577120131418d-01, 1.2378079284274d+00,
     |   1.3595058479923d+00, 1.2398807715056d+00, 8.3533299865532d-01,
     |   2.0700893584492d-01,-4.6992048538689d-01,-9.5642627313338d-01,
     |  -1.0506581360877d+00,-6.9614283208205d-01,-3.5982090899458d-02,
     |   6.3054677073048d-01, 9.8270941635438d-01, 8.4181755200416d-01,
     |   2.7409357813234d-01,-4.3180514215893d-01,-9.0988902002316d-01,
     |  -9.0988902002316d-01,-4.3180514215893d-01, 2.7409357813234d-01,
     |   8.4181755200415d-01, 9.8270941635438d-01, 6.3054677073048d-01,
     |  -3.5982090899456d-02,-6.9614283208204d-01,-1.0506581360877d+00,
     |  -9.5642627313338d-01,-4.6992048538690d-01, 2.0700893584492d-01,
     |   8.3533299865531d-01, 1.2398807715056d+00, 1.3595058479923d+00,
     |   1.2378079284274d+00, 9.7577120131418d-01, 6.7841218553130d-01,
     |   4.1942221142339d-01, 2.3114378778213d-01, 1.1337996908135d-01,
     |   4.9267421827692d-02, 1.8816923356735d-02, 6.2463603902588d-03,
     |   1.7748429066749d-03, 4.2292118440528d-04, 8.2223272255279d-05,
     |   1.2563913899278d-05, 1.4322168920883d-06, 1.1297677326238d-07,
     |   5.5044853191667d-09, 1.3793924325688d-10, 1.2870305174632d-12,
     |   2.3214975999283d-15, 1.4870510822116d-19, 1.3117373942849d-28/
      data (pmn(lat,20,25), lat = 1,72)/
     |   1.1758539759646d-30, 4.0062013361142d-21, 1.0461392165061d-16,
     |   8.1640400082725d-14, 1.1332871896709d-11, 5.5791329076290d-10,
     |   1.3687865335312d-08, 2.0295558630938d-07, 2.0501799409447d-06,
     |   1.5275221592602d-05, 8.8705093506090d-05, 4.1776362950295d-04,
     |   1.6432119787299d-03, 5.5188567076291d-03, 1.6095820005634d-02,
     |   4.1291081538017d-02, 9.4071458900616d-02, 1.9165452271521d-01,
     |   3.5071915204002d-01, 5.7755487854483d-01, 8.5494866127109d-01,
     |   1.1317344899152d+00, 1.3239091333965d+00, 1.3347475067736d+00,
     |   1.0935106882496d+00, 6.0009339720603d-01,-4.7210630943519d-02,
     |  -6.6353663998952d-01,-1.0367884507478d+00,-1.0171927352240d+00,
     |  -5.9713689623139d-01, 6.3376959594057d-02, 6.8956874155998d-01,
     |   1.0078959302046d+00, 8.7325443798526d-01, 3.4310460608701d-01,
     |  -3.4310460608700d-01,-8.7325443798526d-01,-1.0078959302046d+00,
     |  -6.8956874155998d-01,-6.3376959594060d-02, 5.9713689623139d-01,
     |   1.0171927352240d+00, 1.0367884507478d+00, 6.6353663998953d-01,
     |   4.7210630943521d-02,-6.0009339720602d-01,-1.0935106882496d+00,
     |  -1.3347475067736d+00,-1.3239091333965d+00,-1.1317344899152d+00,
     |  -8.5494866127109d-01,-5.7755487854483d-01,-3.5071915204002d-01,
     |  -1.9165452271521d-01,-9.4071458900616d-02,-4.1291081538017d-02,
     |  -1.6095820005634d-02,-5.5188567076291d-03,-1.6432119787300d-03,
     |  -4.1776362950295d-04,-8.8705093506090d-05,-1.5275221592602d-05,
     |  -2.0501799409447d-06,-2.0295558630938d-07,-1.3687865335312d-08,
     |  -5.5791329076292d-10,-1.1332871896709d-11,-8.1640400082725d-14,
     |  -1.0461392165061d-16,-4.0062013361142d-21,-1.1758539759646d-30/
      data (pmn(lat,21,25), lat = 1,72)/
     |   9.2649983761144d-33, 9.4856409618161d-23, 4.1420903137929d-18,
     |   4.5483051647887d-15, 8.1728395798809d-13, 4.9599525095640d-11,
     |   1.4532564182241d-09, 2.5174495353988d-08, 2.9243440165113d-07,
     |   2.4764381676850d-06, 1.6203697531882d-05, 8.5433085509343d-05,
     |   3.7446261092466d-04, 1.3971288777566d-03, 4.5187868942341d-03,
     |   1.2850128937610d-02, 3.2483562393765d-02, 7.3612369817657d-02,
     |   1.5048197888275d-01, 2.7868876894338d-01, 4.6865427926452d-01,
     |   7.1568641103898d-01, 9.8979550402153d-01, 1.2311863186444d+00,
     |   1.3580149454496d+00, 1.2896766014202d+00, 9.8147203194806d-01,
     |   4.5778566509415d-01,-1.7400366483882d-01,-7.4299912969290d-01,
     |  -1.0685708589308d+00,-1.0314889857360d+00,-6.3215351000279d-01,
     |  -5.8364931447685d-03, 6.1881059268554d-01, 1.0055858830073d+00,
     |   1.0055858830073d+00, 6.1881059268554d-01,-5.8364931447664d-03,
     |  -6.3215351000279d-01,-1.0314889857360d+00,-1.0685708589308d+00,
     |  -7.4299912969290d-01,-1.7400366483882d-01, 4.5778566509415d-01,
     |   9.8147203194806d-01, 1.2896766014202d+00, 1.3580149454496d+00,
     |   1.2311863186444d+00, 9.8979550402153d-01, 7.1568641103898d-01,
     |   4.6865427926452d-01, 2.7868876894338d-01, 1.5048197888275d-01,
     |   7.3612369817657d-02, 3.2483562393765d-02, 1.2850128937610d-02,
     |   4.5187868942341d-03, 1.3971288777566d-03, 3.7446261092467d-04,
     |   8.5433085509343d-05, 1.6203697531882d-05, 2.4764381676851d-06,
     |   2.9243440165114d-07, 2.5174495353988d-08, 1.4532564182241d-09,
     |   4.9599525095642d-11, 8.1728395798809d-13, 4.5483051647887d-15,
     |   4.1420903137929d-18, 9.4856409618161d-23, 9.2649983761144d-33/
      data (pmn(lat,22,25), lat = 1,72)/
     |   6.3000297265919d-35, 1.9380059069300d-24, 1.4148210923072d-19,
     |   2.1851908264221d-16, 5.0802773465771d-14, 3.7983413988805d-12,
     |   1.3280378811040d-10, 2.6851086102346d-09, 3.5826048265674d-08,
     |   3.4434470249521d-07, 2.5344240880809d-06, 1.4929780905445d-05,
     |   7.2747131427698d-05, 3.0065264879788d-04, 1.0746170771359d-03,
     |   3.3730370706287d-03, 9.4106733530957d-03, 2.3562127062518d-02,
     |   5.3342626801929d-02, 1.0982854970340d-01, 2.0652471608238d-01,
     |   3.5565109587053d-01, 5.6151113383074d-01, 8.1216490554918d-01,
     |   1.0726513843472d+00, 1.2844181169401d+00, 1.3750708736144d+00,
     |   1.2792361184649d+00, 9.6583712029918d-01, 4.6171978601579d-01,
     |  -1.4047023775666d-01,-6.9858738624299d-01,-1.0607544655584d+00,
     |  -1.1167675363866d+00,-8.4164696152740d-01,-3.1228794543278d-01,
     |   3.1228794543278d-01, 8.4164696152740d-01, 1.1167675363866d+00,
     |   1.0607544655584d+00, 6.9858738624299d-01, 1.4047023775665d-01,
     |  -4.6171978601579d-01,-9.6583712029918d-01,-1.2792361184649d+00,
     |  -1.3750708736144d+00,-1.2844181169401d+00,-1.0726513843472d+00,
     |  -8.1216490554918d-01,-5.6151113383074d-01,-3.5565109587053d-01,
     |  -2.0652471608238d-01,-1.0982854970340d-01,-5.3342626801929d-02,
     |  -2.3562127062518d-02,-9.4106733530958d-03,-3.3730370706287d-03,
     |  -1.0746170771359d-03,-3.0065264879788d-04,-7.2747131427699d-05,
     |  -1.4929780905445d-05,-2.5344240880809d-06,-3.4434470249521d-07,
     |  -3.5826048265675d-08,-2.6851086102347d-09,-1.3280378811040d-10,
     |  -3.7983413988807d-12,-5.0802773465771d-14,-2.1851908264221d-16,
     |  -1.4148210923072d-19,-1.9380059069300d-24,-6.3000297265919d-35/
      data (pmn(lat,23,25), lat = 1,72)/
     |   3.5861750268275d-37, 3.3142916000164d-26, 4.0442781133782d-21,
     |   8.7831448703969d-18, 2.6408065621357d-15, 2.4311165512642d-13,
     |   1.0136229818644d-11, 2.3900045861997d-10, 3.6590691976529d-09,
     |   3.9869723847637d-08, 3.2962112939869d-07, 2.1658351400683d-06,
     |   1.1708674894191d-05, 5.3475615064856d-05, 2.1063311787997d-04,
     |   7.2728839457474d-04, 2.2303125621194d-03, 6.1386728337029d-03,
     |   1.5294260740617d-02, 3.4730204385415d-02, 7.2274587346548d-02,
     |   1.3842216021515d-01, 2.4474638002475d-01, 4.0029243926009d-01,
     |   6.0606766880041d-01, 8.4888848383669d-01, 1.0970618969159d+00,
     |   1.3009782379769d+00, 1.4009624250208d+00, 1.3424140649710d+00,
     |   1.0949250096507d+00, 6.6907724205038d-01, 1.2366335167731d-01,
     |  -4.4178627121477d-01,-9.0932828761716d-01,-1.1739767872589d+00,
     |  -1.1739767872589d+00,-9.0932828761716d-01,-4.4178627121477d-01,
     |   1.2366335167731d-01, 6.6907724205038d-01, 1.0949250096507d+00,
     |   1.3424140649710d+00, 1.4009624250208d+00, 1.3009782379769d+00,
     |   1.0970618969159d+00, 8.4888848383669d-01, 6.0606766880042d-01,
     |   4.0029243926009d-01, 2.4474638002475d-01, 1.3842216021515d-01,
     |   7.2274587346549d-02, 3.4730204385415d-02, 1.5294260740617d-02,
     |   6.1386728337029d-03, 2.2303125621194d-03, 7.2728839457475d-04,
     |   2.1063311787997d-04, 5.3475615064856d-05, 1.1708674894191d-05,
     |   2.1658351400683d-06, 3.2962112939869d-07, 3.9869723847638d-08,
     |   3.6590691976530d-09, 2.3900045861997d-10, 1.0136229818644d-11,
     |   2.4311165512643d-13, 2.6408065621357d-15, 8.7831448703969d-18,
     |   4.0442781133782d-21, 3.3142916000164d-26, 3.5861750268275d-37/
      data (pmn(lat,24,25), lat = 1,72)/
     |   1.6138526563749d-39, 4.4805442382615d-28, 9.1370521837385d-23,
     |   2.7894359848675d-19, 1.0842472050928d-16, 1.2284313274321d-14,
     |   6.1040285787873d-13, 1.6772415821557d-11, 2.9439270480031d-10,
     |   3.6327321659931d-09, 3.3695181697529d-08, 2.4660374972712d-07,
     |   1.4766591021175d-06, 7.4383838399424d-06, 3.2212962617785d-05,
     |   1.2202166543598d-04, 4.0995894962035d-04, 1.2355554646660d-03,
     |   3.3716544218951d-03, 8.3949440789077d-03, 1.9193090215729d-02,
     |   4.0504278029417d-02, 7.9240843065480d-02, 1.4420717760923d-01,
     |   2.4477899333378d-01, 3.8827782427365d-01, 5.7621260342857d-01,
     |   8.0020384144580d-01, 1.0390264412065d+00, 1.2584633333710d+00,
     |   1.4152499119639d+00, 1.4652348108560d+00, 1.3742720963681d+00,
     |   1.1289031499144d+00, 7.4328432352919d-01, 2.5951901474901d-01,
     |  -2.5951901474901d-01,-7.4328432352918d-01,-1.1289031499144d+00,
     |  -1.3742720963681d+00,-1.4652348108560d+00,-1.4152499119639d+00,
     |  -1.2584633333710d+00,-1.0390264412065d+00,-8.0020384144580d-01,
     |  -5.7621260342857d-01,-3.8827782427365d-01,-2.4477899333378d-01,
     |  -1.4420717760923d-01,-7.9240843065480d-02,-4.0504278029417d-02,
     |  -1.9193090215729d-02,-8.3949440789077d-03,-3.3716544218951d-03,
     |  -1.2355554646660d-03,-4.0995894962036d-04,-1.2202166543599d-04,
     |  -3.2212962617784d-05,-7.4383838399423d-06,-1.4766591021175d-06,
     |  -2.4660374972712d-07,-3.3695181697529d-08,-3.6327321659931d-09,
     |  -2.9439270480031d-10,-1.6772415821557d-11,-6.1040285787873d-13,
     |  -1.2284313274321d-14,-1.0842472050928d-16,-2.7894359848675d-19,
     |  -9.1370521837385d-23,-4.4805442382615d-28,-1.6138526563749d-39/
      data (pmn(lat,25,25), lat = 1,72)/
     |   4.9800668257938d-42, 4.1531264087121d-30, 1.4151610294551d-24,
     |   6.0717174965383d-21, 3.0500369127826d-18, 4.2510585591047d-16,
     |   2.5161151475946d-14, 8.0517796371592d-13, 1.6190349853159d-11,
     |   2.2605361049773d-10, 2.3499456058881d-09, 1.9133100339648d-08,
     |   1.2672184227110d-07, 7.0288806651713d-07, 3.3403047517935d-06,
     |   1.3849780946850d-05, 5.0844421122223d-05, 1.6727134782074d-04,
     |   4.9809678707226d-04, 1.3537699439777d-03, 3.3819637176558d-03,
     |   7.8122380499649d-03, 1.6771484240509d-02, 3.3608230055841d-02,
     |   6.3098417443046d-02, 1.1134803976092d-01, 1.8519731264780d-01,
     |   2.9100566128762d-01, 4.3287283822528d-01, 6.1059973027039d-01,
     |   8.1793148874810d-01, 1.0417426371577d+00, 1.2627214756925d+00,
     |   1.4577630073839d+00, 1.6037644730451d+00, 1.6820073544523d+00,
     |   1.6820073544523d+00, 1.6037644730451d+00, 1.4577630073839d+00,
     |   1.2627214756925d+00, 1.0417426371577d+00, 8.1793148874810d-01,
     |   6.1059973027039d-01, 4.3287283822528d-01, 2.9100566128762d-01,
     |   1.8519731264780d-01, 1.1134803976092d-01, 6.3098417443046d-02,
     |   3.3608230055841d-02, 1.6771484240509d-02, 7.8122380499649d-03,
     |   3.3819637176558d-03, 1.3537699439777d-03, 4.9809678707226d-04,
     |   1.6727134782074d-04, 5.0844421122223d-05, 1.3849780946850d-05,
     |   3.3403047517934d-06, 7.0288806651712d-07, 1.2672184227110d-07,
     |   1.9133100339648d-08, 2.3499456058881d-09, 2.2605361049773d-10,
     |   1.6190349853160d-11, 8.0517796371593d-13, 2.5161151475946d-14,
     |   4.2510585591049d-16, 3.0500369127826d-18, 6.0717174965383d-21,
     |   1.4151610294551d-24, 4.1531264087121d-30, 4.9800668257938d-42/
      data (pmn(lat, 0,26), lat = 1,72)/
     |   4.7266973671526d+00, 1.9466016733551d+00,-1.1381282728670d+00,
     |  -2.0301735414570d+00,-5.6325058162198d-01, 1.2197791320516d+00,
     |   1.3687376578469d+00,-2.6610443930086d-02,-1.2230404432951d+00,
     |  -9.0749954340184d-01, 4.1170438238011d-01, 1.1477344544265d+00,
     |   5.0824213775821d-01,-6.7305576524140d-01,-1.0007815678853d+00,
     |  -1.4835604993893d-01, 8.3147124241792d-01, 7.9443165947134d-01,
     |  -1.6890100977080d-01,-8.9514022258614d-01,-5.4480958464123d-01,
     |   4.3308912136721d-01, 8.7095809826397d-01, 2.7076316699166d-01,
     |  -6.3295571406015d-01,-7.6813224011578d-01, 7.3671180211906d-03,
     |   7.5939502635694d-01, 5.9927990054927d-01,-2.6906760674613d-01,
     |  -8.0706238058074d-01,-3.8041740712679d-01, 4.9498594478579d-01,
     |   7.7524397380622d-01, 1.3034295087668d-01,-6.6818787095017d-01,
     |  -6.6818787095017d-01, 1.3034295087667d-01, 7.7524397380622d-01,
     |   4.9498594478579d-01,-3.8041740712679d-01,-8.0706238058074d-01,
     |  -2.6906760674613d-01, 5.9927990054926d-01, 7.5939502635694d-01,
     |   7.3671180211927d-03,-7.6813224011578d-01,-6.3295571406015d-01,
     |   2.7076316699166d-01, 8.7095809826397d-01, 4.3308912136721d-01,
     |  -5.4480958464122d-01,-8.9514022258614d-01,-1.6890100977080d-01,
     |   7.9443165947134d-01, 8.3147124241793d-01,-1.4835604993893d-01,
     |  -1.0007815678853d+00,-6.7305576524140d-01, 5.0824213775820d-01,
     |   1.1477344544265d+00, 4.1170438238011d-01,-9.0749954340184d-01,
     |  -1.2230404432951d+00,-2.6610443930093d-02, 1.3687376578469d+00,
     |   1.2197791320517d+00,-5.6325058162198d-01,-2.0301735414570d+00,
     |  -1.1381282728670d+00, 1.9466016733551d+00, 4.7266973671526d+00/
      data (pmn(lat, 1,26), lat = 1,72)/
     |   1.4265905786761d+00, 2.9842661835698d+00, 1.9523869063388d+00,
     |  -4.3057130595510d-01,-1.7730713908470d+00,-9.9737699091995d-01,
     |   7.1947149311553d-01, 1.4070251320940d+00, 4.4982869666294d-01,
     |  -9.0908861457588d-01,-1.1118014344913d+00,-3.3180404551114d-02,
     |   1.0005012137457d+00, 8.1363824838771d-01,-2.9889782900677d-01,
     |  -1.0014200888061d+00,-5.0568266057119d-01, 5.5367629894310d-01,
     |   9.2072415678590d-01, 1.9791975949327d-01,-7.2917161934627d-01,
     |  -7.7001106904855d-01, 9.4026897705113d-02, 8.2269238352555d-01,
     |   5.6406194666301d-01,-3.5317028342459d-01,-8.3412322542501d-01,
     |  -3.2050206238358d-01, 5.6353785297472d-01, 7.6730154142248d-01,
     |   5.8979680102846d-02,-7.1179399696883d-01,-6.3044523988541d-01,
     |   1.9993455106300d-01, 7.8840322029206d-01, 4.3597996162468d-01,
     |  -4.3597996162468d-01,-7.8840322029206d-01,-1.9993455106300d-01,
     |   6.3044523988541d-01, 7.1179399696883d-01,-5.8979680102848d-02,
     |  -7.6730154142248d-01,-5.6353785297473d-01, 3.2050206238358d-01,
     |   8.3412322542501d-01, 3.5317028342460d-01,-5.6406194666300d-01,
     |  -8.2269238352555d-01,-9.4026897705113d-02, 7.7001106904855d-01,
     |   7.2917161934628d-01,-1.9791975949326d-01,-9.2072415678590d-01,
     |  -5.5367629894311d-01, 5.0568266057118d-01, 1.0014200888061d+00,
     |   2.9889782900676d-01,-8.1363824838772d-01,-1.0005012137457d+00,
     |   3.3180404551114d-02, 1.1118014344913d+00, 9.0908861457588d-01,
     |  -4.4982869666293d-01,-1.4070251320939d+00,-7.1947149311553d-01,
     |   9.9737699091993d-01, 1.7730713908470d+00, 4.3057130595510d-01,
     |  -1.9523869063388d+00,-2.9842661835698d+00,-1.4265905786761d+00/
      data (pmn(lat, 2,26), lat = 1,72)/
     |   2.0879735366814d-01, 1.4924473521076d+00, 2.4873564312267d+00,
     |   1.8216031157338d+00,-1.0976769830429d-01,-1.5296327863629d+00,
     |  -1.1840984895731d+00, 3.3997813591585d-01, 1.3122271612940d+00,
     |   7.5261551226796d-01,-5.8271707026697d-01,-1.1539447556328d+00,
     |  -3.8433200739143d-01, 7.6606572971194d-01, 9.7139515525197d-01,
     |   5.4247287737167d-02,-8.7624662858410d-01,-7.5184449971739d-01,
     |   2.3576982550912d-01, 9.0953881431613d-01, 5.0134869669420d-01,
     |  -4.7638678505524d-01,-8.6745217967102d-01,-2.3341206009038d-01,
     |   6.5725188930131d-01, 7.5606320487646d-01,-3.5121966169773d-02,
     |  -7.6990073154477d-01,-5.8567483677302d-01, 2.8635791487849d-01,
     |   8.0930547896756d-01, 3.7025768099904d-01,-5.0302770485069d-01,
     |  -7.7469546341764d-01,-1.2662278385529d-01, 6.6986086822027d-01,
     |   6.6986086822027d-01,-1.2662278385528d-01,-7.7469546341764d-01,
     |  -5.0302770485070d-01, 3.7025768099904d-01, 8.0930547896756d-01,
     |   2.8635791487850d-01,-5.8567483677302d-01,-7.6990073154477d-01,
     |  -3.5121966169775d-02, 7.5606320487646d-01, 6.5725188930131d-01,
     |  -2.3341206009038d-01,-8.6745217967102d-01,-4.7638678505524d-01,
     |   5.0134869669419d-01, 9.0953881431613d-01, 2.3576982550913d-01,
     |  -7.5184449971739d-01,-8.7624662858411d-01, 5.4247287737163d-02,
     |   9.7139515525197d-01, 7.6606572971194d-01,-3.8433200739142d-01,
     |  -1.1539447556328d+00,-5.8271707026697d-01, 7.5261551226796d-01,
     |   1.3122271612940d+00, 3.3997813591586d-01,-1.1840984895731d+00,
     |  -1.5296327863629d+00,-1.0976769830429d-01, 1.8216031157338d+00,
     |   2.4873564312267d+00, 1.4924473521076d+00, 2.0879735366814d-01/
      data (pmn(lat, 3,26), lat = 1,72)/
     |   2.0171095339539d-02, 4.5960163514861d-01, 1.4855786150378d+00,
     |   2.2262469344624d+00, 1.6944894373547d+00, 5.2450598325090d-02,
     |  -1.3374842518302d+00,-1.2592089131841d+00, 6.0503711978761d-02,
     |   1.1710347829244d+00, 9.3583290644036d-01,-2.8563554366603d-01,
     |  -1.0994018248887d+00,-6.4214130306745d-01, 5.0062355779710d-01,
     |   1.0145416885043d+00, 3.5564026148556d-01,-6.7434511461914d-01,
     |  -8.8914550280031d-01,-7.7549188387303d-02, 7.9227185844443d-01,
     |   7.1925965677918d-01,-1.8217740151741d-01,-8.4652814044659d-01,
     |  -5.1100938235905d-01, 4.1071492296944d-01, 8.3417356253885d-01,
     |   2.7602711519569d-01,-5.9529836137529d-01,-7.5684823212543d-01,
     |  -2.9122810018236d-02, 7.2500305873070d-01, 6.2051536778775d-01,
     |  -2.1337210769772d-01,-7.9192383701099d-01,-4.3501484744131d-01,
     |   4.3501484744131d-01, 7.9192383701099d-01, 2.1337210769772d-01,
     |  -6.2051536778775d-01,-7.2500305873071d-01, 2.9122810018238d-02,
     |   7.5684823212543d-01, 5.9529836137529d-01,-2.7602711519569d-01,
     |  -8.3417356253885d-01,-4.1071492296944d-01, 5.1100938235904d-01,
     |   8.4652814044659d-01, 1.8217740151741d-01,-7.1925965677918d-01,
     |  -7.9227185844444d-01, 7.7549188387300d-02, 8.8914550280031d-01,
     |   6.7434511461914d-01,-3.5564026148556d-01,-1.0145416885043d+00,
     |  -5.0062355779709d-01, 6.4214130306745d-01, 1.0994018248887d+00,
     |   2.8563554366603d-01,-9.3583290644036d-01,-1.1710347829244d+00,
     |  -6.0503711978774d-02, 1.2592089131841d+00, 1.3374842518302d+00,
     |  -5.2450598325071d-02,-1.6944894373547d+00,-2.2262469344624d+00,
     |  -1.4855786150378d+00,-4.5960163514861d-01,-2.0171095339539d-02/
      data (pmn(lat, 4,26), lat = 1,72)/
     |   1.4510801849548d-03, 1.0276935386442d-01, 6.0025311673185d-01,
     |   1.4743406544863d+00, 2.0560689424210d+00, 1.5852294798307d+00,
     |   1.4110252507858d-01,-1.1887648588095d+00,-1.2823820206609d+00,
     |  -1.4797887085300d-01, 1.0187061180642d+00, 1.0400273837872d+00,
     |  -2.7835321433978d-02,-9.8890450430656d-01,-8.1965509577942d-01,
     |   2.3425649523989d-01, 9.7267772884744d-01, 5.9420314048730d-01,
     |  -4.3121399788690d-01,-9.2901907886522d-01,-3.5828186487857d-01,
     |   5.9891631481603d-01, 8.4341113024315d-01, 1.1709057376489d-01,
     |  -7.2413962437258d-01,-7.1307942556606d-01, 1.1911336064651d-01,
     |   7.9775930976512d-01, 5.4205819745136d-01,-3.3798910616533d-01,
     |  -8.1444434518977d-01,-3.3892365338036d-01, 5.2702525829468d-01,
     |   7.7271877604768d-01, 1.1531609023536d-01,-6.7493514154290d-01,
     |  -6.7493514154290d-01, 1.1531609023536d-01, 7.7271877604768d-01,
     |   5.2702525829468d-01,-3.3892365338035d-01,-8.1444434518977d-01,
     |  -3.3798910616533d-01, 5.4205819745135d-01, 7.9775930976513d-01,
     |   1.1911336064651d-01,-7.1307942556606d-01,-7.2413962437259d-01,
     |   1.1709057376488d-01, 8.4341113024315d-01, 5.9891631481603d-01,
     |  -3.5828186487856d-01,-9.2901907886522d-01,-4.3121399788690d-01,
     |   5.9420314048730d-01, 9.7267772884744d-01, 2.3425649523989d-01,
     |  -8.1965509577942d-01,-9.8890450430656d-01,-2.7835321433989d-02,
     |   1.0400273837872d+00, 1.0187061180642d+00,-1.4797887085299d-01,
     |  -1.2823820206609d+00,-1.1887648588095d+00, 1.4110252507858d-01,
     |   1.5852294798307d+00, 2.0560689424210d+00, 1.4743406544863d+00,
     |   6.0025311673185d-01, 1.0276935386442d-01, 1.4510801849548d-03/
      data (pmn(lat, 5,26), lat = 1,72)/
     |   8.2908976210252d-05, 1.8032131225606d-02, 1.8472122887376d-01,
     |   6.9510807044107d-01, 1.4620588514885d+00, 1.9317775366103d+00,
     |   1.4936032953482d+00, 1.9378825540823d-01,-1.0710428002975d+00,
     |  -1.2809060562467d+00,-3.0849803342766d-01, 8.6803278126951d-01,
     |   1.0917791409467d+00, 1.9251946028585d-01,-8.4599438323564d-01,
     |  -9.3106218104954d-01,-1.7954894255581d-02, 8.6843522808041d-01,
     |   7.6789053221767d-01,-1.7157764270332d-01,-8.8499242465354d-01,
     |  -5.8894046585803d-01, 3.5587811951469d-01, 8.7324450641787d-01,
     |   3.9229770819618d-01,-5.2084034947339d-01,-8.2299640402029d-01,
     |  -1.8260625838793d-01, 6.5514667540255d-01, 7.3109565722153d-01,
     |  -3.1757547429285d-02,-7.4989484787201d-01,-5.9929511650213d-01,
     |   2.4054402838724d-01, 7.9887036239144d-01, 4.3304736577755d-01,
     |  -4.3304736577755d-01,-7.9887036239144d-01,-2.4054402838724d-01,
     |   5.9929511650213d-01, 7.4989484787201d-01, 3.1757547429283d-02,
     |  -7.3109565722153d-01,-6.5514667540255d-01, 1.8260625838793d-01,
     |   8.2299640402029d-01, 5.2084034947339d-01,-3.9229770819618d-01,
     |  -8.7324450641787d-01,-3.5587811951469d-01, 5.8894046585803d-01,
     |   8.8499242465354d-01, 1.7157764270333d-01,-7.6789053221767d-01,
     |  -8.6843522808041d-01, 1.7954894255574d-02, 9.3106218104954d-01,
     |   8.4599438323564d-01,-1.9251946028585d-01,-1.0917791409467d+00,
     |  -8.6803278126951d-01, 3.0849803342766d-01, 1.2809060562467d+00,
     |   1.0710428002975d+00,-1.9378825540822d-01,-1.4936032953482d+00,
     |  -1.9317775366103d+00,-1.4620588514885d+00,-6.9510807044107d-01,
     |  -1.8472122887376d-01,-1.8032131225606d-02,-8.2908976210252d-05/
      data (pmn(lat, 6,26), lat = 1,72)/
     |   3.9153937489253d-06, 2.5975647648001d-03, 4.5947178564758d-02,
     |   2.5688803904885d-01, 7.6411616463813d-01, 1.4483976537335d+00,
     |   1.8346011312832d+00, 1.4177996047217d+00, 2.2943954907663d-01,
     |  -9.7389782713159d-01,-1.2675774737897d+00,-4.3738448437455d-01,
     |   7.2209672120273d-01, 1.1073821681009d+00, 3.8064675231360d-01,
     |  -6.8350339611943d-01,-9.8778606415624d-01,-2.4865596569113d-01,
     |   7.1797974221259d-01, 8.7786100649897d-01, 8.6940765793365d-02,
     |  -7.6993774078123d-01,-7.5793379227742d-01, 8.6453938225743d-02,
     |   8.1253131889973d-01, 6.1928343078588d-01,-2.5968990366356d-01,
     |  -8.3106645366105d-01,-4.6028677133589d-01, 4.2269778147439d-01,
     |   8.1748408406582d-01, 2.8389507924436d-01,-5.6651458041010d-01,
     |  -7.6828457733647d-01,-9.5972338329679d-02, 6.8358351561216d-01,
     |   6.8358351561216d-01,-9.5972338329677d-02,-7.6828457733647d-01,
     |  -5.6651458041010d-01, 2.8389507924435d-01, 8.1748408406582d-01,
     |   4.2269778147439d-01,-4.6028677133588d-01,-8.3106645366105d-01,
     |  -2.5968990366356d-01, 6.1928343078588d-01, 8.1253131889973d-01,
     |   8.6453938225746d-02,-7.5793379227742d-01,-7.6993774078123d-01,
     |   8.6940765793352d-02, 8.7786100649897d-01, 7.1797974221260d-01,
     |  -2.4865596569113d-01,-9.8778606415624d-01,-6.8350339611943d-01,
     |   3.8064675231361d-01, 1.1073821681009d+00, 7.2209672120274d-01,
     |  -4.3738448437455d-01,-1.2675774737897d+00,-9.7389782713160d-01,
     |   2.2943954907662d-01, 1.4177996047217d+00, 1.8346011312832d+00,
     |   1.4483976537336d+00, 7.6411616463813d-01, 2.5688803904885d-01,
     |   4.5947178564758d-02, 2.5975647648001d-03, 3.9153937489253d-06/
      data (pmn(lat, 7,26), lat = 1,72)/
     |   1.5699037326168d-07, 3.1637775575557d-04, 9.5742434522114d-03,
     |   7.8203334079946d-02, 3.1905842082854d-01, 8.1555373212463d-01,
     |   1.4329111270455d+00, 1.7553932714315d+00, 1.3563256371195d+00,
     |   2.5864326919408d-01,-8.8933894102480d-01,-1.2482818422399d+00,
     |  -5.4582146141813d-01, 5.7986881567787d-01, 1.0961390049584d+00,
     |   5.4169355111125d-01,-5.0800191695436d-01,-9.9762331568536d-01,
     |  -4.5379500468165d-01, 5.3273313853786d-01, 9.2559452118664d-01,
     |   3.3057327803168d-01,-5.9565434821891d-01,-8.5664258175601d-01,
     |  -1.8762912655826d-01, 6.6820458062554d-01, 7.7707077430925d-01,
     |   3.3299763698804d-02,-7.3405827544512d-01,-6.8016298653666d-01,
     |   1.2548214652826d-01, 7.8305857931814d-01, 5.6399001401163d-01,
     |  -2.8202307749822d-01,-8.0903832867895d-01,-4.2999924442073d-01,
     |   4.2999924442072d-01, 8.0903832867895d-01, 2.8202307749822d-01,
     |  -5.6399001401163d-01,-7.8305857931814d-01,-1.2548214652826d-01,
     |   6.8016298653666d-01, 7.3405827544513d-01,-3.3299763698801d-02,
     |  -7.7707077430925d-01,-6.6820458062555d-01, 1.8762912655826d-01,
     |   8.5664258175601d-01, 5.9565434821891d-01,-3.3057327803168d-01,
     |  -9.2559452118664d-01,-5.3273313853786d-01, 4.5379500468164d-01,
     |   9.9762331568536d-01, 5.0800191695437d-01,-5.4169355111125d-01,
     |  -1.0961390049584d+00,-5.7986881567786d-01, 5.4582146141812d-01,
     |   1.2482818422399d+00, 8.8933894102480d-01,-2.5864326919407d-01,
     |  -1.3563256371195d+00,-1.7553932714315d+00,-1.4329111270455d+00,
     |  -8.1555373212463d-01,-3.1905842082854d-01,-7.8203334079946d-02,
     |  -9.5742434522114d-03,-3.1637775575557d-04,-1.5699037326168d-07/
      data (pmn(lat, 8,26), lat = 1,72)/
     |   5.4472651001554d-09, 3.3255433779136d-05, 1.7115125691771d-03,
     |   2.0213611549945d-02, 1.1117608425499d-01, 3.7182466399600d-01,
     |   8.5352243688369d-01, 1.4153456079009d+00, 1.6892388309353d+00,
     |   1.3081742365586d+00, 2.8788513971509d-01,-8.1119775049207d-01,
     |  -1.2253365668468d+00,-6.4129418196619d-01, 4.3870022639356d-01,
     |   1.0626402029062d+00, 6.7935989273892d-01,-3.2269335417520d-01,
     |  -9.6500318681655d-01,-6.2998118297389d-01, 3.2131078668561d-01,
     |   9.1174789141992d-01, 5.4687333390878d-01,-3.7371626179479d-01,
     |  -8.7798859963390d-01,-4.4444977031687d-01, 4.5082570014593d-01,
     |   8.4715646484859d-01, 3.2799411775051d-01,-5.3645382118626d-01,
     |  -8.0938162415226d-01,-2.0115869984685d-01, 6.2043529054081d-01,
     |   7.5955200885664d-01, 6.7798144738090d-02,-6.9611922196484d-01,
     |  -6.9611922196484d-01, 6.7798144738088d-02, 7.5955200885664d-01,
     |   6.2043529054081d-01,-2.0115869984685d-01,-8.0938162415226d-01,
     |  -5.3645382118626d-01, 3.2799411775050d-01, 8.4715646484859d-01,
     |   4.5082570014594d-01,-4.4444977031687d-01,-8.7798859963390d-01,
     |  -3.7371626179479d-01, 5.4687333390878d-01, 9.1174789141992d-01,
     |   3.2131078668562d-01,-6.2998118297389d-01,-9.6500318681656d-01,
     |  -3.2269335417520d-01, 6.7935989273891d-01, 1.0626402029062d+00,
     |   4.3870022639355d-01,-6.4129418196620d-01,-1.2253365668468d+00,
     |  -8.1119775049207d-01, 2.8788513971509d-01, 1.3081742365586d+00,
     |   1.6892388309353d+00, 1.4153456079009d+00, 8.5352243688369d-01,
     |   3.7182466399600d-01, 1.1117608425499d-01, 2.0213611549945d-02,
     |   1.7115125691771d-03, 3.3255433779136d-05, 5.4472651001554d-09/
      data (pmn(lat, 9,26), lat = 1,72)/
     |   1.6587634479662d-10, 3.0619054032209d-06, 2.6690685640987d-04,
     |   4.5267967897558d-03, 3.3201887456960d-02, 1.4278224092501d-01,
     |   4.1566929150546d-01, 8.8030872000877d-01, 1.3955822249156d+00,
     |   1.6332806639281d+00, 1.2726906961968d+00, 3.2148067693958d-01,
     |  -7.3449933889023d-01,-1.1989930325939d+00,-7.2857407425367d-01,
     |   2.9547587543543d-01, 1.0082243290041d+00, 7.9533240685220d-01,
     |  -1.2935317547888d-01,-8.9163602221284d-01,-7.7288797637504d-01,
     |   9.1407647837581d-02, 8.3610272782092d-01, 7.2289244675670d-01,
     |  -1.1705333173364d-01,-8.1635292302564d-01,-6.6042571148950d-01,
     |   1.7628401511268d-01, 8.1429483795433d-01, 5.8907202626407d-01,
     |  -2.5331641373227d-01,-8.1844630297002d-01,-5.1023365685836d-01,
     |   3.3860824937279d-01, 8.2208009404037d-01, 4.2574276977963d-01,
     |  -4.2574276977962d-01,-8.2208009404037d-01,-3.3860824937279d-01,
     |   5.1023365685836d-01, 8.1844630297002d-01, 2.5331641373227d-01,
     |  -5.8907202626407d-01,-8.1429483795433d-01,-1.7628401511268d-01,
     |   6.6042571148950d-01, 8.1635292302564d-01, 1.1705333173365d-01,
     |  -7.2289244675669d-01,-8.3610272782092d-01,-9.1407647837581d-02,
     |   7.7288797637503d-01, 8.9163602221284d-01, 1.2935317547889d-01,
     |  -7.9533240685220d-01,-1.0082243290042d+00,-2.9547587543544d-01,
     |   7.2857407425367d-01, 1.1989930325939d+00, 7.3449933889024d-01,
     |  -3.2148067693958d-01,-1.2726906961968d+00,-1.6332806639281d+00,
     |  -1.3955822249156d+00,-8.8030872000877d-01,-4.1566929150546d-01,
     |  -1.4278224092501d-01,-3.3201887456960d-02,-4.5267967897558d-03,
     |  -2.6690685640987d-04,-3.0619054032209d-06,-1.6587634479662d-10/
      data (pmn(lat,10,26), lat = 1,72)/
     |   4.4798647382005d-12, 2.4968714308358d-07, 3.6757866989137d-05,
     |   8.9098108779287d-04, 8.6508945686895d-03, 4.7307642565317d-02,
     |   1.7165451012135d-01, 4.5089849520226d-01, 8.9728678423005d-01,
     |   1.3735404965655d+00, 1.5856916966205d+00, 1.2494051363086d+00,
     |   3.6251758043355d-01,-6.5497560689415d-01,-1.1680912720367d+00,
     |  -8.1028168401060d-01, 1.4722208204258d-01, 9.3191121289605d-01,
     |   8.8899293690222d-01, 7.0230786571149d-02,-7.7734220105586d-01,
     |  -8.7629248972128d-01,-1.4836809927587d-01, 6.9834568026418d-01,
     |   8.4408142086616d-01, 1.5801793896128d-01,-6.6884583258764d-01,
     |  -8.0964465676639d-01,-1.3166053296956d-01, 6.6921493299356d-01,
     |   7.7609650346122d-01, 8.5641740166078d-02,-6.8663398496388d-01,
     |  -7.4365863850338d-01,-2.9583054796162d-02, 7.1304136284660d-01,
     |   7.1304136284660d-01,-2.9583054796159d-02,-7.4365863850338d-01,
     |  -6.8663398496388d-01, 8.5641740166075d-02, 7.7609650346122d-01,
     |   6.6921493299356d-01,-1.3166053296956d-01,-8.0964465676639d-01,
     |  -6.6884583258764d-01, 1.5801793896127d-01, 8.4408142086615d-01,
     |   6.9834568026418d-01,-1.4836809927587d-01,-8.7629248972128d-01,
     |  -7.7734220105587d-01, 7.0230786571146d-02, 8.8899293690222d-01,
     |   9.3191121289606d-01, 1.4722208204258d-01,-8.1028168401060d-01,
     |  -1.1680912720367d+00,-6.5497560689415d-01, 3.6251758043354d-01,
     |   1.2494051363086d+00, 1.5856916966205d+00, 1.3735404965655d+00,
     |   8.9728678423006d-01, 4.5089849520226d-01, 1.7165451012135d-01,
     |   4.7307642565317d-02, 8.6508945686895d-03, 8.9098108779287d-04,
     |   3.6757866989137d-05, 2.4968714308358d-07, 4.4798647382005d-12/
      data (pmn(lat,11,26), lat = 1,72)/
     |   1.0816399965233d-13, 1.8184032232486d-08, 4.5112226413435d-06,
     |   1.5573408117457d-04, 1.9912968892412d-03, 1.3742522283796d-02,
     |   6.1456801895964d-02, 1.9680398638071d-01, 4.7768531004741d-01,
     |   9.0530546036410d-01, 1.3490853992929d+00, 1.5451163811866d+00,
     |   1.2378717585785d+00, 4.1332552860777d-01,-5.6872113633402d-01,
     |  -1.1303034770486d+00,-8.8712160394135d-01,-8.4539739001052d-03,
     |   8.3105877801079d-01, 9.5719962003844d-01, 2.7300634557281d-01,
     |  -6.2109054006756d-01,-9.3159838728002d-01,-3.8666807250603d-01,
     |   4.9966269196965d-01, 8.9408276028922d-01, 4.2957642799526d-01,
     |  -4.3804510618796d-01,-8.6467276306235d-01,-4.3860292753459d-01,
     |   4.1366459963055d-01, 8.4615942424846d-01, 4.3190992366422d-01,
     |  -4.1122692000320d-01,-8.3744506621064d-01,-4.2008553047455d-01,
     |   4.2008553047455d-01, 8.3744506621064d-01, 4.1122692000320d-01,
     |  -4.3190992366422d-01,-8.4615942424846d-01,-4.1366459963055d-01,
     |   4.3860292753459d-01, 8.6467276306235d-01, 4.3804510618796d-01,
     |  -4.2957642799526d-01,-8.9408276028922d-01,-4.9966269196966d-01,
     |   3.8666807250603d-01, 9.3159838728002d-01, 6.2109054006756d-01,
     |  -2.7300634557280d-01,-9.5719962003844d-01,-8.3105877801080d-01,
     |   8.4539739001027d-03, 8.8712160394135d-01, 1.1303034770486d+00,
     |   5.6872113633401d-01,-4.1332552860777d-01,-1.2378717585785d+00,
     |  -1.5451163811866d+00,-1.3490853992929d+00,-9.0530546036410d-01,
     |  -4.7768531004741d-01,-1.9680398638071d-01,-6.1456801895964d-02,
     |  -1.3742522283796d-02,-1.9912968892412d-03,-1.5573408117457d-04,
     |  -4.5112226413435d-06,-1.8184032232486d-08,-1.0816399965233d-13/
      data (pmn(lat,12,26), lat = 1,72)/
     |   2.3488011039770d-15, 1.1901080309438d-09, 4.9673784764031d-07,
     |   2.4358327160834d-05, 4.0859246822845d-04, 3.5392546922730d-03,
     |   1.9356817658255d-02, 7.4724156234945d-02, 2.1747382855312d-01,
     |   4.9611180515361d-01, 9.0486250884851d-01, 1.3219413376725d+00,
     |   1.5103225263299d+00, 1.2375089994423d+00, 4.7568637491510d-01,
     |  -4.7197432278883d-01,-1.0821748661309d+00,-9.5786290546937d-01,
     |  -1.7288974902679d-01, 7.0195412473282d-01, 9.9410739335843d-01,
     |   4.7339970829886d-01,-4.2239236320373d-01,-9.2790694048784d-01,
     |  -6.0761678370279d-01, 2.4525319299289d-01, 8.5580736614598d-01,
     |   6.6815086922889d-01,-1.3629220166101d-01,-7.9981017336699d-01,
     |  -6.9765710488089d-01, 6.7816684929917d-02, 7.6101677184973d-01,
     |   7.1637374790098d-01,-2.0430533474345d-02,-7.3511808435970d-01,
     |  -7.3511808435970d-01,-2.0430533474348d-02, 7.1637374790097d-01,
     |   7.6101677184973d-01, 6.7816684929920d-02,-6.9765710488089d-01,
     |  -7.9981017336699d-01,-1.3629220166102d-01, 6.6815086922889d-01,
     |   8.5580736614598d-01, 2.4525319299290d-01,-6.0761678370279d-01,
     |  -9.2790694048784d-01,-4.2239236320373d-01, 4.7339970829886d-01,
     |   9.9410739335843d-01, 7.0195412473282d-01,-1.7288974902679d-01,
     |  -9.5786290546937d-01,-1.0821748661309d+00,-4.7197432278883d-01,
     |   4.7568637491510d-01, 1.2375089994423d+00, 1.5103225263299d+00,
     |   1.3219413376725d+00, 9.0486250884851d-01, 4.9611180515362d-01,
     |   2.1747382855312d-01, 7.4724156234945d-02, 1.9356817658255d-02,
     |   3.5392546922731d-03, 4.0859246822845d-04, 2.4358327160834d-05,
     |   4.9673784764031d-07, 1.1901080309438d-09, 2.3488011039770d-15/
      data (pmn(lat,13,26), lat = 1,72)/
     |   4.6075840830328d-17, 7.0319668753416d-11, 4.9317202018978d-08,
     |   3.4282202693111d-06, 7.5219689257468d-05, 8.1447474219373d-04,
     |   5.4173187639369d-03, 2.5014102669689d-02, 8.6320147948842d-02,
     |   2.3307261841716d-01, 5.0619763003575d-01, 8.9618321201512d-01,
     |   1.2916123554061d+00, 1.4799516907528d+00, 1.2474250459929d+00,
     |   5.5087066067323d-01,-3.6102218277335d-01,-1.0190802216457d+00,
     |  -1.0191193826321d+00,-3.4572761916886d-01, 5.4053959440070d-01,
     |   9.9111362164761d-01, 6.6196934792888d-01,-1.8325492499778d-01,
     |  -8.5291168881073d-01,-7.8929787437816d-01,-5.2145041563853d-02,
     |   7.1444133214970d-01, 8.3595320582707d-01, 2.0869662983716d-01,
     |  -5.9800124469110d-01,-8.5070112997049d-01,-3.2099380770377d-01,
     |   5.0074992159223d-01, 8.5427713788404d-01, 4.1274378239324d-01,
     |  -4.1274378239324d-01,-8.5427713788404d-01,-5.0074992159224d-01,
     |   3.2099380770377d-01, 8.5070112997049d-01, 5.9800124469110d-01,
     |  -2.0869662983716d-01,-8.3595320582706d-01,-7.1444133214971d-01,
     |   5.2145041563851d-02, 7.8929787437816d-01, 8.5291168881073d-01,
     |   1.8325492499778d-01,-6.6196934792888d-01,-9.9111362164761d-01,
     |  -5.4053959440071d-01, 3.4572761916886d-01, 1.0191193826321d+00,
     |   1.0190802216457d+00, 3.6102218277336d-01,-5.5087066067323d-01,
     |  -1.2474250459929d+00,-1.4799516907528d+00,-1.2916123554061d+00,
     |  -8.9618321201512d-01,-5.0619763003575d-01,-2.3307261841716d-01,
     |  -8.6320147948843d-02,-2.5014102669689d-02,-5.4173187639369d-03,
     |  -8.1447474219375d-04,-7.5219689257468d-05,-3.4282202693111d-06,
     |  -4.9317202018978d-08,-7.0319668753416d-11,-4.6075840830328d-17/
      data (pmn(lat,14,26), lat = 1,72)/
     |   8.1901971581937d-19, 3.7631043394640d-12, 4.4300283027606d-09,
     |   4.3584482125513d-07, 1.2480249739492d-05, 1.6839828481580d-04,
     |   1.3564403961138d-03, 7.4491060055584d-03, 3.0242535151421d-02,
     |   9.5585111425017d-02, 2.4314457698735d-01, 5.0791975366306d-01,
     |   8.7925620370569d-01, 1.2573099917080d+00, 1.4523162917674d+00,
     |   1.2662126760434d+00, 6.3952677348917d-01,-2.3225074453685d-01,
     |  -9.3518967822912d-01,-1.0649844060843d+00,-5.2401591228400d-01,
     |   3.4349174806516d-01, 9.3713867396235d-01, 8.2403209299181d-01,
     |   8.9107192783583d-02,-6.9511006724509d-01,-9.0310219848322d-01,
     |  -3.6787478286265d-01, 4.6320310658671d-01, 8.8891787108954d-01,
     |   5.4804396064108d-01,-2.6242618000491d-01,-8.3614127282345d-01,
     |  -6.7153625138341d-01, 8.4776090790704d-02, 7.6354041721793d-01,
     |   7.6354041721793d-01, 8.4776090790707d-02,-6.7153625138341d-01,
     |  -8.3614127282346d-01,-2.6242618000491d-01, 5.4804396064108d-01,
     |   8.8891787108954d-01, 4.6320310658671d-01,-3.6787478286265d-01,
     |  -9.0310219848322d-01,-6.9511006724509d-01, 8.9107192783577d-02,
     |   8.2403209299181d-01, 9.3713867396235d-01, 3.4349174806516d-01,
     |  -5.2401591228399d-01,-1.0649844060843d+00,-9.3518967822912d-01,
     |  -2.3225074453685d-01, 6.3952677348917d-01, 1.2662126760434d+00,
     |   1.4523162917674d+00, 1.2573099917080d+00, 8.7925620370570d-01,
     |   5.0791975366306d-01, 2.4314457698735d-01, 9.5585111425018d-02,
     |   3.0242535151421d-02, 7.4491060055584d-03, 1.3564403961138d-03,
     |   1.6839828481581d-04, 1.2480249739492d-05, 4.3584482125513d-07,
     |   4.4300283027606d-09, 3.7631043394640d-12, 8.1901971581937d-19/
      data (pmn(lat,15,26), lat = 1,72)/
     |   1.3216348580925d-20, 1.8274153633617d-13, 3.6081011364231d-10,
     |   5.0176544696604d-08, 1.8716787646455d-06, 3.1394061883982d-05,
     |   3.0524845848626d-04, 1.9851492121004d-03, 9.4277303803295d-03,
     |   3.4609231668651d-02, 1.0199118939021d-01, 2.4736005104552d-01,
     |   5.0123135558761d-01, 8.5385570119931d-01, 1.2178941165763d+00,
     |   1.4252208854094d+00, 1.2917006768986d+00, 7.4141860894426d-01,
     |  -8.2389362861540d-02,-8.2355134482817d-01,-1.0866057630845d+00,
     |  -7.0099530038294d-01, 1.0990025328862d-01, 8.1961020567557d-01,
     |   9.3855619945773d-01, 3.7872969342457d-01,-4.4801238759444d-01,
     |  -9.1507800336090d-01,-6.6092612133218d-01, 1.1251352497804d-01,
     |   7.8406849700992d-01, 8.0867934942557d-01, 1.6754556460179d-01,
     |  -6.0764058378492d-01,-8.7123528451928d-01,-4.0329482856746d-01,
     |   4.0329482856746d-01, 8.7123528451928d-01, 6.0764058378492d-01,
     |  -1.6754556460178d-01,-8.0867934942557d-01,-7.8406849700992d-01,
     |  -1.1251352497804d-01, 6.6092612133218d-01, 9.1507800336091d-01,
     |   4.4801238759445d-01,-3.7872969342457d-01,-9.3855619945773d-01,
     |  -8.1961020567557d-01,-1.0990025328862d-01, 7.0099530038294d-01,
     |   1.0866057630845d+00, 8.2355134482817d-01, 8.2389362861546d-02,
     |  -7.4141860894426d-01,-1.2917006768986d+00,-1.4252208854094d+00,
     |  -1.2178941165763d+00,-8.5385570119931d-01,-5.0123135558761d-01,
     |  -2.4736005104552d-01,-1.0199118939021d-01,-3.4609231668652d-02,
     |  -9.4277303803296d-03,-1.9851492121004d-03,-3.0524845848626d-04,
     |  -3.1394061883983d-05,-1.8716787646455d-06,-5.0176544696604d-08,
     |  -3.6081011364231d-10,-1.8274153633617d-13,-1.3216348580925d-20/
      data (pmn(lat,16,26), lat = 1,72)/
     |   1.9374054946675d-22, 8.0589170334256d-15, 2.6668964274361d-11,
     |   5.2368379707215d-09, 2.5409692650695d-07, 5.2876439050927d-06,
     |   6.1900325325310d-05, 4.7513621231762d-04, 2.6281141926031d-03,
     |   1.1141782154530d-02, 3.7746142082631d-02, 1.0515076044506d-01,
     |   2.4552059927826d-01, 4.8608849485038d-01, 8.1957077491240d-01,
     |   1.1718377071949d+00, 1.3958044709064d+00, 1.3206571855825d+00,
     |   8.5499359988070d-01, 9.0975418737029d-02,-6.7644176178140d-01,
     |  -1.0718594754239d+00,-8.6459435790853d-01,-1.5619878211951d-01,
     |   6.2671804432912d-01, 9.7800178883103d-01, 6.5682279073800d-01,
     |  -1.1704438926620d-01,-7.9114268912792d-01,-8.7155251143523d-01,
     |  -2.9777322609043d-01, 4.9532391414873d-01, 8.9885437632816d-01,
     |   6.0011442423874d-01,-1.6718651766948d-01,-8.0022309607207d-01,
     |  -8.0022309607207d-01,-1.6718651766949d-01, 6.0011442423874d-01,
     |   8.9885437632816d-01, 4.9532391414873d-01,-2.9777322609043d-01,
     |  -8.7155251143523d-01,-7.9114268912793d-01,-1.1704438926620d-01,
     |   6.5682279073799d-01, 9.7800178883103d-01, 6.2671804432912d-01,
     |  -1.5619878211950d-01,-8.6459435790853d-01,-1.0718594754239d+00,
     |  -6.7644176178141d-01, 9.0975418737027d-02, 8.5499359988070d-01,
     |   1.3206571855825d+00, 1.3958044709064d+00, 1.1718377071950d+00,
     |   8.1957077491240d-01, 4.8608849485038d-01, 2.4552059927826d-01,
     |   1.0515076044506d-01, 3.7746142082631d-02, 1.1141782154530d-02,
     |   2.6281141926032d-03, 4.7513621231762d-04, 6.1900325325310d-05,
     |   5.2876439050929d-06, 2.5409692650695d-07, 5.2368379707215d-09,
     |   2.6668964274361d-11, 8.0589170334256d-15, 1.9374054946675d-22/
      data (pmn(lat,17,26), lat = 1,72)/
     |   2.5786894306626d-24, 3.2260128511056d-16, 1.7882989821052d-12,
     |   4.9541272081057d-10, 3.1229963940396d-08, 8.0497732483129d-07,
     |   1.1322373363249d-05, 1.0230452238423d-04, 6.5683972967920d-04,
     |   3.2018415158924d-03, 1.2399129383827d-02, 3.9373299341936d-02,
     |   1.0483061974675d-01, 2.3757781052536d-01, 4.6249354353895d-01,
     |   7.7586036611401d-01, 1.1172343697803d+00, 1.3604194853673d+00,
     |   1.3484569393300d+00, 9.7676503224899d-01, 2.8851837792229d-01,
     |  -4.8620268300343d-01,-1.0054149322215d+00,-9.9582822235183d-01,
     |  -4.4226312966696d-01, 3.5170071680694d-01, 9.1037546758887d-01,
     |   8.7827710956141d-01, 2.7064684018903d-01,-5.0864499254516d-01,
     |  -9.2516270463401d-01,-6.8618669105019d-01, 3.9825833191077d-02,
     |   7.3126733816977d-01, 8.8616155645265d-01, 3.9108658323997d-01,
     |  -3.9108658323997d-01,-8.8616155645265d-01,-7.3126733816977d-01,
     |  -3.9825833191079d-02, 6.8618669105019d-01, 9.2516270463401d-01,
     |   5.0864499254516d-01,-2.7064684018903d-01,-8.7827710956141d-01,
     |  -9.1037546758887d-01,-3.5170071680694d-01, 4.4226312966695d-01,
     |   9.9582822235183d-01, 1.0054149322215d+00, 4.8620268300343d-01,
     |  -2.8851837792228d-01,-9.7676503224899d-01,-1.3484569393300d+00,
     |  -1.3604194853673d+00,-1.1172343697803d+00,-7.7586036611402d-01,
     |  -4.6249354353895d-01,-2.3757781052536d-01,-1.0483061974675d-01,
     |  -3.9373299341936d-02,-1.2399129383827d-02,-3.2018415158924d-03,
     |  -6.5683972967921d-04,-1.0230452238423d-04,-1.1322373363249d-05,
     |  -8.0497732483132d-07,-3.1229963940396d-08,-4.9541272081057d-10,
     |  -1.7882989821052d-12,-3.2260128511056d-16,-2.5786894306626d-24/
      data (pmn(lat,18,26), lat = 1,72)/
     |   3.1106764896996d-26, 1.1701250280396d-17, 1.0860415594822d-13,
     |   4.2415259747193d-11, 3.4702669968419d-09, 1.1064911817881d-07,
     |   1.8667493729657d-06, 1.9812589386979d-05, 1.4725428687269d-04,
     |   8.2253262440687d-04, 3.6251483581076d-03, 1.3048458740651d-02,
     |   3.9320295061247d-02, 1.0097139168493d-01, 2.2366680653631d-01,
     |   4.3056440448863d-01, 7.2215374517271d-01, 1.0518777378084d+00,
     |   1.3145865936813d+00, 1.3687555549093d+00, 1.1005189819523d+00,
     |   5.0782551843177d-01,-2.4686142448102d-01,-8.6969081480194d-01,
     |  -1.0676241966623d+00,-7.2278954522839d-01,-3.1373476943032d-05,
     |   7.0551423073042d-01, 9.8137618695508d-01, 6.5489151985250d-01,
     |  -7.6501602169307d-02,-7.4935367989018d-01,-9.2617392865193d-01,
     |  -4.8851302275239d-01, 2.7345293591588d-01, 8.4844888579126d-01,
     |   8.4844888579126d-01, 2.7345293591588d-01,-4.8851302275239d-01,
     |  -9.2617392865193d-01,-7.4935367989018d-01,-7.6501602169306d-02,
     |   6.5489151985250d-01, 9.8137618695508d-01, 7.0551423073042d-01,
     |  -3.1373476941225d-05,-7.2278954522838d-01,-1.0676241966623d+00,
     |  -8.6969081480195d-01,-2.4686142448102d-01, 5.0782551843177d-01,
     |   1.1005189819523d+00, 1.3687555549093d+00, 1.3145865936814d+00,
     |   1.0518777378084d+00, 7.2215374517272d-01, 4.3056440448864d-01,
     |   2.2366680653631d-01, 1.0097139168493d-01, 3.9320295061247d-02,
     |   1.3048458740651d-02, 3.6251483581076d-03, 8.2253262440688d-04,
     |   1.4725428687269d-04, 1.9812589386980d-05, 1.8667493729657d-06,
     |   1.1064911817881d-07, 3.4702669968419d-09, 4.2415259747193d-11,
     |   1.0860415594822d-13, 1.1701250280396d-17, 3.1106764896996d-26/
      data (pmn(lat,19,26), lat = 1,72)/
     |   3.3893982513156d-28, 3.8328780837407d-19, 5.9539609184027d-15,
     |   3.2761494443527d-12, 3.4759418373977d-10, 1.3694556854854d-08,
     |   2.7673014623272d-07, 3.4438222806460d-06, 2.9564668992773d-05,
     |   1.8871795675960d-04, 9.4336502468114d-04, 3.8322811571775d-03,
     |   1.2997977130068d-02, 3.7545641683805d-02, 9.3711142767558d-02,
     |   2.0415508134636d-01, 3.9063740717951d-01, 6.5801746495513d-01,
     |   9.7345393439855d-01, 1.2530953119898d+00, 1.3732671338006d+00,
     |   1.2164239636168d+00, 7.4152214277320d-01, 4.3114657908177d-02,
     |  -6.4747359605808d-01,-1.0451648528698d+00,-9.5483603806547d-01,
     |  -4.0058429220966d-01, 3.4821734711084d-01, 8.9564728990643d-01,
     |   9.3480046385676d-01, 4.3686533947363d-01,-3.1224271334023d-01,
     |  -8.6847043196975d-01,-8.9540748051153d-01,-3.7504870265174d-01,
     |   3.7504870265174d-01, 8.9540748051153d-01, 8.6847043196975d-01,
     |   3.1224271334023d-01,-4.3686533947362d-01,-9.3480046385676d-01,
     |  -8.9564728990643d-01,-3.4821734711085d-01, 4.0058429220965d-01,
     |   9.5483603806547d-01, 1.0451648528698d+00, 6.4747359605808d-01,
     |  -4.3114657908174d-02,-7.4152214277320d-01,-1.2164239636168d+00,
     |  -1.3732671338006d+00,-1.2530953119898d+00,-9.7345393439856d-01,
     |  -6.5801746495513d-01,-3.9063740717952d-01,-2.0415508134636d-01,
     |  -9.3711142767557d-02,-3.7545641683804d-02,-1.2997977130068d-02,
     |  -3.8322811571775d-03,-9.4336502468114d-04,-1.8871795675961d-04,
     |  -2.9564668992773d-05,-3.4438222806460d-06,-2.7673014623272d-07,
     |  -1.3694556854854d-08,-3.4759418373977d-10,-3.2761494443527d-12,
     |  -5.9539609184027d-15,-3.8328780837407d-19,-3.3893982513156d-28/
      data (pmn(lat,20,26), lat = 1,72)/
     |   3.3180394774722d-30, 1.1278096139067d-20, 2.9311314692422d-16,
     |   2.2711592276695d-13, 3.1225633379693d-11, 1.5186895476626d-09,
     |   3.6714020722699d-08, 5.3493872452807d-07, 5.2948294100539d-06,
     |   3.8536884122421d-05, 2.1789228389460d-04, 9.9559403828103d-04,
     |   3.7844754754751d-03, 1.2230108091612d-02, 3.4152453976910d-02,
     |   8.3410575992948d-02, 1.7970475695124d-01, 3.4340796430070d-01,
     |   5.8340847435005d-01, 8.7989899212028d-01, 1.1703583426982d+00,
     |   1.3518236660662d+00, 1.3102556985829d+00, 9.7498066016112d-01,
     |   3.7663815687268d-01,-3.2722968386539d-01,-8.8967490456859d-01,
     |  -1.0758691899156d+00,-7.8735371120882d-01,-1.3962675620039d-01,
     |   5.6529165805093d-01, 9.7635740953864d-01, 8.7752829322661d-01,
     |   3.1511795990181d-01,-4.1341978021799d-01,-9.1444685988115d-01,
     |  -9.1444685988115d-01,-4.1341978021800d-01, 3.1511795990181d-01,
     |   8.7752829322661d-01, 9.7635740953864d-01, 5.6529165805093d-01,
     |  -1.3962675620039d-01,-7.8735371120882d-01,-1.0758691899156d+00,
     |  -8.8967490456859d-01,-3.2722968386539d-01, 3.7663815687268d-01,
     |   9.7498066016112d-01, 1.3102556985829d+00, 1.3518236660662d+00,
     |   1.1703583426982d+00, 8.7989899212029d-01, 5.8340847435005d-01,
     |   3.4340796430070d-01, 1.7970475695124d-01, 8.3410575992948d-02,
     |   3.4152453976910d-02, 1.2230108091612d-02, 3.7844754754752d-03,
     |   9.9559403828103d-04, 2.1789228389460d-04, 3.8536884122422d-05,
     |   5.2948294100540d-06, 5.3493872452807d-07, 3.6714020722699d-08,
     |   1.5186895476627d-09, 3.1225633379693d-11, 2.2711592276695d-13,
     |   2.9311314692422d-16, 1.1278096139067d-20, 3.3180394774722d-30/
      data (pmn(lat,21,26), lat = 1,72)/
     |   2.8949426176232d-32, 2.9572150416251d-22, 1.2855030990715d-17,
     |   1.4019880074441d-14, 2.4962858489361d-12, 1.4975654106146d-10,
     |   4.3267813584626d-09, 7.3719755097337d-08, 8.4001388511873d-07,
     |   6.9581134301542d-06, 4.4399451088121d-05, 2.2755541759861d-04,
     |   9.6615741271954d-04, 3.4784767288506d-03, 1.0810339265826d-02,
     |   2.9397322523525d-02, 7.0674247549416d-02, 1.5134080722436d-01,
     |   2.9010421901743d-01, 4.9902392897184d-01, 7.6997490332975d-01,
     |   1.0611642012881d+00, 1.2930055543817d+00, 1.3631777206535d+00,
     |   1.1840588332104d+00, 7.3245076091442d-01, 8.7850873789405d-02,
     |  -5.6852020499986d-01,-1.0087241915790d+00,-1.0540027217942d+00,
     |  -6.6941295167309d-01,-4.2211816541133d-03, 6.5537251766721d-01,
     |   1.0102263894723d+00, 8.9226243353793d-01, 3.5323809297459d-01,
     |  -3.5323809297459d-01,-8.9226243353793d-01,-1.0102263894723d+00,
     |  -6.5537251766721d-01, 4.2211816541112d-03, 6.6941295167309d-01,
     |   1.0540027217942d+00, 1.0087241915790d+00, 5.6852020499986d-01,
     |  -8.7850873789403d-02,-7.3245076091442d-01,-1.1840588332104d+00,
     |  -1.3631777206535d+00,-1.2930055543817d+00,-1.0611642012881d+00,
     |  -7.6997490332976d-01,-4.9902392897185d-01,-2.9010421901744d-01,
     |  -1.5134080722436d-01,-7.0674247549416d-02,-2.9397322523526d-02,
     |  -1.0810339265826d-02,-3.4784767288506d-03,-9.6615741271955d-04,
     |  -2.2755541759861d-04,-4.4399451088121d-05,-6.9581134301543d-06,
     |  -8.4001388511874d-07,-7.3719755097338d-08,-4.3267813584626d-09,
     |  -1.4975654106147d-10,-2.4962858489361d-12,-1.4019880074441d-14,
     |  -1.2855030990715d-17,-2.9572150416251d-22,-2.8949426176232d-32/
      data (pmn(lat,22,26), lat = 1,72)/
     |   2.2241763577609d-34, 6.8272529660540d-24, 4.9626764686979d-19,
     |   7.6151148671690d-16, 1.7550146717454d-13, 1.2977943060589d-11,
     |   4.4773967118401d-10, 8.9110789451121d-09, 1.1674225849562d-07,
     |   1.0988510556397d-06, 7.8982982514807d-06, 4.5303628135664d-05,
     |   2.1426193304147d-04, 8.5655609073062d-04, 2.9503970205353d-03,
     |   8.8876601356807d-03, 2.3687320531566d-02, 5.6357830981055d-02,
     |   1.2050848341897d-01, 2.3267188541294d-01, 4.0673357526449d-01,
     |   6.4409567437308d-01, 9.2198500051277d-01, 1.1857490646751d+00,
     |   1.3528486047665d+00, 1.3339664914769d+00, 1.0691825750140d+00,
     |   5.6683231662074d-01,-7.4848189296060d-02,-6.8153189390668d-01,
     |  -1.0568495030688d+00,-1.0606225644862d+00,-6.7774651405446d-01,
     |  -4.1630923843654d-02, 6.0668614900156d-01, 1.0121329838957d+00,
     |   1.0121329838957d+00, 6.0668614900156d-01,-4.1630923843652d-02,
     |  -6.7774651405446d-01,-1.0606225644862d+00,-1.0568495030688d+00,
     |  -6.8153189390668d-01,-7.4848189296066d-02, 5.6683231662074d-01,
     |   1.0691825750140d+00, 1.3339664914769d+00, 1.3528486047665d+00,
     |   1.1857490646751d+00, 9.2198500051277d-01, 6.4409567437308d-01,
     |   4.0673357526449d-01, 2.3267188541294d-01, 1.2050848341897d-01,
     |   5.6357830981055d-02, 2.3687320531566d-02, 8.8876601356808d-03,
     |   2.9503970205353d-03, 8.5655609073061d-04, 2.1426193304147d-04,
     |   4.5303628135664d-05, 7.8982982514807d-06, 1.0988510556397d-06,
     |   1.1674225849562d-07, 8.9110789451122d-09, 4.4773967118401d-10,
     |   1.2977943060589d-11, 1.7550146717454d-13, 7.6151148671690d-16,
     |   4.9626764686979d-19, 6.8272529660540d-24, 2.2241763577609d-34/
      data (pmn(lat,23,26), lat = 1,72)/
     |   1.4770995401058d-36, 1.3622987847119d-25, 1.6554845094887d-20,
     |   3.5729507198071d-17, 1.0653287164564d-14, 9.7046976922164d-13,
     |   3.9950083148675d-11, 9.2792253854756d-10, 1.3961322580105d-08,
     |   1.4913185069869d-07, 1.2055641533985d-06, 7.7243902847679d-06,
     |   4.0602441676679d-05, 1.7974632993193d-04, 6.8397371746256d-04,
     |   2.2732584835010d-03, 6.6834721683871d-03, 1.7558090063893d-02,
     |   4.1545922175967d-02, 8.9089734832361d-02, 1.7392008294705d-01,
     |   3.1002973936533d-01, 5.0536243468493d-01, 7.5293358373812d-01,
     |   1.0223827481282d+00, 1.2569898892346d+00, 1.3813492988109d+00,
     |   1.3218824694329d+00, 1.0363683120085d+00, 5.4200063998643d-01,
     |  -7.2022427384544d-02,-6.5838052312370d-01,-1.0530610482133d+00,
     |  -1.1322121676515d+00,-8.6237432114722d-01,-3.2147206523963d-01,
     |   3.2147206523963d-01, 8.6237432114722d-01, 1.1322121676515d+00,
     |   1.0530610482133d+00, 6.5838052312370d-01, 7.2022427384543d-02,
     |  -5.4200063998643d-01,-1.0363683120085d+00,-1.3218824694329d+00,
     |  -1.3813492988109d+00,-1.2569898892346d+00,-1.0223827481282d+00,
     |  -7.5293358373812d-01,-5.0536243468493d-01,-3.1002973936533d-01,
     |  -1.7392008294705d-01,-8.9089734832362d-02,-4.1545922175967d-02,
     |  -1.7558090063893d-02,-6.6834721683872d-03,-2.2732584835010d-03,
     |  -6.8397371746256d-04,-1.7974632993193d-04,-4.0602441676679d-05,
     |  -7.7243902847679d-06,-1.2055641533985d-06,-1.4913185069869d-07,
     |  -1.3961322580105d-08,-9.2792253854757d-10,-3.9950083148675d-11,
     |  -9.7046976922168d-13,-1.0653287164564d-14,-3.5729507198071d-17,
     |  -1.6554845094887d-20,-1.3622987847119d-25,-1.4770995401058d-36/
      data (pmn(lat,24,26), lat = 1,72)/
     |   8.2239267676188d-39, 2.2786910697844d-27, 4.6284519848680d-22,
     |   1.4045889887750d-18, 5.4160329603469d-16, 6.0747097719799d-14,
     |   2.9819107649527d-12, 8.0767080384568d-11, 1.3942926742309d-09,
     |   1.6882634037387d-08, 1.5328652618958d-07, 1.0953794417493d-06,
     |   6.3872549885262d-06, 3.1242981753817d-05, 1.3098845100070d-04,
     |   4.7880510995119d-04, 1.5468792669381d-03, 4.4658846973768d-03,
     |   1.1624737015614d-02, 2.7479619390433d-02, 5.9332246748718d-02,
     |   1.1753698705082d-01, 2.1434175265849d-01, 3.6060682244220d-01,
     |   5.6023464966997d-01, 8.0334237877245d-01, 1.0606799192079d+00,
     |   1.2827764328223d+00, 1.4068773314914d+00, 1.3724058606190d+00,
     |   1.1418867455699d+00, 7.2052186527515d-01, 1.6596907319116d-01,
     |  -4.1813177079380d-01,-9.0579387680633d-01,-1.1833101899214d+00,
     |  -1.1833101899214d+00,-9.0579387680633d-01,-4.1813177079380d-01,
     |   1.6596907319116d-01, 7.2052186527515d-01, 1.1418867455699d+00,
     |   1.3724058606190d+00, 1.4068773314914d+00, 1.2827764328223d+00,
     |   1.0606799192079d+00, 8.0334237877245d-01, 5.6023464966997d-01,
     |   3.6060682244220d-01, 2.1434175265849d-01, 1.1753698705082d-01,
     |   5.9332246748719d-02, 2.7479619390434d-02, 1.1624737015614d-02,
     |   4.4658846973768d-03, 1.5468792669381d-03, 4.7880510995120d-04,
     |   1.3098845100070d-04, 3.1242981753816d-05, 6.3872549885263d-06,
     |   1.0953794417493d-06, 1.5328652618958d-07, 1.6882634037388d-08,
     |   1.3942926742310d-09, 8.0767080384569d-11, 2.9819107649527d-12,
     |   6.0747097719801d-14, 5.4160329603469d-16, 1.4045889887750d-18,
     |   4.6284519848680d-22, 2.2786910697844d-27, 8.2239267676188d-39/
      data (pmn(lat,25,26), lat = 1,72)/
     |   3.6246805936301d-41, 3.0170480719774d-29, 1.0241293064730d-23,
     |   4.3688317108641d-20, 2.1777948653888d-17, 3.0061262861738d-15,
     |   1.7585804190268d-13, 5.5506999354846d-12, 1.0985346183656d-10,
     |   1.5063236393107d-09, 1.5343575313165d-08, 1.2212021052616d-07,
     |   7.8869803760833d-07, 4.2547151187978d-06, 1.9610947030613d-05,
     |   7.8634135913408d-05, 2.7829573997812d-04, 8.7966145505927d-04,
     |   2.5075641902019d-03, 6.4982446308491d-03, 1.5410904062292d-02,
     |   3.3630116253621d-02, 6.7834152246671d-02, 1.2692908725673d-01,
     |   2.2094864242134d-01, 3.5853069650114d-01, 5.4300595815475d-01,
     |   7.6784426311714d-01, 1.0129720617293d+00, 1.2439052052304d+00,
     |   1.4153318112278d+00, 1.4795651728465d+00, 1.3984324261279d+00,
     |   1.1553687486895d+00, 7.6361957224098d-01, 2.6712759477581d-01,
     |  -2.6712759477581d-01,-7.6361957224098d-01,-1.1553687486895d+00,
     |  -1.3984324261279d+00,-1.4795651728465d+00,-1.4153318112278d+00,
     |  -1.2439052052304d+00,-1.0129720617293d+00,-7.6784426311714d-01,
     |  -5.4300595815475d-01,-3.5853069650114d-01,-2.2094864242134d-01,
     |  -1.2692908725673d-01,-6.7834152246671d-02,-3.3630116253621d-02,
     |  -1.5410904062293d-02,-6.4982446308492d-03,-2.5075641902019d-03,
     |  -8.7966145505927d-04,-2.7829573997812d-04,-7.8634135913409d-05,
     |  -1.9610947030613d-05,-4.2547151187978d-06,-7.8869803760835d-07,
     |  -1.2212021052616d-07,-1.5343575313165d-08,-1.5063236393108d-09,
     |  -1.0985346183656d-10,-5.5506999354847d-12,-1.7585804190268d-13,
     |  -3.0061262861740d-15,-2.1777948653888d-17,-4.3688317108641d-20,
     |  -1.0241293064730d-23,-3.0170480719774d-29,-3.6246805936301d-41/
      data (pmn(lat,26,26), lat = 1,72)/
     |   1.0967922221315d-43, 2.7422682831212d-31, 1.5553849045062d-25,
     |   9.3248918509480d-22, 6.0072690588210d-19, 1.0200859260862d-16,
     |   7.1081980145312d-15, 2.6129273844961d-13, 5.9241530164018d-12,
     |   9.1913581806258d-11, 1.0493005655121d-09, 9.2908735173697d-09,
     |   6.6369007309879d-08, 3.9424064943399d-07, 1.9940558581876d-06,
     |   8.7518608787866d-06, 3.3844867964130d-05, 1.1677723911993d-04,
     |   3.6325037785140d-04, 1.0275582424272d-03, 2.6627812279155d-03,
     |   6.3604269908097d-03, 1.4078427319666d-02, 2.9007029176281d-02,
     |   5.5849461545243d-02, 1.0082068959985d-01, 1.7113539926500d-01,
     |   2.7381502801142d-01, 4.1382291335314d-01, 5.9181593848824d-01,
     |   8.0209422570481d-01, 1.0315033480793d+00, 1.2599684030213d+00,
     |   1.4629658449171d+00, 1.6156452084228d+00, 1.6976993827110d+00,
     |   1.6976993827110d+00, 1.6156452084228d+00, 1.4629658449171d+00,
     |   1.2599684030213d+00, 1.0315033480793d+00, 8.0209422570481d-01,
     |   5.9181593848824d-01, 4.1382291335314d-01, 2.7381502801142d-01,
     |   1.7113539926500d-01, 1.0082068959985d-01, 5.5849461545243d-02,
     |   2.9007029176281d-02, 1.4078427319666d-02, 6.3604269908097d-03,
     |   2.6627812279156d-03, 1.0275582424272d-03, 3.6325037785140d-04,
     |   1.1677723911993d-04, 3.3844867964131d-05, 8.7518608787867d-06,
     |   1.9940558581875d-06, 3.9424064943399d-07, 6.6369007309880d-08,
     |   9.2908735173697d-09, 1.0493005655121d-09, 9.1913581806260d-11,
     |   5.9241530164020d-12, 2.6129273844961d-13, 7.1081980145312d-15,
     |   1.0200859260863d-16, 6.0072690588210d-19, 9.3248918509480d-22,
     |   1.5553849045062d-25, 2.7422682831212d-31, 1.0967922221315d-43/
      data (pmn(lat, 0,27), lat = 1,72)/
     |   4.7827986109913d+00, 1.7836320291412d+00,-1.3649884189173d+00,
     |  -1.9785770803436d+00,-2.1696634331936d-01, 1.4439505184685d+00,
     |   1.1373616759130d+00,-4.7778461832019d-01,-1.3241694469002d+00,
     |  -4.8016768415532d-01, 8.6771419234391d-01, 1.0410133591189d+00,
     |  -7.6227412608494d-02,-1.0219618302086d+00,-6.4548230824094d-01,
     |   5.0872989264262d-01, 9.7012214924578d-01, 2.0185566174528d-01,
     |  -7.8384608859853d-01,-7.4999177208187d-01, 2.2108723956200d-01,
     |   8.8163117799065d-01, 4.1477044568858d-01,-5.5999326829315d-01,
     |  -8.0449101447512d-01,-2.9448854350634d-02, 7.6623829789559d-01,
     |   5.7898469778135d-01,-3.3721136113588d-01,-8.1309068825156d-01,
     |  -2.5268263399100d-01, 6.2227002109164d-01, 6.9959657053616d-01,
     |  -1.1270068727074d-01,-7.7775606402736d-01,-4.5057280783607d-01,
     |   4.5057280783607d-01, 7.7775606402736d-01, 1.1270068727074d-01,
     |  -6.9959657053615d-01,-6.2227002109164d-01, 2.5268263399100d-01,
     |   8.1309068825157d-01, 3.3721136113589d-01,-5.7898469778134d-01,
     |  -7.6623829789559d-01, 2.9448854350630d-02, 8.0449101447512d-01,
     |   5.5999326829315d-01,-4.1477044568858d-01,-8.8163117799065d-01,
     |  -2.2108723956201d-01, 7.4999177208187d-01, 7.8384608859853d-01,
     |  -2.0185566174528d-01,-9.7012214924578d-01,-5.0872989264262d-01,
     |   6.4548230824095d-01, 1.0219618302086d+00, 7.6227412608508d-02,
     |  -1.0410133591189d+00,-8.6771419234391d-01, 4.8016768415531d-01,
     |   1.3241694469002d+00, 4.7778461832020d-01,-1.1373616759130d+00,
     |  -1.4439505184685d+00, 2.1696634331936d-01, 1.9785770803436d+00,
     |   1.3649884189173d+00,-1.7836320291412d+00,-4.7827986109913d+00/
      data (pmn(lat, 1,27), lat = 1,72)/
     |   1.5032084146931d+00, 3.0505516221072d+00, 1.7811984329134d+00,
     |  -7.2668660086879d-01,-1.8169913605579d+00,-6.6098262962329d-01,
     |   1.0611864218145d+00, 1.2993323846361d+00,-3.1880255127388d-02,
     |  -1.1824352465580d+00,-7.9668063968746d-01, 5.2367737492942d-01,
     |   1.1033852865470d+00, 2.9003713842660d-01,-8.2858946900271d-01,
     |  -8.5954171054529d-01, 1.7520075579330d-01, 9.4215647859835d-01,
     |   5.0295229631349d-01,-5.4512748490922d-01,-8.7305648234001d-01,
     |  -9.7574137397743d-02, 7.7569845216275d-01, 6.5051041606915d-01,
     |  -2.8879061534196d-01,-8.4248385864019d-01,-3.2302612866261d-01,
     |   5.9397147217600d-01, 7.4548439231992d-01,-4.7634809615841d-02,
     |  -7.7043650896675d-01,-5.0954768724970d-01, 3.9524547663501d-01,
     |   7.9226235383777d-01, 1.8072487590862d-01,-6.5891769138712d-01,
     |  -6.5891769138712d-01, 1.8072487590862d-01, 7.9226235383777d-01,
     |   3.9524547663501d-01,-5.0954768724970d-01,-7.7043650896675d-01,
     |  -4.7634809615845d-02, 7.4548439231992d-01, 5.9397147217600d-01,
     |  -3.2302612866261d-01,-8.4248385864019d-01,-2.8879061534197d-01,
     |   6.5051041606915d-01, 7.7569845216275d-01,-9.7574137397743d-02,
     |  -8.7305648234000d-01,-5.4512748490922d-01, 5.0295229631349d-01,
     |   9.4215647859835d-01, 1.7520075579331d-01,-8.5954171054529d-01,
     |  -8.2858946900271d-01, 2.9003713842660d-01, 1.1033852865470d+00,
     |   5.2367737492942d-01,-7.9668063968746d-01,-1.1824352465580d+00,
     |  -3.1880255127400d-02, 1.2993323846361d+00, 1.0611864218145d+00,
     |  -6.6098262962327d-01,-1.8169913605579d+00,-7.2668660086879d-01,
     |   1.7811984329134d+00, 3.0505516221072d+00, 1.5032084146931d+00/
      data (pmn(lat, 2,27), lat = 1,72)/
     |   2.2859167574192d-01, 1.6039541827357d+00, 2.5513979351349d+00,
     |   1.6373159680210d+00,-4.4807347750881d-01,-1.6426090587402d+00,
     |  -8.7369138272775d-01, 7.5721180168597d-01, 1.3199534101044d+00,
     |   2.8507353847707d-01,-9.8653094562828d-01,-9.7286866566889d-01,
     |   2.0876725541224d-01, 1.0549322049559d+00, 5.6402958017521d-01,
     |  -5.8740877301816d-01,-9.5685694741017d-01,-1.3043906255253d-01,
     |   8.1995334174301d-01, 7.1616567128953d-01,-2.7241638129690d-01,
     |  -8.8801065650023d-01,-3.7756905537037d-01, 5.8948659598526d-01,
     |   7.9401747760921d-01,-7.7295061453470d-04,-7.7760635145457d-01,
     |  -5.6292827328979d-01, 3.5608994169245d-01, 8.1315707234099d-01,
     |   2.3928621189066d-01,-6.3047705366043d-01,-6.9609290867076d-01,
     |   1.1916978251970d-01, 7.7964965088151d-01, 4.5012278357727d-01,
     |  -4.5012278357727d-01,-7.7964965088151d-01,-1.1916978251971d-01,
     |   6.9609290867076d-01, 6.3047705366043d-01,-2.3928621189066d-01,
     |  -8.1315707234100d-01,-3.5608994169246d-01, 5.6292827328979d-01,
     |   7.7760635145457d-01, 7.7295061453846d-04,-7.9401747760921d-01,
     |  -5.8948659598526d-01, 3.7756905537037d-01, 8.8801065650023d-01,
     |   2.7241638129692d-01,-7.1616567128953d-01,-8.1995334174301d-01,
     |   1.3043906255253d-01, 9.5685694741017d-01, 5.8740877301817d-01,
     |  -5.6402958017521d-01,-1.0549322049559d+00,-2.0876725541225d-01,
     |   9.7286866566889d-01, 9.8653094562828d-01,-2.8507353847706d-01,
     |  -1.3199534101044d+00,-7.5721180168598d-01, 8.7369138272775d-01,
     |   1.6426090587402d+00, 4.4807347750881d-01,-1.6373159680210d+00,
     |  -2.5513979351349d+00,-1.6039541827357d+00,-2.2859167574192d-01/
      data (pmn(lat, 3,27), lat = 1,72)/
     |   2.2936503810505d-02, 5.1563208196944d-01, 1.6167512894474d+00,
     |   2.2823738430514d+00, 1.4928143843892d+00,-3.1772270733397d-01,
     |  -1.5018252903722d+00,-9.7698186662362d-01, 5.2772776679768d-01,
     |   1.2802129842369d+00, 5.0661248825699d-01,-7.8407982497097d-01,
     |  -1.0560737991754d+00,-6.0208469465626d-02, 9.4315069170462d-01,
     |   7.5493049696054d-01,-3.3503068138975d-01,-9.6456737131095d-01,
     |  -3.8964468788386d-01, 6.3831332352246d-01, 8.4344752107640d-01,
     |   2.7323587696461d-03,-8.1461260561632d-01,-5.9999602401325d-01,
     |   3.5318503676168d-01, 8.4467182025340d-01, 2.7391145214995d-01,
     |  -6.2752726350663d-01,-7.2981460119092d-01, 8.2379729492760d-02,
     |   7.8104048199143d-01, 4.9258741750978d-01,-4.1194670764124d-01,
     |  -7.9246599221506d-01,-1.7374239833534d-01, 6.6210702180004d-01,
     |   6.6210702180004d-01,-1.7374239833534d-01,-7.9246599221506d-01,
     |  -4.1194670764125d-01, 4.9258741750978d-01, 7.8104048199143d-01,
     |   8.2379729492763d-02,-7.2981460119092d-01,-6.2752726350663d-01,
     |   2.7391145214995d-01, 8.4467182025340d-01, 3.5318503676169d-01,
     |  -5.9999602401324d-01,-8.1461260561632d-01, 2.7323587696461d-03,
     |   8.4344752107639d-01, 6.3831332352246d-01,-3.8964468788385d-01,
     |  -9.6456737131095d-01,-3.3503068138975d-01, 7.5493049696054d-01,
     |   9.4315069170461d-01,-6.0208469465631d-02,-1.0560737991754d+00,
     |  -7.8407982497097d-01, 5.0661248825699d-01, 1.2802129842369d+00,
     |   5.2772776679769d-01,-9.7698186662361d-01,-1.5018252903722d+00,
     |  -3.1772270733399d-01, 1.4928143843892d+00, 2.2823738430514d+00,
     |   1.6167512894474d+00, 5.1563208196944d-01, 2.2936503810505d-02/
      data (pmn(lat, 4,27), lat = 1,72)/
     |   1.7139258381669d-03, 1.2010609913940d-01, 6.8564102452165d-01,
     |   1.6180009300592d+00, 2.1007311341054d+00, 1.3636036438531d+00,
     |  -2.5619804436453d-01,-1.3933556061747d+00,-1.0267539799135d+00,
     |   3.5378512352192d-01, 1.2164786469143d+00, 6.6240402456331d-01,
     |  -5.9243459513965d-01,-1.0789986147984d+00,-2.8335209696508d-01,
     |   7.9668227346573d-01, 8.7667225763509d-01,-9.0678527957406d-02,
     |  -9.0530282812279d-01,-5.9591118708055d-01, 4.2241918061679d-01,
     |   8.9202485434409d-01, 2.5935693414912d-01,-6.7194714281664d-01,
     |  -7.5459034629255d-01, 9.2403974675779d-02, 8.0724729321070d-01,
     |   5.1151370279010d-01,-4.1201814784797d-01,-8.1114752129794d-01,
     |  -1.9820847740156d-01, 6.5456730181474d-01, 6.8494693242202d-01,
     |  -1.3874040670658d-01,-7.8529204198181d-01,-4.4875618403223d-01,
     |   4.4875618403223d-01, 7.8529204198181d-01, 1.3874040670658d-01,
     |  -6.8494693242202d-01,-6.5456730181474d-01, 1.9820847740156d-01,
     |   8.1114752129795d-01, 4.1201814784798d-01,-5.1151370279010d-01,
     |  -8.0724729321070d-01,-9.2403974675783d-02, 7.5459034629255d-01,
     |   6.7194714281664d-01,-2.5935693414912d-01,-8.9202485434409d-01,
     |  -4.2241918061680d-01, 5.9591118708055d-01, 9.0530282812279d-01,
     |   9.0678527957409d-02,-8.7667225763509d-01,-7.9668227346574d-01,
     |   2.8335209696509d-01, 1.0789986147984d+00, 5.9243459513966d-01,
     |  -6.6240402456331d-01,-1.2164786469143d+00,-3.5378512352193d-01,
     |   1.0267539799135d+00, 1.3933556061747d+00, 2.5619804436453d-01,
     |  -1.3636036438531d+00,-2.1007311341054d+00,-1.6180009300592d+00,
     |  -6.8564102452165d-01,-1.2010609913940d-01,-1.7139258381669d-03/
      data (pmn(lat, 5,27), lat = 1,72)/
     |   1.0175190824382d-04, 2.1937581084186d-02, 2.2061932843907d-01,
     |   8.0516977369475d-01, 1.6133895439754d+00, 1.9627113881487d+00,
     |   1.2507695399746d+00,-2.2813080529802d-01,-1.3091681716416d+00,
     |  -1.0500540304378d+00, 2.1805379077179d-01, 1.1443733615789d+00,
     |   7.7390206583238d-01,-4.1565421816837d-01,-1.0622186279865d+00,
     |  -4.6630709077626d-01, 6.3162820220044d-01, 9.4186282563654d-01,
     |   1.3619872291783d-01,-7.9587939934223d-01,-7.4804540828035d-01,
     |   1.9012451006316d-01, 8.7013030989318d-01, 4.8300987021233d-01,
     |  -4.7717609441370d-01,-8.3581257453663d-01,-1.7065410551235d-01,
     |   6.8958588442723d-01, 6.9252741310608d-01,-1.5254503182572d-01,
     |  -7.9957604956597d-01,-4.5686295053567d-01, 4.4526716685063d-01,
     |   7.9228060521326d-01, 1.5950619944324d-01,-6.6858317626829d-01,
     |  -6.6858317626829d-01, 1.5950619944324d-01, 7.9228060521326d-01,
     |   4.4526716685063d-01,-4.5686295053567d-01,-7.9957604956598d-01,
     |  -1.5254503182572d-01, 6.9252741310607d-01, 6.8958588442723d-01,
     |  -1.7065410551235d-01,-8.3581257453663d-01,-4.7717609441371d-01,
     |   4.8300987021233d-01, 8.7013030989318d-01, 1.9012451006316d-01,
     |  -7.4804540828035d-01,-7.9587939934223d-01, 1.3619872291782d-01,
     |   9.4186282563654d-01, 6.3162820220044d-01,-4.6630709077626d-01,
     |  -1.0622186279865d+00,-4.1565421816837d-01, 7.7390206583237d-01,
     |   1.1443733615789d+00, 2.1805379077179d-01,-1.0500540304378d+00,
     |  -1.3091681716416d+00,-2.2813080529803d-01, 1.2507695399746d+00,
     |   1.9627113881487d+00, 1.6133895439754d+00, 8.0516977369475d-01,
     |   2.2061932843907d-01, 2.1937581084186d-02, 1.0175190824382d-04/
      data (pmn(lat, 6,27), lat = 1,72)/
     |   4.9953613990432d-06, 3.2894159073119d-03, 5.7289570367038d-02,
     |   3.1240106745364d-01, 8.9514608456562d-01, 1.6038870865292d+00,
     |   1.8505686282318d+00, 1.1534971277197d+00,-2.1563179131550d-01,
     |  -1.2419003169505d+00,-1.0607235101298d+00, 1.0720604792279d-01,
     |   1.0698279691046d+00, 8.5553230436284d-01,-2.5235995983988d-01,
     |  -1.0177820725389d+00,-6.1538541493217d-01, 4.5645403446842d-01,
     |   9.5990563911199d-01, 3.4096118725774d-01,-6.4813662736060d-01,
     |  -8.4640919581437d-01,-4.5358329463500d-02, 7.8533776716948d-01,
     |   6.6261092190559d-01,-2.4601147658555d-01,-8.4065619954106d-01,
     |  -4.1549900465588d-01, 5.0209291689896d-01, 8.0021313012420d-01,
     |   1.2695449443256d-01,-6.9278705582270d-01,-6.6421301903467d-01,
     |   1.7189558749288d-01, 7.9456195452981d-01, 4.4642190761668d-01,
     |  -4.4642190761668d-01,-7.9456195452981d-01,-1.7189558749288d-01,
     |   6.6421301903466d-01, 6.9278705582270d-01,-1.2695449443257d-01,
     |  -8.0021313012420d-01,-5.0209291689897d-01, 4.1549900465588d-01,
     |   8.4065619954106d-01, 2.4601147658556d-01,-6.6261092190559d-01,
     |  -7.8533776716948d-01, 4.5358329463500d-02, 8.4640919581437d-01,
     |   6.4813662736061d-01,-3.4096118725774d-01,-9.5990563911199d-01,
     |  -4.5645403446843d-01, 6.1538541493216d-01, 1.0177820725389d+00,
     |   2.5235995983987d-01,-8.5553230436284d-01,-1.0698279691046d+00,
     |  -1.0720604792279d-01, 1.0607235101298d+00, 1.2419003169505d+00,
     |   2.1563179131551d-01,-1.1534971277197d+00,-1.8505686282318d+00,
     |  -1.6038870865292d+00,-8.9514608456562d-01,-3.1240106745364d-01,
     |  -5.7289570367038d-02,-3.2894159073119d-03,-4.9953613990432d-06/
      data (pmn(lat, 7,27), lat = 1,72)/
     |   2.0834911477648d-07, 4.1715790481592d-04, 1.2456051459384d-02,
     |   9.9608692429667d-02, 3.9409954477538d-01, 9.6443637835138d-01,
     |   1.5900338158944d+00, 1.7560850780844d+00, 1.0711057457950d+00,
     |  -2.0868163298540d-01,-1.1858389469335d+00,-1.0661930801847d+00,
     |   1.1374902718473d-02, 9.9414330961669d-01, 9.1654228350837d-01,
     |  -9.9293640503008d-02,-9.5204508477207d-01,-7.3561103116133d-01,
     |   2.7533351232009d-01, 9.3682382693819d-01, 5.2069626153421d-01,
     |  -4.7042578617255d-01,-8.9102260329092d-01,-2.7303654718649d-01,
     |   6.4442235768646d-01, 7.8832375527586d-01, 5.9653697475880d-03,
     |  -7.6791976034645d-01,-6.2178112960211d-01, 2.5856741806107d-01,
     |   8.2021837476026d-01, 3.9879995599629d-01,-4.9490462676226d-01,
     |  -7.9045630671283d-01,-1.3745320707016d-01, 6.7855266760075d-01,
     |   6.7855266760075d-01,-1.3745320707015d-01,-7.9045630671283d-01,
     |  -4.9490462676226d-01, 3.9879995599629d-01, 8.2021837476026d-01,
     |   2.5856741806107d-01,-6.2178112960211d-01,-7.6791976034646d-01,
     |   5.9653697475860d-03, 7.8832375527586d-01, 6.4442235768646d-01,
     |  -2.7303654718648d-01,-8.9102260329092d-01,-4.7042578617255d-01,
     |   5.2069626153420d-01, 9.3682382693820d-01, 2.7533351232010d-01,
     |  -7.3561103116133d-01,-9.5204508477207d-01,-9.9293640503013d-02,
     |   9.1654228350837d-01, 9.9414330961669d-01, 1.1374902718486d-02,
     |  -1.0661930801847d+00,-1.1858389469335d+00,-2.0868163298540d-01,
     |   1.0711057457950d+00, 1.7560850780844d+00, 1.5900338158944d+00,
     |   9.6443637835139d-01, 3.9409954477538d-01, 9.9608692429667d-02,
     |   1.2456051459384d-02, 4.1715790481592d-04, 2.0834911477648d-07/
      data (pmn(lat, 8,27), lat = 1,72)/
     |   7.5260792834511d-09, 4.5682388550232d-05, 2.3234836624085d-03,
     |   2.6939539719034d-02, 1.4433747677547d-01, 4.6570722186137d-01,
     |   1.0176160568068d+00, 1.5724567964360d+00, 1.6752392077346d+00,
     |   1.0033003429290d+00,-2.0113950961512d-01,-1.1366304907563d+00,
     |  -1.0705542267211d+00,-7.6754026441754d-02, 9.1631204260737d-01,
     |   9.6244445869167d-01, 4.7063619028319d-02,-8.6761054740399d-01,
     |  -8.2998665968141d-01, 9.0381355881372d-02, 8.7571935283323d-01,
     |   6.7231134333157d-01,-2.6922643373520d-01,-8.8082328033537d-01,
     |  -4.8212727364365d-01, 4.5417094438580d-01, 8.5041007097964d-01,
     |   2.6161451898857d-01,-6.1877475224131d-01,-7.6829595622746d-01,
     |  -2.2014037466452d-02, 7.4165613162478d-01, 6.3051524673732d-01,
     |  -2.1941406630749d-01,-8.0723543729608d-01,-4.4302938924031d-01,
     |   4.4302938924031d-01, 8.0723543729608d-01, 2.1941406630749d-01,
     |  -6.3051524673732d-01,-7.4165613162478d-01, 2.2014037466455d-02,
     |   7.6829595622746d-01, 6.1877475224132d-01,-2.6161451898856d-01,
     |  -8.5041007097963d-01,-4.5417094438581d-01, 4.8212727364364d-01,
     |   8.8082328033538d-01, 2.6922643373520d-01,-6.7231134333157d-01,
     |  -8.7571935283324d-01,-9.0381355881375d-02, 8.2998665968141d-01,
     |   8.6761054740400d-01,-4.7063619028312d-02,-9.6244445869168d-01,
     |  -9.1631204260737d-01, 7.6754026441759d-02, 1.0705542267211d+00,
     |   1.1366304907563d+00, 2.0113950961512d-01,-1.0033003429290d+00,
     |  -1.6752392077346d+00,-1.5724567964360d+00,-1.0176160568068d+00,
     |  -4.6570722186138d-01,-1.4433747677547d-01,-2.6939539719034d-02,
     |  -2.3234836624085d-03,-4.5682388550232d-05,-7.5260792834511d-09/
      data (pmn(lat, 9,27), lat = 1,72)/
     |   2.3881609644744d-10, 4.3855217903229d-06, 3.7827217860501d-04,
     |   6.3114453495944d-03, 4.5242391772395d-02, 1.8867246222212d-01,
     |   5.2735717880106d-01, 1.0574264249691d+00, 1.5518878288276d+00,
     |   1.6060620371263d+00, 9.5010309447554d-01,-1.8888728474158d-01,
     |  -1.0908126203824d+00,-1.0759784487255d+00,-1.6266945968552d-01,
     |   8.3407752563704d-01, 9.9594714184255d-01, 1.8970209903603d-01,
     |  -7.6461472950476d-01,-8.9922676343192d-01,-9.6771486278006d-02,
     |   7.7747621689633d-01, 7.9133059548440d-01,-5.0780368726953d-02,
     |  -8.1373295300777d-01,-6.6046988519425d-01, 2.2288508390602d-01,
     |   8.3908912814889d-01, 5.0051060138290d-01,-3.9857375995667d-01,
     |  -8.3305162982553d-01,-3.1318542976182d-01, 5.6002961198855d-01,
     |   7.8494716172748d-01, 1.0668313146728d-01,-6.9235707244897d-01,
     |  -6.9235707244898d-01, 1.0668313146728d-01, 7.8494716172748d-01,
     |   5.6002961198856d-01,-3.1318542976182d-01,-8.3305162982553d-01,
     |  -3.9857375995668d-01, 5.0051060138290d-01, 8.3908912814889d-01,
     |   2.2288508390602d-01,-6.6046988519425d-01,-8.1373295300777d-01,
     |  -5.0780368726957d-02, 7.9133059548440d-01, 7.7747621689633d-01,
     |  -9.6771486277992d-02,-8.9922676343192d-01,-7.6461472950477d-01,
     |   1.8970209903602d-01, 9.9594714184255d-01, 8.3407752563705d-01,
     |  -1.6266945968552d-01,-1.0759784487255d+00,-1.0908126203824d+00,
     |  -1.8888728474158d-01, 9.5010309447554d-01, 1.6060620371263d+00,
     |   1.5518878288276d+00, 1.0574264249691d+00, 5.2735717880106d-01,
     |   1.8867246222212d-01, 4.5242391772395d-02, 6.3114453495944d-03,
     |   3.7827217860501d-04, 4.3855217903229d-06, 2.3881609644744d-10/
      data (pmn(lat,10,27), lat = 1,72)/
     |   6.7286953453490d-12, 3.7326714930086d-07, 5.4428385671345d-05,
     |   1.3000265054135d-03, 1.2367380201408d-02, 6.5831368584461d-02,
     |   2.3067158246652d-01, 5.7915808707255d-01, 1.0857111854417d+00,
     |   1.5290926329657d+00, 1.5476285887225d+00, 9.1174633699670d-01,
     |  -1.6887829324841d-01,-1.0453879518033d+00,-1.0833515124009d+00,
     |  -2.5050923446543d-01, 7.4441142803081d-01, 1.0174744052126d+00,
     |   3.3059663061150d-01,-6.4163240292929d-01,-9.4164636259487d-01,
     |  -2.8372090625365d-01, 6.4163614609153d-01, 8.7115441400566d-01,
     |   1.7722103829439d-01,-6.8744397976748d-01,-7.9342180206832d-01,
     |  -3.7533921869743d-02, 7.4558398572945d-01, 6.9757963538210d-01,
     |  -1.1987046064461d-01,-7.9506258790272d-01,-5.7885786948444d-01,
     |   2.8231920799276d-01, 8.2294838442359d-01, 4.3843924124857d-01,
     |  -4.3843924124857d-01,-8.2294838442359d-01,-2.8231920799276d-01,
     |   5.7885786948443d-01, 7.9506258790272d-01, 1.1987046064460d-01,
     |  -6.9757963538210d-01,-7.4558398572945d-01, 3.7533921869740d-02,
     |   7.9342180206832d-01, 6.8744397976748d-01,-1.7722103829438d-01,
     |  -8.7115441400566d-01,-6.4163614609153d-01, 2.8372090625365d-01,
     |   9.4164636259487d-01, 6.4163240292929d-01,-3.3059663061150d-01,
     |  -1.0174744052126d+00,-7.4441142803081d-01, 2.5050923446543d-01,
     |   1.0833515124009d+00, 1.0453879518033d+00, 1.6887829324843d-01,
     |  -9.1174633699670d-01,-1.5476285887225d+00,-1.5290926329657d+00,
     |  -1.0857111854417d+00,-5.7915808707255d-01,-2.3067158246652d-01,
     |  -6.5831368584462d-02,-1.2367380201408d-02,-1.3000265054135d-03,
     |  -5.4428385671345d-05,-3.7326714930086d-07,-6.7286953453490d-12/
      data (pmn(lat,11,27), lat = 1,72)/
     |   1.6971697610938d-13, 2.8409428374740d-08, 6.9867868469161d-06,
     |   2.3798839649359d-04, 2.9874679272121d-03, 2.0126519944271d-02,
     |   8.7284652318469d-02, 2.6887682808623d-01, 6.2119030236893d-01,
     |   1.1038069688905d+00, 1.5047812933109d+00, 1.4995159431833d+00,
     |   8.8857600029022d-01,-1.3860754640707d-01,-9.9746479170574d-01,
     |  -1.0925007940009d+00,-3.4330464455488d-01, 6.4374307129257d-01,
     |   1.0253934056259d+00, 4.7026061357865d-01,-4.9643451302930d-01,
     |  -9.5311851671335d-01,-4.6612571347676d-01, 4.6753342134859d-01,
     |   9.0274016152987d-01, 4.0385265955501d-01,-5.0102311002270d-01,
     |  -8.6346466874214d-01,-3.0904422340101d-01, 5.6469163110326d-01,
     |   8.2276773836405d-01, 1.9355172264385d-01,-6.3874044018338d-01,
     |  -7.7267560634028d-01,-6.5878042829701d-02, 7.1052097754484d-01,
     |   7.1052097754484d-01,-6.5878042829698d-02,-7.7267560634028d-01,
     |  -6.3874044018338d-01, 1.9355172264385d-01, 8.2276773836405d-01,
     |   5.6469163110327d-01,-3.0904422340100d-01,-8.6346466874214d-01,
     |  -5.0102311002271d-01, 4.0385265955501d-01, 9.0274016152987d-01,
     |   4.6753342134860d-01,-4.6612571347676d-01,-9.5311851671335d-01,
     |  -4.9643451302931d-01, 4.7026061357864d-01, 1.0253934056259d+00,
     |   6.4374307129258d-01,-3.4330464455487d-01,-1.0925007940009d+00,
     |  -9.9746479170574d-01,-1.3860754640707d-01, 8.8857600029021d-01,
     |   1.4995159431833d+00, 1.5047812933109d+00, 1.1038069688905d+00,
     |   6.2119030236894d-01, 2.6887682808623d-01, 8.7284652318469d-02,
     |   2.0126519944272d-02, 2.9874679272121d-03, 2.3798839649359d-04,
     |   6.9867868469161d-06, 2.8409428374740d-08, 1.6971697610938d-13/
      data (pmn(lat,12,27), lat = 1,72)/
     |   3.8562179459282d-15, 1.9461518953702d-09, 8.0580475127302d-07,
     |   3.9031915688765d-05, 6.4381326642819d-04, 5.4564310531650d-03,
     |   2.9033254254879d-02, 1.0831445144900d-01, 3.0214299919477d-01,
     |   6.5351496916124d-01, 1.1127038317871d+00, 1.4795128031183d+00,
     |   1.4614702302148d+00, 8.8096247355062d-01,-9.5801107634178d-02,
     |  -9.4395288946675d-01,-1.1021845681738d+00,-4.4301405408388d-01,
     |   5.2812646539292d-01, 1.0160545299671d+00, 6.0720215759836d-01,
     |  -3.2680627329373d-01,-9.2714920694319d-01,-6.3651681587351d-01,
     |   2.5586000271131d-01, 8.7485690942975d-01, 6.1313107306251d-01,
     |  -2.5753590900907d-01,-8.5100500026444d-01,-5.6481269311514d-01,
     |   2.9927755106085d-01, 8.4286369890807d-01, 5.0239024068362d-01,
     |  -3.6177965754387d-01,-8.4113259933479d-01,-4.3244707410360d-01,
     |   4.3244707410359d-01, 8.4113259933479d-01, 3.6177965754387d-01,
     |  -5.0239024068361d-01,-8.4286369890807d-01,-2.9927755106085d-01,
     |   5.6481269311514d-01, 8.5100500026444d-01, 2.5753590900908d-01,
     |  -6.1313107306251d-01,-8.7485690942975d-01,-2.5586000271132d-01,
     |   6.3651681587351d-01, 9.2714920694319d-01, 3.2680627329373d-01,
     |  -6.0720215759836d-01,-1.0160545299671d+00,-5.2812646539293d-01,
     |   4.4301405408387d-01, 1.1021845681738d+00, 9.4395288946676d-01,
     |   9.5801107634173d-02,-8.8096247355062d-01,-1.4614702302148d+00,
     |  -1.4795128031183d+00,-1.1127038317871d+00,-6.5351496916125d-01,
     |  -3.0214299919477d-01,-1.0831445144900d-01,-2.9033254254879d-02,
     |  -5.4564310531651d-03,-6.4381326642819d-04,-3.9031915688765d-05,
     |  -8.0580475127302d-07,-1.9461518953702d-09,-3.8562179459282d-15/
      data (pmn(lat,13,27), lat = 1,72)/
     |   7.9301838265079d-17, 1.2058299595762d-10, 8.3941415408597d-08,
     |   5.7692847991403d-06, 1.2464243800060d-04, 1.3229665852018d-03,
     |   8.5828516832015d-03, 3.8435638280776d-02, 1.2776937046506d-01,
     |   3.2955143787293d-01, 6.7617100019792d-01, 1.1130971840346d+00,
     |   1.4535949924790d+00, 1.4331678609196d+00, 8.8920205442872d-01,
     |  -3.8241478846008d-02,-8.8130468106129d-01,-1.1099201899776d+00,
     |  -5.5034370329783d-01, 3.9347931363499d-01, 9.8375101663474d-01,
     |   7.3721110291714d-01,-1.3162800459484d-01,-8.5523650134845d-01,
     |  -7.8308437756128d-01, 1.0864474861359d-02, 7.7527870561905d-01,
     |   7.8243784704743d-01, 3.2123739601315d-02,-7.3717645755076d-01,
     |  -7.6730860180920d-01,-3.3116127752863d-02, 7.2715296009851d-01,
     |   7.4915679562870d-01, 1.3165809142793d-02,-7.3383744809286d-01,
     |  -7.3383744809286d-01, 1.3165809142790d-02, 7.4915679562869d-01,
     |   7.2715296009851d-01,-3.3116127752860d-02,-7.6730860180920d-01,
     |  -7.3717645755077d-01, 3.2123739601308d-02, 7.8243784704743d-01,
     |   7.7527870561905d-01, 1.0864474861362d-02,-7.8308437756127d-01,
     |  -8.5523650134845d-01,-1.3162800459484d-01, 7.3721110291714d-01,
     |   9.8375101663474d-01, 3.9347931363499d-01,-5.5034370329783d-01,
     |  -1.1099201899776d+00,-8.8130468106129d-01,-3.8241478846012d-02,
     |   8.8920205442872d-01, 1.4331678609196d+00, 1.4535949924790d+00,
     |   1.1130971840346d+00, 6.7617100019792d-01, 3.2955143787293d-01,
     |   1.2776937046507d-01, 3.8435638280776d-02, 8.5828516832015d-03,
     |   1.3229665852018d-03, 1.2464243800060d-04, 5.7692847991403d-06,
     |   8.3941415408597d-08, 1.2058299595762d-10, 7.9301838265079d-17/
      data (pmn(lat,14,27), lat = 1,72)/
     |   1.4810574986317d-18, 6.7815753588207d-12, 7.9283047702817d-09,
     |   7.7184136119937d-07, 2.1786865685461d-05, 2.8861625801174d-04,
     |   2.2723066692057d-03, 1.2136498635294d-02, 4.7647643302119d-02,
     |   1.4463656744325d-01, 3.5036094732541d-01, 6.8916000820711d-01,
     |   1.1053852107330d+00, 1.4269788748082d+00, 1.4140120777547d+00,
     |   9.1338644971951d-01, 3.6295479733141d-02,-8.0530756313945d-01,
     |  -1.1116912872716d+00,-6.6433256546603d-01, 2.3602598572378d-01,
     |   9.2073615319170d-01, 8.5246869159909d-01, 8.7576660222713d-02,
     |  -7.2781672568902d-01,-8.8863696164204d-01,-2.5666190098523d-01,
     |   5.9350733466236d-01, 8.8189899926029d-01, 3.4428482262062d-01,
     |  -5.0974042907984d-01,-8.6889010324422d-01,-3.9218518761816d-01,
     |   4.5892042706356d-01, 8.6090813998039d-01, 4.2475575530218d-01,
     |  -4.2475575530218d-01,-8.6090813998039d-01,-4.5892042706356d-01,
     |   3.9218518761816d-01, 8.6889010324422d-01, 5.0974042907984d-01,
     |  -3.4428482262062d-01,-8.8189899926029d-01,-5.9350733466236d-01,
     |   2.5666190098522d-01, 8.8863696164204d-01, 7.2781672568902d-01,
     |  -8.7576660222709d-02,-8.5246869159909d-01,-9.2073615319170d-01,
     |  -2.3602598572379d-01, 6.6433256546603d-01, 1.1116912872716d+00,
     |   8.0530756313945d-01,-3.6295479733135d-02,-9.1338644971951d-01,
     |  -1.4140120777547d+00,-1.4269788748082d+00,-1.1053852107330d+00,
     |  -6.8916000820711d-01,-3.5036094732541d-01,-1.4463656744325d-01,
     |  -4.7647643302119d-02,-1.2136498635294d-02,-2.2723066692057d-03,
     |  -2.8861625801175d-04,-2.1786865685461d-05,-7.7184136119937d-07,
     |  -7.9283047702817d-09,-6.7815753588207d-12,-1.4810574986317d-18/
      data (pmn(lat,15,27), lat = 1,72)/
     |   2.5177607342101d-20, 3.4700916483811d-13, 6.8071331067069d-10,
     |   9.3736547283460d-08, 3.4501578543525d-06, 5.6890404593544d-05,
     |   5.4160786494890d-04, 3.4335602699459d-03, 1.5816708684726d-02,
     |   5.5995791220799d-02, 1.5804676984092d-01, 3.6397722843411d-01,
     |   6.9242535072447d-01, 1.0896401897895d+00, 1.3991470292271d+00,
     |   1.4029301043675d+00, 9.5321340087616d-01, 1.2998061114946d-01,
     |  -7.1095634168282d-01,-1.1015706054853d+00,-7.8166703512741d-01,
     |   5.3101525691818d-02, 8.1750815759814d-01, 9.4057196446714d-01,
     |   3.2444276220052d-01,-5.3626263130704d-01,-9.3023666119587d-01,
     |  -5.2568149519970d-01, 3.2578801890018d-01, 8.7609029543900d-01,
     |   6.3727135367773d-01,-1.7314928975115d-01,-8.1789723968736d-01,
     |  -7.0789981499996d-01, 5.4116582230225d-02, 7.6352454172134d-01,
     |   7.6352454172134d-01, 5.4116582230228d-02,-7.0789981499995d-01,
     |  -8.1789723968736d-01,-1.7314928975115d-01, 6.3727135367773d-01,
     |   8.7609029543901d-01, 3.2578801890019d-01,-5.2568149519969d-01,
     |  -9.3023666119586d-01,-5.3626263130704d-01, 3.2444276220051d-01,
     |   9.4057196446714d-01, 8.1750815759814d-01, 5.3101525691818d-02,
     |  -7.8166703512740d-01,-1.1015706054853d+00,-7.1095634168282d-01,
     |   1.2998061114946d-01, 9.5321340087615d-01, 1.4029301043676d+00,
     |   1.3991470292271d+00, 1.0896401897895d+00, 6.9242535072448d-01,
     |   3.6397722843411d-01, 1.5804676984092d-01, 5.5995791220800d-02,
     |   1.5816708684726d-02, 3.4335602699459d-03, 5.4160786494890d-04,
     |   5.6890404593545d-05, 3.4501578543525d-06, 9.3736547283460d-08,
     |   6.8071331067069d-10, 3.4700916483811d-13, 2.5177607342101d-20/
      data (pmn(lat,16,27), lat = 1,72)/
     |   3.9006558073009d-22, 1.6176228603834d-14, 5.3205639728899d-11,
     |   1.0351564735151d-08, 4.9602556438171d-07, 1.0158809616486d-05,
     |   1.1661544342128d-04, 8.7424557286609d-04, 4.7021581926423d-03,
     |   1.9287706110374d-02, 6.2857821213543d-02, 1.6728261822090d-01,
     |   3.6993502480611d-01, 6.8583374165851d-01, 1.0655726633465d+00,
     |   1.3689983874445d+00, 1.3981491491617d+00, 1.0077077487992d+00,
     |   2.4470875062766d-01,-5.9246963335132d-01,-1.0713220342230d+00,
     |  -8.9570222670646d-01,-1.5549145453689d-01, 6.6369357056831d-01,
     |   9.8374960443390d-01, 5.6484441409366d-01,-2.7655362826068d-01,
     |  -8.8049777002688d-01,-7.6111965600951d-01,-1.6907715853107d-02,
     |   7.3029448655008d-01, 8.4830558650988d-01, 2.3716963424725d-01,
     |  -5.7446159098371d-01,-8.8089656517809d-01,-4.1492618533150d-01,
     |   4.1492618533150d-01, 8.8089656517809d-01, 5.7446159098371d-01,
     |  -2.3716963424725d-01,-8.4830558650988d-01,-7.3029448655008d-01,
     |   1.6907715853104d-02, 7.6111965600951d-01, 8.8049777002688d-01,
     |   2.7655362826068d-01,-5.6484441409366d-01,-9.8374960443390d-01,
     |  -6.6369357056831d-01, 1.5549145453689d-01, 8.9570222670646d-01,
     |   1.0713220342230d+00, 5.9246963335132d-01,-2.4470875062765d-01,
     |  -1.0077077487992d+00,-1.3981491491617d+00,-1.3689983874446d+00,
     |  -1.0655726633465d+00,-6.8583374165851d-01,-3.6993502480611d-01,
     |  -1.6728261822090d-01,-6.2857821213543d-02,-1.9287706110374d-02,
     |  -4.7021581926424d-03,-8.7424557286609d-04,-1.1661544342128d-04,
     |  -1.0158809616486d-05,-4.9602556438171d-07,-1.0351564735151d-08,
     |  -5.3205639728899d-11,-1.6176228603834d-14,-3.9006558073009d-22/
      data (pmn(lat,17,27), lat = 1,72)/
     |   5.5082510080662d-24, 6.8712821286820d-16, 3.7871501600383d-12,
     |   1.0400559055854d-09, 6.4796552354679d-08, 1.6453878212067d-06,
     |   2.2722593795571d-05, 2.0085112612034d-04, 1.2565452564876d-03,
     |   5.9422193630090d-03, 2.2212963247448d-02, 6.7697141003227d-02,
     |   1.7179133142538d-01, 3.6789364950140d-01, 6.6916985458694d-01,
     |   1.0325057516638d+00, 1.3347376121401d+00, 1.3969407277500d+00,
     |   1.0748213149362d+00, 3.8164783946949d-01,-4.4356349782051d-01,
     |  -1.0101103739007d+00,-9.9522226279059d-01,-3.8536523948466d-01,
     |   4.5002680084307d-01, 9.5887088114678d-01, 7.8349757609204d-01,
     |   4.4734941938691d-02,-7.1218959443462d-01,-9.1175667063635d-01,
     |  -3.9807094859627d-01, 4.2421940480541d-01, 8.9759902641087d-01,
     |   6.3941599212161d-01,-1.3985803646981d-01,-8.0153012086832d-01,
     |  -8.0153012086833d-01,-1.3985803646982d-01, 6.3941599212161d-01,
     |   8.9759902641087d-01, 4.2421940480541d-01,-3.9807094859627d-01,
     |  -9.1175667063636d-01,-7.1218959443463d-01, 4.4734941938689d-02,
     |   7.8349757609204d-01, 9.5887088114679d-01, 4.5002680084308d-01,
     |  -3.8536523948466d-01,-9.9522226279059d-01,-1.0101103739007d+00,
     |  -4.4356349782053d-01, 3.8164783946949d-01, 1.0748213149362d+00,
     |   1.3969407277500d+00, 1.3347376121401d+00, 1.0325057516638d+00,
     |   6.6916985458694d-01, 3.6789364950140d-01, 1.7179133142538d-01,
     |   6.7697141003227d-02, 2.2212963247448d-02, 5.9422193630090d-03,
     |   1.2565452564877d-03, 2.0085112612034d-04, 2.2722593795571d-05,
     |   1.6453878212068d-06, 6.4796552354679d-08, 1.0400559055854d-09,
     |   3.7871501600383d-12, 6.8712821286820d-16, 5.5082510080662d-24/
      data (pmn(lat,18,27), lat = 1,72)/
     |   7.0833117817315d-26, 2.6572750505100d-17, 2.4529293076907d-13,
     |   9.5013203587890d-11, 7.6877897631523d-09, 2.4169473117383d-07,
     |   4.0079577936926d-06, 4.1672200912669d-05, 3.0232802163042d-04,
     |   1.6419477818899d-03, 7.0052915769688d-03, 2.4288297308502d-02,
     |   7.0095185762835d-02, 1.7120362772465d-01, 3.5765024100307d-01,
     |   6.4215678966663d-01, 9.8938010489530d-01, 1.2937877370334d+00,
     |   1.3953387534534d+00, 1.1508870816386d+00, 5.4047353518000d-01,
     |  -2.5816149734543d-01,-9.0456496878044d-01,-1.0631115252145d+00,
     |  -6.2452255196699d-01, 1.7209836946862d-01, 8.3936328361200d-01,
     |   9.4103801417260d-01, 4.0186931529812d-01,-4.0840727590446d-01,
     |  -9.1350315717688d-01,-7.4452302424890d-01,-2.4536889334853d-02,
     |   7.0800659666807d-01, 8.9887668175033d-01, 4.0228411620013d-01,
     |  -4.0228411620013d-01,-8.9887668175033d-01,-7.0800659666807d-01,
     |   2.4536889334850d-02, 7.4452302424890d-01, 9.1350315717688d-01,
     |   4.0840727590446d-01,-4.0186931529811d-01,-9.4103801417260d-01,
     |  -8.3936328361200d-01,-1.7209836946862d-01, 6.2452255196698d-01,
     |   1.0631115252145d+00, 9.0456496878044d-01, 2.5816149734543d-01,
     |  -5.4047353517999d-01,-1.1508870816386d+00,-1.3953387534534d+00,
     |  -1.2937877370334d+00,-9.8938010489530d-01,-6.4215678966663d-01,
     |  -3.5765024100307d-01,-1.7120362772465d-01,-7.0095185762835d-02,
     |  -2.4288297308502d-02,-7.0052915769688d-03,-1.6419477818900d-03,
     |  -3.0232802163042d-04,-4.1672200912670d-05,-4.0079577936926d-06,
     |  -2.4169473117384d-07,-7.6877897631523d-09,-9.5013203587890d-11,
     |  -2.4529293076907d-13,-2.6572750505100d-17,-7.0833117817315d-26/
      data (pmn(lat,19,27), lat = 1,72)/
     |   8.2767603541617d-28, 9.3356513869915d-19, 1.4427129597667d-14,
     |   7.8767202509527d-12, 8.2696261320297d-10, 3.2149606973362d-08,
     |   6.3918467605667d-07, 7.8020694767171d-06, 6.5479842247085d-05,
     |   4.0715893332166d-04, 1.9749176838334d-03, 7.7509595422969d-03,
     |   2.5273223161859d-02, 6.9782963686801d-02, 1.6536133879961d-01,
     |   3.3917711897794d-01, 6.0451810926553d-01, 9.3481694697033d-01,
     |   1.2427618257100d+00, 1.3878641788578d+00, 1.2299280715462d+00,
     |   7.1819815098032d-01,-3.1795527120739d-02,-7.3962770774579d-01,
     |  -1.0753926305913d+00,-8.4953205653175d-01,-1.6339816631418d-01,
     |   6.0083662060875d-01, 9.8387072595527d-01, 7.3995439251354d-01,
     |   1.9520292648004d-02,-7.0430401325759d-01,-9.4249360636416d-01,
     |  -5.2944664322213d-01, 2.5005146439666d-01, 8.5118363452912d-01,
     |   8.5118363452912d-01, 2.5005146439666d-01,-5.2944664322213d-01,
     |  -9.4249360636416d-01,-7.0430401325759d-01, 1.9520292648005d-02,
     |   7.3995439251354d-01, 9.8387072595527d-01, 6.0083662060875d-01,
     |  -1.6339816631418d-01,-8.4953205653175d-01,-1.0753926305913d+00,
     |  -7.3962770774579d-01,-3.1795527120739d-02, 7.1819815098032d-01,
     |   1.2299280715462d+00, 1.3878641788578d+00, 1.2427618257100d+00,
     |   9.3481694697033d-01, 6.0451810926553d-01, 3.3917711897795d-01,
     |   1.6536133879960d-01, 6.9782963686801d-02, 2.5273223161859d-02,
     |   7.7509595422969d-03, 1.9749176838334d-03, 4.0715893332166d-04,
     |   6.5479842247086d-05, 7.8020694767171d-06, 6.3918467605667d-07,
     |   3.2149606973363d-08, 8.2696261320297d-10, 7.8767202509527d-12,
     |   1.4427129597667d-14, 9.3356513869915d-19, 8.2767603541617d-28/
      data (pmn(lat,20,27), lat = 1,72)/
     |   8.7557219828151d-30, 2.9688037948863d-20, 7.6779215676040d-16,
     |   5.9051360980718d-13, 8.0381107509742d-11, 3.8603269485368d-09,
     |   9.1897962135107d-08, 1.3147555772987d-06, 1.2738976158066d-05,
     |   9.0465414004696d-05, 4.9732063112186d-04, 2.2008124951345d-03,
     |   8.0675348665394d-03, 2.5019688493365d-02, 6.6672189048085d-02,
     |   1.5435567869037d-01, 3.1268994604411d-01, 5.5609952040524d-01,
     |   8.6727625220374d-01, 1.1775546807348d+00, 1.3673351721151d+00,
     |   1.3028803294167d+00, 9.0754037755190d-01, 2.3599275546687d-01,
     |  -5.0086376385385d-01,-1.0015880063791d+00,-1.0216536367224d+00,
     |  -5.2955708512086d-01, 2.3281112414158d-01, 8.5121061179029d-01,
     |   9.6791405106593d-01, 5.0669604802912d-01,-2.5853432191718d-01,
     |  -8.5655351788024d-01,-9.1108758479835d-01,-3.8572580884142d-01,
     |   3.8572580884142d-01, 9.1108758479835d-01, 8.5655351788024d-01,
     |   2.5853432191718d-01,-5.0669604802912d-01,-9.6791405106593d-01,
     |  -8.5121061179030d-01,-2.3281112414159d-01, 5.2955708512086d-01,
     |   1.0216536367224d+00, 1.0015880063791d+00, 5.0086376385385d-01,
     |  -2.3599275546687d-01,-9.0754037755190d-01,-1.3028803294167d+00,
     |  -1.3673351721151d+00,-1.1775546807348d+00,-8.6727625220375d-01,
     |  -5.5609952040524d-01,-3.1268994604411d-01,-1.5435567869038d-01,
     |  -6.6672189048084d-02,-2.5019688493365d-02,-8.0675348665395d-03,
     |  -2.2008124951345d-03,-4.9732063112186d-04,-9.0465414004697d-05,
     |  -1.2738976158066d-05,-1.3147555772987d-06,-9.1897962135107d-08,
     |  -3.8603269485369d-09,-8.0381107509742d-11,-5.9051360980718d-13,
     |  -7.6779215676040d-16,-2.9688037948863d-20,-8.7557219828151d-30/
      data (pmn(lat,21,27), lat = 1,72)/
     |   8.3387605235144d-32, 8.4982265241844d-22, 3.6768804165311d-17,
     |   3.9817603949915d-14, 7.0225046626998d-12, 4.1625918982343d-10,
     |   1.1852192236596d-08, 1.9847251006555d-07, 2.2164208093823d-06,
     |   1.7938987708032d-05, 1.1148667079217d-04, 5.5456676165009d-04,
     |   2.2765287013683d-03, 7.8908968982521d-03, 2.3496631806890d-02,
     |   6.0884931958837d-02, 1.3857604474798d-01, 2.7875111653951d-01,
     |   4.9706816132470d-01, 7.8535662121124d-01, 1.0936485850051d+00,
     |   1.3249140907837d+00, 1.3569062212148d+00, 1.0949120907584d+00,
     |   5.3797834543959d-01,-1.7916256208531d-01,-8.0812229578973d-01,
     |  -1.0849790142805d+00,-8.6833328882896d-01,-2.4135102168573d-01,
     |   4.9619310986520d-01, 9.6498602041375d-01, 9.1018352309675d-01,
     |   3.5536983296073d-01,-3.9482769518053d-01,-9.1879146384895d-01,
     |  -9.1879146384895d-01,-3.9482769518053d-01, 3.5536983296073d-01,
     |   9.1018352309675d-01, 9.6498602041375d-01, 4.9619310986520d-01,
     |  -2.4135102168573d-01,-8.6833328882895d-01,-1.0849790142805d+00,
     |  -8.0812229578973d-01,-1.7916256208532d-01, 5.3797834543958d-01,
     |   1.0949120907584d+00, 1.3569062212148d+00, 1.3249140907837d+00,
     |   1.0936485850051d+00, 7.8535662121124d-01, 4.9706816132470d-01,
     |   2.7875111653951d-01, 1.3857604474798d-01, 6.0884931958838d-02,
     |   2.3496631806890d-02, 7.8908968982521d-03, 2.2765287013684d-03,
     |   5.5456676165009d-04, 1.1148667079217d-04, 1.7938987708033d-05,
     |   2.2164208093824d-06, 1.9847251006555d-07, 1.1852192236596d-08,
     |   4.1625918982344d-10, 7.0225046626998d-12, 3.9817603949915d-14,
     |   3.6768804165311d-17, 8.4982265241844d-22, 8.3387605235144d-32/
      data (pmn(lat,22,27), lat = 1,72)/
     |   7.0909483801622d-34, 2.1717472234480d-23, 1.5715559508504d-18,
     |   2.3952548308304d-15, 5.4702894887286d-13, 3.9990611414274d-11,
     |   1.3606195238649d-09, 2.6637672251519d-08, 3.4236923304309d-07,
     |   3.1527560620557d-06, 2.2104407500135d-05, 1.2327891880557d-04,
     |   5.6495598496768d-04, 2.1802283476664d-03, 7.2192181805756d-03,
     |   2.0807709635119d-02, 5.2778209310637d-02, 1.1876470300503d-01,
     |   2.3840603973618d-01, 4.2820087629564d-01, 6.8828651811149d-01,
     |   9.8676129277873d-01, 1.2506424879542d+00, 1.3751760816226d+00,
     |   1.2584006027568d+00, 8.5432236561414d-01, 2.2119843249413d-01,
     |  -4.6738126740102d-01,-9.7089576841280d-01,-1.0822976743198d+00,
     |  -7.3733227992149d-01,-7.1507051117635d-02, 6.1953540907184d-01,
     |   1.0110267187334d+00, 9.1060478506822d-01, 3.6325061692639d-01,
     |  -3.6325061692638d-01,-9.1060478506822d-01,-1.0110267187334d+00,
     |  -6.1953540907184d-01, 7.1507051117633d-02, 7.3733227992149d-01,
     |   1.0822976743198d+00, 9.7089576841280d-01, 4.6738126740103d-01,
     |  -2.2119843249413d-01,-8.5432236561414d-01,-1.2584006027568d+00,
     |  -1.3751760816226d+00,-1.2506424879542d+00,-9.8676129277873d-01,
     |  -6.8828651811149d-01,-4.2820087629565d-01,-2.3840603973618d-01,
     |  -1.1876470300503d-01,-5.2778209310638d-02,-2.0807709635119d-02,
     |  -7.2192181805755d-03,-2.1802283476664d-03,-5.6495598496769d-04,
     |  -1.2327891880557d-04,-2.2104407500135d-05,-3.1527560620558d-06,
     |  -3.4236923304310d-07,-2.6637672251519d-08,-1.3606195238649d-09,
     |  -3.9990611414275d-11,-5.4702894887286d-13,-2.3952548308304d-15,
     |  -1.5715559508504d-18,-2.1717472234480d-23,-7.0909483801622d-34/
      data (pmn(lat,23,27), lat = 1,72)/
     |   5.3185334241010d-36, 4.8946685408066d-25, 5.9225493228272d-20,
     |   1.2699807000476d-16, 3.7538670317746d-14, 3.3823623876096d-12,
     |   1.3740081698246d-10, 3.1417636094709d-09, 4.6418739190670d-08,
     |   4.8563072232377d-07, 3.8344004051727d-06, 2.3926039251811d-05,
     |   1.2209456865905d-04, 5.2296258527220d-04, 1.9182772054792d-03,
     |   6.1208487783267d-03, 1.7198008559635d-02, 4.2956126476499d-02,
     |   9.6064829412469d-02, 1.9333602987876d-01, 3.5125313540459d-01,
     |   5.7664016195456d-01, 8.5398061126002d-01, 1.1348257781395d+00,
     |   1.3377958875379d+00, 1.3667000608587d+00, 1.1472057180215d+00,
     |   6.7080199688443d-01, 2.4509387078844d-02,-6.1613667520984d-01,
     |  -1.0401742025547d+00,-1.0860465384807d+00,-7.2167914318236d-01,
     |  -7.7248386743090d-02, 5.9425453009320d-01, 1.0184268738287d+00,
     |   1.0184268738287d+00, 5.9425453009320d-01,-7.7248386743088d-02,
     |  -7.2167914318236d-01,-1.0860465384807d+00,-1.0401742025547d+00,
     |  -6.1613667520984d-01, 2.4509387078840d-02, 6.7080199688443d-01,
     |   1.1472057180215d+00, 1.3667000608587d+00, 1.3377958875379d+00,
     |   1.1348257781395d+00, 8.5398061126002d-01, 5.7664016195456d-01,
     |   3.5125313540459d-01, 1.9333602987876d-01, 9.6064829412469d-02,
     |   4.2956126476499d-02, 1.7198008559636d-02, 6.1208487783267d-03,
     |   1.9182772054792d-03, 5.2296258527220d-04, 1.2209456865905d-04,
     |   2.3926039251811d-05, 3.8344004051727d-06, 4.8563072232378d-07,
     |   4.6418739190671d-08, 3.1417636094709d-09, 1.3740081698246d-10,
     |   3.3823623876097d-12, 3.7538670317746d-14, 1.2699807000476d-16,
     |   5.9225493228272d-20, 4.8946685408066d-25, 5.3185334241010d-36/
      data (pmn(lat,24,27), lat = 1,72)/
     |   3.4533092444635d-38, 9.5487786311075d-27, 1.9315509680202d-21,
     |   5.8253366850951d-18, 2.2275870522154d-15, 2.4724238806734d-13,
     |   1.1983271959524d-11, 3.1974898981429d-10, 5.4249822671235d-09,
     |   6.4400224475606d-08, 5.7178987176575d-07, 3.9847798506905d-06,
     |   2.2594930731783d-05, 1.0714443823033d-04, 4.3404048397559d-04,
     |   1.5274620052322d-03, 4.7322095452484d-03, 1.3043798032685d-02,
     |   3.2257178048358d-02, 7.2037581586256d-02, 1.4598725712583d-01,
     |   2.6935765241664d-01, 4.5325243665859d-01, 6.9548408193709d-01,
     |   9.7068657713110d-01, 1.2249050852794d+00, 1.3808543593880d+00,
     |   1.3575390323925d+00, 1.1015948475470d+00, 6.1973634169761d-01,
     |  -3.5068184408493d-03,-6.1658997125850d-01,-1.0435768623118d+00,
     |  -1.1464722788155d+00,-8.8261396059925d-01,-3.3055554247802d-01,
     |   3.3055554247802d-01, 8.8261396059925d-01, 1.1464722788155d+00,
     |   1.0435768623118d+00, 6.1658997125850d-01, 3.5068184408478d-03,
     |  -6.1973634169760d-01,-1.1015948475470d+00,-1.3575390323925d+00,
     |  -1.3808543593880d+00,-1.2249050852794d+00,-9.7068657713110d-01,
     |  -6.9548408193709d-01,-4.5325243665859d-01,-2.6935765241664d-01,
     |  -1.4598725712583d-01,-7.2037581586256d-02,-3.2257178048358d-02,
     |  -1.3043798032685d-02,-4.7322095452484d-03,-1.5274620052323d-03,
     |  -4.3404048397559d-04,-1.0714443823033d-04,-2.2594930731784d-05,
     |  -3.9847798506905d-06,-5.7178987176575d-07,-6.4400224475607d-08,
     |  -5.4249822671236d-09,-3.1974898981429d-10,-1.1983271959524d-11,
     |  -2.4724238806735d-13,-2.2275870522154d-15,-5.8253366850951d-18,
     |  -1.9315509680202d-21,-9.5487786311075d-27,-3.4533092444635d-38/
      data (pmn(lat,25,27), lat = 1,72)/
     |   1.8823157991071d-40, 1.5636717095581d-28, 5.2868342186627d-23,
     |   2.2418849768938d-19, 1.1086396782596d-16, 1.5149877854285d-14,
     |   8.7553997499084d-13, 2.7241582242954d-11, 5.3027182599463d-10,
     |   7.1350542201342d-09, 7.1146184661667d-08, 5.5291813463044d-07,
     |   3.4775702284141d-06, 1.8218057897805d-05, 8.1299833842845d-05,
     |   3.1459956967520d-04, 1.0707564636942d-03, 3.2424986666234d-03,
     |   8.8180365220400d-03, 2.1699110879870d-02, 4.8608941081360d-02,
     |   9.9598815545708d-02, 1.8732510144386d-01, 3.2417069672870d-01,
     |   5.1675145922342d-01, 7.5855292449739d-01, 1.0231361976064d+00,
     |   1.2617376223552d+00, 1.4090562510362d+00, 1.3987796423001d+00,
     |   1.1861869147668d+00, 7.7059860140972d-01, 2.0798977833604d-01,
     |  -3.9419635020510d-01,-9.0187635028935d-01,-1.1923348211400d+00,
     |  -1.1923348211400d+00,-9.0187635028935d-01,-3.9419635020510d-01,
     |   2.0798977833604d-01, 7.7059860140972d-01, 1.1861869147668d+00,
     |   1.3987796423001d+00, 1.4090562510362d+00, 1.2617376223552d+00,
     |   1.0231361976064d+00, 7.5855292449739d-01, 5.1675145922342d-01,
     |   3.2417069672870d-01, 1.8732510144386d-01, 9.9598815545708d-02,
     |   4.8608941081361d-02, 2.1699110879870d-02, 8.8180365220401d-03,
     |   3.2424986666234d-03, 1.0707564636942d-03, 3.1459956967520d-04,
     |   8.1299833842844d-05, 1.8218057897805d-05, 3.4775702284141d-06,
     |   5.5291813463044d-07, 7.1146184661667d-08, 7.1350542201344d-09,
     |   5.3027182599465d-10, 2.7241582242954d-11, 8.7553997499084d-13,
     |   1.5149877854286d-14, 1.1086396782596d-16, 2.2418849768938d-19,
     |   5.2868342186627d-23, 1.5636717095581d-28, 1.8823157991071d-40/
      data (pmn(lat,26,27), lat = 1,72)/
     |   8.1320931398396d-43, 2.0293662373566d-30, 1.1466482780423d-24,
     |   6.8350386197639d-21, 4.3695062817034d-18, 7.3483578831641d-16,
     |   5.0609803181094d-14, 1.8349600795840d-12, 4.0947481136745d-11,
     |   6.2392148974103d-10, 6.9793033733666d-09, 6.0409070441011d-08,
     |   4.2079252275944d-07, 2.4310233373613d-06, 1.1925956062702d-05,
     |   5.0618821491716d-05, 1.8871198609663d-04, 6.2559838577299d-04,
     |   1.8628925396420d-03, 5.0245948170370d-03, 1.2360557785892d-02,
     |   2.7892187886518d-02, 5.8006205444477d-02, 1.1159948164597d-01,
     |   1.9922107114729d-01, 3.3070201606964d-01, 5.1115566324659d-01,
     |   7.3599081763731d-01, 9.8649542520251d-01, 1.2281763893420d+00,
     |   1.4138721496455d+00, 1.4924084944357d+00, 1.4214676584153d+00,
     |   1.1811669537382d+00, 7.8365673326058d-01, 2.7465977760493d-01,
     |  -2.7465977760493d-01,-7.8365673326057d-01,-1.1811669537382d+00,
     |  -1.4214676584153d+00,-1.4924084944357d+00,-1.4138721496455d+00,
     |  -1.2281763893420d+00,-9.8649542520251d-01,-7.3599081763731d-01,
     |  -5.1115566324659d-01,-3.3070201606964d-01,-1.9922107114729d-01,
     |  -1.1159948164597d-01,-5.8006205444477d-02,-2.7892187886518d-02,
     |  -1.2360557785892d-02,-5.0245948170371d-03,-1.8628925396420d-03,
     |  -6.2559838577299d-04,-1.8871198609664d-04,-5.0618821491717d-05,
     |  -1.1925956062702d-05,-2.4310233373613d-06,-4.2079252275945d-07,
     |  -6.0409070441011d-08,-6.9793033733666d-09,-6.2392148974104d-10,
     |  -4.0947481136746d-11,-1.8349600795840d-12,-5.0609803181094d-14,
     |  -7.3483578831645d-16,-4.3695062817034d-18,-6.8350386197639d-21,
     |  -1.1466482780423d-24,-2.0293662373566d-30,-8.1320931398396d-43/
      data (pmn(lat,27,27), lat = 1,72)/
     |   2.4146920675300d-45, 1.8100598421714d-32, 1.7089057091929d-26,
     |   1.4316084478323d-22, 1.1827617586270d-19, 2.4469473551894d-17,
     |   2.0074129644393d-15, 8.4763914021176d-14, 2.1669281100886d-12,
     |   3.7359076755287d-11, 4.6837122515020d-10, 4.5099938363674d-09,
     |   3.4747804356742d-08, 2.2104710679627d-07, 1.1899720203446d-06,
     |   5.5284846511963d-06, 2.2521148956153d-05, 8.1497268350531d-05,
     |   2.6481745708833d-04, 7.7967970289221d-04, 2.0958019058713d-03,
     |   5.1766079765244d-03, 1.1813674200832d-02, 2.5027015583239d-02,
     |   4.9416014485123d-02, 9.1256740633214d-02, 1.5808593282103d-01,
     |   2.5754986365186d-01, 3.9547308694634d-01, 5.7340953198976d-01,
     |   7.8628873483402d-01, 1.0210077676471d+00, 1.2567819753297d+00,
     |   1.4676741685658d+00, 1.6270451591589d+00, 1.7129389822851d+00,
     |   1.7129389822851d+00, 1.6270451591589d+00, 1.4676741685658d+00,
     |   1.2567819753297d+00, 1.0210077676471d+00, 7.8628873483402d-01,
     |   5.7340953198976d-01, 3.9547308694634d-01, 2.5754986365186d-01,
     |   1.5808593282103d-01, 9.1256740633214d-02, 4.9416014485123d-02,
     |   2.5027015583239d-02, 1.1813674200832d-02, 5.1766079765244d-03,
     |   2.0958019058713d-03, 7.7967970289221d-04, 2.6481745708833d-04,
     |   8.1497268350531d-05, 2.2521148956153d-05, 5.5284846511964d-06,
     |   1.1899720203446d-06, 2.2104710679627d-07, 3.4747804356742d-08,
     |   4.5099938363674d-09, 4.6837122515020d-10, 3.7359076755287d-11,
     |   2.1669281100886d-12, 8.4763914021177d-14, 2.0074129644393d-15,
     |   2.4469473551895d-17, 1.1827617586270d-19, 1.4316084478323d-22,
     |   1.7089057091929d-26, 1.8100598421714d-32, 2.4146920675300d-45/
      data (pmn(lat, 0,28), lat = 1,72)/
     |   4.8350417394334d+00, 1.6124335875039d+00,-1.5751760992369d+00,
     |  -1.8802772622556d+00, 1.3773042922199d-01, 1.5848986772179d+00,
     |   8.1474547697858d-01,-8.7810225601574d-01,-1.2448239596037d+00,
     |   2.8644635775916d-02, 1.1445008970623d+00, 6.7732920708457d-01,
     |  -6.3856291109715d-01,-1.0261255678614d+00,-4.0131835348738d-02,
     |   9.4173240889775d-01, 6.2703905197281d-01,-5.0286120801754d-01,
     |  -9.1500370770914d-01,-9.3699179939818d-02, 8.2153939467133d-01,
     |   6.0937346139133d-01,-4.1017383834270d-01,-8.5169284542286d-01,
     |  -1.4081555500401d-01, 7.4209584632331d-01, 6.0973425613225d-01,
     |  -3.3977892860819d-01,-8.1603862408237d-01,-1.8590932793923d-01,
     |   6.8697305035076d-01, 6.2318098783988d-01,-2.8217584166816d-01,
     |  -7.9978813284464d-01,-2.3206365817455d-01, 6.4854065783730d-01,
     |   6.4854065783730d-01,-2.3206365817455d-01,-7.9978813284464d-01,
     |  -2.8217584166816d-01, 6.2318098783988d-01, 6.8697305035076d-01,
     |  -1.8590932793923d-01,-8.1603862408237d-01,-3.3977892860819d-01,
     |   6.0973425613225d-01, 7.4209584632332d-01,-1.4081555500400d-01,
     |  -8.5169284542286d-01,-4.1017383834270d-01, 6.0937346139133d-01,
     |   8.2153939467134d-01,-9.3699179939815d-02,-9.1500370770914d-01,
     |  -5.0286120801754d-01, 6.2703905197280d-01, 9.4173240889775d-01,
     |  -4.0131835348745d-02,-1.0261255678614d+00,-6.3856291109716d-01,
     |   6.7732920708457d-01, 1.1445008970623d+00, 2.8644635775926d-02,
     |  -1.2448239596037d+00,-8.7810225601574d-01, 8.1474547697858d-01,
     |   1.5848986772179d+00, 1.3773042922199d-01,-1.8802772622556d+00,
     |  -1.5751760992369d+00, 1.6124335875039d+00, 4.8350417394334d+00/
      data (pmn(lat, 1,28), lat = 1,72)/
     |   1.5806015382187d+00, 3.1067970301042d+00, 1.5906024307589d+00,
     |  -1.0065901846759d+00,-1.7928560239507d+00,-2.8735436538231d-01,
     |   1.3191138731652d+00, 1.0549579327986d+00,-5.0926618799514d-01,
     |  -1.2565737888090d+00,-3.1796529510145d-01, 9.5186280386646d-01,
     |   8.8703263436148d-01,-3.3106376638313d-01,-1.0381758839855d+00,
     |  -3.3994453142254d-01, 7.6923632828905d-01, 8.0815522823083d-01,
     |  -2.2476165733716d-01,-9.1711185404363d-01,-3.6431113714802d-01,
     |   6.5453492675459d-01, 7.6829913395810d-01,-1.4740466310377d-01,
     |  -8.4198466208111d-01,-3.9244147835983d-01, 5.7377308217519d-01,
     |   7.5125234331427d-01,-8.4031800461160d-02,-7.9394577484083d-01,
     |  -4.2539668857168d-01, 5.1285742818348d-01, 7.5073219055737d-01,
     |  -2.7342474910340d-02,-7.6472345865730d-01,-4.6472639512643d-01,
     |   4.6472639512643d-01, 7.6472345865730d-01, 2.7342474910343d-02,
     |  -7.5073219055737d-01,-5.1285742818348d-01, 4.2539668857168d-01,
     |   7.9394577484084d-01, 8.4031800461168d-02,-7.5125234331427d-01,
     |  -5.7377308217519d-01, 3.9244147835983d-01, 8.4198466208111d-01,
     |   1.4740466310378d-01,-7.6829913395810d-01,-6.5453492675459d-01,
     |   3.6431113714801d-01, 9.1711185404363d-01, 2.2476165733717d-01,
     |  -8.0815522823083d-01,-7.6923632828905d-01, 3.3994453142254d-01,
     |   1.0381758839855d+00, 3.3106376638312d-01,-8.8703263436147d-01,
     |  -9.5186280386646d-01, 3.1796529510145d-01, 1.2565737888090d+00,
     |   5.0926618799515d-01,-1.0549579327986d+00,-1.3191138731652d+00,
     |   2.8735436538229d-01, 1.7928560239507d+00, 1.0065901846759d+00,
     |  -1.5906024307589d+00,-3.1067970301042d+00,-1.5806015382187d+00/
      data (pmn(lat, 2,28), lat = 1,72)/
     |   2.4941250397912d-01, 1.7165490044439d+00, 2.5977402580968d+00,
     |   1.4230183281903d+00,-7.7129023410386d-01,-1.6693769594534d+00,
     |  -4.9771871726194d-01, 1.0975799983759d+00, 1.1543322231294d+00,
     |  -2.2936382209547d-01,-1.1912227954743d+00,-5.5624034883745d-01,
     |   7.4207452091945d-01, 9.9257338966015d-01,-5.9317485153056d-02,
     |  -9.7265923562337d-01,-5.6617316468041d-01, 5.6280667075027d-01,
     |   9.0101256771050d-01, 3.7295362167321d-02,-8.4310013247211d-01,
     |  -5.7639962876891d-01, 4.4675525225572d-01, 8.4645795110361d-01,
     |   1.0852826076623d-01,-7.5661140191927d-01,-5.9274503439224d-01,
     |   3.6072808247047d-01, 8.1504092871688d-01, 1.6987657952677d-01,
     |  -6.9513561652500d-01,-6.1678108169778d-01, 2.9064392958661d-01,
     |   8.0056448568277d-01, 2.2882772093393d-01,-6.5005342397315d-01,
     |  -6.5005342397315d-01, 2.2882772093393d-01, 8.0056448568277d-01,
     |   2.9064392958661d-01,-6.1678108169778d-01,-6.9513561652500d-01,
     |   1.6987657952677d-01, 8.1504092871688d-01, 3.6072808247047d-01,
     |  -5.9274503439224d-01,-7.5661140191927d-01, 1.0852826076623d-01,
     |   8.4645795110361d-01, 4.4675525225572d-01,-5.7639962876891d-01,
     |  -8.4310013247212d-01, 3.7295362167317d-02, 9.0101256771050d-01,
     |   5.6280667075028d-01,-5.6617316468041d-01,-9.7265923562338d-01,
     |  -5.9317485153049d-02, 9.9257338966015d-01, 7.4207452091946d-01,
     |  -5.5624034883745d-01,-1.1912227954743d+00,-2.2936382209548d-01,
     |   1.1543322231294d+00, 1.0975799983759d+00,-4.9771871726194d-01,
     |  -1.6693769594534d+00,-7.7129023410386d-01, 1.4230183281903d+00,
     |   2.5977402580968d+00, 1.7165490044439d+00, 2.4941250397912d-01/
      data (pmn(lat, 3,28), lat = 1,72)/
     |   2.5957763707382d-02, 5.7544325096665d-01, 1.7474324047482d+00,
     |   2.3117200208397d+00, 1.2509775098374d+00,-6.7313772184866d-01,
     |  -1.5629730106099d+00,-6.0201055758046d-01, 9.2875245275340d-01,
     |   1.1862443180304d+00,-2.1584696772613d-02,-1.0970731516911d+00,
     |  -7.1693158687371d-01, 5.4118101077259d-01, 1.0293506538325d+00,
     |   1.7003642679665d-01,-8.6210344512365d-01,-7.2732433074222d-01,
     |   3.4684424854352d-01, 9.2399299092626d-01, 2.6987677369914d-01,
     |  -7.1570362051686d-01,-7.2814463247546d-01, 2.2013923229684d-01,
     |   8.5246028705128d-01, 3.4084378472126d-01,-6.1194220801449d-01,
     |  -7.3334965027951d-01, 1.2322107367190d-01, 8.0288972194666d-01,
     |   4.0248508605181d-01,-5.3141408577341d-01,-7.4628993883918d-01,
     |   3.9763269749492d-02, 7.6873183777574d-01, 4.6387966434905d-01,
     |  -4.6387966434905d-01,-7.6873183777574d-01,-3.9763269749495d-02,
     |   7.4628993883918d-01, 5.3141408577341d-01,-4.0248508605181d-01,
     |  -8.0288972194666d-01,-1.2322107367190d-01, 7.3334965027951d-01,
     |   6.1194220801449d-01,-3.4084378472126d-01,-8.5246028705128d-01,
     |  -2.2013923229685d-01, 7.2814463247546d-01, 7.1570362051686d-01,
     |  -2.6987677369912d-01,-9.2399299092626d-01,-3.4684424854353d-01,
     |   7.2732433074222d-01, 8.6210344512365d-01,-1.7003642679665d-01,
     |  -1.0293506538325d+00,-5.4118101077259d-01, 7.1693158687370d-01,
     |   1.0970731516911d+00, 2.1584696772613d-02,-1.1862443180304d+00,
     |  -9.2875245275341d-01, 6.0201055758045d-01, 1.5629730106099d+00,
     |   6.7313772184868d-01,-1.2509775098374d+00,-2.3117200208397d+00,
     |  -1.7474324047482d+00,-5.7544325096665d-01,-2.5957763707382d-02/
      data (pmn(lat, 4,28), lat = 1,72)/
     |   2.0120413174478d-03, 1.3945345957182d-01, 7.7724968689323d-01,
     |   1.7577694727606d+00, 2.1082943368182d+00, 1.0920742120840d+00,
     |  -6.3793763837051d-01,-1.4778971670909d+00,-6.5202155777821d-01,
     |   8.0211868847958d-01, 1.1863966371016d+00, 1.3412186113543d-01,
     |  -9.9547903456893d-01,-8.2447550838733d-01, 3.5734258444079d-01,
     |   1.0212423985530d+00, 3.5975795129134d-01,-7.2608542590756d-01,
     |  -8.3395061310851d-01, 1.3445989383464d-01, 8.9220344076088d-01,
     |   4.6723537274176d-01,-5.5163619970667d-01,-8.2128884306174d-01,
     |  -9.7254778335711d-03, 7.9509972500344d-01, 5.3784478902942d-01,
     |  -4.2257496535921d-01,-8.0921858144411d-01,-1.2086907318493d-01,
     |   7.1862985387188d-01, 5.9666630875112d-01,-3.1609835613391d-01,
     |  -8.0263720487071d-01,-2.1899587586682d-01, 6.5463374786242d-01,
     |   6.5463374786242d-01,-2.1899587586681d-01,-8.0263720487071d-01,
     |  -3.1609835613391d-01, 5.9666630875112d-01, 7.1862985387188d-01,
     |  -1.2086907318493d-01,-8.0921858144411d-01,-4.2257496535921d-01,
     |   5.3784478902942d-01, 7.9509972500344d-01,-9.7254778335642d-03,
     |  -8.2128884306174d-01,-5.5163619970667d-01, 4.6723537274176d-01,
     |   8.9220344076089d-01, 1.3445989383464d-01,-8.3395061310851d-01,
     |  -7.2608542590756d-01, 3.5975795129133d-01, 1.0212423985530d+00,
     |   3.5734258444078d-01,-8.2447550838733d-01,-9.9547903456894d-01,
     |   1.3412186113543d-01, 1.1863966371016d+00, 8.0211868847959d-01,
     |  -6.5202155777820d-01,-1.4778971670909d+00,-6.3793763837051d-01,
     |   1.0920742120840d+00, 2.1082943368182d+00, 1.7577694727606d+00,
     |   7.7724968689323d-01, 1.3945345957182d-01, 2.0120413174478d-03/
      data (pmn(lat, 5,28), lat = 1,72)/
     |   1.2393909270261d-04, 2.6479391403458d-02, 2.6121627899860d-01,
     |   9.2308721920998d-01, 1.7557044819852d+00, 1.9451979055214d+00,
     |   9.4868041808876d-01,-6.3258526511113d-01,-1.4100545154834d+00,
     |  -6.7401377320351d-01, 7.0557720128955d-01, 1.1720954408729d+00,
     |   2.5420269828170d-01,-8.9466940559116d-01,-8.9599742896688d-01,
     |   1.9082092482514d-01, 9.8306033950165d-01, 5.1537751128764d-01,
     |  -5.7553210343602d-01,-8.9512758140458d-01,-6.7681140966221d-02,
     |   8.1669677444918d-01, 6.2703425451449d-01,-3.6291879421976d-01,
     |  -8.5827155708773d-01,-2.3109961718045d-01, 6.8229908789015d-01,
     |   6.9033031360866d-01,-2.0192807747793d-01,-8.1694931505999d-01,
     |  -3.5452495065953d-01, 5.6782935774736d-01, 7.3621936724520d-01,
     |  -6.4951586486987d-02,-7.7668487257955d-01,-4.6215608043739d-01,
     |   4.6215608043739d-01, 7.7668487257955d-01, 6.4951586486989d-02,
     |  -7.3621936724520d-01,-5.6782935774737d-01, 3.5452495065954d-01,
     |   8.1694931505999d-01, 2.0192807747794d-01,-6.9033031360866d-01,
     |  -6.8229908789015d-01, 2.3109961718045d-01, 8.5827155708773d-01,
     |   3.6291879421976d-01,-6.2703425451449d-01,-8.1669677444918d-01,
     |   6.7681140966205d-02, 8.9512758140458d-01, 5.7553210343603d-01,
     |  -5.1537751128763d-01,-9.8306033950165d-01,-1.9082092482514d-01,
     |   8.9599742896688d-01, 8.9466940559116d-01,-2.5420269828168d-01,
     |  -1.1720954408729d+00,-7.0557720128955d-01, 6.7401377320350d-01,
     |   1.4100545154834d+00, 6.3258526511113d-01,-9.4868041808876d-01,
     |  -1.9451979055214d+00,-1.7557044819852d+00,-9.2308721920998d-01,
     |  -2.6121627899860d-01,-2.6479391403458d-02,-1.2393909270261d-04/
      data (pmn(lat, 6,28), lat = 1,72)/
     |   6.3159257619900d-06, 4.1269174988438d-03, 7.0723948425135d-02,
     |   3.7569099752483d-01, 1.0346263364879d+00, 1.7436534901564d+00,
     |   1.8059087532339d+00, 8.2091747155813d-01,-6.4045952612112d-01,
     |  -1.3550061796498d+00,-6.8231623692991d-01, 6.2901550670154d-01,
     |   1.1516267829886d+00, 3.5091658450270d-01,-7.9660153591623d-01,
     |  -9.4272927141364d-01, 3.8805549452377d-02, 9.2323402020618d-01,
     |   6.4224576026047d-01,-4.1603438901628d-01,-9.1731468646631d-01,
     |  -2.5607327656370d-01, 7.0497576691241d-01, 7.4777123791762d-01,
     |  -1.5859312330162d-01,-8.4092139147762d-01,-4.3391475218726d-01,
     |   5.2126750060842d-01, 7.8986441155053d-01, 3.6488254058743d-02,
     |  -7.5423242360538d-01,-5.6007896867384d-01, 3.5863438582266d-01,
     |   8.0520912310852d-01, 2.0218748847121d-01,-6.6241222104086d-01,
     |  -6.6241222104086d-01, 2.0218748847121d-01, 8.0520912310852d-01,
     |   3.5863438582266d-01,-5.6007896867384d-01,-7.5423242360538d-01,
     |   3.6488254058739d-02, 7.8986441155053d-01, 5.2126750060842d-01,
     |  -4.3391475218726d-01,-8.4092139147763d-01,-1.5859312330163d-01,
     |   7.4777123791762d-01, 7.0497576691241d-01,-2.5607327656370d-01,
     |  -9.1731468646631d-01,-4.1603438901628d-01, 6.4224576026047d-01,
     |   9.2323402020618d-01, 3.8805549452385d-02,-9.4272927141364d-01,
     |  -7.9660153591622d-01, 3.5091658450270d-01, 1.1516267829886d+00,
     |   6.2901550670154d-01,-6.8231623692991d-01,-1.3550061796498d+00,
     |  -6.4045952612113d-01, 8.2091747155812d-01, 1.8059087532339d+00,
     |   1.7436534901564d+00, 1.0346263364879d+00, 3.7569099752483d-01,
     |   7.0723948425135d-02, 4.1269174988438d-03, 6.3159257619900d-06/
      data (pmn(lat, 7,28), lat = 1,72)/
     |   2.7359610907595d-07, 5.4411073912151d-04, 1.6021855845979d-02,
     |   1.2531642168956d-01, 4.8002064661675d-01, 1.1212223828865d+00,
     |   1.7233260921363d+00, 1.6833086477524d+00, 7.0878076065046d-01,
     |  -6.5247805308415d-01,-1.3093919429143d+00,-6.8537046677199d-01,
     |   5.6453733677570d-01, 1.1287296209938d+00, 4.3312672077580d-01,
     |  -7.0026490267831d-01,-9.7155534855331d-01,-1.0231327458514d-01,
     |   8.4587684286460d-01, 7.4429523627245d-01,-2.5017308004090d-01,
     |  -9.0423315151061d-01,-4.2819589137469d-01, 5.6196375298194d-01,
     |   8.2730728424587d-01, 5.3557921178817d-02,-7.7016155380557d-01,
     |  -6.0802684601668d-01, 3.1944517661651d-01, 8.2788980290105d-01,
     |   2.7746405026860d-01,-6.2041469295012d-01,-7.1806310819192d-01,
     |   1.0359123579513d-01, 7.8844442151775d-01, 4.5949279143598d-01,
     |  -4.5949279143598d-01,-7.8844442151775d-01,-1.0359123579514d-01,
     |   7.1806310819192d-01, 6.2041469295012d-01,-2.7746405026861d-01,
     |  -8.2788980290105d-01,-3.1944517661652d-01, 6.0802684601668d-01,
     |   7.7016155380557d-01,-5.3557921178813d-02,-8.2730728424586d-01,
     |  -5.6196375298194d-01, 4.2819589137469d-01, 9.0423315151061d-01,
     |   2.5017308004092d-01,-7.4429523627245d-01,-8.4587684286460d-01,
     |   1.0231327458513d-01, 9.7155534855331d-01, 7.0026490267831d-01,
     |  -4.3312672077581d-01,-1.1287296209938d+00,-5.6453733677571d-01,
     |   6.8537046677199d-01, 1.3093919429143d+00, 6.5247805308416d-01,
     |  -7.0878076065045d-01,-1.6833086477524d+00,-1.7233260921363d+00,
     |  -1.1212223828865d+00,-4.8002064661675d-01,-1.2531642168956d-01,
     |  -1.6021855845979d-02,-5.4411073912151d-04,-2.7359610907595d-07/
      data (pmn(lat, 8,28), lat = 1,72)/
     |   1.0271627294452d-08, 6.1975565608880d-05, 3.1137284041386d-03,
     |   3.5413563748612d-02, 1.8459265401945d-01, 5.7334520781865d-01,
     |   1.1879258741552d+00, 1.6964479846819d+00, 1.5743985955883d+00,
     |   6.1245495301711d-01,-6.6334862067339d-01,-1.2709078126412d+00,
     |  -6.8854087201889d-01, 5.0597984133335d-01, 1.1047186095413d+00,
     |   5.0715684641202d-01,-6.0325106425319d-01,-9.8616280232317d-01,
     |  -2.3586021565037d-01, 7.5222243295280d-01, 8.2353459724455d-01,
     |  -7.9155318801328d-02,-8.5715414421057d-01,-5.8103052165650d-01,
     |   3.9115735146794d-01, 8.6212023552717d-01, 2.6536521118095d-01,
     |  -6.4646570049925d-01,-7.4193099085161d-01, 8.6043395863315d-02,
     |   7.9575447410500d-01, 5.0240473892231d-01,-4.1821411720849d-01,
     |  -8.0685392747201d-01,-1.7773817427942d-01, 6.7362260692130d-01,
     |   6.7362260692130d-01,-1.7773817427941d-01,-8.0685392747201d-01,
     |  -4.1821411720849d-01, 5.0240473892230d-01, 7.9575447410500d-01,
     |   8.6043395863319d-02,-7.4193099085161d-01,-6.4646570049925d-01,
     |   2.6536521118095d-01, 8.6212023552718d-01, 3.9115735146794d-01,
     |  -5.8103052165649d-01,-8.5715414421057d-01,-7.9155318801328d-02,
     |   8.2353459724454d-01, 7.5222243295280d-01,-2.3586021565036d-01,
     |  -9.8616280232317d-01,-6.0325106425320d-01, 5.0715684641202d-01,
     |   1.1047186095413d+00, 5.0597984133335d-01,-6.8854087201888d-01,
     |  -1.2709078126412d+00,-6.6334862067339d-01, 6.1245495301710d-01,
     |   1.5743985955883d+00, 1.6964479846819d+00, 1.1879258741552d+00,
     |   5.7334520781866d-01, 1.8459265401945d-01, 3.5413563748612d-02,
     |   3.1137284041386d-03, 6.1975565608880d-05, 1.0271627294452d-08/
      data (pmn(lat, 9,28), lat = 1,72)/
     |   3.3904247534024d-10, 6.1926626088831d-06, 5.2831840866254d-04,
     |   8.6658998425897d-03, 6.0646874229368d-02, 2.4484767758372d-01,
     |   6.5528911134506d-01, 1.2380226803047d+00, 1.6648457019621d+00,
     |   1.4781760751563d+00, 5.3229976737920d-01,-6.6979421292793d-01,
     |  -1.2379946081709d+00,-6.9547244948973d-01, 4.4838244955431d-01,
     |   1.0794630943820d+00, 5.7741328404221d-01,-5.0249697941772d-01,
     |  -9.8777409903080d-01,-3.6429273045002d-01, 6.4161903401442d-01,
     |   8.7981942336301d-01, 9.5935475808942d-02,-7.7538293428252d-01,
     |  -7.0998386392071d-01, 1.9592775070926d-01, 8.4712007758221d-01,
     |   4.6670049689557d-01,-4.7101217325032d-01,-8.2204112833586d-01,
     |  -1.6591889747929d-01, 6.8586466442310d-01, 6.8792423301417d-01,
     |  -1.5667887149445d-01,-8.0377451283116d-01,-4.5578847592809d-01,
     |   4.5578847592809d-01, 8.0377451283116d-01, 1.5667887149446d-01,
     |  -6.8792423301417d-01,-6.8586466442310d-01, 1.6591889747929d-01,
     |   8.2204112833586d-01, 4.7101217325032d-01,-4.6670049689557d-01,
     |  -8.4712007758221d-01,-1.9592775070926d-01, 7.0998386392070d-01,
     |   7.7538293428252d-01,-9.5935475808942d-02,-8.7981942336301d-01,
     |  -6.4161903401443d-01, 3.6429273045001d-01, 9.8777409903080d-01,
     |   5.0249697941772d-01,-5.7741328404220d-01,-1.0794630943820d+00,
     |  -4.4838244955431d-01, 6.9547244948974d-01, 1.2379946081709d+00,
     |   6.6979421292793d-01,-5.3229976737920d-01,-1.4781760751563d+00,
     |  -1.6648457019621d+00,-1.2380226803047d+00,-6.5528911134506d-01,
     |  -2.4484767758372d-01,-6.0646874229368d-02,-8.6658998425897d-03,
     |  -5.2831840866254d-04,-6.1926626088831d-06,-3.3904247534024d-10/
      data (pmn(lat,10,28), lat = 1,72)/
     |   9.9467048615500d-12, 5.4909697631014d-07, 7.9276608185451d-05,
     |   1.8647340132064d-03, 1.7365075724445d-02, 8.9851009098019d-02,
     |   3.0340218330503d-01, 7.2569160571720d-01, 1.2739947726839d+00,
     |   1.6303953167424d+00, 1.3946446465005d+00, 4.6880081023936d-01,
     |  -6.6960774708467d-01,-1.2095026189736d+00,-7.0875538802310d-01,
     |   3.8755178246752d-01, 1.0517896670599d+00, 6.4674424145731d-01,
     |  -3.9465833596094d-01,-9.7555552307477d-01,-4.8877439409385d-01,
     |   5.1228928792993d-01, 9.1071446718164d-01, 2.7303583149246d-01,
     |  -6.5693268375098d-01,-8.0807530961705d-01,-1.8956512956698d-02,
     |   7.7605291056198d-01, 6.4401563995970d-01,-2.4761725477058d-01,
     |  -8.3281040972098d-01,-4.1723770217951d-01, 4.9432435592765d-01,
     |   8.0535500756179d-01, 1.4464881873135d-01,-6.8863016148328d-01,
     |  -6.8863016148328d-01, 1.4464881873135d-01, 8.0535500756179d-01,
     |   4.9432435592765d-01,-4.1723770217950d-01,-8.3281040972098d-01,
     |  -2.4761725477059d-01, 6.4401563995969d-01, 7.7605291056198d-01,
     |  -1.8956512956696d-02,-8.0807530961705d-01,-6.5693268375098d-01,
     |   2.7303583149245d-01, 9.1071446718164d-01, 5.1228928792993d-01,
     |  -4.8877439409384d-01,-9.7555552307477d-01,-3.9465833596095d-01,
     |   6.4674424145730d-01, 1.0517896670599d+00, 3.8755178246753d-01,
     |  -7.0875538802310d-01,-1.2095026189736d+00,-6.6960774708468d-01,
     |   4.6880081023936d-01, 1.3946446465005d+00, 1.6303953167424d+00,
     |   1.2739947726839d+00, 7.2569160571720d-01, 3.0340218330503d-01,
     |   8.9851009098020d-02, 1.7365075724445d-02, 1.8647340132064d-03,
     |   7.9276608185451d-05, 5.4909697631014d-07, 9.9467048615500d-12/
      data (pmn(lat,11,28), lat = 1,72)/
     |   2.6154589843894d-13, 4.3585776425854d-08, 1.0622446556613d-05,
     |   3.5682577734275d-04, 4.3938995580363d-03, 2.8863406913666d-02,
     |   1.2118604326270d-01, 3.5820073970118d-01, 7.8455258348467d-01,
     |   1.2979075738917d+00, 1.5949354754045d+00, 1.3242972524988d+00,
     |   4.2254307664483d-01,-6.6108322825702d-01,-1.1843795141731d+00,
     |  -7.3022981653133d-01, 3.1973981869461d-01, 1.0195807382949d+00,
     |   7.1656090586382d-01,-2.7635930784198d-01,-9.4681001622810d-01,
     |  -6.0872261546667d-01, 3.6204963051165d-01, 9.1141614653608d-01,
     |   4.4797390243310d-01,-4.9950638460843d-01,-8.6539883361385d-01,
     |  -2.4549501650871d-01, 6.4269559070290d-01, 7.7918835176953d-01,
     |   1.4436612616331d-02,-7.5821413884428d-01,-6.4022294737096d-01,
     |   2.2547352170707d-01, 8.2230046551188d-01, 4.5089322313227d-01,
     |  -4.5089322313227d-01,-8.2230046551188d-01,-2.2547352170707d-01,
     |   6.4022294737096d-01, 7.5821413884428d-01,-1.4436612616334d-02,
     |  -7.7918835176953d-01,-6.4269559070290d-01, 2.4549501650870d-01,
     |   8.6539883361385d-01, 4.9950638460844d-01,-4.4797390243309d-01,
     |  -9.1141614653608d-01,-3.6204963051165d-01, 6.0872261546667d-01,
     |   9.4681001622811d-01, 2.7635930784198d-01,-7.1656090586381d-01,
     |  -1.0195807382949d+00,-3.1973981869462d-01, 7.3022981653134d-01,
     |   1.1843795141731d+00, 6.6108322825701d-01,-4.2254307664482d-01,
     |  -1.3242972524988d+00,-1.5949354754045d+00,-1.2979075738917d+00,
     |  -7.8455258348468d-01,-3.5820073970118d-01,-1.2118604326270d-01,
     |  -2.8863406913667d-02,-4.3938995580363d-03,-3.5682577734275d-04,
     |  -1.0622446556613d-05,-4.3585776425854d-08,-2.6154589843894d-13/
      data (pmn(lat,12,28), lat = 1,72)/
     |   6.2039021881974d-15, 3.1181039111616d-09, 1.2803306812900d-06,
     |   6.1230649183719d-05, 9.9242034207770d-04, 8.2211861383130d-03,
     |   4.2498448438084d-02, 1.5291569876016d-01, 4.0762533055933d-01,
     |   8.3200518722025d-01, 1.3115522540656d+00, 1.5601695071919d+00,
     |   1.2678197463464d+00, 3.9420974134316d-01,-6.4262854518430d-01,
     |  -1.1613743905305d+00,-7.6107507953378d-01, 2.4143379485468d-01,
     |   9.7970790710052d-01, 7.8674064007248d-01,-1.4447636185958d-01,
     |  -8.9706506788702d-01,-7.2123596448366d-01, 1.8917874674117d-01,
     |   8.7481901389260d-01, 6.1322453043702d-01,-3.0199258081370d-01,
     |  -8.6904927795818d-01,-4.7029256791983d-01, 4.4319717650314d-01,
     |   8.4915543906034d-01, 2.9669392909863d-01,-5.8539130851408d-01,
     |  -7.9744626559239d-01,-1.0149976660224d-01, 7.0798148070869d-01,
     |   7.0798148070870d-01,-1.0149976660223d-01,-7.9744626559239d-01,
     |  -5.8539130851409d-01, 2.9669392909862d-01, 8.4915543906034d-01,
     |   4.4319717650315d-01,-4.7029256791982d-01,-8.6904927795818d-01,
     |  -3.0199258081371d-01, 6.1322453043701d-01, 8.7481901389260d-01,
     |   1.8917874674118d-01,-7.2123596448366d-01,-8.9706506788702d-01,
     |  -1.4447636185959d-01, 7.8674064007248d-01, 9.7970790710052d-01,
     |   2.4143379485468d-01,-7.6107507953377d-01,-1.1613743905306d+00,
     |  -6.4262854518429d-01, 3.9420974134316d-01, 1.2678197463464d+00,
     |   1.5601695071919d+00, 1.3115522540656d+00, 8.3200518722026d-01,
     |   4.0762533055934d-01, 1.5291569876016d-01, 4.2498448438084d-02,
     |   8.2211861383132d-03, 9.9242034207770d-04, 6.1230649183719d-05,
     |   1.2803306812900d-06, 3.1181039111616d-09, 6.2039021881974d-15/
      data (pmn(lat,13,28), lat = 1,72)/
     |   1.3340706891119d-16, 2.0207896892402d-10, 1.3959073909177d-07,
     |   9.4816258362403d-06, 2.0157086701257d-04, 2.0953672045475d-03,
     |   1.3243079387212d-02, 5.7420033731726d-02, 1.8343915544749d-01,
     |   4.5039444189223d-01, 8.6827646400009d-01, 1.3164697113076d+00,
     |   1.5275620892446d+00, 1.2259007484755d+00, 3.8459370715685d-01,
     |  -6.1247273683621d-01,-1.1387390176254d+00,-8.0173721713614d-01,
     |   1.4926965639136d-01, 9.2788460554782d-01, 8.5531979316104d-01,
     |   3.4130230474969d-03,-8.2018736690052d-01,-8.2036944003019d-01,
     |  -6.3687139558081d-03, 7.9193160554349d-01, 7.5657296080230d-01,
     |  -6.6732577543003d-02,-8.0393872434691d-01,-6.7226641836486d-01,
     |   1.8000695309887d-01, 8.2725991127748d-01, 5.6740128785296d-01,
     |  -3.1139719779629d-01,-8.4344124045887d-01,-4.4459154843608d-01,
     |   4.4459154843607d-01, 8.4344124045887d-01, 3.1139719779630d-01,
     |  -5.6740128785296d-01,-8.2725991127748d-01,-1.8000695309887d-01,
     |   6.7226641836486d-01, 8.0393872434691d-01, 6.6732577543006d-02,
     |  -7.5657296080230d-01,-7.9193160554349d-01, 6.3687139558018d-03,
     |   8.2036944003018d-01, 8.2018736690052d-01,-3.4130230474969d-03,
     |  -8.5531979316104d-01,-9.2788460554783d-01,-1.4926965639137d-01,
     |   8.0173721713614d-01, 1.1387390176254d+00, 6.1247273683622d-01,
     |  -3.8459370715685d-01,-1.2259007484755d+00,-1.5275620892446d+00,
     |  -1.3164697113076d+00,-8.6827646400009d-01,-4.5039444189223d-01,
     |  -1.8343915544749d-01,-5.7420033731727d-02,-1.3243079387212d-02,
     |  -2.0953672045476d-03,-2.0157086701257d-04,-9.4816258362403d-06,
     |  -1.3959073909177d-07,-2.0207896892402d-10,-1.3340706891119d-16/
      data (pmn(lat,14,28), lat = 1,72)/
     |   2.6103313104785d-18, 1.1909824005032d-11, 1.3823885425031d-08,
     |   1.3311301935286d-06, 3.7017493018664d-05, 4.8105676182943d-04,
     |   3.6979274548540d-03, 1.9181435696256d-02, 7.2679286458361d-02,
     |   2.1131043145982d-01, 4.8549487895699d-01, 8.9363084457008d-01,
     |   1.3139118366707d+00, 1.4982289201469d+00, 1.1990864933841d+00,
     |   3.9460243316479d-01,-5.6843178308926d-01,-1.1139079853049d+00,
     |  -8.5170022307023d-01, 4.0106481700893d-02, 8.5851417686651d-01,
     |   9.1798107623128d-01, 1.6828142803565d-01,-7.0870930540064d-01,
     |  -8.9630764032396d-01,-2.2120644647148d-01, 6.5300063581368d-01,
     |   8.5991913931673d-01, 1.9721096520212d-01,-6.5522547579735d-01,
     |  -8.2087337302732d-01,-1.3230043014588d-01, 6.8781222323975d-01,
     |   7.7840848907516d-01, 4.6308292358250d-02,-7.3249187270658d-01,
     |  -7.3249187270658d-01, 4.6308292358247d-02, 7.7840848907516d-01,
     |   6.8781222323976d-01,-1.3230043014588d-01,-8.2087337302732d-01,
     |  -6.5522547579735d-01, 1.9721096520212d-01, 8.5991913931673d-01,
     |   6.5300063581368d-01,-2.2120644647148d-01,-8.9630764032396d-01,
     |  -7.0870930540064d-01, 1.6828142803565d-01, 9.1798107623128d-01,
     |   8.5851417686652d-01, 4.0106481700895d-02,-8.5170022307023d-01,
     |  -1.1139079853049d+00,-5.6843178308927d-01, 3.9460243316479d-01,
     |   1.1990864933841d+00, 1.4982289201469d+00, 1.3139118366707d+00,
     |   8.9363084457008d-01, 4.8549487895699d-01, 2.1131043145983d-01,
     |   7.2679286458362d-02, 1.9181435696256d-02, 3.6979274548540d-03,
     |   4.8105676182944d-04, 3.7017493018664d-05, 1.3311301935286d-06,
     |   1.3823885425031d-08, 1.1909824005032d-11, 2.6103313104785d-18/
      data (pmn(lat,15,28), lat = 1,72)/
     |   4.6596378518832d-20, 6.4006956544339d-13, 1.2471696241323d-09,
     |   1.6999111326484d-07, 6.1705022234841d-06, 9.9951091985168d-05,
     |   9.3079708149699d-04, 5.7449311177311d-03, 2.5626305434642d-02,
     |   8.7297117100465d-02, 2.3525111482292d-01, 5.1212514049992d-01,
     |   9.0830006563195d-01, 1.3047671634366d+00, 1.4728141228320d+00,
     |   1.1876393159523d+00, 4.2522957362539d-01,-5.0772785922153d-01,
     |  -1.0831469186847d+00,-9.0907946668423d-01,-8.8666889916611d-02,
     |   7.6463711257373d-01, 9.6736300167401d-01, 3.4845402497033d-01,
     |  -5.5464596175999d-01,-9.3462876580405d-01,-4.4607145693081d-01,
     |   4.4988726928064d-01, 8.9881875034748d-01, 4.6977652978064d-01,
     |  -4.1337331827662d-01,-8.7631176645546d-01,-4.5963476632351d-01,
     |   4.1584308344305d-01, 8.6629698863596d-01, 4.3657362886923d-01,
     |  -4.3657362886923d-01,-8.6629698863596d-01,-4.1584308344305d-01,
     |   4.5963476632351d-01, 8.7631176645546d-01, 4.1337331827661d-01,
     |  -4.6977652978064d-01,-8.9881875034748d-01,-4.4988726928064d-01,
     |   4.4607145693080d-01, 9.3462876580405d-01, 5.5464596176000d-01,
     |  -3.4845402497033d-01,-9.6736300167401d-01,-7.6463711257373d-01,
     |   8.8666889916598d-02, 9.0907946668423d-01, 1.0831469186847d+00,
     |   5.0772785922153d-01,-4.2522957362539d-01,-1.1876393159523d+00,
     |  -1.4728141228320d+00,-1.3047671634366d+00,-9.0830006563196d-01,
     |  -5.1212514049992d-01,-2.3525111482292d-01,-8.7297117100466d-02,
     |  -2.5626305434643d-02,-5.7449311177311d-03,-9.3079708149699d-04,
     |  -9.9951091985171d-05,-6.1705022234841d-06,-1.6999111326484d-07,
     |  -1.2471696241323d-09,-6.4006956544339d-13,-4.6596378518832d-20/
      data (pmn(lat,16,28), lat = 1,72)/
     |   7.6007973065151d-22, 3.1421957112976d-14, 1.0269857194034d-10,
     |   1.9789851751968d-08, 9.3603141068463d-07, 1.8854464918886d-05,
     |   2.1204622640556d-04, 1.5508489679434d-03, 8.0990764197378d-03,
     |   3.2081874214649d-02, 1.0032023604333d-01, 2.5415812066373d-01,
     |   5.2964366971018d-01, 9.1240625894219d-01, 1.2894658600948d+00,
     |   1.4513479854001d+00, 1.1913650156067d+00, 4.7745722085961d-01,
     |  -4.2688385269248d-01,-1.0411747797881d+00,-9.7000382487318d-01,
     |  -2.3848132485495d-01, 6.3814623418466d-01, 9.9228825614001d-01,
     |   5.3782273682205d-01,-3.5121263820395d-01,-9.1610747931465d-01,
     |  -6.6272849276041d-01, 1.8039951231723d-01, 8.4394501911926d-01,
     |   7.1524360240517d-01,-8.2921562273781d-02,-7.9435811891669d-01,
     |  -7.4143396344471d-01, 2.3715710811169d-02, 7.6340425970142d-01,
     |   7.6340425970142d-01, 2.3715710811172d-02,-7.4143396344471d-01,
     |  -7.9435811891669d-01,-8.2921562273784d-02, 7.1524360240517d-01,
     |   8.4394501911926d-01, 1.8039951231724d-01,-6.6272849276041d-01,
     |  -9.1610747931465d-01,-3.5121263820396d-01, 5.3782273682204d-01,
     |   9.9228825614001d-01, 6.3814623418466d-01,-2.3848132485495d-01,
     |  -9.7000382487318d-01,-1.0411747797881d+00,-4.2688385269248d-01,
     |   4.7745722085961d-01, 1.1913650156067d+00, 1.4513479854001d+00,
     |   1.2894658600948d+00, 9.1240625894219d-01, 5.2964366971018d-01,
     |   2.5415812066373d-01, 1.0032023604333d-01, 3.2081874214649d-02,
     |   8.0990764197380d-03, 1.5508489679434d-03, 2.1204622640556d-04,
     |   1.8854464918887d-05, 9.3603141068463d-07, 1.9789851751968d-08,
     |   1.0269857194034d-10, 3.1421957112976d-14, 7.6007973065151d-22/
      data (pmn(lat,17,28), lat = 1,72)/
     |   1.1337541974705d-23, 1.4101122524950d-15, 7.7256469586326d-12,
     |   2.1025691889337d-09, 1.2939967205077d-07, 3.2350768102895d-06,
     |   4.3829100138351d-05, 3.7861213825165d-04, 2.3050107835221d-03,
     |   1.0557236076249d-02, 3.8013319781165d-02, 1.1086882341372d-01,
     |   2.6710873561589d-01, 5.3752305244686d-01, 9.0588712446747d-01,
     |   1.2678747328734d+00, 1.4330775864303d+00, 1.2093756489269d+00,
     |   5.5203913107864d-01,-3.2174706841302d-01,-9.8079983025349d-01,
     |  -1.0277622159114d+00,-4.0844035705970d-01, 4.7054687544647d-01,
     |   9.7715847902116d-01, 7.2341751655986d-01,-9.5990792411917d-02,
     |  -8.1792291839709d-01,-8.4073955227668d-01,-1.4475572903490d-01,
     |   6.6645693759435d-01, 8.7918947696881d-01, 3.0469343940789d-01,
     |  -5.3980468132872d-01,-8.8945512974620d-01,-4.2638453800490d-01,
     |   4.2638453800490d-01, 8.8945512974620d-01, 5.3980468132872d-01,
     |  -3.0469343940789d-01,-8.7918947696881d-01,-6.6645693759435d-01,
     |   1.4475572903490d-01, 8.4073955227667d-01, 8.1792291839709d-01,
     |   9.5990792411918d-02,-7.2341751655986d-01,-9.7715847902116d-01,
     |  -4.7054687544647d-01, 4.0844035705970d-01, 1.0277622159114d+00,
     |   9.8079983025349d-01, 3.2174706841302d-01,-5.5203913107864d-01,
     |  -1.2093756489269d+00,-1.4330775864303d+00,-1.2678747328734d+00,
     |  -9.0588712446747d-01,-5.3752305244686d-01,-2.6710873561590d-01,
     |  -1.1086882341372d-01,-3.8013319781165d-02,-1.0557236076250d-02,
     |  -2.3050107835221d-03,-3.7861213825165d-04,-4.3829100138351d-05,
     |  -3.2350768102896d-06,-1.2939967205077d-07,-2.1025691889337d-09,
     |  -7.7256469586326d-12,-1.4101122524950d-15,-1.1337541974705d-23/
      data (pmn(lat,18,28), lat = 1,72)/
     |   1.5460339023873d-25, 5.7835977570254d-17, 5.3087451180089d-13,
     |   2.0388097455829d-10, 1.6307243985767d-08, 5.0521501719564d-07,
     |   8.2286636697013d-06, 8.3736678506566d-05, 5.9230337361238d-04,
     |   3.1230606588462d-03, 1.2874447765217d-02, 4.2893396884055d-02,
     |   1.1817881959276d-01, 2.7336696644063d-01, 5.3531629088603d-01,
     |   8.8843506258820d-01, 1.2391940120208d+00, 1.4162664709470d+00,
     |   1.2397554554717d+00, 6.4909890848107d-01,-1.8773973795699d-01,
     |  -8.9267082192268d-01,-1.0717382840371d+00,-5.9350257648492d-01,
     |   2.5468973642904d-01, 9.0204255548886d-01, 8.8254493658670d-01,
     |   2.0387000521247d-01,-6.1772832106315d-01,-9.3561118740262d-01,
     |  -4.9238853509111d-01, 3.4999306989118d-01, 8.9149597133023d-01,
     |   6.7658257243684d-01,-1.1261599970455d-01,-8.0269774108496d-01,
     |  -8.0269774108496d-01,-1.1261599970455d-01, 6.7658257243684d-01,
     |   8.9149597133023d-01, 3.4999306989118d-01,-4.9238853509111d-01,
     |  -9.3561118740262d-01,-6.1772832106316d-01, 2.0387000521247d-01,
     |   8.8254493658670d-01, 9.0204255548886d-01, 2.5468973642904d-01,
     |  -5.9350257648492d-01,-1.0717382840371d+00,-8.9267082192268d-01,
     |  -1.8773973795700d-01, 6.4909890848106d-01, 1.2397554554717d+00,
     |   1.4162664709470d+00, 1.2391940120208d+00, 8.8843506258820d-01,
     |   5.3531629088603d-01, 2.7336696644063d-01, 1.1817881959276d-01,
     |   4.2893396884055d-02, 1.2874447765217d-02, 3.1230606588462d-03,
     |   5.9230337361239d-04, 8.3736678506567d-05, 8.2286636697013d-06,
     |   5.0521501719566d-07, 1.6307243985767d-08, 2.0388097455829d-10,
     |   5.3087451180089d-13, 5.7835977570254d-17, 1.5460339023873d-25/
      data (pmn(lat,19,28), lat = 1,72)/
     |   1.9248611836542d-27, 2.1653290661598d-18, 3.3283510246269d-14,
     |   1.8024887738594d-11, 1.8718257753777d-09, 7.1768673754981d-08,
     |   1.4029094257872d-06, 1.6781827928358d-05, 1.3754322735079d-04,
     |   8.3202518366866d-04, 3.9095131487100d-03, 1.4792957238901d-02,
     |   4.6248038887089d-02, 1.2164176900881d-01, 2.7239707393233d-01,
     |   5.2264531296806d-01, 8.5946675369623d-01, 1.2018742444392d+00,
     |   1.3979697775973d+00, 1.2791043759579d+00, 7.6746165076514d-01,
     |  -2.0492204480427d-02,-7.6535107539245d-01,-1.0862783564556d+00,
     |  -7.8186566882244d-01,-1.1932981232296d-02, 7.4444144128754d-01,
     |   9.8031979050421d-01, 5.2414119062877d-01,-3.0264599925719d-01,
     |  -8.9158487965771d-01,-7.9663485192306d-01,-8.8295125251831d-02,
     |   6.8314028145306d-01, 9.1063395305831d-01, 4.1332837486571d-01,
     |  -4.1332837486571d-01,-9.1063395305831d-01,-6.8314028145306d-01,
     |   8.8295125251829d-02, 7.9663485192305d-01, 8.9158487965771d-01,
     |   3.0264599925719d-01,-5.2414119062876d-01,-9.8031979050421d-01,
     |  -7.4444144128754d-01, 1.1932981232293d-02, 7.8186566882244d-01,
     |   1.0862783564556d+00, 7.6535107539245d-01, 2.0492204480427d-02,
     |  -7.6746165076513d-01,-1.2791043759579d+00,-1.3979697775973d+00,
     |  -1.2018742444392d+00,-8.5946675369623d-01,-5.2264531296806d-01,
     |  -2.7239707393233d-01,-1.2164176900881d-01,-4.6248038887090d-02,
     |  -1.4792957238901d-02,-3.9095131487100d-03,-8.3202518366867d-04,
     |  -1.3754322735080d-04,-1.6781827928358d-05,-1.4029094257872d-06,
     |  -7.1768673754983d-08,-1.8718257753777d-09,-1.8024887738594d-11,
     |  -3.3283510246269d-14,-2.1653290661598d-18,-1.9248611836542d-27/
      data (pmn(lat,20,28), lat = 1,72)/
     |   2.1826587579736d-29, 7.3819495850451d-20, 1.8993966964864d-15,
     |   1.4496154114529d-12, 1.9528455849526d-10, 9.2561361765068d-09,
     |   2.1684611776009d-07, 3.0437695804089d-06, 2.8841441324359d-05,
     |   1.9960244756648d-04, 1.0652855173039d-03, 4.5574747524760d-03,
     |   1.6073999114874d-02, 4.7700522694548d-02, 1.2084533990323d-01,
     |   2.6389161594071d-01, 4.9922544975059d-01, 8.1814645504337d-01,
     |   1.1535847757707d+00, 1.3738126341998d+00, 1.3219549731546d+00,
     |   9.0363366488460d-01, 1.8291732667038d-01,-5.8608877849203d-01,
     |  -1.0498872784760d+00,-9.5163851071255d-01,-3.2166875335118d-01,
     |   4.8433785392528d-01, 9.6961480789686d-01, 8.1461540067233d-01,
     |   1.1471423733792d-01,-6.5477144252196d-01,-9.5472512308475d-01,
     |  -5.6892824669839d-01, 2.2658730018464d-01, 8.5374655489862d-01,
     |   8.5374655489862d-01, 2.2658730018464d-01,-5.6892824669839d-01,
     |  -9.5472512308475d-01,-6.5477144252196d-01, 1.1471423733793d-01,
     |   8.1461540067233d-01, 9.6961480789686d-01, 4.8433785392529d-01,
     |  -3.2166875335118d-01,-9.5163851071255d-01,-1.0498872784760d+00,
     |  -5.8608877849203d-01, 1.8291732667038d-01, 9.0363366488460d-01,
     |   1.3219549731546d+00, 1.3738126341998d+00, 1.1535847757707d+00,
     |   8.1814645504337d-01, 4.9922544975059d-01, 2.6389161594071d-01,
     |   1.2084533990323d-01, 4.7700522694547d-02, 1.6073999114874d-02,
     |   4.5574747524760d-03, 1.0652855173039d-03, 1.9960244756648d-04,
     |   2.8841441324360d-05, 3.0437695804089d-06, 2.1684611776009d-07,
     |   9.2561361765071d-09, 1.9528455849526d-10, 1.4496154114529d-12,
     |   1.8993966964864d-15, 7.3819495850451d-20, 2.1826587579736d-29/
      data (pmn(lat,21,28), lat = 1,72)/
     |   2.2453034471536d-31, 2.2826952100160d-21, 9.8284187494680d-17,
     |   1.0565418058281d-13, 1.8450576363113d-11, 1.0800745598703d-09,
     |   3.0288828678973d-08, 4.9813138236147d-07, 5.4469161153160d-06,
     |   4.3028663382954d-05, 2.6009955827809d-04, 1.2536669224723d-03,
     |   4.9657983780712d-03, 1.6530055170410d-02, 4.7013663672885d-02,
     |   1.1561734901549d-01, 2.4782173057505d-01, 4.6494242679535d-01,
     |   7.6349506228893d-01, 1.0912864100870d+00, 1.3378384830543d+00,
     |   1.3601091410569d+00, 1.0503758787245d+00, 4.2183847024166d-01,
     |  -3.4288328237095d-01,-9.3559443754332d-01,-1.0674499298954d+00,
     |  -6.4859958427857d-01, 1.1472933641283d-01, 7.9741080375323d-01,
     |   9.9267991283841d-01, 5.7316353142299d-01,-2.0418568574761d-01,
     |  -8.4302862339378d-01,-9.2596232189417d-01,-3.9626851430623d-01,
     |   3.9626851430623d-01, 9.2596232189417d-01, 8.4302862339378d-01,
     |   2.0418568574761d-01,-5.7316353142298d-01,-9.9267991283841d-01,
     |  -7.9741080375323d-01,-1.1472933641284d-01, 6.4859958427857d-01,
     |   1.0674499298954d+00, 9.3559443754332d-01, 3.4288328237095d-01,
     |  -4.2183847024166d-01,-1.0503758787245d+00,-1.3601091410569d+00,
     |  -1.3378384830543d+00,-1.0912864100870d+00,-7.6349506228894d-01,
     |  -4.6494242679535d-01,-2.4782173057505d-01,-1.1561734901550d-01,
     |  -4.7013663672885d-02,-1.6530055170410d-02,-4.9657983780713d-03,
     |  -1.2536669224723d-03,-2.6009955827809d-04,-4.3028663382954d-05,
     |  -5.4469161153161d-06,-4.9813138236148d-07,-3.0288828678973d-08,
     |  -1.0800745598704d-09,-1.8450576363113d-11,-1.0565418058281d-13,
     |  -9.8284187494680d-17,-2.2826952100160d-21,-2.2453034471536d-31/
      data (pmn(lat,22,28), lat = 1,72)/
     |   2.0832622500100d-33, 6.3656236459822d-23, 4.5849975981877d-18,
     |   6.9392224160909d-15, 1.5698965156651d-12, 1.1340808333076d-10,
     |   3.8030728595789d-09, 7.3189045001148d-08, 9.2209942131552d-07,
     |   8.2988018389652d-06, 5.6684582686984d-05, 3.0693305849623d-04,
     |   1.3605263619456d-03, 5.0573747995537d-03, 1.6055094092959d-02,
     |   4.4128801589701d-02, 1.0607461836500d-01, 2.2451573675329d-01,
     |   4.1999903606406d-01, 6.9462599365582d-01, 1.0114897617733d+00,
     |   1.2825569858084d+00, 1.3820425247318d+00, 1.1949269490897d+00,
     |   6.8878539260744d-01,-2.8685239867883d-02,-7.1402745168189d-01,
     |  -1.0788222810909d+00,-9.3871173915360d-01,-3.4031719911208d-01,
     |   4.2392323974453d-01, 9.4889523822369d-01, 9.3983224789290d-01,
     |   3.9482424661458d-01,-3.7604791508634d-01,-9.2293201750158d-01,
     |  -9.2293201750158d-01,-3.7604791508635d-01, 3.9482424661457d-01,
     |   9.3983224789290d-01, 9.4889523822369d-01, 4.2392323974452d-01,
     |  -3.4031719911208d-01,-9.3871173915359d-01,-1.0788222810909d+00,
     |  -7.1402745168189d-01,-2.8685239867886d-02, 6.8878539260744d-01,
     |   1.1949269490897d+00, 1.3820425247318d+00, 1.2825569858084d+00,
     |   1.0114897617733d+00, 6.9462599365582d-01, 4.1999903606406d-01,
     |   2.2451573675329d-01, 1.0607461836500d-01, 4.4128801589701d-02,
     |   1.6055094092959d-02, 5.0573747995537d-03, 1.3605263619456d-03,
     |   3.0693305849623d-04, 5.6684582686984d-05, 8.2988018389654d-06,
     |   9.2209942131554d-07, 7.3189045001149d-08, 3.8030728595789d-09,
     |   1.1340808333076d-10, 1.5698965156651d-12, 6.9392224160909d-15,
     |   4.5849975981877d-18, 6.3656236459822d-23, 2.0832622500100d-33/
      data (pmn(lat,23,28), lat = 1,72)/
     |   1.7287311879692d-35, 1.5874244126421d-24, 1.9122347885026d-19,
     |   4.0729547069240d-16, 1.1930838614423d-13, 1.0628390833847d-11,
     |   4.2583013426260d-10, 9.5791118784661d-09, 1.3886917584127d-07,
     |   1.4215941437698d-06, 1.0950824856782d-05, 6.6455897688734d-05,
     |   3.2869724490238d-04, 1.3595504989524d-03, 4.7960066155374d-03,
     |   1.4649680035292d-02, 3.9198657468341d-02, 9.2674428206442d-02,
     |   1.9476671840369d-01, 3.6514387914078d-01, 6.1115313812277d-01,
     |   9.1081265255630d-01, 1.1994109987836d+00, 1.3727033533855d+00,
     |   1.3171951981908d+00, 9.6501941838210d-01, 3.5135814135122d-01,
     |  -3.6158639681659d-01,-9.2420450586968d-01,-1.1023186179757d+00,
     |  -8.0073106390698d-01,-1.3823013962741d-01, 5.8222290200264d-01,
     |   1.0103664231932d+00, 9.2830352396828d-01, 3.7314738443467d-01,
     |  -3.7314738443467d-01,-9.2830352396827d-01,-1.0103664231932d+00,
     |  -5.8222290200264d-01, 1.3823013962740d-01, 8.0073106390698d-01,
     |   1.1023186179757d+00, 9.2420450586968d-01, 3.6158639681659d-01,
     |  -3.5135814135121d-01,-9.6501941838210d-01,-1.3171951981908d+00,
     |  -1.3727033533855d+00,-1.1994109987836d+00,-9.1081265255630d-01,
     |  -6.1115313812278d-01,-3.6514387914078d-01,-1.9476671840369d-01,
     |  -9.2674428206442d-02,-3.9198657468341d-02,-1.4649680035292d-02,
     |  -4.7960066155374d-03,-1.3595504989524d-03,-3.2869724490238d-04,
     |  -6.6455897688734d-05,-1.0950824856782d-05,-1.4215941437698d-06,
     |  -1.3886917584127d-07,-9.5791118784662d-09,-4.2583013426260d-10,
     |  -1.0628390833848d-11,-1.1930838614423d-13,-4.0729547069240d-16,
     |  -1.9122347885026d-19,-1.5874244126421d-24,-1.7287311879692d-35/
      data (pmn(lat,24,28), lat = 1,72)/
     |   1.2672067014873d-37, 3.4964937269085d-26, 7.0425854517174d-21,
     |   2.1103101045062d-17, 8.0002302368692d-15, 8.7832648452088d-13,
     |   4.2011653804593d-11, 1.1036402747120d-09, 1.8389178025134d-08,
     |   2.1383005430007d-07, 1.8545844639417d-06, 1.2588730715105d-05,
     |   6.9311743010130d-05, 3.1807365702005d-04, 1.2424081918460d-03,
     |   4.1988797374188d-03, 1.2436783903173d-02, 3.2608190266322d-02,
     |   7.6259764187465d-02, 1.5995809418044d-01, 3.0197863027575d-01,
     |   5.1380441459191d-01, 7.8696855799458d-01, 1.0799859450184d+00,
     |   1.3143046671723d+00, 1.3887519738197d+00, 1.2156667998753d+00,
     |   7.6923071210002d-01, 1.2337684355334d-01,-5.4739771221962d-01,
     |  -1.0188684253902d+00,-1.1078589582626d+00,-7.6394027510902d-01,
     |  -1.1265827258599d-01, 5.8153600809032d-01, 1.0244806064003d+00,
     |   1.0244806064003d+00, 5.8153600809032d-01,-1.1265827258598d-01,
     |  -7.6394027510902d-01,-1.1078589582626d+00,-1.0188684253902d+00,
     |  -5.4739771221963d-01, 1.2337684355334d-01, 7.6923071210002d-01,
     |   1.2156667998753d+00, 1.3887519738197d+00, 1.3143046671723d+00,
     |   1.0799859450184d+00, 7.8696855799458d-01, 5.1380441459191d-01,
     |   3.0197863027575d-01, 1.5995809418044d-01, 7.6259764187465d-02,
     |   3.2608190266322d-02, 1.2436783903173d-02, 4.1988797374189d-03,
     |   1.2424081918460d-03, 3.1807365702005d-04, 6.9311743010131d-05,
     |   1.2588730715105d-05, 1.8545844639417d-06, 2.1383005430008d-07,
     |   1.8389178025135d-08, 1.1036402747120d-09, 4.2011653804593d-11,
     |   8.7832648452092d-13, 8.0002302368692d-15, 2.1103101045062d-17,
     |   7.0425854517174d-21, 3.4964937269085d-26, 1.2672067014873d-37/
      data (pmn(lat,25,28), lat = 1,72)/
     |   8.0522001677102d-40, 6.6753854059337d-28, 2.2477067158530d-22,
     |   9.4725406143183d-19, 4.6455361320152d-16, 6.2822070040908d-14,
     |   3.5849195692024d-12, 1.0988801707681d-10, 2.1023775113981d-09,
     |   2.7735839856828d-08, 2.7046760064868d-07, 2.0500858261198d-06,
     |   1.2539825565556d-05, 6.3693309006141d-05, 2.7468017336531d-04,
     |   1.0235011748533d-03, 3.3412597460069d-03, 9.6627540968944d-03,
     |   2.4973350506408d-02, 5.8079279771626d-02, 1.2217525158387d-01,
     |   2.3330434140801d-01, 4.0522647686858d-01, 6.4028555143890d-01,
     |   9.1834965011898d-01, 1.1890377012555d+00, 1.3742936453764d+00,
     |   1.3865864684336d+00, 1.1615640624676d+00, 6.9476034050169d-01,
     |   6.4851741293884d-02,-5.7339207840060d-01,-1.0324007359242d+00,
     |  -1.1595908237593d+00,-9.0238213014221d-01,-3.3954274269383d-01,
     |   3.3954274269382d-01, 9.0238213014221d-01, 1.1595908237593d+00,
     |   1.0324007359242d+00, 5.7339207840060d-01,-6.4851741293886d-02,
     |  -6.9476034050169d-01,-1.1615640624676d+00,-1.3865864684336d+00,
     |  -1.3742936453764d+00,-1.1890377012555d+00,-9.1834965011898d-01,
     |  -6.4028555143890d-01,-4.0522647686858d-01,-2.3330434140801d-01,
     |  -1.2217525158387d-01,-5.8079279771626d-02,-2.4973350506409d-02,
     |  -9.6627540968945d-03,-3.3412597460070d-03,-1.0235011748533d-03,
     |  -2.7468017336531d-04,-6.3693309006141d-05,-1.2539825565556d-05,
     |  -2.0500858261198d-06,-2.7046760064868d-07,-2.7735839856829d-08,
     |  -2.1023775113981d-09,-1.0988801707681d-10,-3.5849195692024d-12,
     |  -6.2822070040911d-14,-4.6455361320152d-16,-9.4725406143183d-19,
     |  -2.2477067158530d-22,-6.6753854059337d-28,-8.0522001677102d-40/
      data (pmn(lat,26,28), lat = 1,72)/
     |   4.3006402728120d-42, 1.0711073259521d-29, 6.0281314438849d-24,
     |   3.5719403363188d-20, 2.2653011512159d-17, 3.7715392643821d-15,
     |   2.5661533027262d-13, 9.1718047509155d-12, 2.0131066835610d-10,
     |   3.0100722480825d-09, 3.2962532903978d-08, 2.7859733509962d-07,
     |   1.8899736224975d-06, 1.0603955025650d-05, 5.0368635360708d-05,
     |   2.0633296498953d-04, 7.3983166699210d-04, 2.3499369113966d-03,
     |   6.6766738176580d-03, 1.7102796488539d-02, 3.9749228572898d-02,
     |   8.4238874992717d-02, 1.6340048241181d-01, 2.9084934605473d-01,
     |   4.7569655896383d-01, 7.1479784265348d-01, 9.8482752966717d-01,
     |   1.2382642718800d+00, 1.4078102736065d+00, 1.4217120061631d+00,
     |   1.2278833992338d+00, 8.1929564606941d-01, 2.4969156185703d-01,
     |  -3.7001037890368d-01,-8.9759777844907d-01,-1.2010684198448d+00,
     |  -1.2010684198448d+00,-8.9759777844907d-01,-3.7001037890368d-01,
     |   2.4969156185703d-01, 8.1929564606941d-01, 1.2278833992338d+00,
     |   1.4217120061631d+00, 1.4078102736065d+00, 1.2382642718800d+00,
     |   9.8482752966717d-01, 7.1479784265348d-01, 4.7569655896384d-01,
     |   2.9084934605473d-01, 1.6340048241181d-01, 8.4238874992717d-02,
     |   3.9749228572899d-02, 1.7102796488539d-02, 6.6766738176580d-03,
     |   2.3499369113967d-03, 7.3983166699210d-04, 2.0633296498953d-04,
     |   5.0368635360708d-05, 1.0603955025650d-05, 1.8899736224976d-06,
     |   2.7859733509962d-07, 3.2962532903978d-08, 3.0100722480825d-09,
     |   2.0131066835611d-10, 9.1718047509156d-12, 2.5661533027262d-13,
     |   3.7715392643823d-15, 2.2653011512159d-17, 3.5719403363188d-20,
     |   6.0281314438849d-24, 1.0711073259521d-29, 4.3006402728120d-42/
      data (pmn(lat,27,28), lat = 1,72)/
     |   1.8226186950667d-44, 1.3636392916130d-31, 1.2825270312095d-25,
     |   1.0682613228364d-21, 8.7580746283591d-19, 1.7944619442748d-16,
     |   1.4550165678646d-14, 6.0599126667196d-13, 1.5247600709791d-11,
     |   2.5816803659814d-10, 3.1714543062299d-09, 2.9852288948084d-08,
     |   2.2427772538698d-07, 1.3876139092272d-06, 7.2451723049076d-06,
     |   3.2551710582888d-05, 1.2783603363921d-04, 4.4446396004387d-04,
     |   1.3825613847699d-03, 3.8812079333385d-03, 9.9039604350602d-03,
     |   2.3109878939443d-02, 4.9552022595487d-02, 9.8022115857706d-02,
     |   1.7944860195616d-01, 3.0472509088230d-01, 4.8068728421238d-01,
     |   7.0474584365046d-01, 9.5973991825691d-01, 1.2114209450361d+00,
     |   1.4109865913669d+00, 1.5038419643640d+00, 1.4434221162649d+00,
     |   1.2063208511324d+00, 8.0340690991907d-01, 2.8211894387063d-01,
     |  -2.8211894387063d-01,-8.0340690991907d-01,-1.2063208511324d+00,
     |  -1.4434221162649d+00,-1.5038419643640d+00,-1.4109865913669d+00,
     |  -1.2114209450361d+00,-9.5973991825691d-01,-7.0474584365046d-01,
     |  -4.8068728421238d-01,-3.0472509088230d-01,-1.7944860195616d-01,
     |  -9.8022115857707d-02,-4.9552022595487d-02,-2.3109878939443d-02,
     |  -9.9039604350603d-03,-3.8812079333385d-03,-1.3825613847699d-03,
     |  -4.4446396004387d-04,-1.2783603363921d-04,-3.2551710582888d-05,
     |  -7.2451723049075d-06,-1.3876139092272d-06,-2.2427772538698d-07,
     |  -2.9852288948084d-08,-3.1714543062299d-09,-2.5816803659814d-10,
     |  -1.5247600709792d-11,-6.0599126667197d-13,-1.4550165678646d-14,
     |  -1.7944619442748d-16,-8.7580746283591d-19,-1.0682613228364d-21,
     |  -1.2825270312095d-25,-1.3636392916130d-31,-1.8226186950667d-44/
      data (pmn(lat,28,28), lat = 1,72)/
     |   5.3144472209711d-47, 1.1943589693590d-33, 1.8769697404573d-27,
     |   2.1971699507359d-23, 2.3279648267270d-20, 5.8677478829291d-18,
     |   5.6672566559544d-16, 2.7488662782560d-14, 7.9235844104594d-13,
     |   1.5179991525198d-11, 2.0899671232767d-10, 2.1885390413642d-09,
     |   1.8186468001779d-08, 1.2389883358945d-07, 7.0989665491294d-07,
     |   3.4911680986842d-06, 1.4981221025237d-05, 5.6857380927482d-05,
     |   1.9299501729924d-04, 5.9140495563846d-04, 1.6490124129634d-03,
     |   4.2117562792681d-03, 9.9100258123950d-03, 2.1586082162881d-02,
     |   4.3709454895944d-02, 8.2573214646332d-02, 1.4598409757344d-01,
     |   2.4217221717058d-01, 3.7781420584490d-01, 5.5539518270456d-01,
     |   7.7054439692030d-01, 1.0102908037609d+00, 1.2531965257789d+00,
     |   1.4719195163933d+00, 1.6379934724480d+00, 1.7277541494479d+00,
     |   1.7277541494479d+00, 1.6379934724480d+00, 1.4719195163933d+00,
     |   1.2531965257789d+00, 1.0102908037609d+00, 7.7054439692030d-01,
     |   5.5539518270456d-01, 3.7781420584490d-01, 2.4217221717058d-01,
     |   1.4598409757344d-01, 8.2573214646333d-02, 4.3709454895944d-02,
     |   2.1586082162881d-02, 9.9100258123950d-03, 4.2117562792681d-03,
     |   1.6490124129635d-03, 5.9140495563846d-04, 1.9299501729924d-04,
     |   5.6857380927482d-05, 1.4981221025237d-05, 3.4911680986843d-06,
     |   7.0989665491294d-07, 1.2389883358945d-07, 1.8186468001780d-08,
     |   2.1885390413642d-09, 2.0899671232767d-10, 1.5179991525199d-11,
     |   7.9235844104596d-13, 2.7488662782560d-14, 5.6672566559544d-16,
     |   5.8677478829294d-18, 2.3279648267270d-20, 2.1971699507359d-23,
     |   1.8769697404573d-27, 1.1943589693590d-33, 5.3144472209711d-47/
      data (pmn(lat, 0,29), lat = 1,72)/
     |   4.8834948955830d+00, 1.4338328477617d+00,-1.7661589001688d+00,
     |  -1.7376364053487d+00, 4.8709648517936d-01, 1.6345337287579d+00,
     |   4.2678604576613d-01,-1.1849659882310d+00,-9.9584278339375d-01,
     |   5.3260260794553d-01, 1.1849145855547d+00, 1.4646412563117d-01,
     |  -1.0154394955659d+00,-6.8415793580034d-01, 5.8077070291843d-01,
     |   9.5993125365605d-01,-2.7406946627308d-02,-9.2824748365724d-01,
     |  -4.8143135364249d-01, 6.2645792129237d-01, 8.0719908018682d-01,
     |  -1.6109101474515d-01,-8.7046793314642d-01,-3.2354027110180d-01,
     |   6.6905844527003d-01, 6.8579279665377d-01,-2.7518267828270d-01,
     |  -8.2525196246348d-01,-1.8732105119943d-01, 7.0906929527323d-01,
     |   5.7920442814491d-01,-3.7915973155522d-01,-7.8544246073767d-01,
     |  -6.1413078684181d-02, 7.4741360452991d-01, 4.7886915215001d-01,
     |  -4.7886915215001d-01,-7.4741360452991d-01, 6.1413078684178d-02,
     |   7.8544246073767d-01, 3.7915973155522d-01,-5.7920442814491d-01,
     |  -7.0906929527323d-01, 1.8732105119942d-01, 8.2525196246348d-01,
     |   2.7518267828270d-01,-6.8579279665377d-01,-6.6905844527003d-01,
     |   3.2354027110179d-01, 8.7046793314642d-01, 1.6109101474515d-01,
     |  -8.0719908018681d-01,-6.2645792129237d-01, 4.8143135364249d-01,
     |   9.2824748365724d-01, 2.7406946627317d-02,-9.5993125365605d-01,
     |  -5.8077070291842d-01, 6.8415793580035d-01, 1.0154394955659d+00,
     |  -1.4646412563117d-01,-1.1849145855547d+00,-5.3260260794554d-01,
     |   9.9584278339374d-01, 1.1849659882310d+00,-4.2678604576613d-01,
     |  -1.6345337287579d+00,-4.8709648517936d-01, 1.7376364053487d+00,
     |   1.7661589001688d+00,-1.4338328477617d+00,-4.8834948955830d+00/
      data (pmn(lat, 1,29), lat = 1,72)/
     |   1.6587017880154d+00, 3.1526050708988d+00, 1.3825676796067d+00,
     |  -1.2639750669888d+00,-1.7014508857505d+00, 1.0247324258674d-01,
     |   1.4728086720205d+00, 6.9954444579060d-01,-9.1782466075094d-01,
     |  -1.1189426675818d+00, 2.2605139795740d-01, 1.1461317477850d+00,
     |   4.1399692932376d-01,-8.4081236591611d-01,-8.4664747472858d-01,
     |   3.2904221334785d-01, 9.8200618058314d-01, 2.2595965446599d-01,
     |  -8.1392594931737d-01,-6.6481772498107d-01, 4.1676279846740d-01,
     |   8.7198209203161d-01, 7.8396016822439d-02,-8.0349675114375d-01,
     |  -5.2155060647709d-01, 4.9515670911696d-01, 7.8539233982883d-01,
     |  -4.9144280873867d-02,-7.9950657361141d-01,-3.9690318470651d-01,
     |   5.6809965400658d-01, 7.0972749841951d-01,-1.6672285284478d-01,
     |  -7.9819266737066d-01,-2.8079426906711d-01, 6.3861134211978d-01,
     |   6.3861134211978d-01,-2.8079426906710d-01,-7.9819266737066d-01,
     |  -1.6672285284478d-01, 7.0972749841951d-01, 5.6809965400658d-01,
     |  -3.9690318470651d-01,-7.9950657361141d-01,-4.9144280873871d-02,
     |   7.8539233982883d-01, 4.9515670911697d-01,-5.2155060647708d-01,
     |  -8.0349675114375d-01, 7.8396016822439d-02, 8.7198209203161d-01,
     |   4.1676279846742d-01,-6.6481772498107d-01,-8.1392594931737d-01,
     |   2.2595965446599d-01, 9.8200618058314d-01, 3.2904221334786d-01,
     |  -8.4664747472859d-01,-8.4081236591610d-01, 4.1399692932375d-01,
     |   1.1461317477850d+00, 2.2605139795740d-01,-1.1189426675818d+00,
     |  -9.1782466075095d-01, 6.9954444579059d-01, 1.4728086720205d+00,
     |   1.0247324258676d-01,-1.7014508857505d+00,-1.2639750669888d+00,
     |   1.3825676796067d+00, 3.1526050708988d+00, 1.6587017880154d+00/
      data (pmn(lat, 2,29), lat = 1,72)/
     |   2.7126779554674d-01, 1.8297202256114d+00, 2.6251746240252d+00,
     |   1.1821581794172d+00,-1.0683251607343d+00,-1.6079875457988d+00,
     |  -8.4258978615898d-02, 1.3262260124163d+00, 8.3676980000958d-01,
     |  -7.0584530643164d-01,-1.1551615794134d+00,-4.8139026167183d-03,
     |   1.0629225480013d+00, 5.9952232528439d-01,-6.5982429361187d-01,
     |  -9.3320540196392d-01, 1.0345299864168d-01, 9.4533975345364d-01,
     |   4.2909254005358d-01,-6.6675785293338d-01,-7.8542200632793d-01,
     |   2.0467933429273d-01, 8.7502615815153d-01, 2.9081413279322d-01,
     |  -6.8925274353294d-01,-6.7000611782499d-01, 2.9895908674478d-01,
     |   8.2490481607711d-01, 1.6911317975226d-01,-7.1773905221033d-01,
     |  -5.7043450622092d-01, 3.8917978704518d-01, 7.8460483864640d-01,
     |   5.5549584288582d-02,-7.4952354512490d-01,-4.7847458846495d-01,
     |   4.7847458846495d-01, 7.4952354512490d-01,-5.5549584288579d-02,
     |  -7.8460483864640d-01,-3.8917978704518d-01, 5.7043450622092d-01,
     |   7.1773905221033d-01,-1.6911317975226d-01,-8.2490481607711d-01,
     |  -2.9895908674478d-01, 6.7000611782499d-01, 6.8925274353294d-01,
     |  -2.9081413279322d-01,-8.7502615815153d-01,-2.0467933429273d-01,
     |   7.8542200632792d-01, 6.6675785293339d-01,-4.2909254005358d-01,
     |  -9.4533975345365d-01,-1.0345299864169d-01, 9.3320540196392d-01,
     |   6.5982429361186d-01,-5.9952232528439d-01,-1.0629225480013d+00,
     |   4.8139026167183d-03, 1.1551615794134d+00, 7.0584530643165d-01,
     |  -8.3676980000957d-01,-1.3262260124163d+00, 8.4258978615898d-02,
     |   1.6079875457988d+00, 1.0683251607343d+00,-1.1821581794172d+00,
     |  -2.6251746240252d+00,-1.8297202256114d+00,-2.7126779554674d-01/
      data (pmn(lat, 3,29), lat = 1,72)/
     |   2.9247656908170d-02, 6.3901059966275d-01, 1.8761800730968d+00,
     |   2.3120955131461d+00, 9.7450704773994d-01,-9.9695120923617d-01,
     |  -1.5155527462637d+00,-1.6949526490668d-01, 1.2127628839245d+00,
     |   9.0323191029715d-01,-5.4533921956851d-01,-1.1499758368091d+00,
     |  -1.7658584488714d-01, 9.6485650786075d-01, 7.2614596255113d-01,
     |  -4.8803321607959d-01,-9.6822364198112d-01,-9.2098363675429d-02,
     |   8.7170613538249d-01, 5.8678307514871d-01,-5.0350860600380d-01,
     |  -8.5357533217758d-01, 9.8674507448072d-04, 8.2936912218766d-01,
     |   4.7129857698385d-01,-5.4126474909945d-01,-7.6930725124333d-01,
     |   9.2911618622813d-02, 8.0916713904518d-01, 3.6935211447619d-01,
     |  -5.8840821671296d-01,-7.0083395860527d-01, 1.8354199837213d-01,
     |   8.0086608449084d-01, 2.7475825323756d-01,-6.4150865414922d-01,
     |  -6.4150865414922d-01, 2.7475825323756d-01, 8.0086608449084d-01,
     |   1.8354199837213d-01,-7.0083395860526d-01,-5.8840821671296d-01,
     |   3.6935211447619d-01, 8.0916713904518d-01, 9.2911618622817d-02,
     |  -7.6930725124333d-01,-5.4126474909946d-01, 4.7129857698384d-01,
     |   8.2936912218766d-01, 9.8674507448072d-04,-8.5357533217758d-01,
     |  -5.0350860600382d-01, 5.8678307514871d-01, 8.7170613538249d-01,
     |  -9.2098363675427d-02,-9.6822364198112d-01,-4.8803321607960d-01,
     |   7.2614596255114d-01, 9.6485650786075d-01,-1.7658584488713d-01,
     |  -1.1499758368091d+00,-5.4533921956851d-01, 9.0323191029715d-01,
     |   1.2127628839245d+00,-1.6949526490667d-01,-1.5155527462637d+00,
     |  -9.9695120923619d-01, 9.7450704773994d-01, 2.3120955131461d+00,
     |   1.8761800730968d+00, 6.3901059966275d-01, 2.9247656908170d-02/
      data (pmn(lat, 4,29), lat = 1,72)/
     |   2.3486104210750d-03, 1.6093110083733d-01, 8.7477555230025d-01,
     |   1.8907561391178d+00, 2.0755850829010d+00, 7.7905403745910d-01,
     |  -9.8052073421951d-01,-1.4331334850837d+00,-2.0088399312818d-01,
     |   1.1287875108103d+00, 9.3267733690727d-01,-4.2453331271010d-01,
     |  -1.1262409576120d+00,-3.0582881276571d-01, 8.6498487072302d-01,
     |   8.1190627843943d-01,-3.2996344641923d-01,-9.6834613779083d-01,
     |  -2.5965878206466d-01, 7.7449300325209d-01, 7.0538725703480d-01,
     |  -3.3359429912873d-01,-8.7794530667415d-01,-1.8874034219004d-01,
     |   7.4462174314967d-01, 6.1766926605078d-01,-3.6934044821124d-01,
     |  -8.2038304955244d-01,-1.1343990769728d-01, 7.4229621499355d-01,
     |   5.4293265337460d-01,-4.1909334037419d-01,-7.8155683600470d-01,
     |  -3.7777439199484d-02, 7.5582851341564d-01, 4.7727740626444d-01,
     |  -4.7727740626444d-01,-7.5582851341564d-01, 3.7777439199481d-02,
     |   7.8155683600470d-01, 4.1909334037419d-01,-5.4293265337460d-01,
     |  -7.4229621499356d-01, 1.1343990769727d-01, 8.2038304955244d-01,
     |   3.6934044821125d-01,-6.1766926605078d-01,-7.4462174314967d-01,
     |   1.8874034219004d-01, 8.7794530667415d-01, 3.3359429912873d-01,
     |  -7.0538725703480d-01,-7.7449300325210d-01, 2.5965878206465d-01,
     |   9.6834613779083d-01, 3.2996344641924d-01,-8.1190627843943d-01,
     |  -8.6498487072302d-01, 3.0582881276572d-01, 1.1262409576120d+00,
     |   4.2453331271010d-01,-9.3267733690727d-01,-1.1287875108103d+00,
     |   2.0088399312817d-01, 1.4331334850837d+00, 9.8052073421951d-01,
     |  -7.7905403745908d-01,-2.0755850829010d+00,-1.8907561391178d+00,
     |  -8.7477555230025d-01,-1.6093110083733d-01,-2.3486104210750d-03/
      data (pmn(lat, 5,29), lat = 1,72)/
     |   1.4990979076821d-04, 3.1727459314129d-02, 3.0676852933958d-01,
     |   1.0478720154402d+00, 1.8841678379670d+00, 1.8752403565313d+00,
     |   5.9959016425291d-01,-9.8818194999496d-01,-1.3602029160078d+00,
     |  -2.0354217574834d-01, 1.0668631608679d+00, 9.4303979603048d-01,
     |  -3.3186392056352d-01,-1.0949796362682d+00,-4.0585071135320d-01,
     |   7.6790912650114d-01, 8.6952684038724d-01,-1.8503561116963d-01,
     |  -9.4400550288547d-01,-4.0316366825753d-01, 6.6121815763687d-01,
     |   7.9046466319764d-01,-1.6195975741759d-01,-8.6468979187301d-01,
     |  -3.6141608515505d-01, 6.2738767478767d-01, 7.2832565449594d-01,
     |  -1.8088880386557d-01,-8.2353248136046d-01,-3.1171758261774d-01,
     |   6.2762576131370d-01, 6.8124970005860d-01,-2.1741185761629d-01,
     |  -8.0576130626259d-01,-2.6245464612965d-01, 6.4737808957638d-01,
     |   6.4737808957638d-01,-2.6245464612965d-01,-8.0576130626259d-01,
     |  -2.1741185761629d-01, 6.8124970005860d-01, 6.2762576131370d-01,
     |  -3.1171758261773d-01,-8.2353248136046d-01,-1.8088880386558d-01,
     |   7.2832565449594d-01, 6.2738767478768d-01,-3.6141608515504d-01,
     |  -8.6468979187301d-01,-1.6195975741759d-01, 7.9046466319764d-01,
     |   6.6121815763688d-01,-4.0316366825753d-01,-9.4400550288547d-01,
     |  -1.8503561116963d-01, 8.6952684038724d-01, 7.6790912650115d-01,
     |  -4.0585071135321d-01,-1.0949796362682d+00,-3.3186392056353d-01,
     |   9.4303979603048d-01, 1.0668631608679d+00,-2.0354217574833d-01,
     |  -1.3602029160078d+00,-9.8818194999497d-01, 5.9959016425291d-01,
     |   1.8752403565313d+00, 1.8841678379670d+00, 1.0478720154402d+00,
     |   3.0676852933958d-01, 3.1727459314129d-02, 1.4990979076821d-04/
      data (pmn(lat, 6,29), lat = 1,72)/
     |   7.9189346540159d-06, 5.1329605427066d-03, 8.6498463254584d-02,
     |   4.4705198858618d-01, 1.1803685238109d+00, 1.8604724726138d+00,
     |   1.6961070587729d+00, 4.3721727600826d-01,-1.0047642804039d+00,
     |  -1.2950935186495d+00,-1.9177400207792d-01, 1.0201415918333d+00,
     |   9.4422830062289d-01,-2.5777960889383d-01,-1.0610976335821d+00,
     |  -4.8659913726005d-01, 6.7402354491619d-01, 9.0740141480827d-01,
     |  -5.0602417381544d-02,-9.0108097248628d-01,-5.2647030411900d-01,
     |   5.3555257491832d-01, 8.4581693568096d-01, 8.8194800298699d-03,
     |  -8.1745388229207d-01,-5.1458413944537d-01, 4.8210538430536d-01,
     |   8.0098091459811d-01, 1.7658679073605d-02,-7.7805035019197d-01,
     |  -4.9316502851806d-01, 4.6833560674565d-01, 7.7464940385520d-01,
     |   7.5541477955730d-03,-7.6624950012522d-01,-4.7523606009656d-01,
     |   4.7523606009656d-01, 7.6624950012522d-01,-7.5541477955703d-03,
     |  -7.7464940385520d-01,-4.6833560674566d-01, 4.9316502851807d-01,
     |   7.7805035019197d-01,-1.7658679073597d-02,-8.0098091459811d-01,
     |  -4.8210538430536d-01, 5.1458413944536d-01, 8.1745388229207d-01,
     |  -8.8194800298663d-03,-8.4581693568096d-01,-5.3555257491832d-01,
     |   5.2647030411899d-01, 9.0108097248628d-01, 5.0602417381551d-02,
     |  -9.0740141480827d-01,-6.7402354491620d-01, 4.8659913726005d-01,
     |   1.0610976335821d+00, 2.5777960889382d-01,-9.4422830062288d-01,
     |  -1.0201415918333d+00, 1.9177400207792d-01, 1.2950935186495d+00,
     |   1.0047642804039d+00,-4.3721727600825d-01,-1.6961070587729d+00,
     |  -1.8604724726138d+00,-1.1803685238109d+00,-4.4705198858618d-01,
     |  -8.6498463254584d-02,-5.1329605427066d-03,-7.9189346540159d-06/
      data (pmn(lat, 7,29), lat = 1,72)/
     |   3.5576501043368d-07, 7.0258930169028d-04, 2.0390808529661d-02,
     |   1.5584035739758d-01, 5.7692419877003d-01, 1.2819414896638d+00,
     |   1.8228045963306d+00, 1.5324502951354d+00, 2.9252699435061d-01,
     |  -1.0224391098140d+00,-1.2367400838732d+00,-1.7439516416834d-01,
     |   9.8317365269288d-01, 9.4199832247916d-01,-1.9472409588279d-01,
     |  -1.0262940600619d+00,-5.5528651582260d-01, 5.8166653106155d-01,
     |   9.3062010692123d-01, 7.6527277005517d-02,-8.4220250582755d-01,
     |  -6.3241176753587d-01, 3.9881583847984d-01, 8.7316497203232d-01,
     |   1.7700047062243d-01,-7.3774485180320d-01,-6.4511946340158d-01,
     |   3.1209286912329d-01, 8.3197844314284d-01, 2.1939406723647d-01,
     |  -6.8248308303294d-01,-6.4731906941196d-01, 2.6870396374401d-01,
     |   8.1192416665616d-01, 2.4340535908580d-01,-6.5637681902814d-01,
     |  -6.5637681902814d-01, 2.4340535908579d-01, 8.1192416665616d-01,
     |   2.6870396374401d-01,-6.4731906941195d-01,-6.8248308303294d-01,
     |   2.1939406723647d-01, 8.3197844314284d-01, 3.1209286912329d-01,
     |  -6.4511946340157d-01,-7.3774485180320d-01, 1.7700047062242d-01,
     |   8.7316497203232d-01, 3.9881583847984d-01,-6.3241176753587d-01,
     |  -8.4220250582755d-01, 7.6527277005514d-02, 9.3062010692123d-01,
     |   5.8166653106155d-01,-5.5528651582259d-01,-1.0262940600619d+00,
     |  -1.9472409588278d-01, 9.4199832247916d-01, 9.8317365269289d-01,
     |  -1.7439516416834d-01,-1.2367400838732d+00,-1.0224391098141d+00,
     |   2.9252699435060d-01, 1.5324502951354d+00, 1.8228045963306d+00,
     |   1.2819414896638d+00, 5.7692419877003d-01, 1.5584035739758d-01,
     |   2.0390808529661d-02, 7.0258930169028d-04, 3.5576501043368d-07/
      data (pmn(lat, 8,29), lat = 1,72)/
     |   1.3860715601134d-08, 8.3113819026501d-05, 4.1228476827566d-03,
     |   4.5958893562272d-02, 2.3274666590237d-01, 6.9430506708103d-01,
     |   1.3580875153359d+00, 1.7742798367679d+00, 1.3824879347992d+00,
     |   1.6595910690556d-01,-1.0371905253480d+00,-1.1848607445092d+00,
     |  -1.5727202363232d-01, 9.5177549617850d-01, 9.3986844187206d-01,
     |  -1.3670956841442d-01,-9.9049780274565d-01,-6.1701395240334d-01,
     |   4.8818782672573d-01, 9.4172893730851d-01, 1.9929530649349d-01,
     |  -7.6767761615059d-01,-7.2229775892964d-01, 2.5110202108322d-01,
     |   8.7210339842827d-01, 3.4046627182374d-01,-6.2552329383435d-01,
     |  -7.4828518959049d-01, 1.2077286031894d-01, 8.1609171778260d-01,
     |   4.1543981754080d-01,-5.3552827881729d-01,-7.6098849590346d-01,
     |   3.6014266132532d-02, 7.8063921992158d-01, 4.7227753743123d-01,
     |  -4.7227753743123d-01,-7.8063921992158d-01,-3.6014266132535d-02,
     |   7.6098849590346d-01, 5.3552827881729d-01,-4.1543981754080d-01,
     |  -8.1609171778260d-01,-1.2077286031895d-01, 7.4828518959049d-01,
     |   6.2552329383435d-01,-3.4046627182374d-01,-8.7210339842827d-01,
     |  -2.5110202108323d-01, 7.2229775892964d-01, 7.6767761615059d-01,
     |  -1.9929530649348d-01,-9.4172893730851d-01,-4.8818782672573d-01,
     |   6.1701395240334d-01, 9.9049780274565d-01, 1.3670956841443d-01,
     |  -9.3986844187206d-01,-9.5177549617850d-01, 1.5727202363230d-01,
     |   1.1848607445092d+00, 1.0371905253480d+00,-1.6595910690555d-01,
     |  -1.3824879347992d+00,-1.7742798367679d+00,-1.3580875153359d+00,
     |  -6.9430506708103d-01,-2.3274666590237d-01,-4.5958893562272d-02,
     |  -4.1228476827566d-03,-8.3113819026501d-05,-1.3860715601134d-08/
      data (pmn(lat, 9,29), lat = 1,72)/
     |   4.7513770575321d-10, 8.6302533452777d-06, 7.2794055802946d-04,
     |   1.1730138440386d-02, 8.0056280432343d-02, 3.1235137295519d-01,
     |   7.9806065729109d-01, 1.4127243673987d+00, 1.7181201500894d+00,
     |   1.2462654596131d+00, 5.7829266897145d-02,-1.0471150448393d+00,
     |  -1.1397769640805d+00,-1.4460511567907d-01, 9.2268083669039d-01,
     |   9.4005406081178d-01,-7.8885767347552d-02,-9.5253300359315d-01,
     |  -6.7520585716588d-01, 3.9047936648192d-01, 9.4119922379444d-01,
     |   3.1990593620520d-01,-6.7614938215190d-01,-7.9557224426279d-01,
     |   9.2226344799581d-02, 8.4020126548234d-01, 4.9566227516998d-01,
     |  -4.8002228499604d-01,-8.1705731459960d-01,-8.6855025006489d-02,
     |   7.4686923345694d-01, 5.9344219213770d-01,-3.3772457064590d-01,
     |  -8.1778938860151d-01,-2.1685340915178d-01, 6.6876114458105d-01,
     |   6.6876114458106d-01,-2.1685340915178d-01,-8.1778938860151d-01,
     |  -3.3772457064590d-01, 5.9344219213770d-01, 7.4686923345694d-01,
     |  -8.6855025006486d-02,-8.1705731459959d-01,-4.8002228499604d-01,
     |   4.9566227516998d-01, 8.4020126548234d-01, 9.2226344799587d-02,
     |  -7.9557224426279d-01,-6.7614938215190d-01, 3.1990593620520d-01,
     |   9.4119922379444d-01, 3.9047936648193d-01,-6.7520585716588d-01,
     |  -9.5253300359315d-01,-7.8885767347560d-02, 9.4005406081178d-01,
     |   9.2268083669038d-01,-1.4460511567907d-01,-1.1397769640805d+00,
     |  -1.0471150448393d+00, 5.7829266897145d-02, 1.2462654596131d+00,
     |   1.7181201500894d+00, 1.4127243673987d+00, 7.9806065729109d-01,
     |   3.1235137295519d-01, 8.0056280432343d-02, 1.1730138440386d-02,
     |   7.2794055802946d-04, 8.6302533452777d-06, 4.7513770575321d-10/
      data (pmn(lat,10,29), lat = 1,72)/
     |   1.4489407750377d-11, 7.9583776088789d-07, 1.1372312020929d-04,
     |   2.6326851576111d-03, 2.3976455507428d-02, 1.2042168327199d-01,
     |   3.9099612144295d-01, 8.8762758955427d-01, 1.4491565778639d+00,
     |   1.6575984604818d+00, 1.1246682825733d+00,-3.1669864712444d-02,
     |  -1.0514906902018d+00,-1.1021762763601d+00,-1.3962241834344d-01,
     |   8.9317390434566d-01, 9.4388708369809d-01,-1.7206794475379d-02,
     |  -9.1037563909385d-01,-7.3182854249692d-01, 2.8527110461856d-01,
     |   9.2766268077192d-01, 4.3940516333777d-01,-5.6512656161043d-01,
     |  -8.4949873030601d-01,-7.7327879804614d-02, 7.7326371482326d-01,
     |   6.3656026216930d-01,-3.0091377009882d-01,-8.4177065634488d-01,
     |  -3.0241803190614d-01, 6.1775131537821d-01, 7.3621726035080d-01,
     |  -9.4150782536885d-02,-7.9875575604041d-01,-4.6829094847869d-01,
     |   4.6829094847869d-01, 7.9875575604041d-01, 9.4150782536887d-02,
     |  -7.3621726035080d-01,-6.1775131537821d-01, 3.0241803190614d-01,
     |   8.4177065634489d-01, 3.0091377009883d-01,-6.3656026216930d-01,
     |  -7.7326371482326d-01, 7.7327879804609d-02, 8.4949873030600d-01,
     |   5.6512656161044d-01,-4.3940516333777d-01,-9.2766268077192d-01,
     |  -2.8527110461857d-01, 7.3182854249692d-01, 9.1037563909385d-01,
     |   1.7206794475380d-02,-9.4388708369809d-01,-8.9317390434566d-01,
     |   1.3962241834344d-01, 1.1021762763601d+00, 1.0514906902018d+00,
     |   3.1669864712444d-02,-1.1246682825733d+00,-1.6575984604818d+00,
     |  -1.4491565778639d+00,-8.8762758955427d-01,-3.9099612144295d-01,
     |  -1.2042168327199d-01,-2.3976455507428d-02,-2.6326851576111d-03,
     |  -1.1372312020929d-04,-7.9583776088789d-07,-1.4489407750377d-11/
      data (pmn(lat,11,29), lat = 1,72)/
     |   3.9644259380961d-13, 6.5760735303878d-08, 1.5876851168269d-05,
     |   5.2566792686328d-04, 6.3444856544884d-03, 4.0588833491352d-02,
     |   1.6469461689413d-01, 4.6583144878951d-01, 9.6290702517499d-01,
     |   1.4704417389344d+00, 1.5959371110422d+00, 1.0189241699029d+00,
     |  -1.0243080169983d-01,-1.0501945676623d+00,-1.0728884139128d+00,
     |  -1.4498094077931d-01, 8.6074486575846d-01, 9.5194490586469d-01,
     |   5.1783468320226d-02,-8.6119193905588d-01,-7.8740212062613d-01,
     |   1.6937410415422d-01, 8.9798896795658d-01, 5.5718677221004d-01,
     |  -4.3154087385628d-01,-8.7884998641929d-01,-2.5530272546322d-01,
     |   6.6588518759086d-01, 7.5363342435247d-01,-9.0007901251392d-02,
     |  -8.1031877311975d-01,-5.1205459180513d-01, 4.2434656326607d-01,
     |   8.2099937794006d-01, 1.8170719813947d-01,-6.8491651278435d-01,
     |  -6.8491651278435d-01, 1.8170719813947d-01, 8.2099937794006d-01,
     |   4.2434656326607d-01,-5.1205459180513d-01,-8.1031877311975d-01,
     |  -9.0007901251396d-02, 7.5363342435247d-01, 6.6588518759087d-01,
     |  -2.5530272546322d-01,-8.7884998641929d-01,-4.3154087385628d-01,
     |   5.5718677221003d-01, 8.9798896795658d-01, 1.6937410415422d-01,
     |  -7.8740212062612d-01,-8.6119193905589d-01, 5.1783468320219d-02,
     |   9.5194490586469d-01, 8.6074486575846d-01,-1.4498094077931d-01,
     |  -1.0728884139128d+00,-1.0501945676623d+00,-1.0243080169984d-01,
     |   1.0189241699029d+00, 1.5959371110422d+00, 1.4704417389344d+00,
     |   9.6290702517500d-01, 4.6583144878951d-01, 1.6469461689413d-01,
     |   4.0588833491353d-02, 6.3444856544884d-03, 5.2566792686328d-04,
     |   1.5876851168269d-05, 6.5760735303878d-08, 3.9644259380961d-13/
      data (pmn(lat,12,29), lat = 1,72)/
     |   9.7969368380874d-15, 4.9029991647075d-09, 1.9958945986856d-06,
     |   9.4194588532845d-05, 1.4990773807378d-03, 1.2125619817489d-02,
     |   6.0807158565430d-02, 2.1056679880940d-01, 5.3463431631604d-01,
     |   1.0241968698484d+00, 1.4794998239347d+00, 1.5362002688103d+00,
     |   9.3034812152921d-01,-1.5435000661599d-01,-1.0432852499917d+00,
     |  -1.0526789687724d+00,-1.6301018877173d-01, 8.2276935868701d-01,
     |   9.6399013735519d-01, 1.3103544564295d-01,-8.0127038984143d-01,
     |  -8.4081496982251d-01, 4.0006051542893d-02, 8.4729940385345d-01,
     |   6.7033895948360d-01,-2.7250952805692d-01,-8.7567779300101d-01,
     |  -4.3627396932514d-01, 5.1254031361572d-01, 8.3297938733662d-01,
     |   1.4631615697322d-01,-7.0937591298978d-01,-6.9421745203647d-01,
     |   1.6835901507365d-01, 8.2021876273245d-01, 4.6311676583028d-01,
     |  -4.6311676583028d-01,-8.2021876273245d-01,-1.6835901507366d-01,
     |   6.9421745203646d-01, 7.0937591298978d-01,-1.4631615697323d-01,
     |  -8.3297938733662d-01,-5.1254031361572d-01, 4.3627396932514d-01,
     |   8.7567779300101d-01, 2.7250952805693d-01,-6.7033895948360d-01,
     |  -8.4729940385345d-01,-4.0006051542893d-02, 8.4081496982251d-01,
     |   8.0127038984144d-01,-1.3103544564295d-01,-9.6399013735519d-01,
     |  -8.2276935868701d-01, 1.6301018877172d-01, 1.0526789687724d+00,
     |   1.0432852499917d+00, 1.5435000661598d-01,-9.3034812152920d-01,
     |  -1.5362002688103d+00,-1.4794998239347d+00,-1.0241968698484d+00,
     |  -5.3463431631604d-01,-2.1056679880940d-01,-6.0807158565430d-02,
     |  -1.2125619817489d-02,-1.4990773807378d-03,-9.4194588532845d-05,
     |  -1.9958945986856d-06,-4.9029991647075d-09,-9.7969368380874d-15/
      data (pmn(lat,13,29), lat = 1,72)/
     |   2.1979503995976d-16, 3.3161926755254d-10, 2.2724627412287d-07,
     |   1.5247798653703d-05, 3.1876386901936d-04, 3.2423111483285d-03,
     |   1.9937977601425d-02, 8.3552406403677d-02, 2.5586660394551d-01,
     |   5.9570487453337d-01, 1.0721101213490d+00, 1.4791001650256d+00,
     |   1.4811934195041d+00, 8.6021903419918d-01,-1.8721100238402d-01,
     |  -1.0306617669159d+00,-1.0420425723905d+00,-1.9584972929495d-01,
     |   7.7620932560768d-01, 9.7876018710782d-01, 2.2291973829517d-01,
     |  -7.2593350225646d-01,-8.8894713108384d-01,-1.0467243154356d-01,
     |   7.6904793837690d-01, 7.7279528043224d-01,-8.6516390320408d-02,
     |  -8.2936672601778d-01,-6.0992635218179d-01, 3.0957784655724d-01,
     |   8.5598276427916d-01, 3.9385331663726d-01,-5.2739000755088d-01,
     |  -8.1812276877636d-01,-1.3644986138676d-01, 7.0540887613018d-01,
     |   7.0540887613018d-01,-1.3644986138676d-01,-8.1812276877636d-01,
     |  -5.2739000755088d-01, 3.9385331663726d-01, 8.5598276427916d-01,
     |   3.0957784655724d-01,-6.0992635218179d-01,-8.2936672601778d-01,
     |  -8.6516390320410d-02, 7.7279528043224d-01, 7.6904793837690d-01,
     |  -1.0467243154356d-01,-8.8894713108384d-01,-7.2593350225646d-01,
     |   2.2291973829516d-01, 9.7876018710782d-01, 7.7620932560769d-01,
     |  -1.9584972929495d-01,-1.0420425723905d+00,-1.0306617669159d+00,
     |  -1.8721100238401d-01, 8.6021903419918d-01, 1.4811934195041d+00,
     |   1.4791001650256d+00, 1.0721101213490d+00, 5.9570487453337d-01,
     |   2.5586660394551d-01, 8.3552406403677d-02, 1.9937977601425d-02,
     |   3.2423111483286d-03, 3.1876386901936d-04, 1.5247798653703d-05,
     |   2.2724627412287d-07, 3.3161926755254d-10, 2.1979503995976d-16/
      data (pmn(lat,14,29), lat = 1,72)/
     |   4.4944123315248d-18, 2.0430447781056d-11, 2.3537639426300d-08,
     |   2.2408625528018d-06, 6.1356821083194d-05, 7.8155639652153d-04,
     |   5.8594543919449d-03, 2.9472826065710d-02, 1.0755387849528d-01,
     |   2.9861364534119d-01, 6.4778509886945d-01, 1.1074700249499d+00,
     |   1.4717860226267d+00, 1.4333714317548d+00, 8.0972854587272d-01,
     |  -2.0054420303622d-01,-1.0117520807564d+00,-1.0409669620198d+00,
     |  -2.4548604716309d-01, 7.1734266523204d-01, 9.9361513595434d-01,
     |   3.2894103252845d-01,-6.2952764795237d-01,-9.2612138504094d-01,
     |  -2.6466931286347d-01, 6.5537322839346d-01, 8.5433591972034d-01,
     |   1.2474306700458d-01,-7.2736368898623d-01,-7.5912953742518d-01,
     |   5.8567734906564d-02, 8.0031159285634d-01, 6.2675122400927d-01,
     |  -2.6032490857175d-01,-8.4443842093550d-01,-4.5652911789289d-01,
     |   4.5652911789289d-01, 8.4443842093550d-01, 2.6032490857175d-01,
     |  -6.2675122400927d-01,-8.0031159285634d-01,-5.8567734906561d-02,
     |   7.5912953742518d-01, 7.2736368898623d-01,-1.2474306700458d-01,
     |  -8.5433591972034d-01,-6.5537322839346d-01, 2.6466931286347d-01,
     |   9.2612138504094d-01, 6.2952764795237d-01,-3.2894103252845d-01,
     |  -9.9361513595434d-01,-7.1734266523205d-01, 2.4548604716308d-01,
     |   1.0409669620198d+00, 1.0117520807564d+00, 2.0054420303623d-01,
     |  -8.0972854587273d-01,-1.4333714317548d+00,-1.4717860226267d+00,
     |  -1.1074700249499d+00,-6.4778509886945d-01,-2.9861364534119d-01,
     |  -1.0755387849528d-01,-2.9472826065710d-02,-5.8594543919449d-03,
     |  -7.8155639652154d-04,-6.1356821083194d-05,-2.2408625528018d-06,
     |  -2.3537639426300d-08,-2.0430447781056d-11,-4.4944123315248d-18/
      data (pmn(lat,15,29), lat = 1,72)/
     |   8.4007037608518d-20, 1.1499712714062d-12, 2.2251192789195d-09,
     |   3.0008365869806d-07, 1.0736514565153d-05, 1.7071634340033d-04,
     |   1.5535847500982d-03, 9.3231869052216d-03, 4.0200261178336d-02,
     |   1.3145107848542d-01, 3.3705134219251d-01, 6.8997593394331d-01,
     |   1.1311843934815d+00, 1.4597649551331d+00, 1.3947489607255d+00,
     |   7.7996110338525d-01,-1.9347954190422d-01,-9.8520370506107d-01,
     |  -1.0486314286539d+00,-3.1365898772075d-01, 6.4155174935165d-01,
     |   1.0040442758081d+00, 4.4915616146005d-01,-5.0563611219094d-01,
     |  -9.4344768644753d-01,-4.3676863873763d-01, 4.9804369091085d-01,
     |   8.9964751739716d-01, 3.5362655072101d-01,-5.5723401668943d-01,
     |  -8.5833156947166d-01,-2.2861801643747d-01, 6.4359928187407d-01,
     |   8.0422339257100d-01, 7.8991119372866d-02,-7.3107369858661d-01,
     |  -7.3107369858661d-01, 7.8991119372864d-02, 8.0422339257099d-01,
     |   6.4359928187407d-01,-2.2861801643747d-01,-8.5833156947166d-01,
     |  -5.5723401668943d-01, 3.5362655072100d-01, 8.9964751739716d-01,
     |   4.9804369091085d-01,-4.3676863873763d-01,-9.4344768644753d-01,
     |  -5.0563611219094d-01, 4.4915616146005d-01, 1.0040442758081d+00,
     |   6.4155174935166d-01,-3.1365898772075d-01,-1.0486314286539d+00,
     |  -9.8520370506107d-01,-1.9347954190423d-01, 7.7996110338525d-01,
     |   1.3947489607255d+00, 1.4597649551331d+00, 1.1311843934815d+00,
     |   6.8997593394331d-01, 3.3705134219251d-01, 1.3145107848542d-01,
     |   4.0200261178336d-02, 9.3231869052216d-03, 1.5535847500982d-03,
     |   1.7071634340033d-04, 1.0736514565153d-05, 3.0008365869806d-07,
     |   2.2251192789195d-09, 1.1499712714062d-12, 8.4007037608518d-20/
      data (pmn(lat,16,29), lat = 1,72)/
     |   1.4381558346095d-21, 5.9260508883659d-14, 1.9241855670540d-10,
     |   3.6711198750672d-08, 1.7130748001733d-06, 3.3914850748864d-05,
     |   3.7335457258406d-04, 2.6608210274582d-03, 1.3471614316474d-02,
     |   5.1428120435433d-02, 1.5387671095771d-01, 3.6965957094150d-01,
     |   7.2164549144611d-01, 1.1441047173260d+00, 1.4447773618082d+00,
     |   1.3668003166591d+00, 7.7186857819824d-01,-1.6461449506656d-01,
     |  -9.4856272652550d-01,-1.0629970115283d+00,-4.0157464372535d-01,
     |   5.4324030835925d-01, 1.0030499793691d+00, 5.8118642226048d-01,
     |  -3.4774443272024d-01,-9.2823672073138d-01,-6.1251295330269d-01,
     |   2.9047665410391d-01, 8.8795575910795d-01, 5.8286613186251d-01,
     |  -3.1098271978793d-01,-8.7349799290098d-01,-5.2310169594997d-01,
     |   3.7172293321514d-01, 8.7049839769556d-01, 4.4820606117307d-01,
     |  -4.4820606117307d-01,-8.7049839769556d-01,-3.7172293321514d-01,
     |   5.2310169594997d-01, 8.7349799290098d-01, 3.1098271978793d-01,
     |  -5.8286613186251d-01,-8.8795575910795d-01,-2.9047665410392d-01,
     |   6.1251295330268d-01, 9.2823672073138d-01, 3.4774443272025d-01,
     |  -5.8118642226047d-01,-1.0030499793691d+00,-5.4324030835925d-01,
     |   4.0157464372534d-01, 1.0629970115283d+00, 9.4856272652550d-01,
     |   1.6461449506656d-01,-7.7186857819823d-01,-1.3668003166591d+00,
     |  -1.4447773618082d+00,-1.1441047173260d+00,-7.2164549144612d-01,
     |  -3.6965957094150d-01,-1.5387671095771d-01,-5.1428120435433d-02,
     |  -1.3471614316474d-02,-2.6608210274582d-03,-3.7335457258406d-04,
     |  -3.3914850748864d-05,-1.7130748001733d-06,-3.6711198750672d-08,
     |  -1.9241855670540d-10,-5.9260508883659d-14,-1.4381558346095d-21/
      data (pmn(lat,17,29), lat = 1,72)/
     |   2.2575075950367d-23, 2.7991644016658d-15, 1.5241283243659d-11,
     |   4.1092422055025d-09, 2.4970510428422d-07, 6.1424439906851d-06,
     |   8.1574278777014d-05, 6.8793124996065d-04, 4.0701584821017d-03,
     |   1.8023261887776d-02, 6.2364902645138d-02, 1.7352369271592d-01,
     |   3.9515010592120d-01, 7.4232929741731d-01, 1.1468766256920d+00,
     |   1.4279467350013d+00, 1.3503297470782d+00, 7.8619910924813d-01,
     |  -1.1193245293994d-01,-8.9794449984881d-01,-1.0802448157552d+00,
     |  -5.0932538342562d-01, 4.1601308591835d-01, 9.8048787256297d-01,
     |   7.1871224282588d-01,-1.5070624632511d-01,-8.6387310642151d-01,
     |  -7.7558752860463d-01, 3.1467018080279d-02, 7.9426317687569d-01,
     |   7.8141889721600d-01, 7.2904503437813d-03,-7.6595247868709d-01,
     |  -7.7218811536027d-01,-6.4155465059323d-03, 7.6317703920172d-01,
     |   7.6317703920173d-01,-6.4155465059298d-03,-7.7218811536027d-01,
     |  -7.6595247868709d-01, 7.2904503437783d-03, 7.8141889721600d-01,
     |   7.9426317687569d-01, 3.1467018080287d-02,-7.7558752860463d-01,
     |  -8.6387310642150d-01,-1.5070624632511d-01, 7.1871224282587d-01,
     |   9.8048787256298d-01, 4.1601308591835d-01,-5.0932538342562d-01,
     |  -1.0802448157552d+00,-8.9794449984881d-01,-1.1193245293995d-01,
     |   7.8619910924813d-01, 1.3503297470782d+00, 1.4279467350013d+00,
     |   1.1468766256920d+00, 7.4232929741731d-01, 3.9515010592120d-01,
     |   1.7352369271592d-01, 6.2364902645138d-02, 1.8023261887776d-02,
     |   4.0701584821018d-03, 6.8793124996065d-04, 8.1574278777014d-05,
     |   6.1424439906853d-06, 2.4970510428422d-07, 4.1092422055025d-09,
     |   1.5241283243659d-11, 2.7991644016658d-15, 2.2575075950367d-23/
      data (pmn(lat,18,29), lat = 1,72)/
     |   3.2501424034775d-25, 1.2123179512708d-16, 1.1062833218615d-12,
     |   4.2111352460916d-10, 3.3281091876908d-08, 1.0154761357695d-06,
     |   1.6232804103843d-05, 1.6152069216331d-04, 1.1125694486027d-03,
     |   5.6865479029535d-03, 2.2605564022051d-02, 7.2183203381668d-02,
     |   1.8919864488248d-01, 4.1245003070010d-01, 7.5162896246065d-01,
     |   1.1397892184306d+00, 1.4096106922042d+00, 1.3452878189750d+00,
     |   8.2333071056599d-01,-3.2827951029764d-02,-8.2772899359938d-01,
     |  -1.0940317867626d+00,-6.3488178048734d-01, 2.5335226097650d-01,
     |   9.2257418999972d-01, 8.4940509175501d-01, 8.6512766672632d-02,
     |  -7.3090576206063d-01,-8.9903631416699d-01,-2.6873936472490d-01,
     |   5.9396937051916d-01, 9.0151769566632d-01, 3.6985807918647d-01,
     |  -5.0383637379018d-01,-8.9695488374716d-01,-4.3767732196117d-01,
     |   4.3767732196117d-01, 8.9695488374716d-01, 5.0383637379018d-01,
     |  -3.6985807918647d-01,-9.0151769566632d-01,-5.9396937051916d-01,
     |   2.6873936472490d-01, 8.9903631416698d-01, 7.3090576206063d-01,
     |  -8.6512766672630d-02,-8.4940509175501d-01,-9.2257418999972d-01,
     |  -2.5335226097651d-01, 6.3488178048734d-01, 1.0940317867626d+00,
     |   8.2772899359939d-01, 3.2827951029767d-02,-8.2333071056599d-01,
     |  -1.3452878189750d+00,-1.4096106922042d+00,-1.1397892184306d+00,
     |  -7.5162896246065d-01,-4.1245003070010d-01,-1.8919864488248d-01,
     |  -7.2183203381668d-02,-2.2605564022051d-02,-5.6865479029536d-03,
     |  -1.1125694486027d-03,-1.6152069216331d-04,-1.6232804103843d-05,
     |  -1.0154761357695d-06,-3.3281091876908d-08,-4.2111352460916d-10,
     |  -1.1062833218615d-12,-1.2123179512708d-16,-3.2501424034775d-25/
      data (pmn(lat,19,29), lat = 1,72)/
     |   4.2890263743193d-27, 4.8115149433878d-18, 7.3548260351144d-14,
     |   3.9496947307020d-11, 4.0553501916385d-09, 1.5326413018581d-07,
     |   2.9435844097683d-06, 3.4477131406269d-05, 2.7564870167237d-04,
     |   1.6199283960429d-03, 7.3608473499353d-03, 2.6792920275497d-02,
     |   8.0081585998707d-02, 1.9986548952096d-01, 4.2068134617965d-01,
     |   7.4912010854431d-01, 1.1226333740705d+00, 1.3891319164851d+00,
     |   1.3505068721684d+00, 8.8294728978433d-01, 7.5670421368882d-02,
     |  -7.3036782675292d-01,-1.0945778163219d+00,-7.7250143218423d-01,
     |   5.0161569334056d-02, 8.1201845491061d-01, 9.5247653910623d-01,
     |   3.5628342657063d-01,-5.1064991375650d-01,-9.4361400557974d-01,
     |  -5.7990963485986d-01, 2.7341028685413d-01, 8.8082080679011d-01,
     |   7.1162970207921d-01,-8.5474838538143d-02,-8.0372767790379d-01,
     |  -8.0372767790379d-01,-8.5474838538145d-02, 7.1162970207921d-01,
     |   8.8082080679011d-01, 2.7341028685413d-01,-5.7990963485986d-01,
     |  -9.4361400557975d-01,-5.1064991375651d-01, 3.5628342657063d-01,
     |   9.5247653910623d-01, 8.1201845491061d-01, 5.0161569334062d-02,
     |  -7.7250143218423d-01,-1.0945778163219d+00,-7.3036782675292d-01,
     |   7.5670421368871d-02, 8.8294728978433d-01, 1.3505068721684d+00,
     |   1.3891319164851d+00, 1.1226333740705d+00, 7.4912010854431d-01,
     |   4.2068134617965d-01, 1.9986548952096d-01, 8.0081585998708d-02,
     |   2.6792920275497d-02, 7.3608473499353d-03, 1.6199283960429d-03,
     |   2.7564870167237d-04, 3.4477131406270d-05, 2.9435844097683d-06,
     |   1.5326413018582d-07, 4.0553501916385d-09, 3.9496947307020d-11,
     |   7.3548260351144d-14, 4.8115149433878d-18, 4.2890263743193d-27/
      data (pmn(lat,20,29), lat = 1,72)/
     |   5.1797458615688d-29, 1.7472287840621d-19, 4.4719449394679d-15,
     |   3.3857973863512d-12, 4.5122872599946d-10, 2.1097335380184d-08,
     |   4.8607922770141d-07, 6.6886017301414d-06, 6.1918296113138d-05,
     |   4.1708797557455d-04, 2.1577537665462d-03, 8.9069601635365d-03,
     |   3.0150969588835d-02, 8.5344176913711d-02, 2.0468456270685d-01,
     |   4.1914822735137d-01, 7.3428525809131d-01, 1.0945850235004d+00,
     |   1.3646947265747d+00, 1.3633320118269d+00, 9.6348175103478d-01,
     |   2.1633947183895d-01,-5.9648330917315d-01,-1.0677058294762d+00,
     |  -9.1043766886545d-01,-1.9429946241291d-01, 6.2964909457293d-01,
     |   9.9656359462249d-01, 6.3567539786414d-01,-1.9318348678714d-01,
     |  -8.6017071541927d-01,-8.4246155103652d-01,-1.5120126381182d-01,
     |   6.5679835261589d-01, 9.2146810590211d-01, 4.2422578086059d-01,
     |  -4.2422578086059d-01,-9.2146810590211d-01,-6.5679835261589d-01,
     |   1.5120126381182d-01, 8.4246155103651d-01, 8.6017071541926d-01,
     |   1.9318348678714d-01,-6.3567539786413d-01,-9.9656359462249d-01,
     |  -6.2964909457293d-01, 1.9429946241291d-01, 9.1043766886544d-01,
     |   1.0677058294762d+00, 5.9648330917315d-01,-2.1633947183895d-01,
     |  -9.6348175103477d-01,-1.3633320118269d+00,-1.3646947265747d+00,
     |  -1.0945850235004d+00,-7.3428525809131d-01,-4.1914822735137d-01,
     |  -2.0468456270685d-01,-8.5344176913711d-02,-3.0150969588835d-02,
     |  -8.9069601635365d-03,-2.1577537665462d-03,-4.1708797557456d-04,
     |  -6.1918296113139d-05,-6.6886017301415d-06,-4.8607922770141d-07,
     |  -2.1097335380185d-08,-4.5122872599946d-10,-3.3857973863512d-12,
     |  -4.4719449394679d-15,-1.7472287840621d-19,-5.1797458615688d-29/
      data (pmn(lat,21,29), lat = 1,72)/
     |   5.7090962859621d-31, 5.7895998462186d-21, 2.4802315718760d-16,
     |   2.6459723653309d-13, 4.5735504524244d-11, 2.6427689502198d-09,
     |   7.2948562349291d-08, 1.1773599143649d-06, 1.2594102242917d-05,
     |   9.6993250910185d-05, 5.6947410098155d-04, 2.6551015434708d-03,
     |   1.0126190138814d-02, 3.2284245676716d-02, 8.7398504033398d-02,
     |   2.0305439622739d-01, 4.0734656332546d-01, 7.0649355553863d-01,
     |   1.0541404452892d+00, 1.3331099229491d+00, 1.3791409787451d+00,
     |   1.0612469564722d+00, 3.9066313834481d-01,-4.1558758275142d-01,
     |  -9.9417808830449d-01,-1.0280158982228d+00,-4.7149303523972d-01,
     |   3.5897575087598d-01, 9.3974616346761d-01, 8.7848459211683d-01,
     |   2.0824528445578d-01,-6.0128757053119d-01,-9.6301738656438d-01,
     |  -6.0694983063945d-01, 2.0307704309599d-01, 8.5614302425871d-01,
     |   8.5614302425871d-01, 2.0307704309599d-01,-6.0694983063945d-01,
     |  -9.6301738656438d-01,-6.0128757053119d-01, 2.0824528445578d-01,
     |   8.7848459211683d-01, 9.3974616346762d-01, 3.5897575087598d-01,
     |  -4.7149303523971d-01,-1.0280158982228d+00,-9.9417808830449d-01,
     |  -4.1558758275142d-01, 3.9066313834481d-01, 1.0612469564722d+00,
     |   1.3791409787451d+00, 1.3331099229491d+00, 1.0541404452892d+00,
     |   7.0649355553863d-01, 4.0734656332546d-01, 2.0305439622739d-01,
     |   8.7398504033397d-02, 3.2284245676716d-02, 1.0126190138814d-02,
     |   2.6551015434708d-03, 5.6947410098155d-04, 9.6993250910187d-05,
     |   1.2594102242917d-05, 1.1773599143649d-06, 7.2948562349291d-08,
     |   2.6427689502199d-09, 4.5735504524244d-11, 2.6459723653309d-13,
     |   2.4802315718760d-16, 5.7895998462186d-21, 5.7090962859621d-31/
      data (pmn(lat,22,29), lat = 1,72)/
     |   5.7192391205623d-33, 1.7433765710014d-22, 1.2496656369141d-17,
     |   1.8776017086211d-14, 4.2064130649101d-12, 3.0013127794863d-10,
     |   9.9143467401256d-09, 1.8742157684242d-07, 2.3126458414743d-06,
     |   2.0320452287825d-05, 1.3504912085127d-04, 7.0887169016885d-04,
     |   3.0335166899904d-03, 1.0836259578623d-02, 3.2884708304455d-02,
     |   8.5872814124373d-02, 1.9466430578011d-01, 3.8501306298359d-01,
     |   6.6505689361327d-01, 9.9914866403749d-01, 1.2896833754692d+00,
     |   1.3907890723220d+00, 1.1692007678333d+00, 5.9694520346732d-01,
     |  -1.7795630328985d-01,-8.5007444826434d-01,-1.0926413869943d+00,
     |  -7.5633354814297d-01,-4.2911193153263d-03, 7.3530073192763d-01,
     |   1.0093159501596d+00, 6.3606879316086d-01,-1.4940752301570d-01,
     |  -8.2799174300666d-01,-9.4005868879933d-01,-4.0668237393145d-01,
     |   4.0668237393145d-01, 9.4005868879933d-01, 8.2799174300667d-01,
     |   1.4940752301570d-01,-6.3606879316085d-01,-1.0093159501596d+00,
     |  -7.3530073192763d-01, 4.2911193153197d-03, 7.5633354814297d-01,
     |   1.0926413869943d+00, 8.5007444826435d-01, 1.7795630328986d-01,
     |  -5.9694520346732d-01,-1.1692007678333d+00,-1.3907890723220d+00,
     |  -1.2896833754692d+00,-9.9914866403750d-01,-6.6505689361328d-01,
     |  -3.8501306298359d-01,-1.9466430578011d-01,-8.5872814124374d-02,
     |  -3.2884708304455d-02,-1.0836259578623d-02,-3.0335166899904d-03,
     |  -7.0887169016885d-04,-1.3504912085127d-04,-2.0320452287825d-05,
     |  -2.3126458414744d-06,-1.8742157684243d-07,-9.9143467401256d-09,
     |  -3.0013127794864d-10,-4.2064130649101d-12,-1.8776017086211d-14,
     |  -1.2496656369141d-17,-1.7433765710014d-22,-5.7192391205623d-33/
      data (pmn(lat,23,29), lat = 1,72)/
     |   5.1762731842311d-35, 4.7422272658621d-24, 5.6862155525371d-19,
     |   1.2027205969713d-15, 3.4902745008744d-13, 3.0727166731875d-11,
     |   1.2135421260832d-09, 2.6838531870911d-08, 3.8146019587807d-07,
     |   3.8172748363951d-06, 2.8654770397525d-05, 1.6888321842364d-04,
     |   8.0825591495367d-04, 3.2216402256463d-03, 1.0901974215451d-02,
     |   3.1778536612298d-02, 8.0653728957305d-02, 1.7956516317767d-01,
     |   3.5223206621206d-01, 6.0940012652541d-01, 9.2701152805376d-01,
     |   1.2282589253673d+00, 1.3881036829698d+00, 1.2753857001257d+00,
     |   8.2739473696888d-01, 1.2158264051266d-01,-6.0959603320650d-01,
     |  -1.0583653588239d+00,-9.9828343951000d-01,-4.3579358700049d-01,
     |   3.4911476898817d-01, 9.2838093486542d-01, 9.6652768421697d-01,
     |   4.3345909702106d-01,-3.5709833836917d-01,-9.2687722546470d-01,
     |  -9.2687722546470d-01,-3.5709833836917d-01, 4.3345909702105d-01,
     |   9.6652768421697d-01, 9.2838093486542d-01, 3.4911476898817d-01,
     |  -4.3579358700049d-01,-9.9828343951000d-01,-1.0583653588239d+00,
     |  -6.0959603320650d-01, 1.2158264051266d-01, 8.2739473696887d-01,
     |   1.2753857001257d+00, 1.3881036829698d+00, 1.2282589253673d+00,
     |   9.2701152805377d-01, 6.0940012652541d-01, 3.5223206621206d-01,
     |   1.7956516317767d-01, 8.0653728957306d-02, 3.1778536612298d-02,
     |   1.0901974215451d-02, 3.2216402256463d-03, 8.0825591495368d-04,
     |   1.6888321842364d-04, 2.8654770397525d-05, 3.8172748363951d-06,
     |   3.8146019587808d-07, 2.6838531870911d-08, 1.2135421260832d-09,
     |   3.0727166731876d-11, 3.4902745008744d-13, 1.2027205969713d-15,
     |   5.6862155525371d-19, 4.7422272658621d-24, 5.1762731842311d-35/
      data (pmn(lat,24,29), lat = 1,72)/
     |   4.1963245151897d-37, 1.1552981748928d-25, 2.3166872204231d-20,
     |   6.8957029757926d-17, 2.5908225822501d-14, 2.8123961276919d-12,
     |   1.3268671116884d-10, 3.4295377826196d-09, 5.6077199164988d-08,
     |   6.3813970557162d-07, 5.4007292543467d-06, 3.5661139030024d-05,
     |   1.9035738047089d-04, 8.4382239591265d-04, 3.1709939851845d-03,
     |   1.0263923849688d-02, 2.8967668566331d-02, 7.1942855187963d-02,
     |   1.5826168841448d-01, 3.0961456093883d-01, 5.3938757133732d-01,
     |   8.3515146883848d-01, 1.1416271045610d+00, 1.3577118908979d+00,
     |   1.3613140799881d+00, 1.0641465453969d+00, 4.7709093106058d-01,
     |  -2.5249110530308d-01,-8.6954578804609d-01,-1.1143477634612d+00,
     |  -8.5948652882447d-01,-2.0416382021892d-01, 5.4359034504832d-01,
     |   1.0083111908000d+00, 9.4537916376371d-01, 3.8293317214047d-01,
     |  -3.8293317214047d-01,-9.4537916376371d-01,-1.0083111908000d+00,
     |  -5.4359034504832d-01, 2.0416382021892d-01, 8.5948652882447d-01,
     |   1.1143477634612d+00, 8.6954578804609d-01, 2.5249110530308d-01,
     |  -4.7709093106058d-01,-1.0641465453969d+00,-1.3613140799881d+00,
     |  -1.3577118908979d+00,-1.1416271045610d+00,-8.3515146883848d-01,
     |  -5.3938757133732d-01,-3.0961456093883d-01,-1.5826168841448d-01,
     |  -7.1942855187964d-02,-2.8967668566331d-02,-1.0263923849688d-02,
     |  -3.1709939851845d-03,-8.4382239591264d-04,-1.9035738047090d-04,
     |  -3.5661139030024d-05,-5.4007292543467d-06,-6.3813970557163d-07,
     |  -5.6077199164989d-08,-3.4295377826196d-09,-1.3268671116884d-10,
     |  -2.8123961276920d-12,-2.5908225822501d-14,-6.8957029757926d-17,
     |  -2.3166872204231d-20,-1.1552981748928d-25,-4.1963245151897d-37/
      data (pmn(lat,25,29), lat = 1,72)/
     |   3.0092254927201d-39, 2.4893919689928d-27, 8.3465181076968d-22,
     |   3.4949683502612d-18, 1.6993045484364d-15, 2.2731783419322d-13,
     |   1.2802289593800d-11, 3.8637922565578d-10, 7.2603443863207d-09,
     |   9.3831746517225d-08, 8.9393382989182d-07, 6.6007331067133d-06,
     |   3.9210639524279d-05, 1.9277759951217d-04, 8.0180959309068d-04,
     |   2.8700387746321d-03, 8.9607507568848d-03, 2.4660527512295d-02,
     |   6.0305935663856d-02, 1.3182001019461d-01, 2.5855076044208d-01,
     |   4.5583957925011d-01, 7.2186704494058d-01, 1.0225886067073d+00,
     |   1.2837324878157d+00, 1.4010294502107d+00, 1.2747972383373d+00,
     |   8.6176925088496d-01, 2.2114205951263d-01,-4.7586253031598d-01,
     |  -9.9324792993401d-01,-1.1261612524644d+00,-8.0452306371475d-01,
     |  -1.4783258741345d-01, 5.6854939957288d-01, 1.0303062332061d+00,
     |   1.0303062332061d+00, 5.6854939957288d-01,-1.4783258741345d-01,
     |  -8.0452306371475d-01,-1.1261612524644d+00,-9.9324792993401d-01,
     |  -4.7586253031598d-01, 2.2114205951262d-01, 8.6176925088496d-01,
     |   1.2747972383373d+00, 1.4010294502107d+00, 1.2837324878157d+00,
     |   1.0225886067073d+00, 7.2186704494058d-01, 4.5583957925011d-01,
     |   2.5855076044208d-01, 1.3182001019461d-01, 6.0305935663856d-02,
     |   2.4660527512295d-02, 8.9607507568848d-03, 2.8700387746321d-03,
     |   8.0180959309067d-04, 1.9277759951217d-04, 3.9210639524280d-05,
     |   6.6007331067133d-06, 8.9393382989182d-07, 9.3831746517226d-08,
     |   7.2603443863209d-09, 3.8637922565578d-10, 1.2802289593800d-11,
     |   2.2731783419323d-13, 1.6993045484364d-15, 3.4949683502612d-18,
     |   8.3465181076968d-22, 2.4893919689928d-27, 3.0092254927201d-39/
      data (pmn(lat,26,29), lat = 1,72)/
     |   1.8729724608494d-41, 4.6552426083966d-29, 2.6092157793795d-23,
     |   1.5365543703028d-19, 9.6643316653941d-17, 1.5923365391359d-14,
     |   1.0698301593391d-12, 3.7672168959369d-11, 8.1273596751886d-10,
     |   1.1915668618498d-08, 1.2761842198595d-07, 1.0520941024576d-06,
     |   6.9419505587672d-06, 3.7767765724528d-05, 1.7338850772456d-04,
     |   6.8405877963517d-04, 2.3530607806799d-03, 7.1394001111346d-03,
     |   1.9283047068633d-02, 4.6699528138616d-02, 1.0196625581146d-01,
     |   2.0150697499929d-01, 3.6123355037375d-01, 5.8767420435229d-01,
     |   8.6603096785488d-01, 1.1501749355051d+00, 1.3623426185587d+00,
     |   1.4094174344440d+00, 1.2163560626145d+00, 7.6693863305997d-01,
     |   1.3285065690543d-01,-5.2895133266651d-01,-1.0196260249748d+00,
     |  -1.1716082457387d+00,-9.2169391123860d-01,-3.4843768015284d-01,
     |   3.4843768015284d-01, 9.2169391123860d-01, 1.1716082457387d+00,
     |   1.0196260249748d+00, 5.2895133266651d-01,-1.3285065690544d-01,
     |  -7.6693863305997d-01,-1.2163560626145d+00,-1.4094174344440d+00,
     |  -1.3623426185587d+00,-1.1501749355051d+00,-8.6603096785488d-01,
     |  -5.8767420435230d-01,-3.6123355037375d-01,-2.0150697499929d-01,
     |  -1.0196625581146d-01,-4.6699528138616d-02,-1.9283047068633d-02,
     |  -7.1394001111347d-03,-2.3530607806799d-03,-6.8405877963517d-04,
     |  -1.7338850772456d-04,-3.7767765724528d-05,-6.9419505587673d-06,
     |  -1.0520941024576d-06,-1.2761842198595d-07,-1.1915668618498d-08,
     |  -8.1273596751888d-10,-3.7672168959370d-11,-1.0698301593391d-12,
     |  -1.5923365391360d-14,-9.6643316653941d-17,-1.5365543703028d-19,
     |  -2.6092157793795d-23,-4.6552426083966d-29,-1.8729724608494d-41/
      data (pmn(lat,27,29), lat = 1,72)/
     |   9.8097143035139d-44, 7.3249207095439d-31, 6.8620217775873d-25,
     |   5.6816851527813d-21, 4.6210771636765d-18, 9.3736650867576d-16,
     |   7.5087899638836d-14, 3.0828851181052d-12, 7.6298200487836d-11,
     |   1.2677536892398d-09, 1.5246380348251d-08, 1.4014222153862d-07,
     |   1.0254393503546d-06, 6.1617817306382d-06, 3.1153100410500d-05,
     |   1.3509747897959d-04, 5.1031741268043d-04, 1.7001782120541d-03,
     |   5.0466848653586d-03, 1.3456903486123d-02, 3.2448007265333d-02,
     |   7.1123028437778d-02, 1.4227892142028d-01, 2.6048348429239d-01,
     |   4.3709932641329d-01, 6.7229641437834d-01, 9.4609914284309d-01,
     |   1.2127243828475d+00, 1.4034344846588d+00, 1.4413767326699d+00,
     |   1.2670374035177d+00, 8.6660562905873d-01, 2.9104403030901d-01,
     |  -3.4560176759394d-01,-8.9297840197943d-01,-1.2095271606511d+00,
     |  -1.2095271606511d+00,-8.9297840197943d-01,-3.4560176759394d-01,
     |   2.9104403030901d-01, 8.6660562905872d-01, 1.2670374035177d+00,
     |   1.4413767326699d+00, 1.4034344846588d+00, 1.2127243828475d+00,
     |   9.4609914284309d-01, 6.7229641437834d-01, 4.3709932641329d-01,
     |   2.6048348429239d-01, 1.4227892142028d-01, 7.1123028437778d-02,
     |   3.2448007265333d-02, 1.3456903486123d-02, 5.0466848653586d-03,
     |   1.7001782120541d-03, 5.1031741268043d-04, 1.3509747897959d-04,
     |   3.1153100410499d-05, 6.1617817306382d-06, 1.0254393503546d-06,
     |   1.4014222153862d-07, 1.5246380348251d-08, 1.2677536892398d-09,
     |   7.6298200487838d-11, 3.0828851181052d-12, 7.5087899638836d-14,
     |   9.3736650867580d-16, 4.6210771636765d-18, 5.6816851527813d-21,
     |   6.8620217775873d-25, 7.3249207095439d-31, 9.8097143035139d-44/
      data (pmn(lat,28,29), lat = 1,72)/
     |   4.0811329370670d-46, 9.1544029836800d-33, 1.4331586715768d-26,
     |   1.6680362366527d-22, 1.7537850329562d-19, 4.3779384363898d-17,
     |   4.1791953602854d-15, 1.9993901794117d-13, 5.6724055588439d-12,
     |   1.0672506891156d-10, 1.4397804923973d-09, 1.4738204037647d-08,
     |   1.1942512817105d-07, 7.9129715697933d-07, 4.3973970027786d-06,
     |   2.0913515655982d-05, 8.6516418691551d-05, 3.1547789016506d-04,
     |   1.0251147594514d-03, 2.9951889111900d-03, 7.9281374075610d-03,
     |   1.9129525746275d-02, 4.2290202048264d-02, 8.6015637508543d-02,
     |   1.6148654092079d-01, 2.8052465204566d-01, 4.5160998449691d-01,
     |   6.7419277615009d-01, 9.3283210832458d-01, 1.1937705385420d+00,
     |   1.4067828909477d+00, 1.5139381438153d+00, 1.4643374587487d+00,
     |   1.2308519717702d+00, 8.2288036630421d-01, 2.8950820660711d-01,
     |  -2.8950820660711d-01,-8.2288036630421d-01,-1.2308519717702d+00,
     |  -1.4643374587487d+00,-1.5139381438153d+00,-1.4067828909477d+00,
     |  -1.1937705385420d+00,-9.3283210832458d-01,-6.7419277615009d-01,
     |  -4.5160998449691d-01,-2.8052465204566d-01,-1.6148654092079d-01,
     |  -8.6015637508544d-02,-4.2290202048264d-02,-1.9129525746275d-02,
     |  -7.9281374075611d-03,-2.9951889111900d-03,-1.0251147594514d-03,
     |  -3.1547789016506d-04,-8.6516418691551d-05,-2.0913515655982d-05,
     |  -4.3973970027785d-06,-7.9129715697933d-07,-1.1942512817106d-07,
     |  -1.4738204037647d-08,-1.4397804923973d-09,-1.0672506891157d-10,
     |  -5.6724055588441d-12,-1.9993901794118d-13,-4.1791953602854d-15,
     |  -4.3779384363900d-17,-1.7537850329562d-19,-1.6680362366527d-22,
     |  -1.4331586715768d-26,-9.1544029836800d-33,-4.0811329370670d-46/
      data (pmn(lat,29,29), lat = 1,72)/
     |   1.1692921550478d-48, 7.8785339743715d-35, 2.0609385196245d-28,
     |   3.3711000644756d-24, 4.5806187754165d-21, 1.4066526208774d-18,
     |   1.5994756485626d-16, 8.9117874455628d-15, 2.8964595578361d-13,
     |   6.1661703386472d-12, 9.3230346341085d-11, 1.0616985962941d-09,
     |   9.5156388932696d-09, 6.9425368795817d-08, 4.2337197264208d-07,
     |   2.2039615187280d-06, 9.9625949723340d-06, 3.9655117730128d-05,
     |   1.4060934237077d-04, 4.4845852570230d-04, 1.2970783588058d-03,
     |   3.4257035801975d-03, 8.3106152467946d-03, 1.8612605919856d-02,
     |   3.8650192374097d-02, 7.4693365171741d-02, 1.3476790200437d-01,
     |   2.2764384175560d-01, 3.6083464385231d-01, 5.3778403290283d-01,
     |   7.5488687537555d-01, 9.9938389881626d-01, 1.2492432620297d+00,
     |   1.4757305620655d+00, 1.6485165862275d+00, 1.7421702411639d+00,
     |   1.7421702411639d+00, 1.6485165862275d+00, 1.4757305620655d+00,
     |   1.2492432620297d+00, 9.9938389881626d-01, 7.5488687537555d-01,
     |   5.3778403290284d-01, 3.6083464385231d-01, 2.2764384175560d-01,
     |   1.3476790200437d-01, 7.4693365171742d-02, 3.8650192374097d-02,
     |   1.8612605919856d-02, 8.3106152467946d-03, 3.4257035801975d-03,
     |   1.2970783588058d-03, 4.4845852570230d-04, 1.4060934237077d-04,
     |   3.9655117730128d-05, 9.9625949723341d-06, 2.2039615187280d-06,
     |   4.2337197264207d-07, 6.9425368795816d-08, 9.5156388932698d-09,
     |   1.0616985962941d-09, 9.3230346341085d-11, 6.1661703386473d-12,
     |   2.8964595578362d-13, 8.9117874455629d-15, 1.5994756485626d-16,
     |   1.4066526208775d-18, 4.5806187754165d-21, 3.3711000644756d-24,
     |   2.0609385196245d-28, 7.8785339743715d-35, 1.1692921550478d-48/
      data (pmn(lat, 0,30), lat = 1,72)/
     |   4.9282203499807d+00, 1.2486790382463d+00,-1.9356437286780d+00,
     |  -1.5540532037287d+00, 8.1760964002629d-01, 1.5900275700314d+00,
     |   4.6045208270195d-03,-1.3657374683542d+00,-6.1117269633639d-01,
     |   9.4621422144443d-01, 9.8062791383556d-01,-4.2055344496624d-01,
     |  -1.0974122637718d+00,-1.1141947155213d-01, 9.7672091699652d-01,
     |   5.5532142284710d-01,-6.6825070620187d-01,-8.3801267898568d-01,
     |   2.4927297592506d-01, 9.1969016591441d-01, 1.8880194465020d-01,
     |  -7.9986228177321d-01,-5.5689996443934d-01, 5.1605969189381d-01,
     |   7.8434672555613d-01,-1.3555054456617d-01,-8.3136723655463d-01,
     |  -2.5834007459804d-01, 6.9563854738367d-01, 5.8269234347998d-01,
     |  -4.1168054724361d-01,-7.7110730118957d-01, 4.3243450688630d-02,
     |   7.8642608541938d-01, 3.2981871751685d-01,-6.2765692986433d-01,
     |  -6.2765692986434d-01, 3.2981871751684d-01, 7.8642608541938d-01,
     |   4.3243450688633d-02,-7.7110730118957d-01,-4.1168054724361d-01,
     |   5.8269234347998d-01, 6.9563854738367d-01,-2.5834007459804d-01,
     |  -8.3136723655462d-01,-1.3555054456617d-01, 7.8434672555612d-01,
     |   5.1605969189382d-01,-5.5689996443934d-01,-7.9986228177321d-01,
     |   1.8880194465018d-01, 9.1969016591441d-01, 2.4927297592507d-01,
     |  -8.3801267898568d-01,-6.6825070620187d-01, 5.5532142284710d-01,
     |   9.7672091699652d-01,-1.1141947155214d-01,-1.0974122637718d+00,
     |  -4.2055344496624d-01, 9.8062791383556d-01, 9.4621422144443d-01,
     |  -6.1117269633638d-01,-1.3657374683542d+00, 4.6045208270195d-03,
     |   1.5900275700314d+00, 8.1760964002629d-01,-1.5540532037287d+00,
     |  -1.9356437286780d+00, 1.2486790382463d+00, 4.9282203499807d+00/
      data (pmn(lat, 1,30), lat = 1,72)/
     |   1.7374420254091d+00, 3.1876280320243d+00, 1.1592907871005d+00,
     |  -1.4930098880846d+00,-1.5461043142463d+00, 4.8650211894507d-01,
     |   1.5100436159969d+00, 2.7046488921867d-01,-1.2023018264906d+00,
     |  -7.9267938621444d-01, 7.2360376353580d-01, 1.0586919244303d+00,
     |  -1.7884968097347d-01,-1.0677489066297d+00,-3.2797257439204d-01,
     |   8.5337845226943d-01, 7.0802468027500d-01,-4.8154520495868d-01,
     |  -9.0139522035348d-01, 4.0029820736733d-02, 8.8624128967652d-01,
     |   3.7713714615785d-01,-6.8113132887652d-01,-6.8661258126678d-01,
     |   3.4003080773120d-01, 8.3061708194661d-01, 5.9135877268046d-02,
     |  -7.8686872216431d-01,-4.3017094476242d-01, 5.7169984238024d-01,
     |   6.9555540851485d-01,-2.3580499462733d-01,-8.0145625891415d-01,
     |  -1.4652428731800d-01, 7.2795610753923d-01, 4.9258687719283d-01,
     |  -4.9258687719283d-01,-7.2795610753923d-01, 1.4652428731799d-01,
     |   8.0145625891415d-01, 2.3580499462733d-01,-6.9555540851485d-01,
     |  -5.7169984238024d-01, 4.3017094476241d-01, 7.8686872216431d-01,
     |  -5.9135877268044d-02,-8.3061708194661d-01,-3.4003080773121d-01,
     |   6.8661258126678d-01, 6.8113132887652d-01,-3.7713714615785d-01,
     |  -8.8624128967652d-01,-4.0029820736736d-02, 9.0139522035348d-01,
     |   4.8154520495868d-01,-7.0802468027500d-01,-8.5337845226944d-01,
     |   3.2797257439205d-01, 1.0677489066297d+00, 1.7884968097348d-01,
     |  -1.0586919244303d+00,-7.2360376353580d-01, 7.9267938621443d-01,
     |   1.2023018264906d+00,-2.7046488921866d-01,-1.5100436159969d+00,
     |  -4.8650211894509d-01, 1.5461043142463d+00, 1.4930098880846d+00,
     |  -1.1592907871005d+00,-3.1876280320243d+00,-1.7374420254091d+00/
      data (pmn(lat, 2,30), lat = 1,72)/
     |   2.9416448068259d-01, 1.9429418946302d+00, 2.6326945517307d+00,
     |   9.1887490677279d-01,-1.3287989587428d+00,-1.4612102802864d+00,
     |   3.3552177623023d-01, 1.4195184869707d+00, 4.0884996359217d-01,
     |  -1.0655076313531d+00,-8.8534956340652d-01, 5.4770005827596d-01,
     |   1.0792438728698d+00, 6.6256858689304d-03,-1.0071394138958d+00,
     |  -4.8611126215257d-01, 7.2197537094019d-01, 8.0588977282958d-01,
     |  -3.0619348681858d-01,-9.1837590796840d-01,-1.4230721402390d-01,
     |   8.1887871710240d-01, 5.2761982777593d-01,-5.4396969014762d-01,
     |  -7.7294404232131d-01, 1.6258907656392d-01, 8.3397094777989d-01,
     |   2.3852865331832d-01,-7.0597465764490d-01,-5.7237976282408d-01,
     |   4.2329819422920d-01, 7.6885835532000d-01,-5.1388736840681d-02,
     |  -7.8832660964880d-01,-3.2704143790659d-01, 6.2903857970054d-01,
     |   6.2903857970054d-01,-3.2704143790659d-01,-7.8832660964880d-01,
     |  -5.1388736840684d-02, 7.6885835532000d-01, 4.2329819422919d-01,
     |  -5.7237976282408d-01,-7.0597465764491d-01, 2.3852865331831d-01,
     |   8.3397094777989d-01, 1.6258907656392d-01,-7.7294404232131d-01,
     |  -5.4396969014763d-01, 5.2761982777593d-01, 8.1887871710240d-01,
     |  -1.4230721402388d-01,-9.1837590796840d-01,-3.0619348681859d-01,
     |   8.0588977282958d-01, 7.2197537094020d-01,-4.8611126215257d-01,
     |  -1.0071394138958d+00, 6.6256858689352d-03, 1.0792438728698d+00,
     |   5.4770005827596d-01,-8.8534956340652d-01,-1.0655076313531d+00,
     |   4.0884996359215d-01, 1.4195184869707d+00, 3.3552177623023d-01,
     |  -1.4612102802864d+00,-1.3287989587428d+00, 9.1887490677279d-01,
     |   2.6326945517307d+00, 1.9429418946302d+00, 2.9416448068259d-01/
      data (pmn(lat, 3,30), lat = 1,72)/
     |   3.2819030336467d-02, 7.0628654713099d-01, 2.0014978399771d+00,
     |   2.2818357837958d+00, 6.7038121477340d-01,-1.2733422447369d+00,
     |  -1.3618319045838d+00, 2.7923040757732d-01, 1.3432496852223d+00,
     |   4.7574066524564d-01,-9.6141393860713d-01,-9.2961101563060d-01,
     |   4.1327491470735d-01, 1.0713624106290d+00, 1.4793384140048d-01,
     |  -9.3492550722142d-01,-6.0122312476848d-01, 5.9336484856739d-01,
     |   8.6477288613367d-01,-1.4609844858266d-01,-9.0318689751458d-01,
     |  -2.9894222353438d-01, 7.2899547064806d-01, 6.4466063903081d-01,
     |  -3.9656710710777d-01,-8.2186209166834d-01,-1.0975874406741d-02,
     |   8.0077621336553d-01, 3.9956593310022d-01,-5.9488962667024d-01,
     |  -6.8342913270369d-01, 2.5643966967887d-01, 8.0214832777299d-01,
     |   1.3548013908691d-01,-7.3235076380788d-01,-4.9184576549176d-01,
     |   4.9184576549176d-01, 7.3235076380788d-01,-1.3548013908691d-01,
     |  -8.0214832777299d-01,-2.5643966967887d-01, 6.8342913270369d-01,
     |   5.9488962667024d-01,-3.9956593310021d-01,-8.0077621336553d-01,
     |   1.0975874406739d-02, 8.2186209166834d-01, 3.9656710710777d-01,
     |  -6.4466063903081d-01,-7.2899547064806d-01, 2.9894222353438d-01,
     |   9.0318689751458d-01, 1.4609844858266d-01,-8.6477288613367d-01,
     |  -5.9336484856739d-01, 6.0122312476848d-01, 9.3492550722143d-01,
     |  -1.4793384140049d-01,-1.0713624106290d+00,-4.1327491470736d-01,
     |   9.2961101563060d-01, 9.6141393860713d-01,-4.7574066524563d-01,
     |  -1.3432496852223d+00,-2.7923040757733d-01, 1.3618319045838d+00,
     |   1.2733422447369d+00,-6.7038121477340d-01,-2.2818357837958d+00,
     |  -2.0014978399771d+00,-7.0628654713099d-01,-3.2819030336467d-02/
      data (pmn(lat, 4,30), lat = 1,72)/
     |   2.7269698628276d-03, 1.8465531401528d-01, 9.7781334018983d-01,
     |   2.0139789772816d+00, 2.0005401406582d+00, 4.3548753563606d-01,
     |  -1.2618565907358d+00,-1.2612535290871d+00, 2.7384187430876d-01,
     |   1.2830940917537d+00, 5.0216880905427d-01,-8.8503952578603d-01,
     |  -9.4789588809969d-01, 3.1087462833553d-01, 1.0503790601302d+00,
     |   2.5701407759311d-01,-8.6009274403605d-01,-6.8577309228107d-01,
     |   4.7112922650236d-01, 8.9599973729679d-01,-7.7693364630643d-04,
     |  -8.6495721539796d-01,-4.3288125201315d-01, 6.2321157349028d-01,
     |   7.3238176458397d-01,-2.4338041900880d-01,-8.3764828784388d-01,
     |  -1.7763954205219d-01, 7.3513761205798d-01, 5.3991000811041d-01,
     |  -4.5779654439716d-01,-7.6126558059820d-01, 7.6005605929735d-02,
     |   7.9383690510119d-01, 3.1860288427752d-01,-6.3321618832922d-01,
     |  -6.3321618832922d-01, 3.1860288427751d-01, 7.9383690510119d-01,
     |   7.6005605929737d-02,-7.6126558059819d-01,-4.5779654439715d-01,
     |   5.3991000811041d-01, 7.3513761205798d-01,-1.7763954205219d-01,
     |  -8.3764828784387d-01,-2.4338041900881d-01, 7.3238176458397d-01,
     |   6.2321157349028d-01,-4.3288125201315d-01,-8.6495721539796d-01,
     |  -7.7693364632423d-04, 8.9599973729679d-01, 4.7112922650237d-01,
     |  -6.8577309228107d-01,-8.6009274403605d-01, 2.5701407759311d-01,
     |   1.0503790601302d+00, 3.1087462833552d-01,-9.4789588809969d-01,
     |  -8.8503952578603d-01, 5.0216880905427d-01, 1.2830940917537d+00,
     |   2.7384187430877d-01,-1.2612535290871d+00,-1.2618565907358d+00,
     |   4.3548753563604d-01, 2.0005401406582d+00, 2.0139789772816d+00,
     |   9.7781334018983d-01, 1.8465531401528d-01, 2.7269698628276d-03/
      data (pmn(lat, 5,30), lat = 1,72)/
     |   1.8014194338764d-04, 3.7755226556071d-02, 3.5749894919798d-01,
     |   1.1782726869195d+00, 1.9938735403362d+00, 1.7508964750438d+00,
     |   2.1970324613830d-01,-1.2658048871290d+00,-1.1623935902177d+00,
     |   2.9550250625466d-01, 1.2356805834018d+00, 5.0586808061089d-01,
     |  -8.2934819644207d-01,-9.5267649975989d-01, 2.3132224566305d-01,
     |   1.0239510165030d+00, 3.4376829481471d-01,-7.8594626039459d-01,
     |  -7.4895957961873d-01, 3.5512358965121d-01, 9.0698289734335d-01,
     |   1.3206176459025d-01,-8.0889906744239d-01,-5.4719732572291d-01,
     |   5.0486234165132d-01, 7.9363725860179d-01,-8.6720876565773d-02,
     |  -8.2260830781025d-01,-3.3513957675241d-01, 6.3923276704903d-01,
     |   6.5671867118510d-01,-2.9772196625791d-01,-8.0256415847529d-01,
     |  -1.1301828034575d-01, 7.4110078563605d-01, 4.9033880743691d-01,
     |  -4.9033880743691d-01,-7.4110078563606d-01, 1.1301828034575d-01,
     |   8.0256415847529d-01, 2.9772196625791d-01,-6.5671867118510d-01,
     |  -6.3923276704903d-01, 3.3513957675240d-01, 8.2260830781025d-01,
     |   8.6720876565775d-02,-7.9363725860179d-01,-5.0486234165133d-01,
     |   5.4719732572291d-01, 8.0889906744239d-01,-1.3206176459025d-01,
     |  -9.0698289734335d-01,-3.5512358965121d-01, 7.4895957961873d-01,
     |   7.8594626039460d-01,-3.4376829481470d-01,-1.0239510165030d+00,
     |  -2.3132224566304d-01, 9.5267649975989d-01, 8.2934819644208d-01,
     |  -5.0586808061089d-01,-1.2356805834018d+00,-2.9550250625467d-01,
     |   1.1623935902177d+00, 1.2658048871290d+00,-2.1970324613830d-01,
     |  -1.7508964750438d+00,-1.9938735403362d+00,-1.1782726869195d+00,
     |  -3.5749894919798d-01,-3.7755226556071d-02,-1.8014194338764d-04/
      data (pmn(lat, 6,30), lat = 1,72)/
     |   9.8516168756432d-06, 6.3328047153772d-03, 1.0486923759724d-01,
     |   5.2665001611541d-01, 1.3296695135291d+00, 1.9472075429640d+00,
     |   1.5201034360931d+00, 2.5260819478298d-02,-1.2717224015705d+00,
     |  -1.0663425234687d+00, 3.3028652034853d-01, 1.1973014136033d+00,
     |   4.9757291943834d-01,-7.8785731845713d-01,-9.5103713397594d-01,
     |   1.6683418581460d-01, 9.9552204141429d-01, 4.1590236008441d-01,
     |  -7.1273032097857d-01,-7.9715208622099d-01, 2.4342481606510d-01,
     |   9.0202648948719d-01, 2.5511647874901d-01,-7.3734679176667d-01,
     |  -6.4411365723777d-01, 3.7518832530174d-01, 8.2956966777950d-01,
     |   7.1992076986424d-02,-7.7713194665916d-01,-4.8079476867276d-01,
     |   5.1389884490890d-01, 7.4574295700486d-01,-1.1760217236946d-01,
     |  -8.0236076539763d-01,-3.0417657345505d-01, 6.4029074838120d-01,
     |   6.4029074838120d-01,-3.0417657345504d-01,-8.0236076539763d-01,
     |  -1.1760217236946d-01, 7.4574295700486d-01, 5.1389884490890d-01,
     |  -4.8079476867276d-01,-7.7713194665916d-01, 7.1992076986421d-02,
     |   8.2956966777950d-01, 3.7518832530174d-01,-6.4411365723777d-01,
     |  -7.3734679176667d-01, 2.5511647874901d-01, 9.0202648948719d-01,
     |   2.4342481606511d-01,-7.9715208622099d-01,-7.1273032097858d-01,
     |   4.1590236008440d-01, 9.9552204141429d-01, 1.6683418581461d-01,
     |  -9.5103713397595d-01,-7.8785731845713d-01, 4.9757291943833d-01,
     |   1.1973014136033d+00, 3.3028652034853d-01,-1.0663425234687d+00,
     |  -1.2717224015705d+00, 2.5260819478289d-02, 1.5201034360931d+00,
     |   1.9472075429640d+00, 1.3296695135291d+00, 5.2665001611541d-01,
     |   1.0486923759724d-01, 6.3328047153772d-03, 9.8516168756432d-06/
      data (pmn(lat, 7,30), lat = 1,72)/
     |   4.5840668437135d-07, 8.9875681233433d-04, 2.5694592120135d-02,
     |   1.9168957111165d-01, 6.8458570237139d-01, 1.4417798171418d+00,
     |   1.8789606436868d+00, 1.3042957612164d+00,-1.4667904370494d-01,
     |  -1.2733994167969d+00,-9.7429576167172d-01, 3.6956084459312d-01,
     |   1.1651317246456d+00, 4.8427108641192d-01,-7.5519416457549d-01,
     |  -9.4713802406197d-01, 1.1104461688753d-01, 9.6619206542576d-01,
     |   4.7924895392779d-01,-6.3903154292257d-01,-8.3441671473448d-01,
     |   1.3338774562828d-01, 8.8299077907992d-01, 3.7070377063894d-01,
     |  -6.5056312453035d-01,-7.2447433253821d-01, 2.3429584642468d-01,
     |   8.3942170678349d-01, 2.3116555238519d-01,-6.9997045435299d-01,
     |  -6.1050224514431d-01, 3.5946141624635d-01, 8.0067965310502d-01,
     |   7.8393539650898d-02,-7.5411983646493d-01,-4.8801467877385d-01,
     |   4.8801467877384d-01, 7.5411983646493d-01,-7.8393539650895d-02,
     |  -8.0067965310502d-01,-3.5946141624635d-01, 6.1050224514432d-01,
     |   6.9997045435300d-01,-2.3116555238518d-01,-8.3942170678349d-01,
     |  -2.3429584642468d-01, 7.2447433253821d-01, 6.5056312453036d-01,
     |  -3.7070377063894d-01,-8.8299077907992d-01,-1.3338774562828d-01,
     |   8.3441671473447d-01, 6.3903154292258d-01,-4.7924895392779d-01,
     |  -9.6619206542576d-01,-1.1104461688754d-01, 9.4713802406197d-01,
     |   7.5519416457548d-01,-4.8427108641192d-01,-1.1651317246456d+00,
     |  -3.6956084459312d-01, 9.7429576167172d-01, 1.2733994167969d+00,
     |   1.4667904370496d-01,-1.3042957612164d+00,-1.8789606436868d+00,
     |  -1.4417798171418d+00,-6.8458570237139d-01,-1.9168957111165d-01,
     |  -2.5694592120135d-02,-8.9875681233433d-04,-4.5840668437135d-07/
      data (pmn(lat, 8,30), lat = 1,72)/
     |   1.8508026225681d-08, 1.1027039086303d-04, 5.3980818551631d-03,
     |   5.8929541295422d-02, 2.8953844540625d-01, 8.2748925808713d-01,
     |   1.5205188326961d+00, 1.7941008483001d+00, 1.1032489553441d+00,
     |  -2.9563467100978d-01,-1.2685168242709d+00,-8.8785495555073d-01,
     |   4.0772411321953d-01, 1.1373589101320d+00, 4.7088146511695d-01,
     |  -7.2701427744169d-01,-9.4350085534236d-01, 5.8739760677646d-02,
     |   9.3567502376775d-01, 5.3812245825071d-01,-5.6250322936298d-01,
     |  -8.6290650899229d-01, 2.2244944591091d-02, 8.4975483812132d-01,
     |   4.8023416999662d-01,-5.4736963016508d-01,-7.8736717460141d-01,
     |   8.2018389061734d-02, 8.2049147303429d-01, 3.8801379970016d-01,
     |  -5.8874257991247d-01,-7.1783204215494d-01, 1.7689978510766d-01,
     |   8.1282718444439d-01, 2.8319629049861d-01,-6.5044124278714d-01,
     |  -6.5044124278714d-01, 2.8319629049861d-01, 8.1282718444438d-01,
     |   1.7689978510766d-01,-7.1783204215493d-01,-5.8874257991247d-01,
     |   3.8801379970016d-01, 8.2049147303429d-01, 8.2018389061737d-02,
     |  -7.8736717460140d-01,-5.4736963016508d-01, 4.8023416999662d-01,
     |   8.4975483812132d-01, 2.2244944591091d-02,-8.6290650899229d-01,
     |  -5.6250322936299d-01, 5.3812245825071d-01, 9.3567502376775d-01,
     |   5.8739760677650d-02,-9.4350085534235d-01,-7.2701427744169d-01,
     |   4.7088146511696d-01, 1.1373589101320d+00, 4.0772411321954d-01,
     |  -8.8785495555073d-01,-1.2685168242709d+00,-2.9563467100979d-01,
     |   1.1032489553441d+00, 1.7941008483001d+00, 1.5205188326961d+00,
     |   8.2748925808714d-01, 2.8953844540625d-01, 5.8929541295422d-02,
     |   5.3980818551631d-03, 1.1027039086303d-04, 1.8508026225681d-08/
      data (pmn(lat, 9,30), lat = 1,72)/
     |   6.5791639269555d-10, 1.1881477226260d-05, 9.9040877085077d-04,
     |   1.5667582258027d-02, 1.0415893534460d-01, 3.9201179078746d-01,
     |   9.5310427610857d-01, 1.5705668698920d+00, 1.6976976824290d+00,
     |   9.1821559117461d-01,-4.2173056185183d-01,-1.2569813976623d+00,
     |  -8.0892797251053d-01, 4.4101674713957d-01, 1.1129933240709d+00,
     |   4.6112991835207d-01,-6.9974139742774d-01,-9.4164230994050d-01,
     |   5.5698984484321d-03, 9.0274008651629d-01, 5.9556131606543d-01,
     |  -4.8023110070346d-01,-8.8306680751005d-01,-9.2483574050288d-02,
     |   8.0051397785078d-01, 5.8375245871190d-01,-4.2571197742284d-01,
     |  -8.2979017976353d-01,-8.1175098760514d-02, 7.6824322063638d-01,
     |   5.3747584429493d-01,-4.4079151546138d-01,-7.9323821999190d-01,
     |  -3.0496138899480d-02, 7.7125773547473d-01, 4.8479143357610d-01,
     |  -4.8479143357609d-01,-7.7125773547473d-01, 3.0496138899477d-02,
     |   7.9323821999190d-01, 4.4079151546138d-01,-5.3747584429494d-01,
     |  -7.6824322063638d-01, 8.1175098760505d-02, 8.2979017976353d-01,
     |   4.2571197742284d-01,-5.8375245871190d-01,-8.0051397785078d-01,
     |   9.2483574050284d-02, 8.8306680751005d-01, 4.8023110070346d-01,
     |  -5.9556131606542d-01,-9.0274008651630d-01,-5.5698984484383d-03,
     |   9.4164230994050d-01, 6.9974139742775d-01,-4.6112991835207d-01,
     |  -1.1129933240709d+00,-4.4101674713957d-01, 8.0892797251052d-01,
     |   1.2569813976623d+00, 4.2173056185183d-01,-9.1821559117460d-01,
     |  -1.6976976824290d+00,-1.5705668698920d+00,-9.5310427610857d-01,
     |  -3.9201179078746d-01,-1.0415893534460d-01,-1.5667582258027d-02,
     |  -9.9040877085077d-04,-1.1881477226260d-05,-6.5791639269555d-10/
      data (pmn(lat,10,30), lat = 1,72)/
     |   2.0822000251432d-11, 1.1376888200455d-06, 1.6084698048795d-04,
     |   3.6624457470177d-03, 3.2588583232865d-02, 1.5864070080056d-01,
     |   4.9410977007397d-01, 1.0602575630749d+00, 1.5963022395402d+00,
     |   1.5948136041884d+00, 7.5091570339278d-01,-5.2563731327076d-01,
     |  -1.2399858241919d+00,-7.3956384725258d-01, 4.6682505805086d-01,
     |   1.0915955866253d+00, 4.5801190212462d-01,-6.7027195222848d-01,
     |  -9.4233547764349d-01,-5.2176380714324d-02, 8.6535716006304d-01,
     |   6.5341562707560d-01,-3.8893563460512d-01,-8.9366518188837d-01,
     |  -2.1259742866376d-01, 7.3199048957335d-01, 6.7942315890893d-01,
     |  -2.8330063377428d-01,-8.4634928203084d-01,-2.5307998328691d-01,
     |   6.7669847186157d-01, 6.7102857305037d-01,-2.5461083284796d-01,
     |  -8.2356414236869d-01,-2.5481936018458d-01, 6.6394299492852d-01,
     |   6.6394299492852d-01,-2.5481936018458d-01,-8.2356414236869d-01,
     |  -2.5461083284796d-01, 6.7102857305037d-01, 6.7669847186157d-01,
     |  -2.5307998328691d-01,-8.4634928203084d-01,-2.8330063377428d-01,
     |   6.7942315890892d-01, 7.3199048957335d-01,-2.1259742866375d-01,
     |  -8.9366518188837d-01,-3.8893563460512d-01, 6.5341562707560d-01,
     |   8.6535716006305d-01,-5.2176380714321d-02,-9.4233547764349d-01,
     |  -6.7027195222849d-01, 4.5801190212461d-01, 1.0915955866253d+00,
     |   4.6682505805085d-01,-7.3956384725259d-01,-1.2399858241919d+00,
     |  -5.2563731327076d-01, 7.5091570339278d-01, 1.5948136041883d+00,
     |   1.5963022395402d+00, 1.0602575630749d+00, 4.9410977007397d-01,
     |   1.5864070080056d-01, 3.2588583232865d-02, 3.6624457470177d-03,
     |   1.6084698048795d-04, 1.1376888200455d-06, 2.0822000251432d-11/
      data (pmn(lat,11,30), lat = 1,72)/
     |   5.9180113362802d-13, 9.7697026159050d-08, 2.3358743910106d-05,
     |   7.6185362338840d-04, 9.0050253219240d-03, 5.6036445025570d-02,
     |   2.1933121512907d-01, 5.9188506111073d-01, 1.1486990374785d+00,
     |   1.6021074774234d+00, 1.4903469253956d+00, 6.0304482805609d-01,
     |  -6.0846227294048d-01,-1.2194100564319d+00,-6.8181569532300d-01,
     |   4.8321540825261d-01, 1.0729873591284d+00, 4.6403298979752d-01,
     |  -6.3568438021743d-01,-9.4564118491666d-01,-1.1770491610360d-01,
     |   8.2067315642482d-01, 7.1226403297863d-01,-2.8514667940294d-01,
     |  -8.9167890985219d-01,-3.3871069948151d-01, 6.3967038407875d-01,
     |   7.6290282962854d-01,-1.1849776140290d-01,-8.2907607044822d-01,
     |  -4.2833991977902d-01, 5.3935823777895d-01, 7.7548324519098d-01,
     |  -3.2129077909310d-02,-7.9227165890911d-01,-4.8054954730953d-01,
     |   4.8054954730952d-01, 7.9227165890912d-01, 3.2129077909313d-02,
     |  -7.7548324519098d-01,-5.3935823777895d-01, 4.2833991977902d-01,
     |   8.2907607044822d-01, 1.1849776140291d-01,-7.6290282962854d-01,
     |  -6.3967038407875d-01, 3.3871069948151d-01, 8.9167890985219d-01,
     |   2.8514667940294d-01,-7.1226403297863d-01,-8.2067315642482d-01,
     |   1.1770491610358d-01, 9.4564118491666d-01, 6.3568438021743d-01,
     |  -4.6403298979752d-01,-1.0729873591284d+00,-4.8321540825262d-01,
     |   6.8181569532300d-01, 1.2194100564319d+00, 6.0846227294049d-01,
     |  -6.0304482805609d-01,-1.4903469253956d+00,-1.6021074774234d+00,
     |  -1.1486990374785d+00,-5.9188506111073d-01,-2.1933121512907d-01,
     |  -5.6036445025571d-02,-9.0050253219240d-03,-7.6185362338840d-04,
     |  -2.3358743910106d-05,-9.7697026159050d-08,-5.9180113362802d-13/
      data (pmn(lat,12,30), lat = 1,72)/
     |   1.5208240409972d-14, 7.5775997885850d-09, 3.0571507828667d-06,
     |   1.4230818021385d-04, 2.2221762395410d-03, 1.7532253102043d-02,
     |   8.5159379190072d-02, 2.8315662635148d-01, 6.8229585659815d-01,
     |   1.2189838413879d+00, 1.5924088314599d+00, 1.3888856997886d+00,
     |   4.7605633580045d-01,-6.7158696800008d-01,-1.1973983711387d+00,
     |  -6.3765025457230d-01, 4.8857495719765d-01, 1.0569561431515d+00,
     |   4.8131451206939d-01,-5.9296506681218d-01,-9.5077556561397d-01,
     |  -1.9372942887342d-01, 7.6490262801022d-01, 7.7114484330016d-01,
     |  -1.6547039988185d-01,-8.7209636584276d-01,-4.6952496675145d-01,
     |   5.1822852757315d-01, 8.2660987711973d-01, 6.8347023563926d-02,
     |  -7.6759132190527d-01,-5.9666278180370d-01, 3.5105187088282d-01,
     |   8.3209900856530d-01, 2.1786676094158d-01,-6.8119898668953d-01,
     |  -6.8119898668954d-01, 2.1786676094157d-01, 8.3209900856530d-01,
     |   3.5105187088282d-01,-5.9666278180370d-01,-7.6759132190527d-01,
     |   6.8347023563924d-02, 8.2660987711973d-01, 5.1822852757315d-01,
     |  -4.6952496675144d-01,-8.7209636584276d-01,-1.6547039988186d-01,
     |   7.7114484330016d-01, 7.6490262801022d-01,-1.9372942887342d-01,
     |  -9.5077556561396d-01,-5.9296506681218d-01, 4.8131451206939d-01,
     |   1.0569561431515d+00, 4.8857495719765d-01,-6.3765025457229d-01,
     |  -1.1973983711387d+00,-6.7158696800008d-01, 4.7605633580044d-01,
     |   1.3888856997886d+00, 1.5924088314599d+00, 1.2189838413879d+00,
     |   6.8229585659816d-01, 2.8315662635148d-01, 8.5159379190072d-02,
     |   1.7532253102043d-02, 2.2221762395410d-03, 1.4230818021385d-04,
     |   3.0571507828667d-06, 7.5775997885850d-09, 1.5208240409972d-14/
      data (pmn(lat,13,30), lat = 1,72)/
     |   3.5525891626228d-16, 5.3380977446755d-10, 3.6277795606968d-07,
     |   2.4034636635373d-05, 4.9377421153506d-04, 4.9097746298003d-03,
     |   2.9337058196419d-02, 1.1860031843719d-01, 3.4718645280603d-01,
     |   7.6312076164281d-01, 1.2723334208275d+00, 1.5715963451830d+00,
     |   1.2945965521540d+00, 3.7110875089069d-01,-7.1646066379000d-01,
     |  -1.1760313691756d+00,-6.0889553869496d-01, 4.8130225037293d-01,
     |   1.0429435693930d+00, 5.1159187501480d-01,-5.3876272516803d-01,
     |  -9.5583933076733d-01,-2.8232319133209d-01, 6.9320983115415d-01,
     |   8.2708523267996d-01,-2.7083474852158d-02,-8.2773454126411d-01,
     |  -6.0078985518031d-01, 3.6238067939110d-01, 8.5901722326646d-01,
     |   2.7289769233267d-01,-6.5004040346928d-01,-7.4080305027228d-01,
     |   1.1123751429048d-01, 8.1677976286619d-01, 4.7512060050677d-01,
     |  -4.7512060050676d-01,-8.1677976286619d-01,-1.1123751429048d-01,
     |   7.4080305027228d-01, 6.5004040346928d-01,-2.7289769233268d-01,
     |  -8.5901722326646d-01,-3.6238067939111d-01, 6.0078985518031d-01,
     |   8.2773454126411d-01, 2.7083474852162d-02,-8.2708523267996d-01,
     |  -6.9320983115415d-01, 2.8232319133209d-01, 9.5583933076733d-01,
     |   5.3876272516804d-01,-5.1159187501480d-01,-1.0429435693930d+00,
     |  -4.8130225037294d-01, 6.0889553869496d-01, 1.1760313691756d+00,
     |   7.1646066378999d-01,-3.7110875089069d-01,-1.2945965521539d+00,
     |  -1.5715963451830d+00,-1.2723334208275d+00,-7.6312076164281d-01,
     |  -3.4718645280604d-01,-1.1860031843719d-01,-2.9337058196419d-02,
     |  -4.9097746298004d-03,-4.9377421153506d-04,-2.4034636635373d-05,
     |  -3.6277795606968d-07,-5.3380977446755d-10,-3.5525891626228d-16/
      data (pmn(lat,14,30), lat = 1,72)/
     |   7.5748036114215d-18, 3.4301711023609d-11, 3.9214429126313d-08,
     |   3.6895899215666d-06, 9.9408859406334d-05, 1.2401332291863d-03,
     |   9.0574041658812d-03, 4.4108797955720d-02, 1.5468042924998d-01,
     |   4.0875375359453d-01, 8.3287485610009d-01, 1.3104657858992d+00,
     |   1.5438938531879d+00, 1.2111558702547d+00, 2.8911921761978d-01,
     |  -7.4436026506119d-01,-1.1570445640075d+00,-5.9720375237901d-01,
     |   4.5952615973072d-01, 1.0296973983482d+00, 5.5609307146435d-01,
     |  -4.6919871285586d-01,-9.5741644453025d-01,-3.8453989298427d-01,
     |   5.9968525309165d-01, 8.7442662755533d-01, 1.3137588660768d-01,
     |  -7.4926374759717d-01,-7.2391182517585d-01, 1.6850071376426d-01,
     |   8.4430029924112d-01, 4.8402340619982d-01,-4.6549498024194d-01,
     |  -8.3485575713525d-01,-1.7072800635882d-01, 7.0279246907447d-01,
     |   7.0279246907447d-01,-1.7072800635881d-01,-8.3485575713525d-01,
     |  -4.6549498024194d-01, 4.8402340619982d-01, 8.4430029924112d-01,
     |   1.6850071376427d-01,-7.2391182517585d-01,-7.4926374759717d-01,
     |   1.3137588660768d-01, 8.7442662755533d-01, 5.9968525309166d-01,
     |  -3.8453989298427d-01,-9.5741644453025d-01,-4.6919871285586d-01,
     |   5.5609307146433d-01, 1.0296973983482d+00, 4.5952615973073d-01,
     |  -5.9720375237901d-01,-1.1570445640075d+00,-7.4436026506119d-01,
     |   2.8911921761978d-01, 1.2111558702547d+00, 1.5438938531879d+00,
     |   1.3104657858992d+00, 8.3287485610009d-01, 4.0875375359453d-01,
     |   1.5468042924998d-01, 4.4108797955720d-02, 9.0574041658812d-03,
     |   1.2401332291863d-03, 9.9408859406334d-05, 3.6895899215666d-06,
     |   3.9214429126313d-08, 3.4301711023609d-11, 7.5748036114215d-18/
      data (pmn(lat,15,30), lat = 1,72)/
     |   1.4788405472479d-19, 2.0171431593718d-12, 3.8749277617857d-09,
     |   5.1685937200886d-07, 1.8217126396811d-05, 2.8412438446569d-04,
     |   2.5241783284176d-03, 1.4708082874081d-02, 6.1189072875794d-02,
     |   1.9155429231848d-01, 4.6553042395481d-01, 8.9070303016716d-01,
     |   1.3354002928696d+00, 1.5132130992204d+00, 1.1417196324391d+00,
     |   2.3088413612546d-01,-7.5612409206773d-01,-1.1415551716737d+00,
     |  -6.0399404364928d-01, 4.2085569680611d-01, 1.0148644742215d+00,
     |   6.1525231827628d-01,-3.7979178156129d-01,-9.5005499919970d-01,
     |  -4.9970455400480d-01, 4.7758192041830d-01, 9.0399714776233d-01,
     |   3.0831348030152d-01,-6.2578379206358d-01,-8.2431119096713d-01,
     |  -6.2567735027097d-02, 7.6302571520847d-01, 6.8030713017098d-01,
     |  -2.0878853835669d-01,-8.4418697249945d-01,-4.6826891001435d-01,
     |   4.6826891001435d-01, 8.4418697249945d-01, 2.0878853835669d-01,
     |  -6.8030713017097d-01,-7.6302571520847d-01, 6.2567735027099d-02,
     |   8.2431119096713d-01, 6.2578379206359d-01,-3.0831348030152d-01,
     |  -9.0399714776233d-01,-4.7758192041831d-01, 4.9970455400480d-01,
     |   9.5005499919970d-01, 3.7979178156129d-01,-6.1525231827628d-01,
     |  -1.0148644742215d+00,-4.2085569680611d-01, 6.0399404364928d-01,
     |   1.1415551716737d+00, 7.5612409206773d-01,-2.3088413612545d-01,
     |  -1.1417196324391d+00,-1.5132130992204d+00,-1.3354002928696d+00,
     |  -8.9070303016716d-01,-4.6553042395481d-01,-1.9155429231848d-01,
     |  -6.1189072875795d-02,-1.4708082874081d-02,-2.5241783284176d-03,
     |  -2.8412438446570d-04,-1.8217126396811d-05,-5.1685937200886d-07,
     |  -3.8749277617857d-09,-2.0171431593718d-12,-1.4788405472479d-19/
      data (pmn(lat,16,30), lat = 1,72)/
     |   2.6495816614804d-21, 1.0881104156247d-13, 3.5091694055034d-10,
     |   6.6263180857836d-08, 3.0490032256467d-06, 5.9287273894010d-05,
     |   6.3828017832036d-04, 4.4272826292340d-03, 2.1696169181171d-02,
     |   7.9648433929939d-02, 2.2733842607049d-01, 5.1555912138705d-01,
     |   9.3624438009246d-01, 1.3492455453440d+00, 1.4830063693563d+00,
     |   1.0889186136290d+00, 1.9723482881131d-01,-7.5186448978854d-01,
     |  -1.1297588065064d+00,-6.3032428077122d-01, 3.6218808548428d-01,
     |   9.9450740970608d-01, 6.8818405905102d-01,-2.6560747836863d-01,
     |  -9.2568147303754d-01,-6.2425389624219d-01, 3.2008187374112d-01,
     |   9.0231030560679d-01, 4.9687518682304d-01,-4.4652653995884d-01,
     |  -8.7994488421210d-01,-3.2109415051024d-01, 5.9509319775765d-01,
     |   8.2669681342119d-01, 1.1120761280433d-01,-7.2957740946108d-01,
     |  -7.2957740946108d-01, 1.1120761280433d-01, 8.2669681342119d-01,
     |   5.9509319775765d-01,-3.2109415051024d-01,-8.7994488421210d-01,
     |  -4.4652653995884d-01, 4.9687518682304d-01, 9.0231030560679d-01,
     |   3.2008187374112d-01,-6.2425389624218d-01,-9.2568147303754d-01,
     |  -2.6560747836863d-01, 6.8818405905102d-01, 9.9450740970608d-01,
     |   3.6218808548429d-01,-6.3032428077122d-01,-1.1297588065064d+00,
     |  -7.5186448978854d-01, 1.9723482881130d-01, 1.0889186136290d+00,
     |   1.4830063693563d+00, 1.3492455453440d+00, 9.3624438009246d-01,
     |   5.1555912138705d-01, 2.2733842607049d-01, 7.9648433929939d-02,
     |   2.1696169181171d-02, 4.4272826292341d-03, 6.3828017832036d-04,
     |   5.9287273894011d-05, 3.0490032256467d-06, 6.6263180857836d-08,
     |   3.5091694055034d-10, 1.0881104156247d-13, 2.6495816614804d-21/
      data (pmn(lat,17,30), lat = 1,72)/
     |   4.3628781016681d-23, 5.3925022237550d-15, 2.9174320270605d-11,
     |   7.7896604444383d-09, 4.6715437045543d-07, 1.1299524879131d-05,
     |   1.4697545101311d-04, 1.2087241024946d-03, 6.9401742620975d-03,
     |   2.9657322216844d-02, 9.8372815825943d-02, 2.6021202165925d-01,
     |   5.5724435743326d-01, 9.6947041639554d-01, 1.3539777297251d+00,
     |   1.4561182581511d+00, 1.0548563149577d+00, 1.8919543346022d-01,
     |  -7.3066477398571d-01,-1.1205546914738d+00,-6.7662039944810d-01,
     |   2.7963810394598d-01, 9.6255034094665d-01, 7.7181874773175d-01,
     |  -1.2182187332030d-01,-8.7309420324727d-01,-7.5002217390591d-01,
     |   1.2200936823067d-01, 8.5122940610996d-01, 6.8175570871435d-01,
     |  -2.0453986924397d-01,-8.6103595435508d-01,-5.8239108231753d-01,
     |   3.2675046576214d-01, 8.7356350193043d-01, 4.5966088299543d-01,
     |  -4.5966088299543d-01,-8.7356350193043d-01,-3.2675046576214d-01,
     |   5.8239108231753d-01, 8.6103595435508d-01, 2.0453986924397d-01,
     |  -6.8175570871435d-01,-8.5122940610997d-01,-1.2200936823068d-01,
     |   7.5002217390590d-01, 8.7309420324728d-01, 1.2182187332031d-01,
     |  -7.7181874773175d-01,-9.6255034094665d-01,-2.7963810394598d-01,
     |   6.7662039944809d-01, 1.1205546914738d+00, 7.3066477398572d-01,
     |  -1.8919543346022d-01,-1.0548563149577d+00,-1.4561182581511d+00,
     |  -1.3539777297251d+00,-9.6947041639554d-01,-5.5724435743327d-01,
     |  -2.6021202165925d-01,-9.8372815825943d-02,-2.9657322216845d-02,
     |  -6.9401742620976d-03,-1.2087241024946d-03,-1.4697545101311d-04,
     |  -1.1299524879131d-05,-4.6715437045543d-07,-7.7896604444383d-09,
     |  -2.9174320270605d-11,-5.3925022237550d-15,-4.3628781016681d-23/
      data (pmn(lat,18,30), lat = 1,72)/
     |   6.6070571811240d-25, 2.4570468026859d-16, 2.2285885176391d-12,
     |   8.4056680775870d-10, 6.5610274478710d-08, 1.9704430882399d-06,
     |   3.0890592896013d-05, 3.0025027147022d-04, 2.0114439545884d-03,
     |   9.9497497874386d-03, 3.8060756712381d-02, 1.1615142912131d-01,
     |   2.8848955655854d-01, 5.8930859132360d-01, 9.9050453911045d-01,
     |   1.3512137235918d+00, 1.4346263197096d+00, 1.0410767285854d+00,
     |   2.0810263013036d-01,-6.9027376164212d-01,-1.1110576483972d+00,
     |  -7.4216543581594d-01, 1.6870817404590d-01, 9.1021530062543d-01,
     |   8.5959915725114d-01, 5.5001356635347d-02,-7.7786989979840d-01,
     |  -8.6198704940449d-01,-1.1694086838179d-01, 7.2899723166790d-01,
     |   8.3547647332647d-01, 9.6611168969382d-02,-7.3309673574173d-01,
     |  -8.0021371815632d-01,-3.6266082576483d-02, 7.6284160307954d-01,
     |   7.6284160307954d-01,-3.6266082576480d-02,-8.0021371815632d-01,
     |  -7.3309673574173d-01, 9.6611168969379d-02, 8.3547647332647d-01,
     |   7.2899723166790d-01,-1.1694086838178d-01,-8.6198704940449d-01,
     |  -7.7786989979840d-01, 5.5001356635343d-02, 8.5959915725113d-01,
     |   9.1021530062543d-01, 1.6870817404590d-01,-7.4216543581594d-01,
     |  -1.1110576483972d+00,-6.9027376164213d-01, 2.0810263013036d-01,
     |   1.0410767285854d+00, 1.4346263197096d+00, 1.3512137235918d+00,
     |   9.9050453911044d-01, 5.8930859132360d-01, 2.8848955655854d-01,
     |   1.1615142912131d-01, 3.8060756712381d-02, 9.9497497874387d-03,
     |   2.0114439545884d-03, 3.0025027147023d-04, 3.0890592896013d-05,
     |   1.9704430882399d-06, 6.5610274478710d-08, 8.4056680775870d-10,
     |   2.2285885176391d-12, 2.4570468026859d-16, 6.6070571811240d-25/
      data (pmn(lat,19,30), lat = 1,72)/
     |   9.2011955356771d-27, 1.0292583001879d-17, 1.5642839407488d-13,
     |   8.3276722646768d-11, 8.4504296662505d-09, 3.1462556725438d-07,
     |   5.9328529801416d-06, 6.7978770528242d-05, 5.2957891570252d-04,
     |   3.0191823941774d-03, 1.3242465277903d-02, 4.6257523446669d-02,
     |   1.3176036822710d-01, 3.1066770851593d-01, 6.1072300228996d-01,
     |   9.9943308001495d-01, 1.3419805197426d+00, 1.4196517472756d+00,
     |   1.0484572701833d+00, 2.5563044698940d-01,-6.2683237113274d-01,
     |  -1.0959664163879d+00,-8.2422197337670d-01, 2.4905784532729d-02,
     |   8.2562863017684d-01, 9.3969275098648d-01, 2.6450039779669d-01,
     |  -6.2334432350177d-01,-9.3583375182591d-01,-3.8685984799425d-01,
     |   5.1422265968447d-01, 9.1553273054086d-01, 4.3243893565416d-01,
     |  -4.6671262098566d-01,-9.0343693627885d-01,-4.4881130266843d-01,
     |   4.4881130266843d-01, 9.0343693627885d-01, 4.6671262098566d-01,
     |  -4.3243893565416d-01,-9.1553273054086d-01,-5.1422265968447d-01,
     |   3.8685984799425d-01, 9.3583375182591d-01, 6.2334432350177d-01,
     |  -2.6450039779669d-01,-9.3969275098648d-01,-8.2562863017685d-01,
     |  -2.4905784532732d-02, 8.2422197337670d-01, 1.0959664163879d+00,
     |   6.2683237113275d-01,-2.5563044698940d-01,-1.0484572701833d+00,
     |  -1.4196517472756d+00,-1.3419805197426d+00,-9.9943308001496d-01,
     |  -6.1072300228996d-01,-3.1066770851593d-01,-1.3176036822710d-01,
     |  -4.6257523446669d-02,-1.3242465277903d-02,-3.0191823941774d-03,
     |  -5.2957891570253d-04,-6.7978770528242d-05,-5.9328529801416d-06,
     |  -3.1462556725439d-07,-8.4504296662505d-09,-8.3276722646768d-11,
     |  -1.5642839407488d-13,-1.0292583001879d-17,-9.2011955356771d-27/
      data (pmn(lat,20,30), lat = 1,72)/
     |   1.1772933410513d-28, 3.9604312303230d-19, 1.0081165227152d-14,
     |   7.5697013786079d-12, 9.9761686590195d-10, 4.5987396261135d-08,
     |   1.0413318266234d-06, 1.4035423549325d-05, 1.2680553050698d-04,
     |   8.3031955794838d-04, 4.1570770652382d-03, 1.6522975444904d-02,
     |   5.3539218178232d-02, 1.4403905409355d-01, 3.2545269965227d-01,
     |   6.2062665667613d-01, 9.9612106411302d-01, 1.3264819121497d+00,
     |   1.4111158411098d+00, 1.0769689554337d+00, 3.3363532223155d-01,
     |  -5.3471106019213d-01,-1.0667967480081d+00,-9.1664566689542d-01,
     |  -1.5486334908951d-01, 6.9399753590409d-01, 9.9287126444420d-01,
     |   4.9849192088451d-01,-3.9382006697053d-01,-9.3646705641358d-01,
     |  -6.5997166109990d-01, 1.9518582732329d-01, 8.6584573453940d-01,
     |   7.4457554388573d-01,-5.8448587190259d-02,-8.0462221155074d-01,
     |  -8.0462221155074d-01,-5.8448587190262d-02, 7.4457554388572d-01,
     |   8.6584573453940d-01, 1.9518582732329d-01,-6.5997166109990d-01,
     |  -9.3646705641359d-01,-3.9382006697053d-01, 4.9849192088450d-01,
     |   9.9287126444420d-01, 6.9399753590409d-01,-1.5486334908951d-01,
     |  -9.1664566689542d-01,-1.0667967480081d+00,-5.3471106019213d-01,
     |   3.3363532223154d-01, 1.0769689554337d+00, 1.4111158411098d+00,
     |   1.3264819121497d+00, 9.9612106411303d-01, 6.2062665667614d-01,
     |   3.2545269965226d-01, 1.4403905409355d-01, 5.3539218178232d-02,
     |   1.6522975444904d-02, 4.1570770652382d-03, 8.3031955794839d-04,
     |   1.2680553050698d-04, 1.4035423549325d-05, 1.0413318266234d-06,
     |   4.5987396261137d-08, 9.9761686590195d-10, 7.5697013786079d-12,
     |   1.0081165227152d-14, 3.9604312303230d-19, 1.1772933410513d-28/
      data (pmn(lat,21,30), lat = 1,72)/
     |   1.3814308480244d-30, 1.3972715744826d-20, 5.9546439148660d-16,
     |   6.3026205761142d-13, 1.0778837808575d-10, 6.1450814598867d-09,
     |   1.6685738468761d-07, 2.6407927052498d-06, 2.7607661098341d-05,
     |   2.0704286452161d-04, 1.1789923641505d-03, 5.3075434452100d-03,
     |   1.9445512397032d-02, 5.9202626934943d-02, 1.5195978372606d-01,
     |   3.3177826603541d-01, 6.1825228080912d-01, 9.8005059866929d-01,
     |   1.3038677329984d+00, 1.4074188052633d+00, 1.1252334196084d+00,
     |   4.4369464908832d-01,-4.0661737733565d-01,-1.0110827021420d+00,
     |  -1.0078804589327d+00,-3.6965919669226d-01, 4.9912671840218d-01,
     |   9.9068584893157d-01, 7.3505552540088d-01,-8.1721998644430d-02,
     |  -8.2005068375874d-01,-8.8199053939506d-01,-2.1303181817047d-01,
     |   6.2910328816801d-01, 9.3141168327968d-01, 4.3498220594937d-01,
     |  -4.3498220594937d-01,-9.3141168327968d-01,-6.2910328816801d-01,
     |   2.1303181817047d-01, 8.8199053939506d-01, 8.2005068375874d-01,
     |   8.1721998644433d-02,-7.3505552540087d-01,-9.9068584893157d-01,
     |  -4.9912671840219d-01, 3.6965919669226d-01, 1.0078804589327d+00,
     |   1.0110827021420d+00, 4.0661737733565d-01,-4.4369464908832d-01,
     |  -1.1252334196084d+00,-1.4074188052633d+00,-1.3038677329984d+00,
     |  -9.8005059866930d-01,-6.1825228080913d-01,-3.3177826603542d-01,
     |  -1.5195978372606d-01,-5.9202626934943d-02,-1.9445512397032d-02,
     |  -5.3075434452100d-03,-1.1789923641505d-03,-2.0704286452162d-04,
     |  -2.7607661098341d-05,-2.6407927052498d-06,-1.6685738468761d-07,
     |  -6.1450814598870d-09,-1.0778837808575d-10,-6.3026205761142d-13,
     |  -5.9546439148660d-16,-1.3972715744826d-20,-1.3814308480244d-30/
      data (pmn(lat,22,30), lat = 1,72)/
     |   1.4821733939808d-32, 4.5068360552684d-22, 3.2144423658265d-17,
     |   4.7933710561138d-14, 1.0630251522978d-11, 7.4880500448588d-10,
     |   2.4351799740393d-08, 4.5187432225096d-07, 5.4560869577226d-06,
     |   4.6754470196258d-05, 3.0193730280601d-04, 1.5338567743225d-03,
     |   6.3241902307610d-03, 2.1654842288108d-02, 6.2617194011806d-02,
     |   1.5469373408892d-01, 3.2882844150476d-01, 6.0288227125876d-01,
     |   9.5020854228231d-01, 1.2720241435477d+00, 1.4050304545415d+00,
     |   1.1898019541427d+00, 5.8615884524572d-01,-2.3426413871644d-01,
     |  -9.1184686041661d-01,-1.0783876660177d+00,-6.1008273719896d-01,
     |   2.2757717344722d-01, 8.9553822315022d-01, 9.3134035874205d-01,
     |   2.9936814870657d-01,-5.4436184606943d-01,-9.6752086316550d-01,
     |  -6.4350615237527d-01, 1.7953651740795d-01, 8.5837841847823d-01,
     |   8.5837841847823d-01, 1.7953651740795d-01,-6.4350615237527d-01,
     |  -9.6752086316550d-01,-5.4436184606943d-01, 2.9936814870657d-01,
     |   9.3134035874205d-01, 8.9553822315023d-01, 2.2757717344722d-01,
     |  -6.1008273719896d-01,-1.0783876660177d+00,-9.1184686041662d-01,
     |  -2.3426413871645d-01, 5.8615884524572d-01, 1.1898019541427d+00,
     |   1.4050304545415d+00, 1.2720241435477d+00, 9.5020854228231d-01,
     |   6.0288227125877d-01, 3.2882844150476d-01, 1.5469373408892d-01,
     |   6.2617194011806d-02, 2.1654842288108d-02, 6.3241902307610d-03,
     |   1.5338567743225d-03, 3.0193730280601d-04, 4.6754470196258d-05,
     |   5.4560869577227d-06, 4.5187432225096d-07, 2.4351799740393d-08,
     |   7.4880500448591d-10, 1.0630251522978d-11, 4.7933710561138d-14,
     |   3.2144423658265d-17, 4.5068360552684d-22, 1.4821733939808d-32/
      data (pmn(lat,23,30), lat = 1,72)/
     |   1.4478241070389d-34, 1.3232623206249d-23, 1.5791000573715d-18,
     |   3.3160189003357d-15, 9.5301210738576d-13, 8.2877652564258d-11,
     |   3.2247381703387d-09, 7.0067948416896d-08, 9.7557723023331d-07,
     |   9.5338086489752d-06, 6.9655759648131d-05, 3.9811818338725d-04,
     |   1.8403311473738d-03, 7.0533261697603d-03, 2.2833310509633d-02,
     |   6.3293464947074d-02, 1.5167916140904d-01, 3.1608271705939d-01,
     |   5.7386516577194d-01, 9.0506486932875d-01, 1.2274309537256d+00,
     |   1.3980187605178d+00, 1.2641026577555d+00, 7.5848900484824d-01,
     |  -1.0076602912477d-02,-7.4800348495949d-01,-1.0980020662629d+00,
     |  -8.5171159619404d-01,-1.2267023387892d-01, 6.6592326812394d-01,
     |   1.0180836395127d+00, 6.9524833035820d-01,-9.4394810085028d-02,
     |  -8.1153371461728d-01,-9.5340196008565d-01,-4.1697248655583d-01,
     |   4.1697248655583d-01, 9.5340196008564d-01, 8.1153371461728d-01,
     |   9.4394810085030d-02,-6.9524833035820d-01,-1.0180836395127d+00,
     |  -6.6592326812394d-01, 1.2267023387891d-01, 8.5171159619404d-01,
     |   1.0980020662629d+00, 7.4800348495949d-01, 1.0076602912481d-02,
     |  -7.5848900484824d-01,-1.2641026577555d+00,-1.3980187605178d+00,
     |  -1.2274309537256d+00,-9.0506486932876d-01,-5.7386516577195d-01,
     |  -3.1608271705939d-01,-1.5167916140904d-01,-6.3293464947074d-02,
     |  -2.2833310509632d-02,-7.0533261697603d-03,-1.8403311473739d-03,
     |  -3.9811818338725d-04,-6.9655759648131d-05,-9.5338086489754d-06,
     |  -9.7557723023333d-07,-7.0067948416897d-08,-3.2247381703387d-09,
     |  -8.2877652564262d-11,-9.5301210738576d-13,-3.3160189003357d-15,
     |  -1.5791000573715d-18,-1.3232623206249d-23,-1.4478241070389d-34/
      data (pmn(lat,24,30), lat = 1,72)/
     |   1.2796912228199d-36, 3.5150921959878d-25, 7.0164401643424d-20,
     |   2.0740652256750d-16, 7.7204786631163d-14, 8.2829917752222d-12,
     |   3.8525555590261d-10, 9.7910686463043d-09, 1.5698601018011d-07,
     |   1.7466644887225d-06, 1.4408546752171d-05, 9.2424757063563d-05,
     |   4.7754103542703d-04, 2.0408028002544d-03, 7.3605551068689d-03,
     |   2.2750182996165d-02, 6.0951211900157d-02, 1.4269833232501d-01,
     |   2.9340279297216d-01, 5.3072980893493d-01, 8.4270494715597d-01,
     |   1.1651799571846d+00, 1.3776195207547d+00, 1.3370830433902d+00,
     |   9.5265747510333d-01, 2.6936911923346d-01,-4.9694532003199d-01,
     |  -1.0246707853149d+00,-1.0469864750356d+00,-5.2714760736887d-01,
     |   2.7236149553987d-01, 9.0373399573962d-01, 9.9032668630400d-01,
     |   4.7125490035355d-01,-3.3799579904746d-01,-9.3063531831659d-01,
     |  -9.3063531831659d-01,-3.3799579904746d-01, 4.7125490035355d-01,
     |   9.9032668630400d-01, 9.0373399573962d-01, 2.7236149553987d-01,
     |  -5.2714760736887d-01,-1.0469864750356d+00,-1.0246707853149d+00,
     |  -4.9694532003199d-01, 2.6936911923346d-01, 9.5265747510333d-01,
     |   1.3370830433902d+00, 1.3776195207547d+00, 1.1651799571846d+00,
     |   8.4270494715598d-01, 5.3072980893493d-01, 2.9340279297216d-01,
     |   1.4269833232501d-01, 6.0951211900157d-02, 2.2750182996165d-02,
     |   7.3605551068688d-03, 2.0408028002544d-03, 4.7754103542704d-04,
     |   9.2424757063563d-05, 1.4408546752171d-05, 1.7466644887226d-06,
     |   1.5698601018012d-07, 9.7910686463045d-09, 3.8525555590261d-10,
     |   8.2829917752226d-12, 7.7204786631163d-14, 2.0740652256750d-16,
     |   7.0164401643424d-20, 3.5150921959878d-25, 1.2796912228199d-36/
      data (pmn(lat,25,30), lat = 1,72)/
     |   1.0145436044225d-38, 8.3744078348823d-27, 2.7954416274093d-21,
     |   1.1627894106593d-17, 5.6034235485052d-15, 7.4118865354992d-13,
     |   4.1176986220602d-11, 1.2228500940750d-09, 2.2551915050956d-08,
     |   2.8527245047968d-07, 2.6524468635357d-06, 1.9055811048859d-05,
     |   1.0977214768124d-04, 5.2147001211846d-04, 2.0873816493694d-03,
     |   7.1589697046809d-03, 2.1308813599109d-02, 5.5584990755552d-02,
     |   1.2796751738562d-01, 2.6117779333648d-01, 4.7343872783767d-01,
     |   7.6120539882173d-01, 1.0793210334304d+00, 1.3320923863434d+00,
     |   1.3917783551498d+00, 1.1515575111102d+00, 5.9737543461825d-01,
     |  -1.4133745712117d-01,-8.0779973535728d-01,-1.1187005574344d+00,
     |  -9.1351254054502d-01,-2.6910344033988d-01, 5.0378373021135d-01,
     |   1.0049232486708d+00, 9.6185086818254d-01, 3.9261237718284d-01,
     |  -3.9261237718284d-01,-9.6185086818254d-01,-1.0049232486708d+00,
     |  -5.0378373021135d-01, 2.6910344033987d-01, 9.1351254054502d-01,
     |   1.1187005574344d+00, 8.0779973535728d-01, 1.4133745712117d-01,
     |  -5.9737543461824d-01,-1.1515575111102d+00,-1.3917783551498d+00,
     |  -1.3320923863434d+00,-1.0793210334304d+00,-7.6120539882173d-01,
     |  -4.7343872783767d-01,-2.6117779333648d-01,-1.2796751738562d-01,
     |  -5.5584990755552d-02,-2.1308813599109d-02,-7.1589697046810d-03,
     |  -2.0873816493694d-03,-5.2147001211846d-04,-1.0977214768124d-04,
     |  -1.9055811048859d-05,-2.6524468635357d-06,-2.8527245047968d-07,
     |  -2.2551915050956d-08,-1.2228500940750d-09,-4.1176986220602d-11,
     |  -7.4118865354996d-13,-5.6034235485052d-15,-1.1627894106593d-17,
     |  -2.7954416274093d-21,-8.3744078348823d-27,-1.0145436044225d-38/
      data (pmn(lat,26,30), lat = 1,72)/
     |   7.1239271695519d-41, 1.7668948893340d-28, 9.8613031213457d-23,
     |   5.7702446145336d-19, 3.5982520637411d-16, 5.8648864706379d-14,
     |   3.8891104821266d-12, 1.3484664032143d-10, 2.8575030458118d-09,
     |   4.1044862734103d-08, 4.2952082679440d-07, 3.4499531311445d-06,
     |   2.2110613272538d-05, 1.1645873311040d-04, 5.1576172539844d-04,
     |   1.9552130268167d-03, 6.4344237182912d-03, 1.8585685628221d-02,
     |   4.7521450653455d-02, 1.0823710046333d-01, 2.2053413877120d-01,
     |   4.0281591408744d-01, 6.5936349119717d-01, 9.6379383231448d-01,
     |   1.2473349096322d+00, 1.4044493683278d+00, 1.3249129543823d+00,
     |   9.4816963511733d-01, 3.1726750646056d-01,-4.0204275299310d-01,
     |  -9.6362002403520d-01,-1.1410574682146d+00,-8.4342448495657d-01,
     |  -1.8274571172112d-01, 5.5531220208624d-01, 1.0359148987496d+00,
     |   1.0359148987496d+00, 5.5531220208624d-01,-1.8274571172112d-01,
     |  -8.4342448495657d-01,-1.1410574682146d+00,-9.6362002403520d-01,
     |  -4.0204275299311d-01, 3.1726750646056d-01, 9.4816963511733d-01,
     |   1.3249129543823d+00, 1.4044493683278d+00, 1.2473349096322d+00,
     |   9.6379383231449d-01, 6.5936349119717d-01, 4.0281591408744d-01,
     |   2.2053413877121d-01, 1.0823710046333d-01, 4.7521450653456d-02,
     |   1.8585685628221d-02, 6.4344237182913d-03, 1.9552130268167d-03,
     |   5.1576172539844d-04, 1.1645873311040d-04, 2.2110613272538d-05,
     |   3.4499531311445d-06, 4.2952082679440d-07, 4.1044862734104d-08,
     |   2.8575030458118d-09, 1.3484664032143d-10, 3.8891104821266d-12,
     |   5.8648864706382d-14, 3.5982520637411d-16, 5.7702446145336d-19,
     |   9.8613031213457d-23, 1.7668948893340d-28, 7.1239271695519d-41/
      data (pmn(lat,27,30), lat = 1,72)/
     |   4.3467165814473d-43, 3.2390760345718d-30, 3.0219876678357d-24,
     |   2.4868005180585d-20, 2.0059417262261d-17, 4.0268608675512d-15,
     |   3.1853541171803d-13, 1.2885353456452d-11, 3.1346657565974d-10,
     |   5.1073497948365d-09, 6.0076991122642d-08, 5.3867869683364d-07,
     |   3.8340651938215d-06, 2.2342469615491d-05, 1.0919157707400d-04,
     |   4.5610677787006d-04, 1.6531594372819d-03, 5.2622312168591d-03,
     |   1.4852793872692d-02, 3.7455911801300d-02, 8.4883814996810d-02,
     |   1.7359013248069d-01, 3.2115140558231d-01, 5.3787554373757d-01,
     |   8.1427511793042d-01, 1.1090204729581d+00, 1.3456408323708d+00,
     |   1.4264302397647d+00, 1.2660781537763d+00, 8.3616617793268d-01,
     |   2.0030769730020d-01,-4.8342127449665d-01,-1.0053410718739d+00,
     |  -1.1825627259802d+00,-9.4056334459527d-01,-3.5724405763081d-01,
     |   3.5724405763080d-01, 9.4056334459527d-01, 1.1825627259802d+00,
     |   1.0053410718739d+00, 4.8342127449665d-01,-2.0030769730020d-01,
     |  -8.3616617793268d-01,-1.2660781537763d+00,-1.4264302397647d+00,
     |  -1.3456408323708d+00,-1.1090204729581d+00,-8.1427511793042d-01,
     |  -5.3787554373757d-01,-3.2115140558231d-01,-1.7359013248069d-01,
     |  -8.4883814996811d-02,-3.7455911801300d-02,-1.4852793872692d-02,
     |  -5.2622312168591d-03,-1.6531594372819d-03,-4.5610677787006d-04,
     |  -1.0919157707400d-04,-2.2342469615491d-05,-3.8340651938216d-06,
     |  -5.3867869683364d-07,-6.0076991122642d-08,-5.1073497948366d-09,
     |  -3.1346657565974d-10,-1.2885353456452d-11,-3.1853541171803d-13,
     |  -4.0268608675514d-15,-2.0059417262261d-17,-2.4868005180585d-20,
     |  -3.0219876678357d-24,-3.2390760345718d-30,-4.3467165814473d-43/
      data (pmn(lat,28,30), lat = 1,72)/
     |   2.2341468944462d-45, 5.0015534449499d-32, 7.7992594116297d-26,
     |   9.0236407125749d-22, 9.4122150988900d-19, 2.3261149709626d-16,
     |   2.1937531693098d-14, 1.0346410967228d-12, 2.8872934430156d-11,
     |   5.3311527229077d-10, 7.0410950525051d-09, 7.0386141728003d-08,
     |   5.5550629060017d-07, 3.5749331509388d-06, 1.9238167098841d-05,
     |   8.8317144713022d-05, 3.5145071892569d-04, 1.2281352975839d-03,
     |   3.8085712176224d-03, 1.0571304853479d-02, 2.6445233610867d-02,
     |   5.9951670443755d-02, 1.2368377844128d-01, 2.3289836700193d-01,
     |   4.0095000133414d-01, 6.3121758234977d-01, 9.0724962672138d-01,
     |   1.1854534626189d+00, 1.3962080633732d+00, 1.4579441415884d+00,
     |   1.3037127507350d+00, 9.1252508221784d-01, 3.3201993547997d-01,
     |  -3.2099623050761d-01,-8.8803683786609d-01,-1.2177258351807d+00,
     |  -1.2177258351807d+00,-8.8803683786609d-01,-3.2099623050761d-01,
     |   3.3201993547997d-01, 9.1252508221784d-01, 1.3037127507350d+00,
     |   1.4579441415884d+00, 1.3962080633732d+00, 1.1854534626189d+00,
     |   9.0724962672138d-01, 6.3121758234977d-01, 4.0095000133414d-01,
     |   2.3289836700193d-01, 1.2368377844128d-01, 5.9951670443755d-02,
     |   2.6445233610867d-02, 1.0571304853479d-02, 3.8085712176225d-03,
     |   1.2281352975839d-03, 3.5145071892570d-04, 8.8317144713023d-05,
     |   1.9238167098841d-05, 3.5749331509387d-06, 5.5550629060018d-07,
     |   7.0386141728003d-08, 7.0410950525051d-09, 5.3311527229078d-10,
     |   2.8872934430156d-11, 1.0346410967228d-12, 2.1937531693098d-14,
     |   2.3261149709627d-16, 9.4122150988900d-19, 9.0236407125749d-22,
     |   7.7992594116297d-26, 5.0015534449499d-32, 2.2341468944462d-45/
      data (pmn(lat,29,30), lat = 1,72)/
     |   9.1302903959538d-48, 6.1401569863975d-34, 1.6000772583595d-27,
     |   2.6022701845041d-23, 3.5088354796070d-20, 1.0671463323594d-17,
     |   1.1993234795327d-15, 6.5909447686342d-14, 2.1083949424396d-12,
     |   4.4080787474106d-11, 6.5305993367531d-10, 7.2699332126492d-09,
     |   6.3536636093889d-08, 4.5084732232520d-07, 2.6666226411814d-06,
     |   1.3424533546042d-05, 5.8500921686910d-05, 2.2372794443675d-04,
     |   7.5941553765842d-04, 2.3094068859123d-03, 6.3409213850262d-03,
     |   1.5820844591543d-02, 3.6060941594467d-02, 7.5413601307389d-02,
     |   1.4519495053501d-01, 2.5801964767630d-01, 4.2391947117046d-01,
     |   6.4439860981077d-01, 9.0588348484851d-01, 1.1753455392515d+00,
     |   1.4013615504610d+00, 1.5227653683843d+00, 1.4842529378605d+00,
     |   1.2547804546612d+00, 8.4208661897713d-01, 2.9683044089752d-01,
     |  -2.9683044089752d-01,-8.4208661897713d-01,-1.2547804546612d+00,
     |  -1.4842529378605d+00,-1.5227653683843d+00,-1.4013615504610d+00,
     |  -1.1753455392515d+00,-9.0588348484851d-01,-6.4439860981077d-01,
     |  -4.2391947117046d-01,-2.5801964767631d-01,-1.4519495053501d-01,
     |  -7.5413601307389d-02,-3.6060941594467d-02,-1.5820844591543d-02,
     |  -6.3409213850263d-03,-2.3094068859123d-03,-7.5941553765842d-04,
     |  -2.2372794443675d-04,-5.8500921686910d-05,-1.3424533546043d-05,
     |  -2.6666226411814d-06,-4.5084732232520d-07,-6.3536636093890d-08,
     |  -7.2699332126492d-09,-6.5305993367531d-10,-4.4080787474107d-11,
     |  -2.1083949424397d-12,-6.5909447686343d-14,-1.1993234795327d-15,
     |  -1.0671463323595d-17,-3.5088354796070d-20,-2.6022701845041d-23,
     |  -1.6000772583595d-27,-6.1401569863975d-34,-9.1302903959538d-48/
      data (pmn(lat,30,30), lat = 1,72)/
     |   2.5719661994874d-50, 5.1955703800246d-36, 2.2622994239214d-29,
     |   5.1707902380018d-25, 9.0105057213558d-22, 3.3711614908134d-19,
     |   4.5129411169764d-17, 2.8883732147171d-15, 1.0584991957996d-13,
     |   2.5040142139528d-12, 4.1576930550406d-11, 5.1490305811489d-10,
     |   4.9774261592483d-09, 3.8890762341621d-08, 2.5242151089953d-07,
     |   1.3909596687733d-06, 6.6233090613521d-06, 2.7649604268331d-05,
     |   1.0241404998350d-04, 3.3996710235650d-04, 1.0199662117830d-03,
     |   2.7855670356090d-03, 6.9673696183423d-03, 1.6044190944934d-02,
     |   3.4166871367591d-02, 6.7546390016346d-02, 1.2437831496506d-01,
     |   2.1392659456451d-01, 3.4452080644290d-01, 5.2058419895538d-01,
     |   7.3933857463231d-01, 9.8831543921002d-01, 1.2449506389664d+00,
     |   1.4791334637284d+00, 1.6586385640300d+00, 1.7562103034203d+00,
     |   1.7562103034203d+00, 1.6586385640300d+00, 1.4791334637284d+00,
     |   1.2449506389664d+00, 9.8831543921002d-01, 7.3933857463231d-01,
     |   5.2058419895538d-01, 3.4452080644290d-01, 2.1392659456452d-01,
     |   1.2437831496506d-01, 6.7546390016347d-02, 3.4166871367591d-02,
     |   1.6044190944934d-02, 6.9673696183423d-03, 2.7855670356090d-03,
     |   1.0199662117830d-03, 3.3996710235651d-04, 1.0241404998350d-04,
     |   2.7649604268331d-05, 6.6233090613521d-06, 1.3909596687733d-06,
     |   2.5242151089953d-07, 3.8890762341620d-08, 4.9774261592484d-09,
     |   5.1490305811489d-10, 4.1576930550406d-11, 2.5040142139528d-12,
     |   1.0584991957996d-13, 2.8883732147171d-15, 4.5129411169764d-17,
     |   3.3711614908136d-19, 9.0105057213558d-22, 5.1707902380018d-25,
     |   2.2622994239214d-29, 5.1955703800246d-36, 2.5719661994874d-50/
      data (pmn(lat, 0,31), lat = 1,72)/
     |   4.9692753399860d+00, 1.0578413851532d+00,-2.0816027701083d+00,
     |  -1.3338814139364d+00, 1.1164895952264d+00, 1.4539713881346d+00,
     |  -4.1794982032917d-01,-1.4012030203689d+00,-1.4323576652067d-01,
     |   1.1993288506895d+00, 5.7384304373049d-01,-8.8379040736050d-01,
     |  -8.6068901031100d-01, 4.9890426134917d-01, 9.9436187973413d-01,
     |  -9.3879270082096d-02,-9.7729706604282d-01,-2.8228715925445d-01,
     |   8.2614178807358d-01, 5.8616651747754d-01,-5.7088580580109d-01,
     |  -7.8471708568999d-01, 2.5176201684766d-01, 8.5890940956319d-01,
     |   8.5361437073060d-02,-8.0568819252721d-01,-3.9438858983995d-01,
     |   6.3801905983417d-01, 6.3447589467655d-01,-3.8300952086406d-01,
     |  -7.7488539520322d-01, 7.8331069473443d-02, 7.9860435599014d-01,
     |   2.3262284667982d-01,-7.0428345517078d-01,-5.0625434035519d-01,
     |   5.0625434035519d-01, 7.0428345517078d-01,-2.3262284667981d-01,
     |  -7.9860435599014d-01,-7.8331069473447d-02, 7.7488539520322d-01,
     |   3.8300952086407d-01,-6.3447589467654d-01,-6.3801905983418d-01,
     |   3.9438858983994d-01, 8.0568819252721d-01,-8.5361437073053d-02,
     |  -8.5890940956319d-01,-2.5176201684766d-01, 7.8471708568999d-01,
     |   5.7088580580110d-01,-5.8616651747754d-01,-8.2614178807358d-01,
     |   2.8228715925445d-01, 9.7729706604282d-01, 9.3879270082102d-02,
     |  -9.9436187973413d-01,-4.9890426134917d-01, 8.6068901031099d-01,
     |   8.8379040736050d-01,-5.7384304373049d-01,-1.1993288506895d+00,
     |   1.4323576652065d-01, 1.4012030203689d+00, 4.1794982032917d-01,
     |  -1.4539713881346d+00,-1.1164895952264d+00, 1.3338814139364d+00,
     |   2.0816027701083d+00,-1.0578413851532d+00,-4.9692753399860d+00/
      data (pmn(lat, 1,31), lat = 1,72)/
     |   1.8167560511811d+00, 3.2115690894894d+00, 9.2316978201170d-01,
     |  -1.6884780372340d+00,-1.3325713345756d+00, 8.4301853702441d-01,
     |   1.4277970106748d+00,-1.8710316640076d-01,-1.3241844359455d+00,
     |  -3.3275077288439d-01, 1.0724224880448d+00, 7.1099067989469d-01,
     |  -7.1990682629959d-01,-9.3550489945557d-01, 3.1743503288292d-01,
     |   1.0025595760365d+00, 8.3077899593527d-02,-9.2192718007559d-01,
     |  -4.3323561160133d-01, 7.1760772380230d-01, 6.9311997906787d-01,
     |  -4.2577514390940d-01,-8.3552210283923d-01, 9.0804756074027d-02,
     |   8.4876654252583d-01, 2.3988844057551d-01,-7.3771937909922d-01,
     |  -5.2146209482086d-01, 5.2282955760290d-01, 7.1697403836003d-01,
     |  -2.3730805899476d-01,-8.0175118013062d-01,-7.7217274112928d-02,
     |   7.6625578622665d-01, 3.7604523595530d-01,-6.1709458386871d-01,
     |  -6.1709458386871d-01, 3.7604523595529d-01, 7.6625578622665d-01,
     |  -7.7217274112925d-02,-8.0175118013062d-01,-2.3730805899476d-01,
     |   7.1697403836003d-01, 5.2282955760291d-01,-5.2146209482086d-01,
     |  -7.3771937909922d-01, 2.3988844057551d-01, 8.4876654252583d-01,
     |   9.0804756074031d-02,-8.3552210283923d-01,-4.2577514390940d-01,
     |   6.9311997906785d-01, 7.1760772380230d-01,-4.3323561160132d-01,
     |  -9.2192718007559d-01, 8.3077899593518d-02, 1.0025595760365d+00,
     |   3.1743503288292d-01,-9.3550489945557d-01,-7.1990682629960d-01,
     |   7.1099067989469d-01, 1.0724224880448d+00,-3.3275077288437d-01,
     |  -1.3241844359455d+00,-1.8710316640077d-01, 1.4277970106748d+00,
     |   8.4301853702443d-01,-1.3325713345756d+00,-1.6884780372340d+00,
     |   9.2316978201170d-01, 3.2115690894894d+00, 1.8167560511811d+00/
      data (pmn(lat, 2,31), lat = 1,72)/
     |   3.1810847555442d-01, 2.0556763267139d+00, 2.6195123724163d+00,
     |   6.3791526107402d-01,-1.5434515238807d+00,-1.2364523140180d+00,
     |   7.2974403289656d-01, 1.3675818438678d+00,-7.3064189164659d-02,
     |  -1.2486090494606d+00,-4.3619207456770d-01, 9.6705960985869d-01,
     |   7.8614734403837d-01,-5.8840300620780d-01,-9.6784714768690d-01,
     |   1.7337608411851d-01, 9.8430530991079d-01, 2.2135618828177d-01,
     |  -8.5333800565228d-01,-5.4675577790120d-01, 6.0682212793592d-01,
     |   7.6566515066207d-01,-2.8750267407889d-01,-8.5627406448040d-01,
     |  -5.5849006622676d-02, 8.1402124282773d-01, 3.7415355767725d-01,
     |  -6.5155309205198d-01,-6.2383529520132d-01, 3.9667977323758d-01,
     |   7.7197661042881d-01,-8.8547253286237d-02,-8.0016607231729d-01,
     |  -2.2752348070618d-01, 7.0656117934392d-01, 5.0590955549779d-01,
     |  -5.0590955549779d-01,-7.0656117934392d-01, 2.2752348070618d-01,
     |   8.0016607231729d-01, 8.8547253286240d-02,-7.7197661042881d-01,
     |  -3.9667977323758d-01, 6.2383529520131d-01, 6.5155309205199d-01,
     |  -3.7415355767725d-01,-8.1402124282773d-01, 5.5849006622669d-02,
     |   8.5627406448040d-01, 2.8750267407889d-01,-7.6566515066207d-01,
     |  -6.0682212793593d-01, 5.4675577790120d-01, 8.5333800565229d-01,
     |  -2.2135618828177d-01,-9.8430530991079d-01,-1.7337608411851d-01,
     |   9.6784714768690d-01, 5.8840300620780d-01,-7.8614734403836d-01,
     |  -9.6705960985869d-01, 4.3619207456770d-01, 1.2486090494606d+00,
     |   7.3064189164675d-02,-1.3675818438678d+00,-7.2974403289656d-01,
     |   1.2364523140180d+00, 1.5434515238807d+00,-6.3791526107402d-01,
     |  -2.6195123724163d+00,-2.0556763267139d+00,-3.1810847555442d-01/
      data (pmn(lat, 3,31), lat = 1,72)/
     |   3.6684781586938d-02, 7.7720008057973d-01, 2.1218527504297d+00,
     |   2.2198635432838d+00, 3.4682605378347d-01,-1.4884033503248d+00,
     |  -1.1117618663070d+00, 7.0069051560486d-01, 1.3029338758635d+00,
     |  -2.8055515213189d-02,-1.1872697366208d+00,-4.8788602251425d-01,
     |   8.8639801939991d-01, 8.2522355246683d-01,-4.8622478560855d-01,
     |  -9.7707292347008d-01, 5.9729848622050d-02, 9.5325099103902d-01,
     |   3.3005275020683d-01,-7.8014238213807d-01,-6.3248417721200d-01,
     |   4.9815351972647d-01, 8.1274391663359d-01,-1.5717847983259d-01,
     |  -8.5438951784462d-01,-1.8923788626261d-01, 7.6018599363632d-01,
     |   4.9024232347852d-01,-5.5086469135141d-01,-7.0369830602956d-01,
     |   2.6185232090357d-01, 8.0113213717770d-01, 6.1685228305468d-02,
     |  -7.7098267148892d-01,-3.7090793035768d-01, 6.1975124180427d-01,
     |   6.1975124180427d-01,-3.7090793035767d-01,-7.7098267148892d-01,
     |   6.1685228305465d-02, 8.0113213717770d-01, 2.6185232090357d-01,
     |  -7.0369830602956d-01,-5.5086469135141d-01, 4.9024232347852d-01,
     |   7.6018599363632d-01,-1.8923788626260d-01,-8.5438951784462d-01,
     |  -1.5717847983259d-01, 8.1274391663359d-01, 4.9815351972647d-01,
     |  -6.3248417721199d-01,-7.8014238213807d-01, 3.3005275020682d-01,
     |   9.5325099103902d-01, 5.9729848622059d-02,-9.7707292347009d-01,
     |  -4.8622478560854d-01, 8.2522355246683d-01, 8.8639801939992d-01,
     |  -4.8788602251425d-01,-1.1872697366208d+00,-2.8055515213200d-02,
     |   1.3029338758635d+00, 7.0069051560487d-01,-1.1117618663070d+00,
     |  -1.4884033503248d+00, 3.4682605378347d-01, 2.2198635432838d+00,
     |   2.1218527504297d+00, 7.7720008057973d-01, 3.6684781586938d-02/
      data (pmn(lat, 4,31), lat = 1,72)/
     |   3.1506096038120d-03, 2.1073806093176d-01, 1.0858549901022d+00,
     |   2.1244295579336d+00, 1.8823550799719d+00, 7.4421948456052d-02,
     |  -1.4630311809012d+00,-9.7613742030303d-01, 7.1545216626126d-01,
     |   1.2402048652519d+00,-2.3911878577386d-02,-1.1404611256868d+00,
     |  -5.0858072308887d-01, 8.2691183731070d-01, 8.4370854647632d-01,
     |  -4.0723797912220d-01,-9.7425994917657d-01,-3.1178819707752d-02,
     |   9.1650349189967d-01, 4.1729758169233d-01,-7.0596929405525d-01,
     |  -6.9799838676799d-01, 3.9246557380860d-01, 8.4061083447073d-01,
     |  -3.3819265206508d-02,-8.3439567501942d-01,-3.1118786143556d-01,
     |   6.9008414975053d-01, 5.8990237727290d-01,-4.3720411348294d-01,
     |  -7.6205542099821d-01, 1.1936037243177d-01, 8.0443152147813d-01,
     |   2.1203559963125d-01,-7.1338026109630d-01,-5.0486403277559d-01,
     |   5.0486403277558d-01, 7.1338026109630d-01,-2.1203559963125d-01,
     |  -8.0443152147813d-01,-1.1936037243177d-01, 7.6205542099821d-01,
     |   4.3720411348295d-01,-5.8990237727289d-01,-6.9008414975054d-01,
     |   3.1118786143556d-01, 8.3439567501942d-01, 3.3819265206515d-02,
     |  -8.4061083447073d-01,-3.9246557380860d-01, 6.9799838676799d-01,
     |   7.0596929405526d-01,-4.1729758169232d-01,-9.1650349189967d-01,
     |   3.1178819707748d-02, 9.7425994917657d-01, 4.0723797912220d-01,
     |  -8.4370854647632d-01,-8.2691183731070d-01, 5.0858072308886d-01,
     |   1.1404611256868d+00, 2.3911878577386d-02,-1.2402048652519d+00,
     |  -7.1545216626127d-01, 9.7613742030302d-01, 1.4630311809012d+00,
     |  -7.4421948456032d-02,-1.8823550799719d+00,-2.1244295579336d+00,
     |  -1.0858549901022d+00,-2.1073806093176d-01,-3.1506096038120d-03/
      data (pmn(lat, 5,31), lat = 1,72)/
     |   2.1515395351131d-04, 4.4639469785351d-02, 4.1359035866963d-01,
     |   1.3127791317536d+00, 2.0800176143731d+00, 1.5725576088540d+00,
     |  -1.7165936001862d-01,-1.4414494923052d+00,-8.3619642524355d-01,
     |   7.5141868877313d-01, 1.1797034550864d+00,-4.3527100672391d-02,
     |  -1.1050987060540d+00,-5.1105426912247d-01, 7.8348450835256d-01,
     |   8.5088460515274d-01,-3.4504006022186d-01,-9.6552321567784d-01,
     |  -1.0627721349808d-01, 8.7725168589480d-01, 4.8969196429519d-01,
     |  -6.3152563024102d-01,-7.4879161358487d-01, 2.8871446266755d-01,
     |   8.5313739021348d-01, 8.4429637778079d-02,-7.9844313209378d-01,
     |  -4.2339468336026d-01, 6.0450983756108d-01, 6.7388882958691d-01,
     |  -3.1077688732181d-01,-7.9832995611869d-01,-3.0167907243261d-02,
     |   7.8010762263289d-01, 3.6043321494938d-01,-6.2512318330333d-01,
     |  -6.2512318330333d-01, 3.6043321494938d-01, 7.8010762263289d-01,
     |  -3.0167907243259d-02,-7.9832995611869d-01,-3.1077688732181d-01,
     |   6.7388882958691d-01, 6.0450983756108d-01,-4.2339468336026d-01,
     |  -7.9844313209378d-01, 8.4429637778074d-02, 8.5313739021347d-01,
     |   2.8871446266756d-01,-7.4879161358487d-01,-6.3152563024102d-01,
     |   4.8969196429518d-01, 8.7725168589480d-01,-1.0627721349807d-01,
     |  -9.6552321567784d-01,-3.4504006022187d-01, 8.5088460515274d-01,
     |   7.8348450835255d-01,-5.1105426912247d-01,-1.1050987060540d+00,
     |  -4.3527100672391d-02, 1.1797034550864d+00, 7.5141868877314d-01,
     |  -8.3619642524354d-01,-1.4414494923052d+00,-1.7165936001862d-01,
     |   1.5725576088540d+00, 2.0800176143731d+00, 1.3127791317536d+00,
     |   4.1359035866963d-01, 4.4639469785351d-02, 2.1515395351131d-04/
      data (pmn(lat, 6,31), lat = 1,72)/
     |   1.2167044315076d-05, 7.7541751127297d-03, 1.2609756579899d-01,
     |   6.1450200792146d-01, 1.4793441719190d+00, 1.9971830390931d+00,
     |   1.2807348583662d+00,-3.8788790882273d-01,-1.4124377778743d+00,
     |  -6.9604028410494d-01, 7.9531270688090d-01, 1.1207932954001d+00,
     |  -7.5943894365859d-02,-1.0777950984172d+00,-5.0357189692008d-01,
     |   7.5116495849159d-01, 8.5245953449169d-01,-2.9384482243486d-01,
     |  -9.5405645230915d-01,-1.7141922989328d-01, 8.3634361179196d-01,
     |   5.5232233677418d-01,-5.5581189936824d-01,-7.8848308434909d-01,
     |   1.8489906038626d-01, 8.5214525296091d-01, 1.9952987449310d-01,
     |  -7.4674662149249d-01,-5.2680022720985d-01, 5.0279917874773d-01,
     |   7.4148755355051d-01,-1.7117757853935d-01,-8.1009880429813d-01,
     |  -1.8558923789568d-01, 7.2469516934375d-01, 5.0308349349450d-01,
     |  -5.0308349349449d-01,-7.2469516934375d-01, 1.8558923789568d-01,
     |   8.1009880429813d-01, 1.7117757853935d-01,-7.4148755355051d-01,
     |  -5.0279917874774d-01, 5.2680022720984d-01, 7.4674662149250d-01,
     |  -1.9952987449310d-01,-8.5214525296090d-01,-1.8489906038627d-01,
     |   7.8848308434909d-01, 5.5581189936824d-01,-5.5232233677418d-01,
     |  -8.3634361179197d-01, 1.7141922989328d-01, 9.5405645230916d-01,
     |   2.9384482243486d-01,-8.5245953449168d-01,-7.5116495849160d-01,
     |   5.0357189692009d-01, 1.0777950984172d+00, 7.5943894365873d-02,
     |  -1.1207932954001d+00,-7.9531270688090d-01, 6.9604028410493d-01,
     |   1.4124377778743d+00, 3.8788790882274d-01,-1.2807348583662d+00,
     |  -1.9971830390931d+00,-1.4793441719190d+00,-6.1450200792146d-01,
     |  -1.2609756579899d-01,-7.7541751127297d-03,-1.2167044315076d-05/
      data (pmn(lat, 7,31), lat = 1,72)/
     |   5.8565431954122d-07, 1.1396651273474d-03, 3.2077457898251d-02,
     |   2.3335494361940d-01, 8.0240874573139d-01, 1.5951919506941d+00,
     |   1.8834632126924d+00, 1.0056432356821d+00,-5.7262084994912d-01,
     |  -1.3720220073649d+00,-5.5924258332509d-01, 8.3918046119292d-01,
     |   1.0633309000704d+00,-1.1373308966934d-01,-1.0558044356294d+00,
     |  -4.9185396822209d-01, 7.2565960636631d-01, 8.5209516773790d-01,
     |  -2.4863408058726d-01,-9.4130327228540d-01,-2.3144151350563d-01,
     |   7.9317293378198d-01, 6.0891544603109d-01,-4.7681298441709d-01,
     |  -8.1901529031763d-01, 7.8648131653008d-02, 8.3765155296565d-01,
     |   3.1300090487927d-01,-6.7793783954861d-01,-6.2107408440155d-01,
     |   3.8337415133850d-01, 7.9009974089738d-01,-1.8186383993316d-02,
     |  -7.9293244502346d-01,-3.4420962690390d-01, 6.3333275584484d-01,
     |   6.3333275584484d-01,-3.4420962690390d-01,-7.9293244502346d-01,
     |  -1.8186383993319d-02, 7.9009974089738d-01, 3.8337415133849d-01,
     |  -6.2107408440154d-01,-6.7793783954861d-01, 3.1300090487926d-01,
     |   8.3765155296565d-01, 7.8648131653013d-02,-8.1901529031763d-01,
     |  -4.7681298441709d-01, 6.0891544603109d-01, 7.9317293378198d-01,
     |  -2.3144151350561d-01,-9.4130327228540d-01,-2.4863408058726d-01,
     |   8.5209516773790d-01, 7.2565960636632d-01,-4.9185396822208d-01,
     |  -1.0558044356294d+00,-1.1373308966934d-01, 1.0633309000704d+00,
     |   8.3918046119292d-01,-5.5924258332509d-01,-1.3720220073649d+00,
     |  -5.7262084994913d-01, 1.0056432356820d+00, 1.8834632126924d+00,
     |   1.5951919506941d+00, 8.0240874573139d-01, 2.3335494361940d-01,
     |   3.2077457898251d-02, 1.1396651273474d-03, 5.8565431954122d-07/
      data (pmn(lat, 8,31), lat = 1,72)/
     |   2.4472447580619d-08, 1.4484119054007d-04, 6.9939092822685d-03,
     |   7.4707692081923d-02, 3.5560061417865d-01, 9.7106396676283d-01,
     |   1.6667019347105d+00, 1.7464442694058d+00, 7.4914294798618d-01,
     |  -7.2565580000187d-01,-1.3201763166422d+00,-4.2918164400403d-01,
     |   8.7837669011443d-01, 1.0079351379613d+00,-1.5159677849368d-01,
     |  -1.0371988073419d+00,-4.8016357852835d-01, 7.0335250329624d-01,
     |   8.5224815512834d-01,-2.0505628184228d-01,-9.2757576963231d-01,
     |  -2.9030480970671d-01, 7.4613604057533d-01, 6.6195601178928d-01,
     |  -3.9189077430087d-01,-8.4074631248687d-01,-3.2354805197414d-02,
     |   8.0800985740193d-01, 4.2541737798449d-01,-5.8938401992306d-01,
     |  -7.0408393944339d-01, 2.4437037453223d-01, 8.1485384485816d-01,
     |   1.4723357780621d-01,-7.4041865175875d-01,-5.0050810227586d-01,
     |   5.0050810227586d-01, 7.4041865175875d-01,-1.4723357780621d-01,
     |  -8.1485384485816d-01,-2.4437037453223d-01, 7.0408393944339d-01,
     |   5.8938401992306d-01,-4.2541737798448d-01,-8.0800985740193d-01,
     |   3.2354805197412d-02, 8.4074631248687d-01, 3.9189077430088d-01,
     |  -6.6195601178927d-01,-7.4613604057533d-01, 2.9030480970671d-01,
     |   9.2757576963231d-01, 2.0505628184229d-01,-8.5224815512834d-01,
     |  -7.0335250329624d-01, 4.8016357852834d-01, 1.0371988073419d+00,
     |   1.5159677849368d-01,-1.0079351379613d+00,-8.7837669011443d-01,
     |   4.2918164400403d-01, 1.3201763166422d+00, 7.2565580000188d-01,
     |  -7.4914294798617d-01,-1.7464442694057d+00,-1.6667019347105d+00,
     |  -9.7106396676284d-01,-3.5560061417865d-01,-7.4707692081923d-02,
     |  -6.9939092822685d-03,-1.4484119054007d-04,-2.4472447580619d-08/
      data (pmn(lat, 9,31), lat = 1,72)/
     |   9.0089462702081d-10, 1.6172761716285d-05, 1.3317301023650d-03,
     |   2.0666640520882d-02, 1.3367663405186d-01, 4.8435072664370d-01,
     |   1.1166024954527d+00, 1.6995853387039d+00, 1.5937725735343d+00,
     |   5.1395245607067d-01,-8.4807244445297d-01,-1.2591101801892d+00,
     |  -3.0896426919658d-01, 9.1044842550158d-01, 9.5588322799940d-01,
     |  -1.8559348085778d-01,-1.0207625456431d+00,-4.7189861113712d-01,
     |   6.8115130811818d-01, 8.5459237028791d-01,-1.5925961917973d-01,
     |  -9.1232509679393d-01,-3.5119909045499d-01, 6.9283178672965d-01,
     |   7.1269373952088d-01,-2.9803777571009d-01,-8.5241387505086d-01,
     |  -1.4995962894718d-01, 7.5998431133640d-01, 5.3583159062269d-01,
     |  -4.7757627304842d-01,-7.7129947327645d-01, 8.4502390150898d-02,
     |   8.0830363856258d-01, 3.2159027469720d-01,-6.4457720024643d-01,
     |  -6.4457720024644d-01, 3.2159027469720d-01, 8.0830363856258d-01,
     |   8.4502390150900d-02,-7.7129947327645d-01,-4.7757627304842d-01,
     |   5.3583159062269d-01, 7.5998431133640d-01,-1.4995962894718d-01,
     |  -8.5241387505086d-01,-2.9803777571010d-01, 7.1269373952088d-01,
     |   6.9283178672966d-01,-3.5119909045499d-01,-9.1232509679393d-01,
     |  -1.5925961917975d-01, 8.5459237028791d-01, 6.8115130811819d-01,
     |  -4.7189861113712d-01,-1.0207625456431d+00,-1.8559348085779d-01,
     |   9.5588322799940d-01, 9.1044842550158d-01,-3.0896426919656d-01,
     |  -1.2591101801892d+00,-8.4807244445297d-01, 5.1395245607066d-01,
     |   1.5937725735343d+00, 1.6995853387039d+00, 1.1166024954527d+00,
     |   4.8435072664370d-01, 1.3367663405186d-01, 2.0666640520882d-02,
     |   1.3317301023650d-03, 1.6172761716285d-05, 9.0089462702081d-10/
      data (pmn(lat,10,31), lat = 1,72)/
     |   2.9547352273115d-11, 1.6057194546410d-06, 2.2452273153690d-04,
     |   5.0251947627721d-03, 4.3644204257378d-02, 2.0560422470117d-01,
     |   6.1273423980341d-01, 1.2369739382101d+00, 1.6997190736585d+00,
     |   1.4329105849965d+00, 3.0259583466763d-01,-9.4206259869834d-01,
     |  -1.1922532284752d+00,-2.0129992232419d-01, 9.3443038938563d-01,
     |   9.0890377218503d-01,-2.1266838082339d-01,-1.0057787105198d+00,
     |  -4.6990740461489d-01, 6.5626782060156d-01, 8.6017869837967d-01,
     |  -1.0773432907818d-01,-8.9418613714123d-01,-4.1655569280437d-01,
     |   6.3011975080173d-01, 7.6100593657600d-01,-1.9211697646190d-01,
     |  -8.5098306833917d-01,-2.7502490485982d-01, 6.8884019460761d-01,
     |   6.4103494055447d-01,-3.3874710734838d-01,-8.1514911238758d-01,
     |  -9.5640122324650d-02, 7.6040278270821d-01, 4.9704794270122d-01,
     |  -4.9704794270121d-01,-7.6040278270821d-01, 9.5640122324646d-02,
     |   8.1514911238758d-01, 3.3874710734838d-01,-6.4103494055447d-01,
     |  -6.8884019460761d-01, 2.7502490485982d-01, 8.5098306833917d-01,
     |   1.9211697646191d-01,-7.6100593657600d-01,-6.3011975080173d-01,
     |   4.1655569280437d-01, 8.9418613714123d-01, 1.0773432907818d-01,
     |  -8.6017869837966d-01,-6.5626782060157d-01, 4.6990740461488d-01,
     |   1.0057787105198d+00, 2.1266838082340d-01,-9.0890377218503d-01,
     |  -9.3443038938562d-01, 2.0129992232419d-01, 1.1922532284752d+00,
     |   9.4206259869834d-01,-3.0259583466763d-01,-1.4329105849965d+00,
     |  -1.6997190736585d+00,-1.2369739382101d+00,-6.1273423980341d-01,
     |  -2.0560422470117d-01,-4.3644204257378d-02,-5.0251947627721d-03,
     |  -2.2452273153690d-04,-1.6057194546410d-06,-2.9547352273115d-11/
      data (pmn(lat,11,31), lat = 1,72)/
     |   8.7101094150822d-13, 1.4307968810291d-07, 3.3866343935073d-05,
     |   1.0874821216099d-03, 1.2577483298940d-02, 7.6032311404903d-02,
     |   2.8650096458050d-01, 7.3525544734950d-01, 1.3317222651008d+00,
     |   1.6733191906455d+00, 1.2708560729880d+00, 1.1691455176217d-01,
     |  -1.0106990061353d+00,-1.1235966041233d+00,-1.0843303885428d-01,
     |   9.5033131192879d-01, 8.6896172794214d-01,-2.3032566953559d-01,
     |  -9.9176781027976d-01,-4.7664428544601d-01, 6.2597207444839d-01,
     |   8.6941355637528d-01,-4.7202699352356d-02,-8.7086864313698d-01,
     |  -4.8792539049456d-01, 5.5412908746728d-01, 8.0509644099381d-01,
     |  -7.1209005902445d-02,-8.3142341285669d-01,-4.0666137669395d-01,
     |   5.8859580609834d-01, 7.3461862689784d-01,-1.6994657758355d-01,
     |  -8.2447046556169d-01,-2.9165236520223d-01, 6.5914818920487d-01,
     |   6.5914818920487d-01,-2.9165236520223d-01,-8.2447046556169d-01,
     |  -1.6994657758355d-01, 7.3461862689784d-01, 5.8859580609834d-01,
     |  -4.0666137669395d-01,-8.3142341285669d-01,-7.1209005902449d-02,
     |   8.0509644099381d-01, 5.5412908746729d-01,-4.8792539049456d-01,
     |  -8.7086864313698d-01,-4.7202699352356d-02, 8.6941355637528d-01,
     |   6.2597207444841d-01,-4.7664428544601d-01,-9.9176781027976d-01,
     |  -2.3032566953560d-01, 8.6896172794213d-01, 9.5033131192880d-01,
     |  -1.0843303885429d-01,-1.1235966041233d+00,-1.0106990061353d+00,
     |   1.1691455176217d-01, 1.2708560729880d+00, 1.6733191906455d+00,
     |   1.3317222651008d+00, 7.3525544734950d-01, 2.8650096458050d-01,
     |   7.6032311404904d-02, 1.2577483298940d-02, 1.0874821216099d-03,
     |   3.3866343935073d-05, 1.4307968810291d-07, 8.7101094150822d-13/
      data (pmn(lat,12,31), lat = 1,72)/
     |   2.3237807291647d-14, 1.1525619083788d-08, 4.6070561277412d-06,
     |   2.1141808138446d-04, 3.2367925280010d-03, 2.4881577769844d-02,
     |   1.1687363050056d-01, 3.7221845216426d-01, 8.4772979500268d-01,
     |   1.4017944857935d+00, 1.6268384451891d+00, 1.1139077552494d+00,
     |  -4.2101376150576d-02,-1.0576532806555d+00,-1.0572485908908d+00,
     |  -3.2160221883097d-02, 9.5870909250892d-01, 8.3806446195259d-01,
     |  -2.3636242868493d-01,-9.7819429948701d-01,-4.9421737713882d-01,
     |   5.8733744696186d-01, 8.8189018917214d-01, 2.5405635287778d-02,
     |  -8.3894417357437d-01,-5.6567564572314d-01, 4.6031559784882d-01,
     |   8.4102488379673d-01, 6.6793098678534d-02,-7.8651650760359d-01,
     |  -5.4113318059709d-01, 4.5267442094091d-01, 8.0588656909130d-01,
     |   2.9117553750101d-02,-7.8440807985046d-01,-4.9257560008089d-01,
     |   4.9257560008089d-01, 7.8440807985046d-01,-2.9117553750097d-02,
     |  -8.0588656909129d-01,-4.5267442094091d-01, 5.4113318059710d-01,
     |   7.8651650760359d-01,-6.6793098678525d-02,-8.4102488379673d-01,
     |  -4.6031559784883d-01, 5.6567564572314d-01, 8.3894417357437d-01,
     |  -2.5405635287774d-02,-8.8189018917214d-01,-5.8733744696186d-01,
     |   4.9421737713880d-01, 9.7819429948702d-01, 2.3636242868494d-01,
     |  -8.3806446195259d-01,-9.5870909250892d-01, 3.2160221883092d-02,
     |   1.0572485908908d+00, 1.0576532806555d+00, 4.2101376150587d-02,
     |  -1.1139077552494d+00,-1.6268384451891d+00,-1.4017944857935d+00,
     |  -8.4772979500268d-01,-3.7221845216426d-01,-1.1687363050056d-01,
     |  -2.4881577769844d-02,-3.2367925280010d-03,-2.1141808138446d-04,
     |  -4.6070561277412d-06,-1.1525619083788d-08,-2.3237807291647d-14/
      data (pmn(lat,13,31), lat = 1,72)/
     |   5.6417190599411d-16, 8.4413648174039d-10, 5.6877404484355d-07,
     |   3.7189749545411d-05, 7.5032702251930d-04, 7.2864412884450d-03,
     |   4.2248145636115d-02, 1.6443998386528d-01, 4.5876724452138d-01,
     |   9.4724541240289d-01, 1.4493089464492d+00, 1.5667557350832d+00,
     |   9.6751385025865d-01,-1.7427882003457d-01,-1.0868854885424d+00,
     |  -9.9713697635256d-01, 2.6070604743769d-02, 9.6028505251046d-01,
     |   8.1808772817797d-01,-2.2862984822539d-01,-9.6413713776528d-01,
     |  -5.2433765633450d-01, 5.3699520769199d-01, 8.9607729269792d-01,
     |   1.1283690449713d-01,-7.9357990913745d-01,-6.4844818109046d-01,
     |   3.4369972406140d-01, 8.6209333309678d-01, 2.2216778456926d-01,
     |  -7.0689635363832d-01,-6.7034830561914d-01, 2.7532723497497d-01,
     |   8.3886819320124d-01, 2.5313354959619d-01,-6.7746418671040d-01,
     |  -6.7746418671041d-01, 2.5313354959619d-01, 8.3886819320124d-01,
     |   2.7532723497497d-01,-6.7034830561914d-01,-7.0689635363832d-01,
     |   2.2216778456925d-01, 8.6209333309678d-01, 3.4369972406141d-01,
     |  -6.4844818109045d-01,-7.9357990913745d-01, 1.1283690449712d-01,
     |   8.9607729269792d-01, 5.3699520769199d-01,-5.2433765633450d-01,
     |  -9.6413713776529d-01,-2.2862984822540d-01, 8.1808772817797d-01,
     |   9.6028505251046d-01, 2.6070604743777d-02,-9.9713697635256d-01,
     |  -1.0868854885424d+00,-1.7427882003456d-01, 9.6751385025864d-01,
     |   1.5667557350832d+00, 1.4493089464492d+00, 9.4724541240290d-01,
     |   4.5876724452138d-01, 1.6443998386528d-01, 4.2248145636115d-02,
     |   7.2864412884451d-03, 7.5032702251930d-04, 3.7189749545411d-05,
     |   5.6877404484355d-07, 8.4413648174039d-10, 5.6417190599411d-16/
      data (pmn(lat,14,31), lat = 1,72)/
     |   1.2518285060130d-17, 5.6464150807874d-11, 6.4037224583336d-08,
     |   5.9519777157461d-06, 1.5770391056056d-04, 1.9251359239795d-03,
     |   1.3681151570435d-02, 6.4399411291010d-02, 2.1649983628426d-01,
     |   5.4254977629856d-01, 1.0320880917192d+00, 1.4772800878797d+00,
     |   1.4993431992895d+00, 8.3621648419236d-01,-2.8009041076833d-01,
     |  -1.1023246712876d+00,-9.4681648723632d-01, 6.4994764015815d-02,
     |   9.5556892142720d-01, 8.1060082747750d-01,-2.0481766462874d-01,
     |  -9.4791188220549d-01,-5.6814359720980d-01, 4.7093374209858d-01,
     |   9.0885497417716d-01, 2.1716583527675d-01,-7.2830190303449d-01,
     |  -7.3231379782993d-01, 1.9948488427657d-01, 8.5819755466597d-01,
     |   3.9172735292694d-01,-5.8169504297267d-01,-7.8000509487673d-01,
     |   5.4347291993731d-02, 8.1205479404767d-01, 4.8691434976566d-01,
     |  -4.8691434976566d-01,-8.1205479404767d-01,-5.4347291993734d-02,
     |   7.8000509487673d-01, 5.8169504297267d-01,-3.9172735292694d-01,
     |  -8.5819755466598d-01,-1.9948488427658d-01, 7.3231379782993d-01,
     |   7.2830190303449d-01,-2.1716583527674d-01,-9.0885497417716d-01,
     |  -4.7093374209859d-01, 5.6814359720980d-01, 9.4791188220549d-01,
     |   2.0481766462875d-01,-8.1060082747750d-01,-9.5556892142720d-01,
     |  -6.4994764015819d-02, 9.4681648723631d-01, 1.1023246712876d+00,
     |   2.8009041076833d-01,-8.3621648419237d-01,-1.4993431992895d+00,
     |  -1.4772800878797d+00,-1.0320880917192d+00,-5.4254977629857d-01,
     |  -2.1649983628427d-01,-6.4399411291010d-02,-1.3681151570435d-02,
     |  -1.9251359239795d-03,-1.5770391056056d-04,-5.9519777157461d-06,
     |  -6.4037224583336d-08,-5.6464150807874d-11,-1.2518285060130d-17/
      data (pmn(lat,15,31), lat = 1,72)/
     |   2.5470959453259d-19, 3.4614051056389d-12, 6.5998221326446d-09,
     |   8.7034430688553d-07, 3.0202451823500d-05, 4.6169348913260d-04,
     |   4.0000348238351d-03, 2.2598963529601d-02, 9.0531643291380d-02,
     |   2.7055930297558d-01, 6.2051474576242d-01, 1.1016088294877d+00,
     |   1.4893160117624d+00, 1.4304572145742d+00, 7.2368937398021d-01,
     |  -3.6039177125386d-01,-1.1075502505283d+00,-9.0934447831323d-01,
     |   8.3322265264922d-02, 9.4447328521937d-01, 8.1665247262894d-01,
     |  -1.6228375657892d-01,-9.2663093760410d-01,-6.2584369990631d-01,
     |   3.8441288449306d-01, 9.1489347393063d-01, 3.3908508894260d-01,
     |  -6.3494399976297d-01,-8.0958896177918d-01, 2.4351213223545d-02,
     |   8.1541805894920d-01, 5.6638967484908d-01,-4.0042070771599d-01,
     |  -8.4779461202909d-01,-2.0433259441043d-01, 7.0012412207847d-01,
     |   7.0012412207847d-01,-2.0433259441042d-01,-8.4779461202908d-01,
     |  -4.0042070771599d-01, 5.6638967484908d-01, 8.1541805894920d-01,
     |   2.4351213223549d-02,-8.0958896177917d-01,-6.3494399976298d-01,
     |   3.3908508894260d-01, 9.1489347393063d-01, 3.8441288449306d-01,
     |  -6.2584369990630d-01,-9.2663093760410d-01,-1.6228375657892d-01,
     |   8.1665247262893d-01, 9.4447328521937d-01, 8.3322265264928d-02,
     |  -9.0934447831323d-01,-1.1075502505283d+00,-3.6039177125387d-01,
     |   7.2368937398022d-01, 1.4304572145742d+00, 1.4893160117624d+00,
     |   1.1016088294877d+00, 6.2051474576242d-01, 2.7055930297558d-01,
     |   9.0531643291381d-02, 2.2598963529601d-02, 4.0000348238351d-03,
     |   4.6169348913261d-04, 3.0202451823500d-05, 8.7034430688553d-07,
     |   6.5998221326446d-09, 3.4614051056389d-12, 2.5470959453259d-19/
      data (pmn(lat,16,31), lat = 1,72)/
     |   4.7642816946459d-21, 1.9497555498618d-13, 6.2439650710098d-10,
     |   1.1665053722623d-07, 5.2900035162555d-06, 1.0095898335411d-04,
     |   1.0619559840778d-03, 7.1601450098626d-03, 3.3906087317937d-02,
     |   1.1941890694935d-01, 3.2406825781739d-01, 6.9023254438920d-01,
     |   1.1560339342447d+00, 1.4893084645343d+00, 1.3653749038793d+00,
     |   6.3285465475391d-01,-4.1609977201905d-01,-1.1054721057038d+00,
     |  -8.8718256932635d-01, 7.9517227230080d-02, 9.2589853231534d-01,
     |   8.3645972640933d-01,-9.7982365174595d-02,-8.9570051308423d-01,
     |  -6.9608872705566d-01, 2.7212512450835d-01, 9.0591116534859d-01,
     |   4.7665503197547d-01,-5.0407295823578d-01,-8.6738362310430d-01,
     |  -1.8117966434335d-01, 7.1643524913927d-01, 7.2798840739712d-01,
     |  -1.5699595926984d-01,-8.4274569963703d-01,-4.7981917033842d-01,
     |   4.7981917033842d-01, 8.4274569963703d-01, 1.5699595926984d-01,
     |  -7.2798840739712d-01,-7.1643524913927d-01, 1.8117966434335d-01,
     |   8.6738362310430d-01, 5.0407295823578d-01,-4.7665503197547d-01,
     |  -9.0591116534859d-01,-2.7212512450835d-01, 6.9608872705565d-01,
     |   8.9570051308423d-01, 9.7982365174595d-02,-8.3645972640933d-01,
     |  -9.2589853231535d-01,-7.9517227230083d-02, 8.8718256932635d-01,
     |   1.1054721057038d+00, 4.1609977201905d-01,-6.3285465475391d-01,
     |  -1.3653749038793d+00,-1.4893084645343d+00,-1.1560339342447d+00,
     |  -6.9023254438920d-01,-3.2406825781739d-01,-1.1941890694935d-01,
     |  -3.3906087317938d-02,-7.1601450098627d-03,-1.0619559840778d-03,
     |  -1.0095898335411d-04,-5.2900035162555d-06,-1.1665053722623d-07,
     |  -6.2439650710098d-10,-1.9497555498618d-13,-4.7642816946459d-21/
      data (pmn(lat,17,31), lat = 1,72)/
     |   8.2064812997111d-23, 1.0109878491589d-14, 5.4334885852305d-11,
     |   1.4362373249127d-08, 8.4964187079483d-07, 2.0194883512294d-05,
     |   2.5705692320059d-04, 2.0592945586666d-03, 1.1457790358843d-02,
     |   4.7157146904926d-02, 1.4953758024314d-01, 3.7458204113328d-01,
     |   7.4989424687836d-01, 1.1962278637086d+00, 1.4811307124962d+00,
     |   1.3086790523373d+00, 5.6605541068368d-01,-4.4783643888933d-01,
     |  -1.0979942060800d+00,-8.8206989364732d-01, 5.1609911139568d-02,
     |   8.9727483163064d-01, 8.6892168492379d-01,-8.5905366017923d-03,
     |  -8.4828977172766d-01,-7.7496385352384d-01, 1.2883230462379d-01,
     |   8.6995637679212d-01, 6.2332401231718d-01,-3.2639104218452d-01,
     |  -8.8621331154833d-01,-4.0888878092479d-01, 5.4284740965928d-01,
     |   8.4592481952459d-01, 1.4295062122680d-01,-7.2799913953875d-01,
     |  -7.2799913953876d-01, 1.4295062122679d-01, 8.4592481952459d-01,
     |   5.4284740965928d-01,-4.0888878092479d-01,-8.8621331154833d-01,
     |  -3.2639104218453d-01, 6.2332401231717d-01, 8.6995637679212d-01,
     |   1.2883230462379d-01,-7.7496385352384d-01,-8.4828977172766d-01,
     |  -8.5905366017960d-03, 8.6892168492379d-01, 8.9727483163064d-01,
     |   5.1609911139584d-02,-8.8206989364732d-01,-1.0979942060800d+00,
     |  -4.4783643888933d-01, 5.6605541068368d-01, 1.3086790523373d+00,
     |   1.4811307124962d+00, 1.1962278637086d+00, 7.4989424687837d-01,
     |   3.7458204113328d-01, 1.4953758024314d-01, 4.7157146904927d-02,
     |   1.1457790358843d-02, 2.0592945586666d-03, 2.5705692320059d-04,
     |   2.0194883512295d-05, 8.4964187079483d-07, 1.4362373249127d-08,
     |   5.4334885852305d-11, 1.0109878491589d-14, 8.2064812997111d-23/
      data (pmn(lat,18,31), lat = 1,72)/
     |   1.3030800941215d-24, 4.8308528145293d-16, 4.3542896577950d-12,
     |   1.6267848261086d-09, 1.2535342187589d-07, 3.7032949206734d-06,
     |   5.6891926152502d-05, 5.3962630767337d-04, 3.5113779934847d-03,
     |   1.6781280499198d-02, 6.1631644715871d-02, 1.7919469194612d-01,
     |   4.1987231809156d-01, 7.9824182290750d-01, 1.2234226489958d+00,
     |   1.4683507511073d+00, 1.2641782471760d+00, 5.2525171448116d-01,
     |  -4.5555901748605d-01,-1.0856352211038d+00,-8.9479595964712d-01,
     |  -2.8886894208806d-03, 8.5406650069344d-01, 9.1086179660668d-01,
     |   1.0899824292613d-01,-7.7489187023080d-01,-8.5450176785438d-01,
     |  -4.9158525951529d-02, 7.9108397858940d-01, 7.6512229001692d-01,
     |  -9.5889899467334d-02,-8.3955530754342d-01,-6.3734948004030d-01,
     |   2.8110285581253d-01, 8.7554028189978d-01, 4.7094521351765d-01,
     |  -4.7094521351764d-01,-8.7554028189978d-01,-2.8110285581253d-01,
     |   6.3734948004030d-01, 8.3955530754342d-01, 9.5889899467331d-02,
     |  -7.6512229001692d-01,-7.9108397858941d-01, 4.9158525951526d-02,
     |   8.5450176785438d-01, 7.7489187023080d-01,-1.0899824292612d-01,
     |  -9.1086179660668d-01,-8.5406650069344d-01, 2.8886894208806d-03,
     |   8.9479595964711d-01, 1.0856352211038d+00, 4.5555901748605d-01,
     |  -5.2525171448116d-01,-1.2641782471759d+00,-1.4683507511073d+00,
     |  -1.2234226489958d+00,-7.9824182290750d-01,-4.1987231809156d-01,
     |  -1.7919469194612d-01,-6.1631644715871d-02,-1.6781280499198d-02,
     |  -3.5113779934847d-03,-5.3962630767338d-04,-5.6891926152502d-05,
     |  -3.7032949206735d-06,-1.2535342187589d-07,-1.6267848261086d-09,
     |  -4.3542896577950d-12,-4.8308528145293d-16,-1.3030800941215d-24/
      data (pmn(lat,19,31), lat = 1,72)/
     |   1.9080236735914d-26, 2.1280372012705d-17, 3.2150387576064d-13,
     |   1.6962110398139d-10, 1.7003662086498d-08, 6.2333058337105d-07,
     |   1.1532110102951d-05, 1.2914401936765d-04, 9.7916415153696d-04,
     |   5.4073057987437d-03, 2.2848679012592d-02, 7.6396370127849d-02,
     |   2.0664688621672d-01, 4.5798591078952d-01, 8.3444202483891d-01,
     |   1.2389274323656d+00, 1.4539574356550d+00, 1.2348341527887d+00,
     |   5.1219741395855d-01,-4.3819922417030d-01,-1.0670731789117d+00,
     |  -9.2477840647849d-01,-8.6854619796165d-02, 7.8929221978527d-01,
     |   9.5590194093703d-01, 2.5654762993835d-01,-6.6326305751351d-01,
     |  -9.2071631612848d-01,-2.6116897666713d-01, 6.5020991990302d-01,
     |   8.7729172621927d-01, 1.8425214747207d-01,-6.9619470653729d-01,
     |  -8.2556413776196d-01,-6.5824883461165d-02, 7.6239761995249d-01,
     |   7.6239761995249d-01,-6.5824883461163d-02,-8.2556413776196d-01,
     |  -6.9619470653729d-01, 1.8425214747207d-01, 8.7729172621927d-01,
     |   6.5020991990303d-01,-2.6116897666712d-01,-9.2071631612848d-01,
     |  -6.6326305751351d-01, 2.5654762993835d-01, 9.5590194093702d-01,
     |   7.8929221978527d-01,-8.6854619796165d-02,-9.2477840647849d-01,
     |  -1.0670731789117d+00,-4.3819922417030d-01, 5.1219741395855d-01,
     |   1.2348341527887d+00, 1.4539574356550d+00, 1.2389274323656d+00,
     |   8.3444202483890d-01, 4.5798591078952d-01, 2.0664688621672d-01,
     |   7.6396370127849d-02, 2.2848679012592d-02, 5.4073057987438d-03,
     |   9.7916415153698d-04, 1.2914401936765d-04, 1.1532110102951d-05,
     |   6.2333058337107d-07, 1.7003662086498d-08, 1.6962110398139d-10,
     |   3.2150387576064d-13, 2.1280372012705d-17, 1.9080236735914d-26/
      data (pmn(lat,20,31), lat = 1,72)/
     |   2.5752902695425d-28, 8.6389467463983d-19, 2.1866034261051d-14,
     |   1.6278605372054d-11, 2.1206988312519d-09, 9.6332106890632d-08,
     |   2.1424033580050d-06, 2.8260377479044d-05, 2.4891835921474d-04,
     |   1.5822632627271d-03, 7.6532777364709d-03, 2.9225431504994d-02,
     |   9.0383664956012d-02, 2.3020156749621d-01, 4.8725660071011d-01,
     |   8.5792024273425d-01, 1.2438293616092d+00, 1.4400872276896d+00,
     |   1.2226532548969d+00, 5.2853931218966d-01,-3.9334940744912d-01,
     |  -1.0385870517857d+00,-9.6932661126073d-01,-2.0301233762560d-01,
     |   6.9321767424560d-01, 9.9292164275163d-01, 4.3234328571841d-01,
     |  -4.9931958479272d-01,-9.5145311849505d-01,-4.9740616330724d-01,
     |   4.2857076892248d-01, 9.2152403720952d-01, 4.9224269882785d-01,
     |  -4.2857968618885d-01,-9.0893991907715d-01,-4.5979266364030d-01,
     |   4.5979266364030d-01, 9.0893991907715d-01, 4.2857968618885d-01,
     |  -4.9224269882785d-01,-9.2152403720952d-01,-4.2857076892248d-01,
     |   4.9740616330724d-01, 9.5145311849505d-01, 4.9931958479272d-01,
     |  -4.3234328571840d-01,-9.9292164275162d-01,-6.9321767424560d-01,
     |   2.0301233762560d-01, 9.6932661126073d-01, 1.0385870517857d+00,
     |   3.9334940744913d-01,-5.2853931218966d-01,-1.2226532548969d+00,
     |  -1.4400872276896d+00,-1.2438293616092d+00,-8.5792024273426d-01,
     |  -4.8725660071010d-01,-2.3020156749621d-01,-9.0383664956013d-02,
     |  -2.9225431504994d-02,-7.6532777364709d-03,-1.5822632627271d-03,
     |  -2.4891835921475d-04,-2.8260377479044d-05,-2.1424033580050d-06,
     |  -9.6332106890635d-08,-2.1206988312519d-09,-1.6278605372054d-11,
     |  -2.1866034261051d-14,-8.6389467463983d-19,-2.5752902695425d-28/
      data (pmn(lat,21,31), lat = 1,72)/
     |   3.2002987003015d-30, 3.2283072745914d-20, 1.3683725157532d-15,
     |   1.4365603687967d-12, 2.4299313694138d-10, 1.3661104583418d-08,
     |   3.6466294609849d-07, 5.6550406502442d-06, 5.7722299811904d-05,
     |   4.2101918697796d-04, 2.3217163446804d-03, 1.0072337315350d-02,
     |   3.5362381938275d-02, 1.0247702575028d-01, 2.4829741631904d-01,
     |   5.0628126434317d-01, 8.6817398778182d-01, 1.2386951802733d+00,
     |   1.4277314687394d+00, 1.2284859902024d+00, 5.7575603275493d-01,
     |  -3.1706897810735d-01,-9.9339984609368d-01,-1.0224583699724d+00,
     |  -3.5269420152311d-01, 5.5357351241190d-01, 1.0042282203582d+00,
     |   6.2761104567321d-01,-2.7002375196605d-01,-9.1503825494969d-01,
     |  -7.3205356060844d-01, 1.1598487349003d-01, 8.4683894291785d-01,
     |   7.7544071283336d-01,-3.1550788357827d-02,-8.0538400913540d-01,
     |  -8.0538400913540d-01,-3.1550788357830d-02, 7.7544071283336d-01,
     |   8.4683894291785d-01, 1.1598487349003d-01,-7.3205356060844d-01,
     |  -9.1503825494969d-01,-2.7002375196606d-01, 6.2761104567321d-01,
     |   1.0042282203582d+00, 5.5357351241190d-01,-3.5269420152310d-01,
     |  -1.0224583699724d+00,-9.9339984609368d-01,-3.1706897810735d-01,
     |   5.7575603275492d-01, 1.2284859902024d+00, 1.4277314687394d+00,
     |   1.2386951802733d+00, 8.6817398778182d-01, 5.0628126434317d-01,
     |   2.4829741631904d-01, 1.0247702575028d-01, 3.5362381938275d-02,
     |   1.0072337315350d-02, 2.3217163446804d-03, 4.2101918697796d-04,
     |   5.7722299811905d-05, 5.6550406502443d-06, 3.6466294609849d-07,
     |   1.3661104583418d-08, 2.4299313694138d-10, 1.4365603687967d-12,
     |   1.3683725157532d-15, 3.2283072745914d-20, 3.2002987003015d-30/
      data (pmn(lat,22,31), lat = 1,72)/
     |   3.6541108900350d-32, 1.1082509487759d-21, 7.8637545663239d-17,
     |   1.1635327201595d-13, 2.5534075818974d-11, 1.7748801191636d-09,
     |   5.6791713574606d-08, 1.0336757137483d-06, 1.2201947104170d-05,
     |   1.0186028944094d-04, 6.3831736117615d-04, 3.1329574321925d-03,
     |   1.2418876745497d-02, 4.0649552253590d-02, 1.1159825761277d-01,
     |   2.5956756528239d-01, 5.1387807784717d-01, 8.6458985677076d-01,
     |   1.2232843249995d+00, 1.4164017355468d+00, 1.2516635335344d+00,
     |   6.5481774642012d-01,-2.0395334585440d-01,-9.2101057736251d-01,
     |  -1.0731657674110d+00,-5.3347676702642d-01, 3.5698596943725d-01,
     |   9.6398929826403d-01, 8.2121108853797d-01, 3.0164257810548d-02,
     |  -7.7203069783907d-01,-9.1525162493377d-01,-2.7358553186194d-01,
     |   6.0017070358817d-01, 9.4049527805224d-01, 4.4560304013988d-01,
     |  -4.4560304013988d-01,-9.4049527805223d-01,-6.0017070358817d-01,
     |   2.7358553186194d-01, 9.1525162493376d-01, 7.7203069783907d-01,
     |  -3.0164257810545d-02,-8.2121108853797d-01,-9.6398929826403d-01,
     |  -3.5698596943725d-01, 5.3347676702641d-01, 1.0731657674110d+00,
     |   9.2101057736251d-01, 2.0395334585440d-01,-6.5481774642012d-01,
     |  -1.2516635335344d+00,-1.4164017355468d+00,-1.2232843249995d+00,
     |  -8.6458985677077d-01,-5.1387807784717d-01,-2.5956756528239d-01,
     |  -1.1159825761277d-01,-4.0649552253589d-02,-1.2418876745497d-02,
     |  -3.1329574321925d-03,-6.3831736117615d-04,-1.0186028944095d-04,
     |  -1.2201947104170d-05,-1.0336757137483d-06,-5.6791713574606d-08,
     |  -1.7748801191636d-09,-2.5534075818974d-11,-1.1635327201595d-13,
     |  -7.8637545663239d-17,-1.1082509487759d-21,-3.6541108900350d-32/
      data (pmn(lat,23,31), lat = 1,72)/
     |   3.8215498313348d-34, 3.4841753748396d-23, 4.1372934246777d-18,
     |   8.6234719315562d-15, 2.4535933799460d-12, 2.1068128237927d-10,
     |   8.0717214879301d-09, 1.7219221512117d-07, 2.3466148420322d-06,
     |   2.2371806226486d-05, 1.5888917283840d-04, 8.7932070538956d-04,
     |   3.9185735813476d-03, 1.4406686661670d-02, 4.4480929922357d-02,
     |   1.1679381545987d-01, 2.6289476066923d-01, 5.0905108416330d-01,
     |   8.4629473585676d-01, 1.1962932280337d+00, 1.4037396624549d+00,
     |   1.2893975404560d+00, 7.6540122664945d-01,-4.7723767081311d-02,
     |  -8.0677851937159d-01,-1.1031690259563d+00,-7.3519420732042d-01,
     |   9.2799637848384d-02, 8.3836109235207d-01, 9.7311033693652d-01,
     |   3.8742269932432d-01,-4.8448124122198d-01,-9.6838696923123d-01,
     |  -6.7859452836921d-01, 1.5598076954436d-01, 8.6045804420426d-01,
     |   8.6045804420426d-01, 1.5598076954436d-01,-6.7859452836921d-01,
     |  -9.6838696923123d-01,-4.8448124122198d-01, 3.8742269932432d-01,
     |   9.7311033693652d-01, 8.3836109235207d-01, 9.2799637848387d-02,
     |  -7.3519420732041d-01,-1.1031690259563d+00,-8.0677851937160d-01,
     |  -4.7723767081314d-02, 7.6540122664945d-01, 1.2893975404560d+00,
     |   1.4037396624549d+00, 1.1962932280337d+00, 8.4629473585676d-01,
     |   5.0905108416330d-01, 2.6289476066924d-01, 1.1679381545987d-01,
     |   4.4480929922357d-02, 1.4406686661670d-02, 3.9185735813476d-03,
     |   8.7932070538956d-04, 1.5888917283840d-04, 2.2371806226487d-05,
     |   2.3466148420323d-06, 1.7219221512117d-07, 8.0717214879301d-09,
     |   2.1068128237928d-10, 2.4535933799460d-12, 8.6234719315562d-15,
     |   4.1372934246777d-18, 3.4841753748396d-23, 3.8215498313348d-34/
      data (pmn(lat,24,31), lat = 1,72)/
     |   3.6443048215479d-36, 9.9866424599417d-25, 1.9839885743574d-19,
     |   5.8228605105203d-16, 2.1467429275612d-13, 2.2753322285471d-11,
     |   1.0427699524762d-09, 2.6041220839497d-08, 4.0910048146895d-07,
     |   4.4461422423550d-06, 3.5708153410896d-05, 2.2220522770921d-04,
     |   1.1093933757102d-03, 4.5611762975356d-03, 1.5747877821901d-02,
     |   4.6326020009794d-02, 1.1732134247378d-01, 2.5747314832596d-01,
     |   4.9099235849776d-01, 8.1208375099280d-01, 1.1551721672037d+00,
     |   1.3850876597288d+00, 1.3358856175204d+00, 9.0445065493736d-01,
     |   1.5723263837638d-01,-6.3235231714876d-01,-1.0845917334448d+00,
     |  -9.3398802204149d-01,-2.3898597255793d-01, 5.9030124257436d-01,
     |   1.0192806420715d+00, 7.5057084729890d-01,-3.9327942655284d-02,
     |  -7.9374065672520d-01,-9.6601587393765d-01,-4.2714354864170d-01,
     |   4.2714354864170d-01, 9.6601587393765d-01, 7.9374065672520d-01,
     |   3.9327942655286d-02,-7.5057084729890d-01,-1.0192806420715d+00,
     |  -5.9030124257437d-01, 2.3898597255793d-01, 9.3398802204149d-01,
     |   1.0845917334448d+00, 6.3235231714876d-01,-1.5723263837637d-01,
     |  -9.0445065493736d-01,-1.3358856175204d+00,-1.3850876597288d+00,
     |  -1.1551721672037d+00,-8.1208375099280d-01,-4.9099235849776d-01,
     |  -2.5747314832596d-01,-1.1732134247378d-01,-4.6326020009795d-02,
     |  -1.5747877821901d-02,-4.5611762975356d-03,-1.1093933757103d-03,
     |  -2.2220522770921d-04,-3.5708153410896d-05,-4.4461422423550d-06,
     |  -4.0910048146896d-07,-2.6041220839498d-08,-1.0427699524762d-09,
     |  -2.2753322285472d-11,-2.1467429275612d-13,-5.8228605105203d-16,
     |  -1.9839885743574d-19,-9.9866424599417d-25,-3.6443048215479d-36/
      data (pmn(lat,25,31), lat = 1,72)/
     |   3.1489895323533d-38, 2.5933880399612d-26, 8.6175443934309d-21,
     |   3.5599863616180d-17, 1.6997708680692d-14, 2.2223104518772d-12,
     |   1.2172641527392d-10, 3.5549206568347d-09, 6.4296142104093d-08,
     |   7.9534988529776d-07, 7.2096231302373d-06, 5.0330463604330d-05,
     |   2.8072365352151d-04, 1.2861445154514d-03, 4.9434400624743d-03,
     |   1.6198879038798d-02, 4.5804450319247d-02, 1.1273971300842d-01,
     |   2.4289484174047d-01, 4.5915987207596d-01, 7.6048552399817d-01,
     |   1.0960966745242d+00, 1.3531043626575d+00, 1.3811361396633d+00,
     |   1.0638748003370d+00, 4.1274173202294d-01,-3.7807796789327d-01,
     |  -9.7886657215641d-01,-1.0848836969578d+00,-6.1383903249016d-01,
     |   1.9421897115553d-01, 8.7523959152237d-01, 1.0112892322447d+00,
     |   5.0819458310781d-01,-3.1875613300752d-01,-9.3421406757782d-01,
     |  -9.3421406757782d-01,-3.1875613300752d-01, 5.0819458310781d-01,
     |   1.0112892322447d+00, 8.7523959152237d-01, 1.9421897115553d-01,
     |  -6.1383903249016d-01,-1.0848836969578d+00,-9.7886657215641d-01,
     |  -3.7807796789328d-01, 4.1274173202294d-01, 1.0638748003370d+00,
     |   1.3811361396633d+00, 1.3531043626575d+00, 1.0960966745242d+00,
     |   7.6048552399817d-01, 4.5915987207596d-01, 2.4289484174047d-01,
     |   1.1273971300842d-01, 4.5804450319247d-02, 1.6198879038798d-02,
     |   4.9434400624743d-03, 1.2861445154514d-03, 2.8072365352151d-04,
     |   5.0330463604330d-05, 7.2096231302373d-06, 7.9534988529777d-07,
     |   6.4296142104094d-08, 3.5549206568348d-09, 1.2172641527392d-10,
     |   2.2223104518773d-12, 1.6997708680692d-14, 3.5599863616180d-17,
     |   8.6175443934309d-21, 2.5933880399612d-26, 3.1489895323533d-38/
      data (pmn(lat,26,31), lat = 1,72)/
     |   2.4437601233100d-40, 6.0478273709670d-28, 3.3605998254589d-22,
     |   1.9534577435604d-18, 1.2073847286529d-15, 1.9460426392830d-13,
     |   1.2730533530588d-11, 4.3437813635840d-10, 9.0350013710048d-09,
     |   1.2703994498398d-07, 1.2976689440252d-06, 1.0143002393153d-05,
     |   6.3052490036423d-05, 3.2097570261107d-04, 1.3685001197491d-03,
     |   4.9726731427107d-03, 1.5608631430836d-02, 4.2759607804924d-02,
     |   1.0300565888216d-01, 2.1927913256099d-01, 4.1347352886227d-01,
     |   6.9004829478795d-01, 1.0142399952401d+00, 1.2976356335906d+00,
     |   1.4097061876262d+00, 1.2273143874164d+00, 7.1138994299422d-01,
     |  -2.9253938887589d-02,-7.3982369927790d-01,-1.1157187262087d+00,
     |  -9.6275564378628d-01,-3.3286460227670d-01, 4.6294038324005d-01,
     |   1.0002616711619d+00, 9.7773659476313d-01, 4.0218906002933d-01,
     |  -4.0218906002933d-01,-9.7773659476313d-01,-1.0002616711619d+00,
     |  -4.6294038324005d-01, 3.3286460227670d-01, 9.6275564378628d-01,
     |   1.1157187262087d+00, 7.3982369927790d-01, 2.9253938887591d-02,
     |  -7.1138994299421d-01,-1.2273143874164d+00,-1.4097061876262d+00,
     |  -1.2976356335906d+00,-1.0142399952401d+00,-6.9004829478795d-01,
     |  -4.1347352886228d-01,-2.1927913256099d-01,-1.0300565888216d-01,
     |  -4.2759607804924d-02,-1.5608631430836d-02,-4.9726731427107d-03,
     |  -1.3685001197491d-03,-3.2097570261107d-04,-6.3052490036424d-05,
     |  -1.0143002393153d-05,-1.2976689440252d-06,-1.2703994498398d-07,
     |  -9.0350013710050d-09,-4.3437813635841d-10,-1.2730533530588d-11,
     |  -1.9460426392831d-13,-1.2073847286529d-15,-1.9534577435604d-18,
     |  -3.3605998254589d-22,-6.0478273709670d-28,-2.4437601233100d-40/
      data (pmn(lat,27,31), lat = 1,72)/
     |   1.6816524410168d-42, 1.2504884099312d-29, 1.1617529399022d-23,
     |   9.4993556158122d-20, 7.5972911042413d-17, 1.5087934850755d-14,
     |   1.1780225702374d-12, 4.6924868179209d-11, 1.1213670587547d-09,
     |   1.7901669100925d-08, 2.0576987539530d-07, 1.7978135453539d-06,
     |   1.2430776761169d-05, 7.0141734660042d-05, 3.3075161706207d-04,
     |   1.3278793576287d-03, 4.6058812625066d-03, 1.3962640138693d-02,
     |   3.7325078032609d-02, 8.8575272927871d-02, 1.8745431074870d-01,
     |   3.5466720002384d-01, 5.9994971414444d-01, 9.0457728061498d-01,
     |   1.2062591635940d+00, 1.3999200867260d+00, 1.3663956126111d+00,
     |   1.0282726479344d+00, 4.1128486496253d-01,-3.2641508180420d-01,
     |  -9.3028298686737d-01,-1.1526536091737d+00,-8.8064493417780d-01,
     |  -2.1737418647973d-01, 5.4184071596235d-01, 1.0413169257685d+00,
     |   1.0413169257685d+00, 5.4184071596235d-01,-2.1737418647973d-01,
     |  -8.8064493417780d-01,-1.1526536091737d+00,-9.3028298686737d-01,
     |  -3.2641508180420d-01, 4.1128486496252d-01, 1.0282726479344d+00,
     |   1.3663956126111d+00, 1.3999200867260d+00, 1.2062591635940d+00,
     |   9.0457728061498d-01, 5.9994971414444d-01, 3.5466720002384d-01,
     |   1.8745431074870d-01, 8.8575272927871d-02, 3.7325078032609d-02,
     |   1.3962640138693d-02, 4.6058812625067d-03, 1.3278793576287d-03,
     |   3.3075161706206d-04, 7.0141734660042d-05, 1.2430776761170d-05,
     |   1.7978135453539d-06, 2.0576987539530d-07, 1.7901669100925d-08,
     |   1.1213670587547d-09, 4.6924868179210d-11, 1.1780225702374d-12,
     |   1.5087934850756d-14, 7.5972911042413d-17, 9.4993556158122d-20,
     |   1.1617529399022d-23, 1.2504884099312d-29, 1.6816524410168d-42/
      data (pmn(lat,28,31), lat = 1,72)/
     |   1.0066348627534d-44, 2.2489533692307d-31, 3.4926527211267d-25,
     |   4.0161811668450d-21, 4.1547335755925d-18, 1.0161914866028d-15,
     |   9.4640332940317d-14, 4.3979053142430d-12, 1.2064369821509d-10,
     |   2.1844486575085d-09, 2.8220777612919d-08, 2.7521203777513d-07,
     |   2.1129813402299d-06, 1.3188465938072d-05, 6.8612828295579d-05,
     |   3.0344501843999d-04, 1.1588530814170d-03, 3.8699033395502d-03,
     |   1.1414328517830d-02, 2.9972489849594d-02, 7.0496709123346d-02,
     |   1.4918018549561d-01, 2.8480703719355d-01, 4.9102399519699d-01,
     |   7.6352517857738d-01, 1.0661987007601d+00, 1.3247895075343d+00,
     |   1.4380236342915d+00, 1.3108599827187d+00, 9.0236368596867d-01,
     |   2.6705929308206d-01,-4.3694531009926d-01,-9.8962960716028d-01,
     |  -1.1924903984662d+00,-9.5900354007849d-01,-3.6596530048097d-01,
     |   3.6596530048097d-01, 9.5900354007849d-01, 1.1924903984662d+00,
     |   9.8962960716028d-01, 4.3694531009926d-01,-2.6705929308206d-01,
     |  -9.0236368596867d-01,-1.3108599827187d+00,-1.4380236342915d+00,
     |  -1.3247895075343d+00,-1.0661987007601d+00,-7.6352517857738d-01,
     |  -4.9102399519699d-01,-2.8480703719355d-01,-1.4918018549561d-01,
     |  -7.0496709123347d-02,-2.9972489849594d-02,-1.1414328517831d-02,
     |  -3.8699033395502d-03,-1.1588530814170d-03,-3.0344501844000d-04,
     |  -6.8612828295579d-05,-1.3188465938072d-05,-2.1129813402299d-06,
     |  -2.7521203777513d-07,-2.8220777612919d-08,-2.1844486575085d-09,
     |  -1.2064369821509d-10,-4.3979053142431d-12,-9.4640332940317d-14,
     |  -1.0161914866029d-15,-4.1547335755925d-18,-4.0161811668450d-21,
     |  -3.4926527211267d-25,-2.2489533692307d-31,-1.0066348627534d-44/
      data (pmn(lat,29,31), lat = 1,72)/
     |   5.0809364913855d-47, 3.4102287283111d-33, 8.8517901761419d-27,
     |   1.4310759687246d-22, 1.9143284159720d-19, 5.7640605803760d-17,
     |   6.4000111924276d-15, 3.4673424247269d-13, 1.0910421595562d-11,
     |   2.2386210406775d-10, 3.2470276496141d-09, 3.5300153913077d-08,
     |   3.0049554724089d-07, 2.0710861908052d-06, 1.1862960265642d-05,
     |   5.7651127072524d-05, 2.4168582575401d-04, 8.8584539591660d-04,
     |   2.8699520635871d-03, 8.2921043149900d-03, 2.1520613104240d-02,
     |   5.0458483391623d-02, 1.0735424870828d-01, 2.0791093621424d-01,
     |   3.6720808973015d-01, 5.9168715933477d-01, 8.6853553883491d-01,
     |   1.1567565036085d+00, 1.3863945120513d+00, 1.4715805804716d+00,
     |   1.3379752778362d+00, 9.5705397512479d-01, 3.7259485525646d-01,
     |  -2.9621751229271d-01,-8.8279025672923d-01,-1.2256780078039d+00,
     |  -1.2256780078039d+00,-8.8279025672923d-01,-2.9621751229271d-01,
     |   3.7259485525646d-01, 9.5705397512479d-01, 1.3379752778362d+00,
     |   1.4715805804716d+00, 1.3863945120513d+00, 1.1567565036085d+00,
     |   8.6853553883491d-01, 5.9168715933477d-01, 3.6720808973015d-01,
     |   2.0791093621424d-01, 1.0735424870828d-01, 5.0458483391623d-02,
     |   2.1520613104240d-02, 8.2921043149900d-03, 2.8699520635872d-03,
     |   8.8584539591661d-04, 2.4168582575401d-04, 5.7651127072524d-05,
     |   1.1862960265642d-05, 2.0710861908052d-06, 3.0049554724089d-07,
     |   3.5300153913077d-08, 3.2470276496141d-09, 2.2386210406776d-10,
     |   1.0910421595562d-11, 3.4673424247270d-13, 6.4000111924276d-15,
     |   5.7640605803763d-17, 1.9143284159720d-19, 1.4310759687246d-22,
     |   8.8517901761419d-27, 3.4102287283111d-33, 5.0809364913855d-47/
      data (pmn(lat,30,31), lat = 1,72)/
     |   2.0409490770719d-49, 4.1150266508475d-35, 1.7849717964770d-28,
     |   4.0564209719933d-24, 7.0144460748927d-21, 2.5990942646730d-18,
     |   3.4389331047786d-16, 2.1709084987272d-14, 7.8303357899778d-13,
     |   1.8191812598111d-11, 2.9597397387939d-10, 3.5831088889187d-09,
     |   3.3775084798794d-08, 2.5666290931170d-07, 1.6157388855513d-06,
     |   8.6102367265971d-06, 3.9524884732533d-05, 1.5853138944227d-04,
     |   5.6212150387000d-04, 1.7791821894725d-03, 5.0673079486024d-03,
     |   1.3073710218359d-02, 3.0724023860584d-02, 6.6064123525569d-02,
     |   1.3043988975538d-01, 2.3712549593482d-01, 3.9760050126057d-01,
     |   6.1541605738788d-01, 8.7899200890860d-01, 1.1562559990413d+00,
     |   1.3948164025328d+00, 1.5303881003992d+00, 1.5032056213991d+00,
     |   1.2781251878227d+00, 8.6103451590834d-01, 3.0408830936360d-01,
     |  -3.0408830936359d-01,-8.6103451590834d-01,-1.2781251878227d+00,
     |  -1.5032056213991d+00,-1.5303881003992d+00,-1.3948164025328d+00,
     |  -1.1562559990413d+00,-8.7899200890860d-01,-6.1541605738788d-01,
     |  -3.9760050126057d-01,-2.3712549593482d-01,-1.3043988975538d-01,
     |  -6.6064123525569d-02,-3.0724023860584d-02,-1.3073710218359d-02,
     |  -5.0673079486025d-03,-1.7791821894725d-03,-5.6212150387001d-04,
     |  -1.5853138944227d-04,-3.9524884732533d-05,-8.6102367265972d-06,
     |  -1.6157388855513d-06,-2.5666290931170d-07,-3.3775084798795d-08,
     |  -3.5831088889187d-09,-2.9597397387939d-10,-1.8191812598111d-11,
     |  -7.8303357899780d-13,-2.1709084987272d-14,-3.4389331047786d-16,
     |  -2.5990942646732d-18,-7.0144460748927d-21,-4.0564209719933d-24,
     |  -1.7849717964770d-28,-4.1150266508475d-35,-2.0409490770719d-49/
      data (pmn(lat,31,31), lat = 1,72)/
     |   5.6557814009234d-52, 3.4253597480354d-37, 2.4826772870226d-30,
     |   7.9291627897178d-26, 1.7719820667426d-22, 8.0771359458517d-20,
     |   1.2729954145536d-17, 9.3589458797451d-16, 3.8672187032475d-14,
     |   1.0165838347202d-12, 1.8536711389973d-11, 2.4965187772771d-10,
     |   2.6028961245825d-09, 2.1780099269944d-08, 1.5045816378648d-07,
     |   8.7762746451918d-07, 4.4021283909731d-06, 1.9273639603810d-05,
     |   7.4574447088489d-05, 2.5765385224637d-04, 8.0184512787805d-04,
     |   2.2644492132720d-03, 5.8396882372679d-03, 1.3826542704966d-02,
     |   3.0195616644271d-02, 6.1067114301479d-02, 1.1475933099393d-01,
     |   2.0098275129061d-01, 3.2885755252366d-01, 5.0380120057432d-01,
     |   7.2391903244684d-01, 9.7711110510948d-01, 1.2403446760032d+00,
     |   1.4821521602815d+00, 1.6683813789357d+00, 1.7698953494669d+00,
     |   1.7698953494669d+00, 1.6683813789357d+00, 1.4821521602815d+00,
     |   1.2403446760032d+00, 9.7711110510948d-01, 7.2391903244684d-01,
     |   5.0380120057433d-01, 3.2885755252367d-01, 2.0098275129061d-01,
     |   1.1475933099393d-01, 6.1067114301479d-02, 3.0195616644271d-02,
     |   1.3826542704966d-02, 5.8396882372679d-03, 2.2644492132720d-03,
     |   8.0184512787807d-04, 2.5765385224638d-04, 7.4574447088489d-05,
     |   1.9273639603810d-05, 4.4021283909731d-06, 8.7762746451919d-07,
     |   1.5045816378648d-07, 2.1780099269944d-08, 2.6028961245825d-09,
     |   2.4965187772771d-10, 1.8536711389973d-11, 1.0165838347202d-12,
     |   3.8672187032476d-14, 9.3589458797453d-16, 1.2729954145536d-17,
     |   8.0771359458522d-20, 1.7719820667426d-22, 7.9291627897178d-26,
     |   2.4826772870226d-30, 3.4253597480354d-37, 5.6557814009234d-52/
      data (pmn(lat, 0,32), lat = 1,72)/
     |   5.0067127884199d+00, 8.6220617286740d-01,-2.2022964178367d+00,
     |  -1.0823265706950d+00, 1.3721895775663d+00, 1.2342220359422d+00,
     |  -8.0701191792350d-01,-1.2876103588943d+00, 3.4421645939298d-01,
     |   1.2490291090183d+00, 4.8566946225723d-02,-1.1289393996941d+00,
     |  -3.7402580277771d-01, 9.4096654743073d-01, 6.2687102219178d-01,
     |  -7.0173796415975d-01,-8.0110622233773d-01, 4.3024103207640d-01,
     |   8.9316121042784d-01,-1.4681900994633d-01,-9.0337786320899d-01,
     |  -1.2803959287681d-01, 8.3661323652435d-01, 3.7498585236061d-01,
     |  -7.0224724337066d-01,-5.7705491716930d-01, 5.1373527449328d-01,
     |   7.2077043626479d-01,-2.8780272545573d-01,-7.9702519296226d-01,
     |   4.3370157754853d-02, 8.0167300961816d-01, 1.9969933930839d-01,
     |  -7.3578871897420d-01,-4.2193479486768d-01, 6.0557688995179d-01,
     |   6.0557688995179d-01,-4.2193479486768d-01,-7.3578871897420d-01,
     |   1.9969933930839d-01, 8.0167300961816d-01, 4.3370157754851d-02,
     |  -7.9702519296226d-01,-2.8780272545574d-01, 7.2077043626479d-01,
     |   5.1373527449328d-01,-5.7705491716929d-01,-7.0224724337067d-01,
     |   3.7498585236061d-01, 8.3661323652435d-01,-1.2803959287681d-01,
     |  -9.0337786320899d-01,-1.4681900994634d-01, 8.9316121042784d-01,
     |   4.3024103207640d-01,-8.0110622233772d-01,-7.0173796415975d-01,
     |   6.2687102219178d-01, 9.4096654743073d-01,-3.7402580277770d-01,
     |  -1.1289393996941d+00, 4.8566946225723d-02, 1.2490291090183d+00,
     |   3.4421645939300d-01,-1.2876103588943d+00,-8.0701191792350d-01,
     |   1.2342220359422d+00, 1.3721895775663d+00,-1.0823265706950d+00,
     |  -2.2022964178367d+00, 8.6220617286740d-01, 5.0067127884199d+00/
      data (pmn(lat, 1,32), lat = 1,72)/
     |   1.8965785350453d+00, 3.2241833890885d+00, 6.7677529028024d-01,
     |  -1.8459026626516d+00,-1.0688235613781d+00, 1.1518285434741d+00,
     |   1.2325100753850d+00,-6.2493550795968d-01,-1.2669323398275d+00,
     |   1.8329587657537d-01, 1.2007716462212d+00, 1.8847954196426d-01,
     |  -1.0525195333663d+00,-4.8853471390395d-01, 8.4013987399864d-01,
     |   7.1097649561311d-01,-5.8303933266090d-01,-8.5088846741432d-01,
     |   3.0197779056183d-01, 9.0662126244713d-01,-1.8221852402829d-02,
     |  -8.8084252653358d-01,-2.4760771640131d-01, 7.8084476473596d-01,
     |   4.7677096118080d-01,-6.1831945591700d-01,-6.5358031736913d-01,
     |   4.0871587438460d-01, 7.6639989851113d-01,-1.7027876101605d-01,
     |  -8.0838958945238d-01,-7.7143117308714d-02, 7.7793527714783d-01,
     |   3.1342165785326d-01,-6.7873151101764d-01,-5.1950859897551d-01,
     |   5.1950859897551d-01, 6.7873151101765d-01,-3.1342165785326d-01,
     |  -7.7793527714783d-01, 7.7143117308711d-02, 8.0838958945238d-01,
     |   1.7027876101606d-01,-7.6639989851112d-01,-4.0871587438461d-01,
     |   6.5358031736913d-01, 6.1831945591701d-01,-4.7677096118079d-01,
     |  -7.8084476473596d-01, 2.4760771640131d-01, 8.8084252653358d-01,
     |   1.8221852402847d-02,-9.0662126244713d-01,-3.0197779056184d-01,
     |   8.5088846741432d-01, 5.8303933266091d-01,-7.1097649561311d-01,
     |  -8.4013987399863d-01, 4.8853471390395d-01, 1.0525195333663d+00,
     |  -1.8847954196426d-01,-1.2007716462212d+00,-1.8329587657538d-01,
     |   1.2669323398275d+00, 6.2493550795969d-01,-1.2325100753850d+00,
     |  -1.1518285434741d+00, 1.0688235613781d+00, 1.8459026626516d+00,
     |  -6.7677529028024d-01,-3.2241833890885d+00,-1.8965785350453d+00/
      data (pmn(lat, 2,32), lat = 1,72)/
     |   3.4310469419467d-01, 2.1673767868553d+00, 2.5850731026855d+00,
     |   3.4453349770048d-01,-1.7045106108322d+00,-9.4541362146920d-01,
     |   1.0682733129497d+00, 1.1754182149926d+00,-5.4524360109342d-01,
     |  -1.2245510636753d+00, 1.0138832534823d-01, 1.1511742591054d+00,
     |   2.6752826016535d-01,-9.8690034949925d-01,-5.5687912227889d-01,
     |   7.5697594996976d-01, 7.6090972952971d-01,-4.8540583127955d-01,
     |  -8.7619964204890d-01, 1.9593877628625d-01, 9.0333361734258d-01,
     |   8.8373355817418d-02,-8.4759877618152d-01,-3.4615169092154d-01,
     |   7.1902670664781d-01, 5.5881773584193d-01,-5.3193870533123d-01,
     |  -7.1166254166970d-01, 3.0410243790931d-01, 7.9472350672080d-01,
     |  -5.5597298610666d-02,-8.0337854755223d-01,-1.9251250684275d-01,
     |   7.3860105663064d-01, 4.1959437685558d-01,-6.0684949560155d-01,
     |  -6.0684949560155d-01, 4.1959437685558d-01, 7.3860105663064d-01,
     |  -1.9251250684275d-01,-8.0337854755223d-01,-5.5597298610664d-02,
     |   7.9472350672080d-01, 3.0410243790932d-01,-7.1166254166970d-01,
     |  -5.3193870533124d-01, 5.5881773584193d-01, 7.1902670664782d-01,
     |  -3.4615169092154d-01,-8.4759877618152d-01, 8.8373355817418d-02,
     |   9.0333361734258d-01, 1.9593877628625d-01,-8.7619964204890d-01,
     |  -4.8540583127955d-01, 7.6090972952970d-01, 7.5697594996977d-01,
     |  -5.5687912227890d-01,-9.8690034949925d-01, 2.6752826016534d-01,
     |   1.1511742591054d+00, 1.0138832534823d-01,-1.2245510636753d+00,
     |  -5.4524360109343d-01, 1.1754182149925d+00, 1.0682733129497d+00,
     |  -9.4541362146918d-01,-1.7045106108322d+00, 3.4453349770048d-01,
     |   2.5850731026855d+00, 2.1673767868553d+00, 3.4310469419467d-01/
      data (pmn(lat, 3,32), lat = 1,72)/
     |   4.0857844705792d-02, 8.5165648945657d-01, 2.2356943989985d+00,
     |   2.1257380710059d+00, 1.3058206385026d-02,-1.6309518988518d+00,
     |  -7.8242822166821d-01, 1.0535660440647d+00, 1.0962653064109d+00,
     |  -5.2718615075006d-01,-1.1776774354897d+00, 7.0183244378471d-02,
     |   1.1089449625464d+00, 3.0713944074293d-01,-9.3549176594833d-01,
     |  -5.9590170987955d-01, 6.9125402442289d-01, 7.8991463051400d-01,
     |  -4.0609352798399d-01,-8.8713490673198d-01, 1.0775270241550d-01,
     |   8.9051756887077d-01, 1.7816746149755d-01,-8.0825980951890d-01,
     |  -4.2898360663943d-01, 6.5351422524858d-01, 6.2593122405837d-01,
     |  -4.4365645514227d-01,-7.5511547211238d-01, 1.9919715164704d-01,
     |   8.0824853058774d-01, 5.7563538548682d-02,-7.8307331950337d-01,
     |  -3.0403280914643d-01, 6.8341798367959d-01, 5.1886263190626d-01,
     |  -5.1886263190626d-01,-6.8341798367959d-01, 3.0403280914643d-01,
     |   7.8307331950337d-01,-5.7563538548678d-02,-8.0824853058774d-01,
     |  -1.9919715164704d-01, 7.5511547211238d-01, 4.4365645514227d-01,
     |  -6.2593122405837d-01,-6.5351422524859d-01, 4.2898360663943d-01,
     |   8.0825980951891d-01,-1.7816746149755d-01,-8.9051756887077d-01,
     |  -1.0775270241552d-01, 8.8713490673198d-01, 4.0609352798400d-01,
     |  -7.8991463051400d-01,-6.9125402442290d-01, 5.9590170987955d-01,
     |   9.3549176594832d-01,-3.0713944074293d-01,-1.1089449625464d+00,
     |  -7.0183244378471d-02, 1.1776774354897d+00, 5.2718615075007d-01,
     |  -1.0962653064109d+00,-1.0535660440648d+00, 7.8242822166821d-01,
     |   1.6309518988518d+00,-1.3058206385026d-02,-2.1257380710059d+00,
     |  -2.2356943989985d+00,-8.5165648945657d-01,-4.0857844705792d-02/
      data (pmn(lat, 4,32), lat = 1,72)/
     |   3.6231729918723d-03, 2.3928601388646d-01, 1.1982900572480d+00,
     |   2.2191425692974d+00, 1.7215921469627d+00,-2.8956090120316d-01,
     |  -1.5698173039623d+00,-6.0244737545738d-01, 1.0702910239472d+00,
     |   1.0055792391416d+00,-5.4513710225223d-01,-1.1307220142850d+00,
     |   7.1059478505965d-02, 1.0750901624245d+00, 3.2155769999374d-01,
     |  -8.9702278161523d-01,-6.1672356965720d-01, 6.4002622324518d-01,
     |   8.0652479074628d-01,-3.4097132276546d-01,-8.8986662434037d-01,
     |   3.2623667614916d-02, 8.7213751677998d-01, 2.5606805910803d-01,
     |  -7.6479302815017d-01,-5.0057579453341d-01, 5.8460860348741d-01,
     |   6.8166686992728d-01,-3.5257380274849d-01,-7.8622232652021d-01,
     |   9.2483128162308d-02, 8.0781002934000d-01, 1.7068369983437d-01,
     |  -7.4690353189127d-01,-4.1248042120255d-01, 6.1069319026984d-01,
     |   6.1069319026984d-01,-4.1248042120255d-01,-7.4690353189127d-01,
     |   1.7068369983436d-01, 8.0781002934000d-01, 9.2483128162306d-02,
     |  -7.8622232652021d-01,-3.5257380274850d-01, 6.8166686992728d-01,
     |   5.8460860348741d-01,-5.0057579453340d-01,-7.6479302815017d-01,
     |   2.5606805910803d-01, 8.7213751677998d-01, 3.2623667614916d-02,
     |  -8.8986662434037d-01,-3.4097132276546d-01, 8.0652479074628d-01,
     |   6.4002622324518d-01,-6.1672356965719d-01,-8.9702278161523d-01,
     |   3.2155769999375d-01, 1.0750901624245d+00, 7.1059478505980d-02,
     |  -1.1307220142850d+00,-5.4513710225223d-01, 1.0055792391416d+00,
     |   1.0702910239472d+00,-6.0244737545737d-01,-1.5698173039623d+00,
     |  -2.8956090120318d-01, 1.7215921469627d+00, 2.2191425692974d+00,
     |   1.1982900572480d+00, 2.3928601388646d-01, 3.6231729918723d-03/
      data (pmn(lat, 5,32), lat = 1,72)/
     |   2.5550646651567d-04, 5.2460053684373d-02, 4.7517918382592d-01,
     |   1.4496341397434d+00, 2.1380806091891d+00, 1.3431207843280d+00,
     |  -5.5318573978473d-01,-1.4987371213559d+00,-4.1642417350109d-01,
     |   1.0972373242636d+00, 9.0746372175721d-01,-5.8271940579489d-01,
     |  -1.0841128139234d+00, 9.1587107864262d-02, 1.0480972842852d+00,
     |   3.2040421600192d-01,-8.6870627106457d-01,-6.2678444093322d-01,
     |   5.9955719019879d-01, 8.1623180545111d-01,-2.8567922835338d-01,
     |  -8.8800381786593d-01,-3.4014327680593d-02, 8.4999534570181d-01,
     |   3.2635104217731d-01,-7.1738830071260d-01,-5.6440834163463d-01,
     |   5.1125262792687d-01, 7.2827848983234d-01,-2.5692273509434d-01,
     |  -8.0573842221140d-01,-1.7847840194154d-02, 7.9262049021430d-01,
     |   2.8487339360776d-01,-6.9277117961391d-01,-5.1755011644307d-01,
     |   5.1755011644306d-01, 6.9277117961391d-01,-2.8487339360776d-01,
     |  -7.9262049021430d-01, 1.7847840194150d-02, 8.0573842221140d-01,
     |   2.5692273509434d-01,-7.2827848983234d-01,-5.1125262792687d-01,
     |   5.6440834163463d-01, 7.1738830071260d-01,-3.2635104217730d-01,
     |  -8.4999534570181d-01, 3.4014327680593d-02, 8.8800381786593d-01,
     |   2.8567922835340d-01,-8.1623180545111d-01,-5.9955719019879d-01,
     |   6.2678444093321d-01, 8.6870627106458d-01,-3.2040421600192d-01,
     |  -1.0480972842852d+00,-9.1587107864257d-02, 1.0841128139234d+00,
     |   5.8271940579489d-01,-9.0746372175721d-01,-1.0972373242636d+00,
     |   4.1642417350108d-01, 1.4987371213558d+00, 5.5318573978473d-01,
     |  -1.3431207843280d+00,-2.1380806091891d+00,-1.4496341397434d+00,
     |  -4.7517918382592d-01,-5.2460053684373d-02,-2.5550646651567d-04/
      data (pmn(lat, 6,32), lat = 1,72)/
     |   1.4924614430222d-05, 9.4273485176524d-03, 1.5044673673029d-01,
     |   7.1045662291920d-01, 1.6257807169561d+00, 2.0045714731937d+00,
     |   9.8493531281413d-01,-7.7300878855470d-01,-1.4098032131917d+00,
     |  -2.3195851057161d-01, 1.1222747722540d+00, 8.0461853281020d-01,
     |  -6.2916133451350d-01,-1.0375241476790d+00, 1.2313857083901d-01,
     |   1.0260167909123d+00, 3.1047059638509d-01,-8.4754679063105d-01,
     |  -6.3126085909613d-01, 5.6610334241591d-01, 8.2261199062371d-01,
     |  -2.3605614713926d-01,-8.8347285752487d-01,-9.6285780306172d-02,
     |   8.2440721541831d-01, 3.9256190138850d-01,-6.6498299114140d-01,
     |  -6.2291158985854d-01, 4.3146788387398d-01, 7.6666542727929d-01,
     |  -1.5448606942763d-01,-8.1284552147188d-01,-1.3342691252490d-01,
     |   7.6027467642525d-01, 4.0030995277932d-01,-6.1718767749753d-01,
     |  -6.1718767749753d-01, 4.0030995277931d-01, 7.6027467642525d-01,
     |  -1.3342691252490d-01,-8.1284552147188d-01,-1.5448606942763d-01,
     |   7.6666542727929d-01, 4.3146788387399d-01,-6.2291158985854d-01,
     |  -6.6498299114140d-01, 3.9256190138850d-01, 8.2440721541831d-01,
     |  -9.6285780306169d-02,-8.8347285752487d-01,-2.3605614713926d-01,
     |   8.2261199062371d-01, 5.6610334241591d-01,-6.3126085909613d-01,
     |  -8.4754679063105d-01, 3.1047059638508d-01, 1.0260167909123d+00,
     |   1.2313857083900d-01,-1.0375241476790d+00,-6.2916133451351d-01,
     |   8.0461853281020d-01, 1.1222747722540d+00,-2.3195851057159d-01,
     |  -1.4098032131917d+00,-7.7300878855470d-01, 9.8493531281413d-01,
     |   2.0045714731937d+00, 1.6257807169561d+00, 7.1045662291920d-01,
     |   1.5044673673029d-01, 9.4273485176524d-03, 1.4924614430222d-05/
      data (pmn(lat, 7,32), lat = 1,72)/
     |   7.4229399138652d-07, 1.4333355206046d-03, 3.9696059374324d-02,
     |   2.8129431893204d-01, 9.2938845461383d-01, 1.7360687080630d+00,
     |   1.8298675076134d+00, 6.4942489561397d-01,-9.4729477721537d-01,
     |  -1.3023703352903d+00,-5.5214204537339d-02, 1.1388473310208d+00,
     |   6.9978664003593d-01,-6.7727837340015d-01,-9.9099359243181d-01,
     |   1.5945997527343d-01, 1.0072433992686d+00, 2.9683960669100d-01,
     |  -8.3082191296135d-01,-6.3395937718265d-01, 5.3616345540363d-01,
     |   8.2801723515406d-01,-1.8824301578000d-01,-8.7702825240865d-01,
     |  -1.5783517693450d-01, 7.9457409820503d-01, 4.5747367164065d-01,
     |  -6.0555461934804d-01,-6.7738113810654d-01, 3.4264918295242d-01,
     |   7.9624641512778d-01,-4.2976987311272d-02,-8.0503577600976d-01,
     |  -2.5517663405589d-01, 7.0674589579413d-01, 5.1552853876020d-01,
     |  -5.1552853876020d-01,-7.0674589579413d-01, 2.5517663405589d-01,
     |   8.0503577600976d-01, 4.2976987311276d-02,-7.9624641512778d-01,
     |  -3.4264918295242d-01, 6.7738113810653d-01, 6.0555461934805d-01,
     |  -4.5747367164064d-01,-7.9457409820503d-01, 1.5783517693449d-01,
     |   8.7702825240865d-01, 1.8824301578000d-01,-8.2801723515406d-01,
     |  -5.3616345540364d-01, 6.3395937718265d-01, 8.3082191296135d-01,
     |  -2.9683960669099d-01,-1.0072433992686d+00,-1.5945997527343d-01,
     |   9.9099359243181d-01, 6.7727837340015d-01,-6.9978664003591d-01,
     |  -1.1388473310208d+00, 5.5214204537339d-02, 1.3023703352903d+00,
     |   9.4729477721538d-01,-6.4942489561396d-01,-1.8298675076134d+00,
     |  -1.7360687080630d+00,-9.2938845461383d-01,-2.8129431893204d-01,
     |  -3.9696059374324d-02,-1.4333355206046d-03,-7.4229399138652d-07/
      data (pmn(lat, 8,32), lat = 1,72)/
     |   3.2064185652914d-08, 1.8847561600073d-04, 8.9726222875071d-03,
     |   9.3699829377023d-02, 4.3141646411832d-01, 1.1224149366514d+00,
     |   1.7875792041843d+00, 1.6253860194105d+00, 3.4119008803189d-01,
     |  -1.0768100751689d+00,-1.1796716703577d+00, 1.0878428262889d-01,
     |   1.1440991789706d+00, 5.9601343850206d-01,-7.2235190110264d-01,
     |  -9.4521322667601d-01, 1.9584442726272d-01, 9.9073846000223d-01,
     |   2.8355276049812d-01,-8.1618957610520d-01,-6.3784095067580d-01,
     |   5.0648953528719d-01, 8.3395050974748d-01,-1.3865480447423d-01,
     |  -8.6849362995847d-01,-2.2182506296331d-01, 7.5873800624924d-01,
     |   5.2300213812384d-01,-5.3627640010962d-01,-7.2779771322224d-01,
     |   2.4182317268648d-01, 8.1473101301443d-01, 7.9501750661915d-02,
     |  -7.7795049443166d-01,-3.8259450547600d-01, 6.2647306332444d-01,
     |   6.2647306332445d-01,-3.8259450547599d-01,-7.7795049443166d-01,
     |   7.9501750661913d-02, 8.1473101301443d-01, 2.4182317268647d-01,
     |  -7.2779771322224d-01,-5.3627640010962d-01, 5.2300213812384d-01,
     |   7.5873800624924d-01,-2.2182506296330d-01,-8.6849362995847d-01,
     |  -1.3865480447423d-01, 8.3395050974748d-01, 5.0648953528719d-01,
     |  -6.3784095067579d-01,-8.1618957610521d-01, 2.8355276049811d-01,
     |   9.9073846000223d-01, 1.9584442726273d-01,-9.4521322667601d-01,
     |  -7.2235190110263d-01, 5.9601343850206d-01, 1.1440991789707d+00,
     |   1.0878428262889d-01,-1.1796716703577d+00,-1.0768100751689d+00,
     |   3.4119008803188d-01, 1.6253860194105d+00, 1.7875792041843d+00,
     |   1.1224149366514d+00, 4.3141646411832d-01, 9.3699829377023d-02,
     |   8.9726222875071d-03, 1.8847561600073d-04, 3.2064185652914d-08/
      data (pmn(lat, 9,32), lat = 1,72)/
     |   1.2208359768526d-09, 2.1781739870286d-05, 1.7710367049309d-03,
     |   2.6941877097487d-02, 1.6934639898679d-01, 5.8949026668589d-01,
     |   1.2834741593796d+00, 1.7876091059040d+00, 1.4024772665004d+00,
     |   6.4674930865957d-02,-1.1644756450660d+00,-1.0469300909330d+00,
     |   2.5622540618790d-01, 1.1377357854196d+00, 4.9652402300744d-01,
     |  -7.6145619571286d-01,-9.0149358206464d-01, 2.2863914672632d-01,
     |   9.7600176950885d-01, 2.7400149334418d-01,-8.0161630487047d-01,
     |  -6.4529866518968d-01, 4.7398770994228d-01, 8.4121436969931d-01,
     |  -8.3916705815832d-02,-8.5680464278460d-01,-2.9089260008069d-01,
     |   7.1419650565642d-01, 5.9001385615545d-01,-4.5362491530092d-01,
     |  -7.7251161377192d-01, 1.2598556852623d-01, 8.1779575148031d-01,
     |   2.1378593439162d-01,-7.2525921707045d-01,-5.1273054580107d-01,
     |   5.1273054580106d-01, 7.2525921707045d-01,-2.1378593439162d-01,
     |  -8.1779575148031d-01,-1.2598556852623d-01, 7.7251161377192d-01,
     |   4.5362491530093d-01,-5.9001385615544d-01,-7.1419650565642d-01,
     |   2.9089260008069d-01, 8.5680464278460d-01, 8.3916705815840d-02,
     |  -8.4121436969931d-01,-4.7398770994228d-01, 6.4529866518968d-01,
     |   8.0161630487048d-01,-2.7400149334418d-01,-9.7600176950885d-01,
     |  -2.2863914672632d-01, 9.0149358206463d-01, 7.6145619571287d-01,
     |  -4.9652402300744d-01,-1.1377357854196d+00,-2.5622540618792d-01,
     |   1.0469300909330d+00, 1.1644756450660d+00,-6.4674930865946d-02,
     |  -1.4024772665004d+00,-1.7876091059040d+00,-1.2834741593796d+00,
     |  -5.8949026668589d-01,-1.6934639898679d-01,-2.6941877097487d-02,
     |  -1.7710367049309d-03,-2.1781739870286d-05,-1.2208359768526d-09/
      data (pmn(lat,10,32), lat = 1,72)/
     |   4.1439770535272d-11, 2.2394495649306d-06, 3.0957664955380d-04,
     |   6.8063988117281d-03, 5.7640806591513d-02, 2.6235325891535d-01,
     |   7.4603071336474d-01, 1.4093677613777d+00, 1.7442953612527d+00,
     |   1.1719211078451d+00,-1.7692613611461d-01,-1.2149678604728d+00,
     |  -9.1016929538994d-01, 3.8458609674678d-01, 1.1212293268920d+00,
     |   4.0451660487613d-01,-7.9299184317749d-01,-8.6160467060338d-01,
     |   2.5491928843198d-01, 9.6292205854713d-01, 2.7115734823686d-01,
     |  -7.8520841397960d-01,-6.5826567450066d-01, 4.3556953710793d-01,
     |   8.4988520549960d-01,-2.0821610214835d-02,-8.3990192386585d-01,
     |  -3.6700426884752d-01, 6.5724153726726d-01, 6.5797341172570d-01,
     |  -3.5354209861490d-01,-8.0777332816930d-01,-7.3421497228197d-03,
     |   7.9872465708844d-01, 3.5861257502175d-01,-6.3876214959287d-01,
     |  -6.3876214959287d-01, 3.5861257502175d-01, 7.9872465708844d-01,
     |  -7.3421497228172d-03,-8.0777332816930d-01,-3.5354209861490d-01,
     |   6.5797341172570d-01, 6.5724153726726d-01,-3.6700426884752d-01,
     |  -8.3990192386585d-01,-2.0821610214840d-02, 8.4988520549959d-01,
     |   4.3556953710793d-01,-6.5826567450066d-01,-7.8520841397960d-01,
     |   2.7115734823685d-01, 9.6292205854714d-01, 2.5491928843199d-01,
     |  -8.6160467060338d-01,-7.9299184317750d-01, 4.0451660487613d-01,
     |   1.1212293268920d+00, 3.8458609674677d-01,-9.1016929538993d-01,
     |  -1.2149678604728d+00,-1.7692613611461d-01, 1.1719211078451d+00,
     |   1.7442953612527d+00, 1.4093677613777d+00, 7.4603071336474d-01,
     |   2.6235325891535d-01, 5.7640806591513d-02, 6.8063988117281d-03,
     |   3.0957664955380d-04, 2.2394495649306d-06, 4.1439770535272d-11/
      data (pmn(lat,11,32), lat = 1,72)/
     |   1.2651988125821d-12, 2.0677188814760d-07, 4.8434522227665d-05,
     |   1.5303633997248d-03, 1.7303979356873d-02, 1.0148252226261d-01,
     |   3.6736991083297d-01, 8.9336777326434d-01, 1.4994648579631d+00,
     |   1.6665326993779d+00, 9.4342789034644d-01,-3.8211409533073d-01,
     |  -1.2342470400784d+00,-7.7542933975499d-01, 4.9260286741859d-01,
     |   1.0972035975982d+00, 3.2298967447267d-01,-8.1630248871594d-01,
     |  -8.2758157329000d-01, 2.7223247840271d-01, 9.5155886904826d-01,
     |   2.7770677739557d-01,-7.6497997289496d-01,-6.7819094880123d-01,
     |   3.8798948333037d-01, 8.5913752034806d-01, 5.3639150726556d-02,
     |  -8.1451131447043d-01,-4.5114379867500d-01, 5.8310228190871d-01,
     |   7.2438055237569d-01,-2.3179098994478d-01,-8.2713014396791d-01,
     |  -1.5915313210511d-01, 7.4816978745121d-01, 5.0905901733344d-01,
     |  -5.0905901733344d-01,-7.4816978745121d-01, 1.5915313210511d-01,
     |   8.2713014396791d-01, 2.3179098994478d-01,-7.2438055237569d-01,
     |  -5.8310228190871d-01, 4.5114379867499d-01, 8.1451131447044d-01,
     |  -5.3639150726553d-02,-8.5913752034806d-01,-3.8798948333038d-01,
     |   6.7819094880123d-01, 7.6497997289496d-01,-2.7770677739557d-01,
     |  -9.5155886904827d-01,-2.7223247840272d-01, 8.2758157329000d-01,
     |   8.1630248871594d-01,-3.2298967447266d-01,-1.0972035975982d+00,
     |  -4.9260286741858d-01, 7.7542933975500d-01, 1.2342470400784d+00,
     |   3.8211409533073d-01,-9.4342789034644d-01,-1.6665326993779d+00,
     |  -1.4994648579631d+00,-8.9336777326434d-01,-3.6736991083297d-01,
     |  -1.0148252226261d-01,-1.7303979356873d-02,-1.5303633997248d-03,
     |  -4.8434522227665d-05,-2.0677188814760d-07,-1.2651988125821d-12/
      data (pmn(lat,12,32), lat = 1,72)/
     |   3.4989546720134d-14, 1.7272651534607d-08, 6.8384290969425d-06,
     |   3.0921417789903d-04, 4.6379255709322d-03, 3.4697661934741d-02,
     |   1.5734284738253d-01, 4.7869280759440d-01, 1.0257333739458d+00,
     |   1.5553889492294d+00, 1.5636074788326d+00, 7.2525552283557d-01,
     |  -5.5114297246005d-01,-1.2290545044216d+00,-6.4826714605155d-01,
     |   5.8012123234748d-01, 1.0689320342712d+00, 2.5464759448976d-01,
     |  -8.3131523886604d-01,-8.0152958785085d-01, 2.7836393129169d-01,
     |   9.4187267693066d-01, 2.9611772846698d-01,-7.3857254321466d-01,
     |  -7.0588782732614d-01, 3.2770491064718d-01, 8.6692365996387d-01,
     |   1.4210364953599d-01,-7.7585635160101d-01,-5.4275319014616d-01,
     |   4.8601377540035d-01, 7.8396396723620d-01,-8.4709365753766d-02,
     |  -8.2079233113672d-01,-3.2736582134060d-01, 6.5436089641642d-01,
     |   6.5436089641642d-01,-3.2736582134060d-01,-8.2079233113672d-01,
     |  -8.4709365753768d-02, 7.8396396723620d-01, 4.8601377540035d-01,
     |  -5.4275319014616d-01,-7.7585635160101d-01, 1.4210364953598d-01,
     |   8.6692365996387d-01, 3.2770491064718d-01,-7.0588782732613d-01,
     |  -7.3857254321466d-01, 2.9611772846698d-01, 9.4187267693066d-01,
     |   2.7836393129171d-01,-8.0152958785084d-01,-8.3131523886604d-01,
     |   2.5464759448976d-01, 1.0689320342712d+00, 5.8012123234748d-01,
     |  -6.4826714605156d-01,-1.2290545044216d+00,-5.5114297246006d-01,
     |   7.2525552283557d-01, 1.5636074788326d+00, 1.5553889492294d+00,
     |   1.0257333739458d+00, 4.7869280759440d-01, 1.5734284738253d-01,
     |   3.4697661934742d-02, 4.6379255709322d-03, 3.0921417789903d-04,
     |   6.8384290969425d-06, 1.7272651534607d-08, 3.4989546720134d-14/
      data (pmn(lat,13,32), lat = 1,72)/
     |   8.8143633137119d-16, 1.3130818193245d-09, 8.7693324771016d-07,
     |   5.6563421417692d-05, 1.1199599844291d-03, 1.0611392367740d-02,
     |   5.9619133852478d-02, 2.2294585543771d-01, 5.9080901121405d-01,
     |   1.1393052829139d+00, 1.5806216799485d+00, 1.4447484337857d+00,
     |   5.2399098818913d-01,-6.8582766860140d-01,-1.2064275566242d+00,
     |  -5.3348386879600d-01, 6.4783883316496d-01, 1.0399215913656d+00,
     |   2.0189442554835d-01,-8.3817643005575d-01,-7.8543430734107d-01,
     |   2.7110252256794d-01, 9.3340023183249d-01, 3.2863254479073d-01,
     |  -7.0293929946078d-01,-7.4123237886455d-01, 2.5081479788013d-01,
     |   8.6950888349498d-01, 2.4642527933983d-01,-7.1738433012231d-01,
     |  -6.3883396345381d-01, 3.5961330598492d-01, 8.2765557275013d-01,
     |   8.9348108499158d-02,-7.7524510447808d-01,-5.0437925022304d-01,
     |   5.0437925022303d-01, 7.7524510447808d-01,-8.9348108499155d-02,
     |  -8.2765557275013d-01,-3.5961330598492d-01, 6.3883396345381d-01,
     |   7.1738433012232d-01,-2.4642527933982d-01,-8.6950888349498d-01,
     |  -2.5081479788014d-01, 7.4123237886455d-01, 7.0293929946079d-01,
     |  -3.2863254479073d-01,-9.3340023183249d-01,-2.7110252256794d-01,
     |   7.8543430734106d-01, 8.3817643005576d-01,-2.0189442554835d-01,
     |  -1.0399215913656d+00,-6.4783883316497d-01, 5.3348386879599d-01,
     |   1.2064275566242d+00, 6.8582766860140d-01,-5.2399098818912d-01,
     |  -1.4447484337857d+00,-1.5806216799485d+00,-1.1393052829139d+00,
     |  -5.9080901121406d-01,-2.2294585543771d-01,-5.9619133852478d-02,
     |  -1.0611392367741d-02,-1.1199599844291d-03,-5.6563421417692d-05,
     |  -8.7693324771016d-07,-1.3130818193245d-09,-8.8143633137119d-16/
      data (pmn(lat,14,32), lat = 1,72)/
     |   2.0316706624360d-17, 9.1265975970307d-11, 1.0265552041610d-07,
     |   9.4215653480912d-06, 2.4534072836060d-04, 2.9280999721824d-03,
     |   2.0222852141398d-02, 9.1850650030749d-02, 2.9525717827506d-01,
     |   6.9881142163102d-01, 1.2321464934196d+00, 1.5800393589277d+00,
     |   1.3187062444991d+00, 3.4450872079491d-01,-7.8919416678561d-01,
     |  -1.1732722027135d+00,-4.3503919026722d-01, 6.9696759069157d-01,
     |   1.0135652008695d+00, 1.6690524167050d-01,-8.3686793091177d-01,
     |  -7.8095935527209d-01, 2.4801193575089d-01, 9.2485943258620d-01,
     |   3.7714918296914d-01,-6.5401838400773d-01,-7.8266534350404d-01,
     |   1.5317412361271d-01, 8.6087916424486d-01, 3.6687262829466d-01,
     |  -6.3066898452440d-01,-7.3262995677713d-01, 1.9799349017750d-01,
     |   8.4151717325833d-01, 2.8751192391688d-01,-6.7370163922371d-01,
     |  -6.7370163922371d-01, 2.8751192391688d-01, 8.4151717325833d-01,
     |   1.9799349017751d-01,-7.3262995677713d-01,-6.3066898452440d-01,
     |   3.6687262829466d-01, 8.6087916424486d-01, 1.5317412361271d-01,
     |  -7.8266534350404d-01,-6.5401838400773d-01, 3.7714918296913d-01,
     |   9.2485943258620d-01, 2.4801193575089d-01,-7.8095935527209d-01,
     |  -8.3686793091178d-01, 1.6690524167050d-01, 1.0135652008695d+00,
     |   6.9696759069158d-01,-4.3503919026721d-01,-1.1732722027135d+00,
     |  -7.8919416678561d-01, 3.4450872079491d-01, 1.3187062444991d+00,
     |   1.5800393589277d+00, 1.2321464934196d+00, 6.9881142163102d-01,
     |   2.9525717827506d-01, 9.1850650030750d-02, 2.0222852141398d-02,
     |   2.9280999721825d-03, 2.4534072836060d-04, 9.4215653480912d-06,
     |   1.0265552041610d-07, 9.1265975970307d-11, 2.0316706624360d-17/
      data (pmn(lat,15,32), lat = 1,72)/
     |   4.2998111505581d-19, 5.8209774828771d-12, 1.1013380805885d-08,
     |   1.4353534310767d-06, 4.9012614966526d-05, 7.3377340374418d-04,
     |   6.1930390534780d-03, 3.3874428845747d-02, 1.3039554691073d-01,
     |   3.7086167244126d-01, 7.9868417150468d-01, 1.3040284000866d+00,
     |   1.5594227964010d+00, 1.1934260566989d+00, 1.9009469182600d-01,
     |  -8.6504016583394d-01,-1.1360161942440d+00,-3.5611472189147d-01,
     |   7.2883899473763d-01, 9.9284046912092d-01, 1.5174851774392d-01,
     |  -8.2679358069876d-01,-7.8919243359524d-01, 2.0623584739274d-01,
     |   9.1366220519848d-01, 4.4291579511084d-01,-5.8645335960081d-01,
     |  -8.2643884313938d-01, 3.0847170249522d-02, 8.3210000262257d-01,
     |   5.0075838451029d-01,-5.0580351914979d-01,-8.1190430647375d-01,
     |  -2.0948392652717d-03, 8.0611065897825d-01, 4.9850669572451d-01,
     |  -4.9850669572450d-01,-8.0611065897825d-01, 2.0948392652690d-03,
     |   8.1190430647375d-01, 5.0580351914980d-01,-5.0075838451029d-01,
     |  -8.3210000262257d-01,-3.0847170249530d-02, 8.2643884313938d-01,
     |   5.8645335960081d-01,-4.4291579511083d-01,-9.1366220519848d-01,
     |  -2.0623584739274d-01, 7.8919243359524d-01, 8.2679358069876d-01,
     |  -1.5174851774391d-01,-9.9284046912092d-01,-7.2883899473764d-01,
     |   3.5611472189147d-01, 1.1360161942440d+00, 8.6504016583395d-01,
     |  -1.9009469182600d-01,-1.1934260566989d+00,-1.5594227964010d+00,
     |  -1.3040284000866d+00,-7.9868417150468d-01,-3.7086167244127d-01,
     |  -1.3039554691073d-01,-3.3874428845747d-02,-6.1930390534780d-03,
     |  -7.3377340374420d-04,-4.9012614966526d-05,-1.4353534310767d-06,
     |  -1.1013380805885d-08,-5.8209774828771d-12,-4.2998111505581d-19/
      data (pmn(lat,16,32), lat = 1,72)/
     |   8.3781830000390d-21, 3.4164137469114d-13, 1.0861719448488d-09,
     |   2.0068933897950d-07, 8.9650062695664d-06, 1.6780901859480d-04,
     |   1.7229450502414d-03, 1.1277512994772d-02, 5.1511897717911d-02,
     |   1.7362540550212d-01, 4.4629825331901d-01, 8.8745366359638d-01,
     |   1.3561531564791d+00, 1.5249834794956d+00, 1.0758441995739d+00,
     |   6.2710034284004d-02,-9.1745517081766d-01,-1.1003444047595d+00,
     |  -2.9928505211791d-01, 7.4446985052441d-01, 9.8001887858486d-01,
     |   1.5851666111138d-01,-8.0632820109376d-01,-8.1027645081018d-01,
     |   1.4240066142433d-01, 8.9532114231038d-01, 5.2592057219714d-01,
     |  -4.9348563461650d-01,-8.6556434938142d-01,-1.1884300670508d-01,
     |   7.7084480128496d-01, 6.4031362306499d-01,-3.3283870188851d-01,
     |  -8.5708755657888d-01,-2.3726121887932d-01, 6.9739769296336d-01,
     |   6.9739769296336d-01,-2.3726121887932d-01,-8.5708755657888d-01,
     |  -3.3283870188851d-01, 6.4031362306499d-01, 7.7084480128496d-01,
     |  -1.1884300670508d-01,-8.6556434938142d-01,-4.9348563461650d-01,
     |   5.2592057219713d-01, 8.9532114231038d-01, 1.4240066142434d-01,
     |  -8.1027645081018d-01,-8.0632820109376d-01, 1.5851666111138d-01,
     |   9.8001887858486d-01, 7.4446985052441d-01,-2.9928505211790d-01,
     |  -1.1003444047595d+00,-9.1745517081767d-01, 6.2710034284000d-02,
     |   1.0758441995739d+00, 1.5249834794956d+00, 1.3561531564791d+00,
     |   8.8745366359638d-01, 4.4629825331901d-01, 1.7362540550212d-01,
     |   5.1511897717912d-02, 1.1277512994772d-02, 1.7229450502414d-03,
     |   1.6780901859481d-04, 8.9650062695664d-06, 2.0068933897950d-07,
     |   1.0861719448488d-09, 3.4164137469114d-13, 8.3781830000390d-21/
      data (pmn(lat,17,32), lat = 1,72)/
     |   1.5059550103070d-22, 1.8489545996541d-14, 9.8693009096576d-11,
     |   2.5817540240777d-08, 1.5058512357146d-06, 3.5148658102157d-05,
     |   4.3744403675961d-04, 3.4097209430522d-03, 1.8355790883953d-02,
     |   7.2609701541365d-02, 2.1946868595747d-01, 5.1832713137455d-01,
     |   9.6320908374079d-01, 1.3908036769127d+00, 1.4829404525429d+00,
     |   9.7181472842140d-01,-3.6639802143936d-02,-9.5033004107665d-01,
     |  -1.0709966269474d+00,-2.6674840866383d-01, 7.4409789597561d-01,
     |   9.7633156851104d-01, 1.8939872112658d-01,-7.7233158677591d-01,
     |  -8.4283768880086d-01, 5.2733822660101d-02, 8.6277134510041d-01,
     |   6.2381504380414d-01,-3.6726412804324d-01,-8.8849989065502d-01,
     |  -2.9530485431543d-01, 6.6158428856397d-01, 7.6976089826218d-01,
     |  -1.0513866917963d-01,-8.4016985022795d-01,-4.9118738775917d-01,
     |   4.9118738775917d-01, 8.4016985022795d-01, 1.0513866917963d-01,
     |  -7.6976089826218d-01,-6.6158428856397d-01, 2.9530485431543d-01,
     |   8.8849989065503d-01, 3.6726412804325d-01,-6.2381504380414d-01,
     |  -8.6277134510041d-01,-5.2733822660105d-02, 8.4283768880085d-01,
     |   7.7233158677592d-01,-1.8939872112658d-01,-9.7633156851104d-01,
     |  -7.4409789597563d-01, 2.6674840866383d-01, 1.0709966269474d+00,
     |   9.5033004107666d-01, 3.6639802143945d-02,-9.7181472842140d-01,
     |  -1.4829404525429d+00,-1.3908036769127d+00,-9.6320908374079d-01,
     |  -5.1832713137455d-01,-2.1946868595747d-01,-7.2609701541365d-02,
     |  -1.8355790883953d-02,-3.4097209430522d-03,-4.3744403675961d-04,
     |  -3.5148658102158d-05,-1.5058512357146d-06,-2.5817540240777d-08,
     |  -9.8693009096576d-11,-1.8489545996541d-14,-1.5059550103070d-22/
      data (pmn(lat,18,32), lat = 1,72)/
     |   2.5003705664237d-24, 9.2397557858435d-16, 8.2744911018948d-12,
     |   3.0611516114758d-09, 2.3275607361192d-07, 6.7600508376790d-06,
     |   1.0168737988100d-04, 9.4025383697552d-04, 5.9347329060559d-03,
     |   2.7353411563454d-02, 9.6215021847089d-02, 2.6560921532818d-01,
     |   5.8411224772283d-01, 1.0250060110913d+00, 1.4109527438190d+00,
     |   1.4391674915553d+00, 8.8615066485128d-01,-1.0746677627010d-01,
     |  -9.6686652373536d-01,-1.0515851867699d+00,-2.6055785801024d-01,
     |   7.2669327351173d-01, 9.8151749879595d-01, 2.4659280252938d-01,
     |  -7.1966006566755d-01,-8.8310428614894d-01,-6.6398864108948d-02,
     |   8.0572191792545d-01, 7.3018877339783d-01,-2.0001057783212d-01,
     |  -8.7783553198416d-01,-4.9128790338973d-01, 4.8738981529609d-01,
     |   8.6200417797996d-01, 1.7421281113190d-01,-7.2633630022937d-01,
     |  -7.2633630022937d-01, 1.7421281113189d-01, 8.6200417797996d-01,
     |   4.8738981529609d-01,-4.9128790338972d-01,-8.7783553198416d-01,
     |  -2.0001057783212d-01, 7.3018877339783d-01, 8.0572191792545d-01,
     |  -6.6398864108945d-02,-8.8310428614894d-01,-7.1966006566756d-01,
     |   2.4659280252938d-01, 9.8151749879595d-01, 7.2669327351173d-01,
     |  -2.6055785801023d-01,-1.0515851867699d+00,-9.6686652373536d-01,
     |  -1.0746677627010d-01, 8.8615066485127d-01, 1.4391674915553d+00,
     |   1.4109527438190d+00, 1.0250060110913d+00, 5.8411224772284d-01,
     |   2.6560921532818d-01, 9.6215021847089d-02, 2.7353411563454d-02,
     |   5.9347329060560d-03, 9.4025383697553d-04, 1.0168737988100d-04,
     |   6.7600508376793d-06, 2.3275607361192d-07, 3.0611516114758d-09,
     |   8.2744911018948d-12, 9.2397557858435d-16, 2.5003705664237d-24/
      data (pmn(lat,19,32), lat = 1,72)/
     |   3.8372329485307d-26, 4.2666525895051d-17, 6.4065623528649d-13,
     |   3.3486715700858d-10, 3.3148073597974d-08, 1.1957760836896d-06,
     |   2.1689155133753d-05, 2.3716717949782d-04, 1.7479661504132d-03,
     |   9.3355912916419d-03, 3.7924568696297d-02, 1.2103416120940d-01,
     |   3.0966806718272d-01, 6.4131174940208d-01, 1.0726740523014d+00,
     |   1.4198582119104d+00, 1.3989122586417d+00, 8.2274753928729d-01,
     |  -1.4932909368176d-01,-9.6907919470130d-01,-1.0443660028760d+00,
     |  -2.8277369555394d-01, 6.8946147533372d-01, 9.9316246933680d-01,
     |   3.3189809922133d-01,-6.4077973902092d-01,-9.2361641436237d-01,
     |  -2.1721172303663d-01, 7.1035008293637d-01, 8.3208099886507d-01,
     |   1.3258480931451d-02,-8.0971700055574d-01,-6.8786085746859d-01,
     |   2.3494503572369d-01, 8.7647391739645d-01, 4.8206555525870d-01,
     |  -4.8206555525870d-01,-8.7647391739645d-01,-2.3494503572369d-01,
     |   6.8786085746859d-01, 8.0971700055574d-01,-1.3258480931453d-02,
     |  -8.3208099886507d-01,-7.1035008293638d-01, 2.1721172303663d-01,
     |   9.2361641436237d-01, 6.4077973902092d-01,-3.3189809922132d-01,
     |  -9.9316246933680d-01,-6.8946147533372d-01, 2.8277369555394d-01,
     |   1.0443660028760d+00, 9.6907919470131d-01, 1.4932909368176d-01,
     |  -8.2274753928729d-01,-1.3989122586417d+00,-1.4198582119104d+00,
     |  -1.0726740523014d+00,-6.4131174940208d-01,-3.0966806718272d-01,
     |  -1.2103416120940d-01,-3.7924568696297d-02,-9.3355912916420d-03,
     |  -1.7479661504132d-03,-2.3716717949782d-04,-2.1689155133753d-05,
     |  -1.1957760836896d-06,-3.3148073597974d-08,-3.3486715700858d-10,
     |  -6.4065623528649d-13,-4.2666525895051d-17,-3.8372329485307d-26/
      data (pmn(lat,20,32), lat = 1,72)/
     |   5.4433481315561d-28, 1.8206978453042d-18, 4.5814961948439d-14,
     |   3.3807173443245d-11, 4.3518488027542d-09, 1.9469434474748d-07,
     |   4.2497930978933d-06, 5.4816185785504d-05, 4.7019392021464d-04,
     |   2.8973794413703d-03, 1.3514984341978d-02, 4.9466479932496d-02,
     |   1.4554303544101d-01, 3.4934977536771d-01, 6.8807966658839d-01,
     |   1.1065529875857d+00, 1.4206617466296d+00, 1.3665700389834d+00,
     |   7.8474110922904d-01,-1.6136506593415d-01,-9.5726922618439d-01,
     |  -1.0498716738729d+00,-3.3542081891371d-01, 6.2739030896923d-01,
     |   1.0057356690416d+00, 4.4574327928661d-01,-5.2573102766674d-01,
     |  -9.5151306090915d-01,-3.9800848891300d-01, 5.6002150425046d-01,
     |   9.0691281831312d-01, 2.6950814015924d-01,-6.5563722771654d-01,
     |  -8.4829451278043d-01,-9.5081183573954d-02, 7.6184547088857d-01,
     |   7.6184547088857d-01,-9.5081183573951d-02,-8.4829451278043d-01,
     |  -6.5563722771654d-01, 2.6950814015924d-01, 9.0691281831312d-01,
     |   5.6002150425047d-01,-3.9800848891300d-01,-9.5151306090915d-01,
     |  -5.2573102766674d-01, 4.4574327928661d-01, 1.0057356690416d+00,
     |   6.2739030896923d-01,-3.3542081891371d-01,-1.0498716738729d+00,
     |  -9.5726922618440d-01,-1.6136506593415d-01, 7.8474110922904d-01,
     |   1.3665700389834d+00, 1.4206617466296d+00, 1.1065529875858d+00,
     |   6.8807966658839d-01, 3.4934977536771d-01, 1.4554303544101d-01,
     |   4.9466479932496d-02, 1.3514984341978d-02, 2.8973794413704d-03,
     |   4.7019392021465d-04, 5.4816185785505d-05, 4.2497930978933d-06,
     |   1.9469434474749d-07, 4.3518488027542d-09, 3.3807173443245d-11,
     |   4.5814961948439d-14, 1.8206978453042d-18, 5.4433481315561d-28/
      data (pmn(lat,21,32), lat = 1,72)/
     |   7.1329330251774d-30, 7.1754201543430d-20, 3.0245057989222d-15,
     |   3.1485428971442d-12, 5.2654423889027d-10, 2.9177417254421d-08,
     |   7.6518177485594d-07, 1.1617586138672d-05, 1.1566445190747d-04,
     |   8.1947818484890d-04, 4.3692503242786d-03, 1.8229530961887d-02,
     |   6.1165302115010d-02, 1.6810512707894d-01, 3.8254290138597d-01,
     |   7.2299120430958d-01, 1.1271821098546d+00, 1.4159964389214d+00,
     |   1.3454756092891d+00, 7.7463393298973d-01,-1.4187990744633d-01,
     |  -9.2944830328304d-01,-1.0662911411803d+00,-4.2007279469942d-01,
     |   5.3298097350072d-01, 1.0092740706757d+00, 5.8530931314504d-01,
     |  -3.6295682727032d-01,-9.4663907976845d-01,-5.9894628820182d-01,
     |   3.3831920418622d-01, 9.1982017199078d-01, 5.4910469310239d-01,
     |  -3.8957490495376d-01,-9.1350025473237d-01,-4.7062707953519d-01,
     |   4.7062707953518d-01, 9.1350025473237d-01, 3.8957490495376d-01,
     |  -5.4910469310239d-01,-9.1982017199078d-01,-3.3831920418622d-01,
     |   5.9894628820182d-01, 9.4663907976845d-01, 3.6295682727033d-01,
     |  -5.8530931314504d-01,-1.0092740706757d+00,-5.3298097350072d-01,
     |   4.2007279469941d-01, 1.0662911411803d+00, 9.2944830328304d-01,
     |   1.4187990744634d-01,-7.7463393298973d-01,-1.3454756092891d+00,
     |  -1.4159964389214d+00,-1.1271821098546d+00,-7.2299120430959d-01,
     |  -3.8254290138596d-01,-1.6810512707894d-01,-6.1165302115010d-02,
     |  -1.8229530961887d-02,-4.3692503242786d-03,-8.1947818484891d-04,
     |  -1.1566445190747d-04,-1.1617586138672d-05,-7.6518177485594d-07,
     |  -2.9177417254422d-08,-5.2654423889027d-10,-3.1485428971442d-12,
     |  -3.0245057989222d-15,-7.1754201543430d-20,-7.1329330251774d-30/
      data (pmn(lat,22,32), lat = 1,72)/
     |   8.6222613348224d-32, 2.6081048366579d-21, 1.8407780698728d-16,
     |   2.7017830114502d-13, 5.8650972953664d-11, 4.0210905535286d-09,
     |   1.2651856953229d-07, 2.2570552601592d-06, 2.6023493982659d-05,
     |   2.1138568434285d-04, 1.2835782790492d-03, 6.0758299341913d-03,
     |   2.3101434941337d-02, 7.2065643768191d-02, 1.8708445677959d-01,
     |   4.0737486084249d-01, 7.4491187713785d-01, 1.1349659293048d+00,
     |   1.4075969577898d+00, 1.3376587282232d+00, 7.9430296614720d-01,
     |  -8.8060919534420d-02,-8.8071441637321d-01,-1.0884673474159d+00,
     |  -5.3679160103283d-01, 3.9647669400363d-01, 9.8781770955387d-01,
     |   7.4134338281832d-01,-1.4192103646904d-01,-8.8032719044227d-01,
     |  -7.9576397818639d-01, 3.6424202222870d-02, 8.2406405814170d-01,
     |   8.0424809309927d-01,-4.7944351876092d-03,-8.0601599702124d-01,
     |  -8.0601599702124d-01,-4.7944351876121d-03, 8.0424809309927d-01,
     |   8.2406405814170d-01, 3.6424202222873d-02,-7.9576397818640d-01,
     |  -8.8032719044227d-01,-1.4192103646905d-01, 7.4134338281832d-01,
     |   9.8781770955387d-01, 3.9647669400363d-01,-5.3679160103282d-01,
     |  -1.0884673474159d+00,-8.8071441637321d-01,-8.8060919534420d-02,
     |   7.9430296614719d-01, 1.3376587282232d+00, 1.4075969577898d+00,
     |   1.1349659293048d+00, 7.4491187713785d-01, 4.0737486084249d-01,
     |   1.8708445677959d-01, 7.2065643768191d-02, 2.3101434941337d-02,
     |   6.0758299341913d-03, 1.2835782790492d-03, 2.1138568434285d-04,
     |   2.6023493982659d-05, 2.2570552601593d-06, 1.2651856953229d-07,
     |   4.0210905535288d-09, 5.8650972953664d-11, 2.7017830114502d-13,
     |   1.8407780698728d-16, 2.6081048366579d-21, 8.6222613348224d-32/
      data (pmn(lat,23,32), lat = 1,72)/
     |   9.5928618811688d-34, 8.7237731737089d-23, 1.0306306898463d-17,
     |   2.1316684106341d-14, 6.0024810312749d-12, 5.0868065400656d-10,
     |   1.9178927772223d-08, 4.0141213939942d-07, 5.3497183968522d-06,
     |   4.9703303179837d-05, 3.4270119507377d-04, 1.8334364494796d-03,
     |   7.8607794029864d-03, 2.7651800998106d-02, 8.1155472169940d-02,
     |   2.0094728557551d-01, 4.2223091185337d-01, 7.5283775028692d-01,
     |   1.1298390731558d+00, 1.3958985258579d+00, 1.3434935540033d+00,
     |   8.4476894549298d-01, 4.0461207550293d-03,-8.0265201372611d-01,
     |  -1.1064097138578d+00,-6.8203909214991d-01, 2.0720476838349d-01,
     |   9.1808080118463d-01, 8.9339056407304d-01, 1.4103402103517d-01,
     |  -7.1692287322074d-01,-9.4231191734393d-01,-3.3268167684705d-01,
     |   5.7010989070940d-01, 9.4874773856695d-01, 4.5609324894271d-01,
     |  -4.5609324894271d-01,-9.4874773856694d-01,-5.7010989070941d-01,
     |   3.3268167684705d-01, 9.4231191734393d-01, 7.1692287322074d-01,
     |  -1.4103402103517d-01,-8.9339056407303d-01,-9.1808080118463d-01,
     |  -2.0720476838350d-01, 6.8203909214991d-01, 1.1064097138578d+00,
     |   8.0265201372611d-01,-4.0461207550293d-03,-8.4476894549298d-01,
     |  -1.3434935540033d+00,-1.3958985258579d+00,-1.1298390731558d+00,
     |  -7.5283775028692d-01,-4.2223091185338d-01,-2.0094728557551d-01,
     |  -8.1155472169940d-02,-2.7651800998106d-02,-7.8607794029865d-03,
     |  -1.8334364494796d-03,-3.4270119507377d-04,-4.9703303179838d-05,
     |  -5.3497183968523d-06,-4.0141213939942d-07,-1.9178927772223d-08,
     |  -5.0868065400658d-10,-6.0024810312749d-12,-2.1316684106341d-14,
     |  -1.0306306898463d-17,-8.7237731737089d-23,-9.5928618811688d-34/
      data (pmn(lat,24,32), lat = 1,72)/
     |   9.7907915735631d-36, 2.6764716363499d-24, 5.2912046753287d-19,
     |   1.5414887049435d-15, 5.6268370520311d-13, 5.8893470845110d-11,
     |   2.6580409180773d-09, 6.5183929172518d-08, 1.0025306880366d-06,
     |   1.0632379766818d-05, 8.3036636355551d-05, 5.0054342021076d-04,
     |   2.4104670047145d-03, 9.5130614933318d-03, 3.1352287124630d-02,
     |   8.7459842105206d-02, 2.0835346249996d-01, 4.2575695708823d-01,
     |   7.4574187225624d-01, 1.1109581712421d+00, 1.3796137863064d+00,
     |   1.3611651420642d+00, 9.2556783404241d-01, 1.3906523895661d-01,
     |  -6.8298566679697d-01,-1.1033456214744d+00,-8.4510026422412d-01,
     |  -4.2896629183353d-02, 7.6964752102176d-01, 1.0038535090901d+00,
     |   4.7182939364957d-01,-4.2211008912407d-01,-9.6576752539334d-01,
     |  -7.1221464040896d-01, 1.3242408030288d-01, 8.6238709296273d-01,
     |   8.6238709296273d-01, 1.3242408030288d-01,-7.1221464040896d-01,
     |  -9.6576752539334d-01,-4.2211008912407d-01, 4.7182939364957d-01,
     |   1.0038535090901d+00, 7.6964752102176d-01,-4.2896629183350d-02,
     |  -8.4510026422412d-01,-1.1033456214744d+00,-6.8298566679698d-01,
     |   1.3906523895660d-01, 9.2556783404241d-01, 1.3611651420642d+00,
     |   1.3796137863064d+00, 1.1109581712421d+00, 7.4574187225625d-01,
     |   4.2575695708823d-01, 2.0835346249996d-01, 8.7459842105207d-02,
     |   3.1352287124630d-02, 9.5130614933317d-03, 2.4104670047145d-03,
     |   5.0054342021076d-04, 8.3036636355551d-05, 1.0632379766818d-05,
     |   1.0025306880367d-06, 6.5183929172519d-08, 2.6580409180773d-09,
     |   5.8893470845113d-11, 5.6268370520311d-13, 1.5414887049435d-15,
     |   5.2912046753287d-19, 2.6764716363499d-24, 9.7907915735631d-36/
      data (pmn(lat,25,32), lat = 1,72)/
     |   9.1247044257875d-38, 7.4971471957608d-26, 2.4795172748306d-20,
     |   1.0170617122409d-16, 4.8099847617092d-14, 6.2132943627448d-12,
     |   3.3537976084571d-10, 9.6258380773272d-09, 1.7061233291879d-07,
     |   2.0619791518345d-06, 1.8202360091393d-05, 1.2331193484144d-04,
     |   6.6486451489501d-04, 2.9319413523841d-03, 1.0794251562889d-02,
     |   3.3690605242776d-02, 9.0139634393391d-02, 2.0824551719148d-01,
     |   4.1687516201204d-01, 7.2247273530234d-01, 1.0764642735176d+00,
     |   1.3552990395992d+00, 1.3858898258060d+00, 1.0335253571645d+00,
     |   3.2093497189399d-01,-5.0601544433010d-01,-1.0536908949304d+00,
     |  -1.0026890562846d+00,-3.5197279904469d-01, 5.0942923459224d-01,
     |   1.0132342455428d+00, 8.0193427691287d-01, 1.5626224160731d-02,
     |  -7.7469434887359d-01,-9.7792279117179d-01,-4.3719989985029d-01,
     |   4.3719989985029d-01, 9.7792279117179d-01, 7.7469434887359d-01,
     |  -1.5626224160729d-02,-8.0193427691287d-01,-1.0132342455428d+00,
     |  -5.0942923459224d-01, 3.5197279904468d-01, 1.0026890562846d+00,
     |   1.0536908949304d+00, 5.0601544433010d-01,-3.2093497189399d-01,
     |  -1.0335253571645d+00,-1.3858898258060d+00,-1.3552990395992d+00,
     |  -1.0764642735176d+00,-7.2247273530235d-01,-4.1687516201205d-01,
     |  -2.0824551719148d-01,-9.0139634393391d-02,-3.3690605242776d-02,
     |  -1.0794251562889d-02,-2.9319413523841d-03,-6.6486451489502d-04,
     |  -1.2331193484144d-04,-1.8202360091393d-05,-2.0619791518346d-06,
     |  -1.7061233291879d-07,-9.6258380773273d-09,-3.3537976084571d-10,
     |  -6.2132943627451d-12,-4.8099847617092d-14,-1.0170617122409d-16,
     |  -2.4795172748306d-20,-7.4971471957608d-26,-9.1247044257875d-38/
      data (pmn(lat,26,32), lat = 1,72)/
     |   7.7154425082487d-40, 1.9051117861082d-27, 1.0538275292511d-21,
     |   6.0839996611991d-18, 3.7260224145645d-15, 5.9364034175160d-13,
     |   3.8292369922128d-11, 1.2850183920376d-09, 2.6216463428137d-08,
     |   3.6054116677680d-07, 3.5911375733935d-06, 2.7281962892941d-05,
     |   1.6425521476370d-04, 8.0670285985312d-04, 3.3039840338940d-03,
     |   1.1476747319859d-02, 3.4244881412768d-02, 8.8594244752965d-02,
     |   1.9994940403474d-01, 3.9484987569595d-01, 6.8176614891000d-01,
     |   1.0233923789753d+00, 1.3169783483007d+00, 1.4088880821987d+00,
     |   1.1607334304359d+00, 5.5009241256667d-01,-2.5486320075264d-01,
     |  -9.2211989765773d-01,-1.1121453018487d+00,-6.9541335739621d-01,
     |   1.1520534649221d-01, 8.4317657285131d-01, 1.0294779632245d+00,
     |   5.4426328925405d-01,-2.9939424310531d-01,-9.3762080548785d-01,
     |  -9.3762080548785d-01,-2.9939424310531d-01, 5.4426328925405d-01,
     |   1.0294779632245d+00, 8.4317657285131d-01, 1.1520534649220d-01,
     |  -6.9541335739621d-01,-1.1121453018487d+00,-9.2211989765774d-01,
     |  -2.5486320075264d-01, 5.5009241256667d-01, 1.1607334304359d+00,
     |   1.4088880821987d+00, 1.3169783483007d+00, 1.0233923789753d+00,
     |   6.8176614891001d-01, 3.9484987569595d-01, 1.9994940403474d-01,
     |   8.8594244752965d-02, 3.4244881412768d-02, 1.1476747319859d-02,
     |   3.3039840338939d-03, 8.0670285985312d-04, 1.6425521476370d-04,
     |   2.7281962892941d-05, 3.5911375733935d-06, 3.6054116677681d-07,
     |   2.6216463428137d-08, 1.2850183920376d-09, 3.8292369922128d-11,
     |   5.9364034175163d-13, 3.7260224145645d-15, 6.0839996611991d-18,
     |   1.0538275292511d-21, 1.9051117861082d-27, 7.7154425082487d-40/
      data (pmn(lat,27,32), lat = 1,72)/
     |   5.8660467040537d-42, 4.3525413584512d-29, 4.0260550412004d-23,
     |   3.2704002443527d-19, 2.5925568327392d-16, 5.0916875121938d-14,
     |   3.9221007769802d-12, 1.5375732835402d-10, 3.6069303231604d-09,
     |   5.6373558410205d-08, 6.3259220676411d-07, 5.3794025315384d-06,
     |   3.6084748408380d-05, 1.9683659584644d-04, 8.9382790148054d-04,
     |   3.4408451890980d-03, 1.1388559377181d-02, 3.2761310520135d-02,
     |   8.2568323157671d-02, 1.8330315177448d-01, 3.5944702632802d-01,
     |   6.2245190088745d-01, 9.4786041716333d-01, 1.2560066138714d+00,
     |   1.4162693148542d+00, 1.2916504214742d+00, 8.1849404924215d-01,
     |   8.2742891249735d-02,-6.6644630973657d-01,-1.1057641928761d+00,
     |  -1.0071914875777d+00,-3.9528160601534d-01, 4.2118957758543d-01,
     |   9.9438264783363d-01, 9.9305321832568d-01, 4.1166698113795d-01,
     |  -4.1166698113795d-01,-9.9305321832568d-01,-9.9438264783363d-01,
     |  -4.2118957758544d-01, 3.9528160601534d-01, 1.0071914875777d+00,
     |   1.1057641928761d+00, 6.6644630973657d-01,-8.2742891249732d-02,
     |  -8.1849404924215d-01,-1.2916504214742d+00,-1.4162693148542d+00,
     |  -1.2560066138714d+00,-9.4786041716333d-01,-6.2245190088745d-01,
     |  -3.5944702632803d-01,-1.8330315177449d-01,-8.2568323157672d-02,
     |  -3.2761310520135d-02,-1.1388559377181d-02,-3.4408451890981d-03,
     |  -8.9382790148053d-04,-1.9683659584644d-04,-3.6084748408381d-05,
     |  -5.3794025315384d-06,-6.3259220676411d-07,-5.6373558410206d-08,
     |  -3.6069303231605d-09,-1.5375732835402d-10,-3.9221007769802d-12,
     |  -5.0916875121941d-14,-2.5925568327392d-16,-3.2704002443527d-19,
     |  -4.0260550412004d-23,-4.3525413584512d-29,-5.8660467040537d-42/
      data (pmn(lat,28,32), lat = 1,72)/
     |   3.9590404789008d-44, 8.8264304176566d-31, 1.3649879248608d-24,
     |   1.5596538757881d-20, 1.5997724352861d-17, 3.8710590938519d-15,
     |   3.5586371826305d-13, 1.6285048804750d-11, 4.3886153849313d-10,
     |   7.7864876011367d-09, 9.8307455957625d-08, 9.3427728922430d-07,
     |   6.9692600144094d-06, 4.2127088906779d-05, 2.1150610814457d-04,
     |   8.9924136917590d-04, 3.2873867171285d-03, 1.0458495169917d-02,
     |   2.9227838063638d-02, 7.2260097677349d-02, 1.5882503631661d-01,
     |   3.1122762486787d-01, 5.4395429145316d-01, 8.4574650508199d-01,
     |   1.1615419252023d+00, 1.3883272808294d+00, 1.3996764103135d+00,
     |   1.1019964074311d+00, 5.0278980773893d-01,-2.4942240441570d-01,
     |  -8.9352562869324d-01,-1.1610570580363d+00,-9.1618786807370d-01,
     |  -2.5169652270025d-01, 5.2815015298235d-01, 1.0465218917450d+00,
     |   1.0465218917450d+00, 5.2815015298235d-01,-2.5169652270024d-01,
     |  -9.1618786807370d-01,-1.1610570580363d+00,-8.9352562869324d-01,
     |  -2.4942240441570d-01, 5.0278980773892d-01, 1.1019964074311d+00,
     |   1.3996764103135d+00, 1.3883272808294d+00, 1.1615419252023d+00,
     |   8.4574650508200d-01, 5.4395429145316d-01, 3.1122762486787d-01,
     |   1.5882503631662d-01, 7.2260097677350d-02, 2.9227838063638d-02,
     |   1.0458495169917d-02, 3.2873867171285d-03, 8.9924136917591d-04,
     |   2.1150610814457d-04, 4.2127088906779d-05, 6.9692600144095d-06,
     |   9.3427728922430d-07, 9.8307455957625d-08, 7.7864876011369d-09,
     |   4.3886153849314d-10, 1.6285048804750d-11, 3.5586371826305d-13,
     |   3.8710590938521d-15, 1.5997724352861d-17, 1.5596538757881d-20,
     |   1.3649879248608d-24, 8.8264304176566d-31, 3.9590404789008d-44/
      data (pmn(lat,29,32), lat = 1,72)/
     |   2.3266132928111d-46, 1.5584079269237d-32, 4.0286459392485d-26,
     |   6.4733038364724d-22, 8.5883066780377d-19, 2.5593099333534d-16,
     |   2.8062854511886d-14, 1.4980655431776d-12, 4.6339514482928d-11,
     |   9.3243633202884d-10, 1.3229948158465d-08, 1.4032342909366d-07,
     |   1.1621258943232d-06, 7.7691637482878d-06, 4.3026213073970d-05,
     |   2.0146465458476d-04, 8.1066217772405d-04, 2.8400055753242d-03,
     |   8.7532733826041d-03, 2.3932586536464d-02, 5.8419815982116d-02,
     |   1.2791542683467d-01, 2.5199320484190d-01, 4.4718004848783d-01,
     |   7.1413493603638d-01, 1.0222595317392d+00, 1.3003501958504d+00,
     |   1.4445925600497d+00, 1.3508493001000d+00, 9.6547474118537d-01,
     |   3.3295899695216d-01,-3.8965744090874d-01,-9.7257110328978d-01,
     |  -1.2014255365604d+00,-9.7702677159977d-01,-3.7460458596609d-01,
     |   3.7460458596609d-01, 9.7702677159977d-01, 1.2014255365604d+00,
     |   9.7257110328978d-01, 3.8965744090875d-01,-3.3295899695216d-01,
     |  -9.6547474118537d-01,-1.3508493001000d+00,-1.4445925600497d+00,
     |  -1.3003501958504d+00,-1.0222595317392d+00,-7.1413493603638d-01,
     |  -4.4718004848783d-01,-2.5199320484190d-01,-1.2791542683467d-01,
     |  -5.8419815982117d-02,-2.3932586536464d-02,-8.7532733826041d-03,
     |  -2.8400055753242d-03,-8.1066217772406d-04,-2.0146465458476d-04,
     |  -4.3026213073969d-05,-7.7691637482877d-06,-1.1621258943232d-06,
     |  -1.4032342909366d-07,-1.3229948158465d-08,-9.3243633202886d-10,
     |  -4.6339514482929d-11,-1.4980655431776d-12,-2.8062854511886d-14,
     |  -2.5593099333535d-16,-8.5883066780377d-19,-6.4733038364724d-22,
     |  -4.0286459392485d-26,-1.5584079269237d-32,-2.3266132928111d-46/
      data (pmn(lat,30,32), lat = 1,72)/
     |   1.1539652257556d-48, 2.3220895017228d-34, 1.0032879208032d-27,
     |   2.2665229551124d-23, 3.8882782085249d-20, 1.4264017136830d-17,
     |   1.8646153519017d-15, 1.1604296099171d-13, 4.1172441128107d-12,
     |   9.3875837952689d-11, 1.4953565149301d-09, 1.7679829629514d-08,
     |   1.6232971902327d-07, 1.1982241573073d-06, 7.3051746690000d-06,
     |   3.7581746865035d-05, 1.6597482507731d-04, 6.3807461890192d-04,
     |   2.1596633689639d-03, 6.4952548892568d-03, 1.7488509132354d-02,
     |   4.2408470816487d-02, 9.3047445836483d-02, 1.8533534584296d-01,
     |   3.3580942486297d-01, 5.5379421469556d-01, 8.3017568124170d-01,
     |   1.1269099426656d+00, 1.3742419872840d+00, 1.4824480247638d+00,
     |   1.3698923152147d+00, 1.0001953083871d+00, 4.1274691452117d-01,
     |  -2.7128758518181d-01,-8.7725453618556d-01,-1.2333961499938d+00,
     |  -1.2333961499938d+00,-8.7725453618556d-01,-2.7128758518181d-01,
     |   4.1274691452117d-01, 1.0001953083870d+00, 1.3698923152147d+00,
     |   1.4824480247638d+00, 1.3742419872840d+00, 1.1269099426656d+00,
     |   8.3017568124170d-01, 5.5379421469557d-01, 3.3580942486297d-01,
     |   1.8533534584296d-01, 9.3047445836483d-02, 4.2408470816487d-02,
     |   1.7488509132354d-02, 6.4952548892568d-03, 2.1596633689640d-03,
     |   6.3807461890192d-04, 1.6597482507731d-04, 3.7581746865035d-05,
     |   7.3051746689999d-06, 1.1982241573073d-06, 1.6232971902327d-07,
     |   1.7679829629514d-08, 1.4953565149301d-09, 9.3875837952691d-11,
     |   4.1172441128108d-12, 1.1604296099171d-13, 1.8646153519017d-15,
     |   1.4264017136831d-17, 3.8882782085249d-20, 2.2665229551124d-23,
     |   1.0032879208032d-27, 2.3220895017228d-34, 1.1539652257556d-48/
      data (pmn(lat,31,32), lat = 1,72)/
     |   4.5587516245631d-51, 2.7557004908340d-36, 1.9897015953627d-29,
     |   6.3182940952349d-25, 1.4011671278658d-21, 6.3253748829235d-19,
     |   9.8532001251406d-17, 7.1449887510912d-15, 2.9058620358251d-13,
     |   7.5018570925985d-12, 1.3403560880253d-10, 1.7646386033832d-09,
     |   1.7940513215141d-08, 1.4600338168069d-07, 9.7824351183123d-07,
     |   5.5181965260093d-06, 2.6683617076526d-05, 1.1224744998754d-04,
     |   4.1576421282495d-04, 1.3696404461677d-03, 4.0463962635751d-03,
     |   1.0795287888281d-02, 2.6156841996605d-02, 5.7829289770376d-02,
     |   1.1709423593795d-01, 2.1775588982640d-01, 3.7262901268167d-01,
     |   5.8728544345164d-01, 8.5224349609976d-01, 1.1366025306641d+00,
     |   1.3872351302955d+00, 1.5368672394283d+00, 1.5212305873928d+00,
     |   1.3009039304944d+00, 8.7973230476996d-01, 3.1128428419425d-01,
     |  -3.1128428419425d-01,-8.7973230476996d-01,-1.3009039304944d+00,
     |  -1.5212305873928d+00,-1.5368672394283d+00,-1.3872351302955d+00,
     |  -1.1366025306641d+00,-8.5224349609976d-01,-5.8728544345164d-01,
     |  -3.7262901268167d-01,-2.1775588982641d-01,-1.1709423593795d-01,
     |  -5.7829289770376d-02,-2.6156841996605d-02,-1.0795287888281d-02,
     |  -4.0463962635752d-03,-1.3696404461677d-03,-4.1576421282495d-04,
     |  -1.1224744998754d-04,-2.6683617076526d-05,-5.5181965260094d-06,
     |  -9.7824351183121d-07,-1.4600338168069d-07,-1.7940513215141d-08,
     |  -1.7646386033832d-09,-1.3403560880253d-10,-7.5018570925986d-12,
     |  -2.9058620358252d-13,-7.1449887510913d-15,-9.8532001251406d-17,
     |  -6.3253748829239d-19,-1.4011671278658d-21,-6.3182940952349d-25,
     |  -1.9897015953627d-29,-2.7557004908340d-36,-4.5587516245631d-51/
      data (pmn(lat,32,32), lat = 1,72)/
     |   1.2434039288507d-53, 2.2577269081364d-38, 2.7238470578347d-31,
     |   1.2155980915526d-26, 3.4838683812293d-23, 1.9347617333643d-20,
     |   3.5899324179260d-18, 3.0317460763610d-16, 1.4125349292893d-14,
     |   4.1261201524862d-13, 8.2623809257862d-12, 1.2101423617783d-10,
     |   1.3608213333095d-09, 1.2194542587877d-08, 8.9659727390745d-08,
     |   5.5360261754022d-07, 2.9251130154531d-06, 1.3431694620279d-05,
     |   5.4289120347688d-05, 1.9522195064017d-04, 6.3021315676896d-04,
     |   1.8403643702397d-03, 4.8933100581562d-03, 1.1912465012311d-02,
     |   2.6679326062168d-02, 5.5195657896202d-02, 1.0585798137786d-01,
     |   1.8877525155890d-01, 3.1382854753149d-01, 4.8743832811502d-01,
     |   7.0864525739803d-01, 9.6579417086656d-01, 1.2354492287335d+00,
     |   1.4848086243919d+00, 1.6777651557140d+00, 1.7832445969295d+00,
     |   1.7832445969295d+00, 1.6777651557140d+00, 1.4848086243919d+00,
     |   1.2354492287335d+00, 9.6579417086656d-01, 7.0864525739803d-01,
     |   4.8743832811503d-01, 3.1382854753149d-01, 1.8877525155890d-01,
     |   1.0585798137786d-01, 5.5195657896202d-02, 2.6679326062168d-02,
     |   1.1912465012311d-02, 4.8933100581562d-03, 1.8403643702397d-03,
     |   6.3021315676897d-04, 1.9522195064017d-04, 5.4289120347688d-05,
     |   1.3431694620279d-05, 2.9251130154531d-06, 5.5360261754022d-07,
     |   8.9659727390744d-08, 1.2194542587877d-08, 1.3608213333095d-09,
     |   1.2101423617783d-10, 8.2623809257862d-12, 4.1261201524862d-13,
     |   1.4125349292893d-14, 3.0317460763611d-16, 3.5899324179260d-18,
     |   1.9347617333644d-20, 3.4838683812293d-23, 1.2155980915526d-26,
     |   2.7238470578347d-31, 2.2577269081364d-38, 1.2434039288507d-53/
      data (pmn(lat, 0,33), lat = 1,72)/
     |   5.0405819218120d+00, 6.6267362913803d-01,-2.2962928834987d+00,
     |  -8.0532312309110d-01, 1.5748399708939d+00, 9.4344635523118d-01,
     |  -1.1314126089800d+00,-1.0370609320741d+00, 7.8478805555309d-01,
     |   1.0869013019407d+00,-4.8674048559913d-01,-1.0955186729828d+00,
     |   2.2125049622807d-01, 1.0656826622587d+00, 1.6588318401778d-02,
     |  -1.0005435004694d+00,-2.2716462969348d-01, 9.0379909786300d-01,
     |   4.0897566989741d-01,-7.7975756441646d-01,-5.5987103547627d-01,
     |   6.3331809317902d-01, 6.7772426094455d-01,-4.6989506549861d-01,
     |  -7.6083058683666d-01, 2.9530293220063d-01, 8.0815432500012d-01,
     |  -1.1561443834172d-01,-8.1948158815659d-01,-6.2998031866021d-02,
     |   7.9550562511572d-01, 2.3442974460735d-01,-7.3785927112077d-01,
     |  -3.9281218859636d-01, 6.4910321155925d-01, 5.3267617742519d-01,
     |  -5.3267617742518d-01,-6.4910321155925d-01, 3.9281218859636d-01,
     |   7.3785927112077d-01,-2.3442974460735d-01,-7.9550562511572d-01,
     |   6.2998031866017d-02, 8.1948158815659d-01, 1.1561443834172d-01,
     |  -8.0815432500012d-01,-2.9530293220063d-01, 7.6083058683666d-01,
     |   4.6989506549861d-01,-6.7772426094455d-01,-6.3331809317902d-01,
     |   5.5987103547626d-01, 7.7975756441646d-01,-4.0897566989740d-01,
     |  -9.0379909786300d-01, 2.2716462969347d-01, 1.0005435004694d+00,
     |  -1.6588318401787d-02,-1.0656826622587d+00,-2.2125049622809d-01,
     |   1.0955186729828d+00, 4.8674048559913d-01,-1.0869013019407d+00,
     |  -7.8478805555310d-01, 1.0370609320741d+00, 1.1314126089800d+00,
     |  -9.4344635523116d-01,-1.5748399708939d+00, 8.0532312309110d-01,
     |   2.2962928834987d+00,-6.6267362913803d-01,-5.0405819218120d+00/
      data (pmn(lat, 1,33), lat = 1,72)/
     |   1.9768449559240d+00, 3.2252789345456d+00, 4.2281962865170d-01,
     |  -1.9616546262896d+00,-7.6475315951987d-01, 1.3954100667718d+00,
     |   9.3959200553417d-01,-9.9684931071187d-01,-1.0382401877303d+00,
     |   6.6840476307381d-01, 1.0822219450275d+00,-3.8037111578014d-01,
     |  -1.0803519820907d+00, 1.2280092636895d-01, 1.0380914145973d+00,
     |   1.0680359561269d-01,-9.6008256161929d-01,-3.0781895411274d-01,
     |   8.5101322403975d-01, 4.7837385037872d-01,-7.1592364196885d-01,
     |  -6.1629452344509d-01, 5.6028205345457d-01, 7.1963918651566d-01,
     |  -3.8994695994560d-01,-7.8702308022866d-01, 2.1106719470991d-01,
     |   8.1782113956501d-01,-2.9945978805302d-02,-8.1228906429241d-01,
     |  -1.4711516464671d-01, 7.7162351075185d-01, 3.1398144519733d-01,
     |  -6.9797302766682d-01,-4.6484993129476d-01, 5.9440722771456d-01,
     |   5.9440722771456d-01,-4.6484993129476d-01,-6.9797302766682d-01,
     |   3.1398144519733d-01, 7.7162351075185d-01,-1.4711516464671d-01,
     |  -8.1228906429242d-01,-2.9945978805311d-02, 8.1782113956502d-01,
     |   2.1106719470991d-01,-7.8702308022865d-01,-3.8994695994560d-01,
     |   7.1963918651565d-01, 5.6028205345457d-01,-6.1629452344509d-01,
     |  -7.1592364196887d-01, 4.7837385037872d-01, 8.5101322403976d-01,
     |  -3.0781895411274d-01,-9.6008256161929d-01, 1.0680359561268d-01,
     |   1.0380914145973d+00, 1.2280092636895d-01,-1.0803519820907d+00,
     |  -3.8037111578014d-01, 1.0822219450275d+00, 6.6840476307382d-01,
     |  -1.0382401877303d+00,-9.9684931071188d-01, 9.3959200553417d-01,
     |   1.3954100667718d+00,-7.6475315951987d-01,-1.9616546262896d+00,
     |   4.2281962865170d-01, 3.2252789345456d+00, 1.9768449559240d+00/
      data (pmn(lat, 2,33), lat = 1,72)/
     |   3.6915705966807d-01, 2.2774902180701d+00, 2.5290654841130d+00,
     |   4.4377941927611d-02,-1.8060086544545d+00,-6.0349458582802d-01,
     |   1.3250689449136d+00, 8.6248965280958d-01,-9.4504131930742d-01,
     |  -9.9708979676961d-01, 6.1832307449257d-01, 1.0550622850814d+00,
     |  -3.2784511030863d-01,-1.0556505111929d+00, 6.8005798609463d-02,
     |   1.0093891682244d+00, 1.6194268160831d-01,-9.2382210139906d-01,
     |  -3.6065494290739d-01, 8.0552473712074d-01, 5.2603240870735d-01,
     |  -6.6088864779431d-01,-6.5595630495242d-01, 4.9641151383404d-01,
     |   7.4872470089729d-01,-3.1876089501132d-01,-8.0332541859650d-01,
     |   1.3472374129109d-01, 8.1960544952051d-01, 4.8905098627471d-02,
     |  -7.9836692406858d-01,-2.2546645291909d-01, 7.4140583298988d-01,
     |   3.8859456498372d-01,-6.5150331324300d-01,-5.3237646256010d-01,
     |   5.3237646256010d-01, 6.5150331324300d-01,-3.8859456498372d-01,
     |  -7.4140583298988d-01, 2.2546645291909d-01, 7.9836692406858d-01,
     |  -4.8905098627468d-02,-8.1960544952051d-01,-1.3472374129109d-01,
     |   8.0332541859650d-01, 3.1876089501132d-01,-7.4872470089729d-01,
     |  -4.9641151383404d-01, 6.5595630495242d-01, 6.6088864779431d-01,
     |  -5.2603240870733d-01,-8.0552473712074d-01, 3.6065494290739d-01,
     |   9.2382210139906d-01,-1.6194268160830d-01,-1.0093891682244d+00,
     |  -6.8005798609454d-02, 1.0556505111929d+00, 3.2784511030864d-01,
     |  -1.0550622850814d+00,-6.1832307449257d-01, 9.9708979676960d-01,
     |   9.4504131930743d-01,-8.6248965280957d-01,-1.3250689449136d+00,
     |   6.0349458582800d-01, 1.8060086544545d+00,-4.4377941927611d-02,
     |  -2.5290654841130d+00,-2.2774902180701d+00,-3.6915705966807d-01/
      data (pmn(lat, 3,33), lat = 1,72)/
     |   4.5351176117361d-02, 9.2953722908651d-01, 2.3414747220886d+00,
     |   1.9996904977734d+00,-3.2101869135593d-01,-1.6932130654529d+00,
     |  -3.9693790986675d-01, 1.3028631221930d+00, 7.4911825781450d-01,
     |  -9.4093234973841d-01,-9.3402938096173d-01, 6.1132109124505d-01,
     |   1.0175958853331d+00,-3.1219219919590d-01,-1.0288447496955d+00,
     |   4.3594977922838d-02, 9.8391223914753d-01, 1.9281958085629d-01,
     |  -8.9387636619420d-01,-3.9464511952659d-01, 7.6775669822804d-01,
     |   5.5937548280813d-01,-6.1376543419556d-01,-6.8485938398534d-01,
     |   4.3982881172151d-01, 7.6961016015782d-01,-2.5376870057326d-01,
     |  -8.1301229998784d-01, 6.3312616481604d-02, 8.1545027092500d-01,
     |   1.2398688409978d-01,-7.7837507864768d-01,-3.0088006687195d-01,
     |   7.0431852134838d-01, 4.6056927277165d-01,-5.9686244364463d-01,
     |  -5.9686244364464d-01, 4.6056927277165d-01, 7.0431852134838d-01,
     |  -3.0088006687195d-01,-7.7837507864768d-01, 1.2398688409978d-01,
     |   8.1545027092500d-01, 6.3312616481613d-02,-8.1301229998784d-01,
     |  -2.5376870057326d-01, 7.6961016015781d-01, 4.3982881172151d-01,
     |  -6.8485938398534d-01,-6.1376543419556d-01, 5.5937548280813d-01,
     |   7.6775669822805d-01,-3.9464511952658d-01,-8.9387636619421d-01,
     |   1.9281958085628d-01, 9.8391223914753d-01, 4.3594977922844d-02,
     |  -1.0288447496955d+00,-3.1219219919590d-01, 1.0175958853331d+00,
     |   6.1132109124505d-01,-9.3402938096173d-01,-9.4093234973842d-01,
     |   7.4911825781449d-01, 1.3028631221930d+00,-3.9693790986675d-01,
     |  -1.6932130654529d+00,-3.2101869135593d-01, 1.999690497773