#include <defs.h>
      module he_coefs_sres
!
! This software is part of the NCAR TIE-GCM.  Use is governed by the 
! Open Source Academic Research License Agreement contained in the file 
! tiegcmlicense.txt.
!
! Associated Legendre functions, normalized by: 
! (-1)^M * sqrt((N+1/2)*(N-M)!/(N+M)!) for Helium at 5.0-deg resolution, 
! obtained from Eric Sutton (eric.sutton.5@us.af.mil) on MMM DD, YYYY.
!
      integer :: lat
!
#if (NLAT==36 && NLON==72)
! Data statements are used only if 5.0-deg resolution.
!
      real,dimension(36,0:34,0:35) :: pmn,zmn
!
!     Pmn Basis Set pmn(lat,m,n)
      data (pmn(lat, 0, 0), lat = 1,36)/
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01/
      data (pmn(lat, 0, 1), lat = 1,36)/
     |   1.2235791856553d+00, 1.2142670092351d+00, 1.1957135276802d+00,
     |   1.1680599441881d+00, 1.1315167192269d+00, 1.0863619688038d+00,
     |   1.0329393478349d+00, 9.7165543472308d-01, 9.0297663705145d-01,
     |   8.2742564193966d-01, 7.4557743807945d-01, 6.5805493972348d-01,
     |   5.6552424593179d-01, 4.6868957115567d-01, 3.6828788574057d-01,
     |   2.6508330713667d-01, 1.5986128450378d-01, 5.3422620968938d-02,
     |  -5.3422620968938d-02,-1.5986128450378d-01,-2.6508330713667d-01,
     |  -3.6828788574057d-01,-4.6868957115567d-01,-5.6552424593179d-01,
     |  -6.5805493972348d-01,-7.4557743807945d-01,-8.2742564193966d-01,
     |  -9.0297663705145d-01,-9.7165543472308d-01,-1.0329393478349d+00,
     |  -1.0863619688038d+00,-1.1315167192269d+00,-1.1680599441881d+00,
     |  -1.1957135276802d+00,-1.2142670092351d+00,-1.2235791856553d+00/
      data (pmn(lat, 1, 1), lat = 1,36)/
     |   3.7775497555894d-02, 1.1303899832182d-01, 1.8744220405569d-01,
     |   2.6041886143601d-01, 3.3141357403559d-01, 3.9988602922377d-01,
     |   4.6531511027178d-01, 5.2720286236567d-01, 5.8507828234316d-01,
     |   6.3850090331210d-01, 6.8706414686945d-01, 7.3039841740845d-01,
     |   7.6817391496434d-01, 8.0010314519127d-01, 8.2594310736780d-01,
     |   8.4549714377918d-01, 8.5861643640126d-01, 8.6520113949555d-01,
     |   8.6520113949555d-01, 8.5861643640126d-01, 8.4549714377918d-01,
     |   8.2594310736780d-01, 8.0010314519127d-01, 7.6817391496434d-01,
     |   7.3039841740845d-01, 6.8706414686945d-01, 6.3850090331210d-01,
     |   5.8507828234317d-01, 5.2720286236567d-01, 4.6531511027178d-01,
     |   3.9988602922377d-01, 3.3141357403559d-01, 2.6041886143601d-01,
     |   1.8744220405569d-01, 1.1303899832182d-01, 3.7775497555894d-02/
      data (pmn(lat, 0, 2), lat = 1,36)/
     |   1.5766262971287d+00, 1.5407318307161d+00, 1.4700335330895d+00,
     |   1.3666795362472d+00, 1.2338101990835d+00, 1.0754626891730d+00,
     |   8.9644831547672d-01, 7.0220633915373d-01, 4.9863870436341d-01,
     |   2.9193071067868d-01, 8.8363075888367d-02,-1.0587890043463d-01,
     |  -2.8489327413092d-01,-4.4324078404137d-01,-5.7611012120508d-01,
     |  -6.7946411804744d-01,-7.5016241567405d-01,-7.8605688208659d-01,
     |  -7.8605688208659d-01,-7.5016241567405d-01,-6.7946411804744d-01,
     |  -5.7611012120508d-01,-4.4324078404137d-01,-2.8489327413092d-01,
     |  -1.0587890043463d-01, 8.8363075888367d-02, 2.9193071067868d-01,
     |   4.9863870436341d-01, 7.0220633915373d-01, 8.9644831547672d-01,
     |   1.0754626891730d+00, 1.2338101990835d+00, 1.3666795362472d+00,
     |   1.4700335330895d+00, 1.5407318307161d+00, 1.5766262971287d+00/
      data (pmn(lat, 1, 2), lat = 1,36)/
     |   8.4388185047002d-02, 2.5060046284084d-01, 4.0919837238121d-01,
     |   5.5536299644115d-01, 6.8465319688146d-01, 7.9314055638576d-01,
     |   8.7752874143276d-01, 9.3525365972230d-01, 9.6456136882236d-01,
     |   9.6456136882236d-01, 9.3525365972230d-01, 8.7752874143276d-01,
     |   7.9314055638576d-01, 6.8465319688146d-01, 5.5536299644115d-01,
     |   4.0919837238121d-01, 2.5060046284084d-01, 8.4388185047004d-02,
     |  -8.4388185047004d-02,-2.5060046284084d-01,-4.0919837238121d-01,
     |  -5.5536299644115d-01,-6.8465319688146d-01,-7.9314055638576d-01,
     |  -8.7752874143276d-01,-9.3525365972230d-01,-9.6456136882236d-01,
     |  -9.6456136882236d-01,-9.3525365972230d-01,-8.7752874143276d-01,
     |  -7.9314055638576d-01,-6.8465319688146d-01,-5.5536299644115d-01,
     |  -4.0919837238121d-01,-2.5060046284084d-01,-8.4388185047002d-02/
      data (pmn(lat, 2, 2), lat = 1,36)/
     |   1.8422338647450d-03, 1.6496088414777d-02, 4.5358547559547d-02,
     |   8.7552640083049d-02, 1.4179631983520d-01, 2.0644142005535d-01,
     |   2.7952373208532d-01, 3.5882268685551d-01, 4.4192882575242d-01,
     |   5.2631701079943d-01, 6.0942314969635d-01, 6.8872210446653d-01,
     |   7.6180441649650d-01, 8.2644951671666d-01, 8.8069319646881d-01,
     |   9.2288728899231d-01, 9.5174974813708d-01, 9.6640360268711d-01,
     |   9.6640360268711d-01, 9.5174974813708d-01, 9.2288728899231d-01,
     |   8.8069319646881d-01, 8.2644951671666d-01, 7.6180441649650d-01,
     |   6.8872210446653d-01, 6.0942314969635d-01, 5.2631701079943d-01,
     |   4.4192882575242d-01, 3.5882268685551d-01, 2.7952373208532d-01,
     |   2.0644142005535d-01, 1.4179631983520d-01, 8.7552640083049d-02,
     |   4.5358547559547d-02, 1.6496088414777d-02, 1.8422338647450d-03/
      data (pmn(lat, 0, 3), lat = 1,36)/
     |   1.8601577137355d+00, 1.7758215221229d+00, 1.6125735893917d+00,
     |   1.3808956068215d+00, 1.0956170930909d+00, 7.7491208529797d-01,
     |   4.3907025269157d-01, 1.0912610628395d-01,-1.9456036925236d-01,
     |  -4.5367504111504d-01,-6.5317958085312d-01,-7.8231636251544d-01,
     |  -8.3531997606634d-01,-8.1178703200225d-01,-7.1667923138935d-01,
     |  -5.5995967795761d-01,-3.5588741147883d-01,-1.2201844047575d-01,
     |   1.2201844047575d-01, 3.5588741147883d-01, 5.5995967795761d-01,
     |   7.1667923138935d-01, 8.1178703200225d-01, 8.3531997606634d-01,
     |   7.8231636251544d-01, 6.5317958085312d-01, 4.5367504111504d-01,
     |   1.9456036925237d-01,-1.0912610628395d-01,-4.3907025269156d-01,
     |  -7.7491208529797d-01,-1.0956170930909d+00,-1.3808956068215d+00,
     |  -1.6125735893917d+00,-1.7758215221229d+00,-1.8601577137355d+00/
      data (pmn(lat, 1, 3), lat = 1,36)/
     |   1.4100681154942d-01, 4.1394583999384d-01, 6.6027543305578d-01,
     |   8.6426195988471d-01, 1.0130372040186d+00, 1.0974674483403d+00,
     |   1.1127682736161d+00, 1.0588232313268d+00, 9.4018472991115d-01,
     |   7.6575712767712d-01, 5.4818367982242d-01, 3.0297916556913d-01,
     |   4.7467349245728d-02,-2.0040427459070d-01,-4.2329164329729d-01,
     |  -6.0563953550565d-01,-7.3474441782897d-01,-8.0162227648079d-01,
     |  -8.0162227648079d-01,-7.3474441782897d-01,-6.0563953550565d-01,
     |  -4.2329164329729d-01,-2.0040427459070d-01, 4.7467349245729d-02,
     |   3.0297916556913d-01, 5.4818367982242d-01, 7.6575712767712d-01,
     |   9.4018472991115d-01, 1.0588232313268d+00, 1.1127682736161d+00,
     |   1.0974674483403d+00, 1.0130372040186d+00, 8.6426195988471d-01,
     |   6.6027543305578d-01, 4.1394583999384d-01, 1.4100681154942d-01/
      data (pmn(lat, 2, 3), lat = 1,36)/
     |   4.8694536067320d-03, 4.3271162396259d-02, 1.1716278124919d-01,
     |   2.2092139048191d-01, 3.4660061205796d-01, 4.8447880444394d-01,
     |   6.2373038043895d-01, 7.5317443177296d-01, 8.6204956015117d-01,
     |   9.4076201333600d-01, 9.8155602966178d-01, 9.7906058218502d-01,
     |   9.3067512423316d-01, 8.3676789835715d-01, 7.0067313378329d-01,
     |   5.2848715369341d-01, 3.2867710973378d-01, 1.1152882375756d-01,
     |  -1.1152882375756d-01,-3.2867710973378d-01,-5.2848715369341d-01,
     |  -7.0067313378329d-01,-8.3676789835715d-01,-9.3067512423316d-01,
     |  -9.7906058218502d-01,-9.8155602966178d-01,-9.4076201333600d-01,
     |  -8.6204956015117d-01,-7.5317443177296d-01,-6.2373038043895d-01,
     |  -4.8447880444394d-01,-3.4660061205796d-01,-2.2092139048191d-01,
     |  -1.1716278124919d-01,-4.3271162396259d-02,-4.8694536067320d-03/
      data (pmn(lat, 3, 3), lat = 1,36)/
     |   8.6795601633180d-05, 2.3256911443542d-03, 1.0603989398149d-02,
     |   2.8437043699258d-02, 5.8610849326562d-02, 1.0296173030619d-01,
     |   1.6222157178266d-01, 2.3593937058028d-01, 3.2248466760959d-01,
     |   4.1913283599632d-01, 5.2222660923130d-01, 6.2740302526595d-01,
     |   7.2987049034842d-01, 8.2471723538509d-01, 9.0723028165762d-01,
     |   9.7320329887662d-01, 1.0192124769554d+00, 1.0428416933614d+00,
     |   1.0428416933614d+00, 1.0192124769554d+00, 9.7320329887662d-01,
     |   9.0723028165762d-01, 8.2471723538509d-01, 7.2987049034842d-01,
     |   6.2740302526595d-01, 5.2222660923130d-01, 4.1913283599632d-01,
     |   3.2248466760959d-01, 2.3593937058028d-01, 1.6222157178266d-01,
     |   1.0296173030619d-01, 5.8610849326562d-02, 2.8437043699258d-02,
     |   1.0603989398149d-02, 2.3256911443542d-03, 8.6795601633180d-05/
      data (pmn(lat, 0, 4), lat = 1,36)/
     |   2.1011732798407d+00, 1.9433086086504d+00, 1.6448095495461d+00,
     |   1.2381134545383d+00, 7.6706067331307d-01, 2.8176516053684d-01,
     |  -1.6722637093313d-01,-5.3478844597638d-01,-7.8638526779050d-01,
     |  -9.0193854913341d-01,-8.7793726202429d-01,-7.2754431855211d-01,
     |  -4.7869694134936d-01,-1.7043932668693d-01, 1.5206101952656d-01,
     |   4.4320383319147d-01, 6.6265979260253d-01, 7.8039323033552d-01,
     |   7.8039323033552d-01, 6.6265979260253d-01, 4.4320383319147d-01,
     |   1.5206101952656d-01,-1.7043932668693d-01,-4.7869694134936d-01,
     |  -7.2754431855211d-01,-8.7793726202429d-01,-9.0193854913341d-01,
     |  -7.8638526779050d-01,-5.3478844597638d-01,-1.6722637093314d-01,
     |   2.8176516053684d-01, 7.6706067331307d-01, 1.2381134545383d+00,
     |   1.6448095495461d+00, 1.9433086086504d+00, 2.1011732798407d+00/
      data (pmn(lat, 1, 4), lat = 1,36)/
     |   2.0601973065225d-01, 5.9554158652955d-01, 9.2015574281074d-01,
     |   1.1450905676765d+00, 1.2472537301334d+00, 1.2178947794450d+00,
     |   1.0635520472139d+00, 8.0517295942015d-01, 4.7551662884358d-01,
     |   1.1515416596024d-01,-2.3244939782260d-01,-5.2617763442970d-01,
     |  -7.3219736508196d-01,-8.2799098435214d-01,-8.0500157685050d-01,
     |  -6.6957393883290d-01,-4.4208077071320d-01,-1.5434273223108d-01,
     |   1.5434273223108d-01, 4.4208077071320d-01, 6.6957393883290d-01,
     |   8.0500157685050d-01, 8.2799098435214d-01, 7.3219736508196d-01,
     |   5.2617763442970d-01, 2.3244939782260d-01,-1.1515416596024d-01,
     |  -4.7551662884358d-01,-8.0517295942015d-01,-1.0635520472139d+00,
     |  -1.2178947794450d+00,-1.2472537301334d+00,-1.1450905676765d+00,
     |  -9.2015574281074d-01,-5.9554158652955d-01,-2.0601973065225d-01/
      data (pmn(lat, 2, 4), lat = 1,36)/
     |   9.5512792501221d-03, 8.4012443249693d-02, 2.2280857881698d-01,
     |   4.0694346193120d-01, 6.1091058997669d-01, 8.0586982366145d-01,
     |   9.6325472400540d-01, 1.0583715730832d+00, 1.0735513198913d+00,
     |   1.0004690078613d+00, 8.4134520606291d-01, 6.0887853833603d-01,
     |   3.2491136042157d-01, 1.7983528695123d-02,-2.7993640867059d-01,
     |  -5.3715360381478d-01,-7.2594098505219d-01,-8.2578336965914d-01,
     |  -8.2578336965914d-01,-7.2594098505219d-01,-5.3715360381478d-01,
     |  -2.7993640867059d-01, 1.7983528695122d-02, 3.2491136042157d-01,
     |   6.0887853833603d-01, 8.4134520606291d-01, 1.0004690078613d+00,
     |   1.0735513198913d+00, 1.0583715730832d+00, 9.6325472400541d-01,
     |   8.0586982366145d-01, 6.1091058997669d-01, 4.0694346193120d-01,
     |   2.2280857881698d-01, 8.4012443249693d-02, 9.5512792501221d-03/
      data (pmn(lat, 3, 4), lat = 1,36)/
     |   2.6013897435827d-04, 6.9173836026377d-03, 3.1057897526865d-02,
     |   8.1362671815450d-02, 1.6244809222774d-01, 2.7398451055309d-01,
     |   4.1044885790346d-01, 5.6154986326823d-01, 7.1328191069188d-01,
     |   8.4948611906789d-01, 9.5373425070607d-01, 1.0113101992530d+00,
     |   1.0110500602787d+00, 9.4681686710344d-01, 8.1842822154102d-01,
     |   6.3191923887643d-01, 3.9910177104049d-01, 1.3646434735037d-01,
     |  -1.3646434735037d-01,-3.9910177104049d-01,-6.3191923887643d-01,
     |  -8.1842822154102d-01,-9.4681686710344d-01,-1.0110500602787d+00,
     |  -1.0113101992530d+00,-9.5373425070607d-01,-8.4948611906789d-01,
     |  -7.1328191069188d-01,-5.6154986326823d-01,-4.1044885790346d-01,
     |  -2.7398451055309d-01,-1.6244809222774d-01,-8.1362671815450d-02,
     |  -3.1057897526865d-02,-6.9173836026377d-03,-2.6013897435827d-04/
      data (pmn(lat, 4, 4), lat = 1,36)/
     |   4.0156286185928d-06, 3.2197783004188d-04, 2.4343459495125d-03,
     |   9.0699002491258d-03, 2.3789972311344d-02, 5.0426368530985d-02,
     |   9.2448823823296d-02, 1.5234345669071d-01, 2.3108336252020d-01,
     |   3.2776217395466d-01, 4.3944235423049d-01, 5.6124445274571d-01,
     |   6.8667461087325d-01, 8.0815874718704d-01, 9.1772655934341d-01,
     |   1.0077698164783d+00, 1.0717896502455d+00, 1.1050478868933d+00,
     |   1.1050478868933d+00, 1.0717896502455d+00, 1.0077698164783d+00,
     |   9.1772655934341d-01, 8.0815874718704d-01, 6.8667461087325d-01,
     |   5.6124445274571d-01, 4.3944235423049d-01, 3.2776217395466d-01,
     |   2.3108336252020d-01, 1.5234345669071d-01, 9.2448823823296d-02,
     |   5.0426368530985d-02, 2.3789972311344d-02, 9.0699002491258d-03,
     |   2.4343459495126d-03, 3.2197783004188d-04, 4.0156286185928d-06/
      data (pmn(lat, 0, 5), lat = 1,36)/
     |   2.3118375000562d+00, 2.0531633551594d+00, 1.5783690546064d+00,
     |   9.6494640784596d-01, 3.1149582157343d-01,-2.7977103346346d-01,
     |  -7.2098361704468d-01,-9.5373642867052d-01,-9.5864019983855d-01,
     |  -7.5760357559105d-01,-4.0850756263385d-01, 6.6487279366505d-03,
     |   3.9784383738406d-01, 6.8430838832342d-01, 8.0971682514627d-01,
     |   7.5244933790916d-01, 5.2902458528381d-01, 1.9010585916262d-01,
     |  -1.9010585916262d-01,-5.2902458528381d-01,-7.5244933790916d-01,
     |  -8.0971682514627d-01,-6.8430838832342d-01,-3.9784383738406d-01,
     |  -6.6487279366527d-03, 4.0850756263385d-01, 7.5760357559105d-01,
     |   9.5864019983855d-01, 9.5373642867052d-01, 7.2098361704468d-01,
     |   2.7977103346346d-01,-3.1149582157343d-01,-9.6494640784596d-01,
     |  -1.5783690546064d+00,-2.0531633551594d+00,-2.3118375000562d+00/
      data (pmn(lat, 1, 5), lat = 1,36)/
     |   2.7828764927230d-01, 7.8896956013186d-01, 1.1701924954518d+00,
     |   1.3615393402751d+00, 1.3364056427312d+00, 1.1064464676999d+00,
     |   7.1900863390729d-01, 2.4805496616934d-01,-2.1970555939593d-01,
     |  -6.0088270346255d-01,-8.3066764180986d-01,-8.7445876308100d-01,
     |  -7.3370793111399d-01,-4.4493562678488d-01,-7.2148508601684d-02,
     |   3.0586904792939d-01, 6.1095905864549d-01, 7.8075925590933d-01,
     |   7.8075925590933d-01, 6.1095905864549d-01, 3.0586904792940d-01,
     |  -7.2148508601683d-02,-4.4493562678488d-01,-7.3370793111399d-01,
     |  -8.7445876308100d-01,-8.3066764180986d-01,-6.0088270346255d-01,
     |  -2.1970555939593d-01, 2.4805496616933d-01, 7.1900863390729d-01,
     |   1.1064464676999d+00, 1.3364056427312d+00, 1.3615393402751d+00,
     |   1.1701924954518d+00, 7.8896956013186d-01, 2.7828764927230d-01/
      data (pmn(lat, 2, 5), lat = 1,36)/
     |   1.6104058398550d-02, 1.3984661382206d-01, 3.6127944443550d-01,
     |   6.3333107538031d-01, 8.9702391051137d-01, 1.0929403707111d+00,
     |   1.1728662564486d+00, 1.1093961450505d+00, 9.0166364285134d-01,
     |   5.7608410907866d-01, 1.8193332578746d-01,-2.1744294756789d-01,
     |  -5.5616882358179d-01,-7.7798471279704d-01,-8.4673460413046d-01,
     |  -7.5322946455155d-01,-5.1719116700687d-01,-1.8389394708191d-01,
     |   1.8389394708191d-01, 5.1719116700687d-01, 7.5322946455155d-01,
     |   8.4673460413046d-01, 7.7798471279704d-01, 5.5616882358179d-01,
     |   2.1744294756790d-01,-1.8193332578746d-01,-5.7608410907866d-01,
     |  -9.0166364285134d-01,-1.1093961450505d+00,-1.1728662564486d+00,
     |  -1.0929403707111d+00,-8.9702391051137d-01,-6.3333107538031d-01,
     |  -3.6127944443550d-01,-1.3984661382206d-01,-1.6104058398550d-02/
      data (pmn(lat, 3, 5), lat = 1,36)/
     |   5.7450453350884d-04, 1.5131206888883d-02, 6.6631916246338d-02,
     |   1.6944124805038d-01, 3.2472787527782d-01, 5.1915124248600d-01,
     |   7.2657763221382d-01, 9.1255522263414d-01, 1.0407362090118d+00,
     |   1.0800428392428d+00, 1.0112084410454d+00, 8.3141705502463d-01,
     |   5.5610046806483d-01, 2.1746789540798d-01,-1.4005438485914d-01,
     |  -4.6672060661388d-01,-7.1550605725741d-01,-8.4987201817474d-01,
     |  -8.4987201817474d-01,-7.1550605725741d-01,-4.6672060661388d-01,
     |  -1.4005438485914d-01, 2.1746789540798d-01, 5.5610046806483d-01,
     |   8.3141705502463d-01, 1.0112084410454d+00, 1.0800428392428d+00,
     |   1.0407362090118d+00, 9.1255522263414d-01, 7.2657763221382d-01,
     |   5.1915124248600d-01, 3.2472787527782d-01, 1.6944124805038d-01,
     |   6.6631916246339d-02, 1.5131206888883d-02, 5.7450453350884d-04/
      data (pmn(lat, 4, 5), lat = 1,36)/
     |   1.3305657322966d-05, 1.0587437945937d-03, 7.8824305393415d-03,
     |   2.8689194502119d-02, 7.2896323447598d-02, 1.4834843188889d-01,
     |   2.5859904972140d-01, 4.0085453635698d-01, 5.6506174365880d-01,
     |   7.3440989578910d-01, 8.8724872327090d-01, 1.0001495136755d+00,
     |   1.0516057024602d+00, 1.0257291104668d+00, 9.1527467777415d-01,
     |   7.2342654410726d-01, 4.6398460430509d-01, 1.5986632908671d-01,
     |  -1.5986632908671d-01,-4.6398460430509d-01,-7.2342654410726d-01,
     |  -9.1527467777415d-01,-1.0257291104668d+00,-1.0516057024602d+00,
     |  -1.0001495136755d+00,-8.8724872327090d-01,-7.3440989578910d-01,
     |  -5.6506174365880d-01,-4.0085453635698d-01,-2.5859904972140d-01,
     |  -1.4834843188889d-01,-7.2896323447598d-02,-2.8689194502119d-02,
     |  -7.8824305393415d-03,-1.0587437945937d-03,-1.3305657322966d-05/
      data (pmn(lat, 5, 5), lat = 1,36)/
     |   1.8370858196787d-07, 4.4077807151189d-05, 5.5260573770510d-04,
     |   2.8604914724503d-03, 9.5483853930534d-03, 2.4420785883256d-02,
     |   5.2097184926452d-02, 9.7267393017009d-02, 1.6373757987198d-01,
     |   2.5344636008382d-01, 3.6564943766704d-01, 4.9645237872436d-01,
     |   6.3881669357887d-01, 7.8308402864221d-01, 9.1797138730968d-01,
     |   1.0319037778946d+00, 1.1144856161062d+00, 1.1578809054659d+00,
     |   1.1578809054659d+00, 1.1144856161062d+00, 1.0319037778946d+00,
     |   9.1797138730968d-01, 7.8308402864221d-01, 6.3881669357886d-01,
     |   4.9645237872436d-01, 3.6564943766704d-01, 2.5344636008382d-01,
     |   1.6373757987198d-01, 9.7267393017009d-02, 5.2097184926452d-02,
     |   2.4420785883256d-02, 9.5483853930534d-03, 2.8604914724503d-03,
     |   5.5260573770511d-04, 4.4077807151189d-05, 1.8370858196787d-07/
      data (pmn(lat, 0, 6), lat = 1,36)/
     |   2.4987938632755d+00, 2.1107305583674d+00, 1.4238452089390d+00,
     |   5.9414683282035d-01,-1.9467625491096d-01,-7.7679318807343d-01,
     |  -1.0444285180357d+00,-9.7242319392299d-01,-6.2105272560861d-01,
     |  -1.1676919233758d-01, 3.8365374294835d-01, 7.3578607370724d-01,
     |   8.4556483882999d-01, 6.9262737928526d-01, 3.3298376517168d-01,
     |  -1.1930051586200d-01,-5.2605885864420d-01,-7.6506969658073d-01,
     |  -7.6506969658073d-01,-5.2605885864420d-01,-1.1930051586200d-01,
     |   3.3298376517168d-01, 6.9262737928526d-01, 8.4556483882999d-01,
     |   7.3578607370724d-01, 3.8365374294835d-01,-1.1676919233758d-01,
     |  -6.2105272560861d-01,-9.7242319392299d-01,-1.0444285180357d+00,
     |  -7.7679318807343d-01,-1.9467625491096d-01, 5.9414683282035d-01,
     |   1.4238452089390d+00, 2.1107305583674d+00, 2.4987938632755d+00/
      data (pmn(lat, 1, 6), lat = 1,36)/
     |   3.5693527747247d-01, 9.8841374961422d-01, 1.3934963558012d+00,
     |   1.4850995924145d+00, 1.2543725676428d+00, 7.7169777030139d-01,
     |   1.6726159676459d-01,-4.0354446948426d-01,-8.0066739191845d-01,
     |  -9.3515827160868d-01,-7.9079552359032d-01,-4.2604143941523d-01,
     |   4.3903854431346d-02, 4.7987045943071d-01, 7.5730567654447d-01,
     |   8.0019331962134d-01, 6.0116269550817d-01, 2.2244439778225d-01,
     |  -2.2244439778225d-01,-6.0116269550817d-01,-8.0019331962134d-01,
     |  -7.5730567654447d-01,-4.7987045943071d-01,-4.3903854431344d-02,
     |   4.2604143941523d-01, 7.9079552359032d-01, 9.3515827160868d-01,
     |   8.0066739191845d-01, 4.0354446948426d-01,-1.6726159676458d-01,
     |  -7.7169777030139d-01,-1.2543725676428d+00,-1.4850995924145d+00,
     |  -1.3934963558012d+00,-9.8841374961422d-01,-3.5693527747247d-01/
      data (pmn(lat, 2, 6), lat = 1,36)/
     |   2.4711418876168d-02, 2.1130310460412d-01, 5.2869173573557d-01,
     |   8.8065586498841d-01, 1.1571237008279d+00, 1.2647577689482d+00,
     |   1.1532457644971d+00, 8.3013010711552d-01, 3.6007771245622d-01,
     |  -1.5132739746156d-01,-5.8501471377318d-01,-8.3978637959950d-01,
     |  -8.5921877331930d-01,-6.4687563529619d-01,-2.6569872955375d-01,
     |   1.7834501043039d-01, 5.6407763311707d-01, 7.8703439719269d-01,
     |   7.8703439719269d-01, 5.6407763311707d-01, 1.7834501043040d-01,
     |  -2.6569872955375d-01,-6.4687563529619d-01,-8.5921877331931d-01,
     |  -8.3978637959950d-01,-5.8501471377318d-01,-1.5132739746156d-01,
     |   3.6007771245622d-01, 8.3013010711552d-01, 1.1532457644971d+00,
     |   1.2647577689482d+00, 1.1571237008279d+00, 8.8065586498841d-01,
     |   5.2869173573558d-01, 2.1130310460412d-01, 2.4711418876168d-02/
      data (pmn(lat, 3, 6), lat = 1,36)/
     |   1.0802115135061d-03, 2.8124710749453d-02, 1.2097540697352d-01,
     |   2.9662328797275d-01, 5.4013770519315d-01, 8.0627717292297d-01,
     |   1.0305129586510d+00, 1.1466042991464d+00, 1.1059481146624d+00,
     |   8.9329936249196d-01, 5.3430662050830d-01, 9.2418490140237d-02,
     |  -3.4446604775819d-01,-6.8445765208308d-01,-8.5411993270841d-01,
     |  -8.1711906153723d-01,-5.8417296788866d-01,-2.1156854065689d-01,
     |   2.1156854065689d-01, 5.8417296788866d-01, 8.1711906153723d-01,
     |   8.5411993270841d-01, 6.8445765208308d-01, 3.4446604775819d-01,
     |  -9.2418490140234d-02,-5.3430662050830d-01,-8.9329936249196d-01,
     |  -1.1059481146624d+00,-1.1466042991464d+00,-1.0305129586510d+00,
     |  -8.0627717292297d-01,-5.4013770519315d-01,-2.9662328797275d-01,
     |  -1.2097540697352d-01,-2.8124710749453d-02,-1.0802115135061d-03/
      data (pmn(lat, 4, 6), lat = 1,36)/
     |   3.2307274718485d-05, 2.5472196188164d-03, 1.8614965917724d-02,
     |   6.5850506883980d-02, 1.6090343980078d-01, 3.1120091629858d-01,
     |   5.0865412501369d-01, 7.2754393519894d-01, 9.2768083608646d-01,
     |   1.0624562794645d+00, 1.0899707414760d+00, 9.8443648767352d-01,
     |   7.4479433739538d-01, 3.9804531102947d-01,-3.9482589174622d-03,
     |  -3.9380807694445d-01,-7.0216439463325d-01,-8.7227192116516d-01,
     |  -8.7227192116516d-01,-7.0216439463325d-01,-3.9380807694445d-01,
     |  -3.9482589174626d-03, 3.9804531102946d-01, 7.4479433739538d-01,
     |   9.8443648767352d-01, 1.0899707414760d+00, 1.0624562794645d+00,
     |   9.2768083608647d-01, 7.2754393519894d-01, 5.0865412501369d-01,
     |   3.1120091629858d-01, 1.6090343980078d-01, 6.5850506883981d-02,
     |   1.8614965917724d-02, 2.5472196188164d-03, 3.2307274718485d-05/
      data (pmn(lat, 5, 6), lat = 1,36)/
     |   6.6174028187942d-07, 1.5756517015158d-04, 1.9452193415630d-03,
     |   9.8363015672663d-03, 3.1806579096972d-02, 7.8101654841954d-02,
     |   1.5842186614285d-01, 2.7823105770142d-01, 4.3526217457739d-01,
     |   6.1736368652350d-01, 8.0257146366697d-01, 9.6175797472817d-01,
     |   1.0635392753734d+00, 1.0804873910281d+00, 9.9527392209871d-01,
     |   8.0528132792689d-01, 5.2449797113571d-01, 1.8210217368640d-01,
     |  -1.8210217368640d-01,-5.2449797113571d-01,-8.0528132792689d-01,
     |  -9.9527392209871d-01,-1.0804873910281d+00,-1.0635392753734d+00,
     |  -9.6175797472817d-01,-8.0257146366697d-01,-6.1736368652350d-01,
     |  -4.3526217457739d-01,-2.7823105770142d-01,-1.5842186614285d-01,
     |  -7.8101654841954d-02,-3.1806579096972d-02,-9.8363015672664d-03,
     |  -1.9452193415630d-03,-1.5756517015158d-04,-6.6174028187942d-07/
      data (pmn(lat, 6, 6), lat = 1,36)/
     |   8.3404610711023d-09, 5.9882331663109d-06, 1.2448963500662d-04,
     |   8.9528954856718d-04, 3.8032130400235d-03, 1.1736707701246d-02,
     |   2.9134786098709d-02, 6.1630466766703d-02, 1.1513643182202d-01,
     |   1.9449032222681d-01, 3.0193441508716d-01, 4.3580061710993d-01,
     |   5.8977482946698d-01, 7.5301697328801d-01, 9.1123354593927d-01,
     |   1.0485804798124d+00, 1.1500695025690d+00, 1.2040136102668d+00,
     |   1.2040136102668d+00, 1.1500695025690d+00, 1.0485804798124d+00,
     |   9.1123354593927d-01, 7.5301697328801d-01, 5.8977482946698d-01,
     |   4.3580061710993d-01, 3.0193441508716d-01, 1.9449032222681d-01,
     |   1.1513643182202d-01, 6.1630466766703d-02, 2.9134786098710d-02,
     |   1.1736707701246d-02, 3.8032130400235d-03, 8.9528954856719d-04,
     |   1.2448963500662d-04, 5.9882331663109d-06, 8.3404610711023d-09/
      data (pmn(lat, 0, 7), lat = 1,36)/
     |   2.6660969608177d+00, 2.1195882986320d+00, 1.1932548563168d+00,
     |   1.6455993404102d-01,-6.7058064630424d-01,-1.0944975809861d+00,
     |  -1.0355720913210d+00,-5.8438850050093d-01, 4.6092016467057d-02,
     |   6.0093279550215d-01, 8.7480041434496d-01, 7.8200063799125d-01,
     |   3.8066947975994d-01,-1.5618290395472d-01,-6.1071882859751d-01,
     |  -8.0465782451421d-01,-6.6649324678159d-01,-2.5685538849478d-01,
     |   2.5685538849478d-01, 6.6649324678159d-01, 8.0465782451421d-01,
     |   6.1071882859751d-01, 1.5618290395472d-01,-3.8066947975995d-01,
     |  -7.8200063799125d-01,-8.7480041434496d-01,-6.0093279550215d-01,
     |  -4.6092016467058d-02, 5.8438850050093d-01, 1.0355720913210d+00,
     |   1.0944975809861d+00, 6.7058064630424d-01,-1.6455993404102d-01,
     |  -1.1932548563168d+00,-2.1195882986320d+00,-2.6660969608177d+00/
      data (pmn(lat, 1, 7), lat = 1,36)/
     |   4.4124538426064d-01, 1.1884429799379d+00, 1.5752413776591d+00,
     |   1.4971084074255d+00, 1.0032121123866d+00, 2.7636381201412d-01,
     |  -4.3263345770376d-01,-8.9263897306743d-01,-9.7073524191663d-01,
     |  -6.7422768186253d-01,-1.4200000753637d-01, 4.1058428448025d-01,
     |   7.7248118288170d-01, 8.1380498300559d-01, 5.3094009738888d-01,
     |   4.4083862245263d-02,-4.5106464980361d-01,-7.5898123349327d-01,
     |  -7.5898123349327d-01,-4.5106464980361d-01, 4.4083862245261d-02,
     |   5.3094009738888d-01, 8.1380498300559d-01, 7.7248118288170d-01,
     |   4.1058428448025d-01,-1.4200000753637d-01,-6.7422768186253d-01,
     |  -9.7073524191663d-01,-8.9263897306743d-01,-4.3263345770377d-01,
     |   2.7636381201412d-01, 1.0032121123866d+00, 1.4971084074255d+00,
     |   1.5752413776591d+00, 1.1884429799379d+00, 4.4124538426064d-01/
      data (pmn(lat, 2, 7), lat = 1,36)/
     |   3.5533779642403d-02, 2.9838797824086d-01, 7.1870854950258d-01,
     |   1.1247225027086d+00, 1.3420621800549d+00, 1.2590717218429d+00,
     |   8.6974779834786d-01, 2.7849930627974d-01,-3.3526224779554d-01,
     |  -7.8010817966377d-01,-9.2050841209611d-01,-7.2515985128594d-01,
     |  -2.7820937616237d-01, 2.5079290631109d-01, 6.6748742077502d-01,
     |   8.2208333627762d-01, 6.6256128091103d-01, 2.5254974786046d-01,
     |  -2.5254974786045d-01,-6.6256128091103d-01,-8.2208333627762d-01,
     |  -6.6748742077502d-01,-2.5079290631109d-01, 2.7820937616237d-01,
     |   7.2515985128594d-01, 9.2050841209611d-01, 7.8010817966377d-01,
     |   3.3526224779554d-01,-2.7849930627973d-01,-8.6974779834785d-01,
     |  -1.2590717218429d+00,-1.3420621800549d+00,-1.1247225027086d+00,
     |  -7.1870854950258d-01,-2.9838797824086d-01,-3.5533779642403d-02/
      data (pmn(lat, 3, 7), lat = 1,36)/
     |   1.8315909097399d-03, 4.7049497017015d-02, 1.9684810125803d-01,
     |   4.6205201225966d-01, 7.9026614902334d-01, 1.0809917726568d+00,
     |   1.2218969157356d+00, 1.1329716653570d+00, 8.0184776055421d-01,
     |   2.9630483715980d-01,-2.5199038542038d-01,-6.8802579920485d-01,
     |  -8.8471231020107d-01,-7.8696651354302d-01,-4.3271612544508d-01,
     |   5.7283716858998d-02, 5.1810365651947d-01, 7.9499399938983d-01,
     |   7.9499399938983d-01, 5.1810365651947d-01, 5.7283716859000d-02,
     |  -4.3271612544508d-01,-7.8696651354302d-01,-8.8471231020107d-01,
     |  -6.8802579920486d-01,-2.5199038542038d-01, 2.9630483715979d-01,
     |   8.0184776055421d-01, 1.1329716653570d+00, 1.2218969157356d+00,
     |   1.0809917726568d+00, 7.9026614902334d-01, 4.6205201225966d-01,
     |   1.9684810125803d-01, 4.7049497017015d-02, 1.8315909097399d-03/
      data (pmn(lat, 4, 7), lat = 1,36)/
     |   6.6363732474423d-05, 5.1764725580583d-03, 3.7011955024235d-02,
     |   1.2658373043631d-01, 2.9509139109173d-01, 5.3614954173411d-01,
     |   8.0773654987587d-01, 1.0386790006807d+00, 1.1489152732952d+00,
     |   1.0771911877976d+00, 8.0636544691650d-01, 3.7654693984350d-01,
     |  -1.2001283730122d-01,-5.6219908811555d-01,-8.3495396489533d-01,
     |  -8.6485665620092d-01,-6.4459475743719d-01,-2.3782238977686d-01,
     |   2.3782238977686d-01, 6.4459475743719d-01, 8.6485665620092d-01,
     |   8.3495396489533d-01, 5.6219908811555d-01, 1.2001283730122d-01,
     |  -3.7654693984350d-01,-8.0636544691650d-01,-1.0771911877976d+00,
     |  -1.1489152732952d+00,-1.0386790006807d+00,-8.0773654987587d-01,
     |  -5.3614954173411d-01,-2.9509139109173d-01,-1.2658373043631d-01,
     |  -3.7011955024235d-02,-5.1764725580583d-03,-6.6363732474423d-05/
      data (pmn(lat, 5, 7), lat = 1,36)/
     |   1.7392203397498d-06, 4.1044090291220d-04, 4.9764228310396d-03,
     |   2.4478682589392d-02, 7.6212751074434d-02, 1.7816354561879d-01,
     |   3.3966534927187d-01, 5.5229646653492d-01, 7.8528528609218d-01,
     |   9.8850783153221d-01, 1.1035804791958d+00, 1.0804902835788d+00,
     |   8.9478662179216d-01, 5.5953023326378d-01, 1.2737237774429d-01,
     |  -3.1897500464737d-01,-6.8593515672655d-01,-8.9274366856325d-01,
     |  -8.9274366856325d-01,-6.8593515672655d-01,-3.1897500464737d-01,
     |   1.2737237774429d-01, 5.5953023326378d-01, 8.9478662179216d-01,
     |   1.0804902835788d+00, 1.1035804791958d+00, 9.8850783153221d-01,
     |   7.8528528609218d-01, 5.5229646653492d-01, 3.3966534927187d-01,
     |   1.7816354561879d-01, 7.6212751074434d-02, 2.4478682589392d-02,
     |   4.9764228310396d-03, 4.1044090291220d-04, 1.7392203397498d-06/
      data (pmn(lat, 6, 7), lat = 1,36)/
     |   3.2271722037291d-08, 2.2993913750988d-05, 4.7071749109299d-04,
     |   3.3069577453736d-03, 1.3608542968169d-02, 4.0320029598292d-02,
     |   9.5167060537331d-02, 1.8936850085200d-01, 3.2876780340414d-01,
     |   5.0889357929121d-01, 7.1187767761264d-01, 9.0688035537165d-01,
     |   1.0547206840974d+00, 1.1160664565568d+00, 1.0612486065881d+00,
     |   8.7899043429611d-01, 5.8138976935858d-01, 2.0340264092844d-01,
     |  -2.0340264092844d-01,-5.8138976935858d-01,-8.7899043429610d-01,
     |  -1.0612486065881d+00,-1.1160664565568d+00,-1.0547206840974d+00,
     |  -9.0688035537165d-01,-7.1187767761264d-01,-5.0889357929121d-01,
     |  -3.2876780340414d-01,-1.8936850085200d-01,-9.5167060537331d-02,
     |  -4.0320029598292d-02,-1.3608542968169d-02,-3.3069577453737d-03,
     |  -4.7071749109299d-04,-2.2993913750988d-05,-3.2271722037291d-08/
      data (pmn(lat, 7, 7), lat = 1,36)/
     |   3.7657478164892d-10, 8.0905488175571d-07, 2.7890195333455d-05,
     |   2.7866789077909d-04, 1.5065096770960d-03, 5.6096207419565d-03,
     |   1.6203542390361d-02, 3.8835079312845d-02, 8.0515171789204d-02,
     |   1.4842617370130d-01, 2.4794815663867d-01, 3.8045092504459d-01,
     |   5.4149789081698d-01, 7.2011477733196d-01, 8.9956140200538d-01,
     |   1.0596559804305d+00, 1.1802506951363d+00, 1.2450863128795d+00,
     |   1.2450863128795d+00, 1.1802506951363d+00, 1.0596559804305d+00,
     |   8.9956140200538d-01, 7.2011477733196d-01, 5.4149789081698d-01,
     |   3.8045092504459d-01, 2.4794815663867d-01, 1.4842617370130d-01,
     |   8.0515171789204d-02, 3.8835079312845d-02, 1.6203542390361d-02,
     |   5.6096207419565d-03, 1.5065096770960d-03, 2.7866789077909d-04,
     |   2.7890195333456d-05, 8.0905488175571d-07, 3.7657478164892d-10/
      data (pmn(lat, 0, 8), lat = 1,36)/
     |   2.8164090536349d+00, 2.0826943680659d+00, 9.0068415862821d-01,
     |  -2.8123024876833d-01,-1.0418558258883d+00,-1.1606065316314d+00,
     |  -6.9831426750276d-01, 4.7567082911570d-02, 6.8925816621234d-01,
     |   9.2722054125204d-01, 6.7912297740828d-01, 1.0246626329708d-01,
     |  -4.9521291689611d-01,-8.1234701664980d-01,-6.9975913094057d-01,
     |  -2.2826649092736d-01, 3.5272540960871d-01, 7.4316539455461d-01,
     |   7.4316539455461d-01, 3.5272540960871d-01,-2.2826649092735d-01,
     |  -6.9975913094057d-01,-8.1234701664980d-01,-4.9521291689611d-01,
     |   1.0246626329708d-01, 6.7912297740828d-01, 9.2722054125204d-01,
     |   6.8925816621234d-01, 4.7567082911572d-02,-6.9831426750276d-01,
     |  -1.1606065316314d+00,-1.0418558258883d+00,-2.8123024876834d-01,
     |   9.0068415862820d-01, 2.0826943680659d+00, 2.8164090536349d+00/
      data (pmn(lat, 1, 8), lat = 1,36)/
     |   5.3060227783904d-01, 1.3839351546391d+00, 1.7031160996619d+00,
     |   1.3902057356006d+00, 6.1262245005893d-01,-2.7709804566676d-01,
     |  -9.0104464087382d-01,-1.0219572716357d+00,-6.4069760809014d-01,
     |   1.7034122176725d-02, 6.1543154430533d-01, 8.6909247939256d-01,
     |   6.7379463069206d-01, 1.4756512607569d-01,-4.3470881193718d-01,
     |  -7.7953017814281d-01,-7.1851098528523d-01,-2.8864216606851d-01,
     |   2.8864216606851d-01, 7.1851098528523d-01, 7.7953017814281d-01,
     |   4.3470881193718d-01,-1.4756512607569d-01,-6.7379463069206d-01,
     |  -8.6909247939256d-01,-6.1543154430533d-01,-1.7034122176726d-02,
     |   6.4069760809014d-01, 1.0219572716357d+00, 9.0104464087383d-01,
     |   2.7709804566676d-01,-6.1262245005893d-01,-1.3902057356006d+00,
     |  -1.7031160996619d+00,-1.3839351546391d+00,-5.3060227783904d-01/
      data (pmn(lat, 2, 8), lat = 1,36)/
     |   4.8712385462238d-02, 4.0061846500464d-01, 9.2295099404309d-01,
     |   1.3392125841909d+00, 1.4101836247658d+00, 1.0498257261995d+00,
     |   3.7012399241746d-01,-3.6661263572892d-01,-8.6617583518020d-01,
     |  -9.3664202252085d-01,-5.7587011830612d-01, 2.8433397322423d-02,
     |   5.8608411441480d-01, 8.3848155050094d-01, 6.7692092567722d-01,
     |   1.9019314818875d-01,-3.8034109183742d-01,-7.5671982141750d-01,
     |  -7.5671982141750d-01,-3.8034109183742d-01, 1.9019314818874d-01,
     |   6.7692092567722d-01, 8.3848155050094d-01, 5.8608411441480d-01,
     |   2.8433397322426d-02,-5.7587011830612d-01,-9.3664202252085d-01,
     |  -8.6617583518020d-01,-3.6661263572892d-01, 3.7012399241746d-01,
     |   1.0498257261995d+00, 1.4101836247658d+00, 1.3392125841909d+00,
     |   9.2295099404309d-01, 4.0061846500464d-01, 4.8712385462238d-02/
      data (pmn(lat, 3, 8), lat = 1,36)/
     |   2.8866265767354d-03, 7.3013586495917d-02, 2.9583316303201d-01,
     |   6.5958120110621d-01, 1.0453385561695d+00, 1.2783241401628d+00,
     |   1.2140013390830d+00, 8.1722809442914d-01, 1.9441077082269d-01,
     |  -4.4012776030275d-01,-8.5137367781580d-01,-8.8612248277803d-01,
     |  -5.4369339491899d-01, 1.9032812178771d-02, 5.5277486759151d-01,
     |   8.2356536064275d-01, 7.1530961475016d-01, 2.8099291335600d-01,
     |  -2.8099291335600d-01,-7.1530961475015d-01,-8.2356536064275d-01,
     |  -5.5277486759151d-01,-1.9032812178771d-02, 5.4369339491899d-01,
     |   8.8612248277803d-01, 8.5137367781580d-01, 4.4012776030275d-01,
     |  -1.9441077082269d-01,-8.1722809442914d-01,-1.2140013390830d+00,
     |  -1.2783241401628d+00,-1.0453385561695d+00,-6.5958120110622d-01,
     |  -2.9583316303201d-01,-7.3013586495917d-02,-2.8866265767354d-03/
      data (pmn(lat, 4, 8), lat = 1,36)/
     |   1.2218226561554d-04, 9.4138933277928d-03, 6.5635921752303d-02,
     |   2.1581959430421d-01, 4.7581371552735d-01, 8.0106236999805d-01,
     |   1.0878823988147d+00, 1.2094771166281d+00, 1.0727929568427d+00,
     |   6.6996144503716d-01, 9.7947614322472d-02,-4.6709827743377d-01,
     |  -8.3392342264562d-01,-8.7330022098665d-01,-5.7495678671308d-01,
     |  -5.8050362115769d-02, 4.7185065028853d-01, 8.0315751810856d-01,
     |   8.0315751810856d-01, 4.7185065028853d-01,-5.8050362115766d-02,
     |  -5.7495678671308d-01,-8.7330022098665d-01,-8.3392342264562d-01,
     |  -4.6709827743378d-01, 9.7947614322472d-02, 6.6996144503716d-01,
     |   1.0727929568427d+00, 1.2094771166281d+00, 1.0878823988147d+00,
     |   8.0106236999805d-01, 4.7581371552735d-01, 2.1581959430421d-01,
     |   6.5635921752304d-02, 9.4138933277928d-03, 1.2218226561554d-04/
      data (pmn(lat, 5, 8), lat = 1,36)/
     |   3.8493988469786d-06, 8.9918879308453d-04, 1.0678291599519d-02,
     |   5.0872167056908d-02, 1.5151216549925d-01, 3.3403432193907d-01,
     |   5.9040244137472d-01, 8.7081670052276d-01, 1.0899977054226d+00,
     |   1.1538412292389d+00, 9.9790217700568d-01, 6.2171905529230d-01,
     |   1.0241519526473d-01,-4.2175102519615d-01,-7.9489108639806d-01,
     |  -8.9892848567181d-01,-6.9944947838524d-01,-2.6293189119308d-01,
     |   2.6293189119308d-01, 6.9944947838524d-01, 8.9892848567181d-01,
     |   7.9489108639806d-01, 4.2175102519615d-01,-1.0241519526473d-01,
     |  -6.2171905529230d-01,-9.9790217700568d-01,-1.1538412292389d+00,
     |  -1.0899977054226d+00,-8.7081670052276d-01,-5.9040244137472d-01,
     |  -3.3403432193907d-01,-1.5151216549925d-01,-5.0872167056909d-02,
     |  -1.0678291599519d-02,-8.9918879308453d-04,-3.8493988469786d-06/
      data (pmn(lat, 6, 8), lat = 1,36)/
     |   9.0798213511372d-08, 6.4131487589660d-05, 1.2898594209845d-03,
     |   8.8202540202139d-03, 3.4978370663398d-02, 9.8784498940183d-02,
     |   2.1951664079932d-01, 4.0536117604443d-01, 6.4178120782586d-01,
     |   8.8598610314126d-01, 1.0725413575031d+00, 1.1309017175734d+00,
     |   1.0101695757143d+00, 7.0215855212209d-01, 2.5302514933561d-01,
     |  -2.4291503589441d-01,-6.6711604997110d-01,-9.1138498597587d-01,
     |  -9.1138498597587d-01,-6.6711604997110d-01,-2.4291503589441d-01,
     |   2.5302514933560d-01, 7.0215855212209d-01, 1.0101695757143d+00,
     |   1.1309017175734d+00, 1.0725413575031d+00, 8.8598610314126d-01,
     |   6.4178120782587d-01, 4.0536117604443d-01, 2.1951664079932d-01,
     |   9.8784498940183d-02, 3.4978370663398d-02, 8.8202540202140d-03,
     |   1.2898594209845d-03, 6.4131487589660d-05, 9.0798213511372d-08/
      data (pmn(lat, 7, 8), lat = 1,36)/
     |   1.5511798146873d-09, 3.3072803426958d-06, 1.1226839907650d-04,
     |   1.0957989822133d-03, 5.7386763531776d-03, 2.0515725751181d-02,
     |   5.6346068920184d-02, 1.2703263649909d-01, 2.4475584327317d-01,
     |   4.1344552781241d-01, 6.2234681660817d-01, 8.4282930802855d-01,
     |   1.0309244265331d+00, 1.1362289339759d+00, 1.1153138041172d+00,
     |   9.4564058899482d-01, 6.3517938479401d-01, 2.2392546322476d-01,
     |  -2.2392546322476d-01,-6.3517938479401d-01,-9.4564058899482d-01,
     |  -1.1153138041172d+00,-1.1362289339759d+00,-1.0309244265331d+00,
     |  -8.4282930802855d-01,-6.2234681660817d-01,-4.1344552781241d-01,
     |  -2.4475584327317d-01,-1.2703263649909d-01,-5.6346068920185d-02,
     |  -2.0515725751181d-02,-5.7386763531776d-03,-1.0957989822133d-03,
     |  -1.1226839907650d-04,-3.3072803426958d-06,-1.5511798146873d-09/
      data (pmn(lat, 8, 8), lat = 1,36)/
     |   1.6931493332474d-11, 1.0885292933440d-07, 6.2223262146819d-06,
     |   8.6376022986666d-05, 5.9425939388898d-04, 2.6699527110552d-03,
     |   8.9741012056147d-03, 2.4368892584969d-02, 5.6069352303533d-02,
     |   1.1279915480769d-01, 2.0276454052768d-01, 3.3074425219608d-01,
     |   4.9509684940703d-01, 6.8577482559135d-01, 8.8433086603551d-01,
     |   1.0663772615467d+00, 1.2061666060918d+00, 1.2821840775059d+00,
     |   1.2821840775059d+00, 1.2061666060918d+00, 1.0663772615467d+00,
     |   8.8433086603551d-01, 6.8577482559135d-01, 4.9509684940703d-01,
     |   3.3074425219608d-01, 2.0276454052768d-01, 1.1279915480769d-01,
     |   5.6069352303533d-02, 2.4368892584969d-02, 8.9741012056147d-03,
     |   2.6699527110552d-03, 5.9425939388898d-04, 8.6376022986667d-05,
     |   6.2223262146820d-06, 1.0885292933440d-07, 1.6931493332474d-11/
      data (pmn(lat, 0, 9), lat = 1,36)/
     |   2.9515719598280d+00, 2.0029148791584d+00, 5.6220679651935d-01,
     |  -7.0022728998013d-01,-1.2512688711291d+00,-9.6081340059095d-01,
     |  -1.4008723567158d-01, 6.5998738457556d-01, 9.6866821817473d-01,
     |   6.4972730121566d-01,-4.9589577774048d-02,-6.7238227090014d-01,
     |  -8.3744755879944d-01,-4.6453610349292d-01, 1.9077679503217d-01,
     |   7.0632967419414d-01, 7.5870506837200d-01, 3.2169377900795d-01,
     |  -3.2169377900795d-01,-7.5870506837200d-01,-7.0632967419414d-01,
     |  -1.9077679503217d-01, 4.6453610349292d-01, 8.3744755879944d-01,
     |   6.7238227090014d-01, 4.9589577774048d-02,-6.4972730121566d-01,
     |  -9.6866821817473d-01,-6.5998738457556d-01, 1.4008723567157d-01,
     |   9.6081340059095d-01, 1.2512688711291d+00, 7.0022728998014d-01,
     |  -5.6220679651934d-01,-2.0029148791584d+00,-2.9515719598280d+00/
      data (pmn(lat, 1, 9), lat = 1,36)/
     |   6.2445911017621d-01, 1.5700676847737d+00, 1.7677716756833d+00,
     |   1.1688906658575d+00, 1.3531514478221d-01,-7.6989497389740d-01,
     |  -1.0948821124995d+00,-7.3760722114166d-01, 2.0359256164842d-02,
     |   6.9650817875894d-01, 8.9462852847037d-01, 5.2822293061513d-01,
     |  -1.4635752382069d-01,-6.9931745425327d-01,-7.9293756471809d-01,
     |  -3.8304921592925d-01, 2.6205428157675d-01, 7.3273336475874d-01,
     |   7.3273336475874d-01, 2.6205428157675d-01,-3.8304921592925d-01,
     |  -7.9293756471809d-01,-6.9931745425327d-01,-1.4635752382069d-01,
     |   5.2822293061513d-01, 8.9462852847037d-01, 6.9650817875894d-01,
     |   2.0359256164843d-02,-7.3760722114166d-01,-1.0948821124995d+00,
     |  -7.6989497389740d-01, 1.3531514478221d-01, 1.1688906658575d+00,
     |   1.7677716756833d+00, 1.5700676847737d+00, 6.2445911017621d-01/
      data (pmn(lat, 2, 9), lat = 1,36)/
     |   6.4371681126739d-02, 5.1705194841746d-01, 1.1314821568601d+00,
     |   1.4985275494737d+00, 1.3350562882760d+00, 6.5635623824376d-01,
     |  -2.2474096345687d-01,-8.7238822711339d-01,-9.7487702678996d-01,
     |  -5.2099753257070d-01, 1.9650638285933d-01, 7.5172531653045d-01,
     |   8.3066701442609d-01, 4.0802810191438d-01,-2.4623532506826d-01,
     |  -7.3241605152666d-01,-7.5992283294202d-01,-3.1850817135416d-01,
     |   3.1850817135416d-01, 7.5992283294202d-01, 7.3241605152666d-01,
     |   2.4623532506826d-01,-4.0802810191438d-01,-8.3066701442609d-01,
     |  -7.5172531653045d-01,-1.9650638285933d-01, 5.2099753257070d-01,
     |   9.7487702678997d-01, 8.7238822711339d-01, 2.2474096345687d-01,
     |  -6.5635623824376d-01,-1.3350562882760d+00,-1.4985275494737d+00,
     |  -1.1314821568601d+00,-5.1705194841746d-01,-6.4371681126739d-02/
      data (pmn(lat, 3, 9), lat = 1,36)/
     |   4.3065154944245d-03, 1.0704214122567d-01, 4.1810291275626d-01,
     |   8.7786027800860d-01, 1.2681814976112d+00, 1.3382920724937d+00,
     |   9.6668496335832d-01, 2.5877315912609d-01,-4.8515871807358d-01,
     |  -9.2125603173455d-01,-8.4987367511589d-01,-3.3164350633966d-01,
     |   3.3852433542685d-01, 7.8953658306534d-01, 7.7771360208761d-01,
     |   3.2119810304231d-01,-3.1188464855496d-01,-7.5604574514661d-01,
     |  -7.5604574514661d-01,-3.1188464855496d-01, 3.2119810304231d-01,
     |   7.7771360208761d-01, 7.8953658306534d-01, 3.3852433542685d-01,
     |  -3.3164350633965d-01,-8.4987367511589d-01,-9.2125603173455d-01,
     |  -4.8515871807358d-01, 2.5877315912608d-01, 9.6668496335832d-01,
     |   1.3382920724937d+00, 1.2681814976112d+00, 8.7786027800860d-01,
     |   4.1810291275626d-01, 1.0704214122567d-01, 4.3065154944245d-03/
      data (pmn(lat, 4, 9), lat = 1,36)/
     |   2.0792281041494d-04, 1.5799264168951d-02, 1.0704965131599d-01,
     |   3.3640751393604d-01, 6.9453565639265d-01, 1.0654055023414d+00,
     |   1.2640892105402d+00, 1.1344293402655d+00, 6.5198193472621d-01,
     |  -3.2839710153903d-02,-6.4696008850398d-01,-9.2363886925486d-01,
     |  -7.4230284900683d-01,-2.0125304433774d-01, 4.2211932922754d-01,
     |   8.0844030214158d-01, 7.6071414892250d-01, 3.0810589528856d-01,
     |  -3.0810589528856d-01,-7.6071414892250d-01,-8.0844030214158d-01,
     |  -4.2211932922754d-01, 2.0125304433773d-01, 7.4230284900683d-01,
     |   9.2363886925486d-01, 6.4696008850398d-01, 3.2839710153904d-02,
     |  -6.5198193472621d-01,-1.1344293402655d+00,-1.2640892105402d+00,
     |  -1.0654055023414d+00,-6.9453565639265d-01,-3.3640751393604d-01,
     |  -1.0704965131599d-01,-1.5799264168951d-02,-2.0792281041494d-04/
      data (pmn(lat, 5, 9), lat = 1,36)/
     |   7.6025385948826d-06, 1.7555532622665d-03, 2.0363496720187d-02,
     |   9.3530766041902d-02, 2.6459773593891d-01, 5.4425020029849d-01,
     |   8.7684963469973d-01, 1.1404768767236d+00, 1.1924692093696d+00,
     |   9.4370190008622d-01, 4.2244656905835d-01,-2.1255786644066d-01,
     |  -7.2683204920200d-01,-9.1314177539568d-01,-6.9369046756401d-01,
     |  -1.6768216382916d-01, 4.2498623842369d-01, 8.1094262438686d-01,
     |   8.1094262438686d-01, 4.2498623842369d-01,-1.6768216382916d-01,
     |  -6.9369046756401d-01,-9.1314177539568d-01,-7.2683204920200d-01,
     |  -2.1255786644066d-01, 4.2244656905835d-01, 9.4370190008622d-01,
     |   1.1924692093696d+00, 1.1404768767236d+00, 8.7684963469973d-01,
     |   5.4425020029849d-01, 2.6459773593891d-01, 9.3530766041902d-02,
     |   2.0363496720188d-02, 1.7555532622665d-03, 7.6025385948826d-06/
      data (pmn(lat, 6, 9), lat = 1,36)/
     |   2.1437927361498d-07, 1.4993368518919d-04, 2.9559044086581d-03,
     |   1.9601132442805d-02, 7.4497121227116d-02, 1.9895865504602d-01,
     |   4.1152424883140d-01, 6.9347925480147d-01, 9.7581695436518d-01,
     |   1.1518499604070d+00, 1.1172786207295d+00, 8.2282489811473d-01,
     |   3.1331183683563d-01,-2.7092206648418d-01,-7.3830698759898d-01,
     |  -9.2120706648672d-01,-7.4943340624231d-01,-2.8708278221717d-01,
     |   2.8708278221717d-01, 7.4943340624231d-01, 9.2120706648672d-01,
     |   7.3830698759898d-01, 2.7092206648418d-01,-3.1331183683563d-01,
     |  -8.2282489811473d-01,-1.1172786207295d+00,-1.1518499604070d+00,
     |  -9.7581695436518d-01,-6.9347925480147d-01,-4.1152424883140d-01,
     |  -1.9895865504602d-01,-7.4497121227116d-02,-1.9601132442805d-02,
     |  -2.9559044086582d-03,-1.4993368518919d-04,-2.1437927361498d-07/
      data (pmn(lat, 7, 9), lat = 1,36)/
     |   4.6333401349062d-09, 9.7941374423152d-06, 3.2673846520470d-04,
     |   3.1055669299326d-03, 1.5683471169703d-02, 5.3492703378520d-02,
     |   1.3849421556572d-01, 2.9026591128234d-01, 5.1126982829383d-01,
     |   7.7304730454492d-01, 1.0126087787702d+00, 1.1455832283134d+00,
     |   1.0951201079952d+00, 8.2655350253532d-01, 3.7237009116485d-01,
     |  -1.6625664457743d-01,-6.4604147067917d-01,-9.2837147002645d-01,
     |  -9.2837147002645d-01,-6.4604147067917d-01,-1.6625664457743d-01,
     |   3.7237009116485d-01, 8.2655350253532d-01, 1.0951201079952d+00,
     |   1.1455832283134d+00, 1.0126087787702d+00, 7.7304730454492d-01,
     |   5.1126982829383d-01, 2.9026591128235d-01, 1.3849421556572d-01,
     |   5.3492703378520d-02, 1.5683471169703d-02, 3.1055669299327d-03,
     |   3.2673846520471d-04, 9.7941374423152d-06, 4.6333401349062d-09/
      data (pmn(lat, 8, 9), lat = 1,36)/
     |   7.3732424612505d-11, 4.7041968575253d-07, 2.6479579826112d-05,
     |   3.5907858572194d-04, 2.3931405303106d-03, 1.0323080020814d-02,
     |   3.2991112087128d-02, 8.4271213684024d-02, 1.8019105335792d-01,
     |   3.3217427213773d-01, 5.3804169993664d-01, 7.7461451387716d-01,
     |   9.9648912380053d-01, 1.1439261800367d+00, 1.1591333149258d+00,
     |   1.0060612622662d+00, 6.8624907115123d-01, 2.4378486604564d-01,
     |  -2.4378486604564d-01,-6.8624907115123d-01,-1.0060612622662d+00,
     |  -1.1591333149258d+00,-1.1439261800367d+00,-9.9648912380053d-01,
     |  -7.7461451387716d-01,-5.3804169993664d-01,-3.3217427213773d-01,
     |  -1.8019105335792d-01,-8.4271213684024d-02,-3.2991112087129d-02,
     |  -1.0323080020814d-02,-2.3931405303106d-03,-3.5907858572194d-04,
     |  -2.6479579826113d-05,-4.7041968575253d-07,-7.3732424612505d-11/
      data (pmn(lat, 9, 9), lat = 1,36)/
     |   7.5877912340921d-13, 1.4597495076975d-08, 1.3836621928176d-06,
     |   2.6685512995299d-05, 2.3364487766520d-04, 1.2666298457373d-03,
     |   4.9539091173773d-03, 1.5241351162688d-02, 3.8917903175773d-02,
     |   8.5443155278498d-02, 1.6527197250827d-01, 2.8659066838970d-01,
     |   4.5119017557948d-01, 6.5093471303916d-01, 8.6651250199573d-01,
     |   1.0696284285131d+00, 1.2286167010033d+00, 1.3160651179151d+00,
     |   1.3160651179151d+00, 1.2286167010033d+00, 1.0696284285131d+00,
     |   8.6651250199573d-01, 6.5093471303916d-01, 4.5119017557947d-01,
     |   2.8659066838970d-01, 1.6527197250827d-01, 8.5443155278498d-02,
     |   3.8917903175773d-02, 1.5241351162688d-02, 4.9539091173773d-03,
     |   1.2666298457373d-03, 2.3364487766520d-04, 2.6685512995299d-05,
     |   1.3836621928176d-06, 1.4597495076975d-08, 7.5877912340921d-13/
      data (pmn(lat, 0,10), lat = 1,36)/
     |   3.0729116272129d+00, 1.8832849384169d+00, 1.9543841512120d-01,
     |  -1.0526537289115d+00,-1.2669893275922d+00,-5.4142399061662d-01,
     |   4.6251842716958d-01, 9.9831549388840d-01, 7.3710682878880d-01,
     |  -5.0692468662240d-02,-7.3962361677088d-01,-8.2413411561144d-01,
     |  -2.7705462094205d-01, 4.5749006982295d-01, 8.1455678057527d-01,
     |   5.3370662877608d-01,-1.5501510207759d-01,-7.1535487152480d-01,
     |  -7.1535487152480d-01,-1.5501510207759d-01, 5.3370662877608d-01,
     |   8.1455678057527d-01, 4.5749006982295d-01,-2.7705462094205d-01,
     |  -8.2413411561144d-01,-7.3962361677088d-01,-5.0692468662241d-02,
     |   7.3710682878880d-01, 9.9831549388840d-01, 4.6251842716958d-01,
     |  -5.4142399061662d-01,-1.2669893275922d+00,-1.0526537289115d+00,
     |   1.9543841512119d-01, 1.8832849384169d+00, 3.0729116272129d+00/
      data (pmn(lat, 1,10), lat = 1,36)/
     |   7.2231769831931d-01, 1.7423403684929d+00, 1.7631894544806d+00,
     |   8.4904499321246d-01,-3.6110111623626d-01,-1.0941231596635d+00,
     |  -9.5356956608087d-01,-1.5374511654742d-01, 6.7026065871686d-01,
     |   9.2764735446703d-01, 4.7846598526156d-01,-2.9854354515089d-01,
     |  -8.0886560679899d-01,-6.8469153286257d-01,-4.4363612973641d-02,
     |   6.1239415254436d-01, 7.8653885005757d-01, 3.5254923025388d-01,
     |  -3.5254923025388d-01,-7.8653885005757d-01,-6.1239415254437d-01,
     |   4.4363612973640d-02, 6.8469153286257d-01, 8.0886560679899d-01,
     |   2.9854354515089d-01,-4.7846598526156d-01,-9.2764735446703d-01,
     |  -6.7026065871686d-01, 1.5374511654742d-01, 9.5356956608087d-01,
     |   1.0941231596635d+00, 3.6110111623626d-01,-8.4904499321246d-01,
     |  -1.7631894544806d+00,-1.7423403684929d+00,-7.2231769831931d-01/
      data (pmn(lat, 2,10), lat = 1,36)/
     |   8.2620881285756d-02, 6.4631658414883d-01, 1.3333608037285d+00,
     |   1.5805905493195d+00, 1.1108936776275d+00, 1.4192430580174d-01,
     |  -7.5484149999168d-01,-1.0460769259500d+00,-6.0313081885678d-01,
     |   2.1474846135372d-01, 8.1709666804464d-01, 7.9512728118492d-01,
     |   1.9857344861926d-01,-5.1628714221931d-01,-8.2475632714989d-01,
     |  -5.1249779476197d-01, 1.7637201198134d-01, 7.2491045673303d-01,
     |   7.2491045673303d-01, 1.7637201198134d-01,-5.1249779476197d-01,
     |  -8.2475632714989d-01,-5.1628714221931d-01, 1.9857344861926d-01,
     |   7.9512728118492d-01, 8.1709666804464d-01, 2.1474846135372d-01,
     |  -6.0313081885677d-01,-1.0460769259500d+00,-7.5484149999169d-01,
     |   1.4192430580174d-01, 1.1108936776275d+00, 1.5805905493195d+00,
     |   1.3333608037285d+00, 6.4631658414883d-01, 8.2620881285756d-02/
      data (pmn(lat, 3,10), lat = 1,36)/
     |   6.1552481958767d-03, 1.5004013524142d-01, 5.6226548426070d-01,
     |   1.1010388033107d+00, 1.4199211410033d+00, 1.2219013478713d+00,
     |   5.0699260377915d-01,-3.7804619470815d-01,-9.4119665802290d-01,
     |  -8.6813467120679d-01,-2.4165852569462d-01, 5.0291661904459d-01,
     |   8.6481931665266d-01, 6.1385434712976d-01,-5.6789201597749d-02,
     |  -6.6862450746390d-01,-7.9241432764567d-01,-3.4685079828818d-01,
     |   3.4685079828818d-01, 7.9241432764567d-01, 6.6862450746390d-01,
     |   5.6789201597750d-02,-6.1385434712976d-01,-8.6481931665266d-01,
     |  -5.0291661904460d-01, 2.4165852569462d-01, 8.6813467120679d-01,
     |   9.4119665802291d-01, 3.7804619470815d-01,-5.0699260377914d-01,
     |  -1.2219013478713d+00,-1.4199211410033d+00,-1.1010388033107d+00,
     |  -5.6226548426070d-01,-1.5004013524142d-01,-6.1552481958767d-03/
      data (pmn(lat, 4,10), lat = 1,36)/
     |   3.3326928627493d-04, 2.4935221293294d-02, 1.6360720457465d-01,
     |   4.8824405665859d-01, 9.3328197411313d-01, 1.2764443411038d+00,
     |   1.2599447773108d+00, 7.7901519293241d-01,-1.2186334098623d-03,
     |  -7.0336985970816d-01,-9.5412649049544d-01,-6.2491872108237d-01,
     |   6.8298319371606d-02, 6.8596602599283d-01, 8.3877650995838d-01,
     |   4.3811221000650d-01,-2.4492043575612d-01,-7.5595049791002d-01,
     |  -7.5595049791002d-01,-2.4492043575612d-01, 4.3811221000650d-01,
     |   8.3877650995838d-01, 6.8596602599283d-01, 6.8298319371603d-02,
     |  -6.2491872108237d-01,-9.5412649049544d-01,-7.0336985970816d-01,
     |  -1.2186334098638d-03, 7.7901519293241d-01, 1.2599447773108d+00,
     |   1.2764443411038d+00, 9.3328197411313d-01, 4.8824405665859d-01,
     |   1.6360720457466d-01, 2.4935221293294d-02, 3.3326928627493d-04/
      data (pmn(lat, 5,10), lat = 1,36)/
     |   1.3821728523595d-05, 3.1509902696115d-03, 3.5599968683532d-02,
     |   1.5688801982031d-01, 4.1833073880219d-01, 7.9267843460865d-01,
     |   1.1387115665957d+00, 1.2506096962775d+00, 9.8101572248393d-01,
     |   3.6239037352661d-01,-3.6521341784337d-01,-8.6051452592587d-01,
     |  -8.7245592137144d-01,-4.0095114551899d-01, 2.8227609372002d-01,
     |   7.7961339154056d-01, 7.9969222006932d-01, 3.3410555827003d-01,
     |  -3.3410555827003d-01,-7.9969222006932d-01,-7.7961339154056d-01,
     |  -2.8227609372002d-01, 4.0095114551899d-01, 8.7245592137144d-01,
     |   8.6051452592587d-01, 3.6521341784337d-01,-3.6239037352661d-01,
     |  -9.8101572248393d-01,-1.2506096962775d+00,-1.1387115665957d+00,
     |  -7.9267843460865d-01,-4.1833073880219d-01,-1.5688801982031d-01,
     |  -3.5599968683532d-02,-3.1509902696115d-03,-1.3821728523595d-05/
      data (pmn(lat, 6,10), lat = 1,36)/
     |   4.5014724541222d-07, 3.1139407233950d-04, 6.0034613261250d-03,
     |   3.8456172438425d-02, 1.3925194047582d-01, 3.4858027703058d-01,
     |   6.6202208725283d-01, 9.9593079706317d-01, 1.1982494557143d+00,
     |   1.1173014916578d+00, 6.9868823327999d-01, 4.9910982491262d-02,
     |  -5.8022082268913d-01,-9.1325925959305d-01,-7.9015034697807d-01,
     |  -2.7145150652702d-01, 3.7748562233329d-01, 8.1811575339878d-01,
     |   8.1811575339878d-01, 3.7748562233330d-01,-2.7145150652702d-01,
     |  -7.9015034697807d-01,-9.1325925959305d-01,-5.8022082268913d-01,
     |   4.9910982491258d-02, 6.9868823327999d-01, 1.1173014916578d+00,
     |   1.1982494557143d+00, 9.9593079706317d-01, 6.6202208725283d-01,
     |   3.4858027703058d-01, 1.3925194047582d-01, 3.8456172438425d-02,
     |   6.0034613261251d-03, 3.1139407233950d-04, 4.5014724541222d-07/
      data (pmn(lat, 7,10), lat = 1,36)/
     |   1.1581739806560d-08, 2.4248700955252d-05, 7.9340300285864d-04,
     |   7.3196828168445d-03, 3.5476074324496d-02, 1.1465463335188d-01,
     |   2.7710330439231d-01, 5.3227768503689d-01, 8.3886359789227d-01,
     |   1.0968067561019d+00, 1.1763021671155d+00, 9.7963019474782d-01,
     |   5.0677295971251d-01,-1.1559204078658d-01,-6.6871382955562d-01,
     |  -9.3318326757925d-01,-7.9506834848872d-01,-3.1040855241314d-01,
     |   3.1040855241314d-01, 7.9506834848872d-01, 9.3318326757925d-01,
     |   6.6871382955562d-01, 1.1559204078658d-01,-5.0677295971252d-01,
     |  -9.7963019474782d-01,-1.1763021671155d+00,-1.0968067561019d+00,
     |  -8.3886359789227d-01,-5.3227768503689d-01,-2.7710330439232d-01,
     |  -1.1465463335188d-01,-3.5476074324496d-02,-7.3196828168446d-03,
     |  -7.9340300285865d-04,-2.4248700955252d-05,-1.1581739806560d-08/
      data (pmn(lat, 8,10), lat = 1,36)/
     |   2.3230206586841d-10, 1.4695682730374d-06, 8.1312863011385d-05,
     |   1.0741325287560d-03, 6.9068205840062d-03, 2.8444892576104d-02,
     |   8.5777981754984d-02, 2.0396536921528d-01, 3.9945836662434d-01,
     |   6.6095819855637d-01, 9.3556720451924d-01, 1.1329882356697d+00,
     |   1.1537033743940d+00, 9.3361100041584d-01, 4.8498827752475d-01,
     |  -8.9528581794183d-02,-6.2302015799960d-01,-9.4388277832401d-01,
     |  -9.4388277832401d-01,-6.2302015799960d-01,-8.9528581794185d-02,
     |   4.8498827752474d-01, 9.3361100041584d-01, 1.1537033743940d+00,
     |   1.1329882356697d+00, 9.3556720451924d-01, 6.6095819855637d-01,
     |   3.9945836662434d-01, 2.0396536921528d-01, 8.5777981754984d-02,
     |   2.8444892576104d-02, 6.9068205840062d-03, 1.0741325287560d-03,
     |   8.1312863011387d-05, 1.4695682730374d-06, 2.3230206586841d-10/
      data (pmn(lat, 9,10), lat = 1,36)/
     |   3.4738532802953d-12, 6.6321837624520d-08, 6.1904359564184d-06,
     |   1.1662850399436d-04, 9.8919350800039d-04, 5.1485897585245d-03,
     |   1.9146388815381d-02, 5.5411482726708d-02, 1.3148916423231d-01,
     |   2.6452716113931d-01, 4.6105844965515d-01, 7.0564816530447d-01,
     |   9.5471749659841d-01, 1.1415284510451d+00, 1.1940603697125d+00,
     |   1.0609119347375d+00, 7.3489235693045d-01, 2.6306713035427d-01,
     |  -2.6306713035427d-01,-7.3489235693045d-01,-1.0609119347375d+00,
     |  -1.1940603697125d+00,-1.1415284510451d+00,-9.5471749659841d-01,
     |  -7.0564816530447d-01,-4.6105844965515d-01,-2.6452716113931d-01,
     |  -1.3148916423231d-01,-5.5411482726708d-02,-1.9146388815381d-02,
     |  -5.1485897585245d-03,-9.8919350800039d-04,-1.1662850399436d-04,
     |  -6.1904359564185d-06,-6.6321837624520d-08,-3.4738532802953d-12/
      data (pmn(lat,10,10), lat = 1,36)/
     |   3.3914825325012d-14, 1.9524083470880d-09, 3.0687497535415d-07,
     |   8.2226538790885d-06, 9.1620060514287d-05, 5.9930785022305d-04,
     |   2.7274651394487d-03, 9.5074761966034d-03, 2.6941850928495d-02,
     |   6.4550975779778d-02, 1.3435706695850d-01, 2.4767711866174d-01,
     |   4.1009380433122d-01, 6.1623651339732d-01, 8.4681586168113d-01,
     |   1.0700623893840d+00, 1.2481869287369d+00, 1.3472819113196d+00,
     |   1.3472819113196d+00, 1.2481869287369d+00, 1.0700623893840d+00,
     |   8.4681586168113d-01, 6.1623651339732d-01, 4.1009380433122d-01,
     |   2.4767711866174d-01, 1.3435706695850d-01, 6.4550975779779d-02,
     |   2.6941850928495d-02, 9.5074761966034d-03, 2.7274651394487d-03,
     |   5.9930785022305d-04, 9.1620060514287d-05, 8.2226538790886d-06,
     |   3.0687497535416d-07, 1.9524083470880d-09, 3.3914825325012d-14/
      data (pmn(lat, 0,11), lat = 1,36)/
     |   3.1814137494382d+00, 1.7271361213810d+00,-1.8111199719984d-01,
     |  -1.3054125303963d+00,-1.0871303075494d+00, 1.5172141078943d-03,
     |   9.1947949377894d-01, 9.2226571184447d-01, 1.1690203681612d-01,
     |  -7.1829246766781d-01,-8.4997753956106d-01,-2.1217002302313d-01,
     |   5.8203495198006d-01, 8.1442295302425d-01, 2.9855927403239d-01,
     |  -4.7569155212719d-01,-7.9929529364908d-01,-3.8410591469203d-01,
     |   3.8410591469203d-01, 7.9929529364908d-01, 4.7569155212720d-01,
     |  -2.9855927403239d-01,-8.1442295302425d-01,-5.8203495198006d-01,
     |   2.1217002302312d-01, 8.4997753956106d-01, 7.1829246766781d-01,
     |  -1.1690203681612d-01,-9.2226571184447d-01,-9.1947949377894d-01,
     |  -1.5172141078943d-03, 1.0871303075494d+00, 1.3054125303963d+00,
     |   1.8111199719985d-01,-1.7271361213810d+00,-3.1814137494382d+00/
      data (pmn(lat, 1,11), lat = 1,36)/
     |   8.2371544085289d-01, 1.8966140527791d+00, 1.6869233227126d+00,
     |   4.5642884391476d-01,-8.0453579253107d-01,-1.1776660649025d+00,
     |  -5.1932189503190d-01, 4.9241223865298d-01, 9.7107386846804d-01,
     |   5.6127997175713d-01,-3.0967887735828d-01,-8.4969094511800d-01,
     |  -6.0305463272612d-01, 1.7318193888861d-01, 7.6565168453516d-01,
     |   6.4871695916762d-01,-5.5913328382017d-02,-7.0139921910185d-01,
     |  -7.0139921910185d-01,-5.5913328382018d-02, 6.4871695916762d-01,
     |   7.6565168453516d-01, 1.7318193888861d-01,-6.0305463272613d-01,
     |  -8.4969094511800d-01,-3.0967887735828d-01, 5.6127997175713d-01,
     |   9.7107386846804d-01, 4.9241223865298d-01,-5.1932189503189d-01,
     |  -1.1776660649025d+00,-8.0453579253107d-01, 4.5642884391475d-01,
     |   1.6869233227125d+00, 1.8966140527791d+00, 8.2371544085289d-01/
      data (pmn(lat, 2,11), lat = 1,36)/
     |   1.0355507314347d-01, 7.8664602736683d-01, 1.5172452239071d+00,
     |   1.5693429646878d+00, 7.5475524909693d-01,-3.9835820764367d-01,
     |  -1.0695160601629d+00,-8.1676712769521d-01, 6.8093046961359d-02,
     |   8.1401410912243d-01, 8.1480869727584d-01, 1.1884331867665d-01,
     |  -6.4156208511265d-01,-8.0808080321150d-01,-2.5850116957551d-01,
     |   5.0456393739356d-01, 8.0412902386869d-01, 3.8167753675338d-01,
     |  -3.8167753675337d-01,-8.0412902386869d-01,-5.0456393739356d-01,
     |   2.5850116957551d-01, 8.0808080321149d-01, 6.4156208511265d-01,
     |  -1.1884331867664d-01,-8.1480869727584d-01,-8.1401410912243d-01,
     |  -6.8093046961361d-02, 8.1676712769521d-01, 1.0695160601629d+00,
     |   3.9835820764367d-01,-7.5475524909693d-01,-1.5693429646878d+00,
     |  -1.5172452239071d+00,-7.8664602736683d-01,-1.0355507314347d-01/
      data (pmn(lat, 3,11), lat = 1,36)/
     |   8.4992136996255d-03, 2.0275790614451d-01, 7.2530412123584d-01,
     |   1.3100424872603d+00, 1.4665230872753d+00, 9.2352149525425d-01,
     |  -7.0738270071349d-02,-8.7947567017208d-01,-9.5988688166801d-01,
     |  -3.0431703865933d-01, 5.3735378440600d-01, 8.9005240983510d-01,
     |   4.9354032362559d-01,-2.9518558917809d-01,-8.0675414088792d-01,
     |  -6.1907278878733d-01, 9.4518934382429d-02, 7.1838388705384d-01,
     |   7.1838388705384d-01, 9.4518934382430d-02,-6.1907278878733d-01,
     |  -8.0675414088792d-01,-2.9518558917809d-01, 4.9354032362559d-01,
     |   8.9005240983510d-01, 5.3735378440600d-01,-3.0431703865933d-01,
     |  -9.5988688166801d-01,-8.7947567017208d-01,-7.0738270071354d-02,
     |   9.2352149525425d-01, 1.4665230872753d+00, 1.3100424872603d+00,
     |   7.2530412123584d-01, 2.0275790614451d-01, 8.4992136996255d-03/
      data (pmn(lat, 4,11), lat = 1,36)/
     |   5.0948918950789d-04, 3.7474761086878d-02, 2.3723483450241d-01,
     |   6.6764755915069d-01, 1.1658176869874d+00, 1.3798929130316d+00,
     |   1.0351104579577d+00, 2.0916230210534d-01,-6.4353190717011d-01,
     |  -9.8685152735888d-01,-6.0909017588182d-01, 1.8879472401415d-01,
     |   7.9812684435713d-01, 7.6106645220039d-01, 1.2556145367560d-01,
     |  -5.9219643776071d-01,-8.1717138183267d-01,-3.7392360063278d-01,
     |   3.7392360063278d-01, 8.1717138183267d-01, 5.9219643776071d-01,
     |  -1.2556145367560d-01,-7.6106645220039d-01,-7.9812684435713d-01,
     |  -1.8879472401416d-01, 6.0909017588182d-01, 9.8685152735888d-01,
     |   6.4353190717011d-01,-2.0916230210534d-01,-1.0351104579577d+00,
     |  -1.3798929130316d+00,-1.1658176869874d+00,-6.6764755915069d-01,
     |  -2.3723483450241d-01,-3.7474761086878d-02,-5.0948918950789d-04/
      data (pmn(lat, 5,11), lat = 1,36)/
     |   2.3579907124501d-05, 5.3001000888196d-03, 5.8156346291750d-02,
     |   2.4466243153890d-01, 6.0959125508126d-01, 1.0478428029436d+00,
     |   1.3014528726657d+00, 1.1163991651784d+00, 4.6269458568788d-01,
     |  -3.6857549675161d-01,-9.0951352663805d-01,-8.3037203603426d-01,
     |  -1.9679051640150d-01, 5.4384821276896d-01, 8.6499662519370d-01,
     |   5.4155773099865d-01,-1.7916123376038d-01,-7.5593915612278d-01,
     |  -7.5593915612278d-01,-1.7916123376038d-01, 5.4155773099865d-01,
     |   8.6499662519370d-01, 5.4384821276896d-01,-1.9679051640150d-01,
     |  -8.3037203603426d-01,-9.0951352663805d-01,-3.6857549675161d-01,
     |   4.6269458568788d-01, 1.1163991651784d+00, 1.3014528726657d+00,
     |   1.0478428029436d+00, 6.0959125508126d-01, 2.4466243153890d-01,
     |   5.8156346291751d-02, 5.3001000888196d-03, 2.3579907124501d-05/
      data (pmn(lat, 6,11), lat = 1,36)/
     |   8.6735735386305d-07, 5.9279909281060d-04, 1.1149631653094d-02,
     |   6.8714590116113d-02, 2.3555412611754d-01, 5.4710196805618d-01,
     |   9.3807950865748d-01, 1.2214095164066d+00, 1.1743077475985d+00,
     |   6.9968604955847d-01,-5.2768747268501d-02,-7.2162634648387d-01,
     |  -9.3776944753370d-01,-5.7445164235882d-01, 1.3847276365420d-01,
     |   7.3942461900692d-01, 8.3293773623357d-01, 3.5914485761508d-01,
     |  -3.5914485761508d-01,-8.3293773623357d-01,-7.3942461900693d-01,
     |  -1.3847276365420d-01, 5.7445164235881d-01, 9.3776944753370d-01,
     |   7.2162634648388d-01, 5.2768747268501d-02,-6.9968604955847d-01,
     |  -1.1743077475985d+00,-1.2214095164066d+00,-9.3807950865748d-01,
     |  -5.4710196805618d-01,-2.3555412611754d-01,-6.8714590116113d-02,
     |  -1.1149631653094d-02,-5.9279909281060d-04,-8.6735735386305d-07/
      data (pmn(lat, 7,11), lat = 1,36)/
     |   2.5678253800732d-08, 5.3198654073607d-05, 1.7036826922442d-03,
     |   1.5205138220836d-02, 7.0367603355846d-02, 2.1387365714289d-01,
     |   4.7706635016307d-01, 8.2495218405432d-01, 1.1284480398042d+00,
     |   1.2033688949608d+00, 9.1703372082696d-01, 3.0248516732425d-01,
     |  -4.0799450359630d-01,-8.7995073403783d-01,-8.6563283749286d-01,
     |  -3.6917979775745d-01, 3.2943973729353d-01, 8.2459325403211d-01,
     |   8.2459325403211d-01, 3.2943973729353d-01,-3.6917979775744d-01,
     |  -8.6563283749286d-01,-8.7995073403783d-01,-4.0799450359629d-01,
     |   3.0248516732425d-01, 9.1703372082696d-01, 1.2033688949608d+00,
     |   1.1284480398042d+00, 8.2495218405432d-01, 4.7706635016307d-01,
     |   2.1387365714289d-01, 7.0367603355846d-02, 1.5205138220837d-02,
     |   1.7036826922443d-03, 5.3198654073607d-05, 2.5678253800732d-08/
      data (pmn(lat, 8,11), lat = 1,36)/
     |   6.1110798719883d-10, 3.8299295920752d-06, 2.0793448537069d-04,
     |   2.6680686397770d-03, 1.6482518032935d-02, 6.4419895051471d-02,
     |   1.8174483601953d-01, 3.9735637472733d-01, 6.9975557517865d-01,
     |   1.0094036906071d+00, 1.1874460209211d+00, 1.0947499596996d+00,
     |   6.7941735566635d-01, 3.9792318577172d-02,-5.8899389977837d-01,
     |  -9.3608852120136d-01,-8.3676398354549d-01,-3.3300978662112d-01,
     |   3.3300978662112d-01, 8.3676398354549d-01, 9.3608852120136d-01,
     |   5.8899389977837d-01,-3.9792318577172d-02,-6.7941735566636d-01,
     |  -1.0947499596996d+00,-1.1874460209211d+00,-1.0094036906071d+00,
     |  -6.9975557517865d-01,-3.9735637472733d-01,-1.8174483601953d-01,
     |  -6.4419895051471d-02,-1.6482518032935d-02,-2.6680686397771d-03,
     |  -2.0793448537069d-04,-3.8299295920752d-06,-6.1110798719883d-10/
      data (pmn(lat, 9,11), lat = 1,36)/
     |   1.1484465760641d-11, 2.1742168481378d-07, 1.9952092913852d-05,
     |   3.6628097466946d-04, 2.9985351477074d-03, 1.4908940418523d-02,
     |   5.2356014646280d-02, 1.4120279495353d-01, 3.0736065403618d-01,
     |   5.5621750817675d-01, 8.4999531828289d-01, 1.1001748475487d+00,
     |   1.1897456586462d+00, 1.0243980194529d+00, 5.9063862410459d-01,
     |  -1.3165355054197d-02,-5.9832198135265d-01,-9.5808179442291d-01,
     |  -9.5808179442291d-01,-5.9832198135265d-01,-1.3165355054200d-02,
     |   5.9063862410459d-01, 1.0243980194529d+00, 1.1897456586463d+00,
     |   1.1001748475487d+00, 8.4999531828289d-01, 5.5621750817675d-01,
     |   3.0736065403618d-01, 1.4120279495353d-01, 5.2356014646281d-02,
     |   1.4908940418523d-02, 2.9985351477074d-03, 3.6628097466946d-04,
     |   1.9952092913852d-05, 2.1742168481378d-07, 1.1484465760641d-11/
      data (pmn(lat,10,11), lat = 1,36)/
     |   1.6249498184302d-13, 9.2833161284185d-09, 1.4368350239868d-06,
     |   3.7609315500250d-05, 4.0594746919235d-04, 2.5494283354967d-03,
     |   1.1031950849855d-02, 3.6173940455983d-02, 9.5262556265577d-02,
     |   2.0914624692045d-01, 3.9225777483513d-01, 6.3821400287941d-01,
     |   9.0813983437322d-01, 1.1309697948797d+00, 1.2212222443769d+00,
     |   1.1107332387322d+00, 7.8134208478399d-01, 2.8183956416592d-01,
     |  -2.8183956416592d-01,-7.8134208478399d-01,-1.1107332387322d+00,
     |  -1.2212222443769d+00,-1.1309697948797d+00,-9.0813983437321d-01,
     |  -6.3821400287941d-01,-3.9225777483513d-01,-2.0914624692045d-01,
     |  -9.5262556265577d-02,-3.6173940455983d-02,-1.1031950849855d-02,
     |  -2.5494283354967d-03,-4.0594746919235d-04,-3.7609315500251d-05,
     |  -1.4368350239868d-06,-9.2833161284185d-09,-1.6249498184302d-13/
      data (pmn(lat,11,11), lat = 1,36)/
     |   1.5125917378025d-15, 2.6056789350496d-10, 6.7912669628310d-08,
     |   2.5281706857140d-06, 3.5849476029570d-05, 2.8294898728818d-04,
     |   1.4984018826930d-03, 5.9178636169482d-03, 1.8610727596997d-02,
     |   4.8661587568862d-02, 1.0898826693321d-01, 2.1358347889227d-01,
     |   3.7193299697747d-01, 5.8212379397590d-01, 8.2577373118456d-01,
     |   1.0681769211516d+00, 1.2653211693470d+00, 1.3762505565544d+00,
     |   1.3762505565544d+00, 1.2653211693470d+00, 1.0681769211516d+00,
     |   8.2577373118456d-01, 5.8212379397590d-01, 3.7193299697747d-01,
     |   2.1358347889227d-01, 1.0898826693321d-01, 4.8661587568863d-02,
     |   1.8610727596997d-02, 5.9178636169482d-03, 1.4984018826930d-03,
     |   2.8294898728818d-04, 3.5849476029570d-05, 2.5281706857140d-06,
     |   6.7912669628312d-08, 2.6056789350496d-10, 1.5125917378025d-15/
      data (pmn(lat, 0,12), lat = 1,36)/
     |   3.2778313966561d+00, 1.5381500234437d+00,-5.4880145577473d-01,
     |  -1.4349979645414d+00,-7.3981161307230d-01, 5.4420273763147d-01,
     |   1.0870204775794d+00, 4.6361378653962d-01,-5.6499994916929d-01,
     |  -9.1899901408518d-01,-2.9422247193351d-01, 5.9647063004334d-01,
     |   8.1414130111229d-01, 1.6522531319723d-01,-6.3529037422454d-01,
     |  -7.3953303338013d-01,-5.3436006147602d-02, 6.8199331220689d-01,
     |   6.8199331220689d-01,-5.3436006147601d-02,-7.3953303338013d-01,
     |  -6.3529037422454d-01, 1.6522531319723d-01, 8.1414130111229d-01,
     |   5.9647063004335d-01,-2.9422247193351d-01,-9.1899901408518d-01,
     |  -5.6499994916929d-01, 4.6361378653961d-01, 1.0870204775794d+00,
     |   5.4420273763147d-01,-7.3981161307230d-01,-1.4349979645414d+00,
     |  -5.4880145577474d-01, 1.5381500234437d+00, 3.2778313966561d+00/
      data (pmn(lat, 1,12), lat = 1,36)/
     |   9.2821651205645d-01, 2.0291559409280d+00, 1.5401909708776d+00,
     |   2.4267138504691d-02,-1.1295609005351d+00,-1.0011001267598d+00,
     |   7.4815695967059d-02, 9.3702831058979d-01, 7.6572580750727d-01,
     |  -1.6680718763633d-01,-8.5625549450587d-01,-6.1707414074851d-01,
     |   2.5008365359980d-01, 8.1724429684019d-01, 5.0601920346114d-01,
     |  -3.3053664572612d-01,-8.0078041000858d-01,-4.1372254757215d-01,
     |   4.1372254757215d-01, 8.0078041000858d-01, 3.3053664572612d-01,
     |  -5.0601920346114d-01,-8.1724429684019d-01,-2.5008365359980d-01,
     |   6.1707414074850d-01, 8.5625549450587d-01, 1.6680718763633d-01,
     |  -7.6572580750727d-01,-9.3702831058979d-01,-7.4815695967064d-02,
     |   1.0011001267598d+00, 1.1295609005351d+00,-2.4267138504684d-02,
     |  -1.5401909708776d+00,-2.0291559409280d+00,-9.2821651205645d-01/
      data (pmn(lat, 2,12), lat = 1,36)/
     |   1.2725602326766d-01, 9.3591917590815d-01, 1.6720208441234d+00,
     |   1.4566901925800d+00, 3.0510404241642d-01,-8.5766001747594d-01,
     |  -1.0751295768289d+00,-2.6980695017383d-01, 7.0333302218437d-01,
     |   9.0031318095387d-01, 1.9023720243446d-01,-6.6368827931889d-01,
     |  -7.9842961664259d-01,-1.1173832583456d-01, 6.6511569524926d-01,
     |   7.3250985202361d-01, 3.6791138421476d-02,-6.8931875377148d-01,
     |  -6.8931875377149d-01, 3.6791138421474d-02, 7.3250985202361d-01,
     |   6.6511569524926d-01,-1.1173832583456d-01,-7.9842961664259d-01,
     |  -6.6368827931889d-01, 1.9023720243446d-01, 9.0031318095387d-01,
     |   7.0333302218437d-01,-2.6980695017383d-01,-1.0751295768289d+00,
     |  -8.5766001747594d-01, 3.0510404241642d-01, 1.4566901925799d+00,
     |   1.6720208441234d+00, 9.3591917590815d-01, 1.2725602326766d-01/
      data (pmn(lat, 3,12), lat = 1,36)/
     |   1.1406824557200d-02, 2.6576022407770d-01, 9.0261470096185d-01,
     |   1.4843072487366d+00, 1.3850907077638d+00, 4.7627287428974d-01,
     |  -6.2697955394964d-01,-1.0642781928619d+00,-5.2518645302833d-01,
     |   4.3845563448804d-01, 9.1527207538741d-01, 4.8715651566581d-01,
     |  -3.8914236255511d-01,-8.4318533386391d-01,-4.4423068084940d-01,
     |   3.8795230832124d-01, 8.1296916312416d-01, 4.0937314255865d-01,
     |  -4.0937314255864d-01,-8.1296916312416d-01,-3.8795230832124d-01,
     |   4.4423068084940d-01, 8.4318533386391d-01, 3.8914236255510d-01,
     |  -4.8715651566580d-01,-9.1527207538741d-01,-4.3845563448804d-01,
     |   5.2518645302833d-01, 1.0642781928619d+00, 6.2697955394965d-01,
     |  -4.7627287428974d-01,-1.3850907077638d+00,-1.4843072487366d+00,
     |  -9.0261470096185d-01,-2.6576022407770d-01,-1.1406824557200d-02/
      data (pmn(lat, 4,12), lat = 1,36)/
     |   7.4948277946502d-04, 5.4106148576341d-02, 3.2921677549623d-01,
     |   8.6708237546089d-01, 1.3605568765749d+00, 1.3328014293703d+00,
     |   6.0521914792772d-01,-4.1812660694027d-01,-1.0044064802520d+00,
     |  -7.1799300936376d-01, 1.5699645070289d-01, 8.3255047782674d-01,
     |   7.1360646916511d-01,-6.0586949187121d-02,-7.4886356169284d-01,
     |  -7.0461125903402d-01, 1.5964911981448d-02, 7.1246981573249d-01,
     |   7.1246981573249d-01, 1.5964911981449d-02,-7.0461125903402d-01,
     |  -7.4886356169284d-01,-6.0586949187122d-02, 7.1360646916512d-01,
     |   8.3255047782674d-01, 1.5699645070289d-01,-7.1799300936376d-01,
     |  -1.0044064802520d+00,-4.1812660694027d-01, 6.0521914792771d-01,
     |   1.3328014293703d+00, 1.3605568765749d+00, 8.6708237546089d-01,
     |   3.2921677549624d-01, 5.4106148576341d-02, 7.4948277946502d-04/
      data (pmn(lat, 5,12), lat = 1,36)/
     |   3.8238029508593d-05, 8.4628819982664d-03, 8.9919354301084d-02,
     |   3.5916817121437d-01, 8.2802178713110d-01, 1.2662621448269d+00,
     |   1.2968538465173d+00, 7.2132585212911d-01,-2.1151788349216d-01,
     |  -9.0249609508984d-01,-8.5916709451647d-01,-1.3743321987021d-01,
     |   6.5525737544500d-01, 8.5041488051764d-01, 2.9513551474646d-01,
     |  -5.0635781680885d-01,-8.3509653044902d-01,-3.9990219120455d-01,
     |   3.9990219120454d-01, 8.3509653044902d-01, 5.0635781680885d-01,
     |  -2.9513551474646d-01,-8.5041488051764d-01,-6.5525737544499d-01,
     |   1.3743321987021d-01, 8.5916709451647d-01, 9.0249609508985d-01,
     |   2.1151788349216d-01,-7.2132585212911d-01,-1.2968538465173d+00,
     |  -1.2662621448269d+00,-8.2802178713110d-01,-3.5916817121437d-01,
     |  -8.9919354301085d-02,-8.4628819982664d-03,-3.8238029508593d-05/
      data (pmn(lat, 6,12), lat = 1,36)/
     |   1.5637065808778d-06, 1.0547026880168d-03, 1.9305669182306d-02,
     |   1.1398939715322d-01, 3.6735332884663d-01, 7.8233311559469d-01,
     |   1.1847263512396d+00, 1.2718654072321d+00, 8.3786213099518d-01,
     |   9.2037941650838d-03,-7.5042488936009d-01,-9.4295732707067d-01,
     |  -4.3750273266484d-01, 3.7675754411429d-01, 8.6091380660825d-01,
     |   6.3203189788968d-01,-1.1453094838709d-01,-7.5575737653138d-01,
     |  -7.5575737653138d-01,-1.1453094838709d-01, 6.3203189788968d-01,
     |   8.6091380660825d-01, 3.7675754411429d-01,-4.3750273266485d-01,
     |  -9.4295732707067d-01,-7.5042488936009d-01, 9.2037941650826d-03,
     |   8.3786213099518d-01, 1.2718654072321d+00, 1.1847263512396d+00,
     |   7.8233311559469d-01, 3.6735332884663d-01, 1.1398939715322d-01,
     |   1.9305669182306d-02, 1.0547026880168d-03, 1.5637065808778d-06/
      data (pmn(lat, 7,12), lat = 1,36)/
     |   5.2112597373629d-08, 1.0672700049049d-04, 3.3384325045667d-03,
     |   2.8723722392357d-02, 1.2624344635391d-01, 3.5781491670368d-01,
     |   7.2666190976199d-01, 1.1045591637968d+00, 1.2500306576304d+00,
     |   9.5828633852979d-01, 2.5608798697399d-01,-5.3067671162028d-01,
     |  -9.4485023382837d-01,-7.1865974599295d-01,-5.2024503901496d-03,
     |   6.8982069846928d-01, 8.6100295076962d-01, 3.8333764260939d-01,
     |  -3.8333764260939d-01,-8.6100295076962d-01,-6.8982069846928d-01,
     |   5.2024503901485d-03, 7.1865974599295d-01, 9.4485023382837d-01,
     |   5.3067671162029d-01,-2.5608798697399d-01,-9.5828633852979d-01,
     |  -1.2500306576304d+00,-1.1045591637968d+00,-7.2666190976199d-01,
     |  -3.5781491670368d-01,-1.2624344635391d-01,-2.8723722392357d-02,
     |  -3.3384325045668d-03,-1.0672700049049d-04,-5.2112597373629d-08/
      data (pmn(lat, 8,12), lat = 1,36)/
     |   1.4228445867055d-09, 8.8265608218851d-06, 4.6936018542038d-04,
     |   5.8326407710964d-03, 3.4464072663691d-02, 1.2699529421604d-01,
     |   3.3194141092875d-01, 6.5730469138314d-01, 1.0152447628721d+00,
     |   1.2195237408302d+00, 1.0763390397802d+00, 5.3349322543902d-01,
     |  -2.2147596799802d-01,-8.1901703698578d-01,-9.2150086497114d-01,
     |  -4.6072400931103d-01, 2.8098005427935d-01, 8.3035970097765d-01,
     |   8.3035970097766d-01, 2.8098005427935d-01,-4.6072400931102d-01,
     |  -9.2150086497114d-01,-8.1901703698578d-01,-2.2147596799802d-01,
     |   5.3349322543902d-01, 1.0763390397802d+00, 1.2195237408302d+00,
     |   1.0152447628721d+00, 6.5730469138314d-01, 3.3194141092875d-01,
     |   1.2699529421604d-01, 3.4464072663691d-02, 5.8326407710965d-03,
     |   4.6936018542039d-04, 8.8265608218851d-06, 1.4228445867055d-09/
      data (pmn(lat, 9,12), lat = 1,36)/
     |   3.1642409765692d-11, 5.9357074297309d-07, 5.3466288551421d-05,
     |   9.5395549544706d-04, 7.5092750530432d-03, 3.5475887468308d-02,
     |   1.1675521546584d-01, 2.9025890275297d-01, 5.7029251864439d-01,
     |   9.0527021328502d-01, 1.1624013147242d+00, 1.1723461349849d+00,
     |   8.2964400171199d-01, 1.9188226714063d-01,-5.0154602006680d-01,
     |  -9.3096638372347d-01,-8.7485318593123d-01,-3.5496498505286d-01,
     |   3.5496498505286d-01, 8.7485318593123d-01, 9.3096638372347d-01,
     |   5.0154602006680d-01,-1.9188226714063d-01,-8.2964400171199d-01,
     |  -1.1723461349849d+00,-1.1624013147242d+00,-9.0527021328502d-01,
     |  -5.7029251864439d-01,-2.9025890275297d-01,-1.1675521546584d-01,
     |  -3.5475887468308d-02,-7.5092750530432d-03,-9.5395549544707d-04,
     |  -5.3466288551422d-05,-5.9357074297309d-07,-3.1642409765692d-11/
      data (pmn(lat,10,12), lat = 1,36)/
     |   5.6129503523889d-13, 3.1800346164513d-08, 4.8397122186583d-06,
     |   1.2346686694400d-04, 1.2867298483019d-03, 7.7230957498796d-03,
     |   3.1578914739050d-02, 9.6579158884758d-02, 2.3359064573723d-01,
     |   4.6213124764672d-01, 7.6195404784299d-01, 1.0529316628986d+00,
     |   1.2067639571915d+00, 1.1000759675761d+00, 6.8921776412399d-01,
     |   6.2478813901980d-02,-5.7217893719775d-01,-9.7111041105916d-01,
     |  -9.7111041105916d-01,-5.7217893719775d-01, 6.2478813901978d-02,
     |   6.8921776412399d-01, 1.1000759675761d+00, 1.2067639571915d+00,
     |   1.0529316628986d+00, 7.6195404784299d-01, 4.6213124764672d-01,
     |   2.3359064573723d-01, 9.6579158884758d-02, 3.1578914739051d-02,
     |   7.7230957498796d-03, 1.2867298483019d-03, 1.2346686694400d-04,
     |   4.8397122186584d-06, 3.1800346164513d-08, 5.6129503523889d-13/
      data (pmn(lat,11,12), lat = 1,36)/
     |   7.5557604281550d-15, 1.2916934952724d-09, 3.3151434095487d-07,
     |   1.2055796186751d-05, 1.6560298577487d-04, 1.2548940848071d-03,
     |   6.3186966512660d-03, 2.3474784339469d-02, 6.8606338394064d-02,
     |   1.6437646024278d-01, 3.3173926561723d-01, 5.7379159779085d-01,
     |   8.5869772785349d-01, 1.1138456577004d+00, 1.2415747502274d+00,
     |   1.1559790021582d+00, 8.2578777085142d-01, 3.0015603069052d-01,
     |  -3.0015603069052d-01,-8.2578777085142d-01,-1.1559790021582d+00,
     |  -1.2415747502274d+00,-1.1138456577004d+00,-8.5869772785349d-01,
     |  -5.7379159779085d-01,-3.3173926561723d-01,-1.6437646024278d-01,
     |  -6.8606338394064d-02,-2.3474784339469d-02,-6.3186966512661d-03,
     |  -1.2548940848071d-03,-1.6560298577487d-04,-1.2055796186751d-05,
     |  -3.3151434095488d-07,-1.2916934952724d-09,-7.5557604281550d-15/
      data (pmn(lat,12,12), lat = 1,36)/
     |   6.7338845907807d-17, 3.4712265130123d-11, 1.5002095884627d-08,
     |   7.7591219719407d-07, 1.4001896288712d-05, 1.3334542722776d-04,
     |   8.2169230049758d-04, 3.6768546620231d-03, 1.2832494357425d-02,
     |   3.6616897247097d-02, 8.8249201572254d-02, 1.8384898282941d-01,
     |   3.3671155238296d-01, 5.4890233795292d-01, 8.0379434863287d-01,
     |   1.0643613288140d+00, 1.2803647933540d+00, 1.4032929460387d+00,
     |   1.4032929460387d+00, 1.2803647933540d+00, 1.0643613288140d+00,
     |   8.0379434863287d-01, 5.4890233795292d-01, 3.3671155238296d-01,
     |   1.8384898282941d-01, 8.8249201572254d-02, 3.6616897247097d-02,
     |   1.2832494357425d-02, 3.6768546620232d-03, 8.2169230049759d-04,
     |   1.3334542722776d-04, 1.4001896288712d-05, 7.7591219719408d-07,
     |   1.5002095884627d-08, 3.4712265130123d-11, 6.7338845907807d-17/
      data (pmn(lat, 0,13), lat = 1,36)/
     |   3.3627542533373d+00, 1.3203668595139d+00,-8.8965716106068d-01,
     |  -1.4295580475482d+00,-2.7871200993498d-01, 9.6319570035643d-01,
     |   9.1261309108182d-01,-1.8730954487536d-01,-9.4942394552849d-01,
     |  -5.2242982912856d-01, 4.9212933913393d-01, 8.5268992197142d-01,
     |   1.6919110370168d-01,-6.8816329738384d-01,-6.8038597472450d-01,
     |   1.5586111883522d-01, 7.8545882826217d-01, 4.4360755909424d-01,
     |  -4.4360755909424d-01,-7.8545882826217d-01,-1.5586111883522d-01,
     |   6.8038597472450d-01, 6.8816329738384d-01,-1.6919110370169d-01,
     |  -8.5268992197142d-01,-4.9212933913393d-01, 5.2242982912856d-01,
     |   9.4942394552849d-01, 1.8730954487536d-01,-9.1261309108181d-01,
     |  -9.6319570035643d-01, 2.7871200993498d-01, 1.4295580475482d+00,
     |   8.8965716106069d-01,-1.3203668595139d+00,-3.3627542533373d+00/
      data (pmn(lat, 1,13), lat = 1,36)/
     |   1.0354057673700d+00, 2.1366860463088d+00, 1.3278016481493d+00,
     |  -4.0986045543557d-01,-1.2875866245885d+00,-6.0272431907405d-01,
     |   6.4559946966406d-01, 9.9788306252690d-01, 1.6092525866878d-01,
     |  -7.8695118117532d-01,-7.3527644112219d-01, 1.8477514166619d-01,
     |   8.3428698549758d-01, 4.5377164043656d-01,-4.6035004126291d-01,
     |  -7.9186655194368d-01,-1.5362011686318d-01, 6.6495376156555d-01,
     |   6.6495376156555d-01,-1.5362011686318d-01,-7.9186655194368d-01,
     |  -4.6035004126291d-01, 4.5377164043656d-01, 8.3428698549758d-01,
     |   1.8477514166620d-01,-7.3527644112219d-01,-7.8695118117532d-01,
     |   1.6092525866878d-01, 9.9788306252689d-01, 6.4559946966406d-01,
     |  -6.0272431907405d-01,-1.2875866245885d+00,-4.0986045543558d-01,
     |   1.3278016481493d+00, 2.1366860463088d+00, 1.0354057673700d+00/
      data (pmn(lat, 2,13), lat = 1,36)/
     |   1.5379278760893d-01, 1.0917050976831d+00, 1.7874220799927d+00,
     |   1.2436987633704d+00,-1.8313304325518d-01,-1.1411300147148d+00,
     |  -7.6660216801653d-01, 3.8220938249848d-01, 9.8086370237362d-01,
     |   4.1782778049857d-01,-5.7896142942131d-01,-8.3986612349059d-01,
     |  -1.0538649104827d-01, 7.1999504474166d-01, 6.6251809688642d-01,
     |  -1.8289445665274d-01,-7.9282532030708d-01,-4.4173732671221d-01,
     |   4.4173732671221d-01, 7.9282532030708d-01, 1.8289445665274d-01,
     |  -6.6251809688642d-01,-7.1999504474166d-01, 1.0538649104827d-01,
     |   8.3986612349059d-01, 5.7896142942131d-01,-4.1782778049857d-01,
     |  -9.8086370237362d-01,-3.8220938249848d-01, 7.6660216801652d-01,
     |   1.1411300147148d+00, 1.8313304325518d-01,-1.2436987633704d+00,
     |  -1.7874220799927d+00,-1.0917050976831d+00,-1.5379278760893d-01/
      data (pmn(lat, 3,13), lat = 1,36)/
     |   1.4948157650211d-02, 3.3939944599698d-01, 1.0881417359914d+00,
     |   1.6038058656932d+00, 1.1688312056814d+00,-5.1405133194611d-02,
     |  -1.0157105581942d+00,-8.5897463752403d-01, 1.6000156900882d-01,
     |   9.1128279977673d-01, 6.0963767532308d-01,-3.4818783230177d-01,
     |  -8.6025539023400d-01,-3.6897892176464d-01, 5.2853495433648d-01,
     |   7.8858918308167d-01, 1.2388501215217d-01,-6.7828275114992d-01,
     |  -6.7828275114992d-01, 1.2388501215217d-01, 7.8858918308167d-01,
     |   5.2853495433649d-01,-3.6897892176464d-01,-8.6025539023400d-01,
     |  -3.4818783230178d-01, 6.0963767532308d-01, 9.1128279977673d-01,
     |   1.6000156900882d-01,-8.5897463752402d-01,-1.0157105581942d+00,
     |  -5.1405133194611d-02, 1.1688312056814d+00, 1.6038058656932d+00,
     |   1.0881417359914d+00, 3.3939944599698d-01, 1.4948157650211d-02/
      data (pmn(lat, 4,13), lat = 1,36)/
     |   1.0678224494869d-03, 7.5535594892046d-02, 4.4000072466280d-01,
     |   1.0753006743041d+00, 1.4848736129598d+00, 1.1156510740540d+00,
     |   4.6328499964436d-02,-9.0403740927626d-01,-9.1767062185378d-01,
     |  -4.0870864240224d-02, 8.0435759722145d-01, 7.5248181712825d-01,
     |  -9.8847511709913d-02,-8.0292261601561d-01,-5.9742102689272d-01,
     |   2.6654527787645d-01, 8.1420045081869d-01, 4.3583714190393d-01,
     |  -4.3583714190393d-01,-8.1420045081869d-01,-2.6654527787646d-01,
     |   5.9742102689272d-01, 8.0292261601561d-01, 9.8847511709909d-02,
     |  -7.5248181712825d-01,-8.0435759722145d-01, 4.0870864240222d-02,
     |   9.1767062185378d-01, 9.0403740927626d-01,-4.6328499964430d-02,
     |  -1.1156510740540d+00,-1.4848736129598d+00,-1.0753006743041d+00,
     |  -4.4000072466281d-01,-7.5535594892046d-02,-1.0678224494869d-03/
      data (pmn(lat, 5,13), lat = 1,36)/
     |   5.9484150385762d-05, 1.2945638285411d-02, 1.3278582550487d-01,
     |   5.0065313818512d-01, 1.0558456941398d+00, 1.3997105761327d+00,
     |   1.0861957503292d+00, 1.3940556197816d-01,-7.9336274883224d-01,
     |  -9.5705205905761d-01,-2.3657125219260d-01, 6.5799304608885d-01,
     |   8.4889771520566d-01, 1.6893920636774d-01,-6.5982347004041d-01,
     |  -7.7068445478963d-01,-5.9532950597325d-02, 7.0678917788792d-01,
     |   7.0678917788792d-01,-5.9532950597323d-02,-7.7068445478963d-01,
     |  -6.5982347004041d-01, 1.6893920636774d-01, 8.4889771520567d-01,
     |   6.5799304608885d-01,-2.3657125219260d-01,-9.5705205905761d-01,
     |  -7.9336274883225d-01, 1.3940556197816d-01, 1.0861957503292d+00,
     |   1.3997105761327d+00, 1.0558456941398d+00, 5.0065313818512d-01,
     |   1.3278582550487d-01, 1.2945638285411d-02, 5.9484150385762d-05/
      data (pmn(lat, 6,13), lat = 1,36)/
     |   2.6725517119665d-06, 1.7769481274172d-03, 3.1575312111515d-02,
     |   1.7782272024748d-01, 5.3460185556664d-01, 1.0291546019211d+00,
     |   1.3350979093459d+00, 1.0806612221579d+00, 2.4511697536652d-01,
     |  -6.6912809474813d-01,-9.7763354837655d-01,-4.3683405296837d-01,
     |   4.6048214968332d-01, 8.8567263470866d-01, 4.4801605275618d-01,
     |  -4.1375658921230d-01,-8.4691395578417d-01,-4.2491551927189d-01,
     |   4.2491551927189d-01, 8.4691395578417d-01, 4.1375658921230d-01,
     |  -4.4801605275618d-01,-8.8567263470865d-01,-4.6048214968332d-01,
     |   4.3683405296837d-01, 9.7763354837655d-01, 6.6912809474813d-01,
     |  -2.4511697536652d-01,-1.0806612221579d+00,-1.3350979093459d+00,
     |  -1.0291546019211d+00,-5.3460185556664d-01,-1.7782272024748d-01,
     |  -3.1575312111516d-02,-1.7769481274172d-03,-2.6725517119665d-06/
      data (pmn(lat, 7,13), lat = 1,36)/
     |   9.8723714072794d-08, 1.9967485242259d-04, 6.0877087979907d-03,
     |   5.0313127430344d-02, 2.0878493266292d-01, 5.4656634460955d-01,
     |   9.9362137027597d-01, 1.2830653785814d+00, 1.0979577879823d+00,
     |   3.7538498466461d-01,-5.1430416897245d-01,-9.6785467090021d-01,
     |  -6.4141899617178d-01, 1.9603090827873d-01, 8.3078300688903d-01,
     |   7.1000602327994d-01,-5.1048038886522d-02,-7.5527283987124d-01,
     |  -7.5527283987124d-01,-5.1048038886523d-02, 7.1000602327994d-01,
     |   8.3078300688903d-01, 1.9603090827873d-01,-6.4141899617178d-01,
     |  -9.6785467090021d-01,-5.1430416897245d-01, 3.7538498466461d-01,
     |   1.0979577879823d+00, 1.2830653785814d+00, 9.9362137027597d-01,
     |   5.4656634460955d-01, 2.0878493266292d-01, 5.0313127430344d-02,
     |   6.0877087979908d-03, 1.9967485242259d-04, 9.8723714072794d-08/
      data (pmn(lat, 8,13), lat = 1,36)/
     |   3.0261911851957d-09, 1.8565868450879d-05, 9.6518605035957d-04,
     |   1.1580710042007d-02, 6.5142733083098d-02, 2.2468626242847d-01,
     |   5.3793740335458d-01, 9.4638728898719d-01, 1.2360552869688d+00,
     |   1.1343375909815d+00, 5.3831434866833d-01,-3.0856110095042d-01,
     |  -9.0183926141865d-01,-8.3230840592783d-01,-1.4554772507125d-01,
     |   6.3245570011282d-01, 8.8434363101047d-01, 4.0677208105085d-01,
     |  -4.0677208105084d-01,-8.8434363101047d-01,-6.3245570011282d-01,
     |   1.4554772507125d-01, 8.3230840592783d-01, 9.0183926141865d-01,
     |   3.0856110095042d-01,-5.3831434866833d-01,-1.1343375909815d+00,
     |  -1.2360552869688d+00,-9.4638728898719d-01,-5.3793740335458d-01,
     |  -2.2468626242847d-01,-6.5142733083098d-02,-1.1580710042007d-02,
     |  -9.6518605035958d-04,-1.8565868450879d-05,-3.0261911851957d-09/
      data (pmn(lat, 9,13), lat = 1,36)/
     |   7.7023810200873d-11, 1.4305453981884d-06, 1.2627706414615d-04,
     |   2.1839691537776d-03, 1.6465389174927d-02, 7.3483429144415d-02,
     |   2.2472246681242d-01, 5.0832157790550d-01, 8.8272869667461d-01,
     |   1.1839313105548d+00, 1.1805831009386d+00, 7.3597206322572d-01,
     |  -2.9707462482734d-02,-7.3573906040680d-01,-9.5916167032476d-01,
     |  -5.4599129343723d-01, 2.3224723776488d-01, 8.3543130457085d-01,
     |   8.3543130457085d-01, 2.3224723776488d-01,-5.4599129343723d-01,
     |  -9.5916167032476d-01,-7.3573906040680d-01,-2.9707462482730d-02,
     |   7.3597206322572d-01, 1.1805831009386d+00, 1.1839313105548d+00,
     |   8.8272869667462d-01, 5.0832157790550d-01, 2.2472246681242d-01,
     |   7.3483429144415d-02, 1.6465389174927d-02, 2.1839691537776d-03,
     |   1.2627706414616d-04, 1.4305453981884d-06, 7.7023810200873d-11/
      data (pmn(lat,10,13), lat = 1,36)/
     |   1.6133089564940d-12, 9.0579557941530d-08, 1.3535274227347d-05,
     |   3.3575640453758d-04, 3.3669486441617d-03, 1.9220542923660d-02,
     |   7.3756759671023d-02, 2.0835206235190d-01, 4.5623691277133d-01,
     |   7.9555380127442d-01, 1.1114016804609d+00, 1.2172865673883d+00,
     |   9.5710252280273d-01, 3.3818623947490d-01,-4.0838463527826d-01,
     |  -9.1871781792021d-01,-9.0961363920777d-01,-3.7633709895030d-01,
     |   3.7633709895030d-01, 9.0961363920777d-01, 9.1871781792021d-01,
     |   4.0838463527826d-01,-3.3818623947490d-01,-9.5710252280273d-01,
     |  -1.2172865673883d+00,-1.1114016804609d+00,-7.9555380127442d-01,
     |  -4.5623691277133d-01,-2.0835206235190d-01,-7.3756759671023d-02,
     |  -1.9220542923660d-02,-3.3669486441617d-03,-3.3575640453758d-04,
     |  -1.3535274227347d-05,-9.0579557941530d-08,-1.6133089564940d-12/
      data (pmn(lat,11,13), lat = 1,36)/
     |   2.7172690015824d-14, 4.6069848737132d-09, 1.1627759754434d-06,
     |   4.1220686403478d-05, 5.4685242702841d-04, 3.9619306884658d-03,
     |   1.8860453729346d-02, 6.5400846918542d-02, 1.7572407352526d-01,
     |   3.7994553520790d-01, 6.7557156003302d-01, 9.9592989370226d-01,
     |   1.2079345711085d+00, 1.1618457023196d+00, 7.8072743127951d-01,
     |   1.3711599269010d-01,-5.4478987709353d-01,-9.8309058426803d-01,
     |  -9.8309058426803d-01,-5.4478987709353d-01, 1.3711599269009d-01,
     |   7.8072743127951d-01, 1.1618457023196d+00, 1.2079345711085d+00,
     |   9.9592989370226d-01, 6.7557156003302d-01, 3.7994553520790d-01,
     |   1.7572407352526d-01, 6.5400846918542d-02, 1.8860453729346d-02,
     |   3.9619306884658d-03, 5.4685242702841d-04, 4.1220686403478d-05,
     |   1.1627759754434d-06, 4.6069848737132d-09, 2.7172690015824d-14/
      data (pmn(lat,12,13), lat = 1,36)/
     |   3.4956987727050d-16, 1.7882712831265d-10, 7.6105375326920d-08,
     |   3.8451559871702d-06, 6.7217767555443d-05, 6.1459487325684d-04,
     |   3.6009765352808d-03, 1.5157410069155d-02, 4.9161355433779d-02,
     |   1.2854250807640d-01, 2.7915139002226d-01, 5.1328625831172d-01,
     |   8.0787747405716d-01, 1.0914821137048d+00, 1.2559392545980d+00,
     |   1.1970374003073d+00, 8.6838692236355d-01, 3.1806053551973d-01,
     |  -3.1806053551973d-01,-8.6838692236355d-01,-1.1970374003073d+00,
     |  -1.2559392545980d+00,-1.0914821137048d+00,-8.0787747405716d-01,
     |  -5.1328625831172d-01,-2.7915139002226d-01,-1.2854250807641d-01,
     |  -4.9161355433779d-02,-1.5157410069155d-02,-3.6009765352809d-03,
     |  -6.1459487325684d-04,-6.7217767555443d-05,-3.8451559871703d-06,
     |  -7.6105375326922d-08,-1.7882712831265d-10,-3.4956987727050d-16/
      data (pmn(lat,13,13), lat = 1,36)/
     |   2.9932324073983d-18, 4.6171696374140d-12, 3.3089019297609d-09,
     |   2.3776591216677d-07, 5.4603656408227d-06, 6.2744972754597d-05,
     |   4.4990513458079d-04, 2.2809659352984d-03, 8.8346558433116d-03,
     |   2.7511079618070d-02, 7.1346495805930d-02, 1.5801038502730d-01,
     |   3.0435619716876d-01, 5.1677992503644d-01, 7.8119536537337d-01,
     |   1.0589264791738d+00, 1.2935925268370d+00, 1.4286636707965d+00,
     |   1.4286636707965d+00, 1.2935925268370d+00, 1.0589264791738d+00,
     |   7.8119536537337d-01, 5.1677992503644d-01, 3.0435619716876d-01,
     |   1.5801038502730d-01, 7.1346495805930d-02, 2.7511079618071d-02,
     |   8.8346558433116d-03, 2.2809659352984d-03, 4.4990513458079d-04,
     |   6.2744972754597d-05, 5.4603656408227d-06, 2.3776591216677d-07,
     |   3.3089019297610d-09, 4.6171696374140d-12, 2.9932324073983d-18/
      data (pmn(lat, 0,14), lat = 1,36)/
     |   3.4366549483639d+00, 1.0781646403464d+00,-1.1871717932489d+00,
     |  -1.2899035210961d+00, 2.2522300129827d-01, 1.1633816766626d+00,
     |   4.5126669553201d-01,-7.6067679316570d-01,-8.3402678914896d-01,
     |   2.1364616429015d-01, 8.9304896138407d-01, 3.1918386953132d-01,
     |  -6.5807653695079d-01,-6.9160354627869d-01, 2.2642422702912d-01,
     |   8.0703449040749d-01, 2.5835654772568d-01,-6.4338780875167d-01,
     |  -6.4338780875167d-01, 2.5835654772568d-01, 8.0703449040749d-01,
     |   2.2642422702912d-01,-6.9160354627869d-01,-6.5807653695079d-01,
     |   3.1918386953132d-01, 8.9304896138407d-01, 2.1364616429015d-01,
     |  -8.3402678914896d-01,-7.6067679316570d-01, 4.5126669553201d-01,
     |   1.1633816766626d+00, 2.2522300129827d-01,-1.2899035210961d+00,
     |  -1.1871717932490d+00, 1.0781646403464d+00, 3.4366549483639d+00/
      data (pmn(lat, 1,14), lat = 1,36)/
     |   1.1448844393893d+00, 2.2164212104079d+00, 1.0579189915227d+00,
     |  -8.0754338169455d-01,-1.2545074650492d+00,-7.0508221276103d-02,
     |   1.0162856623830d+00, 6.4964974922883d-01,-5.2774117610443d-01,
     |  -8.9860003962275d-01,-4.0943800105931d-02, 8.1582494326617d-01,
     |   5.2193525945699d-01,-4.6902377354799d-01,-7.8325524753743d-01,
     |  -1.3006219739837d-02, 7.6035403336792d-01, 4.7171643030123d-01,
     |  -4.7171643030123d-01,-7.6035403336792d-01, 1.3006219739832d-02,
     |   7.8325524753743d-01, 4.6902377354799d-01,-5.2193525945699d-01,
     |  -8.1582494326618d-01, 4.0943800105931d-02, 8.9860003962275d-01,
     |   5.2774117610443d-01,-6.4964974922883d-01,-1.0162856623830d+00,
     |   7.0508221276103d-02, 1.2545074650492d+00, 8.0754338169456d-01,
     |  -1.0579189915227d+00,-2.2164212104079d+00,-1.1448844393893d+00/
      data (pmn(lat, 2,14), lat = 1,36)/
     |   1.8322218673083d-01, 1.2513128834212d+00, 1.8546180637434d+00,
     |   9.4091555420768d-01,-6.4630125354140d-01,-1.1877443234862d+00,
     |  -2.3220983069944d-01, 8.8173299265594d-01, 7.5816003704393d-01,
     |  -3.2885799932603d-01,-9.0168898764029d-01,-2.4864006998928d-01,
     |   6.9891112702823d-01, 6.6797937374552d-01,-2.6175731197452d-01,
     |  -8.1130503858617d-01,-2.4571395482336d-01, 6.4932971294281d-01,
     |   6.4932971294281d-01,-2.4571395482336d-01,-8.1130503858617d-01,
     |  -2.6175731197452d-01, 6.6797937374552d-01, 6.9891112702823d-01,
     |  -2.4864006998928d-01,-9.0168898764029d-01,-3.2885799932603d-01,
     |   7.5816003704393d-01, 8.8173299265594d-01,-2.3220983069944d-01,
     |  -1.1877443234862d+00,-6.4630125354140d-01, 9.4091555420767d-01,
     |   1.8546180637434d+00, 1.2513128834212d+00, 1.8322218673083d-01/
      data (pmn(lat, 3,14), lat = 1,36)/
     |   1.9194607392874d-02, 4.2379327148407d-01, 1.2746078316096d+00,
     |   1.6511660125262d+00, 8.2977285809284d-01,-5.6778965999927d-01,
     |  -1.1282802953685d+00,-3.3417647065321d-01, 7.6460455818705d-01,
     |   8.2297420237143d-01,-1.5242477880482d-01,-8.6814560700330d-01,
     |  -4.2513462163469d-01, 5.5108733515132d-01, 7.6778342617544d-01,
     |  -3.7238321713483d-02,-7.7683178888189d-01,-4.6837896539575d-01,
     |   4.6837896539575d-01, 7.7683178888189d-01, 3.7238321713487d-02,
     |  -7.6778342617544d-01,-5.5108733515132d-01, 4.2513462163470d-01,
     |   8.6814560700330d-01, 1.5242477880482d-01,-8.2297420237143d-01,
     |  -7.6460455818706d-01, 3.3417647065320d-01, 1.1282802953685d+00,
     |   5.6778965999927d-01,-8.2977285809284d-01,-1.6511660125262d+00,
     |  -1.2746078316097d+00,-4.2379327148407d-01,-1.9194607392874d-02/
      data (pmn(lat, 4,14), lat = 1,36)/
     |   1.4807826620458d-03, 1.0246810982375d-01, 5.6903711669721d-01,
     |   1.2779261657837d+00, 1.5102088105631d+00, 7.4052422047523d-01,
     |  -5.1947435231921d-01,-1.0806937971896d+00,-4.1376392883953d-01,
     |   6.5536004376855d-01, 8.6537722063636d-01, 1.6549495175006d-02,
     |  -8.0378901848318d-01,-5.8069100249443d-01, 3.6891749689938d-01,
     |   8.1998562610543d-01, 2.0580024753640d-01,-6.6781447017358d-01,
     |  -6.6781447017358d-01, 2.0580024753640d-01, 8.1998562610543d-01,
     |   3.6891749689938d-01,-5.8069100249443d-01,-8.0378901848318d-01,
     |   1.6549495175000d-02, 8.6537722063636d-01, 6.5536004376855d-01,
     |  -4.1376392883952d-01,-1.0806937971896d+00,-5.1947435231922d-01,
     |   7.4052422047523d-01, 1.5102088105631d+00, 1.2779261657837d+00,
     |   5.6903711669722d-01, 1.0246810982375d-01, 1.4807826620458d-03/
      data (pmn(lat, 5,14), lat = 1,36)/
     |   8.9373182155065d-05, 1.9100383293956d-02, 1.8853404781820d-01,
     |   6.6675232982767d-01, 1.2689880877811d+00, 1.4052314667428d+00,
     |   6.7853937669234d-01,-4.7626216206032d-01,-1.0426031430648d+00,
     |  -4.9158697285378d-01, 5.4098946235680d-01, 8.9235298435251d-01,
     |   1.9114599828623d-01,-7.0216864796568d-01,-7.1627115549394d-01,
     |   1.4351959737627d-01, 8.0874243331140d-01, 4.6121550215615d-01,
     |  -4.6121550215615d-01,-8.0874243331140d-01,-1.4351959737628d-01,
     |   7.1627115549394d-01, 7.0216864796568d-01,-1.9114599828624d-01,
     |  -8.9235298435251d-01,-5.4098946235680d-01, 4.9158697285378d-01,
     |   1.0426031430648d+00, 4.7626216206032d-01,-6.7853937669234d-01,
     |  -1.4052314667428d+00,-1.2689880877811d+00,-6.6675232982767d-01,
     |  -1.8853404781820d-01,-1.9100383293956d-02,-8.9373182155065d-05/
      data (pmn(lat, 6,14), lat = 1,36)/
     |   4.3710432531920d-06, 2.8616250070919d-03, 4.9237171050378d-02,
     |   2.6323630753132d-01, 7.3188671276832d-01, 1.2512159387583d+00,
     |   1.3275829646845d+00, 6.4768205743067d-01,-4.2296526930321d-01,
     |  -1.0090688662249d+00,-5.7968151607134d-01, 4.0672559237403d-01,
     |   8.9998084615433d-01, 3.7981815765842d-01,-5.4735746818493d-01,
     |  -8.1873976026605d-01,-1.3207939491415d-01, 7.0112345614102d-01,
     |   7.0112345614102d-01,-1.3207939491415d-01,-8.1873976026605d-01,
     |  -5.4735746818493d-01, 3.7981815765842d-01, 8.9998084615434d-01,
     |   4.0672559237404d-01,-5.7968151607134d-01,-1.0090688662249d+00,
     |  -4.2296526930321d-01, 6.4768205743067d-01, 1.3275829646845d+00,
     |   1.2512159387583d+00, 7.3188671276832d-01, 2.6323630753132d-01,
     |   4.9237171050378d-02, 2.8616250070919d-03, 4.3710432531920d-06/
      data (pmn(lat, 7,14), lat = 1,36)/
     |   1.7691916707653d-07, 3.5303575345484d-04, 1.0468296617979d-02,
     |   8.2793441764520d-02, 3.2233261365954d-01, 7.7071460087403d-01,
     |   1.2269502588528d+00, 1.2744404131350d+00, 6.5185156090187d-01,
     |  -3.4721060344283d-01,-9.7178695494705d-01,-6.8378127281576d-01,
     |   2.3589215825347d-01, 8.7246901882316d-01, 5.8163198878346d-01,
     |  -3.1660272068617d-01,-8.5322664833648d-01,-4.4906246270063d-01,
     |   4.4906246270063d-01, 8.5322664833648d-01, 3.1660272068617d-01,
     |  -5.8163198878346d-01,-8.7246901882316d-01,-2.3589215825347d-01,
     |   6.8378127281575d-01, 9.7178695494705d-01, 3.4721060344283d-01,
     |  -6.5185156090187d-01,-1.2744404131350d+00,-1.2269502588528d+00,
     |  -7.7071460087403d-01,-3.2233261365954d-01,-8.2793441764521d-02,
     |  -1.0468296617979d-02,-3.5303575345484d-04,-1.7691916707653d-07/
      data (pmn(lat, 8,14), lat = 1,36)/
     |   5.9966058434868d-09, 3.6352251170758d-05, 1.8441586847156d-03,
     |   2.1297013804495d-02, 1.1347443719603d-01, 3.6340951751683d-01,
     |   7.8612251466658d-01, 1.1972469737240d+00, 1.2443077076750d+00,
     |   6.9500528259981d-01,-2.3578104438414d-01,-9.1625295852566d-01,
     |  -8.0146486423911d-01, 1.0994086072380d-02, 7.7858564051137d-01,
     |   7.7596176815429d-01, 1.1227752992906d-02,-7.5441867114017d-01,
     |  -7.5441867114017d-01, 1.1227752992905d-02, 7.7596176815429d-01,
     |   7.7858564051137d-01, 1.0994086072381d-02,-8.0146486423912d-01,
     |  -9.1625295852566d-01,-2.3578104438414d-01, 6.9500528259981d-01,
     |   1.2443077076750d+00, 1.1972469737240d+00, 7.8612251466658d-01,
     |   3.6340951751683d-01, 1.1347443719603d-01, 2.1297013804495d-02,
     |   1.8441586847156d-03, 3.6352251170758d-05, 5.9966058434868d-09/
      data (pmn(lat, 9,14), lat = 1,36)/
     |   1.7097862560342d-10, 3.1416214446524d-06, 2.7131686727911d-04,
     |   4.5362081731220d-03, 3.2618606352309d-02, 1.3665513373074d-01,
     |   3.8454581461160d-01, 7.7882588179315d-01, 1.1609021266421d+00,
     |   1.2341900571858d+00, 7.8016132413463d-01,-7.2695412759403d-02,
     |  -8.1744495398882d-01,-9.1545773621708d-01,-2.8006930727655d-01,
     |   5.6875528306760d-01, 9.0334618109794d-01, 4.2951855201612d-01,
     |  -4.2951855201612d-01,-9.0334618109794d-01,-5.6875528306760d-01,
     |   2.8006930727655d-01, 9.1545773621708d-01, 8.1744495398882d-01,
     |   7.2695412759407d-02,-7.8016132413463d-01,-1.2341900571858d+00,
     |  -1.1609021266421d+00,-7.7882588179315d-01,-3.8454581461161d-01,
     |  -1.3665513373074d-01,-3.2618606352309d-02,-4.5362081731220d-03,
     |  -2.7131686727912d-04,-3.1416214446524d-06,-1.7097862560342d-10/
      data (pmn(lat,10,14), lat = 1,36)/
     |   4.0905698155677d-12, 2.2743753493170d-07, 3.3320162713666d-05,
     |   8.0177380320556d-04, 7.7088539457061d-03, 4.1638055363137d-02,
     |   1.4881985041791d-01, 3.8388726484391d-01, 7.4736164332742d-01,
     |   1.1129922643355d+00, 1.2365109889510d+00, 9.0647331094898d-01,
     |   1.6025010998917d-01,-6.3487082605258d-01,-9.8004084631581d-01,
     |  -6.2493926253169d-01, 1.8337786128484d-01, 8.3983852131624d-01,
     |   8.3983852131625d-01, 1.8337786128484d-01,-6.2493926253169d-01,
     |  -9.8004084631581d-01,-6.3487082605258d-01, 1.6025010998917d-01,
     |   9.0647331094897d-01, 1.2365109889510d+00, 1.1129922643355d+00,
     |   7.4736164332742d-01, 3.8388726484391d-01, 1.4881985041791d-01,
     |   4.1638055363137d-02, 7.7088539457061d-03, 8.0177380320557d-04,
     |   3.3320162713667d-05, 2.2743753493170d-07, 4.0905698155677d-12/
      data (pmn(lat,11,14), lat = 1,36)/
     |   8.1203842062315d-14, 1.3645317934812d-08, 3.3823457110625d-06,
     |   1.1663616991910d-04, 1.4897465050720d-03, 1.0273721622425d-02,
     |   4.5951911465596d-02, 1.4742224005647d-01, 3.5949966583749d-01,
     |   6.8775154736322d-01, 1.0429925940660d+00, 1.2346082120335d+00,
     |   1.0623079358522d+00, 4.7688949212544d-01,-3.1121082927020d-01,
     |  -9.0013159443130d-01,-9.4128185436621d-01,-3.9717771614925d-01,
     |   3.9717771614925d-01, 9.4128185436621d-01, 9.0013159443130d-01,
     |   3.1121082927020d-01,-4.7688949212544d-01,-1.0623079358522d+00,
     |  -1.2346082120335d+00,-1.0429925940660d+00,-6.8775154736322d-01,
     |  -3.5949966583749d-01,-1.4742224005647d-01,-4.5951911465596d-02,
     |  -1.0273721622425d-02,-1.4897465050720d-03,-1.1663616991911d-04,
     |  -3.3823457110626d-06,-1.3645317934812d-08,-8.1203842062315d-14/
      data (pmn(lat,12,14), lat = 1,36)/
     |   1.3049005169910d-15, 6.6206579558778d-10, 2.7711746809061d-07,
     |   1.3650812787476d-05, 2.3052224224506d-04, 2.0158414782188d-03,
     |   1.1171345785033d-02, 4.3916976490917d-02, 1.3106497066279d-01,
     |   3.0963897463296d-01, 5.9352265476689d-01, 9.3288018994021d-01,
     |   1.1960869702844d+00, 1.2109089592670d+00, 8.6524893875747d-01,
     |   2.1051254782588d-01,-5.1632568376895d-01,-9.9412684797683d-01,
     |  -9.9412684797683d-01,-5.1632568376895d-01, 2.1051254782588d-01,
     |   8.6524893875747d-01, 1.2109089592670d+00, 1.1960869702844d+00,
     |   9.3288018994021d-01, 5.9352265476689d-01, 3.0963897463296d-01,
     |   1.3106497066279d-01, 4.3916976490917d-02, 1.1171345785033d-02,
     |   2.0158414782188d-03, 2.3052224224506d-04, 1.3650812787476d-05,
     |   2.7711746809062d-07, 6.6206579558778d-10, 1.3049005169910d-15/
      data (pmn(lat,13,14), lat = 1,36)/
     |   1.6103708056156d-17, 2.4651502595831d-11, 1.7396601194678d-08,
     |   1.2211474071975d-06, 2.7166648905177d-05, 2.9971388138853d-04,
     |   2.0433800097391d-03, 9.7450585546425d-03, 3.5076763885049d-02,
     |   1.0008983625201d-01, 2.3389383475083d-01, 4.5719466532300d-01,
     |   7.5680980121413d-01, 1.0649869696877d+00, 1.2650289405201d+00,
     |   1.2342455152143d+00, 9.0927272849122d-01, 3.3558965283144d-01,
     |  -3.3558965283144d-01,-9.0927272849122d-01,-1.2342455152143d+00,
     |  -1.2650289405201d+00,-1.0649869696877d+00,-7.5680980121413d-01,
     |  -4.5719466532300d-01,-2.3389383475083d-01,-1.0008983625201d-01,
     |  -3.5076763885049d-02,-9.7450585546425d-03,-2.0433800097391d-03,
     |  -2.9971388138853d-04,-2.7166648905177d-05,-1.2211474071975d-06,
     |  -1.7396601194679d-08,-2.4651502595831d-11,-1.6103708056156d-17/
      data (pmn(lat,14,14), lat = 1,36)/
     |   1.3287399218414d-19, 6.1332897624407d-13, 7.2885414756462d-10,
     |   7.2763131009684d-08, 2.1265782565604d-06, 2.9485229883731d-05,
     |   2.4601266005033d-04, 1.4131423458321d-03, 6.0742542386921d-03,
     |   2.0642319766725d-02, 5.7604881215339d-02, 1.3562345581978d-01,
     |   2.7474579632051d-01, 4.8589335951915d-01, 7.5822682120832d-01,
     |   1.0521249139708d+00, 1.3052269950963d+00, 1.4525678768043d+00,
     |   1.4525678768043d+00, 1.3052269950963d+00, 1.0521249139708d+00,
     |   7.5822682120832d-01, 4.8589335951915d-01, 2.7474579632051d-01,
     |   1.3562345581978d-01, 5.7604881215339d-02, 2.0642319766725d-02,
     |   6.0742542386922d-03, 1.4131423458321d-03, 2.4601266005034d-04,
     |   2.9485229883731d-05, 2.1265782565604d-06, 7.2763131009685d-08,
     |   7.2885414756465d-10, 6.1332897624407d-13, 1.3287399218414d-19/
      data (pmn(lat, 0,15), lat = 1,36)/
     |   3.4999210854583d+00, 8.1621801546612d-01,-1.4270436119321d+00,
     |  -1.0293627320311d+00, 6.9466152749273d-01, 1.0994424182282d+00,
     |  -1.5192225887377d-01,-1.0189752630347d+00,-2.7963259349258d-01,
     |   8.1098691937448d-01, 5.9453345425117d-01,-5.0995596873639d-01,
     |  -7.7659916235429d-01, 1.5918365035382d-01, 8.1654045436238d-01,
     |   1.9328038427060d-01,-7.1811635923180d-01,-4.9974124152311d-01,
     |   4.9974124152311d-01, 7.1811635923180d-01,-1.9328038427059d-01,
     |  -8.1654045436238d-01,-1.5918365035382d-01, 7.7659916235429d-01,
     |   5.0995596873640d-01,-5.9453345425117d-01,-8.1098691937448d-01,
     |   2.7963259349258d-01, 1.0189752630347d+00, 1.5192225887377d-01,
     |  -1.0994424182282d+00,-6.9466152749273d-01, 1.0293627320311d+00,
     |   1.4270436119322d+00,-8.1621801546612d-01,-3.4999210854583d+00/
      data (pmn(lat, 1,15), lat = 1,36)/
     |   1.2562670574075d+00, 2.2661142075101d+00, 7.4166716993177d-01,
     |  -1.1331533642213d+00,-1.0346376812237d+00, 4.7728247559058d-01,
     |   1.0716813828666d+00, 3.4892289745634d-02,-9.4037023280956d-01,
     |  -4.2944574745305d-01, 6.8516066122789d-01, 6.9342197407891d-01,
     |  -3.5126802393280d-01,-8.1323479979242d-01,-1.1610881756186d-02,
     |   7.8603059219863d-01, 3.5240626491908d-01,-6.2356802339646d-01,
     |  -6.2356802339646d-01, 3.5240626491908d-01, 7.8603059219863d-01,
     |  -1.1610881756184d-02,-8.1323479979242d-01,-3.5126802393280d-01,
     |   6.9342197407890d-01, 6.8516066122789d-01,-4.2944574745305d-01,
     |  -9.4037023280956d-01, 3.4892289745631d-02, 1.0716813828666d+00,
     |   4.7728247559058d-01,-1.0346376812237d+00,-1.1331533642213d+00,
     |   7.4166716993176d-01, 2.2661142075101d+00, 1.2562670574075d+00/
      data (pmn(lat, 2,15), lat = 1,36)/
     |   2.1558918715089d-01, 1.4118458861874d+00, 1.8667329542839d+00,
     |   5.6776243440451d-01,-1.0213955281854d+00,-9.8519099984927d-01,
     |   3.7064127730682d-01, 1.0291428057502d+00, 1.4776331854429d-01,
     |  -8.6540281492721d-01,-5.2886864897767d-01, 5.6936406151626d-01,
     |   7.5614943782205d-01,-2.0352094864086d-01,-8.2043872048958d-01,
     |  -1.7149974884455d-01, 7.2714204623130d-01, 4.9830705893687d-01,
     |  -4.9830705893687d-01,-7.2714204623130d-01, 1.7149974884455d-01,
     |   8.2043872048958d-01, 2.0352094864086d-01,-7.5614943782206d-01,
     |  -5.6936406151627d-01, 5.2886864897767d-01, 8.6540281492721d-01,
     |  -1.4776331854429d-01,-1.0291428057502d+00,-3.7064127730682d-01,
     |   9.8519099984927d-01, 1.0213955281854d+00,-5.6776243440450d-01,
     |  -1.8667329542839d+00,-1.4118458861874d+00,-2.1558918715089d-01/
      data (pmn(lat, 3,15), lat = 1,36)/
     |   2.4218548926630d-02, 5.1880755265532d-01, 1.4538264961400d+00,
     |   1.6136624013682d+00, 3.9864820922217d-01,-9.7621987801171d-01,
     |  -9.2867096170990d-01, 3.1552000832122d-01, 9.9053990015214d-01,
     |   2.2574170035280d-01,-7.9710779579608d-01,-6.0447526717337d-01,
     |   4.5718626554955d-01, 7.9811232088260d-01,-5.5932934939218d-02,
     |  -8.0266226688761d-01,-3.3037324037967d-01, 6.3456416323994d-01,
     |   6.3456416323994d-01,-3.3037324037967d-01,-8.0266226688761d-01,
     |  -5.5932934939219d-02, 7.9811232088260d-01, 4.5718626554954d-01,
     |  -6.0447526717337d-01,-7.9710779579608d-01, 2.2574170035280d-01,
     |   9.9053990015214d-01, 3.1552000832123d-01,-9.2867096170989d-01,
     |  -9.7621987801171d-01, 3.9864820922217d-01, 1.6136624013682d+00,
     |   1.4538264961400d+00, 5.1880755265532d-01, 2.4218548926630d-02/
      data (pmn(lat, 4,15), lat = 1,36)/
     |   2.0063607279206d-03, 1.3558697589695d-01, 7.1466480786864d-01,
     |   1.4584561225917d+00, 1.4171753600246d+00, 2.5290082884304d-01,
     |  -9.5472622128947d-01,-8.7920442344148d-01, 2.7984478231824d-01,
     |   9.5891125754405d-01, 2.9274024334142d-01,-7.2982757245678d-01,
     |  -6.7146410083611d-01, 3.3754419351654d-01, 8.2415619330965d-01,
     |   1.0303312399094d-01,-7.5393052123569d-01,-4.9381203637977d-01,
     |   4.9381203637977d-01, 7.5393052123569d-01,-1.0303312399094d-01,
     |  -8.2415619330965d-01,-3.3754419351654d-01, 6.7146410083612d-01,
     |   7.2982757245678d-01,-2.9274024334142d-01,-9.5891125754405d-01,
     |  -2.7984478231825d-01, 8.7920442344148d-01, 9.5472622128948d-01,
     |  -2.5290082884304d-01,-1.4171753600246d+00,-1.4584561225917d+00,
     |  -7.1466480786864d-01,-1.3558697589695d-01,-2.0063607279206d-03/
      data (pmn(lat, 5,15), lat = 1,36)/
     |   1.3036708963857d-04, 2.7322649635358d-02, 2.5868093530072d-01,
     |   8.5214055122610d-01, 1.4395148590967d+00, 1.2558415684301d+00,
     |   1.3710961065926d-01,-9.3920488861415d-01,-8.4367001488298d-01,
     |   2.4411545267639d-01, 9.3262631172730d-01, 3.6459143108988d-01,
     |  -6.5395349996527d-01,-7.3708307045794d-01, 1.9709642335003d-01,
     |   8.2944581483369d-01, 2.8279123405980d-01,-6.5762743216967d-01,
     |  -6.5762743216967d-01, 2.8279123405980d-01, 8.2944581483369d-01,
     |   1.9709642335003d-01,-7.3708307045794d-01,-6.5395349996527d-01,
     |   3.6459143108988d-01, 9.3262631172730d-01, 2.4411545267639d-01,
     |  -8.4367001488298d-01,-9.3920488861415d-01, 1.3710961065926d-01,
     |   1.2558415684301d+00, 1.4395148590967d+00, 8.5214055122610d-01,
     |   2.5868093530072d-01, 2.7322649635358d-02, 1.3036708963857d-04/
      data (pmn(lat, 6,15), lat = 1,36)/
     |   6.8891848533959d-06, 4.4358402569584d-03, 7.3709408766234d-02,
     |   3.7222448537982d-01, 9.4765705697165d-01, 1.4058958607554d+00,
     |   1.1257086462461d+00, 5.5257180362450d-02,-9.2177656615016d-01,
     |  -8.2711578419205d-01, 1.9420196828814d-01, 9.0728411030875d-01,
     |   4.5234871507252d-01,-5.5617127754841d-01,-8.0066714125085d-01,
     |   2.1434050740447d-02, 7.9736374996690d-01, 4.8561913334830d-01,
     |  -4.8561913334830d-01,-7.9736374996690d-01,-2.1434050740451d-02,
     |   8.0066714125085d-01, 5.5617127754841d-01,-4.5234871507252d-01,
     |  -9.0728411030875d-01,-1.9420196828814d-01, 8.2711578419205d-01,
     |   9.2177656615016d-01,-5.5257180362448d-02,-1.1257086462461d+00,
     |  -1.4058958607554d+00,-9.4765705697165d-01,-3.7222448537983d-01,
     |  -7.3709408766234d-02,-4.4358402569584d-03,-6.8891848533959d-06/
      data (pmn(lat, 7,15), lat = 1,36)/
     |   3.0279370993418d-07, 5.9552737334987d-04, 1.7136859851325d-02,
     |   1.2918919787907d-01, 4.6858717974109d-01, 1.0098277904484d+00,
     |   1.3657066859339d+00, 1.0286595288286d+00, 1.0988990481664d-02,
     |  -8.9775358746308d-01,-8.3339039369489d-01, 1.1744608549563d-01,
     |   8.7429496015957d-01, 5.6262704194244d-01,-4.1827074518531d-01,
     |  -8.5015846711633d-01,-2.0171169668776d-01, 6.9534404128850d-01,
     |   6.9534404128850d-01,-2.0171169668776d-01,-8.5015846711633d-01,
     |  -4.1827074518531d-01, 5.6262704194244d-01, 8.7429496015957d-01,
     |   1.1744608549564d-01,-8.3339039369489d-01,-8.9775358746309d-01,
     |   1.0988990481660d-02, 1.0286595288286d+00, 1.3657066859339d+00,
     |   1.0098277904484d+00, 4.6858717974109d-01, 1.2918919787907d-01,
     |   1.7136859851326d-02, 5.9552737334987d-04, 3.0279370993418d-07/
      data (pmn(lat, 8,15), lat = 1,36)/
     |   1.1220506851989d-08, 6.7153013009722d-05, 3.3180334002394d-03,
     |   3.6760100378011d-02, 1.8452777763953d-01, 5.4371783938993d-01,
     |   1.0447808152995d+00, 1.3262783857240d+00, 9.6857859567731d-01,
     |   8.9642015003811d-03,-8.6146096662056d-01,-8.6394494086848d-01,
     |   4.9374299068132d-04, 8.1746922682452d-01, 6.9445616220375d-01,
     |  -2.1675900165065d-01,-8.5455030996516d-01,-4.7242139899499d-01,
     |   4.7242139899499d-01, 8.5455030996516d-01, 2.1675900165066d-01,
     |  -6.9445616220375d-01,-8.1746922682452d-01,-4.9374299067700d-04,
     |   8.6394494086848d-01, 8.6146096662056d-01,-8.9642015003805d-03,
     |  -9.6857859567731d-01,-1.3262783857240d+00,-1.0447808152995d+00,
     |  -5.4371783938993d-01,-1.8452777763953d-01,-3.6760100378011d-02,
     |  -3.3180334002395d-03,-6.7153013009722d-05,-1.1220506851989d-08/
      data (pmn(lat, 9,15), lat = 1,36)/
     |   3.5304739048364d-10, 6.4126987786123d-06, 5.4092789204769d-04,
     |   8.7183516058266d-03, 5.9530668851496d-02, 2.3250316311628d-01,
     |   5.9517048922831d-01, 1.0571027454767d+00, 1.2933110386228d+00,
     |   9.4967146170513d-01, 5.6189667435351d-02,-8.0233223013448d-01,
     |  -9.1466407739207d-01,-1.7082422871330d-01, 7.0802704885892d-01,
     |   8.3040211025368d-01, 7.2221039107375d-02,-7.5316447252085d-01,
     |  -7.5316447252085d-01, 7.2221039107374d-02, 8.3040211025368d-01,
     |   7.0802704885892d-01,-1.7082422871330d-01,-9.1466407739207d-01,
     |  -8.0233223013449d-01, 5.6189667435351d-02, 9.4967146170513d-01,
     |   1.2933110386228d+00, 1.0571027454767d+00, 5.9517048922831d-01,
     |   2.3250316311628d-01, 5.9530668851496d-02, 8.7183516058267d-03,
     |   5.4092789204770d-04, 6.4126987786123d-06, 3.5304739048364d-10/
      data (pmn(lat,10,15), lat = 1,36)/
     |   9.4446641103946d-12, 5.1966474542123d-07, 7.4529528198131d-05,
     |   1.7353865927232d-03, 1.5938185463824d-02, 8.0998984963681d-02,
     |   2.6734077985100d-01, 6.2111250326710d-01, 1.0492806141525d+00,
     |   1.2694607023895d+00, 9.7505168959828d-01, 1.6309112776784d-01,
     |  -7.0030840701446d-01,-9.6912028577337d-01,-4.0684876219717d-01,
     |   4.9996050548569d-01, 9.1834500810444d-01, 4.5163459142378d-01,
     |  -4.5163459142378d-01,-9.1834500810444d-01,-4.9996050548569d-01,
     |   4.0684876219717d-01, 9.6912028577337d-01, 7.0030840701446d-01,
     |  -1.6309112776783d-01,-9.7505168959828d-01,-1.2694607023895d+00,
     |  -1.0492806141525d+00,-6.2111250326710d-01,-2.6734077985100d-01,
     |  -8.0998984963681d-02,-1.5938185463824d-02,-1.7353865927232d-03,
     |  -7.4529528198133d-05,-5.1966474542123d-07,-9.4446641103946d-12/
      data (pmn(lat,11,15), lat = 1,36)/
     |   2.1379524409007d-13, 3.5583395998147d-08, 8.6506790440004d-06,
     |   2.8954297001266d-04, 3.5490026861718d-03, 2.3187789918198d-02,
     |   9.6783289570823d-02, 2.8435798044712d-01, 6.1937981757048d-01,
     |   1.0203584060301d+00, 1.2520432503320d+00, 1.0440966121602d+00,
     |   3.4303069982922d-01,-5.2064745545519d-01,-9.8555916582234d-01,
     |  -6.9757123072523d-01, 1.3449902295611d-01, 8.4361747156053d-01,
     |   8.4361747156053d-01, 1.3449902295611d-01,-6.9757123072522d-01,
     |  -9.8555916582234d-01,-5.2064745545519d-01, 3.4303069982923d-01,
     |   1.0440966121602d+00, 1.2520432503320d+00, 1.0203584060301d+00,
     |   6.1937981757048d-01, 2.8435798044712d-01, 9.6783289570824d-02,
     |   2.3187789918198d-02, 3.5490026861718d-03, 2.8954297001266d-04,
     |   8.6506790440006d-06, 3.5583395998147d-08, 2.1379524409007d-13/
      data (pmn(lat,12,15), lat = 1,36)/
     |   4.0429955568261d-15, 2.0332604812684d-09, 8.3598862319075d-07,
     |   4.0071387248952d-05, 6.5181260830129d-04, 5.4292805718943d-03,
     |   2.8297040323746d-02, 1.0306122303097d-01, 2.7971835575102d-01,
     |   5.8655109576664d-01, 9.6404840661840d-01, 1.2291843872043d+00,
     |   1.1463573371247d+00, 6.0671508505647d-01,-2.1146549091368d-01,
     |  -8.7590567874824d-01,-9.7006268960496d-01,-4.1752986786204d-01,
     |   4.1752986786204d-01, 9.7006268960496d-01, 8.7590567874825d-01,
     |   2.1146549091368d-01,-6.0671508505647d-01,-1.1463573371247d+00,
     |  -1.2291843872043d+00,-9.6404840661840d-01,-5.8655109576664d-01,
     |  -2.7971835575102d-01,-1.0306122303097d-01,-2.8297040323746d-02,
     |  -5.4292805718943d-03,-6.5181260830129d-04,-4.0071387248953d-05,
     |  -8.3598862319078d-07,-2.0332604812684d-09,-4.0429955568261d-15/
      data (pmn(lat,13,15), lat = 1,36)/
     |   6.2234132064538d-17, 9.4490666156186d-11, 6.5588665973603d-08,
     |   4.4894047644054d-06, 9.6500132792959d-05, 1.0184928391975d-03,
     |   6.5702675261305d-03, 2.9279734724618d-02, 9.7045051602651d-02,
     |   2.5046238695011d-01, 5.1741136659467d-01, 8.6668217640074d-01,
     |   1.1737133984113d+00, 1.2484417756716d+00, 9.4292340743381d-01,
     |   2.8247936514888d-01,-4.8693391737649d-01,-1.0043089842319d+00,
     |  -1.0043089842319d+00,-4.8693391737649d-01, 2.8247936514888d-01,
     |   9.4292340743380d-01, 1.2484417756716d+00, 1.1737133984113d+00,
     |   8.6668217640075d-01, 5.1741136659467d-01, 2.5046238695011d-01,
     |   9.7045051602651d-02, 2.9279734724618d-02, 6.5702675261306d-03,
     |   1.0184928391975d-03, 9.6500132792959d-05, 4.4894047644054d-06,
     |   6.5588665973605d-08, 9.4490666156186d-11, 6.2234132064538d-17/
      data (pmn(lat,14,15), lat = 1,36)/
     |   7.3910694221188d-19, 3.3856565199740d-12, 3.9618952559322d-09,
     |   3.8637741007837d-07, 1.0938998478045d-05, 1.4561774084888d-04,
     |   1.1552274387601d-03, 6.2421386658494d-03, 2.4934731534501d-02,
     |   7.7646644834524d-02, 1.9524829952570d-01, 4.0572538155775d-01,
     |   7.0634602103360d-01, 1.0352886940747d+00, 1.2694681053627d+00,
     |   1.2678997091107d+00, 9.4855946751141d-01, 3.5277422313138d-01,
     |  -3.5277422313138d-01,-9.4855946751141d-01,-1.2678997091107d+00,
     |  -1.2694681053627d+00,-1.0352886940747d+00,-7.0634602103360d-01,
     |  -4.0572538155775d-01,-1.9524829952570d-01,-7.7646644834524d-02,
     |  -2.4934731534501d-02,-6.2421386658495d-03,-1.1552274387601d-03,
     |  -1.4561774084888d-04,-1.0938998478045d-05,-3.8637741007838d-07,
     |  -3.9618952559323d-09,-3.3856565199740d-12,-7.3910694221188d-19/
      data (pmn(lat,15,15), lat = 1,36)/
     |   5.8916883310749d-21, 8.1378816833451d-14, 1.6036057309585d-10,
     |   2.2241977763854d-08, 8.2725852099713d-07, 1.3839816677807d-05,
     |   1.3436748872552d-04, 8.7448679908862d-04, 4.1715411402611d-03,
     |   1.5470687198532d-02, 4.6456464949153d-02, 1.1627442963141d-01,
     |   2.4773091107352d-01, 4.5632738180281d-01, 7.3508720602516d-01,
     |   1.0441647730790d+00, 1.3154514777212d+00, 1.4751735139291d+00,
     |   1.4751735139291d+00, 1.3154514777212d+00, 1.0441647730790d+00,
     |   7.3508720602516d-01, 4.5632738180281d-01, 2.4773091107352d-01,
     |   1.1627442963141d-01, 4.6456464949153d-02, 1.5470687198532d-02,
     |   4.1715411402611d-03, 8.7448679908862d-04, 1.3436748872552d-04,
     |   1.3839816677807d-05, 8.2725852099713d-07, 2.2241977763854d-08,
     |   1.6036057309586d-10, 8.1378816833451d-14, 5.8916883310749d-21/
      data (pmn(lat, 0,16), lat = 1,36)/
     |   3.5528780032208d+00, 5.3944260128967d-01,-1.5978213192888d+00,
     |  -6.7249203416978d-01, 1.0577020703318d+00, 7.8602205076812d-01,
     |  -7.0743179660523d-01,-8.5529718162561d-01, 4.2195079452984d-01,
     |   8.8159390554846d-01,-1.6960456768584d-01,-8.6693600747253d-01,
     |  -5.8716041581084d-02, 8.1342451126490d-01, 2.6439758210885d-01,
     |  -7.2346264118495d-01,-4.4574837662795d-01, 5.9985561802033d-01,
     |   5.9985561802033d-01,-4.4574837662795d-01,-7.2346264118496d-01,
     |   2.6439758210885d-01, 8.1342451126490d-01,-5.8716041581089d-02,
     |  -8.6693600747253d-01,-1.6960456768584d-01, 8.8159390554846d-01,
     |   4.2195079452984d-01,-8.5529718162560d-01,-7.0743179660524d-01,
     |   7.8602205076812d-01, 1.0577020703318d+00,-6.7249203416978d-01,
     |  -1.5978213192888d+00, 5.3944260128967d-01, 3.5528780032208d+00/
      data (pmn(lat, 1,16), lat = 1,36)/
     |   1.3691792274292d+00, 2.2840861559039d+00, 3.9259711463053d-01,
     |  -1.3572117972755d+00,-6.6031752852877d-01, 9.1844761736903d-01,
     |   7.9427074500842d-01,-5.9407277420623d-01,-8.6103086401509d-01,
     |   3.1730637088492d-01, 8.7636012287672d-01,-6.9413729255253d-02,
     |  -8.4670112662587d-01,-1.5440899762570d-01, 7.7610317569558d-01,
     |   3.5375990668270d-01,-6.6806810231376d-01,-5.2609998832088d-01,
     |   5.2609998832088d-01, 6.6806810231376d-01,-3.5375990668270d-01,
     |  -7.7610317569558d-01, 1.5440899762570d-01, 8.4670112662587d-01,
     |   6.9413729255260d-02,-8.7636012287672d-01,-3.1730637088492d-01,
     |   8.6103086401509d-01, 5.9407277420624d-01,-7.9427074500842d-01,
     |  -9.1844761736903d-01, 6.6031752852877d-01, 1.3572117972755d+00,
     |  -3.9259711463051d-01,-2.2840861559039d+00,-1.3691792274292d+00/
      data (pmn(lat, 2,16), lat = 1,36)/
     |   2.5092721684812d-01, 1.5702596125963d+00, 1.8192742632501d+00,
     |   1.5104794444893d-01,-1.2556457162864d+00,-5.7418150322008d-01,
     |   8.6179730673189d-01, 7.6422517733679d-01,-5.3788128440199d-01,
     |  -8.4946314126469d-01, 2.5208016228961d-01, 8.6475849728034d-01,
     |   5.2849353421123d-03,-8.2421639264917d-01,-2.3559055565892d-01,
     |   7.3568298060579d-01, 4.3669097248594d-01,-6.0486902841540d-01,
     |  -6.0486902841540d-01, 4.3669097248593d-01, 7.3568298060579d-01,
     |  -2.3559055565892d-01,-8.2421639264917d-01, 5.2849353421172d-03,
     |   8.6475849728034d-01, 2.5208016228961d-01,-8.4946314126469d-01,
     |  -5.3788128440200d-01, 7.6422517733679d-01, 8.6179730673189d-01,
     |  -5.7418150322008d-01,-1.2556457162864d+00, 1.5104794444892d-01,
     |   1.8192742632500d+00, 1.5702596125963d+00, 2.5092721684812d-01/
      data (pmn(lat, 3,16), lat = 1,36)/
     |   3.0093009609014d-02, 6.2404453249276d-01, 1.6170835580350d+00,
     |   1.4848712378870d+00,-7.8203685187539d-02,-1.1958426848930d+00,
     |  -4.6845052827162d-01, 8.4278714395144d-01, 7.2351687559462d-01,
     |  -5.1058773451419d-01,-8.3548540512399d-01, 2.0504799819008d-01,
     |   8.5371828435511d-01, 7.1834932883202d-02,-8.0013470742647d-01,
     |  -3.1640935832085d-01, 6.8717253733643d-01, 5.2356387124416d-01,
     |  -5.2356387124416d-01,-6.8717253733643d-01, 3.1640935832084d-01,
     |   8.0013470742647d-01,-7.1834932883201d-02,-8.5371828435511d-01,
     |  -2.0504799819009d-01, 8.3548540512399d-01, 5.1058773451419d-01,
     |  -7.2351687559462d-01,-8.4278714395145d-01, 4.6845052827161d-01,
     |   1.1958426848930d+00, 7.8203685187539d-02,-1.4848712378870d+00,
     |  -1.6170835580350d+00,-6.2404453249276d-01,-3.0093009609014d-02/
      data (pmn(lat, 4,16), lat = 1,36)/
     |   2.6642886526914d-03, 1.7553232510771d-01, 8.7405355194593d-01,
     |   1.5996103564002d+00, 1.1997978794210d+00,-2.7402607092890d-01,
     |  -1.1453000833782d+00,-3.6429534306317d-01, 8.3785828923445d-01,
     |   6.8511328714671d-01,-4.9352465976283d-01,-8.2607160412053d-01,
     |   1.6002409308557d-01, 8.4474430127586d-01, 1.4441839556537d-01,
     |  -7.7022493489330d-01,-4.0803745950190d-01, 6.2031451824331d-01,
     |   6.2031451824331d-01,-4.0803745950190d-01,-7.7022493489330d-01,
     |   1.4441839556537d-01, 8.4474430127585d-01, 1.6002409308556d-01,
     |  -8.2607160412053d-01,-4.9352465976283d-01, 6.8511328714671d-01,
     |   8.3785828923446d-01,-3.6429534306317d-01,-1.1453000833782d+00,
     |  -2.7402607092890d-01, 1.1997978794210d+00, 1.5996103564002d+00,
     |   8.7405355194593d-01, 1.7553232510771d-01, 2.6642886526914d-03/
      data (pmn(lat, 5,16), lat = 1,36)/
     |   1.8537528732869d-04, 3.8047624100363d-02, 3.4433303196088d-01,
     |   1.0484544145651d+00, 1.5391685361327d+00, 9.4939575792031d-01,
     |  -4.3015824073231d-01,-1.0953162128633d+00,-2.7411647147345d-01,
     |   8.3500573693888d-01, 6.5779922909355d-01,-4.7349025909264d-01,
     |  -8.2518259178985d-01, 1.0336905533992d-01, 8.3568348465539d-01,
     |   2.3534018037941d-01,-7.2506672516819d-01,-5.1816066932196d-01,
     |   5.1816066932196d-01, 7.2506672516819d-01,-2.3534018037941d-01,
     |  -8.3568348465539d-01,-1.0336905533992d-01, 8.2518259178986d-01,
     |   4.7349025909265d-01,-6.5779922909355d-01,-8.3500573693888d-01,
     |   2.7411647147344d-01, 1.0953162128633d+00, 4.3015824073232d-01,
     |  -9.4939575792031d-01,-1.5391685361327d+00,-1.0484544145651d+00,
     |  -3.4433303196088d-01,-3.8047624100363d-02,-1.8537528732869d-04/
      data (pmn(lat, 6,16), lat = 1,36)/
     |   1.0519821653567d-05, 6.6541767243378d-03, 1.0649602601150d-01,
     |   5.0524055725649d-01, 1.1643229690634d+00, 1.4519956817763d+00,
     |   7.3468030208608d-01,-5.4584976257273d-01,-1.0472922769016d+00,
     |  -2.0727346469263d-01, 8.2808195876193d-01, 6.4906067795974d-01,
     |  -4.3943037807043d-01,-8.3449730099726d-01, 2.2005738327884d-02,
     |   8.1951608660179d-01, 3.5502066337763d-01,-6.4754406146225d-01,
     |  -6.4754406146225d-01, 3.5502066337763d-01, 8.1951608660179d-01,
     |   2.2005738327886d-02,-8.3449730099726d-01,-4.3943037807042d-01,
     |   6.4906067795974d-01, 8.2808195876193d-01,-2.0727346469263d-01,
     |  -1.0472922769016d+00,-5.4584976257273d-01, 7.3468030208608d-01,
     |   1.4519956817763d+00, 1.1643229690634d+00, 5.0524055725649d-01,
     |   1.0649602601150d-01, 6.6541767243378d-03, 1.0519821653567d-05/
      data (pmn(lat, 7,16), lat = 1,36)/
     |   4.9846823094084d-07, 9.6531695327252d-04, 2.6896490859671d-02,
     |   1.9246636364418d-01, 6.4535205032785d-01, 1.2331707971174d+00,
     |   1.3537276747661d+00, 5.6065396399483d-01,-6.2316571731064d-01,
     |  -1.0067958108907d+00,-1.7196899110199d-01, 8.1286755679121d-01,
     |   6.6543311337617d-01,-3.7953717955782d-01,-8.5171671353076d-01,
     |  -9.7644088066141d-02, 7.8072385150247d-01, 5.0913533737100d-01,
     |  -5.0913533737100d-01,-7.8072385150247d-01, 9.7644088066136d-02,
     |   8.5171671353076d-01, 3.7953717955782d-01,-6.6543311337617d-01,
     |  -8.1286755679121d-01, 1.7196899110199d-01, 1.0067958108907d+00,
     |   6.2316571731064d-01,-5.6065396399483d-01,-1.3537276747661d+00,
     |  -1.2331707971174d+00,-6.4535205032785d-01,-1.9246636364418d-01,
     |  -2.6896490859672d-02,-9.6531695327252d-04,-4.9846823094084d-07/
      data (pmn(lat, 8,16), lat = 1,36)/
     |   2.0017661701382d-08, 1.1817131091885d-04, 5.6759453496988d-03,
     |   6.0121503031124d-02, 2.8267215813847d-01, 7.5825193683194d-01,
     |   1.2660457755158d+00, 1.2592717982527d+00, 4.3288261490675d-01,
     |  -6.6492485635701d-01,-9.8019563839859d-01,-1.7646805225082d-01,
     |   7.8342352897372d-01, 7.1136216251799d-01,-2.7851834809467d-01,
     |  -8.6627818984118d-01,-2.6843519300763d-01, 6.8937503954479d-01,
     |   6.8937503954479d-01,-2.6843519300763d-01,-8.6627818984118d-01,
     |  -2.7851834809467d-01, 7.1136216251799d-01, 7.8342352897372d-01,
     |  -1.7646805225081d-01,-9.8019563839859d-01,-6.6492485635701d-01,
     |   4.3288261490675d-01, 1.2592717982527d+00, 1.2660457755158d+00,
     |   7.5825193683194d-01, 2.8267215813847d-01, 6.0121503031124d-02,
     |   5.6759453496989d-03, 1.1817131091885d-04, 2.0017661701382d-08/
      data (pmn(lat, 9,16), lat = 1,36)/
     |   6.8733425289681d-10, 1.2331919723665d-05, 1.0143085032713d-03,
     |   1.5714065317284d-02, 1.0141296885535d-01, 3.6639299186183d-01,
     |   8.4153120110255d-01, 1.2740609350408d+00, 1.1820819911664d+00,
     |   3.5695839845498d-01,-6.7222318069422d-01,-9.7194833867159d-01,
     |  -2.3013765303641d-01, 7.2779165264851d-01, 7.8577694710403d-01,
     |  -1.1580421143124d-01,-8.5133485741735d-01,-4.9505609886941d-01,
     |   4.9505609886941d-01, 8.5133485741735d-01, 1.1580421143125d-01,
     |  -7.8577694710403d-01,-7.2779165264851d-01, 2.3013765303642d-01,
     |   9.7194833867159d-01, 6.7222318069422d-01,-3.5695839845498d-01,
     |  -1.1820819911664d+00,-1.2740609350408d+00,-8.4153120110255d-01,
     |  -3.6639299186183d-01,-1.0141296885535d-01,-1.5714065317284d-02,
     |  -1.0143085032713d-03,-1.2331919723665d-05,-6.8733425289681d-10/
      data (pmn(lat,10,16), lat = 1,36)/
     |   2.0256848033840d-11, 1.1021957354583d-06, 1.5451422879352d-04,
     |   3.4726946491258d-03, 3.0346611312707d-02, 1.4422615975588d-01,
     |   4.3528516602233d-01, 8.9529583189925d-01, 1.2674181479897d+00,
     |   1.1334528876935d+00, 3.3929871081671d-01,-6.4117722994987d-01,
     |  -9.8109678305198d-01,-3.4348596896498d-01, 6.2253272429361d-01,
     |   8.7385188784622d-01, 1.3185345965254d-01,-7.5150067567358d-01,
     |  -7.5150067567358d-01, 1.3185345965254d-01, 8.7385188784622d-01,
     |   6.2253272429361d-01,-3.4348596896498d-01,-9.8109678305198d-01,
     |  -6.4117722994988d-01, 3.3929871081671d-01, 1.1334528876935d+00,
     |   1.2674181479897d+00, 8.9529583189925d-01, 4.3528516602234d-01,
     |   1.4422615975588d-01, 3.0346611312707d-02, 3.4726946491258d-03,
     |   1.5451422879352d-04, 1.1021957354583d-06, 2.0256848033840d-11/
      data (pmn(lat,11,16), lat = 1,36)/
     |   5.1194046155133d-13, 8.4339231866008d-08, 2.0082075306136d-05,
     |   6.5095266142640d-04, 7.6311171030115d-03, 4.6999486762674d-02,
     |   1.8167461619233d-01, 4.8298717911413d-01, 9.2047437191132d-01,
     |   1.2536792851183d+00, 1.1216165216733d+00, 3.8834312749953d-01,
     |  -5.5859915376419d-01,-9.9497601117807d-01,-5.2444022396534d-01,
     |   4.2715929500869d-01, 9.2963421903313d-01, 4.7316815093353d-01,
     |  -4.7316815093353d-01,-9.2963421903313d-01,-4.2715929500870d-01,
     |   5.2444022396534d-01, 9.9497601117807d-01, 5.5859915376419d-01,
     |  -3.8834312749952d-01,-1.1216165216733d+00,-1.2536792851183d+00,
     |  -9.2047437191132d-01,-4.8298717911413d-01,-1.8167461619233d-01,
     |  -4.6999486762674d-02,-7.6311171030115d-03,-6.5095266142641d-04,
     |  -2.0082075306136d-05,-8.4339231866008d-08,-5.1194046155133d-13/
      data (pmn(lat,12,16), lat = 1,36)/
     |   1.1023494958238d-14, 5.4918177183732d-09, 2.2152736530573d-06,
     |   1.0311649894721d-04, 1.6108570218441d-03, 1.2725868648910d-02,
     |   6.1992814848255d-02, 2.0726982599706d-01, 5.0437738907069d-01,
     |   9.1672014481825d-01, 1.2352485757803d+00, 1.1497220435226d+00,
     |   5.1469729165804d-01,-3.9680445560458d-01,-9.7711377325457d-01,
     |  -7.6393004028276d-01, 8.5726540913541d-02, 8.4680562839792d-01,
     |   8.4680562839793d-01, 8.5726540913542d-02,-7.6393004028276d-01,
     |  -9.7711377325457d-01,-3.9680445560458d-01, 5.1469729165804d-01,
     |   1.1497220435226d+00, 1.2352485757803d+00, 9.1672014481825d-01,
     |   5.0437738907069d-01, 2.0726982599706d-01, 6.1992814848256d-02,
     |   1.2725868648910d-02, 1.6108570218441d-03, 1.0311649894721d-04,
     |   2.2152736530574d-06, 5.4918177183732d-09, 1.1023494958238d-14/
      data (pmn(lat,13,16), lat = 1,36)/
     |   1.9942079351500d-16, 3.0014674411866d-10, 2.0468913683702d-07,
     |   1.3636935506510d-05, 2.8246801519483d-04, 2.8413765951739d-03,
     |   1.7252806106466d-02, 7.1314599100625d-02, 2.1532788842739d-01,
     |   4.9457433166267d-01, 8.7991773142494d-01, 1.2055296304711d+00,
     |   1.2107207126415d+00, 7.2681452826779d-01,-1.1037048753209d-01,
     |  -8.4666285683273d-01,-9.9613605940955d-01,-4.3742998213733d-01,
     |   4.3742998213733d-01, 9.9613605940955d-01, 8.4666285683273d-01,
     |   1.1037048753209d-01,-7.2681452826779d-01,-1.2107207126415d+00,
     |  -1.2055296304711d+00,-8.7991773142494d-01,-4.9457433166267d-01,
     |  -2.1532788842739d-01,-7.1314599100625d-02,-1.7252806106466d-02,
     |  -2.8413765951739d-03,-2.8246801519483d-04,-1.3636935506510d-05,
     |  -2.0468913683702d-07,-3.0014674411866d-10,-1.9942079351500d-16/
      data (pmn(lat,14,16), lat = 1,36)/
     |   2.9504474780822d-18, 1.3405475722780d-11, 1.5431003650549d-08,
     |   1.4676126148259d-06, 4.0153532562544d-05, 5.1147470095937d-04,
     |   3.8406340773621d-03, 1.9400523372545d-02, 7.1404999458422d-02,
     |   2.0129612352680d-01, 4.4807006486128d-01, 7.9956067747145d-01,
     |   1.1429878243369d+00, 1.2755765925821d+00, 1.0139364444533d+00,
     |   3.5286399540314d-01,-4.5674272071044d-01,-1.0137144291690d+00,
     |  -1.0137144291690d+00,-4.5674272071044d-01, 3.5286399540314d-01,
     |   1.0139364444533d+00, 1.2755765925821d+00, 1.1429878243369d+00,
     |   7.9956067747146d-01, 4.4807006486128d-01, 2.0129612352680d-01,
     |   7.1404999458422d-02, 1.9400523372545d-02, 3.8406340773621d-03,
     |   5.1147470095937d-04, 4.0153532562544d-05, 1.4676126148259d-06,
     |   1.5431003650549d-08, 1.3405475722780d-11, 2.9504474780822d-18/
      data (pmn(lat,15,16), lat = 1,36)/
     |   3.3812959606791d-20, 4.6348630633411d-13, 8.9936520774837d-10,
     |   1.2185682932766d-07, 4.3904957902197d-06, 7.0520637786732d-05,
     |   6.5099906110466d-04, 3.9854455719125d-03, 1.7667877737671d-02,
     |   6.0041277089996d-02, 1.6246142466634d-01, 3.5888698729724d-01,
     |   6.5711710107564d-01, 1.0031668211049d+00, 1.2698067697408d+00,
     |   1.2982632327638d+00, 9.8634641818068d-01, 3.6964057553447d-01,
     |  -3.6964057553447d-01,-9.8634641818068d-01,-1.2982632327638d+00,
     |  -1.2698067697408d+00,-1.0031668211049d+00,-6.5711710107564d-01,
     |  -3.5888698729724d-01,-1.6246142466634d-01,-6.0041277089996d-02,
     |  -1.7667877737671d-02,-3.9854455719125d-03,-6.5099906110467d-04,
     |  -7.0520637786732d-05,-4.3904957902197d-06,-1.2185682932766d-07,
     |  -8.9936520774840d-10,-4.6348630633411d-13,-3.3812959606791d-20/
      data (pmn(lat,16,16), lat = 1,36)/
     |   2.6097644270972d-22, 1.0786760120595d-14, 3.5246527050341d-11,
     |   6.7919923351555d-09, 3.2148661104609d-07, 6.4895998370404d-06,
     |   7.3314977433014d-05, 5.4060787348802d-04, 2.8619487856186d-03,
     |   1.1583037712037d-02, 3.7427842648077d-02, 9.9585335405482d-02,
     |   2.2314702674312d-01, 4.2812822074239d-01, 7.1193500367753d-01,
     |   1.0352197079401d+00, 1.3244189318012d+00, 1.4966199774351d+00,
     |   1.4966199774351d+00, 1.3244189318012d+00, 1.0352197079401d+00,
     |   7.1193500367753d-01, 4.2812822074239d-01, 2.2314702674312d-01,
     |   9.9585335405483d-02, 3.7427842648077d-02, 1.1583037712037d-02,
     |   2.8619487856186d-03, 5.4060787348802d-04, 7.3314977433014d-05,
     |   6.4895998370404d-06, 3.2148661104609d-07, 6.7919923351556d-09,
     |   3.5246527050343d-11, 1.0786760120595d-14, 2.6097644270972d-22/
      data (pmn(lat, 0,17), lat = 1,36)/
     |   3.5958053283433d+00, 2.5292886922303d-01,-1.6914201687850d+00,
     |  -2.5275898967813d-01, 1.2588327908676d+00, 2.9431311872774d-01,
     |  -1.0408368762170d+00,-3.3748651126049d-01, 9.0156854407115d-01,
     |   3.7964490712863d-01,-8.0097473727543d-01,-4.2122129392769d-01,
     |   7.2244185984497d-01, 4.6310629861881d-01,-6.5764304301890d-01,
     |  -5.0632763612061d-01, 6.0184310066422d-01, 5.5207716106556d-01,
     |  -5.5207716106556d-01,-6.0184310066422d-01, 5.0632763612061d-01,
     |   6.5764304301890d-01,-4.6310629861880d-01,-7.2244185984496d-01,
     |   4.2122129392768d-01, 8.0097473727543d-01,-3.7964490712863d-01,
     |  -9.0156854407115d-01, 3.3748651126049d-01, 1.0408368762170d+00,
     |  -2.9431311872774d-01,-1.2588327908676d+00, 2.5275898967812d-01,
     |   1.6914201687850d+00,-2.5292886922303d-01,-3.5958053283433d+00/
      data (pmn(lat, 1,17), lat = 1,36)/
     |   1.4832560322403d+00, 2.2692509399373d+00, 2.6036944077455d-02,
     |  -1.4591974583132d+00,-1.8723151171573d-01, 1.1542638571779d+00,
     |   2.7000433816878d-01,-9.7873223733049d-01,-3.3107695584200d-01,
     |   8.5866963368675d-01, 3.8333134885678d-01,-7.6799446279864d-01,
     |  -4.3173461093111d-01, 6.9476484617783d-01, 4.7897374466798d-01,
     |  -6.3256393895700d-01,-5.2697475966818d-01, 5.7750720811917d-01,
     |   5.7750720811917d-01,-5.2697475966818d-01,-6.3256393895701d-01,
     |   4.7897374466797d-01, 6.9476484617784d-01,-4.3173461093112d-01,
     |  -7.6799446279864d-01, 3.8333134885678d-01, 8.5866963368676d-01,
     |  -3.3107695584199d-01,-9.7873223733049d-01, 2.7000433816877d-01,
     |   1.1542638571779d+00,-1.8723151171573d-01,-1.4591974583132d+00,
     |   2.6036944077440d-02, 2.2692509399373d+00, 1.4832560322403d+00/
      data (pmn(lat, 2,17), lat = 1,36)/
     |   2.8925843477840d-01, 1.7234223883778d+00, 1.7104468026714d+00,
     |  -2.7727699598145d-01,-1.3148167890745d+00,-4.0935591896005d-02,
     |   1.0928707767939d+00, 1.9228396382714d-01,-9.4597413461673d-01,
     |  -2.9063658795192d-01, 8.3734543137237d-01, 3.6648190995411d-01,
     |  -7.5059464501902d-01,-4.3161643008473d-01, 6.7712595999507d-01,
     |   4.9190427908206d-01,-6.1177775221259d-01,-5.5099792465931d-01,
     |   5.5099792465931d-01, 6.1177775221259d-01,-4.9190427908206d-01,
     |  -6.7712595999507d-01, 4.3161643008473d-01, 7.5059464501902d-01,
     |  -3.6648190995410d-01,-8.3734543137237d-01, 2.9063658795192d-01,
     |   9.4597413461673d-01,-1.9228396382714d-01,-1.0928707767939d+00,
     |   4.0935591896005d-02, 1.3148167890745d+00, 2.7727699598146d-01,
     |  -1.7104468026714d+00,-1.7234223883778d+00,-2.8925843477840d-01/
      data (pmn(lat, 3,17), lat = 1,36)/
     |   3.6891347630286d-02, 7.3883679526750d-01, 1.7555684848551d+00,
     |   1.2658021245652d+00,-5.4458570737057d-01,-1.1800937999461d+00,
     |   1.2437091781324d-01, 1.0431066423736d+00, 9.4865895701529d-02,
     |  -9.2587896554960d-01,-2.3749531117933d-01, 8.2701615052972d-01,
     |   3.4436696485898d-01,-7.4066906561467d-01,-4.3285131043997d-01,
     |   6.6195167622561d-01, 5.1187589750999d-01,-5.8690025423818d-01,
     |  -5.8690025423818d-01, 5.1187589750998d-01, 6.6195167622561d-01,
     |  -4.3285131043997d-01,-7.4066906561467d-01, 3.4436696485898d-01,
     |   8.2701615052972d-01,-2.3749531117933d-01,-9.2587896554960d-01,
     |   9.4865895701526d-02, 1.0431066423736d+00, 1.2437091781325d-01,
     |  -1.1800937999461d+00,-5.4458570737057d-01, 1.2658021245652d+00,
     |   1.7555684848551d+00, 7.3883679526750d-01, 3.6891347630286d-02/
      data (pmn(lat, 4,17), lat = 1,36)/
     |   3.4760362394319d-03, 2.2287932609254d-01, 1.0432107663225d+00,
     |   1.6849134260813d+00, 8.6810019185297d-01,-7.5191224592463d-01,
     |  -1.0356522940593d+00, 2.8145583751227d-01, 9.9180541806247d-01,
     |  -3.2949829335526d-03,-9.0961613086365d-01,-1.8583745113692d-01,
     |   8.2094515651197d-01, 3.2864248834086d-01,-7.3175768597744d-01,
     |  -4.4554615271167d-01, 6.4157034992448d-01, 5.4762520704301d-01,
     |  -5.4762520704301d-01,-6.4157034992448d-01, 4.4554615271166d-01,
     |   7.3175768597744d-01,-3.2864248834086d-01,-8.2094515651197d-01,
     |   1.8583745113692d-01, 9.0961613086365d-01, 3.2949829335544d-03,
     |  -9.9180541806247d-01,-2.8145583751227d-01, 1.0356522940593d+00,
     |   7.5191224592463d-01,-8.6810019185297d-01,-1.6849134260813d+00,
     |  -1.0432107663225d+00,-2.2287932609254d-01,-3.4760362394319d-03/
      data (pmn(lat, 5,17), lat = 1,36)/
     |   2.5779500937925d-04, 5.1744588876423d-02, 4.4604044724506d-01,
     |   1.2445302371380d+00, 1.5435579630117d+00, 5.1320675321786d-01,
     |  -8.9511124735022d-01,-8.8408003515372d-01, 4.1582945612439d-01,
     |   9.3731073403574d-01,-8.9382057210192d-02,-8.9450813171086d-01,
     |  -1.4698887573979d-01, 8.1535205094864d-01, 3.2972025158570d-01,
     |  -7.1787149190478d-01,-4.7902977698578d-01, 6.0636258155160d-01,
     |   6.0636258155160d-01,-4.7902977698578d-01,-7.1787149190478d-01,
     |   3.2972025158570d-01, 8.1535205094864d-01,-1.4698887573979d-01,
     |  -8.9450813171086d-01,-8.9382057210192d-02, 9.3731073403574d-01,
     |   4.1582945612439d-01,-8.8408003515371d-01,-8.9511124735022d-01,
     |   5.1320675321786d-01, 1.5435579630117d+00, 1.2445302371380d+00,
     |   4.4604044724506d-01, 5.1744588876423d-02, 2.5779500937925d-04/
      data (pmn(lat, 6,17), lat = 1,36)/
     |   1.5629555025213d-05, 9.7007112737039d-03, 1.4911530440782d-01,
     |   6.6073683597337d-01, 1.3593897889734d+00, 1.3588312341577d+00,
     |   2.0851054745770d-01,-9.8002544213310d-01,-7.3645861225967d-01,
     |   5.2034339183291d-01, 8.8466458798531d-01,-1.5384402007479d-01,
     |  -8.8174318799911d-01,-1.3125368669158d-01, 8.0747302104144d-01,
     |   3.5774981870411d-01,-6.9105053859419d-01,-5.4152199038633d-01,
     |   5.4152199038633d-01, 6.9105053859419d-01,-3.5774981870411d-01,
     |  -8.0747302104144d-01, 1.3125368669158d-01, 8.8174318799911d-01,
     |   1.5384402007480d-01,-8.8466458798531d-01,-5.2034339183291d-01,
     |   7.3645861225966d-01, 9.8002544213310d-01,-2.0851054745769d-01,
     |  -1.3588312341577d+00,-1.3593897889734d+00,-6.6073683597337d-01,
     |  -1.4911530440782d-01,-9.7007112737039d-03,-1.5629555025213d-05/
      data (pmn(lat, 7,17), lat = 1,36)/
     |   7.9367016386314d-07, 1.5118673708857d-03, 4.0694515502283d-02,
     |   2.7519472593941d-01, 8.4556323333929d-01, 1.4030863784356d+00,
     |   1.1569527337499d+00,-3.9320815665648d-02,-1.0187495105750d+00,
     |  -6.0623131479995d-01, 5.9273786896594d-01, 8.4222717221312d-01,
     |  -1.8870632131014d-01,-8.7382958971154d-01,-1.4909955567135d-01,
     |   7.9258067191060d-01, 4.2260373835862d-01,-6.3745218766786d-01,
     |  -6.3745218766786d-01, 4.2260373835862d-01, 7.9258067191060d-01,
     |  -1.4909955567135d-01,-8.7382958971154d-01,-1.8870632131013d-01,
     |   8.4222717221312d-01, 5.9273786896594d-01,-6.0623131479995d-01,
     |  -1.0187495105750d+00,-3.9320815665651d-02, 1.1569527337499d+00,
     |   1.4030863784356d+00, 8.4556323333929d-01, 2.7519472593941d-01,
     |   4.0694515502284d-02, 1.5118673708857d-03, 7.9367016386314d-07/
      data (pmn(lat, 8,17), lat = 1,36)/
     |   3.4297079293663d-08, 1.9953449149803d-04, 9.2982625906240d-03,
     |   9.3830053638702d-02, 4.1057200875138d-01, 9.9016350852221d-01,
     |   1.3937316865607d+00, 9.6171910930943d-01,-2.2760455006168d-01,
     |  -1.0265828795482d+00,-5.0637966334911d-01, 6.3318158051579d-01,
     |   8.1911535500673d-01,-1.8560729158989d-01,-8.7139953403842d-01,
     |  -2.1204930291652d-01, 7.5939934740287d-01, 5.3183477906502d-01,
     |  -5.3183477906501d-01,-7.5939934740287d-01, 2.1204930291652d-01,
     |   8.7139953403842d-01, 1.8560729158989d-01,-8.1911535500674d-01,
     |  -6.3318158051580d-01, 5.0637966334911d-01, 1.0265828795482d+00,
     |   2.2760455006168d-01,-9.6171910930943d-01,-1.3937316865607d+00,
     |  -9.9016350852221d-01,-4.1057200875138d-01,-9.3830053638703d-02,
     |  -9.2982625906242d-03,-1.9953449149803d-04,-3.4297079293663d-08/
      data (pmn(lat, 9,17), lat = 1,36)/
     |   1.2740401380960d-09, 2.2560996904138d-05, 1.8063111802889d-03,
     |   2.6818482491263d-02, 1.6276381291564d-01, 5.3923039330389d-01,
     |   1.0923995266586d+00, 1.3515738693457d+00, 7.9320188092489d-01,
     |  -3.5730265337478d-01,-1.0190814838618d+00,-4.4862758188996d-01,
     |   6.4105006368362d-01, 8.2279622575232d-01,-1.3326408523281d-01,
     |  -8.6839988921326d-01,-3.3224182668832d-01, 6.8317255643543d-01,
     |   6.8317255643543d-01,-3.3224182668831d-01,-8.6839988921326d-01,
     |  -1.3326408523281d-01, 8.2279622575232d-01, 6.4105006368362d-01,
     |  -4.4862758188996d-01,-1.0190814838618d+00,-3.5730265337478d-01,
     |   7.9320188092489d-01, 1.3515738693457d+00, 1.0923995266586d+00,
     |   5.3923039330389d-01, 1.6276381291564d-01, 2.6818482491263d-02,
     |   1.8063111802889d-03, 2.2560996904138d-05, 1.2740401380960d-09/
      data (pmn(lat,10,17), lat = 1,36)/
     |   4.0911205368479d-11, 2.1997324910571d-06, 3.0096815456676d-04,
     |   6.5121488440894d-03, 5.3922443244955d-02, 2.3805950585674d-01,
     |   6.4945722503315d-01, 1.1562831954142d+00, 1.2970717258917d+00,
     |   6.6751060821798d-01,-4.3065552215787d-01,-1.0090772971927d+00,
     |  -4.4385324331781d-01, 6.1059560366625d-01, 8.5552005524742d-01,
     |  -1.5079505777141d-02,-8.4397881250935d-01,-5.1701954989262d-01,
     |   5.1701954989262d-01, 8.4397881250935d-01, 1.5079505777146d-02,
     |  -8.5552005524742d-01,-6.1059560366625d-01, 4.4385324331782d-01,
     |   1.0090772971927d+00, 4.3065552215787d-01,-6.6751060821798d-01,
     |  -1.2970717258917d+00,-1.1562831954142d+00,-6.4945722503315d-01,
     |  -2.3805950585674d-01,-5.3922443244955d-02,-6.5121488440895d-03,
     |  -3.0096815456677d-04,-2.1997324910571d-06,-4.0911205368479d-11/
      data (pmn(lat,11,17), lat = 1,36)/
     |   1.1374014504337d-12, 1.8535423535358d-07, 4.3167716597325d-05,
     |   1.3520258461745d-03, 1.5105438183318d-02, 8.7223229554193d-02,
     |   3.0956744059692d-01, 7.3385385654409d-01, 1.1894620565396d+00,
     |   1.2488907637867d+00, 5.9773612551433d-01,-4.4740076978111d-01,
     |  -1.0030414863326d+00,-5.0244613492908d-01, 5.2524734319849d-01,
     |   9.0685420061785d-01, 1.9004995057325d-01,-7.4942973130330d-01,
     |  -7.4942973130330d-01, 1.9004995057324d-01, 9.0685420061785d-01,
     |   5.2524734319849d-01,-5.0244613492908d-01,-1.0030414863326d+00,
     |  -4.4740076978111d-01, 5.9773612551433d-01, 1.2488907637867d+00,
     |   1.1894620565396d+00, 7.3385385654409d-01, 3.0956744059692d-01,
     |   8.7223229554193d-02, 1.5105438183318d-02, 1.3520258461745d-03,
     |   4.3167716597326d-05, 1.8535423535358d-07, 1.1374014504337d-12/
      data (pmn(lat,12,17), lat = 1,36)/
     |   2.7306710879062d-14, 1.3468326339247d-08, 5.3233292505046d-06,
     |   2.4013782019968d-04, 3.5915938398108d-03, 2.6788209224615d-02,
     |   1.2113776573756d-01, 3.6785407516923d-01, 7.8831105751424d-01,
     |   1.2001902985764d+00, 1.2220295329782d+00, 5.9560095671766d-01,
     |  -3.9977256064888d-01,-9.9515367395862d-01,-6.3178860299923d-01,
     |   3.5131000775306d-01, 9.3747582832857d-01, 4.9415983461972d-01,
     |  -4.9415983461972d-01,-9.3747582832857d-01,-3.5131000775306d-01,
     |   6.3178860299922d-01, 9.9515367395862d-01, 3.9977256064888d-01,
     |  -5.9560095671766d-01,-1.2220295329782d+00,-1.2001902985764d+00,
     |  -7.8831105751424d-01,-3.6785407516923d-01,-1.2113776573756d-01,
     |  -2.6788209224615d-02,-3.5915938398108d-03,-2.4013782019968d-04,
     |  -5.3233292505047d-06,-1.3468326339247d-08,-2.7306710879062d-14/
      data (pmn(lat,13,17), lat = 1,36)/
     |   5.6179238923370d-16, 8.3772523662724d-10, 5.6063809898355d-07,
     |   3.6287631640374d-05, 7.2231981358355d-04, 6.8976560559078d-03,
     |   3.9198522394042d-02, 1.4903717306142d-01, 4.0472847792971d-01,
     |   8.1000724825189d-01, 1.1937203494587d+00, 1.2254122139567d+00,
     |   6.7250118485308d-01,-2.6660473727239d-01,-9.5606366149844d-01,
     |  -8.2409189263239d-01, 3.7164784821770d-02, 8.4943966493064d-01,
     |   8.4943966493064d-01, 3.7164784821771d-02,-8.2409189263239d-01,
     |  -9.5606366149844d-01,-2.6660473727239d-01, 6.7250118485309d-01,
     |   1.2254122139567d+00, 1.1937203494587d+00, 8.1000724825189d-01,
     |   4.0472847792971d-01, 1.4903717306142d-01, 3.9198522394042d-02,
     |   6.8976560559078d-03, 7.2231981358355d-04, 3.6287631640375d-05,
     |   5.6063809898356d-07, 8.3772523662724d-10, 5.6179238923370d-16/
      data (pmn(lat,14,17), lat = 1,36)/
     |   9.7570023917591d-18, 4.3948662646925d-11, 4.9710174110847d-08,
     |   4.6028909370512d-06, 1.2139793515282d-04, 1.4745510361148d-03,
     |   1.0429200631100d-02, 4.8913774528657d-02, 1.6424681224112d-01,
     |   4.1298785141963d-01, 7.9462556580650d-01, 1.1676969990632d+00,
     |   1.2570866812189d+00, 8.3668050853790d-01,-8.9614124117620d-03,
     |  -8.1296251420934d-01,-1.0196618097243d+00,-4.5690928574177d-01,
     |   4.5690928574177d-01, 1.0196618097243d+00, 8.1296251420934d-01,
     |   8.9614124117631d-03,-8.3668050853790d-01,-1.2570866812189d+00,
     |  -1.1676969990632d+00,-7.9462556580650d-01,-4.1298785141963d-01,
     |  -1.6424681224112d-01,-4.8913774528657d-02,-1.0429200631100d-02,
     |  -1.4745510361148d-03,-1.2139793515282d-04,-4.6028909370513d-06,
     |  -4.9710174110849d-08,-4.3948662646925d-11,-9.7570023917591d-18/
      data (pmn(lat,15,17), lat = 1,36)/
     |   1.3914923020682d-19, 1.8919394087879d-12, 3.6114956617495d-09,
     |   4.7726008105529d-07, 1.6620005138539d-05, 2.5549872746220d-04,
     |   2.2330743233594d-03, 1.2785427646055d-02, 5.2252188302962d-02,
     |   1.6087871164170d-01, 3.8578919801695d-01, 7.3318616668236d-01,
     |   1.1057900054480d+00, 1.2933906275684d+00, 1.0785062243950d+00,
     |   4.2154435897808d-01,-4.2586402042616d-01,-1.0224103148176d+00,
     |  -1.0224103148176d+00,-4.2586402042616d-01, 4.2154435897808d-01,
     |   1.0785062243950d+00, 1.2933906275684d+00, 1.1057900054480d+00,
     |   7.3318616668236d-01, 3.8578919801695d-01, 1.6087871164170d-01,
     |   5.2252188302962d-02, 1.2785427646055d-02, 2.2330743233595d-03,
     |   2.5549872746220d-04, 1.6620005138539d-05, 4.7726008105530d-07,
     |   3.6114956617496d-09, 1.8919394087879d-12, 1.3914923020682d-19/
      data (pmn(lat,16,17), lat = 1,36)/
     |   1.5424879511945d-21, 6.3269384450245d-14, 2.0357847949986d-10,
     |   3.8322224511965d-08, 1.7571638447073d-06, 3.4054998399645d-05,
     |   3.6581029126352d-04, 2.5373655745082d-03, 1.2483224020600d-02,
     |   4.6295612954164d-02, 1.3479567101319d-01, 3.1655263764625d-01,
     |   6.0958002382213d-01, 9.6927617703756d-01, 1.2665320163637d+00,
     |   1.3255719454412d+00, 1.0227207583998d+00, 3.8621142926986d-01,
     |  -3.8621142926986d-01,-1.0227207583998d+00,-1.3255719454412d+00,
     |  -1.2665320163637d+00,-9.6927617703756d-01,-6.0958002382213d-01,
     |  -3.1655263764625d-01,-1.3479567101319d-01,-4.6295612954164d-02,
     |  -1.2483224020600d-02,-2.5373655745082d-03,-3.6581029126352d-04,
     |  -3.4054998399645d-05,-1.7571638447073d-06,-3.8322224511966d-08,
     |  -2.0357847949986d-10,-6.3269384450245d-14,-1.5424879511945d-21/
      data (pmn(lat,17,17), lat = 1,36)/
     |   1.1549825755501d-23, 1.4285098957951d-15, 7.7401191345758d-12,
     |   2.0722089966910d-09, 1.2482371813646d-07, 3.0403114951299d-06,
     |   3.9967206360823d-05, 3.3390587314056d-04, 1.9617324115520d-03,
     |   8.6645880278578d-03, 3.0127008725427d-02, 8.5215607789713d-02,
     |   2.0082352793137d-01, 4.0131349640491d-01, 6.8889718738320d-01,
     |   1.0254361130647d+00, 1.3322585311760d+00, 1.5170243534235d+00,
     |   1.5170243534235d+00, 1.3322585311760d+00, 1.0254361130647d+00,
     |   6.8889718738320d-01, 4.0131349640491d-01, 2.0082352793137d-01,
     |   8.5215607789713d-02, 3.0127008725427d-02, 8.6645880278578d-03,
     |   1.9617324115521d-03, 3.3390587314056d-04, 3.9967206360824d-05,
     |   3.0403114951299d-06, 1.2482371813646d-07, 2.0722089966911d-09,
     |   7.7401191345761d-12, 1.4285098957951d-15, 1.1549825755501d-23/
      data (pmn(lat, 0,18), lat = 1,36)/
     |   3.6289492556681d+00,-3.8131300663288d-02,-1.7034830585740d+00,
     |   1.9058845538042d-01, 1.2673706118693d+00,-2.6414243130473d-01,
     |  -1.0475234867248d+00, 3.2005170977213d-01, 9.0692859465079d-01,
     |  -3.6886431093692d-01,-8.0521624332865d-01, 4.1450714025531d-01,
     |   7.2563439447989d-01,-4.5915310611028d-01,-6.5977148038667d-01,
     |   5.0440233218590d-01, 6.0282117145915d-01,-5.5173971869651d-01,
     |  -5.5173971869651d-01, 6.0282117145915d-01, 5.0440233218591d-01,
     |  -6.5977148038667d-01,-4.5915310611028d-01, 7.2563439447990d-01,
     |   4.1450714025532d-01,-8.0521624332865d-01,-3.6886431093692d-01,
     |   9.0692859465079d-01, 3.2005170977214d-01,-1.0475234867248d+00,
     |  -2.6414243130473d-01, 1.2673706118693d+00, 1.9058845538043d-01,
     |  -1.7034830585740d+00,-3.8131300663288d-02, 3.6289492556681d+00/
      data (pmn(lat, 1,18), lat = 1,36)/
     |   1.5981408876471d+00, 2.2211307156062d+00,-3.4164334298493d-01,
     |  -1.4295314504758d+00, 3.1386445304156d-01, 1.1317467022234d+00,
     |  -3.3819181068143d-01,-9.6077374059241d-01, 3.7215215670122d-01,
     |   8.4430209857853d-01,-4.0898057075622d-01,-7.5683988201959d-01,
     |   4.4741362425080d-01, 6.8675425760175d-01,-4.8759934284026d-01,
     |  -6.2785163193555d-01, 5.3024644091241d-01, 5.7646542630375d-01,
     |  -5.7646542630375d-01,-5.3024644091242d-01, 6.2785163193555d-01,
     |   4.8759934284026d-01,-6.8675425760175d-01,-4.4741362425079d-01,
     |   7.5683988201958d-01, 4.0898057075622d-01,-8.4430209857853d-01,
     |  -3.7215215670122d-01, 9.6077374059240d-01, 3.3819181068143d-01,
     |  -1.1317467022234d+00,-3.1386445304156d-01, 1.4295314504758d+00,
     |   3.4164334298494d-01,-2.2211307156062d+00,-1.5981408876471d+00/
      data (pmn(lat, 2,18), lat = 1,36)/
     |   3.3059396877948d-01, 1.8681778186971d+00, 1.5413352322932d+00,
     |  -6.8291809449331d-01,-1.1889047177583d+00, 5.0072865986863d-01,
     |   9.9302063240658d-01,-4.5680148275205d-01,-8.6554083203383d-01,
     |   4.5386286035081d-01, 7.7354229726048d-01,-4.6802210571209d-01,
     |  -7.0250297862336d-01, 4.9135591283494d-01, 6.4503375128507d-01,
     |  -5.2098111544088d-01,-5.9701980538816d-01, 5.5609006710755d-01,
     |   5.5609006710755d-01,-5.9701980538816d-01,-5.2098111544089d-01,
     |   6.4503375128506d-01, 4.9135591283495d-01,-7.0250297862337d-01,
     |  -4.6802210571210d-01, 7.7354229726048d-01, 4.5386286035081d-01,
     |  -8.6554083203383d-01,-4.5680148275205d-01, 9.9302063240657d-01,
     |   5.0072865986863d-01,-1.1889047177583d+00,-6.8291809449332d-01,
     |   1.5413352322932d+00, 1.8681778186971d+00, 3.3059396877948d-01/
      data (pmn(lat, 3,18), lat = 1,36)/
     |   4.4686936985290d-02, 8.6224711247529d-01, 1.8608338413873d+00,
     |   9.6536864766137d-01,-9.4207140711801d-01,-9.2856157649197d-01,
     |   6.8034170930015d-01, 8.3656726695021d-01,-5.8048331809146d-01,
     |  -7.5855848552013d-01, 5.4093316142879d-01, 6.9626705964254d-01,
     |  -5.2987118271672d-01,-6.4641691021262d-01, 5.3487392965391d-01,
     |   6.0637389733344d-01,-5.5054507204806d-01,-5.7458841305692d-01,
     |   5.7458841305692d-01, 5.5054507204806d-01,-6.0637389733343d-01,
     |  -5.3487392965391d-01, 6.4641691021262d-01, 5.2987118271672d-01,
     |  -6.9626705964254d-01,-5.4093316142879d-01, 7.5855848552013d-01,
     |   5.8048331809147d-01,-8.3656726695021d-01,-6.8034170930016d-01,
     |   9.2856157649197d-01, 9.4207140711801d-01,-9.6536864766136d-01,
     |  -1.8608338413873d+00,-8.6224711247529d-01,-4.4686936985290d-02/
      data (pmn(lat, 4,18), lat = 1,36)/
     |   4.4648056157243d-03, 2.7811650677745d-01, 1.2170566894348d+00,
     |   1.7003639205896d+00, 4.4846735330122d-01,-1.0944135316253d+00,
     |  -6.4928421204374d-01, 8.2102851359086d-01, 6.6414027545485d-01,
     |  -6.8755123145957d-01,-6.4344885053757d-01, 6.1876437800519d-01,
     |   6.1775580163185d-01,-5.8423911397727d-01,-5.9516963577005d-01,
     |   5.7009669309044d-01, 5.7848324424675d-01,-5.6940864612085d-01,
     |  -5.6940864612085d-01, 5.7848324424675d-01, 5.7009669309044d-01,
     |  -5.9516963577005d-01,-5.8423911397727d-01, 6.1775580163186d-01,
     |   6.1876437800520d-01,-6.4344885053757d-01,-6.8755123145957d-01,
     |   6.6414027545485d-01, 8.2102851359086d-01,-6.4928421204373d-01,
     |  -1.0944135316253d+00, 4.4846735330122d-01, 1.7003639205896d+00,
     |   1.2170566894348d+00, 2.7811650677745d-01, 4.4648056157243d-03/
      data (pmn(lat, 5,18), lat = 1,36)/
     |   3.5155142670949d-04, 6.8909688397901d-02, 5.6366340797655d-01,
     |   1.4269738699420d+00, 1.4363926572329d+00, 2.7511735910820d-03,
     |  -1.1431112162709d+00,-3.6987210139151d-01, 9.1077419232425d-01,
     |   4.8704456130831d-01,-7.6773010614738d-01,-5.2912162994215d-01,
     |   6.7978215026421d-01, 5.4650871109555d-01,-6.2513896009158d-01,
     |  -5.5751392551471d-01, 5.9129547806921d-01, 5.7059880729748d-01,
     |  -5.7059880729748d-01,-5.9129547806921d-01, 5.5751392551471d-01,
     |   6.2513896009158d-01,-5.4650871109555d-01,-6.7978215026421d-01,
     |   5.2912162994215d-01, 7.6773010614738d-01,-4.8704456130831d-01,
     |  -9.1077419232426d-01, 3.6987210139151d-01, 1.1431112162709d+00,
     |  -2.7511735910820d-03,-1.4363926572329d+00,-1.4269738699420d+00,
     |  -5.6366340797655d-01,-6.8909688397901d-02,-3.5155142670949d-04/
      data (pmn(lat, 6,18), lat = 1,36)/
     |   2.2670575341291d-05, 1.3790466429694d-02, 2.0301227846242d-01,
     |   8.3482159647816d-01, 1.5076340836454d+00, 1.1148059005144d+00,
     |  -3.5622925902931d-01,-1.1069761347549d+00,-1.1199436918840d-01,
     |   9.5114706724226d-01, 3.2016698602399d-01,-8.1944057129779d-01,
     |  -4.2723697801189d-01, 7.2168559999535d-01, 4.9304333765525d-01,
     |  -6.4913431188761d-01,-5.4360934186732d-01, 5.9256595743152d-01,
     |   5.9256595743152d-01,-5.4360934186732d-01,-6.4913431188761d-01,
     |   4.9304333765525d-01, 7.2168559999535d-01,-4.2723697801189d-01,
     |  -8.1944057129780d-01, 3.2016698602399d-01, 9.5114706724226d-01,
     |  -1.1199436918840d-01,-1.1069761347549d+00,-3.5622925902932d-01,
     |   1.1148059005144d+00, 1.5076340836454d+00, 8.3482159647817d-01,
     |   2.0301227846242d-01, 1.3790466429694d-02, 2.2670575341291d-05/
      data (pmn(lat, 7,18), lat = 1,36)/
     |   1.2275762153069d-06, 2.2978613800572d-03, 5.9609664363797d-02,
     |   3.7915781933983d-01, 1.0568543846601d+00, 1.4808844516892d+00,
     |   7.7834637367360d-01,-6.2229287287502d-01,-1.0134878578017d+00,
     |   1.0714849148310d-01, 9.5314124568629d-01, 1.7791953761170d-01,
     |  -8.4733153570861d-01,-3.5022557707687d-01, 7.4522220467397d-01,
     |   4.6885137299056d-01,-6.5258887376323d-01,-5.6397425118228d-01,
     |   5.6397425118228d-01, 6.5258887376323d-01,-4.6885137299056d-01,
     |  -7.4522220467397d-01, 3.5022557707687d-01, 8.4733153570861d-01,
     |  -1.7791953761170d-01,-9.5314124568629d-01,-1.0714849148310d-01,
     |   1.0134878578017d+00, 6.2229287287502d-01,-7.7834637367359d-01,
     |  -1.4808844516892d+00,-1.0568543846601d+00,-3.7915781933983d-01,
     |  -5.9609664363798d-02,-2.2978613800572d-03,-1.2275762153069d-06/
      data (pmn(lat, 8,18), lat = 1,36)/
     |   5.6752171975192d-08, 3.2510209060741d-04, 1.4668667133895d-02,
     |   1.4049318589025d-01, 5.6811061759458d-01, 1.2132270587213d+00,
     |   1.3762617932519d+00, 4.6238021819717d-01,-8.0090848131380d-01,
     |  -8.9286879288394d-01, 2.7754661425772d-01, 9.3309027967398d-01,
     |   7.2415736649453d-02,-8.5923106598708d-01,-3.1045165555850d-01,
     |   7.5087934390433d-01, 4.8563189885287d-01,-6.2728042220928d-01,
     |  -6.2728042220928d-01, 4.8563189885287d-01, 7.5087934390433d-01,
     |  -3.1045165555850d-01,-8.5923106598708d-01, 7.2415736649458d-02,
     |   9.3309027967398d-01, 2.7754661425772d-01,-8.9286879288394d-01,
     |  -8.0090848131380d-01, 4.6238021819717d-01, 1.3762617932519d+00,
     |   1.2132270587213d+00, 5.6811061759458d-01, 1.4049318589025d-01,
     |   1.4668667133895d-02, 3.2510209060741d-04, 5.6752171975192d-08/
      data (pmn(lat, 9,18), lat = 1,36)/
     |   2.2649857091908d-09, 3.9555707935262d-05, 3.0773736100460d-03,
     |   4.3650979135623d-02, 2.4779067775759d-01, 7.4522957116917d-01,
     |   1.3024684809864d+00, 1.2272209256446d+00, 1.9200859432468d-01,
     |  -9.0694710040542d-01,-7.7360193824683d-01, 3.9571206219410d-01,
     |   9.0878324308189d-01, 1.3898117050860d-02,-8.6229858196473d-01,
     |  -3.2045062620900d-01, 7.3390159199503d-01, 5.5377595952121d-01,
     |  -5.5377595952121d-01,-7.3390159199503d-01, 3.2045062620899d-01,
     |   8.6229858196473d-01,-1.3898117050858d-02,-9.0878324308189d-01,
     |  -3.9571206219411d-01, 7.7360193824683d-01, 9.0694710040542d-01,
     |  -1.9200859432467d-01,-1.2272209256446d+00,-1.3024684809864d+00,
     |  -7.4522957116917d-01,-2.4779067775759d-01,-4.3650979135624d-02,
     |  -3.0773736100460d-03,-3.9555707935262d-05,-2.2649857091908d-09/
      data (pmn(lat,10,18), lat = 1,36)/
     |   7.8571659237187d-11, 4.1718021864161d-06, 5.5621499282268d-04,
     |   1.1555591059026d-02, 9.0266927788513d-02, 3.6744153498744d-01,
     |   8.9364023439874d-01, 1.3348782828232d+00, 1.0666157588421d+00,
     |  -1.8130883988714d-02,-9.6037357397252d-01,-6.7998976483822d-01,
     |   4.6146785218010d-01, 8.9591623391075d-01, 1.3063124277744d-02,
     |  -8.5778823732514d-01,-3.9312001516192d-01, 6.7671262971605d-01,
     |   6.7671262971605d-01,-3.9312001516192d-01,-8.5778823732514d-01,
     |   1.3063124277742d-02, 8.9591623391075d-01, 4.6146785218010d-01,
     |  -6.7998976483822d-01,-9.6037357397252d-01,-1.8130883988714d-02,
     |   1.0666157588421d+00, 1.3348782828232d+00, 8.9364023439874d-01,
     |   3.6744153498744d-01, 9.0266927788513d-02, 1.1555591059026d-02,
     |   5.5621499282270d-04, 4.1718021864161d-06, 7.8571659237187d-11/
      data (pmn(lat,11,18), lat = 1,36)/
     |   2.3768946427340d-12, 3.8290764699835d-07, 8.7100965382137d-05,
     |   2.6297552855158d-03, 2.7897217841756d-02, 1.5013707123208d-01,
     |   4.8443129093028d-01, 1.0052437556779d+00, 1.3283021091697d+00,
     |   9.2341649364045d-01,-1.6136649219328d-01,-9.8123717533386d-01,
     |  -6.3171443218674d-01, 4.7279424085813d-01, 9.0410659406631d-01,
     |   8.4276047279926d-02,-8.3283936219589d-01,-5.3835654514786d-01,
     |   5.3835654514786d-01, 8.3283936219589d-01,-8.4276047279921d-02,
     |  -9.0410659406631d-01,-4.7279424085813d-01, 6.3171443218674d-01,
     |   9.8123717533386d-01, 1.6136649219328d-01,-9.2341649364045d-01,
     |  -1.3283021091698d+00,-1.0052437556779d+00,-4.8443129093028d-01,
     |  -1.5013707123208d-01,-2.7897217841756d-02,-2.6297552855158d-03,
     |  -8.7100965382139d-05,-3.8290764699835d-07,-2.3768946427340d-12/
      data (pmn(lat,12,18), lat = 1,36)/
     |   6.2697235992605d-14, 3.0597063189854d-08, 1.1834698051780d-05,
     |   5.1629884463675d-04, 7.3693229098877d-03, 5.1639755307945d-02,
     |   2.1511988530868d-01, 5.8579951368322d-01, 1.0795879159727d+00,
     |   1.3036427637038d+00, 8.2144820770573d-01,-2.3429650911149d-01,
     |  -9.8427933923228d-01,-6.4436653419054d-01, 4.1903748940046d-01,
     |   9.2996542080733d-01, 2.4674172327665d-01,-7.4696098773590d-01,
     |  -7.4696098773590d-01, 2.4674172327665d-01, 9.2996542080733d-01,
     |   4.1903748940046d-01,-6.4436653419054d-01,-9.8427933923228d-01,
     |  -2.3429650911149d-01, 8.2144820770573d-01, 1.3036427637038d+00,
     |   1.0795879159727d+00, 5.8579951368322d-01, 2.1511988530868d-01,
     |   5.1639755307945d-02, 7.3693229098877d-03, 5.1629884463676d-04,
     |   1.1834698051780d-05, 3.0597063189854d-08, 6.2697235992605d-14/
      data (pmn(lat,13,18), lat = 1,36)/
     |   1.4365034578505d-15, 2.1210652909767d-09, 1.3913915713073d-06,
     |   8.7328575359628d-05, 1.6657476882720d-03, 1.5037507892797d-02,
     |   7.9484027361999d-02, 2.7532445668083d-01, 6.6189153307167d-01,
     |   1.1209755183366d+00, 1.2806756880526d+00, 7.7995422743913d-01,
     |  -2.3044051311528d-01,-9.7206272395237d-01,-7.2816312205720d-01,
     |   2.7325966295508d-01, 9.4210571403062d-01, 5.1464448637575d-01,
     |  -5.1464448637575d-01,-9.4210571403062d-01,-2.7325966295508d-01,
     |   7.2816312205720d-01, 9.7206272395237d-01, 2.3044051311528d-01,
     |  -7.7995422743913d-01,-1.2806756880526d+00,-1.1209755183366d+00,
     |  -6.6189153307167d-01,-2.7532445668083d-01,-7.9484027361999d-02,
     |  -1.5037507892797d-02,-1.6657476882720d-03,-8.7328575359629d-05,
     |  -1.3913915713074d-06,-2.1210652909767d-09,-1.4365034578505d-15/
      data (pmn(lat,14,18), lat = 1,36)/
     |   2.8342091025250d-17, 1.2649453844813d-10, 1.4044024907630d-07,
     |   1.2638421772033d-05, 3.2050256020522d-04, 3.6986011865864d-03,
     |   2.4511140880010d-02, 1.0592168041750d-01, 3.2072674805669d-01,
     |   7.0577991655444d-01, 1.1342348858966d+00, 1.2739555799933d+00,
     |   8.1466812707465d-01,-1.3287043114688d-01,-9.2371886553721d-01,
     |  -8.7816070772240d-01,-1.1092766276586d-02, 8.5155442380669d-01,
     |   8.5155442380669d-01,-1.1092766276584d-02,-8.7816070772240d-01,
     |  -9.2371886553721d-01,-1.3287043114688d-01, 8.1466812707466d-01,
     |   1.2739555799933d+00, 1.1342348858966d+00, 7.0577991655444d-01,
     |   3.2072674805669d-01, 1.0592168041750d-01, 2.4511140880010d-02,
     |   3.6986011865864d-03, 3.2050256020522d-04, 1.2638421772033d-05,
     |   1.4044024907630d-07, 1.2649453844813d-10, 2.8342091025250d-17/
      data (pmn(lat,15,18), lat = 1,36)/
     |   4.7400038295094d-19, 6.3895165907658d-12, 1.1986534043004d-08,
     |   1.5424905025146d-06, 5.1796699040017d-05, 7.5962341429293d-04,
     |   6.2573697129393d-03, 3.3292829203029d-02, 1.2429074246410d-01,
     |   3.4197943270768d-01, 7.1109021800700d-01, 1.1192366986465d+00,
     |   1.2872494575296d+00, 9.3607651594558d-01, 9.1885810321570d-02,
     |  -7.7530975202913d-01,-1.0407833527574d+00,-4.7599483642139d-01,
     |   4.7599483642139d-01, 1.0407833527574d+00, 7.7530975202913d-01,
     |  -9.1885810321569d-02,-9.3607651594557d-01,-1.2872494575296d+00,
     |  -1.1192366986465d+00,-7.1109021800700d-01,-3.4197943270768d-01,
     |  -1.2429074246410d-01,-3.3292829203029d-02,-6.2573697129394d-03,
     |  -7.5962341429293d-04,-5.1796699040017d-05,-1.5424905025147d-06,
     |  -1.1986534043005d-08,-6.3895165907658d-12,-4.7400038295094d-19/
      data (pmn(lat,16,18), lat = 1,36)/
     |   6.5324362726635d-21, 2.6578595436823d-13, 8.4134948592510d-10,
     |   1.5448624244445d-07, 6.8473384318947d-06, 1.2703569418353d-04,
     |   1.2922931476108d-03, 8.3859887666533d-03, 3.8053006037403d-02,
     |   1.2794672304640d-01, 3.3049092598743d-01, 6.6877903721300d-01,
     |   1.0637318843098d+00, 1.3028987817926d+00, 1.1368741728527d+00,
     |   4.8842368125844d-01,-3.9439612910216d-01,-1.0304551593207d+00,
     |  -1.0304551593207d+00,-3.9439612910216d-01, 4.8842368125844d-01,
     |   1.1368741728527d+00, 1.3028987817926d+00, 1.0637318843098d+00,
     |   6.6877903721300d-01, 3.3049092598743d-01, 1.2794672304640d-01,
     |   3.8053006037403d-02, 8.3859887666534d-03, 1.2922931476108d-03,
     |   1.2703569418353d-04, 6.8473384318947d-06, 1.5448624244445d-07,
     |   8.4134948592513d-10, 2.6578595436823d-13, 6.5324362726635d-21/
      data (pmn(lat,17,18), lat = 1,36)/
     |   7.0187980289568d-23, 8.6149484180039d-15, 4.5965291694182d-11,
     |   1.2021368732439d-08, 7.0147681715357d-07, 1.6403928495055d-05,
     |   2.0503775911434d-04, 1.6113562750048d-03, 8.7977479157869d-03,
     |   3.5606732867349d-02, 1.1155884342148d-01, 2.7850726723398d-01,
     |   5.6405448140043d-01, 9.3416649807832d-01, 1.2600769804228d+00,
     |   1.3500387080711d+00, 1.0577597586054d+00, 4.0250657257225d-01,
     |  -4.0250657257225d-01,-1.0577597586054d+00,-1.3500387080711d+00,
     |  -1.2600769804228d+00,-9.3416649807832d-01,-5.6405448140043d-01,
     |  -2.7850726723398d-01,-1.1155884342148d-01,-3.5606732867349d-02,
     |  -8.7977479157870d-03,-1.6113562750048d-03,-2.0503775911434d-04,
     |  -1.6403928495055d-05,-7.0147681715357d-07,-1.2021368732439d-08,
     |  -4.5965291694184d-11,-8.6149484180039d-15,-7.0187980289568d-23/
      data (pmn(lat,18,18), lat = 1,36)/
     |   5.1074556671442d-25, 1.8902991263613d-16, 1.6983766392377d-12,
     |   6.3172050033427d-10, 4.8426868559220d-08, 1.4232241123554d-06,
     |   2.1770576445726d-05, 2.0607285951007d-04, 1.3436084460637d-03,
     |   6.4763217122402d-03, 2.4231052551950d-02, 7.2861473416598d-02,
     |   1.8058976290137d-01, 3.7587957152921d-01, 6.6607560028111d-01,
     |   1.0149385134615d+00, 1.3390805061170d+00, 1.5364860283163d+00,
     |   1.5364860283163d+00, 1.3390805061170d+00, 1.0149385134615d+00,
     |   6.6607560028111d-01, 3.7587957152921d-01, 1.8058976290137d-01,
     |   7.2861473416599d-02, 2.4231052551950d-02, 6.4763217122402d-03,
     |   1.3436084460637d-03, 2.0607285951007d-04, 2.1770576445726d-05,
     |   1.4232241123554d-06, 4.8426868559220d-08, 6.3172050033429d-10,
     |   1.6983766392378d-12, 1.8902991263613d-16, 5.1074556671442d-25/
      data (pmn(lat, 0,19), lat = 1,36)/
     |   3.6525318135704d+00,-3.2852285694315d-01,-1.6335683818444d+00,
     |   6.1617797331139d-01, 1.0821019201708d+00,-7.6275687759750d-01,
     |  -7.2545470302622d-01, 8.4515218100903d-01, 4.3524843740720d-01,
     |  -8.7788955635013d-01,-1.7902322678098d-01, 8.6651274951171d-01,
     |  -5.2581174125193d-02,-8.1442349374028d-01, 2.6101226407600d-01,
     |   7.2461734710931d-01,-4.4455351220709d-01,-6.0021543532866d-01,
     |   6.0021543532866d-01, 4.4455351220710d-01,-7.2461734710931d-01,
     |  -2.6101226407600d-01, 8.1442349374028d-01, 5.2581174125187d-02,
     |  -8.6651274951171d-01, 1.7902322678098d-01, 8.7788955635013d-01,
     |  -4.3524843740720d-01,-8.4515218100904d-01, 7.2545470302622d-01,
     |   7.6275687759750d-01,-1.0821019201708d+00,-6.1617797331140d-01,
     |   1.6335683818444d+00, 3.2852285694315d-01,-3.6525318135704d+00/
      data (pmn(lat, 1,19), lat = 1,36)/
     |   1.7134847402859d+00, 2.1398618749325d+00,-6.9381843142683d-01,
     |  -1.2705518908771d+00, 7.6775890520589d-01, 8.5570704493696d-01,
     |  -8.4102226922375d-01,-5.4743755739322d-01, 8.8036756777092d-01,
     |   2.8342477480926d-01,-8.8174732579245d-01,-4.6243261178333d-02,
     |   8.4529862933310d-01,-1.6851594329972d-01,-7.7246992867399d-01,
     |   3.6042173862888d-01, 6.6547823324861d-01,-5.2709595739883d-01,
     |  -5.2709595739883d-01, 6.6547823324861d-01, 3.6042173862888d-01,
     |  -7.7246992867399d-01,-1.6851594329972d-01, 8.4529862933310d-01,
     |  -4.6243261178324d-02,-8.8174732579245d-01, 2.8342477480925d-01,
     |   8.8036756777093d-01,-5.4743755739322d-01,-8.4102226922376d-01,
     |   8.5570704493696d-01, 7.6775890520589d-01,-1.2705518908771d+00,
     |  -6.9381843142684d-01, 2.1398618749325d+00, 1.7134847402859d+00/
      data (pmn(lat, 2,19), lat = 1,36)/
     |   3.7493413250097d-01, 2.0014079940128d+00, 1.3159444743230d+00,
     |  -1.0323342372857d+00,-8.9428984730942d-01, 9.3386777661685d-01,
     |   5.9156995971656d-01,-9.2077530740706d-01,-3.3756680501449d-01,
     |   9.0692513197993d-01, 1.0989629163654d-01,-8.7183262608518d-01,
     |   9.7985970970697d-02, 8.0939479811925d-01,-2.8675649097362d-01,
     |  -7.1831220227821d-01, 4.5474056500242d-01, 5.9943383793118d-01,
     |  -5.9943383793118d-01,-4.5474056500243d-01, 7.1831220227820d-01,
     |   2.8675649097362d-01,-8.0939479811925d-01,-9.7985970970692d-02,
     |   8.7183262608518d-01,-1.0989629163654d-01,-9.0692513197993d-01,
     |   3.3756680501449d-01, 9.2077530740706d-01,-5.9156995971655d-01,
     |  -9.3386777661685d-01, 8.9428984730942d-01, 1.0323342372857d+00,
     |  -1.3159444743230d+00,-2.0014079940128d+00,-3.7493413250097d-01/
      data (pmn(lat, 3,19), lat = 1,36)/
     |   5.3552858322217d-02, 9.9307426066656d-01, 1.9252591394821d+00,
     |   6.0011999936868d-01,-1.2184119587461d+00,-4.8922044779870d-01,
     |   1.0375704267610d+00, 3.0215975734206d-01,-9.6125876995770d-01,
     |  -1.1304738281034d-01, 9.0389166692697d-01,-6.8390162647042d-02,
     |  -8.3925662169509d-01, 2.3875870522877d-01, 7.5788901626561d-01,
     |  -3.9528165619095d-01,-6.5664472894519d-01, 5.3532041165143d-01,
     |   5.3532041165143d-01,-6.5664472894519d-01,-3.9528165619096d-01,
     |   7.5788901626561d-01, 2.3875870522877d-01,-8.3925662169509d-01,
     |  -6.8390162647051d-02, 9.0389166692697d-01,-1.1304738281033d-01,
     |  -9.6125876995770d-01, 3.0215975734206d-01, 1.0375704267610d+00,
     |  -4.8922044779870d-01,-1.2184119587461d+00, 6.0011999936867d-01,
     |   1.9252591394821d+00, 9.9307426066656d-01, 5.3552858322217d-02/
      data (pmn(lat, 4,19), lat = 1,36)/
     |   5.6555173415905d-03, 3.4162474465661d-01, 1.3895682926906d+00,
     |   1.6360259251637d+00,-1.8469034132268d-02,-1.2353877307990d+00,
     |  -8.6974622152264d-02, 1.0514151949190d+00, 1.2200809652315d-02,
     |  -9.4668830012348d-01, 1.0614372498353d-01, 8.6528396825416d-01,
     |  -2.3542812837421d-01,-7.8503424260799d-01, 3.6382510030299d-01,
     |   6.9673558152560d-01,-4.8547146896546d-01,-5.9699048490936d-01,
     |   5.9699048490936d-01, 4.8547146896546d-01,-6.9673558152560d-01,
     |  -3.6382510030299d-01, 7.8503424260799d-01, 2.3542812837421d-01,
     |  -8.6528396825416d-01,-1.0614372498353d-01, 9.4668830012348d-01,
     |  -1.2200809652312d-02,-1.0514151949190d+00, 8.6974622152256d-02,
     |   1.2353877307990d+00, 1.8469034132268d-02,-1.6360259251637d+00,
     |  -1.3895682926906d+00,-3.4162474465661d-01,-5.6555173415905d-03/
      data (pmn(lat, 5,19), lat = 1,36)/
     |   4.7113728958001d-04, 9.0057087555132d-02, 6.9626113659424d-01,
     |   1.5810435887781d+00, 1.2130754502768d+00,-5.0598480251914d-01,
     |  -1.1065987123499d+00, 2.7224145974418d-01, 9.7749476883149d-01,
     |  -2.5146512082647d-01,-8.7953867616566d-01, 3.0157188758423d-01,
     |   7.9685625696840d-01,-3.7850148497858d-01,-7.1789622846699d-01,
     |   4.6477667547716d-01, 6.3695238107547d-01,-5.5222577347162d-01,
     |  -5.5222577347162d-01, 6.3695238107547d-01, 4.6477667547717d-01,
     |  -7.1789622846699d-01,-3.7850148497859d-01, 7.9685625696841d-01,
     |   3.0157188758423d-01,-8.7953867616566d-01,-2.5146512082647d-01,
     |   9.7749476883150d-01, 2.7224145974418d-01,-1.1065987123499d+00,
     |  -5.0598480251914d-01, 1.2130754502768d+00, 1.5810435887781d+00,
     |   6.9626113659425d-01, 9.0057087555132d-02, 4.7113728958001d-04/
      data (pmn(lat, 6,19), lat = 1,36)/
     |   3.2193398718578d-05, 1.9170175436539d-02, 2.6945843295795d-01,
     |   1.0210922541813d+00, 1.5841459686507d+00, 7.3336252343279d-01,
     |  -8.4026362285810d-01,-8.7668534131000d-01, 5.5782709875350d-01,
     |   8.3694965429886d-01,-4.6839527555900d-01,-7.7486432699899d-01,
     |   4.6049677397447d-01, 7.1236736157313d-01,-4.8997613023291d-01,
     |  -6.5154245000419d-01, 5.3718104920049d-01, 5.9257114785962d-01,
     |  -5.9257114785962d-01,-5.3718104920049d-01, 6.5154245000419d-01,
     |   4.8997613023291d-01,-7.1236736157313d-01,-4.6049677397446d-01,
     |   7.7486432699899d-01, 4.6839527555900d-01,-8.3694965429886d-01,
     |  -5.5782709875351d-01, 8.7668534131000d-01, 8.4026362285811d-01,
     |  -7.3336252343279d-01,-1.5841459686507d+00,-1.0210922541813d+00,
     |  -2.6945843295795d-01,-1.9170175436539d-02,-3.2193398718578d-05/
      data (pmn(lat, 7,19), lat = 1,36)/
     |   1.8509378741478d-06, 3.4011527525665d-03, 8.4827152011343d-02,
     |   5.0494351208629d-01, 1.2618612377480d+00, 1.4344163902283d+00,
     |   2.6517428722227d-01,-1.0227698175805d+00,-5.9734831504133d-01,
     |   7.5647144740508d-01, 6.6042217137220d-01,-6.2908623065425d-01,
     |  -6.5441003621654d-01, 5.7775960267042d-01, 6.2969175527942d-01,
     |  -5.6723546876428d-01,-6.0199988293756d-01, 5.7883025733503d-01,
     |   5.7883025733503d-01,-6.0199988293756d-01,-5.6723546876429d-01,
     |   6.2969175527942d-01, 5.7775960267043d-01,-6.5441003621655d-01,
     |  -6.2908623065426d-01, 6.6042217137220d-01, 7.5647144740508d-01,
     |  -5.9734831504133d-01,-1.0227698175805d+00, 2.6517428722226d-01,
     |   1.4344163902283d+00, 1.2618612377480d+00, 5.0494351208629d-01,
     |   8.4827152011344d-02, 3.4011527525665d-03, 1.8509378741478d-06/
      data (pmn(lat, 8,19), lat = 1,36)/
     |   9.1101415092176d-08, 5.1339404865939d-04, 2.2383042658994d-02,
     |   2.0267302066740d-01, 7.5141477325998d-01, 1.3941183070894d+00,
     |   1.1819679058580d+00,-1.4127389893745d-01,-1.0767780306094d+00,
     |  -3.1570194469827d-01, 8.7255438577562d-01, 4.7971652870376d-01,
     |  -7.3530168972526d-01,-5.4146069492385d-01, 6.5487090118231d-01,
     |   5.6766217432972d-01,-6.1030669232686d-01,-5.8558200856632d-01,
     |   5.8558200856632d-01, 6.1030669232686d-01,-5.6766217432972d-01,
     |  -6.5487090118231d-01, 5.4146069492384d-01, 7.3530168972525d-01,
     |  -4.7971652870375d-01,-8.7255438577562d-01, 3.1570194469827d-01,
     |   1.0767780306094d+00, 1.4127389893745d-01,-1.1819679058580d+00,
     |  -1.3941183070894d+00,-7.5141477325998d-01,-2.0267302066740d-01,
     |  -2.2383042658994d-02,-5.1339404865939d-04,-9.1101415092176d-08/
      data (pmn(lat, 9,19), lat = 1,36)/
     |   3.8840900518218d-09, 6.6842992567581d-05, 5.0442003889541d-03,
     |   6.8134975397301d-02, 3.5964302685676d-01, 9.7035872950051d-01,
     |   1.4194901153587d+00, 8.8114711125328d-01,-4.5865044409300d-01,
     |  -1.0396102927498d+00,-6.6954495418083d-02, 9.2384205683794d-01,
     |   3.2222349243075d-01,-7.9704931232750d-01,-4.5759567835570d-01,
     |   6.9651571709232d-01, 5.4418588303173d-01,-6.1698356576218d-01,
     |  -6.1698356576219d-01, 5.4418588303173d-01, 6.9651571709233d-01,
     |  -4.5759567835570d-01,-7.9704931232750d-01, 3.2222349243076d-01,
     |   9.2384205683794d-01,-6.6954495418083d-02,-1.0396102927498d+00,
     |  -4.5865044409301d-01, 8.8114711125328d-01, 1.4194901153587d+00,
     |   9.7035872950051d-01, 3.5964302685676d-01, 6.8134975397301d-02,
     |   5.0442003889542d-03, 6.6842992567581d-05, 3.8840900518218d-09/
      data (pmn(lat,10,19), lat = 1,36)/
     |   1.4456400741457d-10, 7.5741927803465d-06, 9.8251996915941d-04,
     |   1.9545069005469d-02, 1.4335898613237d-01, 5.3355269426002d-01,
     |   1.1370523822141d+00, 1.3593763905108d+00, 5.8063474602880d-01,
     |  -6.8157154159563d-01,-9.5353025746086d-01, 1.2771749046803d-01,
     |   9.3507732667544d-01, 2.0904577081826d-01,-8.2739130506153d-01,
     |  -4.2179922802884d-01, 7.0468896970208d-01, 5.7500821317921d-01,
     |  -5.7500821317921d-01,-7.0468896970208d-01, 4.2179922802884d-01,
     |   8.2739130506153d-01,-2.0904577081826d-01,-9.3507732667544d-01,
     |  -1.2771749046804d-01, 9.5353025746086d-01, 6.8157154159563d-01,
     |  -5.8063474602880d-01,-1.3593763905108d+00,-1.1370523822141d+00,
     |  -5.3355269426002d-01,-1.4335898613237d-01,-1.9545069005470d-02,
     |  -9.8251996915943d-04,-7.5741927803465d-06,-1.4456400741457d-10/
      data (pmn(lat,11,19), lat = 1,36)/
     |   4.7184763962510d-12, 7.5092598011232d-07, 1.6660419464418d-04,
     |   4.8372400241015d-03, 4.8533337611299d-02, 2.4186759134070d-01,
     |   7.0128259406867d-01, 1.2430917310512d+00, 1.2465902688527d+00,
     |   3.1725431401076d-01,-8.2116976023622d-01,-8.5841288528694d-01,
     |   2.5853360201641d-01, 9.3143583682388d-01, 1.5671340915911d-01,
     |  -8.3566931343667d-01,-4.5105989628024d-01, 6.6998394152245d-01,
     |   6.6998394152245d-01,-4.5105989628024d-01,-8.3566931343667d-01,
     |   1.5671340915911d-01, 9.3143583682387d-01, 2.5853360201640d-01,
     |  -8.5841288528694d-01,-8.2116976023622d-01, 3.1725431401076d-01,
     |   1.2465902688527d+00, 1.2430917310512d+00, 7.0128259406867d-01,
     |   2.4186759134070d-01, 4.8533337611299d-02, 4.8372400241016d-03,
     |   1.6660419464418d-04, 7.5092598011232d-07, 4.7184763962510d-12/
      data (pmn(lat,12,19), lat = 1,36)/
     |   1.3527169815278d-13, 6.5277621966970d-08, 2.4677049006111d-05,
     |   1.0388979661935d-03, 1.4103872470421d-02, 9.2363868353749d-02,
     |   3.5139491470433d-01, 8.4479199659419d-01, 1.2946594767600d+00,
     |   1.1172825779784d+00, 1.1466683516398d-01,-8.9723923300736d-01,
     |  -7.8765724524788d-01, 3.2086082386785d-01, 9.3233844462056d-01,
     |   1.8129732787023d-01,-8.1823965063624d-01,-5.5910549878167d-01,
     |   5.5910549878167d-01, 8.1823965063624d-01,-1.8129732787023d-01,
     |  -9.3233844462056d-01,-3.2086082386785d-01, 7.8765724524789d-01,
     |   8.9723923300736d-01,-1.1466683516398d-01,-1.1172825779784d+00,
     |  -1.2946594767600d+00,-8.4479199659419d-01,-3.5139491470433d-01,
     |  -9.2363868353749d-02,-1.4103872470421d-02,-1.0388979661935d-03,
     |  -2.4677049006112d-05,-6.5277621966970d-08,-1.3527169815278d-13/
      data (pmn(lat,13,19), lat = 1,36)/
     |   3.4015434743918d-15, 4.9705387539490d-09, 3.1922961704898d-06,
     |   1.9391067766493d-04, 3.5338938288284d-03, 3.0024764631697d-02,
     |   1.4659943078694d-01, 4.5746282255844d-01, 9.5396403053348d-01,
     |   1.3079160246833d+00, 1.0051348730589d+00,-1.3376875257985d-02,
     |  -9.2953948036704d-01,-7.6694278249687d-01, 3.0649780754855d-01,
     |   9.4375003151246d-01, 3.0186751723595d-01,-7.4410764195543d-01,
     |  -7.4410764195543d-01, 3.0186751723594d-01, 9.4375003151246d-01,
     |   3.0649780754855d-01,-7.6694278249687d-01,-9.2953948036703d-01,
     |  -1.3376875257992d-02, 1.0051348730589d+00, 1.3079160246833d+00,
     |   9.5396403053348d-01, 4.5746282255844d-01, 1.4659943078694d-01,
     |   3.0024764631697d-02, 3.5338938288284d-03, 1.9391067766494d-04,
     |   3.1922961704899d-06, 4.9705387539490d-09, 3.4015434743918d-15/
      data (pmn(lat,14,19), lat = 1,36)/
     |   7.4664012857994d-17, 3.3001758584232d-10, 3.5925768717934d-07,
     |   3.1365914229967d-05, 7.6279664415594d-04, 8.3309701200335d-03,
     |   5.1437714626781d-02, 2.0303226719100d-01, 5.4658315151918d-01,
     |   1.0261091398635d+00, 1.3031374243984d+00, 9.3858594825251d-01,
     |  -5.6320811642837d-02,-9.2826424562920d-01,-8.1310247844745d-01,
     |   1.9375844713543d-01, 9.4373806353275d-01, 5.3465234854357d-01,
     |  -5.3465234854357d-01,-9.4373806353275d-01,-1.9375844713543d-01,
     |   8.1310247844745d-01, 9.2826424562920d-01, 5.6320811642833d-02,
     |  -9.3858594825251d-01,-1.3031374243984d+00,-1.0261091398635d+00,
     |  -5.4658315151918d-01,-2.0303226719100d-01,-5.1437714626781d-02,
     |  -8.3309701200335d-03,-7.6279664415594d-04,-3.1365914229968d-05,
     |  -3.5925768717935d-07,-3.3001758584232d-10,-7.4664012857994d-17/
      data (pmn(lat,15,19), lat = 1,36)/
     |   1.4171911028559d-18, 1.8930863301028d-11, 3.4866145834873d-08,
     |   4.3620427868186d-06, 1.4090820189949d-04, 1.9646700925160d-03,
     |   1.5179176194671d-02, 7.4521229842954d-02, 2.5143257879693d-01,
     |   6.0767804877545d-01, 1.0626000087779d+00, 1.2985250129439d+00,
     |   9.4021123105850d-01, 1.9827288641766d-03,-8.8133272091322d-01,
     |  -9.2626316324895d-01,-5.8962675583337d-02, 8.5318247998094d-01,
     |   8.5318247998094d-01,-5.8962675583336d-02,-9.2626316324895d-01,
     |  -8.8133272091322d-01, 1.9827288641756d-03, 9.4021123105851d-01,
     |   1.2985250129439d+00, 1.0626000087779d+00, 6.0767804877546d-01,
     |   2.5143257879693d-01, 7.4521229842954d-02, 1.5179176194671d-02,
     |   1.9646700925160d-03, 1.4090820189949d-04, 4.3620427868187d-06,
     |   3.4866145834874d-08, 1.8930863301028d-11, 1.4171911028559d-18/
      data (pmn(lat,16,19), lat = 1,36)/
     |   2.2883253111955d-20, 9.2312856843336d-13, 2.8721264562213d-09,
     |   5.1364080225829d-07, 2.1959079091472d-05, 3.8879826454477d-04,
     |   3.7296887593523d-03, 2.2508303382779d-02, 9.3401624814855d-02,
     |   2.8111553364067d-01, 6.3133163647501d-01, 1.0631944613981d+00,
     |   1.3030269815601d+00, 1.0249796863597d+00, 1.9143293906478d-01,
     |  -7.3416260196948d-01,-1.0596304370585d+00,-4.9471029983376d-01,
     |   4.9471029983376d-01, 1.0596304370585d+00, 7.3416260196949d-01,
     |  -1.9143293906478d-01,-1.0249796863597d+00,-1.3030269815601d+00,
     |  -1.0631944613981d+00,-6.3133163647501d-01,-2.8111553364067d-01,
     |  -9.3401624814856d-02,-2.2508303382779d-02,-3.7296887593524d-03,
     |  -3.8879826454477d-04,-2.1959079091472d-05,-5.1364080225830d-07,
     |  -2.8721264562214d-09,-9.2312856843336d-13,-2.2883253111955d-20/
      data (pmn(lat,17,19), lat = 1,36)/
     |   3.0541748254861d-22, 3.7186028521691d-14, 1.9520273924115d-10,
     |   4.9801240306393d-08, 2.8094519251166d-06, 6.2901784555796d-05,
     |   7.4474355616915d-04, 5.4772703892859d-03, 2.7594378857412d-02,
     |   1.0131477481558d-01, 2.8185824816513d-01, 6.0719842902952d-01,
     |   1.0181845171157d+00, 1.3050498257464d+00, 1.1892976516225d+00,
     |   5.5342639208610d-01,-3.6242585874280d-01,-1.0379002525137d+00,
     |  -1.0379002525137d+00,-3.6242585874280d-01, 5.5342639208610d-01,
     |   1.1892976516225d+00, 1.3050498257464d+00, 1.0181845171157d+00,
     |   6.0719842902952d-01, 2.8185824816513d-01, 1.0131477481558d-01,
     |   2.7594378857412d-02, 5.4772703892860d-03, 7.4474355616916d-04,
     |   6.2901784555796d-05, 2.8094519251166d-06, 4.9801240306394d-08,
     |   1.9520273924115d-10, 3.7186028521691d-14, 3.0541748254861d-22/
      data (pmn(lat,18,19), lat = 1,36)/
     |   3.1865692445812d-24, 1.1703921582532d-15, 1.0354945661160d-11,
     |   3.7625023144731d-09, 2.7940491176797d-07, 7.8837804327422d-06,
     |   1.1466514481326d-04, 1.0209859262768d-03, 6.1863703120893d-03,
     |   2.7323986608151d-02, 9.2119529435564d-02, 2.4448193649921d-01,
     |   5.2075210138032d-01, 8.9829852634039d-01, 1.2508281095692d+00,
     |   1.3718568209555d+00, 1.0915324718744d+00, 4.1854338327121d-01,
     |  -4.1854338327120d-01,-1.0915324718744d+00,-1.3718568209555d+00,
     |  -1.2508281095692d+00,-8.9829852634039d-01,-5.2075210138032d-01,
     |  -2.4448193649921d-01,-9.2119529435564d-02,-2.7323986608151d-02,
     |  -6.1863703120893d-03,-1.0209859262768d-03,-1.1466514481326d-04,
     |  -7.8837804327422d-06,-2.7940491176797d-07,-3.7625023144732d-09,
     |  -1.0354945661160d-11,-1.1703921582532d-15,-3.1865692445812d-24/
      data (pmn(lat,19,19), lat = 1,36)/
     |   2.2569642109480d-26, 2.4995895914279d-17, 3.7240136433587d-13,
     |   1.9244528714917d-10, 1.8774421022373d-08, 6.6576260534960d-07,
     |   1.1850234860366d-05, 1.2708913697256d-04, 9.1959494742778d-04,
     |   4.8372641510152d-03, 1.9475088473422d-02, 6.2254055195470d-02,
     |   1.6227908749355d-01, 3.5180707919783d-01, 6.4355183299640d-01,
     |   1.0038336531438d+00, 1.3449797918213d+00, 1.5550901541775d+00,
     |   1.5550901541775d+00, 1.3449797918213d+00, 1.0038336531438d+00,
     |   6.4355183299640d-01, 3.5180707919783d-01, 1.6227908749355d-01,
     |   6.2254055195471d-02, 1.9475088473422d-02, 4.8372641510152d-03,
     |   9.1959494742778d-04, 1.2708913697256d-04, 1.1850234860367d-05,
     |   6.6576260534960d-07, 1.8774421022373d-08, 1.9244528714918d-10,
     |   3.7240136433589d-13, 2.4995895914279d-17, 2.2569642109480d-26/
      data (pmn(lat, 0,20), lat = 1,36)/
     |   3.6667579559057d+00,-6.1308840585485d-01,-1.4851550346732d+00,
     |   9.8435651706100d-01, 7.3142527450739d-01,-1.0885729475348d+00,
     |  -1.7574324507944d-01, 1.0205269588781d+00,-2.6536220915116d-01,
     |  -8.1693966148818d-01, 5.8734670006697d-01, 5.1634174716067d-01,
     |  -7.7420230028604d-01,-1.6396931625715d-01, 8.1672051008030d-01,
     |  -1.9084561255259d-01,-7.1885701922655d-01, 4.9941266478554d-01,
     |   4.9941266478554d-01,-7.1885701922655d-01,-1.9084561255260d-01,
     |   8.1672051008030d-01,-1.6396931625715d-01,-7.7420230028604d-01,
     |   5.1634174716066d-01, 5.8734670006697d-01,-8.1693966148818d-01,
     |  -2.6536220915117d-01, 1.0205269588781d+00,-1.7574324507943d-01,
     |  -1.0885729475348d+00, 7.3142527450739d-01, 9.8435651706101d-01,
     |  -1.4851550346732d+00,-6.1308840585485d-01, 3.6667579559057d+00/
      data (pmn(lat, 1,20), lat = 1,36)/
     |   1.8289455250367d+00, 2.0261911077638d+00,-1.0144083582867d+00,
     |  -9.9638420557576d-01, 1.1061335919132d+00, 3.8783719509056d-01,
     |  -1.0817971937412d+00, 9.1237294783502d-02, 9.2725526252920d-01,
     |  -4.6089854972463d-01,-6.6561700966373d-01, 7.0702332488609d-01,
     |   3.3399610865794d-01,-8.1578215694294d-01, 2.2540999441989d-02,
     |   7.8395348516263d-01,-3.5630468428970d-01,-6.2243325384546d-01,
     |   6.2243325384546d-01, 3.5630468428970d-01,-7.8395348516263d-01,
     |  -2.2540999441990d-02, 8.1578215694294d-01,-3.3399610865795d-01,
     |  -7.0702332488610d-01, 6.6561700966373d-01, 4.6089854972463d-01,
     |  -9.2725526252920d-01,-9.1237294783505d-02, 1.0817971937412d+00,
     |  -3.8783719509056d-01,-1.1061335919132d+00, 9.9638420557575d-01,
     |   1.0144083582867d+00,-2.0261911077638d+00,-1.8289455250367d+00/
      data (pmn(lat, 2,20), lat = 1,36)/
     |   4.2226862935624d-01, 2.1200963511211d+00, 1.0410941520806d+00,
     |  -1.2958423516043d+00,-4.7194176180065d-01, 1.1640551339110d+00,
     |   1.0051424275278d-02,-1.0113340495571d+00, 3.6498569122284d-01,
     |   7.7757750083237d-01,-6.3871295556926d-01,-4.7351367005780d-01,
     |   7.9306051069590d-01, 1.3130587492427d-01,-8.1797681117842d-01,
     |   2.0830314195145d-01, 7.1598599080802d-01,-5.0326445163243d-01,
     |  -5.0326445163243d-01, 7.1598599080802d-01, 2.0830314195145d-01,
     |  -8.1797681117842d-01, 1.3130587492427d-01, 7.9306051069589d-01,
     |  -4.7351367005779d-01,-6.3871295556926d-01, 7.7757750083237d-01,
     |   3.6498569122285d-01,-1.0113340495571d+00, 1.0051424275269d-02,
     |   1.1640551339110d+00,-4.7194176180065d-01,-1.2958423516043d+00,
     |   1.0410941520806d+00, 2.1200963511211d+00, 4.2226862935624d-01/
      data (pmn(lat, 3,20), lat = 1,36)/
     |   6.3561595411864d-02, 1.1298647764125d+00, 1.9424945389617d+00,
     |   1.9322640598313d-01,-1.3354519557326d+00, 4.9892698844885d-02,
     |   1.0901124065608d+00,-3.5078091116160d-01,-8.5342012365877d-01,
     |   6.0319325650062d-01, 5.7247608552965d-01,-7.6973409702334d-01,
     |  -2.5444559134515d-01, 8.3040589001516d-01,-7.3351400753800d-02,
     |  -7.7865316342108d-01, 3.7655259449603d-01, 6.2111329331955d-01,
     |  -6.2111329331955d-01,-3.7655259449603d-01, 7.7865316342108d-01,
     |   7.3351400753802d-02,-8.3040589001516d-01, 2.5444559134516d-01,
     |   7.6973409702334d-01,-5.7247608552965d-01,-6.0319325650062d-01,
     |   8.5342012365877d-01, 3.5078091116161d-01,-1.0901124065608d+00,
     |  -4.9892698844885d-02, 1.3354519557326d+00,-1.9322640598311d-01,
     |  -1.9424945389617d+00,-1.1298647764125d+00,-6.3561595411864d-02/
      data (pmn(lat, 4,20), lat = 1,36)/
     |   7.0747882500073d-03, 4.1365745333921d-01, 1.5539884258734d+00,
     |   1.4873752068442d+00,-4.8229111802855d-01,-1.1441135161953d+00,
     |   4.9815739309981d-01, 8.8295041926517d-01,-6.4431019569768d-01,
     |  -6.1909038914700d-01, 7.7387675362806d-01, 3.3131968917008d-01,
     |  -8.3821584769663d-01,-3.0094892253401d-02, 8.1709947218586d-01,
     |  -2.6110593886436d-01,-7.0650568066105d-01, 5.1500678275653d-01,
     |   5.1500678275653d-01,-7.0650568066105d-01,-2.6110593886436d-01,
     |   8.1709947218586d-01,-3.0094892253399d-02,-8.3821584769663d-01,
     |   3.3131968917007d-01, 7.7387675362806d-01,-6.1909038914700d-01,
     |  -6.4431019569769d-01, 8.8295041926517d-01, 4.9815739309982d-01,
     |  -1.1441135161953d+00,-4.8229111802855d-01, 1.4873752068442d+00,
     |   1.5539884258734d+00, 4.1365745333921d-01, 7.0747882500073d-03/
      data (pmn(lat, 5,20), lat = 1,36)/
     |   6.2165187795809d-04, 1.1570863207840d-01, 8.4201220397333d-01,
     |   1.6917914859315d+00, 8.8299885892400d-01,-9.2951780217212d-01,
     |  -7.8817937330980d-01, 8.1454471019484d-01, 5.8065559778274d-01,
     |  -8.3611205652546d-01,-3.4064589791875d-01, 8.6182289972738d-01,
     |   8.2438430009015d-02,-8.4365512371711d-01, 1.7713347300442d-01,
     |   7.6324682971200d-01,-4.1750477373405d-01,-6.1829940462054d-01,
     |   6.1829940462054d-01, 4.1750477373405d-01,-7.6324682971200d-01,
     |  -1.7713347300442d-01, 8.4365512371711d-01,-8.2438430009021d-02,
     |  -8.6182289972739d-01, 3.4064589791875d-01, 8.3611205652546d-01,
     |  -5.8065559778274d-01,-8.1454471019484d-01, 7.8817937330979d-01,
     |   9.2951780217212d-01,-8.8299885892400d-01,-1.6917914859315d+00,
     |  -8.4201220397333d-01,-1.1570863207840d-01,-6.2165187795809d-04/
      data (pmn(lat, 6,20), lat = 1,36)/
     |   4.4860488072257d-05, 2.6118250181751d-02, 3.4944306366681d-01,
     |   1.2106927811454d+00, 1.5678876710188d+00, 2.5452163126064d-01,
     |  -1.1309810331796d+00,-3.5666933780936d-01, 9.7339180015651d-01,
     |   2.3901926934058d-01,-9.1609380021826d-01,-5.7522400430999d-02,
     |   8.7062490550842d-01,-1.4647432250516d-01,-7.9922807092021d-01,
     |   3.5011393729072d-01, 6.8767322963021d-01,-5.3523736373043d-01,
     |  -5.3523736373043d-01, 6.8767322963021d-01, 3.5011393729073d-01,
     |  -7.9922807092020d-01,-1.4647432250516d-01, 8.7062490550843d-01,
     |  -5.7522400430991d-02,-9.1609380021826d-01, 2.3901926934057d-01,
     |   9.7339180015652d-01,-3.5666933780935d-01,-1.1309810331796d+00,
     |   2.5452163126064d-01, 1.5678876710188d+00, 1.2106927811454d+00,
     |   3.4944306366682d-01, 2.6118250181751d-02, 4.4860488072257d-05/
      data (pmn(lat, 7,20), lat = 1,36)/
     |   2.7285096427992d-06, 4.9166850074630d-03, 1.1760080187460d-01,
     |   6.5155712482769d-01, 1.4393806305198d+00, 1.2459318546137d+00,
     |  -2.9513704285213d-01,-1.1142664352365d+00, 6.5847395928682d-02,
     |   9.8446256296073d-01,-8.7855415041429d-02,-8.9801403426956d-01,
     |   1.9599586430023d-01, 8.1949449263054d-01,-3.3545823557482d-01,
     |  -7.2736009318094d-01, 4.7995879168122d-01, 6.1361336199258d-01,
     |  -6.1361336199257d-01,-4.7995879168122d-01, 7.2736009318093d-01,
     |   3.3545823557482d-01,-8.1949449263054d-01,-1.9599586430022d-01,
     |   8.9801403426956d-01, 8.7855415041429d-02,-9.8446256296074d-01,
     |  -6.5847395928686d-02, 1.1142664352365d+00, 2.9513704285214d-01,
     |  -1.2459318546137d+00,-1.4393806305198d+00,-6.5155712482769d-01,
     |  -1.1760080187460d-01,-4.9166850074630d-03,-2.7285096427992d-06/
      data (pmn(lat, 8,20), lat = 1,36)/
     |   1.4238117949993d-07, 7.8863539391092d-04, 3.3153657191154d-02,
     |   2.8262255705217d-01, 9.5217761296307d-01, 1.4969147620986d+00,
     |   8.1257649216018d-01,-7.0211600314434d-01,-9.3920356854991d-01,
     |   4.1838340294130d-01, 8.8407654622159d-01,-3.6118702300037d-01,
     |  -8.1234091782366d-01, 3.9834963077473d-01, 7.3683918131991d-01,
     |  -4.7510988229978d-01,-6.5440579491706d-01, 5.6509245111307d-01,
     |   5.6509245111307d-01,-6.5440579491706d-01,-4.7510988229979d-01,
     |   7.3683918131991d-01, 3.9834963077473d-01,-8.1234091782367d-01,
     |  -3.6118702300038d-01, 8.8407654622159d-01, 4.1838340294131d-01,
     |  -9.3920356854991d-01,-7.0211600314434d-01, 8.1257649216017d-01,
     |   1.4969147620986d+00, 9.5217761296307d-01, 2.8262255705217d-01,
     |   3.3153657191154d-02, 7.8863539391092d-04, 1.4238117949993d-07/
      data (pmn(lat, 9,20), lat = 1,36)/
     |   6.4539173072462d-09, 1.0936176086883d-04, 7.9906388140123d-03,
     |   1.0243553146317d-01, 4.9952561565024d-01, 1.1920754567106d+00,
     |   1.3958202701911d+00, 3.5479433132415d-01,-9.4644280900083d-01,
     |  -6.7802029240028d-01, 6.7168853713664d-01, 7.2107027936759d-01,
     |  -5.6314905590205d-01,-6.9660133083562d-01, 5.4234566821904d-01,
     |   6.5355320385514d-01,-5.6476190076587d-01,-6.0639957044932d-01,
     |   6.0639957044932d-01, 5.6476190076587d-01,-6.5355320385514d-01,
     |  -5.4234566821905d-01, 6.9660133083562d-01, 5.6314905590205d-01,
     |  -7.2107027936758d-01,-6.7168853713664d-01, 6.7802029240028d-01,
     |   9.4644280900083d-01,-3.5479433132415d-01,-1.3958202701911d+00,
     |  -1.1920754567106d+00,-4.9952561565024d-01,-1.0243553146317d-01,
     |  -7.9906388140125d-03,-1.0936176086883d-04,-6.4539173072462d-09/
      data (pmn(lat,10,20), lat = 1,36)/
     |   2.5628770093458d-10, 1.3240647178925d-05, 1.6684284997828d-03,
     |   3.1688850015858d-02, 2.1714661996986d-01, 7.3184468079061d-01,
     |   1.3365459619942d+00, 1.1791646569062d+00,-5.8950230337638d-02,
     |  -1.0452594865400d+00,-3.9716985760070d-01, 8.2608395658608d-01,
     |   5.4372197312726d-01,-6.9497605214378d-01,-5.8722874511483d-01,
     |   6.3146143122142d-01, 5.9834298714755d-01,-6.0653363064651d-01,
     |  -6.0653363064652d-01, 5.9834298714755d-01, 6.3146143122143d-01,
     |  -5.8722874511483d-01,-6.9497605214379d-01, 5.4372197312727d-01,
     |   8.2608395658609d-01,-3.9716985760070d-01,-1.0452594865400d+00,
     |  -5.8950230337642d-02, 1.1791646569062d+00, 1.3365459619942d+00,
     |   7.3184468079061d-01, 2.1714661996986d-01, 3.1688850015859d-02,
     |   1.6684284997829d-03, 1.3240647178925d-05, 2.5628770093458d-10/
      data (pmn(lat,11,20), lat = 1,36)/
     |   8.9646061911503d-12, 1.4084863475734d-06, 3.0435540213191d-04,
     |   8.4768304569842d-03, 8.0107203224232d-02, 3.6702176261636d-01,
     |   9.4297590033381d-01, 1.3795331141573d+00, 9.0341881838478d-01,
     |  -3.8844197861502d-01,-1.0392004062159d+00,-1.4616053013643d-01,
     |   9.0254732773954d-01, 3.9172449645826d-01,-7.6988638410107d-01,
     |  -5.1528626817632d-01, 6.7217581005325d-01, 5.9557378958218d-01,
     |  -5.9557378958218d-01,-6.7217581005326d-01, 5.1528626817632d-01,
     |   7.6988638410107d-01,-3.9172449645826d-01,-9.0254732773953d-01,
     |   1.4616053013642d-01, 1.0392004062159d+00, 3.8844197861502d-01,
     |  -9.0341881838478d-01,-1.3795331141573d+00,-9.4297590033381d-01,
     |  -3.6702176261636d-01,-8.0107203224232d-02,-8.4768304569843d-03,
     |  -3.0435540213192d-04,-1.4084863475734d-06,-8.9646061911503d-12/
      data (pmn(lat,12,20), lat = 1,36)/
     |   2.7698735827059d-13, 1.3209351419868d-07, 4.8741575722174d-05,
     |   1.9758798164009d-03, 2.5423373328675d-02, 1.5470754796725d-01,
     |   5.3218887911669d-01, 1.1072820842536d+00, 1.3392552887022d+00,
     |   6.2301879050696d-01,-6.2166744839265d-01,-9.7776536801279d-01,
     |   4.4971260839361d-02, 9.3137649521858d-01, 2.9456039063846d-01,
     |  -8.0322748958183d-01,-5.0605603301434d-01, 6.6298328540605d-01,
     |   6.6298328540605d-01,-5.0605603301434d-01,-8.0322748958184d-01,
     |   2.9456039063846d-01, 9.3137649521858d-01, 4.4971260839356d-02,
     |  -9.7776536801279d-01,-6.2166744839265d-01, 6.2301879050696d-01,
     |   1.3392552887022d+00, 1.1072820842536d+00, 5.3218887911670d-01,
     |   1.5470754796725d-01, 2.5423373328675d-02, 1.9758798164009d-03,
     |   4.8741575722176d-05, 1.3209351419868d-07, 2.7698735827059d-13/
      data (pmn(lat,13,20), lat = 1,36)/
     |   7.5622763333933d-15, 1.0929942660326d-08, 6.8644747189028d-06,
     |   4.0275416206839d-04, 6.9912609968728d-03, 5.5637635600632d-02,
     |   2.4901588963548d-01, 6.9063320074846d-01, 1.2152484780897d+00,
     |   1.2489771044418d+00, 3.8080092295027d-01,-7.6743231894719d-01,
     |  -9.0810025539149d-01, 1.6070489494060d-01, 9.4130488156840d-01,
     |   2.7517029025136d-01,-8.0047422788323d-01,-5.7929975768699d-01,
     |   5.7929975768699d-01, 8.0047422788323d-01,-2.7517029025136d-01,
     |  -9.4130488156840d-01,-1.6070489494060d-01, 9.0810025539150d-01,
     |   7.6743231894720d-01,-3.8080092295027d-01,-1.2489771044418d+00,
     |  -1.2152484780897d+00,-6.9063320074846d-01,-2.4901588963548d-01,
     |  -5.5637635600632d-02,-6.9912609968728d-03,-4.0275416206839d-04,
     |  -6.8644747189030d-06,-1.0929942660326d-08,-7.5622763333933d-15/
      data (pmn(lat,14,20), lat = 1,36)/
     |   1.8200494825936d-16, 7.9628684025136d-10, 8.4901014200682d-07,
     |   7.1785396584341d-05, 1.6696044170729d-03, 1.7187210574306d-02,
     |   9.8251293126549d-02, 3.5068561171712d-01, 8.2459052720026d-01,
     |   1.2726531080446d+00, 1.1471954813541d+00, 2.0581705019724d-01,
     |  -8.4406498404419d-01,-8.6874577182797d-01, 1.8995996870559d-01,
     |   9.4877581268040d-01, 3.5537393697527d-01,-7.4088489402780d-01,
     |  -7.4088489402780d-01, 3.5537393697526d-01, 9.4877581268040d-01,
     |   1.8995996870559d-01,-8.6874577182797d-01,-8.4406498404419d-01,
     |   2.0581705019724d-01, 1.1471954813541d+00, 1.2726531080446d+00,
     |   8.2459052720026d-01, 3.5068561171712d-01, 9.8251293126550d-02,
     |   1.7187210574306d-02, 1.6696044170729d-03, 7.1785396584342d-05,
     |   8.4901014200684d-07, 7.9628684025136d-10, 1.8200494825936d-16/
      data (pmn(lat,15,20), lat = 1,36)/
     |   3.8399007155261d-18, 5.0804720126359d-11, 9.1770807441562d-08,
     |   1.1143782335589d-05, 3.4544433477231d-04, 4.5628131273207d-03,
     |   3.2890720156197d-02, 1.4781595856714d-01, 4.4500767375654d-01,
     |   9.2362016307739d-01, 1.2954575199285d+00, 1.0703418500008d+00,
     |   1.1775973422605d-01,-8.6637249552980d-01,-8.8636908105702d-01,
     |   1.1347151427727d-01, 9.4256877215822d-01, 5.5420992792079d-01,
     |  -5.5420992792079d-01,-9.4256877215822d-01,-1.1347151427728d-01,
     |   8.8636908105702d-01, 8.6637249552980d-01,-1.1775973422606d-01,
     |  -1.0703418500008d+00,-1.2954575199285d+00,-9.2362016307739d-01,
     |  -4.4500767375655d-01,-1.4781595856714d-01,-3.2890720156197d-02,
     |  -4.5628131273207d-03,-3.4544433477231d-04,-1.1143782335589d-05,
     |  -9.1770807441565d-08,-5.0804720126359d-11,-3.8399007155261d-18/
      data (pmn(lat,16,20), lat = 1,36)/
     |   7.0309179798957d-20, 2.8109055444246d-12, 8.5876202811067d-09,
     |   1.4935172998557d-06, 6.1449035014275d-05, 1.0350110461861d-03,
     |   9.3203909918977d-03, 5.1966809567889d-02, 1.9526595775192d-01,
     |   5.1785566340815d-01, 9.8362719109362d-01, 1.3024288324138d+00,
     |   1.0487694582060d+00, 1.3591008585177d-01,-8.3009658904103d-01,
     |  -9.6854441275637d-01,-1.0637061952573d-01, 8.5435401792527d-01,
     |   8.5435401792527d-01,-1.0637061952572d-01,-9.6854441275637d-01,
     |  -8.3009658904103d-01, 1.3591008585177d-01, 1.0487694582060d+00,
     |   1.3024288324138d+00, 9.8362719109362d-01, 5.1785566340815d-01,
     |   1.9526595775192d-01, 5.1966809567889d-02, 9.3203909918978d-03,
     |   1.0350110461861d-03, 6.1449035014275d-05, 1.4935172998557d-06,
     |   8.5876202811070d-09, 2.8109055444246d-12, 7.0309179798957d-20/
      data (pmn(lat,17,20), lat = 1,36)/
     |   1.0985863665419d-21, 1.3262629398041d-13, 6.8434989241706d-10,
     |   1.7007778878788d-07, 9.2567241215711d-06, 1.9785789188901d-04,
     |   2.2101265087604d-03, 1.5126653619491d-02, 6.9758463432700d-02,
     |   2.2960031586140d-01, 5.5665921379326d-01, 1.0021347007266d+00,
     |   1.3062027039970d+00, 1.1035341526579d+00, 2.8906099154769d-01,
     |  -6.8993784762256d-01,-1.0763212989361d+00,-5.1307654546079d-01,
     |   5.1307654546079d-01, 1.0763212989361d+00, 6.8993784762257d-01,
     |  -2.8906099154769d-01,-1.1035341526579d+00,-1.3062027039970d+00,
     |  -1.0021347007266d+00,-5.5665921379326d-01,-2.2960031586140d-01,
     |  -6.9758463432701d-02,-1.5126653619491d-02,-2.2101265087605d-03,
     |  -1.9785789188901d-04,-9.2567241215711d-06,-1.7007778878789d-07,
     |  -6.8434989241708d-10,-1.3262629398041d-13,-1.0985863665419d-21/
      data (pmn(lat,18,20), lat = 1,36)/
     |   1.4227364219152d-23, 5.1836809255748d-15, 4.5123594764080d-11,
     |   1.5995397553632d-08, 1.1484722213304d-06, 3.1030707818518d-05,
     |   4.2759598230513d-04, 3.5640270015608d-03, 1.9934221150696d-02,
     |   7.9916194907313d-02, 2.3942940035161d-01, 5.4901692921646d-01,
     |   9.7030439004971d-01, 1.3007249496758d+00, 1.2360441952167d+00,
     |   6.1649478121456d-01,-3.3003024277428d-01,-1.0447907890323d+00,
     |  -1.0447907890323d+00,-3.3003024277428d-01, 6.1649478121456d-01,
     |   1.2360441952167d+00, 1.3007249496758d+00, 9.7030439004971d-01,
     |   5.4901692921646d-01, 2.3942940035161d-01, 7.9916194907313d-02,
     |   1.9934221150696d-02, 3.5640270015608d-03, 4.2759598230513d-04,
     |   3.1030707818518d-05, 1.1484722213304d-06, 1.5995397553633d-08,
     |   4.5123594764082d-11, 5.1836809255748d-15, 1.4227364219152d-23/
      data (pmn(lat,19,20), lat = 1,36)/
     |   1.4437867499982d-25, 1.5868256139801d-16, 2.3280092676928d-12,
     |   1.1752187449816d-09, 1.1106413207675d-07, 3.7812922998632d-06,
     |   6.3995299794567d-05, 6.4560519073509d-04, 4.3412959103027d-03,
     |   2.0925463103124d-02, 7.5913409178218d-02, 2.1417861150317d-01,
     |   4.7979982489403d-01, 8.6205735822507d-01, 1.2391311198718d+00,
     |   1.3912027584985d+00, 1.1241010571581d+00, 4.3433723439069d-01,
     |  -4.3433723439069d-01,-1.1241010571581d+00,-1.3912027584985d+00,
     |  -1.2391311198718d+00,-8.6205735822507d-01,-4.7979982489402d-01,
     |  -2.1417861150317d-01,-7.5913409178218d-02,-2.0925463103124d-02,
     |  -4.3412959103028d-03,-6.4560519073510d-04,-6.3995299794568d-05,
     |  -3.7812922998632d-06,-1.1106413207675d-07,-1.1752187449816d-09,
     |  -2.3280092676929d-12,-1.5868256139801d-16,-1.4437867499982d-25/
      data (pmn(lat,20,20), lat = 1,36)/
     |   9.9670392100200d-28, 3.3031500988595d-18, 8.1603718062398d-14,
     |   5.8588316204472d-11, 7.2739137329482d-09, 3.1123392556696d-07,
     |   6.4462243218086d-06, 7.8328081792154d-05, 6.2898726894730d-04,
     |   3.6107101000162d-03, 1.5642567100617d-02, 5.3156792908828d-02,
     |   1.4573149280260d-01, 3.2906512163446d-01, 6.2139101014658d-01,
     |   9.9221364906062d-01, 1.3500388241640d+00, 1.5729102967051d+00,
     |   1.5729102967051d+00, 1.3500388241640d+00, 9.9221364906062d-01,
     |   6.2139101014658d-01, 3.2906512163446d-01, 1.4573149280260d-01,
     |   5.3156792908829d-02, 1.5642567100617d-02, 3.6107101000162d-03,
     |   6.2898726894730d-04, 7.8328081792155d-05, 6.4462243218087d-06,
     |   3.1123392556696d-07, 7.2739137329482d-09, 5.8588316204473d-11,
     |   8.1603718062402d-14, 3.3031500988595d-18, 9.9670392100200d-28/
      data (pmn(lat, 0,21), lat = 1,36)/
     |   3.6718210562406d+00,-8.8680966041573d-01,-1.2654639050702d+00,
     |   1.2608668319850d+00, 2.6898117148348d-01,-1.1678254863253d+00,
     |   4.2911913067973d-01, 7.7364114911669d-01,-8.2644125034113d-01,
     |  -2.2560487136774d-01, 8.9393374032871d-01,-3.1183479855131d-01,
     |  -6.6218828865925d-01, 6.8898606504305d-01, 2.3002609137428d-01,
     |  -8.0722809415940d-01, 2.5696029586045d-01, 6.4378868217426d-01,
     |  -6.4378868217426d-01,-2.5696029586046d-01, 8.0722809415940d-01,
     |  -2.3002609137428d-01,-6.8898606504305d-01, 6.6218828865926d-01,
     |   3.1183479855132d-01,-8.9393374032871d-01, 2.2560487136773d-01,
     |   8.2644125034113d-01,-7.7364114911669d-01,-4.2911913067974d-01,
     |   1.1678254863253d+00,-2.6898117148348d-01,-1.2608668319850d+00,
     |   1.2654639050702d+00, 8.8680966041573d-01,-3.6718210562406d+00/
      data (pmn(lat, 1,21), lat = 1,36)/
     |   1.9441878222093d+00, 1.8814614377479d+00,-1.2886552789608d+00,
     |  -6.3171527504174d-01, 1.2779177727058d+00,-1.6701451410345d-01,
     |  -9.8536277699845d-01, 6.9227985580408d-01, 4.8816277841396d-01,
     |  -9.0668762553353d-01, 7.0575931570483d-02, 8.0665318261174d-01,
     |  -5.3651748947431d-01,-4.5640332871737d-01, 7.8597036949151d-01,
     |  -2.0743950782520d-02,-7.5851348665536d-01, 4.7270330717352d-01,
     |   4.7270330717352d-01,-7.5851348665536d-01,-2.0743950782526d-02,
     |   7.8597036949151d-01,-4.5640332871737d-01,-5.3651748947431d-01,
     |   8.0665318261173d-01, 7.0575931570483d-02,-9.0668762553353d-01,
     |   4.8816277841396d-01, 6.9227985580408d-01,-9.8536277699845d-01,
     |  -1.6701451410345d-01, 1.2779177727058d+00,-6.3171527504173d-01,
     |  -1.2886552789608d+00, 1.8814614377479d+00, 1.9441878222093d+00/
      data (pmn(lat, 2,21), lat = 1,36)/
     |   4.7257674958849d-01, 2.2213890838821d+00, 7.2617035359135d-01,
     |  -1.4504363976151d+00, 1.8127972994104d-02, 1.1404437552374d+00,
     |  -5.7428241345020d-01,-6.9119088001761d-01, 8.7791381901903d-01,
     |   1.4861984810535d-01,-8.9082500408278d-01, 3.6043289788516d-01,
     |   6.3758203005266d-01,-7.0811109506458d-01,-2.0741669068073d-01,
     |   8.0855219206706d-01,-2.6683031052792d-01,-6.4326213874841d-01,
     |   6.4326213874840d-01, 2.6683031052792d-01,-8.0855219206706d-01,
     |   2.0741669068073d-01, 7.0811109506458d-01,-6.3758203005267d-01,
     |  -3.6043289788517d-01, 8.9082500408278d-01,-1.4861984810535d-01,
     |  -8.7791381901904d-01, 6.9119088001761d-01, 5.7428241345021d-01,
     |  -1.1404437552374d+00,-1.8127972994104d-02, 1.4504363976151d+00,
     |  -7.2617035359133d-01,-2.2213890838821d+00,-4.7257674958849d-01/
      data (pmn(lat, 3,21), lat = 1,36)/
     |   7.4784737149878d-02, 1.2709305009659d+00, 1.9078603154260d+00,
     |  -2.2721585541735d-01,-1.2753125395613d+00, 5.7811464205803d-01,
     |   8.2081939601797d-01,-8.6404062515938d-01,-3.1083531296845d-01,
     |   9.3616543058349d-01,-1.9892620742502d-01,-7.6717144118080d-01,
     |   6.0103685077663d-01, 4.0345887637775d-01,-8.0166029231656d-01,
     |   5.4411655175835d-02, 7.5525279485370d-01,-4.8003292383614d-01,
     |  -4.8003292383614d-01, 7.5525279485370d-01, 5.4411655175841d-02,
     |  -8.0166029231656d-01, 4.0345887637775d-01, 6.0103685077662d-01,
     |  -7.6717144118080d-01,-1.9892620742502d-01, 9.3616543058349d-01,
     |  -3.1083531296845d-01,-8.6404062515938d-01, 8.2081939601796d-01,
     |   5.7811464205803d-01,-1.2753125395613d+00,-2.2721585541737d-01,
     |   1.9078603154260d+00, 1.2709305009659d+00, 7.4784737149878d-02/
      data (pmn(lat, 4,21), lat = 1,36)/
     |   8.7509011715863d-03, 4.9432247969512d-01, 1.7030928507349d+00,
     |   1.2562471367623d+00,-8.8908629973397d-01,-8.3391115909127d-01,
     |   9.4252085966810d-01, 3.7729144752400d-01,-9.7969231607840d-01,
     |   9.3025738353286d-02, 8.5357065114883d-01,-5.0106497133380d-01,
     |  -5.5332267969184d-01, 7.6008435151990d-01, 1.3730285327414d-01,
     |  -8.1051282339674d-01, 2.9672659910443d-01, 6.4160834005116d-01,
     |  -6.4160834005116d-01,-2.9672659910443d-01, 8.1051282339674d-01,
     |  -1.3730285327414d-01,-7.6008435151990d-01, 5.5332267969184d-01,
     |   5.0106497133381d-01,-8.5357065114883d-01,-9.3025738353288d-02,
     |   9.7969231607840d-01,-3.7729144752399d-01,-9.4252085966811d-01,
     |   8.3391115909127d-01, 8.8908629973397d-01,-1.2562471367623d+00,
     |  -1.7030928507349d+00,-4.9432247969512d-01,-8.7509011715863d-03/
      data (pmn(lat, 5,21), lat = 1,36)/
     |   8.0883904602403d-04, 1.4638216569772d-01, 9.9817436372105d-01,
     |   1.7453761065612d+00, 4.7003456001058d-01,-1.1928907090891d+00,
     |  -2.6524789453548d-01, 1.0589256009237d+00,-9.3197236640904d-02,
     |  -9.1216298988324d-01, 4.4994750054815d-01, 6.5261549764027d-01,
     |  -7.1605762351246d-01,-2.8729146891275d-01, 8.2535590716197d-01,
     |  -1.2327633130508d-01,-7.4719202795004d-01, 4.9501725803228d-01,
     |   4.9501725803228d-01,-7.4719202795004d-01,-1.2327633130509d-01,
     |   8.2535590716197d-01,-2.8729146891275d-01,-7.1605762351246d-01,
     |   6.5261549764027d-01, 4.4994750054815d-01,-9.1216298988324d-01,
     |  -9.3197236640908d-02, 1.0589256009237d+00,-2.6524789453547d-01,
     |  -1.1928907090891d+00, 4.7003456001058d-01, 1.7453761065612d+00,
     |   9.9817436372106d-01, 1.4638216569772d-01, 8.0883904602403d-04/
      data (pmn(lat, 6,21), lat = 1,36)/
     |   6.1460733333015d-05, 3.4943854620416d-02, 4.4356181372042d-01,
     |   1.3926253476382d+00, 1.4452812716463d+00,-2.5900121630402d-01,
     |  -1.1536865314992d+00, 2.8232854775926d-01, 9.4203270409263d-01,
     |  -4.9624160074861d-01,-6.9728163718306d-01, 7.0686470577784d-01,
     |   3.8034792231715d-01,-8.2608520746692d-01,-1.3677909192200d-02,
     |   8.0669108012225d-01,-3.4746942924097d-01,-6.3859335704942d-01,
     |   6.3859335704942d-01, 3.4746942924097d-01,-8.0669108012224d-01,
     |   1.3677909192199d-02, 8.2608520746692d-01,-3.8034792231716d-01,
     |  -7.0686470577784d-01, 6.9728163718306d-01, 4.9624160074862d-01,
     |  -9.4203270409263d-01,-2.8232854775927d-01, 1.1536865314992d+00,
     |   2.5900121630402d-01,-1.4452812716463d+00,-1.3926253476382d+00,
     |  -4.4356181372043d-01,-3.4943854620416d-02,-6.1460733333015d-05/
      data (pmn(lat, 7,21), lat = 1,36)/
     |   3.9417992661346d-06, 6.9583114480581d-03, 1.5920209151825d-01,
     |   8.1610417644910d-01, 1.5663746040943d+00, 9.1848432443707d-01,
     |  -7.9135870364238d-01,-8.5850429975053d-01, 6.9648269485205d-01,
     |   6.5884438425683d-01,-7.6961916582273d-01,-3.9819107134587d-01,
     |   8.4214991211977d-01, 9.1009156389658d-02,-8.3958888443047d-01,
     |   2.2974247755300d-01, 7.3100536876141d-01,-5.1836491646674d-01,
     |  -5.1836491646674d-01, 7.3100536876141d-01, 2.2974247755301d-01,
     |  -8.3958888443047d-01, 9.1009156389657d-02, 8.4214991211977d-01,
     |  -3.9819107134586d-01,-7.6961916582273d-01, 6.5884438425683d-01,
     |   6.9648269485205d-01,-8.5850429975053d-01,-7.9135870364238d-01,
     |   9.1848432443707d-01, 1.5663746040943d+00, 8.1610417644911d-01,
     |   1.5920209151825d-01, 6.9583114480581d-03, 3.9417992661346d-06/
      data (pmn(lat, 8,21), lat = 1,36)/
     |   2.1729784331802d-07, 1.1819088504337d-03, 4.7807134003085d-02,
     |   3.8197574285229d-01, 1.1574726330017d+00, 1.4893431538604d+00,
     |   3.1032906353428d-01,-1.0645236728781d+00,-4.3002882238345d-01,
     |   9.2419442044989d-01, 2.9888309158047d-01,-8.9520472174089d-01,
     |  -8.2249223176765d-02, 8.6639969249085d-01,-1.7001886941412d-01,
     |  -7.8509321893166d-01, 4.2027694655417d-01, 6.3378516224103d-01,
     |  -6.3378516224103d-01,-4.2027694655417d-01, 7.8509321893166d-01,
     |   1.7001886941413d-01,-8.6639969249085d-01, 8.2249223176771d-02,
     |   8.9520472174089d-01,-2.9888309158047d-01,-9.2419442044989d-01,
     |   4.3002882238344d-01, 1.0645236728781d+00,-3.1032906353427d-01,
     |  -1.4893431538604d+00,-1.1574726330017d+00,-3.8197574285229d-01,
     |  -4.7807134003086d-02,-1.1819088504337d-03,-2.1729784331802d-07/
      data (pmn(lat, 9,21), lat = 1,36)/
     |   1.0429559392146d-08, 1.7387385323740d-04, 1.2278020447682d-02,
     |   1.4884802588164d-01, 6.6580546111047d-01, 1.3808234874846d+00,
     |   1.2020882554082d+00,-2.4805257479573d-01,-1.0908440142828d+00,
     |   1.3902077685942d-02, 9.7105772360873d-01,-5.5781943573114d-02,
     |  -8.9394049759655d-01, 1.9789982305019d-01, 8.1320638655130d-01,
     |  -3.7542239596900d-01,-7.0102132383064d-01, 5.5131050832203d-01,
     |   5.5131050832203d-01,-7.0102132383063d-01,-3.7542239596901d-01,
     |   8.1320638655130d-01, 1.9789982305019d-01,-8.9394049759655d-01,
     |  -5.5781943573122d-02, 9.7105772360873d-01, 1.3902077685943d-02,
     |  -1.0908440142828d+00,-2.4805257479573d-01, 1.2020882554082d+00,
     |   1.3808234874846d+00, 6.6580546111047d-01, 1.4884802588164d-01,
     |   1.2278020447682d-02, 1.7387385323740d-04, 1.0429559392146d-08/
      data (pmn(lat,10,21), lat = 1,36)/
     |   4.3980904097065d-10, 2.2389084969799d-05, 2.7360506059172d-03,
     |   4.9469063772283d-02, 3.1496813293293d-01, 9.5054767820501d-01,
     |   1.4432139589354d+00, 7.8828169481002d-01,-6.7068290637149d-01,
     |  -9.3440116870705d-01, 3.8935826433480d-01, 8.8344190621579d-01,
     |  -3.5008087619713d-01,-8.1061172480706d-01, 4.1337340177184d-01,
     |   7.2618889824739d-01,-5.1645619828565d-01,-6.2647337246074d-01,
     |   6.2647337246074d-01, 5.1645619828565d-01,-7.2618889824739d-01,
     |  -4.1337340177184d-01, 8.1061172480706d-01, 3.5008087619713d-01,
     |  -8.8344190621579d-01,-3.8935826433480d-01, 9.3440116870705d-01,
     |   6.7068290637149d-01,-7.8828169481001d-01,-1.4432139589354d+00,
     |  -9.5054767820501d-01,-3.1496813293293d-01,-4.9469063772283d-02,
     |  -2.7360506059173d-03,-2.2389084969799d-05,-4.3980904097065d-10/
      data (pmn(lat,11,21), lat = 1,36)/
     |   1.6395480028895d-11, 2.5414724969111d-06, 5.3410255810886d-04,
     |   1.4233266745492d-02, 1.2613040093842d-01, 5.2699715589455d-01,
     |   1.1791494195521d+00, 1.3501169306150d+00, 3.4117435424664d-01,
     |  -9.2702613441976d-01,-6.7977881275498d-01, 6.5730710819037d-01,
     |   7.2471659403816d-01,-5.6137246154208d-01,-6.9705090060305d-01,
     |   5.5755872938833d-01, 6.4818106223408d-01,-5.9591414395434d-01,
     |  -5.9591414395434d-01, 6.4818106223408d-01, 5.5755872938834d-01,
     |  -6.9705090060304d-01,-5.6137246154208d-01, 7.2471659403816d-01,
     |   6.5730710819038d-01,-6.7977881275498d-01,-9.2702613441976d-01,
     |   3.4117435424664d-01, 1.3501169306150d+00, 1.1791494195521d+00,
     |   5.2699715589455d-01, 1.2613040093842d-01, 1.4233266745493d-02,
     |   5.3410255810887d-04, 2.5414724969111d-06, 1.6395480028895d-11/
      data (pmn(lat,12,21), lat = 1,36)/
     |   5.4233726428550d-13, 2.5544207846552d-07, 9.1882108416232d-05,
     |   3.5784350517605d-03, 4.3477057015305d-02, 2.4429787807598d-01,
     |   7.5099878510347d-01, 1.3167345273604d+00, 1.1435880784823d+00,
     |  -6.3705338463708d-02,-1.0338317504765d+00,-4.0528246107019d-01,
     |   8.1845085866479d-01, 5.5559069133014d-01,-6.9309616949038d-01,
     |  -6.0030819608440d-01, 6.3673906825905d-01, 6.1550934411783d-01,
     |  -6.1550934411782d-01,-6.3673906825905d-01, 6.0030819608439d-01,
     |   6.9309616949038d-01,-5.5559069133014d-01,-8.1845085866479d-01,
     |   4.0528246107018d-01, 1.0338317504765d+00, 6.3705338463710d-02,
     |  -1.1435880784823d+00,-1.3167345273604d+00,-7.5099878510347d-01,
     |  -2.4429787807598d-01,-4.3477057015305d-02,-3.5784350517606d-03,
     |  -9.1882108416234d-05,-2.5544207846552d-07,-5.4233726428550d-13/
      data (pmn(lat,13,21), lat = 1,36)/
     |   1.5942948337828d-14, 2.2778705180901d-08, 1.3972961060895d-05,
     |   7.9027540704443d-04, 1.3024580005047d-02, 9.6589479450238d-02,
     |   3.9282632017948d-01, 9.5227174856757d-01, 1.3579508059852d+00,
     |   8.8260383559874d-01,-3.8244714401456d-01,-1.0368357572061d+00,
     |  -1.6805292286030d-01, 8.9871169480698d-01, 4.2404632967725d-01,
     |  -7.6160236495058d-01,-5.5810869214669d-01, 6.5571267839743d-01,
     |   6.5571267839744d-01,-5.5810869214669d-01,-7.6160236495058d-01,
     |   4.2404632967725d-01, 8.9871169480698d-01,-1.6805292286030d-01,
     |  -1.0368357572061d+00,-3.8244714401456d-01, 8.8260383559874d-01,
     |   1.3579508059852d+00, 9.5227174856757d-01, 3.9282632017948d-01,
     |   9.6589479450238d-02, 1.3024580005047d-02, 7.9027540704445d-04,
     |   1.3972961060895d-05, 2.2778705180901d-08, 1.5942948337828d-14/
      data (pmn(lat,14,21), lat = 1,36)/
     |   4.1622798845989d-16, 1.8015751475285d-09, 1.8792787830978d-06,
     |   1.5360001018416d-04, 3.4069499101942d-03, 3.2913352671534d-02,
     |   1.7300011818778d-01, 5.5178895633331d-01, 1.1071344941052d+00,
     |   1.3232424294449d+00, 6.2478527057527d-01,-6.0265938134420d-01,
     |  -9.9153750648152d-01,-2.3991163002331d-03, 9.3230609938406d-01,
     |   3.6521297677828d-01,-7.7981322761540d-01,-5.9896857337877d-01,
     |   5.9896857337876d-01, 7.7981322761540d-01,-3.6521297677828d-01,
     |  -9.3230609938406d-01, 2.3991163002315d-03, 9.9153750648153d-01,
     |   6.0265938134421d-01,-6.2478527057527d-01,-1.3232424294449d+00,
     |  -1.1071344941052d+00,-5.5178895633331d-01,-1.7300011818778d-01,
     |  -3.2913352671534d-02,-3.4069499101942d-03,-1.5360001018416d-04,
     |  -1.8792787830979d-06,-1.8015751475285d-09,-4.1622798845989d-16/
      data (pmn(lat,15,21), lat = 1,36)/
     |   9.6204405688466d-18, 1.2601145243652d-10, 2.2301457438750d-07,
     |   2.6240748586977d-05, 7.7860819863786d-04, 9.7058639349251d-03,
     |   6.4904093369738d-02, 2.6460008843045d-01, 6.9970325587229d-01,
     |   1.2083527426457d+00, 1.2487425572210d+00, 4.1572074921799d-01,
     |  -7.3328042590558d-01,-9.4907810922657d-01, 7.1503777803564d-02,
     |   9.4560957219812d-01, 4.0721530797256d-01,-7.3730881938918d-01,
     |  -7.3730881938918d-01, 4.0721530797256d-01, 9.4560957219813d-01,
     |   7.1503777803565d-02,-9.4907810922656d-01,-7.3328042590557d-01,
     |   4.1572074921799d-01, 1.2487425572210d+00, 1.2083527426457d+00,
     |   6.9970325587229d-01, 2.6460008843045d-01, 6.4904093369739d-02,
     |   9.7058639349251d-03, 7.7860819863786d-04, 2.6240748586978d-05,
     |   2.2301457438751d-07, 1.2601145243652d-10, 9.6204405688466d-18/
      data (pmn(lat,16,21), lat = 1,36)/
     |   1.9564070331652d-19, 7.7479188944196d-12, 2.3221079253840d-08,
     |   3.9213020670913d-06, 1.5491228339593d-04, 2.4739119907290d-03,
     |   2.0811129152486d-02, 1.0642040610783d-01, 3.5789719503615d-01,
     |   8.1959673148104d-01, 1.2636296177729d+00, 1.1753433079644d+00,
     |   2.8782668976205d-01,-7.8898058448175d-01,-9.4791053467562d-01,
     |   3.2988768484531d-02, 9.3877809505771d-01, 5.7334065638264d-01,
     |  -5.7334065638264d-01,-9.3877809505771d-01,-3.2988768484537d-02,
     |   9.4791053467562d-01, 7.8898058448175d-01,-2.8782668976206d-01,
     |  -1.1753433079644d+00,-1.2636296177729d+00,-8.1959673148104d-01,
     |  -3.5789719503616d-01,-1.0642040610783d-01,-2.0811129152486d-02,
     |  -2.4739119907290d-03,-1.5491228339593d-04,-3.9213020670913d-06,
     |  -2.3221079253841d-08,-7.7479188944196d-12,-1.9564070331652d-19/
      data (pmn(lat,17,21), lat = 1,36)/
     |   3.4638235035386d-21, 4.1445172113312d-13, 2.1002761263666d-09,
     |   5.0773557485578d-07, 2.6604799898575d-05, 5.4126240513785d-04,
     |   5.6799367961720d-03, 3.5956070234890d-02, 1.5039821562156d-01,
     |   4.3736458429546d-01, 9.0117951840688d-01, 1.2889348571783d+00,
     |   1.1404697900742d+00, 2.6720296294797d-01,-7.7113654189580d-01,
     |  -1.0051644235968d+00,-1.5325047721337d-01, 8.5509687293821d-01,
     |   8.5509687293821d-01,-1.5325047721337d-01,-1.0051644235968d+00,
     |  -7.7113654189580d-01, 2.6720296294797d-01, 1.1404697900742d+00,
     |   1.2889348571783d+00, 9.0117951840688d-01, 4.3736458429546d-01,
     |   1.5039821562156d-01, 3.5956070234890d-02, 5.6799367961720d-03,
     |   5.4126240513785d-04, 2.6604799898575d-05, 5.0773557485579d-07,
     |   2.1002761263666d-09, 4.1445172113312d-13, 3.4638235035386d-21/
      data (pmn(lat,18,21), lat = 1,36)/
     |   5.2478486202546d-23, 1.8959385825246d-14, 1.6224556994274d-10,
     |   5.6033042932629d-08, 3.8823287472313d-06, 1.0017299644885d-04,
     |   1.3028576381071d-03, 1.0111874920455d-02, 5.1815593709471d-02,
     |   1.8645690509798d-01, 4.8783411717429d-01, 9.3817810485121d-01,
     |   1.2984853402391d+00, 1.1720128608624d+00, 3.8425463237435d-01,
     |  -6.4301580080417d-01,-1.0909643612327d+00,-5.3111211127005d-01,
     |   5.3111211127005d-01, 1.0909643612327d+00, 6.4301580080417d-01,
     |  -3.8425463237435d-01,-1.1720128608624d+00,-1.2984853402391d+00,
     |  -9.3817810485121d-01,-4.8783411717429d-01,-1.8645690509798d-01,
     |  -5.1815593709471d-02,-1.0111874920455d-02,-1.3028576381071d-03,
     |  -1.0017299644885d-04,-3.8823287472313d-06,-5.6033042932630d-08,
     |  -1.6224556994275d-10,-1.8959385825246d-14,-5.2478486202546d-23/
      data (pmn(lat,19,21), lat = 1,36)/
     |   6.6058103714170d-25, 7.2022275881007d-16, 1.0396557595899d-11,
     |   5.1205286305333d-09, 4.6792864805603d-07, 1.5257178339952d-05,
     |   2.4468396323009d-04, 2.3112702808007d-03, 1.4351391166807d-02,
     |   6.2818663815732d-02, 2.0266552909061d-01, 4.9458270773814d-01,
     |   9.2105842313388d-01, 1.2907380086433d+00, 1.2773869596056d+00,
     |   6.7758624945579d-01,-2.9727794611886d-01,-1.0511667962678d+00,
     |  -1.0511667962678d+00,-2.9727794611886d-01, 6.7758624945578d-01,
     |   1.2773869596055d+00, 1.2907380086433d+00, 9.2105842313388d-01,
     |   4.9458270773814d-01, 2.0266552909061d-01, 6.2818663815732d-02,
     |   1.4351391166807d-02, 2.3112702808007d-03, 2.4468396323009d-04,
     |   1.5257178339952d-05, 4.6792864805603d-07, 5.1205286305334d-09,
     |   1.0396557595899d-11, 7.2022275881007d-16, 6.6058103714170d-25/
      data (pmn(lat,20,21), lat = 1,36)/
     |   6.5296040320177d-27, 2.1474897664404d-17, 5.2242708857334d-13,
     |   3.6640783030380d-10, 4.4067429645187d-08, 1.8102980442922d-06,
     |   3.5650763406809d-05, 4.0749133052774d-04, 3.0409338102351d-03,
     |   1.5995955770533d-02, 6.2443808363365d-02, 1.8728781488636d-01,
     |   4.4125865940584d-01, 8.2576361171163d-01, 1.2252959493545d+00,
     |   1.4082383767822d+00, 1.1555218300279d+00, 4.4990181464170d-01,
     |  -4.4990181464170d-01,-1.1555218300279d+00,-1.4082383767822d+00,
     |  -1.2252959493545d+00,-8.2576361171163d-01,-4.4125865940584d-01,
     |  -1.8728781488636d-01,-6.2443808363365d-02,-1.5995955770533d-02,
     |  -3.0409338102352d-03,-4.0749133052774d-04,-3.5650763406810d-05,
     |  -1.8102980442922d-06,-4.4067429645187d-08,-3.6640783030381d-10,
     |  -5.2242708857337d-13,-2.1474897664404d-17,-6.5296040320177d-27/
      data (pmn(lat,21,21), lat = 1,36)/
     |   4.3990136640885d-29, 4.3625012086151d-19, 1.7871305541549d-14,
     |   1.7826348947883d-11, 2.8165495068246d-09, 1.4541262448108d-07,
     |   3.5045440326199d-06, 4.8247431865034d-05, 4.2996666247218d-04,
     |   2.6935999027703d-03, 1.2556952858176d-02, 4.5362558923116d-02,
     |   1.3079523430063d-01, 3.0761448474526d-01, 5.9964476981531d-01,
     |   9.8015845980312d-01, 1.3543297134129d+00, 1.5900104882917d+00,
     |   1.5900104882917d+00, 1.3543297134129d+00, 9.8015845980312d-01,
     |   5.9964476981531d-01, 3.0761448474526d-01, 1.3079523430063d-01,
     |   4.5362558923116d-02, 1.2556952858176d-02, 2.6935999027703d-03,
     |   4.2996666247218d-04, 4.8247431865034d-05, 3.5045440326199d-06,
     |   1.4541262448108d-07, 2.8165495068246d-09, 1.7826348947883d-11,
     |   1.7871305541550d-14, 4.3625012086151d-19, 4.3990136640885d-29/
      data (pmn(lat, 0,22), lat = 1,36)/
     |   3.6679072066954d+00,-1.1448877055994d+00,-9.8510402333488d-01,
     |   1.4200176100173d+00,-2.3455968294700d-01,-9.8261221188894d-01,
     |   8.9939151732300d-01, 2.0667183606562d-01,-9.5294914268870d-01,
     |   5.1220609917296d-01, 5.0074213600892d-01,-8.5136563234338d-01,
     |   1.6285071589728d-01, 6.9116434466577d-01,-6.7843646193270d-01,
     |  -1.5849159538469d-01, 7.8593790300057d-01,-4.4327641914363d-01,
     |  -4.4327641914363d-01, 7.8593790300057d-01,-1.5849159538468d-01,
     |  -6.7843646193270d-01, 6.9116434466577d-01, 1.6285071589727d-01,
     |  -8.5136563234338d-01, 5.0074213600892d-01, 5.1220609917296d-01,
     |  -9.5294914268871d-01, 2.0667183606562d-01, 8.9939151732301d-01,
     |  -9.8261221188894d-01,-2.3455968294700d-01, 1.4200176100173d+00,
     |  -9.8510402333486d-01,-1.1448877055994d+00, 3.6679072066954d+00/
      data (pmn(lat, 1,22), lat = 1,36)/
     |   2.0588826700205d+00, 1.7075883291498d+00,-1.5038393165244d+00,
     |  -2.0958156249029d-01, 1.2570669294511d+00,-6.8432513098337d-01,
     |  -5.8166776993858d-01, 1.0080671875985d+00,-2.0680366572515d-01,
     |  -7.6518571974438d-01, 7.5156108803496d-01, 1.6053185230997d-01,
     |  -8.2982775661259d-01, 4.6613327467185d-01, 4.5051925900646d-01,
     |  -7.9288069594751d-01, 1.5811226405588d-01, 6.6365616720366d-01,
     |  -6.6365616720366d-01,-1.5811226405588d-01, 7.9288069594751d-01,
     |  -4.5051925900646d-01,-4.6613327467185d-01, 8.2982775661259d-01,
     |  -1.6053185230996d-01,-7.5156108803496d-01, 7.6518571974438d-01,
     |   2.0680366572516d-01,-1.0080671875985d+00, 5.8166776993857d-01,
     |   6.8432513098337d-01,-1.2570669294511d+00, 2.0958156249028d-01,
     |   1.5038393165244d+00,-1.7075883291498d+00,-2.0588826700205d+00/
      data (pmn(lat, 2,22), lat = 1,36)/
     |   5.2582756514223d-01, 2.3026540071959d+00, 3.8274506787115d-01,
     |  -1.4820491925413d+00, 5.0538858777439d-01, 8.6744814005783d-01,
     |  -9.8251392548972d-01,-9.0044344482012d-02, 9.3473228254815d-01,
     |  -5.7568598673551d-01,-4.5035878305901d-01, 8.6216411925913d-01,
     |  -2.0165743756682d-01,-6.7533352483516d-01, 6.9243589062108d-01,
     |   1.4314625443401d-01,-7.8564133415251d-01, 4.4673643928306d-01,
     |   4.4673643928306d-01,-7.8564133415251d-01, 1.4314625443400d-01,
     |   6.9243589062108d-01,-6.7533352483516d-01,-2.0165743756681d-01,
     |   8.6216411925913d-01,-4.5035878305901d-01,-5.7568598673552d-01,
     |   9.3473228254815d-01,-9.0044344482008d-02,-9.8251392548973d-01,
     |   8.6744814005783d-01, 5.0538858777439d-01,-1.4820491925413d+00,
     |   3.8274506787113d-01, 2.3026540071959d+00, 5.2582756514223d-01/
      data (pmn(lat, 3,22), lat = 1,36)/
     |   8.7292685134103d-02, 1.4143716554062d+00, 1.8186797119720d+00,
     |  -6.3042554148395d-01,-1.0438241984085d+00, 9.8514315315791d-01,
     |   3.0810589682090d-01,-1.0330832856219d+00, 3.9010692041942d-01,
     |   6.7387489514958d-01,-8.1637922271113d-01,-6.2918242152932d-02,
     |   8.1436173877210d-01,-5.1803412952508d-01,-4.1326272646006d-01,
     |   8.0172278748524d-01,-1.7724586818211d-01,-6.6281635505835d-01,
     |   6.6281635505835d-01, 1.7724586818211d-01,-8.0172278748524d-01,
     |   4.1326272646006d-01, 5.1803412952508d-01,-8.1436173877210d-01,
     |   6.2918242152923d-02, 8.1637922271113d-01,-6.7387489514958d-01,
     |  -3.9010692041943d-01, 1.0330832856219d+00,-3.0810589682089d-01,
     |  -9.8514315315791d-01, 1.0438241984085d+00, 6.3042554148396d-01,
     |  -1.8186797119720d+00,-1.4143716554062d+00,-8.7292685134103d-02/
      data (pmn(lat, 4,22), lat = 1,36)/
     |   1.0713766698539d-02, 5.8356620089845d-01, 1.8295042607501d+00,
     |   9.5126409650646d-01,-1.1887333715149d+00,-3.6183009370386d-01,
     |   1.1190196887577d+00,-2.7285877455061d-01,-8.2546548260530d-01,
     |   7.4586532993151d-01, 2.8397904324480d-01,-8.7820473996000d-01,
     |   3.1731942619143d-01, 6.2149677283716d-01,-7.3180345429774d-01,
     |  -9.6032166894278d-02, 7.8409872528890d-01,-4.5725343896706d-01,
     |  -4.5725343896706d-01, 7.8409872528890d-01,-9.6032166894271d-02,
     |  -7.3180345429774d-01, 6.2149677283715d-01, 3.1731942619143d-01,
     |  -8.7820473996000d-01, 2.8397904324480d-01, 7.4586532993151d-01,
     |  -8.2546548260530d-01,-2.7285877455061d-01, 1.1190196887577d+00,
     |  -3.6183009370386d-01,-1.1887333715149d+00, 9.5126409650645d-01,
     |   1.8295042607501d+00, 5.8356620089845d-01, 1.0713766698539d-02/
      data (pmn(lat, 5,22), lat = 1,36)/
     |   1.0391241513675d-03, 1.8257870017229d-01, 1.1610901935783d+00,
     |   1.7304330487357d+00, 1.0945700898739d-02,-1.2454500449061d+00,
     |   3.2678355685875d-01, 9.1250985255583d-01,-7.2020712161987d-01,
     |  -4.3137967660666d-01, 9.0214586141398d-01,-1.3959357006202d-01,
     |  -7.6109301996275d-01, 6.1569934555464d-01, 3.3291873291415d-01,
     |  -8.1602020202768d-01, 2.1615906642750d-01, 6.6100464124425d-01,
     |  -6.6100464124425d-01,-2.1615906642750d-01, 8.1602020202768d-01,
     |  -3.3291873291415d-01,-6.1569934555464d-01, 7.6109301996275d-01,
     |   1.3959357006203d-01,-9.0214586141398d-01, 4.3137967660666d-01,
     |   7.2020712161987d-01,-9.1250985255582d-01,-3.2678355685876d-01,
     |   1.2454500449061d+00,-1.0945700898739d-02,-1.7304330487357d+00,
     |  -1.1610901935783d+00,-1.8257870017229d-01,-1.0391241513675d-03/
      data (pmn(lat, 6,22), lat = 1,36)/
     |   8.2924760298547d-05, 4.5985002937663d-02, 5.5190872582470d-01,
     |   1.5543227950321d+00, 1.2132671630388d+00,-7.3098367006969d-01,
     |  -8.9560393016704d-01, 8.2078171398294d-01, 4.7384335757451d-01,
     |  -9.3483866460467d-01, 3.0341569026052d-02, 8.4662021549335d-01,
     |  -5.0223323741627d-01,-5.1109789231888d-01, 7.8756291519954d-01,
     |   1.4116929333311d-02,-7.7924859854894d-01, 4.7525955527527d-01,
     |   4.7525955527528d-01,-7.7924859854894d-01, 1.4116929333304d-02,
     |   7.8756291519954d-01,-5.1109789231888d-01,-5.0223323741626d-01,
     |   8.4662021549335d-01, 3.0341569026052d-02,-9.3483866460467d-01,
     |   4.7384335757450d-01, 8.2078171398294d-01,-8.9560393016704d-01,
     |  -7.3098367006969d-01, 1.2132671630388d+00, 1.5543227950321d+00,
     |   5.5190872582470d-01, 4.5985002937663d-02, 8.2924760298547d-05/
      data (pmn(lat, 7,22), lat = 1,36)/
     |   5.5921584344340d-06, 9.6604446109857d-03, 2.1085683701410d-01,
     |   9.9359044787485d-01, 1.6206665314699d+00, 4.7918836154592d-01,
     |  -1.1141429842248d+00,-3.2833962177491d-01, 1.0175350477593d+00,
     |  -4.0289775490518d-02,-9.0076705230025d-01, 4.4185513426548d-01,
     |   6.2522396601177d-01,-7.4154731266875d-01,-1.9886195610223d-01,
     |   8.2824831462402d-01,-2.7608785232804d-01,-6.5793786352888d-01,
     |   6.5793786352888d-01, 2.7608785232804d-01,-8.2824831462402d-01,
     |   1.9886195610223d-01, 7.4154731266875d-01,-6.2522396601177d-01,
     |  -4.4185513426548d-01, 9.0076705230025d-01, 4.0289775490520d-02,
     |  -1.0175350477594d+00, 3.2833962177491d-01, 1.1141429842248d+00,
     |  -4.7918836154592d-01,-1.6206665314699d+00,-9.9359044787486d-01,
     |  -2.1085683701410d-01,-9.6604446109857d-03,-5.5921584344340d-06/
      data (pmn(lat, 8,22), lat = 1,36)/
     |   3.2464669983490d-07, 1.7324016428321d-03, 6.7274818012913d-02,
     |   5.0141368679017d-01, 1.3502117801201d+00, 1.3497745457106d+00,
     |  -2.4475602550440d-01,-1.1158515797896d+00, 2.5169827798858d-01,
     |   9.2490407144834d-01,-4.8696735492040d-01,-6.7391324853774d-01,
     |   7.2478581606037d-01, 3.1627284368210d-01,-8.4110056768659d-01,
     |   1.0684700556855d-01, 7.6728917396655d-01,-5.0155417509427d-01,
     |  -5.0155417509427d-01, 7.6728917396655d-01, 1.0684700556856d-01,
     |  -8.4110056768659d-01, 3.1627284368209d-01, 7.2478581606037d-01,
     |  -6.7391324853774d-01,-4.8696735492040d-01, 9.2490407144834d-01,
     |   2.5169827798859d-01,-1.1158515797896d+00,-2.4475602550441d-01,
     |   1.3497745457106d+00, 1.3502117801201d+00, 5.0141368679017d-01,
     |   6.7274818012914d-02, 1.7324016428321d-03, 3.2464669983490d-07/
      data (pmn(lat, 9,22), lat = 1,36)/
     |   1.6441287971974d-08, 2.6945055745783d-04, 1.8354084286853d-02,
     |   2.0963520683164d-01, 8.5325920711256d-01, 1.5034639954529d+00,
     |   8.3942694514902d-01,-7.8252883004465d-01,-8.2516034683648d-01,
     |   6.9194070928042d-01, 6.3023826215854d-01,-7.7966227485715d-01,
     |  -3.4686914884055d-01, 8.5570735208030d-01,-1.1841361973597d-03,
     |  -8.2518487448151d-01, 3.5871338407707d-01, 6.5313753253149d-01,
     |  -6.5313753253149d-01,-3.5871338407707d-01, 8.2518487448151d-01,
     |   1.1841361973616d-03,-8.5570735208030d-01, 3.4686914884055d-01,
     |   7.7966227485715d-01,-6.3023826215854d-01,-6.9194070928042d-01,
     |   8.2516034683647d-01, 7.8252883004465d-01,-8.3942694514901d-01,
     |  -1.5034639954529d+00,-8.5325920711256d-01,-2.0963520683164d-01,
     |  -1.8354084286853d-02,-2.6945055745783d-04,-1.6441287971974d-08/
      data (pmn(lat,10,22), lat = 1,36)/
     |   7.3331803142257d-10, 3.6756934265935d-05, 4.3491094224546d-03,
     |   7.4623100829455d-02, 4.3883864076459d-01, 1.1701706138508d+00,
     |   1.4128390396310d+00, 2.3973032035874d-01,-1.0518015908990d+00,
     |  -3.8514144844822d-01, 9.2417804151189d-01, 2.4999004073853d-01,
     |  -8.9965614709724d-01,-1.0236580407521d-02, 8.5877526470207d-01,
     |  -2.7058199709188d-01,-7.4203581281093d-01, 5.3745674633076d-01,
     |   5.3745674633077d-01,-7.4203581281093d-01,-2.7058199709189d-01,
     |   8.5877526470207d-01,-1.0236580407520d-02,-8.9965614709724d-01,
     |   2.4999004073852d-01, 9.2417804151189d-01,-3.8514144844822d-01,
     |  -1.0518015908990d+00, 2.3973032035873d-01, 1.4128390396310d+00,
     |   1.1701706138508d+00, 4.3883864076459d-01, 7.4623100829456d-02,
     |   4.3491094224546d-03, 3.6756934265935d-05, 7.3331803142257d-10/
      data (pmn(lat,11,22), lat = 1,36)/
     |   2.8999988868947d-11, 4.4321208208253d-06, 9.0453209266853d-04,
     |   2.3002739330420d-02, 1.9024675259596d-01, 7.1823860071306d-01,
     |   1.3685219911388d+00, 1.1160428258565d+00,-3.0788155115269d-01,
     |  -1.0638937859071d+00, 6.6761962091639d-02, 9.5917175992650d-01,
     |  -1.1517013281910d-01,-8.8131145677933d-01, 2.7334856446641d-01,
     |   7.8547742589667d-01,-4.6584324566236d-01,-6.4584366837728d-01,
     |   6.4584366837728d-01, 4.6584324566237d-01,-7.8547742589667d-01,
     |  -2.7334856446641d-01, 8.8131145677933d-01, 1.1517013281909d-01,
     |  -9.5917175992650d-01,-6.6761962091639d-02, 1.0638937859071d+00,
     |   3.0788155115270d-01,-1.1160428258565d+00,-1.3685219911388d+00,
     |  -7.1823860071306d-01,-1.9024675259596d-01,-2.3002739330420d-02,
     |  -9.0453209266855d-04,-4.4321208208253d-06,-2.8999988868947d-11/
      data (pmn(lat,12,22), lat = 1,36)/
     |   1.0213639000047d-12, 4.7483348366624d-07, 1.6627412244173d-04,
     |   6.2069732682312d-03, 7.0930971138598d-02, 3.6546807139519d-01,
     |   9.8991997450604d-01, 1.4078976159312d+00, 7.0007079299152d-01,
     |  -7.1270821299570d-01,-8.9269445882311d-01, 4.3789967493305d-01,
     |   8.5753554666542d-01,-4.0474625778778d-01,-7.8562733771283d-01,
     |   4.7652263235703d-01, 6.9378063056855d-01,-5.8511643780954d-01,
     |  -5.8511643780954d-01, 6.9378063056855d-01, 4.7652263235704d-01,
     |  -7.8562733771283d-01,-4.0474625778778d-01, 8.5753554666543d-01,
     |   4.3789967493305d-01,-8.9269445882311d-01,-7.1270821299571d-01,
     |   7.0007079299151d-01, 1.4078976159312d+00, 9.8991997450604d-01,
     |   3.6546807139519d-01, 7.0930971138598d-02, 6.2069732682313d-03,
     |   1.6627412244173d-04, 4.7483348366624d-07, 1.0213639000047d-12/
      data (pmn(lat,13,22), lat = 1,36)/
     |   3.2114646626827d-14, 4.5333060183081d-08, 2.7128096150579d-05,
     |   1.4759391267166d-03, 2.3017778628464d-02, 1.5818175819053d-01,
     |   5.7871460197905d-01, 1.2001178150244d+00, 1.2983541945113d+00,
     |   2.6196329733460d-01,-9.4775326938205d-01,-6.3363099037120d-01,
     |   6.9172545936708d-01, 6.9595463887762d-01,-6.0033748906231d-01,
     |  -6.7643766269929d-01, 5.9872347042246d-01, 6.3484703374375d-01,
     |  -6.3484703374375d-01,-5.9872347042246d-01, 6.7643766269929d-01,
     |   6.0033748906231d-01,-6.9595463887762d-01,-6.9172545936708d-01,
     |   6.3363099037119d-01, 9.4775326938205d-01,-2.6196329733460d-01,
     |  -1.2983541945113d+00,-1.2001178150244d+00,-5.7871460197905d-01,
     |  -1.5818175819053d-01,-2.3017778628464d-02,-1.4759391267166d-03,
     |  -2.7128096150580d-05,-4.5333060183081d-08,-3.2114646626827d-14/
      data (pmn(lat,14,22), lat = 1,36)/
     |   9.0199206205741d-16, 3.8603987940215d-09, 3.9353495301018d-06,
     |   3.1034808569134d-04, 6.5454836830597d-03, 5.9066169049440d-02,
     |   2.8326067440060d-01, 7.9584839378049d-01, 1.3190224415161d+00,
     |   1.0874846266415d+00,-1.2263161778652d-01,-1.0382059296930d+00,
     |  -3.7114969591547d-01, 8.3706829065627d-01, 5.4312854962799d-01,
     |  -7.1188612454594d-01,-6.0722431441441d-01, 6.4817748504214d-01,
     |   6.4817748504214d-01,-6.0722431441441d-01,-7.1188612454594d-01,
     |   5.4312854962799d-01, 8.3706829065627d-01,-3.7114969591547d-01,
     |  -1.0382059296930d+00,-1.2263161778652d-01, 1.0874846266415d+00,
     |   1.3190224415161d+00, 7.9584839378049d-01, 2.8326067440060d-01,
     |   5.9066169049440d-02, 6.5454836830597d-03, 3.1034808569134d-04,
     |   3.9353495301019d-06, 3.8603987940215d-09, 9.0199206205741d-16/
      data (pmn(lat,15,22), lat = 1,36)/
     |   2.2596957829180d-17, 2.9287646122751d-10, 5.0732084333990d-07,
     |   5.7743121907024d-05, 1.6356890289672d-03, 1.9166323279326d-02,
     |   1.1815309036027d-01, 4.3236183534764d-01, 9.8429873736878d-01,
     |   1.3476908706991d+00, 8.3842443779371d-01,-4.1350015139592d-01,
     |  -1.0381431871381d+00,-1.6384421251617d-01, 9.0679043096551d-01,
     |   4.5085949261337d-01,-7.5650564213991d-01,-6.1813783788202d-01,
     |   6.1813783788202d-01, 7.5650564213991d-01,-4.5085949261337d-01,
     |  -9.0679043096551d-01, 1.6384421251617d-01, 1.0381431871381d+00,
     |   4.1350015139593d-01,-8.3842443779371d-01,-1.3476908706991d+00,
     |  -9.8429873736878d-01,-4.3236183534764d-01,-1.1815309036027d-01,
     |  -1.9166323279326d-02,-1.6356890289672d-03,-5.7743121907025d-05,
     |  -5.0732084333991d-07,-2.9287646122751d-10,-2.2596957829180d-17/
      data (pmn(lat,16,22), lat = 1,36)/
     |   5.0305106650324d-19, 1.9725635150730d-11, 5.7940433287134d-08,
     |   9.4854618559819d-06, 3.5895137649609d-04, 5.4159908072490d-03,
     |   4.2336973516070d-02, 1.9691913687370d-01, 5.8443750448882d-01,
     |   1.1243836132392d+00, 1.3127439003106d+00, 6.1063225711534d-01,
     |  -6.0254388060765d-01,-1.0078454754206d+00,-4.7030187896724d-02,
     |   9.3481346915446d-01, 4.5735328903892d-01,-7.3339567882147d-01,
     |  -7.3339567882147d-01, 4.5735328903892d-01, 9.3481346915446d-01,
     |  -4.7030187896723d-02,-1.0078454754206d+00,-6.0254388060765d-01,
     |   6.1063225711534d-01, 1.3127439003106d+00, 1.1243836132392d+00,
     |   5.8443750448882d-01, 1.9691913687370d-01, 4.2336973516071d-02,
     |   5.4159908072490d-03, 3.5895137649609d-04, 9.4854618559821d-06,
     |   5.7940433287136d-08, 1.9725635150730d-11, 5.0305106650324d-19/
      data (pmn(lat,17,22), lat = 1,36)/
     |   9.8848372631534d-21, 1.1717187713827d-12, 5.8262447893236d-09,
     |   1.3680741660428d-06, 6.8866067623318d-05, 1.3293677653457d-03,
     |   1.3045971361140d-02, 7.5867681449028d-02, 2.8477534721400d-01,
     |   7.1841754757464d-01, 1.2132681278185d+00, 1.2546519429532d+00,
     |   4.5069705810647d-01,-6.9860530403088d-01,-9.9782701917389d-01,
     |  -4.7166896714910d-02, 9.3253275366824d-01, 5.9206540381664d-01,
     |  -5.9206540381664d-01,-9.3253275366824d-01, 4.7166896714905d-02,
     |   9.9782701917389d-01, 6.9860530403088d-01,-4.5069705810648d-01,
     |  -1.2546519429532d+00,-1.2132681278185d+00,-7.1841754757464d-01,
     |  -2.8477534721401d-01,-7.5867681449028d-02,-1.3045971361140d-02,
     |  -1.3293677653457d-03,-6.8866067623318d-05,-1.3680741660428d-06,
     |  -5.8262447893238d-09,-1.1717187713827d-12,-9.8848372631534d-21/
      data (pmn(lat,18,22), lat = 1,36)/
     |   1.6957991293309d-22, 6.0725294642882d-14, 5.1042681612879d-10,
     |   1.7151227030997d-07, 1.1444607507106d-05, 2.8120151458191d-04,
     |   3.4381881118459d-03, 2.4705448865825d-02, 1.1499458583932d-01,
     |   3.6647389101683d-01, 8.1826216861456d-01, 1.2611512198882d+00,
     |   1.2158108769682d+00, 3.9445459080765d-01,-7.0551158964493d-01,
     |  -1.0362948586383d+00,-1.9954348224651d-01, 8.5543665421978d-01,
     |   8.5543665421978d-01,-1.9954348224651d-01,-1.0362948586383d+00,
     |  -7.0551158964493d-01, 3.9445459080765d-01, 1.2158108769682d+00,
     |   1.2611512198882d+00, 8.1826216861456d-01, 3.6647389101683d-01,
     |   1.1499458583932d-01, 2.4705448865825d-02, 3.4381881118459d-03,
     |   2.8120151458191d-04, 1.1444607507106d-05, 1.7151227030997d-07,
     |   5.1042681612881d-10, 6.0725294642882d-14, 1.6957991293309d-22/
      data (pmn(lat,19,22), lat = 1,36)/
     |   2.4955971755506d-24, 2.6981248556807d-15, 3.8291689687750d-11,
     |   1.8376724690305d-08, 1.6208409189981d-06, 5.0482526490153d-05,
     |   7.6443762180567d-04, 6.7273878682263d-03, 3.8299499349013d-02,
     |   1.5064941465069d-01, 4.2520530716332d-01, 8.7304660695197d-01,
     |   1.2814822445719d+00, 1.2307862738335d+00, 4.7658881951059d-01,
     |  -5.9374427816782d-01,-1.1036595943792d+00,-5.4883357132308d-01,
     |   5.4883357132308d-01, 1.1036595943792d+00, 5.9374427816782d-01,
     |  -4.7658881951059d-01,-1.2307862738335d+00,-1.2814822445719d+00,
     |  -8.7304660695197d-01,-4.2520530716332d-01,-1.5064941465069d-01,
     |  -3.8299499349013d-02,-6.7273878682263d-03,-7.6443762180568d-04,
     |  -5.0482526490153d-05,-1.6208409189981d-06,-1.8376724690305d-08,
     |  -3.8291689687752d-11,-2.6981248556807d-15,-2.4955971755506d-24/
      data (pmn(lat,20,22), lat = 1,36)/
     |   3.0579843685227d-26, 9.9770485553346d-17, 2.3882531924306d-12,
     |   1.6343186535319d-09, 1.9008024624091d-07, 7.4791022917377d-06,
     |   1.3959265796462d-04, 1.4942915036776d-03, 1.0300283103112d-02,
     |   4.9224619347661d-02, 1.7099807582772d-01, 4.4407069940854d-01,
     |   8.7124726033054d-01, 1.2758369677618d+00, 1.3136011258219d+00,
     |   7.3667103240429d-01,-2.6423042674218d-01,-1.0570638969505d+00,
     |  -1.0570638969505d+00,-2.6423042674218d-01, 7.3667103240428d-01,
     |   1.3136011258219d+00, 1.2758369677618d+00, 8.7124726033054d-01,
     |   4.4407069940854d-01, 1.7099807582772d-01, 4.9224619347661d-02,
     |   1.0300283103112d-02, 1.4942915036777d-03, 1.3959265796462d-04,
     |   7.4791022917377d-06, 1.9008024624091d-07, 1.6343186535319d-09,
     |   2.3882531924308d-12, 9.9770485553346d-17, 3.0579843685227d-26/
      data (pmn(lat,21,22), lat = 1,36)/
     |   2.9481394273639d-28, 2.9014185500219d-18, 1.1704262404677d-13,
     |   1.1404812822747d-10, 1.7455769242106d-08, 8.6524140473455d-07,
     |   1.9827454855986d-05, 2.5677167431241d-04, 2.1265320129874d-03,
     |   1.2207386375486d-02, 5.1278775798795d-02, 1.6350096724420d-01,
     |   4.0513874352511d-01, 7.8968283647057d-01, 1.2096009272099d+00,
     |   1.4231127191077d+00, 1.1858461076388d+00, 4.6524938486859d-01,
     |  -4.6524938486859d-01,-1.1858461076388d+00,-1.4231127191077d+00,
     |  -1.2096009272099d+00,-7.8968283647057d-01,-4.0513874352511d-01,
     |  -1.6350096724420d-01,-5.1278775798795d-02,-1.2207386375486d-02,
     |  -2.1265320129875d-03,-2.5677167431241d-04,-1.9827454855986d-05,
     |  -8.6524140473455d-07,-1.7455769242106d-08,-1.1404812822747d-10,
     |  -1.1704262404677d-13,-2.9014185500219d-18,-2.9481394273639d-28/
      data (pmn(lat,22,22), lat = 1,36)/
     |   1.9405051122872d-30, 5.7585500742737d-20, 3.9117667347159d-15,
     |   5.4210589043120d-12, 1.0900262795420d-09, 6.7902791926857d-08,
     |   1.9042675362289d-06, 2.9703063792655d-05, 2.9376364515409d-04,
     |   2.0083707638779d-03, 1.0074670174262d-02, 3.8690706116998d-02,
     |   1.1732775554209d-01, 2.8741011333637d-01, 5.7835363602607d-01,
     |   9.6773784336646d-01, 1.3579159565094d+00, 1.6064468407112d+00,
     |   1.6064468407112d+00, 1.3579159565094d+00, 9.6773784336646d-01,
     |   5.7835363602607d-01, 2.8741011333637d-01, 1.1732775554209d-01,
     |   3.8690706116998d-02, 1.0074670174262d-02, 2.0083707638780d-03,
     |   2.9376364515409d-04, 2.9703063792655d-05, 1.9042675362290d-06,
     |   6.7902791926857d-08, 1.0900262795420d-09, 5.4210589043121d-12,
     |   3.9117667347161d-15, 5.7585500742737d-20, 1.9405051122872d-30/
      data (pmn(lat, 0,23), lat = 1,36)/
     |   3.6551986078635d+00,-1.3828204152655d+00,-6.5755995991155d-01,
     |   1.4470550818109d+00,-7.0229443970476d-01,-5.7491224547921d-01,
     |   1.0875911410797d+00,-4.4580806807213d-01,-5.7838412092947d-01,
     |   9.1752912510961d-01,-2.8443247078736d-01,-6.0281898246876d-01,
     |   8.1255948736208d-01,-1.6013193535637d-01,-6.3795428056807d-01,
     |   7.3865433171577d-01,-5.1843467002831d-02,-6.8246458594552d-01,
     |   6.8246458594552d-01, 5.1843467002833d-02,-7.3865433171577d-01,
     |   6.3795428056807d-01, 1.6013193535637d-01,-8.1255948736208d-01,
     |   6.0281898246876d-01, 2.8443247078736d-01,-9.1752912510961d-01,
     |   5.7838412092947d-01, 4.4580806807213d-01,-1.0875911410797d+00,
     |   5.7491224547921d-01, 7.0229443970476d-01,-1.4470550818109d+00,
     |   6.5755995991153d-01, 1.3828204152655d+00,-3.6551986078635d+00/
      data (pmn(lat, 1,23), lat = 1,36)/
     |   2.1727074987222d+00, 1.5070261659577d+00,-1.6498992628179d+00,
     |   2.3162673847865d-01, 1.0465725731725d+00,-1.0478660450589d+00,
     |   3.4538410493931d-03, 9.0840843437579d-01,-7.9329033959721d-01,
     |  -1.2801028391379d-01, 8.4512119298333d-01,-6.3397000843695d-01,
     |  -2.3040567483184d-01, 8.1338943007673d-01,-5.1477856659290d-01,
     |  -3.2272268205281d-01, 7.9976825997713d-01,-4.1473441975667d-01,
     |  -4.1473441975667d-01, 7.9976825997713d-01,-3.2272268205280d-01,
     |  -5.1477856659290d-01, 8.1338943007673d-01,-2.3040567483184d-01,
     |  -6.3397000843696d-01, 8.4512119298333d-01,-1.2801028391379d-01,
     |  -7.9329033959721d-01, 9.0840843437579d-01, 3.4538410494027d-03,
     |  -1.0478660450589d+00, 1.0465725731725d+00, 2.3162673847866d-01,
     |  -1.6498992628179d+00, 1.5070261659577d+00, 2.1727074987222d+00/
      data (pmn(lat, 2,23), lat = 1,36)/
     |   5.8198012597891d-01, 2.3615358096345d+00, 2.4080241990860d-02,
     |  -1.3870345741497d+00, 9.1904359039617d-01, 4.0429317895077d-01,
     |  -1.0891044427690d+00, 5.4757789119314d-01, 5.0560554145470d-01,
     |  -9.2919920778416d-01, 3.4025207832936d-01, 5.6947072701975d-01,
     |  -8.2426418184723d-01, 1.8915519275274d-01, 6.2527138186007d-01,
     |  -7.4609757541263d-01, 6.0916930661007d-02, 6.8216007516452d-01,
     |  -6.8216007516452d-01,-6.0916930661009d-02, 7.4609757541263d-01,
     |  -6.2527138186006d-01,-1.8915519275274d-01, 8.2426418184723d-01,
     |  -5.6947072701975d-01,-3.4025207832936d-01, 9.2919920778416d-01,
     |  -5.0560554145469d-01,-5.4757789119315d-01, 1.0891044427690d+00,
     |  -4.0429317895077d-01,-9.1904359039617d-01, 1.3870345741497d+00,
     |  -2.4080241990841d-02,-2.3615358096345d+00,-5.8198012597891d-01/
      data (pmn(lat, 3,23), lat = 1,36)/
     |   1.0115436695902d-01, 1.5581050785442d+00, 1.6745256695131d+00,
     |  -9.8553203446455d-01,-6.7058124381326d-01, 1.1846458676985d+00,
     |  -2.9611467628680d-01,-7.8956984386298d-01, 8.9064544505242d-01,
     |  -1.7277173289187d-02,-8.0351766792017d-01, 6.9839241043469d-01,
     |   1.5779557906653d-01,-8.0295104911079d-01, 5.5040926527015d-01,
     |   2.9558779157264d-01,-8.0131959379086d-01, 4.2134932891777d-01,
     |   4.2134932891777d-01,-8.0131959379085d-01, 2.9558779157263d-01,
     |   5.5040926527015d-01,-8.0295104911079d-01, 1.5779557906654d-01,
     |   6.9839241043470d-01,-8.0351766792017d-01,-1.7277173289191d-02,
     |   8.9064544505243d-01,-7.8956984386298d-01,-2.9611467628681d-01,
     |   1.1846458676985d+00,-6.7058124381326d-01,-9.8553203446456d-01,
     |   1.6745256695130d+00, 1.5581050785442d+00, 1.0115436695902d-01/
      data (pmn(lat, 4,23), lat = 1,36)/
     |   1.2994877149341d-02, 6.8116027522200d-01, 1.9260392934960d+00,
     |   5.8766462795447d-01,-1.3421402654881d+00, 1.8104591559483d-01,
     |   9.7512567360752d-01,-8.1629500516098d-01,-2.5744539899469d-01,
     |   9.3025946045991d-01,-5.0133245775343d-01,-4.5774656356535d-01,
     |   8.5004005502189d-01,-2.7607835069023d-01,-5.8392680906951d-01,
     |   7.6715094572770d-01,-8.8493302461560d-02,-6.8118942608186d-01,
     |   6.8118942608186d-01, 8.8493302461561d-02,-7.6715094572770d-01,
     |   5.8392680906951d-01, 2.7607835069023d-01,-8.5004005502189d-01,
     |   4.5774656356534d-01, 5.0133245775343d-01,-9.3025946045991d-01,
     |   2.5744539899469d-01, 8.1629500516098d-01,-9.7512567360751d-01,
     |  -1.8104591559483d-01, 1.3421402654881d+00,-5.8766462795445d-01,
     |  -1.9260392934960d+00,-6.8116027522200d-01,-1.2994877149341d-02/
      data (pmn(lat, 5,23), lat = 1,36)/
     |   1.3196496638514d-03, 2.2476867252720d-01, 1.3262427201430d+00,
     |   1.6393740448332d+00,-4.4824408409275d-01,-1.0728922714793d+00,
     |   8.2922632103059d-01, 4.2650599792299d-01,-9.9476367407086d-01,
     |   3.1306533632866d-01, 6.7611061076588d-01,-8.0476939435991d-01,
     |  -5.4981338097781d-03, 7.6930226579853d-01,-6.1839017635495d-01,
     |  -2.3881307205257d-01, 8.0328121282867d-01,-4.3482116406531d-01,
     |  -4.3482116406531d-01, 8.0328121282867d-01,-2.3881307205257d-01,
     |  -6.1839017635495d-01, 7.6930226579853d-01,-5.4981338097841d-03,
     |  -8.0476939435991d-01, 6.7611061076588d-01, 3.1306533632866d-01,
     |  -9.9476367407086d-01, 4.2650599792299d-01, 8.2922632103060d-01,
     |  -1.0728922714793d+00,-4.4824408409275d-01, 1.6393740448332d+00,
     |   1.3262427201430d+00, 2.2476867252720d-01, 1.3196496638514d-03/
      data (pmn(lat, 6,23), lat = 1,36)/
     |   1.1034103233231d-04, 5.9605621415366d-02, 6.7397866325424d-01,
     |   1.6824618787775d+00, 8.8128779987481d-01,-1.0848500491654d+00,
     |  -4.1471603922144d-01, 1.0673585171245d+00,-2.1525195648074d-01,
     |  -8.1356746425579d-01, 7.3318339240180d-01, 2.3770995794226d-01,
     |  -8.5939630313327d-01, 4.1818192797619d-01, 5.0415403469843d-01,
     |  -7.9763705244551d-01, 1.3562417699689d-01, 6.7937389740449d-01,
     |  -6.7937389740449d-01,-1.3562417699689d-01, 7.9763705244552d-01,
     |  -5.0415403469843d-01,-4.1818192797619d-01, 8.5939630313327d-01,
     |  -2.3770995794225d-01,-7.3318339240180d-01, 8.1356746425578d-01,
     |   2.1525195648074d-01,-1.0673585171245d+00, 4.1471603922143d-01,
     |   1.0848500491654d+00,-8.8128779987481d-01,-1.6824618787775d+00,
     |  -6.7397866325425d-01,-5.9605621415366d-02,-1.1034103233231d-04/
      data (pmn(lat, 7,23), lat = 1,36)/
     |   7.8042315048827d-06, 1.3179459216382d-02, 2.7367114137104d-01,
     |   1.1768823703471d+00, 1.5840364328898d+00,-2.1919780473773d-02,
     |  -1.1848324489130d+00, 3.0764426536129d-01, 8.8157682826013d-01,
     |  -7.1286110994250d-01,-3.8507501290283d-01, 8.9465164088560d-01,
     |  -2.3215788315614d-01,-6.8625832555540d-01, 7.1008901306032d-01,
     |   1.4764333673032d-01,-8.0318890289224d-01, 4.5566848564397d-01,
     |   4.5566848564398d-01,-8.0318890289223d-01, 1.4764333673032d-01,
     |   7.1008901306032d-01,-6.8625832555540d-01,-2.3215788315613d-01,
     |   8.9465164088560d-01,-3.8507501290283d-01,-7.1286110994250d-01,
     |   8.8157682826013d-01, 3.0764426536130d-01,-1.1848324489130d+00,
     |  -2.1919780473773d-02, 1.5840364328898d+00, 1.1768823703471d+00,
     |   2.7367114137105d-01, 1.3179459216382d-02, 7.8042315048827d-06/
      data (pmn(lat, 8,23), lat = 1,36)/
     |   4.7580556553748d-07, 2.4887273221376d-03, 9.2574375623600d-02,
     |   6.4033678719997d-01, 1.5103257122041d+00, 1.0735843342901d+00,
     |  -7.4858568958846d-01,-8.3028530352678d-01, 8.2304514039596d-01,
     |   4.1434512743499d-01,-9.2920197251539d-01, 1.1724349846936d-01,
     |   7.9546957574451d-01,-6.0273216423517d-01,-3.7047806278861d-01,
     |   8.2939147333346d-01,-2.0399618231047d-01,-6.7638880374335d-01,
     |   6.7638880374335d-01, 2.0399618231047d-01,-8.2939147333346d-01,
     |   3.7047806278861d-01, 6.0273216423517d-01,-7.9546957574452d-01,
     |  -1.1724349846937d-01, 9.2920197251539d-01,-4.1434512743499d-01,
     |  -8.2304514039596d-01, 8.3028530352678d-01, 7.4858568958847d-01,
     |  -1.0735843342901d+00,-1.5103257122041d+00,-6.4033678719997d-01,
     |  -9.2574375623602d-02,-2.4887273221376d-03,-4.7580556553748d-07/
      data (pmn(lat, 9,23), lat = 1,36)/
     |   2.5347582416347d-08, 4.0803866726818d-04, 2.6759472166566d-02,
     |   2.8681520631093d-01, 1.0526230100524d+00, 1.5283996121256d+00,
     |   3.4628685969905d-01,-1.1029464080569d+00,-2.4019960389519d-01,
     |   1.0019218738891d+00,-1.2926253622738d-01,-8.5489269604066d-01,
     |   5.3840787664745d-01, 5.1527644104331d-01,-8.0713371738878d-01,
     |  -1.5803011205582d-02, 7.9685235941828d-01,-4.8476766403490d-01,
     |  -4.8476766403491d-01, 7.9685235941828d-01,-1.5803011205576d-02,
     |  -8.0713371738878d-01, 5.1527644104330d-01, 5.3840787664745d-01,
     |  -8.5489269604066d-01,-1.2926253622738d-01, 1.0019218738891d+00,
     |  -2.4019960389519d-01,-1.1029464080569d+00, 3.4628685969904d-01,
     |   1.5283996121256d+00, 1.0526230100524d+00, 2.8681520631093d-01,
     |   2.6759472166566d-02, 4.0803866726818d-04, 2.5347582416347d-08/
      data (pmn(lat,10,23), lat = 1,36)/
     |   1.1916654824928d-09, 5.8770368036585d-05, 6.7214580597129d-03,
     |   1.0909150442142d-01, 5.8867283507042d-01, 1.3644367271290d+00,
     |   1.2182270332839d+00,-3.5741479382830d-01,-1.0584438976635d+00,
     |   3.4650364458292d-01, 8.6406791519151d-01,-5.7559554058225d-01,
     |  -5.7610334431127d-01, 7.9309919020326d-01, 1.6450861175664d-01,
     |  -8.4832797872688d-01, 2.9578554435794d-01, 6.7171463369854d-01,
     |  -6.7171463369854d-01,-2.9578554435794d-01, 8.4832797872689d-01,
     |  -1.6450861175664d-01,-7.9309919020326d-01, 5.7610334431128d-01,
     |   5.7559554058226d-01,-8.6406791519151d-01,-3.4650364458292d-01,
     |   1.0584438976635d+00, 3.5741479382831d-01,-1.2182270332839d+00,
     |  -1.3644367271290d+00,-5.8867283507042d-01,-1.0909150442142d-01,
     |  -6.7214580597130d-03,-5.8770368036585d-05,-1.1916654824928d-09/
      data (pmn(lat,11,23), lat = 1,36)/
     |   4.9796150331236d-11, 7.4984834567321d-06, 1.4839236579286d-03,
     |   3.5912724168038d-02, 2.7580009080425d-01, 9.3082461752170d-01,
     |   1.4650786232645d+00, 6.8451453008011d-01,-8.5326558759560d-01,
     |  -7.2228880620396d-01, 7.6289008343595d-01, 5.2518231918080d-01,
     |  -8.3575045090073d-01,-2.1429043819189d-01, 8.7453611782796d-01,
     |  -1.6275475864546d-01,-7.7763664053325d-01, 5.2351344365138d-01,
     |   5.2351344365139d-01,-7.7763664053325d-01,-1.6275475864546d-01,
     |   8.7453611782796d-01,-2.1429043819189d-01,-8.3575045090072d-01,
     |   5.2518231918079d-01, 7.6289008343595d-01,-7.2228880620396d-01,
     |  -8.5326558759560d-01, 6.8451453008011d-01, 1.4650786232645d+00,
     |   9.3082461752170d-01, 2.7580009080425d-01, 3.5912724168039d-02,
     |   1.4839236579287d-03, 7.4984834567321d-06, 4.9796150331236d-11/
      data (pmn(lat,12,23), lat = 1,36)/
     |   1.8587821839273d-12, 8.5243765346567d-07, 2.9020691927599d-04,
     |   1.0358977555358d-02, 1.1087929795149d-01, 5.1978899673297d-01,
     |   1.2189931007096d+00, 1.3242916760565d+00, 8.6203051973655d-02,
     |  -1.0659584956176d+00,-2.5800320692787d-01, 9.4964446045103d-01,
     |   1.2396214390142d-01,-9.0889085779465d-01, 1.2724216657728d-01,
     |   8.3152900026224d-01,-4.1333499500653d-01,-6.6454576466035d-01,
     |   6.6454576466035d-01, 4.1333499500653d-01,-8.3152900026223d-01,
     |  -1.2724216657728d-01, 9.0889085779465d-01,-1.2396214390143d-01,
     |  -9.4964446045104d-01, 2.5800320692787d-01, 1.0659584956176d+00,
     |  -8.6203051973650d-02,-1.3242916760565d+00,-1.2189931007096d+00,
     |  -5.1978899673297d-01,-1.1087929795149d-01,-1.0358977555358d-02,
     |  -2.9020691927600d-04,-8.5243765346567d-07,-1.8587821839273d-12/
      data (pmn(lat,13,23), lat = 1,36)/
     |   6.2175194751880d-14, 8.6663500782946d-08, 5.0530603825732d-05,
     |   2.6390118174170d-03, 3.8807093707143d-02, 2.4562626135889d-01,
     |   7.9886859353102d-01, 1.3765017486918d+00, 9.9219945694303d-01,
     |  -4.3417574934453d-01,-1.0244321313622d+00, 1.8878284200163d-01,
     |   9.3853054484120d-01,-2.3335726500921d-01,-8.5226170843944d-01,
     |   3.8994326444359d-01, 7.3522590168864d-01,-5.7413718059766d-01,
     |  -5.7413718059766d-01, 7.3522590168864d-01, 3.8994326444359d-01,
     |  -8.5226170843944d-01,-2.3335726500921d-01, 9.3853054484120d-01,
     |   1.8878284200164d-01,-1.0244321313622d+00,-4.3417574934454d-01,
     |   9.9219945694303d-01, 1.3765017486918d+00, 7.9886859353102d-01,
     |   2.4562626135889d-01, 3.8807093707143d-02, 2.6390118174170d-03,
     |   5.0530603825734d-05, 8.6663500782946d-08, 6.2175194751880d-14/
      data (pmn(lat,14,23), lat = 1,36)/
     |   1.8663388801125d-15, 7.8940759430221d-09, 7.8555570486439d-06,
     |   5.9659477747185d-04, 1.1927692208878d-02, 1.0003775685133d-01,
     |   4.3386858260541d-01, 1.0547291616935d+00, 1.3744081789702d+00,
     |   5.6501279465959d-01,-7.9560334869466d-01,-8.1988068512858d-01,
     |   5.3214193525360d-01, 8.0963012274831d-01,-4.9485527870019d-01,
     |  -7.4339879459595d-01, 5.5844557067200d-01, 6.5361534070872d-01,
     |  -6.5361534070872d-01,-5.5844557067200d-01, 7.4339879459595d-01,
     |   4.9485527870019d-01,-8.0963012274831d-01,-5.3214193525360d-01,
     |   8.1988068512858d-01, 7.9560334869466d-01,-5.6501279465959d-01,
     |  -1.3744081789702d+00,-1.0547291616935d+00,-4.3386858260541d-01,
     |  -1.0003775685133d-01,-1.1927692208878d-02,-5.9659477747186d-04,
     |  -7.8555570486442d-06,-7.8940759430221d-09,-1.8663388801125d-15/
      data (pmn(lat,15,23), lat = 1,36)/
     |   5.0262569994897d-17, 6.4429768430198d-10, 1.0912100746392d-06,
     |   1.1993501287315d-04, 3.2346164374303d-03, 3.5475950023091d-02,
     |   2.0020821488649d-01, 6.4941856795107d-01, 1.2389366666517d+00,
     |   1.2354904957676d+00, 1.4122368038957d-01,-9.8718847213092d-01,
     |  -5.5677419150167d-01, 7.5047903310285d-01, 6.5022767321436d-01,
     |  -6.5512146044260d-01,-6.5341552709759d-01, 6.4038517990907d-01,
     |   6.4038517990907d-01,-6.5341552709758d-01,-6.5512146044260d-01,
     |   6.5022767321436d-01, 7.5047903310285d-01,-5.5677419150168d-01,
     |  -9.8718847213093d-01, 1.4122368038957d-01, 1.2354904957676d+00,
     |   1.2389366666517d+00, 6.4941856795107d-01, 2.0020821488649d-01,
     |   3.5475950023091d-02, 3.2346164374303d-03, 1.1993501287315d-04,
     |   1.0912100746393d-06, 6.4429768430198d-10, 5.0262569994897d-17/
      data (pmn(lat,16,23), lat = 1,36)/
     |   1.2119321681741d-18, 4.7031771028210d-11, 1.3526177336100d-07,
     |   2.1433228785752d-05, 7.7504066008169d-04, 1.1007857516375d-02,
     |   7.9501797144634d-02, 3.3316125223841d-01, 8.5739416264815d-01,
     |   1.3312540783405d+00, 1.0170241122660d+00,-2.0975435418617d-01,
     |  -1.0494044637919d+00,-3.1969434349042d-01, 8.6630280166047d-01,
     |   5.3164629482365d-01,-7.3078193951089d-01,-6.3683065151613d-01,
     |   6.3683065151613d-01, 7.3078193951089d-01,-5.3164629482365d-01,
     |  -8.6630280166047d-01, 3.1969434349042d-01, 1.0494044637919d+00,
     |   2.0975435418618d-01,-1.0170241122660d+00,-1.3312540783405d+00,
     |  -8.5739416264815d-01,-3.3316125223841d-01,-7.9501797144635d-02,
     |  -1.1007857516375d-02,-7.7504066008169d-04,-2.1433228785752d-05,
     |  -1.3526177336100d-07,-4.7031771028210d-11,-1.2119321681741d-18/
      data (pmn(lat,17,23), lat = 1,36)/
     |   2.6051815373636d-20, 3.0580183306401d-12, 1.4906468938541d-08,
     |   3.3947981425742d-06, 1.6380128776520d-04, 2.9903727703038d-03,
     |   2.7310269969556d-02, 1.4479449500603d-01, 4.8154711821695d-01,
     |   1.0286564334562d+00, 1.3433158809999d+00, 7.8652739812203d-01,
     |  -4.5696812895244d-01,-1.0454424502620d+00,-1.6402692710524d-01,
     |   9.1694190822404d-01, 5.0575637260294d-01,-7.2916149992981d-01,
     |  -7.2916149992981d-01, 5.0575637260294d-01, 9.1694190822404d-01,
     |  -1.6402692710524d-01,-1.0454424502620d+00,-4.5696812895244d-01,
     |   7.8652739812203d-01, 1.3433158809999d+00, 1.0286564334562d+00,
     |   4.8154711821695d-01, 1.4479449500603d-01, 2.7310269969556d-02,
     |   2.9903727703038d-03, 1.6380128776520d-04, 3.3947981425742d-06,
     |   1.4906468938541d-08, 3.0580183306401d-12, 2.6051815373636d-20/
      data (pmn(lat,18,23), lat = 1,36)/
     |   4.9570498785129d-22, 1.7587073351565d-13, 1.4507836890174d-09,
     |   4.7364972179970d-07, 3.0376264412675d-05, 7.0864756054141d-04,
     |   8.1106605280949d-03, 5.3616451877195d-02, 2.2446597876040d-01,
     |   6.2303467843363d-01, 1.1494142170861d+00, 1.3099874916268d+00,
     |   6.0390555959678d-01,-5.9764716154074d-01,-1.0363435347275d+00,
     |  -1.2653256557345d-01, 9.2398763526022d-01, 6.1040288259623d-01,
     |  -6.1040288259623d-01,-9.2398763526022d-01, 1.2653256557345d-01,
     |   1.0363435347275d+00, 5.9764716154074d-01,-6.0390555959678d-01,
     |  -1.3099874916268d+00,-1.1494142170861d+00,-6.2303467843363d-01,
     |  -2.2446597876040d-01,-5.3616451877195d-02,-8.1106605280950d-03,
     |  -7.0864756054141d-04,-3.0376264412675d-05,-4.7364972179971d-07,
     |  -1.4507836890175d-09,-1.7587073351565d-13,-4.9570498785129d-22/
      data (pmn(lat,19,23), lat = 1,36)/
     |   8.2553626500563d-24, 8.8471320466960d-15, 1.2334327631583d-10,
     |   5.7604707168262d-08, 4.8946081780301d-06, 1.4523192259952d-04,
     |   2.0686702205047d-03, 1.6869523596028d-02, 8.7351761178032d-02,
     |   3.0492436156707d-01, 7.3713282217991d-01, 1.2219505935662d+00,
     |   1.2755658392204d+00, 5.1652759440022d-01,-6.3421311471515d-01,
     |  -1.0621164257939d+00,-2.4519745308948d-01, 8.5539690432989d-01,
     |   8.5539690432989d-01,-2.4519745308948d-01,-1.0621164257939d+00,
     |  -6.3421311471515d-01, 5.1652759440022d-01, 1.2755658392204d+00,
     |   1.2219505935662d+00, 7.3713282217991d-01, 3.0492436156707d-01,
     |   8.7351761178033d-02, 1.6869523596028d-02, 2.0686702205048d-03,
     |   1.4523192259952d-04, 4.8946081780301d-06, 5.7604707168263d-08,
     |   1.2334327631584d-10, 8.8471320466960d-15, 8.2553626500563d-24/
      data (pmn(lat,20,23), lat = 1,36)/
     |   1.1819485111968d-25, 3.8240906864926d-16, 9.0003488392580d-12,
     |   6.0021492804328d-09, 6.7389325615509d-07, 2.5334775668126d-05,
     |   4.4663105455689d-04, 4.4564551085274d-03, 2.8184196990603d-02,
     |   1.2116120306706d-01, 3.6882069392150d-01, 8.0811099132477d-01,
     |   1.2566830577649d+00, 1.2802967229269d+00, 5.6571729557246d-01,
     |  -5.4244195488805d-01,-1.1144996210835d+00,-5.6625583036617d-01,
     |   5.6625583036617d-01, 1.1144996210835d+00, 5.4244195488805d-01,
     |  -5.6571729557246d-01,-1.2802967229269d+00,-1.2566830577649d+00,
     |  -8.0811099132477d-01,-3.6882069392150d-01,-1.2116120306706d-01,
     |  -2.8184196990603d-02,-4.4564551085274d-03,-4.4663105455689d-04,
     |  -2.5334775668126d-05,-6.7389325615509d-07,-6.0021492804329d-09,
     |  -9.0003488392585d-12,-3.8240906864926d-16,-1.1819485111968d-25/
      data (pmn(lat,21,23), lat = 1,36)/
     |   1.4117885861775d-27, 1.3783574312149d-17, 5.4713461575005d-13,
     |   5.2021075130551d-10, 7.7003693974164d-08, 3.6562610708002d-06,
     |   7.9419221735757d-05, 9.6342295010623d-04, 7.3720619174008d-03,
     |   3.8462979184523d-02, 1.4386095662651d-01, 3.9752437975847d-01,
     |   8.2152664583388d-01, 1.2567061807445d+00, 1.3449610613168d+00,
     |   7.9373030193984d-01,-2.3094289856284d-01,-1.0625139386937d+00,
     |  -1.0625139386937d+00,-2.3094289856284d-01, 7.9373030193983d-01,
     |   1.3449610613168d+00, 1.2567061807445d+00, 8.2152664583388d-01,
     |   3.9752437975847d-01, 1.4386095662651d-01, 3.8462979184523d-02,
     |   7.3720619174009d-03, 9.6342295010624d-04, 7.9419221735758d-05,
     |   3.6562610708002d-06, 7.7003693974164d-08, 5.2021075130553d-10,
     |   5.4713461575008d-13, 1.3783574312149d-17, 1.4117885861775d-27/
      data (pmn(lat,22,23), lat = 1,36)/
     |   1.3290770879927d-29, 3.9140885153274d-19, 2.6182034528435d-14,
     |   3.5444802176001d-11, 6.9040073236682d-09, 4.1291958696641d-07,
     |   1.1010475742686d-05, 1.6155367120511d-04, 1.4848338571628d-03,
     |   9.3019963694106d-03, 4.2046213756259d-02, 1.4251878418424d-01,
     |   3.7141145287298d-01, 7.5403349041150d-01, 1.1922963195726d+00,
     |   1.4359635102337d+00, 1.2151208959593d+00, 4.8039098557665d-01,
     |  -4.8039098557665d-01,-1.2151208959593d+00,-1.4359635102337d+00,
     |  -1.1922963195726d+00,-7.5403349041150d-01,-3.7141145287298d-01,
     |  -1.4251878418425d-01,-4.2046213756259d-02,-9.3019963694106d-03,
     |  -1.4848338571628d-03,-1.6155367120511d-04,-1.1010475742686d-05,
     |  -4.1291958696641d-07,-6.9040073236682d-09,-3.5444802176002d-11,
     |  -2.6182034528436d-14,-3.9140885153274d-19,-1.3290770879927d-29/
      data (pmn(lat,23,23), lat = 1,36)/
     |   8.5558737195385d-32, 7.5976770535065d-21, 8.5581464283347d-16,
     |   1.6477675409415d-12, 4.2164469663105d-10, 3.1692992236732d-08,
     |   1.0342237358636d-06, 1.8277567182839d-05, 2.0060945942472d-04,
     |   1.4967345646865d-03, 8.0791841056682d-03, 3.2984192830329d-02,
     |   1.0519611468279d-01, 2.6840302426514d-01, 5.5754892779349d-01,
     |   9.5501292810513d-01, 1.3608538018506d+00, 1.6222688268785d+00,
     |   1.6222688268785d+00, 1.3608538018506d+00, 9.5501292810513d-01,
     |   5.5754892779349d-01, 2.6840302426514d-01, 1.0519611468279d-01,
     |   3.2984192830330d-02, 8.0791841056682d-03, 1.4967345646865d-03,
     |   2.0060945942472d-04, 1.8277567182839d-05, 1.0342237358636d-06,
     |   3.1692992236732d-08, 4.2164469663105d-10, 1.6477675409416d-12,
     |   8.5581464283352d-16, 7.5976770535065d-21, 8.5558737195385d-32/
      data (pmn(lat, 0,24), lat = 1,36)/
     |   3.6338762572450d+00,-1.5964754870155d+00,-2.9854463625158d-01,
     |   1.3395178598293d+00,-1.0628250665150d+00,-3.7054255358707d-02,
     |   9.3472310160209d-01,-9.1388893757428d-01, 1.0029361869095d-01,
     |   7.2726233305548d-01,-8.4697966931471d-01, 2.0373384318932d-01,
     |   5.8737971152150d-01,-8.1371075445080d-01, 2.9485971638766d-01,
     |   4.7817337214498d-01,-7.9948398701776d-01, 3.8376051748243d-01,
     |   3.8376051748243d-01,-7.9948398701776d-01, 4.7817337214498d-01,
     |   2.9485971638766d-01,-8.1371075445080d-01, 5.8737971152151d-01,
     |   2.0373384318933d-01,-8.4697966931471d-01, 7.2726233305548d-01,
     |   1.0029361869095d-01,-9.1388893757428d-01, 9.3472310160209d-01,
     |  -3.7054255358707d-02,-1.0628250665150d+00, 1.3395178598293d+00,
     |  -2.9854463625156d-01,-1.5964754870155d+00, 3.6338762572450d+00/
      data (pmn(lat, 1,24), lat = 1,36)/
     |   2.2853461605448d+00, 1.2827255952344d+00,-1.7199283358161d+00,
     |   6.5167015076562d-01, 6.7808067741959d-01,-1.1758635637497d+00,
     |   5.8746372733172d-01, 4.3430870691842d-01,-9.6372093284858d-01,
     |   5.9206360479987d-01, 2.7810769075646d-01,-8.4223037792907d-01,
     |   6.1686192389818d-01, 1.5684093913336d-01,-7.6028878526445d-01,
     |   6.5304370612159d-01, 5.0814430823017d-02,-6.9982220444983d-01,
     |   6.9982220444983d-01,-5.0814430823015d-02,-6.5304370612160d-01,
     |   7.6028878526445d-01,-1.5684093913336d-01,-6.1686192389817d-01,
     |   8.4223037792907d-01,-2.7810769075646d-01,-5.9206360479987d-01,
     |   9.6372093284858d-01,-4.3430870691842d-01,-5.8746372733173d-01,
     |   1.1758635637497d+00,-6.7808067741959d-01,-6.5167015076564d-01,
     |   1.7199283358161d+00,-1.2827255952344d+00,-2.2853461605448d+00/
      data (pmn(lat, 2,24), lat = 1,36)/
     |   6.4098366067288d-01, 2.3960066833344d+00,-3.3546076613730d-01,
     |  -1.1727177590021d+00, 1.1984872804602d+00,-1.4762328897219d-01,
     |  -8.6086720600806d-01, 9.6170700061897d-01,-1.8647699405093d-01,
     |  -6.8410637206638d-01, 8.6584795301871d-01,-2.4795738500533d-01,
     |  -5.6209814948591d-01, 8.2038362444678d-01,-3.1495798815394d-01,
     |  -4.6713163902290d-01, 8.0136693714650d-01,-3.8690068713933d-01,
     |  -3.8690068713933d-01, 8.0136693714650d-01,-4.6713163902290d-01,
     |  -3.1495798815394d-01, 8.2038362444678d-01,-5.6209814948592d-01,
     |  -2.4795738500534d-01, 8.6584795301871d-01,-6.8410637206638d-01,
     |  -1.8647699405093d-01, 9.6170700061897d-01,-8.6086720600806d-01,
     |  -1.4762328897219d-01, 1.1984872804602d+00,-1.1727177590021d+00,
     |  -3.3546076613732d-01, 2.3960066833344d+00, 6.4098366067288d-01/
      data (pmn(lat, 3,24), lat = 1,36)/
     |   1.1643695544653d-01, 1.6998971568330d+00, 1.4773658560210d+00,
     |  -1.2642935951970d+00,-2.0548868963241d-01, 1.1332740651651d+00,
     |  -8.1121493940241d-01,-2.3007104398250d-01, 9.3356087071211d-01,
     |  -6.9693656172286d-01,-1.7000174745221d-01, 8.1913567315385d-01,
     |  -6.6695911330797d-01,-1.0159718396081d-01, 7.4654610786168d-01,
     |  -6.7223538729689d-01,-3.3670044907602d-02, 6.9940213234683d-01,
     |  -6.9940213234683d-01, 3.3670044907600d-02, 6.7223538729689d-01,
     |  -7.4654610786168d-01, 1.0159718396081d-01, 6.6695911330797d-01,
     |  -8.1913567315385d-01, 1.7000174745221d-01, 6.9693656172287d-01,
     |  -9.3356087071211d-01, 2.3007104398250d-01, 8.1121493940241d-01,
     |  -1.1332740651651d+00, 2.0548868963241d-01, 1.2642935951970d+00,
     |  -1.4773658560209d+00,-1.6998971568330d+00,-1.1643695544653d-01/
      data (pmn(lat, 4,24), lat = 1,36)/
     |   1.5627252903869d-02, 7.8669145510980d-01, 1.9860720931937d+00,
     |   1.8651095753507d-01,-1.3273378186663d+00, 6.8704216656005d-01,
     |   5.5017523275511d-01,-1.0407909944206d+00, 4.3951433691132d-01,
     |   5.2956921997322d-01,-9.0253157644124d-01, 3.7834290248776d-01,
     |   4.7904975582013d-01,-8.3497145675586d-01, 3.7480354160098d-01,
     |   4.3263330613891d-01,-8.0654198678906d-01, 3.9642549830507d-01,
     |   3.9642549830508d-01,-8.0654198678906d-01, 4.3263330613890d-01,
     |   3.7480354160098d-01,-8.3497145675585d-01, 4.7904975582014d-01,
     |   3.7834290248777d-01,-9.0253157644124d-01, 5.2956921997322d-01,
     |   4.3951433691133d-01,-1.0407909944206d+00, 5.5017523275510d-01,
     |   6.8704216656005d-01,-1.3273378186663d+00, 1.8651095753506d-01,
     |   1.9860720931937d+00, 7.8669145510980d-01, 1.5627252903869d-02/
      data (pmn(lat, 5,24), lat = 1,36)/
     |   1.6583092538338d-03, 2.7337755792285d-01, 1.4883626859696d+00,
     |   1.4694809575410d+00,-8.5756830886156d-01,-7.0265070570591d-01,
     |   1.1036633778308d+00,-2.1891434286950d-01,-7.8064753217356d-01,
     |   8.6292141909854d-01,-5.8878057390825d-02,-7.4469939379170d-01,
     |   7.5438178142631d-01,-1.2591821926598d-02,-7.1242143687814d-01,
     |   7.0871601279021d-01,-1.3707045574300d-03,-6.9845956843987d-01,
     |   6.9845956843987d-01, 1.3707045574323d-03,-7.0871601279021d-01,
     |   7.1242143687814d-01, 1.2591821926600d-02,-7.5438178142631d-01,
     |   7.4469939379170d-01, 5.8878057390825d-02,-8.6292141909854d-01,
     |   7.8064753217356d-01, 2.1891434286950d-01,-1.1036633778308d+00,
     |   7.0265070570591d-01, 8.5756830886156d-01,-1.4694809575410d+00,
     |  -1.4883626859696d+00,-2.7337755792285d-01,-1.6583092538338d-03/
      data (pmn(lat, 6,24), lat = 1,36)/
     |   1.4497270399108d-04, 7.6191535458999d-02, 8.0858709663717d-01,
     |   1.7639698521479d+00, 4.7175504565329d-01,-1.2584030455318d+00,
     |   1.7064404192168d-01, 9.3038423364465d-01,-8.0018603719700d-01,
     |  -2.0299745141357d-01, 8.9149081348553d-01,-5.8036238608427d-01,
     |  -3.1874710779557d-01, 8.4007930458679d-01,-4.7216231438467d-01,
     |  -3.7060211288455d-01, 8.1351057036724d-01,-4.1266091434276d-01,
     |  -4.1266091434277d-01, 8.1351057036724d-01,-3.7060211288455d-01,
     |  -4.7216231438467d-01, 8.4007930458679d-01,-3.1874710779557d-01,
     |  -5.8036238608428d-01, 8.9149081348553d-01,-2.0299745141357d-01,
     |  -8.0018603719700d-01, 9.3038423364465d-01, 1.7064404192169d-01,
     |  -1.2584030455318d+00, 4.7175504565329d-01, 1.7639698521479d+00,
     |   8.0858709663718d-01, 7.6191535458999d-02, 1.4497270399108d-04/
      data (pmn(lat, 7,24), lat = 1,36)/
     |   1.0729778725286d-05, 1.7694770512071d-02, 3.4854914846667d-01,
     |   1.3568606517849d+00, 1.4453110560099d+00,-5.1785916530530d-01,
     |  -9.7939585828518d-01, 8.3720652789972d-01, 3.4538558651814d-01,
     |  -9.6664543184539d-01, 4.0701313470021d-01, 5.6484047066641d-01,
     |  -8.4674240439970d-01, 1.8949657306577d-01, 6.4441397801807d-01,
     |  -7.5803365982886d-01, 5.5792574111995d-02, 6.9677720796951d-01,
     |  -6.9677720796951d-01,-5.5792574111998d-02, 7.5803365982887d-01,
     |  -6.4441397801807d-01,-1.8949657306577d-01, 8.4674240439970d-01,
     |  -5.6484047066640d-01,-4.0701313470021d-01, 9.6664543184539d-01,
     |  -3.4538558651814d-01,-8.3720652789972d-01, 9.7939585828518d-01,
     |   5.1785916530530d-01,-1.4453110560099d+00,-1.3568606517849d+00,
     |  -3.4854914846668d-01,-1.7694770512071d-02,-1.0729778725286d-05/
      data (pmn(lat, 8,24), lat = 1,36)/
     |   6.8531135257272d-07, 3.5102978697122d-03, 1.2478181377193d-01,
     |   7.9657804974684d-01, 1.6166419134255d+00, 6.7737017646319d-01,
     |  -1.0956087356152d+00,-2.8737140234803d-01, 1.0366628417935d+00,
     |  -3.2608450354905d-01,-7.1542550332522d-01, 8.0377686417999d-01,
     |   5.8242847385990d-02,-8.0370601606595d-01, 6.0015889564640d-01,
     |   2.7446820645896d-01,-8.1950310217300d-01, 4.3619778333487d-01,
     |   4.3619778333487d-01,-8.1950310217300d-01, 2.7446820645895d-01,
     |   6.0015889564640d-01,-8.0370601606595d-01, 5.8242847385997d-02,
     |   8.0377686418000d-01,-7.1542550332522d-01,-3.2608450354905d-01,
     |   1.0366628417935d+00,-2.8737140234803d-01,-1.0956087356152d+00,
     |   6.7737017646319d-01, 1.6166419134255d+00, 7.9657804974685d-01,
     |   1.2478181377193d-01, 3.5102978697122d-03, 6.8531135257272d-07/
      data (pmn(lat, 9,24), lat = 1,36)/
     |   3.8300321900335d-08, 6.0510825465644d-04, 3.8130707194442d-02,
     |   3.8190932111619d-01, 1.2505975707687d+00, 1.4316974844852d+00,
     |  -2.0336357318145d-01,-1.1105718911350d+00, 4.3716977293667d-01,
     |   7.7312368266625d-01,-7.9538434455410d-01,-2.1678034401651d-01,
     |   8.8058774318472d-01,-4.2415224269761d-01,-5.2234253486096d-01,
     |   8.1180250574769d-01,-1.3175630296582d-01,-6.9399454759840d-01,
     |   6.9399454759840d-01, 1.3175630296582d-01,-8.1180250574769d-01,
     |   5.2234253486096d-01, 4.2415224269761d-01,-8.8058774318472d-01,
     |   2.1678034401650d-01, 7.9538434455410d-01,-7.7312368266625d-01,
     |  -4.3716977293667d-01, 1.1105718911350d+00, 2.0336357318146d-01,
     |  -1.4316974844852d+00,-1.2505975707687d+00,-3.8190932111620d-01,
     |  -3.8130707194443d-02,-6.0510825465644d-04,-3.8300321900335d-08/
      data (pmn(lat,10,24), lat = 1,36)/
     |   1.8922352860304d-09, 9.1752322181674d-05, 1.0125647152482d-02,
     |   1.5492677059794d-01, 7.6154777226605d-01, 1.5028881670166d+00,
     |   8.6034246781808d-01,-8.6119699130970d-01,-6.7453437564759d-01,
     |   8.9645142015200d-01, 2.4148365603007d-01,-9.2791467696013d-01,
     |   3.0611148394873d-01, 6.7773207815254d-01,-7.4192798540890d-01,
     |  -1.3582224448543d-01, 8.2001379552271d-01,-4.6797972563367d-01,
     |  -4.6797972563368d-01, 8.2001379552271d-01,-1.3582224448542d-01,
     |  -7.4192798540890d-01, 6.7773207815254d-01, 3.0611148394873d-01,
     |  -9.2791467696013d-01, 2.4148365603007d-01, 8.9645142015201d-01,
     |  -6.7453437564759d-01,-8.6119699130970d-01, 8.6034246781807d-01,
     |   1.5028881670166d+00, 7.6154777226605d-01, 1.5492677059794d-01,
     |   1.0125647152483d-02, 9.1752322181674d-05, 1.8922352860304d-09/
      data (pmn(lat,11,24), lat = 1,36)/
     |   8.3268172793001d-11, 1.2346127860232d-05, 2.3655755127861d-03,
     |   5.4326666419031d-02, 3.8526975968910d-01, 1.1478229792297d+00,
     |   1.4276300977531d+00, 1.1897252264005d-01,-1.1110972217310d+00,
     |  -4.6560622681161d-02, 9.7887157595670d-01,-3.1294565910980d-01,
     |  -7.5440380497926d-01, 6.8635983607336d-01, 3.2153927949994d-01,
     |  -8.5540979997449d-01, 2.3195819538783d-01, 6.8955518844790d-01,
     |  -6.8955518844790d-01,-2.3195819538783d-01, 8.5540979997450d-01,
     |  -3.2153927949994d-01,-6.8635983607336d-01, 7.5440380497927d-01,
     |   3.1294565910981d-01,-9.7887157595670d-01, 4.6560622681159d-02,
     |   1.1110972217310d+00,-1.1897252264005d-01,-1.4276300977531d+00,
     |  -1.1478229792297d+00,-3.8526975968910d-01,-5.4326666419031d-02,
     |  -2.3655755127861d-03,-1.2346127860232d-05,-8.3268172793001d-11/
      data (pmn(lat,12,24), lat = 1,36)/
     |   3.2815116442323d-12, 1.4835965882977d-06, 4.9037902431314d-04,
     |   1.6696362341114d-02, 1.6664756238145d-01, 7.0451527464948d-01,
     |   1.3985829790305d+00, 1.0388824783957d+00,-5.4289625227865d-01,
     |  -9.6066802775362d-01, 5.1675186707657d-01, 7.4672643846428d-01,
     |  -7.1259825815532d-01,-4.0436021396795d-01, 8.6226559314240d-01,
     |  -5.3876262791853d-02,-8.0801078411785d-01, 5.0946988103298d-01,
     |   5.0946988103298d-01,-8.0801078411785d-01,-5.3876262791860d-02,
     |   8.6226559314240d-01,-4.0436021396795d-01,-7.1259825815532d-01,
     |   7.4672643846427d-01, 5.1675186707657d-01,-9.6066802775362d-01,
     |  -5.4289625227865d-01, 1.0388824783957d+00, 1.3985829790305d+00,
     |   7.0451527464948d-01, 1.6664756238145d-01, 1.6696362341114d-02,
     |   4.9037902431315d-04, 1.4835965882977d-06, 3.2815116442323d-12/
      data (pmn(lat,13,24), lat = 1,36)/
     |   1.1624150698145d-13, 1.5989776479551d-07, 9.0727222084876d-05,
     |   4.5385326016344d-03, 6.2696065950311d-02, 3.6302741896934d-01,
     |   1.0347574116651d+00, 1.4199300604999d+00, 4.6591759622674d-01,
     |  -9.5483876359761d-01,-5.5334991733981d-01, 8.6312929005017d-01,
     |   3.5201068761914d-01,-8.9543703551434d-01,-2.0456586413749d-02,
     |   8.6462054855509d-01,-3.5930671643036d-01,-6.8261094296245d-01,
     |   6.8261094296245d-01, 3.5930671643037d-01,-8.6462054855509d-01,
     |   2.0456586413747d-02, 8.9543703551434d-01,-3.5201068761915d-01,
     |  -8.6312929005018d-01, 5.5334991733981d-01, 9.5483876359761d-01,
     |  -4.6591759622674d-01,-1.4199300604999d+00,-1.0347574116651d+00,
     |  -3.6302741896934d-01,-6.2696065950311d-02,-4.5385326016345d-03,
     |  -9.0727222084879d-05,-1.5989776479551d-07,-1.1624150698145d-13/
      data (pmn(lat,14,24), lat = 1,36)/
     |   3.7091062393576d-15, 1.5496504948190d-08, 1.5036312768957d-05,
     |   1.0975695046717d-03, 2.0734701752718d-02, 1.6074996383389d-01,
     |   6.2412992117986d-01, 1.2825647753638d+00, 1.2061350594952d+00,
     |  -1.2257883649192d-01,-1.0725455686342d+00,-7.0324038193084d-02,
     |   9.6745926133125d-01,-5.4930555570527d-02,-8.9688033773934d-01,
     |   2.9928856083677d-01, 7.7260514017980d-01,-5.6297670378401d-01,
     |  -5.6297670378401d-01, 7.7260514017980d-01, 2.9928856083678d-01,
     |  -8.9688033773934d-01,-5.4930555570529d-02, 9.6745926133126d-01,
     |  -7.0324038193076d-02,-1.0725455686342d+00,-1.2257883649192d-01,
     |   1.2061350594953d+00, 1.2825647753638d+00, 6.2412992117986d-01,
     |   1.6074996383389d-01, 2.0734701752718d-02, 1.0975695046717d-03,
     |   1.5036312768957d-05, 1.5496504948190d-08, 3.7091062393576d-15/
      data (pmn(lat,15,24), lat = 1,36)/
     |   1.0668028795658d-16, 1.3518262333944d-09, 2.2362009690611d-06,
     |   2.3691834167406d-04, 6.0663013418205d-03, 6.1991067550735d-02,
     |   3.1777691978927d-01, 8.9985174759710d-01, 1.3838944032139d+00,
     |   8.2926572994095d-01,-5.9399912004698d-01,-9.5709733536746d-01,
     |   3.4963267470600d-01, 8.9476383758216d-01,-3.7976470782533d-01,
     |  -8.0104594746205d-01, 5.1619701620643d-01, 6.7183970405114d-01,
     |  -6.7183970405114d-01,-5.1619701620643d-01, 8.0104594746205d-01,
     |   3.7976470782533d-01,-8.9476383758216d-01,-3.4963267470600d-01,
     |   9.5709733536746d-01, 5.9399912004698d-01,-8.2926572994095d-01,
     |  -1.3838944032139d+00,-8.9985174759710d-01,-3.1777691978927d-01,
     |  -6.1991067550735d-02,-6.0663013418205d-03,-2.3691834167406d-04,
     |  -2.2362009690611d-06,-1.3518262333944d-09,-1.0668028795658d-16/
      data (pmn(lat,16,24), lat = 1,36)/
     |   2.7633018728828d-18, 1.0608061751585d-10, 2.9842083354998d-07,
     |   4.5695357230121d-05, 1.5749649550016d-03, 2.0974046892222d-02,
     |   1.3907260099587d-01, 5.1928098874918d-01, 1.1325388009579d+00,
     |   1.3290630976421d+00, 3.9567109449276d-01,-8.9088524215157d-01,
     |  -7.1918479436663d-01, 6.4318045221747d-01, 7.4417811270466d-01,
     |  -5.9230007818848d-01,-6.9670090257370d-01, 6.3234452169903d-01,
     |   6.3234452169904d-01,-6.9670090257370d-01,-5.9230007818848d-01,
     |   7.4417811270466d-01, 6.4318045221747d-01,-7.1918479436664d-01,
     |  -8.9088524215158d-01, 3.9567109449276d-01, 1.3290630976421d+00,
     |   1.1325388009579d+00, 5.1928098874918d-01, 1.3907260099587d-01,
     |   2.0974046892222d-02, 1.5749649550016d-03, 4.5695357230122d-05,
     |   2.9842083354999d-07, 1.0608061751585d-10, 2.7633018728828d-18/
      data (pmn(lat,17,24), lat = 1,36)/
     |   6.4295180344784d-20, 7.4703496883932d-12, 3.5665535564530d-08,
     |   7.8660135559458d-06, 3.6297080517612d-04, 6.2452786230142d-03,
     |   5.2798144407256d-02, 2.5300959496835d-01, 7.3397347247887d-01,
     |   1.2830691929767d+00, 1.1587487477413d+00,-1.1941296131494d-04,
     |  -1.0277916579768d+00,-4.6666706693153d-01, 8.1244249307313d-01,
     |   6.0720033141912d-01,-7.0285619032413d-01,-6.5506776824500d-01,
     |   6.5506776824499d-01, 7.0285619032413d-01,-6.0720033141912d-01,
     |  -8.1244249307313d-01, 4.6666706693153d-01, 1.0277916579768d+00,
     |   1.1941296132212d-04,-1.1587487477413d+00,-1.2830691929767d+00,
     |  -7.3397347247887d-01,-2.5300959496835d-01,-5.2798144407256d-02,
     |  -6.2452786230142d-03,-3.6297080517612d-04,-7.8660135559460d-06,
     |  -3.5665535564532d-08,-7.4703496883932d-12,-6.4295180344784d-20/
      data (pmn(lat,18,24), lat = 1,36)/
     |   1.3375157396311d-21, 4.6996633124150d-13, 3.8014455346376d-09,
     |   1.2041775926079d-06, 7.4067839229499d-05, 1.6355702469875d-03,
     |   1.7443200677006d-02, 1.0533920475475d-01, 3.9206769662119d-01,
     |   9.2753998494985d-01, 1.3451678549561d+00, 9.4083917911486d-01,
     |  -3.0129782075143d-01,-1.0626520791585d+00,-2.7808277204797d-01,
     |   8.9253895575728d-01, 5.5239934573895d-01,-7.2462182922540d-01,
     |  -7.2462182922540d-01, 5.5239934573895d-01, 8.9253895575728d-01,
     |  -2.7808277204797d-01,-1.0626520791585d+00,-3.0129782075142d-01,
     |   9.4083917911485d-01, 1.3451678549561d+00, 9.2753998494986d-01,
     |   3.9206769662119d-01, 1.0533920475475d-01, 1.7443200677006d-02,
     |   1.6355702469875d-03, 7.4067839229499d-05, 1.2041775926079d-06,
     |   3.8014455346377d-09, 4.6996633124150d-13, 1.3375157396311d-21/
      data (pmn(lat,19,24), lat = 1,36)/
     |   2.4690969043772d-23, 2.6218931820844d-14, 3.5879570736037d-10,
     |   1.6285542894954d-07, 1.3304885321987d-05, 3.7505168788864d-04,
     |   5.0050288073572d-03, 3.7596874446930d-02, 1.7545233055290d-01,
     |   5.3526090048182d-01, 1.0764412906614d+00, 1.3434966333448d+00,
     |   7.4562494558608d-01,-4.8836249303599d-01,-1.0637862119886d+00,
     |  -2.0469922857724d-01, 9.1328718325230d-01, 6.2836997091194d-01,
     |  -6.2836997091193d-01,-9.1328718325230d-01, 2.0469922857724d-01,
     |   1.0637862119886d+00, 4.8836249303599d-01,-7.4562494558609d-01,
     |  -1.3434966333448d+00,-1.0764412906614d+00,-5.3526090048182d-01,
     |  -1.7545233055290d-01,-3.7596874446930d-02,-5.0050288073572d-03,
     |  -3.7505168788864d-04,-1.3304885321987d-05,-1.6285542894955d-07,
     |  -3.5879570736039d-10,-2.6218931820844d-14,-2.4690969043772d-23/
      data (pmn(lat,20,24), lat = 1,36)/
     |   3.9982626353955d-25, 1.2823416439622d-15, 2.9652090259223d-11,
     |   1.9246940187318d-08, 2.0823372778821d-06, 7.4608316840179d-05,
     |   1.2378935375070d-03, 1.1454349559238d-02, 6.5965052942455d-02,
     |   2.5212373012165d-01, 6.5941722965703d-01, 1.1739270220862d+00,
     |   1.3207019226587d+00, 6.3252337710043d-01,-5.5816524221903d-01,
     |  -1.0828166263268d+00,-2.9016610455990d-01, 8.5499927012475d-01,
     |   8.5499927012475d-01,-2.9016610455989d-01,-1.0828166263268d+00,
     |  -5.5816524221903d-01, 6.3252337710043d-01, 1.3207019226587d+00,
     |   1.1739270220862d+00, 6.5941722965703d-01, 2.5212373012165d-01,
     |   6.5965052942455d-02, 1.1454349559238d-02, 1.2378935375070d-03,
     |   7.4608316840179d-05, 2.0823372778821d-06, 1.9246940187318d-08,
     |   2.9652090259224d-11, 1.2823416439622d-15, 3.9982626353955d-25/
      data (pmn(lat,21,24), lat = 1,36)/
     |   5.5771615376296d-27, 5.3998629368766d-17, 2.1076478462069d-12,
     |   1.9530896094941d-09, 2.7913098303242d-07, 1.2666147901919d-05,
     |   2.5994820449503d-04, 2.9405927883938d-03, 2.0657564078596d-02,
     |   9.7041711700480d-02, 3.1851602654490d-01, 7.4443803933338d-01,
     |   1.2254510417471d+00, 1.3210374188739d+00, 6.5136260653228d-01,
     |  -4.8940122532117d-01,-1.1235706233996d+00,-5.8339236263508d-01,
     |   5.8339236263508d-01, 1.1235706233996d+00, 4.8940122532118d-01,
     |  -6.5136260653228d-01,-1.3210374188738d+00,-1.2254510417471d+00,
     |  -7.4443803933339d-01,-3.1851602654490d-01,-9.7041711700480d-02,
     |  -2.0657564078596d-02,-2.9405927883938d-03,-2.5994820449503d-04,
     |  -1.2666147901919d-05,-2.7913098303242d-07,-1.9530896094942d-09,
     |  -2.1076478462070d-12,-5.3998629368766d-17,-5.5771615376296d-27/
      data (pmn(lat,22,24), lat = 1,36)/
     |   6.5017707663498d-29, 1.8995405500702d-18, 1.2503559500206d-13,
     |   1.6517544755199d-10, 3.1117646208943d-08, 1.7829591967078d-06,
     |   4.5071241002198d-05, 6.1958622080213d-04, 5.2628515415082d-03,
     |   2.9976464134070d-02, 1.2071150542174d-01, 3.5488956056833d-01,
     |   7.7242682054723d-01, 1.2339692285808d+00, 1.3717380866889d+00,
     |   8.4875457212298d-01,-1.9746513483700d-01,-1.0675455163636d+00,
     |  -1.0675455163636d+00,-1.9746513483700d-01, 8.4875457212297d-01,
     |   1.3717380866889d+00, 1.2339692285808d+00, 7.7242682054723d-01,
     |   3.5488956056833d-01, 1.2071150542174d-01, 2.9976464134070d-02,
     |   5.2628515415083d-03, 6.1958622080213d-04, 4.5071241002199d-05,
     |   1.7829591967078d-06, 3.1117646208943d-08, 1.6517544755199d-10,
     |   1.2503559500207d-13, 1.8995405500702d-18, 6.5017707663498d-29/
      data (pmn(lat,23,24), lat = 1,36)/
     |   5.9834112965087d-31, 5.2728745111537d-20, 5.8486989304316d-15,
     |   1.1000526842821d-11, 2.7268423364655d-09, 1.9678419214870d-07,
     |   6.1057881631881d-06, 1.0150398283832d-04, 1.0353336558850d-03,
     |   7.0782545071147d-03, 3.4428069629738d-02, 1.2405675722560d-01,
     |   3.4001912050746d-01, 7.1899373408068d-01, 1.1736073726642d+00,
     |   1.4469184062548d+00, 1.2433894544661d+00, 4.9533660659225d-01,
     |  -4.9533660659225d-01,-1.2433894544661d+00,-1.4469184062548d+00,
     |  -1.1736073726642d+00,-7.1899373408068d-01,-3.4001912050745d-01,
     |  -1.2405675722561d-01,-3.4428069629738d-02,-7.0782545071147d-03,
     |  -1.0353336558850d-03,-1.0150398283832d-04,-6.1057881631882d-06,
     |  -1.9678419214870d-07,-2.7268423364655d-09,-1.1000526842821d-11,
     |  -5.8486989304320d-15,-5.2728745111537d-20,-5.9834112965087d-31/
      data (pmn(lat,24,24), lat = 1,36)/
     |   3.7706945124446d-33, 1.0019727709845d-21, 1.8715174673515d-16,
     |   5.0062803807707d-13, 1.6302857186426d-10, 1.4785848956395d-08,
     |   5.6144658698224d-07, 1.1241983358519d-05, 1.3693427759900d-04,
     |   1.1149441001659d-03, 6.4760706907891d-03, 2.8106869283229d-02,
     |   9.4277063130739d-02, 2.5054178787562d-01, 5.3725430958656d-01,
     |   9.4203748681592d-01, 1.3631933487760d+00, 1.6375203105139d+00,
     |   1.6375203105139d+00, 1.3631933487760d+00, 9.4203748681592d-01,
     |   5.3725430958656d-01, 2.5054178787562d-01, 9.4277063130739d-02,
     |   2.8106869283229d-02, 6.4760706907891d-03, 1.1149441001659d-03,
     |   1.3693427759901d-04, 1.1241983358519d-05, 5.6144658698225d-07,
     |   1.4785848956395d-08, 1.6302857186426d-10, 5.0062803807709d-13,
     |   1.8715174673516d-16, 1.0019727709845d-21, 3.7706945124446d-33/
      data (pmn(lat, 0,25), lat = 1,36)/
     |   3.6041220887272d+00,-1.7821576930950d+00, 7.4751878522850d-02,
     |   1.1074510057058d+00,-1.2611454494204d+00, 5.0920012762456d-01,
     |   4.8874991655099d-01,-1.0039679825858d+00, 7.2625280921361d-01,
     |   6.4921326484865d-02,-7.4657353146681d-01, 8.2171768061012d-01,
     |  -2.7023828312720d-01,-4.6252801804008d-01, 8.1526172282978d-01,
     |  -5.3171698672805d-01,-1.5682110608015d-01, 7.1594830317115d-01,
     |  -7.1594830317115d-01, 1.5682110608015d-01, 5.3171698672806d-01,
     |  -8.1526172282978d-01, 4.6252801804008d-01, 2.7023828312719d-01,
     |  -8.2171768061013d-01, 7.4657353146681d-01,-6.4921326484862d-02,
     |  -7.2625280921362d-01, 1.0039679825858d+00,-4.8874991655098d-01,
     |  -5.0920012762456d-01, 1.2611454494204d+00,-1.1074510057058d+00,
     |  -7.4751878522872d-02, 1.7821576930950d+00,-3.6041220887272d+00/
      data (pmn(lat, 1,25), lat = 1,36)/
     |   2.3964890353187d+00, 1.0380824024542d+00,-1.7105210721911d+00,
     |   1.0121496282172d+00, 2.0716341081937d-01,-1.0394482226663d+00,
     |   9.8806542855714d-01,-2.1882743476642d-01,-6.2866318586759d-01,
     |   9.2846909964449d-01,-5.0627207115351d-01,-2.7166626458427d-01,
     |   8.0040641323204d-01,-6.9323485155046d-01, 5.7231038136670d-02,
     |   6.0556506527349d-01,-7.8645415642487d-01, 3.5362489703731d-01,
     |   3.5362489703732d-01,-7.8645415642487d-01, 6.0556506527349d-01,
     |   5.7231038136672d-02,-6.9323485155046d-01, 8.0040641323205d-01,
     |  -2.7166626458426d-01,-5.0627207115351d-01, 9.2846909964450d-01,
     |  -6.2866318586759d-01,-2.1882743476643d-01, 9.8806542855714d-01,
     |  -1.0394482226663d+00, 2.0716341081937d-01, 1.0121496282172d+00,
     |  -1.7105210721911d+00, 1.0380824024542d+00, 2.3964890353187d+00/
      data (pmn(lat, 2,25), lat = 1,36)/
     |   7.0277778350065d-01, 2.4044113928210d+00,-6.8106680119513d-01,
     |  -8.5694720382923d-01, 1.3023846136313d+00,-6.6686572124189d-01,
     |  -3.6764927765806d-01, 9.8311015026530d-01,-7.8127510099949d-01,
     |   1.8225601569270d-03, 7.1720318884266d-01,-8.3658248902990d-01,
     |   3.0339130650132d-01, 4.4068082515459d-01,-8.1510113406274d-01,
     |   5.4308462427090d-01, 1.4892816258974d-01,-7.1583926120229d-01,
     |   7.1583926120229d-01,-1.4892816258973d-01,-5.4308462427091d-01,
     |   8.1510113406274d-01,-4.4068082515459d-01,-3.0339130650132d-01,
     |   8.3658248902991d-01,-7.1720318884266d-01,-1.8225601569298d-03,
     |   7.8127510099950d-01,-9.8311015026530d-01, 3.6764927765805d-01,
     |   6.6686572124189d-01,-1.3023846136313d+00, 8.5694720382922d-01,
     |   6.8106680119515d-01,-2.4044113928210d+00,-7.0277778350065d-01/
      data (pmn(lat, 3,25), lat = 1,36)/
     |   1.3320559409184d-01, 1.8374008800735d+00, 1.2315952058389d+00,
     |  -1.4436874518923d+00, 2.8779502168736d-01, 8.4075158682800d-01,
     |  -1.0820919255592d+00, 4.2145360280089d-01, 4.9622203069703d-01,
     |  -9.3108484080392d-01, 5.9458597031546d-01, 1.8850209062107d-01,
     |  -7.7799417455440d-01, 7.2415612233704d-01,-9.7917437135972d-02,
     |  -5.8846525585318d-01, 7.9198323885427d-01,-3.5964776572702d-01,
     |  -3.5964776572702d-01, 7.9198323885427d-01,-5.8846525585317d-01,
     |  -9.7917437135974d-02, 7.2415612233704d-01,-7.7799417455441d-01,
     |   1.8850209062106d-01, 5.9458597031546d-01,-9.3108484080392d-01,
     |   4.9622203069703d-01, 4.2145360280089d-01,-1.0820919255592d+00,
     |   8.4075158682800d-01, 2.8779502168736d-01,-1.4436874518923d+00,
     |   1.2315952058389d+00, 1.8374008800735d+00, 1.3320559409184d-01/
      data (pmn(lat, 4,25), lat = 1,36)/
     |   1.8645381288750d-02, 8.9955481659074d-01, 2.0038963220565d+00,
     |  -2.2668927005298d-01,-1.1434502977373d+00, 1.0536412253737d+00,
     |  -3.4102036028482d-02,-8.5725224381821d-01, 9.1357679322317d-01,
     |  -2.0449791868863d-01,-6.1219099612927d-01, 8.6903328933342d-01,
     |  -4.0101875071275d-01,-3.7149608172384d-01, 8.1159122706388d-01,
     |  -5.7662200948120d-01,-1.2485909444460d-01, 7.1546737774679d-01,
     |  -7.1546737774679d-01, 1.2485909444460d-01, 5.7662200948121d-01,
     |  -8.1159122706388d-01, 3.7149608172384d-01, 4.0101875071274d-01,
     |  -8.6903328933342d-01, 6.1219099612927d-01, 2.0449791868863d-01,
     |  -9.1357679322317d-01, 8.5725224381821d-01, 3.4102036028492d-02,
     |  -1.0536412253737d+00, 1.1434502977373d+00, 2.2668927005299d-01,
     |  -2.0038963220565d+00,-8.9955481659074d-01,-1.8645381288750d-02/
      data (pmn(lat, 5,25), lat = 1,36)/
     |   2.0637801644722d-03, 3.2877113567715d-01, 1.6415863575817d+00,
     |   1.2236703140812d+00,-1.1694747347141d+00,-2.0095985624828d-01,
     |   1.0718793546318d+00,-7.8020129367624d-01,-1.8159313540153d-01,
     |   8.7725216672665d-01,-7.4807172856774d-01,-1.3236298534839d-02,
     |   7.1638156653512d-01,-7.7778483283187d-01, 1.8009757612165d-01,
     |   5.5144552196494d-01,-8.0223508951427d-01, 3.7188044754378d-01,
     |   3.7188044754378d-01,-8.0223508951427d-01, 5.5144552196493d-01,
     |   1.8009757612165d-01,-7.7778483283187d-01, 7.1638156653512d-01,
     |  -1.3236298534829d-02,-7.4807172856774d-01, 8.7725216672665d-01,
     |  -1.8159313540153d-01,-7.8020129367625d-01, 1.0718793546318d+00,
     |  -2.0095985624828d-01,-1.1694747347141d+00, 1.2236703140812d+00,
     |   1.6415863575817d+00, 3.2877113567715d-01, 2.0637801644722d-03/
      data (pmn(lat, 6,25), lat = 1,36)/
     |   1.8827518066920d-04, 9.6145368052090d-02, 9.5381399424017d-01,
     |   1.7871517456886d+00, 1.8745413795906d-02,-1.2171418552310d+00,
     |   7.1008965998669d-01, 4.5578999428998d-01,-1.0005035241324d+00,
     |   5.2897583619362d-01, 3.8657804882126d-01,-8.7940014281382d-01,
     |   5.5400997579918d-01, 2.4509383935460d-01,-7.9530491370348d-01,
     |   6.3035138310255d-01, 8.3445486845490d-02,-7.1469340003680d-01,
     |   7.1469340003680d-01,-8.3445486845488d-02,-6.3035138310255d-01,
     |   7.9530491370347d-01,-2.4509383935460d-01,-5.5400997579918d-01,
     |   8.7940014281382d-01,-3.8657804882126d-01,-5.2897583619362d-01,
     |   1.0005035241324d+00,-4.5578999428997d-01,-7.1008965998670d-01,
     |   1.2171418552310d+00,-1.8745413795906d-02,-1.7871517456886d+00,
     |  -9.5381399424018d-01,-9.6145368052090d-02,-1.8827518066920d-04/
      data (pmn(lat, 7,25), lat = 1,36)/
     |   1.4551889257445d-05, 2.3409509709321d-02, 4.3610601368407d-01,
     |   1.5227850178111d+00, 1.2029834154343d+00,-9.3494016302726d-01,
     |  -5.3996092383379d-01, 1.0769401826005d+00,-3.4799185307099d-01,
     |  -6.4997249535548d-01, 8.9977802645508d-01,-2.5928234870921d-01,
     |  -5.8306292692880d-01, 8.3482957394869d-01,-3.0390145723765d-01,
     |  -4.8885166992196d-01, 8.1545960038762d-01,-3.9071835201786d-01,
     |  -3.9071835201786d-01, 8.1545960038762d-01,-4.8885166992195d-01,
     |  -3.0390145723765d-01, 8.3482957394869d-01,-5.8306292692881d-01,
     |  -2.5928234870922d-01, 8.9977802645508d-01,-6.4997249535548d-01,
     |  -3.4799185307100d-01, 1.0769401826005d+00,-5.3996092383379d-01,
     |  -9.3494016302726d-01, 1.2029834154343d+00, 1.5227850178111d+00,
     |   4.3610601368408d-01, 2.3409509709321d-02, 1.4551889257445d-05/
      data (pmn(lat, 8,25), lat = 1,36)/
     |   9.7152820043622d-07, 4.8687158055526d-03, 1.6499356159036d-01,
     |   9.6619540296750d-01, 1.6493195587637d+00, 1.9972900750466d-01,
     |  -1.2052753959436d+00, 3.4507583060763d-01, 7.9407720753979d-01,
     |  -8.7729624024299d-01, 5.4909854848792d-03, 7.9481862854620d-01,
     |  -7.3485268420146d-01,-4.9329790446498d-02, 7.4958115726253d-01,
     |  -6.9999048937937d-01,-2.2754200958564d-02, 7.1326743765329d-01,
     |  -7.1326743765329d-01, 2.2754200958562d-02, 6.9999048937938d-01,
     |  -7.4958115726252d-01, 4.9329790446496d-02, 7.3485268420146d-01,
     |  -7.9481862854620d-01,-5.4909854848792d-03, 8.7729624024299d-01,
     |  -7.9407720753979d-01,-3.4507583060764d-01, 1.2052753959436d+00,
     |  -1.9972900750466d-01,-1.6493195587637d+00,-9.6619540296751d-01,
     |  -1.6499356159036d-01,-4.8687158055526d-03,-9.7152820043622d-07/
      data (pmn(lat, 9,25), lat = 1,36)/
     |   5.6824118389174d-08, 8.8038213005852d-04, 5.3198545200393d-02,
     |   4.9566493253816d-01, 1.4304231100952d+00, 1.2031331634215d+00,
     |  -7.1170150451508d-01,-7.9245560790788d-01, 9.2949722332500d-01,
     |   1.2390599858322d-01,-9.0934263261319d-01, 5.9983220419262d-01,
     |   3.3649278909289d-01,-8.5990389046524d-01, 4.6536751316476d-01,
     |   3.9229463708119d-01,-8.2866283304368d-01, 4.1681463860772d-01,
     |   4.1681463860773d-01,-8.2866283304368d-01, 3.9229463708118d-01,
     |   4.6536751316476d-01,-8.5990389046524d-01, 3.3649278909290d-01,
     |   5.9983220419262d-01,-9.0934263261319d-01, 1.2390599858322d-01,
     |   9.2949722332500d-01,-7.9245560790787d-01,-7.1170150451509d-01,
     |   1.2031331634215d+00, 1.4304231100952d+00, 4.9566493253816d-01,
     |   5.3198545200394d-02, 8.8038213005852d-04, 5.6824118389174d-08/
      data (pmn(lat,10,25), lat = 1,36)/
     |   2.9424492310156d-09, 1.4017409983171d-04, 1.4901003039983d-02,
     |   2.1416026685284d-01, 9.5113288779436d-01, 1.5550728606592d+00,
     |   3.7474685748740d-01,-1.1361262530190d+00,-3.5170370538715d-02,
     |   9.7764624856320d-01,-5.3632427593889d-01,-5.1682455361492d-01,
     |   8.7980827552496d-01,-2.2081094922092d-01,-6.4992432415783d-01,
     |   7.7730383572571d-01,-5.9865296281597d-02,-7.1079749939814d-01,
     |   7.1079749939813d-01, 5.9865296281598d-02,-7.7730383572571d-01,
     |   6.4992432415783d-01, 2.2081094922093d-01,-8.7980827552496d-01,
     |   5.1682455361492d-01, 5.3632427593889d-01,-9.7764624856320d-01,
     |   3.5170370538710d-02, 1.1361262530190d+00,-3.7474685748739d-01,
     |  -1.5550728606592d+00,-9.5113288779436d-01,-2.1416026685284d-01,
     |  -1.4901003039983d-02,-1.4017409983171d-04,-2.9424492310156d-09/
      data (pmn(lat,11,25), lat = 1,36)/
     |   1.3595352926833d-10, 1.9834676119050d-05, 3.6739236861210d-03,
     |   7.9827292138086d-02, 5.1961534109604d-01, 1.3458193807250d+00,
     |   1.2310331906121d+00,-4.6732487676674d-01,-9.7958736963609d-01,
     |   6.4484327549781d-01, 5.7183533752873d-01,-8.9421555734788d-01,
     |   5.1515465252743d-02, 7.9696453758057d-01,-6.5027443704253d-01,
     |  -2.5118032325511d-01, 8.3708568132909d-01,-4.5117314271223d-01,
     |  -4.5117314271224d-01, 8.3708568132909d-01,-2.5118032325510d-01,
     |  -6.5027443704253d-01, 7.9696453758057d-01, 5.1515465252736d-02,
     |  -8.9421555734789d-01, 5.7183533752873d-01, 6.4484327549781d-01,
     |  -9.7958736963609d-01,-4.6732487676675d-01, 1.2310331906121d+00,
     |   1.3458193807250d+00, 5.1961534109604d-01, 7.9827292138087d-02,
     |   3.6739236861211d-03, 1.9834676119050d-05, 1.3595352926833d-10/
      data (pmn(lat,12,25), lat = 1,36)/
     |   5.6375959408196d-12, 2.5111750948480d-06, 8.0475682530719d-04,
     |   2.6069039725951d-02, 2.4147342879262d-01, 9.1125720864163d-01,
     |   1.4852203515101d+00, 5.7129864783179d-01,-9.9744308568385d-01,
     |  -4.2702245327232d-01, 9.7173500741978d-01,-2.2979375832853d-02,
     |  -8.7237497850757d-01, 5.4454704593561d-01, 4.6539455677015d-01,
     |  -8.4746546346258d-01, 1.6764964184325d-01, 7.0669351144933d-01,
     |  -7.0669351144933d-01,-1.6764964184325d-01, 8.4746546346258d-01,
     |  -4.6539455677015d-01,-5.4454704593561d-01, 8.7237497850758d-01,
     |   2.2979375832862d-02,-9.7173500741978d-01, 4.2702245327232d-01,
     |   9.9744308568385d-01,-5.7129864783178d-01,-1.4852203515101d+00,
     |  -9.1125720864163d-01,-2.4147342879262d-01,-2.6069039725951d-02,
     |  -8.0475682530721d-04,-2.5111750948480d-06,-5.6375959408196d-12/
      data (pmn(lat,13,25), lat = 1,36)/
     |   2.1067366700130d-13, 2.8582984722440d-07, 1.5762903266514d-04,
     |   7.5358230302388d-03, 9.7407864483636d-02, 5.1209511323786d-01,
     |   1.2568125838512d+00, 1.2824949555631d+00,-1.7229307953834d-01,
     |  -1.0828452865435d+00, 2.1958734836105d-01, 8.9987191637586d-01,
     |  -5.4312624751110d-01,-5.7253355480409d-01, 8.2433292590025d-01,
     |   5.4336153147290d-02,-8.3334555397805d-01, 4.9532030675363d-01,
     |   4.9532030675363d-01,-8.3334555397804d-01, 5.4336153147282d-02,
     |   8.2433292590025d-01,-5.7253355480409d-01,-5.4312624751110d-01,
     |   8.9987191637586d-01, 2.1958734836105d-01,-1.0828452865435d+00,
     |  -1.7229307953834d-01, 1.2824949555631d+00, 1.2568125838512d+00,
     |   5.1209511323786d-01, 9.7407864483636d-02, 7.5358230302389d-03,
     |   1.5762903266514d-04, 2.8582984722440d-07, 2.1067366700130d-13/
      data (pmn(lat,14,25), lat = 1,36)/
     |   7.1138136690143d-15, 2.9342177555215d-08, 2.7728987931543d-05,
     |   1.9415265591573d-03, 3.4540852970529d-02, 2.4606319945210d-01,
     |   8.4509236765217d-01, 1.4217951593948d+00, 7.9879754523258d-01,
     |  -7.5380608105718d-01,-7.9585666820720d-01, 7.1260784287209d-01,
     |   5.5647655698037d-01,-8.4448913232777d-01,-1.6577309980047d-01,
     |   8.8516552745622d-01,-3.0410107542480d-01,-7.0006716342776d-01,
     |   7.0006716342776d-01, 3.0410107542480d-01,-8.8516552745622d-01,
     |   1.6577309980047d-01, 8.4448913232777d-01,-5.5647655698037d-01,
     |  -7.1260784287210d-01, 7.9585666820720d-01, 7.5380608105718d-01,
     |  -7.9879754523258d-01,-1.4217951593948d+00,-8.4509236765218d-01,
     |  -2.4606319945210d-01,-3.4540852970529d-02,-1.9415265591573d-03,
     |  -2.7728987931543d-05,-2.9342177555215d-08,-7.1138136690143d-15/
      data (pmn(lat,15,25), lat = 1,36)/
     |   2.1734749273218d-16, 2.7212786344809d-09, 4.3920933736476d-06,
     |   4.4773731691660d-04, 1.0852195790911d-02, 1.0282203009062d-01,
     |   4.7452913619204d-01, 1.1506929433826d+00, 1.3413233829054d+00,
     |   1.9474077267103d-01,-1.0416342836957d+00,-3.2206682018894d-01,
     |   9.4682416726735d-01, 1.2354141959750d-01,-9.1992708874780d-01,
     |   2.0590742219726d-01, 8.0601065337220d-01,-5.5163785048095d-01,
     |  -5.5163785048095d-01, 8.0601065337220d-01, 2.0590742219726d-01,
     |  -9.1992708874780d-01, 1.2354141959749d-01, 9.4682416726735d-01,
     |  -3.2206682018893d-01,-1.0416342836957d+00, 1.9474077267103d-01,
     |   1.3413233829054d+00, 1.1506929433826d+00, 4.7452913619205d-01,
     |   1.0282203009062d-01, 1.0852195790911d-02, 4.4773731691660d-04,
     |   4.3920933736478d-06, 2.7212786344809d-09, 2.1734749273218d-16/
      data (pmn(lat,16,25), lat = 1,36)/
     |   6.0086592284519d-18, 2.2807627086792d-10, 6.2698259833121d-07,
     |   9.2621168889948d-05, 3.0348240479295d-03, 3.7736863413351d-02,
     |   2.2811808510043d-01, 7.4892326546229d-01, 1.3412483730030d+00,
     |   1.0452836608101d+00,-3.5974063166164d-01,-1.0422109838629d+00,
     |   1.5378027226850d-01, 9.5065661962129d-01,-2.5800835591130d-01,
     |  -8.4934529475701d-01, 4.7224722198396d-01, 6.8954301212761d-01,
     |  -6.8954301212761d-01,-4.7224722198396d-01, 8.4934529475701d-01,
     |   2.5800835591130d-01,-9.5065661962129d-01,-1.5378027226850d-01,
     |   1.0422109838629d+00, 3.5974063166164d-01,-1.0452836608101d+00,
     |  -1.3412483730030d+00,-7.4892326546229d-01,-2.2811808510043d-01,
     |  -3.7736863413351d-02,-3.0348240479295d-03,-9.2621168889949d-05,
     |  -6.2698259833123d-07,-2.2807627086792d-10,-6.0086592284519d-18/
      data (pmn(lat,17,25), lat = 1,36)/
     |   1.5009647880589d-19, 1.7254613846842d-11, 8.0609663351293d-08,
     |   1.7190858157404d-05, 7.5683792961372d-04, 1.2228615441150d-02,
     |   9.5147287536576d-02, 4.0801660147709d-01, 1.0121875714753d+00,
     |   1.3736717897196d+00, 6.3049626797494d-01,-7.5739366624248d-01,
     |  -8.5432796380754d-01, 5.1945053098928d-01, 8.2418113863378d-01,
     |  -5.2436175628070d-01,-7.3710458246515d-01, 6.2406499761855d-01,
     |   6.2406499761855d-01,-7.3710458246515d-01,-5.2436175628071d-01,
     |   8.2418113863378d-01, 5.1945053098928d-01,-8.5432796380754d-01,
     |  -7.5739366624248d-01, 6.3049626797494d-01, 1.3736717897196d+00,
     |   1.0121875714753d+00, 4.0801660147709d-01, 9.5147287536577d-02,
     |   1.2228615441150d-02, 7.5683792961372d-04, 1.7190858157405d-05,
     |   8.0609663351296d-08, 1.7254613846842d-11, 1.5009647880589d-19/
      data (pmn(lat,18,25), lat = 1,36)/
     |   3.3777447969771d-21, 1.1749365270744d-12, 9.3109646462500d-09,
     |   2.8576493994508d-06, 1.6821924711840d-04, 3.5047742245330d-03,
     |   3.4658670403846d-02, 1.8969647717414d-01, 6.1895224077505d-01,
     |   1.2117419200359d+00, 1.2639752511327d+00, 2.0798009340462d-01,
     |  -9.7646996256599d-01,-6.0210152451252d-01, 7.4682867690402d-01,
     |   6.7722868758342d-01,-6.7292782179496d-01,-6.7286795009739d-01,
     |   6.7286795009738d-01, 6.7292782179496d-01,-6.7722868758341d-01,
     |  -7.4682867690402d-01, 6.0210152451252d-01, 9.7646996256599d-01,
     |  -2.0798009340461d-01,-1.2639752511327d+00,-1.2117419200359d+00,
     |  -6.1895224077505d-01,-1.8969647717414d-01,-3.4658670403846d-02,
     |  -3.5047742245330d-03,-1.6821924711840d-04,-2.8576493994508d-06,
     |  -9.3109646462503d-09,-1.1749365270744d-12,-3.3777447969771d-21/
      data (pmn(lat,19,25), lat = 1,36)/
     |   6.8133206437096d-23, 7.1660135405647d-14, 9.6178035438503d-10,
     |   4.2371083856866d-07, 3.3217588834651d-05, 8.8700545394512d-04,
     |   1.1042577635247d-02, 7.5911466772984d-02, 3.1587362089860d-01,
     |   8.2593110303636d-01, 1.3231848515098d+00, 1.0722257411575d+00,
     |  -1.3983122096251d-01,-1.0605582830471d+00,-3.8799089189033d-01,
     |   8.6213621902690d-01, 5.9726275183035d-01,-7.1979159233477d-01,
     |  -7.1979159233478d-01, 5.9726275183035d-01, 8.6213621902691d-01,
     |  -3.8799089189033d-01,-1.0605582830471d+00,-1.3983122096250d-01,
     |   1.0722257411575d+00, 1.3231848515098d+00, 8.2593110303636d-01,
     |   3.1587362089860d-01, 7.5911466772984d-02, 1.1042577635247d-02,
     |   8.8700545394512d-04, 3.3217588834651d-05, 4.2371083856867d-07,
     |   9.6178035438507d-10, 7.1660135405647d-14, 6.8133206437096d-23/
      data (pmn(lat,20,25), lat = 1,36)/
     |   1.2223264441743d-24, 3.8847421723186d-15, 8.8186065174196d-11,
     |   5.5645089504972d-08, 5.7906218656724d-06, 1.9720955670079d-04,
     |   3.0679186342558d-03, 2.6179362478404d-02, 1.3611659183187d-01,
     |   4.5603498613044d-01, 9.9803030551748d-01, 1.3575682862266d+00,
     |   8.7458514038510d-01,-3.7284514319810d-01,-1.0805620509316d+00,
     |  -2.8130648964965d-01, 9.0056654864717d-01, 6.4598197439426d-01,
     |  -6.4598197439426d-01,-9.0056654864717d-01, 2.8130648964965d-01,
     |   1.0805620509316d+00, 3.7284514319810d-01,-8.7458514038511d-01,
     |  -1.3575682862266d+00,-9.9803030551748d-01,-4.5603498613044d-01,
     |  -1.3611659183187d-01,-2.6179362478404d-02,-3.0679186342558d-03,
     |  -1.9720955670079d-04,-5.7906218656724d-06,-5.5645089504974d-08,
     |  -8.8186065174200d-11,-3.8847421723186d-15,-1.2223264441743d-24/
      data (pmn(lat,21,25), lat = 1,36)/
     |   1.9274325433043d-26, 1.8500067981590d-16, 7.0950327724506d-12,
     |   6.4004441621040d-09, 8.8167295413030d-07, 3.8142158551675d-05,
     |   7.3709765155248d-04, 7.7379416414235d-03, 4.9550762968656d-02,
     |   2.0729142330032d-01, 5.8622074618941d-01, 1.1193767230504d+00,
     |   1.3523148210547d+00, 7.4175359592227d-01,-4.7822593054296d-01,
     |  -1.0985878417701d+00,-3.3440843651921d-01, 8.5426367177446d-01,
     |   8.5426367177446d-01,-3.3440843651920d-01,-1.0985878417701d+00,
     |  -4.7822593054296d-01, 7.4175359592227d-01, 1.3523148210547d+00,
     |   1.1193767230504d+00, 5.8622074618941d-01, 2.0729142330032d-01,
     |   4.9550762968656d-02, 7.7379416414235d-03, 7.3709765155249d-04,
     |   3.8142158551675d-05, 8.8167295413030d-07, 6.4004441621042d-09,
     |   7.0950327724510d-12, 1.8500067981590d-16, 1.9274325433043d-26/
      data (pmn(lat,22,25), lat = 1,36)/
     |   2.6227533844798d-28, 7.5991490279806d-18, 4.9188151229186d-13,
     |   6.3336641765599d-10, 1.1522145838210d-07, 6.3105567275807d-06,
     |   1.5076572379304d-04, 1.9334513461092d-03, 1.5085851082617d-02,
     |   7.7431403971112d-02, 2.7398455758151d-01, 6.8283527838207d-01,
     |   1.1890200986578d+00, 1.3535353235296d+00, 7.3330740007871d-01,
     |  -4.3489066783946d-01,-1.1309530953529d+00,-6.0025540744834d-01,
     |   6.0025540744834d-01, 1.1309530953529d+00, 4.3489066783947d-01,
     |  -7.3330740007870d-01,-1.3535353235296d+00,-1.1890200986578d+00,
     |  -6.8283527838208d-01,-2.7398455758151d-01,-7.7431403971112d-02,
     |  -1.5085851082618d-02,-1.9334513461092d-03,-1.5076572379304d-04,
     |  -6.3105567275807d-06,-1.1522145838210d-07,-6.3336641765601d-10,
     |  -4.9188151229189d-13,-7.5991490279806d-18,-2.6227533844798d-28/
      data (pmn(lat,23,25), lat = 1,36)/
     |   2.9875193647644d-30, 2.6118715962101d-19, 2.8509429985277d-14,
     |   5.2326929417168d-11, 1.2546220170261d-08, 8.6746705403807d-07,
     |   2.5519716957498d-05, 3.9754125320295d-04, 3.7483449352858d-03,
     |   2.3307234162361d-02, 1.0104324026916d-01, 3.1604148242682d-01,
     |   7.2436996059280d-01, 1.2081921145343d+00, 1.3941987289026d+00,
     |   9.0174235228740d-01,-1.6384214270452d-01,-1.0721844078348d+00,
     |  -1.0721844078348d+00,-1.6384214270452d-01, 9.0174235228740d-01,
     |   1.3941987289026d+00, 1.2081921145343d+00, 7.2436996059280d-01,
     |   3.1604148242683d-01, 1.0104324026916d-01, 2.3307234162361d-02,
     |   3.7483449352858d-03, 3.9754125320295d-04, 2.5519716957498d-05,
     |   8.6746705403807d-07, 1.2546220170261d-08, 5.2326929417170d-11,
     |   2.8509429985279d-14, 2.6118715962101d-19, 2.9875193647644d-30/
      data (pmn(lat,24,25), lat = 1,36)/
     |   2.6902515359283d-32, 7.0943003929006d-21, 1.3048496879100d-15,
     |   3.4097281778120d-12, 1.0756330999629d-09, 9.3661320700442d-08,
     |   3.3816038244260d-06, 6.3693436411121d-05, 7.2098818413383d-04,
     |   5.3792475141415d-03, 2.8154239234380d-02, 1.0784849424047d-01,
     |   3.1088282735027d-01, 6.8470724127795d-01, 1.1537369455161d+00,
     |   1.4560960502640d+00, 1.2706917644904d+00, 5.1009532705376d-01,
     |  -5.1009532705376d-01,-1.2706917644904d+00,-1.4560960502640d+00,
     |  -1.1537369455161d+00,-6.8470724127795d-01,-3.1088282735027d-01,
     |  -1.0784849424047d-01,-2.8154239234380d-02,-5.3792475141415d-03,
     |  -7.2098818413384d-04,-6.3693436411121d-05,-3.3816038244260d-06,
     |  -9.3661320700442d-08,-1.0756330999629d-09,-3.4097281778121d-12,
     |  -1.3048496879100d-15,-7.0943003929006d-21,-2.6902515359283d-32/
      data (pmn(lat,25,25), lat = 1,36)/
     |   1.6611199587508d-34, 1.3208505281103d-22, 4.0910116980568d-17,
     |   1.5203971924391d-13, 6.3009128182084d-11, 6.8952807079568d-09,
     |   3.0466674732770d-07, 6.9117839081338d-06, 9.3431991715796d-05,
     |   8.3020255182500d-04, 5.1889360842667d-03, 2.3940970505054d-02,
     |   8.4456884138491d-02, 2.3377367494262d-01, 5.1748706094331d-01,
     |   9.2885898011802d-01, 1.3649794419929d+00, 1.6522403813728d+00,
     |   1.6522403813728d+00, 1.3649794419929d+00, 9.2885898011802d-01,
     |   5.1748706094331d-01, 2.3377367494262d-01, 8.4456884138491d-02,
     |   2.3940970505054d-02, 5.1889360842667d-03, 8.3020255182500d-04,
     |   9.3431991715797d-05, 6.9117839081339d-06, 3.0466674732771d-07,
     |   6.8952807079568d-09, 6.3009128182084d-11, 1.5203971924392d-13,
     |   4.0910116980570d-17, 1.3208505281103d-22, 1.6611199587508d-34/
      data (pmn(lat, 0,26), lat = 1,36)/
     |   3.5661206768497d+00,-1.9366690847744d+00, 4.4448207161471d-01,
     |   7.7246087240028d-01,-1.2670208897490d+00, 9.4021982189853d-01,
     |  -1.1047467112626d-01,-6.7880538127430d-01, 9.7040630180057d-01,
     |  -6.3956910796421d-01,-6.1809791170952d-02, 6.7911696253802d-01,
     |  -8.3690673127200d-01, 4.5978488344046d-01, 1.9535301731752d-01,
     |  -7.0830726386753d-01, 7.5856510199437d-01,-3.2131940782412d-01,
     |  -3.2131940782412d-01, 7.5856510199437d-01,-7.0830726386753d-01,
     |   1.9535301731751d-01, 4.5978488344046d-01,-8.3690673127200d-01,
     |   6.7911696253802d-01,-6.1809791170952d-02,-6.3956910796421d-01,
     |   9.7040630180058d-01,-6.7880538127430d-01,-1.1047467112627d-01,
     |   9.4021982189853d-01,-1.2670208897490d+00, 7.7246087240027d-01,
     |   4.4448207161473d-01,-1.9366690847744d+00, 3.5661206768497d+00/
      data (pmn(lat, 1,26), lat = 1,36)/
     |   2.5058331958626d+00, 7.7687874647617d-01,-1.6219544655078d+00,
     |   1.2800401808726d+00,-2.9504925348198d-01,-6.6921759474287d-01,
     |   1.0801404369592d+00,-7.8169680621348d-01, 3.6164130792941d-02,
     |   6.6318927756254d-01,-8.9483524504446d-01, 5.5009768593408d-01,
     |   1.2274969271943d-01,-6.8770749512585d-01, 7.9469283101007d-01,
     |  -3.9073196009176d-01,-2.5623188612401d-01, 7.3065740251462d-01,
     |  -7.3065740251462d-01, 2.5623188612401d-01, 3.9073196009177d-01,
     |  -7.9469283101007d-01, 6.8770749512584d-01,-1.2274969271944d-01,
     |  -5.5009768593409d-01, 8.9483524504446d-01,-6.6318927756254d-01,
     |  -3.6164130792946d-02, 7.8169680621349d-01,-1.0801404369592d+00,
     |   6.6921759474287d-01, 2.9504925348198d-01,-1.2800401808726d+00,
     |   1.6219544655077d+00,-7.7687874647617d-01,-2.5058331958626d+00/
      data (pmn(lat, 2,26), lat = 1,36)/
     |   7.6729270974630d-01, 2.3855059356916d+00,-9.9816659212857d-01,
     |  -4.6667392699850d-01, 1.2149839094715d+00,-1.0387408615672d+00,
     |   2.3879868585571d-01, 6.0276588039197d-01,-9.6880824165559d-01,
     |   6.8642000477336d-01, 9.9935854408547d-03,-6.5359484148776d-01,
     |   8.4293180359645d-01,-4.8197447398101d-01,-1.7669090842155d-01,
     |   7.0277031197799d-01,-7.6219801151654d-01, 3.2418961151948d-01,
     |   3.2418961151948d-01,-7.6219801151654d-01, 7.0277031197799d-01,
     |  -1.7669090842155d-01,-4.8197447398101d-01, 8.4293180359645d-01,
     |  -6.5359484148775d-01, 9.9935854408547d-03, 6.8642000477337d-01,
     |  -9.6880824165559d-01, 6.0276588039197d-01, 2.3879868585572d-01,
     |  -1.0387408615672d+00, 1.2149839094715d+00,-4.6667392699848d-01,
     |  -9.9816659212859d-01, 2.3855059356916d+00, 7.6729270974630d-01/
      data (pmn(lat, 3,26), lat = 1,36)/
     |   1.5152312904893d-01, 1.9681963707351d+00, 9.4395060786863d-01,
     |  -1.5081254615308d+00, 7.4063116223174d-01, 3.6859571279804d-01,
     |  -1.0264069217746d+00, 9.0304307873717d-01,-1.9657056388291d-01,
     |  -5.6972534176669d-01, 8.9856559867391d-01,-6.1480841928376d-01,
     |  -5.6570849565424d-02, 6.5941144104316d-01,-8.0541995297085d-01,
     |   4.1547554430556d-01, 2.4175281891849d-01,-7.3060789648994d-01,
     |   7.3060789648993d-01,-2.4175281891848d-01,-4.1547554430557d-01,
     |   8.0541995297085d-01,-6.5941144104316d-01, 5.6570849565432d-02,
     |   6.1480841928377d-01,-8.9856559867391d-01, 5.6972534176668d-01,
     |   1.9657056388291d-01,-9.0304307873717d-01, 1.0264069217746d+00,
     |  -3.6859571279804d-01,-7.4063116223174d-01, 1.5081254615308d+00,
     |  -9.4395060786861d-01,-1.9681963707351d+00,-1.5152312904893d-01/
      data (pmn(lat, 4,26), lat = 1,36)/
     |   2.2085148203776d-02, 1.0189506964327d+00, 1.9750667595223d+00,
     |  -6.2385283960096d-01,-8.1183748691444d-01, 1.2049809712245d+00,
     |  -6.0784412169433d-01,-3.3656518547051d-01, 9.2401171235645d-01,
     |  -8.0864422256250d-01, 1.4745450260610d-01, 5.6696526777830d-01,
     |  -8.5331539913137d-01, 5.4645440365741d-01, 1.1945167080252d-01,
     |  -6.8478010923970d-01, 7.7277462480429d-01,-3.3288233247573d-01,
     |  -3.3288233247573d-01, 7.7277462480429d-01,-6.8478010923970d-01,
     |   1.1945167080252d-01, 5.4645440365741d-01,-8.5331539913137d-01,
     |   5.6696526777829d-01, 1.4745450260610d-01,-8.0864422256250d-01,
     |   9.2401171235645d-01,-3.3656518547050d-01,-6.0784412169434d-01,
     |   1.2049809712245d+00,-8.1183748691444d-01,-6.2385283960097d-01,
     |   1.9750667595223d+00, 1.0189506964327d+00, 2.2085148203776d-02/
      data (pmn(lat, 5,26), lat = 1,36)/
     |   2.5455536782244d-03, 3.9124072931442d-01, 1.7796599113313d+00,
     |   9.1082632539334d-01,-1.3453650058288d+00, 3.3833865958767d-01,
     |   7.4012693658074d-01,-1.0426891888816d+00, 5.0662359851876d-01,
     |   3.4606656181169d-01,-8.6915979429716d-01, 7.2905131594464d-01,
     |  -7.9175114781244d-02,-5.9392892538373d-01, 8.2166756771648d-01,
     |  -4.6441073115087d-01,-2.1200068423881d-01, 7.3042822204408d-01,
     |  -7.3042822204408d-01, 2.1200068423881d-01, 4.6441073115088d-01,
     |  -8.2166756771648d-01, 5.9392892538373d-01, 7.9175114781236d-02,
     |  -7.2905131594465d-01, 8.6915979429716d-01,-3.4606656181169d-01,
     |  -5.0662359851877d-01, 1.0426891888816d+00,-7.4012693658073d-01,
     |  -3.3833865958767d-01, 1.3453650058288d+00,-9.1082632539333d-01,
     |  -1.7796599113314d+00,-3.9124072931442d-01,-2.5455536782244d-03/
      data (pmn(lat, 6,26), lat = 1,36)/
     |   2.4191433350154d-04, 1.1988036253323d-01, 1.1069778777066d+00,
     |   1.7428454680615d+00,-4.3508696309692d-01,-9.6319272555272d-01,
     |   1.0605112571009d+00,-1.8513109908266d-01,-7.1758230241052d-01,
     |   9.3696714943860d-01,-4.0582132592575d-01,-3.9200003767231d-01,
     |   8.4374162590696d-01,-6.4540700565390d-01,-2.0398439491580d-02,
     |   6.5013971238945d-01,-7.8926988112219d-01, 3.4765228083668d-01,
     |   3.4765228083669d-01,-7.8926988112219d-01, 6.5013971238945d-01,
     |  -2.0398439491578d-02,-6.4540700565390d-01, 8.4374162590696d-01,
     |  -3.9200003767231d-01,-4.0582132592575d-01, 9.3696714943860d-01,
     |  -7.1758230241052d-01,-1.8513109908266d-01, 1.0605112571009d+00,
     |  -9.6319272555272d-01,-4.3508696309692d-01, 1.7428454680615d+00,
     |   1.1069778777066d+00, 1.1988036253323d-01, 2.4191433350154d-04/
      data (pmn(lat, 7,26), lat = 1,36)/
     |   1.9489597990007d-05, 3.0550720151764d-02, 5.3658026683688d-01,
     |   1.6628690188232d+00, 8.6690266945807d-01,-1.2056633627237d+00,
     |   3.0740885823602d-02, 9.3942956475804d-01,-8.7699574759932d-01,
     |   5.1840084739981d-02, 7.3157200642434d-01,-8.5229865627680d-01,
     |   2.8505294027654d-01, 4.7443132462694d-01,-8.3210782268569d-01,
     |   5.3593783027187d-01, 1.6538328949221d-01,-7.2994854674669d-01,
     |   7.2994854674669d-01,-1.6538328949220d-01,-5.3593783027188d-01,
     |   8.3210782268569d-01,-4.7443132462694d-01,-2.8505294027654d-01,
     |   8.5229865627680d-01,-7.3157200642434d-01,-5.1840084739985d-02,
     |   8.7699574759933d-01,-9.3942956475804d-01,-3.0740885823613d-02,
     |   1.2056633627237d+00,-8.6690266945807d-01,-1.6628690188232d+00,
     |  -5.3658026683689d-01,-3.0550720151764d-02,-1.9489597990007d-05/
      data (pmn(lat, 8,26), lat = 1,36)/
     |   1.3574160593277d-06, 6.6491507016797d-03, 2.1427881014717d-01,
     |   1.1433796621979d+00, 1.5925864358940d+00,-3.0216318360925d-01,
     |  -1.0453621360310d+00, 8.6149219546569d-01, 1.9813886160878d-01,
     |  -9.2090007000474d-01, 7.1940220845489d-01, 9.7142510124639d-02,
     |  -7.7109921940982d-01, 7.6060849363843d-01,-1.2389696139426d-01,
     |  -5.9170106248594d-01, 8.0976962868022d-01,-3.6895406938848d-01,
     |  -3.6895406938849d-01, 8.0976962868022d-01,-5.9170106248594d-01,
     |  -1.2389696139427d-01, 7.6060849363843d-01,-7.7109921940983d-01,
     |   9.7142510124629d-02, 7.1940220845489d-01,-9.2090007000474d-01,
     |   1.9813886160878d-01, 8.6149219546569d-01,-1.0453621360310d+00,
     |  -3.0216318360925d-01, 1.5925864358940d+00, 1.1433796621979d+00,
     |   2.1427881014717d-01, 6.6491507016797d-03, 1.3574160593277d-06/
      data (pmn(lat, 9,26), lat = 1,36)/
     |   8.2911962147201d-08, 1.2586443993795d-03, 7.2780638923006d-02,
     |   6.2777516183812d-01, 1.5730739432175d+00, 8.5086642978936d-01,
     |  -1.0771226733160d+00,-2.3560123095949d-01, 1.0258997260833d+00,
     |  -5.9041050839580d-01,-3.8891759704937d-01, 9.0250358019730d-01,
     |  -5.4453014491891d-01,-2.7958502215062d-01, 8.1770611091737d-01,
     |  -6.2632016791756d-01,-9.9512273534502d-02, 7.2889092643364d-01,
     |  -7.2889092643364d-01, 9.9512273534500d-02, 6.2632016791757d-01,
     |  -8.1770611091737d-01, 2.7958502215062d-01, 5.4453014491891d-01,
     |  -9.0250358019730d-01, 3.8891759704937d-01, 5.9041050839580d-01,
     |  -1.0258997260833d+00, 2.3560123095949d-01, 1.0771226733160d+00,
     |  -8.5086642978936d-01,-1.5730739432175d+00,-6.2777516183812d-01,
     |  -7.2780638923007d-02,-1.2586443993795d-03,-8.2911962147201d-08/
      data (pmn(lat,10,26), lat = 1,36)/
     |   4.4892484321279d-09, 2.0995511278563d-04, 2.1460562448126d-02,
     |   2.8862831479659d-01, 1.1474220468754d+00, 1.4958474165580d+00,
     |  -1.6957319952713d-01,-1.0974748969923d+00, 6.1357752641226d-01,
     |   5.4070085137860d-01,-9.4704249989605d-01, 3.1978280885252d-01,
     |   5.7610605405541d-01,-8.5597548470582d-01, 3.1329864709399d-01,
     |   4.9930993894714d-01,-8.3112411475786d-01, 3.9749595368497d-01,
     |   3.9749595368498d-01,-8.3112411475786d-01, 4.9930993894714d-01,
     |   3.1329864709400d-01,-8.5597548470582d-01, 5.7610605405542d-01,
     |   3.1978280885253d-01,-9.4704249989605d-01, 5.4070085137860d-01,
     |   6.1357752641227d-01,-1.0974748969923d+00,-1.6957319952714d-01,
     |   1.4958474165580d+00, 1.1474220468754d+00, 2.8862831479659d-01,
     |   2.1460562448126d-02, 2.0995511278563d-04, 4.4892484321279d-09/
      data (pmn(lat,11,26), lat = 1,36)/
     |   2.1722063681493d-10, 3.1162050236368d-05, 5.5712046627866d-03,
     |   1.1417269037919d-01, 6.7760072482586d-01, 1.4968794966262d+00,
     |   8.7637036237647d-01,-9.3611619548905d-01,-4.9267541347862d-01,
     |   1.0075672906904d+00,-2.0190396059443d-01,-7.5016175184576d-01,
     |   8.0016967263308d-01,-7.1752608130373d-03,-7.5020511755593d-01,
     |   7.2780221683203d-01, 1.1236932945643d-02,-7.2683524239809d-01,
     |   7.2683524239809d-01,-1.1236932945641d-02,-7.2780221683203d-01,
     |   7.5020511755593d-01, 7.1752608130387d-03,-8.0016967263308d-01,
     |   7.5016175184575d-01, 2.0190396059443d-01,-1.0075672906904d+00,
     |   4.9267541347862d-01, 9.3611619548905d-01,-8.7637036237646d-01,
     |  -1.4968794966262d+00,-6.7760072482586d-01,-1.1417269037919d-01,
     |  -5.5712046627868d-03,-3.1162050236368d-05,-2.1722063681493d-10/
      data (pmn(lat,12,26), lat = 1,36)/
     |   9.4503169590214d-12, 4.1447937703314d-06, 1.2860383551927d-03,
     |   3.9530563019791d-02, 3.3806618665085d-01, 1.1252507832626d+00,
     |   1.4404245260742d+00,-5.7228674665446d-03,-1.1207493764265d+00,
     |   2.9973258930266d-01, 8.2238440895472d-01,-7.6627554513660d-01,
     |  -2.0328412712702d-01, 8.6959920377055d-01,-5.3725293062566d-01,
     |  -3.6017407065373d-01, 8.4837471207789d-01,-4.3433679428096d-01,
     |  -4.3433679428097d-01, 8.4837471207789d-01,-3.6017407065373d-01,
     |  -5.3725293062566d-01, 8.6959920377054d-01,-2.0328412712703d-01,
     |  -7.6627554513661d-01, 8.2238440895472d-01, 2.9973258930266d-01,
     |  -1.1207493764265d+00,-5.7228674665474d-03, 1.4404245260742d+00,
     |   1.1252507832626d+00, 3.3806618665085d-01, 3.9530563019791d-02,
     |   1.2860383551927d-03, 4.1447937703314d-06, 9.4503169590214d-12/
      data (pmn(lat,13,26), lat = 1,36)/
     |   3.7132558278046d-13, 4.9661697634771d-07, 2.6584782550341d-04,
     |   1.2118242913178d-02, 1.4595334842051d-01, 6.9075268301942d-01,
     |   1.4268746695940d+00, 9.4880858502777d-01,-7.5284821750239d-01,
     |  -7.4737461741080d-01, 8.5443583485051d-01, 2.6506818747352d-01,
     |  -9.2625806972563d-01, 3.7729432772149d-01, 5.9252914499425d-01,
     |  -8.2563883558472d-01, 1.0323680247260d-01, 7.2316029115292d-01,
     |  -7.2316029115292d-01,-1.0323680247260d-01, 8.2563883558473d-01,
     |  -5.9252914499424d-01,-3.7729432772149d-01, 9.2625806972563d-01,
     |  -2.6506818747351d-01,-8.5443583485051d-01, 7.4737461741079d-01,
     |   7.5284821750239d-01,-9.4880858502776d-01,-1.4268746695940d+00,
     |  -6.9075268301942d-01,-1.4595334842051d-01,-1.2118242913178d-02,
     |  -2.6584782550341d-04,-4.9661697634771d-07,-3.7132558278046d-13/
      data (pmn(lat,14,26), lat = 1,36)/
     |   1.3218349906815d-14, 5.3797667381662d-08, 4.9457926024755d-05,
     |   3.3149071246427d-03, 5.5340366893961d-02, 3.5988669454281d-01,
     |   1.0777058190466d+00, 1.4157041303104d+00, 2.1167002853103d-01,
     |  -1.0879752802327d+00,-9.5158130515565d-02, 9.7773684956909d-01,
     |  -3.4146489396117d-01,-7.1288691980046d-01, 7.6353224931187d-01,
     |   1.6037120279819d-01,-8.5382882981220d-01, 4.8106251414346d-01,
     |   4.8106251414347d-01,-8.5382882981220d-01, 1.6037120279818d-01,
     |   7.6353224931187d-01,-7.1288691980045d-01,-3.4146489396117d-01,
     |   9.7773684956909d-01,-9.5158130515565d-02,-1.0879752802327d+00,
     |   2.1167002853102d-01, 1.4157041303104d+00, 1.0777058190466d+00,
     |   3.5988669454281d-01, 5.5340366893961d-02, 3.3149071246427d-03,
     |   4.9457926024757d-05, 5.3797667381662d-08, 1.3218349906815d-14/
      data (pmn(lat,15,26), lat = 1,36)/
     |   4.2710096738761d-16, 5.2810091332393d-09, 8.3073032854110d-06,
     |   8.1333876324019d-04, 1.8603634667294d-02, 1.6256295358463d-01,
     |   6.6852993031500d-01, 1.3535557343326d+00, 1.0655708656866d+00,
     |  -4.9013477368183d-01,-9.7058523989063d-01, 5.1378728521953d-01,
     |   7.2786304443572d-01,-7.6063418832573d-01,-3.0526030793233d-01,
     |   8.9368798826923d-01,-2.4803150156510d-01,-7.1693961042278d-01,
     |   7.1693961042277d-01, 2.4803150156510d-01,-8.9368798826923d-01,
     |   3.0526030793233d-01, 7.6063418832573d-01,-7.2786304443572d-01,
     |  -5.1378728521954d-01, 9.7058523989063d-01, 4.9013477368184d-01,
     |  -1.0655708656866d+00,-1.3535557343326d+00,-6.6852993031500d-01,
     |  -1.6256295358463d-01,-1.8603634667294d-02,-8.1333876324020d-04,
     |  -8.3073032854112d-06,-5.2810091332393d-09,-4.2710096738761d-16/
      data (pmn(lat,16,26), lat = 1,36)/
     |   1.2534938231120d-17, 4.7023960480072d-10, 1.2619617172752d-06,
     |   1.7954776198593d-04, 5.5775873155462d-03, 6.4470589861407d-02,
     |   3.5250381134572d-01, 1.0010990580314d+00, 1.4046090886214d+00,
     |   4.9588694896373d-01,-9.4127680465250d-01,-5.5213511515397d-01,
     |   8.8121987702233d-01, 2.9592407605599d-01,-9.2226853407871d-01,
     |   1.1103330155157d-01, 8.3553856065076d-01,-5.4012517298929d-01,
     |  -5.4012517298929d-01, 8.3553856065076d-01, 1.1103330155158d-01,
     |  -9.2226853407871d-01, 2.9592407605599d-01, 8.8121987702233d-01,
     |  -5.5213511515396d-01,-9.4127680465250d-01, 4.9588694896372d-01,
     |   1.4046090886214d+00, 1.0010990580314d+00, 3.5250381134572d-01,
     |   6.4470589861407d-02, 5.5775873155462d-03, 1.7954776198593d-04,
     |   1.2619617172752d-06, 4.7023960480072d-10, 1.2534938231120d-17/
      data (pmn(lat,17,26), lat = 1,36)/
     |   3.3399401318560d-19, 3.7971438980621d-11, 1.7342467256007d-07,
     |   3.5706893438934d-05, 1.4961878742720d-03, 2.2614342454677d-02,
     |   1.6091182293574d-01, 6.1030088294962d-01, 1.2609685919803d+00,
     |   1.2092596142551d+00,-1.0853395992173d-01,-1.0753726876697d+00,
     |  -4.6552543519827d-02, 9.7758512742059d-01,-1.3232565800852d-01,
     |  -8.8835876803784d-01, 4.2684559616950d-01, 7.0674599263058d-01,
     |  -7.0674599263058d-01,-4.2684559616950d-01, 8.8835876803783d-01,
     |   1.3232565800852d-01,-9.7758512742059d-01, 4.6552543519835d-02,
     |   1.0753726876697d+00, 1.0853395992173d-01,-1.2092596142551d+00,
     |  -1.2609685919803d+00,-6.1030088294962d-01,-1.6091182293574d-01,
     |  -2.2614342454677d-02,-1.4961878742720d-03,-3.5706893438934d-05,
     |  -1.7342467256008d-07,-3.7971438980621d-11,-3.3399401318560d-19/
      data (pmn(lat,18,26), lat = 1,36)/
     |   8.0648239682373d-21, 2.7760291378807d-12, 2.1534030606255d-08,
     |   6.3942256180247d-06, 3.5943507630522d-04, 7.0417379070504d-03,
     |   6.4225850580519d-02, 3.1573234568976d-01, 8.8749870838224d-01,
     |   1.3764931059504d+00, 8.3856214619172d-01,-5.9516696976116d-01,
     |  -9.5967597561691d-01, 3.8348094078358d-01, 8.8976074664667d-01,
     |  -4.5219390323075d-01,-7.7465583818472d-01, 6.1555644800709d-01,
     |   6.1555644800709d-01,-7.7465583818472d-01,-4.5219390323076d-01,
     |   8.8976074664667d-01, 3.8348094078358d-01,-9.5967597561692d-01,
     |  -5.9516696976117d-01, 8.3856214619172d-01, 1.3764931059504d+00,
     |   8.8749870838224d-01, 3.1573234568976d-01, 6.4225850580519d-02,
     |   7.0417379070504d-03, 3.5943507630522d-04, 6.3942256180248d-06,
     |   2.1534030606256d-08, 2.7760291378807d-12, 8.0648239682373d-21/
      data (pmn(lat,19,26), lat = 1,36)/
     |   1.7588594216097d-22, 1.8315678136533d-13, 2.4089730217199d-09,
     |   1.0286852689810d-06, 7.7230543126733d-05, 1.9476554030544d-03,
     |   2.2516114853846d-02, 1.4062123361654d-01, 5.1515072170008d-01,
     |   1.1249109757208d+00, 1.3346945053111d+00, 4.0844884406176d-01,
     |  -8.9905351088944d-01,-7.2391651676123d-01, 6.7107246758865d-01,
     |   7.4150948013951d-01,-6.4118308352717d-01,-6.9024825287678d-01,
     |   6.9024825287678d-01, 6.4118308352717d-01,-7.4150948013951d-01,
     |  -6.7107246758865d-01, 7.2391651676123d-01, 8.9905351088944d-01,
     |  -4.0844884406175d-01,-1.3346945053111d+00,-1.1249109757208d+00,
     |  -5.1515072170008d-01,-1.4062123361654d-01,-2.2516114853846d-02,
     |  -1.9476554030544d-03,-7.7230543126733d-05,-1.0286852689810d-06,
     |  -2.4089730217200d-09,-1.8315678136533d-13,-1.7588594216097d-22/
      data (pmn(lat,20,26), lat = 1,36)/
     |   3.4461264394598d-24, 1.0848964198260d-14, 2.4158846772386d-10,
     |   1.4800570565900d-07, 1.4786701061329d-05, 4.7736693992462d-04,
     |   6.9349123558770d-03, 5.4241226173510d-02, 2.5211565703485d-01,
     |   7.2741176353140d-01, 1.2821295549380d+00, 1.1803432583880d+00,
     |   2.3623094929271d-02,-1.0404701189147d+00,-4.9272680550611d-01,
     |   8.2625113005634d-01, 6.4033237399695d-01,-7.1468502300218d-01,
     |  -7.1468502300218d-01, 6.4033237399695d-01, 8.2625113005634d-01,
     |  -4.9272680550611d-01,-1.0404701189147d+00, 2.3623094929278d-02,
     |   1.1803432583880d+00, 1.2821295549380d+00, 7.2741176353140d-01,
     |   2.5211565703485d-01, 5.4241226173510d-02, 6.9349123558771d-03,
     |   4.7736693992462d-04, 1.4786701061329d-05, 1.4800570565900d-07,
     |   2.4158846772387d-10, 1.0848964198260d-14, 3.4461264394598d-24/
      data (pmn(lat,21,26), lat = 1,36)/
     |   6.0173757703531d-26, 5.7236487268900d-16, 2.1552668120130d-11,
     |   1.8904937017854d-08, 2.5056858691004d-06, 1.0308596365410d-04,
     |   1.8691306066391d-03, 1.8113885688412d-02, 1.0488919973517d-01,
     |   3.8565193371330d-01, 9.1719169811835d-01, 1.3546898481111d+00,
     |   9.8999449689486d-01,-2.5301568799068d-01,-1.0871415744257d+00,
     |  -3.5603791364896d-01, 8.8595255422234d-01, 6.6325284011734d-01,
     |  -6.6325284011734d-01,-8.8595255422234d-01, 3.5603791364895d-01,
     |   1.0871415744257d+00, 2.5301568799068d-01,-9.8999449689486d-01,
     |  -1.3546898481111d+00,-9.1719169811835d-01,-3.8565193371330d-01,
     |  -1.0488919973517d-01,-1.8113885688413d-02,-1.8691306066391d-03,
     |  -1.0308596365410d-04,-2.5056858691004d-06,-1.8904937017855d-08,
     |  -2.1552668120131d-11,-5.7236487268900d-16,-6.0173757703531d-26/
      data (pmn(lat,22,26), lat = 1,36)/
     |   9.2519521175835d-28, 2.6575743703694d-17, 1.6903947283930d-12,
     |   2.1192417966839d-09, 3.7167845537244d-07, 1.9413344165184d-05,
     |   4.3692461010962d-04, 5.2031522513090d-03, 3.7041866951630d-02,
     |   1.6956209121075d-01, 5.1823054646882d-01, 1.0602960580238d+00,
     |   1.3715756382826d+00, 8.4371381710708d-01,-3.9518860912161d-01,
     |  -1.1096257081325d+00,-3.7788819310104d-01, 8.5320846298607d-01,
     |   8.5320846298607d-01,-3.7788819310104d-01,-1.1096257081325d+00,
     |  -3.9518860912161d-01, 8.4371381710708d-01, 1.3715756382826d+00,
     |   1.0602960580238d+00, 5.1823054646882d-01, 1.6956209121075d-01,
     |   3.7041866951630d-02, 5.2031522513090d-03, 4.3692461010963d-04,
     |   1.9413344165184d-05, 3.7167845537244d-07, 2.1192417966840d-09,
     |   1.6903947283931d-12, 2.6575743703694d-17, 9.2519521175835d-28/
      data (pmn(lat,23,26), lat = 1,36)/
     |   1.2295691028290d-29, 1.0660971480116d-18, 1.1443769696729d-13,
     |   2.0475220262810d-10, 4.7412343991194d-08, 3.1340966761570d-06,
     |   8.7161467184143d-05, 1.2671150722720d-03, 1.0980292436099d-02,
     |   6.1571946995332d-02, 2.3483055863274d-01, 6.2389220782614d-01,
     |   1.1484959233179d+00, 1.3783372313708d+00, 8.1138680701072d-01,
     |  -3.7915718773918d-01,-1.1367224733626d+00,-6.1685613091222d-01,
     |   6.1685613091222d-01, 1.1367224733626d+00, 3.7915718773919d-01,
     |  -8.1138680701072d-01,-1.3783372313708d+00,-1.1484959233179d+00,
     |  -6.2389220782615d-01,-2.3483055863274d-01,-6.1571946995332d-02,
     |  -1.0980292436099d-02,-1.2671150722720d-03,-8.7161467184145d-05,
     |  -3.1340966761570d-06,-4.7412343991194d-08,-2.0475220262811d-10,
     |  -1.1443769696730d-13,-1.0660971480116d-18,-1.2295691028290d-29/
      data (pmn(lat,24,26), lat = 1,36)/
     |   1.3698898004045d-31, 3.5838548984252d-20, 6.4869080449035d-15,
     |   1.6542371071122d-11, 5.0478858946153d-09, 4.2116460059456d-07,
     |   1.4418999979540d-05, 2.5453040296270d-04, 2.6639540615691d-03,
     |   1.8082481842063d-02, 8.4392785360412d-02, 2.8080632624454d-01,
     |   6.7768573562093d-01, 1.1798866634917d+00, 1.4126033674211d+00,
     |   9.5269900241923d-01,-1.3011473304986d-01,-1.0764539394473d+00,
     |  -1.0764539394473d+00,-1.3011473304986d-01, 9.5269900241923d-01,
     |   1.4126033674211d+00, 1.1798866634917d+00, 6.7768573562093d-01,
     |   2.8080632624455d-01, 8.4392785360412d-02, 1.8082481842063d-02,
     |   2.6639540615692d-03, 2.5453040296270d-04, 1.4418999979540d-05,
     |   4.2116460059456d-07, 5.0478858946153d-09, 1.6542371071123d-11,
     |   6.4869080449039d-15, 3.5838548984252d-20, 1.3698898004045d-31/
      data (pmn(lat,25,26), lat = 1,36)/
     |   1.2081625853284d-33, 9.5336713179701d-22, 2.9077038351311d-16,
     |   1.0556367363495d-12, 4.2379590047805d-10, 4.4526525735925d-08,
     |   1.8706484680407d-06, 3.9920386850898d-05, 5.0149248113760d-04,
     |   4.0832441148103d-03, 2.2996586901559d-02, 9.3647504829796d-02,
     |   2.8390862710543d-01, 6.5128818455538d-01, 1.1328678036893d+00,
     |   1.4636069719019d+00, 1.2970649209663d+00, 5.2467543189960d-01,
     |  -5.2467543189960d-01,-1.2970649209663d+00,-1.4636069719019d+00,
     |  -1.1328678036893d+00,-6.5128818455538d-01,-2.8390862710543d-01,
     |  -9.3647504829797d-02,-2.2996586901559d-02,-4.0832441148103d-03,
     |  -5.0149248113760d-04,-3.9920386850898d-05,-1.8706484680407d-06,
     |  -4.4526525735925d-08,-4.2379590047805d-10,-1.0556367363495d-12,
     |  -2.9077038351313d-16,-9.5336713179701d-22,-1.2081625853284d-33/
      data (pmn(lat,26,26), lat = 1,36)/
     |   7.3150419495050d-36, 1.7405544177521d-23, 8.9393045826539d-18,
     |   4.6156739848932d-14, 2.4343296800506d-11, 3.2143548105115d-09,
     |   1.6526384127771d-07, 4.2478927438513d-06, 6.3725788221191d-05,
     |   6.1794697592535d-04, 4.1560545460558d-03, 2.0384835276743d-02,
     |   7.5631069522410d-02, 2.1804554255917d-01, 4.9825912370130d-01,
     |   9.1551941850107d-01, 1.3662524056925d+00, 1.6664640388041d+00,
     |   1.6664640388041d+00, 1.3662524056925d+00, 9.1551941850107d-01,
     |   4.9825912370130d-01, 2.1804554255917d-01, 7.5631069522409d-02,
     |   2.0384835276744d-02, 4.1560545460558d-03, 6.1794697592535d-04,
     |   6.3725788221191d-05, 4.2478927438513d-06, 1.6526384127771d-07,
     |   3.2143548105115d-09, 2.4343296800506d-11, 4.6156739848934d-14,
     |   8.9393045826544d-18, 1.7405544177521d-23, 7.3150419495050d-36/
      data (pmn(lat, 0,27), lat = 1,36)/
     |   3.5200605917745d+00,-2.0573610371856d+00, 7.9299043140852d-01,
     |   3.6569949112502d-01,-1.0795854587822d+00, 1.1584773319855d+00,
     |  -6.7507131944390d-01,-7.2898851203767d-02, 7.0440919430373d-01,
     |  -9.2894726187708d-01, 6.7134164294227d-01,-9.2075319607216d-02,
     |  -5.0250659220601d-01, 8.1437800758750d-01,-6.9780526330665d-01,
     |   2.2516521446504d-01, 3.5481448584101d-01,-7.4398463602587d-01,
     |   7.4398463602587d-01,-3.5481448584101d-01,-2.2516521446505d-01,
     |   6.9780526330665d-01,-8.1437800758750d-01, 5.0250659220601d-01,
     |   9.2075319607227d-02,-6.7134164294227d-01, 9.2894726187708d-01,
     |  -7.0440919430373d-01, 7.2898851203762d-02, 6.7507131944391d-01,
     |  -1.1584773319855d+00, 1.0795854587822d+00,-3.6569949112500d-01,
     |  -7.9299043140854d-01, 2.0573610371856d+00,-3.5200605917745d+00/
      data (pmn(lat, 1,27), lat = 1,36)/
     |   2.6130826204015d+00, 5.0321772436526d-01,-1.4581943133676d+00,
     |   1.4307406649615d+00,-7.5261572912123d-01,-1.4841166966900d-01,
     |   8.3487516973796d-01,-1.0221436892761d+00, 6.8199123662508d-01,
     |  -3.1881759424607d-02,-5.8379180672041d-01, 8.6309425210875d-01,
     |  -6.8695669745145d-01, 1.6658725682413d-01, 4.2095488725788d-01,
     |  -7.7476745180152d-01, 7.1949799078030d-01,-2.8983612797979d-01,
     |  -2.8983612797979d-01, 7.1949799078031d-01,-7.7476745180152d-01,
     |   4.2095488725788d-01, 1.6658725682413d-01,-6.8695669745144d-01,
     |   8.6309425210875d-01,-5.8379180672041d-01,-3.1881759424611d-02,
     |   6.8199123662509d-01,-1.0221436892761d+00, 8.3487516973795d-01,
     |  -1.4841166966900d-01,-7.5261572912123d-01, 1.4307406649615d+00,
     |  -1.4581943133675d+00, 5.0321772436526d-01, 2.6130826204015d+00/
      data (pmn(lat, 2,27), lat = 1,36)/
     |   8.3444948055375d-01, 2.3384890556715d+00,-1.2731175243434d+00,
     |  -3.5675448086857d-02, 9.4867566078803d-01,-1.1807779364553d+00,
     |   7.7141661857285d-01,-2.4027776200087d-02,-6.5113389776588d-01,
     |   9.2805063104116d-01,-7.0485885118094d-01, 1.3224618881406d-01,
     |   4.7712604599383d-01,-8.1043150892039d-01, 7.0839735447597d-01,
     |  -2.3797403658443d-01,-3.4838548251432d-01, 7.4404899881992d-01,
     |  -7.4404899881991d-01, 3.4838548251432d-01, 2.3797403658444d-01,
     |  -7.0839735447597d-01, 8.1043150892039d-01,-4.7712604599384d-01,
     |  -1.3224618881407d-01, 7.0485885118094d-01,-9.2805063104116d-01,
     |   6.5113389776588d-01, 2.4027776200091d-02,-7.7141661857286d-01,
     |   1.1807779364553d+00,-9.4867566078803d-01, 3.5675448086841d-02,
     |   1.2731175243434d+00,-2.3384890556715d+00,-8.3444948055375d-01/
      data (pmn(lat, 3,27), lat = 1,36)/
     |   1.7144984801446d-01, 2.0898341599752d+00, 6.2330818297262d-01,
     |  -1.4510772326267d+00, 1.0891405865325d+00,-1.8249269350530d-01,
     |  -6.6023797390399d-01, 1.0202921360213d+00,-7.8759547582174d-01,
     |   1.5617578634957d-01, 5.0634926152159d-01,-8.5308725938187d-01,
     |   7.2506379712928d-01,-2.1606181309551d-01,-3.8945258806814d-01,
     |   7.6912501407204d-01,-7.2811323230733d-01, 2.9535286313068d-01,
     |   2.9535286313068d-01,-7.2811323230733d-01, 7.6912501407204d-01,
     |  -3.8945258806814d-01,-2.1606181309551d-01, 7.2506379712928d-01,
     |  -8.5308725938187d-01, 5.0634926152159d-01, 1.5617578634957d-01,
     |  -7.8759547582175d-01, 1.0202921360213d+00,-6.6023797390398d-01,
     |  -1.8249269350530d-01, 1.0891405865325d+00,-1.4510772326267d+00,
     |   6.2330818297260d-01, 2.0898341599752d+00, 1.7144984801446d-01/
      data (pmn(lat, 4,27), lat = 1,36)/
     |   2.5983762692247d-02, 1.1438855586831d+00, 1.8967018331100d+00,
     |  -9.7653639837969d-01,-3.7409844410253d-01, 1.1084155137620d+00,
     |  -1.0024910548740d+00, 3.1661300383329d-01, 4.6468725233091d-01,
     |  -9.0030553016762d-01, 7.9316172182553d-01,-2.5232726501782d-01,
     |  -3.9601939665425d-01, 7.9400637925393d-01,-7.3825912279369d-01,
     |   2.7643908211417d-01, 3.2870150947777d-01,-7.4420656547846d-01,
     |   7.4420656547846d-01,-3.2870150947777d-01,-2.7643908211418d-01,
     |   7.3825912279369d-01,-7.9400637925393d-01, 3.9601939665426d-01,
     |   2.5232726501783d-01,-7.9316172182553d-01, 9.0030553016762d-01,
     |  -4.6468725233090d-01,-3.1661300383329d-01, 1.0024910548740d+00,
     |  -1.1084155137620d+00, 3.7409844410253d-01, 9.7653639837970d-01,
     |  -1.8967018331100d+00,-1.1438855586831d+00,-2.5983762692247d-02/
      data (pmn(lat, 5,27), lat = 1,36)/
     |   3.1139634934178d-03, 4.6098875848455d-01, 1.8961836243208d+00,
     |   5.4563431089752d-01,-1.3613692793109d+00, 8.1136232714703d-01,
     |   1.9978845455728d-01,-9.0414777559564d-01, 9.4140500609539d-01,
     |  -4.0029502089594d-01,-3.2962312818282d-01, 8.1030842557396d-01,
     |  -7.8978540051286d-01, 3.1421673075273d-01, 3.2292267850063d-01,
     |  -7.5522176294113d-01, 7.4482059130552d-01,-3.0653529568132d-01,
     |  -3.0653529568132d-01, 7.4482059130552d-01,-7.5522176294113d-01,
     |   3.2292267850062d-01, 3.1421673075273d-01,-7.8978540051286d-01,
     |   8.1030842557396d-01,-3.2962312818282d-01,-4.0029502089594d-01,
     |   9.4140500609539d-01,-9.0414777559563d-01, 1.9978845455727d-01,
     |   8.1136232714703d-01,-1.3613692793109d+00, 5.4563431089750d-01,
     |   1.8961836243208d+00, 4.6098875848455d-01, 3.1139634934178d-03/
      data (pmn(lat, 6,27), lat = 1,36)/
     |   3.0778531408065d-04, 1.4781317047183d-01, 1.2646450232665d+00,
     |   1.6254991269379d+00,-8.4311902345180d-01,-5.3756775798270d-01,
     |   1.1257614033308d+00,-7.5609731133700d-01,-8.6586355119397d-02,
     |   7.7035148615461d-01,-8.9247623924477d-01, 4.4564758606223d-01,
     |   2.4615049895825d-01,-7.5115179458511d-01, 7.8111404413899d-01,
     |  -3.4047501551958d-01,-2.9456500352605d-01, 7.4434729887506d-01,
     |  -7.4434729887506d-01, 2.9456500352605d-01, 3.4047501551959d-01,
     |  -7.8111404413899d-01, 7.5115179458511d-01,-2.4615049895825d-01,
     |  -4.4564758606224d-01, 8.9247623924477d-01,-7.7035148615461d-01,
     |   8.6586355119392d-02, 7.5609731133700d-01,-1.1257614033308d+00,
     |   5.3756775798270d-01, 8.4311902345180d-01,-1.6254991269379d+00,
     |  -1.2646450232665d+00,-1.4781317047183d-01,-3.0778531408065d-04/
      data (pmn(lat, 7,27), lat = 1,36)/
     |   2.5802918705888d-05, 3.9369002033122d-02, 6.4975034506547d-01,
     |   1.7650426233252d+00, 4.5865536447153d-01,-1.2819071655120d+00,
     |   5.9212046631028d-01, 4.6919760782619d-01,-9.9171849133326d-01,
     |   7.2065524046112d-01, 2.4836100258523d-02,-6.8958911907275d-01,
     |   8.5393985591372d-01,-4.5657443732984d-01,-2.1502150265727d-01,
     |   7.2764383363892d-01,-7.6846926664969d-01, 3.2369538070996d-01,
     |   3.2369538070996d-01,-7.6846926664969d-01, 7.2764383363892d-01,
     |  -2.1502150265727d-01,-4.5657443732984d-01, 8.5393985591372d-01,
     |  -6.8958911907274d-01, 2.4836100258523d-02, 7.2065524046113d-01,
     |  -9.9171849133326d-01, 4.6919760782619d-01, 5.9212046631029d-01,
     |  -1.2819071655120d+00, 4.5865536447153d-01, 1.7650426233252d+00,
     |   6.4975034506548d-01, 3.9369002033122d-02, 2.5802918705888d-05/
      data (pmn(lat, 8,27), lat = 1,36)/
     |   1.8714088795294d-06, 8.9516595543703d-03, 2.7362292905587d-01,
     |   1.3205095272246d+00, 1.4374323269650d+00,-7.6012667971323d-01,
     |  -6.4514830141805d-01, 1.0871804841347d+00,-4.8523595621344d-01,
     |  -4.2858779859447d-01, 9.1144105206332d-01,-6.8254655717000d-01,
     |  -1.3375089792905d-02, 6.5855358591052d-01,-8.2476079604761d-01,
     |   4.2922265455870d-01, 2.4396146342822d-01,-7.4427552316283d-01,
     |   7.4427552316283d-01,-2.4396146342822d-01,-4.2922265455871d-01,
     |   8.2476079604761d-01,-6.5855358591052d-01, 1.3375089792914d-02,
     |   6.8254655717001d-01,-9.1144105206332d-01, 4.2858779859447d-01,
     |   4.8523595621344d-01,-1.0871804841347d+00, 6.4514830141804d-01,
     |   7.6012667971323d-01,-1.4374323269650d+00,-1.3205095272246d+00,
     |  -2.7362292905587d-01,-8.9516595543703d-03,-1.8714088795294d-06/
      data (pmn(lat, 9,27), lat = 1,36)/
     |   1.1913955176585d-07, 1.7706226262106d-03, 9.7767583286919d-02,
     |   7.7662196974804d-01, 1.6590358461037d+00, 4.0350554575993d-01,
     |  -1.2185384105282d+00, 3.9213485411522d-01, 6.7928970259042d-01,
     |  -9.6929674105016d-01, 4.0273441234524d-01, 4.3158954795682d-01,
     |  -8.6812928847147d-01, 6.2876480215054d-01, 5.8432070563422d-02,
     |  -6.7789077595070d-01, 7.9705433807658d-01,-3.4733951680049d-01,
     |  -3.4733951680049d-01, 7.9705433807658d-01,-6.7789077595069d-01,
     |   5.8432070563420d-02, 6.2876480215054d-01,-8.6812928847148d-01,
     |   4.3158954795681d-01, 4.0273441234524d-01,-9.6929674105016d-01,
     |   6.7928970259042d-01, 3.9213485411523d-01,-1.2185384105282d+00,
     |   4.0350554575993d-01, 1.6590358461037d+00, 7.7662196974805d-01,
     |   9.7767583286921d-02, 1.7706226262106d-03, 1.1913955176585d-07/
      data (pmn(lat,10,27), lat = 1,36)/
     |   6.7309465194608d-09, 3.0881485404396d-04, 3.0296113552806d-02,
     |   3.7976313940725d-01, 1.3368892922455d+00, 1.3109702390301d+00,
     |  -6.8028821608067d-01,-7.4533094014476d-01, 1.0088059317886d+00,
     |  -1.8516378650239d-01,-7.0813236971322d-01, 8.8348439442536d-01,
     |  -3.0165282166075d-01,-4.8573838799466d-01, 8.4868207897041d-01,
     |  -5.3980578601099d-01,-1.7404614659434d-01, 7.4368875388472d-01,
     |  -7.4368875388472d-01, 1.7404614659434d-01, 5.3980578601100d-01,
     |  -8.4868207897041d-01, 4.8573838799466d-01, 3.0165282166074d-01,
     |  -8.8348439442537d-01, 7.0813236971322d-01, 1.8516378650239d-01,
     |  -1.0088059317886d+00, 7.4533094014476d-01, 6.8028821608068d-01,
     |  -1.3109702390301d+00,-1.3368892922455d+00,-3.7976313940725d-01,
     |  -3.0296113552807d-02,-3.0881485404396d-04,-6.7309465194608d-09/
      data (pmn(lat,11,27), lat = 1,36)/
     |   3.4028605077926d-10, 4.7969517607228d-05, 8.2644280766193d-03,
     |   1.5922045979168d-01, 8.5519255518313d-01, 1.5719592730790d+00,
     |   3.9698649777926d-01,-1.1624914366768d+00, 1.7657630130905d-01,
     |   8.5067436415577d-01,-8.3649258003044d-01, 4.6745819009574d-03,
     |   7.5789972531442d-01,-7.9674552552638d-01, 1.5123282342652d-01,
     |   5.9413576857544d-01,-8.2732907158896d-01, 3.7822572667543d-01,
     |   3.7822572667543d-01,-8.2732907158896d-01, 5.9413576857544d-01,
     |   1.5123282342652d-01,-7.9674552552638d-01, 7.5789972531442d-01,
     |   4.6745819009680d-03,-8.3649258003044d-01, 8.5067436415576d-01,
     |   1.7657630130905d-01,-1.1624914366768d+00, 3.9698649777925d-01,
     |   1.5719592730790d+00, 8.5519255518313d-01, 1.5922045979168d-01,
     |   8.2644280766195d-03, 4.7969517607228d-05, 3.4028605077926d-10/
      data (pmn(lat,12,27), lat = 1,36)/
     |   1.5492313864134d-11, 6.6861716904923d-06, 2.0057368888895d-03,
     |   5.8341090486993d-02, 4.5806649421405d-01, 1.3255893045109d+00,
     |   1.2409825213224d+00,-5.7590159175584d-01,-8.5672419263374d-01,
     |   8.7490855097556d-01, 1.5521519608109d-01,-8.9630096169374d-01,
     |   6.5439555599339d-01, 2.0357423191963d-01,-8.2151811731999d-01,
     |   6.6524272790035d-01, 8.1161373752103d-02,-7.4214140452878d-01,
     |   7.4214140452878d-01,-8.1161373752101d-02,-6.6524272790035d-01,
     |   8.2151811731998d-01,-2.0357423191963d-01,-6.5439555599338d-01,
     |   8.9630096169373d-01,-1.5521519608109d-01,-8.7490855097557d-01,
     |   8.5672419263374d-01, 5.7590159175584d-01,-1.2409825213224d+00,
     |  -1.3255893045109d+00,-4.5806649421405d-01,-5.8341090486994d-02,
     |  -2.0057368888895d-03,-6.6861716904923d-06,-1.5492313864134d-11/
      data (pmn(lat,13,27), lat = 1,36)/
     |   6.3821312878827d-13, 8.4091885219011d-07, 4.3640596682036d-04,
     |   1.8922201042856d-02, 2.1139851926332d-01, 8.9189475843564d-01,
     |   1.5037473554084d+00, 4.5014751394785d-01,-1.0961337617312d+00,
     |  -8.2012806933579d-02, 9.6975288161077d-01,-5.6423716643260d-01,
     |  -4.3913499758588d-01, 8.9514372944980d-01,-4.0801815015572d-01,
     |  -4.6140092989243d-01, 8.5418263079053d-01,-4.1746400033260d-01,
     |  -4.1746400033261d-01, 8.5418263079053d-01,-4.6140092989243d-01,
     |  -4.0801815015573d-01, 8.9514372944980d-01,-4.3913499758589d-01,
     |  -5.6423716643261d-01, 9.6975288161077d-01,-8.2012806933576d-02,
     |  -1.0961337617312d+00, 4.5014751394785d-01, 1.5037473554084d+00,
     |   8.9189475843564d-01, 2.1139851926332d-01, 1.8922201042856d-02,
     |   4.3640596682038d-04, 8.4091885219011d-07, 6.3821312878827d-13/
      data (pmn(lat,14,27), lat = 1,36)/
     |   2.3872382915215d-14, 9.5818322419594d-08, 8.5593870715230d-05,
     |   5.4800801799088d-03, 8.5527726760976d-02, 5.0404196282822d-01,
     |   1.2927853018978d+00, 1.2254370792069d+00,-4.2224834007659d-01,
     |  -9.7605928748172d-01, 6.4883894410084d-01, 5.2628420874778d-01,
     |  -9.1713244062966d-01, 1.9424450530742d-01, 7.0030702118054d-01,
     |  -7.9114953434198d-01, 3.9059440080479d-02, 7.3898319387741d-01,
     |  -7.3898319387741d-01,-3.9059440080481d-02, 7.9114953434198d-01,
     |  -7.0030702118054d-01,-1.9424450530742d-01, 9.1713244062966d-01,
     |  -5.2628420874778d-01,-6.4883894410084d-01, 9.7605928748171d-01,
     |   4.2224834007659d-01,-1.2254370792069d+00,-1.2927853018978d+00,
     |  -5.0404196282822d-01,-8.5527726760976d-02,-5.4800801799088d-03,
     |  -8.5593870715233d-05,-9.5818322419594d-08,-2.3872382915215d-14/
      data (pmn(lat,15,27), lat = 1,36)/
     |   8.1266123596074d-16, 9.9185820885100d-09, 1.5190380819440d-05,
     |   1.4256610408860d-03, 3.0674197118408d-02, 2.4577245744650d-01,
     |   8.8982549124012d-01, 1.4521474789475d+00, 5.7171279170282d-01,
     |  -9.8765288584961d-01,-3.9771318376429d-01, 9.8028639729450d-01,
     |  -1.2184391663894d-01,-8.2139636702083d-01, 6.8293878996590d-01,
     |   2.6291149201952d-01,-8.6964899932417d-01, 4.6669683296023d-01,
     |   4.6669683296023d-01,-8.6964899932417d-01, 2.6291149201952d-01,
     |   6.8293878996590d-01,-8.2139636702083d-01,-1.2184391663893d-01,
     |   9.8028639729450d-01,-3.9771318376429d-01,-9.8765288584962d-01,
     |   5.7171279170282d-01, 1.4521474789475d+00, 8.8982549124012d-01,
     |   2.4577245744650d-01, 3.0674197118408d-02, 1.4256610408861d-03,
     |   1.5190380819440d-05, 9.9185820885100d-09, 8.1266123596074d-16/
      data (pmn(lat,16,27), lat = 1,36)/
     |   2.5208455046032d-17, 9.3419355628502d-10, 2.4450116127963d-06,
     |   3.3446119284946d-04, 9.8225758740690d-03, 1.0503631371008d-01,
     |   5.1481437963685d-01, 1.2387905765211d+00, 1.2583394257334d+00,
     |  -1.9120246254976d-01,-1.0704728885061d+00, 2.8341028621469d-01,
     |   8.5964886143573d-01,-6.4914973751520d-01,-4.3599624586014d-01,
     |   8.9080020516781d-01,-1.9138501657030d-01,-7.3325112267347d-01,
     |   7.3325112267346d-01, 1.9138501657031d-01,-8.9080020516782d-01,
     |   4.3599624586014d-01, 6.4914973751520d-01,-8.5964886143573d-01,
     |  -2.8341028621470d-01, 1.0704728885061d+00, 1.9120246254976d-01,
     |  -1.2583394257334d+00,-1.2387905765211d+00,-5.1481437963686d-01,
     |  -1.0503631371008d-01,-9.8225758740690d-03,-3.3446119284946d-04,
     |  -2.4450116127964d-06,-9.3419355628502d-10,-2.5208455046032d-17/
      data (pmn(lat,17,27), lat = 1,36)/
     |   7.1266881712624d-19, 8.0094141258427d-11, 3.5729035922588d-07,
     |   7.0909938781506d-05, 2.8208023862691d-03, 3.9720689236231d-02,
     |   2.5664295351998d-01, 8.4886800911699d-01, 1.4071250101938d+00,
     |   7.6493672733439d-01,-7.8411730536191d-01,-7.4955245149739d-01,
     |   7.7672352973600d-01, 4.5700757846668d-01,-9.0510900003854d-01,
     |   1.5788171181644d-02, 8.6128844304011d-01,-5.2844436779883d-01,
     |  -5.2844436779884d-01, 8.6128844304011d-01, 1.5788171181651d-02,
     |  -9.0510900003854d-01, 4.5700757846668d-01, 7.7672352973600d-01,
     |  -7.4955245149739d-01,-7.8411730536191d-01, 7.6493672733439d-01,
     |   1.4071250101938d+00, 8.4886800911699d-01, 2.5664295351998d-01,
     |   3.9720689236231d-02, 2.8208023862691d-03, 7.0909938781507d-05,
     |   3.5729035922590d-07, 8.0094141258427d-11, 7.1266881712624d-19/
      data (pmn(lat,18,27), lat = 1,36)/
     |   1.8345745241195d-20, 6.2463672530138d-12, 4.7388175820728d-08,
     |   1.3593983084556d-05, 7.2803665223632d-04, 1.3364038035426d-02,
     |   1.1176722572329d-01, 4.8835917163189d-01, 1.1562226903564d+00,
     |   1.3217360980424d+00, 1.4582780821286d-01,-1.0592753678591d+00,
     |  -2.4347232375002d-01, 9.7663001959658d-01,-5.2323461161763d-03,
     |  -9.1822997696589d-01, 3.8022341735390d-01, 7.2346752562550d-01,
     |  -7.2346752562550d-01,-3.8022341735390d-01, 9.1822997696589d-01,
     |   5.2323461161784d-03,-9.7663001959658d-01, 2.4347232375002d-01,
     |   1.0592753678591d+00,-1.4582780821286d-01,-1.3217360980424d+00,
     |  -1.1562226903564d+00,-4.8835917163189d-01,-1.1176722572329d-01,
     |  -1.3364038035426d-02,-7.2803665223632d-04,-1.3593983084556d-05,
     |  -4.7388175820730d-08,-6.2463672530138d-12,-1.8345745241195d-20/
      data (pmn(lat,19,27), lat = 1,36)/
     |   4.2909155003961d-22, 4.4222750235585d-13, 5.6951834038185d-09,
     |   2.3541006576154d-06, 1.6890162561729d-04, 4.0100159483303d-03,
     |   4.2836768410414d-02, 2.4105307625005d-01, 7.6547019378976d-01,
     |   1.3453866794243d+00, 1.0154796375113d+00,-4.1252162786244d-01,
     |  -1.0340382731112d+00, 2.3927901187566d-01, 9.4072245136341d-01,
     |  -3.7663154919789d-01,-8.0938860974630d-01, 6.0682881277289d-01,
     |   6.0682881277290d-01,-8.0938860974630d-01,-3.7663154919790d-01,
     |   9.4072245136341d-01, 2.3927901187566d-01,-1.0340382731112d+00,
     |  -4.1252162786245d-01, 1.0154796375113d+00, 1.3453866794243d+00,
     |   7.6547019378976d-01, 2.4105307625005d-01, 4.2836768410414d-02,
     |   4.0100159483303d-03, 1.6890162561729d-04, 2.3541006576155d-06,
     |   5.6951834038188d-09, 4.4222750235585d-13, 4.2909155003961d-22/
      data (pmn(lat,20,27), lat = 1,36)/
     |   9.0853709280589d-24, 2.8321813248565d-14, 6.1818886409064d-10,
     |   3.6723714196555d-07, 3.5156002178466d-05, 1.0728056366767d-03,
     |   1.4491631898215d-02, 1.0318994541986d-01, 4.2382055509637d-01,
     |   1.0290386428118d+00, 1.3739887552703d+00, 5.9649490497059d-01,
     |  -7.9940039272885d-01,-8.3056237283111d-01, 5.8675446361753d-01,
     |   7.9988380047867d-01,-6.0779628676791d-01,-7.0722425914392d-01,
     |   7.0722425914392d-01, 6.0779628676791d-01,-7.9988380047866d-01,
     |  -5.8675446361753d-01, 8.3056237283111d-01, 7.9940039272885d-01,
     |  -5.9649490497059d-01,-1.3739887552703d+00,-1.0290386428118d+00,
     |  -4.2382055509637d-01,-1.0318994541986d-01,-1.4491631898215d-02,
     |  -1.0728056366767d-03,-3.5156002178466d-05,-3.6723714196556d-07,
     |  -6.1818886409067d-10,-2.8321813248565d-14,-9.0853709280589d-24/
      data (pmn(lat,21,27), lat = 1,36)/
     |   1.7317607089756d-25, 1.6318200850445d-15, 6.0287447199063d-11,
     |   5.1357093115306d-08, 6.5378001772796d-06, 2.5512529958781d-04,
     |   4.3237946810299d-03, 3.8460774105927d-02, 1.9954614348543d-01,
     |   6.3444625119649d-01, 1.2264426647206d+00, 1.2656341802103d+00,
     |   1.8576266241887d-01,-1.0038568579391d+00,-5.9143410645624d-01,
     |   7.8538557948589d-01, 6.8159875066636d-01,-7.0931563578467d-01,
     |  -7.0931563578468d-01, 6.8159875066636d-01, 7.8538557948590d-01,
     |  -5.9143410645624d-01,-1.0038568579391d+00, 1.8576266241887d-01,
     |   1.2656341802103d+00, 1.2264426647206d+00, 6.3444625119649d-01,
     |   1.9954614348543d-01, 3.8460774105927d-02, 4.3237946810300d-03,
     |   2.5512529958781d-04, 6.5378001772796d-06, 5.1357093115307d-08,
     |   6.0287447199066d-11, 1.6318200850445d-15, 1.7317607089756d-25/
      data (pmn(lat,22,27), lat = 1,36)/
     |   2.9471637715963d-27, 8.3898582026846d-17, 5.2403437231149d-12,
     |   6.3893982605218d-09, 1.0785314166040d-06, 5.3595754886706d-05,
     |   1.1324761970088d-03, 1.2461221336652d-02, 8.0333338225179d-02,
     |   3.2395382439484d-01, 8.3631630323520d-01, 1.3373385526114d+00,
     |   1.0914653312619d+00,-1.3061656121526d-01,-1.0840439753927d+00,
     |  -4.2861690727775d-01, 8.6956451001385d-01, 6.8019533337071d-01,
     |  -6.8019533337070d-01,-8.6956451001385d-01, 4.2861690727775d-01,
     |   1.0840439753927d+00, 1.3061656121527d-01,-1.0914653312619d+00,
     |  -1.3373385526114d+00,-8.3631630323520d-01,-3.2395382439484d-01,
     |  -8.0333338225179d-02,-1.2461221336652d-02,-1.1324761970088d-03,
     |  -5.3595754886706d-05,-1.0785314166040d-06,-6.3893982605220d-09,
     |  -5.2403437231152d-12,-8.3898582026846d-17,-2.9471637715963d-27/
      data (pmn(lat,23,27), lat = 1,36)/
     |   4.4237039916901d-29, 3.8027055806465d-18, 4.0115307302720d-13,
     |   6.9892105229420d-10, 1.5605880146883d-07, 9.8408693415641d-06,
     |   2.5792506016922d-04, 3.4839072596777d-03, 2.7569267582552d-02,
     |   1.3805671888150d-01, 4.5580589443912d-01, 9.9839137486598d-01,
     |   1.3796886469234d+00, 9.3805936616465d-01,-3.0978422496326d-01,
     |  -1.1161277340682d+00,-4.2057338496389d-01, 8.5185057925495d-01,
     |   8.5185057925495d-01,-4.2057338496388d-01,-1.1161277340682d+00,
     |  -3.0978422496327d-01, 9.3805936616465d-01, 1.3796886469234d+00,
     |   9.9839137486598d-01, 4.5580589443912d-01, 1.3805671888150d-01,
     |   2.7569267582552d-02, 3.4839072596777d-03, 2.5792506016922d-04,
     |   9.8408693415641d-06, 1.5605880146883d-07, 6.9892105229422d-10,
     |   4.0115307302722d-13, 3.8027055806465d-18, 4.4237039916901d-29/
      data (pmn(lat,24,27), lat = 1,36)/
     |   5.7478686597947d-31, 1.4913705108302d-19, 2.6547990037798d-14,
     |   6.6001111167725d-11, 1.9453225062046d-08, 1.5519918672780d-06,
     |   5.0241801997568d-05, 8.2793956306578d-04, 7.9676563790974d-03,
     |   4.8806857159948d-02, 2.0060956737946d-01, 5.6801743520560d-01,
     |   1.1048600899951d+00, 1.3959985253036d+00, 8.8548174732915d-01,
     |  -3.2242789523529d-01,-1.1409496688782d+00,-6.3320476074898d-01,
     |   6.3320476074898d-01, 1.1409496688782d+00, 3.2242789523530d-01,
     |  -8.8548174732915d-01,-1.3959985253036d+00,-1.1048600899951d+00,
     |  -5.6801743520561d-01,-2.0060956737946d-01,-4.8806857159948d-02,
     |  -7.9676563790975d-03,-8.2793956306579d-04,-5.0241801997569d-05,
     |  -1.5519918672780d-06,-1.9453225062046d-08,-6.6001111167727d-11,
     |  -2.6547990037800d-14,-1.4913705108302d-19,-5.7478686597947d-31/
      data (pmn(lat,25,27), lat = 1,36)/
     |   6.2694002383301d-33, 4.9081072508673d-21, 1.4731639843221d-15,
     |   5.2195493035471d-12, 2.0270612272247d-09, 2.0408385091586d-07,
     |   8.1310850735824d-06, 1.6264696193418d-04, 1.8895372100154d-03,
     |   1.4000916632179d-02, 7.0342707875461d-02, 2.4897811452785d-01,
     |   6.3262509852581d-01, 1.1495140126960d+00, 1.4272051989974d+00,
     |   1.0016357552882d+00,-9.6320004776409d-02,-1.0803752941307d+00,
     |  -1.0803752941307d+00,-9.6320004776410d-02, 1.0016357552882d+00,
     |   1.4272051989974d+00, 1.1495140126960d+00, 6.3262509852581d-01,
     |   2.4897811452786d-01, 7.0342707875461d-02, 1.4000916632179d-02,
     |   1.8895372100155d-03, 1.6264696193418d-04, 8.1310850735825d-06,
     |   2.0408385091586d-07, 2.0270612272247d-09, 5.2195493035472d-12,
     |   1.4731639843222d-15, 4.9081072508673d-21, 6.2694002383301d-33/
      data (pmn(lat,26,27), lat = 1,36)/
     |   5.4198169247239d-35, 1.2797864769038d-22, 6.4724185337176d-17,
     |   3.2646450730775d-13, 1.6679233354977d-10, 2.1144824386238d-08,
     |   1.0336853935757d-06, 2.4993181437478d-05, 3.4843955065629d-04,
     |   3.0961065776221d-03, 1.8763321125960d-02, 8.1227871883509d-02,
     |   2.5899249921131d-01, 6.1882552403370d-01, 1.1111646300660d+00,
     |   1.4695543601065d+00, 1.3225434626684d+00, 5.3908450955049d-01,
     |  -5.3908450955048d-01,-1.3225434626684d+00,-1.4695543601065d+00,
     |  -1.1111646300660d+00,-6.1882552403370d-01,-2.5899249921131d-01,
     |  -8.1227871883510d-02,-1.8763321125960d-02,-3.0961065776221d-03,
     |  -3.4843955065630d-04,-2.4993181437478d-05,-1.0336853935757d-06,
     |  -2.1144824386238d-08,-1.6679233354977d-10,-3.2646450730776d-13,
     |  -6.4724185337180d-17,-1.2797864769038d-22,-5.4198169247239d-35/
      data (pmn(lat,27,27), lat = 1,36)/
     |   3.2201851837665d-37, 2.2928188283481d-24, 1.9526524487314d-18,
     |   1.4007524637785d-14, 9.4016378798510d-12, 1.4979036481113d-09,
     |   8.9614612624030d-08, 2.6097874314348d-06, 4.3449324288549d-05,
     |   4.5979745214697d-04, 3.3276095211479d-03, 1.7350854306310d-02,
     |   6.7703891319997d-02, 2.0330451505481d-01, 4.7957797138093d-01,
     |   9.0205608035386d-01, 1.3670486510396d+00, 1.6802227557682d+00,
     |   1.6802227557682d+00, 1.3670486510396d+00, 9.0205608035386d-01,
     |   4.7957797138093d-01, 2.0330451505481d-01, 6.7703891319996d-02,
     |   1.7350854306310d-02, 3.3276095211479d-03, 4.5979745214697d-04,
     |   4.3449324288550d-05, 2.6097874314348d-06, 8.9614612624031d-08,
     |   1.4979036481113d-09, 9.4016378798510d-12, 1.4007524637785d-14,
     |   1.9526524487316d-18, 2.2928188283481d-24, 3.2201851837665d-37/
      data (pmn(lat, 0,28), lat = 1,36)/
     |   3.4661354706416d+00,-2.1421771822774d+00, 1.1036524710739d+00,
     |  -7.5033785326940d-02,-7.2745960603454d-01, 1.1146050523816d+00,
     |  -1.0280411845822d+00, 5.6316289876584d-01, 6.8106270215395d-02,
     |  -6.1539840352779d-01, 8.7905399928410d-01,-7.7805342392959d-01,
     |   3.7292735322795d-01, 1.6340814053653d-01,-6.1495663049496d-01,
     |   8.0576958950936d-01,-6.6596383149876d-01, 2.5642931529743d-01,
     |   2.5642931529743d-01,-6.6596383149876d-01, 8.0576958950936d-01,
     |  -6.1495663049496d-01, 1.6340814053653d-01, 3.7292735322794d-01,
     |  -7.7805342392960d-01, 8.7905399928410d-01,-6.1539840352779d-01,
     |   6.8106270215390d-02, 5.6316289876584d-01,-1.0280411845822d+00,
     |   1.1146050523816d+00,-7.2745960603454d-01,-7.5033785326957d-02,
     |   1.1036524710739d+00,-2.1421771822774d+00, 3.4661354706416d+00/
      data (pmn(lat, 1,28), lat = 1,36)/
     |   2.7179484416944d+00, 2.2145235988757d-01,-1.2267260365169d+00,
     |   1.4503560364060d+00,-1.0962798092789d+00, 4.0578182318621d-01,
     |   3.2882604817958d-01,-8.4095022781438d-01, 9.6995205163148d-01,
     |  -7.0626394108481d-01, 1.8368270089508d-01, 3.7784669448172d-01,
     |  -7.5745162054099d-01, 8.1524405241812d-01,-5.4137573449007d-01,
     |   5.5176515821732d-02, 4.4413922420218d-01,-7.5592804752617d-01,
     |   7.5592804752617d-01,-4.4413922420218d-01,-5.5176515821741d-02,
     |   5.4137573449007d-01,-8.1524405241812d-01, 7.5745162054100d-01,
     |  -3.7784669448171d-01,-1.8368270089508d-01, 7.0626394108481d-01,
     |  -9.6995205163148d-01, 8.4095022781438d-01,-3.2882604817957d-01,
     |  -4.0578182318621d-01, 1.0962798092789d+00,-1.4503560364060d+00,
     |   1.2267260365169d+00,-2.2145235988757d-01,-2.7179484416944d+00/
      data (pmn(lat, 2,28), lat = 1,36)/
     |   9.0416019833979d-01, 2.2630259904091d+00,-1.4938621311101d+00,
     |   3.9837731297414d-01, 5.4236929501548d-01,-1.0612026092897d+00,
     |   1.0655811598301d+00,-6.4087308510907d-01, 6.1946866452860d-03,
     |   5.7067909729173d-01,-8.7023399858653d-01, 7.9592910986209d-01,
     |  -4.0109635921607d-01,-1.3987966161920d-01, 6.0372013828054d-01,
     |  -8.0590415230961d-01, 6.7089449817627d-01,-2.5906502156712d-01,
     |  -2.5906502156713d-01, 6.7089449817627d-01,-8.0590415230961d-01,
     |   6.0372013828054d-01,-1.3987966161920d-01,-4.0109635921607d-01,
     |   7.9592910986209d-01,-8.7023399858653d-01, 5.7067909729173d-01,
     |   6.1946866452915d-03,-6.4087308510907d-01, 1.0655811598301d+00,
     |  -1.0612026092897d+00, 5.4236929501548d-01, 3.9837731297415d-01,
     |  -1.4938621311101d+00, 2.2630259904091d+00, 9.0416019833979d-01/
      data (pmn(lat, 3,28), lat = 1,36)/
     |   1.9304322639458d-01, 2.1998804214488d+00, 2.8036948160402d-01,
     |  -1.2759321329220d+00, 1.2834826702344d+00,-6.9400710010712d-01,
     |  -9.3977837597433d-02, 7.2535941831251d-01,-9.7140341414460d-01,
     |   7.8169213022949d-01,-2.7822045567446d-01,-3.0734102235325d-01,
     |   7.2991050704778d-01,-8.2542789215588d-01, 5.6953692112130d-01,
     |  -8.0486036228951d-02,-4.3279548992176d-01, 7.5620782284022d-01,
     |  -7.5620782284022d-01, 4.3279548992175d-01, 8.0486036228960d-02,
     |  -5.6953692112130d-01, 8.2542789215588d-01,-7.2991050704778d-01,
     |   3.0734102235324d-01, 2.7822045567446d-01,-7.8169213022949d-01,
     |   9.7140341414460d-01,-7.2535941831250d-01, 9.3977837597420d-02,
     |   6.9400710010712d-01,-1.2834826702344d+00, 1.2759321329220d+00,
     |  -2.8036948160400d-01,-2.1998804214488d+00,-1.9304322639458d-01/
      data (pmn(lat, 4,28), lat = 1,36)/
     |   3.0379674670733d-02, 1.2731769366661d+00, 1.7677296098441d+00,
     |  -1.2583115667753d+00, 1.1291321039602d-01, 7.8236551052762d-01,
     |  -1.1008624210359d+00, 8.4380172408821d-01,-2.3109921346391d-01,
     |  -4.2086733166528d-01, 8.2820404697173d-01,-8.4044325953252d-01,
     |   4.8320090990843d-01, 6.7874560822853d-02,-5.6788639785111d-01,
     |   8.0513550676002d-01,-6.8549264078318d-01, 2.6703861026586d-01,
     |   2.6703861026586d-01,-6.8549264078318d-01, 8.0513550676002d-01,
     |  -5.6788639785111d-01, 6.7874560822850d-02, 4.8320090990842d-01,
     |  -8.4044325953253d-01, 8.2820404697173d-01,-4.2086733166528d-01,
     |  -2.3109921346391d-01, 8.4380172408822d-01,-1.1008624210359d+00,
     |   7.8236551052762d-01, 1.1291321039602d-01,-1.2583115667753d+00,
     |   1.7677296098441d+00, 1.2731769366661d+00, 3.0379674670733d-02/
      data (pmn(lat, 5,28), lat = 1,36)/
     |   3.7802118329122d-03, 5.3811495065971d-01, 1.9848864954812d+00,
     |   1.4788934693397d-01,-1.2124582305094d+00, 1.1247320773452d+00,
     |  -3.9676540557855d-01,-4.1641482716030d-01, 9.0460471843069d-01,
     |  -8.9525905529425d-01, 4.6027509544751d-01, 1.5668637974229d-01,
     |  -6.6208341796882d-01, 8.3757830552846d-01,-6.2330536738340d-01,
     |   1.3163164441583d-01, 4.0932158524911d-01,-7.5670313716957d-01,
     |   7.5670313716957d-01,-4.0932158524911d-01,-1.3163164441584d-01,
     |   6.2330536738340d-01,-8.3757830552846d-01, 6.6208341796882d-01,
     |  -1.5668637974228d-01,-4.6027509544751d-01, 8.9525905529425d-01,
     |  -9.0460471843069d-01, 4.1641482716029d-01, 3.9676540557856d-01,
     |  -1.1247320773452d+00, 1.2124582305094d+00,-1.4788934693396d-01,
     |  -1.9848864954812d+00,-5.3811495065971d-01,-3.7802118329122d-03/
      data (pmn(lat, 6,28), lat = 1,36)/
     |   3.8803190902683d-04, 1.8035567394653d-01, 1.4226773344096d+00,
     |   1.4340616591130d+00,-1.1603735294139d+00,-1.4726472225136d-02,
     |   8.8516709448159d-01,-1.0432425559920d+00, 5.8559514350647d-01,
     |   1.3019183775735d-01,-7.0718520006002d-01, 8.8149550973221d-01,
     |  -6.0953035504740d-01, 5.5757002552273d-02, 5.0122778609423d-01,
     |  -7.9983160513095d-01, 7.0913204716548d-01,-2.8055509229370d-01,
     |  -2.8055509229370d-01, 7.0913204716548d-01,-7.9983160513094d-01,
     |   5.0122778609423d-01, 5.5757002552276d-02,-6.0953035504739d-01,
     |   8.8149550973222d-01,-7.0718520006002d-01, 1.3019183775735d-01,
     |   5.8559514350648d-01,-1.0432425559920d+00, 8.8516709448158d-01,
     |  -1.4726472225136d-02,-1.1603735294139d+00, 1.4340616591130d+00,
     |   1.4226773344096d+00, 1.8035567394653d-01, 3.8803190902683d-04/
      data (pmn(lat, 7,28), lat = 1,36)/
     |   3.3798304632077d-05, 5.0137539922157d-02, 7.7486046159169d-01,
     |   1.8178587622534d+00, 1.0408587360747d-02,-1.1456960438151d+00,
     |   1.0007058492582d+00,-1.6830334619848d-01,-6.3526270541027d-01,
     |   9.5379891125608d-01,-6.9851343724168d-01, 8.4950322194481d-02,
     |   5.3000557126842d-01,-8.3409209276116d-01, 6.9648640288142d-01,
     |  -2.0933471812656d-01,-3.7212567320065d-01, 7.5727952008767d-01,
     |  -7.5727952008767d-01, 3.7212567320065d-01, 2.0933471812657d-01,
     |  -6.9648640288142d-01, 8.3409209276116d-01,-5.3000557126843d-01,
     |  -8.4950322194493d-02, 6.9851343724168d-01,-9.5379891125608d-01,
     |   6.3526270541027d-01, 1.6830334619849d-01,-1.0007058492582d+00,
     |   1.1456960438151d+00,-1.0408587360747d-02,-1.8178587622534d+00,
     |  -7.7486046159170d-01,-5.0137539922157d-02,-3.3798304632077d-05/
      data (pmn(lat, 8,28), lat = 1,36)/
     |   2.5484117845844d-06, 1.1892406077090d-02, 3.4386344316905d-01,
     |   1.4883756165351d+00, 1.1838632752029d+00,-1.1057616839428d+00,
     |  -9.3516567747028d-02, 9.4117686680465d-01,-9.4398702695639d-01,
     |   3.1362502798443d-01, 4.4079133462926d-01,-8.6206385312476d-01,
     |   7.5563141894217d-01,-2.3218694952197d-01,-3.9403197597271d-01,
     |   7.8357348541460d-01,-7.4061310043873d-01, 2.9997603763503d-01,
     |   2.9997603763503d-01,-7.4061310043873d-01, 7.8357348541460d-01,
     |  -3.9403197597271d-01,-2.3218694952197d-01, 7.5563141894217d-01,
     |  -8.6206385312475d-01, 4.4079133462926d-01, 3.1362502798444d-01,
     |  -9.4398702695640d-01, 9.4117686680465d-01,-9.3516567747017d-02,
     |  -1.1057616839428d+00, 1.1838632752029d+00, 1.4883756165351d+00,
     |   3.4386344316905d-01, 1.1892406077090d-02, 2.5484117845844d-06/
      data (pmn(lat, 9,28), lat = 1,36)/
     |   1.6880088556411d-07, 2.4539349171199d-03, 1.2910162189186d-01,
     |   9.3907263956761d-01, 1.6705322977361d+00,-9.1348278773939d-02,
     |  -1.0978051056431d+00, 8.9154426710162d-01, 3.6170336253432d-02,
     |  -7.9502374379989d-01, 9.0496250309350d-01,-4.0888489164997d-01,
     |  -3.0434337170347d-01, 7.8649367949383d-01,-7.7704887988231d-01,
     |   3.1375938708174d-01, 3.1877830255933d-01,-7.5771912083189d-01,
     |   7.5771912083189d-01,-3.1877830255933d-01,-3.1375938708174d-01,
     |   7.7704887988231d-01,-7.8649367949383d-01, 3.0434337170348d-01,
     |   4.0888489164998d-01,-9.0496250309350d-01, 7.9502374379989d-01,
     |  -3.6170336253427d-02,-8.9154426710162d-01, 1.0978051056431d+00,
     |   9.1348278773939d-02,-1.6705322977361d+00,-9.3907263956761d-01,
     |  -1.2910162189186d-01,-2.4539349171199d-03,-1.6880088556411d-07/
      data (pmn(lat,10,28), lat = 1,36)/
     |   9.9319052738043d-09, 4.4668051602641d-04, 4.1980525583652d-02,
     |   4.8835950759166d-01, 1.5031537616200d+00, 1.0019092176061d+00,
     |  -1.0596863539252d+00,-1.7450214925047d-01, 9.8212432748573d-01,
     |  -8.0552911798833d-01, 1.8921360728512d-02, 6.9824490470341d-01,
     |  -8.7112419181552d-01, 4.5329795393178d-01, 2.3478856659858d-01,
     |  -7.4668411490828d-01, 7.7790222885734d-01,-3.2585414307670d-01,
     |  -3.2585414307671d-01, 7.7790222885734d-01,-7.4668411490828d-01,
     |   2.3478856659858d-01, 4.5329795393178d-01,-8.7112419181552d-01,
     |   6.9824490470341d-01, 1.8921360728512d-02,-8.0552911798833d-01,
     |   9.8212432748573d-01,-1.7450214925046d-01,-1.0596863539252d+00,
     |   1.0019092176061d+00, 1.5031537616200d+00, 4.8835950759166d-01,
     |   4.1980525583653d-02, 4.4668051602641d-04, 9.9319052738043d-09/
      data (pmn(lat,11,28), lat = 1,36)/
     |   5.2352958891122d-10, 7.2470808642885d-05, 1.2012336388782d-02,
     |   2.1681722027744d-01, 1.0451439664506d+00, 1.5454648337678d+00,
     |  -1.4226688055866d-01,-1.0758201332525d+00, 7.7236819255548d-01,
     |   2.4908981379735d-01,-9.0680358499596d-01, 7.5044988940397d-01,
     |  -3.3660598518814d-02,-6.5588609088220d-01, 8.4392076804089d-01,
     |  -4.4315249121681d-01,-2.4598099408899d-01, 7.5769769309312d-01,
     |  -7.5769769309312d-01, 2.4598099408898d-01, 4.4315249121682d-01,
     |  -8.4392076804089d-01, 6.5588609088220d-01, 3.3660598518806d-02,
     |  -7.5044988940397d-01, 9.0680358499596d-01,-2.4908981379735d-01,
     |  -7.7236819255549d-01, 1.0758201332525d+00, 1.4226688055867d-01,
     |  -1.5454648337678d+00,-1.0451439664506d+00,-2.1681722027745d-01,
     |  -1.2012336388783d-02,-7.2470808642885d-05,-5.2352958891122d-10/
      data (pmn(lat,12,28), lat = 1,36)/
     |   2.4885720286554d-11, 1.0561999035270d-05, 3.0588621045766d-03,
     |   8.3952637764272d-02, 6.0145135734924d-01, 1.4866833720230d+00,
     |   8.8829023945216d-01,-1.0055413486798d+00,-2.8676967290103d-01,
     |   1.0110207022814d+00,-6.0625720814555d-01,-3.0610459794151d-01,
     |   8.7032059535593d-01,-6.8977569592505d-01,-1.4068864817664d-02,
     |   6.7578154567383d-01,-8.1770691917833d-01, 3.5899319160719d-01,
     |   3.5899319160720d-01,-8.1770691917833d-01, 6.7578154567382d-01,
     |  -1.4068864817661d-02,-6.8977569592505d-01, 8.7032059535593d-01,
     |  -3.0610459794150d-01,-6.0625720814555d-01, 1.0110207022814d+00,
     |  -2.8676967290103d-01,-1.0055413486798d+00, 8.8829023945216d-01,
     |   1.4866833720230d+00, 6.0145135734924d-01, 8.3952637764273d-02,
     |   3.0588621045767d-03, 1.0561999035270d-05, 2.4885720286554d-11/
      data (pmn(lat,13,28), lat = 1,36)/
     |   1.0721113948696d-12, 1.3909172026974d-06, 6.9887126909798d-04,
     |   2.8752706759728d-02, 2.9652510459725d-01, 1.1026109744989d+00,
     |   1.4513984905310d+00,-1.3262163320421d-01,-1.0796213556987d+00,
     |   6.1449874519738d-01, 4.8733257263832d-01,-9.4678711757852d-01,
     |   4.5880752864409d-01, 4.0004963151554d-01,-8.6337629445349d-01,
     |   5.9157117945626d-01, 1.4956463494406d-01,-7.5674632508958d-01,
     |   7.5674632508958d-01,-1.4956463494406d-01,-5.9157117945626d-01,
     |   8.6337629445349d-01,-4.0004963151554d-01,-4.5880752864409d-01,
     |   9.4678711757852d-01,-4.8733257263832d-01,-6.1449874519739d-01,
     |   1.0796213556987d+00, 1.3262163320421d-01,-1.4513984905310d+00,
     |  -1.1026109744989d+00,-2.9652510459725d-01,-2.8752706759728d-02,
     |  -6.9887126909800d-04,-1.3909172026974d-06,-1.0721113948696d-12/
      data (pmn(lat,14,28), lat = 1,36)/
     |   4.2018414992886d-14, 1.6623731773984d-07, 1.4412156872871d-04,
     |   8.7950355173475d-03, 1.2781285107495d-01, 6.7701023435688d-01,
     |   1.4535131356695d+00, 8.4704624099632d-01,-9.2782854594984d-01,
     |  -4.4839285668707d-01, 1.0059956416528d+00,-3.1244529774177d-01,
     |  -6.4069199567128d-01, 8.7551425783667d-01,-2.6762842849033d-01,
     |  -5.5373348938803d-01, 8.5480640459501d-01,-4.0055133573418d-01,
     |  -4.0055133573418d-01, 8.5480640459501d-01,-5.5373348938802d-01,
     |  -2.6762842849033d-01, 8.7551425783667d-01,-6.4069199567129d-01,
     |  -3.1244529774179d-01, 1.0059956416528d+00,-4.4839285668707d-01,
     |  -9.2782854594984d-01, 8.4704624099631d-01, 1.4535131356695d+00,
     |   6.7701023435688d-01, 1.2781285107495d-01, 8.7950355173477d-03,
     |   1.4412156872872d-04, 1.6623731773984d-07, 4.2018414992886d-14/
      data (pmn(lat,15,28), lat = 1,36)/
     |   1.5021171271995d-15, 1.8087668898553d-08, 2.6940396096104d-05,
     |   2.4190427189940d-03, 4.8792984635450d-02, 3.5619020585924d-01,
     |   1.1189344937199d+00, 1.3954267945020d+00,-5.1070100594466d-02,
     |  -1.0975169577733d+00, 3.8238268888316d-01, 7.4140080463318d-01,
     |  -8.4997108350087d-01, 4.6067821372727d-03, 7.8692926931449d-01,
     |  -7.4526509296579d-01,-2.4576257601123d-02, 7.5418733805332d-01,
     |  -7.5418733805332d-01, 2.4576257601121d-02, 7.4526509296580d-01,
     |  -7.8692926931449d-01,-4.6067821372751d-03, 8.4997108350087d-01,
     |  -7.4140080463317d-01,-3.8238268888316d-01, 1.0975169577733d+00,
     |   5.1070100594471d-02,-1.3954267945020d+00,-1.1189344937199d+00,
     |  -3.5619020585924d-01,-4.8792984635450d-02,-2.4190427189940d-03,
     |  -2.6940396096105d-05,-1.8087668898553d-08,-1.5021171271995d-15/
      data (pmn(lat,16,28), lat = 1,36)/
     |   4.9063255658004d-17, 1.7953092429226d-09, 4.5778532781999d-06,
     |   6.0102592504869d-04, 1.6638050149196d-02, 1.6374197639054d-01,
     |   7.1198961268385d-01, 1.4121537539211d+00, 8.8193907951254d-01,
     |  -8.0149794021223d-01,-6.6399366601702d-01, 9.1300035273304d-01,
     |   1.0226449105924d-01,-8.9578658791629d-01, 5.8578681997101d-01,
     |   3.6082143036281d-01,-8.8099472478883d-01, 4.5222540553560d-01,
     |   4.5222540553560d-01,-8.8099472478883d-01, 3.6082143036280d-01,
     |   5.8578681997101d-01,-8.9578658791629d-01, 1.0226449105925d-01,
     |   9.1300035273304d-01,-6.6399366601702d-01,-8.0149794021223d-01,
     |   8.8193907951254d-01, 1.4121537539211d+00, 7.1198961268385d-01,
     |   1.6374197639054d-01, 1.6638050149196d-02, 6.0102592504870d-04,
     |   4.5778532782001d-06, 1.7953092429226d-09, 4.9063255658004d-17/
      data (pmn(lat,17,28), lat = 1,36)/
     |   1.4652443079843d-18, 1.6271522974339d-10, 7.0828313237460d-07,
     |   1.3528138186870d-04, 5.0956126194237d-03, 6.6556031562592d-02,
     |   3.8739187035680d-01, 1.0981023363067d+00, 1.3779378828743d+00,
     |   1.1820286428871d-01,-1.0951623005114d+00, 3.7908918354469d-02,
     |   9.4810152343992d-01,-5.1569550960942d-01,-5.5556994128845d-01,
     |   8.7718332852761d-01,-1.3442464184807d-01,-7.4902253704959d-01,
     |   7.4902253704959d-01, 1.3442464184807d-01,-8.7718332852761d-01,
     |   5.5556994128845d-01, 5.1569550960942d-01,-9.4810152343992d-01,
     |  -3.7908918354479d-02, 1.0951623005114d+00,-1.1820286428870d-01,
     |  -1.3779378828743d+00,-1.0981023363067d+00,-3.8739187035680d-01,
     |  -6.6556031562592d-02,-5.0956126194237d-03,-1.3528138186870d-04,
     |  -7.0828313237462d-07,-1.6271522974339d-10,-1.4652443079843d-18/
      data (pmn(lat,18,28), lat = 1,36)/
     |   4.0000055437232d-20, 1.3465946362644d-11, 9.9824668522842d-08,
     |   2.7623814781200d-05, 1.4061763296994d-03, 2.4093972739166d-02,
     |   1.8358725571908d-01, 7.0422084888827d-01, 1.3618149082932d+00,
     |   9.9170133950234d-01,-5.8423314298876d-01,-9.0667229975746d-01,
     |   6.4034933226915d-01, 6.0252766618764d-01,-8.6991498018351d-01,
     |  -7.8813197265353d-02, 8.8336293362908d-01,-5.1660187461246d-01,
     |  -5.1660187461247d-01, 8.8336293362908d-01,-7.8813197265345d-02,
     |  -8.6991498018351d-01, 6.0252766618764d-01, 6.4034933226915d-01,
     |  -9.0667229975745d-01,-5.8423314298876d-01, 9.9170133950234d-01,
     |   1.3618149082932d+00, 7.0422084888827d-01, 1.8358725571908d-01,
     |   2.4093972739166d-02, 1.4061763296994d-03, 2.7623814781201d-05,
     |   9.9824668522846d-08, 1.3465946362644d-11, 4.0000055437232d-20/
      data (pmn(lat,19,28), lat = 1,36)/
     |   9.9690666283786d-22, 1.0164469454779d-12, 1.2806773635694d-08,
     |   5.1171085463847d-06, 3.5010923307639d-04, 7.7993725306701d-03,
     |   7.6575117499171d-02, 3.8460805667123d-01, 1.0381160885863d+00,
     |   1.3863457203090d+00, 3.9190711969090d-01,-9.9849438977930d-01,
     |  -4.3020420519568d-01, 9.4951470871108d-01, 1.2099198687913d-01,
     |  -9.3917181654201d-01, 3.3259543735912d-01, 7.3972489784853d-01,
     |  -7.3972489784852d-01,-3.3259543735912d-01, 9.3917181654201d-01,
     |  -1.2099198687913d-01,-9.4951470871108d-01, 4.3020420519569d-01,
     |   9.9849438977931d-01,-3.9190711969090d-01,-1.3863457203090d+00,
     |  -1.0381160885863d+00,-3.8460805667123d-01,-7.6575117499171d-02,
     |  -7.7993725306701d-03,-3.5010923307639d-04,-5.1171085463848d-06,
     |  -1.2806773635695d-08,-1.0164469454779d-12,-9.9690666283786d-22/
      data (pmn(lat,20,28), lat = 1,36)/
     |   2.2626781210010d-23, 6.9817045691693d-14, 1.4925669365090d-09,
     |   8.5866280870821d-07, 7.8610331279932d-05, 2.2607312712243d-03,
     |   2.8265131420600d-02, 1.8184767608367d-01, 6.5081534828489d-01,
     |   1.2881548481503d+00, 1.1591878628604d+00,-2.1727778849097d-01,
     |  -1.0773619589616d+00, 9.0595039236641d-02, 9.7711506195099d-01,
     |  -2.9845770955384d-01,-8.4134104731124d-01, 5.9789196103879d-01,
     |   5.9789196103879d-01,-8.4134104731124d-01,-2.9845770955384d-01,
     |   9.7711506195099d-01, 9.0595039236643d-02,-1.0773619589616d+00,
     |  -2.1727778849098d-01, 1.1591878628604d+00, 1.2881548481503d+00,
     |   6.5081534828490d-01, 1.8184767608367d-01, 2.8265131420601d-02,
     |   2.2607312712243d-03, 7.8610331279932d-05, 8.5866280870823d-07,
     |   1.4925669365091d-09, 6.9817045691693d-14, 2.2626781210010d-23/
      data (pmn(lat,21,28), lat = 1,36)/
     |   4.6587188430576d-25, 4.3472644513884d-15, 1.5746174502490d-10,
     |   1.3011351475804d-07, 1.5879666594706d-05, 5.8619459009020d-04,
     |   9.2484938359442d-03, 7.5034730874247d-02, 3.4510726138578d-01,
     |   9.2936069958741d-01, 1.3855963819492d+00, 7.6854766693716d-01,
     |  -6.8144582567988d-01,-9.2096945225966d-01, 4.9540692050191d-01,
     |   8.5224854895056d-01,-5.7293086319788d-01,-7.2381027017416d-01,
     |   7.2381027017416d-01, 5.7293086319788d-01,-8.5224854895055d-01,
     |  -4.9540692050191d-01, 9.2096945225966d-01, 6.8144582567988d-01,
     |  -7.6854766693715d-01,-1.3855963819492d+00,-9.2936069958741d-01,
     |  -3.4510726138578d-01,-7.5034730874247d-02,-9.2484938359443d-03,
     |  -5.8619459009020d-04,-1.5879666594706d-05,-1.3011351475805d-07,
     |  -1.5746174502490d-10,-4.3472644513884d-15,-4.6587188430576d-25/
      data (pmn(lat,22,28), lat = 1,36)/
     |   8.6509971362759d-27, 2.4398794442825d-16, 1.4954426127822d-11,
     |   1.7712595826882d-08, 2.8727867239670d-06, 1.3548628714699d-04,
     |   2.6780912414729d-03, 2.7082150255958d-02, 1.5674818447239d-01,
     |   5.4858720320179d-01, 1.1601213006856d+00, 1.3291368179186d+00,
     |   3.4378734447690d-01,-9.5229284802994d-01,-6.8341055363337d-01,
     |   7.4002485149902d-01, 7.2105672752188d-01,-7.0369622624970d-01,
     |  -7.0369622624970d-01, 7.2105672752188d-01, 7.4002485149903d-01,
     |  -6.8341055363337d-01,-9.5229284802994d-01, 3.4378734447691d-01,
     |   1.3291368179186d+00, 1.1601213006856d+00, 5.4858720320179d-01,
     |   1.5674818447239d-01, 2.7082150255958d-02, 2.6780912414729d-03,
     |   1.3548628714699d-04, 2.8727867239670d-06, 1.7712595826883d-08,
     |   1.4954426127823d-11, 2.4398794442825d-16, 8.6509971362759d-27/
      data (pmn(lat,23,28), lat = 1,36)/
     |   1.4366787704629d-28, 1.2240213554056d-17, 1.2681180169341d-12,
     |   2.1491524591421d-09, 4.6199148917038d-07, 2.7727879590138d-05,
     |   6.8267962921290d-04, 8.5275453896248d-03, 6.1185086356270d-02,
     |   2.7048218510808d-01, 7.5724229468519d-01, 1.3079022581419d+00,
     |   1.1789450745837d+00,-7.2117557183367d-03,-1.0718244082085d+00,
     |  -4.9880304959207d-01, 8.5151490929427d-01, 6.9682118497495d-01,
     |  -6.9682118497495d-01,-8.5151490929427d-01, 4.9880304959207d-01,
     |   1.0718244082085d+00, 7.2117557183391d-03,-1.1789450745837d+00,
     |  -1.3079022581419d+00,-7.5724229468519d-01,-2.7048218510808d-01,
     |  -6.1185086356271d-02,-8.5275453896249d-03,-6.8267962921291d-04,
     |  -2.7727879590138d-05,-4.6199148917038d-07,-2.1491524591421d-09,
     |  -1.2681180169342d-12,-1.2240213554056d-17,-1.4366787704629d-28/
      data (pmn(lat,24,28), lat = 1,36)/
     |   2.1075183577147d-30, 5.4216275641125d-19, 9.4854021649942d-14,
     |   2.2966226625963d-10, 6.5284311506704d-08, 4.9698822174481d-06,
     |   1.5168116652637d-04, 2.3236838257229d-03, 2.0436561627343d-02,
     |   1.1192901287542d-01, 3.9905559784777d-01, 9.3509665867270d-01,
     |   1.3778581919287d+00, 1.0245833333873d+00,-2.2268358708313d-01,
     |  -1.1182921266105d+00,-4.6243586714706d-01, 8.5020567304889d-01,
     |   8.5020567304889d-01,-4.6243586714706d-01,-1.1182921266105d+00,
     |  -2.2268358708313d-01, 1.0245833333873d+00, 1.3778581919288d+00,
     |   9.3509665867271d-01, 3.9905559784777d-01, 1.1192901287542d-01,
     |   2.0436561627343d-02, 2.3236838257229d-03, 1.5168116652637d-04,
     |   4.9698822174481d-06, 6.5284311506704d-08, 2.2966226625964d-10,
     |   9.4854021649947d-14, 5.4216275641125d-19, 2.1075183577147d-30/
      data (pmn(lat,25,28), lat = 1,36)/
     |   2.6798716448009d-32, 2.0807806192050d-20, 6.1424761997747d-15,
     |   2.1218709001446d-11, 7.9603225310676d-09, 7.6647274893515d-07,
     |   2.8881791480304d-05, 5.3948916317031d-04, 5.7653396115267d-03,
     |   3.8576335000536d-02, 1.7085793753617d-01, 5.1547153486019d-01,
     |   1.0589761495486d+00, 1.4070741635086d+00, 9.5551303184091d-01,
     |  -2.6491176311434d-01,-1.1437015219678d+00,-6.4931069959089d-01,
     |   6.4931069959089d-01, 1.1437015219678d+00, 2.6491176311434d-01,
     |  -9.5551303184091d-01,-1.4070741635086d+00,-1.0589761495486d+00,
     |  -5.1547153486020d-01,-1.7085793753617d-01,-3.8576335000536d-02,
     |  -5.7653396115267d-03,-5.3948916317031d-04,-2.8881791480304d-05,
     |  -7.6647274893515d-07,-7.9603225310676d-09,-2.1218709001447d-11,
     |  -6.1424761997751d-15,-2.0807806192050d-20,-2.6798716448009d-32/
      data (pmn(lat,26,28), lat = 1,36)/
     |   2.8641364317581d-34, 6.7097236006755d-22, 3.3395704886088d-16,
     |   1.6439672877232d-12, 8.1254481987456d-10, 9.8715659168926d-08,
     |   4.5769808476254d-06, 1.0374443574078d-04, 1.3377971350089d-03,
     |   1.0820610724129d-02, 5.8521580897262d-02, 2.2033183261332d-01,
     |   5.8937243679076d-01, 1.1174881104209d+00, 1.4382494617454d+00,
     |   1.0485688769979d+00,-6.2491758677765d-02,-1.0839677725317d+00,
     |  -1.0839677725317d+00,-6.2491758677766d-02, 1.0485688769979d+00,
     |   1.4382494617454d+00, 1.1174881104209d+00, 5.8937243679076d-01,
     |   2.2033183261332d-01, 5.8521580897262d-02, 1.0820610724129d-02,
     |   1.3377971350089d-03, 1.0374443574078d-04, 4.5769808476255d-06,
     |   9.8715659168926d-08, 8.1254481987456d-10, 1.6439672877233d-12,
     |   3.3395704886090d-16, 6.7097236006755d-22, 2.8641364317581d-34/
      data (pmn(lat,27,28), lat = 1,36)/
     |   2.4288725479948d-36, 1.7162309650660d-23, 1.4392753629769d-17,
     |   1.0085985150775d-13, 6.5577717017981d-11, 1.0031138581439d-08,
     |   5.7061797927244d-07, 1.5631808201098d-05, 2.4185292210334d-04,
     |   2.3452402238435d-03, 1.5293853083104d-02, 7.0384141040694d-02,
     |   2.3602426743954d-01, 5.8738670460940d-01, 1.0887757972806d+00,
     |   1.4740347318878d+00, 1.3471596525972d+00, 5.5332953440492d-01,
     |  -5.5332953440492d-01,-1.3471596525972d+00,-1.4740347318878d+00,
     |  -1.0887757972806d+00,-5.8738670460939d-01,-2.3602426743954d-01,
     |  -7.0384141040695d-02,-1.5293853083104d-02,-2.3452402238435d-03,
     |  -2.4185292210335d-04,-1.5631808201098d-05,-5.7061797927245d-07,
     |  -1.0031138581439d-08,-6.5577717017981d-11,-1.0085985150775d-13,
     |  -1.4392753629770d-17,-1.7162309650660d-23,-2.4288725479948d-36/
      data (pmn(lat,28,28), lat = 1,36)/
     |   1.4171108507276d-38, 3.0193316708585d-25, 4.2638813908156d-19,
     |   4.2495859106872d-15, 3.6298325809212d-12, 6.9780309702778d-10,
     |   4.8577903760180d-08, 1.6028603188005d-06, 2.9614867041792d-05,
     |   3.4201161794997d-04, 2.6634369914333d-03, 1.4763640765174d-02,
     |   6.0587909636715d-02, 1.8949850320853d-01, 4.6144733504999d-01,
     |   8.8850211450709d-01, 1.3674011826795d+00, 1.6935449477324d+00,
     |   1.6935449477324d+00, 1.3674011826795d+00, 8.8850211450710d-01,
     |   4.6144733504999d-01, 1.8949850320853d-01, 6.0587909636715d-02,
     |   1.4763640765174d-02, 2.6634369914333d-03, 3.4201161794997d-04,
     |   2.9614867041793d-05, 1.6028603188005d-06, 4.8577903760180d-08,
     |   6.9780309702778d-10, 3.6298325809212d-12, 4.2495859106873d-15,
     |   4.2638813908159d-19, 3.0193316708585d-25, 1.4171108507276d-38/
      data (pmn(lat, 0,29), lat = 1,36)/
     |   3.4045448560958d+00,-2.1896864489365d+00, 1.3616636737190d+00,
     |  -5.0880415590333d-01,-2.6437315051921d-01, 8.1854973968556d-01,
     |  -1.0587459050749d+00, 9.6634114880734d-01,-6.0400531737222d-01,
     |   9.7566632296617d-02, 3.9876034912570d-01,-7.4389500471436d-01,
     |   8.4685820799854d-01,-6.8933822491974d-01, 3.2802573048829d-01,
     |   1.2358142231188d-01,-5.2864392549189d-01, 7.6635993221764d-01,
     |  -7.6635993221764d-01, 5.2864392549189d-01,-1.2358142231187d-01,
     |  -3.2802573048830d-01, 6.8933822491974d-01,-8.4685820799854d-01,
     |   7.4389500471435d-01,-3.9876034912570d-01,-9.7566632296620d-02,
     |   6.0400531737223d-01,-9.6634114880734d-01, 1.0587459050749d+00,
     |  -8.1854973968556d-01, 2.6437315051921d-01, 5.0880415590335d-01,
     |  -1.3616636737190d+00, 2.1896864489365d+00,-3.4045448560958d+00/
      data (pmn(lat, 1,29), lat = 1,36)/
     |   2.8201492244083d+00,-6.3889787347166d-02,-9.3821758368385d-01,
     |   1.3369988119548d+00,-1.2739737734084d+00, 8.6859389411063d-01,
     |  -2.7994235057099d-01,-3.1282639745001d-01, 7.4891659804102d-01,
     |  -9.2283520816404d-01, 8.0751055516240d-01,-4.5685124256345d-01,
     |  -1.2882286561986d-02, 4.5765742810216d-01,-7.4667618590394d-01,
     |   7.9863772463519d-01,-6.0347927758659d-01, 2.2385104719673d-01,
     |   2.2385104719673d-01,-6.0347927758659d-01, 7.9863772463520d-01,
     |  -7.4667618590394d-01, 4.5765742810216d-01,-1.2882286561994d-02,
     |  -4.5685124256346d-01, 8.0751055516240d-01,-9.2283520816404d-01,
     |   7.4891659804102d-01,-3.1282639745001d-01,-2.7994235057100d-01,
     |   8.6859389411063d-01,-1.2739737734084d+00, 1.3369988119548d+00,
     |  -9.3821758368383d-01,-6.3889787347166d-02, 2.8201492244083d+00/
      data (pmn(lat, 2,29), lat = 1,36)/
     |   9.7632827352164d-01, 2.1592639702028d+00,-1.6505201548287d+00,
     |   7.9724836191471d-01, 5.5889181607467d-02,-7.0622344504334d-01,
     |   1.0301350835094d+00,-9.9512915011653d-01, 6.6018265035357d-01,
     |  -1.5508357886555d-01,-3.5715662461489d-01, 7.2499402053067d-01,
     |  -8.4828852905402d-01, 7.0300064493701d-01,-3.4438518771502d-01,
     |  -1.1170452555926d-01, 5.2385922468197d-01,-7.6657885570995d-01,
     |   7.6657885570995d-01,-5.2385922468197d-01, 1.1170452555925d-01,
     |   3.4438518771502d-01,-7.0300064493701d-01, 8.4828852905402d-01,
     |  -7.2499402053066d-01, 3.5715662461489d-01, 1.5508357886555d-01,
     |  -6.6018265035358d-01, 9.9512915011653d-01,-1.0301350835094d+00,
     |   7.0622344504334d-01,-5.5889181607467d-02,-7.9724836191472d-01,
     |   1.6505201548287d+00,-2.1592639702028d+00,-9.7632827352164d-01/
      data (pmn(lat, 3,29), lat = 1,36)/
     |   2.1635768115701d-01, 2.2959633260441d+00,-7.2751380151138d-02,
     |  -9.9599823982510d-01, 1.2952808137385d+00,-1.0552178825665d+00,
     |   5.0063383746470d-01, 1.3706701448898d-01,-6.5260561174936d-01,
     |   9.0563049585677d-01,-8.4667192061891d-01, 5.2076038321812d-01,
     |  -4.7180859212526d-02,-4.1908933027714d-01, 7.3362616469292d-01,
     |  -8.0385428229981d-01, 6.1425987828193d-01,-2.2892325218938d-01,
     |  -2.2892325218939d-01, 6.1425987828193d-01,-8.0385428229981d-01,
     |   7.3362616469292d-01,-4.1908933027714d-01,-4.7180859212517d-02,
     |   5.2076038321813d-01,-8.4667192061891d-01, 9.0563049585677d-01,
     |  -6.5260561174936d-01, 1.3706701448898d-01, 5.0063383746472d-01,
     |  -1.0552178825665d+00, 1.2952808137385d+00,-9.9599823982509d-01,
     |  -7.2751380151161d-02, 2.2959633260441d+00, 2.1635768115701d-01/
      data (pmn(lat, 4,29), lat = 1,36)/
     |   3.5312486046742d-02, 1.4054625165021d+00, 1.5890619090034d+00,
     |  -1.4470900761583d+00, 5.8445717124432d-01, 2.9347341880609d-01,
     |  -8.7276233611061d-01, 1.0351923651436d+00,-8.0837038404070d-01,
     |   3.2561008287418d-01, 2.2532617646636d-01,-6.5956775521131d-01,
     |   8.4621845405411d-01,-7.4101250505283d-01, 3.9296828829745d-01,
     |   7.5590444091157d-02,-5.0912280768816d-01, 7.6720718867726d-01,
     |  -7.6720718867726d-01, 5.0912280768816d-01,-7.5590444091148d-02,
     |  -3.9296828829746d-01, 7.4101250505283d-01,-8.4621845405412d-01,
     |   6.5956775521130d-01,-2.2532617646636d-01,-3.2561008287418d-01,
     |   8.0837038404071d-01,-1.0351923651436d+00, 8.7276233611060d-01,
     |  -2.9347341880609d-01,-5.8445717124432d-01, 1.4470900761583d+00,
     |  -1.5890619090034d+00,-1.4054625165021d+00,-3.5312486046742d-02/
      data (pmn(lat, 5,29), lat = 1,36)/
     |   4.5563931134184d-03, 6.2260356328310d-01, 2.0399196776025d+00,
     |  -2.5869697173137d-01,-9.1418555650339d-01, 1.2148656817082d+00,
     |  -8.7889883932796d-01, 2.3247643036698d-01, 4.1360090581361d-01,
     |  -8.2801116691661d-01, 8.9808998277964d-01,-6.3850474077346d-01,
     |   1.6827825882878d-01, 3.3683396082182d-01,-7.0307189288798d-01,
     |   8.1222662352935d-01,-6.3553587975473d-01, 2.3918951317487d-01,
     |   2.3918951317487d-01,-6.3553587975473d-01, 8.1222662352935d-01,
     |  -7.0307189288798d-01, 3.3683396082182d-01, 1.6827825882878d-01,
     |  -6.3850474077347d-01, 8.9808998277964d-01,-8.2801116691661d-01,
     |   4.1360090581360d-01, 2.3247643036698d-01,-8.7889883932797d-01,
     |   1.2148656817082d+00,-9.1418555650339d-01,-2.5869697173138d-01,
     |   2.0399196776025d+00, 6.2260356328310d-01, 4.5563931134184d-03/
      data (pmn(lat, 6,29), lat = 1,36)/
     |   4.8506637011539d-04, 2.1790594006361d-01, 1.5763206429250d+00,
     |   1.1725850481242d+00,-1.3494266495852d+00, 5.1000004809197d-01,
     |   4.0193654036867d-01,-9.3680169470577d-01, 9.6890400581926d-01,
     |  -5.8933006830677d-01, 1.1108548957039d-02, 5.2313233271002d-01,
     |  -8.2101565429771d-01, 7.9354962966716d-01,-4.7178654343973d-01,
     |  -1.3910277476021d-02, 4.8327548125864d-01,-7.6815712702545d-01,
     |   7.6815712702545d-01,-4.8327548125864d-01, 1.3910277476012d-02,
     |   4.7178654343973d-01,-7.9354962966716d-01, 8.2101565429771d-01,
     |  -5.2313233271001d-01,-1.1108548957039d-02, 5.8933006830678d-01,
     |  -9.6890400581927d-01, 9.3680169470577d-01,-4.0193654036866d-01,
     |  -5.1000004809197d-01, 1.3494266495852d+00,-1.1725850481242d+00,
     |  -1.5763206429250d+00,-2.1790594006361d-01,-4.8506637011539d-04/
      data (pmn(lat, 7,29), lat = 1,36)/
     |   4.3834545754782d-05, 6.3150456049212d-02, 9.1056110759606d-01,
     |   1.8114803114276d+00,-4.3781197395440d-01,-8.1507383859022d-01,
     |   1.1483540837618d+00,-7.4329035623541d-01, 2.4367864690365d-02,
     |   6.0878512565280d-01,-9.0101976358363d-01, 7.8209899631212d-01,
     |  -3.4772877294574d-01,-2.0218903985637d-01, 6.4611369823791d-01,
     |  -8.1937719963523d-01, 6.6665786509282d-01,-2.5490304223117d-01,
     |  -2.5490304223117d-01, 6.6665786509282d-01,-8.1937719963523d-01,
     |   6.4611369823791d-01,-2.0218903985637d-01,-3.4772877294573d-01,
     |   7.8209899631212d-01,-9.0101976358363d-01, 6.0878512565279d-01,
     |   2.4367864690372d-02,-7.4329035623541d-01, 1.1483540837618d+00,
     |  -8.1507383859022d-01,-4.3781197395440d-01, 1.8114803114276d+00,
     |   9.1056110759607d-01, 6.3150456049212d-02, 4.3834545754782d-05/
      data (pmn(lat, 8,29), lat = 1,36)/
     |   3.4309267883464d-06, 1.5604730312988d-02, 4.2562072220193d-01,
     |   1.6365824779088d+00, 8.4232588578061d-01,-1.2826764379679d+00,
     |   4.7913494194284d-01, 4.6949488096731d-01,-9.6415147437373d-01,
     |   8.6811267082411d-01,-3.5046208078463d-01,-2.8311969950950d-01,
     |   7.3922131129871d-01,-8.4144050422118d-01, 5.7579117570248d-01,
     |  -7.5106981305317d-02,-4.4434636597536d-01, 7.6927359109576d-01,
     |  -7.6927359109576d-01, 4.4434636597536d-01, 7.5106981305326d-02,
     |  -5.7579117570248d-01, 8.4144050422118d-01,-7.3922131129872d-01,
     |   2.8311969950949d-01, 3.5046208078463d-01,-8.6811267082411d-01,
     |   9.6415147437373d-01,-4.6949488096731d-01,-4.7913494194285d-01,
     |   1.2826764379679d+00,-8.4232588578061d-01,-1.6365824779088d+00,
     |  -4.2562072220194d-01,-1.5604730312988d-02,-3.4309267883464d-06/
      data (pmn(lat, 9,29), lat = 1,36)/
     |   2.3606789956787d-07, 3.3540898259872d-03, 1.6774758910674d-01,
     |   1.1103602623874d+00, 1.5939721110588d+00,-5.7238917685783d-01,
     |  -7.3382942835060d-01, 1.0972573188303d+00,-6.2056302864238d-01,
     |  -1.6430369224912d-01, 7.5769363657187d-01,-8.9205951682849d-01,
     |   5.6915390793629d-01, 6.7972486002329d-03,-5.4973219496962d-01,
     |   8.1811982014987d-01,-7.0644163284695d-01, 2.7646936863158d-01,
     |   2.7646936863158d-01,-7.0644163284695d-01, 8.1811982014987d-01,
     |  -5.4973219496962d-01, 6.7972486002308d-03, 5.6915390793628d-01,
     |  -8.9205951682850d-01, 7.5769363657187d-01,-1.6430369224912d-01,
     |  -6.2056302864239d-01, 1.0972573188303d+00,-7.3382942835060d-01,
     |  -5.7238917685783d-01, 1.5939721110588d+00, 1.1103602623874d+00,
     |   1.6774758910674d-01, 3.3540898259872d-03, 2.3606789956787d-07/
      data (pmn(lat,10,29), lat = 1,36)/
     |   1.4440543455729d-08, 6.3615275280431d-04, 5.7166519665195d-02,
     |   6.1433298283641d-01, 1.6281813035641d+00, 5.8872883851645d-01,
     |  -1.2270233980153d+00, 4.4674158236744d-01, 5.3873858472975d-01,
     |  -9.7510645974453d-01, 7.2919628990755d-01,-7.9906399354829d-02,
     |  -5.5674688976246d-01, 8.5290866457361d-01,-6.9410873124111d-01,
     |   1.9286403971698d-01, 3.8950228458336d-01,-7.7031945377062d-01,
     |   7.7031945377062d-01,-3.8950228458336d-01,-1.9286403971699d-01,
     |   6.9410873124111d-01,-8.5290866457361d-01, 5.5674688976247d-01,
     |   7.9906399354841d-02,-7.2919628990755d-01, 9.7510645974453d-01,
     |  -5.3873858472974d-01,-4.4674158236744d-01, 1.2270233980153d+00,
     |  -5.8872883851645d-01,-1.6281813035641d+00,-6.1433298283641d-01,
     |  -5.7166519665196d-02,-6.3615275280431d-04,-1.4440543455729d-08/
      data (pmn(lat,11,29), lat = 1,36)/
     |   7.9217659643988d-10, 1.0760868976719d-04, 1.7131937573838d-02,
     |   2.8865363039280d-01, 1.2368764051407d+00, 1.4003400579526d+00,
     |  -6.5387457487528d-01,-6.8922528557105d-01, 1.0552045577857d+00,
     |  -4.8177631922881d-01,-3.6167137700872d-01, 8.6678983326565d-01,
     |  -7.8685463541340d-01, 2.4941474120273d-01, 3.9814687295016d-01,
     |  -7.9779551485264d-01, 7.5287821527961d-01,-3.0448335178792d-01,
     |  -3.0448335178792d-01, 7.5287821527961d-01,-7.9779551485264d-01,
     |   3.9814687295016d-01, 2.4941474120273d-01,-7.8685463541340d-01,
     |   8.6678983326565d-01,-3.6167137700872d-01,-4.8177631922881d-01,
     |   1.0552045577857d+00,-6.8922528557104d-01,-6.5387457487529d-01,
     |   1.4003400579526d+00, 1.2368764051407d+00, 2.8865363039280d-01,
     |   1.7131937573838d-02, 1.0760868976719d-04, 7.9217659643988d-10/
      data (pmn(lat,12,29), lat = 1,36)/
     |   3.9235762836076d-11, 1.6365957175979d-05, 4.5691299695945d-03,
     |   1.1797179853603d-01, 7.6595242062704d-01, 1.5810292706955d+00,
     |   4.1398555435883d-01,-1.1807546694509d+00, 3.8585451276167d-01,
     |   6.3202036403740d-01,-9.6472977511705d-01, 5.2828233303018d-01,
     |   2.3326890818773d-01,-7.8186359449650d-01, 8.0604089307971d-01,
     |  -3.3895001618800d-01,-3.1499615185519d-01, 7.7095094341345d-01,
     |  -7.7095094341345d-01, 3.1499615185518d-01, 3.3895001618801d-01,
     |  -8.0604089307971d-01, 7.8186359449650d-01,-2.3326890818773d-01,
     |  -5.2828233303019d-01, 9.6472977511705d-01,-6.3202036403739d-01,
     |  -3.8585451276168d-01, 1.1807546694509d+00,-4.1398555435882d-01,
     |  -1.5810292706955d+00,-7.6595242062704d-01,-1.1797179853603d-01,
     |  -4.5691299695946d-03,-1.6365957175979d-05,-3.9235762836076d-11/
      data (pmn(lat,13,29), lat = 1,36)/
     |   1.7637427834356d-12, 2.2517490151659d-06, 1.0939592643317d-03,
     |   4.2596081256265d-02, 4.0339276437239d-01, 1.3042000161408d+00,
     |   1.2484333156408d+00,-6.8139277779729d-01,-6.9458229367552d-01,
     |   1.0099769183151d+00,-2.9718804056599d-01,-5.7895305083352d-01,
     |   9.0903736044620d-01,-5.4445433817333d-01,-1.7651696126181d-01,
     |   7.4360090849679d-01,-8.0267449476090d-01, 3.3979147583479d-01,
     |   3.3979147583479d-01,-8.0267449476090d-01, 7.4360090849679d-01,
     |  -1.7651696126181d-01,-5.4445433817333d-01, 9.0903736044620d-01,
     |  -5.7895305083351d-01,-2.9718804056599d-01, 1.0099769183151d+00,
     |  -6.9458229367552d-01,-6.8139277779729d-01, 1.2484333156408d+00,
     |   1.3042000161408d+00, 4.0339276437239d-01, 4.2596081256266d-02,
     |   1.0939592643318d-03, 2.2517490151659d-06, 1.7637427834356d-12/
      data (pmn(lat,14,29), lat = 1,36)/
     |   7.2246420488678d-14, 2.8158526997410d-07, 2.3664368704286d-04,
     |   1.3733905645261d-02, 1.8505466775024d-01, 8.7277353134175d-01,
     |   1.5207472242632d+00, 3.2262851546444d-01,-1.1444417449528d+00,
     |   2.7351497765263d-01, 7.5674670792087d-01,-9.0377489361133d-01,
     |   2.3143413787205d-01, 5.7295520848748d-01,-8.7629816171411d-01,
     |   5.0870356614327d-01, 2.1614444832246d-01,-7.7067757646124d-01,
     |   7.7067757646124d-01,-2.1614444832246d-01,-5.0870356614327d-01,
     |   8.7629816171411d-01,-5.7295520848748d-01,-2.3143413787204d-01,
     |   9.0377489361133d-01,-7.5674670792087d-01,-2.7351497765263d-01,
     |   1.1444417449528d+00,-3.2262851546444d-01,-1.5207472242632d+00,
     |  -8.7277353134175d-01,-1.8505466775024d-01,-1.3733905645261d-02,
     |  -2.3664368704286d-04,-2.8158526997410d-07,-7.2246420488678d-14/
      data (pmn(lat,15,29), lat = 1,36)/
     |   2.7046082561460d-15, 3.2114882630361d-08, 4.6467701476250d-05,
     |   3.9839686753458d-03, 7.5063984115323d-02, 4.9572711641801d-01,
     |   1.3270511249010d+00, 1.1539526244322d+00,-6.5205395390488d-01,
     |  -7.5801655110783d-01, 9.3630029253352d-01,-3.6422495203439d-02,
     |  -7.9681199545992d-01, 8.1454446943452d-01,-1.2091195965050d-01,
     |  -6.3629508624090d-01, 8.5053817689871d-01,-3.8359776928098d-01,
     |  -3.8359776928099d-01, 8.5053817689871d-01,-6.3629508624090d-01,
     |  -1.2091195965050d-01, 8.1454446943452d-01,-7.9681199545992d-01,
     |  -3.6422495203450d-02, 9.3630029253352d-01,-7.5801655110782d-01,
     |  -6.5205395390488d-01, 1.1539526244322d+00, 1.3270511249010d+00,
     |   4.9572711641801d-01, 7.5063984115323d-02, 3.9839686753459d-03,
     |   4.6467701476252d-05, 3.2114882630361d-08, 2.7046082561460d-15/
      data (pmn(lat,16,29), lat = 1,36)/
     |   9.2720005483622d-17, 3.3484722916172d-09, 8.3100774725227d-06,
     |   1.0452515565644d-03, 2.7190421406794d-02, 2.4488361352324d-01,
     |   9.3319014513108d-01, 1.4672360884649d+00, 3.2085832661328d-01,
     |  -1.1101503599920d+00, 8.4155232298749d-02, 8.9730938272648d-01,
     |  -7.3265413197054d-01,-1.8317375766639d-01, 8.5135359166562d-01,
     |  -6.8927750130675d-01,-8.7394604361233d-02, 7.6879567185805d-01,
     |  -7.6879567185804d-01, 8.7394604361230d-02, 6.8927750130675d-01,
     |  -8.5135359166562d-01, 1.8317375766639d-01, 7.3265413197054d-01,
     |  -8.9730938272647d-01,-8.4155232298749d-02, 1.1101503599920d+00,
     |  -3.2085832661328d-01,-1.4672360884649d+00,-9.3319014513109d-01,
     |  -2.4488361352324d-01,-2.7190421406794d-02,-1.0452515565644d-03,
     |  -8.3100774725229d-06,-3.3484722916172d-09,-9.2720005483622d-17/
      data (pmn(lat,17,29), lat = 1,36)/
     |   2.9142054092175d-18, 3.1963445040858d-10, 1.3563705378556d-06,
     |   2.4890943034642d-04, 8.8533615264707d-03, 1.0675919885259d-01,
     |   5.5472901442021d-01, 1.3177568408838d+00, 1.1274782997657d+00,
     |  -5.5313676724488d-01,-8.7652451433254d-01, 7.8543138290653d-01,
     |   3.1876792593586d-01,-9.3534005242893d-01, 4.7536730158043d-01,
     |   4.5313526936125d-01,-8.8805461579487d-01, 4.3765166197125d-01,
     |   4.3765166197125d-01,-8.8805461579487d-01, 4.5313526936124d-01,
     |   4.7536730158043d-01,-9.3534005242893d-01, 3.1876792593586d-01,
     |   7.8543138290654d-01,-8.7652451433254d-01,-5.5313676724488d-01,
     |   1.1274782997657d+00, 1.3177568408838d+00, 5.5472901442021d-01,
     |   1.0675919885259d-01, 8.8533615264707d-03, 2.4890943034642d-04,
     |   1.3563705378557d-06, 3.1963445040858d-10, 2.9142054092175d-18/
      data (pmn(lat,18,29), lat = 1,36)/
     |   8.3998237017679d-20, 2.7948036671501d-11, 2.0226709785235d-07,
     |   5.3911755722014d-05, 2.6021304182042d-03, 4.1451227889837d-02,
     |   2.8571000904517d-01, 9.4782149264472d-01, 1.4311624208054d+00,
     |   4.1747744178332d-01,-1.0495607350606d+00,-2.0759419730792d-01,
     |   9.9198401392708d-01,-3.6605396767291d-01,-6.6205859823202d-01,
     |   8.5357063250695d-01,-7.7391473248909d-02,-7.6427296678173d-01,
     |   7.6427296678173d-01, 7.7391473248911d-02,-8.5357063250696d-01,
     |   6.6205859823202d-01, 3.6605396767291d-01,-9.9198401392709d-01,
     |   2.0759419730791d-01, 1.0495607350606d+00,-4.1747744178332d-01,
     |  -1.4311624208054d+00,-9.4782149264472d-01,-2.8571000904518d-01,
     |  -4.1451227889837d-02,-2.6021304182042d-03,-5.3911755722015d-05,
     |  -2.0226709785236d-07,-2.7948036671501d-11,-8.3998237017679d-20/
      data (pmn(lat,19,29), lat = 1,36)/
     |   2.2190329400039d-21, 2.2374770239725d-12, 2.7557778153849d-08,
     |   1.0628891971989d-05, 6.9195262930210d-04, 1.4412931374245d-02,
     |   1.2929668074192d-01, 5.7328601110123d-01, 1.2816512562526d+00,
     |   1.1710196860403d+00,-3.5583745154520d-01,-1.0189651724977d+00,
     |   4.7957837714798d-01, 7.2915093299808d-01,-8.1834836434719d-01,
     |  -1.7185870884423d-01, 9.0186728599369d-01,-5.0460459016374d-01,
     |  -5.0460459016374d-01, 9.0186728599369d-01,-1.7185870884422d-01,
     |  -8.1834836434719d-01, 7.2915093299808d-01, 4.7957837714797d-01,
     |  -1.0189651724977d+00,-3.5583745154520d-01, 1.1710196860403d+00,
     |   1.2816512562526d+00, 5.7328601110123d-01, 1.2929668074193d-01,
     |   1.4412931374245d-02, 6.9195262930210d-04, 1.0628891971989d-05,
     |   2.7557778153851d-08, 2.2374770239725d-12, 2.2190329400039d-21/
      data (pmn(lat,20,29), lat = 1,36)/
     |   5.3643463895634d-23, 1.6377759620640d-13, 3.4265492998981d-09,
     |   1.9065205651721d-06, 1.6658016927724d-04, 4.5007647156009d-03,
     |   5.1824262120982d-02, 2.9866869990134d-01, 9.1543935255306d-01,
     |   1.4086902877573d+00, 6.2077361482341d-01,-8.9888375061052d-01,
     |  -6.0116048485640d-01, 8.9845727587948d-01, 2.4430975409816d-01,
     |  -9.5145552723556d-01, 2.8416126457231d-01, 7.5553401153569d-01,
     |  -7.5553401153569d-01,-2.8416126457231d-01, 9.5145552723556d-01,
     |  -2.4430975409816d-01,-8.9845727587948d-01, 6.0116048485640d-01,
     |   8.9888375061052d-01,-6.2077361482341d-01,-1.4086902877573d+00,
     |  -9.1543935255307d-01,-2.9866869990134d-01,-5.1824262120982d-02,
     |  -4.5007647156009d-03,-1.6658016927724d-04,-1.9065205651721d-06,
     |  -3.4265492998983d-09,-1.6377759620640d-13,-5.3643463895634d-23/
      data (pmn(lat,21,29), lat = 1,36)/
     |   1.1834496127224d-24, 1.0932282936279d-14, 3.8792722170080d-10,
     |   3.1055541311294d-07, 3.6268909938049d-05, 1.2629731676316d-03,
     |   1.8469998542332d-02, 1.3572105220179d-01, 5.4638187914187d-01,
     |   1.2120492473890d+00, 1.2695042392178d+00,-1.6514648916303d-02,
     |  -1.0905327716823d+00,-5.9129041622631d-02, 9.9919543519977d-01,
     |  -2.1840406186135d-01,-8.7055506937776d-01, 5.8875557812352d-01,
     |   5.8875557812352d-01,-8.7055506937776d-01,-2.1840406186136d-01,
     |   9.9919543519977d-01,-5.9129041622630d-02,-1.0905327716823d+00,
     |  -1.6514648916313d-02, 1.2695042392178d+00, 1.2120492473890d+00,
     |   5.4638187914188d-01, 1.3572105220179d-01, 1.8469998542332d-02,
     |   1.2629731676316d-03, 3.6268909938049d-05, 3.1055541311295d-07,
     |   3.8792722170082d-10, 1.0932282936279d-14, 1.1834496127224d-24/
      data (pmn(lat,22,29), lat = 1,36)/
     |   2.3728443036337d-26, 6.6279103285519d-16, 3.9835148783982d-11,
     |   4.5781483035064d-08, 7.1220589915395d-06, 3.1796684836094d-04,
     |   5.8571771063889d-03, 5.4113300991384d-02, 2.7842893172732d-01,
     |   8.2994086656209d-01, 1.3735647184223d+00, 9.2214035882233d-01,
     |  -5.4906990002696d-01,-9.9449543491337d-01, 3.9849983628704d-01,
     |   8.9855003526131d-01,-5.3674027812431d-01,-7.4001946559448d-01,
     |   7.4001946559448d-01, 5.3674027812431d-01,-8.9855003526131d-01,
     |  -3.9849983628704d-01, 9.9449543491337d-01, 5.4906990002695d-01,
     |  -9.2214035882232d-01,-1.3735647184223d+00,-8.2994086656210d-01,
     |  -2.7842893172732d-01,-5.4113300991384d-02,-5.8571771063890d-03,
     |  -3.1796684836094d-04,-7.1220589915395d-06,-4.5781483035065d-08,
     |  -3.9835148783984d-11,-6.6279103285519d-16,-2.3728443036337d-26/
      data (pmn(lat,23,29), lat = 1,36)/
     |   4.2980799408967d-28, 3.6281578330898d-17, 3.6890699821932d-12,
     |   6.0749124882856d-09, 1.2551885865042d-06, 7.1533508029393d-05,
     |   1.6487989874291d-03, 1.8949295060253d-02, 1.2228813268926d-01,
     |   4.7067127375301d-01, 1.0866570711567d+00, 1.3723191304596d+00,
     |   4.9538081055365d-01,-8.8741115476342d-01,-7.6809464112706d-01,
     |   6.9063681669779d-01, 7.5870504658876d-01,-6.9783888814989d-01,
     |  -6.9783888814989d-01, 7.5870504658875d-01, 6.9063681669780d-01,
     |  -7.6809464112706d-01,-8.8741115476342d-01, 4.9538081055366d-01,
     |   1.3723191304597d+00, 1.0866570711567d+00, 4.7067127375301d-01,
     |   1.2228813268926d-01, 1.8949295060253d-02, 1.6487989874291d-03,
     |   7.1533508029393d-05, 1.2551885865042d-06, 6.0749124882858d-09,
     |   3.6890699821934d-12, 3.6281578330898d-17, 4.2980799408967d-28/
      data (pmn(lat,24,29), lat = 1,36)/
     |   6.9732154567554d-30, 1.7780194137315d-18, 3.0553610368357d-13,
     |   7.1971588922554d-10, 1.9701422314596d-07, 1.4280081439417d-05,
     |   4.0962154454970d-04, 5.8075423149876d-03, 4.6364763297186d-02,
     |   2.2459555358947d-01, 6.8132891827241d-01, 1.2686243993979d+00,
     |   1.2526537743995d+00, 1.1580997985870d-01,-1.0510631315294d+00,
     |  -5.6638880544853d-01, 8.3191002747559d-01, 7.1314121504186d-01,
     |  -7.1314121504186d-01,-8.3191002747559d-01, 5.6638880544853d-01,
     |   1.0510631315294d+00,-1.1580997985870d-01,-1.2526537743995d+00,
     |  -1.2686243993979d+00,-6.8132891827241d-01,-2.2459555358947d-01,
     |  -4.6364763297187d-02,-5.8075423149877d-03,-4.0962154454971d-04,
     |  -1.4280081439417d-05,-1.9701422314596d-07,-7.1971588922556d-10,
     |  -3.0553610368358d-13,-1.7780194137315d-18,-6.9732154567554d-30/
      data (pmn(lat,25,29), lat = 1,36)/
     |   1.0007097656906d-31, 7.7039869632174d-20, 2.2353466711854d-14,
     |   7.5211818928823d-11, 2.7217720180185d-08, 2.5012856919621d-06,
     |   8.8889264805280d-05, 1.5442985803002d-03, 1.5093207430372d-02,
     |   9.0393478059885d-02, 3.4790288611157d-01, 8.7159592107616d-01,
     |   1.3672632773240d+00, 1.1031966592149d+00,-1.3449992008288d-01,
     |  -1.1163167939284d+00,-5.0345096563781d-01, 8.4828823597371d-01,
     |   8.4828823597372d-01,-5.0345096563781d-01,-1.1163167939284d+00,
     |  -1.3449992008288d-01, 1.1031966592149d+00, 1.3672632773240d+00,
     |   8.7159592107617d-01, 3.4790288611157d-01, 9.0393478059885d-02,
     |   1.5093207430372d-02, 1.5442985803002d-03, 8.8889264805281d-05,
     |   2.5012856919621d-06, 2.7217720180185d-08, 7.5211818928825d-11,
     |   2.2353466711855d-14, 7.7039869632174d-20, 1.0007097656906d-31/
      data (pmn(lat,26,29), lat = 1,36)/
     |   1.2464038544004d-33, 2.8960331029647d-21, 1.4177166117546d-15,
     |   6.8048255457970d-12, 3.2493355514806d-09, 3.7759059602802d-07,
     |   1.6561115981409d-05, 3.5063764649826d-04, 4.1609240251630d-03,
     |   3.0408878888695d-02, 1.4511391251545d-01, 4.6639569001720d-01,
     |   1.0115970289121d+00, 1.4121115283278d+00, 1.0214361526366d+00,
     |  -2.0680109931594d-01,-1.1450411904021d+00,-6.6518262085886d-01,
     |   6.6518262085885d-01, 1.1450411904021d+00, 2.0680109931595d-01,
     |  -1.0214361526366d+00,-1.4121115283278d+00,-1.0115970289121d+00,
     |  -4.6639569001720d-01,-1.4511391251545d-01,-3.0408878888695d-02,
     |  -4.1609240251631d-03,-3.5063764649826d-04,-1.6561115981409d-05,
     |  -3.7759059602802d-07,-3.2493355514806d-09,-6.8048255457972d-12,
     |  -1.4177166117547d-15,-2.8960331029647d-21,-1.2464038544004d-33/
      data (pmn(lat,27,29), lat = 1,36)/
     |   1.3063031891795d-35, 9.1575111346270d-23, 7.5580832505978d-17,
     |   5.1693240591619d-13, 3.2516710046144d-10, 4.7669439835856d-08,
     |   2.5720726888209d-06, 6.6062205296249d-05, 9.4555915128895d-04,
     |   8.3483853613639d-03, 4.8602237542519d-02, 1.9463347297840d-01,
     |   5.4805622388199d-01, 1.0841791616078d+00, 1.4459728706731d+00,
     |   1.0935189431926d+00,-2.8660853046379d-02,-1.0872490154157d+00,
     |  -1.0872490154157d+00,-2.8660853046381d-02, 1.0935189431926d+00,
     |   1.4459728706731d+00, 1.0841791616078d+00, 5.4805622388199d-01,
     |   1.9463347297840d-01, 4.8602237542519d-02, 8.3483853613639d-03,
     |   9.4555915128895d-04, 6.6062205296249d-05, 2.5720726888209d-06,
     |   4.7669439835856d-08, 3.2516710046144d-10, 5.1693240591621d-13,
     |   7.5580832505983d-17, 9.1575111346270d-23, 1.3063031891795d-35/
      data (pmn(lat,28,29), lat = 1,36)/
     |   1.0874674843945d-37, 2.2993516477734d-24, 3.1975153224067d-18,
     |   3.1130931860089d-14, 2.5758937552290d-11, 4.7543135726830d-09,
     |   3.1469798908520d-07, 9.7676106080027d-06, 1.6771298060689d-04,
     |   1.7748032319882d-03, 1.2454192117933d-02, 6.0930676362057d-02,
     |   2.1489067726884d-01, 5.5702084831611d-01, 1.0658349376297d+00,
     |   1.4771385150877d+00, 1.3709437176154d+00, 5.6741693696652d-01,
     |  -5.6741693696652d-01,-1.3709437176154d+00,-1.4771385150877d+00,
     |  -1.0658349376297d+00,-5.5702084831611d-01,-2.1489067726884d-01,
     |  -6.0930676362058d-02,-1.2454192117933d-02,-1.7748032319882d-03,
     |  -1.6771298060689d-04,-9.7676106080027d-06,-3.1469798908520d-07,
     |  -4.7543135726830d-09,-2.5758937552290d-11,-3.1130931860090d-14,
     |  -3.1975153224069d-18,-2.2993516477734d-24,-1.0874674843945d-37/
      data (pmn(lat,29,29), lat = 1,36)/
     |   6.2344104913595d-40, 3.9748477673000d-26, 9.3079464270118d-20,
     |   1.2888442152514d-15, 1.4010004156065d-12, 3.2497541083834d-10,
     |   2.6324934736794d-08, 9.8413531015245d-07, 2.0179255642364d-05,
     |   2.5432189586933d-04, 2.1311847058353d-03, 1.2558410362290d-02,
     |   5.4203446524468d-02, 1.7657659542061d-01, 4.4386781241693d-01,
     |   8.7488704934798d-01, 1.3673400240055d+00, 1.7064563652091d+00,
     |   1.7064563652091d+00, 1.3673400240055d+00, 8.7488704934798d-01,
     |   4.4386781241693d-01, 1.7657659542061d-01, 5.4203446524468d-02,
     |   1.2558410362291d-02, 2.1311847058353d-03, 2.5432189586933d-04,
     |   2.0179255642364d-05, 9.8413531015245d-07, 2.6324934736795d-08,
     |   3.2497541083834d-10, 1.4010004156065d-12, 1.2888442152515d-15,
     |   9.3079464270124d-20, 3.9748477673000d-26, 6.2344104913595d-40/
      data (pmn(lat, 0,30), lat = 1,36)/
     |   3.3354948416607d+00,-2.1991056100516d+00, 1.5547410877551d+00,
     |  -8.9534097708685d-01, 2.3903666246989d-01, 3.3730735923510d-01,
     |  -7.5757521948181d-01, 9.6991859575999d-01,-9.5862208920503d-01,
     |   7.4721621326199d-01,-3.9363016230521d-01,-2.1216948149274d-02,
     |   4.0903158977526d-01,-6.9093308674624d-01, 8.1221370159221d-01,
     |  -7.5228904279818d-01, 5.2798573359299d-01,-1.8958479934932d-01,
     |  -1.8958479934932d-01, 5.2798573359299d-01,-7.5228904279818d-01,
     |   8.1221370159221d-01,-6.9093308674624d-01, 4.0903158977527d-01,
     |  -2.1216948149262d-02,-3.9363016230521d-01, 7.4721621326200d-01,
     |  -9.5862208920503d-01, 9.6991859575999d-01,-7.5757521948180d-01,
     |   3.3730735923510d-01, 2.3903666246989d-01,-8.9534097708687d-01,
     |   1.5547410877552d+00,-2.1991056100516d+00, 3.3354948416607d+00/
      data (pmn(lat, 1,30), lat = 1,36)/
     |   2.9194112637227d+00,-3.4818511379454d-01,-6.0603003943763d-01,
     |   1.1009868385374d+00,-1.2587305884564d+00, 1.1357770662374d+00,
     |  -8.0121531874278d-01, 3.4435487110655d-01, 1.3485535978451d-01,
     |  -5.4119361111346d-01, 7.9989525623976d-01,-8.6897236112391d-01,
     |   7.4552773050080d-01,-4.6479827699367d-01, 9.2112890749940d-02,
     |   2.9068295847168d-01,-6.0173162827313d-01, 7.7544255476031d-01,
     |  -7.7544255476031d-01, 6.0173162827313d-01,-2.9068295847168d-01,
     |  -9.2112890749942d-02, 4.6479827699367d-01,-7.4552773050079d-01,
     |   8.6897236112391d-01,-7.9989525623976d-01, 5.4119361111346d-01,
     |  -1.3485535978451d-01,-3.4435487110655d-01, 8.0121531874279d-01,
     |  -1.1357770662374d+00, 1.2587305884564d+00,-1.1009868385374d+00,
     |   6.0603003943760d-01, 3.4818511379454d-01,-2.9194112637227d+00/
      data (pmn(lat, 2,30), lat = 1,36)/
     |   1.0508486830970d+00, 2.0278391272351d+00,-1.7358868176720d+00,
     |   1.1255586897375d+00,-4.3880401934535d-01,-1.9442796500454d-01,
     |   6.7582196262021d-01,-9.4149987854492d-01, 9.6931663628684d-01,
     |  -7.8057922553393d-01, 4.3435081556878d-01,-1.5105588528915d-02,
     |  -3.8399229173392d-01, 6.7903729124957d-01,-8.1118168900653d-01,
     |   7.5733014385045d-01,-5.3375539064399d-01, 1.9201177496946d-01,
     |   1.9201177496946d-01,-5.3375539064399d-01, 7.5733014385045d-01,
     |  -8.1118168900653d-01, 6.7903729124957d-01,-3.8399229173393d-01,
     |  -1.5105588528928d-02, 4.3435081556878d-01,-7.8057922553393d-01,
     |   9.6931663628684d-01,-9.4149987854492d-01, 6.7582196262020d-01,
     |  -1.9442796500454d-01,-4.3880401934535d-01, 1.1255586897375d+00,
     |  -1.7358868176720d+00, 2.0278391272351d+00, 1.0508486830970d+00/
      data (pmn(lat, 3,30), lat = 1,36)/
     |   2.4144433278264d-01, 2.3758196477683d+00,-4.2302243032240d-01,
     |  -6.3361404396131d-01, 1.1220497593358d+00,-1.1873808271679d+00,
     |   9.4254239268850d-01,-5.0655899650218d-01, 4.0524117572313d-03,
     |   4.4824126036409d-01,-7.5776713546474d-01, 8.6958488637456d-01,
     |  -7.7344376854958d-01, 5.0281519562669d-01,-1.2596820494575d-01,
     |  -2.6921796466580d-01, 5.9378578772704d-01,-7.7601601282777d-01,
     |   7.7601601282777d-01,-5.9378578772703d-01, 2.6921796466580d-01,
     |   1.2596820494575d-01,-5.0281519562669d-01, 7.7344376854958d-01,
     |  -8.6958488637456d-01, 7.5776713546474d-01,-4.4824126036409d-01,
     |  -4.0524117572378d-03, 5.0655899650218d-01,-9.4254239268851d-01,
     |   1.1873808271679d+00,-1.1220497593358d+00, 6.3361404396130d-01,
     |   4.2302243032243d-01,-2.3758196477683d+00,-2.4144433278264d-01/
      data (pmn(lat, 4,30), lat = 1,36)/
     |   4.0822855466066d-02, 1.5392133452812d+00, 1.3636841919903d+00,
     |  -1.5271845625716d+00, 9.7667143261544d-01,-2.5663058626437d-01,
     |  -3.8504322674797d-01, 8.1384039769782d-01,-9.7160340665904d-01,
     |   8.6446411691874d-01,-5.5091323317650d-01, 1.2486058089776d-01,
     |   3.0551263410975d-01,-6.4000857845238d-01, 8.0596303082954d-01,
     |  -7.7162027810702d-01, 5.5097748484135d-01,-1.9934779724055d-01,
     |  -1.9934779724055d-01, 5.5097748484135d-01,-7.7162027810702d-01,
     |   8.0596303082954d-01,-6.4000857845237d-01, 3.0551263410976d-01,
     |   1.2486058089777d-01,-5.5091323317650d-01, 8.6446411691874d-01,
     |  -9.7160340665905d-01, 8.1384039769782d-01,-3.8504322674795d-01,
     |  -2.5663058626437d-01, 9.7667143261544d-01,-1.5271845625716d+00,
     |   1.3636841919902d+00, 1.5392133452812d+00, 4.0822855466066d-02/
      data (pmn(lat, 5,30), lat = 1,36)/
     |   5.4555150109847d-03, 7.1431196226923d-01, 2.0561553511474d+00,
     |  -6.4811996251669d-01,-5.0166380811202d-01, 1.0618509053991d+00,
     |  -1.1069608408784d+00, 7.9005376752347d-01,-2.8526406147678d-01,
     |  -2.4013497264799d-01, 6.4898363015951d-01,-8.5230375474484d-01,
     |   8.1901302919868d-01,-5.7532443328653d-01, 1.9391244672148d-01,
     |   2.2503299403675d-01,-5.7715334973120d-01, 7.7711140600711d-01,
     |  -7.7711140600711d-01, 5.7715334973119d-01,-2.2503299403674d-01,
     |  -1.9391244672148d-01, 5.7532443328653d-01,-8.1901302919868d-01,
     |   8.5230375474483d-01,-6.4898363015951d-01, 2.4013497264799d-01,
     |   2.8526406147679d-01,-7.9005376752347d-01, 1.1069608408784d+00,
     |  -1.0618509053991d+00, 5.0166380811202d-01, 6.4811996251670d-01,
     |  -2.0561553511474d+00,-7.1431196226923d-01,-5.4555150109847d-03/
      data (pmn(lat, 6,30), lat = 1,36)/
     |   6.0158965152357d-04, 2.6083843343127d-01, 1.7203331888787d+00,
     |   8.5045418214355d-01,-1.3857902525176d+00, 9.3798457683868d-01,
     |  -1.9201704224278d-01,-4.7514320468630d-01, 8.7321592709525d-01,
     |  -9.4260114892331d-01, 7.1995962546805d-01,-3.0654479300267d-01,
     |  -1.6508817217481d-01, 5.6411863180542d-01,-7.9004811427752d-01,
     |   7.9252475330647d-01,-5.7935790836889d-01, 2.1176203119826d-01,
     |   2.1176203119827d-01,-5.7935790836889d-01, 7.9252475330648d-01,
     |  -7.9004811427752d-01, 5.6411863180542d-01,-1.6508817217482d-01,
     |  -3.0654479300268d-01, 7.1995962546805d-01,-9.4260114892332d-01,
     |   8.7321592709525d-01,-4.7514320468629d-01,-1.9201704224279d-01,
     |   9.3798457683868d-01,-1.3857902525176d+00, 8.5045418214353d-01,
     |   1.7203331888787d+00, 2.6083843343127d-01, 6.0158965152357d-04/
      data (pmn(lat, 7,30), lat = 1,36)/
     |   5.6329110535660d-05, 7.8720443185867d-02, 1.0548693278533d+00,
     |   1.7386684075505d+00,-8.4220719696387d-01,-3.4340732716460d-01,
     |   9.9304077593779d-01,-1.0447294750095d+00, 6.7093113130273d-01,
     |  -1.0606845024557d-01,-4.3088807664927d-01, 7.7940096917469d-01,
     |  -8.5913560530105d-01, 6.7329436027073d-01,-2.9552974191411d-01,
     |  -1.5579571440660d-01, 5.5032492798923d-01,-7.7862134199010d-01,
     |   7.7862134199010d-01,-5.5032492798923d-01, 1.5579571440659d-01,
     |   2.9552974191411d-01,-6.7329436027073d-01, 8.5913560530105d-01,
     |  -7.7940096917468d-01, 4.3088807664927d-01, 1.0606845024558d-01,
     |  -6.7093113130274d-01, 1.0447294750095d+00,-9.9304077593779d-01,
     |   3.4340732716460d-01, 8.4220719696387d-01,-1.7386684075505d+00,
     |  -1.0548693278533d+00,-7.8720443185867d-02,-5.6329110535660d-05/
      data (pmn(lat, 8,30), lat = 1,36)/
     |   4.5703167546407d-06, 2.0240017198635d-02, 5.1922617105651d-01,
     |   1.7541216542467d+00, 4.3397672262141d-01,-1.2578630038546d+00,
     |   9.3171148012528d-01,-1.6582286667436d-01,-5.3344676749202d-01,
     |   9.0409376986808d-01,-8.8227612702720d-01, 5.4412699762920d-01,
     |  -4.5387430767535d-02,-4.3654957543112d-01, 7.5222446467443d-01,
     |  -8.1520321280948d-01, 6.1828963138638d-01,-2.2955006206116d-01,
     |  -2.2955006206117d-01, 6.1828963138638d-01,-8.1520321280949d-01,
     |   7.5222446467443d-01,-4.3654957543112d-01,-4.5387430767526d-02,
     |   5.4412699762921d-01,-8.8227612702720d-01, 9.0409376986808d-01,
     |  -5.3344676749202d-01,-1.6582286667436d-01, 9.3171148012528d-01,
     |  -1.2578630038546d+00, 4.3397672262141d-01, 1.7541216542467d+00,
     |   5.1922617105651d-01, 2.0240017198635d-02, 4.5703167546407d-06/
      data (pmn(lat, 9,30), lat = 1,36)/
     |   3.2617714805203d-07, 4.5255233911324d-03, 2.1465603293738d-01,
     |   1.2840764783791d+00, 1.4223167067446d+00,-9.7328114919218d-01,
     |  -2.0339753888162d-01, 9.3638253554409d-01,-9.9514910364296d-01,
     |   5.5957755264068d-01, 6.5091863704999d-02,-5.9728513857171d-01,
     |   8.5420328303770d-01,-7.7831525124217d-01, 4.2782512476246d-01,
     |   5.8523392822659d-02,-5.1096960033995d-01, 7.8037315072809d-01,
     |  -7.8037315072809d-01, 5.1096960033995d-01,-5.8523392822650d-02,
     |  -4.2782512476246d-01, 7.7831525124217d-01,-8.5420328303770d-01,
     |   5.9728513857170d-01,-6.5091863704999d-02,-5.5957755264068d-01,
     |   9.9514910364296d-01,-9.3638253554409d-01, 2.0339753888161d-01,
     |   9.7328114919218d-01,-1.4223167067446d+00,-1.2840764783791d+00,
     |  -2.1465603293739d-01,-4.5255233911324d-03,-3.2617714805203d-07/
      data (pmn(lat,10,30), lat = 1,36)/
     |   2.0711254208337d-08, 8.9303092253199d-04, 7.6581051451976d-02,
     |   7.5649024596588d-01, 1.6939758492953d+00, 1.1010217118708d-01,
     |  -1.1399268120091d+00, 9.2547928033682d-01,-1.3534721921295d-01,
     |  -5.9527595093447d-01, 9.2269885498045d-01,-7.8624680370132d-01,
     |   3.2203750604672d-01, 2.4097967503802d-01,-6.7646493989576d-01,
     |   8.3194905728984d-01,-6.6665795234104d-01, 2.5315710589418d-01,
     |   2.5315710589418d-01,-6.6665795234104d-01, 8.3194905728984d-01,
     |  -6.7646493989576d-01, 2.4097967503802d-01, 3.2203750604671d-01,
     |  -7.8624680370133d-01, 9.2269885498045d-01,-5.9527595093447d-01,
     |  -1.3534721921296d-01, 9.2547928033682d-01,-1.1399268120091d+00,
     |   1.1010217118708d-01, 1.6939758492953d+00, 7.5649024596588d-01,
     |   7.6581051451977d-02, 8.9303092253199d-04, 2.0711254208337d-08/
      data (pmn(lat,11,30), lat = 1,36)/
     |   1.1804287484155d-09, 1.5724240312748d-04, 2.4004110288929d-02,
     |   3.7608860164749d-01, 1.4167565970779d+00, 1.1327999400984d+00,
     |  -1.0438569057798d+00,-1.0535061813650d-01, 9.0404991186061d-01,
     |  -9.4733326977088d-01, 4.2861595942957d-01, 2.5468535951780d-01,
     |  -7.4747130852775d-01, 8.5746497147634d-01,-5.8197827660194d-01,
     |   6.9584758578723d-02, 4.5586413679209d-01,-7.8211276009451d-01,
     |   7.8211276009451d-01,-4.5586413679209d-01,-6.9584758578732d-02,
     |   5.8197827660194d-01,-8.5746497147633d-01, 7.4747130852776d-01,
     |  -2.5468535951778d-01,-4.2861595942957d-01, 9.4733326977088d-01,
     |  -9.0404991186061d-01, 1.0535061813650d-01, 1.0438569057798d+00,
     |  -1.1327999400984d+00,-1.4167565970779d+00,-3.7608860164750d-01,
     |  -2.4004110288930d-02,-1.5724240312748d-04,-1.1804287484155d-09/
      data (pmn(lat,12,30), lat = 1,36)/
     |   6.0806951188226d-11, 2.4911699740407d-05, 6.6945769722166d-03,
     |   1.6209592035900d-01, 9.4657439759519d-01, 1.5831097534304d+00,
     |  -1.2053783902546d-01,-1.0450744323854d+00, 9.0555391374328d-01,
     |  -7.2620651210512d-02,-6.7919562795874d-01, 9.2337195922673d-01,
     |  -6.2948119202899d-01, 3.2327351386925d-02, 5.4282029733947d-01,
     |  -8.3132497581005d-01, 7.2252467824398d-01,-2.8321701798011d-01,
     |  -2.8321701798012d-01, 7.2252467824398d-01,-8.3132497581005d-01,
     |   5.4282029733947d-01, 3.2327351386927d-02,-6.2948119202898d-01,
     |   9.2337195922673d-01,-6.7919562795874d-01,-7.2620651210516d-02,
     |   9.0555391374328d-01,-1.0450744323854d+00,-1.2053783902547d-01,
     |   1.5831097534304d+00, 9.4657439759519d-01, 1.6209592035901d-01,
     |   6.6945769722168d-03, 2.4911699740407d-05, 6.0806951188226d-11/
      data (pmn(lat,13,30), lat = 1,36)/
     |   2.8464026349778d-12, 3.5739934025424d-06, 1.6766301362513d-03,
     |   6.1621934074901d-02, 5.3282974502085d-01, 1.4732353513322d+00,
     |   8.9669588668322d-01,-1.0679463827295d+00,-6.5443045570034d-02,
     |   9.0450300242347d-01,-8.8479989318305d-01, 2.4885963306841d-01,
     |   4.7628821432423d-01,-8.5910609962817d-01, 7.3857744978484d-01,
     |  -2.2964426448235d-01,-3.8081953670106d-01, 7.8347870244569d-01,
     |  -7.8347870244569d-01, 3.8081953670106d-01, 2.2964426448236d-01,
     |  -7.3857744978484d-01, 8.5910609962817d-01,-4.7628821432424d-01,
     |  -2.4885963306842d-01, 8.8479989318305d-01,-9.0450300242347d-01,
     |   6.5443045570029d-02, 1.0679463827295d+00,-8.9669588668321d-01,
     |  -1.4732353513322d+00,-5.3282974502085d-01,-6.1621934074901d-02,
     |  -1.6766301362514d-03,-3.5739934025424d-06,-2.8464026349778d-12/
      data (pmn(lat,14,30), lat = 1,36)/
     |   1.2158874733994d-13, 4.6661593336840d-07, 3.7966481986989d-04,
     |   2.0906631657743d-02, 2.6000300346662d-01, 1.0800184581290d+00,
     |   1.4606896616781d+00,-2.6001417150218d-01,-9.8905205685361d-01,
     |   8.6179725350102d-01, 4.5470579680011d-02,-7.8856505848222d-01,
     |   8.7603306562358d-01,-3.7117790121425d-01,-3.3079247364307d-01,
     |   7.9725105493202d-01,-7.8263650852873d-01, 3.2061661797290d-01,
     |   3.2061661797290d-01,-7.8263650852873d-01, 7.9725105493201d-01,
     |  -3.3079247364307d-01,-3.7117790121425d-01, 8.7603306562358d-01,
     |  -7.8856505848221d-01, 4.5470579680011d-02, 8.6179725350102d-01,
     |  -9.8905205685361d-01,-2.6001417150219d-01, 1.4606896616780d+00,
     |   1.0800184581290d+00, 2.6000300346662d-01, 2.0906631657743d-02,
     |   3.7966481986990d-04, 4.6661593336840d-07, 1.2158874733994d-13/
      data (pmn(lat,15,30), lat = 1,36)/
     |   4.7547493501196d-15, 5.5646326200407d-08, 7.8130477938266d-05,
     |   6.3829175668142d-03, 1.1191532931847d-01, 6.6333371993233d-01,
     |   1.4785922801196d+00, 7.3491714931199d-01,-1.0596079667146d+00,
     |  -9.7880811046393d-02, 9.3824874224576d-01,-7.7787611029347d-01,
     |  -9.5903528230232d-03, 7.1521695131250d-01,-8.6163698719616d-01,
     |   4.1850146432168d-01, 2.8063578305423d-01,-7.8396037826954d-01,
     |   7.8396037826954d-01,-2.8063578305423d-01,-4.1850146432169d-01,
     |   8.6163698719616d-01,-7.1521695131249d-01, 9.5903528230319d-03,
     |   7.7787611029348d-01,-9.3824874224576d-01, 9.7880811046389d-02,
     |   1.0596079667146d+00,-7.3491714931199d-01,-1.4785922801196d+00,
     |  -6.6333371993233d-01,-1.1191532931847d-01,-6.3829175668143d-03,
     |  -7.8130477938269d-05,-5.5646326200407d-08,-4.7547493501196d-15/
      data (pmn(lat,16,30), lat = 1,36)/
     |   1.7060697027449d-16, 6.0779610651897d-09, 1.4665767105792d-05,
     |   1.7640213669733d-03, 4.2980771130993d-02, 3.5205127014396d-01,
     |   1.1585771778966d+00, 1.3594485719170d+00,-3.1033082396692d-01,
     |  -9.8276726112620d-01, 7.7578495852035d-01, 2.3955400059307d-01,
     |  -9.0057638928630d-01, 7.1750540278469d-01, 2.7634561069542d-02,
     |  -7.0843649780409d-01, 8.4166509121419d-01,-3.6660403177929d-01,
     |  -3.6660403177930d-01, 8.4166509121419d-01,-7.0843649780408d-01,
     |   2.7634561069540d-02, 7.1750540278469d-01,-9.0057638928630d-01,
     |   2.3955400059306d-01, 7.7578495852035d-01,-9.8276726112620d-01,
     |  -3.1033082396692d-01, 1.3594485719170d+00, 1.1585771778966d+00,
     |   3.5205127014396d-01, 4.2980771130993d-02, 1.7640213669734d-03,
     |   1.4665767105793d-05, 6.0779610651897d-09, 1.7060697027449d-16/
      data (pmn(lat,17,30), lat = 1,36)/
     |   5.6253108004070d-18, 6.0912275501695d-10, 2.5174444794865d-06,
     |   4.4312493116372d-04, 1.4841119503722d-02, 1.6438575541767d-01,
     |   7.5456836783395d-01, 1.4575624081468d+00, 6.6258440514035d-01,
     |  -1.0231822470343d+00,-2.1818577330908d-01, 9.8694932574858d-01,
     |  -5.7501543900191d-01,-3.6164721344683d-01, 8.9320948554853d-01,
     |  -6.2448349467027d-01,-1.4914774567370d-01, 7.8282927778438d-01,
     |  -7.8282927778438d-01, 1.4914774567370d-01, 6.2448349467028d-01,
     |  -8.9320948554853d-01, 3.6164721344683d-01, 5.7501543900190d-01,
     |  -9.8694932574858d-01, 2.1818577330908d-01, 1.0231822470343d+00,
     |  -6.6258440514035d-01,-1.4575624081468d+00,-7.5456836783395d-01,
     |  -1.6438575541767d-01,-1.4841119503722d-02,-4.4312493116373d-04,
     |  -2.5174444794866d-06,-6.0912275501695d-10,-5.6253108004070d-18/
      data (pmn(lat,18,30), lat = 1,36)/
     |   1.7056332928335d-19, 5.6065017043899d-11, 3.9577666891943d-07,
     |   1.0144998604871d-04, 4.6311375125701d-03, 6.8292432619512d-02,
     |   4.2239957514527d-01, 1.1894394956437d+00, 1.3028551109565d+00,
     |  -2.6693539207527d-01,-1.0245131563503d+00, 6.0979940218633d-01,
     |   5.1736548878123d-01,-9.4068363379507d-01, 3.5494324058413d-01,
     |   5.3904532994502d-01,-8.9101685737051d-01, 4.2297993641437d-01,
     |   4.2297993641438d-01,-8.9101685737051d-01, 5.3904532994502d-01,
     |   3.5494324058413d-01,-9.4068363379507d-01, 5.1736548878123d-01,
     |   6.0979940218634d-01,-1.0245131563503d+00,-2.6693539207528d-01,
     |   1.3028551109565d+00, 1.1894394956437d+00, 4.2239957514527d-01,
     |   6.8292432619512d-02, 4.6311375125701d-03, 1.0144998604871d-04,
     |   3.9577666891944d-07, 5.6065017043899d-11, 1.7056332928335d-19/
      data (pmn(lat,19,30), lat = 1,36)/
     |   4.7553630902025d-21, 4.7399415001471d-12, 5.7019597384650d-08,
     |   2.1198640420551d-05, 1.3101287294987d-03, 2.5421255048510d-02,
     |   2.0702671170626d-01, 7.9979429653742d-01, 1.4282843044503d+00,
     |   6.9090023647264d-01,-9.4234445038973d-01,-4.3996251222549d-01,
     |   9.9219806425005d-01,-2.0591760631404d-01,-7.5399848294356d-01,
     |   8.2073300549669d-01,-2.0506488319518d-02,-7.7902002915799d-01,
     |   7.7902002915799d-01, 2.0506488319520d-02,-8.2073300549669d-01,
     |   7.5399848294356d-01, 2.0591760631404d-01,-9.9219806425005d-01,
     |   4.3996251222548d-01, 9.4234445038973d-01,-6.9090023647264d-01,
     |  -1.4282843044503d+00,-7.9979429653743d-01,-2.0702671170626d-01,
     |  -2.5421255048510d-02,-1.3101287294987d-03,-2.1198640420551d-05,
     |  -5.7019597384653d-08,-4.7399415001471d-12,-4.7553630902025d-21/
      data (pmn(lat,20,30), lat = 1,36)/
     |   1.2180066609921d-22, 3.6781101059503d-13, 7.5251137259405d-09,
     |   4.0440547967029d-06, 3.3652642484559d-04, 8.5143849841893d-03,
     |   8.9804179639197d-02, 4.5904201149438d-01, 1.1784881547811d+00,
     |   1.3018201782577d+00,-1.1232082058909d-01,-1.0846695982731d+00,
     |   3.0196756707955d-01, 8.3443344846449d-01,-7.5220789784156d-01,
     |  -2.6253424363828d-01, 9.1690894320985d-01,-4.9245966329573d-01,
     |  -4.9245966329573d-01, 9.1690894320985d-01,-2.6253424363827d-01,
     |  -7.5220789784156d-01, 8.3443344846449d-01, 3.0196756707955d-01,
     |  -1.0846695982731d+00,-1.1232082058909d-01, 1.3018201782577d+00,
     |   1.1784881547811d+00, 4.5904201149438d-01, 8.9804179639198d-02,
     |   8.5143849841893d-03, 3.3652642484559d-04, 4.0440547967030d-06,
     |   7.5251137259409d-09, 3.6781101059503d-13, 1.2180066609921d-22/
      data (pmn(lat,21,30), lat = 1,36)/
     |   2.8608057200144d-24, 2.6152131967454d-14, 9.0844993515548d-10,
     |   7.0370699190978d-07, 7.8493117003080d-05, 2.5708504992454d-03,
     |   3.4688041270016d-02, 2.2904520504239d-01, 7.9472996921364d-01,
     |   1.3954142104129d+00, 8.2594500749224d-01,-7.6704851001000d-01,
     |  -7.5194604443257d-01, 8.2603700299765d-01, 3.6292596620088d-01,
     |  -9.5540101708535d-01, 2.3510656939191d-01, 7.7090955759768d-01,
     |  -7.7090955759768d-01,-2.3510656939191d-01, 9.5540101708536d-01,
     |  -3.6292596620088d-01,-8.2603700299765d-01, 7.5194604443257d-01,
     |   7.6704851001001d-01,-8.2594500749224d-01,-1.3954142104129d+00,
     |  -7.9472996921364d-01,-2.2904520504239d-01,-3.4688041270017d-02,
     |  -2.5708504992454d-03,-7.8493117003080d-05,-7.0370699190980d-07,
     |  -9.0844993515552d-10,-2.6152131967454d-14,-2.8608057200144d-24/
      data (pmn(lat,22,30), lat = 1,36)/
     |   6.1436327669978d-26, 1.6989903801335d-15, 1.0005982413443d-10,
     |   1.1145168927533d-07, 1.6600675206353d-05, 6.9973326538263d-04,
     |   1.1963378304099d-02, 1.0032066334648d-01, 4.5357855233585d-01,
     |   1.1234780308235d+00, 1.3476855834114d+00, 1.8357844423420d-01,
     |  -1.0751845357363d+00,-2.0679314699456d-01, 1.0073961563446d+00,
     |  -1.3715188340617d-01,-8.9707594507306d-01, 5.7942909228525d-01,
     |   5.7942909228525d-01,-8.9707594507306d-01,-1.3715188340618d-01,
     |   1.0073961563446d+00,-2.0679314699455d-01,-1.0751845357363d+00,
     |   1.8357844423419d-01, 1.3476855834114d+00, 1.1234780308235d+00,
     |   4.5357855233585d-01, 1.0032066334648d-01, 1.1963378304099d-02,
     |   6.9973326538263d-04, 1.6600675206353d-05, 1.1145168927533d-07,
     |   1.0005982413443d-10, 1.6989903801335d-15, 6.1436327669978d-26/
      data (pmn(lat,23,30), lat = 1,36)/
     |   1.2011168125128d-27, 1.0042429206587d-16, 1.0014629756622d-11,
     |   1.6006425666903d-08, 3.1735581198816d-06, 1.7132047363198d-04,
     |   3.6834848817699d-03, 3.8733603155447d-02, 2.2276945341072d-01,
     |   7.3378726540884d-01, 1.3419849016793d+00, 1.0557731905294d+00,
     |  -4.0599594395718d-01,-1.0508730145758d+00, 2.9743034213853d-01,
     |   9.3877824313256d-01,-4.9936882486026d-01,-7.5586403726946d-01,
     |   7.5586403726946d-01, 4.9936882486027d-01,-9.3877824313256d-01,
     |  -2.9743034213853d-01, 1.0508730145758d+00, 4.0599594395718d-01,
     |  -1.0557731905294d+00,-1.3419849016793d+00,-7.3378726540884d-01,
     |  -2.2276945341072d-01,-3.8733603155448d-02,-3.6834848817699d-03,
     |  -1.7132047363198d-04,-3.1735581198816d-06,-1.6006425666903d-08,
     |  -1.0014629756622d-11,-1.0042429206587d-16,-1.2011168125128d-27/
      data (pmn(lat,24,30), lat = 1,36)/
     |   2.1246964474457d-29, 5.3679780802122d-18, 9.0543124069695d-13,
     |   2.0728337403228d-09, 5.4556214826675d-07, 3.7566401680421d-05,
     |   1.0095021878101d-03, 1.3182000038326d-02, 9.4809897893584d-02,
     |   4.0099378260575d-01, 1.0090180007971d+00, 1.3969373780641d+00,
     |   6.3868170294118d-01,-8.1086502031903d-01,-8.4505272884363d-01,
     |   6.3767134540574d-01, 7.9454597131806d-01,-6.9175504069966d-01,
     |  -6.9175504069966d-01, 7.9454597131806d-01, 6.3767134540575d-01,
     |  -8.4505272884363d-01,-8.1086502031903d-01, 6.3868170294119d-01,
     |   1.3969373780641d+00, 1.0090180007971d+00, 4.0099378260575d-01,
     |   9.4809897893584d-02, 1.3182000038326d-02, 1.0095021878101d-03,
     |   3.7566401680421d-05, 5.4556214826675d-07, 2.0728337403229d-09,
     |   9.0543124069700d-13, 5.3679780802122d-18, 2.1246964474457d-29/
      data (pmn(lat,25,30), lat = 1,36)/
     |   3.3710574029358d-31, 2.5724049912524d-19, 7.3318193176214d-14,
     |   2.4004178917651d-10, 8.3670383610034d-08, 7.3236021534055d-06,
     |   2.4472872191534d-04, 3.9376132448862d-03, 3.4970764959854d-02,
     |   1.8555720296300d-01, 6.0953070752278d-01, 1.2215683792943d+00,
     |   1.3130282418667d+00, 2.3722932434304d-01,-1.0223562549012d+00,
     |  -6.3119656817830d-01, 8.1085044138197d-01, 7.2916543771327d-01,
     |  -7.2916543771327d-01,-8.1085044138197d-01, 6.3119656817829d-01,
     |   1.0223562549012d+00,-2.3722932434304d-01,-1.3130282418667d+00,
     |  -1.2215683792943d+00,-6.0953070752278d-01,-1.8555720296300d-01,
     |  -3.4970764959854d-02,-3.9376132448862d-03,-2.4472872191535d-04,
     |  -7.3236021534055d-06,-8.3670383610034d-08,-2.4004178917652d-10,
     |  -7.3318193176218d-14,-2.5724049912524d-19,-3.3710574029358d-31/
      data (pmn(lat,26,30), lat = 1,36)/
     |   4.7369866907481d-33, 1.0913306579666d-20, 5.2515101609438d-15,
     |   2.4554160880044d-11, 1.1311652864974d-08, 1.2548625081674d-06,
     |   5.1923080401717d-05, 1.0229335341242d-03, 1.1108892680849d-02,
     |   7.2740338724143d-02, 3.0213860405920d-01, 8.0884804975929d-01,
     |   1.3490385543519d+00, 1.1739101994339d+00,-4.5791555833490d-02,
     |  -1.1103984994627d+00,-5.4359714645623d-01, 8.4611170857131d-01,
     |   8.4611170857131d-01,-5.4359714645623d-01,-1.1103984994627d+00,
     |  -4.5791555833492d-02, 1.1739101994339d+00, 1.3490385543519d+00,
     |   8.0884804975929d-01, 3.0213860405920d-01, 7.2740338724143d-02,
     |   1.1108892680849d-02, 1.0229335341242d-03, 5.1923080401717d-05,
     |   1.2548625081674d-06, 1.1311652864974d-08, 2.4554160880045d-11,
     |   5.2515101609441d-15, 1.0913306579666d-20, 4.7369866907481d-33/
      data (pmn(lat,27,30), lat = 1,36)/
     |   5.7838441355305d-35, 4.0215431510543d-22, 3.2647147161717d-16,
     |   2.1773163022052d-12, 1.3233053147328d-09, 1.8558393458455d-07,
     |   9.4741523112954d-06, 2.2735602239538d-04, 2.9957667712619d-03,
     |   2.3911424485014d-02, 1.2293209325205d-01, 4.2083633611613d-01,
     |   9.6337319445416d-01, 1.4116448286825d+00, 1.0832366734889d+00,
     |  -1.4827286266640d-01,-1.1450284856517d+00,-6.8082855043546d-01,
     |   6.8082855043546d-01, 1.1450284856517d+00, 1.4827286266640d-01,
     |  -1.0832366734889d+00,-1.4116448286825d+00,-9.6337319445416d-01,
     |  -4.2083633611613d-01,-1.2293209325205d-01,-2.3911424485014d-02,
     |  -2.9957667712619d-03,-2.2735602239538d-04,-9.4741523112955d-06,
     |  -1.8558393458455d-07,-1.3233053147328d-09,-2.1773163022053d-12,
     |  -3.2647147161719d-16,-4.0215431510543d-22,-5.7838441355305d-35/
      data (pmn(lat,28,30), lat = 1,36)/
     |   5.9487589038120d-37, 1.2479065662599d-23, 1.7079056921090d-17,
     |   1.6229476212996d-13, 1.2992555758937d-10, 2.2983743848121d-08,
     |   1.4431497072565d-06, 4.2001190882219d-05, 6.6727101553007d-04,
     |   6.4307402558218d-03, 4.0298916601818d-02, 1.7164759321154d-01,
     |   5.0875831026868d-01, 1.0499169766270d+00, 1.4506032259331d+00,
     |   1.1365102125045d+00, 5.1444892153780d-03,-1.0902351939923d+00,
     |  -1.0902351939923d+00, 5.1444892153767d-03, 1.1365102125045d+00,
     |   1.4506032259331d+00, 1.0499169766270d+00, 5.0875831026868d-01,
     |   1.7164759321154d-01, 4.0298916601818d-02, 6.4307402558218d-03,
     |   6.6727101553008d-04, 4.2001190882220d-05, 1.4431497072566d-06,
     |   2.2983743848121d-08, 1.2992555758937d-10, 1.6229476212997d-13,
     |   1.7079056921091d-17, 1.2479065662599d-23, 5.9487589038120d-37/
      data (pmn(lat,29,30), lat = 1,36)/
     |   4.8645958236942d-39, 3.0778963027669d-25, 7.0974167255095d-19,
     |   9.6003009102012d-15, 1.0109240475846d-11, 2.2513568753099d-09,
     |   1.7340491880332d-07, 6.0979854868159d-06, 1.1619861298253d-04,
     |   1.3419366554513d-03, 1.0132885522404d-02, 5.2700666969187d-02,
     |   1.9547778951151d-01, 5.2776151407561d-01, 1.0424623395775d+00,
     |   1.4789505593979d+00, 1.3939240545150d+00, 5.8135266381930d-01,
     |  -5.8135266381930d-01,-1.3939240545150d+00,-1.4789505593979d+00,
     |  -1.0424623395775d+00,-5.2776151407561d-01,-1.9547778951151d-01,
     |  -5.2700666969188d-02,-1.0132885522404d-02,-1.3419366554513d-03,
     |  -1.1619861298253d-04,-6.0979854868160d-06,-1.7340491880333d-07,
     |  -2.2513568753099d-09,-1.0109240475846d-11,-9.6003009102015d-15,
     |  -7.0974167255099d-19,-3.0778963027669d-25,-4.8645958236942d-39/
      data (pmn(lat,30,30), lat = 1,36)/
     |   2.7419797807712d-41, 5.2312739218344d-27, 2.0313273592294d-20,
     |   3.9077927520968d-16, 5.4058901576311d-13, 1.5130225249576d-10,
     |   1.4261759859556d-08, 6.0407551725208d-07, 1.3746045610775d-05,
     |   1.8906186124251d-04, 1.7048141358294d-03, 1.0679554938832d-02,
     |   4.8478047322247d-02, 1.6448934724023d-01, 4.2683738120135d-01,
     |   8.6123722572996d-01, 1.3668925765298d+00, 1.7189804244978d+00,
     |   1.7189804244978d+00, 1.3668925765298d+00, 8.6123722572996d-01,
     |   4.2683738120135d-01, 1.6448934724023d-01, 4.8478047322247d-02,
     |   1.0679554938832d-02, 1.7048141358294d-03, 1.8906186124251d-04,
     |   1.3746045610775d-05, 6.0407551725209d-07, 1.4261759859556d-08,
     |   1.5130225249576d-10, 5.4058901576311d-13, 3.9077927520970d-16,
     |   2.0313273592295d-20, 5.2312739218344d-27, 2.7419797807712d-41/
      data (pmn(lat, 0,31), lat = 1,36)/
     |   3.2591985552853d+00,-2.1703109243815d+00, 1.6737044531005d+00,
     |  -1.1987729369905d+00, 7.0600018724426d-01,-2.2024423395139d-01,
     |  -2.1894345142786d-01, 5.7242645302471d-01,-8.0934616289322d-01,
     |   9.1192508742644d-01,-8.7795524384151d-01, 7.2110481467668d-01,
     |  -4.6917527413743d-01, 1.6059580272048d-01, 1.6038257641155d-01,
     |  -4.4919045108096d-01, 6.6646259266394d-01,-7.8290368450034d-01,
     |   7.8290368450034d-01,-6.6646259266394d-01, 4.4919045108095d-01,
     |  -1.6038257641154d-01,-1.6059580272048d-01, 4.6917527413743d-01,
     |  -7.2110481467669d-01, 8.7795524384151d-01,-9.1192508742644d-01,
     |   8.0934616289322d-01,-5.7242645302471d-01, 2.1894345142785d-01,
     |   2.2024423395139d-01,-7.0600018724426d-01, 1.1987729369905d+00,
     |  -1.6737044531005d+00, 2.1703109243815d+00,-3.2591985552853d+00/
      data (pmn(lat, 1,31), lat = 1,36)/
     |   3.0154688992864d+00,-6.2679422822949d-01,-2.4559882671179d-01,
     |   7.6391639287947d-01,-1.0527991712925d+00, 1.1471091468285d+00,
     |  -1.0720691727759d+00, 8.5942167921071d-01,-5.4996750190764d-01,
     |   1.9127497131946d-01, 1.6678194076008d-01,-4.7732256824878d-01,
     |   7.0164362675853d-01,-8.1352544204731d-01, 8.0207580781941d-01,
     |  -6.7273681638419d-01, 4.4631847029573d-01,-1.5617004041025d-01,
     |  -1.5617004041026d-01, 4.4631847029573d-01,-6.7273681638419d-01,
     |   8.0207580781941d-01,-8.1352544204730d-01, 7.0164362675854d-01,
     |  -4.7732256824877d-01, 1.6678194076008d-01, 1.9127497131946d-01,
     |  -5.4996750190765d-01, 8.5942167921071d-01,-1.0720691727759d+00,
     |   1.1471091468285d+00,-1.0527991712925d+00, 7.6391639287945d-01,
     |  -2.4559882671177d-01,-6.2679422822949d-01, 3.0154688992864d+00/
      data (pmn(lat, 2,31), lat = 1,36)/
     |   1.1276082414335d+00, 1.8698746252116d+00,-1.7458121721621d+00,
     |   1.3539885994346d+00,-8.6827287472844d-01, 3.6053508659316d-01,
     |   1.1219797302521d-01,-5.0181121642740d-01, 7.7201305906164d-01,
     |  -9.0170478910622d-01, 8.8697632650438d-01,-7.4116193882808d-01,
     |   4.9286592579431d-01,-1.8217736604978d-01,-1.4446952923204d-01,
     |   4.4016385178357d-01,-6.6340048405804d-01, 7.8326068301054d-01,
     |  -7.8326068301054d-01, 6.6340048405804d-01,-4.4016385178356d-01,
     |   1.4446952923203d-01, 1.8217736604978d-01,-4.9286592579431d-01,
     |   7.4116193882809d-01,-8.8697632650438d-01, 9.0170478910622d-01,
     |  -7.7201305906164d-01, 5.0181121642740d-01,-1.1219797302520d-01,
     |  -3.6053508659316d-01, 8.6827287472844d-01,-1.3539885994346d+00,
     |   1.7458121721621d+00,-1.8698746252116d+00,-1.1276082414335d+00/
      data (pmn(lat, 3,31), lat = 1,36)/
     |   2.6835077573753d-01, 2.4373407339113d+00,-7.5704873804618d-01,
     |  -2.1843045284895d-01, 7.8790656495758d-01,-1.0612084375244d+00,
     |   1.0966761998441d+00,-9.4447015016620d-01, 6.5840515163311d-01,
     |  -2.9691650273255d-01,-8.0420908931037d-02, 4.1814167968346d-01,
     |  -6.7038201542611d-01, 8.0556133823668d-01,-8.0950365581271d-01,
     |   6.8653058585124d-01,-4.5834854159746d-01, 1.6084282672845d-01,
     |   1.6084282672845d-01,-4.5834854159746d-01, 6.8653058585124d-01,
     |  -8.0950365581271d-01, 8.0556133823668d-01,-6.7038201542612d-01,
     |   4.1814167968345d-01,-8.0420908931037d-02,-2.9691650273256d-01,
     |   6.5840515163312d-01,-9.4447015016620d-01, 1.0966761998441d+00,
     |  -1.0612084375244d+00, 7.8790656495758d-01,-2.1843045284893d-01,
     |  -7.5704873804620d-01, 2.4373407339113d+00, 2.6835077573753d-01/
      data (pmn(lat, 4,31), lat = 1,36)/
     |   4.6952396944901d-02, 1.6727510627305d+00, 1.0966526139375d+00,
     |  -1.4909060467450d+00, 1.2355032513744d+00,-7.5235401232127d-01,
     |   2.1739477941113d-01, 2.6743523261987d-01,-6.3665847957252d-01,
     |   8.5231441625108d-01,-9.0151477269427d-01, 7.9448360041980d-01,
     |  -5.6125870763120d-01, 2.4668723327730d-01, 9.5991909918076d-02,
     |  -4.1233810013328d-01, 6.5386273608034d-01,-7.8430879829604d-01,
     |   7.8430879829604d-01,-6.5386273608033d-01, 4.1233810013327d-01,
     |  -9.5991909918074d-02,-2.4668723327730d-01, 5.6125870763119d-01,
     |  -7.9448360041981d-01, 9.0151477269427d-01,-8.5231441625108d-01,
     |   6.3665847957251d-01,-2.6743523261986d-01,-2.1739477941114d-01,
     |   7.5235401232127d-01,-1.2355032513744d+00, 1.4909060467450d+00,
     |  -1.0966526139375d+00,-1.6727510627305d+00,-4.6952396944901d-02/
      data (pmn(lat, 5,31), lat = 1,36)/
     |   6.4915167655029d-03, 8.1296089033999d-01, 2.0294765302764d+00,
     |  -9.9401896041878d-01,-2.5763527714154d-02, 6.9471306894859d-01,
     |  -1.0136174256505d+00, 1.0377813181994d+00,-8.3939249084097d-01,
     |   4.9854115332216d-01,-9.6753649215168d-02,-2.8998283564114d-01,
     |   5.9816356302686d-01,-7.8264990472151d-01, 8.2059441346648d-01,
     |  -7.1280665193936d-01, 4.8231970583210d-01,-1.7029030267769d-01,
     |  -1.7029030267769d-01, 4.8231970583211d-01,-7.1280665193937d-01,
     |   8.2059441346648d-01,-7.8264990472151d-01, 5.9816356302686d-01,
     |  -2.8998283564113d-01,-9.6753649215168d-02, 4.9854115332217d-01,
     |  -8.3939249084097d-01, 1.0377813181994d+00,-1.0136174256505d+00,
     |   6.9471306894859d-01,-2.5763527714154d-02,-9.9401896041880d-01,
     |   2.0294765302764d+00, 8.1296089033999d-01, 6.4915167655029d-03/
      data (pmn(lat, 6,31), lat = 1,36)/
     |   7.4061198182317d-04, 3.0949363886248d-01, 1.8491518817677d+00,
     |   4.8218779088743d-01,-1.2619618363455d+00, 1.1865244553582d+00,
     |  -7.3150031198344d-01, 1.6722991956643d-01, 3.4461704845984d-01,
     |  -7.0944535543412d-01, 8.8225180616894d-01,-8.5816464360413d-01,
     |   6.6456261977799d-01,-3.5248725936062d-01,-1.3070856740753d-02,
     |   3.6352624527634d-01,-6.3677963655801d-01, 7.8597755682144d-01,
     |  -7.8597755682144d-01, 6.3677963655801d-01,-3.6352624527633d-01,
     |   1.3070856740751d-02, 3.5248725936062d-01,-6.6456261977799d-01,
     |   8.5816464360413d-01,-8.8225180616894d-01, 7.0944535543412d-01,
     |  -3.4461704845984d-01,-1.6722991956644d-01, 7.3150031198345d-01,
     |  -1.1865244553582d+00, 1.2619618363455d+00,-4.8218779088741d-01,
     |  -1.8491518817677d+00,-3.0949363886248d-01,-7.4061198182317d-04/
      data (pmn(lat, 7,31), lat = 1,36)/
     |   7.1764937820812d-05, 9.7175643879346d-02, 1.2051534492652d+00,
     |   1.5956834709881d+00,-1.1602290098278d+00, 1.8831311418137d-01,
     |   5.7295888081049d-01,-9.5946494232252d-01, 9.9109840594472d-01,
     |  -7.5477920148582d-01, 3.6093068084277d-01, 7.8956726472561d-02,
     |  -4.6724061372758d-01, 7.3073311098757d-01,-8.2736537361714d-01,
     |   7.4867139134007d-01,-5.1799544142478d-01, 1.8472294491353d-01,
     |   1.8472294491354d-01,-5.1799544142478d-01, 7.4867139134007d-01,
     |  -8.2736537361714d-01, 7.3073311098757d-01,-4.6724061372759d-01,
     |   7.8956726472548d-02, 3.6093068084277d-01,-7.5477920148582d-01,
     |   9.9109840594472d-01,-9.5946494232252d-01, 5.7295888081048d-01,
     |   1.8831311418137d-01,-1.1602290098278d+00, 1.5956834709881d+00,
     |   1.2051534492652d+00, 9.7175643879346d-02, 7.1764937820812d-05/
      data (pmn(lat, 8,31), lat = 1,36)/
     |   6.0282173909746d-06, 2.5968310994530d-02, 6.2465126699300d-01,
     |   1.8300915054664d+00,-1.0403715101135d-02,-1.0298285118264d+00,
     |   1.1485040675964d+00,-7.4066393318873d-01, 1.4775738790770d-01,
     |   3.9823951836615d-01,-7.6209099113744d-01, 8.8757666742310d-01,
     |  -7.8081732141415d-01, 4.9362107289260d-01,-1.0620575626965d-01,
     |  -2.9028329332063d-01, 6.1031769545134d-01,-7.8814311688891d-01,
     |   7.8814311688891d-01,-6.1031769545133d-01, 2.9028329332062d-01,
     |   1.0620575626965d-01,-4.9362107289260d-01, 7.8081732141415d-01,
     |  -8.8757666742310d-01, 7.6209099113744d-01,-3.9823951836615d-01,
     |  -1.4775738790770d-01, 7.4066393318873d-01,-1.1485040675964d+00,
     |   1.0298285118264d+00, 1.0403715101135d-02,-1.8300915054664d+00,
     |  -6.2465126699301d-01,-2.5968310994530d-02,-6.0282173909746d-06/
      data (pmn(lat, 9,31), lat = 1,36)/
     |   4.4564673470462d-07, 6.0326539590878d-03, 2.7071889951584d-01,
     |   1.4522990880532d+00, 1.1570252533319d+00,-1.2334960655865d+00,
     |   3.7306010509221d-01, 4.5859748046822d-01,-9.1462000725160d-01,
     |   9.5381072921846d-01,-6.7252599014922d-01, 2.1863631741288d-01,
     |   2.5687253399696d-01,-6.2920398088732d-01, 8.1686454404062d-01,
     |  -7.8910066792615d-01, 5.6486523126758d-01,-2.0447429857507d-01,
     |  -2.0447429857507d-01, 5.6486523126758d-01,-7.8910066792615d-01,
     |   8.1686454404062d-01,-6.2920398088731d-01, 2.5687253399697d-01,
     |   2.1863631741290d-01,-6.7252599014922d-01, 9.5381072921847d-01,
     |  -9.1462000725160d-01, 4.5859748046822d-01, 3.7306010509222d-01,
     |  -1.2334960655865d+00, 1.1570252533319d+00, 1.4522990880532d+00,
     |   2.7071889951585d-01, 6.0326539590878d-03, 4.4564673470462d-07/
      data (pmn(lat,10,31), lat = 1,36)/
     |   2.9330875626107d-08, 1.2368977355635d-03, 1.0101454870998d-01,
     |   9.1233527521565d-01, 1.6846315378525d+00,-3.8008407827044d-01,
     |  -8.0894453725678d-01, 1.1062133930810d+00,-7.4743964166917d-01,
     |   1.2162874649899d-01, 4.6037249516588d-01,-8.1290969294220d-01,
     |   8.6871232521014d-01,-6.5472344161458d-01, 2.6162264649988d-01,
     |   1.8831817078309d-01,-5.7180720226300d-01, 7.9061764403337d-01,
     |  -7.9061764403336d-01, 5.7180720226300d-01,-1.8831817078308d-01,
     |  -2.6162264649988d-01, 6.5472344161458d-01,-8.6871232521014d-01,
     |   8.1290969294220d-01,-4.6037249516588d-01,-1.2162874649899d-01,
     |   7.4743964166918d-01,-1.1062133930810d+00, 8.0894453725677d-01,
     |   3.8008407827044d-01,-1.6846315378525d+00,-9.1233527521566d-01,
     |  -1.0101454870998d-01,-1.2368977355635d-03,-2.9330875626107d-08/
      data (pmn(lat,11,31), lat = 1,36)/
     |   1.7341384587776d-09, 2.2636931262691d-04, 3.3077705561142d-02,
     |   4.7995043122202d-01, 1.5688309595002d+00, 7.5570458922639d-01,
     |  -1.2323862068891d+00, 5.0708663474323d-01, 3.7561936254135d-01,
     |  -8.8950846656469d-01, 9.1800338545779d-01,-5.6986022235092d-01,
     |   4.4774222680995d-02, 4.5366538924516d-01,-7.7052294431344d-01,
     |   8.2611256501954d-01,-6.2192978445890d-01, 2.3002598499418d-01,
     |   2.3002598499418d-01,-6.2192978445890d-01, 8.2611256501954d-01,
     |  -7.7052294431344d-01, 4.5366538924516d-01, 4.4774222680987d-02,
     |  -5.6986022235093d-01, 9.1800338545779d-01,-8.8950846656469d-01,
     |   3.7561936254134d-01, 5.0708663474323d-01,-1.2323862068891d+00,
     |   7.5570458922639d-01, 1.5688309595002d+00, 4.7995043122202d-01,
     |   3.3077705561143d-02, 2.2636931262691d-04, 1.7341384587776d-09/
      data (pmn(lat,12,31), lat = 1,36)/
     |   9.2752965941342d-11, 3.7298795950708d-05, 9.6333913590820d-03,
     |   2.1802019373513d-01, 1.1353105691050d+00, 1.4739674757747d+00,
     |  -6.3199282458286d-01,-6.2450910278676d-01, 1.0644564281931d+00,
     |  -7.3464583371120d-01, 6.2219279464882d-02, 5.5089061738463d-01,
     |  -8.6226808981421d-01, 8.0401710903383d-01,-4.4720364075535d-01,
     |  -5.3317632514515d-02, 5.1765000682504d-01,-7.9313202657988d-01,
     |   7.9313202657988d-01,-5.1765000682504d-01, 5.3317632514506d-02,
     |   4.4720364075535d-01,-8.0401710903383d-01, 8.6226808981422d-01,
     |  -5.5089061738462d-01,-6.2219279464882d-02, 7.3464583371120d-01,
     |  -1.0644564281931d+00, 6.2450910278675d-01, 6.3199282458287d-01,
     |  -1.4739674757747d+00,-1.1353105691050d+00,-2.1802019373513d-01,
     |  -9.6333913590823d-03,-3.7298795950708d-05,-9.2752965941342d-11/
      data (pmn(lat,13,31), lat = 1,36)/
     |   4.5130949001510d-12, 5.5699692488569d-06, 2.5196856466849d-03,
     |   8.7170257706011d-02, 6.8389868882763d-01, 1.5838032310233d+00,
     |   4.2650897400609d-01,-1.1898777381643d+00, 5.8326354057137d-01,
     |   3.4340910498852d-01,-8.9145818864115d-01, 8.6929578920247d-01,
     |  -4.1799884860347d-01,-1.8369327701538d-01, 6.6446443917483d-01,
     |  -8.4769820708817d-01, 6.8736217813596d-01,-2.6204839703565d-01,
     |  -2.6204839703565d-01, 6.8736217813596d-01,-8.4769820708817d-01,
     |   6.6446443917483d-01,-1.8369327701538d-01,-4.1799884860346d-01,
     |   8.6929578920248d-01,-8.9145818864115d-01, 3.4340910498852d-01,
     |   5.8326354057137d-01,-1.1898777381643d+00, 4.2650897400608d-01,
     |   1.5838032310233d+00, 6.8389868882763d-01, 8.7170257706012d-02,
     |   2.5196856466850d-03, 5.5699692488569d-06, 4.5130949001510d-12/
      data (pmn(lat,14,31), lat = 1,36)/
     |   2.0064327951259d-13, 7.5775768735607d-07, 5.9619853177843d-04,
     |   3.1075505358747d-02, 3.5494900342063d-01, 1.2819908410515d+00,
     |   1.2536617238006d+00,-7.8216491030024d-01,-4.9991408089282d-01,
     |   1.0338150243058d+00,-6.8811251392596d-01,-5.3737696797328d-02,
     |   6.7721311749564d-01,-8.8632934650274d-01, 6.4571677980287d-01,
     |  -1.1751642979857d-01,-4.4322280024323d-01, 7.9530861899705d-01,
     |  -7.9530861899705d-01, 4.4322280024323d-01, 1.1751642979858d-01,
     |  -6.4571677980287d-01, 8.8632934650274d-01,-6.7721311749565d-01,
     |   5.3737696797317d-02, 6.8811251392596d-01,-1.0338150243058d+00,
     |   4.9991408089281d-01, 7.8216491030024d-01,-1.2536617238006d+00,
     |  -1.2819908410515d+00,-3.5494900342063d-01,-3.1075505358747d-02,
     |  -5.9619853177845d-04,-7.5775768735607d-07,-2.0064327951259d-13/
      data (pmn(lat,15,31), lat = 1,36)/
     |   8.1780482159894d-15, 9.4286270388707d-08, 1.2831617882924d-04,
     |   9.9677395212023d-03, 1.6198308711491d-01, 8.5392029430862d-01,
     |   1.5362920266452d+00, 1.9035272745243d-01,-1.1398714530609d+00,
     |   5.9902453943581d-01, 3.7859536628354d-01,-9.1900019861763d-01,
     |   7.7840174956252d-01,-1.8064583035641d-01,-4.7240170032402d-01,
     |   8.3665486106638d-01,-7.5798562954283d-01, 3.0146684115976d-01,
     |   3.0146684115976d-01,-7.5798562954283d-01, 8.3665486106638d-01,
     |  -4.7240170032402d-01,-1.8064583035642d-01, 7.7840174956252d-01,
     |  -9.1900019861763d-01, 3.7859536628354d-01, 5.9902453943581d-01,
     |  -1.1398714530609d+00, 1.9035272745242d-01, 1.5362920266452d+00,
     |   8.5392029430862d-01, 1.6198308711491d-01, 9.9677395212024d-03,
     |   1.2831617882924d-04, 9.4286270388707d-08, 8.1780482159894d-15/
      data (pmn(lat,16,31), lat = 1,36)/
     |   3.0637302038263d-16, 1.0762086540552d-08, 2.5222021901706d-05,
     |   2.8956142218811d-03, 6.5856793706678d-02, 4.8722698817375d-01,
     |   1.3597219822544d+00, 1.0690022333415d+00,-8.5107895512167d-01,
     |  -4.5373965284188d-01, 1.0195143331178d+00,-5.8569519401554d-01,
     |  -2.4729427641832d-01, 8.2197724342621d-01,-8.2141770651028d-01,
     |   3.2275247113476d-01, 3.4280744957705d-01,-7.9661793044926d-01,
     |   7.9661793044926d-01,-3.4280744957705d-01,-3.2275247113477d-01,
     |   8.2141770651028d-01,-8.2197724342621d-01, 2.4729427641833d-01,
     |   5.8569519401555d-01,-1.0195143331178d+00, 4.5373965284188d-01,
     |   8.5107895512168d-01,-1.0690022333414d+00,-1.3597219822544d+00,
     |  -4.8722698817375d-01,-6.5856793706678d-02,-2.8956142218812d-03,
     |  -2.5222021901706d-05,-1.0762086540552d-08,-3.0637302038263d-16/
      data (pmn(lat,17,31), lat = 1,36)/
     |   1.0568068611894d-17, 1.1292443620491d-09, 4.5410229001049d-06,
     |   7.6538233984410d-04, 2.4065878376170d-02, 2.4350066140831d-01,
     |   9.7528346503437d-01, 1.4668925125524d+00, 5.7280217546382d-02,
     |  -1.1080330479848d+00, 5.4603107952090d-01, 4.9421813241534d-01,
     |  -9.4903488566482d-01, 5.9065562635086d-01, 1.7391940340392d-01,
     |  -7.6971374119371d-01, 8.2846904768586d-01,-3.4957214776288d-01,
     |  -3.4957214776288d-01, 8.2846904768586d-01,-7.6971374119371d-01,
     |   1.7391940340392d-01, 5.9065562635086d-01,-9.4903488566482d-01,
     |   4.9421813241533d-01, 5.4603107952090d-01,-1.1080330479848d+00,
     |   5.7280217546376d-02, 1.4668925125524d+00, 9.7528346503438d-01,
     |   2.4350066140831d-01, 2.4065878376170d-02, 7.6538233984411d-04,
     |   4.5410229001051d-06, 1.1292443620491d-09, 1.0568068611894d-17/
      data (pmn(lat,18,31), lat = 1,36)/
     |   3.3600221443257d-19, 1.0906703100431d-10, 7.5031588221417d-07,
     |   1.8467474203071d-04, 7.9522654275504d-03, 1.0805685987754d-01,
     |   5.9427582912440d-01, 1.3864433675141d+00, 9.5306114751046d-01,
     |  -8.5317214890732d-01,-5.0057920622743d-01, 1.0087511425827d+00,
     |  -3.8797291847748d-01,-5.2450425301463d-01, 9.1271216819378d-01,
     |  -5.5216806914768d-01,-2.0961331538419d-01, 7.9630762112308d-01,
     |  -7.9630762112308d-01, 2.0961331538418d-01, 5.5216806914769d-01,
     |  -9.1271216819378d-01, 5.2450425301462d-01, 3.8797291847748d-01,
     |  -1.0087511425827d+00, 5.0057920622743d-01, 8.5317214890733d-01,
     |  -9.5306114751046d-01,-1.3864433675141d+00,-5.9427582912441d-01,
     |  -1.0805685987754d-01,-7.9522654275504d-03,-1.8467474203071d-04,
     |  -7.5031588221420d-07,-1.0906703100431d-10,-3.3600221443257d-19/
      data (pmn(lat,19,31), lat = 1,36)/
     |   9.8501310759092d-21, 9.7018657605835d-12, 1.1389488275350d-07,
     |   4.0756654036207d-05, 2.3855924596582d-03, 4.2950937243967d-02,
     |   3.1525696387643d-01, 1.0443682271277d+00, 1.4097907891471d+00,
     |   3.4390287883282d-02,-1.1033224769521d+00, 3.9971873878290d-01,
     |   6.8977852082070d-01,-9.1356625539064d-01, 2.2768086003737d-01,
     |   6.1789047870279d-01,-8.9006882430410d-01, 4.0821518456530d-01,
     |   4.0821518456530d-01,-8.9006882430410d-01, 6.1789047870279d-01,
     |   2.2768086003737d-01,-9.1356625539064d-01, 6.8977852082071d-01,
     |   3.9971873878291d-01,-1.1033224769521d+00, 3.4390287883281d-02,
     |   1.4097907891471d+00, 1.0443682271277d+00, 3.1525696387643d-01,
     |   4.2950937243967d-02, 2.3855924596582d-03, 4.0756654036208d-05,
     |   1.1389488275351d-07, 9.7018657605835d-12, 9.8501310759092d-21/
      data (pmn(lat,20,31), lat = 1,36)/
     |   2.6615397783441d-22, 7.9466392004024d-13, 1.5885872847415d-08,
     |   8.2347285435763d-06, 6.5123824839793d-04, 1.5376077921264d-02,
     |   1.4767765848772d-01, 6.6181034000034d-01, 1.3810482408728d+00,
     |   9.2766631076857d-01,-7.8455547643883d-01,-6.4844121778660d-01,
     |   9.5139830716210d-01,-4.0719756909739d-02,-8.3035146589306d-01,
     |   7.7946639234048d-01, 3.6027864507547d-02,-7.9328003377446d-01,
     |   7.9328003377446d-01,-3.6027864507545d-02,-7.7946639234049d-01,
     |   8.3035146589306d-01, 4.0719756909740d-02,-9.5139830716210d-01,
     |   6.4844121778659d-01, 7.8455547643883d-01,-9.2766631076857d-01,
     |  -1.3810482408728d+00,-6.6181034000034d-01,-1.4767765848773d-01,
     |  -1.5376077921264d-02,-6.5123824839793d-04,-8.2347285435765d-06,
     |  -1.5885872847416d-08,-7.9466392004024d-13,-2.6615397783441d-22/
      data (pmn(lat,21,31), lat = 1,36)/
     |   6.6208295071031d-24, 5.9873496960270d-14, 2.0344881175563d-09,
     |   1.5230037821310d-06, 1.6193117054600d-04, 4.9731031746514d-03,
     |   6.1600641081191d-02, 3.6222985077341d-01, 1.0624324878786d+00,
     |   1.3861218768045d+00, 1.3439525667958d-01,-1.1043662903832d+00,
     |   1.1483635821372d-01, 9.1676015643665d-01,-6.7337827033429d-01,
     |  -3.5011883737791d-01, 9.2859712089274d-01,-4.8017434813382d-01,
     |  -4.8017434813383d-01, 9.2859712089274d-01,-3.5011883737790d-01,
     |  -6.7337827033429d-01, 9.1676015643665d-01, 1.1483635821371d-01,
     |  -1.1043662903832d+00, 1.3439525667958d-01, 1.3861218768045d+00,
     |   1.0624324878786d+00, 3.6222985077341d-01, 6.1600641081192d-02,
     |   4.9731031746514d-03, 1.6193117054600d-04, 1.5230037821310d-06,
     |   2.0344881175564d-09, 5.9873496960270d-14, 6.6208295071031d-24/
      data (pmn(lat,22,31), lat = 1,36)/
     |   1.5131768391460d-25, 4.1415844712234d-15, 2.3883786282729d-10,
     |   2.5752517645915d-07, 3.6659993034444d-05, 1.4548811433148d-03,
     |   2.2986844314015d-02, 1.7368888169001d-01, 6.8051698504511d-01,
     |   1.3534869500371d+00, 1.0031867093313d+00,-6.0990277622786d-01,
     |  -8.7931610837652d-01, 7.3507613738620d-01, 4.7528462821661d-01,
     |  -9.5136828792566d-01, 1.8560414373515d-01, 7.8586516050556d-01,
     |  -7.8586516050556d-01,-1.8560414373516d-01, 9.5136828792567d-01,
     |  -4.7528462821660d-01,-7.3507613738620d-01, 8.7931610837653d-01,
     |   6.0990277622787d-01,-1.0031867093313d+00,-1.3534869500371d+00,
     |  -6.8051698504512d-01,-1.7368888169001d-01,-2.2986844314015d-02,
     |  -1.4548811433148d-03,-3.6659993034444d-05,-2.5752517645916d-07,
     |  -2.3883786282730d-10,-4.1415844712234d-15,-1.5131768391460d-25/
      data (pmn(lat,23,31), lat = 1,36)/
     |   3.1674382639103d-27, 2.6221819615294d-16, 2.5628795491546d-11,
     |   3.9713593310890d-08, 7.5429224884927d-06, 3.8474211179093d-04,
     |   7.6868587194908d-03, 7.3507187785442d-02, 3.7276434903078d-01,
     |   1.0278666142927d+00, 1.3960262230458d+00, 3.7777395246211d-01,
     |  -1.0335224243563d+00,-3.4965783468153d-01, 1.0022960634905d+00,
     |  -5.5333202473605d-02,-9.2095190407243d-01, 5.6992162915500d-01,
     |   5.6992162915500d-01,-9.2095190407243d-01,-5.5333202473613d-02,
     |   1.0022960634905d+00,-3.4965783468153d-01,-1.0335224243563d+00,
     |   3.7777395246210d-01, 1.3960262230458d+00, 1.0278666142927d+00,
     |   3.7276434903079d-01, 7.3507187785443d-02, 7.6868587194909d-03,
     |   3.8474211179093d-04, 7.5429224884927d-06, 3.9713593310891d-08,
     |   2.5628795491548d-11, 2.6221819615294d-16, 3.1674382639103d-27/
      data (pmn(lat,24,31), lat = 1,36)/
     |   6.0453527414019d-29, 1.5129029275913d-17, 2.5031791305728d-12,
     |   5.5635542112785d-09, 1.4056848095768d-06, 9.1740129619134d-05,
     |   2.3016302729504d-03, 2.7535698014372d-02, 1.7689434887135d-01,
     |   6.4299965615016d-01, 1.2947991195891d+00, 1.1687691571415d+00,
     |  -2.5571547389096d-01,-1.0901591822295d+00, 1.9351488203880d-01,
     |   9.7296167559083d-01,-4.6095232113456d-01,-7.7135530245854d-01,
     |   7.7135530245854d-01, 4.6095232113457d-01,-9.7296167559083d-01,
     |  -1.9351488203880d-01, 1.0901591822295d+00, 2.5571547389095d-01,
     |  -1.1687691571415d+00,-1.2947991195891d+00,-6.4299965615016d-01,
     |  -1.7689434887135d-01,-2.7535698014372d-02,-2.3016302729504d-03,
     |  -9.1740129619134d-05,-1.4056848095768d-06,-5.5635542112787d-09,
     |  -2.5031791305729d-12,-1.5129029275913d-17,-6.0453527414019d-29/
      data (pmn(lat,25,31), lat = 1,36)/
     |   1.0454342409141d-30, 7.9050795452552d-19, 2.2118285734638d-13,
     |   7.0392179939103d-10, 2.3598390684430d-07, 1.9631130065668d-05,
     |   6.1494105325514d-04, 9.1212125984966d-03, 7.3087151447642d-02,
     |   3.3945763283257d-01, 9.2966125162755d-01, 1.4049188541318d+00,
     |   7.7224802708125d-01,-7.2429623729818d-01,-9.1396678984121d-01,
     |   5.8155990894627d-01, 8.2858494554723d-01,-6.8545546145644d-01,
     |  -6.8545546145644d-01, 8.2858494554722d-01, 5.8155990894627d-01,
     |  -9.1396678984121d-01,-7.2429623729818d-01, 7.7224802708126d-01,
     |   1.4049188541318d+00, 9.2966125162755d-01, 3.3945763283257d-01,
     |   7.3087151447643d-02, 9.1212125984966d-03, 6.1494105325515d-04,
     |   1.9631130065668d-05, 2.3598390684430d-07, 7.0392179939105d-10,
     |   2.2118285734639d-13, 7.9050795452552d-19, 1.0454342409141d-30/
      data (pmn(lat,26,31), lat = 1,36)/
     |   1.6236225052805d-32, 3.7078675043582d-20, 1.7528106623940d-14,
     |   7.9757920325403d-11, 3.5398774871013d-08, 3.7413992683882d-06,
     |   1.4563431529506d-04, 2.6588511797777d-03, 2.6263759621987d-02,
     |   1.5259827774762d-01, 5.4246809408382d-01, 1.1685972813186d+00,
     |   1.3606728313769d+00, 3.5598865643767d-01,-9.8630787812362d-01,
     |  -6.9307598769642d-01, 7.8843148261348d-01, 7.4490315040219d-01,
     |  -7.4490315040219d-01,-7.8843148261348d-01, 6.9307598769642d-01,
     |   9.8630787812362d-01,-3.5598865643767d-01,-1.3606728313769d+00,
     |  -1.1685972813186d+00,-5.4246809408382d-01,-1.5259827774763d-01,
     |  -2.6263759621987d-02,-2.6588511797777d-03,-1.4563431529507d-04,
     |  -3.7413992683882d-06,-3.5398774871013d-08,-7.9757920325405d-11,
     |  -1.7528106623941d-14,-3.7078675043582d-20,-1.6236225052805d-32/
      data (pmn(lat,27,31), lat = 1,36)/
     |   2.2358776461601d-34, 1.5415121941107d-21, 1.2301811533403d-15,
     |   7.9928715140819d-12, 4.6873693993122d-09, 6.2768787015028d-07,
     |   3.0238944080638d-05, 6.7550811280388d-04, 8.1505318583627d-03,
     |   5.8341321935321d-02, 2.6146395674450d-01, 7.4761246489447d-01,
     |   1.3242605972220d+00, 1.2368186549051d+00, 4.2935293518447d-02,
     |  -1.1007321458627d+00,-5.8285572179786d-01, 8.4368857868752d-01,
     |   8.4368857868752d-01,-5.8285572179786d-01,-1.1007321458627d+00,
     |   4.2935293518446d-02, 1.2368186549051d+00, 1.3242605972220d+00,
     |   7.4761246489448d-01, 2.6146395674450d-01, 5.8341321935322d-02,
     |   8.1505318583628d-03, 6.7550811280388d-04, 3.0238944080639d-05,
     |   6.2768787015028d-07, 4.6873693993122d-09, 7.9928715140822d-12,
     |   1.2301811533404d-15, 1.5415121941107d-21, 2.2358776461601d-34/
      data (pmn(lat,28,31), lat = 1,36)/
     |   2.6782739974655d-36, 5.5726485269683d-23, 7.5020309737785d-17,
     |   6.9518571106003d-13, 5.3776923381882d-10, 9.1017282355053d-08,
     |   5.4081276755374d-06, 1.4709516660731d-04, 2.1520555100111d-03,
     |   1.8759145324620d-02, 1.0389284413512d-01, 3.7876611464536d-01,
     |   9.1486117397799d-01, 1.4061907971703d+00, 1.1409261452759d+00,
     |  -8.9489844582502d-02,-1.1437201648453d+00,-6.9625593665920d-01,
     |   6.9625593665919d-01, 1.1437201648453d+00, 8.9489844582508d-02,
     |  -1.1409261452759d+00,-1.4061907971703d+00,-9.1486117397799d-01,
     |  -3.7876611464537d-01,-1.0389284413512d-01,-1.8759145324621d-02,
     |  -2.1520555100111d-03,-1.4709516660731d-04,-5.4081276755375d-06,
     |  -9.1017282355053d-08,-5.3776923381882d-10,-6.9518571106005d-13,
     |  -7.5020309737790d-17,-5.5726485269683d-23,-2.6782739974655d-36/
      data (pmn(lat,29,31), lat = 1,36)/
     |   2.7051129280101d-38, 1.6980992127456d-24, 3.8538242809235d-18,
     |   5.0880357885477d-14, 5.1838949624838d-11, 1.1065557955698d-08,
     |   8.0855376961966d-07, 2.6664667196217d-05, 4.7019413016579d-04,
     |   4.9462291060002d-03, 3.3363799198827d-02, 1.5114288009205d-01,
     |   4.7152199015758d-01, 1.0149941924433d+00, 1.4523591622075d+00,
     |   1.1775700822294d+00, 3.8898414080964d-02,-1.0929411735377d+00,
     |  -1.0929411735377d+00, 3.8898414080962d-02, 1.1775700822294d+00,
     |   1.4523591622075d+00, 1.0149941924433d+00, 4.7152199015758d-01,
     |   1.5114288009205d-01, 3.3363799198827d-02, 4.9462291060002d-03,
     |   4.7019413016580d-04, 2.6664667196217d-05, 8.0855376961968d-07,
     |   1.1065557955698d-08, 5.1838949624838d-11, 5.0880357885479d-14,
     |   3.8538242809238d-18, 1.6980992127456d-24, 2.7051129280101d-38/
      data (pmn(lat,30,31), lat = 1,36)/
     |   2.1743075494236d-40, 4.1166723477592d-26, 1.5740977776401d-19,
     |   2.9581575416440d-15, 3.9641751764730d-12, 1.0652329514954d-09,
     |   9.5471244998413d-08, 3.8038918757456d-06, 8.0441273902495d-05,
     |   1.0138122856265d-03, 8.2374812737737d-03, 4.5544920983719d-02,
     |   1.7767281891738d-01, 4.9962908541286d-01, 1.0187661947476d+00,
     |   1.4795505870857d+00, 1.4161274082281d+00, 5.9514222920975d-01,
     |  -5.9514222920975d-01,-1.4161274082281d+00,-1.4795505870857d+00,
     |  -1.0187661947476d+00,-4.9962908541286d-01,-1.7767281891737d-01,
     |  -4.5544920983719d-02,-8.2374812737737d-03,-1.0138122856265d-03,
     |  -8.0441273902496d-05,-3.8038918757457d-06,-9.5471244998415d-08,
     |  -1.0652329514954d-09,-3.9641751764730d-12,-2.9581575416441d-15,
     |  -1.5740977776402d-19,-4.1166723477592d-26,-2.1743075494236d-40/
      data (pmn(lat,31,31), lat = 1,36)/
     |   1.2056416414600d-42, 6.8830283764415d-28, 4.4319116943317d-21,
     |   1.1845346170811d-16, 2.0853612899440d-13, 7.0424767740033d-11,
     |   7.7243878751377d-09, 3.7069164043475d-07, 9.3612869245170d-06,
     |   1.4051065016639d-04, 1.3633837781288d-03, 9.0793921879423d-03,
     |   4.3345944663752d-02, 1.5318899008736d-01, 4.1035183349881d-01,
     |   8.4757616725184d-01, 1.3660839254039d+00, 1.7311384880348d+00,
     |   1.7311384880348d+00, 1.3660839254039d+00, 8.4757616725184d-01,
     |   4.1035183349881d-01, 1.5318899008736d-01, 4.3345944663752d-02,
     |   9.0793921879424d-03, 1.3633837781288d-03, 1.4051065016639d-04,
     |   9.3612869245171d-06, 3.7069164043475d-07, 7.7243878751378d-09,
     |   7.0424767740033d-11, 2.0853612899440d-13, 1.1845346170811d-16,
     |   4.4319116943320d-21, 6.8830283764415d-28, 1.2056416414600d-42/
      data (pmn(lat, 0,32), lat = 1,36)/
     |   3.1758765060233d+00,-2.1038386540597d+00, 1.7129094588240d+00,
     |  -1.3909528557074d+00, 1.0653204173600d+00,-7.2798040417319d-01,
     |   3.8831629999753d-01,-6.1764362315143d-02,-2.3464971382402d-01,
     |   4.8480270266810d-01,-6.7516677188974d-01, 7.9602118909075d-01,
     |  -8.4226403418943d-01, 8.1383831823898d-01,-7.1577603641355d-01,
     |   5.5787358635882d-01,-3.5402955023193d-01, 1.2129509658516d-01,
     |   1.2129509658516d-01,-3.5402955023193d-01, 5.5787358635882d-01,
     |  -7.1577603641356d-01, 8.1383831823898d-01,-8.4226403418943d-01,
     |   7.9602118909075d-01,-6.7516677188974d-01, 4.8480270266810d-01,
     |  -2.3464971382402d-01,-6.1764362315149d-02, 3.8831629999754d-01,
     |  -7.2798040417319d-01, 1.0653204173600d+00,-1.3909528557074d+00,
     |   1.7129094588240d+00,-2.1038386540597d+00, 3.1758765060233d+00/
      data (pmn(lat, 1,32), lat = 1,36)/
     |   3.1080648395511d+00,-8.9514260094585d-01, 1.2628540669444d-01,
     |   3.5669368926926d-01,-6.8733184370525d-01, 8.9999254503853d-01,
     |  -1.0078146425143d+00, 1.0198033063570d+00,-9.4610648568052d-01,
     |   7.9972231856835d-01,-5.9674078135337d-01, 3.5583302525596d-01,
     |  -9.7306385871171d-02,-1.5808651323389d-01, 3.9044380979974d-01,
     |  -5.8199649515872d-01, 7.1827236701828d-01,-7.8905299121171d-01,
     |   7.8905299121171d-01,-7.1827236701827d-01, 5.8199649515871d-01,
     |  -3.9044380979974d-01, 1.5808651323389d-01, 9.7306385871161d-02,
     |  -3.5583302525597d-01, 5.9674078135337d-01,-7.9972231856835d-01,
     |   9.4610648568053d-01,-1.0198033063570d+00, 1.0078146425143d+00,
     |  -8.9999254503853d-01, 6.8733184370525d-01,-3.5669368926924d-01,
     |  -1.2628540669447d-01, 8.9514260094585d-01,-3.1080648395511d+00/
      data (pmn(lat, 2,32), lat = 1,36)/
     |   1.2064858834706d+00, 1.6869699738883d+00,-1.6794418803610d+00,
     |   1.4619639014993d+00,-1.1685544362763d+00, 8.3517623356770d-01,
     |  -4.8613929922490d-01, 1.4369686363744d-01, 1.7126635867386d-01,
     |  -4.4011831092208d-01, 6.4759881099632d-01,-7.8281099438339d-01,
     |   8.3994224214695d-01,-8.1864402925761d-01, 7.2403868293209d-01,
     |  -5.6635112950484d-01, 3.6019071196682d-01,-1.2353243351883d-01,
     |  -1.2353243351883d-01, 3.6019071196682d-01,-5.6635112950484d-01,
     |   7.2403868293209d-01,-8.1864402925761d-01, 8.3994224214695d-01,
     |  -7.8281099438339d-01, 6.4759881099632d-01,-4.4011831092208d-01,
     |   1.7126635867386d-01, 1.4369686363744d-01,-4.8613929922491d-01,
     |   8.3517623356770d-01,-1.1685544362763d+00, 1.4619639014993d+00,
     |  -1.6794418803610d+00, 1.6869699738883d+00, 1.2064858834706d+00/
      data (pmn(lat, 3,32), lat = 1,36)/
     |   2.9712085788837d-01, 2.4786169517634d+00,-1.0616623825805d+00,
     |   2.1500126419321d-01, 3.4039072445342d-01,-7.0365885963237d-01,
     |   9.1553510275701d-01,-9.9862690592679d-01, 9.7097886436918d-01,
     |  -8.5102785923319d-01, 6.5921749208772d-01,-4.1807171448889d-01,
     |   1.5146640478543d-01, 1.1652873874626d-01,-3.6300625865829d-01,
     |   5.6760491078378d-01,-7.1378555161949d-01, 7.8988872727745d-01,
     |  -7.8988872727745d-01, 7.1378555161949d-01,-5.6760491078377d-01,
     |   3.6300625865829d-01,-1.1652873874626d-01,-1.5146640478542d-01,
     |   4.1807171448891d-01,-6.5921749208772d-01, 8.5102785923319d-01,
     |  -9.7097886436919d-01, 9.9862690592679d-01,-9.1553510275700d-01,
     |   7.0365885963237d-01,-3.4039072445342d-01,-2.1500126419323d-01,
     |   1.0616623825805d+00,-2.4786169517634d+00,-2.9712085788837d-01/
      data (pmn(lat, 4,32), lat = 1,36)/
     |   5.3743572655148d-02, 1.8042689711891d+00, 7.9499391447144d-01,
     |  -1.3395338545259d+00, 1.3245074948494d+00,-1.0885801039478d+00,
     |   7.5439743745857d-01,-3.8577977769481d-01, 2.5011943570366d-02,
     |   2.9657164474041d-01,-5.5552579046363d-01, 7.3559893604076d-01,
     |  -8.2771062741217d-01, 8.2995618685720d-01,-7.4737011356236d-01,
     |   5.9134321270932d-01,-3.7867435733271d-01, 1.3029103156296d-01,
     |   1.3029103156297d-01,-3.7867435733271d-01, 5.9134321270932d-01,
     |  -7.4737011356236d-01, 8.2995618685720d-01,-8.2771062741218d-01,
     |   7.3559893604076d-01,-5.5552579046363d-01, 2.9657164474040d-01,
     |   2.5011943570372d-02,-3.8577977769482d-01, 7.5439743745858d-01,
     |  -1.0885801039478d+00, 1.3245074948494d+00,-1.3395338545259d+00,
     |   7.9499391447142d-01, 1.8042689711891d+00, 5.3743572655148d-02/
      data (pmn(lat, 5,32), lat = 1,36)/
     |   7.6792845748236d-03, 9.1812673868347d-01, 1.9570428478068d+00,
     |  -1.2717752816072d+00, 4.5306526411652d-01, 1.8662126890448d-01,
     |  -6.2474101619292d-01, 8.7751574643753d-01,-9.6793630727887d-01,
     |   9.2185220519825d-01,-7.6770633770305d-01, 5.3615934628541d-01,
     |  -2.5914413605751d-01,-3.1532213677100d-02, 3.0583608741669d-01,
     |  -5.3720817857294d-01, 7.0414521611805d-01,-7.9151872885142d-01,
     |   7.9151872885142d-01,-7.0414521611805d-01, 5.3720817857294d-01,
     |  -3.0583608741669d-01, 3.1532213677098d-02, 2.5914413605750d-01,
     |  -5.3615934628543d-01, 7.6770633770305d-01,-9.2185220519825d-01,
     |   9.6793630727888d-01,-8.7751574643753d-01, 6.2474101619291d-01,
     |  -1.8662126890448d-01,-4.5306526411652d-01, 1.2717752816072d+00,
     |  -1.9570428478068d+00,-9.1812673868347d-01,-7.6792845748236d-03/
      data (pmn(lat, 6,32), lat = 1,36)/
     |   9.0547369462393d-04, 3.6416727115504d-01, 1.9570917629185d+00,
     |   8.6788901107760d-02,-9.8946852463105d-01, 1.2057930052992d+00,
     |  -1.0642182672912d+00, 7.4468199405811d-01,-3.5491074780461d-01,
     |  -3.4295234785795d-02, 3.7431791717832d-01,-6.3253812836875d-01,
     |   7.8961878917251d-01,-8.3806860453011d-01, 7.8110834770400d-01,
     |  -6.3139928033473d-01, 4.0945654883760d-01,-1.4171342436922d-01,
     |  -1.4171342436922d-01, 4.0945654883761d-01,-6.3139928033474d-01,
     |   7.8110834770400d-01,-8.3806860453011d-01, 7.8961878917252d-01,
     |  -6.3253812836875d-01, 3.7431791717832d-01,-3.4295234785790d-02,
     |  -3.5491074780462d-01, 7.4468199405811d-01,-1.0642182672912d+00,
     |   1.2057930052992d+00,-9.8946852463105d-01, 8.6788901107742d-02,
     |   1.9570917629185d+00, 3.6416727115504d-01, 9.0547369462393d-04/
      data (pmn(lat, 7,32), lat = 1,36)/
     |   9.0697682799286d-05, 1.1885575760243d-01, 1.3581461743806d+00,
     |   1.3830083925967d+00,-1.3559401642864d+00, 6.8516536912988d-01,
     |  -1.0875304047328d-03,-5.1696955983955d-01, 8.2768854115115d-01,
     |  -9.3913354800305d-01, 8.8047451479145d-01,-6.9118007810259d-01,
     |   4.1557480684385d-01,-9.9099347181071d-02,-2.1483021549260d-01,
     |   4.8762768218127d-01,-6.8798532607133d-01, 7.9385683021079d-01,
     |  -7.9385683021078d-01, 6.8798532607133d-01,-4.8762768218126d-01,
     |   2.1483021549260d-01, 9.9099347181073d-02,-4.1557480684384d-01,
     |   6.9118007810260d-01,-8.8047451479145d-01, 9.3913354800305d-01,
     |  -8.2768854115115d-01, 5.1696955983954d-01, 1.0875304047472d-03,
     |  -6.8516536912988d-01, 1.3559401642864d+00,-1.3830083925967d+00,
     |  -1.3581461743806d+00,-1.1885575760243d-01,-9.0697682799286d-05/
      data (pmn(lat, 8,32), lat = 1,36)/
     |   7.8781071122694d-06, 3.2978621971770d-02, 7.4144123018810d-01,
     |   1.8545221741027d+00,-4.5288239667333d-01,-6.3150187717816d-01,
     |   1.0708861458637d+00,-1.0481486828217d+00, 7.5727830452526d-01,
     |  -3.4645051111621d-01,-7.7822915732703d-02, 4.4200798383441d-01,
     |  -6.9935152058407d-01, 8.2574184029590d-01,-8.1654497750205d-01,
     |   6.8366359556005d-01,-4.5241203849188d-01, 1.5804684464062d-01,
     |   1.5804684464062d-01,-4.5241203849189d-01, 6.8366359556005d-01,
     |  -8.1654497750205d-01, 8.2574184029589d-01,-6.9935152058407d-01,
     |   4.4200798383440d-01,-7.7822915732703d-02,-3.4645051111622d-01,
     |   7.5727830452526d-01,-1.0481486828217d+00, 1.0708861458637d+00,
     |  -6.3150187717816d-01,-4.5288239667333d-01, 1.8545221741027d+00,
     |   7.4144123018811d-01, 3.2978621971770d-02, 7.8781071122694d-06/
      data (pmn(lat, 9,32), lat = 1,36)/
     |   6.0252691466607d-07, 7.9509318040956d-03, 3.3671864356376d-01,
     |   1.6058683173490d+00, 8.0924155608865d-01,-1.3094707539518d+00,
     |   8.5848631172782d-01,-1.7557493248220d-01,-4.1286349582593d-01,
     |   7.8481217367077d-01,-9.1806261225171d-01, 8.4040502279185d-01,
     |  -6.0463245522700d-01, 2.7435984422041d-01, 8.5251581976593d-02,
     |  -4.1426891654839d-01, 6.6317629395407d-01,-7.9676526032055d-01,
     |   7.9676526032055d-01,-6.6317629395406d-01, 4.1426891654839d-01,
     |  -8.5251581976591d-02,-2.7435984422042d-01, 6.0463245522699d-01,
     |  -8.4040502279186d-01, 9.1806261225171d-01,-7.8481217367077d-01,
     |   4.1286349582592d-01, 1.7557493248220d-01,-8.5848631172783d-01,
     |   1.3094707539518d+00,-8.0924155608865d-01,-1.6058683173490d+00,
     |  -3.3671864356376d-01,-7.9509318040956d-03,-6.0252691466607d-07/
      data (pmn(lat,10,32), lat = 1,36)/
     |   4.1050432860411d-08, 1.6917615788919d-03, 1.3130437938126d-01,
     |   1.0779367699270d+00, 1.5885386722905d+00,-8.1945224153064d-01,
     |  -3.0039443204745d-01, 9.2535368520295d-01,-1.0252395107825d+00,
     |   7.6615106949538d-01,-3.2943334602513d-01,-1.3603694646860d-01,
     |   5.2355166618724d-01,-7.6758398537137d-01, 8.3968456181460d-01,
     |  -7.4319269725554d-01, 5.0717167476463d-01,-1.7965939797444d-01,
     |  -1.7965939797444d-01, 5.0717167476463d-01,-7.4319269725554d-01,
     |   8.3968456181460d-01,-7.6758398537137d-01, 5.2355166618725d-01,
     |  -1.3603694646859d-01,-3.2943334602513d-01, 7.6615106949538d-01,
     |  -1.0252395107825d+00, 9.2535368520294d-01,-3.0039443204744d-01,
     |  -8.1945224153064d-01, 1.5885386722905d+00, 1.0779367699270d+00,
     |   1.3130437938127d-01, 1.6917615788919d-03, 4.1050432860411d-08/
      data (pmn(lat,11,32), lat = 1,36)/
     |   2.5141372247873d-09, 3.2138390810499d-04, 4.4871511915807d-02,
     |   6.0032675381041d-01, 1.6760274982648d+00, 2.9963789681500d-01,
     |  -1.1741256327132d+00, 9.6159388677811d-01,-3.1033573462085d-01,
     |  -3.3655383707845d-01, 7.6334278489657d-01,-9.0559683667726d-01,
     |   7.8821372047345d-01,-4.8398970997276d-01, 8.6008243308629d-02,
     |   3.1148777741479d-01,-6.2673207767732d-01, 8.0004300136413d-01,
     |  -8.0004300136413d-01, 6.2673207767732d-01,-3.1148777741478d-01,
     |  -8.6008243308630d-02, 4.8398970997276d-01,-7.8821372047345d-01,
     |   9.0559683667727d-01,-7.6334278489657d-01, 3.3655383707845d-01,
     |   3.1033573462086d-01,-9.6159388677811d-01, 1.1741256327132d+00,
     |  -2.9963789681500d-01,-1.6760274982648d+00,-6.0032675381042d-01,
     |  -4.4871511915808d-02,-3.2138390810499d-04,-2.5141372247873d-09/
      data (pmn(lat,12,32), lat = 1,36)/
     |   1.3941364931217d-10, 5.4993809109644d-05, 1.3629706037357d-02,
     |   2.8731525506480d-01, 1.3211498813656d+00, 1.2457382422902d+00,
     |  -1.0299217933520d+00,-2.9324568979786d-02, 7.9226012863957d-01,
     |  -9.9841801138862d-01, 7.5725489966877d-01,-2.7990351217103d-01,
     |  -2.3278132729082d-01, 6.3157490930327d-01,-8.2999522218482d-01,
     |   8.0196665161574d-01,-5.7289087949888d-01, 2.0706655394929d-01,
     |   2.0706655394929d-01,-5.7289087949888d-01, 8.0196665161574d-01,
     |  -8.2999522218482d-01, 6.3157490930327d-01,-2.3278132729083d-01,
     |  -2.7990351217104d-01, 7.5725489966877d-01,-9.9841801138863d-01,
     |   7.9226012863957d-01,-2.9324568979781d-02,-1.0299217933520d+00,
     |   1.2457382422902d+00, 1.3211498813656d+00, 2.8731525506480d-01,
     |   1.3629706037357d-02, 5.4993809109644d-05, 1.3941364931217d-10/
      data (pmn(lat,13,32), lat = 1,36)/
     |   7.0395239259848d-12, 8.5347272866662d-06, 3.7178422666611d-03,
     |   1.2071960767569d-01, 8.5340286396121d-01, 1.6108259350504d+00,
     |  -1.0364506445230d-01,-1.0049040024833d+00, 1.0061264915587d+00,
     |  -3.9089354080019d-01,-3.0860402886722d-01, 7.7493745660891d-01,
     |  -8.9559672337617d-01, 6.9968596350066d-01,-2.9650466564093d-01,
     |  -1.7338024208367d-01, 5.7469551439706d-01,-8.0340748234168d-01,
     |   8.0340748234168d-01,-5.7469551439706d-01, 1.7338024208366d-01,
     |   2.9650466564093d-01,-6.9968596350066d-01, 8.9559672337617d-01,
     |  -7.7493745660891d-01, 3.0860402886722d-01, 3.9089354080019d-01,
     |  -1.0061264915587d+00, 1.0049040024833d+00, 1.0364506445232d-01,
     |  -1.6108259350504d+00,-8.5340286396121d-01,-1.2071960767569d-01,
     |  -3.7178422666612d-03,-8.5347272866662d-06,-7.0395239259848d-12/
      data (pmn(lat,14,32), lat = 1,36)/
     |   3.2513973204709d-13, 1.2077620947611d-06, 9.1773633215401d-04,
     |   4.5165776753957d-02, 4.7129818115220d-01, 1.4572506453031d+00,
     |   9.0204873196904d-01,-1.1220017676056d+00, 1.6168761562086d-01,
     |   6.9814670996853d-01,-9.7669291459869d-01, 7.1821812802170d-01,
     |  -1.7380328817240d-01,-3.8601471244420d-01, 7.6003135271165d-01,
     |  -8.4761214029924d-01, 6.4788995932613d-01,-2.4097331240765d-01,
     |  -2.4097331240765d-01, 6.4788995932613d-01,-8.4761214029924d-01,
     |   7.6003135271165d-01,-3.8601471244420d-01,-1.7380328817239d-01,
     |   7.1821812802171d-01,-9.7669291459869d-01, 6.9814670996853d-01,
     |   1.6168761562087d-01,-1.1220017676056d+00, 9.0204873196903d-01,
     |   1.4572506453031d+00, 4.7129818115220d-01, 4.5165776753958d-02,
     |   9.1773633215404d-04, 1.2077620947611d-06, 3.2513973204709d-13/
      data (pmn(lat,15,32), lat = 1,36)/
     |   1.3785811165701d-14, 1.5649602764729d-07, 2.0620014677647d-04,
     |   1.5197585116588d-02, 2.2791786354510d-01, 1.0575585060027d+00,
     |   1.4684079790119d+00,-3.8622333131906d-01,-8.5277845145640d-01,
     |   1.0131554057523d+00,-4.0778912885294d-01,-3.4718687894152d-01,
     |   8.2319896496827d-01,-8.6509255425130d-01, 5.3206030133096d-01,
     |  -4.6683921576598d-03,-5.0201707550332d-01, 8.0646615649222d-01,
     |  -8.0646615649222d-01, 5.0201707550331d-01, 4.6683921576686d-03,
     |  -5.3206030133096d-01, 8.6509255425130d-01,-8.2319896496828d-01,
     |   3.4718687894151d-01, 4.0778912885294d-01,-1.0131554057524d+00,
     |   8.5277845145640d-01, 3.8622333131906d-01,-1.4684079790119d+00,
     |  -1.0575585060027d+00,-2.2791786354510d-01,-1.5197585116588d-02,
     |  -2.0620014677647d-04,-1.5649602764729d-07,-1.3785811165701d-14/
      data (pmn(lat,16,32), lat = 1,36)/
     |   5.3804451855240d-16, 1.8627103043555d-08, 4.2355359537752d-05,
     |   4.6322000900433d-03, 9.7986549493811d-02, 6.4975873632251d-01,
     |   1.5021891067907d+00, 6.1383205893427d-01,-1.1420050736048d+00,
     |   2.6413574284671d-01, 6.6586606184648d-01,-9.6358952048460d-01,
     |   6.2701615268217d-01, 1.6721529225772d-02,-5.9769530667086d-01,
     |   8.6196568775495d-01,-7.2910247917940d-01, 2.8234200978101d-01,
     |   2.8234200978102d-01,-7.2910247917940d-01, 8.6196568775494d-01,
     |  -5.9769530667086d-01, 1.6721529225771d-02, 6.2701615268216d-01,
     |  -9.6358952048460d-01, 6.6586606184648d-01, 2.6413574284671d-01,
     |  -1.1420050736048d+00, 6.1383205893427d-01, 1.5021891067907d+00,
     |   6.4975873632251d-01, 9.7986549493811d-02, 4.6322000900434d-03,
     |   4.2355359537753d-05, 1.8627103043555d-08, 5.3804451855240d-16/
      data (pmn(lat,17,32), lat = 1,36)/
     |   1.9368613012135d-17, 2.0414250879241d-09, 7.9796933402352d-06,
     |   1.2856039194148d-03, 3.7832077664440d-02, 3.4756013927661d-01,
     |   1.1967408734635d+00, 1.3082683412829d+00,-5.5431178346194d-01,
     |  -7.5701289920431d-01, 9.9995612495910d-01,-3.4736908138884d-01,
     |  -4.6679784239585d-01, 8.9048669053749d-01,-7.5818448744568d-01,
     |   2.2315493247475d-01, 4.0245910222347d-01,-8.0867168423906d-01,
     |   8.0867168423906d-01,-4.0245910222347d-01,-2.2315493247476d-01,
     |   7.5818448744568d-01,-8.9048669053749d-01, 4.6679784239586d-01,
     |   3.4736908138885d-01,-9.9995612495910d-01, 7.5701289920431d-01,
     |   5.5431178346194d-01,-1.3082683412829d+00,-1.1967408734635d+00,
     |  -3.4756013927661d-01,-3.7832077664440d-02,-1.2856039194148d-03,
     |  -7.9796933402355d-06,-2.0414250879241d-09,-1.9368613012135d-17/
      data (pmn(lat,18,32), lat = 1,36)/
     |   6.4395043991656d-19, 2.0633282143687d-10, 1.3820257370238d-06,
     |   3.2609566477349d-04, 1.3209495168113d-02, 1.6457555203971d-01,
     |   7.9631334967703d-01, 1.4891346242273d+00, 4.1658633234729d-01,
     |  -1.1312564731950d+00, 2.7180634050887d-01, 7.1044571466175d-01,
     |  -9.4275605435640d-01, 4.4083463803292d-01, 3.1430549452933d-01,
     |  -8.1986700001397d-01, 8.1122643119502d-01,-3.3250508561903d-01,
     |  -3.3250508561903d-01, 8.1122643119502d-01,-8.1986700001397d-01,
     |   3.1430549452933d-01, 4.4083463803292d-01,-9.4275605435640d-01,
     |   7.1044571466174d-01, 2.7180634050887d-01,-1.1312564731950d+00,
     |   4.1658633234729d-01, 1.4891346242273d+00, 7.9631334967704d-01,
     |   1.6457555203971d-01, 1.3209495168113d-02, 3.2609566477350d-04,
     |   1.3820257370239d-06, 2.0633282143687d-10, 6.4395043991656d-19/
      data (pmn(lat,19,32), lat = 1,36)/
     |   1.9786987431671d-20, 1.9250676710619d-11, 2.2035460485718d-07,
     |   7.5785442704061d-05, 4.1909486099522d-03, 6.9719322375057d-02,
     |   4.5749109861232d-01, 1.2737654678988d+00, 1.1806139884103d+00,
     |  -6.2072100858258d-01,-7.4386343563241d-01, 9.6579642209773d-01,
     |  -1.8277361187445d-01,-6.6664950400390d-01, 9.1057760505821d-01,
     |  -4.7359078689812d-01,-2.6859236037797d-01, 8.0924875481164d-01,
     |  -8.0924875481164d-01, 2.6859236037797d-01, 4.7359078689813d-01,
     |  -9.1057760505821d-01, 6.6664950400390d-01, 1.8277361187445d-01,
     |  -9.6579642209774d-01, 7.4386343563241d-01, 6.2072100858258d-01,
     |  -1.1806139884103d+00,-1.2737654678988d+00,-4.5749109861233d-01,
     |  -6.9719322375057d-02,-4.1909486099522d-03,-7.5785442704062d-05,
     |  -2.2035460485719d-07,-1.9250676710619d-11,-1.9786987431671d-20/
      data (pmn(lat,20,32), lat = 1,36)/
     |   5.6195283255764d-22, 1.6583020570992d-12, 3.2365435080414d-08,
     |   1.6160661872117d-05, 1.2119275155678d-03, 2.6605264683340d-02,
     |   2.3116693187573d-01, 8.9574214499603d-01, 1.4549316935737d+00,
     |   3.3131481421336d-01,-1.1135678308956d+00, 1.6911477900784d-01,
     |   8.2983194929573d-01,-8.5663787663163d-01, 9.6594812726502d-02,
     |   6.8914490619517d-01,-8.8539670072593d-01, 3.9336277462322d-01,
     |   3.9336277462322d-01,-8.8539670072594d-01, 6.8914490619516d-01,
     |   9.6594812726504d-02,-8.5663787663163d-01, 8.2983194929573d-01,
     |   1.6911477900785d-01,-1.1135678308956d+00, 3.3131481421335d-01,
     |   1.4549316935737d+00, 8.9574214499603d-01, 2.3116693187573d-01,
     |   2.6605264683340d-02, 1.2119275155678d-03, 1.6160661872117d-05,
     |   3.2365435080416d-08, 1.6583020570992d-12, 5.6195283255764d-22/
      data (pmn(lat,21,32), lat = 1,36)/
     |   1.4741394493278d-23, 1.3182866127460d-13, 4.3785172443737d-09,
     |   3.1635358126839d-06, 3.1997291700476d-04, 9.1846133690532d-03,
     |   1.0387418976771d-01, 5.3833346712126d-01, 1.3012076896706d+00,
     |   1.1214744674136d+00,-5.8837990687430d-01,-8.2482072150823d-01,
     |   8.7360344995934d-01, 1.2449506362472d-01,-8.9046879872241d-01,
     |   7.3058094391715d-01, 9.2026256764360d-02,-8.0706813961264d-01,
     |   8.0706813961264d-01,-9.2026256764357d-02,-7.3058094391715d-01,
     |   8.9046879872241d-01,-1.2449506362472d-01,-8.7360344995933d-01,
     |   8.2482072150822d-01, 5.8837990687430d-01,-1.1214744674136d+00,
     |  -1.3012076896706d+00,-5.3833346712126d-01,-1.0387418976771d-01,
     |  -9.1846133690532d-03,-3.1997291700476d-04,-3.1635358126840d-06,
     |  -4.3785172443740d-09,-1.3182866127460d-13,-1.4741394493278d-23/
      data (pmn(lat,22,32), lat = 1,36)/
     |   3.5669527000106d-25, 9.6591295366920d-15, 5.4504144720308d-10,
     |   5.6821789665683d-07, 7.7163394307603d-05, 2.8748770900535d-03,
     |   4.1780704158162d-02, 2.8213290380228d-01, 9.4160138191031d-01,
     |   1.4280879048097d+00, 3.7423757567160d-01,-1.0805217277385d+00,
     |  -7.4973397484045d-02, 9.7527120121238d-01,-5.8378623195446d-01,
     |  -4.3397979732866d-01, 9.3704241191331d-01,-4.6775589914112d-01,
     |  -4.6775589914112d-01, 9.3704241191331d-01,-4.3397979732865d-01,
     |  -5.8378623195446d-01, 9.7527120121237d-01,-7.4973397484054d-02,
     |  -1.0805217277385d+00, 3.7423757567160d-01, 1.4280879048097d+00,
     |   9.4160138191031d-01, 2.8213290380228d-01, 4.1780704158163d-02,
     |   2.8748770900535d-03, 7.7163394307603d-05, 5.6821789665685d-07,
     |   5.4504144720311d-10, 9.6591295366920d-15, 3.5669527000106d-25/
      data (pmn(lat,23,32), lat = 1,36)/
     |   7.9433382715089d-27, 6.5090548315969d-16, 6.2309582849137d-11,
     |   9.3503246564003d-08, 1.6983371892636d-05, 8.1636238972326d-04,
     |   1.5094580991864d-02, 1.3038145261848d-01, 5.7565175626623d-01,
     |   1.2896835223883d+00, 1.1502271140657d+00,-4.3431449396722d-01,
     |  -9.8109963164798d-01, 6.2853688440742d-01, 5.8006184568118d-01,
     |  -9.3974983354651d-01, 1.3581483949292d-01, 8.0041350049060d-01,
     |  -8.0041350049060d-01,-1.3581483949292d-01, 9.3974983354651d-01,
     |  -5.8006184568118d-01,-6.2853688440742d-01, 9.8109963164799d-01,
     |   4.3431449396723d-01,-1.1502271140657d+00,-1.2896835223883d+00,
     |  -5.7565175626623d-01,-1.3038145261848d-01,-1.5094580991864d-02,
     |  -8.1636238972326d-04,-1.6983371892636d-05,-9.3503246564006d-08,
     |  -6.2309582849141d-11,-6.5090548315969d-16,-7.9433382715089d-27/
      data (pmn(lat,24,32), lat = 1,36)/
     |   1.6226601575767d-28, 4.0212171316855d-17, 6.5221467505765d-12,
     |   1.4058476276180d-08, 3.4043018578764d-06, 2.1007462777029d-04,
     |   4.9028163145481d-03, 5.3432297304890d-02, 3.0357840710453d-01,
     |   9.2962911491375d-01, 1.4175075247368d+00, 5.6181848460317d-01,
     |  -9.6816331368013d-01,-4.8535113561738d-01, 9.8459350629865d-01,
     |   2.6467877564176d-02,-9.4223377528538d-01, 5.6024198548491d-01,
     |   5.6024198548491d-01,-9.4223377528538d-01, 2.6467877564169d-02,
     |   9.8459350629865d-01,-4.8535113561737d-01,-9.6816331368013d-01,
     |   5.6181848460316d-01, 1.4175075247368d+00, 9.2962911491375d-01,
     |   3.0357840710453d-01, 5.3432297304890d-02, 4.9028163145481d-03,
     |   2.1007462777029d-04, 3.4043018578764d-06, 1.4058476276181d-08,
     |   6.5221467505768d-12, 4.0212171316855d-17, 1.6226601575767d-28/
      data (pmn(lat,25,32), lat = 1,36)/
     |   3.0266515743210d-30, 2.2671416129909d-18, 6.2233641819340d-13,
     |   1.9233377160810d-09, 6.1919603260777d-07, 4.8847204914688d-05,
     |   1.4296860604691d-03, 1.9452478766088d-02, 1.3950162588061d-01,
     |   5.5892572323355d-01, 1.2356690716870d+00, 1.2611311962003d+00,
     |  -1.0143580653820d-01,-1.1126869446901d+00, 8.7983741484991d-02,
     |   1.0011627113150d+00,-4.2161872394919d-01,-7.8650380013072d-01,
     |   7.8650380013072d-01, 4.2161872394919d-01,-1.0011627113150d+00,
     |  -8.7983741484992d-02, 1.1126869446901d+00, 1.0143580653820d-01,
     |  -1.2611311962003d+00,-1.2356690716870d+00,-5.5892572323356d-01,
     |  -1.3950162588061d-01,-1.9452478766088d-02,-1.4296860604691d-03,
     |  -4.8847204914688d-05,-6.1919603260777d-07,-1.9233377160811d-09,
     |  -6.2233641819344d-13,-2.2671416129909d-18,-3.0266515743210d-30/
      data (pmn(lat,26,32), lat = 1,36)/
     |   5.1217646041961d-32, 1.1590950851864d-19, 5.3796340719550d-14,
     |   2.3799629992903d-10, 1.0161960598509d-07, 1.0211890930422d-05,
     |   3.7283278981782d-04, 6.2804001035363d-03, 5.6046450974553d-02,
     |   2.8569563806728d-01, 8.5056618885100d-01, 1.3982669894626d+00,
     |   8.9501755319456d-01,-6.2930959827739d-01,-9.7462281000545d-01,
     |   5.2271534092211d-01, 8.6083028377576d-01,-6.7895032187304d-01,
     |  -6.7895032187305d-01, 8.6083028377576d-01, 5.2271534092211d-01,
     |  -9.7462281000545d-01,-6.2930959827739d-01, 8.9501755319457d-01,
     |   1.3982669894626d+00, 8.5056618885100d-01, 2.8569563806728d-01,
     |   5.6046450974553d-02, 6.2804001035363d-03, 3.7283278981783d-04,
     |   1.0211890930422d-05, 1.0161960598509d-07, 2.3799629992904d-10,
     |   5.3796340719553d-14, 1.1590950851864d-19, 5.1217646041961d-32/
      data (pmn(lat,27,32), lat = 1,36)/
     |   7.7929653870097d-34, 5.3260399366743d-21, 4.1758653175353d-15,
     |   2.6408125016147d-11, 1.4923291992205d-08, 1.9044924319700d-06,
     |   8.6346369789406d-05, 1.7885732795683d-03, 1.9646488862237d-02,
     |   1.2496132754863d-01, 4.8049197051491d-01, 1.1113653844027d+00,
     |   1.3963166267356d+00, 4.7118298884374d-01,-9.4352344236840d-01,
     |  -7.5190154795343d-01, 7.6474363590600d-01, 7.6036301030340d-01,
     |  -7.6036301030339d-01,-7.6474363590600d-01, 7.5190154795343d-01,
     |   9.4352344236840d-01,-4.7118298884374d-01,-1.3963166267356d+00,
     |  -1.1113653844027d+00,-4.8049197051491d-01,-1.2496132754863d-01,
     |  -1.9646488862237d-02,-1.7885732795683d-03,-8.6346369789407d-05,
     |  -1.9044924319700d-06,-1.4923291992205d-08,-2.6408125016148d-11,
     |  -4.1758653175355d-15,-5.3260399366743d-21,-7.7929653870097d-34/
      data (pmn(lat,28,32), lat = 1,36)/
     |   1.0525207400351d-35, 2.1715633037758d-22, 2.8739885474323d-16,
     |   2.5948100695171d-12, 1.9370837564388d-09, 3.1310851380126d-07,
     |   1.7561383823597d-05, 4.4481013143936d-04, 5.9624610349423d-03,
     |   4.6649352454992d-02, 2.2552417570395d-01, 6.8847441664670d-01,
     |   1.2939385058543d+00, 1.2920862419621d+00, 1.3122372648230d-01,
     |  -1.0875101705211d+00,-6.2121058847327d-01, 8.4103046945361d-01,
     |   8.4103046945361d-01,-6.2121058847327d-01,-1.0875101705211d+00,
     |   1.3122372648230d-01, 1.2920862419621d+00, 1.2939385058543d+00,
     |   6.8847441664671d-01, 2.2552417570395d-01, 4.6649352454993d-02,
     |   5.9624610349424d-03, 4.4481013143936d-04, 1.7561383823597d-05,
     |   3.1310851380126d-07, 1.9370837564388d-09, 2.5948100695172d-12,
     |   2.8739885474325d-16, 2.1715633037758d-22, 1.0525207400351d-35/
      data (pmn(lat,29,32), lat = 1,36)/
     |   1.2377557336100d-37, 7.7067498670177d-24, 1.7204872164402d-17,
     |   2.2152176916303d-13, 2.1810426966871d-10, 4.4548610766415d-08,
     |   3.0808653546394d-06, 9.4972740603542d-05, 1.5427392994705d-03,
     |   1.4685615510989d-02, 8.7607889818035d-02, 3.4010149294296d-01,
     |   8.6653213667957d-01, 1.3962454640703d+00, 1.1945384828413d+00,
     |  -3.0601735370425d-02,-1.1411701859253d+00,-7.1147171064678d-01,
     |   7.1147171064678d-01, 1.1411701859253d+00, 3.0601735370431d-02,
     |  -1.1945384828413d+00,-1.3962454640703d+00,-8.6653213667957d-01,
     |  -3.4010149294296d-01,-8.7607889818035d-02,-1.4685615510989d-02,
     |  -1.5427392994705d-03,-9.4972740603543d-05,-3.0808653546394d-06,
     |  -4.4548610766415d-08,-2.1810426966871d-10,-2.2152176916304d-13,
     |  -1.7204872164403d-17,-7.7067498670177d-24,-1.2377557336100d-37/
      data (pmn(lat,30,32), lat = 1,36)/
     |   1.2284608547824d-39, 2.3076008642785d-25, 8.6843248352000d-19,
     |   1.5929829485209d-14, 2.0655320734708d-11, 5.3203277699027d-09,
     |   4.5239390501658d-07, 1.6905111084198d-05, 3.3086837311505d-04,
     |   3.7991342909168d-03, 2.7583285261759d-02, 1.3289612767233d-01,
     |   4.3635897357992d-01, 9.7966934549992d-01, 1.4514500133584d+00,
     |   1.2167286139197d+00, 7.2577204052303d-02,-1.0953806546772d+00,
     |  -1.0953806546772d+00, 7.2577204052301d-02, 1.2167286139197d+00,
     |   1.4514500133584d+00, 9.7966934549992d-01, 4.3635897357992d-01,
     |   1.3289612767233d-01, 2.7583285261759d-02, 3.7991342909168d-03,
     |   3.3086837311506d-04, 1.6905111084198d-05, 4.5239390501659d-07,
     |   5.3203277699027d-09, 2.0655320734708d-11, 1.5929829485210d-14,
     |   8.6843248352006d-19, 2.3076008642785d-25, 1.2284608547824d-39/
      data (pmn(lat,31,32), lat = 1,36)/
     |   9.7109421949815d-42, 5.5018000700481d-27, 3.4884241945728d-20,
     |   9.1080191915577d-16, 1.5532928095113d-12, 5.0362934315421d-10,
     |   5.2523050737424d-08, 2.3710249562829d-06, 5.5644612097423d-05,
     |   7.6533093437505d-04, 6.6914760595877d-03, 3.9330546260007d-02,
     |   1.6136552316686d-01, 4.7263283725584d-01, 9.9484371518170d-01,
     |   1.4790135926899d+00, 1.4375790267665d+00, 6.0879075964259d-01,
     |  -6.0879075964259d-01,-1.4375790267665d+00,-1.4790135926899d+00,
     |  -9.9484371518170d-01,-4.7263283725584d-01,-1.6136552316686d-01,
     |  -3.9330546260008d-02,-6.6914760595877d-03,-7.6533093437505d-04,
     |  -5.5644612097423d-05,-2.3710249562829d-06,-5.2523050737425d-08,
     |  -5.0362934315421d-10,-1.5532928095113d-12,-9.1080191915580d-16,
     |  -3.4884241945731d-20,-5.5018000700481d-27,-9.7109421949815d-42/
      data (pmn(lat,32,32), lat = 1,36)/
     |   5.2998611595367d-44, 9.0540715056042d-29, 9.6670628121411d-22,
     |   3.5896842752308d-17, 8.0424368504525d-14, 3.2771605217137d-11,
     |   4.1826092039620d-09, 2.2741892976594d-07, 6.3736115913720d-06,
     |   1.0440151935185d-04, 1.0900626728268d-03, 7.7170739005607d-03,
     |   3.8747535739111d-02, 1.4262957571574d-01, 3.9440514452925d-01,
     |   8.3392489869727d-01, 1.3649371006161d+00, 1.7429501033632d+00,
     |   1.7429501033632d+00, 1.3649371006161d+00, 8.3392489869727d-01,
     |   3.9440514452925d-01, 1.4262957571574d-01, 3.8747535739111d-02,
     |   7.7170739005608d-03, 1.0900626728268d-03, 1.0440151935185d-04,
     |   6.3736115913720d-06, 2.2741892976594d-07, 4.1826092039620d-09,
     |   3.2771605217137d-11, 8.0424368504525d-14, 3.5896842752310d-17,
     |   9.6670628121419d-22, 9.0540715056042d-29, 5.2998611595367d-44/
      data (pmn(lat, 0,33), lat = 1,36)/
     |   3.0857568139367d+00,-2.0008744336860d+00, 1.6705127487718d+00,
     |  -1.4540644016122d+00, 1.2622241652909d+00,-1.0710589237091d+00,
     |   8.7387514985466d-01,-6.7042130137669d-01, 4.6338794716617d-01,
     |  -2.5695101070096d-01, 5.6025026095148d-02, 1.3419548380584d-01,
     |  -3.0856051855733d-01, 4.6221640745745d-01,-5.9081034116559d-01,
     |   6.9065789098787d-01,-7.5887709900515d-01, 7.9348981112498d-01,
     |  -7.9348981112498d-01, 7.5887709900515d-01,-6.9065789098786d-01,
     |   5.9081034116558d-01,-4.6221640745744d-01, 3.0856051855734d-01,
     |  -1.3419548380583d-01,-5.6025026095148d-02, 2.5695101070097d-01,
     |  -4.6338794716618d-01, 6.7042130137669d-01,-8.7387514985466d-01,
     |   1.0710589237091d+00,-1.2622241652909d+00, 1.4540644016122d+00,
     |  -1.6705127487718d+00, 2.0008744336860d+00,-3.0857568139367d+00/
      data (pmn(lat, 1,33), lat = 1,36)/
     |   3.1969504922322d+00,-1.1488002239672d+00, 4.9226230386093d-01,
     |  -8.3295577973526d-02,-2.1768517555989d-01, 4.5007243703034d-01,
     |  -6.2850460962424d-01, 7.5928347036072d-01,-8.4561103391374d-01,
     |   8.8967072366177d-01,-8.9357420718416d-01, 8.5982178388406d-01,
     |  -7.9152141684579d-01, 6.9247176409979d-01,-5.6715989884795d-01,
     |   4.2070108178864d-01,-2.5873737233798d-01, 8.7306885073698d-02,
     |   8.7306885073702d-02,-2.5873737233798d-01, 4.2070108178865d-01,
     |  -5.6715989884795d-01, 6.9247176409979d-01,-7.9152141684579d-01,
     |   8.5982178388406d-01,-8.9357420718416d-01, 8.8967072366177d-01,
     |  -8.4561103391374d-01, 7.5928347036072d-01,-6.2850460962423d-01,
     |   4.5007243703034d-01,-2.1768517555989d-01,-8.3295577973546d-02,
     |   4.9226230386096d-01,-1.1488002239672d+00, 3.1969504922322d+00/
      data (pmn(lat, 2,33), lat = 1,36)/
     |   1.2873529604052d+00, 1.4811816490390d+00,-1.5393062392810d+00,
     |   1.4395743302579d+00,-1.2947575811972d+00, 1.1236834035109d+00,
     |  -9.3361296288815d-01, 7.3015460513571d-01,-5.1895069512342d-01,
     |   3.0589982027902d-01,-9.7051263978230d-02,-1.0157991496432d-01,
     |   2.8421179815698d-01,-4.4548747401425d-01, 5.8065078751720d-01,
     |  -6.8570049441513d-01, 7.5751868684451d-01,-7.9397016351804d-01,
     |   7.9397016351804d-01,-7.5751868684450d-01, 6.8570049441512d-01,
     |  -5.8065078751720d-01, 4.4548747401424d-01,-2.8421179815699d-01,
     |   1.0157991496430d-01, 9.7051263978230d-02,-3.0589982027902d-01,
     |   5.1895069512342d-01,-7.3015460513571d-01, 9.3361296288816d-01,
     |  -1.1236834035109d+00, 1.2947575811972d+00,-1.4395743302579d+00,
     |   1.5393062392810d+00,-1.4811816490390d+00,-1.2873529604052d+00/
      data (pmn(lat, 3,33), lat = 1,36)/
     |   3.2779446928278d-01, 2.4979797397465d+00,-1.3245200939433d+00,
     |   6.3013290138134d-01,-1.5620111052358d-01,-1.9241719917725d-01,
     |   4.5415811254707d-01,-6.4670664023742d-01, 7.7931389469287d-01,
     |  -8.5770078190660d-01, 8.8625735124783d-01,-8.6910990182061d-01,
     |   8.1065387020823d-01,-7.1580632240498d-01, 5.9009665030109d-01,
     |  -4.3965628847591d-01, 2.7114190993980d-01,-9.1613945795076d-02,
     |  -9.1613945795080d-02, 2.7114190993980d-01,-4.3965628847592d-01,
     |   5.9009665030109d-01,-7.1580632240498d-01, 8.1065387020823d-01,
     |  -8.6910990182062d-01, 8.8625735124783d-01,-8.5770078190660d-01,
     |   7.7931389469286d-01,-6.4670664023741d-01, 4.5415811254706d-01,
     |  -1.9241719917725d-01,-1.5620111052358d-01, 6.3013290138135d-01,
     |  -1.3245200939434d+00, 2.4979797397465d+00, 3.2779446928278d-01/
      data (pmn(lat, 4,33), lat = 1,36)/
     |   6.1239580144449d-02, 1.9318566765728d+00, 4.6750847958283d-01,
     |  -1.0835451034531d+00, 1.2303397340662d+00,-1.1932829844756d+00,
     |   1.0645164273842d+00,-8.8390605616278d-01, 6.7351291232507d-01,
     |  -4.4826508343232d-01, 2.1978331465749d-01, 2.1410833744468d-03,
     |  -2.0898094947792d-01, 3.9329376319152d-01,-5.4871102464419d-01,
     |   6.6999796106103d-01,-7.5313468857959d-01, 7.9539278532574d-01,
     |  -7.9539278532574d-01, 7.5313468857958d-01,-6.6999796106102d-01,
     |   5.4871102464419d-01,-3.9329376319151d-01, 2.0898094947793d-01,
     |  -2.1410833744330d-03,-2.1978331465749d-01, 4.4826508343233d-01,
     |  -6.7351291232508d-01, 8.8390605616278d-01,-1.0645164273842d+00,
     |   1.1932829844756d+00,-1.2303397340662d+00, 1.0835451034531d+00,
     |  -4.6750847958280d-01,-1.9318566765728d+00,-6.1239580144449d-02/
      data (pmn(lat, 5,33), lat = 1,36)/
     |   9.0346639371990d-03, 1.0292361080559d+00, 1.8375176725434d+00,
     |  -1.4605943642832d+00, 8.7258062461325d-01,-3.5930126960775d-01,
     |  -5.3119756163727d-02, 3.7144635907977d-01,-6.0500728817457d-01,
     |   7.6181948879285d-01,-8.4882650366556d-01, 8.7258757649412d-01,
     |  -8.3980800554700d-01, 7.5765895236587d-01,-6.3392788378598d-01,
     |   4.7704470800239d-01,-2.9601897623583d-01, 1.0031488878768d-01,
     |   1.0031488878769d-01,-2.9601897623583d-01, 4.7704470800240d-01,
     |  -6.3392788378598d-01, 7.5765895236587d-01,-8.3980800554700d-01,
     |   8.7258757649413d-01,-8.4882650366556d-01, 7.6181948879285d-01,
     |  -6.0500728817457d-01, 3.7144635907976d-01,-5.3119756163714d-02,
     |  -3.5930126960775d-01, 8.7258062461325d-01,-1.4605943642832d+00,
     |   1.8375176725434d+00, 1.0292361080559d+00, 9.0346639371990d-03/
      data (pmn(lat, 6,33), lat = 1,36)/
     |   1.0998662382792d-03, 4.2509927075585d-01, 2.0385719890122d+00,
     |  -3.1333701066472d-01,-5.9847537633167d-01, 9.8986683652886d-01,
     |  -1.0946118126704d+00, 1.0344327852618d+00,-8.7639035190847d-01,
     |   6.6156120090696d-01,-4.1788801829048d-01, 1.6607200559886d-01,
     |   7.7640051450223d-02,-3.0012038564203d-01, 4.9073227291366d-01,
     |  -6.4105481894032d-01, 7.4478189467323d-01,-7.9770099326547d-01,
     |   7.9770099326547d-01,-7.4478189467323d-01, 6.4105481894032d-01,
     |  -4.9073227291365d-01, 3.0012038564202d-01,-7.7640051450234d-02,
     |  -1.6607200559888d-01, 4.1788801829048d-01,-6.6156120090696d-01,
     |   8.7639035190847d-01,-1.0344327852618d+00, 1.0946118126704d+00,
     |  -9.8986683652886d-01, 5.9847537633167d-01, 3.1333701066474d-01,
     |  -2.0385719890122d+00,-4.2509927075585d-01,-1.0998662382792d-03/
      data (pmn(lat, 7,33), lat = 1,36)/
     |   1.1376341884810d-04, 1.4410737381046d-01, 1.5099888959445d+00,
     |   1.1058099306740d+00,-1.4049985678657d+00, 1.0556275276551d+00,
     |  -5.7398255780736d-01, 1.1875192438710d-01, 2.5912678220209d-01,
     |  -5.4468384296424d-01, 7.3644188783143d-01,-8.3878936542505d-01,
     |   8.5921886499217d-01,-8.0724957161388d-01, 6.9393839497550d-01,
     |  -5.3158194915980d-01, 3.3346265606747d-01,-1.1358817953842d-01,
     |  -1.1358817953842d-01, 3.3346265606748d-01,-5.3158194915981d-01,
     |   6.9393839497550d-01,-8.0724957161388d-01, 8.5921886499218d-01,
     |  -8.3878936542504d-01, 7.3644188783143d-01,-5.4468384296424d-01,
     |   2.5912678220208d-01, 1.1875192438711d-01,-5.7398255780737d-01,
     |   1.0556275276551d+00,-1.4049985678657d+00, 1.1058099306740d+00,
     |   1.5099888959445d+00, 1.4410737381046d-01, 1.1376341884810d-04/
      data (pmn(lat, 8,33), lat = 1,36)/
     |   1.0207044604929d-05, 4.1478872526543d-02, 8.6865739809072d-01,
     |   1.8192485813164d+00,-8.5206487398286d-01,-1.2681791202299d-01,
     |   7.1544414740734d-01,-9.7484284369507d-01, 1.0033841736740d+00,
     |  -8.7990731252958d-01, 6.6293152739769d-01,-3.9629305372664d-01,
     |   1.1364352617147d-01, 1.5870704150062d-01,-4.0012480571191d-01,
     |   5.9471766255950d-01,-7.3083203020275d-01, 8.0079554295415d-01,
     |  -8.0079554295415d-01, 7.3083203020275d-01,-5.9471766255949d-01,
     |   4.0012480571191d-01,-1.5870704150061d-01,-1.1364352617146d-01,
     |   3.9629305372665d-01,-6.6293152739769d-01, 8.7990731252959d-01,
     |  -1.0033841736740d+00, 9.7484284369507d-01,-7.1544414740734d-01,
     |   1.2681791202299d-01, 8.5206487398286d-01,-1.8192485813164d+00,
     |  -8.6865739809073d-01,-4.1478872526543d-02,-1.0207044604929d-05/
      data (pmn(lat, 9,33), lat = 1,36)/
     |   8.0668799878339d-07, 1.0367857024027d-02, 4.1327213841385d-01,
     |   1.7348139331194d+00, 3.9994360315905d-01,-1.1839299212415d+00,
     |   1.1328547830223d+00,-7.4695931822614d-01, 2.7958614997647d-01,
     |   1.5069745911370d-01,-4.9085777663536d-01, 7.2049540459452d-01,
     |  -8.3652952471475d-01, 8.4583659130868d-01,-7.6149910954265d-01,
     |   6.0071834644521d-01,-3.8350229372581d-01, 1.3171428815665d-01,
     |   1.3171428815665d-01,-3.8350229372581d-01, 6.0071834644522d-01,
     |  -7.6149910954265d-01, 8.4583659130868d-01,-8.3652952471476d-01,
     |   7.2049540459451d-01,-4.9085777663536d-01, 1.5069745911370d-01,
     |   2.7958614997647d-01,-7.4695931822614d-01, 1.1328547830223d+00,
     |  -1.1839299212415d+00, 3.9994360315905d-01, 1.7348139331194d+00,
     |   4.1327213841385d-01, 1.0367857024027d-02, 8.0668799878339d-07/
      data (pmn(lat,10,33), lat = 1,36)/
     |   5.6822948431114d-08, 2.2867529006099d-03, 1.6831211988955d-01,
     |   1.2478815634951d+00, 1.4004757974538d+00,-1.1464111037541d+00,
     |   2.7471101757260d-01, 4.3786493060334d-01,-8.4113626300654d-01,
     |   9.6492103812356d-01,-8.7972987203452d-01, 6.5692245548966d-01,
     |  -3.5863075718833d-01, 3.6225328339202d-02, 2.6906756587031d-01,
     |  -5.2526112427348d-01, 7.0888822345315d-01,-8.0452678989876d-01,
     |   8.0452678989876d-01,-7.0888822345315d-01, 5.2526112427347d-01,
     |  -2.6906756587031d-01,-3.6225328339204d-02, 3.5863075718832d-01,
     |  -6.5692245548967d-01, 8.7972987203452d-01,-9.6492103812356d-01,
     |   8.4113626300654d-01,-4.3786493060333d-01,-2.7471101757261d-01,
     |   1.1464111037541d+00,-1.4004757974538d+00,-1.2478815634951d+00,
     |  -1.6831211988956d-01,-2.2867529006099d-03,-5.6822948431114d-08/
      data (pmn(lat,11,33), lat = 1,36)/
     |   3.6003451773373d-09, 4.5037700056079d-04, 5.9973419432811d-02,
     |   7.3635912887513d-01, 1.7217701743184d+00,-1.8896183650756d-01,
     |  -8.7289487737314d-01, 1.1130604392600d+00,-8.5943874429841d-01,
     |   4.0370446833008d-01, 7.1290110335382d-02,-4.6446777521315d-01,
     |   7.2738333537043d-01,-8.4472019197045d-01, 8.2232335210440d-01,
     |  -6.7983522809488d-01, 4.4594742431923d-01,-1.5509322241880d-01,
     |  -1.5509322241880d-01, 4.4594742431923d-01,-6.7983522809489d-01,
     |   8.2232335210440d-01,-8.4472019197045d-01, 7.2738333537043d-01,
     |  -4.6446777521314d-01, 7.1290110335382d-02, 4.0370446833008d-01,
     |  -8.5943874429842d-01, 1.1130604392600d+00,-8.7289487737313d-01,
     |  -1.8896183650756d-01, 1.7217701743184d+00, 7.3635912887514d-01,
     |   5.9973419432813d-02, 4.5037700056079d-04, 3.6003451773373d-09/
      data (pmn(lat,12,33), lat = 1,36)/
     |   2.0669516158786d-10, 7.9928829533113d-05, 1.8979028003909d-02,
     |   3.7127765139002d-01, 1.4904526392145d+00, 9.0527264953522d-01,
     |  -1.2357778860632d+00, 5.7154276185393d-01, 1.9463670075784d-01,
     |  -7.1692833960367d-01, 9.2769947757142d-01,-8.7107553875681d-01,
     |   6.2734921869433d-01,-2.8127396061246d-01,-9.0752381138325d-02,
     |   4.2568388534771d-01,-6.7567103750620d-01, 8.0868217439937d-01,
     |  -8.0868217439937d-01, 6.7567103750620d-01,-4.2568388534770d-01,
     |   9.0752381138322d-02, 2.8127396061246d-01,-6.2734921869433d-01,
     |   8.7107553875681d-01,-9.2769947757142d-01, 7.1692833960367d-01,
     |  -1.9463670075783d-01,-5.7154276185394d-01, 1.2357778860632d+00,
     |  -9.0527264953522d-01,-1.4904526392145d+00,-3.7127765139002d-01,
     |  -1.8979028003909d-02,-7.9928829533113d-05,-2.0669516158786d-10/
      data (pmn(lat,13,33), lat = 1,36)/
     |   1.0814617266856d-11, 1.2872754228929d-05, 5.3922203613378d-03,
     |   1.6383290906566d-01, 1.0355119010451d+00, 1.5341382896130d+00,
     |  -6.1420390141626d-01,-5.5163945439326d-01, 1.0340687999014d+00,
     |  -9.1597234001941d-01, 4.7751040007401d-01, 4.1687359738736d-02,
     |  -4.8418483418870d-01, 7.6518362279124d-01,-8.5457133483094d-01,
     |   7.6110131794347d-01,-5.2014213928946d-01, 1.8427228259622d-01,
     |   1.8427228259623d-01,-5.2014213928947d-01, 7.6110131794347d-01,
     |  -8.5457133483094d-01, 7.6518362279124d-01,-4.8418483418871d-01,
     |   4.1687359738723d-02, 4.7751040007401d-01,-9.1597234001942d-01,
     |   1.0340687999014d+00,-5.5163945439325d-01,-6.1420390141627d-01,
     |   1.5341382896130d+00, 1.0355119010451d+00, 1.6383290906566d-01,
     |   5.3922203613379d-03, 1.2872754228929d-05, 1.0814617266856d-11/
      data (pmn(lat,14,33), lat = 1,36)/
     |   5.1809753016879d-13, 1.8918801325703d-06, 1.3866094581805d-03,
     |   6.4267087126674d-02, 6.0909650078950d-01, 1.5814713949867d+00,
     |   4.3516357405244d-01,-1.1890483422587d+00, 7.5967765976257d-01,
     |   1.4998198814795d-02,-6.2971933363423d-01, 9.0556185703348d-01,
     |  -8.4971179332654d-01, 5.5391890450616d-01,-1.3649785271822d-01,
     |  -2.8844155628251d-01, 6.2688051894131d-01,-8.1296699418012d-01,
     |   8.1296699418012d-01,-6.2688051894130d-01, 2.8844155628250d-01,
     |   1.3649785271822d-01,-5.5391890450616d-01, 8.4971179332654d-01,
     |  -9.0556185703348d-01, 6.2971933363423d-01,-1.4998198814792d-02,
     |  -7.5967765976258d-01, 1.1890483422587d+00,-4.3516357405243d-01,
     |  -1.5814713949867d+00,-6.0909650078950d-01,-6.4267087126675d-02,
     |  -1.3866094581805d-03,-1.8918801325703d-06,-5.1809753016879d-13/
      data (pmn(lat,15,33), lat = 1,36)/
     |   2.2810942090396d-14, 2.5484019662448d-07, 3.2471587382268d-04,
     |   2.2655946817151d-02, 3.1210946750805d-01, 1.2592197547567d+00,
     |   1.2568850006317d+00,-8.7670126925743d-01,-2.8115695328438d-01,
     |   9.4266944811210d-01,-9.3279560593813d-01, 4.9256949528108d-01,
     |   8.1443209047660d-02,-5.6410990019821d-01, 8.2768728872913d-01,
     |  -8.3198550418508d-01, 6.0458633160328d-01,-2.1998954459169d-01,
     |  -2.1998954459169d-01, 6.0458633160328d-01,-8.3198550418509d-01,
     |   8.2768728872912d-01,-5.6410990019821d-01, 8.1443209047669d-02,
     |   4.9256949528109d-01,-9.3279560593813d-01, 9.4266944811210d-01,
     |  -2.8115695328437d-01,-8.7670126925743d-01, 1.2568850006317d+00,
     |   1.2592197547567d+00, 3.1210946750805d-01, 2.2655946817152d-02,
     |   3.2471587382269d-04, 2.5484019662448d-07, 2.2810942090396d-14/
      data (pmn(lat,16,33), lat = 1,36)/
     |   9.2569675209514d-16, 3.1569861722317d-08, 6.9575005945214d-05,
     |   7.2340736114472d-03, 1.4178017379665d-01, 8.3535475490720d-01,
     |   1.5504419258093d+00, 5.4962141464354d-02,-1.0824333842277d+00,
     |   8.5731600633780d-01,-8.2686724873336d-02,-6.0384653210730d-01,
     |   9.0686892396519d-01,-7.9929475763767d-01, 4.0241813085417d-01,
     |   1.0698665695777d-01,-5.5704920987929d-01, 8.1697488799687d-01,
     |  -8.1697488799687d-01, 5.5704920987929d-01,-1.0698665695776d-01,
     |  -4.0241813085417d-01, 7.9929475763767d-01,-9.0686892396520d-01,
     |   6.0384653210729d-01, 8.2686724873336d-02,-8.5731600633780d-01,
     |   1.0824333842277d+00,-5.4962141464349d-02,-1.5504419258093d+00,
     |  -8.3535475490720d-01,-1.4178017379665d-01,-7.2340736114473d-03,
     |  -6.9575005945217d-05,-3.1569861722317d-08,-9.2569675209514d-16/
      data (pmn(lat,17,33), lat = 1,36)/
     |   3.4701262312161d-17, 3.6060429927322d-09, 1.3688084952959d-05,
     |   2.1041612833046d-03, 5.7761598488614d-02, 4.7860216363220d-01,
     |   1.3908885946432d+00, 9.7166972639624d-01,-1.0101494628794d+00,
     |  -9.7998477574551d-02, 8.8055221237399d-01,-9.2399092036830d-01,
     |   4.3519531334119d-01, 2.1124132343629d-01,-7.0385886780359d-01,
     |   8.7353479101233d-01,-6.9635557911605d-01, 2.6324321973310d-01,
     |   2.6324321973310d-01,-6.9635557911605d-01, 8.7353479101233d-01,
     |  -7.0385886780359d-01, 2.1124132343629d-01, 4.3519531334118d-01,
     |  -9.2399092036830d-01, 8.8055221237399d-01,-9.7998477574548d-02,
     |  -1.0101494628794d+00, 9.7166972639623d-01, 1.3908885946432d+00,
     |   4.7860216363220d-01, 5.7761598488614d-02, 2.1041612833046d-03,
     |   1.3688084952959d-05, 3.6060429927322d-09, 3.4701262312161d-17/
      data (pmn(lat,18,33), lat = 1,36)/
     |   1.2035210755742d-18, 3.8049863945815d-10, 2.4791299677442d-06,
     |   5.5986423588668d-04, 2.1273527849300d-02, 2.4170808372585d-01,
     |   1.0161833490996d+00, 1.4511084935552d+00,-2.0734628813140d-01,
     |  -9.8187674493615d-01, 8.8860170074069d-01,-8.4331946554707d-02,
     |  -6.5592275961380d-01, 9.1992146208244d-01,-6.7486087892158d-01,
     |   1.2130632587477d-01, 4.5941857150390d-01,-8.2014156502673d-01,
     |   8.2014156502673d-01,-4.5941857150390d-01,-1.2130632587478d-01,
     |   6.7486087892158d-01,-9.1992146208244d-01, 6.5592275961381d-01,
     |   8.4331946554720d-02,-8.8860170074069d-01, 9.8187674493615d-01,
     |   2.0734628813140d-01,-1.4511084935552d+00,-1.0161833490996d+00,
     |  -2.4170808372585d-01,-2.1273527849300d-02,-5.5986423588670d-04,
     |  -2.4791299677443d-06,-3.8049863945815d-10,-1.2035210755742d-18/
      data (pmn(lat,19,33), lat = 1,36)/
     |   3.8655844456412d-20, 3.7133278473686d-11, 4.1408836001868d-07,
     |   1.3666985031534d-04, 7.1223687646712d-03, 1.0898539116001d-01,
     |   6.3345570636327d-01, 1.4438283542937d+00, 7.4152280008506d-01,
     |  -1.0595162066762d+00,-2.1736664925145d-02, 8.7582090118655d-01,
     |  -8.8525865361054d-01, 2.7510708992715d-01, 4.4564005751690d-01,
     |  -8.5880069178715d-01, 7.9020783560999d-01,-3.1540649438113d-01,
     |  -3.1540649438113d-01, 7.9020783560999d-01,-8.5880069178715d-01,
     |   4.4564005751690d-01, 2.7510708992715d-01,-8.8525865361054d-01,
     |   8.7582090118655d-01,-2.1736664925145d-02,-1.0595162066762d+00,
     |   7.4152280008506d-01, 1.4438283542937d+00, 6.3345570636328d-01,
     |   1.0898539116001d-01, 7.1223687646712d-03, 1.3666985031535d-04,
     |   4.1408836001869d-07, 3.7133278473686d-11, 3.8655844456412d-20/
      data (pmn(lat,20,33), lat = 1,36)/
     |   1.1502614072569d-21, 3.3535980178612d-12, 6.3850968701700d-08,
     |   3.0667600802883d-05, 2.1758566877063d-03, 4.4240692093705d-02,
     |   3.4522958761991d-01, 1.1371216964094d+00, 1.3414847724736d+00,
     |  -3.4767844799501d-01,-9.3433934195403d-01, 8.6483118857998d-01,
     |   2.9631014114320d-02,-7.8421601494655d-01, 8.8794040929280d-01,
     |  -3.8997450135203d-01,-3.2590748810708d-01, 8.2166948991908d-01,
     |  -8.2166948991908d-01, 3.2590748810708d-01, 3.8997450135204d-01,
     |  -8.8794040929280d-01, 7.8421601494655d-01,-2.9631014114329d-02,
     |  -8.6483118857999d-01, 9.3433934195403d-01, 3.4767844799501d-01,
     |  -1.3414847724736d+00,-1.1371216964093d+00,-3.4522958761991d-01,
     |  -4.4240692093705d-02,-2.1758566877063d-03,-3.0667600802884d-05,
     |  -6.3850968701703d-08,-3.3535980178612d-12,-1.1502614072569d-21/
      data (pmn(lat,21,33), lat = 1,36)/
     |   3.1703329265968d-23, 2.8026604171891d-13, 9.0918504309529d-09,
     |   6.3319030898138d-06, 6.0796803074418d-04, 1.6255584498012d-02,
     |   1.6685790624120d-01, 7.5287424706812d-01, 1.4478089745284d+00,
     |   6.0830961545867d-01,-1.0600246245781d+00,-6.8644264034138d-02,
     |   9.3341736697894d-01,-7.7323744507557d-01,-3.5494234514132d-02,
     |   7.5240725243121d-01,-8.7718511645537d-01, 3.7842833202500d-01,
     |   3.7842833202500d-01,-8.7718511645537d-01, 7.5240725243121d-01,
     |  -3.5494234514129d-02,-7.7323744507557d-01, 9.3341736697895d-01,
     |  -6.8644264034127d-02,-1.0600246245781d+00, 6.0830961545867d-01,
     |   1.4478089745284d+00, 7.5287424706812d-01, 1.6685790624121d-01,
     |   1.6255584498012d-02, 6.0796803074418d-04, 6.3319030898140d-06,
     |   9.0918504309534d-09, 2.8026604171891d-13, 3.1703329265968d-23/
      data (pmn(lat,22,33), lat = 1,36)/
     |   8.0866646906220d-25, 2.1658394653399d-14, 1.1949723784428d-09,
     |   1.2030513621220d-06, 1.5555102186583d-04, 5.4242391363322d-03,
     |   7.2145496589207d-02, 4.3131028311601d-01, 1.1995595961028d+00,
     |   1.2698558482919d+00,-3.6615164938182d-01,-9.6341805398601d-01,
     |   7.6382360011694d-01, 2.8516558766147d-01,-9.3405339579504d-01,
     |   6.7489166651706d-01, 1.4731922117311d-01,-8.2039848720978d-01,
     |   8.2039848720978d-01,-1.4731922117311d-01,-6.7489166651706d-01,
     |   9.3405339579504d-01,-2.8516558766147d-01,-7.6382360011694d-01,
     |   9.6341805398600d-01, 3.6615164938182d-01,-1.2698558482919d+00,
     |  -1.1995595961028d+00,-4.3131028311601d-01,-7.2145496589207d-02,
     |  -5.4242391363322d-03,-1.5555102186583d-04,-1.2030513621220d-06,
     |  -1.1949723784429d-09,-2.1658394653399d-14,-8.0866646906220d-25/
      data (pmn(lat,23,33), lat = 1,36)/
     |   1.9059387178791d-26, 1.5454069594868d-15, 1.4479447365528d-10,
     |   2.1017828961379d-07, 3.6442839952729d-05, 1.6463203253015d-03,
     |   2.8048907374477d-02, 2.1718816870932d-01, 8.2214312387313d-01,
     |   1.4331971189188d+00, 5.9914435497010d-01,-1.0170354695506d+00,
     |  -2.6127136731384d-01, 1.0097802057083d+00,-4.8536314265966d-01,
     |  -5.1356779927678d-01, 9.4235641677911d-01,-4.5521149658218d-01,
     |  -4.5521149658218d-01, 9.4235641677911d-01,-5.1356779927678d-01,
     |  -4.8536314265966d-01, 1.0097802057082d+00,-2.6127136731384d-01,
     |  -1.0170354695506d+00, 5.9914435497010d-01, 1.4331971189188d+00,
     |   8.2214312387314d-01, 2.1718816870932d-01, 2.8048907374477d-02,
     |   1.6463203253015d-03, 3.6442839952729d-05, 2.1017828961379d-07,
     |   1.4479447365528d-10, 1.5454069594868d-15, 1.9059387178791d-26/
      data (pmn(lat,24,33), lat = 1,36)/
     |   4.1407441645868d-28, 1.0158127309066d-16, 1.6140370357241d-11,
     |   3.3703812524060d-08, 7.8091916847377d-06, 4.5451150312869d-04,
     |   9.8297586474828d-03, 9.6974580274410d-02, 4.8165919527435d-01,
     |   1.2102378993931d+00, 1.2664327744144d+00,-2.4683283290973d-01,
     |  -1.0560994755718d+00, 5.0943317825006d-01, 6.7615639657414d-01,
     |  -9.2096389782517d-01, 8.5888405559613d-02, 8.1456641737302d-01,
     |  -8.1456641737302d-01,-8.5888405559615d-02, 9.2096389782517d-01,
     |  -6.7615639657414d-01,-5.0943317825006d-01, 1.0560994755718d+00,
     |   2.4683283290974d-01,-1.2664327744144d+00,-1.2102378993931d+00,
     |  -4.8165919527435d-01,-9.6974580274410d-02,-9.8297586474829d-03,
     |  -4.5451150312869d-04,-7.8091916847377d-06,-3.3703812524061d-08,
     |  -1.6140370357241d-11,-1.0158127309066d-16,-4.1407441645868d-28/
      data (pmn(lat,25,33), lat = 1,36)/
     |   8.2639392946209d-30, 6.1302788642458d-18, 1.6498916638436d-12,
     |   4.9465001912834d-09, 1.5269113898558d-06, 1.1396731804430d-04,
     |   3.1059999574652d-03, 3.8557291530652d-02, 2.4520439529911d-01,
     |   8.3221431066016d-01, 1.4155048280673d+00, 7.3240084115175d-01,
     |  -8.8199493326189d-01,-6.1186581561908d-01, 9.5508221180489d-01,
     |   1.0771371685307d-01,-9.6097465402895d-01, 5.5039861635200d-01,
     |   5.5039861635200d-01,-9.6097465402895d-01, 1.0771371685306d-01,
     |   9.5508221180489d-01,-6.1186581561908d-01,-8.8199493326188d-01,
     |   7.3240084115175d-01, 1.4155048280673d+00, 8.3221431066016d-01,
     |   2.4520439529912d-01, 3.8557291530652d-02, 3.1059999574653d-03,
     |   1.1396731804430d-04, 1.5269113898558d-06, 4.9465001912835d-09,
     |   1.6498916638437d-12, 6.1302788642458d-18, 8.2639392946209d-30/
      data (pmn(lat,26,33), lat = 1,36)/
     |   1.5078972871408d-31, 3.3807006311310d-19, 1.5395793267068d-13,
     |   6.6156854970765d-10, 2.7135839060177d-07, 2.5872271194852d-05,
     |   8.8322378279135d-04, 1.3662838467583d-02, 1.0932102603520d-01,
     |   4.8231224440511d-01, 1.1678942991978d+00, 1.3334066871475d+00,
     |   5.3953354759989d-02,-1.1190200553737d+00,-1.8022451451621d-02,
     |   1.0234734135328d+00,-3.8148867595493d-01,-8.0131937347613d-01,
     |   8.0131937347613d-01, 3.8148867595493d-01,-1.0234734135328d+00,
     |   1.8022451451619d-02, 1.1190200553737d+00,-5.3953354759997d-02,
     |  -1.3334066871475d+00,-1.1678942991978d+00,-4.8231224440511d-01,
     |  -1.0932102603520d-01,-1.3662838467583d-02,-8.8322378279136d-04,
     |  -2.5872271194852d-05,-2.7135839060177d-07,-6.6156854970767d-10,
     |  -1.5395793267069d-13,-3.3807006311310d-19,-1.5078972871408d-31/
      data (pmn(lat,27,33), lat = 1,36)/
     |   2.4991710768901d-33, 1.6927008932718d-20, 1.3031416189620d-14,
     |   8.0137589836967d-11, 4.3577990262654d-08, 5.2896199501657d-06,
     |   2.2505999810421d-04, 4.3047252231805d-03, 4.2771316062895d-02,
     |   2.3916773406691d-01, 7.7327969425842d-01, 1.3789866027726d+00,
     |   1.0062663906079d+00,-5.2745264902612d-01,-1.0268998595993d+00,
     |   4.6153173441716d-01, 8.9129289006671d-01,-6.7224922362398d-01,
     |  -6.7224922362399d-01, 8.9129289006671d-01, 4.6153173441717d-01,
     |  -1.0268998595993d+00,-5.2745264902612d-01, 1.0062663906079d+00,
     |   1.3789866027726d+00, 7.7327969425842d-01, 2.3916773406691d-01,
     |   4.2771316062895d-02, 4.3047252231805d-03, 2.2505999810421d-04,
     |   5.2896199501657d-06, 4.3577990262654d-08, 8.0137589836969d-11,
     |   1.3031416189621d-14, 1.6927008932718d-20, 2.4991710768901d-33/
      data (pmn(lat,28,33), lat = 1,36)/
     |   3.7283840952650d-35, 7.6257362064310d-22, 9.9162786720042d-16,
     |   8.7152896922308d-12, 6.2705622401540d-09, 9.6620303162729d-07,
     |   5.1019690289777d-05, 1.1989152373705d-03, 1.4642499063665d-02,
     |   1.0192867043242d-01, 4.2374094871305d-01, 1.0513185324490d+00,
     |   1.4207766679493d+00, 5.8205002433834d-01,-8.9460413694901d-01,
     |  -8.0757036368286d-01, 7.3987289123666d-01, 7.7555310036723d-01,
     |  -7.7555310036723d-01,-7.3987289123666d-01, 8.0757036368286d-01,
     |   8.9460413694901d-01,-5.8205002433834d-01,-1.4207766679493d+00,
     |  -1.0513185324490d+00,-4.2374094871305d-01,-1.0192867043242d-01,
     |  -1.4642499063665d-02,-1.1989152373705d-03,-5.1019690289778d-05,
     |  -9.6620303162729d-07,-6.2705622401540d-09,-8.7152896922311d-12,
     |  -9.9162786720049d-16,-7.6257362064310d-22,-3.7283840952650d-35/
      data (pmn(lat,29,33), lat = 1,36)/
     |   4.9422711771310d-37, 3.0514738286542d-23, 6.6974455234654d-17,
     |   8.4025484843840d-13, 7.9847684663390d-10, 1.5578636649613d-07,
     |   1.0172284191267d-05, 2.9212184025779d-04, 4.3498851161415d-03,
     |   3.7194415030662d-02, 1.9393447933467d-01, 6.3186913356581d-01,
     |   1.2590080130186d+00, 1.3399339760309d+00, 2.1866334302370d-01,
     |  -1.0709220372967d+00,-6.5864799452052d-01, 8.3814821793019d-01,
     |   8.3814821793019d-01,-6.5864799452052d-01,-1.0709220372967d+00,
     |   2.1866334302370d-01, 1.3399339760309d+00, 1.2590080130186d+00,
     |   6.3186913356582d-01, 1.9393447933467d-01, 3.7194415030662d-02,
     |   4.3498851161415d-03, 2.9212184025779d-04, 1.0172284191267d-05,
     |   1.5578636649613d-07, 7.9847684663390d-10, 8.4025484843843d-13,
     |   6.6974455234658d-17, 3.0514738286542d-23, 4.9422711771310d-37/
      data (pmn(lat,30,33), lat = 1,36)/
     |   5.7096756235933d-39, 1.0638408820938d-24, 3.9383862231126d-18,
     |   7.0456941413856d-14, 8.8291851821137d-11, 2.1763450081590d-08,
     |   1.7517612692615d-06, 6.1202114350469d-05, 1.1037862641076d-03,
     |   1.1473734103090d-02, 7.3723103914547d-02, 3.0471742067225d-01,
     |   8.1878031225090d-01, 1.3822818246789d+00, 1.2441267488967d+00,
     |   2.8253909542966d-02,-1.1374299318404d+00,-7.2648233855143d-01,
     |   7.2648233855143d-01, 1.1374299318404d+00,-2.8253909542960d-02,
     |  -1.2441267488967d+00,-1.3822818246789d+00,-8.1878031225090d-01,
     |  -3.0471742067225d-01,-7.3723103914547d-02,-1.1473734103090d-02,
     |  -1.1037862641076d-03,-6.1202114350469d-05,-1.7517612692615d-06,
     |  -2.1763450081590d-08,-8.8291851821137d-11,-7.0456941413859d-14,
     |  -3.9383862231129d-18,-1.0638408820938d-24,-5.7096756235933d-39/
      data (pmn(lat,31,33), lat = 1,36)/
     |   5.5717368440939d-41, 3.1319257103798d-26, 1.9544873890277d-19,
     |   4.9810857964202d-15, 8.2197490470293d-12, 2.5547761867265d-09,
     |   2.5279703878063d-07, 1.0703961874239d-05, 2.3252742463562d-04,
     |   2.9142751107874d-03, 2.2774246656875d-02, 1.1669496509799d-01,
     |   4.0325538524696d-01, 9.4416978330797d-01, 1.4480757710558d+00,
     |   1.2540181187302d+00, 1.0615907471665d-01,-1.0975662958850d+00,
     |  -1.0975662958850d+00, 1.0615907471664d-01, 1.2540181187302d+00,
     |   1.4480757710558d+00, 9.4416978330796d-01, 4.0325538524696d-01,
     |   1.1669496509799d-01, 2.2774246656875d-02, 2.9142751107874d-03,
     |   2.3252742463562d-04, 1.0703961874239d-05, 2.5279703878064d-07,
     |   2.5547761867265d-09, 8.2197490470293d-12, 4.9810857964204d-15,
     |   1.9544873890278d-19, 3.1319257103798d-26, 5.5717368440939d-41/
      data (pmn(lat,32,33), lat = 1,36)/
     |   4.3339943911209d-43, 7.3476741390116d-28, 7.7252662265906d-21,
     |   2.8022905065667d-16, 6.0819158479410d-13, 2.3793812766687d-10,
     |   2.8874460732682d-08, 1.4768305489633d-06, 3.8463949842024d-05,
     |   5.7733457417223d-04, 5.4317027790005d-03, 3.3939589446457d-02,
     |   1.4644922867643d-01, 4.4677272520360d-01, 9.7078213737611d-01,
     |   1.4774101992393d+00, 1.4583027965953d+00, 6.2230303262508d-01,
     |  -6.2230303262508d-01,-1.4583027965953d+00,-1.4774101992393d+00,
     |  -9.7078213737611d-01,-4.4677272520360d-01,-1.4644922867643d-01,
     |  -3.3939589446458d-02,-5.4317027790005d-03,-5.7733457417223d-04,
     |  -3.8463949842024d-05,-1.4768305489633d-06,-2.8874460732683d-08,
     |  -2.3793812766687d-10,-6.0819158479410d-13,-2.8022905065668d-16,
     |  -7.7252662265911d-21,-7.3476741390116d-28,-4.3339943911209d-43/
      data (pmn(lat,33,33), lat = 1,36)/
     |   2.3292145144040d-45, 1.1907128003078d-29, 2.1081267771378d-22,
     |   1.0875857040550d-17, 3.1009356479549d-14, 1.5246450492241d-11,
     |   2.2642753903217d-09, 1.3948874690753d-07, 4.3384477719820d-06,
     |   7.7553809740218d-05, 8.7133178436060d-04, 6.5576356725482d-03,
     |   3.4628879971272d-02, 1.3276706962259d-01, 3.7898978657857d-01,
     |   8.2030222128235d-01, 1.3634733014700d+00, 1.7544332078968d+00,
     |   1.7544332078968d+00, 1.3634733014700d+00, 8.2030222128235d-01,
     |   3.7898978657857d-01, 1.3276706962259d-01, 3.4628879971272d-02,
     |   6.5576356725483d-03, 8.7133178436060d-04, 7.7553809740218d-05,
     |   4.3384477719820d-06, 1.3948874690753d-07, 2.2642753903218d-09,
     |   1.5246450492241d-11, 3.1009356479549d-14, 1.0875857040550d-17,
     |   2.1081267771380d-22, 1.1907128003078d-29, 2.3292145144040d-45/
      data (pmn(lat, 0,34), lat = 1,36)/
     |   2.9890753395348d+00,-1.8632316612734d+00, 1.5485562704452d+00,
     |  -1.3822697008465d+00, 1.2667064300594d+00,-1.1718910185123d+00,
     |   1.0855593697479d+00,-1.0018821520073d+00, 9.1786824917599d-01,
     |  -8.3195555809098d-01, 7.4337563825522d-01,-6.5183571830350d-01,
     |   5.5734566996727d-01,-4.6011686631578d-01, 3.6049903073447d-01,
     |  -2.5893817397304d-01, 1.5594665255927d-01,-5.2080310425247d-02,
     |  -5.2080310425250d-02, 1.5594665255928d-01,-2.5893817397305d-01,
     |   3.6049903073447d-01,-4.6011686631578d-01, 5.5734566996726d-01,
     |  -6.5183571830351d-01, 7.4337563825522d-01,-8.3195555809098d-01,
     |   9.1786824917599d-01,-1.0018821520073d+00, 1.0855593697479d+00,
     |  -1.1718910185123d+00, 1.2667064300594d+00,-1.3822697008465d+00,
     |   1.5485562704452d+00,-1.8632316612734d+00, 2.9890753395348d+00/
      data (pmn(lat, 1,34), lat = 1,36)/
     |   3.2818862972344d+00,-1.3835589140288d+00, 8.3521658314627d-01,
     |  -5.1561894802939d-01, 2.8495778131895d-01,-1.0127711713827d-01,
     |  -5.2700465618950d-02, 1.8536831682990d-01,-3.0121689172374d-01,
     |   4.0278954858153d-01,-4.9157133646894d-01, 5.6843783939215d-01,
     |  -6.3390068018444d-01, 6.8825034598867d-01,-7.3164327796441d-01,
     |   7.6415674411610d-01,-7.8582395008509d-01, 7.9665624394219d-01,
     |  -7.9665624394219d-01, 7.8582395008509d-01,-7.6415674411609d-01,
     |   7.3164327796441d-01,-6.8825034598867d-01, 6.3390068018445d-01,
     |  -5.6843783939214d-01, 4.9157133646894d-01,-4.0278954858153d-01,
     |   3.0121689172374d-01,-1.8536831682989d-01, 5.2700465618936d-02,
     |   1.0127711713827d-01,-2.8495778131895d-01, 5.1561894802941d-01,
     |  -8.3521658314629d-01, 1.3835589140288d+00,-3.2818862972344d+00/
      data (pmn(lat, 2,34), lat = 1,36)/
     |   1.3700735478184d+00, 1.2549952931944d+00,-1.3312514244591d+00,
     |   1.2885410133084d+00,-1.2278533865630d+00, 1.1615880190660d+00,
     |  -1.0912728406421d+00, 1.0167428340424d+00,-9.3771484184883d-01,
     |   8.5407225682404d-01,-7.6588824129935d-01, 6.7339736568118d-01,
     |  -5.7696245353829d-01, 4.7704617906213d-01,-3.7418812676358d-01,
     |   2.6898617831201d-01,-1.6208097333778d-01, 5.4142431239687d-02,
     |   5.4142431239690d-02,-1.6208097333778d-01, 2.6898617831202d-01,
     |  -3.7418812676358d-01, 4.7704617906213d-01,-5.7696245353828d-01,
     |   6.7339736568120d-01,-7.6588824129935d-01, 8.5407225682404d-01,
     |  -9.3771484184883d-01, 1.0167428340424d+00,-1.0912728406421d+00,
     |   1.1615880190660d+00,-1.2278533865630d+00, 1.2885410133084d+00,
     |  -1.3312514244591d+00, 1.2549952931944d+00, 1.3700735478184d+00/
      data (pmn(lat, 3,34), lat = 1,36)/
     |   3.6040734071071d-01, 2.4940404226693d+00,-1.5346801811094d+00,
     |   9.9156190200866d-01,-6.3003163328619d-01, 3.6084184720547d-01,
     |  -1.4633759015184d-01,-3.1647815635792d-02, 1.8276486063469d-01,
     |  -3.1249244542097d-01, 4.2408380011325d-01,-5.1952682495244d-01,
     |   6.0005585124323d-01,-6.6644153392670d-01, 7.1916309980718d-01,
     |  -7.5851428885935d-01, 7.8466970163637d-01,-7.9772601349010d-01,
     |   7.9772601349010d-01,-7.8466970163637d-01, 7.5851428885935d-01,
     |  -7.1916309980718d-01, 6.6644153392670d-01,-6.0005585124323d-01,
     |   5.1952682495243d-01,-4.2408380011325d-01, 3.1249244542097d-01,
     |  -1.8276486063468d-01, 3.1647815635787d-02, 1.4633759015185d-01,
     |  -3.6084184720547d-01, 6.3003163328619d-01,-9.9156190200867d-01,
     |   1.5346801811094d+00,-2.4940404226693d+00,-3.6040734071071d-01/
      data (pmn(lat, 4,34), lat = 1,36)/
     |   6.9484234285442d-02, 2.0535279543954d+00, 1.2448169770431d-01,
     |  -7.4205456563724d-01, 9.6507741158153d-01,-1.0433658477728d+00,
     |   1.0538927463932d+00,-1.0265389830961d+00, 9.7496721920893d-01,
     |  -9.0630221616480d-01, 8.2472294600578d-01,-7.3296951981976d-01,
     |   6.3303676017007d-01,-5.2651704172995d-01, 4.1477936969804d-01,
     |  -2.9906696673395d-01, 1.8055225609947d-01,-6.0368852595222d-02,
     |  -6.0368852595225d-02, 1.8055225609947d-01,-2.9906696673396d-01,
     |   4.1477936969804d-01,-5.2651704172995d-01, 6.3303676017007d-01,
     |  -7.3296951981977d-01, 8.2472294600578d-01,-9.0630221616480d-01,
     |   9.7496721920893d-01,-1.0265389830961d+00, 1.0538927463932d+00,
     |  -1.0433658477728d+00, 9.6507741158153d-01,-7.4205456563722d-01,
     |   1.2448169770428d-01, 2.0535279543954d+00, 6.9484234285442d-02/
      data (pmn(lat, 5,34), lat = 1,36)/
     |   1.0574468809278d-02, 1.1455629110780d+00, 1.6712429859930d+00,
     |  -1.5453868539081d+00, 1.1771046085800d+00,-8.3084035663916d-01,
     |   5.3374363838211d-01,-2.8113442037731d-01, 6.5459626631379d-02,
     |   1.1932618058627d-01,-2.7752304713136d-01, 4.1208797354347d-01,
     |  -5.2503075872679d-01, 6.1770861261669d-01,-6.9103061507177d-01,
     |   7.4559633398584d-01,-7.8178834821991d-01, 7.9983217836022d-01,
     |  -7.9983217836022d-01, 7.8178834821991d-01,-7.4559633398583d-01,
     |   6.9103061507176d-01,-6.1770861261669d-01, 5.2503075872680d-01,
     |  -4.1208797354346d-01, 2.7752304713136d-01,-1.1932618058627d-01,
     |  -6.5459626631385d-02, 2.8113442037731d-01,-5.3374363838212d-01,
     |   8.3084035663916d-01,-1.1771046085800d+00, 1.5453868539081d+00,
     |  -1.6712429859930d+00,-1.1455629110780d+00,-1.0574468809278d-02/
      data (pmn(lat, 6,34), lat = 1,36)/
     |   1.3278532818092d-03, 4.9246280285677d-01, 2.0883597558878d+00,
     |  -6.9383703066276d-01,-1.3485240271603d-01, 5.7924307405817d-01,
     |  -8.1243624399566d-01, 9.2338090959500d-01,-9.5818612418353d-01,
     |   9.4230431265602d-01,-8.9079470196707d-01, 8.1320325782799d-01,
     |  -7.1600718091335d-01, 6.0390568878193d-01,-4.8053547360596d-01,
     |   3.4888548535587d-01,-2.1154846956846d-01, 7.0881788808999d-02,
     |   7.0881788809002d-02,-2.1154846956846d-01, 3.4888548535588d-01,
     |  -4.8053547360596d-01, 6.0390568878193d-01,-7.1600718091334d-01,
     |   8.1320325782800d-01,-8.9079470196707d-01, 9.4230431265602d-01,
     |  -9.5818612418353d-01, 9.2338090959499d-01,-8.1243624399565d-01,
     |   5.7924307405817d-01,-1.3485240271603d-01,-6.9383703066278d-01,
     |   2.0883597558878d+00, 4.9246280285677d-01, 1.3278532818092d-03/
      data (pmn(lat, 7,34), lat = 1,36)/
     |   1.4168679500275d-04, 1.7327854667222d-01, 1.6563087773815d+00,
     |   7.7406957972662d-01,-1.2985448101184d+00, 1.2292605870675d+00,
     |  -9.8818664173949d-01, 7.0879726994531d-01,-4.3614691134070d-01,
     |   1.8586337592799d-01, 3.6884455429182d-02,-2.3075275918378d-01,
     |   3.9575844065916d-01,-5.3233477886017d-01, 6.4097197118990d-01,
     |  -7.2208949058884d-01, 7.7599981343378d-01,-8.0290554901694d-01,
     |   8.0290554901694d-01,-7.7599981343378d-01, 7.2208949058884d-01,
     |  -6.4097197118990d-01, 5.3233477886017d-01,-3.9575844065917d-01,
     |   2.3075275918377d-01,-3.6884455429182d-02,-1.8586337592799d-01,
     |   4.3614691134071d-01,-7.0879726994531d-01, 9.8818664173950d-01,
     |  -1.2292605870675d+00, 1.2985448101184d+00,-7.7406957972660d-01,
     |  -1.6563087773815d+00,-1.7327854667222d-01,-1.4168679500275d-04/
      data (pmn(lat, 8,34), lat = 1,36)/
     |   1.3117583863860d-05, 5.1695432078414d-02, 1.0048324681929d+00,
     |   1.7187623985342d+00,-1.1676469561259d+00, 3.9891492183758d-01,
     |   1.7256444151042d-01,-5.4503514743088d-01, 7.6620273431447d-01,
     |  -8.7729753315984d-01, 9.0804301465098d-01,-8.7932374834831d-01,
     |   8.0606361837057d-01,-6.9929279107365d-01, 5.6751267628223d-01,
     |  -4.1758551364254d-01, 2.5532324916997d-01,-8.5891999059358d-02,
     |  -8.5891999059361d-02, 2.5532324916997d-01,-4.1758551364255d-01,
     |   5.6751267628223d-01,-6.9929279107365d-01, 8.0606361837057d-01,
     |  -8.7932374834832d-01, 9.0804301465098d-01,-8.7729753315984d-01,
     |   7.6620273431447d-01,-5.4503514743088d-01, 1.7256444151041d-01,
     |   3.9891492183758d-01,-1.1676469561259d+00, 1.7187623985342d+00,
     |   1.0048324681929d+00, 5.1695432078414d-02, 1.3117583863860d-05/
      data (pmn(lat, 9,34), lat = 1,36)/
     |   1.0701494001271d-06, 1.3383935889042d-02, 5.0077126783097d-01,
     |   1.8289218367559d+00,-4.1116670870546d-02,-8.7133242258323d-01,
     |   1.1248499513915d+00,-1.0537448485450d+00, 8.3937678470300d-01,
     |  -5.7186759731511d-01, 2.9626819654863d-01,-3.5663900599370d-02,
     |  -1.9778889795356d-01, 3.9752430748992d-01,-5.5991795576610d-01,
     |   6.8293855030684d-01,-7.6544795231255d-01, 8.0683593232181d-01,
     |  -8.0683593232181d-01, 7.6544795231255d-01,-6.8293855030683d-01,
     |   5.5991795576609d-01,-3.9752430748991d-01, 1.9778889795357d-01,
     |   3.5663900599384d-02,-2.9626819654863d-01, 5.7186759731511d-01,
     |  -8.3937678470301d-01, 1.0537448485450d+00,-1.1248499513915d+00,
     |   8.7133242258323d-01, 4.1116670870546d-02,-1.8289218367559d+00,
     |  -5.0077126783098d-01,-1.3383935889042d-02,-1.0701494001271d-06/
      data (pmn(lat,10,34), lat = 1,36)/
     |   7.7848200157582d-08, 3.0568689392177d-03, 2.1289444802150d-01,
     |   1.4153355851636d+00, 1.1232888351999d+00,-1.3105785703727d+00,
     |   7.8428953833516d-01,-1.9582362514301d-01,-2.7530399996712d-01,
     |   6.0004988320574d-01,-7.9206319011780d-01, 8.7415819113044d-01,
     |  -8.6851171093630d-01, 7.9435538346863d-01,-6.6794977213883d-01,
     |   5.0315820962235d-01,-3.1209541885377d-01, 1.0571043049311d-01,
     |   1.0571043049312d-01,-3.1209541885378d-01, 5.0315820962236d-01,
     |  -6.6794977213884d-01, 7.9435538346863d-01,-8.6851171093630d-01,
     |   8.7415819113044d-01,-7.9206319011780d-01, 6.0004988320574d-01,
     |  -2.7530399996712d-01,-1.9582362514302d-01, 7.8428953833517d-01,
     |  -1.3105785703727d+00, 1.1232888351999d+00, 1.4153355851636d+00,
     |   2.1289444802151d-01, 3.0568689392177d-03, 7.7848200157582d-08/
      data (pmn(lat,11,34), lat = 1,36)/
     |   5.0968078267565d-09, 6.2347747779963d-04, 7.9036119473592d-02,
     |   8.8606126943341d-01, 1.6918805499009d+00,-6.5279805033237d-01,
     |  -3.8600116781008d-01, 9.0814580384499d-01,-1.0299560721329d+00,
     |   9.1176303187704d-01,-6.6887676953446d-01, 3.7491126775377d-01,
     |  -7.5538729676213d-02,-2.0094523452539d-01, 4.3690923583171d-01,
     |  -6.2134740760647d-01, 7.4749747475575d-01,-8.1146351201772d-01,
     |   8.1146351201772d-01,-7.4749747475574d-01, 6.2134740760646d-01,
     |  -4.3690923583170d-01, 2.0094523452539d-01, 7.5538729676204d-02,
     |  -3.7491126775378d-01, 6.6887676953446d-01,-9.1176303187704d-01,
     |   1.0299560721329d+00,-9.0814580384498d-01, 3.8600116781007d-01,
     |   6.5279805033237d-01,-1.6918805499009d+00,-8.8606126943342d-01,
     |  -7.9036119473594d-02,-6.2347747779963d-04,-5.0968078267565d-09/
      data (pmn(lat,12,34), lat = 1,36)/
     |   3.0255242116061d-10, 1.1461989268611d-04, 2.6032911617783d-02,
     |   4.7075871857717d-01, 1.6277383914346d+00, 4.7596624896557d-01,
     |  -1.2022104844536d+00, 9.9833736003366d-01,-4.8208029565667d-01,
     |  -4.1170826020562d-02, 4.5311446317905d-01,-7.2165422998060d-01,
     |   8.5089854106896d-01,-8.5886834568971d-01, 7.6803240538381d-01,
     |  -6.0153121850886d-01, 3.8188439449209d-01,-1.3076688665638d-01,
     |  -1.3076688665639d-01, 3.8188439449209d-01,-6.0153121850886d-01,
     |   7.6803240538381d-01,-8.5886834568971d-01, 8.5089854106896d-01,
     |  -7.2165422998059d-01, 4.5311446317905d-01,-4.1170826020559d-02,
     |  -4.8208029565668d-01, 9.9833736003366d-01,-1.2022104844536d+00,
     |   4.7596624896557d-01, 1.6277383914346d+00, 4.7075871857718d-01,
     |   2.6032911617784d-02, 1.1461989268611d-04, 3.0255242116061d-10/
      data (pmn(lat,13,34), lat = 1,36)/
     |   1.6380646964566d-11, 1.9131545487988d-05, 7.6951461341519d-03,
     |   2.1807852679552d-01, 1.2215917124206d+00, 1.3427485543729d+00,
     |  -1.0180036370979d+00, 5.2439174327754d-02, 6.4917946274370d-01,
     |  -9.5044115281539d-01, 9.3609603379651d-01,-7.2237424389355d-01,
     |   4.0701232169227d-01,-6.2258929365680d-02,-2.6121127010160d-01,
     |   5.2898465980751d-01,-7.1859848403033d-01, 8.1656556479920d-01,
     |  -8.1656556479920d-01, 7.1859848403033d-01,-5.2898465980751d-01,
     |   2.6121127010160d-01, 6.2258929365683d-02,-4.0701232169226d-01,
     |   7.2237424389356d-01,-9.3609603379651d-01, 9.5044115281539d-01,
     |  -6.4917946274369d-01,-5.2439174327758d-02, 1.0180036370979d+00,
     |  -1.3427485543729d+00,-1.2215917124206d+00,-2.1807852679553d-01,
     |  -7.6951461341521d-03,-1.9131545487988d-05,-1.6380646964566d-11/
      data (pmn(lat,14,34), lat = 1,36)/
     |   8.1276533226910d-13, 2.9159639722758d-06, 2.0587616832794d-03,
     |   8.9622256725857d-02, 7.6655669421983d-01, 1.6302611315896d+00,
     |  -9.0977994610558d-02,-9.5516551997196d-01, 1.0684281841330d+00,
     |  -6.7151708659768d-01, 1.2930465594281d-01, 3.5403107067350d-01,
     |  -6.8829144432625d-01, 8.4875570977428d-01,-8.4532069362467d-01,
     |   7.0527729267335d-01,-4.6425258121154d-01, 1.6163888940291d-01,
     |   1.6163888940291d-01,-4.6425258121154d-01, 7.0527729267336d-01,
     |  -8.4532069362467d-01, 8.4875570977428d-01,-6.8829144432625d-01,
     |   3.5403107067349d-01, 1.2930465594281d-01,-6.7151708659768d-01,
     |   1.0684281841330d+00,-9.5516551997196d-01,-9.0977994610570d-02,
     |   1.6302611315896d+00, 7.6655669421983d-01, 8.9622256725858d-02,
     |   2.0587616832795d-03, 2.9159639722758d-06, 8.1276533226910d-13/
      data (pmn(lat,15,34), lat = 1,36)/
     |   3.7099787721272d-14, 4.0769047712330d-07, 5.0177210841168d-04,
     |   3.3064895714331d-02, 4.1633507455471d-01, 1.4392842821051d+00,
     |   9.0471380016570d-01,-1.1665623663359d+00, 3.8450033172426d-01,
     |   4.1355355263629d-01,-8.6063052626817d-01, 9.3435269255271d-01,
     |  -7.3326074911158d-01, 3.7759238150317d-01, 2.6526160678735d-02,
     |  -3.9663911608737d-01, 6.7412447897053d-01,-8.2183638695618d-01,
     |   8.2183638695618d-01,-6.7412447897053d-01, 3.9663911608736d-01,
     |  -2.6526160678732d-02,-3.7759238150318d-01, 7.3326074911157d-01,
     |  -9.3435269255272d-01, 8.6063052626817d-01,-4.1355355263629d-01,
     |  -3.8450033172427d-01, 1.1665623663359d+00,-9.0471380016569d-01,
     |  -1.4392842821051d+00,-4.1633507455471d-01,-3.3064895714331d-02,
     |  -5.0177210841169d-04,-4.0769047712330d-07,-3.7099787721272d-14/
      data (pmn(lat,16,34), lat = 1,36)/
     |   1.5627028940630d-15, 5.2474972699107d-08, 1.1196511012214d-04,
     |   1.1045109065688d-02, 1.9974755832816d-01, 1.0352950166203d+00,
     |   1.4746429363754d+00,-5.0961534325420d-01,-6.7675007722995d-01,
     |   1.0508823809750d+00,-7.7410202753957d-01, 2.1979457707538d-01,
     |   3.2754415396034d-01,-7.0982058999577d-01, 8.6670471676467d-01,
     |  -8.0191417418492d-01, 5.5790898393322d-01,-1.9909636722485d-01,
     |  -1.9909636722485d-01, 5.5790898393322d-01,-8.0191417418493d-01,
     |   8.6670471676466d-01,-7.0982058999577d-01, 3.2754415396035d-01,
     |   2.1979457707539d-01,-7.7410202753957d-01, 1.0508823809750d+00,
     |  -6.7675007722995d-01,-5.0961534325420d-01, 1.4746429363754d+00,
     |   1.0352950166203d+00, 1.9974755832816d-01, 1.1045109065688d-02,
     |   1.1196511012214d-04, 5.2474972699107d-08, 1.5627028940630d-15/
      data (pmn(lat,17,34), lat = 1,36)/
     |   6.0885095177643d-17, 6.2352640415980d-09, 2.2961129488000d-05,
     |   3.3615840914194d-03, 8.5784919097121d-02, 6.3631311110768d-01,
     |   1.5243675191944d+00, 4.8528023101609d-01,-1.1711622156357d+00,
     |   5.9633367197187d-01, 2.4815586881624d-01,-8.0261020790969d-01,
     |   9.2601543449805d-01,-6.9464569585361d-01, 2.6163259773906d-01,
     |   2.1572924258822d-01,-6.0819840328329d-01, 8.2685673830818d-01,
     |  -8.2685673830818d-01, 6.0819840328328d-01,-2.1572924258821d-01,
     |  -2.6163259773906d-01, 6.9464569585361d-01,-9.2601543449806d-01,
     |   8.0261020790968d-01,-2.4815586881624d-01,-5.9633367197188d-01,
     |   1.1711622156357d+00,-4.8528023101609d-01,-1.5243675191944d+00,
     |  -6.3631311110768d-01,-8.5784919097121d-02,-3.3615840914195d-03,
     |  -2.2961129488001d-05,-6.2352640415980d-09,-6.0885095177643d-17/
      data (pmn(lat,18,34), lat = 1,36)/
     |   2.1980711719073d-18, 6.8539864807890d-10, 4.3399557603970d-06,
     |   9.3647518056243d-04, 3.3278857241978d-02, 3.4278956449136d-01,
     |   1.2335120965145d+00, 1.2425339878168d+00,-7.7192073233635d-01,
     |  -4.4602393097291d-01, 1.0065979749256d+00,-8.0869727130932d-01,
     |   2.1746518557146d-01, 3.9430844630960d-01,-7.8888114602204d-01,
     |   8.7188125065045d-01,-6.6010128395987d-01, 2.4417248702770d-01,
     |   2.4417248702770d-01,-6.6010128395987d-01, 8.7188125065045d-01,
     |  -7.8888114602204d-01, 3.9430844630960d-01, 2.1746518557145d-01,
     |  -8.0869727130933d-01, 1.0065979749256d+00,-4.4602393097291d-01,
     |  -7.7192073233635d-01, 1.2425339878168d+00, 1.2335120965145d+00,
     |   3.4278956449136d-01, 3.3278857241978d-02, 9.3647518056245d-04,
     |   4.3399557603972d-06, 6.8539864807890d-10, 2.1980711719073d-18/
      data (pmn(lat,19,34), lat = 1,36)/
     |   7.3619180260130d-20, 6.9799008215877d-11, 7.5762777306864d-07,
     |   2.3959916292299d-04, 1.1735834397237d-02, 1.6437889416886d-01,
     |   8.3726197108678d-01, 1.5063799729193d+00, 1.5434603417910d-01,
     |  -1.1141204591780d+00, 7.0149449727833d-01, 1.8255994076043d-01,
     |  -8.0551773971739d-01, 9.1115059959997d-01,-5.7462367808702d-01,
     |   1.8694759290322d-02, 5.1353947264842d-01,-8.3104615738031d-01,
     |   8.3104615738031d-01,-5.1353947264842d-01,-1.8694759290332d-02,
     |   5.7462367808703d-01,-9.1115059959997d-01, 8.0551773971739d-01,
     |  -1.8255994076042d-01,-7.0149449727833d-01, 1.1141204591780d+00,
     |  -1.5434603417909d-01,-1.5063799729193d+00,-8.3726197108679d-01,
     |  -1.6437889416886d-01,-1.1735834397237d-02,-2.3959916292299d-04,
     |  -7.5762777306867d-07,-6.9799008215877d-11,-7.3619180260130d-20/
      data (pmn(lat,20,34), lat = 1,36)/
     |   2.2890037554779d-21, 6.5909609605275d-12, 1.2231781573462d-07,
     |   5.6431427380027d-05, 3.7789868316671d-03, 7.0871423759970d-02,
     |   4.9263476055247d-01, 1.3498239457885d+00, 1.0147172183475d+00,
     |  -9.0672735033950d-01,-3.1124192297153d-01, 9.8273587583376d-01,
     |  -7.8238507369029d-01, 1.0046135472059d-01, 5.6526753352394d-01,
     |  -8.8656468162946d-01, 7.6567779942649d-01,-2.9828050460578d-01,
     |  -2.9828050460578d-01, 7.6567779942649d-01,-8.8656468162946d-01,
     |   5.6526753352394d-01, 1.0046135472059d-01,-7.8238507369029d-01,
     |   9.8273587583376d-01,-3.1124192297153d-01,-9.0672735033950d-01,
     |   1.0147172183475d+00, 1.3498239457885d+00, 4.9263476055247d-01,
     |   7.0871423759970d-02, 3.7789868316671d-03, 5.6431427380029d-05,
     |   1.2231781573462d-07, 6.5909609605275d-12, 2.2890037554779d-21/
      data (pmn(lat,21,34), lat = 1,36)/
     |   6.6078801575914d-23, 5.7725418151110d-13, 1.8275913919248d-08,
     |   1.2252502562985d-05, 1.1144073149517d-03, 2.7655327378539d-02,
     |   2.5595178144100d-01, 9.9076694512429d-01, 1.4379688391826d+00,
     |  -5.4996010182171d-02,-1.0637497091667d+00, 7.1524073858531d-01,
     |   2.3907569027661d-01,-8.7453287585563d-01, 8.4627590498084d-01,
     |  -3.0249618569238d-01,-3.8140120168076d-01, 8.3358553876331d-01,
     |  -8.3358553876331d-01, 3.8140120168075d-01, 3.0249618569239d-01,
     |  -8.4627590498084d-01, 8.7453287585562d-01,-2.3907569027662d-01,
     |  -7.1524073858532d-01, 1.0637497091667d+00, 5.4996010182174d-02,
     |  -1.4379688391826d+00,-9.9076694512430d-01,-2.5595178144101d-01,
     |  -2.7655327378539d-02,-1.1144073149517d-03,-1.2252502562986d-05,
     |  -1.8275913919249d-08,-5.7725418151110d-13,-6.6078801575914d-23/
      data (pmn(lat,22,34), lat = 1,36)/
     |   1.7703058553477d-24, 4.6878472062888d-14, 2.5271344466280d-09,
     |   2.4539179109287d-06, 3.0149929695673d-04, 9.8091066114612d-03,
     |   1.1874890419937d-01, 6.2168564282920d-01, 1.3991814647835d+00,
     |   8.5407085022672d-01,-9.5049025876616d-01,-3.0139762361772d-01,
     |   9.9836689870463d-01,-6.6719522366110d-01,-1.6599119236921d-01,
     |   8.0739011621910d-01,-8.6561680672676d-01, 3.6341762392504d-01,
     |   3.6341762392505d-01,-8.6561680672676d-01, 8.0739011621910d-01,
     |  -1.6599119236921d-01,-6.6719522366110d-01, 9.9836689870463d-01,
     |  -3.0139762361771d-01,-9.5049025876616d-01, 8.5407085022672d-01,
     |   1.3991814647835d+00, 6.2168564282920d-01, 1.1874890419938d-01,
     |   9.8091066114612d-03, 3.0149929695673d-04, 2.4539179109287d-06,
     |   2.5271344466281d-09, 4.6878472062888d-14, 1.7703058553477d-24/
      data (pmn(lat,23,34), lat = 1,36)/
     |   4.3969449754356d-26, 3.5266523260270d-15, 3.2317886424894d-10,
     |   4.5325175957735d-07, 7.4886235172404d-05, 3.1703604706629d-03,
     |   4.9537541855876d-02, 3.4092296360481d-01, 1.0853956274718d+00,
     |   1.3733892710388d+00,-1.2959251595337d-01,-1.0609236764874d+00,
     |   6.2771698168496d-01, 4.3727745347702d-01,-9.6112163378757d-01,
     |   6.1321039300067d-01, 2.0175201979875d-01,-8.3328431072756d-01,
     |   8.3328431072756d-01,-2.0175201979875d-01,-6.1321039300067d-01,
     |   9.6112163378757d-01,-4.3727745347701d-01,-6.2771698168495d-01,
     |   1.0609236764874d+00, 1.2959251595337d-01,-1.3733892710388d+00,
     |  -1.0853956274718d+00,-3.4092296360481d-01,-4.9537541855876d-02,
     |  -3.1703604706629d-03,-7.4886235172404d-05,-4.5325175957736d-07,
     |  -3.2317886424896d-10,-3.5266523260270d-15,-4.3969449754356d-26/
      data (pmn(lat,24,34), lat = 1,36)/
     |   1.0106874981762d-27, 2.4537031182577d-16, 3.8168211004032d-11,
     |   7.7127656834592d-08, 1.7070301316867d-05, 9.3465125928207d-04,
     |   1.8654905505376d-02, 1.6543178975896d-01, 7.0841932544171d-01,
     |   1.4075647217849d+00, 8.0306366179330d-01,-9.1881525163002d-01,
     |  -4.3863442951317d-01, 1.0206885477804d+00,-3.8001337733435d-01,
     |  -5.8841200466061d-01, 9.4465140135562d-01,-4.4254819419039d-01,
     |  -4.4254819419039d-01, 9.4465140135562d-01,-5.8841200466060d-01,
     |  -3.8001337733436d-01, 1.0206885477804d+00,-4.3863442951318d-01,
     |  -9.1881525163003d-01, 8.0306366179330d-01, 1.4075647217849d+00,
     |   7.0841932544172d-01, 1.6543178975896d-01, 1.8654905505377d-02,
     |   9.3465125928207d-04, 1.7070301316867d-05, 7.7127656834594d-08,
     |   3.8168211004034d-11, 2.4537031182577d-16, 1.0106874981762d-27/
      data (pmn(lat,25,34), lat = 1,36)/
     |   2.1445592149033d-29, 1.5749909624078d-17, 4.1534393120440d-12,
     |   1.2067373493931d-08, 3.5660415386172d-06, 2.5123423255514d-04,
     |   6.3524351369637d-03, 7.1523411032101d-02, 3.9906900220965d-01,
     |   1.1206381302493d+00, 1.3524760759208d+00,-5.3490569963233d-02,
     |  -1.1039785289925d+00, 3.8075647109470d-01, 7.6267840162527d-01,
     |  -8.9544849705034d-01, 3.5964239096863d-02, 8.2833499938024d-01,
     |  -8.2833499938024d-01,-3.5964239096866d-02, 8.9544849705035d-01,
     |  -7.6267840162526d-01,-3.8075647109470d-01, 1.1039785289925d+00,
     |   5.3490569963242d-02,-1.3524760759208d+00,-1.1206381302493d+00,
     |  -3.9906900220965d-01,-7.1523411032101d-02,-6.3524351369638d-03,
     |  -2.5123423255514d-04,-3.5660415386172d-06,-1.2067373493932d-08,
     |  -4.1534393120442d-12,-1.5749909624078d-17,-2.1445592149033d-29/
      data (pmn(lat,26,34), lat = 1,36)/
     |   4.1857051267944d-31, 9.2942453104264d-19, 4.1505803782763d-13,
     |   1.7306502426940d-09, 6.8091841211976d-07, 6.1460945703226d-05,
     |   1.9554353123590d-03, 2.7637264427034d-02, 1.9657215538177d-01,
     |   7.3819726920643d-01, 1.3935519563329d+00, 8.8708886260990d-01,
     |  -7.7805434234444d-01,-7.2754912930518d-01, 9.1462961840940d-01,
     |   1.8791157097188d-01,-9.7722959659154d-01, 5.4039963168991d-01,
     |   5.4039963168991d-01,-9.7722959659154d-01, 1.8791157097188d-01,
     |   9.1462961840940d-01,-7.2754912930517d-01,-7.7805434234444d-01,
     |   8.8708886260989d-01, 1.3935519563329d+00, 7.3819726920644d-01,
     |   1.9657215538177d-01, 2.7637264427034d-02, 1.9554353123591d-03,
     |   6.1460945703226d-05, 6.8091841211976d-07, 1.7306502426940d-09,
     |   4.1505803782766d-13, 9.2942453104264d-19, 4.1857051267944d-31/
      data (pmn(lat,27,34), lat = 1,36)/
     |   7.4781944118634d-33, 5.0181453703615d-20, 3.7911615886714d-14,
     |   2.2649730036745d-10, 1.1835607960270d-07, 1.3636660402907d-05,
     |   5.4287562782245d-04, 9.5452064111052d-03, 8.5174189434086d-02,
     |   4.1344270913463d-01, 1.0943697252638d+00, 1.3865631458971d+00,
     |   2.0789773736307d-01,-1.1099111227220d+00,-1.2345457581765d-01,
     |   1.0400117417782d+00,-3.4067599385713d-01,-8.1581124101583d-01,
     |   8.1581124101583d-01, 3.4067599385714d-01,-1.0400117417782d+00,
     |   1.2345457581764d-01, 1.1099111227220d+00,-2.0789773736307d-01,
     |  -1.3865631458971d+00,-1.0943697252638d+00,-4.1344270913464d-01,
     |  -8.5174189434087d-02,-9.5452064111052d-03,-5.4287562782246d-04,
     |  -1.3636660402907d-05,-1.1835607960270d-07,-2.2649730036746d-10,
     |  -3.7911615886716d-14,-5.0181453703615d-20,-7.4781944118634d-33/
      data (pmn(lat,28,34), lat = 1,36)/
     |   1.2149071167241d-34, 2.4626772294934d-21, 3.1447562790849d-15,
     |   2.6880870859487d-11, 1.8615507786450d-08, 2.7291514014670d-06,
     |   1.3530674856671d-04, 2.9381189982238d-03, 3.2494652989039d-02,
     |   1.9923581136677d-01, 6.9896764940485d-01, 1.3490268341268d+00,
     |   1.1055673779205d+00,-4.2020004092455d-01,-1.0707598435582d+00,
     |   3.9838445440159d-01, 9.1998600293173d-01,-6.6536123449786d-01,
     |  -6.6536123449786d-01, 9.1998600293173d-01, 3.9838445440160d-01,
     |  -1.0707598435582d+00,-4.2020004092455d-01, 1.1055673779205d+00,
     |   1.3490268341268d+00, 6.9896764940485d-01, 1.9923581136678d-01,
     |   3.2494652989039d-02, 2.9381189982238d-03, 1.3530674856671d-04,
     |   2.7291514014670d-06, 1.8615507786450d-08, 2.6880870859488d-11,
     |   3.1447562790852d-15, 2.4626772294934d-21, 1.2149071167241d-34/
      data (pmn(lat,29,34), lat = 1,36)/
     |   1.7784032251239d-36, 1.0885492132091d-22, 2.3476543268375d-16,
     |   2.8674777780570d-12, 2.6266896506126d-09, 4.8865088895466d-07,
     |   3.0050058213987d-05, 8.0102188451151d-04, 1.0875773426421d-02,
     |   8.2839348700687d-02, 3.7219088343008d-01, 9.8970093052033d-01,
     |   1.4349267667305d+00, 6.8795970150662d-01,-8.4014222647314d-01,
     |  -8.6000017120140d-01, 7.1390105675708d-01, 7.9048098649129d-01,
     |  -7.9048098649129d-01,-7.1390105675708d-01, 8.6000017120140d-01,
     |   8.4014222647314d-01,-6.8795970150662d-01,-1.4349267667305d+00,
     |  -9.8970093052034d-01,-3.7219088343008d-01,-8.2839348700688d-02,
     |  -1.0875773426421d-02,-8.0102188451151d-04,-3.0050058213988d-05,
     |  -4.8865088895466d-07,-2.6266896506126d-09,-2.8674777780571d-12,
     |  -2.3476543268377d-16,-1.0885492132091d-22,-1.7784032251239d-36/
      data (pmn(lat,30,34), lat = 1,36)/
     |   2.3152876701640d-38, 4.2778720449804d-24, 1.5570810944110d-17,
     |   2.7144973111165d-13, 3.2835374536407d-10, 7.7324936434924d-08,
     |   5.8778644423833d-06, 1.9137032540940d-04, 3.1653516359482d-03,
     |   2.9577209586982d-02, 1.6629962203158d-01, 5.7810431739859d-01,
     |   1.2203283962264d+00, 1.3806284410259d+00, 3.0488746358498d-01,
     |  -1.0511538113419d+00,-6.9515633043073d-01, 8.3505194541350d-01,
     |   8.3505194541350d-01,-6.9515633043073d-01,-1.0511538113419d+00,
     |   3.0488746358498d-01, 1.3806284410259d+00, 1.2203283962264d+00,
     |   5.7810431739860d-01, 1.6629962203158d-01, 2.9577209586982d-02,
     |   3.1653516359482d-03, 1.9137032540940d-04, 5.8778644423834d-06,
     |   7.7324936434924d-08, 3.2835374536407d-10, 2.7144973111166d-13,
     |   1.5570810944111d-17, 4.2778720449804d-24, 2.3152876701640d-38/
      data (pmn(lat,31,34), lat = 1,36)/
     |   2.6292650550193d-40, 1.4659793599595d-25, 8.9997309311663d-19,
     |   2.2370377096241d-14, 3.5679273739335d-11, 1.0613429713891d-08,
     |   9.9427230645267d-07, 3.9368918664037d-05, 7.8828783654355d-04,
     |   8.9476072554235d-03, 6.1919277952869d-02, 2.7245938844888d-01,
     |   7.7193109418813d-01, 1.3647482450004d+00, 1.2897602981279d+00,
     |   8.6950790711297d-02,-1.1325484085205d+00,-7.4129386705523d-01,
     |   7.4129386705523d-01, 1.1325484085205d+00,-8.6950790711291d-02,
     |  -1.2897602981279d+00,-1.3647482450004d+00,-7.7193109418813d-01,
     |  -2.7245938844889d-01,-6.1919277952869d-02,-8.9476072554235d-03,
     |  -7.8828783654356d-04,-3.9368918664038d-05,-9.9427230645269d-07,
     |  -1.0613429713891d-08,-3.5679273739335d-11,-2.2370377096242d-14,
     |  -8.9997309311669d-19,-1.4659793599595d-25,-2.6292650550193d-40/
      data (pmn(lat,32,34), lat = 1,36)/
     |   2.5240988911369d-42, 4.2456921606010d-27, 4.3935498005816d-20,
     |   1.5556866196408d-15, 3.2671525231515d-12, 1.2253220049888d-09,
     |   1.4109392158066d-07, 6.7693922309654d-06, 1.6321808021329d-04,
     |   2.2327840330834d-03, 1.8780411664168d-02, 1.0233960882698d-01,
     |   3.7217690243093d-01, 9.0869440757693d-01, 1.4424271197936d+00,
     |   1.2894727940703d+00, 1.3962399587648d-01,-1.0995098201243d+00,
     |  -1.0995098201243d+00, 1.3962399587648d-01, 1.2894727940703d+00,
     |   1.4424271197936d+00, 9.0869440757693d-01, 3.7217690243093d-01,
     |   1.0233960882698d-01, 1.8780411664168d-02, 2.2327840330834d-03,
     |   1.6321808021330d-04, 6.7693922309654d-06, 1.4109392158066d-07,
     |   1.2253220049888d-09, 3.2671525231515d-12, 1.5556866196408d-15,
     |   4.3935498005819d-20, 4.2456921606010d-27, 2.5240988911369d-42/
      data (pmn(lat,33,34), lat = 1,36)/
     |   1.9329493945108d-44, 9.8061861670415d-29, 1.7096325708270d-21,
     |   8.6160366418608d-17, 2.3797571752381d-13, 1.1233684363642d-10,
     |   1.5862914505423d-08, 9.1924308758511d-07, 2.6569892867211d-05,
     |   4.3522218832848d-04, 4.4061089288471d-03, 2.9267683770377d-02,
     |   1.3282156411871d-01, 4.2204093426186d-01, 9.4665962699014d-01,
     |   1.4748069771988d+00, 1.4783213614625d+00, 6.3568351048141d-01,
     |  -6.3568351048141d-01,-1.4783213614625d+00,-1.4748069771988d+00,
     |  -9.4665962699014d-01,-4.2204093426186d-01,-1.3282156411871d-01,
     |  -2.9267683770377d-02,-4.4061089288471d-03,-4.3522218832848d-04,
     |  -2.6569892867211d-05,-9.1924308758512d-07,-1.5862914505423d-08,
     |  -1.1233684363642d-10,-2.3797571752381d-13,-8.6160366418611d-17,
     |  -1.7096325708271d-21,-9.8061861670415d-29,-1.9329493945108d-44/
      data (pmn(lat,34,34), lat = 1,36)/
     |   1.0234323447163d-46, 1.5655782532913d-30, 4.5962491680782d-23,
     |   3.2943928252004d-18, 1.1953704157053d-14, 7.0916033531573d-12,
     |   1.2255071781751d-09, 8.5537467829423d-08, 2.9524857395427d-06,
     |   5.7597563233138d-05, 6.9633832758232d-04, 5.5711719831473d-03,
     |   3.0941221728970d-02, 1.2355940398919d-01, 3.6409699692319d-01,
     |   8.0672495169392d-01, 1.3617120904556d+00, 1.7656043052364d+00,
     |   1.7656043052364d+00, 1.3617120904556d+00, 8.0672495169392d-01,
     |   3.6409699692319d-01, 1.2355940398919d-01, 3.0941221728970d-02,
     |   5.5711719831474d-03, 6.9633832758232d-04, 5.7597563233138d-05,
     |   2.9524857395427d-06, 8.5537467829423d-08, 1.2255071781751d-09,
     |   7.0916033531573d-12, 1.1953704157053d-14, 3.2943928252005d-18,
     |   4.5962491680785d-23, 1.5655782532913d-30, 1.0234323447163d-46/
      data (pmn(lat, 0,35), lat = 1,36)/
     |   2.8860757261240d+00,-1.6933192717901d+00, 1.3528671253685d+00,
     |  -1.1822457753475d+00, 1.0780975884560d+00,-1.0076824592750d+00,
     |   9.5703564248235d-01,-9.1910549632379d-01, 8.8991803260301d-01,
     |  -8.6705476821119d-01, 8.4895910477987d-01,-8.3458697424573d-01,
     |   8.2321705487799d-01,-8.1434149030361d-01, 8.0760011445517d-01,
     |  -8.0273961704021d-01, 7.9958781323944d-01,-7.9803760387239d-01,
     |   7.9803760387239d-01,-7.9958781323944d-01, 8.0273961704021d-01,
     |  -8.0760011445517d-01, 8.1434149030361d-01,-8.2321705487800d-01,
     |   8.3458697424573d-01,-8.4895910477987d-01, 8.6705476821119d-01,
     |  -8.8991803260301d-01, 9.1910549632379d-01,-9.5703564248235d-01,
     |   1.0076824592750d+00,-1.0780975884560d+00, 1.1822457753475d+00,
     |  -1.3528671253684d+00, 1.6933192717901d+00,-2.8860757261240d+00/
      data (pmn(lat, 2,35), lat = 1,36)/
     |   1.4545047661013d+00, 1.0112899232038d+00,-1.0642144233567d+00,
     |   1.0221358469277d+00,-9.7761967567306d-01, 9.4026394527396d-01,
     |  -9.1003751430774d-01, 8.8566047016288d-01,-8.6593038772532d-01,
     |   8.4990469548152d-01,-8.3687492761659d-01, 8.2631326048218d-01,
     |  -8.1782655648195d-01, 8.1112221957254d-01,-8.0598394524623d-01,
     |   8.0225482525603d-01,-7.9982578455998d-01, 7.9862793669091d-01,
     |  -7.9862793669091d-01, 7.9982578455998d-01,-8.0225482525602d-01,
     |   8.0598394524623d-01,-8.1112221957254d-01, 8.1782655648196d-01,
     |  -8.2631326048218d-01, 8.3687492761659d-01,-8.4990469548152d-01,
     |   8.6593038772532d-01,-8.8566047016288d-01, 9.1003751430773d-01,
     |  -9.4026394527396d-01, 9.7761967567306d-01,-1.0221358469277d+00,
     |   1.0642144233567d+00,-1.0112899232038d+00,-1.4545047661013d+00/
      data (pmn(lat, 4,35), lat = 1,36)/
     |   7.8521844261278d-02, 2.1672514213880d+00,-2.2268657617684d-01,
     |  -3.4148609174761d-01, 5.6494709311972d-01,-6.7015221059588d-01,
     |   7.2512763767644d-01,-7.5582920664050d-01, 7.7372551598843d-01,
     |  -7.8443773231667d-01, 7.9094052243661d-01,-7.9490258600956d-01,
     |   7.9730296547490d-01,-7.9873585675426d-01, 7.9957031948182d-01,
     |  -8.0003777034675d-01, 8.0028137193775d-01,-8.0038411508839d-01,
     |   8.0038411508839d-01,-8.0028137193775d-01, 8.0003777034675d-01,
     |  -7.9957031948182d-01, 7.9873585675426d-01,-7.9730296547491d-01,
     |   7.9490258600956d-01,-7.9094052243661d-01, 7.8443773231667d-01,
     |  -7.7372551598843d-01, 7.5582920664050d-01,-7.2512763767643d-01,
     |   6.7015221059588d-01,-5.6494709311972d-01, 3.4148609174759d-01,
     |   2.2268657617687d-01,-2.1672514213880d+00,-7.8521844261278d-02/
      data (pmn(lat, 6,35), lat = 1,36)/
     |   1.5938918311896d-03, 5.6635349244100d-01, 2.1018219934502d+00,
     |  -1.0301415173457d+00, 3.4504497399383d-01, 5.3945768993579d-02,
     |  -2.9722421205654d-01, 4.5349391004021d-01,-5.5837810748701d-01,
     |   6.3125539264616d-01,-6.8323430663003d-01, 7.2098481783529d-01,
     |  -7.4866806631392d-01, 7.6895753025697d-01,-7.8360377532585d-01,
     |   7.9375811869919d-01,-8.0016244981321d-01, 8.0326062499784d-01,
     |  -8.0326062499784d-01, 8.0016244981321d-01,-7.9375811869919d-01,
     |   7.8360377532584d-01,-7.6895753025696d-01, 7.4866806631392d-01,
     |  -7.2098481783529d-01, 6.8323430663003d-01,-6.3125539264616d-01,
     |   5.5837810748700d-01,-4.5349391004021d-01, 2.9722421205653d-01,
     |  -5.3945768993579d-02,-3.4504497399383d-01, 1.0301415173458d+00,
     |  -2.1018219934502d+00,-5.6635349244100d-01,-1.5938918311896d-03/
      data (pmn(lat, 8,35), lat = 1,36)/
     |   1.6729876363625d-05, 6.3872193760127d-02, 1.1479426529755d+00,
     |   1.5509671255850d+00,-1.3653061029113d+00, 8.5346325750605d-01,
     |  -4.1530704588383d-01, 8.5006851828991d-02, 1.5867376239711d-01,
     |  -3.3903301986354d-01, 4.7366648318493d-01,-5.7487356917644d-01,
     |   6.5110458257364d-01,-7.0816009009867d-01, 7.5002246948683d-01,
     |  -7.7940268077389d-01, 7.9809137242971d-01,-8.0717797388047d-01,
     |   8.0717797388047d-01,-7.9809137242971d-01, 7.7940268077389d-01,
     |  -7.5002246948683d-01, 7.0816009009866d-01,-6.5110458257365d-01,
     |   5.7487356917643d-01,-4.7366648318493d-01, 3.3903301986354d-01,
     |  -1.5867376239711d-01,-8.5006851828997d-02, 4.1530704588384d-01,
     |  -8.5346325750605d-01, 1.3653061029113d+00,-1.5509671255850d+00,
     |  -1.1479426529755d+00,-6.3872193760127d-02,-1.6729876363625d-05/
      data (pmn(lat,10,35), lat = 1,36)/
     |   1.0562539320448d-07, 4.0437588002634d-03, 2.6586779427913d-01,
     |   1.5722280961230d+00, 7.6886579172509d-01,-1.2825079356061d+00,
     |   1.1063475048267d+00,-7.6090162161901d-01, 4.1534123973044d-01,
     |  -1.1640697892045d-01,-1.2880189768045d-01, 3.2494931996649d-01,
     |  -4.7919113522834d-01, 5.9822508717780d-01,-6.8749828342630d-01,
     |   7.5112682264423d-01,-7.9201800538019d-01, 8.1201678079996d-01,
     |  -8.1201678079996d-01, 7.9201800538019d-01,-7.5112682264423d-01,
     |   6.8749828342630d-01,-5.9822508717779d-01, 4.7919113522835d-01,
     |  -3.2494931996648d-01, 1.2880189768045d-01, 1.1640697892046d-01,
     |  -4.1534123973044d-01, 7.6090162161902d-01,-1.1063475048267d+00,
     |   1.2825079356061d+00,-7.6886579172509d-01,-1.5722280961230d+00,
     |  -2.6586779427913d-01,-4.0437588002634d-03,-1.0562539320448d-07/
      data (pmn(lat,12,35), lat = 1,36)/
     |   4.3759643795004d-10, 1.6230777930422d-04, 3.5202422467508d-02,
     |   5.8598085507639d-01, 1.7168820455613d+00,-2.9074043626643d-03,
     |  -9.2762998432707d-01, 1.1168364176754d+00,-9.5050575563922d-01,
     |   6.5486425681959d-01,-3.3679626663384d-01, 4.2168910419249d-02,
     |   2.1156571226100d-01,-4.1953714238486d-01, 5.8204841422574d-01,
     |  -7.0115410549173d-01, 7.7909706171776d-01,-8.1760848500901d-01,
     |   8.1760848500901d-01,-7.7909706171776d-01, 7.0115410549173d-01,
     |  -5.8204841422574d-01, 4.1953714238486d-01,-2.1156571226101d-01,
     |  -4.2168910419263d-02, 3.3679626663384d-01,-6.5486425681960d-01,
     |   9.5050575563922d-01,-1.1168364176754d+00, 9.2762998432706d-01,
     |   2.9074043626643d-03,-1.7168820455613d+00,-5.8598085507640d-01,
     |  -3.5202422467509d-02,-1.6230777930422d-04,-4.3759643795004d-10/
      data (pmn(lat,14,35), lat = 1,36)/
     |   1.2565834123276d-12, 4.4269673905742d-06, 3.0069335253402d-03,
     |   1.2260000735789d-01, 9.3964676831728d-01, 1.5827728493548d+00,
     |  -6.0010703293976d-01,-4.7117405262860d-01, 9.6343632807134d-01,
     |  -1.0048016678170d+00, 7.9788737878072d-01,-4.8535148483945d-01,
     |   1.5140870548782d-01, 1.5794530433883d-01,-4.1891711527891d-01,
     |   6.1987443047695d-01,-7.5553081399456d-01, 8.2372137109029d-01,
     |  -8.2372137109029d-01, 7.5553081399456d-01,-6.1987443047694d-01,
     |   4.1891711527891d-01,-1.5794530433882d-01,-1.5140870548781d-01,
     |   4.8535148483947d-01,-7.9788737878072d-01, 1.0048016678170d+00,
     |  -9.6343632807134d-01, 4.7117405262859d-01, 6.0010703293977d-01,
     |  -1.5827728493548d+00,-9.3964676831728d-01,-1.2260000735789d-01,
     |  -3.0069335253403d-03,-4.4269673905742d-06,-1.2565834123276d-12/
      data (pmn(lat,16,35), lat = 1,36)/
     |   2.5920099514878d-15, 8.5660120847561d-08, 1.7676070713865d-04,
     |   1.6508580504062d-02, 2.7428448999770d-01, 1.2360855175944d+00,
     |   1.2582772361764d+00,-9.6360504988478d-01,-4.8020441982203d-02,
     |   7.4581953755741d-01,-9.7755563845194d-01, 8.6460737218000d-01,
     |  -5.5962654253681d-01, 1.8219910083202d-01, 1.8677462218731d-01,
     |  -4.9640259386594d-01, 7.1638230790214d-01,-8.3003970603311d-01,
     |   8.3003970603311d-01,-7.1638230790214d-01, 4.9640259386593d-01,
     |  -1.8677462218731d-01,-1.8219910083202d-01, 5.5962654253681d-01,
     |  -8.6460737218001d-01, 9.7755563845194d-01,-7.4581953755741d-01,
     |   4.8020441982197d-02, 9.6360504988479d-01,-1.2582772361764d+00,
     |  -1.2360855175944d+00,-2.7428448999770d-01,-1.6508580504063d-02,
     |  -1.7676070713865d-04,-8.5660120847561d-08,-2.5920099514878d-15/
      data (pmn(lat,18,35), lat = 1,36)/
     |   3.9300423106413d-18, 1.2081444705920d-09, 7.4276326794429d-06,
     |   1.5287793718458d-03, 5.0648613143263d-02, 4.6990116733130d-01,
     |   1.4206253038594d+00, 8.6315566626943d-01,-1.1219630850649d+00,
     |   2.6864804365584d-01, 5.4985704262252d-01,-9.2977434519617d-01,
     |   8.8299510913950d-01,-5.5814313290157d-01, 1.1443076072776d-01,
     |   3.2003503502049d-01,-6.5537318838436d-01, 8.3613218456573d-01,
     |  -8.3613218456573d-01, 6.5537318838435d-01,-3.2003503502048d-01,
     |  -1.1443076072777d-01, 5.5814313290157d-01,-8.8299510913950d-01,
     |   9.2977434519617d-01,-5.4985704262252d-01,-2.6864804365585d-01,
     |   1.1219630850649d+00,-8.6315566626942d-01,-1.4206253038594d+00,
     |  -4.6990116733130d-01,-5.0648613143263d-02,-1.5287793718458d-03,
     |  -7.4276326794432d-06,-1.2081444705920d-09,-3.9300423106413d-18/
      data (pmn(lat,20,35), lat = 1,36)/
     |   4.4391216139500d-21, 1.2618966881652d-11, 2.2808269335263d-07,
     |   1.0092892619083d-04, 6.3636498318205d-03, 1.0959263710430d-01,
     |   6.7226773607405d-01, 1.4890258586915d+00, 5.0112803865097d-01,
     |  -1.1501363560535d+00, 4.5901298987392d-01, 4.3447779909300d-01,
     |  -9.0954428404327d-01, 8.6647384205290d-01,-4.6079103088543d-01,
     |  -8.3306875941936d-02, 5.6469904847993d-01,-8.4140286004534d-01,
     |   8.4140286004534d-01,-5.6469904847992d-01, 8.3306875941926d-02,
     |   4.6079103088543d-01,-8.6647384205290d-01, 9.0954428404328d-01,
     |  -4.3447779909299d-01,-4.5901298987392d-01, 1.1501363560535d+00,
     |  -5.0112803865097d-01,-1.4890258586915d+00,-6.7226773607405d-01,
     |  -1.0959263710430d-01,-6.3636498318205d-03,-1.0092892619083d-04,
     |  -2.2808269335264d-07,-1.2618966881652d-11,-4.4391216139500d-21/
      data (pmn(lat,22,35), lat = 1,36)/
     |   3.7548188928949d-24, 9.8273022175265d-14, 5.1724191271972d-09,
     |   4.8382377271027d-06, 5.6373012308591d-04, 1.7054423155783d-02,
     |   1.8678994345913d-01, 8.4536197477193d-01, 1.4765135218454d+00,
     |   2.3875371835020d-01,-1.1288370656304d+00, 5.2806612959959d-01,
     |   4.3654244614152d-01,-9.3605691064828d-01, 7.8732726306576d-01,
     |  -2.1227959151391d-01,-4.3493439453252d-01, 8.4501163600842d-01,
     |  -8.4501163600842d-01, 4.3493439453251d-01, 2.1227959151392d-01,
     |  -7.8732726306576d-01, 9.3605691064827d-01,-4.3654244614153d-01,
     |  -5.2806612959960d-01, 1.1288370656304d+00,-2.3875371835019d-01,
     |  -1.4765135218454d+00,-8.4536197477193d-01,-1.8678994345913d-01,
     |  -1.7054423155783d-02,-5.6373012308591d-04,-4.8382377271029d-06,
     |  -5.1724191271974d-09,-9.8273022175265d-14,-3.7548188928949d-24/
      data (pmn(lat,24,35), lat = 1,36)/
     |   2.3712206180608d-27, 5.6952305810998d-16, 8.6672764287274d-11,
     |   1.6929839258026d-07, 3.5730343230382d-05, 1.8354585450379d-03,
     |   3.3660943067629d-02, 2.6622115042171d-01, 9.6627192511243d-01,
     |   1.4349083026698d+00, 1.1072287137998d-01,-1.1161561077024d+00,
     |   4.7128445422140d-01, 5.7740045241479d-01,-9.7196547011856d-01,
     |   5.4633892179401d-01, 2.5518362037209d-01,-8.4573803364704d-01,
     |   8.4573803364704d-01,-2.5518362037209d-01,-5.4633892179402d-01,
     |   9.7196547011856d-01,-5.7740045241478d-01,-4.7128445422139d-01,
     |   1.1161561077024d+00,-1.1072287137998d-01,-1.4349083026698d+00,
     |  -9.6627192511244d-01,-2.6622115042171d-01,-3.3660943067629d-02,
     |  -1.8354585450379d-03,-3.5730343230382d-05,-1.6929839258027d-07,
     |  -8.6672764287279d-11,-5.6952305810998d-16,-2.3712206180608d-27/
      data (pmn(lat,26,35), lat = 1,36)/
     |   1.1040294851608d-30, 2.4272337207738d-18, 1.0622875504749d-12,
     |   4.2937641420999d-09, 1.6180237182981d-06, 1.3794945783677d-04,
     |   4.0763665803823d-03, 5.2346929919397d-02, 3.2770508005562d-01,
     |   1.0255313023600d+00, 1.4100180074775d+00, 1.4032800453506d-01,
     |  -1.1251391166917d+00, 2.4541457583659d-01, 8.3893662096612d-01,
     |  -8.6365612378628d-01,-1.3827936344899d-02, 8.4172965959919d-01,
     |  -8.4172965959919d-01, 1.3827936344896d-02, 8.6365612378628d-01,
     |  -8.3893662096612d-01,-2.4541457583659d-01, 1.1251391166917d+00,
     |  -1.4032800453505d-01,-1.4100180074775d+00,-1.0255313023600d+00,
     |  -3.2770508005562d-01,-5.2346929919398d-02,-4.0763665803823d-03,
     |  -1.3794945783677d-04,-1.6180237182981d-06,-4.2937641421000d-09,
     |  -1.0622875504750d-12,-2.4272337207738d-18,-1.1040294851608d-30/
      data (pmn(lat,28,35), lat = 1,36)/
     |   3.6929186769921d-34, 7.4168809287131d-21, 9.2954527997643d-15,
     |   7.7207114119761d-11, 5.1393862106874d-08, 7.1549581124630d-06,
     |   3.3211253324032d-04, 6.6355670600602d-03, 6.6006499170768d-02,
     |   3.5225710291423d-01, 1.0175729020014d+00, 1.4218773203803d+00,
     |   3.5818375150930d-01,-1.0862632970994d+00,-2.2735549588717d-01,
     |   1.0509181239336d+00,-2.9928810738348d-01,-8.2998805822463d-01,
     |   8.2998805822463d-01, 2.9928810738349d-01,-1.0509181239336d+00,
     |   2.2735549588717d-01, 1.0862632970994d+00,-3.5818375150930d-01,
     |  -1.4218773203803d+00,-1.0175729020014d+00,-3.5225710291423d-01,
     |  -6.6006499170769d-02,-6.6355670600602d-03,-3.3211253324032d-04,
     |  -7.1549581124630d-06,-5.1393862106874d-08,-7.7207114119764d-11,
     |  -9.2954527997649d-15,-7.4168809287131d-21,-3.6929186769921d-34/
      data (pmn(lat,30,35), lat = 1,36)/
     |   8.4589078687406d-38, 1.5494812770565d-23, 5.5422532650785d-17,
     |   9.4075550568763d-13, 1.0971280264679d-09, 2.4640975278558d-07,
     |   1.7646439687924d-05, 5.3354252195191d-04, 8.0523137994897d-03,
     |   6.7097760736634d-02, 3.2569678242778d-01, 9.2756640096042d-01,
     |   1.4396714128517d+00, 7.8840352154137d-01,-7.8071718069923d-01,
     |  -9.0912749187261d-01, 6.8690603833356d-01, 8.0515376734499d-01,
     |  -8.0515376734499d-01,-6.8690603833356d-01, 9.0912749187261d-01,
     |   7.8071718069923d-01,-7.8840352154137d-01,-1.4396714128517d+00,
     |  -9.2756640096043d-01,-3.2569678242778d-01,-6.7097760736635d-02,
     |  -8.0523137994898d-03,-5.3354252195192d-04,-1.7646439687925d-05,
     |  -2.4640975278558d-07,-1.0971280264679d-09,-9.4075550568766d-13,
     |  -5.5422532650789d-17,-1.5494812770565d-23,-8.4589078687406d-38/
      data (pmn(lat,32,35), lat = 1,36)/
     |   1.2087851921289d-41, 2.0168344427336d-26, 2.0531973191900d-19,
     |   7.0910532005818d-15, 1.4394493167775d-11, 5.1673117346694d-09,
     |   5.6339247790910d-07, 2.5281801049587d-05, 5.6200615005117d-04,
     |   6.9654512930407d-03, 5.1911482713254d-02, 2.4315323585958d-01,
     |   7.2624872194803d-01, 1.3440674748636d+00, 1.3315222409268d+00,
     |   1.4537306244630d-01,-1.1265724205233d+00,-7.5591196315154d-01,
     |   7.5591196315154d-01, 1.1265724205233d+00,-1.4537306244630d-01,
     |  -1.3315222409268d+00,-1.3440674748636d+00,-7.2624872194803d-01,
     |  -2.4315323585958d-01,-5.1911482713254d-02,-6.9654512930407d-03,
     |  -5.6200615005117d-04,-2.5281801049587d-05,-5.6339247790911d-07,
     |  -5.1673117346694d-09,-1.4394493167775d-11,-7.0910532005820d-15,
     |  -2.0531973191902d-19,-2.0168344427336d-26,-1.2087851921289d-41/
      data (pmn(lat,34,35), lat = 1,36)/
     |   8.6153864684276d-46, 1.3078939193132d-29, 3.7810659437998d-22,
     |   2.6474274000818d-17, 9.3056566320749d-14, 5.3003254266894d-11,
     |   8.7091190171250d-09, 5.7181062206340d-07, 1.8342049761139d-05,
     |   3.2788128662227d-04, 3.5718778803650d-03, 2.5222740037400d-02,
     |   1.2038495983240d-01, 3.9842321873705d-01, 9.2254609599813d-01,
     |   1.4712667312756d+00, 1.4976562271587d+00, 6.4893636999092d-01,
     |  -6.4893636999091d-01,-1.4976562271587d+00,-1.4712667312756d+00,
     |  -9.2254609599813d-01,-3.9842321873705d-01,-1.2038495983240d-01,
     |  -2.5222740037401d-02,-3.5718778803650d-03,-3.2788128662228d-04,
     |  -1.8342049761139d-05,-5.7181062206341d-07,-8.7091190171252d-09,
     |  -5.3003254266894d-11,-9.3056566320749d-14,-2.6474274000819d-17,
     |  -3.7810659438001d-22,-1.3078939193132d-29,-8.6153864684276d-46/
!
!     Zmn Basis Set zmn(lat,m,n)
      data (zmn(lat, 0, 0), lat = 1,36)/
     |   2.3490641842922d-03, 8.2463537327360d-03, 1.3229643528858d-02,
     |   1.8647469951069d-02, 2.3543023080653d-02, 2.8550067424809d-02,
     |   3.3108104619451d-02, 3.7603718778872d-02, 4.1655669807542d-02,
     |   4.5522521895799d-02, 4.8932114002537d-02, 5.2062110725661d-02,
     |   5.4718818423095d-02, 5.7022061778323d-02, 5.8841216534333d-02,
     |   6.0250704841040d-02, 6.1174823017764d-02, 6.1649294721211d-02,
     |   6.1649294721211d-02, 6.1174823017764d-02, 6.0250704841040d-02,
     |   5.8841216534333d-02, 5.7022061778323d-02, 5.4718818423095d-02,
     |   5.2062110725661d-02, 4.8932114002537d-02, 4.5522521895799d-02,
     |   4.1655669807542d-02, 3.7603718778872d-02, 3.3108104619452d-02,
     |   2.8550067424809d-02, 2.3543023080653d-02, 1.8647469951069d-02,
     |   1.3229643528858d-02, 8.2463537327360d-03, 2.3490641842922d-03/
      data (zmn(lat, 0, 1), lat = 1,36)/
     |   4.0625341846829d-03, 1.4167767768315d-02, 2.2359879545600d-02,
     |   3.0819298121973d-02, 3.7653586820473d-02, 4.3887095152989d-02,
     |   4.8335983842576d-02, 5.1704319236041d-02, 5.3158868995833d-02,
     |   5.3307215583740d-02, 5.1552617057075d-02, 4.8494886740161d-02,
     |   4.3715977059168d-02, 3.7844312713774d-02, 3.0596615396335d-02,
     |   2.2638345997272d-02, 1.3778189312883d-02, 4.7101571769983d-03,
     |  -4.7101571769983d-03,-1.3778189312883d-02,-2.2638345997272d-02,
     |  -3.0596615396335d-02,-3.7844312713774d-02,-4.3715977059168d-02,
     |  -4.8494886740161d-02,-5.1552617057075d-02,-5.3307215583740d-02,
     |  -5.3158868995833d-02,-5.1704319236041d-02,-4.8335983842576d-02,
     |  -4.3887095152989d-02,-3.7653586820473d-02,-3.0819298121973d-02,
     |  -2.2359879545600d-02,-1.4167767768315d-02,-4.0625341846829d-03/
      data (zmn(lat, 1, 1), lat = 1,36)/
     |   1.6261034096553d-04, 1.2814380088883d-03, 3.5432295318094d-03,
     |   6.8322042789634d-03, 1.1068693859339d-02, 1.6112800649451d-02,
     |   2.1818285921101d-02, 2.8007009220559d-02, 3.4494361054024d-02,
     |   4.1080673841791d-02, 4.7567771534204d-02, 5.3757040656615d-02,
     |   5.9461598444892d-02, 6.4507198606809d-02, 6.8741240084215d-02,
     |   7.2034541550065d-02, 7.4287418765375d-02, 7.5431173260324d-02,
     |   7.5431173260324d-02, 7.4287418765375d-02, 7.2034541550065d-02,
     |   6.8741240084215d-02, 6.4507198606809d-02, 5.9461598444892d-02,
     |   5.3757040656615d-02, 4.7567771534204d-02, 4.1080673841791d-02,
     |   3.4494361054024d-02, 2.8007009220559d-02, 2.1818285921101d-02,
     |   1.6112800649451d-02, 1.1068693859339d-02, 6.8322042789634d-03,
     |   3.5432295318094d-03, 1.2814380088883d-03, 1.6261034096552d-04/
      data (zmn(lat, 0, 2), lat = 1,36)/
     |   5.2332423191757d-03, 1.7981343786370d-02, 2.7482153159682d-02,
     |   3.6070575770820d-02, 4.1043568190153d-02, 4.3464438879477d-02,
     |   4.1927334010966d-02, 3.7392254538339d-02, 2.9324133034143d-02,
     |   1.8844760685127d-02, 6.0656256897331d-03,-7.7494329926194d-03,
     |  -2.2087881117916d-02,-3.5707572659808d-02,-4.7969634057914d-02,
     |  -5.7873846437252d-02,-6.4912916517691d-02,-6.8528146590482d-02,
     |  -6.8528146590482d-02,-6.4912916517691d-02,-5.7873846437252d-02,
     |  -4.7969634057914d-02,-3.5707572659808d-02,-2.2087881117916d-02,
     |  -7.7494329926195d-03, 6.0656256897331d-03, 1.8844760685127d-02,
     |   2.9324133034143d-02, 3.7392254538339d-02, 4.1927334010966d-02,
     |   4.3464438879477d-02, 4.1043568190153d-02, 3.6070575770820d-02,
     |   2.7482153159682d-02, 1.7981343786370d-02, 5.2332423191758d-03/
      data (zmn(lat, 1, 2), lat = 1,36)/
     |   3.6829658559418d-04, 2.8358338689638d-03, 7.7401325615932d-03,
     |   1.4565159532412d-02, 2.2871378418502d-02, 3.1953360104421d-02,
     |   4.1151717124976d-02, 4.9679175391703d-02, 5.6872515900920d-02,
     |   6.2054127112215d-02, 6.4755804683998d-02, 6.4580740641604d-02,
     |   6.1399211847019d-02, 5.5194172885585d-02, 4.6226549091445d-02,
     |   3.4857787982888d-02, 2.1686964947387d-02, 7.3522136416415d-03,
     |  -7.3522136416415d-03,-2.1686964947387d-02,-3.4857787982888d-02,
     |  -4.6226549091445d-02,-5.5194172885585d-02,-6.1399211847019d-02,
     |  -6.4580740641604d-02,-6.4755804683998d-02,-6.2054127112215d-02,
     |  -5.6872515900920d-02,-4.9679175391703d-02,-4.1151717124976d-02,
     |  -3.1953360104421d-02,-2.2871378418502d-02,-1.4565159532412d-02,
     |  -7.7401325615932d-03,-2.8358338689637d-03,-3.6829658559417d-04/
      data (zmn(lat, 2, 2), lat = 1,36)/
     |   7.9301742204996d-06, 1.8700373328235d-04, 8.5741493514030d-04,
     |   2.2969823265160d-03, 4.7357748070639d-03, 8.3182437095849d-03,
     |   1.3106663793507d-02, 1.9062017710248d-02, 2.6054722822106d-02,
     |   3.3862845527517d-02, 4.2192423057579d-02, 5.0689680164262d-02,
     |   5.8968558323623d-02, 6.6631338014049d-02, 7.3297957109821d-02,
     |   7.8628015782282d-02, 8.2345304727730d-02, 8.4254347649374d-02,
     |   8.4254347649374d-02, 8.2345304727730d-02, 7.8628015782282d-02,
     |   7.3297957109821d-02, 6.6631338014048d-02, 5.8968558323623d-02,
     |   5.0689680164262d-02, 4.2192423057579d-02, 3.3862845527517d-02,
     |   2.6054722822106d-02, 1.9062017710248d-02, 1.3106663793507d-02,
     |   8.3182437095849d-03, 4.7357748070639d-03, 2.2969823265161d-03,
     |   8.5741493514034d-04, 1.8700373328240d-04, 7.9301742205855d-06/
      data (zmn(lat, 0, 3), lat = 1,36)/
     |   6.1673127477326d-03, 2.0746158963050d-02, 3.0111545111917d-02,
     |   3.6495590620101d-02, 3.6381809523074d-02, 3.1398152939257d-02,
     |   2.0437806993687d-02, 5.9296000308052d-03,-1.1590092478424d-02,
     |  -2.9079567339563d-02,-4.5323734510586d-02,-5.7482230584629d-02,
     |  -6.4750447032857d-02,-6.5361460113004d-02,-5.9732518548633d-02,
     |  -4.7624241914544d-02,-3.0873226238075d-02,-1.0556712334668d-02,
     |   1.0556712334668d-02, 3.0873226238075d-02, 4.7624241914544d-02,
     |   5.9732518548633d-02, 6.5361460113004d-02, 6.4750447032857d-02,
     |   5.7482230584629d-02, 4.5323734510586d-02, 2.9079567339563d-02,
     |   1.1590092478424d-02,-5.9296000308051d-03,-2.0437806993687d-02,
     |  -3.1398152939257d-02,-3.6381809523074d-02,-3.6495590620101d-02,
     |  -3.0111545111917d-02,-2.0746158963050d-02,-6.1673127477325d-03/
      data (zmn(lat, 1, 3), lat = 1,36)/
     |   6.0779446321451d-04, 4.6917891358662d-03, 1.2482011037274d-02,
     |   2.2673523063378d-02, 3.3834603037809d-02, 4.4220066667347d-02,
     |   5.2177575447341d-02, 5.6248050402231d-02, 5.5430908915394d-02,
     |   4.9267697500577d-02, 3.7953100867733d-02, 2.2298713986933d-02,
     |   3.6746519868182d-03,-1.6157624751017d-02,-3.5229292451764d-02,
     |  -5.1599363583990d-02,-6.3569916845315d-02,-6.9888187426993d-02,
     |  -6.9888187426993d-02,-6.3569916845315d-02,-5.1599363583990d-02,
     |  -3.5229292451765d-02,-1.6157624751017d-02, 3.6746519868182d-03,
     |   2.2298713986932d-02, 3.7953100867733d-02, 4.9267697500577d-02,
     |   5.5430908915394d-02, 5.6248050402231d-02, 5.2177575447341d-02,
     |   4.4220066667347d-02, 3.3834603037809d-02, 2.2673523063378d-02,
     |   1.2482011037274d-02, 4.6917891358662d-03, 6.0779446321458d-04/
      data (zmn(lat, 2, 3), lat = 1,36)/
     |   2.0983647630095d-05, 4.9046571131637d-04, 2.2148449147889d-03,
     |   5.7958165523881d-03, 1.1576113189676d-02, 1.9521101566375d-02,
     |   2.9246537607901d-02, 4.0011161410097d-02, 5.0824055838579d-02,
     |   6.0527551399119d-02, 6.7956845736696d-02, 7.2058047573705d-02,
     |   7.2040690974726d-02, 6.7462769774637d-02, 5.8315812875033d-02,
     |   4.5025470743444d-02, 2.8437622669662d-02, 9.7229497074777d-03,
     |  -9.7229497074777d-03,-2.8437622669662d-02,-4.5025470743444d-02,
     |  -5.8315812875033d-02,-6.7462769774637d-02,-7.2040690974726d-02,
     |  -7.2058047573705d-02,-6.7956845736696d-02,-6.0527551399119d-02,
     |  -5.0824055838579d-02,-4.0011161410097d-02,-2.9246537607901d-02,
     |  -1.9521101566375d-02,-1.1576113189676d-02,-5.7958165523881d-03,
     |  -2.2148449147890d-03,-4.9046571131634d-04,-2.0983647630082d-05/
      data (zmn(lat, 3, 3), lat = 1,36)/
     |   1.6465865405854d-07, 2.6571985104004d-05, 2.0024354460898d-04,
     |   7.4625793260487d-04, 1.9573172475295d-03, 4.1488721917753d-03,
     |   7.6062746990482d-03, 1.2534157312310d-02, 1.9012519637232d-02,
     |   2.6966836646867d-02, 3.6155384712077d-02, 4.6176732066800d-02,
     |   5.6496570603167d-02, 6.6491755295166d-02, 7.5506511401665d-02,
     |   8.2914877078448d-02, 8.8182146806179d-02, 9.0918489074921d-02,
     |   9.0918489074921d-02, 8.8182146806179d-02, 8.2914877078448d-02,
     |   7.5506511401665d-02, 6.6491755295166d-02, 5.6496570603167d-02,
     |   4.6176732066800d-02, 3.6155384712077d-02, 2.6966836646867d-02,
     |   1.9012519637232d-02, 1.2534157312310d-02, 7.6062746990482d-03,
     |   4.1488721917753d-03, 1.9573172475295d-03, 7.4625793260487d-04,
     |   2.0024354460897d-04, 2.6571985104024d-05, 1.6465865403121d-07/
      data (zmn(lat, 0, 4), lat = 1,36)/
     |   6.9603855834413d-03, 2.2721316401626d-02, 3.0681030550314d-02,
     |   3.2771617899440d-02, 2.5398262899747d-02, 1.1528878263922d-02,
     |  -7.9848124658127d-03,-2.8290487937215d-02,-4.6463021662070d-02,
     |  -5.7945741250306d-02,-6.0853288855581d-02,-5.3488162537099d-02,
     |  -3.7102354393372d-02,-1.3703081012705d-02, 1.2626443556701d-02,
     |   3.7780582616740d-02, 5.7321045923969d-02, 6.8041386002758d-02,
     |   6.8041386002758d-02, 5.7321045923969d-02, 3.7780582616740d-02,
     |   1.2626443556702d-02,-1.3703081012705d-02,-3.7102354393372d-02,
     |  -5.3488162537099d-02,-6.0853288855581d-02,-5.7945741250306d-02,
     |  -4.6463021662070d-02,-2.8290487937215d-02,-7.9848124658128d-03,
     |   1.1528878263922d-02, 2.5398262899747d-02, 3.2771617899440d-02,
     |   3.0681030550314d-02, 2.2721316401626d-02, 6.9603855834413d-03/
      data (zmn(lat, 1, 4), lat = 1,36)/
     |   9.0104723410393d-04, 6.7370275142141d-03, 1.7407880418134d-02,
     |   3.0027901495855d-02, 4.1670283612284d-02, 4.9059368427944d-02,
     |   4.9882907312658d-02, 4.2760239626593d-02, 2.8048402792771d-02,
     |   7.3956286365001d-03,-1.6080094571037d-02,-3.8739496516942d-02,
     |  -5.6663881157362d-02,-6.6768406933765d-02,-6.6985630092983d-02,
     |  -5.7058887045818d-02,-3.8236214106594d-02,-1.3468673762606d-02,
     |   1.3468673762606d-02, 3.8236214106594d-02, 5.7058887045818d-02,
     |   6.6985630092983d-02, 6.6768406933765d-02, 5.6663881157362d-02,
     |   3.8739496516942d-02, 1.6080094571037d-02,-7.3956286365001d-03,
     |  -2.8048402792771d-02,-4.2760239626593d-02,-4.9882907312658d-02,
     |  -4.9059368427944d-02,-4.1670283612284d-02,-3.0027901495855d-02,
     |  -1.7407880418134d-02,-6.7370275142141d-03,-9.0104723410391d-04/
      data (zmn(lat, 2, 4), lat = 1,36)/
     |   4.1166083375704d-05, 9.5223389158065d-04, 4.2120099791081d-03,
     |   1.0676005459148d-02, 2.0403871110437d-02, 3.2470820677364d-02,
     |   4.5166842973343d-02, 5.6224132331105d-02, 6.3293767811210d-02,
     |   6.4368848084400d-02, 5.8249737334009d-02, 4.4812692644370d-02,
     |   2.5150708476057d-02, 1.4494818347621d-03,-2.3298091156370d-02,
     |  -4.5764581955720d-02,-6.2808198433443d-02,-7.1994649394757d-02,
     |  -7.1994649394757d-02,-6.2808198433443d-02,-4.5764581955720d-02,
     |  -2.3298091156370d-02, 1.4494818347621d-03, 2.5150708476058d-02,
     |   4.4812692644370d-02, 5.8249737334009d-02, 6.4368848084400d-02,
     |   6.3293767811210d-02, 5.6224132331105d-02, 4.5166842973343d-02,
     |   3.2470820677364d-02, 2.0403871110437d-02, 1.0676005459148d-02,
     |   4.2120099791082d-03, 9.5223389158067d-04, 4.1166083375676d-05/
      data (zmn(lat, 3, 4), lat = 1,36)/
     |   4.1253862616498d-07, 7.9114941443775d-05, 5.8640995197933d-04,
     |   2.1352374870468d-03, 5.4248950636909d-03, 1.1040364705910d-02,
     |   1.9245120079860d-02, 2.9832127681551d-02, 4.2052418565386d-02,
     |   5.4655673274163d-02, 6.6029930023871d-02, 7.4432301129864d-02,
     |   7.8261558418462d-02, 7.6335960388182d-02, 6.8115656669268d-02,
     |   5.3838272920934d-02, 3.4530158566020d-02, 1.1897507348070d-02,
     |  -1.1897507348070d-02,-3.4530158566020d-02,-5.3838272920934d-02,
     |  -6.8115656669268d-02,-7.6335960388182d-02,-7.8261558418462d-02,
     |  -7.4432301129864d-02,-6.6029930023871d-02,-5.4655673274163d-02,
     |  -4.2052418565386d-02,-2.9832127681551d-02,-1.9245120079860d-02,
     |  -1.1040364705910d-02,-5.4248950636909d-03,-2.1352374870469d-03,
     |  -5.8640995197936d-04,-7.9114941443780d-05,-4.1253862618522d-07/
      data (zmn(lat, 4, 4), lat = 1,36)/
     |   7.6179896656218d-09, 3.6787301375931d-06, 4.5969685882463d-05,
     |   2.3801647880222d-04, 7.9446934583380d-04, 2.0319448547363d-03,
     |   4.3347573437766d-03, 8.0931675242083d-03, 1.3623832104390d-02,
     |   2.1088085315593d-02, 3.0423971308875d-02, 4.1307474900094d-02,
     |   5.3152937606895d-02, 6.5156748703715d-02, 7.6380090389029d-02,
     |   8.5859871779224d-02, 9.2731117819141d-02, 9.6341836801639d-02,
     |   9.6341836801639d-02, 9.2731117819141d-02, 8.5859871779224d-02,
     |   7.6380090389029d-02, 6.5156748703715d-02, 5.3152937606894d-02,
     |   4.1307474900094d-02, 3.0423971308875d-02, 2.1088085315593d-02,
     |   1.3623832104390d-02, 8.0931675242083d-03, 4.3347573437766d-03,
     |   2.0319448547363d-03, 7.9446934583378d-04, 2.3801647880222d-04,
     |   4.5969685882468d-05, 3.6787301376303d-06, 7.6179897061154d-09/
      data (zmn(lat, 0, 5), lat = 1,36)/
     |   7.6448147927184d-03, 2.4046876695725d-02, 2.9369666552201d-02,
     |   2.5652389855048d-02, 1.0138081520988d-02,-1.1052176244004d-02,
     |  -3.3996852993517d-02,-5.0497366182402d-02,-5.6670922515021d-02,
     |  -4.8603483867251d-02,-2.8412910810356d-02, 6.1235289987543d-04,
     |   3.0678582334016d-02, 5.5283893868200d-02, 6.7281768655012d-02,
     |   6.4213551684878d-02, 4.5666307793827d-02, 1.6678124985909d-02,
     |  -1.6678124985908d-02,-4.5666307793827d-02,-6.4213551684878d-02,
     |  -6.7281768655012d-02,-5.5283893868200d-02,-3.0678582334015d-02,
     |  -6.1235289987557d-04, 2.8412910810356d-02, 4.8603483867251d-02,
     |   5.6670922515021d-02, 5.0497366182402d-02, 3.3996852993517d-02,
     |   1.1052176244004d-02,-1.0138081520988d-02,-2.5652389855047d-02,
     |  -2.9369666552201d-02,-2.4046876695724d-02,-7.6448147927184d-03/
      data (zmn(lat, 1, 5), lat = 1,36)/
     |   1.2024694195870d-03, 8.9395008093990d-03, 2.2124495205163d-02,
     |   3.5716540620362d-02, 4.4637599978856d-02, 4.4579183961341d-02,
     |   3.3716805608124d-02, 1.3175000095088d-02,-1.2950924272345d-02,
     |  -3.8662181720597d-02,-5.7508449305604d-02,-6.4360981741931d-02,
     |  -5.6792834316904d-02,-3.5872952878727d-02,-6.0042996301525d-03,
     |   2.6059097306850d-02, 5.2860285294747d-02, 6.8069191493679d-02,
     |   6.8069191493679d-02, 5.2860285294747d-02, 2.6059097306851d-02,
     |  -6.0042996301524d-03,-3.5872952878727d-02,-5.6792834316904d-02,
     |  -6.4360981741931d-02,-5.7508449305604d-02,-3.8662181720598d-02,
     |  -1.2950924272345d-02, 1.3175000095088d-02, 3.3716805608124d-02,
     |   4.4579183961341d-02, 4.4637599978856d-02, 3.5716540620362d-02,
     |   2.2124495205163d-02, 8.9395008093990d-03, 1.2024694195870d-03/
      data (zmn(lat, 2, 5), lat = 1,36)/
     |   6.9509194697826d-05, 1.5847816965646d-03, 6.8301860504165d-03,
     |   1.6614501329908d-02, 2.9960690669036d-02, 4.4036644341652d-02,
     |   5.4996751494744d-02, 5.8933281967044d-02, 5.3161341607774d-02,
     |   3.7062683532923d-02, 1.2597987985849d-02,-1.6005804309250d-02,
     |  -4.3049016817137d-02,-6.2725882723402d-02,-7.0469787208856d-02,
     |  -6.4175348078964d-02,-4.4745566856377d-02,-1.6034241310201d-02,
     |   1.6034241310201d-02, 4.4745566856377d-02, 6.4175348078964d-02,
     |   7.0469787208856d-02, 6.2725882723402d-02, 4.3049016817137d-02,
     |   1.6005804309250d-02,-1.2597987985849d-02,-3.7062683532923d-02,
     |  -5.3161341607774d-02,-5.8933281967044d-02,-5.4996751494744d-02,
     |  -4.4036644341652d-02,-2.9960690669036d-02,-1.6614501329908d-02,
     |  -6.8301860504166d-03,-1.5847816965647d-03,-6.9509194697870d-05/
      data (zmn(lat, 3, 5), lat = 1,36)/
     |   1.0653460628990d-06, 1.7290466041844d-04, 1.2582393585415d-03,
     |   4.4465783058125d-03, 1.0844308662214d-02, 2.0919368682095d-02,
     |   3.4067884065441d-02, 4.8479044790257d-02, 6.1357992359628d-02,
     |   6.9489534751187d-02, 7.0009114348973d-02, 6.1192135388718d-02,
     |   4.3045665627454d-02, 1.7533075843844d-02,-1.1656384185582d-02,
     |  -3.9763610130006d-02,-6.1905505354247d-02,-7.4094734775309d-02,
     |  -7.4094734775309d-02,-6.1905505354247d-02,-3.9763610130006d-02,
     |  -1.1656384185582d-02, 1.7533075843844d-02, 4.3045665627454d-02,
     |   6.1192135388718d-02, 7.0009114348974d-02, 6.9489534751187d-02,
     |   6.1357992359628d-02, 4.8479044790257d-02, 3.4067884065441d-02,
     |   2.0919368682095d-02, 1.0844308662214d-02, 4.4465783058126d-03,
     |   1.2582393585415d-03, 1.7290466041838d-04, 1.0653460629847d-06/
      data (zmn(lat, 4, 5), lat = 1,36)/
     |   2.4736925761353d-08, 1.2098097880200d-05, 1.4884768348373d-04,
     |   7.5287847120242d-04, 2.4343781588138d-03, 5.9777475804817d-03,
     |   1.2125233273797d-02, 2.1295197442891d-02, 3.3313971342113d-02,
     |   4.7251643318320d-02, 6.1427000388490d-02, 7.3610805792331d-02,
     |   8.1400891124562d-02, 8.2698087184319d-02, 7.6176015364787d-02,
     |   6.1634433473627d-02, 4.0143883358867d-02, 1.3937702385639d-02,
     |  -1.3937702385639d-02,-4.0143883358867d-02,-6.1634433473627d-02,
     |  -7.6176015364787d-02,-8.2698087184319d-02,-8.1400891124562d-02,
     |  -7.3610805792331d-02,-6.1427000388490d-02,-4.7251643318320d-02,
     |  -3.3313971342113d-02,-2.1295197442891d-02,-1.2125233273797d-02,
     |  -5.9777475804817d-03,-2.4343781588138d-03,-7.5287847120242d-04,
     |  -1.4884768348370d-04,-1.2098097880138d-05,-2.4736925759420d-08/
      data (zmn(lat, 5, 5), lat = 1,36)/
     |   4.0064203936745d-09, 4.9997714215357d-07, 1.0438867166262d-05,
     |   7.5062836164039d-05, 3.1887300547252d-04, 9.8403926160312d-04,
     |   2.4427454140746d-03, 5.1672771571915d-03, 9.6533731239997d-03,
     |   1.6306633523734d-02, 2.5315058671685d-02, 3.6538789771207d-02,
     |   4.9448435225793d-02, 6.3135130707146d-02, 7.6400467910441d-02,
     |   8.7916033811687d-02, 9.6425168374616d-02, 1.0094799906569d-01,
     |   1.0094799906569d-01, 9.6425168374616d-02, 8.7916033811687d-02,
     |   7.6400467910441d-02, 6.3135130707146d-02, 4.9448435225793d-02,
     |   3.6538789771207d-02, 2.5315058671685d-02, 1.6306633523734d-02,
     |   9.6533731239997d-03, 5.1672771571916d-03, 2.4427454140747d-03,
     |   9.8403926160316d-04, 3.1887300547255d-04, 7.5062836164090d-05,
     |   1.0438867166302d-05, 4.9997714218424d-07, 4.0064203570659d-09/
      data (zmn(lat, 0, 6), lat = 1,36)/
     |   8.2508277376169d-03, 2.4760099519334d-02, 2.6419166679892d-02,
     |   1.5937892994659d-02,-6.7698530474251d-03,-3.1085258380875d-02,
     |  -4.9148722232403d-02,-5.1511701024566d-02,-3.6739045465831d-02,
     |  -7.4085554128795d-03, 2.6474082652328d-02, 5.4226387530847d-02,
     |   6.5392607754610d-02, 5.5889497749216d-02, 2.7677377373863d-02,
     |  -1.0138812905492d-02,-4.5529603152060d-02,-6.6696388870208d-02,
     |  -6.6696388870208d-02,-4.5529603152060d-02,-1.0138812905492d-02,
     |   2.7677377373863d-02, 5.5889497749216d-02, 6.5392607754610d-02,
     |   5.4226387530847d-02, 2.6474082652328d-02,-7.4085554128795d-03,
     |  -3.6739045465831d-02,-5.1511701024566d-02,-4.9148722232403d-02,
     |  -3.1085258380875d-02,-6.7698530474251d-03, 1.5937892994659d-02,
     |   2.6419166679892d-02, 2.4760099519334d-02, 8.2508277376169d-03/
      data (zmn(lat, 1, 6), lat = 1,36)/
     |   1.5664581735067d-03, 1.1175141478369d-02, 2.6370678532360d-02,
     |   3.8933485175727d-02, 4.1922124517292d-02, 3.1067138352790d-02,
     |   7.8692007742483d-03,-2.1463426541103d-02,-4.7179941540235d-02,
     |  -6.0191601271209d-02,-5.4725778586882d-02,-3.1379723931929d-02,
     |   3.4213664509027d-03, 3.8666171837446d-02, 6.3051295887402d-02,
     |   6.8152242861830d-02, 5.2035019167271d-02, 1.9370995413945d-02,
     |  -1.9370995413945d-02,-5.2035019167271d-02,-6.8152242861830d-02,
     |  -6.3051295887402d-02,-3.8666171837446d-02,-3.4213664509025d-03,
     |   3.1379723931929d-02, 5.4725778586882d-02, 6.0191601271209d-02,
     |   4.7179941540235d-02, 2.1463426541103d-02,-7.8692007742483d-03,
     |  -3.1067138352790d-02,-4.1922124517292d-02,-3.8933485175727d-02,
     |  -2.6370678532360d-02,-1.1175141478369d-02,-1.5664581735068d-03/
      data (zmn(lat, 2, 6), lat = 1,36)/
     |   1.0671882505893d-04, 2.3943708627340d-03, 9.9955075090631d-03,
     |   2.3102264766515d-02, 3.8648639675155d-02, 5.0958720594204d-02,
     |   5.4077737310431d-02, 4.4096787985822d-02, 2.1231761674787d-02,
     |  -9.7387794892038d-03,-4.0500356385148d-02,-6.1809805488856d-02,
     |  -6.6507547279012d-02,-5.2154619510492d-02,-2.2112593906634d-02,
     |   1.5194023229141d-02, 4.8804287141126d-02, 6.8616220367340d-02,
     |   6.8616220367340d-02, 4.8804287141126d-02, 1.5194023229141d-02,
     |  -2.2112593906634d-02,-5.2154619510492d-02,-6.6507547279012d-02,
     |  -6.1809805488856d-02,-4.0500356385148d-02,-9.7387794892038d-03,
     |   2.1231761674787d-02, 4.4096787985822d-02, 5.4077737310431d-02,
     |   5.0958720594204d-02, 3.8648639675155d-02, 2.3102264766515d-02,
     |   9.9955075090631d-03, 2.3943708627340d-03, 1.0671882505899d-04/
      data (zmn(lat, 3, 6), lat = 1,36)/
     |   1.6440480379152d-06, 3.2174082515456d-04, 2.2840719223357d-03,
     |   7.7845244582086d-03, 1.8037574749500d-02, 3.2489561145635d-02,
     |   4.8318490907050d-02, 6.0913146085055d-02, 6.5202287030584d-02,
     |   5.7474893203253d-02, 3.6991352013570d-02, 6.8023467438085d-03,
     |  -2.6664201404533d-02,-5.5183151607789d-02,-7.1086623550199d-02,
     |  -6.9616476439554d-02,-5.0542928044873d-02,-1.8444916742300d-02,
     |   1.8444916742300d-02, 5.0542928044873d-02, 6.9616476439554d-02,
     |   7.1086623550199d-02, 5.5183151607789d-02, 2.6664201404533d-02,
     |  -6.8023467438084d-03,-3.6991352013570d-02,-5.7474893203253d-02,
     |  -6.5202287030584d-02,-6.0913146085055d-02,-4.8318490907050d-02,
     |  -3.2489561145635d-02,-1.8037574749500d-02,-7.7845244582087d-03,
     |  -2.2840719223357d-03,-3.2174082515462d-04,-1.6440480378392d-06/
      data (zmn(lat, 4, 6), lat = 1,36)/
     |   5.9940487223577d-08, 2.9107046233049d-05, 3.5151462772415d-04,
     |   1.7280880579067d-03, 5.3733812079929d-03, 1.2539942068240d-02,
     |   2.3849853525880d-02, 3.8650411081678d-02, 5.4692662664758d-02,
     |   6.8358021456646d-02, 7.5462075232808d-02, 7.2454334613744d-02,
     |   5.7651757632148d-02, 3.2091896845514d-02,-3.2861261163079d-04,
     |  -3.3551614511827d-02,-6.0751187032229d-02,-7.6047634298375d-02,
     |  -7.6047634298375d-02,-6.0751187032229d-02,-3.3551614511827d-02,
     |  -3.2861261163084d-04, 3.2091896845514d-02, 5.7651757632148d-02,
     |   7.2454334613744d-02, 7.5462075232808d-02, 6.8358021456646d-02,
     |   5.4692662664758d-02, 3.8650411081678d-02, 2.3849853525880d-02,
     |   1.2539942068240d-02, 5.3733812079929d-03, 1.7280880579067d-03,
     |   3.5151462772417d-04, 2.9107046233086d-05, 5.9940487211525d-08/
      data (zmn(lat, 5, 6), lat = 1,36)/
     |   1.7162918179397d-08, 1.7845396193546d-06, 3.6748434316529d-05,
     |   2.5811399447196d-04, 1.0621990140299d-03, 3.1471152659568d-03,
     |   7.4281255282721d-03, 1.4780870326839d-02, 2.5661479963627d-02,
     |   3.9720920400788d-02, 5.5564545153637d-02, 7.0785180209438d-02,
     |   8.2324640607883d-02, 8.7112887028759d-02, 8.2834167715748d-02,
     |   6.8608274484600d-02, 4.5379507363778d-02, 1.5876284693738d-02,
     |  -1.5876284693737d-02,-4.5379507363778d-02,-6.8608274484599d-02,
     |  -8.2834167715748d-02,-8.7112887028759d-02,-8.2324640607883d-02,
     |  -7.0785180209438d-02,-5.5564545153637d-02,-3.9720920400788d-02,
     |  -2.5661479963627d-02,-1.4780870326839d-02,-7.4281255282722d-03,
     |  -3.1471152659568d-03,-1.0621990140299d-03,-2.5811399447192d-04,
     |  -3.6748434316478d-05,-1.7845396192903d-06,-1.7162918202306d-08/
      data (zmn(lat, 6, 6), lat = 1,36)/
     |   1.8189348107393d-10, 6.7924878724782d-08, 2.3516418212015d-06,
     |   2.3493505696747d-05, 1.2701016167686d-04, 4.7293241238011d-04,
     |   1.3660789010604d-03, 3.2740849038171d-03, 6.7880259218009d-03,
     |   1.2513426538920d-02, 2.0903867599798d-02, 3.2074832981278d-02,
     |   4.5652286087449d-02, 6.0711013498348d-02, 7.5839694186420d-02,
     |   8.9336853776766d-02, 9.9503882172281d-02, 1.0497000531793d-01,
     |   1.0497000531793d-01, 9.9503882172281d-02, 8.9336853776766d-02,
     |   7.5839694186420d-02, 6.0711013498348d-02, 4.5652286087449d-02,
     |   3.2074832981278d-02, 2.0903867599798d-02, 1.2513426538920d-02,
     |   6.7880259218009d-03, 3.2740849038171d-03, 1.3660789010604d-03,
     |   4.7293241238008d-04, 1.2701016167683d-04, 2.3493505696712d-05,
     |   2.3516418211621d-06, 6.7924878710563d-08, 1.8189347335944d-10/
      data (zmn(lat, 0, 7), lat = 1,36)/
     |   8.7819366041321d-03, 2.4931891034342d-02, 2.2007570437798d-02,
     |   4.7155895067926d-03,-2.2712319833893d-02,-4.3836780988522d-02,
     |  -4.8786269355512d-02,-3.0841438259561d-02, 2.5332292975612d-03,
     |   3.8832849089832d-02, 6.0407843736529d-02, 5.7703223212429d-02,
     |   2.9325258546131d-02,-1.2456641189696d-02,-5.0959820097393d-02,
     |  -6.8426940725835d-02,-5.7791197167594d-02,-2.2268200499312d-02,
     |   2.2268200499312d-02, 5.7791197167594d-02, 6.8426940725835d-02,
     |   5.0959820097393d-02, 1.2456641189696d-02,-2.9325258546132d-02,
     |  -5.7703223212429d-02,-6.0407843736529d-02,-3.8832849089832d-02,
     |  -2.5332292975611d-03, 3.0841438259561d-02, 4.8786269355512d-02,
     |   4.3836780988523d-02, 2.2712319833893d-02,-4.7155895067926d-03,
     |  -2.2007570437798d-02,-2.4931891034342d-02,-8.7819366041321d-03/
      data (zmn(lat, 1, 7), lat = 1,36)/
     |   1.9135851050577d-03, 1.3458793353278d-02, 2.9789629854463d-02,
     |   3.9265820715895d-02, 3.3515679362770d-02, 1.1127312856515d-02,
     |  -2.0279119365991d-02,-4.7425630953909d-02,-5.7227471476807d-02,
     |  -4.3382277800820d-02,-9.8289588131908d-03, 3.0217234112388d-02,
     |   5.9796218290861d-02, 6.5610965403956d-02, 4.4189559388158d-02,
     |   3.7553437485531d-03,-3.9025764412769d-02,-6.6170665687326d-02,
     |  -6.6170665687326d-02,-3.9025764412769d-02, 3.7553437485528d-03,
     |   4.4189559388158d-02, 6.5610965403956d-02, 5.9796218290861d-02,
     |   3.0217234112388d-02,-9.8289588131909d-03,-4.3382277800820d-02,
     |  -5.7227471476807d-02,-4.7425630953909d-02,-2.0279119365992d-02,
     |   1.1127312856515d-02, 3.3515679362769d-02, 3.9265820715895d-02,
     |   2.9789629854463d-02, 1.3458793353278d-02, 1.9135851050577d-03/
      data (zmn(lat, 2, 7), lat = 1,36)/
     |   1.5374225856784d-04, 3.3803099445976d-03, 1.3589423483143d-02,
     |   2.9502847501767d-02, 4.4828329587962d-02, 5.0726332047334d-02,
     |   4.0788088271634d-02, 1.4788743801850d-02,-1.9760050697909d-02,
     |  -5.0197174354313d-02,-6.3724707467394d-02,-5.3376309398777d-02,
     |  -2.1530681186362d-02, 2.0215546895268d-02, 5.5557487369404d-02,
     |   7.0035691315703d-02, 5.7328747868390d-02, 2.2014154940766d-02,
     |  -2.2014154940766d-02,-5.7328747868390d-02,-7.0035691315703d-02,
     |  -5.5557487369404d-02,-2.0215546895268d-02, 2.1530681186362d-02,
     |   5.3376309398777d-02, 6.3724707467394d-02, 5.0197174354313d-02,
     |   1.9760050697909d-02,-1.4788743801850d-02,-4.0788088271634d-02,
     |  -5.0726332047334d-02,-4.4828329587962d-02,-2.9502847501767d-02,
     |  -1.3589423483143d-02,-3.3803099445975d-03,-1.5374225856785d-04/
      data (zmn(lat, 3, 7), lat = 1,36)/
     |   3.2788994216708d-06, 5.3775242293586d-04, 3.7170530181548d-03,
     |   1.2125557014961d-02, 2.6390880639197d-02, 4.3559021210597d-02,
     |   5.7292390757720d-02, 6.0188654053885d-02, 4.7273916305807d-02,
     |   1.9064219751231d-02,-1.7446155695286d-02,-5.0638497885474d-02,
     |  -6.8482347471723d-02,-6.3448118087794d-02,-3.6013907691276d-02,
     |   4.8804690856979d-03, 4.4826259441310d-02, 6.9310286467415d-02,
     |   6.9310286467415d-02, 4.4826259441310d-02, 4.8804690856980d-03,
     |  -3.6013907691276d-02,-6.3448118087794d-02,-6.8482347471723d-02,
     |  -5.0638497885475d-02,-1.7446155695286d-02, 1.9064219751231d-02,
     |   4.7273916305807d-02, 6.0188654053885d-02, 5.7292390757720d-02,
     |   4.3559021210597d-02, 2.6390880639197d-02, 1.2125557014961d-02,
     |   3.7170530181549d-03, 5.3775242293592d-04, 3.2788994216335d-06/
      data (zmn(lat, 4, 7), lat = 1,36)/
     |   1.1998537268867d-07, 5.9160887322085d-05, 6.9889750591080d-04,
     |   3.3219070187799d-03, 9.8545692456597d-03, 2.1604353439644d-02,
     |   3.7873237710897d-02, 5.5179351552246d-02, 6.7735785019442d-02,
     |   6.9306113937113d-02, 5.5827136813497d-02, 2.7713845682225d-02,
     |  -9.2898169390075d-03,-4.5326504832481d-02,-6.9491198118647d-02,
     |  -7.3683908243048d-02,-5.5770325788048d-02,-2.0734105070634d-02,
     |   2.0734105070634d-02, 5.5770325788048d-02, 7.3683908243048d-02,
     |   6.9491198118647d-02, 4.5326504832481d-02, 9.2898169390074d-03,
     |  -2.7713845682225d-02,-5.5827136813497d-02,-6.9306113937113d-02,
     |  -6.7735785019442d-02,-5.5179351552246d-02,-3.7873237710897d-02,
     |  -2.1604353439644d-02,-9.8545692456598d-03,-3.3219070187799d-03,
     |  -6.9889750591074d-04,-5.9160887322118d-05,-1.1998537262626d-07/
      data (zmn(lat, 5, 7), lat = 1,36)/
     |   3.9196089136840d-08, 4.6543985909309d-06, 9.4007168440726d-05,
     |   6.4234971536569d-04, 2.5451633098652d-03, 7.1791258995393d-03,
     |   1.5926312162789d-02, 2.9340447288669d-02, 4.6297569772082d-02,
     |   6.3600182388868d-02, 7.6404342476582d-02, 7.9523855006780d-02,
     |   6.9262120303343d-02, 4.5111396401681d-02, 1.0600885542741d-02,
     |  -2.7176000492937d-02,-5.9347031348996d-02,-7.7832432211818d-02,
     |  -7.7832432211818d-02,-5.9347031348996d-02,-2.7176000492937d-02,
     |   1.0600885542741d-02, 4.5111396401681d-02, 6.9262120303343d-02,
     |   7.9523855006780d-02, 7.6404342476582d-02, 6.3600182388868d-02,
     |   4.6297569772082d-02, 2.9340447288669d-02, 1.5926312162789d-02,
     |   7.1791258995393d-03, 2.5451633098652d-03, 6.4234971536573d-04,
     |   9.4007168440740d-05, 4.6543985908767d-06, 3.9196089231023d-08/
      data (zmn(lat, 6, 7), lat = 1,36)/
     |   7.2548370410767d-10, 2.6075642085413d-07, 8.8920843284494d-06,
     |   8.6778514193228d-05, 4.5446414594645d-04, 1.6247014628361d-03,
     |   4.4622164314989d-03, 1.0060097931664d-02, 1.9382956160033d-02,
     |   3.2742001125791d-02, 4.9285527238919d-02, 6.6746201376983d-02,
     |   8.1642023814985d-02, 8.9981405156614d-02, 8.8325073818996d-02,
     |   7.4888137727900d-02, 5.0301777017844d-02, 1.7733334174890d-02,
     |  -1.7733334174890d-02,-5.0301777017844d-02,-7.4888137727899d-02,
     |  -8.8325073818996d-02,-8.9981405156614d-02,-8.1642023814985d-02,
     |  -6.6746201376983d-02,-4.9285527238919d-02,-3.2742001125791d-02,
     |  -1.9382956160033d-02,-1.0060097931664d-02,-4.4622164314989d-03,
     |  -1.6247014628361d-03,-4.5446414594641d-04,-8.6778514193188d-05,
     |  -8.8920843284177d-06,-2.6075642080139d-07,-7.2548370074392d-10/
      data (zmn(lat, 7, 7), lat = 1,36)/
     |  -1.2452033997546d-10, 9.3088794050726d-09, 5.2672338686653d-07,
     |   7.3127170223037d-06, 5.0310505567873d-05, 2.2604063428203d-04,
     |   7.5975550471824d-04, 2.0630924944014d-03, 4.7468820535458d-03,
     |   9.5496784480380d-03, 1.7166229335176d-02, 2.8001107456921d-02,
     |   4.1915346935859d-02, 5.8058316819009d-02, 7.4868250732878d-02,
     |   9.0280463188181d-02, 1.0211515549305d-01, 1.0855086335964d-01,
     |   1.0855086335964d-01, 1.0211515549305d-01, 9.0280463188181d-02,
     |   7.4868250732878d-02, 5.8058316819009d-02, 4.1915346935859d-02,
     |   2.8001107456921d-02, 1.7166229335176d-02, 9.5496784480380d-03,
     |   4.7468820535458d-03, 2.0630924944014d-03, 7.5975550471821d-04,
     |   2.2604063428199d-04, 5.0310505567863d-05, 7.3127170222819d-06,
     |   5.2672338685775d-07, 9.3088794380301d-09,-1.2452038747099d-10/
      data (zmn(lat, 0, 8), lat = 1,36)/
     |   9.2570662903688d-03, 2.4565564090982d-02, 1.6452756042710d-02,
     |  -6.9703778030101d-03,-3.5110927820042d-02,-4.6511427369678d-02,
     |  -3.2952711115484d-02, 2.7020044179787d-03, 4.0489199876275d-02,
     |   5.9780610385271d-02, 4.6914153914687d-02, 7.6276451852013d-03,
     |  -3.8403045348853d-02,-6.5438336394556d-02,-5.8281914700767d-02,
     |  -1.9417787810698d-02, 3.0499921365654d-02, 6.4797606222906d-02,
     |   6.4797606222906d-02, 3.0499921365654d-02,-1.9417787810698d-02,
     |  -5.8281914700767d-02,-6.5438336394556d-02,-3.8403045348853d-02,
     |   7.6276451852011d-03, 4.6914153914687d-02, 5.9780610385272d-02,
     |   4.0489199876275d-02, 2.7020044179788d-03,-3.2952711115484d-02,
     |  -4.6511427369678d-02,-3.5110927820042d-02,-6.9703778030102d-03,
     |   1.6452756042710d-02, 2.4565564090982d-02, 9.2570662903688d-03/
      data (zmn(lat, 1, 8), lat = 1,36)/
     |   2.3399947563053d-03, 1.5633668645669d-02, 3.2247226800752d-02,
     |   3.6421978851704d-02, 2.0508522503927d-02,-1.1210301589496d-02,
     |  -4.2206892271430d-02,-5.4330442084568d-02,-3.7735027227629d-02,
     |   1.0587328837334d-03, 4.2644814931684d-02, 6.3928963707036d-02,
     |   5.2191637012882d-02, 1.1861830347104d-02,-3.6144512704734d-02,
     |  -6.6449411440583d-02,-6.2130498445662d-02,-2.5199753964503d-02,
     |   2.5199753964503d-02, 6.2130498445662d-02, 6.6449411440583d-02,
     |   3.6144512704734d-02,-1.1861830347104d-02,-5.2191637012882d-02,
     |  -6.3928963707036d-02,-4.2644814931684d-02,-1.0587328837335d-03,
     |   3.7735027227629d-02, 5.4330442084568d-02, 4.2206892271430d-02,
     |   1.1210301589496d-02,-2.0508522503927d-02,-3.6421978851704d-02,
     |  -3.2247226800753d-02,-1.5633668645669d-02,-2.3399947563053d-03/
      data (zmn(lat, 2, 8), lat = 1,36)/
     |   2.1095842041778d-04, 4.5378330848705d-03, 1.7452309105256d-02,
     |   3.5127616278820d-02, 4.7106008085994d-02, 4.2292814722064d-02,
     |   1.7362851386612d-02,-1.9483142840123d-02,-5.1060634797706d-02,
     |  -6.0268179364592d-02,-3.9865075674782d-02, 2.0891775895458d-03,
     |   4.5369479425080d-02, 6.7599190164273d-02, 5.6340187484012d-02,
     |   1.6202826540266d-02,-3.2906337010594d-02,-6.5973652548650d-02,
     |  -6.5973652548650d-02,-3.2906337010594d-02, 1.6202826540266d-02,
     |   5.6340187484012d-02, 6.7599190164273d-02, 4.5369479425080d-02,
     |   2.0891775895460d-03,-3.9865075674782d-02,-6.0268179364592d-02,
     |  -5.1060634797706d-02,-1.9483142840123d-02, 1.7362851386612d-02,
     |   4.2292814722064d-02, 4.7106008085994d-02, 3.5127616278820d-02,
     |   1.7452309105256d-02, 4.5378330848705d-03, 2.1095842041774d-04/
      data (zmn(lat, 3, 8), lat = 1,36)/
     |   4.1291824176480d-06, 8.3554792742189d-04, 5.5851333252649d-03,
     |   1.7310325029167d-02, 3.4907961778663d-02, 5.1511659417723d-02,
     |   5.6921129642733d-02, 4.3415970192008d-02, 1.1460636011020d-02,
     |  -2.8316559715617d-02,-5.8944322055793d-02,-6.5217398571527d-02,
     |  -4.2086305494228d-02, 1.5354968005348d-03, 4.6005080240281d-02,
     |   7.0167025077254d-02, 6.1887523359983d-02, 2.4498899833377d-02,
     |  -2.4498899833377d-02,-6.1887523359983d-02,-7.0167025077254d-02,
     |  -4.6005080240281d-02,-1.5354968005348d-03, 4.2086305494228d-02,
     |   6.5217398571527d-02, 5.8944322055793d-02, 2.8316559715617d-02,
     |  -1.1460636011019d-02,-4.3415970192008d-02,-5.6921129642733d-02,
     |  -5.1511659417723d-02,-3.4907961778663d-02,-1.7310325029167d-02,
     |  -5.5851333252650d-03,-8.3554792742192d-04,-4.1291824177088d-06/
      data (zmn(lat, 4, 8), lat = 1,36)/
     |   2.1945524776737d-07, 1.0759392268645d-04, 1.2393970188295d-03,
     |   5.6637134704753d-03, 1.5889772231633d-02, 3.2279136837915d-02,
     |   5.1008722970558d-02, 6.4252953522287d-02, 6.3247857665687d-02,
     |   4.3105141791015d-02, 6.7811361535002d-03,-3.4378263489644d-02,
     |  -6.4550982761560d-02,-7.0408647526269d-02,-4.7852253975324d-02,
     |  -4.9457439866671d-03, 4.0824449628736d-02, 7.0022011500661d-02,
     |   7.0022011500661d-02, 4.0824449628736d-02,-4.9457439866669d-03,
     |  -4.7852253975324d-02,-7.0408647526269d-02,-6.4550982761559d-02,
     |  -3.4378263489644d-02, 6.7811361535003d-03, 4.3105141791015d-02,
     |   6.3247857665687d-02, 6.4252953522287d-02, 5.1008722970558d-02,
     |   3.2279136837915d-02, 1.5889772231633d-02, 5.6637134704753d-03,
     |   1.2393970188296d-03, 1.0759392268642d-04, 2.1945524781598d-07/
      data (zmn(lat, 5, 8), lat = 1,36)/
     |   1.0407086938241d-07, 1.0179479062563d-05, 2.0173570135049d-04,
     |   1.3349287849740d-03, 5.0598426058373d-03, 1.3459944099880d-02,
     |   2.7682951737034d-02, 4.6261642923094d-02, 6.4262325217913d-02,
     |   7.4237647006920d-02, 6.9087919112702d-02, 4.5758372774222d-02,
     |   7.9275986817509d-03,-3.4003144902488d-02,-6.6156784413953d-02,
     |  -7.6586835338121d-02,-6.0516272141137d-02,-2.2923314255177d-02,
     |   2.2923314255177d-02, 6.0516272141137d-02, 7.6586835338121d-02,
     |   6.6156784413953d-02, 3.4003144902489d-02,-7.9275986817510d-03,
     |  -4.5758372774221d-02,-6.9087919112702d-02,-7.4237647006920d-02,
     |  -6.4262325217913d-02,-4.6261642923094d-02,-2.7682951737034d-02,
     |  -1.3459944099880d-02,-5.0598426058373d-03,-1.3349287849741d-03,
     |  -2.0173570135055d-04,-1.0179479062659d-05,-1.0407086931287d-07/
      data (zmn(lat, 6, 8), lat = 1,36)/
     |   2.0455539610885d-09, 7.2725307197133d-07, 2.4366099406137d-05,
     |   2.3145395052915d-04, 1.1681203455122d-03, 3.9805357147168d-03,
     |   1.0292750055483d-02, 2.1534590472128d-02, 3.7837090241042d-02,
     |   5.7003977081706d-02, 7.4255406575111d-02, 8.3234125857128d-02,
     |   7.8193487625450d-02, 5.6610618948375d-02, 2.1058652224390d-02,
     |  -2.0695851002456d-02,-5.7718804350526d-02,-7.9457645733826d-02,
     |  -7.9457645733826d-02,-5.7718804350526d-02,-2.0695851002456d-02,
     |   2.1058652224390d-02, 5.6610618948375d-02, 7.8193487625450d-02,
     |   8.3234125857128d-02, 7.4255406575111d-02, 5.7003977081706d-02,
     |   3.7837090241042d-02, 2.1534590472128d-02, 1.0292750055483d-02,
     |   3.9805357147169d-03, 1.1681203455122d-03, 2.3145395052919d-04,
     |   2.4366099406165d-05, 7.2725307199714d-07, 2.0455538969671d-09/
      data (zmn(lat, 7, 8), lat = 1,36)/
     |  -6.7523077936219d-10, 3.8215443408857d-08, 2.1200950324586d-06,
     |   2.8755781939268d-05, 1.9164527682030d-04, 8.2668486612011d-04,
     |   2.6419675630211d-03, 6.7485399758645d-03, 1.4429915269974d-02,
     |   2.6600913922530d-02, 4.3087023854091d-02, 6.2032058618163d-02,
     |   7.9800042895279d-02, 9.1606979360973d-02, 9.2824784612067d-02,
     |   8.0566591547290d-02, 5.4955647744960d-02, 1.9522584347691d-02,
     |  -1.9522584347691d-02,-5.4955647744960d-02,-8.0566591547289d-02,
     |  -9.2824784612067d-02,-9.1606979360973d-02,-7.9800042895279d-02,
     |  -6.2032058618163d-02,-4.3087023854091d-02,-2.6600913922530d-02,
     |  -1.4429915269974d-02,-6.7485399758645d-03,-2.6419675630211d-03,
     |  -8.2668486612012d-04,-1.9164527682033d-04,-2.8755781939270d-05,
     |  -2.1200950324643d-06,-3.8215443381198d-08, 6.7523072347963d-10/
      data (zmn(lat, 8, 8), lat = 1,36)/
     |  -5.5988047366900d-12, 1.2524474051291d-09, 1.1751243388291d-07,
     |   2.2666530106128d-06, 1.9845535013489d-05, 1.0758620449971d-04,
     |   4.2077976695518d-04, 1.2945841820978d-03, 3.3056453372589d-03,
     |   7.2574508306850d-03, 1.4038025734598d-02, 2.4342706869266d-02,
     |   3.8323614111289d-02, 5.5289702897361d-02, 7.3600651230224d-02,
     |   9.0853102217824d-02, 1.0435739715228d-01, 1.1178517277037d-01,
     |   1.1178517277037d-01, 1.0435739715228d-01, 9.0853102217824d-02,
     |   7.3600651230224d-02, 5.5289702897361d-02, 3.8323614111289d-02,
     |   2.4342706869266d-02, 1.4038025734598d-02, 7.2574508306850d-03,
     |   3.3056453372589d-03, 1.2945841820978d-03, 4.2077976695519d-04,
     |   1.0758620449970d-04, 1.9845535013480d-05, 2.2666530106008d-06,
     |   1.1751243387943d-07, 1.2524473923354d-09,-5.5988127518125d-12/
      data (zmn(lat, 0, 9), lat = 1,36)/
     |   9.6705243585278d-03, 2.3728949134868d-02, 1.0000376248053d-02,
     |  -1.7910694073325d-02,-4.2158822168193d-02,-3.8404366044588d-02,
     |  -6.8381090078449d-03, 3.5300468766153d-02, 5.6893199640390d-02,
     |   4.2001464917894d-02,-3.6177684388436d-03,-4.9313433510801d-02,
     |  -6.4989056931742d-02,-3.7293784484226d-02, 1.5723947475288d-02,
     |   6.0328217025571d-02, 6.5494934169396d-02, 2.8193386246377d-02,
     |  -2.8193386246377d-02,-6.5494934169396d-02,-6.0328217025571d-02,
     |  -1.5723947475288d-02, 3.7293784484226d-02, 6.4989056931741d-02,
     |   4.9313433510802d-02, 3.6177684388435d-03,-4.2001464917894d-02,
     |  -5.6893199640390d-02,-3.5300468766153d-02, 6.8381090078448d-03,
     |   3.8404366044588d-02, 4.2158822168193d-02, 1.7910694073325d-02,
     |  -1.0000376248053d-02,-2.3728949134868d-02,-9.6705243585278d-03/
      data (zmn(lat, 1, 9), lat = 1,36)/
     |   2.7217245877389d-03, 1.7766847982744d-02, 3.3444755225859d-02,
     |   3.0642260712409d-02, 4.5386347489043d-03,-3.1036464370904d-02,
     |  -5.1327489338586d-02,-3.9192106096291d-02, 1.2057283039208d-03,
     |   4.4808851717624d-02, 6.1941220947674d-02, 3.8874526577506d-02,
     |  -1.1326993215031d-02,-5.6383090935137d-02,-6.5993084269457d-02,
     |  -3.2635765644283d-02, 2.2673361311256d-02, 6.3882039446334d-02,
     |   6.3882039446334d-02, 2.2673361311256d-02,-3.2635765644283d-02,
     |  -6.5993084269457d-02,-5.6383090935137d-02,-1.1326993215031d-02,
     |   3.8874526577506d-02, 6.1941220947674d-02, 4.4808851717624d-02,
     |   1.2057283039210d-03,-3.9192106096291d-02,-5.1327489338586d-02,
     |  -3.1036464370904d-02, 4.5386347489043d-03, 3.0642260712409d-02,
     |   3.3444755225859d-02, 1.7766847982744d-02, 2.7217245877388d-03/
      data (zmn(lat, 2, 9), lat = 1,36)/
     |   2.7942129214753d-04, 5.8547277003765d-03, 2.1398789376796d-02,
     |   3.9301669235864d-02, 4.4602992999474d-02, 2.6432435901845d-02,
     |  -1.0524101045173d-02,-4.6357301594506d-02,-5.7464170916924d-02,
     |  -3.3530936549916d-02, 1.3614245271480d-02, 5.5317868571007d-02,
     |   6.4307392428649d-02, 3.2888527385271d-02,-2.0485591378734d-02,
     |  -6.2408091576570d-02,-6.5740768788475d-02,-2.7776238323706d-02,
     |   2.7776238323706d-02, 6.5740768788475d-02, 6.2408091576570d-02,
     |   2.0485591378734d-02,-3.2888527385271d-02,-6.4307392428649d-02,
     |  -5.5317868571007d-02,-1.3614245271480d-02, 3.3530936549916d-02,
     |   5.7464170916924d-02, 4.6357301594506d-02, 1.0524101045173d-02,
     |  -2.6432435901845d-02,-4.4602992999474d-02,-3.9301669235864d-02,
     |  -2.1398789376796d-02,-5.8547277003764d-03,-2.7942129214745d-04/
      data (zmn(lat, 3, 9), lat = 1,36)/
     |   7.3276757828333d-06, 1.2238183525397d-03, 7.8945985474929d-03,
     |   2.3037916711214d-02, 4.2350466246047d-02, 5.3927400646326d-02,
     |   4.5325646423917d-02, 1.3747563156510d-02,-2.8603486820770d-02,
     |  -5.9273004368328d-02,-5.8839600527915d-02,-2.4408752117775d-02,
     |   2.6203806481556d-02, 6.3655443118972d-02, 6.4727100639263d-02,
     |   2.7365446037994d-02,-2.6984249091016d-02,-6.5914633648618d-02,
     |  -6.5914633648618d-02,-2.6984249091016d-02, 2.7365446037994d-02,
     |   6.4727100639263d-02, 6.3655443118972d-02, 2.6203806481556d-02,
     |  -2.4408752117774d-02,-5.8839600527915d-02,-5.9273004368328d-02,
     |  -2.8603486820770d-02, 1.3747563156510d-02, 4.5325646423917d-02,
     |   5.3927400646326d-02, 4.2350466246047d-02, 2.3037916711214d-02,
     |   7.8945985474929d-03, 1.2238183525397d-03, 7.3276757829008d-06/
      data (zmn(lat, 4, 9), lat = 1,36)/
     |   3.6137262083560d-07, 1.8061025920613d-04, 2.0213483933475d-03,
     |   8.8283639375382d-03, 2.3193871226766d-02, 4.2931083556401d-02,
     |   5.9270566864116d-02, 6.0266255001458d-02, 3.8438200237002d-02,
     |  -2.1126279910112d-03,-4.4791326709941d-02,-6.7979389776991d-02,
     |  -5.7459139995610d-02,-1.6225548367123d-02, 3.5131728244771d-02,
     |   6.8877620867775d-02, 6.5816698636530d-02, 2.6861922129850d-02,
     |  -2.6861922129850d-02,-6.5816698636530d-02,-6.8877620867775d-02,
     |  -3.5131728244771d-02, 1.6225548367123d-02, 5.7459139995610d-02,
     |   6.7979389776991d-02, 4.4791326709941d-02, 2.1126279910112d-03,
     |  -3.8438200237002d-02,-6.0266255001458d-02,-5.9270566864116d-02,
     |  -4.2931083556401d-02,-2.3193871226766d-02,-8.8283639375382d-03,
     |  -2.0213483933477d-03,-1.8061025920609d-04,-3.6137262086568d-07/
      data (zmn(lat, 5, 9), lat = 1,36)/
     |   1.7905361702243d-07, 1.9900307721886d-05, 3.8468439804725d-04,
     |   2.4543510527903d-03, 8.8363821659357d-03, 2.1930633848484d-02,
     |   4.1113947170473d-02, 6.0587203258534d-02, 7.0303661507101d-02,
     |   6.0717382114713d-02, 2.9247307517622d-02,-1.5644218045250d-02,
     |  -5.6261374749867d-02,-7.3620869822520d-02,-5.7734124753553d-02,
     |  -1.4286169321089d-02, 3.6769761604524d-02, 7.0700738412809d-02,
     |   7.0700738412809d-02, 3.6769761604524d-02,-1.4286169321088d-02,
     |  -5.7734124753553d-02,-7.3620869822520d-02,-5.6261374749867d-02,
     |  -1.5644218045250d-02, 2.9247307517622d-02, 6.0717382114713d-02,
     |   7.0303661507101d-02, 6.0587203258535d-02, 4.1113947170473d-02,
     |   2.1930633848484d-02, 8.8363821659358d-03, 2.4543510527903d-03,
     |   3.8468439804726d-04, 1.9900307721905d-05, 1.7905361696501d-07/
      data (zmn(lat, 6, 9), lat = 1,36)/
     |   5.0050535717213d-09, 1.6997277530376d-06, 5.5839405839017d-05,
     |   5.1435580591329d-04, 2.4878705108013d-03, 8.0170660055219d-03,
     |   1.9295652008395d-02, 3.6840703151250d-02, 5.7530627988676d-02,
     |   7.4109543994562d-02, 7.7352711050794d-02, 6.0559734000150d-02,
     |   2.4252313255188d-02,-2.1842742855330d-02,-6.1447444516668d-02,
     |  -7.8484910225133d-02,-6.4840889233537d-02,-2.5028857810394d-02,
     |   2.5028857810393d-02, 6.4840889233537d-02, 7.8484910225132d-02,
     |   6.1447444516668d-02, 2.1842742855330d-02,-2.4252313255188d-02,
     |  -6.0559734000150d-02,-7.7352711050794d-02,-7.4109543994562d-02,
     |  -5.7530627988676d-02,-3.6840703151251d-02,-1.9295652008395d-02,
     |  -8.0170660055219d-03,-2.4878705108013d-03,-5.1435580591335d-04,
     |  -5.5839405838988d-05,-1.6997277531141d-06,-5.0050535754437d-09/
      data (zmn(lat, 7, 9), lat = 1,36)/
     |  -1.6351211613426d-09, 1.1279231334517d-07, 6.1705549481223d-06,
     |   8.1495429915139d-05, 5.2375582584104d-04, 2.1554977904091d-03,
     |   6.4937492496017d-03, 1.5420218954637d-02, 3.0142611788487d-02,
     |   4.9737542980289d-02, 7.0106084849610d-02, 8.4314682883667d-02,
     |   8.4769193039724d-02, 6.6639800566621d-02, 3.0991433448242d-02,
     |  -1.4164716789322d-02,-5.5895434352302d-02,-8.0938585174204d-02,
     |  -8.0938585174204d-02,-5.5895434352302d-02,-1.4164716789322d-02,
     |   3.0991433448242d-02, 6.6639800566621d-02, 8.4769193039724d-02,
     |   8.4314682883667d-02, 7.0106084849610d-02, 4.9737542980289d-02,
     |   3.0142611788487d-02, 1.5420218954637d-02, 6.4937492496017d-03,
     |   2.1554977904091d-03, 5.2375582584097d-04, 8.1495429915146d-05,
     |   6.1705549481273d-06, 1.1279231327796d-07,-1.6351210672824d-09/
      data (zmn(lat, 8, 9), lat = 1,36)/
     |  -2.5923827678927d-11, 5.4172045396836d-09, 5.0007539440144d-07,
     |   9.4228403678660d-06, 7.9919891263701d-05, 4.1597030434261d-04,
     |   1.5468950000656d-03, 4.4768624748092d-03, 1.0623409929615d-02,
     |   2.1371954907908d-02, 3.7250316079184d-02, 5.7011464092441d-02,
     |   7.7134533731797d-02, 9.2227559678377d-02, 9.6471773278493d-02,
     |   8.5714305837989d-02, 5.9374191309485d-02, 2.1253994565302d-02,
     |  -2.1253994565302d-02,-5.9374191309485d-02,-8.5714305837989d-02,
     |  -9.6471773278493d-02,-9.2227559678377d-02,-7.7134533731797d-02,
     |  -5.7011464092441d-02,-3.7250316079184d-02,-2.1371954907908d-02,
     |  -1.0623409929615d-02,-4.4768624748092d-03,-1.5468950000656d-03,
     |  -4.1597030434261d-04,-7.9919891263697d-05,-9.4228403678468d-06,
     |  -5.0007539441645d-07,-5.4172045043920d-09, 2.5923764452672d-11/
      data (zmn(lat, 9, 9), lat = 1,36)/
     |   8.0789939938731d-12, 1.5969034316960d-10, 2.6139446449969d-08,
     |   7.0026506686141d-07, 7.8026737578908d-06, 5.1039060466593d-05,
     |   2.3228006228957d-04, 8.0968849524114d-04, 2.2944582062784d-03,
     |   5.4973771627463d-03, 1.1442297545074d-02, 2.1093012453803d-02,
     |   3.4924961050203d-02, 5.2480764157960d-02, 7.2117673257458d-02,
     |   9.1130094810831d-02, 1.0629977680386d-01, 1.1473903721289d-01,
     |   1.1473903721289d-01, 1.0629977680386d-01, 9.1130094810831d-02,
     |   7.2117673257458d-02, 5.2480764157960d-02, 3.4924961050202d-02,
     |   2.1093012453803d-02, 1.1442297545074d-02, 5.4973771627464d-03,
     |   2.2944582062784d-03, 8.0968849524117d-04, 2.3228006228959d-04,
     |   5.1039060466628d-05, 7.8026737579271d-06, 7.0026506687887d-07,
     |   2.6139446447805d-08, 1.5969038975146d-10, 8.0789393261398d-12/
      data (zmn(lat, 0,10), lat = 1,36)/
     |   1.0038683352535d-02, 2.2420249509428d-02, 3.0446368313523d-03,
     |  -2.7148306407097d-02,-4.2680657669281d-02,-2.1519856240528d-02,
     |   2.1442423408109d-02, 5.3238632434838d-02, 4.3286095923653d-02,
     |  -3.1176173634204d-03,-5.1327156595790d-02,-6.0555783630370d-02,
     |  -2.1527806661286d-02, 3.6949854841024d-02, 6.7743790211439d-02,
     |   4.5505666122553d-02,-1.3432667263427d-02,-6.2360181438424d-02,
     |  -6.2360181438424d-02,-1.3432667263427d-02, 4.5505666122553d-02,
     |   6.7743790211439d-02, 3.6949854841024d-02,-2.1527806661286d-02,
     |  -6.0555783630370d-02,-5.1327156595790d-02,-3.1176173634205d-03,
     |   4.3286095923653d-02, 5.3238632434838d-02, 2.1442423408109d-02,
     |  -2.1519856240527d-02,-4.2680657669281d-02,-2.7148306407097d-02,
     |   3.0446368313522d-03, 2.2420249509428d-02, 1.0038683352535d-02/
      data (zmn(lat, 1,10), lat = 1,36)/
     |   3.2062907939804d-03, 1.9657795428198d-02, 3.3417755813198d-02,
     |   2.2194190515795d-02,-1.1986855734462d-02,-4.4152589351006d-02,
     |  -4.4651032183734d-02,-8.2248591607387d-03, 3.9571384621984d-02,
     |   5.9630587621752d-02, 3.3178555778334d-02,-2.2024856692364d-02,
     |  -6.2559724405505d-02,-5.5253526088738d-02,-3.6414056362511d-03,
     |   5.2124034002809d-02, 6.8101782122137d-02, 3.0685974893973d-02,
     |  -3.0685974893973d-02,-6.8101782122137d-02,-5.2124034002809d-02,
     |   3.6414056362510d-03, 5.5253526088738d-02, 6.2559724405505d-02,
     |   2.2024856692364d-02,-3.3178555778334d-02,-5.9630587621752d-02,
     |  -3.9571384621984d-02, 8.2248591607385d-03, 4.4651032183734d-02,
     |   4.4152589351006d-02, 1.1986855734462d-02,-2.2194190515795d-02,
     |  -3.3417755813198d-02,-1.9657795428198d-02,-3.2062907939803d-03/
      data (zmn(lat, 2,10), lat = 1,36)/
     |   3.5912403234985d-04, 7.3169201175735d-03, 2.5219443650504d-02,
     |   4.1449665571223d-02, 3.7120815685451d-02, 5.7007887263870d-03,
     |  -3.5378143208733d-02,-5.5584908089632d-02,-3.5547730885970d-02,
     |   1.3807814686492d-02, 5.6577746089505d-02, 5.8514887985947d-02,
     |   1.5376004534771d-02,-4.1629098991527d-02,-6.8639270980828d-02,
     |  -4.3665945112165d-02, 1.5260999335415d-02, 6.3199725854291d-02,
     |   6.3199725854291d-02, 1.5260999335415d-02,-4.3665945112165d-02,
     |  -6.8639270980828d-02,-4.1629098991527d-02, 1.5376004534771d-02,
     |   5.8514887985947d-02, 5.6577746089505d-02, 1.3807814686492d-02,
     |  -3.5547730885969d-02,-5.5584908089632d-02,-3.5378143208733d-02,
     |   5.7007887263869d-03, 3.7120815685451d-02, 4.1449665571223d-02,
     |   2.5219443650504d-02, 7.3169201175737d-03, 3.5912403234982d-04/
      data (zmn(lat, 3,10), lat = 1,36)/
     |   8.0424967562445d-06, 1.7178501755057d-03, 1.0614229683749d-02,
     |   2.8897299042271d-02, 4.7415288648050d-02, 4.9239860862721d-02,
     |   2.3769127711775d-02,-2.0080821863283d-02,-5.5492085859410d-02,
     |  -5.5852965210244d-02,-1.6733172040155d-02, 3.7016901507013d-02,
     |   6.6940152813485d-02, 4.9493489630223d-02,-4.7286855818060d-03,
     |  -5.6963154970745d-02,-6.8561836767013d-02,-3.0237398068031d-02,
     |   3.0237398068031d-02, 6.8561836767013d-02, 5.6963154970745d-02,
     |   4.7286855818061d-03,-4.9493489630223d-02,-6.6940152813485d-02,
     |  -3.7016901507014d-02, 1.6733172040155d-02, 5.5852965210244d-02,
     |   5.5492085859410d-02, 2.0080821863283d-02,-2.3769127711775d-02,
     |  -4.9239860862721d-02,-4.7415288648050d-02,-2.8897299042271d-02,
     |  -1.0614229683749d-02,-1.7178501755057d-03,-8.0424967563657d-06/
      data (zmn(lat, 4,10), lat = 1,36)/
     |   5.7228403383226d-07, 2.8506961050431d-04, 3.0892514876236d-03,
     |   1.2813072818179d-02, 3.1166681697250d-02, 5.1435103095043d-02,
     |   5.9076111436297d-02, 4.1385163741212d-02,-7.2190745287144d-05,
     |  -4.5254232407158d-02,-6.6057419516028d-02,-4.5993679106208d-02,
     |   5.2865506856914d-03, 5.5305253388309d-02, 6.9809172676462d-02,
     |   3.7326312485525d-02,-2.1190531362077d-02,-6.5906323527733d-02,
     |  -6.5906323527733d-02,-2.1190531362077d-02, 3.7326312485525d-02,
     |   6.9809172676462d-02, 5.5305253388309d-02, 5.2865506856912d-03,
     |  -4.5993679106208d-02,-6.6057419516028d-02,-4.5254232407158d-02,
     |  -7.2190745287194d-05, 4.1385163741212d-02, 5.9076111436297d-02,
     |   5.1435103095043d-02, 3.1166681697250d-02, 1.2813072818179d-02,
     |   3.0892514876236d-03, 2.8506961050418d-04, 5.7228403382822d-07/
      data (zmn(lat, 5,10), lat = 1,36)/
     |   3.9448685001203d-07, 3.5649494994399d-05, 6.7258378599930d-04,
     |   4.1168466164599d-03, 1.3970446720882d-02, 3.1941013178645d-02,
     |   5.3392265006930d-02, 6.6437878669897d-02, 5.7837200732279d-02,
     |   2.3315972363881d-02,-2.5284800017356d-02,-6.3333756463722d-02,
     |  -6.7533514393396d-02,-3.2326231719328d-02, 2.3493201537779d-02,
     |   6.6421356855610d-02, 6.9189345448432d-02, 2.9128394311961d-02,
     |  -2.9128394311961d-02,-6.9189345448432d-02,-6.6421356855610d-02,
     |  -2.3493201537779d-02, 3.2326231719328d-02, 6.7533514393396d-02,
     |   6.3333756463722d-02, 2.5284800017356d-02,-2.3315972363881d-02,
     |  -5.7837200732279d-02,-6.6437878669897d-02,-5.3392265006930d-02,
     |  -3.1941013178646d-02,-1.3970446720882d-02,-4.1168466164600d-03,
     |  -6.7258378599935d-04,-3.5649494994442d-05,-3.9448684995338d-07/
      data (zmn(lat, 6,10), lat = 1,36)/
     |   1.0578696422926d-08, 3.5299190611127d-06, 1.1341055518336d-04,
     |   1.0091327976567d-03, 4.6503924018799d-03, 1.4046088707227d-02,
     |   3.1041058448737d-02, 5.2908273276000d-02, 7.0644443102735d-02,
     |   7.1886707837623d-02, 4.8372385599463d-02, 3.6734330308233d-03,
     |  -4.4912741861330d-02,-7.3630342450577d-02,-6.5762239281243d-02,
     |  -2.3127099703191d-02, 3.2660013971640d-02, 7.1326116133731d-02,
     |   7.1326116133731d-02, 3.2660013971640d-02,-2.3127099703191d-02,
     |  -6.5762239281243d-02,-7.3630342450577d-02,-4.4912741861330d-02,
     |   3.6734330308230d-03, 4.8372385599463d-02, 7.1886707837623d-02,
     |   7.0644443102735d-02, 5.2908273276000d-02, 3.1041058448737d-02,
     |   1.4046088707227d-02, 4.6503924018798d-03, 1.0091327976567d-03,
     |   1.1341055518335d-04, 3.5299190611168d-06, 1.0578696429094d-08/
      data (zmn(lat, 7,10), lat = 1,36)/
     |  -5.4476008523378d-09, 2.8061592928492d-07, 1.4982295729225d-05,
     |   1.9208245603709d-04, 1.1847364058633d-03, 4.6200297617946d-03,
     |   1.2992883342439d-02, 2.8276964411284d-02, 4.9456349033481d-02,
     |   7.0568093188446d-02, 8.1439090677806d-02, 7.2100576140393d-02,
     |   3.9227417189970d-02,-9.3194564933598d-03,-5.5655384688563d-02,
     |  -7.9505252429781d-02,-6.8789224139946d-02,-2.7062472981566d-02,
     |   2.7062472981566d-02, 6.8789224139946d-02, 7.9505252429781d-02,
     |   5.5655384688563d-02, 9.3194564933599d-03,-3.9227417189970d-02,
     |  -7.2100576140393d-02,-8.1439090677806d-02,-7.0568093188446d-02,
     |  -4.9456349033481d-02,-2.8276964411284d-02,-1.2992883342439d-02,
     |  -4.6200297617945d-03,-1.1847364058632d-03,-1.9208245603709d-04,
     |  -1.4982295729227d-05,-2.8061592933182d-07, 5.4476009112572d-09/
      data (zmn(lat, 8,10), lat = 1,36)/
     |  -8.1946361924070d-11, 1.6923900224569d-08, 1.5356182357822d-06,
     |   2.8187089001283d-05, 2.3065605087402d-04, 1.1461918953771d-03,
     |   4.0219781197981d-03, 1.0835549508342d-02, 2.3550614186221d-02,
     |   4.2525776385080d-02, 6.4772254792554d-02, 8.3387694092214d-02,
     |   8.9303906797709d-02, 7.5271172018807d-02, 4.0364364069980d-02,
     |  -7.6276470438133d-03,-5.3903633007455d-02,-8.2290913835544d-02,
     |  -8.2290913835544d-02,-5.3903633007455d-02,-7.6276470438135d-03,
     |   4.0364364069980d-02, 7.5271172018807d-02, 8.9303906797709d-02,
     |   8.3387694092214d-02, 6.4772254792554d-02, 4.2525776385080d-02,
     |   2.3550614186221d-02, 1.0835549508342d-02, 4.0219781197981d-03,
     |   1.1461918953772d-03, 2.3065605087409d-04, 2.8187089001327d-05,
     |   1.5356182358005d-06, 1.6923900252371d-08,-8.1946398823615d-11/
      data (zmn(lat, 9,10), lat = 1,36)/
     |   5.2270876229560d-11, 7.1024906475234d-10, 1.1696186927422d-07,
     |   3.0604792689977d-06, 3.3034568848445d-05, 2.0746326602773d-04,
     |   8.9774042215901d-04, 2.9437048826070d-03, 7.7521235186210d-03,
     |   1.7019567787819d-02, 3.1920524025250d-02, 5.1935555396909d-02,
     |   7.3901146776342d-02, 9.2034245845089d-02, 9.9378664944265d-02,
     |   9.0387467839291d-02, 6.3582802896589d-02, 2.2935087958954d-02,
     |  -2.2935087958954d-02,-6.3582802896589d-02,-9.0387467839291d-02,
     |  -9.9378664944265d-02,-9.2034245845089d-02,-7.3901146776342d-02,
     |  -5.1935555396909d-02,-3.1920524025250d-02,-1.7019567787819d-02,
     |  -7.7521235186209d-03,-2.9437048826070d-03,-8.9774042215901d-04,
     |  -2.0746326602774d-04,-3.3034568848454d-05,-3.0604792689860d-06,
     |  -1.1696186924623d-07,-7.1024902645896d-10,-5.2270912394378d-11/
      data (zmn(lat,10,10), lat = 1,36)/
     |   3.6110650550836d-13, 2.1358502569696d-11, 5.7973268793166d-09,
     |   2.1577390213144d-07, 3.0596923374684d-06, 2.4149209580589d-05,
     |   1.2788603050103d-04, 5.0507950463182d-04, 1.5883936674600d-03,
     |   4.1531830013545d-03, 9.3019615733439d-03, 1.8228983441115d-02,
     |   3.1743843102972d-02, 4.9683266965642d-02, 7.0478371034805d-02,
     |   9.1167067365274d-02, 1.0799299067470d-01, 1.1746062353210d-01,
     |   1.1746062353210d-01, 1.0799299067470d-01, 9.1167067365274d-02,
     |   7.0478371034805d-02, 4.9683266965642d-02, 3.1743843102972d-02,
     |   1.8228983441116d-02, 9.3019615733439d-03, 4.1531830013545d-03,
     |   1.5883936674600d-03, 5.0507950463185d-04, 1.2788603050103d-04,
     |   2.4149209580578d-05, 3.0596923374674d-06, 2.1577390208844d-07,
     |   5.7973268284193d-09, 2.1358478071491d-11, 3.6108655978845d-13/
      data (zmn(lat, 0,11), lat = 1,36)/
     |   1.0351057130221d-02, 2.0718240383434d-02,-4.1324410535872d-03,
     |  -3.3720070165360d-02,-3.6735499529062d-02, 4.2200411768694d-04,
     |   4.2800433339291d-02, 4.9271804423110d-02, 6.6417981455771d-03,
     |  -4.5984760774315d-02,-5.9060581063916d-02,-1.5414162418864d-02,
     |   4.4861408796797d-02, 6.5846017510946d-02, 2.4669797391527d-02,
     |  -4.0353447607150d-02,-6.9326780239783d-02,-3.3317109444268d-02,
     |   3.3317109444267d-02, 6.9326780239783d-02, 4.0353447607151d-02,
     |  -2.4669797391526d-02,-6.5846017510946d-02,-4.4861408796797d-02,
     |   1.5414162418864d-02, 5.9060581063916d-02, 4.5984760774315d-02,
     |  -6.6417981455770d-03,-4.9271804423110d-02,-4.2800433339291d-02,
     |  -4.2200411768707d-04, 3.6735499529062d-02, 3.3720070165360d-02,
     |   4.1324410535873d-03,-2.0718240383433d-02,-1.0351057130221d-02/
      data (zmn(lat, 1,11), lat = 1,36)/
     |   3.6137933542718d-03, 2.1437740233301d-02, 3.1941462312819d-02,
     |   1.1932476739429d-02,-2.6839339141803d-02,-4.7473663609557d-02,
     |  -2.4336175896710d-02, 2.6148801371798d-02, 5.7258854947186d-02,
     |   3.6106428247425d-02,-2.1435277552157d-02,-6.2540806592396d-02,
     |  -4.6677318492256d-02, 1.3960342681633d-02, 6.3724922661967d-02,
     |   5.5268191953786d-02,-4.8369535840125d-03,-6.1150589348139d-02,
     |  -6.1150589348139d-02,-4.8369535840126d-03, 5.5268191953786d-02,
     |   6.3724922661967d-02, 1.3960342681633d-02,-4.6677318492256d-02,
     |  -6.2540806592396d-02,-2.1435277552157d-02, 3.6106428247425d-02,
     |   5.7258854947186d-02, 2.6148801371799d-02,-2.4336175896710d-02,
     |  -4.7473663609557d-02,-2.6839339141803d-02, 1.1932476739429d-02,
     |   3.1941462312819d-02, 2.1437740233301d-02, 3.6137933542719d-03/
      data (zmn(lat, 2,11), lat = 1,36)/
     |   4.5139627365638d-04, 8.9016874363608d-03, 2.8704210066503d-02,
     |   4.1144478564201d-02, 2.5236498892579d-02,-1.6078517730254d-02,
     |  -5.0124416780411d-02,-4.3411135909161d-02, 4.0334447873232d-03,
     |   5.2355883013245d-02, 5.6428048996491d-02, 8.7314751581286d-03,
     |  -4.9646298558441d-02,-6.5164550855561d-02,-2.1500742654189d-02,
     |   4.2974426673862d-02, 6.9586315521977d-02, 3.3262879410378d-02,
     |  -3.3262879410378d-02,-6.9586315521977d-02,-4.2974426673863d-02,
     |   2.1500742654189d-02, 6.5164550855561d-02, 4.9646298558440d-02,
     |  -8.7314751581284d-03,-5.6428048996491d-02,-5.2355883013245d-02,
     |  -4.0334447873232d-03, 4.3411135909161d-02, 5.0124416780411d-02,
     |   1.6078517730254d-02,-2.5236498892579d-02,-4.1144478564201d-02,
     |  -2.8704210066504d-02,-8.9016874363610d-03,-4.5139627365633d-04/
      data (zmn(lat, 3,11), lat = 1,36)/
     |   1.3462300272165d-05, 2.3191389351552d-03, 1.3694162608867d-02,
     |   3.4380779260743d-02, 4.8973015957235d-02, 3.7214957788047d-02,
     |  -3.3178879030993d-03,-4.6720844812046d-02,-5.6592074651771d-02,
     |  -1.9579140832266d-02, 3.7202303977522d-02, 6.5507971828154d-02,
     |   3.8202892583935d-02,-2.3798772567223d-02,-6.7144268116299d-02,
     |  -5.2743608625732d-02, 8.1777133807361d-03, 6.2631170636797d-02,
     |   6.2631170636797d-02, 8.1777133807362d-03,-5.2743608625732d-02,
     |  -6.7144268116299d-02,-2.3798772567223d-02, 3.8202892583936d-02,
     |   6.5507971828154d-02, 3.7202303977522d-02,-1.9579140832266d-02,
     |  -5.6592074651771d-02,-4.6720844812046d-02,-3.3178879030996d-03,
     |   3.7214957788047d-02, 4.8973015957235d-02, 3.4380779260743d-02,
     |   1.3694162608867d-02, 2.3191389351552d-03, 1.3462300272129d-05/
      data (zmn(lat, 4,11), lat = 1,36)/
     |   8.3877870968650d-07, 4.2853518450820d-04, 4.4793162453870d-03,
     |   1.7521445122577d-02, 3.8931812290054d-02, 5.5604043039345d-02,
     |   4.8533589869968d-02, 1.1112459315704d-02,-3.7941059908072d-02,
     |  -6.3492916801523d-02,-4.2169882237661d-02, 1.3895873656700d-02,
     |   6.1779449934450d-02, 6.1360564779241d-02, 1.0449610486310d-02,
     |  -5.0453348193788d-02,-7.0702111118829d-02,-3.2599399836017d-02,
     |   3.2599399836017d-02, 7.0702111118829d-02, 5.0453348193789d-02,
     |  -1.0449610486310d-02,-6.1360564779241d-02,-6.1779449934450d-02,
     |  -1.3895873656700d-02, 4.2169882237661d-02, 6.3492916801523d-02,
     |   3.7941059908071d-02,-1.1112459315703d-02,-4.8533589869968d-02,
     |  -5.5604043039345d-02,-3.8931812290054d-02,-1.7521445122577d-02,
     |  -4.4793162453870d-03,-4.2853518450812d-04,-8.3877870970485d-07/
      data (zmn(lat, 5,11), lat = 1,36)/
     |   5.8749064890422d-07, 6.0048061139330d-05, 1.0986561397737d-03,
     |   6.4201827139621d-03, 2.0357654367356d-02, 4.2222935307289d-02,
     |   6.1022879063901d-02, 5.9308061290508d-02, 2.7278821171746d-02,
     |  -2.3714017366130d-02,-6.2968458956535d-02,-6.1115220069251d-02,
     |  -1.5232814175741d-02, 4.3847045883615d-02, 7.1991516941515d-02,
     |   4.6139576504456d-02,-1.5501006951290d-02,-6.5905349888560d-02,
     |  -6.5905349888560d-02,-1.5501006951290d-02, 4.6139576504456d-02,
     |   7.1991516941515d-02, 4.3847045883615d-02,-1.5232814175741d-02,
     |  -6.1115220069251d-02,-6.2968458956535d-02,-2.3714017366130d-02,
     |   2.7278821171746d-02, 5.9308061290508d-02, 6.1022879063901d-02,
     |   4.2222935307289d-02, 2.0357654367356d-02, 6.4201827139621d-03,
     |   1.0986561397737d-03, 6.0048061139304d-05, 5.8749064896266d-07/
      data (zmn(lat, 6,11), lat = 1,36)/
     |   2.1248412629791d-08, 6.7172958924077d-06, 2.1063044769102d-04,
     |   1.8031413861004d-03, 7.8664626210870d-03, 2.2045537404397d-02,
     |   4.3984919294338d-02, 6.4886693124454d-02, 6.9232941018976d-02,
     |   4.5017489812110d-02,-3.6533268805983d-03,-5.3111564374715d-02,
     |  -7.2589243578997d-02,-4.6314432963626d-02, 1.1524758966293d-02,
     |   6.2997407943676d-02, 7.2065693755513d-02, 3.1311455574625d-02,
     |  -3.1311455574625d-02,-7.2065693755513d-02,-6.2997407943676d-02,
     |  -1.1524758966293d-02, 4.6314432963626d-02, 7.2589243578997d-02,
     |   5.3111564374715d-02, 3.6533268805982d-03,-4.5017489812110d-02,
     |  -6.9232941018976d-02,-6.4886693124454d-02,-4.3984919294338d-02,
     |  -2.2045537404397d-02,-7.8664626210870d-03,-1.8031413861004d-03,
     |  -2.1063044769108d-04,-6.7172958924409d-06,-2.1248412673447d-08/
      data (zmn(lat, 7,11), lat = 1,36)/
     |  -9.8389822149930d-09, 6.1342334251795d-07, 3.2173804448655d-05,
     |   3.9900978123206d-04, 2.3499536886522d-03, 8.6180769198484d-03,
     |   2.2368798217605d-02, 4.3825137539660d-02, 6.6529196541845d-02,
     |   7.7424256176659d-02, 6.3489123050187d-02, 2.2262844651674d-02,
     |  -3.1581344354121d-02,-7.0944882557020d-02,-7.2044461175312d-02,
     |  -3.1453342981418d-02, 2.8503088405707d-02, 7.1890847046238d-02,
     |   7.1890847046238d-02, 2.8503088405707d-02,-3.1453342981417d-02,
     |  -7.2044461175312d-02,-7.0944882557020d-02,-3.1581344354121d-02,
     |   2.2262844651673d-02, 6.3489123050188d-02, 7.7424256176659d-02,
     |   6.6529196541845d-02, 4.3825137539660d-02, 2.2368798217605d-02,
     |   8.6180769198484d-03, 2.3499536886523d-03, 3.9900978123205d-04,
     |   3.2173804448650d-05, 6.1342334250733d-07,-9.8389822675226d-09/
      data (zmn(lat, 8,11), lat = 1,36)/
     |  -2.3121443160219d-10, 4.4153195392720d-08, 3.9268285895058d-06,
     |   7.0014827852534d-05, 5.5044018055507d-04, 2.5958110450876d-03,
     |   8.5216942896073d-03, 2.1109341904655d-02, 4.1255046471426d-02,
     |   6.4944615103732d-02, 8.2210615741226d-02, 8.0573365389387d-02,
     |   5.2591181735491d-02, 3.2082042500523d-03,-4.9020492849806d-02,
     |  -7.9752774944049d-02,-7.2396724722194d-02,-2.9032926524660d-02,
     |   2.9032926524660d-02, 7.2396724722194d-02, 7.9752774944049d-02,
     |   4.9020492849806d-02,-3.2082042500522d-03,-5.2591181735491d-02,
     |  -8.0573365389386d-02,-8.2210615741226d-02,-6.4944615103732d-02,
     |  -4.1255046471427d-02,-2.1109341904655d-02,-8.5216942896074d-03,
     |  -2.5958110450877d-03,-5.5044018055506d-04,-7.0014827852522d-05,
     |  -3.9268285893749d-06,-4.4153195410128d-08, 2.3121449814441d-10/
      data (zmn(lat, 9,11), lat = 1,36)/
     |   1.3469709754228d-10, 2.3661768834093d-09, 3.7693698521970d-07,
     |   9.6117116031468d-06, 1.0013741549228d-04, 6.0075822475764d-04,
     |   2.4548812073580d-03, 7.5013217134824d-03, 1.8120867717666d-02,
     |   3.5786803709279d-02, 5.8847844539865d-02, 8.0972635603181d-02,
     |   9.2093806646147d-02, 8.2590757233832d-02, 4.9157378816281d-02,
     |  -1.1216605927842d-03,-5.1766749565346d-02,-8.3528832401658d-02,
     |  -8.3528832401658d-02,-5.1766749565346d-02,-1.1216605927844d-03,
     |   4.9157378816281d-02, 8.2590757233832d-02, 9.2093806646147d-02,
     |   8.0972635603181d-02, 5.8847844539865d-02, 3.5786803709279d-02,
     |   1.8120867717666d-02, 7.5013217134823d-03, 2.4548812073579d-03,
     |   6.0075822475763d-04, 1.0013741549221d-04, 9.6117116031618d-06,
     |   3.7693698523826d-07, 2.3661768497333d-09, 1.3469720906035d-10/
      data (zmn(lat,10,11), lat = 1,36)/
     |   1.8974370398927d-12, 1.0105479703981d-10, 2.7144790944747d-08,
     |   9.8691972153215d-07, 1.3556796278236d-05, 1.0272963736437d-04,
     |   5.1726872255337d-04, 1.9217209200497d-03, 5.6163342893445d-03,
     |   1.3456382755358d-02, 2.7157237288438d-02, 4.6972415346387d-02,
     |   7.0295742376089d-02, 9.1182967943788d-02, 1.0163927998158d-01,
     |   9.4632138276191d-02, 6.7601628039772d-02, 2.4571732656425d-02,
     |  -2.4571732656425d-02,-6.7601628039772d-02,-9.4632138276191d-02,
     |  -1.0163927998158d-01,-9.1182967943788d-02,-7.0295742376089d-02,
     |  -4.6972415346388d-02,-2.7157237288438d-02,-1.3456382755358d-02,
     |  -5.6163342893445d-03,-1.9217209200497d-03,-5.1726872255329d-04,
     |  -1.0272963736431d-04,-1.3556796278178d-05,-9.8691972145809d-07,
     |  -2.7144790900868d-08,-1.0105469332809d-10,-1.8974091581242d-12/
      data (zmn(lat,11,11), lat = 1,36)/
     |  -8.0094840431512d-13, 3.6612644432276d-12, 1.2821733080346d-09,
     |   6.6343503537658d-08, 1.1972083107357d-06, 1.1401477265456d-05,
     |   7.0257421156333d-05, 3.1438328831817d-04, 1.0972208971130d-03,
     |   3.1308663564602d-03, 7.5455998991426d-03, 1.5719698780287d-02,
     |   2.8789956288099d-02, 4.6932973354506d-02, 6.8727087021579d-02,
     |   9.1006429433439d-02, 1.0947544321742d-01, 1.1998620864062d-01,
     |   1.1998620864062d-01, 1.0947544321742d-01, 9.1006429433439d-02,
     |   6.8727087021579d-02, 4.6932973354506d-02, 2.8789956288099d-02,
     |   1.5719698780287d-02, 7.5455998991426d-03, 3.1308663564602d-03,
     |   1.0972208971130d-03, 3.1438328831820d-04, 7.0257421156347d-05,
     |   1.1401477265469d-05, 1.1972083107575d-06, 6.6343503558768d-08,
     |   1.2821733581810d-09, 3.6613505051188d-12,-8.0098442764563d-13/
      data (zmn(lat, 0,12), lat = 1,36)/
     |   1.0624106103971d-02, 1.8622352737251d-02,-1.1107104244306d-02,
     |  -3.7110153601083d-02,-2.5131690413075d-02, 2.2271408424495d-02,
     |   5.0686373693298d-02, 2.4864572873064d-02,-3.3508063091836d-02,
     |  -5.8961616417073d-02,-2.0509518012169d-02, 4.4016133230811d-02,
     |   6.2924773826579d-02, 1.3396630363520d-02,-5.2931172689232d-02,
     |  -6.2966188899572d-02,-4.6473163718901d-03, 5.9466471794739d-02,
     |   5.9466471794739d-02,-4.6473163718900d-03,-6.2966188899571d-02,
     |  -5.2931172689232d-02, 1.3396630363520d-02, 6.2924773826579d-02,
     |   4.4016133230811d-02,-2.0509518012169d-02,-5.8961616417073d-02,
     |  -3.3508063091836d-02, 2.4864572873064d-02, 5.0686373693298d-02,
     |   2.2271408424495d-02,-2.5131690413075d-02,-3.7110153601083d-02,
     |  -1.1107104244306d-02, 1.8622352737251d-02, 1.0624106103971d-02/
      data (zmn(lat, 1,12), lat = 1,36)/
     |   4.1551715613629d-03, 2.2851786803223d-02, 2.9251167130468d-02,
     |   5.1667515652911d-04,-3.7621403829606d-02,-4.0429586332324d-02,
     |   3.5916129351956d-03, 4.9699646945388d-02, 4.5221061747737d-02,
     |  -1.0806969275485d-02,-5.9208026368491d-02,-4.5488701185345d-02,
     |   1.9429442561612d-02, 6.5818444527467d-02, 4.2185106984330d-02,
     |  -2.8231124461003d-02,-6.9213519851167d-02,-3.6139559307007d-02,
     |   3.6139559307007d-02, 6.9213519851167d-02, 2.8231124461004d-02,
     |  -4.2185106984330d-02,-6.5818444527467d-02,-1.9429442561612d-02,
     |   4.5488701185345d-02, 5.9208026368490d-02, 1.0806969275485d-02,
     |  -4.5221061747737d-02,-4.9699646945388d-02,-3.5916129351958d-03,
     |   4.0429586332324d-02, 3.7621403829606d-02,-5.1667515652907d-04,
     |  -2.9251167130468d-02,-2.2851786803223d-02,-4.1551715613630d-03/
      data (zmn(lat, 2,12), lat = 1,36)/
     |   5.5572620072264d-04, 1.0587669911693d-02, 3.1638262560930d-02,
     |   3.8180712546084d-02, 1.0225365903159d-02,-3.4589354711892d-02,
     |  -5.0386101204965d-02,-1.4354224587509d-02, 4.1483594908416d-02,
     |   5.7910877993098d-02, 1.3183250539611d-02,-4.8857755482309d-02,
     |  -6.1794929843684d-02,-9.0155733170921d-03, 5.5361114975967d-02,
     |   6.2404643983605d-02, 3.1853377170205d-03,-6.0097876305243d-02,
     |  -6.0097876305243d-02, 3.1853377170203d-03, 6.2404643983605d-02,
     |   5.5361114975967d-02,-9.0155733170918d-03,-6.1794929843684d-02,
     |  -4.8857755482309d-02, 1.3183250539611d-02, 5.7910877993098d-02,
     |   4.1483594908416d-02,-1.4354224587509d-02,-5.0386101204965d-02,
     |  -3.4589354711892d-02, 1.0225365903159d-02, 3.8180712546084d-02,
     |   3.1638262560930d-02, 1.0587669911693d-02, 5.5572620072275d-04/
      data (zmn(lat, 3,12), lat = 1,36)/
     |   1.3044332601350d-05, 3.0447925234664d-03, 1.7036827774626d-02,
     |   3.8959300548758d-02, 4.6248440586051d-02, 1.9197847356330d-02,
     |  -2.9403748145646d-02,-5.6533794606414d-02,-3.0968231473182d-02,
     |   2.8215014309494d-02, 6.3362333712820d-02, 3.5859341979405d-02,
     |  -3.0126720677160d-02,-6.7976124599809d-02,-3.6976766230364d-02,
     |   3.3057248434877d-02, 7.0333490378386d-02, 3.5695044312025d-02,
     |  -3.5695044312025d-02,-7.0333490378386d-02,-3.3057248434877d-02,
     |   3.6976766230364d-02, 6.7976124599809d-02, 3.0126720677159d-02,
     |  -3.5859341979405d-02,-6.3362333712820d-02,-2.8215014309494d-02,
     |   3.0968231473182d-02, 5.6533794606414d-02, 2.9403748145646d-02,
     |  -1.9197847356330d-02,-4.6248440586051d-02,-3.8959300548758d-02,
     |  -1.7036827774626d-02,-3.0447925234663d-03,-1.3044332601194d-05/
      data (zmn(lat, 4,12), lat = 1,36)/
     |   1.2105432591888d-06, 6.1879141920729d-04, 6.2159368261870d-03,
     |   2.2755508102466d-02, 4.5434752824955d-02, 5.3706829646310d-02,
     |   2.8376496200674d-02,-2.2211760575109d-02,-5.9216998897516d-02,
     |  -4.6194657621568d-02, 1.0868753501646d-02, 6.1276043139583d-02,
     |   5.5237220646445d-02,-4.8844132279501d-03,-6.2326297923283d-02,
     |  -6.0031221092245d-02, 1.3811766653947d-03, 6.2115579043977d-02,
     |   6.2115579043977d-02, 1.3811766653949d-03,-6.0031221092245d-02,
     |  -6.2326297923283d-02,-4.8844132279503d-03, 5.5237220646445d-02,
     |   6.1276043139583d-02, 1.0868753501646d-02,-4.6194657621568d-02,
     |  -5.9216998897516d-02,-2.2211760575109d-02, 2.8376496200673d-02,
     |   5.3706829646310d-02, 4.5434752824955d-02, 2.2755508102466d-02,
     |   6.2159368261871d-03, 6.1879141920752d-04, 1.2105432591291d-06/
      data (zmn(lat, 5,12), lat = 1,36)/
     |   1.1682728795168d-06, 9.5665441273340d-05, 1.6989205320016d-03,
     |   9.4247094552603d-03, 2.7652486150868d-02, 5.1023947113991d-02,
     |   6.0807459343167d-02, 3.8319793697080d-02,-1.2470089883827d-02,
     |  -5.8066450471952d-02,-5.9482616704646d-02,-1.0115268989686d-02,
     |   5.0721256437973d-02, 6.8563387222707d-02, 2.4563595979809d-02,
     |  -4.3140824091961d-02,-7.2252255599935d-02,-3.4865034848424d-02,
     |   3.4865034848424d-02, 7.2252255599935d-02, 4.3140824091961d-02,
     |  -2.4563595979809d-02,-6.8563387222707d-02,-5.0721256437972d-02,
     |   1.0115268989685d-02, 5.9482616704646d-02, 5.8066450471952d-02,
     |   1.2470089883827d-02,-3.8319793697080d-02,-6.0807459343167d-02,
     |  -5.1023947113991d-02,-2.7652486150868d-02,-9.4247094552604d-03,
     |  -1.6989205320017d-03,-9.5665441273302d-05,-1.1682728797037d-06/
      data (zmn(lat, 6,12), lat = 1,36)/
     |   3.8742060213307d-08, 1.1950033782535d-05, 3.6471041131398d-04,
     |   2.9911955544216d-03, 1.2267975560047d-02, 3.1524198109002d-02,
     |   5.5549768920395d-02, 6.7567124041577d-02, 4.9397337370286d-02,
     |   5.9214298394516d-04,-5.1954249631656d-02,-6.9401477452550d-02,
     |  -3.3865451923983d-02, 3.0375574828404d-02, 7.1651716892370d-02,
     |   5.3847783391643d-02,-9.9092007778802d-03,-6.5889502148414d-02,
     |  -6.5889502148414d-02,-9.9092007778804d-03, 5.3847783391642d-02,
     |   7.1651716892370d-02, 3.0375574828404d-02,-3.3865451923983d-02,
     |  -6.9401477452550d-02,-5.1954249631656d-02, 5.9214298394503d-04,
     |   4.9397337370286d-02, 6.7567124041577d-02, 5.5549768920395d-02,
     |   3.1524198109002d-02, 1.2267975560047d-02, 2.9911955544216d-03,
     |   3.6471041131396d-04, 1.1950033782330d-05, 3.8742060253472d-08/
      data (zmn(lat, 7,12), lat = 1,36)/
     |  -2.6992530826247d-08, 1.2376741369294d-06, 6.3038793428055d-05,
     |   7.5376842561858d-04, 4.2159423252120d-03, 1.4418222528239d-02,
     |   3.4071885935919d-02, 5.8679113823307d-02, 7.3697258856554d-02,
     |   6.1655753175612d-02, 1.7729767922826d-02,-3.9057686288956d-02,
     |  -7.3137365536106d-02,-5.7940999873193d-02,-4.3299380917239d-04,
     |   5.8771280973124d-02, 7.4493870330189d-02, 3.3420687388430d-02,
     |  -3.3420687388430d-02,-7.4493870330189d-02,-5.8771280973124d-02,
     |   4.3299380917237d-04, 5.7940999873193d-02, 7.3137365536106d-02,
     |   3.9057686288956d-02,-1.7729767922826d-02,-6.1655753175612d-02,
     |  -7.3697258856554d-02,-5.8679113823307d-02,-3.4071885935919d-02,
     |  -1.4418222528239d-02,-4.2159423252120d-03,-7.5376842561851d-04,
     |  -6.3038793428017d-05,-1.2376741369486d-06, 2.6992530988010d-08/
      data (zmn(lat, 8,12), lat = 1,36)/
     |  -5.4381327501888d-10, 1.0177320721670d-07, 8.8638071647487d-06,
     |   1.5305882320642d-04, 1.1509412256124d-03, 5.1172978701759d-03,
     |   1.5564146265146d-02, 3.4918955349826d-02, 5.9855142664560d-02,
     |   7.8463652210761d-02, 7.4518330433722d-02, 3.9264988799802d-02,
     |  -1.7143635104083d-02,-6.6032182481432d-02,-7.6694217731343d-02,
     |  -3.9252717438164d-02, 2.4310362139273d-02, 7.2393585528497d-02,
     |   7.2393585528497d-02, 2.4310362139273d-02,-3.9252717438164d-02,
     |  -7.6694217731343d-02,-6.6032182481432d-02,-1.7143635104082d-02,
     |   3.9264988799802d-02, 7.4518330433722d-02, 7.8463652210761d-02,
     |   5.9855142664560d-02, 3.4918955349826d-02, 1.5564146265146d-02,
     |   5.1172978701758d-03, 1.1509412256124d-03, 1.5305882320642d-04,
     |   8.8638071648107d-06, 1.0177320730902d-07,-5.4381332520525d-10/
      data (zmn(lat, 9,12), lat = 1,36)/
     |   5.3349869463309d-10, 6.2973883757751d-09, 1.0102529902457d-06,
     |   2.5032928974008d-05, 2.5077574414388d-04, 1.4295066019020d-03,
     |   5.4744463410641d-03, 1.5419846239779d-02, 3.3622375554500d-02,
     |   5.8244709776310d-02, 8.0476692669661d-02, 8.6284426899318d-02,
     |   6.4219670748623d-02, 1.5470257921467d-02,-4.1742423536459d-02,
     |  -7.9316380085767d-02,-7.5692197679248d-02,-3.0947055950598d-02,
     |   3.0947055950598d-02, 7.5692197679248d-02, 7.9316380085767d-02,
     |   4.1742423536459d-02,-1.5470257921467d-02,-6.4219670748623d-02,
     |  -8.6284426899318d-02,-8.0476692669661d-02,-5.8244709776310d-02,
     |  -3.3622375554500d-02,-1.5419846239779d-02,-5.4744463410642d-03,
     |  -1.4295066019020d-03,-2.5077574414386d-04,-2.5032928974010d-05,
     |  -1.0102529902445d-06,-6.2973883781716d-09,-5.3349866898929d-10/
      data (zmn(lat,10,12), lat = 1,36)/
     |   6.5805425327775d-12, 3.4608767028298d-10, 9.1432326107806d-08,
     |   3.2399387538277d-06, 4.2970915804962d-05, 3.1120342308442d-04,
     |   1.4806796289471d-03, 5.1307153081302d-03, 1.3771655987472d-02,
     |   2.9733332741912d-02, 5.2752470971833d-02, 7.7495547225996d-02,
     |   9.3411130129626d-02, 8.8692193319144d-02, 5.7361874647275d-02,
     |   5.3230636729957d-03,-4.9504856367425d-02,-8.4664711552919d-02,
     |  -8.4664711552919d-02,-4.9504856367425d-02, 5.3230636729954d-03,
     |   5.7361874647275d-02, 8.8692193319144d-02, 9.3411130129626d-02,
     |   7.7495547225996d-02, 5.2752470971833d-02, 2.9733332741912d-02,
     |   1.3771655987472d-02, 5.1307153081302d-03, 1.4806796289471d-03,
     |   3.1120342308445d-04, 4.2970915805033d-05, 3.2399387539319d-06,
     |   9.1432326172113d-08, 3.4608771596494d-10, 6.5805269401527d-12/
      data (zmn(lat,11,12), lat = 1,36)/
     |  -6.1342817758365d-12, 2.0283394708706d-11, 6.2567703049102d-09,
     |   3.1636675326968d-07, 5.5303791390833d-06, 5.0566171377204d-05,
     |   2.9627253790735d-04, 1.2470851617284d-03, 4.0447805024460d-03,
     |   1.0575913261023d-02, 2.2967350884517d-02, 4.2230939992025d-02,
     |   6.6468611953502d-02, 8.9802356674142d-02, 1.0333316824999d-01,
     |   9.8486982264427d-02, 7.1447063721726d-02, 2.6168624568099d-02,
     |  -2.6168624568099d-02,-7.1447063721726d-02,-9.8486982264427d-02,
     |  -1.0333316824999d-01,-8.9802356674142d-02,-6.6468611953502d-02,
     |  -4.2230939992025d-02,-2.2967350884517d-02,-1.0575913261023d-02,
     |  -4.0447805024461d-03,-1.2470851617284d-03,-2.9627253790737d-04,
     |  -5.0566171377256d-05,-5.5303791391122d-06,-3.1636675328803d-07,
     |  -6.2567702628281d-09,-2.0283319775106d-11, 6.1342572099536d-12/
      data (zmn(lat,12,12), lat = 1,36)/
     |  -3.5800111582678d-14, 4.8764251506365d-13, 2.8323555361957d-10,
     |   2.0361257192731d-08, 4.6759920814844d-07, 5.3731765276323d-06,
     |   3.8527702536916d-05, 1.9533090556618d-04, 7.5655725428625d-04,
     |   2.3559159780118d-03, 6.1097692918733d-03, 1.3531246171892d-02,
     |   2.6063594662429d-02, 4.4254536694710d-02, 6.6897797858865d-02,
     |   9.0681348982866d-02, 1.1077701585025d-01, 1.2234385621529d-01,
     |   1.2234385621529d-01, 1.1077701585025d-01, 9.0681348982866d-02,
     |   6.6897797858865d-02, 4.4254536694710d-02, 2.6063594662429d-02,
     |   1.3531246171892d-02, 6.1097692918732d-03, 2.3559159780118d-03,
     |   7.5655725428621d-04, 1.9533090556619d-04, 3.8527702536921d-05,
     |   5.3731765276544d-06, 4.6759920818726d-07, 2.0361257206627d-08,
     |   2.8323554256556d-10, 4.8761506656968d-13,-3.5782669058726d-14/
      data (zmn(lat, 0,13), lat = 1,36)/
     |   1.0843862031175d-02, 1.6225815456738d-02,-1.7618169560171d-02,
     |  -3.6897866545109d-02,-9.8033686515104d-03, 3.9228371036795d-02,
     |   4.2430239531614d-02,-9.6308171367605d-03,-5.6263858372055d-02,
     |  -3.3347192858943d-02, 3.3824272797690d-02, 6.2990813859804d-02,
     |   1.2874682185878d-02,-5.5269191129433d-02,-5.6833349034852d-02,
     |   1.3480860346524d-02, 6.7759024855012d-02, 3.8872510106331d-02,
     |  -3.8872510106331d-02,-6.7759024855012d-02,-1.3480860346524d-02,
     |   5.6833349034852d-02, 5.5269191129433d-02,-1.2874682185878d-02,
     |  -6.2990813859804d-02,-3.3824272797690d-02, 3.3347192858943d-02,
     |   5.6263858372055d-02, 9.6308171367609d-03,-4.2430239531614d-02,
     |  -3.9228371036795d-02, 9.8033686515103d-03, 3.6897866545109d-02,
     |   1.7618169560171d-02,-1.6225815456739d-02,-1.0843862031175d-02/
      data (zmn(lat, 1,13), lat = 1,36)/
     |   4.5807882284919d-03, 2.4110982465340d-02, 2.5189026359959d-02,
     |  -1.0818153262790d-02,-4.2959520565109d-02,-2.4314210540729d-02,
     |   3.0290645944497d-02, 5.2997402038872d-02, 9.4986915371354d-03,
     |  -5.0640731974103d-02,-5.0898753782152d-02, 1.3594124953181d-02,
     |   6.4583185752175d-02, 3.6581594603615d-02,-3.8311456285714d-02,
     |  -6.7466967890282d-02,-1.3290257891699d-02, 5.7972624097191d-02,
     |   5.7972624097191d-02,-1.3290257891699d-02,-6.7466967890282d-02,
     |  -3.8311456285714d-02, 3.6581594603615d-02, 6.4583185752175d-02,
     |   1.3594124953181d-02,-5.0898753782152d-02,-5.0640731974103d-02,
     |   9.4986915371352d-03, 5.2997402038871d-02, 3.0290645944497d-02,
     |  -2.4314210540729d-02,-4.2959520565109d-02,-1.0818153262790d-02,
     |   2.5189026359959d-02, 2.4110982465340d-02, 4.5807882284919d-03/
      data (zmn(lat, 2,13), lat = 1,36)/
     |   6.7392307155819d-04, 1.2342891527174d-02, 3.3834622249397d-02,
     |   3.2576798187442d-02,-6.0660392675308d-03,-4.6024650838792d-02,
     |  -3.5907241869661d-02, 2.0271231295749d-02, 5.7858563469909d-02,
     |   2.6854827010554d-02,-4.0057137824428d-02,-6.1838680551983d-02,
     |  -8.1340207862089d-03, 5.8026002948642d-02, 5.5161710306198d-02,
     |  -1.5603718394758d-02,-6.8573976610788d-02,-3.8533188728802d-02,
     |   3.8533188728802d-02, 6.8573976610788d-02, 1.5603718394758d-02,
     |  -5.5161710306198d-02,-5.8026002948642d-02, 8.1340207862090d-03,
     |   6.1838680551983d-02, 4.0057137824428d-02,-2.6854827010554d-02,
     |  -5.7858563469909d-02,-2.0271231295749d-02, 3.5907241869661d-02,
     |   4.6024650838792d-02, 6.0660392675309d-03,-3.2576798187441d-02,
     |  -3.3834622249397d-02,-1.2342891527174d-02,-6.7392307155825d-04/
      data (zmn(lat, 3,13), lat = 1,36)/
     |   2.1390790027292d-05, 3.8843330794328d-03, 2.0542436893922d-02,
     |   4.2092670037565d-02, 3.9029406794353d-02,-2.0684251950626d-03,
     |  -4.7627031932472d-02,-4.5630940183962d-02, 9.4318664878311d-03,
     |   5.8632527385903d-02, 4.2206368243270d-02,-2.5625951367578d-02,
     |  -6.6589652881470d-02,-2.9748086453377d-02, 4.3988379913848d-02,
     |   6.7186324247525d-02, 1.0718410155885d-02,-5.9134964074486d-02,
     |  -5.9134964074486d-02, 1.0718410155885d-02, 6.7186324247525d-02,
     |   4.3988379913848d-02,-2.9748086453377d-02,-6.6589652881470d-02,
     |  -2.5625951367578d-02, 4.2206368243270d-02, 5.8632527385903d-02,
     |   9.4318664878312d-03,-4.5630940183961d-02,-4.7627031932472d-02,
     |  -2.0684251950625d-03, 3.9029406794353d-02, 4.2092670037565d-02,
     |   2.0542436893922d-02, 3.8843330794328d-03, 2.1390790027322d-05/
      data (zmn(lat, 4,13), lat = 1,36)/
     |   1.6325267003560d-06, 8.6414959809434d-04, 8.3071792064545d-03,
     |   2.8220608623269d-02, 4.9585320745782d-02, 4.4957696285678d-02,
     |   2.1701665664296d-03,-4.8024600460672d-02,-5.4104264140509d-02,
     |  -2.6280025146172d-03, 5.5686690290772d-02, 5.5383933629513d-02,
     |  -7.6527877028413d-03,-6.4733272960560d-02,-4.9723141597889d-02,
     |   2.2710350759742d-02, 7.0443294671708d-02, 3.7998992498919d-02,
     |  -3.7998992498919d-02,-7.0443294671708d-02,-2.2710350759742d-02,
     |   4.9723141597889d-02, 6.4733272960560d-02, 7.6527877028412d-03,
     |  -5.5383933629513d-02,-5.5686690290772d-02, 2.6280025146171d-03,
     |   5.4104264140509d-02, 4.8024600460673d-02,-2.1701665664295d-03,
     |  -4.4957696285678d-02,-4.9585320745782d-02,-2.8220608623269d-02,
     |  -8.3071792064546d-03,-8.6414959809455d-04,-1.6325267003410d-06/
      data (zmn(lat, 5,13), lat = 1,36)/
     |   1.5891274844450d-06, 1.4656247836793d-04, 2.5086186837811d-03,
     |   1.3137526512655d-02, 3.5260683028574d-02, 5.6401383496008d-02,
     |   5.0929943819805d-02, 7.4057373085886d-03,-4.6773702551067d-02,
     |  -6.1576397810475d-02,-1.6378518903334d-02, 4.8428107977562d-02,
     |   6.5710061189675d-02, 1.3620479124701d-02,-5.4915442717337d-02,
     |  -6.5660708859790d-02,-5.1507767541176d-03, 6.1620284207244d-02,
     |   6.1620284207244d-02,-5.1507767541175d-03,-6.5660708859790d-02,
     |  -5.4915442717337d-02, 1.3620479124701d-02, 6.5710061189675d-02,
     |   4.8428107977562d-02,-1.6378518903334d-02,-6.1576397810475d-02,
     |  -4.6773702551067d-02, 7.4057373085882d-03, 5.0929943819804d-02,
     |   5.6401383496008d-02, 3.5260683028574d-02, 1.3137526512655d-02,
     |   2.5086186837812d-03, 1.4656247836789d-04, 1.5891274843806d-06/
      data (zmn(lat, 6,13), lat = 1,36)/
     |   6.9482854887468d-08, 2.0123448831223d-05, 5.9651700806333d-04,
     |   4.6662228450411d-03, 1.7853365591086d-02, 4.1469860766105d-02,
     |   6.2600474242676d-02, 5.7409459212315d-02, 1.4451281345136d-02,
     |  -4.3051493950367d-02,-6.7684574005534d-02,-3.2150956399151d-02,
     |   3.5644278444008d-02, 7.1406145591116d-02, 3.7287314560524d-02,
     |  -3.5251247422674d-02,-7.3274844244373d-02,-3.7045635720767d-02,
     |   3.7045635720767d-02, 7.3274844244373d-02, 3.5251247422674d-02,
     |  -3.7287314560524d-02,-7.1406145591117d-02,-3.5644278444007d-02,
     |   3.2150956399151d-02, 6.7684574005534d-02, 4.3051493950367d-02,
     |  -1.4451281345136d-02,-5.7409459212315d-02,-6.2600474242676d-02,
     |  -4.1469860766105d-02,-1.7853365591086d-02,-4.6662228450410d-03,
     |  -5.9651700806330d-04,-2.0123448831049d-05,-6.9482854946599d-08/
      data (zmn(lat, 7,13), lat = 1,36)/
     |  -4.1839463044339d-08, 2.3063957673168d-06, 1.1496158395853d-04,
     |   1.3203094987548d-03, 6.9724509068121d-03, 2.2023991326253d-02,
     |   4.6589146950115d-02, 6.8162155910081d-02, 6.4731598983880d-02,
     |   2.4152117311703d-02,-3.5606894814367d-02,-7.1233896680799d-02,
     |  -4.9649871318644d-02, 1.5804738074598d-02, 6.9143995651217d-02,
     |   6.0491022066978d-02,-4.4166708596439d-03,-6.5847257209782d-02,
     |  -6.5847257209782d-02,-4.4166708596441d-03, 6.0491022066978d-02,
     |   6.9143995651217d-02, 1.5804738074598d-02,-4.9649871318644d-02,
     |  -7.1233896680799d-02,-3.5606894814367d-02, 2.4152117311703d-02,
     |   6.4731598983880d-02, 6.8162155910081d-02, 4.6589146950115d-02,
     |   2.2023991326253d-02, 6.9724509068121d-03, 1.3203094987548d-03,
     |   1.1496158395848d-04, 2.3063957673085d-06,-4.1839462989472d-08/
      data (zmn(lat, 8,13), lat = 1,36)/
     |  -1.2524655685950d-09, 2.1435764658101d-07, 1.8226939017852d-05,
     |   3.0389900322825d-04, 2.1754662790639d-03, 9.0537737579648d-03,
     |   2.5222933187608d-02, 5.0276312977517d-02, 7.2873327390146d-02,
     |   7.2982812332039d-02, 3.7269190247493d-02,-2.2710029531054d-02,
     |  -6.9808040369333d-02,-6.7103780161044d-02,-1.2113575870103d-02,
     |   5.3883898729379d-02, 7.6513308213309d-02, 3.5463776625190d-02,
     |  -3.5463776625190d-02,-7.6513308213309d-02,-5.3883898729379d-02,
     |   1.2113575870103d-02, 6.7103780161044d-02, 6.9808040369333d-02,
     |   2.2710029531054d-02,-3.7269190247493d-02,-7.2982812332039d-02,
     |  -7.2873327390146d-02,-5.0276312977517d-02,-2.5222933187608d-02,
     |  -9.0537737579648d-03,-2.1754662790639d-03,-3.0389900322828d-04,
     |  -1.8226939017938d-05,-2.1435764666267d-07, 1.2524656004191d-09/
      data (zmn(lat, 9,13), lat = 1,36)/
     |   1.0171515112122d-09, 1.5455564921321d-08, 2.3857504423459d-06,
     |   5.7310216235290d-05, 5.4986910325048d-04, 2.9610268533566d-03,
     |   1.0536840311712d-02, 2.7004307373956d-02, 5.2042477652459d-02,
     |   7.6173649247348d-02, 8.1735474720182d-02, 5.4167387806051d-02,
     |  -2.2995446314660d-03,-5.9318004347626d-02,-7.9828632311070d-02,
     |  -4.6517311089748d-02, 2.0094004527879d-02, 7.2835745157087d-02,
     |   7.2835745157087d-02, 2.0094004527879d-02,-4.6517311089747d-02,
     |  -7.9828632311070d-02,-5.9318004347626d-02,-2.2995446314659d-03,
     |   5.4167387806051d-02, 8.1735474720182d-02, 7.6173649247348d-02,
     |   5.2042477652459d-02, 2.7004307373956d-02, 1.0536840311712d-02,
     |   2.9610268533565d-03, 5.4986910325052d-04, 5.7310216235288d-05,
     |   2.3857504423985d-06, 1.5455564949694d-08, 1.0171514704931d-09/
      data (zmn(lat,10,13), lat = 1,36)/
     |   2.0992310871709d-11, 9.7957166196516d-10, 2.5572006409182d-07,
     |   8.8106910341467d-06, 1.1244076631203d-04, 7.7449494024884d-04,
     |   3.4583244311561d-03, 1.1068590007689d-02, 2.6898071192803d-02,
     |   5.1185601474776d-02, 7.6945827745791d-02, 8.9592033321724d-02,
     |   7.4085762856834d-02, 2.7265825419114d-02,-3.3988834070816d-02,
     |  -7.8272827897908d-02,-7.8699668246308d-02,-3.2810349481522d-02,
     |   3.2810349481522d-02, 7.8699668246308d-02, 7.8272827897908d-02,
     |   3.3988834070816d-02,-2.7265825419114d-02,-7.4085762856834d-02,
     |  -8.9592033321724d-02,-7.6945827745791d-02,-5.1185601474776d-02,
     |  -2.6898071192803d-02,-1.1068590007689d-02,-3.4583244311563d-03,
     |  -7.7449494024884d-04,-1.1244076631201d-04,-8.8106910341067d-06,
     |  -2.5572006393337d-07,-9.7957164533899d-10,-2.0992276548032d-11/
      data (zmn(lat,11,13), lat = 1,36)/
     |  -1.6508732503806d-11, 6.6838526820968d-11, 2.1950833033179d-08,
     |   1.0817030238295d-06, 1.8262364548436d-05, 1.5964666860191d-04,
     |   8.8433340446628d-04, 3.4743844491664d-03, 1.0360053069592d-02,
     |   2.4445538112707d-02, 4.6771940122984d-02, 7.3300229103501d-02,
     |   9.3501743011092d-02, 9.3672297806376d-02, 6.4977995887788d-02,
     |   1.1681994495804d-02,-4.7135158013919d-02,-8.5709183836269d-02,
     |  -8.5709183836269d-02,-4.7135158013919d-02, 1.1681994495804d-02,
     |   6.4977995887788d-02, 9.3672297806376d-02, 9.3501743011092d-02,
     |   7.3300229103501d-02, 4.6771940122984d-02, 2.4445538112707d-02,
     |   1.0360053069592d-02, 3.4743844491665d-03, 8.8433340446636d-04,
     |   1.5964666860206d-04, 1.8262364548488d-05, 1.0817030239085d-06,
     |   2.1950833046866d-08, 6.6838464852653d-11,-1.6508644883852d-11/
      data (zmn(lat,12,13), lat = 1,36)/
     |  -2.1128188881150d-13, 2.5911279127621d-12, 1.4367196266354d-09,
     |   1.0090362102039d-07, 2.2447653530688d-06, 2.4765204571143d-05,
     |   1.6884343743309d-04, 8.0522917230539d-04, 2.8983749412084d-03,
     |   8.2703716430019d-03, 1.9326527153940d-02, 3.7777759828037d-02,
     |   6.2534804260609d-02, 8.7999325040254d-02, 1.0452869010532d-01,
     |   1.0198507152114d-01, 7.5132737452158d-02, 2.7729600249237d-02,
     |  -2.7729600249237d-02,-7.5132737452158d-02,-1.0198507152114d-01,
     |  -1.0452869010532d-01,-8.7999325040254d-02,-6.2534804260609d-02,
     |  -3.7777759828037d-02,-1.9326527153940d-02,-8.2703716430019d-03,
     |  -2.8983749412085d-03,-8.0522917230536d-04,-1.6884343743303d-04,
     |  -2.4765204571115d-05,-2.2447653530418d-06,-1.0090362096084d-07,
     |  -1.4367196295794d-09,-2.5910681396898d-12, 2.1127169101563d-13/
      data (zmn(lat,13,13), lat = 1,36)/
     |   1.1603795250337d-13,-5.1877927560682d-14, 6.2586097905100d-11,
     |   6.2392700286314d-09, 1.8235131292765d-07, 2.5283191775006d-06,
     |   2.1095258244424d-05, 1.2117507552454d-04, 5.2085921741504d-04,
     |   1.7700514493151d-03, 4.9395419040391d-03, 1.1629530849741d-02,
     |   2.3559086404619d-02, 4.1664708955114d-02, 6.5016940875417d-02,
     |   9.0218311212163d-02, 1.1192147784212d-01, 1.2455576236832d-01,
     |   1.2455576236832d-01, 1.1192147784212d-01, 9.0218311212163d-02,
     |   6.5016940875417d-02, 4.1664708955114d-02, 2.3559086404619d-02,
     |   1.1629530849741d-02, 4.9395419040392d-03, 1.7700514493151d-03,
     |   5.2085921741504d-04, 1.2117507552453d-04, 2.1095258244438d-05,
     |   2.5283191775128d-06, 1.8235131297009d-07, 6.2392700730512d-09,
     |   6.2586137269075d-11,-5.1815568190095d-14, 1.1597239100648d-13/
      data (zmn(lat, 0,14), lat = 1,36)/
     |   1.1028069312178d-02, 1.3529224150331d-02,-2.3270913148524d-02,
     |  -3.3221401702570d-02, 7.0315475968751d-03, 4.7273902451824d-02,
     |   2.0833397540152d-02,-4.0138643010143d-02,-4.9399725527484d-02,
     |   1.3938303893299d-02, 6.1667163700862d-02, 2.3626071448366d-02,
     |  -5.1049046261538d-02,-5.5672218408753d-02, 1.8778143808692d-02,
     |   6.8804475249768d-02, 2.2325160939850d-02,-5.6083512779037d-02,
     |  -5.6083512779037d-02, 2.2325160939850d-02, 6.8804475249768d-02,
     |   1.8778143808692d-02,-5.5672218408753d-02,-5.1049046261538d-02,
     |   2.3626071448366d-02, 6.1667163700862d-02, 1.3938303893300d-02,
     |  -4.9399725527484d-02,-4.0138643010144d-02, 2.0833397540152d-02,
     |   4.7273902451824d-02, 7.0315475968753d-03,-3.3221401702570d-02,
     |  -2.3270913148524d-02, 1.3529224150331d-02, 1.1028069312178d-02/
      data (zmn(lat, 1,14), lat = 1,36)/
     |   5.1805601964405d-03, 2.4892506264137d-02, 2.0200231591003d-02,
     |  -2.1355084505918d-02,-4.1757510819767d-02,-2.9636736506755d-03,
     |   4.7765410229197d-02, 3.4404526754123d-02,-3.1009884389369d-02,
     |  -5.7916593143872d-02,-2.7356383069205d-03, 5.9946992710151d-02,
     |   4.0497528027952d-02,-3.7910069548908d-02,-6.5093334517465d-02,
     |  -1.2027336242547d-03, 6.5880112596039d-02, 4.1031603352326d-02,
     |  -4.1031603352326d-02,-6.5880112596039d-02, 1.2027336242543d-03,
     |   6.5093334517465d-02, 3.7910069548908d-02,-4.0497528027953d-02,
     |  -5.9946992710152d-02, 2.7356383069207d-03, 5.7916593143872d-02,
     |   3.1009884389369d-02,-3.4404526754123d-02,-4.7765410229197d-02,
     |   2.9636736506755d-03, 4.1757510819767d-02, 2.1355084505918d-02,
     |  -2.0200231591002d-02,-2.4892506264137d-02,-5.1805601964406d-03/
      data (zmn(lat, 2,14), lat = 1,36)/
     |   8.0479253565179d-04, 1.4141332940403d-02, 3.5118472371132d-02,
     |   2.4620963652321d-02,-2.1526884782209d-02,-4.7906956324016d-02,
     |  -1.0849031375568d-02, 4.6808864184071d-02, 4.4726020489200d-02,
     |  -2.1181965978548d-02,-6.2407087627702d-02,-1.8316247416839d-02,
     |   5.4113551919492d-02, 5.3844261081474d-02,-2.1777246230563d-02,
     |  -6.9127229191639d-02,-2.1255729827910d-02, 5.6609642462853d-02,
     |   5.6609642462853d-02,-2.1255729827910d-02,-6.9127229191639d-02,
     |  -2.1777246230563d-02, 5.3844261081474d-02, 5.4113551919491d-02,
     |  -1.8316247416839d-02,-6.2407087627702d-02,-2.1181965978549d-02,
     |   4.4726020489200d-02, 4.6808864184071d-02,-1.0849031375567d-02,
     |  -4.7906956324016d-02,-2.1526884782209d-02, 2.4620963652321d-02,
     |   3.5118472371132d-02, 1.4141332940403d-02, 8.0479253565193d-04/
      data (zmn(lat, 3,14), lat = 1,36)/
     |   1.7875131864332d-05, 4.8598280989110d-03, 2.4052903393623d-02,
     |   4.3345599893880d-02, 2.7697028136251d-02,-2.2867288588387d-02,
     |  -5.2913890514139d-02,-1.7742839359117d-02, 4.5068697127140d-02,
     |   5.2959076621665d-02,-1.0561846529419d-02,-6.3886522895911d-02,
     |  -3.2916764491349d-02, 4.4439260727465d-02, 6.3892214582682d-02,
     |  -3.1641969039631d-03,-6.7219793199718d-02,-4.0826493957608d-02,
     |   4.0826493957608d-02, 6.7219793199718d-02, 3.1641969039635d-03,
     |  -6.3892214582682d-02,-4.4439260727465d-02, 3.2916764491350d-02,
     |   6.3886522895911d-02, 1.0561846529419d-02,-5.2959076621664d-02,
     |  -4.5068697127139d-02, 1.7742839359117d-02, 5.2913890514139d-02,
     |   2.2867288588387d-02,-2.7697028136251d-02,-4.3345599893880d-02,
     |  -2.4052903393624d-02,-4.8598280989110d-03,-1.7875131864297d-05/
      data (zmn(lat, 4,14), lat = 1,36)/
     |   2.1996240872774d-06, 1.1724631157024d-03, 1.0743028735873d-02,
     |   3.3538925551478d-02, 5.0430541490724d-02, 2.9842530720497d-02,
     |  -2.4359767453239d-02,-5.7409115313756d-02,-2.4395854936206d-02,
     |   4.2167154924959d-02, 5.9911462225686d-02, 1.2191424904831d-03,
     |  -6.2219238064653d-02,-4.6816732757322d-02, 3.0703530305684d-02,
     |   6.9861441687583d-02, 1.7805582563418d-02,-5.8222262147875d-02,
     |  -5.8222262147875d-02, 1.7805582563418d-02, 6.9861441687583d-02,
     |   3.0703530305684d-02,-4.6816732757322d-02,-6.2219238064653d-02,
     |   1.2191424904827d-03, 5.9911462225686d-02, 4.2167154924959d-02,
     |  -2.4395854936206d-02,-5.7409115313756d-02,-2.4359767453239d-02,
     |   2.9842530720497d-02, 5.0430541490724d-02, 3.3538925551478d-02,
     |   1.0743028735873d-02, 1.1724631157024d-03, 2.1996240872951d-06/
      data (zmn(lat, 5,14), lat = 1,36)/
     |   2.9689627162915d-06, 2.1566065751560d-04, 3.5624097365373d-03,
     |   1.7495511882504d-02, 4.2379308781094d-02, 5.6623247577300d-02,
     |   3.1816228533203d-02,-2.5301829978758d-02,-6.1467469812932d-02,
     |  -3.1629099286461d-02, 3.7454976451510d-02, 6.5676427937712d-02,
     |   1.4796455440867d-02,-5.6611976510866d-02,-5.9612924019254d-02,
     |   1.2227035593743d-02, 6.9972832887575d-02, 4.0209809088625d-02,
     |  -4.0209809088625d-02,-6.9972832887575d-02,-1.2227035593744d-02,
     |   5.9612924019254d-02, 5.6611976510866d-02,-1.4796455440867d-02,
     |  -6.5676427937712d-02,-3.7454976451510d-02, 3.1629099286461d-02,
     |   6.1467469812932d-02, 2.5301829978758d-02,-3.1816228533202d-02,
     |  -5.6623247577300d-02,-4.2379308781094d-02,-1.7495511882504d-02,
     |  -3.5624097365371d-03,-2.1566065751561d-04,-2.9689627162636d-06/
      data (zmn(lat, 6,14), lat = 1,36)/
     |   1.1551919344008d-07, 3.2401405167525d-05, 9.3019252279984d-04,
     |   6.9075353018234d-03, 2.4441837427825d-02, 5.0417811863004d-02,
     |   6.2248148819389d-02, 3.4407649183210d-02,-2.4936402878662d-02,
     |  -6.4923151883388d-02,-4.0133103647628d-02, 2.9934860596957d-02,
     |   6.9664232094386d-02, 3.0622307231968d-02,-4.5555167565867d-02,
     |  -6.9754927598030d-02,-1.1427482158566d-02, 6.1126325725191d-02,
     |   6.1126325725191d-02,-1.1427482158565d-02,-6.9754927598030d-02,
     |  -4.5555167565867d-02, 3.0622307231968d-02, 6.9664232094386d-02,
     |   2.9934860596957d-02,-4.0133103647628d-02,-6.4923151883388d-02,
     |  -2.4936402878662d-02, 3.4407649183210d-02, 6.2248148819389d-02,
     |   5.0417811863004d-02, 2.4441837427825d-02, 6.9075353018235d-03,
     |   9.3019252279995d-04, 3.2401405167671d-05, 1.1551919341114d-07/
      data (zmn(lat, 7,14), lat = 1,36)/
     |  -1.0302719119181d-07, 4.1058888252846d-06, 1.9765745295581d-04,
     |   2.1726811237587d-03, 1.0764390003809d-02, 3.1056114778941d-02,
     |   5.7529497040350d-02, 6.7703987958550d-02, 3.8430768548318d-02,
     |  -2.2339355979129d-02,-6.7279891001377d-02,-5.0326128512698d-02,
     |   1.8259511015966d-02, 7.0341706404155d-02, 4.8407752251891d-02,
     |  -2.6973860088645d-02,-7.3821098643591d-02,-3.9150767932628d-02,
     |   3.9150767932628d-02, 7.3821098643591d-02, 2.6973860088645d-02,
     |  -4.8407752251891d-02,-7.0341706404155d-02,-1.8259511015966d-02,
     |   5.0326128512698d-02, 6.7279891001377d-02, 2.2339355979129d-02,
     |  -3.8430768548318d-02,-6.7703987958550d-02,-5.7529497040350d-02,
     |  -3.1056114778941d-02,-1.0764390003809d-02,-2.1726811237588d-03,
     |  -1.9765745295596d-04,-4.1058888252818d-06, 1.0302719103946d-07/
      data (zmn(lat, 8,14), lat = 1,36)/
     |  -2.5251372828095d-09, 4.1984656044054d-07, 3.4825568741360d-05,
     |   5.5887289783562d-04, 3.7895214398480d-03, 1.4643653075980d-02,
     |   3.6859893287712d-02, 6.3603098990424d-02, 7.3359858912401d-02,
     |   4.4716354737813d-02,-1.6323864684429d-02,-6.7436021262820d-02,
     |  -6.2038429775407d-02, 8.8638540677829d-04, 6.4799738819767d-02,
     |   6.6110313169273d-02, 9.7142341684622d-04,-6.5772787827190d-02,
     |  -6.5772787827190d-02, 9.7142341684601d-04, 6.6110313169273d-02,
     |   6.4799738819767d-02, 8.8638540677853d-04,-6.2038429775407d-02,
     |  -6.7436021262821d-02,-1.6323864684429d-02, 4.4716354737813d-02,
     |   7.3359858912401d-02, 6.3603098990424d-02, 3.6859893287712d-02,
     |   1.4643653075980d-02, 3.7895214398481d-03, 5.5887289783565d-04,
     |   3.4825568741306d-05, 4.1984656024567d-07,-2.5251371820993d-09/
      data (zmn(lat, 9,14), lat = 1,36)/
     |   3.3104460335693d-09, 3.2889313298391d-08, 5.1270378705372d-06,
     |   1.1903500131327d-04, 1.0893141354764d-03, 5.5065400165804d-03,
     |   1.8030676397335d-02, 4.1374700346229d-02, 6.8442573743734d-02,
     |   7.9407275086622d-02, 5.4013018992532d-02,-5.3503680665036d-03,
     |  -6.3275386393412d-02,-7.3807589717899d-02,-2.3309468530777d-02,
     |   4.8456754135680d-02, 7.8157409545425d-02, 3.7446888547295d-02,
     |  -3.7446888547295d-02,-7.8157409545425d-02,-4.8456754135680d-02,
     |   2.3309468530777d-02, 7.3807589717899d-02, 6.3275386393412d-02,
     |   5.3503680665039d-03,-5.4013018992532d-02,-7.9407275086622d-02,
     |  -6.8442573743734d-02,-4.1374700346229d-02,-1.8030676397335d-02,
     |  -5.5065400165803d-03,-1.0893141354764d-03,-1.1903500131315d-04,
     |  -5.1270378704012d-06,-3.2889313303668d-08,-3.3104458336644d-09/
      data (zmn(lat,10,14), lat = 1,36)/
     |   5.3886538205660d-11, 2.4576273119183d-09, 6.2951659307095d-07,
     |   2.1039597601889d-05, 2.5744065564462d-04, 1.6778122851872d-03,
     |   6.9779004334778d-03, 2.0393802169288d-02, 4.4061727872404d-02,
     |   7.1609460454642d-02, 8.5607537995263d-02, 6.6716243501360d-02,
     |   1.2404367777570d-02,-5.1185634220620d-02,-8.1566354022356d-02,
     |  -5.3243512190166d-02, 1.5865831652630d-02, 7.3219981315408d-02,
     |   7.3219981315408d-02, 1.5865831652630d-02,-5.3243512190166d-02,
     |  -8.1566354022356d-02,-5.1185634220620d-02, 1.2404367777570d-02,
     |   6.6716243501360d-02, 8.5607537995263d-02, 7.1609460454642d-02,
     |   4.4061727872404d-02, 2.0393802169288d-02, 6.9779004334778d-03,
     |   1.6778122851871d-03, 2.5744065564453d-04, 2.1039597601877d-05,
     |   6.2951659316090d-07, 2.4576275233628d-09, 5.3886589980643d-11/
      data (zmn(lat,11,14), lat = 1,36)/
     |  -7.7393235834775d-11, 2.2602568746529d-10, 6.3823712709059d-08,
     |   3.0607654882549d-06, 4.9750676910799d-05, 4.1398138213921d-04,
     |   2.1546040387950d-03, 7.8317264115448d-03, 2.1194794412206d-02,
     |   4.4249649267788d-02, 7.2209651834673d-02, 9.0866902776370d-02,
     |   8.2229324301516d-02, 3.8448594740857d-02,-2.5901300756917d-02,
     |  -7.6689320633639d-02,-8.1439598681054d-02,-3.4627305364125d-02,
     |   3.4627305364125d-02, 8.1439598681054d-02, 7.6689320633639d-02,
     |   2.5901300756917d-02,-3.8448594740857d-02,-8.2229324301516d-02,
     |  -9.0866902776370d-02,-7.2209651834673d-02,-4.4249649267788d-02,
     |  -2.1194794412206d-02,-7.8317264115449d-03,-2.1546040387951d-03,
     |  -4.1398138213919d-04,-4.9750676910826d-05,-3.0607654883022d-06,
     |  -6.3823712758921d-08,-2.2602571790430d-10, 7.7393206635940d-11/
      data (zmn(lat,12,14), lat = 1,36)/
     |  -7.9259394544913d-13, 9.6042926141114d-12, 5.2314128275127d-09,
     |   3.5822123956948d-07, 7.6983862885842d-06, 8.1228674027416d-05,
     |   5.2380469698164d-04, 2.3330655085266d-03, 7.7271145859083d-03,
     |   1.9922043172385d-02, 4.1091436810989d-02, 6.8659784269078d-02,
     |   9.2584664094714d-02, 9.7627959050314d-02, 7.2012510041291d-02,
     |   1.7935226786627d-02,-4.4672439254846d-02,-8.6671362876748d-02,
     |  -8.6671362876748d-02,-4.4672439254846d-02, 1.7935226786627d-02,
     |   7.2012510041291d-02, 9.7627959050314d-02, 9.2584664094714d-02,
     |   6.8659784269078d-02, 4.1091436810989d-02, 1.9922043172385d-02,
     |   7.7271145859083d-03, 2.3330655085266d-03, 5.2380469698167d-04,
     |   8.1228674027431d-05, 7.6983862885844d-06, 3.5822123955256d-07,
     |   5.2314127741197d-09, 9.6042675040475d-12,-7.9263165054203d-13/
      data (zmn(lat,13,14), lat = 1,36)/
     |   1.0469621303633d-12,-6.9963400473399d-13, 3.2947016865299d-10,
     |   3.2043987775514d-08, 9.0724261553109d-07, 1.2077020585264d-05,
     |   9.5810485086874d-05, 5.1770093849832d-04, 2.0679985858406d-03,
     |   6.4397385405261d-03, 1.6193204513098d-02, 3.3649430470824d-02,
     |   5.8581844774819d-02, 8.5863188531716d-02, 1.0528520198338d-01,
     |   1.0515512473561d-01, 7.8670172734886d-02, 2.9257848369192d-02,
     |  -2.9257848369192d-02,-7.8670172734886d-02,-1.0515512473561d-01,
     |  -1.0528520198338d-01,-8.5863188531716d-02,-5.8581844774819d-02,
     |  -3.3649430470825d-02,-1.6193204513098d-02,-6.4397385405261d-03,
     |  -2.0679985858406d-03,-5.1770093849829d-04,-9.5810485086846d-05,
     |  -1.2077020585268d-05,-9.0724261550760d-07,-3.2043987750132d-08,
     |  -3.2947015407251d-10, 6.9967526518284d-13,-1.0470030822809d-12/
      data (zmn(lat,14,14), lat = 1,36)/
     |   4.9930162838593d-15,-7.0289918758454d-15, 1.3785788875804d-11,
     |   1.9093939877540d-09, 7.1018016431178d-08, 1.1881122724740d-06,
     |   1.1535099727151d-05, 7.5072419027924d-05, 3.5811596572161d-04,
     |   1.3281182900695d-03, 3.9881667827717d-03, 9.9818576046895d-03,
     |   2.1267054901568d-02, 3.9174519803881d-02, 6.3105326259962d-02,
     |   8.9638832147006d-02, 1.1292809070860d-01, 1.2663981242431d-01,
     |   1.2663981242431d-01, 1.1292809070860d-01, 8.9638832147006d-02,
     |   6.3105326259962d-02, 3.9174519803881d-02, 2.1267054901568d-02,
     |   9.9818576046895d-03, 3.9881667827718d-03, 1.3281182900696d-03,
     |   3.5811596572162d-04, 7.5072419027943d-05, 1.1535099727172d-05,
     |   1.1881122724888d-06, 7.1018016433633d-08, 1.9093939544749d-09,
     |   1.3785738986062d-11,-7.0612586432708d-15, 4.9862903792306d-15/
      data (zmn(lat, 0,15), lat = 1,36)/
     |   1.1159571190856d-02, 1.0640484986773d-02,-2.7885899338208d-02,
     |  -2.6303455565905d-02, 2.2626596160449d-02, 4.4783357820005d-02,
     |  -7.5406494968030d-03,-5.3762011155649d-02,-1.6821326649730d-02,
     |   5.2486602989100d-02, 4.0874553448589d-02,-3.7262392234121d-02,
     |  -6.0370928103187d-02, 1.3081179552373d-02, 6.7719005576777d-02,
     |   1.6701260801556d-02,-6.2362008611229d-02,-4.3340204611328d-02,
     |   4.3340204611328d-02, 6.2362008611229d-02,-1.6701260801555d-02,
     |  -6.7719005576777d-02,-1.3081179552373d-02, 6.0370928103187d-02,
     |   3.7262392234122d-02,-4.0874553448589d-02,-5.2486602989101d-02,
     |   1.6821326649730d-02, 5.3762011155649d-02, 7.5406494968033d-03,
     |  -4.4783357820005d-02,-2.2626596160449d-02, 2.6303455565904d-02,
     |   2.7885899338208d-02,-1.0640484986773d-02,-1.1159571190856d-02/
      data (zmn(lat, 1,15), lat = 1,36)/
     |   5.6172827554223d-03, 2.5506988916069d-02, 1.4158278976220d-02,
     |  -2.9822226625727d-02,-3.4496741711086d-02, 1.9194154267552d-02,
     |   5.0276617617977d-02, 1.8332491351119d-03,-5.5425257199440d-02,
     |  -2.7642426756280d-02, 4.7445268428768d-02, 5.1028301925704d-02,
     |  -2.7184582574411d-02,-6.5570419646071d-02,-9.6307808248210d-04,
     |   6.6965908484989d-02, 3.0491464569105d-02,-5.4365215931949d-02,
     |  -5.4365215931949d-02, 3.0491464569105d-02, 6.6965908484989d-02,
     |  -9.6307808248202d-04,-6.5570419646071d-02,-2.7184582574411d-02,
     |   5.1028301925704d-02, 4.7445268428768d-02,-2.7642426756280d-02,
     |  -5.5425257199440d-02, 1.8332491351117d-03, 5.0276617617976d-02,
     |   1.9194154267552d-02,-3.4496741711086d-02,-2.9822226625727d-02,
     |   1.4158278976220d-02, 2.5506988916069d-02, 5.6172827554222d-03/
      data (zmn(lat, 2,15), lat = 1,36)/
     |   9.5089330599601d-04, 1.5943264584854d-02, 3.5370871483721d-02,
     |   1.4807735811541d-02,-3.4033694846395d-02,-3.9763897733903d-02,
     |   1.7436215675837d-02, 5.4621166859929d-02, 8.7584420754714d-03,
     |  -5.5722894337661d-02,-3.6574850584189d-02, 4.1866939791927d-02,
     |   5.8567090175477d-02,-1.6443595591022d-02,-6.8249125952554d-02,
     |  -1.4644610319350d-02, 6.2944954021626d-02, 4.3411636816334d-02,
     |  -4.3411636816334d-02,-6.2944954021626d-02, 1.4644610319350d-02,
     |   6.8249125952554d-02, 1.6443595591022d-02,-5.8567090175477d-02,
     |  -4.1866939791928d-02, 3.6574850584189d-02, 5.5722894337661d-02,
     |  -8.7584420754713d-03,-5.4621166859929d-02,-1.7436215675838d-02,
     |   3.9763897733903d-02, 3.4033694846395d-02,-1.4807735811541d-02,
     |  -3.5370871483721d-02,-1.5943264584854d-02,-9.5089330599593d-04/
      data (zmn(lat, 3,15), lat = 1,36)/
     |   2.9870561548046d-05, 5.9424372568603d-03, 2.7441058175342d-02,
     |   4.2356604348777d-02, 1.3305262559441d-02,-3.9331479037282d-02,
     |  -4.3547743048321d-02, 1.6764842162943d-02, 5.8396316485569d-02,
     |   1.4525935734611d-02,-5.5187696994599d-02,-4.4488132778463d-02,
     |   3.5388222000079d-02, 6.4347437919341d-02,-4.6556546678737d-03,
     |  -6.8384797265885d-02,-2.8584055027084d-02, 5.5323529829085d-02,
     |   5.5323529829086d-02,-2.8584055027084d-02,-6.8384797265885d-02,
     |  -4.6556546678738d-03, 6.4347437919341d-02, 3.5388222000079d-02,
     |  -4.4488132778463d-02,-5.5187696994599d-02, 1.4525935734611d-02,
     |   5.8396316485569d-02, 1.6764842162943d-02,-4.3547743048321d-02,
     |  -3.9331479037282d-02, 1.3305262559441d-02, 4.2356604348777d-02,
     |   2.7441058175342d-02, 5.9424372568603d-03, 2.9870561548196d-05/
      data (zmn(lat, 4,15), lat = 1,36)/
     |   2.7685165768221d-06, 1.5520574314568d-03, 1.3491289603844d-02,
     |   3.8278489589341d-02, 4.7321617392702d-02, 1.0195587737075d-02,
     |  -4.4769814686315d-02,-4.6703282474081d-02, 1.6494984105315d-02,
     |   6.1699339263592d-02, 2.0264148280372d-02,-5.3712143850040d-02,
     |  -5.1978428218925d-02, 2.7216835691273d-02, 6.8589767958414d-02,
     |   8.7808441789615d-03,-6.5232584246239d-02,-4.3049631000706d-02,
     |   4.3049631000706d-02, 6.5232584246239d-02,-8.7808441789611d-03,
     |  -6.8589767958414d-02,-2.7216835691274d-02, 5.1978428218925d-02,
     |   5.3712143850040d-02,-2.0264148280372d-02,-6.1699339263592d-02,
     |  -1.6494984105315d-02, 4.6703282474081d-02, 4.4769814686315d-02,
     |  -1.0195587737075d-02,-4.7321617392702d-02,-3.8278489589342d-02,
     |  -1.3491289603844d-02,-1.5520574314568d-03,-2.7685165769355d-06/
      data (zmn(lat, 5,15), lat = 1,36)/
     |   3.7917032888955d-06, 3.0902207450380d-04, 4.8873628552836d-03,
     |   2.2360524021908d-02, 4.8073879520666d-02, 5.0603867027880d-02,
     |   6.4291861273903d-03,-4.9895022924251d-02,-4.9739506867439d-02,
     |   1.5706119829857d-02, 6.4568779741005d-02, 2.6833747666505d-02,
     |  -5.0620037475182d-02,-5.9426426290898d-02, 1.6403890107450d-02,
     |   7.0667008617798d-02, 2.4467084140007d-02,-5.7334204478162d-02,
     |  -5.7334204478162d-02, 2.4467084140007d-02, 7.0667008617798d-02,
     |   1.6403890107450d-02,-5.9426426290898d-02,-5.0620037475181d-02,
     |   2.6833747666505d-02, 6.4568779741005d-02, 1.5706119829857d-02,
     |  -4.9739506867439d-02,-4.9895022924251d-02, 6.4291861273900d-03,
     |   5.0603867027880d-02, 4.8073879520666d-02, 2.2360524021908d-02,
     |   4.8873628552835d-03, 3.0902207450381d-04, 3.7917032887969d-06/
      data (zmn(lat, 6,15), lat = 1,36)/
     |   1.9250373854000d-07, 5.0194485388852d-05, 1.3925763212886d-03,
     |   9.7674002403109d-03, 3.1647725651614d-02, 5.6650527153166d-02,
     |   5.2782750895573d-02, 2.9352705341894d-03,-5.4344378209410d-02,
     |  -5.3216492074171d-02, 1.3445406033853d-02, 6.6775733601913d-02,
     |   3.5014816361511d-02,-4.4840756574717d-02,-6.6637361679896d-02,
     |   1.8259728914646d-03, 6.8987981722216d-02, 4.2337769240932d-02,
     |  -4.2337769240932d-02,-6.8987981722216d-02,-1.8259728914650d-03,
     |   6.6637361679896d-02, 4.4840756574717d-02,-3.5014816361511d-02,
     |  -6.6775733601913d-02,-1.3445406033853d-02, 5.3216492074171d-02,
     |   5.4344378209410d-02,-2.9352705341890d-03,-5.2782750895573d-02,
     |  -5.6650527153166d-02,-3.1647725651614d-02,-9.7674002403109d-03,
     |  -1.3925763212886d-03,-5.0194485388893d-05,-1.9250373846945d-07/
      data (zmn(lat, 7,15), lat = 1,36)/
     |  -1.4485389387162d-07, 6.8952182766885d-06, 3.2359987224582d-04,
     |   3.3901793654901d-03, 1.5648628559960d-02, 4.0691211550024d-02,
     |   6.4035554018558d-02, 5.4646996681856d-02, 6.4785657601278d-04,
     |  -5.7761081974165d-02,-5.7698242534891d-02, 8.6440142009688d-03,
     |   6.7675930299052d-02, 4.5361077461022d-02,-3.4811633617296d-02,
     |  -7.2431712970015d-02,-1.7452074297985d-02, 6.0622461086949d-02,
     |   6.0622461086949d-02,-1.7452074297985d-02,-7.2431712970015d-02,
     |  -3.4811633617296d-02, 4.5361077461022d-02, 6.7675930299052d-02,
     |   8.6440142009690d-03,-5.7698242534891d-02,-5.7761081974165d-02,
     |   6.4785657601256d-04, 5.4646996681856d-02, 6.4035554018558d-02,
     |   4.0691211550024d-02, 1.5648628559960d-02, 3.3901793654901d-03,
     |   3.2359987224600d-04, 6.8952182767334d-06,-1.4485389382181d-07/
      data (zmn(lat, 8,15), lat = 1,36)/
     |  -5.1716303549728d-09, 7.7691509125904d-07, 6.2656374890149d-05,
     |   9.6465589456111d-04, 6.1623704518382d-03, 2.1909214771934d-02,
     |   4.8987917470357d-02, 7.0457829716442d-02, 5.7103865092264d-02,
     |   5.7676303285300d-04,-5.9641656882674d-02,-6.3586155442747d-02,
     |   3.8210054660838d-05, 6.5907401106256d-02, 5.7797845162926d-02,
     |  -1.8467403400506d-02,-7.3935603354385d-02,-4.1187297833081d-02,
     |   4.1187297833081d-02, 7.3935603354385d-02, 1.8467403400507d-02,
     |  -5.7797845162925d-02,-6.5907401106256d-02,-3.8210054660581d-05,
     |   6.3586155442747d-02, 5.9641656882674d-02,-5.7676303285289d-04,
     |  -5.7103865092264d-02,-7.0457829716442d-02,-4.8987917470357d-02,
     |  -2.1909214771934d-02,-6.1623704518382d-03,-9.6465589456103d-04,
     |  -6.2656374890131d-05,-7.7691509107135d-07, 5.1716303488080d-09/
      data (zmn(lat, 9,15), lat = 1,36)/
     |   5.3772313550425d-09, 6.8572770010600d-08, 1.0220441029809d-05,
     |   2.2878030156325d-04, 1.9880542197468d-03, 9.3687525273713d-03,
     |   2.7906495639961d-02, 5.6158007867935d-02, 7.6248921731114d-02,
     |   6.1101467275895d-02, 3.8901875604070d-03,-5.9051482469753d-02,
     |  -7.0800759572472d-02,-1.3772481370978d-02, 5.8927324646003d-02,
     |   7.0748514993690d-02, 6.2485561335628d-03,-6.5663442707926d-02,
     |  -6.5663442707926d-02, 6.2485561335626d-03, 7.0748514993690d-02,
     |   5.8927324646003d-02,-1.3772481370977d-02,-7.0800759572472d-02,
     |  -5.9051482469753d-02, 3.8901875604071d-03, 6.1101467275895d-02,
     |   7.6248921731114d-02, 5.6158007867935d-02, 2.7906495639961d-02,
     |   9.3687525273713d-03, 1.9880542197468d-03, 2.2878030156325d-04,
     |   1.0220441029691d-05, 6.8572770009486d-08, 5.3772313830527d-09/
      data (zmn(lat,10,15), lat = 1,36)/
     |   1.3995541394248d-10, 5.5688466706098d-09, 1.4081607675283d-06,
     |   4.5538716036268d-05, 5.3226303143012d-04, 3.2638672480751d-03,
     |   1.2535138068598d-02, 3.2996263726831d-02, 6.1861773986984d-02,
     |   8.1676574561902d-02, 6.7505890104719d-02, 1.2003472090135d-02,
     |  -5.4208280697706d-02,-7.8134062223085d-02,-3.3861006912603d-02,
     |   4.2595584331519d-02, 7.9455105642675d-02, 3.9375040854362d-02,
     |  -3.9375040854362d-02,-7.9455105642675d-02,-4.2595584331519d-02,
     |   3.3861006912603d-02, 7.8134062223085d-02, 5.4208280697706d-02,
     |  -1.2003472090135d-02,-6.7505890104719d-02,-8.1676574561902d-02,
     |  -6.1861773986984d-02,-3.2996263726830d-02,-1.2535138068598d-02,
     |  -3.2638672480750d-03,-5.3226303143014d-04,-4.5538716036295d-05,
     |  -1.4081607676090d-06,-5.5688468316890d-09,-1.3995540353465d-10/
      data (zmn(lat,11,15), lat = 1,36)/
     |  -1.5323945219971d-10, 5.3941890346792d-10, 1.6328431422044d-07,
     |   7.5981370653148d-06, 1.1852040115813d-04, 9.3435594561274d-04,
     |   4.5379976970694d-03, 1.5106363189867d-02, 3.6516384172640d-02,
     |   6.5649436558323d-02, 8.6682885116413d-02, 7.6845289386409d-02,
     |   2.6552736459663d-02,-4.1976523553477d-02,-8.2025630026555d-02,
     |  -5.9431603250256d-02, 1.1636840119160d-02, 7.3549443068098d-02,
     |   7.3549443068098d-02, 1.1636840119160d-02,-5.9431603250255d-02,
     |  -8.2025630026555d-02,-4.1976523553477d-02, 2.6552736459664d-02,
     |   7.6845289386409d-02, 8.6682885116413d-02, 6.5649436558323d-02,
     |   3.6516384172640d-02, 1.5106363189867d-02, 4.5379976970693d-03,
     |   9.3435594561265d-04, 1.1852040115818d-04, 7.5981370652851d-06,
     |   1.6328431423579d-07, 5.3941889262638d-10,-1.5323949981713d-10/
      data (zmn(lat,12,15), lat = 1,36)/
     |  -2.8487514002316d-12, 3.0672475095654d-11, 1.5779809366807d-08,
     |   1.0515461056204d-06, 2.1767550072250d-05, 2.1877378501211d-04,
     |   1.3267982983709d-03, 5.4750714683467d-03, 1.6491178191548d-02,
     |   3.7738454174213d-02, 6.6744097905733d-02, 9.0467710397961d-02,
     |   8.8735277297853d-02, 4.8915614205392d-02,-1.7599745129297d-02,
     |  -7.4625323535531d-02,-8.3929713243314d-02,-3.6401675253619d-02,
     |   3.6401675253619d-02, 8.3929713243314d-02, 7.4625323535532d-02,
     |   1.7599745129297d-02,-4.8915614205392d-02,-8.8735277297853d-02,
     |  -9.0467710397961d-02,-6.6744097905733d-02,-3.7738454174213d-02,
     |  -1.6491178191548d-02,-5.4750714683468d-03,-1.3267982983710d-03,
     |  -2.1877378501208d-04,-2.1767550072223d-05,-1.0515461055874d-06,
     |  -1.5779809215078d-08,-3.0672421665766d-11, 2.8488183826467d-12/
      data (zmn(lat,13,15), lat = 1,36)/
     |   2.9102801380321d-12,-1.5551023820974d-12, 1.2410614938005d-09,
     |   1.1780703002018d-07, 3.2226648526340d-06, 4.1040338959408d-05,
     |   3.0806825647208d-04, 1.5554699922475d-03, 5.7214237352869d-03,
     |   1.6114646068616d-02, 3.5822013373918d-02, 6.3787624500693d-02,
     |   9.0852808731108d-02, 1.0065399352925d-01, 7.8477162242235d-02,
     |   2.4066648419052d-02,-4.2129466979377d-02,-8.7559076178262d-02,
     |  -8.7559076178262d-02,-4.2129466979377d-02, 2.4066648419052d-02,
     |   7.8477162242235d-02, 1.0065399352925d-01, 9.0852808731108d-02,
     |   6.3787624500694d-02, 3.5822013373918d-02, 1.6114646068616d-02,
     |   5.7214237352869d-03, 1.5554699922475d-03, 3.0806825647210d-04,
     |   4.1040338959482d-05, 3.2226648525932d-06, 1.1780703005176d-07,
     |   1.2410614875657d-09,-1.5551391958700d-12, 2.9103888247393d-12/
      data (zmn(lat,14,15), lat = 1,36)/
     |   3.4078206986614d-14,-5.5330226074664d-14, 7.4965342407599d-11,
     |   1.0138979291323d-08, 3.6531271720374d-07, 5.8676911764898d-06,
     |   5.4166577152228d-05, 3.3161022371394d-04, 1.4700611981542d-03,
     |   4.9957529158865d-03, 1.3517652777655d-02, 2.9861302094267d-02,
     |   5.4675630382835d-02, 8.3468803707959d-02, 1.0565466259550d-01,
     |   1.0802239134814d-01, 8.2069256912583d-02, 3.0756057709046d-02,
     |  -3.0756057709046d-02,-8.2069256912583d-02,-1.0802239134814d-01,
     |  -1.0565466259550d-01,-8.3468803707959d-02,-5.4675630382835d-02,
     |  -2.9861302094267d-02,-1.3517652777655d-02,-4.9957529158865d-03,
     |  -1.4700611981542d-03,-3.3161022371393d-04,-5.4166577152178d-05,
     |  -5.8676911764703d-06,-3.6531271718169d-07,-1.0138979258141d-08,
     |  -7.4965390192187d-11, 5.5354773336156d-14,-3.4149685410233d-14/
      data (zmn(lat,15,15), lat = 1,36)/
     |  -2.3649094708255d-14, 2.2719272541628d-14, 3.0097596950995d-12,
     |   5.8367958009479d-10, 2.7626640165515d-08, 5.5767775026377d-07,
     |   6.3002545367619d-06, 4.6456635905070d-05, 2.4593891285766d-04,
     |   9.9537759616382d-04, 3.2163269230913d-03, 8.5577733780154d-03,
     |   1.9175932651821d-02, 3.6790801325588d-02, 6.1179473830552d-02,
     |   8.8960644867357d-02, 1.1381271177884d-01, 1.2861064882440d-01,
     |   1.2861064882440d-01, 1.1381271177884d-01, 8.8960644867357d-02,
     |   6.1179473830552d-02, 3.6790801325588d-02, 1.9175932651821d-02,
     |   8.5577733780155d-03, 3.2163269230913d-03, 9.9537759616383d-04,
     |   2.4593891285769d-04, 4.6456635905075d-05, 6.3002545367638d-06,
     |   5.5767775027039d-07, 2.7626640208337d-08, 5.8367958707713d-10,
     |   3.0097701522296d-12, 2.2752387537693d-14,-2.3729538702040d-14/
      data (zmn(lat, 0,16), lat = 1,36)/
     |   1.1258197179894d-02, 7.5584683063438d-03,-3.1150710683133d-02,
     |  -1.6923959731908d-02, 3.4756057724335d-02, 3.2130759080146d-02,
     |  -3.3548026986848d-02,-4.5121533257507d-02, 2.4611200886278d-02,
     |   5.6944990613632d-02,-1.1929919251581d-02,-6.3650243496569d-02,
     |  -4.6726709141669d-03, 6.5682979321573d-02, 2.1927695883650d-02,
     |  -6.1583011089977d-02,-3.8598464477163d-02, 5.2308190097372d-02,
     |   5.2308190097372d-02,-3.8598464477163d-02,-6.1583011089977d-02,
     |   2.1927695883650d-02, 6.5682979321573d-02,-4.6726709141672d-03,
     |  -6.3650243496569d-02,-1.1929919251581d-02, 5.6944990613632d-02,
     |   2.4611200886278d-02,-4.5121533257507d-02,-3.3548026986848d-02,
     |   3.2130759080146d-02, 3.4756057724335d-02,-1.6923959731908d-02,
     |  -3.1150710683133d-02, 7.5584683063439d-03, 1.1258197179894d-02/
      data (zmn(lat, 1,16), lat = 1,36)/
     |   6.2806874374961d-03, 2.5544583318782d-02, 7.7096641984997d-03,
     |  -3.5836595524488d-02,-2.1866465821929d-02, 3.6844125550585d-02,
     |   3.7394471112281d-02,-3.1704274675580d-02,-5.0624247255055d-02,
     |   2.0280222064327d-02, 6.0805499790588d-02,-5.2391085384483d-03,
     |  -6.5411260707110d-02,-1.2576625748683d-02, 6.4719902617285d-02,
     |   3.0013408296980d-02,-5.7675351074141d-02,-4.5992834445560d-02,
     |   4.5992834445560d-02, 5.7675351074141d-02,-3.0013408296980d-02,
     |  -6.4719902617285d-02, 1.2576625748683d-02, 6.5411260707110d-02,
     |   5.2391085384487d-03,-6.0805499790588d-02,-2.0280222064327d-02,
     |   5.0624247255055d-02, 3.1704274675580d-02,-3.7394471112280d-02,
     |  -3.6844125550585d-02, 2.1866465821929d-02, 3.5836595524488d-02,
     |  -7.7096641984995d-03,-2.5544583318781d-02,-6.2806874374961d-03/
      data (zmn(lat, 2,16), lat = 1,36)/
     |   1.1100948835094d-03, 1.7721275487147d-02, 3.4494446420734d-02,
     |   3.8584729694399d-03,-4.1847461603524d-02,-2.3207178603761d-02,
     |   4.0467026447590d-02, 4.0549437676788d-02,-3.1669556703346d-02,
     |  -5.4689604410421d-02, 1.7482185233617d-02, 6.3621133209950d-02,
     |   4.2950075640816d-04,-6.6467652455261d-02,-1.9595203240153d-02,
     |   6.2669908180085d-02, 3.7787644683980d-02,-5.2736263341762d-02,
     |  -5.2736263341762d-02, 3.7787644683980d-02, 6.2669908180085d-02,
     |  -1.9595203240152d-02,-6.6467652455261d-02, 4.2950075640840d-04,
     |   6.3621133209950d-02, 1.7482185233617d-02,-5.4689604410421d-02,
     |  -3.1669556703346d-02, 4.0549437676788d-02, 4.0467026447590d-02,
     |  -2.3207178603761d-02,-4.1847461603524d-02, 3.8584729694397d-03,
     |   3.4494446420734d-02, 1.7721275487147d-02, 1.1100948835094d-03/
      data (zmn(lat, 3,16), lat = 1,36)/
     |   1.9708656636049d-05, 7.1653435822957d-03, 3.0504731446446d-02,
     |   3.8994628949258d-02,-2.6358791321749d-03,-4.8165486622145d-02,
     |  -2.1984085100908d-02, 4.4790586844716d-02, 4.2638843471606d-02,
     |  -3.2834559714048d-02,-5.7859252657071d-02, 1.5107116474634d-02,
     |   6.6067804243497d-02, 5.8067719169121d-03,-6.6608247483024d-02,
     |  -2.6942479227052d-02, 5.9439219173096d-02, 4.5660920413534d-02,
     |  -4.5660920413534d-02,-5.9439219173096d-02, 2.6942479227052d-02,
     |   6.6608247483024d-02,-5.8067719169120d-03,-6.6067804243497d-02,
     |  -1.5107116474635d-02, 5.7859252657071d-02, 3.2834559714048d-02,
     |  -4.2638843471606d-02,-4.4790586844717d-02, 2.1984085100907d-02,
     |   4.8165486622145d-02, 2.6358791321750d-03,-3.8994628949258d-02,
     |  -3.0504731446447d-02,-7.1653435822957d-03,-1.9708656636056d-05/
      data (zmn(lat, 4,16), lat = 1,36)/
     |   3.5207438070109d-06, 2.0097919664797d-03, 1.6499332624952d-02,
     |   4.1984596125429d-02, 4.0060669931005d-02,-1.1035910847067d-02,
     |  -5.3706218319227d-02,-1.9348627343926d-02, 4.9393357115788d-02,
     |   4.4083074062967d-02,-3.4170942001590d-02,-6.0796453253039d-02,
     |   1.2385030713028d-02, 6.8107881592454d-02, 1.2018459142884d-02,
     |  -6.5620754550700d-02,-3.5303825194043d-02, 5.4081287634455d-02,
     |   5.4081287634455d-02,-3.5303825194043d-02,-6.5620754550701d-02,
     |   1.2018459142884d-02, 6.8107881592454d-02, 1.2385030713028d-02,
     |  -6.0796453253038d-02,-3.4170942001590d-02, 4.4083074062967d-02,
     |   4.9393357115789d-02,-1.9348627343926d-02,-5.3706218319227d-02,
     |  -1.1035910847067d-02, 4.0060669931005d-02, 4.1984596125429d-02,
     |   1.6499332624952d-02, 2.0097919664796d-03, 3.5207438070423d-06/
      data (zmn(lat, 5,16), lat = 1,36)/
     |   6.8160122286751d-06, 4.2889544253143d-04, 6.5070560173585d-03,
     |   2.7510435766061d-02, 5.1403373834131d-02, 3.8254159030394d-02,
     |  -2.0167642684162d-02,-5.8189670078694d-02,-1.6159409997848d-02,
     |   5.3722486841232d-02, 4.5542893122047d-02,-3.4850133563485d-02,
     |  -6.3873005926046d-02, 8.3326926655788d-03, 6.9553138905678d-02,
     |   2.0049211673133d-02,-6.2731419838650d-02,-4.5176278332015d-02,
     |   4.5176278332015d-02, 6.2731419838650d-02,-2.0049211673133d-02,
     |  -6.9553138905678d-02,-8.3326926655789d-03, 6.3873005926046d-02,
     |   3.4850133563485d-02,-4.5542893122047d-02,-5.3722486841232d-02,
     |   1.6159409997848d-02, 5.8189670078694d-02, 2.0167642684162d-02,
     |  -3.8254159030395d-02,-5.1403373834131d-02,-2.7510435766061d-02,
     |  -6.5070560173586d-03,-4.2889544253144d-04,-6.8160122286520d-06/
      data (zmn(lat, 6,16), lat = 1,36)/
     |   3.0050000048944d-07, 7.5276453781198d-05, 2.0120415453599d-03,
     |   1.3257772535954d-02, 3.8883521209265d-02, 5.8508012076537d-02,
     |   3.4448208965679d-02,-2.8998270776992d-02,-6.1744290873020d-02,
     |  -1.3336109581012d-02, 5.7330901673714d-02, 4.7770570582574d-02,
     |  -3.4014548630144d-02,-6.7280363079628d-02, 1.8315623412427d-03,
     |   6.9820992573878d-02, 3.0716380735005d-02,-5.6455106791432d-02,
     |  -5.6455106791432d-02, 3.0716380735005d-02, 6.9820992573878d-02,
     |   1.8315623412428d-03,-6.7280363079628d-02,-3.4014548630143d-02,
     |   4.7770570582574d-02, 5.7330901673714d-02,-1.3336109581012d-02,
     |  -6.1744290873020d-02,-2.8998270776992d-02, 3.4448208965678d-02,
     |   5.8508012076537d-02, 3.8883521209265d-02, 1.3257772535954d-02,
     |   2.0120415453599d-03, 7.5276453781312d-05, 3.0050000043353d-07/
      data (zmn(lat, 7,16), lat = 1,36)/
     |  -3.3399901351901d-07, 1.1272372332225d-05, 5.0779782151965d-04,
     |   5.0507930122312d-03, 2.1551655221062d-02, 4.9690959565711d-02,
     |   6.3473780899549d-02, 2.9784549886007d-02,-3.6739693132771d-02,
     |  -6.4776723752650d-02,-1.1906050452073d-02, 5.9826974342926d-02,
     |   5.1508621391855d-02,-3.0599600544648d-02,-7.0886346158601d-02,
     |  -8.3189825441052d-03, 6.7548050494671d-02, 4.4388239748394d-02,
     |  -4.4388239748393d-02,-6.7548050494671d-02, 8.3189825441048d-03,
     |   7.0886346158601d-02, 3.0599600544648d-02,-5.1508621391855d-02,
     |  -5.9826974342926d-02, 1.1906050452073d-02, 6.4776723752650d-02,
     |   3.6739693132771d-02,-2.9784549886007d-02,-6.3473780899549d-02,
     |  -4.9690959565711d-02,-2.1551655221062d-02,-5.0507930122313d-03,
     |  -5.0779782151961d-04,-1.1272372332325d-05, 3.3399901341508d-07/
      data (zmn(lat, 8,16), lat = 1,36)/
     |  -9.4595364414748d-09, 1.3678701013371d-06, 1.0718100436886d-04,
     |   1.5777058887665d-03, 9.4399343925310d-03, 3.0553910593384d-02,
     |   5.9362634410561d-02, 6.6898146457064d-02, 2.5521172080644d-02,
     |  -4.2780976881828d-02,-6.7862032186454d-02,-1.2988002198914d-02,
     |   6.0641907423790d-02, 5.7352654647481d-02,-2.3180391707920d-02,
     |  -7.3805078461743d-02,-2.3224984213416d-02, 6.0102063406107d-02,
     |   6.0102063406107d-02,-2.3224984213416d-02,-7.3805078461743d-02,
     |  -2.3180391707920d-02, 5.7352654647481d-02, 6.0641907423790d-02,
     |  -1.2988002198914d-02,-6.7862032186454d-02,-4.2780976881828d-02,
     |   2.5521172080644d-02, 6.6898146457064d-02, 5.9362634410561d-02,
     |   3.0553910593384d-02, 9.4399343925308d-03, 1.5777058887665d-03,
     |   1.0718100436885d-04, 1.3678701013074d-06,-9.4595364378016d-09/
      data (zmn(lat, 9,16), lat = 1,36)/
     |   1.5707479643567d-08, 1.2662856283166d-07, 1.9169867954866d-05,
     |   4.1235121214729d-04, 3.3867382538658d-03, 1.4763859546296d-02,
     |   3.9457920651720d-02, 6.7683788266216d-02, 6.9691266426315d-02,
     |   2.2966549522269d-02,-4.6540115787948d-02,-7.1535197085864d-02,
     |  -1.7814098462285d-02, 5.8677249777096d-02, 6.5398259537246d-02,
     |  -9.8662805033359d-03,-7.3657389777381d-02,-4.3160680946420d-02,
     |   4.3160680946420d-02, 7.3657389777381d-02, 9.8662805033363d-03,
     |  -6.5398259537246d-02,-5.8677249777096d-02, 1.7814098462285d-02,
     |   7.1535197085864d-02, 4.6540115787948d-02,-2.2966549522269d-02,
     |  -6.9691266426315d-02,-6.7683788266216d-02,-3.9457920651720d-02,
     |  -1.4763859546296d-02,-3.3867382538657d-03,-4.1235121214736d-04,
     |  -1.9169867954976d-05,-1.2662856276842d-07,-1.5707479697532d-08/
      data (zmn(lat,10,16), lat = 1,36)/
     |   3.0660127503996d-10, 1.1791946261597d-08, 2.9194244951332d-06,
     |   9.1127806338416d-05, 1.0134391003560d-03, 5.8116164391215d-03,
     |   2.0409754493031d-02, 4.7562103720269d-02, 7.4722370865941d-02,
     |   7.2925888002503d-02, 2.3490715499031d-02,-4.7190508648559d-02,
     |  -7.5943069317102d-02,-2.7693109536067d-02, 5.1811845395542d-02,
     |   7.4450344723922d-02, 1.1407946376290d-02,-6.5518387241711d-02,
     |  -6.5518387241711d-02, 1.1407946376289d-02, 7.4450344723922d-02,
     |   5.1811845395542d-02,-2.7693109536067d-02,-7.5943069317102d-02,
     |  -4.7190508648559d-02, 2.3490715499031d-02, 7.2925888002503d-02,
     |   7.4722370865941d-02, 4.7562103720269d-02, 2.0409754493031d-02,
     |   5.8116164391215d-03, 1.0134391003561d-03, 9.1127806338405d-05,
     |   2.9194244950034d-06, 1.1791946062936d-08, 3.0660135306061d-10/
      data (zmn(lat,11,16), lat = 1,36)/
     |  -5.9121911671169d-10, 1.5028203617882d-09, 3.7883121769185d-07,
     |   1.7082412719397d-05, 2.5484406287747d-04, 1.8938525517033d-03,
     |   8.5184020072199d-03, 2.5658431658047d-02, 5.4267825157837d-02,
     |   8.0661205353933d-02, 7.7653032978506d-02, 2.8581972114870d-02,
     |  -4.3239092619965d-02,-8.0218645884962d-02,-4.3647851380688d-02,
     |   3.6393074688323d-02, 8.0431846355897d-02, 4.1252410404229d-02,
     |  -4.1252410404229d-02,-8.0431846355897d-02,-3.6393074688323d-02,
     |   4.3647851380688d-02, 8.0218645884962d-02, 4.3239092619965d-02,
     |  -2.8581972114869d-02,-7.7653032978506d-02,-8.0661205353933d-02,
     |  -5.4267825157837d-02,-2.5658431658047d-02,-8.5184020072199d-03,
     |  -1.8938525517033d-03,-2.5484406287745d-04,-1.7082412719311d-05,
     |  -3.7883121759987d-07,-1.5028204323966d-09, 5.9121930539295d-10/
      data (zmn(lat,12,16), lat = 1,36)/
     |  -7.8820449190986d-12, 8.3193908469832d-11, 4.1814092177744d-08,
     |   2.7059653759760d-06, 5.3795231503176d-05, 5.1279104526607d-04,
     |   2.9067337170850d-03, 1.1011096874366d-02, 2.9736258730302d-02,
     |   5.8981393824619d-02, 8.5520137069802d-02, 8.4619298748654d-02,
     |   3.9840811771244d-02,-3.1991842850291d-02,-8.1322741078467d-02,
     |  -6.5085234403462d-02, 7.4170505366107d-03, 7.3827397434665d-02,
     |   7.3827397434665d-02, 7.4170505366109d-03,-6.5085234403462d-02,
     |  -8.1322741078467d-02,-3.1991842850291d-02, 3.9840811771244d-02,
     |   8.4619298748654d-02, 8.5520137069802d-02, 5.8981393824619d-02,
     |   2.9736258730302d-02, 1.1011096874366d-02, 2.9067337170851d-03,
     |   5.1279104526604d-04, 5.3795231503114d-05, 2.7059653759760d-06,
     |   4.1814092276493d-08, 8.3194138296667d-11,-7.8820303007579d-12/
      data (zmn(lat,13,16), lat = 1,36)/
     |   1.6119721003643d-11,-1.1733701189989d-11, 3.8798996449171d-09,
     |   3.5784173015942d-07, 9.4331517887217d-06, 1.1449373738208d-04,
     |   8.0895365675463d-04, 3.7885493073787d-03, 1.2694950149768d-02,
     |   3.1820707311439d-02, 6.0919467142792d-02, 8.8726725299006d-02,
     |   9.3717407920270d-02, 5.8598475509488d-02,-9.1858602533990d-03,
     |  -7.2133896563121d-02,-8.6185578208981d-02,-3.8136634976554d-02,
     |   3.8136634976554d-02, 8.6185578208981d-02, 7.2133896563121d-02,
     |   9.1858602533990d-03,-5.8598475509488d-02,-9.3717407920270d-02,
     |  -8.8726725299006d-02,-6.0919467142792d-02,-3.1820707311439d-02,
     |  -1.2694950149768d-02,-3.7885493073787d-03,-8.0895365675465d-04,
     |  -1.1449373738207d-04,-9.4331517887940d-06,-3.5784173028224d-07,
     |  -3.8798997652277d-09, 1.1733641849072d-11,-1.6119793984651d-11/
      data (zmn(lat,14,16), lat = 1,36)/
     |   1.3775281167044d-13,-2.2056308076343d-13, 2.9198346563308d-10,
     |   3.8511806012429d-08, 1.3409450776077d-06, 2.0609958449804d-05,
     |   1.8008055824964d-04, 1.0306422590142d-03, 4.2097793959881d-03,
     |   1.2951309077260d-02, 3.1021297350984d-02, 5.8847496405058d-02,
     |   8.8474455797317d-02, 1.0284170283132d-01, 8.4387400108377d-02,
     |   3.0063271038008d-02,-3.9517328088195d-02,-8.8379074886502d-02,
     |  -8.8379074886502d-02,-3.9517328088195d-02, 3.0063271038008d-02,
     |   8.4387400108377d-02, 1.0284170283132d-01, 8.8474455797317d-02,
     |   5.8847496405058d-02, 3.1021297350984d-02, 1.2951309077260d-02,
     |   4.2097793959881d-03, 1.0306422590142d-03, 1.8008055824961d-04,
     |   2.0609958449816d-05, 1.3409450776276d-06, 3.8511806030253d-08,
     |   2.9198345214578d-10,-2.2057305914054d-13, 1.3775328652463d-13/
      data (zmn(lat,15,16), lat = 1,36)/
     |  -2.5119723556573d-13, 2.4510807373375d-13, 1.6764605692275d-11,
     |   3.1979133427307d-09, 1.4662230589474d-07, 2.8416411247255d-06,
     |   3.0524197568472d-05, 2.1172462997477d-04, 1.0416338942186d-03,
     |   3.8630308592825d-03, 1.1247714493229d-02, 2.6414006203754d-02,
     |   5.0865001948902d-02, 8.0879019501166d-02, 1.0568284878634d-01,
     |   1.1060929976961d-01, 8.5338579573307d-02, 3.2226523729310d-02,
     |  -3.2226523729310d-02,-8.5338579573307d-02,-1.1060929976961d-01,
     |  -1.0568284878634d-01,-8.0879019501166d-02,-5.0865001948902d-02,
     |  -2.6414006203754d-02,-1.1247714493229d-02,-3.8630308592825d-03,
     |  -1.0416338942186d-03,-2.1172462997481d-04,-3.0524197568465d-05,
     |  -2.8416411247485d-06,-1.4662230591235d-07,-3.1979133629203d-09,
     |  -1.6764591876844d-11,-2.4507589847829d-13, 2.5113990961811d-13/
      data (zmn(lat,16,16), lat = 1,36)/
     |  -1.2058064305563d-15, 2.8673947812562d-15, 6.6143380048188d-13,
     |   1.7823710014609d-10, 1.0736178188255d-08, 2.6149952138466d-07,
     |   3.4376099722466d-06, 2.8719499450707d-05, 1.6873010461200d-04,
     |   7.4524784103820d-04, 2.5912470549361d-03, 7.3294595800242d-03,
     |   1.7272985182742d-02, 3.4517280661491d-02, 5.9252573802859d-02,
     |   8.8198544111182d-02, 1.1458857488278d-01, 1.3048042452228d-01,
     |   1.3048042452228d-01, 1.1458857488278d-01, 8.8198544111182d-02,
     |   5.9252573802859d-02, 3.4517280661491d-02, 1.7272985182742d-02,
     |   7.3294595800242d-03, 2.5912470549361d-03, 7.4524784103821d-04,
     |   1.6873010461202d-04, 2.8719499450723d-05, 3.4376099722448d-06,
     |   2.6149952139361d-07, 1.0736178200025d-08, 1.7823710092122d-10,
     |   6.6141407546899d-13, 2.8522037028467d-15,-1.2181164731261d-15/
      data (zmn(lat, 0,17), lat = 1,36)/
     |   1.1303390434741d-02, 4.4048243051431d-03,-3.3018274689200d-02,
     |  -5.8132103205913d-03, 4.1375259360575d-02, 1.2419304038791d-02,
     |  -4.9289339112168d-02,-1.7496535567952d-02, 5.2761842786139d-02,
     |   2.4786035051695d-02,-5.5789227946449d-02,-3.0685878678887d-02,
     |   5.5620757134795d-02, 3.7626423575146d-02,-5.5014232896105d-02,
     |  -4.2864147301137d-02, 5.1801589704353d-02, 4.8399762212529d-02,
     |  -4.8399762212529d-02,-5.1801589704353d-02, 4.2864147301137d-02,
     |   5.5014232896106d-02,-3.7626423575146d-02,-5.5620757134795d-02,
     |   3.0685878678887d-02, 5.5789227946449d-02,-2.4786035051695d-02,
     |  -5.2761842786139d-02, 1.7496535567951d-02, 4.9289339112168d-02,
     |  -1.2419304038791d-02,-4.1375259360575d-02, 5.8132103205913d-03,
     |   3.3018274689201d-02,-4.4048243051431d-03,-1.1303390434741d-02/
      data (zmn(lat, 1,17), lat = 1,36)/
     |   6.7218739468367d-03, 2.5441103437253d-02, 6.9516305538389d-04,
     |  -3.8410456916543d-02,-6.1760064072791d-03, 4.6458418922474d-02,
     |   1.2698176633540d-02,-5.2023096219452d-02,-1.9497328072306d-02,
     |   5.5229545443552d-02, 2.6552475528971d-02,-5.6534624173614d-02,
     |  -3.3410871503075d-02, 5.6008301473729d-02, 3.9868378190063d-02,
     |  -5.3896274883376d-02,-4.5591948680451d-02, 5.0348436114212d-02,
     |   5.0348436114213d-02,-4.5591948680450d-02,-5.3896274883376d-02,
     |   3.9868378190063d-02, 5.6008301473729d-02,-3.3410871503076d-02,
     |  -5.6534624173614d-02, 2.6552475528971d-02, 5.5229545443552d-02,
     |  -1.9497328072306d-02,-5.2023096219452d-02, 1.2698176633540d-02,
     |   4.6458418922475d-02,-6.1760064072789d-03,-3.8410456916543d-02,
     |   6.9516305538378d-04, 2.5441103437253d-02, 6.7218739468368d-03/
      data (zmn(lat, 2,17), lat = 1,36)/
     |   1.2860813222796d-03, 1.9429425154776d-02, 3.2472008521102d-02,
     |  -7.4115589855350d-03,-4.3795177591998d-02,-1.7474123787222d-03,
     |   5.1328958758166d-02, 1.0137708804459d-02,-5.5700805635344d-02,
     |  -1.8764445257700d-02, 5.8032810440582d-02, 2.6915596935938d-02,
     |  -5.8046009002334d-02,-3.4851195121120d-02, 5.6406625310464d-02,
     |   4.1859212155955d-02,-5.2881668877561d-02,-4.8086790352655d-02,
     |   4.8086790352655d-02, 5.2881668877561d-02,-4.1859212155955d-02,
     |  -5.6406625310464d-02, 3.4851195121120d-02, 5.8046009002334d-02,
     |  -2.6915596935937d-02,-5.8032810440582d-02, 1.8764445257700d-02,
     |   5.5700805635344d-02,-1.0137708804458d-02,-5.1328958758166d-02,
     |   1.7474123787221d-03, 4.3795177591998d-02, 7.4115589855350d-03,
     |  -3.2472008521102d-02,-1.9429425154776d-02,-1.2860813222797d-03/
      data (zmn(lat, 3,17), lat = 1,36)/
     |   3.6058026830270d-05, 8.4722542714828d-03, 3.3126423043157d-02,
     |   3.3237093851885d-02,-1.8200464688624d-02,-4.7542323864430d-02,
     |   5.8243689915124d-03, 5.5419884321745d-02, 5.5887783254931d-03,
     |  -5.9567410450492d-02,-1.6445110173701d-02, 6.0870232857328d-02,
     |   2.6654592876957d-02,-5.9714267659470d-02,-3.6026031164101d-02,
     |   5.6397509472626d-02, 4.4287082645578d-02,-5.1167843027976d-02,
     |  -5.1167843027976d-02, 4.4287082645577d-02, 5.6397509472627d-02,
     |  -3.6026031164100d-02,-5.9714267659470d-02, 2.6654592876957d-02,
     |   6.0870232857328d-02,-1.6445110173701d-02,-5.9567410450492d-02,
     |   5.5887783254928d-03, 5.5419884321745d-02, 5.8243689915125d-03,
     |  -4.7542323864430d-02,-1.8200464688624d-02, 3.3237093851885d-02,
     |   3.3126423043157d-02, 8.4722542714828d-03, 3.6058026830109d-05/
      data (zmn(lat, 4,17), lat = 1,36)/
     |   4.1409651296818d-06, 2.5532763564917d-03, 1.9690109933122d-02,
     |   4.4227099930562d-02, 2.8979691397442d-02,-3.0288789015039d-02,
     |  -4.8568552463899d-02, 1.4960036343900d-02, 5.8466031705015d-02,
     |  -2.0529342291190d-04,-6.2981876660317d-02,-1.3671628097715d-02,
     |   6.3540616511860d-02, 2.6501877771984d-02,-6.0907715860300d-02,
     |  -3.7954358434190d-02, 5.5503428472715d-02, 4.7748959064565d-02,
     |  -4.7748959064565d-02,-5.5503428472716d-02, 3.7954358434190d-02,
     |   6.0907715860300d-02,-2.6501877771984d-02,-6.3540616511860d-02,
     |   1.3671628097714d-02, 6.2981876660317d-02, 2.0529342291207d-04,
     |  -5.8466031705015d-02,-1.4960036343901d-02, 4.8568552463899d-02,
     |   3.0288789015039d-02,-2.8979691397442d-02,-4.4227099930562d-02,
     |  -1.9690109933122d-02,-2.5532763564916d-03,-4.1409651295501d-06/
      data (zmn(lat, 5,17), lat = 1,36)/
     |   8.3069450338998d-06, 5.8442807288976d-04, 8.4280309441293d-03,
     |   3.2656177828827d-02, 5.1549329939153d-02, 2.0678624006068d-02,
     |  -4.1969341935908d-02,-4.6966919212609d-02, 2.4516298771522d-02,
     |   6.0305786603077d-02,-6.1878860689886d-03,-6.5835857587737d-02,
     |  -1.1377669604193d-02, 6.5736547967159d-02, 2.7441905027631d-02,
     |  -6.1161219566832d-02,-4.1445556689968d-02, 5.2864739262425d-02,
     |   5.2864739262425d-02,-4.1445556689968d-02,-6.1161219566832d-02,
     |   2.7441905027631d-02, 6.5736547967159d-02,-1.1377669604193d-02,
     |  -6.5835857587737d-02,-6.1878860689884d-03, 6.0305786603077d-02,
     |   2.4516298771522d-02,-4.6966919212608d-02,-4.1969341935908d-02,
     |   2.0678624006068d-02, 5.1549329939153d-02, 3.2656177828827d-02,
     |   8.4280309441294d-03, 5.8442807288970d-04, 8.3069450340478d-06/
      data (zmn(lat, 6,17), lat = 1,36)/
     |   4.7619947963889d-07, 1.0965138766719d-04, 2.8174026278949d-03,
     |   1.7337861651674d-02, 4.5398220456208d-02, 5.4753589142869d-02,
     |   9.7773726432929d-03,-5.2063946286052d-02,-4.3418341918477d-02,
     |   3.3478132058584d-02, 6.1248622593717d-02,-1.1323378330823d-02,
     |  -6.8252004468714d-02,-1.0582613251106d-02, 6.7204408141704d-02,
     |   3.0479098071087d-02,-5.9789184584562d-02,-4.7212156985966d-02,
     |   4.7212156985966d-02, 5.9789184584562d-02,-3.0479098071087d-02,
     |  -6.7204408141704d-02, 1.0582613251106d-02, 6.8252004468714d-02,
     |   1.1323378330823d-02,-6.1248622593717d-02,-3.3478132058584d-02,
     |   4.3418341918477d-02, 5.2063946286052d-02,-9.7773726432927d-03,
     |  -5.4753589142869d-02,-4.5398220456208d-02,-1.7337861651674d-02,
     |  -2.8174026278950d-03,-1.0965138766728d-04,-4.7619947978171d-07/
      data (zmn(lat, 7,17), lat = 1,36)/
     |  -4.3846425204748d-07, 1.7563395136889d-05, 7.6838743029968d-04,
     |   7.2217095051077d-03, 2.8237816167507d-02, 5.6537699883671d-02,
     |   5.4247397686595d-02,-2.0888383482365d-03,-6.0061816787486d-02,
     |  -3.9004634637057d-02, 4.1037074424416d-02, 6.1987764591064d-02,
     |  -1.4607075965672d-02,-7.0451359423289d-02,-1.2409194437397d-02,
     |   6.7526215264216d-02, 3.6563622984312d-02,-5.5575250376841d-02,
     |  -5.5575250376841d-02, 3.6563622984312d-02, 6.7526215264216d-02,
     |  -1.2409194437397d-02,-7.0451359423289d-02,-1.4607075965671d-02,
     |   6.1987764591064d-02, 4.1037074424416d-02,-3.9004634637057d-02,
     |  -6.0061816787486d-02,-2.0888383482366d-03, 5.4247397686595d-02,
     |   5.6537699883671d-02, 2.8237816167507d-02, 7.2217095051077d-03,
     |   7.6838743029954d-04, 1.7563395136986d-05,-4.3846425214465d-07/
      data (zmn(lat, 8,17), lat = 1,36)/
     |  -1.7958330834790d-08, 2.3149247205290d-06, 1.7557383473800d-04,
     |   2.4622964593899d-03, 1.3711178332303d-02, 3.9898852284681d-02,
     |   6.5349576267495d-02, 5.1090846353356d-02,-1.3418776411739d-02,
     |  -6.6049879825658d-02,-3.5058288873089d-02, 4.6602063582438d-02,
     |   6.3404654794053d-02,-1.4964315102536d-02,-7.2524439227598d-02,
     |  -1.8066125155231d-02, 6.5703115326394d-02, 4.6367195941018d-02,
     |  -4.6367195941018d-02,-6.5703115326394d-02, 1.8066125155231d-02,
     |   7.2524439227598d-02, 1.4964315102537d-02,-6.3404654794053d-02,
     |  -4.6602063582438d-02, 3.5058288873090d-02, 6.6049879825658d-02,
     |   1.3418776411739d-02,-5.1090846353356d-02,-6.5349576267495d-02,
     |  -3.9898852284681d-02,-1.3711178332303d-02,-2.4622964593898d-03,
     |  -1.7557383473804d-04,-2.3149247205112d-06, 1.7958330961731d-08/
      data (zmn(lat, 9,17), lat = 1,36)/
     |   2.2992274440081d-08, 2.3768772700752d-07, 3.4132457728661d-05,
     |   7.0374662094801d-04, 5.4355761639712d-03, 2.1728372590412d-02,
     |   5.1220692277772d-02, 7.1801623030710d-02, 4.6764304981951d-02,
     |  -2.2988707147408d-02,-7.0554208500468d-02,-3.3018896652185d-02,
     |   4.9621313418388d-02, 6.6336873928093d-02,-1.1091236490912d-02,
     |  -7.3985846583289d-02,-2.8745524625304d-02, 5.9561309065587d-02,
     |   5.9561309065587d-02,-2.8745524625304d-02,-7.3985846583289d-02,
     |  -1.1091236490912d-02, 6.6336873928093d-02, 4.9621313418388d-02,
     |  -3.3018896652185d-02,-7.0554208500468d-02,-2.2988707147408d-02,
     |   4.6764304981951d-02, 7.1801623030709d-02, 5.1220692277772d-02,
     |   2.1728372590412d-02, 5.4355761639713d-03, 7.0374662094797d-04,
     |   3.4132457728831d-05, 2.3768772700519d-07, 2.2992274539396d-08/
      data (zmn(lat,10,17), lat = 1,36)/
     |   7.0736259637408d-10, 2.3270096800402d-08, 5.6869942777546d-06,
     |   1.7088623631441d-04, 1.8007656761779d-03, 9.5926453533953d-03,
     |   3.0451906094943d-02, 6.1426914063340d-02, 7.6470639573978d-02,
     |   4.2947353588828d-02,-2.9815631950706d-02,-7.4267877073597d-02,
     |  -3.4357034486494d-02, 4.9228474208183d-02, 7.1202801057806d-02,
     |  -1.2847438948946d-03,-7.3020948906441d-02,-4.5075526087841d-02,
     |   4.5075526087841d-02, 7.3020948906441d-02, 1.2847438948950d-03,
     |  -7.1202801057806d-02,-4.9228474208183d-02, 3.4357034486494d-02,
     |   7.4267877073597d-02, 2.9815631950706d-02,-4.2947353588828d-02,
     |  -7.6470639573978d-02,-6.1426914063340d-02,-3.0451906094943d-02,
     |  -9.5926453533953d-03,-1.8007656761779d-03,-1.7088623631441d-04,
     |  -5.6869942777641d-06,-2.3270096677121d-08,-7.0736268793556d-10/
      data (zmn(lat,11,17), lat = 1,36)/
     |  -9.9219243958329d-10, 2.9854840048250d-09, 8.1463131187028d-07,
     |   3.5479800044337d-05, 5.0445214307919d-04, 3.5146750542419d-03,
     |   1.4515070981673d-02, 3.8985587491442d-02, 7.0126362049692d-02,
     |   8.0353113774598d-02, 4.1383148500285d-02,-3.2928601738045d-02,
     |  -7.7641727972672d-02,-4.0509065720837d-02, 4.3715025634427d-02,
     |   7.7262072615296d-02, 1.6443100023495d-02,-6.5337835225658d-02,
     |  -6.5337835225658d-02, 1.6443100023495d-02, 7.7262072615296d-02,
     |   4.3715025634427d-02,-4.0509065720837d-02,-7.7641727972672d-02,
     |  -3.2928601738045d-02, 4.1383148500285d-02, 8.0353113774598d-02,
     |   7.0126362049692d-02, 3.8985587491442d-02, 1.4515070981673d-02,
     |   3.5146750542420d-03, 5.0445214307918d-04, 3.5479800044324d-05,
     |   8.1463131174042d-07, 2.9854840077726d-09,-9.9219244210321d-10/
      data (zmn(lat,12,17), lat = 1,36)/
     |  -2.3078291944125d-11, 2.1466338961011d-10, 1.0046212313292d-07,
     |   6.3016797792072d-06, 1.1994271938587d-04, 1.0794354922705d-03,
     |   5.6799360734676d-03, 1.9542047899175d-02, 4.6475956389050d-02,
     |   7.7219745983713d-02, 8.4604941167458d-02, 4.3836104265014d-02,
     |  -3.0944913919742d-02,-8.0232969863768d-02,-5.2582188945548d-02,
     |   2.9930874629051d-02, 8.1110301641783d-02, 4.3082536705364d-02,
     |  -4.3082536705363d-02,-8.1110301641783d-02,-2.9930874629052d-02,
     |   5.2582188945548d-02, 8.0232969863768d-02, 3.0944913919742d-02,
     |  -4.3836104265014d-02,-8.4604941167458d-02,-7.7219745983713d-02,
     |  -4.6475956389050d-02,-1.9542047899175d-02,-5.6799360734677d-03,
     |  -1.0794354922704d-03,-1.1994271938586d-04,-6.3016797792152d-06,
     |  -1.0046212315455d-07,-2.1466354957569d-10, 2.3078320272871d-11/
      data (zmn(lat,13,17), lat = 1,36)/
     |   3.2824942686860d-11,-2.0290311951054d-11, 1.0614737411931d-08,
     |   9.5222200836956d-07, 2.4122197485969d-05, 2.7794219628912d-04,
     |   1.8379495870703d-03, 7.9175188045327d-03, 2.3861320924687d-02,
     |   5.2115530305478d-02, 8.2645007601078d-02, 9.0190079232945d-02,
     |   5.2055826920936d-02,-2.1494660004487d-02,-7.9570792795989d-02,
     |  -7.0210897829577d-02, 3.2154929435907d-03, 7.4057041705260d-02,
     |   7.4057041705260d-02, 3.2154929435908d-03,-7.0210897829576d-02,
     |  -7.9570792795989d-02,-2.1494660004487d-02, 5.2055826920937d-02,
     |   9.0190079232945d-02, 8.2645007601078d-02, 5.2115530305478d-02,
     |   2.3861320924687d-02, 7.9175188045326d-03, 1.8379495870702d-03,
     |   2.7794219628903d-04, 2.4122197486039d-05, 9.5222200844069d-07,
     |   1.0614737519174d-08,-2.0290307526070d-11, 3.2824923737707d-11/
      data (zmn(lat,14,17), lat = 1,36)/
     |   5.5888297956383d-13,-1.0308129501370d-12, 9.4112054839824d-10,
     |   1.2078432649404d-07, 4.0541389375969d-06, 5.9417279039826d-05,
     |   4.8900682512005d-04, 2.5985176833203d-03, 9.6833954399232d-03,
     |   2.6571467024929d-02, 5.5014422728843d-02, 8.5942251650346d-02,
     |   9.7306425882385d-02, 6.7456277201529d-02,-7.4583599053580d-04,
     |  -6.9262698171827d-02,-8.8221023446730d-02,-3.9834906973040d-02,
     |   3.9834906973040d-02, 8.8221023446730d-02, 6.9262698171827d-02,
     |   7.4583599053596d-04,-6.7456277201529d-02,-9.7306425882385d-02,
     |  -8.5942251650346d-02,-5.5014422728843d-02,-2.6571467024929d-02,
     |  -9.6833954399233d-03,-2.5985176833204d-03,-4.8900682512011d-04,
     |  -5.9417279039806d-05,-4.0541389375652d-06,-1.2078432650105d-07,
     |  -9.4112042985289d-10, 1.0308627290850d-12,-5.5885130800500d-13/
      data (zmn(lat,15,17), lat = 1,36)/
     |  -7.1541814833791d-13, 6.8529956574108d-13, 6.7630731983259d-11,
     |   1.2524530704850d-08, 5.5503179532544d-07, 1.0295364511802d-05,
     |   1.0470491599070d-04, 6.7921889475277d-04, 3.0805992205503d-03,
     |   1.0350869564779d-02, 2.6709397401920d-02, 5.3962346478615d-02,
     |   8.5595110354303d-02, 1.0427793622044d-01, 8.9761381766135d-02,
     |   3.5914693716721d-02,-3.6845706462492d-02,-8.9137211800409d-02,
     |  -8.9137211800409d-02,-3.6845706462492d-02, 3.5914693716721d-02,
     |   8.9761381766135d-02, 1.0427793622044d-01, 8.5595110354303d-02,
     |   5.3962346478615d-02, 2.6709397401920d-02, 1.0350869564779d-02,
     |   3.0805992205502d-03, 6.7921889475277d-04, 1.0470491599067d-04,
     |   1.0295364511817d-05, 5.5503179520797d-07, 1.2524530673614d-08,
     |   6.7630668632407d-11, 6.8522941494959d-13,-7.1532847627208d-13/
      data (zmn(lat,16,17), lat = 1,36)/
     |  -8.1403617176675d-15, 2.2558199316980d-14, 3.8125111680887d-12,
     |   1.0056732617144d-09, 5.8681198124424d-08, 1.3722519297858d-06,
     |   1.7152199287257d-05, 1.3479616707370d-04, 7.3596554396776d-04,
     |   2.9786405312405d-03, 9.3323275085392d-03, 2.3298207041574d-02,
     |   4.7185332795354d-02, 7.8146630426049d-02, 1.0541029923462d-01,
     |   1.1293594471382d-01, 8.8485683339368d-02, 3.3671227169445d-02,
     |  -3.3671227169445d-02,-8.8485683339368d-02,-1.1293594471382d-01,
     |  -1.0541029923462d-01,-7.8146630426049d-02,-4.7185332795354d-02,
     |  -2.3298207041574d-02,-9.3323275085392d-03,-2.9786405312405d-03,
     |  -7.3596554396783d-04,-1.3479616707370d-04,-1.7152199287167d-05,
     |  -1.3722519297187d-06,-5.8681198060246d-08,-1.0056731941276d-09,
     |  -3.8125341054816d-12,-2.2501807013881d-14, 8.1111075615092d-15/
      data (zmn(lat,17,17), lat = 1,36)/
     |   6.5689197416682d-15,-6.2309567553780d-15, 1.5171261088027d-13,
     |   5.4373043501106d-11, 4.1685457506689d-09, 1.2250985921163d-07,
     |   1.8739918140250d-06, 1.7738568022460d-05, 1.1565661716205d-04,
     |   5.5747599910540d-04, 2.0857874007856d-03, 6.2718506729772d-03,
     |   1.5545005788038d-02, 3.2355378406570d-02, 5.7335193840946d-02,
     |   8.7365002383210d-02, 1.1526685612632d-01, 1.3225934748283d-01,
     |   1.3225934748283d-01, 1.1526685612632d-01, 8.7365002383210d-02,
     |   5.7335193840946d-02, 3.2355378406570d-02, 1.5545005788038d-02,
     |   6.2718506729772d-03, 2.0857874007856d-03, 5.5747599910540d-04,
     |   1.1565661716208d-04, 1.7738568022484d-05, 1.8739918140234d-06,
     |   1.2250985917659d-07, 4.1685457625312d-09, 5.4373047731007d-11,
     |   1.5174096194263d-13,-6.1590275614559d-15, 6.5069065441322d-15/
      data (zmn(lat, 0,18), lat = 1,36)/
     |   1.1317825445966d-02, 1.1720887259844d-03,-3.3294174147629d-02,
     |   5.8407154269634d-03, 4.1664326661390d-02,-1.0108648844338d-02,
     |  -4.9558736199170d-02, 1.7372486060762d-02, 5.3157848783174d-02,
     |  -2.3470171564528d-02,-5.5967972568767d-02, 3.0690923070580d-02,
     |   5.6018683564417d-02,-3.6899145492072d-02,-5.5002151859230d-02,
     |   4.3038051845176d-02, 5.2117979775181d-02,-4.8089929526329d-02,
     |  -4.8089929526329d-02, 5.2117979775181d-02, 4.3038051845176d-02,
     |  -5.5002151859229d-02,-3.6899145492073d-02, 5.6018683564417d-02,
     |   3.0690923070580d-02,-5.5967972568767d-02,-2.3470171564528d-02,
     |   5.3157848783174d-02, 1.7372486060762d-02,-4.9558736199170d-02,
     |  -1.0108648844338d-02, 4.1664326661390d-02, 5.8407154269636d-03,
     |  -3.3294174147629d-02, 1.1720887259844d-03, 1.1317825445966d-02/
      data (zmn(lat, 1,18), lat = 1,36)/
     |   7.4593754352056d-03, 2.4671806332847d-02,-6.0569920009838d-03,
     |  -3.7811509168158d-02, 1.0731017677420d-02, 4.5382290471815d-02,
     |  -1.5652645983229d-02,-5.1234002803239d-02, 2.2126529739816d-02,
     |   5.4141658669908d-02,-2.8138542981115d-02,-5.5876825689635d-02,
     |   3.4804048756387d-02, 5.5198850716503d-02,-4.0413025469662d-02,
     |  -5.3659475423416d-02, 4.6044179549806d-02, 5.0091151617022d-02,
     |  -5.0091151617022d-02,-4.6044179549806d-02, 5.3659475423416d-02,
     |   4.0413025469662d-02,-5.5198850716503d-02,-3.4804048756387d-02,
     |   5.5876825689635d-02, 2.8138542981115d-02,-5.4141658669908d-02,
     |  -2.2126529739816d-02, 5.1234002803239d-02, 1.5652645983229d-02,
     |  -4.5382290471815d-02,-1.0731017677420d-02, 3.7811509168158d-02,
     |   6.0569920009839d-03,-2.4671806332847d-02,-7.4593754352056d-03/
      data (zmn(lat, 2,18), lat = 1,36)/
     |   1.4754213975044d-03, 2.1042805743026d-02, 2.9305074863285d-02,
     |  -1.8075383537058d-02,-3.9577983343326d-02, 2.0072632105580d-02,
     |   4.6648365847697d-02,-2.4341080972664d-02,-5.0966678648654d-02,
     |   2.9148470846850d-02, 5.3599304490666d-02,-3.4483472408783d-02,
     |  -5.4347702802960d-02, 3.9590641147771d-02, 5.3703072105835d-02,
     |  -4.4399536510096d-02,-5.1646335488904d-02, 4.8479253952106d-02,
     |   4.8479253952106d-02,-5.1646335488904d-02,-4.4399536510096d-02,
     |   5.3703072105835d-02, 3.9590641147772d-02,-5.4347702802960d-02,
     |  -3.4483472408783d-02, 5.3599304490666d-02, 2.9148470846850d-02,
     |  -5.0966678648653d-02,-2.4341080972664d-02, 4.6648365847697d-02,
     |   2.0072632105580d-02,-3.9577983343326d-02,-1.8075383537058d-02,
     |   2.9305074863285d-02, 2.1042805743026d-02, 1.4754213975043d-03/
      data (zmn(lat, 3,18), lat = 1,36)/
     |   1.3059569107314d-05, 9.9183104029326d-03, 3.5080962545398d-02,
     |   2.5383430135832d-02,-3.1502826931493d-02,-3.7379855476574d-02,
     |   3.1866699419925d-02, 4.4473243893927d-02,-3.4252673610953d-02,
     |  -4.8776984676584d-02, 3.7422977969558d-02, 5.1272013329088d-02,
     |  -4.1041809423118d-02,-5.2090424006982d-02, 4.4490376606054d-02,
     |   5.1687451052593d-02,-4.7658653421393d-02,-5.0069071931148d-02,
     |   5.0069071931148d-02, 4.7658653421393d-02,-5.1687451052593d-02,
     |  -4.4490376606054d-02, 5.2090424006982d-02, 4.1041809423118d-02,
     |  -5.1272013329088d-02,-3.7422977969558d-02, 4.8776984676584d-02,
     |   3.4252673610953d-02,-4.4473243893926d-02,-3.1866699419925d-02,
     |   3.7379855476574d-02, 3.1502826931493d-02,-2.5383430135832d-02,
     |  -3.5080962545398d-02,-9.9183104029326d-03,-1.3059569107390d-05/
      data (zmn(lat, 4,18), lat = 1,36)/
     |   4.9731471135361d-06, 3.1871462486106d-03, 2.2969390563445d-02,
     |   4.4636040941631d-02, 1.4963208257772d-02,-4.4088038505518d-02,
     |  -3.0453636998884d-02, 4.3625109147913d-02, 3.9148106157960d-02,
     |  -4.4230632949408d-02,-4.4553171264312d-02, 4.5545268456965d-02,
     |   4.7814620592481d-02,-4.7100665712639d-02,-4.9536662146771d-02,
     |   4.8572575808221d-02, 5.0049391200948d-02,-4.9642681152721d-02,
     |  -4.9642681152721d-02, 5.0049391200948d-02, 4.8572575808221d-02,
     |  -4.9536662146771d-02,-4.7100665712639d-02, 4.7814620592481d-02,
     |   4.5545268456965d-02,-4.4553171264312d-02,-4.4230632949408d-02,
     |   3.9148106157960d-02, 4.3625109147913d-02,-3.0453636998883d-02,
     |  -4.4088038505518d-02, 1.4963208257773d-02, 4.4636040941631d-02,
     |   2.2969390563445d-02, 3.1871462486105d-03, 4.9731471136293d-06/
      data (zmn(lat, 5,18), lat = 1,36)/
     |   1.4607132729155d-05, 7.7500980111118d-04, 1.0653855102932d-02,
     |   3.7440093169173d-02, 4.7973876577593d-02, 1.0655159672543d-04,
     |  -5.3594576795565d-02,-1.9652857908603d-02, 5.3699335744013d-02,
     |   3.1332997757082d-02,-5.3149230133043d-02,-3.8946291320008d-02,
     |   5.2622407657008d-02, 4.4058612971319d-02,-5.2025849923869d-02,
     |  -4.7501896329272d-02, 5.1161682888268d-02, 4.9743888512538d-02,
     |  -4.9743888512538d-02,-5.1161682888268d-02, 4.7501896329272d-02,
     |   5.2025849923869d-02,-4.4058612971319d-02,-5.2622407657008d-02,
     |   3.8946291320008d-02, 5.3149230133043d-02,-3.1332997757082d-02,
     |  -5.3699335744013d-02, 1.9652857908603d-02, 5.3594576795565d-02,
     |  -1.0655159672538d-04,-4.7973876577593d-02,-3.7440093169173d-02,
     |  -1.0653855102932d-02,-7.7500980111115d-04,-1.4607132729114d-05/
      data (zmn(lat, 6,18), lat = 1,36)/
     |   7.1059002727405d-07, 1.5581876444052d-04, 3.8358450484842d-03,
     |   2.1905717336530d-02, 5.0349231476363d-02, 4.4920287028942d-02,
     |  -1.6702086829996d-02,-5.8808264303317d-02,-6.6021257752702d-03,
     |   6.1195844843569d-02, 2.2166644908383d-02,-6.0311055298768d-02,
     |  -3.3070500353757d-02, 5.8184696022074d-02, 4.1034970441154d-02,
     |  -5.5305023343823d-02,-4.7032932642449d-02, 5.1661889000174d-02,
     |   5.1661889000175d-02,-4.7032932642449d-02,-5.5305023343823d-02,
     |   4.1034970441153d-02, 5.8184696022074d-02,-3.3070500353757d-02,
     |  -6.0311055298768d-02, 2.2166644908383d-02, 6.1195844843569d-02,
     |  -6.6021257752700d-03,-5.8808264303317d-02,-1.6702086829996d-02,
     |   4.4920287028942d-02, 5.0349231476363d-02, 2.1905717336530d-02,
     |   3.8358450484844d-03, 1.5581876444057d-04, 7.1059002724806d-07/
      data (zmn(lat, 7,18), lat = 1,36)/
     |  -9.7176619396710d-07, 2.6988244773589d-05, 1.1252455752647d-03,
     |   9.9502238136366d-03, 3.5293643540811d-02, 5.9672895368750d-02,
     |   3.6494919850766d-02,-3.3058629716173d-02,-5.9751883232963d-02,
     |   6.8941948572810d-03, 6.5988666998778d-02, 1.3095125485202d-02,
     |  -6.5589075712411d-02,-2.8236207776768d-02, 6.2022714550327d-02,
     |   3.9945419242060d-02,-5.6462180569063d-02,-4.9168930283445d-02,
     |   4.9168930283445d-02, 5.6462180569063d-02,-3.9945419242059d-02,
     |  -6.2022714550327d-02, 2.8236207776768d-02, 6.5589075712411d-02,
     |  -1.3095125485202d-02,-6.5988666998778d-02,-6.8941948572812d-03,
     |   5.9751883232963d-02, 3.3058629716173d-02,-3.6494919850766d-02,
     |  -5.9672895368750d-02,-3.5293643540811d-02,-9.9502238136365d-03,
     |  -1.1252455752646d-03,-2.6988244773574d-05, 9.7176619395152d-07/
      data (zmn(lat, 8,18), lat = 1,36)/
     |  -3.0722698690885d-08, 3.7747759560709d-06, 2.7697488908956d-04,
     |   3.6868421750879d-03, 1.8972217868707d-02, 4.8887260817878d-02,
     |   6.4530423410918d-02, 2.4563754688380d-02,-4.7218704555973d-02,
     |  -5.7446764636933d-02, 1.9215386564574d-02, 6.8675278028514d-02,
     |   5.6054082327335d-03,-6.9274365787880d-02,-2.5838132518084d-02,
     |   6.3973353750896d-02, 4.2016809779978d-02,-5.4688440409024d-02,
     |  -5.4688440409024d-02, 4.2016809779978d-02, 6.3973353750897d-02,
     |  -2.5838132518084d-02,-6.9274365787880d-02, 5.6054082327338d-03,
     |   6.8675278028514d-02, 1.9215386564574d-02,-5.7446764636933d-02,
     |  -4.7218704555973d-02, 2.4563754688380d-02, 6.4530423410918d-02,
     |   4.8887260817878d-02, 1.8972217868707d-02, 3.6868421750879d-03,
     |   2.7697488908948d-04, 3.7747759561465d-06,-3.0722698618551d-08/
      data (zmn(lat, 9,18), lat = 1,36)/
     |   6.3036542899879d-08, 3.9456108914308d-07, 5.8172930681775d-05,
     |   1.1454277030932d-03, 8.2751116875030d-03, 3.0029119115354d-02,
     |   6.1070478608597d-02, 6.5195417919324d-02, 1.1320154399352d-02,
     |  -5.8352624099748d-02,-5.3558867998345d-02, 2.9124301641079d-02,
     |   7.0345567978623d-02, 1.1204962984280d-03,-7.1766938216099d-02,
     |  -2.7301740855922d-02, 6.3497102643630d-02, 4.8280052787786d-02,
     |  -4.8280052787786d-02,-6.3497102643630d-02, 2.7301740855921d-02,
     |   7.1766938216099d-02,-1.1204962984278d-03,-7.0345567978623d-02,
     |  -2.9124301641079d-02, 5.3558867998345d-02, 5.8352624099748d-02,
     |  -1.1320154399352d-02,-6.5195417919323d-02,-6.1070478608597d-02,
     |  -3.0029119115354d-02,-8.2751116875031d-03,-1.1454277030933d-03,
     |  -5.8172930681735d-05,-3.9456108914818d-07,-6.3036542991319d-08/
      data (zmn(lat,10,18), lat = 1,36)/
     |   1.4009683690082d-09, 4.4003203085223d-08, 1.0510272639575d-05,
     |   3.0323161363570d-04, 3.0145074758312d-03, 1.4806114075496d-02,
     |   4.1901218312774d-02, 7.0914679706082d-02, 6.2883793873827d-02,
     |  -1.1665362842072d-03,-6.6489675357261d-02,-5.0047104579240d-02,
     |   3.5720519609324d-02, 7.2232079134485d-02, 1.0872122679277d-03,
     |  -7.3081756330323d-02,-3.4012698426884d-02, 5.8998110622264d-02,
     |   5.8998110622264d-02,-3.4012698426884d-02,-7.3081756330323d-02,
     |   1.0872122679276d-03, 7.2232079134485d-02, 3.5720519609324d-02,
     |  -5.0047104579240d-02,-6.6489675357261d-02,-1.1665362842073d-03,
     |   6.2883793873827d-02, 7.0914679706083d-02, 4.1901218312774d-02,
     |   1.4806114075496d-02, 3.0145074758311d-03, 3.0323161363564d-04,
     |   1.0510272639543d-05, 4.4003203013397d-08, 1.4009684590152d-09/
      data (zmn(lat,11,18), lat = 1,36)/
     |  -3.4484033703030d-09, 7.5426707829031d-09, 1.6423334780946d-06,
     |   6.9011293803031d-05, 9.3163735745177d-04, 6.0498005179265d-03,
     |   2.2714126950697d-02, 5.3403029848532d-02, 7.8311865810499d-02,
     |   5.9412235636434d-02,-1.1171910346541d-02,-7.2218846724640d-02,
     |  -4.8898676782012d-02, 3.8118421763836d-02, 7.5246534393386d-02,
     |   7.1801434839586d-03,-7.2057167913472d-02,-4.6935755007437d-02,
     |   4.6935755007437d-02, 7.2057167913472d-02,-7.1801434839582d-03,
     |  -7.5246534393386d-02,-3.8118421763836d-02, 4.8898676782012d-02,
     |   7.2218846724640d-02, 1.1171910346541d-02,-5.9412235636434d-02,
     |  -7.8311865810499d-02,-5.3403029848532d-02,-2.2714126950697d-02,
     |  -6.0498005179265d-03,-9.3163735745165d-04,-6.9011293803059d-05,
     |  -1.6423334782394d-06,-7.5426708147114d-09, 3.4484033695228d-09/
      data (zmn(lat,12,18), lat = 1,36)/
     |  -5.4351862343548d-11, 4.9178944788805d-10, 2.2333800748758d-07,
     |   1.3548687959412d-05, 2.4610148625625d-04, 2.0808328276381d-03,
     |   1.0086591796140d-02, 3.1120280943740d-02, 6.3648581858506d-02,
     |   8.3875834723485d-02, 5.6871438317224d-02,-1.7244173311867d-02,
     |  -7.6189419637394d-02,-5.1951213216614d-02, 3.4875444528738d-02,
     |   7.9231100025510d-02, 2.1348065725674d-02,-6.5122601755679d-02,
     |  -6.5122601755679d-02, 2.1348065725674d-02, 7.9231100025510d-02,
     |   3.4875444528738d-02,-5.1951213216614d-02,-7.6189419637393d-02,
     |  -1.7244173311867d-02, 5.6871438317224d-02, 8.3875834723485d-02,
     |   6.3648581858506d-02, 3.1120280943740d-02, 1.0086591796140d-02,
     |   2.0808328276381d-03, 2.4610148625638d-04, 1.3548687959409d-05,
     |   2.2333800741512d-07, 4.9178932100459d-10,-5.4351841253624d-11/
      data (zmn(lat,13,18), lat = 1,36)/
     |   1.5036599816492d-10,-1.1780939749708d-10, 2.6410098009417d-08,
     |   2.2915185188471d-06, 5.5628465338286d-05, 6.0593881136980d-04,
     |   3.7268659366328d-03, 1.4626462032369d-02, 3.9022720604502d-02,
     |   7.2123099724784d-02, 8.8665198764188d-02, 5.7404465768262d-02,
     |  -1.7837546891862d-02,-7.8371292211689d-02,-6.0603199534317d-02,
     |   2.3281149097812d-02, 8.1510878962202d-02, 4.4868458243532d-02,
     |  -4.4868458243532d-02,-8.1510878962202d-02,-2.3281149097813d-02,
     |   6.0603199534316d-02, 7.8371292211689d-02, 1.7837546891861d-02,
     |  -5.7404465768261d-02,-8.8665198764188d-02,-7.2123099724784d-02,
     |  -3.9022720604503d-02,-1.4626462032369d-02,-3.7268659366328d-03,
     |  -6.0593881136984d-04,-5.5628465338312d-05,-2.2915185187979d-06,
     |  -2.6410097895538d-08, 1.1780935845895d-10,-1.5036578911027d-10/
      data (zmn(lat,14,18), lat = 1,36)/
     |   1.6518198073141d-12,-3.0516781044308d-12, 2.6589789556362d-09,
     |   3.3164425163081d-07, 1.0703328191007d-05, 1.4903574910254d-04,
     |   1.1492841695328d-03, 5.6270316948337d-03, 1.8908884058810d-02,
     |   4.5409587024901d-02, 7.8526642197760d-02, 9.3762860685208d-02,
     |   6.3060443573582d-02,-1.0712505605674d-02,-7.6878816140727d-02,
     |  -7.4817447276373d-02,-9.5974487185516d-04, 7.4241413583234d-02,
     |   7.4241413583234d-02,-9.5974487185495d-04,-7.4817447276373d-02,
     |  -7.6878816140727d-02,-1.0712505605674d-02, 6.3060443573582d-02,
     |   9.3762860685208d-02, 7.8526642197760d-02, 4.5409587024901d-02,
     |   1.8908884058810d-02, 5.6270316948337d-03, 1.1492841695329d-03,
     |   1.4903574910250d-04, 1.0703328190924d-05, 3.3164425161479d-07,
     |   2.6589790043171d-09,-3.0515052086846d-12, 1.6517564479480d-12/
      data (zmn(lat,15,18), lat = 1,36)/
     |  -4.6954058896204d-12, 4.5727750289360d-12, 2.2220752740690d-10,
     |   4.0481172136481d-08, 1.7297694604361d-06, 3.0609156439223d-05,
     |   2.9339702589315d-04, 1.7686634588506d-03, 7.3277306974866d-03,
     |   2.2002814828860d-02, 4.9231008328180d-02, 8.2375583815084d-02,
     |   9.9641214720172d-02, 7.5469950956478d-02, 7.6474267001472d-03,
     |  -6.6054761938316d-02,-9.0048456944782d-02,-4.1498850249070d-02,
     |   4.1498850249070d-02, 9.0048456944782d-02, 6.6054761938317d-02,
     |  -7.6474267001471d-03,-7.5469950956478d-02,-9.9641214720172d-02,
     |  -8.2375583815084d-02,-4.9231008328180d-02,-2.2002814828860d-02,
     |  -7.3277306974866d-03,-1.7686634588507d-03,-2.9339702589315d-04,
     |  -3.0609156439172d-05,-1.7297694603975d-06,-4.0481172101815d-08,
     |  -2.2220759762113d-10,-4.5728312600109d-12, 4.6952997455307d-12/
      data (zmn(lat,16,18), lat = 1,36)/
     |  -3.3706833916594d-14, 9.6136943177201d-14, 1.5755565467013d-11,
     |   4.0541157972282d-09, 2.2866963718278d-07, 5.1189248204372d-06,
     |   6.0593346151116d-05, 4.4550109540141d-04, 2.2434670115393d-03,
     |   8.2320390807437d-03, 2.2880924414942d-02, 4.9221995399917d-02,
     |   8.2339546908818d-02, 1.0504451878152d-01, 9.4619200465656d-02,
     |   4.1612671460991d-02,-3.4123108095163d-02,-8.9838588730963d-02,
     |  -8.9838588730963d-02,-3.4123108095163d-02, 4.1612671460990d-02,
     |   9.4619200465656d-02, 1.0504451878152d-01, 8.2339546908818d-02,
     |   4.9221995399917d-02, 2.2880924414942d-02, 8.2320390807437d-03,
     |   2.2434670115394d-03, 4.4550109540145d-04, 6.0593346151130d-05,
     |   5.1189248204975d-06, 2.2866963726515d-07, 4.0541158391527d-09,
     |   1.5755544289598d-11, 9.6087975392884d-14,-3.3727810600402d-14/
      data (zmn(lat,17,18), lat = 1,36)/
     |   8.2843922646507d-14,-8.0230052517283d-14, 9.4397736167404d-13,
     |   3.1538815284994d-10, 2.3426185492756d-08, 6.6099899437871d-07,
     |   9.6138589322270d-06, 8.5602426245385d-05, 5.1868326010068d-04,
     |   2.2909224207679d-03, 7.7235689801378d-03, 2.0498075842366d-02,
     |   4.3661369105833d-02, 7.5315958249135d-02, 1.0487306270116d-01,
     |   1.1502046148492d-01, 9.1517253639805d-02, 3.5091893235436d-02,
     |  -3.5091893235435d-02,-9.1517253639805d-02,-1.1502046148492d-01,
     |  -1.0487306270116d-01,-7.5315958249135d-02,-4.3661369105833d-02,
     |  -2.0498075842366d-02,-7.7235689801378d-03,-2.2909224207679d-03,
     |  -5.1868326010073d-04,-8.5602426245449d-05,-9.6138589322873d-06,
     |  -6.6099899446142d-07,-2.3426185544299d-08,-3.1538815965375d-10,
     |  -9.4394860297229d-13, 8.0254541562001d-14,-8.2893023067614d-14/
      data (zmn(lat,18,18), lat = 1,36)/
     |   1.0526542121038d-16,-9.8475614381001d-16, 3.3151444321760d-14,
     |   1.6575730755779d-11, 1.6172376184210d-09, 5.7349053200188d-08,
     |   1.0207839317210d-06, 1.0947508654641d-05, 7.9214273438764d-05,
     |   4.1668385218689d-04, 1.6775918439582d-03, 5.3625890014150d-03,
     |   1.3978784948552d-02, 3.0304801311382d-02, 5.5435810095127d-02,
     |   8.6470628952563d-02, 1.1585709261992d-01, 1.3395608255266d-01,
     |   1.3395608255266d-01, 1.1585709261992d-01, 8.6470628952563d-02,
     |   5.5435810095127d-02, 3.0304801311382d-02, 1.3978784948552d-02,
     |   5.3625890014150d-03, 1.6775918439582d-03, 4.1668385218691d-04,
     |   7.9214273438768d-05, 1.0947508654658d-05, 1.0207839317163d-06,
     |   5.7349053188959d-08, 1.6172375852069d-09, 1.6575688862191d-11,
     |   3.3114871912548d-14,-1.0182353773874d-15, 1.1491827233897d-16/
      data (zmn(lat, 0,19), lat = 1,36)/
     |   1.1276938963820d-02,-2.0053798281118d-03,-3.2094365941061d-02,
     |   1.7126142649255d-02, 3.5358375755677d-02,-3.0076625136202d-02,
     |  -3.4588674487965d-02, 4.5408581651264d-02, 2.5198151573246d-02,
     |  -5.6057483176590d-02,-1.2791017476288d-02, 6.4149129817461d-02,
     |  -4.4262905703562d-03,-6.5319448020006d-02, 2.1391424589632d-02,
     |   6.2060378166934d-02,-3.8782392094187d-02,-5.2011522904661d-02,
     |   5.2011522904661d-02, 3.8782392094187d-02,-6.2060378166934d-02,
     |  -2.1391424589632d-02, 6.5319448020006d-02, 4.4262905703556d-03,
     |  -6.4149129817461d-02, 1.2791017476289d-02, 5.6057483176590d-02,
     |  -2.5198151573246d-02,-4.5408581651264d-02, 3.4588674487964d-02,
     |   3.0076625136202d-02,-3.5358375755677d-02,-1.7126142649256d-02,
     |   3.2094365941061d-02, 2.0053798281119d-03,-1.1276938963820d-02/
      data (zmn(lat, 1,19), lat = 1,36)/
     |   7.8985733228195d-03, 2.3832465646792d-02,-1.2827807958468d-02,
     |  -3.3505368935448d-02, 2.5746431904908d-02, 3.4406830276634d-02,
     |  -3.9380383473462d-02,-2.9122500514827d-02, 5.1934047843198d-02,
     |   1.8211497904776d-02,-6.1027361398201d-02,-3.4182437757487d-03,
     |   6.5442947919104d-02,-1.3595201272784d-02,-6.4284223041767d-02,
     |   3.0702687842325d-02, 5.7579727564510d-02,-4.5954884894116d-02,
     |  -4.5954884894116d-02, 5.7579727564510d-02, 3.0702687842325d-02,
     |  -6.4284223041767d-02,-1.3595201272784d-02, 6.5442947919104d-02,
     |  -3.4182437757480d-03,-6.1027361398201d-02, 1.8211497904776d-02,
     |   5.1934047843198d-02,-2.9122500514827d-02,-3.9380383473463d-02,
     |   3.4406830276634d-02, 2.5746431904908d-02,-3.3505368935448d-02,
     |  -1.2827807958468d-02, 2.3832465646792d-02, 7.8985733228195d-03/
      data (zmn(lat, 2,19), lat = 1,36)/
     |   1.6834707438374d-03, 2.2510510532706d-02, 2.5094400149873d-02,
     |  -2.7287653279101d-02,-2.9698259301401d-02, 3.7486048755054d-02,
     |   2.7865029318224d-02,-4.9030100935262d-02,-1.9797343389197d-02,
     |   5.8254705389832d-02, 7.6987063250933d-03,-6.4251990762289d-02,
     |   7.6661219165557d-03, 6.5178050888053d-02,-2.3789978676943d-02,
     |  -6.1273081868305d-02, 3.9417420274121d-02, 5.2187891396764d-02,
     |  -5.2187891396764d-02,-3.9417420274122d-02, 6.1273081868305d-02,
     |   2.3789978676943d-02,-6.5178050888053d-02,-7.6661219165552d-03,
     |   6.4251990762289d-02,-7.6987063250934d-03,-5.8254705389832d-02,
     |   1.9797343389197d-02, 4.9030100935262d-02,-2.7865029318223d-02,
     |  -3.7486048755054d-02, 2.9698259301400d-02, 2.7287653279101d-02,
     |  -2.5094400149872d-02,-2.2510510532706d-02,-1.6834707438375d-03/
      data (zmn(lat, 3,19), lat = 1,36)/
     |   3.4410123640099d-05, 1.1405978265136d-02, 3.6308614589582d-02,
     |   1.5783445397208d-02,-4.0713396130566d-02,-1.9696134713648d-02,
     |   4.8637242276538d-02, 1.6061624597530d-02,-5.6679705103379d-02,
     |  -7.2676455906145d-03, 6.2574705694297d-02,-5.0299123520007d-03,
     |  -6.4966556408951d-02, 1.9251766927435d-02, 6.3075614796737d-02,
     |  -3.3676066807780d-02,-5.6813471301458d-02, 4.6671268077704d-02,
     |   4.6671268077705d-02,-5.6813471301458d-02,-3.3676066807780d-02,
     |   6.3075614796737d-02, 1.9251766927435d-02,-6.4966556408951d-02,
     |  -5.0299123520013d-03, 6.2574705694297d-02,-7.2676455906144d-03,
     |  -5.6679705103379d-02, 1.6061624597530d-02, 4.8637242276538d-02,
     |  -1.9696134713648d-02,-4.0713396130566d-02, 1.5783445397208d-02,
     |   3.6308614589582d-02, 1.1405978265136d-02, 3.4410123640011d-05/
      data (zmn(lat, 4,19), lat = 1,36)/
     |   5.3802939410214d-06, 3.9177452121450d-03, 2.6220264496384d-02,
     |   4.2954941156289d-02,-6.3723624033420d-04,-4.9761952521092d-02,
     |  -4.0944631268836d-03, 5.5870768739484d-02, 7.0558741495848d-04,
     |  -6.0896754392348d-02, 7.3366504312116d-03, 6.3696114804181d-02,
     |  -1.8234527880456d-02,-6.3281840565864d-02, 3.0270024494693d-02,
     |   5.9370426776126d-02,-4.2012817775282d-02,-5.2037848753348d-02,
     |   5.2037848753348d-02, 4.2012817775282d-02,-5.9370426776126d-02,
     |  -3.0270024494693d-02, 6.3281840565864d-02, 1.8234527880456d-02,
     |  -6.3696114804181d-02,-7.3366504312115d-03, 6.0896754392348d-02,
     |  -7.0558741495844d-04,-5.5870768739484d-02, 4.0944631268832d-03,
     |   4.9761952521092d-02, 6.3723624033434d-04,-4.2954941156289d-02,
     |  -2.6220264496384d-02,-3.9177452121449d-03,-5.3802939409832d-06/
      data (zmn(lat, 5,19), lat = 1,36)/
     |   1.7167547169559d-05, 1.0151561658674d-03, 1.3158014223702d-02,
     |   4.1484147899758d-02, 4.0514624897750d-02,-2.0391272671090d-02,
     |  -5.1884556132732d-02, 1.4461214068676d-02, 5.7630685417776d-02,
     |  -1.6180064564510d-02,-6.0892507957039d-02, 2.2195059905664d-02,
     |   6.1682137968382d-02,-3.0516532595471d-02,-5.9748457309597d-02,
     |   3.9597820818415d-02, 5.5109150202587d-02,-4.8144956749281d-02,
     |  -4.8144956749281d-02, 5.5109150202587d-02, 3.9597820818415d-02,
     |  -5.9748457309596d-02,-3.0516532595471d-02, 6.1682137968382d-02,
     |   2.2195059905665d-02,-6.0892507957039d-02,-1.6180064564510d-02,
     |   5.7630685417776d-02, 1.4461214068676d-02,-5.1884556132732d-02,
     |  -2.0391272671090d-02, 4.0514624897750d-02, 4.1484147899758d-02,
     |   1.3158014223702d-02, 1.0151561658672d-03, 1.7167547169590d-05/
      data (zmn(lat, 6,19), lat = 1,36)/
     |   1.0874945391242d-06, 2.1636768889799d-04, 5.0917208816945d-03,
     |   2.6792884959202d-02, 5.2905220679108d-02, 2.9549142484780d-02,
     |  -3.9396802788126d-02,-4.6574981885966d-02, 3.2888902446163d-02,
     |   5.3847639266215d-02,-3.2427194369692d-02,-5.7031071576811d-02,
     |   3.5646523413733d-02, 5.7432556725799d-02,-4.0778385232572d-02,
     |  -5.5511131919342d-02, 4.6477913268036d-02, 5.1661306618604d-02,
     |  -5.1661306618604d-02,-4.6477913268036d-02, 5.5511131919342d-02,
     |   4.0778385232572d-02,-5.7432556725799d-02,-3.5646523413733d-02,
     |   5.7031071576810d-02, 3.2427194369691d-02,-5.3847639266215d-02,
     |  -3.2888902446163d-02, 4.6574981885966d-02, 3.9396802788127d-02,
     |  -2.9549142484780d-02,-5.2905220679108d-02,-2.6792884959202d-02,
     |  -5.0917208816943d-03,-2.1636768889806d-04,-1.0874945391365d-06/
      data (zmn(lat, 7,19), lat = 1,36)/
     |  -1.2120222999551d-06, 3.9700038097161d-05, 1.6015054019259d-03,
     |   1.3251004520709d-02, 4.2140017082705d-02, 5.7800337468202d-02,
     |   1.2433333006067d-02,-5.4333917526116d-02,-3.5217623651215d-02,
     |   4.8671168005228d-02, 4.5723013441044d-02,-4.6300544024028d-02,
     |  -5.0655512658398d-02, 4.6581158266718d-02, 5.2407642127259d-02,
     |  -4.8327248521808d-02,-5.2084973899516d-02, 5.0464396515012d-02,
     |   5.0464396515012d-02,-5.2084973899516d-02,-4.8327248521808d-02,
     |   5.2407642127259d-02, 4.6581158266718d-02,-5.0655512658398d-02,
     |  -4.6300544024029d-02, 4.5723013441044d-02, 4.8671168005228d-02,
     |  -3.5217623651215d-02,-5.4333917526116d-02, 1.2433333006067d-02,
     |   5.7800337468202d-02, 4.2140017082705d-02, 1.3251004520709d-02,
     |   1.6015054019259d-03, 3.9700038097242d-05,-1.2120222998299d-06/
      data (zmn(lat, 8,19), lat = 1,36)/
     |  -5.5430721541018d-08, 5.9793944276523d-06, 4.2260767105040d-04,
     |   5.3186173435690d-03, 2.5093657004565d-02, 5.6176385042844d-02,
     |   5.5420246018605d-02,-7.5049635201981d-03,-6.3483049158493d-02,
     |  -2.0312011125945d-02, 6.0409564310873d-02, 3.5307145338024d-02,
     |  -5.6917088055585d-02,-4.3654460501368d-02, 5.4503169983918d-02,
     |   4.8363723769350d-02,-5.2803763403863d-02,-5.1052935549707d-02,
     |   5.1052935549707d-02, 5.2803763403863d-02,-4.8363723769350d-02,
     |  -5.4503169983919d-02, 4.3654460501368d-02, 5.6917088055585d-02,
     |  -3.5307145338024d-02,-6.0409564310873d-02, 2.0312011125945d-02,
     |   6.3483049158493d-02, 7.5049635201986d-03,-5.5420246018605d-02,
     |  -5.6176385042844d-02,-2.5093657004565d-02,-5.3186173435692d-03,
     |  -4.2260767105056d-04,-5.9793944277249d-06, 5.5430721452528d-08/
      data (zmn(lat, 9,19), lat = 1,36)/
     |   8.5655356872256d-08, 6.8874759835016d-07, 9.5331612744446d-05,
     |   1.7879220475401d-03, 1.2010467297936d-02, 3.9100741682824d-02,
     |   6.6557408555436d-02, 4.6810444868707d-02,-2.7040350983496d-02,
     |  -6.6888105540794d-02,-4.6354614048993d-03, 6.7994572762532d-02,
     |   2.4942132984532d-02,-6.4261067770558d-02,-3.8084543310232d-02,
     |   5.9341673550956d-02, 4.7082901785470d-02,-5.3790728056752d-02,
     |  -5.3790728056752d-02, 4.7082901785470d-02, 5.9341673550956d-02,
     |  -3.8084543310231d-02,-6.4261067770558d-02, 2.4942132984532d-02,
     |   6.7994572762532d-02,-4.6354614048995d-03,-6.6888105540794d-02,
     |  -2.7040350983496d-02, 4.6810444868707d-02, 6.6557408555435d-02,
     |   3.9100741682824d-02, 1.2010467297936d-02, 1.7879220475402d-03,
     |   9.5331612744352d-05, 6.8874759828952d-07, 8.5655356705398d-08/
      data (zmn(lat,10,19), lat = 1,36)/
     |   2.9981215619334d-09, 7.8630941243273d-08, 1.8567852631312d-05,
     |   5.1288151264253d-04, 4.7875460525673d-03, 2.1499584622284d-02,
     |   5.3314391090336d-02, 7.2216121915832d-02, 3.4232125040798d-02,
     |  -4.3852039332404d-02,-6.6015884689816d-02, 9.3999718087282d-03,
     |   7.2380882078245d-02, 1.6854035291444d-02,-6.8861705883556d-02,
     |  -3.5936415675925d-02, 6.0969616834185d-02, 5.0131165974925d-02,
     |  -5.0131165974925d-02,-6.0969616834185d-02, 3.5936415675925d-02,
     |   6.8861705883557d-02,-1.6854035291444d-02,-7.2380882078245d-02,
     |  -9.3999718087286d-03, 6.6015884689816d-02, 4.3852039332404d-02,
     |  -3.4232125040798d-02,-7.2216121915832d-02,-5.3314391090336d-02,
     |  -2.1499584622284d-02,-4.7875460525673d-03,-5.1288151264238d-04,
     |  -1.8567852631279d-05,-7.8630941109223d-08,-2.9981213953001d-09/
      data (zmn(lat,11,19), lat = 1,36)/
     |  -5.1907471013045d-09, 1.3162195459694d-08, 3.1429871536567d-06,
     |   1.2693965988243d-04, 1.6207891991469d-03, 9.7460972061340d-03,
     |   3.2881902326715d-02, 6.6038573828976d-02, 7.3494433094174d-02,
     |   2.0412011778152d-02,-5.6852161318240d-02,-6.3179005885297d-02,
     |   2.0012128531521d-02, 7.5095802574511d-02, 1.3042865733062d-02,
     |  -7.1197269582742d-02,-3.9025650869136d-02, 5.8411480857880d-02,
     |   5.8411480857881d-02,-3.9025650869136d-02,-7.1197269582742d-02,
     |   1.3042865733061d-02, 7.5095802574511d-02, 2.0012128531521d-02,
     |  -6.3179005885296d-02,-5.6852161318240d-02, 2.0412011778152d-02,
     |   7.3494433094174d-02, 6.6038573828976d-02, 3.2881902326716d-02,
     |   9.7460972061340d-03, 1.6207891991470d-03, 1.2693965988237d-04,
     |   3.1429871538407d-06, 1.3162195500013d-08,-5.1907469469357d-09/
      data (zmn(lat,12,19), lat = 1,36)/
     |  -1.4167132588915d-10, 1.1222787166506d-09, 4.6557061157738d-07,
     |   2.7262876250259d-05, 4.7100424726158d-04, 3.7218182324843d-03,
     |   1.6476287132293d-02, 4.4879116256118d-02, 7.6328419429345d-02,
     |   7.1885498110098d-02, 7.9387444641726d-03,-6.6036616865467d-02,
     |  -6.0969631722033d-02, 2.5868986878547d-02, 7.7596201710130d-02,
     |   1.5446151911020d-02,-7.0794001703106d-02,-4.8744720249643d-02,
     |   4.8744720249643d-02, 7.0794001703106d-02,-1.5446151911020d-02,
     |  -7.7596201710130d-02,-2.5868986878547d-02, 6.0969631722033d-02,
     |   6.6036616865467d-02,-7.9387444641727d-03,-7.1885498110098d-02,
     |  -7.6328419429345d-02,-4.4879116256118d-02,-1.6476287132293d-02,
     |  -3.7218182324843d-03,-4.7100424726158d-04,-2.7262876250419d-05,
     |  -4.6557061167130d-07,-1.1222786220228d-09, 1.4167129902409d-10/
      data (zmn(lat,13,19), lat = 1,36)/
     |   2.5848418999798d-10,-1.7967930160616d-10, 6.0499152506434d-08,
     |   5.0883437445555d-06, 1.1801604110253d-04, 1.2098528239481d-03,
     |   6.8737888269594d-03, 2.4302463730770d-02, 5.6242254109806d-02,
     |   8.4150774373012d-02, 6.9588643023747d-02,-9.8453521758991d-04,
     |  -7.1952209713454d-02,-6.1833763814563d-02, 2.5509047707404d-02,
     |   8.0405519847179d-02, 2.6117543159060d-02,-6.4873837366647d-02,
     |  -6.4873837366647d-02, 2.6117543159060d-02, 8.0405519847179d-02,
     |   2.5509047707404d-02,-6.1833763814563d-02,-7.1952209713454d-02,
     |  -9.8453521759018d-04, 6.9588643023747d-02, 8.4150774373012d-02,
     |   5.6242254109806d-02, 2.4302463730770d-02, 6.8737888269595d-03,
     |   1.2098528239482d-03, 1.1801604110255d-04, 5.0883437445921d-06,
     |   6.0499152367231d-08,-1.7967930663587d-10, 2.5848415713663d-10/
      data (zmn(lat,14,19), lat = 1,36)/
     |   5.4729348009352d-12,-1.1316649011483d-11, 6.8074515566479d-09,
     |   8.2306379466650d-07, 2.5473949342416d-05, 3.3569781275273d-04,
     |   2.4118237403456d-03, 1.0785978813659d-02, 3.2224557224545d-02,
     |   6.6019436338726d-02, 9.0220295245986d-02, 6.9079726844813d-02,
     |  -4.3595854878109d-03,-7.4840096850633d-02,-6.7672490251976d-02,
     |   1.6507812584099d-02, 8.1652109613785d-02, 4.6612811820344d-02,
     |  -4.6612811820344d-02,-8.1652109613785d-02,-1.6507812584100d-02,
     |   6.7672490251976d-02, 7.4840096850634d-02, 4.3595854878106d-03,
     |  -6.9079726844813d-02,-9.0220295245986d-02,-6.6019436338726d-02,
     |  -3.2224557224545d-02,-1.0785978813660d-02,-2.4118237403457d-03,
     |  -3.3569781275264d-04,-2.5473949342356d-05,-8.2306379462747d-07,
     |  -6.8074515426887d-09, 1.1316462400262d-11,-5.4729806059203d-12/
      data (zmn(lat,15,19), lat = 1,36)/
     |  -9.7639584968195d-12, 9.3162225196181d-12, 6.5049998538153d-10,
     |   1.1447357501679d-07, 4.7056841155825d-06, 7.9166716449179d-05,
     |   7.1172479436647d-04, 3.9588998347150d-03, 1.4823551535797d-02,
     |   3.9097753558177d-02, 7.3567134743622d-02, 9.5571165748635d-02,
     |   7.2778270450120d-02, 1.5985493544892d-04,-7.3351123096277d-02,
     |  -7.8915675421608d-02,-5.1014439649948d-03, 7.4383353063226d-02,
     |   7.4383353063226d-02,-5.1014439649946d-03,-7.8915675421608d-02,
     |  -7.3351123096277d-02, 1.5985493544886d-04, 7.2778270450120d-02,
     |   9.5571165748635d-02, 7.3567134743622d-02, 3.9097753558177d-02,
     |   1.4823551535797d-02, 3.9588998347149d-03, 7.1172479436635d-04,
     |   7.9166716449156d-05, 4.7056841156984d-06, 1.1447357508606d-07,
     |   6.5050012692018d-10, 9.3162356408633d-12,-9.7639527344985d-12/
      data (zmn(lat,16,19), lat = 1,36)/
     |  -1.5438149552791d-13, 4.4374791611110d-13, 5.3603516111440d-11,
     |   1.3479506517883d-08, 7.3333200906305d-07, 1.5666692330435d-05,
     |   1.7487852649053d-04, 1.1957413843453d-03, 5.5066205247684d-03,
     |   1.8086856811285d-02, 4.3709071320388d-02, 7.8250887029468d-02,
     |   1.0086249444374d-01, 8.2637653377321d-02, 1.5932485818307d-02,
     |  -6.2549111205180d-02,-9.1679104526914d-02,-4.3130528063159d-02,
     |   4.3130528063158d-02, 9.1679104526914d-02, 6.2549111205181d-02,
     |  -1.5932485818307d-02,-8.2637653377321d-02,-1.0086249444374d-01,
     |  -7.8250887029468d-02,-4.3709071320388d-02,-1.8086856811285d-02,
     |  -5.5066205247684d-03,-1.1957413843454d-03,-1.7487852649061d-04,
     |  -1.5666692330413d-05,-7.3333200902762d-07,-1.3479506468431d-08,
     |  -5.3603399682720d-11,-4.4367100556716d-13, 1.5441880808517d-13/
      data (zmn(lat,17,19), lat = 1,36)/
     |   2.4045335952523d-13,-2.2689803442689d-13, 3.8919455211641d-12,
     |   1.3066812909494d-09, 9.3823007594027d-08, 2.5346378509585d-06,
     |   3.4919711862918d-05, 2.9097701231442d-04, 1.6268643432919d-03,
     |   6.5185505799564d-03, 1.9513931442367d-02, 4.4689675688686d-02,
     |   7.8813893844500d-02, 1.0521794390099d-01, 9.8982275786884d-02,
     |   4.7150765852214d-02,-3.1357043950977d-02,-9.0487677300596d-02,
     |  -9.0487677300596d-02,-3.1357043950977d-02, 4.7150765852214d-02,
     |   9.8982275786884d-02, 1.0521794390099d-01, 7.8813893844500d-02,
     |   4.4689675688686d-02, 1.9513931442367d-02, 6.5185505799564d-03,
     |   1.6268643432919d-03, 2.9097701231443d-04, 3.4919711862931d-05,
     |   2.5346378510261d-06, 9.3823007517044d-08, 1.3066813205249d-09,
     |   3.8919167245579d-12,-2.2693225017100d-13, 2.4055157934683d-13/
      data (zmn(lat,18,19), lat = 1,36)/
     |   2.3528958658841d-15,-7.1981435600876d-15, 2.0629399075436d-13,
     |   9.8720393329374d-11, 9.3308622200291d-09, 3.1767824166792d-07,
     |   5.3764464079394d-06, 5.4239322387040d-05, 3.6472592215707d-04,
     |   1.7580139626777d-03, 6.3777242412123d-03, 1.7993818711545d-02,
     |   4.0309492186888d-02, 7.2424149703842d-02, 1.0410330225949d-01,
     |   1.1687931886267d-01, 9.4439264938845d-02, 3.6490036985735d-02,
     |  -3.6490036985735d-02,-9.4439264938845d-02,-1.1687931886267d-01,
     |  -1.0410330225949d-01,-7.2424149703842d-02,-4.0309492186888d-02,
     |  -1.7993818711545d-02,-6.3777242412123d-03,-1.7580139626777d-03,
     |  -3.6472592215709d-04,-5.4239322387019d-05,-5.3764464078701d-06,
     |  -3.1767824162324d-07,-9.3308621864548d-09,-9.8720367279973d-11,
     |  -2.0633245729153d-13, 7.2628132124819d-15,-2.3837044852435d-15/
      data (zmn(lat,19,19), lat = 1,36)/
     |  -2.5058352380763d-15, 2.2921156742004d-15, 4.7582334741571d-15,
     |   5.0518799005640d-12, 6.2697806476099d-10, 2.6827017464348d-08,
     |   5.5563660958070d-07, 6.7515413267601d-06, 5.4215977749495d-05,
     |   3.1122756868164d-04, 1.3483215189803d-03, 4.5818852684463d-03,
     |   1.2561423356862d-02, 2.8363987943409d-02, 5.3561213149532d-02,
     |   8.5524518184895d-02, 1.1636749814603d-01, 1.3557805357860d-01,
     |   1.3557805357860d-01, 1.1636749814603d-01, 8.5524518184895d-02,
     |   5.3561213149532d-02, 2.8363987943409d-02, 1.2561423356862d-02,
     |   4.5818852684463d-03, 1.3483215189803d-03, 3.1122756868162d-04,
     |   5.4215977749484d-05, 6.7515413267625d-06, 5.5563660959710d-07,
     |   2.6827017469189d-08, 6.2697813816729d-10, 5.0519146367509d-12,
     |   4.7902818329868d-15, 2.3462712860485d-15,-2.5841843024115d-15/
      data (zmn(lat, 0,20), lat = 1,36)/
     |   1.1207161355712d-02,-5.1473325403492d-03,-2.9352317145094d-02,
     |   2.6815862317549d-02, 2.3647605119897d-02,-4.3230917756710d-02,
     |  -8.7649386979794d-03, 5.4654507727296d-02,-1.6015205538318d-02,
     |  -5.2249135304263d-02, 4.0401374626484d-02, 3.8221099313894d-02,
     |  -6.0106965525204d-02,-1.3077323712260d-02, 6.7865039919401d-02,
     |  -1.6183253741089d-02,-6.2240812100248d-02, 4.3555550794440d-02,
     |   4.3555550794440d-02,-6.2240812100248d-02,-1.6183253741089d-02,
     |   6.7865039919401d-02,-1.3077323712260d-02,-6.0106965525204d-02,
     |   3.8221099313894d-02, 4.0401374626484d-02,-5.2249135304263d-02,
     |  -1.6015205538318d-02, 5.4654507727296d-02,-8.7649386979792d-03,
     |  -4.3230917756710d-02, 2.3647605119897d-02, 2.6815862317550d-02,
     |  -2.9352317145094d-02,-5.1473325403492d-03, 1.1207161355712d-02/
      data (zmn(lat, 1,20), lat = 1,36)/
     |   8.7287940714466d-03, 2.2241771099396d-02,-1.8624154195728d-02,
     |  -2.6552120824441d-02, 3.7278440762348d-02, 1.5327648825488d-02,
     |  -5.0447028442103d-02, 4.5860473253857d-03, 5.4917725472724d-02,
     |  -2.9896496411949d-02,-4.5845849328603d-02, 5.1803980812026d-02,
     |   2.6083117484956d-02,-6.5998807792913d-02, 2.1017974279418d-03,
     |   6.6566589676629d-02,-3.0603580801876d-02,-5.4489350258516d-02,
     |   5.4489350258516d-02, 3.0603580801877d-02,-6.6566589676629d-02,
     |  -2.1017974279421d-03, 6.5998807792913d-02,-2.6083117484956d-02,
     |  -5.1803980812026d-02, 4.5845849328603d-02, 2.9896496411949d-02,
     |  -5.4917725472724d-02,-4.5860473253861d-03, 5.0447028442104d-02,
     |  -1.5327648825488d-02,-3.7278440762348d-02, 2.6552120824441d-02,
     |   1.8624154195729d-02,-2.2241771099396d-02,-8.7287940714465d-03/
      data (zmn(lat, 2,20), lat = 1,36)/
     |   1.9049601900161d-03, 2.3814674349393d-02, 1.9940511631989d-02,
     |  -3.4229131438104d-02,-1.5576722351059d-02, 4.6752838419793d-02,
     |   5.9979731924199d-04,-5.3835256692220d-02, 2.1610422888276d-02,
     |   4.9950884527738d-02,-4.4154233544321d-02,-3.4905470260690d-02,
     |   6.1432960797625d-02, 1.0550391915768d-02,-6.8050729443305d-02,
     |   1.7727668818644d-02, 6.1958510619689d-02,-4.3880118492862d-02,
     |  -4.3880118492862d-02, 6.1958510619689d-02, 1.7727668818644d-02,
     |  -6.8050729443305d-02, 1.0550391915768d-02, 6.1432960797625d-02,
     |  -3.4905470260690d-02,-4.4154233544321d-02, 4.9950884527738d-02,
     |   2.1610422888276d-02,-5.3835256692220d-02, 5.9979731924168d-04,
     |   4.6752838419793d-02,-1.5576722351059d-02,-3.4229131438104d-02,
     |   1.9940511631989d-02, 2.3814674349393d-02, 1.9049601900159d-03/
      data (zmn(lat, 3,20), lat = 1,36)/
     |  -1.2178669897244d-05, 1.3030811335964d-02, 3.6577638575185d-02,
     |   5.1568256888252d-03,-4.4669599326490d-02, 2.0730917281579d-03,
     |   5.1056577868660d-02,-1.8582091048811d-02,-5.0364758065267d-02,
     |   3.8857430751829d-02, 3.9587547671690d-02,-5.6606584645618d-02,
     |  -1.9740557504056d-02, 6.6994651657167d-02,-6.1486652183569d-03,
     |  -6.6296115399899d-02, 3.2535988409921d-02, 5.4193973673772d-02,
     |  -5.4193973673772d-02,-3.2535988409922d-02, 6.6296115399899d-02,
     |   6.1486652183571d-03,-6.6994651657167d-02, 1.9740557504057d-02,
     |   5.6606584645618d-02,-3.9587547671690d-02,-3.8857430751830d-02,
     |   5.0364758065267d-02, 1.8582091048811d-02,-5.1056577868660d-02,
     |  -2.0730917281579d-03, 4.4669599326490d-02,-5.1568256888250d-03,
     |  -3.6577638575185d-02,-1.3030811335964d-02, 1.2178669897087d-05/
      data (zmn(lat, 4,20), lat = 1,36)/
     |   6.0064877431643d-06, 4.7460975452520d-03, 2.9318467132116d-02,
     |   3.9060137088413d-02,-1.6131360556507d-02,-4.6080810086057d-02,
     |   2.3339360756792d-02, 4.6921999003976d-02,-3.7999666303271d-02,
     |  -3.9820517214933d-02, 5.3568170062775d-02, 2.4393224246712d-02,
     |  -6.4889902571231d-02,-2.4209897802230d-03, 6.8001046008392d-02,
     |  -2.2242784232465d-02,-6.1128511824030d-02, 4.4900615724848d-02,
     |   4.4900615724848d-02,-6.1128511824030d-02,-2.2242784232465d-02,
     |   6.8001046008392d-02,-2.4209897802229d-03,-6.4889902571230d-02,
     |   2.4393224246712d-02, 5.3568170062775d-02,-3.9820517214933d-02,
     |  -3.7999666303271d-02, 4.6921999003976d-02, 2.3339360756792d-02,
     |  -4.6080810086057d-02,-1.6131360556508d-02, 3.9060137088413d-02,
     |   2.9318467132116d-02, 4.7460975452519d-03, 6.0064877433768d-06/
      data (zmn(lat, 5,20), lat = 1,36)/
     |   2.9921387976219d-05, 1.2970085761703d-03, 1.5919812519981d-02,
     |   4.4382439397143d-02, 2.9498857184718d-02,-3.7464478102772d-02,
     |  -3.6947839788925d-02, 4.3264374830338d-02, 3.4240761789619d-02,
     |  -5.3802186952316d-02,-2.3577149226979d-02, 6.3423334150855d-02,
     |   6.3877607824688d-03,-6.8024997305558d-02, 1.4748699512776d-02,
     |   6.5020758809405d-02,-3.6116233004740d-02,-5.3911662246368d-02,
     |   5.3911662246368d-02, 3.6116233004740d-02,-6.5020758809405d-02,
     |  -1.4748699512777d-02, 6.8024997305558d-02,-6.3877607824691d-03,
     |  -6.3423334150855d-02, 2.3577149226979d-02, 5.3802186952316d-02,
     |  -3.4240761789619d-02,-4.3264374830338d-02, 3.6947839788925d-02,
     |   3.7464478102772d-02,-2.9498857184718d-02,-4.4382439397143d-02,
     |  -1.5919812519981d-02,-1.2970085761702d-03,-2.9921387976132d-05/
      data (zmn(lat, 6,20), lat = 1,36)/
     |   1.5703185501570d-06, 2.9461916560720d-04, 6.6034198850684d-03,
     |   3.1767428972206d-02, 5.2362989532889d-02, 1.0253600310556d-02,
     |  -5.3027612586728d-02,-1.8949686662571d-02, 5.7389222609015d-02,
     |   1.5377042879090d-02,-6.3422892065406d-02,-4.2346110879267d-03,
     |   6.7392655284113d-02,-1.1809946903532d-02,-6.6517263970118d-02,
     |   2.9828623128334d-02, 5.9497617001569d-02,-4.6663884402338d-02,
     |  -4.6663884402338d-02, 5.9497617001568d-02, 2.9828623128334d-02,
     |  -6.6517263970118d-02,-1.1809946903532d-02, 6.7392655284112d-02,
     |  -4.2346110879263d-03,-6.3422892065406d-02, 1.5377042879089d-02,
     |   5.7389222609015d-02,-1.8949686662571d-02,-5.3027612586729d-02,
     |   1.0253600310556d-02, 5.2362989532889d-02, 3.1767428972206d-02,
     |   6.6034198850683d-03, 2.9461916560722d-04, 1.5703185500441d-06/
      data (zmn(lat, 7,20), lat = 1,36)/
     |  -2.6319466192225d-06, 5.8236919175430d-05, 2.2194096195336d-03,
     |   1.7099376045675d-02, 4.8067430355590d-02, 5.0206186137563d-02,
     |  -1.3839500252596d-02,-5.9193831986102d-02, 3.8812141736258d-03,
     |   6.3340778805755d-02,-6.0833394180334d-03,-6.6092834345385d-02,
     |   1.5170524998904d-02, 6.6071451857234d-02,-2.7920116012704d-02,
     |  -6.1968795115005d-02, 4.1525228077733d-02, 5.3497651276524d-02,
     |  -5.3497651276524d-02,-4.1525228077733d-02, 6.1968795115005d-02,
     |   2.7920116012705d-02,-6.6071451857233d-02,-1.5170524998904d-02,
     |   6.6092834345385d-02, 6.0833394180332d-03,-6.3340778805755d-02,
     |  -3.8812141736260d-03, 5.9193831986102d-02, 1.3839500252596d-02,
     |  -5.0206186137563d-02,-4.8067430355590d-02,-1.7099376045675d-02,
     |  -2.2194096195337d-03,-5.8236919175408d-05, 2.6319466192663d-06/
      data (zmn(lat, 8,20), lat = 1,36)/
     |  -9.0400873770210d-08, 9.1965746505380d-06, 6.2594461336693d-04,
     |   7.4167110207043d-03, 3.1798133062912d-02, 6.0318657213280d-02,
     |   3.8100076902661d-02,-3.7299352735320d-02,-5.5372187122304d-02,
     |   2.6918750301832d-02, 6.1207278382905d-02,-2.6583189709908d-02,
     |  -6.2880384688411d-02, 3.2116486373975d-02, 6.1325235889164d-02,
     |  -4.0478328071324d-02,-5.6619135989784d-02, 4.9266690678825d-02,
     |   4.9266690678825d-02,-5.6619135989784d-02,-4.0478328071324d-02,
     |   6.1325235889164d-02, 3.2116486373976d-02,-6.2880384688411d-02,
     |  -2.6583189709908d-02, 6.1207278382905d-02, 2.6918750301832d-02,
     |  -5.5372187122304d-02,-3.7299352735321d-02, 3.8100076902660d-02,
     |   6.0318657213280d-02, 3.1798133062912d-02, 7.4167110207043d-03,
     |   6.2594461336701d-04, 9.1965746505590d-06,-9.0400873763873d-08/
      data (zmn(lat, 9,20), lat = 1,36)/
     |   2.2690169971421d-07, 1.0422183017410d-06, 1.5110188026420d-04,
     |   2.6879139531212d-03, 1.6682005096882d-02, 4.8034762219192d-02,
     |   6.5447658738375d-02, 1.8848155601157d-02,-5.5798735676432d-02,
     |  -4.3623634254448d-02, 4.6503192686558d-02, 5.3070536013078d-02,
     |  -4.3591201824072d-02,-5.6162655850676d-02, 4.5138155482847d-02,
     |   5.5681281806156d-02,-4.8863057718641d-02,-5.2868056138403d-02,
     |   5.2868056138403d-02, 4.8863057718641d-02,-5.5681281806156d-02,
     |  -4.5138155482847d-02, 5.6162655850676d-02, 4.3591201824072d-02,
     |  -5.3070536013078d-02,-4.6503192686557d-02, 4.3623634254447d-02,
     |   5.5798735676432d-02,-1.8848155601157d-02,-6.5447658738375d-02,
     |  -4.8034762219192d-02,-1.6682005096882d-02,-2.6879139531212d-03,
     |  -1.5110188026405d-04,-1.0422183017533d-06,-2.2690169978684d-07/
      data (zmn(lat,10,20), lat = 1,36)/
     |   5.5395548879166d-09, 1.3677548221071d-07, 3.1531449350199d-05,
     |   8.3154437301099d-04, 7.2517238267524d-03, 2.9489786413777d-02,
     |   6.2668299196400d-02, 6.2642466687649d-02,-3.4754783093761d-03,
     |  -6.7251573245002d-02,-2.7497306230745d-02, 6.0799595646139d-02,
     |   4.2087511979312d-02,-5.6031545511154d-02,-4.8873578708249d-02,
     |   5.3799184128138d-02, 5.1768568839291d-02,-5.2879667336443d-02,
     |  -5.2879667336443d-02, 5.1768568839290d-02, 5.3799184128138d-02,
     |  -4.8873578708249d-02,-5.6031545511154d-02, 4.2087511979312d-02,
     |   6.0799595646139d-02,-2.7497306230745d-02,-6.7251573245002d-02,
     |  -3.4754783093763d-03, 6.2642466687649d-02, 6.2668299196400d-02,
     |   2.9489786413777d-02, 7.2517238267525d-03, 8.3154437301100d-04,
     |   3.1531449350095d-05, 1.3677548221534d-07, 5.5395549132321d-09/
      data (zmn(lat,11,20), lat = 1,36)/
     |  -1.7041560124087d-08, 3.1870035277472d-08, 5.7344754873845d-06,
     |   2.2245759545859d-04, 2.6752031951028d-03, 1.4789213818860d-02,
     |   4.4214467345612d-02, 7.3286955618384d-02, 5.3262283702331d-02,
     |  -2.4992187905842d-02,-7.1947114338516d-02,-1.0757376735874d-02,
     |   6.9862840018712d-02, 3.1582284741601d-02,-6.4075729454947d-02,
     |  -4.3901300633354d-02, 5.8156567654884d-02, 5.1924157187837d-02,
     |  -5.1924157187837d-02,-5.8156567654884d-02, 4.3901300633353d-02,
     |   6.4075729454947d-02,-3.1582284741601d-02,-6.9862840018712d-02,
     |   1.0757376735874d-02, 7.1947114338516d-02, 2.4992187905842d-02,
     |  -5.3262283702331d-02,-7.3286955618384d-02,-4.4214467345612d-02,
     |  -1.4789213818860d-02,-2.6752031951029d-03,-2.2245759545870d-04,
     |  -5.7344754874444d-06,-3.1870035218322d-08, 1.7041560103145d-08/
      data (zmn(lat,12,20), lat = 1,36)/
     |  -3.0105425800370d-10, 2.3041954996079d-09, 9.1952867275644d-07,
     |   5.1851339718009d-05, 8.4902322426841d-04, 6.2339678495820d-03,
     |   2.4953396735099d-02, 5.8823759914760d-02, 7.8957626173409d-02,
     |   4.0084771327356d-02,-4.3039989946996d-02,-7.1963323254655d-02,
     |   3.4810582971979d-03, 7.5091018310176d-02, 2.4515525953830d-02,
     |  -6.8433294299748d-02,-4.3783910377239d-02, 5.7801139836511d-02,
     |   5.7801139836512d-02,-4.3783910377239d-02,-6.8433294299748d-02,
     |   2.4515525953830d-02, 7.5091018310176d-02, 3.4810582971975d-03,
     |  -7.1963323254655d-02,-4.3039989946996d-02, 4.0084771327356d-02,
     |   7.8957626173409d-02, 5.8823759914760d-02, 2.4953396735099d-02,
     |   6.2339678495820d-03, 8.4902322426833d-04, 5.1851339717993d-05,
     |   9.1952867279418d-07, 2.3041954089759d-09,-3.0105424133872d-10/
      data (zmn(lat,13,20), lat = 1,36)/
     |   1.0748189414671d-09,-8.9533201411129d-10, 1.3059321787781d-07,
     |   1.0568033561580d-05, 2.3347693943862d-04, 2.2419271664193d-03,
     |   1.1675916504912d-02, 3.6689512796479d-02, 7.1646636566767d-02,
     |   8.0358668189092d-02, 2.6364043994824d-02,-5.6482856547219d-02,
     |  -7.0292678202596d-02, 1.2956622527927d-02, 7.8342456862098d-02,
     |   2.3443930110880d-02,-6.9256938394274d-02,-5.0505325442601d-02,
     |   5.0505325442601d-02, 6.9256938394274d-02,-2.3443930110879d-02,
     |  -7.8342456862098d-02,-1.2956622527927d-02, 7.0292678202597d-02,
     |   5.6482856547219d-02,-2.6364043994824d-02,-8.0358668189092d-02,
     |  -7.1646636566767d-02,-3.6689512796479d-02,-1.1675916504912d-02,
     |  -2.2419271664193d-03,-2.3347693943857d-04,-1.0568033561537d-05,
     |  -1.3059321795050d-07, 8.9533200637386d-10,-1.0748188877366d-09/
      data (zmn(lat,14,20), lat = 1,36)/
     |   1.3744123583677d-11,-2.8522990536780d-11, 1.6089663577290d-08,
     |   1.8836966753953d-06, 5.5757221347574d-05, 6.9256147511270d-04,
     |   4.6068298975443d-03, 1.8629982460371d-02, 4.8614862280421d-02,
     |   8.1881972950917d-02, 7.9423944947933d-02, 1.5148091239698d-02,
     |  -6.5335945403259d-02,-7.0041497352772d-02, 1.5809894190024d-02,
     |   8.0833705841419d-02, 3.0746912491945d-02,-6.4592867231691d-02,
     |  -6.4592867231691d-02, 3.0746912491945d-02, 8.0833705841419d-02,
     |   1.5809894190024d-02,-7.0041497352772d-02,-6.5335945403259d-02,
     |   1.5148091239698d-02, 7.9423944947933d-02, 8.1881972950917d-02,
     |   4.8614862280421d-02, 1.8629982460371d-02, 4.6068298975442d-03,
     |   6.9256147511270d-04, 5.5757221347702d-05, 1.8836966754138d-06,
     |   1.6089663572713d-08,-2.8523055865311d-11, 1.3744087137372d-11/
      data (zmn(lat,15,20), lat = 1,36)/
     |  -5.3456734525974d-11, 5.2004298702393d-11, 1.6851694463305d-09,
     |   2.9247453024890d-07, 1.1536220678337d-05, 1.8385936016712d-04,
     |   1.5421878189689d-03, 7.8526424911204d-03, 2.6236035960465d-02,
     |   5.9425338148391d-02, 8.9688591292184d-02, 7.8776933343522d-02,
     |   9.1153450166231d-03,-6.9850154988749d-02,-7.3770286809527d-02,
     |   9.6675346383835d-03, 8.1550942607573d-02, 4.8317908219307d-02,
     |  -4.8317908219307d-02,-8.1550942607573d-02,-9.6675346383839d-03,
     |   7.3770286809527d-02, 6.9850154988749d-02,-9.1153450166235d-03,
     |  -7.8776933343522d-02,-8.9688591292184d-02,-5.9425338148391d-02,
     |  -2.6236035960465d-02,-7.8526424911205d-03,-1.5421878189690d-03,
     |  -1.8385936016719d-04,-1.1536220678345d-05,-2.9247453015269d-07,
     |  -1.6851693031696d-09,-5.2004358243966d-11, 5.3456883548300d-11/
      data (zmn(lat,16,20), lat = 1,36)/
     |  -4.8338592575859d-13, 1.3796913489133d-12, 1.6022584512363d-10,
     |   3.9194532420071d-08, 2.0521143957900d-06, 4.1705946610835d-05,
     |   4.3701669163901d-04, 2.7607085154236d-03, 1.1512171580069d-02,
     |   3.3318618547134d-02, 6.8099598632560d-02, 9.5858486034193d-02,
     |   8.1181360898375d-02, 1.0957573809004d-02,-6.9086867694581d-02,
     |  -8.2517949046326d-02,-9.2031738663803d-03, 7.4485491729450d-02,
     |   7.4485491729451d-02,-9.2031738663801d-03,-8.2517949046326d-02,
     |  -6.9086867694581d-02, 1.0957573809004d-02, 8.1181360898375d-02,
     |   9.5858486034193d-02, 6.8099598632560d-02, 3.3318618547134d-02,
     |   1.1512171580069d-02, 2.7607085154236d-03, 4.3701669163909d-04,
     |   4.1705946610766d-05, 2.0521143956869d-06, 3.9194532447552d-08,
     |   1.6022598944355d-10, 1.3799036085374d-12,-4.8346886983287d-13/
      data (zmn(lat,17,20), lat = 1,36)/
     |   1.8844284726327d-12,-1.8281856324163d-12, 1.4664300763825d-11,
     |   4.4614693879991d-09, 3.0913380422938d-07, 7.9727155804039d-06,
     |   1.0362893506946d-04, 8.0359525057217d-04, 4.1127056135620d-03,
     |   1.4772389068993d-02, 3.8539265058680d-02, 7.3756901582912d-02,
     |   1.0110831536202d-01, 8.8971004995494d-02, 2.4057825008557d-02,
     |  -5.8781255053236d-02,-9.3123195990567d-02,-4.4731759882285d-02,
     |   4.4731759882285d-02, 9.3123195990567d-02, 5.8781255053236d-02,
     |  -2.4057825008557d-02,-8.8971004995494d-02,-1.0110831536202d-01,
     |  -7.3756901582912d-02,-3.8539265058680d-02,-1.4772389068993d-02,
     |  -4.1127056135620d-03,-8.0359525057221d-04,-1.0362893506947d-04,
     |  -7.9727155803218d-06,-3.0913380418563d-07,-4.4614694090965d-09,
     |  -1.4664358062047d-11, 1.8282074908364d-12,-1.8845230810229d-12/
      data (zmn(lat,18,20), lat = 1,36)/
     |   1.1103638943894d-14,-3.1717555837662d-14, 8.9953423103373d-13,
     |   4.1968601750660d-10, 3.8353785968272d-08, 1.2503875230667d-06,
     |   2.0049221469818d-05, 1.8933699726626d-04, 1.1752492697494d-03,
     |   5.1417748261220d-03, 1.6576449098665d-02, 4.0407529633264d-02,
     |   7.5107670474955d-02, 1.0486925639588d-01, 1.0287287395952d-01,
     |   5.2524060098742d-02,-2.8554178953242d-02,-9.1088417731493d-02,
     |  -9.1088417731493d-02,-2.8554178953242d-02, 5.2524060098742d-02,
     |   1.0287287395952d-01, 1.0486925639588d-01, 7.5107670474955d-02,
     |   4.0407529633264d-02, 1.6576449098665d-02, 5.1417748261220d-03,
     |   1.1752492697493d-03, 1.8933699726624d-04, 2.0049221469772d-05,
     |   1.2503875231097d-06, 3.8353786038199d-08, 4.1968609622856d-10,
     |   8.9959067101331d-13,-3.1696163574526d-14, 1.1174189126757d-14/
      data (zmn(lat,19,20), lat = 1,36)/
     |  -3.7232337535069d-14, 3.6236344988566d-14, 8.9502284688761d-15,
     |   3.0872510938350d-11, 3.7090030151114d-09, 1.5236783835782d-07,
     |   3.0006267029693d-06, 3.4297424883056d-05, 2.5594703746029d-04,
     |   1.3463356149076d-03, 5.2557236550391d-03, 1.5763500414273d-02,
     |   3.7139528081696d-02, 6.9502252686282d-02, 1.0312979099545d-01,
     |   1.1852755209539d-01, 9.7257095221960d-02, 3.7866998692807d-02,
     |  -3.7866998692807d-02,-9.7257095221960d-02,-1.1852755209539d-01,
     |  -1.0312979099545d-01,-6.9502252686282d-02,-3.7139528081696d-02,
     |  -1.5763500414273d-02,-5.2557236550391d-03,-1.3463356149076d-03,
     |  -2.5594703746029d-04,-3.4297424883057d-05,-3.0006267029334d-06,
     |  -1.5236783837123d-07,-3.7090030116719d-09,-3.0872506025619d-11,
     |  -8.9228177690838d-15,-3.6202993742851d-14, 3.7203390836543d-14/
      data (zmn(lat,20,20), lat = 1,36)/
     |  -3.2687134844911d-16, 9.2387355370248d-17, 8.7859023510302d-16,
     |   1.5378952997851d-12, 2.4291473048145d-10, 1.2541223997082d-08,
     |   3.0225208778210d-07, 4.1611367727528d-06, 3.7082804634180d-05,
     |   2.3231158989054d-04, 1.0829840317615d-03, 3.9123286921964d-03,
     |   1.1280535316011d-02, 2.6530447209642d-02, 5.1716823163567d-02,
     |   8.4534518250738d-02, 1.1680520504716d-01, 1.3713167426862d-01,
     |   1.3713167426862d-01, 1.1680520504716d-01, 8.4534518250738d-02,
     |   5.1716823163567d-02, 2.6530447209642d-02, 1.1280535316011d-02,
     |   3.9123286921965d-03, 1.0829840317615d-03, 2.3231158989054d-04,
     |   3.7082804634186d-05, 4.1611367727610d-06, 3.0225208778232d-07,
     |   1.2541223979311d-08, 2.4291471229563d-10, 1.5378720051436d-12,
     |   8.6161435999680d-16, 7.0494555931757d-17,-3.2204502855697d-16/
      data (zmn(lat, 0,21), lat = 1,36)/
     |   1.1078858120976d-02,-8.1069448584649d-03,-2.5352975154183d-02,
     |   3.4218718501703d-02, 8.0555600239927d-03,-4.6270303707249d-02,
     |   1.9433426767749d-02, 4.1712077293921d-02,-4.9280129858293d-02,
     |  -1.4003081266493d-02, 6.1412010308559d-02,-2.2500236524894d-02,
     |  -5.1687015215483d-02, 5.5961581967761d-02, 1.8743983045941d-02,
     |  -6.8382572220760d-02, 2.1846396537680d-02, 5.6510626687807d-02,
     |  -5.6510626687806d-02,-2.1846396537680d-02, 6.8382572220760d-02,
     |  -1.8743983045941d-02,-5.5961581967761d-02, 5.1687015215483d-02,
     |   2.2500236524895d-02,-6.1412010308559d-02, 1.4003081266493d-02,
     |   4.9280129858293d-02,-4.1712077293921d-02,-1.9433426767750d-02,
     |   4.6270303707249d-02,-8.0555600239928d-03,-3.4218718501703d-02,
     |   2.5352975154183d-02, 8.1069448584649d-03,-1.1078858120976d-02/
      data (zmn(lat, 1,21), lat = 1,36)/
     |   9.1596089874792d-03, 2.0705475873267d-02,-2.3958935134791d-02,
     |  -1.6806857304238d-02, 4.2827708942194d-02,-6.8354093328807d-03,
     |  -4.6125010743332d-02, 3.6719190153227d-02, 2.8824701903750d-02,
     |  -5.8370509641947d-02, 4.9133806411644d-03, 5.9348117841903d-02,
     |  -4.1513127500836d-02,-3.6809737708086d-02, 6.5423828884586d-02,
     |  -1.7738635425984d-03,-6.5622681081851d-02, 4.1210625747825d-02,
     |   4.1210625747825d-02,-6.5622681081851d-02,-1.7738635425988d-03,
     |   6.5423828884586d-02,-3.6809737708086d-02,-4.1513127500835d-02,
     |   5.9348117841903d-02, 4.9133806411642d-03,-5.8370509641947d-02,
     |   2.8824701903750d-02, 3.6719190153227d-02,-4.6125010743332d-02,
     |  -6.8354093328809d-03, 4.2827708942194d-02,-1.6806857304238d-02,
     |  -2.3958935134791d-02, 2.0705475873268d-02, 9.1596089874791d-03/
      data (zmn(lat, 2,21), lat = 1,36)/
     |   2.1477459911928d-03, 2.4899853658454d-02, 1.4058156316123d-02,
     |  -3.8348057265933d-02, 8.4910629564802d-04, 4.5742635001013d-02,
     |  -2.6739576896624d-02,-3.6888012535528d-02, 5.1912937806050d-02,
     |   9.4192816521505d-03,-6.1540857237803d-02, 2.6401263774937d-02,
     |   4.9473666912503d-02,-5.7206879330966d-02,-1.7149811869561d-02,
     |   6.8776421749409d-02,-2.2977179557319d-02,-5.6189956005951d-02,
     |   5.6189956005951d-02, 2.2977179557319d-02,-6.8776421749409d-02,
     |   1.7149811869560d-02, 5.7206879330966d-02,-4.9473666912503d-02,
     |  -2.6401263774938d-02, 6.1540857237803d-02,-9.4192816521503d-03,
     |  -5.1912937806050d-02, 3.6888012535528d-02, 2.6739576896624d-02,
     |  -4.5742635001013d-02,-8.4910629564798d-04, 3.8348057265933d-02,
     |  -1.4058156316123d-02,-2.4899853658454d-02,-2.1477459911927d-03/
      data (zmn(lat, 3,21), lat = 1,36)/
     |   1.4711695289846d-05, 1.4631796843377d-02, 3.5941990578205d-02,
     |  -5.9019453988932d-03,-4.2631153701679d-02, 2.3325029701217d-02,
     |   3.8464659371259d-02,-4.5884859322012d-02,-1.8338765117856d-02,
     |   6.0242730080528d-02,-1.3780367166530d-02,-5.6457274745090d-02,
     |   4.6519038870059d-02, 3.2532189178897d-02,-6.6723031863576d-02,
     |   4.6377199189237d-03, 6.5343236438015d-02,-4.1850525862021d-02,
     |  -4.1850525862021d-02, 6.5343236438015d-02, 4.6377199189241d-03,
     |  -6.6723031863576d-02, 3.2532189178897d-02, 4.6519038870058d-02,
     |  -5.6457274745090d-02,-1.3780367166530d-02, 6.0242730080528d-02,
     |  -1.8338765117856d-02,-4.5884859322013d-02, 3.8464659371259d-02,
     |   2.3325029701217d-02,-4.2631153701679d-02,-5.9019453988934d-03,
     |   3.5941990578205d-02, 1.4631796843377d-02, 1.4711695289970d-05/
      data (zmn(lat, 4,21), lat = 1,36)/
     |   5.6223095914389d-06, 5.6771683999871d-03, 3.2121620905665d-02,
     |   3.3007844709571d-02,-2.9728910093088d-02,-3.3569016992433d-02,
     |   4.4162801527606d-02, 2.0071112969629d-02,-5.7784680073881d-02,
     |   6.0090918601742d-03, 5.9072917863761d-02,-3.6856943272096d-02,
     |  -4.2851092697369d-02, 6.1300536993613d-02, 1.1408188434211d-02,
     |  -6.9035194719888d-02, 2.5654210287395d-02, 5.5956015570391d-02,
     |  -5.5956015570391d-02,-2.5654210287395d-02, 6.9035194719888d-02,
     |  -1.1408188434211d-02,-6.1300536993613d-02, 4.2851092697370d-02,
     |   3.6856943272097d-02,-5.9072917863761d-02,-6.0090918601744d-03,
     |   5.7784680073881d-02,-2.0071112969629d-02,-4.4162801527606d-02,
     |   3.3569016992433d-02, 2.9728910093088d-02,-3.3007844709571d-02,
     |  -3.2121620905665d-02,-5.6771683999872d-03,-5.6223095915572d-06/
      data (zmn(lat, 5,21), lat = 1,36)/
     |   3.4156262707894d-05, 1.6453602692542d-03, 1.8868399872389d-02,
     |   4.5790933105087d-02, 1.5704482291576d-02,-4.8073261911962d-02,
     |  -1.2432813892505d-02, 5.6251607584822d-02,-5.4920312838954d-03,
     |  -5.8690197558932d-02, 3.1152874766678d-02, 4.8031095473154d-02,
     |  -5.5426373447438d-02,-2.3163268701092d-02, 6.8692882573400d-02,
     |  -1.0503277776836d-02,-6.4646738302873d-02, 4.3157213683524d-02,
     |   4.3157213683524d-02,-6.4646738302873d-02,-1.0503277776836d-02,
     |   6.8692882573400d-02,-2.3163268701092d-02,-5.5426373447438d-02,
     |   4.8031095473154d-02, 3.1152874766678d-02,-5.8690197558931d-02,
     |  -5.4920312838957d-03, 5.6251607584823d-02,-1.2432813892505d-02,
     |  -4.8073261911962d-02, 1.5704482291576d-02, 4.5790933105087d-02,
     |   1.8868399872389d-02, 1.6453602692545d-03, 3.4156262707823d-05/
      data (zmn(lat, 6,21), lat = 1,36)/
     |   2.3477950001416d-06, 3.9357985862574d-04, 8.3829898594903d-03,
     |   3.6539691378734d-02, 4.8270409556867d-02,-1.0440771808329d-02,
     |  -5.4090376242574d-02, 1.4994884187900d-02, 5.5542251117599d-02,
     |  -3.1931200699203d-02,-4.8271943265272d-02, 5.2022177171892d-02,
     |   2.9444127745089d-02,-6.6604758993466d-02,-1.1357326373784d-03,
     |   6.8725789408741d-02,-3.0060452148120d-02,-5.5677289985424d-02,
     |   5.5677289985424d-02, 3.0060452148120d-02,-6.8725789408741d-02,
     |   1.1357326373782d-03, 6.6604758993466d-02,-2.9444127745090d-02,
     |  -5.2022177171893d-02, 4.8271943265272d-02, 3.1931200699203d-02,
     |  -5.5542251117599d-02,-1.4994884187901d-02, 5.4090376242574d-02,
     |   1.0440771808329d-02,-4.8270409556867d-02,-3.6539691378734d-02,
     |  -8.3829898594905d-03,-3.9357985862561d-04,-2.3477950000096d-06/
      data (zmn(lat, 7,21), lat = 1,36)/
     |  -3.1543253941849d-06, 8.1793062109654d-05, 3.0051065098477d-03,
     |   2.1417223578897d-02, 5.2308702296892d-02, 3.7011281224155d-02,
     |  -3.7106034499440d-02,-4.5607086783280d-02, 4.1061702921371d-02,
     |   4.2390083317859d-02,-5.3283398430866d-02,-2.9306581167712d-02,
     |   6.5187551010637d-02, 7.3376152880163d-03,-6.9876977406969d-02,
     |   1.9573638373112d-02, 6.3246464717544d-02,-4.5192806067960d-02,
     |  -4.5192806067961d-02, 6.3246464717544d-02, 1.9573638373112d-02,
     |  -6.9876977406969d-02, 7.3376152880163d-03, 6.5187551010637d-02,
     |  -2.9306581167711d-02,-5.3283398430866d-02, 4.2390083317859d-02,
     |   4.1061702921371d-02,-4.5607086783280d-02,-3.7106034499440d-02,
     |   3.7011281224155d-02, 5.2308702296892d-02, 2.1417223578897d-02,
     |   3.0051065098477d-03, 8.1793062109420d-05,-3.1543253941131d-06/
      data (zmn(lat, 8,21), lat = 1,36)/
     |  -1.5773376906275d-07, 1.3842102881063d-05, 9.0250430934292d-04,
     |   1.0024123786860d-02, 3.8653809895738d-02, 6.0013796566632d-02,
     |   1.4550343797271d-02,-5.6551827495042d-02,-2.5353328981259d-02,
     |   5.9462657623803d-02, 2.0692259604988d-02,-6.5886536749651d-02,
     |  -6.3669372194302d-03, 6.9852667697554d-02,-1.4150558895768d-02,
     |  -6.6887985459912d-02, 3.6362009670512d-02, 5.5255850078272d-02,
     |  -5.5255850078272d-02,-3.6362009670512d-02, 6.6887985459912d-02,
     |   1.4150558895768d-02,-6.9852667697554d-02, 6.3669372194307d-03,
     |   6.5886536749651d-02,-2.0692259604988d-02,-5.9462657623803d-02,
     |   2.5353328981259d-02, 5.6551827495043d-02,-1.4550343797270d-02,
     |  -6.0013796566632d-02,-3.8653809895738d-02,-1.0024123786861d-02,
     |  -9.0250430934282d-04,-1.3842102881177d-05, 1.5773376903086d-07/
      data (zmn(lat, 9,21), lat = 1,36)/
     |   2.9140255377232d-07, 1.7305094519287d-06, 2.3210585891332d-04,
     |   3.9058443214824d-03, 2.2234980783627d-02, 5.5640419183293d-02,
     |   5.6363873510674d-02,-1.3177718475561d-02,-6.4312152265988d-02,
     |   8.9441486546493d-04, 6.7229406423975d-02,-4.1055644937656d-03,
     |  -6.9196604236928d-02, 1.5955400143628d-02, 6.7681149894561d-02,
     |  -3.1985207409219d-02,-6.0652280236120d-02, 4.8065125362766d-02,
     |   4.8065125362766d-02,-6.0652280236120d-02,-3.1985207409219d-02,
     |   6.7681149894561d-02, 1.5955400143629d-02,-6.9196604236928d-02,
     |  -4.1055644937662d-03, 6.7229406423975d-02, 8.9441486546508d-04,
     |  -6.4312152265988d-02,-1.3177718475561d-02, 5.6363873510674d-02,
     |   5.5640419183293d-02, 2.2234980783627d-02, 3.9058443214825d-03,
     |   2.3210585891335d-04, 1.7305094520412d-06, 2.9140255374573d-07/
      data (zmn(lat,10,21), lat = 1,36)/
     |   1.1298391537412d-08, 2.2590506907262d-07, 5.1717273029588d-05,
     |   1.2981008984025d-03, 1.0518540046387d-02, 3.8302435200120d-02,
     |   6.7669798792746d-02, 4.1876996432088d-02,-3.9540989485206d-02,
     |  -6.0119020459896d-02, 2.6956530584991d-02, 6.5021102756405d-02,
     |  -2.7098431234128d-02,-6.5354547893205d-02, 3.4404068500915d-02,
     |   6.1869737088091d-02,-4.4683700361340d-02,-5.4618112127637d-02,
     |   5.4618112127637d-02, 4.4683700361340d-02,-6.1869737088091d-02,
     |  -3.4404068500915d-02, 6.5354547893205d-02, 2.7098431234128d-02,
     |  -6.5021102756405d-02,-2.6956530584991d-02, 6.0119020459896d-02,
     |   3.9540989485206d-02,-4.1876996432087d-02,-6.7669798792747d-02,
     |  -3.8302435200120d-02,-1.0518540046387d-02,-1.2981008984026d-03,
     |  -5.1717273029843d-05,-2.2590506905826d-07,-1.1298391474214d-08/
      data (zmn(lat,11,21), lat = 1,36)/
     |  -2.3710835330542d-08, 5.0183694710837d-08, 1.0070278873525d-05,
     |   3.7351721461362d-04, 4.2121672184476d-03, 2.1235448389929d-02,
     |   5.5288228869072d-02, 7.1724234283774d-02, 2.0114395625468d-02,
     |  -5.9644472818225d-02,-4.7063224757378d-02, 4.8377666533535d-02,
     |   5.6097626290820d-02,-4.5259922518501d-02,-5.8013808289520d-02,
     |   4.7502833171523d-02, 5.6080551048491d-02,-5.1953823551237d-02,
     |  -5.1953823551237d-02, 5.6080551048490d-02, 4.7502833171523d-02,
     |  -5.8013808289520d-02,-4.5259922518501d-02, 5.6097626290820d-02,
     |   4.8377666533535d-02,-4.7063224757378d-02,-5.9644472818225d-02,
     |   2.0114395625467d-02, 7.1724234283774d-02, 5.5288228869072d-02,
     |   2.1235448389929d-02, 4.2121672184476d-03, 3.7351721461363d-04,
     |   1.0070278873464d-05, 5.0183694659866d-08,-2.3710835433856d-08/
      data (zmn(lat,12,21), lat = 1,36)/
     |  -7.3104230303590d-10, 4.8798890118872d-09, 1.7326870451233d-06,
     |   9.3906820538487d-05, 1.4519316039251d-03, 9.8440274809183d-03,
     |   3.5213005028249d-02, 6.9950809383383d-02, 6.7421795926076d-02,
     |  -4.0987719517667d-03,-7.1575420904819d-02,-2.9828700322411d-02,
     |   6.3353247972932d-02, 4.4793779265980d-02,-5.7684667379081d-02,
     |  -5.1144994354643d-02, 5.5090588868135d-02, 5.3662202639596d-02,
     |  -5.3662202639596d-02,-5.5090588868135d-02, 5.1144994354643d-02,
     |   5.7684667379081d-02,-4.4793779265980d-02,-6.3353247972932d-02,
     |   2.9828700322411d-02, 7.1575420904819d-02, 4.0987719517669d-03,
     |  -6.7421795926076d-02,-6.9950809383383d-02,-3.5213005028249d-02,
     |  -9.8440274809184d-03,-1.4519316039251d-03,-9.3906820538266d-05,
     |  -1.7326870449855d-06,-4.8798889075249d-09, 7.3104241155561d-10/
      data (zmn(lat,13,21), lat = 1,36)/
     |   1.6510647759652d-09,-1.2598051185119d-09, 2.6524017701492d-07,
     |   2.0736925877226d-05, 4.3496236352306d-04, 3.8920885510556d-03,
     |   1.8418933901285d-02, 5.0588918547092d-02, 8.0059847303620d-02,
     |   5.6786364276490d-02,-2.6478016226299d-02,-7.6310892217490d-02,
     |  -1.3008354391119d-02, 7.2457460729173d-02, 3.5292317967921d-02,
     |  -6.4886921436255d-02,-4.8287500328102d-02, 5.7167263507054d-02,
     |   5.7167263507055d-02,-4.8287500328102d-02,-6.4886921436256d-02,
     |   3.5292317967921d-02, 7.2457460729173d-02,-1.3008354391120d-02,
     |  -7.6310892217490d-02,-2.6478016226299d-02, 5.6786364276490d-02,
     |   8.0059847303620d-02, 5.0588918547092d-02, 1.8418933901285d-02,
     |   3.8920885510556d-03, 4.3496236352324d-04, 2.0736925877232d-05,
     |   2.6524017713536d-07,-1.2598051702508d-09, 1.6510649159983d-09/
      data (zmn(lat,14,21), lat = 1,36)/
     |   4.0764900814235d-11,-9.2470626409895d-11, 3.5660732612471d-08,
     |   4.0305022078315d-06, 1.1377676985993d-04, 1.3262488563434d-03,
     |   8.1116706233245d-03, 2.9313488174108d-02, 6.5272628418189d-02,
     |   8.5136868735688d-02, 4.3255846064495d-02,-4.4355602943921d-02,
     |  -7.6751247207805d-02,-1.9342582485977d-04, 7.7593510379722d-02,
     |   3.1115378115800d-02,-6.7469351299379d-02,-5.2220119462304d-02,
     |   5.2220119462304d-02, 6.7469351299379d-02,-3.1115378115799d-02,
     |  -7.7593510379722d-02, 1.9342582485962d-04, 7.6751247207805d-02,
     |   4.4355602943921d-02,-4.3255846064495d-02,-8.5136868735688d-02,
     |  -6.5272628418189d-02,-2.9313488174108d-02,-8.1116706233244d-03,
     |  -1.3262488563434d-03,-1.1377676985993d-04,-4.0305022079210d-06,
     |  -3.5660732618653d-08, 9.2470656419306d-11,-4.0765043871439d-11/
      data (zmn(lat,15,21), lat = 1,36)/
     |  -9.3534922896752d-11, 8.9062292577580d-11, 4.1341554416266d-09,
     |   6.8866492646238d-07, 2.6001897882526d-05, 3.9109946682565d-04,
     |   3.0432384184961d-03, 1.4056735915137d-02, 4.1251962326134d-02,
     |   7.7744914185786d-02, 8.6454367768052d-02, 3.0596959051419d-02,
     |  -5.6760522957115d-02,-7.6518187483239d-02, 5.9510809895973d-03,
     |   8.0563948822773d-02, 3.5232221985483d-02,-6.4281092867203d-02,
     |  -6.4281092867203d-02, 3.5232221985483d-02, 8.0563948822773d-02,
     |   5.9510809895975d-03,-7.6518187483239d-02,-5.6760522957115d-02,
     |   3.0596959051418d-02, 8.6454367768053d-02, 7.7744914185786d-02,
     |   4.1251962326135d-02, 1.4056735915137d-02, 3.0432384184962d-03,
     |   3.9109946682568d-04, 2.6001897882452d-05, 6.8866492645877d-07,
     |   4.1341552538841d-09, 8.9062323773382d-11,-9.3534964038284d-11/
      data (zmn(lat,16,21), lat = 1,36)/
     |  -1.8267260180601d-12, 5.2455305258323d-12, 4.3086104193313d-10,
     |   1.0291046970009d-07, 5.1733516501688d-06, 9.9686710665116d-05,
     |   9.7579712738451d-04, 5.6535262439768d-03, 2.1100318577031d-02,
     |   5.2732513695485d-02, 8.7485045717491d-02, 8.6505018378275d-02,
     |   2.2279598422752d-02,-6.3610532889601d-02,-7.8892228408040d-02,
     |   2.8105737755429d-03, 8.1222973673391d-02, 4.9985790236630d-02,
     |  -4.9985790236630d-02,-8.1222973673392d-02,-2.8105737755434d-03,
     |   7.8892228408040d-02, 6.3610532889601d-02,-2.2279598422752d-02,
     |  -8.6505018378275d-02,-8.7485045717491d-02,-5.2732513695485d-02,
     |  -2.1100318577031d-02,-5.6535262439768d-03,-9.7579712738467d-04,
     |  -9.9686710665032d-05,-5.1733516501389d-06,-1.0291046964870d-07,
     |  -4.3086099948751d-10,-5.2457155040172d-12, 1.8267031803679d-12/
      data (zmn(lat,17,21), lat = 1,36)/
     |   3.9805898597569d-12,-3.7711050839137d-12, 4.3100962273884d-11,
     |   1.3320733074907d-08, 8.8848133551353d-07, 2.1810257356663d-05,
     |   2.6632221986601d-04, 1.9101466866651d-03, 8.8669324857543d-03,
     |   2.8139855906654d-02, 6.2391487402455d-02, 9.4865332314503d-02,
     |   8.8279544087926d-02, 2.1542891168104d-02,-6.4179770097660d-02,
     |  -8.5637897031788d-02,-1.3259213804731d-02, 7.4550256358192d-02,
     |   7.4550256358192d-02,-1.3259213804731d-02,-8.5637897031788d-02,
     |  -6.4179770097660d-02, 2.1542891168104d-02, 8.8279544087926d-02,
     |   9.4865332314503d-02, 6.2391487402455d-02, 2.8139855906654d-02,
     |   8.8669324857544d-03, 1.9101466866650d-03, 2.6632221986586d-04,
     |   2.1810257356575d-05, 8.8848133557028d-07, 1.3320733140152d-08,
     |   4.3101128103524d-11,-3.7710858552384d-12, 3.9806223245092d-12/
      data (zmn(lat,18,21), lat = 1,36)/
     |   5.8903205390674d-14,-1.6808399037619d-13, 3.3217836319611d-12,
     |   1.4700701119515d-09, 1.2965240237704d-07, 4.0364873361383d-06,
     |   6.1088697048832d-05, 5.3718785869450d-04, 3.0548591898199d-03,
     |   1.1996559919771d-02, 3.3774287535838d-02, 6.9049709681943d-02,
     |   1.0051094280485d-01, 9.4492011731772d-02, 3.1980554188969d-02,
     |  -5.4783595247298d-02,-9.4390112070530d-02,-4.6304161906745d-02,
     |   4.6304161906745d-02, 9.4390112070530d-02, 5.4783595247298d-02,
     |  -3.1980554188969d-02,-9.4492011731772d-02,-1.0051094280485d-01,
     |  -6.9049709681943d-02,-3.3774287535838d-02,-1.1996559919771d-02,
     |  -3.0548591898199d-03,-5.3718785869454d-04,-6.1088697048885d-05,
     |  -4.0364873361547d-06,-1.2965240237019d-07,-1.4700701106652d-09,
     |  -3.3216902148451d-12, 1.6818522550963d-13,-5.8847687648509d-14/
      data (zmn(lat,19,21), lat = 1,36)/
     |  -1.0950210348950d-13, 1.0469621351072d-13, 9.9728623761547d-14,
     |   1.3445708372562d-10, 1.5626602123426d-08, 6.1479063181559d-07,
     |   1.1472799399903d-05, 1.2278497748677d-04, 8.4610589295431d-04,
     |   4.0417267688848d-03, 1.4031170867383d-02, 3.6401182469151d-02,
     |   7.1295722499337d-02, 1.0406407227148d-01, 1.0631372907338d-01,
     |   5.7728924839229d-02,-2.5720453983183d-02,-9.1644299747893d-02,
     |  -9.1644299747893d-02,-2.5720453983183d-02, 5.7728924839228d-02,
     |   1.0631372907338d-01, 1.0406407227148d-01, 7.1295722499337d-02,
     |   3.6401182469151d-02, 1.4031170867383d-02, 4.0417267688848d-03,
     |   8.4610589295424d-04, 1.2278497748679d-04, 1.1472799399863d-05,
     |   6.1479063181124d-07, 1.5626601988192d-08, 1.3445705013098d-10,
     |   9.9638694610090d-14, 1.0459780930548d-13,-1.0942425820966d-13/
      data (zmn(lat,20,21), lat = 1,36)/
     |  -1.1080662915583d-15, 3.0131519550236d-15, 4.9092012821455d-15,
     |   9.6210280052941d-12, 1.4716435040564d-09, 7.2946271604874d-08,
     |   1.6716014064089d-06, 2.1647755461707d-05, 1.7928241151145d-04,
     |   1.0291731581762d-03, 4.3231809014985d-03, 1.3784343482417d-02,
     |   3.4156199152262d-02, 6.6576116603743d-02, 1.0197832427741d-01,
     |   1.1997895098117d-01, 9.9975616906015d-02, 3.9223971785016d-02,
     |  -3.9223971785016d-02,-9.9975616906015d-02,-1.1997895098117d-01,
     |  -1.0197832427741d-01,-6.6576116603743d-02,-3.4156199152262d-02,
     |  -1.3784343482418d-02,-4.3231809014985d-03,-1.0291731581762d-03,
     |  -1.7928241151150d-04,-2.1647755461679d-05,-1.6716014063080d-06,
     |  -7.2946271573658d-08,-1.4716435019284d-09,-9.6210184610479d-12,
     |  -4.9779730753135d-15,-2.9757060690973d-15, 1.0822765715598d-15/
      data (zmn(lat,21,21), lat = 1,36)/
     |   1.2106903294048d-15,-1.2979765231878d-15, 1.3445051049774d-15,
     |   4.6665454047995d-13, 9.4060703245286d-11, 5.8594252967422d-09,
     |   1.6432188896419d-07, 2.5631185936089d-06, 2.5349272602745d-05,
     |   1.7330510027248d-04, 8.6935727016702d-04, 3.3386747227341d-03,
     |   1.0124374843897d-02, 2.4801017524795d-02, 4.9906937846076d-02,
     |   8.3507441454052d-02, 1.1717645229545d-01, 1.3862252718471d-01,
     |   1.3862252718471d-01, 1.1717645229545d-01, 8.3507441454053d-02,
     |   4.9906937846076d-02, 2.4801017524795d-02, 1.0124374843897d-02,
     |   3.3386747227341d-03, 8.6935727016702d-04, 1.7330510027248d-04,
     |   2.5349272602762d-05, 2.5631185936124d-06, 1.6432188896142d-07,
     |   5.8594252792070d-09, 9.4060755988382d-11, 4.6668864832573d-13,
     |   1.3983365566647d-15,-1.2068707532352d-15, 1.1476824993559d-15/
      data (zmn(lat, 0,22), lat = 1,36)/
     |   1.0923465429538d-02,-1.0923563225714d-02,-2.0138173331166d-02,
     |   3.8436546675827d-02,-8.7673115862698d-03,-3.8831312020279d-02,
     |   4.1536664343455d-02, 1.1511851491326d-02,-5.6631867205269d-02,
     |   3.3334649797354d-02, 3.4348820655174d-02,-6.2394553571043d-02,
     |   1.2387994079437d-02, 5.5897730557032d-02,-5.6596812798419d-02,
     |  -1.3410087589409d-02, 6.7943961154348d-02,-3.8628003785016d-02,
     |  -3.8628003785016d-02, 6.7943961154348d-02,-1.3410087589409d-02,
     |  -5.6596812798419d-02, 5.5897730557032d-02, 1.2387994079436d-02,
     |  -6.2394553571043d-02, 3.4348820655174d-02, 3.3334649797354d-02,
     |  -5.6631867205270d-02, 1.1511851491326d-02, 4.1536664343455d-02,
     |  -3.8831312020279d-02,-8.7673115862699d-03, 3.8436546675827d-02,
     |  -2.0138173331166d-02,-1.0923563225714d-02, 1.0923465429538d-02/
      data (zmn(lat, 1,22), lat = 1,36)/
     |   1.0114899063731d-02, 1.8321407088464d-02,-2.7668543484899d-02,
     |  -6.0597857971696d-03, 4.2448132934123d-02,-2.7989108951720d-02,
     |  -2.6893008543757d-02, 5.3195055910848d-02,-1.1849933862702d-02,
     |  -4.9563113537759d-02, 5.2356218373914d-02, 1.1497834265309d-02,
     |  -6.3921107378021d-02, 3.7271944130649d-02, 3.7802593968004d-02,
     |  -6.7857057799931d-02, 1.3984055821924d-02, 5.7556131583627d-02,
     |  -5.7556131583627d-02,-1.3984055821925d-02, 6.7857057799931d-02,
     |  -3.7802593968003d-02,-3.7271944130649d-02, 6.3921107378021d-02,
     |  -1.1497834265308d-02,-5.2356218373914d-02, 4.9563113537759d-02,
     |   1.1849933862702d-02,-5.3195055910848d-02, 2.6893008543756d-02,
     |   2.7989108951720d-02,-4.2448132934123d-02, 6.0597857971692d-03,
     |   2.7668543484899d-02,-1.8321407088464d-02,-1.0114899063731d-02/
      data (zmn(lat, 2,22), lat = 1,36)/
     |   2.4039002317487d-03, 2.5760557660030d-02, 7.6239501953291d-03,
     |  -3.9215472343674d-02, 1.7145845586911d-02, 3.4729777267994d-02,
     |  -4.5879273711834d-02,-4.9439094045982d-03, 5.5244715117800d-02,
     |  -3.7155077142459d-02,-3.1082112852241d-02, 6.3373550446324d-02,
     |  -1.5542625576844d-02,-5.4501319772535d-02, 5.7670483701331d-02,
     |   1.2167042948236d-02,-6.7956526461796d-02, 3.8942338823881d-02,
     |   3.8942338823881d-02,-6.7956526461796d-02, 1.2167042948235d-02,
     |   5.7670483701331d-02,-5.4501319772535d-02,-1.5542625576844d-02,
     |   6.3373550446324d-02,-3.1082112852241d-02,-3.7155077142459d-02,
     |   5.5244715117800d-02,-4.9439094045978d-03,-4.5879273711834d-02,
     |   3.4729777267994d-02, 1.7145845586911d-02,-3.9215472343674d-02,
     |   7.6239501953289d-03, 2.5760557660030d-02, 2.4039002317487d-03/
      data (zmn(lat, 3,22), lat = 1,36)/
     |  -7.4512633930041d-05, 1.6376495859604d-02, 3.4162388383099d-02,
     |  -1.6396630217931d-02,-3.4981225907980d-02, 3.9803609448569d-02,
     |   1.4349371714914d-02,-5.4791601452761d-02, 2.2913693499904d-02,
     |   4.3438948583658d-02,-5.6600044265409d-02,-4.5531451301176d-03,
     |   6.2960549460180d-02,-4.1690732191856d-02,-3.4469126361488d-02,
     |   6.8378840012003d-02,-1.5408680120022d-02,-5.7713371141901d-02,
     |   5.7713371141901d-02, 1.5408680120022d-02,-6.8378840012003d-02,
     |   3.4469126361488d-02, 4.1690732191857d-02,-6.2960549460181d-02,
     |   4.5531451301172d-03, 5.6600044265409d-02,-4.3438948583658d-02,
     |  -2.2913693499904d-02, 5.4791601452761d-02,-1.4349371714913d-02,
     |  -3.9803609448569d-02, 3.4981225907980d-02, 1.6396630217931d-02,
     |  -3.4162388383099d-02,-1.6376495859604d-02, 7.4512633929997d-05/
      data (zmn(lat, 4,22), lat = 1,36)/
     |   5.4247657677560d-06, 6.7067557452357d-03, 3.4496782133655d-02,
     |   2.5014982031666d-02,-3.9743691954710d-02,-1.4540851849231d-02,
     |   5.2435160483222d-02,-1.4466484942880d-02,-4.8691339201648d-02,
     |   4.8009952741897d-02, 1.9642692332371d-02,-6.4620528312810d-02,
     |   2.4550043697046d-02, 5.0117354624460d-02,-6.0913808911363d-02,
     |  -8.1763555657553d-03, 6.7836929364928d-02,-3.9863848242782d-02,
     |  -3.9863848242783d-02, 6.7836929364928d-02,-8.1763555657547d-03,
     |  -6.0913808911363d-02, 5.0117354624460d-02, 2.4550043697045d-02,
     |  -6.4620528312810d-02, 1.9642692332371d-02, 4.8009952741897d-02,
     |  -4.8691339201648d-02,-1.4466484942880d-02, 5.2435160483222d-02,
     |  -1.4540851849231d-02,-3.9743691954710d-02, 2.5014982031666d-02,
     |   3.4496782133655d-02, 6.7067557452356d-03, 5.4247657677172d-06/
      data (zmn(lat, 5,22), lat = 1,36)/
     |   5.9725333982804d-05, 2.0362774474951d-03, 2.1964164575474d-02,
     |   4.5382052668481d-02, 3.8852008286109d-04,-5.0205818072359d-02,
     |   1.5340589910280d-02, 4.8459658075922d-02,-4.2444844735287d-02,
     |  -2.7770015580047d-02, 6.2473072826631d-02,-1.0288328190763d-02,
     |  -5.8899433912386d-02, 4.9626234571688d-02, 2.7721545946713d-02,
     |  -6.9536635125002d-02, 1.8715408183262d-02, 5.7615322416115d-02,
     |  -5.7615322416115d-02,-1.8715408183262d-02, 6.9536635125002d-02,
     |  -2.7721545946712d-02,-4.9626234571688d-02, 5.8899433912386d-02,
     |   1.0288328190764d-02,-6.2473072826631d-02, 2.7770015580047d-02,
     |   4.2444844735287d-02,-4.8459658075922d-02,-1.5340589910281d-02,
     |   5.0205818072359d-02,-3.8852008286098d-04,-4.5382052668481d-02,
     |  -2.1964164575474d-02,-2.0362774474949d-03,-5.9725333982878d-05/
      data (zmn(lat, 6,22), lat = 1,36)/
     |   3.3105084204204d-06, 5.1749641174887d-04, 1.0431458460117d-02,
     |   4.0781029914477d-02, 4.0523753358893d-02,-2.9460606951272d-02,
     |  -4.1988449548503d-02, 4.3599352024017d-02, 2.7939759073898d-02,
     |  -6.0150303239713d-02, 2.1033521078205d-03, 6.2308783789687d-02,
     |  -3.8874126921181d-02,-4.1208118329586d-02, 6.5548057463517d-02,
     |   1.2019124756114d-03,-6.7420011340375d-02, 4.1434583703356d-02,
     |   4.1434583703356d-02,-6.7420011340375d-02, 1.2019124756109d-03,
     |   6.5548057463517d-02,-4.1208118329586d-02,-3.8874126921180d-02,
     |   6.2308783789687d-02, 2.1033521078206d-03,-6.0150303239713d-02,
     |   2.7939759073898d-02, 4.3599352024017d-02,-4.1988449548503d-02,
     |  -2.9460606951272d-02, 4.0523753358893d-02, 4.0781029914477d-02,
     |   1.0431458460117d-02, 5.1749641174881d-04, 3.3105084205373d-06/
      data (zmn(lat, 7,22), lat = 1,36)/
     |  -6.8229945814667d-06, 1.1590978643176d-04, 3.9777764983479d-03,
     |   2.6077434533230d-02, 5.4119310996613d-02, 1.9312121814299d-02,
     |  -5.2243058402206d-02,-1.7440215572771d-02, 5.9987678799009d-02,
     |  -2.5898542987761d-03,-6.2365214017744d-02, 3.2522658064734d-02,
     |   4.8394111535030d-02,-5.9784166335665d-02,-1.6552875332423d-02,
     |   7.0567086132211d-02,-2.3889145880798d-02,-5.7359212922447d-02,
     |   5.7359212922447d-02, 2.3889145880798d-02,-7.0567086132211d-02,
     |   1.6552875332423d-02, 5.9784166335665d-02,-4.8394111535030d-02,
     |  -3.2522658064735d-02, 6.2365214017744d-02, 2.5898542987763d-03,
     |  -5.9987678799009d-02, 1.7440215572770d-02, 5.2243058402206d-02,
     |  -1.9312121814299d-02,-5.4119310996613d-02,-2.6077434533230d-02,
     |  -3.9777764983479d-03,-1.1590978643180d-04, 6.8229945816261d-06/
      data (zmn(lat, 8,22), lat = 1,36)/
     |  -2.4851252936357d-07, 2.0328634309534d-05, 1.2699472459516d-03,
     |   1.3158616635508d-02, 4.5090184362005d-02, 5.4390051721675d-02,
     |  -1.1476772289144d-02,-5.9278480628780d-02, 1.4838751532788d-02,
     |   5.9508349005450d-02,-3.3714627295393d-02,-4.9599576849775d-02,
     |   5.6102741372224d-02, 2.5499283975876d-02,-7.0002853081414d-02,
     |   9.1032477279077d-03, 6.6385707795249d-02,-4.3727179141125d-02,
     |  -4.3727179141125d-02, 6.6385707795249d-02, 9.1032477279081d-03,
     |  -7.0002853081414d-02, 2.5499283975876d-02, 5.6102741372223d-02,
     |  -4.9599576849774d-02,-3.3714627295393d-02, 5.9508349005450d-02,
     |   1.4838751532788d-02,-5.9278480628780d-02,-1.1476772289144d-02,
     |   5.4390051721675d-02, 4.5090184362005d-02, 1.3158616635508d-02,
     |   1.2699472459516d-03, 2.0328634309630d-05,-2.4851252952973d-07/
      data (zmn(lat, 9,22), lat = 1,36)/
     |   7.6309670883503d-07, 2.3776750745704d-06, 3.4727369441158d-04,
     |   5.5006231496539d-03, 2.8495422090415d-02, 6.0581916764083d-02,
     |   3.9359631021221d-02,-4.1571773956157d-02,-4.8648122197181d-02,
     |   4.4518859568985d-02, 4.3633679854289d-02,-5.7383274883531d-02,
     |  -2.6849567312677d-02, 6.8990008085175d-02,-9.8273310217062d-05,
     |  -7.0304293970199d-02, 3.1036115522063d-02, 5.6942480025947d-02,
     |  -5.6942480025947d-02,-3.1036115522064d-02, 7.0304293970198d-02,
     |   9.8273310217222d-05,-6.8990008085175d-02, 2.6849567312678d-02,
     |   5.7383274883531d-02,-4.3633679854289d-02,-4.4518859568986d-02,
     |   4.8648122197181d-02, 4.1571773956157d-02,-3.9359631021221d-02,
     |  -6.0581916764083d-02,-2.8495422090415d-02,-5.5006231496539d-03,
     |  -3.4727369441158d-04,-2.3776750745891d-06,-7.6309670897397d-07/
      data (zmn(lat,10,22), lat = 1,36)/
     |   1.9869417405652d-08, 3.6773885819115d-07, 8.2212960421722d-05,
     |   1.9581515185591d-03, 1.4655277132169d-02, 4.7152153205376d-02,
     |   6.6245593509505d-02, 1.2735486075467d-02,-6.2010350512993d-02,
     |  -2.4779885620385d-02, 6.3983786058738d-02, 1.8399181010400d-02,
     |  -6.9639024017424d-02,-8.2533322598505d-04, 7.1473739440084d-02,
     |  -2.3053029804684d-02,-6.4200846617386d-02, 4.6857306378669d-02,
     |   4.6857306378669d-02,-6.4200846617386d-02,-2.3053029804684d-02,
     |   7.1473739440084d-02,-8.2533322598490d-04,-6.9639024017424d-02,
     |   1.8399181010400d-02, 6.3983786058739d-02,-2.4779885620385d-02,
     |  -6.2010350512993d-02, 1.2735486075467d-02, 6.6245593509505d-02,
     |   4.7152153205376d-02, 1.4655277132169d-02, 1.9581515185591d-03,
     |   8.2212960421872d-05, 3.6773885824820d-07, 1.9869417459419d-08/
      data (zmn(lat,11,22), lat = 1,36)/
     |  -7.5980257922836d-08, 1.2157590956272d-07, 1.7020472121640d-05,
     |   6.0368470553333d-04, 6.3533200970905d-03, 2.8941592432733d-02,
     |   6.4167538703038d-02, 5.9289209277719d-02,-1.8151616386131d-02,
     |  -6.8450448116964d-02, 4.6221049474365d-03, 7.0594872434844d-02,
     |  -8.9149269109895d-03,-7.1054556668812d-02, 2.2750086753205d-02,
     |   6.6921058191187d-02,-4.0304736038199d-02,-5.6306818174837d-02,
     |   5.6306818174837d-02, 4.0304736038199d-02,-6.6921058191187d-02,
     |  -2.2750086753205d-02, 7.1054556668812d-02, 8.9149269109893d-03,
     |  -7.0594872434844d-02,-4.6221049474363d-03, 6.8450448116964d-02,
     |   1.8151616386131d-02,-5.9289209277719d-02,-6.4167538703038d-02,
     |  -2.8941592432733d-02,-6.3533200970907d-03,-6.0368470553336d-04,
     |  -1.7020472121504d-05,-1.2157590954156d-07, 7.5980257915728d-08/
      data (zmn(lat,12,22), lat = 1,36)/
     |  -1.4475483743484d-09, 9.2857862710873d-09, 3.1351848807215d-06,
     |   1.6288657352299d-04, 2.3687639990806d-03, 1.4726603430516d-02,
     |   4.6415595864135d-02, 7.4793800853045d-02, 4.1273626286357d-02,
     |  -4.5855346554677d-02,-6.1804043753459d-02, 3.2229326414416d-02,
     |   6.6378649175528d-02,-3.2632138186562d-02,-6.5385804525770d-02,
     |   4.0598728272235d-02, 6.0025820305232d-02,-5.1012442705690d-02,
     |  -5.1012442705690d-02, 6.0025820305232d-02, 4.0598728272236d-02,
     |  -6.5385804525770d-02,-3.2632138186562d-02, 6.6378649175528d-02,
     |   3.2229326414417d-02,-6.1804043753460d-02,-4.5855346554677d-02,
     |   4.1273626286357d-02, 7.4793800853045d-02, 4.6415595864135d-02,
     |   1.4726603430515d-02, 2.3687639990806d-03, 1.6288657352297d-04,
     |   3.1351848805798d-06, 9.2857862237558d-09,-1.4475483567258d-09/
      data (zmn(lat,13,22), lat = 1,36)/
     |   6.5592931098259d-09,-5.7414805599841d-09, 5.1819204209999d-07,
     |   3.8725589159314d-05, 7.6869347277088d-04, 6.3739560421496d-03,
     |   2.7134911116418d-02, 6.3755602705393d-02, 7.6546250868720d-02,
     |   1.6854606316002d-02,-6.5615930980433d-02,-4.6635109920240d-02,
     |   5.3543910069516d-02, 5.6110433922129d-02,-4.9964588018122d-02,
     |  -5.7631070748005d-02, 5.1801489420059d-02, 5.5348122535156d-02,
     |  -5.5348122535156d-02,-5.1801489420059d-02, 5.7631070748005d-02,
     |   4.9964588018122d-02,-5.6110433922129d-02,-5.3543910069516d-02,
     |   4.6635109920240d-02, 6.5615930980433d-02,-1.6854606316002d-02,
     |  -7.6546250868721d-02,-6.3755602705393d-02,-2.7134911116418d-02,
     |  -6.3739560421496d-03,-7.6869347277081d-04,-3.8725589159330d-05,
     |  -5.1819204221687d-07, 5.7414805769111d-09,-6.5592931339646d-09/
      data (zmn(lat,14,22), lat = 1,36)/
     |   9.2283630891225d-11,-2.1007718914171d-10, 7.4696464254819d-08,
     |   8.1435813062366d-06, 2.1858968957179d-04, 2.3800807617695d-03,
     |   1.3281593829963d-02, 4.2279012957491d-02, 7.7764772280956d-02,
     |   6.9968309394904d-02,-8.4901716249218d-03,-7.6411736640206d-02,
     |  -2.8729323643182d-02, 6.7487541461727d-02, 4.5203234001987d-02,
     |  -6.0651202226720d-02,-5.2536978351455d-02, 5.6510319694485d-02,
     |   5.6510319694485d-02,-5.2536978351455d-02,-6.0651202226720d-02,
     |   4.5203234001987d-02, 6.7487541461727d-02,-2.8729323643182d-02,
     |  -7.6411736640206d-02,-8.4901716249216d-03, 6.9968309394904d-02,
     |   7.7764772280957d-02, 4.2279012957491d-02, 1.3281593829963d-02,
     |   2.3800807617696d-03, 2.1858968957172d-04, 8.1435813062109d-06,
     |   7.4696464277335d-08,-2.1007731438276d-10, 9.2283667100995d-11/
      data (zmn(lat,15,22), lat = 1,36)/
     |  -4.7063238102810d-10, 4.5795758591132d-10, 9.1535004472502d-09,
     |   1.5156675754143d-06, 5.4624166001264d-05, 7.7231056462229d-04,
     |   5.5399896808445d-03, 2.2968987811091d-02, 5.8030677882303d-02,
     |   8.6709871795417d-02, 5.8046755874926d-02,-3.0433523244785d-02,
     |  -8.0358820853456d-02,-1.3209726168263d-02, 7.5469904529633d-02,
     |   3.8412281755066d-02,-6.5452782094033d-02,-5.3891360769594d-02,
     |   5.3891360769593d-02, 6.5452782094033d-02,-3.8412281755066d-02,
     |  -7.5469904529633d-02, 1.3209726168263d-02, 8.0358820853456d-02,
     |   3.0433523244786d-02,-5.8046755874926d-02,-8.6709871795417d-02,
     |  -5.8030677882303d-02,-2.2968987811091d-02,-5.5399896808445d-03,
     |  -7.7231056462229d-04,-5.4624166001198d-05,-1.5156675753861d-06,
     |  -9.1535004842953d-09,-4.5795762595777d-10, 4.7063246308251d-10/
      data (zmn(lat,16,22), lat = 1,36)/
     |  -4.8603163840742d-12, 1.3848759074273d-11, 1.0742346341890d-09,
     |   2.4893721635183d-07, 1.1987309267379d-05, 2.1823828639952d-04,
     |   1.9851059874774d-03, 1.0461222140612d-02, 3.4456312323008d-02,
     |   7.2342375232507d-02, 9.0885381689753d-02, 4.4942404723751d-02,
     |  -4.6640691012332d-02,-8.1256229905950d-02,-3.9142051885422d-03,
     |   7.9644143526991d-02, 3.9570154386793d-02,-6.3939931950956d-02,
     |  -6.3939931950956d-02, 3.9570154386793d-02, 7.9644143526991d-02,
     |  -3.9142051885420d-03,-8.1256229905950d-02,-4.6640691012331d-02,
     |   4.4942404723751d-02, 9.0885381689753d-02, 7.2342375232507d-02,
     |   3.4456312323008d-02, 1.0461222140612d-02, 1.9851059874773d-03,
     |   2.1823828639953d-04, 1.1987309267484d-05, 2.4893721631338d-07,
     |   1.0742345312796d-09, 1.3848732190561d-11,-4.8602996717191d-12/
      data (zmn(lat,17,22), lat = 1,36)/
     |   2.6364067893584d-11,-2.5666149224783d-11, 1.3456951513228d-10,
     |   3.5877200367835d-08, 2.2998336876939d-06, 5.3567077045649d-05,
     |   6.1170260571342d-04, 4.0304293227239d-03, 1.6789320067258d-02,
     |   4.6222686950171d-02, 8.3998361680472d-02, 9.2342117078254d-02,
     |   3.4886790667391d-02,-5.6324143537028d-02,-8.3046652826480d-02,
     |  -4.0185205168769d-03, 8.0682627473859d-02, 5.1618277437011d-02,
     |  -5.1618277437011d-02,-8.0682627473859d-02, 4.0185205168765d-03,
     |   8.3046652826480d-02, 5.6324143537029d-02,-3.4886790667391d-02,
     |  -9.2342117078254d-02,-8.3998361680472d-02,-4.6222686950171d-02,
     |  -1.6789320067258d-02,-4.0304293227240d-03,-6.1170260571340d-04,
     |  -5.3567077045612d-05,-2.2998336877269d-06,-3.5877200353262d-08,
     |  -1.3456944111711d-10, 2.5666080893216d-11,-2.6363934783930d-11/
      data (zmn(lat,18,22), lat = 1,36)/
     |   1.9442478658960d-13,-5.5115398252239d-13, 1.0472250770218d-11,
     |   4.4997258911407d-09, 3.8219870396154d-07, 1.1331061139872d-05,
     |   1.6121057734997d-04, 1.3124635419185d-03, 6.7796630741184d-03,
     |   2.3578778111133d-02, 5.6650858949009d-02, 9.2820462498377d-02,
     |   9.4111418689009d-02, 3.1802388067982d-02,-5.8717969081436d-02,
     |  -8.8290144692046d-02,-1.7264479318833d-02, 7.4579879647019d-02,
     |   7.4579879647019d-02,-1.7264479318833d-02,-8.8290144692046d-02,
     |  -5.8717969081436d-02, 3.1802388067982d-02, 9.4111418689009d-02,
     |   9.2820462498377d-02, 5.6650858949009d-02, 2.3578778111133d-02,
     |   6.7796630741185d-03, 1.3124635419186d-03, 1.6121057735011d-04,
     |   1.1331061139864d-05, 3.8219870386277d-07, 4.4997258897649d-09,
     |   1.0472325790595d-11,-5.5101683395745d-13, 1.9430133547128d-13/
      data (zmn(lat,19,22), lat = 1,36)/
     |  -1.0371272915794d-12, 1.0158690430405d-12,-2.5600789379747d-13,
     |   4.8316757568046d-10, 5.4127791454646d-08, 2.0342027322716d-06,
     |   3.5843130952707d-05, 3.5738882477217d-04, 2.2579993612327d-03,
     |   9.6927208406686d-03, 2.9438298388340d-02, 6.4256045241409d-02,
     |   9.9194796118778d-02, 9.9230541670025d-02, 3.9665298173781d-02,
     |  -5.0585765037549d-02,-9.5488502195032d-02,-4.7849179121691d-02,
     |   4.7849179121691d-02, 9.5488502195032d-02, 5.0585765037550d-02,
     |  -3.9665298173780d-02,-9.9230541670025d-02,-9.9194796118778d-02,
     |  -6.4256045241410d-02,-2.9438298388340d-02,-9.6927208406686d-03,
     |  -2.2579993612326d-03,-3.5738882477219d-04,-3.5843130952702d-05,
     |  -2.0342027322427d-06,-5.4127791472595d-08,-4.8316768185050d-10,
     |   2.5587858980786d-13,-1.0158558189818d-12, 1.0370038506444d-12/
      data (zmn(lat,20,22), lat = 1,36)/
     |  -5.0867891744738d-15, 1.4455320439836d-14, 2.2815990095149d-14,
     |   4.2914532353821d-11, 6.3477805285854d-09, 3.0137171636270d-07,
     |   6.5452534829384d-06, 7.9383423981995d-05, 6.0726727683362d-04,
     |   3.1670915874491d-03, 1.1838733654897d-02, 3.2683509361456d-02,
     |   6.7440024802645d-02, 1.0286269524158d-01, 1.0932774375922d-01,
     |   6.2762824208815d-02,-2.2861186376946d-02,-9.2158429060702d-02,
     |  -9.2158429060702d-02,-2.2861186376947d-02, 6.2762824208815d-02,
     |   1.0932774375922d-01, 1.0286269524158d-01, 6.7440024802645d-02,
     |   3.2683509361456d-02, 1.1838733654897d-02, 3.1670915874491d-03,
     |   6.0726727683359d-04, 7.9383423981996d-05, 6.5452534828839d-06,
     |   3.0137171639614d-07, 6.3477805689346d-09, 4.2914545255120d-11,
     |   2.2796120094345d-14, 1.4388940903335d-14,-5.0353368345175d-15/
      data (zmn(lat,21,22), lat = 1,36)/
     |   2.2599598217949d-14,-2.2387596379595d-14, 2.3678221484793d-14,
     |   2.9719102608945d-12, 5.8296279339780d-10, 3.4865028905466d-08,
     |   9.2967440436039d-07, 1.3640855619129d-05, 1.2537260305714d-04,
     |   7.8541817500622d-04, 3.5501906433536d-03, 1.2033636537245d-02,
     |   3.1360290190755d-02, 6.3667151052886d-02, 1.0067206674949d-01,
     |   1.2124621369616d-01, 1.0259926994538d-01, 4.0562025204555d-02,
     |  -4.0562025204555d-02,-1.0259926994538d-01,-1.2124621369616d-01,
     |  -1.0067206674949d-01,-6.3667151052886d-02,-3.1360290190755d-02,
     |  -1.2033636537245d-02,-3.5501906433536d-03,-7.8541817500620d-04,
     |  -1.2537260305714d-04,-1.3640855619114d-05,-9.2967440432986d-07,
     |  -3.4865028920639d-08,-5.8296278359855d-10,-2.9718910161372d-12,
     |  -2.3628166543490d-14, 2.2466577870827d-14,-2.2609948136215d-14/
      data (zmn(lat,22,22), lat = 1,36)/
     |   3.4387271744761d-17,-1.8965354142280d-16, 2.7217203580221d-16,
     |   1.4187980223019d-13, 3.6402169792404d-11, 2.7361539833311d-09,
     |   8.9287746324266d-08, 1.5779591193046d-06, 1.7319237447375d-05,
     |   1.2921774175164d-04, 6.9750104658777d-04, 2.8476277702168d-03,
     |   9.0819071738573d-03, 2.3172066372497d-02, 4.8134929910413d-02,
     |   8.2449231029469d-02, 1.1748673363902d-01, 1.4005550434233d-01,
     |   1.4005550434233d-01, 1.1748673363902d-01, 8.2449231029469d-02,
     |   4.8134929910413d-02, 2.3172066372497d-02, 9.0819071738573d-03,
     |   2.8476277702168d-03, 6.9750104658778d-04, 1.2921774175164d-04,
     |   1.7319237447367d-05, 1.5779591192910d-06, 8.9287746323387d-08,
     |   2.7361539790614d-09, 3.6402150778178d-11, 1.4185463984590d-13,
     |   2.4972197953340d-16,-2.0216561789694d-16, 3.0586973731045d-17/
      data (zmn(lat, 0,23), lat = 1,36)/
     |   1.0704528849552d-02,-1.3436216896430d-02,-1.4144136902674d-02,
     |   3.9335853555211d-02,-2.4579459220459d-02,-2.2204618089262d-02,
     |   5.0152862778409d-02,-2.2930129742320d-02,-3.4784308095491d-02,
     |   5.9665161376194d-02,-2.0282074469638d-02,-4.3810411695588d-02,
     |   6.2366226629227d-02,-1.2399583741240d-02,-5.3590946892215d-02,
     |   6.3416448126301d-02,-4.9630557829960d-03,-5.9025501358162d-02,
     |   5.9025501358162d-02, 4.9630557829960d-03,-6.3416448126301d-02,
     |   5.3590946892215d-02, 1.2399583741240d-02,-6.2366226629227d-02,
     |   4.3810411695588d-02, 2.0282074469638d-02,-5.9665161376194d-02,
     |   3.4784308095491d-02, 2.2930129742320d-02,-5.0152862778410d-02,
     |   2.2204618089261d-02, 2.4579459220460d-02,-3.9335853555211d-02,
     |   1.4144136902673d-02, 1.3436216896430d-02,-1.0704528849552d-02/
      data (zmn(lat, 1,23), lat = 1,36)/
     |   1.0530870917740d-02, 1.6181961166585d-02,-3.0629215215643d-02,
     |   5.7496416045885d-03, 3.5169966068884d-02,-4.2378561626907d-02,
     |   2.7543061945847d-04, 4.8172974659659d-02,-4.6703410994076d-02,
     |  -8.2878040051065d-03, 5.8551085241117d-02,-4.6692122004622d-02,
     |  -1.7809770384181d-02, 6.5559207591714d-02,-4.2829482944133d-02,
     |  -2.7505109761665d-02, 6.9201607929034d-02,-3.6159852300962d-02,
     |  -3.6159852300962d-02, 6.9201607929034d-02,-2.7505109761664d-02,
     |  -4.2829482944133d-02, 6.5559207591714d-02,-1.7809770384181d-02,
     |  -4.6692122004622d-02, 5.8551085241117d-02,-8.2878040051063d-03,
     |  -4.6703410994077d-02, 4.8172974659659d-02, 2.7543061945899d-04,
     |  -4.2378561626907d-02, 3.5169966068884d-02, 5.7496416045887d-03,
     |  -3.0629215215643d-02, 1.6181961166585d-02, 1.0530870917740d-02/
      data (zmn(lat, 2,23), lat = 1,36)/
     |   2.6851032074757d-03, 2.6335598457874d-02, 9.4453865445308d-04,
     |  -3.6813536483093d-02, 3.1048925830700d-02, 1.5978813330860d-02,
     |  -5.0788383855839d-02, 2.8838750381599d-02, 3.0038644044937d-02,
     |  -5.9997575687889d-02, 2.3756698256101d-02, 4.1723554014506d-02,
     |  -6.3622275506584d-02, 1.5075996252552d-02, 5.2209182339504d-02,
     |  -6.3731754511982d-02, 5.4340026546109d-03, 5.9310707567225d-02,
     |  -5.9310707567225d-02,-5.4340026546110d-03, 6.3731754511982d-02,
     |  -5.2209182339504d-02,-1.5075996252553d-02, 6.3622275506584d-02,
     |  -4.1723554014505d-02,-2.3756698256101d-02, 5.9997575687889d-02,
     |  -3.0038644044937d-02,-2.8838750381599d-02, 5.0788383855839d-02,
     |  -1.5978813330860d-02,-3.1048925830701d-02, 3.6813536483093d-02,
     |  -9.4453865445289d-04,-2.6335598457874d-02,-2.6851032074760d-03/
      data (zmn(lat, 3,23), lat = 1,36)/
     |  -4.1722606077850d-05, 1.8002341831790d-02, 3.1470542276114d-02,
     |  -2.5757723719584d-02,-2.2466807350380d-02, 4.7788012644646d-02,
     |  -1.3923548906962d-02,-4.1915427791559d-02, 5.2485835939886d-02,
     |  -1.0931978287505d-03,-5.5644623322217d-02, 5.1413062282880d-02,
     |   1.2205326136655d-02,-6.4729922096278d-02, 4.5804028493076d-02,
     |   2.5187017449926d-02,-6.9332165927402d-02, 3.6735356259564d-02,
     |   3.6735356259564d-02,-6.9332165927402d-02, 2.5187017449925d-02,
     |   4.5804028493076d-02,-6.4729922096278d-02, 1.2205326136656d-02,
     |   5.1413062282881d-02,-5.5644623322217d-02,-1.0931978287507d-03,
     |   5.2485835939886d-02,-4.1915427791559d-02,-1.3923548906963d-02,
     |   4.7788012644646d-02,-2.2466807350379d-02,-2.5757723719584d-02,
     |   3.1470542276114d-02, 1.8002341831790d-02,-4.1722606078056d-05/
      data (zmn(lat, 4,23), lat = 1,36)/
     |   3.0873081458443d-06, 7.8391963743208d-03, 3.6297185872116d-02,
     |   1.5496544471267d-02,-4.4889338977735d-02, 7.3566426088410d-03,
     |   4.5666144709642d-02,-4.3314062983773d-02,-1.5225433100736d-02,
     |   5.9896810309392d-02,-3.4750610510787d-02,-3.3650294643199d-02,
     |   6.5760330689302d-02,-2.2221621921631d-02,-4.8634622670741d-02,
     |   6.5394787150397d-02,-7.6911049433650d-03,-5.9353967149374d-02,
     |   5.9353967149374d-02, 7.6911049433649d-03,-6.5394787150397d-02,
     |   4.8634622670741d-02, 2.2221621921631d-02,-6.5760330689302d-02,
     |   3.3650294643198d-02, 3.4750610510787d-02,-5.9896810309392d-02,
     |   1.5225433100736d-02, 4.3314062983774d-02,-4.5666144709642d-02,
     |  -7.3566426088412d-03, 4.4889338977735d-02,-1.5496544471266d-02,
     |  -3.6297185872116d-02,-7.8391963743208d-03,-3.0873081456035d-06/
      data (zmn(lat, 5,23), lat = 1,36)/
     |   6.6560818291023d-05, 2.5154966073603d-03, 2.5081107439952d-02,
     |   4.2997620046239d-02,-1.4953232667674d-02,-4.3244388348628d-02,
     |   3.8890140008493d-02, 2.2650760894472d-02,-5.8642030188031d-02,
     |   2.0138028048052d-02, 4.6812819674058d-02,-5.9233687597880d-02,
     |  -4.2336028838855d-04, 6.2022272695890d-02,-5.1465792122007d-02,
     |  -2.0347255377341d-02, 6.9500317271231d-02,-3.7909360224700d-02,
     |  -3.7909360224700d-02, 6.9500317271231d-02,-2.0347255377341d-02,
     |  -5.1465792122007d-02, 6.2022272695891d-02,-4.2336028838908d-04,
     |  -5.9233687597880d-02, 4.6812819674058d-02, 2.0138028048052d-02,
     |  -5.8642030188031d-02, 2.2650760894472d-02, 3.8890140008493d-02,
     |  -4.3244388348628d-02,-1.4953232667674d-02, 4.2997620046239d-02,
     |   2.5081107439952d-02, 2.5154966073599d-03, 6.6560818291151d-05/
      data (zmn(lat, 6,23), lat = 1,36)/
     |   4.8823880688556d-06, 6.6932953473253d-04, 1.2741144990919d-02,
     |   4.4139332037927d-02, 2.9441459261508d-02,-4.3723991495184d-02,
     |  -1.9436206348959d-02, 5.6694353306636d-02,-1.2682513134991d-02,
     |  -5.2352105837743d-02, 5.0767726004790d-02, 1.7488574745660d-02,
     |  -6.6516110972896d-02, 3.3709000202077d-02, 4.1965700274758d-02,
     |  -6.7963105665634d-02, 1.1740218887367d-02, 5.9224135165245d-02,
     |  -5.9224135165245d-02,-1.1740218887367d-02, 6.7963105665634d-02,
     |  -4.1965700274758d-02,-3.3709000202077d-02, 6.6516110972896d-02,
     |  -1.7488574745659d-02,-5.0767726004790d-02, 5.2352105837743d-02,
     |   1.2682513134991d-02,-5.6694353306636d-02, 1.9436206348958d-02,
     |   4.3723991495184d-02,-2.9441459261508d-02,-4.4139332037927d-02,
     |  -1.2741144990919d-02,-6.6932953473252d-04,-4.8823880691046d-06/
      data (zmn(lat, 7,23), lat = 1,36)/
     |  -7.9189650478131d-06, 1.5659427190693d-04, 5.1641542212433d-03,
     |   3.0886906569206d-02, 5.2896755314361d-02,-8.8108606754880d-04,
     |  -5.5556403646473d-02, 1.6344778574761d-02, 5.1973495234545d-02,
     |  -4.5864328039724d-02,-2.6660642789546d-02, 6.5846723666530d-02,
     |  -1.7970919430732d-02,-5.5328345767089d-02, 5.9098684283773d-02,
     |   1.2579076671992d-02,-6.9491914814610d-02, 3.9726763627846d-02,
     |   3.9726763627846d-02,-6.9491914814610d-02, 1.2579076671991d-02,
     |   5.9098684283773d-02,-5.5328345767089d-02,-1.7970919430732d-02,
     |   6.5846723666530d-02,-2.6660642789547d-02,-4.5864328039724d-02,
     |   5.1973495234545d-02, 1.6344778574762d-02,-5.5556403646473d-02,
     |  -8.8108606754891d-04, 5.2896755314361d-02, 3.0886906569206d-02,
     |   5.1641542212434d-03, 1.5659427190731d-04,-7.9189650478751d-06/
      data (zmn(lat, 8,23), lat = 1,36)/
     |  -4.2522919403408d-07, 2.9387284108267d-05, 1.7472185239546d-03,
     |   1.6804820242986d-02, 5.0436583718988d-02, 4.3261603267239d-02,
     |  -3.5101141305214d-02,-4.4107241293236d-02, 4.8522597884522d-02,
     |   2.6659893796633d-02,-6.4332623415561d-02, 8.6301105614869d-03,
     |   6.1573373784582d-02,-4.8593542026272d-02,-3.0834898259605d-02,
     |   7.0663329278639d-02,-1.7650634700735d-02,-5.8968975205075d-02,
     |   5.8968975205075d-02, 1.7650634700735d-02,-7.0663329278639d-02,
     |   3.0834898259604d-02, 4.8593542026272d-02,-6.1573373784582d-02,
     |  -8.6301105614876d-03, 6.4332623415561d-02,-2.6659893796633d-02,
     |  -4.8522597884522d-02, 4.4107241293236d-02, 3.5101141305214d-02,
     |  -4.3261603267239d-02,-5.0436583718988d-02,-1.6804820242986d-02,
     |  -1.7472185239546d-03,-2.9387284108180d-05, 4.2522919417101d-07/
      data (zmn(lat, 9,23), lat = 1,36)/
     |   9.3725048543468d-07, 3.8330226999005d-06, 5.0609198760447d-04,
     |   7.5259461036052d-03, 3.5153211426048d-02, 6.1586790908504d-02,
     |   1.6237042302273d-02,-5.8593639277195d-02,-1.4161125784290d-02,
     |   6.4463099697840d-02,-8.9491395107913d-03,-6.2920011157575d-02,
     |   4.1676231876903d-02, 4.1543436927020d-02,-6.7175683657634d-02,
     |  -1.3464121438769d-03, 6.8943592164656d-02,-4.2263700818040d-02,
     |  -4.2263700818040d-02, 6.8943592164656d-02,-1.3464121438764d-03,
     |  -6.7175683657634d-02, 4.1543436927020d-02, 4.1676231876903d-02,
     |  -6.2920011157575d-02,-8.9491395107910d-03, 6.4463099697840d-02,
     |  -1.4161125784290d-02,-5.8593639277195d-02, 1.6237042302273d-02,
     |   6.1586790908504d-02, 3.5153211426048d-02, 7.5259461036052d-03,
     |   5.0609198760446d-04, 3.8330226995733d-06, 9.3725048555522d-07/
      data (zmn(lat,10,23), lat = 1,36)/
     |   3.9410817663887d-08, 5.6660179373191d-07, 1.2709407752967d-04,
     |   2.8625714510333d-03, 1.9659143988146d-02, 5.4980046484131d-02,
     |   5.7120673538300d-02,-1.8987618028096d-02,-6.2401861707247d-02,
     |   2.2293760289902d-02, 5.9822270188881d-02,-4.2363841126221d-02,
     |  -4.4593899275908d-02, 6.3942465419001d-02, 1.3691763587340d-02,
     |  -7.2275882032949d-02, 2.5591450983557d-02, 5.8562249605735d-02,
     |  -5.8562249605735d-02,-2.5591450983557d-02, 7.2275882032949d-02,
     |  -1.3691763587340d-02,-6.3942465419001d-02, 4.4593899275908d-02,
     |   4.2363841126221d-02,-5.9822270188881d-02,-2.2293760289902d-02,
     |   6.2401861707247d-02, 1.8987618028097d-02,-5.7120673538299d-02,
     |  -5.4980046484131d-02,-1.9659143988146d-02,-2.8625714510334d-03,
     |  -1.2709407752960d-04,-5.6660179386161d-07,-3.9410817830852d-08/
      data (zmn(lat,11,23), lat = 1,36)/
     |  -9.9521178063762d-08, 1.7540400687548d-07, 2.7951744970985d-05,
     |   9.4246799490327d-04, 9.2104109814652d-03, 3.7507776321219d-02,
     |   6.8694918366959d-02, 3.6364490242352d-02,-5.0305462442587d-02,
     |  -4.6471743476948d-02, 5.2817260418985d-02, 3.8653319718485d-02,
     |  -6.4692358058915d-02,-1.7276880025535d-02, 7.2785453018201d-02,
     |  -1.3866359484081d-02,-6.7281035780259d-02, 4.5641684974370d-02,
     |   4.5641684974370d-02,-6.7281035780259d-02,-1.3866359484082d-02,
     |   7.2785453018201d-02,-1.7276880025535d-02,-6.4692358058914d-02,
     |   3.8653319718484d-02, 5.2817260418985d-02,-4.6471743476948d-02,
     |  -5.0305462442587d-02, 3.6364490242352d-02, 6.8694918366959d-02,
     |   3.7507776321219d-02, 9.2104109814653d-03, 9.4246799490330d-04,
     |   2.7951744971037d-05, 1.7540400711174d-07,-9.9521178173222d-08/
      data (zmn(lat,12,23), lat = 1,36)/
     |  -3.3744223508768d-09, 1.8887565480199d-08, 5.4683147012676d-06,
     |   2.7185074552958d-04, 3.7028454113118d-03, 2.0945001680707d-02,
     |   5.7156419799515d-02, 7.0352291812553d-02, 5.0822029105122d-03,
     |  -6.8583311899304d-02,-1.7862387111943d-02, 6.9893645714394d-02,
     |   9.5954362577377d-03,-7.3278128567858d-02, 1.0590034156262d-02,
     |   7.0844537452977d-02,-3.5761710179719d-02,-5.7937348541514d-02,
     |   5.7937348541514d-02, 3.5761710179719d-02,-7.0844537452977d-02,
     |  -1.0590034156262d-02, 7.3278128567858d-02,-9.5954362577381d-03,
     |  -6.9893645714394d-02, 1.7862387111943d-02, 6.8583311899304d-02,
     |  -5.0822029105122d-03,-7.0352291812553d-02,-5.7156419799515d-02,
     |  -2.0945001680707d-02,-3.7028454113118d-03,-2.7185074552962d-04,
     |  -5.4683147014470d-06,-1.8887565360620d-08, 3.3744224515635d-09/
      data (zmn(lat,13,23), lat = 1,36)/
     |   9.2810085337836d-09,-7.6154312444708d-09, 9.6197485397394d-07,
     |   6.9245275922177d-05, 1.2959849535879d-03, 9.8975470000357d-03,
     |   3.7457543011156d-02, 7.3125904152618d-02, 5.8496478456588d-02,
     |  -2.7934689700202d-02,-7.0924651025443d-02, 1.3894375747545d-02,
     |   7.2648175888822d-02,-1.8814126706044d-02,-7.0931614602493d-02,
     |   3.3222346391279d-02, 6.3611661410091d-02,-5.0055234009727d-02,
     |  -5.0055234009727d-02, 6.3611661410091d-02, 3.3222346391280d-02,
     |  -7.0931614602493d-02,-1.8814126706044d-02, 7.2648175888822d-02,
     |   1.3894375747545d-02,-7.0924651025443d-02,-2.7934689700202d-02,
     |   5.8496478456588d-02, 7.3125904152617d-02, 3.7457543011156d-02,
     |   9.8975470000357d-03, 1.2959849535878d-03, 6.9245275922166d-05,
     |   9.6197485394423d-07,-7.6154313747943d-09, 9.2810085258972d-09/
      data (zmn(lat,14,23), lat = 1,36)/
     |   2.5722128730056d-10,-6.2802255617754d-10, 1.4943499095513d-07,
     |   1.5654279642120d-05, 3.9833181116286d-04, 4.0310367580212d-03,
     |   2.0343334060515d-02, 5.6031911959997d-02, 8.1030115278803d-02,
     |   3.6352687364652d-02,-5.5082116291312d-02,-6.0343046049684d-02,
     |   4.1191138421047d-02, 6.5275373709851d-02,-4.1185568667267d-02,
     |  -6.3336016722669d-02, 4.8316648365354d-02, 5.6984409185466d-02,
     |  -5.6984409185466d-02,-4.8316648365354d-02, 6.3336016722669d-02,
     |   4.1185568667267d-02,-6.5275373709851d-02,-4.1191138421046d-02,
     |   6.0343046049684d-02, 5.5082116291311d-02,-3.6352687364652d-02,
     |  -8.1030115278803d-02,-5.6031911959998d-02,-2.0343334060515d-02,
     |  -4.0310367580212d-03,-3.9833181116290d-04,-1.5654279641965d-05,
     |  -1.4943499081767d-07, 6.2802263402416d-10,-2.5722121051216d-10/
      data (zmn(lat,15,23), lat = 1,36)/
     |  -7.3358183606829d-10, 6.9848281493102d-10, 1.9988890222125d-08,
     |   3.1478211168337d-06, 1.0802093986473d-04, 1.4295097637380d-03,
     |   9.3874097315044d-03, 3.4500008727631d-02, 7.3043205300635d-02,
     |   7.9490946134923d-02, 9.7773586177254d-03,-7.2656862194752d-02,
     |  -4.3097828925264d-02, 6.0506395507363d-02, 5.4116826608829d-02,
     |  -5.5814971969892d-02,-5.6533436885471d-02, 5.5830960033295d-02,
     |   5.5830960033296d-02,-5.6533436885471d-02,-5.5814971969893d-02,
     |   5.4116826608829d-02, 6.0506395507363d-02,-4.3097828925265d-02,
     |  -7.2656862194752d-02, 9.7773586177255d-03, 7.9490946134923d-02,
     |   7.3043205300635d-02, 3.4500008727631d-02, 9.3874097315046d-03,
     |   1.4295097637380d-03, 1.0802093986486d-04, 3.1478211168428d-06,
     |   1.9988890402246d-08, 6.9848288141960d-10,-7.3358167145667d-10/
      data (zmn(lat,16,23), lat = 1,36)/
     |  -1.6612565463805d-11, 4.7696027641664d-11, 2.4834483186050d-09,
     |   5.6252921988418d-07, 2.5882716185410d-05, 4.4356357483181d-04,
     |   3.7276989318004d-03, 1.7699010554627d-02, 5.0548845308636d-02,
     |   8.5652335223509d-02, 7.0411772231882d-02,-1.5437875906727d-02,
     |  -8.1230514436299d-02,-2.5774940312235d-02, 7.2100220318664d-02,
     |   4.5295147427758d-02,-6.3227170136608d-02,-5.5521064037554d-02,
     |   5.5521064037554d-02, 6.3227170136608d-02,-4.5295147427757d-02,
     |  -7.2100220318664d-02, 2.5774940312235d-02, 8.1230514436299d-02,
     |   1.5437875906728d-02,-7.0411772231882d-02,-8.5652335223509d-02,
     |  -5.0548845308636d-02,-1.7699010554627d-02,-3.7276989318003d-03,
     |  -4.4356357483180d-04,-2.5882716185380d-05,-5.6252921998988d-07,
     |  -2.4834483517787d-09,-4.7696052469984d-11, 1.6612404763955d-11/
      data (zmn(lat,17,23), lat = 1,36)/
     |   4.6729543313215d-11,-4.4488312626649d-11, 3.2231675674523d-10,
     |   8.9048432541355d-08, 5.4702460061886d-06, 1.2049754613005d-04,
     |   1.2805304117171d-03, 7.6921288281848d-03, 2.8390268928166d-02,
     |   6.6183328164385d-02, 9.3001975926412d-02, 5.7888249797800d-02,
     |  -3.5372211020839d-02,-8.4287437093509d-02,-1.3651551827656d-02,
     |   7.8121524074749d-02, 4.3757983660204d-02,-6.3570781822756d-02,
     |  -6.3570781822756d-02, 4.3757983660203d-02, 7.8121524074750d-02,
     |  -1.3651551827656d-02,-8.4287437093509d-02,-3.5372211020839d-02,
     |   5.7888249797800d-02, 9.3001975926412d-02, 6.6183328164385d-02,
     |   2.8390268928166d-02, 7.6921288281851d-03, 1.2805304117171d-03,
     |   1.2049754613008d-04, 5.4702460060886d-06, 8.9048432536304d-08,
     |   3.2231654315514d-10,-4.4488388422608d-11, 4.6729421758241d-11/
      data (zmn(lat,18,23), lat = 1,36)/
     |   8.4989606301529d-13,-2.4390155511334d-12, 3.1163308842568d-11,
     |   1.2424538044501d-08, 1.0144338445537d-06, 2.8555066666186d-05,
     |   3.8029457256054d-04, 2.8483448578737d-03, 1.3233698760636d-02,
     |   4.0085792730857d-02, 7.9577554954809d-02, 9.6414801742552d-02,
     |   4.6746093534529d-02,-4.8184524669558d-02,-8.6252286311232d-02,
     |  -1.0780308746984d-02, 7.9943304795447d-02, 5.3217001271218d-02,
     |  -5.3217001271218d-02,-7.9943304795447d-02, 1.0780308746983d-02,
     |   8.6252286311232d-02, 4.8184524669558d-02,-4.6746093534530d-02,
     |  -9.6414801742552d-02,-7.9577554954809d-02,-4.0085792730857d-02,
     |  -1.3233698760636d-02,-2.8483448578736d-03,-3.8029457256067d-04,
     |  -2.8555066666123d-05,-1.0144338445948d-06,-1.2424538047382d-08,
     |  -3.1163269450067d-11, 2.4389068616722d-12,-8.4980100663347d-13/
      data (zmn(lat,19,23), lat = 1,36)/
     |  -2.2164149594685d-12, 2.1285761446984d-12, 3.5496234099985d-13,
     |   1.5134195079574d-09, 1.6345596170782d-07, 5.8521461142514d-06,
     |   9.6996296674658d-05, 8.9618427308763d-04, 5.1499425403877d-03,
     |   1.9618706922547d-02, 5.1034019580279d-02, 8.9935304710386d-02,
     |   9.8736829085062d-02, 4.1644365126275d-02,-5.2783974930950d-02,
     |  -9.0490087961911d-02,-2.1214455667996d-02, 7.4576414116390d-02,
     |   7.4576414116390d-02,-2.1214455667996d-02,-9.0490087961911d-02,
     |  -5.2783974930950d-02, 4.1644365126275d-02, 9.8736829085062d-02,
     |   8.9935304710386d-02, 5.1034019580279d-02, 1.9618706922547d-02,
     |   5.1499425403877d-03, 8.9618427308750d-04, 9.6996296674559d-05,
     |   5.8521461141750d-06, 1.6345596171497d-07, 1.5134194517656d-09,
     |   3.5505322257551d-13, 2.1285508079962d-12,-2.2163881592795d-12/
      data (zmn(lat,20,23), lat = 1,36)/
     |  -3.0830362251000d-14, 8.9409986810938d-14, 3.0259078726825d-14,
     |   1.5768485262879d-10, 2.2504745929996d-08, 1.0208692732218d-06,
     |   2.0941742127266d-05, 2.3674675570460d-04, 1.6616378776280d-03,
     |   7.7954615404571d-03, 2.5534614588967d-02, 5.9476797693102d-02,
     |   9.7275182882495d-02, 1.0322225719840d-01, 4.7083238826762d-02,
     |  -4.6214914881096d-02,-9.6426380068439d-02,-4.9368110975401d-02,
     |   4.9368110975401d-02, 9.6426380068439d-02, 4.6214914881096d-02,
     |  -4.7083238826762d-02,-1.0322225719840d-01,-9.7275182882495d-02,
     |  -5.9476797693102d-02,-2.5534614588967d-02,-7.7954615404571d-03,
     |  -1.6616378776281d-03,-2.3674675570465d-04,-2.0941742127335d-05,
     |  -1.0208692732967d-06,-2.2504745978201d-08,-1.5768485495357d-10,
     |  -3.0161310995558d-14,-8.9279278084277d-14, 3.0880858698776d-14/
      data (zmn(lat,21,23), lat = 1,36)/
     |   6.7289760112071d-14,-6.5264237678731d-14, 7.1127204672532d-14,
     |   1.3595249132158d-11, 2.5716213936050d-09, 1.4732961025886d-07,
     |   3.7238272644998d-06, 5.1181320548137d-05, 4.3462999229516d-04,
     |   2.4746921238929d-03, 9.9599456929729d-03, 2.9257710100062d-02,
     |   6.3591336115167d-02, 1.0132030043374d-01, 1.1193775293531d-01,
     |   6.7624154091224d-02,-1.9981153236477d-02,-9.2633582253259d-02,
     |  -9.2633582253259d-02,-1.9981153236477d-02, 6.7624154091223d-02,
     |   1.1193775293531d-01, 1.0132030043374d-01, 6.3591336115167d-02,
     |   2.9257710100062d-02, 9.9599456929729d-03, 2.4746921238929d-03,
     |   4.3462999229508d-04, 5.1181320548161d-05, 3.7238272645033d-06,
     |   1.4732961027017d-07, 2.5716212481686d-09, 1.3595226268231d-11,
     |   7.1049619070884d-14,-6.5303051536735d-14, 6.7386623887610d-14/
      data (zmn(lat,22,23), lat = 1,36)/
     |   7.3035693673842d-16,-1.8153639650514d-15, 3.2886075842064d-15,
     |   9.2620336339345d-13, 2.3056657044262d-10, 1.6638659147944d-08,
     |   5.1626179227843d-07, 8.5824509691309d-06, 8.7540410692200d-05,
     |   5.9848658736077d-04, 2.9109913865976d-03, 1.0489352310944d-02,
     |   2.8749585489944d-02, 6.0792968918426d-02, 9.9231847437516d-02,
     |   1.2234107410049d-01, 1.0513212129104d-01, 4.1882121500298d-02,
     |  -4.1882121500298d-02,-1.0513212129104d-01,-1.2234107410049d-01,
     |  -9.9231847437516d-02,-6.0792968918426d-02,-2.8749585489944d-02,
     |  -1.0489352310944d-02,-2.9109913865976d-03,-5.9848658736079d-04,
     |  -8.7540410692233d-05,-8.5824509691134d-06,-5.1626179220376d-07,
     |  -1.6638659123083d-08,-2.3056653037127d-10,-9.2614875396768d-13,
     |  -3.3086074315948d-15, 1.8788484367693d-15,-7.3558923828549d-16/
      data (zmn(lat,23,23), lat = 1,36)/
     |  -8.8915761490331d-16, 7.0193561470439d-16,-9.1143182112914d-16,
     |   4.3801514361587d-14, 1.4080249613386d-11, 1.2770749463164d-09,
     |   4.8492926219645d-08, 9.7098582266626d-07, 1.1827205030514d-05,
     |   9.6299280954420d-05, 5.5934728103247d-04, 2.4276296017399d-03,
     |   8.1428417699238d-03, 2.1639644550614d-02, 4.6403405960010d-02,
     |   8.1365094984358d-02, 1.1774091568278d-01, 1.4143491895861d-01,
     |   1.4143491895861d-01, 1.1774091568278d-01, 8.1365094984358d-02,
     |   4.6403405960010d-02, 2.1639644550614d-02, 8.1428417699237d-03,
     |   2.4276296017399d-03, 5.5934728103247d-04, 9.6299280954419d-05,
     |   1.1827205030555d-05, 9.7098582265211d-07, 4.8492926201755d-08,
     |   1.2770749361957d-09, 1.4080306317941d-11, 4.3840926090782d-14,
     |  -8.5476880064891d-16, 7.9052261367125d-16,-9.6375740868217d-16/
      data (zmn(lat, 0,24), lat = 1,36)/
     |   1.0460362732926d-02,-1.5712980028039d-02,-7.4731728880153d-03,
     |   3.6576968064532d-02,-3.6639580708983d-02,-5.5086308501866d-04,
     |   4.3041164603101d-02,-4.7887567045093d-02, 5.3527277060192d-03,
     |   4.7265607491730d-02,-5.9038013018022d-02, 1.5327340893263d-02,
     |   4.5194303994885d-02,-6.5386979617394d-02, 2.4374682648417d-02,
     |   4.0856051330000d-02,-6.9240608137849d-02, 3.3480554094034d-02,
     |   3.3480554094034d-02,-6.9240608137849d-02, 4.0856051329999d-02,
     |   2.4374682648417d-02,-6.5386979617394d-02, 4.5194303994885d-02,
     |   1.5327340893264d-02,-5.9038013018022d-02, 4.7265607491730d-02,
     |   5.3527277060194d-03,-4.7887567045093d-02, 4.3041164603100d-02,
     |  -5.5086308501878d-04,-3.6639580708983d-02, 3.6576968064532d-02,
     |  -7.4731728880152d-03,-1.5712980028039d-02, 1.0460362732926d-02/
      data (zmn(lat, 1,24), lat = 1,36)/
     |   1.1668594969459d-02, 1.3060125510041d-02,-3.1450919457704d-02,
     |   1.6306152365634d-02, 2.3309813184082d-02,-4.7969508489682d-02,
     |   2.8083837584098d-02, 2.2566748686671d-02,-5.6334890967935d-02,
     |   3.7627127354331d-02, 1.9708071604832d-02,-6.2432691354473d-02,
     |   4.8186898706007d-02, 1.2212281610626d-02,-6.2847850041689d-02,
     |   5.5211477212204d-02, 4.8212710184231d-03,-6.1436886295777d-02,
     |   6.1436886295777d-02,-4.8212710184229d-03,-5.5211477212204d-02,
     |   6.2847850041689d-02,-1.2212281610626d-02,-4.8186898706007d-02,
     |   6.2432691354472d-02,-1.9708071604833d-02,-3.7627127354331d-02,
     |   5.6334890967935d-02,-2.2566748686671d-02,-2.8083837584099d-02,
     |   4.7969508489682d-02,-2.3309813184082d-02,-1.6306152365634d-02,
     |   3.1450919457704d-02,-1.3060125510041d-02,-1.1668594969460d-02/
      data (zmn(lat, 2,24), lat = 1,36)/
     |   2.9794533775866d-03, 2.6638434931704d-02,-5.7713941239709d-03,
     |  -3.1245144425528d-02, 4.0417838275200d-02,-6.2801272501198d-03,
     |  -4.0083435056286d-02, 5.0850857048789d-02,-1.0790036797092d-02,
     |  -4.4188602778620d-02, 6.0092036362733d-02,-1.8372252428160d-02,
     |  -4.3409181388604d-02, 6.6061866746061d-02,-2.6151712082922d-02,
     |  -3.9841935398195d-02, 6.9359924475025d-02,-3.3739863724855d-02,
     |  -3.3739863724855d-02, 6.9359924475025d-02,-3.9841935398195d-02,
     |  -2.6151712082922d-02, 6.6061866746061d-02,-4.3409181388604d-02,
     |  -1.8372252428161d-02, 6.0092036362733d-02,-4.4188602778620d-02,
     |  -1.0790036797092d-02, 5.0850857048789d-02,-4.0083435056286d-02,
     |  -6.2801272501197d-03, 4.0417838275200d-02,-3.1245144425528d-02,
     |  -5.7713941239710d-03, 2.6638434931704d-02, 2.9794533775869d-03/
      data (zmn(lat, 3,24), lat = 1,36)/
     |  -2.0876575541593d-04, 1.9805002104530d-02, 2.7583288736890d-02,
     |  -3.2924201408631d-02,-7.0743344749992d-03, 4.5851529442450d-02,
     |  -3.8205276651344d-02,-1.2065470390804d-02, 5.4890925464768d-02,
     |  -4.4698385453760d-02,-1.1907361066731d-02, 6.0422345886785d-02,
     |  -5.1758348541256d-02,-8.0615949787108d-03, 6.2005071016023d-02,
     |  -5.7145961989184d-02,-3.0395604181130d-03, 6.1102375097147d-02,
     |  -6.1102375097147d-02, 3.0395604181128d-03, 5.7145961989185d-02,
     |  -6.2005071016023d-02, 8.0615949787104d-03, 5.1758348541256d-02,
     |  -6.0422345886785d-02, 1.1907361066731d-02, 4.4698385453761d-02,
     |  -5.4890925464768d-02, 1.2065470390804d-02, 3.8205276651344d-02,
     |  -4.5851529442450d-02, 7.0743344749993d-03, 3.2924201408631d-02,
     |  -2.7583288736890d-02,-1.9805002104529d-02, 2.0876575541613d-04/
      data (zmn(lat, 4,24), lat = 1,36)/
     |   8.3690523950447d-07, 9.0629703259944d-03, 3.7409710117842d-02,
     |   4.9877265621935d-03,-4.4409023398078d-02, 2.7755762681085d-02,
     |   2.5735003492370d-02,-5.5238090408031d-02, 2.5866179144468d-02,
     |   3.4111700391037d-02,-6.2518640224592d-02, 2.7874139714402d-02,
     |   3.7058232659161d-02,-6.7299874083480d-02, 3.1179724883568d-02,
     |   3.6869495246023d-02,-6.9787900068338d-02, 3.4563709620220d-02,
     |   3.4563709620220d-02,-6.9787900068338d-02, 3.6869495246023d-02,
     |   3.1179724883568d-02,-6.7299874083480d-02, 3.7058232659161d-02,
     |   2.7874139714403d-02,-6.2518640224592d-02, 3.4111700391036d-02,
     |   2.5866179144468d-02,-5.5238090408031d-02, 2.5735003492370d-02,
     |   2.7755762681085d-02,-4.4409023398078d-02, 4.9877265621935d-03,
     |   3.7409710117842d-02, 9.0629703259945d-03, 8.3690523915883d-07/
      data (zmn(lat, 5,24), lat = 1,36)/
     |   1.1829453087350d-04, 3.0245874545722d-03, 2.8182664400140d-02,
     |   3.8503562265500d-02,-2.8589493317733d-02,-2.8357007307058d-02,
     |   5.1788361124964d-02,-1.1666337061888d-02,-4.5989635565383d-02,
     |   5.5487082251644d-02,-4.0445845784657d-03,-5.4840535956977d-02,
     |   5.8424026154283d-02,-1.0448009206985d-03,-5.9263844107555d-02,
     |   6.0352174488656d-02,-8.9827177557585d-05,-6.0922763750184d-02,
     |   6.0922763750184d-02, 8.9827177557788d-05,-6.0352174488657d-02,
     |   5.9263844107555d-02, 1.0448009206989d-03,-5.8424026154283d-02,
     |   5.4840535956977d-02, 4.0445845784655d-03,-5.5487082251644d-02,
     |   4.5989635565383d-02, 1.1666337061889d-02,-5.1788361124964d-02,
     |   2.8357007307058d-02, 2.8589493317733d-02,-3.8503562265500d-02,
     |  -2.8182664400140d-02,-3.0245874545727d-03,-1.1829453087376d-04/
      data (zmn(lat, 6,24), lat = 1,36)/
     |   6.7724787335663d-06, 8.5446414894407d-04, 1.5287857959684d-02,
     |   4.6274278600063d-02, 1.5768290292613d-02,-5.0719989818675d-02,
     |   8.0122182359368d-03, 4.9416468399629d-02,-4.7167606950329d-02,
     |  -1.3068091419028d-02, 6.1726979456544d-02,-4.2719846814131d-02,
     |  -2.4668646648771d-02, 6.7726775124110d-02,-3.9294187685307d-02,
     |  -3.1576432196715d-02, 7.0385980243474d-02,-3.5977561501794d-02,
     |  -3.5977561501795d-02, 7.0385980243474d-02,-3.1576432196714d-02,
     |  -3.9294187685307d-02, 6.7726775124110d-02,-2.4668646648772d-02,
     |  -4.2719846814131d-02, 6.1726979456544d-02,-1.3068091419028d-02,
     |  -4.7167606950329d-02, 4.9416468399629d-02, 8.0122182359372d-03,
     |  -5.0719989818674d-02, 1.5768290292612d-02, 4.6274278600063d-02,
     |   1.5287857959684d-02, 8.5446414894395d-04, 6.7724787338478d-06/
      data (zmn(lat, 7,24), lat = 1,36)/
     |  -1.7350904759049d-05, 2.1672836594599d-04, 6.5705614150503d-03,
     |   3.5617024397797d-02, 4.8257255849291d-02,-2.0858714783756d-02,
     |  -4.5929901486377d-02, 4.4483340865454d-02, 2.0355900875471d-02,
     |  -6.2187107529334d-02, 2.8172584499687d-02, 4.1578162074206d-02,
     |  -6.5549071927138d-02, 1.5283680806739d-02, 5.3627283787845d-02,
     |  -6.4577250272586d-02, 4.8215798093810d-03, 6.0752977993985d-02,
     |  -6.0752977993985d-02,-4.8215798093813d-03, 6.4577250272587d-02,
     |  -5.3627283787845d-02,-1.5283680806739d-02, 6.5549071927138d-02,
     |  -4.1578162074206d-02,-2.8172584499687d-02, 6.2187107529334d-02,
     |  -2.0355900875471d-02,-4.4483340865454d-02, 4.5929901486377d-02,
     |   2.0858714783756d-02,-4.8257255849291d-02,-3.5617024397798d-02,
     |  -6.5705614150504d-03,-2.1672836594553d-04, 1.7350904759197d-05/
      data (zmn(lat, 8,24), lat = 1,36)/
     |  -6.5385972812042d-07, 4.1577277678288d-05, 2.3548681273455d-03,
     |   2.0905514961161d-02, 5.3986437257302d-02, 2.7296613975393d-02,
     |  -5.1372857707225d-02,-1.5264931718539d-02, 6.1116533258367d-02,
     |  -2.0978967795501d-02,-4.9532167464790d-02, 5.9158668479755d-02,
     |   4.5076463930423d-03,-6.4797173514644d-02, 4.9949282723272d-02,
     |   2.3384429324890d-02,-7.0903502699165d-02, 3.8029270101024d-02,
     |   3.8029270101024d-02,-7.0903502699165d-02, 2.3384429324889d-02,
     |   4.9949282723272d-02,-6.4797173514644d-02, 4.5076463930430d-03,
     |   5.9158668479755d-02,-4.9532167464789d-02,-2.0978967795501d-02,
     |   6.1116533258367d-02,-1.5264931718538d-02,-5.1372857707225d-02,
     |   2.7296613975393d-02, 5.3986437257302d-02, 2.0905514961162d-02,
     |   2.3548681273454d-03, 4.1577277678387d-05,-6.5385972817900d-07/
      data (zmn(lat, 9,24), lat = 1,36)/
     |   2.4794801220009d-06, 4.6192895217270d-06, 7.2222066458956d-04,
     |   1.0020111776868d-02, 4.1765824138210d-02, 5.7689059818814d-02,
     |  -9.5340442473465d-03,-5.8999753596810d-02, 2.5775097978719d-02,
     |   4.9741354854726d-02,-5.5065895399281d-02,-1.5956014370197d-02,
     |   6.8164038350851d-02,-3.4197704260228d-02,-4.3472298824871d-02,
     |   6.9162911492283d-02,-1.1398590665508d-02,-6.0505753529492d-02,
     |   6.0505753529491d-02, 1.1398590665508d-02,-6.9162911492284d-02,
     |   4.3472298824871d-02, 3.4197704260229d-02,-6.8164038350852d-02,
     |   1.5956014370197d-02, 5.5065895399281d-02,-4.9741354854726d-02,
     |  -2.5775097978719d-02, 5.8999753596810d-02, 9.5340442473470d-03,
     |  -5.7689059818814d-02,-4.1765824138210d-02,-1.0020111776868d-02,
     |  -7.2222066458960d-04,-4.6192895219945d-06,-2.4794801219397d-06/
      data (zmn(lat,10,24), lat = 1,36)/
     |   6.6921994205016d-08, 8.7133669855438d-07, 1.9148574703249d-04,
     |   4.0652592593074d-03, 2.5432472229973d-02, 6.0558885344381d-02,
     |   4.0340169142868d-02,-4.5750829868779d-02,-3.9767910399266d-02,
     |   5.7677147944720d-02, 1.6718814898268d-02,-6.8294446078615d-02,
     |   2.3695059080957d-02, 5.4641183919107d-02,-6.1748750881434d-02,
     |  -1.1571815242998d-02, 7.0947527142448d-02,-4.0800074622209d-02,
     |  -4.0800074622209d-02, 7.0947527142448d-02,-1.1571815242998d-02,
     |  -6.1748750881435d-02, 5.4641183919107d-02, 2.3695059080956d-02,
     |  -6.8294446078615d-02, 1.6718814898268d-02, 5.7677147944721d-02,
     |  -3.9767910399266d-02,-4.5750829868780d-02, 4.0340169142868d-02,
     |   6.0558885344381d-02, 2.5432472229973d-02, 4.0652592593073d-03,
     |   1.9148574703246d-04, 8.7133669860991d-07, 6.6921994109720d-08/
      data (zmn(lat,11,24), lat = 1,36)/
     |  -3.2017812366689d-07, 4.4268068890690d-07, 4.4404728666769d-05,
     |   1.4258650009985d-03, 1.2866021771335d-02, 4.6251928333781d-02,
     |   6.6938863965274d-02, 6.3205316685219d-03,-6.5506427608261d-02,
     |  -2.9955274741489d-03, 6.7770194920726d-02,-2.3032581492277d-02,
     |  -5.8395754390619d-02, 5.5337014523552d-02, 2.6760768176087d-02,
     |  -7.2878975638802d-02, 2.0068855535629d-02, 6.0117909318400d-02,
     |  -6.0117909318399d-02,-2.0068855535629d-02, 7.2878975638802d-02,
     |  -2.6760768176087d-02,-5.5337014523552d-02, 5.8395754390619d-02,
     |   2.3032581492277d-02,-6.7770194920726d-02, 2.9955274741488d-03,
     |   6.5506427608261d-02,-6.3205316685216d-03,-6.6938863965274d-02,
     |  -4.6251928333781d-02,-1.2866021771335d-02,-1.4258650009986d-03,
     |  -4.4404728666788d-05,-4.4268068877116d-07, 3.2017812356351d-07/
      data (zmn(lat,12,24), lat = 1,36)/
     |  -6.3578081517867d-09, 3.4088984759703d-08, 9.2380390263621d-06,
     |   4.3816583258221d-04, 5.5652381627342d-03, 2.8388589615470d-02,
     |   6.5577062311445d-02, 5.5190091721891d-02,-3.2007213440620d-02,
     |  -6.1808962340871d-02, 3.5776336581701d-02, 5.4958922736388d-02,
     |  -5.5159605618639d-02,-3.2601005716081d-02, 7.1764205642735d-02,
     |  -4.5901387149380d-03,-6.9909004257560d-02, 4.4417319729247d-02,
     |   4.4417319729247d-02,-6.9909004257560d-02,-4.5901387149384d-03,
     |   7.1764205642735d-02,-3.2601005716081d-02,-5.5159605618639d-02,
     |   5.4958922736388d-02, 3.5776336581701d-02,-6.1808962340871d-02,
     |  -3.2007213440620d-02, 5.5190091721890d-02, 6.5577062311445d-02,
     |   2.8388589615470d-02, 5.5652381627341d-03, 4.3816583258226d-04,
     |   9.2380390264185d-06, 3.4088984800562d-08,-6.3578080541508d-09/
      data (zmn(lat,13,24), lat = 1,36)/
     |   3.6599478155142d-08,-3.3306112697974d-08, 1.7464879690990d-06,
     |   1.1906768011712d-04, 2.0937901011451d-03, 1.4628224826300d-02,
     |   4.8517974252319d-02, 7.5432989747601d-02, 2.7468830877326d-02,
     |  -6.1433950805871d-02,-3.8310131941927d-02, 6.3526113288307d-02,
     |   2.7247863130956d-02,-7.2193464407753d-02,-1.7025322457614d-03,
     |   7.3663835971609d-02,-3.1087158055844d-02,-5.9512363788537d-02,
     |   5.9512363788537d-02, 3.1087158055845d-02,-7.3663835971609d-02,
     |   1.7025322457612d-03, 7.2193464407753d-02,-2.7247863130956d-02,
     |  -6.3526113288307d-02, 3.8310131941927d-02, 6.1433950805872d-02,
     |  -2.7468830877325d-02,-7.5432989747601d-02,-4.8517974252319d-02,
     |  -1.4628224826300d-02,-2.0937901011452d-03,-1.1906768011712d-04,
     |  -1.7464879690251d-06, 3.3306112625731d-08,-3.6599478195514d-08/
      data (zmn(lat,14,24), lat = 1,36)/
     |   5.4248225537664d-10,-1.3276363328423d-09, 2.8619457545065d-07,
     |   2.8799314948111d-05, 6.9244703022371d-04, 6.4774440420604d-03,
     |   2.9264353823014d-02, 6.8135554077530d-02, 7.1109344230932d-02,
     |  -7.8866735643189d-03,-7.4255695241855d-02,-5.1758358984550d-03,
     |   7.4887440938392d-02,-4.4287056568106d-03,-7.4645111596038d-02,
     |   2.5498755969343d-02, 6.6845708948590d-02,-4.9082225678126d-02,
     |  -4.9082225678126d-02, 6.6845708948590d-02, 2.5498755969343d-02,
     |  -7.4645111596038d-02,-4.4287056568108d-03, 7.4887440938392d-02,
     |  -5.1758358984546d-03,-7.4255695241856d-02,-7.8866735643191d-03,
     |   7.1109344230932d-02, 6.8135554077530d-02, 2.9264353823014d-02,
     |   6.4774440420604d-03, 6.9244703022378d-04, 2.8799314948125d-05,
     |   2.8619457535821d-07,-1.3276364346822d-09, 5.4248218341239d-10/
      data (zmn(lat,15,24), lat = 1,36)/
     |  -3.5904542876265d-09, 3.4993383859466d-09, 3.8928342027869d-08,
     |   6.2202080422049d-06, 2.0258382827343d-04, 2.4979432169603d-03,
     |   1.4899996693407d-02, 4.7804137440504d-02, 8.1589384807465d-02,
     |   5.3354615269471d-02,-4.1124426159485d-02,-7.0442158940784d-02,
     |   2.7063768855365d-02, 7.2139172031685d-02,-3.1606870951771d-02,
     |  -6.8247429761762d-02, 4.4661305008010d-02, 5.8573274455698d-02,
     |  -5.8573274455697d-02,-4.4661305008010d-02, 6.8247429761762d-02,
     |   3.1606870951771d-02,-7.2139172031685d-02,-2.7063768855365d-02,
     |   7.0442158940784d-02, 4.1124426159485d-02,-5.3354615269471d-02,
     |  -8.1589384807465d-02,-4.7804137440505d-02,-1.4899996693407d-02,
     |  -2.4979432169603d-03,-2.0258382827334d-04,-6.2202080422166d-06,
     |  -3.8928342183959d-08,-3.4993383842358d-09, 3.5904542997658d-09/
      data (zmn(lat,16,24), lat = 1,36)/
     |  -3.9839678147979d-11, 1.1351206302970d-10, 5.4690470521492d-09,
     |   1.1993192176699d-06, 5.2596409590813d-05, 8.4515297155366d-04,
     |   6.5208687389737d-03, 2.7586520497422d-02, 6.6770373657905d-02,
     |   8.5511368503563d-02, 2.7393551961160d-02,-6.5568964872125d-02,
     |  -5.5669432411034d-02, 5.1855587066708d-02, 6.1936087233215d-02,
     |  -5.0462722180693d-02,-6.0278482639485d-02, 5.5129948080101d-02,
     |   5.5129948080101d-02,-6.0278482639484d-02,-5.0462722180693d-02,
     |   6.1936087233215d-02, 5.1855587066708d-02,-5.5669432411034d-02,
     |  -6.5568964872125d-02, 2.7393551961160d-02, 8.5511368503562d-02,
     |   6.6770373657905d-02, 2.7586520497422d-02, 6.5208687389738d-03,
     |   8.4515297155369d-04, 5.2596409590713d-05, 1.1993192177199d-06,
     |   5.4690471503009d-09, 1.1351192181173d-10,-3.9839694216799d-11/
      data (zmn(lat,17,24), lat = 1,36)/
     |   2.8985892126239d-10,-2.8322378151429d-10, 9.4575410474528d-10,
     |   2.0615758578417d-07, 1.2121810747953d-05, 2.5165432008847d-04,
     |   2.4756120846883d-03, 1.3440997006312d-02, 4.3272410042574d-02,
     |   8.2552139386317d-02, 8.0223813999856d-02,-8.7889510140388d-06,
     |  -7.9557546871744d-02,-3.7624425158732d-02, 6.7617561512658d-02,
     |   5.1732192333262d-02,-6.0811037231875d-02,-5.7111038228075d-02,
     |   5.7111038228075d-02, 6.0811037231875d-02,-5.1732192333262d-02,
     |  -6.7617561512659d-02, 3.7624425158732d-02, 7.9557546871744d-02,
     |   8.7889510144775d-06,-8.0223813999856d-02,-8.2552139386317d-02,
     |  -4.3272410042574d-02,-1.3440997006312d-02,-2.4756120846881d-03,
     |  -2.5165432008845d-04,-1.2121810747985d-05,-2.0615758578822d-07,
     |  -9.4575410435315d-10, 2.8322374806447d-10,-2.8985880257393d-10/
      data (zmn(lat,18,24), lat = 1,36)/
     |   2.3840085990268d-12,-6.7914260203199d-12, 8.2119339972242d-11,
     |   3.1586710953962d-08, 2.4735414640763d-06, 6.5905563287443d-05,
     |   8.1788092767789d-04, 5.5960879841738d-03, 2.3114887253690d-02,
     |   5.9677537818771d-02, 9.3130193897005d-02, 6.9245564174627d-02,
     |  -2.3322348801035d-02,-8.5674941028389d-02,-2.3144135188252d-02,
     |   7.6042443794929d-02, 4.7793528374964d-02,-6.3174997876615d-02,
     |  -6.3174997876615d-02, 4.7793528374964d-02, 7.6042443794929d-02,
     |  -2.3144135188252d-02,-8.5674941028389d-02,-2.3322348801034d-02,
     |   6.9245564174627d-02, 9.3130193897005d-02, 5.9677537818771d-02,
     |   2.3114887253690d-02, 5.5960879841738d-03, 8.1788092767771d-04,
     |   6.5905563287437d-05, 2.4735414642091d-06, 3.1586710956361d-08,
     |   8.2119307323821d-11,-6.7913604688270d-12, 2.3840317320485d-12/
      data (zmn(lat,19,24), lat = 1,36)/
     |  -1.8100929741890d-11, 1.7780734016098d-11,-1.0440228208522d-11,
     |   4.2900923970150d-09, 4.4430658788001d-07, 1.5112785849426d-05,
     |   2.3467695841736d-04, 1.9973135339899d-03, 1.0344032080583d-02,
     |   3.4438464290585d-02, 7.4525410133948d-02, 9.8881067489570d-02,
     |   5.7716066498060d-02,-3.9373590468890d-02,-8.8536271877201d-02,
     |  -1.7439944188619d-02, 7.9017502891116d-02, 5.4783433212611d-02,
     |  -5.4783433212611d-02,-7.9017502891116d-02, 1.7439944188618d-02,
     |   8.8536271877201d-02, 3.9373590468890d-02,-5.7716066498060d-02,
     |  -9.8881067489570d-02,-7.4525410133948d-02,-3.4438464290585d-02,
     |  -1.0344032080583d-02,-1.9973135339899d-03,-2.3467695841742d-04,
     |  -1.5112785849448d-05,-4.4430658790421d-07,-4.2900923347616d-09,
     |   1.0440375281972d-11,-1.7780711476835d-11, 1.8101049213315d-11/
      data (zmn(lat,20,24), lat = 1,36)/
     |  -1.0694202828514d-13, 3.0768181847491d-13, 8.6427365388853d-14,
     |   5.0566304062456d-10, 6.9539877772806d-08, 3.0063553743894d-06,
     |   5.8042643836720d-05, 6.0850609532168d-04, 3.8890599084251d-03,
     |   1.6221536200168d-02, 4.5653525114208d-02, 8.6400780027397d-02,
     |   1.0223064619667d-01, 5.0996374157758d-02,-4.6454700271971d-02,
     |  -9.2253701556007d-02,-2.5105138262967d-02, 7.4541747012737d-02,
     |   7.4541747012737d-02,-2.5105138262967d-02,-9.2253701556007d-02,
     |  -4.6454700271971d-02, 5.0996374157757d-02, 1.0223064619667d-01,
     |   8.6400780027397d-02, 4.5653525114208d-02, 1.6221536200168d-02,
     |   3.8890599084252d-03, 6.0850609532171d-04, 5.8042643836906d-05,
     |   3.0063553743490d-06, 6.9539877626355d-08, 5.0566301255855d-10,
     |   8.6514241924055d-14, 3.0784286777973d-13,-1.0702706570431d-13/
      data (zmn(lat,21,24), lat = 1,36)/
     |   7.8684635920585d-13,-7.7606569352902d-13, 7.9544196363324d-13,
     |   5.0521978616915d-11, 9.3224012988661d-09, 5.1038388465553d-07,
     |   1.2188513453484d-05, 1.5621739297941d-04, 1.2178949418431d-03,
     |   6.2436234713422d-03, 2.2051864530832d-02, 5.4790481920382d-02,
     |   9.4857628153678d-02, 1.0650692279126d-01, 5.4211284340548d-02,
     |  -4.1695956161792d-02,-9.7211202153189d-02,-5.0862132196652d-02,
     |   5.0862132196652d-02, 9.7211202153189d-02, 4.1695956161792d-02,
     |  -5.4211284340548d-02,-1.0650692279126d-01,-9.4857628153678d-02,
     |  -5.4790481920382d-02,-2.2051864530832d-02,-6.2436234713421d-03,
     |  -1.2178949418430d-03,-1.5621739297938d-04,-1.2188513453471d-05,
     |  -5.1038388462551d-07,-9.3224012986593d-09,-5.0522030934888d-11,
     |  -7.9555311477791d-13, 7.7603911121269d-13,-7.8700437205324d-13/
      data (zmn(lat,22,24), lat = 1,36)/
     |   3.1514984328990d-15,-9.0420998326310d-15, 1.6045333855900d-14,
     |   4.3165046527703d-12, 1.0392071775379d-09, 7.1844618932077d-08,
     |   2.1133110149048d-06, 3.2915181199155d-05, 3.1027861005042d-04,
     |   1.9286732662818d-03, 8.3572365060723d-03, 2.6119796443567d-02,
     |   5.9790700422054d-02, 9.9487163253809d-02, 1.1416633793799d-01,
     |   7.2312106304372d-02,-1.7084660938236d-02,-9.3072252323337d-02,
     |  -9.3072252323337d-02,-1.7084660938236d-02, 7.2312106304372d-02,
     |   1.1416633793799d-01, 9.9487163253809d-02, 5.9790700422054d-02,
     |   2.6119796443567d-02, 8.3572365060722d-03, 1.9286732662818d-03,
     |   3.1027861005036d-04, 3.2915181199141d-05, 2.1133110148519d-06,
     |   7.1844618987805d-08, 1.0392072581911d-09, 4.3165395150461d-12,
     |   1.6057624571080d-14,-9.0793321824106d-15, 3.2200229045193d-15/
      data (zmn(lat,23,24), lat = 1,36)/
     |  -1.8891892196034d-14, 1.8496046909573d-14,-1.8307548811986d-14,
     |   3.0617202492116d-13, 9.1046757708516d-11, 7.9294685054146d-09,
     |   2.8628962144094d-07, 5.3923439339343d-06, 6.1039511575260d-05,
     |   4.5541195850610d-04, 2.3835633507818d-03, 9.1305510395955d-03,
     |   2.6319621265370d-02, 5.7967934162540d-02, 9.7676413022469d-02,
     |   1.2327440822517d-01, 1.0757791374801d-01, 4.3185131619297d-02,
     |  -4.3185131619296d-02,-1.0757791374801d-01,-1.2327440822517d-01,
     |  -9.7676413022469d-02,-5.7967934162540d-02,-2.6319621265370d-02,
     |  -9.1305510395955d-03,-2.3835633507817d-03,-4.5541195850607d-04,
     |  -6.1039511575245d-05,-5.3923439339272d-06,-2.8628962141766d-07,
     |  -7.9294685474090d-09,-9.1046797513205d-11,-3.0613935202349d-13,
     |   1.8364620992217d-14,-1.8458640798769d-14, 1.8872644693961d-14/
      data (zmn(lat,24,24), lat = 1,36)/
     |  -1.1869464069066d-16, 2.5200153975392d-17,-2.4169697539446d-16,
     |   1.3266623925238d-14, 5.4440688042992d-12, 5.9579845783629d-10,
     |   2.6325239840319d-08, 5.9722425589473d-07, 8.0731476049517d-06,
     |   7.1735040857423d-05, 4.4835870618749d-04, 2.0686596223590d-03,
     |   7.2976384148939d-03, 2.0199605610062d-02, 4.4714335529570d-02,
     |   8.0259614648028d-02, 1.1794333301586d-01, 1.4276459522203d-01,
     |   1.4276459522203d-01, 1.1794333301586d-01, 8.0259614648028d-02,
     |   4.4714335529570d-02, 2.0199605610062d-02, 7.2976384148938d-03,
     |   2.0686596223590d-03, 4.4835870618749d-04, 7.1735040857440d-05,
     |   8.0731476049558d-06, 5.9722425588940d-07, 2.6325239855101d-08,
     |   5.9579844043436d-10, 5.4440336851353d-12, 1.3237324645671d-14,
     |  -2.7033923759988d-16, 1.0384743245893d-17,-1.2450685784087d-16/
      data (zmn(lat, 0,25), lat = 1,36)/
     |   1.0144757022407d-02,-1.7573293179503d-02,-6.7879388575324d-04,
     |   3.0742818936555d-02,-4.3521487427867d-02, 2.1727229519077d-02,
     |   2.1851888888059d-02,-5.2379560719944d-02, 4.1945706677778d-02,
     |   4.9826177299175d-03,-5.2441172897746d-02, 6.1190556518532d-02,
     |  -2.1597931975582d-02,-3.6636247276105d-02, 6.7216905594143d-02,
     |  -4.4679676529791d-02,-1.4180702914339d-02, 6.3026978489356d-02,
     |  -6.3026978489356d-02, 1.4180702914339d-02, 4.4679676529792d-02,
     |  -6.7216905594143d-02, 3.6636247276105d-02, 2.1597931975581d-02,
     |  -6.1190556518532d-02, 5.2441172897747d-02,-4.9826177299173d-03,
     |  -4.1945706677778d-02, 5.2379560719944d-02,-2.1851888888058d-02,
     |  -2.1727229519078d-02, 4.3521487427867d-02,-3.0742818936555d-02,
     |   6.7879388575324d-04, 1.7573293179503d-02,-1.0144757022407d-02/
      data (zmn(lat, 1,25), lat = 1,36)/
     |   1.2063044505985d-02, 1.0461223519981d-02,-3.1538915838063d-02,
     |   2.6074477000173d-02, 7.2483664798289d-03,-4.2120564800363d-02,
     |   4.6503383069598d-02,-1.1758034357476d-02,-3.6960624880227d-02,
     |   5.9656405360377d-02,-3.4986883810096d-02,-2.0045075155479d-02,
     |   6.1996072013688d-02,-5.5921589951443d-02, 4.7857459019220d-03,
     |   5.1577329694185d-02,-6.8034815685184d-02, 3.0827221517617d-02,
     |   3.0827221517617d-02,-6.8034815685184d-02, 5.1577329694184d-02,
     |   4.7857459019223d-03,-5.5921589951443d-02, 6.1996072013688d-02,
     |  -2.0045075155478d-02,-3.4986883810096d-02, 5.9656405360377d-02,
     |  -3.6960624880226d-02,-1.1758034357476d-02, 4.6503383069598d-02,
     |  -4.2120564800363d-02, 7.2483664798285d-03, 2.6074477000173d-02,
     |  -3.1538915838064d-02, 1.0461223519981d-02, 1.2063044505985d-02/
      data (zmn(lat, 2,25), lat = 1,36)/
     |   3.3047053868630d-03, 2.6597822017142d-02,-1.2158451311894d-02,
     |  -2.3097292933277d-02, 4.4023985487502d-02,-2.7339240723664d-02,
     |  -1.6819626861215d-02, 5.1846990652215d-02,-4.5711597363325d-02,
     |  -2.0777839932999d-04, 4.9959621709136d-02,-6.1861949532603d-02,
     |   2.3761534629354d-02, 3.5261988443461d-02,-6.7578969734381d-02,
     |   4.6015195849269d-02, 1.3136222286617d-02,-6.2658556872633d-02,
     |   6.2658556872633d-02,-1.3136222286616d-02,-4.6015195849270d-02,
     |   6.7578969734380d-02,-3.5261988443461d-02,-2.3761534629353d-02,
     |   6.1861949532603d-02,-4.9959621709136d-02, 2.0777839932985d-04,
     |   4.5711597363325d-02,-5.1846990652214d-02, 1.6819626861214d-02,
     |   2.7339240723664d-02,-4.4023985487501d-02, 2.3097292933277d-02,
     |   1.2158451311894d-02,-2.6597822017142d-02,-3.3047053868628d-03/
      data (zmn(lat, 3,25), lat = 1,36)/
     |  -1.7000294266972d-04, 2.1350808903527d-02, 2.2992207149204d-02,
     |  -3.7701973917527d-02, 9.4817533057849d-03, 3.3973144664558d-02,
     |  -5.0809043380726d-02, 2.2444751701733d-02, 2.9212182534479d-02,
     |  -5.9871397177112d-02, 4.1137870713558d-02, 1.3895279993785d-02,
     |  -6.0238606436912d-02, 5.8397217795776d-02,-8.1591285655916d-03,
     |  -5.0129305969273d-02, 6.8518371084082d-02,-3.1354021751049d-02,
     |  -3.1354021751049d-02, 6.8518371084082d-02,-5.0129305969272d-02,
     |  -8.1591285655919d-03, 5.8397217795777d-02,-6.0238606436912d-02,
     |   1.3895279993785d-02, 4.1137870713558d-02,-5.9871397177112d-02,
     |   2.9212182534479d-02, 2.2444751701734d-02,-5.0809043380726d-02,
     |   3.3973144664558d-02, 9.4817533057853d-03,-3.7701973917527d-02,
     |   2.2992207149204d-02, 2.1350808903526d-02,-1.7000294266961d-04/
      data (zmn(lat, 4,25), lat = 1,36)/
     |  -5.7376448142073d-06, 1.0384214066922d-02, 3.7705640617081d-02,
     |  -5.8135141033949d-03,-3.8309717261782d-02, 4.2569454762700d-02,
     |  -1.7023036739114d-03,-4.5445731576580d-02, 5.3772484557575d-02,
     |  -1.3074111932002d-02,-4.2462599147029d-02, 6.4035686821384d-02,
     |  -3.1113435624401d-02,-2.9881673736437d-02, 6.7478796640486d-02,
     |  -4.9060373516735d-02,-1.0868554181451d-02, 6.2442221726274d-02,
     |  -6.2442221726274d-02, 1.0868554181451d-02, 4.9060373516736d-02,
     |  -6.7478796640486d-02, 2.9881673736436d-02, 3.1113435624400d-02,
     |  -6.4035686821384d-02, 4.2462599147030d-02, 1.3074111932002d-02,
     |  -5.3772484557575d-02, 4.5445731576579d-02, 1.7023036739120d-03,
     |  -4.2569454762700d-02, 3.8309717261781d-02, 5.8135141033948d-03,
     |  -3.7705640617080d-02,-1.0384214066922d-02, 5.7376448139458d-06/
      data (zmn(lat, 5,25), lat = 1,36)/
     |   1.2919375340746d-04, 3.6539983493546d-03, 3.1071196548794d-02,
     |   3.2063860946353d-02,-3.9020194646890d-02,-8.1241632843432d-03,
     |   5.0278956605645d-02,-4.1463780788935d-02,-1.0693379100675d-02,
     |   5.6431907904025d-02,-5.1783245765473d-02,-9.8065819985817d-04,
     |   5.5457553951850d-02,-6.2711841742856d-02, 1.4992012708904d-02,
     |   4.6979966722603d-02,-6.9408094526618d-02, 3.2421409669499d-02,
     |   3.2421409669499d-02,-6.9408094526618d-02, 4.6979966722602d-02,
     |   1.4992012708904d-02,-6.2711841742856d-02, 5.5457553951851d-02,
     |  -9.8065819985769d-04,-5.1783245765472d-02, 5.6431907904025d-02,
     |  -1.0693379100674d-02,-4.1463780788936d-02, 5.0278956605645d-02,
     |  -8.1241632843430d-03,-3.9020194646890d-02, 3.2063860946353d-02,
     |   3.1071196548794d-02, 3.6539983493550d-03, 1.2919375340728d-04/
      data (zmn(lat, 6,25), lat = 1,36)/
     |   9.9450597057080d-06, 1.0747434494129d-03, 1.8039685876645d-02,
     |   4.6873109904030d-02, 6.4958229909001d-04,-4.9067186315304d-02,
     |   3.3315739053553d-02, 2.4193973946082d-02,-5.8967552055479d-02,
     |   3.4016550629595d-02, 2.6780728223738d-02,-6.4739696606927d-02,
     |   4.2899332455753d-02, 1.9745350584945d-02,-6.6176570821724d-02,
     |   5.3690195921088d-02, 7.2339446121391d-03,-6.2323571674598d-02,
     |   6.2323571674598d-02,-7.2339446121388d-03,-5.3690195921088d-02,
     |   6.6176570821724d-02,-1.9745350584945d-02,-4.2899332455753d-02,
     |   6.4739696606927d-02,-2.6780728223738d-02,-3.4016550629595d-02,
     |   5.8967552055479d-02,-2.4193973946082d-02,-3.3315739053553d-02,
     |   4.9067186315304d-02,-6.4958229908984d-04,-4.6873109904029d-02,
     |  -1.8039685876646d-02,-1.0747434494130d-03,-9.9450597053922d-06/
      data (zmn(lat, 7,25), lat = 1,36)/
     |  -1.9610409302808d-05, 2.8299602149153d-04, 8.2244078230603d-03,
     |   3.9969997205737d-02, 4.0166582564644d-02,-3.7667660718713d-02,
     |  -2.5322484098352d-02, 5.7215585433901d-02,-2.0519326637038d-02,
     |  -4.1816548388307d-02, 6.2292511778982d-02,-1.9081563646630d-02,
     |  -4.5133982287675d-02, 6.7308010537613d-02,-2.5293678250759d-02,
     |  -4.1648637594279d-02, 7.0553179019023d-02,-3.4064059490220d-02,
     |  -3.4064059490220d-02, 7.0553179019023d-02,-4.1648637594278d-02,
     |  -2.5293678250760d-02, 6.7308010537613d-02,-4.5133982287676d-02,
     |  -1.9081563646630d-02, 6.2292511778982d-02,-4.1816548388307d-02,
     |  -2.0519326637039d-02, 5.7215585433902d-02,-2.5322484098351d-02,
     |  -3.7667660718713d-02, 4.0166582564644d-02, 3.9969997205737d-02,
     |   8.2244078230605d-03, 2.8299602149112d-04,-1.9610409302639d-05/
      data (zmn(lat, 8,25), lat = 1,36)/
     |  -1.1115918038391d-06, 5.8223543952913d-05, 3.1128006274716d-03,
     |   2.5358328282519d-02, 5.5075824626772d-02, 8.0519290013100d-03,
     |  -5.6516907084603d-02, 1.8335477046249d-02, 4.6812550405897d-02,
     |  -5.6441659533364d-02, 3.7706586861717d-04, 5.8501467969337d-02,
     |  -5.6885121262850d-02,-3.9743277170744d-03, 6.2383004183474d-02,
     |  -5.9634996320842d-02,-1.9713856672879d-03, 6.2187764319834d-02,
     |  -6.2187764319834d-02, 1.9713856672878d-03, 5.9634996320842d-02,
     |  -6.2383004183474d-02, 3.9743277170742d-03, 5.6885121262850d-02,
     |  -5.8501467969336d-02,-3.7706586861704d-04, 5.6441659533365d-02,
     |  -4.6812550405897d-02,-1.8335477046249d-02, 5.6516907084604d-02,
     |  -8.0519290013098d-03,-5.5075824626772d-02,-2.5358328282520d-02,
     |  -3.1128006274716d-03,-5.8223543952936d-05, 1.1115918035691d-06/
      data (zmn(lat, 9,25), lat = 1,36)/
     |   2.9362794584400d-06, 7.4377623298715d-06, 1.0069518819906d-03,
     |   1.3005278367321d-02, 4.7770980569237d-02, 4.8479338834195d-02,
     |  -3.3369528770641d-02,-4.2099502990396d-02, 5.4800373753267d-02,
     |   7.9715766527382d-03,-6.2956251871783d-02, 4.4147205086725d-02,
     |   2.6046914666153d-02,-6.9328829861427d-02, 3.8731524836669d-02,
     |   3.3422576130028d-02,-7.1695753288517d-02, 3.6339299166812d-02,
     |   3.6339299166812d-02,-7.1695753288517d-02, 3.3422576130028d-02,
     |   3.8731524836669d-02,-6.9328829861427d-02, 2.6046914666153d-02,
     |   4.4147205086726d-02,-6.2956251871783d-02, 7.9715766527379d-03,
     |   5.4800373753267d-02,-4.2099502990396d-02,-3.3369528770642d-02,
     |   4.8479338834195d-02, 4.7770980569237d-02, 1.3005278367321d-02,
     |   1.0069518819906d-03, 7.4377623302864d-06, 2.9362794583037d-06/
      data (zmn(lat,10,25), lat = 1,36)/
     |   1.3141797877679d-07, 1.2490302850048d-06, 2.8192964911783d-04,
     |   5.6193452849096d-03, 3.1764065582778d-02, 6.2661344941321d-02,
     |   1.7571787397635d-02,-6.0356643094316d-02,-2.0729807380609d-03,
     |   6.2900834353276d-02,-3.7130909549712d-02,-3.8038667410241d-02,
     |   6.8103178901931d-02,-1.7803062890618d-02,-5.4091120314690d-02,
     |   6.6224200340349d-02,-5.1790892639729d-03,-6.1970193086452d-02,
     |   6.1970193086452d-02, 5.1790892639729d-03,-6.6224200340349d-02,
     |   5.4091120314690d-02, 1.7803062890618d-02,-6.8103178901931d-02,
     |   3.8038667410240d-02, 3.7130909549712d-02,-6.2900834353276d-02,
     |   2.0729807380609d-03, 6.0356643094316d-02,-1.7571787397635d-02,
     |  -6.2661344941321d-02,-3.1764065582778d-02,-5.6193452849096d-03,
     |  -2.8192964911781d-04,-1.2490302850463d-06,-1.3141797850144d-07/
      data (zmn(lat,11,25), lat = 1,36)/
     |  -3.9959388096824d-07, 5.9114451096501d-07, 6.9077611250471d-05,
     |   2.0950545494335d-03, 1.7352558868168d-02, 5.4230198253543d-02,
     |   5.7720826688834d-02,-2.4826257880570d-02,-5.7753013768494d-02,
     |   4.1489031740763d-02, 3.9589887765308d-02,-6.5814020210440d-02,
     |   3.9875771090036d-03, 6.4254263420179d-02,-5.4120744754277d-02,
     |  -2.1400017688767d-02, 7.2424546965353d-02,-3.9334806963636d-02,
     |  -3.9334806963637d-02, 7.2424546965353d-02,-2.1400017688766d-02,
     |  -5.4120744754277d-02, 6.4254263420179d-02, 3.9875771090033d-03,
     |  -6.5814020210440d-02, 3.9589887765308d-02, 4.1489031740763d-02,
     |  -5.7753013768494d-02,-2.4826257880570d-02, 5.7720826688834d-02,
     |   5.4230198253543d-02, 1.7352558868168d-02, 2.0950545494336d-03,
     |   6.9077611250411d-05, 5.9114451057144d-07,-3.9959388078075d-07/
      data (zmn(lat,12,25), lat = 1,36)/
     |  -1.4580250288763d-08, 6.8664819096672d-08, 1.5142213346816d-05,
     |   6.8416033101810d-04, 8.0640343402659d-03, 3.6719339288755d-02,
     |   6.9639285342838d-02, 3.0350006666468d-02,-5.8805696375804d-02,
     |  -2.7474373907119d-02, 6.7276193468494d-02,-1.6912067805056d-03,
     |  -6.7527386317330d-02, 4.3903464783786d-02, 3.8733560743073d-02,
     |  -7.2202210805690d-02, 1.4504962224259d-02, 6.1612011516815d-02,
     |  -6.1612011516815d-02,-1.4504962224259d-02, 7.2202210805690d-02,
     |  -3.8733560743073d-02,-4.3903464783786d-02, 6.7527386317331d-02,
     |   1.6912067805063d-03,-6.7276193468494d-02, 2.7474373907119d-02,
     |   5.8805696375804d-02,-3.0350006666468d-02,-6.9639285342838d-02,
     |  -3.6719339288755d-02,-8.0640343402661d-03,-6.8416033101821d-04,
     |  -1.5142213346812d-05,-6.8664819211300d-08, 1.4580250055263d-08/
      data (zmn(lat,13,25), lat = 1,36)/
     |   4.8590555773682d-08,-4.2146579939744d-08, 3.0176637484091d-06,
     |   1.9771668295479d-04, 3.2530070570302d-03, 2.0634933754431d-02,
     |   5.8929746139672d-02, 6.8131829993672d-02,-1.0157759571483d-02,
     |  -6.9669828605502d-02, 1.5202731542274d-02, 6.6230374145438d-02,
     |  -4.2041385408830d-02,-4.6159777982071d-02, 6.8607176294517d-02,
     |   4.6293233672420d-03,-7.2100960651630d-02, 4.3183710012762d-02,
     |   4.3183710012762d-02,-7.2100960651630d-02, 4.6293233672415d-03,
     |   6.8607176294517d-02,-4.6159777982071d-02,-4.2041385408830d-02,
     |   6.6230374145438d-02, 1.5202731542273d-02,-6.9669828605502d-02,
     |  -1.0157759571483d-02, 6.8131829993672d-02, 5.8929746139672d-02,
     |   2.0634933754431d-02, 3.2530070570303d-03, 1.9771668295481d-04,
     |   3.0176637484466d-06,-4.2146579627080d-08, 4.8590555592268d-08/
      data (zmn(lat,14,25), lat = 1,36)/
     |   1.4710066887812d-09,-3.8034067781873d-09, 5.2992382974025d-07,
     |   5.0941063163681d-05, 1.1535150364440d-03, 9.9151490965879d-03,
     |   3.9624899621311d-02, 7.5532085920614d-02, 4.7094210797243d-02,
     |  -4.8499579521155d-02,-5.5099646946906d-02, 5.2447777476769d-02,
     |   4.3074798635865d-02,-6.8085845825972d-02,-1.3796873032106d-02,
     |   7.5414234875463d-02,-2.6310782077992d-02,-6.1034246770529d-02,
     |   6.1034246770529d-02, 2.6310782077992d-02,-7.5414234875463d-02,
     |   1.3796873032106d-02, 6.8085845825972d-02,-4.3074798635866d-02,
     |  -5.2447777476769d-02, 5.5099646946906d-02, 4.8499579521155d-02,
     |  -4.7094210797243d-02,-7.5532085920614d-02,-3.9624899621311d-02,
     |  -9.9151490965879d-03,-1.1535150364439d-03,-5.0941063163562d-05,
     |  -5.2992382987814d-07, 3.8034069486544d-09,-1.4710065040858d-09/
      data (zmn(lat,15,25), lat = 1,36)/
     |  -5.1396298006032d-09, 4.9035204480277d-09, 7.8529354296528d-08,
     |   1.1753222829013d-05, 3.6241034877875d-04, 4.1432338919336d-03,
     |   2.2249831736388d-02, 6.1129939284321d-02, 7.9079552646986d-02,
     |   1.2529542004861d-02,-7.2115613007515d-02,-2.3704048692457d-02,
     |   7.3290152537910d-02, 9.9603668354602d-03,-7.6563236512334d-02,
     |   1.7542880100201d-02, 6.9735949573501d-02,-4.8093665658843d-02,
     |  -4.8093665658843d-02, 6.9735949573501d-02, 1.7542880100202d-02,
     |  -7.6563236512334d-02, 9.9603668354601d-03, 7.3290152537910d-02,
     |  -2.3704048692456d-02,-7.2115613007516d-02, 1.2529542004861d-02,
     |   7.9079552646986d-02, 6.1129939284321d-02, 2.2249831736389d-02,
     |   4.1432338919335d-03, 3.6241034877870d-04, 1.1753222829003d-05,
     |   7.8529354294158d-08, 4.9035202196429d-09,-5.1396297415628d-09/
      data (zmn(lat,16,25), lat = 1,36)/
     |  -1.2988483673061d-10, 3.7354515942135d-10, 1.1275563357110d-08,
     |   2.4312319257352d-06, 1.0134844430963d-04, 1.5206141236101d-03,
     |   1.0696053745998d-02, 3.9786142341949d-02, 7.9075131175543d-02,
     |   6.7253118013334d-02,-2.4905974289998d-02,-7.6706506618577d-02,
     |   1.1903560633594d-02, 7.6645453733044d-02,-2.1473392518140d-02,
     |  -7.2362433751137d-02, 4.0858774893028d-02, 6.0116708058296d-02,
     |  -6.0116708058296d-02,-4.0858774893028d-02, 7.2362433751137d-02,
     |   2.1473392518140d-02,-7.6645453733044d-02,-1.1903560633593d-02,
     |   7.6706506618576d-02, 2.4905974289998d-02,-6.7253118013334d-02,
     |  -7.9075131175543d-02,-3.9786142341949d-02,-1.0696053745998d-02,
     |  -1.5206141236101d-03,-1.0134844430963d-04,-2.4312319256333d-06,
     |  -1.1275563251216d-08,-3.7354513538960d-10, 1.2988485845213d-10/
      data (zmn(lat,17,25), lat = 1,36)/
     |   4.5644619072144d-10,-4.3684710816299d-10, 1.9260511902537d-09,
     |   4.5075183771505d-07, 2.5275247461813d-05, 4.9275383625073d-04,
     |   4.4612887298162d-03, 2.1675659981115d-02, 5.9674902704763d-02,
     |   8.8381472918634d-02, 4.3651236261493d-02,-5.5744013418514d-02,
     |  -6.6130364615490d-02, 4.1880023018516d-02, 6.8594539567894d-02,
     |  -4.4674519981765d-02,-6.3774204361343d-02, 5.4408110967498d-02,
     |   5.4408110967499d-02,-6.3774204361342d-02,-4.4674519981765d-02,
     |   6.8594539567893d-02, 4.1880023018516d-02,-6.6130364615490d-02,
     |  -5.5744013418515d-02, 4.3651236261494d-02, 8.8381472918634d-02,
     |   5.9674902704763d-02, 2.1675659981115d-02, 4.4612887298164d-03,
     |   4.9275383625069d-04, 2.5275247461927d-05, 4.5075183772460d-07,
     |   1.9260513488651d-09,-4.3684701446816d-10, 4.5644628152982d-10/
      data (zmn(lat,18,25), lat = 1,36)/
     |   9.5781559443354d-12,-2.7626443720526d-11, 2.1879938180560d-10,
     |   7.4934278480008d-08, 5.6178174428036d-06, 1.4122539713157d-04,
     |   1.6250839966314d-03, 1.0077522169978d-02, 3.6491175901744d-02,
     |   7.7962972352716d-02, 8.7508975088392d-02, 1.5307290718946d-02,
     |  -7.5584924540034d-02,-4.8543651957517d-02, 6.2156687228037d-02,
     |   5.7698461243520d-02,-5.8221638295388d-02,-5.8662918584677d-02,
     |   5.8662918584677d-02, 5.8221638295388d-02,-5.7698461243519d-02,
     |  -6.2156687228037d-02, 4.8543651957517d-02, 7.5584924540034d-02,
     |  -1.5307290718945d-02,-8.7508975088392d-02,-7.7962972352716d-02,
     |  -3.6491175901744d-02,-1.0077522169978d-02,-1.6250839966314d-03,
     |  -1.4122539713158d-04,-5.6178174428096d-06,-7.4934278619590d-08,
     |  -2.1879943890997d-10, 2.7626377712312d-11,-9.5783012531125d-12/
      data (zmn(lat,19,25), lat = 1,36)/
     |  -3.2379349239612d-11, 3.1223288604129d-11,-1.1001007181282d-11,
     |   1.1145394551603d-08, 1.1092918819676d-06, 3.5742054819571d-05,
     |   5.1776696986490d-04, 4.0327554285037d-03, 1.8622761290698d-02,
     |   5.3140064533815d-02, 9.1608241529935d-02, 7.8915587312969d-02,
     |  -1.0823817124097d-02,-8.5506131429656d-02,-3.2291513748685d-02,
     |   7.3452194508452d-02, 5.1675105147830d-02,-6.2753881379789d-02,
     |  -6.2753881379789d-02, 5.1675105147830d-02, 7.3452194508453d-02,
     |  -3.2291513748685d-02,-8.5506131429656d-02,-1.0823817124097d-02,
     |   7.8915587312969d-02, 9.1608241529935d-02, 5.3140064533815d-02,
     |   1.8622761290698d-02, 4.0327554285038d-03, 5.1776696986484d-04,
     |   3.5742054819619d-05, 1.1092918819145d-06, 1.1145394589625d-08,
     |  -1.1001139294344d-11, 3.1223294981295d-11,-3.2379441349457d-11/
      data (zmn(lat,20,25), lat = 1,36)/
     |  -5.5263081938639d-13, 1.6064844732433d-12,-8.6048121634714d-13,
     |   1.4634835287964d-09, 1.9337646345656d-07, 7.9465964905511d-06,
     |   1.4384928895086d-04, 1.3907644073068d-03, 8.0249398176887d-03,
     |   2.9341101821133d-02, 6.9096771460853d-02, 9.9916738152227d-02,
     |   6.7698397734885d-02,-3.0060154471022d-02,-8.9932483083682d-02,
     |  -2.3966721885917d-02, 7.7916915042679d-02, 5.6318907625780d-02,
     |  -5.6318907625780d-02,-7.7916915042679d-02, 2.3966721885917d-02,
     |   8.9932483083682d-02, 3.0060154471022d-02,-6.7698397734885d-02,
     |  -9.9916738152228d-02,-6.9096771460853d-02,-2.9341101821133d-02,
     |  -8.0249398176887d-03,-1.3907644073068d-03,-1.4384928895098d-04,
     |  -7.9465964904872d-06,-1.9337646349222d-07,-1.4634834736225d-09,
     |   8.6055165714885d-13,-1.6066245114233d-12, 5.5263272996273d-13/
      data (zmn(lat,21,25), lat = 1,36)/
     |   1.6960305711355d-12,-1.6442357822814d-12, 1.6834042112053d-12,
     |   1.6653034137669d-10, 2.9445137671365d-08, 1.5369435392718d-06,
     |   3.4561209785848d-05, 4.1107394306305d-04, 2.9213329964955d-03,
     |   1.3337044177225d-02, 4.0585902757253d-02, 8.2385889578644d-02,
     |   1.0467768362184d-01, 5.9802918405121d-02,-3.9801550840177d-02,
     |  -9.3597375976671d-02,-2.8932979776478d-02, 7.4477615044318d-02,
     |   7.4477615044318d-02,-2.8932979776478d-02,-9.3597375976671d-02,
     |  -3.9801550840177d-02, 5.9802918405121d-02, 1.0467768362184d-01,
     |   8.2385889578644d-02, 4.0585902757252d-02, 1.3337044177225d-02,
     |   2.9213329964955d-03, 4.1107394306292d-04, 3.4561209785747d-05,
     |   1.5369435391917d-06, 2.9445137726830d-08, 1.6653038278299d-10,
     |   1.6835955530083d-12,-1.6442459838959d-12, 1.6960734345014d-12/
      data (zmn(lat,22,25), lat = 1,36)/
     |   2.2382561799459d-14,-6.5592790683027d-14, 1.1299926197988d-13,
     |   1.6484329902064d-11, 3.8480316554352d-09, 2.5428476314136d-07,
     |   7.0691390599926d-06, 1.0271355168097d-04, 8.8940698198111d-04,
     |   4.9819044079652d-03, 1.8968811123199d-02, 5.0256531770606d-02,
     |   9.2037643727133d-02, 1.0912702406396d-01, 6.1031345023156d-02,
     |  -3.7051771191191d-02,-9.7849932784654d-02,-5.2332309849434d-02,
     |   5.2332309849434d-02, 9.7849932784655d-02, 3.7051771191192d-02,
     |  -6.1031345023156d-02,-1.0912702406396d-01,-9.2037643727133d-02,
     |  -5.0256531770606d-02,-1.8968811123199d-02,-4.9819044079653d-03,
     |  -8.8940698198116d-04,-1.0271355168101d-04,-7.0691390599958d-06,
     |  -2.5428476314914d-07,-3.8480316073877d-09,-1.6484314281106d-11,
     |  -1.1294616770879d-13, 6.5640530806133d-14,-2.2491454893517d-14/
      data (zmn(lat,23,25), lat = 1,36)/
     |  -5.6558651718237d-14, 5.4867035373072d-14,-5.1802169449460d-14,
     |   1.4215155620053d-12, 4.1894214381707d-10, 3.4954770632483d-08,
     |   1.1965744805122d-06, 2.1119163034670d-05, 2.2098880181522d-04,
     |   1.4995777767523d-03, 6.9955407590586d-03, 2.3260586125732d-02,
     |   5.6070796813911d-02, 9.7408916978348d-02, 1.1603568114143d-01,
     |   7.6826553846621d-02,-1.4175603494828d-02,-9.3476686673804d-02,
     |  -9.3476686673805d-02,-1.4175603494828d-02, 7.6826553846621d-02,
     |   1.1603568114143d-01, 9.7408916978348d-02, 5.6070796813911d-02,
     |   2.3260586125732d-02, 6.9955407590585d-03, 1.4995777767523d-03,
     |   2.2098880181516d-04, 2.1119163034728d-05, 1.1965744805539d-06,
     |   3.4954770717064d-08, 4.1894205477089d-10, 1.4215317063330d-12,
     |  -5.1852461169973d-14, 5.4826176146494d-14,-5.6478948308001d-14/
      data (zmn(lat,24,25), lat = 1,36)/
     |  -5.2644144036437d-16, 1.3932337057483d-15,-2.4695993095375d-15,
     |   9.2461871124854d-14, 3.5917439168259d-11, 3.7741029390205d-09,
     |   1.5855743432796d-07, 3.3836791955855d-06, 4.2506844403841d-05,
     |   3.4609855342182d-04, 1.9492063752091d-03, 7.9376263190126d-03,
     |   2.4064288683405d-02, 5.5203630298335d-02, 9.6022646955335d-02,
     |   1.2405632421245d-01, 1.0994010649653d-01, 4.4471847111704d-02,
     |  -4.4471847111703d-02,-1.0994010649653d-01,-1.2405632421245d-01,
     |  -9.6022646955335d-02,-5.5203630298335d-02,-2.4064288683405d-02,
     |  -7.9376263190126d-03,-1.9492063752090d-03,-3.4609855342183d-04,
     |  -4.2506844403855d-05,-3.3836791955636d-06,-1.5855743422433d-07,
     |  -3.7741028529176d-09,-3.5917359393828d-11,-9.2378231353737d-14,
     |   2.4563859665213d-15,-1.3403675875868d-15, 5.1619030282185d-16/
      data (zmn(lat,25,25), lat = 1,36)/
     |   7.6449743421776d-16,-8.0552269440318d-16, 6.3018996773779d-16,
     |   3.2101581668276d-15, 2.1047049088201d-12, 2.7784580109340d-10,
     |   1.4285286783546d-08, 3.6718476286207d-07, 5.5084108481379d-06,
     |   5.3414887764792d-05, 3.5924633629194d-04, 1.7620503551930d-03,
     |   6.5374947163618d-03, 1.8847698325679d-02, 4.3069156751924d-02,
     |   7.9136833565521d-02, 1.1809786559722d-01, 1.4404794111051d-01,
     |   1.4404794111051d-01, 1.1809786559722d-01, 7.9136833565521d-02,
     |   4.3069156751924d-02, 1.8847698325679d-02, 6.5374947163618d-03,
     |   1.7620503551930d-03, 3.5924633629197d-04, 5.3414887764806d-05,
     |   5.5084108481685d-06, 3.6718476283689d-07, 1.4285286774771d-08,
     |   2.7784576589448d-10, 2.1047440745780d-12, 3.2218613017210d-15,
     |   6.6014944764223d-16,-7.4984585855193d-16, 6.6361250392565d-16/
      data (zmn(lat, 0,26), lat = 1,36)/
     |   9.8059337594464d-03,-1.9126241235042d-02, 6.1481232779573d-03,
     |   2.2051530706380d-02,-4.3762217722636d-02, 3.9088319332352d-02,
     |  -6.1892383159867d-03,-3.5207339448430d-02, 5.6486991269431d-02,
     |  -4.0535150472201d-02,-4.7976151610454d-03, 5.0415591826218d-02,
     |  -6.5136927953109d-02, 3.7352982321916d-02, 1.6042500364143d-02,
     |  -6.0193995235768d-02, 6.5540431581339d-02,-2.7983679903268d-02,
     |  -2.7983679903268d-02, 6.5540431581339d-02,-6.0193995235768d-02,
     |   1.6042500364142d-02, 3.7352982321917d-02,-6.5136927953109d-02,
     |   5.0415591826218d-02,-4.7976151610458d-03,-4.0535150472201d-02,
     |   5.6486991269431d-02,-3.5207339448430d-02,-6.1892383159871d-03,
     |   3.9088319332352d-02,-4.3762217722636d-02, 2.2051530706379d-02,
     |   6.1481232779574d-03,-1.9126241235042d-02, 9.8059337594465d-03/
      data (zmn(lat, 1,26), lat = 1,36)/
     |   1.3490878727356d-02, 6.6530090779120d-03,-2.9124913932757d-02,
     |   3.2415120359852d-02,-8.8656512681664d-03,-2.7839394008847d-02,
     |   5.1444544616840d-02,-4.2275070034620d-02, 2.8440355214814d-03,
     |   4.1983483422065d-02,-6.1285735910290d-02, 3.9835042968678d-02,
     |   1.0142717017806d-02,-5.6078462464443d-02, 6.6767232655065d-02,
     |  -3.3912249538127d-02,-2.1549136242694d-02, 6.3082491402171d-02,
     |  -6.3082491402171d-02, 2.1549136242694d-02, 3.3912249538128d-02,
     |  -6.6767232655065d-02, 5.6078462464442d-02,-1.0142717017806d-02,
     |  -3.9835042968678d-02, 6.1285735910290d-02,-4.1983483422065d-02,
     |  -2.8440355214817d-03, 4.2275070034620d-02,-5.1444544616840d-02,
     |   2.7839394008847d-02, 8.8656512681665d-03,-3.2415120359852d-02,
     |   2.9124913932757d-02,-6.6530090779121d-03,-1.3490878727356d-02/
      data (zmn(lat, 2,26), lat = 1,36)/
     |   3.6427436607048d-03, 2.6255131934845d-02,-1.8036563577663d-02,
     |  -1.2941287308394d-02, 4.1163740312735d-02,-4.2356845247477d-02,
     |   1.1624195200375d-02, 3.1655910392770d-02,-5.6804478904718d-02,
     |   4.3897008462378d-02, 9.1811577548125d-04,-4.8293959306629d-02,
     |   6.5404145987559d-02,-3.8983263027231d-02,-1.4610264249259d-02,
     |   5.9807382338870d-02,-6.5905327550652d-02, 2.8250691592463d-02,
     |   2.8250691592463d-02,-6.5905327550652d-02, 5.9807382338869d-02,
     |  -1.4610264249259d-02,-3.8983263027232d-02, 6.5404145987559d-02,
     |  -4.8293959306629d-02, 9.1811577548165d-04, 4.3897008462378d-02,
     |  -5.6804478904718d-02, 3.1655910392769d-02, 1.1624195200376d-02,
     |  -4.2356845247477d-02, 4.1163740312735d-02,-1.2941287308394d-02,
     |  -1.8036563577663d-02, 2.6255131934845d-02, 3.6427436607046d-03/
      data (zmn(lat, 3,26), lat = 1,36)/
     |  -4.8455152961604d-04, 2.3169995528465d-02, 1.7268095053164d-02,
     |  -3.9126316261963d-02, 2.4353781829393d-02, 1.5187455512689d-02,
     |  -4.8430631870654d-02, 4.8256382077354d-02,-1.1856250986195d-02,
     |  -3.6400204177051d-02, 6.1963435757079d-02,-4.5009202659030d-02,
     |  -4.6145628255251d-03, 5.3396086245878d-02,-6.7262239871337d-02,
     |   3.5624851435168d-02, 2.0690455945146d-02,-6.3471516200055d-02,
     |   6.3471516200055d-02,-2.0690455945146d-02,-3.5624851435169d-02,
     |   6.7262239871337d-02,-5.3396086245878d-02, 4.6145628255254d-03,
     |   4.5009202659030d-02,-6.1963435757079d-02, 3.6400204177050d-02,
     |   1.1856250986196d-02,-4.8256382077354d-02, 4.8430631870654d-02,
     |  -1.5187455512689d-02,-2.4353781829394d-02, 3.9126316261963d-02,
     |  -1.7268095053165d-02,-2.3169995528465d-02, 4.8455152961596d-04/
      data (zmn(lat, 4,26), lat = 1,36)/
     |  -1.2436441634310d-05, 1.1780849496651d-02, 3.7123764201603d-02,
     |  -1.6203290498867d-02,-2.7261020033308d-02, 4.8686188431611d-02,
     |  -2.8615400650277d-02,-1.7780104403859d-02, 5.4389997470924d-02,
     |  -5.1953481125678d-02, 1.0145302306221d-02, 4.1781942383722d-02,
     |  -6.6096108565570d-02, 4.4092570267584d-02, 9.9145592817850d-03,
     |  -5.8322687128192d-02, 6.6848975618846d-02,-2.9018030368567d-02,
     |  -2.9018030368567d-02, 6.6848975618846d-02,-5.8322687128192d-02,
     |   9.9145592817849d-03, 4.4092570267584d-02,-6.6096108565570d-02,
     |   4.1781942383721d-02, 1.0145302306221d-02,-5.1953481125678d-02,
     |   5.4389997470924d-02,-1.7780104403859d-02,-2.8615400650277d-02,
     |   4.8686188431611d-02,-2.7261020033308d-02,-1.6203290498867d-02,
     |   3.7123764201603d-02, 1.1780849496651d-02,-1.2436441634129d-05/
      data (zmn(lat, 5,26), lat = 1,36)/
     |   2.3721503384211d-04, 4.2697085072125d-03, 3.3765315208329d-02,
     |   2.3775358394581d-02,-4.4820279147050d-02, 1.3536791202245d-02,
     |   3.4791199068435d-02,-5.5473928095151d-02, 2.9945624676502d-02,
     |   2.2192380016851d-02,-6.0103958924055d-02, 5.3589386934502d-02,
     |  -6.0616010054229d-03,-4.7950595496206d-02, 6.8450297291818d-02,
     |  -3.9631142391701d-02,-1.8278355845905d-02, 6.3617497284158d-02,
     |  -6.3617497284158d-02, 1.8278355845905d-02, 3.9631142391701d-02,
     |  -6.8450297291818d-02, 4.7950595496205d-02, 6.0616010054225d-03,
     |  -5.3589386934503d-02, 6.0103958924055d-02,-2.2192380016851d-02,
     |  -2.9945624676502d-02, 5.5473928095151d-02,-3.4791199068435d-02,
     |  -1.3536791202245d-02, 4.4820279147050d-02,-2.3775358394581d-02,
     |  -3.3765315208329d-02,-4.2697085072127d-03,-2.3721503384203d-04/
      data (zmn(lat, 6,26), lat = 1,36)/
     |   1.3661623255941d-05, 1.3372961029247d-03, 2.0941615997706d-02,
     |   4.5701893965947d-02,-1.4498958634013d-02,-3.8840174234713d-02,
     |   4.9750710467127d-02,-9.8573145404406d-03,-4.2286448831176d-02,
     |   6.0267034588378d-02,-2.8081628638688d-02,-2.8863536719379d-02,
     |   6.5321219991598d-02,-5.2043395919854d-02,-1.6913412065054d-03,
     |   5.5386031003820d-02,-6.8284853330040d-02, 3.0308616607121d-02,
     |   3.0308616607121d-02,-6.8284853330040d-02, 5.5386031003820d-02,
     |  -1.6913412065052d-03,-5.2043395919854d-02, 6.5321219991598d-02,
     |  -2.8863536719378d-02,-2.8081628638688d-02, 6.0267034588378d-02,
     |  -4.2286448831176d-02,-9.8573145404415d-03, 4.9750710467127d-02,
     |  -3.8840174234713d-02,-1.4498958634013d-02, 4.5701893965947d-02,
     |   2.0941615997706d-02, 1.3372961029247d-03, 1.3661623255660d-05/
      data (zmn(lat, 7,26), lat = 1,36)/
     |  -4.4415137502587d-05, 3.8754978122974d-04, 1.0100818823113d-02,
     |   4.3665752831938d-02, 2.8924539623760d-02,-4.8558970527089d-02,
     |   1.4199101651153d-03, 4.9926675037020d-02,-5.1723337810201d-02,
     |   3.3533479888099d-03, 5.0631727541055d-02,-6.2712228981410d-02,
     |   2.2048530121166d-02, 3.8266457704660d-02,-6.9270073292069d-02,
     |   4.5676426348999d-02, 1.4293400994300d-02,-6.3623909155420d-02,
     |   6.3623909155420d-02,-1.4293400994300d-02,-4.5676426349000d-02,
     |   6.9270073292069d-02,-3.8266457704659d-02,-2.2048530121165d-02,
     |   6.2712228981411d-02,-5.0631727541056d-02,-3.3533479888102d-03,
     |   5.1723337810201d-02,-4.9926675037020d-02,-1.4199101651156d-03,
     |   4.8558970527089d-02,-2.8924539623760d-02,-4.3665752831938d-02,
     |  -1.0100818823113d-02,-3.8754978122980d-04, 4.4415137502348d-05/
      data (zmn(lat, 8,26), lat = 1,36)/
     |  -1.6828093202149d-06, 7.9914877205186d-05, 4.0419185833209d-03,
     |   3.0009734460713d-02, 5.3179520727686d-02,-1.2170465377205d-02,
     |  -4.9020001727959d-02, 4.5770647335290d-02, 1.1677682116066d-02,
     |  -5.9246930363510d-02, 4.9803526751910d-02, 7.1521812158177d-03,
     |  -5.9690031924527d-02, 6.1324764245006d-02,-1.0312939680389d-02,
     |  -5.0410762348177d-02, 7.0060623667623d-02,-3.2166488174975d-02,
     |  -3.2166488174975d-02, 7.0060623667623d-02,-5.0410762348177d-02,
     |  -1.0312939680390d-02, 6.1324764245006d-02,-5.9690031924527d-02,
     |   7.1521812158170d-03, 4.9803526751910d-02,-5.9246930363510d-02,
     |   1.1677682116066d-02, 4.5770647335290d-02,-4.9020001727959d-02,
     |  -1.2170465377205d-02, 5.3179520727686d-02, 3.0009734460713d-02,
     |   4.0419185833210d-03, 7.9914877205124d-05,-1.6828093198968d-06/
      data (zmn(lat, 9,26), lat = 1,36)/
     |   8.0445794721621d-06, 6.8657144834475d-06, 1.3813902698595d-03,
     |   1.6467773913850d-02, 5.2538895601243d-02, 3.4280864455755d-02,
     |  -5.0499815259178d-02,-1.2520460122779d-02, 6.0487362586761d-02,
     |  -3.7990625789712d-02,-2.6922271857026d-02, 6.6420471464214d-02,
     |  -4.2146550785311d-02,-2.2544621503301d-02, 6.8059030296831d-02,
     |  -5.3364516578491d-02,-8.6064602226868d-03, 6.3543873655944d-02,
     |  -6.3543873655944d-02, 8.6064602226866d-03, 5.3364516578491d-02,
     |  -6.8059030296831d-02, 2.2544621503300d-02, 4.2146550785310d-02,
     |  -6.6420471464214d-02, 2.6922271857026d-02, 3.7990625789712d-02,
     |  -6.0487362586761d-02, 1.2520460122778d-02, 5.0499815259178d-02,
     |  -3.4280864455755d-02,-5.2538895601242d-02,-1.6467773913851d-02,
     |  -1.3813902698595d-03,-6.8657144831029d-06,-8.0445794719214d-06/
      data (zmn(lat,10,26), lat = 1,36)/
     |   2.1796806377659d-07, 1.8174281403130d-06, 4.0613033978096d-04,
     |   7.5731712818681d-03, 3.8319545960616d-02, 6.0274557888984d-02,
     |  -7.9501767527020d-03,-5.8303502192266d-02, 3.6174974263406d-02,
     |   3.4787871246636d-02,-6.5566203280244d-02, 2.3535498509495d-02,
     |   4.4594612765344d-02,-6.9012214726826d-02, 2.6075300342283d-02,
     |   4.2539990242197d-02,-7.1908663449831d-02, 3.4655017104092d-02,
     |   3.4655017104092d-02,-7.1908663449831d-02, 4.2539990242196d-02,
     |   2.6075300342283d-02,-6.9012214726826d-02, 4.4594612765345d-02,
     |   2.3535498509495d-02,-6.5566203280244d-02, 3.4787871246636d-02,
     |   3.6174974263407d-02,-5.8303502192266d-02,-7.9501767527025d-03,
     |   6.0274557888984d-02, 3.8319545960616d-02, 7.5731712818683d-03,
     |   4.0613033978087d-04, 1.8174281404259d-06, 2.1796806348409d-07/
      data (zmn(lat,11,26), lat = 1,36)/
     |  -1.3301068591025d-06, 1.6211026309810d-06, 1.0405661881872d-04,
     |   2.9971407860641d-03, 2.2627780371843d-02, 6.0317923281367d-02,
     |   4.1090609607136d-02,-4.9729863176356d-02,-2.9047113224823d-02,
     |   6.4827189308686d-02,-1.3979146700289d-02,-5.5211065299562d-02,
     |   6.1937507848138d-02,-5.7784496965833d-04,-6.2438341173400d-02,
     |   6.2007853999539d-02, 9.7158846988971d-04,-6.3367343322257d-02,
     |   6.3367343322257d-02,-9.7158846988953d-04,-6.2007853999540d-02,
     |   6.2438341173399d-02, 5.7784496965860d-04,-6.1937507848138d-02,
     |   5.5211065299562d-02, 1.3979146700289d-02,-6.4827189308686d-02,
     |   2.9047113224823d-02, 4.9729863176356d-02,-4.1090609607136d-02,
     |  -6.0317923281367d-02,-2.2627780371843d-02,-2.9971407860640d-03,
     |  -1.0405661881874d-04,-1.6211026313204d-06, 1.3301068590812d-06/
      data (zmn(lat,12,26), lat = 1,36)/
     |  -2.6546312129431d-08, 1.1974019041509d-07, 2.4186952696574d-05,
     |   1.0374630184894d-03, 1.1289738740007d-02, 4.5342295305475d-02,
     |   6.7538844897770d-02,-3.0391183463371d-04,-6.6075414950180d-02,
     |   1.9284762701144d-02, 5.6936173230202d-02,-5.6397647401533d-02,
     |  -1.5735530937714d-02, 7.0110352472996d-02,-4.4714258192697d-02,
     |  -3.0686047436170d-02, 7.3401267343401d-02,-3.7866955008894d-02,
     |  -3.7866955008894d-02, 7.3401267343401d-02,-3.0686047436169d-02,
     |  -4.4714258192697d-02, 7.0110352472996d-02,-1.5735530937715d-02,
     |  -5.6397647401533d-02, 5.6936173230202d-02, 1.9284762701144d-02,
     |  -6.6075414950181d-02,-3.0391183463412d-04, 6.7538844897770d-02,
     |   4.5342295305476d-02, 1.1289738740007d-02, 1.0374630184892d-03,
     |   2.4186952696634d-05, 1.1974019043918d-07,-2.6546312047552d-08/
      data (zmn(lat,13,26), lat = 1,36)/
     |   1.9735416610568d-07,-1.8499774741472d-07, 5.2013121388976d-06,
     |   3.1783308511160d-04, 4.8743315689500d-03, 2.7833848770562d-02,
     |   6.6903774509988d-02, 5.0404809677871d-02,-4.4385071609757d-02,
     |  -4.8085892471724d-02, 5.9155390995849d-02, 1.9508850165285d-02,
     |  -7.1698098286635d-02, 3.0418756667609d-02, 4.9314828079965d-02,
     |  -7.0342798901147d-02, 8.9321404105457d-03, 6.3047472339391d-02,
     |  -6.3047472339390d-02,-8.9321404105460d-03, 7.0342798901147d-02,
     |  -4.9314828079964d-02,-3.0418756667609d-02, 7.1698098286635d-02,
     |  -1.9508850165285d-02,-5.9155390995848d-02, 4.8085892471724d-02,
     |   4.4385071609757d-02,-5.0404809677871d-02,-6.6903774509989d-02,
     |  -2.7833848770562d-02,-4.8743315689500d-03,-3.1783308511176d-04,
     |  -5.2013121388977d-06, 1.8499774765926d-07,-1.9735416615874d-07/
      data (zmn(lat,14,26), lat = 1,36)/
     |   2.9540381641404d-09,-7.6430160242092d-09, 9.4632401979161d-07,
     |   8.6973660001759d-05, 1.8481310593813d-03, 1.4501678870187d-02,
     |   5.0531740547610d-02, 7.5208497708384d-02, 1.2479309652903d-02,
     |  -6.9999890542720d-02,-6.5880851359880d-03, 7.1961215342860d-02,
     |  -2.6431525129824d-02,-5.7475586840375d-02, 6.3546888956999d-02,
     |   1.3663285858016d-02,-7.3873170740163d-02, 4.1940666911806d-02,
     |   4.1940666911806d-02,-7.3873170740163d-02, 1.3663285858015d-02,
     |   6.3546888956999d-02,-5.7475586840375d-02,-2.6431525129823d-02,
     |   7.1961215342860d-02,-6.5880851359879d-03,-6.9999890542720d-02,
     |   1.2479309652903d-02, 7.5208497708384d-02, 5.0531740547610d-02,
     |   1.4501678870187d-02, 1.8481310593812d-03, 8.6973660001814d-05,
     |   9.4632401986266d-07,-7.6430160254518d-09, 2.9540381745864d-09/
      data (zmn(lat,15,26), lat = 1,36)/
     |  -2.5650719804864d-08, 2.5071212252920d-08, 1.3296791483611d-07,
     |   2.1365936587936d-05, 6.2125495484185d-04, 6.5505217735517d-03,
     |   3.1346170078850d-02, 7.1906930974591d-02, 6.2822170140385d-02,
     |  -3.1535051142762d-02,-6.7196679725771d-02, 3.7814651179550d-02,
     |   5.6341167981526d-02,-6.1325126361533d-02,-2.5406068705457d-02,
     |   7.6140353815266d-02,-2.1459671976444d-02,-6.2505221181339d-02,
     |   6.2505221181339d-02, 2.1459671976445d-02,-7.6140353815266d-02,
     |   2.5406068705457d-02, 6.1325126361533d-02,-5.6341167981527d-02,
     |  -3.7814651179550d-02, 6.7196679725771d-02, 3.1535051142762d-02,
     |  -6.2822170140385d-02,-7.1906930974591d-02,-3.1346170078850d-02,
     |  -6.5505217735517d-03,-6.2125495484193d-04,-2.1365936587894d-05,
     |  -1.3296791480512d-07,-2.5071212422252d-08, 2.5650719806444d-08/
      data (zmn(lat,16,26), lat = 1,36)/
     |  -2.9035051122298d-10, 8.2887391568015d-10, 2.2595219360143d-08,
     |   4.7131295792609d-06, 1.8626424563456d-04, 2.5978549903802d-03,
     |   1.6528280241238d-02, 5.3182844985798d-02, 8.2810648200734d-02,
     |   3.1905161982961d-02,-6.5167549681515d-02,-4.0637026351382d-02,
     |   6.8211967197370d-02, 2.3858494310845d-02,-7.6758109277683d-02,
     |   9.4598044416143d-03, 7.2290700685913d-02,-4.7089951223532d-02,
     |  -4.7089951223532d-02, 7.2290700685913d-02, 9.4598044416148d-03,
     |  -7.6758109277683d-02, 2.3858494310845d-02, 6.8211967197370d-02,
     |  -4.0637026351381d-02,-6.5167549681515d-02, 3.1905161982961d-02,
     |   8.2810648200734d-02, 5.3182844985798d-02, 1.6528280241238d-02,
     |   2.5978549903803d-03, 1.8626424563476d-04, 4.7131295792298d-06,
     |   2.2595219213755d-08, 8.2887382224649d-10,-2.9035051669025d-10/
      data (zmn(lat,17,26), lat = 1,36)/
     |   2.8322967873937d-09,-2.7782009010436d-09, 5.9610811007765d-09,
     |   9.3443223750999d-07, 4.9968288159617d-05, 9.1124639428320d-04,
     |   7.5448737876976d-03, 3.2421900557647d-02, 7.4342129877453d-02,
     |   7.7803259920747d-02,-7.5141448722649d-03,-7.9147203778524d-02,
     |  -3.6034582049648d-03, 7.8816526932525d-02,-1.1013132531591d-02,
     |  -7.5686302350331d-02, 3.6930634034797d-02, 6.1616519842279d-02,
     |  -6.1616519842279d-02,-3.6930634034797d-02, 7.5686302350331d-02,
     |   1.1013132531591d-02,-7.8816526932525d-02, 3.6034582049651d-03,
     |   7.9147203778523d-02, 7.5141448722647d-03,-7.7803259920747d-02,
     |  -7.4342129877453d-02,-3.2421900557647d-02,-7.5448737876979d-03,
     |  -9.1124639428327d-04,-4.9968288159478d-05,-9.3443223748597d-07,
     |  -5.9610812361457d-09, 2.7782008854580d-09,-2.8322968194171d-09/
      data (zmn(lat,18,26), lat = 1,36)/
     |   2.4224084907588d-11,-6.9368911736964d-11, 5.1296592417168d-10,
     |   1.6766166197314d-07, 1.2003637535727d-05, 2.8374785628934d-04,
     |   3.0114370075692d-03, 1.6773109104593d-02, 5.2323700227045d-02,
     |   8.8562995249893d-02, 5.8056290249363d-02,-4.3804162941875d-02,
     |  -7.4284964173121d-02, 3.0917651741313d-02, 7.4052566704269d-02,
     |  -3.8525970533705d-02,-6.7023134717908d-02, 5.3666306645552d-02,
     |   5.3666306645552d-02,-6.7023134717907d-02,-3.8525970533706d-02,
     |   7.4052566704269d-02, 3.0917651741313d-02,-7.4284964173121d-02,
     |  -4.3804162941875d-02, 5.8056290249364d-02, 8.8562995249893d-02,
     |   5.2323700227045d-02, 1.6773109104593d-02, 3.0114370075693d-03,
     |   2.8374785628938d-04, 1.2003637535673d-05, 1.6766166193305d-07,
     |   5.1296593719896d-10,-6.9368985889060d-11, 2.4224146457820d-11/
      data (zmn(lat,19,26), lat = 1,36)/
     |  -2.5493222422324d-10, 2.5115845152342d-10,-1.9892816289787d-10,
     |   2.7230197114616d-08, 2.5789204541161d-06, 7.8481319382579d-05,
     |   1.0557407021251d-03, 7.4704268060655d-03, 3.0371415116380d-02,
     |   7.2376305683618d-02, 9.2405090825054d-02, 3.0061748536190d-02,
     |  -6.9592403886439d-02,-5.8364826937741d-02, 5.5851686722007d-02,
     |   6.3175049958602d-02,-5.5475087404544d-02,-6.0178192306297d-02,
     |   6.0178192306297d-02, 5.5475087404545d-02,-6.3175049958601d-02,
     |  -5.5851686722007d-02, 5.8364826937741d-02, 6.9592403886439d-02,
     |  -3.0061748536190d-02,-9.2405090825054d-02,-7.2376305683618d-02,
     |  -3.0371415116380d-02,-7.4704268060655d-03,-1.0557407021250d-03,
     |  -7.8481319382593d-05,-2.5789204540970d-06,-2.7230197061677d-08,
     |   1.9892821079750d-10,-2.5115848544301d-10, 2.5493236157450d-10/
      data (zmn(lat,20,26), lat = 1,36)/
     |  -1.6273256698981d-12, 4.6955474293210d-12,-2.7100871832537d-12,
     |   3.8931018734664d-09, 4.9379775698493d-07, 1.9235592230766d-05,
     |   3.2516579708459d-04, 2.8815356702030d-03, 1.4863823339655d-02,
     |   4.6801371100211d-02, 8.8765854451951d-02, 8.6873013666792d-02,
     |   1.8285763118814d-03,-8.3886549337464d-02,-4.1008422482702d-02,
     |   7.0394860323383d-02, 5.5401483943840d-02,-6.2308673281180d-02,
     |  -6.2308673281180d-02, 5.5401483943840d-02, 7.0394860323383d-02,
     |  -4.1008422482702d-02,-8.3886549337464d-02, 1.8285763118817d-03,
     |   8.6873013666791d-02, 8.8765854451951d-02, 4.6801371100211d-02,
     |   1.4863823339655d-02, 2.8815356702030d-03, 3.2516579708439d-04,
     |   1.9235592230744d-05, 4.9379775707998d-07, 3.8931018895435d-09,
     |  -2.7100543679081d-12, 4.6956646318148d-12,-1.6274094673621d-12/
      data (zmn(lat,21,26), lat = 1,36)/
     |   1.7595357181303d-11,-1.7387083011624d-11, 1.7414992450429d-11,
     |   4.7957769063257d-10, 8.3694426280253d-08, 4.1538508183989d-06,
     |   8.7640252208219d-05, 9.6229031749500d-04, 6.1838862292864d-03,
     |   2.4812685409376d-02, 6.3500060887970d-02, 9.9704885699092d-02,
     |   7.6631808759778d-02,-2.0399060599958d-02,-9.0480080388376d-02,
     |  -3.0333682216451d-02, 7.6652513929345d-02, 5.7824640477085d-02,
     |  -5.7824640477084d-02,-7.6652513929345d-02, 3.0333682216451d-02,
     |   9.0480080388376d-02, 2.0399060599958d-02,-7.6631808759778d-02,
     |  -9.9704885699092d-02,-6.3500060887970d-02,-2.4812685409376d-02,
     |  -6.1838862292866d-03,-9.6229031749505d-04,-8.7640252208257d-05,
     |  -4.1538508183642d-06,-8.3694426271793d-08,-4.7957764116830d-10,
     |  -1.7414922513814d-11, 1.7386999999184d-11,-1.7595307525587d-11/
      data (zmn(lat,22,26), lat = 1,36)/
     |   8.1342523578089d-14,-2.3566636982038d-13, 3.9986714769803d-13,
     |   5.5140914771909d-11, 1.2412903796081d-08, 7.8226338309802d-07,
     |   2.0486624908717d-05, 2.7641463472438d-04, 2.1838539246270d-03,
     |   1.0909554603160d-02, 3.5878727768568d-02, 7.8037565154100d-02,
     |   1.0616859217410d-01, 6.8023328554303d-02,-3.2890561788504d-02,
     |  -9.4537779000110d-02,-3.2694843355531d-02, 7.4385618349934d-02,
     |   7.4385618349934d-02,-3.2694843355531d-02,-9.4537779000110d-02,
     |  -3.2890561788504d-02, 6.8023328554302d-02, 1.0616859217410d-01,
     |   7.8037565154100d-02, 3.5878727768568d-02, 1.0909554603160d-02,
     |   2.1838539246272d-03, 2.7641463472438d-04, 2.0486624908866d-05,
     |   7.8226338304401d-07, 1.2412903630877d-08, 5.5140903789267d-11,
     |   3.9997341354130d-13,-2.3548435085320d-13, 8.1285906721579d-14/
      data (zmn(lat,23,26), lat = 1,36)/
     |  -8.3891798831847d-13, 8.3051968874473d-13,-8.1374670929284d-13,
     |   6.1689065490518d-12, 1.5825821160256d-09, 1.2628970250684d-07,
     |   4.0868467314286d-06, 6.7314800213339d-05, 6.4735815637424d-04,
     |   3.9615135265090d-03, 1.6258056847252d-02, 4.5918334270771d-02,
     |   8.8900817345909d-02, 1.1112664560904d-01, 6.7529699222950d-02,
     |  -3.2303395782329d-02,-9.8349098712675d-02,-5.3779617433437d-02,
     |   5.3779617433437d-02, 9.8349098712675d-02, 3.2303395782329d-02,
     |  -6.7529699222950d-02,-1.1112664560904d-01,-8.8900817345909d-02,
     |  -4.5918334270771d-02,-1.6258056847252d-02,-3.9615135265090d-03,
     |  -6.4735815637421d-04,-6.7314800213396d-05,-4.0868467314546d-06,
     |  -1.2628970246115d-07,-1.5825821257768d-09,-6.1689894346313d-12,
     |   8.1364088650052d-13,-8.3048856867294d-13, 8.3878183952070d-13/
      data (zmn(lat,24,26), lat = 1,36)/
     |  -2.4104967197207d-15, 7.5738324184436d-15,-1.1906133731759d-14,
     |   4.4920427301429d-13, 1.6855834712488d-10, 1.6970917641442d-08,
     |   6.7608145648708d-07, 1.3521789334157d-05, 1.5705705486580d-04,
     |   1.1634193800084d-03, 5.8427774899795d-03, 2.0667286098349d-02,
     |   5.2457143797888d-02, 9.5126826822758d-02, 1.1756745327863d-01,
     |   8.1167953377503d-02,-1.1257511859307d-02,-9.3848918974390d-02,
     |  -9.3848918974390d-02,-1.1257511859307d-02, 8.1167953377502d-02,
     |   1.1756745327863d-01, 9.5126826822758d-02, 5.2457143797888d-02,
     |   2.0667286098349d-02, 5.8427774899795d-03, 1.1634193800084d-03,
     |   1.5705705486580d-04, 1.3521789334167d-05, 6.7608145645124d-07,
     |   1.6970917681121d-08, 1.6855843295537d-10, 4.4919705903110d-13,
     |  -1.1942992848111d-14, 7.4443795043721d-15,-2.4464021890088d-15/
      data (zmn(lat,25,26), lat = 1,36)/
     |   2.1804756079081d-14,-2.1842311543069d-14, 2.1170315085378d-14,
     |   6.5977323865058d-15, 1.4173146940875d-11, 1.7941839402046d-09,
     |   8.7711426577591d-08, 2.1207488350727d-06, 2.9566175077829d-05,
     |   2.6271423234769d-04, 1.5921259112711d-03, 6.8924365080800d-03,
     |   2.1976315709080d-02, 5.2509262339259d-02, 9.4285760357697d-02,
     |   1.2469623895546d-01, 1.1222190898605d-01, 4.5742990286668d-02,
     |  -4.5742990286668d-02,-1.1222190898605d-01,-1.2469623895546d-01,
     |  -9.4285760357698d-02,-5.2509262339259d-02,-2.1976315709080d-02,
     |  -6.8924365080800d-03,-1.5921259112711d-03,-2.6271423234769d-04,
     |  -2.9566175077831d-05,-2.1207488350676d-06,-8.7711426571007d-08,
     |  -1.7941839814783d-09,-1.4173166138743d-11,-6.5656206085396d-15,
     |  -2.1122838889595d-14, 2.1877890456124d-14,-2.1823573936573d-14/
      data (zmn(lat,26,26), lat = 1,36)/
     |  -6.2487095107241d-17,-2.3504336636800d-16,-4.1884368820098d-17,
     |   7.9153691468624d-16, 8.1298021655339d-13, 1.2952254913300d-10,
     |   7.7489302118813d-09, 2.2566699290574d-07, 3.7570409953559d-06,
     |   3.9758452068361d-05, 2.8773670456798d-04, 1.5003195560664d-03,
     |   5.8543210827525d-03, 1.7579638119745d-02, 4.1468863516412d-02,
     |   7.8000330942288d-02, 1.1820800227128d-01, 1.4528800798646d-01,
     |   1.4528800798646d-01, 1.1820800227128d-01, 7.8000330942288d-02,
     |   4.1468863516413d-02, 1.7579638119745d-02, 5.8543210827525d-03,
     |   1.5003195560663d-03, 2.8773670456796d-04, 3.9758452068363d-05,
     |   3.7570409953868d-06, 2.2566699293546d-07, 7.7489302538161d-09,
     |   1.2952254790640d-10, 8.1295025197215d-13, 7.5993623852699d-16,
     |  -5.4361731514842d-17,-2.5633722871275d-16,-8.0890463987567d-17/
      data (zmn(lat, 0,27), lat = 1,36)/
     |   9.3826576729224d-03,-2.0158797172560d-02, 1.2372435796559d-02,
     |   1.1740812745248d-02,-3.7872583666808d-02, 4.8263509248916d-02,
     |  -3.3057580620928d-02,-2.6045385674717d-03, 4.0367831173561d-02,
     |  -5.8690730472969d-02, 4.5468731191491d-02,-5.8197152245972d-03,
     |  -3.9811923956724d-02, 6.6539911955023d-02,-5.8933266832499d-02,
     |   2.0022207937568d-02, 2.9871619927164d-02,-6.4041985829955d-02,
     |   6.4041985829955d-02,-2.9871619927164d-02,-2.0022207937569d-02,
     |   5.8933266832499d-02,-6.6539911955023d-02, 3.9811923956725d-02,
     |   5.8197152245976d-03,-4.5468731191491d-02, 5.8690730472969d-02,
     |  -4.0367831173561d-02, 2.6045385674713d-03, 3.3057580620929d-02,
     |  -4.8263509248916d-02, 3.7872583666808d-02,-1.1740812745248d-02,
     |  -1.2372435796559d-02, 2.0158797172560d-02,-9.3826576729224d-03/
      data (zmn(lat, 1,27), lat = 1,36)/
     |   1.3856669910457d-02, 3.7809109469548d-03,-2.6387521299863d-02,
     |   3.6791171981789d-02,-2.4609771439481d-02,-6.3613604741764d-03,
     |   3.9431938800829d-02,-5.4520724929798d-02, 4.0379558573765d-02,
     |  -2.1869811318619d-03,-4.0309994206406d-02, 6.3438111233496d-02,
     |  -5.3107608603463d-02, 1.3379111118133d-02, 3.5073452230829d-02,
     |  -6.6035077519438d-02, 6.2266437947946d-02,-2.5274026819883d-02,
     |  -2.5274026819883d-02, 6.2266437947946d-02,-6.6035077519438d-02,
     |   3.5073452230829d-02, 1.3379111118133d-02,-5.3107608603463d-02,
     |   6.3438111233496d-02,-4.0309994206406d-02,-2.1869811318622d-03,
     |   4.0379558573766d-02,-5.4520724929798d-02, 3.9431938800829d-02,
     |  -6.3613604741761d-03,-2.4609771439481d-02, 3.6791171981789d-02,
     |  -2.6387521299863d-02, 3.7809109469549d-03, 1.3856669910457d-02/
      data (zmn(lat, 2,27), lat = 1,36)/
     |   4.0215575357378d-03, 2.5518567339948d-02,-2.3012902769972d-02,
     |  -1.8504812140374d-03, 3.2489829169672d-02,-4.8301291138963d-02,
     |   3.6822207452839d-02,-1.8722151306155d-03,-3.7837943539236d-02,
     |   5.9196387817549d-02,-4.8315144511262d-02, 9.2726833788802d-03,
     |   3.7374103320241d-02,-6.5766529556241d-02, 5.9373233036658d-02,
     |  -2.0681686692328d-02,-2.9740862516984d-02, 6.4469969271491d-02,
     |  -6.4469969271491d-02, 2.9740862516983d-02, 2.0681686692329d-02,
     |  -5.9373233036659d-02, 6.5766529556241d-02,-3.7374103320242d-02,
     |  -9.2726833788806d-03, 4.8315144511263d-02,-5.9196387817549d-02,
     |   3.7837943539236d-02, 1.8722151306159d-03,-3.6822207452839d-02,
     |   4.8301291138963d-02,-3.2489829169672d-02, 1.8504812140370d-03,
     |   2.3012902769973d-02,-2.5518567339948d-02,-4.0215575357377d-03/
      data (zmn(lat, 3,27), lat = 1,36)/
     |  -4.4021896080232d-04, 2.4520107119856d-02, 1.1296177343911d-02,
     |  -3.7746370207951d-02, 3.6131823770412d-02,-7.1739490567213d-03,
     |  -3.1094824455433d-02, 5.4309547321267d-02,-4.6518303822566d-02,
     |   1.0115574955273d-02, 3.5002411227608d-02,-6.2744230758966d-02,
     |   5.6090731342289d-02,-1.7393600764055d-02,-3.2432581000871d-02,
     |   6.5541251922426d-02,-6.3004150345670d-02, 2.5752465324727d-02,
     |   2.5752465324727d-02,-6.3004150345670d-02, 6.5541251922426d-02,
     |  -3.2432581000871d-02,-1.7393600764055d-02, 5.6090731342288d-02,
     |  -6.2744230758966d-02, 3.5002411227608d-02, 1.0115574955273d-02,
     |  -4.6518303822566d-02, 5.4309547321267d-02,-3.1094824455432d-02,
     |  -7.1739490567216d-03, 3.6131823770412d-02,-3.7746370207951d-02,
     |   1.1296177343910d-02, 2.4520107119856d-02,-4.4021896080232d-04/
      data (zmn(lat, 4,27), lat = 1,36)/
     |  -2.7834530123197d-05, 1.3266782021279d-02, 3.5568941169609d-02,
     |  -2.5379507148102d-02,-1.2722682274978d-02, 4.4875928242944d-02,
     |  -4.7201366974657d-02, 1.7002502662411d-02, 2.7225314802926d-02,
     |  -5.7764101756467d-02, 5.4760020408201d-02,-1.8424867916209d-02,
     |  -3.0795325606505d-02, 6.4152334764880d-02,-6.1576734537580d-02,
     |   2.3682870708367d-02, 2.8309960812418d-02,-6.4753988424185d-02,
     |   6.4753988424185d-02,-2.8309960812418d-02,-2.3682870708368d-02,
     |   6.1576734537580d-02,-6.4152334764880d-02, 3.0795325606505d-02,
     |   1.8424867916209d-02,-5.4760020408201d-02, 5.7764101756467d-02,
     |  -2.7225314802926d-02,-1.7002502662412d-02, 4.7201366974657d-02,
     |  -4.4875928242944d-02, 1.2722682274978d-02, 2.5379507148102d-02,
     |  -3.5568941169609d-02,-1.3266782021279d-02, 2.7834530123156d-05/
      data (zmn(lat, 5,27), lat = 1,36)/
     |   2.5461190874710d-04, 5.0628014593609d-03, 3.5954103067518d-02,
     |   1.4214717062398d-02,-4.5385101251939d-02, 3.2633552640876d-02,
     |   9.4150274489318d-03,-4.8069845052143d-02, 5.5531797449903d-02,
     |  -2.5778916596050d-02,-2.2801447204597d-02, 5.9622982065584d-02,
     |  -6.1122041755033d-02, 2.5323757241960d-02, 2.6883176888185d-02,
     |  -6.4348243185547d-02, 6.4444693817881d-02,-2.6725747856023d-02,
     |  -2.6725747856023d-02, 6.4444693817881d-02,-6.4348243185547d-02,
     |   2.6883176888185d-02, 2.5323757241960d-02,-6.1122041755033d-02,
     |   5.9622982065584d-02,-2.2801447204597d-02,-2.5778916596050d-02,
     |   5.5531797449903d-02,-4.8069845052143d-02, 9.4150274489313d-03,
     |   3.2633552640877d-02,-4.5385101251939d-02, 1.4214717062398d-02,
     |   3.5954103067519d-02, 5.0628014593610d-03, 2.5461190874707d-04/
      data (zmn(lat, 6,27), lat = 1,36)/
     |   2.0189166909488d-05, 1.6403322628340d-03, 2.3939256548449d-02,
     |   4.2600772551907d-02,-2.8102573332829d-02,-2.1712868013324d-02,
     |   5.2833858908715d-02,-4.0213612522547d-02,-5.0607878729882d-03,
     |   4.9522119478993d-02,-6.1748728152024d-02, 3.2760862983507d-02,
     |   1.9091060693743d-02,-6.0597092876156d-02, 6.5045846304409d-02,
     |  -2.9042854190355d-02,-2.5451010097941d-02, 6.4860198239306d-02,
     |  -6.4860198239307d-02, 2.5451010097941d-02, 2.9042854190356d-02,
     |  -6.5045846304409d-02, 6.0597092876156d-02,-1.9091060693743d-02,
     |  -3.2760862983507d-02, 6.1748728152024d-02,-4.9522119478992d-02,
     |   5.0607878729878d-03, 4.0213612522547d-02,-5.2833858908715d-02,
     |   2.1712868013323d-02, 2.8102573332829d-02,-4.2600772551907d-02,
     |  -2.3939256548449d-02,-1.6403322628341d-03,-2.0189166909511d-05/
      data (zmn(lat, 7,27), lat = 1,36)/
     |  -4.9080400285280d-05, 4.9027926803692d-04, 1.2238970673136d-02,
     |   4.6343778072905d-02, 1.5296200176989d-02,-5.1638145841372d-02,
     |   2.7750254837707d-02, 2.4936538280195d-02,-5.8476770229383d-02,
     |   4.6373688377044d-02, 1.7137762148224d-03,-5.0749010108441d-02,
     |   6.6096655383843d-02,-3.6807863766750d-02,-1.7897839650735d-02,
     |   6.1995208456478d-02,-6.6488745992304d-02, 2.8221153381839d-02,
     |   2.8221153381839d-02,-6.6488745992305d-02, 6.1995208456477d-02,
     |  -1.7897839650735d-02,-3.6807863766750d-02, 6.6096655383843d-02,
     |  -5.0749010108441d-02, 1.7137762148224d-03, 4.6373688377044d-02,
     |  -5.8476770229383d-02, 2.4936538280194d-02, 2.7750254837708d-02,
     |  -5.1638145841372d-02, 1.5296200176989d-02, 4.6343778072905d-02,
     |   1.2238970673136d-02, 4.9027926803703d-04,-4.9080400285359d-05/
      data (zmn(lat, 8,27), lat = 1,36)/
     |  -2.8841324350714d-06, 1.0929115104699d-04, 5.1584377121892d-03,
     |   3.4662960882824d-02, 4.7992620260622d-02,-3.0618488812815d-02,
     |  -3.0260521981090d-02, 5.7766170066877d-02,-2.8617676397977d-02,
     |  -2.7565587239240d-02, 6.3092672184052d-02,-5.0226309750429d-02,
     |  -1.0440489021048d-03, 5.3103561104180d-02,-6.8651161993957d-02,
     |   3.6577131460306d-02, 2.1099331563647d-02,-6.4880325540493d-02,
     |   6.4880325540493d-02,-2.1099331563646d-02,-3.6577131460306d-02,
     |   6.8651161993957d-02,-5.3103561104179d-02, 1.0440489021054d-03,
     |   5.0226309750429d-02,-6.3092672184052d-02, 2.7565587239240d-02,
     |   2.8617676397978d-02,-5.7766170066877d-02, 3.0260521981089d-02,
     |   3.0618488812815d-02,-4.7992620260622d-02,-3.4662960882824d-02,
     |  -5.1584377121895d-03,-1.0929115104697d-04, 2.8841324352932d-06/
      data (zmn(lat, 9,27), lat = 1,36)/
     |   9.2387797737607d-06, 1.1884086740099d-05, 1.8536261582857d-03,
     |   2.0373981138693d-02, 5.5408929245534d-02, 1.6255473759376d-02,
     |  -5.7131966470677d-02, 2.0829366733125d-02, 4.0050576687527d-02,
     |  -6.2365894079754d-02, 2.7883995268148d-02, 3.1763739689880d-02,
     |  -6.7197745289698d-02, 5.0692617519188d-02, 4.8637005640607d-03,
     |  -5.7755249012300d-02, 6.8961273910656d-02,-3.0282315361624d-02,
     |  -3.0282315361624d-02, 6.8961273910656d-02,-5.7755249012300d-02,
     |   4.8637005640604d-03, 5.0692617519188d-02,-6.7197745289699d-02,
     |   3.1763739689880d-02, 2.7883995268148d-02,-6.2365894079754d-02,
     |   4.0050576687527d-02, 2.0829366733126d-02,-5.7131966470677d-02,
     |   1.6255473759376d-02, 5.5408929245535d-02, 2.0373981138693d-02,
     |   1.8536261582860d-03, 1.1884086739841d-05, 9.2387797738385d-06/
      data (zmn(lat,10,27), lat = 1,36)/
     |   4.3199902340157d-07, 2.3570378011461d-06, 5.7386812478163d-04,
     |   9.9636622521236d-03, 4.4648022286452d-02, 5.2823694716675d-02,
     |  -3.1895450335071d-02,-3.9597332424139d-02, 5.9477519826021d-02,
     |  -1.1915299002542d-02,-4.9024337199180d-02, 6.5022418331876d-02,
     |  -2.3348021247811d-02,-3.9163799294341d-02, 7.0635438912885d-02,
     |  -4.5992046092964d-02,-1.5056738836564d-02, 6.4835610041335d-02,
     |  -6.4835610041335d-02, 1.5056738836564d-02, 4.5992046092965d-02,
     |  -7.0635438912885d-02, 3.9163799294341d-02, 2.3348021247810d-02,
     |  -6.5022418331876d-02, 4.9024337199181d-02, 1.1915299002542d-02,
     |  -5.9477519826022d-02, 3.9597332424139d-02, 3.1895450335072d-02,
     |  -5.2823694716675d-02,-4.4648022286453d-02,-9.9636622521240d-03,
     |  -5.7386812478150d-04,-2.3570378011414d-06,-4.3199902369435d-07/
      data (zmn(lat,11,27), lat = 1,36)/
     |  -1.5949021754101d-06, 2.0214109641260d-06, 1.5480284637763d-04,
     |   4.1792939390641d-03, 2.8558592419413d-02, 6.3343141146492d-02,
     |   1.8613347606332d-02,-6.1756184897070d-02, 1.0409847300627d-02,
     |   5.4732409100920d-02,-5.7913315782867d-02, 3.4430028614009d-04,
     |   5.8666008784579d-02,-6.4236411758898d-02, 1.2586610500314d-02,
     |   5.0619202859096d-02,-7.1580466279587d-02, 3.2975022763486d-02,
     |   3.2975022763486d-02,-7.1580466279587d-02, 5.0619202859095d-02,
     |   1.2586610500314d-02,-6.4236411758898d-02, 5.8666008784579d-02,
     |   3.4430028614067d-04,-5.7913315782867d-02, 5.4732409100920d-02,
     |   1.0409847300628d-02,-6.1756184897070d-02, 1.8613347606331d-02,
     |   6.3343141146492d-02, 2.8558592419413d-02, 4.1792939390641d-03,
     |   1.5480284637739d-04, 2.0214109644157d-06,-1.5949021754929d-06/
      data (zmn(lat,12,27), lat = 1,36)/
     |  -6.1389106711193d-08, 2.4675628078837d-07, 3.7633244764842d-05,
     |   1.5312625925251d-03, 1.5296993823113d-02, 5.3415192890373d-02,
     |   5.8187126455128d-02,-3.0594103736869d-02,-5.0509698589515d-02,
     |   5.6291600494279d-02, 1.0745693626661d-02,-6.5967224728812d-02,
     |   5.0654006370454d-02, 1.6413233774289d-02,-6.8373225330772d-02,
     |   5.6677602248976d-02, 7.0217552563643d-03,-6.4702097542970d-02,
     |   6.4702097542970d-02,-7.0217552563641d-03,-5.6677602248976d-02,
     |   6.8373225330772d-02,-1.6413233774289d-02,-5.0654006370453d-02,
     |   6.5967224728812d-02,-1.0745693626661d-02,-5.6291600494279d-02,
     |   5.0509698589515d-02, 3.0594103736870d-02,-5.8187126455128d-02,
     |  -5.3415192890373d-02,-1.5296993823113d-02,-1.5312625925250d-03,
     |  -3.7633244764935d-05,-2.4675628083816d-07, 6.1389106986509d-08/
      data (zmn(lat,13,27), lat = 1,36)/
     |   2.4885356824476d-07,-2.2501130707111d-07, 8.4543513547743d-06,
     |   4.9636208550250d-04, 7.0599041843450d-03, 3.5938912760594d-02,
     |   7.0508176937705d-02, 2.3913744159498d-02,-6.4623982601292d-02,
     |  -5.2767389891738d-03, 6.7139094042208d-02,-4.1527783118656d-02,
     |  -3.3991776104002d-02, 7.2169768148810d-02,-3.3958309696950d-02,
     |  -3.9310405734065d-02, 7.3903793175784d-02,-3.6395935820197d-02,
     |  -3.6395935820197d-02, 7.3903793175784d-02,-3.9310405734064d-02,
     |  -3.3958309696950d-02, 7.2169768148811d-02,-3.3991776104002d-02,
     |  -4.1527783118656d-02, 6.7139094042208d-02,-5.2767389891737d-03,
     |  -6.4623982601292d-02, 2.3913744159498d-02, 7.0508176937705d-02,
     |   3.5938912760594d-02, 7.0599041843450d-03, 4.9636208550259d-04,
     |   8.4543513548840d-06,-2.2501130748009d-07, 2.4885356839103d-07/
      data (zmn(lat,14,27), lat = 1,36)/
     |   8.0451600032112d-09,-2.1732343723114d-08, 1.6512443700353d-06,
     |   1.4376275961565d-04, 2.8562836289077d-03, 2.0310403775829d-02,
     |   6.0616476258573d-02, 6.5100624241221d-02,-2.4894173624602d-02,
     |  -6.2799304142630d-02, 4.4921211279555d-02, 3.8734352669705d-02,
     |  -7.0991773723445d-02, 1.5660657973388d-02, 5.8284857883392d-02,
     |  -6.7404329812520d-02, 3.3794697582931d-03, 6.4427019199349d-02,
     |  -6.4427019199349d-02,-3.3794697582931d-03, 6.7404329812520d-02,
     |  -5.8284857883392d-02,-1.5660657973389d-02, 7.0991773723445d-02,
     |  -3.8734352669704d-02,-4.4921211279555d-02, 6.2799304142630d-02,
     |   2.4894173624602d-02,-6.5100624241220d-02,-6.0616476258573d-02,
     |  -2.0310403775829d-02,-2.8562836289079d-03,-1.4376275961575d-04,
     |  -1.6512443701163d-06, 2.1732343658672d-08,-8.0451602041076d-09/
      data (zmn(lat,15,27), lat = 1,36)/
     |  -3.4352509620838d-08, 3.2902827269525d-08, 2.5677779528073d-07,
     |   3.7438492234852d-05, 1.0243542922469d-03, 9.9034630569870d-03,
     |   4.1722330071806d-02, 7.7144560705259d-02, 3.3706096601389d-02,
     |  -6.3545166033514d-02,-2.7534941508371d-02, 7.2148878646686d-02,
     |  -9.4314926376316d-03,-6.6224008312645d-02, 5.6839287602799d-02,
     |   2.2399509324325d-02,-7.5241933737081d-02, 4.0688219163209d-02,
     |   4.0688219163209d-02,-7.5241933737081d-02, 2.2399509324325d-02,
     |   5.6839287602799d-02,-6.6224008312646d-02,-9.4314926376311d-03,
     |   7.2148878646686d-02,-2.7534941508371d-02,-6.3545166033515d-02,
     |   3.3706096601389d-02, 7.7144560705259d-02, 4.1722330071806d-02,
     |   9.9034630569870d-03, 1.0243542922469d-03, 3.7438492234773d-05,
     |   2.5677779527741d-07, 3.2902827680177d-08,-3.4352509780899d-08/
      data (zmn(lat,16,27), lat = 1,36)/
     |  -9.4207469937982d-10, 2.7190804650422d-09, 4.1996980753815d-08,
     |   8.7820868684296d-06, 3.2802301923786d-04, 4.2324625817208d-03,
     |   2.4138731207086d-02, 6.5810083282850d-02, 7.4187114408981d-02,
     |  -1.2301879756206d-02,-7.4112206286492d-02, 2.0858944333791d-02,
     |   6.6542228389597d-02,-5.2336845575581d-02,-3.6286886778733d-02,
     |   7.5894313084533d-02,-1.6558616959688d-02,-6.3927321906575d-02,
     |   6.3927321906575d-02, 1.6558616959688d-02,-7.5894313084533d-02,
     |   3.6286886778733d-02, 5.2336845575581d-02,-6.6542228389597d-02,
     |  -2.0858944333792d-02, 7.4112206286492d-02, 1.2301879756206d-02,
     |  -7.4187114408981d-02,-6.5810083282851d-02,-2.4138731207086d-02,
     |  -4.2324625817209d-03,-3.2802301923769d-04,-8.7820868682427d-06,
     |  -4.1996980810680d-08,-2.7190802853239d-09, 9.4207491531085d-10/
      data (zmn(lat,17,27), lat = 1,36)/
     |   4.0851421089580d-09,-3.9317098107176d-09, 1.0413007455013d-08,
     |   1.8574550031445d-06, 9.4204879130766d-05, 1.6005492316060d-03,
     |   1.2033537700803d-02, 4.5095649629425d-02, 8.2958981036469d-02,
     |   4.9215710248361d-02,-5.4286901644601d-02,-5.5166902587566d-02,
     |   6.0123293602273d-02, 3.6845640637304d-02,-7.5329962975466d-02,
     |   1.3451186622918d-03, 7.4518578039813d-02,-4.6071579017847d-02,
     |  -4.6071579017847d-02, 7.4518578039813d-02, 1.3451186622922d-03,
     |  -7.5329962975467d-02, 3.6845640637304d-02, 6.0123293602273d-02,
     |  -5.5166902587566d-02,-5.4286901644601d-02, 4.9215710248361d-02,
     |   8.2958981036469d-02, 4.5095649629425d-02, 1.2033537700803d-02,
     |   1.6005492316060d-03, 9.4204879130740d-05, 1.8574550030977d-06,
     |   1.0413007425265d-08,-3.9317101388312d-09, 4.0851422318439d-09/
      data (zmn(lat,18,27), lat = 1,36)/
     |   9.5126590025351d-11,-2.7588353189459d-10, 1.3276087849425d-09,
     |   3.5616858282533d-07, 2.4313750361336d-05, 5.3850543630483d-04,
     |   5.2405688469280d-03, 2.5943814756371d-02, 6.8166690765255d-02,
     |   8.5039951377318d-02, 1.0096117842150d-02,-7.7962443415360d-02,
     |  -1.8846290333453d-02, 7.8739523573930d-02,-4.3547427393294d-04,
     |  -7.8231265663236d-02, 3.2896887524754d-02, 6.3074360926090d-02,
     |  -6.3074360926089d-02,-3.2896887524754d-02, 7.8231265663235d-02,
     |   4.3547427393322d-04,-7.8739523573930d-02, 1.8846290333453d-02,
     |   7.7962443415360d-02,-1.0096117842151d-02,-8.5039951377318d-02,
     |  -6.8166690765255d-02,-2.5943814756371d-02,-5.2405688469279d-03,
     |  -5.3850543630486d-04,-2.4313750361401d-05,-3.5616858283656d-07,
     |  -1.3276086933199d-09, 2.7588347841957d-10,-9.5126689648332d-11/
      data (zmn(lat,19,27), lat = 1,36)/
     |  -4.0417159014319d-10, 3.9143965841367d-10,-2.6091392275480d-10,
     |   6.2114174070864d-08, 5.6402360318025d-06, 1.6158453965412d-04,
     |   2.0085402736002d-03, 1.2805813868071d-02, 4.5129341938832d-02,
     |   8.6561620961081d-02, 7.0304843371023d-02,-3.0361504271075d-02,
     |  -8.0041074491771d-02, 1.9291559024251d-02, 7.8293982105283d-02,
     |  -3.2088216646734d-02,-7.0028210199030d-02, 5.2905401710665d-02,
     |   5.2905401710665d-02,-7.0028210199030d-02,-3.2088216646735d-02,
     |   7.8293982105282d-02, 1.9291559024251d-02,-8.0041074491771d-02,
     |  -3.0361504271075d-02, 7.0304843371023d-02, 8.6561620961081d-02,
     |   4.5129341938833d-02, 1.2805813868072d-02, 2.0085402736003d-03,
     |   1.6158453965416d-04, 5.6402360319406d-06, 6.2114174080670d-08,
     |  -2.6091387154232d-10, 3.9143976446439d-10,-4.0417153103790d-10/
      data (zmn(lat,20,27), lat = 1,36)/
     |  -7.9207420986587d-12, 2.3123211045255d-11,-2.4955622483032d-11,
     |   9.6847534168337d-09, 1.1739929906882d-06, 4.3228947024036d-05,
     |   6.7948699049394d-04, 5.4819098363539d-03, 2.4986920362128d-02,
     |   6.6207919445925d-02, 9.5125555223857d-02, 4.3901898664121d-02,
     |  -6.1878624858297d-02,-6.6963010396141d-02, 4.8834109749429d-02,
     |   6.8148419316267d-02,-5.2586465468619d-02,-6.1658218412221d-02,
     |   6.1658218412221d-02, 5.2586465468619d-02,-6.8148419316267d-02,
     |  -4.8834109749430d-02, 6.6963010396141d-02, 6.1878624858297d-02,
     |  -4.3901898664120d-02,-9.5125555223857d-02,-6.6207919445925d-02,
     |  -2.4986920362128d-02,-5.4819098363538d-03,-6.7948699049401d-04,
     |  -4.3228947024023d-05,-1.1739929906273d-06,-9.6847535004006d-09,
     |   2.4955550126688d-11,-2.3123297936966d-11, 7.9206770288231d-12/
      data (zmn(lat,21,27), lat = 1,36)/
     |   3.1672037096756d-11,-3.0809825360067d-11, 3.0365930779600d-11,
     |   1.3205463175024d-09, 2.1835741828071d-07, 1.0280294531731d-05,
     |   2.0273512602402d-04, 2.0432077025754d-03, 1.1764515800869d-02,
     |   4.0820008581401d-02, 8.4910476227870d-02, 9.3150407419253d-02,
     |   1.4379199956354d-02,-8.0934652829060d-02,-4.9223584818730d-02,
     |   6.6913201267139d-02, 5.8971846149284d-02,-6.1840551826042d-02,
     |  -6.1840551826042d-02, 5.8971846149284d-02, 6.6913201267139d-02,
     |  -4.9223584818729d-02,-8.0934652829060d-02, 1.4379199956355d-02,
     |   9.3150407419253d-02, 8.4910476227870d-02, 4.0820008581401d-02,
     |   1.1764515800869d-02, 2.0432077025755d-03, 2.0273512602388d-04,
     |   1.0280294531762d-05, 2.1835741822160d-07, 1.3205463551370d-09,
     |   3.0365746559447d-11,-3.0809901093518d-11, 3.1671921132128d-11/
      data (zmn(lat,22,27), lat = 1,36)/
     |   5.1031290082792d-13,-1.4967650027912d-12, 2.4889837947178d-12,
     |   1.6451218392616d-10, 3.6021801726920d-08, 2.1596456761361d-06,
     |   5.3099816043689d-05, 6.6199560561046d-04, 4.7361618229241d-03,
     |   2.0843054660264d-02, 5.7900803376091d-02, 9.8427834035163d-02,
     |   8.4486290365393d-02,-1.0530790278323d-02,-9.0222274957354d-02,
     |  -3.6517259977881d-02, 7.5234622207471d-02, 5.9301744722184d-02,
     |  -5.9301744722184d-02,-7.5234622207471d-02, 3.6517259977880d-02,
     |   9.0222274957354d-02, 1.0530790278323d-02,-8.4486290365393d-02,
     |  -9.8427834035163d-02,-5.7900803376091d-02,-2.0843054660264d-02,
     |  -4.7361618229242d-03,-6.6199560561048d-04,-5.3099816043838d-05,
     |  -2.1596456761116d-06,-3.6021801750486d-08,-1.6451211628970d-10,
     |  -2.4889144249969d-12, 1.4966579773054d-12,-5.1018229117223d-13/
      data (zmn(lat,23,27), lat = 1,36)/
     |  -1.8186402454788d-12, 1.7749334668891d-12,-1.6863391819158d-12,
     |   1.9925584964143d-11, 5.2101922398844d-09, 3.9654080784521d-07,
     |   1.2093649950167d-05, 1.8508068063872d-04, 1.6253838727387d-03,
     |   8.8825120192021d-03, 3.1556873119009d-02, 7.3481393594596d-02,
     |   1.0679659013533d-01, 7.5629815673122d-02,-2.5782568012517d-02,
     |  -9.5091737948643d-02,-3.6387961285983d-02, 7.4267233423737d-02,
     |   7.4267233423737d-02,-3.6387961285983d-02,-9.5091737948643d-02,
     |  -2.5782568012518d-02, 7.5629815673121d-02, 1.0679659013533d-01,
     |   7.3481393594596d-02, 3.1556873119009d-02, 8.8825120192021d-03,
     |   1.6253838727387d-03, 1.8508068063859d-04, 1.2093649950095d-05,
     |   3.9654080779400d-07, 5.2101923265213d-09, 1.9925566682047d-11,
     |  -1.6862079610138d-12, 1.7749139642101d-12,-1.8185775886123d-12/
      data (zmn(lat,24,27), lat = 1,36)/
     |  -2.2817399632890d-14, 6.7263715800925d-14,-1.0782567162671d-13,
     |   1.8757592171867d-12, 6.4947483137453d-10, 6.2537971608997d-08,
     |   2.3557492605095d-06, 4.3983839515998d-05, 4.6974407803825d-04,
     |   3.1402129418303d-03, 1.3888830182996d-02, 4.1805962847456d-02,
     |   8.5523129041743d-02, 1.1255056444887d-01, 7.3696436210459d-02,
     |  -2.7470179250056d-02,-9.8714835186097d-02,-5.5204946637989d-02,
     |   5.5204946637988d-02, 9.8714835186097d-02, 2.7470179250056d-02,
     |  -7.3696436210459d-02,-1.1255056444887d-01,-8.5523129041743d-02,
     |  -4.1805962847456d-02,-1.3888830182996d-02,-3.1402129418303d-03,
     |  -4.6974407803830d-04,-4.3983839516052d-05,-2.3557492605009d-06,
     |  -6.2537971618560d-08,-6.4947481951642d-10,-1.8757642623245d-12,
     |   1.0790221821974d-13,-6.7109302336050d-14, 2.2779429897268d-14/
      data (zmn(lat,25,27), lat = 1,36)/
     |   6.5953739116279d-14,-6.4570484346402d-14, 6.1790792692969d-14,
     |   7.8575930552993d-14, 6.7748419239568d-11, 8.2235437696315d-09,
     |   3.8125228188572d-07, 8.6405314106833d-06, 1.1140025035549d-04,
     |   9.0081316764048d-04, 4.8700465141318d-03, 1.8324736461541d-02,
     |   4.8969166708424d-02, 9.2678071377150d-02, 1.1878272728353d-01,
     |   8.5337261905399d-02,-8.3335958245591d-03,-9.4190796025018d-02,
     |  -9.4190796025018d-02,-8.3335958245592d-03, 8.5337261905398d-02,
     |   1.1878272728353d-01, 9.2678071377150d-02, 4.8969166708424d-02,
     |   1.8324736461541d-02, 4.8700465141317d-03, 9.0081316764046d-04,
     |   1.1140025035542d-04, 8.6405314107365d-06, 3.8125228191408d-07,
     |   8.2235438449305d-09, 6.7748330840165d-11, 7.8596622086235d-14,
     |   6.1711756085600d-14,-6.4588541374862d-14, 6.6039117173490d-14/
      data (zmn(lat,26,27), lat = 1,36)/
     |   7.4118820421775d-16,-1.6230967465450d-15, 2.5837367949323d-15,
     |   4.7694787763141d-15, 5.5742966707060d-12, 8.5202913312446d-10,
     |   4.8467690420162d-08, 1.3277491735645d-06, 2.0542730236211d-05,
     |   1.9920221274185d-04, 1.2990436308591d-03, 5.9783541554240d-03,
     |   2.0047650495789d-02, 4.9892002579325d-02, 9.2479459374832d-02,
     |   1.2520294393499d-01, 1.1442630950738d-01, 4.6999222728586d-02,
     |  -4.6999222728586d-02,-1.1442630950738d-01,-1.2520294393499d-01,
     |  -9.2479459374832d-02,-4.9892002579325d-02,-2.0047650495789d-02,
     |  -5.9783541554241d-03,-1.2990436308591d-03,-1.9920221274187d-04,
     |  -2.0542730236252d-05,-1.3277491735616d-06,-4.8467690336208d-08,
     |  -8.5202910792415d-10,-5.5742851508595d-12,-4.7267715030460d-15,
     |  -2.6354934049556d-15, 1.6134456170273d-15,-7.8979708253377d-16/
      data (zmn(lat,27,27), lat = 1,36)/
     |  -1.0157208949224d-15, 8.4149687213877d-16,-1.0875291126263d-15,
     |   1.0484161139099d-15, 3.1299421097436d-13, 6.0358918557060d-11,
     |   4.2018704300327d-09, 1.3864353944820d-07, 2.5616143336173d-06,
     |   2.9583177319338d-05, 2.3038085450785d-04, 1.2770191996559d-03,
     |   5.2407075669022d-03, 1.6391161960139d-02, 3.9914077825489d-02,
     |   7.6853282818732d-02, 1.1827689332787d-01, 1.4648753976969d-01,
     |   1.4648753976969d-01, 1.1827689332787d-01, 7.6853282818733d-02,
     |   3.9914077825489d-02, 1.6391161960140d-02, 5.2407075669022d-03,
     |   1.2770191996559d-03, 2.3038085450785d-04, 2.9583177319334d-05,
     |   2.5616143336417d-06, 1.3864353944777d-07, 4.2018704112112d-09,
     |   6.0358886012701d-11, 3.1303832617333d-13, 1.0548917135081d-15,
     |  -1.0499471988802d-15, 9.0092073393779d-16,-1.0992414696690d-15/
      data (zmn(lat, 0,28), lat = 1,36)/
     |   8.9384138594407d-03,-2.0839826652520d-02, 1.8006269994506d-02,
     |   3.3945731996753d-04,-2.6205507149885d-02, 4.6518069100312d-02,
     |  -4.9562757470299d-02, 3.1075783310406d-02, 3.0274118591666d-03,
     |  -3.8753482552784d-02, 6.0148065331718d-02,-5.6669062713412d-02,
     |   2.8377372819586d-02, 1.3565891543801d-02,-5.1480192181724d-02,
     |   6.8860535467473d-02,-5.7744406034966d-02, 2.2397963103553d-02,
     |   2.2397963103553d-02,-5.7744406034967d-02, 6.8860535467473d-02,
     |  -5.1480192181724d-02, 1.3565891543801d-02, 2.8377372819585d-02,
     |  -5.6669062713413d-02, 6.0148065331718d-02,-3.8753482552784d-02,
     |   3.0274118591668d-03, 3.1075783310406d-02,-4.9562757470299d-02,
     |   4.6518069100312d-02,-2.6205507149885d-02, 3.3945731996736d-04,
     |   1.8006269994506d-02,-2.0839826652520d-02, 8.9384138594404d-03/
      data (zmn(lat, 1,28), lat = 1,36)/
     |   1.5798109573966d-02,-7.4033034893131d-04,-2.0836591623834d-02,
     |   3.6208100603708d-02,-3.5041089535213d-02, 1.4959511992534d-02,
     |   1.6690562904331d-02,-4.5864558760058d-02, 5.8314724417947d-02,
     |  -4.6526667781229d-02, 1.3769962921583d-02, 2.6781301536197d-02,
     |  -5.7622281950293d-02, 6.4732985851823d-02,-4.4072857488610d-02,
     |   3.7238424830238d-03, 3.9399223356463d-02,-6.6874423000727d-02,
     |   6.6874423000727d-02,-3.9399223356463d-02,-3.7238424830246d-03,
     |   4.4072857488611d-02,-6.4732985851823d-02, 5.7622281950294d-02,
     |  -2.6781301536196d-02,-1.3769962921583d-02, 4.6526667781229d-02,
     |  -5.8314724417947d-02, 4.5864558760058d-02,-1.6690562904330d-02,
     |  -1.4959511992534d-02, 3.5041089535213d-02,-3.6208100603708d-02,
     |   2.0836591623833d-02, 7.4033034893117d-04,-1.5798109573966d-02/
      data (zmn(lat, 2,28), lat = 1,36)/
     |   4.4126699309492d-03, 2.4471626665310d-02,-2.7009405982509d-02,
     |   9.4007940433889d-03, 1.9021242722537d-02,-4.3544109599558d-02,
     |   5.0638109875222d-02,-3.4627955475505d-02, 8.6609622545481d-04,
     |   3.6287997122612d-02,-5.9883978225017d-02, 5.8273539411670d-02,
     |  -3.0794529398363d-02,-1.1480186349788d-02, 5.0401097418176d-02,
     |  -6.8770698568172d-02, 5.8110805792441d-02,-2.2607780998784d-02,
     |  -2.2607780998784d-02, 5.8110805792441d-02,-6.8770698568172d-02,
     |   5.0401097418175d-02,-1.1480186349788d-02,-3.0794529398363d-02,
     |   5.8273539411671d-02,-5.9883978225017d-02, 3.6287997122612d-02,
     |   8.6609622545467d-04,-3.4627955475505d-02, 5.0638109875223d-02,
     |  -4.3544109599558d-02, 1.9021242722536d-02, 9.4007940433891d-03,
     |  -2.7009405982509d-02, 2.4471626665310d-02, 4.4126699309495d-03/
      data (zmn(lat, 3,28), lat = 1,36)/
     |  -1.0562177956795d-03, 2.6390259050202d-02, 4.2642427632957d-03,
     |  -3.2638355413651d-02, 4.2139319398907d-02,-2.7323356083694d-02,
     |  -4.9914945412409d-03, 3.9078611754232d-02,-5.7784731230576d-02,
     |   5.0785612001850d-02,-1.9736905924112d-02,-2.2158423589873d-02,
     |   5.6047816394700d-02,-6.6104746529157d-02, 4.6962433259540d-02,
     |  -6.4225005004625d-03,-3.7877621460136d-02, 6.6359740175250d-02,
     |  -6.6359740175250d-02, 3.7877621460136d-02, 6.4225005004632d-03,
     |  -4.6962433259540d-02, 6.6104746529157d-02,-5.6047816394700d-02,
     |   2.2158423589873d-02, 1.9736905924111d-02,-5.0785612001850d-02,
     |   5.7784731230576d-02,-3.9078611754232d-02, 4.9914945412400d-03,
     |   2.7323356083694d-02,-4.2139319398907d-02, 3.2638355413651d-02,
     |  -4.2642427632951d-03,-2.6390259050202d-02, 1.0562177956796d-03/
      data (zmn(lat, 4,28), lat = 1,36)/
     |  -4.3756649856792d-05, 1.4803212808275d-02, 3.3065143045612d-02,
     |  -3.2712855752941d-02, 3.4916335079542d-03, 3.1774551926522d-02,
     |  -5.1837468015658d-02, 4.5019549790370d-02,-1.3793118518085d-02,
     |  -2.6932716094843d-02, 5.7214303100443d-02,-6.1750934620765d-02,
     |   3.7315405574917d-02, 5.5425490231527d-03,-4.7317651378587d-02,
     |   6.8633945426404d-02,-5.9331444042301d-02, 2.3288875652605d-02,
     |   2.3288875652605d-02,-5.9331444042302d-02, 6.8633945426404d-02,
     |  -4.7317651378587d-02, 5.5425490231524d-03, 3.7315405574916d-02,
     |  -6.1750934620765d-02, 5.7214303100444d-02,-2.6932716094843d-02,
     |  -1.3793118518084d-02, 4.5019549790370d-02,-5.1837468015658d-02,
     |   3.1774551926522d-02, 3.4916335079547d-03,-3.2712855752942d-02,
     |   3.3065143045612d-02, 1.4803212808275d-02,-4.3756649857030d-05/
      data (zmn(lat, 5,28), lat = 1,36)/
     |   4.9486944518000d-04, 5.7220664828069d-03, 3.7830222211053d-02,
     |   3.5912475609510d-03,-4.0237140296770d-02, 4.5094010288116d-02,
     |  -1.8395575208651d-02,-2.2315546458225d-02, 5.3515109522639d-02,
     |  -5.7775204228173d-02, 3.2034497731860d-02, 1.1368833844327d-02,
     |  -5.1090006514069d-02, 6.7372169974964d-02,-5.1721844936249d-02,
     |   1.1061987919099d-02, 3.5566211146521d-02,-6.6123222282352d-02,
     |   6.6123222282351d-02,-3.5566211146521d-02,-1.1061987919100d-02,
     |   5.1721844936249d-02,-6.7372169974964d-02, 5.1090006514069d-02,
     |  -1.1368833844326d-02,-3.2034497731859d-02, 5.7775204228173d-02,
     |  -5.3515109522639d-02, 2.2315546458224d-02, 1.8395575208652d-02,
     |  -4.5094010288116d-02, 4.0237140296770d-02,-3.5912475609509d-03,
     |  -3.7830222211053d-02,-5.7220664828069d-03,-4.9486944518008d-04/
      data (zmn(lat, 6,28), lat = 1,36)/
     |   2.7655694921353d-05, 1.9945362925205d-03, 2.6943785970240d-02,
     |   3.7557931402641d-02,-3.8680413840574d-02,-6.5878745560258d-04,
     |   4.1563179699119d-02,-5.5474695556844d-02, 3.4571457445533d-02,
     |   8.3354450764767d-03,-4.8925175826493d-02, 6.4847702716842d-02,
     |  -4.7156360987091d-02, 4.4750548283591d-03, 4.1731540596201d-02,
     |  -6.8155026019491d-02, 6.1360619843554d-02,-2.4461940694648d-02,
     |  -2.4461940694649d-02, 6.1360619843554d-02,-6.8155026019491d-02,
     |   4.1731540596201d-02, 4.4750548283594d-03,-4.7156360987090d-02,
     |   6.4847702716842d-02,-4.8925175826494d-02, 8.3354450764766d-03,
     |   3.4571457445532d-02,-5.5474695556843d-02, 4.1563179699119d-02,
     |  -6.5878745560261d-04,-3.8680413840575d-02, 3.7557931402641d-02,
     |   2.6943785970240d-02, 1.9945362925205d-03, 2.7655694921514d-05/
      data (zmn(lat, 7,28), lat = 1,36)/
     |  -1.1831970463794d-04, 6.7867004184791d-04, 1.4540657845187d-02,
     |   4.7787218694508d-02, 2.7255159075794d-04,-4.6097776052607d-02,
     |   4.6858354652485d-02,-8.8821243308886d-03,-3.7508502395581d-02,
     |   6.1420256611350d-02,-4.8411551094888d-02, 6.3020600715472d-03,
     |   4.0977237248709d-02,-6.7199985453197d-02, 5.7919918303786d-02,
     |  -1.7788469297836d-02,-3.2242358792701d-02, 6.6068137368393d-02,
     |  -6.6068137368393d-02, 3.2242358792701d-02, 1.7788469297837d-02,
     |  -5.7919918303786d-02, 6.7199985453197d-02,-4.0977237248710d-02,
     |  -6.3020600715478d-03, 4.8411551094887d-02,-6.1420256611350d-02,
     |   3.7508502395581d-02, 8.8821243308892d-03,-4.6858354652486d-02,
     |   4.6097776052607d-02,-2.7255159075784d-04,-4.7787218694508d-02,
     |  -1.4540657845186d-02,-6.7867004184814d-04, 1.1831970463801d-04/
      data (zmn(lat, 8,28), lat = 1,36)/
     |  -4.3353100267545d-06, 1.4645545959723d-04, 6.4803871515992d-03,
     |   3.9073003972643d-02, 3.9519889306291d-02,-4.4541830961888d-02,
     |  -4.3987813468138d-03, 5.0012228880148d-02,-5.5665465842605d-02,
     |   2.0188614104535d-02, 3.0508550489569d-02,-6.3440162228917d-02,
     |   5.8484305641591d-02,-1.8714643574494d-02,-3.2798255320657d-02,
     |   6.6761624668102d-02,-6.4079440270630d-02, 2.6153490810058d-02,
     |   2.6153490810058d-02,-6.4079440270630d-02, 6.6761624668102d-02,
     |  -3.2798255320657d-02,-1.8714643574494d-02, 5.8484305641591d-02,
     |  -6.3440162228916d-02, 3.0508550489569d-02, 2.0188614104535d-02,
     |  -5.5665465842605d-02, 5.0012228880147d-02,-4.3987813468135d-03,
     |  -4.4541830961888d-02, 3.9519889306291d-02, 3.9073003972643d-02,
     |   6.4803871515995d-03, 1.4645545959718d-04,-4.3353100268924d-06/
      data (zmn(lat, 9,28), lat = 1,36)/
     |   2.7130969145983d-05, 2.3963068158914d-06, 2.4618556652683d-03,
     |   2.4621418401982d-02, 5.5807598896318d-02,-3.6988352460871d-03,
     |  -5.1457432237981d-02, 4.7347080037330d-02, 2.1474030342306d-03,
     |  -5.1165793189707d-02, 6.2667181343544d-02,-3.0107221179642d-02,
     |  -2.3545035133232d-02, 6.3397221104255d-02,-6.4659220268057d-02,
     |   2.6719157633218d-02, 2.7593057355996d-02,-6.6072884242931d-02,
     |   6.6072884242931d-02,-2.7593057355996d-02,-2.6719157633219d-02,
     |   6.4659220268057d-02,-6.3397221104255d-02, 2.3545035133233d-02,
     |   3.0107221179643d-02,-6.2667181343544d-02, 5.1165793189707d-02,
     |  -2.1474030342304d-03,-4.7347080037330d-02, 5.1457432237981d-02,
     |   3.6988352460871d-03,-5.5807598896318d-02,-2.4621418401982d-02,
     |  -2.4618556652687d-03,-2.3963068156953d-06,-2.7130969146018d-05/
      data (zmn(lat,10,28), lat = 1,36)/
     |   7.0720916298269d-07, 3.1955473350877d-06, 7.9556688321803d-04,
     |   1.2812286458331d-02, 5.0201592024256d-02, 4.0369027168232d-02,
     |  -4.9683903912712d-02,-9.2730413055755d-03, 5.7904950007684d-02,
     |  -5.1829618084902d-02, 1.3119289798059d-03, 5.1388999707944d-02,
     |  -6.7429086319050d-02, 3.6545407852279d-02, 1.9541756909485d-02,
     |  -6.3616551583465d-02, 6.7304391441159d-02,-2.8409199779141d-02,
     |  -2.8409199779141d-02, 6.7304391441159d-02,-6.3616551583465d-02,
     |   1.9541756909485d-02, 3.6545407852280d-02,-6.7429086319050d-02,
     |   5.1388999707943d-02, 1.3119289798056d-03,-5.1829618084903d-02,
     |   5.7904950007683d-02,-9.2730413055746d-03,-4.9683903912712d-02,
     |   4.0369027168232d-02, 5.0201592024256d-02, 1.2812286458330d-02,
     |   7.9556688321792d-04, 3.1955473350211d-06, 7.0720916333338d-07/
      data (zmn(lat,11,28), lat = 1,36)/
     |  -5.7150711658725d-06, 6.3192272105241d-06, 2.2173138068370d-04,
     |   5.6944120605565d-03, 3.4898571642404d-02, 6.2278930994981d-02,
     |  -6.6745595669183d-03,-5.7148651034256d-02, 4.5532485613648d-02,
     |   1.6029732233603d-02,-6.2784141591051d-02, 5.5236142512375d-02,
     |  -2.6086578250823d-03,-5.2876905337297d-02, 7.0234406840886d-02,
     |  -3.7752680509214d-02,-2.1285207391052d-02, 6.6061613884394d-02,
     |  -6.6061613884394d-02, 2.1285207391051d-02, 3.7752680509214d-02,
     |  -7.0234406840886d-02, 5.2876905337297d-02, 2.6086578250819d-03,
     |  -5.5236142512375d-02, 6.2784141591051d-02,-1.6029732233603d-02,
     |  -4.5532485613648d-02, 5.7148651034256d-02, 6.6745595669185d-03,
     |  -6.2278930994981d-02,-3.4898571642404d-02,-5.6944120605566d-03,
     |  -2.2173138068351d-04,-6.3192272104515d-06, 5.7150711660572d-06/
      data (zmn(lat,12,28), lat = 1,36)/
     |  -1.0941924694290d-07, 4.2273803272264d-07, 5.7336043236622d-05,
     |   2.2035659452309d-03, 2.0085170174345d-02, 5.9906716830910d-02,
     |   4.1649819158845d-02,-5.3418325164579d-02,-1.6907371040229d-02,
     |   6.5049080367499d-02,-4.1973469658186d-02,-2.2528903581046d-02,
     |   6.7368015753460d-02,-5.5612039433187d-02,-1.1710939889571d-03,
     |   5.7575294497845d-02,-7.0747985269556d-02, 3.1298273843235d-02,
     |   3.1298273843236d-02,-7.0747985269556d-02, 5.7575294497844d-02,
     |  -1.1710939889570d-03,-5.5612039433188d-02, 6.7368015753460d-02,
     |  -2.2528903581045d-02,-4.1973469658186d-02, 6.5049080367499d-02,
     |  -1.6907371040228d-02,-5.3418325164579d-02, 4.1649819158845d-02,
     |   5.9906716830910d-02, 2.0085170174345d-02, 2.2035659452311d-03,
     |   5.7336043236643d-05, 4.2273803279913d-07,-1.0941924728799d-07/
      data (zmn(lat,13,28), lat = 1,36)/
     |   1.0894497634394d-06,-1.0440355736210d-06, 1.4211838828099d-05,
     |   7.5355872506596d-04, 9.9034848828943d-03, 4.4429043037150d-02,
     |   6.8054322548851d-02,-7.0462215441261d-03,-6.3649816283932d-02,
     |   3.9535884033963d-02, 3.3740252011990d-02,-6.9684000857890d-02,
     |   3.5515246989143d-02, 3.2252837858023d-02,-7.1856020465828d-02,
     |   5.0399994081068d-02, 1.2940938398109d-02,-6.5976341927860d-02,
     |   6.5976341927860d-02,-1.2940938398109d-02,-5.0399994081069d-02,
     |   7.1856020465828d-02,-3.2252837858023d-02,-3.5515246989143d-02,
     |   6.9684000857890d-02,-3.3740252011990d-02,-3.9535884033964d-02,
     |   6.3649816283932d-02, 7.0462215441264d-03,-6.8054322548851d-02,
     |  -4.4429043037150d-02,-9.9034848828945d-03,-7.5355872506588d-04,
     |  -1.4211838828258d-05, 1.0440355732871d-06,-1.0894497636328d-06/
      data (zmn(lat,14,28), lat = 1,36)/
     |   1.5642166204031d-08,-4.2205003375673d-08, 2.7880392966993d-06,
     |   2.3071504256634d-04, 4.2684528952190d-03, 2.7280150792844d-02,
     |   6.8152756384328d-02, 4.4998785816218d-02,-5.4701321118586d-02,
     |  -2.8849483205076d-02, 6.9648301860684d-02,-2.2995964691864d-02,
     |  -4.9593546839799d-02, 7.0587157871468d-02,-2.2274015218106d-02,
     |  -4.7176952101628d-02, 7.3957765935813d-02,-3.4921433476638d-02,
     |  -3.4921433476638d-02, 7.3957765935813d-02,-4.7176952101627d-02,
     |  -2.2274015218106d-02, 7.0587157871468d-02,-4.9593546839800d-02,
     |  -2.2995964691864d-02, 6.9648301860684d-02,-2.8849483205076d-02,
     |  -5.4701321118586d-02, 4.4998785816217d-02, 6.8152756384328d-02,
     |   2.7280150792845d-02, 4.2684528952189d-03, 2.3071504256614d-04,
     |   2.7880392967719d-06,-4.2205003416306d-08, 1.5642166440452d-08/
      data (zmn(lat,15,28), lat = 1,36)/
     |  -1.8428407544711d-07, 1.8083244670465d-07, 3.3447675654605d-07,
     |   6.3646216082979d-05, 1.6293036561585d-03, 1.4352895774273d-02,
     |   5.2464720044879d-02, 7.4131428767202d-02,-3.0110411755845d-03,
     |  -7.0613656634596d-02, 2.6473428710824d-02, 5.4567064348579d-02,
     |  -6.5793234438414d-02, 3.7153349324403d-04, 6.5494043286371d-02,
     |  -6.3494905154265d-02,-2.1264492120320d-03, 6.5752733421916d-02,
     |  -6.5752733421916d-02, 2.1264492120317d-03, 6.3494905154265d-02,
     |  -6.5494043286370d-02,-3.7153349324430d-04, 6.5793234438414d-02,
     |  -5.4567064348579d-02,-2.6473428710824d-02, 7.0613656634596d-02,
     |   3.0110411755846d-03,-7.4131428767202d-02,-5.2464720044880d-02,
     |  -1.4352895774273d-02,-1.6293036561584d-03,-6.3646216083135d-05,
     |  -3.3447675646683d-07,-1.8083244634111d-07, 1.8428407549624d-07/
      data (zmn(lat,16,28), lat = 1,36)/
     |  -2.0083734116134d-09, 5.7553142827002d-09, 7.7729887563054d-08,
     |   1.5782694336500d-05, 5.5562269874690d-04, 6.5980231650595d-03,
     |   3.3383924390205d-02, 7.5019912971530d-02, 5.1995912919344d-02,
     |  -5.1568034228714d-02,-4.5970375848815d-02, 6.7196640978223d-02,
     |   7.9159083550379d-03,-7.2221621932401d-02, 4.8753570566708d-02,
     |   3.0741231142967d-02,-7.6223565103372d-02, 3.9426551024292d-02,
     |   3.9426551024293d-02,-7.6223565103372d-02, 3.0741231142966d-02,
     |   4.8753570566709d-02,-7.2221621932401d-02, 7.9159083550386d-03,
     |   6.7196640978223d-02,-4.5970375848815d-02,-5.1568034228714d-02,
     |   5.1995912919344d-02, 7.5019912971530d-02, 3.3383924390205d-02,
     |   6.5980231650593d-03, 5.5562269874685d-04, 1.5782694336673d-05,
     |   7.7729887527120d-08, 5.7553142751455d-09,-2.0083734097008d-09/
      data (zmn(lat,17,28), lat = 1,36)/
     |   2.7013980016799d-08,-2.6605877448947d-08, 3.9268231790468d-08,
     |   3.5249990550979d-06, 1.7019419719409d-04, 2.6818634074325d-03,
     |   1.8164143687699d-02, 5.8336068404582d-02, 8.1238232984056d-02,
     |   7.6051032215009d-03,-7.5821504937606d-02, 2.7900693069879d-03,
     |   7.3389047452246d-02,-4.1577297754356d-02,-4.6238681701457d-02,
     |   7.4734158640861d-02,-1.1630386808128d-02,-6.5302352463968d-02,
     |   6.5302352463968d-02, 1.1630386808128d-02,-7.4734158640861d-02,
     |   4.6238681701457d-02, 4.1577297754356d-02,-7.3389047452246d-02,
     |  -2.7900693069885d-03, 7.5821504937606d-02,-7.6051032215008d-03,
     |  -8.1238232984056d-02,-5.8336068404582d-02,-1.8164143687699d-02,
     |  -2.6818634074325d-03,-1.7019419719420d-04,-3.5249990550487d-06,
     |  -3.9268231777177d-08, 2.6605877238946d-08,-2.7013980047965d-08/
      data (zmn(lat,18,28), lat = 1,36)/
     |   2.2452903640694d-10,-6.4655762690278d-10, 2.8845408365254d-09,
     |   7.2363007701077d-07, 4.6961294270736d-05, 9.7086916010311d-04,
     |   8.6080841487439d-03, 3.7411348323927d-02, 8.0287661758573d-02,
     |   6.3805651424549d-02,-4.0448293530377d-02,-6.6730890181276d-02,
     |   4.9567071970166d-02, 4.8578008233876d-02,-7.2400852426099d-02,
     |  -6.7147192509050d-03, 7.6428460498459d-02,-4.5039110164529d-02,
     |  -4.5039110164529d-02, 7.6428460498458d-02,-6.7147192509046d-03,
     |  -7.2400852426099d-02, 4.8578008233876d-02, 4.9567071970166d-02,
     |  -6.6730890181276d-02,-4.0448293530377d-02, 6.3805651424549d-02,
     |   8.0287661758573d-02, 3.7411348323928d-02, 8.6080841487440d-03,
     |   9.7086916010325d-04, 4.6961294270883d-05, 7.2363007697766d-07,
     |   2.8845407864325d-09,-6.4655769174427d-10, 2.2452902314797d-10/
      data (zmn(lat,19,28), lat = 1,36)/
     |  -3.3307249685515d-09, 3.2916446788763d-09,-2.9791052807685d-09,
     |   1.3741070706347d-07, 1.1689019054043d-05, 3.1427995392607d-04,
     |   3.5904693659978d-03, 2.0432096704852d-02, 6.1203551059553d-02,
     |   8.9196911086446d-02, 2.7132957806537d-02,-7.3488973002247d-02,
     |  -3.3300517201928d-02, 7.6553390145453d-02, 1.0069858787268d-02,
     |  -8.0015463223393d-02, 2.8776116971652d-02, 6.4491737130915d-02,
     |  -6.4491737130915d-02,-2.8776116971652d-02, 8.0015463223393d-02,
     |  -1.0069858787268d-02,-7.6553390145453d-02, 3.3300517201928d-02,
     |   7.3488973002247d-02,-2.7132957806537d-02,-8.9196911086446d-02,
     |  -6.1203551059553d-02,-2.0432096704852d-02,-3.5904693659980d-03,
     |  -3.1427995392614d-04,-1.1689019053919d-05,-1.3741070709280d-07,
     |   2.9791051355375d-09,-3.2916446446817d-09, 3.3307249890950d-09/
      data (zmn(lat,20,28), lat = 1,36)/
     |  -2.1048161403704d-11, 6.0996895413872d-11,-6.7013608838359d-11,
     |   2.2654288312872d-08, 2.6250858880995d-06, 9.1096696985991d-05,
     |   1.3253020033261d-03, 9.6605591061917d-03, 3.8369708757116d-02,
     |   8.2879348661362d-02, 8.0254215005262d-02,-1.5991599072089d-02,
     |  -8.3394600621392d-02, 7.3041072244493d-03, 8.1322848263256d-02,
     |  -2.5427969746574d-02,-7.2792731456052d-02, 5.2126256554546d-02,
     |   5.2126256554547d-02,-7.2792731456052d-02,-2.5427969746574d-02,
     |   8.1322848263256d-02, 7.3041072244494d-03,-8.3394600621392d-02,
     |  -1.5991599072089d-02, 8.0254215005262d-02, 8.2879348661362d-02,
     |   3.8369708757116d-02, 9.6605591061918d-03, 1.3253020033261d-03,
     |   9.1096696986022d-05, 2.6250858880431d-06, 2.2654288351357d-08,
     |  -6.7013486966470d-11, 6.0996879666898d-11,-2.1048127527608d-11/
      data (zmn(lat,21,28), lat = 1,36)/
     |   3.3171999106079d-10,-3.2860545842775d-10, 3.2585783073924d-10,
     |   3.0990338687098d-09, 5.3061508418944d-07, 2.3620511611323d-05,
     |   4.3364585248693d-04, 3.9861790135441d-03, 2.0346270832250d-02,
     |   5.9794681588544d-02, 9.5929188000117d-02, 5.6564945146993d-02,
     |  -5.2748198196777d-02,-7.4251963851879d-02, 4.1231482006864d-02,
     |   7.2609785545850d-02,-4.9569912678895d-02,-6.3104243636385d-02,
     |   6.3104243636385d-02, 4.9569912678895d-02,-7.2609785545849d-02,
     |  -4.1231482006865d-02, 7.4251963851879d-02, 5.2748198196777d-02,
     |  -5.6564945146993d-02,-9.5929188000117d-02,-5.9794681588545d-02,
     |  -2.0346270832250d-02,-3.9861790135442d-03,-4.3364585248682d-04,
     |  -2.3620511611363d-05,-5.3061508417331d-07,-3.0990337555159d-09,
     |  -3.2585773222682d-10, 3.2860539524980d-10,-3.3171986529292d-10/
      data (zmn(lat,22,28), lat = 1,36)/
     |   1.5721562022288d-12,-4.5762042766120d-12, 7.4804117224871d-12,
     |   4.5551896269030d-10, 9.5948732936789d-08, 5.4594310001101d-06,
     |   1.2557098676025d-04, 1.4387245004664d-03, 9.2413035938514d-03,
     |   3.5295873055173d-02, 8.0318839972145d-02, 9.7824188096411d-02,
     |   2.6611305539612d-02,-7.6777371632216d-02,-5.6878555000066d-02,
     |   6.3048562545560d-02, 6.2385745805505d-02,-6.1350632572919d-02,
     |  -6.1350632572919d-02, 6.2385745805505d-02, 6.3048562545560d-02,
     |  -5.6878555000066d-02,-7.6777371632216d-02, 2.6611305539612d-02,
     |   9.7824188096411d-02, 8.0318839972145d-02, 3.5295873055173d-02,
     |   9.2413035938512d-03, 1.4387245004663d-03, 1.2557098676009d-04,
     |   5.4594310001765d-06, 9.5948733074899d-08, 4.5551894979517d-10,
     |   7.4803510164604d-12,-4.5761004581214d-12, 1.5721313201442d-12/
      data (zmn(lat,23,28), lat = 1,36)/
     |  -2.5124603556076d-11, 2.4931918193534d-11,-2.4549721854743d-11,
     |   8.0490275210926d-11, 1.5404865615418d-08, 1.1173225209132d-06,
     |   3.2009621321098d-05, 4.5302123571012d-04, 3.6072504206937d-03,
     |   1.7402711597984d-02, 5.2426261477725d-02, 9.6261329026332d-02,
     |   9.1257773394375d-02,-5.8143840044796d-04,-8.9205270897970d-02,
     |  -4.2496971816715d-02, 7.3672972787829d-02, 6.0751243088359d-02,
     |  -6.0751243088359d-02,-7.3672972787829d-02, 4.2496971816714d-02,
     |   8.9205270897970d-02, 5.8143840044814d-04,-9.1257773394376d-02,
     |  -9.6261329026332d-02,-5.2426261477725d-02,-1.7402711597984d-02,
     |  -3.6072504206939d-03,-4.5302123571012d-04,-3.2009621321095d-05,
     |  -1.1173225208386d-06,-1.5404865569990d-08,-8.0490205141222d-11,
     |   2.4549806784401d-11,-2.4931930413214d-11, 2.5124647498729d-11/
      data (zmn(lat,24,28), lat = 1,36)/
     |  -8.6417731084305d-14, 2.5231507159511d-13,-3.9781811243972d-13,
     |   6.5458368712862d-12, 2.1795895990700d-09, 2.0026290523626d-07,
     |   7.1120616648546d-06, 1.2344444096365d-04, 1.2048654388073d-03,
     |   7.2014662539959d-03, 2.7627871912916d-02, 6.8822915897219d-02,
     |   1.0665490139110d-01, 8.2605697934263d-02,-1.8533399271549d-02,
     |  -9.5276139645823d-02,-4.0009898468590d-02, 7.4123824901001d-02,
     |   7.4123824901001d-02,-4.0009898468590d-02,-9.5276139645823d-02,
     |  -1.8533399271549d-02, 8.2605697934263d-02, 1.0665490139110d-01,
     |   6.8822915897219d-02, 2.7627871912916d-02, 7.2014662539959d-03,
     |   1.2048654388075d-03, 1.2344444096368d-04, 7.1120616650557d-06,
     |   2.0026290520056d-07, 2.1795894249229d-09, 6.5458219771684d-12,
     |  -3.9773097118594d-13, 2.5246144267712d-13,-8.6404501796404d-14/
      data (zmn(lat,25,28), lat = 1,36)/
     |   1.3046027787052d-12,-1.2962722163115d-12, 1.2807228219954d-12,
     |  -7.0276097483950d-13, 2.6707290057016d-10, 3.0883940358401d-08,
     |   1.3542174409740d-06, 2.8660067413936d-05, 3.3990348252297d-04,
     |   2.4819853889856d-03, 1.1829031442106d-02, 3.7938595717125d-02,
     |   8.1971423089252d-02, 1.1344352336478d-01, 7.9524965266530d-02,
     |  -2.2569925636522d-02,-9.8952925200172d-02,-5.6609117216382d-02,
     |   5.6609117216382d-02, 9.8952925200172d-02, 2.2569925636523d-02,
     |  -7.9524965266530d-02,-1.1344352336478d-01,-8.1971423089252d-02,
     |  -3.7938595717125d-02,-1.1829031442106d-02,-2.4819853889856d-03,
     |  -3.3990348252290d-04,-2.8660067413974d-05,-1.3542174409689d-06,
     |  -3.0883940309416d-08,-2.6707285660508d-10, 7.0267708195415d-13,
     |  -1.2808403923481d-12, 1.2962863400322d-12,-1.3047382259386d-12/
      data (zmn(lat,26,28), lat = 1,36)/
     |   3.1321863635047d-15,-8.8093214574722d-15, 1.3905075518511d-14,
     |   2.4631861046063d-14, 2.7156793851740d-11, 3.9777402358374d-09,
     |   2.1460658401897d-07, 5.5113667359360d-06, 7.8871659671439d-05,
     |   6.9619360491049d-04, 4.0516327798295d-03, 1.6216376183842d-02,
     |   4.5621138297881d-02, 9.0096024682475d-02, 1.1970191371234d-01,
     |   8.9335865268174d-02,-5.4067798314078d-03,-9.4504000521768d-02,
     |  -9.4504000521768d-02,-5.4067798314080d-03, 8.9335865268174d-02,
     |   1.1970191371234d-01, 9.0096024682475d-02, 4.5621138297881d-02,
     |   1.6216376183842d-02, 4.0516327798295d-03, 6.9619360491047d-04,
     |   7.8871659671385d-05, 5.5113667359325d-06, 2.1460658395730d-07,
     |   3.9777402652647d-09, 2.7156898080986d-11, 2.4657332794547d-14,
     |   1.3842738350926d-14,-8.8884331251256d-15, 3.2087083301721d-15/
      data (zmn(lat,27,28), lat = 1,36)/
     |  -3.6789539847135d-14, 3.6572832801366d-14,-3.6316864598008d-14,
     |   3.8204149250156d-14, 2.1547713535520d-12, 4.0424079391654d-10,
     |   2.6755236852625d-08, 8.3043134758287d-07, 1.4258769744799d-05,
     |   1.5089178308378d-04, 1.0588414654761d-03, 5.1802578636188d-03,
     |   1.8269764709604d-02, 4.7357288675539d-02, 9.0616092690864d-02,
     |   1.2558466219749d-01, 1.1655609945165d-01, 4.8241152489257d-02,
     |  -4.8241152489257d-02,-1.1655609945165d-01,-1.2558466219749d-01,
     |  -9.0616092690864d-02,-4.7357288675539d-02,-1.8269764709604d-02,
     |  -5.1802578636189d-03,-1.0588414654761d-03,-1.5089178308378d-04,
     |  -1.4258769744795d-05,-8.3043134756685d-07,-2.6755236844469d-08,
     |  -4.0424084099604d-10,-2.1548186014420d-12,-3.8200013250387d-14,
     |   3.6378142412836d-14,-3.6503396222688d-14, 3.6797919551224d-14/
      data (zmn(lat,28,28), lat = 1,36)/
     |  -7.3734792368450d-17, 6.2872625246032d-17,-3.4216518726464d-16,
     |   1.8270527684976d-16, 1.2072171018957d-13, 2.8118309097594d-11,
     |   2.2777317995562d-09, 8.5151083616624d-08, 1.7459849869584d-06,
     |   2.2004885611766d-05, 1.8439810504044d-04, 1.0866008313547d-03,
     |   4.6898857703049d-03, 1.5278070221203d-02, 3.8405110206615d-02,
     |   7.5698513405584d-02, 1.1830739432514d-01, 1.4764901381738d-01,
     |   1.4764901381738d-01, 1.1830739432514d-01, 7.5698513405585d-02,
     |   3.8405110206616d-02, 1.5278070221203d-02, 4.6898857703049d-03,
     |   1.0866008313547d-03, 1.8439810504043d-04, 2.2004885611766d-05,
     |   1.7459849869607d-06, 8.5151083582708d-08, 2.2777317997436d-09,
     |   2.8118316116537d-11, 1.2072446504285d-13, 1.7327837242924d-16,
     |  -3.5056679616654d-16, 3.8456960829131d-17,-8.8271251757409d-17/
      data (zmn(lat, 0,29), lat = 1,36)/
     |   8.3863731976853d-03,-2.0894512831998d-02, 2.2344318369164d-02,
     |  -1.0486705579994d-02,-1.1313545294330d-02, 3.5179594444183d-02,
     |  -5.1615541503069d-02, 5.3133898499430d-02,-3.7268218424812d-02,
     |   7.8240607272252d-03, 2.6150513324180d-02,-5.3365698248797d-02,
     |   6.4224855943587d-02,-5.4294859951157d-02, 2.6053077297168d-02,
     |   1.1751649805806d-02,-4.6944797647629d-02, 6.8012483072794d-02,
     |  -6.8012483072793d-02, 4.6944797647629d-02,-1.1751649805806d-02,
     |  -2.6053077297169d-02, 5.4294859951157d-02,-6.4224855943587d-02,
     |   5.3365698248797d-02,-2.6150513324180d-02,-7.8240607272254d-03,
     |   3.7268218424812d-02,-5.3133898499430d-02, 5.1615541503069d-02,
     |  -3.5179594444182d-02, 1.1313545294330d-02, 1.0486705579995d-02,
     |  -2.2344318369164d-02, 2.0894512831999d-02,-8.3863731976849d-03/
      data (zmn(lat, 1,29), lat = 1,36)/
     |   1.6127212920214d-02,-3.6647869651263d-03,-1.5877294013924d-02,
     |   3.3829755125180d-02,-4.1644075711023d-02, 3.4329227710056d-02,
     |  -1.2612749485963d-02,-1.7019092517400d-02, 4.4469973070351d-02,
     |  -5.9627259173428d-02, 5.6108414992852d-02,-3.3785262166745d-02,
     |  -8.6990799523774d-04, 3.6799570858993d-02,-6.2070696744202d-02,
     |   6.7991567594067d-02,-5.2183187578594d-02, 1.9506277498510d-02,
     |   1.9506277498511d-02,-5.2183187578594d-02, 6.7991567594067d-02,
     |  -6.2070696744201d-02, 3.6799570858992d-02,-8.6990799523832d-04,
     |  -3.3785262166745d-02, 5.6108414992852d-02,-5.9627259173428d-02,
     |   4.4469973070351d-02,-1.7019092517400d-02,-1.2612749485964d-02,
     |   3.4329227710057d-02,-4.1644075711023d-02, 3.3829755125180d-02,
     |  -1.5877294013924d-02,-3.6647869651262d-03, 1.6127212920214d-02/
      data (zmn(lat, 2,29), lat = 1,36)/
     |   4.8629617507145d-03, 2.2977482666607d-02,-2.9613025761367d-02,
     |   1.9496342702429d-02, 3.1548352561850d-03,-2.9627223787303d-02,
     |   4.9371759981119d-02,-5.3854104820447d-02, 3.9842709906199d-02,
     |  -1.0843107644848d-02,-2.3907603008059d-02, 5.2577126666876d-02,
     |  -6.4910593857532d-02, 5.5949989905708d-02,-2.7952035795704d-02,
     |  -1.0214024875510d-02, 4.6012638407305d-02,-6.7517092273687d-02,
     |   6.7517092273687d-02,-4.6012638407305d-02, 1.0214024875509d-02,
     |   2.7952035795704d-02,-5.5949989905709d-02, 6.4910593857532d-02,
     |  -5.2577126666876d-02, 2.3907603008059d-02, 1.0843107644848d-02,
     |  -3.9842709906199d-02, 5.3854104820447d-02,-4.9371759981119d-02,
     |   2.9627223787302d-02,-3.1548352561849d-03,-1.9496342702429d-02,
     |   2.9613025761367d-02,-2.2977482666607d-02,-4.8629617507149d-03/
      data (zmn(lat, 3,29), lat = 1,36)/
     |  -1.0075846449641d-03, 2.7423963243390d-02,-2.2633495122118d-03,
     |  -2.5493364789270d-02, 4.2776829747965d-02,-4.2153530063650d-02,
     |   2.3188072947851d-02, 7.5076055238804d-03,-3.8655821769623d-02,
     |   5.8413024176874d-02,-5.8734576962104d-02, 3.8421514710508d-02,
     |  -3.7263602881361d-03,-3.3730905351300d-02, 6.1014882530392d-02,
     |  -6.8456918842440d-02, 5.3128188175554d-02,-1.9952531701448d-02,
     |  -1.9952531701448d-02, 5.3128188175554d-02,-6.8456918842440d-02,
     |   6.1014882530392d-02,-3.3730905351300d-02,-3.7263602881356d-03,
     |   3.8421514710509d-02,-5.8734576962104d-02, 5.8413024176874d-02,
     |  -3.8655821769623d-02, 7.5076055238796d-03, 2.3188072947852d-02,
     |  -4.2153530063651d-02, 4.2776829747965d-02,-2.5493364789270d-02,
     |  -2.2633495122123d-03, 2.7423963243390d-02,-1.0075846449642d-03/
      data (zmn(lat, 4,29), lat = 1,36)/
     |  -7.7833091755353d-05, 1.6426464799959d-02, 2.9545583493960d-02,
     |  -3.7508657429761d-02, 1.9074291379386d-02, 1.2243564552149d-02,
     |  -4.1314841047836d-02, 5.5363426390586d-02,-4.8007645253481d-02,
     |   2.1281198008382d-02, 1.5283271403189d-02,-4.8239656426898d-02,
     |   6.5208418277337d-02,-5.9457120018245d-02, 3.2426060290895d-02,
     |   6.7152156092538d-03,-4.4321274919021d-02, 6.7158257513384d-02,
     |  -6.7158257513384d-02, 4.4321274919020d-02,-6.7152156092533d-03,
     |  -3.2426060290895d-02, 5.9457120018245d-02,-6.5208418277337d-02,
     |   4.8239656426898d-02,-1.5283271403189d-02,-2.1281198008382d-02,
     |   4.8007645253481d-02,-5.5363426390586d-02, 4.1314841047836d-02,
     |  -1.2243564552148d-02,-1.9074291379386d-02, 3.7508657429761d-02,
     |  -2.9545583493959d-02,-1.6426464799959d-02, 7.7833091755713d-05/
      data (zmn(lat, 5,29), lat = 1,36)/
     |   5.2315425989864d-04, 6.6842713406486d-03, 3.8843377565290d-02,
     |  -7.0299230435641d-03,-3.0341806373068d-02, 4.8805178889924d-02,
     |  -4.1091990425196d-02, 1.2255224411296d-02, 2.4461292161195d-02,
     |  -5.3336337836934d-02, 6.2228263076209d-02,-4.7034703487498d-02,
     |   1.3058383319417d-02, 2.7131414789149d-02,-5.8495924612936d-02,
     |   6.9186818039116d-02,-5.4978730245564d-02, 2.0850793153611d-02,
     |   2.0850793153611d-02,-5.4978730245564d-02, 6.9186818039116d-02,
     |  -5.8495924612936d-02, 2.7131414789148d-02, 1.3058383319416d-02,
     |  -4.7034703487499d-02, 6.2228263076209d-02,-5.3336337836934d-02,
     |   2.4461292161195d-02, 1.2255224411297d-02,-4.1091990425196d-02,
     |   4.8805178889924d-02,-3.0341806373068d-02,-7.0299230435640d-03,
     |   3.8843377565290d-02, 6.6842713406486d-03, 5.2315425989880d-04/
      data (zmn(lat, 6,29), lat = 1,36)/
     |   4.1745044813228d-05, 2.3878837563360d-03, 2.9892113715789d-02,
     |   3.0643391399409d-02,-4.4937096629319d-02, 2.0425930888056d-02,
     |   1.8966305010598d-02,-4.9882517694182d-02, 5.7233858904186d-02,
     |  -3.8023786185583d-02, 8.7182791880430d-04, 3.8402953611460d-02,
     |  -6.3455065994706d-02, 6.3884449028222d-02,-3.9172937233555d-02,
     |  -1.2764909520323d-03, 4.1903436468690d-02,-6.7060619298087d-02,
     |   6.7060619298086d-02,-4.1903436468690d-02, 1.2764909520319d-03,
     |   3.9172937233555d-02,-6.3884449028222d-02, 6.3455065994706d-02,
     |  -3.8402953611459d-02,-8.7182791880440d-04, 3.8023786185583d-02,
     |  -5.7233858904186d-02, 4.9882517694182d-02,-1.8966305010597d-02,
     |  -2.0425930888056d-02, 4.4937096629319d-02,-3.0643391399409d-02,
     |  -2.9892113715789d-02,-2.3878837563359d-03,-4.1745044813547d-05/
      data (zmn(lat, 7,29), lat = 1,36)/
     |  -1.2820252701612d-04, 8.3144239242936d-04, 1.7106081228527d-02,
     |   4.7611054539486d-02,-1.4681634837682d-02,-3.2794253592192d-02,
     |   5.3804109068292d-02,-3.9453988852292d-02, 1.4096255690486d-03,
     |   3.9191165584804d-02,-6.2398587717163d-02, 5.7577077259282d-02,
     |  -2.6928222268241d-02,-1.6291976407284d-02, 5.3767485361883d-02,
     |  -6.9804383840339d-02, 5.7676313370156d-02,-2.2222373514384d-02,
     |  -2.2222373514385d-02, 5.7676313370156d-02,-6.9804383840339d-02,
     |   5.3767485361883d-02,-1.6291976407283d-02,-2.6928222268241d-02,
     |   5.7577077259283d-02,-6.2398587717163d-02, 3.9191165584804d-02,
     |   1.4096255690488d-03,-3.9453988852292d-02, 5.3804109068291d-02,
     |  -3.2794253592192d-02,-1.4681634837683d-02, 4.7611054539486d-02,
     |   1.7106081228527d-02, 8.3144239242950d-04,-1.2820252701623d-04/
      data (zmn(lat, 8,29), lat = 1,36)/
     |  -7.6422538335166d-06, 1.9762861711380d-04, 8.0119067940053d-03,
     |   4.2977330599517d-02, 2.8097389379247d-02,-5.1652899125940d-02,
     |   2.2433368186919d-02, 2.4973419599111d-02,-5.6873829125622d-02,
     |   5.5884146342318d-02,-2.4292941972229d-02,-2.0808911437980d-02,
     |   5.7192369388346d-02,-6.7812553498412d-02, 4.7894590230237d-02,
     |  -6.3721991197577d-03,-3.8471345322367d-02, 6.7094334313479d-02,
     |  -6.7094334313479d-02, 3.8471345322366d-02, 6.3721991197582d-03,
     |  -4.7894590230237d-02, 6.7812553498412d-02,-5.7192369388346d-02,
     |   2.0808911437979d-02, 2.4292941972229d-02,-5.5884146342318d-02,
     |   5.6873829125621d-02,-2.4973419599111d-02,-2.2433368186919d-02,
     |   5.1652899125940d-02,-2.8097389379247d-02,-4.2977330599517d-02,
     |  -8.0119067940053d-03,-1.9762861711382d-04, 7.6422538337768d-06/
      data (zmn(lat, 9,29), lat = 1,36)/
     |   3.0341850204890d-05, 1.0499275202552d-05, 3.1924010635285d-03,
     |   2.9117276205262d-02, 5.3248339206531d-02,-2.3078645651046d-02,
     |  -3.4396205239468d-02, 5.8281405810952d-02,-3.6577994265344d-02,
     |  -1.0577994478897d-02, 5.2463094546549d-02,-6.5659961783052d-02,
     |   4.4059779889456d-02, 5.4512509853296d-04,-4.5750658767752d-02,
     |   6.9700569442868d-02,-6.1120351638540d-02, 2.4103243813215d-02,
     |   2.4103243813215d-02,-6.1120351638540d-02, 6.9700569442868d-02,
     |  -4.5750658767752d-02, 5.4512509853246d-04, 4.4059779889456d-02,
     |  -6.5659961783052d-02, 5.2463094546549d-02,-1.0577994478896d-02,
     |  -3.6577994265344d-02, 5.8281405810952d-02,-3.4396205239468d-02,
     |  -2.3078645651046d-02, 5.3248339206531d-02, 2.9117276205262d-02,
     |   3.1924010635283d-03, 1.0499275202369d-05, 3.0341850204982d-05/
      data (zmn(lat,10,29), lat = 1,36)/
     |   1.4513592456814d-06, 3.2786640541570d-06, 1.0854882968733d-03,
     |   1.6114214960970d-02, 5.4381246648134d-02, 2.3715200642806d-02,
     |  -5.7525138034859d-02, 2.3725097404254d-02, 3.1769792854392d-02,
     |  -6.2745552167819d-02, 5.0492028418405d-02,-5.8884483326088d-03,
     |  -4.3088477092025d-02, 6.8757513872684d-02,-5.7761883606118d-02,
     |   1.6424620544739d-02, 3.3706640794534d-02,-6.7165998364325d-02,
     |   6.7165998364325d-02,-3.3706640794534d-02,-1.6424620544740d-02,
     |   5.7761883606118d-02,-6.8757513872684d-02, 4.3088477092025d-02,
     |   5.8884483326093d-03,-5.0492028418405d-02, 6.2745552167819d-02,
     |  -3.1769792854392d-02,-2.3725097404255d-02, 5.7525138034859d-02,
     |  -2.3715200642806d-02,-5.4381246648134d-02,-1.6114214960970d-02,
     |  -1.0854882968735d-03,-3.2786640541197d-06,-1.4513592457590d-06/
      data (zmn(lat,11,29), lat = 1,36)/
     |  -6.6225071001712d-06, 7.4306803725188d-06, 3.1803124213149d-04,
     |   7.5795560268114d-03, 4.1301859242804d-02, 5.6430481890308d-02,
     |  -3.0662030872993d-02,-3.6612178381361d-02, 6.2208887813380d-02,
     |  -3.0995494025174d-02,-2.5041139295317d-02, 6.3796779180705d-02,
     |  -6.0908501709289d-02, 2.0109526226058d-02, 3.3136175732142d-02,
     |  -6.7970085758619d-02, 6.5138691283488d-02,-2.6545813731652d-02,
     |  -2.6545813731652d-02, 6.5138691283488d-02,-6.7970085758618d-02,
     |   3.3136175732141d-02, 2.0109526226059d-02,-6.0908501709288d-02,
     |   6.3796779180705d-02,-2.5041139295317d-02,-3.0995494025174d-02,
     |   6.2208887813380d-02,-3.6612178381361d-02,-3.0662030872993d-02,
     |   5.6430481890308d-02, 4.1301859242805d-02, 7.5795560268114d-03,
     |   3.1803124213167d-04, 7.4306803725358d-06,-6.6225071001091d-06/
      data (zmn(lat,12,29), lat = 1,36)/
     |  -2.6333534809835d-07, 9.2752356589050d-07, 8.5190395547561d-05,
     |   3.0971296738553d-03, 2.5577774042504d-02, 6.3709476516010d-02,
     |   1.9409361747196d-02,-6.2725235338394d-02, 2.2746861094059d-02,
     |   4.0665640446693d-02,-6.6792970233557d-02, 3.8883150527270d-02,
     |   1.8054816513257d-02,-6.3035084430259d-02, 6.7083135178618d-02,
     |  -2.8876202846175d-02,-2.7255050258579d-02, 6.7215743214500d-02,
     |  -6.7215743214500d-02, 2.7255050258579d-02, 2.8876202846175d-02,
     |  -6.7083135178618d-02, 6.3035084430258d-02,-1.8054816513257d-02,
     |  -3.8883150527271d-02, 6.6792970233557d-02,-4.0665640446693d-02,
     |  -2.2746861094059d-02, 6.2725235338394d-02,-1.9409361747196d-02,
     |  -6.3709476516010d-02,-2.5577774042504d-02,-3.0971296738556d-03,
     |  -8.5190395547274d-05,-9.2752356587257d-07, 2.6333534794517d-07/
      data (zmn(lat,13,29), lat = 1,36)/
     |   1.3156484738713d-06,-1.2266572007081d-06, 2.1809650873090d-05,
     |   1.1167628255983d-03, 1.3472372803600d-02, 5.2552179173439d-02,
     |   5.8537507981142d-02,-3.6199196499899d-02,-4.0949558713632d-02,
     |   6.4981080904220d-02,-2.0574912799521d-02,-4.2611110628042d-02,
     |   7.0365451748633d-02,-4.3896108894972d-02,-1.4690924897879d-02,
     |   6.3353136077620d-02,-6.9447247061256d-02, 2.9624158177360d-02,
     |   2.9624158177360d-02,-6.9447247061256d-02, 6.3353136077620d-02,
     |  -1.4690924897879d-02,-4.3896108894972d-02, 7.0365451748633d-02,
     |  -4.2611110628042d-02,-2.0574912799520d-02, 6.4981080904220d-02,
     |  -4.0949558713632d-02,-3.6199196499900d-02, 5.8537507981142d-02,
     |   5.2552179173439d-02, 1.3472372803600d-02, 1.1167628255983d-03,
     |   2.1809650872832d-05,-1.2266572005192d-06, 1.3156484737768d-06/
      data (zmn(lat,14,29), lat = 1,36)/
     |   4.4447851870495d-08,-1.2408918624669d-07, 4.6653733889781d-06,
     |   3.6015134670702d-04, 6.1802641821488d-03, 3.5168247321646d-02,
     |   7.1305479642325d-02, 1.7139130498106d-02,-6.7471789181841d-02,
     |   1.7597499141076d-02, 5.2392291679532d-02,-6.6517980884194d-02,
     |   1.7914798515099d-02, 4.6193431037861d-02,-7.2931773866591d-02,
     |   4.3340140959920d-02, 1.8701126138330d-02,-6.7190627338698d-02,
     |   6.7190627338698d-02,-1.8701126138330d-02,-4.3340140959921d-02,
     |   7.2931773866591d-02,-4.6193431037861d-02,-1.7914798515098d-02,
     |   6.6517980884194d-02,-5.2392291679532d-02,-1.7597499141076d-02,
     |   6.7471789181842d-02,-1.7139130498105d-02,-7.1305479642325d-02,
     |  -3.5168247321646d-02,-6.1802641821487d-03,-3.6015134670686d-04,
     |  -4.6653733891800d-06, 1.2408918626260d-07,-4.4447851732087d-08/
      data (zmn(lat,15,29), lat = 1,36)/
     |  -2.3372433601822d-07, 2.2512205099579d-07, 6.6850188448878d-07,
     |   1.0473541771312d-04, 2.5066244178094d-03, 1.9975556963856d-02,
     |   6.2222956003086d-02, 6.1303219136125d-02,-3.8442829966914d-02,
     |  -4.8770387304373d-02, 6.4822938603949d-02,-2.6806293324644d-03,
     |  -6.1678314484505d-02, 6.5671626006117d-02,-1.0063229687393d-02,
     |  -5.4210984116547d-02, 7.3588453947943d-02,-3.3443355389072d-02,
     |  -3.3443355389072d-02, 7.3588453947943d-02,-5.4210984116547d-02,
     |  -1.0063229687393d-02, 6.5671626006117d-02,-6.1678314484506d-02,
     |  -2.6806293324650d-03, 6.4822938603948d-02,-4.8770387304373d-02,
     |  -3.8442829966914d-02, 6.1303219136125d-02, 6.2222956003086d-02,
     |   1.9975556963856d-02, 2.5066244178095d-03, 1.0473541771315d-04,
     |   6.6850188469896d-07, 2.2512205067164d-07,-2.3372433593351d-07/
      data (zmn(lat,16,29), lat = 1,36)/
     |  -6.7911570919264d-09, 1.9705567316680d-08, 1.2620105403934d-07,
     |   2.7468635334519d-05, 9.0798944299249d-04, 9.8676776037436d-03,
     |   4.3755585279107d-02, 7.7946176656657d-02, 1.8916583044269d-02,
     |  -7.1426554318463d-02, 5.8262711844103d-03, 6.6041840364131d-02,
     |  -5.6712103856994d-02,-1.4768085891441d-02, 7.0855975124696d-02,
     |  -5.8724935182505d-02,-7.5614308689186d-03, 6.7026283481806d-02,
     |  -6.7026283481806d-02, 7.5614308689185d-03, 5.8724935182505d-02,
     |  -7.0855975124696d-02, 1.4768085891441d-02, 5.6712103856994d-02,
     |  -6.6041840364131d-02,-5.8262711844103d-03, 7.1426554318463d-02,
     |  -1.8916583044269d-02,-7.7946176656657d-02,-4.3755585279107d-02,
     |  -9.8676776037436d-03,-9.0798944299269d-04,-2.7468635334642d-05,
     |  -1.2620105404390d-07,-1.9705567281862d-08, 6.7911568598781d-09/
      data (zmn(lat,17,29), lat = 1,36)/
     |   3.6356204466613d-08,-3.5200811782143d-08, 5.8760569452154d-08,
     |   6.5012604246880d-06, 2.9568940625909d-04, 4.3018552250283d-03,
     |   2.6010286808859d-02, 7.0005096882316d-02, 6.6472041629741d-02,
     |  -3.5588604358631d-02,-6.0684531958605d-02, 5.7807573170479d-02,
     |   2.4674653314916d-02,-7.5410581202319d-02, 3.9563639364086d-02,
     |   3.8606169334847d-02,-7.6834381921876d-02, 3.8155961068415d-02,
     |   3.8155961068415d-02,-7.6834381921876d-02, 3.8606169334847d-02,
     |   3.9563639364086d-02,-7.5410581202319d-02, 2.4674653314917d-02,
     |   5.7807573170479d-02,-6.0684531958605d-02,-3.5588604358632d-02,
     |   6.6472041629741d-02, 7.0005096882316d-02, 2.6010286808859d-02,
     |   4.3018552250282d-03, 2.9568940625904d-04, 6.5012604246342d-06,
     |   5.8760569350667d-08,-3.5200811382800d-08, 3.6356204305038d-08/
      data (zmn(lat,18,29), lat = 1,36)/
     |   9.1268891859895d-10,-2.6626356168726d-09, 8.0366031593312d-09,
     |   1.4092163296897d-06, 8.6905801419653d-05, 1.6702768704608d-03,
     |   1.3396446289775d-02, 5.0352493305865d-02, 8.4376146378236d-02,
     |   2.6860316586129d-02,-7.2664375933834d-02,-1.5278897961166d-02,
     |   7.6785818979083d-02,-2.9512633896759d-02,-5.5101475916900d-02,
     |   7.2722415404906d-02,-6.6958923102326d-03,-6.6631928156584d-02,
     |   6.6631928156583d-02, 6.6958923102326d-03,-7.2722415404906d-02,
     |   5.5101475916900d-02, 2.9512633896759d-02,-7.6785818979083d-02,
     |   1.5278897961165d-02, 7.2664375933833d-02,-2.6860316586129d-02,
     |  -8.4376146378236d-02,-5.0352493305866d-02,-1.3396446289775d-02,
     |  -1.6702768704608d-03,-8.6905801419466d-05,-1.4092163294938d-06,
     |  -8.0366031661761d-09, 2.6626357272979d-09,-9.1268868392971d-10/
      data (zmn(lat,19,29), lat = 1,36)/
     |  -4.8248884017419d-09, 4.6949987835417d-09,-3.9366932420367d-09,
     |   2.8306307007919d-07, 2.3104265263470d-05, 5.8077491135033d-04,
     |   6.0624902536333d-03, 3.0455510439109d-02, 7.5561500223905d-02,
     |   7.5342922828909d-02,-2.4635745702812d-02,-7.4995619268639d-02,
     |   3.7122385417731d-02, 5.8786846079632d-02,-6.8109093012129d-02,
     |  -1.4642000392980d-02, 7.8029454382816d-02,-4.3993145874298d-02,
     |  -4.3993145874298d-02, 7.8029454382816d-02,-1.4642000392980d-02,
     |  -6.8109093012129d-02, 5.8786846079632d-02, 3.7122385417730d-02,
     |  -7.4995619268638d-02,-2.4635745702812d-02, 7.5342922828909d-02,
     |   7.5561500223905d-02, 3.0455510439109d-02, 6.0624902536335d-03,
     |   5.8077491135038d-04, 2.3104265263476d-05, 2.8306307005438d-07,
     |  -3.9366932159882d-09, 4.6949984269403d-09,-4.8248882097943d-09/
      data (zmn(lat,20,29), lat = 1,36)/
     |  -1.0435244337361d-10, 3.0605850197952d-10,-4.2419459621141d-10,
     |   5.0675997053557d-08, 5.5622410869111d-06, 1.8135994871293d-04,
     |   2.4299472845001d-03, 1.5866613366521d-02, 5.3970977909280d-02,
     |   9.0634549797254d-02, 4.2978105216868d-02,-6.6157652404668d-02,
     |  -4.6533608600072d-02, 7.2436949830367d-02, 2.0333290030183d-02,
     |  -8.1062010745557d-02, 2.4585599031795d-02, 6.5870028323992d-02,
     |  -6.5870028323992d-02,-2.4585599031795d-02, 8.1062010745557d-02,
     |  -2.0333290030182d-02,-7.2436949830367d-02, 4.6533608600072d-02,
     |   6.6157652404669d-02,-4.2978105216868d-02,-9.0634549797254d-02,
     |  -5.3970977909280d-02,-1.5866613366521d-02,-2.4299472845000d-03,
     |  -1.8135994871294d-04,-5.5622410869217d-06,-5.0675997041799d-08,
     |   4.2419466582460d-10,-3.0605863997402d-10, 1.0435229233751d-10/
      data (zmn(lat,21,29), lat = 1,36)/
     |   5.2801642446646d-10,-5.1564029701573d-10, 4.9995761070704d-10,
     |   7.6877111331535d-09, 1.2116416815026d-06, 5.0891328604171d-05,
     |   8.6602600228824d-04, 7.2101068206176d-03, 3.2212691181