#include <defs.h>
      module he_coef1_dres
!
! This software is part of the NCAR TIE-GCM.  Use is governed by the 
! Open Source Academic Research License Agreement contained in the file 
! tiegcmlicense.txt.
!
! Laplacian coefficients for Helium at 2.5-deg resolution, obtained
! from Eric Sutton (eric.sutton.5@us.af.mil) on May 2, 2014.
!
      integer :: lat
!
#if (NLAT==72 && NLON==144)
! Data statements are used only if 2.5-deg resolution.
!
      real,dimension(72,0:70,0:71) :: zmn
!
!     Zmn Basis Set zmn(lat,m,n)
      data (zmn(lat, 0, 0), lat = 1,72)/
     |   5.8736449859770d-04, 2.0661366742186d-03, 3.3269761225209d-03,
     |   4.7170634359873d-03, 6.0006695825447d-03, 7.3485954189742d-03,
     |   8.6208456204929d-03, 9.9285286324009d-03, 1.1172767499814d-02,
     |   1.2434638609643d-02, 1.3638449401782d-02, 1.4846990230262d-02,
     |   1.5999676188934d-02, 1.7146855523577d-02, 1.8238734244064d-02,
     |   1.9316546292644d-02, 2.0338719801663d-02, 2.1339446143120d-02,
     |   2.2283731030328d-02, 2.3200096214635d-02, 2.4059016060684d-02,
     |   2.4884294421418d-02, 2.5651098116590d-02, 2.6379194359399d-02,
     |   2.7047884760929d-02, 2.7673398129349d-02, 2.8238763647320d-02,
     |   2.8757040240580d-02, 2.9214685486326d-02, 2.9621860967133d-02,
     |   2.9968234288311d-02, 3.0261268103843d-02, 3.0493684706262d-02,
     |   3.0670386389186d-02, 3.0787046238519d-02, 3.0846094069873d-02,
     |   3.0846094069873d-02, 3.0787046238520d-02, 3.0670386389186d-02,
     |   3.0493684706262d-02, 3.0261268103843d-02, 2.9968234288311d-02,
     |   2.9621860967133d-02, 2.9214685486326d-02, 2.8757040240580d-02,
     |   2.8238763647320d-02, 2.7673398129349d-02, 2.7047884760929d-02,
     |   2.6379194359399d-02, 2.5651098116590d-02, 2.4884294421418d-02,
     |   2.4059016060684d-02, 2.3200096214635d-02, 2.2283731030328d-02,
     |   2.1339446143120d-02, 2.0338719801663d-02, 1.9316546292644d-02,
     |   1.8238734244064d-02, 1.7146855523577d-02, 1.5999676188934d-02,
     |   1.4846990230262d-02, 1.3638449401782d-02, 1.2434638609643d-02,
     |   1.1172767499814d-02, 9.9285286324009d-03, 8.6208456204929d-03,
     |   7.3485954189742d-03, 6.0006695825447d-03, 4.7170634359873d-03,
     |   3.3269761225209d-03, 2.0661366742186d-03, 5.8736449859772d-04/
      data (zmn(lat, 0, 1), lat = 1,72)/
     |   1.0169598627880d-03, 3.5714208225374d-03, 5.7275267868316d-03,
     |   8.0761033446027d-03, 1.0192476534958d-02, 1.2364938611047d-02,
     |   1.4333380557026d-02, 1.6286198439462d-02, 1.8033651782164d-02,
     |   1.9716096696665d-02, 2.1183461807650d-02, 2.2548835706992d-02,
     |   2.3688128076124d-02, 2.4697649768656d-02, 2.5472037922410d-02,
     |   2.6096890515320d-02, 2.6481256340979d-02, 2.6703836982845d-02,
     |   2.6685279699522d-02, 2.6499919356296d-02, 2.6078012202675d-02,
     |   2.5491249122909d-02, 2.4677975091845d-02, 2.3708416138134d-02,
     |   2.2527756514490d-02, 2.1205549763606d-02, 1.9692724612556d-02,
     |   1.8058668732607d-02, 1.6259045556733d-02, 1.4363368067781d-02,
     |   1.2331068022661d-02, 1.0231912422796d-02, 8.0281542388244d-03,
     |   5.7898236835437d-03, 3.4810542488688d-03, 1.1720662486037d-03,
     |  -1.1720662486037d-03,-3.4810542488688d-03,-5.7898236835437d-03,
     |  -8.0281542388244d-03,-1.0231912422796d-02,-1.2331068022661d-02,
     |  -1.4363368067781d-02,-1.6259045556733d-02,-1.8058668732607d-02,
     |  -1.9692724612556d-02,-2.1205549763606d-02,-2.2527756514490d-02,
     |  -2.3708416138134d-02,-2.4677975091845d-02,-2.5491249122909d-02,
     |  -2.6078012202675d-02,-2.6499919356296d-02,-2.6685279699522d-02,
     |  -2.6703836982845d-02,-2.6481256340979d-02,-2.6096890515320d-02,
     |  -2.5472037922410d-02,-2.4697649768656d-02,-2.3688128076124d-02,
     |  -2.2548835706992d-02,-2.1183461807650d-02,-1.9716096696665d-02,
     |  -1.8033651782164d-02,-1.6286198439462d-02,-1.4333380557026d-02,
     |  -1.2364938611047d-02,-1.0192476534958d-02,-8.0761033446027d-03,
     |  -5.7275267868316d-03,-3.5714208225375d-03,-1.0169598627880d-03/
      data (zmn(lat, 1, 1), lat = 1,72)/
     |   2.0333284471686d-05, 1.6087054235747d-04, 4.4821331439217d-04,
     |   8.7425975244230d-04, 1.4383274115704d-03, 2.1347013989260d-03,
     |   2.9589848368477d-03, 3.9042813607934d-03, 4.9638516949608d-03,
     |   6.1292856920626d-03, 7.3919853619808d-03, 8.7421223978041d-03,
     |   1.0169600429371d-02, 1.1663406492720d-02, 1.3212297446713d-02,
     |   1.4804378246717d-02, 1.6427624222628d-02, 1.8069601801974d-02,
     |   1.9717883967849d-02, 2.1359865522745d-02, 2.2983103403007d-02,
     |   2.4575196721430d-02, 2.6124070243856d-02, 2.7617899381187d-02,
     |   2.9045347644934d-02, 3.0395522650420d-02, 3.1658173963500d-02,
     |   3.2823669941719d-02, 3.3883159717356d-02, 3.4828563294390d-02,
     |   3.5652699782643d-02, 3.6349285089359d-02, 3.6913027534309d-02,
     |   3.7339629005817d-02, 3.7625848513219d-02, 3.7769503980698d-02,
     |   3.7769503980698d-02, 3.7625848513219d-02, 3.7339629005817d-02,
     |   3.6913027534309d-02, 3.6349285089359d-02, 3.5652699782643d-02,
     |   3.4828563294390d-02, 3.3883159717356d-02, 3.2823669941719d-02,
     |   3.1658173963500d-02, 3.0395522650420d-02, 2.9045347644934d-02,
     |   2.7617899381187d-02, 2.6124070243856d-02, 2.4575196721430d-02,
     |   2.2983103403008d-02, 2.1359865522745d-02, 1.9717883967849d-02,
     |   1.8069601801974d-02, 1.6427624222628d-02, 1.4804378246717d-02,
     |   1.3212297446713d-02, 1.1663406492720d-02, 1.0169600429371d-02,
     |   8.7421223978041d-03, 7.3919853619807d-03, 6.1292856920626d-03,
     |   4.9638516949608d-03, 3.9042813607934d-03, 2.9589848368477d-03,
     |   2.1347013989260d-03, 1.4383274115704d-03, 8.7425975244229d-04,
     |   4.4821331439216d-04, 1.6087054235747d-04, 2.0333284471683d-05/
      data (zmn(lat, 0, 2), lat = 1,72)/
     |   1.3121721847170d-03, 4.5912079127997d-03, 7.3057125624311d-03,
     |   1.0183451720034d-02, 1.2649440057506d-02, 1.5042418516718d-02,
     |   1.7009198578658d-02, 1.8763932966903d-02, 2.0056060387042d-02,
     |   2.1044295914624d-02, 2.1542902535380d-02, 2.1683388683894d-02,
     |   2.1328218224441d-02, 2.0595757859476d-02, 1.9387475729544d-02,
     |   1.7816007607565d-02, 1.5815515947297d-02, 1.3496484273931d-02,
     |   1.0820536846583d-02, 7.8970694593453d-03, 4.7102459442510d-03,
     |   1.3676810793183d-03,-2.1288240849352d-03,-5.6753587931170d-03,
     |  -9.2574094334665d-03,-1.2777493031658d-02,-1.6213234203978d-02,
     |  -1.9476722894478d-02,-2.2542327023798d-02,-2.5334931322733d-02,
     |  -2.7829800587574d-02,-2.9967604065848d-02,-3.1727996743370d-02,
     |  -3.3069924979727d-02,-3.3980079483784d-02,-3.4437468421413d-02,
     |  -3.4437468421413d-02,-3.3980079483784d-02,-3.3069924979727d-02,
     |  -3.1727996743370d-02,-2.9967604065848d-02,-2.7829800587574d-02,
     |  -2.5334931322733d-02,-2.2542327023799d-02,-1.9476722894478d-02,
     |  -1.6213234203978d-02,-1.2777493031658d-02,-9.2574094334665d-03,
     |  -5.6753587931171d-03,-2.1288240849353d-03, 1.3676810793183d-03,
     |   4.7102459442509d-03, 7.8970694593453d-03, 1.0820536846583d-02,
     |   1.3496484273931d-02, 1.5815515947297d-02, 1.7816007607565d-02,
     |   1.9387475729544d-02, 2.0595757859476d-02, 2.1328218224441d-02,
     |   2.1683388683894d-02, 2.1542902535380d-02, 2.1044295914624d-02,
     |   2.0056060387042d-02, 1.8763932966903d-02, 1.7009198578658d-02,
     |   1.5042418516718d-02, 1.2649440057506d-02, 1.0183451720034d-02,
     |   7.3057125624311d-03, 4.5912079127997d-03, 1.3121721847170d-03/
      data (zmn(lat, 1, 2), lat = 1,72)/
     |   4.5756610704172d-05, 3.5864646133587d-04, 9.9657931516868d-04,
     |   1.9318512797199d-03, 3.1547003502471d-03, 4.6362426443182d-03,
     |   6.3524622753478d-03, 8.2666250737261d-03, 1.0345131321812d-02,
     |   1.2544500159450d-02, 1.4824694008347d-02, 1.7137936217181d-02,
     |   1.9440926544375d-02, 2.1684567820656d-02, 2.3825573787973d-02,
     |   2.5816680127658d-02, 2.7617846348701d-02, 2.9186712455003d-02,
     |   3.0489477211923d-02, 3.1491447381173d-02, 3.2167623169380d-02,
     |   3.2493234877797d-02, 3.2454045385772d-02, 3.2036801333869d-02,
     |   3.1239257213646d-02, 3.0060493473722d-02, 2.8510670140088d-02,
     |   2.6601185943282d-02, 2.4354177477191d-02, 2.1792512777255d-02,
     |   1.8949062326451d-02, 1.5856537618274d-02, 1.2556571026096d-02,
     |   9.0894244410446d-03, 5.5029247548767d-03, 1.8420791826332d-03,
     |  -1.8420791826332d-03,-5.5029247548768d-03,-9.0894244410447d-03,
     |  -1.2556571026096d-02,-1.5856537618274d-02,-1.8949062326451d-02,
     |  -2.1792512777255d-02,-2.4354177477191d-02,-2.6601185943282d-02,
     |  -2.8510670140088d-02,-3.0060493473722d-02,-3.1239257213646d-02,
     |  -3.2036801333869d-02,-3.2454045385772d-02,-3.2493234877797d-02,
     |  -3.2167623169380d-02,-3.1491447381173d-02,-3.0489477211923d-02,
     |  -2.9186712455003d-02,-2.7617846348701d-02,-2.5816680127658d-02,
     |  -2.3825573787972d-02,-2.1684567820656d-02,-1.9440926544375d-02,
     |  -1.7137936217181d-02,-1.4824694008347d-02,-1.2544500159450d-02,
     |  -1.0345131321811d-02,-8.2666250737261d-03,-6.3524622753478d-03,
     |  -4.6362426443182d-03,-3.1547003502471d-03,-1.9318512797199d-03,
     |  -9.9657931516868d-04,-3.5864646133588d-04,-4.5756610704171d-05/
      data (zmn(lat, 2, 2), lat = 1,72)/
     |   4.9592439450594d-07, 1.1763324032408d-05, 5.4555120076752d-05,
     |   1.4869332606313d-04, 3.1372453868961d-04, 5.6727748436007d-04,
     |   9.2574310995856d-04, 1.4031216018864d-03, 2.0114422825647d-03,
     |   2.7599222703829d-03, 3.6552908462158d-03, 4.7011794052924d-03,
     |   5.8984306403270d-03, 7.2446829973030d-03, 8.7347064533634d-03,
     |   1.0360158913944d-02, 1.2109968695291d-02, 1.3970243396651d-02,
     |   1.5924704581629d-02, 1.7954728281957d-02, 2.0039826491955d-02,
     |   2.2157795507819d-02, 2.4285230565431d-02, 2.6397755190819d-02,
     |   2.8470549269272d-02, 3.0478630350365d-02, 3.2397371556154d-02,
     |   3.4202804870258d-02, 3.5872103556009d-02, 3.7383878146493d-02,
     |   3.8718598394340d-02, 3.9858855061158d-02, 4.0789698722107d-02,
     |   4.1498844460002d-02, 4.1976908865401d-02, 4.2217540165938d-02,
     |   4.2217540165938d-02, 4.1976908865401d-02, 4.1498844460002d-02,
     |   4.0789698722107d-02, 3.9858855061158d-02, 3.8718598394340d-02,
     |   3.7383878146493d-02, 3.5872103556009d-02, 3.4202804870258d-02,
     |   3.2397371556154d-02, 3.0478630350365d-02, 2.8470549269272d-02,
     |   2.6397755190819d-02, 2.4285230565431d-02, 2.2157795507819d-02,
     |   2.0039826491955d-02, 1.7954728281957d-02, 1.5924704581629d-02,
     |   1.3970243396651d-02, 1.2109968695291d-02, 1.0360158913944d-02,
     |   8.7347064533634d-03, 7.2446829973030d-03, 5.8984306403270d-03,
     |   4.7011794052925d-03, 3.6552908462158d-03, 2.7599222703830d-03,
     |   2.0114422825647d-03, 1.4031216018864d-03, 9.2574310995857d-04,
     |   5.6727748436008d-04, 3.1372453868962d-04, 1.4869332606314d-04,
     |   5.4555120076768d-05, 1.1763324032425d-05, 4.9592439451008d-07/
      data (zmn(lat, 0, 3), lat = 1,72)/
     |   1.5510362436550d-03, 5.3987367274033d-03, 8.4869785627572d-03,
     |   1.1626558477441d-02, 1.4082944545160d-02, 1.6226080805640d-02,
     |   1.7601475889666d-02, 1.8459559923668d-02, 1.8491282689557d-02,
     |   1.7914196945061d-02, 1.6522417685589d-02, 1.4534469597503d-02,
     |   1.1825940765293d-02, 8.6289008707537d-03, 4.8831360423328d-03,
     |   8.3488673312198d-04,-3.5293843001320d-03,-7.9562561122114d-03,
     |  -1.2431278226677d-02,-1.6705466536458d-02,-2.0755568669237d-02,
     |  -2.4350694350293d-02,-2.7477076617683d-02,-2.9935246827113d-02,
     |  -3.1736683147477d-02,-3.2724255353665d-02,-3.2946402738938d-02,
     |  -3.2295189601921d-02,-3.0862545077848d-02,-2.8591448592948d-02,
     |  -2.5618070089306d-02,-2.1932486941203d-02,-1.7710142212418d-02,
     |  -1.2979155773188d-02,-7.9442750911616d-03,-2.6583217166286d-03,
     |   2.6583217166286d-03, 7.9442750911616d-03, 1.2979155773188d-02,
     |   1.7710142212418d-02, 2.1932486941203d-02, 2.5618070089306d-02,
     |   2.8591448592948d-02, 3.0862545077848d-02, 3.2295189601921d-02,
     |   3.2946402738938d-02, 3.2724255353665d-02, 3.1736683147477d-02,
     |   2.9935246827113d-02, 2.7477076617683d-02, 2.4350694350293d-02,
     |   2.0755568669237d-02, 1.6705466536458d-02, 1.2431278226677d-02,
     |   7.9562561122114d-03, 3.5293843001321d-03,-8.3488673312192d-04,
     |  -4.8831360423328d-03,-8.6289008707537d-03,-1.1825940765293d-02,
     |  -1.4534469597503d-02,-1.6522417685589d-02,-1.7914196945061d-02,
     |  -1.8491282689557d-02,-1.8459559923668d-02,-1.7601475889665d-02,
     |  -1.6226080805640d-02,-1.4082944545160d-02,-1.1626558477441d-02,
     |  -8.4869785627572d-03,-5.3987367274033d-03,-1.5510362436550d-03/
      data (zmn(lat, 1, 3), lat = 1,72)/
     |   7.6060089639834d-05, 5.9867888198477d-04, 1.6522400316180d-03,
     |   3.1765304558662d-03, 5.1257157689432d-03, 7.4232463265823d-03,
     |   9.9878486492318d-03, 1.2721712950985d-02, 1.5523332990364d-02,
     |   1.8283718631868d-02, 2.0895183814624d-02, 2.3250665884355d-02,
     |   2.5250500869634d-02, 2.6802959004020d-02, 2.7829516004003d-02,
     |   2.8265584780123d-02, 2.8064343001223d-02, 2.7197027765738d-02,
     |   2.5655272080133d-02, 2.3450581144383d-02, 2.0615163574719d-02,
     |   1.7200416524335d-02, 1.3276334086110d-02, 8.9290147308343d-03,
     |   4.2588476276655d-03,-6.2278244163361d-04,-5.5962183080266d-03,
     |  -1.0537325442496d-02,-1.5320727494387d-02,-1.9823715662158d-02,
     |  -2.3929555868085d-02,-2.7531095318249d-02,-3.0533706018421d-02,
     |  -3.2858193291933d-02,-3.4442995376988d-02,-3.5246070287968d-02,
     |  -3.5246070287968d-02,-3.4442995376988d-02,-3.2858193291933d-02,
     |  -3.0533706018421d-02,-2.7531095318249d-02,-2.3929555868085d-02,
     |  -1.9823715662158d-02,-1.5320727494387d-02,-1.0537325442496d-02,
     |  -5.5962183080266d-03,-6.2278244163363d-04, 4.2588476276655d-03,
     |   8.9290147308343d-03, 1.3276334086110d-02, 1.7200416524335d-02,
     |   2.0615163574719d-02, 2.3450581144383d-02, 2.5655272080133d-02,
     |   2.7197027765738d-02, 2.8064343001223d-02, 2.8265584780123d-02,
     |   2.7829516004003d-02, 2.6802959004020d-02, 2.5250500869634d-02,
     |   2.3250665884355d-02, 2.0895183814624d-02, 1.8283718631868d-02,
     |   1.5523332990364d-02, 1.2721712950985d-02, 9.9878486492318d-03,
     |   7.4232463265822d-03, 5.1257157689432d-03, 3.1765304558661d-03,
     |   1.6522400316180d-03, 5.9867888198476d-04, 7.6060089639852d-05/
      data (zmn(lat, 2, 3), lat = 1,72)/
     |   1.3121276264149d-06, 3.1055152518134d-05, 1.4348310956024d-04,
     |   3.8882449433967d-04, 8.1409128470783d-04, 1.4578593892599d-03,
     |   2.3514411670109d-03, 3.5152938466879d-03, 4.9599429322969d-03,
     |   6.6836602189802d-03, 8.6736548471529d-03, 1.0904852621000d-02,
     |   1.3341575343842d-02, 1.5937292657385d-02, 1.8636832162289d-02,
     |   2.1376938814312d-02, 2.4088932028186d-02, 2.6699853904575d-02,
     |   2.9135398324845d-02, 3.1321384087455d-02, 3.3186723535435d-02,
     |   3.4664933754129d-02, 3.5696889972953d-02, 3.6232094026907d-02,
     |   3.6230970623434d-02, 3.5665648662650d-02, 3.4521603465636d-02,
     |   3.2797770104871d-02, 3.0507405608072d-02, 2.7677437254816d-02,
     |   2.4348506566694d-02, 2.0573549959035d-02, 1.6417080124840d-02,
     |   1.1953090431050d-02, 7.2637176106807d-03, 2.4366437479598d-03,
     |  -2.4366437479598d-03,-7.2637176106807d-03,-1.1953090431050d-02,
     |  -1.6417080124840d-02,-2.0573549959035d-02,-2.4348506566694d-02,
     |  -2.7677437254816d-02,-3.0507405608072d-02,-3.2797770104871d-02,
     |  -3.4521603465635d-02,-3.5665648662650d-02,-3.6230970623434d-02,
     |  -3.6232094026907d-02,-3.5696889972953d-02,-3.4664933754129d-02,
     |  -3.3186723535435d-02,-3.1321384087455d-02,-2.9135398324845d-02,
     |  -2.6699853904575d-02,-2.4088932028186d-02,-2.1376938814312d-02,
     |  -1.8636832162289d-02,-1.5937292657385d-02,-1.3341575343842d-02,
     |  -1.0904852621000d-02,-8.6736548471529d-03,-6.6836602189802d-03,
     |  -4.9599429322969d-03,-3.5152938466879d-03,-2.3514411670110d-03,
     |  -1.4578593892599d-03,-8.1409128470786d-04,-3.8882449433969d-04,
     |  -1.4348310956029d-04,-3.1055152518165d-05,-1.3121276264430d-06/
      data (zmn(lat, 3, 3), lat = 1,72)/
     |   5.1883520324191d-09, 8.3748646752735d-07, 6.4086583414345d-06,
     |   2.4438526158759d-05, 6.6102172995198d-05, 1.4564352098710d-04,
     |   2.7979950494052d-04, 4.8716198186587d-04, 7.8742899163843d-04,
     |   1.2006166920494d-03, 1.7462230568533d-03, 2.4423964979693d-03,
     |   3.3051161219159d-03, 4.3474269185535d-03, 5.5787418644342d-03,
     |   7.0042455694691d-03, 8.6244105725962d-03, 1.0434651450865d-02,
     |   1.2425122913798d-02, 1.4580676553798d-02, 1.6880975000359d-02,
     |   1.9300767170359d-02, 2.1810314882230d-02, 2.4375963968038d-02,
     |   2.6960841967387d-02, 2.9525666409956d-02, 3.2029639087347d-02,
     |   3.4431403551358d-02, 3.6690037016870d-02, 3.8766050189800d-02,
     |   4.0622365061887d-02, 4.2225243890332d-02, 4.3545141583298d-02,
     |   4.4557457792824d-02, 4.5243166245912d-02, 4.5589303663037d-02,
     |   4.5589303663037d-02, 4.5243166245912d-02, 4.4557457792824d-02,
     |   4.3545141583298d-02, 4.2225243890332d-02, 4.0622365061887d-02,
     |   3.8766050189800d-02, 3.6690037016870d-02, 3.4431403551358d-02,
     |   3.2029639087347d-02, 2.9525666409956d-02, 2.6960841967387d-02,
     |   2.4375963968038d-02, 2.1810314882230d-02, 1.9300767170359d-02,
     |   1.6880975000359d-02, 1.4580676553798d-02, 1.2425122913798d-02,
     |   1.0434651450865d-02, 8.6244105725962d-03, 7.0042455694691d-03,
     |   5.5787418644341d-03, 4.3474269185535d-03, 3.3051161219158d-03,
     |   2.4423964979692d-03, 1.7462230568533d-03, 1.2006166920494d-03,
     |   7.8742899163840d-04, 4.8716198186585d-04, 2.7979950494052d-04,
     |   1.4564352098709d-04, 6.6102172995176d-05, 2.4438526158759d-05,
     |   6.4086583414244d-06, 8.3748646754109d-07, 5.1883520327615d-09/
      data (zmn(lat, 0, 4), lat = 1,72)/
     |   1.7566619206416d-03, 6.0700353373023d-03, 9.3894983596241d-03,
     |   1.2555327591752d-02, 1.4679768322551d-02, 1.6138771807308d-02,
     |   1.6416337433817d-02, 1.5804784645651d-02, 1.4016678727845d-02,
     |   1.1361513000340d-02, 7.7274338244627d-03, 3.4671382743226d-03,
     |  -1.3994241558470d-03,-6.4872894195814d-03,-1.1694086881893d-02,
     |  -1.6634995157161d-02,-2.1179494498324d-02,-2.4985045392478d-02,
     |  -2.7945890127484d-02,-2.9802849807420d-02,-3.0518598996582d-02,
     |  -2.9947936541824d-02,-2.8149342132216d-02,-2.5104886018011d-02,
     |  -2.0975433266760d-02,-1.5862991860391d-02,-1.0015711827555d-02,
     |  -3.6283252046827d-03, 2.9975161904275d-03, 9.6168525291461d-03,
     |   1.5920605008530d-02, 2.1663807754074d-02, 2.6579688737209d-02,
     |   3.0472134915077d-02, 3.3160784929524d-02, 3.4536961874728d-02,
     |   3.4536961874728d-02, 3.3160784929524d-02, 3.0472134915077d-02,
     |   2.6579688737209d-02, 2.1663807754074d-02, 1.5920605008530d-02,
     |   9.6168525291462d-03, 2.9975161904276d-03,-3.6283252046827d-03,
     |  -1.0015711827555d-02,-1.5862991860391d-02,-2.0975433266760d-02,
     |  -2.5104886018011d-02,-2.8149342132216d-02,-2.9947936541824d-02,
     |  -3.0518598996582d-02,-2.9802849807420d-02,-2.7945890127484d-02,
     |  -2.4985045392478d-02,-2.1179494498324d-02,-1.6634995157161d-02,
     |  -1.1694086881893d-02,-6.4872894195814d-03,-1.3994241558471d-03,
     |   3.4671382743226d-03, 7.7274338244627d-03, 1.1361513000340d-02,
     |   1.4016678727845d-02, 1.5804784645651d-02, 1.6416337433817d-02,
     |   1.6138771807308d-02, 1.4679768322551d-02, 1.2555327591752d-02,
     |   9.3894983596241d-03, 6.0700353373023d-03, 1.7566619206415d-03/
      data (zmn(lat, 1, 4), lat = 1,72)/
     |   1.1204225655636d-04, 8.7186463860082d-04, 2.3905490783151d-03,
     |   4.5403296004802d-03, 7.2128208781185d-03, 1.0233544955766d-02,
     |   1.3428177413470d-02, 1.6587488662586d-02, 1.9515224718311d-02,
     |   2.2005069519671d-02, 2.3882089226467d-02, 2.4983040088239d-02,
     |   2.5192983407557d-02, 2.4424907934800d-02, 2.2651222671149d-02,
     |   1.9880421145505d-02, 1.6183089441493d-02, 1.1664576154010d-02,
     |   6.4857097149472d-03, 8.3153209817927d-04,-5.0723344099700d-03,
     |  -1.0993892416124d-02,-1.6681135168233d-02,-2.1897511256059d-02,
     |  -2.6408971951842d-02,-3.0018686622686d-02,-3.2552638145702d-02,
     |  -3.3891649956887d-02,-3.3953692404113d-02,-3.2721730482185d-02,
     |  -3.0221531764266d-02,-2.6544582689387d-02,-2.1821035452214d-02,
     |  -1.6237830015958d-02,-1.0007327955066d-02,-3.3816498035720d-03,
     |   3.3816498035720d-03, 1.0007327955066d-02, 1.6237830015958d-02,
     |   2.1821035452214d-02, 2.6544582689387d-02, 3.0221531764266d-02,
     |   3.2721730482185d-02, 3.3953692404113d-02, 3.3891649956887d-02,
     |   3.2552638145702d-02, 3.0018686622686d-02, 2.6408971951842d-02,
     |   2.1897511256059d-02, 1.6681135168233d-02, 1.0993892416124d-02,
     |   5.0723344099701d-03,-8.3153209817927d-04,-6.4857097149472d-03,
     |  -1.1664576154010d-02,-1.6183089441493d-02,-1.9880421145505d-02,
     |  -2.2651222671149d-02,-2.4424907934800d-02,-2.5192983407557d-02,
     |  -2.4983040088239d-02,-2.3882089226467d-02,-2.2005069519671d-02,
     |  -1.9515224718311d-02,-1.6587488662586d-02,-1.3428177413470d-02,
     |  -1.0233544955766d-02,-7.2128208781186d-03,-4.5403296004802d-03,
     |  -2.3905490783151d-03,-8.7186463860085d-04,-1.1204225655635d-04/
      data (zmn(lat, 2, 4), lat = 1,72)/
     |   2.5762635042701d-06, 6.0816605034867d-05, 2.7956094054556d-04,
     |   7.5176780774526d-04, 1.5577824949982d-03, 2.7533705415600d-03,
     |   4.3708669835126d-03, 6.4119571901423d-03, 8.8499896080912d-03,
     |   1.1627090585944d-02, 1.4658730584761d-02, 1.7834690948154d-02,
     |   2.1025943144375d-02, 2.4088633943863d-02, 2.6872599683960d-02,
     |   2.9227142786764d-02, 3.1010014961961d-02, 3.2093511110734d-02,
     |   3.2372542271271d-02, 3.1769563194605d-02, 3.0240432514976d-02,
     |   2.7776939538347d-02, 2.4409490661506d-02, 2.0206473056483d-02,
     |   1.5273343993171d-02, 9.7486818559986d-03, 3.7998856452628d-03,
     |  -2.3835938937229d-03,-8.5971332730237d-03,-1.4629478403113d-02,
     |  -2.0270927645049d-02,-2.5322237900538d-02,-2.9602603040000d-02,
     |  -3.2957410735687d-02,-3.5264547649234d-02,-3.6439668626925d-02,
     |  -3.6439668626925d-02,-3.5264547649234d-02,-3.2957410735687d-02,
     |  -2.9602603040000d-02,-2.5322237900538d-02,-2.0270927645049d-02,
     |  -1.4629478403113d-02,-8.5971332730238d-03,-2.3835938937229d-03,
     |   3.7998856452628d-03, 9.7486818559985d-03, 1.5273343993170d-02,
     |   2.0206473056483d-02, 2.4409490661506d-02, 2.7776939538347d-02,
     |   3.0240432514976d-02, 3.1769563194605d-02, 3.2372542271271d-02,
     |   3.2093511110734d-02, 3.1010014961961d-02, 2.9227142786764d-02,
     |   2.6872599683960d-02, 2.4088633943863d-02, 2.1025943144375d-02,
     |   1.7834690948154d-02, 1.4658730584761d-02, 1.1627090585944d-02,
     |   8.8499896080912d-03, 6.4119571901423d-03, 4.3708669835126d-03,
     |   2.7533705415600d-03, 1.5577824949982d-03, 7.5176780774527d-04,
     |   2.7956094054557d-04, 6.0816605034886d-05, 2.5762635042979d-06/
      data (zmn(lat, 3, 4), lat = 1,72)/
     |   1.4397433298526d-08, 2.5082439528959d-06, 1.9110538412642d-05,
     |   7.2463459802341d-05, 1.9449495091026d-04, 4.2441020131018d-04,
     |   8.0586325800738d-04, 1.3839262396386d-03, 2.2016688862064d-03,
     |   3.2968158846844d-03, 4.6984184170641d-03, 6.4239442373666d-03,
     |   8.4767478558164d-03, 1.0844261287369d-02, 1.3496837661603d-02,
     |   1.6387508470122d-02, 1.9452524389642d-02, 2.2612849658198d-02,
     |   2.5776402979854d-02, 2.8841125365141d-02, 3.1698594294312d-02,
     |   3.4238190709876d-02, 3.6351484000136d-02, 3.7936795909426d-02,
     |   3.8903585396851d-02, 3.9176606136826d-02, 3.8699492195479d-02,
     |   3.7437752239445d-02, 3.5380876478049d-02, 3.2543597971382d-02,
     |   2.8966088100484d-02, 2.4713210447242d-02, 1.9872702005393d-02,
     |   1.4552494707678d-02, 8.8771327823680d-03, 2.9835774185633d-03,
     |  -2.9835774185633d-03,-8.8771327823680d-03,-1.4552494707678d-02,
     |  -1.9872702005393d-02,-2.4713210447242d-02,-2.8966088100484d-02,
     |  -3.2543597971382d-02,-3.5380876478049d-02,-3.7437752239445d-02,
     |  -3.8699492195479d-02,-3.9176606136826d-02,-3.8903585396851d-02,
     |  -3.7936795909426d-02,-3.6351484000135d-02,-3.4238190709876d-02,
     |  -3.1698594294312d-02,-2.8841125365141d-02,-2.5776402979854d-02,
     |  -2.2612849658198d-02,-1.9452524389642d-02,-1.6387508470122d-02,
     |  -1.3496837661603d-02,-1.0844261287369d-02,-8.4767478558164d-03,
     |  -6.4239442373666d-03,-4.6984184170641d-03,-3.2968158846844d-03,
     |  -2.2016688862064d-03,-1.3839262396386d-03,-8.0586325800736d-04,
     |  -4.2441020131016d-04,-1.9449495091025d-04,-7.2463459802332d-05,
     |  -1.9110538412639d-05,-2.5082439528829d-06,-1.4397433294626d-08/
      data (zmn(lat, 4, 4), lat = 1,72)/
     |   1.2004901386996d-10, 5.8096850196136d-08, 7.4001263759484d-07,
     |   3.9431859356155d-06, 1.3678161373951d-05, 3.6717308299494d-05,
     |   8.3045469592079d-05, 1.6609205052192d-04, 3.0270628136767d-04,
     |   5.1287628478894d-04, 8.1918466474384d-04, 1.2460267487464d-03,
     |   1.8186141451168d-03, 2.5618135588979d-03, 3.4988674744085d-03,
     |   4.6500632827144d-03, 6.0314112062439d-03, 7.6534031734598d-03,
     |   9.5199140241906d-03, 1.1627310059230d-02, 1.3963814390417d-02,
     |   1.6509175088776d-02, 1.9234662863324d-02, 2.2103416531096d-02,
     |   2.5071133672568d-02, 2.8087093155408d-02, 3.1095476428087d-02,
     |   3.4036944540189d-02, 3.6850411876901d-02, 3.9474951128368d-02,
     |   4.1851754087669d-02, 4.3926071815752d-02, 4.5649055122107d-02,
     |   4.6979421474051d-02, 4.7884879294639d-02, 4.8343251531442d-02,
     |   4.8343251531442d-02, 4.7884879294639d-02, 4.6979421474051d-02,
     |   4.5649055122107d-02, 4.3926071815752d-02, 4.1851754087669d-02,
     |   3.9474951128368d-02, 3.6850411876901d-02, 3.4036944540189d-02,
     |   3.1095476428086d-02, 2.8087093155408d-02, 2.5071133672568d-02,
     |   2.2103416531096d-02, 1.9234662863324d-02, 1.6509175088776d-02,
     |   1.3963814390417d-02, 1.1627310059230d-02, 9.5199140241906d-03,
     |   7.6534031734598d-03, 6.0314112062439d-03, 4.6500632827144d-03,
     |   3.4988674744085d-03, 2.5618135588979d-03, 1.8186141451168d-03,
     |   1.2460267487464d-03, 8.1918466474383d-04, 5.1287628478894d-04,
     |   3.0270628136767d-04, 1.6609205052192d-04, 8.3045469592087d-05,
     |   3.6717308299485d-05, 1.3678161373935d-05, 3.9431859356032d-06,
     |   7.4001263757972d-07, 5.8096850189220d-08, 1.2004899710870d-10/
      data (zmn(lat, 0, 5), lat = 1,72)/
     |   1.9389233247244d-03, 6.6407038480091d-03, 1.0060139427723d-02,
     |   1.3037733039422d-02, 1.4523499002887d-02, 1.4928413163682d-02,
     |   1.3704941835296d-02, 1.1277105410440d-02, 7.4440577909210d-03,
     |   2.7382493210545d-03,-2.7880517747194d-03,-8.5160002120103d-03,
     |  -1.4252260797605d-02,-1.9374770064281d-02,-2.3677246867420d-02,
     |  -2.6639714920979d-02,-2.8163088116574d-02,-2.7920964607427d-02,
     |  -2.6005853011671d-02,-2.2333533974817d-02,-1.7216072819910d-02,
     |  -1.0800957852197d-02,-3.5845407364301d-03, 4.1231859729834d-03,
     |   1.1730527056827d-02, 1.8876321670537d-02, 2.4992422454123d-02,
     |   2.9791635902468d-02, 3.2846430756492d-02, 3.4050038994359d-02,
     |   3.3199327100603d-02, 3.0427808602022d-02, 2.5784428729305d-02,
     |   1.9640361424803d-02, 1.2260129284750d-02, 4.1879429070453d-03,
     |  -4.1879429070453d-03,-1.2260129284750d-02,-1.9640361424803d-02,
     |  -2.5784428729305d-02,-3.0427808602022d-02,-3.3199327100603d-02,
     |  -3.4050038994359d-02,-3.2846430756492d-02,-2.9791635902468d-02,
     |  -2.4992422454123d-02,-1.8876321670537d-02,-1.1730527056827d-02,
     |  -4.1231859729834d-03, 3.5845407364301d-03, 1.0800957852197d-02,
     |   1.7216072819910d-02, 2.2333533974817d-02, 2.6005853011671d-02,
     |   2.7920964607427d-02, 2.8163088116574d-02, 2.6639714920979d-02,
     |   2.3677246867420d-02, 1.9374770064281d-02, 1.4252260797605d-02,
     |   8.5160002120103d-03, 2.7880517747195d-03,-2.7382493210544d-03,
     |  -7.4440577909211d-03,-1.1277105410440d-02,-1.3704941835296d-02,
     |  -1.4928413163682d-02,-1.4523499002887d-02,-1.3037733039422d-02,
     |  -1.0060139427723d-02,-6.6407038480091d-03,-1.9389233247244d-03/
      data (zmn(lat, 1, 5), lat = 1,72)/
     |   1.5068459997130d-04, 1.1751041289857d-03, 3.1875148676578d-03,
     |   5.9675141860488d-03, 9.2866669571815d-03, 1.2833521814988d-02,
     |   1.6283551971539d-02, 1.9295210802110d-02, 2.1555247334903d-02,
     |   2.2789149734383d-02, 2.2793517289130d-02, 2.1444941172005d-02,
     |   1.8718171459801d-02, 1.4685528663367d-02, 9.5192813952966d-03,
     |   3.4786985676244d-03,-3.1022460176244d-03,-9.8386333031709d-03,
     |  -1.6317190369787d-02,-2.2125770666558d-02,-2.6879411919544d-02,
     |  -3.0248472946255d-02,-3.1980529957852d-02,-3.1920134627095d-02,
     |  -3.0020079530777d-02,-2.6347728477020d-02,-2.1082038872940d-02,
     |  -1.4504815289452d-02,-6.9836986160340d-03, 1.0494063245869d-03,
     |   9.1253811630520d-03, 1.6766687691661d-02, 2.3517720480324d-02,
     |   2.8973310865193d-02, 3.2804671761946d-02, 3.4780158927163d-02,
     |   3.4780158927163d-02, 3.2804671761946d-02, 2.8973310865193d-02,
     |   2.3517720480324d-02, 1.6766687691661d-02, 9.1253811630520d-03,
     |   1.0494063245870d-03,-6.9836986160340d-03,-1.4504815289452d-02,
     |  -2.1082038872940d-02,-2.6347728477020d-02,-3.0020079530777d-02,
     |  -3.1920134627095d-02,-3.1980529957852d-02,-3.0248472946255d-02,
     |  -2.6879411919544d-02,-2.2125770666558d-02,-1.6317190369787d-02,
     |  -9.8386333031709d-03,-3.1022460176245d-03, 3.4786985676244d-03,
     |   9.5192813952966d-03, 1.4685528663367d-02, 1.8718171459801d-02,
     |   2.1444941172005d-02, 2.2793517289130d-02, 2.2789149734383d-02,
     |   2.1555247334903d-02, 1.9295210802110d-02, 1.6283551971539d-02,
     |   1.2833521814988d-02, 9.2866669571815d-03, 5.9675141860489d-03,
     |   3.1875148676579d-03, 1.1751041289857d-03, 1.5068459997129d-04/
      data (zmn(lat, 2, 5), lat = 1,72)/
     |   4.3504627812150d-06, 1.0233221577002d-04, 4.6742810726989d-04,
     |   1.2448084203583d-03, 2.5459048818580d-03, 4.4254121036656d-03,
     |   6.8828455734631d-03, 9.8519289466200d-03, 1.3208904504376d-02,
     |   1.6773720253612d-02, 2.0326147964782d-02, 2.3616296818943d-02,
     |   2.6386226750468d-02, 2.8385377180431d-02, 2.9393172131609d-02,
     |   2.9233831983351d-02, 2.7794729423370d-02, 2.5035278071763d-02,
     |   2.0996608720573d-02, 1.5800839126389d-02, 9.6497475382178d-03,
     |   2.8133407217956d-03,-4.3819706459155d-03,-1.1573648642731d-02,
     |  -1.8382064799187d-02,-2.4435275486127d-02,-2.9390005691643d-02,
     |  -3.2955208616991d-02,-3.4909101089155d-02,-3.5115922687182d-02,
     |  -3.3534034720772d-02,-3.0221905317915d-02,-2.5334509341095d-02,
     |  -1.9117247720889d-02,-1.1890857070760d-02,-4.0350272094389d-03,
     |   4.0350272094388d-03, 1.1890857070760d-02, 1.9117247720889d-02,
     |   2.5334509341095d-02, 3.0221905317915d-02, 3.3534034720772d-02,
     |   3.5115922687182d-02, 3.4909101089155d-02, 3.2955208616991d-02,
     |   2.9390005691643d-02, 2.4435275486127d-02, 1.8382064799187d-02,
     |   1.1573648642731d-02, 4.3819706459155d-03,-2.8133407217956d-03,
     |  -9.6497475382177d-03,-1.5800839126389d-02,-2.0996608720573d-02,
     |  -2.5035278071763d-02,-2.7794729423370d-02,-2.9233831983351d-02,
     |  -2.9393172131609d-02,-2.8385377180431d-02,-2.6386226750468d-02,
     |  -2.3616296818943d-02,-2.0326147964782d-02,-1.6773720253613d-02,
     |  -1.3208904504376d-02,-9.8519289466201d-03,-6.8828455734631d-03,
     |  -4.4254121036656d-03,-2.5459048818580d-03,-1.2448084203583d-03,
     |  -4.6742810726989d-04,-1.0233221577001d-04,-4.3504627812063d-06/
      data (zmn(lat, 3, 5), lat = 1,72)/
     |   3.4209252682500d-08, 5.5287109874895d-06, 4.1943233388006d-05,
     |   1.5788670476136d-04, 4.1969762770671d-04, 9.0468880968826d-04,
     |   1.6924822041221d-03, 2.8558455164854d-03, 4.4513186074320d-03,
     |   6.5107173677185d-03, 9.0340133855086d-03, 1.1984401474146d-02,
     |   1.5285912205991d-02, 1.8823994486363d-02, 2.2449086059399d-02,
     |   2.5983137255814d-02, 2.9228699924880d-02, 3.1980114431753d-02,
     |   3.4036063366465d-02, 3.5212727476096d-02, 3.5356637836594d-02,
     |   3.4356375947326d-02, 3.2152268014751d-02, 2.8743379491255d-02,
     |   2.4191231165492d-02, 1.8619897722140d-02, 1.2212342616066d-02,
     |   5.2031140920333d-03,-2.1322629831570d-03,-9.4906232462147d-03,
     |  -1.6556485479605d-02,-2.3018470510262d-02,-2.8585850533652d-02,
     |  -3.3004234337886d-02,-3.6069446495964d-02,-3.7638753363244d-02,
     |  -3.7638753363244d-02,-3.6069446495964d-02,-3.3004234337886d-02,
     |  -2.8585850533652d-02,-2.3018470510262d-02,-1.6556485479605d-02,
     |  -9.4906232462148d-03,-2.1322629831571d-03, 5.2031140920333d-03,
     |   1.2212342616066d-02, 1.8619897722139d-02, 2.4191231165492d-02,
     |   2.8743379491255d-02, 3.2152268014751d-02, 3.4356375947326d-02,
     |   3.5356637836594d-02, 3.5212727476096d-02, 3.4036063366465d-02,
     |   3.1980114431753d-02, 2.9228699924880d-02, 2.5983137255814d-02,
     |   2.2449086059399d-02, 1.8823994486363d-02, 1.5285912205991d-02,
     |   1.1984401474146d-02, 9.0340133855086d-03, 6.5107173677184d-03,
     |   4.4513186074320d-03, 2.8558455164854d-03, 1.6924822041221d-03,
     |   9.0468880968823d-04, 4.1969762770671d-04, 1.5788670476132d-04,
     |   4.1943233387987d-05, 5.5287109874724d-06, 3.4209252697870d-08/
      data (zmn(lat, 4, 5), lat = 1,72)/
     |   3.9612950848040d-10, 1.9227869563991d-07, 2.4397468186871d-06,
     |   1.2925872748830d-05, 4.4493629731577d-05, 1.1828766391142d-04,
     |   2.6442714327574d-04, 5.2163070586402d-04, 9.3570153065484d-04,
     |   1.5569615208170d-03, 2.4367387744588d-03, 3.6231638425934d-03,
     |   5.1565383357269d-03, 7.0646434363414d-03, 9.3583303936196d-03,
     |   1.2027780319155d-02, 1.5039749263368d-02, 1.8336101634389d-02,
     |   2.1833821303040d-02, 2.5426632816256d-02, 2.8988226561040d-02,
     |   3.2377005753255d-02, 3.5442136088701d-02, 3.8030613571830d-02,
     |   3.9994958445235d-02, 4.1201115285153d-02, 4.1536082809992d-02,
     |   4.0914823455474d-02, 3.9286006571982d-02, 3.6636222409129d-02,
     |   3.2992362206862d-02, 2.8421987018920d-02, 2.3031600435664d-02,
     |   1.6962886859060d-02, 1.0387074908902d-02, 3.4977207990202d-03,
     |  -3.4977207990202d-03,-1.0387074908902d-02,-1.6962886859060d-02,
     |  -2.3031600435664d-02,-2.8421987018920d-02,-3.2992362206862d-02,
     |  -3.6636222409129d-02,-3.9286006571982d-02,-4.0914823455474d-02,
     |  -4.1536082809992d-02,-4.1201115285154d-02,-3.9994958445235d-02,
     |  -3.8030613571830d-02,-3.5442136088701d-02,-3.2377005753255d-02,
     |  -2.8988226561040d-02,-2.5426632816256d-02,-2.1833821303040d-02,
     |  -1.8336101634389d-02,-1.5039749263368d-02,-1.2027780319155d-02,
     |  -9.3583303936196d-03,-7.0646434363414d-03,-5.1565383357269d-03,
     |  -3.6231638425934d-03,-2.4367387744587d-03,-1.5569615208170d-03,
     |  -9.3570153065488d-04,-5.2163070586405d-04,-2.6442714327577d-04,
     |  -1.1828766391144d-04,-4.4493629731623d-05,-1.2925872748837d-05,
     |  -2.4397468187078d-06,-1.9227869566567d-07,-3.9612954009876d-10/
      data (zmn(lat, 5, 5), lat = 1,72)/
     |   3.0765508048858d-11, 3.9572100648463d-09, 8.4522902694831d-08,
     |   6.2910112406096d-07, 2.7987496782304d-06, 9.1531228701986d-06,
     |   2.4372804755594d-05, 5.5994346511233d-05, 1.1506722648268d-04,
     |   2.1664111825401d-04, 3.8000036967292d-04, 6.2857720402764d-04,
     |   9.8949703835773d-04, 1.4927353728455d-03, 2.1698954325513d-03,
     |   3.0526459745585d-03, 4.1708880903458d-03, 5.5507455205956d-03,
     |   7.2124936091114d-03, 9.1685553658989d-03, 1.1421698457217d-02,
     |   1.3963563233230d-02, 1.6773639436905d-02, 1.9818788250467d-02,
     |   2.3053378231551d-02, 2.6420069871947d-02, 2.9851246241971d-02,
     |   3.3271048603190d-02, 3.6597938600549d-02, 3.9747674950928d-02,
     |   4.2636564775287d-02, 4.5184829634165d-02, 4.7319915416582d-02,
     |   4.8979574244586d-02, 5.0114555760298d-02, 5.0690764054379d-02,
     |   5.0690764054379d-02, 5.0114555760298d-02, 4.8979574244586d-02,
     |   4.7319915416582d-02, 4.5184829634165d-02, 4.2636564775287d-02,
     |   3.9747674950928d-02, 3.6597938600549d-02, 3.3271048603190d-02,
     |   2.9851246241971d-02, 2.6420069871947d-02, 2.3053378231551d-02,
     |   1.9818788250467d-02, 1.6773639436905d-02, 1.3963563233230d-02,
     |   1.1421698457217d-02, 9.1685553658989d-03, 7.2124936091114d-03,
     |   5.5507455205956d-03, 4.1708880903458d-03, 3.0526459745585d-03,
     |   2.1698954325513d-03, 1.4927353728455d-03, 9.8949703835772d-04,
     |   6.2857720402765d-04, 3.8000036967294d-04, 2.1664111825403d-04,
     |   1.1506722648270d-04, 5.5994346511259d-05, 2.4372804755607d-05,
     |   9.1531228702151d-06, 2.7987496782280d-06, 6.2910112407599d-07,
     |   8.4522902691527d-08, 3.9572100632147d-09, 3.0765496116945d-11/
      data (zmn(lat, 0, 6), lat = 1,72)/
     |   2.1040681035121d-03, 7.1274782928692d-03, 1.0527145729450d-02,
     |   1.3107656904098d-02, 1.3687371235631d-02, 1.2736659335999d-02,
     |   9.7816728492695d-03, 5.4538194654136d-03,-2.1071579979714d-04,
     |  -6.3837661573411d-03,-1.2723009939277d-02,-1.8352956172770d-02,
     |  -2.2882510294667d-02,-2.5609705498780d-02,-2.6343825623743d-02,
     |  -2.4746625493385d-02,-2.0988809025201d-02,-1.5174317182380d-02,
     |  -7.8526882919369d-03, 5.0020082659371d-04, 9.0887344787071d-03,
     |   1.7265125134275d-02, 2.4223674448946d-02, 2.9406715485425d-02,
     |   3.2253030794223d-02, 3.2526941431498d-02, 3.0092365210435d-02,
     |   2.5154050185440d-02, 1.8040691708755d-02, 9.3584125080550d-03,
     |  -2.1802570277648d-04,-9.8661670705020d-03,-1.8803132401036d-02,
     |  -2.6257628421214d-02,-3.1613796024593d-02,-3.4408135154038d-02,
     |  -3.4408135154038d-02,-3.1613796024593d-02,-2.6257628421214d-02,
     |  -1.8803132401036d-02,-9.8661670705020d-03,-2.1802570277643d-04,
     |   9.3584125080550d-03, 1.8040691708755d-02, 2.5154050185440d-02,
     |   3.0092365210435d-02, 3.2526941431498d-02, 3.2253030794223d-02,
     |   2.9406715485425d-02, 2.4223674448946d-02, 1.7265125134275d-02,
     |   9.0887344787072d-03, 5.0020082659375d-04,-7.8526882919369d-03,
     |  -1.5174317182380d-02,-2.0988809025201d-02,-2.4746625493385d-02,
     |  -2.6343825623743d-02,-2.5609705498780d-02,-2.2882510294667d-02,
     |  -1.8352956172770d-02,-1.2723009939277d-02,-6.3837661573412d-03,
     |  -2.1071579979720d-04, 5.4538194654136d-03, 9.7816728492695d-03,
     |   1.2736659335999d-02, 1.3687371235631d-02, 1.3107656904098d-02,
     |   1.0527145729450d-02, 7.1274782928693d-03, 2.1040681035121d-03/
      data (zmn(lat, 1, 6), lat = 1,72)/
     |   1.9503475346682d-04, 1.5004333749684d-03, 4.0275720993227d-03,
     |   7.4011488835823d-03, 1.1234235954096d-02, 1.5010455544407d-02,
     |   1.8237213992855d-02, 2.0421538415041d-02, 2.1187492055330d-02,
     |   2.0260887264916d-02, 1.7555449257818d-02, 1.3137635792026d-02,
     |   7.2751684864397d-03, 3.7105559713472d-04,-7.0238914468065d-03,
     |  -1.4303766359873d-02,-2.0818308118289d-02,-2.5976566785775d-02,
     |  -2.9260326955362d-02,-3.0317619630287d-02,-2.8957366459538d-02,
     |  -2.5214290597048d-02,-1.9310028753767d-02,-1.1680631753067d-02,
     |  -2.9014684392310d-03, 6.3183702268561d-03, 1.5236866000314d-02,
     |   2.3101592847150d-02, 2.9256133627893d-02, 3.3157074218837d-02,
     |   3.4463489453942d-02, 3.3027602599390d-02, 2.8950357765563d-02,
     |   2.2533988466721d-02, 1.4298381931059d-02, 4.8970971001266d-03,
     |  -4.8970971001266d-03,-1.4298381931059d-02,-2.2533988466721d-02,
     |  -2.8950357765563d-02,-3.3027602599390d-02,-3.4463489453942d-02,
     |  -3.3157074218837d-02,-2.9256133627893d-02,-2.3101592847150d-02,
     |  -1.5236866000314d-02,-6.3183702268562d-03, 2.9014684392309d-03,
     |   1.1680631753067d-02, 1.9310028753767d-02, 2.5214290597048d-02,
     |   2.8957366459538d-02, 3.0317619630287d-02, 2.9260326955362d-02,
     |   2.5976566785775d-02, 2.0818308118289d-02, 1.4303766359873d-02,
     |   7.0238914468065d-03,-3.7105559713472d-04,-7.2751684864396d-03,
     |  -1.3137635792026d-02,-1.7555449257818d-02,-2.0260887264916d-02,
     |  -2.1187492055330d-02,-2.0421538415041d-02,-1.8237213992855d-02,
     |  -1.5010455544407d-02,-1.1234235954096d-02,-7.4011488835824d-03,
     |  -4.0275720993227d-03,-1.5004333749685d-03,-1.9503475346684d-04/
      data (zmn(lat, 2, 6), lat = 1,72)/
     |   6.6861604222135d-06, 1.5664952081265d-04, 7.1005943453016d-04,
     |   1.8688976932066d-03, 3.7618103865861d-03, 6.4062575104906d-03,
     |   9.7131427134771d-03, 1.3478403559530d-02, 1.7407881676476d-02,
     |   2.1135473382085d-02, 2.4265203308548d-02, 2.6405212751604d-02,
     |   2.7215013814166d-02, 2.6439426036200d-02, 2.3945367938440d-02,
     |   1.9739942697237d-02, 1.3983766723820d-02, 6.9831882834506d-03,
     |  -8.2500655638358d-04,-8.9076633644585d-03,-1.6674175210438d-02,
     |  -2.3527249888545d-02,-2.8911702539335d-02,-3.2365543485807d-02,
     |  -3.3560839886100d-02,-3.2337727314714d-02,-2.8721760358963d-02,
     |  -2.2928697432640d-02,-1.5350629276972d-02,-6.5291438271447d-03,
     |   2.8866655026301d-03, 1.2190183525421d-02, 2.0674322721972d-02,
     |   2.7688058909768d-02, 3.2689909495597d-02, 3.5291953277061d-02,
     |   3.5291953277061d-02, 3.2689909495597d-02, 2.7688058909768d-02,
     |   2.0674322721972d-02, 1.2190183525421d-02, 2.8866655026301d-03,
     |  -6.5291438271447d-03,-1.5350629276972d-02,-2.2928697432640d-02,
     |  -2.8721760358963d-02,-3.2337727314714d-02,-3.3560839886100d-02,
     |  -3.2365543485807d-02,-2.8911702539335d-02,-2.3527249888545d-02,
     |  -1.6674175210438d-02,-8.9076633644585d-03,-8.2500655638358d-04,
     |   6.9831882834505d-03, 1.3983766723820d-02, 1.9739942697237d-02,
     |   2.3945367938440d-02, 2.6439426036200d-02, 2.7215013814167d-02,
     |   2.6405212751604d-02, 2.4265203308548d-02, 2.1135473382085d-02,
     |   1.7407881676476d-02, 1.3478403559530d-02, 9.7131427134771d-03,
     |   6.4062575104906d-03, 3.7618103865862d-03, 1.8688976932066d-03,
     |   7.1005943453017d-04, 1.5664952081264d-04, 6.6861604222095d-06/
      data (zmn(lat, 3, 6), lat = 1,72)/
     |   5.9426510682655d-08, 1.0381731449910d-05, 7.8266363201615d-05,
     |   2.9209042148624d-04, 7.6736999514263d-04, 1.6297038069281d-03,
     |   2.9938396962094d-03, 4.9431769156949d-03, 7.5106472238624d-03,
     |   1.0664465189689d-02, 1.4299604016534d-02, 1.8237251650082d-02,
     |   2.2231964738766d-02, 2.5987108791271d-02, 2.9176768318966d-02,
     |   3.1473103663823d-02, 3.2576072680456d-02, 3.2243498865240d-02,
     |   3.0317940622692d-02, 2.6748340503058d-02, 2.1603479903885d-02,
     |   1.5076237880825d-02, 7.4771320117677d-03,-7.8215817167023d-04,
     |  -9.2149593835087d-03,-1.7292977726479d-02,-2.4484955825262d-02,
     |  -3.0296901357173d-02,-3.4311201075871d-02,-3.6220702123562d-02,
     |  -3.5855436715679d-02,-3.3198993625561d-02,-2.8393605616946d-02,
     |  -2.1732714871691d-02,-1.3642048828950d-02,-4.6499739916328d-03,
     |   4.6499739916327d-03, 1.3642048828950d-02, 2.1732714871691d-02,
     |   2.8393605616946d-02, 3.3198993625561d-02, 3.5855436715679d-02,
     |   3.6220702123562d-02, 3.4311201075871d-02, 3.0296901357173d-02,
     |   2.4484955825262d-02, 1.7292977726479d-02, 9.2149593835087d-03,
     |   7.8215817167026d-04,-7.4771320117677d-03,-1.5076237880825d-02,
     |  -2.1603479903885d-02,-2.6748340503058d-02,-3.0317940622692d-02,
     |  -3.2243498865240d-02,-3.2576072680456d-02,-3.1473103663823d-02,
     |  -2.9176768318966d-02,-2.5987108791271d-02,-2.2231964738766d-02,
     |  -1.8237251650082d-02,-1.4299604016533d-02,-1.0664465189689d-02,
     |  -7.5106472238624d-03,-4.9431769156948d-03,-2.9938396962093d-03,
     |  -1.6297038069281d-03,-7.6736999514262d-04,-2.9209042148626d-04,
     |  -7.8266363201619d-05,-1.0381731449933d-05,-5.9426510661825d-08/
      data (zmn(lat, 4, 6), lat = 1,72)/
     |   9.6219106397499d-10, 4.6620331042660d-07, 5.8883648134344d-06,
     |   3.0981756036845d-05, 1.0565993769560d-04, 2.7762830516590d-04,
     |   6.1186380523474d-04, 1.1868833183042d-03, 2.0878504886034d-03,
     |   3.3971624805990d-03, 5.1833182416736d-03, 7.4892841804163d-03,
     |   1.0321582613459d-02, 1.3641469898533d-02, 1.7359344656856d-02,
     |   2.1333381703662d-02, 2.5372944641815d-02, 2.9246982077089d-02,
     |   3.2697068768733d-02, 3.5454357817612d-02, 3.7259232657482d-02,
     |   3.7882180646435d-02, 3.7144156009759d-02, 3.4934693127177d-02,
     |   3.1226087485840d-02, 2.6082254386359d-02, 1.9661224197421d-02,
     |   1.2210754954817d-02, 4.0570634735448d-03,-4.4127303871902d-03,
     |  -1.2773343429827d-02,-2.0587676246911d-02,-2.7434878796796d-02,
     |  -3.2938049394656d-02,-3.6789484552370d-02,-3.8771546805187d-02,
     |  -3.8771546805187d-02,-3.6789484552370d-02,-3.2938049394656d-02,
     |  -2.7434878796796d-02,-2.0587676246911d-02,-1.2773343429827d-02,
     |  -4.4127303871903d-03, 4.0570634735447d-03, 1.2210754954817d-02,
     |   1.9661224197421d-02, 2.6082254386359d-02, 3.1226087485840d-02,
     |   3.4934693127177d-02, 3.7144156009758d-02, 3.7882180646435d-02,
     |   3.7259232657482d-02, 3.5454357817612d-02, 3.2697068768733d-02,
     |   2.9246982077089d-02, 2.5372944641815d-02, 2.1333381703662d-02,
     |   1.7359344656856d-02, 1.3641469898533d-02, 1.0321582613459d-02,
     |   7.4892841804163d-03, 5.1833182416736d-03, 3.3971624805990d-03,
     |   2.0878504886034d-03, 1.1868833183042d-03, 6.1186380523474d-04,
     |   2.7762830516592d-04, 1.0565993769559d-04, 3.0981756036866d-05,
     |   5.8883648134352d-06, 4.6620331043430d-07, 9.6219106464124d-10/
      data (zmn(lat, 5, 6), lat = 1,72)/
     |   1.2022765544039d-10, 1.4228047620553d-08, 3.0294964623938d-07,
     |   2.2418479548668d-06, 9.8971483824357d-06, 3.2056273956700d-05,
     |   8.4366691783316d-05, 1.9117617612797d-04, 3.8667216595615d-04,
     |   7.1495954445151d-04, 1.2288150544679d-03, 1.9869848756574d-03,
     |   3.0500539658407d-03, 4.4750808007258d-03, 6.3093558570945d-03,
     |   8.5837763950619d-03, 1.1306430835210d-02, 1.4457029405585d-02,
     |   1.7982807765255d-02, 2.1796453830628d-02, 2.5776479647268d-02,
     |   2.9770278499790d-02, 3.3599897157243d-02, 3.7070321665170d-02,
     |   3.9979852515182d-02, 4.2131941456269d-02, 4.3347706370082d-02,
     |   4.3478238035087d-02, 4.2415783868837d-02, 4.0102934034079d-02,
     |   3.6539053044824d-02, 3.1783377835355d-02, 2.5954437438328d-02,
     |   1.9225712243432d-02, 1.1817730700633d-02, 3.9870661488801d-03,
     |  -3.9870661488801d-03,-1.1817730700633d-02,-1.9225712243432d-02,
     |  -2.5954437438328d-02,-3.1783377835355d-02,-3.6539053044824d-02,
     |  -4.0102934034079d-02,-4.2415783868837d-02,-4.3478238035087d-02,
     |  -4.3347706370082d-02,-4.2131941456269d-02,-3.9979852515182d-02,
     |  -3.7070321665170d-02,-3.3599897157243d-02,-2.9770278499790d-02,
     |  -2.5776479647268d-02,-2.1796453830628d-02,-1.7982807765255d-02,
     |  -1.4457029405585d-02,-1.1306430835210d-02,-8.5837763950619d-03,
     |  -6.3093558570945d-03,-4.4750808007258d-03,-3.0500539658407d-03,
     |  -1.9869848756574d-03,-1.2288150544679d-03,-7.1495954445152d-04,
     |  -3.8667216595614d-04,-1.9117617612797d-04,-8.4366691783299d-05,
     |  -3.2056273956696d-05,-9.8971483824449d-06,-2.2418479548629d-06,
     |  -3.0294964624765d-07,-1.4228047621443d-08,-1.2022766255880d-10/
      data (zmn(lat, 6, 6), lat = 1,72)/
     |   6.9854706978414d-13, 2.6938206331952d-10, 9.5774790749360d-09,
     |   9.9608751861490d-08, 5.6830416032585d-07, 2.2644031517492d-06,
     |   7.0987078805786d-06, 1.8733737504255d-05, 4.3407669467738d-05,
     |   9.0814233465237d-05, 1.7493266257010d-04, 3.1468396651017d-04,
     |   5.3428518588702d-04, 8.6318293527344d-04, 1.3354721148010d-03,
     |   1.9887433100096d-03, 2.8623507091780d-03, 3.9951469136911d-03,
     |   5.4227872446780d-03, 7.1747584016866d-03, 9.2713296461616d-03,
     |   1.1720654111719d-02, 1.4516259995606d-02, 1.7635163810004d-02,
     |   2.1036810230602d-02, 2.4662996413049d-02, 2.8438876093953d-02,
     |   3.2275064670190d-02, 3.6070786548937d-02, 3.9717926591958d-02,
     |   4.3105775066645d-02, 4.6126196163959d-02, 4.8678909116412d-02,
     |   5.0676551941147d-02, 5.2049202946975d-02, 5.2748064410671d-02,
     |   5.2748064410671d-02, 5.2049202946975d-02, 5.0676551941147d-02,
     |   4.8678909116412d-02, 4.6126196163959d-02, 4.3105775066645d-02,
     |   3.9717926591958d-02, 3.6070786548937d-02, 3.2275064670190d-02,
     |   2.8438876093953d-02, 2.4662996413049d-02, 2.1036810230602d-02,
     |   1.7635163810004d-02, 1.4516259995606d-02, 1.1720654111719d-02,
     |   9.2713296461617d-03, 7.1747584016866d-03, 5.4227872446780d-03,
     |   3.9951469136911d-03, 2.8623507091780d-03, 1.9887433100096d-03,
     |   1.3354721148010d-03, 8.6318293527342d-04, 5.3428518588701d-04,
     |   3.1468396651017d-04, 1.7493266257010d-04, 9.0814233465234d-05,
     |   4.3407669467747d-05, 1.8733737504254d-05, 7.0987078805817d-06,
     |   2.2644031517553d-06, 5.6830416032966d-07, 9.9608751858636d-08,
     |   9.5774790774503d-09, 2.6938206508086d-10, 6.9855029100276d-13/
      data (zmn(lat, 0, 7), lat = 1,72)/
     |   2.2550655217212d-03, 7.5430458452049d-03, 1.0803221649640d-02,
     |   1.2798400840854d-02, 1.2237816739552d-02, 9.7444080732771d-03,
     |   5.0084427274975d-03,-9.7630299287828d-04,-7.8527349499112d-03,
     |  -1.4386094273628d-02,-1.9985115194846d-02,-2.3561687819998d-02,
     |  -2.4773961537581d-02,-2.3070539320764d-02,-1.8698256485067d-02,
     |  -1.1818739144425d-02,-3.3088217485929d-03, 6.0991711467500d-03,
     |   1.5177301834376d-02, 2.3032912995830d-02, 2.8559159342611d-02,
     |   3.1199141210316d-02, 3.0412076019085d-02, 2.6329482141168d-02,
     |   1.9181845242820d-02, 9.8300263313331d-03,-8.6356444914161d-04,
     |  -1.1606547043606d-02,-2.1334658654279d-02,-2.8830987745869d-02,
     |  -3.3360290405173d-02,-3.4268713721182d-02,-3.1541787738329d-02,
     |  -2.5333712223508d-02,-1.6423750304313d-02,-5.6616244389483d-03,
     |   5.6616244389482d-03, 1.6423750304313d-02, 2.5333712223508d-02,
     |   3.1541787738329d-02, 3.4268713721182d-02, 3.3360290405173d-02,
     |   2.8830987745869d-02, 2.1334658654279d-02, 1.1606547043606d-02,
     |   8.6356444914166d-04,-9.8300263313331d-03,-1.9181845242820d-02,
     |  -2.6329482141168d-02,-3.0412076019085d-02,-3.1199141210316d-02,
     |  -2.8559159342611d-02,-2.3032912995830d-02,-1.5177301834376d-02,
     |  -6.0991711467500d-03, 3.3088217485928d-03, 1.1818739144425d-02,
     |   1.8698256485067d-02, 2.3070539320764d-02, 2.4773961537581d-02,
     |   2.3561687819998d-02, 1.9985115194846d-02, 1.4386094273628d-02,
     |   7.8527349499112d-03, 9.7630299287832d-04,-5.0084427274976d-03,
     |  -9.7444080732771d-03,-1.2237816739552d-02,-1.2798400840854d-02,
     |  -1.0803221649640d-02,-7.5430458452049d-03,-2.2550655217212d-03/
      data (zmn(lat, 1, 7), lat = 1,72)/
     |   2.4024689433098d-04, 1.8484880397220d-03, 4.8886404767538d-03,
     |   8.7958186857156d-03, 1.2945533357481d-02, 1.6592934308784d-02,
     |   1.9050146226190d-02, 1.9738580946758d-02, 1.8304905832373d-02,
     |   1.4656669458306d-02, 9.0041486207082d-03, 1.8337753788852d-03,
     |  -6.1310035589922d-03,-1.4019817655631d-02,-2.0911144710066d-02,
     |  -2.5951041419374d-02,-2.8456146985918d-02,-2.8008675348593d-02,
     |  -2.4513692018778d-02,-1.8226242812088d-02,-9.7309271160645d-03,
     |   1.1293731911441d-04, 1.0265021802207d-02, 1.9617112000154d-02,
     |   2.7120597967904d-02, 3.1906463093671d-02, 3.3389758138669d-02,
     |   3.1340570613809d-02, 2.5917544742761d-02, 1.7655315848916d-02,
     |   7.4104500491864d-03,-3.7314790397830d-03,-1.4574596230938d-02,
     |  -2.3946017327232d-02,-3.0826634970189d-02,-3.4465834201501d-02,
     |  -3.4465834201501d-02,-3.0826634970189d-02,-2.3946017327232d-02,
     |  -1.4574596230938d-02,-3.7314790397830d-03, 7.4104500491864d-03,
     |   1.7655315848916d-02, 2.5917544742761d-02, 3.1340570613809d-02,
     |   3.3389758138669d-02, 3.1906463093671d-02, 2.7120597967904d-02,
     |   1.9617112000154d-02, 1.0265021802207d-02, 1.1293731911442d-04,
     |  -9.7309271160644d-03,-1.8226242812088d-02,-2.4513692018778d-02,
     |  -2.8008675348593d-02,-2.8456146985918d-02,-2.5951041419374d-02,
     |  -2.0911144710066d-02,-1.4019817655631d-02,-6.1310035589923d-03,
     |   1.8337753788852d-03, 9.0041486207082d-03, 1.4656669458305d-02,
     |   1.8304905832373d-02, 1.9738580946758d-02, 1.9050146226190d-02,
     |   1.6592934308784d-02, 1.2945533357481d-02, 8.7958186857156d-03,
     |   4.8886404767537d-03, 1.8484880397221d-03, 2.4024689433100d-04/
      data (zmn(lat, 2, 7), lat = 1,72)/
     |   9.6347300249513d-06, 2.2461281332979d-04, 1.0090484451879d-03,
     |   2.6193135635742d-03, 5.1733650481674d-03, 8.5956299930787d-03,
     |   1.2634036251878d-02, 1.6866960767948d-02, 2.0766369640542d-02,
     |   2.3753269053262d-02, 2.5287148329062d-02, 2.4935089973864d-02,
     |   2.2449682425997d-02, 1.7810387446874d-02, 1.1253952053706d-02,
     |   3.2593931462531d-03,-5.4845400469833d-03,-1.4152392474942d-02,
     |  -2.1863503795170d-02,-2.7785823659828d-02,-3.1228124715479d-02,
     |  -3.1730432391786d-02,-2.9121512692304d-02,-2.3555164726920d-02,
     |  -1.5501502321037d-02,-5.7112165177385d-03, 4.8615664844255d-03,
     |   1.5152759150274d-02, 2.4104707764129d-02, 3.0776311012410d-02,
     |   3.4450472678178d-02, 3.4710898095928d-02, 3.1494808618976d-02,
     |   2.5099986007679d-02, 1.6160125663897d-02, 5.5759028603897d-03,
     |  -5.5759028603897d-03,-1.6160125663897d-02,-2.5099986007679d-02,
     |  -3.1494808618976d-02,-3.4710898095928d-02,-3.4450472678178d-02,
     |  -3.0776311012410d-02,-2.4104707764129d-02,-1.5152759150274d-02,
     |  -4.8615664844255d-03, 5.7112165177385d-03, 1.5501502321037d-02,
     |   2.3555164726920d-02, 2.9121512692304d-02, 3.1730432391786d-02,
     |   3.1228124715479d-02, 2.7785823659828d-02, 2.1863503795170d-02,
     |   1.4152392474942d-02, 5.4845400469833d-03,-3.2593931462531d-03,
     |  -1.1253952053707d-02,-1.7810387446874d-02,-2.2449682425997d-02,
     |  -2.4935089973864d-02,-2.5287148329062d-02,-2.3753269053262d-02,
     |  -2.0766369640542d-02,-1.6866960767948d-02,-1.2634036251878d-02,
     |  -8.5956299930786d-03,-5.1733650481674d-03,-2.6193135635742d-03,
     |  -1.0090484451879d-03,-2.2461281332984d-04,-9.6347300249678d-06/
      data (zmn(lat, 3, 7), lat = 1,72)/
     |   1.0844089802118d-07, 1.7558837747305d-05, 1.3154989342305d-04,
     |   4.8592533394554d-04, 1.2591020720209d-03, 2.6271979174509d-03,
     |   4.7223766523788d-03, 7.5951049093956d-03, 1.1184942448839d-02,
     |   1.5305970728597d-02, 1.9649415288993d-02, 2.3805064799536d-02,
     |   2.7299585114053d-02, 2.9648239581421d-02, 3.0413895746573d-02,
     |   2.9266429567790d-02, 2.6034744411005d-02, 2.0744499223051d-02,
     |   1.3635720584088d-02, 5.1569200020571d-03,-4.0652220654802d-03,
     |  -1.3278444127793d-02,-2.1675041402409d-02,-2.8472396051716d-02,
     |  -3.2995376003481d-02,-3.4751399644076d-02,-3.3489573954808d-02,
     |  -2.9236726503719d-02,-2.2305612303013d-02,-1.3273474569559d-02,
     |  -2.9324504551426d-03, 7.7836004435229d-03, 1.7888533106712d-02,
     |   2.6440441331976d-02, 3.2635147478989d-02, 3.5886770618466d-02,
     |   3.5886770618466d-02, 3.2635147478989d-02, 2.6440441331976d-02,
     |   1.7888533106712d-02, 7.7836004435230d-03,-2.9324504551426d-03,
     |  -1.3273474569559d-02,-2.2305612303013d-02,-2.9236726503719d-02,
     |  -3.3489573954808d-02,-3.4751399644076d-02,-3.2995376003481d-02,
     |  -2.8472396051716d-02,-2.1675041402409d-02,-1.3278444127793d-02,
     |  -4.0652220654804d-03, 5.1569200020571d-03, 1.3635720584088d-02,
     |   2.0744499223051d-02, 2.6034744411005d-02, 2.9266429567790d-02,
     |   3.0413895746573d-02, 2.9648239581421d-02, 2.7299585114053d-02,
     |   2.3805064799536d-02, 1.9649415288993d-02, 1.5305970728598d-02,
     |   1.1184942448840d-02, 7.5951049093957d-03, 4.7223766523788d-03,
     |   2.6271979174510d-03, 1.2591020720209d-03, 4.8592533394554d-04,
     |   1.3154989342308d-04, 1.7558837747277d-05, 1.0844089801232d-07/
      data (zmn(lat, 4, 7), lat = 1,72)/
     |   1.9667525474578d-09, 9.5608530676348d-07, 1.2010717707614d-05,
     |   6.2685143476249d-05, 2.1146068869491d-04, 5.4800147767827d-04,
     |   1.1875480079244d-03, 2.2578256763555d-03, 3.8795599490063d-03,
     |   6.1432537559025d-03, 9.0853184784313d-03, 1.2667391673088d-02,
     |   1.6762271169483d-02, 2.1149572831884d-02, 2.5522916570295d-02,
     |   2.9509302340672d-02, 3.2699574738663d-02, 3.4687559201663d-02,
     |   3.5113958656273d-02, 3.3710372787024d-02, 3.0338244190615d-02,
     |   2.5017911984648d-02, 1.7943603233816d-02, 9.4816792460825d-03,
     |   1.5103136744959d-04,-9.4134096377695d-03,-1.8511310743817d-02,
     |  -2.6437167649890d-02,-3.2544463805883d-02,-3.6307309133419d-02,
     |  -3.7373260443404d-02,-3.5601621407545d-02,-3.1082989961246d-02,
     |  -2.4137543225941d-02,-1.5291808629140d-02,-5.2357611885983d-03,
     |   5.2357611885983d-03, 1.5291808629139d-02, 2.4137543225941d-02,
     |   3.1082989961246d-02, 3.5601621407545d-02, 3.7373260443404d-02,
     |   3.6307309133419d-02, 3.2544463805883d-02, 2.6437167649890d-02,
     |   1.8511310743817d-02, 9.4134096377695d-03,-1.5103136744951d-04,
     |  -9.4816792460825d-03,-1.7943603233816d-02,-2.5017911984648d-02,
     |  -3.0338244190615d-02,-3.3710372787024d-02,-3.5113958656273d-02,
     |  -3.4687559201663d-02,-3.2699574738663d-02,-2.9509302340672d-02,
     |  -2.5522916570294d-02,-2.1149572831884d-02,-1.6762271169483d-02,
     |  -1.2667391673088d-02,-9.0853184784313d-03,-6.1432537559025d-03,
     |  -3.8795599490063d-03,-2.2578256763555d-03,-1.1875480079245d-03,
     |  -5.4800147767831d-04,-2.1146068869489d-04,-6.2685143476281d-05,
     |  -1.2010717707640d-05,-9.5608530674684d-07,-1.9667525465941d-09/
      data (zmn(lat, 5, 7), lat = 1,72)/
     |   2.9407200659744d-10, 3.7365072081084d-08, 7.9156145918598d-07,
     |   5.8185528480927d-06, 2.5456513193583d-05, 8.1519681701014d-05,
     |   2.1160636062792d-04, 4.7174886987304d-04, 9.3627667667258d-04,
     |   1.6940876128987d-03, 2.8410252154382d-03, 4.4686520943001d-03,
     |   6.6503303723723d-03, 9.4260679754353d-03, 1.2787994552898d-02,
     |   1.6668516318769d-02, 2.0933132111247d-02, 2.5379555959915d-02,
     |   2.9744213904854d-02, 3.3716415083675d-02, 3.6959625711825d-02,
     |   3.9138395013292d-02, 3.9948703039918d-02, 3.9148917140112d-02,
     |   3.6588238867485d-02, 3.2229544644731d-02, 2.6163888175132d-02,
     |   1.8614614331060d-02, 9.9299731209677d-03, 5.6422420506835d-04,
     |  -8.9516255731873d-03,-1.8047231125375d-02,-2.6155357094392d-02,
     |  -3.2755662281209d-02,-3.7415883842256d-02,-3.9826643980396d-02,
     |  -3.9826643980396d-02,-3.7415883842256d-02,-3.2755662281209d-02,
     |  -2.6155357094392d-02,-1.8047231125375d-02,-8.9516255731873d-03,
     |   5.6422420506830d-04, 9.9299731209676d-03, 1.8614614331060d-02,
     |   2.6163888175132d-02, 3.2229544644731d-02, 3.6588238867484d-02,
     |   3.9148917140112d-02, 3.9948703039918d-02, 3.9138395013292d-02,
     |   3.6959625711825d-02, 3.3716415083675d-02, 2.9744213904854d-02,
     |   2.5379555959915d-02, 2.0933132111247d-02, 1.6668516318769d-02,
     |   1.2787994552898d-02, 9.4260679754353d-03, 6.6503303723723d-03,
     |   4.4686520943001d-03, 2.8410252154383d-03, 1.6940876128987d-03,
     |   9.3627667667258d-04, 4.7174886987305d-04, 2.1160636062794d-04,
     |   8.1519681701024d-05, 2.5456513193635d-05, 5.8185528481116d-06,
     |   7.9156145920693d-07, 3.7365072111043d-08, 2.9407203596471d-10/
      data (zmn(lat, 6, 7), lat = 1,72)/
     |   2.7249576635699d-12, 1.0410179853758d-09, 3.6873046839389d-08,
     |   3.8129296471511d-07, 2.1587405055674d-06, 8.5186655518420d-06,
     |   2.6394821219125d-05, 6.8704944554667d-05, 1.5668653593853d-04,
     |   3.2193519632673d-04, 6.0764140745159d-04, 1.0685245517015d-03,
     |   1.7690500075759d-03, 2.7796803507105d-03, 4.1711421854939d-03,
     |   6.0069586267422d-03, 8.3347732764863d-03, 1.1177236882180d-02,
     |   1.4523409385179d-02, 1.8321716762451d-02, 2.2475475590764d-02,
     |   2.6841849970719d-02, 3.1234843637119d-02, 3.5432574464844d-02,
     |   3.9188663688390d-02, 4.2247138982167d-02, 4.4359846866795d-02,
     |   4.5305040373240d-02, 4.4905593331306d-02, 4.3045220869220d-02,
     |   3.9681172221118d-02, 3.4852103630592d-02, 2.8680218177185d-02,
     |   2.1367240747128d-02, 1.3184335340243d-02, 4.4566146732958d-03,
     |  -4.4566146732958d-03,-1.3184335340243d-02,-2.1367240747128d-02,
     |  -2.8680218177185d-02,-3.4852103630592d-02,-3.9681172221118d-02,
     |  -4.3045220869220d-02,-4.4905593331306d-02,-4.5305040373240d-02,
     |  -4.4359846866795d-02,-4.2247138982167d-02,-3.9188663688390d-02,
     |  -3.5432574464844d-02,-3.1234843637119d-02,-2.6841849970719d-02,
     |  -2.2475475590764d-02,-1.8321716762451d-02,-1.4523409385179d-02,
     |  -1.1177236882180d-02,-8.3347732764863d-03,-6.0069586267422d-03,
     |  -4.1711421854940d-03,-2.7796803507105d-03,-1.7690500075759d-03,
     |  -1.0685245517015d-03,-6.0764140745154d-04,-3.2193519632673d-04,
     |  -1.5668653593857d-04,-6.8704944554677d-05,-2.6394821219145d-05,
     |  -8.5186655518508d-06,-2.1587405056186d-06,-3.8129296472998d-07,
     |  -3.6873046873008d-08,-1.0410180114202d-09,-2.7249859244543d-12/
      data (zmn(lat, 7, 7), lat = 1,72)/
     |  -2.3113190701836d-13, 1.8483227049553d-11, 1.0790206931236d-09,
     |   1.5684903524619d-08, 1.1476177478257d-07, 5.5710743520946d-07,
     |   2.0561443879836d-06, 6.2331166643541d-06, 1.6284778135510d-05,
     |   3.7858858525827d-05, 8.0086322382397d-05, 1.5667191928405d-04,
     |   2.8690117369812d-04, 4.9639046008473d-04, 8.1739391664526d-04,
     |   1.2884915697166d-03, 1.9535193180615d-03, 2.8596623003586d-03,
     |   4.0547142082320d-03, 5.5835988568251d-03, 7.4843469897702d-03,
     |   9.7838098124543d-03, 1.2493460023048d-02, 1.5605671372655d-02,
     |   1.9090871806206d-02, 2.2895929346366d-02, 2.6944054589705d-02,
     |   3.1136393851148d-02, 3.5355351505867d-02, 3.9469531062203d-02,
     |   4.3340036120198d-02, 4.6827739383574d-02, 4.9801024069195d-02,
     |   5.2143438686344d-02, 5.3760690772604d-02, 5.4586440670959d-02,
     |   5.4586440670959d-02, 5.3760690772604d-02, 5.2143438686344d-02,
     |   4.9801024069195d-02, 4.6827739383574d-02, 4.3340036120198d-02,
     |   3.9469531062203d-02, 3.5355351505867d-02, 3.1136393851148d-02,
     |   2.6944054589705d-02, 2.2895929346366d-02, 1.9090871806206d-02,
     |   1.5605671372655d-02, 1.2493460023048d-02, 9.7838098124543d-03,
     |   7.4843469897702d-03, 5.5835988568251d-03, 4.0547142082320d-03,
     |   2.8596623003586d-03, 1.9535193180615d-03, 1.2884915697166d-03,
     |   8.1739391664527d-04, 4.9639046008474d-04, 2.8690117369813d-04,
     |   1.5667191928406d-04, 8.0086322382408d-05, 3.7858858525840d-05,
     |   1.6284778135527d-05, 6.2331166643816d-06, 2.0561443879930d-06,
     |   5.5710743522209d-07, 1.1476177476465d-07, 1.5684903542628d-08,
     |   1.0790206908009d-09, 1.8483220917501d-11,-2.3114008989467d-13/
      data (zmn(lat, 0, 8), lat = 1,72)/
     |   2.3949101959798d-03, 7.8926001581679d-03, 1.0902561360947d-02,
     |   1.2133901587248d-02, 1.0262815387762d-02, 6.1489863009117d-03,
     |  -1.8964108459805d-04,-7.3024626304202d-03,-1.4398162065282d-02,
     |  -1.9896426172464d-02,-2.3047471882224d-02,-2.2869570966789d-02,
     |  -1.9380036346660d-02,-1.2664808671106d-02,-3.7396032070248d-03,
     |   6.3630303782296d-03, 1.6035737993248d-02, 2.3977849414819d-02,
     |   2.8806973388774d-02, 2.9813427332744d-02, 2.6587605682034d-02,
     |   1.9549074349588d-02, 9.4877959950877d-03,-2.1597278091512d-03,
     |  -1.3855978858312d-02,-2.3868063918140d-02,-3.0804679666336d-02,
     |  -3.3566022224805d-02,-3.1740318257461d-02,-2.5467983141566d-02,
     |  -1.5609380078474d-02,-3.4727535474310d-03, 9.2367033311329d-03,
     |   2.0768183338115d-02, 2.9488659728940d-02, 3.4182274461753d-02,
     |   3.4182274461753d-02, 2.9488659728940d-02, 2.0768183338115d-02,
     |   9.2367033311329d-03,-3.4727535474309d-03,-1.5609380078474d-02,
     |  -2.5467983141566d-02,-3.1740318257461d-02,-3.3566022224805d-02,
     |  -3.0804679666336d-02,-2.3868063918140d-02,-1.3855978858312d-02,
     |  -2.1597278091512d-03, 9.4877959950877d-03, 1.9549074349588d-02,
     |   2.6587605682034d-02, 2.9813427332744d-02, 2.8806973388774d-02,
     |   2.3977849414819d-02, 1.6035737993248d-02, 6.3630303782296d-03,
     |  -3.7396032070248d-03,-1.2664808671106d-02,-1.9380036346660d-02,
     |  -2.2869570966789d-02,-2.3047471882224d-02,-1.9896426172464d-02,
     |  -1.4398162065282d-02,-7.3024626304203d-03,-1.8964108459802d-04,
     |   6.1489863009116d-03, 1.0262815387762d-02, 1.2133901587248d-02,
     |   1.0902561360947d-02, 7.8926001581680d-03, 2.3949101959798d-03/
      data (zmn(lat, 1, 8), lat = 1,72)/
     |   2.9180787854200d-04, 2.2100167772498d-03, 5.7599150174936d-03,
     |   1.0099248582084d-02, 1.4333895331174d-02, 1.7439943264125d-02,
     |   1.8594736168645d-02, 1.7216611552199d-02, 1.3177733866061d-02,
     |   6.7630703644846d-03,-1.2730079238204d-03,-9.8822840511231d-03,
     |  -1.7803726322058d-02,-2.3826098651944d-02,-2.6913253683336d-02,
     |  -2.6443564233666d-02,-2.2259471518450d-02,-1.4779373071639d-02,
     |  -4.8943409595022d-03, 6.0813523756766d-03, 1.6653610486383d-02,
     |   2.5299168010400d-02, 3.0751457059100d-02, 3.2130424863716d-02,
     |   2.9143644918804d-02, 2.2081194711558d-02, 1.1849166797406d-02,
     |  -2.0964198181352d-04,-1.2438519434897d-02,-2.3159965618911d-02,
     |  -3.0853431497694d-02,-3.4434903330124d-02,-3.3354622034003d-02,
     |  -2.7740733455444d-02,-1.8325163335937d-02,-6.4040352929171d-03,
     |   6.4040352929171d-03, 1.8325163335937d-02, 2.7740733455443d-02,
     |   3.3354622034003d-02, 3.4434903330124d-02, 3.0853431497694d-02,
     |   2.3159965618911d-02, 1.2438519434897d-02, 2.0964198181356d-04,
     |  -1.1849166797406d-02,-2.2081194711558d-02,-2.9143644918804d-02,
     |  -3.2130424863716d-02,-3.0751457059100d-02,-2.5299168010400d-02,
     |  -1.6653610486384d-02,-6.0813523756766d-03, 4.8943409595022d-03,
     |   1.4779373071639d-02, 2.2259471518450d-02, 2.6443564233666d-02,
     |   2.6913253683336d-02, 2.3826098651944d-02, 1.7803726322058d-02,
     |   9.8822840511231d-03, 1.2730079238203d-03,-6.7630703644846d-03,
     |  -1.3177733866061d-02,-1.7216611552199d-02,-1.8594736168645d-02,
     |  -1.7439943264125d-02,-1.4333895331174d-02,-1.0099248582084d-02,
     |  -5.7599150174936d-03,-2.2100167772498d-03,-2.9180787854200d-04/
      data (zmn(lat, 2, 8), lat = 1,72)/
     |   1.3236219721903d-05, 3.0692378562118d-04, 1.3646438196114d-03,
     |   3.4861668219634d-03, 6.7347735665621d-03, 1.0868156923693d-02,
     |   1.5385908424259d-02, 1.9578603572314d-02, 2.2660473190773d-02,
     |   2.3890277628118d-02, 2.2723934727671d-02, 1.8918059209757d-02,
     |   1.2614291703288d-02, 4.3451482819607d-03,-5.0039942992653d-03,
     |  -1.4308849681110d-02,-2.2349458512722d-02,-2.7991338264836d-02,
     |  -3.0351372065541d-02,-2.8947012380776d-02,-2.3782901113952d-02,
     |  -1.5379978822911d-02,-4.7216010824121d-03, 6.8610840643535d-03,
     |   1.7865535164644d-02, 2.6817782427501d-02, 3.2480727702805d-02,
     |   3.4029075657794d-02, 3.1175643063424d-02, 2.4220367637248d-02,
     |   1.4022026837883d-02, 1.8879402550740d-03,-1.0597466765197d-02,
     |  -2.1787224515853d-02,-3.0195155407356d-02,-3.4700197723343d-02,
     |  -3.4700197723343d-02,-3.0195155407356d-02,-2.1787224515853d-02,
     |  -1.0597466765197d-02, 1.8879402550739d-03, 1.4022026837883d-02,
     |   2.4220367637248d-02, 3.1175643063424d-02, 3.4029075657794d-02,
     |   3.2480727702805d-02, 2.6817782427501d-02, 1.7865535164644d-02,
     |   6.8610840643535d-03,-4.7216010824122d-03,-1.5379978822911d-02,
     |  -2.3782901113952d-02,-2.8947012380776d-02,-3.0351372065541d-02,
     |  -2.7991338264836d-02,-2.2349458512722d-02,-1.4308849681110d-02,
     |  -5.0039942992652d-03, 4.3451482819607d-03, 1.2614291703288d-02,
     |   1.8918059209757d-02, 2.2723934727671d-02, 2.3890277628118d-02,
     |   2.2660473190773d-02, 1.9578603572314d-02, 1.5385908424259d-02,
     |   1.0868156923693d-02, 6.7347735665621d-03, 3.4861668219633d-03,
     |   1.3646438196114d-03, 3.0692378562120d-04, 1.3236219721909d-05/
      data (zmn(lat, 3, 8), lat = 1,72)/
     |   1.5747238070924d-07, 2.7620690835343d-05, 2.0522777141827d-04,
     |   7.4929391633805d-04, 1.9106617879912d-03, 3.9055258836175d-03,
     |   6.8424352679986d-03, 1.0665388831026d-02, 1.5121629480358d-02,
     |   1.9765902141217d-02, 2.4001039072719d-02, 2.7153626523227d-02,
     |   2.8572463226945d-02, 2.7737319566363d-02, 2.4358621520769d-02,
     |   1.8452967047966d-02, 1.0378298733078d-02, 8.2179365905001d-04,
     |  -9.2632732048793d-03,-1.8764058055025d-02,-2.6547018377506d-02,
     |  -3.1608982000446d-02,-3.3220959519121d-02,-3.1041837360613d-02,
     |  -2.5185930258254d-02,-1.6230911985114d-02,-5.1641192818557d-03,
     |   6.7294654888545d-03, 1.8022468837901d-02, 2.7325358056279d-02,
     |   3.3466027227417d-02, 3.5645931966263d-02, 3.3549405007532d-02,
     |   2.7392162673344d-02, 1.7899869343500d-02, 6.2204370652107d-03,
     |  -6.2204370652107d-03,-1.7899869343500d-02,-2.7392162673344d-02,
     |  -3.3549405007532d-02,-3.5645931966263d-02,-3.3466027227417d-02,
     |  -2.7325358056279d-02,-1.8022468837901d-02,-6.7294654888546d-03,
     |   5.1641192818557d-03, 1.6230911985114d-02, 2.5185930258254d-02,
     |   3.1041837360613d-02, 3.3220959519121d-02, 3.1608982000446d-02,
     |   2.6547018377506d-02, 1.8764058055025d-02, 9.2632732048793d-03,
     |  -8.2179365904997d-04,-1.0378298733078d-02,-1.8452967047966d-02,
     |  -2.4358621520769d-02,-2.7737319566363d-02,-2.8572463226945d-02,
     |  -2.7153626523227d-02,-2.4001039072719d-02,-1.9765902141217d-02,
     |  -1.5121629480358d-02,-1.0665388831026d-02,-6.8424352679985d-03,
     |  -3.9055258836175d-03,-1.9106617879913d-03,-7.4929391633804d-04,
     |  -2.0522777141829d-04,-2.7620690835347d-05,-1.5747238071707d-07/
      data (zmn(lat, 4, 8), lat = 1,72)/
     |   3.6197351810669d-09, 1.7569065553451d-06, 2.1935587602377d-05,
     |   1.1342439365628d-04, 3.7784343100232d-04, 9.6364310609074d-04,
     |   2.0476580441902d-03, 3.8024790591055d-03, 6.3543115069938d-03,
     |   9.7392438956152d-03, 1.3866375254741d-02, 1.8496536762810d-02,
     |   2.3242946982038d-02, 2.7597426166162d-02, 3.0981331512524d-02,
     |   3.2816487599107d-02, 3.2607233906637d-02, 3.0022331976246d-02,
     |   2.4964104874563d-02, 1.7613242153164d-02, 8.4401238867023d-03,
     |  -1.8220419771066d-03,-1.2241959107508d-02,-2.1786881338887d-02,
     |  -2.9440401774323d-02,-3.4326843428655d-02,-3.5826085308516d-02,
     |  -3.3662988377909d-02,-2.7958398398212d-02,-1.9233223964522d-02,
     |  -8.3631437411042d-03, 3.5120887207080d-03, 1.5114566241977d-02,
     |   2.5174349588942d-02, 3.2577729882933d-02, 3.6499006786709d-02,
     |   3.6499006786709d-02, 3.2577729882933d-02, 2.5174349588942d-02,
     |   1.5114566241978d-02, 3.5120887207080d-03,-8.3631437411042d-03,
     |  -1.9233223964522d-02,-2.7958398398212d-02,-3.3662988377909d-02,
     |  -3.5826085308516d-02,-3.4326843428655d-02,-2.9440401774323d-02,
     |  -2.1786881338887d-02,-1.2241959107508d-02,-1.8220419771066d-03,
     |   8.4401238867022d-03, 1.7613242153164d-02, 2.4964104874563d-02,
     |   3.0022331976246d-02, 3.2607233906637d-02, 3.2816487599107d-02,
     |   3.0981331512524d-02, 2.7597426166162d-02, 2.3242946982038d-02,
     |   1.8496536762810d-02, 1.3866375254741d-02, 9.7392438956153d-03,
     |   6.3543115069939d-03, 3.8024790591055d-03, 2.0476580441902d-03,
     |   9.6364310609075d-04, 3.7784343100237d-04, 1.1342439365626d-04,
     |   2.1935587602388d-05, 1.7569065553464d-06, 3.6197351871812d-09/
      data (zmn(lat, 5, 8), lat = 1,72)/
     |   7.0744306773854d-10, 8.2512406976912d-08, 1.7403218724729d-06,
     |   1.2693963733346d-05, 5.4964244849637d-05, 1.7371872114131d-04,
     |   4.4378705925116d-04, 9.7076588033935d-04, 1.8844467724584d-03,
     |   3.3236257764360d-03, 5.4131067800816d-03, 8.2354801688385d-03,
     |   1.1801812287077d-02, 1.6026326655273d-02, 2.0710350958240d-02,
     |   2.5540061568759d-02, 3.0100991314432d-02, 3.3909989663399d-02,
     |   3.6462711936313d-02, 3.7292086681022d-02, 3.6031042503977d-02,
     |   3.2471374624628d-02, 2.6610330089048d-02, 1.8677352933718d-02,
     |   9.1354705047076d-03,-1.3452590195599d-03,-1.1941286954887d-02,
     |  -2.1751552419241d-02,-2.9888123669460d-02,-3.5571398101171d-02,
     |  -3.8218624483547d-02,-3.7514834177088d-02,-3.3456997775561d-02,
     |  -2.6365227604837d-02,-1.6858702993184d-02,-5.7982682246855d-03,
     |   5.7982682246855d-03, 1.6858702993184d-02, 2.6365227604837d-02,
     |   3.3456997775561d-02, 3.7514834177088d-02, 3.8218624483547d-02,
     |   3.5571398101171d-02, 2.9888123669460d-02, 2.1751552419241d-02,
     |   1.1941286954887d-02, 1.3452590195600d-03,-9.1354705047074d-03,
     |  -1.8677352933718d-02,-2.6610330089048d-02,-3.2471374624628d-02,
     |  -3.6031042503976d-02,-3.7292086681022d-02,-3.6462711936313d-02,
     |  -3.3909989663399d-02,-3.0100991314432d-02,-2.5540061568759d-02,
     |  -2.0710350958240d-02,-1.6026326655273d-02,-1.1801812287077d-02,
     |  -8.2354801688384d-03,-5.4131067800815d-03,-3.3236257764359d-03,
     |  -1.8844467724584d-03,-9.7076588033934d-04,-4.4378705925113d-04,
     |  -1.7371872114128d-04,-5.4964244849579d-05,-1.2693963733326d-05,
     |  -1.7403218724291d-06,-8.2512406968509d-08,-7.0744303891666d-10/
      data (zmn(lat, 6, 8), lat = 1,72)/
     |   7.6772574440597d-12, 2.9249615076139d-09, 1.0315154351092d-07,
     |   1.0596610062281d-06, 5.9466600730372d-06, 2.3206528415340d-05,
     |   7.0940931545985d-05, 1.8173746223397d-04, 4.0687628835557d-04,
     |   8.1849747523277d-04, 1.5083275524297d-03, 2.5818915700833d-03,
     |   4.1477608072611d-03, 6.3022221802833d-03, 9.1106838919350d-03,
     |   1.2587993624085d-02, 1.6680486489861d-02, 2.1252858555302d-02,
     |   2.6082790789854d-02, 3.0865597366585d-02, 3.5230091057795d-02,
     |   3.8765461751696d-02, 4.1057430272286d-02, 4.1730476803632d-02,
     |   4.0491769755129d-02, 3.7171724546385d-02, 3.1756038661030d-02,
     |   2.4404633674906d-02, 1.5454154358581d-02, 5.4024043667348d-03,
     |  -5.1248607383973d-03,-1.5422261138152d-02,-2.4763825688227d-02,
     |  -3.2466880860749d-02,-3.7954169231989d-02,-4.0807568106590d-02,
     |  -4.0807568106590d-02,-3.7954169231989d-02,-3.2466880860749d-02,
     |  -2.4763825688227d-02,-1.5422261138152d-02,-5.1248607383972d-03,
     |   5.4024043667348d-03, 1.5454154358581d-02, 2.4404633674906d-02,
     |   3.1756038661030d-02, 3.7171724546385d-02, 4.0491769755129d-02,
     |   4.1730476803632d-02, 4.1057430272286d-02, 3.8765461751696d-02,
     |   3.5230091057795d-02, 3.0865597366585d-02, 2.6082790789854d-02,
     |   2.1252858555302d-02, 1.6680486489861d-02, 1.2587993624085d-02,
     |   9.1106838919350d-03, 6.3022221802833d-03, 4.1477608072611d-03,
     |   2.5818915700833d-03, 1.5083275524297d-03, 8.1849747523278d-04,
     |   4.0687628835556d-04, 1.8173746223399d-04, 7.0940931545985d-05,
     |   2.3206528415358d-05, 5.9466600730114d-06, 1.0596610062544d-06,
     |   1.0315154351350d-07, 2.9249615042675d-09, 7.6772500576910d-12/
      data (zmn(lat, 7, 8), lat = 1,72)/
     |  -1.0820426288174d-12, 7.6174464889737d-11, 4.4223442336119d-09,
     |   6.3917976251147d-08, 4.6408286656006d-07, 2.2311852970577d-06,
     |   8.1390149947443d-06, 2.4335913541073d-05, 6.2578606083961d-05,
     |   1.4287652719565d-04, 2.9615129518503d-04, 5.6634345373039d-04,
     |   1.0112956355852d-03, 1.7017441597162d-03, 2.7178807794093d-03,
     |   4.1432040414631d-03, 6.0557437190782d-03, 8.5171693402231d-03,
     |   1.1560725613018d-02, 1.5179306293354d-02, 1.9315217936062d-02,
     |   2.3853242751547d-02, 2.8618453454642d-02, 3.3379859072635d-02,
     |   3.7860396493331d-02, 4.1753085141472d-02, 4.4742411741450d-02,
     |   4.6529302674523d-02, 4.6857467977818d-02, 4.5538547006357d-02,
     |   4.2473410481875d-02, 3.7667203547073d-02, 3.1236237628865d-02,
     |   2.3405605724925d-02, 1.4497323457304d-02, 4.9097815116268d-03,
     |  -4.9097815116267d-03,-1.4497323457304d-02,-2.3405605724925d-02,
     |  -3.1236237628865d-02,-3.7667203547073d-02,-4.2473410481875d-02,
     |  -4.5538547006357d-02,-4.6857467977818d-02,-4.6529302674523d-02,
     |  -4.4742411741450d-02,-4.1753085141472d-02,-3.7860396493331d-02,
     |  -3.3379859072635d-02,-2.8618453454642d-02,-2.3853242751547d-02,
     |  -1.9315217936062d-02,-1.5179306293354d-02,-1.1560725613018d-02,
     |  -8.5171693402231d-03,-6.0557437190782d-03,-4.1432040414631d-03,
     |  -2.7178807794093d-03,-1.7017441597162d-03,-1.0112956355852d-03,
     |  -5.6634345373038d-04,-2.9615129518504d-04,-1.4287652719564d-04,
     |  -6.2578606083943d-05,-2.4335913541069d-05,-8.1390149947452d-06,
     |  -2.2311852970757d-06,-4.6408286659264d-07,-6.3917976259471d-08,
     |  -4.4223442454031d-09,-7.6174472666631d-11, 1.0820243440046d-12/
      data (zmn(lat, 8, 8), lat = 1,72)/
     |  -5.2059735132559d-15, 1.2460591469136d-12, 1.2108489634206d-10,
     |   2.4594744034549d-09, 2.3077961860681d-08, 1.3649188430610d-07,
     |   5.9307664259998d-07, 2.0652323627747d-06, 6.0838722563626d-06,
     |   1.5716794131640d-05, 3.6511414174408d-05, 7.7676664582173d-05,
     |   1.5341731408240d-04, 2.8426727366000d-04, 4.9820815947519d-04,
     |   8.3131820023976d-04, 1.3276861769153d-03, 2.0383539691644d-03,
     |   3.0191228814733d-03, 4.3271703785025d-03, 6.0165656927001d-03,
     |   8.1329295760686d-03, 1.0707635589746d-02, 1.3752076323123d-02,
     |   1.7252597530543d-02, 2.1166720270205d-02, 2.5421216425715d-02,
     |   2.9912475833201d-02, 3.4509412354145d-02, 3.9058919224003d-02,
     |   4.3393625559614d-02, 4.7341454987374d-02, 5.0736273655156d-02,
     |   5.3428765068124d-02, 5.5296603332890d-02, 5.6253025270102d-02,
     |   5.6253025270102d-02, 5.5296603332890d-02, 5.3428765068124d-02,
     |   5.0736273655156d-02, 4.7341454987374d-02, 4.3393625559614d-02,
     |   3.9058919224003d-02, 3.4509412354145d-02, 2.9912475833201d-02,
     |   2.5421216425715d-02, 2.1166720270205d-02, 1.7252597530543d-02,
     |   1.3752076323123d-02, 1.0707635589746d-02, 8.1329295760685d-03,
     |   6.0165656927001d-03, 4.3271703785025d-03, 3.0191228814732d-03,
     |   2.0383539691644d-03, 1.3276861769153d-03, 8.3131820023973d-04,
     |   4.9820815947517d-04, 2.8426727365998d-04, 1.5341731408237d-04,
     |   7.7676664582162d-05, 3.6511414174388d-05, 1.5716794131630d-05,
     |   6.0838722563601d-06, 2.0652323627647d-06, 5.9307664260733d-07,
     |   1.3649188430530d-07, 2.3077961875849d-08, 2.4594744141175d-09,
     |   1.2108492331300d-10, 1.2460822345017d-12,-5.1795970223070d-15/
      data (zmn(lat, 0, 9), lat = 1,72)/
     |   2.5245964463756d-03, 8.1830111410468d-03, 1.0830909294849d-02,
     |   1.1149500198596d-02, 7.8510776294621d-03, 2.1862457421688d-03,
     |  -5.3829872545802d-03,-1.2821537937597d-02,-1.8952534218706d-02,
     |  -2.1961756664622d-02,-2.1298206179766d-02,-1.6452089693955d-02,
     |  -8.3176458809930d-03, 2.0694532855297d-03, 1.2664857752967d-02,
     |   2.1753075507127d-02, 2.7364546568079d-02, 2.8508321944437d-02,
     |   2.4572702503847d-02, 1.6235566259189d-02, 4.6364498342628d-03,
     |  -8.1028739324576d-03,-1.9925089991964d-02,-2.8550431630088d-02,
     |  -3.2526228158509d-02,-3.0886035198674d-02,-2.3939889943259d-02,
     |  -1.2652609526119d-02, 9.3959564036509d-04, 1.4642092515079d-02,
     |   2.5934266380327d-02, 3.2961156237375d-02, 3.4329169244999d-02,
     |   2.9890760702407d-02, 2.0250056033575d-02, 7.1848716405640d-03,
     |  -7.1848716405640d-03,-2.0250056033575d-02,-2.9890760702407d-02,
     |  -3.4329169244999d-02,-3.2961156237375d-02,-2.5934266380327d-02,
     |  -1.4642092515079d-02,-9.3959564036513d-04, 1.2652609526119d-02,
     |   2.3939889943259d-02, 3.0886035198674d-02, 3.2526228158509d-02,
     |   2.8550431630088d-02, 1.9925089991964d-02, 8.1028739324576d-03,
     |  -4.6364498342626d-03,-1.6235566259189d-02,-2.4572702503847d-02,
     |  -2.8508321944437d-02,-2.7364546568079d-02,-2.1753075507127d-02,
     |  -1.2664857752967d-02,-2.0694532855297d-03, 8.3176458809930d-03,
     |   1.6452089693955d-02, 2.1298206179766d-02, 2.1961756664622d-02,
     |   1.8952534218706d-02, 1.2821537937597d-02, 5.3829872545802d-03,
     |  -2.1862457421687d-03,-7.8510776294621d-03,-1.1149500198596d-02,
     |  -1.0830909294849d-02,-8.1830111410469d-03,-2.5245964463756d-03/
      data (zmn(lat, 1, 9), lat = 1,72)/
     |   3.4248145207411d-04, 2.5887907548760d-03, 6.6186311071113d-03,
     |   1.1275694961803d-02, 1.5315390531384d-02, 1.7470234742624d-02,
     |   1.6840772117631d-02, 1.3048025595243d-02, 6.3928440854435d-03,
     |  -2.1963478651004d-03,-1.1290406230885d-02,-1.9237330709070d-02,
     |  -2.4463489707181d-02,-2.5801222151048d-02,-2.2729155012206d-02,
     |  -1.5517210563145d-02,-5.2099297466227d-03, 6.5243443122130d-03,
     |   1.7679760764949d-02, 2.6262869004025d-02, 3.0661658093174d-02,
     |   2.9948642011141d-02, 2.4074700986816d-02, 1.3902097107500d-02,
     |   1.0781483008177d-03,-1.2241013332545d-02,-2.3760456101789d-02,
     |  -3.1452676009541d-02,-3.3920200172319d-02,-3.0654452270053d-02,
     |  -2.2137520580181d-02,-9.7711173637361d-03, 4.3602977263039d-03,
     |   1.7848136631707d-02, 2.8379574438458d-02, 3.4142094127717d-02,
     |   3.4142094127717d-02, 2.8379574438458d-02, 1.7848136631707d-02,
     |   4.3602977263039d-03,-9.7711173637361d-03,-2.2137520580181d-02,
     |  -3.0654452270053d-02,-3.3920200172319d-02,-3.1452676009541d-02,
     |  -2.3760456101789d-02,-1.2241013332545d-02, 1.0781483008176d-03,
     |   1.3902097107500d-02, 2.4074700986816d-02, 2.9948642011141d-02,
     |   3.0661658093174d-02, 2.6262869004025d-02, 1.7679760764950d-02,
     |   6.5243443122130d-03,-5.2099297466228d-03,-1.5517210563144d-02,
     |  -2.2729155012206d-02,-2.5801222151048d-02,-2.4463489707181d-02,
     |  -1.9237330709070d-02,-1.1290406230885d-02,-2.1963478651003d-03,
     |   6.3928440854435d-03, 1.3048025595243d-02, 1.6840772117631d-02,
     |   1.7470234742624d-02, 1.5315390531384d-02, 1.1275694961803d-02,
     |   6.6186311071114d-03, 2.5887907548760d-03, 3.4248145207407d-04/
      data (zmn(lat, 2, 9), lat = 1,72)/
     |   1.7538321983504d-05, 4.0410002690526d-04, 1.7759070870454d-03,
     |   4.4546956566152d-03, 8.3890030284159d-03, 1.3081697528313d-02,
     |   1.7701670326627d-02, 2.1214121801103d-02, 2.2624849848338d-02,
     |   2.1187726038760d-02, 1.6619451248501d-02, 9.1972868214371d-03,
     |  -2.1608223004983d-04,-1.0294967713841d-02,-1.9445520216088d-02,
     |  -2.6093878731678d-02,-2.8966003832881d-02,-2.7352938050348d-02,
     |  -2.1265437933868d-02,-1.1486096989132d-02, 5.3602953838980d-04,
     |   1.2897145663582d-02, 2.3559477984579d-02, 3.0691399713018d-02,
     |   3.3000573989540d-02, 2.9966900543740d-02, 2.1962937221024d-02,
     |   1.0206020092767d-02,-3.4229514616158d-03,-1.6694859242083d-02,
     |  -2.7399650555916d-02,-3.3730733859909d-02,-3.4591120258988d-02,
     |  -2.9794756675099d-02,-2.0099261300568d-02,-7.0903030253902d-03,
     |   7.0903030253902d-03, 2.0099261300568d-02, 2.9794756675099d-02,
     |   3.4591120258988d-02, 3.3730733859909d-02, 2.7399650555915d-02,
     |   1.6694859242083d-02, 3.4229514616158d-03,-1.0206020092767d-02,
     |  -2.1962937221024d-02,-2.9966900543740d-02,-3.3000573989540d-02,
     |  -3.0691399713018d-02,-2.3559477984579d-02,-1.2897145663583d-02,
     |  -5.3602953838997d-04, 1.1486096989132d-02, 2.1265437933868d-02,
     |   2.7352938050348d-02, 2.8966003832881d-02, 2.6093878731678d-02,
     |   1.9445520216088d-02, 1.0294967713841d-02, 2.1608223004985d-04,
     |  -9.1972868214371d-03,-1.6619451248501d-02,-2.1187726038760d-02,
     |  -2.2624849848338d-02,-2.1214121801103d-02,-1.7701670326627d-02,
     |  -1.3081697528313d-02,-8.3890030284159d-03,-4.4546956566152d-03,
     |  -1.7759070870455d-03,-4.0410002690520d-04,-1.7538321983475d-05/
      data (zmn(lat, 3, 9), lat = 1,72)/
     |   2.5300926948573d-07, 4.1078435452133d-05, 3.0272321767089d-04,
     |   1.0905542695148d-03, 2.7306004669292d-03, 5.4507132903768d-03,
     |   9.2683981792109d-03, 1.3919881420734d-02, 1.8848420372198d-02,
     |   2.3263625612710d-02, 2.6264383599562d-02, 2.7006637249805d-02,
     |   2.4883768488455d-02, 1.9684005020428d-02, 1.1689605125128d-02,
     |   1.6928407379613d-03,-9.0826775933827d-03,-1.9148268776335d-02,
     |  -2.6980434805904d-02,-3.1277137059550d-02,-3.1195448909829d-02,
     |  -2.6526223168494d-02,-1.7770896221438d-02,-6.1010706989910d-03,
     |   6.7980341215003d-03, 1.8978741980819d-02, 2.8537284225878d-02,
     |   3.3925012022557d-02, 3.4211321535642d-02, 2.9252088679772d-02,
     |   1.9732324736092d-02, 7.0728090009671d-03,-6.7865271617507d-03,
     |  -1.9692264885347d-02,-2.9622370171426d-02,-3.5013068844971d-02,
     |  -3.5013068844971d-02,-2.9622370171426d-02,-1.9692264885347d-02,
     |  -6.7865271617507d-03, 7.0728090009671d-03, 1.9732324736092d-02,
     |   2.9252088679772d-02, 3.4211321535642d-02, 3.3925012022557d-02,
     |   2.8537284225878d-02, 1.8978741980819d-02, 6.7980341215003d-03,
     |  -6.1010706989910d-03,-1.7770896221438d-02,-2.6526223168494d-02,
     |  -3.1195448909829d-02,-3.1277137059550d-02,-2.6980434805904d-02,
     |  -1.9148268776335d-02,-9.0826775933826d-03, 1.6928407379613d-03,
     |   1.1689605125129d-02, 1.9684005020428d-02, 2.4883768488455d-02,
     |   2.7006637249805d-02, 2.6264383599562d-02, 2.3263625612710d-02,
     |   1.8848420372198d-02, 1.3919881420734d-02, 9.2683981792109d-03,
     |   5.4507132903768d-03, 2.7306004669293d-03, 1.0905542695148d-03,
     |   3.0272321767085d-04, 4.1078435452196d-05, 2.5300926950743d-07/
      data (zmn(lat, 4, 9), lat = 1,72)/
     |   6.1243740860148d-09, 2.9835115781687d-06, 3.6991273367233d-05,
     |   1.8927452378800d-04, 6.2158060148584d-04, 1.5565694566585d-03,
     |   3.2336954397541d-03, 5.8428960978008d-03, 9.4496571421358d-03,
     |   1.3930405262445d-02, 1.8935988346715d-02, 2.3897944735317d-02,
     |   2.8083567269358d-02, 3.0696769517720d-02, 3.1010821613205d-02,
     |   2.8511481282335d-02, 2.3023718425955d-02, 1.4796107736156d-02,
     |   4.5217288927922d-03,-6.7151622641397d-03,-1.7565263702449d-02,
     |  -2.6597838520850d-02,-3.2515439755719d-02,-3.4365397864125d-02,
     |  -3.1712340898694d-02,-2.4739995063794d-02,-1.4261169300467d-02,
     |  -1.6288439818636d-03, 1.1442003947514d-02, 2.3117256063807d-02,
     |   3.1714491960721d-02, 3.5959586450845d-02, 3.5187500373650d-02,
     |   2.9454095848722d-02, 1.9539189665590d-02, 6.8387022416435d-03,
     |  -6.8387022416434d-03,-1.9539189665590d-02,-2.9454095848722d-02,
     |  -3.5187500373650d-02,-3.5959586450845d-02,-3.1714491960721d-02,
     |  -2.3117256063807d-02,-1.1442003947514d-02, 1.6288439818636d-03,
     |   1.4261169300466d-02, 2.4739995063794d-02, 3.1712340898694d-02,
     |   3.4365397864125d-02, 3.2515439755719d-02, 2.6597838520850d-02,
     |   1.7565263702449d-02, 6.7151622641397d-03,-4.5217288927922d-03,
     |  -1.4796107736156d-02,-2.3023718425955d-02,-2.8511481282335d-02,
     |  -3.1010821613206d-02,-3.0696769517720d-02,-2.8083567269358d-02,
     |  -2.3897944735317d-02,-1.8935988346715d-02,-1.3930405262445d-02,
     |  -9.4496571421358d-03,-5.8428960978008d-03,-3.2336954397541d-03,
     |  -1.5565694566584d-03,-6.2158060148587d-04,-1.8927452378799d-04,
     |  -3.6991273367165d-05,-2.9835115781993d-06,-6.1243740816042d-09/
      data (zmn(lat, 5, 9), lat = 1,72)/
     |   1.3017666628790d-09, 1.6276673526430d-07, 3.4112040550534d-06,
     |   2.4666661661989d-05, 1.0555820401388d-04, 3.2868766929512d-04,
     |   8.2448964591272d-04, 1.7646200823074d-03, 3.3386658748262d-03,
     |   5.7150161412849d-03, 8.9912663597826d-03, 1.3143384915228d-02,
     |   1.7985178529917d-02, 2.3149578785759d-02, 2.8100732517273d-02,
     |   3.2181027212412d-02, 3.4690815992077d-02, 3.4991830351739d-02,
     |   3.2619421205545d-02, 2.7385063684210d-02, 1.9449934647632d-02,
     |   9.3532044760538d-03,-2.0152357750808d-03,-1.3499424104156d-02,
     |  -2.3811643114705d-02,-3.1699737713417d-02,-3.6123990375124d-02,
     |  -3.6416819994272d-02,-3.2399529840987d-02,-2.4435603490747d-02,
     |  -1.3408944536998d-02,-6.2664712260999d-04, 1.2342406254500d-02,
     |   2.3871507306357d-02, 3.2493845795930d-02, 3.7102384421421d-02,
     |   3.7102384421421d-02, 3.2493845795930d-02, 2.3871507306357d-02,
     |   1.2342406254500d-02,-6.2664712260999d-04,-1.3408944536998d-02,
     |  -2.4435603490747d-02,-3.2399529840987d-02,-3.6416819994272d-02,
     |  -3.6123990375124d-02,-3.1699737713417d-02,-2.3811643114705d-02,
     |  -1.3499424104156d-02,-2.0152357750807d-03, 9.3532044760538d-03,
     |   1.9449934647632d-02, 2.7385063684210d-02, 3.2619421205545d-02,
     |   3.4991830351739d-02, 3.4690815992077d-02, 3.2181027212412d-02,
     |   2.8100732517273d-02, 2.3149578785759d-02, 1.7985178529917d-02,
     |   1.3143384915228d-02, 8.9912663597826d-03, 5.7150161412850d-03,
     |   3.3386658748263d-03, 1.7646200823074d-03, 8.2448964591266d-04,
     |   3.2868766929507d-04, 1.0555820401385d-04, 2.4666661661982d-05,
     |   3.4112040550919d-06, 1.6276673519700d-07, 1.3017666425150d-09/
      data (zmn(lat, 6, 9), lat = 1,72)/
     |   1.8298711831315d-11, 6.8949408865595d-09, 2.4198032008932d-07,
     |   2.4674319027132d-06, 1.3709313695862d-05, 5.2829039668084d-05,
     |   1.5903484997743d-04, 4.0006527242461d-04, 8.7685811785269d-04,
     |   1.7213499057067d-03, 3.0848278086463d-03, 5.1159200004176d-03,
     |   7.9296190407961d-03, 1.1571228629761d-02, 1.5981280397736d-02,
     |   2.0968737348835d-02, 2.6199786775882d-02, 3.1208025602657d-02,
     |   3.5428955719827d-02, 3.8257801621673d-02, 3.9125362382699d-02,
     |   3.7582659694421d-02, 3.3382314680475d-02, 2.6543497097829d-02,
     |   1.7388316271965d-02, 6.5406756755767d-03,-5.1164526705861d-03,
     |  -1.6523356426001d-02,-2.6557339824600d-02,-3.4164375852392d-02,
     |  -3.8491511708376d-02,-3.9001710701523d-02,-3.5554372071802d-02,
     |  -2.8438939968136d-02,-1.8355231215052d-02,-6.3414818270121d-03,
     |   6.3414818270120d-03, 1.8355231215052d-02, 2.8438939968136d-02,
     |   3.5554372071802d-02, 3.9001710701523d-02, 3.8491511708376d-02,
     |   3.4164375852392d-02, 2.6557339824600d-02, 1.6523356426001d-02,
     |   5.1164526705862d-03,-6.5406756755767d-03,-1.7388316271965d-02,
     |  -2.6543497097829d-02,-3.3382314680475d-02,-3.7582659694421d-02,
     |  -3.9125362382699d-02,-3.8257801621673d-02,-3.5428955719827d-02,
     |  -3.1208025602657d-02,-2.6199786775882d-02,-2.0968737348835d-02,
     |  -1.5981280397736d-02,-1.1571228629761d-02,-7.9296190407962d-03,
     |  -5.1159200004176d-03,-3.0848278086462d-03,-1.7213499057067d-03,
     |  -8.7685811785265d-04,-4.0006527242460d-04,-1.5903484997743d-04,
     |  -5.2829039668126d-05,-1.3709313695830d-05,-2.4674319027266d-06,
     |  -2.4198032012967d-07,-6.8949408793501d-09,-1.8298730134048d-11/
      data (zmn(lat, 7, 9), lat = 1,72)/
     |  -2.8937180390689d-12, 2.2688650875139d-10, 1.3135493380592d-08,
     |   1.8862180752853d-07, 1.3576618817781d-06, 6.4561977778960d-06,
     |   2.3240786144649d-05, 6.8410677356820d-05, 1.7275016468237d-04,
     |   3.8631347611307d-04, 7.8214998921596d-04, 1.4567799900449d-03,
     |   2.5257196630595d-03, 4.1128907764434d-03, 6.3337139700953d-03,
     |   9.2729523182635d-03, 1.2959733516779d-02, 1.7343370249407d-02,
     |   2.2274348146898d-02, 2.7494936432676d-02, 3.2643172335893d-02,
     |   3.7272484010998d-02, 4.0887100799639d-02, 4.2990939042745d-02,
     |   4.3145223691938d-02, 4.1028121512811d-02, 3.6488495093173d-02,
     |   2.9585808209089d-02, 2.0609333901136d-02, 1.0072060379348d-02,
     |  -1.3222069044983d-03,-1.2736503335341d-02,-2.3277602793973d-02,
     |  -3.2083750832286d-02,-3.8412994447979d-02,-4.1721393532860d-02,
     |  -4.1721393532860d-02,-3.8412994447979d-02,-3.2083750832286d-02,
     |  -2.3277602793973d-02,-1.2736503335341d-02,-1.3222069044983d-03,
     |   1.0072060379348d-02, 2.0609333901136d-02, 2.9585808209089d-02,
     |   3.6488495093173d-02, 4.1028121512811d-02, 4.3145223691938d-02,
     |   4.2990939042746d-02, 4.0887100799639d-02, 3.7272484010998d-02,
     |   3.2643172335893d-02, 2.7494936432676d-02, 2.2274348146898d-02,
     |   1.7343370249407d-02, 1.2959733516779d-02, 9.2729523182636d-03,
     |   6.3337139700953d-03, 4.1128907764434d-03, 2.5257196630596d-03,
     |   1.4567799900449d-03, 7.8214998921600d-04, 3.8631347611304d-04,
     |   1.7275016468236d-04, 6.8410677356816d-05, 2.3240786144669d-05,
     |   6.4561977779061d-06, 1.3576618817895d-06, 1.8862180750264d-07,
     |   1.3135493364520d-08, 2.2688653100091d-10,-2.8936939988702d-12/
      data (zmn(lat, 8, 9), lat = 1,72)/
     |  -2.2994231485290d-14, 5.4208629161308d-12, 5.2465812036741d-10,
     |   1.0595831129331d-08, 9.8661605251785d-08, 5.7790417422889d-07,
     |   2.4818835819209d-06, 8.5243968094152d-06, 2.4715902094621d-05,
     |   6.2706083154601d-05, 1.4273690637404d-04, 2.9684629291132d-04,
     |   5.7170570109157d-04, 1.0302676099613d-03, 1.7513065700861d-03,
     |   2.8260143885672d-03, 4.3510848310226d-03, 6.4181886063624d-03,
     |   9.1003474536104d-03, 1.2436381900044d-02, 1.6415219764832d-02,
     |   2.0962292544883d-02, 2.5930408081939d-02, 3.1097297993724d-02,
     |   3.6171475717339d-02, 4.0807144421168d-02, 4.4627761988689d-02,
     |   4.7256650092335d-02, 4.8351901885238d-02, 4.7641975862645d-02,
     |   4.4957913035818d-02, 4.0258179081184d-02, 3.3642739409633d-02,
     |   2.5354070455568d-02, 1.5764267048074d-02, 5.3490371319061d-03,
     |  -5.3490371319061d-03,-1.5764267048074d-02,-2.5354070455568d-02,
     |  -3.3642739409633d-02,-4.0258179081184d-02,-4.4957913035818d-02,
     |  -4.7641975862645d-02,-4.8351901885238d-02,-4.7256650092335d-02,
     |  -4.4627761988689d-02,-4.0807144421168d-02,-3.6171475717339d-02,
     |  -3.1097297993724d-02,-2.5930408081939d-02,-2.0962292544883d-02,
     |  -1.6415219764832d-02,-1.2436381900044d-02,-9.1003474536104d-03,
     |  -6.4181886063624d-03,-4.3510848310226d-03,-2.8260143885672d-03,
     |  -1.7513065700862d-03,-1.0302676099613d-03,-5.7170570109156d-04,
     |  -2.9684629291133d-04,-1.4273690637402d-04,-6.2706083154616d-05,
     |  -2.4715902094670d-05,-8.5243968094364d-06,-2.4818835819396d-06,
     |  -5.7790417421646d-07,-9.8661605280974d-08,-1.0595831107936d-08,
     |  -5.2465810049730d-10,-5.4208581790091d-12, 2.3014375140725d-14/
      data (zmn(lat, 9, 9), lat = 1,72)/
     |   3.5686092283958d-15, 8.0042808234556d-14, 1.3547027564089d-11,
     |   3.8439232857277d-10, 4.6256637838613d-09, 3.3331183575442d-08,
     |   1.7050774840536d-07, 6.8203814510073d-07, 2.2654496076081d-06,
     |   6.5033404797906d-06, 1.6591094488684d-05, 3.8385398393053d-05,
     |   8.1769718751295d-05, 1.6225809797831d-04, 3.0266789011844d-04,
     |   5.3460014790687d-04, 8.9939244605302d-04, 1.4481732972901d-03,
     |   2.2406674689926d-03, 3.3424880241074d-03, 4.8208041746694d-03,
     |   6.7384824270720d-03, 9.1470386077111d-03, 1.2078977417702d-02,
     |   1.5540296461310d-02, 1.9504056354648d-02, 2.3905937787014d-02,
     |   2.8642603292818d-02, 3.3573455837428d-02, 3.8526056394702d-02,
     |   4.3305063920218d-02, 4.7704141948738d-02, 5.1519891470740d-02,
     |   5.4566573461906d-02, 5.6690220765226d-02, 5.7780735923978d-02,
     |   5.7780735923978d-02, 5.6690220765226d-02, 5.4566573461906d-02,
     |   5.1519891470740d-02, 4.7704141948738d-02, 4.3305063920218d-02,
     |   3.8526056394702d-02, 3.3573455837429d-02, 2.8642603292818d-02,
     |   2.3905937787014d-02, 1.9504056354648d-02, 1.5540296461310d-02,
     |   1.2078977417702d-02, 9.1470386077111d-03, 6.7384824270720d-03,
     |   4.8208041746695d-03, 3.3424880241074d-03, 2.2406674689926d-03,
     |   1.4481732972901d-03, 8.9939244605302d-04, 5.3460014790687d-04,
     |   3.0266789011844d-04, 1.6225809797831d-04, 8.1769718751292d-05,
     |   3.8385398393057d-05, 1.6591094488692d-05, 6.5033404798102d-06,
     |   2.2654496076048d-06, 6.8203814510011d-07, 1.7050774840002d-07,
     |   3.3331183577861d-08, 4.6256637734215d-09, 3.8439234751242d-10,
     |   1.3547025950163d-11, 8.0052531306111d-14, 3.5591818407841d-15/
      data (zmn(lat, 0,10), lat = 1,72)/
     |   2.6460629059659d-03, 8.4156337009609d-03, 1.0600367362441d-02,
     |   9.8744372752875d-03, 5.1153467293518d-03,-1.9089219352037d-03,
     |  -1.0133247481320d-02,-1.6947219315692d-02,-2.0881238461113d-02,
     |  -2.0251132682916d-02,-1.5101527243182d-02,-5.9355955879147d-03,
     |   5.1818153800489d-03, 1.6105603698461d-02, 2.4142165581932d-02,
     |   2.7522431756556d-02, 2.5055590578297d-02, 1.7150352417821d-02,
     |   5.1267369668593d-03,-8.4392682401056d-03,-2.0798558555773d-02,
     |  -2.9125452538880d-02,-3.1602468107194d-02,-2.7424986774863d-02,
     |  -1.7390310980398d-02,-3.4118324718135d-03, 1.1554435036398d-02,
     |   2.4415790822962d-02, 3.2352942982914d-02, 3.3659787631502d-02,
     |   2.7926968723782d-02, 1.6318493897575d-02, 1.1920554883944d-03,
     |  -1.4274203695261d-02,-2.6851810640276d-02,-3.3879244384278d-02,
     |  -3.3879244384278d-02,-2.6851810640276d-02,-1.4274203695261d-02,
     |   1.1920554883943d-03, 1.6318493897575d-02, 2.7926968723782d-02,
     |   3.3659787631502d-02, 3.2352942982914d-02, 2.4415790822962d-02,
     |   1.1554435036398d-02,-3.4118324718135d-03,-1.7390310980398d-02,
     |  -2.7424986774863d-02,-3.1602468107194d-02,-2.9125452538880d-02,
     |  -2.0798558555773d-02,-8.4392682401056d-03, 5.1267369668593d-03,
     |   1.7150352417821d-02, 2.5055590578297d-02, 2.7522431756556d-02,
     |   2.4142165581932d-02, 1.6105603698461d-02, 5.1818153800490d-03,
     |  -5.9355955879147d-03,-1.5101527243182d-02,-2.0251132682916d-02,
     |  -2.0881238461113d-02,-1.6947219315692d-02,-1.0133247481320d-02,
     |  -1.9089219352037d-03, 5.1153467293518d-03, 9.8744372752874d-03,
     |   1.0600367362441d-02, 8.4156337009609d-03, 2.6460629059659d-03/
      data (zmn(lat, 1,10), lat = 1,72)/
     |   4.0052292066593d-04, 2.9733012004413d-03, 7.4582360284709d-03,
     |   1.2278269146036d-02, 1.5839368101065d-02, 1.6638388398364d-02,
     |   1.3884740968259d-02, 7.5986215225643d-03,-1.1998875496449d-03,
     |  -1.0797607599778d-02,-1.9052128506758d-02,-2.3990505115476d-02,
     |  -2.4193863859779d-02,-1.9267907784729d-02,-9.9042712020669d-03,
     |   2.1205342972949d-03, 1.4380621572226d-02, 2.4223052414655d-02,
     |   2.9438674130591d-02, 2.8682950693520d-02, 2.1894742063151d-02,
     |   1.0270455981589d-02,-3.8678449938573d-03,-1.7627851034084d-02,
     |  -2.8071901295946d-02,-3.2935249121694d-02,-3.1045168773533d-02,
     |  -2.2680717000348d-02,-9.4569167269441d-03, 5.9137604900494d-03,
     |   2.0267262892594d-02, 3.0572602428666d-02, 3.4661184659230d-02,
     |   3.1612150581371d-02, 2.2039766001803d-02, 7.8888869310827d-03,
     |  -7.8888869310827d-03,-2.2039766001803d-02,-3.1612150581371d-02,
     |  -3.4661184659230d-02,-3.0572602428666d-02,-2.0267262892594d-02,
     |  -5.9137604900495d-03, 9.4569167269440d-03, 2.2680717000348d-02,
     |   3.1045168773533d-02, 3.2935249121694d-02, 2.8071901295946d-02,
     |   1.7627851034085d-02, 3.8678449938573d-03,-1.0270455981589d-02,
     |  -2.1894742063151d-02,-2.8682950693520d-02,-2.9438674130591d-02,
     |  -2.4223052414655d-02,-1.4380621572226d-02,-2.1205342972950d-03,
     |   9.9042712020670d-03, 1.9267907784729d-02, 2.4193863859779d-02,
     |   2.3990505115476d-02, 1.9052128506758d-02, 1.0797607599778d-02,
     |   1.1998875496449d-03,-7.5986215225642d-03,-1.3884740968259d-02,
     |  -1.6638388398364d-02,-1.5839368101065d-02,-1.2278269146036d-02,
     |  -7.4582360284708d-03,-2.9733012004413d-03,-4.0052292066587d-04/
      data (zmn(lat, 2,10), lat = 1,72)/
     |   2.2571412043533d-05, 5.1656007230819d-04, 2.2406438529769d-03,
     |   5.5059293918498d-03, 1.0070189540059d-02, 1.5087114913741d-02,
     |   1.9331421974034d-02, 2.1465343445318d-02, 2.0432783999235d-02,
     |   1.5756799956616d-02, 7.7684715760973d-03,-2.3919406089002d-03,
     |  -1.2932797259984d-02,-2.1776209356276d-02,-2.6989224515940d-02,
     |  -2.7244797099213d-02,-2.2151622919876d-02,-1.2419582310420d-02,
     |   2.3198754176035d-04, 1.3374058265666d-02, 2.4357359778679d-02,
     |   3.0856593949036d-02, 3.1384130874026d-02, 2.5630264722839d-02,
     |   1.4576663707569d-02, 3.2656353610285d-04,-1.4297897148008d-02,
     |  -2.6331121271255d-02,-3.3275152937826d-02,-3.3632956241494d-02,
     |  -2.7234417387373d-02,-1.5294913412111d-02,-1.7916637680814d-04,
     |   1.5074052397875d-02, 2.7376103524719d-02, 3.4225029413990d-02,
     |   3.4225029413990d-02, 2.7376103524719d-02, 1.5074052397875d-02,
     |  -1.7916637680803d-04,-1.5294913412111d-02,-2.7234417387373d-02,
     |  -3.3632956241494d-02,-3.3275152937826d-02,-2.6331121271255d-02,
     |  -1.4297897148008d-02, 3.2656353610275d-04, 1.4576663707569d-02,
     |   2.5630264722839d-02, 3.1384130874026d-02, 3.0856593949036d-02,
     |   2.4357359778679d-02, 1.3374058265666d-02, 2.3198754176041d-04,
     |  -1.2419582310420d-02,-2.2151622919876d-02,-2.7244797099213d-02,
     |  -2.6989224515940d-02,-2.1776209356276d-02,-1.2932797259984d-02,
     |  -2.3919406089002d-03, 7.7684715760972d-03, 1.5756799956616d-02,
     |   2.0432783999235d-02, 2.1465343445318d-02, 1.9331421974034d-02,
     |   1.5087114913741d-02, 1.0070189540059d-02, 5.5059293918498d-03,
     |   2.2406438529769d-03, 5.1656007230822d-04, 2.2571412043541d-05/
      data (zmn(lat, 3,10), lat = 1,72)/
     |   3.3208742164597d-07, 5.8567354563785d-05, 4.2718406170681d-04,
     |   1.5162586103819d-03, 3.7189026791388d-03, 7.2253679439395d-03,
     |   1.1867572366069d-02, 1.7056636941171d-02, 2.1834479590280d-02,
     |   2.5046406130043d-02, 2.5596601956446d-02, 2.2734655520092d-02,
     |   1.6298001735039d-02, 6.8491951586120d-03,-4.3418558328083d-03,
     |  -1.5478515355112d-02,-2.4559244366435d-02,-2.9775922034537d-02,
     |  -2.9909607691362d-02,-2.4631700251596d-02,-1.4641386588164d-02,
     |  -1.5945964359973d-03, 1.2169462920500d-02, 2.4061223587144d-02,
     |   3.1746092702083d-02, 3.3623063328286d-02, 2.9171683504378d-02,
     |   1.9093716175702d-02, 5.2093938961789d-03,-9.8742574769847d-03,
     |  -2.3264516013700d-02,-3.2351043516596d-02,-3.5329526729564d-02,
     |  -3.1569560199627d-02,-2.1753070141615d-02,-7.7489953438928d-03,
     |   7.7489953438928d-03, 2.1753070141615d-02, 3.1569560199627d-02,
     |   3.5329526729564d-02, 3.2351043516596d-02, 2.3264516013700d-02,
     |   9.8742574769848d-03,-5.2093938961788d-03,-1.9093716175702d-02,
     |  -2.9171683504378d-02,-3.3623063328286d-02,-3.1746092702083d-02,
     |  -2.4061223587144d-02,-1.2169462920500d-02, 1.5945964359973d-03,
     |   1.4641386588164d-02, 2.4631700251596d-02, 2.9909607691362d-02,
     |   2.9775922034537d-02, 2.4559244366435d-02, 1.5478515355112d-02,
     |   4.3418558328083d-03,-6.8491951586120d-03,-1.6298001735039d-02,
     |  -2.2734655520092d-02,-2.5596601956446d-02,-2.5046406130043d-02,
     |  -2.1834479590280d-02,-1.7056636941171d-02,-1.1867572366069d-02,
     |  -7.2253679439396d-03,-3.7189026791388d-03,-1.5162586103819d-03,
     |  -4.2718406170685d-04,-5.8567354563790d-05,-3.3208742168761d-07/
      data (zmn(lat, 4,10), lat = 1,72)/
     |   9.8056000944638d-09, 4.7707764500195d-06, 5.8695173120137d-05,
     |   2.9681905474269d-04, 9.5925862924054d-04, 2.3530969662112d-03,
     |   4.7641405149298d-03, 8.3408346017665d-03, 1.2982187096570d-02,
     |   1.8267434505431d-02, 2.3456915606969d-02, 2.7579831922505d-02,
     |   2.9601896231963d-02, 2.8645235570832d-02, 2.4214572238323d-02,
     |   1.6377072212622d-02, 5.8467494707596d-03,-6.0582672614349d-03,
     |  -1.7592436698421d-02,-2.6870093598413d-02,-3.2213825507417d-02,
     |  -3.2496022636158d-02,-2.7402035780928d-02,-1.7554029539676d-02,
     |  -4.4600966989261d-03, 9.7130769737897d-03, 2.2508919539466d-02,
     |   3.1625397657717d-02, 3.5350535103501d-02, 3.2902771006564d-02,
     |   2.4605462181093d-02, 1.1855896243111d-02,-3.1111479221883d-03,
     |  -1.7624200299597d-02,-2.9065826541722d-02,-3.5359657856760d-02,
     |  -3.5359657856760d-02,-2.9065826541722d-02,-1.7624200299597d-02,
     |  -3.1111479221883d-03, 1.1855896243111d-02, 2.4605462181093d-02,
     |   3.2902771006564d-02, 3.5350535103501d-02, 3.1625397657717d-02,
     |   2.2508919539466d-02, 9.7130769737897d-03,-4.4600966989260d-03,
     |  -1.7554029539676d-02,-2.7402035780928d-02,-3.2496022636158d-02,
     |  -3.2213825507417d-02,-2.6870093598413d-02,-1.7592436698421d-02,
     |  -6.0582672614350d-03, 5.8467494707595d-03, 1.6377072212621d-02,
     |   2.4214572238323d-02, 2.8645235570832d-02, 2.9601896231963d-02,
     |   2.7579831922505d-02, 2.3456915606969d-02, 1.8267434505431d-02,
     |   1.2982187096570d-02, 8.3408346017666d-03, 4.7641405149298d-03,
     |   2.3530969662112d-03, 9.5925862924058d-04, 2.9681905474264d-04,
     |   5.8695173120134d-05, 4.7707764499922d-06, 9.8056000654901d-09/
      data (zmn(lat, 5,10), lat = 1,72)/
     |   2.5775703479578d-09, 2.9512027353858d-07, 6.1500840458195d-06,
     |   4.4040366760917d-05, 1.8600611581480d-04, 5.6955767173654d-04,
     |   1.3995133499751d-03, 2.9218015442297d-03, 5.3672818660572d-03,
     |   8.8734287170831d-03, 1.3401062419668d-02, 1.8669016217810d-02,
     |   2.4129976086964d-02, 2.9004590670270d-02, 3.2379401397435d-02,
     |   3.3359187489319d-02, 3.1249559556348d-02, 2.5734455817736d-02,
     |   1.7008939873231d-02, 5.8318891040152d-03,-6.5240505223832d-03,
     |  -1.8428760654800d-02,-2.8138732893204d-02,-3.4090412630938d-02,
     |  -3.5190427667980d-02,-3.1046334092199d-02,-2.2088712176901d-02,
     |  -9.5532731925697d-03, 4.6831715095592d-03, 1.8391038485809d-02,
     |   2.9353739256734d-02, 3.5746971662735d-02, 3.6462471389821d-02,
     |   3.1315157996930d-02, 2.1092763585197d-02, 7.4354655137500d-03,
     |  -7.4354655137499d-03,-2.1092763585197d-02,-3.1315157996930d-02,
     |  -3.6462471389821d-02,-3.5746971662735d-02,-2.9353739256734d-02,
     |  -1.8391038485809d-02,-4.6831715095593d-03, 9.5532731925697d-03,
     |   2.2088712176900d-02, 3.1046334092199d-02, 3.5190427667980d-02,
     |   3.4090412630938d-02, 2.8138732893204d-02, 1.8428760654800d-02,
     |   6.5240505223833d-03,-5.8318891040152d-03,-1.7008939873231d-02,
     |  -2.5734455817736d-02,-3.1249559556348d-02,-3.3359187489319d-02,
     |  -3.2379401397435d-02,-2.9004590670270d-02,-2.4129976086964d-02,
     |  -1.8669016217810d-02,-1.3401062419668d-02,-8.8734287170831d-03,
     |  -5.3672818660572d-03,-2.9218015442297d-03,-1.3995133499751d-03,
     |  -5.6955767173653d-04,-1.8600611581480d-04,-4.4040366760899d-05,
     |  -6.1500840458002d-06,-2.9512027352298d-07,-2.5775703272092d-09/
      data (zmn(lat, 6,10), lat = 1,72)/
     |   3.8523683070765d-11, 1.4452958272442d-08, 5.0446897426225d-07,
     |   5.1015898679669d-06, 2.8030585270668d-05, 1.0649944732700d-04,
     |   3.1511128601093d-04, 7.7652637691656d-04, 1.6613451174651d-03,
     |   3.1711873234301d-03, 5.5023791051567d-03, 8.7928917913959d-03,
     |   1.3061031193966d-02, 1.8149252060040d-02, 2.3688868349299d-02,
     |   2.9100226957028d-02, 3.3637815758633d-02, 3.6481384994049d-02,
     |   3.6864002584311d-02, 3.4218146409949d-02, 2.8313777190602d-02,
     |   1.9359775139886d-02, 8.0433063158567d-03,-4.5094270034422d-03,
     |  -1.6854263752424d-02,-2.7419772818239d-02,-3.4740785335144d-02,
     |  -3.7697367356894d-02,-3.5717541733081d-02,-2.8905438032911d-02,
     |  -1.8067403871915d-02,-4.6252792386159d-03, 9.5744012541909d-03,
     |   2.2527660724978d-02, 3.2374638299983d-02, 3.7685973390713d-02,
     |   3.7685973390713d-02, 3.2374638299983d-02, 2.2527660724978d-02,
     |   9.5744012541910d-03,-4.6252792386158d-03,-1.8067403871915d-02,
     |  -2.8905438032911d-02,-3.5717541733081d-02,-3.7697367356894d-02,
     |  -3.4740785335144d-02,-2.7419772818239d-02,-1.6854263752424d-02,
     |  -4.5094270034422d-03, 8.0433063158568d-03, 1.9359775139886d-02,
     |   2.8313777190602d-02, 3.4218146409949d-02, 3.6864002584311d-02,
     |   3.6481384994049d-02, 3.3637815758633d-02, 2.9100226957028d-02,
     |   2.3688868349299d-02, 1.8149252060040d-02, 1.3061031193966d-02,
     |   8.7928917913959d-03, 5.5023791051566d-03, 3.1711873234301d-03,
     |   1.6613451174651d-03, 7.7652637691656d-04, 3.1511128601093d-04,
     |   1.0649944732700d-04, 2.8030585270669d-05, 5.1015898679745d-06,
     |   5.0446897427199d-07, 1.4452958283125d-08, 3.8523703393062d-11/
      data (zmn(lat, 7,10), lat = 1,72)/
     |  -8.2416910632863d-12, 5.6729497881132d-10, 3.2627863121337d-08,
     |   4.6517405234857d-07, 3.3159159501115d-06, 1.5576527839571d-05,
     |   5.5243310140643d-05, 1.5976864524760d-04, 3.9524526602948d-04,
     |   8.6324444652718d-04, 1.7013762946387d-03, 3.0737928477278d-03,
     |   5.1492609562405d-03, 8.0670205059368d-03, 1.1893984680513d-02,
     |   1.6580211980713d-02, 2.1922113051311d-02, 2.7543734233651d-02,
     |   3.2905133464506d-02, 3.7343222848362d-02, 4.0144907466313d-02,
     |   4.0645810236732d-02, 3.8341591777026d-02, 3.2994215191816d-02,
     |   2.4713648550941d-02, 1.3997170583529d-02, 1.7137219063074d-03,
     |  -1.0971024016066d-02,-2.2723310349747d-02,-3.2208300885082d-02,
     |  -3.8272195712616d-02,-4.0111868244837d-02,-3.7404639760388d-02,
     |  -3.0375783610038d-02,-1.9790429234475d-02,-6.8682568310945d-03,
     |   6.8682568310945d-03, 1.9790429234475d-02, 3.0375783610038d-02,
     |   3.7404639760388d-02, 4.0111868244837d-02, 3.8272195712616d-02,
     |   3.2208300885082d-02, 2.2723310349747d-02, 1.0971024016066d-02,
     |  -1.7137219063074d-03,-1.3997170583529d-02,-2.4713648550941d-02,
     |  -3.2994215191816d-02,-3.8341591777026d-02,-4.0645810236732d-02,
     |  -4.0144907466313d-02,-3.7343222848362d-02,-3.2905133464506d-02,
     |  -2.7543734233651d-02,-2.1922113051311d-02,-1.6580211980713d-02,
     |  -1.1893984680513d-02,-8.0670205059368d-03,-5.1492609562405d-03,
     |  -3.0737928477278d-03,-1.7013762946387d-03,-8.6324444652719d-04,
     |  -3.9524526602951d-04,-1.5976864524762d-04,-5.5243310140664d-05,
     |  -1.5576527839602d-05,-3.3159159501034d-06,-4.6517405236630d-07,
     |  -3.2627863121847d-08,-5.6729498975506d-10, 8.2417057936830d-12/
      data (zmn(lat, 8,10), lat = 1,72)/
     |  -7.2602733960651d-14, 1.7056575161206d-11, 1.6438111501512d-09,
     |   3.2986254820342d-08, 3.0452330606486d-07, 1.7645543326372d-06,
     |   7.4795358742154d-06, 2.5295692229206d-05, 7.2042042346540d-05,
     |   1.7907546129646d-04, 3.9830301129787d-04, 8.0709869210854d-04,
     |   1.5099811261714d-03, 2.6347697663915d-03, 4.3213712809977d-03,
     |   6.7024305390489d-03, 9.8767198468105d-03, 1.3878078737635d-02,
     |   1.8644566451921d-02, 2.3993802703110d-02, 2.9610838633394d-02,
     |   3.5054046200784d-02, 3.9782387858983d-02, 4.3204239623379d-02,
     |   4.4744152227111d-02, 4.3920195912872d-02, 4.0421566088408d-02,
     |   3.4174584705754d-02, 2.5385566179676d-02, 1.4551364998339d-02,
     |   2.4325576696281d-03,-1.0010441829079d-02,-2.1712315327209d-02,
     |  -3.1617673424999d-02,-3.8801002414594d-02,-4.2575482135040d-02,
     |  -4.2575482135040d-02,-3.8801002414594d-02,-3.1617673424999d-02,
     |  -2.1712315327209d-02,-1.0010441829079d-02, 2.4325576696282d-03,
     |   1.4551364998339d-02, 2.5385566179676d-02, 3.4174584705754d-02,
     |   4.0421566088408d-02, 4.3920195912872d-02, 4.4744152227111d-02,
     |   4.3204239623379d-02, 3.9782387858983d-02, 3.5054046200784d-02,
     |   2.9610838633394d-02, 2.3993802703110d-02, 1.8644566451921d-02,
     |   1.3878078737635d-02, 9.8767198468105d-03, 6.7024305390489d-03,
     |   4.3213712809977d-03, 2.6347697663916d-03, 1.5099811261714d-03,
     |   8.0709869210853d-04, 3.9830301129787d-04, 1.7907546129644d-04,
     |   7.2042042346471d-05, 2.5295692229171d-05, 7.4795358741689d-06,
     |   1.7645543326149d-06, 3.0452330600273d-07, 3.2986254794205d-08,
     |   1.6438111065974d-09, 1.7056554591558d-11,-7.2627711970304d-14/
      data (zmn(lat, 9,10), lat = 1,72)/
     |   1.9133283953615d-14, 3.6323549306259d-13, 6.1714001818883d-11,
     |   1.7410028493077d-09, 2.0790154050988d-08, 1.4836538013389d-07,
     |   7.5014903434886d-07, 2.9596219987421d-06, 9.6757275953963d-06,
     |   2.7278158480731d-05, 6.8189186430243d-05, 1.5421973772499d-04,
     |   3.2034909304226d-04, 6.1824755831199d-04, 1.1185374700842d-03,
     |   1.9105966039735d-03, 3.0987333016460d-03, 4.7938700151842d-03,
     |   7.1004756154502d-03, 1.0099334606954d-02, 1.3827713596103d-02,
     |   1.8259408841990d-02, 2.3287835682172d-02, 2.8715567103374d-02,
     |   3.4253415498999d-02, 3.9531238844465d-02, 4.4121209774675d-02,
     |   4.7572492509940d-02, 4.9454394784461d-02, 4.9403412175658d-02,
     |   4.7168464276638d-02, 4.2648274182365d-02, 3.5915388688759d-02,
     |   2.7222755740846d-02, 1.6990897633481d-02, 5.7762455224463d-03,
     |  -5.7762455224462d-03,-1.6990897633481d-02,-2.7222755740846d-02,
     |  -3.5915388688759d-02,-4.2648274182365d-02,-4.7168464276638d-02,
     |  -4.9403412175658d-02,-4.9454394784461d-02,-4.7572492509940d-02,
     |  -4.4121209774675d-02,-3.9531238844465d-02,-3.4253415498999d-02,
     |  -2.8715567103374d-02,-2.3287835682172d-02,-1.8259408841990d-02,
     |  -1.3827713596103d-02,-1.0099334606954d-02,-7.1004756154502d-03,
     |  -4.7938700151841d-03,-3.0987333016460d-03,-1.9105966039735d-03,
     |  -1.1185374700842d-03,-6.1824755831200d-04,-3.2034909304229d-04,
     |  -1.5421973772501d-04,-6.8189186430290d-05,-2.7278158480742d-05,
     |  -9.6757275953890d-06,-2.9596219987365d-06,-7.5014903434873d-07,
     |  -1.4836538013220d-07,-2.0790154048626d-08,-1.7410028260956d-09,
     |  -6.1714006581565d-11,-3.6322606613034d-13,-1.9139107262702d-14/
      data (zmn(lat,10,10), lat = 1,72)/
     |  -2.3955484350124d-17, 5.2638738948454d-15, 1.5111459717344d-12,
     |   5.9919016724910d-11, 9.2470754127184d-10, 8.1179951361816d-09,
     |   4.8891291630410d-08, 2.2464797648326d-07, 8.4136187129809d-07,
     |   2.6838801674936d-06, 7.5192672427388d-06, 1.8918889371312d-05,
     |   4.3467507167341d-05, 9.2371925980908d-05, 1.8339013249195d-04,
     |   3.4288221723054d-04, 6.0765508874906d-04, 1.0261611509934d-03,
     |   1.6585483241842d-03, 2.5750746641028d-03, 3.8525157196627d-03,
     |   5.5684110954566d-03, 7.7933026707245d-03, 1.0581473929789d-02,
     |   1.3961054084249d-02, 1.7924638985782d-02, 2.2421741612805d-02,
     |   2.7354369986874d-02, 3.2576815767295d-02, 3.7900330020519d-02,
     |   4.3102804874858d-02, 4.7942941633591d-02, 5.2177757912557d-02,
     |   5.5581764679038d-02, 5.7965814553157d-02, 5.9193545809451d-02,
     |   5.9193545809451d-02, 5.7965814553157d-02, 5.5581764679038d-02,
     |   5.2177757912557d-02, 4.7942941633591d-02, 4.3102804874858d-02,
     |   3.7900330020519d-02, 3.2576815767295d-02, 2.7354369986874d-02,
     |   2.2421741612805d-02, 1.7924638985783d-02, 1.3961054084249d-02,
     |   1.0581473929789d-02, 7.7933026707246d-03, 5.5684110954566d-03,
     |   3.8525157196627d-03, 2.5750746641028d-03, 1.6585483241842d-03,
     |   1.0261611509935d-03, 6.0765508874907d-04, 3.4288221723055d-04,
     |   1.8339013249196d-04, 9.2371925980913d-05, 4.3467507167352d-05,
     |   1.8918889371316d-05, 7.5192672427346d-06, 2.6838801675057d-06,
     |   8.4136187131835d-07, 2.2464797648719d-07, 4.8891291637244d-08,
     |   8.1179951360629d-09, 9.2470754226539d-10, 5.9918995062672d-11,
     |   1.5111205994296d-12, 5.2288533257073d-15,-5.1745317488966d-17/
      data (zmn(lat, 0,11), lat = 1,72)/
     |   2.7594707161087d-03, 8.5954238214541d-03, 1.0215776563594d-02,
     |   8.3523788215207d-03, 2.1639670057738d-03,-5.8828038309597d-03,
     |  -1.4062604006376d-02,-1.9226647467430d-02,-1.9939057780368d-02,
     |  -1.5052907271745d-02,-5.7733082702720d-03, 6.0758685483451d-03,
     |   1.7151699452167d-02, 2.4704961536213d-02, 2.6209592139742d-02,
     |   2.1148886179747d-02, 1.0242516785416d-02,-3.7377601892617d-03,
     |  -1.7520847193476d-02,-2.7329446917803d-02,-3.0675103443643d-02,
     |  -2.6275188510150d-02,-1.5178856837461d-02, 1.6198430888881d-04,
     |   1.5790089255017d-02, 2.7909977833429d-02, 3.3209700030678d-02,
     |   3.0368886161057d-02, 1.9803797562439d-02, 4.2076232318101d-03,
     |  -1.2712739664696d-02,-2.6572601391187d-02,-3.4009745079010d-02,
     |  -3.2966405564139d-02,-2.3798969183673d-02,-8.6272267141307d-03,
     |   8.6272267141307d-03, 2.3798969183673d-02, 3.2966405564139d-02,
     |   3.4009745079010d-02, 2.6572601391187d-02, 1.2712739664696d-02,
     |  -4.2076232318101d-03,-1.9803797562439d-02,-3.0368886161057d-02,
     |  -3.3209700030678d-02,-2.7909977833429d-02,-1.5790089255017d-02,
     |  -1.6198430888883d-04, 1.5178856837461d-02, 2.6275188510150d-02,
     |   3.0675103443643d-02, 2.7329446917803d-02, 1.7520847193476d-02,
     |   3.7377601892617d-03,-1.0242516785416d-02,-2.1148886179747d-02,
     |  -2.6209592139742d-02,-2.4704961536213d-02,-1.7151699452167d-02,
     |  -6.0758685483451d-03, 5.7733082702720d-03, 1.5052907271745d-02,
     |   1.9939057780368d-02, 1.9226647467430d-02, 1.4062604006376d-02,
     |   5.8828038309597d-03,-2.1639670057737d-03,-8.3523788215207d-03,
     |  -1.0215776563595d-02,-8.5954238214541d-03,-2.7594707161087d-03/
      data (zmn(lat, 1,11), lat = 1,72)/
     |   4.5585793918676d-04, 3.3705277004702d-03, 8.2545929390970d-03,
     |   1.3083371127290d-02, 1.5856528974789d-02, 1.4970339353857d-02,
     |   9.9085492281476d-03, 1.4011528404771d-03,-8.6371095492210d-03,
     |  -1.7628322203289d-02,-2.3003023778793d-02,-2.2968222123186d-02,
     |  -1.7053404882366d-02,-6.3527329119002d-03, 6.6856352621745d-03,
     |   1.8828949632280d-02, 2.6893877239190d-02, 2.8588647022929d-02,
     |   2.3169739604742d-02, 1.1699853466663d-02,-3.1503746821411d-03,
     |  -1.7741896597620d-02,-2.8372897570136d-02,-3.2237010731786d-02,
     |  -2.8168755960842d-02,-1.6989402108863d-02,-1.3419938778134d-03,
     |   1.4941869929302d-02, 2.7797570332719d-02, 3.3955755063653d-02,
     |   3.1786251659949d-02, 2.1731766653573d-02, 6.2202316030320d-03,
     |  -1.0931311920929d-02,-2.5469305832844d-02,-3.3774246250812d-02,
     |  -3.3774246250812d-02,-2.5469305832844d-02,-1.0931311920929d-02,
     |   6.2202316030319d-03, 2.1731766653573d-02, 3.1786251659949d-02,
     |   3.3955755063653d-02, 2.7797570332719d-02, 1.4941869929302d-02,
     |  -1.3419938778133d-03,-1.6989402108863d-02,-2.8168755960842d-02,
     |  -3.2237010731786d-02,-2.8372897570136d-02,-1.7741896597620d-02,
     |  -3.1503746821413d-03, 1.1699853466663d-02, 2.3169739604742d-02,
     |   2.8588647022929d-02, 2.6893877239190d-02, 1.8828949632280d-02,
     |   6.6856352621744d-03,-6.3527329119002d-03,-1.7053404882366d-02,
     |  -2.2968222123186d-02,-2.3003023778793d-02,-1.7628322203289d-02,
     |  -8.6371095492211d-03, 1.4011528404770d-03, 9.9085492281476d-03,
     |   1.4970339353857d-02, 1.5856528974789d-02, 1.3083371127290d-02,
     |   8.2545929390969d-03, 3.3705277004703d-03, 4.5585793918680d-04/
      data (zmn(lat, 2,11), lat = 1,72)/
     |   2.8383174005558d-05, 6.4452675288458d-04, 2.7556354817958d-03,
     |   6.6170113983244d-03, 1.1706911682603d-02, 1.6737873267837d-02,
     |   2.0066724415360d-02, 2.0156089494845d-02, 1.6144406574162d-02,
     |   8.1870160483144d-03,-2.4068188918072d-03,-1.3427322224474d-02,
     |  -2.2248729679050d-02,-2.6528409167938d-02,-2.4842588815812d-02,
     |  -1.7165904093870d-02,-4.9700384784715d-03, 9.0319030316583d-03,
     |   2.1519933246992d-02, 2.9363507861012d-02, 3.0442712922461d-02,
     |   2.4217768161227d-02, 1.1947240559626d-02,-3.5727760197534d-03,
     |  -1.8643173050870d-02,-2.9572680053081d-02,-3.3588156037089d-02,
     |  -2.9562331530567d-02,-1.8320080333699d-02,-2.4843398235291d-03,
     |   1.4155299850716d-02, 2.7553512008414d-02, 3.4419410899427d-02,
     |   3.3027804640593d-02, 2.3669810892519d-02, 8.5827361291925d-03,
     |  -8.5827361291925d-03,-2.3669810892519d-02,-3.3027804640593d-02,
     |  -3.4419410899427d-02,-2.7553512008414d-02,-1.4155299850716d-02,
     |   2.4843398235290d-03, 1.8320080333699d-02, 2.9562331530567d-02,
     |   3.3588156037089d-02, 2.9572680053081d-02, 1.8643173050870d-02,
     |   3.5727760197534d-03,-1.1947240559626d-02,-2.4217768161227d-02,
     |  -3.0442712922461d-02,-2.9363507861012d-02,-2.1519933246992d-02,
     |  -9.0319030316583d-03, 4.9700384784714d-03, 1.7165904093870d-02,
     |   2.4842588815812d-02, 2.6528409167938d-02, 2.2248729679050d-02,
     |   1.3427322224474d-02, 2.4068188918071d-03,-8.1870160483144d-03,
     |  -1.6144406574162d-02,-2.0156089494845d-02,-2.0066724415360d-02,
     |  -1.6737873267837d-02,-1.1706911682603d-02,-6.6170113983244d-03,
     |  -2.7556354817957d-03,-6.4452675288466d-04,-2.8383174005592d-05/
      data (zmn(lat, 3,11), lat = 1,72)/
     |   4.9439764654048d-07, 8.0568876526667d-05, 5.8167375830229d-04,
     |   2.0304968979797d-03, 4.8664914537562d-03, 9.1688458036266d-03,
     |   1.4468490852039d-02, 1.9736004342856d-02, 2.3567033153751d-02,
     |   2.4536313410391d-02, 2.1626124060742d-02, 1.4608403086530d-02,
     |   4.2565490457626d-03,-7.6951621280624d-03,-1.8864370582019d-02,
     |  -2.6747162052944d-02,-2.9336941359653d-02,-2.5676797022750d-02,
     |  -1.6193559936868d-02,-2.7077512982082d-03, 1.1906598694130d-02,
     |   2.4349062983707d-02, 3.1664432134249d-02, 3.1972143376807d-02,
     |   2.4967656855327d-02, 1.2060115443350d-02,-3.9033936522306d-03,
     |  -1.9273827487415d-02,-3.0451423664509d-02,-3.4748562862053d-02,
     |  -3.1052541214434d-02,-2.0120969779277d-02,-4.4303839066341d-03,
     |   1.2392428393795d-02, 2.6423261215575d-02, 3.4372892344649d-02,
     |   3.4372892344649d-02, 2.6423261215575d-02, 1.2392428393795d-02,
     |  -4.4303839066340d-03,-2.0120969779277d-02,-3.1052541214434d-02,
     |  -3.4748562862053d-02,-3.0451423664509d-02,-1.9273827487415d-02,
     |  -3.9033936522306d-03, 1.2060115443350d-02, 2.4967656855327d-02,
     |   3.1972143376807d-02, 3.1664432134249d-02, 2.4349062983707d-02,
     |   1.1906598694130d-02,-2.7077512982082d-03,-1.6193559936868d-02,
     |  -2.5676797022750d-02,-2.9336941359653d-02,-2.6747162052944d-02,
     |  -1.8864370582019d-02,-7.6951621280623d-03, 4.2565490457625d-03,
     |   1.4608403086530d-02, 2.1626124060742d-02, 2.4536313410391d-02,
     |   2.3567033153751d-02, 1.9736004342856d-02, 1.4468490852039d-02,
     |   9.1688458036266d-03, 4.8664914537563d-03, 2.0304968979797d-03,
     |   5.8167375830234d-04, 8.0568876526634d-05, 4.9439764650160d-07/
      data (zmn(lat, 4,11), lat = 1,72)/
     |   1.4890183296894d-08, 7.2745676171870d-06, 8.8735834046274d-05,
     |   4.4293557082717d-04, 1.4061601514691d-03, 3.3704053146289d-03,
     |   6.6275058445979d-03, 1.1189827005754d-02, 1.6651280655259d-02,
     |   2.2152561675814d-02, 2.6486597702217d-02, 2.8342692723858d-02,
     |   2.6640906898946d-02, 2.0874960225427d-02, 1.1365022272223d-02,
     |  -6.6431583359549d-04,-1.3229291682889d-02,-2.3946669375038d-02,
     |  -3.0541639496529d-02,-3.1389766859129d-02,-2.5959963940241d-02,
     |  -1.5037530096169d-02,-6.5340228514105d-04, 1.4287040170833d-02,
     |   2.6606536192144d-02, 3.3560093809539d-02, 3.3477283583950d-02,
     |   2.6186704919922d-02, 1.3111146205548d-02,-3.0021771894947d-03,
     |  -1.8666365766142d-02,-3.0426474615916d-02,-3.5642525263889d-02,
     |  -3.3100430569979d-02,-2.3305388459128d-02,-8.3842491818262d-03,
     |   8.3842491818261d-03, 2.3305388459128d-02, 3.3100430569979d-02,
     |   3.5642525263889d-02, 3.0426474615916d-02, 1.8666365766142d-02,
     |   3.0021771894948d-03,-1.3111146205548d-02,-2.6186704919922d-02,
     |  -3.3477283583950d-02,-3.3560093809539d-02,-2.6606536192145d-02,
     |  -1.4287040170834d-02, 6.5340228514103d-04, 1.5037530096169d-02,
     |   2.5959963940241d-02, 3.1389766859128d-02, 3.0541639496529d-02,
     |   2.3946669375038d-02, 1.3229291682889d-02, 6.6431583359553d-04,
     |  -1.1365022272223d-02,-2.0874960225427d-02,-2.6640906898946d-02,
     |  -2.8342692723858d-02,-2.6486597702217d-02,-2.2152561675814d-02,
     |  -1.6651280655259d-02,-1.1189827005754d-02,-6.6275058445979d-03,
     |  -3.3704053146289d-03,-1.4061601514690d-03,-4.4293557082714d-04,
     |  -8.8735834046349d-05,-7.2745676171616d-06,-1.4890183295780d-08/
      data (zmn(lat, 5,11), lat = 1,72)/
     |   4.1013522901012d-09, 5.0267489286338d-07, 1.0395172366734d-05,
     |   7.3647306108284d-05, 3.0654929449874d-04, 9.2128877435530d-04,
     |   2.2119580331468d-03, 4.4898629870531d-03, 7.9736957490501d-03,
     |   1.2660143239551d-02, 1.8215405908959d-02, 2.3931597124489d-02,
     |   2.8781492675802d-02, 3.1581668539341d-02, 3.1243327895361d-02,
     |   2.7060245224410d-02, 1.8963343426588d-02, 7.6684343808768d-03,
     |  -5.3393636023724d-03,-1.8006488704598d-02,-2.8074335915778d-02,
     |  -3.3538526987886d-02,-3.3105831709917d-02,-2.6540719380108d-02,
     |  -1.4809802028840d-02, 2.7223702474675d-05, 1.5175499771281d-02,
     |   2.7648273409909d-02, 3.4884581440484d-02, 3.5306700409921d-02,
     |   2.8689629614902d-02, 1.6252147645694d-02, 4.3892536225212d-04,
     |  -1.5567690031595d-02,-2.8505367251049d-02,-3.5717617169840d-02,
     |  -3.5717617169840d-02,-2.8505367251049d-02,-1.5567690031595d-02,
     |   4.3892536225208d-04, 1.6252147645694d-02, 2.8689629614902d-02,
     |   3.5306700409921d-02, 3.4884581440484d-02, 2.7648273409909d-02,
     |   1.5175499771281d-02, 2.7223702474748d-05,-1.4809802028839d-02,
     |  -2.6540719380108d-02,-3.3105831709917d-02,-3.3538526987886d-02,
     |  -2.8074335915778d-02,-1.8006488704598d-02,-5.3393636023725d-03,
     |   7.6684343808767d-03, 1.8963343426588d-02, 2.7060245224409d-02,
     |   3.1243327895361d-02, 3.1581668539341d-02, 2.8781492675802d-02,
     |   2.3931597124489d-02, 1.8215405908959d-02, 1.2660143239551d-02,
     |   7.9736957490500d-03, 4.4898629870531d-03, 2.2119580331468d-03,
     |   9.2128877435538d-04, 3.0654929449875d-04, 7.3647306108298d-05,
     |   1.0395172366713d-05, 5.0267489292997d-07, 4.1013523387156d-09/
      data (zmn(lat, 6,11), lat = 1,72)/
     |   7.5035923234748d-11, 2.7794045386295d-08, 9.6437432645262d-07,
     |   9.6638081753585d-06, 5.2446235568113d-05, 1.9615867775124d-04,
     |   5.6931294090110d-04, 1.3708807956483d-03, 2.8538578973145d-03,
     |   5.2758089637642d-03, 8.8186505528601d-03, 1.3492208515529d-02,
     |   1.9046813815331d-02, 2.4925313358439d-02, 3.0281590549410d-02,
     |   3.4080302723709d-02, 3.5273124516921d-02, 3.3024717005151d-02,
     |   2.6942804997346d-02, 1.7256830957824d-02, 4.8927169605703d-03,
     |  -8.5917426952891d-03,-2.1217988609268d-02,-3.0917635846900d-02,
     |  -3.5925177846744d-02,-3.5153441345904d-02,-2.8468376757269d-02,
     |  -1.6794460840204d-02,-2.0137790360320d-03, 1.3335479699501d-02,
     |   2.6511129684756d-02, 3.5084007830517d-02, 3.7415751251947d-02,
     |   3.2996931697645d-02, 2.2571166335279d-02, 8.0139550722212d-03,
     |  -8.0139550722212d-03,-2.2571166335279d-02,-3.2996931697645d-02,
     |  -3.7415751251947d-02,-3.5084007830517d-02,-2.6511129684756d-02,
     |  -1.3335479699501d-02, 2.0137790360319d-03, 1.6794460840204d-02,
     |   2.8468376757269d-02, 3.5153441345904d-02, 3.5925177846744d-02,
     |   3.0917635846900d-02, 2.1217988609268d-02, 8.5917426952892d-03,
     |  -4.8927169605701d-03,-1.7256830957824d-02,-2.6942804997346d-02,
     |  -3.3024717005151d-02,-3.5273124516921d-02,-3.4080302723709d-02,
     |  -3.0281590549410d-02,-2.4925313358439d-02,-1.9046813815331d-02,
     |  -1.3492208515529d-02,-8.8186505528602d-03,-5.2758089637642d-03,
     |  -2.8538578973145d-03,-1.3708807956484d-03,-5.6931294090108d-04,
     |  -1.9615867775118d-04,-5.2446235568143d-05,-9.6638081753436d-06,
     |  -9.6437432636154d-07,-2.7794045413694d-08,-7.5035916296735d-11/
      data (zmn(lat, 7,11), lat = 1,72)/
     |  -1.6387610987816d-11, 1.2538092908198d-09, 7.1844285457931d-08,
     |   1.0161354244584d-06, 7.1661704086254d-06, 3.3209363704102d-05,
     |   1.1584577194542d-04, 3.2849969579165d-04, 7.9413449370314d-04,
     |   1.6887697106974d-03, 3.2279339101292d-03, 5.6308886952177d-03,
     |   9.0630145524649d-03, 1.3564188827971d-02, 1.8978345846960d-02,
     |   2.4904311675762d-02, 3.0688333853136d-02, 3.5473317929591d-02,
     |   3.8308930563275d-02, 3.8312325857514d-02, 3.4854491598510d-02,
     |   2.7735894882281d-02, 1.7310690558211d-02, 4.5234002376259d-03,
     |  -9.1641816829454d-03,-2.1957174965928d-02,-3.2000316897445d-02,
     |  -3.7694979787220d-02,-3.8002148210472d-02,-3.2670222122194d-02,
     |  -2.2336671307031d-02,-8.4743695725502d-03, 6.8171422724013d-03,
     |   2.1144146185205d-02, 3.2217580594766d-02, 3.8245495962641d-02,
     |   3.8245495962641d-02, 3.2217580594766d-02, 2.1144146185205d-02,
     |   6.8171422724013d-03,-8.4743695725502d-03,-2.2336671307031d-02,
     |  -3.2670222122194d-02,-3.8002148210472d-02,-3.7694979787220d-02,
     |  -3.2000316897445d-02,-2.1957174965928d-02,-9.1641816829454d-03,
     |   4.5234002376259d-03, 1.7310690558211d-02, 2.7735894882281d-02,
     |   3.4854491598510d-02, 3.8312325857514d-02, 3.8308930563275d-02,
     |   3.5473317929591d-02, 3.0688333853136d-02, 2.4904311675762d-02,
     |   1.8978345846960d-02, 1.3564188827971d-02, 9.0630145524649d-03,
     |   5.6308886952176d-03, 3.2279339101292d-03, 1.6887697106975d-03,
     |   7.9413449370317d-04, 3.2849969579167d-04, 1.1584577194541d-04,
     |   3.3209363704091d-05, 7.1661704086653d-06, 1.0161354244728d-06,
     |   7.1844285518545d-08, 1.2538092342349d-09,-1.6387628100634d-11/
      data (zmn(lat, 8,11), lat = 1,72)/
     |  -1.9427717584135d-13, 4.4814523222701d-11, 4.2978593450797d-09,
     |   8.5639323379859d-08, 7.8315406795532d-07, 4.4840344608619d-06,
     |   1.8732692166424d-05, 6.2273371131485d-05, 1.7384159992442d-04,
     |   4.2230579866464d-04, 9.1506709437678d-04, 1.8002525327560d-03,
     |   3.2578708290251d-03, 5.4762819327678d-03, 8.6132276811748d-03,
     |   1.2744923727717d-02, 1.7811435231356d-02, 2.3570491842274d-02,
     |   2.9573710356900d-02, 3.5177856019438d-02, 3.9598902582407d-02,
     |   4.2008730396875d-02, 4.1664694462798d-02, 3.8053024913938d-02,
     |   3.1020353363836d-02, 2.0865556093343d-02, 8.3677170267278d-03,
     |  -5.2647031951020d-03,-1.8524803080177d-02,-2.9804142203442d-02,
     |  -3.7627293633210d-02,-4.0885935213624d-02,-3.9031343397613d-02,
     |  -3.2188992574060d-02,-2.1171144617400d-02,-7.3807375088693d-03,
     |   7.3807375088693d-03, 2.1171144617400d-02, 3.2188992574060d-02,
     |   3.9031343397613d-02, 4.0885935213624d-02, 3.7627293633210d-02,
     |   2.9804142203442d-02, 1.8524803080177d-02, 5.2647031951021d-03,
     |  -8.3677170267277d-03,-2.0865556093343d-02,-3.1020353363836d-02,
     |  -3.8053024913938d-02,-4.1664694462798d-02,-4.2008730396875d-02,
     |  -3.9598902582407d-02,-3.5177856019438d-02,-2.9573710356900d-02,
     |  -2.3570491842274d-02,-1.7811435231356d-02,-1.2744923727717d-02,
     |  -8.6132276811748d-03,-5.4762819327677d-03,-3.2578708290251d-03,
     |  -1.8002525327560d-03,-9.1506709437676d-04,-4.2230579866463d-04,
     |  -1.7384159992439d-04,-6.2273371131456d-05,-1.8732692166434d-05,
     |  -4.4840344609028d-06,-7.8315406790117d-07,-8.5639323367039d-08,
     |  -4.2978593610551d-09,-4.4814467500368d-11, 1.9429448183084d-13/
      data (zmn(lat, 9,11), lat = 1,72)/
     |   5.5428656858559d-14, 1.2072465024770d-12, 2.0289530125167d-10,
     |   5.6879459906017d-09, 6.7348177861227d-08, 4.7550696257446d-07,
     |   2.3732684624577d-06, 9.2214464140248d-06, 2.9618370357168d-05,
     |   8.1830192834732d-05, 1.9993433334400d-04, 4.4073045318537d-04,
     |   8.8966950416060d-04, 1.6632533270679d-03, 2.9049934024905d-03,
     |   4.7723905090460d-03, 7.4136772929824d-03, 1.0935200117671d-02,
     |   1.5362986984646d-02, 2.0604699308609d-02, 2.6420105404655d-02,
     |   3.2408773805096d-02, 3.8022399378987d-02, 4.2605939575096d-02,
     |   4.5466895956118d-02, 4.5966408641727d-02, 4.3620434508953d-02,
     |   3.8195351110769d-02, 2.9780901949521d-02, 1.8825093786713d-02,
     |   6.1204940594177d-03,-7.2612821270102d-03,-2.0081475686790d-02,
     |  -3.1078713726622d-02,-3.9125967119441d-02,-4.3376545430817d-02,
     |  -4.3376545430817d-02,-3.9125967119441d-02,-3.1078713726622d-02,
     |  -2.0081475686791d-02,-7.2612821270102d-03, 6.1204940594177d-03,
     |   1.8825093786713d-02, 2.9780901949521d-02, 3.8195351110769d-02,
     |   4.3620434508953d-02, 4.5966408641727d-02, 4.5466895956118d-02,
     |   4.2605939575096d-02, 3.8022399378987d-02, 3.2408773805096d-02,
     |   2.6420105404655d-02, 2.0604699308609d-02, 1.5362986984646d-02,
     |   1.0935200117671d-02, 7.4136772929825d-03, 4.7723905090461d-03,
     |   2.9049934024905d-03, 1.6632533270680d-03, 8.8966950416062d-04,
     |   4.4073045318539d-04, 1.9993433334406d-04, 8.1830192834715d-05,
     |   2.9618370357156d-05, 9.2214464140280d-06, 2.3732684624768d-06,
     |   4.7550696257862d-07, 6.7348177879213d-08, 5.6879459651223d-09,
     |   2.0289527254809d-10, 1.2072741741761d-12, 5.5454540225653d-14/
      data (zmn(lat,10,11), lat = 1,72)/
     |   2.2434410030029d-16, 2.5487420962073d-14, 7.2044885532049d-12,
     |   2.8401731525021d-10, 4.3495296425764d-09, 3.7816811210969d-08,
     |   2.2510711162035d-07, 1.0201977567680d-06, 3.7606795126585d-06,
     |   1.1781374141449d-05, 3.2342252485821d-05, 7.9547001942692d-05,
     |   1.7821735746194d-04, 3.6834119996096d-04, 7.0927462493596d-04,
     |   1.2824462133986d-03, 2.1910201604273d-03, 3.5549668740907d-03,
     |   5.5003766766227d-03, 8.1426730666281d-03, 1.1564572294915d-02,
     |   1.5791019636163d-02, 2.0764641141699d-02, 2.6326169015801d-02,
     |   3.2204537260249d-02, 3.8020705357569d-02, 4.3307712113145d-02,
     |   4.7547140764165d-02, 5.0219426263034d-02, 5.0862728262939d-02,
     |   4.9132951718328d-02, 4.4856390211649d-02, 3.8066707538422d-02,
     |   2.9019638986242d-02, 1.8181695866421d-02, 6.1928591481818d-03,
     |  -6.1928591481818d-03,-1.8181695866421d-02,-2.9019638986242d-02,
     |  -3.8066707538421d-02,-4.4856390211649d-02,-4.9132951718328d-02,
     |  -5.0862728262939d-02,-5.0219426263034d-02,-4.7547140764165d-02,
     |  -4.3307712113145d-02,-3.8020705357569d-02,-3.2204537260249d-02,
     |  -2.6326169015801d-02,-2.0764641141699d-02,-1.5791019636163d-02,
     |  -1.1564572294915d-02,-8.1426730666281d-03,-5.5003766766227d-03,
     |  -3.5549668740908d-03,-2.1910201604273d-03,-1.2824462133986d-03,
     |  -7.0927462493598d-04,-3.6834119996098d-04,-1.7821735746192d-04,
     |  -7.9547001942697d-05,-3.2342252485791d-05,-1.1781374141466d-05,
     |  -3.7606795127019d-06,-1.0201977567867d-06,-2.2510711164523d-07,
     |  -3.7816811209096d-08,-4.3495296947889d-09,-2.8401731280187d-10,
     |  -7.2044923811306d-12,-2.5506983080210d-14,-2.4918016810411d-16/
      data (zmn(lat,11,11), lat = 1,72)/
     |  -8.9098899965410d-17, 4.1610422538234d-16, 1.6809979340426d-13,
     |   9.3199896446441d-12, 1.8445584778977d-10, 1.9728986625958d-09,
     |   1.3988682931724d-08, 7.3833641035186d-08, 3.1179502073536d-07,
     |   1.1052173104091d-06, 3.4004307287413d-06, 9.3042881314821d-06,
     |   2.3056580232274d-05, 5.2472474484669d-05, 1.1087752096473d-04,
     |   2.1944150724847d-04, 4.0965944364581d-04, 7.2555197807988d-04,
     |   1.2250019465533d-03, 1.9795556712325d-03, 3.0720429029865d-03,
     |   4.5915403822208d-03, 6.6255281373003d-03, 9.2495390722213d-03,
     |   1.2515120847399d-02, 1.6437426346655d-02, 2.0984123328891d-02,
     |   2.6067469473783d-02, 3.1541267710404d-02, 3.7203975981270d-02,
     |   4.2808529407800d-02, 4.8078531527389d-02, 5.2729519701602d-02,
     |   5.6493165131374d-02, 5.9141681210952d-02, 6.0509500907622d-02,
     |   6.0509500907622d-02, 5.9141681210952d-02, 5.6493165131374d-02,
     |   5.2729519701602d-02, 4.8078531527389d-02, 4.2808529407800d-02,
     |   3.7203975981270d-02, 3.1541267710404d-02, 2.6067469473783d-02,
     |   2.0984123328891d-02, 1.6437426346655d-02, 1.2515120847399d-02,
     |   9.2495390722213d-03, 6.6255281373003d-03, 4.5915403822208d-03,
     |   3.0720429029865d-03, 1.9795556712325d-03, 1.2250019465533d-03,
     |   7.2555197807991d-04, 4.0965944364580d-04, 2.1944150724847d-04,
     |   1.1087752096472d-04, 5.2472474484645d-05, 2.3056580232256d-05,
     |   9.3042881314716d-06, 3.4004307287221d-06, 1.1052173104090d-06,
     |   3.1179502073285d-07, 7.3833641043024d-08, 1.3988682932471d-08,
     |   1.9728986723365d-09, 1.8445583320049d-10, 9.3200101891988d-12,
     |   1.6810050050029d-13, 4.2186259357781d-16,-1.0080316041172d-16/
      data (zmn(lat, 0,12), lat = 1,72)/
     |   2.8663360050738d-03, 8.7221185298185d-03, 9.6903569952452d-03,
     |   6.6199315598517d-03,-8.7510477809544d-04,-9.5092673397874d-03,
     |  -1.6843229971103d-02,-1.9430940472332d-02,-1.6249749962592d-02,
     |  -7.2777861306353d-03, 4.7571717046809d-03, 1.6581077895486d-02,
     |   2.4118242848632d-02, 2.4938905451357d-02, 1.8090299910829d-02,
     |   5.4317469711114d-03,-9.6716444630406d-03,-2.2548544832261d-02,
     |  -2.9338330060150d-02,-2.7567151860005d-02,-1.7565189049789d-02,
     |  -1.9162918192867d-03, 1.4756497738573d-02, 2.7597441255900d-02,
     |   3.2569706067594d-02, 2.8079491301125d-02, 1.5170617441841d-02,
     |  -2.4252658390559d-03,-1.9637904105863d-02,-3.1312567503152d-02,
     |  -3.3969615459019d-02,-2.6680302553373d-02,-1.1530621759974d-02,
     |   7.1048980770473d-03, 2.3745899420482d-02, 3.3508768611742d-02,
     |   3.3508768611742d-02, 2.3745899420482d-02, 7.1048980770473d-03,
     |  -1.1530621759974d-02,-2.6680302553373d-02,-3.3969615459019d-02,
     |  -3.1312567503152d-02,-1.9637904105863d-02,-2.4252658390559d-03,
     |   1.5170617441841d-02, 2.8079491301125d-02, 3.2569706067594d-02,
     |   2.7597441255900d-02, 1.4756497738573d-02,-1.9162918192867d-03,
     |  -1.7565189049789d-02,-2.7567151860005d-02,-2.9338330060150d-02,
     |  -2.2548544832261d-02,-9.6716444630406d-03, 5.4317469711113d-03,
     |   1.8090299910829d-02, 2.4938905451357d-02, 2.4118242848632d-02,
     |   1.6581077895486d-02, 4.7571717046808d-03,-7.2777861306353d-03,
     |  -1.6249749962592d-02,-1.9430940472332d-02,-1.6843229971103d-02,
     |  -9.5092673397875d-03,-8.7510477809555d-04, 6.6199315598518d-03,
     |   9.6903569952452d-03, 8.7221185298186d-03, 2.8663360050738d-03/
      data (zmn(lat, 1,12), lat = 1,72)/
     |   5.1987431760056d-04, 3.7661122513732d-03, 9.0058419178494d-03,
     |   1.3651487006918d-02, 1.5360016105027d-02, 1.2522420274621d-02,
     |   5.2037362740449d-03,-4.9405988127126d-03,-1.4936273337519d-02,
     |  -2.1569425125186d-02,-2.2320711288735d-02,-1.6406976683474d-02,
     |  -5.0465936218478d-03, 8.6600941486408d-03, 2.0717063400902d-02,
     |   2.7319940828687d-02, 2.6178559040805d-02, 1.7193725594959d-02,
     |   2.7106225962376d-03,-1.3206025729116d-02,-2.5831607345058d-02,
     |  -3.1308495455531d-02,-2.7736616744083d-02,-1.5922262514146d-02,
     |   8.9550890453691d-04, 1.7844683273451d-02, 2.9952170683926d-02,
     |   3.3522443985517d-02, 2.7375776985530d-02, 1.3136263523077d-02,
     |  -5.1009655732020d-03,-2.2062117031751d-02,-3.2740114300413d-02,
     |  -3.3989016327505d-02,-2.5362713077299d-02,-9.3686782695207d-03,
     |   9.3686782695206d-03, 2.5362713077299d-02, 3.3989016327505d-02,
     |   3.2740114300413d-02, 2.2062117031751d-02, 5.1009655732020d-03,
     |  -1.3136263523077d-02,-2.7375776985530d-02,-3.3522443985517d-02,
     |  -2.9952170683926d-02,-1.7844683273451d-02,-8.9550890453708d-04,
     |   1.5922262514146d-02, 2.7736616744083d-02, 3.1308495455531d-02,
     |   2.5831607345058d-02, 1.3206025729116d-02,-2.7106225962376d-03,
     |  -1.7193725594959d-02,-2.6178559040805d-02,-2.7319940828687d-02,
     |  -2.0717063400902d-02,-8.6600941486407d-03, 5.0465936218477d-03,
     |   1.6406976683474d-02, 2.2320711288735d-02, 2.1569425125186d-02,
     |   1.4936273337519d-02, 4.9405988127127d-03,-5.2037362740449d-03,
     |  -1.2522420274621d-02,-1.5360016105027d-02,-1.3651487006918d-02,
     |  -9.0058419178494d-03,-3.7661122513732d-03,-5.1987431760060d-04/
      data (zmn(lat, 2,12), lat = 1,72)/
     |   3.4994140753987d-05, 7.8816621628720d-04, 3.3164813062672d-03,
     |   7.7621540053275d-03, 1.3224986187448d-02, 1.7900432485677d-02,
     |   1.9760685900809d-02, 1.7270166655936d-02, 1.0113208674326d-02,
     |  -5.2981622527489d-04,-1.2123287051148d-02,-2.1471594567904d-02,
     |  -2.5647759322360d-02,-2.2981468752824d-02,-1.3681140437264d-02,
     |   4.4139690996054d-05, 1.4522267833159d-02, 2.5610105467527d-02,
     |   2.9927207186474d-02, 2.5896678290018d-02, 1.4321496797390d-02,
     |  -1.7563355112413d-03,-1.7852288358624d-02,-2.9321037291044d-02,
     |  -3.2712348960565d-02,-2.6833086165200d-02,-1.3153610846578d-02,
     |   4.5497378881725d-03, 2.1255871862663d-02, 3.2138169322622d-02,
     |   3.3983408542290d-02, 2.6149726019378d-02, 1.0790026535165d-02,
     |  -7.7486060859827d-03,-2.4168825417444d-02,-3.3758164227620d-02,
     |  -3.3758164227620d-02,-2.4168825417444d-02,-7.7486060859828d-03,
     |   1.0790026535165d-02, 2.6149726019377d-02, 3.3983408542290d-02,
     |   3.2138169322622d-02, 2.1255871862663d-02, 4.5497378881726d-03,
     |  -1.3153610846578d-02,-2.6833086165200d-02,-3.2712348960565d-02,
     |  -2.9321037291044d-02,-1.7852288358624d-02,-1.7563355112413d-03,
     |   1.4321496797390d-02, 2.5896678290018d-02, 2.9927207186474d-02,
     |   2.5610105467527d-02, 1.4522267833159d-02, 4.4139690996204d-05,
     |  -1.3681140437264d-02,-2.2981468752824d-02,-2.5647759322360d-02,
     |  -2.1471594567904d-02,-1.2123287051148d-02,-5.2981622527493d-04,
     |   1.0113208674326d-02, 1.7270166655936d-02, 1.9760685900809d-02,
     |   1.7900432485677d-02, 1.3224986187449d-02, 7.7621540053274d-03,
     |   3.3164813062673d-03, 7.8816621628719d-04, 3.4994140753982d-05/
      data (zmn(lat, 3,12), lat = 1,72)/
     |   6.0684697601996d-07, 1.0780032622022d-04, 7.6869946867001d-04,
     |   2.6349758055167d-03, 6.1545113562010d-03, 1.1199810284164d-02,
     |   1.6872948138048d-02, 2.1618578587883d-02, 2.3631243053255d-02,
     |   2.1458286450278d-02, 1.4590976273256d-02, 3.8384453716644d-03,
     |  -8.6870622426314d-03,-2.0011482392459d-02,-2.7081804583886d-02,
     |  -2.7667429996996d-02,-2.1113427082914d-02,-8.6876649177752d-03,
     |   6.6138018792081d-03, 2.0794674617152d-02, 2.9931339896230d-02,
     |   3.1299020564314d-02, 2.4211749383131d-02, 1.0318593509637d-02,
     |  -6.7651266874165d-03,-2.2406382330502d-02,-3.2235587482969d-02,
     |  -3.3392201258508d-02,-2.5378265519188d-02,-1.0254455896805d-02,
     |   7.8880048282774d-03, 2.4049565500239d-02, 3.3719755585650d-02,
     |   3.4158484802292d-02, 2.5184871814036d-02, 9.2486158976200d-03,
     |  -9.2486158976200d-03,-2.5184871814036d-02,-3.4158484802292d-02,
     |  -3.3719755585650d-02,-2.4049565500239d-02,-7.8880048282773d-03,
     |   1.0254455896805d-02, 2.5378265519188d-02, 3.3392201258508d-02,
     |   3.2235587482969d-02, 2.2406382330502d-02, 6.7651266874167d-03,
     |  -1.0318593509637d-02,-2.4211749383131d-02,-3.1299020564314d-02,
     |  -2.9931339896230d-02,-2.0794674617152d-02,-6.6138018792081d-03,
     |   8.6876649177751d-03, 2.1113427082914d-02, 2.7667429996996d-02,
     |   2.7081804583886d-02, 2.0011482392459d-02, 8.6870622426314d-03,
     |  -3.8384453716644d-03,-1.4590976273256d-02,-2.1458286450278d-02,
     |  -2.3631243053255d-02,-2.1618578587883d-02,-1.6872948138048d-02,
     |  -1.1199810284164d-02,-6.1545113562012d-03,-2.6349758055167d-03,
     |  -7.6869946867001d-04,-1.0780032622026d-04,-6.0684697598336d-07/
      data (zmn(lat, 4,12), lat = 1,72)/
     |   2.1861897935498d-08, 1.0670737725039d-05, 1.2895255163092d-04,
     |   6.3454604393112d-04, 1.9751088849988d-03, 4.6134242703928d-03,
     |   8.7777000531251d-03, 1.4215446041141d-02, 2.0063294962577d-02,
     |   2.4923491600476d-02, 2.7168030504919d-02, 2.5411767139972d-02,
     |   1.9019502027180d-02, 8.4800004488175d-03,-4.5035553470045d-03,
     |  -1.7282095092543d-02,-2.6858809051576d-02,-3.0676328650551d-02,
     |  -2.7378202939874d-02,-1.7312884272740d-02,-2.6052141351155d-03,
     |   1.3266898819605d-02, 2.6309620673270d-02, 3.3056107426307d-02,
     |   3.1531424900865d-02, 2.1861366485336d-02, 6.3330584823827d-03,
     |  -1.1136500478526d-02,-2.6001401825014d-02,-3.4295471224938d-02,
     |  -3.3718963285036d-02,-2.4297169111376d-02,-8.4174680090643d-03,
     |   9.7788170517575d-03, 2.5492587225796d-02, 3.4555174451687d-02,
     |   3.4555174451687d-02, 2.5492587225796d-02, 9.7788170517575d-03,
     |  -8.4174680090643d-03,-2.4297169111376d-02,-3.3718963285036d-02,
     |  -3.4295471224938d-02,-2.6001401825014d-02,-1.1136500478526d-02,
     |   6.3330584823827d-03, 2.1861366485336d-02, 3.1531424900865d-02,
     |   3.3056107426307d-02, 2.6309620673270d-02, 1.3266898819605d-02,
     |  -2.6052141351153d-03,-1.7312884272740d-02,-2.7378202939874d-02,
     |  -3.0676328650551d-02,-2.6858809051576d-02,-1.7282095092543d-02,
     |  -4.5035553470044d-03, 8.4800004488175d-03, 1.9019502027180d-02,
     |   2.5411767139972d-02, 2.7168030504919d-02, 2.4923491600476d-02,
     |   2.0063294962577d-02, 1.4215446041141d-02, 8.7777000531250d-03,
     |   4.6134242703928d-03, 1.9751088849987d-03, 6.3454604393117d-04,
     |   1.2895255163087d-04, 1.0670737725065d-05, 2.1861897931352d-08/
      data (zmn(lat, 5,12), lat = 1,72)/
     |   7.2592128376743d-09, 8.1260954910829d-07, 1.6688236854136d-05,
     |   1.1684486913054d-04, 4.7861468451689d-04, 1.4089462900307d-03,
     |   3.2964918341813d-03, 6.4823493571130d-03, 1.1075880613158d-02,
     |   1.6776399626185d-02, 2.2778284668385d-02, 2.7825266839001d-02,
     |   3.0440094445747d-02, 2.9297804517753d-02, 2.3653463063297d-02,
     |   1.3698059740963d-02, 7.1580601528507d-04,-1.3043038508767d-02,
     |  -2.4784777598302d-02,-3.1812934636851d-02,-3.2233499542463d-02,
     |  -2.5533228722137d-02,-1.2854284494940d-02, 3.1426287046945d-03,
     |   1.8828034620561d-02, 3.0451623165087d-02, 3.5081690610797d-02,
     |   3.1389478489060d-02, 2.0059181523763d-02, 3.6944545125298d-03,
     |  -1.3776869706245d-02,-2.8062158873912d-02,-3.5586153080141d-02,
     |  -3.4414066450675d-02,-2.4768865868490d-02,-8.9994542435788d-03,
     |   8.9994542435788d-03, 2.4768865868490d-02, 3.4414066450675d-02,
     |   3.5586153080141d-02, 2.8062158873912d-02, 1.3776869706245d-02,
     |  -3.6944545125297d-03,-2.0059181523763d-02,-3.1389478489060d-02,
     |  -3.5081690610797d-02,-3.0451623165087d-02,-1.8828034620561d-02,
     |  -3.1426287046946d-03, 1.2854284494940d-02, 2.5533228722137d-02,
     |   3.2233499542463d-02, 3.1812934636851d-02, 2.4784777598302d-02,
     |   1.3043038508767d-02,-7.1580601528506d-04,-1.3698059740963d-02,
     |  -2.3653463063297d-02,-2.9297804517753d-02,-3.0440094445747d-02,
     |  -2.7825266839001d-02,-2.2778284668385d-02,-1.6776399626185d-02,
     |  -1.1075880613158d-02,-6.4823493571130d-03,-3.2964918341812d-03,
     |  -1.4089462900307d-03,-4.7861468451683d-04,-1.1684486913051d-04,
     |  -1.6688236854127d-05,-8.1260954908307d-07,-7.2592128858721d-09/
      data (zmn(lat, 6,12), lat = 1,72)/
     |   1.3580687680996d-10, 5.0004641896273d-08, 1.7236608178626d-06,
     |   1.7100569007739d-05, 9.1556436262872d-05, 3.3655729482706d-04,
     |   9.5613491950518d-04, 2.2436480970812d-03, 4.5291345854615d-03,
     |   8.0728463449224d-03, 1.2923580073000d-02, 1.8782957939183d-02,
     |   2.4929551188242d-02, 3.0252171390071d-02, 3.3417674835143d-02,
     |   3.3159681425392d-02, 2.8631427263210d-02, 1.9732352329042d-02,
     |   7.3068577835818d-03,-6.8677853616835d-03,-2.0340316074285d-02,
     |  -3.0461957716468d-02,-3.4985377891699d-02,-3.2643926369147d-02,
     |  -2.3556614790959d-02,-9.3340394378811d-03, 7.1721857085832d-03,
     |   2.2444583868256d-02, 3.3079598275217d-02, 3.6589744046703d-02,
     |   3.2028186662090d-02, 2.0270175645990d-02, 3.8656099003099d-03,
     |  -1.3517106912895d-02,-2.7931158481372d-02,-3.6075172441195d-02,
     |  -3.6075172441195d-02,-2.7931158481372d-02,-1.3517106912895d-02,
     |   3.8656099003099d-03, 2.0270175645990d-02, 3.2028186662090d-02,
     |   3.6589744046703d-02, 3.3079598275217d-02, 2.2444583868256d-02,
     |   7.1721857085833d-03,-9.3340394378810d-03,-2.3556614790959d-02,
     |  -3.2643926369147d-02,-3.4985377891699d-02,-3.0461957716468d-02,
     |  -2.0340316074285d-02,-6.8677853616836d-03, 7.3068577835818d-03,
     |   1.9732352329042d-02, 2.8631427263210d-02, 3.3159681425392d-02,
     |   3.3417674835143d-02, 3.0252171390071d-02, 2.4929551188242d-02,
     |   1.8782957939183d-02, 1.2923580073000d-02, 8.0728463449224d-03,
     |   4.5291345854615d-03, 2.2436480970812d-03, 9.5613491950519d-04,
     |   3.3655729482708d-04, 9.1556436262962d-05, 1.7100569007688d-05,
     |   1.7236608178888d-06, 5.0004641861231d-08, 1.3580687012787d-10/
      data (zmn(lat, 7,12), lat = 1,72)/
     |  -3.7995767738618d-11, 2.5446890708668d-09, 1.4470366079098d-07,
     |   2.0289610545938d-06, 1.4141821579696d-05, 6.4564894819047d-05,
     |   2.2114485586949d-04, 6.1352855888146d-04, 1.4454664165301d-03,
     |   2.9828986384252d-03, 5.5063313262540d-03, 9.2257341101683d-03,
     |   1.4170762520408d-02, 2.0084131342177d-02, 2.6355715347397d-02,
     |   3.2034319460646d-02, 3.5940518771981d-02, 3.6878998012636d-02,
     |   3.3918078691604d-02, 2.6676274083703d-02, 1.5540036586376d-02,
     |   1.7403822228652d-03,-1.2758995537685d-02,-2.5567085789588d-02,
     |  -3.4319068053281d-02,-3.7187616831681d-02,-3.3335050915130d-02,
     |  -2.3190555222466d-02,-8.4681988316679d-03, 8.1023194121689d-03,
     |   2.3292135584103d-02, 3.4033731012221d-02, 3.8080949267749d-02,
     |   3.4516237036855d-02, 2.3982345356659d-02, 8.5765654268369d-03,
     |  -8.5765654268369d-03,-2.3982345356659d-02,-3.4516237036855d-02,
     |  -3.8080949267749d-02,-3.4033731012221d-02,-2.3292135584103d-02,
     |  -8.1023194121690d-03, 8.4681988316678d-03, 2.3190555222466d-02,
     |   3.3335050915130d-02, 3.7187616831681d-02, 3.4319068053281d-02,
     |   2.5567085789588d-02, 1.2758995537685d-02,-1.7403822228652d-03,
     |  -1.5540036586376d-02,-2.6676274083703d-02,-3.3918078691604d-02,
     |  -3.6878998012637d-02,-3.5940518771981d-02,-3.2034319460646d-02,
     |  -2.6355715347397d-02,-2.0084131342177d-02,-1.4170762520408d-02,
     |  -9.2257341101684d-03,-5.5063313262540d-03,-2.9828986384252d-03,
     |  -1.4454664165301d-03,-6.1352855888146d-04,-2.2114485586950d-04,
     |  -6.4564894819017d-05,-1.4141821579687d-05,-2.0289610545601d-06,
     |  -1.4470366074383d-07,-2.5446890496359d-09, 3.7995817693762d-11/
      data (zmn(lat, 8,12), lat = 1,72)/
     |  -4.5393784334636d-13, 1.0417939389416d-10, 9.9399404664461d-09,
     |   1.9654285775363d-07, 1.7787932011961d-06, 1.0051838493533d-05,
     |   4.1326538119832d-05, 1.3479479660514d-04, 3.6802271983293d-04,
     |   8.7137262839381d-04, 1.8334220594269d-03, 3.4880985397051d-03,
     |   6.0762946537894d-03, 9.7807571798693d-03, 1.4642211553908d-02,
     |   2.0474657344776d-02, 2.6805231142246d-02, 3.2865638428843d-02,
     |   3.7655706123235d-02, 4.0085038411521d-02, 3.9178591826949d-02,
     |   3.4311012043057d-02, 2.5418758216882d-02, 1.3133891678035d-02,
     |  -1.2077376844529d-03,-1.5708437482975d-02,-2.8192681610732d-02,
     |  -3.6589897039708d-02,-3.9343738535533d-02,-3.5760901013368d-02,
     |  -2.6217376468718d-02,-1.2165003157709d-02, 4.0783642268638d-03,
     |   1.9724520665777d-02, 3.2022956826792d-02, 3.8779741762469d-02,
     |   3.8779741762469d-02, 3.2022956826792d-02, 1.9724520665777d-02,
     |   4.0783642268639d-03,-1.2165003157709d-02,-2.6217376468718d-02,
     |  -3.5760901013368d-02,-3.9343738535533d-02,-3.6589897039708d-02,
     |  -2.8192681610732d-02,-1.5708437482975d-02,-1.2077376844530d-03,
     |   1.3133891678035d-02, 2.5418758216882d-02, 3.4311012043058d-02,
     |   3.9178591826949d-02, 4.0085038411521d-02, 3.7655706123235d-02,
     |   3.2865638428843d-02, 2.6805231142246d-02, 2.0474657344776d-02,
     |   1.4642211553908d-02, 9.7807571798693d-03, 6.0762946537894d-03,
     |   3.4880985397051d-03, 1.8334220594268d-03, 8.7137262839378d-04,
     |   3.6802271983294d-04, 1.3479479660510d-04, 4.1326538119815d-05,
     |   1.0051838493522d-05, 1.7787932011767d-06, 1.9654285777206d-07,
     |   9.9399404662281d-09, 1.0417940936230d-10,-4.5391718748688d-13/
      data (zmn(lat, 9,12), lat = 1,72)/
     |   1.7926420921292d-13, 3.2950310923614d-12, 5.5569590931564d-10,
     |   1.5470144729087d-08, 1.8148042842999d-07, 1.2663917272923d-06,
     |   6.2312403081937d-06, 2.3807256632442d-05, 7.4983753668070d-05,
     |   2.0256432459637d-04, 4.8244496953761d-04, 1.0332709021333d-03,
     |   2.0192960145117d-03, 3.6404949730004d-03, 6.1050989278074d-03,
     |   9.5831602818975d-03, 1.4145204544218d-02, 1.9696381762628d-02,
     |   2.5922011242354d-02, 3.2263015624054d-02, 3.7937828657752d-02,
     |   4.2020274384757d-02, 4.3571380136521d-02, 4.1809272919619d-02,
     |   3.6288465406609d-02, 2.7051540372591d-02, 1.4715444898092d-02,
     |   4.6273410430913d-04,-1.4075534590597d-02,-2.7036850481536d-02,
     |  -3.6613358681130d-02,-4.1358140982853d-02,-4.0453883659075d-02,
     |  -3.3889171675639d-02,-2.2502751690384d-02,-7.8805924248613d-03,
     |   7.8805924248612d-03, 2.2502751690384d-02, 3.3889171675639d-02,
     |   4.0453883659075d-02, 4.1358140982853d-02, 3.6613358681130d-02,
     |   2.7036850481536d-02, 1.4075534590598d-02,-4.6273410430909d-04,
     |  -1.4715444898092d-02,-2.7051540372591d-02,-3.6288465406609d-02,
     |  -4.1809272919619d-02,-4.3571380136521d-02,-4.2020274384757d-02,
     |  -3.7937828657752d-02,-3.2263015624054d-02,-2.5922011242354d-02,
     |  -1.9696381762628d-02,-1.4145204544218d-02,-9.5831602818975d-03,
     |  -6.1050989278073d-03,-3.6404949730003d-03,-2.0192960145117d-03,
     |  -1.0332709021333d-03,-4.8244496953756d-04,-2.0256432459637d-04,
     |  -7.4983753668071d-05,-2.3807256632432d-05,-6.2312403081681d-06,
     |  -1.2663917272769d-06,-1.8148042838231d-07,-1.5470144716519d-08,
     |  -5.5569587596494d-10,-3.2950288467548d-12,-1.7925928014089d-13/
      data (zmn(lat,10,12), lat = 1,72)/
     |   1.2192702997583d-15, 8.8351698259597d-14, 2.4750666200350d-11,
     |   9.6960604305573d-10, 1.4724376276061d-08, 1.2667062245944d-07,
     |   7.4439780147330d-07, 3.3229518646581d-06, 1.2036291875626d-05,
     |   3.6959696372870d-05, 9.9191853837275d-05, 2.3785259459073d-04,
     |   5.1801610973770d-04, 1.0375164325335d-03, 1.9295074297746d-03,
     |   3.3571148771426d-03, 5.4969285790358d-03, 8.5097341330409d-03,
     |   1.2499749399799d-02, 1.7467279611117d-02, 2.3263325921793d-02,
     |   2.9557233340353d-02, 3.5828930892833d-02, 4.1395016947846d-02,
     |   4.5472791953224d-02, 4.7278997185204d-02, 4.6151838453774d-02,
     |   4.1677671002677d-02, 3.3799362253066d-02, 2.2883280900987d-02,
     |   9.7266958590878d-03,-4.5033671405450d-03,-1.8396625676062d-02,
     |  -3.0475562553197d-02,-3.9394643423104d-02,-4.4130440890284d-02,
     |  -4.4130440890284d-02,-3.9394643423104d-02,-3.0475562553197d-02,
     |  -1.8396625676062d-02,-4.5033671405450d-03, 9.7266958590879d-03,
     |   2.2883280900987d-02, 3.3799362253066d-02, 4.1677671002677d-02,
     |   4.6151838453774d-02, 4.7278997185204d-02, 4.5472791953224d-02,
     |   4.1395016947846d-02, 3.5828930892833d-02, 2.9557233340353d-02,
     |   2.3263325921793d-02, 1.7467279611117d-02, 1.2499749399799d-02,
     |   8.5097341330409d-03, 5.4969285790358d-03, 3.3571148771427d-03,
     |   1.9295074297746d-03, 1.0375164325335d-03, 5.1801610973774d-04,
     |   2.3785259459075d-04, 9.9191853837316d-05, 3.6959696372873d-05,
     |   1.2036291875583d-05, 3.3229518646434d-06, 7.4439780144103d-07,
     |   1.2667062245375d-07, 1.4724376237153d-08, 9.6960605759359d-10,
     |   2.4750668419736d-11, 8.8369555259308d-14, 1.2488338765456d-15/
      data (zmn(lat,11,12), lat = 1,72)/
     |  -5.0753753093456d-16, 2.2668616456174d-15, 8.3555747596270d-13,
     |   4.6057870335059d-11, 9.0455799529178d-10, 9.5817976432546d-09,
     |   6.7149165220866d-08, 3.4957649667139d-07, 1.4529770647539d-06,
     |   5.0580904559819d-06, 1.5248768150448d-05, 4.0786591738621d-05,
     |   9.8556720688494d-05, 2.1814634008177d-04, 4.4708289258284d-04,
     |   8.5569513224814d-04, 1.5399913862130d-03, 2.6205630078305d-03,
     |   4.2355241970014d-03, 6.5260587379240d-03, 9.6143188026784d-03,
     |   1.3575110644291d-02, 1.8404731055589d-02, 2.3992067604897d-02,
     |   3.0098162846338d-02, 3.6350438847167d-02, 4.2256431051492d-02,
     |   4.7239212495491d-02, 5.0693041139081d-02, 5.2053759584357d-02,
     |   5.0874917557321d-02, 4.6898280988705d-02, 4.0106965445878d-02,
     |   3.0751171691743d-02, 1.9340255095639d-02, 6.6000390289923d-03,
     |  -6.6000390289923d-03,-1.9340255095639d-02,-3.0751171691743d-02,
     |  -4.0106965445878d-02,-4.6898280988705d-02,-5.0874917557321d-02,
     |  -5.2053759584357d-02,-5.0693041139081d-02,-4.7239212495491d-02,
     |  -4.2256431051492d-02,-3.6350438847167d-02,-3.0098162846338d-02,
     |  -2.3992067604897d-02,-1.8404731055589d-02,-1.3575110644291d-02,
     |  -9.6143188026785d-03,-6.5260587379240d-03,-4.2355241970014d-03,
     |  -2.6205630078305d-03,-1.5399913862130d-03,-8.5569513224814d-04,
     |  -4.4708289258284d-04,-2.1814634008176d-04,-9.8556720688504d-05,
     |  -4.0786591738609d-05,-1.5248768150470d-05,-5.0580904559738d-06,
     |  -1.4529770647420d-06,-3.4957649667708d-07,-6.7149165222711d-08,
     |  -9.5817976473193d-09,-9.0455800518774d-10,-4.6057851717026d-11,
     |  -8.3557341206425d-13,-2.2659672563171d-15, 4.8960216631683d-16/
      data (zmn(lat,12,12), lat = 1,72)/
     |  -1.6148098035127d-16,-1.1585847984052d-16, 1.8547308088627d-14,
     |   1.4469147871973d-12, 3.6727501564918d-11, 4.7859978598793d-10,
     |   3.9951578844165d-09, 2.4222438703775d-08, 1.1533664916048d-07,
     |   4.5430136484555d-07, 1.5349850490524d-06, 4.5675411656810d-06,
     |   1.2207784584908d-05, 2.9753283273031d-05, 6.6914903528638d-05,
     |   1.4018592092797d-04, 2.7567704720941d-04, 5.1207467490842d-04,
     |   9.0314448371367d-04, 1.5189987620262d-03, 2.4452425229515d-03,
     |   3.7791778649284d-03, 5.6225233519056d-03, 8.0705999835199d-03,
     |   1.1198598943060d-02, 1.5046276142511d-02, 1.9603071434348d-02,
     |   2.4796069011346d-02, 3.0483263713851d-02, 3.6454196051064d-02,
     |   4.2439170936666d-02, 4.8127080511764d-02, 5.3190493950895d-02,
     |   5.7315395002711d-02, 6.0231987606353d-02, 6.1742554202596d-02,
     |   6.1742554202596d-02, 6.0231987606353d-02, 5.7315395002711d-02,
     |   5.3190493950895d-02, 4.8127080511764d-02, 4.2439170936666d-02,
     |   3.6454196051064d-02, 3.0483263713851d-02, 2.4796069011346d-02,
     |   1.9603071434348d-02, 1.5046276142511d-02, 1.1198598943060d-02,
     |   8.0705999835199d-03, 5.6225233519056d-03, 3.7791778649285d-03,
     |   2.4452425229515d-03, 1.5189987620262d-03, 9.0314448371367d-04,
     |   5.1207467490841d-04, 2.7567704720942d-04, 1.4018592092797d-04,
     |   6.6914903528639d-05, 2.9753283273023d-05, 1.2207784584911d-05,
     |   4.5675411656822d-06, 1.5349850490551d-06, 4.5430136485221d-07,
     |   1.1533664917211d-07, 2.4222438705632d-08, 3.9951578846689d-09,
     |   4.7859977721195d-10, 3.6727500487684d-11, 1.4468983439325d-12,
     |   1.8540147246804d-14,-1.2799816179540d-16,-1.7014813729168d-16/
      data (zmn(lat, 0,13), lat = 1,72)/
     |   2.9663765775993d-03, 8.8000714332089d-03, 9.0298600396673d-03,
     |   4.7286665130477d-03,-3.8872893805697d-03,-1.2566850338060d-02,
     |  -1.8263432543212d-02,-1.7530393292238d-02,-1.0340124165412d-02,
     |   1.7577859034420d-03, 1.4283357664040d-02, 2.2995055580809d-02,
     |   2.4032959032332d-02, 1.6755084729040d-02, 2.9196544697026d-03,
     |  -1.2660790049142d-02,-2.4802268067838d-02,-2.8786752270881d-02,
     |  -2.3051191271490d-02,-8.9629054626079d-03, 8.6754721622551d-03,
     |   2.4045972972663d-02, 3.1532255125511d-02, 2.8484330473426d-02,
     |   1.5481264755406d-02,-3.0579066834319d-03,-2.1039469110953d-02,
     |  -3.2092559148210d-02,-3.2459339529706d-02,-2.1681466286786d-02,
     |  -3.4603825610098d-03, 1.6212467747254d-02, 3.0469377122181d-02,
     |   3.4555886901561d-02, 2.6866284023876d-02, 1.0128870272856d-02,
     |  -1.0128870272856d-02,-2.6866284023876d-02,-3.4555886901561d-02,
     |  -3.0469377122181d-02,-1.6212467747254d-02, 3.4603825610099d-03,
     |   2.1681466286786d-02, 3.2459339529706d-02, 3.2092559148210d-02,
     |   2.1039469110953d-02, 3.0579066834319d-03,-1.5481264755406d-02,
     |  -2.8484330473426d-02,-3.1532255125511d-02,-2.4045972972663d-02,
     |  -8.6754721622554d-03, 8.9629054626079d-03, 2.3051191271490d-02,
     |   2.8786752270881d-02, 2.4802268067838d-02, 1.2660790049142d-02,
     |  -2.9196544697027d-03,-1.6755084729040d-02,-2.4032959032332d-02,
     |  -2.2995055580809d-02,-1.4283357664040d-02,-1.7577859034420d-03,
     |   1.0340124165412d-02, 1.7530393292238d-02, 1.8263432543212d-02,
     |   1.2566850338060d-02, 3.8872893805698d-03,-4.7286665130477d-03,
     |  -9.0298600396673d-03,-8.8000714332090d-03,-2.9663765775993d-03/
      data (zmn(lat, 1,13), lat = 1,72)/
     |   5.7924186191071d-04, 4.1705197447716d-03, 9.6863049933716d-03,
     |   1.3973902700945d-02, 1.4339796901693d-02, 9.4235217049672d-03,
     |   1.0264635270935d-04,-1.0771743311834d-02,-1.9276198257631d-02,
     |  -2.1945732732334d-02,-1.7139039467022d-02,-5.8676639781255d-03,
     |   8.3928616773027d-03, 2.0789321608691d-02, 2.6800228413374d-02,
     |   2.3891548416306d-02, 1.2563313110361d-02,-3.6769233477887d-03,
     |  -1.9408292788153d-02,-2.9144267052113d-02,-2.9264485639387d-02,
     |  -1.9369499634876d-02,-2.5299447672872d-03, 1.5671150178131d-02,
     |   2.9017881220584d-02, 3.2806054700631d-02, 2.5518763277747d-02,
     |   9.4202291175374d-03,-1.0150443810237d-02,-2.6572433358023d-02,
     |  -3.4205811087374d-02,-3.0349387473571d-02,-1.6202149644083d-02,
     |   3.5107618377601d-03, 2.2133966907954d-02, 3.3351618400214d-02,
     |   3.3351618400214d-02, 2.2133966907954d-02, 3.5107618377601d-03,
     |  -1.6202149644083d-02,-3.0349387473571d-02,-3.4205811087374d-02,
     |  -2.6572433358023d-02,-1.0150443810237d-02, 9.4202291175374d-03,
     |   2.5518763277746d-02, 3.2806054700631d-02, 2.9017881220584d-02,
     |   1.5671150178131d-02,-2.5299447672873d-03,-1.9369499634876d-02,
     |  -2.9264485639387d-02,-2.9144267052113d-02,-1.9408292788153d-02,
     |  -3.6769233477888d-03, 1.2563313110361d-02, 2.3891548416306d-02,
     |   2.6800228413374d-02, 2.0789321608690d-02, 8.3928616773028d-03,
     |  -5.8676639781255d-03,-1.7139039467022d-02,-2.1945732732334d-02,
     |  -1.9276198257631d-02,-1.0771743311834d-02, 1.0264635270938d-04,
     |   9.4235217049671d-03, 1.4339796901693d-02, 1.3973902700945d-02,
     |   9.6863049933716d-03, 4.1705197447716d-03, 5.7924186191074d-04/
      data (zmn(lat, 2,13), lat = 1,72)/
     |   4.2454989004192d-05, 9.4742062253702d-04, 3.9179584092810d-03,
     |   8.9129494614031d-03, 1.4551303720053d-02, 1.8462858712758d-02,
     |   1.8344454926021d-02, 1.2960361334571d-02, 2.9520532252981d-03,
     |  -9.1520376281859d-03,-1.9589360232265d-02,-2.4674548955070d-02,
     |  -2.2143493972316d-02,-1.2173200348444d-02, 2.4784719209742d-03,
     |   1.7201005573368d-02, 2.7044392535053d-02, 2.8403061791704d-02,
     |   2.0381100149733d-02, 5.2295183429833d-03,-1.2250876442508d-02,
     |  -2.6271135489014d-02,-3.1983401527214d-02,-2.7200766472962d-02,
     |  -1.3217047959866d-02, 5.5092149757653d-03, 2.2807668678593d-02,
     |   3.2838270291220d-02, 3.2104058238006d-02, 2.0668184109251d-02,
     |   2.2108799004350d-03,-1.7181481197127d-02,-3.1030501351740d-02,
     |  -3.4669563725579d-02,-2.6819241290206d-02,-1.0056165271413d-02,
     |   1.0056165271413d-02, 2.6819241290206d-02, 3.4669563725579d-02,
     |   3.1030501351740d-02, 1.7181481197127d-02,-2.2108799004350d-03,
     |  -2.0668184109251d-02,-3.2104058238006d-02,-3.2838270291220d-02,
     |  -2.2807668678593d-02,-5.5092149757653d-03, 1.3217047959866d-02,
     |   2.7200766472962d-02, 3.1983401527214d-02, 2.6271135489014d-02,
     |   1.2250876442508d-02,-5.2295183429833d-03,-2.0381100149733d-02,
     |  -2.8403061791704d-02,-2.7044392535053d-02,-1.7201005573368d-02,
     |  -2.4784719209740d-03, 1.2173200348444d-02, 2.2143493972316d-02,
     |   2.4674548955070d-02, 1.9589360232265d-02, 9.1520376281859d-03,
     |  -2.9520532252980d-03,-1.2960361334571d-02,-1.8344454926021d-02,
     |  -1.8462858712758d-02,-1.4551303720053d-02,-8.9129494614031d-03,
     |  -3.9179584092809d-03,-9.4742062253698d-04,-4.2454989004207d-05/
      data (zmn(lat, 3,13), lat = 1,72)/
     |   8.5880447532494d-07, 1.4065411731559d-04, 9.9069639843478d-04,
     |   3.3282233214549d-03, 7.5550309287357d-03, 1.3219470418373d-02,
     |   1.8872405311330d-02, 2.2405162909740d-02, 2.1782845911058d-02,
     |   1.5922403329247d-02, 5.3556836043935d-03,-7.6267356415327d-03,
     |  -1.9490254892049d-02,-2.6517315595065d-02,-2.6083894047608d-02,
     |  -1.7699524205593d-02,-3.4072029744845d-03, 1.2664381385344d-02,
     |   2.5510287482545d-02, 3.0856371881915d-02, 2.6630597838121d-02,
     |   1.3780420213624d-02,-3.8849534585544d-03,-2.0824926025301d-02,
     |  -3.1532072478323d-02,-3.2357597013094d-02,-2.2781268445618d-02,
     |  -5.6763442621865d-03, 1.3550969940466d-02, 2.8689068944379d-02,
     |   3.4755446992477d-02, 2.9661881375803d-02, 1.4945197045783d-02,
     |  -4.6952516243584d-03,-2.2914080631644d-02,-3.3794644328326d-02,
     |  -3.3794644328326d-02,-2.2914080631644d-02,-4.6952516243585d-03,
     |   1.4945197045783d-02, 2.9661881375803d-02, 3.4755446992477d-02,
     |   2.8689068944379d-02, 1.3550969940467d-02,-5.6763442621864d-03,
     |  -2.2781268445618d-02,-3.2357597013094d-02,-3.1532072478323d-02,
     |  -2.0824926025301d-02,-3.8849534585544d-03, 1.3780420213624d-02,
     |   2.6630597838121d-02, 3.0856371881915d-02, 2.5510287482545d-02,
     |   1.2664381385344d-02,-3.4072029744845d-03,-1.7699524205593d-02,
     |  -2.6083894047608d-02,-2.6517315595065d-02,-1.9490254892049d-02,
     |  -7.6267356415328d-03, 5.3556836043934d-03, 1.5922403329247d-02,
     |   2.1782845911058d-02, 2.2405162909740d-02, 1.8872405311330d-02,
     |   1.3219470418373d-02, 7.5550309287358d-03, 3.3282233214549d-03,
     |   9.9069639843477d-04, 1.4065411731565d-04, 8.5880447530671d-07/
      data (zmn(lat, 4,13), lat = 1,72)/
     |   3.0907131448113d-08, 1.5156622325092d-05, 1.8130550901297d-04,
     |   8.7835028729314d-04, 2.6753266823988d-03, 6.0723336169006d-03,
     |   1.1132387138069d-02, 1.7184620727574d-02, 2.2774509271163d-02,
     |   2.5963010936339d-02, 2.4930955907243d-02, 1.8707795440033d-02,
     |   7.7514650387522d-03,-5.8774759399100d-03,-1.8891284976314d-02,
     |  -2.7651192409607d-02,-2.9304550960513d-02,-2.2812853134405d-02,
     |  -9.4989559567903d-03, 7.1308545716653d-03, 2.2301446615920d-02,
     |   3.1379795087611d-02, 3.1349026970631d-02, 2.1860752247543d-02,
     |   5.4882158602647d-03,-1.2949280952479d-02,-2.7818901610548d-02,
     |  -3.4429135641583d-02,-3.0548316024169d-02,-1.7182261593973d-02,
     |   1.6646469676853d-03, 2.0196605034797d-02, 3.2632447714821d-02,
     |   3.5038892867121d-02, 2.6597839020557d-02, 9.8922033617403d-03,
     |  -9.8922033617402d-03,-2.6597839020557d-02,-3.5038892867121d-02,
     |  -3.2632447714821d-02,-2.0196605034797d-02,-1.6646469676852d-03,
     |   1.7182261593973d-02, 3.0548316024168d-02, 3.4429135641583d-02,
     |   2.7818901610548d-02, 1.2949280952479d-02,-5.4882158602646d-03,
     |  -2.1860752247543d-02,-3.1349026970631d-02,-3.1379795087611d-02,
     |  -2.2301446615920d-02,-7.1308545716654d-03, 9.4989559567903d-03,
     |   2.2812853134405d-02, 2.9304550960513d-02, 2.7651192409607d-02,
     |   1.8891284976314d-02, 5.8774759399100d-03,-7.7514650387521d-03,
     |  -1.8707795440033d-02,-2.4930955907243d-02,-2.5963010936339d-02,
     |  -2.2774509271163d-02,-1.7184620727574d-02,-1.1132387138069d-02,
     |  -6.0723336169006d-03,-2.6753266823988d-03,-8.7835028729312d-04,
     |  -1.8130550901296d-04,-1.5156622325140d-05,-3.0907131437656d-08/
      data (zmn(lat, 5,13), lat = 1,72)/
     |   1.0542949589128d-08, 1.2616075097876d-06, 2.5676586674285d-05,
     |   1.7749516642006d-04, 7.1438623133196d-04, 2.0556244291634d-03,
     |   4.6733362734808d-03, 8.8676295483497d-03, 1.4495914075831d-02,
     |   2.0776424073489d-02, 2.6289464011031d-02, 2.9245852628716d-02,
     |   2.7994670593981d-02, 2.1635376064801d-02, 1.0526201741288d-02,
     |  -3.5235768945888d-03,-1.7512599155974d-02,-2.7951795092367d-02,
     |  -3.1848060496672d-02,-2.7678448447085d-02,-1.6030117734737d-02,
     |   3.4524444818401d-04, 1.7145579297300d-02, 2.9670770665604d-02,
     |   3.4193753700988d-02, 2.9133146587814d-02, 1.5643285824407d-02,
     |  -2.6005497490929d-03,-2.0399329773536d-02,-3.2536738744800d-02,
     |  -3.5347238371944d-02,-2.7860382782237d-02,-1.2152856971335d-02,
     |   7.2217329652768d-03, 2.4568784551683d-02, 3.4754694458810d-02,
     |   3.4754694458810d-02, 2.4568784551683d-02, 7.2217329652769d-03,
     |  -1.2152856971335d-02,-2.7860382782237d-02,-3.5347238371944d-02,
     |  -3.2536738744800d-02,-2.0399329773536d-02,-2.6005497490929d-03,
     |   1.5643285824407d-02, 2.9133146587814d-02, 3.4193753700988d-02,
     |   2.9670770665604d-02, 1.7145579297300d-02, 3.4524444818404d-04,
     |  -1.6030117734737d-02,-2.7678448447085d-02,-3.1848060496672d-02,
     |  -2.7951795092367d-02,-1.7512599155974d-02,-3.5235768945888d-03,
     |   1.0526201741288d-02, 2.1635376064801d-02, 2.7994670593981d-02,
     |   2.9245852628716d-02, 2.6289464011031d-02, 2.0776424073489d-02,
     |   1.4495914075831d-02, 8.8676295483497d-03, 4.6733362734808d-03,
     |   2.0556244291634d-03, 7.1438623133204d-04, 1.7749516642010d-04,
     |   2.5676586674335d-05, 1.2616075097703d-06, 1.0542949575395d-08/
      data (zmn(lat, 6,13), lat = 1,72)/
     |   2.3496076152296d-10, 8.5266494917773d-08, 2.9184620569843d-06,
     |   2.8640856706100d-05, 1.5109105728422d-04, 5.4495486684136d-04,
     |   1.5120984991279d-03, 3.4478322168202d-03, 6.7232153831204d-03,
     |   1.1495432950649d-02, 1.7501915950582d-02, 2.3925253867604d-02,
     |   2.9417043032687d-02, 3.2331095430282d-02, 3.1146992774180d-02,
     |   2.4985304208952d-02, 1.4055916167809d-02,-1.3204046714002d-04,
     |  -1.4922506501071d-02,-2.7049960512373d-02,-3.3458694930089d-02,
     |  -3.2190247846272d-02,-2.3071535267124d-02,-7.9646809356958d-03,
     |   9.5499476924983d-03, 2.5021545138560d-02, 3.4302434150322d-02,
     |   3.4723371419632d-02, 2.5920557041527d-02, 1.0046262474507d-02,
     |  -8.7341423245950d-03,-2.5345350177193d-02,-3.5205972926522d-02,
     |  -3.5531610634091d-02,-2.6152695673857d-02,-9.5973108924436d-03,
     |   9.5973108924435d-03, 2.6152695673856d-02, 3.5531610634091d-02,
     |   3.5205972926522d-02, 2.5345350177193d-02, 8.7341423245949d-03,
     |  -1.0046262474507d-02,-2.5920557041527d-02,-3.4723371419632d-02,
     |  -3.4302434150322d-02,-2.5021545138560d-02,-9.5499476924985d-03,
     |   7.9646809356957d-03, 2.3071535267124d-02, 3.2190247846272d-02,
     |   3.3458694930089d-02, 2.7049960512374d-02, 1.4922506501071d-02,
     |   1.3204046714004d-04,-1.4055916167809d-02,-2.4985304208952d-02,
     |  -3.1146992774180d-02,-3.2331095430282d-02,-2.9417043032687d-02,
     |  -2.3925253867604d-02,-1.7501915950582d-02,-1.1495432950649d-02,
     |  -6.7232153831204d-03,-3.4478322168203d-03,-1.5120984991279d-03,
     |  -5.4495486684139d-04,-1.5109105728420d-04,-2.8640856706092d-05,
     |  -2.9184620570328d-06,-8.5266494867469d-08,-2.3496074048728d-10/
      data (zmn(lat, 7,13), lat = 1,72)/
     |  -6.4657326610675d-11, 4.8040124877001d-09, 2.7190479178952d-07,
     |   3.7765066526762d-06, 2.5987436417174d-05, 1.1672600186516d-04,
     |   3.9185915421416d-04, 1.0612056570192d-03, 2.4295653321947d-03,
     |   4.8474114197110d-03, 8.6008150624914d-03, 1.3755110587684d-02,
     |   1.9995670165946d-02, 2.6529731340083d-02, 3.2113658140625d-02,
     |   3.5244124061996d-02, 3.4502765758982d-02, 2.8985215841202d-02,
     |   1.8697090077413d-02, 4.7816026928962d-03,-1.0531360342751d-02,
     |  -2.4297411883712d-02,-3.3499867890967d-02,-3.5817880109106d-02,
     |  -3.0315475181445d-02,-1.7841749506844d-02,-9.9239645770159d-04,
     |   1.6404435488840d-02, 3.0179270992314d-02, 3.6872261158068d-02,
     |   3.4663431279866d-02, 2.3916836368609d-02, 7.1674044686745d-03,
     |  -1.1471416843310d-02,-2.7338540870740d-02,-3.6425947164917d-02,
     |  -3.6425947164917d-02,-2.7338540870740d-02,-1.1471416843310d-02,
     |   7.1674044686744d-03, 2.3916836368609d-02, 3.4663431279866d-02,
     |   3.6872261158068d-02, 3.0179270992314d-02, 1.6404435488840d-02,
     |  -9.9239645770157d-04,-1.7841749506844d-02,-3.0315475181445d-02,
     |  -3.5817880109106d-02,-3.3499867890967d-02,-2.4297411883712d-02,
     |  -1.0531360342751d-02, 4.7816026928962d-03, 1.8697090077413d-02,
     |   2.8985215841202d-02, 3.4502765758982d-02, 3.5244124061996d-02,
     |   3.2113658140625d-02, 2.6529731340082d-02, 1.9995670165946d-02,
     |   1.3755110587684d-02, 8.6008150624913d-03, 4.8474114197110d-03,
     |   2.4295653321947d-03, 1.0612056570191d-03, 3.9185915421418d-04,
     |   1.1672600186523d-04, 2.5987436417155d-05, 3.7765066526612d-06,
     |   2.7190479175462d-07, 4.8040125350484d-09,-6.4657289460911d-11/
      data (zmn(lat, 8,13), lat = 1,72)/
     |  -9.8430190159613d-13, 2.2124796393106d-10, 2.0987841649421d-08,
     |   4.1153555539832d-07, 3.6827499106243d-06, 2.0514987547738d-05,
     |   8.2879730683473d-05, 2.6473569728489d-04, 7.0525625901151d-04,
     |   1.6228394084418d-03, 3.3037700562925d-03, 6.0511649947779d-03,
     |   1.0089885084099d-02, 1.5440305684798d-02, 2.1793271033191d-02,
     |   2.8432645202069d-02, 3.4252936197306d-02, 3.7902921907351d-02,
     |   3.8053141903448d-02, 3.3743191928382d-02, 2.4726678219155d-02,
     |   1.1711543967937d-02,-3.5980897693424d-03,-1.8712576500752d-02,
     |  -3.0809827217979d-02,-3.7348778244135d-02,-3.6702557113518d-02,
     |  -2.8645217358364d-02,-1.4545552065554d-02, 2.8145276948133d-03,
     |   1.9785616469827d-02, 3.2649808385386d-02, 3.8486247537165d-02,
     |   3.5886694182207d-02, 2.5332516489809d-02, 9.1251428986057d-03,
     |  -9.1251428986057d-03,-2.5332516489809d-02,-3.5886694182207d-02,
     |  -3.8486247537165d-02,-3.2649808385386d-02,-1.9785616469827d-02,
     |  -2.8145276948133d-03, 1.4545552065554d-02, 2.8645217358364d-02,
     |   3.6702557113518d-02, 3.7348778244135d-02, 3.0809827217979d-02,
     |   1.8712576500752d-02, 3.5980897693424d-03,-1.1711543967937d-02,
     |  -2.4726678219155d-02,-3.3743191928382d-02,-3.8053141903448d-02,
     |  -3.7902921907351d-02,-3.4252936197306d-02,-2.8432645202069d-02,
     |  -2.1793271033191d-02,-1.5440305684798d-02,-1.0089885084099d-02,
     |  -6.0511649947779d-03,-3.3037700562925d-03,-1.6228394084418d-03,
     |  -7.0525625901153d-04,-2.6473569728490d-04,-8.2879730683464d-05,
     |  -2.0514987547688d-05,-3.6827499106542d-06,-4.1153555540149d-07,
     |  -2.0987841572625d-08,-2.2124800379106d-10, 9.8429139576073d-13/
      data (zmn(lat, 9,13), lat = 1,72)/
     |   3.8296316247691d-13, 8.0621310080946d-12, 1.3438201801235d-09,
     |   3.7132500789949d-08, 4.3122202400437d-07, 2.9709158385164d-06,
     |   1.4392660031879d-05, 5.3982715037929d-05, 1.6639945116601d-04,
     |   4.3848519573871d-04, 1.0150770083024d-03, 2.1048967834909d-03,
     |   3.9655477036934d-03, 6.8585721654836d-03, 1.0972583190160d-02,
     |   1.6323961812280d-02, 2.2657629543579d-02, 2.9380406157879d-02,
     |   3.5561582191938d-02, 4.0026207382018d-02, 4.1546021026763d-02,
     |   3.9104735035959d-02, 3.2185885683599d-02, 2.1011796834630d-02,
     |   6.6594370049822d-03,-9.0026819665198d-03,-2.3574606952581d-02,
     |  -3.4550774919551d-02,-3.9832069587813d-02,-3.8211380987013d-02,
     |  -2.9712935666545d-02,-1.5689666596619d-02, 1.3657098022685d-03,
     |   1.8273115304669d-02, 3.1792299845743d-02, 3.9288953824164d-02,
     |   3.9288953824164d-02, 3.1792299845743d-02, 1.8273115304669d-02,
     |   1.3657098022685d-03,-1.5689666596619d-02,-2.9712935666545d-02,
     |  -3.8211380987013d-02,-3.9832069587813d-02,-3.4550774919551d-02,
     |  -2.3574606952581d-02,-9.0026819665198d-03, 6.6594370049821d-03,
     |   2.1011796834630d-02, 3.2185885683599d-02, 3.9104735035959d-02,
     |   4.1546021026763d-02, 4.0026207382018d-02, 3.5561582191938d-02,
     |   2.9380406157879d-02, 2.2657629543579d-02, 1.6323961812280d-02,
     |   1.0972583190160d-02, 6.8585721654836d-03, 3.9655477036934d-03,
     |   2.1048967834909d-03, 1.0150770083023d-03, 4.3848519573876d-04,
     |   1.6639945116603d-04, 5.3982715037923d-05, 1.4392660031844d-05,
     |   2.9709158384726d-06, 4.3122202402894d-07, 3.7132500789607d-08,
     |   1.3438202422294d-09, 8.0620639740430d-12, 3.8294415705247d-13/
      data (zmn(lat,10,13), lat = 1,72)/
     |   3.8591363449460d-15, 2.5352465648095d-13, 7.0720095934880d-11,
     |   2.7516227695726d-09, 4.1405521627841d-08, 3.5211643007857d-07,
     |   2.0404864147454d-06, 8.9590002629885d-06, 3.1832702077686d-05,
     |   9.5616174679321d-05, 2.5026663322115d-04, 5.8340350311686d-04,
     |   1.2309397152436d-03, 2.3794750683527d-03, 4.2531852165205d-03,
     |   7.0792863490400d-03, 1.1030571159744d-02, 1.6150683010073d-02,
     |   2.2276203948247d-02, 2.8976744495990d-02, 3.5537126099241d-02,
     |   4.1002096618829d-02, 4.4293014089997d-02, 4.4388969849730d-02,
     |   4.0545529232704d-02, 3.2507806372233d-02, 2.0666313001827d-02,
     |   6.1078528635125d-03,-9.4692593332285d-03,-2.3978724885665d-02,
     |  -3.5279185516381d-02,-4.1557935717922d-02,-4.1688653613365d-02,
     |  -3.5485051280746d-02,-2.3789584736006d-02,-8.3691557275271d-03,
     |   8.3691557275271d-03, 2.3789584736005d-02, 3.5485051280746d-02,
     |   4.1688653613365d-02, 4.1557935717922d-02, 3.5279185516381d-02,
     |   2.3978724885665d-02, 9.4692593332286d-03,-6.1078528635124d-03,
     |  -2.0666313001827d-02,-3.2507806372233d-02,-4.0545529232704d-02,
     |  -4.4388969849730d-02,-4.4293014089997d-02,-4.1002096618829d-02,
     |  -3.5537126099241d-02,-2.8976744495990d-02,-2.2276203948247d-02,
     |  -1.6150683010073d-02,-1.1030571159744d-02,-7.0792863490401d-03,
     |  -4.2531852165205d-03,-2.3794750683527d-03,-1.2309397152437d-03,
     |  -5.8340350311686d-04,-2.5026663322114d-04,-9.5616174679363d-05,
     |  -3.1832702077698d-05,-8.9590002630110d-06,-2.0404864148059d-06,
     |  -3.5211643016688d-07,-4.1405521612817d-08,-2.7516227980881d-09,
     |  -7.0720163711862d-11,-2.5347910365633d-13,-3.8652172354965d-15/
      data (zmn(lat,11,13), lat = 1,72)/
     |  -1.5307706510810d-15, 7.9654392056156d-15, 2.9890526247421d-12,
     |   1.6371673448552d-10, 3.1885729330689d-09, 3.3422337765437d-08,
     |   2.3125803683614d-07, 1.1859667088548d-06, 4.8443514532332d-06,
     |   1.6532567979959d-05, 4.8735443814046d-05, 1.2711689484378d-04,
     |   2.9867247901797d-04, 6.4082834218501d-04, 1.2688953082156d-03,
     |   2.3379564541825d-03, 4.0346060197520d-03, 6.5545870558036d-03,
     |   1.0064699591241d-02, 1.4651318938878d-02, 2.0262822101474d-02,
     |   2.6657946844231d-02, 3.3375056601588d-02, 3.9737007251083d-02,
     |   4.4901952967684d-02, 4.7962135189756d-02, 4.8081798995453d-02,
     |   4.4654226045660d-02, 3.7449339360962d-02, 2.6720088843161d-02,
     |   1.3239541106521d-02,-1.7486458702072d-03,-1.6667612050843d-02,
     |  -2.9815683998094d-02,-3.9612836395599d-02,-4.4842204083312d-02,
     |  -4.4842204083312d-02,-3.9612836395599d-02,-2.9815683998094d-02,
     |  -1.6667612050843d-02,-1.7486458702072d-03, 1.3239541106521d-02,
     |   2.6720088843161d-02, 3.7449339360962d-02, 4.4654226045660d-02,
     |   4.8081798995453d-02, 4.7962135189756d-02, 4.4901952967684d-02,
     |   3.9737007251083d-02, 3.3375056601588d-02, 2.6657946844231d-02,
     |   2.0262822101474d-02, 1.4651318938878d-02, 1.0064699591241d-02,
     |   6.5545870558036d-03, 4.0346060197520d-03, 2.3379564541825d-03,
     |   1.2688953082155d-03, 6.4082834218498d-04, 2.9867247901792d-04,
     |   1.2711689484374d-04, 4.8735443814057d-05, 1.6532567979884d-05,
     |   4.8443514531850d-06, 1.1859667088306d-06, 2.3125803683141d-07,
     |   3.3422337756532d-08, 3.1885729165033d-09, 1.6371669913078d-10,
     |   2.9890179155659d-12, 8.0082858671353d-15,-1.5048232652673d-15/
      data (zmn(lat,12,13), lat = 1,72)/
     |  -1.0036762005388d-16, 7.2010859967254d-17, 9.6427028665002d-14,
     |   7.4314304543473d-12, 1.8717523935933d-10, 2.4156091223716d-09,
     |   1.9930106663001d-08, 1.1918392511890d-07, 5.5855866236591d-07,
     |   2.1607017947114d-06, 7.1534715890324d-06, 2.0807917280795d-05,
     |   5.4230060224597d-05, 1.2854735969464d-04, 2.8040081961771d-04,
     |   5.6808923619249d-04, 1.0769804180981d-03, 1.9220790780431d-03,
     |   3.2451852977691d-03, 5.2041829561624d-03, 7.9528915390280d-03,
     |   1.1611656495203d-02, 1.6231255663018d-02, 2.1755310452895d-02,
     |   2.7988557068509d-02, 3.4579343543490d-02, 4.1023998182227d-02,
     |   4.6698022444333d-02, 5.0914624163744d-02, 5.3005648127158d-02,
     |   5.2414588259340d-02, 4.8787338306336d-02, 4.2044761134078d-02,
     |   3.2422681348755d-02, 2.0469517445983d-02, 6.9987326249644d-03,
     |  -6.9987326249644d-03,-2.0469517445983d-02,-3.2422681348755d-02,
     |  -4.2044761134078d-02,-4.8787338306336d-02,-5.2414588259340d-02,
     |  -5.3005648127158d-02,-5.0914624163744d-02,-4.6698022444333d-02,
     |  -4.1023998182227d-02,-3.4579343543490d-02,-2.7988557068510d-02,
     |  -2.1755310452895d-02,-1.6231255663018d-02,-1.1611656495203d-02,
     |  -7.9528915390280d-03,-5.2041829561624d-03,-3.2451852977691d-03,
     |  -1.9220790780432d-03,-1.0769804180981d-03,-5.6808923619247d-04,
     |  -2.8040081961770d-04,-1.2854735969464d-04,-5.4230060224537d-05,
     |  -2.0807917280766d-05,-7.1534715889713d-06,-2.1607017946746d-06,
     |  -5.5855866236790d-07,-1.1918392509703d-07,-1.9930106639573d-08,
     |  -2.4156090712449d-09,-1.8717525601671d-10,-7.4313869818583d-12,
     |  -9.6382570183414d-14,-4.9753929386163d-17, 1.2257526564483d-16/
      data (zmn(lat,13,13), lat = 1,72)/
     |   2.1901108355170d-18,-1.5405308318911d-17, 2.0540835972770d-15,
     |   2.2427876683257d-13, 7.3016540646910d-12, 1.1592337424680d-10,
     |   1.1392574765525d-09, 7.9343667156210d-09, 4.2598696369012d-08,
     |   1.8645379587036d-07, 6.9183924178494d-07, 2.2387861627301d-06,
     |   6.4537129705694d-06, 1.6844924691822d-05, 4.0321161099315d-05,
     |   8.9417154445099d-05, 1.8522903771170d-04, 3.6085181169952d-04,
     |   6.6482679241194d-04, 1.1637989056531d-03, 1.9433339024016d-03,
     |   3.1057541972434d-03, 4.7640121195483d-03, 7.0310854770794d-03,
     |   1.0005139769495d-02, 1.3751657935755d-02, 1.8284716856906d-02,
     |   2.3550363982983d-02, 2.9415389709474d-02, 3.5664531146458d-02,
     |   4.2008221787744d-02, 4.8101504991168d-02, 5.3572887633134d-02,
     |   5.8060062187197d-02, 6.1247948723217d-02, 6.2903735588926d-02,
     |   6.2903735588926d-02, 6.1247948723217d-02, 5.8060062187197d-02,
     |   5.3572887633135d-02, 4.8101504991168d-02, 4.2008221787744d-02,
     |   3.5664531146459d-02, 2.9415389709474d-02, 2.3550363982983d-02,
     |   1.8284716856907d-02, 1.3751657935755d-02, 1.0005139769495d-02,
     |   7.0310854770794d-03, 4.7640121195483d-03, 3.1057541972434d-03,
     |   1.9433339024016d-03, 1.1637989056531d-03, 6.6482679241192d-04,
     |   3.6085181169952d-04, 1.8522903771166d-04, 8.9417154445089d-05,
     |   4.0321161099295d-05, 1.6844924691812d-05, 6.4537129705615d-06,
     |   2.2387861627231d-06, 6.9183924176759d-07, 1.8645379587448d-07,
     |   4.2598696373268d-08, 7.9343667158727d-09, 1.1392574587547d-09,
     |   1.1592336337345d-10, 7.3016255436085d-12, 2.2428897415913d-13,
     |   2.0398488883671d-15,-3.3225512992994d-17,-2.1378244107991d-17/
      data (zmn(lat, 0,14), lat = 1,72)/
     |   3.0609288969963d-03, 8.8282469909165d-03, 8.2495805799786d-03,
     |   2.7206937586530d-03,-6.7451337832585d-03,-1.4887608461401d-02,
     |  -1.8200291242778d-02,-1.3746011761507d-02,-3.0104500549247d-03,
     |   1.0494319103743d-02, 2.0846706236145d-02, 2.3712268221346d-02,
     |   1.6945205086249d-02, 2.9034622585854d-03,-1.3386070776348d-02,
     |  -2.5167610261461d-02,-2.7598241131023d-02,-1.9011647187679d-02,
     |  -2.5187374416522d-03, 1.5758196504786d-02, 2.8420416179699d-02,
     |   3.0335577218922d-02, 2.0256409223351d-02, 1.9347065625763d-03,
     |  -1.7689901266088d-02,-3.0785585843470d-02,-3.2108506884686d-02,
     |  -2.0822774147078d-02,-1.2142050601453d-03, 1.9189296954014d-02,
     |   3.2329162757498d-02, 3.3004780408490d-02, 2.0796093929909d-02,
     |   4.1355981022591d-04,-2.0236286219859d-02,-3.3070549345189d-02,
     |  -3.3070549345189d-02,-2.0236286219859d-02, 4.1355981022584d-04,
     |   2.0796093929909d-02, 3.3004780408490d-02, 3.2329162757498d-02,
     |   1.9189296954014d-02,-1.2142050601451d-03,-2.0822774147078d-02,
     |  -3.2108506884686d-02,-3.0785585843470d-02,-1.7689901266088d-02,
     |   1.9347065625762d-03, 2.0256409223351d-02, 3.0335577218922d-02,
     |   2.8420416179699d-02, 1.5758196504786d-02,-2.5187374416521d-03,
     |  -1.9011647187679d-02,-2.7598241131023d-02,-2.5167610261461d-02,
     |  -1.3386070776348d-02, 2.9034622585855d-03, 1.6945205086249d-02,
     |   2.3712268221346d-02, 2.0846706236145d-02, 1.0494319103743d-02,
     |  -3.0104500549246d-03,-1.3746011761507d-02,-1.8200291242778d-02,
     |  -1.4887608461401d-02,-6.7451337832586d-03, 2.7206937586530d-03,
     |   8.2495805799786d-03, 8.8282469909164d-03, 3.0609288969963d-03/
      data (zmn(lat, 1,14), lat = 1,72)/
     |   6.4886662468212d-04, 4.5660704355115d-03, 1.0299541063847d-02,
     |   1.4020170804386d-02, 1.2835423367388d-02, 5.8153836323255d-03,
     |  -4.9965172535442d-03,-1.5508439377436d-02,-2.1060344370421d-02,
     |  -1.8696906796619d-02,-8.4801491317552d-03, 6.0853369381589d-03,
     |   1.9431072746752d-02, 2.5972221143324d-02, 2.2606305750903d-02,
     |   1.0017209894619d-02,-7.2348629432570d-03,-2.2518941850296d-02,
     |  -2.9595386432084d-02,-2.5312324395260d-02,-1.0873234908170d-02,
     |   8.3399596640181d-03, 2.4919703994390d-02, 3.2200000493983d-02,
     |   2.7081094652289d-02, 1.1227907599955d-02,-9.3401193146693d-03,
     |  -2.6678657685728d-02,-3.3897248108116d-02,-2.8040415907813d-02,
     |  -1.1184174062819d-02, 1.0182685629228d-02, 2.7799264251379d-02,
     |   3.4736288774808d-02, 2.8263879562381d-02, 1.0815566492009d-02,
     |  -1.0815566492009d-02,-2.8263879562381d-02,-3.4736288774808d-02,
     |  -2.7799264251379d-02,-1.0182685629228d-02, 1.1184174062819d-02,
     |   2.8040415907813d-02, 3.3897248108116d-02, 2.6678657685728d-02,
     |   9.3401193146694d-03,-1.1227907599955d-02,-2.7081094652289d-02,
     |  -3.2200000493983d-02,-2.4919703994390d-02,-8.3399596640182d-03,
     |   1.0873234908170d-02, 2.5312324395260d-02, 2.9595386432084d-02,
     |   2.2518941850296d-02, 7.2348629432571d-03,-1.0017209894619d-02,
     |  -2.2606305750903d-02,-2.5972221143324d-02,-1.9431072746752d-02,
     |  -6.0853369381589d-03, 8.4801491317552d-03, 1.8696906796619d-02,
     |   2.1060344370421d-02, 1.5508439377436d-02, 4.9965172535441d-03,
     |  -5.8153836323255d-03,-1.2835423367388d-02,-1.4020170804386d-02,
     |  -1.0299541063847d-02,-4.5660704355116d-03,-6.4886662468215d-04/
      data (zmn(lat, 2,14), lat = 1,72)/
     |   5.0775344979443d-05, 1.1222259016979d-03, 4.5537474891114d-03,
     |   1.0039639232073d-02, 1.5616499325329d-02, 1.8343636405973d-02,
     |   1.5835709916157d-02, 7.5404916295862d-03,-4.5412435569955d-03,
     |  -1.6387763874798d-02,-2.3375485198348d-02,-2.2248128746948d-02,
     |  -1.2621771346429d-02, 2.5055073225843d-03, 1.7696096858894d-02,
     |   2.7046264780599d-02, 2.6561752217025d-02, 1.5863429783879d-02,
     |  -1.4188772981042d-03,-1.8893041717733d-02,-2.9784367752100d-02,
     |  -2.9617101285381d-02,-1.8059052395837d-02, 7.7885351620590d-04,
     |   1.9823128021371d-02, 3.1711814560252d-02, 3.1683009267488d-02,
     |   1.9492386851643d-02,-3.8303264185578d-04,-2.0408385110802d-02,
     |  -3.2869064052041d-02,-3.2877867510324d-02,-2.0305834553850d-02,
     |   1.1439367716955d-04, 2.0588814107782d-02, 3.3262363713349d-02,
     |   3.3262363713349d-02, 2.0588814107782d-02, 1.1439367716962d-04,
     |  -2.0305834553850d-02,-3.2877867510324d-02,-3.2869064052041d-02,
     |  -2.0408385110802d-02,-3.8303264185598d-04, 1.9492386851643d-02,
     |   3.1683009267488d-02, 3.1711814560252d-02, 1.9823128021371d-02,
     |   7.7885351620601d-04,-1.8059052395838d-02,-2.9617101285381d-02,
     |  -2.9784367752100d-02,-1.8893041717733d-02,-1.4188772981043d-03,
     |   1.5863429783879d-02, 2.6561752217025d-02, 2.7046264780599d-02,
     |   1.7696096858894d-02, 2.5055073225842d-03,-1.2621771346429d-02,
     |  -2.2248128746948d-02,-2.3375485198348d-02,-1.6387763874798d-02,
     |  -4.5412435569956d-03, 7.5404916295862d-03, 1.5835709916157d-02,
     |   1.8343636405973d-02, 1.5616499325329d-02, 1.0039639232073d-02,
     |   4.5537474891114d-03, 1.1222259016980d-03, 5.0775344979436d-05/
      data (zmn(lat, 3,14), lat = 1,72)/
     |   1.0035403428688d-06, 1.7995094006723d-04, 1.2492044851832d-03,
     |   4.1061910173394d-03, 9.0309021905542d-03, 1.5117560071384d-02,
     |   2.0265179003002d-02, 2.1876279251912d-02, 1.7999891153903d-02,
     |   8.4443961930169d-03,-4.7074835043314d-03,-1.7506324644956d-02,
     |  -2.5441313693676d-02,-2.5179982799839d-02,-1.6063357664739d-02,
     |  -6.8185813598605d-04, 1.5792259924620d-02, 2.7374985635654d-02,
     |   2.9508244452077d-02, 2.0914590751365d-02, 4.2892337005962d-03,
     |  -1.4507577575765d-02,-2.8537663143110d-02,-3.2386304285869d-02,
     |  -2.4295092127406d-02,-6.9622946280148d-03, 1.3339975731348d-02,
     |   2.9057306906692d-02, 3.4196057395822d-02, 2.6643563642901d-02,
     |   9.0453075886377d-03,-1.2118055702126d-02,-2.8941250744963d-02,
     |  -3.5076188897180d-02,-2.8157196200706d-02,-1.0722335653442d-02,
     |   1.0722335653442d-02, 2.8157196200706d-02, 3.5076188897180d-02,
     |   2.8941250744963d-02, 1.2118055702126d-02,-9.0453075886378d-03,
     |  -2.6643563642901d-02,-3.4196057395822d-02,-2.9057306906692d-02,
     |  -1.3339975731348d-02, 6.9622946280147d-03, 2.4295092127406d-02,
     |   3.2386304285869d-02, 2.8537663143110d-02, 1.4507577575765d-02,
     |  -4.2892337005960d-03,-2.0914590751365d-02,-2.9508244452077d-02,
     |  -2.7374985635654d-02,-1.5792259924621d-02, 6.8185813598597d-04,
     |   1.6063357664739d-02, 2.5179982799839d-02, 2.5441313693676d-02,
     |   1.7506324644956d-02, 4.7074835043313d-03,-8.4443961930168d-03,
     |  -1.7999891153903d-02,-2.1876279251912d-02,-2.0265179003002d-02,
     |  -1.5117560071384d-02,-9.0309021905543d-03,-4.1061910173394d-03,
     |  -1.2492044851833d-03,-1.7995094006717d-04,-1.0035403428508d-06/
      data (zmn(lat, 4,14), lat = 1,72)/
     |   4.2738267960778d-08, 2.0948179946020d-05, 2.4784836603235d-04,
     |   1.1805351339551d-03, 3.5113868133344d-03, 7.7208908587321d-03,
     |   1.3574814834836d-02, 1.9823684251257d-02, 2.4348021678711d-02,
     |   2.4815844039355d-02, 1.9658074040988d-02, 8.9750429373590d-03,
     |  -5.0645684052361d-03,-1.8612958208431d-02,-2.7302722823551d-02,
     |  -2.7816128668672d-02,-1.9281928542296d-02,-3.9092236458804d-03,
     |   1.3485869942557d-02, 2.6997437916189d-02, 3.1700713845266d-02,
     |   2.5526183829152d-02, 1.0200366401020d-02,-9.1708402662446d-03,
     |  -2.5804249703321d-02,-3.3653071539449d-02,-2.9656304081704d-02,
     |  -1.4967555637142d-02, 5.3386963472643d-03, 2.4026478888757d-02,
     |   3.4307319415854d-02, 3.2344349220264d-02, 1.8711911368402d-02,
     |  -1.7541976040171d-03,-2.1685324418321d-02,-3.3862354740107d-02,
     |  -3.3862354740107d-02,-2.1685324418321d-02,-1.7541976040172d-03,
     |   1.8711911368402d-02, 3.2344349220264d-02, 3.4307319415854d-02,
     |   2.4026478888757d-02, 5.3386963472644d-03,-1.4967555637142d-02,
     |  -2.9656304081704d-02,-3.3653071539449d-02,-2.5804249703321d-02,
     |  -9.1708402662447d-03, 1.0200366401020d-02, 2.5526183829152d-02,
     |   3.1700713845266d-02, 2.6997437916189d-02, 1.3485869942557d-02,
     |  -3.9092236458804d-03,-1.9281928542296d-02,-2.7816128668672d-02,
     |  -2.7302722823550d-02,-1.8612958208431d-02,-5.0645684052363d-03,
     |   8.9750429373590d-03, 1.9658074040988d-02, 2.4815844039355d-02,
     |   2.4348021678711d-02, 1.9823684251257d-02, 1.3574814834836d-02,
     |   7.7208908587321d-03, 3.5113868133344d-03, 1.1805351339551d-03,
     |   2.4784836603244d-04, 2.0948179945998d-05, 4.2738268011545d-08/
      data (zmn(lat, 5,14), lat = 1,72)/
     |   1.7329202298071d-08, 1.8887733314090d-06, 3.8125487792303d-05,
     |   2.5990619251676d-04, 1.0262660673234d-03, 2.8801259618025d-03,
     |   6.3426200665977d-03, 1.1561501451290d-02, 1.7963114222879d-02,
     |   2.4112254255123d-02, 2.7940985138044d-02, 2.7365825794110d-02,
     |   2.1127355867931d-02, 9.5374727788399d-03,-5.2132400997102d-03,
     |  -1.9418787988929d-02,-2.8882131500181d-02,-3.0315324374296d-02,
     |  -2.2630492971938d-02,-7.6090943802543d-03, 1.0387653648352d-02,
     |   2.5672689213835d-02, 3.3087850245365d-02, 2.9831364716835d-02,
     |   1.6584921775277d-02,-2.5244678315738d-03,-2.1191458380885d-02,
     |  -3.3040782282890d-02,-3.3856855246525d-02,-2.3134147960178d-02,
     |  -4.3615986178195d-03, 1.6104629367424d-02, 3.1215682931225d-02,
     |   3.5695615909807d-02, 2.7918858813910d-02, 1.0517005180045d-02,
     |  -1.0517005180045d-02,-2.7918858813910d-02,-3.5695615909807d-02,
     |  -3.1215682931225d-02,-1.6104629367424d-02, 4.3615986178196d-03,
     |   2.3134147960178d-02, 3.3856855246524d-02, 3.3040782282890d-02,
     |   2.1191458380885d-02, 2.5244678315738d-03,-1.6584921775277d-02,
     |  -2.9831364716835d-02,-3.3087850245365d-02,-2.5672689213836d-02,
     |  -1.0387653648352d-02, 7.6090943802543d-03, 2.2630492971938d-02,
     |   3.0315324374296d-02, 2.8882131500182d-02, 1.9418787988929d-02,
     |   5.2132400997101d-03,-9.5374727788399d-03,-2.1127355867931d-02,
     |  -2.7365825794110d-02,-2.7940985138044d-02,-2.4112254255124d-02,
     |  -1.7963114222879d-02,-1.1561501451290d-02,-6.3426200665978d-03,
     |  -2.8801259618026d-03,-1.0262660673234d-03,-2.5990619251676d-04,
     |  -3.8125487792302d-05,-1.8887733314555d-06,-1.7329202289843d-08/
      data (zmn(lat, 6,14), lat = 1,72)/
     |   3.8629496583740d-10, 1.3911848573014d-07, 4.7252264902427d-06,
     |   4.5829277759640d-05, 2.3791362787753d-04, 8.4050459796599d-04,
     |   2.2725141607962d-03, 5.0192788313718d-03, 9.4142923421835d-03,
     |   1.5349132594119d-02, 2.2034135847278d-02, 2.7958377797264d-02,
     |   3.1154243893873d-02, 2.9762104323827d-02, 2.2751411791906d-02,
     |   1.0544252308591d-02,-4.7370898837812d-03,-1.9587427250089d-02,
     |  -3.0002806021723d-02,-3.2710978303220d-02,-2.6355383849799d-02,
     |  -1.2195074940870d-02, 5.9988853208553d-03, 2.2914670945017d-02,
     |   3.3293184663565d-02, 3.3647334273084d-02, 2.3518905013484d-02,
     |   5.8007332958205d-03,-1.4051260523281d-02,-2.9710784419791d-02,
     |  -3.6042923813615d-02,-3.0842976692986d-02,-1.5643560782033d-02,
     |   4.7160924817525d-03, 2.3643478084137d-02, 3.4961308236164d-02,
     |   3.4961308236164d-02, 2.3643478084137d-02, 4.7160924817526d-03,
     |  -1.5643560782033d-02,-3.0842976692986d-02,-3.6042923813615d-02,
     |  -2.9710784419791d-02,-1.4051260523281d-02, 5.8007332958205d-03,
     |   2.3518905013484d-02, 3.3647334273084d-02, 3.3293184663565d-02,
     |   2.2914670945017d-02, 5.9988853208552d-03,-1.2195074940869d-02,
     |  -2.6355383849799d-02,-3.2710978303220d-02,-3.0002806021723d-02,
     |  -1.9587427250089d-02,-4.7370898837812d-03, 1.0544252308591d-02,
     |   2.2751411791906d-02, 2.9762104323827d-02, 3.1154243893873d-02,
     |   2.7958377797264d-02, 2.2034135847278d-02, 1.5349132594119d-02,
     |   9.4142923421835d-03, 5.0192788313718d-03, 2.2725141607963d-03,
     |   8.4050459796602d-04, 2.3791362787752d-04, 4.5829277759684d-05,
     |   4.7252264901804d-06, 1.3911848577597d-07, 3.8629497046443d-10/
      data (zmn(lat, 7,14), lat = 1,72)/
     |  -1.3275122343899d-10, 8.6078546220450d-09, 4.8297395940109d-07,
     |   6.6400873535747d-06, 4.5063145317569d-05, 1.9884629167561d-04,
     |   6.5305460509156d-04, 1.7221786249351d-03, 3.8194170121135d-03,
     |   7.3373428134006d-03, 1.2444723759931d-02, 1.8854760057916d-02,
     |   2.5663274482075d-02, 3.1365781927329d-02, 3.4123499165587d-02,
     |   3.2263654274648d-02, 2.4894923315298d-02, 1.2435863754121d-02,
     |  -3.1660979099336d-03,-1.8682617663026d-02,-3.0335588177913d-02,
     |  -3.4852256526939d-02,-3.0538187692123d-02,-1.8004902627575d-02,
     |  -2.5667264692964d-04, 1.7975230804675d-02, 3.1516155082042d-02,
     |   3.6288905584895d-02, 3.0629236154906d-02, 1.5928603590129d-02,
     |  -3.6507218873690d-03,-2.2349828673351d-02,-3.4540465976239d-02,
     |  -3.6470291655557d-02,-2.7464042313050d-02,-1.0179866312472d-02,
     |   1.0179866312472d-02, 2.7464042313050d-02, 3.6470291655557d-02,
     |   3.4540465976239d-02, 2.2349828673351d-02, 3.6507218873689d-03,
     |  -1.5928603590129d-02,-3.0629236154906d-02,-3.6288905584896d-02,
     |  -3.1516155082042d-02,-1.7975230804675d-02, 2.5667264692950d-04,
     |   1.8004902627575d-02, 3.0538187692123d-02, 3.4852256526939d-02,
     |   3.0335588177913d-02, 1.8682617663026d-02, 3.1660979099336d-03,
     |  -1.2435863754121d-02,-2.4894923315298d-02,-3.2263654274648d-02,
     |  -3.4123499165587d-02,-3.1365781927329d-02,-2.5663274482075d-02,
     |  -1.8854760057916d-02,-1.2444723759931d-02,-7.3373428134005d-03,
     |  -3.8194170121135d-03,-1.7221786249351d-03,-6.5305460509151d-04,
     |  -1.9884629167559d-04,-4.5063145317519d-05,-6.6400873535718d-06,
     |  -4.8297395941029d-07,-8.6078545852793d-09, 1.3275118950417d-10/
      data (zmn(lat, 8,14), lat = 1,72)/
     |  -1.9608359461573d-12, 4.3762934860560d-10, 4.1264572098565d-08,
     |   8.0184633217372d-07, 7.0884256930787d-06, 3.8877361412739d-05,
     |   1.5409435096379d-04, 4.8107226633055d-04, 1.2473683180327d-03,
     |   2.7807193124670d-03, 5.4554705963577d-03, 9.5704091582932d-03,
     |   1.5172002124750d-02, 2.1872450721653d-02, 2.8739525451658d-02,
     |   3.4338242945842d-02, 3.6972831853659d-02, 3.5113855758881d-02,
     |   2.7917615925144d-02, 1.5681613970609d-02, 6.0311781065059d-05,
     |  -1.6092285339537d-02,-2.9285536004720d-02,-3.6259381100051d-02,
     |  -3.4932458423192d-02,-2.5143099420620d-02,-8.9201126707664d-03,
     |   9.8617962247114d-03, 2.6405714373253d-02, 3.6269647020168d-02,
     |   3.6637798581453d-02, 2.7199060605357d-02, 1.0341586685996d-02,
     |  -9.4318029621259d-03,-2.6725581089490d-02,-3.6766486854826d-02,
     |  -3.6766486854826d-02,-2.6725581089490d-02,-9.4318029621259d-03,
     |   1.0341586685995d-02, 2.7199060605357d-02, 3.6637798581453d-02,
     |   3.6269647020168d-02, 2.6405714373253d-02, 9.8617962247115d-03,
     |  -8.9201126707664d-03,-2.5143099420620d-02,-3.4932458423191d-02,
     |  -3.6259381100051d-02,-2.9285536004720d-02,-1.6092285339537d-02,
     |   6.0311781064859d-05, 1.5681613970609d-02, 2.7917615925144d-02,
     |   3.5113855758881d-02, 3.6972831853659d-02, 3.4338242945842d-02,
     |   2.8739525451658d-02, 2.1872450721653d-02, 1.5172002124750d-02,
     |   9.5704091582932d-03, 5.4554705963578d-03, 2.7807193124670d-03,
     |   1.2473683180326d-03, 4.8107226633057d-04, 1.5409435096378d-04,
     |   3.8877361412742d-05, 7.0884256931649d-06, 8.0184633212556d-07,
     |   4.1264572160017d-08, 4.3762931706526d-10,-1.9608255630589d-12/
      data (zmn(lat, 9,14), lat = 1,72)/
     |   1.0013151484505d-12, 1.7716367011810d-11, 2.9622734167351d-09,
     |   8.1188521765831d-08, 9.3260550632516d-07, 6.3368570283548d-06,
     |   3.0184327853920d-05, 1.1095419383363d-04, 3.3402609091948d-04,
     |   8.5641653291813d-04, 1.9209999279510d-03, 3.8418415367913d-03,
     |   6.9437088713475d-03, 1.1450409548155d-02, 1.7337608521282d-02,
     |   2.4190293367960d-02, 3.1123052200942d-02, 3.6822087474945d-02,
     |   3.9744749676603d-02, 3.8466894218114d-02, 3.2111884911989d-02,
     |   2.0746441176428d-02, 5.6081997430433d-03,-1.0947904302246d-02,
     |  -2.5831245240594d-02,-3.5876548643558d-02,-3.8638899591147d-02,
     |  -3.3111562788251d-02,-2.0147736182073d-02,-2.4280018270875d-03,
     |   1.6067268114850d-02, 3.0978736359909d-02, 3.8655854365130d-02,
     |   3.7119654838190d-02, 2.6626692043209d-02, 9.6611536007176d-03,
     |  -9.6611536007176d-03,-2.6626692043209d-02,-3.7119654838190d-02,
     |  -3.8655854365130d-02,-3.0978736359909d-02,-1.6067268114850d-02,
     |   2.4280018270875d-03, 2.0147736182073d-02, 3.3111562788251d-02,
     |   3.8638899591147d-02, 3.5876548643558d-02, 2.5831245240595d-02,
     |   1.0947904302246d-02,-5.6081997430434d-03,-2.0746441176428d-02,
     |  -3.2111884911989d-02,-3.8466894218114d-02,-3.9744749676603d-02,
     |  -3.6822087474945d-02,-3.1123052200942d-02,-2.4190293367960d-02,
     |  -1.7337608521282d-02,-1.1450409548155d-02,-6.9437088713476d-03,
     |  -3.8418415367913d-03,-1.9209999279510d-03,-8.5641653291816d-04,
     |  -3.3402609091955d-04,-1.1095419383363d-04,-3.0184327853959d-05,
     |  -6.3368570283439d-06,-9.3260550634971d-07,-8.1188521767814d-08,
     |  -2.9622734009267d-09,-1.7716376799873d-11,-1.0012564074312d-12/
      data (zmn(lat,10,14), lat = 1,72)/
     |   1.0086940608818d-14, 6.4197810194230d-13, 1.7817052923431d-10,
     |   6.8815944053296d-09, 1.0253367900674d-07, 8.6113289893166d-07,
     |   4.9149389098718d-06, 2.1194104786254d-05, 7.3739895319412d-05,
     |   2.1619775825424d-04, 5.5045901775587d-04, 1.2435759610266d-03,
     |   2.5324076553838d-03, 4.7029615452640d-03, 8.0338374436493d-03,
     |   1.2702200649397d-02, 1.8665497181099d-02, 2.5548790033391d-02,
     |   3.2579819590781d-02, 3.8614882317111d-02, 4.2283882016013d-02,
     |   4.2252788720803d-02, 3.7562646754545d-02, 2.7967714022890d-02,
     |   1.4174727037093d-02,-2.1085369384051d-03,-1.8370597372498d-02,
     |  -3.1733653796174d-02,-3.9554983577312d-02,-4.0057729742701d-02,
     |  -3.2829325497122d-02,-1.9042455432515d-02,-1.3137532202982d-03,
     |   1.6794391201704d-02, 3.1527658222729d-02, 3.9774056087565d-02,
     |   3.9774056087565d-02, 3.1527658222729d-02, 1.6794391201705d-02,
     |  -1.3137532202982d-03,-1.9042455432515d-02,-3.2829325497122d-02,
     |  -4.0057729742701d-02,-3.9554983577312d-02,-3.1733653796174d-02,
     |  -1.8370597372498d-02,-2.1085369384052d-03, 1.4174727037093d-02,
     |   2.7967714022890d-02, 3.7562646754545d-02, 4.2252788720803d-02,
     |   4.2283882016013d-02, 3.8614882317111d-02, 3.2579819590781d-02,
     |   2.5548790033391d-02, 1.8665497181099d-02, 1.2702200649397d-02,
     |   8.0338374436492d-03, 4.7029615452640d-03, 2.5324076553838d-03,
     |   1.2435759610267d-03, 5.5045901775584d-04, 2.1619775825428d-04,
     |   7.3739895319488d-05, 2.1194104786260d-05, 4.9149389098709d-06,
     |   8.6113289891383d-07, 1.0253367893637d-07, 6.8815944273554d-09,
     |   1.7817051078402d-10, 6.4200361523301d-13, 1.0101603172649d-14/
      data (zmn(lat,11,14), lat = 1,72)/
     |  -5.5520328565918d-15, 2.4762273605502d-14, 8.8795581396475d-12,
     |   4.8314475599896d-10, 9.3252409781978d-09, 9.6640154786959d-08,
     |   6.5950864110676d-07, 3.3274089286500d-06, 1.3336403053369d-05,
     |   4.4536255779337d-05, 1.2809094720016d-04, 3.2495277265224d-04,
     |   7.4010535047515d-04, 1.5336634959194d-03, 2.9211449642523d-03,
     |   5.1540892986028d-03, 8.4742451885985d-03, 1.3040652650181d-02,
     |   1.8838592636428d-02, 2.5590314465670d-02, 3.2695998891387d-02,
     |   3.9235465322781d-02, 4.4053641277832d-02, 4.5935279257249d-02,
     |   4.3849754509311d-02, 3.7221159261272d-02, 2.6160281201311d-02,
     |   1.1590813615951d-02,-4.7834760898502d-03,-2.0691784197361d-02,
     |  -3.3667380050624d-02,-4.1511065196421d-02,-4.2749778751561d-02,
     |  -3.6983974617599d-02,-2.5035215938713d-02,-8.8475175350734d-03,
     |   8.8475175350733d-03, 2.5035215938713d-02, 3.6983974617599d-02,
     |   4.2749778751560d-02, 4.1511065196421d-02, 3.3667380050624d-02,
     |   2.0691784197361d-02, 4.7834760898503d-03,-1.1590813615951d-02,
     |  -2.6160281201311d-02,-3.7221159261272d-02,-4.3849754509311d-02,
     |  -4.5935279257249d-02,-4.4053641277832d-02,-3.9235465322781d-02,
     |  -3.2695998891387d-02,-2.5590314465670d-02,-1.8838592636428d-02,
     |  -1.3040652650181d-02,-8.4742451885985d-03,-5.1540892986028d-03,
     |  -2.9211449642522d-03,-1.5336634959194d-03,-7.4010535047512d-04,
     |  -3.2495277265223d-04,-1.2809094720013d-04,-4.4536255779337d-05,
     |  -1.3336403053359d-05,-3.3274089286497d-06,-6.5950864108355d-07,
     |  -9.6640154798835d-08,-9.3252409726566d-09,-4.8314478021526d-10,
     |  -8.8795682554436d-12,-2.4775716013128d-14, 5.5302923629575d-15/
      data (zmn(lat,12,14), lat = 1,72)/
     |  -1.5940932794975d-16, 4.6347230875534d-16, 3.5818166824900d-13,
     |   2.7421021691087d-11, 6.8493566879580d-10, 8.7475479260147d-09,
     |   7.1264097837875d-08, 4.1985118967073d-07, 1.9339433748406d-06,
     |   7.3351070312105d-06, 2.3749537695807d-05, 6.7379042810771d-05,
     |   1.7078730003924d-04, 3.9253285627450d-04, 8.2750027129292d-04,
     |   1.6145094394098d-03, 2.9361721986331d-03, 5.0053275712845d-03,
     |   8.0335560292433d-03, 1.2180747953946d-02, 1.7490291848804d-02,
     |   2.3821076168203d-02, 3.0793290387703d-02, 3.7767725219495d-02,
     |   4.3875996641576d-02, 4.8111033974225d-02, 4.9474115430779d-02,
     |   4.7159315573432d-02, 4.0742369719937d-02, 3.0332907484715d-02,
     |   1.6650069731865d-02, 9.9290967487384d-04,-1.4902862042037d-02,
     |  -2.9105498121150d-02,-3.9785527703298d-02,-4.5516148408706d-02,
     |  -4.5516148408706d-02,-3.9785527703298d-02,-2.9105498121150d-02,
     |  -1.4902862042037d-02, 9.9290967487379d-04, 1.6650069731865d-02,
     |   3.0332907484714d-02, 4.0742369719937d-02, 4.7159315573432d-02,
     |   4.9474115430779d-02, 4.8111033974225d-02, 4.3875996641576d-02,
     |   3.7767725219495d-02, 3.0793290387703d-02, 2.3821076168203d-02,
     |   1.7490291848804d-02, 1.2180747953946d-02, 8.0335560292433d-03,
     |   5.0053275712845d-03, 2.9361721986331d-03, 1.6145094394098d-03,
     |   8.2750027129291d-04, 3.9253285627449d-04, 1.7078730003924d-04,
     |   6.7379042810771d-05, 2.3749537695845d-05, 7.3351070312162d-06,
     |   1.9339433748009d-06, 4.1985118968432d-07, 7.1264097828586d-08,
     |   8.7475479358604d-09, 6.8493565087337d-10, 2.7421050315399d-11,
     |   3.5820096046145d-13, 4.8189767807351d-16,-1.4342694612592d-16/
      data (zmn(lat,13,14), lat = 1,72)/
     |  -3.1913844074790d-18,-6.5537862633287d-17, 1.1008988914476d-14,
     |   1.1937884704763d-12, 3.8565134523108d-11, 6.0637634262381d-10,
     |   5.8899916343928d-09, 4.0460309819653d-08, 2.1380353780417d-07,
     |   9.1904999543154d-07, 3.3414503756266d-06, 1.0570021565823d-05,
     |   2.9711870436037d-05, 7.5424849865953d-05, 1.7510823441019d-04,
     |   3.7553474394496d-04, 7.4995185888801d-04, 1.4037312243521d-03,
     |   2.4757563183865d-03, 4.1322843405409d-03, 6.5503976338085d-03,
     |   9.8896528060643d-03, 1.4253148998507d-02, 1.9642599308938d-02,
     |   2.5915350960547d-02, 3.2753664343182d-02, 3.9656941641163d-02,
     |   4.5965331206760d-02, 5.0918171843830d-02, 5.3743786379148d-02,
     |   5.3769587210293d-02, 5.0535130231649d-02, 4.3887418794294d-02,
     |   3.4038644082730d-02, 2.1571933602374d-02, 7.3897264928024d-03,
     |  -7.3897264928023d-03,-2.1571933602374d-02,-3.4038644082730d-02,
     |  -4.3887418794294d-02,-5.0535130231649d-02,-5.3769587210293d-02,
     |  -5.3743786379148d-02,-5.0918171843830d-02,-4.5965331206760d-02,
     |  -3.9656941641163d-02,-3.2753664343182d-02,-2.5915350960547d-02,
     |  -1.9642599308938d-02,-1.4253148998507d-02,-9.8896528060643d-03,
     |  -6.5503976338085d-03,-4.1322843405409d-03,-2.4757563183865d-03,
     |  -1.4037312243521d-03,-7.4995185888801d-04,-3.7553474394496d-04,
     |  -1.7510823441021d-04,-7.5424849865963d-05,-2.9711870436061d-05,
     |  -1.0570021565830d-05,-3.3414503756661d-06,-9.1904999543872d-07,
     |  -2.1380353780321d-07,-4.0460309828091d-08,-5.8899916544239d-09,
     |  -6.0637637009717d-10,-3.8565181276243d-11,-1.1937996845694d-12,
     |  -1.1030833172142d-14, 6.3803008079825d-17,-1.1265890186189d-17/
      data (zmn(lat,14,14), lat = 1,72)/
     |  -1.7127397711860d-16,-1.6345009726466d-16, 7.1033870068012d-17,
     |   3.4576653699772d-14, 1.4495688689272d-12, 2.8040954379261d-11,
     |   3.2444008629564d-10, 2.5955621994594d-09, 1.5712672626089d-08,
     |   7.6422843407207d-08, 3.1140889207038d-07, 1.0958914357820d-06,
     |   3.4072751854229d-06, 9.5241894500758d-06, 2.4264311816047d-05,
     |   5.6958961998077d-05, 1.2429175143407d-04, 2.5395060824459d-04,
     |   4.8874752119671d-04, 8.9047810232380d-04, 1.5424023917888d-03,
     |   2.5489516910506d-03, 4.0312452720117d-03, 6.1173553429754d-03,
     |   8.9270384166756d-03, 1.2551795909597d-02, 1.7032450357699d-02,
     |   2.2337634798739d-02, 2.8347353855549d-02, 3.4845787868344d-02,
     |   4.1526610111777d-02, 4.8012308430278d-02, 5.3886610072446d-02,
     |   5.8736556067648d-02, 6.2198609637052d-02, 6.4001928130153d-02,
     |   6.4001928130153d-02, 6.2198609637052d-02, 5.8736556067648d-02,
     |   5.3886610072446d-02, 4.8012308430278d-02, 4.1526610111777d-02,
     |   3.4845787868344d-02, 2.8347353855549d-02, 2.2337634798739d-02,
     |   1.7032450357699d-02, 1.2551795909597d-02, 8.9270384166757d-03,
     |   6.1173553429754d-03, 4.0312452720117d-03, 2.5489516910506d-03,
     |   1.5424023917888d-03, 8.9047810232381d-04, 4.8874752119673d-04,
     |   2.5395060824459d-04, 1.2429175143410d-04, 5.6958961998082d-05,
     |   2.4264311816057d-05, 9.5241894500749d-06, 3.4072751854130d-06,
     |   1.0958914357766d-06, 3.1140889205979d-07, 7.6422843392342d-08,
     |   1.5712672629678d-08, 2.5955621937259d-09, 3.2444009122329d-10,
     |   2.8040950539441d-11, 1.4495737266687d-12, 3.4558666294943d-14,
     |   5.6026111230479d-17,-1.8371954467168d-16,-1.7887113274097d-16/
      data (zmn(lat, 0,15), lat = 1,72)/
     |   3.1494322092905d-03, 8.8109423000522d-03, 7.3566529414800d-03,
     |   6.5261651513006d-04,-9.3445617405171d-03,-1.6327647365692d-02,
     |  -1.6674164093823d-02,-8.4727705621394d-03, 4.7168357830660d-03,
     |   1.7460016154981d-02, 2.3069174531882d-02, 1.8579183501509d-02,
     |   4.8997590714976d-03,-1.1906751224514d-02,-2.4523811513778d-02,
     |  -2.6544842662705d-02,-1.6700160569201d-02, 1.3677422336456d-03,
     |   1.9540190632814d-02, 2.9764930512868d-02, 2.6848203344839d-02,
     |   1.1842554094529d-02,-9.0757316648541d-03,-2.6443335091705d-02,
     |  -3.2528423859986d-02,-2.4120012885519d-02,-4.8473453585662d-03,
     |   1.7050110869386d-02, 3.1640756758400d-02, 3.2458397371181d-02,
     |   1.8778338061274d-02,-3.3005613012133d-03,-2.4191155842113d-02,
     |  -3.4425588365298d-02,-2.9557368738799d-02,-1.1528368252871d-02,
     |   1.1528368252871d-02, 2.9557368738799d-02, 3.4425588365298d-02,
     |   2.4191155842113d-02, 3.3005613012134d-03,-1.8778338061274d-02,
     |  -3.2458397371181d-02,-3.1640756758400d-02,-1.7050110869386d-02,
     |   4.8473453585662d-03, 2.4120012885519d-02, 3.2528423859986d-02,
     |   2.6443335091705d-02, 9.0757316648541d-03,-1.1842554094529d-02,
     |  -2.6848203344839d-02,-2.9764930512869d-02,-1.9540190632815d-02,
     |  -1.3677422336456d-03, 1.6700160569201d-02, 2.6544842662705d-02,
     |   2.4523811513778d-02, 1.1906751224514d-02,-4.8997590714975d-03,
     |  -1.8579183501509d-02,-2.3069174531882d-02,-1.7460016154981d-02,
     |  -4.7168357830661d-03, 8.4727705621394d-03, 1.6674164093823d-02,
     |   1.6327647365692d-02, 9.3445617405172d-03,-6.5261651512999d-04,
     |  -7.3566529414799d-03,-8.8109423000522d-03,-3.1494322092905d-03/
      data (zmn(lat, 1,15), lat = 1,72)/
     |   7.1174305137785d-04, 4.9670824353727d-03, 1.0818293823132d-02,
     |   1.3798568874907d-02, 1.0874876156244d-02, 1.9036712306710d-03,
     |  -9.7208855643497d-03,-1.8642583571023d-02,-2.0059221878470d-02,
     |  -1.2335935426623d-02, 1.8902624813520d-03, 1.6562088505395d-02,
     |   2.4881018047574d-02, 2.2485584964819d-02, 9.7218144623474d-03,
     |  -8.2281255250946d-03,-2.3463892721783d-02,-2.8905827625553d-02,
     |  -2.1602234063168d-02,-4.2921730907251d-03, 1.5617352245159d-02,
     |   2.9249367447421d-02, 3.0260060549687d-02, 1.7802160952230d-02,
     |  -2.9199135699612d-03,-2.2845478465185d-02,-3.3051948410735d-02,
     |  -2.8785787887708d-02,-1.1683166312436d-02, 1.0848998438584d-02,
     |   2.8869711422989d-02, 3.4323300172199d-02, 2.4668782756298d-02,
     |   4.0669757138009d-03,-1.8425772796402d-02,-3.2870484645651d-02,
     |  -3.2870484645651d-02,-1.8425772796403d-02, 4.0669757138008d-03,
     |   2.4668782756298d-02, 3.4323300172199d-02, 2.8869711422989d-02,
     |   1.0848998438584d-02,-1.1683166312435d-02,-2.8785787887708d-02,
     |  -3.3051948410735d-02,-2.2845478465185d-02,-2.9199135699614d-03,
     |   1.7802160952230d-02, 3.0260060549687d-02, 2.9249367447421d-02,
     |   1.5617352245159d-02,-4.2921730907251d-03,-2.1602234063168d-02,
     |  -2.8905827625553d-02,-2.3463892721783d-02,-8.2281255250947d-03,
     |   9.7218144623475d-03, 2.2485584964819d-02, 2.4881018047574d-02,
     |   1.6562088505395d-02, 1.8902624813521d-03,-1.2335935426623d-02,
     |  -2.0059221878470d-02,-1.8642583571023d-02,-9.7208855643496d-03,
     |   1.9036712306710d-03, 1.0874876156244d-02, 1.3798568874907d-02,
     |   1.0818293823132d-02, 4.9670824353728d-03, 7.1174305137786d-04/
      data (zmn(lat, 2,15), lat = 1,72)/
     |   6.0011755234505d-05, 1.3122516200380d-03, 5.2169645645327d-03,
     |   1.1111308520471d-02, 1.6358923901003d-02, 1.7497005678714d-02,
     |   1.2342017510343d-02, 1.4567974971202d-03,-1.1484322637789d-02,
     |  -2.1113279282335d-02,-2.2718600532614d-02,-1.4697768925053d-02,
     |   3.5300469719082d-04, 1.6358856485898d-02, 2.6308412210014d-02,
     |   2.5362124970306d-02, 1.3268300756752d-02,-5.2562959844265d-03,
     |  -2.2333426974547d-02,-3.0348525492002d-02,-2.5363967002800d-02,
     |  -9.0846505565058d-03, 1.1708612074722d-02, 2.7980340251018d-02,
     |   3.2432104814935d-02, 2.2785065091949d-02, 2.9582999025897d-03,
     |  -1.8549273718211d-02,-3.2310742521724d-02,-3.2161682104945d-02,
     |  -1.7963837680886d-02, 4.2218773866389d-03, 2.4762612543563d-02,
     |   3.4649752336333d-02, 2.9502739543008d-02, 1.1505674805028d-02,
     |  -1.1505674805028d-02,-2.9502739543008d-02,-3.4649752336333d-02,
     |  -2.4762612543563d-02,-4.2218773866389d-03, 1.7963837680886d-02,
     |   3.2161682104945d-02, 3.2310742521724d-02, 1.8549273718211d-02,
     |  -2.9582999025897d-03,-2.2785065091949d-02,-3.2432104814935d-02,
     |  -2.7980340251018d-02,-1.1708612074722d-02, 9.0846505565059d-03,
     |   2.5363967002800d-02, 3.0348525492002d-02, 2.2333426974547d-02,
     |   5.2562959844266d-03,-1.3268300756752d-02,-2.5362124970306d-02,
     |  -2.6308412210014d-02,-1.6358856485898d-02,-3.5300469719089d-04,
     |   1.4697768925053d-02, 2.2718600532613d-02, 2.1113279282335d-02,
     |   1.1484322637789d-02,-1.4567974971201d-03,-1.2342017510344d-02,
     |  -1.7497005678714d-02,-1.6358923901003d-02,-1.1111308520471d-02,
     |  -5.2169645645327d-03,-1.3122516200381d-03,-6.0011755234515d-05/
      data (zmn(lat, 3,15), lat = 1,72)/
     |   1.3703427589161d-06, 2.2592235764058d-04, 1.5458230119677d-03,
     |   4.9611740564911d-03, 1.0537845435780d-02, 1.6777672101214d-02,
     |   2.0875954209316d-02, 1.9923446002149d-02, 1.2507702435753d-02,
     |  -1.0621427922744d-04,-1.3952787523509d-02,-2.3708442806534d-02,
     |  -2.4940658714732d-02,-1.6275003028670d-02,-4.2232047121766d-04,
     |   1.6561324428771d-02, 2.7619799900460d-02, 2.7716060218876d-02,
     |   1.6195572117036d-02,-2.6307900091899d-03,-2.1073314049252d-02,
     |  -3.1240112460869d-02,-2.8471859366922d-02,-1.3513893103618d-02,
     |   7.5973874486882d-03, 2.5978084453685d-02, 3.3673621408670d-02,
     |   2.7144554177760d-02, 8.9145919386663d-03,-1.3392594236392d-02,
     |  -3.0264845162965d-02,-3.4395825140391d-02,-2.3882115725990d-02,
     |  -3.1093026897133d-03, 1.9088233468288d-02, 3.3215886336647d-02,
     |   3.3215886336647d-02, 1.9088233468288d-02,-3.1093026897133d-03,
     |  -2.3882115725990d-02,-3.4395825140391d-02,-3.0264845162965d-02,
     |  -1.3392594236392d-02, 8.9145919386662d-03, 2.7144554177760d-02,
     |   3.3673621408670d-02, 2.5978084453685d-02, 7.5973874486884d-03,
     |  -1.3513893103618d-02,-2.8471859366922d-02,-3.1240112460869d-02,
     |  -2.1073314049252d-02,-2.6307900091898d-03, 1.6195572117036d-02,
     |   2.7716060218876d-02, 2.7619799900460d-02, 1.6561324428771d-02,
     |  -4.2232047121778d-04,-1.6275003028671d-02,-2.4940658714732d-02,
     |  -2.3708442806534d-02,-1.3952787523509d-02,-1.0621427922751d-04,
     |   1.2507702435752d-02, 1.9923446002149d-02, 2.0875954209316d-02,
     |   1.6777672101214d-02, 1.0537845435780d-02, 4.9611740564912d-03,
     |   1.5458230119677d-03, 2.2592235764058d-04, 1.3703427589296d-06/
      data (zmn(lat, 4,15), lat = 1,72)/
     |   5.7392491234628d-08, 2.8282991987967d-05, 3.3068678824545d-04,
     |   1.5464923943417d-03, 4.4822940015299d-03, 9.5158146257519d-03,
     |   1.5959198892036d-02, 2.1843788395845d-02, 2.4417091903988d-02,
     |   2.1291418329248d-02, 1.1774680256849d-02,-2.2835376153501d-03,
     |  -1.6687964668267d-02,-2.6252711432143d-02,-2.6879871470723d-02,
     |  -1.7495410608073d-02,-9.2597824153612d-04, 1.6828462583313d-02,
     |   2.8787083879069d-02, 2.9827448630065d-02, 1.8975946901216d-02,
     |   1.0043792055318d-04,-1.9420216057734d-02,-3.1605549004065d-02,
     |  -3.1198955784339d-02,-1.7993230208011d-02, 2.8914621120481d-03,
     |   2.2985423068886d-02, 3.3936398811296d-02, 3.1030170893325d-02,
     |   1.5256724464598d-02,-6.9965039026732d-03,-2.6546146675968d-02,
     |  -3.5238807836042d-02,-2.9390487557690d-02,-1.1368869805253d-02,
     |   1.1368869805253d-02, 2.9390487557690d-02, 3.5238807836042d-02,
     |   2.6546146675968d-02, 6.9965039026733d-03,-1.5256724464598d-02,
     |  -3.1030170893325d-02,-3.3936398811296d-02,-2.2985423068886d-02,
     |  -2.8914621120482d-03, 1.7993230208011d-02, 3.1198955784339d-02,
     |   3.1605549004065d-02, 1.9420216057734d-02,-1.0043792055325d-04,
     |  -1.8975946901216d-02,-2.9827448630065d-02,-2.8787083879069d-02,
     |  -1.6828462583313d-02, 9.2597824153606d-04, 1.7495410608073d-02,
     |   2.6879871470723d-02, 2.6252711432143d-02, 1.6687964668267d-02,
     |   2.2835376153500d-03,-1.1774680256849d-02,-2.1291418329248d-02,
     |  -2.4417091903988d-02,-2.1843788395845d-02,-1.5959198892036d-02,
     |  -9.5158146257519d-03,-4.4822940015300d-03,-1.5464923943417d-03,
     |  -3.3068678824536d-04,-2.8282991987887d-05,-5.7392491194847d-08/
      data (zmn(lat, 5,15), lat = 1,72)/
     |   2.3621479507413d-08, 2.7485627922705d-06, 5.4908216119781d-05,
     |   3.6876669010173d-04, 1.4262113225035d-03, 3.8945899484573d-03,
     |   8.2797306238917d-03, 1.4425205002819d-02, 2.1132485651169d-02,
     |   2.6206905940297d-02, 2.7082337992477d-02, 2.1890657378373d-02,
     |   1.0557185809276d-02,-4.6231581610744d-03,-1.9342743692935d-02,
     |  -2.8617165137505d-02,-2.8686991055043d-02,-1.8733951184849d-02,
     |  -1.6239232761833d-03, 1.6786755481092d-02, 2.9667391261617d-02,
     |   3.1842763344421d-02, 2.1986079595100d-02, 3.4131750633212d-03,
     |  -1.6966151952760d-02,-3.1232086584558d-02,-3.3594188692367d-02,
     |  -2.2812593468092d-02,-2.8618803560798d-03, 1.8512146009156d-02,
     |   3.2823792070035d-02, 3.4264997208205d-02, 2.2108719034034d-02,
     |   1.0837913856196d-03,-2.0471191530941d-02,-3.3948217727322d-02,
     |  -3.3948217727322d-02,-2.0471191530941d-02, 1.0837913856195d-03,
     |   2.2108719034034d-02, 3.4264997208205d-02, 3.2823792070035d-02,
     |   1.8512146009156d-02,-2.8618803560797d-03,-2.2812593468092d-02,
     |  -3.3594188692367d-02,-3.1232086584558d-02,-1.6966151952760d-02,
     |   3.4131750633212d-03, 2.1986079595101d-02, 3.1842763344421d-02,
     |   2.9667391261617d-02, 1.6786755481092d-02,-1.6239232761832d-03,
     |  -1.8733951184849d-02,-2.8686991055043d-02,-2.8617165137505d-02,
     |  -1.9342743692935d-02,-4.6231581610743d-03, 1.0557185809276d-02,
     |   2.1890657378373d-02, 2.7082337992477d-02, 2.6206905940297d-02,
     |   2.1132485651169d-02, 1.4425205002819d-02, 8.2797306238917d-03,
     |   3.8945899484574d-03, 1.4262113225035d-03, 3.6876669010172d-04,
     |   5.4908216119801d-05, 2.7485627923321d-06, 2.3621479486134d-08/
      data (zmn(lat, 6,15), lat = 1,72)/
     |   6.1720196342791d-10, 2.1868014409844d-07, 7.3670595461224d-06,
     |   7.0552062800667d-05, 3.5995246293679d-04, 1.2433138347504d-03,
     |   3.2675113918327d-03, 6.9667481058696d-03, 1.2507877636321d-02,
     |   1.9307690330935d-02, 2.5844905634808d-02, 2.9871888017897d-02,
     |   2.9086203656187d-02, 2.2095939058115d-02, 9.3083508325758d-03,
     |  -6.6980016329249d-03,-2.1625156687178d-02,-3.0728862970057d-02,
     |  -3.0537294554180d-02,-2.0370485176192d-02,-2.9916459117654d-03,
     |   1.6008923049171d-02, 3.0014703725175d-02, 3.3778568247699d-02,
     |   2.5510036686495d-02, 7.7883124022156d-03,-1.3159931091658d-02,
     |  -2.9648115429712d-02,-3.5405410566500d-02,-2.8036922131814d-02,
     |  -1.0073211948343d-02, 1.1864467062640d-02, 2.9519026825633d-02,
     |   3.6149991763957d-02, 2.9156210652191d-02, 1.1125256275410d-02,
     |  -1.1125256275410d-02,-2.9156210652191d-02,-3.6149991763957d-02,
     |  -2.9519026825633d-02,-1.1864467062640d-02, 1.0073211948343d-02,
     |   2.8036922131814d-02, 3.5405410566500d-02, 2.9648115429712d-02,
     |   1.3159931091658d-02,-7.7883124022155d-03,-2.5510036686495d-02,
     |  -3.3778568247699d-02,-3.0014703725175d-02,-1.6008923049171d-02,
     |   2.9916459117652d-03, 2.0370485176192d-02, 3.0537294554180d-02,
     |   3.0728862970057d-02, 2.1625156687179d-02, 6.6980016329250d-03,
     |  -9.3083508325760d-03,-2.2095939058115d-02,-2.9086203656187d-02,
     |  -2.9871888017897d-02,-2.5844905634808d-02,-1.9307690330935d-02,
     |  -1.2507877636321d-02,-6.9667481058697d-03,-3.2675113918327d-03,
     |  -1.2433138347505d-03,-3.5995246293680d-04,-7.0552062800664d-05,
     |  -7.3670595461708d-06,-2.1868014413945d-07,-6.1720192727638d-10/
      data (zmn(lat, 7,15), lat = 1,72)/
     |  -2.0440159822476d-10, 1.4676183255751d-08, 8.1883572904984d-07,
     |   1.1134216332089d-05, 7.4440678330520d-05, 3.2222310696063d-04,
     |   1.0332551639718d-03, 2.6464929689181d-03, 5.6660674820797d-03,
     |   1.0431671037389d-02, 1.6802991417620d-02, 2.3890233275282d-02,
     |   3.0004646817712d-02, 3.2962454156898d-02, 3.0746588554235d-02,
     |   2.2354498524968d-02, 8.5144415636635d-03,-8.0814956614126d-03,
     |  -2.3257662123928d-02,-3.2522804937236d-02,-3.2600801550987d-02,
     |  -2.2783107817676d-02,-5.5394063372314d-03, 1.3965105652717d-02,
     |   2.9407934929069d-02, 3.5440012602570d-02, 2.9659058457375d-02,
     |   1.3661306942036d-02,-7.3020977003720d-03,-2.6033988724991d-02,
     |  -3.5905895083480d-02,-3.3275451967988d-02,-1.8894190277490d-02,
     |   2.2601540552401d-03, 2.2712111490580d-02, 3.5168841154277d-02,
     |   3.5168841154277d-02, 2.2712111490580d-02, 2.2601540552402d-03,
     |  -1.8894190277490d-02,-3.3275451967988d-02,-3.5905895083480d-02,
     |  -2.6033988724991d-02,-7.3020977003721d-03, 1.3661306942036d-02,
     |   2.9659058457375d-02, 3.5440012602570d-02, 2.9407934929069d-02,
     |   1.3965105652717d-02,-5.5394063372315d-03,-2.2783107817676d-02,
     |  -3.2600801550987d-02,-3.2522804937236d-02,-2.3257662123928d-02,
     |  -8.0814956614127d-03, 8.5144415636635d-03, 2.2354498524968d-02,
     |   3.0746588554235d-02, 3.2962454156898d-02, 3.0004646817712d-02,
     |   2.3890233275282d-02, 1.6802991417620d-02, 1.0431671037389d-02,
     |   5.6660674820798d-03, 2.6464929689182d-03, 1.0332551639717d-03,
     |   3.2222310696058d-04, 7.4440678330514d-05, 1.1134216332081d-05,
     |   8.1883572904149d-07, 1.4676183213524d-08,-2.0440159263485d-10/
      data (zmn(lat, 8,15), lat = 1,72)/
     |  -3.7490664566278d-12, 8.1746628566797d-10, 7.6566027629107d-08,
     |   1.4734423719377d-06, 1.2855123801642d-05, 6.9330958377629d-05,
     |   2.6916858518279d-04, 8.1959972108888d-04, 2.0628844617065d-03,
     |   4.4398878716029d-03, 8.3565155595745d-03, 1.3956214326574d-02,
     |   2.0860576637419d-02, 2.7993901571931d-02, 3.3622861184757d-02,
     |   3.5695183233595d-02, 3.2453225566017d-02, 2.3163489449583d-02,
     |   8.6988304091147d-03,-8.3058589294203d-03,-2.3901265507583d-02,
     |  -3.3848193844433d-02,-3.4955737732273d-02,-2.6293863102545d-02,
     |  -9.8112000658602d-03, 9.9588083168424d-03, 2.7120533918608d-02,
     |   3.6238449441421d-02, 3.4169385535899d-02, 2.1252242352196d-02,
     |   1.3813119233436d-03,-1.9138882847386d-02,-3.3622872989763d-02,
     |  -3.7244582453169d-02,-2.8708675458378d-02,-1.0748726447799d-02,
     |   1.0748726447799d-02, 2.8708675458378d-02, 3.7244582453169d-02,
     |   3.3622872989763d-02, 1.9138882847386d-02,-1.3813119233437d-03,
     |  -2.1252242352196d-02,-3.4169385535899d-02,-3.6238449441421d-02,
     |  -2.7120533918608d-02,-9.9588083168425d-03, 9.8112000658600d-03,
     |   2.6293863102545d-02, 3.4955737732273d-02, 3.3848193844433d-02,
     |   2.3901265507583d-02, 8.3058589294204d-03,-8.6988304091146d-03,
     |  -2.3163489449583d-02,-3.2453225566017d-02,-3.5695183233595d-02,
     |  -3.3622861184757d-02,-2.7993901571931d-02,-2.0860576637419d-02,
     |  -1.3956214326574d-02,-8.3565155595744d-03,-4.4398878716030d-03,
     |  -2.0628844617064d-03,-8.1959972108885d-04,-2.6916858518270d-04,
     |  -6.9330958377593d-05,-1.2855123801600d-05,-1.4734423719148d-06,
     |  -7.6566027628696d-08,-8.1746624687169d-10, 3.7490518664281d-12/
      data (zmn(lat, 9,15), lat = 1,72)/
     |   1.8174994624108d-12, 3.6767971838341d-11, 6.0704700783329d-09,
     |   1.6494120787852d-07, 1.8725217489137d-06, 1.2534754138936d-05,
     |   5.8624033609088d-05, 2.1082694262903d-04, 6.1851716653769d-04,
     |   1.5387541676531d-03, 3.3328390291461d-03, 6.4003658001644d-03,
     |   1.1035145275029d-02, 1.7220938060064d-02, 2.4428205200767d-02,
     |   3.1506680533158d-02, 3.6770293666742d-02, 3.8326875879447d-02,
     |   3.4619451347435d-02, 2.5044676268672d-02, 1.0438165623949d-02,
     |  -6.7933014486275d-03,-2.3034918855845d-02,-3.4310895564578d-02,
     |  -3.7420905958276d-02,-3.1026813642577d-02,-1.6308468760664d-02,
     |   3.0989368897406d-03, 2.1959956483238d-02, 3.4892124658458d-02,
     |   3.7994062603704d-02, 3.0124552223342d-02, 1.3385228066232d-02,
     |  -7.4004923489281d-03,-2.6091826633834d-02,-3.7094986728126d-02,
     |  -3.7094986728126d-02,-2.6091826633834d-02,-7.4004923489282d-03,
     |   1.3385228066232d-02, 3.0124552223342d-02, 3.7994062603704d-02,
     |   3.4892124658458d-02, 2.1959956483238d-02, 3.0989368897407d-03,
     |  -1.6308468760664d-02,-3.1026813642577d-02,-3.7420905958276d-02,
     |  -3.4310895564578d-02,-2.3034918855845d-02,-6.7933014486275d-03,
     |   1.0438165623949d-02, 2.5044676268672d-02, 3.4619451347435d-02,
     |   3.8326875879447d-02, 3.6770293666742d-02, 3.1506680533158d-02,
     |   2.4428205200767d-02, 1.7220938060064d-02, 1.1035145275030d-02,
     |   6.4003658001643d-03, 3.3328390291461d-03, 1.5387541676531d-03,
     |   6.1851716653768d-04, 2.1082694262902d-04, 5.8624033609090d-05,
     |   1.2534754138983d-05, 1.8725217488828d-06, 1.6494120786252d-07,
     |   6.0704700586625d-09, 3.6768002759092d-11, 1.8175226557682d-12/
      data (zmn(lat,10,15), lat = 1,72)/
     |   2.4068007540613d-14, 1.4780514040356d-12, 4.0857083289129d-10,
     |   1.5656344474577d-08, 2.3080926444859d-07, 1.9125480085501d-06,
     |   1.0738181463707d-05, 4.5408982491363d-05, 1.5441729698808d-04,
     |   4.4090844657729d-04, 1.0889697186490d-03, 2.3760590860435d-03,
     |   4.6501474645670d-03, 8.2523928434664d-03, 1.3381034742567d-02,
     |   1.9918820526753d-02, 2.7276769369994d-02, 3.4327871531039d-02,
     |   3.9501021875277d-02, 4.1069850283823d-02, 3.7607102010774d-02,
     |   2.8500935854223d-02, 1.4372969889310d-02,-2.7727495677132d-03,
     |  -1.9789340208662d-02,-3.3026802587455d-02,-3.9248048395735d-02,
     |  -3.6580026342891d-02,-2.5205791725476d-02,-7.5442863225562d-03,
     |   1.2202029838030d-02, 2.9061309854206d-02, 3.8610943337717d-02,
     |   3.8224795259371d-02, 2.7869011316759d-02, 1.0185789875424d-02,
     |  -1.0185789875424d-02,-2.7869011316758d-02,-3.8224795259371d-02,
     |  -3.8610943337717d-02,-2.9061309854206d-02,-1.2202029838029d-02,
     |   7.5442863225561d-03, 2.5205791725476d-02, 3.6580026342891d-02,
     |   3.9248048395735d-02, 3.3026802587455d-02, 1.9789340208662d-02,
     |   2.7727495677132d-03,-1.4372969889310d-02,-2.8500935854223d-02,
     |  -3.7607102010774d-02,-4.1069850283824d-02,-3.9501021875277d-02,
     |  -3.4327871531039d-02,-2.7276769369994d-02,-1.9918820526753d-02,
     |  -1.3381034742567d-02,-8.2523928434664d-03,-4.6501474645670d-03,
     |  -2.3760590860434d-03,-1.0889697186490d-03,-4.4090844657718d-04,
     |  -1.5441729698805d-04,-4.5408982491353d-05,-1.0738181463705d-05,
     |  -1.9125480085157d-06,-2.3080926449647d-07,-1.5656344509662d-08,
     |  -4.0857078489316d-10,-1.4781203674215d-12,-2.4086318181397d-14/
      data (zmn(lat,11,15), lat = 1,72)/
     |  -1.2530372378075d-14, 6.3017082870211d-14, 2.3234181294087d-11,
     |   1.2549901263399d-09, 2.3988985977070d-08, 2.4557743846679d-07,
     |   1.6511307561300d-06, 8.1846008988297d-06, 3.2136382285782d-05,
     |   1.0480848776028d-04, 2.9341693658421d-04, 7.2195245146823d-04,
     |   1.5885047893817d-03, 3.1660933234843d-03, 5.7715139433495d-03,
     |   9.6906374078782d-03, 1.5060980737446d-02, 2.1731813923349d-02,
     |   2.9142891421824d-02, 3.6276211843265d-02, 4.1731903631781d-02,
     |   4.3954256131247d-02, 4.1589496295698d-02, 3.3904433512353d-02,
     |   2.1152407337925d-02, 4.7588270191068d-03,-1.2774697144531d-02,
     |  -2.8281433596429d-02,-3.8597368272057d-02,-4.1337383314368d-02,
     |  -3.5574699307776d-02,-2.2219022087584d-02,-3.9536935983068d-03,
     |   1.5292652800598d-02, 3.1231241337977d-02, 4.0236268201510d-02,
     |   4.0236268201511d-02, 3.1231241337977d-02, 1.5292652800598d-02,
     |  -3.9536935983067d-03,-2.2219022087584d-02,-3.5574699307776d-02,
     |  -4.1337383314368d-02,-3.8597368272057d-02,-2.8281433596429d-02,
     |  -1.2774697144531d-02, 4.7588270191067d-03, 2.1152407337924d-02,
     |   3.3904433512353d-02, 4.1589496295698d-02, 4.3954256131247d-02,
     |   4.1731903631781d-02, 3.6276211843265d-02, 2.9142891421824d-02,
     |   2.1731813923349d-02, 1.5060980737446d-02, 9.6906374078782d-03,
     |   5.7715139433495d-03, 3.1660933234843d-03, 1.5885047893817d-03,
     |   7.2195245146822d-04, 2.9341693658421d-04, 1.0480848776036d-04,
     |   3.2136382285861d-05, 8.1846008988812d-06, 1.6511307561461d-06,
     |   2.4557743845049d-07, 2.3988986022149d-08, 1.2549901328759d-09,
     |   2.3234221926614d-11, 6.2931727133425d-14,-1.2563269734525d-14/
      data (zmn(lat,12,15), lat = 1,72)/
     |  -2.3583721139645d-16, 1.6882968177113d-15, 1.1035345965049d-12,
     |   8.3909412462245d-11, 2.0773085328042d-09, 2.6233246285261d-08,
     |   2.1081952338104d-07, 1.2221724265508d-06, 5.5252870516340d-06,
     |   2.0512216964618d-05, 6.4820079828716d-05, 1.7893627685560d-04,
     |   4.3986475549872d-04, 9.7696346037455d-04, 1.9824736316232d-03,
     |   3.7070458635889d-03, 6.4297223344356d-03, 1.0395357350001d-02,
     |   1.5721299848652d-02, 2.2288232528947d-02, 2.9643830744225d-02,
     |   3.6956999169208d-02, 4.3059323396237d-02, 4.6595625620517d-02,
     |   4.6277950662335d-02, 4.1202885815775d-02, 3.1160996473884d-02,
     |   1.6850873483588d-02,-8.2239691383033d-05,-1.7229514567288d-02,
     |  -3.1815479660328d-02,-4.1240317889026d-02,-4.3649622516318d-02,
     |  -3.8392227195685d-02,-2.6242642107930d-02,-9.3165844876475d-03,
     |   9.3165844876475d-03, 2.6242642107930d-02, 3.8392227195685d-02,
     |   4.3649622516318d-02, 4.1240317889026d-02, 3.1815479660328d-02,
     |   1.7229514567288d-02, 8.2239691383145d-05,-1.6850873483588d-02,
     |  -3.1160996473884d-02,-4.1202885815775d-02,-4.6277950662335d-02,
     |  -4.6595625620517d-02,-4.3059323396237d-02,-3.6956999169208d-02,
     |  -2.9643830744226d-02,-2.2288232528947d-02,-1.5721299848652d-02,
     |  -1.0395357350001d-02,-6.4297223344356d-03,-3.7070458635890d-03,
     |  -1.9824736316232d-03,-9.7696346037449d-04,-4.3986475549874d-04,
     |  -1.7893627685560d-04,-6.4820079828674d-05,-2.0512216964627d-05,
     |  -5.5252870516140d-06,-1.2221724265302d-06,-2.1081952340671d-07,
     |  -2.6233246358278d-08,-2.0773085106451d-09,-8.3909440407015d-11,
     |  -1.1036202529870d-12,-1.6589918889592d-15, 2.2676495101765d-16/
      data (zmn(lat,13,15), lat = 1,72)/
     |   4.2826991648732d-17,-5.6932714577268d-17, 4.2643197891569d-14,
     |   4.5610430482285d-12, 1.4611746511544d-10, 2.2736871522726d-09,
     |   2.1808942882011d-08, 1.4760533489882d-07, 7.6670513430903d-07,
     |   3.2317704220251d-06, 1.1492729629024d-05, 3.5464376737086d-05,
     |   9.6972360881434d-05, 2.3874046300837d-04, 5.3580530588385d-04,
     |   1.1069259558573d-03, 2.1213324142042d-03, 3.7943215928496d-03,
     |   6.3648791306238d-03, 1.0050753324130d-02, 1.4981736564681d-02,
     |   2.1119760391231d-02, 2.8182944994364d-02, 3.5597105924378d-02,
     |   4.2499309996911d-02, 4.7811667540739d-02, 5.0389407203939d-02,
     |   4.9227772861224d-02, 4.3692199021500d-02, 3.3721646602057d-02,
     |   1.9951482738014d-02, 3.7129587004430d-03,-1.3109622866511d-02,
     |  -2.8350551315464d-02,-3.9917004358468d-02,-4.6155974224080d-02,
     |  -4.6155974224080d-02,-3.9917004358468d-02,-2.8350551315464d-02,
     |  -1.3109622866511d-02, 3.7129587004429d-03, 1.9951482738014d-02,
     |   3.3721646602057d-02, 4.3692199021500d-02, 4.9227772861224d-02,
     |   5.0389407203939d-02, 4.7811667540739d-02, 4.2499309996911d-02,
     |   3.5597105924378d-02, 2.8182944994364d-02, 2.1119760391232d-02,
     |   1.4981736564681d-02, 1.0050753324130d-02, 6.3648791306238d-03,
     |   3.7943215928495d-03, 2.1213324142042d-03, 1.1069259558573d-03,
     |   5.3580530588386d-04, 2.3874046300838d-04, 9.6972360881417d-05,
     |   3.5464376737095d-05, 1.1492729629075d-05, 3.2317704219755d-06,
     |   7.6670513428324d-07, 1.4760533491705d-07, 2.1808942927866d-08,
     |   2.2736871864046d-09, 1.4611747429985d-10, 4.5610455829951d-12,
     |   4.2618474424774d-14, 4.9547950315602d-18, 8.1568733373230d-17/
      data (zmn(lat,14,15), lat = 1,72)/
     |  -1.3332430235829d-16,-1.3062389675924d-16, 1.1490161629896d-15,
     |   1.9099812808870d-13, 7.9164261148868d-12, 1.5165173086519d-10,
     |   1.7342401799042d-09, 1.3684540894485d-08, 8.1536204175150d-08,
     |   3.8946904724001d-07, 1.5550439972416d-06, 5.3494932068894d-06,
     |   1.6218452182614d-05, 4.4091538613749d-05, 1.0894902945238d-04,
     |   2.4732794708230d-04, 5.2029358496049d-04, 1.0213772392515d-03,
     |   1.8817667856952d-03, 3.2690182504630d-03, 5.3752637014552d-03,
     |   8.3918442892414d-03, 1.2469787082326d-02, 1.7669413579605d-02,
     |   2.3906895674454d-02, 3.0909540587639d-02, 3.8193543978584d-02,
     |   4.5076667809873d-02, 5.0733236509515d-02, 5.4290504524628d-02,
     |   5.4955445459107d-02, 5.2151782863315d-02, 4.5641267278925d-02,
     |   3.5602876009188d-02, 2.2649574695857d-02, 7.7736831173358d-03,
     |  -7.7736831173358d-03,-2.2649574695857d-02,-3.5602876009188d-02,
     |  -4.5641267278925d-02,-5.2151782863315d-02,-5.4955445459107d-02,
     |  -5.4290504524628d-02,-5.0733236509515d-02,-4.5076667809873d-02,
     |  -3.8193543978584d-02,-3.0909540587639d-02,-2.3906895674454d-02,
     |  -1.7669413579605d-02,-1.2469787082326d-02,-8.3918442892414d-03,
     |  -5.3752637014552d-03,-3.2690182504630d-03,-1.8817667856952d-03,
     |  -1.0213772392515d-03,-5.2029358496047d-04,-2.4732794708232d-04,
     |  -1.0894902945240d-04,-4.4091538613783d-05,-1.6218452182575d-05,
     |  -5.3494932068626d-06,-1.5550439972025d-06,-3.8946904722996d-07,
     |  -8.1536204202707d-08,-1.3684540882726d-08,-1.7342401680444d-09,
     |  -1.5165168706582d-10,-7.9164577853464d-12,-1.9097828022855d-13,
     |  -1.1381022585495d-15, 9.6758624387880d-17, 1.1420418748654d-16/
      data (zmn(lat,15,15), lat = 1,72)/
     |  -6.1176816431886d-18,-2.2455974819498d-17,-1.4902680239281d-17,
     |   5.3148128552858d-15, 2.8743943477633d-13, 6.7750794577186d-12,
     |   9.2288441798273d-11, 8.4810736787321d-10, 5.7890066740256d-09,
     |   3.1287826225660d-08, 1.4000935760951d-07, 5.3582464913527d-07,
     |   1.7968218114271d-06, 5.3788225098250d-06, 1.4584890179510d-05,
     |   3.6241279641127d-05, 8.3305903984397d-05, 1.7851300507245d-04,
     |   3.5888958784963d-04, 6.8056369896336d-04, 1.2227796125206d-03,
     |   2.0895673064673d-03, 3.4072643076132d-03, 5.3162485266459d-03,
     |   7.9559470437479d-03, 1.1443448340866d-02, 1.5847700694599d-02,
     |   2.1162987973989d-02, 2.7286678863646d-02, 3.4006684644638d-02,
     |   4.1003308314913d-02, 4.7868161349379d-02, 5.4139832477043d-02,
     |   5.9352592978797d-02, 6.3091382145359d-02, 6.5044400421683d-02,
     |   6.5044400421683d-02, 6.3091382145359d-02, 5.9352592978797d-02,
     |   5.4139832477043d-02, 4.7868161349379d-02, 4.1003308314913d-02,
     |   3.4006684644638d-02, 2.7286678863646d-02, 2.1162987973989d-02,
     |   1.5847700694599d-02, 1.1443448340866d-02, 7.9559470437479d-03,
     |   5.3162485266459d-03, 3.4072643076132d-03, 2.0895673064673d-03,
     |   1.2227796125206d-03, 6.8056369896337d-04, 3.5888958784964d-04,
     |   1.7851300507248d-04, 8.3305903984399d-05, 3.6241279641163d-05,
     |   1.4584890179515d-05, 5.3788225098314d-06, 1.7968218114310d-06,
     |   5.3582464913850d-07, 1.4000935759613d-07, 3.1287826236525d-08,
     |   5.7890066704801d-09, 8.4810737051332d-10, 9.2288429744639d-11,
     |   6.7750738465224d-12, 2.8741150768685d-13, 5.3225701959637d-15,
     |  -2.5924114545864d-17,-4.6341014328721d-17,-3.2439820532227d-17/
      data (zmn(lat, 0,16), lat = 1,72)/
     |   3.2331547818952d-03, 8.7467251364740d-03, 6.3685755306134d-03,
     |  -1.4314649567859d-03,-1.1575476777036d-02,-1.6815358678060d-02,
     |  -1.3798903986024d-02,-2.2914689451965d-03, 1.1798614792731d-02,
     |   2.1452069958882d-02, 2.0511907293466d-02, 8.8479583991371d-03,
     |  -8.5727135903807d-03,-2.2694191016831d-02,-2.6147900369073d-02,
     |  -1.6214294928336d-02, 2.5006733346393d-03, 2.0987977873615d-02,
     |   2.9530302115234d-02, 2.3472336876996d-02, 5.1710960493397d-03,
     |  -1.6339227393419d-02,-3.0337260908457d-02,-2.9357627213821d-02,
     |  -1.3585237629004d-02, 9.4620618640605d-03, 2.8208071658665d-02,
     |   3.3177357719574d-02, 2.1545528060649d-02,-1.0338587160400d-03,
     |  -2.3409007749461d-02,-3.4294189341747d-02,-2.8153980899436d-02,
     |  -7.9055392417297d-03, 1.6373248553204d-02, 3.2570042142755d-02,
     |   3.2570042142755d-02, 1.6373248553204d-02,-7.9055392417296d-03,
     |  -2.8153980899436d-02,-3.4294189341747d-02,-2.3409007749461d-02,
     |  -1.0338587160400d-03, 2.1545528060649d-02, 3.3177357719574d-02,
     |   2.8208071658665d-02, 9.4620618640605d-03,-1.3585237629004d-02,
     |  -2.9357627213821d-02,-3.0337260908457d-02,-1.6339227393419d-02,
     |   5.1710960493394d-03, 2.3472336876996d-02, 2.9530302115234d-02,
     |   2.0987977873615d-02, 2.5006733346393d-03,-1.6214294928336d-02,
     |  -2.6147900369073d-02,-2.2694191016831d-02,-8.5727135903808d-03,
     |   8.8479583991371d-03, 2.0511907293466d-02, 2.1452069958882d-02,
     |   1.1798614792731d-02,-2.2914689451964d-03,-1.3798903986024d-02,
     |  -1.6815358678060d-02,-1.1575476777036d-02,-1.4314649567859d-03,
     |   6.3685755306134d-03, 8.7467251364740d-03, 3.2331547818952d-03/
      data (zmn(lat, 1,16), lat = 1,72)/
     |   7.8670685655812d-04, 5.3521148106923d-03, 1.1252344734948d-02,
     |   1.3288501148676d-02, 8.5405678403993d-03,-2.1207406047173d-03,
     |  -1.3686791188019d-02,-1.9863241118923d-02,-1.6379376009228d-02,
     |  -3.9327209380404d-03, 1.1884264395512d-02, 2.2989222387726d-02,
     |   2.3187743646163d-02, 1.1469953742140d-02,-6.8882648198490d-03,
     |  -2.2878215452419d-02,-2.8090426183088d-02,-1.9318254090934d-02,
     |  -3.2077160516292d-04, 1.9628616129772d-02, 3.0460496697582d-02,
     |   2.6293226942573d-02, 8.7681417256022d-03,-1.3705958825512d-02,
     |  -2.9878416755575d-02,-3.1474123271728d-02,-1.7313820793081d-02,
     |   5.7662505321551d-03, 2.6378676134417d-02, 3.4105175976636d-02,
     |   2.4936121961090d-02, 3.2211443073014d-03,-2.0266994932524d-02,
     |  -3.3852626184730d-02,-3.0661690986724d-02,-1.2259814771646d-02,
     |   1.2259814771646d-02, 3.0661690986724d-02, 3.3852626184730d-02,
     |   2.0266994932524d-02,-3.2211443073013d-03,-2.4936121961090d-02,
     |  -3.4105175976636d-02,-2.6378676134417d-02,-5.7662505321552d-03,
     |   1.7313820793081d-02, 3.1474123271728d-02, 2.9878416755575d-02,
     |   1.3705958825513d-02,-8.7681417256022d-03,-2.6293226942573d-02,
     |  -3.0460496697583d-02,-1.9628616129772d-02, 3.2077160516282d-04,
     |   1.9318254090934d-02, 2.8090426183088d-02, 2.2878215452419d-02,
     |   6.8882648198490d-03,-1.1469953742140d-02,-2.3187743646163d-02,
     |  -2.2989222387726d-02,-1.1884264395512d-02, 3.9327209380403d-03,
     |   1.6379376009228d-02, 1.9863241118923d-02, 1.3686791188019d-02,
     |   2.1207406047174d-03,-8.5405678403992d-03,-1.3288501148676d-02,
     |  -1.1252344734948d-02,-5.3521148106923d-03,-7.8670685655813d-04/
      data (zmn(lat, 2,16), lat = 1,72)/
     |   7.0161261794408d-05, 1.5172241634195d-03, 5.8997286738644d-03,
     |   1.2097467788816d-02, 1.6726596337267d-02, 1.5918330690032d-02,
     |   8.0541269757103d-03,-4.7533259186585d-03,-1.7029067313017d-02,
     |  -2.2566032665037d-02,-1.7701993859317d-02,-3.7376169126329d-03,
     |   1.3216861434434d-02, 2.4902511100904d-02, 2.5069180155857d-02,
     |   1.2833813036492d-02,-6.4353064561272d-03,-2.3497352514847d-02,
     |  -2.9699262882364d-02,-2.1443375033028d-02,-2.2333955428371d-03,
     |   1.8763364479966d-02, 3.1146864524432d-02, 2.8468056856042d-02,
     |   1.1627460558477d-02,-1.1374689536528d-02,-2.9249921804492d-02,
     |  -3.3017971468946d-02,-2.0543238315562d-02, 2.2544555854074d-03,
     |   2.4232509203756d-02, 3.4503614758839d-02, 2.7874778603497d-02,
     |   7.4860710732113d-03,-1.6679922718419d-02,-3.2722498729383d-02,
     |  -3.2722498729383d-02,-1.6679922718419d-02, 7.4860710732112d-03,
     |   2.7874778603497d-02, 3.4503614758839d-02, 2.4232509203756d-02,
     |   2.2544555854074d-03,-2.0543238315562d-02,-3.3017971468946d-02,
     |  -2.9249921804492d-02,-1.1374689536529d-02, 1.1627460558477d-02,
     |   2.8468056856042d-02, 3.1146864524432d-02, 1.8763364479966d-02,
     |  -2.2333955428368d-03,-2.1443375033028d-02,-2.9699262882364d-02,
     |  -2.3497352514847d-02,-6.4353064561273d-03, 1.2833813036492d-02,
     |   2.5069180155857d-02, 2.4902511100904d-02, 1.3216861434434d-02,
     |  -3.7376169126329d-03,-1.7701993859317d-02,-2.2566032665037d-02,
     |  -1.7029067313017d-02,-4.7533259186586d-03, 8.0541269757104d-03,
     |   1.5918330690032d-02, 1.6726596337267d-02, 1.2097467788816d-02,
     |   5.8997286738643d-03, 1.5172241634195d-03, 7.0161261794395d-05/
      data (zmn(lat, 3,16), lat = 1,72)/
     |   1.5401332805266d-06, 2.7953012892152d-04, 1.8808363125860d-03,
     |   5.8831599499761d-03, 1.2024613712976d-02, 1.8085677030656d-02,
     |   2.0571867830679d-02, 1.6572219420090d-02, 5.7678119987189d-03,
     |  -8.6213457362171d-03,-2.0771475287941d-02,-2.4837834754667d-02,
     |  -1.8014058457253d-02,-2.4209105759166d-03, 1.5330701982537d-02,
     |   2.6965842875013d-02, 2.6506676494304d-02, 1.3437465889919d-02,
     |  -6.6441231954032d-03,-2.4393298988338d-02,-3.1122753062938d-02,
     |  -2.3121520307218d-02,-3.7241066359580d-03, 1.8039846799068d-02,
     |   3.1672258859749d-02, 3.0328622470408d-02, 1.4292539372298d-02,
     |  -8.9640581040154d-03,-2.8281026679878d-02,-3.4205021734235d-02,
     |  -2.3663095891137d-02,-1.5675686084158d-03, 2.1476573595132d-02,
     |   3.4301748707628d-02, 3.0628775176799d-02, 1.2171001795893d-02,
     |  -1.2171001795893d-02,-3.0628775176799d-02,-3.4301748707628d-02,
     |  -2.1476573595132d-02, 1.5675686084157d-03, 2.3663095891137d-02,
     |   3.4205021734235d-02, 2.8281026679878d-02, 8.9640581040154d-03,
     |  -1.4292539372297d-02,-3.0328622470408d-02,-3.1672258859749d-02,
     |  -1.8039846799068d-02, 3.7241066359581d-03, 2.3121520307218d-02,
     |   3.1122753062938d-02, 2.4393298988338d-02, 6.6441231954033d-03,
     |  -1.3437465889919d-02,-2.6506676494304d-02,-2.6965842875013d-02,
     |  -1.5330701982537d-02, 2.4209105759167d-03, 1.8014058457253d-02,
     |   2.4837834754667d-02, 2.0771475287941d-02, 8.6213457362171d-03,
     |  -5.7678119987189d-03,-1.6572219420090d-02,-2.0571867830679d-02,
     |  -1.8085677030656d-02,-1.2024613712976d-02,-5.8831599499760d-03,
     |  -1.8808363125860d-03,-2.7953012892148d-04,-1.5401332805104d-06/
      data (zmn(lat, 4,16), lat = 1,72)/
     |   7.5918921856776d-08, 3.7414385332719d-05, 4.3194807869884d-04,
     |   1.9805206709258d-03, 5.5807918846961d-03, 1.1397295620373d-02,
     |   1.8119521322886d-02, 2.2971176598999d-02, 2.2745962154385d-02,
     |   1.5531881141548d-02, 2.2338915365412d-03,-1.3067704059852d-02,
     |  -2.4413261993521d-02,-2.6537860046290d-02,-1.7575339408838d-02,
     |  -4.8003443509355d-04, 1.7757126843888d-02, 2.8989120610216d-02,
     |   2.7674209194881d-02, 1.3728347513995d-02,-7.0348580466747d-03,
     |  -2.5287777861192d-02,-3.2429481153234d-02,-2.4721885747790d-02,
     |  -5.2946410812586d-03, 1.7070052840807d-02, 3.1926040013142d-02,
     |   3.2099265383177d-02, 1.7207012247802d-02,-5.9904297791324d-03,
     |  -2.6664884661011d-02,-3.5015682385329d-02,-2.6964412735962d-02,
     |  -6.1741969857383d-03, 1.7618354822542d-02, 3.3196711740817d-02,
     |   3.3196711740817d-02, 1.7618354822542d-02,-6.1741969857382d-03,
     |  -2.6964412735962d-02,-3.5015682385329d-02,-2.6664884661011d-02,
     |  -5.9904297791325d-03, 1.7207012247802d-02, 3.2099265383177d-02,
     |   3.1926040013142d-02, 1.7070052840807d-02,-5.2946410812584d-03,
     |  -2.4721885747790d-02,-3.2429481153234d-02,-2.5287777861192d-02,
     |  -7.0348580466750d-03, 1.3728347513995d-02, 2.7674209194881d-02,
     |   2.8989120610216d-02, 1.7757126843888d-02,-4.8003443509345d-04,
     |  -1.7575339408838d-02,-2.6537860046290d-02,-2.4413261993521d-02,
     |  -1.3067704059852d-02, 2.2338915365412d-03, 1.5531881141548d-02,
     |   2.2745962154385d-02, 2.2971176598999d-02, 1.8119521322886d-02,
     |   1.1397295620373d-02, 5.5807918846962d-03, 1.9805206709258d-03,
     |   4.3194807869885d-04, 3.7414385332713d-05, 7.5918921816270d-08/
      data (zmn(lat, 5,16), lat = 1,72)/
     |   3.6836162489934d-08, 3.8926342000858d-06, 7.7024616778703d-05,
     |   5.0902412177166d-04, 1.9250232986962d-03, 5.1021965454487d-03,
     |   1.0432340655249d-02, 1.7269867018376d-02, 2.3617964758629d-02,
     |   2.6546241468742d-02, 2.3381299994075d-02, 1.3225369588249d-02,
     |  -1.9773171163211d-03,-1.7556152957977d-02,-2.7651910164364d-02,
     |  -2.7691795124472d-02,-1.6720187741689d-02, 1.6119701310385d-03,
     |   2.0099469522842d-02, 3.0844927521335d-02, 2.8767401044989d-02,
     |   1.4141641639089d-02,-7.1373861800869d-03,-2.5883904254522d-02,
     |  -3.3635068606590d-02,-2.6563833213527d-02,-7.4383621164880d-03,
     |   1.5396085639519d-02, 3.1669856479896d-02, 3.3863941797767d-02,
     |   2.0747395584306d-02,-1.9176479867433d-03,-2.3906474665019d-02,
     |  -3.5182579754853d-02,-3.0529351589751d-02,-1.1997490202127d-02,
     |   1.1997490202127d-02, 3.0529351589751d-02, 3.5182579754853d-02,
     |   2.3906474665019d-02, 1.9176479867433d-03,-2.0747395584306d-02,
     |  -3.3863941797767d-02,-3.1669856479896d-02,-1.5396085639519d-02,
     |   7.4383621164879d-03, 2.6563833213527d-02, 3.3635068606590d-02,
     |   2.5883904254522d-02, 7.1373861800869d-03,-1.4141641639089d-02,
     |  -2.8767401044988d-02,-3.0844927521335d-02,-2.0099469522842d-02,
     |  -1.6119701310385d-03, 1.6720187741689d-02, 2.7691795124472d-02,
     |   2.7651910164364d-02, 1.7556152957977d-02, 1.9773171163213d-03,
     |  -1.3225369588249d-02,-2.3381299994075d-02,-2.6546241468742d-02,
     |  -2.3617964758629d-02,-1.7269867018376d-02,-1.0432340655249d-02,
     |  -5.1021965454487d-03,-1.9250232986962d-03,-5.0902412177162d-04,
     |  -7.7024616778675d-05,-3.8926342000426d-06,-3.6836162472145d-08/
      data (zmn(lat, 6,16), lat = 1,72)/
     |   9.4866753073220d-10, 3.3299856447704d-07, 1.1119829475303d-05,
     |   1.0505405750690d-04, 5.2604976269193d-04, 1.7731988549976d-03,
     |   4.5176240396372d-03, 9.2630191164420d-03, 1.5829750241516d-02,
     |   2.2932696693448d-02, 2.8198341040976d-02, 2.8831356487423d-02,
     |   2.2817871632045d-02, 1.0190667536956d-02,-6.3077185260776d-03,
     |  -2.1689657138181d-02,-3.0376229948725d-02,-2.8499540682998d-02,
     |  -1.5871604177470d-02, 3.3794750205936d-03, 2.2020426131609d-02,
     |   3.2470477465975d-02, 3.0027053904195d-02, 1.5130837420114d-02,
     |  -6.4590136195026d-03,-2.5840050466495d-02,-3.4682938386465d-02,
     |  -2.8907026961430d-02,-1.0648275421959d-02, 1.2457910985854d-02,
     |   3.0473756150478d-02, 3.5486626575234d-02, 2.5150576206140d-02,
     |   3.8235953624348d-03,-1.9264978257039d-02,-3.4043933415870d-02,
     |  -3.4043933415870d-02,-1.9264978257039d-02, 3.8235953624347d-03,
     |   2.5150576206140d-02, 3.5486626575234d-02, 3.0473756150478d-02,
     |   1.2457910985855d-02,-1.0648275421959d-02,-2.8907026961430d-02,
     |  -3.4682938386465d-02,-2.5840050466495d-02,-6.4590136195028d-03,
     |   1.5130837420114d-02, 3.0027053904196d-02, 3.2470477465975d-02,
     |   2.2020426131609d-02, 3.3794750205937d-03,-1.5871604177470d-02,
     |  -2.8499540682998d-02,-3.0376229948725d-02,-2.1689657138181d-02,
     |  -6.3077185260775d-03, 1.0190667536956d-02, 2.2817871632045d-02,
     |   2.8831356487423d-02, 2.8198341040975d-02, 2.2932696693448d-02,
     |   1.5829750241516d-02, 9.2630191164420d-03, 4.5176240396371d-03,
     |   1.7731988549976d-03, 5.2604976269193d-04, 1.0505405750694d-04,
     |   1.1119829475367d-05, 3.3299856443934d-07, 9.4866753316568d-10/
      data (zmn(lat, 7,16), lat = 1,72)/
     |  -3.8666723376504d-10, 2.4152352146893d-08, 1.3343799171244d-06,
     |   1.7932750373715d-05, 1.1798161523630d-04, 5.0020542425948d-04,
     |   1.5628703543374d-03, 3.8771285191260d-03, 7.9827475795774d-03,
     |   1.4009168951878d-02, 2.1261019641968d-02, 2.8016612638226d-02,
     |   3.1781620881856d-02, 3.0076093483842d-02, 2.1557198640962d-02,
     |   7.0214892402567d-03,-1.0256287214870d-02,-2.5209995970671d-02,
     |  -3.2639293097972d-02,-2.9294287586959d-02,-1.5524227374718d-02,
     |   4.3326379922495d-03, 2.3196540117310d-02, 3.3815563878074d-02,
     |   3.1697506214034d-02, 1.7165083965168d-02,-4.4453119517885d-03,
     |  -2.4687393875652d-02,-3.5345597714102d-02,-3.1862949183874d-02,
     |  -1.5381441935198d-02, 7.5523001743442d-03, 2.7585184755435d-02,
     |   3.6420054379220d-02, 3.0316532426637d-02, 1.1718707999740d-02,
     |  -1.1718707999740d-02,-3.0316532426637d-02,-3.6420054379220d-02,
     |  -2.7585184755435d-02,-7.5523001743443d-03, 1.5381441935198d-02,
     |   3.1862949183874d-02, 3.5345597714102d-02, 2.4687393875652d-02,
     |   4.4453119517886d-03,-1.7165083965168d-02,-3.1697506214034d-02,
     |  -3.3815563878074d-02,-2.3196540117310d-02,-4.3326379922495d-03,
     |   1.5524227374718d-02, 2.9294287586959d-02, 3.2639293097972d-02,
     |   2.5209995970671d-02, 1.0256287214870d-02,-7.0214892402565d-03,
     |  -2.1557198640962d-02,-3.0076093483842d-02,-3.1781620881856d-02,
     |  -2.8016612638226d-02,-2.1261019641968d-02,-1.4009168951878d-02,
     |  -7.9827475795774d-03,-3.8771285191260d-03,-1.5628703543374d-03,
     |  -5.0020542425952d-04,-1.1798161523625d-04,-1.7932750373725d-05,
     |  -1.3343799171450d-06,-2.4152352221703d-08, 3.8666720298614d-10/
      data (zmn(lat, 8,16), lat = 1,72)/
     |  -6.7365247416444d-12, 1.4554045616097d-09, 1.3537625875910d-07,
     |   2.5782538246457d-06, 2.2178768593339d-05, 1.1747183768499d-04,
     |   4.4596857479788d-04, 1.3215320393795d-03, 3.2194722001177d-03,
     |   6.6642477069144d-03, 1.1970803120788d-02, 1.8894846755499d-02,
     |   2.6345127413252d-02, 3.2361817065063d-02, 3.4515054050608d-02,
     |   3.0715257540385d-02, 2.0204723980754d-02, 4.3227406623482d-03,
     |  -1.3385764697120d-02,-2.7959421108077d-02,-3.4591519193795d-02,
     |  -3.0480067356679d-02,-1.6220436669262d-02, 3.9332352172048d-03,
     |   2.3230257053761d-02, 3.4727785247208d-02, 3.3926047293338d-02,
     |   2.0683976772327d-02,-4.4130939951077d-04,-2.1702099100447d-02,
     |  -3.5031159929338d-02,-3.5187593556700d-02,-2.1908416454476d-02,
     |  -1.4606240605568d-04, 2.1772328274360d-02, 3.5373466283311d-02,
     |   3.5373466283311d-02, 2.1772328274360d-02,-1.4606240605565d-04,
     |  -2.1908416454476d-02,-3.5187593556700d-02,-3.5031159929338d-02,
     |  -2.1702099100447d-02,-4.4130939951097d-04, 2.0683976772327d-02,
     |   3.3926047293338d-02, 3.4727785247208d-02, 2.3230257053761d-02,
     |   3.9332352172049d-03,-1.6220436669262d-02,-3.0480067356679d-02,
     |  -3.4591519193795d-02,-2.7959421108077d-02,-1.3385764697120d-02,
     |   4.3227406623482d-03, 2.0204723980754d-02, 3.0715257540385d-02,
     |   3.4515054050608d-02, 3.2361817065063d-02, 2.6345127413252d-02,
     |   1.8894846755499d-02, 1.1970803120788d-02, 6.6642477069144d-03,
     |   3.2194722001177d-03, 1.3215320393795d-03, 4.4596857479792d-04,
     |   1.1747183768500d-04, 2.2178768593336d-05, 2.5782538246388d-06,
     |   1.3537625868845d-07, 1.4554046094166d-09,-6.7365410764058d-12/
      data (zmn(lat, 9,16), lat = 1,72)/
     |   4.1823022019318d-12, 7.0805680750754d-11, 1.1724194846596d-08,
     |   3.1558887486129d-07, 3.5379356349208d-06, 2.3306011858885d-05,
     |   1.0687012073066d-04, 3.7531863408498d-04, 1.0705450915810d-03,
     |   2.5765972049449d-03, 5.3682345217016d-03, 9.8495515460400d-03,
     |   1.6090518443315d-02, 2.3539557613481d-02, 3.0853662833543d-02,
     |   3.6001089420607d-02, 3.6724380891807d-02, 3.1307807578921d-02,
     |   1.9422269480502d-02, 2.7025815483846d-03,-1.5276579219578d-02,
     |  -2.9787514774774d-02,-3.6368517836544d-02,-3.2441870251376d-02,
     |  -1.8522196272621d-02, 1.5372072391346d-03, 2.1508601874207d-02,
     |   3.4756140141690d-02, 3.6562738309866d-02, 2.5956365648222d-02,
     |   6.2866728470770d-03,-1.5767325155526d-02,-3.2482378934322d-02,
     |  -3.7866928611521d-02,-2.9891360301415d-02,-1.1305187939990d-02,
     |   1.1305187939990d-02, 2.9891360301415d-02, 3.7866928611521d-02,
     |   3.2482378934322d-02, 1.5767325155526d-02,-6.2866728470771d-03,
     |  -2.5956365648222d-02,-3.6562738309866d-02,-3.4756140141690d-02,
     |  -2.1508601874207d-02,-1.5372072391346d-03, 1.8522196272621d-02,
     |   3.2441870251376d-02, 3.6368517836544d-02, 2.9787514774774d-02,
     |   1.5276579219578d-02,-2.7025815483845d-03,-1.9422269480502d-02,
     |  -3.1307807578921d-02,-3.6724380891807d-02,-3.6001089420607d-02,
     |  -3.0853662833543d-02,-2.3539557613481d-02,-1.6090518443315d-02,
     |  -9.8495515460400d-03,-5.3682345217015d-03,-2.5765972049449d-03,
     |  -1.0705450915810d-03,-3.7531863408502d-04,-1.0687012073064d-04,
     |  -2.3306011858872d-05,-3.5379356349270d-06,-3.1558887487351d-07,
     |  -1.1724194853656d-08,-7.0805630360263d-11,-4.1823105559146d-12/
      data (zmn(lat,10,16), lat = 1,72)/
     |   5.2020896172143d-14, 3.1639270617300d-12, 8.6991703123080d-10,
     |   3.3055009352088d-08, 4.8179140716244d-07, 3.9350126285041d-06,
     |   2.1706566685408d-05, 8.9874230690696d-05, 2.9813238454821d-04,
     |   8.2701422356659d-04, 1.9754241019283d-03, 4.1470695133443d-03,
     |   7.7622147594075d-03, 1.3080431642299d-02, 1.9962361760185d-02,
     |   2.7651294837024d-02, 3.4692869950751d-02, 3.9104558754540d-02,
     |   3.8839485584511d-02, 3.2471740749276d-02, 1.9902873015139d-02,
     |   2.8103189846228d-03,-1.5419496867745d-02,-3.0389452489484d-02,
     |  -3.7910061675958d-02,-3.5393161097572d-02,-2.2936815474602d-02,
     |  -3.6490946360965d-03, 1.7022482759532d-02, 3.2844361440073d-02,
     |   3.8775160762294d-02, 3.2701995036847d-02, 1.6295662300406d-02,
     |  -5.3801522797365d-03,-2.5437639448578d-02,-3.7410600918128d-02,
     |  -3.7410600918128d-02,-2.5437639448578d-02,-5.3801522797366d-03,
     |   1.6295662300405d-02, 3.2701995036847d-02, 3.8775160762294d-02,
     |   3.2844361440073d-02, 1.7022482759533d-02,-3.6490946360965d-03,
     |  -2.2936815474602d-02,-3.5393161097572d-02,-3.7910061675958d-02,
     |  -3.0389452489484d-02,-1.5419496867745d-02, 2.8103189846227d-03,
     |   1.9902873015139d-02, 3.2471740749276d-02, 3.8839485584511d-02,
     |   3.9104558754540d-02, 3.4692869950751d-02, 2.7651294837024d-02,
     |   1.9962361760185d-02, 1.3080431642299d-02, 7.7622147594075d-03,
     |   4.1470695133443d-03, 1.9754241019284d-03, 8.2701422356662d-04,
     |   2.9813238454818d-04, 8.9874230690717d-05, 2.1706566685406d-05,
     |   3.9350126285177d-06, 4.8179140725889d-07, 3.3055009312199d-08,
     |   8.6991710020540d-10, 3.1638688638241d-12, 5.2005072910054d-14/
      data (zmn(lat,11,16), lat = 1,72)/
     |  -3.6514715796809d-14, 1.5724801381455d-13, 5.5257445574302d-11,
     |   2.9621461544087d-09, 5.6036360491323d-08, 5.6616378821817d-07,
     |   3.7461249724217d-06, 1.8219291023969d-05, 6.9962734248628d-05,
     |   2.2238187881603d-04, 6.0448462147168d-04, 1.4381354653060d-03,
     |   3.0454082651087d-03, 5.8107673033746d-03, 1.0077517382975d-02,
     |   1.5978628418281d-02, 2.3236608498082d-02, 3.1004093382769d-02,
     |   3.7837569535098d-02, 4.1882659714587d-02, 4.1292459705813d-02,
     |   3.4810691409421d-02, 2.2358603395203d-02, 5.4093125376109d-03,
     |  -1.3048897607531d-02,-2.9055612363906d-02,-3.8656405023209d-02,
     |  -3.9068990905462d-02,-2.9674224898575d-02,-1.2469069926530d-02,
     |   8.2458531303264d-03, 2.6933655714017d-02, 3.8370292781127d-02,
     |   3.9210512425012d-02, 2.9062959055947d-02, 1.0700040322227d-02,
     |  -1.0700040322227d-02,-2.9062959055947d-02,-3.9210512425012d-02,
     |  -3.8370292781127d-02,-2.6933655714017d-02,-8.2458531303263d-03,
     |   1.2469069926530d-02, 2.9674224898575d-02, 3.9068990905462d-02,
     |   3.8656405023209d-02, 2.9055612363907d-02, 1.3048897607531d-02,
     |  -5.4093125376109d-03,-2.2358603395203d-02,-3.4810691409421d-02,
     |  -4.1292459705813d-02,-4.1882659714587d-02,-3.7837569535098d-02,
     |  -3.1004093382770d-02,-2.3236608498082d-02,-1.5978628418282d-02,
     |  -1.0077517382975d-02,-5.8107673033746d-03,-3.0454082651088d-03,
     |  -1.4381354653059d-03,-6.0448462147166d-04,-2.2238187881604d-04,
     |  -6.9962734248687d-05,-1.8219291023981d-05,-3.7461249724971d-06,
     |  -5.6616378826545d-07,-5.6036360542969d-08,-2.9621461614782d-09,
     |  -5.5257414455235d-11,-1.5727129511391d-13, 3.6557862578719d-14/
      data (zmn(lat,12,16), lat = 1,72)/
     |  -4.0760271448729d-16, 4.7895523011776d-15, 2.9904865693616d-12,
     |   2.2576721585577d-10, 5.5361334003270d-09, 6.9075485202721d-08,
     |   5.4704380357287d-07, 3.1167942910441d-06, 1.3808928554539d-05,
     |   5.0088509889782d-05, 1.5415395393221d-04, 4.1299884032698d-04,
     |   9.8156557083509d-04, 2.0989150531635d-03, 4.0811319630159d-03,
     |   7.2728531565650d-03, 1.1946245185037d-02, 1.8153980188160d-02,
     |   2.5568375398422d-02, 3.3363695058052d-02, 4.0210177953074d-02,
     |   4.4435175619632d-02, 4.4364518327708d-02, 3.8793299869822d-02,
     |   2.7469301807939d-02, 1.1430818166902d-02,-6.9526578279144d-03,
     |  -2.4323776087144d-02,-3.7040386063779d-02,-4.2088455931506d-02,
     |  -3.7958986122200d-02,-2.5216430150806d-02,-6.5485387714332d-03,
     |   1.3771927882631d-02, 3.0905246312529d-02, 4.0676909036791d-02,
     |   4.0676909036791d-02, 3.0905246312529d-02, 1.3771927882631d-02,
     |  -6.5485387714331d-03,-2.5216430150806d-02,-3.7958986122200d-02,
     |  -4.2088455931506d-02,-3.7040386063779d-02,-2.4323776087144d-02,
     |  -6.9526578279144d-03, 1.1430818166902d-02, 2.7469301807938d-02,
     |   3.8793299869822d-02, 4.4364518327708d-02, 4.4435175619632d-02,
     |   4.0210177953074d-02, 3.3363695058052d-02, 2.5568375398422d-02,
     |   1.8153980188160d-02, 1.1946245185037d-02, 7.2728531565650d-03,
     |   4.0811319630159d-03, 2.0989150531635d-03, 9.8156557083510d-04,
     |   4.1299884032697d-04, 1.5415395393214d-04, 5.0088509889771d-05,
     |   1.3808928554590d-05, 3.1167942910381d-06, 5.4704380357001d-07,
     |   6.9075485189672d-08, 5.5361333301233d-09, 2.2576725942413d-10,
     |   2.9904576811264d-12, 4.8279761289846d-15,-3.9413824975903d-16/
      data (zmn(lat,13,16), lat = 1,72)/
     |   2.0593376116784d-16,-1.7345955435135d-16, 1.3601672447867d-13,
     |   1.4436509558479d-11, 4.5841614421723d-10, 7.0542682634131d-09,
     |   6.6756160790783d-08, 4.4466225899337d-07, 2.2673572989687d-06,
     |   9.3569352321857d-06, 3.2485597956884d-05, 9.7572801054254d-05,
     |   2.5885219147159d-04, 6.1614036301511d-04, 1.3318336034431d-03,
     |   2.6388433172474d-03, 4.8272158268712d-03, 8.1973445243485d-03,
     |   1.2973912204237d-02, 1.9187703758999d-02, 2.6549878333972d-02,
     |   3.4359542201780d-02, 4.1492843323398d-02, 4.6513395835620d-02,
     |   4.7916902991341d-02, 4.4481459306874d-02, 3.5650434327859d-02,
     |   2.1842836955031d-02, 4.5816388715465d-03,-1.3638205000098d-02,
     |  -2.9756783397665d-02,-4.0766064128940d-02,-4.4399144720244d-02,
     |  -3.9715267897989d-02,-2.7414414868533d-02,-9.7771218454713d-03,
     |   9.7771218454712d-03, 2.7414414868533d-02, 3.9715267897989d-02,
     |   4.4399144720244d-02, 4.0766064128940d-02, 2.9756783397665d-02,
     |   1.3638205000098d-02,-4.5816388715463d-03,-2.1842836955031d-02,
     |  -3.5650434327859d-02,-4.4481459306874d-02,-4.7916902991341d-02,
     |  -4.6513395835620d-02,-4.1492843323398d-02,-3.4359542201780d-02,
     |  -2.6549878333973d-02,-1.9187703758999d-02,-1.2973912204237d-02,
     |  -8.1973445243485d-03,-4.8272158268712d-03,-2.6388433172474d-03,
     |  -1.3318336034431d-03,-6.1614036301510d-04,-2.5885219147154d-04,
     |  -9.7572801054228d-05,-3.2485597956828d-05,-9.3569352321448d-06,
     |  -2.2673572989112d-06,-4.4466225893980d-07,-6.6756160704669d-08,
     |  -7.0542682117018d-09,-4.5841607619191d-10,-1.4436497752102d-11,
     |  -1.3600420301396d-13, 1.8204031729920d-16,-2.2678274658027d-16/
      data (zmn(lat,14,16), lat = 1,72)/
     |  -2.0974001359506d-16,-1.9412726170872d-16, 4.9013100540189d-15,
     |   7.5407539974069d-13, 3.0985346148035d-11, 5.8745405083362d-10,
     |   6.6342706787092d-09, 5.1582049869683d-08, 3.0213222920373d-07,
     |   1.4153105544277d-06, 5.5279020687488d-06, 1.8553227922603d-05,
     |   5.4725397815665d-05, 1.4431504310041d-04, 3.4479910640819d-04,
     |   7.5422121068569d-04, 1.5230587472949d-03, 2.8581880302764d-03,
     |   5.0106778331113d-03, 8.2396608224240d-03, 1.2748713308679d-02,
     |   1.8599298439634d-02, 2.5616550312162d-02, 3.3312901415919d-02,
     |   4.0860581047403d-02, 4.7140900942458d-02, 5.0884541491045d-02,
     |   5.0894188822354d-02, 4.6314069760171d-02, 3.6888181082014d-02,
     |   2.3138742920311d-02, 6.4045116113704d-03,-1.1294160075098d-02,
     |  -2.7555661963557d-02,-4.0010972902768d-02,-4.6764868257391d-02,
     |  -4.6764868257391d-02,-4.0010972902768d-02,-2.7555661963557d-02,
     |  -1.1294160075098d-02, 6.4045116113703d-03, 2.3138742920311d-02,
     |   3.6888181082014d-02, 4.6314069760171d-02, 5.0894188822354d-02,
     |   5.0884541491045d-02, 4.7140900942458d-02, 4.0860581047403d-02,
     |   3.3312901415919d-02, 2.5616550312162d-02, 1.8599298439634d-02,
     |   1.2748713308679d-02, 8.2396608224240d-03, 5.0106778331113d-03,
     |   2.8581880302764d-03, 1.5230587472948d-03, 7.5422121068570d-04,
     |   3.4479910640816d-04, 1.4431504310041d-04, 5.4725397815660d-05,
     |   1.8553227922604d-05, 5.5279020687951d-06, 1.4153105544321d-06,
     |   3.0213222916316d-07, 5.1582049882710d-08, 6.6342706782594d-09,
     |   5.8745407406295d-10, 3.0985359137824d-11, 7.5410995503281d-13,
     |   4.9372733625244d-15,-1.7204491041308d-16,-1.8410444043692d-16/
      data (zmn(lat,15,16), lat = 1,72)/
     |  -1.8963863517822d-17,-5.0031516031873d-17, 5.6688701231200d-17,
     |   3.0363718878334d-14, 1.6196650836267d-12, 3.7804677600536d-11,
     |   5.0897706945276d-10, 4.6134493829887d-09, 3.0994212179908d-08,
     |   1.6451339703010d-07, 7.2134804286807d-07, 2.6986335708341d-06,
     |   8.8243622518227d-06, 2.5691565309532d-05, 6.7567005797233d-05,
     |   1.6236438550606d-04, 3.5979743907780d-04, 7.4076917520178d-04,
     |   1.4256673794225d-03, 2.5777393678529d-03, 4.3966955815373d-03,
     |   7.0978742357015d-03, 1.0874311323573d-02, 1.5843087696798d-02,
     |   2.1982839515797d-02, 2.9074999605685d-02, 3.6665297229451d-02,
     |   4.4062357132532d-02, 5.0385647805723d-02, 5.4665585783127d-02,
     |   5.5985978623446d-02, 5.3646258968164d-02, 4.7311842516185d-02,
     |   3.7118671414134d-02, 2.3704212910653d-02, 8.1511674175007d-03,
     |  -8.1511674175007d-03,-2.3704212910653d-02,-3.7118671414134d-02,
     |  -4.7311842516185d-02,-5.3646258968164d-02,-5.5985978623446d-02,
     |  -5.4665585783127d-02,-5.0385647805723d-02,-4.4062357132532d-02,
     |  -3.6665297229451d-02,-2.9074999605685d-02,-2.1982839515797d-02,
     |  -1.5843087696798d-02,-1.0874311323573d-02,-7.0978742357016d-03,
     |  -4.3966955815374d-03,-2.5777393678529d-03,-1.4256673794225d-03,
     |  -7.4076917520180d-04,-3.5979743907782d-04,-1.6236438550604d-04,
     |  -6.7567005797254d-05,-2.5691565309552d-05,-8.8243622518498d-06,
     |  -2.6986335708339d-06,-7.2134804291047d-07,-1.6451339705449d-07,
     |  -3.0994212181998d-08,-4.6134493989831d-09,-5.0897708925098d-10,
     |  -3.7804690059397d-11,-1.6196939746477d-12,-3.0354360700269d-14,
     |  -6.6348623261836d-17, 5.8397546237874d-17, 1.2627463904015d-17/
      data (zmn(lat,16,16), lat = 1,72)/
     |  -2.3635862958996d-16,-2.2925713683777d-16,-2.1823926560758d-16,
     |   6.3108401070658d-16, 5.6781936317149d-14, 1.6351628244755d-12,
     |   2.6225286323735d-11, 2.7684195028397d-10, 2.1306876658358d-09,
     |   1.2796445475320d-08, 6.2884683272663d-08, 2.6172162297282d-07,
     |   9.4659579841219d-07, 3.0346468827682d-06, 8.7579025719610d-06,
     |   2.3035982634656d-05, 5.5779037535676d-05, 1.2535804937897d-04,
     |   2.6326850718768d-04, 5.1960829738805d-04, 9.6841264012238d-04,
     |   1.7112477334413d-03, 2.8769624024410d-03, 4.6153921127257d-03,
     |   7.0833405956317d-03, 1.0422447567663d-02, 1.4730488525250d-02,
     |   2.0029889121871d-02, 2.6239200354416d-02, 3.3154315117032d-02,
     |   4.0445767261124d-02, 4.7676313445704d-02, 5.4339384243532d-02,
     |   5.9914601703062d-02, 6.3932423509044d-02, 6.6037182077332d-02,
     |   6.6037182077332d-02, 6.3932423509044d-02, 5.9914601703062d-02,
     |   5.4339384243532d-02, 4.7676313445704d-02, 4.0445767261124d-02,
     |   3.3154315117032d-02, 2.6239200354416d-02, 2.0029889121871d-02,
     |   1.4730488525250d-02, 1.0422447567663d-02, 7.0833405956317d-03,
     |   4.6153921127257d-03, 2.8769624024410d-03, 1.7112477334413d-03,
     |   9.6841264012239d-04, 5.1960829738805d-04, 2.6326850718769d-04,
     |   1.2535804937896d-04, 5.5779037535681d-05, 2.3035982634648d-05,
     |   8.7579025719614d-06, 3.0346468827588d-06, 9.4659579841037d-07,
     |   2.6172162296461d-07, 6.2884683253878d-08, 1.2796445461949d-08,
     |   2.1306876727530d-09, 2.7684193876178d-10, 2.6225294767277d-11,
     |   1.6351699289224d-12, 5.6779605794326d-14, 6.1850526419509d-16,
     |  -2.1002289672973d-16,-2.2894704859477d-16,-2.2705574317788d-16/
      data (zmn(lat, 0,17), lat = 1,72)/
     |   3.3113366214687d-03, 8.6400957940499d-03, 5.2937675644334d-03,
     |  -3.4738602997520d-03,-1.3360413821610d-02,-1.6313024018085d-02,
     |  -9.8219187579608d-03, 4.1505666124936d-03, 1.7249087813445d-02,
     |   2.1811676304386d-02, 1.3685891425480d-02,-3.0497521646589d-03,
     |  -1.9575999764803d-02,-2.5789102419603d-02,-1.7658143084763d-02,
     |   1.2962466014955d-03, 2.0428564888246d-02, 2.8973611620967d-02,
     |   2.1248142987015d-02, 1.2082687302848d-03,-2.0415881741507d-02,
     |  -3.1119887476830d-02,-2.4657371351376d-02,-3.9615748329117d-03,
     |   1.9425829551666d-02, 3.2529984500084d-02, 2.7516010446686d-02,
     |   7.0319847486391d-03,-1.7842031485946d-02,-3.2993264085544d-02,
     |  -2.9948388245377d-02,-1.0028114347960d-02, 1.5583816120244d-02,
     |   3.2753857968221d-02, 3.1652729277568d-02, 1.2996595956452d-02,
     |  -1.2996595956452d-02,-3.1652729277568d-02,-3.2753857968221d-02,
     |  -1.5583816120244d-02, 1.0028114347960d-02, 2.9948388245377d-02,
     |   3.2993264085544d-02, 1.7842031485946d-02,-7.0319847486390d-03,
     |  -2.7516010446686d-02,-3.2529984500084d-02,-1.9425829551667d-02,
     |   3.9615748329117d-03, 2.4657371351376d-02, 3.1119887476830d-02,
     |   2.0415881741508d-02,-1.2082687302846d-03,-2.1248142987015d-02,
     |  -2.8973611620967d-02,-2.0428564888246d-02,-1.2962466014957d-03,
     |   1.7658143084763d-02, 2.5789102419603d-02, 1.9575999764804d-02,
     |   3.0497521646590d-03,-1.3685891425480d-02,-2.1811676304386d-02,
     |  -1.7249087813445d-02,-4.1505666124937d-03, 9.8219187579608d-03,
     |   1.6313024018085d-02, 1.3360413821610d-02, 3.4738602997519d-03,
     |  -5.2937675644334d-03,-8.6400957940500d-03,-3.3113366214687d-03/
      data (zmn(lat, 1,17), lat = 1,72)/
     |   8.5263785820391d-04, 5.7397663712544d-03, 1.1572799918489d-02,
     |   1.2516317662327d-02, 5.8910576736756d-03,-6.0181243613150d-03,
     |  -1.6605342945983d-02,-1.9017449177095d-02,-1.0525383093568d-02,
     |   5.1350758912500d-03, 1.9445428788296d-02, 2.3813173307392d-02,
     |   1.4812450745314d-02,-3.3741485841582d-03,-2.0853377428043d-02,
     |  -2.7495977600440d-02,-1.8842154460723d-02, 9.6285392378951d-04,
     |   2.1146904255745d-02, 3.0216364057982d-02, 2.2559993028309d-02,
     |   1.8972888940138d-03,-2.0505676948411d-02,-3.2032626921491d-02,
     |  -2.5865551330854d-02,-5.0310969243437d-03, 1.9077718854444d-02,
     |   3.2970131428338d-02, 2.8658084744765d-02, 8.2679268397125d-03,
     |  -1.6998080556178d-02,-3.3056957084650d-02,-3.0840476331785d-02,
     |  -1.1445564080734d-02, 1.4406008660441d-02, 3.2329608864218d-02,
     |   3.2329608864218d-02, 1.4406008660441d-02,-1.1445564080734d-02,
     |  -3.0840476331785d-02,-3.3056957084650d-02,-1.6998080556178d-02,
     |   8.2679268397124d-03, 2.8658084744765d-02, 3.2970131428338d-02,
     |   1.9077718854444d-02,-5.0310969243437d-03,-2.5865551330853d-02,
     |  -3.2032626921491d-02,-2.0505676948411d-02, 1.8972888940137d-03,
     |   2.2559993028309d-02, 3.0216364057982d-02, 2.1146904255745d-02,
     |   9.6285392378954d-04,-1.8842154460723d-02,-2.7495977600440d-02,
     |  -2.0853377428042d-02,-3.3741485841582d-03, 1.4812450745313d-02,
     |   2.3813173307392d-02, 1.9445428788296d-02, 5.1350758912500d-03,
     |  -1.0525383093568d-02,-1.9017449177095d-02,-1.6605342945983d-02,
     |  -6.0181243613151d-03, 5.8910576736755d-03, 1.2516317662327d-02,
     |   1.1572799918489d-02, 5.7397663712545d-03, 8.5263785820394d-04/
      data (zmn(lat, 2,17), lat = 1,72)/
     |   8.1289274592256d-05, 1.7365468827280d-03, 6.5939103625955d-03,
     |   1.2967995522074d-02, 1.6680887070389d-02, 1.3644480063775d-02,
     |   3.2351258904959d-03,-1.0517330442288d-02,-2.0475348323959d-02,
     |  -2.0486193122190d-02,-9.2609515448833d-03, 8.0876695639588d-03,
     |   2.2394961951826d-02, 2.5336907672036d-02, 1.4413994321856d-02,
     |  -5.1927134102577d-03,-2.2995886680956d-02,-2.8919356304524d-02,
     |  -1.9028384621978d-02, 1.8587134889255d-03, 2.2529688906024d-02,
     |   3.1410845973653d-02, 2.3138379321344d-02, 1.7724357740545d-03,
     |  -2.1144210787807d-02,-3.2895172897284d-02,-2.6669183348104d-02,
     |  -5.5591139909525d-03, 1.8991663822735d-02, 3.3402562271078d-02,
     |   2.9545396481970d-02, 9.3307881480752d-03,-1.6203301465573d-02,
     |  -3.2981535081478d-02,-3.1671954497639d-02,-1.2934819313282d-02,
     |   1.2934819313282d-02, 3.1671954497638d-02, 3.2981535081478d-02,
     |   1.6203301465573d-02,-9.3307881480752d-03,-2.9545396481970d-02,
     |  -3.3402562271078d-02,-1.8991663822736d-02, 5.5591139909523d-03,
     |   2.6669183348104d-02, 3.2895172897284d-02, 2.1144210787807d-02,
     |  -1.7724357740544d-03,-2.3138379321344d-02,-3.1410845973653d-02,
     |  -2.2529688906025d-02,-1.8587134889256d-03, 1.9028384621978d-02,
     |   2.8919356304524d-02, 2.2995886680956d-02, 5.1927134102578d-03,
     |  -1.4413994321856d-02,-2.5336907672036d-02,-2.2394961951826d-02,
     |  -8.0876695639589d-03, 9.2609515448833d-03, 2.0486193122190d-02,
     |   2.0475348323959d-02, 1.0517330442288d-02,-3.2351258904959d-03,
     |  -1.3644480063774d-02,-1.6680887070389d-02,-1.2967995522074d-02,
     |  -6.5939103625954d-03,-1.7365468827279d-03,-8.1289274592277d-05/
      data (zmn(lat, 3,17), lat = 1,72)/
     |   2.0490051726571d-06, 3.4075766613724d-04, 2.2548762061851d-03,
     |   6.8582413028844d-03, 1.3436547475002d-02, 1.8935422277743d-02,
     |   1.9278932365405d-02, 1.1988581978226d-02,-1.5642011401835d-03,
     |  -1.5921401861276d-02,-2.3911541290615d-02,-2.0566911918076d-02,
     |  -6.3878543720300d-03, 1.2153669972949d-02, 2.5531808227773d-02,
     |   2.6184497683599d-02, 1.2911691442801d-02,-7.9458492814664d-03,
     |  -2.5494156084610d-02,-3.0040695993514d-02,-1.8534038931844d-02,
     |   3.4089749643179d-03, 2.4212394672826d-02, 3.2493856060693d-02,
     |   2.3358486405035d-02, 1.3181920508624d-03,-2.1914500352665d-02,
     |  -3.3688455699555d-02,-2.7359681051531d-02,-6.0744404041415d-03,
     |   1.8780656444233d-02, 3.3705234011664d-02, 3.0469451011261d-02,
     |   1.0687444370438d-02,-1.4981136862512d-02,-3.2609606154213d-02,
     |  -3.2609606154213d-02,-1.4981136862512d-02, 1.0687444370437d-02,
     |   3.0469451011261d-02, 3.3705234011664d-02, 1.8780656444233d-02,
     |  -6.0744404041414d-03,-2.7359681051531d-02,-3.3688455699555d-02,
     |  -2.1914500352665d-02, 1.3181920508624d-03, 2.3358486405035d-02,
     |   3.2493856060693d-02, 2.4212394672826d-02, 3.4089749643180d-03,
     |  -1.8534038931844d-02,-3.0040695993514d-02,-2.5494156084610d-02,
     |  -7.9458492814664d-03, 1.2911691442801d-02, 2.6184497683599d-02,
     |   2.5531808227773d-02, 1.2153669972949d-02,-6.3878543720298d-03,
     |  -2.0566911918075d-02,-2.3911541290615d-02,-1.5921401861276d-02,
     |  -1.5642011401835d-03, 1.1988581978226d-02, 1.9278932365405d-02,
     |   1.8935422277744d-02, 1.3436547475003d-02, 6.8582413028844d-03,
     |   2.2548762061851d-03, 3.4075766613728d-04, 2.0490051726640d-06/
      data (zmn(lat, 4,17), lat = 1,72)/
     |   9.8035902477807d-08, 4.8617445504355d-05, 5.5372791648871d-04,
     |   2.4855691755900d-03, 6.7928841139282d-03, 1.3290762757388d-02,
     |   1.9881112545799d-02, 2.2979212583219d-02, 1.9278671130464d-02,
     |   8.0296961310012d-03,-7.6097907453920d-03,-2.1290271215319d-02,
     |  -2.6303885498118d-02,-1.9231167136471d-02,-2.3737030648110d-03,
     |   1.6660157207686d-02, 2.8382949923078d-02, 2.6306889631501d-02,
     |   1.0682969783008d-02,-1.1097839922993d-02,-2.7962256385075d-02,
     |  -3.0856415867637d-02,-1.7710805480003d-02, 5.1080874103207d-03,
     |   2.5844388772864d-02, 3.3455415930424d-02, 2.3566908721338d-02,
     |   1.0300995613590d-03,-2.2433239667678d-02,-3.4362363910011d-02,
     |  -2.8236124948018d-02,-7.0805700567690d-03, 1.8009947628508d-02,
     |   3.3724876133952d-02, 3.1650985483725d-02, 1.2816075178785d-02,
     |  -1.2816075178785d-02,-3.1650985483725d-02,-3.3724876133952d-02,
     |  -1.8009947628508d-02, 7.0805700567690d-03, 2.8236124948018d-02,
     |   3.4362363910011d-02, 2.2433239667678d-02,-1.0300995613589d-03,
     |  -2.3566908721338d-02,-3.3455415930424d-02,-2.5844388772865d-02,
     |  -5.1080874103207d-03, 1.7710805480003d-02, 3.0856415867637d-02,
     |   2.7962256385075d-02, 1.1097839922994d-02,-1.0682969783008d-02,
     |  -2.6306889631501d-02,-2.8382949923078d-02,-1.6660157207686d-02,
     |   2.3737030648111d-03, 1.9231167136471d-02, 2.6303885498118d-02,
     |   2.1290271215319d-02, 7.6097907453920d-03,-8.0296961310011d-03,
     |  -1.9278671130464d-02,-2.2979212583219d-02,-1.9881112545799d-02,
     |  -1.3290762757388d-02,-6.7928841139283d-03,-2.4855691755901d-03,
     |  -5.5372791648876d-04,-4.8617445504387d-05,-9.8035902444826d-08/
      data (zmn(lat, 5,17), lat = 1,72)/
     |   4.7911342734244d-08, 5.3983378094121d-06, 1.0557026227530d-04,
     |   6.8578495051192d-04, 2.5315431889403d-03, 6.4952152239122d-03,
     |   1.2719556992685d-02, 1.9867816145823d-02, 2.5037386551686d-02,
     |   2.4775170710059d-02, 1.6943967590159d-02, 2.4949100960398d-03,
     |  -1.4028934345672d-02,-2.5937553648326d-02,-2.7417848799125d-02,
     |  -1.6728559063028d-02, 2.2190193260760d-03, 2.1055878579563d-02,
     |   3.0686007002110d-02, 2.5853968546808d-02, 8.1752427870337d-03,
     |  -1.4159012333337d-02,-3.0146758183856d-02,-3.1478885657294d-02,
     |  -1.6975684370086d-02, 6.4680586625480d-03, 2.7124263045569d-02,
     |   3.4345869467029d-02, 2.4137391916627d-02, 1.4208781878674d-03,
     |  -2.2309972122093d-02,-3.4839634313837d-02,-2.9581365592213d-02,
     |  -9.0886903394843d-03, 1.6170567411946d-02, 3.3194826391353d-02,
     |   3.3194826391353d-02, 1.6170567411946d-02,-9.0886903394842d-03,
     |  -2.9581365592213d-02,-3.4839634313837d-02,-2.2309972122093d-02,
     |   1.4208781878673d-03, 2.4137391916627d-02, 3.4345869467029d-02,
     |   2.7124263045569d-02, 6.4680586625480d-03,-1.6975684370086d-02,
     |  -3.1478885657294d-02,-3.0146758183856d-02,-1.4159012333337d-02,
     |   8.1752427870334d-03, 2.5853968546808d-02, 3.0686007002110d-02,
     |   2.1055878579563d-02, 2.2190193260761d-03,-1.6728559063028d-02,
     |  -2.7417848799125d-02,-2.5937553648326d-02,-1.4028934345672d-02,
     |   2.4949100960397d-03, 1.6943967590159d-02, 2.4775170710059d-02,
     |   2.5037386551686d-02, 1.9867816145823d-02, 1.2719556992685d-02,
     |   6.4952152239122d-03, 2.5315431889403d-03, 6.8578495051202d-04,
     |   1.0557026227533d-04, 5.3983378093909d-06, 4.7911342724278d-08/
      data (zmn(lat, 6,17), lat = 1,72)/
     |   1.4309428416014d-09, 4.9324824789665d-07, 1.6318313151069d-05,
     |   1.5194394216722d-04, 7.4572469279667d-04, 2.4481790678882d-03,
     |   6.0293165235558d-03, 1.1838420906794d-02, 1.9129444135006d-02,
     |   2.5718342817777d-02, 2.8428030456547d-02, 2.4409934108133d-02,
     |   1.2860130407067d-02,-3.7893601842135d-03,-2.0091800684858d-02,
     |  -2.9505467645424d-02,-2.7369533637569d-02,-1.3539595579677d-02,
     |   6.8071329756772d-03, 2.4944870326711d-02, 3.2413731871808d-02,
     |   2.5161348575573d-02, 5.9038527438579d-03,-1.6697737321411d-02,
     |  -3.1914324031329d-02,-3.2136100162700d-02,-1.6806073352623d-02,
     |   6.9910287156616d-03, 2.7767926687444d-02, 3.5228647417668d-02,
     |   2.5457008711823d-02, 3.0363367467142d-03,-2.1073927311165d-02,
     |  -3.4929515678661d-02,-3.1581328097272d-02,-1.2610172436988d-02,
     |   1.2610172436988d-02, 3.1581328097272d-02, 3.4929515678661d-02,
     |   2.1073927311165d-02,-3.0363367467141d-03,-2.5457008711823d-02,
     |  -3.5228647417668d-02,-2.7767926687444d-02,-6.9910287156617d-03,
     |   1.6806073352623d-02, 3.2136100162700d-02, 3.1914324031329d-02,
     |   1.6697737321411d-02,-5.9038527438579d-03,-2.5161348575573d-02,
     |  -3.2413731871808d-02,-2.4944870326711d-02,-6.8071329756773d-03,
     |   1.3539595579677d-02, 2.7369533637569d-02, 2.9505467645424d-02,
     |   2.0091800684858d-02, 3.7893601842134d-03,-1.2860130407067d-02,
     |  -2.4409934108133d-02,-2.8428030456547d-02,-2.5718342817777d-02,
     |  -1.9129444135007d-02,-1.1838420906794d-02,-6.0293165235557d-03,
     |  -2.4481790678881d-03,-7.4572469279664d-04,-1.5194394216711d-04,
     |  -1.6318313150956d-05,-4.9324824786587d-07,-1.4309428869620d-09/
      data (zmn(lat, 7,17), lat = 1,72)/
     |  -5.5470055038274d-10, 3.8296521583711d-08, 2.1019426238062d-06,
     |   2.7894529487720d-05, 1.8038936472833d-04, 7.4790176511248d-04,
     |   2.2719380081256d-03, 5.4424539211023d-03, 1.0730076223631d-02,
     |   1.7835742500513d-02, 2.5249867519474d-02, 3.0309596736381d-02,
     |   2.9996179576646d-02, 2.2332050061004d-02, 7.7965172305141d-03,
     |  -1.0046783707935d-02,-2.5318244325699d-02,-3.1974878366176d-02,
     |  -2.6562976952691d-02,-1.0278485037787d-02, 1.0854202049131d-02,
     |   2.8102768944861d-02, 3.3737746792585d-02, 2.4703064945649d-02,
     |   4.4261039560002d-03,-1.8317780868991d-02,-3.3195331286601d-02,
     |  -3.3109917903173d-02,-1.7718354181827d-02, 6.1307668475892d-03,
     |   2.7412018275251d-02, 3.6068702873456d-02, 2.7850650156266d-02,
     |   6.4677078957375d-03,-1.8062755424698d-02,-3.4144086088757d-02,
     |  -3.4144086088757d-02,-1.8062755424698d-02, 6.4677078957374d-03,
     |   2.7850650156266d-02, 3.6068702873456d-02, 2.7412018275251d-02,
     |   6.1307668475892d-03,-1.7718354181827d-02,-3.3109917903173d-02,
     |  -3.3195331286601d-02,-1.8317780868991d-02, 4.4261039560000d-03,
     |   2.4703064945649d-02, 3.3737746792585d-02, 2.8102768944861d-02,
     |   1.0854202049131d-02,-1.0278485037787d-02,-2.6562976952691d-02,
     |  -3.1974878366176d-02,-2.5318244325699d-02,-1.0046783707935d-02,
     |   7.7965172305142d-03, 2.2332050061004d-02, 2.9996179576646d-02,
     |   3.0309596736381d-02, 2.5249867519474d-02, 1.7835742500513d-02,
     |   1.0730076223631d-02, 5.4424539211024d-03, 2.2719380081257d-03,
     |   7.4790176511254d-04, 1.8038936472842d-04, 2.7894529487668d-05,
     |   2.1019426238338d-06, 3.8296521645722d-08,-5.5470056367175d-10/
      data (zmn(lat, 8,17), lat = 1,72)/
     |  -1.1818622567277d-11, 2.4887631951876d-09, 2.2974246517383d-07,
     |   4.3272713246702d-06, 3.6666632879529d-05, 1.9047505811222d-04,
     |   7.0585567630951d-04, 2.0307978578876d-03, 4.7735326608836d-03,
     |   9.4624003095895d-03, 1.6122716047134d-02, 2.3833763706764d-02,
     |   3.0553804444529d-02, 3.3487359728596d-02, 3.0061664120625d-02,
     |   1.9236427740532d-02, 2.5629219100270d-03,-1.5661315126784d-02,
     |  -2.9510505841010d-02,-3.3615140068397d-02,-2.5595534866709d-02,
     |  -7.6111151099255d-03, 1.3893374616251d-02, 3.0431783017729d-02,
     |   3.4945812476355d-02, 2.5025202666552d-02, 4.3372690384399d-03,
     |  -1.8584780490504d-02,-3.3860365563972d-02,-3.4619376188646d-02,
     |  -2.0220863818007d-02, 3.2323862392922d-03, 2.5451499959035d-02,
     |   3.6521401117267d-02, 3.1405295092424d-02, 1.2298772621493d-02,
     |  -1.2298772621493d-02,-3.1405295092424d-02,-3.6521401117267d-02,
     |  -2.5451499959035d-02,-3.2323862392923d-03, 2.0220863818007d-02,
     |   3.4619376188646d-02, 3.3860365563972d-02, 1.8584780490504d-02,
     |  -4.3372690384399d-03,-2.5025202666552d-02,-3.4945812476355d-02,
     |  -3.0431783017729d-02,-1.3893374616251d-02, 7.6111151099255d-03,
     |   2.5595534866709d-02, 3.3615140068397d-02, 2.9510505841010d-02,
     |   1.5661315126784d-02,-2.5629219100269d-03,-1.9236427740532d-02,
     |  -3.0061664120625d-02,-3.3487359728596d-02,-3.0553804444529d-02,
     |  -2.3833763706764d-02,-1.6122716047134d-02,-9.4624003095895d-03,
     |  -4.7735326608837d-03,-2.0307978578876d-03,-7.0585567630956d-04,
     |  -1.9047505811225d-04,-3.6666632879521d-05,-4.3272713247040d-06,
     |  -2.2974246528309d-07,-2.4887632721752d-09, 1.1818596618214d-11/
      data (zmn(lat, 9,17), lat = 1,72)/
     |   6.8256564438582d-12, 1.3191153359994d-10, 2.1545618336680d-08,
     |   5.7426038155365d-07, 6.3517762562430d-06, 4.1128940894103d-05,
     |   1.8463705437416d-04, 6.3200705433608d-04, 1.7483426788062d-03,
     |   4.0577211870840d-03, 8.0971569217513d-03, 1.4110858668333d-02,
     |   2.1660147192044d-02, 2.9337489457571d-02, 3.4824291478495d-02,
     |   3.5454075859142d-02, 2.9226261262005d-02, 1.5938152137576d-02,
     |  -2.0922371259251d-03,-2.0210282084103d-02,-3.2705726975690d-02,
     |  -3.4884811256722d-02,-2.5162256905270d-02,-6.2186075654897d-03,
     |   1.5478009636689d-02, 3.1841845444937d-02, 3.6307593129919d-02,
     |   2.6663829100618d-02, 6.2918667014554d-03,-1.6891220093499d-02,
     |  -3.3509075358869d-02,-3.6608925798432d-02,-2.4689692778310d-02,
     |  -2.5016272229338d-03, 2.0823077038725d-02, 3.5572797518441d-02,
     |   3.5572797518441d-02, 2.0823077038725d-02,-2.5016272229338d-03,
     |  -2.4689692778310d-02,-3.6608925798432d-02,-3.3509075358869d-02,
     |  -1.6891220093499d-02, 6.2918667014553d-03, 2.6663829100618d-02,
     |   3.6307593129919d-02, 3.1841845444937d-02, 1.5478009636689d-02,
     |  -6.2186075654896d-03,-2.5162256905270d-02,-3.4884811256722d-02,
     |  -3.2705726975690d-02,-2.0210282084103d-02,-2.0922371259252d-03,
     |   1.5938152137576d-02, 2.9226261262005d-02, 3.5454075859142d-02,
     |   3.4824291478495d-02, 2.9337489457571d-02, 2.1660147192044d-02,
     |   1.4110858668333d-02, 8.0971569217513d-03, 4.0577211870839d-03,
     |   1.7483426788062d-03, 6.3200705433607d-04, 1.8463705437411d-04,
     |   4.1128940894047d-05, 6.3517762562185d-06, 5.7426038159746d-07,
     |   2.1545618354999d-08, 1.3191150741449d-10, 6.8256883929773d-12/
      data (zmn(lat,10,17), lat = 1,72)/
     |   1.0833337704990d-13, 6.3689068690258d-12, 1.7433119280784d-09,
     |   6.5649275604735d-08, 9.4532353569549d-07, 7.6025610733827d-06,
     |   4.1150243451789d-05, 1.6654870549365d-04, 5.3782591766536d-04,
     |   1.4456630517707d-03, 3.3285332176863d-03, 6.6943264145573d-03,
     |   1.1915637146011d-02, 1.8919702427892d-02, 2.6879278262009d-02,
     |   3.4081028113898d-02, 3.8148474494996d-02, 3.6691849313894d-02,
     |   2.8262489677254d-02, 1.3280440389589d-02,-5.5077990404010d-03,
     |  -2.3405361698065d-02,-3.5052174460067d-02,-3.6296032295243d-02,
     |  -2.5972800857954d-02,-6.8153039126266d-03, 1.5051812460001d-02,
     |   3.2043027566599d-02, 3.7858797110288d-02, 3.0003151701610d-02,
     |   1.1004101539697d-02,-1.2282927338354d-02,-3.1144922834595d-02,
     |  -3.8348226177781d-02,-3.1016115405853d-02,-1.1850319949386d-02,
     |   1.1850319949385d-02, 3.1016115405853d-02, 3.8348226177781d-02,
     |   3.1144922834595d-02, 1.2282927338354d-02,-1.1004101539697d-02,
     |  -3.0003151701610d-02,-3.7858797110288d-02,-3.2043027566599d-02,
     |  -1.5051812460001d-02, 6.8153039126266d-03, 2.5972800857954d-02,
     |   3.6296032295243d-02, 3.5052174460067d-02, 2.3405361698065d-02,
     |   5.5077990404013d-03,-1.3280440389589d-02,-2.8262489677254d-02,
     |  -3.6691849313894d-02,-3.8148474494996d-02,-3.4081028113898d-02,
     |  -2.6879278262009d-02,-1.8919702427892d-02,-1.1915637146011d-02,
     |  -6.6943264145574d-03,-3.3285332176863d-03,-1.4456630517707d-03,
     |  -5.3782591766533d-04,-1.6654870549367d-04,-4.1150243451749d-05,
     |  -7.6025610733694d-06,-9.4532353569373d-07,-6.5649275589951d-08,
     |  -1.7433118657881d-09,-6.3688246210220d-12,-1.0830522892842d-13/
      data (zmn(lat,11,17), lat = 1,72)/
     |  -6.9680953335222d-14, 3.3736369484605d-13, 1.2190852020746d-10,
     |   6.4810255597140d-09, 1.2125586722293d-07, 1.2080386940528d-06,
     |   7.8573117283043d-06, 3.7440322750877d-05, 1.4036116474997d-04,
     |   4.3387897396411d-04, 1.1420383152357d-03, 2.6183210193699d-03,
     |   5.3135282516296d-03, 9.6525311855719d-03, 1.5811695099363d-02,
     |   2.3443946295758d-02, 3.1461671385237d-02, 3.8023862540684d-02,
     |   4.0847031424891d-02, 3.7854424627111d-02, 2.8018895358984d-02,
     |   1.2104964253540d-02,-7.0438673263097d-03,-2.4936069200072d-02,
     |  -3.6604477493025d-02,-3.8228311563033d-02,-2.8653667279507d-02,
     |  -1.0189972629652d-02, 1.1753958614399d-02, 3.0225117619235d-02,
     |   3.9023896329154d-02, 3.4941043308638d-02, 1.9070689504807d-02,
     |  -3.3735724943879d-03,-2.4763825275198d-02,-3.7713050991714d-02,
     |  -3.7713050991714d-02,-2.4763825275198d-02,-3.3735724943880d-03,
     |   1.9070689504807d-02, 3.4941043308638d-02, 3.9023896329153d-02,
     |   3.0225117619235d-02, 1.1753958614400d-02,-1.0189972629652d-02,
     |  -2.8653667279507d-02,-3.8228311563033d-02,-3.6604477493025d-02,
     |  -2.4936069200072d-02,-7.0438673263096d-03, 1.2104964253540d-02,
     |   2.8018895358984d-02, 3.7854424627111d-02, 4.0847031424891d-02,
     |   3.8023862540684d-02, 3.1461671385237d-02, 2.3443946295758d-02,
     |   1.5811695099363d-02, 9.6525311855719d-03, 5.3135282516296d-03,
     |   2.6183210193698d-03, 1.1420383152357d-03, 4.3387897396418d-04,
     |   1.4036116474998d-04, 3.7440322750877d-05, 7.8573117283553d-06,
     |   1.2080386941468d-06, 1.2125586724104d-07, 6.4810255748856d-09,
     |   1.2190852792122d-10, 3.3740595323630d-13,-6.9660187543206d-14/
      data (zmn(lat,12,17), lat = 1,72)/
     |  -9.7637696677742d-16, 1.2030868147852d-14, 7.3593113964094d-12,
     |   5.5141371627482d-10, 1.3384641471201d-08, 1.6486851540703d-07,
     |   1.2853805566187d-06, 7.1884425618025d-06, 3.1163603053507d-05,
     |   1.1023858156125d-04, 3.2967230975085d-04, 8.5482744317025d-04,
     |   1.9575909532756d-03, 4.0131367549833d-03, 7.4375171670127d-03,
     |   1.2546351563513d-02, 1.9344758381089d-02, 2.7303621205772d-02,
     |   3.5219773025522d-02, 4.1272184296079d-02, 4.3350706148746d-02,
     |   3.9644059297105d-02, 2.9352501397592d-02, 1.3285647799397d-02,
     |  -5.9270134163155d-03,-2.4208520632603d-02,-3.7002728525145d-02,
     |  -4.0617451718123d-02,-3.3526481965514d-02,-1.7150309460370d-02,
     |   4.2470536590526d-03, 2.4627990519697d-02, 3.7950739554327d-02,
     |   4.0084199679906d-02, 3.0211515873148d-02, 1.1204737745627d-02,
     |  -1.1204737745627d-02,-3.0211515873148d-02,-4.0084199679906d-02,
     |  -3.7950739554327d-02,-2.4627990519697d-02,-4.2470536590525d-03,
     |   1.7150309460370d-02, 3.3526481965514d-02, 4.0617451718124d-02,
     |   3.7002728525145d-02, 2.4208520632603d-02, 5.9270134163157d-03,
     |  -1.3285647799397d-02,-2.9352501397592d-02,-3.9644059297105d-02,
     |  -4.3350706148746d-02,-4.1272184296079d-02,-3.5219773025522d-02,
     |  -2.7303621205772d-02,-1.9344758381089d-02,-1.2546351563513d-02,
     |  -7.4375171670127d-03,-4.0131367549832d-03,-1.9575909532756d-03,
     |  -8.5482744317022d-04,-3.2967230975089d-04,-1.1023858156117d-04,
     |  -3.1163603053499d-05,-7.1884425617746d-06,-1.2853805566149d-06,
     |  -1.6486851536428d-07,-1.3384641481019d-08,-5.5141373507486d-10,
     |  -7.3592770771040d-12,-1.2108579660918d-14, 9.4638638144598d-16/
      data (zmn(lat,13,17), lat = 1,72)/
     |   5.2432660700150d-16,-2.7576620668187d-16, 3.8088303246820d-13,
     |   4.0140530337979d-11, 1.2626736755041d-09, 1.9201016670649d-08,
     |   1.7910029593930d-07, 1.1727730321664d-06, 5.8623483676342d-06,
     |   2.3646793103342d-05, 7.9992454545584d-05, 2.3330948568691d-04,
     |   5.9881775125310d-04, 1.3733778779295d-03, 2.8473898751463d-03,
     |   5.3832787691492d-03, 9.3403383195851d-03, 1.4938004208331d-02,
     |   2.2075209724826d-02, 3.0156441081043d-02, 3.8002058933147d-02,
     |   4.3924413465219d-02, 4.6019391493700d-02, 4.2655058354993d-02,
     |   3.3052281165428d-02, 1.7778915311664d-02,-1.0443264717607d-03,
     |  -1.9977331590108d-02,-3.4960941076900d-02,-4.2349171692608d-02,
     |  -3.9993521915987d-02,-2.8032983753117d-02,-9.0934377108550d-03,
     |   1.2235927088638d-02, 3.0551775796412d-02, 4.1097296157333d-02,
     |   4.1097296157333d-02, 3.0551775796412d-02, 1.2235927088638d-02,
     |  -9.0934377108550d-03,-2.8032983753117d-02,-3.9993521915987d-02,
     |  -4.2349171692608d-02,-3.4960941076900d-02,-1.9977331590108d-02,
     |  -1.0443264717608d-03, 1.7778915311664d-02, 3.3052281165428d-02,
     |   4.2655058354993d-02, 4.6019391493700d-02, 4.3924413465219d-02,
     |   3.8002058933147d-02, 3.0156441081043d-02, 2.2075209724826d-02,
     |   1.4938004208331d-02, 9.3403383195851d-03, 5.3832787691492d-03,
     |   2.8473898751463d-03, 1.3733778779296d-03, 5.9881775125313d-04,
     |   2.3330948568695d-04, 7.9992454545583d-05, 2.3646793103369d-05,
     |   5.8623483676667d-06, 1.1727730321643d-06, 1.7910029588707d-07,
     |   1.9201016572437d-08, 1.2626736712496d-09, 4.0140506931361d-11,
     |   3.8092504422617d-13,-3.5014568543242d-16, 4.9089721788596d-16/
      data (zmn(lat,14,17), lat = 1,72)/
     |  -1.1724147571268d-16,-1.2546564804923d-16, 1.6516613484229d-14,
     |   2.4636807521222d-12, 1.0034119533305d-10, 1.8814937439082d-09,
     |   2.0965753416162d-08, 1.6045443758455d-07, 9.2276436564939d-07,
     |   4.2329095075220d-06, 1.6144741492787d-05, 5.2757951614498d-05,
     |   1.5103495949706d-04, 3.8523988615333d-04, 8.8693449775117d-04,
     |   1.8618143661351d-03, 3.5913915180376d-03, 6.4043489458613d-03,
     |   1.0604835611721d-02, 1.6355734778096d-02, 2.3533794741262d-02,
     |   3.1595800204069d-02, 3.9511844280325d-02, 4.5822840356683d-02,
     |   4.8857262941010d-02, 4.7096998060672d-02, 3.9624668929552d-02,
     |   2.6534205994912d-02, 9.1648292633302d-03,-9.9579977139064d-03,
     |  -2.7520986724467d-02,-4.0106657533637d-02,-4.5008163585369d-02,
     |  -4.0957896129510d-02,-2.8552734257804d-02,-1.0229783668231d-02,
     |   1.0229783668231d-02, 2.8552734257804d-02, 4.0957896129510d-02,
     |   4.5008163585369d-02, 4.0106657533637d-02, 2.7520986724467d-02,
     |   9.9579977139065d-03,-9.1648292633300d-03,-2.6534205994912d-02,
     |  -3.9624668929552d-02,-4.7096998060672d-02,-4.8857262941010d-02,
     |  -4.5822840356683d-02,-3.9511844280325d-02,-3.1595800204069d-02,
     |  -2.3533794741262d-02,-1.6355734778096d-02,-1.0604835611721d-02,
     |  -6.4043489458613d-03,-3.5913915180376d-03,-1.8618143661351d-03,
     |  -8.8693449775113d-04,-3.8523988615329d-04,-1.5103495949709d-04,
     |  -5.2757951614524d-05,-1.6144741492763d-05,-4.2329095075925d-06,
     |  -9.2276436567763d-07,-1.6045443760310d-07,-2.0965753454076d-08,
     |  -1.8814938161339d-09,-1.0034114440141d-10,-2.4636606977166d-12,
     |  -1.6561709327717d-14, 2.0119516149241d-16, 1.4797676677634d-16/
      data (zmn(lat,15,17), lat = 1,72)/
     |  -3.2282217501394d-17,-9.2303206569878d-17, 4.5550107508215d-16,
     |   1.2388154756826d-13, 6.5362280102743d-12, 1.5098808224551d-10,
     |   2.0075880434973d-09, 1.7931394693455d-08, 1.1843497086000d-07,
     |   6.1655473084485d-07, 2.6448411031832d-06, 9.6547502738737d-06,
     |   3.0719582778816d-05, 8.6770493033607d-05, 2.2069259371774d-04,
     |   5.1112462018401d-04, 1.0875647431622d-03, 2.1412000553978d-03,
     |   3.9227222477100d-03, 6.7169834515402d-03, 1.0786660972379d-02,
     |   1.6284453772151d-02, 2.3145321689348d-02, 3.0984092977360d-02,
     |   3.9034427426499d-02, 4.6166871694862d-02, 5.1012331653643d-02,
     |   5.2192362294545d-02, 4.8624177152301d-02, 3.9835914087375d-02,
     |   2.6208256217386d-02, 9.0617046442791d-03,-9.4619189416201d-03,
     |  -2.6725040868122d-02,-4.0070655560857d-02,-4.7345588416652d-02,
     |  -4.7345588416652d-02,-4.0070655560857d-02,-2.6725040868122d-02,
     |  -9.4619189416202d-03, 9.0617046442791d-03, 2.6208256217386d-02,
     |   3.9835914087375d-02, 4.8624177152301d-02, 5.2192362294545d-02,
     |   5.1012331653643d-02, 4.6166871694862d-02, 3.9034427426499d-02,
     |   3.0984092977360d-02, 2.3145321689348d-02, 1.6284453772151d-02,
     |   1.0786660972379d-02, 6.7169834515403d-03, 3.9227222477100d-03,
     |   2.1412000553978d-03, 1.0875647431622d-03, 5.1112462018402d-04,
     |   2.2069259371773d-04, 8.6770493033593d-05, 3.0719582778795d-05,
     |   9.6547502738648d-06, 2.6448411032141d-06, 6.1655473077500d-07,
     |   1.1843497082169d-07, 1.7931394688031d-08, 2.0075880809439d-09,
     |   1.5098812614820d-10, 6.5362361014135d-12, 1.2386868639040d-13,
     |   4.2530597320644d-16,-2.2833862849315d-17,-5.1837981624628d-18/
      data (zmn(lat,16,17), lat = 1,72)/
     |  -1.7882367564449d-16,-1.7513106406263d-16,-1.5470490907484d-16,
     |   4.6995244744603d-15, 3.3036326273448d-13, 9.3973415335044d-12,
     |   1.4895321677052d-10, 1.5509006858929d-09, 1.1748256152559d-08,
     |   6.9293465736700d-08, 3.3366428675903d-07, 1.3574939021635d-06,
     |   4.7876229711410d-06, 1.4927551112673d-05, 4.1783871017425d-05,
     |   1.0628477173883d-04, 2.4810205123842d-04, 5.3572550051581d-04,
     |   1.0770436809497d-03, 2.0268581413233d-03, 3.5860447889898d-03,
     |   5.9863468110280d-03, 9.4559937630924d-03, 1.4165118323732d-02,
     |   2.0156126848252d-02, 2.7271534502649d-02, 3.5098063225465d-02,
     |   4.2948335642604d-02, 4.9898077686512d-02, 5.4886662749228d-02,
     |   5.6873572063866d-02, 5.5026566396758d-02, 4.8904037862629d-02,
     |   3.8588904977517d-02, 2.4737380977283d-02, 8.5226662882158d-03,
     |  -8.5226662882157d-03,-2.4737380977283d-02,-3.8588904977517d-02,
     |  -4.8904037862629d-02,-5.5026566396758d-02,-5.6873572063866d-02,
     |  -5.4886662749228d-02,-4.9898077686512d-02,-4.2948335642604d-02,
     |  -3.5098063225465d-02,-2.7271534502649d-02,-2.0156126848252d-02,
     |  -1.4165118323732d-02,-9.4559937630924d-03,-5.9863468110280d-03,
     |  -3.5860447889898d-03,-2.0268581413233d-03,-1.0770436809497d-03,
     |  -5.3572550051582d-04,-2.4810205123840d-04,-1.0628477173883d-04,
     |  -4.1783871017461d-05,-1.4927551112721d-05,-4.7876229711097d-06,
     |  -1.3574939021527d-06,-3.3366428672830d-07,-6.9293465718431d-08,
     |  -1.1748256172941d-08,-1.5509006762344d-09,-1.4895319338985d-10,
     |  -9.3972879265435d-12,-3.3040053649436d-13,-4.6776142584573d-15,
     |   1.7551162433235d-16, 1.5693861032208d-16, 1.8154840415019d-16/
      data (zmn(lat,17,17), lat = 1,72)/
     |  -1.2728288918149d-17,-3.0301886171197d-17,-4.8368819058762d-17,
     |   6.6515672097417d-17, 1.1209540509124d-14, 3.9430217811049d-13,
     |   7.4457045336504d-12, 9.0287051177901d-11, 7.8351643701504d-10,
     |   5.2289668794457d-09, 2.8219237526617d-08, 1.2772299798153d-07,
     |   4.9823785016245d-07, 1.7105733248160d-06, 5.2542367607463d-06,
     |   1.4629266250001d-05, 3.7314603735347d-05, 8.7952294412193d-05,
     |   1.9295211612755d-04, 3.9636560180332d-04, 7.6627612181875d-04,
     |   1.4001739391986d-03, 2.4270299280094d-03, 4.0033587930196d-03,
     |   6.3008182014380d-03, 9.4840777892007d-03, 1.3679827553694d-02,
     |   1.8940554454689d-02, 2.5209433969753d-02, 3.2294488526788d-02,
     |   3.9860233731949d-02, 4.7442893604912d-02, 5.4491040515458d-02,
     |   6.0428002569883d-02, 6.4726910289961d-02, 6.6985335037813d-02,
     |   6.6985335037813d-02, 6.4726910289961d-02, 6.0428002569883d-02,
     |   5.4491040515458d-02, 4.7442893604912d-02, 3.9860233731949d-02,
     |   3.2294488526788d-02, 2.5209433969753d-02, 1.8940554454689d-02,
     |   1.3679827553694d-02, 9.4840777892007d-03, 6.3008182014380d-03,
     |   4.0033587930196d-03, 2.4270299280094d-03, 1.4001739391986d-03,
     |   7.6627612181875d-04, 3.9636560180333d-04, 1.9295211612755d-04,
     |   8.7952294412221d-05, 3.7314603735330d-05, 1.4629266250003d-05,
     |   5.2542367607411d-06, 1.7105733248041d-06, 4.9823785016436d-07,
     |   1.2772299799258d-07, 2.8219237518734d-08, 5.2289669003171d-09,
     |   7.8351643811773d-10, 9.0287064487097d-11, 7.4456965284945d-12,
     |   3.9429868350510d-13, 1.1193853134032d-14, 8.8852223556851d-17,
     |  -3.9157901485345d-17,-3.5289335299406d-17,-2.4072927309178d-17/
      data (zmn(lat, 0,18), lat = 1,72)/
     |   3.3852363240424d-03, 8.4894054629132d-03, 4.1516718549966d-03,
     |  -5.4326779672378d-03,-1.4621263524797d-02,-1.4862679171332d-02,
     |  -5.0522368074750d-03, 1.0149136039016d-02, 2.0340997695551d-02,
     |   1.8460474619524d-02, 4.0266665428395d-03,-1.4193907281995d-02,
     |  -2.4885478800759d-02,-2.0173909113546d-02,-2.3205152878020d-03,
     |   1.8236118192983d-02, 2.8205372938453d-02, 2.0853874023802d-02,
     |  -1.5628612618266d-04,-2.1880715479286d-02,-3.0719034966968d-02,
     |  -2.0448786559604d-02, 2.9514486501977d-03, 2.5250267969793d-02,
     |   3.2265873632236d-02, 1.9301680418128d-02,-6.0539790594808d-03,
     |  -2.8083558609226d-02,-3.3012375601351d-02,-1.7423912859089d-02,
     |   9.1789772361278d-03, 3.0384526770793d-02, 3.2894793647371d-02,
     |   1.5034777312227d-02,-1.2235236801173d-02,-3.2004745524305d-02,
     |  -3.2004745524305d-02,-1.2235236801173d-02, 1.5034777312227d-02,
     |   3.2894793647371d-02, 3.0384526770793d-02, 9.1789772361277d-03,
     |  -1.7423912859089d-02,-3.3012375601351d-02,-2.8083558609226d-02,
     |  -6.0539790594808d-03, 1.9301680418128d-02, 3.2265873632236d-02,
     |   2.5250267969792d-02, 2.9514486501976d-03,-2.0448786559604d-02,
     |  -3.0719034966968d-02,-2.1880715479286d-02,-1.5628612618276d-04,
     |   2.0853874023802d-02, 2.8205372938453d-02, 1.8236118192983d-02,
     |  -2.3205152878021d-03,-2.0173909113546d-02,-2.4885478800759d-02,
     |  -1.4193907281995d-02, 4.0266665428395d-03, 1.8460474619524d-02,
     |   2.0340997695551d-02, 1.0149136039016d-02,-5.0522368074750d-03,
     |  -1.4862679171332d-02,-1.4621263524797d-02,-5.4326779672378d-03,
     |   4.1516718549965d-03, 8.4894054629134d-03, 3.3852363240425d-03/
      data (zmn(lat, 1,18), lat = 1,72)/
     |   9.3274677947372d-04, 6.1043891702405d-03, 1.1796460537209d-02,
     |   1.1470875218988d-02, 3.0422625614687d-03,-9.5969330651626d-03,
     |  -1.8223549835920d-02,-1.6210230850227d-02,-3.2526789062531d-03,
     |   1.3330967895566d-02, 2.3050525074817d-02, 1.8805259956083d-02,
     |   2.1840814688037d-03,-1.7098348903397d-02,-2.6773423539669d-02,
     |  -2.0074634684732d-02,-2.6647066699390d-04, 2.0695716519700d-02,
     |   2.9613877529270d-02, 2.0253951971753d-02,-2.1692873579154d-03,
     |  -2.4055647414500d-02,-3.1565537824852d-02,-1.9582368937208d-02,
     |   4.9757561084712d-03, 2.7001640498422d-02, 3.2708685744403d-02,
     |   1.8149056410362d-02,-7.9174126913833d-03,-2.9480290303356d-02,
     |  -3.3009901457879d-02,-1.6146336591908d-02, 1.0882634680299d-02,
     |   3.1340389883845d-02, 3.2556453192092d-02, 1.3657764620973d-02,
     |  -1.3657764620973d-02,-3.2556453192092d-02,-3.1340389883845d-02,
     |  -1.0882634680299d-02, 1.6146336591908d-02, 3.3009901457879d-02,
     |   2.9480290303356d-02, 7.9174126913835d-03,-1.8149056410362d-02,
     |  -3.2708685744403d-02,-2.7001640498422d-02,-4.9757561084713d-03,
     |   1.9582368937208d-02, 3.1565537824852d-02, 2.4055647414500d-02,
     |   2.1692873579158d-03,-2.0253951971753d-02,-2.9613877529270d-02,
     |  -2.0695716519700d-02, 2.6647066699389d-04, 2.0074634684732d-02,
     |   2.6773423539669d-02, 1.7098348903397d-02,-2.1840814688036d-03,
     |  -1.8805259956083d-02,-2.3050525074817d-02,-1.3330967895566d-02,
     |   3.2526789062530d-03, 1.6210230850227d-02, 1.8223549835920d-02,
     |   9.5969330651627d-03,-3.0422625614686d-03,-1.1470875218988d-02,
     |  -1.1796460537208d-02,-6.1043891702406d-03,-9.3274677947372d-04/
      data (zmn(lat, 2,18), lat = 1,72)/
     |   9.3378054287639d-05, 1.9697588402256d-03, 7.2904891193303d-03,
     |   1.3695025031855d-02, 1.6197189221631d-02, 1.0754755554119d-02,
     |  -1.8003493575199d-03,-1.5284774552117d-02,-2.1372382746447d-02,
     |  -1.5171596654671d-02, 9.8057574466231d-04, 1.7999165847769d-02,
     |   2.5307676908364d-02, 1.7495077527169d-02,-1.6673700989538d-03,
     |  -2.0971447490270d-02,-2.8349729684847d-02,-1.8544038649793d-02,
     |   3.2076587728010d-03, 2.3893529779096d-02, 3.0600305827368d-02,
     |   1.8614063749703d-02,-5.2645400319122d-03,-2.6598102402280d-02,
     |  -3.2078289371320d-02,-1.7901719222409d-02, 7.6217860973898d-03,
     |   2.8941301563948d-02, 3.2809314027883d-02, 1.6550374482279d-02,
     |  -1.0088189139407d-02,-3.0817137661269d-02,-3.2813577739170d-02,
     |  -1.4703900424458d-02, 1.2500978065013d-02, 3.2131609799824d-02,
     |   3.2131609799824d-02, 1.2500978065013d-02,-1.4703900424458d-02,
     |  -3.2813577739170d-02,-3.0817137661269d-02,-1.0088189139407d-02,
     |   1.6550374482279d-02, 3.2809314027883d-02, 2.8941301563948d-02,
     |   7.6217860973898d-03,-1.7901719222409d-02,-3.2078289371320d-02,
     |  -2.6598102402280d-02,-5.2645400319122d-03, 1.8614063749703d-02,
     |   3.0600305827368d-02, 2.3893529779096d-02, 3.2076587728011d-03,
     |  -1.8544038649792d-02,-2.8349729684847d-02,-2.0971447490270d-02,
     |  -1.6673700989538d-03, 1.7495077527169d-02, 2.5307676908364d-02,
     |   1.7999165847769d-02, 9.8057574466232d-04,-1.5171596654671d-02,
     |  -2.1372382746447d-02,-1.5284774552117d-02,-1.8003493575199d-03,
     |   1.0754755554119d-02, 1.6197189221631d-02, 1.3695025031855d-02,
     |   7.2904891193304d-03, 1.9697588402256d-03, 9.3378054287636d-05/
      data (zmn(lat, 3,18), lat = 1,72)/
     |   2.2284054678663d-06, 4.1076514585677d-04, 2.6667297989574d-03,
     |   7.8709835601806d-03, 1.4715553533930d-02, 1.9238138841011d-02,
     |   1.6990488907282d-02, 6.4739730942949d-03,-8.7143952288127d-03,
     |  -2.0940910661629d-02,-2.2746760769613d-02,-1.1764197253291d-02,
     |   6.9105566806375d-03, 2.2906816683115d-02, 2.6442745930756d-02,
     |   1.4485108259422d-02,-6.7795488162381d-03,-2.5052374209348d-02,
     |  -2.9112897952447d-02,-1.5808260092803d-02, 7.5481063990468d-03,
     |   2.7170079341567d-02, 3.0991914222170d-02, 1.6169864784303d-02,
     |  -8.8389916104845d-03,-2.9095006546665d-02,-3.2164317285600d-02,
     |  -1.5807456501193d-02, 1.0401407438237d-02, 3.0701273857475d-02,
     |   3.2673779811965d-02, 1.4897848362365d-02,-1.2042671429086d-02,
     |  -3.1884449715735d-02,-3.2564212778036d-02,-1.3592481690795d-02,
     |   1.3592481690795d-02, 3.2564212778036d-02, 3.1884449715736d-02,
     |   1.2042671429086d-02,-1.4897848362365d-02,-3.2673779811965d-02,
     |  -3.0701273857475d-02,-1.0401407438238d-02, 1.5807456501192d-02,
     |   3.2164317285600d-02, 2.9095006546665d-02, 8.8389916104846d-03,
     |  -1.6169864784303d-02,-3.0991914222170d-02,-2.7170079341567d-02,
     |  -7.5481063990471d-03, 1.5808260092803d-02, 2.9112897952447d-02,
     |   2.5052374209348d-02, 6.7795488162380d-03,-1.4485108259422d-02,
     |  -2.6442745930756d-02,-2.2906816683115d-02,-6.9105566806375d-03,
     |   1.1764197253291d-02, 2.2746760769613d-02, 2.0940910661629d-02,
     |   8.7143952288127d-03,-6.4739730942949d-03,-1.6990488907282d-02,
     |  -1.9238138841011d-02,-1.4715553533930d-02,-7.8709835601806d-03,
     |  -2.6667297989574d-03,-4.1076514585685d-04,-2.2284054679031d-06/
      data (zmn(lat, 4,18), lat = 1,72)/
     |   1.2529139516158d-07, 6.2178319761723d-05, 6.9806258627130d-04,
     |   3.0629661498433d-03, 8.0976937709112d-03, 1.5109769187015d-02,
     |   2.1074303987111d-02, 2.1718383066415d-02, 1.4167744097959d-02,
     |  -4.1317434381495d-04,-1.6221640554695d-02,-2.5246957365719d-02,
     |  -2.1773117119032d-02,-6.3322583186890d-03, 1.3595597764124d-02,
     |   2.7120671807330d-02, 2.6054470671630d-02, 1.0066796209277d-02,
     |  -1.2440426819361d-02,-2.8689879283765d-02,-2.8875285582822d-02,
     |  -1.2203494338566d-02, 1.2152739574051d-02, 3.0078846364550d-02,
     |   3.0767671973470d-02, 1.3324065411680d-02,-1.2364643546594d-02,
     |  -3.1234081425666d-02,-3.1939602425840d-02,-1.3744913155985d-02,
     |   1.2820545748403d-02, 3.2074536045105d-02, 3.2498537254355d-02,
     |   1.3683483634376d-02,-1.3318984330378d-02,-3.2520388511300d-02,
     |  -3.2520388511300d-02,-1.3318984330378d-02, 1.3683483634376d-02,
     |   3.2498537254355d-02, 3.2074536045105d-02, 1.2820545748403d-02,
     |  -1.3744913155985d-02,-3.1939602425840d-02,-3.1234081425666d-02,
     |  -1.2364643546594d-02, 1.3324065411680d-02, 3.0767671973470d-02,
     |   3.0078846364550d-02, 1.2152739574051d-02,-1.2203494338566d-02,
     |  -2.8875285582822d-02,-2.8689879283765d-02,-1.2440426819361d-02,
     |   1.0066796209277d-02, 2.6054470671630d-02, 2.7120671807330d-02,
     |   1.3595597764124d-02,-6.3322583186890d-03,-2.1773117119032d-02,
     |  -2.5246957365719d-02,-1.6221640554695d-02,-4.1317434381493d-04,
     |   1.4167744097959d-02, 2.1718383066415d-02, 2.1074303987111d-02,
     |   1.5109769187015d-02, 8.0976937709113d-03, 3.0629661498433d-03,
     |   6.9806258627123d-04, 6.2178319761842d-05, 1.2529139517479d-07/
      data (zmn(lat, 5,18), lat = 1,72)/
     |   7.1843364319773d-08, 7.3287256611639d-06, 1.4177120223052d-04,
     |   9.0412449430761d-04, 3.2519064129095d-03, 8.0534648258498d-03,
     |   1.5033670227399d-02, 2.1970189269116d-02, 2.5064090992127d-02,
     |   2.0781050469302d-02, 8.3623719463610d-03,-8.6066933478549d-03,
     |  -2.2992661218679d-02,-2.7414408805782d-02,-1.8502977167031d-02,
     |   4.0137188492294d-04, 2.0108152309697d-02, 3.0050137798373d-02,
     |   2.4162744361992d-02, 4.7866119601778d-03,-1.7973407265614d-02,
     |  -3.1494500949813d-02,-2.7754608232191d-02,-8.2319843967097d-03,
     |   1.6473248363743d-02, 3.2383817139172d-02, 3.0135660095963d-02,
     |   1.0587768541697d-02,-1.5363680395373d-02,-3.2866172759135d-02,
     |  -3.1678787133533d-02,-1.2237189460119d-02, 1.4421125818252d-02,
     |   3.2946435066240d-02, 3.2576832381188d-02, 1.3444174087402d-02,
     |  -1.3444174087402d-02,-3.2576832381188d-02,-3.2946435066240d-02,
     |  -1.4421125818252d-02, 1.2237189460119d-02, 3.1678787133533d-02,
     |   3.2866172759135d-02, 1.5363680395373d-02,-1.0587768541697d-02,
     |  -3.0135660095963d-02,-3.2383817139172d-02,-1.6473248363743d-02,
     |   8.2319843967096d-03, 2.7754608232191d-02, 3.1494500949813d-02,
     |   1.7973407265614d-02,-4.7866119601777d-03,-2.4162744361992d-02,
     |  -3.0050137798373d-02,-2.0108152309697d-02,-4.0137188492307d-04,
     |   1.8502977167031d-02, 2.7414408805782d-02, 2.2992661218679d-02,
     |   8.6066933478550d-03,-8.3623719463610d-03,-2.0781050469301d-02,
     |  -2.5064090992127d-02,-2.1970189269116d-02,-1.5033670227399d-02,
     |  -8.0534648258498d-03,-3.2519064129095d-03,-9.0412449430760d-04,
     |  -1.4177120223053d-04,-7.3287256611421d-06,-7.1843364306879d-08/
      data (zmn(lat, 6,18), lat = 1,72)/
     |   2.0920912497180d-09, 7.1321048875446d-07, 2.3361487119788d-05,
     |   2.1418678323131d-04, 1.0288488834996d-03, 3.2827859388873d-03,
     |   7.7908982616597d-03, 1.4578090826936d-02, 2.2095776757280d-02,
     |   2.7157719349429d-02, 2.6079607014128d-02, 1.6766892333746d-02,
     |   6.6782753880615d-04,-1.6794856249856d-02,-2.8098244869127d-02,
     |  -2.7268697624836d-02,-1.3487796738420d-02, 7.5447204435807d-03,
     |   2.5733418363411d-02, 3.1522565693436d-02, 2.1167698023632d-02,
     |  -6.7613177550565d-04,-2.2845043648818d-02,-3.3385080935958d-02,
     |  -2.6140379755246d-02,-4.4946961423752d-03, 2.0068216576921d-02,
     |   3.4061689505378d-02, 2.9494841857353d-02, 8.5400685090276d-03,
     |  -1.7412956236687d-02,-3.3962543319323d-02,-3.1758630993542d-02,
     |  -1.1858283435675d-02, 1.4739561741139d-02, 3.3203517446950d-02,
     |   3.3203517446950d-02, 1.4739561741139d-02,-1.1858283435675d-02,
     |  -3.1758630993542d-02,-3.3962543319323d-02,-1.7412956236687d-02,
     |   8.5400685090275d-03, 2.9494841857353d-02, 3.4061689505378d-02,
     |   2.0068216576921d-02,-4.4946961423752d-03,-2.6140379755245d-02,
     |  -3.3385080935958d-02,-2.2845043648818d-02,-6.7613177550569d-04,
     |   2.1167698023632d-02, 3.1522565693436d-02, 2.5733418363411d-02,
     |   7.5447204435808d-03,-1.3487796738420d-02,-2.7268697624836d-02,
     |  -2.8098244869127d-02,-1.6794856249856d-02, 6.6782753880599d-04,
     |   1.6766892333746d-02, 2.6079607014128d-02, 2.7157719349429d-02,
     |   2.2095776757280d-02, 1.4578090826936d-02, 7.7908982616597d-03,
     |   3.2827859388873d-03, 1.0288488834996d-03, 2.1418678323129d-04,
     |   2.3361487119822d-05, 7.1321048865795d-07, 2.0920912087832d-09/
      data (zmn(lat, 7,18), lat = 1,72)/
     |  -9.8901288275290d-10, 5.9203812106874d-08, 3.2140632646555d-06,
     |   4.2088980674223d-05, 2.6722387071748d-04, 1.0816665243389d-03,
     |   3.1872548204944d-03, 7.3483428533018d-03, 1.3805041536872d-02,
     |   2.1568692273723d-02, 2.8111282802789d-02, 2.9951114612933d-02,
     |   2.4210491938109d-02, 1.0543083369400d-02,-7.6802716775601d-03,
     |  -2.3948654247535d-02,-3.1161862921638d-02,-2.5184916513232d-02,
     |  -7.5740498758812d-03, 1.4271293382646d-02, 3.0099593743818d-02,
     |   3.1774736301351d-02, 1.7728659222553d-02,-5.6405411853167d-03,
     |  -2.6735285028005d-02,-3.4560812111446d-02,-2.4614697460533d-02,
     |  -1.6204479398001d-03, 2.2604567854967d-02, 3.5241615804127d-02,
     |   2.9354102356834d-02, 7.7991316035397d-03,-1.8093303993829d-02,
     |  -3.4498669989797d-02,-3.2552653764728d-02,-1.3208476423489d-02,
     |   1.3208476423489d-02, 3.2552653764728d-02, 3.4498669989797d-02,
     |   1.8093303993829d-02,-7.7991316035396d-03,-2.9354102356834d-02,
     |  -3.5241615804127d-02,-2.2604567854968d-02, 1.6204479398000d-03,
     |   2.4614697460533d-02, 3.4560812111446d-02, 2.6735285028005d-02,
     |   5.6405411853168d-03,-1.7728659222553d-02,-3.1774736301351d-02,
     |  -3.0099593743818d-02,-1.4271293382646d-02, 7.5740498758811d-03,
     |   2.5184916513232d-02, 3.1161862921638d-02, 2.3948654247535d-02,
     |   7.6802716775600d-03,-1.0543083369400d-02,-2.4210491938109d-02,
     |  -2.9951114612933d-02,-2.8111282802789d-02,-2.1568692273723d-02,
     |  -1.3805041536872d-02,-7.3483428533018d-03,-3.1872548204943d-03,
     |  -1.0816665243388d-03,-2.6722387071747d-04,-4.2088980674224d-05,
     |  -3.2140632646878d-06,-5.9203812145036d-08, 9.8901287363456d-10/
      data (zmn(lat, 8,18), lat = 1,72)/
     |  -1.9734367873813d-11, 4.1088252444984d-09, 3.7633402095214d-07,
     |   7.0053973514324d-06, 5.8412192576881d-05, 2.9719994612110d-04,
     |   1.0730780577362d-03, 2.9899886816438d-03, 6.7577802334199d-03,
     |   1.2764933697861d-02, 2.0479784353216d-02, 2.8022312221014d-02,
     |   3.2344793657931d-02, 3.0263319465325d-02, 2.0106509672236d-02,
     |   3.2259646456387d-03,-1.5601813866956d-02,-2.9506341016540d-02,
     |  -3.2358028857641d-02,-2.1924008636375d-02,-1.6811355027822d-03,
     |   1.9979602844791d-02, 3.3203996428874d-02, 3.1358943358155d-02,
     |   1.4630248453080d-02,-9.5058597976408d-03,-2.9519607783936d-02,
     |  -3.5407075644221d-02,-2.3855943138585d-02,-2.4305364206781d-04,
     |   2.3780331476430d-02, 3.6068123459873d-02, 3.0221270835139d-02,
     |   9.0173028577319d-03,-1.6862295252163d-02,-3.4245072868227d-02,
     |  -3.4245072868227d-02,-1.6862295252163d-02, 9.0173028577318d-03,
     |   3.0221270835139d-02, 3.6068123459873d-02, 2.3780331476430d-02,
     |  -2.4305364206774d-04,-2.3855943138585d-02,-3.5407075644221d-02,
     |  -2.9519607783936d-02,-9.5058597976408d-03, 1.4630248453080d-02,
     |   3.1358943358155d-02, 3.3203996428874d-02, 1.9979602844791d-02,
     |  -1.6811355027819d-03,-2.1924008636375d-02,-3.2358028857641d-02,
     |  -2.9506341016540d-02,-1.5601813866956d-02, 3.2259646456385d-03,
     |   2.0106509672236d-02, 3.0263319465325d-02, 3.2344793657931d-02,
     |   2.8022312221014d-02, 2.0479784353216d-02, 1.2764933697861d-02,
     |   6.7577802334200d-03, 2.9899886816438d-03, 1.0730780577362d-03,
     |   2.9719994612112d-04, 5.8412192576853d-05, 7.0053973514553d-06,
     |   3.7633402096245d-07, 4.1088252858161d-09,-1.9734322911978d-11/
      data (zmn(lat, 9,18), lat = 1,72)/
     |   1.4396881553254d-11, 2.3176170179810d-10, 3.7959740787886d-08,
     |   1.0010863790845d-06, 1.0915442763495d-05, 6.9393781358378d-05,
     |   3.0451259686715d-04, 1.0138837540820d-03, 2.7128826118636d-03,
     |   6.0498156999911d-03, 1.1505665727443d-02, 1.8910278323839d-02,
     |   2.6984741703298d-02, 3.3251409804370d-02, 3.4605980475602d-02,
     |   2.8561905234502d-02, 1.4748803645925d-02,-4.0925846474968d-03,
     |  -2.2367064745178d-02,-3.3409791995173d-02,-3.2292406423274d-02,
     |  -1.8437870854263d-02, 3.3569540158280d-03, 2.4334424240581d-02,
     |   3.5331607964096d-02, 3.1005480287239d-02, 1.2685819878136d-02,
     |  -1.1739561259023d-02,-3.1149952877604d-02,-3.6339766731465d-02,
     |  -2.4545197837269d-02,-1.0409739954430d-03, 2.3150985443733d-02,
     |   3.6467753417424d-02, 3.2427117656728d-02, 1.2866606874431d-02,
     |  -1.2866606874430d-02,-3.2427117656728d-02,-3.6467753417424d-02,
     |  -2.3150985443733d-02, 1.0409739954429d-03, 2.4545197837269d-02,
     |   3.6339766731465d-02, 3.1149952877604d-02, 1.1739561259023d-02,
     |  -1.2685819878136d-02,-3.1005480287239d-02,-3.5331607964096d-02,
     |  -2.4334424240581d-02,-3.3569540158279d-03, 1.8437870854263d-02,
     |   3.2292406423274d-02, 3.3409791995173d-02, 2.2367064745178d-02,
     |   4.0925846474968d-03,-1.4748803645925d-02,-2.8561905234502d-02,
     |  -3.4605980475602d-02,-3.3251409804370d-02,-2.6984741703298d-02,
     |  -1.8910278323839d-02,-1.1505665727443d-02,-6.0498156999912d-03,
     |  -2.7128826118636d-03,-1.0138837540820d-03,-3.0451259686714d-04,
     |  -6.9393781358439d-05,-1.0915442763467d-05,-1.0010863790975d-06,
     |  -3.7959740787182d-08,-2.3176173335494d-10,-1.4396903962766d-11/
      data (zmn(lat,10,18), lat = 1,72)/
     |   2.0986780082763d-13, 1.2203409370199d-11, 3.3206319580492d-09,
     |   1.2386098398819d-07, 1.7606752674735d-06, 1.3928573445782d-05,
     |   7.3877211336613d-05, 2.9178652009810d-04, 9.1526165099310d-04,
     |   2.3772248016094d-03, 5.2564830190926d-03, 1.0078194006174d-02,
     |   1.6943606273401d-02, 2.5101845626172d-02, 3.2703701807009d-02,
     |   3.7013123915225d-02, 3.5218989973542d-02, 2.5694377809659d-02,
     |   9.2150355655610d-03,-1.0529120057107d-02,-2.7647424458313d-02,
     |  -3.6010192699797d-02,-3.1826027642512d-02,-1.5715963067225d-02,
     |   6.8351723286482d-03, 2.7176969080989d-02, 3.6884970235233d-02,
     |   3.1473280467598d-02, 1.2703476052006d-02,-1.1758700930540d-02,
     |  -3.1425340180192d-02,-3.7568841602838d-02,-2.7241610377100d-02,
     |  -4.8051739418257d-03, 1.9864094528814d-02, 3.5765359032091d-02,
     |   3.5765359032091d-02, 1.9864094528814d-02,-4.8051739418257d-03,
     |  -2.7241610377100d-02,-3.7568841602838d-02,-3.1425340180192d-02,
     |  -1.1758700930540d-02, 1.2703476052006d-02, 3.1473280467598d-02,
     |   3.6884970235233d-02, 2.7176969080989d-02, 6.8351723286484d-03,
     |  -1.5715963067225d-02,-3.1826027642512d-02,-3.6010192699797d-02,
     |  -2.7647424458313d-02,-1.0529120057107d-02, 9.2150355655609d-03,
     |   2.5694377809659d-02, 3.5218989973542d-02, 3.7013123915225d-02,
     |   3.2703701807009d-02, 2.5101845626172d-02, 1.6943606273401d-02,
     |   1.0078194006174d-02, 5.2564830190927d-03, 2.3772248016094d-03,
     |   9.1526165099310d-04, 2.9178652009811d-04, 7.3877211336668d-05,
     |   1.3928573445796d-05, 1.7606752675298d-06, 1.2386098398570d-07,
     |   3.3206319356228d-09, 1.2203483242642d-11, 2.0990915191802d-13/
      data (zmn(lat,11,18), lat = 1,72)/
     |  -1.7817804738423d-13, 7.3620716491351d-13, 2.5281236982486d-10,
     |   1.3325478997286d-08, 2.4639635925871d-07, 2.4183670193652d-06,
     |   1.5444066456589d-05, 7.1995430920152d-05, 2.6301678342051d-04,
     |   7.8883913388838d-04, 2.0047263071210d-03, 4.4126233624149d-03,
     |   8.5398083163621d-03, 1.4673596935279d-02, 2.2498800470378d-02,
     |   3.0787533731755d-02, 3.7360699791767d-02, 3.9508904958031d-02,
     |   3.4894401849988d-02, 2.2695541981153d-02, 4.5194347118721d-03,
     |  -1.5453663396254d-02,-3.1421591889372d-02,-3.7883916118950d-02,
     |  -3.1899178375211d-02,-1.4716351033888d-02, 8.0894189976731d-03,
     |   2.8306091806933d-02, 3.8127130687748d-02, 3.3373429745051d-02,
     |   1.5484199470235d-02,-8.7274917966220d-03,-2.9633773976828d-02,
     |  -3.8698151391308d-02,-3.2086388123492d-02,-1.2385019304526d-02,
     |   1.2385019304526d-02, 3.2086388123492d-02, 3.8698151391308d-02,
     |   2.9633773976828d-02, 8.7274917966220d-03,-1.5484199470235d-02,
     |  -3.3373429745051d-02,-3.8127130687748d-02,-2.8306091806933d-02,
     |  -8.0894189976732d-03, 1.4716351033888d-02, 3.1899178375211d-02,
     |   3.7883916118950d-02, 3.1421591889372d-02, 1.5453663396254d-02,
     |  -4.5194347118718d-03,-2.2695541981152d-02,-3.4894401849988d-02,
     |  -3.9508904958031d-02,-3.7360699791767d-02,-3.0787533731755d-02,
     |  -2.2498800470378d-02,-1.4673596935279d-02,-8.5398083163621d-03,
     |  -4.4126233624148d-03,-2.0047263071209d-03,-7.8883913388831d-04,
     |  -2.6301678342049d-04,-7.1995430920155d-05,-1.5444066456549d-05,
     |  -2.4183670193166d-06,-2.4639635927132d-07,-1.3325479018094d-08,
     |  -2.5281239006642d-10,-7.3617907353608d-13, 1.7817041862939d-13/
      data (zmn(lat,12,18), lat = 1,72)/
     |  -2.0274109400329d-15, 2.7801843423769d-14, 1.6780156770811d-11,
     |   1.2472518198428d-09, 2.9949715228933d-08, 3.6389778478345d-07,
     |   2.7900779293536d-06, 1.5295822670629d-05, 6.4781538533049d-05,
     |   2.2304321704534d-04, 6.4656781090051d-04, 1.6177088923199d-03,
     |   3.5560724926644d-03, 6.9553814117741d-03, 1.2209390745440d-02,
     |   1.9333102823164d-02, 2.7657690840541d-02, 3.5649393300610d-02,
     |   4.1026568467535d-02, 4.1283228233221d-02, 3.4566217446527d-02,
     |   2.0647232740579d-02, 1.5777940797512d-03,-1.8381215866869d-02,
     |  -3.3752555020452d-02,-3.9582704728845d-02,-3.3365199668178d-02,
     |  -1.6369646179943d-02, 6.2961298051939d-03, 2.7126993708168d-02,
     |   3.8782625014075d-02, 3.6852220679046d-02, 2.1708649469827d-02,
     |  -1.3834973892169d-03,-2.4071421617816d-02,-3.8002396482992d-02,
     |  -3.8002396482992d-02,-2.4071421617816d-02,-1.3834973892169d-03,
     |   2.1708649469827d-02, 3.6852220679046d-02, 3.8782625014075d-02,
     |   2.7126993708168d-02, 6.2961298051941d-03,-1.6369646179943d-02,
     |  -3.3365199668178d-02,-3.9582704728845d-02,-3.3752555020452d-02,
     |  -1.8381215866869d-02, 1.5777940797513d-03, 2.0647232740579d-02,
     |   3.4566217446527d-02, 4.1283228233221d-02, 4.1026568467535d-02,
     |   3.5649393300610d-02, 2.7657690840541d-02, 1.9333102823164d-02,
     |   1.2209390745440d-02, 6.9553814117742d-03, 3.5560724926644d-03,
     |   1.6177088923199d-03, 6.4656781090056d-04, 2.2304321704535d-04,
     |   6.4781538532996d-05, 1.5295822670628d-05, 2.7900779293158d-06,
     |   3.6389778477659d-07, 2.9949715276457d-08, 1.2472517912171d-09,
     |   1.6780247269914d-11, 2.7772878870974d-14,-1.9944713915517d-15/
      data (zmn(lat,13,18), lat = 1,72)/
     |   1.7587428650701d-15,-9.2637716413512d-16, 9.6823025639401d-13,
     |   1.0122428222222d-10, 3.1524982618582d-09, 4.7337169608270d-08,
     |   4.3480748043984d-07, 2.7956850205830d-06, 1.3680379399644d-05,
     |   5.3844230882987d-05, 1.7710509734227d-04, 5.0033554063878d-04,
     |   1.2385702947056d-03, 2.7266473693738d-03, 5.3964375577694d-03,
     |   9.6766106813019d-03, 1.5800733381649d-02, 2.3552830600478d-02,
     |   3.2036349942716d-02, 3.9595924892053d-02, 4.4017811340255d-02,
     |   4.3061833986284d-02, 3.5242534224243d-02, 2.0625491941788d-02,
     |   1.3086900720570d-03,-1.8713677042606d-02,-3.4430671921658d-02,
     |  -4.1279228201409d-02,-3.6751281977499d-02,-2.1547139304609d-02,
     |   2.4737777402377d-04, 2.2173195620689d-02, 3.7367512172641d-02,
     |   4.0852445070388d-02, 3.1317265332424d-02, 1.1700593122348d-02,
     |  -1.1700593122348d-02,-3.1317265332424d-02,-4.0852445070388d-02,
     |  -3.7367512172641d-02,-2.2173195620689d-02,-2.4737777402369d-04,
     |   2.1547139304609d-02, 3.6751281977499d-02, 4.1279228201409d-02,
     |   3.4430671921658d-02, 1.8713677042606d-02,-1.3086900720569d-03,
     |  -2.0625491941788d-02,-3.5242534224243d-02,-4.3061833986284d-02,
     |  -4.4017811340255d-02,-3.9595924892053d-02,-3.2036349942716d-02,
     |  -2.3552830600478d-02,-1.5800733381649d-02,-9.6766106813019d-03,
     |  -5.3964375577694d-03,-2.7266473693738d-03,-1.2385702947057d-03,
     |  -5.0033554063878d-04,-1.7710509734225d-04,-5.3844230883006d-05,
     |  -1.3680379399683d-05,-2.7956850205628d-06,-4.3480748049550d-07,
     |  -4.7337169652055d-08,-3.1524983147794d-09,-1.0122430070821d-10,
     |  -9.6821737751341d-13, 8.9166707682454d-16,-1.7142193362758d-15/
      data (zmn(lat,14,18), lat = 1,72)/
     |  -1.1417830567159d-16,-1.1642449011772d-16, 4.7926353889073d-14,
     |   7.0646862258500d-12, 2.8506166761849d-10, 5.2828433293831d-09,
     |   5.8034839102915d-08, 4.3672447275311d-07, 2.4628273513013d-06,
     |   1.1046190305555d-05, 4.1067281538693d-05, 1.3037794538872d-04,
     |   3.6131036460431d-04, 8.8858933750757d-04, 1.9638714472599d-03,
     |   3.9377166592856d-03, 7.2138473133675d-03, 1.2135311690100d-02,
     |   1.8803193058248d-02, 2.6864646072770d-02, 3.5347021763735d-02,
     |   4.2638539738040d-02, 4.6701922042219d-02, 4.5544594222924d-02,
     |   3.7867543628772d-02, 2.3708658852532d-02, 4.8338846228998d-03,
     |  -1.5346197719550d-02,-3.2431341045171d-02,-4.2157410271280d-02,
     |  -4.1690727889699d-02,-3.0668060301843d-02,-1.1584201015917d-02,
     |   1.0688041448006d-02, 3.0172802261042d-02, 4.1498695613592d-02,
     |   4.1498695613592d-02, 3.0172802261042d-02, 1.0688041448007d-02,
     |  -1.1584201015917d-02,-3.0668060301843d-02,-4.1690727889699d-02,
     |  -4.2157410271280d-02,-3.2431341045171d-02,-1.5346197719550d-02,
     |   4.8338846228997d-03, 2.3708658852532d-02, 3.7867543628772d-02,
     |   4.5544594222924d-02, 4.6701922042219d-02, 4.2638539738040d-02,
     |   3.5347021763735d-02, 2.6864646072770d-02, 1.8803193058248d-02,
     |   1.2135311690100d-02, 7.2138473133675d-03, 3.9377166592856d-03,
     |   1.9638714472599d-03, 8.8858933750755d-04, 3.6131036460434d-04,
     |   1.3037794538875d-04, 4.1067281538660d-05, 1.1046190305592d-05,
     |   2.4628273513893d-06, 4.3672447275482d-07, 5.8034839099527d-08,
     |   5.2828433050692d-09, 2.8506154754802d-10, 7.0647022147140d-12,
     |   4.7846442012143d-14,-1.1141044905965d-16,-1.3129631681271d-16/
      data (zmn(lat,15,18), lat = 1,72)/
     |  -4.0962970155541d-17,-7.1231289040927d-17, 1.8696220114505d-15,
     |   4.1732118349870d-13, 2.1807040643926d-11, 4.9824973848361d-10,
     |   6.5375235278300d-09, 5.7483708081219d-08, 3.7283675032917d-07,
     |   1.9010085693336d-06, 7.9650867089685d-06, 2.8316652487015d-05,
     |   8.7472002207914d-05, 2.3906411715566d-04, 5.8616993682704d-04,
     |   1.3034667257540d-03, 2.6509966435543d-03, 4.9634392179913d-03,
     |   8.5970535551487d-03, 1.3823272464869d-02, 2.0675672540518d-02,
     |   2.8783260023449d-02, 3.7249104771490d-02, 4.4646196078059d-02,
     |   4.9189290179729d-02, 4.9097056894196d-02, 4.3090509489484d-02,
     |   3.0902861462636d-02, 1.3632042165840d-02,-6.2237338384388d-03,
     |  -2.5134679568265d-02,-3.9278741812282d-02,-4.5485552330013d-02,
     |  -4.2124375859424d-02,-2.9659517766224d-02,-1.0675135014309d-02,
     |   1.0675135014309d-02, 2.9659517766224d-02, 4.2124375859424d-02,
     |   4.5485552330014d-02, 3.9278741812282d-02, 2.5134679568265d-02,
     |   6.2237338384389d-03,-1.3632042165840d-02,-3.0902861462636d-02,
     |  -4.3090509489484d-02,-4.9097056894196d-02,-4.9189290179729d-02,
     |  -4.4646196078059d-02,-3.7249104771490d-02,-2.8783260023449d-02,
     |  -2.0675672540518d-02,-1.3823272464869d-02,-8.5970535551487d-03,
     |  -4.9634392179913d-03,-2.6509966435543d-03,-1.3034667257540d-03,
     |  -5.8616993682700d-04,-2.3906411715565d-04,-8.7472002207873d-05,
     |  -2.8316652487003d-05,-7.9650867089347d-06,-1.9010085693196d-06,
     |  -3.7283675030703d-07,-5.7483708104088d-08,-6.5375235279839d-09,
     |  -4.9824975796515d-10,-2.1807045162713d-11,-4.1737410002382d-13,
     |  -1.9068144301406d-15, 5.8358681146481d-17, 1.1107642009114d-17/
      data (zmn(lat,16,18), lat = 1,72)/
     |  -1.3201237882081d-16,-1.2926132039314d-16,-4.2359246231694d-17,
     |   2.0206610441858d-14, 1.3724433506133d-12, 3.8628426935604d-11,
     |   6.0471206030131d-10, 6.2046726246930d-09, 4.6211312623696d-08,
     |   2.6734519463643d-07, 1.2595467789420d-06, 5.0007111487188d-06,
     |   1.7163405795838d-05, 5.1926092608896d-05, 1.4058932172619d-04,
     |   3.4473534875886d-04, 7.7287688540391d-04, 1.5963328001628d-03,
     |   3.0560320049594d-03, 5.4487079761264d-03, 9.0809486359333d-03,
     |   1.4185176232039d-02, 2.0803737431647d-02, 2.8663955078567d-02,
     |   3.7083016424729d-02, 4.4949521966889d-02, 5.0821424986054d-02,
     |   5.3154917883118d-02, 5.0639252806720d-02, 4.2569431049120d-02,
     |   2.9157616065248d-02, 1.1679618196747d-02,-7.6176551772855d-03,
     |  -2.5862389573275d-02,-4.0098869507642d-02,-4.7900534194047d-02,
     |  -4.7900534194047d-02,-4.0098869507642d-02,-2.5862389573275d-02,
     |  -7.6176551772856d-03, 1.1679618196747d-02, 2.9157616065248d-02,
     |   4.2569431049120d-02, 5.0639252806720d-02, 5.3154917883118d-02,
     |   5.0821424986054d-02, 4.4949521966889d-02, 3.7083016424729d-02,
     |   2.8663955078567d-02, 2.0803737431646d-02, 1.4185176232039d-02,
     |   9.0809486359334d-03, 5.4487079761265d-03, 3.0560320049594d-03,
     |   1.5963328001628d-03, 7.7287688540388d-04, 3.4473534875889d-04,
     |   1.4058932172619d-04, 5.1926092608901d-05, 1.7163405795832d-05,
     |   5.0007111487232d-06, 1.2595467789966d-06, 2.6734519464875d-07,
     |   4.6211312585354d-08, 6.2046726432213d-09, 6.0471206424970d-10,
     |   3.8628449251163d-11, 1.3724648666078d-12, 2.0225416455699d-14,
     |  -2.2850659884237d-17,-1.1128179678942d-16,-1.1485564925555d-16/
      data (zmn(lat,17,18), lat = 1,72)/
     |  -2.0741516228869d-17,-5.7878130447269d-17,-9.0950962085947d-17,
     |   6.5878283289077d-16, 6.7139649791504d-14, 2.3299769341525d-12,
     |   4.3481350006672d-11, 5.2004929608350d-10, 4.4418979158037d-09,
     |   2.9112913175287d-08, 1.5394903200589d-07, 6.8113661480024d-07,
     |   2.5909493698274d-06, 8.6514507330472d-06, 2.5774190916532d-05,
     |   6.9399075593154d-05, 1.7064949698537d-04, 3.8645960601849d-04,
     |   8.1161635865316d-04, 1.5896813300513d-03, 2.9174766747783d-03,
     |   5.0361402658617d-03, 8.2019092985362d-03, 1.2632897067564d-02,
     |   1.8434558749838d-02, 2.5515366074180d-02, 3.3513012186962d-02,
     |   4.1756810750984d-02, 4.9290492044101d-02, 5.4969528895583d-02,
     |   5.7629401361887d-02, 5.6299917307688d-02, 5.0422218141932d-02,
     |   4.0016108986793d-02, 2.5750417005301d-02, 8.8886033107810d-03,
     |  -8.8886033107810d-03,-2.5750417005301d-02,-4.0016108986793d-02,
     |  -5.0422218141932d-02,-5.6299917307688d-02,-5.7629401361887d-02,
     |  -5.4969528895583d-02,-4.9290492044101d-02,-4.1756810750984d-02,
     |  -3.3513012186962d-02,-2.5515366074180d-02,-1.8434558749838d-02,
     |  -1.2632897067564d-02,-8.2019092985362d-03,-5.0361402658618d-03,
     |  -2.9174766747783d-03,-1.5896813300513d-03,-8.1161635865318d-04,
     |  -3.8645960601851d-04,-1.7064949698540d-04,-6.9399075593158d-05,
     |  -2.5774190916559d-05,-8.6514507330698d-06,-2.5909493698684d-06,
     |  -6.8113661483469d-07,-1.5394903207493d-07,-2.9112913206840d-08,
     |  -4.4418979330384d-09,-5.2004931979659d-10,-4.3481370909784d-11,
     |  -2.3299772956488d-12,-6.7152564074746d-14,-6.4000511816357d-16,
     |   8.0199565815452d-17, 6.2688624254265d-17, 1.1322991022993d-17/
      data (zmn(lat,18,18), lat = 1,72)/
     |  -1.5688303823831d-16,-1.6140278448992d-16,-1.6184465558102d-16,
     |  -1.3115441823523d-16, 2.0937656556005d-15, 9.4914349894754d-14,
     |   2.1121887974638d-12, 2.9422097299511d-11, 2.8789322627328d-10,
     |   2.1349980397962d-09, 1.2653210164302d-08, 6.2280723884579d-08,
     |   2.6203777892020d-07, 9.6345242787507d-07, 3.1497364455065d-06,
     |   9.2831077985922d-06, 2.4942598713028d-05, 6.1659098259498d-05,
     |   1.4130425150260d-04, 3.0211402417550d-04, 6.0585009977496d-04,
     |   1.1447381122503d-03, 2.0458374535082d-03, 3.4697283428297d-03,
     |   5.6002939257659d-03, 8.6233406777932d-03, 1.2694018981408d-02,
     |   1.7896243451875d-02, 2.4200851198207d-02, 3.1431984989485d-02,
     |   3.9251987467657d-02, 4.7173132947393d-02, 5.4599735267614d-02,
     |   6.0897413811451d-02, 6.5479240540712d-02, 6.7893153763411d-02,
     |   6.7893153763411d-02, 6.5479240540712d-02, 6.0897413811451d-02,
     |   5.4599735267614d-02, 4.7173132947393d-02, 3.9251987467657d-02,
     |   3.1431984989485d-02, 2.4200851198207d-02, 1.7896243451875d-02,
     |   1.2694018981408d-02, 8.6233406777932d-03, 5.6002939257660d-03,
     |   3.4697283428297d-03, 2.0458374535082d-03, 1.1447381122502d-03,
     |   6.0585009977495d-04, 3.0211402417548d-04, 1.4130425150260d-04,
     |   6.1659098259494d-05, 2.4942598713053d-05, 9.2831077985888d-06,
     |   3.1497364455142d-06, 9.6345242787575d-07, 2.6203777892891d-07,
     |   6.2280723892380d-08, 1.2653210163591d-08, 2.1349980395310d-09,
     |   2.8789323864613d-10, 2.9422090498555d-11, 2.1121992296504d-12,
     |   9.4911357340722d-14, 2.0999437239079d-15,-1.4564296430542d-16,
     |  -1.5757440660009d-16,-1.4945595420666d-16,-1.4959161086002d-16/
      data (zmn(lat, 0,19), lat = 1,72)/
     |   3.4539358029782d-03, 8.2994920645095d-03, 2.9515974449044d-03,
     |  -7.2534157610482d-03,-1.5319725626917d-02,-1.2537686518946d-02,
     |   1.1058133838960d-04, 1.5080069670357d-02, 2.0634533361659d-02,
     |   1.1990488687273d-02,-6.4887014548742d-03,-2.1805306489082d-02,
     |  -2.2984759236897d-02,-7.7178776933258d-03, 1.3887213425241d-02,
     |   2.7169940367510d-02, 2.1934118679149d-02, 1.1782886053626d-03,
     |  -2.1501938546150d-02,-3.0013853465662d-02,-1.8065341113062d-02,
     |   6.9875391840274d-03, 2.7894232958791d-02, 3.0194635457035d-02,
     |   1.1556934844660d-02,-1.5417563180955d-02,-3.2438583679419d-02,
     |  -2.7334727120026d-02,-3.4212207390211d-03, 2.3295531438934d-02,
     |   3.4261895115302d-02, 2.1929935649671d-02,-5.6302268780274d-03,
     |  -2.9431955751718d-02,-3.3304820876819d-02,-1.4341941426934d-02,
     |   1.4341941426934d-02, 3.3304820876819d-02, 2.9431955751718d-02,
     |   5.6302268780274d-03,-2.1929935649671d-02,-3.4261895115302d-02,
     |  -2.3295531438934d-02, 3.4212207390209d-03, 2.7334727120026d-02,
     |   3.2438583679419d-02, 1.5417563180955d-02,-1.1556934844660d-02,
     |  -3.0194635457035d-02,-2.7894232958791d-02,-6.9875391840273d-03,
     |   1.8065341113062d-02, 3.0013853465661d-02, 2.1501938546150d-02,
     |  -1.1782886053626d-03,-2.1934118679148d-02,-2.7169940367510d-02,
     |  -1.3887213425241d-02, 7.7178776933258d-03, 2.2984759236897d-02,
     |   2.1805306489083d-02, 6.4887014548742d-03,-1.1990488687273d-02,
     |  -2.0634533361659d-02,-1.5080069670357d-02,-1.1058133838947d-04,
     |   1.2537686518946d-02, 1.5319725626917d-02, 7.2534157610482d-03,
     |  -2.9515974449044d-03,-8.2994920645095d-03,-3.4539358029783d-03/
      data (zmn(lat, 1,19), lat = 1,72)/
     |   1.0013259097420d-03, 6.4693431513576d-03, 1.1892633601252d-02,
     |   1.0196502214402d-02, 7.0589485571724d-05,-1.2633056413973d-02,
     |  -1.8436704363391d-02,-1.1704254059865d-02, 4.4425335878430d-03,
     |   1.9306939019902d-02, 2.1934930718422d-02, 9.2096544522362d-03,
     |  -1.1083631841726d-02,-2.5078451968673d-02,-2.2387220026393d-02,
     |  -3.8414459646095d-03, 1.8428934199002d-02, 2.8977555825134d-02,
     |   1.9845939256149d-02,-3.4675839224086d-03,-2.5283969976652d-02,
     |  -3.0367589236764d-02,-1.4614322783043d-02, 1.1696854094207d-02,
     |   3.0647704477583d-02, 2.8946213914416d-02, 7.2933234253566d-03,
     |  -1.9791932906193d-02,-3.3754131148929d-02,-2.4779326253124d-02,
     |   1.2846224360277d-03, 2.6749036387768d-02, 3.4149260554367d-02,
     |   1.8276596194674d-02,-1.0142130895077d-02,-3.1728967873059d-02,
     |  -3.1728967873059d-02,-1.0142130895077d-02, 1.8276596194674d-02,
     |   3.4149260554367d-02, 2.6749036387768d-02, 1.2846224360276d-03,
     |  -2.4779326253124d-02,-3.3754131148929d-02,-1.9791932906193d-02,
     |   7.2933234253564d-03, 2.8946213914416d-02, 3.0647704477583d-02,
     |   1.1696854094207d-02,-1.4614322783043d-02,-3.0367589236764d-02,
     |  -2.5283969976652d-02,-3.4675839224088d-03, 1.9845939256149d-02,
     |   2.8977555825134d-02, 1.8428934199002d-02,-3.8414459646094d-03,
     |  -2.2387220026393d-02,-2.5078451968673d-02,-1.1083631841726d-02,
     |   9.2096544522363d-03, 2.1934930718422d-02, 1.9306939019902d-02,
     |   4.4425335878430d-03,-1.1704254059865d-02,-1.8436704363391d-02,
     |  -1.2633056413973d-02, 7.0589485571593d-05, 1.0196502214402d-02,
     |   1.1892633601252d-02, 6.4693431513577d-03, 1.0013259097420d-03/
      data (zmn(lat, 2,19), lat = 1,72)/
     |   1.0650513300846d-04, 2.2160036580476d-03, 7.9805681279433d-03,
     |   1.4252482014591d-02, 1.5267991097536d-02, 7.3656426636676d-03,
     |  -6.7074253934479d-03,-1.8588671258754d-02,-1.9583164107646d-02,
     |  -7.4460998003512d-03, 1.1024640890254d-02, 2.3641982153381d-02,
     |   2.1118153278745d-02, 3.9225344950071d-03,-1.7107196263724d-02,
     |  -2.7693970985861d-02,-1.9868449019258d-02, 1.9687891951872d-03,
     |   2.3478324291389d-02, 2.9813726740524d-02, 1.5993401106642d-02,
     |  -9.2653862592428d-03,-2.9002643315381d-02,-2.9514891840626d-02,
     |  -9.8864822333685d-03, 1.6954717056162d-02, 3.2826972943460d-02,
     |   2.6642141699472d-02, 2.2250710467433d-03,-2.4073894651581d-02,
     |  -3.4345931104123d-02,-2.1414935742418d-02, 6.1603817483657d-03,
     |   2.9740880305332d-02, 3.3299265506060d-02, 1.4333731021967d-02,
     |  -1.4333731021967d-02,-3.3299265506060d-02,-2.9740880305332d-02,
     |  -6.1603817483657d-03, 2.1414935742418d-02, 3.4345931104123d-02,
     |   2.4073894651581d-02,-2.2250710467431d-03,-2.6642141699472d-02,
     |  -3.2826972943460d-02,-1.6954717056162d-02, 9.8864822333682d-03,
     |   2.9514891840626d-02, 2.9002643315381d-02, 9.2653862592428d-03,
     |  -1.5993401106642d-02,-2.9813726740524d-02,-2.3478324291389d-02,
     |  -1.9687891951873d-03, 1.9868449019258d-02, 2.7693970985861d-02,
     |   1.7107196263724d-02,-3.9225344950072d-03,-2.1118153278745d-02,
     |  -2.3641982153381d-02,-1.1024640890254d-02, 7.4460998003511d-03,
     |   1.9583164107646d-02, 1.8588671258754d-02, 6.7074253934478d-03,
     |  -7.3656426636676d-03,-1.5267991097536d-02,-1.4252482014591d-02,
     |  -7.9805681279434d-03,-2.2160036580476d-03,-1.0650513300844d-04/
      data (zmn(lat, 3,19), lat = 1,72)/
     |   2.9082998958879d-06, 4.8918165925105d-04, 3.1160203605980d-03,
     |   8.9020156627391d-03, 1.5805151445383d-02, 1.8926354534946d-02,
     |   1.3775317662752d-02, 4.4029334943978d-04,-1.4882032774573d-02,
     |  -2.2910086814619d-02,-1.7427962484418d-02,-3.4549602542596d-04,
     |   1.8340944719728d-02, 2.6426427436786d-02, 1.7680894005145d-02,
     |  -3.2751116652618d-03,-2.3213200260943d-02,-2.8706721899306d-02,
     |  -1.5303041348095d-02, 8.8939746234737d-03, 2.8073766519447d-02,
     |   2.9124383206868d-02, 1.0684020475875d-02,-1.5463669695693d-02,
     |  -3.1933014874389d-02,-2.7371217548388d-02,-4.3446513686786d-03,
     |   2.2040418316474d-02, 3.4090379027291d-02, 2.3460142470247d-02,
     |  -3.0297976632696d-03,-2.7772753383050d-02,-3.4135275710511d-02,
     |  -1.7700377930311d-02, 1.0647650367027d-02, 3.1962880619637d-02,
     |   3.1962880619637d-02, 1.0647650367027d-02,-1.7700377930311d-02,
     |  -3.4135275710511d-02,-2.7772753383050d-02,-3.0297976632696d-03,
     |   2.3460142470247d-02, 3.4090379027291d-02, 2.2040418316474d-02,
     |  -4.3446513686785d-03,-2.7371217548388d-02,-3.1933014874389d-02,
     |  -1.5463669695693d-02, 1.0684020475875d-02, 2.9124383206868d-02,
     |   2.8073766519448d-02, 8.8939746234738d-03,-1.5303041348095d-02,
     |  -2.8706721899306d-02,-2.3213200260944d-02,-3.2751116652619d-03,
     |   1.7680894005145d-02, 2.6426427436786d-02, 1.8340944719728d-02,
     |  -3.4549602542606d-04,-1.7427962484418d-02,-2.2910086814619d-02,
     |  -1.4882032774573d-02, 4.4029334943971d-04, 1.3775317662752d-02,
     |   1.8926354534946d-02, 1.5805151445383d-02, 8.9020156627391d-03,
     |   3.1160203605980d-03, 4.8918165925105d-04, 2.9082998959140d-06/
      data (zmn(lat, 4,19), lat = 1,72)/
     |   1.5683405411640d-07, 7.8405507640991d-05, 8.6686288830854d-04,
     |   3.7122313295883d-03, 9.4675712015537d-03, 1.6760028572878d-02,
     |   2.1548908470561d-02, 1.9140812715608d-02, 7.7766434039589d-03,
     |  -8.7821314847737d-03,-2.2164382871532d-02,-2.4033892348463d-02,
     |  -1.1833343546624d-02, 8.4131323719610d-03, 2.4790602227497d-02,
     |   2.6640201022699d-02, 1.1753009487566d-02,-1.1366069208410d-02,
     |  -2.8248901603931d-02,-2.7618142981630d-02,-9.0741745794519d-03,
     |   1.6018033759906d-02, 3.1472674099564d-02, 2.6817930390786d-02,
     |   4.4889286484073d-03,-2.1315765876878d-02,-3.3689856094359d-02,
     |  -2.4179214790560d-02, 1.3778119784458d-03, 2.6406594531704d-02,
     |   3.4394386935853d-02, 1.9859485698556d-02,-7.8522235478918d-03,
     |  -3.0590107573165d-02,-3.3349911720405d-02,-1.4233409141133d-02,
     |   1.4233409141133d-02, 3.3349911720405d-02, 3.0590107573165d-02,
     |   7.8522235478918d-03,-1.9859485698556d-02,-3.4394386935853d-02,
     |  -2.6406594531704d-02,-1.3778119784460d-03, 2.4179214790560d-02,
     |   3.3689856094359d-02, 2.1315765876878d-02,-4.4889286484070d-03,
     |  -2.6817930390786d-02,-3.1472674099564d-02,-1.6018033759906d-02,
     |   9.0741745794517d-03, 2.7618142981630d-02, 2.8248901603931d-02,
     |   1.1366069208411d-02,-1.1753009487566d-02,-2.6640201022699d-02,
     |  -2.4790602227497d-02,-8.4131323719610d-03, 1.1833343546624d-02,
     |   2.4033892348463d-02, 2.2164382871532d-02, 8.7821314847739d-03,
     |  -7.7766434039588d-03,-1.9140812715608d-02,-2.1548908470560d-02,
     |  -1.6760028572878d-02,-9.4675712015538d-03,-3.7122313295884d-03,
     |  -8.6686288830853d-04,-7.8405507640945d-05,-1.5683405407465d-07/
      data (zmn(lat, 5,19), lat = 1,72)/
     |   9.0122711814250d-08, 9.7906105185056d-06, 1.8691767621631d-04,
     |   1.1689762293871d-03, 4.0887292312458d-03, 9.7435170492621d-03,
     |   1.7244492207968d-02, 2.3329694839705d-02, 2.3478210866837d-02,
     |   1.4747828406363d-02,-1.3299006755545d-03,-1.8121761272619d-02,
     |  -2.6765849969665d-02,-2.1409549251826d-02,-3.6206726141536d-03,
     |   1.7306700565258d-02, 2.9120376725284d-02, 2.4017772941581d-02,
     |   4.0700469109132d-03,-1.9204496747631d-02,-3.1454679317423d-02,
     |  -2.4494121222379d-02,-1.9353192345084d-03, 2.2496062513358d-02,
     |   3.3324246536335d-02, 2.3241518700178d-02,-1.8576414189838d-03,
     |  -2.6248527401064d-02,-3.4269878351777d-02,-2.0474114002898d-02,
     |   6.6118809270189d-03, 2.9745235545739d-02, 3.4002893493906d-02,
     |   1.6483415979236d-02,-1.1686950701207d-02,-3.2447021878088d-02,
     |  -3.2447021878089d-02,-1.1686950701208d-02, 1.6483415979236d-02,
     |   3.4002893493906d-02, 2.9745235545739d-02, 6.6118809270189d-03,
     |  -2.0474114002898d-02,-3.4269878351777d-02,-2.6248527401064d-02,
     |  -1.8576414189839d-03, 2.3241518700178d-02, 3.3324246536335d-02,
     |   2.2496062513358d-02,-1.9353192345084d-03,-2.4494121222379d-02,
     |  -3.1454679317423d-02,-1.9204496747631d-02, 4.0700469109132d-03,
     |   2.4017772941581d-02, 2.9120376725285d-02, 1.7306700565258d-02,
     |  -3.6206726141536d-03,-2.1409549251826d-02,-2.6765849969665d-02,
     |  -1.8121761272619d-02,-1.3299006755545d-03, 1.4747828406363d-02,
     |   2.3478210866837d-02, 2.3329694839705d-02, 1.7244492207968d-02,
     |   9.7435170492622d-03, 4.0887292312458d-03, 1.1689762293871d-03,
     |   1.8691767621627d-04, 9.7906105185078d-06, 9.0122711792703d-08/
      data (zmn(lat, 6,19), lat = 1,72)/
     |   3.0208166477526d-09, 1.0093656988270d-06, 3.2717887487189d-05,
     |   2.9508078670922d-04, 1.3852410241296d-03, 4.2862826383145d-03,
     |   9.7693044381417d-03, 1.7323973036919d-02, 2.4384245054447d-02,
     |   2.6822402304473d-02, 2.1037200930259d-02, 6.7187707201241d-03,
     |  -1.1576006859497d-02,-2.5659378122362d-02,-2.7781793338550d-02,
     |  -1.5491740244516d-02, 5.8292517362470d-03, 2.4938153808954d-02,
     |   3.0732171901944d-02, 1.9007598866220d-02,-4.2912108833372d-03,
     |  -2.5845130330938d-02,-3.2610382832238d-02,-1.9901555890734d-02,
     |   5.2196490461971d-03, 2.7744584020868d-02, 3.3730792565863d-02,
     |   1.9066112315858d-02,-7.6155335849977d-03,-2.9970976840521d-02,
     |  -3.4017507893902d-02,-1.6978542476771d-02, 1.0761010954026d-02,
     |   3.1989011139708d-02, 3.3413493078148d-02, 1.4056916122976d-02,
     |  -1.4056916122975d-02,-3.3413493078148d-02,-3.1989011139708d-02,
     |  -1.0761010954026d-02, 1.6978542476771d-02, 3.4017507893902d-02,
     |   2.9970976840521d-02, 7.6155335849979d-03,-1.9066112315858d-02,
     |  -3.3730792565863d-02,-2.7744584020868d-02,-5.2196490461974d-03,
     |   1.9901555890734d-02, 3.2610382832238d-02, 2.5845130330937d-02,
     |   4.2912108833375d-03,-1.9007598866220d-02,-3.0732171901944d-02,
     |  -2.4938153808954d-02,-5.8292517362471d-03, 1.5491740244516d-02,
     |   2.7781793338550d-02, 2.5659378122362d-02, 1.1576006859498d-02,
     |  -6.7187707201241d-03,-2.1037200930259d-02,-2.6822402304474d-02,
     |  -2.4384245054447d-02,-1.7323973036919d-02,-9.7693044381417d-03,
     |  -4.2862826383146d-03,-1.3852410241296d-03,-2.9508078670925d-04,
     |  -3.2717887487232d-05,-1.0093656988870d-06,-3.0208166697210d-09/
      data (zmn(lat, 7,19), lat = 1,72)/
     |  -1.3455035384369d-09, 8.8866179495081d-08, 4.7881603552808d-06,
     |   6.1817730711633d-05, 3.8487295727470d-04, 1.5183531872116d-03,
     |   4.3290531175374d-03, 9.5708926940940d-03, 1.7036415060098d-02,
     |   2.4781152731995d-02, 2.9197572814955d-02, 2.6434236884840d-02,
     |   1.4785231535421d-02,-3.2792178933678d-03,-2.1046676575128d-02,
     |  -3.0210126589096d-02,-2.5294216448342d-02,-7.4367270756249d-03,
     |   1.5060952740140d-02, 3.0422662098388d-02, 2.9760189987015d-02,
     |   1.2555923492287d-02,-1.2252976203670d-02,-3.0774457611446d-02,
     |  -3.2041531851166d-02,-1.4719984598220d-02, 1.1577847476592d-02,
     |   3.1549899729452d-02, 3.3185566327856d-02, 1.5132448580421d-02,
     |  -1.2161439250872d-02,-3.2473025309392d-02,-3.3520155026872d-02,
     |  -1.4486772822877d-02, 1.3322069056057d-02, 3.3218183410563d-02,
     |   3.3218183410563d-02, 1.3322069056058d-02,-1.4486772822877d-02,
     |  -3.3520155026872d-02,-3.2473025309392d-02,-1.2161439250872d-02,
     |   1.5132448580421d-02, 3.3185566327856d-02, 3.1549899729452d-02,
     |   1.1577847476592d-02,-1.4719984598220d-02,-3.2041531851166d-02,
     |  -3.0774457611446d-02,-1.2252976203670d-02, 1.2555923492287d-02,
     |   2.9760189987014d-02, 3.0422662098388d-02, 1.5060952740140d-02,
     |  -7.4367270756248d-03,-2.5294216448342d-02,-3.0210126589096d-02,
     |  -2.1046676575128d-02,-3.2792178933678d-03, 1.4785231535420d-02,
     |   2.6434236884840d-02, 2.9197572814955d-02, 2.4781152731995d-02,
     |   1.7036415060098d-02, 9.5708926940940d-03, 4.3290531175374d-03,
     |   1.5183531872115d-03, 3.8487295727465d-04, 6.1817730711677d-05,
     |   4.7881603553096d-06, 8.8866179498956d-08,-1.3455035471656d-09/
      data (zmn(lat, 8,19), lat = 1,72)/
     |  -3.2507776393929d-11, 6.5813908405138d-09, 5.9768206278001d-07,
     |   1.0987861285439d-05, 9.0065253212364d-05, 4.4819615840695d-04,
     |   1.5736617971990d-03, 4.2350965655825d-03, 9.1682291959469d-03,
     |   1.6408246438413d-02, 2.4562850094044d-02, 3.0613465572998d-02,
     |   3.0774257782949d-02, 2.2390785636234d-02, 6.0503033207030d-03,
     |  -1.3453465528803d-02,-2.8386934614378d-02,-3.1513416592826d-02,
     |  -2.0175328810712d-02, 1.3371633567354d-03, 2.2960225844894d-02,
     |   3.3558127282254d-02, 2.6939674476123d-02, 5.8024466440759d-03,
     |  -1.9003459213859d-02,-3.3983627580999d-02,-3.0489544823318d-02,
     |  -9.9310578656093d-03, 1.6539980451161d-02, 3.4042198647111d-02,
     |   3.2430105576373d-02, 1.2317593129564d-02,-1.5003788519609d-02,
     |  -3.3906814976151d-02,-3.3448618466800d-02,-1.3793652878367d-02,
     |   1.3793652878367d-02, 3.3448618466800d-02, 3.3906814976151d-02,
     |   1.5003788519609d-02,-1.2317593129564d-02,-3.2430105576373d-02,
     |  -3.4042198647111d-02,-1.6539980451161d-02, 9.9310578656091d-03,
     |   3.0489544823318d-02, 3.3983627580999d-02, 1.9003459213859d-02,
     |  -5.8024466440758d-03,-2.6939674476123d-02,-3.3558127282254d-02,
     |  -2.2960225844894d-02,-1.3371633567356d-03, 2.0175328810712d-02,
     |   3.1513416592826d-02, 2.8386934614379d-02, 1.3453465528803d-02,
     |  -6.0503033207031d-03,-2.2390785636234d-02,-3.0774257782949d-02,
     |  -3.0613465572998d-02,-2.4562850094044d-02,-1.6408246438413d-02,
     |  -9.1682291959470d-03,-4.2350965655825d-03,-1.5736617971989d-03,
     |  -4.4819615840687d-04,-9.0065253212345d-05,-1.0987861285361d-05,
     |  -5.9768206272195d-07,-6.5813908153258d-09, 3.2507748014118d-11/
      data (zmn(lat, 9,19), lat = 1,72)/
     |   2.1770972941362d-11, 3.9947116822020d-10, 6.4470286132545d-08,
     |   1.6814509616040d-06, 1.8057306249560d-05, 1.1257407370605d-04,
     |   4.8210272532145d-04, 1.5580123733685d-03, 4.0206160420303d-03,
     |   8.5805748557613d-03, 1.5463322758915d-02, 2.3760746309325d-02,
     |   3.1071143109200d-02, 3.3914028412269d-02, 2.9109254277960d-02,
     |   1.5702602096487d-02,-3.5675145952525d-03,-2.2384616411819d-02,
     |  -3.3055174607908d-02,-3.0133760193619d-02,-1.3723300623715d-02,
     |   9.5548403936269d-03, 2.8977998609082d-02, 3.4773725966456d-02,
     |   2.3358333974559d-02,-1.8132297271494d-04,-2.4105669765237d-02,
     |  -3.5879908017329d-02,-2.8917902261802d-02,-6.4744272815733d-03,
     |   1.9708082723693d-02, 3.5539540321232d-02, 3.2274428856950d-02,
     |   1.1472839038737d-02,-1.5662437097475d-02,-3.4344467510327d-02,
     |  -3.4344467510327d-02,-1.5662437097475d-02, 1.1472839038737d-02,
     |   3.2274428856950d-02, 3.5539540321232d-02, 1.9708082723693d-02,
     |  -6.4744272815732d-03,-2.8917902261802d-02,-3.5879908017329d-02,
     |  -2.4105669765237d-02,-1.8132297271493d-04, 2.3358333974558d-02,
     |   3.4773725966456d-02, 2.8977998609082d-02, 9.5548403936269d-03,
     |  -1.3723300623715d-02,-3.0133760193619d-02,-3.3055174607908d-02,
     |  -2.2384616411819d-02,-3.5675145952525d-03, 1.5702602096487d-02,
     |   2.9109254277960d-02, 3.3914028412269d-02, 3.1071143109200d-02,
     |   2.3760746309325d-02, 1.5463322758915d-02, 8.5805748557614d-03,
     |   4.0206160420304d-03, 1.5580123733686d-03, 4.8210272532144d-04,
     |   1.1257407370608d-04, 1.8057306249635d-05, 1.6814509615189d-06,
     |   6.4470286114812d-08, 3.9947118957335d-10, 2.1770971362481d-11/
      data (zmn(lat,10,19), lat = 1,72)/
     |   3.9900268353139d-13, 2.2369666972226d-11, 6.0567254627598d-09,
     |   2.2364840078667d-07, 3.1359267780762d-06, 2.4377382265360d-05,
     |   1.2652819066443d-04, 4.8680404918719d-04, 1.4798052593097d-03,
     |   3.7025151124306d-03, 7.8300548325278d-03, 1.4229405710070d-02,
     |   2.2407139239901d-02, 3.0573623901551d-02, 3.5727526384644d-02,
     |   3.4544875007701d-02, 2.4954816190529d-02, 7.7606590082389d-03,
     |  -1.2654973862809d-02,-2.9310856079649d-02,-3.5303935993338d-02,
     |  -2.7178698876564d-02,-7.2970765101712d-03, 1.6324096340218d-02,
     |   3.3129563113035d-02, 3.4927900308415d-02, 2.0210232962691d-02,
     |  -4.5135764749917d-03,-2.7421362149503d-02,-3.7077459509024d-02,
     |  -2.8324002061394d-02,-5.2219326029673d-03, 2.0713053703209d-02,
     |   3.6271349947719d-02, 3.3385971317029d-02, 1.3423175680339d-02,
     |  -1.3423175680339d-02,-3.3385971317029d-02,-3.6271349947719d-02,
     |  -2.0713053703209d-02, 5.2219326029672d-03, 2.8324002061394d-02,
     |   3.7077459509024d-02, 2.7421362149503d-02, 4.5135764749918d-03,
     |  -2.0210232962691d-02,-3.4927900308415d-02,-3.3129563113035d-02,
     |  -1.6324096340218d-02, 7.2970765101713d-03, 2.7178698876564d-02,
     |   3.5303935993338d-02, 2.9310856079649d-02, 1.2654973862809d-02,
     |  -7.7606590082388d-03,-2.4954816190529d-02,-3.4544875007701d-02,
     |  -3.5727526384644d-02,-3.0573623901551d-02,-2.2407139239901d-02,
     |  -1.4229405710070d-02,-7.8300548325278d-03,-3.7025151124306d-03,
     |  -1.4798052593097d-03,-4.8680404918721d-04,-1.2652819066449d-04,
     |  -2.4377382265400d-05,-3.1359267780512d-06,-2.2364840082064d-07,
     |  -6.0567255508839d-09,-2.2369692325523d-11,-3.9894961472830d-13/
      data (zmn(lat,11,19), lat = 1,72)/
     |  -3.0439594163954d-13, 1.4093006048935d-12, 4.9793420179519d-10,
     |   2.6002322438021d-08, 4.7484660205662d-07, 4.5871994990165d-06,
     |   2.8728507617434d-05, 1.3081897006896d-04, 4.6481161649187d-04,
     |   1.3492347437855d-03, 3.3000109047458d-03, 6.9441912009259d-03,
     |   1.2743310106019d-02, 2.0545568594238d-02, 2.9139522748080d-02,
     |   3.6115289753504d-02, 3.8332233455225d-02, 3.3066259388772d-02,
     |   1.9512269235071d-02,-5.7156239183406d-05,-2.0265046695201d-02,
     |  -3.4158291234943d-02,-3.5966661052172d-02,-2.3981795947823d-02,
     |  -2.0854889223657d-03, 2.1152954158763d-02, 3.5806392773549d-02,
     |   3.5048653166662d-02, 1.8640104252401d-02,-6.4440383259908d-03,
     |  -2.8860921948166d-02,-3.8096580975600d-02,-2.9568062298858d-02,
     |  -7.0551674781819d-03, 1.8895596678882d-02, 3.5950263101674d-02,
     |   3.5950263101674d-02, 1.8895596678882d-02,-7.0551674781818d-03,
     |  -2.9568062298858d-02,-3.8096580975600d-02,-2.8860921948166d-02,
     |  -6.4440383259909d-03, 1.8640104252401d-02, 3.5048653166662d-02,
     |   3.5806392773549d-02, 2.1152954158763d-02,-2.0854889223656d-03,
     |  -2.3981795947823d-02,-3.5966661052172d-02,-3.4158291234943d-02,
     |  -2.0265046695201d-02,-5.7156239183365d-05, 1.9512269235071d-02,
     |   3.3066259388772d-02, 3.8332233455225d-02, 3.6115289753504d-02,
     |   2.9139522748080d-02, 2.0545568594238d-02, 1.2743310106019d-02,
     |   6.9441912009260d-03, 3.3000109047458d-03, 1.3492347437855d-03,
     |   4.6481161649187d-04, 1.3081897006895d-04, 2.8728507617392d-05,
     |   4.5871994989628d-06, 4.7484660198100d-07, 2.6002322454642d-08,
     |   4.9793416844289d-10, 1.4092294437548d-12,-3.0438039721382d-13/
      data (zmn(lat,12,19), lat = 1,72)/
     |  -4.4305513477067d-15, 6.0452726325624d-14, 3.5937973079773d-11,
     |   2.6487449748297d-09, 6.2879772531223d-08, 7.5299150914414d-07,
     |   5.6716146752298d-06, 3.0439320813671d-05, 1.2573408419122d-04,
     |   4.2047146133621d-04, 1.1784210548485d-03, 2.8355297184535d-03,
     |   5.9575940026214d-03, 1.1054958181704d-02, 1.8240095794717d-02,
     |   2.6818717575965d-02, 3.5024114006382d-02, 4.0156906382511d-02,
     |   3.9298855299696d-02, 3.0513289828723d-02, 1.4115151903698d-02,
     |  -6.6305562575227d-03,-2.5959092580970d-02,-3.7362644652418d-02,
     |  -3.6166163729494d-02,-2.1871412569383d-02, 9.2241227823985d-04,
     |   2.3750198311573d-02, 3.7451266793166d-02, 3.6063145224909d-02,
     |   1.9687683302085d-02,-5.1376806658972d-03,-2.7969957029821d-02,
     |  -3.8925396673014d-02,-3.3105178057294d-02,-1.2910049175276d-02,
     |   1.2910049175276d-02, 3.3105178057294d-02, 3.8925396673014d-02,
     |   2.7969957029821d-02, 5.1376806658973d-03,-1.9687683302085d-02,
     |  -3.6063145224909d-02,-3.7451266793166d-02,-2.3750198311573d-02,
     |  -9.2241227823993d-04, 2.1871412569383d-02, 3.6166163729494d-02,
     |   3.7362644652418d-02, 2.5959092580970d-02, 6.6305562575227d-03,
     |  -1.4115151903697d-02,-3.0513289828723d-02,-3.9298855299696d-02,
     |  -4.0156906382511d-02,-3.5024114006382d-02,-2.6818717575965d-02,
     |  -1.8240095794717d-02,-1.1054958181704d-02,-5.9575940026215d-03,
     |  -2.8355297184537d-03,-1.1784210548485d-03,-4.2047146133621d-04,
     |  -1.2573408419116d-04,-3.0439320813641d-05,-5.6716146751279d-06,
     |  -7.5299150909111d-07,-6.2879772542627d-08,-2.6487449666859d-09,
     |  -3.5937910167386d-11,-6.0397630376974d-14, 4.4369912768546d-15/
      data (zmn(lat,13,19), lat = 1,72)/
     |   3.5309013358753d-15,-1.3944385940424d-15, 2.2766052215204d-12,
     |   2.3620271744807d-10, 7.2788171459089d-09, 1.0784295311497d-07,
     |   9.7452081492084d-07, 6.1452138843448d-06, 2.9394140410946d-05,
     |   1.1268322495571d-04, 3.5958747652566d-04, 9.8128199665029d-04,
     |   2.3349022694762d-03, 4.9126625933258d-03, 9.2300527396738d-03,
     |   1.5583078133516d-02, 2.3708726787082d-02, 3.2474570505603d-02,
     |   3.9795983907758d-02, 4.2970702458387d-02, 3.9489241245499d-02,
     |   2.8145542528768d-02, 1.0030052340381d-02,-1.1122565932636d-02,
     |  -2.9622713043464d-02,-3.9553056552451d-02,-3.7024951325485d-02,
     |  -2.2068028941347d-02, 7.7286291869745d-04, 2.3636288595172d-02,
     |   3.8092968257384d-02, 3.8446785761661d-02, 2.4208429450174d-02,
     |   5.8746067195360d-04,-2.3361574169713d-02,-3.8278896813115d-02,
     |  -3.8278896813115d-02,-2.3361574169713d-02, 5.8746067195352d-04,
     |   2.4208429450174d-02, 3.8446785761661d-02, 3.8092968257384d-02,
     |   2.3636288595172d-02, 7.7286291869762d-04,-2.2068028941347d-02,
     |  -3.7024951325485d-02,-3.9553056552451d-02,-2.9622713043464d-02,
     |  -1.1122565932636d-02, 1.0030052340381d-02, 2.8145542528768d-02,
     |   3.9489241245499d-02, 4.2970702458387d-02, 3.9795983907759d-02,
     |   3.2474570505604d-02, 2.3708726787082d-02, 1.5583078133516d-02,
     |   9.2300527396738d-03, 4.9126625933258d-03, 2.3349022694762d-03,
     |   9.8128199665022d-04, 3.5958747652566d-04, 1.1268322495579d-04,
     |   2.9394140410951d-05, 6.1452138843485d-06, 9.7452081495063d-07,
     |   1.0784295317554d-07, 7.2788171563980d-09, 2.3620269101287d-10,
     |   2.2766069454308d-12,-1.3689617464138d-15, 3.5358635447191d-15/
      data (zmn(lat,14,19), lat = 1,72)/
     |  -6.7145730147762d-17,-1.3807714741826d-16, 1.2555475206784d-13,
     |   1.8358366329449d-11, 7.3351530836107d-10, 1.3425785369251d-08,
     |   1.4527564941824d-07, 1.0737915722881d-06, 5.9301149354793d-06,
     |   2.5964595530579d-05, 9.3912189269730d-05, 2.8898222610042d-04,
     |   7.7304403510985d-04, 1.8267630120279d-03, 3.8589710768779d-03,
     |   7.3506721761668d-03, 1.2700169164509d-02, 1.9969396077625d-02,
     |   2.8592641372045d-02, 3.7175848415705d-02, 4.3547943960090d-02,
     |   4.5184579056749d-02, 3.9994226904571d-02, 2.7269086227358d-02,
     |   8.4388095292171d-03,-1.2777780026575d-02,-3.1083313005919d-02,
     |  -4.1118379426306d-02,-3.9349610118053d-02,-2.5628192816159d-02,
     |  -3.7171347208735d-03, 1.9595266027618d-02, 3.6634482387687d-02,
     |   4.1521178113298d-02, 3.2382472346537d-02, 1.2188220350437d-02,
     |  -1.2188220350437d-02,-3.2382472346537d-02,-4.1521178113298d-02,
     |  -3.6634482387687d-02,-1.9595266027618d-02, 3.7171347208736d-03,
     |   2.5628192816159d-02, 3.9349610118053d-02, 4.1118379426306d-02,
     |   3.1083313005919d-02, 1.2777780026575d-02,-8.4388095292170d-03,
     |  -2.7269086227358d-02,-3.9994226904571d-02,-4.5184579056749d-02,
     |  -4.3547943960090d-02,-3.7175848415705d-02,-2.8592641372045d-02,
     |  -1.9969396077625d-02,-1.2700169164509d-02,-7.3506721761668d-03,
     |  -3.8589710768780d-03,-1.8267630120279d-03,-7.7304403510982d-04,
     |  -2.8898222610034d-04,-9.3912189269761d-05,-2.5964595530527d-05,
     |  -5.9301149355215d-06,-1.0737915723109d-06,-1.4527564948319d-07,
     |  -1.3425785369641d-08,-7.3351532303490d-10,-1.8358380042847d-11,
     |  -1.2554516507687d-13, 5.8752139822751d-17, 3.6983491799364d-17/
      data (zmn(lat,15,19), lat = 1,72)/
     |  -6.7064421923586d-17,-6.4110551400250d-17, 5.8250384665807d-15,
     |   1.2322014556150d-12, 6.3781691973158d-11, 1.4404759492757d-09,
     |   1.8636136368266d-08, 1.6115766812022d-07, 1.0252181267813d-06,
     |   5.1125407181900d-06, 2.0887369115162d-05, 7.2171372117381d-05,
     |   2.1592003217291d-04, 5.6932909966786d-04, 1.3410286783469d-03,
     |   2.8509308279994d-03, 5.5128009393349d-03, 9.7504857386408d-03,
     |   1.5831910267988d-02, 2.3638954142274d-02, 3.2439772482373d-02,
     |   4.0773149297850d-02, 4.6563726754706d-02, 4.7538977437778d-02,
     |   4.1911555340962d-02, 2.9154205536458d-02, 1.0586545363891d-02,
     |  -1.0522535594735d-02,-2.9519112770006d-02,-4.1550351090610d-02,
     |  -4.3063836592629d-02,-3.3121957378471d-02,-1.4017235071175d-02,
     |   9.1313574921651d-03, 2.9770156322271d-02, 4.1882298653766d-02,
     |   4.1882298653766d-02, 2.9770156322271d-02, 9.1313574921652d-03,
     |  -1.4017235071175d-02,-3.3121957378471d-02,-4.3063836592629d-02,
     |  -4.1550351090610d-02,-2.9519112770006d-02,-1.0522535594735d-02,
     |   1.0586545363891d-02, 2.9154205536458d-02, 4.1911555340962d-02,
     |   4.7538977437778d-02, 4.6563726754706d-02, 4.0773149297850d-02,
     |   3.2439772482373d-02, 2.3638954142274d-02, 1.5831910267988d-02,
     |   9.7504857386409d-03, 5.5128009393349d-03, 2.8509308279994d-03,
     |   1.3410286783469d-03, 5.6932909966791d-04, 2.1592003217293d-04,
     |   7.2171372117405d-05, 2.0887369115138d-05, 5.1125407181767d-06,
     |   1.0252181267970d-06, 1.6115766812357d-07, 1.8636136349565d-08,
     |   1.4404759090392d-09, 6.3781757957792d-11, 1.2322277768014d-12,
     |   5.8800618970781d-15,-1.2098842154480d-16,-8.2024845216703d-17/
      data (zmn(lat,16,19), lat = 1,72)/
     |  -1.3618152360293d-17,-1.7955427386979d-17, 2.0644685074442d-16,
     |   7.0245206581581d-14, 4.7095529360238d-12, 1.3111413146243d-10,
     |   2.0256574386595d-09, 2.0463400989380d-08, 1.4968375559008d-07,
     |   8.4828738575542d-07, 3.9043335610261d-06, 1.5099860811801d-05,
     |   5.0328509085305d-05, 1.4737467739775d-04, 3.8481084314886d-04,
     |   9.0638959337299d-04, 1.9433809994385d-03, 3.8197286264502d-03,
     |   6.9193012183799d-03, 1.1596397952062d-02, 1.8024974762637d-02,
     |   2.6009492557300d-02, 3.4814076231520d-02, 4.3092336783441d-02,
     |   4.8999963286520d-02, 5.0533443072328d-02, 4.6062813651782d-02,
     |   3.4935158274073d-02, 1.7954836412811d-02,-2.4656475313790d-03,
     |  -2.2621745801134d-02,-3.8297490574936d-02,-4.5839389938590d-02,
     |  -4.3218529709468d-02,-3.0736452391788d-02,-1.1113668631929d-02,
     |   1.1113668631929d-02, 3.0736452391788d-02, 4.3218529709468d-02,
     |   4.5839389938590d-02, 3.8297490574936d-02, 2.2621745801134d-02,
     |   2.4656475313791d-03,-1.7954836412811d-02,-3.4935158274073d-02,
     |  -4.6062813651782d-02,-5.0533443072328d-02,-4.8999963286520d-02,
     |  -4.3092336783441d-02,-3.4814076231520d-02,-2.6009492557300d-02,
     |  -1.8024974762638d-02,-1.1596397952062d-02,-6.9193012183799d-03,
     |  -3.8197286264502d-03,-1.9433809994385d-03,-9.0638959337305d-04,
     |  -3.8481084314883d-04,-1.4737467739773d-04,-5.0328509085349d-05,
     |  -1.5099860811839d-05,-3.9043335610195d-06,-8.4828738584311d-07,
     |  -1.4968375562032d-07,-2.0463401004293d-08,-2.0256574709349d-09,
     |  -1.3111420749617d-10,-4.7094957013189d-12,-7.0208746441244d-14,
     |  -2.3223427725615d-16, 1.2107500584679d-16, 5.9228604162649d-17/
      data (zmn(lat,17,19), lat = 1,72)/
     |  -3.6465204669768d-17,-1.2043477860783d-16,-1.8255218195542d-16,
     |   3.0795748306549d-15, 2.8679994087924d-13, 9.8419845991093d-12,
     |   1.8140083300325d-10, 2.1381486343439d-09, 1.7956746576942d-08,
     |   1.1544637885659d-07, 5.9735392042562d-07, 2.5794074103648d-06,
     |   9.5495505670587d-06, 3.0944490052532d-05, 8.9185155060625d-05,
     |   2.3153173911751d-04, 5.4691446678258d-04, 1.1850302310099d-03,
     |   2.3705606437445d-03, 4.4006311586720d-03, 7.6111826158026d-03,
     |   1.2301020856699d-02, 1.8613316593023d-02, 2.6392752858250d-02,
     |   3.5057613094848d-02, 4.3541212156991d-02, 5.0356321590004d-02,
     |   5.3813048213199d-02, 5.2376245947822d-02, 4.5094223865426d-02,
     |   3.1985396854702d-02, 1.4254129624917d-02,-5.7655409615708d-03,
     |  -2.4970980383835d-02,-4.0098091703012d-02,-4.8431804469594d-02,
     |  -4.8431804469594d-02,-4.0098091703012d-02,-2.4970980383835d-02,
     |  -5.7655409615708d-03, 1.4254129624917d-02, 3.1985396854702d-02,
     |   4.5094223865426d-02, 5.2376245947822d-02, 5.3813048213199d-02,
     |   5.0356321590004d-02, 4.3541212156991d-02, 3.5057613094848d-02,
     |   2.6392752858250d-02, 1.8613316593023d-02, 1.2301020856699d-02,
     |   7.6111826158027d-03, 4.4006311586720d-03, 2.3705606437445d-03,
     |   1.1850302310099d-03, 5.4691446678262d-04, 2.3153173911751d-04,
     |   8.9185155060621d-05, 3.0944490052521d-05, 9.5495505670413d-06,
     |   2.5794074103571d-06, 5.9735392045495d-07, 1.1544637879396d-07,
     |   1.7956746535019d-08, 2.1381486252259d-09, 1.8140086625602d-10,
     |   9.8420263368046d-12, 2.8681530572107d-13, 3.0888707807494d-15,
     |  -2.0988416757063d-16,-4.6600003752491d-17,-2.5384880030743d-18/
      data (zmn(lat,18,19), lat = 1,72)/
     |  -2.2328457057715d-16,-2.2554502305564d-16,-2.1180607857620d-16,
     |  -7.7140757616328d-17, 1.3496894568279d-14, 5.7633272256259d-13,
     |   1.2664137105707d-11, 1.7399021145056d-10, 1.6756504070013d-09,
     |   1.2203901740438d-08, 7.0870231400275d-08, 3.4099673107062d-07,
     |   1.3989995039954d-06, 5.0027518435221d-06, 1.5862844234134d-05,
     |   4.5212235043760d-05, 1.1711143961114d-04, 2.7815415001869d-04,
     |   6.1022207793937d-04, 1.2439887227175d-03, 2.3682018999342d-03,
     |   4.2272059880675d-03, 7.0981046352989d-03, 1.1241010619111d-02,
     |   1.6822016721805d-02, 2.3818460171194d-02, 3.1927390682272d-02,
     |   4.0506801678612d-02, 4.8580518067434d-02, 5.4928388041935d-02,
     |   5.8263606025097d-02, 5.7472852078335d-02, 5.1870307729225d-02,
     |   4.1402532725691d-02, 2.6744498885491d-02, 9.2493500286366d-03,
     |  -9.2493500286365d-03,-2.6744498885491d-02,-4.1402532725691d-02,
     |  -5.1870307729225d-02,-5.7472852078334d-02,-5.8263606025097d-02,
     |  -5.4928388041935d-02,-4.8580518067434d-02,-4.0506801678612d-02,
     |  -3.1927390682272d-02,-2.3818460171194d-02,-1.6822016721805d-02,
     |  -1.1241010619111d-02,-7.0981046352989d-03,-4.2272059880675d-03,
     |  -2.3682018999342d-03,-1.2439887227175d-03,-6.1022207793937d-04,
     |  -2.7815415001870d-04,-1.1711143961110d-04,-4.5212235043730d-05,
     |  -1.5862844234132d-05,-5.0027518435420d-06,-1.3989995039567d-06,
     |  -3.4099673105729d-07,-7.0870231367042d-08,-1.2203901718178d-08,
     |  -1.6756504330622d-09,-1.7399019873367d-10,-1.2664121273000d-11,
     |  -5.7627894808586d-13,-1.3551521835552d-14, 8.2213282404646d-17,
     |   2.4644346933723d-16, 1.9225890856938d-16, 2.1630335555783d-16/
      data (zmn(lat,19,19), lat = 1,72)/
     |  -1.4865775570844d-17,-4.6175857489336d-17,-6.6623321376517d-17,
     |  -9.3230969209395d-17, 3.2230801731362d-16, 2.2756072672410d-14,
     |   5.9866182296496d-13, 9.5809352504122d-12, 1.0570736399256d-10,
     |   8.7110379326031d-10, 5.6695299267962d-09, 3.0347931213477d-08,
     |   1.3771523746667d-07, 5.4226272121693d-07, 1.8868165904443d-06,
     |   5.8864727350081d-06, 1.6660784956396d-05, 4.3195455522312d-05,
     |   1.0340744448028d-04, 2.3011064376937d-04, 4.7866973433619d-04,
     |   9.3523594003603d-04, 1.7232885877027d-03, 3.0050889136921d-03,
     |   4.9741123078849d-03, 7.8351420375384d-03, 1.1770869844814d-02,
     |   1.6897480873936d-02, 2.3216090163534d-02, 3.0570750434940d-02,
     |   3.8625521457640d-02, 4.6871533748278d-02, 5.4669722144732d-02,
     |   6.1326806972734d-02, 6.6193185869114d-02, 6.8764315698776d-02,
     |   6.8764315698776d-02, 6.6193185869114d-02, 6.1326806972734d-02,
     |   5.4669722144732d-02, 4.6871533748278d-02, 3.8625521457640d-02,
     |   3.0570750434940d-02, 2.3216090163534d-02, 1.6897480873936d-02,
     |   1.1770869844814d-02, 7.8351420375384d-03, 4.9741123078850d-03,
     |   3.0050889136921d-03, 1.7232885877027d-03, 9.3523594003605d-04,
     |   4.7866973433620d-04, 2.3011064376939d-04, 1.0340744448028d-04,
     |   4.3195455522349d-05, 1.6660784956379d-05, 5.8864727350125d-06,
     |   1.8868165904421d-06, 5.4226272121661d-07, 1.3771523747040d-07,
     |   3.0347931219808d-08, 5.6695299238052d-09, 8.7110382694728d-10,
     |   1.0570737223804d-10, 9.5809468939638d-12, 5.9865902063781d-13,
     |   2.2744750976059d-14, 2.9783333606530d-16,-9.2531913919939d-17,
     |  -9.1502009035581d-17,-7.8351797452765d-17,-4.1372074039344d-17/
      data (zmn(lat, 0,20), lat = 1,72)/
     |   3.5187184978901d-03, 8.0685752821310d-03, 1.7144621137035d-03,
     |  -8.9006510913103d-03,-1.5419572992684d-02,-9.4859707889249d-03,
     |   5.2646683212859d-03, 1.8401139489403d-02, 1.8109388468440d-02,
     |   3.4821051306774d-03,-1.5662243721557d-02,-2.4028254255705d-02,
     |  -1.4401284385935d-02, 7.3442404709385d-03, 2.4712129715727d-02,
     |   2.4128850076472d-02, 4.7652528726510d-03,-1.9152804137746d-02,
     |  -2.9572156555541d-02,-1.7685192298963d-02, 8.1120989885614d-03,
     |   2.8710493282779d-02, 2.8033175382708d-02, 6.0674261889867d-03,
     |  -2.1152926715724d-02,-3.2936097592489d-02,-2.0066714209981d-02,
     |   8.2764105466105d-03, 3.0814747564932d-02, 3.0457957817327d-02,
     |   7.1027603688456d-03,-2.1831591209177d-02,-3.4608347905198d-02,
     |  -2.1441612406098d-02, 7.8805327516737d-03, 3.1380286713582d-02,
     |   3.1380286713582d-02, 7.8805327516738d-03,-2.1441612406098d-02,
     |  -3.4608347905198d-02,-2.1831591209177d-02, 7.1027603688456d-03,
     |   3.0457957817326d-02, 3.0814747564932d-02, 8.2764105466105d-03,
     |  -2.0066714209980d-02,-3.2936097592489d-02,-2.1152926715725d-02,
     |   6.0674261889867d-03, 2.8033175382708d-02, 2.8710493282779d-02,
     |   8.1120989885617d-03,-1.7685192298963d-02,-2.9572156555541d-02,
     |  -1.9152804137746d-02, 4.7652528726509d-03, 2.4128850076472d-02,
     |   2.4712129715727d-02, 7.3442404709384d-03,-1.4401284385935d-02,
     |  -2.4028254255705d-02,-1.5662243721557d-02, 3.4821051306773d-03,
     |   1.8109388468440d-02, 1.8401139489403d-02, 5.2646683212858d-03,
     |  -9.4859707889248d-03,-1.5419572992684d-02,-8.9006510913103d-03,
     |   1.7144621137035d-03, 8.0685752821311d-03, 3.5187184978902d-03/
      data (zmn(lat, 1,20), lat = 1,72)/
     |   1.0864503551181d-03, 6.8042971133653d-03, 1.1885891254921d-02,
     |   8.6898391445299d-03,-2.8883108474880d-03,-1.4984181666083d-02,
     |  -1.7196821641034d-02,-5.9935072942404d-03, 1.1556126377795d-02,
     |   2.2032268431562d-02, 1.6349507917855d-02,-2.6545242354425d-03,
     |  -2.1137672933167d-02,-2.4661553226942d-02,-9.3562765137385d-03,
     |   1.4060151717468d-02, 2.8018734671538d-02, 2.1195352236396d-02,
     |  -2.1225856262633d-03,-2.4843909715607d-02,-2.9497281201535d-02,
     |  -1.1908877426092d-02, 1.5323556616391d-02, 3.1712763813307d-02,
     |   2.4549895046118d-02,-1.3847233168172d-03,-2.6810073442717d-02,
     |  -3.2522434611775d-02,-1.3788550275252d-02, 1.5581272005695d-02,
     |   3.3632840490905d-02, 2.6576410508399d-02,-4.6692006496254d-04,
     |  -2.7369081492333d-02,-3.3865999324074d-02,-1.5057051124981d-02,
     |   1.5057051124981d-02, 3.3865999324074d-02, 2.7369081492333d-02,
     |   4.6692006496270d-04,-2.6576410508399d-02,-3.3632840490905d-02,
     |  -1.5581272005695d-02, 1.3788550275251d-02, 3.2522434611775d-02,
     |   2.6810073442717d-02, 1.3847233168174d-03,-2.4549895046118d-02,
     |  -3.1712763813308d-02,-1.5323556616391d-02, 1.1908877426092d-02,
     |   2.9497281201535d-02, 2.4843909715607d-02, 2.1225856262635d-03,
     |  -2.1195352236396d-02,-2.8018734671538d-02,-1.4060151717468d-02,
     |   9.3562765137385d-03, 2.4661553226942d-02, 2.1137672933167d-02,
     |   2.6545242354425d-03,-1.6349507917855d-02,-2.2032268431562d-02,
     |  -1.1556126377795d-02, 5.9935072942403d-03, 1.7196821641034d-02,
     |   1.4984181666083d-02, 2.8883108474881d-03,-8.6898391445299d-03,
     |  -1.1885891254921d-02,-6.8042971133654d-03,-1.0864503551181d-03/
      data (zmn(lat, 2,20), lat = 1,72)/
     |   1.2063528664398d-04, 2.4746583499720d-03, 8.6544596835179d-03,
     |   1.4618277774131d-02, 1.3901816695288d-02, 3.6274599926760d-03,
     |  -1.1140334053443d-02,-2.0093691598786d-02,-1.5314316625992d-02,
     |   1.4684388038669d-03, 1.8888739010802d-02, 2.3660987664007d-02,
     |   1.0984165214581d-02,-1.0932371118752d-02,-2.6055832010992d-02,
     |  -2.2439532044622d-02,-1.6816913215273d-03, 2.1392344609328d-02,
     |   2.9418502758834d-02, 1.5619528257192d-02,-1.0468773557918d-02,
     |  -2.9613717305480d-02,-2.7116391800840d-02,-4.1832431716070d-03,
     |   2.2506366218967d-02, 3.2961157416788d-02, 1.8948929121333d-02,
     |  -9.5230071570440d-03,-3.1355307136796d-02,-3.0078691991363d-02,
     |  -6.3211867701788d-03, 2.2406195942971d-02, 3.4679906738300d-02,
     |   2.1202554026687d-02,-8.1182499197792d-03,-3.1486826725151d-02,
     |  -3.1486826725151d-02,-8.1182499197792d-03, 2.1202554026687d-02,
     |   3.4679906738300d-02, 2.2406195942971d-02,-6.3211867701788d-03,
     |  -3.0078691991363d-02,-3.1355307136796d-02,-9.5230071570440d-03,
     |   1.8948929121333d-02, 3.2961157416788d-02, 2.2506366218967d-02,
     |  -4.1832431716070d-03,-2.7116391800840d-02,-2.9613717305480d-02,
     |  -1.0468773557918d-02, 1.5619528257192d-02, 2.9418502758834d-02,
     |   2.1392344609328d-02,-1.6816913215272d-03,-2.2439532044622d-02,
     |  -2.6055832010992d-02,-1.0932371118751d-02, 1.0984165214581d-02,
     |   2.3660987664007d-02, 1.8888739010802d-02, 1.4684388038670d-03,
     |  -1.5314316625992d-02,-2.0093691598786d-02,-1.1140334053443d-02,
     |   3.6274599926758d-03, 1.3901816695288d-02, 1.4618277774131d-02,
     |   8.6544596835179d-03, 2.4746583499721d-03, 1.2063528664393d-04/
      data (zmn(lat, 3,20), lat = 1,72)/
     |   3.0711493000758d-06, 5.7744695185152d-04, 3.5998484005263d-03,
     |   9.9317516522685d-03, 1.6649574946052d-02, 1.7962788087817d-02,
     |   9.7737946484008d-03,-5.6224213849893d-03,-1.9345755389896d-02,
     |  -2.1490261710821d-02,-8.8905392820655d-03, 1.1137988853935d-02,
     |   2.4805958645896d-02, 2.1556032540650d-02, 2.4233221840596d-03,
     |  -1.9632253361137d-02,-2.8522858657587d-02,-1.6912257448235d-02,
     |   7.6770665365616d-03, 2.7648625133911d-02, 2.7995565682391d-02,
     |   7.6897074215199d-03,-1.8951439996815d-02,-3.2372516897586d-02,
     |  -2.2232952335282d-02, 4.5789986836477d-03, 2.8586274055016d-02,
     |   3.1943255358296d-02, 1.1770452423151d-02,-1.7387775166222d-02,
     |  -3.4091121945696d-02,-2.5836204315791d-02, 1.5264010555569d-03,
     |   2.7949586291057d-02, 3.3932491820939d-02, 1.4986663250337d-02,
     |  -1.4986663250337d-02,-3.3932491820939d-02,-2.7949586291057d-02,
     |  -1.5264010555570d-03, 2.5836204315791d-02, 3.4091121945696d-02,
     |   1.7387775166222d-02,-1.1770452423151d-02,-3.1943255358296d-02,
     |  -2.8586274055016d-02,-4.5789986836479d-03, 2.2232952335282d-02,
     |   3.2372516897586d-02, 1.8951439996815d-02,-7.6897074215200d-03,
     |  -2.7995565682391d-02,-2.7648625133911d-02,-7.6770665365617d-03,
     |   1.6912257448235d-02, 2.8522858657587d-02, 1.9632253361137d-02,
     |  -2.4233221840596d-03,-2.1556032540650d-02,-2.4805958645896d-02,
     |  -1.1137988853935d-02, 8.8905392820654d-03, 2.1490261710821d-02,
     |   1.9345755389896d-02, 5.6224213849894d-03,-9.7737946484010d-03,
     |  -1.7962788087817d-02,-1.6649574946052d-02,-9.9317516522685d-03,
     |  -3.5998484005263d-03,-5.7744695185150d-04,-3.0711493001435d-06/
      data (zmn(lat, 4,20), lat = 1,72)/
     |   1.9494664621555d-07, 9.7611676435224d-05, 1.0618963111527d-03,
     |   4.4308604955809d-03, 1.0868617949080d-02, 1.8144222065892d-02,
     |   2.1188529364584d-02, 1.5315784226888d-02, 6.5377680882234d-04,
     |  -1.5990900536968d-02,-2.4378766710329d-02,-1.7806953749297d-02,
     |   1.0810958641215d-03, 2.0592763493847d-02, 2.7230827307580d-02,
     |   1.5335670908194d-02,-7.9650937100589d-03,-2.6798702547959d-02,
     |  -2.7449321289036d-02,-8.5329978973357d-03, 1.7221101398736d-02,
     |   3.1504224713775d-02, 2.3554758473520d-02,-1.6223427306352d-03,
     |  -2.6293465934010d-02,-3.2532734854755d-02,-1.5350683341570d-02,
     |   1.3281995152081d-02, 3.2772460594605d-02, 2.8793101068242d-02,
     |   3.8899666418749d-03,-2.4097245126075d-02,-3.4863920758972d-02,
     |  -2.0448831304785d-02, 8.8384815398046d-03, 3.1814600978623d-02,
     |   3.1814600978624d-02, 8.8384815398047d-03,-2.0448831304785d-02,
     |  -3.4863920758972d-02,-2.4097245126075d-02, 3.8899666418750d-03,
     |   2.8793101068242d-02, 3.2772460594606d-02, 1.3281995152081d-02,
     |  -1.5350683341570d-02,-3.2532734854755d-02,-2.6293465934011d-02,
     |  -1.6223427306352d-03, 2.3554758473520d-02, 3.1504224713775d-02,
     |   1.7221101398736d-02,-8.5329978973356d-03,-2.7449321289036d-02,
     |  -2.6798702547959d-02,-7.9650937100591d-03, 1.5335670908194d-02,
     |   2.7230827307580d-02, 2.0592763493847d-02, 1.0810958641217d-03,
     |  -1.7806953749297d-02,-2.4378766710329d-02,-1.5990900536968d-02,
     |   6.5377680882234d-04, 1.5315784226888d-02, 2.1188529364584d-02,
     |   1.8144222065892d-02, 1.0868617949080d-02, 4.4308604955809d-03,
     |   1.0618963111527d-03, 9.7611676435213d-05, 1.9494664622895d-07/
      data (zmn(lat, 5,20), lat = 1,72)/
     |   1.3113030094982d-07, 1.2854595183919d-05, 2.4243285855418d-04,
     |   1.4848685435209d-03, 5.0405055848970d-03, 1.1518540366655d-02,
     |   1.9206430795015d-02, 2.3726246287609d-02, 2.0210388047337d-02,
     |   7.1676069157916d-03,-1.0795435756454d-02,-2.4231592750287d-02,
     |  -2.4340494718616d-02,-9.4424854316687d-03, 1.2407488652786d-02,
     |   2.7471084824639d-02, 2.5173354846521d-02, 5.8831676755044d-03,
     |  -1.8264601452281d-02,-3.0916697061507d-02,-2.2745918213735d-02,
     |   1.4740583766702d-03, 2.5435189884762d-02, 3.2301195605357d-02,
     |   1.6683804567414d-02,-1.1041568865519d-02,-3.1572847401742d-02,
     |  -3.0194731479089d-02,-7.4380145807994d-03, 2.0918102439648d-02,
     |   3.4810752084807d-02, 2.4176332149715d-02,-3.6883586275899d-03,
     |  -2.9123162107292d-02,-3.4038755869462d-02,-1.4857768253216d-02,
     |   1.4857768253216d-02, 3.4038755869462d-02, 2.9123162107292d-02,
     |   3.6883586275901d-03,-2.4176332149715d-02,-3.4810752084807d-02,
     |  -2.0918102439648d-02, 7.4380145807991d-03, 3.0194731479089d-02,
     |   3.1572847401742d-02, 1.1041568865520d-02,-1.6683804567414d-02,
     |  -3.2301195605357d-02,-2.5435189884762d-02,-1.4740583766702d-03,
     |   2.2745918213734d-02, 3.0916697061507d-02, 1.8264601452281d-02,
     |  -5.8831676755044d-03,-2.5173354846521d-02,-2.7471084824639d-02,
     |  -1.2407488652786d-02, 9.4424854316687d-03, 2.4340494718616d-02,
     |   2.4231592750287d-02, 1.0795435756454d-02,-7.1676069157915d-03,
     |  -2.0210388047337d-02,-2.3726246287609d-02,-1.9206430795015d-02,
     |  -1.1518540366655d-02,-5.0405055848971d-03,-1.4848685435209d-03,
     |  -2.4243285855419d-04,-1.2854595183922d-05,-1.3113030089530d-07/
      data (zmn(lat, 6,20), lat = 1,72)/
     |   4.2489113225369d-09, 1.4016005183650d-06, 4.4929178468117d-05,
     |   3.9821942362418d-04, 1.8241873376665d-03, 5.4609162450208d-03,
     |   1.1908194611779d-02, 1.9882129596120d-02, 2.5654236735441d-02,
     |   2.4443328077878d-02, 1.3604283356483d-02,-4.3316030228243d-03,
     |  -2.1406417517930d-02,-2.8010862851011d-02,-1.9009189943297d-02,
     |   1.8011939520483d-03, 2.2601688068598d-02, 3.0252130151587d-02,
     |   1.8945301780317d-02,-5.0875531594140d-03,-2.6684583734096d-02,
     |  -3.1358226468512d-02,-1.5248992981379d-02, 1.1568322494033d-02,
     |   3.1263220366400d-02, 3.0189978731436d-02, 8.5115312792927d-03,
     |  -1.9397013086980d-02,-3.4468497505573d-02,-2.6072517044436d-02,
     |   3.7378873133386d-04, 2.6839358467565d-02, 3.5020593133374d-02,
     |   1.9094274634244d-02,-1.0080802107272d-02,-3.2384061371037d-02,
     |  -3.2384061371037d-02,-1.0080802107273d-02, 1.9094274634244d-02,
     |   3.5020593133374d-02, 2.6839358467565d-02, 3.7378873133383d-04,
     |  -2.6072517044436d-02,-3.4468497505573d-02,-1.9397013086980d-02,
     |   8.5115312792926d-03, 3.0189978731436d-02, 3.1263220366400d-02,
     |   1.1568322494033d-02,-1.5248992981379d-02,-3.1358226468512d-02,
     |  -2.6684583734096d-02,-5.0875531594141d-03, 1.8945301780317d-02,
     |   3.0252130151587d-02, 2.2601688068598d-02, 1.8011939520484d-03,
     |  -1.9009189943297d-02,-2.8010862851011d-02,-2.1406417517930d-02,
     |  -4.3316030228243d-03, 1.3604283356483d-02, 2.4443328077878d-02,
     |   2.5654236735441d-02, 1.9882129596120d-02, 1.1908194611779d-02,
     |   5.4609162450209d-03, 1.8241873376666d-03, 3.9821942362417d-04,
     |   4.4929178468060d-05, 1.4016005184392d-06, 4.2489113350642d-09/
      data (zmn(lat, 7,20), lat = 1,72)/
     |  -2.2940948888266d-09, 1.3091449441266d-07, 6.9687390043862d-06,
     |   8.8635197628859d-05, 5.4046843460341d-04, 2.0743471628458d-03,
     |   5.7074530433785d-03, 1.2050801103313d-02, 2.0188749315241d-02,
     |   2.7006746433103d-02, 2.7992380275626d-02, 1.9740015683687d-02,
     |   2.9506016493102d-03,-1.6283153533077d-02,-2.8604303735209d-02,
     |  -2.6518561952737d-02,-9.6627991489318d-03, 1.3529214263789d-02,
     |   2.9746155285531d-02, 2.8649794382381d-02, 9.8855155618993d-03,
     |  -1.5688750110633d-02,-3.2124577016091d-02,-2.8477184464737d-02,
     |  -6.3603559058904d-03, 2.0404555733368d-02, 3.4381663934833d-02,
     |   2.6014563938191d-02, 3.3347461385567d-04,-2.5938032074791d-02,
     |  -3.5302522172595d-02,-2.1261990889945d-02, 7.0733516042667d-03,
     |   3.0872506015437d-02, 3.4167031134531d-02, 1.4655615516949d-02,
     |  -1.4655615516949d-02,-3.4167031134531d-02,-3.0872506015437d-02,
     |  -7.0733516042668d-03, 2.1261990889945d-02, 3.5302522172595d-02,
     |   2.5938032074791d-02,-3.3347461385541d-04,-2.6014563938191d-02,
     |  -3.4381663934833d-02,-2.0404555733368d-02, 6.3603559058903d-03,
     |   2.8477184464736d-02, 3.2124577016091d-02, 1.5688750110633d-02,
     |  -9.8855155618989d-03,-2.8649794382381d-02,-2.9746155285531d-02,
     |  -1.3529214263789d-02, 9.6627991489318d-03, 2.6518561952737d-02,
     |   2.8604303735209d-02, 1.6283153533077d-02,-2.9506016493101d-03,
     |  -1.9740015683687d-02,-2.7992380275626d-02,-2.7006746433103d-02,
     |  -2.0188749315241d-02,-1.2050801103313d-02,-5.7074530433785d-03,
     |  -2.0743471628458d-03,-5.4046843460346d-04,-8.8635197628853d-05,
     |  -6.9687390043639d-06,-1.3091449438136d-07, 2.2940948799730d-09/
      data (zmn(lat, 8,20), lat = 1,72)/
     |  -5.1367886509409d-11, 1.0260075745469d-08, 9.2363753255409d-07,
     |   1.6757831316028d-05, 1.3489179029734d-04, 6.5558241920021d-04,
     |   2.2337761201496d-03, 5.7893802113918d-03, 1.1952474375718d-02,
     |   2.0129810761775d-02, 2.7789172373513d-02, 3.0817167802094d-02,
     |   2.5382254613657d-02, 1.0662152568310d-02,-9.2551984083826d-03,
     |  -2.6081298577204d-02,-3.1117462699424d-02,-2.0457773709949d-02,
     |   1.5892915918053d-03, 2.3621318992345d-02, 3.3014847294298d-02,
     |   2.3514340993814d-02,-2.1149433172123d-04,-2.4469024410100d-02,
     |  -3.4419290273278d-02,-2.3381285776880d-02, 2.4274635195400d-03,
     |   2.7190001802211d-02, 3.5208165551419d-02, 2.1021475991173d-02,
     |  -6.7198143285046d-03,-3.0454068524663d-02,-3.4888829510913d-02,
     |  -1.6976966730044d-02, 1.1916123838770d-02, 3.3235615288377d-02,
     |   3.3235615288377d-02, 1.1916123838770d-02,-1.6976966730044d-02,
     |  -3.4888829510913d-02,-3.0454068524663d-02,-6.7198143285045d-03,
     |   2.1021475991173d-02, 3.5208165551419d-02, 2.7190001802211d-02,
     |   2.4274635195400d-03,-2.3381285776880d-02,-3.4419290273278d-02,
     |  -2.4469024410100d-02,-2.1149433172116d-04, 2.3514340993814d-02,
     |   3.3014847294297d-02, 2.3621318992345d-02, 1.5892915918054d-03,
     |  -2.0457773709949d-02,-3.1117462699424d-02,-2.6081298577204d-02,
     |  -9.2551984083826d-03, 1.0662152568310d-02, 2.5382254613657d-02,
     |   3.0817167802094d-02, 2.7789172373513d-02, 2.0129810761775d-02,
     |   1.1952474375718d-02, 5.7893802113918d-03, 2.2337761201495d-03,
     |   6.5558241920011d-04, 1.3489179029731d-04, 1.6757831316078d-05,
     |   9.2363753267353d-07, 1.0260075650295d-08,-5.1367902956345d-11/
      data (zmn(lat, 9,20), lat = 1,72)/
     |   4.3091171410741d-11, 6.5532190026273d-10, 1.0605450513169d-07,
     |   2.7334344586776d-06, 2.8886107944250d-05, 1.7637812504224d-04,
     |   7.3592750719959d-04, 2.3031550257762d-03, 5.7140916002357d-03,
     |   1.1617396547239d-02, 1.9702924520630d-02, 2.7989694522961d-02,
     |   3.2858355829476d-02, 3.0339465955713d-02, 1.8428293680569d-02,
     |  -7.5069699875827d-04,-2.0550692585045d-02,-3.2165973730523d-02,
     |  -2.9117387805443d-02,-1.1533667735433d-02, 1.2616182855146d-02,
     |   3.0833159428904d-02, 3.2733568680230d-02, 1.6389350080579d-02,
     |  -9.6908925785996d-03,-3.0757841492063d-02,-3.4247058590534d-02,
     |  -1.7536996464344d-02, 9.9096804903135d-03, 3.1782847993466d-02,
     |   3.4694630588350d-02, 1.6549658906182d-02,-1.1839843918197d-02,
     |  -3.3168929330891d-02,-3.4273777512881d-02,-1.4366739956641d-02,
     |   1.4366739956641d-02, 3.4273777512881d-02, 3.3168929330891d-02,
     |   1.1839843918198d-02,-1.6549658906182d-02,-3.4694630588350d-02,
     |  -3.1782847993466d-02,-9.9096804903137d-03, 1.7536996464344d-02,
     |   3.4247058590533d-02, 3.0757841492063d-02, 9.6908925785998d-03,
     |  -1.6389350080579d-02,-3.2733568680230d-02,-3.0833159428904d-02,
     |  -1.2616182855146d-02, 1.1533667735433d-02, 2.9117387805443d-02,
     |   3.2165973730523d-02, 2.0550692585045d-02, 7.5069699875841d-04,
     |  -1.8428293680569d-02,-3.0339465955713d-02,-3.2858355829476d-02,
     |  -2.7989694522961d-02,-1.9702924520630d-02,-1.1617396547239d-02,
     |  -5.7140916002357d-03,-2.3031550257762d-03,-7.3592750719960d-04,
     |  -1.7637812504233d-04,-2.8886107944258d-05,-2.7334344586750d-06,
     |  -1.0605450514539d-07,-6.5532192849306d-10,-4.3091175756901d-11/
      data (zmn(lat,10,20), lat = 1,72)/
     |   7.1492329468353d-13, 3.9551737340801d-11, 1.0639521917209d-08,
     |   3.8870863754521d-07, 5.3719963960232d-06, 4.0990757070799d-05,
     |   2.0790578766253d-04, 7.7773629522223d-04, 2.2854465769955d-03,
     |   5.4899012260039d-03, 1.1051701286091d-02, 1.8906066998967d-02,
     |   2.7589066431784d-02, 3.4042464416949d-02, 3.4407752837600d-02,
     |   2.5856356071416d-02, 8.7352893794867d-03,-1.2285844051754d-02,
     |  -2.9251334481633d-02,-3.4279364681656d-02,-2.3870213405008d-02,
     |  -1.7457873027816d-03, 2.1889309783233d-02, 3.4981976642070d-02,
     |   3.0077484010971d-02, 8.9809264862036d-03,-1.7424234630487d-02,
     |  -3.4679184711928d-02,-3.2822477489401d-02,-1.2407925071549d-02,
     |   1.5312837556585d-02, 3.4535474787584d-02, 3.4022026422880d-02,
     |   1.3834414172097d-02,-1.4462700676302d-02,-3.4440627295306d-02,
     |  -3.4440627295306d-02,-1.4462700676302d-02, 1.3834414172097d-02,
     |   3.4022026422880d-02, 3.4535474787584d-02, 1.5312837556585d-02,
     |  -1.2407925071549d-02,-3.2822477489401d-02,-3.4679184711928d-02,
     |  -1.7424234630487d-02, 8.9809264862035d-03, 3.0077484010971d-02,
     |   3.4981976642069d-02, 2.1889309783233d-02,-1.7457873027816d-03,
     |  -2.3870213405008d-02,-3.4279364681656d-02,-2.9251334481633d-02,
     |  -1.2285844051754d-02, 8.7352893794867d-03, 2.5856356071416d-02,
     |   3.4407752837600d-02, 3.4042464416949d-02, 2.7589066431784d-02,
     |   1.8906066998967d-02, 1.1051701286091d-02, 5.4899012260040d-03,
     |   2.2854465769955d-03, 7.7773629522227d-04, 2.0790578766262d-04,
     |   4.0990757070874d-05, 5.3719963960104d-06, 3.8870863751564d-07,
     |   1.0639521835682d-08, 3.9551781690786d-11, 7.1490982443110d-13/
      data (zmn(lat,11,20), lat = 1,72)/
     |  -7.1096896157776d-13, 2.8041875425368d-12, 9.3798025695075d-10,
     |   4.8514936266827d-08, 8.7437144908327d-07, 8.3058787252618d-06,
     |   5.0949693224322d-05, 2.2626781584460d-04, 7.8030537503259d-04,
     |   2.1863408959359d-03, 5.1281993555413d-03, 1.0266826888491d-02,
     |   1.7743457770691d-02, 2.6570345050553d-02, 3.4291178303652d-02,
     |   3.7369851277689d-02, 3.2517839251071d-02, 1.8608970060489d-02,
     |  -1.7662250999774d-03,-2.2248453188140d-02,-3.4778675857727d-02,
     |  -3.3266288013072d-02,-1.7159002855154d-02, 7.2031396708950d-03,
     |   2.8742575437207d-02, 3.6765418726360d-02, 2.6625583920481d-02,
     |   2.7748010415483d-03,-2.2880506131674d-02,-3.6900236886718d-02,
     |  -3.1539983492450d-02,-9.2719100965872d-03, 1.8164058986443d-02,
     |   3.5943227215949d-02, 3.4285321584086d-02, 1.3969296693461d-02,
     |  -1.3969296693461d-02,-3.4285321584086d-02,-3.5943227215949d-02,
     |  -1.8164058986443d-02, 9.2719100965871d-03, 3.1539983492450d-02,
     |   3.6900236886718d-02, 2.2880506131675d-02,-2.7748010415482d-03,
     |  -2.6625583920481d-02,-3.6765418726360d-02,-2.8742575437207d-02,
     |  -7.2031396708951d-03, 1.7159002855154d-02, 3.3266288013072d-02,
     |   3.4778675857728d-02, 2.2248453188140d-02, 1.7662250999774d-03,
     |  -1.8608970060489d-02,-3.2517839251071d-02,-3.7369851277690d-02,
     |  -3.4291178303652d-02,-2.6570345050553d-02,-1.7743457770691d-02,
     |  -1.0266826888491d-02,-5.1281993555413d-03,-2.1863408959359d-03,
     |  -7.8030537503258d-04,-2.2626781584458d-04,-5.0949693224312d-05,
     |  -8.3058787252410d-06,-8.7437144902301d-07,-4.8514936269710d-08,
     |  -9.3798025556074d-10,-2.8042030985501d-12, 7.1093663338789d-13/
      data (zmn(lat,12,20), lat = 1,72)/
     |  -8.9789362420179d-15, 1.2395661849774d-13, 7.3020281905210d-11,
     |   5.3339467011398d-09, 1.2510426839127d-07, 1.4752797038388d-06,
     |   1.0904261531178d-05, 5.7212966610760d-05, 2.3008685798349d-04,
     |   7.4568788075841d-04, 2.0147729269162d-03, 4.6451809530754d-03,
     |   9.2826182654707d-03, 1.6231509877469d-02, 2.4929571241245d-02,
     |   3.3535305546912d-02, 3.9005667104825d-02, 3.7946687908259d-02,
     |   2.8156134643536d-02, 1.0270747258381d-02,-1.1420008392786d-02,
     |  -2.9809440276207d-02,-3.7573132927245d-02,-3.0627143598777d-02,
     |  -1.0763165865481d-02, 1.4186319773386d-02, 3.3265080093272d-02,
     |   3.7378218268530d-02, 2.3984347520480d-02,-1.0698276151335d-03,
     |  -2.5891987196963d-02,-3.8221144245824d-02,-3.1673306469892d-02,
     |  -9.2500572948151d-03, 1.7918088990230d-02, 3.6127008368282d-02,
     |   3.6127008368282d-02, 1.7918088990230d-02,-9.2500572948150d-03,
     |  -3.1673306469892d-02,-3.8221144245824d-02,-2.5891987196962d-02,
     |  -1.0698276151335d-03, 2.3984347520480d-02, 3.7378218268530d-02,
     |   3.3265080093273d-02, 1.4186319773386d-02,-1.0763165865481d-02,
     |  -3.0627143598777d-02,-3.7573132927245d-02,-2.9809440276207d-02,
     |  -1.1420008392786d-02, 1.0270747258381d-02, 2.8156134643536d-02,
     |   3.7946687908259d-02, 3.9005667104825d-02, 3.3535305546912d-02,
     |   2.4929571241245d-02, 1.6231509877469d-02, 9.2826182654707d-03,
     |   4.6451809530754d-03, 2.0147729269163d-03, 7.4568788075836d-04,
     |   2.3008685798346d-04, 5.7212966610767d-05, 1.0904261531201d-05,
     |   1.4752797038087d-06, 1.2510426842071d-07, 5.3339466674048d-09,
     |   7.3020281759055d-11, 1.2398162690772d-13,-8.9599657513462d-15/
      data (zmn(lat,13,20), lat = 1,72)/
     |   9.9863381885228d-15,-5.1771807904040d-15, 5.0273220469294d-12,
     |   5.1706558958807d-10, 1.5757030847311d-08, 2.3017239887528d-07,
     |   2.0442338221542d-06, 1.2626908998971d-05, 5.8948246566568d-05,
     |   2.1968603581940d-04, 6.7853563530480d-04, 1.7833060552199d-03,
     |   4.0631449762532d-03, 8.1300945883514d-03, 1.4404836527084d-02,
     |   2.2687705861310d-02, 3.1733755921352d-02, 3.9115174630583d-02,
     |   4.1657919662989d-02, 3.6542272930413d-02, 2.2786763472883d-02,
     |   2.4603013997351d-03,-1.9161382837029d-02,-3.4975308626057d-02,
     |  -3.8742719359254d-02,-2.8066570697419d-02,-6.1892549236401d-03,
     |   1.8572310262611d-02, 3.5923833064020d-02, 3.8080442458786d-02,
     |   2.3583946483002d-02,-1.5456762706035d-03,-2.6172575555800d-02,
     |  -3.9037844606688d-02,-3.4075126638605d-02,-1.3426066949502d-02,
     |   1.3426066949502d-02, 3.4075126638605d-02, 3.9037844606688d-02,
     |   2.6172575555800d-02, 1.5456762706036d-03,-2.3583946483002d-02,
     |  -3.8080442458786d-02,-3.5923833064021d-02,-1.8572310262611d-02,
     |   6.1892549236400d-03, 2.8066570697419d-02, 3.8742719359254d-02,
     |   3.4975308626057d-02, 1.9161382837029d-02,-2.4603013997351d-03,
     |  -2.2786763472883d-02,-3.6542272930413d-02,-4.1657919662989d-02,
     |  -3.9115174630583d-02,-3.1733755921353d-02,-2.2687705861310d-02,
     |  -1.4404836527084d-02,-8.1300945883514d-03,-4.0631449762532d-03,
     |  -1.7833060552199d-03,-6.7853563530478d-04,-2.1968603581932d-04,
     |  -5.8948246566578d-05,-1.2626908998990d-05,-2.0442338221297d-06,
     |  -2.3017239883607d-07,-1.5757030874079d-08,-5.1706560507366d-10,
     |  -5.0273281598969d-12, 5.1966622792552d-15,-9.9682000289283d-15/
      data (zmn(lat,14,20), lat = 1,72)/
     |  -3.3199377335808d-17,-2.0477526744200d-16, 3.0410908176944d-13,
     |   4.4111286579599d-11, 1.7442808323927d-09, 3.1509442653228d-08,
     |   3.3553498358361d-07, 2.4332828511718d-06, 1.3142028229638d-05,
     |   5.6078886274444d-05, 1.9693095297820d-04, 5.8589342829429d-04,
     |   1.5082114732740d-03, 3.4111972125249d-03, 6.8535282094725d-03,
     |   1.2321799622530d-02, 1.9903333561904d-02, 2.8897288670596d-02,
     |   3.7554674895377d-02, 4.3192060419650d-02, 4.2849459454426d-02,
     |   3.4435773124866d-02, 1.7994605700134d-02,-3.5119556899443d-03,
     |  -2.4485819825751d-02,-3.8267603828714d-02,-3.9624716138457d-02,
     |  -2.7194892862294d-02,-4.7087183972102d-03, 1.9832959534288d-02,
     |   3.6995568068450d-02, 3.9736591743735d-02, 2.6569439897553d-02,
     |   2.5368631964751d-03,-2.2635464136715d-02,-3.8542926537352d-02,
     |  -3.8542926537352d-02,-2.2635464136715d-02, 2.5368631964751d-03,
     |   2.6569439897553d-02, 3.9736591743735d-02, 3.6995568068450d-02,
     |   1.9832959534288d-02,-4.7087183972100d-03,-2.7194892862293d-02,
     |  -3.9624716138457d-02,-3.8267603828714d-02,-2.4485819825751d-02,
     |  -3.5119556899444d-03, 1.7994605700134d-02, 3.4435773124866d-02,
     |   4.2849459454426d-02, 4.3192060419650d-02, 3.7554674895377d-02,
     |   2.8897288670596d-02, 1.9903333561904d-02, 1.2321799622530d-02,
     |   6.8535282094725d-03, 3.4111972125250d-03, 1.5082114732740d-03,
     |   5.8589342829431d-04, 1.9693095297826d-04, 5.6078886274474d-05,
     |   1.3142028229587d-05, 2.4332828511519d-06, 3.3553498354282d-07,
     |   3.1509442661916d-08, 1.7442808761446d-09, 4.4111271960404d-11,
     |   3.0419364508050d-13,-2.2379522753750d-16,-1.8660056214634d-17/
      data (zmn(lat,15,20), lat = 1,72)/
     |  -1.3036557152916d-16, 5.0678892150222d-17, 1.5923941312067d-14,
     |   3.2942808368509d-12, 1.6885641944479d-10, 3.7670766096967d-09,
     |   4.8015533811472d-08, 4.0794599708395d-07, 2.5423044302998d-06,
     |   1.2381149129179d-05, 4.9235016927064d-05, 1.6498706528429d-04,
     |   4.7680829632861d-04, 1.2090705491767d-03, 2.7250641905817d-03,
     |   5.5112194279035d-03, 1.0068520220777d-02, 1.6684578977031d-02,
     |   2.5115264561161d-02, 3.4285841130099d-02, 4.2190062617715d-02,
     |   4.6167195054024d-02, 4.3630673576381d-02, 3.3116369367774d-02,
     |   1.5289016794295d-02,-6.5840440013864d-03,-2.7099220395806d-02,
     |  -4.0205571262167d-02,-4.1332232330730d-02,-2.9370197589864d-02,
     |  -7.6154382170454d-03, 1.6917669273044d-02, 3.5764359817012d-02,
     |   4.2095781015473d-02, 3.3409141950775d-02, 1.2668154715321d-02,
     |  -1.2668154715321d-02,-3.3409141950775d-02,-4.2095781015473d-02,
     |  -3.5764359817012d-02,-1.6917669273044d-02, 7.6154382170455d-03,
     |   2.9370197589864d-02, 4.1332232330730d-02, 4.0205571262167d-02,
     |   2.7099220395806d-02, 6.5840440013864d-03,-1.5289016794295d-02,
     |  -3.3116369367774d-02,-4.3630673576381d-02,-4.6167195054024d-02,
     |  -4.2190062617715d-02,-3.4285841130099d-02,-2.5115264561161d-02,
     |  -1.6684578977031d-02,-1.0068520220777d-02,-5.5112194279035d-03,
     |  -2.7250641905818d-03,-1.2090705491768d-03,-4.7680829632865d-04,
     |  -1.6498706528429d-04,-4.9235016927051d-05,-1.2381149129210d-05,
     |  -2.5423044303448d-06,-4.0794599707639d-07,-4.8015533879246d-08,
     |  -3.7670766648281d-09,-1.6885645780160d-10,-3.2942974733128d-12,
     |  -1.5915229886445d-14,-8.9487640535938d-17, 1.7611844226197d-16/
      data (zmn(lat,16,20), lat = 1,72)/
     |  -1.5318342142216d-16,-1.2711686900181d-16, 6.3415649869678d-16,
     |   2.1321601375577d-13, 1.4158529008277d-11, 3.8966724501151d-10,
     |   5.9368475921036d-09, 5.8993890663862d-08, 4.2333743078176d-07,
     |   2.3470355757612d-06, 1.0536464401327d-05, 3.9619313336853d-05,
     |   1.2794869998000d-04, 3.6165526775720d-04, 9.0773172050071d-04,
     |   2.0456498100273d-03, 4.1741204487073d-03, 7.7596523093208d-03,
     |   1.3197282041542d-02, 2.0581056669065d-02, 2.9433026939135d-02,
     |   3.8498671321747d-02, 4.5751882085714d-02, 4.8728263699489d-02,
     |   4.5203492723897d-02, 3.4073466857418d-02, 1.6136839428876d-02,
     |  -5.5872860821048d-03,-2.6286936119786d-02,-4.0564199586254d-02,
     |  -4.4126661701321d-02,-3.5395756969902d-02,-1.6389477850533d-02,
     |   7.5686797260088d-03, 2.9345527371101d-02, 4.2249212951313d-02,
     |   4.2249212951313d-02, 2.9345527371102d-02, 7.5686797260089d-03,
     |  -1.6389477850533d-02,-3.5395756969902d-02,-4.4126661701321d-02,
     |  -4.0564199586254d-02,-2.6286936119786d-02,-5.5872860821049d-03,
     |   1.6136839428876d-02, 3.4073466857418d-02, 4.5203492723897d-02,
     |   4.8728263699489d-02, 4.5751882085714d-02, 3.8498671321747d-02,
     |   2.9433026939136d-02, 2.0581056669065d-02, 1.3197282041542d-02,
     |   7.7596523093209d-03, 4.1741204487073d-03, 2.0456498100273d-03,
     |   9.0773172050072d-04, 3.6165526775719d-04, 1.2794869998003d-04,
     |   3.9619313336856d-05, 1.0536464401252d-05, 2.3470355757337d-06,
     |   4.2333743083083d-07, 5.8993890661668d-08, 5.9368476223946d-09,
     |   3.8966727613097d-10, 1.4158469658856d-11, 2.1327238643586d-13,
     |   5.5785809371216d-16,-1.3531269043631d-16,-2.0423899330864d-16/
      data (zmn(lat,17,20), lat = 1,72)/
     |  -2.6590721178901d-17,-8.9800314632830d-17,-9.8729507294227d-17,
     |   1.1625682889568d-14, 1.0112975292538d-12, 3.4309363585560d-11,
     |   6.2412808635598d-10, 7.2436522325150d-09, 5.9754062887918d-08,
     |   3.7638035189528d-07, 1.9028928330855d-06, 8.0056839864568d-06,
     |   2.8789488377433d-05, 9.0319802851035d-05, 2.5112790686495d-04,
     |   6.2649915333092d-04, 1.4159795728893d-03, 2.9213467447271d-03,
     |   5.5336813223616d-03, 9.6648885972182d-03, 1.5608118930439d-02,
     |   2.3337314153083d-02, 3.2295100626939d-02, 4.1256455447230d-02,
     |   4.8371101324842d-02, 5.1459825626752d-02, 4.8562337243928d-02,
     |   3.8624349127763d-02, 2.2110618998650d-02, 1.2900552130179d-03,
     |  -2.0003689700190d-02,-3.7176798443966d-02,-4.6077079017740d-02,
     |  -4.4243811681672d-02,-3.1785034635156d-02,-1.1545817748408d-02,
     |   1.1545817748408d-02, 3.1785034635156d-02, 4.4243811681672d-02,
     |   4.6077079017740d-02, 3.7176798443966d-02, 2.0003689700190d-02,
     |  -1.2900552130179d-03,-2.2110618998650d-02,-3.8624349127763d-02,
     |  -4.8562337243928d-02,-5.1459825626752d-02,-4.8371101324842d-02,
     |  -4.1256455447230d-02,-3.2295100626939d-02,-2.3337314153083d-02,
     |  -1.5608118930439d-02,-9.6648885972182d-03,-5.5336813223617d-03,
     |  -2.9213467447271d-03,-1.4159795728894d-03,-6.2649915333097d-04,
     |  -2.5112790686495d-04,-9.0319802851043d-05,-2.8789488377418d-05,
     |  -8.0056839864764d-06,-1.9028928330795d-06,-3.7638035188913d-07,
     |  -5.9754062865429d-08,-7.2436522227808d-09,-6.2412803044263d-10,
     |  -3.4309351300129d-11,-1.0112707974175d-12,-1.1638531357175d-14,
     |   7.5984493455946d-17, 9.3169047297135d-17, 1.6274224254304d-18/
      data (zmn(lat,18,20), lat = 1,72)/
     |  -4.3744829432153d-17,-5.3465577916350d-17,-7.0793115051740d-17,
     |   4.4826849466431d-16, 5.9703444916606d-14, 2.4984141073327d-12,
     |   5.4216997049833d-11, 7.3410846681056d-10, 6.9519656810569d-09,
     |   4.9669027315231d-08, 2.8225573198282d-07, 1.3255537287594d-06,
     |   5.2935430321156d-06, 1.8372109371042d-05, 5.6364247819958d-05,
     |   1.5491654249312d-04, 3.8555038652552d-04, 8.7634728265469d-04,
     |   1.8317695994970d-03, 3.5403461707137d-03, 6.3542033998125d-03,
     |   1.0624513044764d-02, 1.6585699156774d-02, 2.4200081677680d-02,
     |   3.3000020725646d-02, 4.1987369012139d-02, 4.9657482688017d-02,
     |   5.4196348855628d-02, 5.3852079684708d-02, 4.7416469752168d-02,
     |   3.4690985797479d-02, 1.6781793161356d-02,-3.9092513400281d-03,
     |  -2.4053721593190d-02,-4.0070511853899d-02,-4.8941244819727d-02,
     |  -4.8941244819727d-02,-4.0070511853899d-02,-2.4053721593190d-02,
     |  -3.9092513400282d-03, 1.6781793161356d-02, 3.4690985797479d-02,
     |   4.7416469752168d-02, 5.3852079684708d-02, 5.4196348855628d-02,
     |   4.9657482688017d-02, 4.1987369012139d-02, 3.3000020725646d-02,
     |   2.4200081677680d-02, 1.6585699156774d-02, 1.0624513044764d-02,
     |   6.3542033998125d-03, 3.5403461707138d-03, 1.8317695994970d-03,
     |   8.7634728265471d-04, 3.8555038652549d-04, 1.5491654249317d-04,
     |   5.6364247819969d-05, 1.8372109371055d-05, 5.2935430321323d-06,
     |   1.3255537287859d-06, 2.8225573205720d-07, 4.9669027324907d-08,
     |   6.9519656264020d-09, 7.3410846454275d-10, 5.4216976302540d-11,
     |   2.4984194603328d-12, 5.9713086988275d-14, 4.4952185051454d-16,
     |  -4.4545215464325d-17,-6.3018874727816d-17,-5.6438781292047d-17/
      data (zmn(lat,19,20), lat = 1,72)/
     |  -2.5295319438353d-17,-7.4690050563657d-17,-1.2116356378611d-16,
     |  -1.3152220304400d-16, 2.5994029147720d-15, 1.4214993498407d-13,
     |   3.6808693389584d-12, 5.8092897215058d-11, 6.3083708176792d-10,
     |   5.1054120448580d-09, 3.2558906673263d-08, 1.7036692354895d-07,
     |   7.5386793487838d-07, 2.8870084782302d-06, 9.7430774560375d-06,
     |   2.9395262627506d-05, 8.0207079618510d-05, 1.9979566360438d-04,
     |   4.5787203342287d-04, 9.7149795295048d-04, 1.9184440364500d-03,
     |   3.5410175701227d-03, 6.1304013596913d-03, 9.9822130680958d-03,
     |   1.5319424508342d-02, 2.2189352856432d-02, 3.0355155753617d-02,
     |   3.9214588582774d-02, 4.7783747528085d-02, 5.4776057443621d-02,
     |   5.8785428635389d-02, 5.8551337316595d-02, 5.3251859685947d-02,
     |   4.2750188885975d-02, 2.7720671111454d-02, 9.6052347289875d-03,
     |  -9.6052347289875d-03,-2.7720671111454d-02,-4.2750188885975d-02,
     |  -5.3251859685947d-02,-5.8551337316595d-02,-5.8785428635389d-02,
     |  -5.4776057443621d-02,-4.7783747528086d-02,-3.9214588582774d-02,
     |  -3.0355155753617d-02,-2.2189352856432d-02,-1.5319424508343d-02,
     |  -9.9822130680959d-03,-6.1304013596913d-03,-3.5410175701227d-03,
     |  -1.9184440364500d-03,-9.7149795295049d-04,-4.5787203342287d-04,
     |  -1.9979566360439d-04,-8.0207079618518d-05,-2.9395262627495d-05,
     |  -9.7430774560503d-06,-2.8870084782340d-06,-7.5386793490255d-07,
     |  -1.7036692354239d-07,-3.2558906706371d-08,-5.1054120373955d-09,
     |  -6.3083706375740d-10,-5.8092889139850d-11,-3.6808794940042d-12,
     |  -1.4215233418138d-13,-2.6331542931858d-15, 1.3170756728912d-16,
     |   1.0545191482348d-16, 7.0952882894227d-17, 1.8536518417741d-17/
      data (zmn(lat,20,20), lat = 1,72)/
     |  -9.8707555943029d-17,-8.9388293570201d-17,-9.2564599537226d-17,
     |  -9.4886379928061d-17,-2.4595282857458d-18, 5.4223297160127d-15,
     |   1.6956073122216d-13, 3.1179240458305d-12, 3.8788302200834d-11,
     |   3.5519252325805d-10, 2.5387200885453d-09, 1.4778350405043d-08,
     |   7.2330506960711d-08, 3.0500759261524d-07, 1.1295529246760d-06,
     |   3.7302531641992d-06, 1.1121686415608d-05, 3.0241294323400d-05,
     |   7.5625770002942d-05, 1.7515557162338d-04, 3.7794463140653d-04,
     |   7.6358547938370d-04, 1.4506623055165d-03, 2.6010015225397d-03,
     |   4.4151125581426d-03, 7.1144221488769d-03, 1.0907856081993d-02,
     |   1.5944227244970d-02, 2.2257119093623d-02, 2.9714047855898d-02,
     |   3.7984681321229d-02, 4.6541999476546d-02, 5.4704697863771d-02,
     |   6.1719625878347d-02, 6.6872007684223d-02, 6.9601996221401d-02,
     |   6.9601996221401d-02, 6.6872007684223d-02, 6.1719625878347d-02,
     |   5.4704697863771d-02, 4.6541999476546d-02, 3.7984681321229d-02,
     |   2.9714047855898d-02, 2.2257119093623d-02, 1.5944227244970d-02,
     |   1.0907856081993d-02, 7.1144221488769d-03, 4.4151125581427d-03,
     |   2.6010015225397d-03, 1.4506623055165d-03, 7.6358547938370d-04,
     |   3.7794463140653d-04, 1.7515557162338d-04, 7.5625770002943d-05,
     |   3.0241294323381d-05, 1.1121686415608d-05, 3.7302531641790d-06,
     |   1.1295529246691d-06, 3.0500759261624d-07, 7.2330506971984d-08,
     |   1.4778350408129d-08, 2.5387200741915d-09, 3.5519252240683d-10,
     |   3.8788326118104d-11, 3.1179309377382d-12, 1.6958003401919d-13,
     |   5.4166304245044d-15, 3.4634338584330d-18,-1.0217201660722d-16,
     |  -1.0499933292584d-16,-1.1113423005706d-16,-1.0463356247532d-16/
      data (zmn(lat, 0,21), lat = 1,72)/
     |   3.5785300544797d-03, 7.8019035728410d-03, 4.4989844901889d-04,
     |  -1.0327129332423d-02,-1.4928579619213d-02,-5.8718791922087d-03,
     |   9.9798261885084d-03, 1.9776502847320d-02, 1.3091521044606d-02,
     |  -5.5960413074219d-03,-2.1621583754967d-02,-2.0288051777615d-02,
     |  -1.6598216694352d-03, 1.9958263621079d-02, 2.5926444396022d-02,
     |   1.0488505132439d-02,-1.4807687741740d-02,-2.8802984230706d-02,
     |  -1.9424691180089d-02, 6.7414300838826d-03, 2.8175141351473d-02,
     |   2.7000630899951d-02, 3.1991279091192d-03,-2.3854976365032d-02,
     |  -3.1948428659988d-02,-1.3658860684373d-02, 1.6230092299894d-02,
     |   3.3384523714779d-02, 2.3173703707150d-02,-6.2021252753445d-03,
     |  -3.0940893481507d-02,-3.0392405559079d-02,-4.9505370061349d-03,
     |   2.4820320203563d-02, 3.4281362405770d-02, 1.5766147199894d-02,
     |  -1.5766147199894d-02,-3.4281362405770d-02,-2.4820320203563d-02,
     |   4.9505370061348d-03, 3.0392405559079d-02, 3.0940893481507d-02,
     |   6.2021252753445d-03,-2.3173703707150d-02,-3.3384523714779d-02,
     |  -1.6230092299894d-02, 1.3658860684373d-02, 3.1948428659988d-02,
     |   2.3854976365033d-02,-3.1991279091192d-03,-2.7000630899951d-02,
     |  -2.8175141351473d-02,-6.7414300838827d-03, 1.9424691180089d-02,
     |   2.8802984230706d-02, 1.4807687741740d-02,-1.0488505132439d-02,
     |  -2.5926444396022d-02,-1.9958263621079d-02, 1.6598216694351d-03,
     |   2.0288051777615d-02, 2.1621583754967d-02, 5.5960413074219d-03,
     |  -1.3091521044606d-02,-1.9776502847320d-02,-9.9798261885083d-03,
     |   5.8718791922086d-03, 1.4928579619213d-02, 1.0327129332423d-02,
     |  -4.4989844901883d-04,-7.8019035728409d-03,-3.5785300544797d-03/
      data (zmn(lat, 1,21), lat = 1,72)/
     |   1.1573053318886d-03, 7.1379087471008d-03, 1.1743427095472d-02,
     |   7.0119394740957d-03,-5.7564282032693d-03,-1.6487134135066d-02,
     |  -1.4627716593687d-02, 3.5755714925976d-04, 1.7102379799503d-02,
     |   2.1076250216390d-02, 7.4047507628593d-03,-1.3853639876204d-02,
     |  -2.5103238793355d-02,-1.5956292539643d-02, 7.2691131332022d-03,
     |   2.5802621108248d-02, 2.3727969325295d-02, 1.6839183090218d-03,
     |  -2.2793149426408d-02,-2.9311736828008d-02,-1.1685602731772d-02,
     |   1.6278548551380d-02, 3.1645454943560d-02, 2.1243808601524d-02,
     |  -7.0160074815804d-03,-3.0162680544746d-02,-2.8912740652249d-02,
     |  -3.7989273658626d-03, 2.4874215612057d-02, 3.3509164635335d-02,
     |   1.4713483372680d-02,-1.6365201339833d-02,-3.4290842765770d-02,
     |  -2.4237539346038d-02, 5.7065593258478d-03, 3.1069041281942d-02,
     |   3.1069041281942d-02, 5.7065593258479d-03,-2.4237539346038d-02,
     |  -3.4290842765770d-02,-1.6365201339833d-02, 1.4713483372680d-02,
     |   3.3509164635335d-02, 2.4874215612057d-02,-3.7989273658626d-03,
     |  -2.8912740652249d-02,-3.0162680544746d-02,-7.0160074815806d-03,
     |   2.1243808601524d-02, 3.1645454943560d-02, 1.6278548551380d-02,
     |  -1.1685602731771d-02,-2.9311736828008d-02,-2.2793149426409d-02,
     |   1.6839183090216d-03, 2.3727969325295d-02, 2.5802621108248d-02,
     |   7.2691131332020d-03,-1.5956292539643d-02,-2.5103238793355d-02,
     |  -1.3853639876204d-02, 7.4047507628593d-03, 2.1076250216390d-02,
     |   1.7102379799503d-02, 3.5755714925990d-04,-1.4627716593687d-02,
     |  -1.6487134135066d-02,-5.7564282032694d-03, 7.0119394740957d-03,
     |   1.1743427095472d-02, 7.1379087471010d-03, 1.1573053318886d-03/
      data (zmn(lat, 2,21), lat = 1,72)/
     |   1.3586181443263d-04, 2.7446141027526d-03, 9.3030225860240d-03,
     |   1.4773278437148d-02, 1.2125539535168d-02,-2.8602827587973d-04,
     |  -1.4776710366180d-02,-1.9638176714768d-02,-9.0925694780619d-03,
     |   1.0141120038942d-02, 2.3008368146129d-02, 1.8032861495632d-02,
     |  -2.2456977766428d-03,-2.2180401819013d-02,-2.5103422298312d-02,
     |  -7.4706854784252d-03, 1.7322393841385d-02, 2.9068167016768d-02,
     |   1.7395220924623d-02,-9.1176323730139d-03,-2.9145121849972d-02,
     |  -2.5913131316865d-02,-1.2664164959903d-03, 2.5140101751642d-02,
     |   3.1628426219715d-02, 1.2331223758395d-02,-1.7480826081340d-02,
     |  -3.3566138536164d-02,-2.2464842618804d-02, 7.1541797431982d-03,
     |   3.1316336607413d-02, 3.0182069592038d-02, 4.4421144843032d-03,
     |  -2.5094892260115d-02,-3.4347680339155d-02,-1.5710465667454d-02,
     |   1.5710465667454d-02, 3.4347680339155d-02, 2.5094892260115d-02,
     |  -4.4421144843032d-03,-3.0182069592038d-02,-3.1316336607413d-02,
     |  -7.1541797431982d-03, 2.2464842618804d-02, 3.3566138536164d-02,
     |   1.7480826081340d-02,-1.2331223758395d-02,-3.1628426219715d-02,
     |  -2.5140101751642d-02, 1.2664164959903d-03, 2.5913131316865d-02,
     |   2.9145121849972d-02, 9.1176323730140d-03,-1.7395220924623d-02,
     |  -2.9068167016768d-02,-1.7322393841385d-02, 7.4706854784251d-03,
     |   2.5103422298312d-02, 2.2180401819013d-02, 2.2456977766429d-03,
     |  -1.8032861495632d-02,-2.3008368146129d-02,-1.0141120038942d-02,
     |   9.0925694780618d-03, 1.9638176714768d-02, 1.4776710366180d-02,
     |   2.8602827587982d-04,-1.2125539535168d-02,-1.4773278437148d-02,
     |  -9.3030225860240d-03,-2.7446141027527d-03,-1.3586181443266d-04/
      data (zmn(lat, 3,21), lat = 1,72)/
     |   3.9524449393858d-06, 6.7470656993701d-04, 4.1168903142603d-03,
     |   1.0936736255444d-02, 1.7200325636573d-02, 1.6340333005348d-02,
     |   5.1953905544957d-03,-1.1195832469997d-02,-2.1556983367701d-02,
     |  -1.6851305429102d-02, 1.3023792248722d-03, 2.0071302643699d-02,
     |   2.4519877826974d-02, 9.8080708587445d-03,-1.3714056091510d-02,
     |  -2.7659144221763d-02,-2.0131847776509d-02, 3.9965984824747d-03,
     |   2.6012162938124d-02, 2.7942237901969d-02, 7.3551265617742d-03,
     |  -1.9908870957656d-02,-3.1942454117795d-02,-1.8479183726963d-02,
     |   1.0297030068998d-02, 3.1433776038290d-02, 2.7598477711606d-02,
     |   1.3704725469616d-03,-2.6411515531725d-02,-3.3265210040376d-02,
     |  -1.3342452860484d-02, 1.7561396683801d-02, 3.4568982836366d-02,
     |   2.3828801418888d-02,-6.1532341883051d-03,-3.1269224471562d-02,
     |  -3.1269224471562d-02,-6.1532341883051d-03, 2.3828801418888d-02,
     |   3.4568982836366d-02, 1.7561396683801d-02,-1.3342452860484d-02,
     |  -3.3265210040376d-02,-2.6411515531725d-02, 1.3704725469616d-03,
     |   2.7598477711606d-02, 3.1433776038290d-02, 1.0297030068999d-02,
     |  -1.8479183726963d-02,-3.1942454117795d-02,-1.9908870957656d-02,
     |   7.3551265617739d-03, 2.7942237901969d-02, 2.6012162938124d-02,
     |   3.9965984824748d-03,-2.0131847776509d-02,-2.7659144221763d-02,
     |  -1.3714056091510d-02, 9.8080708587445d-03, 2.4519877826974d-02,
     |   2.0071302643699d-02, 1.3023792248722d-03,-1.6851305429102d-02,
     |  -2.1556983367701d-02,-1.1195832469997d-02, 5.1953905544958d-03,
     |   1.6340333005348d-02, 1.7200325636573d-02, 1.0936736255444d-02,
     |   4.1168903142604d-03, 6.7470656993703d-04, 3.9524449394170d-06/
      data (zmn(lat, 4,21), lat = 1,72)/
     |   2.3784985102556d-07, 1.2013350832657d-04, 1.2847056631701d-03,
     |   5.2142472436884d-03, 1.2261421891589d-02, 1.9167566175203d-02,
     |   1.9923133775460d-02, 1.0434165130923d-02,-6.5208672070006d-03,
     |  -2.1045319476200d-02,-2.2410041628263d-02,-7.8087283583002d-03,
     |   1.3693195368705d-02, 2.6476209701316d-02, 1.9983208011918d-02,
     |  -2.2301535652501d-03,-2.3927585948565d-02,-2.8083178432755d-02,
     |  -1.0465083808541d-02, 1.6106698265692d-02, 3.1010830934957d-02,
     |   2.1954115383161d-02,-4.7597055087005d-03,-2.8480976933504d-02,
     |  -3.0238630818062d-02,-8.0307813874466d-03, 2.1033757836184d-02,
     |   3.3937904628614d-02, 2.0080261473238d-02,-9.9460868327264d-03,
     |  -3.2445941419799d-02,-2.9396504584206d-02,-2.9648232014137d-03,
     |   2.5997883796649d-02, 3.4463710016312d-02, 1.5620001101686d-02,
     |  -1.5620001101686d-02,-3.4463710016312d-02,-2.5997883796649d-02,
     |   2.9648232014137d-03, 2.9396504584206d-02, 3.2445941419799d-02,
     |   9.9460868327265d-03,-2.0080261473238d-02,-3.3937904628614d-02,
     |  -2.1033757836184d-02, 8.0307813874465d-03, 3.0238630818062d-02,
     |   2.8480976933504d-02, 4.7597055087005d-03,-2.1954115383161d-02,
     |  -3.1010830934957d-02,-1.6106698265692d-02, 1.0465083808541d-02,
     |   2.8083178432755d-02, 2.3927585948565d-02, 2.2301535652502d-03,
     |  -1.9983208011918d-02,-2.6476209701316d-02,-1.3693195368706d-02,
     |   7.8087283583000d-03, 2.2410041628263d-02, 2.1045319476200d-02,
     |   6.5208672070007d-03,-1.0434165130923d-02,-1.9923133775460d-02,
     |  -1.9167566175203d-02,-1.2261421891589d-02,-5.2142472436884d-03,
     |  -1.2847056631700d-03,-1.2013350832644d-04,-2.3784985099282d-07/
      data (zmn(lat, 5,21), lat = 1,72)/
     |   1.5981967285629d-07, 1.6665755325389d-05, 3.0974794489036d-04,
     |   1.8558425603082d-03, 6.1009266309715d-03, 1.3319203281264d-02,
     |   2.0767635189761d-02, 2.2993180921242d-02, 1.5370469507940d-02,
     |  -1.1968744437266d-03,-1.8606163547807d-02,-2.5668251515314d-02,
     |  -1.6154059678501d-02, 5.1815086793669d-03, 2.4208202742034d-02,
     |   2.6850971256065d-02, 9.9310096633959d-03,-1.5195601370465d-02,
     |  -3.0058625447582d-02,-2.2819038669614d-02, 2.0493344320107d-03,
     |   2.6213644574194d-02, 3.1020045466197d-02, 1.2069239765390d-02,
     |  -1.6702447099947d-02,-3.3223963423902d-02,-2.4325365484865d-02,
     |   3.6391963381253d-03, 2.9243220064016d-02, 3.2461764138023d-02,
     |   1.0441520436577d-02,-1.9944643022253d-02,-3.5054064617946d-02,
     |  -2.2960047768494d-02, 7.0682181037419d-03, 3.1680627787757d-02,
     |   3.1680627787757d-02, 7.0682181037420d-03,-2.2960047768493d-02,
     |  -3.5054064617946d-02,-1.9944643022253d-02, 1.0441520436577d-02,
     |   3.2461764138023d-02, 2.9243220064016d-02, 3.6391963381253d-03,
     |  -2.4325365484865d-02,-3.3223963423902d-02,-1.6702447099947d-02,
     |   1.2069239765390d-02, 3.1020045466197d-02, 2.6213644574194d-02,
     |   2.0493344320111d-03,-2.2819038669614d-02,-3.0058625447582d-02,
     |  -1.5195601370466d-02, 9.9310096633958d-03, 2.6850971256065d-02,
     |   2.4208202742034d-02, 5.1815086793669d-03,-1.6154059678501d-02,
     |  -2.5668251515314d-02,-1.8606163547807d-02,-1.1968744437267d-03,
     |   1.5370469507940d-02, 2.2993180921242d-02, 2.0767635189761d-02,
     |   1.3319203281264d-02, 6.1009266309716d-03, 1.8558425603082d-03,
     |   3.0974794489029d-04, 1.6665755325408d-05, 1.5981967285298d-07/
      data (zmn(lat, 6,21), lat = 1,72)/
     |   5.9285540892768d-09, 1.9130408655227d-06, 6.0614225723266d-05,
     |   5.2743474785241d-04, 2.3539072611337d-03, 6.8003279544489d-03,
     |   1.4127764622125d-02, 2.2035349125452d-02, 2.5612232207145d-02,
     |   1.9978972873129d-02, 4.5151250287617d-03,-1.4611688473739d-02,
     |  -2.6658979113811d-02,-2.3049795379725d-02,-4.3285477811734d-03,
     |   1.8352273227392d-02, 2.9651165160427d-02, 2.0769302295390d-02,
     |  -3.2589021346697d-03,-2.5920119209726d-02,-3.0576453051816d-02,
     |  -1.2959137127404d-02, 1.4786643215063d-02, 3.2332477882526d-02,
     |   2.6177847810670d-02, 2.4040436475202d-04,-2.6425573357221d-02,
     |  -3.3647489193817d-02,-1.5535414899282d-02, 1.4612901919904d-02,
     |   3.4048537518237d-02, 2.7826130914816d-02, 4.0303710735907d-04,
     |  -2.7506797669448d-02,-3.4637491646783d-02,-1.5467093110857d-02,
     |   1.5467093110857d-02, 3.4637491646783d-02, 2.7506797669448d-02,
     |  -4.0303710735904d-04,-2.7826130914816d-02,-3.4048537518237d-02,
     |  -1.4612901919904d-02, 1.5535414899282d-02, 3.3647489193817d-02,
     |   2.6425573357221d-02,-2.4040436475195d-04,-2.6177847810670d-02,
     |  -3.2332477882527d-02,-1.4786643215063d-02, 1.2959137127404d-02,
     |   3.0576453051816d-02, 2.5920119209726d-02, 3.2589021346698d-03,
     |  -2.0769302295390d-02,-2.9651165160427d-02,-1.8352273227392d-02,
     |   4.3285477811735d-03, 2.3049795379725d-02, 2.6658979113811d-02,
     |   1.4611688473739d-02,-4.5151250287617d-03,-1.9978972873129d-02,
     |  -2.5612232207145d-02,-2.2035349125452d-02,-1.4127764622125d-02,
     |  -6.8003279544489d-03,-2.3539072611338d-03,-5.2743474785241d-04,
     |  -6.0614225723292d-05,-1.9130408656035d-06,-5.9285541226414d-09/
      data (zmn(lat, 7,21), lat = 1,72)/
     |  -2.9944540041405d-09, 1.8820919767763d-07, 9.9339012048117d-06,
     |   1.2435990845852d-04, 7.4174809592019d-04, 2.7643988275075d-03,
     |   7.3189960083590d-03, 1.4690431283643d-02, 2.2976188310627d-02,
     |   2.7800690114826d-02, 2.4231162641733d-02, 1.0437324233407d-02,
     |  -9.3411119983874d-03,-2.5454065631206d-02,-2.8008272407729d-02,
     |  -1.3842627992405d-02, 9.7256213584336d-03, 2.8114968605895d-02,
     |   2.8658289180709d-02, 9.8326225670210d-03,-1.6447673090316d-02,
     |  -3.2149308403067d-02,-2.5674862705523d-02,-7.5224755023237d-04,
     |   2.5348699576487d-02, 3.3764667153536d-02, 1.7862038610613d-02,
     |  -1.1352488946363d-02,-3.2745920394784d-02,-3.0428263090910d-02,
     |  -5.7111349525854d-03, 2.3468501534209d-02, 3.5587633235798d-02,
     |   2.1521808291011d-02,-8.4978103351299d-03,-3.2327636607613d-02,
     |  -3.2327636607613d-02,-8.4978103351300d-03, 2.1521808291010d-02,
     |   3.5587633235798d-02, 2.3468501534209d-02,-5.7111349525854d-03,
     |  -3.0428263090910d-02,-3.2745920394784d-02,-1.1352488946363d-02,
     |   1.7862038610613d-02, 3.3764667153536d-02, 2.5348699576487d-02,
     |  -7.5224755023228d-04,-2.5674862705523d-02,-3.2149308403067d-02,
     |  -1.6447673090316d-02, 9.8326225670208d-03, 2.8658289180708d-02,
     |   2.8114968605895d-02, 9.7256213584337d-03,-1.3842627992405d-02,
     |  -2.8008272407729d-02,-2.5454065631206d-02,-9.3411119983875d-03,
     |   1.0437324233407d-02, 2.4231162641733d-02, 2.7800690114826d-02,
     |   2.2976188310627d-02, 1.4690431283643d-02, 7.3189960083590d-03,
     |   2.7643988275075d-03, 7.4174809592016d-04, 1.2435990845857d-04,
     |   9.9339012048308d-06, 1.8820919766375d-07,-2.9944540253687d-09/
      data (zmn(lat, 8,21), lat = 1,72)/
     |  -8.0628108794121d-11, 1.5621192156611d-08, 1.3930061539059d-06,
     |   2.4924844260051d-05, 1.9681724286924d-04, 9.3277418982814d-04,
     |   3.0775974566997d-03, 7.6568968636217d-03, 1.5001405296186d-02,
     |   2.3578768899703d-02, 2.9547751347151d-02, 2.8080015308204d-02,
     |   1.6419070952805d-02,-3.0246823991638d-03,-2.2138061790992d-02,
     |  -3.0649759911189d-02,-2.2452669354656d-02,-7.1834196353573d-04,
     |   2.2376227509341d-02, 3.2354544695181d-02, 2.1927244258872d-02,
     |  -3.1979372413855d-03,-2.6959133270324d-02,-3.3202375083050d-02,
     |  -1.6962820644704d-02, 1.1324661345813d-02, 3.2338163439049d-02,
     |   3.1155300056087d-02, 8.0776888450111d-03,-2.1024991396340d-02,
     |  -3.5601602387671d-02,-2.5058340951796d-02, 3.3958604086992d-03,
     |   2.9614709253768d-02, 3.4842639120631d-02, 1.5241392887328d-02,
     |  -1.5241392887328d-02,-3.4842639120631d-02,-2.9614709253768d-02,
     |  -3.3958604086992d-03, 2.5058340951796d-02, 3.5601602387671d-02,
     |   2.1024991396340d-02,-8.0776888450109d-03,-3.1155300056087d-02,
     |  -3.2338163439049d-02,-1.1324661345813d-02, 1.6962820644704d-02,
     |   3.3202375083050d-02, 2.6959133270324d-02, 3.1979372413855d-03,
     |  -2.1927244258871d-02,-3.2354544695181d-02,-2.2376227509341d-02,
     |   7.1834196353561d-04, 2.2452669354655d-02, 3.0649759911189d-02,
     |   2.2138061790992d-02, 3.0246823991637d-03,-1.6419070952805d-02,
     |  -2.8080015308204d-02,-2.9547751347151d-02,-2.3578768899703d-02,
     |  -1.5001405296186d-02,-7.6568968636217d-03,-3.0775974566998d-03,
     |  -9.3277418982822d-04,-1.9681724286924d-04,-2.4924844260035d-05,
     |  -1.3930061538769d-06,-1.5621192135943d-08, 8.0628120907745d-11/
      data (zmn(lat, 9,21), lat = 1,72)/
     |   6.1497457744201d-11, 1.0645477444450d-09, 1.6956352543186d-07,
     |   4.3166138212930d-06, 4.4847317924285d-05, 2.6786160394257d-04,
     |   1.0869961180418d-03, 3.2863323716742d-03, 7.8112298339044d-03,
     |   1.5050363961964d-02, 2.3820956689035d-02, 3.0818848530617d-02,
     |   3.1452791126373d-02, 2.2303412092485d-02, 4.1153142852992d-03,
     |  -1.6816523247185d-02,-3.0665932413783d-02,-2.9293848607964d-02,
     |  -1.1885472824570d-02, 1.2956224450680d-02, 3.1039804079866d-02,
     |   3.0902395912949d-02, 1.1601834714782d-02,-1.5555968577876d-02,
     |  -3.3403187458747d-02,-2.9925633676965d-02,-6.6964345268903d-03,
     |   2.1399003124188d-02, 3.5632429873869d-02, 2.6081122207028d-02,
     |  -1.2310012204974d-03,-2.7983397722252d-02,-3.5886833373064d-02,
     |  -1.9331118937751d-02, 1.0520612481170d-02, 3.3253546377589d-02,
     |   3.3253546377589d-02, 1.0520612481170d-02,-1.9331118937751d-02,
     |  -3.5886833373064d-02,-2.7983397722252d-02,-1.2310012204974d-03,
     |   2.6081122207028d-02, 3.5632429873869d-02, 2.1399003124188d-02,
     |  -6.6964345268902d-03,-2.9925633676965d-02,-3.3403187458747d-02,
     |  -1.5555968577876d-02, 1.1601834714782d-02, 3.0902395912949d-02,
     |   3.1039804079866d-02, 1.2956224450680d-02,-1.1885472824570d-02,
     |  -2.9293848607964d-02,-3.0665932413783d-02,-1.6816523247185d-02,
     |   4.1153142852992d-03, 2.2303412092485d-02, 3.1452791126373d-02,
     |   3.0818848530617d-02, 2.3820956689035d-02, 1.5050363961964d-02,
     |   7.8112298339044d-03, 3.2863323716742d-03, 1.0869961180418d-03,
     |   2.6786160394255d-04, 4.4847317924289d-05, 4.3166138212585d-06,
     |   1.6956352540386d-07, 1.0645477143434d-09, 6.1497442162915d-11/
      data (zmn(lat,10,21), lat = 1,72)/
     |   1.2710519982929d-12, 6.7591305478054d-11, 1.8083190940482d-08,
     |   6.5328429774176d-07, 8.8915239171343d-06, 6.6524130612024d-05,
     |   3.2923118650955d-04, 1.1951086024495d-03, 3.3858430139529d-03,
     |   7.7791389564693d-03, 1.4825964832427d-02, 2.3674660045670d-02,
     |   3.1561493826450d-02, 3.4248552798707d-02, 2.7905310486160d-02,
     |   1.1828046271312d-02,-9.6444597955826d-03,-2.7822836863058d-02,
     |  -3.3529659765500d-02,-2.2524124989775d-02, 7.9788241832911d-04,
     |   2.4420654999511d-02, 3.4838361783948d-02, 2.5186607306831d-02,
     |   2.6586271433534d-04,-2.5368118443324d-02,-3.5861138436185d-02,
     |  -2.4133949814387d-02, 3.0174706940291d-03, 2.8622224922780d-02,
     |   3.6171637478669d-02, 2.0462696332123d-02,-8.6319014453264d-03,
     |  -3.2298529604664d-02,-3.5032114644226d-02,-1.4928614125941d-02,
     |   1.4928614125941d-02, 3.5032114644226d-02, 3.2298529604664d-02,
     |   8.6319014453264d-03,-2.0462696332123d-02,-3.6171637478669d-02,
     |  -2.8622224922780d-02,-3.0174706940294d-03, 2.4133949814386d-02,
     |   3.5861138436185d-02, 2.5368118443324d-02,-2.6586271433510d-04,
     |  -2.5186607306831d-02,-3.4838361783948d-02,-2.4420654999511d-02,
     |  -7.9788241832945d-04, 2.2524124989775d-02, 3.3529659765500d-02,
     |   2.7822836863058d-02, 9.6444597955827d-03,-1.1828046271312d-02,
     |  -2.7905310486160d-02,-3.4248552798707d-02,-3.1561493826450d-02,
     |  -2.3674660045670d-02,-1.4825964832427d-02,-7.7791389564693d-03,
     |  -3.3858430139530d-03,-1.1951086024495d-03,-3.2923118650946d-04,
     |  -6.6524130611919d-05,-8.8915239171021d-06,-6.5328429766097d-07,
     |  -1.8083190909271d-08,-6.7591291567383d-11,-1.2710642013317d-12/
      data (zmn(lat,11,21), lat = 1,72)/
     |  -1.1209637362185d-12, 4.9376798427360d-12, 1.7005908934262d-09,
     |   8.7054777816534d-08, 1.5473278330428d-06, 1.4439345739528d-05,
     |   8.6644702555110d-05, 3.7464935224399d-04, 1.2512788559140d-03,
     |   3.3743199988599d-03, 7.5600802509630d-03, 1.4319184531827d-02,
     |   2.3110700533092d-02, 3.1711421017799d-02, 3.6339396934167d-02,
     |   3.2997829535771d-02, 1.9801821968579d-02,-8.6788683391689d-04,
     |  -2.1997763701401d-02,-3.4376118765528d-02,-3.1226799692405d-02,
     |  -1.2680353851685d-02, 1.2887817973498d-02, 3.2284175725131d-02,
     |   3.4494516427025d-02, 1.7428161231357d-02,-9.9367214410048d-03,
     |  -3.2003166256480d-02,-3.5538830005645d-02,-1.7918566805433d-02,
     |   1.0700840266383d-02, 3.3106334741527d-02, 3.5475993811322d-02,
     |   1.6101975257699d-02,-1.3263043189167d-02,-3.4532442283148d-02,
     |  -3.4532442283148d-02,-1.3263043189167d-02, 1.6101975257699d-02,
     |   3.5475993811322d-02, 3.3106334741527d-02, 1.0700840266382d-02,
     |  -1.7918566805433d-02,-3.5538830005645d-02,-3.2003166256480d-02,
     |  -9.9367214410049d-03, 1.7428161231357d-02, 3.4494516427025d-02,
     |   3.2284175725131d-02, 1.2887817973498d-02,-1.2680353851685d-02,
     |  -3.1226799692405d-02,-3.4376118765528d-02,-2.1997763701401d-02,
     |  -8.6788683391691d-04, 1.9801821968579d-02, 3.2997829535771d-02,
     |   3.6339396934167d-02, 3.1711421017799d-02, 2.3110700533092d-02,
     |   1.4319184531827d-02, 7.5600802509630d-03, 3.3743199988600d-03,
     |   1.2512788559141d-03, 3.7464935224399d-04, 8.6644702555050d-05,
     |   1.4439345739549d-05, 1.5473278331184d-06, 8.7054777794510d-08,
     |   1.7005909199406d-09, 4.9377256475612d-12,-1.1209405703729d-12/
      data (zmn(lat,12,21), lat = 1,72)/
     |  -1.8381795061328d-14, 2.4451762456884d-13, 1.4181059268179d-10,
     |   1.0262199769407d-08, 2.3764767789780d-07, 2.7572952093806d-06,
     |   1.9976694335568d-05, 1.0232169326879d-04, 3.9989401947994d-04,
     |   1.2530276757696d-03, 3.2537564000278d-03, 7.1581029298281d-03,
     |   1.3526964594641d-02, 2.2104550031926d-02, 3.1200488144845d-02,
     |   3.7576110102409d-02, 3.7306069894170d-02, 2.7637347456075d-02,
     |   9.1264431225591d-03,-1.3247070808323d-02,-3.1175828095192d-02,
     |  -3.6481521170532d-02,-2.5552024827258d-02,-2.2873197677051d-03,
     |   2.2643931745907d-02, 3.6608679353437d-02, 3.1742152188936d-02,
     |   9.8533679951566d-03,-1.7726426387576d-02,-3.5886014671355d-02,
     |  -3.4186771054464d-02,-1.3158636693821d-02, 1.5527714154570d-02,
     |   3.5493425689961d-02, 3.5128230849190d-02, 1.4505671861379d-02,
     |  -1.4505671861379d-02,-3.5128230849190d-02,-3.5493425689961d-02,
     |  -1.5527714154570d-02, 1.3158636693821d-02, 3.4186771054464d-02,
     |   3.5886014671355d-02, 1.7726426387576d-02,-9.8533679951565d-03,
     |  -3.1742152188936d-02,-3.6608679353437d-02,-2.2643931745907d-02,
     |   2.2873197677051d-03, 2.5552024827258d-02, 3.6481521170532d-02,
     |   3.1175828095192d-02, 1.3247070808323d-02,-9.1264431225590d-03,
     |  -2.7637347456075d-02,-3.7306069894170d-02,-3.7576110102409d-02,
     |  -3.1200488144845d-02,-2.2104550031926d-02,-1.3526964594641d-02,
     |  -7.1581029298280d-03,-3.2537564000278d-03,-1.2530276757697d-03,
     |  -3.9989401947990d-04,-1.0232169326877d-04,-1.9976694335585d-05,
     |  -2.7572952094143d-06,-2.3764767787681d-07,-1.0262199814975d-08,
     |  -1.4181068710481d-10,-2.4458423012659d-13, 1.8367746943793d-14/
      data (zmn(lat,13,21), lat = 1,72)/
     |   1.7743195045283d-14,-7.4014069614534d-15, 1.0515882015241d-11,
     |   1.0725176047834d-09, 3.2301608166040d-08, 4.6484748669396d-07,
     |   4.0534956546751d-06, 2.4494357148053d-05, 1.1142886967399d-04,
     |   4.0289371027614d-04, 1.2013755363142d-03, 3.0308982203825d-03,
     |   6.5841291991807d-03, 1.2456317053230d-02, 2.0643421431660d-02,
     |   2.9967512244872d-02, 3.7799895386611d-02, 4.0511072358503d-02,
     |   3.4830749229540d-02, 1.9759858075278d-02,-1.9006016252438d-03,
     |  -2.3531579594186d-02,-3.6808081139033d-02,-3.5430618108158d-02,
     |  -1.8777650862636d-02, 6.6703457452906d-03, 2.9481444774265d-02,
     |   3.8491642762352d-02, 2.8650521914914d-02, 4.2572388559946d-03,
     |  -2.2589862730336d-02,-3.7971182203011d-02,-3.3561974723242d-02,
     |  -1.1388364180184d-02, 1.6932247724920d-02, 3.6295350247659d-02,
     |   3.6295350247659d-02, 1.6932247724921d-02,-1.1388364180184d-02,
     |  -3.3561974723242d-02,-3.7971182203011d-02,-2.2589862730336d-02,
     |   4.2572388559945d-03, 2.8650521914914d-02, 3.8491642762352d-02,
     |   2.9481444774265d-02, 6.6703457452906d-03,-1.8777650862636d-02,
     |  -3.5430618108158d-02,-3.6808081139033d-02,-2.3531579594186d-02,
     |  -1.9006016252441d-03, 1.9759858075278d-02, 3.4830749229540d-02,
     |   4.0511072358502d-02, 3.7799895386611d-02, 2.9967512244872d-02,
     |   2.0643421431660d-02, 1.2456317053230d-02, 6.5841291991808d-03,
     |   3.0308982203825d-03, 1.2013755363141d-03, 4.0289371027607d-04,
     |   1.1142886967395d-04, 2.4494357148021d-05, 4.0534956546520d-06,
     |   4.6484748664699d-07, 3.2301608091488d-08, 1.0725176788171d-09,
     |   1.0515914322714d-11,-7.4138004539245d-15, 1.7782632234547d-14/
      data (zmn(lat,14,21), lat = 1,72)/
     |   1.2054023772499d-16,-3.5580936630845d-16, 6.9071789311084d-13,
     |   9.9362035877076d-11, 3.8863443552033d-09, 6.9238504217758d-08,
     |   7.2492528267167d-07, 5.1520729400334d-06, 2.7174841074984d-05,
     |   1.1281485069396d-04, 3.8381015607299d-04, 1.1010377227344d-03,
     |   2.7181170357107d-03, 5.8581374860578d-03, 1.1128791373569d-02,
     |   1.8734846017186d-02, 2.7972880496219d-02, 3.6862209559259d-02,
     |   4.2267786739908d-02, 4.0774105837609d-02, 3.0220997762903d-02,
     |   1.1328389697919d-02,-1.1502630857391d-02,-3.1015210906142d-02,
     |  -3.9678787197685d-02,-3.3159504116408d-02,-1.3027100621146d-02,
     |   1.2957447506259d-02, 3.3642691445507d-02, 3.9443234166745d-02,
     |   2.7149853444229d-02, 2.0202800581640d-03,-2.4259064695612d-02,
     |  -3.9042699509949d-02,-3.4998583788382d-02,-1.3933644833662d-02,
     |   1.3933644833662d-02, 3.4998583788382d-02, 3.9042699509949d-02,
     |   2.4259064695612d-02,-2.0202800581640d-03,-2.7149853444229d-02,
     |  -3.9443234166745d-02,-3.3642691445507d-02,-1.2957447506259d-02,
     |   1.3027100621146d-02, 3.3159504116408d-02, 3.9678787197685d-02,
     |   3.1015210906142d-02, 1.1502630857391d-02,-1.1328389697919d-02,
     |  -3.0220997762903d-02,-4.0774105837609d-02,-4.2267786739908d-02,
     |  -3.6862209559259d-02,-2.7972880496219d-02,-1.8734846017186d-02,
     |  -1.1128791373568d-02,-5.8581374860578d-03,-2.7181170357107d-03,
     |  -1.1010377227345d-03,-3.8381015607294d-04,-1.1281485069394d-04,
     |  -2.7174841074942d-05,-5.1520729400102d-06,-7.2492528259907d-07,
     |  -6.9238504176421d-08,-3.8863443777636d-09,-9.9362013536076d-11,
     |  -6.9062268754489d-13, 4.1605707807378d-16,-1.1222133717579d-16/
      data (zmn(lat,15,21), lat = 1,72)/
     |  -2.4152448578099d-16, 2.0942106437096d-16, 3.9869629656747d-14,
     |   8.1374039870369d-12, 4.1285900579502d-10, 9.0923970253487d-09,
     |   1.1408300654103d-07, 9.5130500513180d-07, 5.8003713063460d-06,
     |   2.7544400079967d-05, 1.0641352735844d-04, 3.4503882298943d-04,
     |   9.6049318484268d-04, 2.3339919668561d-03, 5.0109689889163d-03,
     |   9.5848873671438d-03, 1.6416355553759d-02, 2.5217132206044d-02,
     |   3.4654490268582d-02, 4.2242342839798d-02, 4.4785058806318d-02,
     |   3.9455432387274d-02, 2.5242625730255d-02, 4.1509231378513d-03,
     |  -1.8602692540005d-02,-3.5874186193576d-02,-4.1186577482162d-02,
     |  -3.1686012581394d-02,-1.0057041951296d-02, 1.5790668422902d-02,
     |   3.5529886040064d-02, 4.0733952506024d-02, 2.8791575535712d-02,
     |   4.4624623193796d-03,-2.1894265576292d-02,-3.8794922597924d-02,
     |  -3.8794922597924d-02,-2.1894265576292d-02, 4.4624623193795d-03,
     |   2.8791575535712d-02, 4.0733952506024d-02, 3.5529886040064d-02,
     |   1.5790668422902d-02,-1.0057041951296d-02,-3.1686012581394d-02,
     |  -4.1186577482162d-02,-3.5874186193576d-02,-1.8602692540006d-02,
     |   4.1509231378513d-03, 2.5242625730255d-02, 3.9455432387274d-02,
     |   4.4785058806318d-02, 4.2242342839798d-02, 3.4654490268582d-02,
     |   2.5217132206045d-02, 1.6416355553759d-02, 9.5848873671438d-03,
     |   5.0109689889162d-03, 2.3339919668562d-03, 9.6049318484272d-04,
     |   3.4503882298940d-04, 1.0641352735848d-04, 2.7544400080064d-05,
     |   5.8003713063779d-06, 9.5130500515755d-07, 1.1408300659052d-07,
     |   9.0923971105045d-09, 4.1285908129373d-10, 8.1373969626760d-12,
     |   3.9902350649962d-14, 2.5113717349276d-16,-2.3749374293848d-16/
      data (zmn(lat,16,21), lat = 1,72)/
     |  -9.4209557202823d-17,-7.0998790806947d-17, 1.9671365459015d-15,
     |   5.8554900832407d-13, 3.8504915185318d-11, 1.0469759336100d-09,
     |   1.5718464618394d-08, 1.5349358000750d-07, 1.0793312685951d-06,
     |   5.8459099178523d-06, 2.5555023360727d-05, 9.3240341447474d-05,
     |   2.9104972035595d-04, 7.9175777966829d-04, 1.9033244298471d-03,
     |   4.0852734827111d-03, 7.8875779090206d-03, 1.3765099496089d-02,
     |   2.1762463812744d-02, 3.1148174565533d-02, 4.0173443478589d-02,
     |   4.6179898262539d-02, 4.6215544370123d-02, 3.8116057723477d-02,
     |   2.1725833010058d-02,-2.9161167346716d-04,-2.2609705413061d-02,
     |  -3.8615204854946d-02,-4.2717629301513d-02,-3.2756786557490d-02,
     |  -1.1420883259243d-02, 1.4161638146078d-02, 3.4768845664062d-02,
     |   4.2581174689900d-02, 3.4399064271896d-02, 1.3140866951880d-02,
     |  -1.3140866951880d-02,-3.4399064271896d-02,-4.2581174689900d-02,
     |  -3.4768845664062d-02,-1.4161638146078d-02, 1.1420883259243d-02,
     |   3.2756786557490d-02, 4.2717629301513d-02, 3.8615204854946d-02,
     |   2.2609705413061d-02, 2.9161167346723d-04,-2.1725833010058d-02,
     |  -3.8116057723477d-02,-4.6215544370123d-02,-4.6179898262539d-02,
     |  -4.0173443478589d-02,-3.1148174565533d-02,-2.1762463812744d-02,
     |  -1.3765099496089d-02,-7.8875779090207d-03,-4.0852734827110d-03,
     |  -1.9033244298471d-03,-7.9175777966820d-04,-2.9104972035591d-04,
     |  -9.3240341447372d-05,-2.5555023360745d-05,-5.8459099177794d-06,
     |  -1.0793312686176d-06,-1.5349358003339d-07,-1.5718464721189d-08,
     |  -1.0469759857613d-09,-3.8504949696500d-11,-5.8558123738059d-13,
     |  -1.9930179119777d-15,-1.1264070905610d-18, 6.6654312015110d-17/
      data (zmn(lat,17,21), lat = 1,72)/
     |  -3.8211323184766d-17,-1.1501436876927d-16,-5.5161219077549d-17,
     |   3.6508550744582d-14, 3.1207994350105d-12, 1.0466713260827d-10,
     |   1.8778933961275d-09, 2.1441801067292d-08, 1.7355409275615d-07,
     |   1.0696850974193d-06, 5.2763094606447d-06, 2.1589283222877d-05,
     |   7.5253426390377d-05, 2.2799390512516d-04, 6.0969511556539d-04,
     |   1.4562516079636d-03, 3.1349057738122d-03, 6.1235947928196d-03,
     |   1.0905111235895d-02, 1.7754012788553d-02, 2.6442213653360d-02,
     |   3.5959200462929d-02, 4.4403572710467d-02, 4.9208558536086d-02,
     |   4.7779015638163d-02, 3.8443821735361d-02, 2.1424322941193d-02,
     |  -6.1094285968223d-04,-2.2792668083142d-02,-3.9233980759069d-02,
     |  -4.4893405815262d-02,-3.7491206926293d-02,-1.8698339550568d-02,
     |   6.0025553222312d-03, 2.8900470273954d-02, 4.2600461611412d-02,
     |   4.2600461611412d-02, 2.8900470273954d-02, 6.0025553222313d-03,
     |  -1.8698339550568d-02,-3.7491206926293d-02,-4.4893405815262d-02,
     |  -3.9233980759069d-02,-2.2792668083142d-02,-6.1094285968226d-04,
     |   2.1424322941193d-02, 3.8443821735360d-02, 4.7779015638163d-02,
     |   4.9208558536086d-02, 4.4403572710467d-02, 3.5959200462929d-02,
     |   2.6442213653360d-02, 1.7754012788553d-02, 1.0905111235895d-02,
     |   6.1235947928196d-03, 3.1349057738121d-03, 1.4562516079636d-03,
     |   6.0969511556542d-04, 2.2799390512521d-04, 7.5253426390383d-05,
     |   2.1589283222884d-05, 5.2763094606084d-06, 1.0696850973757d-06,
     |   1.7355409276094d-07, 2.1441801048769d-08, 1.8778933514327d-09,
     |   1.0466704272662d-10, 3.1208047580976d-12, 3.6515458078480d-14,
     |  -1.6094184420163d-17,-1.6695317151242d-16,-5.4962174819324d-17/
      data (zmn(lat,18,21), lat = 1,72)/
     |   1.0178483711830d-17, 1.7579441511976d-18,-7.3479249244863d-18,
     |   1.9258272569174d-15, 2.1607598510102d-13, 8.9329158589498d-12,
     |   1.9133447298698d-10, 2.5511867039411d-09, 2.3733224415643d-08,
     |   1.6614891017946d-07, 9.2269171903013d-07, 4.2226486087135d-06,
     |   1.6383188340723d-05, 5.5064061055183d-05, 1.6302140277331d-04,
     |   4.3072517437433d-04, 1.0261163483776d-03, 2.2219444241776d-03,
     |   4.4006273201678d-03, 8.0085685223322d-03, 1.3434702522861d-02,
     |   2.0809521240201d-02, 2.9761924687230d-02, 3.9220423928653d-02,
     |   4.7378228837913d-02, 5.1929961748634d-02, 5.0614013329719d-02,
     |   4.1969273261071d-02, 2.6081798936696d-02, 5.0207075061065d-03,
     |  -1.7299907053802d-02,-3.5929435958305d-02,-4.6205439472231d-02,
     |  -4.5203364308211d-02,-3.2806601739335d-02,-1.1971966032525d-02,
     |   1.1971966032525d-02, 3.2806601739335d-02, 4.5203364308211d-02,
     |   4.6205439472231d-02, 3.5929435958305d-02, 1.7299907053802d-02,
     |  -5.0207075061064d-03,-2.6081798936696d-02,-4.1969273261071d-02,
     |  -5.0614013329719d-02,-5.1929961748634d-02,-4.7378228837913d-02,
     |  -3.9220423928653d-02,-2.9761924687230d-02,-2.0809521240201d-02,
     |  -1.3434702522861d-02,-8.0085685223322d-03,-4.4006273201678d-03,
     |  -2.2219444241776d-03,-1.0261163483776d-03,-4.3072517437437d-04,
     |  -1.6302140277327d-04,-5.5064061055183d-05,-1.6383188340768d-05,
     |  -4.2226486087566d-06,-9.2269171899606d-07,-1.6614891024525d-07,
     |  -2.3733224422710d-08,-2.5511866981136d-09,-1.9133447788562d-10,
     |  -8.9329586957554d-12,-2.1603634380312d-13,-1.9279600653148d-15,
     |  -6.2175992319561d-17, 5.9943239419400d-17,-2.0029402807459d-17/
      data (zmn(lat,19,21), lat = 1,72)/
     |  -4.8860177462326d-17,-1.2458050783131d-16,-1.8144306950183d-16,
     |  -1.3039316776832d-16, 1.2211627420236d-14, 6.3200408849573d-13,
     |   1.6150840389480d-11, 2.5121549183083d-10, 2.6825581683784d-09,
     |   2.1298539623791d-08, 1.3292585091103d-07, 6.7893251098801d-07,
     |   2.9245392601423d-06, 1.0871189741613d-05, 3.5501867747545d-05,
     |   1.0330332734987d-04, 2.7087176247183d-04, 6.4585334327035d-04,
     |   1.4105531261643d-03, 2.8383157117101d-03, 5.2861116331486d-03,
     |   9.1436741127327d-03, 1.4725130010606d-02, 2.2106872067464d-02,
     |   3.0943895986794d-02, 4.0327137009608d-02, 4.8761498357069d-02,
     |   5.4332722394599d-02, 5.5083465437951d-02, 4.9542852988461d-02,
     |   3.7274445031848d-02, 1.9259741231264d-02,-2.0520350458443d-03,
     |  -2.3113210868080d-02,-4.0018075770612d-02,-4.9430486272736d-02,
     |  -4.9430486272736d-02,-4.0018075770612d-02,-2.3113210868080d-02,
     |  -2.0520350458443d-03, 1.9259741231264d-02, 3.7274445031848d-02,
     |   4.9542852988461d-02, 5.5083465437951d-02, 5.4332722394599d-02,
     |   4.8761498357069d-02, 4.0327137009608d-02, 3.0943895986794d-02,
     |   2.2106872067465d-02, 1.4725130010606d-02, 9.1436741127327d-03,
     |   5.2861116331486d-03, 2.8383157117101d-03, 1.4105531261643d-03,
     |   6.4585334327029d-04, 2.7087176247184d-04, 1.0330332734983d-04,
     |   3.5501867747507d-05, 1.0871189741587d-05, 2.9245392601254d-06,
     |   6.7893251097031d-07, 1.3292585095057d-07, 2.1298539572743d-08,
     |   2.6825581234022d-09, 2.5121547775826d-10, 1.6150876222687d-11,
     |   6.3203914103406d-13, 1.2198904283435d-14,-1.3999073025602d-16,
     |  -2.2247738023992d-16,-4.3704773218100d-17,-7.2763176666291d-18/
      data (zmn(lat,20,21), lat = 1,72)/
     |  -8.6945358148022d-17,-9.0301768861676d-17,-1.0818614132238d-16,
     |  -1.1961674436831d-16, 4.3504150635040d-16, 3.4960984623529d-14,
     |   1.0678987877297d-12, 1.9360928255109d-11, 2.3705835735451d-10,
     |   2.1319009551617d-09, 1.4930690125818d-08, 8.4961945696465d-08,
     |   4.0548713942148d-07, 1.6629962120494d-06, 5.9733141062627d-06,
     |   1.9076680879225d-05, 5.4831507963092d-05, 1.4324869497215d-04,
     |   3.4292916449350d-04, 7.5730607106313d-04, 1.5512566148478d-03,
     |   2.9607848803115d-03, 5.2849334479055d-03, 8.8481487491027d-03,
     |   1.3925504674240d-02, 2.0633822645215d-02, 2.8807502397543d-02,
     |   3.7894089315151d-02, 4.6913990374067d-02, 5.4524135513209d-02,
     |   5.9203327971339d-02, 5.9540844516445d-02, 5.4570110797648d-02,
     |   4.4060890352960d-02, 2.8679865987670d-02, 9.9565493790154d-03,
     |  -9.9565493790153d-03,-2.8679865987670d-02,-4.4060890352960d-02,
     |  -5.4570110797648d-02,-5.9540844516445d-02,-5.9203327971339d-02,
     |  -5.4524135513209d-02,-4.6913990374067d-02,-3.7894089315151d-02,
     |  -2.8807502397543d-02,-2.0633822645215d-02,-1.3925504674240d-02,
     |  -8.8481487491027d-03,-5.2849334479055d-03,-2.9607848803115d-03,
     |  -1.5512566148478d-03,-7.5730607106313d-04,-3.4292916449348d-04,
     |  -1.4324869497214d-04,-5.4831507963049d-05,-1.9076680879202d-05,
     |  -5.9733141062805d-06,-1.6629962120741d-06,-4.0548713937159d-07,
     |  -8.4961945690836d-08,-1.4930690116348d-08,-2.1319009475163d-09,
     |  -2.3705839785861d-10,-1.9360942528860d-11,-1.0679028642626d-12,
     |  -3.4921663519549d-14,-5.0086770996929d-16, 1.2214046117728d-16,
     |   1.3371447236340d-16, 6.8521289212218d-17, 9.4962069643301d-17/
      data (zmn(lat,21,21), lat = 1,72)/
     |  -1.5972286101416d-17,-4.9991686972863d-17,-8.2803137157589d-17,
     |  -1.1852292799577d-16,-1.1976913292643d-16, 1.1738726260168d-15,
     |   4.7879856107683d-14, 1.0139560628819d-12, 1.4224616190137d-11,
     |   1.4474549631727d-10, 1.1361356948466d-09, 7.1923443688863d-09,
     |   3.7967208872241d-08, 1.7145857162582d-07, 6.7582014370782d-07,
     |   2.3624853710022d-06, 7.4198219233356d-06, 2.1159740709690d-05,
     |   5.5275854314095d-05, 1.3324743438703d-04, 2.9824147792382d-04,
     |   6.2307709181577d-04, 1.2204564603829d-03, 2.2499431066069d-03,
     |   3.9166577476504d-03, 6.4562455385690d-03, 1.0102244859850d-02,
     |   1.5036011090730d-02, 2.1325364716433d-02, 2.8864576315132d-02,
     |   3.7332774636133d-02, 4.6187936373629d-02, 5.4707898282234d-02,
     |   6.2078879036025d-02, 6.7518547362019d-02, 7.0408957742915d-02,
     |   7.0408957742915d-02, 6.7518547362019d-02, 6.2078879036025d-02,
     |   5.4707898282234d-02, 4.6187936373629d-02, 3.7332774636133d-02,
     |   2.8864576315132d-02, 2.1325364716433d-02, 1.5036011090730d-02,
     |   1.0102244859850d-02, 6.4562455385690d-03, 3.9166577476505d-03,
     |   2.2499431066069d-03, 1.2204564603829d-03, 6.2307709181577d-04,
     |   2.9824147792382d-04, 1.3324743438702d-04, 5.5275854314083d-05,
     |   2.1159740709714d-05, 7.4198219233131d-06, 2.3624853710102d-06,
     |   6.7582014370109d-07, 1.7145857161439d-07, 3.7967208886698d-08,
     |   7.1923443789279d-09, 1.1361356794389d-09, 1.4474552703234d-10,
     |   1.4224624361456d-11, 1.0139739792989d-12, 4.7878921843542d-14,
     |   1.1817072346338d-15,-1.1807368643189d-16,-8.0243357617688d-17,
     |  -7.3664415019704d-17,-6.6345267105300d-17,-3.6960904770049d-17/
      data (zmn(lat, 0,22), lat = 1,72)/
     |   3.6347015530797d-03, 7.4975978171831d-03,-8.2028753623231d-04,
     |  -1.1507726078284d-02,-1.3855936933613d-02,-1.9180503204072d-03,
     |   1.3892510816778d-02, 1.9042655406610d-02, 6.2866533220034d-03,
     |  -1.3723788493854d-02,-2.3110962122267d-02,-1.1536107225544d-02,
     |   1.1564377796862d-02, 2.5836381168087d-02, 1.7092928907842d-02,
     |  -7.7740388855370d-03,-2.7025639876907d-02,-2.2448440488341d-02,
     |   2.7149856843867d-03, 2.6573209092684d-02, 2.7149550811897d-02,
     |   3.2120026191325d-03,-2.4480119403003d-02,-3.0811833651258d-02,
     |  -9.5722726105232d-03, 2.0857729090284d-02, 3.3137074927682d-02,
     |   1.5916772772645d-02,-1.5921486213978d-02,-3.3928897874375d-02,
     |  -2.1807567929719d-02, 9.9766759399709d-03, 3.3103424043208d-02,
     |   2.6844978141747d-02,-3.3976728234744d-03,-3.0693381677037d-02,
     |  -3.0693381677037d-02,-3.3976728234745d-03, 2.6844978141747d-02,
     |   3.3103424043208d-02, 9.9766759399709d-03,-2.1807567929719d-02,
     |  -3.3928897874375d-02,-1.5921486213978d-02, 1.5916772772645d-02,
     |   3.3137074927682d-02, 2.0857729090285d-02,-9.5722726105229d-03,
     |  -3.0811833651258d-02,-2.4480119403003d-02, 3.2120026191325d-03,
     |   2.7149550811897d-02, 2.6573209092684d-02, 2.7149856843868d-03,
     |  -2.2448440488341d-02,-2.7025639876907d-02,-7.7740388855371d-03,
     |   1.7092928907842d-02, 2.5836381168087d-02, 1.1564377796862d-02,
     |  -1.1536107225544d-02,-2.3110962122267d-02,-1.3723788493854d-02,
     |   6.2866533220034d-03, 1.9042655406610d-02, 1.3892510816778d-02,
     |  -1.9180503204071d-03,-1.3855936933613d-02,-1.1507726078284d-02,
     |  -8.2028753623216d-04, 7.4975978171830d-03, 3.6347015530797d-03/
      data (zmn(lat, 1,22), lat = 1,72)/
     |   1.2473754655291d-03, 7.4346381256306d-03, 1.1498272823553d-02,
     |   5.1643507504074d-03,-8.3944236980782d-03,-1.7088992921177d-02,
     |  -1.0895065596908d-02, 6.6528543708707d-03, 2.0366483097886d-02,
     |   1.6564124136661d-02,-3.0378351881223d-03,-2.1674130779704d-02,
     |  -2.1801465852546d-02,-1.9131405525154d-03, 2.1106828820625d-02,
     |   2.6200388107666d-02, 7.7082297846071d-03,-1.8776942557825d-02,
     |  -2.9407673527832d-02,-1.3859000509811d-02, 1.4872995288386d-02,
     |   3.1156354123477d-02, 1.9885326945204d-02,-9.6697034560104d-03,
     |  -3.1284627340658d-02,-2.5335201459796d-02, 3.5188346386711d-03,
     |   2.9746194589612d-02, 2.9808913321248d-02, 3.1702481779876d-03,
     |  -2.6612601939186d-02,-3.2982625585702d-02,-9.9562027155400d-03,
     |   2.2067694529801d-02, 3.4628354744270d-02, 1.6394609981539d-02,
     |  -1.6394609981539d-02,-3.4628354744270d-02,-2.2067694529801d-02,
     |   9.9562027155399d-03, 3.2982625585702d-02, 2.6612601939186d-02,
     |  -3.1702481779875d-03,-2.9808913321248d-02,-2.9746194589612d-02,
     |  -3.5188346386712d-03, 2.5335201459796d-02, 3.1284627340658d-02,
     |   9.6697034560105d-03,-1.9885326945204d-02,-3.1156354123477d-02,
     |  -1.4872995288386d-02, 1.3859000509811d-02, 2.9407673527832d-02,
     |   1.8776942557825d-02,-7.7082297846070d-03,-2.6200388107666d-02,
     |  -2.1106828820625d-02, 1.9131405525155d-03, 2.1801465852546d-02,
     |   2.1674130779704d-02, 3.0378351881222d-03,-1.6564124136661d-02,
     |  -2.0366483097886d-02,-6.6528543708708d-03, 1.0895065596908d-02,
     |   1.7088992921177d-02, 8.3944236980784d-03,-5.1643507504074d-03,
     |  -1.1498272823553d-02,-7.4346381256307d-03,-1.2473754655291d-03/
      data (zmn(lat, 2,22), lat = 1,72)/
     |   1.5212876523210d-04, 3.0251150233189d-03, 9.9164035900057d-03,
     |   1.4703824893657d-02, 9.9813134409068d-03,-4.1839062421607d-03,
     |  -1.7347285038292d-02,-1.7250928411061d-02,-1.7062903712514d-03,
     |   1.7169064841463d-02, 2.2550519053460d-02, 8.0910899903391d-03,
     |  -1.4834695584563d-02,-2.6100256567943d-02,-1.4600991220361d-02,
     |   1.0733006206923d-02, 2.7829930244376d-02, 2.0775128235283d-02,
     |  -5.2554506443662d-03,-2.7683794875006d-02,-2.6162691716069d-02,
     |  -1.1624152716413d-03, 2.5693403174131d-02, 3.0367366127215d-02,
     |   8.0466678097352d-03,-2.1998145824364d-02,-3.3077291719149d-02,
     |  -1.4906772730479d-02, 1.6844876443428d-02, 3.4086730800503d-02,
     |   2.1263718971555d-02,-1.0575283720643d-02,-3.3309919774792d-02,
     |  -2.6679779479498d-02, 3.6047477199964d-03, 3.0786708573712d-02,
     |   3.0786708573712d-02, 3.6047477199965d-03,-2.6679779479498d-02,
     |  -3.3309919774792d-02,-1.0575283720643d-02, 2.1263718971555d-02,
     |   3.4086730800503d-02, 1.6844876443429d-02,-1.4906772730479d-02,
     |  -3.3077291719149d-02,-2.1998145824365d-02, 8.0466678097349d-03,
     |   3.0367366127215d-02, 2.5693403174131d-02,-1.1624152716412d-03,
     |  -2.6162691716069d-02,-2.7683794875006d-02,-5.2554506443663d-03,
     |   2.0775128235282d-02, 2.7829930244376d-02, 1.0733006206923d-02,
     |  -1.4600991220361d-02,-2.6100256567943d-02,-1.4834695584563d-02,
     |   8.0910899903391d-03, 2.2550519053460d-02, 1.7169064841463d-02,
     |  -1.7062903712513d-03,-1.7250928411060d-02,-1.7347285038292d-02,
     |  -4.1839062421607d-03, 9.9813134409067d-03, 1.4703824893657d-02,
     |   9.9164035900055d-03, 3.0251150233191d-03, 1.5212876523216d-04/
      data (zmn(lat, 3,22), lat = 1,72)/
     |   4.0587878045383d-06, 7.8279000130173d-04, 4.6624240512434d-03,
     |   1.1895136310080d-02, 1.7413538859419d-02, 1.4089360068345d-02,
     |   3.0127338219190d-04,-1.5779529767736d-02,-2.1223454447383d-02,
     |  -9.6594294652465d-03, 1.1239254179313d-02, 2.4389645417093d-02,
     |   1.7524548813318d-02,-5.0760395653124d-03,-2.4744045279053d-02,
     |  -2.3921968466935d-02,-2.0530278863558d-03, 2.2724838054394d-02,
     |   2.8634328576221d-02, 9.5621076509994d-03,-1.8679334614567d-02,
     |  -3.1442429815333d-02,-1.6884412164159d-02, 1.2995462170190d-02,
     |   3.2208447070378d-02, 2.3486508945668d-02,-6.1272131826671d-03,
     |  -3.0911159379987d-02,-2.8895801650368d-02,-1.4148410522951d-03,
     |   2.7658848044158d-02, 3.2728766739168d-02, 9.0880539943901d-03,
     |  -2.2687708040324d-02,-3.4715096167137d-02,-1.6349119437322d-02,
     |   1.6349119437322d-02, 3.4715096167137d-02, 2.2687708040324d-02,
     |  -9.0880539943900d-03,-3.2728766739168d-02,-2.7658848044158d-02,
     |   1.4148410522951d-03, 2.8895801650368d-02, 3.0911159379987d-02,
     |   6.1272131826672d-03,-2.3486508945668d-02,-3.2208447070378d-02,
     |  -1.2995462170190d-02, 1.6884412164159d-02, 3.1442429815333d-02,
     |   1.8679334614567d-02,-9.5621076509994d-03,-2.8634328576221d-02,
     |  -2.2724838054394d-02, 2.0530278863557d-03, 2.3921968466935d-02,
     |   2.4744045279053d-02, 5.0760395653123d-03,-1.7524548813318d-02,
     |  -2.4389645417093d-02,-1.1239254179313d-02, 9.6594294652464d-03,
     |   2.1223454447383d-02, 1.5779529767736d-02,-3.0127338219201d-04,
     |  -1.4089360068345d-02,-1.7413538859419d-02,-1.1895136310080d-02,
     |  -4.6624240512432d-03,-7.8279000130175d-04,-4.0587878044748d-06/
      data (zmn(lat, 4,22), lat = 1,72)/
     |   2.8889658655143d-07, 1.4630220147663d-04, 1.5366106737094d-03,
     |   6.0555439760455d-03, 1.3602249645363d-02, 1.9743507089293d-02,
     |   1.7739064148076d-02, 4.7999931208167d-03,-1.3010540536179d-02,
     |  -2.3204327973815d-02,-1.6530008590457d-02, 3.8569629451707d-03,
     |   2.2724338826151d-02, 2.4204128867988d-02, 5.5824692523999d-03,
     |  -1.8847047223731d-02,-2.8627829404866d-02,-1.4494941735806d-02,
     |   1.2689208940860d-02, 3.0113188901571d-02, 2.2275836295658d-02,
     |  -5.0558344067020d-03,-2.8893015560661d-02,-2.8423787878418d-02,
     |  -3.3240439610065d-03, 2.5256889223102d-02, 3.2550746804880d-02,
     |   1.1751132284267d-02,-1.9594014132047d-02,-3.4405091770115d-02,
     |  -1.9564849416535d-02, 1.2396299394192d-02, 3.3889548498070d-02,
     |   2.6170313164204d-02,-4.2406617192179d-03,-3.1069459901255d-02,
     |  -3.1069459901255d-02,-4.2406617192179d-03, 2.6170313164204d-02,
     |   3.3889548498070d-02, 1.2396299394192d-02,-1.9564849416535d-02,
     |  -3.4405091770115d-02,-1.9594014132047d-02, 1.1751132284267d-02,
     |   3.2550746804880d-02, 2.5256889223102d-02,-3.3240439610062d-03,
     |  -2.8423787878418d-02,-2.8893015560661d-02,-5.0558344067021d-03,
     |   2.2275836295658d-02, 3.0113188901571d-02, 1.2689208940860d-02,
     |  -1.4494941735806d-02,-2.8627829404866d-02,-1.8847047223731d-02,
     |   5.5824692524001d-03, 2.4204128867989d-02, 2.2724338826151d-02,
     |   3.8569629451707d-03,-1.6530008590457d-02,-2.3204327973815d-02,
     |  -1.3010540536179d-02, 4.7999931208166d-03, 1.7739064148076d-02,
     |   1.9743507089293d-02, 1.3602249645363d-02, 6.0555439760455d-03,
     |   1.5366106737095d-03, 1.4630220147654d-04, 2.8889658652484d-07/
      data (zmn(lat, 5,22), lat = 1,72)/
     |   2.2710782495138d-07, 2.1294526313690d-05, 3.9043415013106d-04,
     |   2.2851059478721d-03, 7.2586123822911d-03, 1.5075223848713d-02,
     |   2.1781086805867d-02, 2.1040702671565d-02, 9.2559754269464d-03,
     |  -9.3980808505418d-03,-2.3495684445555d-02,-2.2037865888992d-02,
     |  -4.0790742057534d-03, 1.8263378711531d-02, 2.7709236199706d-02,
     |   1.5596878700900d-02,-9.7766457358353d-03,-2.8405325245215d-02,
     |  -2.4461432911733d-02,-5.6669349937385d-05, 2.5319751696366d-02,
     |   3.0355387844863d-02, 1.0016532702051d-02,-1.9360572014484d-02,
     |  -3.3134713963569d-02,-1.9158661001864d-02, 1.1374468177887d-02,
     |   3.2823329372332d-02, 2.6718508568950d-02,-2.2121723919757d-03,
     |  -2.9623368145493d-02,-3.2101754940664d-02,-7.2701759759931d-03,
     |   2.3914238502515d-02, 3.4898301759785d-02, 1.6237601150942d-02,
     |  -1.6237601150942d-02,-3.4898301759785d-02,-2.3914238502515d-02,
     |   7.2701759759930d-03, 3.2101754940664d-02, 2.9623368145493d-02,
     |   2.2121723919758d-03,-2.6718508568950d-02,-3.2823329372332d-02,
     |  -1.1374468177887d-02, 1.9158661001864d-02, 3.3134713963569d-02,
     |   1.9360572014484d-02,-1.0016532702051d-02,-3.0355387844863d-02,
     |  -2.5319751696366d-02, 5.6669349937375d-05, 2.4461432911733d-02,
     |   2.8405325245215d-02, 9.7766457358354d-03,-1.5596878700900d-02,
     |  -2.7709236199706d-02,-1.8263378711531d-02, 4.0790742057532d-03,
     |   2.2037865888992d-02, 2.3495684445555d-02, 9.3980808505419d-03,
     |  -9.2559754269464d-03,-2.1040702671565d-02,-2.1781086805867d-02,
     |  -1.5075223848713d-02,-7.2586123822911d-03,-2.2851059478720d-03,
     |  -3.9043415013117d-04,-2.1294526313726d-05,-2.2710782506006d-07/
      data (zmn(lat, 6,22), lat = 1,72)/
     |   8.0858506838678d-09, 2.5711644966851d-06, 8.0469902416768d-05,
     |   6.8672676723312d-04, 2.9809773985732d-03, 8.2882645634923d-03,
     |   1.6326539202308d-02, 2.3560415382230d-02, 2.4055736609357d-02,
     |   1.3657252539009d-02,-5.1352939180071d-03,-2.2308852225672d-02,
     |  -2.6043032283132d-02,-1.1928810770719d-02, 1.1680369884003d-02,
     |   2.7951355122401d-02, 2.3817131643751d-02, 1.0461007815161d-03,
     |  -2.3554939096786d-02,-3.0450553166914d-02,-1.3194458986159d-02,
     |   1.5310441784835d-02, 3.2262526025328d-02, 2.3336047502547d-02,
     |  -4.9732969336373d-03,-2.9851252091588d-02,-3.0596946522773d-02,
     |  -6.0233841509619d-03, 2.3955826179582d-02, 3.4469101046218d-02,
     |   1.6446792089080d-02,-1.5452576242440d-02,-3.4756582792637d-02,
     |  -2.5243339149096d-02, 5.3333762581353d-03, 3.1556521359090d-02,
     |   3.1556521359091d-02, 5.3333762581354d-03,-2.5243339149095d-02,
     |  -3.4756582792637d-02,-1.5452576242440d-02, 1.6446792089080d-02,
     |   3.4469101046218d-02, 2.3955826179583d-02,-6.0233841509618d-03,
     |  -3.0596946522773d-02,-2.9851252091588d-02,-4.9732969336376d-03,
     |   2.3336047502547d-02, 3.2262526025328d-02, 1.5310441784835d-02,
     |  -1.3194458986159d-02,-3.0450553166914d-02,-2.3554939096786d-02,
     |   1.0461007815160d-03, 2.3817131643751d-02, 2.7951355122401d-02,
     |   1.1680369884003d-02,-1.1928810770719d-02,-2.6043032283132d-02,
     |  -2.2308852225672d-02,-5.1352939180071d-03, 1.3657252539009d-02,
     |   2.4055736609357d-02, 2.3560415382230d-02, 1.6326539202308d-02,
     |   8.2882645634925d-03, 2.9809773985732d-03, 6.8672676723310d-04,
     |   8.0469902416667d-05, 2.5711644967366d-06, 8.0858506688460d-09/
      data (zmn(lat, 7,22), lat = 1,72)/
     |  -4.9311506679252d-09, 2.6680265628923d-07, 1.3895562442000d-05,
     |   1.7108564930987d-04, 9.9684976117591d-04, 3.6003143011310d-03,
     |   9.1435925858345d-03, 1.7354464638922d-02, 2.5086026495539d-02,
     |   2.6809909493801d-02, 1.7996457843619d-02,-3.3216018036334d-04,
     |  -1.9777285760063d-02,-2.8443558753675d-02,-1.9190851174499d-02,
     |   3.6041552104783d-03, 2.5031751669929d-02, 2.9379039715893d-02,
     |   1.2214040151502d-02,-1.4819279213826d-02,-3.1544412358684d-02,
     |  -2.4491535100003d-02, 1.8639646311804d-03, 2.7498013861543d-02,
     |   3.2040485680644d-02, 1.1203934344005d-02,-1.9020631430736d-02,
     |  -3.4549977666626d-02,-2.2531610688505d-02, 7.8375234908455d-03,
     |   3.2245997555620d-02, 3.0801875415192d-02, 4.3834460866635d-03,
     |  -2.5761636431648d-02,-3.5151934260846d-02,-1.6062658157972d-02,
     |   1.6062658157972d-02, 3.5151934260846d-02, 2.5761636431648d-02,
     |  -4.3834460866634d-03,-3.0801875415192d-02,-3.2245997555620d-02,
     |  -7.8375234908456d-03, 2.2531610688505d-02, 3.4549977666626d-02,
     |   1.9020631430736d-02,-1.1203934344005d-02,-3.2040485680644d-02,
     |  -2.7498013861543d-02,-1.8639646311804d-03, 2.4491535100003d-02,
     |   3.1544412358684d-02, 1.4819279213826d-02,-1.2214040151501d-02,
     |  -2.9379039715893d-02,-2.5031751669929d-02,-3.6041552104783d-03,
     |   1.9190851174499d-02, 2.8443558753675d-02, 1.9777285760063d-02,
     |   3.3216018036333d-04,-1.7996457843619d-02,-2.6809909493801d-02,
     |  -2.5086026495539d-02,-1.7354464638922d-02,-9.1435925858344d-03,
     |  -3.6003143011310d-03,-9.9684976117601d-04,-1.7108564930988d-04,
     |  -1.3895562441953d-05,-2.6680265627223d-07, 4.9311507620155d-09/
      data (zmn(lat, 8,22), lat = 1,72)/
     |  -1.2203477375028d-10, 2.3274112155118d-08, 2.0554393699428d-06,
     |   3.6243381964557d-05, 2.8044693989197d-04, 1.2940432232550d-03,
     |   4.1247547896966d-03, 9.8164035635463d-03, 1.8146448515139d-02,
     |   2.6343770852569d-02, 2.9298858898969d-02, 2.2253639319370d-02,
     |   4.9354539301577d-03,-1.5981026973089d-02,-2.9133979189400d-02,
     |  -2.5419127642777d-02,-5.3472000006212d-03, 1.9191946114691d-02,
     |   3.1635136334523d-02, 2.2343570113534d-02,-3.3102752382803d-03,
     |  -2.7398416061575d-02,-3.1938578890868d-02,-1.2683941392954d-02,
     |   1.6650964988355d-02, 3.3958472175132d-02, 2.5545813402384d-02,
     |  -2.7507813277240d-03,-2.9373337334948d-02,-3.3493534632792d-02,
     |  -1.1493176459337d-02, 1.9734638441360d-02, 3.5738364350873d-02,
     |   2.3771004096485d-02,-6.9362531282019d-03,-3.2274951539992d-02,
     |  -3.2274951539992d-02,-6.9362531282020d-03, 2.3771004096485d-02,
     |   3.5738364350873d-02, 1.9734638441360d-02,-1.1493176459337d-02,
     |  -3.3493534632792d-02,-2.9373337334948d-02,-2.7507813277240d-03,
     |   2.5545813402384d-02, 3.3958472175132d-02, 1.6650964988355d-02,
     |  -1.2683941392954d-02,-3.1938578890868d-02,-2.7398416061575d-02,
     |  -3.3102752382806d-03, 2.2343570113534d-02, 3.1635136334523d-02,
     |   1.9191946114691d-02,-5.3472000006211d-03,-2.5419127642777d-02,
     |  -2.9133979189399d-02,-1.5981026973089d-02, 4.9354539301575d-03,
     |   2.2253639319370d-02, 2.9298858898969d-02, 2.6343770852569d-02,
     |   1.8146448515139d-02, 9.8164035635463d-03, 4.1247547896966d-03,
     |   1.2940432232551d-03, 2.8044693989209d-04, 3.6243381964620d-05,
     |   2.0554393699888d-06, 2.3274112091640d-08,-1.2203488298279d-10/
      data (zmn(lat, 9,22), lat = 1,72)/
     |   1.1597336190522d-10, 1.6548713889312d-09, 2.6435543033273d-07,
     |   6.6419994877481d-06, 6.7780191634257d-05, 3.9548003350790d-04,
     |   1.5580040516424d-03, 4.5384157254982d-03, 1.0294469090108d-02,
     |   1.8682597464581d-02, 2.7304848303854d-02, 3.1491630735691d-02,
     |   2.6385176909882d-02, 1.0594047398910d-02,-1.0975086936935d-02,
     |  -2.7994538621356d-02,-3.0171877265110d-02,-1.4518200821568d-02,
     |   1.0821751673156d-02, 3.0139250496615d-02, 3.0080143175421d-02,
     |   9.5097922581377d-03,-1.8288176840741d-02,-3.3911636680023d-02,
     |  -2.5609819765491d-02, 1.4531081564041d-03, 2.8000992461355d-02,
     |   3.4359508736589d-02, 1.5285280686045d-02,-1.5478506618342d-02,
     |  -3.4994978274850d-02,-2.8349660079506d-02,-2.3887389403568d-04,
     |   2.8231643623823d-02, 3.5444867204675d-02, 1.5815189778695d-02,
     |  -1.5815189778695d-02,-3.5444867204675d-02,-2.8231643623823d-02,
     |   2.3887389403548d-04, 2.8349660079505d-02, 3.4994978274850d-02,
     |   1.5478506618342d-02,-1.5285280686045d-02,-3.4359508736589d-02,
     |  -2.8000992461355d-02,-1.4531081564043d-03, 2.5609819765491d-02,
     |   3.3911636680023d-02, 1.8288176840741d-02,-9.5097922581377d-03,
     |  -3.0080143175421d-02,-3.0139250496615d-02,-1.0821751673156d-02,
     |   1.4518200821568d-02, 3.0171877265110d-02, 2.7994538621356d-02,
     |   1.0975086936935d-02,-1.0594047398910d-02,-2.6385176909882d-02,
     |  -3.1491630735691d-02,-2.7304848303854d-02,-1.8682597464581d-02,
     |  -1.0294469090108d-02,-4.5384157254982d-03,-1.5580040516425d-03,
     |  -3.9548003350788d-04,-6.7780191634249d-05,-6.6419994877558d-06,
     |  -2.6435543036120d-07,-1.6548713828138d-09,-1.1597342694012d-10/
      data (zmn(lat,10,22), lat = 1,72)/
     |   2.1468100223305d-12, 1.1235583514870d-10, 2.9847778574044d-08,
     |   1.0656640411065d-06, 1.4272559281681d-05, 1.0458484454736d-04,
     |   5.0427373783950d-04, 1.7725707749261d-03, 4.8274173889562d-03,
     |   1.0563736510618d-02, 1.8938161782800d-02, 2.7928275600636d-02,
     |   3.3332241285349d-02, 3.0315604415578d-02, 1.6547893883007d-02,
     |  -4.8195679642727d-03,-2.4901029776212d-02,-3.2987018369679d-02,
     |  -2.3169745057016d-02, 5.0447410187437d-04, 2.4686876957128d-02,
     |   3.4138607215637d-02, 2.1838018134401d-02,-5.2051786043746d-03,
     |  -2.9406855136458d-02,-3.4052960698045d-02,-1.5219310650397d-02,
     |   1.4601649876289d-02, 3.4581192911121d-02, 3.0228915703426d-02,
     |   4.1819614810264d-03,-2.5133700040161d-02,-3.6535809553848d-02,
     |  -2.1551191463176d-02, 9.1349854940524d-03, 3.3270362127632d-02,
     |   3.3270362127632d-02, 9.1349854940525d-03,-2.1551191463176d-02,
     |  -3.6535809553848d-02,-2.5133700040161d-02, 4.1819614810263d-03,
     |   3.0228915703426d-02, 3.4581192911121d-02, 1.4601649876289d-02,
     |  -1.5219310650397d-02,-3.4052960698045d-02,-2.9406855136458d-02,
     |  -5.2051786043746d-03, 2.1838018134401d-02, 3.4138607215637d-02,
     |   2.4686876957128d-02, 5.0447410187447d-04,-2.3169745057016d-02,
     |  -3.2987018369679d-02,-2.4901029776212d-02,-4.8195679642728d-03,
     |   1.6547893883007d-02, 3.0315604415578d-02, 3.3332241285349d-02,
     |   2.7928275600636d-02, 1.8938161782800d-02, 1.0563736510618d-02,
     |   4.8274173889564d-03, 1.7725707749261d-03, 5.0427373783948d-04,
     |   1.0458484454732d-04, 1.4272559281616d-05, 1.0656640411092d-06,
     |   2.9847778630586d-08, 1.1235579306945d-10, 2.1468590686476d-12/
      data (zmn(lat,11,22), lat = 1,72)/
     |  -2.4496584957075d-12, 9.1789822899656d-12, 2.9797991924451d-09,
     |   1.5093256854102d-07, 2.6437664622858d-06, 2.4212249262884d-05,
     |   1.4193769393085d-04, 5.9652112998366d-04, 1.9249926314662d-03,
     |   4.9802956884331d-03, 1.0610387526772d-02, 1.8885903146848d-02,
     |   2.8163297538912d-02, 3.4740797800547d-02, 3.3930997362602d-02,
     |   2.2657454411087d-02, 2.3871815593581d-03,-1.9751979135262d-02,
     |  -3.3383607619123d-02,-3.0446327516920d-02,-1.0917257345382d-02,
     |   1.5410585701953d-02, 3.3409518658651d-02, 3.1582951029702d-02,
     |   1.0034137725167d-02,-1.8367013005333d-02,-3.5429772295660d-02,
     |  -2.9509608805753d-02,-3.8686475090306d-03, 2.4719876807871d-02,
     |   3.6896279824890d-02, 2.4032152874129d-02,-5.4068967996046d-03,
     |  -3.1307912574229d-02,-3.5727159943398d-02,-1.5480024990705d-02,
     |   1.5480024990705d-02, 3.5727159943398d-02, 3.1307912574229d-02,
     |   5.4068967996047d-03,-2.4032152874129d-02,-3.6896279824890d-02,
     |  -2.4719876807872d-02, 3.8686475090304d-03, 2.9509608805753d-02,
     |   3.5429772295660d-02, 1.8367013005333d-02,-1.0034137725167d-02,
     |  -3.1582951029702d-02,-3.3409518658651d-02,-1.5410585701953d-02,
     |   1.0917257345382d-02, 3.0446327516920d-02, 3.3383607619123d-02,
     |   1.9751979135262d-02,-2.3871815593581d-03,-2.2657454411086d-02,
     |  -3.3930997362602d-02,-3.4740797800547d-02,-2.8163297538912d-02,
     |  -1.8885903146848d-02,-1.0610387526772d-02,-4.9802956884332d-03,
     |  -1.9249926314662d-03,-5.9652112998368d-04,-1.4193769393080d-04,
     |  -2.4212249262935d-05,-2.6437664622458d-06,-1.5093256853976d-07,
     |  -2.9797992269434d-09,-9.1790531449116d-12, 2.4496556911527d-12/
      data (zmn(lat,12,22), lat = 1,72)/
     |  -3.4889769983251d-14, 4.6081075972862d-13, 2.6479682923237d-10,
     |   1.8973985013918d-08, 4.3354627334994d-07, 4.9448142583618d-06,
     |   3.5075877267928d-05, 1.7512558332076d-04, 6.6383896049658d-04,
     |   2.0059445955959d-03, 4.9889428844957d-03, 1.0423058562006d-02,
     |   1.8499002824490d-02, 2.7952685455273d-02, 3.5615654592199d-02,
     |   3.7074228688242d-02, 2.8719543146699d-02, 1.0471194931982d-02,
     |  -1.2513555021049d-02,-3.0893641149015d-02,-3.5370204821104d-02,
     |  -2.2274095676769d-02, 2.9239505730259d-03, 2.7158058731532d-02,
     |   3.6521758281056d-02, 2.4736336245824d-02,-2.0739325242058d-03,
     |  -2.8079602460176d-02,-3.7077673805425d-02,-2.2908727909649d-02,
     |   5.9675118358308d-03, 3.1300390781666d-02, 3.6648331895161d-02,
     |   1.8275443960712d-02,-1.2063703133230d-02,-3.4619171034962d-02,
     |  -3.4619171034962d-02,-1.2063703133230d-02, 1.8275443960712d-02,
     |   3.6648331895160d-02, 3.1300390781666d-02, 5.9675118358307d-03,
     |  -2.2908727909649d-02,-3.7077673805425d-02,-2.8079602460176d-02,
     |  -2.0739325242059d-03, 2.4736336245824d-02, 3.6521758281056d-02,
     |   2.7158058731532d-02, 2.9239505730259d-03,-2.2274095676769d-02,
     |  -3.5370204821104d-02,-3.0893641149015d-02,-1.2513555021049d-02,
     |   1.0471194931982d-02, 2.8719543146699d-02, 3.7074228688242d-02,
     |   3.5615654592199d-02, 2.7952685455273d-02, 1.8499002824490d-02,
     |   1.0423058562006d-02, 4.9889428844956d-03, 2.0059445955960d-03,
     |   6.6383896049656d-04, 1.7512558332075d-04, 3.5075877268017d-05,
     |   4.9448142584461d-06, 4.3354627339427d-07, 1.8973985016386d-08,
     |   2.6479676097189d-10, 4.6089933238828d-13,-3.4900245751462d-14/
      data (zmn(lat,13,22), lat = 1,72)/
     |   4.5686500743690d-14,-2.4629977875544d-14, 2.1025749941754d-11,
     |   2.1238910436108d-09, 6.3180817850963d-08, 8.9502068229378d-07,
     |   7.6550475704327d-06, 4.5194430033327d-05, 2.0000931051530d-04,
     |   7.0012857791081d-04, 2.0099478183965d-03, 4.8499076524912d-03,
     |   9.9954455142749d-03, 1.7754941976904d-02, 2.7237807315401d-02,
     |   3.5838152669196d-02, 3.9543695758471d-02, 3.4450271659355d-02,
     |   1.9141747035599d-02,-3.2834623558209d-03,-2.5131775397143d-02,
     |  -3.6881814460358d-02,-3.2029657851012d-02,-1.1506518724233d-02,
     |   1.5331470908581d-02, 3.4635335387119d-02, 3.5453696939418d-02,
     |   1.6496391691793d-02,-1.2147135728438d-02,-3.4119345826477d-02,
     |  -3.6267046499248d-02,-1.6855358414764d-02, 1.2825419837245d-02,
     |   3.4931145486808d-02, 3.5917434211722d-02, 1.5032910528736d-02,
     |  -1.5032910528736d-02,-3.5917434211722d-02,-3.4931145486809d-02,
     |  -1.2825419837245d-02, 1.6855358414764d-02, 3.6267046499248d-02,
     |   3.4119345826478d-02, 1.2147135728438d-02,-1.6496391691793d-02,
     |  -3.5453696939418d-02,-3.4635335387119d-02,-1.5331470908581d-02,
     |   1.1506518724233d-02, 3.2029657851012d-02, 3.6881814460358d-02,
     |   2.5131775397144d-02, 3.2834623558210d-03,-1.9141747035599d-02,
     |  -3.4450271659355d-02,-3.9543695758471d-02,-3.5838152669196d-02,
     |  -2.7237807315401d-02,-1.7754941976903d-02,-9.9954455142749d-03,
     |  -4.8499076524912d-03,-2.0099478183965d-03,-7.0012857791083d-04,
     |  -2.0000931051531d-04,-4.5194430033353d-05,-7.6550475704606d-06,
     |  -8.9502068226940d-07,-6.3180817824968d-08,-2.1238910351198d-09,
     |  -2.1025717634758d-11, 2.4672892795679d-14,-4.5698577622544d-14/
      data (zmn(lat,14,22), lat = 1,72)/
     |   3.2931386312032d-16,-7.2478390111432d-16, 1.4858945369261d-12,
     |   2.1193073948016d-10, 8.1946007857164d-09, 1.4387996978639d-07,
     |   1.4797587992944d-06, 1.0294515513664d-05, 5.2950586306694d-05,
     |   2.1346982973033d-04, 7.0197058923626d-04, 1.9360001086455d-03,
     |   4.5659412183839d-03, 9.3293889095227d-03, 1.6640658045514d-02,
     |   2.5966301334309d-02, 3.5281725876745d-02, 4.1098315866270d-02,
     |   3.9474295750147d-02, 2.7949977987011d-02, 7.6270001521473d-03,
     |  -1.5911351254013d-02,-3.3952331575283d-02,-3.8312292024830d-02,
     |  -2.5809448672685d-02,-1.0382104624050d-03, 2.4688873614777d-02,
     |   3.8450764040392d-02, 3.2580635529758d-02, 9.4453395872135d-03,
     |  -1.9021036610955d-02,-3.7374884014643d-02,-3.5239053605983d-02,
     |  -1.3468727861934d-02, 1.5938844336498d-02, 3.6455215904168d-02,
     |   3.6455215904168d-02, 1.5938844336498d-02,-1.3468727861934d-02,
     |  -3.5239053605983d-02,-3.7374884014643d-02,-1.9021036610955d-02,
     |   9.4453395872133d-03, 3.2580635529758d-02, 3.8450764040392d-02,
     |   2.4688873614777d-02,-1.0382104624048d-03,-2.5809448672685d-02,
     |  -3.8312292024830d-02,-3.3952331575282d-02,-1.5911351254013d-02,
     |   7.6270001521470d-03, 2.7949977987011d-02, 3.9474295750147d-02,
     |   4.1098315866271d-02, 3.5281725876745d-02, 2.5966301334309d-02,
     |   1.6640658045514d-02, 9.3293889095226d-03, 4.5659412183839d-03,
     |   1.9360001086455d-03, 7.0197058923632d-04, 2.1346982973029d-04,
     |   5.2950586306685d-05, 1.0294515513685d-05, 1.4797587992946d-06,
     |   1.4387996975624d-07, 8.1946008304553d-09, 2.1193070261217d-10,
     |   1.4859155310156d-12,-7.3201696258655d-16, 3.6777063347697d-16/
      data (zmn(lat,15,22), lat = 1,72)/
     |  -7.5861504995471d-16, 6.1784208833743d-16, 9.2798529373400d-14,
     |   1.8831657783228d-11, 9.4524182568391d-10, 2.0536127360672d-08,
     |   2.5342987405752d-07, 2.0719323974702d-06, 1.2343999715497d-05,
     |   5.7066209244993d-05, 2.1376164611019d-04, 6.6899379085434d-04,
     |   1.7882520641276d-03, 4.1476417082748d-03, 8.4383753473494d-03,
     |   1.5159087223519d-02, 2.4103030442229d-02, 3.3827319690698d-02,
     |   4.1472753999164d-02, 4.3326864461995d-02, 3.6255823384244d-02,
     |   1.9599669726980d-02,-3.4107285828189d-03,-2.5797664906826d-02,
     |  -3.9084422588115d-02,-3.7069728353214d-02,-1.9412910563316d-02,
     |   7.0760002566133d-03, 3.0707873763714d-02, 4.0177163465704d-02,
     |   3.0368715169600d-02, 5.5354396649853d-03,-2.2245392970056d-02,
     |  -3.8946589137623d-02,-3.5877658610820d-02,-1.4433285412228d-02,
     |   1.4433285412228d-02, 3.5877658610820d-02, 3.8946589137623d-02,
     |   2.2245392970056d-02,-5.5354396649853d-03,-3.0368715169600d-02,
     |  -4.0177163465704d-02,-3.0707873763714d-02,-7.0760002566133d-03,
     |   1.9412910563316d-02, 3.7069728353214d-02, 3.9084422588115d-02,
     |   2.5797664906826d-02, 3.4107285828188d-03,-1.9599669726980d-02,
     |  -3.6255823384244d-02,-4.3326864461995d-02,-4.1472753999164d-02,
     |  -3.3827319690698d-02,-2.4103030442229d-02,-1.5159087223519d-02,
     |  -8.4383753473493d-03,-4.1476417082748d-03,-1.7882520641276d-03,
     |  -6.6899379085436d-04,-2.1376164611022d-04,-5.7066209244988d-05,
     |  -1.2343999715539d-05,-2.0719323974847d-06,-2.5342987401926d-07,
     |  -2.0536127293495d-08,-9.4524182547149d-10,-1.8831633270792d-11,
     |  -9.2785818691694d-14,-5.9415684443602d-16, 7.8962848697356d-16/
      data (zmn(lat,16,22), lat = 1,72)/
     |  -8.2409142075202d-17,-5.6001614961691d-17, 5.1468727612804d-15,
     |   1.4848114614184d-12, 9.6656578947619d-11, 2.5949331261894d-09,
     |   3.8359364477947d-08, 3.6775721514432d-07, 2.5310358418569d-06,
     |   1.3373241086811d-05, 5.6826579976972d-05, 2.0075619662848d-04,
     |   6.0412759312945d-04, 1.5765442496509d-03, 3.6149499282799d-03,
     |   7.3511603306522d-03, 1.3336847313465d-02, 2.1644567479177d-02,
     |   3.1386865487696d-02, 4.0407697778464d-02, 4.5478468028507d-02,
     |   4.3219052250218d-02, 3.1623809243456d-02, 1.1620055799303d-02,
     |  -1.2215630856110d-02,-3.2530779734458d-02,-4.1756014998150d-02,
     |  -3.5499589173121d-02,-1.5194873838458d-02, 1.1576897852285d-02,
     |   3.3734043993593d-02, 4.1451520520289d-02, 3.0875170930479d-02,
     |   6.3622035406379d-03,-2.1139120775464d-02,-3.9035351237496d-02,
     |  -3.9035351237496d-02,-2.1139120775464d-02, 6.3622035406378d-03,
     |   3.0875170930479d-02, 4.1451520520289d-02, 3.3734043993593d-02,
     |   1.1576897852285d-02,-1.5194873838458d-02,-3.5499589173121d-02,
     |  -4.1756014998150d-02,-3.2530779734458d-02,-1.2215630856110d-02,
     |   1.1620055799303d-02, 3.1623809243456d-02, 4.3219052250218d-02,
     |   4.5478468028507d-02, 4.0407697778464d-02, 3.1386865487696d-02,
     |   2.1644567479177d-02, 1.3336847313465d-02, 7.3511603306523d-03,
     |   3.6149499282799d-03, 1.5765442496509d-03, 6.0412759312938d-04,
     |   2.0075619662847d-04, 5.6826579976989d-05, 1.3373241086856d-05,
     |   2.5310358418428d-06, 3.6775721514243d-07, 3.8359364442412d-08,
     |   2.5949331252530d-09, 9.6656578299608d-11, 1.4848136768052d-12,
     |   5.2098429960492d-15,-6.0201771651788d-17,-3.4725202633852d-17/
      data (zmn(lat,17,22), lat = 1,72)/
     |  -3.7906278285161d-17,-1.4125655438561d-16, 1.0040630505521d-16,
     |   1.0306119520037d-13, 8.7065976494550d-12, 2.8852770733988d-10,
     |   5.1019215444514d-09, 5.7259079893259d-08, 4.5426962814475d-07,
     |   2.7361056072686d-06, 1.3146711460493d-05, 5.2219758395949d-05,
     |   1.7603241950479d-04, 5.1362146254184d-04, 1.3165727774746d-03,
     |   2.9981031643185d-03, 6.1148867428312d-03, 1.1232214136184d-02,
     |   1.8636539822391d-02, 2.7935528933696d-02, 3.7699794269768d-02,
     |   4.5394590441291d-02, 4.7839172410714d-02, 4.2255595382750d-02,
     |   2.7651881823996d-02, 5.9640227761481d-03,-1.7736989898149d-02,
     |  -3.6423159211101d-02,-4.3530272910341d-02,-3.5777482858527d-02,
     |  -1.5110707535876d-02, 1.1346413640790d-02, 3.3658756329080d-02,
     |   4.2981886466717d-02, 3.5353849547468d-02, 1.3606774144056d-02,
     |  -1.3606774144056d-02,-3.5353849547468d-02,-4.2981886466717d-02,
     |  -3.3658756329080d-02,-1.1346413640791d-02, 1.5110707535876d-02,
     |   3.5777482858527d-02, 4.3530272910341d-02, 3.6423159211101d-02,
     |   1.7736989898149d-02,-5.9640227761480d-03,-2.7651881823996d-02,
     |  -4.2255595382750d-02,-4.7839172410714d-02,-4.5394590441291d-02,
     |  -3.7699794269768d-02,-2.7935528933696d-02,-1.8636539822391d-02,
     |  -1.1232214136184d-02,-6.1148867428312d-03,-2.9981031643185d-03,
     |  -1.3165727774746d-03,-5.1362146254186d-04,-1.7603241950482d-04,
     |  -5.2219758395932d-05,-1.3146711460465d-05,-2.7361056073007d-06,
     |  -4.5426962816092d-07,-5.7259079871637d-08,-5.1019216052275d-09,
     |  -2.8852777286404d-10,-8.7066278535422d-12,-1.0309420215455d-13,
     |  -1.0112842835607d-16, 8.2911620196905d-17, 6.1827807627897d-17/
      data (zmn(lat,18,22), lat = 1,72)/
     |   4.6774180838673d-17, 1.1020871183827d-17,-1.6519129838237d-17,
     |   6.1905965076030d-15, 6.8348403352610d-13, 2.7936615896663d-11,
     |   5.9023220094680d-10, 7.7435181971485d-09, 7.0695017119249d-08,
     |   4.8437029962362d-07, 2.6249828237049d-06, 1.1686949950436d-05,
     |   4.3965645102739d-05, 1.4275997327586d-04, 4.0669778878774d-04,
     |   1.0293975842783d-03, 2.3374823868162d-03, 4.7966446248779d-03,
     |   8.9416391963488d-03, 1.5191505258358d-02, 2.3550959346893d-02,
     |   3.3273271296371d-02, 4.2642964176367d-02, 4.9076913523353d-02,
     |   4.9685200457491d-02, 4.2258375727048d-02, 2.6402835906798d-02,
     |   4.3456496678305d-03,-1.9089434194292d-02,-3.7593387419892d-02,
     |  -4.5378500645570d-02,-3.9410618232009d-02,-2.0941649121815d-02,
     |   4.4352985069837d-03, 2.8436414788477d-02, 4.2936986230937d-02,
     |   4.2936986230937d-02, 2.8436414788477d-02, 4.4352985069838d-03,
     |  -2.0941649121815d-02,-3.9410618232009d-02,-4.5378500645570d-02,
     |  -3.7593387419892d-02,-1.9089434194292d-02, 4.3456496678304d-03,
     |   2.6402835906798d-02, 4.2258375727048d-02, 4.9685200457491d-02,
     |   4.9076913523353d-02, 4.2642964176366d-02, 3.3273271296371d-02,
     |   2.3550959346893d-02, 1.5191505258358d-02, 8.9416391963489d-03,
     |   4.7966446248779d-03, 2.3374823868162d-03, 1.0293975842783d-03,
     |   4.0669778878771d-04, 1.4275997327580d-04, 4.3965645102748d-05,
     |   1.1686949950412d-05, 2.6249828236289d-06, 4.8437029960472d-07,
     |   7.0695017172028d-08, 7.7435182034918d-09, 5.9023222377235d-10,
     |   2.7936644038325d-11, 6.8342488913889d-13, 6.2560149818258d-15,
     |  -7.2859585693695d-17, 5.8010608068609d-17, 3.1030937301082d-17/
      data (zmn(lat,19,22), lat = 1,72)/
     |  -3.3271965919363d-17,-9.6461813938442d-17,-1.3873778331925d-16,
     |   1.6413965245782d-16, 4.5828762349523d-14, 2.3152188150832d-12,
     |   5.8390550864607d-11, 8.9443978261079d-10, 9.3834637403654d-09,
     |   7.3009061046798d-08, 4.4534612372422d-07, 2.2169630418673d-06,
     |   9.2797447324346d-06, 3.3412593148034d-05, 1.0532498367218d-04,
     |   2.9470922149229d-04, 7.3998283408266d-04, 1.6816444537611d-03,
     |   3.4819558200917d-03, 6.6018782182247d-03, 1.1502474940157d-02,
     |   1.8453064869188d-02, 2.7268264726662d-02, 3.7053577325715d-02,
     |   4.6089983036843d-02, 5.1996404067172d-02, 5.2245577493513d-02,
     |   4.4973261676674d-02, 2.9855065944632d-02, 8.7067637658462d-03,
     |  -1.4527913442226d-02,-3.4567177017307d-02,-4.6230784064994d-02,
     |  -4.6100064215958d-02,-3.3802356446584d-02,-1.2392455468209d-02,
     |   1.2392455468209d-02, 3.3802356446584d-02, 4.6100064215958d-02,
     |   4.6230784064994d-02, 3.4567177017307d-02, 1.4527913442226d-02,
     |  -8.7067637658462d-03,-2.9855065944632d-02,-4.4973261676675d-02,
     |  -5.2245577493513d-02,-5.1996404067172d-02,-4.6089983036843d-02,
     |  -3.7053577325715d-02,-2.7268264726662d-02,-1.8453064869188d-02,
     |  -1.1502474940157d-02,-6.6018782182247d-03,-3.4819558200918d-03,
     |  -1.6816444537611d-03,-7.3998283408271d-04,-2.9470922149232d-04,
     |  -1.0532498367215d-04,-3.3412593148018d-05,-9.2797447323865d-06,
     |  -2.2169630418626d-06,-4.4534612371276d-07,-7.3009061037495d-08,
     |  -9.3834637012074d-09,-8.9443979008440d-10,-5.8390513549550d-11,
     |  -2.3152031616571d-12,-4.5791249917084d-14,-1.5661131679554d-16,
     |   1.4532483464129d-16, 1.2146187518934d-16, 2.7048665058436d-18/
      data (zmn(lat,20,22), lat = 1,72)/
     |   4.0729705460737d-17, 2.6680874564928d-17,-4.5620752787630d-18,
     |  -3.9925125828115d-17, 2.4800787428896d-15, 1.5935273649137d-13,
     |   4.7968002559048d-12, 8.5710379248218d-11, 1.0320243793123d-09,
     |   9.1056507070023d-09, 6.2412327577803d-08, 3.4669447220218d-07,
     |   1.6108524157218d-06, 6.4132478967081d-06, 2.2293406568193d-05,
     |   6.8675607702184d-05, 1.8971900428182d-04, 4.7451237677740d-04,
     |   1.0828137065478d-03, 2.2683439504192d-03, 4.3835854147432d-03,
     |   7.8438862382159d-03, 1.3030441263994d-02, 2.0127090719442d-02,
     |   2.8915932655870d-02, 3.8594012516750d-02, 4.7701293000676d-02,
     |   5.4248334041308d-02, 5.6086762739342d-02, 5.1480420617107d-02,
     |   3.9736397722115d-02, 2.1685602744757d-02,-1.9677293833599d-04,
     |  -2.2151779170762d-02,-3.9942521000430d-02,-4.9900977157393d-02,
     |  -4.9900977157393d-02,-3.9942521000430d-02,-2.2151779170762d-02,
     |  -1.9677293833612d-04, 2.1685602744757d-02, 3.9736397722115d-02,
     |   5.1480420617107d-02, 5.6086762739342d-02, 5.4248334041308d-02,
     |   4.7701293000676d-02, 3.8594012516750d-02, 2.8915932655871d-02,
     |   2.0127090719442d-02, 1.3030441263995d-02, 7.8438862382159d-03,
     |   4.3835854147432d-03, 2.2683439504193d-03, 1.0828137065478d-03,
     |   4.7451237677746d-04, 1.8971900428183d-04, 6.8675607702250d-05,
     |   2.2293406568223d-05, 6.4132478967453d-06, 1.6108524157376d-06,
     |   3.4669447221239d-07, 6.2412327629580d-08, 9.1056506815787d-09,
     |   1.0320242993316d-09, 8.5710346204076d-11, 4.7967439160897d-12,
     |   1.5932410676337d-13, 2.4589641839996d-15,-8.3461200419217d-17,
     |  -2.2635522559638d-17,-3.7180026334889d-17,-1.7225493903443d-17/
      data (zmn(lat,21,22), lat = 1,72)/
     |  -3.3322691165398d-17,-1.0590183160168d-16,-1.5126938669633d-16,
     |  -1.7605176157108d-16,-6.6047315893753d-17, 8.4723005304317d-15,
     |   3.0922442564761d-13, 6.4417360959831d-12, 8.8934553452360d-11,
     |   8.8875204324942d-10, 6.8354534002406d-09, 4.2300061297292d-08,
     |   2.1773902656594d-07, 9.5633894125368d-07, 3.6560483439927d-06,
     |   1.2359635536428d-05, 3.7421832939909d-05, 1.0253512609454d-04,
     |   2.5641421892621d-04, 5.8935689200868d-04, 1.2522629675608d-03,
     |   2.4715136107601d-03, 4.5484928470963d-03, 7.8298848324507d-03,
     |   1.2637373330846d-02, 1.9155439895294d-02, 2.7293304933396d-02,
     |   3.6557178168368d-02, 4.5983489103334d-02, 5.4183142095598d-02,
     |   5.9525072191608d-02, 6.0446414002586d-02, 5.5828025948472d-02,
     |   4.5336279730560d-02, 2.9622920610986d-02, 1.0303555173772d-02,
     |  -1.0303555173772d-02,-2.9622920610986d-02,-4.5336279730560d-02,
     |  -5.5828025948472d-02,-6.0446414002586d-02,-5.9525072191608d-02,
     |  -5.4183142095598d-02,-4.5983489103334d-02,-3.6557178168368d-02,
     |  -2.7293304933396d-02,-1.9155439895294d-02,-1.2637373330846d-02,
     |  -7.8298848324507d-03,-4.5484928470963d-03,-2.4715136107601d-03,
     |  -1.2522629675608d-03,-5.8935689200866d-04,-2.5641421892618d-04,
     |  -1.0253512609453d-04,-3.7421832939890d-05,-1.2359635536399d-05,
     |  -3.6560483439989d-06,-9.5633894125288d-07,-2.1773902659958d-07,
     |  -4.2300061303239d-08,-6.8354534422218d-09,-8.8875204314353d-10,
     |  -8.8934555540097d-11,-6.4417499144155d-12,-3.0923665474976d-13,
     |  -8.4717084274473d-15, 4.5618006498614d-17, 1.9308072670877d-16,
     |   1.4673782331150d-16, 1.0831896150665d-16, 3.4186276754011d-17/
      data (zmn(lat,22,22), lat = 1,72)/
     |  -9.4079858203209d-17,-9.0856278456849d-17,-1.0123684378962d-16,
     |  -1.0955938068183d-16,-9.5239084170592d-17, 2.3797874458118d-16,
     |   1.3513443194256d-14, 3.2958212189170d-13, 5.2137865916703d-12,
     |   5.8954501234810d-11, 5.0817812673288d-10, 3.4985278120380d-09,
     |   1.9918937642784d-08, 9.6333666230580d-08, 4.0413458351897d-07,
     |   1.4954444474182d-06, 4.9475097071495d-06, 1.4797578216712d-05,
     |   4.0380477812995d-05, 1.0131274694611d-04, 2.3522216394183d-04,
     |   5.0815504696772d-04, 1.0262391793915d-03, 1.9452382580415d-03,
     |   3.4726403085313d-03, 5.8558613077779d-03, 9.3511864951958d-03,
     |   1.4172032359538d-02, 2.0421814229621d-02, 2.8024565756101d-02,
     |   3.6672657814544d-02, 4.5812333845582d-02, 5.4682174170666d-02,
     |   6.2407212350311d-02, 6.8135297099852d-02, 7.1187619681557d-02,
     |   7.1187619681557d-02, 6.8135297099852d-02, 6.2407212350311d-02,
     |   5.4682174170666d-02, 4.5812333845582d-02, 3.6672657814544d-02,
     |   2.8024565756101d-02, 2.0421814229621d-02, 1.4172032359538d-02,
     |   9.3511864951958d-03, 5.8558613077779d-03, 3.4726403085313d-03,
     |   1.9452382580415d-03, 1.0262391793915d-03, 5.0815504696772d-04,
     |   2.3522216394183d-04, 1.0131274694609d-04, 4.0380477812999d-05,
     |   1.4797578216705d-05, 4.9475097071672d-06, 1.4954444474141d-06,
     |   4.0413458353104d-07, 9.6333666228217d-08, 1.9918937641038d-08,
     |   3.4985278085830d-09, 5.0817811006128d-10, 5.8954498940105d-11,
     |   5.2138027846501d-12, 3.2958446534224d-13, 1.3516075454396d-14,
     |   2.2896464606303d-16,-7.4424345472191d-17,-9.4309047777922d-17,
     |  -8.2168485488998d-17,-7.9621031534670d-17,-7.7099009930982d-17/
      data (zmn(lat, 0,23), lat = 1,72)/
     |   3.6860533053205d-03, 7.1613570725632d-03,-2.0868029269274d-03,
     |  -1.2405833848483d-02,-1.2255636207837d-02, 2.1608179697999d-03,
     |   1.6672062301411d-02, 1.6297729734272d-02,-1.3976504252955d-03,
     |  -1.9497097442927d-02,-1.9849556365792d-02, 9.3773575005265d-05,
     |   2.1397469144584d-02, 2.3028421900624d-02, 1.6004057215693d-03,
     |  -2.2574456653806d-02,-2.5859386899648d-02,-3.5795995095488d-03,
     |   2.3136289795790d-02, 2.8336593992591d-02, 5.7570415246949d-03,
     |  -2.3155722638957d-02,-3.0442928507316d-02,-8.0549576829306d-03,
     |   2.2691004821180d-02, 3.2158261720455d-02, 1.0400658467001d-02,
     |  -2.1795027126920d-02,-3.3463536339527d-02,-1.2724898894910d-02,
     |   2.0519719196955d-02, 3.4343021296311d-02, 1.4961264527884d-02,
     |  -1.8918240566695d-02,-3.4785622043704d-02,-1.7046035337368d-02,
     |   1.7046035337368d-02, 3.4785622043704d-02, 1.8918240566695d-02,
     |  -1.4961264527884d-02,-3.4343021296311d-02,-2.0519719196955d-02,
     |   1.2724898894910d-02, 3.3463536339527d-02, 2.1795027126920d-02,
     |  -1.0400658467001d-02,-3.2158261720455d-02,-2.2691004821181d-02,
     |   8.0549576829305d-03, 3.0442928507316d-02, 2.3155722638957d-02,
     |  -5.7570415246946d-03,-2.8336593992591d-02,-2.3136289795790d-02,
     |   3.5795995095487d-03, 2.5859386899648d-02, 2.2574456653806d-02,
     |  -1.6004057215695d-03,-2.3028421900624d-02,-2.1397469144584d-02,
     |  -9.3773575005173d-05, 1.9849556365792d-02, 1.9497097442927d-02,
     |   1.3976504252955d-03,-1.6297729734272d-02,-1.6672062301411d-02,
     |  -2.1608179698001d-03, 1.2255636207837d-02, 1.2405833848483d-02,
     |   2.0868029269274d-03,-7.1613570725631d-03,-3.6860533053205d-03/
      data (zmn(lat, 1,23), lat = 1,72)/
     |   1.3201589885644d-03, 7.7290419458205d-03, 1.1115006313915d-02,
     |   3.2225913583338d-03,-1.0740085421263d-02,-1.6718027657614d-02,
     |  -6.3255182777866d-03, 1.2268548797924d-02, 2.0871864584627d-02,
     |   9.2863106369531d-03,-1.2873865547838d-02,-2.4162579924158d-02,
     |  -1.2217403185804d-02, 1.2786962367832d-02, 2.6783558050164d-02,
     |   1.5109112819975d-02,-1.2141407075581d-02,-2.8817244255050d-02,
     |  -1.7921636526099d-02, 1.1033304202641d-02, 3.0305155700719d-02,
     |   2.0605757991431d-02,-9.5425883275417d-03,-3.1272674738326d-02,
     |  -2.3109851369499d-02, 7.7420324082783d-03, 3.1739771976781d-02,
     |   2.5383011166894d-02,-5.7014051960417d-03,-3.1726246854267d-02,
     |  -2.7376780933179d-02, 3.4894190708140d-03, 3.1254462951504d-02,
     |   2.9046250092182d-02,-1.1745737403478d-03,-3.0350783103077d-02,
     |  -3.0350783103077d-02,-1.1745737403480d-03, 2.9046250092182d-02,
     |   3.1254462951504d-02, 3.4894190708142d-03,-2.7376780933179d-02,
     |  -3.1726246854267d-02,-5.7014051960420d-03, 2.5383011166894d-02,
     |   3.1739771976781d-02, 7.7420324082784d-03,-2.3109851369499d-02,
     |  -3.1272674738326d-02,-9.5425883275416d-03, 2.0605757991431d-02,
     |   3.0305155700720d-02, 1.1033304202641d-02,-1.7921636526099d-02,
     |  -2.8817244255050d-02,-1.2141407075581d-02, 1.5109112819975d-02,
     |   2.6783558050164d-02, 1.2786962367832d-02,-1.2217403185804d-02,
     |  -2.4162579924158d-02,-1.2873865547838d-02, 9.2863106369530d-03,
     |   2.0871864584627d-02, 1.2268548797924d-02,-6.3255182777866d-03,
     |  -1.6718027657614d-02,-1.0740085421264d-02, 3.2225913583337d-03,
     |   1.1115006313915d-02, 7.7290419458206d-03, 1.3201589885644d-03/
      data (zmn(lat, 2,23), lat = 1,72)/
     |   1.6954935531965d-04, 3.3148080650872d-03, 1.0485762855330d-02,
     |   1.4399967226494d-02, 7.5282035346227d-03,-7.8721029750189d-03,
     |  -1.8654226619291d-02,-1.3157091699493d-02, 5.8992597513230d-03,
     |   2.1402603698624d-02, 1.7595331280733d-02,-3.7910671733169d-03,
     |  -2.3207896379464d-02,-2.1387300656341d-02, 1.4639575866426d-03,
     |   2.4266128430313d-02, 2.4682764953257d-02, 1.0598456271095d-03,
     |  -2.4680584727169d-02,-2.7525258170938d-02,-3.7295620072196d-03,
     |   2.4521359443294d-02, 2.9920431346182d-02, 6.4843534047926d-03,
     |  -2.3845730215875d-02,-3.1859527175376d-02,-9.2594609670226d-03,
     |   2.2706778576595d-02, 3.3329388070644d-02, 1.1988875599837d-02,
     |  -2.1157427437984d-02,-3.4317358815845d-02,-1.4606833861100d-02,
     |   1.9252360083188d-02, 3.4813884007715d-02, 1.7048830469381d-02,
     |  -1.7048830469381d-02,-3.4813884007715d-02,-1.9252360083187d-02,
     |   1.4606833861100d-02, 3.4317358815845d-02, 2.1157427437984d-02,
     |  -1.1988875599837d-02,-3.3329388070644d-02,-2.2706778576595d-02,
     |   9.2594609670224d-03, 3.1859527175376d-02, 2.3845730215875d-02,
     |  -6.4843534047926d-03,-2.9920431346183d-02,-2.4521359443294d-02,
     |   3.7295620072193d-03, 2.7525258170938d-02, 2.4680584727169d-02,
     |  -1.0598456271095d-03,-2.4682764953257d-02,-2.4266128430313d-02,
     |  -1.4639575866424d-03, 2.1387300656341d-02, 2.3207896379464d-02,
     |   3.7910671733169d-03,-1.7595331280733d-02,-2.1402603698624d-02,
     |  -5.8992597513231d-03, 1.3157091699493d-02, 1.8654226619291d-02,
     |   7.8721029750191d-03,-7.5282035346224d-03,-1.4399967226494d-02,
     |  -1.0485762855330d-02,-3.3148080650873d-03,-1.6954935531965d-04/
      data (zmn(lat, 3,23), lat = 1,72)/
     |   5.1729792250895d-06, 9.0020168005439d-04, 5.2343533164687d-03,
     |   1.2781292218684d-02, 1.7258134650565d-02, 1.1272050714112d-02,
     |  -4.6070997921405d-03,-1.8948427651953d-02,-1.8351327992847d-02,
     |  -9.9367380509062d-04, 1.9028754808508d-02, 2.3068008484153d-02,
     |   5.7150607630535d-03,-1.8313040546161d-02,-2.6539703282027d-02,
     |  -9.9886076031971d-03, 1.7003830382075d-02, 2.9112132322825d-02,
     |   1.3942676905889d-02,-1.5205861425870d-02,-3.0928364967209d-02,
     |  -1.7603240804716d-02, 1.2999826593498d-02, 3.2060593585048d-02,
     |   2.0954879797085d-02,-1.0459879737608d-02,-3.2553271702493d-02,
     |  -2.3964231730905d-02, 7.6589955887512d-03, 3.2440440804086d-02,
     |   2.6590626149408d-02,-4.6707060084599d-03,-3.1753596717254d-02,
     |  -2.8791514627584d-02, 1.5694803114247d-03, 3.0525436944000d-02,
     |   3.0525436944000d-02, 1.5694803114248d-03,-2.8791514627584d-02,
     |  -3.1753596717254d-02,-4.6707060084601d-03, 2.6590626149408d-02,
     |   3.2440440804086d-02, 7.6589955887514d-03,-2.3964231730905d-02,
     |  -3.2553271702493d-02,-1.0459879737608d-02, 2.0954879797085d-02,
     |   3.2060593585048d-02, 1.2999826593498d-02,-1.7603240804716d-02,
     |  -3.0928364967209d-02,-1.5205861425870d-02, 1.3942676905889d-02,
     |   2.9112132322824d-02, 1.7003830382075d-02,-9.9886076031971d-03,
     |  -2.6539703282027d-02,-1.8313040546161d-02, 5.7150607630532d-03,
     |   2.3068008484153d-02, 1.9028754808508d-02,-9.9367380509055d-04,
     |  -1.8351327992848d-02,-1.8948427651953d-02,-4.6070997921405d-03,
     |   1.1272050714112d-02, 1.7258134650565d-02, 1.2781292218684d-02,
     |   5.2343533164687d-03, 9.0020168005442d-04, 5.1729792251219d-06/
      data (zmn(lat, 4,23), lat = 1,72)/
     |   3.4487988297250d-07, 1.7647650235625d-04, 1.8186067738402d-03,
     |   6.9457284141450d-03, 1.4844328091441d-02, 1.9799604711382d-02,
     |   1.4684966293102d-02,-1.1901860333180d-03,-1.8109843840156d-02,
     |  -2.2110205645931d-02,-7.7244154218195d-03, 1.4663697702739d-02,
     |   2.5772833001802d-02, 1.4424925631151d-02,-1.0813684694110d-02,
     |  -2.7617814852020d-02,-1.9809628080041d-02, 6.7828928343879d-03,
     |   2.8266865465612d-02, 2.4231443811133d-02,-2.6558864897279d-03,
     |  -2.7992810721478d-02,-2.7840551839400d-02,-1.4998557150392d-03,
     |   2.6948884745149d-02, 3.0701516934921d-02, 5.6149882442756d-03,
     |  -2.5241346639087d-02,-3.2840228649015d-02,-9.6163809875053d-03,
     |   2.2957124725646d-02, 3.4265163349709d-02, 1.3428270996337d-02,
     |  -2.0175576372319d-02,-3.4977802974425d-02,-1.6973698626820d-02,
     |   1.6973698626820d-02, 3.4977802974425d-02, 2.0175576372319d-02,
     |  -1.3428270996337d-02,-3.4265163349709d-02,-2.2957124725646d-02,
     |   9.6163809875053d-03, 3.2840228649015d-02, 2.5241346639087d-02,
     |  -5.6149882442755d-03,-3.0701516934921d-02,-2.6948884745149d-02,
     |   1.4998557150391d-03, 2.7840551839400d-02, 2.7992810721478d-02,
     |   2.6558864897282d-03,-2.4231443811133d-02,-2.8266865465612d-02,
     |  -6.7828928343879d-03, 1.9809628080041d-02, 2.7617814852020d-02,
     |   1.0813684694110d-02,-1.4424925631151d-02,-2.5772833001802d-02,
     |  -1.4663697702739d-02, 7.7244154218195d-03, 2.2110205645931d-02,
     |   1.8109843840156d-02, 1.1901860333178d-03,-1.4684966293102d-02,
     |  -1.9799604711382d-02,-1.4844328091441d-02,-6.9457284141450d-03,
     |  -1.8186067738402d-03,-1.7647650235626d-04,-3.4487988298291d-07/
      data (zmn(lat, 5,23), lat = 1,72)/
     |   2.7035603691641d-07, 2.6936435425305d-05, 4.8598305353249d-04,
     |   2.7750374229901d-03, 8.4966807961001d-03, 1.6708153830436d-02,
     |   2.2116247616937d-02, 1.7874269707079d-02, 2.3364814330911d-03,
     |  -1.6427538201050d-02,-2.4604107628316d-02,-1.3970223081096d-02,
     |   8.9733960601251d-03, 2.5938034847671d-02, 2.1623248455813d-02,
     |  -1.8718479647757d-03,-2.4965904991406d-02,-2.6872639906560d-02,
     |  -4.6616455253744d-03, 2.2690340121726d-02, 3.0420717632587d-02,
     |   1.0616067534853d-02,-1.9549357038190d-02,-3.2616425980458d-02,
     |  -1.5983875406282d-02, 1.5789558407437d-02, 3.3654051313588d-02,
     |   2.0739182445088d-02,-1.1582899108762d-02,-3.3655619516412d-02,
     |  -2.4841388342650d-02, 7.0697000887929d-03, 3.2708314830002d-02,
     |   2.8240803154165d-02,-2.3763997302872d-03,-3.0882554811393d-02,
     |  -3.0882554811393d-02,-2.3763997302874d-03, 2.8240803154165d-02,
     |   3.2708314830002d-02, 7.0697000887931d-03,-2.4841388342650d-02,
     |  -3.3655619516412d-02,-1.1582899108762d-02, 2.0739182445088d-02,
     |   3.3654051313589d-02, 1.5789558407437d-02,-1.5983875406282d-02,
     |  -3.2616425980458d-02,-1.9549357038190d-02, 1.0616067534853d-02,
     |   3.0420717632587d-02, 2.2690340121726d-02,-4.6616455253743d-03,
     |  -2.6872639906560d-02,-2.4965904991406d-02,-1.8718479647758d-03,
     |   2.1623248455813d-02, 2.5938034847671d-02, 8.9733960601253d-03,
     |  -1.3970223081096d-02,-2.4604107628316d-02,-1.6427538201050d-02,
     |   2.3364814330911d-03, 1.7874269707079d-02, 2.2116247616937d-02,
     |   1.6708153830436d-02, 8.4966807961001d-03, 2.7750374229900d-03,
     |   4.8598305353251d-04, 2.6936435425315d-05, 2.7035603692541d-07/
      data (zmn(lat, 6,23), lat = 1,72)/
     |   1.0976057256659d-08, 3.4071126632475d-06, 1.0527359484199d-04,
     |   8.8017206781055d-04, 3.7097466472458d-03, 9.8977102812447d-03,
     |   1.8385284943749d-02, 2.4248737451359d-02, 2.0911922547786d-02,
     |   5.9804268795138d-03,-1.4039417082736d-02,-2.5948703620577d-02,
     |  -1.9546341004690d-02, 2.4283790531296d-03, 2.3824178831275d-02,
     |   2.6860466145774d-02, 7.5381332854394d-03,-1.9133968197130d-02,
     |  -3.0489696520874d-02,-1.5752788359673d-02, 1.3367309545130d-02,
     |   3.1666780290564d-02, 2.2388541226149d-02,-7.1484981296428d-03,
     |  -3.1044028080685d-02,-2.7585994822401d-02, 8.1270828159334d-04,
     |   2.9012059957421d-02, 3.1432250994646d-02, 5.4145728643449d-03,
     |  -2.5836643525201d-02,-3.3976204837357d-02,-1.1352946492470d-02,
     |   2.1721736214162d-02, 3.5242966111504d-02, 1.6840680759528d-02,
     |  -1.6840680759528d-02,-3.5242966111504d-02,-2.1721736214162d-02,
     |   1.1352946492470d-02, 3.3976204837357d-02, 2.5836643525201d-02,
     |  -5.4145728643449d-03,-3.1432250994646d-02,-2.9012059957421d-02,
     |  -8.1270828159341d-04, 2.7585994822401d-02, 3.1044028080685d-02,
     |   7.1484981296429d-03,-2.2388541226149d-02,-3.1666780290564d-02,
     |  -1.3367309545130d-02, 1.5752788359673d-02, 3.0489696520874d-02,
     |   1.9133968197130d-02,-7.5381332854393d-03,-2.6860466145774d-02,
     |  -2.3824178831275d-02,-2.4283790531295d-03, 1.9546341004690d-02,
     |   2.5948703620577d-02, 1.4039417082736d-02,-5.9804268795138d-03,
     |  -2.0911922547786d-02,-2.4248737451359d-02,-1.8385284943749d-02,
     |  -9.8977102812447d-03,-3.7097466472457d-03,-8.8017206781054d-04,
     |  -1.0527359484194d-04,-3.4071126632042d-06,-1.0976057285983d-08/
      data (zmn(lat, 7,23), lat = 1,72)/
     |  -6.2260359857386d-09, 3.7039012441369d-07, 1.9109177404766d-05,
     |   2.3117519171234d-04, 1.3140528113332d-03, 4.5895536800231d-03,
     |   1.1142261377869d-02, 1.9874729108044d-02, 2.6210511940653d-02,
     |   2.3841809193668d-02, 9.7642780521305d-03,-1.0999192747363d-02,
     |  -2.6194474509776d-02,-2.4310246023666d-02,-4.6108786565920d-03,
     |   1.9677303319937d-02, 2.9825345201827d-02, 1.6566158731178d-02,
     |  -1.0793179574143d-02,-3.0296501833980d-02,-2.5075789075746d-02,
     |   1.5976422865349d-03, 2.7727049693315d-02, 3.0692937416695d-02,
     |   7.1209043239302d-03,-2.3202931498773d-02,-3.3857661695119d-02,
     |  -1.4986757975089d-02, 1.7387982535307d-02, 3.4887874486754d-02,
     |   2.1772527318430d-02,-1.0743533371836d-02,-3.4019387642369d-02,
     |  -2.7307033583802d-02, 3.6316283823053d-03, 3.1439026028216d-02,
     |   3.1439026028216d-02, 3.6316283823055d-03,-2.7307033583802d-02,
     |  -3.4019387642369d-02,-1.0743533371836d-02, 2.1772527318430d-02,
     |   3.4887874486754d-02, 1.7387982535307d-02,-1.4986757975089d-02,
     |  -3.3857661695119d-02,-2.3202931498773d-02, 7.1209043239300d-03,
     |   3.0692937416695d-02, 2.7727049693315d-02, 1.5976422865349d-03,
     |  -2.5075789075746d-02,-3.0296501833980d-02,-1.0793179574143d-02,
     |   1.6566158731178d-02, 2.9825345201827d-02, 1.9677303319937d-02,
     |  -4.6108786565922d-03,-2.4310246023666d-02,-2.6194474509777d-02,
     |  -1.0999192747363d-02, 9.7642780521305d-03, 2.3841809193668d-02,
     |   2.6210511940653d-02, 1.9874729108045d-02, 1.1142261377869d-02,
     |   4.5895536800231d-03, 1.3140528113333d-03, 2.3117519171238d-04,
     |   1.9109177404699d-05, 3.7039012442319d-07,-6.2260360025598d-09/
      data (zmn(lat, 8,23), lat = 1,72)/
     |  -1.8437433210734d-10, 3.4021888423023d-08, 2.9734536622869d-06,
     |   5.1631093844499d-05, 3.9105702679846d-04, 1.7539019799491d-03,
     |   5.3874979660606d-03, 1.2216439011506d-02, 2.1164043459975d-02,
     |   2.7997214839875d-02, 2.6682830318080d-02, 1.3709259594532d-02,
     |  -7.3153915186660d-03,-2.5333356890641d-02,-2.8111093701068d-02,
     |  -1.1824814047528d-02, 1.3735097978507d-02, 3.0280510933018d-02,
     |   2.4421979853933d-02,-7.2841358590151d-04,-2.6205873388658d-02,
     |  -3.1374196989494d-02,-1.1056126285971d-02, 1.8956654962301d-02,
     |   3.3934905634572d-02, 2.0779682301692d-02,-1.0189081695429d-02,
     |  -3.3082268363839d-02,-2.8162386381432d-02, 9.0189096255729d-04,
     |   2.9547833850931d-02, 3.3108995361927d-02, 8.2205588815034d-03,
     |  -2.3906114731319d-02,-3.5587251694158d-02,-1.6645468376207d-02,
     |   1.6645468376207d-02, 3.5587251694158d-02, 2.3906114731319d-02,
     |  -8.2205588815033d-03,-3.3108995361927d-02,-2.9547833850931d-02,
     |  -9.0189096255734d-04, 2.8162386381431d-02, 3.3082268363839d-02,
     |   1.0189081695429d-02,-2.0779682301692d-02,-3.3934905634572d-02,
     |  -1.8956654962301d-02, 1.1056126285971d-02, 3.1374196989494d-02,
     |   2.6205873388658d-02, 7.2841358590161d-04,-2.4421979853933d-02,
     |  -3.0280510933018d-02,-1.3735097978507d-02, 1.1824814047528d-02,
     |   2.8111093701068d-02, 2.5333356890641d-02, 7.3153915186661d-03,
     |  -1.3709259594532d-02,-2.6682830318080d-02,-2.7997214839875d-02,
     |  -2.1164043459975d-02,-1.2216439011506d-02,-5.3874979660606d-03,
     |  -1.7539019799491d-03,-3.9105702679856d-04,-5.1631093844520d-05,
     |  -2.9734536623389d-06,-3.4021888489054d-08, 1.8437437029122d-10/
      data (zmn(lat, 9,23), lat = 1,72)/
     |   1.5812352586420d-10, 2.5651500010551d-09, 4.0280417933430d-07,
     |   9.9834154924580d-06, 9.9972023548768d-05, 5.6905995931235d-04,
     |   2.1721191996324d-03, 6.0790022944985d-03, 1.3101347495619d-02,
     |   2.2231778875242d-02, 2.9588795981000d-02, 2.9430161918662d-02,
     |   1.7823456760231d-02,-2.9764102199552d-03,-2.3311526888476d-02,
     |  -3.0762333534516d-02,-1.8880541343933d-02, 6.2603354308034d-03,
     |   2.8045169413681d-02, 3.0330789680402d-02, 1.0130372758843d-02,
     |  -1.8424172318441d-02,-3.3580422470882d-02,-2.2799557726156d-02,
     |   6.3575599016458d-03, 3.1070123716112d-02, 3.1143188622245d-02,
     |   5.8392290507691d-03,-2.4656928154370d-02,-3.5272594243777d-02,
     |  -1.6852157109665d-02, 1.5730704469622d-02, 3.5505748595621d-02,
     |   2.5846397052265d-02,-5.3950850688149d-03,-3.2223962287408d-02,
     |  -3.2223962287408d-02,-5.3950850688150d-03, 2.5846397052265d-02,
     |   3.5505748595621d-02, 1.5730704469622d-02,-1.6852157109665d-02,
     |  -3.5272594243777d-02,-2.4656928154370d-02, 5.8392290507690d-03,
     |   3.1143188622244d-02, 3.1070123716112d-02, 6.3575599016460d-03,
     |  -2.2799557726156d-02,-3.3580422470882d-02,-1.8424172318441d-02,
     |   1.0130372758843d-02, 3.0330789680402d-02, 2.8045169413681d-02,
     |   6.2603354308035d-03,-1.8880541343933d-02,-3.0762333534516d-02,
     |  -2.3311526888476d-02,-2.9764102199552d-03, 1.7823456760231d-02,
     |   2.9430161918662d-02, 2.9588795981000d-02, 2.2231778875242d-02,
     |   1.3101347495619d-02, 6.0790022944985d-03, 2.1721191996324d-03,
     |   5.6905995931238d-04, 9.9972023548716d-05, 9.9834154924612d-06,
     |   4.0280417935857d-07, 2.5651499557350d-09, 1.5812349424545d-10/
      data (zmn(lat,10,23), lat = 1,72)/
     |   3.6247397193698d-12, 1.8173324137050d-10, 4.7993411177320d-08,
     |   1.6924548736402d-06, 2.2286688664632d-05, 1.5976205276964d-04,
     |   7.4929490938408d-04, 2.5447896152301d-03, 6.6408703210656d-03,
     |   1.3774509491384d-02, 2.3048607573029d-02, 3.0949719536846d-02,
     |   3.2053824913659d-02, 2.2091780275083d-02, 2.0289580815281d-03,
     |  -2.0045170921334d-02,-3.2029373417565d-02,-2.5388232866426d-02,
     |  -2.4102058492450d-03, 2.3017748091616d-02, 3.3520257418771d-02,
     |   2.0666487130788d-02,-7.5207032973575d-03,-3.0908429078506d-02,
     |  -3.1668785991829d-02,-8.3493472672989d-03, 2.1861333368556d-02,
     |   3.5622179446120d-02, 2.1696508898794d-02,-9.5289894157400d-03,
     |  -3.3571272336309d-02,-3.1127449752326d-02,-3.8027024669642d-03,
     |   2.6737848549701d-02, 3.5977757805828d-02, 1.6377806863358d-02,
     |  -1.6377806863358d-02,-3.5977757805828d-02,-2.6737848549702d-02,
     |   3.8027024669642d-03, 3.1127449752326d-02, 3.3571272336309d-02,
     |   9.5289894157400d-03,-2.1696508898794d-02,-3.5622179446120d-02,
     |  -2.1861333368556d-02, 8.3493472672988d-03, 3.1668785991829d-02,
     |   3.0908429078506d-02, 7.5207032973575d-03,-2.0666487130788d-02,
     |  -3.3520257418771d-02,-2.3017748091616d-02, 2.4102058492449d-03,
     |   2.5388232866426d-02, 3.2029373417565d-02, 2.0045170921334d-02,
     |  -2.0289580815282d-03,-2.2091780275083d-02,-3.2053824913659d-02,
     |  -3.0949719536846d-02,-2.3048607573029d-02,-1.3774509491384d-02,
     |  -6.6408703210655d-03,-2.5447896152301d-03,-7.4929490938410d-04,
     |  -1.5976205276966d-04,-2.2286688664561d-05,-1.6924548735815d-06,
     |  -4.7993411114618d-08,-1.8173319081379d-10,-3.6247517558896d-12/
      data (zmn(lat,11,23), lat = 1,72)/
     |  -3.6318750245241d-12, 1.5147734198163d-11, 5.0679018098173d-09,
     |   2.5379505605379d-07, 4.3777920159551d-06, 3.9307470367642d-05,
     |   2.2480978161778d-04, 9.1662646018501d-04, 2.8508935143960d-03,
     |   7.0513007608065d-03, 1.4211134375156d-02, 2.3578065253583d-02,
     |   3.2028501878662d-02, 3.4495636496219d-02, 2.6465499850583d-02,
     |   7.6910938868179d-03,-1.5440986889011d-02,-3.1629810768835d-02,
     |  -3.0867568772016d-02,-1.1806390522364d-02, 1.5235731316124d-02,
     |   3.3251772318351d-02, 2.9551292961862d-02, 5.4673291949138d-03,
     |  -2.3027829430315d-02,-3.5682226084695d-02,-2.2689200697413d-02,
     |   7.2082457460520d-03, 3.2214925759352d-02, 3.3419594220209d-02,
     |   9.4144095100167d-03,-2.1972785963269d-02,-3.6856948876966d-02,
     |  -2.3639015157895d-02, 7.7590694972073d-03, 3.3284907929024d-02,
     |   3.3284907929024d-02, 7.7590694972074d-03,-2.3639015157895d-02,
     |  -3.6856948876966d-02,-2.1972785963269d-02, 9.4144095100167d-03,
     |   3.3419594220209d-02, 3.2214925759352d-02, 7.2082457460520d-03,
     |  -2.2689200697413d-02,-3.5682226084695d-02,-2.3027829430315d-02,
     |   5.4673291949137d-03, 2.9551292961862d-02, 3.3251772318351d-02,
     |   1.5235731316124d-02,-1.1806390522364d-02,-3.0867568772016d-02,
     |  -3.1629810768835d-02,-1.5440986889011d-02, 7.6910938868179d-03,
     |   2.6465499850584d-02, 3.4495636496219d-02, 3.2028501878662d-02,
     |   2.3578065253583d-02, 1.4211134375156d-02, 7.0513007608066d-03,
     |   2.8508935143961d-03, 9.1662646018507d-04, 2.2480978161783d-04,
     |   3.9307470367650d-05, 4.3777920160125d-06, 2.5379505599404d-07,
     |   5.0679017451554d-09, 1.5147716697992d-11,-3.6318844862223d-12/
      data (zmn(lat,12,23), lat = 1,72)/
     |  -6.6430173371553d-14, 8.4591704026916d-13, 4.7760804527287d-10,
     |   3.3871692068335d-08, 7.6314644455298d-07, 8.5486429868553d-06,
     |   5.9300576144860d-05, 2.8815110571470d-04, 1.0572427241103d-03,
     |   3.0723345471568d-03, 7.2905605903465d-03, 1.4385569401299d-02,
     |   2.3777627133307d-02, 3.2757404449469d-02, 3.6665547655147d-02,
     |   3.0850615741293d-02, 1.3956515344458d-02,-9.4244358786461d-03,
     |  -2.9248322185858d-02,-3.4727737197232d-02,-2.1260362599376d-02,
     |   4.9721410912351d-03, 2.8911804340852d-02, 3.5269075400806d-02,
     |   1.8925683846561d-02,-1.0324467041433d-02,-3.3143758994252d-02,
     |  -3.3534097840238d-02,-1.0518354205336d-02, 2.0232157562415d-02,
     |   3.6912287837663d-02, 2.7240428510451d-02,-2.1886975936002d-03,
     |  -3.0208339014820d-02,-3.6362075941223d-02,-1.6021621194583d-02,
     |   1.6021621194583d-02, 3.6362075941223d-02, 3.0208339014820d-02,
     |   2.1886975936002d-03,-2.7240428510451d-02,-3.6912287837663d-02,
     |  -2.0232157562415d-02, 1.0518354205335d-02, 3.3534097840238d-02,
     |   3.3143758994252d-02, 1.0324467041433d-02,-1.8925683846561d-02,
     |  -3.5269075400806d-02,-2.8911804340852d-02,-4.9721410912351d-03,
     |   2.1260362599376d-02, 3.4727737197232d-02, 2.9248322185859d-02,
     |   9.4244358786462d-03,-1.3956515344458d-02,-3.0850615741293d-02,
     |  -3.6665547655147d-02,-3.2757404449469d-02,-2.3777627133307d-02,
     |  -1.4385569401299d-02,-7.2905605903465d-03,-3.0723345471567d-03,
     |  -1.0572427241103d-03,-2.8815110571472d-04,-5.9300576144814d-05,
     |  -8.5486429868230d-06,-7.6314644463112d-07,-3.3871692093870d-08,
     |  -4.7760809500604d-10,-8.4595340426006d-13, 6.6424121088075d-14/
      data (zmn(lat,13,23), lat = 1,72)/
     |   7.4614466444064d-14,-3.3487564687793d-14, 4.0357522430771d-11,
     |   4.0392023220535d-09, 1.1860811601667d-07, 1.6526169741636d-06,
     |   1.3849215538911d-05, 7.9776203677844d-05, 3.4285622610786d-04,
     |   1.1592714281235d-03, 3.1944864233683d-03, 7.3421924571512d-03,
     |   1.4273277670586d-02, 2.3600695411204d-02, 3.3053210751068d-02,
     |   3.8438534199009d-02, 3.5095448185754d-02, 2.0700802455874d-02,
     |  -1.9790873164693d-03,-2.4571706746795d-02,-3.6269676860321d-02,
     |  -2.9847671090143d-02,-7.1349286304532d-03, 2.0180973489651d-02,
     |   3.6237730193218d-02, 3.0607064790985d-02, 5.7781520079097d-03,
     |  -2.3151137389426d-02,-3.7482961678840d-02,-2.7305199307743d-02,
     |   1.1979610248867d-03, 2.9163740426894d-02, 3.7551114037883d-02,
     |   2.0354790696233d-02,-1.0865097946359d-02,-3.4700330490543d-02,
     |  -3.4700330490543d-02,-1.0865097946359d-02, 2.0354790696233d-02,
     |   3.7551114037883d-02, 2.9163740426894d-02, 1.1979610248866d-03,
     |  -2.7305199307743d-02,-3.7482961678840d-02,-2.3151137389426d-02,
     |   5.7781520079096d-03, 3.0607064790985d-02, 3.6237730193219d-02,
     |   2.0180973489651d-02,-7.1349286304532d-03,-2.9847671090143d-02,
     |  -3.6269676860321d-02,-2.4571706746795d-02,-1.9790873164693d-03,
     |   2.0700802455874d-02, 3.5095448185754d-02, 3.8438534199009d-02,
     |   3.3053210751068d-02, 2.3600695411204d-02, 1.4273277670586d-02,
     |   7.3421924571513d-03, 3.1944864233683d-03, 1.1592714281235d-03,
     |   3.4285622610782d-04, 7.9776203677815d-05, 1.3849215538831d-05,
     |   1.6526169741675d-06, 1.1860811602639d-07, 4.0392022844894d-09,
     |   4.0357507516922d-11,-3.3482638656942d-14, 7.4641560141479d-14/
      data (zmn(lat,14,23), lat = 1,72)/
     |   9.3680384221762d-16,-1.5654148762768d-15, 3.0511698837036d-12,
     |   4.3128161873811d-10, 1.6476526960735d-08, 2.8489435964746d-07,
     |   2.8754602877214d-06, 1.9558042643578d-05, 9.7950829175697d-05,
     |   3.8273618688201d-04, 1.2134873479374d-03, 3.2071142409463d-03,
     |   7.1947442390805d-03, 1.3853647881356d-02, 2.3000112239796d-02,
     |   3.2820215208640d-02, 3.9653731816363d-02, 3.8979037429847d-02,
     |   2.7697684555710d-02, 6.8001878156407d-03,-1.7351925432797d-02,
     |  -3.4725588111134d-02,-3.6354367506654d-02,-1.9934446792680d-02,
     |   7.2929053568570d-03, 3.1082892977862d-02, 3.7725065175389d-02,
     |   2.2523205736630d-02,-6.3167399798023d-03,-3.1688584185757d-02,
     |  -3.7790960242559d-02,-2.0340167725825d-02, 1.0076530412391d-02,
     |   3.4264866752505d-02, 3.6655396793020d-02, 1.5551546760463d-02,
     |  -1.5551546760462d-02,-3.6655396793020d-02,-3.4264866752505d-02,
     |  -1.0076530412391d-02, 2.0340167725825d-02, 3.7790960242559d-02,
     |   3.1688584185757d-02, 6.3167399798026d-03,-2.2523205736630d-02,
     |  -3.7725065175389d-02,-3.1082892977862d-02,-7.2929053568573d-03,
     |   1.9934446792680d-02, 3.6354367506654d-02, 3.4725588111134d-02,
     |   1.7351925432797d-02,-6.8001878156405d-03,-2.7697684555710d-02,
     |  -3.8979037429847d-02,-3.9653731816363d-02,-3.2820215208640d-02,
     |  -2.3000112239796d-02,-1.3853647881356d-02,-7.1947442390805d-03,
     |  -3.2071142409462d-03,-1.2134873479374d-03,-3.8273618688206d-04,
     |  -9.7950829175568d-05,-1.9558042643527d-05,-2.8754602877555d-06,
     |  -2.8489435970847d-07,-1.6476526960192d-08,-4.3128169083327d-10,
     |  -3.0512344568903d-12, 1.5359791955119d-15,-9.2221365977234d-16/
      data (zmn(lat,15,23), lat = 1,72)/
     |  -1.3695267474110d-15, 1.1832221082435d-15, 2.0531810205495d-13,
     |   4.1240495302932d-11, 2.0469085605822d-09, 4.3840774383250d-08,
     |   5.3166585187508d-07, 4.2570082044313d-06, 2.4748106087614d-05,
     |   1.1119332647199d-04, 4.0299459014571d-04, 1.2140885632162d-03,
     |   3.1055682780203d-03, 6.8440211116544d-03, 1.3113885567778d-02,
     |   2.1933848560424d-02, 3.1956819625873d-02, 4.0118279847995d-02,
     |   4.2203628546106d-02, 3.4587074913539d-02, 1.6639709471235d-02,
     |  -7.5054721774080d-03,-2.9357255836674d-02,-3.9305780719370d-02,
     |  -3.1634148336342d-02,-8.6271419679859d-03, 1.9122604546670d-02,
     |   3.7341602839189d-02, 3.5740641001254d-02, 1.4416474709600d-02,
     |  -1.5247198742891d-02,-3.6459872914023d-02,-3.6709851189989d-02,
     |  -1.5489931193089d-02, 1.4938696933718d-02, 3.6606647473455d-02,
     |   3.6606647473455d-02, 1.4938696933718d-02,-1.5489931193089d-02,
     |  -3.6709851189989d-02,-3.6459872914022d-02,-1.5247198742891d-02,
     |   1.4416474709600d-02, 3.5740641001254d-02, 3.7341602839189d-02,
     |   1.9122604546670d-02,-8.6271419679859d-03,-3.1634148336342d-02,
     |  -3.9305780719370d-02,-2.9357255836674d-02,-7.5054721774081d-03,
     |   1.6639709471235d-02, 3.4587074913539d-02, 4.2203628546105d-02,
     |   4.0118279847995d-02, 3.1956819625873d-02, 2.1933848560424d-02,
     |   1.3113885567778d-02, 6.8440211116543d-03, 3.1055682780203d-03,
     |   1.2140885632162d-03, 4.0299459014565d-04, 1.1119332647195d-04,
     |   2.4748106087599d-05, 4.2570082044202d-06, 5.3166585188052d-07,
     |   4.3840774369834d-08, 2.0469085213081d-09, 4.1240575695289d-11,
     |   2.0534517985742d-13, 1.1496323485570d-15,-1.3563094832826d-15/
      data (zmn(lat,16,23), lat = 1,72)/
     |  -9.6686871064296d-17,-6.1156978207755d-17, 1.2321814096604d-14,
     |   3.5251941093096d-12, 2.2707444750728d-10, 6.0154030330089d-09,
     |   8.7485624927959d-08, 8.2263534284483d-07, 5.5346317417611d-06,
     |   2.8485191099589d-05, 1.1744263111363d-04, 4.0081458205273d-04,
     |   1.1594741869638d-03, 2.8921288099966d-03, 6.2957917316019d-03,
     |   1.2054112866746d-02, 2.0373457391575d-02, 3.0367346420183d-02,
     |   3.9619254870473d-02, 4.4396808947658d-02, 4.0848972815551d-02,
     |   2.7009987895302d-02, 4.7461305344587d-03,-1.9638634579971d-02,
     |  -3.7111631299891d-02,-3.9768769832291d-02,-2.5206430827927d-02,
     |   1.0820922638876d-03, 2.7219169116003d-02, 4.0313887711860d-02,
     |   3.3229409656732d-02, 8.9781674110612d-03,-2.0146226561953d-02,
     |  -3.8755644805147d-02,-3.6714258675684d-02,-1.4925433623238d-02,
     |   1.4925433623238d-02, 3.6714258675684d-02, 3.8755644805147d-02,
     |   2.0146226561953d-02,-8.9781674110611d-03,-3.3229409656732d-02,
     |  -4.0313887711861d-02,-2.7219169116003d-02,-1.0820922638878d-03,
     |   2.5206430827927d-02, 3.9768769832291d-02, 3.7111631299891d-02,
     |   1.9638634579971d-02,-4.7461305344587d-03,-2.7009987895302d-02,
     |  -4.0848972815551d-02,-4.4396808947658d-02,-3.9619254870473d-02,
     |  -3.0367346420183d-02,-2.0373457391575d-02,-1.2054112866746d-02,
     |  -6.2957917316018d-03,-2.8921288099966d-03,-1.1594741869638d-03,
     |  -4.0081458205285d-04,-1.1744263111361d-04,-2.8485191099553d-05,
     |  -5.5346317417529d-06,-8.2263534284085d-07,-8.7485624856380d-08,
     |  -6.0154029693868d-09,-2.2707445100784d-10,-3.5251620737104d-12,
     |  -1.2227201418425d-14, 8.2815535588462d-17, 4.7131390526451d-17/
      data (zmn(lat,17,23), lat = 1,72)/
     |  -1.9265463277054d-17,-1.2000009932886d-16, 5.6480198364599d-16,
     |   2.6817539869527d-13, 2.2408749857701d-11, 7.3333680384148d-10,
     |   1.2770735242511d-08, 1.4075140009173d-07, 1.0932942240918d-06,
     |   6.4264419440610d-06, 3.0030083389309d-05, 1.1556382204448d-04,
     |   3.7583160396977d-04, 1.0529089705470d-03, 2.5773100212450d-03,
     |   5.5687264704912d-03, 1.0693545695569d-02, 1.8315593413888d-02,
     |   2.7980614098171d-02, 3.7947854432393d-02, 4.5131633124483d-02,
     |   4.5796285637957d-02, 3.7054055647885d-02, 1.8701383466769d-02,
     |  -5.5431089508749d-03,-2.8398122141692d-02,-4.1396000726848d-02,
     |  -3.8612967480011d-02,-2.0058110002118d-02, 7.2531217263606d-03,
     |   3.1644701764242d-02, 4.1902178211751d-02, 3.2820955342991d-02,
     |   8.2342207584249d-03,-2.0371126615427d-02,-3.9264687221602d-02,
     |  -3.9264687221602d-02,-2.0371126615427d-02, 8.2342207584248d-03,
     |   3.2820955342991d-02, 4.1902178211751d-02, 3.1644701764242d-02,
     |   7.2531217263607d-03,-2.0058110002118d-02,-3.8612967480011d-02,
     |  -4.1396000726848d-02,-2.8398122141692d-02,-5.5431089508751d-03,
     |   1.8701383466769d-02, 3.7054055647885d-02, 4.5796285637957d-02,
     |   4.5131633124483d-02, 3.7947854432393d-02, 2.7980614098171d-02,
     |   1.8315593413888d-02, 1.0693545695569d-02, 5.5687264704912d-03,
     |   2.5773100212450d-03, 1.0529089705470d-03, 3.7583160396980d-04,
     |   1.1556382204444d-04, 3.0030083389336d-05, 6.4264419441393d-06,
     |   1.0932942241041d-06, 1.4075140010668d-07, 1.2770735297736d-08,
     |   7.3333689286829d-10, 2.2408832307343d-11, 2.6815355599652d-13,
     |   5.8979808851733d-16,-8.7257718864660d-17,-2.1405249338744d-17/
      data (zmn(lat,18,23), lat = 1,72)/
     |   1.2704996129552d-17,-6.3842327074825d-18,-1.5992205986924d-17,
     |   1.7978844673559d-14, 1.9538195325096d-12, 7.8910974032747d-11,
     |   1.6433768000968d-09, 2.1196013539167d-08, 1.8971387936910d-07,
     |   1.2705881130840d-06, 6.7097551523984d-06, 2.9011036129645d-05,
     |   1.0559740798912d-04, 3.3040986128917d-04, 9.0290454003692d-04,
     |   2.1808152795022d-03, 4.6970924127377d-03, 9.0771497808528d-03,
     |   1.5796207336810d-02, 2.4776106636226d-02, 3.4940017361270d-02,
     |   4.3975587391947d-02, 4.8607497752095d-02, 4.5552220720732d-02,
     |   3.3001005258714d-02, 1.2069905016130d-02,-1.2593079298443d-02,
     |  -3.3705031901336d-02,-4.3799185668792d-02,-3.8426827091507d-02,
     |  -1.8665597698296d-02, 8.4894496018492d-03, 3.2444124386475d-02,
     |   4.3302104226590d-02, 3.6274955821595d-02, 1.4066248305093d-02,
     |  -1.4066248305092d-02,-3.6274955821595d-02,-4.3302104226590d-02,
     |  -3.2444124386475d-02,-8.4894496018493d-03, 1.8665597698296d-02,
     |   3.8426827091507d-02, 4.3799185668792d-02, 3.3705031901336d-02,
     |   1.2593079298443d-02,-1.2069905016130d-02,-3.3001005258714d-02,
     |  -4.5552220720732d-02,-4.8607497752095d-02,-4.3975587391947d-02,
     |  -3.4940017361270d-02,-2.4776106636226d-02,-1.5796207336810d-02,
     |  -9.0771497808528d-03,-4.6970924127378d-03,-2.1808152795021d-03,
     |  -9.0290454003693d-04,-3.3040986128909d-04,-1.0559740798909d-04,
     |  -2.9011036129546d-05,-6.7097551524449d-06,-1.2705881130544d-06,
     |  -1.8971387940639d-07,-2.1196013531249d-08,-1.6433768704848d-09,
     |  -7.8911007341398d-11,-1.9538185958671d-12,-1.7995223347435d-14,
     |  -7.3596087972446d-18,-2.8031960922566d-17, 1.2511899899332d-17/
      data (zmn(lat,19,23), lat = 1,72)/
     |  -6.0826002868558d-17,-1.4524184771580d-16,-1.7736346863202d-16,
     |   9.0230125782228d-16, 1.4879159121298d-13, 7.4141451635582d-12,
     |   1.8445312533892d-10, 2.7804448555029d-09, 2.8630382567508d-08,
     |   2.1805504578584d-07, 1.2982821466225d-06, 6.2890626892000d-06,
     |   2.5532477995826d-05, 8.8847801832056d-05, 2.6961570775752d-04,
     |   7.2308940434558d-04, 1.7316888323321d-03, 3.7323754854216d-03,
     |   7.2814375202915d-03, 1.2905703046614d-02, 2.0816643613925d-02,
     |   3.0535799632698d-02, 4.0579687867100d-02, 4.8427685877434d-02,
     |   5.0976470513498d-02, 4.5522728279042d-02, 3.1038579639850d-02,
     |   9.2304969164171d-03,-1.5225769450894d-02,-3.5674672686910d-02,
     |  -4.5596474522035d-02,-4.1156776263247d-02,-2.3117606769674d-02,
     |   2.8690134559312d-03, 2.7954675893519d-02, 4.3259651931145d-02,
     |   4.3259651931145d-02, 2.7954675893519d-02, 2.8690134559313d-03,
     |  -2.3117606769674d-02,-4.1156776263247d-02,-4.5596474522035d-02,
     |  -3.5674672686910d-02,-1.5225769450894d-02, 9.2304969164170d-03,
     |   3.1038579639850d-02, 4.5522728279042d-02, 5.0976470513498d-02,
     |   4.8427685877434d-02, 4.0579687867100d-02, 3.0535799632698d-02,
     |   2.0816643613925d-02, 1.2905703046614d-02, 7.2814375202915d-03,
     |   3.7323754854216d-03, 1.7316888323321d-03, 7.2308940434556d-04,
     |   2.6961570775754d-04, 8.8847801832082d-05, 2.5532477995833d-05,
     |   6.2890626892589d-06, 1.2982821466277d-06, 2.1805504575785d-07,
     |   2.8630382573438d-08, 2.7804448377678d-09, 1.8445306756453d-10,
     |   7.4140395368065d-12, 1.4877256875435d-13, 9.0310963187430d-16,
     |  -1.4516927803495d-16,-2.0389567560291d-16,-6.9226343329716d-17/
      data (zmn(lat,20,23), lat = 1,72)/
     |  -5.1314834917841d-18,-3.6200186424352d-17,-7.4233342725538d-17,
     |  -5.4837825818597d-17, 9.6100631873539d-15, 5.9751991471121d-13,
     |   1.7746279495356d-11, 3.1230002566661d-10, 3.6946702792359d-09,
     |   3.1948826613140d-08, 2.1405683831709d-07, 1.1590770358162d-06,
     |   5.2341012976893d-06, 2.0188618075693d-05, 6.7757281788453d-05,
     |   2.0077288777335d-04, 5.3130086914590d-04, 1.2670674665331d-03,
     |   2.7425868016144d-03, 5.4170558333907d-03, 9.8012136793943d-03,
     |   1.6282625503829d-02, 2.4854270283551d-02, 3.4813744057844d-02,
     |   4.4567911297420d-02, 5.1709582590497d-02, 5.3486473896488d-02,
     |   4.7643220957974d-02, 3.3420771865754d-02, 1.2331439478918d-02,
     |  -1.1703538784144d-02,-3.3100905128456d-02,-4.6158980167872d-02,
     |  -4.6936558924983d-02,-3.4773386871589d-02,-1.2807592658044d-02,
     |   1.2807592658043d-02, 3.4773386871589d-02, 4.6936558924983d-02,
     |   4.6158980167872d-02, 3.3100905128456d-02, 1.1703538784144d-02,
     |  -1.2331439478918d-02,-3.3420771865754d-02,-4.7643220957974d-02,
     |  -5.3486473896488d-02,-5.1709582590497d-02,-4.4567911297420d-02,
     |  -3.4813744057844d-02,-2.4854270283551d-02,-1.6282625503830d-02,
     |  -9.8012136793944d-03,-5.4170558333907d-03,-2.7425868016144d-03,
     |  -1.2670674665331d-03,-5.3130086914593d-04,-2.0077288777342d-04,
     |  -6.7757281788420d-05,-2.0188618075688d-05,-5.2341012977191d-06,
     |  -1.1590770358278d-06,-2.1405683824494d-07,-3.1948826650397d-08,
     |  -3.6946702665434d-09,-3.1230000933276d-10,-1.7746270014780d-11,
     |  -5.9757017851638d-13,-9.5794934277469d-15, 6.4395929261453d-17,
     |   9.1928522886550d-18, 1.0743322247810d-16, 1.5675253316780d-17/
      data (zmn(lat,21,23), lat = 1,72)/
     |  -3.7842553683810d-17,-1.0680739684199d-16,-1.5954113517360d-16,
     |  -1.7733038245607d-16, 3.5241776763015d-16, 3.9963754390399d-14,
     |   1.4207438110885d-12, 2.9163573387957d-11, 3.9595792387087d-10,
     |   3.8822932073357d-09, 2.9224367237861d-08, 1.7655428604391d-07,
     |   8.8483409383808d-07, 3.7729668635736d-06, 1.3960508701996d-05,
     |   4.5528680162007d-05, 1.3250922333111d-04, 3.4764980245778d-04,
     |   8.2887685924401d-04, 1.8076667607093d-03, 3.6246887782648d-03,
     |   6.7092436722525d-03, 1.1496617728898d-02, 1.8269170911285d-02,
     |   2.6936915186155d-02, 3.6816447760207d-02, 4.6506352887553d-02,
     |   5.3967605533773d-02, 5.6877874635586d-02, 5.3236465245983d-02,
     |   4.2077933353866d-02, 2.4057434948119d-02, 1.6539734470417d-03,
     |  -2.1171527107303d-02,-3.9845406258045d-02,-5.0354009389128d-02,
     |  -5.0354009389128d-02,-3.9845406258045d-02,-2.1171527107303d-02,
     |   1.6539734470416d-03, 2.4057434948119d-02, 4.2077933353866d-02,
     |   5.3236465245983d-02, 5.6877874635586d-02, 5.3967605533773d-02,
     |   4.6506352887553d-02, 3.6816447760207d-02, 2.6936915186155d-02,
     |   1.8269170911285d-02, 1.1496617728898d-02, 6.7092436722525d-03,
     |   3.6246887782648d-03, 1.8076667607094d-03, 8.2887685924402d-04,
     |   3.4764980245776d-04, 1.3250922333116d-04, 4.5528680162013d-05,
     |   1.3960508701981d-05, 3.7729668635594d-06, 8.8483409383374d-07,
     |   1.7655428604229d-07, 2.9224367290817d-08, 3.8822931623578d-09,
     |   3.9595789293046d-10, 2.9163570061837d-11, 1.4207968012190d-12,
     |   4.0037871540890d-14, 3.7774836059302d-16,-1.7137652198806d-16,
     |  -1.8862927851113d-16,-1.1140801304688d-17, 4.6676787487323d-18/
      data (zmn(lat,22,23), lat = 1,72)/
     |   9.8733980389069d-18,-1.1113442312694d-17,-4.6011673972900d-17,
     |  -9.0214053132353d-17,-9.7193297426787d-17, 1.9839939291815d-15,
     |   8.9322687762082d-14, 2.1399417766447d-12, 3.3313899812252d-11,
     |   3.6994321877210d-10, 3.1246094618303d-09, 2.1028026831746d-08,
     |   1.1674450514228d-07, 5.4912776052875d-07, 2.2343411598262d-06,
     |   7.9955711640591d-06, 2.5501216621733d-05, 7.3281718387214d-05,
     |   1.9143474605966d-04, 4.5795865772328d-04, 1.0093653869731d-03,
     |   2.0599664048997d-03, 3.9087373479645d-03, 6.9182987546210d-03,
     |   1.1451006644898d-02, 1.7756016720150d-02, 2.5819488065758d-02,
     |   3.5213957469420d-02, 4.5003101697536d-02, 5.3762637104665d-02,
     |   5.9757816506287d-02, 6.1272707525396d-02, 5.7028334308637d-02,
     |   4.6577853308272d-02, 3.0550590622152d-02, 1.0646487023993d-02,
     |  -1.0646487023993d-02,-3.0550590622152d-02,-4.6577853308272d-02,
     |  -5.7028334308637d-02,-6.1272707525396d-02,-5.9757816506287d-02,
     |  -5.3762637104665d-02,-4.5003101697536d-02,-3.5213957469420d-02,
     |  -2.5819488065758d-02,-1.7756016720151d-02,-1.1451006644898d-02,
     |  -6.9182987546210d-03,-3.9087373479645d-03,-2.0599664048997d-03,
     |  -1.0093653869731d-03,-4.5795865772327d-04,-1.9143474605966d-04,
     |  -7.3281718387230d-05,-2.5501216621710d-05,-7.9955711640615d-06,
     |  -2.2343411598699d-06,-5.4912776057047d-07,-1.1674450510608d-07,
     |  -2.1028026829861d-08,-3.1246094489166d-09,-3.6994320374665d-10,
     |  -3.3313930417482d-11,-2.1399419857373d-12,-8.9317843350958d-14,
     |  -1.9340211810682d-15, 3.8547381484273d-17, 9.9402712832396d-17,
     |   8.4698179242489d-17,-1.6981760443953d-17,-7.6551624051493d-18/
      data (zmn(lat,23,23), lat = 1,72)/
     |  -1.6316335173120d-17,-5.6104207388025d-17,-7.6968536960500d-17,
     |  -9.6722747189293d-17,-1.1281634874272d-16,-4.7705081886560d-17,
     |   3.7216141297258d-15, 1.0699470850492d-13, 1.9100205080363d-12,
     |   2.4000349796400d-11, 2.2719130265004d-10, 1.7009450035973d-09,
     |   1.0445127969584d-08, 5.4098730066998d-08, 2.4155219872770d-07,
     |   9.4615335920113d-07, 3.2973870057388d-06, 1.0343345730005d-05,
     |   2.9484755993609d-05, 7.6994449887957d-05, 1.8542937462677d-04,
     |   4.1422928284755d-04, 8.6251168171766d-04, 1.6809862576552d-03,
     |   3.0774717541989d-03, 5.3087420070117d-03, 8.6517834462223d-03,
     |   1.3351243840225d-02, 1.9547097065567d-02, 2.7195853378378d-02,
     |   3.6006805948437d-02, 4.5417828843231d-02, 5.4630051685910d-02,
     |   6.2706967019487d-02, 6.8724456254549d-02, 7.1940114062741d-02,
     |   7.1940114062741d-02, 6.8724456254549d-02, 6.2706967019487d-02,
     |   5.4630051685910d-02, 4.5417828843231d-02, 3.6006805948437d-02,
     |   2.7195853378378d-02, 1.9547097065567d-02, 1.3351243840225d-02,
     |   8.6517834462223d-03, 5.3087420070117d-03, 3.0774717541989d-03,
     |   1.6809862576552d-03, 8.6251168171766d-04, 4.1422928284755d-04,
     |   1.8542937462677d-04, 7.6994449887956d-05, 2.9484755993596d-05,
     |   1.0343345730016d-05, 3.2973870057074d-06, 9.4615335921004d-07,
     |   2.4155219872116d-07, 5.4098730072207d-08, 1.0445127976954d-08,
     |   1.7009450116129d-09, 2.2719130938288d-10, 2.4000389842072d-11,
     |   1.9100418258284d-12, 1.0700848069356d-13, 3.7169487037918d-15,
     |  -3.7978878356981d-17,-1.0670809902061d-16,-5.3073850356188d-17,
     |  -5.8412786958397d-17,-6.0453133248095d-17,-3.5665200565475d-17/
      data (zmn(lat, 0,24), lat = 1,72)/
     |   3.7339809402633d-03, 6.7912037597776d-03,-3.3275955479418d-03,
     |  -1.3009626913695d-02,-1.0178873331317d-02, 6.1149630411213d-03,
     |   1.8112295359778d-02, 1.1815900921488d-02,-8.8914515457733d-03,
     |  -2.1960034508791d-02,-1.2485916511304d-02, 1.1700721673754d-02,
     |   2.5013359364846d-02, 1.2449675089288d-02,-1.4512541745555d-02,
     |  -2.7429105979191d-02,-1.1849632402071d-02, 1.7278448568153d-02,
     |   2.9276110071792d-02, 1.0785397550336d-02,-1.9944703858443d-02,
     |  -3.0590525559882d-02,-9.3384365574927d-03, 2.2456848593818d-02,
     |   3.1395956663330d-02, 7.5821655282800d-03,-2.4761870866138d-02,
     |  -3.1712344650566d-02,-5.5865399907981d-03, 2.6809506189947d-02,
     |   3.1560367040807d-02, 3.4202054801367d-03,-2.8553134099155d-02,
     |  -3.0963741428594d-02,-1.1514511445907d-03, 2.9950420562004d-02,
     |   2.9950420562004d-02,-1.1514511445905d-03,-3.0963741428594d-02,
     |  -2.8553134099155d-02, 3.4202054801366d-03, 3.1560367040807d-02,
     |   2.6809506189947d-02,-5.5865399907977d-03,-3.1712344650566d-02,
     |  -2.4761870866138d-02, 7.5821655282799d-03, 3.1395956663329d-02,
     |   2.2456848593818d-02,-9.3384365574928d-03,-3.0590525559882d-02,
     |  -1.9944703858443d-02, 1.0785397550336d-02, 2.9276110071792d-02,
     |   1.7278448568153d-02,-1.1849632402071d-02,-2.7429105979191d-02,
     |  -1.4512541745555d-02, 1.2449675089288d-02, 2.5013359364846d-02,
     |   1.1700721673754d-02,-1.2485916511304d-02,-2.1960034508791d-02,
     |  -8.8914515457735d-03, 1.1815900921488d-02, 1.8112295359778d-02,
     |   6.1149630411214d-03,-1.0178873331317d-02,-1.3009626913695d-02,
     |  -3.3275955479418d-03, 6.7912037597776d-03, 3.7339809402633d-03/
      data (zmn(lat, 1,24), lat = 1,72)/
     |   1.4151647066798d-03, 7.9797790938782d-03, 1.0635742911287d-02,
     |   1.1892150413988d-03,-1.2666176256743d-02,-1.5432076482164d-02,
     |  -1.2380530716333d-03, 1.6576539355779d-02, 1.8586603784128d-02,
     |   4.2659551956669d-04,-2.0048777247583d-02,-2.0743765845077d-02,
     |   9.1803395144934d-04, 2.3169776966439d-02, 2.2142527796603d-02,
     |  -2.6378365522951d-03,-2.5955414724109d-02,-2.2905423852298d-02,
     |   4.6247750635714d-03, 2.8396151470939d-02, 2.3111074462286d-02,
     |  -6.7909506159949d-03,-3.0473185799191d-02,-2.2819923179755d-02,
     |   9.0582191395324d-03, 3.2165567136851d-02, 2.2085270948188d-02,
     |  -1.1353994018236d-02,-3.3453830906503d-02,-2.0958546500006d-02,
     |   1.3609482431748d-02, 3.4322047692436d-02, 1.9491951779031d-02,
     |  -1.5759000257179d-02,-3.4759031780058d-02,-1.7739777785598d-02,
     |   1.7739777785598d-02, 3.4759031780058d-02, 1.5759000257180d-02,
     |  -1.9491951779031d-02,-3.4322047692436d-02,-1.3609482431748d-02,
     |   2.0958546500006d-02, 3.3453830906503d-02, 1.1353994018236d-02,
     |  -2.2085270948188d-02,-3.2165567136852d-02,-9.0582191395327d-03,
     |   2.2819923179755d-02, 3.0473185799191d-02, 6.7909506159949d-03,
     |  -2.3111074462286d-02,-2.8396151470939d-02,-4.6247750635714d-03,
     |   2.2905423852298d-02, 2.5955414724109d-02, 2.6378365522954d-03,
     |  -2.2142527796603d-02,-2.3169776966439d-02,-9.1803395144949d-04,
     |   2.0743765845077d-02, 2.0048777247583d-02,-4.2659551956660d-04,
     |  -1.8586603784128d-02,-1.6576539355779d-02, 1.2380530716334d-03,
     |   1.5432076482164d-02, 1.2666176256743d-02,-1.1892150413990d-03,
     |  -1.0635742911287d-02,-7.9797790938783d-03,-1.4151647066799d-03/
      data (zmn(lat, 2,24), lat = 1,72)/
     |   1.8804305824258d-04, 3.6128379033915d-03, 1.1001588128798d-02,
     |   1.3858360993778d-02, 4.8370247910088d-03,-1.1160370780914d-02,
     |  -1.8592963882429d-02,-7.7533379757423d-03, 1.2738092871417d-02,
     |   2.2144257680080d-02, 9.1208874285427d-03,-1.4757946741002d-02,
     |  -2.4980901790275d-02,-9.5895238607203d-03, 1.6965664933408d-02,
     |   2.7243542731396d-02, 9.4146134764308d-03,-1.9232874427563d-02,
     |  -2.8991681173109d-02,-8.7403874952911d-03, 2.1470947312794d-02,
     |   3.0256413420273d-02, 7.6686871472575d-03,-2.3608680679252d-02,
     |  -3.1058450456683d-02,-6.2827115198861d-03, 2.5584809300722d-02,
     |   3.1415895167249d-02, 4.6569153970880d-03,-2.7345168663322d-02,
     |  -3.1348081203223d-02,-2.8615875099771d-03, 2.8841586837309d-02,
     |   3.0877611515466d-02, 9.6507976225478d-04,-3.0031465934772d-02,
     |  -3.0031465934772d-02, 9.6507976225466d-04, 3.0877611515466d-02,
     |   2.8841586837309d-02,-2.8615875099769d-03,-3.1348081203223d-02,
     |  -2.7345168663322d-02, 4.6569153970877d-03, 3.1415895167249d-02,
     |   2.5584809300722d-02,-6.2827115198860d-03,-3.1058450456683d-02,
     |  -2.3608680679252d-02, 7.6686871472576d-03, 3.0256413420273d-02,
     |   2.1470947312794d-02,-8.7403874952909d-03,-2.8991681173109d-02,
     |  -1.9232874427563d-02, 9.4146134764308d-03, 2.7243542731396d-02,
     |   1.6965664933408d-02,-9.5895238607204d-03,-2.4980901790275d-02,
     |  -1.4757946741003d-02, 9.1208874285430d-03, 2.2144257680080d-02,
     |   1.2738092871417d-02,-7.7533379757422d-03,-1.8592963882429d-02,
     |  -1.1160370780914d-02, 4.8370247910085d-03, 1.3858360993778d-02,
     |   1.1001588128798d-02, 3.6128379033916d-03, 1.8804305824262d-04/
      data (zmn(lat, 3,24), lat = 1,72)/
     |   5.1652256993773d-06, 1.0293065924678d-03, 5.8260468020805d-03,
     |   1.3573501560679d-02, 1.6710467510453d-02, 7.9878620670850d-03,
     |  -9.2163549693625d-03,-2.0391604523894d-02,-1.3262406723799d-02,
     |   7.8209796791956d-03, 2.3162359966443d-02, 1.6387879839607d-02,
     |  -7.6668696948812d-03,-2.5613795683747d-02,-1.8408760166114d-02,
     |   8.2070818850669d-03, 2.7815261687365d-02, 1.9674353570347d-02,
     |  -9.1845783264237d-03,-2.9760316095752d-02,-2.0349865337506d-02,
     |   1.0444109267988d-02, 3.1427288059573d-02, 2.0534699811865d-02,
     |  -1.1874481165462d-02,-3.2792885924075d-02,-2.0301188705455d-02,
     |   1.3386531443865d-02, 3.3836428057690d-02, 1.9710178031272d-02,
     |  -1.4903478701325d-02,-3.4541536666552d-02,-1.8818208520003d-02,
     |   1.6356273360001d-02, 3.4896952014362d-02, 1.7681158797916d-02,
     |  -1.7681158797916d-02,-3.4896952014362d-02,-1.6356273360001d-02,
     |   1.8818208520003d-02, 3.4541536666552d-02, 1.4903478701324d-02,
     |  -1.9710178031272d-02,-3.3836428057690d-02,-1.3386531443865d-02,
     |   2.0301188705455d-02, 3.2792885924075d-02, 1.1874481165462d-02,
     |  -2.0534699811865d-02,-3.1427288059573d-02,-1.0444109267988d-02,
     |   2.0349865337506d-02, 2.9760316095752d-02, 9.1845783264237d-03,
     |  -1.9674353570347d-02,-2.7815261687365d-02,-8.2070818850671d-03,
     |   1.8408760166114d-02, 2.5613795683748d-02, 7.6668696948813d-03,
     |  -1.6387879839607d-02,-2.3162359966443d-02,-7.8209796791957d-03,
     |   1.3262406723799d-02, 2.0391604523894d-02, 9.2163549693625d-03,
     |  -7.9878620670850d-03,-1.6710467510453d-02,-1.3573501560679d-02,
     |  -5.8260468020806d-03,-1.0293065924678d-03,-5.1652256993119d-06/
      data (zmn(lat, 4,24), lat = 1,72)/
     |   4.1069057754602d-07, 2.1099652763456d-04, 2.1313982210068d-03,
     |   7.8735476956508d-03, 1.5939596101931d-02, 1.9282720418970d-02,
     |   1.0873488277754d-02,-7.0795131332400d-03,-2.1234183383391d-02,
     |  -1.7865384890607d-02, 2.4602040757142d-03, 2.2219042880873d-02,
     |   2.1986481339416d-02, 1.4890889213907d-04,-2.3260329374383d-02,
     |  -2.4855512435082d-02,-1.6112915057209d-03, 2.4413095407236d-02,
     |   2.6966420217004d-02, 2.3245127938089d-03,-2.5619167748156d-02,
     |  -2.8517636187956d-02,-2.5098907072715d-03, 2.6810333938792d-02,
     |   2.9606139586564d-02, 2.3118284051983d-03,-2.7924035695891d-02,
     |  -3.0288797791140d-02,-1.8376177112431d-03, 2.8905015707023d-02,
     |   3.0605949697676d-02, 1.1755155534421d-03,-2.9704597865827d-02,
     |  -3.0591830554507d-02,-4.0385219491816d-04, 3.0279698312007d-02,
     |   3.0279698312008d-02,-4.0385219491809d-04,-3.0591830554507d-02,
     |  -2.9704597865827d-02, 1.1755155534420d-03, 3.0605949697676d-02,
     |   2.8905015707023d-02,-1.8376177112428d-03,-3.0288797791140d-02,
     |  -2.7924035695891d-02, 2.3118284051982d-03, 2.9606139586564d-02,
     |   2.6810333938792d-02,-2.5098907072716d-03,-2.8517636187956d-02,
     |  -2.5619167748156d-02, 2.3245127938087d-03, 2.6966420217004d-02,
     |   2.4413095407236d-02,-1.6112915057208d-03,-2.4855512435082d-02,
     |  -2.3260329374383d-02, 1.4890889213908d-04, 2.1986481339415d-02,
     |   2.2219042880873d-02, 2.4602040757141d-03,-1.7865384890607d-02,
     |  -2.1234183383391d-02,-7.0795131332401d-03, 1.0873488277754d-02,
     |   1.9282720418970d-02, 1.5939596101931d-02, 7.8735476956508d-03,
     |   2.1313982210067d-03, 2.1099652763458d-04, 4.1069057753779d-07/
      data (zmn(lat, 5,24), lat = 1,72)/
     |   3.7702350101536d-07, 3.3648553789134d-05, 5.9804768028901d-04,
     |   3.3267358624275d-03, 9.7929946202618d-03, 1.8134503419864d-02,
     |   2.1671152857443d-02, 1.3604584805455d-02,-4.7854487512521d-03,
     |  -2.1361366936813d-02,-2.1665038513609d-02,-3.0464813173279d-03,
     |   1.9754703677838d-02, 2.5864541428651d-02, 7.9967721102671d-03,
     |  -1.8550264506037d-02,-2.8617435013903d-02,-1.1337512539520d-02,
     |   1.7822215868700d-02, 3.0642698360363d-02, 1.3658877007054d-02,
     |  -1.7461139056009d-02,-3.2201047648258d-02,-1.5270921203405d-02,
     |   1.7350878843415d-02, 3.3397653553948d-02, 1.6358566960237d-02,
     |  -1.7390522673656d-02,-3.4276868853495d-02,-1.7046323082304d-02,
     |   1.7493021053664d-02, 3.4857285109467d-02, 1.7428142939307d-02,
     |  -1.7580940265543d-02,-3.5146263717523d-02,-1.7582531369411d-02,
     |   1.7582531369411d-02, 3.5146263717523d-02, 1.7580940265543d-02,
     |  -1.7428142939307d-02,-3.4857285109467d-02,-1.7493021053664d-02,
     |   1.7046323082304d-02, 3.4276868853495d-02, 1.7390522673656d-02,
     |  -1.6358566960237d-02,-3.3397653553948d-02,-1.7350878843416d-02,
     |   1.5270921203405d-02, 3.2201047648258d-02, 1.7461139056009d-02,
     |  -1.3658877007054d-02,-3.0642698360363d-02,-1.7822215868700d-02,
     |   1.1337512539520d-02, 2.8617435013903d-02, 1.8550264506037d-02,
     |  -7.9967721102672d-03,-2.5864541428651d-02,-1.9754703677838d-02,
     |   3.0464813173280d-03, 2.1665038513609d-02, 2.1361366936813d-02,
     |   4.7854487512522d-03,-1.3604584805455d-02,-2.1671152857443d-02,
     |  -1.8134503419864d-02,-9.7929946202619d-03,-3.3267358624276d-03,
     |  -5.9804768028886d-04,-3.3648553789160d-05,-3.7702350107005d-07/
      data (zmn(lat, 6,24), lat = 1,72)/
     |   1.4599707782964d-08, 4.4575212482197d-06, 1.3588004589485d-04,
     |   1.1118227836755d-03, 4.5417563620362d-03, 1.1590570497710d-02,
     |   2.0172972962688d-02, 2.3928530982469d-02, 1.6264940157416d-02,
     |  -2.3125128887972d-03,-2.0883229626401d-02,-2.4738725218358d-02,
     |  -8.5430696669146d-03, 1.6063437950509d-02, 2.8031390904615d-02,
     |   1.5391746928509d-02,-1.2042816848185d-02,-2.9586779989206d-02,
     |  -2.0055989796626d-02, 8.9111454398176d-03, 3.0434448296221d-02,
     |   2.3404210142619d-02,-6.4803702350895d-03,-3.0925760661334d-02,
     |  -2.5877716969829d-02, 4.5665358538543d-03, 3.1182739026019d-02,
     |   2.7720764515053d-02,-3.0199283088115d-03,-3.1238519370634d-02,
     |  -2.9080381550618d-02, 1.7183897546954d-03, 3.1087562456057d-02,
     |   3.0052557207427d-02,-5.5750552419558d-04,-3.0704845828261d-02,
     |  -3.0704845828261d-02,-5.5750552419570d-04, 3.0052557207427d-02,
     |   3.1087562456057d-02, 1.7183897546954d-03,-2.9080381550618d-02,
     |  -3.1238519370634d-02,-3.0199283088117d-03, 2.7720764515053d-02,
     |   3.1182739026019d-02, 4.5665358538544d-03,-2.5877716969829d-02,
     |  -3.0925760661334d-02,-6.4803702350895d-03, 2.3404210142619d-02,
     |   3.0434448296221d-02, 8.9111454398178d-03,-2.0055989796626d-02,
     |  -2.9586779989206d-02,-1.2042816848185d-02, 1.5391746928508d-02,
     |   2.8031390904615d-02, 1.6063437950509d-02,-8.5430696669144d-03,
     |  -2.4738725218358d-02,-2.0883229626401d-02,-2.3125128887973d-03,
     |   1.6264940157416d-02, 2.3928530982469d-02, 2.0172972962688d-02,
     |   1.1590570497710d-02, 4.5417563620361d-03, 1.1118227836756d-03,
     |   1.3588004589497d-04, 4.4575212481888d-06, 1.4599707782335d-08/
      data (zmn(lat, 7,24), lat = 1,72)/
     |  -9.9741608733032d-09, 5.0879691735623d-07, 2.5869333166598d-05,
     |   3.0725888883996d-04, 1.7014464404584d-03, 5.7338420986172d-03,
     |   1.3255979945538d-02, 2.2059431122879d-02, 2.6083897813643d-02,
     |   1.8919966057430d-02, 3.8449013721689d-04,-1.9828101922425d-02,
     |  -2.7117865802969d-02,-1.3928552404714d-02, 1.1338585723692d-02,
     |   2.8490928621055d-02, 2.1947578765154d-02,-4.2419048967938d-03,
     |  -2.7766123972374d-02,-2.7000512965449d-02,-1.3963984158670d-03,
     |   2.6365495906588d-02, 3.0345819819930d-02, 5.9009746729197d-03,
     |  -2.4748507905704d-02,-3.2610889042845d-02,-9.5633590760948d-03,
     |   2.3052745155863d-02, 3.4122742686876d-02, 1.2603165461334d-02,
     |  -2.1294979383465d-02,-3.5056492951314d-02,-1.5183816460519d-02,
     |   1.9440923024707d-02, 3.5503638693514d-02, 1.7430202744426d-02,
     |  -1.7430202744426d-02,-3.5503638693514d-02,-1.9440923024707d-02,
     |   1.5183816460518d-02, 3.5056492951314d-02, 2.1294979383465d-02,
     |  -1.2603165461334d-02,-3.4122742686876d-02,-2.3052745155863d-02,
     |   9.5633590760947d-03, 3.2610889042845d-02, 2.4748507905704d-02,
     |  -5.9009746729196d-03,-3.0345819819930d-02,-2.6365495906588d-02,
     |   1.3963984158667d-03, 2.7000512965449d-02, 2.7766123972374d-02,
     |   4.2419048967939d-03,-2.1947578765154d-02,-2.8490928621055d-02,
     |  -1.1338585723692d-02, 1.3928552404714d-02, 2.7117865802969d-02,
     |   1.9828101922425d-02,-3.8449013721694d-04,-1.8919966057430d-02,
     |  -2.6083897813643d-02,-2.2059431122879d-02,-1.3255979945538d-02,
     |  -5.7338420986173d-03,-1.7014464404585d-03,-3.0725888883983d-04,
     |  -2.5869333166729d-05,-5.0879691734073d-07, 9.9741608551592d-09/
      data (zmn(lat, 8,24), lat = 1,72)/
     |  -2.6958149072058d-10, 4.8856211065489d-08, 4.2247631402650d-06,
     |   7.2185618551441d-05, 5.3455026212268d-04, 2.3263169832517d-03,
     |   6.8677876098645d-03, 1.4772420034164d-02, 2.3788329711206d-02,
     |   2.8151939168303d-02, 2.1618245826602d-02, 3.3610498805880d-03,
     |  -1.8171955820630d-02,-2.8781272251386d-02,-1.9107671852263d-02,
     |   5.7195235201914d-03, 2.7218785320552d-02, 2.7305290388517d-02,
     |   4.3577476977471d-03,-2.3238179109678d-02,-3.1496286834485d-02,
     |  -1.2099532706120d-02, 1.8734057691011d-02, 3.3470527814854d-02,
     |   1.8058765554501d-02,-1.4278013569038d-02,-3.4107254243560d-02,
     |  -2.2694171924638d-02, 1.0011247587677d-02, 3.3842923169150d-02,
     |   2.6324416267016d-02,-5.9259729451053d-03,-3.2887824584401d-02,
     |  -2.9158808963288d-02, 1.9614232392403d-03, 3.1325725229352d-02,
     |   3.1325725229352d-02, 1.9614232392404d-03,-2.9158808963288d-02,
     |  -3.2887824584401d-02,-5.9259729451053d-03, 2.6324416267016d-02,
     |   3.3842923169150d-02, 1.0011247587677d-02,-2.2694171924638d-02,
     |  -3.4107254243560d-02,-1.4278013569039d-02, 1.8058765554501d-02,
     |   3.3470527814854d-02, 1.8734057691011d-02,-1.2099532706120d-02,
     |  -3.1496286834485d-02,-2.3238179109678d-02, 4.3577476977470d-03,
     |   2.7305290388517d-02, 2.7218785320552d-02, 5.7195235201916d-03,
     |  -1.9107671852263d-02,-2.8781272251386d-02,-1.8171955820630d-02,
     |   3.3610498805880d-03, 2.1618245826602d-02, 2.8151939168304d-02,
     |   2.3788329711206d-02, 1.4772420034164d-02, 6.8677876098644d-03,
     |   2.3263169832518d-03, 5.3455026212274d-04, 7.2185618551385d-05,
     |   4.2247631401184d-06, 4.8856211149940d-08,-2.6958147453865d-10/
      data (zmn(lat, 9,24), lat = 1,72)/
     |   2.8713017018955d-10, 3.8170064861666d-09, 6.0130247927146d-07,
     |   1.4689589745312d-05, 1.4420647623733d-04, 7.9966766356484d-04,
     |   2.9513576564708d-03, 7.9109781915683d-03, 1.6118266734989d-02,
     |   2.5345565652972d-02, 3.0134219766356d-02, 2.4392153765065d-02,
     |   6.6736391877845d-03,-1.5855018233776d-02,-2.9654661365685d-02,
     |  -2.3957213310001d-02,-6.6619139773937d-04, 2.4166898833112d-02,
     |   3.1088436253707d-02, 1.3216211487549d-02,-1.6184251371433d-02,
     |  -3.2939480445484d-02,-2.2085969267621d-02, 8.1526427656632d-03,
     |   3.2019298157314d-02, 2.8198488549426d-02,-7.4274140870384d-04,
     |  -2.9544557974982d-02,-3.2269582055793d-02,-5.9240705257669d-03,
     |   2.6100536670872d-02, 3.4762913410252d-02, 1.1887487191645d-02,
     |  -2.1956887480344d-02,-3.5948042562326d-02,-1.7216375499886d-02,
     |   1.7216375499886d-02, 3.5948042562326d-02, 2.1956887480344d-02,
     |  -1.1887487191645d-02,-3.4762913410252d-02,-2.6100536670871d-02,
     |   5.9240705257668d-03, 3.2269582055792d-02, 2.9544557974982d-02,
     |   7.4274140870394d-04,-2.8198488549426d-02,-3.2019298157314d-02,
     |  -8.1526427656633d-03, 2.2085969267621d-02, 3.2939480445484d-02,
     |   1.6184251371433d-02,-1.3216211487549d-02,-3.1088436253707d-02,
     |  -2.4166898833112d-02, 6.6619139773934d-04, 2.3957213310001d-02,
     |   2.9654661365685d-02, 1.5855018233776d-02,-6.6736391877844d-03,
     |  -2.4392153765065d-02,-3.0134219766356d-02,-2.5345565652972d-02,
     |  -1.6118266734989d-02,-7.9109781915683d-03,-2.9513576564708d-03,
     |  -7.9966766356481d-04,-1.4420647623736d-04,-1.4689589745371d-05,
     |  -6.0130247917025d-07,-3.8170064767111d-09,-2.8713009115821d-10/
      data (zmn(lat,10,24), lat = 1,72)/
     |   5.8441870357096d-12, 2.8757987736832d-10, 7.5370326373133d-08,
     |   2.6237029263654d-06, 3.3940832352138d-05, 2.3773549040872d-04,
     |   1.0827494983326d-03, 3.5444730196314d-03, 8.8318280954241d-03,
     |   1.7267583239906d-02, 2.6708429963696d-02, 3.2017963479895d-02,
     |   2.7255703728173d-02, 1.0371723045712d-02,-1.2793970103897d-02,
     |  -2.9611679795553d-02,-2.8300430241113d-02,-7.6612996441796d-03,
     |   1.9286887139315d-02, 3.2882801998957d-02, 2.1694170019078d-02,
     |  -6.9394114709510d-03,-3.0824206338115d-02,-3.0112923575486d-02,
     |  -4.3733367869585d-03, 2.5611582987193d-02, 3.4443439504806d-02,
     |   1.3933638793687d-02,-1.8917345234844d-02,-3.5811251838361d-02,
     |  -2.1694347362252d-02, 1.1541085819108d-02, 3.4921501546470d-02,
     |   2.7752263699147d-02,-3.8737211545753d-03,-3.2173161847231d-02,
     |  -3.2173161847231d-02,-3.8737211545753d-03, 2.7752263699147d-02,
     |   3.4921501546470d-02, 1.1541085819108d-02,-2.1694347362252d-02,
     |  -3.5811251838361d-02,-1.8917345234844d-02, 1.3933638793687d-02,
     |   3.4443439504806d-02, 2.5611582987193d-02,-4.3733367869582d-03,
     |  -3.0112923575486d-02,-3.0824206338115d-02,-6.9394114709510d-03,
     |   2.1694170019078d-02, 3.2882801998957d-02, 1.9286887139315d-02,
     |  -7.6612996441795d-03,-2.8300430241113d-02,-2.9611679795553d-02,
     |  -1.2793970103896d-02, 1.0371723045712d-02, 2.7255703728172d-02,
     |   3.2017963479895d-02, 2.6708429963696d-02, 1.7267583239906d-02,
     |   8.8318280954241d-03, 3.5444730196313d-03, 1.0827494983326d-03,
     |   2.3773549040863d-04, 3.3940832352136d-05, 2.6237029263983d-06,
     |   7.5370326481183d-08, 2.8757976075696d-10, 5.8441354390670d-12/
      data (zmn(lat,11,24), lat = 1,72)/
     |  -7.5433941057303d-12, 2.6730806538132d-11, 8.3876901364193d-09,
     |   4.1519932613276d-07, 7.0474496671400d-06, 6.1974127700631d-05,
     |   3.4531465881835d-04, 1.3633290060893d-03, 4.0756543160749d-03,
     |   9.5992248726636d-03, 1.8190336833857d-02, 2.7844687356252d-02,
     |   3.3773495911070d-02, 3.0199947384091d-02, 1.4488701196376d-02,
     |  -8.8940286944641d-03,-2.8476960688850d-02,-3.1886030686170d-02,
     |  -1.5034921831572d-02, 1.2571625325813d-02, 3.2242587568087d-02,
     |   2.9007774509923d-02, 3.9234779652996d-03,-2.4827132646718d-02,
     |  -3.4833999716463d-02,-1.7356695440533d-02, 1.4450840275665d-02,
     |   3.5037131752516d-02, 2.7119616388870d-02,-3.3870800525999d-03,
     |  -3.1424211150775d-02,-3.3391114283338d-02,-7.2713680709828d-03,
     |   2.5146598011435d-02, 3.6444941023428d-02, 1.6929934739999d-02,
     |  -1.6929934739999d-02,-3.6444941023428d-02,-2.5146598011435d-02,
     |   7.2713680709827d-03, 3.3391114283338d-02, 3.1424211150775d-02,
     |   3.3870800526000d-03,-2.7119616388869d-02,-3.5037131752516d-02,
     |  -1.4450840275665d-02, 1.7356695440532d-02, 3.4833999716463d-02,
     |   2.4827132646718d-02,-3.9234779652996d-03,-2.9007774509923d-02,
     |  -3.2242587568087d-02,-1.2571625325813d-02, 1.5034921831571d-02,
     |   3.1886030686170d-02, 2.8476960688850d-02, 8.8940286944642d-03,
     |  -1.4488701196376d-02,-3.0199947384091d-02,-3.3773495911070d-02,
     |  -2.7844687356252d-02,-1.8190336833857d-02,-9.5992248726636d-03,
     |  -4.0756543160749d-03,-1.3633290060893d-03,-3.4531465881842d-04,
     |  -6.1974127700644d-05,-7.0474496670841d-06,-4.1519932609461d-07,
     |  -8.3876901944484d-09,-2.6730803361520d-11, 7.5433094175630d-12/
      data (zmn(lat,12,24), lat = 1,72)/
     |  -1.1890310620088d-13, 1.4950334553116d-12, 8.3534338073851d-10,
     |   5.8604870229615d-08, 1.3010854339238d-06, 1.4301175392155d-05,
     |   9.6895910594621d-05, 4.5748782635744d-04, 1.6211464894200d-03,
     |   4.5169009151256d-03, 1.0182608012239d-02, 1.8852584134779d-02,
     |   2.8711432441847d-02, 3.5350824374453d-02, 3.3186265619341d-02,
     |   1.9030118697836d-02,-4.0641855897642d-03,-2.6033869652514d-02,
     |  -3.4371775294035d-02,-2.2434915169811d-02, 4.1178237305687d-03,
     |   2.8730548125868d-02, 3.4206407879857d-02, 1.5491738827491d-02,
     |  -1.4959569522178d-02,-3.4911111076675d-02,-2.8777409496595d-02,
     |  -4.0123059214039d-04, 2.8718789646619d-02, 3.5639325262027d-02,
     |   1.4378606964795d-02,-1.8563723796292d-02,-3.6871021071762d-02,
     |  -2.5596387987892d-02, 6.3929420004389d-03, 3.3296358703271d-02,
     |   3.3296358703271d-02, 6.3929420004390d-03,-2.5596387987892d-02,
     |  -3.6871021071762d-02,-1.8563723796292d-02, 1.4378606964795d-02,
     |   3.5639325262027d-02, 2.8718789646619d-02,-4.0123059214038d-04,
     |  -2.8777409496595d-02,-3.4911111076675d-02,-1.4959569522178d-02,
     |   1.5491738827491d-02, 3.4206407879857d-02, 2.8730548125868d-02,
     |   4.1178237305689d-03,-2.2434915169811d-02,-3.4371775294035d-02,
     |  -2.6033869652514d-02,-4.0641855897643d-03, 1.9030118697836d-02,
     |   3.3186265619341d-02, 3.5350824374453d-02, 2.8711432441847d-02,
     |   1.8852584134779d-02, 1.0182608012239d-02, 4.5169009151256d-03,
     |   1.6211464894202d-03, 4.5748782635746d-04, 9.6895910594575d-05,
     |   1.4301175392130d-05, 1.3010854338194d-06, 5.8604870163346d-08,
     |   8.3534332832930d-10, 1.4950203692377d-12,-1.1887980184297d-13/
      data (zmn(lat,13,24), lat = 1,72)/
     |   1.7912427707117d-13,-1.0196303210154d-13, 7.4841815822209d-11,
     |   7.4120157942460d-09, 2.1471287070728d-07, 2.9401392213842d-06,
     |   2.4115121383874d-05, 1.3534330793977d-04, 5.6382960683884d-04,
     |   1.8369781788880d-03, 4.8426857905668d-03, 1.0552580521211d-02,
     |   1.9216985166912d-02, 2.9254244729456d-02, 3.6675939507844d-02,
     |   3.6137868255639d-02, 2.3958042477397d-02, 1.7612704359985d-03,
     |  -2.2041181360948d-02,-3.5316425400491d-02,-2.9338290729769d-02,
     |  -5.7873714345652d-03, 2.2004613551395d-02, 3.6196511672243d-02,
     |   2.6415266890803d-02,-1.7895131350337d-03,-2.9258563613738d-02,
     |  -3.6149335834562d-02,-1.6739247613389d-02, 1.5309146283617d-02,
     |   3.6269784069984d-02, 3.0075919402389d-02, 1.0015473571809d-03,
     |  -2.9010176069727d-02,-3.6939722322141d-02,-1.6553969775926d-02,
     |   1.6553969775926d-02, 3.6939722322141d-02, 2.9010176069727d-02,
     |  -1.0015473571808d-03,-3.0075919402389d-02,-3.6269784069984d-02,
     |  -1.5309146283617d-02, 1.6739247613389d-02, 3.6149335834562d-02,
     |   2.9258563613738d-02, 1.7895131350339d-03,-2.6415266890803d-02,
     |  -3.6196511672243d-02,-2.2004613551395d-02, 5.7873714345652d-03,
     |   2.9338290729768d-02, 3.5316425400491d-02, 2.2041181360949d-02,
     |  -1.7612704359985d-03,-2.3958042477397d-02,-3.6137868255639d-02,
     |  -3.6675939507844d-02,-2.9254244729457d-02,-1.9216985166912d-02,
     |  -1.0552580521211d-02,-4.8426857905667d-03,-1.8369781788880d-03,
     |  -5.6382960683883d-04,-1.3534330793977d-04,-2.4115121383854d-05,
     |  -2.9401392214885d-06,-2.1471287072363d-07,-7.4120157840804d-09,
     |  -7.4841738086262d-11, 1.0199300473012d-13,-1.7906130165387d-13/
      data (zmn(lat,14,24), lat = 1,72)/
     |   2.0559494284356d-15,-3.0551151015882d-15, 6.0153762327329d-12,
     |   8.4235622432175d-10, 3.1777959173113d-08, 5.4071010293241d-07,
     |   5.3505631811710d-06, 3.5536970463050d-05, 1.7301719670009d-04,
     |   6.5390427568372d-04, 1.9935885628322d-03, 5.0308795833147d-03,
     |   1.0682120789976d-02, 1.9244061232447d-02, 2.9407287537243d-02,
     |   3.7647679908934d-02, 3.8930179792815d-02, 2.9171058383518d-02,
     |   8.5919280105143d-03,-1.6264599543605d-02,-3.4188038119276d-02,
     |  -3.5007038757353d-02,-1.6556351623898d-02, 1.1966122465873d-02,
     |   3.3847187974837d-02, 3.4858220961219d-02, 1.3286917296531d-02,
     |  -1.7463688339607d-02,-3.6824558591698d-02,-3.1056407052293d-02,
     |  -3.5324884366483d-03, 2.6740274960479d-02, 3.8196466279641d-02,
     |   2.2340077148688d-02,-9.6677559319956d-03,-3.4775620686101d-02,
     |  -3.4775620686101d-02,-9.6677559319957d-03, 2.2340077148688d-02,
     |   3.8196466279641d-02, 2.6740274960479d-02,-3.5324884366483d-03,
     |  -3.1056407052293d-02,-3.6824558591698d-02,-1.7463688339607d-02,
     |   1.3286917296531d-02, 3.4858220961219d-02, 3.3847187974838d-02,
     |   1.1966122465873d-02,-1.6556351623898d-02,-3.5007038757353d-02,
     |  -3.4188038119276d-02,-1.6264599543605d-02, 8.5919280105142d-03,
     |   2.9171058383518d-02, 3.8930179792815d-02, 3.7647679908934d-02,
     |   2.9407287537243d-02, 1.9244061232447d-02, 1.0682120789976d-02,
     |   5.0308795833148d-03, 1.9935885628322d-03, 6.5390427568375d-04,
     |   1.7301719670001d-04, 3.5536970463006d-05, 5.3505631812332d-06,
     |   5.4071010297244d-07, 3.1777959230098d-08, 8.4235623165979d-10,
     |   6.0153371434564d-12,-2.9822726950725d-15, 2.0345799503498d-15/
      data (zmn(lat,15,24), lat = 1,72)/
     |  -3.7659168344680d-15, 3.5679176108173d-15, 4.3176764187842d-13,
     |   8.6121040108606d-11, 4.2244504579626d-09, 8.9136532389984d-08,
     |   1.0613406119028d-06, 8.3135079424491d-06, 4.7094405339968d-05,
     |   2.0528159940932d-04, 7.1822415495876d-04, 2.0768395096933d-03,
     |   5.0641189942918d-03, 1.0548551249826d-02, 1.8894682150950d-02,
     |   2.9095220876931d-02, 3.8136463309255d-02, 4.1381559714208d-02,
     |   3.4480357762037d-02, 1.6338688053782d-02,-8.5304895804600d-03,
     |  -3.0401785108624d-02,-3.8465775506244d-02,-2.7178138550460d-02,
     |  -1.0190040673097d-03, 2.6225468480048d-02, 3.8579875026388d-02,
     |   2.7795630584798d-02,-3.9356899474523d-04,-2.8683590026886d-02,
     |  -3.8774779032873d-02,-2.3595430976510d-02, 7.2985732368331d-03,
     |   3.3502444628110d-02, 3.7344357922837d-02, 1.6062052581823d-02,
     |  -1.6062052581823d-02,-3.7344357922837d-02,-3.3502444628110d-02,
     |  -7.2985732368332d-03, 2.3595430976510d-02, 3.8774779032873d-02,
     |   2.8683590026886d-02, 3.9356899474552d-04,-2.7795630584798d-02,
     |  -3.8579875026388d-02,-2.6225468480049d-02, 1.0190040673095d-03,
     |   2.7178138550460d-02, 3.8465775506244d-02, 3.0401785108624d-02,
     |   8.5304895804604d-03,-1.6338688053782d-02,-3.4480357762037d-02,
     |  -4.1381559714208d-02,-3.8136463309255d-02,-2.9095220876931d-02,
     |  -1.8894682150950d-02,-1.0548551249826d-02,-5.0641189942919d-03,
     |  -2.0768395096933d-03,-7.1822415495878d-04,-2.0528159940926d-04,
     |  -4.7094405339943d-05,-8.3135079424515d-06,-1.0613406119128d-06,
     |  -8.9136532333247d-08,-4.2244504325885d-09,-8.6121030978296d-11,
     |  -4.3173345206621d-13,-3.5164461253319d-15, 3.7561134478936d-15/
      data (zmn(lat,16,24), lat = 1,72)/
     |  -1.1928621856244d-16, 4.1348888774494d-17, 2.8179817321012d-14,
     |   7.9162104047072d-12, 5.0430759893038d-10, 1.3173988133359d-08,
     |   1.8834970343760d-07, 1.7353106306801d-06, 1.1398746613227d-05,
     |   5.7056077772992d-05, 2.2780077342014d-04, 7.4921974859614d-04,
     |   2.0769476931650d-03, 4.9316204460935d-03, 1.0136441330686d-02,
     |   1.8134329473889d-02, 2.8238064841838d-02, 3.7986859990233d-02,
     |   4.3247091601263d-02, 3.9584308702024d-02, 2.4758863427786d-02,
     |   1.1905073514122d-03,-2.3406048081433d-02,-3.8531033776099d-02,
     |  -3.6113197593845d-02,-1.5832765907498d-02, 1.3011241323077d-02,
     |   3.5267517607991d-02, 3.8116977735810d-02, 1.9105415687208d-02,
     |  -1.1325317173756d-02,-3.5253114007266d-02,-3.7979957838376d-02,
     |  -1.7450910228751d-02, 1.3932638982440d-02, 3.6749763597922d-02,
     |   3.6749763597922d-02, 1.3932638982440d-02,-1.7450910228751d-02,
     |  -3.7979957838376d-02,-3.5253114007266d-02,-1.1325317173756d-02,
     |   1.9105415687208d-02, 3.8116977735810d-02, 3.5267517607991d-02,
     |   1.3011241323077d-02,-1.5832765907497d-02,-3.6113197593844d-02,
     |  -3.8531033776099d-02,-2.3406048081433d-02, 1.1905073514121d-03,
     |   2.4758863427786d-02, 3.9584308702024d-02, 4.3247091601263d-02,
     |   3.7986859990233d-02, 2.8238064841838d-02, 1.8134329473889d-02,
     |   1.0136441330686d-02, 4.9316204460934d-03, 2.0769476931651d-03,
     |   7.4921974859613d-04, 2.2780077342018d-04, 5.7056077772919d-05,
     |   1.1398746613188d-05, 1.7353106306672d-06, 1.8834970338294d-07,
     |   1.3173988073489d-08, 5.0430761726643d-10, 7.9161745128743d-12,
     |   2.8228305193640d-14, 2.0756023205936d-17,-6.7577344501526d-17/
      data (zmn(lat,17,24), lat = 1,72)/
     |   2.6432954888296d-17,-1.7134809234900d-16, 1.6058932900505d-15,
     |   6.5261213685146d-13, 5.3950366708481d-11, 1.7424928728159d-09,
     |   2.9862429235485d-08, 3.2291315854670d-07, 2.4529597025506d-06,
     |   1.4051811051804d-05, 6.3749442387224d-05, 2.3717674535355d-04,
     |   7.4218939376675d-04, 1.9898348987014d-03, 4.6313979741610d-03,
     |   9.4415640593838d-03, 1.6939667152399d-02, 2.6760377052678d-02,
     |   3.7026800997584d-02, 4.4220063727051d-02, 4.4047242995756d-02,
     |   3.3392650970835d-02, 1.2665131822203d-02,-1.2839301844037d-02,
     |  -3.3939024375114d-02,-4.1270727972802d-02,-3.0302355489487d-02,
     |  -4.8872470803512d-03, 2.3274244766307d-02, 3.9889629854891d-02,
     |   3.5725620490119d-02, 1.2329616602604d-02,-1.7975065298242d-02,
     |  -3.8475565568191d-02,-3.7510120962897d-02,-1.5410486128446d-02,
     |   1.5410486128446d-02, 3.7510120962897d-02, 3.8475565568191d-02,
     |   1.7975065298242d-02,-1.2329616602604d-02,-3.5725620490119d-02,
     |  -3.9889629854891d-02,-2.3274244766307d-02, 4.8872470803511d-03,
     |   3.0302355489487d-02, 4.1270727972802d-02, 3.3939024375114d-02,
     |   1.2839301844037d-02,-1.2665131822203d-02,-3.3392650970835d-02,
     |  -4.4047242995756d-02,-4.4220063727051d-02,-3.7026800997584d-02,
     |  -2.6760377052678d-02,-1.6939667152399d-02,-9.4415640593838d-03,
     |  -4.6313979741609d-03,-1.9898348987014d-03,-7.4218939376674d-04,
     |  -2.3717674535358d-04,-6.3749442387246d-05,-1.4051811051795d-05,
     |  -2.4529597025875d-06,-3.2291315853406d-07,-2.9862429173470d-08,
     |  -1.7424928203721d-09,-5.3950375515468d-11,-6.5261385371235d-13,
     |  -1.6183483758630d-15, 1.5600615081690d-16, 6.3278463086194d-18/
      data (zmn(lat,18,24), lat = 1,72)/
     |  -3.5459725057209d-17,-5.2714894667400d-17,-5.4922115521981d-18,
     |   4.7937904126387d-14, 5.1497690110999d-12, 2.0542298680037d-10,
     |   4.2140431219967d-09, 5.3388289290964d-08, 4.6798566569841d-07,
     |   3.0598943299263d-06, 1.5721599845405d-05, 6.5891352035905d-05,
     |   2.3153198421479d-04, 6.9615080535920d-04, 1.8184460211478d-03,
     |   4.1727323164051d-03, 8.4758468177785d-03, 1.5307757233143d-02,
     |   2.4606126853092d-02, 3.5086966468808d-02, 4.3948162435039d-02,
     |   4.7293357264430d-02, 4.1503043643848d-02, 2.5248990005580d-02,
     |   1.2231053997334d-03,-2.3634101159428d-02,-4.0181994902185d-02,
     |  -4.1019650309867d-02,-2.4594592601410d-02, 2.8750172780525d-03,
     |   2.9296967169174d-02, 4.2098942744190d-02, 3.4630009300910d-02,
     |   1.0076827252203d-02,-1.9591327679155d-02,-3.9483400885172d-02,
     |  -3.9483400885172d-02,-1.9591327679155d-02, 1.0076827252203d-02,
     |   3.4630009300910d-02, 4.2098942744190d-02, 2.9296967169174d-02,
     |   2.8750172780526d-03,-2.4594592601410d-02,-4.1019650309867d-02,
     |  -4.0181994902185d-02,-2.3634101159428d-02, 1.2231053997332d-03,
     |   2.5248990005580d-02, 4.1503043643848d-02, 4.7293357264430d-02,
     |   4.3948162435039d-02, 3.5086966468808d-02, 2.4606126853092d-02,
     |   1.5307757233143d-02, 8.4758468177785d-03, 4.1727323164051d-03,
     |   1.8184460211478d-03, 6.9615080535928d-04, 2.3153198421473d-04,
     |   6.5891352035914d-05, 1.5721599845390d-05, 3.0598943299636d-06,
     |   4.6798566567880d-07, 5.3388289280189d-08, 4.2140431111410d-09,
     |   2.0542302745951d-10, 5.1497969974792d-12, 4.7990373532400d-14,
     |   6.5962206768401d-17,-4.8628467109756d-17,-3.1583109248199d-18/
      data (zmn(lat,19,24), lat = 1,72)/
     |  -7.9837197464766d-17,-2.1108274338148d-16,-2.4722272243840d-16,
     |   2.9340718865437d-15, 4.3540863771204d-13, 2.1434448565084d-11,
     |   5.2571169630839d-10, 7.7920303683681d-09, 7.8676749403102d-08,
     |   5.8588020379890d-07, 3.4001061051169d-06, 1.6000910198561d-05,
     |   6.2880307585514d-05, 2.1095990561140d-04, 6.1446536126343d-04,
     |   1.5738081134871d-03, 3.5785390476254d-03, 7.2728968830056d-03,
     |   1.3267731808309d-02, 2.1760153980098d-02, 3.2034095891004d-02,
     |   4.2073755438315d-02, 4.8633540132586d-02, 4.8045241175508d-02,
     |   3.7733497429061d-02, 1.7934069713221d-02,-7.2791754193154d-03,
     |  -3.0534785189911d-02,-4.3556736151069d-02,-4.0703622933761d-02,
     |  -2.2069308568166d-02, 5.6065873362878d-03, 3.1134282228890d-02,
     |   4.3545720275370d-02, 3.7163711149225d-02, 1.4519623224899d-02,
     |  -1.4519623224899d-02,-3.7163711149225d-02,-4.3545720275370d-02,
     |  -3.1134282228890d-02,-5.6065873362879d-03, 2.2069308568166d-02,
     |   4.0703622933761d-02, 4.3556736151069d-02, 3.0534785189911d-02,
     |   7.2791754193155d-03,-1.7934069713221d-02,-3.7733497429061d-02,
     |  -4.8045241175508d-02,-4.8633540132586d-02,-4.2073755438315d-02,
     |  -3.2034095891004d-02,-2.1760153980098d-02,-1.3267731808309d-02,
     |  -7.2728968830057d-03,-3.5785390476253d-03,-1.5738081134871d-03,
     |  -6.1446536126346d-04,-2.1095990561143d-04,-6.2880307585570d-05,
     |  -1.6000910198585d-05,-3.4001061051200d-06,-5.8588020386530d-07,
     |  -7.8676749449648d-08,-7.7920303624222d-09,-5.2571174679243d-10,
     |  -2.1434456668644d-11,-4.3536506881349d-13,-2.8792298862322d-15,
     |   3.1797372671221d-16, 1.8833194896656d-16, 1.0953303439408d-16/
      data (zmn(lat,20,24), lat = 1,72)/
     |  -3.7768944705773d-18,-3.2055637278198d-17,-8.2780222360810d-17,
     |   5.5008629554874d-17, 3.2115136858157d-14, 1.9573653015357d-12,
     |   5.7344779453978d-11, 9.9317493523542d-10, 1.1534231985843d-08,
     |   9.7647957931741d-08, 6.3870816024068d-07, 3.3662040135723d-06,
     |   1.4747459313801d-05, 5.4992266972563d-05, 1.7774486194505d-04,
     |   5.0505098975733d-04, 1.2754733194107d-03, 2.8869888298463d-03,
     |   5.8930800814253d-03, 1.0893673957475d-02, 1.8275605017635d-02,
     |   2.7820644670512d-02, 3.8308462750035d-02, 4.7350051042775d-02,
     |   5.1711374190895d-02, 4.8252204035603d-02, 3.5308364664138d-02,
     |   1.3999669847605d-02,-1.1245794701857d-02,-3.3508578189572d-02,
     |  -4.5561842838630d-02,-4.2732864188969d-02,-2.5224742051236d-02,
     |   1.3056152231273d-03, 2.7456464082232d-02, 4.3569253199468d-02,
     |   4.3569253199468d-02, 2.7456464082232d-02, 1.3056152231274d-03,
     |  -2.5224742051235d-02,-4.2732864188969d-02,-4.5561842838630d-02,
     |  -3.3508578189572d-02,-1.1245794701857d-02, 1.3999669847605d-02,
     |   3.5308364664138d-02, 4.8252204035603d-02, 5.1711374190895d-02,
     |   4.7350051042775d-02, 3.8308462750035d-02, 2.7820644670512d-02,
     |   1.8275605017636d-02, 1.0893673957475d-02, 5.8930800814253d-03,
     |   2.8869888298463d-03, 1.2754733194107d-03, 5.0505098975735d-04,
     |   1.7774486194505d-04, 5.4992266972526d-05, 1.4747459313830d-05,
     |   3.3662040135708d-06, 6.3870816016367d-07, 9.7647957890482d-08,
     |   1.1534232013601d-08, 9.9317492289419d-10, 5.7344791407045d-11,
     |   1.9573703618661d-12, 3.2051179048024d-14, 1.2040111264523d-16,
     |  -1.3302583829641d-16, 1.6826014241908d-17, 9.5907666643003d-19/
      data (zmn(lat,21,24), lat = 1,72)/
     |  -3.8306418409625d-17,-1.0544565348408d-16,-1.5448283638592d-16,
     |  -1.5621386673749d-16, 1.9176568186708d-15, 1.5360120580230d-13,
     |   5.3734445737373d-12, 1.0863445453963d-10, 1.4492970186430d-09,
     |   1.3928233772466d-08, 1.0249818876202d-07, 6.0368885836737d-07,
     |   2.9409323306204d-06, 1.2151440392613d-05, 4.3420117551339d-05,
     |   1.3624160575040d-04, 3.7995500507466d-04, 9.5085222789958d-04,
     |   2.1513665280812d-03, 4.4262655693022d-03, 8.3156776276806d-03,
     |   1.4303603836890d-02, 2.2548799051233d-02, 3.2548396494700d-02,
     |   4.2866544251698d-02, 5.1117177876153d-02, 5.4366989885465d-02,
     |   4.9988865609547d-02, 3.6772397665839d-02, 1.5880398163943d-02,
     |  -8.8410948813538d-03,-3.1540703035416d-02,-4.5995500822556d-02,
     |  -4.7715296911626d-02,-3.5720682638554d-02,-1.3217653928066d-02,
     |   1.3217653928066d-02, 3.5720682638554d-02, 4.7715296911626d-02,
     |   4.5995500822556d-02, 3.1540703035416d-02, 8.8410948813537d-03,
     |  -1.5880398163943d-02,-3.6772397665839d-02,-4.9988865609547d-02,
     |  -5.4366989885465d-02,-5.1117177876153d-02,-4.2866544251698d-02,
     |  -3.2548396494700d-02,-2.2548799051233d-02,-1.4303603836890d-02,
     |  -8.3156776276807d-03,-4.4262655693022d-03,-2.1513665280813d-03,
     |  -9.5085222789955d-04,-3.7995500507471d-04,-1.3624160575042d-04,
     |  -4.3420117551316d-05,-1.2151440392609d-05,-2.9409323305798d-06,
     |  -6.0368885836893d-07,-1.0249818873971d-07,-1.3928233743473d-08,
     |  -1.4492969681948d-09,-1.0863443183543d-10,-5.3733756391990d-12,
     |  -1.5356937878375d-13,-1.8796445029168d-15, 1.4787404580410d-16,
     |   1.3604104093984d-16, 1.2708261993560d-16,-2.1644207667602d-19/
      data (zmn(lat,22,24), lat = 1,72)/
     |  -1.5341492585528d-17,-2.9265605015785d-17,-5.8675913120046d-17,
     |  -9.0171841291500d-17, 7.9970360511407d-18, 9.9542710889787d-15,
     |   4.1971605675119d-13, 9.8984653712794d-12, 1.5154072386329d-10,
     |   1.6511455320217d-09, 1.3650152064981d-08, 8.9686038906317d-08,
     |   4.8481981590616d-07, 2.2140992503114d-06, 8.7202980174637d-06,
     |   3.0107060315335d-05, 9.2315953893352d-05, 2.5405364434973d-04,
     |   6.3285997232920d-04, 1.4368118429504d-03, 2.9893216963883d-03,
     |   5.7235089702112d-03, 1.0116019707403d-02, 1.6537205714402d-02,
     |   2.5022647870844d-02, 3.5018416874552d-02, 4.5202964454773d-02,
     |   5.3513237262122d-02, 5.7472171161862d-02, 5.4818429648585d-02,
     |   4.4300528513332d-02, 2.6373666184272d-02, 3.4979212903277d-03,
     |  -2.0174355190483d-02,-3.9728135863236d-02,-5.0790740272488d-02,
     |  -5.0790740272488d-02,-3.9728135863236d-02,-2.0174355190483d-02,
     |   3.4979212903276d-03, 2.6373666184272d-02, 4.4300528513332d-02,
     |   5.4818429648585d-02, 5.7472171161862d-02, 5.3513237262122d-02,
     |   4.5202964454773d-02, 3.5018416874552d-02, 2.5022647870844d-02,
     |   1.6537205714402d-02, 1.0116019707403d-02, 5.7235089702112d-03,
     |   2.9893216963883d-03, 1.4368118429504d-03, 6.3285997232918d-04,
     |   2.5405364434972d-04, 9.2315953893322d-05, 3.0107060315371d-05,
     |   8.7202980174699d-06, 2.2140992503281d-06, 4.8481981590392d-07,
     |   8.9686038913767d-08, 1.3650152122588d-08, 1.6511455199319d-09,
     |   1.5154065229130d-10, 9.8984578842652d-12, 4.1967896952766d-13,
     |   9.9497206996874d-15, 1.6161963692609d-17,-1.0584551231922d-16,
     |  -2.0763890572925d-17,-3.6220753772234d-17,-1.2039921278405d-17/
      data (zmn(lat,23,24), lat = 1,72)/
     |  -2.6442046265971d-17,-7.7135866315091d-17,-1.3296141224242d-16,
     |  -1.6692073698230d-16,-1.9080500568974d-16, 3.1881905121415d-16,
     |   2.5641217501015d-14, 7.0980657941424d-13, 1.2461643905712d-11,
     |   1.5377511749509d-10, 1.4263322382555d-09, 1.0438848214107d-08,
     |   6.2507647422524d-08, 3.1487015087675d-07, 1.3635892712037d-06,
     |   5.1652322642385d-06, 1.7353747680973d-05, 5.2301621417230d-05,
     |   1.4272365601275d-04, 3.5536177823675d-04, 8.1245218607901d-04,
     |   1.7145644010772d-03, 3.3543007119580d-03, 6.1043550246480d-03,
     |   1.0361605453054d-02, 1.6435975842942d-02, 2.4391340010384d-02,
     |   3.3872990382689d-02, 4.3982459002894d-02, 5.3271321856221d-02,
     |   5.9908168611687d-02, 6.2024051980096d-02, 5.8173559151336d-02,
     |   4.7786980715998d-02, 3.1463561455813d-02, 1.0985557223563d-02,
     |  -1.0985557223563d-02,-3.1463561455813d-02,-4.7786980715998d-02,
     |  -5.8173559151336d-02,-6.2024051980096d-02,-5.9908168611687d-02,
     |  -5.3271321856221d-02,-4.3982459002894d-02,-3.3872990382689d-02,
     |  -2.4391340010384d-02,-1.6435975842942d-02,-1.0361605453054d-02,
     |  -6.1043550246480d-03,-3.3543007119580d-03,-1.7145644010773d-03,
     |  -8.1245218607902d-04,-3.5536177823675d-04,-1.4272365601274d-04,
     |  -5.2301621417222d-05,-1.7353747680960d-05,-5.1652322642097d-06,
     |  -1.3635892712116d-06,-3.1487015087273d-07,-6.2507647443485d-08,
     |  -1.0438848215090d-08,-1.4263322744576d-09,-1.5377511877506d-10,
     |  -1.2461639992777d-11,-7.0979663215366d-13,-2.5634330758283d-14,
     |  -2.9234881513558d-16, 1.9332719150693d-16, 2.1767518976449d-16,
     |   1.6222043446962d-16, 9.8325376547095d-17, 2.7880792022874d-17/
      data (zmn(lat,24,24), lat = 1,72)/
     |  -2.0035390069498d-17,-3.3891572446168d-17,-5.2185182474206d-17,
     |  -5.5649328572791d-17,-6.0341852661362d-17,-6.3269457487748d-17,
     |   9.9486878932409d-16, 3.4696963224975d-14, 6.9938046029578d-13,
     |   9.7661849430879d-12, 1.0152540837798d-10, 8.2661370447320d-10,
     |   5.4748063550124d-09, 3.0367109776013d-08, 1.4431231103266d-07,
     |   5.9835675031616d-07, 2.1966486482720d-06, 7.2266803707961d-06,
     |   2.1519443232788d-05, 5.8487378790223d-05, 1.4611211741646d-04,
     |   3.3751475135074d-04, 7.2458408166959d-04, 1.4519876811340d-03,
     |   2.7260621780477d-03, 4.8106068597677d-03, 8.0011418660529d-03,
     |   1.2572415584749d-02, 1.8701551005700d-02, 2.6379945774689d-02,
     |   3.5337369558008d-02, 4.5006757974218d-02, 5.4553781153082d-02,
     |   6.2980226129652d-02, 6.9287976618603d-02, 7.2668330173401d-02,
     |   7.2668330173401d-02, 6.9287976618603d-02, 6.2980226129652d-02,
     |   5.4553781153082d-02, 4.5006757974218d-02, 3.5337369558008d-02,
     |   2.6379945774689d-02, 1.8701551005700d-02, 1.2572415584749d-02,
     |   8.0011418660529d-03, 4.8106068597677d-03, 2.7260621780477d-03,
     |   1.4519876811340d-03, 7.2458408166959d-04, 3.3751475135074d-04,
     |   1.4611211741647d-04, 5.8487378790223d-05, 2.1519443232791d-05,
     |   7.2266803707766d-06, 2.1966486482761d-06, 5.9835675029446d-07,
     |   1.4431231103745d-07, 3.0367109789560d-08, 5.4748063612834d-09,
     |   8.2661370754611d-10, 1.0152539624727d-10, 9.7661894207783d-12,
     |   6.9941446519442d-13, 3.4693664418801d-14, 9.9879250407105d-16,
     |  -6.6088257561020d-17,-5.2634042005529d-17,-6.4200913292676d-17,
     |  -4.7051563326136d-17,-3.3398472322125d-17,-3.0289431844083d-17/
      data (zmn(lat, 0,25), lat = 1,72)/
     |   3.7771835533348d-03, 6.3933091560790d-03,-4.5344185542913d-03,
     |  -1.3295535203282d-02,-7.7191858993319d-03, 9.7313744626082d-03,
     |   1.8080258564255d-02, 6.0956889006655d-03,-1.5195938736450d-02,
     |  -2.0669379126000d-02,-2.5703990052875d-03, 2.0449478182406d-02,
     |   2.1328951669746d-02,-2.2944581959352d-03,-2.5040596763129d-02,
     |  -2.0159737932088d-02, 8.0032761141966d-03, 2.8581440930089d-02,
     |   1.7298757754956d-02,-1.4069342592212d-02,-3.0769616268700d-02,
     |  -1.2962144268390d-02, 2.0016162217036d-02, 3.1405000071176d-02,
     |   7.4488405452726d-03,-2.5395920803656d-02,-3.0400763083152d-02,
     |  -1.1280646876248d-03, 2.9812944228711d-02, 2.7787517929875d-02,
     |  -5.5821299578267d-03,-3.2946803740368d-02,-2.3710034865345d-02,
     |   1.2241477270353d-02, 3.4571966936873d-02, 1.8416575790650d-02,
     |  -1.8416575790650d-02,-3.4571966936873d-02,-1.2241477270353d-02,
     |   2.3710034865345d-02, 3.2946803740368d-02, 5.5821299578267d-03,
     |  -2.7787517929875d-02,-2.9812944228711d-02, 1.1280646876246d-03,
     |   3.0400763083152d-02, 2.5395920803656d-02,-7.4488405452724d-03,
     |  -3.1405000071176d-02,-2.0016162217036d-02, 1.2962144268390d-02,
     |   3.0769616268700d-02, 1.4069342592212d-02,-1.7298757754956d-02,
     |  -2.8581440930089d-02,-8.0032761141967d-03, 2.0159737932088d-02,
     |   2.5040596763129d-02, 2.2944581959351d-03,-2.1328951669746d-02,
     |  -2.0449478182406d-02, 2.5703990052874d-03, 2.0669379126000d-02,
     |   1.5195938736450d-02,-6.0956889006651d-03,-1.8080258564254d-02,
     |  -9.7313744626083d-03, 7.7191858993319d-03, 1.3295535203282d-02,
     |   4.5344185542912d-03,-6.3933091560789d-03,-3.7771835533349d-03/
      data (zmn(lat, 1,25), lat = 1,72)/
     |   1.4895480515960d-03, 8.2279836101630d-03, 1.0021728618280d-02,
     |  -8.4879677738826d-04,-1.4142293283357d-02,-1.3259389816181d-02,
     |   3.9257274881971d-03, 1.9165157296574d-02, 1.3775494788494d-02,
     |  -8.4845489845451d-03,-2.3130283516465d-02,-1.2214693483727d-02,
     |   1.3768827589200d-02, 2.5784831431651d-02, 8.9351947339311d-03,
     |  -1.9208287208379d-02,-2.6927620708140d-02,-4.2805253755489d-03,
     |   2.4305726549286d-02, 2.6449846097707d-02,-1.3682922360456d-03,
     |  -2.8627794101191d-02,-2.4350299891966d-02, 7.5913874526418d-03,
     |   3.1817259993510d-02, 2.0737997860494d-02,-1.3946669699821d-02,
     |  -3.3609023404227d-02,-1.5825552463350d-02, 1.9994036727988d-02,
     |   3.3843668536704d-02, 9.9148412742505d-03,-2.5322242466317d-02,
     |  -3.2475727367149d-02,-3.3763374568150d-03, 2.9575257185207d-02,
     |   2.9575257185207d-02,-3.3763374568150d-03,-3.2475727367149d-02,
     |  -2.5322242466317d-02, 9.9148412742503d-03, 3.3843668536704d-02,
     |   1.9994036727988d-02,-1.5825552463350d-02,-3.3609023404227d-02,
     |  -1.3946669699821d-02, 2.0737997860494d-02, 3.1817259993510d-02,
     |   7.5913874526419d-03,-2.4350299891967d-02,-2.8627794101191d-02,
     |  -1.3682922360462d-03, 2.6449846097707d-02, 2.4305726549286d-02,
     |  -4.2805253755488d-03,-2.6927620708140d-02,-1.9208287208379d-02,
     |   8.9351947339312d-03, 2.5784831431651d-02, 1.3768827589200d-02,
     |  -1.2214693483727d-02,-2.3130283516465d-02,-8.4845489845453d-03,
     |   1.3775494788493d-02, 1.9165157296574d-02, 3.9257274881971d-03,
     |  -1.3259389816181d-02,-1.4142293283357d-02,-8.4879677738810d-04,
     |   1.0021728618280d-02, 8.2279836101631d-03, 1.4895480515960d-03/
      data (zmn(lat, 2,25), lat = 1,72)/
     |   2.0774779414857d-04, 3.9176160887998d-03, 1.1455885099152d-02,
     |   1.3079601424430d-02, 1.9916050074101d-03,-1.3877703727010d-02,
     |  -1.7156957604143d-02,-1.5761149701911d-03, 1.7919895245123d-02,
     |   1.9260617266560d-02,-1.1784331537812d-03,-2.2168016264090d-02,
     |  -1.9636842219510d-02, 5.3837897847822d-03, 2.5985997309757d-02,
     |   1.8358308321647d-02,-1.0473450243644d-02,-2.8933525486814d-02,
     |  -1.5538804983435d-02, 1.5953307165659d-02, 3.0692387520379d-02,
     |   1.1370072901932d-02,-2.1361360604170d-02,-3.1056475068390d-02,
     |  -6.1230441136903d-03, 2.6271966336513d-02, 2.9932783676033d-02,
     |   1.3506973429897d-04,-3.0312607031050d-02,-2.7341306859878d-02,
     |   6.2105655843609d-03, 3.3183088714088d-02, 2.3410085569432d-02,
     |  -1.2509669057591d-02,-3.4672672825189d-02,-1.8364320931758d-02,
     |   1.8364320931758d-02, 3.4672672825189d-02, 1.2509669057591d-02,
     |  -2.3410085569432d-02,-3.3183088714088d-02,-6.2105655843609d-03,
     |   2.7341306859878d-02, 3.0312607031050d-02,-1.3506973429874d-04,
     |  -2.9932783676033d-02,-2.6271966336513d-02, 6.1230441136901d-03,
     |   3.1056475068390d-02, 2.1361360604169d-02,-1.1370072901932d-02,
     |  -3.0692387520379d-02,-1.5953307165659d-02, 1.5538804983435d-02,
     |   2.8933525486814d-02, 1.0473450243644d-02,-1.8358308321647d-02,
     |  -2.5985997309757d-02,-5.3837897847822d-03, 1.9636842219510d-02,
     |   2.2168016264090d-02, 1.1784331537813d-03,-1.9260617266559d-02,
     |  -1.7919895245124d-02, 1.5761149701907d-03, 1.7156957604143d-02,
     |   1.3877703727010d-02,-1.9916050074101d-03,-1.3079601424430d-02,
     |  -1.1455885099152d-02,-3.9176160887999d-03,-2.0774779414854d-04/
      data (zmn(lat, 3,25), lat = 1,72)/
     |   6.5446043805966d-06, 1.1677753604514d-03, 6.4349293082664d-03,
     |   1.4246079880958d-02, 1.5764332530948d-02, 4.3612053201373d-03,
     |  -1.3215986013265d-02,-1.9956437001238d-02,-6.5548368528014d-03,
     |   1.5410462091902d-02, 2.2825347667409d-02, 5.8835397778056d-03,
     |  -1.8912253368261d-02,-2.4594758726791d-02,-3.3767067293843d-03,
     |   2.2873291966574d-02, 2.5128687153688d-02,-4.7022739016326d-04,
     |  -2.6725748530380d-02,-2.4326622026793d-02, 5.2552784026386d-03,
     |   3.0030639419450d-02, 2.2176032627254d-02,-1.0585398623578d-02,
     |  -3.2445405180777d-02,-1.8760165956722d-02, 1.6065914747156d-02,
     |   3.3721516897958d-02, 1.4252733267149d-02,-2.1312165900117d-02,
     |  -3.3709069640151d-02,-8.9051962809075d-03, 2.5968698308418d-02,
     |   3.2360480309622d-02, 3.0285999984344d-03,-2.9730124516462d-02,
     |  -2.9730124516462d-02, 3.0285999984343d-03, 3.2360480309622d-02,
     |   2.5968698308418d-02,-8.9051962809073d-03,-3.3709069640151d-02,
     |  -2.1312165900117d-02, 1.4252733267149d-02, 3.3721516897958d-02,
     |   1.6065914747156d-02,-1.8760165956722d-02,-3.2445405180777d-02,
     |  -1.0585398623578d-02, 2.2176032627254d-02, 3.0030639419450d-02,
     |   5.2552784026391d-03,-2.4326622026793d-02,-2.6725748530380d-02,
     |  -4.7022739016337d-04, 2.5128687153688d-02, 2.2873291966574d-02,
     |  -3.3767067293844d-03,-2.4594758726791d-02,-1.8912253368262d-02,
     |   5.8835397778056d-03, 2.2825347667409d-02, 1.5410462091902d-02,
     |  -6.5548368528012d-03,-1.9956437001238d-02,-1.3215986013265d-02,
     |   4.3612053201374d-03, 1.5764332530948d-02, 1.4246079880958d-02,
     |   6.4349293082662d-03, 1.1677753604514d-03, 6.5446043806130d-06/
      data (zmn(lat, 4,25), lat = 1,72)/
     |   4.8100871923211d-07, 2.5023639260678d-04, 2.4752694430598d-03,
     |   8.8257577449558d-03, 1.6840333285792d-02, 1.8163807562109d-02,
     |   6.4775585651723d-03,-1.2390908873347d-02,-2.1999607045070d-02,
     |  -1.1039016271391d-02, 1.2185463736342d-02, 2.4813222887145d-02,
     |   1.2331419137849d-02,-1.4158075388380d-02,-2.7196753856526d-02,
     |  -1.1679395285054d-02, 1.7333630703153d-02, 2.8948223949380d-02,
     |   9.5385047252409d-03,-2.1099847199033d-02,-2.9830605031676d-02,
     |  -6.1966112665833d-03, 2.4984985148836d-02, 2.9672822953957d-02,
     |   1.9269109158550d-03,-2.8596188674280d-02,-2.8390689003247d-02,
     |   2.9760973763881d-03, 3.1607252810137d-02, 2.5990839461700d-02,
     |  -8.1959832046026d-03,-3.3762596750272d-02,-2.2567413661810d-02,
     |   1.3407188267556d-02, 3.4885498214188d-02, 1.8293364339735d-02,
     |  -1.8293364339735d-02,-3.4885498214188d-02,-1.3407188267556d-02,
     |   2.2567413661810d-02, 3.3762596750272d-02, 8.1959832046026d-03,
     |  -2.5990839461700d-02,-3.1607252810137d-02,-2.9760973763883d-03,
     |   2.8390689003247d-02, 2.8596188674280d-02,-1.9269109158549d-03,
     |  -2.9672822953957d-02,-2.4984985148836d-02, 6.1966112665833d-03,
     |   2.9830605031675d-02, 2.1099847199033d-02,-9.5385047252409d-03,
     |  -2.8948223949380d-02,-1.7333630703153d-02, 1.1679395285054d-02,
     |   2.7196753856526d-02, 1.4158075388380d-02,-1.2331419137848d-02,
     |  -2.4813222887145d-02,-1.2185463736342d-02, 1.1039016271390d-02,
     |   2.1999607045070d-02, 1.2390908873347d-02,-6.4775585651723d-03,
     |  -1.8163807562109d-02,-1.6840333285792d-02,-8.8257577449557d-03,
     |  -2.4752694430599d-03,-2.5023639260686d-04,-4.8100871922984d-07/
      data (zmn(lat, 5,25), lat = 1,72)/
     |   4.4010671636343d-07, 4.1694100946281d-05, 7.2807302646454d-04,
     |   3.9401920577337d-03, 1.1120033891942d-02, 1.9270138109011d-02,
     |   2.0382874729775d-02, 8.4484085189659d-03,-1.1434702606284d-02,
     |  -2.3504259628119d-02,-1.5094156861947d-02, 8.4948053454315d-03,
     |   2.5508991759443d-02, 1.7996885340671d-02,-8.4240685738026d-03,
     |  -2.7656257232603d-02,-1.8988010089962d-02, 1.0111434376935d-02,
     |   2.9805244518500d-02, 1.8582831367180d-02,-1.2919386755818d-02,
     |  -3.1668861458949d-02,-1.6995411505089d-02, 1.6391376804998d-02,
     |   3.2987697472135d-02, 1.4384179957690d-02,-2.0149208738231d-02,
     |  -3.3566069806107d-02,-1.0923243577861d-02, 2.3861619784504d-02,
     |   3.3283197922288d-02, 6.8210484554670d-03,-2.7240145570843d-02,
     |  -3.2097299481521d-02,-2.3189926073602d-03, 3.0045515898627d-02,
     |   3.0045515898627d-02,-2.3189926073602d-03,-3.2097299481521d-02,
     |  -2.7240145570843d-02, 6.8210484554668d-03, 3.3283197922288d-02,
     |   2.3861619784504d-02,-1.0923243577861d-02,-3.3566069806107d-02,
     |  -2.0149208738231d-02, 1.4384179957690d-02, 3.2987697472135d-02,
     |   1.6391376804998d-02,-1.6995411505089d-02,-3.1668861458949d-02,
     |  -1.2919386755818d-02, 1.8582831367180d-02, 2.9805244518500d-02,
     |   1.0111434376935d-02,-1.8988010089962d-02,-2.7656257232603d-02,
     |  -8.4240685738025d-03, 1.7996885340671d-02, 2.5508991759443d-02,
     |   8.4948053454317d-03,-1.5094156861947d-02,-2.3504259628119d-02,
     |  -1.1434702606284d-02, 8.4484085189658d-03, 2.0382874729775d-02,
     |   1.9270138109011d-02, 1.1120033891942d-02, 3.9401920577338d-03,
     |   7.2807302646472d-04, 4.1694100946294d-05, 4.4010671638224d-07/
      data (zmn(lat, 6,25), lat = 1,72)/
     |   1.9376989756392d-08, 5.7628739840818d-06, 1.7322239919641d-04,
     |   1.3855834973852d-03, 5.4752126198471d-03, 1.3317977033526d-02,
     |   2.1554574503138d-02, 2.2486296605798d-02, 1.0366809721366d-02,
     |  -1.0324885658485d-02,-2.4576152569403d-02,-1.8793666339689d-02,
     |   4.4518855585793d-03, 2.5089146981164d-02, 2.2800839596780d-02,
     |  -2.0655883970769d-03,-2.6168632478553d-02,-2.4938484898932d-02,
     |   1.8435033837619d-03, 2.7814461528298d-02, 2.5905747557752d-02,
     |  -3.0790157755587d-03,-2.9746537947627d-02,-2.5916345653635d-02,
     |   5.3256220320429d-03, 3.1674880553762d-02, 2.5057932608545d-02,
     |  -8.2420877834430d-03,-3.3350450563972d-02,-2.3406225546298d-02,
     |   1.1532493206970d-02, 3.4578855914798d-02, 2.1064700742652d-02,
     |  -1.4926460291399d-02,-3.5226916167940d-02,-1.8176842120791d-02,
     |   1.8176842120791d-02, 3.5226916167940d-02, 1.4926460291399d-02,
     |  -2.1064700742652d-02,-3.4578855914798d-02,-1.1532493206970d-02,
     |   2.3406225546298d-02, 3.3350450563972d-02, 8.2420877834431d-03,
     |  -2.5057932608545d-02,-3.1674880553762d-02,-5.3256220320432d-03,
     |   2.5916345653635d-02, 2.9746537947627d-02, 3.0790157755587d-03,
     |  -2.5905747557752d-02,-2.7814461528298d-02,-1.8435033837620d-03,
     |   2.4938484898932d-02, 2.6168632478553d-02, 2.0655883970771d-03,
     |  -2.2800839596780d-02,-2.5089146981164d-02,-4.4518855585795d-03,
     |   1.8793666339689d-02, 2.4576152569403d-02, 1.0324885658485d-02,
     |  -1.0366809721366d-02,-2.2486296605798d-02,-2.1554574503138d-02,
     |  -1.3317977033526d-02,-5.4752126198474d-03,-1.3855834973853d-03,
     |  -1.7322239919635d-04,-5.7628739839839d-06,-1.9376989757287d-08/
      data (zmn(lat, 7,25), lat = 1,72)/
     |  -1.2253818118566d-08, 6.8615012508827d-07, 3.4525466478491d-05,
     |   4.0220268217142d-04, 2.1665652481715d-03, 7.0278533312237d-03,
     |   1.5405975803630d-02, 2.3706480799605d-02, 2.4520590365691d-02,
     |   1.2315456646623d-02,-9.0107759958653d-03,-2.5249557788063d-02,
     |  -2.2189092431328d-02, 9.9924838417009d-05, 2.3640311702061d-02,
     |   2.6675334170107d-02, 4.6526061319560d-03,-2.2888860951090d-02,
     |  -2.9239087298374d-02,-6.8942981587543d-03, 2.3164767259827d-02,
     |   3.0881149345935d-02, 7.4893704063700d-03,-2.4205832294462d-02,
     |  -3.1889738710284d-02,-6.9235827963926d-03, 2.5712918616274d-02,
     |   3.2335852436487d-02, 5.5210090466224d-03,-2.7416111733991d-02,
     |  -3.2236687334375d-02,-3.5406768473694d-03, 2.9085496403468d-02,
     |   3.1616944945621d-02, 1.2181093533941d-03,-3.0533589791534d-02,
     |  -3.0533589791534d-02, 1.2181093533940d-03, 3.1616944945621d-02,
     |   2.9085496403468d-02,-3.5406768473691d-03,-3.2236687334375d-02,
     |  -2.7416111733991d-02, 5.5210090466220d-03, 3.2335852436487d-02,
     |   2.5712918616274d-02,-6.9235827963925d-03,-3.1889738710284d-02,
     |  -2.4205832294463d-02, 7.4893704063700d-03, 3.0881149345935d-02,
     |   2.3164767259828d-02,-6.8942981587542d-03,-2.9239087298374d-02,
     |  -2.2888860951090d-02, 4.6526061319558d-03, 2.6675334170107d-02,
     |   2.3640311702061d-02, 9.9924838416939d-05,-2.2189092431328d-02,
     |  -2.5249557788063d-02,-9.0107759958653d-03, 1.2315456646623d-02,
     |   2.4520590365691d-02, 2.3706480799605d-02, 1.5405975803629d-02,
     |   7.0278533312240d-03, 2.1665652481715d-03, 4.0220268217136d-04,
     |   3.4525466478393d-05, 6.8615012508094d-07,-1.2253818143353d-08/
      data (zmn(lat, 8,25), lat = 1,72)/
     |  -3.9491852591354d-10, 6.9065829243832d-08, 5.9046122247740d-06,
     |   9.9199562182305d-05, 7.1737099758769d-04, 3.0237697066100d-03,
     |   8.5545502665752d-03, 1.7366512107674d-02, 2.5732012881445d-02,
     |   2.6523470876979d-02, 1.4368144803666d-02,-7.4235144238925d-03,
     |  -2.5508808066676d-02,-2.5297197405027d-02,-4.5476772665667d-03,
     |   2.1181877683638d-02, 2.9522728508347d-02, 1.1496092633496d-02,
     |  -1.7943495358929d-02,-3.1613406569886d-02,-1.5529677975763d-02,
     |   1.6121826945489d-02, 3.2969622628233d-02, 1.7782522577391d-02,
     |  -1.5437785441880d-02,-3.4007273020333d-02,-1.8852459479293d-02,
     |   1.5561904295811d-02, 3.4817739157531d-02, 1.9090157540358d-02,
     |  -1.6198832181069d-02,-3.5388545226419d-02,-1.8739955564369d-02,
     |   1.7090350902580d-02, 3.5685499727123d-02, 1.8007083118770d-02,
     |  -1.8007083118770d-02,-3.5685499727123d-02,-1.7090350902580d-02,
     |   1.8739955564369d-02, 3.5388545226419d-02, 1.6198832181069d-02,
     |  -1.9090157540358d-02,-3.4817739157531d-02,-1.5561904295811d-02,
     |   1.8852459479293d-02, 3.4007273020333d-02, 1.5437785441880d-02,
     |  -1.7782522577391d-02,-3.2969622628233d-02,-1.6121826945489d-02,
     |   1.5529677975763d-02, 3.1613406569886d-02, 1.7943495358929d-02,
     |  -1.1496092633496d-02,-2.9522728508347d-02,-2.1181877683638d-02,
     |   4.5476772665668d-03, 2.5297197405027d-02, 2.5508808066676d-02,
     |   7.4235144238925d-03,-1.4368144803666d-02,-2.6523470876979d-02,
     |  -2.5732012881445d-02,-1.7366512107673d-02,-8.5545502665750d-03,
     |  -3.0237697066099d-03,-7.1737099758755d-04,-9.9199562182260d-05,
     |  -5.9046122247830d-06,-6.9065829298367d-08, 3.9491853112075d-10/
      data (zmn(lat, 9,25), lat = 1,72)/
     |   3.7725032068018d-10, 5.6953262156055d-09, 8.8078147682326d-07,
     |   2.1197745412028d-05, 2.0380077331567d-04, 1.0993588257694d-03,
     |   3.9145889174193d-03, 1.0015312268583d-02, 1.9179128760150d-02,
     |   2.7631779662492d-02, 2.8524817235910d-02, 1.6591414224316d-02,
     |  -5.4821704917956d-03,-2.5297547135936d-02,-2.8092952597440d-02,
     |  -9.4777746201064d-03, 1.7687388750154d-02, 3.1195619402149d-02,
     |   1.8209407400136d-02,-1.1461734506449d-02,-3.1778066107341d-02,
     |  -2.3438623553604d-02, 7.0686454397057d-03, 3.1719917046362d-02,
     |   2.6691577283021d-02,-4.1422373749459d-03,-3.1586988426647d-02,
     |  -2.8752876044019d-02, 2.2688065494591d-03, 3.1496075442023d-02,
     |   3.0041847275954d-02,-1.0953385553591d-03,-3.1404889449481d-02,
     |  -3.0805924654717d-02, 3.2174681609266d-04, 3.1214805569542d-02,
     |   3.1214805569542d-02, 3.2174681609279d-04,-3.0805924654717d-02,
     |  -3.1404889449481d-02,-1.0953385553592d-03, 3.0041847275954d-02,
     |   3.1496075442023d-02, 2.2688065494594d-03,-2.8752876044019d-02,
     |  -3.1586988426647d-02,-4.1422373749460d-03, 2.6691577283021d-02,
     |   3.1719917046362d-02, 7.0686454397056d-03,-2.3438623553604d-02,
     |  -3.1778066107341d-02,-1.1461734506449d-02, 1.8209407400136d-02,
     |   3.1195619402149d-02, 1.7687388750154d-02,-9.4777746201064d-03,
     |  -2.8092952597441d-02,-2.5297547135936d-02,-5.4821704917959d-03,
     |   1.6591414224316d-02, 2.8524817235910d-02, 2.7631779662492d-02,
     |   1.9179128760150d-02, 1.0015312268583d-02, 3.9145889174192d-03,
     |   1.0993588257693d-03, 2.0380077331568d-04, 2.1197745412131d-05,
     |   8.8078147684820d-07, 5.6953262117362d-09, 3.7725029877548d-10/
      data (zmn(lat,10,25), lat = 1,72)/
     |   9.4697892886939d-12, 4.4487210704063d-10, 1.1585905715479d-07,
     |   3.9789047846919d-06, 5.0521539671996d-05, 3.4534827962277d-04,
     |   1.5246949774860d-03, 4.7986002265114d-03, 1.1371689678742d-02,
     |   2.0820225540288d-02, 2.9400097382243d-02, 3.0545235068295d-02,
     |   1.9043660246245d-02,-3.0975875380765d-03,-2.4522893929003d-02,
     |  -3.0502039226518d-02,-1.4652427342638d-02, 1.3107828766918d-02,
     |   3.1488831289524d-02, 2.4471769612118d-02,-3.6224971606982d-03,
     |  -2.9451148446228d-02,-2.9902714272821d-02,-3.4251863525328d-03,
     |   2.6822345324921d-02, 3.2995719854696d-02, 8.5812281915649d-03,
     |  -2.4315021222082d-02,-3.4787073979412d-02,-1.2411667851984d-02,
     |   2.2048714242415d-02, 3.5787066505449d-02, 1.5362070334534d-02,
     |  -1.9929085940149d-02,-3.6238440320228d-02,-1.7776115163752d-02,
     |   1.7776115163752d-02, 3.6238440320228d-02, 1.9929085940149d-02,
     |  -1.5362070334534d-02,-3.5787066505449d-02,-2.2048714242415d-02,
     |   1.2411667851984d-02, 3.4787073979412d-02, 2.4315021222082d-02,
     |  -8.5812281915648d-03,-3.2995719854695d-02,-2.6822345324922d-02,
     |   3.4251863525327d-03, 2.9902714272821d-02, 2.9451148446228d-02,
     |   3.6224971606985d-03,-2.4471769612118d-02,-3.1488831289524d-02,
     |  -1.3107828766918d-02, 1.4652427342638d-02, 3.0502039226518d-02,
     |   2.4522893929003d-02, 3.0975875380764d-03,-1.9043660246245d-02,
     |  -3.0545235068295d-02,-2.9400097382243d-02,-2.0820225540288d-02,
     |  -1.1371689678742d-02,-4.7986002265116d-03,-1.5246949774860d-03,
     |  -3.4534827962286d-04,-5.0521539672153d-05,-3.9789047847137d-06,
     |  -1.1585905717789d-07,-4.4487214135004d-10,-9.4697923412307d-12/
      data (zmn(lat,11,25), lat = 1,72)/
     |  -1.0650217310013d-11, 4.1859256258649d-11, 1.3552689073073d-08,
     |   6.6258041421174d-07, 1.1058318174107d-05, 9.5140289611241d-05,
     |   5.1569842158740d-04, 1.9674265985969d-03, 5.6366541660939d-03,
     |   1.2585646089771d-02, 2.2262322233042d-02, 3.1022928380143d-02,
     |   3.2592938507260d-02, 2.1771841681607d-02,-1.7641653538487d-04,
     |  -2.3057590374322d-02,-3.2391818271853d-02,-1.9983335853696d-02,
     |   7.4002700258629d-03, 3.0142889847846d-02, 2.9858940288930d-02,
     |   5.2831606047899d-03,-2.4394707675508d-02,-3.4090830894031d-02,
     |  -1.4516507555260d-02, 1.8222687603197d-02, 3.5416332253316d-02,
     |   2.1142415652464d-02,-1.2473681769294d-02,-3.5187628976447d-02,
     |  -2.5949596919432d-02, 7.2420590060233d-03, 3.4016167512189d-02,
     |   2.9492743849463d-02,-2.3718914559774d-03,-3.2121432763980d-02,
     |  -3.2121432763980d-02,-2.3718914559775d-03, 2.9492743849463d-02,
     |   3.4016167512189d-02, 7.2420590060235d-03,-2.5949596919432d-02,
     |  -3.5187628976447d-02,-1.2473681769295d-02, 2.1142415652464d-02,
     |   3.5416332253316d-02, 1.8222687603197d-02,-1.4516507555260d-02,
     |  -3.4090830894031d-02,-2.4394707675508d-02, 5.2831606047898d-03,
     |   2.9858940288930d-02, 3.0142889847846d-02, 7.4002700258631d-03,
     |  -1.9983335853696d-02,-3.2391818271853d-02,-2.3057590374322d-02,
     |  -1.7641653538471d-04, 2.1771841681607d-02, 3.2592938507260d-02,
     |   3.1022928380142d-02, 2.2262322233042d-02, 1.2585646089771d-02,
     |   5.6366541660940d-03, 1.9674265985969d-03, 5.1569842158745d-04,
     |   9.5140289611348d-05, 1.1058318174113d-05, 6.6258041419793d-07,
     |   1.3552689123422d-08, 4.1859256243327d-11,-1.0650218199312d-11/
      data (zmn(lat,12,25), lat = 1,72)/
     |  -2.1495343267396d-13, 2.5936471493904d-12, 1.4211788834418d-09,
     |   9.8588104739008d-08, 2.1552636320178d-06, 2.3223952399006d-05,
     |   1.5349453244297d-04, 7.0297097834124d-04, 2.4002041894521d-03,
     |   6.3906587585935d-03, 1.3618904334602d-02, 2.3472901902023d-02,
     |   3.2474995179614d-02, 3.4659043585172d-02, 2.4805663912775d-02,
     |   3.3727185941241d-03,-2.0742695616403d-02,-3.3561442054124d-02,
     |  -2.5302781874349d-02, 5.6630008741454d-04, 2.6863134599174d-02,
     |   3.3814540356792d-02, 1.4775109987131d-02,-1.6499225384654d-02,
     |  -3.5084234541519d-02,-2.5002607095090d-02, 6.3018899412892d-03,
     |   3.2773422334241d-02, 3.1425189938463d-02, 2.7585446257266d-03,
     |  -2.8649959001194d-02,-3.5146664888204d-02,-1.0624051246599d-02,
     |   2.3470068495619d-02, 3.6849707364645d-02, 1.7472175563107d-02,
     |  -1.7472175563107d-02,-3.6849707364645d-02,-2.3470068495619d-02,
     |   1.0624051246599d-02, 3.5146664888204d-02, 2.8649959001194d-02,
     |  -2.7585446257266d-03,-3.1425189938463d-02,-3.2773422334241d-02,
     |  -6.3018899412893d-03, 2.5002607095090d-02, 3.5084234541519d-02,
     |   1.6499225384654d-02,-1.4775109987131d-02,-3.3814540356793d-02,
     |  -2.6863134599174d-02,-5.6630008741464d-04, 2.5302781874349d-02,
     |   3.3561442054124d-02, 2.0742695616403d-02,-3.3727185941240d-03,
     |  -2.4805663912775d-02,-3.4659043585172d-02,-3.2474995179614d-02,
     |  -2.3472901902023d-02,-1.3618904334602d-02,-6.3906587585935d-03,
     |  -2.4002041894521d-03,-7.0297097834111d-04,-1.5349453244296d-04,
     |  -2.3223952398961d-05,-2.1552636319035d-06,-9.8588104672471d-08,
     |  -1.4211788129705d-09,-2.5935586609445d-12, 2.1497083160928d-13/
      data (zmn(lat,13,25), lat = 1,72)/
     |   2.7409490571946d-13,-1.3370383275669d-13, 1.3437489439018d-10,
     |   1.3174540241524d-08, 3.7625842224361d-07, 5.0592221945195d-06,
     |   4.0568704835656d-05, 2.2151372864238d-04, 8.9276467620362d-04,
     |   2.7952981055754d-03, 7.0238064052431d-03, 1.4432617504805d-02,
     |   2.4413114154421d-02, 3.3716357020401d-02, 3.6711368238295d-02,
     |   2.8148763173988d-02, 7.6290896117805d-03,-1.7393810387328d-02,
     |  -3.3733240677771d-02,-3.0330153615211d-02,-7.2949901243195d-03,
     |   2.1362695226231d-02, 3.5640604490939d-02, 2.4098085255792d-02,
     |  -5.9191095810210d-03,-3.1974079644558d-02,-3.3272239375494d-02,
     |  -7.8878361327410d-03, 2.4291884854431d-02, 3.6900466178148d-02,
     |   1.9002352149260d-02,-1.4964967012478d-02,-3.6598376474820d-02,
     |  -2.7425134339951d-02, 5.0368466077677d-03, 3.3304128605612d-02,
     |   3.3304128605612d-02, 5.0368466077678d-03,-2.7425134339951d-02,
     |  -3.6598376474820d-02,-1.4964967012478d-02, 1.9002352149260d-02,
     |   3.6900466178148d-02, 2.4291884854431d-02,-7.8878361327409d-03,
     |  -3.3272239375494d-02,-3.1974079644558d-02,-5.9191095810213d-03,
     |   2.4098085255792d-02, 3.5640604490939d-02, 2.1362695226231d-02,
     |  -7.2949901243191d-03,-3.0330153615211d-02,-3.3733240677771d-02,
     |  -1.7393810387328d-02, 7.6290896117804d-03, 2.8148763173988d-02,
     |   3.6711368238295d-02, 3.3716357020402d-02, 2.4413114154421d-02,
     |   1.4432617504805d-02, 7.0238064052431d-03, 2.7952981055754d-03,
     |   8.9276467620366d-04, 2.2151372864243d-04, 4.0568704835663d-05,
     |   5.0592221944821d-06, 3.7625842231561d-07, 1.3174540212149d-08,
     |   1.3437487073743d-10,-1.3366622707267d-13, 2.7411386876296d-13/
      data (zmn(lat,14,25), lat = 1,72)/
     |   4.3503214753014d-15,-6.5492749521035d-15, 1.1441964079209d-11,
     |   1.5865722169028d-09, 5.9070217329170d-08, 9.8831821211896d-07,
     |   9.5788142457077d-06, 6.2043569899544d-05, 2.9316137682403d-04,
     |   1.0693354867976d-03, 3.1257057812951d-03, 7.5011907660826d-03,
     |   1.4987440057898d-02, 2.5036703415966d-02, 3.4688836587443d-02,
     |   3.8686918759826d-02, 3.1766362619079d-02, 1.2643708367866d-02,
     |  -1.2814681090700d-02,-3.2549634184077d-02,-3.4635899420871d-02,
     |  -1.5915621588950d-02, 1.3441232754603d-02, 3.4526094103704d-02,
     |   3.2142813838805d-02, 6.7371142623563d-03,-2.4069829762848d-02,
     |  -3.7358060664007d-02,-2.2375874384745d-02, 1.0092373144543d-02,
     |   3.5023454119883d-02, 3.2532196921260d-02, 4.1451168591051d-03,
     |  -2.7723009812067d-02,-3.7462705620406d-02,-1.7077570843181d-02,
     |   1.7077570843181d-02, 3.7462705620406d-02, 2.7723009812067d-02,
     |  -4.1451168591051d-03,-3.2532196921260d-02,-3.5023454119883d-02,
     |  -1.0092373144543d-02, 2.2375874384744d-02, 3.7358060664007d-02,
     |   2.4069829762848d-02,-6.7371142623561d-03,-3.2142813838805d-02,
     |  -3.4526094103705d-02,-1.3441232754603d-02, 1.5915621588950d-02,
     |   3.4635899420871d-02, 3.2549634184077d-02, 1.2814681090700d-02,
     |  -1.2643708367865d-02,-3.1766362619079d-02,-3.8686918759826d-02,
     |  -3.4688836587443d-02,-2.5036703415966d-02,-1.4987440057898d-02,
     |  -7.5011907660825d-03,-3.1257057812951d-03,-1.0693354867976d-03,
     |  -2.9316137682410d-04,-6.2043569899600d-05,-9.5788142456442d-06,
     |  -9.8831821203758d-07,-5.9070217334543d-08,-1.5865722032817d-09,
     |  -1.1442017297740d-11, 6.4791624232782d-15,-4.3777680128800d-15/
      data (zmn(lat,15,25), lat = 1,72)/
     |  -6.3334091806018d-15, 5.9303751586694d-15, 8.7414112700593d-13,
     |   1.7251013351084d-10, 8.3587586668120d-09, 1.7363214261808d-07,
     |   2.0280419969986d-06, 1.5522863170527d-05, 8.5559801376375d-05,
     |   3.6114537815861d-04, 1.2168259250119d-03, 3.3664367714130d-03,
     |   7.7908677974892d-03, 1.5244234700057d-02, 2.5289669298222d-02,
     |   3.5312936041984d-02, 4.0483554217826d-02, 3.5569101778520d-02,
     |   1.8414923726301d-02,-6.8232558093171d-03,-2.9582901830831d-02,
     |  -3.7609361488682d-02,-2.4768675157546d-02, 3.1133060097471d-03,
     |   2.9643445630630d-02, 3.7410614029531d-02, 2.0177232077018d-02,
     |  -1.1257397465316d-02,-3.5191838044142d-02,-3.4129798784167d-02,
     |  -8.1577571966586d-03, 2.4071655804314d-02, 3.8596536701055d-02,
     |   2.4231479128964d-02,-8.4722704835051d-03,-3.4844872414425d-02,
     |  -3.4844872414425d-02,-8.4722704835051d-03, 2.4231479128964d-02,
     |   3.8596536701055d-02, 2.4071655804315d-02,-8.1577571966586d-03,
     |  -3.4129798784167d-02,-3.5191838044142d-02,-1.1257397465316d-02,
     |   2.0177232077018d-02, 3.7410614029531d-02, 2.9643445630630d-02,
     |   3.1133060097472d-03,-2.4768675157546d-02,-3.7609361488682d-02,
     |  -2.9582901830831d-02,-6.8232558093171d-03, 1.8414923726301d-02,
     |   3.5569101778520d-02, 4.0483554217826d-02, 3.5312936041984d-02,
     |   2.5289669298222d-02, 1.5244234700057d-02, 7.7908677974893d-03,
     |   3.3664367714132d-03, 1.2168259250118d-03, 3.6114537815859d-04,
     |   8.5559801376360d-05, 1.5522863170512d-05, 2.0280419969291d-06,
     |   1.7363214261496d-07, 8.3587586180865d-09, 1.7251012164484d-10,
     |   8.7415951120102d-13, 5.9318405859310d-15,-6.3204375569757d-15/
      data (zmn(lat,16,25), lat = 1,72)/
     |  -7.8316353147621d-18, 2.4610591659605d-16, 6.0747902165359d-14,
     |   1.6941292568985d-11, 1.0669045111042d-09, 2.7465870370567d-08,
     |   3.8570862406522d-07, 3.4782654133714d-06, 2.2277994547222d-05,
     |   1.0827436446302d-04, 4.1776067186837d-04, 1.3205852786624d-03,
     |   3.4960387022828d-03, 7.8654865240024d-03, 1.5165774701731d-02,
     |   2.5111372451623d-02, 3.5486286822382d-02, 4.1951957166760d-02,
     |   3.9393454098549d-02, 2.4853837062463d-02, 7.0351481057165d-04,
     |  -2.4369306497956d-02,-3.8444543013379d-02,-3.2967917245623d-02,
     |  -9.2029144965298d-03, 2.0354504063664d-02, 3.8088771740119d-02,
     |   3.2214623891824d-02, 5.4808977908137d-03,-2.5193884485726d-02,
     |  -3.9239725605712d-02,-2.6607292866525d-02, 4.5074324353329d-03,
     |   3.2651185499729d-02, 3.7986365798941d-02, 1.6564848271531d-02,
     |  -1.6564848271531d-02,-3.7986365798941d-02,-3.2651185499729d-02,
     |  -4.5074324353329d-03, 2.6607292866525d-02, 3.9239725605712d-02,
     |   2.5193884485726d-02,-5.4808977908135d-03,-3.2214623891823d-02,
     |  -3.8088771740119d-02,-2.0354504063664d-02, 9.2029144965295d-03,
     |   3.2967917245623d-02, 3.8444543013379d-02, 2.4369306497956d-02,
     |  -7.0351481057125d-04,-2.4853837062463d-02,-3.9393454098549d-02,
     |  -4.1951957166760d-02,-3.5486286822382d-02,-2.5111372451623d-02,
     |  -1.5165774701731d-02,-7.8654865240024d-03,-3.4960387022828d-03,
     |  -1.3205852786624d-03,-4.1776067186841d-04,-1.0827436446310d-04,
     |  -2.2277994547146d-05,-3.4782654133601d-06,-3.8570862412843d-07,
     |  -2.7465870465865d-08,-1.0669045159913d-09,-1.6941350905852d-11,
     |  -6.0756476686435d-14,-2.1314516486506d-16, 6.4878622347400d-17/
      data (zmn(lat,17,25), lat = 1,72)/
     |   7.3500695536661d-17,-2.4207580393519d-16, 3.8113750139741d-15,
     |   1.5009157422674d-12, 1.2273132816452d-10, 3.9098930444547d-09,
     |   6.5891760651765d-08, 6.9839961167712d-07, 5.1822593873753d-06,
     |   2.8889403949236d-05, 1.2701571839995d-04, 4.5582969581416d-04,
     |   1.3685854195263d-03, 3.4984073114898d-03, 7.7046463497113d-03,
     |   1.4719893282892d-02, 2.4438043039126d-02, 3.5085256001437d-02,
     |   4.2890113870279d-02, 4.2980671639882d-02, 3.1738978972805d-02,
     |   9.7594531289617d-03,-1.6483860104377d-02,-3.6169383505089d-02,
     |  -3.9182690105705d-02,-2.2440841321112d-02, 6.5704902600892d-03,
     |   3.2343399286428d-02, 3.9713406074173d-02, 2.3458667762212d-02,
     |  -7.3077448798533d-03,-3.3780835617693d-02,-3.9055205370026d-02,
     |  -1.9350755820121d-02, 1.2921499178754d-02, 3.6884733066114d-02,
     |   3.6884733066114d-02, 1.2921499178754d-02,-1.9350755820120d-02,
     |  -3.9055205370026d-02,-3.3780835617693d-02,-7.3077448798532d-03,
     |   2.3458667762212d-02, 3.9713406074173d-02, 3.2343399286428d-02,
     |   6.5704902600893d-03,-2.2440841321112d-02,-3.9182690105705d-02,
     |  -3.6169383505089d-02,-1.6483860104377d-02, 9.7594531289616d-03,
     |   3.1738978972804d-02, 4.2980671639882d-02, 4.2890113870279d-02,
     |   3.5085256001437d-02, 2.4438043039126d-02, 1.4719893282892d-02,
     |   7.7046463497113d-03, 3.4984073114897d-03, 1.3685854195263d-03,
     |   4.5582969581404d-04, 1.2701571839988d-04, 2.8889403949217d-05,
     |   5.1822593873661d-06, 6.9839961167448d-07, 6.5891760666828d-08,
     |   3.9098930042112d-09, 1.2273125751940d-10, 1.5009594247231d-12,
     |   3.8384310434457d-15,-2.4486836954557d-16, 9.0293642726038d-17/
      data (zmn(lat,18,25), lat = 1,72)/
     |   2.2471123437493d-17,-4.2022882045342d-17, 1.1781176800872d-16,
     |   1.1951479756785d-13, 1.2691218220038d-11, 4.9972573676920d-10,
     |   1.0090801545035d-08, 1.2546528213776d-07, 1.0759365947198d-06,
     |   6.8589927252860d-06, 3.4232902770635d-05, 1.3880200228435d-04,
     |   4.6968958667974d-04, 1.3528972844558d-03, 3.3648807017607d-03,
     |   7.2981088751503d-03, 1.3884555437430d-02, 2.3209870818080d-02,
     |   3.3972050873410d-02, 4.3044117656012d-02, 4.5958959605512d-02,
     |   3.8663170744540d-02, 2.0108967996797d-02,-5.6755911833386d-03,
     |  -2.9759210463007d-02,-4.1623511342853d-02,-3.4626908199885d-02,
     |  -1.0712292573417d-02, 1.8967205310392d-02, 3.8943954496168d-02,
     |   3.7855173332394d-02, 1.5573447081173d-02,-1.5744356855121d-02,
     |  -3.8111670389710d-02,-3.8266836594917d-02,-1.5888798752093d-02,
     |   1.5888798752093d-02, 3.8266836594916d-02, 3.8111670389710d-02,
     |   1.5744356855121d-02,-1.5573447081172d-02,-3.7855173332394d-02,
     |  -3.8943954496168d-02,-1.8967205310392d-02, 1.0712292573417d-02,
     |   3.4626908199885d-02, 4.1623511342853d-02, 2.9759210463007d-02,
     |   5.6755911833387d-03,-2.0108967996797d-02,-3.8663170744540d-02,
     |  -4.5958959605512d-02,-4.3044117656012d-02,-3.3972050873410d-02,
     |  -2.3209870818080d-02,-1.3884555437430d-02,-7.2981088751502d-03,
     |  -3.3648807017606d-03,-1.3528972844558d-03,-4.6968958667980d-04,
     |  -1.3880200228448d-04,-3.4232902770627d-05,-6.8589927252430d-06,
     |  -1.0759365947401d-06,-1.2546528213179d-07,-1.0090801470956d-08,
     |  -4.9972567302142d-10,-1.2691251071894d-11,-1.1949339410726d-13,
     |  -3.8628791217113d-17, 5.9863271801718d-17,-4.4316032677344d-17/
      data (zmn(lat,19,25), lat = 1,72)/
     |  -7.5532362595789d-17,-1.7716530045219d-16,-1.9406957512169d-16,
     |   8.3804970515587d-15, 1.1741229802789d-12, 5.7087041025229d-11,
     |   1.3794288535601d-09, 2.0087475782568d-08, 1.9869004079542d-07,
     |   1.4449210313143d-06, 8.1617380156181d-06, 3.7248795284739d-05,
     |   1.4139107447515d-04, 4.5614714481828d-04, 1.2711364660839d-03,
     |   3.0965275508345d-03, 6.6498654200929d-03, 1.2655205040806d-02,
     |   2.1382923769198d-02, 3.2010369628188d-02, 4.2121217506496d-02,
     |   4.7837998055912d-02, 4.4982509756664d-02, 3.1160065478828d-02,
     |   7.9190070485184d-03,-1.8389612533986d-02,-3.8197750086048d-02,
     |  -4.2726604781429d-02,-2.8762965951970d-02,-1.5072925712023d-03,
     |   2.6724333388970d-02, 4.2054883390406d-02, 3.6303724039880d-02,
     |   1.1888504743455d-02,-1.8800713502171d-02,-3.9691950210242d-02,
     |  -3.9691950210242d-02,-1.8800713502171d-02, 1.1888504743455d-02,
     |   3.6303724039880d-02, 4.2054883390406d-02, 2.6724333388970d-02,
     |  -1.5072925712022d-03,-2.8762965951970d-02,-4.2726604781429d-02,
     |  -3.8197750086048d-02,-1.8389612533986d-02, 7.9190070485183d-03,
     |   3.1160065478828d-02, 4.4982509756664d-02, 4.7837998055912d-02,
     |   4.2121217506496d-02, 3.2010369628188d-02, 2.1382923769198d-02,
     |   1.2655205040806d-02, 6.6498654200929d-03, 3.0965275508345d-03,
     |   1.2711364660840d-03, 4.5614714481835d-04, 1.4139107447518d-04,
     |   3.7248795284722d-05, 8.1617380156439d-06, 1.4449210313689d-06,
     |   1.9869004080266d-07, 2.0087475795336d-08, 1.3794288911335d-09,
     |   5.7087131511422d-11, 1.1742286373658d-12, 8.3498468334258d-15,
     |  -1.7456377706498d-16,-1.5323059209939d-16,-7.9086459563431d-17/
      data (zmn(lat,20,25), lat = 1,72)/
     |   1.0022553369831d-16, 5.0466643366727d-17,-4.8800567158967d-17,
     |   4.2636433548175d-16, 9.6315787345235d-14, 5.7859847253271d-12,
     |   1.6712663227877d-10, 2.8465419312075d-09, 3.2422248407697d-08,
     |   2.6843359970399d-07, 1.7118738919371d-06, 8.7676446487265d-06,
     |   3.7195341406470d-05, 1.3378439621192d-04, 4.1528423858342d-04,
     |   1.1277033555590d-03, 2.7063783438148d-03, 5.7827821605526d-03,
     |   1.1054342849983d-02, 1.8946803428800d-02, 2.9092945433010d-02,
     |   3.9823228718231d-02, 4.8031034014365d-02, 4.9789508825487d-02,
     |   4.1831618584649d-02, 2.3483728422132d-02,-1.8854980596437d-03,
     |  -2.6983722679194d-02,-4.2837632643671d-02,-4.2610282364309d-02,
     |  -2.5308329587122d-02, 2.7122062748256d-03, 2.9737932216454d-02,
     |   4.3716367339917d-02, 3.8021331614938d-02, 1.4967200001340d-02,
     |  -1.4967200001340d-02,-3.8021331614938d-02,-4.3716367339917d-02,
     |  -2.9737932216454d-02,-2.7122062748257d-03, 2.5308329587122d-02,
     |   4.2610282364309d-02, 4.2837632643671d-02, 2.6983722679194d-02,
     |   1.8854980596437d-03,-2.3483728422132d-02,-4.1831618584649d-02,
     |  -4.9789508825487d-02,-4.8031034014365d-02,-3.9823228718231d-02,
     |  -2.9092945433010d-02,-1.8946803428800d-02,-1.1054342849983d-02,
     |  -5.7827821605526d-03,-2.7063783438148d-03,-1.1277033555590d-03,
     |  -4.1528423858346d-04,-1.3378439621187d-04,-3.7195341406467d-05,
     |  -8.7676446486428d-06,-1.7118738919634d-06,-2.6843359965069d-07,
     |  -3.2422248396629d-08,-2.8465418817269d-09,-1.6712667991087d-10,
     |  -5.7860344675436d-12,-9.6341554482613d-14,-4.8842405693816d-16,
     |  -4.0954096988402d-17,-1.1028153007893d-16,-8.9021182751819d-17/
      data (zmn(lat,21,25), lat = 1,72)/
     |  -5.0111559057287d-17,-1.2076768676982d-16,-1.5929353269035d-16,
     |  -1.3924454657410d-16, 6.8136659010752d-15, 5.1432947629940d-13,
     |   1.7744046252563d-11, 3.5308350452048d-10, 4.6246579431280d-09,
     |   4.3518793386156d-08, 3.1270680928687d-07, 1.7929922139556d-06,
     |   8.4762433802982d-06, 3.3868254466895d-05, 1.1658809392963d-04,
     |   3.5095068916914d-04, 9.3453222496865d-04, 2.2211022883614d-03,
     |   4.7430526038796d-03, 9.1424408643007d-03, 1.5947780248370d-02,
     |   2.5183418806535d-02, 3.5909489799317d-02, 4.5926410625887d-02,
     |   5.1950075880131d-02, 5.0469502249386d-02, 3.9198027538469d-02,
     |   1.8616547585987d-02,-7.1894175399440d-03,-3.1124291018140d-02,
     |  -4.5289017737293d-02,-4.4142396818116d-02,-2.7261877022338d-02,
     |  -2.5315141241003d-04, 2.6942895137889d-02, 4.3866519896495d-02,
     |   4.3866519896495d-02, 2.6942895137889d-02,-2.5315141240992d-04,
     |  -2.7261877022338d-02,-4.4142396818116d-02,-4.5289017737293d-02,
     |  -3.1124291018140d-02,-7.1894175399441d-03, 1.8616547585987d-02,
     |   3.9198027538469d-02, 5.0469502249386d-02, 5.1950075880131d-02,
     |   4.5926410625887d-02, 3.5909489799317d-02, 2.5183418806535d-02,
     |   1.5947780248370d-02, 9.1424408643007d-03, 4.7430526038796d-03,
     |   2.2211022883614d-03, 9.3453222496865d-04, 3.5095068916914d-04,
     |   1.1658809392969d-04, 3.3868254466928d-05, 8.4762433802875d-06,
     |   1.7929922139736d-06, 3.1270680925237d-07, 4.3518793324689d-08,
     |   4.6246579471978d-09, 3.5308351335635d-10, 1.7744002612116d-11,
     |   5.1423468802014d-13, 6.7928405984903d-15,-1.5365374505499d-16,
     |  -1.6047997199020d-16,-2.0290709420641d-16,-6.6908733197708d-17/
      data (zmn(lat,22,25), lat = 1,72)/
     |   4.7907458216717d-17, 2.8900216637018d-17, 1.5576915730609d-17,
     |  -1.2957036047221d-17, 3.9437710805625d-16, 3.9338471100953d-14,
     |   1.6214556747379d-12, 3.7659795067133d-11, 5.6656538622784d-10,
     |   6.0512174835021d-09, 4.8910544550654d-08, 3.1333271838230d-07,
     |   1.6466861396336d-06, 7.2882184155089d-06, 2.7725927258849d-05,
     |   9.2121230088696d-05, 2.7073931733582d-04, 7.1093886077647d-04,
     |   1.6813101929488d-03, 3.6029475629111d-03, 7.0278047884413d-03,
     |   1.2514573922549d-02, 2.0371458801918d-02, 3.0295836124344d-02,
     |   4.1033657984754d-02, 5.0263719579524d-02, 5.4917577085004d-02,
     |   5.2022074715287d-02, 3.9906092436846d-02, 1.9341477552912d-02,
     |  -5.9535210380791d-03,-2.9895929129738d-02,-4.5745467411579d-02,
     |  -4.8438552424814d-02,-3.6645148120597d-02,-1.3622889504768d-02,
     |   1.3622889504767d-02, 3.6645148120597d-02, 4.8438552424814d-02,
     |   4.5745467411579d-02, 2.9895929129738d-02, 5.9535210380791d-03,
     |  -1.9341477552912d-02,-3.9906092436846d-02,-5.2022074715287d-02,
     |  -5.4917577085004d-02,-5.0263719579524d-02,-4.1033657984754d-02,
     |  -3.0295836124344d-02,-2.0371458801918d-02,-1.2514573922549d-02,
     |  -7.0278047884414d-03,-3.6029475629111d-03,-1.6813101929488d-03,
     |  -7.1093886077651d-04,-2.7073931733584d-04,-9.2121230088734d-05,
     |  -2.7725927258806d-05,-7.2882184155146d-06,-1.6466861396608d-06,
     |  -3.1333271841215d-07,-4.8910544489413d-08,-6.0512175365315d-09,
     |  -5.6656537849449d-10,-3.7659785871302d-11,-1.6214386707027d-12,
     |  -3.9349792796398d-14,-3.3798464441310d-16, 4.6376920823735d-17,
     |  -5.7506439301413d-17, 2.3923319905141d-17,-7.8657989698667d-17/
      data (zmn(lat,23,25), lat = 1,72)/
     |  -1.1824297538839d-17,-2.7903113026271d-17,-5.9996889492905d-17,
     |  -9.7129269648072d-17,-1.0061189957093d-16, 2.3862114330367d-15,
     |   1.2362544358341d-13, 3.3519671083747d-12, 5.7865685271932d-11,
     |   7.0063618148122d-10, 6.3611883356288d-09, 4.5454586160077d-08,
     |   2.6503467954570d-07, 1.2963197366359d-06, 5.4344925545195d-06,
     |   1.9863019627251d-05, 6.4164728479742d-05, 1.8522186301305d-04,
     |   4.8206093359990d-04, 1.1393313085509d-03, 2.4594232626088d-03,
     |   4.8707690673390d-03, 8.8793266904226d-03, 1.4931935692835d-02,
     |   2.3184767949849d-02, 3.3219939942535d-02, 4.3814455274249d-02,
     |   5.2906250943113d-02, 5.7884435023691d-02, 5.6233829025170d-02,
     |   4.6405980257305d-02, 2.8633047496368d-02, 5.3330322971426d-03,
     |  -1.9161989188941d-02,-3.9591980145103d-02,-5.1212210678916d-02,
     |  -5.1212210678916d-02,-3.9591980145103d-02,-1.9161989188941d-02,
     |   5.3330322971426d-03, 2.8633047496368d-02, 4.6405980257305d-02,
     |   5.6233829025170d-02, 5.7884435023691d-02, 5.2906250943113d-02,
     |   4.3814455274249d-02, 3.3219939942535d-02, 2.3184767949849d-02,
     |   1.4931935692835d-02, 8.8793266904226d-03, 4.8707690673390d-03,
     |   2.4594232626089d-03, 1.1393313085509d-03, 4.8206093359991d-04,
     |   1.8522186301303d-04, 6.4164728479804d-05, 1.9863019627259d-05,
     |   5.4344925544982d-06, 1.2963197366135d-06, 2.6503467952822d-07,
     |   4.5454586141073d-08, 6.3611883694529d-09, 7.0063613148643d-10,
     |   5.7865648675581d-11, 3.3519722055150d-12, 1.2367195137641d-13,
     |   2.4457550603085d-15,-1.0405326089824d-16,-1.2416730534941d-16,
     |  -1.2458576950618d-16, 3.7579224237985d-17, 2.6748878328002d-17/
      data (zmn(lat,24,25), lat = 1,72)/
     |   1.4874065455366d-17,-1.1790748138487d-17,-2.3793236317039d-17,
     |  -6.0636589374824d-17,-8.8507836595329d-17, 8.0108063471860d-18,
     |   7.3244676391078d-15, 2.3511282577191d-13, 4.6555161051604d-12,
     |   6.3838411769708d-11, 6.5026588006727d-10, 5.1754960874652d-09,
     |   3.3425291531203d-08, 1.8031627629931d-07, 8.3111861645275d-07,
     |   3.3325414699647d-06, 1.1794268273056d-05, 3.7280352157795d-05,
     |   1.0627142468416d-04, 2.7539782134577d-04, 6.5311936450890d-04,
     |   1.4252557842902d-03, 2.8748344826664d-03, 5.3792979614766d-03,
     |   9.3638787409236d-03, 1.5194653065727d-02, 2.3012777503579d-02,
     |   3.2541501468163d-02, 4.2930101086061d-02, 5.2717126384370d-02,
     |   5.9982244349959d-02, 6.2704476099058d-02, 5.9266042651968d-02,
     |   4.8964921192638d-02, 3.2362457629519d-02, 1.1320958474437d-02,
     |  -1.1320958474437d-02,-3.2362457629519d-02,-4.8964921192638d-02,
     |  -5.9266042651968d-02,-6.2704476099058d-02,-5.9982244349959d-02,
     |  -5.2717126384370d-02,-4.2930101086061d-02,-3.2541501468163d-02,
     |  -2.3012777503579d-02,-1.5194653065727d-02,-9.3638787409236d-03,
     |  -5.3792979614766d-03,-2.8748344826664d-03,-1.4252557842902d-03,
     |  -6.5311936450889d-04,-2.7539782134579d-04,-1.0627142468417d-04,
     |  -3.7280352157805d-05,-1.1794268273031d-05,-3.3325414699613d-06,
     |  -8.3111861648754d-07,-1.8031627632897d-07,-3.3425291476667d-08,
     |  -5.1754960781108d-09,-6.5026586520152d-10,-6.3838389595181d-11,
     |  -4.6555443866462d-12,-2.3510279447448d-13,-7.2991074995997d-15,
     |   5.7335522075443d-17, 5.0746838026545d-17, 8.5303833553845d-17,
     |   7.3327211894173d-17,-3.9414453363631d-17,-3.9532968836065d-17/
      data (zmn(lat,25,25), lat = 1,72)/
     |  -3.5583358844132d-17,-9.0602049513319d-17,-1.4111063022844d-16,
     |  -1.8966021271757d-16,-2.3173479797481d-16,-2.5960552740996d-16,
     |   4.2972067655711d-17, 1.1040883590638d-14, 2.5581212158612d-13,
     |   3.9722792907738d-12, 4.5350237904481d-11, 4.0154806010658d-10,
     |   2.8684442948111d-09, 1.7038937619215d-08, 8.6182369944596d-08,
     |   3.7825224873990d-07, 1.4627629020617d-06, 5.0470698652337d-06,
     |   1.5699549410714d-05, 4.4410694064121d-05, 1.1508443764073d-04,
     |   2.7489534465650d-04, 6.0846451596000d-04, 1.2536732666532d-03,
     |   2.4137934454006d-03, 4.3574335899326d-03, 7.3964098057999d-03,
     |   1.1834186070545d-02, 1.7885276029013d-02, 2.5578069934467d-02,
     |   3.4666221142197d-02, 4.4581200097795d-02, 5.4455376801817d-02,
     |   6.3228852518932d-02, 6.9827599161805d-02, 7.3373950775317d-02,
     |   7.3373950775317d-02, 6.9827599161805d-02, 6.3228852518932d-02,
     |   5.4455376801817d-02, 4.4581200097795d-02, 3.4666221142197d-02,
     |   2.5578069934467d-02, 1.7885276029013d-02, 1.1834186070545d-02,
     |   7.3964098057999d-03, 4.3574335899326d-03, 2.4137934454006d-03,
     |   1.2536732666532d-03, 6.0846451596001d-04, 2.7489534465652d-04,
     |   1.1508443764074d-04, 4.4410694064132d-05, 1.5699549410719d-05,
     |   5.0470698652601d-06, 1.4627629020302d-06, 3.7825224875081d-07,
     |   8.6182369943409d-08, 1.7038937615844d-08, 2.8684442907411d-09,
     |   4.0154804756604d-10, 4.5350211202113d-11, 3.9722982216690d-12,
     |   2.5582994550392d-13, 1.1043012950083d-14, 2.0787343943182d-17,
     |  -2.7167679237191d-16,-2.6909183113230d-16,-1.8641637296090d-16,
     |  -1.5551520455708d-16,-1.2923246592465d-16,-6.1693705448138d-17/
      data (zmn(lat, 0,26), lat = 1,72)/
     |   3.8171353842234d-03, 5.9655753646835d-03,-5.6856221141731d-03,
     |  -1.3266907011164d-02,-4.9599007007378d-03, 1.2786435412869d-02,
     |   1.6596910490964d-02,-2.7383120220863d-04,-1.9428645025611d-02,
     |  -1.5870476683082d-02, 7.8763160151320d-03, 2.4149680018861d-02,
     |   1.1448266904328d-02,-1.6264701944080d-02,-2.5867478654852d-02,
     |  -4.0091985946458d-03, 2.3881948919473d-02, 2.4006060306304d-02,
     |  -5.3563426554471d-03,-2.9335253672727d-02,-1.8566721960878d-02,
     |   1.5264540194050d-02, 3.1575232384057d-02, 1.0120935113580d-02,
     |  -2.4232138413521d-02,-3.0042782725174d-02, 2.7915969059317d-04,
     |   3.0895267450644d-02, 2.4749193664192d-02,-1.1261279296023d-02,
     |  -3.4213939791247d-02,-1.6273084917506d-02, 2.1341197536694d-02,
     |   3.3629098659583d-02, 5.6728618795747d-03,-2.9147510278804d-02,
     |  -2.9147510278804d-02, 5.6728618795745d-03, 3.3629098659583d-02,
     |   2.1341197536694d-02,-1.6273084917506d-02,-3.4213939791247d-02,
     |  -1.1261279296024d-02, 2.4749193664192d-02, 3.0895267450644d-02,
     |   2.7915969059325d-04,-3.0042782725174d-02,-2.4232138413521d-02,
     |   1.0120935113580d-02, 3.1575232384057d-02, 1.5264540194050d-02,
     |  -1.8566721960878d-02,-2.9335253672727d-02,-5.3563426554471d-03,
     |   2.4006060306304d-02, 2.3881948919473d-02,-4.0091985946456d-03,
     |  -2.5867478654852d-02,-1.6264701944080d-02, 1.1448266904327d-02,
     |   2.4149680018861d-02, 7.8763160151320d-03,-1.5870476683082d-02,
     |  -1.9428645025611d-02,-2.7383120220876d-04, 1.6596910490964d-02,
     |   1.2786435412869d-02,-4.9599007007377d-03,-1.3266907011163d-02,
     |  -5.6856221141731d-03, 5.9655753646836d-03, 3.8171353842233d-03/
      data (zmn(lat, 1,26), lat = 1,72)/
     |   1.5895426668554d-03, 8.4258348044687d-03, 9.3247329820815d-03,
     |  -2.8925309430030d-03,-1.5066309966838d-02,-1.0366338006288d-02,
     |   8.8045734602763d-03, 1.9715899278306d-02, 7.1308415404580d-03,
     |  -1.5991814665874d-02,-2.1440415273984d-02,-7.1156947800325d-04,
     |   2.2661953226218d-02, 1.9709094430592d-02,-7.6974384273686d-03,
     |  -2.7364015290384d-02,-1.4534163409047d-02, 1.6692153951118d-02,
     |   2.9034161060679d-02, 6.4790971501413d-03,-2.4799268281534d-02,
     |  -2.7108544476399d-02, 3.4247747535840d-03, 3.0675078584283d-02,
     |   2.1591282375865d-02,-1.3834157874163d-02,-3.3299856955800d-02,
     |  -1.3047030665806d-02, 2.3297350675383d-02, 3.2129032155101d-02,
     |   2.5129972139401d-03,-3.0474365166975d-02,-2.7174955405623d-02,
     |   8.6586945428389d-03, 3.4340165843273d-02, 1.9005449748464d-02,
     |  -1.9005449748464d-02,-3.4340165843273d-02,-8.6586945428390d-03,
     |   2.7174955405623d-02, 3.0474365166975d-02,-2.5129972139403d-03,
     |  -3.2129032155101d-02,-2.3297350675384d-02, 1.3047030665805d-02,
     |   3.3299856955800d-02, 1.3834157874163d-02,-2.1591282375865d-02,
     |  -3.0675078584283d-02,-3.4247747535839d-03, 2.7108544476399d-02,
     |   2.4799268281534d-02,-6.4790971501412d-03,-2.9034161060679d-02,
     |  -1.6692153951118d-02, 1.4534163409047d-02, 2.7364015290384d-02,
     |   7.6974384273684d-03,-1.9709094430592d-02,-2.2661953226218d-02,
     |   7.1156947800312d-04, 2.1440415273984d-02, 1.5991814665874d-02,
     |  -7.1308415404578d-03,-1.9715899278306d-02,-8.8045734602763d-03,
     |   1.0366338006288d-02, 1.5066309966838d-02, 2.8925309430030d-03,
     |  -9.3247329820815d-03,-8.4258348044688d-03,-1.5895426668554d-03/
      data (zmn(lat, 2,26), lat = 1,72)/
     |   2.2855390728948d-04, 4.2282259695947d-03, 1.1839967926027d-02,
     |   1.2071584126826d-02,-9.1836403388139d-04,-1.5877284976455d-02,
     |  -1.4446129982618d-02, 4.7583133605263d-03, 2.0760846161735d-02,
     |   1.3217956683282d-02,-1.1238508576742d-02,-2.4224306005144d-02,
     |  -8.6938792003560d-03, 1.8565200098700d-02, 2.5067515167833d-02,
     |   1.4771676491103d-03,-2.5205063089437d-02,-2.2689049146792d-02,
     |   7.4346248445113d-03, 2.9834505806008d-02, 1.7063170783183d-02,
     |  -1.6765587672335d-02,-3.1468546502100d-02,-8.7090163459951d-03,
     |   2.5144732645210d-02, 2.9585619895016d-02,-1.4011426521641d-03,
     |  -3.1310557141687d-02,-2.4197488468081d-02, 1.1994522365105d-02,
     |   3.4301493954227d-02, 1.5844409875100d-02,-2.1692728633980d-02,
     |  -3.3601944133813d-02,-5.5128995023581d-03, 2.9221161330814d-02,
     |   2.9221161330814d-02,-5.5128995023580d-03,-3.3601944133813d-02,
     |  -2.1692728633980d-02, 1.5844409875100d-02, 3.4301493954227d-02,
     |   1.1994522365106d-02,-2.4197488468080d-02,-3.1310557141687d-02,
     |  -1.4011426521642d-03, 2.9585619895016d-02, 2.5144732645210d-02,
     |  -8.7090163459950d-03,-3.1468546502100d-02,-1.6765587672335d-02,
     |   1.7063170783183d-02, 2.9834505806008d-02, 7.4346248445113d-03,
     |  -2.2689049146792d-02,-2.5205063089437d-02, 1.4771676491100d-03,
     |   2.5067515167833d-02, 1.8565200098700d-02,-8.6938792003558d-03,
     |  -2.4224306005144d-02,-1.1238508576742d-02, 1.3217956683282d-02,
     |   2.0760846161735d-02, 4.7583133605264d-03,-1.4446129982618d-02,
     |  -1.5877284976455d-02,-9.1836403388142d-04, 1.2071584126826d-02,
     |   1.1839967926027d-02, 4.2282259695946d-03, 2.2855390728950d-04/
      data (zmn(lat, 3,26), lat = 1,72)/
     |   6.3426840361185d-06, 1.3186981108848d-03, 7.0524126756820d-03,
     |   1.4780098275707d-02, 1.4421835463962d-02, 5.4591862174186d-04,
     |  -1.6332163137565d-02,-1.7659449505496d-02, 9.5543642781656d-04,
     |   2.0580058953149d-02, 1.8058921584280d-02,-5.9934748629363d-03,
     |  -2.4886934847098d-02,-1.5565240632902d-02, 1.2915373485340d-02,
     |   2.7709282375046d-02, 1.0230499851839d-02,-2.0345941810940d-02,
     |  -2.8026070045875d-02,-2.5429992764460d-03, 2.6959115084243d-02,
     |   2.5310155145256d-02,-6.6103381118876d-03,-3.1576682760858d-02,
     |  -1.9549353887574d-02, 1.6073676017943d-02, 3.3314243275240d-02,
     |   1.1226036273978d-02,-2.4597285308511d-02,-3.1703460044714d-02,
     |  -1.2352752656319d-03, 3.1027351211414d-02, 2.6759010653983d-02,
     |  -9.2538124010404d-03,-3.4481178194441d-02,-1.8975621301948d-02,
     |   1.8975621301948d-02, 3.4481178194441d-02, 9.2538124010405d-03,
     |  -2.6759010653983d-02,-3.1027351211414d-02, 1.2352752656321d-03,
     |   3.1703460044714d-02, 2.4597285308512d-02,-1.1226036273978d-02,
     |  -3.3314243275240d-02,-1.6073676017943d-02, 1.9549353887574d-02,
     |   3.1576682760858d-02, 6.6103381118875d-03,-2.5310155145256d-02,
     |  -2.6959115084244d-02, 2.5429992764458d-03, 2.8026070045875d-02,
     |   2.0345941810940d-02,-1.0230499851839d-02,-2.7709282375046d-02,
     |  -1.2915373485339d-02, 1.5565240632902d-02, 2.4886934847098d-02,
     |   5.9934748629364d-03,-1.8058921584280d-02,-2.0580058953149d-02,
     |  -9.5543642781672d-04, 1.7659449505496d-02, 1.6332163137565d-02,
     |  -5.4591862174158d-04,-1.4421835463962d-02,-1.4780098275707d-02,
     |  -7.0524126756820d-03,-1.3186981108848d-03,-6.3426840360907d-06/
      data (zmn(lat, 4,26), lat = 1,72)/
     |   5.6290637153734d-07, 2.9453395644274d-04, 2.8501650429200d-03,
     |   9.7871397477344d-03, 1.7501264978759d-02, 1.6441161752537d-02,
     |   1.7221939962665d-03,-1.6672384731571d-02,-2.0280533738486d-02,
     |  -2.6000014498567d-03, 1.9659077461954d-02, 2.1827521150880d-02,
     |  -6.3040847433751d-04,-2.3972049384542d-02,-2.1147996221187d-02,
     |   6.3980501150746d-03, 2.7983108515095d-02, 1.7929076751887d-02,
     |  -1.3591663781010d-02,-3.0476475297621d-02,-1.2192096990367d-02,
     |   2.1074690058934d-02, 3.0598568975468d-02, 4.3679051622108d-03,
     |  -2.7701656404874d-02,-2.7905159526865d-02, 4.7570574721628d-03,
     |   3.2442171895619d-02, 2.2396484619640d-02,-1.4158329043028d-02,
     |  -3.4518477279608d-02,-1.4504138983489d-02, 2.2728146339921d-02,
     |   3.3515842140454d-02, 5.0208268929274d-03,-2.9442588383422d-02,
     |  -2.9442588383422d-02, 5.0208268929273d-03, 3.3515842140454d-02,
     |   2.2728146339921d-02,-1.4504138983489d-02,-3.4518477279608d-02,
     |  -1.4158329043028d-02, 2.2396484619640d-02, 3.2442171895619d-02,
     |   4.7570574721629d-03,-2.7905159526865d-02,-2.7701656404874d-02,
     |   4.3679051622107d-03, 3.0598568975468d-02, 2.1074690058934d-02,
     |  -1.2192096990367d-02,-3.0476475297621d-02,-1.3591663781010d-02,
     |   1.7929076751887d-02, 2.7983108515095d-02, 6.3980501150749d-03,
     |  -2.1147996221187d-02,-2.3972049384542d-02,-6.3040847433775d-04,
     |   2.1827521150880d-02, 1.9659077461954d-02,-2.6000014498567d-03,
     |  -2.0280533738486d-02,-1.6672384731571d-02, 1.7221939962664d-03,
     |   1.6441161752537d-02, 1.7501264978759d-02, 9.7871397477345d-03,
     |   2.8501650429200d-03, 2.9453395644290d-04, 5.6290637149302d-07/
      data (zmn(lat, 5,26), lat = 1,72)/
     |   6.0456516410868d-07, 5.1095931726166d-05, 8.7771571994026d-04,
     |   4.6136898033715d-03, 1.2445804329220d-02, 2.0034353274088d-02,
     |   1.8236765029788d-02, 2.7178758660323d-03,-1.6937755954449d-02,
     |  -2.2509616771405d-02,-5.9534731147134d-03, 1.8217417766435d-02,
     |   2.4713308840102d-02, 4.6668636255581d-03,-2.1827228819835d-02,
     |  -2.5428358355109d-02,-5.1649264234645d-04, 2.6203194252485d-02,
     |   2.4203255237141d-02,-5.6286950641208d-03,-3.0115245515783d-02,
     |  -2.0723564890961d-02, 1.2911208092133d-02, 3.2574207859068d-02,
     |   1.5007175675277d-02,-2.0382336363330d-02,-3.2868774973650d-02,
     |  -7.4260132609630d-03, 2.7069155222543d-02, 3.0625600835322d-02,
     |  -1.3459208891161d-03,-3.2091675854709d-02,-2.5844792951988d-02,
     |   1.0433277819614d-02, 3.4782715557021d-02, 1.8890706933348d-02,
     |  -1.8890706933347d-02,-3.4782715557021d-02,-1.0433277819614d-02,
     |   2.5844792951988d-02, 3.2091675854709d-02, 1.3459208891159d-03,
     |  -3.0625600835322d-02,-2.7069155222543d-02, 7.4260132609629d-03,
     |   3.2868774973650d-02, 2.0382336363330d-02,-1.5007175675277d-02,
     |  -3.2574207859068d-02,-1.2911208092133d-02, 2.0723564890961d-02,
     |   3.0115245515783d-02, 5.6286950641210d-03,-2.4203255237141d-02,
     |  -2.6203194252485d-02, 5.1649264234637d-04, 2.5428358355109d-02,
     |   2.1827228819835d-02,-4.6668636255581d-03,-2.4713308840102d-02,
     |  -1.8217417766435d-02, 5.9534731147134d-03, 2.2509616771405d-02,
     |   1.6937755954449d-02,-2.7178758660322d-03,-1.8236765029788d-02,
     |  -2.0034353274088d-02,-1.2445804329220d-02,-4.6136898033714d-03,
     |  -8.7771571994022d-04,-5.1095931726133d-05,-6.0456516407792d-07/
      data (zmn(lat, 6,26), lat = 1,72)/
     |   2.5245799432592d-08, 7.3705804315014d-06, 2.1830364582488d-04,
     |   1.7050874361058d-03, 6.5045158319616d-03, 1.5021304103183d-02,
     |   2.2400223164007d-02, 1.9885240667952d-02, 3.6284591926940d-03,
     |  -1.7114463558070d-02,-2.4462305301230d-02,-9.1794468467984d-03,
     |   1.6345219368696d-02, 2.6844395882612d-02, 9.8209853076522d-03,
     |  -1.8667217014703d-02,-2.8417989721417d-02,-7.5026941577800d-03,
     |   2.2630066029473d-02, 2.8798397342205d-02, 2.9585049056102d-03,
     |  -2.7092410212331d-02,-2.7497608389966d-02, 3.2249477693456d-03,
     |   3.1082920917691d-02, 2.4234695795103d-02,-1.0371490291127d-02,
     |  -3.3796580263911d-02,-1.9017951117789d-02, 1.7706839826374d-02,
     |   3.4647261349366d-02, 1.2149239930364d-02,-2.4431169955532d-02,
     |  -3.3323491951675d-02,-4.1786166380935d-03, 2.9819859421040d-02,
     |   2.9819859421040d-02,-4.1786166380935d-03,-3.3323491951675d-02,
     |  -2.4431169955532d-02, 1.2149239930364d-02, 3.4647261349366d-02,
     |   1.7706839826374d-02,-1.9017951117788d-02,-3.3796580263911d-02,
     |  -1.0371490291127d-02, 2.4234695795103d-02, 3.1082920917691d-02,
     |   3.2249477693457d-03,-2.7497608389966d-02,-2.7092410212331d-02,
     |   2.9585049056097d-03, 2.8798397342205d-02, 2.2630066029473d-02,
     |  -7.5026941577799d-03,-2.8417989721417d-02,-1.8667217014704d-02,
     |   9.8209853076524d-03, 2.6844395882612d-02, 1.6345219368696d-02,
     |  -9.1794468467983d-03,-2.4462305301230d-02,-1.7114463558070d-02,
     |   3.6284591926938d-03, 1.9885240667952d-02, 2.2400223164007d-02,
     |   1.5021304103184d-02, 6.5045158319618d-03, 1.7050874361056d-03,
     |   2.1830364582485d-04, 7.3705804313747d-06, 2.5245799440169d-08/
      data (zmn(lat, 7,26), lat = 1,72)/
     |  -1.9201525979548d-08, 9.1812823918850d-07, 4.5468200423619d-05,
     |   5.1909404703115d-04, 2.7159525403869d-03, 8.4581165426935d-03,
     |   1.7495616365068d-02, 2.4620171971844d-02, 2.1449394430994d-02,
     |   4.5451780074234d-03,-1.7162897485378d-02,-2.6197805290350d-02,
     |  -1.2355083270396d-02, 1.4056791175155d-02, 2.8281206192454d-02,
     |   1.4794229925479d-02,-1.4614907297389d-02,-3.0101234779522d-02,
     |  -1.4303200968362d-02, 1.7476419941245d-02, 3.1496942292098d-02,
     |   1.1632143690172d-02,-2.1610167157076d-02,-3.1954965082207d-02,
     |  -7.1776461964979d-03, 2.6149156927693d-02, 3.1034648118772d-02,
     |   1.3541878330004d-03,-3.0329544369785d-02,-2.8492077644127d-02,
     |   5.3182813977046d-03, 3.3510862024910d-02, 2.4322296097452d-02,
     |  -1.2232435522053d-02,-3.5225376921521d-02,-1.8757789129205d-02,
     |   1.8757789129205d-02, 3.5225376921521d-02, 1.2232435522053d-02,
     |  -2.4322296097451d-02,-3.3510862024910d-02,-5.3182813977044d-03,
     |   2.8492077644127d-02, 3.0329544369785d-02,-1.3541878330003d-03,
     |  -3.1034648118772d-02,-2.6149156927693d-02, 7.1776461964976d-03,
     |   3.1954965082207d-02, 2.1610167157076d-02,-1.1632143690172d-02,
     |  -3.1496942292098d-02,-1.7476419941245d-02, 1.4303200968362d-02,
     |   3.0101234779522d-02, 1.4614907297389d-02,-1.4794229925479d-02,
     |  -2.8281206192454d-02,-1.4056791175155d-02, 1.2355083270396d-02,
     |   2.6197805290350d-02, 1.7162897485378d-02,-4.5451780074234d-03,
     |  -2.1449394430994d-02,-2.4620171971844d-02,-1.7495616365068d-02,
     |  -8.4581165426935d-03,-2.7159525403869d-03,-5.1909404703125d-04,
     |  -4.5468200423626d-05,-9.1812823921562d-07, 1.9201525912086d-08/
      data (zmn(lat, 8,26), lat = 1,72)/
     |  -5.6132519996375d-10, 9.6189010100059d-08, 8.1285369466167d-06,
     |   1.3417207773207d-04, 9.4637624218341d-04, 3.8561961862109d-03,
     |   1.0421374715472d-02, 1.9850849555259d-02, 2.6714200908369d-02,
     |   2.2988729189310d-02, 5.5557461733788d-03,-1.7024682881511d-02,
     |  -2.7736417229293d-02,-1.5545819740113d-02, 1.1318794591354d-02,
     |   2.9021834723598d-02, 1.9544768179455d-02,-9.7366097147128d-03,
     |  -3.0416007104229d-02,-2.0666658471130d-02, 1.0933845874240d-02,
     |   3.2082388130941d-02, 1.9840403440480d-02,-1.3940575782485d-02,
     |  -3.3586946038168d-02,-1.7392855220736d-02, 1.8005075487399d-02,
     |   3.4450901196048d-02, 1.3551936621195d-02,-2.2472091941869d-02,
     |  -3.4303854104494d-02,-8.6085524774813d-03, 2.6756523979482d-02,
     |   3.2944725427954d-02, 2.9519182579011d-03,-3.0366702841798d-02,
     |  -3.0366702841798d-02, 2.9519182579009d-03, 3.2944725427954d-02,
     |   2.6756523979482d-02,-8.6085524774812d-03,-3.4303854104494d-02,
     |  -2.2472091941869d-02, 1.3551936621194d-02, 3.4450901196048d-02,
     |   1.8005075487399d-02,-1.7392855220736d-02,-3.3586946038168d-02,
     |  -1.3940575782485d-02, 1.9840403440480d-02, 3.2082388130941d-02,
     |   1.0933845874241d-02,-2.0666658471129d-02,-3.0416007104229d-02,
     |  -9.7366097147129d-03, 1.9544768179455d-02, 2.9021834723598d-02,
     |   1.1318794591354d-02,-1.5545819740113d-02,-2.7736417229293d-02,
     |  -1.7024682881511d-02, 5.5557461733789d-03, 2.2988729189310d-02,
     |   2.6714200908370d-02, 1.9850849555259d-02, 1.0421374715472d-02,
     |   3.8561961862110d-03, 9.4637624218323d-04, 1.3417207773215d-04,
     |   8.1285369466382d-06, 9.6189010186728d-08,-5.6132517798126d-10/
      data (zmn(lat, 9,26), lat = 1,72)/
     |   6.6475397077116d-10, 8.1708021529769d-09, 1.2683218440145d-06,
     |   3.0046855478787d-05, 2.8262875265107d-04, 1.4807948658643d-03,
     |   5.0752574665986d-03, 1.2346719170884d-02, 2.2070215828322d-02,
     |   2.8701868742613d-02, 2.4561002109335d-02, 6.7469451079973d-03,
     |  -1.6625945891532d-02,-2.9065179285085d-02,-1.8797757897620d-02,
     |   8.0697603140365d-03, 2.9005997492980d-02, 2.3997524119836d-02,
     |  -4.0770921740398d-03,-2.9250298345480d-02,-2.6300512119246d-02,
     |   3.2164324531806d-03, 3.0333561186836d-02, 2.6965744105931d-02,
     |  -4.4778073619272d-03,-3.1946711118488d-02,-2.6376080295610d-02,
     |   7.1688564282640d-03, 3.3644725898514d-02, 2.4676272644380d-02,
     |  -1.0736257074633d-02,-3.5025271317692d-02,-2.2004033704858d-02,
     |   1.4686756902708d-02, 3.5793210546368d-02, 1.8572111933503d-02,
     |  -1.8572111933503d-02,-3.5793210546368d-02,-1.4686756902708d-02,
     |   2.2004033704858d-02, 3.5025271317692d-02, 1.0736257074633d-02,
     |  -2.4676272644380d-02,-3.3644725898514d-02,-7.1688564282641d-03,
     |   2.6376080295610d-02, 3.1946711118488d-02, 4.4778073619275d-03,
     |  -2.6965744105931d-02,-3.0333561186836d-02,-3.2164324531806d-03,
     |   2.6300512119246d-02, 2.9250298345480d-02, 4.0770921740398d-03,
     |  -2.3997524119835d-02,-2.9005997492980d-02,-8.0697603140367d-03,
     |   1.8797757897620d-02, 2.9065179285085d-02, 1.6625945891533d-02,
     |  -6.7469451079974d-03,-2.4561002109335d-02,-2.8701868742613d-02,
     |  -2.2070215828322d-02,-1.2346719170884d-02,-5.0752574665986d-03,
     |  -1.4807948658644d-03,-2.8262875265113d-04,-3.0046855478674d-05,
     |  -1.2683218441249d-06,-8.1708021442662d-09,-6.6475391941028d-10/
      data (zmn(lat,10,26), lat = 1,72)/
     |   1.4706357383802d-11, 6.7610806305739d-10, 1.7465410727138d-07,
     |   5.9139583092265d-06, 7.3640105482591d-05, 4.9062768253703d-04,
     |   2.0958748481458d-03, 6.3240508968523d-03, 1.4190000791670d-02,
     |   2.4137418686871d-02, 3.0601447010088d-02, 2.6221383271047d-02,
     |   8.2058586389231d-03,-1.5877476236732d-02,-3.0137631633013d-02,
     |  -2.2129654656210d-02, 4.2354892858267d-03, 2.8118509584875d-02,
     |   2.8020234036178d-02, 2.3039350009124d-03,-2.6452084495150d-02,
     |  -3.0834790815970d-02,-5.3827509975951d-03, 2.6050086792472d-02,
     |   3.2289846309988d-02, 6.1837880183346d-03,-2.6712363169034d-02,
     |  -3.2925426531800d-02,-5.4399000443517d-03, 2.8033465305948d-02,
     |   3.2893137616164d-02, 3.6650237932591d-03,-2.9611369643029d-02,
     |  -3.2255368083040d-02,-1.2880405603592d-03, 3.1104894826515d-02,
     |   3.1104894826515d-02,-1.2880405603591d-03,-3.2255368083040d-02,
     |  -2.9611369643029d-02, 3.6650237932590d-03, 3.2893137616164d-02,
     |   2.8033465305948d-02,-5.4399000443514d-03,-3.2925426531800d-02,
     |  -2.6712363169034d-02, 6.1837880183345d-03, 3.2289846309988d-02,
     |   2.6050086792472d-02,-5.3827509975952d-03,-3.0834790815970d-02,
     |  -2.6452084495150d-02, 2.3039350009121d-03, 2.8020234036178d-02,
     |   2.8118509584875d-02, 4.2354892858268d-03,-2.2129654656210d-02,
     |  -3.0137631633013d-02,-1.5877476236732d-02, 8.2058586389229d-03,
     |   2.6221383271047d-02, 3.0601447010088d-02, 2.4137418686871d-02,
     |   1.4190000791670d-02, 6.3240508968523d-03, 2.0958748481458d-03,
     |   4.9062768253711d-04, 7.3640105482805d-05, 5.9139583091868d-06,
     |   1.7465410715961d-07, 6.7610802088297d-10, 1.4706307312475d-11/
      data (zmn(lat,11,26), lat = 1,72)/
     |  -2.1256475264913d-11, 7.0922293635297d-11, 2.1413133117241d-08,
     |   1.0337194977696d-06, 1.6950746309840d-05, 1.4252375676367d-04,
     |   7.5037796102967d-04, 2.7602630100089d-03, 7.5542792157711d-03,
     |   1.5909059127834d-02, 2.6035303960468d-02, 3.2427503058198d-02,
     |   2.8020160067539d-02, 1.0019558260225d-02,-1.4673432236767d-02,
     |  -3.0869790186968d-02,-2.5521946036877d-02,-2.5508131975680d-04,
     |   2.6194202984456d-02, 3.1401125190362d-02, 9.2901001788406d-03,
     |  -2.1854799732172d-02,-3.3798115523132d-02,-1.4423711829689d-02,
     |   1.9114307131711d-02, 3.4988548165530d-02, 1.7156422294672d-02,
     |  -1.7813767848455d-02,-3.5726221832847d-02,-1.8373110558977d-02,
     |   1.7532261177808d-02, 3.6211249559727d-02, 1.8626290979773d-02,
     |  -1.7836511243132d-02,-3.6462198404104d-02,-1.8325327143392d-02,
     |   1.8325327143392d-02, 3.6462198404104d-02, 1.7836511243132d-02,
     |  -1.8626290979773d-02,-3.6211249559727d-02,-1.7532261177807d-02,
     |   1.8373110558977d-02, 3.5726221832847d-02, 1.7813767848455d-02,
     |  -1.7156422294672d-02,-3.4988548165530d-02,-1.9114307131711d-02,
     |   1.4423711829689d-02, 3.3798115523132d-02, 2.1854799732172d-02,
     |  -9.2901001788403d-03,-3.1401125190362d-02,-2.6194202984456d-02,
     |   2.5508131975661d-04, 2.5521946036876d-02, 3.0869790186969d-02,
     |   1.4673432236767d-02,-1.0019558260225d-02,-2.8020160067538d-02,
     |  -3.2427503058198d-02,-2.6035303960468d-02,-1.5909059127834d-02,
     |  -7.5542792157711d-03,-2.7602630100089d-03,-7.5037796102971d-04,
     |  -1.4252375676368d-04,-1.6950746309884d-05,-1.0337194978833d-06,
     |  -2.1413132995976d-08,-7.0922300792749d-11, 2.1256489642203d-11/
      data (zmn(lat,12,26), lat = 1,72)/
     |  -3.6669129297409d-13, 4.3553535036769d-12, 2.3583159730155d-09,
     |   1.6168311260884d-07, 3.4781097199756d-06, 3.6705624259556d-05,
     |   2.3634372443107d-04, 1.0480393607484d-03, 3.4392056641122d-03,
     |   8.7182419476593d-03, 1.7462475301208d-02, 2.7743707390634d-02,
     |   3.4187288509581d-02, 2.9998857204000d-02, 1.2273065549340d-02,
     |  -1.2890120764433d-02,-3.1133509102583d-02,-2.8901548700340d-02,
     |  -5.4493247661498d-03, 2.3027745607721d-02, 3.3828361232998d-02,
     |   1.6657886657326d-02,-1.5324270717051d-02,-3.4613311182628d-02,
     |  -2.3244028444305d-02, 9.5976049826398d-03, 3.4179232432112d-02,
     |   2.7171367301686d-02,-5.6312695834344d-03,-3.3504110032146d-02,
     |  -2.9568656803221d-02, 2.9022035703533d-03, 3.2819157558671d-02,
     |   3.1071916234069d-02,-8.8954152941172d-04,-3.2067944288744d-02,
     |  -3.2067944288744d-02,-8.8954152941183d-04, 3.1071916234069d-02,
     |   3.2819157558671d-02, 2.9022035703534d-03,-2.9568656803221d-02,
     |  -3.3504110032146d-02,-5.6312695834347d-03, 2.7171367301686d-02,
     |   3.4179232432112d-02, 9.5976049826399d-03,-2.3244028444305d-02,
     |  -3.4613311182628d-02,-1.5324270717051d-02, 1.6657886657326d-02,
     |   3.3828361232998d-02, 2.3027745607722d-02,-5.4493247661497d-03,
     |  -2.8901548700340d-02,-3.1133509102583d-02,-1.2890120764433d-02,
     |   1.2273065549340d-02, 2.9998857204000d-02, 3.4187288509581d-02,
     |   2.7743707390634d-02, 1.7462475301208d-02, 8.7182419476593d-03,
     |   3.4392056641123d-03, 1.0480393607484d-03, 2.3634372443101d-04,
     |   3.6705624259442d-05, 3.4781097199140d-06, 1.6168311270590d-07,
     |   2.3583161436128d-09, 4.3552748663259d-12,-3.6672242671388d-13/
      data (zmn(lat,13,26), lat = 1,72)/
     |   6.2442327677919d-13,-3.7568227134917d-13, 2.3477437515731d-10,
     |   2.2754835821770d-08, 6.4030205318358d-07, 8.4469200835881d-06,
     |   6.6144617807140d-05, 3.5083385938116d-04, 1.3650964066778d-03,
     |   4.0958176307606d-03, 9.7688472295802d-03, 1.8808281497004d-02,
     |   2.9236618979311d-02, 3.5875989151065d-02, 3.2184502574987d-02,
     |   1.5044863669690d-02,-1.0386387417590d-02,-3.0748655666693d-02,
     |  -3.2121699072027d-02,-1.1341663768625d-02, 1.8393957013776d-02,
     |   3.4875091986834d-02, 2.4016053266024d-02,-6.8358791901639d-03,
     |  -3.2627643091152d-02,-3.0887953462653d-02,-2.0825685384273d-03,
     |   2.9053839102987d-02, 3.4539598037409d-02, 8.7423179676433d-03,
     |  -2.5344963089013d-02,-3.6405611084756d-02,-1.3842988407088d-02,
     |   2.1719472081989d-02, 3.7195063589488d-02, 1.8005059188210d-02,
     |  -1.8005059188210d-02,-3.7195063589488d-02,-2.1719472081989d-02,
     |   1.3842988407088d-02, 3.6405611084756d-02, 2.5344963089013d-02,
     |  -8.7423179676432d-03,-3.4539598037409d-02,-2.9053839102987d-02,
     |   2.0825685384272d-03, 3.0887953462653d-02, 3.2627643091152d-02,
     |   6.8358791901640d-03,-2.4016053266024d-02,-3.4875091986834d-02,
     |  -1.8393957013776d-02, 1.1341663768626d-02, 3.2121699072027d-02,
     |   3.0748655666693d-02, 1.0386387417590d-02,-1.5044863669690d-02,
     |  -3.2184502574987d-02,-3.5875989151065d-02,-2.9236618979311d-02,
     |  -1.8808281497004d-02,-9.7688472295803d-03,-4.0958176307606d-03,
     |  -1.3650964066779d-03,-3.5083385938115d-04,-6.6144617807131d-05,
     |  -8.4469200835931d-06,-6.4030205310021d-07,-2.2754835762857d-08,
     |  -2.3477450517158d-10, 3.7565140819724d-13,-6.2451214935003d-13/
      data (zmn(lat,14,26), lat = 1,72)/
     |   8.4641655289715d-15,-1.2458934660524d-14, 2.1076164713256d-11,
     |   2.8929413250498d-09, 1.0623718090671d-07, 1.7464591652559d-06,
     |   1.6561925796314d-05, 1.0447700820839d-04, 4.7826581673744d-04,
     |   1.6797304946648d-03, 4.6923219041684d-03, 1.0659759719642d-02,
     |   1.9902626748044d-02, 3.0478859481747d-02, 3.7470850518846d-02,
     |   3.4581614974412d-02, 1.8398794175088d-02,-7.0076898956454d-03,
     |  -2.9476312521778d-02,-3.4937026672969d-02,-1.7831674617082d-02,
     |   1.2086713419006d-02, 3.3999115490502d-02, 3.0738512683691d-02,
     |   3.4087440952669d-03,-2.7202059077271d-02,-3.6068093327048d-02,
     |  -1.4960185351024d-02, 1.9138450573077d-02, 3.7236838382903d-02,
     |   2.3227633850252d-02,-1.1230484022064d-02,-3.6058932193403d-02,
     |  -2.9127139586318d-02, 3.6911348179450d-03, 3.3307807388367d-02,
     |   3.3307807388367d-02, 3.6911348179451d-03,-2.9127139586318d-02,
     |  -3.6058932193403d-02,-1.1230484022064d-02, 2.3227633850252d-02,
     |   3.7236838382903d-02, 1.9138450573077d-02,-1.4960185351024d-02,
     |  -3.6068093327048d-02,-2.7202059077272d-02, 3.4087440952666d-03,
     |   3.0738512683691d-02, 3.3999115490502d-02, 1.2086713419006d-02,
     |  -1.7831674617082d-02,-3.4937026672969d-02,-2.9476312521778d-02,
     |  -7.0076898956455d-03, 1.8398794175088d-02, 3.4581614974412d-02,
     |   3.7470850518845d-02, 3.0478859481747d-02, 1.9902626748044d-02,
     |   1.0659759719642d-02, 4.6923219041684d-03, 1.6797304946649d-03,
     |   4.7826581673750d-04, 1.0447700820837d-04, 1.6561925796293d-05,
     |   1.7464591652976d-06, 1.0623718088409d-07, 2.8929412834726d-09,
     |   2.1076077174097d-11,-1.2399204781355d-14, 8.5026283719522d-15/
      data (zmn(lat,15,26), lat = 1,72)/
     |  -1.6528621245435d-14, 1.5992327361964d-14, 1.6998207260268d-12,
     |   3.3306605172957d-10, 1.5932506914133d-08, 3.2558793602463d-07,
     |   3.7270360792044d-06, 2.7842596212518d-05, 1.4909335964120d-04,
     |   6.0819285520295d-04, 1.9682754101824d-03, 5.1913686943204d-03,
     |   1.1345749444377d-02, 2.0698593112440d-02, 3.1422582428267d-02,
     |   3.8924298299368d-02, 3.7161438543674d-02, 2.2370785956753d-02,
     |  -2.5968364116050d-03,-2.7016766758675d-02,-3.6975977160565d-02,
     |  -2.4666471178802d-02, 3.9871488690054d-03, 3.0573564934082d-02,
     |   3.5903924285198d-02, 1.4821001709387d-02,-1.7892717606685d-02,
     |  -3.7213033289177d-02,-2.7307895231488d-02, 4.7132002649097d-03,
     |   3.3231012966104d-02, 3.4607296088085d-02, 7.2254705629799d-03,
     |  -2.6355735920065d-02,-3.7933418058283d-02,-1.7592868913988d-02,
     |   1.7592868913988d-02, 3.7933418058283d-02, 2.6355735920065d-02,
     |  -7.2254705629797d-03,-3.4607296088085d-02,-3.3231012966104d-02,
     |  -4.7132002649098d-03, 2.7307895231488d-02, 3.7213033289177d-02,
     |   1.7892717606685d-02,-1.4821001709387d-02,-3.5903924285198d-02,
     |  -3.0573564934083d-02,-3.9871488690053d-03, 2.4666471178802d-02,
     |   3.6975977160565d-02, 2.7016766758675d-02, 2.5968364116051d-03,
     |  -2.2370785956753d-02,-3.7161438543674d-02,-3.8924298299368d-02,
     |  -3.1422582428267d-02,-2.0698593112440d-02,-1.1345749444377d-02,
     |  -5.1913686943204d-03,-1.9682754101822d-03,-6.0819285520301d-04,
     |  -1.4909335964114d-04,-2.7842596212498d-05,-3.7270360791436d-06,
     |  -3.2558793606808d-07,-1.5932506921007d-08,-3.3306607390970d-10,
     |  -1.6997633440534d-12,-1.6002204971831d-14, 1.6584993830945d-14/
      data (zmn(lat,16,26), lat = 1,72)/
     |  -1.9736298178063d-16, 4.7310715406753d-16, 1.2587744678436d-13,
     |   3.4760986907423d-11, 2.1629790666689d-09, 5.4838174478263d-08,
     |   7.5579332070600d-07, 6.6639956447728d-06, 4.1561898643708d-05,
     |   1.9579609178967d-04, 7.2844334628155d-04, 2.2068089153875d-03,
     |   5.5575437805157d-03, 1.1783428929985d-02, 2.1145541209185d-02,
     |   3.2004134194396d-02, 4.0156441033320d-02, 3.9848122052098d-02,
     |   2.6948606406713d-02, 2.9844668267825d-03,-2.3018555564328d-02,
     |  -3.7716359644395d-02,-3.1367229038442d-02,-5.8266155968838d-03,
     |   2.3974736115710d-02, 3.8272589753862d-02, 2.6232186961192d-02,
     |  -4.7597874040002d-03,-3.2688134075127d-02,-3.6509402123678d-02,
     |  -1.2620461062914d-02, 2.1197303193941d-02, 3.8763460268282d-02,
     |   2.6029297102806d-02,-7.2792690805258d-03,-3.4908010303905d-02,
     |  -3.4908010303905d-02,-7.2792690805259d-03, 2.6029297102806d-02,
     |   3.8763460268282d-02, 2.1197303193941d-02,-1.2620461062914d-02,
     |  -3.6509402123678d-02,-3.2688134075127d-02,-4.7597874040002d-03,
     |   2.6232186961191d-02, 3.8272589753862d-02, 2.3974736115710d-02,
     |  -5.8266155968838d-03,-3.1367229038442d-02,-3.7716359644395d-02,
     |  -2.3018555564328d-02, 2.9844668267824d-03, 2.6948606406713d-02,
     |   3.9848122052098d-02, 4.0156441033320d-02, 3.2004134194396d-02,
     |   2.1145541209185d-02, 1.1783428929985d-02, 5.5575437805157d-03,
     |   2.2068089153875d-03, 7.2844334628163d-04, 1.9579609178973d-04,
     |   4.1561898643649d-05, 6.6639956447797d-06, 7.5579332079404d-07,
     |   5.4838174501414d-08, 2.1629791338879d-09, 3.4760981690719d-11,
     |   1.2585625200527d-13, 5.3244537544143d-16,-2.0256845323303d-16/
      data (zmn(lat,17,26), lat = 1,72)/
     |   3.3369982405001d-16,-4.9356634283542d-16, 8.6827490097033d-15,
     |   3.2879619402218d-12, 2.6584284020657d-10, 8.3484224416241d-09,
     |   1.3824441379081d-07, 1.4348661999324d-06, 1.0387488621264d-05,
     |   5.6266407531737d-05, 2.3928440897549d-04, 8.2633114252525d-04,
     |   2.3729200747062d-03, 5.7592007943500d-03, 1.1932680597268d-02,
     |   2.1189571833000d-02, 3.2142149581558d-02, 4.1047867899994d-02,
     |   4.2502113839772d-02, 3.2042972450990d-02, 9.8179572710653d-03,
     |  -1.7108394964718d-02,-3.6476158060930d-02,-3.7146949377193d-02,
     |  -1.6918520095945d-02, 1.3763264448197d-02, 3.6358573130267d-02,
     |   3.5716469191910d-02, 1.1182483666582d-02,-2.1307178084365d-02,
     |  -3.9210979590043d-02,-2.9365243474738d-02, 1.7175052413496d-03,
     |   3.1717909181978d-02, 3.8583305090360d-02, 1.7060310486502d-02,
     |  -1.7060310486502d-02,-3.8583305090360d-02,-3.1717909181978d-02,
     |  -1.7175052413497d-03, 2.9365243474738d-02, 3.9210979590043d-02,
     |   2.1307178084366d-02,-1.1182483666581d-02,-3.5716469191910d-02,
     |  -3.6358573130267d-02,-1.3763264448197d-02, 1.6918520095945d-02,
     |   3.7146949377193d-02, 3.6476158060930d-02, 1.7108394964718d-02,
     |  -9.8179572710649d-03,-3.2042972450990d-02,-4.2502113839772d-02,
     |  -4.1047867899994d-02,-3.2142149581558d-02,-2.1189571833000d-02,
     |  -1.1932680597268d-02,-5.7592007943499d-03,-2.3729200747063d-03,
     |  -8.2633114252527d-04,-2.3928440897551d-04,-5.6266407531641d-05,
     |  -1.0387488621257d-05,-1.4348661999368d-06,-1.3824441382813d-07,
     |  -8.3484223878856d-09,-2.6584282952728d-10,-3.2879328473082d-12,
     |  -8.6586333317426d-15, 5.5423036018876d-16,-3.4590243145157d-16/
      data (zmn(lat,18,26), lat = 1,72)/
     |  -2.2235510924734d-17,-5.8083227568915d-17, 4.3600817040231d-16,
     |   2.8140047627264d-13, 2.9540311207330d-11, 1.1475423584993d-09,
     |   2.2792718855495d-08, 2.7788033402860d-07, 2.3287297650261d-06,
     |   1.4454480530527d-05, 6.9959870202623d-05, 2.7384923284478d-04,
     |   8.9004450912909d-04, 2.4476802690983d-03, 5.7707715056653d-03,
     |   1.1759171851168d-02, 2.0775921620446d-02, 3.1738253452644d-02,
     |   4.1434551914311d-02, 4.4902300031272d-02, 3.7449428416354d-02,
     |   1.7869254626125d-02,-8.9560598812877d-03,-3.2441700231151d-02,
     |  -4.0841345829010d-02,-2.8285252704876d-02,-1.2529938430538d-06,
     |   2.8690804999940d-02, 4.0548129709301d-02, 2.7433456426289d-02,
     |  -3.2423515844740d-03,-3.2068464086629d-02,-3.9941627064751d-02,
     |  -2.1188710176300d-02, 1.1906088655585d-02, 3.7011756587528d-02,
     |   3.7011756587528d-02, 1.1906088655585d-02,-2.1188710176300d-02,
     |  -3.9941627064751d-02,-3.2068464086629d-02,-3.2423515844739d-03,
     |   2.7433456426289d-02, 4.0548129709301d-02, 2.8690804999940d-02,
     |  -1.2529938429779d-06,-2.8285252704876d-02,-4.0841345829010d-02,
     |  -3.2441700231151d-02,-8.9560598812876d-03, 1.7869254626125d-02,
     |   3.7449428416354d-02, 4.4902300031272d-02, 4.1434551914311d-02,
     |   3.1738253452644d-02, 2.0775921620446d-02, 1.1759171851168d-02,
     |   5.7707715056653d-03, 2.4476802690983d-03, 8.9004450912919d-04,
     |   2.7384923284482d-04, 6.9959870202688d-05, 1.4454480530469d-05,
     |   2.3287297650120d-06, 2.7788033403169d-07, 2.2792718803239d-08,
     |   1.1475423181997d-09, 2.9540340968130d-11, 2.8140245603284d-13,
     |   5.0685965157460d-16,-1.1760945333877d-16,-1.2451354436676d-17/
      data (zmn(lat,19,26), lat = 1,72)/
     |  -4.9965339448825d-17,-1.0058917233590d-16,-1.0630979201475d-16,
     |   2.1649401113475d-14, 2.9588101020110d-12, 1.4202630385678d-10,
     |   3.3788319616694d-09, 4.8301131536886d-08, 4.6754580893607d-07,
     |   3.3163669753446d-06, 1.8205515515698d-05, 8.0428445672951d-05,
     |   2.9421900716615d-04, 9.1015608289167d-04, 2.4178178283176d-03,
     |   5.5756924186342d-03, 1.1238399312926d-02, 1.9854327483463d-02,
     |   3.0682366437402d-02, 4.1108042604784d-02, 4.6730742556178d-02,
     |   4.2803263621557d-02, 2.6902205267345d-02, 1.6082874322920d-03,
     |  -2.4768727736249d-02,-4.0900912550327d-02,-3.8134239281914d-02,
     |  -1.6290367101351d-02, 1.4387512500673d-02, 3.7518734257707d-02,
     |   3.9619454746126d-02, 1.8695578370492d-02,-1.3465593906399d-02,
     |  -3.7668941098056d-02,-3.8985870859782d-02,-1.6360692463010d-02,
     |   1.6360692463010d-02, 3.8985870859782d-02, 3.7668941098056d-02,
     |   1.3465593906399d-02,-1.8695578370491d-02,-3.9619454746126d-02,
     |  -3.7518734257708d-02,-1.4387512500673d-02, 1.6290367101351d-02,
     |   3.8134239281914d-02, 4.0900912550327d-02, 2.4768727736249d-02,
     |  -1.6082874322919d-03,-2.6902205267345d-02,-4.2803263621557d-02,
     |  -4.6730742556178d-02,-4.1108042604785d-02,-3.0682366437402d-02,
     |  -1.9854327483464d-02,-1.1238399312926d-02,-5.5756924186342d-03,
     |  -2.4178178283176d-03,-9.1015608289170d-04,-2.9421900716613d-04,
     |  -8.0428445672948d-05,-1.8205515515703d-05,-3.3163669753705d-06,
     |  -4.6754580901038d-07,-4.8301131576791d-08,-3.3788319679853d-09,
     |  -1.4202629737363d-10,-2.9588271884565d-12,-2.1635313062461d-14,
     |   1.2285650283159d-16, 9.5422172555956d-17, 9.3983644924352d-17/
      data (zmn(lat,20,26), lat = 1,72)/
     |   3.4690105478450d-17,-2.5585707365514d-18,-5.5911632727936d-17,
     |   1.4073867386333d-15, 2.6569124611255d-13, 1.5750258567969d-11,
     |   4.4827244178333d-10, 7.5027523685239d-09, 8.3734247190180d-08,
     |   6.7721403963368d-07, 4.2049909117393d-06, 2.0894625873222d-05,
     |   8.5664454237496d-05, 2.9647401868226d-04, 8.8115894937897d-04,
     |   2.2780315490104d-03, 5.1699959602748d-03, 1.0361631030752d-02,
     |   1.8388494781475d-02, 2.8865262610033d-02, 3.9825983645105d-02,
     |   4.7567679098042d-02, 4.7535691414636d-02, 3.6369281783572d-02,
     |   1.4408074737653d-02,-1.2805628362741d-02,-3.5531834096532d-02,
     |  -4.3751850478414d-02,-3.2531582520105d-02,-5.8489756181762d-03,
     |   2.3958639442805d-02, 4.1783050332245d-02, 3.7843764267734d-02,
     |   1.3667891771005d-02,-1.8000218351147d-02,-3.9890776164538d-02,
     |  -3.9890776164538d-02,-1.8000218351147d-02, 1.3667891771005d-02,
     |   3.7843764267734d-02, 4.1783050332245d-02, 2.3958639442805d-02,
     |  -5.8489756181761d-03,-3.2531582520104d-02,-4.3751850478414d-02,
     |  -3.5531834096532d-02,-1.2805628362741d-02, 1.4408074737653d-02,
     |   3.6369281783572d-02, 4.7535691414636d-02, 4.7567679098042d-02,
     |   3.9825983645105d-02, 2.8865262610033d-02, 1.8388494781475d-02,
     |   1.0361631030752d-02, 5.1699959602749d-03, 2.2780315490104d-03,
     |   8.8115894937904d-04, 2.9647401868238d-04, 8.5664454237457d-05,
     |   2.0894625873251d-05, 4.2049909117391d-06, 6.7721403970882d-07,
     |   8.3734247202509d-08, 7.5027523753026d-09, 4.4827243824974d-10,
     |   1.5750271183228d-11, 2.6566768928024d-13, 1.4166061791426d-15,
     |  -5.1347408609682d-17,-1.0167986669296d-17, 2.8952063892157d-17/
      data (zmn(lat,21,26), lat = 1,72)/
     |  -2.4545165906407d-17,-6.9826826774590d-17,-9.9945347525418d-17,
     |  -2.6569883399336d-17, 2.1136415061730d-14, 1.5530317802367d-12,
     |   5.2829266717679d-11, 1.0339521595911d-09, 1.3284267475699d-08,
     |   1.2227589776688d-07, 8.5684212846580d-07, 4.7757269864346d-06,
     |   2.1869701099814d-05, 8.4322883082494d-05, 2.7891486791391d-04,
     |   8.0287214622142d-04, 2.0332548816451d-03, 4.5663984746197d-03,
     |   9.1438163002842d-03, 1.6370579904578d-02, 2.6201383617650d-02,
     |   3.7340016648836d-02, 4.6909861256067d-02, 5.0850028794767d-02,
     |   4.5295485471592d-02, 2.8663329461685d-02, 3.5085879760024d-03,
     |  -2.3119735406740d-02,-4.1678084209443d-02,-4.4152255549199d-02,
     |  -2.8371590698468d-02,-1.8064475548835d-04, 2.8263206163934d-02,
     |   4.3817448424149d-02, 3.8848936114619d-02, 1.5409251557241d-02,
     |  -1.5409251557241d-02,-3.8848936114619d-02,-4.3817448424149d-02,
     |  -2.8263206163934d-02, 1.8064475548828d-04, 2.8371590698468d-02,
     |   4.4152255549199d-02, 4.1678084209443d-02, 2.3119735406740d-02,
     |  -3.5085879760023d-03,-2.8663329461685d-02,-4.5295485471592d-02,
     |  -5.0850028794767d-02,-4.6909861256067d-02,-3.7340016648836d-02,
     |  -2.6201383617650d-02,-1.6370579904578d-02,-9.1438163002842d-03,
     |  -4.5663984746198d-03,-2.0332548816450d-03,-8.0287214622143d-04,
     |  -2.7891486791392d-04,-8.4322883082474d-05,-2.1869701099820d-05,
     |  -4.7757269864230d-06,-8.5684212846442d-07,-1.2227589782680d-07,
     |  -1.3284267515749d-08,-1.0339521591833d-09,-5.2829333188963d-11,
     |  -1.5530913675297d-12,-2.1137680889651d-14, 1.4881708397410d-17,
     |   1.1601665223958d-16, 2.6867437182696d-17, 3.4735021232037d-17/
      data (zmn(lat,22,26), lat = 1,72)/
     |   4.7905212882091d-17, 1.9941132679704d-17,-4.9360982189930d-17,
     |  -1.0667795361968d-16, 1.3510905865755d-15, 1.3445620455019d-13,
     |   5.4667346020261d-12, 1.2498180075374d-10, 1.8462021279986d-09,
     |   1.9310262949436d-08, 1.5242518822917d-07, 9.5079151167094d-07,
     |   4.8499803148538d-06, 2.0764054131330d-05, 7.6122457865695d-05,
     |   2.4273145155690d-04, 6.8146972587471d-04, 1.7004819661312d-03,
     |   3.7983157871368d-03, 7.6328477865760d-03, 1.3840688040087d-02,
     |   2.2664299432020d-02, 3.3449344674247d-02, 4.4231484397494d-02,
     |   5.1752440506963d-02, 5.2202718703325d-02, 4.2701010986391d-02,
     |   2.3051094868763d-02,-3.0925491451954d-03,-2.8549423756207d-02,
     |  -4.4792233935727d-02,-4.5389163397023d-02,-2.9228093850795d-02,
     |  -1.8056951168361d-03, 2.6414999173204d-02, 4.4152123081898d-02,
     |   4.4152123081898d-02, 2.6414999173205d-02,-1.8056951168360d-03,
     |  -2.9228093850795d-02,-4.5389163397023d-02,-4.4792233935727d-02,
     |  -2.8549423756207d-02,-3.0925491451956d-03, 2.3051094868763d-02,
     |   4.2701010986391d-02, 5.2202718703325d-02, 5.1752440506963d-02,
     |   4.4231484397494d-02, 3.3449344674247d-02, 2.2664299432020d-02,
     |   1.3840688040087d-02, 7.6328477865761d-03, 3.7983157871368d-03,
     |   1.7004819661313d-03, 6.8146972587470d-04, 2.4273145155689d-04,
     |   7.6122457865677d-05, 2.0764054131259d-05, 4.8499803148839d-06,
     |   9.5079151166302d-07, 1.5242518814945d-07, 1.9310262901818d-08,
     |   1.8462021636386d-09, 1.2498180506165d-10, 5.4667535174845d-12,
     |   1.3444731587335d-13, 1.2507650370329d-15,-9.1317688722827d-17,
     |  -1.5500038348359d-16, 3.3617347538698d-17, 5.7438535417048d-17/
      data (zmn(lat,23,26), lat = 1,72)/
     |  -2.5897867519455d-17,-6.6430822764861d-17,-1.0564001836092d-16,
     |  -1.3766814736141d-16,-6.7409020435370d-17, 9.9134566310647d-15,
     |   4.8767670033727d-13, 1.3014477368004d-11, 2.2078915294776d-10,
     |   2.6207148930011d-09, 2.3265561516784d-08, 1.6211250672828d-07,
     |   9.1906686405029d-07, 4.3572891081357d-06, 1.7647035340093d-05,
     |   6.2085107108031d-05, 1.9227940705276d-04, 5.2977935796332d-04,
     |   1.3094889887833d-03, 2.9226065887374d-03, 5.9183056387975d-03,
     |   1.0909259486405d-02, 1.8334400509544d-02, 2.8086355750648d-02,
     |   3.9110660395724d-02, 4.9190358243548d-02, 5.5168324814679d-02,
     |   5.3756353183797d-02, 4.2820273510318d-02, 2.2704448735934d-02,
     |  -3.0525116458493d-03,-2.8175283217696d-02,-4.5413685662016d-02,
     |  -4.9108446164407d-02,-3.7547613403711d-02,-1.4023526965025d-02,
     |   1.4023526965025d-02, 3.7547613403711d-02, 4.9108446164406d-02,
     |   4.5413685662016d-02, 2.8175283217696d-02, 3.0525116458493d-03,
     |  -2.2704448735933d-02,-4.2820273510318d-02,-5.3756353183797d-02,
     |  -5.5168324814679d-02,-4.9190358243548d-02,-3.9110660395724d-02,
     |  -2.8086355750648d-02,-1.8334400509544d-02,-1.0909259486405d-02,
     |  -5.9183056387976d-03,-2.9226065887375d-03,-1.3094889887833d-03,
     |  -5.2977935796329d-04,-1.9227940705281d-04,-6.2085107108028d-05,
     |  -1.7647035340049d-05,-4.3572891081305d-06,-9.1906686401025d-07,
     |  -1.6211250672560d-07,-2.3265561498520d-08,-2.6207148667181d-09,
     |  -2.2078911159819d-10,-1.3014467988008d-11,-4.8761413846331d-13,
     |  -9.8871816513569d-15, 8.5755657466613d-17, 1.1941048145554d-16,
     |   6.9046743576278d-17, 7.2601194393256d-17,-2.1829562868253d-17/
      data (zmn(lat,24,26), lat = 1,72)/
     |   1.8276777111433d-16, 1.4525111744470d-16, 6.8215582130947d-17,
     |  -2.2834313596284d-17,-9.2024085536743d-17, 4.8266079149841d-16,
     |   3.6226711655270d-14, 1.1325961085470d-12, 2.2049638855870d-11,
     |   2.9668074325101d-10, 2.9581975891973d-09, 2.2988831496574d-08,
     |   1.4458032985927d-07, 7.5737125843285d-07, 3.3796003631958d-06,
     |   1.3076676827988d-05, 4.4502770526395d-05, 1.3474891170427d-04,
     |   3.6640094435681d-04, 9.0147441607727d-04, 2.0190099069949d-03,
     |   4.1358661063048d-03, 7.7762557511987d-03, 1.3451560296910d-02,
     |   2.1431452325731d-02, 3.1437563454151d-02, 4.2361431940234d-02,
     |   5.2166046961974d-02, 5.8128824889655d-02, 5.7490187664908d-02,
     |   4.8396349799246d-02, 3.0834611452890d-02, 7.1574837302237d-03,
     |  -1.8136001486584d-02,-3.9438092572757d-02,-5.1619360282461d-02,
     |  -5.1619360282461d-02,-3.9438092572757d-02,-1.8136001486584d-02,
     |   7.1574837302236d-03, 3.0834611452890d-02, 4.8396349799246d-02,
     |   5.7490187664908d-02, 5.8128824889655d-02, 5.2166046961974d-02,
     |   4.2361431940234d-02, 3.1437563454152d-02, 2.1431452325731d-02,
     |   1.3451560296910d-02, 7.7762557511987d-03, 4.1358661063048d-03,
     |   2.0190099069949d-03, 9.0147441607729d-04, 3.6640094435681d-04,
     |   1.3474891170429d-04, 4.4502770526383d-05, 1.3076676828036d-05,
     |   3.3796003632077d-06, 7.5737125844878d-07, 1.4458032984659d-07,
     |   2.2988831479698d-08, 2.9581976522728d-09, 2.9668075613637d-10,
     |   2.2049589384947d-11, 1.1325977312883d-12, 3.6198900786198d-14,
     |   4.6941700268465d-16,-7.6552306865259d-17,-4.4862002963444d-17,
     |   9.5990162669069d-17, 1.3096835077183d-16, 1.9197871092705d-16/
      data (zmn(lat,25,26), lat = 1,72)/
     |  -1.4497365762396d-17,-5.6729132640290d-17,-9.5770429947935d-17,
     |  -1.1962523381912d-16,-1.4394182779299d-16,-1.3886129520915d-16,
     |   1.9616373585870d-15, 7.7665700883140d-14, 1.7370942014785d-12,
     |   2.6470711246200d-11, 2.9610765968583d-10, 2.5629483126304d-09,
     |   1.7852774410306d-08, 1.0313992979056d-07, 5.0597715453963d-07,
     |   2.1475818901005d-06, 8.0063982493955d-06, 2.6541980317445d-05,
     |   7.9036100867643d-05, 2.1317621619470d-04, 5.2441580561227d-04,
     |   1.1833692648962d-03, 2.4610030943261d-03, 4.7347808316615d-03,
     |   8.4522624569497d-03, 1.4030545156523d-02, 2.1686570588319d-02,
     |   3.1225550192812d-02, 4.1853596099918d-02, 5.2107285270403d-02,
     |   5.9985715469524d-02, 6.3317741518543d-02, 6.0307966691478d-02,
     |   5.0112837166156d-02, 3.3247850478512d-02, 1.1652866402711d-02,
     |  -1.1652866402711d-02,-3.3247850478512d-02,-5.0112837166156d-02,
     |  -6.0307966691478d-02,-6.3317741518543d-02,-5.9985715469524d-02,
     |  -5.2107285270403d-02,-4.1853596099919d-02,-3.1225550192812d-02,
     |  -2.1686570588320d-02,-1.4030545156523d-02,-8.4522624569498d-03,
     |  -4.7347808316616d-03,-2.4610030943261d-03,-1.1833692648962d-03,
     |  -5.2441580561229d-04,-2.1317621619470d-04,-7.9036100867623d-05,
     |  -2.6541980317447d-05,-8.0063982493889d-06,-2.1475818900758d-06,
     |  -5.0597715455817d-07,-1.0313992979506d-07,-1.7852774449601d-08,
     |  -2.5629483189643d-09,-2.9610769372838d-10,-2.6470702276689d-11,
     |  -1.7370885713667d-12,-7.7662899738120d-14,-1.9766303922833d-15,
     |   1.4375287370410d-16, 1.2904690492385d-16, 1.3524226108748d-16,
     |   7.5034658212515d-17, 4.5250056261525d-17, 9.3051588202264d-18/
      data (zmn(lat,26,26), lat = 1,72)/
     |  -2.6172079236811d-16,-2.6591453762319d-16,-2.7633102853548d-16,
     |  -2.7601218272165d-16,-2.7536707024673d-16,-2.8188717460197d-16,
     |  -1.8945801324889d-16, 3.4165255583901d-15, 9.3470422635927d-14,
     |   1.6150529335805d-12, 2.0249809100375d-11, 1.9498839252858d-10,
     |   1.5023124982334d-09, 9.5569155635398d-09, 5.1448138096160d-08,
     |   2.3902262955786d-07, 9.7369615390721d-07, 3.5235136933432d-06,
     |   1.1449315481846d-05, 3.3709253880932d-05, 9.0611462972306d-05,
     |   2.2380933077320d-04, 5.1076120286677d-04, 1.0820366607501d-03,
     |   2.1364888323665d-03, 3.9454619979465d-03, 6.8348051445560d-03,
     |   1.1135102925699d-02, 1.7098178446113d-02, 2.4791215443678d-02,
     |   3.3994993697724d-02, 4.4143011452170d-02, 5.4336649424040d-02,
     |   6.3454519822466d-02, 7.0344884113333d-02, 7.4058481735287d-02,
     |   7.4058481735287d-02, 7.0344884113333d-02, 6.3454519822466d-02,
     |   5.4336649424040d-02, 4.4143011452170d-02, 3.3994993697724d-02,
     |   2.4791215443678d-02, 1.7098178446113d-02, 1.1135102925699d-02,
     |   6.8348051445560d-03, 3.9454619979465d-03, 2.1364888323666d-03,
     |   1.0820366607501d-03, 5.1076120286676d-04, 2.2380933077318d-04,
     |   9.0611462972288d-05, 3.3709253880918d-05, 1.1449315481850d-05,
     |   3.5235136933401d-06, 9.7369615392089d-07, 2.3902262953991d-07,
     |   5.1448138098013d-08, 9.5569155691079d-09, 1.5023125070234d-09,
     |   1.9498839235762d-10, 2.0249796666303d-11, 1.6150529658947d-12,
     |   9.3498376198841d-14, 3.4210963334969d-15,-1.6698237073419d-16,
     |  -2.7002095812279d-16,-2.6764317492882d-16,-2.8081717372590d-16,
     |  -2.8304711573156d-16,-2.7587560257182d-16,-2.7886684600986d-16/
      data (zmn(lat, 0,27), lat = 1,72)/
     |   3.8524136717663d-03, 5.5146571256818d-03,-6.7747110638541d-03,
     |  -1.2914349079877d-02,-2.0216262331560d-03, 1.5120552801858d-02,
     |   1.3762551748352d-02,-6.5922194541410d-03,-2.1037820994589d-02,
     |  -8.3505791496601d-03, 1.6665762668415d-02, 2.1921337010543d-02,
     |  -1.7936802708076d-03,-2.4709954647345d-02,-1.6713870999476d-02,
     |   1.3950615241879d-02, 2.7856006759601d-02, 6.1419118048825d-03,
     |  -2.4755257954426d-02,-2.4556388952447d-02, 7.4777978330410d-03,
     |   3.1066709381339d-02, 1.5005006538708d-02,-2.0847609216855d-02,
     |  -3.0815886301782d-02,-1.1127937814276d-03, 3.0563176437791d-02,
     |   2.3583443810248d-02,-1.3970326629756d-02,-3.4023387606356d-02,
     |  -1.0746011152320d-02, 2.6666204588511d-02, 3.0134399098866d-02,
     |  -4.8524852737741d-03,-3.3898996758047d-02,-1.9619690475814d-02,
     |   1.9619690475814d-02, 3.3898996758047d-02, 4.8524852737744d-03,
     |  -3.0134399098866d-02,-2.6666204588511d-02, 1.0746011152320d-02,
     |   3.4023387606356d-02, 1.3970326629756d-02,-2.3583443810248d-02,
     |  -3.0563176437791d-02, 1.1127937814274d-03, 3.0815886301782d-02,
     |   2.0847609216855d-02,-1.5005006538708d-02,-3.1066709381339d-02,
     |  -7.4777978330414d-03, 2.4556388952446d-02, 2.4755257954426d-02,
     |  -6.1419118048824d-03,-2.7856006759601d-02,-1.3950615241879d-02,
     |   1.6713870999476d-02, 2.4709954647345d-02, 1.7936802708078d-03,
     |  -2.1921337010543d-02,-1.6665762668415d-02, 8.3505791496600d-03,
     |   2.1037820994589d-02, 6.5922194541411d-03,-1.3762551748352d-02,
     |  -1.5120552801858d-02, 2.0216262331559d-03, 1.2914349079877d-02,
     |   6.7747110638542d-03,-5.5146571256819d-03,-3.8524136717663d-03/
      data (zmn(lat, 1,27), lat = 1,72)/
     |   1.6652110630759d-03, 8.6218158842178d-03, 8.5017206576079d-03,
     |  -4.8469360126620d-03,-1.5451914664563d-02,-6.8654888131501d-03,
     |   1.2964533086327d-02, 1.8217935366482d-02,-4.9964660072295d-04,
     |  -2.0782720485995d-02,-1.5371770712654d-02, 1.0988010655054d-02,
     |   2.4978022773226d-02, 7.0291283565606d-03,-2.1376723600786d-02,
     |  -2.3476300958771d-02, 5.0415518835716d-03, 2.8426648406944d-02,
     |   1.5853460866102d-02,-1.7883782955910d-02,-2.9708457419586d-02,
     |  -3.4340160549678d-03, 2.8142640885563d-02, 2.4265241036476d-02,
     |  -1.1047105477353d-02,-3.2969667314916d-02,-1.2900699705314d-02,
     |   2.4154474526294d-02, 3.0801878357160d-02,-1.9956261923962d-03,
     |  -3.2653084983238d-02,-2.1806141019176d-02, 1.7045224598606d-02,
     |   3.4363427561772d-02, 7.8687699771705d-03,-2.8743880554402d-02,
     |  -2.8743880554402d-02, 7.8687699771705d-03, 3.4363427561772d-02,
     |   1.7045224598606d-02,-2.1806141019176d-02,-3.2653084983238d-02,
     |  -1.9956261923964d-03, 3.0801878357160d-02, 2.4154474526294d-02,
     |  -1.2900699705313d-02,-3.2969667314916d-02,-1.1047105477354d-02,
     |   2.4265241036476d-02, 2.8142640885563d-02,-3.4340160549677d-03,
     |  -2.9708457419586d-02,-1.7883782955910d-02, 1.5853460866102d-02,
     |   2.8426648406944d-02, 5.0415518835717d-03,-2.3476300958770d-02,
     |  -2.1376723600786d-02, 7.0291283565605d-03, 2.4978022773226d-02,
     |   1.0988010655054d-02,-1.5371770712654d-02,-2.0782720485995d-02,
     |  -4.9964660072309d-04, 1.8217935366482d-02, 1.2964533086327d-02,
     |  -6.8654888131500d-03,-1.5451914664564d-02,-4.8469360126621d-03,
     |   8.5017206576078d-03, 8.6218158842179d-03, 1.6652110630759d-03/
      data (zmn(lat, 2,27), lat = 1,72)/
     |   2.5062960191860d-04, 4.5428525829740d-03, 1.2147205620418d-02,
     |   1.0845776303756d-02,-3.7958959786658d-03,-1.7051026761570d-02,
     |  -1.0654177422901d-02, 1.0608355175540d-02, 2.0884826626798d-02,
     |   5.0000056410202d-03,-1.9029738317621d-02,-2.0425821938783d-02,
     |   4.7331693956006d-03, 2.5565873258026d-02, 1.4559051672079d-02,
     |  -1.6049064500511d-02,-2.7522195244334d-02,-3.9414523136043d-03,
     |   2.5849651498819d-02, 2.3488687668217d-02,-9.2649401228640d-03,
     |  -3.1252046555907d-02,-1.3693320722383d-02, 2.1984718962173d-02,
     |   3.0379209613196d-02,-3.4678251789339d-05,-3.1051698630207d-02,
     |  -2.2896596043283d-02, 1.4716987951902d-02, 3.4059070831845d-02,
     |   1.0145712238410d-02,-2.6985214160924d-02,-3.0015265130767d-02,
     |   5.1648554272054d-03, 3.3949783577996d-02, 1.9631658644005d-02,
     |  -1.9631658644004d-02,-3.3949783577996d-02,-5.1648554272057d-03,
     |   3.0015265130767d-02, 2.6985214160924d-02,-1.0145712238410d-02,
     |  -3.4059070831845d-02,-1.4716987951902d-02, 2.2896596043283d-02,
     |   3.1051698630207d-02, 3.4678251789482d-05,-3.0379209613196d-02,
     |  -2.1984718962173d-02, 1.3693320722383d-02, 3.1252046555907d-02,
     |   9.2649401228643d-03,-2.3488687668217d-02,-2.5849651498819d-02,
     |   3.9414523136043d-03, 2.7522195244334d-02, 1.6049064500511d-02,
     |  -1.4559051672079d-02,-2.5565873258026d-02,-4.7331693956008d-03,
     |   2.0425821938783d-02, 1.9029738317621d-02,-5.0000056410201d-03,
     |  -2.0884826626798d-02,-1.0608355175540d-02, 1.0654177422901d-02,
     |   1.7051026761570d-02, 3.7958959786660d-03,-1.0845776303756d-02,
     |  -1.2147205620418d-02,-4.5428525829739d-03,-2.5062960191855d-04/
      data (zmn(lat, 3,27), lat = 1,72)/
     |   8.0200072951787d-06, 1.4786750225680d-03, 7.6758609551176d-03,
     |   1.5152082519563d-02, 1.2705776777099d-02,-3.2939051563375d-03,
     |  -1.8337941275322d-02,-1.3701921043414d-02, 8.3451299705632d-03,
     |   2.2497794850904d-02, 9.7764975865475d-03,-1.6455260815447d-02,
     |  -2.3905276161373d-02,-1.4593201182555d-03, 2.4333812819044d-02,
     |   2.0618113289793d-02,-9.6387658292820d-03,-2.9103721395735d-02,
     |  -1.2281345865544d-02, 2.0940089980595d-02, 2.8701491825822d-02,
     |   9.6218785714470d-05,-2.9553970467571d-02,-2.2381334924898d-02,
     |   1.3510838738939d-02, 3.3054971691386d-02, 1.0939436076376d-02,
     |  -2.5519313132569d-02,-3.0154232323232d-02, 3.4509177795146d-03,
     |   3.3102656865185d-02, 2.1080211682645d-02,-1.7765381774535d-02,
     |  -3.4372323967113d-02,-7.5647161873203d-03, 2.8882995586621d-02,
     |   2.8882995586621d-02,-7.5647161873203d-03,-3.4372323967113d-02,
     |  -1.7765381774536d-02, 2.1080211682645d-02, 3.3102656865185d-02,
     |   3.4509177795148d-03,-3.0154232323232d-02,-2.5519313132569d-02,
     |   1.0939436076376d-02, 3.3054971691386d-02, 1.3510838738939d-02,
     |  -2.2381334924898d-02,-2.9553970467571d-02, 9.6218785714403d-05,
     |   2.8701491825822d-02, 2.0940089980595d-02,-1.2281345865544d-02,
     |  -2.9103721395735d-02,-9.6387658292821d-03, 2.0618113289793d-02,
     |   2.4333812819044d-02,-1.4593201182554d-03,-2.3905276161373d-02,
     |  -1.6455260815447d-02, 9.7764975865475d-03, 2.2497794850904d-02,
     |   8.3451299705633d-03,-1.3701921043414d-02,-1.8337941275322d-02,
     |  -3.2939051563376d-03, 1.2705776777099d-02, 1.5152082519563d-02,
     |   7.6758609551177d-03, 1.4786750225680d-03, 8.0200072951998d-06/
      data (zmn(lat, 4,27), lat = 1,72)/
     |   6.4802142188553d-07, 3.4427180562153d-04, 3.2555219891973d-03,
     |   1.0740932500761d-02, 1.7881243515726d-02, 1.4142865755096d-02,
     |  -3.1289563533445d-03,-1.9541698513771d-02,-1.6238098754622d-02,
     |   6.2177163598512d-03, 2.3475642022824d-02, 1.3902447491393d-02,
     |  -1.3410680758123d-02,-2.6155907865322d-02,-7.3111189515620d-03,
     |   2.1758640263870d-02, 2.5220944076160d-02,-2.7356749187591d-03,
     |  -2.8534655444501d-02,-1.9548650232110d-02, 1.4374127715343d-02,
     |   3.1388691423344d-02, 9.4090888862409d-03,-2.5065057284609d-02,
     |  -2.8866706147738d-02, 3.6163696440275d-03, 3.2239563133113d-02,
     |   2.0801752011746d-02,-1.7023878011650d-02,-3.3978767815012d-02,
     |  -8.4008904981069d-03, 2.8012356179925d-02, 2.9538357640490d-02,
     |  -6.0174554217127d-03,-3.4191720456714d-02,-1.9575768397390d-02,
     |   1.9575768397390d-02, 3.4191720456714d-02, 6.0174554217129d-03,
     |  -2.9538357640490d-02,-2.8012356179925d-02, 8.4008904981070d-03,
     |   3.3978767815012d-02, 1.7023878011650d-02,-2.0801752011746d-02,
     |  -3.2239563133113d-02,-3.6163696440276d-03, 2.8866706147738d-02,
     |   2.5065057284609d-02,-9.4090888862411d-03,-3.1388691423344d-02,
     |  -1.4374127715343d-02, 1.9548650232110d-02, 2.8534655444501d-02,
     |   2.7356749187591d-03,-2.5220944076160d-02,-2.1758640263870d-02,
     |   7.3111189515622d-03, 2.6155907865322d-02, 1.3410680758123d-02,
     |  -1.3902447491393d-02,-2.3475642022824d-02,-6.2177163598513d-03,
     |   1.6238098754622d-02, 1.9541698513771d-02, 3.1289563533442d-03,
     |  -1.4142865755095d-02,-1.7881243515726d-02,-1.0740932500761d-02,
     |  -3.2555219891973d-03,-3.4427180562173d-04,-6.4802142192813d-07/
      data (zmn(lat, 5,27), lat = 1,72)/
     |   6.9410428079719d-07, 6.2209617214276d-05, 1.0482422699505d-03,
     |   5.3442535047339d-03, 1.3733970107310d-02, 2.0355199861372d-02,
     |   1.5271766772667d-02,-3.1996866206986d-03,-2.0703593471920d-02,
     |  -1.8452779002300d-02, 4.2081350448391d-03, 2.4017048711286d-02,
     |   1.7517875771046d-02,-1.0076025286972d-02,-2.7406023738666d-02,
     |  -1.2735354969980d-02, 1.8171567874007d-02, 2.8418769670907d-02,
     |   4.2928659061321d-03,-2.6108990371680d-02,-2.5455140984950d-02,
     |   6.6900544512120d-03, 3.1568076822698d-02, 1.8017503747666d-02,
     |  -1.8254091397729d-02,-3.2708237908253d-02,-6.8155801872303d-03,
     |   2.8043052019091d-02, 2.8613587716121d-02,-6.3901251124242d-03,
     |  -3.3888264757876d-02,-1.9551374045804d-02, 1.9202328514884d-02,
     |   3.4364291222351d-02, 6.9448699082627d-03,-2.9165502260409d-02,
     |  -2.9165502260409d-02, 6.9448699082627d-03, 3.4364291222351d-02,
     |   1.9202328514884d-02,-1.9551374045804d-02,-3.3888264757876d-02,
     |  -6.3901251124244d-03, 2.8613587716120d-02, 2.8043052019092d-02,
     |  -6.8155801872302d-03,-3.2708237908253d-02,-1.8254091397729d-02,
     |   1.8017503747666d-02, 3.1568076822698d-02, 6.6900544512120d-03,
     |  -2.5455140984949d-02,-2.6108990371680d-02, 4.2928659061319d-03,
     |   2.8418769670907d-02, 1.8171567874007d-02,-1.2735354969980d-02,
     |  -2.7406023738666d-02,-1.0076025286972d-02, 1.7517875771046d-02,
     |   2.4017048711286d-02, 4.2081350448391d-03,-1.8452779002300d-02,
     |  -2.0703593471920d-02,-3.1996866206985d-03, 1.5271766772667d-02,
     |   2.0355199861372d-02, 1.3733970107310d-02, 5.3442535047338d-03,
     |   1.0482422699503d-03, 6.2209617214285d-05, 6.9410428079310d-07/
      data (zmn(lat, 6,27), lat = 1,72)/
     |   3.2886705135837d-08, 9.3316618178952d-06, 2.7219691906367d-04,
     |   2.0735487436761d-03, 7.6199106099452d-03, 1.6633873606979d-02,
     |   2.2595194935495d-02, 1.6178271013884d-02,-3.4100416185864d-03,
     |  -2.1824118192997d-02,-2.0470328057773d-02, 2.2499170064084d-03,
     |   2.4216386989955d-02, 2.0739212936837d-02,-6.5110544178713d-03,
     |  -2.7796731820160d-02,-1.7704242162958d-02, 1.3772545324312d-02,
     |   3.0255354985581d-02, 1.1185282421556d-02,-2.2055346544840d-02,
     |  -2.9783280379250d-02,-1.6455708602300d-03, 2.9295099411955d-02,
     |   2.5347812581263d-02,-9.6272941169707d-03,-3.3574110589156d-02,
     |  -1.6896910816075d-02, 2.0745299151352d-02, 3.3520975987117d-02,
     |   5.3806998624966d-03,-2.9647718620381d-02,-2.8644442828468d-02,
     |   7.4557668511907d-03, 3.4595089324704d-02, 1.9474181517848d-02,
     |  -1.9474181517848d-02,-3.4595089324704d-02,-7.4557668511909d-03,
     |   2.8644442828468d-02, 2.9647718620381d-02,-5.3806998624966d-03,
     |  -3.3520975987117d-02,-2.0745299151352d-02, 1.6896910816075d-02,
     |   3.3574110589156d-02, 9.6272941169708d-03,-2.5347812581263d-02,
     |  -2.9295099411955d-02, 1.6455708602301d-03, 2.9783280379250d-02,
     |   2.2055346544841d-02,-1.1185282421556d-02,-3.0255354985581d-02,
     |  -1.3772545324312d-02, 1.7704242162958d-02, 2.7796731820160d-02,
     |   6.5110544178712d-03,-2.0739212936837d-02,-2.4216386989955d-02,
     |  -2.2499170064083d-03, 2.0470328057773d-02, 2.1824118192997d-02,
     |   3.4100416185865d-03,-1.6178271013884d-02,-2.2595194935494d-02,
     |  -1.6633873606979d-02,-7.6199106099452d-03,-2.0735487436760d-03,
     |  -2.7219691906370d-04,-9.3316618177602d-06,-3.2886705139997d-08/
      data (zmn(lat, 7,27), lat = 1,72)/
     |  -2.3056895038970d-08, 1.2081889171636d-06, 5.9156298337249d-05,
     |   6.6117514588299d-04, 3.3547346945012d-03, 1.0002178044011d-02,
     |   1.9414061154278d-02, 2.4629873390459d-02, 1.6938830947120d-02,
     |  -3.6671894392218d-03,-2.2884896463799d-02,-2.2376293217079d-02,
     |   2.5747830550605d-04, 2.4099351568303d-02, 2.3647478042509d-02,
     |  -2.7118141688659d-03,-2.7389755541553d-02,-2.2195553620251d-02,
     |   8.6782567875384d-03, 3.0732693671059d-02, 1.7718710215231d-02,
     |  -1.6553240569124d-02,-3.2326038326308d-02,-1.0184963921380d-02,
     |   2.4652004129811d-02, 3.0849833034138d-02, 2.3824473073243d-04,
     |  -3.1228620235871d-02,-2.5690517427716d-02, 1.0831409265368d-02,
     |   3.4763145658585d-02, 1.7066576798794d-02,-2.1342963217662d-02,
     |  -3.4285164956490d-02,-5.9846864363315d-03, 2.9600399733023d-02,
     |   2.9600399733023d-02,-5.9846864363315d-03,-3.4285164956490d-02,
     |  -2.1342963217663d-02, 1.7066576798794d-02, 3.4763145658585d-02,
     |   1.0831409265368d-02,-2.5690517427716d-02,-3.1228620235871d-02,
     |   2.3824473073235d-04, 3.0849833034138d-02, 2.4652004129811d-02,
     |  -1.0184963921380d-02,-3.2326038326309d-02,-1.6553240569124d-02,
     |   1.7718710215230d-02, 3.0732693671059d-02, 8.6782567875385d-03,
     |  -2.2195553620251d-02,-2.7389755541553d-02,-2.7118141688661d-03,
     |   2.3647478042510d-02, 2.4099351568303d-02, 2.5747830550627d-04,
     |  -2.2376293217079d-02,-2.2884896463799d-02,-3.6671894392219d-03,
     |   1.6938830947120d-02, 2.4629873390459d-02, 1.9414061154278d-02,
     |   1.0002178044011d-02, 3.3547346945013d-03, 6.6117514588312d-04,
     |   5.9156298337442d-05, 1.2081889171402d-06,-2.3056895046597d-08/
      data (zmn(lat, 8,27), lat = 1,72)/
     |  -8.0171953204385d-10, 1.3221183084434d-07, 1.1034857369377d-05,
     |   1.7881701996944d-04, 1.2286593186831d-03, 4.8298531509487d-03,
     |   1.2424931640253d-02, 2.2054404061304d-02, 2.6492805536983d-02,
     |   1.7631138243461d-02,-3.8816890405464d-03,-2.3854569983882d-02,
     |  -2.4232802785984d-02,-1.8606181922828d-03, 2.3641537523088d-02,
     |   2.6285382822217d-02, 1.3539906183597d-03,-2.6178368012724d-02,
     |  -2.6160411659224d-02, 2.9649792926912d-03, 2.9799748014632d-02,
     |   2.3657147061121d-02,-9.7674565841966d-03,-3.2856969051552d-02,
     |  -1.8443500563680d-02, 1.7773279261322d-02, 3.3963674591123d-02,
     |   1.0638951412324d-02,-2.5566301582418d-02,-3.2183976387994d-02,
     |  -9.3301704088933d-04, 3.1739049447038d-02, 2.7191225620364d-02,
     |  -9.5168409757323d-03,-3.5146877548355d-02,-1.9326202979509d-02,
     |   1.9326202979509d-02, 3.5146877548355d-02, 9.5168409757324d-03,
     |  -2.7191225620364d-02,-3.1739049447038d-02, 9.3301704088936d-04,
     |   3.2183976387994d-02, 2.5566301582419d-02,-1.0638951412324d-02,
     |  -3.3963674591123d-02,-1.7773279261322d-02, 1.8443500563679d-02,
     |   3.2856969051552d-02, 9.7674565841965d-03,-2.3657147061121d-02,
     |  -2.9799748014632d-02,-2.9649792926913d-03, 2.6160411659224d-02,
     |   2.6178368012724d-02,-1.3539906183595d-03,-2.6285382822216d-02,
     |  -2.3641537523088d-02, 1.8606181922828d-03, 2.4232802785984d-02,
     |   2.3854569983882d-02, 3.8816890405465d-03,-1.7631138243461d-02,
     |  -2.6492805536983d-02,-2.2054404061304d-02,-1.2424931640254d-02,
     |  -4.8298531509488d-03,-1.2286593186832d-03,-1.7881701996960d-04,
     |  -1.1034857369326d-05,-1.3221183085317d-07, 8.0171955957245d-10/
      data (zmn(lat, 9,27), lat = 1,72)/
     |   8.4698519974279d-10, 1.1812221251979d-08, 1.7974139723909d-06,
     |   4.1892660931168d-05, 3.8512260438942d-04, 1.9567225273009d-03,
     |   6.4389491256865d-03, 1.4830873408857d-02, 2.4542086169329d-02,
     |   2.8223552078811d-02, 1.8335550139151d-02,-3.9641953124688d-03,
     |  -2.4691365598693d-02,-2.6083142763472d-02,-4.1969941222859d-03,
     |   2.2779544340971d-02, 2.8652790241706d-02, 5.7238717489778d-03,
     |  -2.4099948090241d-02,-2.9499314042122d-02,-3.2930252760292d-03,
     |   2.7357665126094d-02, 2.8709241300657d-02,-1.8942381417869d-03,
     |  -3.1128883211852d-02,-2.5846469056553d-02, 8.9015839295890d-03,
     |   3.4122830551659d-02, 2.0679907524810d-02,-1.6696285643087d-02,
     |  -3.5307054949287d-02,-1.3402717541208d-02, 2.4151504613089d-02,
     |   3.4046211948842d-02, 4.6449631905999d-03,-3.0202587176050d-02,
     |  -3.0202587176050d-02, 4.6449631905999d-03, 3.4046211948842d-02,
     |   2.4151504613089d-02,-1.3402717541208d-02,-3.5307054949287d-02,
     |  -1.6696285643087d-02, 2.0679907524810d-02, 3.4122830551659d-02,
     |   8.9015839295890d-03,-2.5846469056553d-02,-3.1128883211853d-02,
     |  -1.8942381417870d-03, 2.8709241300657d-02, 2.7357665126094d-02,
     |  -3.2930252760286d-03,-2.9499314042122d-02,-2.4099948090242d-02,
     |   5.7238717489777d-03, 2.8652790241706d-02, 2.2779544340971d-02,
     |  -4.1969941222860d-03,-2.6083142763472d-02,-2.4691365598693d-02,
     |  -3.9641953124689d-03, 1.8335550139151d-02, 2.8223552078811d-02,
     |   2.4542086169330d-02, 1.4830873408857d-02, 6.4389491256863d-03,
     |   1.9567225273010d-03, 3.8512260438941d-04, 4.1892660931076d-05,
     |   1.7974139722286d-06, 1.1812221296349d-08, 8.4698519009236d-10/
      data (zmn(lat,10,27), lat = 1,72)/
     |   2.3047657478104d-11, 1.0078611120898d-09, 2.5861995411489d-07,
     |   8.6290232653311d-06, 1.0527642555852d-04, 6.8273728191070d-04,
     |   2.8164641274677d-03, 8.1229484067311d-03, 1.7169808880854d-02,
     |   2.6870958051518d-02, 2.9866886726773d-02, 1.9134906217910d-02,
     |  -3.8226873818669d-03,-2.5341588592052d-02,-2.7951282203180d-02,
     |  -6.8416736844487d-03, 2.1416261583120d-02, 3.0700203412178d-02,
     |   1.0420099646721d-02,-2.1048879480096d-02,-3.2043171077766d-02,
     |  -9.9835099831148d-03, 2.3278370714276d-02, 3.2496296208553d-02,
     |   6.7794882952672d-03,-2.6902058611197d-02,-3.1687677902761d-02,
     |  -1.5263738224525d-03, 3.0805756846031d-02, 2.9221664860543d-02,
     |  -5.0804449175425d-03,-3.4024569106924d-02,-2.4963480839224d-02,
     |   1.2245282282694d-02, 3.5831015667631d-02, 1.9125968251988d-02,
     |  -1.9125968251988d-02,-3.5831015667631d-02,-1.2245282282694d-02,
     |   2.4963480839224d-02, 3.4024569106924d-02, 5.0804449175425d-03,
     |  -2.9221664860543d-02,-3.0805756846031d-02, 1.5263738224524d-03,
     |   3.1687677902761d-02, 2.6902058611197d-02,-6.7794882952669d-03,
     |  -3.2496296208553d-02,-2.3278370714276d-02, 9.9835099831149d-03,
     |   3.2043171077766d-02, 2.1048879480096d-02,-1.0420099646721d-02,
     |  -3.0700203412178d-02,-2.1416261583121d-02, 6.8416736844485d-03,
     |   2.7951282203180d-02, 2.5341588592052d-02, 3.8226873818672d-03,
     |  -1.9134906217910d-02,-2.9866886726773d-02,-2.6870958051518d-02,
     |  -1.7169808880854d-02,-8.1229484067309d-03,-2.8164641274676d-03,
     |  -6.8273728191059d-04,-1.0527642555838d-04,-8.6290232652554d-06,
     |  -2.5861995419850d-07,-1.0078611741674d-09,-2.3047630247482d-11/
      data (zmn(lat,11,27), lat = 1,72)/
     |  -2.8835705693937d-11, 1.0631189635753d-10, 3.3168177679340d-08,
     |   1.5796963906256d-06, 2.5430572256485d-05, 2.0873221939224d-04,
     |   1.0657319882990d-03, 3.7711165090000d-03, 9.8237163529812d-03,
     |   1.9397353821179d-02, 2.9039998794443d-02, 3.1470482367664d-02,
     |   2.0113587363922d-02,-3.3600305054470d-03,-2.5735340381975d-02,
     |  -2.9837358707443d-02,-9.8766646798937d-03, 1.9423626931366d-02,
     |   3.2319450464900d-02, 1.5426993585248d-02,-1.6893110491590d-02,
     |  -3.3538128442551d-02,-1.6910903803941d-02, 1.7440196959541d-02,
     |   3.4533802479724d-02, 1.5804150194007d-02,-2.0009859705908d-02,
     |  -3.5114098845709d-02,-1.2768972207904d-02, 2.3654976109404d-02,
     |   3.4871194909295d-02, 8.2830132596037d-03,-2.7545941063423d-02,
     |  -3.3513946855998d-02,-2.8683174154924d-03, 3.0994948442553d-02,
     |   3.0994948442553d-02,-2.8683174154923d-03,-3.3513946855998d-02,
     |  -2.7545941063423d-02, 8.2830132596035d-03, 3.4871194909295d-02,
     |   2.3654976109404d-02,-1.2768972207904d-02,-3.5114098845709d-02,
     |  -2.0009859705908d-02, 1.5804150194007d-02, 3.4533802479724d-02,
     |   1.7440196959541d-02,-1.6910903803941d-02,-3.3538128442551d-02,
     |  -1.6893110491590d-02, 1.5426993585248d-02, 3.2319450464900d-02,
     |   1.9423626931366d-02,-9.8766646798936d-03,-2.9837358707443d-02,
     |  -2.5735340381975d-02,-3.3600305054469d-03, 2.0113587363922d-02,
     |   3.1470482367664d-02, 2.9039998794443d-02, 1.9397353821179d-02,
     |   9.8237163529811d-03, 3.7711165090000d-03, 1.0657319882991d-03,
     |   2.0873221939204d-04, 2.5430572256430d-05, 1.5796963907312d-06,
     |   3.3168177799594d-08, 1.0631190032736d-10,-2.8835712409845d-11/
      data (zmn(lat,12,27), lat = 1,72)/
     |  -6.3471876654752d-13, 7.2205996109527d-12, 3.8254800284195d-09,
     |   2.5908212729124d-07, 5.4804070878225d-06, 5.6588668161104d-05,
     |   3.5449150556575d-04, 1.5191581171785d-03, 4.7781929485144d-03,
     |   1.1484309703372d-02, 2.1473497895517d-02, 3.1050674581181d-02,
     |   3.3081479972717d-02, 2.1355697178279d-02,-2.4717404922999d-03,
     |  -2.5780357433819d-02,-3.1709175994391d-02,-1.3367040507415d-02,
     |   1.6646057057831d-02, 3.3331872291481d-02, 2.0662409378448d-02,
     |  -1.1499588536460d-02,-3.3636700566005d-02,-2.3743711420416d-02,
     |   9.7877763411495d-03, 3.4236174178216d-02, 2.4487227249684d-02,
     |  -1.0473087888606d-02,-3.5161502381764d-02,-2.3660047405092d-02,
     |   1.2684218556008d-02, 3.6070209547899d-02, 2.1665783296898d-02,
     |  -1.5691791116830d-02,-3.6622752889882d-02,-1.8864572882227d-02,
     |   1.8864572882227d-02, 3.6622752889882d-02, 1.5691791116830d-02,
     |  -2.1665783296898d-02,-3.6070209547899d-02,-1.2684218556008d-02,
     |   2.3660047405092d-02, 3.5161502381765d-02, 1.0473087888606d-02,
     |  -2.4487227249684d-02,-3.4236174178216d-02,-9.7877763411498d-03,
     |   2.3743711420416d-02, 3.3636700566005d-02, 1.1499588536460d-02,
     |  -2.0662409378447d-02,-3.3331872291481d-02,-1.6646057057831d-02,
     |   1.3367040507415d-02, 3.1709175994391d-02, 2.5780357433820d-02,
     |   2.4717404922997d-03,-2.1355697178279d-02,-3.3081479972717d-02,
     |  -3.1050674581181d-02,-2.1473497895517d-02,-1.1484309703372d-02,
     |  -4.7781929485144d-03,-1.5191581171788d-03,-3.5449150556585d-04,
     |  -5.6588668161220d-05,-5.4804070879722d-06,-2.5908212730733d-07,
     |  -3.8254799861256d-09,-7.2205805428953d-12, 6.3471138712166d-13/
      data (zmn(lat,13,27), lat = 1,72)/
     |   9.0767404757455d-13,-4.7780750509685d-13, 3.9943806812689d-10,
     |   3.8293830310648d-08, 1.0610093946925d-06, 1.3720490723707d-05,
     |   1.0479528124579d-04, 5.3907683587561d-04, 2.0205886185092d-03,
     |   5.7912533813678d-03, 1.3049075716690d-02, 2.3360675462628d-02,
     |   3.2903218033913d-02, 3.4741887151705d-02, 2.2942080489994d-02,
     |  -1.0444154624443d-03,-2.5354596718229d-02,-3.3489565408215d-02,
     |  -1.7346323821150d-02, 1.2908167666244d-02, 3.3475945332329d-02,
     |   2.5940825013866d-02,-4.7754252965041d-03,-3.1902517229446d-02,
     |  -2.9956439707186d-02, 4.2516444651361d-04, 3.0963078991203d-02,
     |   3.1819020391632d-02, 1.3272765096920d-03,-3.0880378831701d-02,
     |  -3.2520681793693d-02,-1.4171990904121d-03, 3.1358766914940d-02,
     |   3.2493844544295d-02, 5.7323681807379d-04,-3.2012079287837d-02,
     |  -3.2012079287837d-02, 5.7323681807366d-04, 3.2493844544295d-02,
     |   3.1358766914940d-02,-1.4171990904119d-03,-3.2520681793693d-02,
     |  -3.0880378831701d-02, 1.3272765096917d-03, 3.1819020391632d-02,
     |   3.0963078991203d-02, 4.2516444651374d-04,-2.9956439707186d-02,
     |  -3.1902517229446d-02,-4.7754252965040d-03, 2.5940825013866d-02,
     |   3.3475945332329d-02, 1.2908167666244d-02,-1.7346323821150d-02,
     |  -3.3489565408215d-02,-2.5354596718229d-02,-1.0444154624444d-03,
     |   2.2942080489994d-02, 3.4741887151705d-02, 3.2903218033913d-02,
     |   2.3360675462628d-02, 1.3049075716690d-02, 5.7912533813678d-03,
     |   2.0205886185093d-03, 5.3907683587561d-04, 1.0479528124580d-04,
     |   1.3720490723808d-05, 1.0610093946779d-06, 3.8293830194390d-08,
     |   3.9943800990039d-10,-4.7784214470352d-13, 9.0766435110303d-13/
      data (zmn(lat,14,27), lat = 1,72)/
     |   1.6408169165110d-14,-2.5461757125937d-14, 3.7724684953649d-11,
     |   5.1231276728391d-09, 1.8545905367005d-07, 2.9932401489791d-06,
     |   2.7744510239903d-05, 1.7021976415422d-04, 7.5351616277976d-04,
     |   2.5417185726336d-03, 6.7614353890814d-03, 1.4463466015806d-02,
     |   2.5021227225158d-02, 3.4591857931218d-02, 3.6482573044028d-02,
     |   2.4945555454159d-02, 1.0441987557195d-03,-2.4298504120406d-02,
     |  -3.5039479769903d-02,-2.1793562822937d-02, 8.0316999540790d-03,
     |   3.2398664832065d-02, 3.0927313430785d-02, 3.2668342700654d-03,
     |  -2.7842207667164d-02,-3.4775435241005d-02,-1.0250562354680d-02,
     |   2.4135874888273d-02, 3.6437968933703d-02, 1.4422117851975d-02,
     |  -2.1604223193091d-02,-3.7184005121887d-02,-1.6913145597751d-02,
     |   1.9905164182174d-02, 3.7483776155486d-02, 1.8529055653960d-02,
     |  -1.8529055653960d-02,-3.7483776155486d-02,-1.9905164182174d-02,
     |   1.6913145597751d-02, 3.7184005121887d-02, 2.1604223193091d-02,
     |  -1.4422117851975d-02,-3.6437968933703d-02,-2.4135874888273d-02,
     |   1.0250562354680d-02, 3.4775435241005d-02, 2.7842207667164d-02,
     |  -3.2668342700653d-03,-3.0927313430785d-02,-3.2398664832065d-02,
     |  -8.0316999540794d-03, 2.1793562822937d-02, 3.5039479769903d-02,
     |   2.4298504120407d-02,-1.0441987557195d-03,-2.4945555454159d-02,
     |  -3.6482573044028d-02,-3.4591857931218d-02,-2.5021227225158d-02,
     |  -1.4463466015806d-02,-6.7614353890814d-03,-2.5417185726336d-03,
     |  -7.5351616277975d-04,-1.7021976415404d-04,-2.7744510239857d-05,
     |  -2.9932401489121d-06,-1.8545905356029d-07,-5.1231276614369d-09,
     |  -3.7724698002949d-11, 2.5497069255836d-14,-1.6393466949534d-14/
      data (zmn(lat,15,27), lat = 1,72)/
     |  -2.5999243876731d-14, 2.4872413683063d-14, 3.2123284637594d-12,
     |   6.2220684308634d-10, 2.9369181678442d-08, 5.9001059869481d-07,
     |   6.6129475804515d-06, 4.8157202277323d-05, 2.5013085240933d-04,
     |   9.8402184907850d-04, 3.0500631730737d-03, 7.6388243823155d-03,
     |   1.5673569601499d-02, 2.6414321407858d-02, 3.6099043633407d-02,
     |   3.8315513359795d-02, 2.7423366612083d-02, 3.9218983654781d-03,
     |  -2.2408685429975d-02,-3.6137244269598d-02,-2.6599253767982d-02,
     |   1.8685250133821d-03, 2.9658955538647d-02, 3.5085749093507d-02,
     |   1.2411370118975d-02,-2.0985809967558d-02,-3.7151789430491d-02,
     |  -2.1377634374910d-02, 1.3460786010192d-02, 3.6699490246620d-02,
     |   2.7009339997402d-02,-7.4098945918617d-03,-3.5272150850144d-02,
     |  -3.0704368799382d-02, 2.3562256649844d-03, 3.3307114853996d-02,
     |   3.3307114853996d-02, 2.3562256649845d-03,-3.0704368799382d-02,
     |  -3.5272150850144d-02,-7.4098945918618d-03, 2.7009339997402d-02,
     |   3.6699490246620d-02, 1.3460786010192d-02,-2.1377634374910d-02,
     |  -3.7151789430490d-02,-2.0985809967558d-02, 1.2411370118975d-02,
     |   3.5085749093507d-02, 2.9658955538647d-02, 1.8685250133822d-03,
     |  -2.6599253767981d-02,-3.6137244269598d-02,-2.2408685429975d-02,
     |   3.9218983654779d-03, 2.7423366612083d-02, 3.8315513359795d-02,
     |   3.6099043633407d-02, 2.6414321407858d-02, 1.5673569601500d-02,
     |   7.6388243823155d-03, 3.0500631730737d-03, 9.8402184907851d-04,
     |   2.5013085240927d-04, 4.8157202277316d-05, 6.6129475804293d-06,
     |   5.9001059864592d-07, 2.9369181766462d-08, 6.2220685267367d-10,
     |   3.2123128201707d-12, 2.4897900600172d-14,-2.5967242004445d-14/
      data (zmn(lat,16,27), lat = 1,72)/
     |  -4.4845611731091d-16, 1.0761959355553d-15, 2.5109223591291d-13,
     |   6.8711809867466d-11, 4.2223764847567d-09, 1.0535705248469d-07,
     |   1.4238563810761d-06, 1.2261681048849d-05, 7.4361541350740d-05,
     |   3.3894554961022d-04, 1.2130607023230d-03, 3.5107760677796d-03,
     |   8.3737580567561d-03, 1.6625518271331d-02, 2.7492574593796d-02,
     |   3.7388802079569d-02, 4.0223895992853d-02, 3.0405514622090d-02,
     |   7.7129931801387d-03,-1.9436084946460d-02,-3.6455888984602d-02,
     |  -3.1517776435559d-02,-5.6411842424908d-03, 2.4757474145135d-02,
     |   3.7632771839980d-02, 2.2104313900292d-02,-1.1044998108515d-02,
     |  -3.5806775713891d-02,-3.1447653760510d-02,-7.0826552499578d-04,
     |   3.0951920201067d-02, 3.6303094207086d-02, 1.0228036861256d-02,
     |  -2.4916633931659d-02,-3.8354068374814d-02,-1.8100261819495d-02,
     |   1.8100261819495d-02, 3.8354068374814d-02, 2.4916633931659d-02,
     |  -1.0228036861256d-02,-3.6303094207086d-02,-3.0951920201067d-02,
     |   7.0826552499570d-04, 3.1447653760510d-02, 3.5806775713891d-02,
     |   1.1044998108515d-02,-2.2104313900292d-02,-3.7632771839980d-02,
     |  -2.4757474145135d-02, 5.6411842424908d-03, 3.1517776435559d-02,
     |   3.6455888984602d-02, 1.9436084946460d-02,-7.7129931801387d-03,
     |  -3.0405514622090d-02,-4.0223895992853d-02,-3.7388802079569d-02,
     |  -2.7492574593796d-02,-1.6625518271331d-02,-8.3737580567562d-03,
     |  -3.5107760677795d-03,-1.2130607023231d-03,-3.3894554961019d-04,
     |  -7.4361541350791d-05,-1.2261681048939d-05,-1.4238563810304d-06,
     |  -1.0535705246259d-07,-4.2223765541939d-09,-6.8711842274391d-11,
     |  -2.5116206459135d-13,-1.1374724451472d-15, 4.4666447587694d-16/
      data (zmn(lat,17,27), lat = 1,72)/
     |   6.2400757446869d-16,-7.0492155808352d-16, 1.8456672268263d-14,
     |   6.9029843440287d-12, 5.5157595986926d-10, 1.7064322539895d-08,
     |   2.7743932794190d-07, 2.8170259279084d-06, 1.9871437375080d-05,
     |   1.0442344965022d-04, 4.2867653185334d-04, 1.4207662757720d-03,
     |   3.8886262428339d-03, 8.9182293319377d-03, 1.7265084565302d-02,
     |   2.8198830290103d-02, 3.8399584851633d-02, 4.2149821487834d-02,
     |   3.3877372389457d-02, 1.2520033787392d-02,-1.5093969056553d-02,
     |  -3.5543545600981d-02,-3.6106371011516d-02,-1.4375112817207d-02,
     |   1.7215514844095d-02, 3.7523931224010d-02, 3.1291324219420d-02,
     |   1.8192141844081d-03,-2.9425980002989d-02,-3.8193557462639d-02,
     |  -1.6871358694655d-02, 1.8154397733587d-02, 3.8709322792933d-02,
     |   2.7733958990124d-02,-6.0893922233036d-03,-3.4965026447627d-02,
     |  -3.4965026447627d-02,-6.0893922233038d-03, 2.7733958990124d-02,
     |   3.8709322792933d-02, 1.8154397733587d-02,-1.6871358694655d-02,
     |  -3.8193557462639d-02,-2.9425980002989d-02, 1.8192141844081d-03,
     |   3.1291324219420d-02, 3.7523931224010d-02, 1.7215514844095d-02,
     |  -1.4375112817207d-02,-3.6106371011516d-02,-3.5543545600981d-02,
     |  -1.5093969056554d-02, 1.2520033787392d-02, 3.3877372389457d-02,
     |   4.2149821487834d-02, 3.8399584851633d-02, 2.8198830290103d-02,
     |   1.7265084565302d-02, 8.9182293319376d-03, 3.8886262428340d-03,
     |   1.4207662757720d-03, 4.2867653185329d-04, 1.0442344965015d-04,
     |   1.9871437375037d-05, 2.8170259278797d-06, 2.7743932789953d-07,
     |   1.7064322565960d-08, 5.5157591389199d-10, 6.9029981950218d-12,
     |   1.8471741814648d-14,-7.3261014820500d-16, 6.3289093305922d-16/
      data (zmn(lat,18,27), lat = 1,72)/
     |   8.9700229690921d-18,-4.3413450979104d-17, 1.1372616777654d-15,
     |   6.3052522041672d-13, 6.5441669141067d-11, 2.5066167847751d-09,
     |   4.8936539835044d-08, 5.8447105935483d-07, 4.7811189590165d-06,
     |   2.8854177379941d-05, 1.3519151246880d-04, 5.0974078373851d-04,
     |   1.5866573510554d-03, 4.1502026919395d-03, 9.2276446904954d-03,
     |   1.7537984948042d-02, 2.8463860569217d-02, 3.9037391548416d-02,
     |   4.3979785200844d-02, 3.7755081143963d-02, 1.8391709092333d-02,
     |  -9.0841309924189d-03,-3.2817351046014d-02,-3.9656789316722d-02,
     |  -2.3890748825887d-02, 6.7348039310376d-03, 3.3522488705561d-02,
     |   3.8268736456533d-02, 1.6604284207725d-02,-1.7108212380316d-02,
     |  -3.8716815401322d-02,-3.1861736994864d-02,-1.0581633242129d-03,
     |   3.0709000335723d-02, 3.9136919219804d-02, 1.7548778762250d-02,
     |  -1.7548778762250d-02,-3.9136919219804d-02,-3.0709000335723d-02,
     |   1.0581633242129d-03, 3.1861736994864d-02, 3.8716815401322d-02,
     |   1.7108212380316d-02,-1.6604284207725d-02,-3.8268736456533d-02,
     |  -3.3522488705561d-02,-6.7348039310377d-03, 2.3890748825887d-02,
     |   3.9656789316722d-02, 3.2817351046014d-02, 9.0841309924188d-03,
     |  -1.8391709092333d-02,-3.7755081143963d-02,-4.3979785200844d-02,
     |  -3.9037391548416d-02,-2.8463860569217d-02,-1.7537984948042d-02,
     |  -9.2276446904954d-03,-4.1502026919395d-03,-1.5866573510554d-03,
     |  -5.0974078373859d-04,-1.3519151246882d-04,-2.8854177380025d-05,
     |  -4.7811189589352d-06,-5.8447105931687d-07,-4.8936539862010d-08,
     |  -2.5066168094425d-09,-6.5441590263583d-11,-6.3051610345702d-13,
     |  -1.0926111848777d-15, 6.1891565424154d-17,-4.2683978585181d-17/
      data (zmn(lat,19,27), lat = 1,72)/
     |  -8.4844635496878d-17,-1.6758064294528d-16,-1.4574387671446d-16,
     |   5.2190712675125d-14, 7.0394640587203d-12, 3.3342382225011d-10,
     |   7.8043453616618d-09, 1.0942747717231d-07, 1.0355206688601d-06,
     |   7.1550607231696d-06, 3.8112918747823d-05, 1.6267011810797d-04,
     |   5.7207845129776d-04, 1.6916314659540d-03, 4.2664466706575d-03,
     |   9.2632878808982d-03, 1.7391616314663d-02, 2.8206184167932d-02,
     |   3.9170701749137d-02, 4.5529162265835d-02, 4.1853074801968d-02,
     |   2.5271801368926d-02,-1.1535323732702d-03,-2.7590012414707d-02,
     |  -4.1138522773516d-02,-3.3245125166138d-02,-6.5257955544652d-03,
     |   2.4433931404702d-02, 4.0651198127191d-02, 3.0996746742168d-02,
     |   8.2732452657108d-04,-3.0140571216692d-02,-4.0645419798311d-02,
     |  -2.2964160533208d-02, 1.0887193050586d-02, 3.7131054115416d-02,
     |   3.7131054115416d-02, 1.0887193050586d-02,-2.2964160533208d-02,
     |  -4.0645419798311d-02,-3.0140571216692d-02, 8.2732452657114d-04,
     |   3.0996746742168d-02, 4.0651198127191d-02, 2.4433931404702d-02,
     |  -6.5257955544651d-03,-3.3245125166138d-02,-4.1138522773516d-02,
     |  -2.7590012414707d-02,-1.1535323732701d-03, 2.5271801368926d-02,
     |   4.1853074801968d-02, 4.5529162265835d-02, 3.9170701749137d-02,
     |   2.8206184167932d-02, 1.7391616314663d-02, 9.2632878808982d-03,
     |   4.2664466706574d-03, 1.6916314659540d-03, 5.7207845129772d-04,
     |   1.6267011810787d-04, 3.8112918747831d-05, 7.1550607232146d-06,
     |   1.0355206688852d-06, 1.0942747716512d-07, 7.8043453751601d-09,
     |   3.3342377977598d-10, 7.0394261621200d-12, 5.2236835975020d-14,
     |  -1.1701843152467d-16,-1.7656327008983d-16,-7.9371387417667d-17/
      data (zmn(lat,20,27), lat = 1,72)/
     |   3.1577207176402d-17,-2.5434436373835d-17,-9.2246232300657d-17,
     |   3.7841676317228d-15, 6.8413427357051d-13, 4.0035460958561d-11,
     |   1.1220598592806d-09, 1.8440028898386d-08, 2.0145853540086d-07,
     |   1.5897613378751d-06, 9.5975346014202d-06, 4.6188659167060d-05,
     |   1.8261473112006d-04, 6.0651038717272d-04, 1.7201925253784d-03,
     |   4.2156177635714d-03, 8.9958985242960d-03, 1.6779162529182d-02,
     |   2.7335744232225d-02, 3.8629917071706d-02, 4.6528884543590d-02,
     |   4.5845471542297d-02, 3.2925298001212d-02, 8.8031356653147d-03,
     |  -1.9160253445665d-02,-3.9195599955245d-02,-4.0802800368682d-02,
     |  -2.1535241110317d-02, 9.6192018768569d-03, 3.5657278373987d-02,
     |   4.1022901065036d-02, 2.1683971741408d-02,-1.1149397699506d-02,
     |  -3.7152058175640d-02,-3.9668579608702d-02,-1.6826458240972d-02,
     |   1.6826458240972d-02, 3.9668579608702d-02, 3.7152058175640d-02,
     |   1.1149397699506d-02,-2.1683971741408d-02,-4.1022901065036d-02,
     |  -3.5657278373987d-02,-9.6192018768571d-03, 2.1535241110316d-02,
     |   4.0802800368682d-02, 3.9195599955245d-02, 1.9160253445665d-02,
     |  -8.8031356653147d-03,-3.2925298001212d-02,-4.5845471542297d-02,
     |  -4.6528884543590d-02,-3.8629917071706d-02,-2.7335744232225d-02,
     |  -1.6779162529182d-02,-8.9958985242961d-03,-4.2156177635714d-03,
     |  -1.7201925253784d-03,-6.0651038717269d-04,-1.8261473112010d-04,
     |  -4.6188659167130d-05,-9.5975346013894d-06,-1.5897613378076d-06,
     |  -2.0145853545890d-07,-1.8440028944632d-08,-1.1220598310568d-09,
     |  -4.0035428113603d-11,-6.8420223465690d-13,-3.7727239439217d-15,
     |   1.9530305021338d-16, 9.4404225877817d-17, 1.2049226335361d-17/
      data (zmn(lat,21,27), lat = 1,72)/
     |  -4.0236887349094d-17,-1.2495335970069d-16,-1.8525827604690d-16,
     |   5.9508812851349d-17, 5.9650601181808d-14, 4.3169916828446d-12,
     |   1.4471349894117d-10, 2.7836649293315d-09, 3.5051238509395d-08,
     |   3.1524433306787d-07, 2.1515238128735d-06, 1.1638744870582d-05,
     |   5.1530942668747d-05, 1.9128579215379d-04, 6.0623073852620d-04,
     |   1.6628322513121d-03, 3.9867480621693d-03, 8.4107432536522d-03,
     |   1.5667128079926d-02, 2.5763781203072d-02, 3.7215636502827d-02,
     |   4.6620790776855d-02, 4.9228158656378d-02, 4.0843032056093d-02,
     |   2.0580050286708d-02,-7.0112502004089d-03,-3.2274786212648d-02,
     |  -4.4122315286992d-02,-3.5877466046516d-02,-1.0110212968321d-02,
     |   2.1030049964391d-02, 4.1296413656463d-02, 3.9252034326777d-02,
     |   1.5413772090620d-02,-1.7190722515943d-02,-4.0080300162057d-02,
     |  -4.0080300162057d-02,-1.7190722515943d-02, 1.5413772090620d-02,
     |   3.9252034326777d-02, 4.1296413656463d-02, 2.1030049964391d-02,
     |  -1.0110212968321d-02,-3.5877466046516d-02,-4.4122315286992d-02,
     |  -3.2274786212648d-02,-7.0112502004090d-03, 2.0580050286708d-02,
     |   4.0843032056093d-02, 4.9228158656378d-02, 4.6620790776855d-02,
     |   3.7215636502827d-02, 2.5763781203072d-02, 1.5667128079926d-02,
     |   8.4107432536522d-03, 3.9867480621693d-03, 1.6628322513121d-03,
     |   6.0623073852621d-04, 1.9128579215382d-04, 5.1530942668770d-05,
     |   1.1638744870569d-05, 2.1515238128810d-06, 3.1524433311629d-07,
     |   3.5051238515094d-08, 2.7836649202905d-09, 1.4471351004691d-10,
     |   4.3170680182473d-12, 5.9753106323106d-14, 2.0778009167875d-17,
     |  -1.8570236782143d-16,-1.3602500040298d-16,-6.8590906091434d-17/
      data (zmn(lat,22,27), lat = 1,72)/
     |   1.2873684308536d-16, 4.1327098355365d-17,-8.6154109027053d-17,
     |  -1.7094776502856d-16, 4.4193274547740d-15, 4.1453172387656d-13,
     |   1.6612849625951d-11, 3.7360514926966d-10, 5.4143444971499d-09,
     |   5.5403822143868d-08, 4.2658157054883d-07, 2.5872662827671d-06,
     |   1.2788204451073d-05, 5.2851622817677d-05, 1.8626124821464d-04,
     |   5.6828068200190d-04, 1.5183968057149d-03, 3.5834813398136d-03,
     |   7.5143375701645d-03, 1.4047215481331d-02, 2.3421619356562d-02,
     |   3.4721943179066d-02, 4.5372941664533d-02, 5.1297598463436d-02,
     |   4.8139386845390d-02, 3.3432586514775d-02, 8.8342224394937d-03,
     |  -1.9006767290497d-02,-4.0115103744223d-02,-4.5337533299276d-02,
     |  -3.1250201542137d-02,-3.0601321675536d-03, 2.6717716291769d-02,
     |   4.3852161817588d-02, 3.9647558600569d-02, 1.5846026365408d-02,
     |  -1.5846026365407d-02,-3.9647558600569d-02,-4.3852161817588d-02,
     |  -2.6717716291769d-02, 3.0601321675535d-03, 3.1250201542137d-02,
     |   4.5337533299276d-02, 4.0115103744223d-02, 1.9006767290498d-02,
     |  -8.8342224394937d-03,-3.3432586514775d-02,-4.8139386845390d-02,
     |  -5.1297598463436d-02,-4.5372941664533d-02,-3.4721943179066d-02,
     |  -2.3421619356563d-02,-1.4047215481331d-02,-7.5143375701645d-03,
     |  -3.5834813398136d-03,-1.5183968057149d-03,-5.6828068200189d-04,
     |  -1.8626124821465d-04,-5.2851622817617d-05,-1.2788204451052d-05,
     |  -2.5872662826714d-06,-4.2658157059939d-07,-5.5403822147933d-08,
     |  -5.4143445154313d-09,-3.7360513766675d-10,-1.6612937433909d-11,
     |  -4.1459913420403d-13,-4.4212853722043d-15, 1.3446025284844d-16,
     |   1.0375289436874d-17,-9.0184692138530d-17,-1.1056580573326d-16/
      data (zmn(lat,23,27), lat = 1,72)/
     |  -2.8572734402544d-17,-7.0590513255191d-17,-1.1236340319222d-16,
     |  -1.2933152801890d-16, 2.0111014615941d-16, 3.4996964247845d-14,
     |   1.6776079433772d-12, 4.4064647528592d-11, 7.3408190246046d-10,
     |   8.5340564645634d-09, 7.3998117671223d-08, 5.0213803978630d-07,
     |   2.7637025678111d-06, 1.2677305720776d-05, 4.9492991869296d-05,
     |   1.6716689050230d-04, 4.9477618893642d-04, 1.2961130181304d-03,
     |   3.0278744516052d-03, 6.3424271699458d-03, 1.1952750807641d-02,
     |   2.0290689434900d-02, 3.0982165431405d-02, 4.2331915069572d-02,
     |   5.1176607520114d-02, 5.3483696393176d-02, 4.5817099075192d-02,
     |   2.7279179423860d-02, 1.0126695752135d-03,-2.5810012986296d-02,
     |  -4.4085488122434d-02,-4.6477178067343d-02,-3.1122706335897d-02,
     |  -3.3505630393720d-03, 2.5873728857859d-02, 4.4426680484345d-02,
     |   4.4426680484345d-02, 2.5873728857859d-02,-3.3505630393719d-03,
     |  -3.1122706335897d-02,-4.6477178067343d-02,-4.4085488122434d-02,
     |  -2.5810012986296d-02, 1.0126695752133d-03, 2.7279179423859d-02,
     |   4.5817099075192d-02, 5.3483696393176d-02, 5.1176607520114d-02,
     |   4.2331915069572d-02, 3.0982165431405d-02, 2.0290689434900d-02,
     |   1.1952750807641d-02, 6.3424271699458d-03, 3.0278744516052d-03,
     |   1.2961130181304d-03, 4.9477618893646d-04, 1.6716689050230d-04,
     |   4.9492991869338d-05, 1.2677305720809d-05, 2.7637025678055d-06,
     |   5.0213803981772d-07, 7.3998117653783d-08, 8.5340563882874d-09,
     |   7.3408188512377d-10, 4.4064637103951d-11, 1.6775650937814d-12,
     |   3.4905845326210d-14, 1.8363865156030d-16,-1.0270922561160d-16,
     |  -8.3579488412490d-17,-1.2568746853782d-16,-3.6011577498630d-17/
      data (zmn(lat,24,27), lat = 1,72)/
     |   2.0895715658244d-16, 1.3723941534683d-16, 2.4199241289543d-17,
     |  -1.1547903832806d-16,-1.9202968874844d-16, 2.3065982290879d-15,
     |   1.4607863741355d-13, 4.4844717497912d-12, 8.5792468922139d-11,
     |   1.1317141456782d-09, 1.1034678171355d-08, 8.3628950210932d-08,
     |   5.1145328396468d-07, 2.5973230935036d-06, 1.1198570302092d-05,
     |   4.1716612029265d-05, 1.3614277466649d-04, 3.9356985423897d-04,
     |   1.0167163767516d-03, 2.3632072873141d-03, 4.9677828598060d-03,
     |   9.4780988781190d-03, 1.6443865106053d-02, 2.5943341837959d-02,
     |   3.7133053289844d-02, 4.7934768986826d-02, 5.5148557925255d-02,
     |   5.5206381333878d-02, 4.5515278808653d-02, 2.5960803293923d-02,
     |  -1.4862876078050d-04,-2.6386863613423d-02,-4.5004676290693d-02,
     |  -4.9726962659289d-02,-3.8428843443776d-02,-1.4419774109839d-02,
     |   1.4419774109839d-02, 3.8428843443775d-02, 4.9726962659289d-02,
     |   4.5004676290693d-02, 2.6386863613423d-02, 1.4862876078044d-04,
     |  -2.5960803293923d-02,-4.5515278808653d-02,-5.5206381333878d-02,
     |  -5.5148557925255d-02,-4.7934768986826d-02,-3.7133053289844d-02,
     |  -2.5943341837959d-02,-1.6443865106053d-02,-9.4780988781190d-03,
     |  -4.9677828598060d-03,-2.3632072873141d-03,-1.0167163767516d-03,
     |  -3.9356985423899d-04,-1.3614277466649d-04,-4.1716612029285d-05,
     |  -1.1198570302032d-05,-2.5973230935067d-06,-5.1145328401519d-07,
     |  -8.3628950287657d-08,-1.1034678123303d-08,-1.1317142150429d-09,
     |  -8.5792466733982d-11,-4.4844601246972d-12,-1.4606366164606d-13,
     |  -2.3414964761919d-15, 2.1671491659430d-16, 1.2936701409633d-16,
     |  -6.9912765553275d-17,-6.0900515623566d-17,-2.1371751434237d-16/
      data (zmn(lat,25,27), lat = 1,72)/
     |  -1.7128704795313d-17,-6.6712622963968d-17,-1.1251321275539d-16,
     |  -1.5390363299350d-16,-1.9236857656313d-16,-6.0010062665467d-17,
     |   1.0484295930194d-14, 3.8190486350512d-13, 8.3857808282706d-12,
     |   1.2538525738596d-10, 1.3730135772513d-09, 1.1604145056984d-08,
     |   7.8717422827266d-08, 4.4162985305315d-07, 2.0975967415583d-06,
     |   8.5920488679159d-06, 3.0805008646732d-05, 9.7835747256654d-05,
     |   2.7793634425516d-04, 7.1184367701369d-04, 1.6541078248298d-03,
     |   3.5046616029513d-03, 6.7960995903937d-03, 1.2092399261904d-02,
     |   1.9768028038113d-02, 2.9684797325965d-02, 4.0862010881533d-02,
     |   5.1310471861924d-02, 5.8218852662391d-02, 5.8594987419691d-02,
     |   5.0273914709194d-02, 3.2977636912567d-02, 8.9696437165640d-03,
     |  -1.7097829183737d-02,-3.9267524215663d-02,-5.2013040396313d-02,
     |  -5.2013040396313d-02,-3.9267524215663d-02,-1.7097829183737d-02,
     |   8.9696437165639d-03, 3.2977636912567d-02, 5.0273914709194d-02,
     |   5.8594987419691d-02, 5.8218852662391d-02, 5.1310471861924d-02,
     |   4.0862010881533d-02, 2.9684797325965d-02, 1.9768028038113d-02,
     |   1.2092399261904d-02, 6.7960995903937d-03, 3.5046616029513d-03,
     |   1.6541078248299d-03, 7.1184367701370d-04, 2.7793634425514d-04,
     |   9.7835747256620d-05, 3.0805008646784d-05, 8.5920488679331d-06,
     |   2.0975967415493d-06, 4.4162985305020d-07, 7.8717422827943d-08,
     |   1.1604145052496d-08, 1.3730136144705d-09, 1.2538520008243d-10,
     |   8.3857202533905d-12, 3.8188103933536d-13, 1.0509228197132d-14,
     |  -1.2211161854418d-18,-1.8651948210529d-16,-1.4019186143568d-16,
     |  -1.2340771171883d-16, 2.9370245037403d-17, 1.6828440055790d-17/
      data (zmn(lat,26,27), lat = 1,72)/
     |   3.9717758623047d-17, 2.5438761792613d-17, 1.4685379843699d-17,
     |  -1.7412793347428d-17,-5.7182513950849d-17,-7.1003227241222d-17,
     |   5.0806430587898d-16, 2.5595803888625d-14, 6.4741124578139d-13,
     |   1.0964108469395d-11, 1.3468983451118d-10, 1.2678107250390d-09,
     |   9.5249557433725d-09, 5.8931225471416d-08, 3.0769861868325d-07,
     |   1.3824538550529d-06, 5.4291284345446d-06, 1.8876148257209d-05,
     |   5.8716647511664d-05, 1.6483283899826d-04, 4.2061593809853d-04,
     |   9.8146428120261d-04, 2.1044480746200d-03, 4.1629471852419d-03,
     |   7.6210867912034d-03, 1.2941512721502d-02, 2.0414533590545d-02,
     |   2.9930181576517d-02, 4.0759644456886d-02, 5.1448403956122d-02,
     |   5.9923850934535d-02, 6.3867369295370d-02, 6.1301370445252d-02,
     |   5.1231805677508d-02, 3.4120264646261d-02, 1.1981441667659d-02,
     |  -1.1981441667659d-02,-3.4120264646261d-02,-5.1231805677508d-02,
     |  -6.1301370445252d-02,-6.3867369295370d-02,-5.9923850934535d-02,
     |  -5.1448403956122d-02,-4.0759644456886d-02,-2.9930181576517d-02,
     |  -2.0414533590545d-02,-1.2941512721502d-02,-7.6210867912035d-03,
     |  -4.1629471852419d-03,-2.1044480746200d-03,-9.8146428120258d-04,
     |  -4.2061593809852d-04,-1.6483283899827d-04,-5.8716647511657d-05,
     |  -1.8876148257217d-05,-5.4291284345124d-06,-1.3824538550382d-06,
     |  -3.0769861873009d-07,-5.8931225511551d-08,-9.5249557177812d-09,
     |  -1.2678107303038d-09,-1.3468983631396d-10,-1.0964085379054d-11,
     |  -6.4744786571226d-13,-2.5600988056755d-14,-4.8717335844180d-16,
     |   1.3998857468322d-16, 3.9230518732901d-18, 2.2183979411576d-17,
     |   9.4659781593119d-18,-1.0711267245991d-16,-1.0054733138158d-16/
      data (zmn(lat,27,27), lat = 1,72)/
     |  -2.2998357630615d-17,-7.3889829765155d-17,-1.1998869414396d-16,
     |  -1.4657675989129d-16,-1.7272148659605d-16,-2.0840892230761d-16,
     |  -1.9546448127677d-16, 9.6555073849902d-16, 3.4039272565696d-14,
     |   6.5628864375290d-13, 9.0386393461901d-12, 9.4651471413314d-11,
     |   7.8654255712272d-10, 5.3584744880626d-09, 3.0702171258421d-08,
     |   1.5098879602074d-07, 6.4791968274418d-07, 2.4590129304583d-06,
     |   8.3468009838238d-06, 2.5577548760922d-05, 7.1317791638171d-05,
     |   1.8215336306410d-04, 4.2859662575105d-04, 9.3357193546611d-04,
     |   1.8903810379979d-03, 3.5711916239991d-03, 6.3136355866037d-03,
     |   1.0473655376372d-02, 1.6340007266522d-02, 2.4020169651613d-02,
     |   3.3325112846669d-02, 4.3693854861377d-02, 5.4199233434897d-02,
     |   6.3658738135105d-02, 7.0841235793298d-02, 7.4723276467620d-02,
     |   7.4723276467620d-02, 7.0841235793298d-02, 6.3658738135105d-02,
     |   5.4199233434897d-02, 4.3693854861377d-02, 3.3325112846669d-02,
     |   2.4020169651613d-02, 1.6340007266522d-02, 1.0473655376372d-02,
     |   6.3136355866037d-03, 3.5711916239991d-03, 1.8903810379979d-03,
     |   9.3357193546608d-04, 4.2859662575103d-04, 1.8215336306409d-04,
     |   7.1317791638151d-05, 2.5577548760919d-05, 8.3468009838128d-06,
     |   2.4590129304871d-06, 6.4791968271015d-07, 1.5098879604630d-07,
     |   3.0702171264497d-08, 5.3584744986654d-09, 7.8654257302916d-10,
     |   9.4651476376306d-11, 9.0386270906300d-12, 6.5630116425365d-13,
     |   3.4020920376383d-14, 9.3405094848916d-16,-2.3597970739486d-16,
     |  -2.3749438104766d-16,-2.2053751042386d-16,-1.4311202769529d-16,
     |  -1.0884827608756d-16,-1.0411571825030d-16,-5.5895720970837d-17/
      data (zmn(lat, 0,28), lat = 1,72)/
     |   3.8845842334711d-03, 5.0382976190355d-03,-7.7810507814086d-03,
     |  -1.2256953982054d-02, 9.9503019436362d-04, 1.6583185036911d-02,
     |   9.8241478209062d-03,-1.2208917234750d-02,-1.9779697764811d-02,
     |   5.8634324417803d-04, 2.2012959052584d-02, 1.4281945739531d-02,
     |  -1.4514792755105d-02,-2.4819703117892d-02,-1.0855338156068d-03,
     |   2.5765513928589d-02, 1.7997594360293d-02,-1.5134372555736d-02,
     |  -2.8875301873536d-02,-3.0415345077951d-03, 2.7926511108247d-02,
     |   2.1469507865256d-02,-1.4905600853869d-02,-3.1747972222021d-02,
     |  -5.4070336207582d-03, 2.9058948979544d-02, 2.4335347787749d-02,
     |  -1.3803290828617d-02,-3.3729288045985d-02,-7.7770110228333d-03,
     |   2.9106815523762d-02, 2.6676258577642d-02,-1.2174622570866d-02,
     |  -3.4685884665566d-02,-1.0106424032905d-02, 2.8291994918639d-02,
     |   2.8291994918639d-02,-1.0106424032905d-02,-3.4685884665566d-02,
     |  -1.2174622570867d-02, 2.6676258577642d-02, 2.9106815523762d-02,
     |  -7.7770110228331d-03,-3.3729288045985d-02,-1.3803290828618d-02,
     |   2.4335347787749d-02, 2.9058948979544d-02,-5.4070336207579d-03,
     |  -3.1747972222021d-02,-1.4905600853869d-02, 2.1469507865256d-02,
     |   2.7926511108247d-02,-3.0415345077950d-03,-2.8875301873536d-02,
     |  -1.5134372555736d-02, 1.7997594360292d-02, 2.5765513928589d-02,
     |  -1.0855338156070d-03,-2.4819703117892d-02,-1.4514792755105d-02,
     |   1.4281945739531d-02, 2.2012959052584d-02, 5.8634324417827d-04,
     |  -1.9779697764811d-02,-1.2208917234750d-02, 9.8241478209064d-03,
     |   1.6583185036911d-02, 9.9503019436386d-04,-1.2256953982054d-02,
     |  -7.7810507814086d-03, 5.0382976190353d-03, 3.8845842334711d-03/
      data (zmn(lat, 1,28), lat = 1,72)/
     |   1.7703184944122d-03, 8.7608405146266d-03, 7.6146556141559d-03,
     |  -6.7217909962623d-03,-1.5230188493610d-02,-3.0064789369400d-03,
     |   1.6129440030587d-02, 1.4774977403449d-02,-8.0337989963482d-03,
     |  -2.2100885073395d-02,-6.1180264551439d-03, 1.9959155028477d-02,
     |   2.0095911260894d-02,-8.0423517793483d-03,-2.6769055390649d-02,
     |  -9.3006923195325d-03, 2.2146726531962d-02, 2.4368306531429d-02,
     |  -7.0682830663908d-03,-3.0101929647639d-02,-1.2381297147870d-02,
     |   2.3015906573324d-02, 2.7889328682596d-02,-5.5141786190080d-03,
     |  -3.2194077774831d-02,-1.5373108181318d-02, 2.2930829404052d-02,
     |   3.0535363461221d-02,-3.4565686984811d-03,-3.3273853667060d-02,
     |  -1.8014114099513d-02, 2.1932275732246d-02, 3.2390990666880d-02,
     |  -1.2013009772110d-03,-3.3280567525306d-02,-2.0288032009663d-02,
     |   2.0288032009663d-02, 3.3280567525306d-02, 1.2013009772112d-03,
     |  -3.2390990666880d-02,-2.1932275732247d-02, 1.8014114099514d-02,
     |   3.3273853667060d-02, 3.4565686984814d-03,-3.0535363461221d-02,
     |  -2.2930829404053d-02, 1.5373108181318d-02, 3.2194077774831d-02,
     |   5.5141786190082d-03,-2.7889328682596d-02,-2.3015906573324d-02,
     |   1.2381297147869d-02, 3.0101929647639d-02, 7.0682830663910d-03,
     |  -2.4368306531429d-02,-2.2146726531962d-02, 9.3006923195323d-03,
     |   2.6769055390649d-02, 8.0423517793481d-03,-2.0095911260894d-02,
     |  -1.9959155028477d-02, 6.1180264551441d-03, 2.2100885073395d-02,
     |   8.0337989963483d-03,-1.4774977403449d-02,-1.6129440030587d-02,
     |   3.0064789369400d-03, 1.5230188493610d-02, 6.7217909962622d-03,
     |  -7.6146556141560d-03,-8.7608405146267d-03,-1.7703184944123d-03/
      data (zmn(lat, 2,28), lat = 1,72)/
     |   2.7383069780176d-04, 4.8605609116100d-03, 1.2370177090111d-02,
     |   9.4211763201406d-03,-6.5455977760352d-03,-1.7329886382489d-02,
     |  -6.0626907894266d-03, 1.5381529408139d-02, 1.8266034862306d-02,
     |  -4.0404569927260d-03,-2.2979993393416d-02,-1.1681810696961d-02,
     |   1.6804617922877d-02, 2.4054737562651d-02,-1.5244498566657d-03,
     |  -2.6569835304015d-02,-1.6283436876625d-02, 1.6976934382291d-02,
     |   2.8403303323889d-02, 1.2196114240293d-03,-2.8686208911974d-02,
     |  -2.0285465453992d-02, 1.6211102965669d-02, 3.1572371153850d-02,
     |   4.1541128991956d-03,-2.9611001163438d-02,-2.3671102003039d-02,
     |   1.4667832220477d-02, 3.3677055679470d-02, 7.1148521361286d-03,
     |  -2.9460705185211d-02,-2.6395923333020d-02, 1.2534819476997d-02,
     |   3.4723110811770d-02, 9.9634057200608d-03,-2.8357278240365d-02,
     |  -2.8357278240365d-02, 9.9634057200607d-03, 3.4723110811770d-02,
     |   1.2534819476998d-02,-2.6395923333019d-02,-2.9460705185211d-02,
     |   7.1148521361285d-03, 3.3677055679470d-02, 1.4667832220478d-02,
     |  -2.3671102003039d-02,-2.9611001163438d-02, 4.1541128991953d-03,
     |   3.1572371153850d-02, 1.6211102965669d-02,-2.0285465453991d-02,
     |  -2.8686208911974d-02, 1.2196114240292d-03, 2.8403303323889d-02,
     |   1.6976934382291d-02,-1.6283436876625d-02,-2.6569835304015d-02,
     |  -1.5244498566655d-03, 2.4054737562651d-02, 1.6804617922877d-02,
     |  -1.1681810696961d-02,-2.2979993393416d-02,-4.0404569927262d-03,
     |   1.8266034862306d-02, 1.5381529408139d-02,-6.0626907894268d-03,
     |  -1.7329886382489d-02,-6.5455977760355d-03, 9.4211763201407d-03,
     |   1.2370177090111d-02, 4.8605609116103d-03, 2.7383069780178d-04/
      data (zmn(lat, 3,28), lat = 1,72)/
     |   7.5151774418179d-06, 1.6517654990852d-03, 8.2947038550338d-03,
     |   1.5348548080827d-02, 1.0645617656528d-02,-6.9784540714065d-03,
     |  -1.9085955720226d-02,-8.4414064159959d-03, 1.4685719590867d-02,
     |   2.0847805417107d-02,-4.1823008387403d-04,-2.3022768432299d-02,
     |  -1.6229842138302d-02, 1.3120457291778d-02, 2.6556541048442d-02,
     |   4.6453262125875d-03,-2.4803616374646d-02,-2.1944111755482d-02,
     |   1.0930817348045d-02, 3.0313153562488d-02, 9.1822374653470d-03,
     |  -2.5182667392400d-02,-2.6418221602080d-02, 8.2130997120724d-03,
     |   3.2609040108134d-02, 1.3339724630732d-02,-2.4441071163559d-02,
     |  -2.9821453683129d-02, 5.0898842282541d-03, 3.3634427150879d-02,
     |   1.7057129939771d-02,-2.2740465672037d-02,-3.2185365721824d-02,
     |   1.7259954127872d-03, 3.3469130550631d-02, 2.0237058616389d-02,
     |  -2.0237058616389d-02,-3.3469130550631d-02,-1.7259954127873d-03,
     |   3.2185365721824d-02, 2.2740465672037d-02,-1.7057129939771d-02,
     |  -3.3634427150879d-02,-5.0898842282544d-03, 2.9821453683129d-02,
     |   2.4441071163559d-02,-1.3339724630732d-02,-3.2609040108134d-02,
     |  -8.2130997120726d-03, 2.6418221602080d-02, 2.5182667392400d-02,
     |  -9.1822374653464d-03,-3.0313153562488d-02,-1.0930817348045d-02,
     |   2.1944111755482d-02, 2.4803616374646d-02,-4.6453262125873d-03,
     |  -2.6556541048442d-02,-1.3120457291778d-02, 1.6229842138302d-02,
     |   2.3022768432299d-02, 4.1823008387392d-04,-2.0847805417107d-02,
     |  -1.4685719590867d-02, 8.4414064159958d-03, 1.9085955720226d-02,
     |   6.9784540714065d-03,-1.0645617656528d-02,-1.5348548080827d-02,
     |  -8.2947038550336d-03,-1.6517654990852d-03,-7.5151774417941d-06/
      data (zmn(lat, 4,28), lat = 1,72)/
     |   7.4648275017795d-07, 3.9977284283527d-04, 3.6904160307311d-03,
     |   1.1668890294032d-02, 1.7945438776636d-02, 1.1326985183127d-02,
     |  -7.7900607734266d-03,-2.0727332308627d-02,-1.0312029523216d-02,
     |   1.4096403553548d-02, 2.2895062791645d-02, 2.8153665673985d-03,
     |  -2.2533907721085d-02,-1.9985931630258d-02, 9.2192983473349d-03,
     |   2.7891590532108d-02, 1.0349672759087d-02,-2.1907823276970d-02,
     |  -2.6285640427229d-02, 4.4112493189870d-03, 3.0360440497510d-02,
     |   1.6441199916496d-02,-2.0013402104574d-02,-3.0635997907097d-02,
     |  -3.7220945642658d-04, 3.1115150066513d-02, 2.1480309798966d-02,
     |  -1.7184532633350d-02,-3.3435090432275d-02,-5.0631259424894d-03,
     |   3.0457465847927d-02, 2.5534294528994d-02,-1.3631917033656d-02,
     |  -3.4813464517115d-02,-9.5350586549546d-03, 2.8556994989341d-02,
     |   2.8556994989341d-02,-9.5350586549545d-03,-3.4813464517115d-02,
     |  -1.3631917033656d-02, 2.5534294528994d-02, 3.0457465847927d-02,
     |  -5.0631259424893d-03,-3.3435090432275d-02,-1.7184532633350d-02,
     |   2.1480309798966d-02, 3.1115150066513d-02,-3.7220945642622d-04,
     |  -3.0635997907097d-02,-2.0013402104574d-02, 1.6441199916496d-02,
     |   3.0360440497510d-02, 4.4112493189871d-03,-2.6285640427229d-02,
     |  -2.1907823276970d-02, 1.0349672759086d-02, 2.7891590532108d-02,
     |   9.2192983473347d-03,-1.9985931630258d-02,-2.2533907721085d-02,
     |   2.8153665673985d-03, 2.2895062791645d-02, 1.4096403553548d-02,
     |  -1.0312029523216d-02,-2.0727332308627d-02,-7.7900607734263d-03,
     |   1.1326985183127d-02, 1.7945438776636d-02, 1.1668890294032d-02,
     |   3.6904160307311d-03, 3.9977284283512d-04, 7.4648275022237d-07/
      data (zmn(lat, 5,28), lat = 1,72)/
     |   9.4201633494931d-07, 7.4992305671792d-05, 1.2412303206692d-03,
     |   6.1268235433760d-03, 1.4945524878526d-02, 2.0173465566921d-02,
     |   1.1583402157089d-02,-8.8724321141424d-03,-2.2298954665655d-02,
     |  -1.1844659175723d-02, 1.3616684721348d-02, 2.4598769140580d-02,
     |   5.7541735454564d-03,-2.1688071776996d-02,-2.3117308671049d-02,
     |   5.2114271560156d-03, 2.8282138130996d-02, 1.5550367674836d-02,
     |  -1.8140148467661d-02,-2.9364928785592d-02,-2.3030251451148d-03,
     |   2.8737662202192d-02, 2.2748705083944d-02,-1.3537888897328d-02,
     |  -3.2832596163766d-02,-9.0438117790294d-03, 2.7249743989659d-02,
     |   2.8073243606855d-02,-8.3431037335424d-03,-3.4222153877488d-02,
     |  -1.5025673995125d-02, 2.4300077886710d-02, 3.1749842793342d-02,
     |  -2.8172862684676d-03,-3.3816627931499d-02,-2.0160647544439d-02,
     |   2.0160647544439d-02, 3.3816627931499d-02, 2.8172862684677d-03,
     |  -3.1749842793342d-02,-2.4300077886710d-02, 1.5025673995125d-02,
     |   3.4222153877488d-02, 8.3431037335427d-03,-2.8073243606855d-02,
     |  -2.7249743989659d-02, 9.0438117790294d-03, 3.2832596163766d-02,
     |   1.3537888897328d-02,-2.2748705083944d-02,-2.8737662202192d-02,
     |   2.3030251451142d-03, 2.9364928785592d-02, 1.8140148467661d-02,
     |  -1.5550367674836d-02,-2.8282138130996d-02,-5.2114271560157d-03,
     |   2.3117308671049d-02, 2.1688071776995d-02,-5.7541735454561d-03,
     |  -2.4598769140580d-02,-1.3616684721348d-02, 1.1844659175723d-02,
     |   2.2298954665654d-02, 8.8724321141425d-03,-1.1583402157089d-02,
     |  -2.0173465566921d-02,-1.4945524878526d-02,-6.1268235433760d-03,
     |  -1.2412303206693d-03,-7.4992305671719d-05,-9.4201633490384d-07/
      data (zmn(lat, 6,28), lat = 1,72)/
     |   4.2110608327401d-08, 1.1705938238084d-05, 3.3602973145483d-04,
     |   2.4936289112400d-03, 8.8072386360599d-03, 1.8083379974886d-02,
     |   2.2049914601414d-02, 1.1513685911362d-02,-1.0128406145024d-02,
     |  -2.3811748959937d-02,-1.3167636510401d-02, 1.3201177711814d-02,
     |   2.6067967422632d-02, 8.5066577544226d-03,-2.0552894648330d-02,
     |  -2.5746960197742d-02, 1.1164312906834d-03, 2.7856675308012d-02,
     |   2.0243007899600d-02,-1.3648106453139d-02,-3.1215177645699d-02,
     |  -9.0106637396324d-03, 2.5576325006719d-02, 2.7893776533138d-02,
     |  -6.0668786852913d-03,-3.2908168608295d-02,-1.7329678668935d-02,
     |   2.1198125867119d-02, 3.2635324565137d-02, 1.5284907345308d-03,
     |  -3.1966472595132d-02,-2.3968488257787d-02, 1.5466256305270d-02,
     |   3.4925050137938d-02, 8.8032058084023d-03,-2.8896307859672d-02,
     |  -2.8896307859672d-02, 8.8032058084022d-03, 3.4925050137938d-02,
     |   1.5466256305270d-02,-2.3968488257787d-02,-3.1966472595132d-02,
     |   1.5284907345307d-03, 3.2635324565137d-02, 2.1198125867119d-02,
     |  -1.7329678668935d-02,-3.2908168608295d-02,-6.0668786852916d-03,
     |   2.7893776533138d-02, 2.5576325006719d-02,-9.0106637396324d-03,
     |  -3.1215177645699d-02,-1.3648106453140d-02, 2.0243007899600d-02,
     |   2.7856675308012d-02, 1.1164312906836d-03,-2.5746960197742d-02,
     |  -2.0552894648330d-02, 8.5066577544228d-03, 2.6067967422632d-02,
     |   1.3201177711814d-02,-1.3167636510401d-02,-2.3811748959938d-02,
     |  -1.0128406145024d-02, 1.1513685911362d-02, 2.2049914601414d-02,
     |   1.8083379974886d-02, 8.8072386360600d-03, 2.4936289112401d-03,
     |   3.3602973145479d-04, 1.1705938238252d-05, 4.2110608319243d-08/
      data (zmn(lat, 7,28), lat = 1,72)/
     |  -3.5490926153604d-08, 1.5810936507852d-06, 7.6085791206097d-05,
     |   8.3182124295329d-04, 4.0861245786383d-03, 1.1628212384323d-02,
     |   2.1041533337204d-02, 2.3609157186705d-02, 1.1208894217721d-02,
     |  -1.1466080761679d-02,-2.5269287013611d-02,-1.4383928302749d-02,
     |   1.2778722067866d-02, 2.7361906731030d-02, 1.1174988973816d-02,
     |  -1.9124973921551d-02,-2.7951058501612d-02,-3.0870880620659d-03,
     |   2.6661249593799d-02, 2.4416759247822d-02,-8.5131146632183d-03,
     |  -3.1817955896581d-02,-1.5534825841751d-02, 2.0962695556962d-02,
     |   3.1648156658879d-02, 2.0959112617530d-03,-3.0758714890180d-02,
     |  -2.4726328141127d-02, 1.3198710201172d-02, 3.4680372522490d-02,
     |   1.1759696840567d-02,-2.6550537319421d-02,-3.0966767961224d-02,
     |   4.4931594773901d-03, 3.4328715086157d-02, 2.0044388684599d-02,
     |  -2.0044388684599d-02,-3.4328715086158d-02,-4.4931594773902d-03,
     |   3.0966767961224d-02, 2.6550537319421d-02,-1.1759696840567d-02,
     |  -3.4680372522490d-02,-1.3198710201173d-02, 2.4726328141127d-02,
     |   3.0758714890180d-02,-2.0959112617530d-03,-3.1648156658879d-02,
     |  -2.0962695556962d-02, 1.5534825841751d-02, 3.1817955896581d-02,
     |   8.5131146632188d-03,-2.4416759247822d-02,-2.6661249593799d-02,
     |   3.0870880620659d-03, 2.7951058501612d-02, 1.9124973921551d-02,
     |  -1.1174988973816d-02,-2.7361906731030d-02,-1.2778722067867d-02,
     |   1.4383928302749d-02, 2.5269287013611d-02, 1.1466080761679d-02,
     |  -1.1208894217721d-02,-2.3609157186705d-02,-2.1041533337205d-02,
     |  -1.1628212384323d-02,-4.0861245786383d-03,-8.3182124295326d-04,
     |  -7.6085791205963d-05,-1.5810936508126d-06, 3.5490926118766d-08/
      data (zmn(lat, 8,28), lat = 1,72)/
     |  -1.1130747031406d-09, 1.7942389935778d-07, 1.4787848277202d-05,
     |   2.3506532600079d-04, 1.5713275771199d-03, 5.9461677645659d-03,
     |   1.4504387356726d-02, 2.3793435870995d-02, 2.4898077080324d-02,
     |   1.0762758081051d-02,-1.2801624836039d-02,-2.6672660515500d-02,
     |  -1.5585642852031d-02, 1.2265622756780d-02, 2.8502568248673d-02,
     |   1.3850993957706d-02,-1.7355165172132d-02,-2.9755439157598d-02,
     |  -7.4340963727061d-03, 2.4676808276919d-02, 2.8023959324774d-02,
     |  -2.7852996225201d-03,-3.1097300852464d-02,-2.1673929665335d-02,
     |   1.4963497647860d-02, 3.3737744541609d-02, 1.0598154751743d-02,
     |  -2.6289506724063d-02,-3.0654824055562d-02, 3.6043647634977d-03,
     |   3.3726297102641d-02, 2.1500326067536d-02,-1.8035653899144d-02,
     |  -3.4996393505806d-02,-7.7386862535100d-03, 2.9385336456888d-02,
     |   2.9385336456888d-02,-7.7386862535099d-03,-3.4996393505806d-02,
     |  -1.8035653899144d-02, 2.1500326067536d-02, 3.3726297102640d-02,
     |   3.6043647634978d-03,-3.0654824055562d-02,-2.6289506724063d-02,
     |   1.0598154751743d-02, 3.3737744541609d-02, 1.4963497647860d-02,
     |  -2.1673929665335d-02,-3.1097300852464d-02,-2.7852996225202d-03,
     |   2.8023959324774d-02, 2.4676808276919d-02,-7.4340963727060d-03,
     |  -2.9755439157598d-02,-1.7355165172132d-02, 1.3850993957706d-02,
     |   2.8502568248673d-02, 1.2265622756780d-02,-1.5585642852031d-02,
     |  -2.6672660515500d-02,-1.2801624836039d-02, 1.0762758081051d-02,
     |   2.4898077080324d-02, 2.3793435870996d-02, 1.4504387356727d-02,
     |   5.9461677645660d-03, 1.5713275771200d-03, 2.3506532600070d-04,
     |   1.4787848277265d-05, 1.7942389918729d-07,-1.1130747136445d-09/
      data (zmn(lat, 9,28), lat = 1,72)/
     |   1.4569154381744d-09, 1.6425069494765d-08, 2.5106348496477d-06,
     |   5.7520262287246d-05, 5.1625240890833d-04, 2.5393155542495d-03,
     |   8.0009783814928d-03, 1.7363815523833d-02, 2.6328440965507d-02,
     |   2.5976193969262d-02, 1.0272579269649d-02,-1.4057034567904d-02,
     |  -2.8022940559701d-02,-1.6859173609004d-02, 1.1568604063025d-02,
     |   2.9481284990809d-02, 1.6611827336097d-02,-1.5161816049094d-02,
     |  -3.1133724507678d-02,-1.1950696212956d-02, 2.1833577386601d-02,
     |   3.0958895538176d-02, 3.4805110909848d-03,-2.8923774401964d-02,
     |  -2.7160021622186d-02, 7.6673297321971d-03, 3.3832279757895d-02,
     |   1.8979082493588d-02,-1.9461102400830d-02,-3.4435366686569d-02,
     |  -7.0321060902750d-03, 2.9351462170158d-02, 2.9667012346097d-02,
     |  -6.7957723866415d-03,-3.4996188701948d-02,-1.9882791530092d-02,
     |   1.9882791530092d-02, 3.4996188701948d-02, 6.7957723866416d-03,
     |  -2.9667012346097d-02,-2.9351462170158d-02, 7.0321060902752d-03,
     |   3.4435366686569d-02, 1.9461102400831d-02,-1.8979082493588d-02,
     |  -3.3832279757895d-02,-7.6673297321972d-03, 2.7160021622186d-02,
     |   2.8923774401964d-02,-3.4805110909849d-03,-3.0958895538176d-02,
     |  -2.1833577386601d-02, 1.1950696212955d-02, 3.1133724507678d-02,
     |   1.5161816049094d-02,-1.6611827336097d-02,-2.9481284990809d-02,
     |  -1.1568604063025d-02, 1.6859173609004d-02, 2.8022940559701d-02,
     |   1.4057034567905d-02,-1.0272579269649d-02,-2.5976193969262d-02,
     |  -2.6328440965507d-02,-1.7363815523833d-02,-8.0009783814927d-03,
     |  -2.5393155542493d-03,-5.1625240890841d-04,-5.7520262287288d-05,
     |  -2.5106348497440d-06,-1.6425069475827d-08,-1.4569154479979d-09/
      data (zmn(lat,10,28), lat = 1,72)/
     |   3.4705131487203d-11, 1.4807049056674d-09, 3.7669110169993d-07,
     |   1.2377307025241d-05, 1.4781895172086d-04, 9.3184502376592d-04,
     |   3.7044934556997d-03, 1.0178145824575d-02, 2.0147390089574d-02,
     |   2.8651164220919d-02, 2.6914528474023d-02, 9.8387667030717d-03,
     |  -1.5157075888076d-02,-2.9319945502485d-02,-1.8286420991705d-02,
     |   1.0584451346494d-02, 3.0259345550311d-02, 1.9514181044196d-02,
     |  -1.2439265195217d-02,-3.2003294294614d-02,-1.6632445190768d-02,
     |   1.8026324753959d-02, 3.3040453065903d-02, 1.0184937481216d-02,
     |  -2.5130579640370d-02,-3.1622779413668d-02,-7.5708514916388d-04,
     |   3.1559367261200d-02, 2.6609194378593d-02,-1.0372705968629d-02,
     |  -3.5296831363088d-02,-1.7855616957618d-02, 2.1317938746057d-02,
     |   3.4931379609840d-02, 6.2979819715289d-03,-3.0040008706738d-02,
     |  -3.0040008706739d-02, 6.2979819715287d-03, 3.4931379609840d-02,
     |   2.1317938746057d-02,-1.7855616957618d-02,-3.5296831363088d-02,
     |  -1.0372705968629d-02, 2.6609194378593d-02, 3.1559367261200d-02,
     |  -7.5708514916374d-04,-3.1622779413668d-02,-2.5130579640370d-02,
     |   1.0184937481216d-02, 3.3040453065903d-02, 1.8026324753959d-02,
     |  -1.6632445190767d-02,-3.2003294294614d-02,-1.2439265195217d-02,
     |   1.9514181044196d-02, 3.0259345550311d-02, 1.0584451346495d-02,
     |  -1.8286420991705d-02,-2.9319945502485d-02,-1.5157075888076d-02,
     |   9.8387667030716d-03, 2.6914528474023d-02, 2.8651164220919d-02,
     |   2.0147390089574d-02, 1.0178145824575d-02, 3.7044934556995d-03,
     |   9.3184502376594d-04, 1.4781895172068d-04, 1.2377307025327d-05,
     |   3.7669110167791d-07, 1.4807050967779d-09, 3.4705144678570d-11/
      data (zmn(lat,11,28), lat = 1,72)/
     |  -5.5758964967905d-11, 1.7442831925786d-10, 5.0416311298555d-08,
     |   2.3685150221702d-06, 3.7402693178129d-05, 2.9934252071822d-04,
     |   1.4796626716573d-03, 5.0239239123647d-03, 1.2407183447017d-02,
     |   2.2808310837246d-02, 3.0779837888191d-02, 2.7793151211085d-02,
     |   9.5645809395342d-03,-1.6025533031314d-02,-3.0557880541379d-02,
     |  -1.9943352976869d-02, 9.1987190368565d-03, 3.0763757741914d-02,
     |   2.2585336090496d-02,-9.0660224149486d-03,-3.2218884472294d-02,
     |  -2.1419599866457d-02, 1.3135054109631d-02, 3.3998162241107d-02,
     |   1.7136982392596d-02,-1.9547411002111d-02,-3.4562296446552d-02,
     |  -9.9834267444376d-03, 2.6554653059152d-02, 3.2640260340835d-02,
     |   6.1186395665775d-04,-3.2447645919725d-02,-2.7609874798572d-02,
     |   9.7796637682561d-03, 3.5802805365018d-02, 1.9669246444626d-02,
     |  -1.9669246444626d-02,-3.5802805365018d-02,-9.7796637682562d-03,
     |   2.7609874798572d-02, 3.2447645919725d-02,-6.1186395665793d-04,
     |  -3.2640260340835d-02,-2.6554653059152d-02, 9.9834267444376d-03,
     |   3.4562296446552d-02, 1.9547411002111d-02,-1.7136982392596d-02,
     |  -3.3998162241107d-02,-1.3135054109631d-02, 2.1419599866457d-02,
     |   3.2218884472295d-02, 9.0660224149487d-03,-2.2585336090496d-02,
     |  -3.0763757741915d-02,-9.1987190368566d-03, 1.9943352976869d-02,
     |   3.0557880541379d-02, 1.6025533031314d-02,-9.5645809395342d-03,
     |  -2.7793151211086d-02,-3.0779837888191d-02,-2.2808310837246d-02,
     |  -1.2407183447017d-02,-5.0239239123646d-03,-1.4796626716573d-03,
     |  -2.9934252071837d-04,-3.7402693178172d-05,-2.3685150220613d-06,
     |  -5.0416311274197d-08,-1.7442828809381d-10, 5.5759043500837d-11/
      data (zmn(lat,12,28), lat = 1,72)/
     |  -1.0409522111159d-12, 1.1628410901557d-11, 6.0781456997305d-09,
     |   4.0643079180746d-07, 8.4478957495170d-06, 8.5261954381985d-05,
     |   5.1889942582809d-04, 2.1447103497708d-03, 6.4463266902847d-03,
     |   1.4620943201084d-02, 2.5310971133853d-02, 3.2743424428807d-02,
     |   2.8698055341320d-02, 9.5561662556039d-03,-1.6580298861395d-02,
     |  -3.1718369885170d-02,-2.1895664609734d-02, 7.2847696072004d-03,
     |   3.0879485863251d-02, 2.5809184220336d-02,-4.9163687873411d-03,
     |  -3.1565731795384d-02,-2.6166228686006d-02, 7.0568529508331d-03,
     |   3.3465695134032d-02, 2.3997595044553d-02,-1.2060978932194d-02,
     |  -3.5341205439567d-02,-1.9431370252679d-02, 1.8565564008080d-02,
     |   3.5989579370868d-02, 1.2696966553447d-02,-2.5245238079510d-02,
     |  -3.4588346708794d-02,-4.4192804720483d-03, 3.0884168358665d-02,
     |   3.0884168358665d-02,-4.4192804720482d-03,-3.4588346708794d-02,
     |  -2.5245238079510d-02, 1.2696966553447d-02, 3.5989579370868d-02,
     |   1.8565564008080d-02,-1.9431370252678d-02,-3.5341205439567d-02,
     |  -1.2060978932194d-02, 2.3997595044553d-02, 3.3465695134032d-02,
     |   7.0568529508332d-03,-2.6166228686006d-02,-3.1565731795384d-02,
     |  -4.9163687873416d-03, 2.5809184220336d-02, 3.0879485863252d-02,
     |   7.2847696072006d-03,-2.1895664609734d-02,-3.1718369885170d-02,
     |  -1.6580298861395d-02, 9.5561662556039d-03, 2.8698055341320d-02,
     |   3.2743424428807d-02, 2.5310971133853d-02, 1.4620943201084d-02,
     |   6.4463266902846d-03, 2.1447103497709d-03, 5.1889942582817d-04,
     |   8.5261954381988d-05, 8.4478957497138d-06, 4.0643079172322d-07,
     |   6.0781456836770d-09, 1.1628293393935d-11,-1.0409801797688d-12/
      data (zmn(lat,13,28), lat = 1,72)/
     |   1.9843673263700d-12,-1.2583415560841d-12, 6.6470494098267d-10,
     |   6.2934166317941d-08, 1.7158573288769d-06, 2.1731059580322d-05,
     |   1.6169593558317d-04, 8.0534138281133d-04, 2.9009696799473d-03,
     |   7.9148443449087d-03, 1.6756420075328d-02, 2.7628873851108d-02,
     |   3.4577519008733d-02, 2.9717457824312d-02, 9.9228063431067d-03,
     |  -1.6727281892689d-02,-3.2760825148531d-02,-2.4190776252595d-02,
     |   4.7048413222433d-03, 3.0439440265734d-02, 2.9105574636040d-02,
     |   1.2009671714537d-04,-2.9756156463762d-02,-3.0601886325209d-02,
     |  -2.4363146647813d-04, 3.0991020464164d-02, 3.0216009002270d-02,
     |  -2.7137813616514d-03,-3.3216835812847d-02,-2.8161292269451d-02,
     |   7.6291974687995d-03, 3.5402448091906d-02, 2.4469411127629d-02,
     |  -1.3506507844662d-02,-3.6723270682505d-02,-1.9394349438743d-02,
     |   1.9394349438743d-02, 3.6723270682505d-02, 1.3506507844663d-02,
     |  -2.4469411127629d-02,-3.5402448091906d-02,-7.6291974687994d-03,
     |   2.8161292269451d-02, 3.3216835812847d-02, 2.7137813616515d-03,
     |  -3.0216009002270d-02,-3.0991020464164d-02, 2.4363146647786d-04,
     |   3.0601886325209d-02, 2.9756156463762d-02,-1.2009671714536d-04,
     |  -2.9105574636040d-02,-3.0439440265734d-02,-4.7048413222433d-03,
     |   2.4190776252595d-02, 3.2760825148531d-02, 1.6727281892689d-02,
     |  -9.9228063431067d-03,-2.9717457824312d-02,-3.4577519008733d-02,
     |  -2.7628873851108d-02,-1.6756420075329d-02,-7.9148443449088d-03,
     |  -2.9009696799472d-03,-8.0534138281133d-04,-1.6169593558319d-04,
     |  -2.1731059580280d-05,-1.7158573289121d-06,-6.2934166475155d-08,
     |  -6.6470486326217d-10, 1.2583562865549d-12,-1.9843970706196d-12/
      data (zmn(lat,14,28), lat = 1,72)/
     |   2.9559678282155d-14,-4.6359620340990d-14, 6.5780008137012d-11,
     |   8.8354254307178d-09, 3.1510862721811d-07, 4.9890412324896d-06,
     |   4.5151117824925d-05, 2.6902812403807d-04, 1.1493751474537d-03,
     |   3.7133876842143d-03, 9.3693155040876d-03, 1.8754714721082d-02,
     |   2.9741384541760d-02, 3.6319053399508d-02, 3.0937331631920d-02,
     |   1.0777012163730d-02,-1.6353434778851d-02,-3.3609888953686d-02,
     |  -2.6844802219787d-02, 1.3157011622719d-03, 2.9214275935529d-02,
     |   3.2301719779217d-02, 6.1052007196930d-03,-2.6436676627547d-02,
     |  -3.4287730103963d-02,-8.6565726907940d-03, 2.6079537747484d-02,
     |   3.4969914520778d-02, 8.1482879892814d-03,-2.7447445866671d-02,
     |  -3.4790906415216d-02,-5.6617745487149d-03, 2.9662181650065d-02,
     |   3.3762604281978d-02, 2.0162542137665d-03,-3.1953381457595d-02,
     |  -3.1953381457595d-02, 2.0162542137664d-03, 3.3762604281978d-02,
     |   2.9662181650065d-02,-5.6617745487148d-03,-3.4790906415216d-02,
     |  -2.7447445866671d-02, 8.1482879892811d-03, 3.4969914520778d-02,
     |   2.6079537747484d-02,-8.6565726907938d-03,-3.4287730103963d-02,
     |  -2.6436676627547d-02, 6.1052007196931d-03, 3.2301719779217d-02,
     |   2.9214275935529d-02, 1.3157011622720d-03,-2.6844802219787d-02,
     |  -3.3609888953687d-02,-1.6353434778851d-02, 1.0777012163730d-02,
     |   3.0937331631920d-02, 3.6319053399508d-02, 2.9741384541760d-02,
     |   1.8754714721082d-02, 9.3693155040878d-03, 3.7133876842142d-03,
     |   1.1493751474538d-03, 2.6902812403809d-04, 4.5151117824893d-05,
     |   4.9890412324194d-06, 3.1510862708498d-07, 8.8354255444283d-09,
     |   6.5780136938884d-11,-4.6410522275275d-14, 2.9530038164304d-14/
      data (zmn(lat,15,28), lat = 1,72)/
     |  -6.4640772278097d-14, 6.2656929164058d-14, 5.8690423799588d-12,
     |   1.1283880601601d-09, 5.2525870168871d-08, 1.0365931651362d-06,
     |   1.1364887213169d-05, 8.0575201310587d-05, 4.0526317769227d-04,
     |   1.5340844144989d-03, 4.5399900451334d-03, 1.0748018569414d-02,
     |   2.0560056449149d-02, 3.1629284180598d-02, 3.7999709947109d-02,
     |   3.2435692936767d-02, 1.2233594786953d-02,-1.5319646857910d-02,
     |  -3.4139787708780d-02,-2.9822533920605d-02,-3.0172349603289d-03,
     |   2.6905885516286d-02, 3.5095645211253d-02, 1.2998229750206d-02,
     |  -2.1217660303821d-02,-3.6575253475268d-02,-1.7815200722745d-02,
     |   1.8295347354700d-02, 3.7137052802662d-02, 1.9678975172474d-02,
     |  -1.7519915864355d-02,-3.7501613944665d-02,-1.9821936090582d-02,
     |   1.8036732212905d-02, 3.7718405597719d-02, 1.9044584953619d-02,
     |  -1.9044584953619d-02,-3.7718405597719d-02,-1.8036732212905d-02,
     |   1.9821936090582d-02, 3.7501613944665d-02, 1.7519915864355d-02,
     |  -1.9678975172474d-02,-3.7137052802662d-02,-1.8295347354701d-02,
     |   1.7815200722745d-02, 3.6575253475268d-02, 2.1217660303821d-02,
     |  -1.2998229750206d-02,-3.5095645211253d-02,-2.6905885516286d-02,
     |   3.0172349603285d-03, 2.9822533920605d-02, 3.4139787708780d-02,
     |   1.5319646857911d-02,-1.2233594786953d-02,-3.2435692936767d-02,
     |  -3.7999709947109d-02,-3.1629284180598d-02,-2.0560056449149d-02,
     |  -1.0748018569414d-02,-4.5399900451334d-03,-1.5340844144988d-03,
     |  -4.0526317769229d-04,-8.0575201310546d-05,-1.1364887213149d-05,
     |  -1.0365931652182d-06,-5.2525870118677d-08,-1.1283879503913d-09,
     |  -5.8691527055488d-12,-6.2669268281828d-14, 6.4588736500282d-14/
      data (zmn(lat,16,28), lat = 1,72)/
     |  -7.7922875347748d-16, 2.2020752300043d-15, 4.8460491600978d-13,
     |   1.3136148589677d-10, 7.9678895541761d-09, 1.9553972613876d-07,
     |   2.5890513610744d-06, 2.1751343089610d-05, 1.2808157050741d-04,
     |   5.6377925016023d-04, 1.9360285425499d-03, 5.3340404218199d-03,
     |   1.1988883585083d-02, 2.2117936181206d-02, 3.3269187136872d-02,
     |   3.9637857189883d-02, 3.4274842927894d-02, 1.4406292427115d-02,
     |  -1.3454983673793d-02,-3.4155947115140d-02,-3.3008143792975d-02,
     |  -8.3916293347526d-03, 2.3151757705324d-02, 3.7014899549006d-02,
     |   2.0574097569091d-02,-1.3744164245770d-02,-3.6587498200127d-02,
     |  -2.6950858147832d-02, 7.4536787443649d-03, 3.5352922134962d-02,
     |   3.0314021690825d-02,-3.5486142433748d-03,-3.4257016700749d-02,
     |  -3.2158875269653d-02, 1.0325775238150d-03, 3.3301867809751d-02,
     |   3.3301867809751d-02, 1.0325775238151d-03,-3.2158875269653d-02,
     |  -3.4257016700749d-02,-3.5486142433748d-03, 3.0314021690825d-02,
     |   3.5352922134962d-02, 7.4536787443652d-03,-2.6950858147832d-02,
     |  -3.6587498200127d-02,-1.3744164245770d-02, 2.0574097569090d-02,
     |   3.7014899549006d-02, 2.3151757705324d-02,-8.3916293347526d-03,
     |  -3.3008143792975d-02,-3.4155947115140d-02,-1.3454983673793d-02,
     |   1.4406292427115d-02, 3.4274842927894d-02, 3.9637857189883d-02,
     |   3.3269187136872d-02, 2.2117936181206d-02, 1.1988883585084d-02,
     |   5.3340404218199d-03, 1.9360285425497d-03, 5.6377925016027d-04,
     |   1.2808157050744d-04, 2.1751343089649d-05, 2.5890513611364d-06,
     |   1.9553972622337d-07, 7.9678895983524d-09, 1.3136141552294d-10,
     |   4.8448018979658d-13, 2.2891348555305d-15,-7.5464508595406d-16/
      data (zmn(lat,17,28), lat = 1,72)/
     |   1.8580508581675d-15,-1.8573033315747d-15, 3.8302144114178d-14,
     |   1.3954551424498d-11, 1.1015058641958d-09, 3.3550991773677d-08,
     |   5.3514648059652d-07, 5.3102027884107d-06, 3.6452230588495d-05,
     |   1.8552378202548d-04, 7.3359947101631d-04, 2.3268144415904d-03,
     |   6.0462075145942d-03, 1.3030270730199d-02, 2.3372567821669d-02,
     |   3.4627007514287d-02, 4.1228765772825d-02, 3.6490429909725d-02,
     |   1.7399762134616d-02,-1.0554976999543d-02,-3.3375519764949d-02,
     |  -3.6164674803948d-02,-1.4818096036881d-02, 1.7552606533409d-02,
     |   3.7380632151479d-02, 2.8309827393205d-02,-3.8336800254338d-03,
     |  -3.3262074575615d-02,-3.4737358487601d-02,-6.0638286869702d-03,
     |   2.8246306565063d-02, 3.7624765079753d-02, 1.3140028400087d-02,
     |  -2.3413428940014d-02,-3.8726706643154d-02,-1.8600107793891d-02,
     |   1.8600107793890d-02, 3.8726706643154d-02, 2.3413428940014d-02,
     |  -1.3140028400087d-02,-3.7624765079753d-02,-2.8246306565063d-02,
     |   6.0638286869700d-03, 3.4737358487601d-02, 3.3262074575615d-02,
     |   3.8336800254339d-03,-2.8309827393205d-02,-3.7380632151479d-02,
     |  -1.7552606533409d-02, 1.4818096036881d-02, 3.6164674803948d-02,
     |   3.3375519764949d-02, 1.0554976999543d-02,-1.7399762134616d-02,
     |  -3.6490429909725d-02,-4.1228765772825d-02,-3.4627007514287d-02,
     |  -2.3372567821669d-02,-1.3030270730199d-02,-6.0462075145942d-03,
     |  -2.3268144415904d-03,-7.3359947101621d-04,-1.8552378202554d-04,
     |  -3.6452230588410d-05,-5.3102027883860d-06,-5.3514648054674d-07,
     |  -3.3550991785785d-08,-1.1015058981395d-09,-1.3954589930152d-11,
     |  -3.8182047056370d-14, 1.8845524870733d-15,-1.7887941689231d-15/
      data (zmn(lat,18,28), lat = 1,72)/
     |   3.2085354509822d-18,-9.9230102118739d-17, 2.5241519370439d-15,
     |   1.3531082810661d-12, 1.3881416638978d-10, 5.2395865771621d-09,
     |   1.0047070063567d-07, 1.1744439727269d-06, 9.3668885662062d-06,
     |   5.4881980543201d-05, 2.4845733349666d-04, 9.0020776125922d-04,
     |   2.6750666369633d-03, 6.6267773357810d-03, 1.3811562143719d-02,
     |   2.4264106532415d-02, 3.5650853905235d-02, 4.2732936153829d-02,
     |   3.9075943743607d-02, 2.1293819655416d-02,-6.3885730212967d-03,
     |  -3.1411108018968d-02,-3.8882349759927d-02,-2.2139169857881d-02,
     |   9.7430084828694d-03, 3.5300042454948d-02, 3.5247077453240d-02,
     |   8.2906826115074d-03,-2.5523064876164d-02,-3.9192825015263d-02,
     |  -2.0868801458514d-02, 1.4977894275530d-02, 3.8446126062334d-02,
     |   2.9346018161252d-02,-4.9032791402621d-03,-3.5015961366593d-02,
     |  -3.5015961366593d-02,-4.9032791402621d-03, 2.9346018161252d-02,
     |   3.8446126062334d-02, 1.4977894275530d-02,-2.0868801458514d-02,
     |  -3.9192825015263d-02,-2.5523064876165d-02, 8.2906826115074d-03,
     |   3.5247077453240d-02, 3.5300042454948d-02, 9.7430084828697d-03,
     |  -2.2139169857881d-02,-3.8882349759927d-02,-3.1411108018968d-02,
     |  -6.3885730212970d-03, 2.1293819655416d-02, 3.9075943743607d-02,
     |   4.2732936153829d-02, 3.5650853905235d-02, 2.4264106532415d-02,
     |   1.3811562143719d-02, 6.6267773357810d-03, 2.6750666369633d-03,
     |   9.0020776125925d-04, 2.4845733349674d-04, 5.4881980543183d-05,
     |   9.3668885661057d-06, 1.1744439727213d-06, 1.0047070070096d-07,
     |   5.2395865711992d-09, 1.3881419728184d-10, 1.3530780917983d-12,
     |   2.5313431201575d-15,-8.7174875273488d-17,-2.0189173440158d-17/
      data (zmn(lat,19,28), lat = 1,72)/
     |  -1.4141317822240d-16,-1.7342553094306d-16,-9.0790689301448d-17,
     |   1.1960508359127d-13, 1.5933812128536d-11, 7.4431334602706d-10,
     |   1.7129305413461d-08, 2.3537256327614d-07, 2.1751557409536d-06,
     |   1.4621294598253d-05, 7.5447679769364d-05, 3.1046118717149d-04,
     |   1.0468592111359d-03, 2.9487575929443d-03, 7.0280489841934d-03,
     |   1.4273999402478d-02, 2.4726332902839d-02, 3.6264090413866d-02,
     |   4.4062712645109d-02, 4.1961275155798d-02, 2.6115860447623d-02,
     |  -7.2107526388624d-04,-2.7766711934978d-02,-4.0520971600402d-02,
     |  -2.9909818709651d-02,-4.6697879335171d-04, 2.9731500406026d-02,
     |   3.9866189400345d-02, 2.1656267256234d-02,-1.2677864320312d-02,
     |  -3.7787857577851d-02,-3.4091853853037d-02,-3.8077631591047d-03,
     |   2.9630451511631d-02, 3.9648828569293d-02, 1.8030560776778d-02,
     |  -1.8030560776777d-02,-3.9648828569293d-02,-2.9630451511631d-02,
     |   3.8077631591045d-03, 3.4091853853037d-02, 3.7787857577851d-02,
     |   1.2677864320312d-02,-2.1656267256233d-02,-3.9866189400345d-02,
     |  -2.9731500406026d-02, 4.6697879335158d-04, 2.9909818709651d-02,
     |   4.0520971600402d-02, 2.7766711934978d-02, 7.2107526388625d-04,
     |  -2.6115860447623d-02,-4.1961275155798d-02,-4.4062712645109d-02,
     |  -3.6264090413866d-02,-2.4726332902839d-02,-1.4273999402478d-02,
     |  -7.0280489841933d-03,-2.9487575929443d-03,-1.0468592111360d-03,
     |  -3.1046118717152d-04,-7.5447679769443d-05,-1.4621294598178d-05,
     |  -2.1751557409887d-06,-2.3537256327766d-07,-1.7129305431150d-08,
     |  -7.4431325124114d-10,-1.5933788907393d-11,-1.1960115977827d-13,
     |   4.7702629437898d-17, 1.9860342850627d-16, 1.0607655516861d-16/
      data (zmn(lat,20,28), lat = 1,72)/
     |  -1.2156598935053d-18,-2.1117235516318d-18,-2.3078287659270d-18,
     |   9.6102553800798d-15, 1.6623298760365d-12, 9.5995417336658d-11,
     |   2.6476572663932d-09, 4.2690215328022d-08, 4.5610843867489d-07,
     |   3.5076416504172d-06, 2.0558396279905d-05, 9.5648151975832d-05,
     |   3.6384708277639d-04, 1.1563238485357d-03, 3.1179004828898d-03,
     |   7.2071607164430d-03, 1.4362410891423d-02, 2.4685891352403d-02,
     |   3.6359923727334d-02, 4.5068198529925d-02, 4.4984647197066d-02,
     |   3.1796866168574d-02, 6.6361868178840d-03,-2.1862616158605d-02,
     |  -4.0162830287818d-02,-3.7240903575453d-02,-1.2846805860681d-02,
     |   1.9696332569611d-02, 4.0062177502642d-02, 3.4124302149403d-02,
     |   4.8619097985841d-03,-2.8020833223296d-02,-4.1172908927703d-02,
     |  -2.4676631264573d-02, 9.8655678177029d-03, 3.7242856000547d-02,
     |   3.7242856000547d-02, 9.8655678177030d-03,-2.4676631264573d-02,
     |  -4.1172908927703d-02,-2.8020833223296d-02, 4.8619097985842d-03,
     |   3.4124302149403d-02, 4.0062177502643d-02, 1.9696332569611d-02,
     |  -1.2846805860681d-02,-3.7240903575453d-02,-4.0162830287818d-02,
     |  -2.1862616158605d-02, 6.6361868178841d-03, 3.1796866168574d-02,
     |   4.4984647197066d-02, 4.5068198529925d-02, 3.6359923727334d-02,
     |   2.4685891352403d-02, 1.4362410891423d-02, 7.2071607164431d-03,
     |   3.1179004828898d-03, 1.1563238485356d-03, 3.6384708277645d-04,
     |   9.5648151975842d-05, 2.0558396279947d-05, 3.5076416503773d-06,
     |   4.5610843868078d-07, 4.2690215320465d-08, 2.6476571814267d-09,
     |   9.5995364860765d-11, 1.6623280892828d-12, 9.6005841358093d-15,
     |   5.3661100643920d-17,-8.2076391652528d-17,-3.0221813108526d-17/
      data (zmn(lat,21,28), lat = 1,72)/
     |  -2.3934568364386d-17,-7.3059960506686d-17,-1.1603346223808d-16,
     |   5.7762412445856d-16, 1.5699261978331d-13, 1.1201467568202d-11,
     |   3.6982194923097d-10, 6.9865131739325d-09, 8.6139398467223d-08,
     |   7.5614870297855d-07, 5.0195273514176d-06, 2.6310825805820d-05,
     |   1.1240458834183d-04, 4.0071043106908d-04, 1.2129878138909d-03,
     |   3.1576327765981d-03, 7.1296796349637d-03, 1.4028684182692d-02,
     |   2.4064657244176d-02, 3.5799869180455d-02, 4.5525145250024d-02,
     |   4.7859226601925d-02, 3.8107327977605d-02, 1.5735657965600d-02,
     |  -1.3116801546909d-02,-3.6613043547589d-02,-4.2631812610013d-02,
     |  -2.6376284680059d-02, 4.7403432813705d-03, 3.3403600253586d-02,
     |   4.2072547463044d-02, 2.4528436459933d-02,-8.8055906777270d-03,
     |  -3.6565430888155d-02,-4.0316222823789d-02,-1.7286361076573d-02,
     |   1.7286361076573d-02, 4.0316222823788d-02, 3.6565430888155d-02,
     |   8.8055906777271d-03,-2.4528436459933d-02,-4.2072547463044d-02,
     |  -3.3403600253587d-02,-4.7403432813708d-03, 2.6376284680059d-02,
     |   4.2631812610013d-02, 3.6613043547589d-02, 1.3116801546909d-02,
     |  -1.5735657965600d-02,-3.8107327977605d-02,-4.7859226601925d-02,
     |  -4.5525145250025d-02,-3.5799869180455d-02,-2.4064657244176d-02,
     |  -1.4028684182692d-02,-7.1296796349638d-03,-3.1576327765981d-03,
     |  -1.2129878138909d-03,-4.0071043106911d-04,-1.1240458834181d-04,
     |  -2.6310825805838d-05,-5.0195273514166d-06,-7.5614870300408d-07,
     |  -8.6139398507632d-08,-6.9865131842685d-09,-3.6982195758043d-10,
     |  -1.1201505252895d-11,-1.5704517809191d-13,-6.1209690313335d-16,
     |   1.1239346892697d-16, 6.3914795774436d-17, 7.8805185897173d-17/
      data (zmn(lat,22,28), lat = 1,72)/
     |   8.9371065035397d-17, 1.2247887983299d-17,-8.4258291319554d-17,
     |  -1.1230072103148d-16, 1.3208875274778d-14, 1.1760755102284d-12,
     |   4.6434941544525d-11, 1.0265088255191d-09, 1.4582396391813d-08,
     |   1.4583600222637d-07, 1.0939265529282d-06, 6.4416330138077d-06,
     |   3.0796539448295d-05, 1.2259746353625d-04, 4.1423347946526d-04,
     |   1.2052045084770d-03, 3.0517019011553d-03, 6.7743018994108d-03,
     |   1.3237980630111d-02, 2.2787344800015d-02, 3.4419863763011d-02,
     |   4.5130338118300d-02, 5.0140096355701d-02, 4.4573843049406d-02,
     |   2.6349086606875d-02,-1.1225525658464d-03,-2.8516826565804d-02,
     |  -4.3871942404795d-02,-3.8785336209290d-02,-1.4255913796320d-02,
     |   1.7967051004227d-02, 4.0607811352057d-02, 4.0530647632678d-02,
     |   1.7125063493615d-02,-1.6373054473781d-02,-4.0260922903739d-02,
     |  -4.0260922903739d-02,-1.6373054473781d-02, 1.7125063493614d-02,
     |   4.0530647632678d-02, 4.0607811352057d-02, 1.7967051004227d-02,
     |  -1.4255913796320d-02,-3.8785336209289d-02,-4.3871942404795d-02,
     |  -2.8516826565804d-02,-1.1225525658465d-03, 2.6349086606875d-02,
     |   4.4573843049406d-02, 5.0140096355701d-02, 4.5130338118300d-02,
     |   3.4419863763011d-02, 2.2787344800015d-02, 1.3237980630111d-02,
     |   6.7743018994107d-03, 3.0517019011554d-03, 1.2052045084770d-03,
     |   4.1423347946534d-04, 1.2259746353636d-04, 3.0796539448242d-05,
     |   6.4416330138237d-06, 1.0939265528930d-06, 1.4583600227660d-07,
     |   1.4582396375590d-08, 1.0265087906996d-09, 4.6434915770119d-11,
     |   1.1760801734799d-12, 1.3161845484792d-14,-1.0452613425822d-16,
     |  -1.1445175897464d-16, 1.1150061579396d-17, 8.0766815641013d-17/
      data (zmn(lat,23,28), lat = 1,72)/
     |   8.9264961148641d-18, 1.6777795283887d-17, 2.1479993782174d-19,
     |  -4.1986141019816d-17, 9.1812955379720d-16, 1.1009634012432d-13,
     |   5.1992076642734d-12, 1.3435122367626d-10, 2.1961247530720d-09,
     |   2.4981872246015d-08, 2.1133432629003d-07, 1.3947161854540d-06,
     |   7.4403098332649d-06, 3.2957304792886d-05, 1.2374057083614d-04,
     |   4.0009834371743d-04, 1.1277214036939d-03, 2.7962608060546d-03,
     |   6.1388665787916d-03, 1.1978618064383d-02, 2.0796856822004d-02,
     |   3.2049478835735d-02, 4.3514278303969d-02, 5.1205359351726d-02,
     |   5.0388540070375d-02, 3.7764544734007d-02, 1.4032540563804d-02,
     |  -1.4704458605966d-02,-3.8185931837410d-02,-4.6176212177759d-02,
     |  -3.3937219093144d-02,-5.9155354638158d-03, 2.5108599260826d-02,
     |   4.3823522231375d-02, 4.0418158315399d-02, 1.6277751547860d-02,
     |  -1.6277751547860d-02,-4.0418158315399d-02,-4.3823522231375d-02,
     |  -2.5108599260826d-02, 5.9155354638157d-03, 3.3937219093144d-02,
     |   4.6176212177759d-02, 3.8185931837410d-02, 1.4704458605966d-02,
     |  -1.4032540563804d-02,-3.7764544734007d-02,-5.0388540070375d-02,
     |  -5.1205359351726d-02,-4.3514278303969d-02,-3.2049478835735d-02,
     |  -2.0796856822004d-02,-1.1978618064383d-02,-6.1388665787916d-03,
     |  -2.7962608060547d-03,-1.1277214036938d-03,-4.0009834371745d-04,
     |  -1.2374057083616d-04,-3.2957304792873d-05,-7.4403098332944d-06,
     |  -1.3947161854512d-06,-2.1133432627293d-07,-2.4981872281112d-08,
     |  -2.1961247934077d-09,-1.3435124656329d-10,-5.1992858154942d-12,
     |  -1.1015880857543d-13,-9.2652857826550d-16, 1.3994274429462d-17,
     |  -2.4413805481520d-17,-7.2561881135938d-17,-1.5903608142207d-17/
      data (zmn(lat,24,28), lat = 1,72)/
     |   3.8555903541827d-18,-2.0406979767156d-17,-5.3485244198058d-17,
     |  -9.1465702087053d-17,-4.7340971954713d-17, 8.9996691405987d-15,
     |   5.1286602426723d-13, 1.5478991229163d-11, 2.9081273732694d-10,
     |   3.7576653871827d-09, 3.5790669991525d-08, 2.6420087753574d-07,
     |   1.5689235340434d-06, 7.7105267286360d-06, 3.2055063971949d-05,
     |   1.1467587171623d-04, 3.5779866726437d-04, 9.8388526546901d-04,
     |   2.4036371383874d-03, 5.2474573064263d-03, 1.0275994583682d-02,
     |   1.8079638732459d-02, 2.8550987846349d-02, 4.0286248498695d-02,
     |   5.0277964478959d-02, 5.4346663953852d-02, 4.8551297589737d-02,
     |   3.1281932241079d-02, 5.0976377071537d-03,-2.2930532509277d-02,
     |  -4.3182489774832d-02,-4.7410636885512d-02,-3.2945234824910d-02,
     |  -4.8864275374640d-03, 2.5319966836518d-02, 4.4690761538768d-02,
     |   4.4690761538768d-02, 2.5319966836518d-02,-4.8864275374639d-03,
     |  -3.2945234824910d-02,-4.7410636885512d-02,-4.3182489774832d-02,
     |  -2.2930532509277d-02, 5.0976377071535d-03, 3.1281932241079d-02,
     |   4.8551297589737d-02, 5.4346663953852d-02, 5.0277964478959d-02,
     |   4.0286248498695d-02, 2.8550987846349d-02, 1.8079638732459d-02,
     |   1.0275994583682d-02, 5.2474573064264d-03, 2.4036371383874d-03,
     |   9.8388526546910d-04, 3.5779866726435d-04, 1.1467587171621d-04,
     |   3.2055063971910d-05, 7.7105267285490d-06, 1.5689235340811d-06,
     |   2.6420087752713d-07, 3.5790669942229d-08, 3.7576653534714d-09,
     |   2.9081279433005d-10, 1.5478995786280d-11, 5.1288813772886d-13,
     |   8.9952016199614d-15,-1.1264836469176d-16,-6.9178072870414d-17,
     |  -1.5618622901947d-16,-2.6817185164564d-17,-4.6087128770462d-17/
      data (zmn(lat,25,28), lat = 1,72)/
     |  -7.4550644663465d-18,-1.5639596110191d-17,-2.3220310825028d-17,
     |  -3.4161313160229d-17,-4.7782682808265d-17, 5.7972783470811d-16,
     |   4.3688692620689d-14, 1.5411461471474d-12, 3.3247659866618d-11,
     |   4.8740576610693d-10, 5.2196148787961d-09, 4.3025344419282d-08,
     |   2.8384840132542d-07, 1.5440101709395d-06, 7.0869546634401d-06,
     |   2.7952905719829d-05, 9.6125999568104d-05, 2.9155378762627d-04,
     |   7.8713687862455d-04, 1.9053024015515d-03, 4.1574869797552d-03,
     |   8.2094627597181d-03, 1.4701497408710d-02, 2.3884294933997d-02,
     |   3.5130934433403d-02, 4.6531154300257d-02, 5.4886536145595d-02,
     |   5.6387639325426d-02, 4.7993064124304d-02, 2.9103564407369d-02,
     |   2.7485979401420d-03,-2.4538217089215d-02,-4.4522701298316d-02,
     |  -5.0295964986357d-02,-3.9289545773955d-02,-1.4811821376754d-02,
     |   1.4811821376754d-02, 3.9289545773954d-02, 5.0295964986357d-02,
     |   4.4522701298316d-02, 2.4538217089215d-02,-2.7485979401421d-03,
     |  -2.9103564407369d-02,-4.7993064124304d-02,-5.6387639325426d-02,
     |  -5.4886536145595d-02,-4.6531154300257d-02,-3.5130934433404d-02,
     |  -2.3884294933997d-02,-1.4701497408710d-02,-8.2094627597181d-03,
     |  -4.1574869797553d-03,-1.9053024015515d-03,-7.8713687862460d-04,
     |  -2.9155378762622d-04,-9.6125999568154d-05,-2.7952905719814d-05,
     |  -7.0869546633630d-06,-1.5440101708864d-06,-2.8384840125359d-07,
     |  -4.3025344399193d-08,-5.2196148623980d-09,-4.8740572601213d-10,
     |  -3.3247618449128d-11,-1.5411532416777d-12,-4.3622962427342d-14,
     |  -5.4666305206693d-16, 7.3441327424859d-17, 2.4597931043155d-17,
     |  -4.5128942267581d-18, 2.6956962300907d-17,-3.7647872023713d-17/
      data (zmn(lat,26,28), lat = 1,72)/
     |   1.6960224615041d-16, 1.2691352902966d-16, 5.6016995870693d-17,
     |  -2.1991702039445d-17,-9.2385949234037d-17,-1.1491346302417d-16,
     |   2.9494437054338d-15, 1.2844492533077d-13, 3.1834163829532d-12,
     |   5.2896264051052d-11, 6.3612680669511d-10, 5.8469484262104d-09,
     |   4.2780977091754d-08, 2.5705391450602d-07, 1.2995486018461d-06,
     |   5.6351727374126d-06, 2.1284504620398d-05, 7.0904526838900d-05,
     |   2.1044257505926d-04, 5.6106066313138d-04, 1.3526217307087d-03,
     |   2.9641793333105d-03, 5.9281214478449d-03, 1.0849427332727d-02,
     |   1.8197496586392d-02, 2.7972509765571d-02, 3.9332039397919d-02,
     |   5.0355892504281d-02, 5.8167371838721d-02, 5.9555625915864d-02,
     |   5.2041128187669d-02, 3.5061618708750d-02, 1.0768050078266d-02,
     |  -1.6048789521803d-02,-3.9081236014079d-02,-5.2394024843117d-02,
     |  -5.2394024843117d-02,-3.9081236014079d-02,-1.6048789521803d-02,
     |   1.0768050078266d-02, 3.5061618708750d-02, 5.2041128187669d-02,
     |   5.9555625915864d-02, 5.8167371838721d-02, 5.0355892504281d-02,
     |   3.9332039397919d-02, 2.7972509765571d-02, 1.8197496586392d-02,
     |   1.0849427332727d-02, 5.9281214478449d-03, 2.9641793333105d-03,
     |   1.3526217307087d-03, 5.6106066313136d-04, 2.1044257505924d-04,
     |   7.0904526838894d-05, 2.1284504620379d-05, 5.6351727374660d-06,
     |   1.2995486018872d-06, 2.5705391457390d-07, 4.2780977121038d-08,
     |   5.8469484635554d-09, 6.3612691310673d-10, 5.2896301205050d-11,
     |   3.1833670318908d-12, 1.2845565495652d-13, 2.9361708712375d-15,
     |  -1.0634720826120d-16,-5.7145252763240d-17,-3.6948180498350d-17,
     |   9.0410515090674d-17, 1.0101050328492d-16, 1.5233900642146d-16/
      data (zmn(lat,27,28), lat = 1,72)/
     |  -1.3393064998850d-17,-4.4737037949538d-17,-8.5444874369617d-17,
     |  -1.2451674520630d-16,-1.5497394665812d-16,-1.7733468976360d-16,
     |  -1.2511536801488d-17, 8.3153396809322d-15, 2.4096998797946d-13,
     |   4.5366948013851d-12, 6.1204169541343d-11, 6.2651274204516d-10,
     |   5.0766953158987d-09, 3.3637599054412d-08, 1.8693088416581d-07,
     |   8.8902183932377d-07, 3.6777645106285d-06, 1.3410788447613d-05,
     |   4.3577054373878d-05, 1.2732380334931d-04, 3.3702068154538d-04,
     |   8.1318542719769d-04, 1.7977328071289d-03, 3.6564765828911d-03,
     |   6.8647024242575d-03, 1.1924945868439d-02, 1.9197687545462d-02,
     |   2.8659557375278d-02, 3.9654170551477d-02, 5.0746517098020d-02,
     |   5.9801552914738d-02, 6.4356662708643d-02, 6.2248165362180d-02,
     |   5.2322828059444d-02, 3.4980183569684d-02, 1.2306831742177d-02,
     |  -1.2306831742177d-02,-3.4980183569684d-02,-5.2322828059444d-02,
     |  -6.2248165362180d-02,-6.4356662708643d-02,-5.9801552914738d-02,
     |  -5.0746517098020d-02,-3.9654170551477d-02,-2.8659557375278d-02,
     |  -1.9197687545462d-02,-1.1924945868439d-02,-6.8647024242575d-03,
     |  -3.6564765828911d-03,-1.7977328071288d-03,-8.1318542719770d-04,
     |  -3.3702068154539d-04,-1.2732380334933d-04,-4.3577054373873d-05,
     |  -1.3410788447629d-05,-3.6777645106111d-06,-8.8902183928286d-07,
     |  -1.8693088415912d-07,-3.3637599031565d-08,-5.0766953331948d-09,
     |  -6.2651273642543d-10,-6.1204196895597d-11,-4.5366910298703d-12,
     |  -2.4097455603821d-13,-8.3253901845884d-15,-1.4952059903854d-17,
     |   1.6008150847985d-16, 1.1592445251967d-16, 1.3245548341845d-16,
     |   7.5939656944748d-17, 4.6204609011736d-17, 2.3610289962920d-17/
      data (zmn(lat,28,28), lat = 1,72)/
     |  -3.9349518323169d-17,-5.2766947408585d-17,-6.9412375953866d-17,
     |  -8.9963704337158d-17,-1.1114233723717d-16,-1.2511981004170d-16,
     |  -1.2246954362618d-16, 2.5848524676200d-16, 1.2408052709405d-14,
     |   2.6665915624788d-13, 4.0332343849637d-12, 4.5931013577601d-11,
     |   4.1166436926820d-10, 3.0034718118896d-09, 1.8315866582052d-08,
     |   9.5347514116381d-08, 4.3100056724552d-07, 1.7155548612557d-06,
     |   6.0830242008817d-06, 1.9401157980955d-05, 5.6114045581886d-05,
     |   1.4820236999877d-04, 3.5953282205802d-04, 8.0521628465478d-04,
     |   1.6720799031941d-03, 3.2313752437958d-03, 5.8303125209840d-03,
     |   9.8483000860956d-03, 1.5610384303442d-02, 2.3265547166542d-02,
     |   3.2657823828746d-02, 4.3235224203083d-02, 5.4044609465911d-02,
     |   6.3842875385343d-02, 7.1317923264994d-02, 7.5369556249485d-02,
     |   7.5369556249485d-02, 7.1317923264994d-02, 6.3842875385343d-02,
     |   5.4044609465911d-02, 4.3235224203083d-02, 3.2657823828746d-02,
     |   2.3265547166542d-02, 1.5610384303442d-02, 9.8483000860956d-03,
     |   5.8303125209840d-03, 3.2313752437958d-03, 1.6720799031941d-03,
     |   8.0521628465478d-04, 3.5953282205800d-04, 1.4820236999875d-04,
     |   5.6114045581866d-05, 1.9401157980928d-05, 6.0830242008870d-06,
     |   1.7155548612459d-06, 4.3100056726636d-07, 9.5347514119947d-08,
     |   1.8315866593450d-08, 3.0034718123877d-09, 4.1166436589289d-10,
     |   4.5931002586783d-11, 4.0331983857026d-12, 2.6664869964401d-13,
     |   1.2434340998902d-14, 2.5868863475432d-16,-1.0244343127227d-16,
     |  -1.0700163919028d-16,-8.1886421466019d-17,-7.6125540177879d-17,
     |  -6.8254006222953d-17,-5.9596611924134d-17,-5.8449394874506d-17/
      data (zmn(lat, 0,29), lat = 1,72)/
     |   3.9120980792936d-03, 4.5436410306048d-03,-8.7005649001376d-03,
     |  -1.1299274295950d-02, 3.9587668479173d-03, 1.7107945580531d-02,
     |   5.0771654924679d-03,-1.6502507929367d-02,-1.5852915597315d-02,
     |   9.4536377323666d-03, 2.2781157981602d-02, 3.1529663909943d-03,
     |  -2.3058674966939d-02,-1.6516256149915d-02, 1.4919780867952d-02,
     |   2.6277751760681d-02,-8.4642650962079d-04,-2.7952690551838d-02,
     |  -1.5227202213495d-02, 2.0601949545564d-02, 2.7419025424710d-02,
     |  -5.6209858063051d-03,-3.1626351166904d-02,-1.2024107181623d-02,
     |   2.5550776116232d-02, 2.6880133835777d-02,-1.1032081143109d-02,
     |  -3.3519031087464d-02,-7.7801059291346d-03, 2.9742863077496d-02,
     |   2.4508867801809d-02,-1.6187020964235d-02,-3.3911282883888d-02,
     |  -2.6251876642399d-03, 3.2503855512526d-02, 2.0927953576841d-02,
     |  -2.0927953576841d-02,-3.2503855512526d-02, 2.6251876642396d-03,
     |   3.3911282883888d-02, 1.6187020964235d-02,-2.4508867801809d-02,
     |  -2.9742863077496d-02, 7.7801059291342d-03, 3.3519031087464d-02,
     |   1.1032081143109d-02,-2.6880133835777d-02,-2.5550776116232d-02,
     |   1.2024107181623d-02, 3.1626351166904d-02, 5.6209858063053d-03,
     |  -2.7419025424710d-02,-2.0601949545564d-02, 1.5227202213495d-02,
     |   2.7952690551838d-02, 8.4642650962081d-04,-2.6277751760681d-02,
     |  -1.4919780867952d-02, 1.6516256149915d-02, 2.3058674966939d-02,
     |  -3.1529663909942d-03,-2.2781157981602d-02,-9.4536377323667d-03,
     |   1.5852915597315d-02, 1.6502507929367d-02,-5.0771654924681d-03,
     |  -1.7107945580531d-02,-3.9587668479175d-03, 1.1299274295950d-02,
     |   8.7005649001375d-03,-4.5436410306046d-03,-3.9120980792937d-03/
      data (zmn(lat, 1,29), lat = 1,72)/
     |   1.8469676871509d-03, 8.8996274677069d-03, 6.6150228992732d-03,
     |  -8.4173546868410d-03,-1.4465704978158d-02, 1.0504382811806d-03,
     |   1.7991756021279d-02, 9.8045916885447d-03,-1.4509448610059d-02,
     |  -1.9667620746122d-02, 4.3659517557086d-03, 2.4051066997397d-02,
     |   9.3735786457773d-03,-2.0384485566894d-02,-2.1842355338201d-02,
     |   8.9849493927245d-03, 2.8253060210730d-02, 6.8166946440665d-03,
     |  -2.5653160645840d-02,-2.1810387256492d-02, 1.4182773575610d-02,
     |   3.0682408169502d-02, 2.8448116941552d-03,-2.9973046008662d-02,
     |  -1.9951127768564d-02, 1.9376763459286d-02, 3.1367373098332d-02,
     |  -1.9988529052925d-03,-3.3033429507796d-02,-1.6626542613153d-02,
     |   2.4077847256287d-02, 3.0372509648921d-02,-7.1898689153754d-03,
     |  -3.4620807282678d-02,-1.2225677491157d-02, 2.7858028280577d-02,
     |   2.7858028280577d-02,-1.2225677491157d-02,-3.4620807282678d-02,
     |  -7.1898689153755d-03, 3.0372509648921d-02, 2.4077847256287d-02,
     |  -1.6626542613153d-02,-3.3033429507796d-02,-1.9988529052925d-03,
     |   3.1367373098332d-02, 1.9376763459286d-02,-1.9951127768563d-02,
     |  -2.9973046008662d-02, 2.8448116941553d-03, 3.0682408169502d-02,
     |   1.4182773575610d-02,-2.1810387256492d-02,-2.5653160645841d-02,
     |   6.8166946440662d-03, 2.8253060210730d-02, 8.9849493927247d-03,
     |  -2.1842355338202d-02,-2.0384485566894d-02, 9.3735786457771d-03,
     |   2.4051066997397d-02, 4.3659517557085d-03,-1.9667620746122d-02,
     |  -1.4509448610059d-02, 9.8045916885444d-03, 1.7991756021279d-02,
     |   1.0504382811808d-03,-1.4465704978158d-02,-8.4173546868410d-03,
     |   6.6150228992731d-03, 8.8996274677070d-03, 1.8469676871509d-03/
      data (zmn(lat, 2,29), lat = 1,72)/
     |   2.9836224997078d-04, 5.1793176034914d-03, 1.2504082407440d-02,
     |   7.8193604211545d-03,-9.0713630723817d-03,-1.6695702470253d-02,
     |  -1.0120791894371d-03, 1.8586154100289d-02, 1.3246176204716d-02,
     |  -1.2415891009893d-02,-2.2281908771268d-02,-1.1114726061252d-04,
     |   2.4069462250194d-02, 1.4524407644849d-02,-1.7015670645038d-02,
     |  -2.5494677520710d-02, 2.9837370053198d-03, 2.8516569900358d-02,
     |   1.3531420064409d-02,-2.1879683154183d-02,-2.6720704610288d-02,
     |   7.1960904919063d-03, 3.1751632005848d-02, 1.0842333954598d-02,
     |  -2.6361326814503d-02,-2.6225167864324d-02, 1.1945230700907d-02,
     |   3.3540696175123d-02, 6.9925795344481d-03,-3.0071299050587d-02,
     |  -2.4171512323424d-02, 1.6649836335596d-02, 3.3841411141492d-02,
     |   2.4044213321447d-03,-3.2629150688014d-02,-2.0877376251621d-02,
     |   2.0877376251620d-02, 3.2629150688014d-02,-2.4044213321444d-03,
     |  -3.3841411141492d-02,-1.6649836335596d-02, 2.4171512323424d-02,
     |   3.0071299050587d-02,-6.9925795344477d-03,-3.3540696175123d-02,
     |  -1.1945230700907d-02, 2.6225167864324d-02, 2.6361326814503d-02,
     |  -1.0842333954598d-02,-3.1751632005848d-02,-7.1960904919065d-03,
     |   2.6720704610288d-02, 2.1879683154183d-02,-1.3531420064409d-02,
     |  -2.8516569900358d-02,-2.9837370053198d-03, 2.5494677520710d-02,
     |   1.7015670645038d-02,-1.4524407644849d-02,-2.4069462250194d-02,
     |   1.1114726061241d-04, 2.2281908771268d-02, 1.2415891009893d-02,
     |  -1.3246176204716d-02,-1.8586154100289d-02, 1.0120791894373d-03,
     |   1.6695702470253d-02, 9.0713630723819d-03,-7.8193604211547d-03,
     |  -1.2504082407440d-02,-5.1793176034916d-03,-2.9836224997072d-04/
      data (zmn(lat, 3,29), lat = 1,72)/
     |   9.5233217662670d-06, 1.8332072232540d-03, 8.9067904199573d-03,
     |   1.5350256711384d-02, 8.2931215577163d-03,-1.0337753782183d-02,
     |  -1.8505873841002d-02,-2.3763157064523d-03, 1.9178313684908d-02,
     |   1.5873212523532d-02,-1.0524706792262d-02,-2.4134246122266d-02,
     |  -3.9974953738255d-03, 2.3389690900683d-02, 1.8734860577052d-02,
     |  -1.3328489449194d-02,-2.7855390908712d-02,-2.7787139180523d-03,
     |   2.7475224739132d-02, 1.9249664370202d-02,-1.7133947128297d-02,
     |  -3.0035324264063d-02, 3.5710250904480d-05, 3.0937675873236d-02,
     |   1.8029185251563d-02,-2.1181499384512d-02,-3.0724644193028d-02,
     |   3.7784378642401d-03, 3.3432821816771d-02, 1.5472222243158d-02,
     |  -2.4938411652846d-02,-2.9992048360323d-02, 7.9153060258343d-03,
     |   3.4736689759643d-02, 1.1962914647652d-02,-2.7984431947188d-02,
     |  -2.7984431947188d-02, 1.1962914647652d-02, 3.4736689759643d-02,
     |   7.9153060258343d-03,-2.9992048360323d-02,-2.4938411652846d-02,
     |   1.5472222243158d-02, 3.3432821816771d-02, 3.7784378642400d-03,
     |  -3.0724644193028d-02,-2.1181499384512d-02, 1.8029185251562d-02,
     |   3.0937675873236d-02, 3.5710250904340d-05,-3.0035324264063d-02,
     |  -1.7133947128297d-02, 1.9249664370202d-02, 2.7475224739132d-02,
     |  -2.7787139180520d-03,-2.7855390908712d-02,-1.3328489449194d-02,
     |   1.8734860577052d-02, 2.3389690900683d-02,-3.9974953738252d-03,
     |  -2.4134246122266d-02,-1.0524706792262d-02, 1.5873212523532d-02,
     |   1.9178313684908d-02,-2.3763157064519d-03,-1.8505873841002d-02,
     |  -1.0337753782183d-02, 8.2931215577160d-03, 1.5350256711384d-02,
     |   8.9067904199573d-03, 1.8332072232540d-03, 9.5233217663127d-06/
      data (zmn(lat, 4,29), lat = 1,72)/
     |   8.4563589173557d-07, 4.6142147827399d-04, 4.1533374754423d-03,
     |   1.2551921486678d-02, 1.7666720464894d-02, 8.0809106557961d-03,
     |  -1.1973187199654d-02,-2.0099275311959d-02,-3.1778021288087d-03,
     |   1.9837210141444d-02, 1.7998459453713d-02,-8.9089795199733d-03,
     |  -2.5494003971191d-02,-7.4130470313637d-03, 2.2316647401052d-02,
     |   2.2174603576714d-02,-9.4933981336014d-03,-2.9217331706713d-02,
     |  -8.1847097487148d-03, 2.5407884384775d-02, 2.4003068890747d-02,
     |  -1.1737989626345d-02,-3.1852038768760d-02,-7.0400698490865d-03,
     |   2.8484654793267d-02, 2.4171942833559d-02,-1.4751119765270d-02,
     |  -3.3361724685012d-02,-4.6874559290609d-03, 3.1095229450903d-02,
     |   2.3010623147089d-02,-1.7934653019516d-02,-3.3705329008443d-02,
     |  -1.6381837520245d-03, 3.2908259901491d-02, 2.0820568312648d-02,
     |  -2.0820568312648d-02,-3.2908259901491d-02, 1.6381837520242d-03,
     |   3.3705329008443d-02, 1.7934653019517d-02,-2.3010623147089d-02,
     |  -3.1095229450903d-02, 4.6874559290605d-03, 3.3361724685012d-02,
     |   1.4751119765270d-02,-2.4171942833559d-02,-2.8484654793267d-02,
     |   7.0400698490863d-03, 3.1852038768760d-02, 1.1737989626345d-02,
     |  -2.4003068890747d-02,-2.5407884384775d-02, 8.1847097487146d-03,
     |   2.9217331706713d-02, 9.4933981336014d-03,-2.2174603576714d-02,
     |  -2.2316647401052d-02, 7.4130470313639d-03, 2.5494003971191d-02,
     |   8.9089795199734d-03,-1.7998459453713d-02,-1.9837210141444d-02,
     |   3.1778021288085d-03, 2.0099275311958d-02, 1.1973187199654d-02,
     |  -8.0809106557959d-03,-1.7666720464894d-02,-1.2551921486678d-02,
     |  -4.1533374754423d-03,-4.6142147827387d-04,-8.4563589174939d-07/
      data (zmn(lat, 5,29), lat = 1,72)/
     |   1.0662365266569d-06, 8.9927346771338d-05, 1.4576130561156d-03,
     |   6.9551250919895d-03, 1.6039017773431d-02, 1.9447986909387d-02,
     |   7.3210065414032d-03,-1.3859770273354d-02,-2.1510650459505d-02,
     |  -3.5769276026140d-03, 2.0588885814371d-02, 1.9791628711010d-02,
     |  -7.5119591689093d-03,-2.6543782948381d-02,-1.0471230357783d-02,
     |   2.0972395371491d-02, 2.5015772590625d-02,-5.5830851101706d-03,
     |  -2.9754165923851d-02,-1.3225876530273d-02, 2.2500523685198d-02,
     |   2.7814690652644d-02,-5.8758442817870d-03,-3.2255156389143d-02,
     |  -1.3825756879321d-02, 2.4551842273489d-02, 2.9087873013266d-02,
     |  -7.3561214648139d-03,-3.4026399617804d-02,-1.3057876724066d-02,
     |   2.6600535403620d-02, 2.9153963723790d-02,-9.3759731355752d-03,
     |  -3.4949003486792d-02,-1.1427224550491d-02, 2.8240475631378d-02,
     |   2.8240475631378d-02,-1.1427224550491d-02,-3.4949003486792d-02,
     |  -9.3759731355753d-03, 2.9153963723790d-02, 2.6600535403620d-02,
     |  -1.3057876724066d-02,-3.4026399617804d-02,-7.3561214648139d-03,
     |   2.9087873013266d-02, 2.4551842273489d-02,-1.3825756879320d-02,
     |  -3.2255156389143d-02,-5.8758442817869d-03, 2.7814690652644d-02,
     |   2.2500523685198d-02,-1.3225876530273d-02,-2.9754165923851d-02,
     |  -5.5830851101708d-03, 2.5015772590624d-02, 2.0972395371491d-02,
     |  -1.0471230357783d-02,-2.6543782948381d-02,-7.5119591689096d-03,
     |   1.9791628711010d-02, 2.0588885814371d-02,-3.5769276026139d-03,
     |  -2.1510650459505d-02,-1.3859770273355d-02, 7.3210065414033d-03,
     |   1.9447986909387d-02, 1.6039017773431d-02, 6.9551250919894d-03,
     |   1.4576130561156d-03, 8.9927346771299d-05, 1.0662365266534d-06/
      data (zmn(lat, 6,29), lat = 1,72)/
     |   5.4004234702834d-08, 1.4555921762271d-05, 4.1098512885872d-04,
     |   2.9672748303573d-03, 1.0047878310495d-02, 1.9294890734592d-02,
     |   2.0709271074585d-02, 6.1321038609440d-03,-1.5889630211812d-02,
     |  -2.2758910963184d-02,-3.7008996121191d-03, 2.1409762980848d-02,
     |   2.1373360974024d-02,-6.2489585213919d-03,-2.7377078240824d-02,
     |  -1.3289575348592d-02, 1.9391278886055d-02, 2.7378944473157d-02,
     |  -1.5949103780930d-03,-2.9560171529308d-02,-1.7915166021243d-02,
     |   1.8844880396165d-02, 3.0686016787724d-02, 3.2896285060130d-04,
     |  -3.1271199451186d-02,-2.0137480881671d-02, 1.9254348353268d-02,
     |   3.2573078020481d-02, 7.2963855230379d-04,-3.2592612978071d-02,
     |  -2.0901688061499d-02, 2.0042319999156d-02, 3.3407093323786d-02,
     |   3.2762993389472d-04,-3.3362334278188d-02,-2.0731173022351d-02,
     |   2.0731173022350d-02, 3.3362334278188d-02,-3.2762993389441d-04,
     |  -3.3407093323786d-02,-2.0042319999156d-02, 2.0901688061499d-02,
     |   3.2592612978071d-02,-7.2963855230341d-04,-3.2573078020481d-02,
     |  -1.9254348353268d-02, 2.0137480881671d-02, 3.1271199451186d-02,
     |  -3.2896285060119d-04,-3.0686016787724d-02,-1.8844880396165d-02,
     |   1.7915166021242d-02, 2.9560171529308d-02, 1.5949103780932d-03,
     |  -2.7378944473157d-02,-1.9391278886055d-02, 1.3289575348592d-02,
     |   2.7377078240824d-02, 6.2489585213917d-03,-2.1373360974024d-02,
     |  -2.1409762980849d-02, 3.7008996121192d-03, 2.2758910963184d-02,
     |   1.5889630211812d-02,-6.1321038609439d-03,-2.0709271074585d-02,
     |  -1.9294890734592d-02,-1.0047878310495d-02,-2.9672748303574d-03,
     |  -4.1098512885873d-04,-1.4555921762458d-05,-5.4004234676348d-08/
      data (zmn(lat, 7,29), lat = 1,72)/
     |  -4.1797478079338d-08, 2.0372999755805d-06, 9.6837610331312d-05,
     |   1.0344279693332d-03, 4.9110095658056d-03, 1.3295028893155d-02,
     |   2.2256152817632d-02, 2.1493299188244d-02, 4.6261176130760d-03,
     |  -1.7967461357478d-02,-2.3867212708423d-02,-3.6600451351998d-03,
     |   2.2254874300301d-02, 2.2835288894420d-02,-5.0240294856548d-03,
     |  -2.8029180958537d-02,-1.5975254726034d-02, 1.7550595735995d-02,
     |   2.9332282901112d-02, 2.5104934972380d-03,-2.8659208793259d-02,
     |  -2.2253167973873d-02, 1.4468920740837d-02, 3.2571295739702d-02,
     |   6.7710501137137d-03,-2.8870505125860d-02,-2.5764779860262d-02,
     |   1.2691729632886d-02, 3.4375370031099d-02, 9.1904346738896d-03,
     |  -2.8925539560641d-02,-2.7701910024423d-02, 1.1587967520087d-02,
     |   3.5216309681192d-02, 1.0597822844424d-02,-2.8633026041513d-02,
     |  -2.8633026041513d-02, 1.0597822844424d-02, 3.5216309681192d-02,
     |   1.1587967520087d-02,-2.7701910024423d-02,-2.8925539560641d-02,
     |   9.1904346738895d-03, 3.4375370031099d-02, 1.2691729632886d-02,
     |  -2.5764779860262d-02,-2.8870505125860d-02, 6.7710501137135d-03,
     |   3.2571295739702d-02, 1.4468920740837d-02,-2.2253167973873d-02,
     |  -2.8659208793260d-02, 2.5104934972380d-03, 2.9332282901112d-02,
     |   1.7550595735995d-02,-1.5975254726034d-02,-2.8029180958537d-02,
     |  -5.0240294856547d-03, 2.2835288894420d-02, 2.2254874300302d-02,
     |  -3.6600451351998d-03,-2.3867212708423d-02,-1.7967461357478d-02,
     |   4.6261176130758d-03, 2.1493299188244d-02, 2.2256152817632d-02,
     |   1.3295028893155d-02, 4.9110095658056d-03, 1.0344279693331d-03,
     |   9.6837610331270d-05, 2.0372999756396d-06,-4.1797478063465d-08/
      data (zmn(lat, 8,29), lat = 1,72)/
     |  -1.5566071924344d-09, 2.4078505102579d-07, 1.9580123784564d-05,
     |   3.0506266445341d-04, 1.9812335567593d-03, 7.2006440775040d-03,
     |   1.6582033342892d-02, 2.4885063105694d-02, 2.1863135095831d-02,
     |   2.9164252781005d-03,-2.0016208063900d-02,-2.4866781674309d-02,
     |  -3.5599730189695d-03, 2.3072300759244d-02, 2.4249309305749d-02,
     |  -3.7336818068582d-03,-2.8496017882897d-02,-1.8617128832037d-02,
     |   1.5387226471742d-02, 3.0893607967621d-02, 6.7817945042697d-03,
     |  -2.7012872574406d-02,-2.6204751757496d-02, 9.3667515088075d-03,
     |   3.3361809425786d-02, 1.3323623173639d-02,-2.4982149088008d-02,
     |  -3.0430149504706d-02, 4.9900460011700d-03, 3.4186146483090d-02,
     |   1.7607498593806d-02,-2.2917840915376d-02,-3.2817939407698d-02,
     |   1.5620800761430d-03, 3.3988881441974d-02, 2.0602092368671d-02,
     |  -2.0602092368671d-02,-3.3988881441974d-02,-1.5620800761433d-03,
     |   3.2817939407698d-02, 2.2917840915376d-02,-1.7607498593806d-02,
     |  -3.4186146483090d-02,-4.9900460011704d-03, 3.0430149504706d-02,
     |   2.4982149088009d-02,-1.3323623173639d-02,-3.3361809425786d-02,
     |  -9.3667515088077d-03, 2.6204751757496d-02, 2.7012872574406d-02,
     |  -6.7817945042693d-03,-3.0893607967621d-02,-1.5387226471742d-02,
     |   1.8617128832037d-02, 2.8496017882897d-02, 3.7336818068584d-03,
     |  -2.4249309305749d-02,-2.3072300759244d-02, 3.5599730189693d-03,
     |   2.4866781674309d-02, 2.0016208063900d-02,-2.9164252781004d-03,
     |  -2.1863135095831d-02,-2.4885063105694d-02,-1.6582033342892d-02,
     |  -7.2006440775041d-03,-1.9812335567594d-03,-3.0506266445332d-04,
     |  -1.9580123784533d-05,-2.4078505079063d-07, 1.5566071705312d-09/
      data (zmn(lat, 9,29), lat = 1,72)/
     |   1.8088455488371d-09, 2.3121442750580d-08, 3.4590368687941d-06,
     |   7.7859491944512d-05, 6.8147345116786d-04, 3.2393966613106d-03,
     |   9.7441966186713d-03, 1.9814084103303d-02, 2.7170941222961d-02,
     |   2.1900796517359d-02, 1.1160174128620d-03,-2.1975902251627d-02,
     |  -2.5799710341778d-02,-3.5054196485054d-03, 2.3805858305423d-02,
     |   2.5673876188807d-02,-2.2694952065471d-03,-2.8740729911452d-02,
     |  -2.1281863208140d-02, 1.2809753745711d-02, 3.2027955525798d-02,
     |   1.1256780924938d-02,-2.4530500699990d-02,-2.9676887291528d-02,
     |   3.5280654798557d-03, 3.2879979041503d-02, 1.9795758719124d-02,
     |  -1.9520833440893d-02,-3.3758864741329d-02,-3.6383637305522d-03,
     |   3.1654404283488d-02, 2.5396258308470d-02,-1.4564509351038d-02,
     |  -3.5470707096490d-02,-9.4417560562357d-03, 2.9173265605120d-02,
     |   2.9173265605120d-02,-9.4417560562358d-03,-3.5470707096490d-02,
     |  -1.4564509351038d-02, 2.5396258308470d-02, 3.1654404283488d-02,
     |  -3.6383637305520d-03,-3.3758864741329d-02,-1.9520833440893d-02,
     |   1.9795758719123d-02, 3.2879979041503d-02, 3.5280654798560d-03,
     |  -2.9676887291528d-02,-2.4530500699990d-02, 1.1256780924938d-02,
     |   3.2027955525798d-02, 1.2809753745711d-02,-2.1281863208140d-02,
     |  -2.8740729911452d-02,-2.2694952065472d-03, 2.5673876188807d-02,
     |   2.3805858305423d-02,-3.5054196485053d-03,-2.5799710341778d-02,
     |  -2.1975902251627d-02, 1.1160174128619d-03, 2.1900796517359d-02,
     |   2.7170941222961d-02, 1.9814084103302d-02, 9.7441966186713d-03,
     |   3.2393966613107d-03, 6.8147345116791d-04, 7.7859491944583d-05,
     |   3.4590368688927d-06, 2.3121442724001d-08, 1.8088455350231d-09/
      data (zmn(lat,10,29), lat = 1,72)/
     |   5.2915199620076d-11, 2.1389805751402d-09, 5.4037916053896d-07,
     |   1.7474621677154d-05, 2.0409786574948d-04, 1.2488935298786d-03,
     |   4.7740018447172d-03, 1.2449369602540d-02, 2.2917458970367d-02,
     |   2.9129208806229d-02, 2.1704393791509d-02,-6.6465855035678d-04,
     |  -2.3801284030147d-02,-2.6718212854085d-02,-3.6023631029233d-03,
     |   2.4393529246880d-02, 2.7155054260630d-02,-5.1917982076488d-04,
     |  -2.8694196906534d-02,-2.4007781944085d-02, 9.7074562754353d-03,
     |   3.2642393912331d-02, 1.5941490176020d-02,-2.1080671722561d-02,
     |  -3.2497082268420d-02,-3.0261072335769d-03, 3.0882604361440d-02,
     |   2.5886687341240d-02,-1.2433041150970d-02,-3.5261837974826d-02,
     |  -1.2817320843283d-02, 2.6436563075336d-02, 3.1749668609959d-02,
     |  -4.0836857601111d-03,-3.4777673154825d-02,-2.0428184820977d-02,
     |   2.0428184820976d-02, 3.4777673154825d-02, 4.0836857601114d-03,
     |  -3.1749668609959d-02,-2.6436563075336d-02, 1.2817320843283d-02,
     |   3.5261837974825d-02, 1.2433041150970d-02,-2.5886687341240d-02,
     |  -3.0882604361440d-02, 3.0261072335767d-03, 3.2497082268420d-02,
     |   2.1080671722561d-02,-1.5941490176020d-02,-3.2642393912331d-02,
     |  -9.7074562754357d-03, 2.4007781944085d-02, 2.8694196906534d-02,
     |   5.1917982076489d-04,-2.7155054260630d-02,-2.4393529246880d-02,
     |   3.6023631029235d-03, 2.6718212854085d-02, 2.3801284030147d-02,
     |   6.6465855035666d-04,-2.1704393791509d-02,-2.9129208806229d-02,
     |  -2.2917458970367d-02,-1.2449369602540d-02,-4.7740018447173d-03,
     |  -1.2488935298786d-03,-2.0409786574951d-04,-1.7474621677272d-05,
     |  -5.4037916048827d-07,-2.1389807361575d-09,-5.2915212232605d-11/
      data (zmn(lat,11,29), lat = 1,72)/
     |  -7.3160326902602d-11, 2.5188475787916d-10, 7.5365938064020d-08,
     |   3.4892335747048d-06, 5.4006900674694d-05, 4.2094696135870d-04,
     |   2.0108955739573d-03, 6.5334922350757d-03, 1.5227741724132d-02,
     |   2.5840277778540d-02, 3.0799167943961d-02, 2.1384257552105d-02,
     |  -2.3185983922396d-03,-2.5458107276092d-02,-2.7681326455627d-02,
     |  -3.9595836949971d-03, 2.4763103400947d-02, 2.8722985203799d-02,
     |   1.6321669582839d-03,-2.8251573985755d-02,-2.6794412307060d-02,
     |   5.9598993857945d-03, 3.2578775667967d-02, 2.0784497123289d-02,
     |  -1.6508346406306d-02,-3.4392437077454d-02,-1.0196279607402d-02,
     |   2.7079229926390d-02, 3.1138340474511d-02,-3.7704379452572d-03,
     |  -3.4343572990667d-02,-2.1913289716149d-02, 1.8300117992385d-02,
     |   3.5609936816472d-02, 7.9114967375032d-03,-2.9878008773932d-02,
     |  -2.9878008773932d-02, 7.9114967375033d-03, 3.5609936816472d-02,
     |   1.8300117992386d-02,-2.1913289716149d-02,-3.4343572990667d-02,
     |  -3.7704379452574d-03, 3.1138340474511d-02, 2.7079229926390d-02,
     |  -1.0196279607402d-02,-3.4392437077454d-02,-1.6508346406306d-02,
     |   2.0784497123289d-02, 3.2578775667967d-02, 5.9598993857945d-03,
     |  -2.6794412307059d-02,-2.8251573985755d-02, 1.6321669582838d-03,
     |   2.8722985203799d-02, 2.4763103400947d-02,-3.9595836949969d-03,
     |  -2.7681326455627d-02,-2.5458107276092d-02,-2.3185983922398d-03,
     |   2.1384257552105d-02, 3.0799167943961d-02, 2.5840277778540d-02,
     |   1.5227741724132d-02, 6.5334922350759d-03, 2.0108955739572d-03,
     |   4.2094696135871d-04, 5.4006900674657d-05, 3.4892335746282d-06,
     |   7.5365937890983d-08, 2.5188479742219d-10,-7.3160339235457d-11/
      data (zmn(lat,12,29), lat = 1,72)/
     |  -1.7398561967262d-12, 1.8573331459954d-11, 9.4746788188791d-09,
     |   6.2523626700875d-07, 1.2760770847311d-05, 1.2575485278094d-04,
     |   7.4244591912340d-04, 2.9532925436162d-03, 8.4548903214415d-03,
     |   1.7998354448263d-02, 2.8552104742452d-02, 3.2240379767307d-02,
     |   2.1059130804189d-02,-3.7416485893338d-03,-2.6917542603469d-02,
     |  -2.8749782302101d-02,-4.6897034472630d-03, 2.4825377992693d-02,
     |   3.0384076315820d-02, 4.2986440339050d-03,-2.7266333977422d-02,
     |  -2.9586415495363d-02, 1.4514077813447d-03, 3.1606443118464d-02,
     |   2.5643428979135d-02,-1.0664239562121d-02,-3.4972817493098d-02,
     |  -1.7741741885720d-02, 2.1176946609321d-02, 3.4893570974280d-02,
     |   6.2012874204013d-03,-3.0357622305664d-02,-2.9938409747833d-02,
     |   7.3023854251826d-03, 3.5712168430668d-02, 2.0202472179500d-02,
     |  -2.0202472179500d-02,-3.5712168430668d-02,-7.3023854251827d-03,
     |   2.9938409747833d-02, 3.0357622305664d-02,-6.2012874204013d-03,
     |  -3.4893570974280d-02,-2.1176946609321d-02, 1.7741741885719d-02,
     |   3.4972817493098d-02, 1.0664239562121d-02,-2.5643428979134d-02,
     |  -3.1606443118464d-02,-1.4514077813446d-03, 2.9586415495363d-02,
     |   2.7266333977422d-02,-4.2986440339049d-03,-3.0384076315820d-02,
     |  -2.4825377992693d-02, 4.6897034472628d-03, 2.8749782302101d-02,
     |   2.6917542603469d-02, 3.7416485893338d-03,-2.1059130804189d-02,
     |  -3.2240379767307d-02,-2.8552104742453d-02,-1.7998354448263d-02,
     |  -8.4548903214415d-03,-2.9532925436160d-03,-7.4244591912320d-04,
     |  -1.2575485278087d-04,-1.2760770847263d-05,-6.2523626692664d-07,
     |  -9.4746789382529d-09,-1.8573284692970d-11, 1.7398912448486d-12/
      data (zmn(lat,13,29), lat = 1,72)/
     |   2.7649082971955d-12,-1.5630944385712d-12, 1.0816074012950d-09,
     |   1.0120755115178d-07, 2.7134537470929d-06, 3.3626019135569d-05,
     |   2.4343959903144d-04, 1.1718594741565d-03, 4.0463621753621d-03,
     |   1.0468404844861d-02, 2.0690100797253d-02, 3.1042014504407d-02,
     |   3.3527929227095d-02, 2.0852848732150d-02,-4.8301843924627d-03,
     |  -2.8148469105545d-02,-2.9978927553471d-02,-5.9093639153747d-03,
     |   2.4465399048697d-02, 3.2108423905458d-02, 7.5857090326704d-03,
     |  -2.5543991238513d-02,-3.2250740487291d-02,-3.9045504320458d-03,
     |   2.9419483848921d-02, 3.0242149932043d-02,-3.4552913785183d-03,
     |  -3.3727454349174d-02,-2.5200706079976d-02, 1.2968239939890d-02,
     |   3.6278940484190d-02, 1.6854886122415d-02,-2.2743908403808d-02,
     |  -3.5485167086381d-02,-5.9410009304507d-03, 3.0771944020719d-02,
     |   3.0771944020719d-02,-5.9410009304507d-03,-3.5485167086381d-02,
     |  -2.2743908403808d-02, 1.6854886122415d-02, 3.6278940484190d-02,
     |   1.2968239939890d-02,-2.5200706079975d-02,-3.3727454349174d-02,
     |  -3.4552913785184d-03, 3.0242149932043d-02, 2.9419483848921d-02,
     |  -3.9045504320457d-03,-3.2250740487291d-02,-2.5543991238513d-02,
     |   7.5857090326699d-03, 3.2108423905458d-02, 2.4465399048697d-02,
     |  -5.9093639153747d-03,-2.9978927553471d-02,-2.8148469105545d-02,
     |  -4.8301843924625d-03, 2.0852848732150d-02, 3.3527929227095d-02,
     |   3.1042014504407d-02, 2.0690100797253d-02, 1.0468404844861d-02,
     |   4.0463621753620d-03, 1.1718594741564d-03, 2.4343959903151d-04,
     |   3.3626019135431d-05, 2.7134537470644d-06, 1.0120755126424d-07,
     |   1.0816076039594d-09,-1.5630752513052d-12, 2.7649312487645d-12/
      data (zmn(lat,14,29), lat = 1,72)/
     |   5.4523460936569d-14,-9.0429051296190d-14, 1.1202039243226d-10,
     |   1.4873781868220d-08, 5.2229536077152d-07, 8.1055238755388d-06,
     |   7.1543024855225d-05, 4.1336942818397d-04, 1.7008938995305d-03,
     |   5.2475792381521d-03, 1.2501270833652d-02, 2.3242577744728d-02,
     |   3.3314985709521d-02, 3.4746821978290d-02, 2.0891604312005d-02,
     |  -5.4770754914900d-03,-2.9107488633146d-02,-3.1409043170187d-02,
     |  -7.7374928468808d-03, 2.3532569759259d-02, 3.3811610265439d-02,
     |   1.1574705984274d-02,-2.2839077931299d-02,-3.4546705380711d-02,
     |  -1.0124771404241d-02, 2.5647019251182d-02, 3.4120465808850d-02,
     |   5.0728657970926d-03,-3.0052937496106d-02,-3.1799995045948d-02,
     |   2.4822641970598d-03, 3.4249199359771d-02, 2.7028901243529d-02,
     |  -1.1291303982806d-02,-3.6766687730503d-02,-1.9915100213624d-02,
     |   1.9915100213624d-02, 3.6766687730503d-02, 1.1291303982806d-02,
     |  -2.7028901243529d-02,-3.4249199359771d-02,-2.4822641970598d-03,
     |   3.1799995045948d-02, 3.0052937496106d-02,-5.0728657970924d-03,
     |  -3.4120465808850d-02,-2.5647019251182d-02, 1.0124771404241d-02,
     |   3.4546705380711d-02, 2.2839077931299d-02,-1.1574705984274d-02,
     |  -3.3811610265439d-02,-2.3532569759259d-02, 7.7374928468808d-03,
     |   3.1409043170187d-02, 2.9107488633146d-02, 5.4770754914902d-03,
     |  -2.0891604312005d-02,-3.4746821978290d-02,-3.3314985709521d-02,
     |  -2.3242577744728d-02,-1.2501270833652d-02,-5.2475792381521d-03,
     |  -1.7008938995305d-03,-4.1336942818422d-04,-7.1543024855350d-05,
     |  -8.1055238756363d-06,-5.2229536090874d-07,-1.4873781934894d-08,
     |  -1.1202034124399d-10, 9.0429399933734d-14,-5.4564489980924d-14/
      data (zmn(lat,15,29), lat = 1,72)/
     |  -9.6255700014146d-14, 9.2518447309411d-14, 1.0491212821927d-11,
     |   1.9919127339713d-09, 9.1393677351718d-08, 1.7704998448969d-06,
     |   1.8969027545441d-05, 1.3076182224788d-04, 6.3574070913878d-04,
     |   2.3100081362374d-03, 6.5045801776888d-03, 1.4480589926175d-02,
     |   2.5605211167970d-02, 3.5386635942892d-02, 3.5985570164618d-02,
     |   2.1301567329587d-02,-5.5662880995061d-03,-2.9726501255605d-02,
     |  -3.3051891429891d-02,-1.0289645893029d-02, 2.1831287516826d-02,
     |   3.5330093051893d-02, 1.6295253446509d-02,-1.8861525151873d-02,
     |  -3.6091045289388d-02,-1.7092266209181d-02, 1.9890867672442d-02,
     |   3.6585529201304d-02, 1.4611007927322d-02,-2.3342576064411d-02,
     |  -3.6378489408907d-02,-9.7836693759283d-03, 2.7755480585780d-02,
     |   3.4882297069950d-02, 3.4392582661701d-03,-3.1891516663844d-02,
     |  -3.1891516663844d-02, 3.4392582661700d-03, 3.4882297069950d-02,
     |   2.7755480585780d-02,-9.7836693759281d-03,-3.6378489408907d-02,
     |  -2.3342576064411d-02, 1.4611007927322d-02, 3.6585529201304d-02,
     |   1.9890867672442d-02,-1.7092266209181d-02,-3.6091045289388d-02,
     |  -1.8861525151873d-02, 1.6295253446509d-02, 3.5330093051893d-02,
     |   2.1831287516827d-02,-1.0289645893029d-02,-3.3051891429891d-02,
     |  -2.9726501255605d-02,-5.5662880995062d-03, 2.1301567329587d-02,
     |   3.5985570164618d-02, 3.5386635942892d-02, 2.5605211167970d-02,
     |   1.4480589926175d-02, 6.5045801776888d-03, 2.3100081362375d-03,
     |   6.3574070913893d-04, 1.3076182224797d-04, 1.8969027545445d-05,
     |   1.7704998450314d-06, 9.1393677349276d-08, 1.9919125750700d-09,
     |   1.0491107619761d-11, 9.2533849638352d-14,-9.6247942992158d-14/
      data (zmn(lat,16,29), lat = 1,72)/
     |  -1.5991916962180d-15, 4.5527238735711d-15, 9.0740578525794d-13,
     |   2.4368330208487d-10, 1.4582405703685d-08, 3.5173104520672d-07,
     |   4.5586011142443d-06, 3.7319192434337d-05, 2.1304472627307d-04,
     |   9.0375353329820d-04, 2.9695873554255d-03, 7.7580802398365d-03,
     |   1.6334989506021d-02, 2.7734613692560d-02, 3.7276340466719d-02,
     |   3.7328770428473d-02, 2.2206186963819d-02,-4.9669047823759d-03,
     |  -2.9897818618509d-02,-3.4871829796624d-02,-1.3665135377623d-02,
     |   1.9115422602681d-02, 3.6390358266946d-02, 2.1679745684893d-02,
     |  -1.3302762040469d-02,-3.6325110662098d-02,-2.4462540785373d-02,
     |   1.1812673192014d-02, 3.6688219843746d-02, 2.4416307351811d-02,
     |  -1.3180316302621d-02,-3.7381198980954d-02,-2.2558973223299d-02,
     |   1.6123069664356d-02, 3.7901334146566d-02, 1.9552024777221d-02,
     |  -1.9552024777221d-02,-3.7901334146566d-02,-1.6123069664356d-02,
     |   2.2558973223299d-02, 3.7381198980954d-02, 1.3180316302621d-02,
     |  -2.4416307351811d-02,-3.6688219843746d-02,-1.1812673192014d-02,
     |   2.4462540785373d-02, 3.6325110662098d-02, 1.3302762040469d-02,
     |  -2.1679745684893d-02,-3.6390358266946d-02,-1.9115422602681d-02,
     |   1.3665135377622d-02, 3.4871829796624d-02, 2.9897818618509d-02,
     |   4.9669047823760d-03,-2.2206186963819d-02,-3.7328770428473d-02,
     |  -3.7276340466719d-02,-2.7734613692560d-02,-1.6334989506021d-02,
     |  -7.7580802398366d-03,-2.9695873554255d-03,-9.0375353329823d-04,
     |  -2.1304472627304d-04,-3.7319192434102d-05,-4.5586011141684d-06,
     |  -3.5173104510517d-07,-1.4582405547105d-08,-2.4368326708175d-10,
     |  -9.0745248910068d-13,-4.5471737101250d-15, 1.6265581397119d-15/
      data (zmn(lat,17,29), lat = 1,72)/
     |   2.9621453649434d-15,-2.9973049274548d-15, 7.4826484076738d-14,
     |   2.7273360030455d-11, 2.1255969745702d-09, 6.3703306635451d-08,
     |   9.9600922731990d-07, 9.6485402154803d-06, 6.4366881309407d-05,
     |   3.1672529492689d-04, 1.2035481208644d-03, 3.6417580861564d-03,
     |   8.9445204190138d-03, 1.7995045370193d-02, 2.9590277853690d-02,
     |   3.8998744151033d-02, 3.8848161038538d-02, 2.3721945713529d-02,
     |  -3.5280072492205d-03,-2.9457249104142d-02,-3.6759521246965d-02,
     |  -1.7922031551481d-02, 1.5092832412828d-02, 3.6574714945346d-02,
     |   2.7493920943869d-02,-5.8976562260070d-03,-3.4501361947158d-02,
     |  -3.1540441814395d-02, 1.3001423385287d-03, 3.3271745920199d-02,
     |   3.3118715525970d-02, 3.1199359034198d-04,-3.3032011921962d-02,
     |  -3.3492802475903d-02,-2.7933167079676d-04, 3.3291955804482d-02,
     |   3.3291955804482d-02,-2.7933167079664d-04,-3.3492802475903d-02,
     |  -3.3032011921962d-02, 3.1199359034181d-04, 3.3118715525970d-02,
     |   3.3271745920199d-02, 1.3001423385291d-03,-3.1540441814395d-02,
     |  -3.4501361947158d-02,-5.8976562260071d-03, 2.7493920943868d-02,
     |   3.6574714945346d-02, 1.5092832412828d-02,-1.7922031551481d-02,
     |  -3.6759521246965d-02,-2.9457249104142d-02,-3.5280072492206d-03,
     |   2.3721945713529d-02, 3.8848161038538d-02, 3.8998744151033d-02,
     |   2.9590277853690d-02, 1.7995045370193d-02, 8.9445204190138d-03,
     |   3.6417580861565d-03, 1.2035481208644d-03, 3.1672529492690d-04,
     |   6.4366881309329d-05, 9.6485402154719d-06, 9.9600922728898d-07,
     |   6.3703306549828d-08, 2.1255970462920d-09, 2.7273434579157d-11,
     |   7.4860302012955d-14,-2.9808102627193d-15, 2.9842140125454d-15/
      data (zmn(lat,18,29), lat = 1,72)/
     |   5.7358783924766d-17,-1.6232102104852d-16, 5.3410537035620d-15,
     |   2.7948962377073d-12, 2.8330290875904d-10, 1.0531506394405d-08,
     |   1.9820000766190d-07, 2.2653991865136d-06, 1.7594554600640d-05,
     |   9.9930499423103d-05, 4.3625313190376d-04, 1.5149156895262d-03,
     |   4.2826539004865d-03, 9.9983350262593d-03, 1.9392591446941d-02,
     |   3.1128855878256d-02, 4.0553637576960d-02, 4.0591300899992d-02,
     |   2.5950621460440d-02,-1.0769275063495d-03,-2.8166690627136d-02,
     |  -3.8496554145423d-02,-2.3033324285222d-02, 9.4506897895152d-03,
     |   3.5292541761879d-02, 3.3240156595661d-02, 3.4551466573452d-03,
     |  -2.9723390087969d-02,-3.7146042022195d-02,-1.1257512776879d-02,
     |   2.5174080999894d-02, 3.8580297425340d-02, 1.5950279973064d-02,
     |  -2.1853343520648d-02,-3.9053244501420d-02,-1.9092731189341d-02,
     |   1.9092731189341d-02, 3.9053244501420d-02, 2.1853343520648d-02,
     |  -1.5950279973064d-02,-3.8580297425340d-02,-2.5174080999894d-02,
     |   1.1257512776879d-02, 3.7146042022195d-02, 2.9723390087969d-02,
     |  -3.4551466573451d-03,-3.3240156595661d-02,-3.5292541761879d-02,
     |  -9.4506897895153d-03, 2.3033324285222d-02, 3.8496554145423d-02,
     |   2.8166690627137d-02, 1.0769275063497d-03,-2.5950621460440d-02,
     |  -4.0591300899992d-02,-4.0553637576960d-02,-3.1128855878256d-02,
     |  -1.9392591446941d-02,-9.9983350262594d-03,-4.2826539004866d-03,
     |  -1.5149156895261d-03,-4.3625313190378d-04,-9.9930499423054d-05,
     |  -1.7594554600676d-05,-2.2653991866871d-06,-1.9820000769328d-07,
     |  -1.0531506419868d-08,-2.8330300886932d-10,-2.7949527514181d-12,
     |  -5.3881685653808d-15, 1.0091628356197d-16,-6.1464004231772d-17/
      data (zmn(lat,19,29), lat = 1,72)/
     |  -1.5177982419481d-16,-7.3513935502241d-17, 1.2784129986218d-16,
     |   2.6216371958566d-13, 3.4520811903745d-11, 1.5895029457817d-09,
     |   3.5940706721210d-08, 4.8355702544126d-07, 4.3592030484412d-06,
     |   2.8467227641273d-05, 1.4205320012099d-04, 5.6230554189971d-04,
     |   1.8127070458011d-03, 4.8450041839636d-03, 1.0853894518784d-02,
     |   2.0459266956822d-02, 3.2297475633263d-02, 4.1914206622932d-02,
     |   4.2566725824271d-02, 2.8965262625232d-02, 2.5749796911837d-03,
     |  -2.5700025290736d-02,-3.9710961274395d-02,-2.8816286736066d-02,
     |   1.9189018073051d-03, 3.1777088296029d-02, 3.8040005618426d-02,
     |   1.4488805287266d-02,-2.1098839786694d-02,-3.9528063687767d-02,
     |  -2.4578190130951d-02, 1.1700547018307d-02, 3.7985755253218d-02,
     |   3.0866148511758d-02,-3.7215581615479d-03,-3.5060890143656d-02,
     |  -3.5060890143656d-02,-3.7215581615480d-03, 3.0866148511758d-02,
     |   3.7985755253218d-02, 1.1700547018307d-02,-2.4578190130951d-02,
     |  -3.9528063687767d-02,-2.1098839786694d-02, 1.4488805287266d-02,
     |   3.8040005618426d-02, 3.1777088296029d-02, 1.9189018073054d-03,
     |  -2.8816286736066d-02,-3.9710961274395d-02,-2.5700025290736d-02,
     |   2.5749796911833d-03, 2.8965262625232d-02, 4.2566725824271d-02,
     |   4.1914206622932d-02, 3.2297475633263d-02, 2.0459266956822d-02,
     |   1.0853894518784d-02, 4.8450041839634d-03, 1.8127070458011d-03,
     |   5.6230554189975d-04, 1.4205320012096d-04, 2.8467227641266d-05,
     |   4.3592030484770d-06, 4.8355702544146d-07, 3.5940706698590d-08,
     |   1.5895030021554d-09, 3.4520756850261d-11, 2.6218176366488d-13,
     |   1.6809724858954d-16,-8.3879128449992d-17,-1.3034103791584d-16/
      data (zmn(lat,20,29), lat = 1,72)/
     |   1.0386914969814d-16, 2.1376873757831d-17,-7.7926689721630d-17,
     |   2.2317621311808d-14, 3.8409124155176d-12, 2.1880049488478d-10,
     |   5.9349516310374d-09, 9.3810599343869d-08, 9.7919715770040d-07,
     |   7.3295451676821d-06, 4.1641378096737d-05, 1.8693121204918d-04,
     |   6.8248991737370d-04, 2.0688558851002d-03, 5.2810153657132d-03,
     |   1.1447383910872d-02, 2.1124937828171d-02, 3.3026858210448d-02,
     |   4.3013913854923d-02, 4.4724379614549d-02, 3.2786204924728d-02,
     |   7.6125065946069d-03,-2.1640239038457d-02,-3.9828168661074d-02,
     |  -3.4828266169067d-02,-7.6036094199926d-03, 2.5146923952233d-02,
     |   4.0526768303102d-02, 2.6264595400037d-02,-8.0924712053795d-03,
     |  -3.6456437551274d-02,-3.6052999696672d-02,-6.5206159491889d-03,
     |   2.8487899584416d-02, 4.0120545516980d-02, 1.8505936659606d-02,
     |  -1.8505936659606d-02,-4.0120545516980d-02,-2.8487899584416d-02,
     |   6.5206159491889d-03, 3.6052999696672d-02, 3.6456437551274d-02,
     |   8.0924712053796d-03,-2.6264595400037d-02,-4.0526768303101d-02,
     |  -2.5146923952233d-02, 7.6036094199925d-03, 3.4828266169066d-02,
     |   3.9828168661074d-02, 2.1640239038457d-02,-7.6125065946070d-03,
     |  -3.2786204924728d-02,-4.4724379614549d-02,-4.3013913854923d-02,
     |  -3.3026858210448d-02,-2.1124937828171d-02,-1.1447383910872d-02,
     |  -5.2810153657132d-03,-2.0688558851002d-03,-6.8248991737366d-04,
     |  -1.8693121204928d-04,-4.1641378096721d-05,-7.3295451677389d-06,
     |  -9.7919715759728d-07,-9.3810599243381d-08,-5.9349516304820d-09,
     |  -2.1880050899422d-10,-3.8408374813665d-12,-2.2296497385221d-14,
     |   1.4834147971988d-16, 1.4847598599174d-17,-1.1920353862201d-16/
      data (zmn(lat,21,29), lat = 1,72)/
     |  -4.6095464959635d-17,-1.1764125089717d-16,-1.3414301419935d-16,
     |   1.6588410688086d-15, 3.8929616252157d-13, 2.7408218592602d-11,
     |   8.9069066311402d-10, 1.6512993887964d-08, 1.9916744957780d-07,
     |   1.7044759261834d-06, 1.0989987237034d-05, 5.5722866221581d-05,
     |   2.2921394453954d-04, 7.8261287506269d-04, 2.2549470103506d-03,
     |   5.5456315373049d-03, 1.1719111516875d-02, 2.1316994097682d-02,
     |   3.3225530531996d-02, 4.3732937937841d-02, 4.6930622921156d-02,
     |   3.7342928620375d-02, 1.4173143769965d-02,-1.5502483813722d-02,
     |  -3.8031707455680d-02,-4.0229814692014d-02,-1.8830487653163d-02,
     |   1.4598292733836d-02, 3.8828076161427d-02, 3.6799787519667d-02,
     |   8.8260168266821d-03,-2.5731999960475d-02,-4.1530516160189d-02,
     |  -2.6325775269030d-02, 8.8419357097660d-03, 3.7347396818634d-02,
     |   3.7347396818634d-02, 8.8419357097661d-03,-2.6325775269030d-02,
     |  -4.1530516160189d-02,-2.5731999960475d-02, 8.8260168266822d-03,
     |   3.6799787519667d-02, 3.8828076161427d-02, 1.4598292733836d-02,
     |  -1.8830487653163d-02,-4.0229814692014d-02,-3.8031707455681d-02,
     |  -1.5502483813722d-02, 1.4173143769965d-02, 3.7342928620375d-02,
     |   4.6930622921156d-02, 4.3732937937841d-02, 3.3225530531996d-02,
     |   2.1316994097682d-02, 1.1719111516875d-02, 5.5456315373049d-03,
     |   2.2549470103505d-03, 7.8261287506271d-04, 2.2921394453954d-04,
     |   5.5722866221493d-05, 1.0989987237035d-05, 1.7044759262283d-06,
     |   1.9916744959802d-07, 1.6512993901842d-08, 8.9069070255835d-10,
     |   2.7408176361200d-11, 3.8927006286273d-13, 1.6759780779571d-15,
     |  -1.3003636667510d-16,-1.2589780568221d-16,-4.7054064932535d-17/
      data (zmn(lat,22,29), lat = 1,72)/
     |  -1.1774683694939d-17,-7.6270087904793d-17,-1.5897757240558d-16,
     |  -7.9847315998182d-17, 3.5622962086302d-14, 3.1125788696307d-12,
     |   1.2105263619655d-10, 2.6286706222929d-09, 3.6572974101980d-08,
     |   3.5709414229289d-07, 2.6062433954368d-06, 1.4877156942183d-05,
     |   6.8665936231470d-05, 2.6268528460209d-04, 8.4845015938768d-04,
     |   2.3452778913092d-03, 5.6003730316720d-03, 1.1616979556020d-02,
     |   2.0961977337089d-02, 3.2777271973466d-02, 4.3886480870795d-02,
     |   4.8938785394835d-02, 4.2418260009543d-02, 2.2267588682905d-02,
     |  -6.8076154023434d-03,-3.3266350829019d-02,-4.3637908960140d-02,
     |  -3.0757449530418d-02,-1.7729884310292d-04, 3.0801804540237d-02,
     |   4.2777629192552d-02, 2.7220456504723d-02,-6.4432601483905d-03,
     |  -3.5913222890335d-02,-4.0929975949285d-02,-1.7740643289727d-02,
     |   1.7740643289727d-02, 4.0929975949285d-02, 3.5913222890335d-02,
     |   6.4432601483905d-03,-2.7220456504723d-02,-4.2777629192552d-02,
     |  -3.0801804540237d-02, 1.7729884310269d-04, 3.0757449530418d-02,
     |   4.3637908960140d-02, 3.3266350829019d-02, 6.8076154023437d-03,
     |  -2.2267588682905d-02,-4.2418260009543d-02,-4.8938785394835d-02,
     |  -4.3886480870795d-02,-3.2777271973467d-02,-2.0961977337089d-02,
     |  -1.1616979556020d-02,-5.6003730316720d-03,-2.3452778913093d-03,
     |  -8.4845015938771d-04,-2.6268528460204d-04,-6.8665936231502d-05,
     |  -1.4877156942186d-05,-2.6062433953663d-06,-3.5709414215934d-07,
     |  -3.6572974127181d-08,-2.6286706501961d-09,-1.2105260320806d-10,
     |  -3.1125427035324d-12,-3.5696823436404d-14, 7.5857780095759d-17,
     |   2.0556730713188d-16, 9.2221124721209d-17, 1.8568391035178d-17/
      data (zmn(lat,23,29), lat = 1,72)/
     |   1.0658599292661d-17, 1.8863111721413d-17,-3.9321451641887d-18,
     |  -6.8292752951206d-17, 2.8441293752764d-15, 3.1850909436633d-13,
     |   1.4817024430178d-11, 3.7642221526905d-10, 6.0325422809222d-09,
     |   6.7081503143494d-08, 5.5299364873521d-07, 3.5443680150139d-06,
     |   1.8295481708707d-05, 7.8096826069741d-05, 2.8127911840059d-04,
     |   8.6790563573512d-04, 2.3203584588666d-03, 5.4180105304562d-03,
     |   1.1102028503484d-02, 1.9991493164864d-02, 3.1545164081949d-02,
     |   4.3219709698672d-02, 5.0359993394063d-02, 4.7575161032370d-02,
     |   3.1651506864766d-02, 4.7579488858546d-03,-2.4346044837918d-02,
     |  -4.3040030669926d-02,-4.1246697168689d-02,-1.8255427070619d-02,
     |   1.4796459058294d-02, 3.9729905206853d-02, 4.1681899173021d-02,
     |   1.8800807250363d-02,-1.5547993519051d-02,-4.0433024110144d-02,
     |  -4.0433024110145d-02,-1.5547993519051d-02, 1.8800807250363d-02,
     |   4.1681899173021d-02, 3.9729905206853d-02, 1.4796459058294d-02,
     |  -1.8255427070619d-02,-4.1246697168689d-02,-4.3040030669926d-02,
     |  -2.4346044837918d-02, 4.7579488858546d-03, 3.1651506864766d-02,
     |   4.7575161032369d-02, 5.0359993394063d-02, 4.3219709698673d-02,
     |   3.1545164081950d-02, 1.9991493164864d-02, 1.1102028503484d-02,
     |   5.4180105304562d-03, 2.3203584588666d-03, 8.6790563573512d-04,
     |   2.8127911840066d-04, 7.8096826069818d-05, 1.8295481708754d-05,
     |   3.5443680150541d-06, 5.5299364880278d-07, 6.7081503214329d-08,
     |   6.0325423028302d-09, 3.7642222459577d-10, 1.4817024247636d-11,
     |   3.1855836362518d-13, 2.9336859968266d-15,-1.1700006425371d-16,
     |   7.0609990159374d-18, 2.3468082472088d-17,-6.5850784167022d-18/
      data (zmn(lat,24,29), lat = 1,72)/
     |   1.6604652437477d-16, 8.6924892060321d-17,-2.9851447829237d-17,
     |  -1.2346769813396d-16, 6.5643208219656d-17, 2.9055100531863d-14,
     |   1.6200620810103d-12, 4.8100813244254d-11, 8.8682408137501d-10,
     |   1.1214118048633d-08, 1.0422589095142d-07, 7.4842368426209d-07,
     |   4.3088827536156d-06, 2.0455372503333d-05, 8.1814025146244d-05,
     |   2.8031867743257d-04, 8.3338210967424d-04, 2.1707281084015d-03,
     |   4.9882618430581d-03, 1.0156967662679d-02, 1.8354754959005d-02,
     |   2.9387129449783d-02, 4.1417895615099d-02, 5.0646139311947d-02,
     |   5.2076282362752d-02, 4.1643731775423d-02, 1.9054056402349d-02,
     |  -1.0267933304435d-02,-3.5927563630075d-02,-4.6680114012669d-02,
     |  -3.6427439812314d-02,-8.7371561816296d-03, 2.3442554542127d-02,
     |   4.3734378807360d-02, 4.1161628414099d-02, 1.6704635475283d-02,
     |  -1.6704635475283d-02,-4.1161628414099d-02,-4.3734378807360d-02,
     |  -2.3442554542127d-02, 8.7371561816295d-03, 3.6427439812314d-02,
     |   4.6680114012669d-02, 3.5927563630075d-02, 1.0267933304435d-02,
     |  -1.9054056402349d-02,-4.1643731775423d-02,-5.2076282362752d-02,
     |  -5.0646139311947d-02,-4.1417895615099d-02,-2.9387129449783d-02,
     |  -1.8354754959005d-02,-1.0156967662679d-02,-4.9882618430581d-03,
     |  -2.1707281084016d-03,-8.3338210967425d-04,-2.8031867743258d-04,
     |  -8.1814025146270d-05,-2.0455372503293d-05,-4.3088827535985d-06,
     |  -7.4842368418015d-07,-1.0422589100198d-07,-1.1214118065550d-08,
     |  -8.8682410926623d-10,-4.8100818505201d-11,-1.6201701293419d-12,
     |  -2.9145825960622d-14,-6.3323227356296d-17, 9.0083692999073d-17,
     |  -2.9939832105504d-17,-9.9270822190416d-17,-1.2727666268998d-16/
      data (zmn(lat,25,29), lat = 1,72)/
     |   3.0312062543108d-17, 7.2641585355161d-17, 5.6454710691912d-17,
     |   3.6312914033644d-19,-7.5696799758634d-17, 2.2228745675818d-15,
     |   1.5615556641675d-13, 5.4190041704611d-12, 1.1481749347825d-10,
     |   1.6489183606500d-09, 1.7251568396671d-08, 1.3853020759483d-07,
     |   8.8756237343085d-07, 4.6731843423733d-06, 2.0687289385604d-05,
     |   7.8383811616958d-05, 2.5779531938983d-04, 7.4408084164975d-04,
     |   1.9007872391332d-03, 4.3243818274593d-03, 8.7981928108074d-03,
     |   1.6039984629840d-02, 2.6189124098298d-02, 3.8145180418105d-02,
     |   4.9108443449223d-02, 5.4827124033263d-02, 5.0912848892015d-02,
     |   3.5045152110520d-02, 9.1370638828334d-03,-1.9933918205671d-02,
     |  -4.2096621614143d-02,-4.8193880472706d-02,-3.4695384076139d-02,
     |  -6.4120744042147d-03, 2.4754532379484d-02, 4.4944891970099d-02,
     |   4.4944891970099d-02, 2.4754532379484d-02,-6.4120744042146d-03,
     |  -3.4695384076139d-02,-4.8193880472706d-02,-4.2096621614143d-02,
     |  -1.9933918205671d-02, 9.1370638828332d-03, 3.5045152110520d-02,
     |   5.0912848892015d-02, 5.4827124033263d-02, 4.9108443449223d-02,
     |   3.8145180418105d-02, 2.6189124098298d-02, 1.6039984629840d-02,
     |   8.7981928108074d-03, 4.3243818274593d-03, 1.9007872391332d-03,
     |   7.4408084164972d-04, 2.5779531938983d-04, 7.8383811616943d-05,
     |   2.0687289385637d-05, 4.6731843424038d-06, 8.8756237343130d-07,
     |   1.3853020764931d-07, 1.7251568400332d-08, 1.6489183008231d-09,
     |   1.1481749940676d-10, 5.4190026145716d-12, 1.5611293054274d-13,
     |   2.1222276885606d-15,-1.0961646537888d-16,-6.2405889364206d-18,
     |   4.0870512422190d-17,-4.9843872496156d-18, 1.7386510234288d-17/
      data (zmn(lat,26,29), lat = 1,72)/
     |   1.2898282748908d-17,-1.9952840569248d-17,-7.2923687565385d-17,
     |  -1.4650067855941d-16,-1.8909301143391d-16,-3.4239539314772d-17,
     |   1.2888985280876d-14, 5.2826503028414d-13, 1.2852866492382d-11,
     |   2.0939577428131d-10, 2.4628423049081d-09, 2.2080398211298d-08,
     |   1.5713628228619d-07, 9.1554066396977d-07, 4.4735536546648d-06,
     |   1.8682372862685d-05, 6.7696119662005d-05, 2.1541675622791d-04,
     |   6.0778378440172d-04, 1.5319873707748d-03, 3.4697974869285d-03,
     |   7.0905839003961d-03, 1.3105446973252d-02, 2.1921756613606d-02,
     |   3.3129513519241d-02, 4.5010319975360d-02, 5.4409236066667d-02,
     |   5.7316095145640d-02, 5.0256939240206d-02, 3.2127118666046d-02,
     |   5.6305819185648d-03,-2.2636382886218d-02,-4.3971786697054d-02,
     |  -5.0817207326943d-02,-4.0130377038248d-02,-1.5199843879473d-02,
     |   1.5199843879473d-02, 4.0130377038248d-02, 5.0817207326943d-02,
     |   4.3971786697054d-02, 2.2636382886218d-02,-5.6305819185648d-03,
     |  -3.2127118666046d-02,-5.0256939240206d-02,-5.7316095145640d-02,
     |  -5.4409236066667d-02,-4.5010319975360d-02,-3.3129513519241d-02,
     |  -2.1921756613606d-02,-1.3105446973252d-02,-7.0905839003961d-03,
     |  -3.4697974869285d-03,-1.5319873707748d-03,-6.0778378440174d-04,
     |  -2.1541675622795d-04,-6.7696119662029d-05,-1.8682372862735d-05,
     |  -4.4735536546391d-06,-9.1554066398809d-07,-1.5713628230777d-07,
     |  -2.2080398243745d-08,-2.4628421974447d-09,-2.0939579249259d-10,
     |  -1.2852841182883d-11,-5.2825431943221d-13,-1.2864207384111d-14,
     |   4.8893500554085d-18, 1.9440981313602d-16, 1.5205137448691d-16,
     |   2.6099968769669d-17, 7.5748544307989d-17,-3.4913632505129d-17/
      data (zmn(lat,27,29), lat = 1,72)/
     |  -3.0943709899079d-17,-8.9157696699128d-17,-1.4292361563443d-16,
     |  -2.0141500565663d-16,-2.3566551861235d-16,-2.3092814201229d-16,
     |   7.0401107855468d-16, 4.3093163134262d-14, 1.2065534452233d-12,
     |   2.2278466676045d-11, 2.9423216618479d-10, 2.9411781924296d-09,
     |   2.3211592659728d-08, 1.4936975052157d-07, 8.0377337603490d-07,
     |   3.6896558457768d-06, 1.4681519881674d-05, 5.1299390669848d-05,
     |   1.5906683291444d-04, 4.4145641320561d-04, 1.1041693467028d-03,
     |   2.5026617584332d-03, 5.1618374266613d-03, 9.7167027278583d-03,
     |   1.6720981790673d-02, 2.6309282001671d-02, 3.7785305182541d-02,
     |   4.9317274225535d-02, 5.7986574647807d-02, 6.0379382830418d-02,
     |   5.3700584254320d-02, 3.7086241435170d-02, 1.2551392085658d-02,
     |  -1.4990093096611d-02,-3.8880109243957d-02,-5.2763019205659d-02,
     |  -5.2763019205659d-02,-3.8880109243957d-02,-1.4990093096611d-02,
     |   1.2551392085658d-02, 3.7086241435170d-02, 5.3700584254320d-02,
     |   6.0379382830418d-02, 5.7986574647807d-02, 4.9317274225535d-02,
     |   3.7785305182541d-02, 2.6309282001671d-02, 1.6720981790673d-02,
     |   9.7167027278583d-03, 5.1618374266613d-03, 2.5026617584333d-03,
     |   1.1041693467028d-03, 4.4145641320561d-04, 1.5906683291441d-04,
     |   5.1299390669791d-05, 1.4681519881707d-05, 3.6896558457784d-06,
     |   8.0377337600649d-07, 1.4936975048068d-07, 2.3211592613902d-08,
     |   2.9411781383182d-09, 2.9423215760494d-10, 2.2278387836881d-11,
     |   1.2064857868961d-12, 4.3061373603047d-14, 7.2287865772864d-16,
     |  -1.7637115876587d-16,-2.4668559946730d-16,-2.2407568304548d-16,
     |  -1.9791539924758d-16, 2.7783345853908d-18, 9.6203662039214d-18/
      data (zmn(lat,28,29), lat = 1,72)/
     |   1.0961543744978d-16, 7.5134789895632d-17, 3.3144655286372d-17,
     |  -3.2759333399927d-17,-9.1892964828800d-17,-1.3446474345945d-16,
     |  -1.1296356298009d-16, 2.6347198509094d-15, 8.9573987266025d-14,
     |   1.8754112156511d-12, 2.7785543109340d-11, 3.0931206158997d-10,
     |   2.7032777589003d-09, 1.9182091132421d-08, 1.1345614357638d-07,
     |   5.7117035692716d-07, 2.4890244571913d-06, 9.5188983251874d-06,
     |   3.2310667796837d-05, 9.8257771928857d-05, 2.6978563676646d-04,
     |   6.7312561899779d-04, 1.5342760932872d-03, 3.2086041151062d-03,
     |   6.1775741736608d-03, 1.0977899065421d-02, 1.8036398422705d-02,
     |   2.7417070599503d-02, 3.8542403848930d-02, 5.0007140204621d-02,
     |   5.9623388349180d-02, 6.4788727001959d-02, 6.3150148006668d-02,
     |   5.3386838190769d-02, 3.5828054145202d-02, 1.2629172425681d-02,
     |  -1.2629172425681d-02,-3.5828054145202d-02,-5.3386838190769d-02,
     |  -6.3150148006668d-02,-6.4788727001959d-02,-5.9623388349180d-02,
     |  -5.0007140204621d-02,-3.8542403848930d-02,-2.7417070599503d-02,
     |  -1.8036398422706d-02,-1.0977899065421d-02,-6.1775741736608d-03,
     |  -3.2086041151062d-03,-1.5342760932871d-03,-6.7312561899776d-04,
     |  -2.6978563676644d-04,-9.8257771928865d-05,-3.2310667796850d-05,
     |  -9.5188983252212d-06,-2.4890244571835d-06,-5.7117035693727d-07,
     |  -1.1345614363071d-07,-1.9182091187748d-08,-2.7032777295747d-09,
     |  -3.0931205048479d-10,-2.7785536762507d-11,-1.8753846944295d-12,
     |  -8.9610568172159d-14,-2.6517259392114d-15, 1.1198392870342d-16,
     |   1.7858498347843d-16, 2.1833418587400d-17, 2.6631666042923d-17,
     |  -8.7109136623729d-18,-1.4697272005803d-16,-1.3692117391617d-16/
      data (zmn(lat,29,29), lat = 1,72)/
     |  -9.7312943479030d-18,-3.6235541962160d-17,-6.7432568913831d-17,
     |  -8.8433057322211d-17,-1.1595523117987d-16,-1.4171168214075d-16,
     |  -1.5513128603132d-16,-5.2020565430226d-17, 4.4124646361027d-15,
     |   1.0820392288896d-13, 1.7990699519095d-12, 2.2281863579566d-11,
     |   2.1539358500397d-10, 1.6829628519680d-09, 1.0923314675673d-08,
     |   6.0192533292310d-08, 2.8661776481818d-07, 1.1965118492428d-06,
     |   4.4318762447042d-06, 1.4711771726130d-05, 4.4138123871656d-05,
     |   1.2054291745168d-04, 3.0150667710479d-04, 6.9429798670461d-04,
     |   1.4785407431220d-03, 2.9230095028459d-03, 5.3823601306132d-03,
     |   9.2574816903201d-03, 1.4908829190088d-02, 2.2527814739023d-02,
     |   3.1994214331037d-02, 4.2768465049296d-02, 5.3874123360142d-02,
     |   6.4008175261612d-02, 7.1776097631169d-02, 7.5998427223887d-02,
     |   7.5998427223887d-02, 7.1776097631169d-02, 6.4008175261612d-02,
     |   5.3874123360142d-02, 4.2768465049296d-02, 3.1994214331037d-02,
     |   2.2527814739023d-02, 1.4908829190088d-02, 9.2574816903201d-03,
     |   5.3823601306132d-03, 2.9230095028459d-03, 1.4785407431221d-03,
     |   6.9429798670462d-04, 3.0150667710479d-04, 1.2054291745167d-04,
     |   4.4138123871635d-05, 1.4711771726124d-05, 4.4318762446918d-06,
     |   1.1965118492629d-06, 2.8661776477851d-07, 6.0192533292189d-08,
     |   1.0923314656885d-08, 1.6829628329607d-09, 2.1539358324469d-10,
     |   2.2281861190685d-11, 1.7990434491124d-12, 1.0821069168831d-13,
     |   4.4128181562160d-15,-5.4670254082001d-17,-1.8184175684231d-16,
     |  -1.5924313709795d-16,-1.4506592671579d-16,-7.4255254095723d-17,
     |  -6.0080528033974d-17,-6.7704143735724d-17,-3.8565869656820d-17/
      data (zmn(lat, 0,30), lat = 1,72)/
     |   3.9366256062842d-03, 4.0282192600739d-03,-9.5141741247903d-03,
     |  -1.0075359802526d-02, 6.7692820107486d-03, 1.6647371535996d-02,
     |  -7.6933664041906d-05,-1.9040066654048d-02,-9.7660891636876d-03,
     |   1.6717293528269d-02, 1.8844749731622d-02,-8.7542728611045d-03,
     |  -2.4905859427179d-02,-2.6417702492521d-03, 2.5146155503532d-02,
     |   1.5215763579152d-02,-1.9270347278958d-02,-2.5243903248014d-02,
     |   7.8188901906502d-03, 3.0205409041370d-02, 6.3928722882306d-03,
     |  -2.8116280073757d-02,-2.0230691365113d-02, 1.9274443975248d-02,
     |   2.9982944993820d-02,-5.2849764975439d-03,-3.3220619008844d-02,
     |  -1.0490343544383d-02, 2.8728645334261d-02, 2.4420606838963d-02,
     |  -1.7457893270204d-02,-3.2991503579666d-02, 1.8587759381654d-03,
     |   3.4114710172444d-02, 1.4357639704735d-02,-2.7379315690883d-02,
     |  -2.7379315690883d-02, 1.4357639704735d-02, 3.4114710172444d-02,
     |   1.8587759381655d-03,-3.2991503579666d-02,-1.7457893270204d-02,
     |   2.4420606838963d-02, 2.8728645334261d-02,-1.0490343544383d-02,
     |  -3.3220619008844d-02,-5.2849764975439d-03, 2.9982944993820d-02,
     |   1.9274443975249d-02,-2.0230691365114d-02,-2.8116280073757d-02,
     |   6.3928722882302d-03, 3.0205409041370d-02, 7.8188901906504d-03,
     |  -2.5243903248014d-02,-1.9270347278958d-02, 1.5215763579152d-02,
     |   2.5146155503532d-02,-2.6417702492523d-03,-2.4905859427179d-02,
     |  -8.7542728611045d-03, 1.8844749731622d-02, 1.6717293528269d-02,
     |  -9.7660891636875d-03,-1.9040066654048d-02,-7.6933664041740d-05,
     |   1.6647371535996d-02, 6.7692820107487d-03,-1.0075359802525d-02,
     |  -9.5141741247903d-03, 4.0282192600737d-03, 3.9366256062842d-03/
      data (zmn(lat, 1,30), lat = 1,72)/
     |   1.9573934148560d-03, 8.9749048623211d-03, 5.5755264803392d-03,
     |  -9.9571872485067d-03,-1.3124528565572d-02, 5.0148481594950d-03,
     |   1.8464468383675d-02, 3.7686619267199d-03,-1.8990492419706d-02,
     |  -1.3951838778880d-02, 1.3985583245095d-02, 2.2198381228090d-02,
     |  -4.0284080625875d-03,-2.5903244867075d-02,-8.4426559598546d-03,
     |   2.3287646311771d-02, 2.0388253542731d-02,-1.4548280554428d-02,
     |  -2.8392647524585d-02, 1.2948150981872d-03, 3.0176064543123d-02,
     |   1.3252444196013d-02,-2.4693145021503d-02,-2.5630445259356d-02,
     |   1.3025658087673d-02, 3.2486989448271d-02, 2.3796539202629d-03,
     |  -3.2017058127760d-02,-1.7755821251156d-02, 2.3930757331892d-02,
     |   2.9497353050519d-02,-1.0108989663861d-02,-3.4545385579910d-02,
     |  -6.3730597019250d-03, 3.1712794854968d-02, 2.1470320777400d-02,
     |  -2.1470320777400d-02,-3.1712794854968d-02, 6.3730597019249d-03,
     |   3.4545385579910d-02, 1.0108989663861d-02,-2.9497353050519d-02,
     |  -2.3930757331892d-02, 1.7755821251156d-02, 3.2017058127760d-02,
     |  -2.3796539202628d-03,-3.2486989448271d-02,-1.3025658087673d-02,
     |   2.5630445259356d-02, 2.4693145021503d-02,-1.3252444196013d-02,
     |  -3.0176064543124d-02,-1.2948150981872d-03, 2.8392647524585d-02,
     |   1.4548280554428d-02,-2.0388253542731d-02,-2.3287646311771d-02,
     |   8.4426559598547d-03, 2.5903244867075d-02, 4.0284080625877d-03,
     |  -2.2198381228090d-02,-1.3985583245095d-02, 1.3951838778880d-02,
     |   1.8990492419706d-02,-3.7686619267197d-03,-1.8464468383675d-02,
     |  -5.0148481594951d-03, 1.3124528565572d-02, 9.9571872485068d-03,
     |  -5.5755264803391d-03,-8.9749048623211d-03,-1.9573934148561d-03/
      data (zmn(lat, 2,30), lat = 1,72)/
     |   3.2403913851662d-04, 5.4982173300379d-03, 1.2543131931088d-02,
     |   6.0692285113809d-03,-1.1286679971282d-02,-1.5174937729953d-02,
     |   4.1144450971913d-03, 1.9893891098286d-02, 6.4793440947158d-03,
     |  -1.8736464955234d-02,-1.7075005929818d-02, 1.1484796114266d-02,
     |   2.4438419498910d-02, 1.5249340428438d-04,-2.5977536686144d-02,
     |  -1.3283001991188d-02, 2.0777008940960d-02, 2.4310367471341d-02,
     |  -9.6457033703389d-03,-3.0132302149077d-02,-4.8381624309608d-03,
     |   2.8810511973578d-02, 1.9145553150787d-02,-2.0294792189511d-02,
     |  -2.9565518783436d-02, 6.3599675007774d-03, 3.3309543750112d-02,
     |   9.6979949475396d-03,-2.9167330370084d-02,-2.3978632671891d-02,
     |   1.7941903358334d-02, 3.2902071115970d-02,-2.2153149169649d-03,
     |  -3.4193393224247d-02,-1.4238961828834d-02, 2.7440334362155d-02,
     |   2.7440334362155d-02,-1.4238961828834d-02,-3.4193393224247d-02,
     |  -2.2153149169650d-03, 3.2902071115970d-02, 1.7941903358334d-02,
     |  -2.3978632671891d-02,-2.9167330370084d-02, 9.6979949475395d-03,
     |   3.3309543750112d-02, 6.3599675007775d-03,-2.9565518783436d-02,
     |  -2.0294792189511d-02, 1.9145553150787d-02, 2.8810511973578d-02,
     |  -4.8381624309603d-03,-3.0132302149077d-02,-9.6457033703392d-03,
     |   2.4310367471341d-02, 2.0777008940961d-02,-1.3283001991188d-02,
     |  -2.5977536686144d-02, 1.5249340428453d-04, 2.4438419498910d-02,
     |   1.1484796114266d-02,-1.7075005929818d-02,-1.8736464955234d-02,
     |   6.4793440947157d-03, 1.9893891098286d-02, 4.1144450971912d-03,
     |  -1.5174937729953d-02,-1.1286679971282d-02, 6.0692285113807d-03,
     |   1.2543131931088d-02, 5.4982173300381d-03, 3.2403913851661d-04/
      data (zmn(lat, 3,30), lat = 1,72)/
     |   8.5701607978529d-06, 2.0283412073241d-03, 9.4995412729434d-03,
     |   1.5151627637317d-02, 5.7022236294961d-03,-1.3202259474424d-02,
     |  -1.6630846536558d-02, 3.9190959772748d-03, 2.1240072330140d-02,
     |   8.3626311225414d-03,-1.8556083658265d-02,-1.9507676121014d-02,
     |   9.3527042489625d-03, 2.5973270829221d-02, 3.8148237669553d-03,
     |  -2.5531867657718d-02,-1.7298732625767d-02, 1.7905452253029d-02,
     |   2.7254977520582d-02,-4.7909444832397d-03,-3.0736267175315d-02,
     |  -1.0517299279567d-02, 2.6445937764936d-02, 2.4049290503840d-02,
     |  -1.5172230199611d-02,-3.2160526189650d-02,-4.4012574082032d-04,
     |   3.2566543716245d-02, 1.6507352664536d-02,-2.4918215087090d-02,
     |  -2.8967389778620d-02, 1.0976043897932d-02, 3.4591223086714d-02,
     |   5.8780487036950d-03,-3.1888159573316d-02,-2.1453966397926d-02,
     |   2.1453966397926d-02, 3.1888159573316d-02,-5.8780487036949d-03,
     |  -3.4591223086714d-02,-1.0976043897932d-02, 2.8967389778620d-02,
     |   2.4918215087090d-02,-1.6507352664536d-02,-3.2566543716245d-02,
     |   4.4012574082016d-04, 3.2160526189650d-02, 1.5172230199611d-02,
     |  -2.4049290503839d-02,-2.6445937764936d-02, 1.0517299279567d-02,
     |   3.0736267175316d-02, 4.7909444832397d-03,-2.7254977520582d-02,
     |  -1.7905452253029d-02, 1.7298732625766d-02, 2.5531867657718d-02,
     |  -3.8148237669555d-03,-2.5973270829221d-02,-9.3527042489627d-03,
     |   1.9507676121015d-02, 1.8556083658265d-02,-8.3626311225412d-03,
     |  -2.1240072330140d-02,-3.9190959772749d-03, 1.6630846536558d-02,
     |   1.3202259474424d-02,-5.7022236294961d-03,-1.5151627637317d-02,
     |  -9.4995412729435d-03,-2.0283412073242d-03,-8.5701607978780d-06/
      data (zmn(lat, 4,30), lat = 1,72)/
     |   9.5984975453690d-07, 5.2951143976847d-04, 4.6424289932687d-03,
     |   1.3370134680580d-02, 1.7027654423576d-02, 4.5179870818397d-03,
     |  -1.5408420664007d-02,-1.7688450149209d-02, 4.3295722443532d-03,
     |   2.2548938235356d-02, 9.6902437893055d-03,-1.8573634976892d-02,
     |  -2.1457040730678d-02, 7.5366542268510d-03, 2.7099981399281d-02,
     |   7.0198656305028d-03,-2.4744835720706d-02,-2.0691343578105d-02,
     |   1.4849140957398d-02, 2.9393832390934d-02,-2.6787879748449d-05,
     |  -3.0435607783284d-02,-1.5705096259226d-02, 2.3247656888320d-02,
     |   2.8016600681050d-02,-9.5241010831079d-03,-3.3454187841838d-02,
     |  -7.2238107651132d-03, 3.0373988772079d-02, 2.2616999757128d-02,
     |  -1.9402803549933d-02,-3.2578144639182d-02, 3.2777051393588d-03,
     |   3.4431842742387d-02, 1.3871880040454d-02,-2.7622683818183d-02,
     |  -2.7622683818184d-02, 1.3871880040454d-02, 3.4431842742387d-02,
     |   3.2777051393590d-03,-3.2578144639182d-02,-1.9402803549933d-02,
     |   2.2616999757128d-02, 3.0373988772079d-02,-7.2238107651131d-03,
     |  -3.3454187841838d-02,-9.5241010831080d-03, 2.8016600681049d-02,
     |   2.3247656888320d-02,-1.5705096259226d-02,-3.0435607783284d-02,
     |  -2.6787879748953d-05, 2.9393832390934d-02, 1.4849140957398d-02,
     |  -2.0691343578105d-02,-2.4744835720706d-02, 7.0198656305025d-03,
     |   2.7099981399281d-02, 7.5366542268509d-03,-2.1457040730678d-02,
     |  -1.8573634976892d-02, 9.6902437893054d-03, 2.2548938235356d-02,
     |   4.3295722443533d-03,-1.7688450149208d-02,-1.5408420664007d-02,
     |   4.5179870818396d-03, 1.7027654423576d-02, 1.3370134680580d-02,
     |   4.6424289932687d-03, 5.2951143976844d-04, 9.5984975453012d-07/
      data (zmn(lat, 5,30), lat = 1,72)/
     |   1.4331846462214d-06, 1.0685992614157d-04, 1.6988123212415d-03,
     |   7.8204889252890d-03, 1.6973048165051d-02, 1.8158258987795d-02,
     |   2.6827954641976d-03,-1.7753698162847d-02,-1.8382286669362d-02,
     |   5.1927178430662d-03, 2.3846940398203d-02, 1.0616532298745d-02,
     |  -1.8772759521920d-02,-2.3094296526249d-02, 5.9684394984878d-03,
     |   2.7965043105656d-02, 9.8901488601630d-03,-2.3714459242079d-02,
     |  -2.3606371692925d-02, 1.1649761662251d-02, 3.0863749474919d-02,
     |   4.6468248890126d-03,-2.9346485456532d-02,-2.0411998972574d-02,
     |   1.9313349740504d-02, 3.1057636268877d-02,-3.4633264751531d-03,
     |  -3.3452744178162d-02,-1.3847039443981d-02, 2.6777379747304d-02,
     |   2.7833701631324d-02,-1.2741090971840d-02,-3.4610775949140d-02,
     |  -4.9021718696995d-03, 3.2267516104533d-02, 2.1389845903568d-02,
     |  -2.1389845903568d-02,-3.2267516104533d-02, 4.9021718696994d-03,
     |   3.4610775949140d-02, 1.2741090971840d-02,-2.7833701631324d-02,
     |  -2.6777379747304d-02, 1.3847039443981d-02, 3.3452744178162d-02,
     |   3.4633264751532d-03,-3.1057636268877d-02,-1.9313349740504d-02,
     |   2.0411998972574d-02, 2.9346485456532d-02,-4.6468248890126d-03,
     |  -3.0863749474919d-02,-1.1649761662251d-02, 2.3606371692925d-02,
     |   2.3714459242079d-02,-9.8901488601628d-03,-2.7965043105656d-02,
     |  -5.9684394984877d-03, 2.3094296526249d-02, 1.8772759521920d-02,
     |  -1.0616532298745d-02,-2.3846940398203d-02,-5.1927178430664d-03,
     |   1.8382286669362d-02, 1.7753698162847d-02,-2.6827954641977d-03,
     |  -1.8158258987795d-02,-1.6973048165051d-02,-7.8204889252890d-03,
     |  -1.6988123212413d-03,-1.0685992614158d-04,-1.4331846461909d-06/
      data (zmn(lat, 6,30), lat = 1,72)/
     |   6.8144715271820d-08, 1.7955485958916d-05, 4.9827627625686d-04,
     |   3.4955934865149d-03, 1.1318812248854d-02, 2.0194402383227d-02,
     |   1.8560309626188d-02, 3.5421935122708d-04,-2.0111386724834d-02,
     |  -1.8739046575491d-02, 6.3740843820096d-03, 2.5127827497933d-02,
     |   1.1262983685785d-02,-1.9098746725143d-02,-2.4537433607805d-02,
     |   4.5563838493759d-03, 2.8640592692202d-02, 1.2548970990746d-02,
     |  -2.2464572265839d-02,-2.6150758911587d-02, 8.2834969000564d-03,
     |   3.1740292143951d-02, 9.2555700661665d-03,-2.7504945892875d-02,
     |  -2.4640179380630d-02, 1.4682401483506d-02, 3.3131364029478d-02,
     |   2.9276556162814d-03,-3.2109233689741d-02,-2.0140538499613d-02,
     |   2.1780475566372d-02, 3.1913938041393d-02,-5.0716370106156d-03,
     |  -3.4801510861758d-02,-1.3243788069728d-02, 2.7931305213363d-02,
     |   2.7931305213363d-02,-1.3243788069728d-02,-3.4801510861758d-02,
     |  -5.0716370106157d-03, 3.1913938041393d-02, 2.1780475566372d-02,
     |  -2.0140538499613d-02,-3.2109233689741d-02, 2.9276556162812d-03,
     |   3.3131364029478d-02, 1.4682401483506d-02,-2.4640179380630d-02,
     |  -2.7504945892875d-02, 9.2555700661665d-03, 3.1740292143951d-02,
     |   8.2834969000569d-03,-2.6150758911587d-02,-2.2464572265839d-02,
     |   1.2548970990746d-02, 2.8640592692202d-02, 4.5563838493762d-03,
     |  -2.4537433607805d-02,-1.9098746725143d-02, 1.1262983685785d-02,
     |   2.5127827497933d-02, 6.3740843820097d-03,-1.8739046575491d-02,
     |  -2.0111386724834d-02, 3.5421935122697d-04, 1.8560309626188d-02,
     |   2.0194402383227d-02, 1.1318812248854d-02, 3.4955934865148d-03,
     |   4.9827627625686d-04, 1.7955485958927d-05, 6.8144715239839d-08/
      data (zmn(lat, 7,30), lat = 1,72)/
     |  -6.3418609021774d-08, 2.6157023237313d-06, 1.2201610833519d-04,
     |   1.2723954223600d-03, 5.8274576301926d-03, 1.4952723739202d-02,
     |   2.2941799115162d-02, 1.8293340663656d-02,-2.3196466237201d-03,
     |  -2.2377612701754d-02,-1.8802443886941d-02, 7.7560196215153d-03,
     |   2.6373623749028d-02, 1.1739382965902d-02,-1.9484586421071d-02,
     |  -2.5867337045803d-02, 3.1946761490525d-03, 2.9152873395359d-02,
     |   1.5105473956168d-02,-2.0963548642631d-02,-2.8394275237654d-02,
     |   4.6936280222055d-03, 3.2034637029014d-02, 1.3828211070753d-02,
     |  -2.4886924477701d-02,-2.8351175693581d-02, 9.3572984117828d-03,
     |   3.4136363845104d-02, 9.5512023311089d-03,-2.9321808074576d-02,
     |  -2.5874798786413d-02, 1.5383098917690d-02, 3.4529627087324d-02,
     |   3.4002411084933d-03,-3.2834242120417d-02,-2.1288581721576d-02,
     |   2.1288581721576d-02, 3.2834242120417d-02,-3.4002411084932d-03,
     |  -3.4529627087324d-02,-1.5383098917690d-02, 2.5874798786413d-02,
     |   2.9321808074576d-02,-9.5512023311087d-03,-3.4136363845104d-02,
     |  -9.3572984117829d-03, 2.8351175693581d-02, 2.4886924477701d-02,
     |  -1.3828211070753d-02,-3.2034637029014d-02,-4.6936280222054d-03,
     |   2.8394275237653d-02, 2.0963548642631d-02,-1.5105473956167d-02,
     |  -2.9152873395359d-02,-3.1946761490527d-03, 2.5867337045802d-02,
     |   1.9484586421071d-02,-1.1739382965902d-02,-2.6373623749028d-02,
     |  -7.7560196215152d-03, 1.8802443886941d-02, 2.2377612701754d-02,
     |   2.3196466237202d-03,-1.8293340663656d-02,-2.2941799115162d-02,
     |  -1.4952723739202d-02,-5.8274576301927d-03,-1.2723954223601d-03,
     |  -1.2201610833537d-04,-2.6157023237182d-06, 6.3418609004783d-08/
      data (zmn(lat, 8,30), lat = 1,72)/
     |  -2.1188735045367d-09, 3.1958125551628d-07, 2.5636225962884d-05,
     |   3.9115860433667d-04, 2.4646677016765d-03, 8.5818990431749d-03,
     |   1.8565293302093d-02, 2.5163062522235d-02, 1.7447153338518d-02,
     |  -5.1952258583760d-03,-2.4480455700159d-02,-1.8633492714308d-02,
     |   9.2291399093451d-03, 2.7571088816121d-02, 1.2149093040784d-02,
     |  -1.9855531144608d-02,-2.7143944506487d-02, 1.7723535498539d-03,
     |   2.9491608561949d-02, 1.7653216458669d-02,-1.9141356265082d-02,
     |  -3.0363766567562d-02, 8.0703891642278d-04, 3.1698038146999d-02,
     |   1.8371079338199d-02,-2.1420464376802d-02,-3.1445868984849d-02,
     |   3.3354027071168d-03, 3.3900755436380d-02, 1.6253928582731d-02,
     |  -2.4952555432989d-02,-3.0719500586682d-02, 7.6288748603175d-03,
     |   3.5255477180911d-02, 1.2330312342849d-02,-2.8374099281614d-02,
     |  -2.8374099281614d-02, 1.2330312342849d-02, 3.5255477180911d-02,
     |   7.6288748603176d-03,-3.0719500586682d-02,-2.4952555432989d-02,
     |   1.6253928582731d-02, 3.3900755436380d-02, 3.3354027071169d-03,
     |  -3.1445868984849d-02,-2.1420464376802d-02, 1.8371079338199d-02,
     |   3.1698038146999d-02, 8.0703891642264d-04,-3.0363766567562d-02,
     |  -1.9141356265082d-02, 1.7653216458669d-02, 2.9491608561949d-02,
     |   1.7723535498540d-03,-2.7143944506487d-02,-1.9855531144608d-02,
     |   1.2149093040784d-02, 2.7571088816121d-02, 9.2291399093454d-03,
     |  -1.8633492714307d-02,-2.4480455700159d-02,-5.1952258583762d-03,
     |   1.7447153338518d-02, 2.5163062522235d-02, 1.8565293302093d-02,
     |   8.5818990431749d-03, 2.4646677016765d-03, 3.9115860433680d-04,
     |   2.5636225962941d-05, 3.1958125559503d-07,-2.1188735202556d-09/
      data (zmn(lat, 9,30), lat = 1,72)/
     |   3.0516433781115d-09, 3.1284489798406d-08, 4.7067847228548d-06,
     |   1.0399396007675d-04, 8.8664615578606d-04, 4.0655544461719d-03,
     |   1.1637255671814d-02, 2.2027894448823d-02, 2.6847973895391d-02,
     |   1.6135929869931d-02,-8.1387600766598d-03,-2.6380387695075d-02,
     |  -1.8310693585499d-02, 1.0690829443529d-02, 2.8716063840112d-02,
     |   1.2593947960907d-02,-2.0131131512865d-02,-2.8412126053575d-02,
     |   1.7555858555305d-04, 2.9614568749242d-02, 2.0266285107310d-02,
     |  -1.6898268737681d-02,-3.2037403562651d-02,-3.4498752635331d-03,
     |   3.0623199485340d-02, 2.2844250526796d-02,-1.7002083383341d-02,
     |  -3.3744675232471d-02,-3.3539615019930d-03, 3.2181767449706d-02,
     |   2.2779728049745d-02,-1.8863598896122d-02,-3.4208720117791d-02,
     |  -1.3227366639533d-03, 3.3580415133761d-02, 2.1147982423114d-02,
     |  -2.1147982423114d-02,-3.3580415133761d-02, 1.3227366639532d-03,
     |   3.4208720117791d-02, 1.8863598896122d-02,-2.2779728049745d-02,
     |  -3.2181767449707d-02, 3.3539615019927d-03, 3.3744675232471d-02,
     |   1.7002083383341d-02,-2.2844250526796d-02,-3.0623199485340d-02,
     |   3.4498752635329d-03, 3.2037403562651d-02, 1.6898268737681d-02,
     |  -2.0266285107309d-02,-2.9614568749242d-02,-1.7555858555319d-04,
     |   2.8412126053575d-02, 2.0131131512865d-02,-1.2593947960907d-02,
     |  -2.8716063840112d-02,-1.0690829443529d-02, 1.8310693585499d-02,
     |   2.6380387695075d-02, 8.1387600766597d-03,-1.6135929869931d-02,
     |  -2.6847973895391d-02,-2.2027894448823d-02,-1.1637255671814d-02,
     |  -4.0655544461720d-03,-8.8664615578599d-04,-1.0399396007675d-04,
     |  -4.7067847226706d-06,-3.1284489781777d-08,-3.0516433886068d-09/
      data (zmn(lat,10,30), lat = 1,72)/
     |   7.7654769635004d-11, 3.0529064287156d-09, 7.6430625152074d-07,
     |   2.4309713870056d-05, 2.7740800372988d-04, 1.6452630210565d-03,
     |   6.0330034855029d-03, 1.4870581316643d-02, 2.5244470952196d-02,
     |   2.8025881723353d-02, 1.4491535392720d-02,-1.1031599962797d-02,
     |  -2.8068013402463d-02,-1.7928007323251d-02, 1.2044437041090d-02,
     |   2.9812636424245d-02, 1.3176722430536d-02,-2.0224081597005d-02,
     |  -2.9701541415739d-02,-1.7116566947657d-03, 2.9447135062086d-02,
     |   2.2992247847819d-02,-1.4110470381708d-02,-3.3336005730327d-02,
     |  -8.1327915573162d-03, 2.8645317408450d-02, 2.7134800448525d-02,
     |  -1.1520849489763d-02,-3.4969139146382d-02,-1.0601540103884d-02,
     |   2.8680371416505d-02, 2.8716554358418d-02,-1.0980195624736d-02,
     |  -3.5721180636812d-02,-1.1094786317447d-02, 2.8963084195302d-02,
     |   2.8963084195302d-02,-1.1094786317447d-02,-3.5721180636812d-02,
     |  -1.0980195624736d-02, 2.8716554358418d-02, 2.8680371416505d-02,
     |  -1.0601540103884d-02,-3.4969139146382d-02,-1.1520849489763d-02,
     |   2.7134800448525d-02, 2.8645317408450d-02,-8.1327915573159d-03,
     |  -3.3336005730327d-02,-1.4110470381708d-02, 2.2992247847819d-02,
     |   2.9447135062086d-02,-1.7116566947656d-03,-2.9701541415739d-02,
     |  -2.0224081597005d-02, 1.3176722430535d-02, 2.9812636424245d-02,
     |   1.2044437041090d-02,-1.7928007323251d-02,-2.8068013402463d-02,
     |  -1.1031599962797d-02, 1.4491535392720d-02, 2.8025881723353d-02,
     |   2.5244470952196d-02, 1.4870581316643d-02, 6.0330034855030d-03,
     |   1.6452630210566d-03, 2.7740800372985d-04, 2.4309713869942d-05,
     |   7.6430625154770d-07, 3.0529063254125d-09, 7.7654779589910d-11/
      data (zmn(lat,11,30), lat = 1,72)/
     |  -1.3792935800725d-10, 4.0294022327845d-10, 1.1085303442943d-07,
     |   5.0569955693716d-06, 7.6654492040394d-05, 5.8115423391039d-04,
     |   2.6779998840835d-03, 8.3014499653697d-03, 1.8165920255880d-02,
     |   2.8154058195797d-02, 2.8761437329702d-02, 1.2656158655023d-02,
     |  -1.3773002099907d-02,-2.9560114818784d-02,-1.7591356781852d-02,
     |   1.3197126797358d-02, 3.0869190113166d-02, 1.4001243816569d-02,
     |  -2.0036182948003d-02,-3.1021948378704d-02,-4.0053664984178d-03,
     |   2.8877669748671d-02, 2.5840729620760d-02,-1.0636703198245d-02,
     |  -3.4110660725472d-02,-1.3254920152756d-02, 2.5547154160577d-02,
     |   3.1024599340569d-02,-4.8960456646229d-03,-3.4730060698684d-02,
     |  -1.8154242266921d-02, 2.3081744657753d-02, 3.3443030074690d-02,
     |  -1.3935630692887d-03,-3.4495356891211d-02,-2.0962939723471d-02,
     |   2.0962939723471d-02, 3.4495356891211d-02, 1.3935630692889d-03,
     |  -3.3443030074690d-02,-2.3081744657754d-02, 1.8154242266921d-02,
     |   3.4730060698684d-02, 4.8960456646233d-03,-3.1024599340569d-02,
     |  -2.5547154160577d-02, 1.3254920152756d-02, 3.4110660725472d-02,
     |   1.0636703198245d-02,-2.5840729620760d-02,-2.8877669748671d-02,
     |   4.0053664984173d-03, 3.1021948378704d-02, 2.0036182948004d-02,
     |  -1.4001243816569d-02,-3.0869190113166d-02,-1.3197126797358d-02,
     |   1.7591356781852d-02, 2.9560114818784d-02, 1.3773002099907d-02,
     |  -1.2656158655023d-02,-2.8761437329702d-02,-2.8154058195797d-02,
     |  -1.8165920255881d-02,-8.3014499653698d-03,-2.6779998840834d-03,
     |  -5.8115423391018d-04,-7.6654492040503d-05,-5.0569955693558d-06,
     |  -1.1085303462468d-07,-4.0294020418125d-10, 1.3792937956238d-10/
      data (zmn(lat,12,30), lat = 1,72)/
     |  -2.7612435289577d-12, 2.8887331562870d-11, 1.4512244127470d-08,
     |   9.4460072278029d-07, 1.8916088843605d-05, 1.8182706943385d-04,
     |   1.0397827327051d-03, 3.9713970019576d-03, 1.0790060528431d-02,
     |   2.1421373069459d-02, 3.0731077496771d-02, 2.9148675031256d-02,
     |   1.0775893893821d-02,-1.6280157602114d-02,-3.0893776816414d-02,
     |  -1.7414906676017d-02, 1.4056002729027d-02, 3.1891483923136d-02,
     |   1.5170587641641d-02,-1.9452337736495d-02,-3.2353827668842d-02,
     |  -6.8169092844200d-03, 2.7750442392860d-02, 2.8765682490502d-02,
     |  -6.3299743952886d-03,-3.4128144564502d-02,-1.8751886940820d-02,
     |   2.1074548157380d-02, 3.4153553917922d-02, 2.8630621054520d-03,
     |  -3.2532664262179d-02,-2.5534082907591d-02, 1.5139254596538d-02,
     |   3.6091370975910d-02, 9.4858772026210d-03,-2.9715839698967d-02,
     |  -2.9715839698967d-02, 9.4858772026208d-03, 3.6091370975910d-02,
     |   1.5139254596538d-02,-2.5534082907591d-02,-3.2532664262179d-02,
     |   2.8630621054518d-03, 3.4153553917921d-02, 2.1074548157380d-02,
     |  -1.8751886940820d-02,-3.4128144564502d-02,-6.3299743952890d-03,
     |   2.8765682490501d-02, 2.7750442392860d-02,-6.8169092844199d-03,
     |  -3.2353827668842d-02,-1.9452337736495d-02, 1.5170587641641d-02,
     |   3.1891483923136d-02, 1.4056002729027d-02,-1.7414906676016d-02,
     |  -3.0893776816414d-02,-1.6280157602114d-02, 1.0775893893821d-02,
     |   2.9148675031256d-02, 3.0731077496771d-02, 2.1421373069459d-02,
     |   1.0790060528431d-02, 3.9713970019577d-03, 1.0397827327049d-03,
     |   1.8182706943382d-04, 1.8916088843521d-05, 9.4460072290498d-07,
     |   1.4512244115049d-08, 2.8887525223178d-11,-2.7612750515136d-12/
      data (zmn(lat,13,30), lat = 1,72)/
     |   5.8512944916490d-12,-3.8986837312026d-12, 1.7280709868496d-09,
     |   1.5952896964308d-07, 4.2032176684064d-06, 5.0919286767981d-05,
     |   3.5820090957058d-04, 1.6634219487420d-03, 5.4905255673370d-03,
     |   1.3410427577608d-02, 2.4554107084661d-02, 3.2983240549689d-02,
     |   2.9304168523081d-02, 8.9961676462539d-03,-1.8485222940279d-02,
     |  -3.2118667565202d-02,-1.7517552280831d-02, 1.4522308305453d-02,
     |   3.2872615375309d-02, 1.6782873889446d-02,-1.8333492142266d-02,
     |  -3.3633867861925d-02,-1.0242602352417d-02, 2.5858506443513d-02,
     |   3.1639666958629d-02,-1.0598699667557d-03,-3.3058060021670d-02,
     |  -2.4432029619007d-02, 1.4972707702387d-02, 3.5984297931326d-02,
     |   1.1566166461112d-02,-2.7818369207879d-02,-3.1947432599722d-02,
     |   4.8248037219838d-03, 3.5562435036759d-02, 2.0726113628168d-02,
     |  -2.0726113628168d-02,-3.5562435036759d-02,-4.8248037219839d-03,
     |   3.1947432599722d-02, 2.7818369207879d-02,-1.1566166461112d-02,
     |  -3.5984297931326d-02,-1.4972707702388d-02, 2.4432029619007d-02,
     |   3.3058060021670d-02, 1.0598699667557d-03,-3.1639666958629d-02,
     |  -2.5858506443513d-02, 1.0242602352417d-02, 3.3633867861925d-02,
     |   1.8333492142267d-02,-1.6782873889446d-02,-3.2872615375309d-02,
     |  -1.4522308305453d-02, 1.7517552280831d-02, 3.2118667565202d-02,
     |   1.8485222940279d-02,-8.9961676462538d-03,-2.9304168523081d-02,
     |  -3.2983240549689d-02,-2.4554107084661d-02,-1.3410427577608d-02,
     |  -5.4905255673370d-03,-1.6634219487420d-03,-3.5820090957061d-04,
     |  -5.0919286768115d-05,-4.2032176683145d-06,-1.5952896954519d-07,
     |  -1.7280708496466d-09, 3.8986450556284d-12,-5.8512723690317d-12/
      data (zmn(lat,14,30), lat = 1,72)/
     |   9.4038458408277d-14,-1.5807085368170d-13, 1.8663999733606d-10,
     |   2.4489731411842d-08, 8.4621051684735d-07, 1.2861425642052d-05,
     |   1.1058949318351d-04, 6.1864541076417d-04, 2.4461693262328d-03,
     |   7.1830867220217d-03, 1.6073222685818d-02, 2.7502868903266d-02,
     |   3.4947200792341d-02, 2.9360022447230d-02, 7.4594928441729d-03,
     |  -2.0329270568782d-02,-3.3287464523606d-02,-1.8019398428926d-02,
     |   1.4483838959798d-02, 3.3779429318832d-02, 1.8923224418960d-02,
     |  -1.6510062937044d-02,-3.4734787043121d-02,-1.4344325273874d-02,
     |   2.2940612330405d-02, 3.4219335760297d-02, 5.2468898283375d-03,
     |  -3.0469945381022d-02,-2.9910314694240d-02, 7.0585079340361d-03,
     |   3.5783804984393d-02, 2.0713699866065d-02,-2.0074660197324d-02,
     |  -3.6210941885026d-02,-7.4334648223380d-03, 3.0657808894015d-02,
     |   3.0657808894015d-02,-7.4334648223378d-03,-3.6210941885026d-02,
     |  -2.0074660197324d-02, 2.0713699866065d-02, 3.5783804984393d-02,
     |   7.0585079340362d-03,-2.9910314694240d-02,-3.0469945381022d-02,
     |   5.2468898283374d-03, 3.4219335760297d-02, 2.2940612330406d-02,
     |  -1.4344325273874d-02,-3.4734787043121d-02,-1.6510062937044d-02,
     |   1.8923224418960d-02, 3.3779429318832d-02, 1.4483838959798d-02,
     |  -1.8019398428925d-02,-3.3287464523607d-02,-2.0329270568782d-02,
     |   7.4594928441731d-03, 2.9360022447230d-02, 3.4947200792341d-02,
     |   2.7502868903266d-02, 1.6073222685818d-02, 7.1830867220218d-03,
     |   2.4461693262328d-03, 6.1864541076412d-04, 1.1058949318360d-04,
     |   1.2861425642025d-05, 8.4621051703334d-07, 2.4489731305669d-08,
     |   1.8664000118527d-10,-1.5826729299740d-13, 9.4056743196542d-14/
      data (zmn(lat,15,30), lat = 1,72)/
     |  -2.2996795008322d-13, 2.2284392787478d-13, 1.8209334638250d-11,
     |   3.4308997297870d-09, 1.5507169581025d-07, 2.9466551295400d-06,
     |   3.0819823729558d-05, 2.0628737131483d-04, 9.6766497129425d-04,
     |   3.3662102958251d-03, 8.9840317740594d-03, 1.8693268404568d-02,
     |   3.0227791940612d-02, 3.6682289746664d-02, 2.9457223556558d-02,
     |   6.3056913347557d-03,-2.1753227726352d-02,-3.4444086100896d-02,
     |  -1.9037332860305d-02, 1.3806255397588d-02, 3.4534701448009d-02,
     |   2.1649365649397d-02,-1.3778734143051d-02,-3.5439490635657d-02,
     |  -1.9115908543762d-02, 1.8689430963041d-02, 3.6103835809051d-02,
     |   1.2538034751002d-02,-2.5855897776935d-02,-3.4530459554821d-02,
     |  -2.6517953749182d-03, 3.2653556527494d-02, 2.9338521461382d-02,
     |  -9.0559711231855d-03,-3.6755739713748d-02,-2.0427223378044d-02,
     |   2.0427223378044d-02, 3.6755739713748d-02, 9.0559711231855d-03,
     |  -2.9338521461382d-02,-3.2653556527494d-02, 2.6517953749183d-03,
     |   3.4530459554821d-02, 2.5855897776935d-02,-1.2538034751002d-02,
     |  -3.6103835809051d-02,-1.8689430963042d-02, 1.9115908543762d-02,
     |   3.5439490635657d-02, 1.3778734143051d-02,-2.1649365649397d-02,
     |  -3.4534701448009d-02,-1.3806255397588d-02, 1.9037332860305d-02,
     |   3.4444086100895d-02, 2.1753227726352d-02,-6.3056913347555d-03,
     |  -2.9457223556558d-02,-3.6682289746664d-02,-3.0227791940612d-02,
     |  -1.8693268404568d-02,-8.9840317740594d-03,-3.3662102958251d-03,
     |  -9.6766497129421d-04,-2.0628737131481d-04,-3.0819823729573d-05,
     |  -2.9466551294266d-06,-1.5507169577780d-07,-3.4308998314418d-09,
     |  -1.8209363555567d-11,-2.2289230616776d-13, 2.2988975229585d-13/
      data (zmn(lat,16,30), lat = 1,72)/
     |  -3.0222776317737d-15, 8.6495989644372d-15, 1.6546498687304d-12,
     |   4.3984534865154d-10, 2.5954383818028d-08, 6.1486854210921d-07,
     |   7.7933014495722d-06, 6.2094598133216d-05, 3.4311065591509d-04,
     |   1.3996730383390d-03, 4.3872871421493d-03, 1.0820087849786d-02,
     |   2.1192597064845d-02, 3.2707499068780d-02, 3.8262677558327d-02,
     |   2.9739525553234d-02, 5.6743254072851d-03,-2.2685968987862d-02,
     |  -3.5608951242809d-02,-2.0677914234328d-02, 1.2324854912117d-02,
     |   3.4994511867951d-02, 2.4967115275968d-02,-9.9078408622090d-03,
     |  -3.5411409076368d-02,-2.4429212242730d-02, 1.2783429066810d-02,
     |   3.6693815517797d-02, 2.0529700834848d-02,-1.8705031300298d-02,
     |  -3.7294522057993d-02,-1.3741169904673d-02, 2.5663635995672d-02,
     |   3.5857056756768d-02, 4.8419582433429d-03,-3.1826244271097d-02,
     |  -3.1826244271097d-02, 4.8419582433428d-03, 3.5857056756768d-02,
     |   2.5663635995672d-02,-1.3741169904673d-02,-3.7294522057993d-02,
     |  -1.8705031300299d-02, 2.0529700834847d-02, 3.6693815517797d-02,
     |   1.2783429066810d-02,-2.4429212242730d-02,-3.5411409076368d-02,
     |  -9.9078408622091d-03, 2.4967115275968d-02, 3.4994511867951d-02,
     |   1.2324854912118d-02,-2.0677914234328d-02,-3.5608951242809d-02,
     |  -2.2685968987862d-02, 5.6743254072851d-03, 2.9739525553234d-02,
     |   3.8262677558327d-02, 3.2707499068780d-02, 2.1192597064845d-02,
     |   1.0820087849786d-02, 4.3872871421494d-03, 1.3996730383389d-03,
     |   3.4311065591520d-04, 6.2094598133212d-05, 7.7933014495081d-06,
     |   6.1486854209248d-07, 2.5954383644401d-08, 4.3984545649994d-10,
     |   1.6547110950419d-12, 8.6982492096060d-15,-3.0011737153242d-15/
      data (zmn(lat,17,30), lat = 1,72)/
     |   8.1746488265076d-15,-7.9827491248929d-15, 1.4579744037918d-13,
     |   5.1698288370747d-11, 3.9766207803535d-09, 1.1718740685039d-07,
     |   1.7945473473336d-06, 1.6952890439877d-05, 1.0975429457340d-04,
     |   5.2117225973398d-04, 1.8984462832450d-03, 5.4610942123255d-03,
     |   1.2613645950627d-02, 2.3501246938242d-02, 3.4933641799616d-02,
     |   3.9768138412549d-02, 3.0347571091188d-02, 5.7085841856027d-03,
     |  -2.3029876962981d-02,-3.6760021011452d-02,-2.3024634404055d-02,
     |   9.8398451854241d-03, 3.4921043295428d-02, 2.8790820853266d-02,
     |  -4.6602252678087d-03,-3.4167193392663d-02,-2.9954383691271d-02,
     |   4.9616957952022d-03, 3.5170774296463d-02, 2.8558799375811d-02,
     |  -8.6689709800246d-03,-3.6847888147531d-02,-2.5115852105251d-02,
     |   1.4172438802134d-02, 3.8034788200144d-02, 2.0051716725831d-02,
     |  -2.0051716725831d-02,-3.8034788200144d-02,-1.4172438802134d-02,
     |   2.5115852105251d-02, 3.6847888147531d-02, 8.6689709800244d-03,
     |  -2.8558799375811d-02,-3.5170774296463d-02,-4.9616957952023d-03,
     |   2.9954383691271d-02, 3.4167193392663d-02, 4.6602252678089d-03,
     |  -2.8790820853266d-02,-3.4921043295428d-02,-9.8398451854241d-03,
     |   2.3024634404055d-02, 3.6760021011452d-02, 2.3029876962981d-02,
     |  -5.7085841856026d-03,-3.0347571091188d-02,-3.9768138412549d-02,
     |  -3.4933641799616d-02,-2.3501246938242d-02,-1.2613645950628d-02,
     |  -5.4610942123256d-03,-1.8984462832450d-03,-5.2117225973396d-04,
     |  -1.0975429457342d-04,-1.6952890439843d-05,-1.7945473473037d-06,
     |  -1.1718740696201d-07,-3.9766207456327d-09,-5.1698156933798d-11,
     |  -1.4586668603508d-13, 7.9984058923811d-15,-8.1738783024464d-15/
      data (zmn(lat,18,30), lat = 1,72)/
     |   6.6230507355189d-17,-3.0411783539231d-16, 1.0869838977747d-14,
     |   5.5788665868492d-12, 5.5850281787761d-10, 2.0435471762483d-08,
     |   3.7716932381425d-07, 4.2111429291257d-06, 3.1809664133354d-05,
     |   1.7484834074410d-04, 7.3451493190827d-04, 2.4376809852340d-03,
     |   6.5301785084797d-03, 1.4285620781516d-02, 2.5555760638103d-02,
     |   3.6903083993308d-02, 4.1273321882153d-02, 3.1412355151024d-02,
     |   6.5592021652183d-03,-2.2644568957401d-02,-3.7808047432567d-02,
     |  -2.6115157009555d-02, 6.1206829394035d-03, 3.3953367594691d-02,
     |   3.2883468326564d-02, 2.1523931576101d-03,-3.1066566097787d-02,
     |  -3.5054009217268d-02,-4.8317185219004d-03, 3.0537750426744d-02,
     |   3.5409826595339d-02, 4.1344586483059d-03,-3.1615094655063d-02,
     |  -3.4708381892427d-02,-1.5790183158947d-03, 3.3277323125587d-02,
     |   3.3277323125587d-02,-1.5790183158946d-03,-3.4708381892427d-02,
     |  -3.1615094655063d-02, 4.1344586483059d-03, 3.5409826595339d-02,
     |   3.0537750426744d-02,-4.8317185219001d-03,-3.5054009217268d-02,
     |  -3.1066566097787d-02, 2.1523931576100d-03, 3.2883468326564d-02,
     |   3.3953367594691d-02, 6.1206829394034d-03,-2.6115157009555d-02,
     |  -3.7808047432567d-02,-2.2644568957401d-02, 6.5592021652182d-03,
     |   3.1412355151024d-02, 4.1273321882153d-02, 3.6903083993308d-02,
     |   2.5555760638103d-02, 1.4285620781516d-02, 6.5301785084799d-03,
     |   2.4376809852340d-03, 7.3451493190812d-04, 1.7484834074416d-04,
     |   3.1809664133328d-05, 4.2111429291600d-06, 3.7716932390549d-07,
     |   2.0435471858822d-08, 5.5850293804799d-10, 5.5787814324472d-12,
     |   1.0752593263625d-14,-2.0826792843366d-16, 1.1953218022058d-16/
      data (zmn(lat,19,30), lat = 1,72)/
     |  -3.4457552955103d-16, 7.5251262159293d-17, 3.5037005308566d-16,
     |   5.5295418689318d-13, 7.1933483669718d-11, 3.2629831360101d-09,
     |   7.2439209750864d-08, 9.5343233993367d-07, 8.3749424891690d-06,
     |   5.3056513309997d-05, 2.5555951384237d-04, 9.7081100235309d-04,
     |   2.9824952248879d-03, 7.5309967277978d-03, 1.5757111902508d-02,
     |   2.7295580450028d-02, 3.8607958874008d-02, 4.2835079924213d-02,
     |   3.3046402116191d-02, 8.3860079958592d-03,-2.1330403561187d-02,
     |  -3.8564629474697d-02,-2.9902530800645d-02, 9.2904970603438d-04,
     |   3.1583945471450d-02, 3.6773424715480d-02, 1.0563616220619d-02,
     |  -2.5349241240524d-02,-3.8666424618591d-02,-1.6205588958339d-02,
     |   2.1794192645933d-02, 3.9180068474190d-02, 1.8649104840725d-02,
     |  -2.0243141945264d-02,-3.9335471831890d-02,-1.9578427134834d-02,
     |   1.9578427134834d-02, 3.9335471831890d-02, 2.0243141945264d-02,
     |  -1.8649104840725d-02,-3.9180068474190d-02,-2.1794192645933d-02,
     |   1.6205588958339d-02, 3.8666424618591d-02, 2.5349241240525d-02,
     |  -1.0563616220619d-02,-3.6773424715480d-02,-3.1583945471451d-02,
     |  -9.2904970603451d-04, 2.9902530800645d-02, 3.8564629474698d-02,
     |   2.1330403561188d-02,-8.3860079958592d-03,-3.3046402116191d-02,
     |  -4.2835079924213d-02,-3.8607958874008d-02,-2.7295580450028d-02,
     |  -1.5757111902508d-02,-7.5309967277979d-03,-2.9824952248879d-03,
     |  -9.7081100235306d-04,-2.5555951384229d-04,-5.3056513310047d-05,
     |  -8.3749424891057d-06,-9.5343233993759d-07,-7.2439209744188d-08,
     |  -3.2629831276376d-09,-7.1933520934038d-11,-5.5303876820262d-13,
     |  -2.3825549901233d-16,-5.0245950569462d-17, 3.9864658377096d-16/
      data (zmn(lat,20,30), lat = 1,72)/
     |   4.6154482343601d-17,-3.7389444482204d-17,-9.5207392455851d-17,
     |   5.0105260575585d-14, 8.4920289091911d-12, 4.7693545753457d-10,
     |   1.2714499297754d-08, 1.9685302658125d-07, 2.0053461228390d-06,
     |   1.4591321399722d-05, 8.0225288230172d-05, 3.4676924224044d-04,
     |   1.2119005487720d-03, 3.4916974481691d-03, 8.3969239543385d-03,
     |   1.6949974115808d-02, 2.8657793843523d-02, 4.0023871230389d-02,
     |   4.4477064391656d-02, 3.5330182213912d-02, 1.1353236356644d-02,
     |  -1.8815297260928d-02,-3.8703072286038d-02,-3.4193236765846d-02,
     |  -5.9242078028735d-03, 2.7158521881228d-02, 3.9653290057172d-02,
     |   2.0271929144981d-02,-1.6271708413053d-02,-3.9228677434339d-02,
     |  -2.7971442432531d-02, 8.3529444929838d-03, 3.7339949176624d-02,
     |   3.2295137834539d-02,-2.5448403344077d-03,-3.5099912248764d-02,
     |  -3.5099912248764d-02,-2.5448403344078d-03, 3.2295137834539d-02,
     |   3.7339949176624d-02, 8.3529444929839d-03,-2.7971442432531d-02,
     |  -3.9228677434339d-02,-1.6271708413053d-02, 2.0271929144981d-02,
     |   3.9653290057172d-02, 2.7158521881228d-02,-5.9242078028732d-03,
     |  -3.4193236765846d-02,-3.8703072286038d-02,-1.8815297260928d-02,
     |   1.1353236356644d-02, 3.5330182213912d-02, 4.4477064391656d-02,
     |   4.0023871230389d-02, 2.8657793843523d-02, 1.6949974115808d-02,
     |   8.3969239543385d-03, 3.4916974481691d-03, 1.2119005487719d-03,
     |   3.4676924224043d-04, 8.0225288230270d-05, 1.4591321399691d-05,
     |   2.0053461227581d-06, 1.9685302655110d-07, 1.2714499314836d-08,
     |   4.7693543842403d-10, 8.4920754116973d-12, 5.0130119232702d-14,
     |  -2.3044472115309d-17,-4.8035864925390d-17, 1.7469806022232d-17/
      data (zmn(lat,21,30), lat = 1,72)/
     |  -1.7298411064946d-17,-7.5908252577135d-17,-8.4064342472742d-17,
     |   4.0953131992189d-15, 9.1748781079876d-13, 6.3730645472761d-11,
     |   2.0373026780455d-09, 3.7038286370732d-08, 4.3659701532122d-07,
     |   3.6383931352592d-06, 2.2752766126421d-05, 1.1138991429172d-04,
     |   4.4016382657405d-04, 1.4351500896374d-03, 3.9206764897904d-03,
     |   9.0612173373379d-03, 1.7786740030934d-02, 2.9571016838697d-02,
     |   4.1096703352973d-02, 4.6170655700298d-02, 3.8290433050562d-02,
     |   1.5612631451237d-02,-1.4751958868609d-02,-3.7715980637626d-02,
     |  -3.8555883714754d-02,-1.4466041826626d-02, 1.9934121621664d-02,
     |   4.0287740870185d-02, 3.0370745880812d-02,-3.4233408448870d-03,
     |  -3.4756038546090d-02,-3.7744636072892d-02,-9.1870837334793d-03,
     |   2.7286656901889d-02, 4.0553486978788d-02, 1.8975162553829d-02,
     |  -1.8975162553829d-02,-4.0553486978788d-02,-2.7286656901889d-02,
     |   9.1870837334791d-03, 3.7744636072892d-02, 3.4756038546090d-02,
     |   3.4233408448872d-03,-3.0370745880812d-02,-4.0287740870185d-02,
     |  -1.9934121621664d-02, 1.4466041826626d-02, 3.8555883714754d-02,
     |   3.7715980637626d-02, 1.4751958868609d-02,-1.5612631451237d-02,
     |  -3.8290433050561d-02,-4.6170655700298d-02,-4.1096703352973d-02,
     |  -2.9571016838697d-02,-1.7786740030934d-02,-9.0612173373380d-03,
     |  -3.9206764897903d-03,-1.4351500896373d-03,-4.4016382657406d-04,
     |  -1.1138991429174d-04,-2.2752766126501d-05,-3.6383931351725d-06,
     |  -4.3659701537742d-07,-3.7038286373374d-08,-2.0373026909995d-09,
     |  -6.3730554975422d-11,-9.1746546053443d-13,-4.0706516204805d-15,
     |   3.4442320578454d-18, 7.4255225566657d-17,-3.4512047470129d-17/
      data (zmn(lat,22,30), lat = 1,72)/
     |   1.0819764109016d-16, 2.1152619078749d-17,-1.0735643643441d-16,
     |   1.3947667416276d-16, 9.0333327687605d-14, 7.7658117964831d-12,
     |   2.9733172112674d-10, 6.3377374250248d-09, 8.6284429322055d-08,
     |   8.2162282578680d-07, 5.8269324250655d-06, 3.2191196622560d-05,
     |   1.4315281156483d-04, 5.2494205848359d-04, 1.6155706095325d-03,
     |   4.2248504160742d-03, 9.4601931693125d-03, 1.8190736089903d-02,
     |   2.9949693206868d-02, 4.1729006713975d-02, 4.7811612787276d-02,
     |   4.1866494103908d-02, 2.1265670523467d-02,-8.7386538224832d-03,
     |  -3.4882173976383d-02,-4.2201036039465d-02,-2.4365482820743d-02,
     |   9.2547705225614d-03, 3.7001509222064d-02, 3.9013919672298d-02,
     |   1.2688058338329d-02,-2.3295873202847d-02,-4.1724730418799d-02,
     |  -2.7911365151583d-02, 7.8169857127869d-03, 3.7444911080383d-02,
     |   3.7444911080383d-02, 7.8169857127870d-03,-2.7911365151583d-02,
     |  -4.1724730418799d-02,-2.3295873202848d-02, 1.2688058338329d-02,
     |   3.9013919672298d-02, 3.7001509222064d-02, 9.2547705225615d-03,
     |  -2.4365482820743d-02,-4.2201036039465d-02,-3.4882173976383d-02,
     |  -8.7386538224832d-03, 2.1265670523467d-02, 4.1866494103908d-02,
     |   4.7811612787276d-02, 4.1729006713975d-02, 2.9949693206868d-02,
     |   1.8190736089903d-02, 9.4601931693124d-03, 4.2248504160742d-03,
     |   1.6155706095324d-03, 5.2494205848355d-04, 1.4315281156489d-04,
     |   3.2191196622574d-05, 5.8269324250900d-06, 8.2162282578033d-07,
     |   8.6284429363783d-08, 6.3377374386602d-09, 2.9733164968544d-10,
     |   7.7657826354978d-12, 9.0325022952033d-14, 1.1680240373722d-16,
     |  -6.8929004103815d-17,-2.7297166290169d-17, 1.5965350032389d-16/
      data (zmn(lat,23,30), lat = 1,72)/
     |   2.4178673553661d-17, 4.8337585541756d-17, 1.0306153187938d-17,
     |  -5.0144817555731d-17, 7.9730255140444d-15, 8.5937747312754d-13,
     |   3.9373474184517d-11, 9.8273400302017d-10, 1.5428112791684d-08,
     |   1.6753894920820d-07, 1.3442506134096d-06, 8.3553438202294d-06,
     |   4.1657282330812d-05, 1.7098196834900d-04, 5.8911655113023d-04,
     |   1.7286118490275d-03, 4.3637167153867d-03, 9.5371477363265d-03,
     |   1.8087698533731d-02, 2.9690834250573d-02, 4.1768100679209d-02,
     |   4.9193182101085d-02, 4.5861272666452d-02, 2.8293587221011d-02,
     |  -3.8547461327367d-04,-2.9271961300328d-02,-4.3852003755261d-02,
     |  -3.4636142345834d-02,-5.0684422761730d-03, 2.7895577214750d-02,
     |   4.3149228357279d-02, 2.9753034797465d-02,-4.0708145464123d-03,
     |  -3.5199374175205d-02,-4.1510939435225d-02,-1.8189527306301d-02,
     |   1.8189527306301d-02, 4.1510939435225d-02, 3.5199374175205d-02,
     |   4.0708145464124d-03,-2.9753034797465d-02,-4.3149228357279d-02,
     |  -2.7895577214750d-02, 5.0684422761727d-03, 3.4636142345834d-02,
     |   4.3852003755261d-02, 2.9271961300328d-02, 3.8547461327384d-04,
     |  -2.8293587221010d-02,-4.5861272666452d-02,-4.9193182101085d-02,
     |  -4.1768100679209d-02,-2.9690834250573d-02,-1.8087698533731d-02,
     |  -9.5371477363265d-03,-4.3637167153868d-03,-1.7286118490275d-03,
     |  -5.8911655113026d-04,-1.7098196834908d-04,-4.1657282330798d-05,
     |  -8.3553438202466d-06,-1.3442506133876d-06,-1.6753894925500d-07,
     |  -1.5428112826973d-08,-9.8273400292298d-10,-3.9373473513681d-11,
     |  -8.5942098757092d-13,-7.9875382127472d-15, 7.6241033192100d-17,
     |   5.4293922052602d-17,-4.4431963804184d-17, 4.1127428736769d-17/
      data (zmn(lat,24,30), lat = 1,72)/
     |   1.2487716077497d-17,-2.8109248287458d-17,-1.0263016675073d-16,
     |  -1.4392934356830d-16, 5.2116124162866d-16, 8.5813910588682d-14,
     |   4.7038926109493d-12, 1.3732409877727d-10, 2.4826306127412d-09,
     |   3.0694378697764d-08, 2.7806311937319d-07, 1.9397270835675d-06,
     |   1.0809501195396d-05, 4.9471762882094d-05, 1.8990784700869d-04,
     |   6.2133169558034d-04, 1.7535290920717d-03, 4.3056295192986d-03,
     |   9.2477842963274d-03, 1.7410697644924d-02, 2.8676305554168d-02,
     |   4.1000100594565d-02, 4.9979631072162d-02, 4.9876630337526d-02,
     |   3.6443360424878d-02, 1.0541344515437d-02,-1.9847000939053d-02,
     |  -4.1669789793138d-02,-4.3258990749864d-02,-2.2082254050615d-02,
     |   1.1543440942047d-02, 3.8675143612412d-02, 4.2708240809799d-02,
     |   2.0440158271510d-02,-1.4716272601704d-02,-4.0596962822537d-02,
     |  -4.0596962822537d-02,-1.4716272601705d-02, 2.0440158271510d-02,
     |   4.2708240809799d-02, 3.8675143612412d-02, 1.1543440942047d-02,
     |  -2.2082254050615d-02,-4.3258990749864d-02,-4.1669789793138d-02,
     |  -1.9847000939053d-02, 1.0541344515436d-02, 3.6443360424878d-02,
     |   4.9876630337526d-02, 4.9979631072162d-02, 4.1000100594565d-02,
     |   2.8676305554168d-02, 1.7410697644924d-02, 9.2477842963274d-03,
     |   4.3056295192985d-03, 1.7535290920718d-03, 6.2133169558032d-04,
     |   1.8990784700873d-04, 4.9471762882184d-05, 1.0809501195331d-05,
     |   1.9397270835681d-06, 2.7806311934154d-07, 3.0694378770718d-08,
     |   2.4826306290150d-09, 1.3732410345763d-10, 4.7039085483438d-12,
     |   8.5848836959609d-14, 4.9259718928809d-16,-1.1128617550833d-16,
     |  -1.2564163372844d-16,-2.6062301682854d-17, 3.5713960279027d-18/
      data (zmn(lat,25,30), lat = 1,72)/
     |  -9.6404621336452d-18,-2.6021099349844d-17,-5.0947000814784d-17,
     |  -9.1598999668277d-17,-6.7319434317693d-17, 7.5736636983959d-15,
     |   5.0268267818155d-13, 1.7150985797586d-11, 3.5664372161544d-10,
     |   5.0131325730302d-09, 5.1188205284107d-08, 3.9992610166975d-07,
     |   2.4847752832650d-06, 1.2641123770688d-05, 5.3856013461097d-05,
     |   1.9551907718569d-04, 6.1304153598747d-04, 1.6771630973370d-03,
     |   4.0334176295011d-03, 8.5679898034658d-03, 1.6110589674913d-02,
     |   2.6785131114190d-02, 3.9157449677924d-02, 4.9690466016697d-02,
     |   5.3241675579951d-02, 4.5064424936663d-02, 2.3857978602298d-02,
     |  -5.7477018107098d-03,-3.3376363604291d-02,-4.6862452888921d-02,
     |  -3.8717213094673d-02,-1.1516236249607d-02, 2.1725878100109d-02,
     |   4.3587430577678d-02, 4.1878803281732d-02, 1.7126869963404d-02,
     |  -1.7126869963404d-02,-4.1878803281732d-02,-4.3587430577678d-02,
     |  -2.1725878100109d-02, 1.1516236249607d-02, 3.8717213094673d-02,
     |   4.6862452888921d-02, 3.3376363604292d-02, 5.7477018107099d-03,
     |  -2.3857978602298d-02,-4.5064424936663d-02,-5.3241675579951d-02,
     |  -4.9690466016697d-02,-3.9157449677924d-02,-2.6785131114190d-02,
     |  -1.6110589674914d-02,-8.5679898034659d-03,-4.0334176295011d-03,
     |  -1.6771630973371d-03,-6.1304153598739d-04,-1.9551907718572d-04,
     |  -5.3856013461098d-05,-1.2641123770654d-05,-2.4847752832886d-06,
     |  -3.9992610167867d-07,-5.1188205293372d-08,-5.0131326132922d-09,
     |  -3.5664371908106d-10,-1.7150958043242d-11,-5.0271922429806d-13,
     |  -7.6057777734104d-15, 7.3793738294531d-17, 7.1139649576295d-17,
     |   4.6215069110691d-17,-1.4511365146034d-17,-9.3744830148339d-18/
      data (zmn(lat,26,30), lat = 1,72)/
     |   9.9607090038229d-17, 4.3905411597683d-17,-3.7122956405035d-17,
     |  -1.1175167467143d-16,-1.4232665429160d-16, 4.4754034144402d-16,
     |   4.7348620147601d-14, 1.8912083450184d-12, 4.5189525120729d-11,
     |   7.2128713688059d-10, 8.2891011767287d-09, 7.2404491426093d-08,
     |   5.0049039324545d-07, 2.8231139379305d-06, 1.3307039675353d-05,
     |   5.3398947400842d-05, 1.8511443544750d-04, 5.6078494663138d-04,
     |   1.4978321120939d-03, 3.5507397519504d-03, 7.5045297525207d-03,
     |   1.4174199355937d-02, 2.3921513550007d-02, 3.5951984383897d-02,
     |   4.7716075158417d-02, 5.4960957247664d-02, 5.2914370233121d-02,
     |   3.8558754626184d-02, 1.3108738703376d-02,-1.6841602023227d-02,
     |  -4.0840908205383d-02,-4.8831361508204d-02,-3.6373023676501d-02,
     |  -7.9263924220567d-03, 2.4178187326542d-02, 4.5189557933309d-02,
     |   4.5189557933309d-02, 2.4178187326543d-02,-7.9263924220566d-03,
     |  -3.6373023676501d-02,-4.8831361508204d-02,-4.0840908205383d-02,
     |  -1.6841602023227d-02, 1.3108738703376d-02, 3.8558754626184d-02,
     |   5.2914370233121d-02, 5.4960957247664d-02, 4.7716075158417d-02,
     |   3.5951984383898d-02, 2.3921513550007d-02, 1.4174199355937d-02,
     |   7.5045297525207d-03, 3.5507397519505d-03, 1.4978321120939d-03,
     |   5.6078494663146d-04, 1.8511443544746d-04, 5.3398947400820d-05,
     |   1.3307039675304d-05, 2.8231139378408d-06, 5.0049039329330d-07,
     |   7.2404491420332d-08, 8.2891011132126d-09, 7.2128706871732d-10,
     |   4.5189519855660d-11, 1.8911785787382d-12, 4.7340437557439d-14,
     |   4.2709118917395d-16,-2.2202534740906d-16,-7.9424410251208d-17,
     |  -1.0534304113640d-16, 6.3208932043207d-17, 8.6822444499815d-17/
      data (zmn(lat,27,30), lat = 1,72)/
     |   1.8818214015086d-17, 3.8746706488514d-17, 2.1876425287027d-17,
     |  -3.3128773101871d-17,-9.0695074972079d-17,-1.0825248677508d-16,
     |   3.7067088851818d-15, 1.8054857125213d-13, 4.9571260742833d-12,
     |   8.9752087723633d-11, 1.1593948768678d-09, 1.1305300592580d-08,
     |   8.6786954935784d-08, 5.4161105568214d-07, 2.8172246539171d-06,
     |   1.2456761236012d-05, 4.7560386032185d-05, 1.5877703471031d-04,
     |   4.6814630679223d-04, 1.2287486860706d-03, 2.8885011576910d-03,
     |   6.1082520773264d-03, 1.1651278547880d-02, 2.0064138719891d-02,
     |   3.1149623430530d-02, 4.3399803635219d-02, 5.3742200171985d-02,
     |   5.8007946647278d-02, 5.2311337776310d-02, 3.5027065875918d-02,
     |   8.4895997117328d-03,-2.0687931741631d-02,-4.3355742289260d-02,
     |  -5.1292345749381d-02,-4.0951948566353d-02,-1.5584003143621d-02,
     |   1.5584003143621d-02, 4.0951948566353d-02, 5.1292345749381d-02,
     |   4.3355742289260d-02, 2.0687931741631d-02,-8.4895997117329d-03,
     |  -3.5027065875917d-02,-5.2311337776310d-02,-5.8007946647278d-02,
     |  -5.3742200171985d-02,-4.3399803635219d-02,-3.1149623430531d-02,
     |  -2.0064138719891d-02,-1.1651278547880d-02,-6.1082520773264d-03,
     |  -2.8885011576910d-03,-1.2287486860706d-03,-4.6814630679227d-04,
     |  -1.5877703471027d-04,-4.7560386032258d-05,-1.2456761236017d-05,
     |  -2.8172246538779d-06,-5.4161105566081d-07,-8.6786954871275d-08,
     |  -1.1305300600505d-08,-1.1593948877843d-09,-8.9752076706826d-11,
     |  -4.9570875466680d-12,-1.8054499118890d-13,-3.6338109539716d-15,
     |   1.5308175426889d-16, 1.3039690236099d-16, 3.2353971245950d-17,
     |  -3.5192665185506d-17, 1.5811788522105d-19,-4.8142867418615d-17/
      data (zmn(lat,28,30), lat = 1,72)/
     |   1.3165968148705d-16, 1.1180720125220d-16, 6.3564144522197d-17,
     |   7.5772477559595d-19,-6.3681269674115d-17,-1.2394370971028d-16,
     |   1.0403864529506d-16, 1.4344249544673d-14, 4.5645838159056d-13,
     |   9.3683909464308d-12, 1.3588238486068d-10, 1.4772005417525d-09,
     |   1.2574303459653d-08, 8.6661114487859d-08, 4.9635915238702d-07,
     |   2.4120351595467d-06, 1.0111022256208d-05, 3.7056463833979d-05,
     |   1.2004263743021d-04, 3.4679377230688d-04, 8.9990168212007d-04,
     |   2.1095664269281d-03, 4.4872111079843d-03, 8.6877070310575d-03,
     |   1.5338110278713d-02, 2.4701725345076d-02, 3.6233733305579d-02,
     |   4.8208260940801d-02, 5.7687996109305d-02, 6.1073392871597d-02,
     |   5.5254987911097d-02, 3.9051356672512d-02, 1.4318494648522d-02,
     |  -1.3922855234420d-02,-3.8664954485301d-02,-5.3120668736598d-02,
     |  -5.3120668736598d-02,-3.8664954485301d-02,-1.3922855234420d-02,
     |   1.4318494648522d-02, 3.9051356672512d-02, 5.5254987911097d-02,
     |   6.1073392871597d-02, 5.7687996109305d-02, 4.8208260940802d-02,
     |   3.6233733305579d-02, 2.4701725345076d-02, 1.5338110278714d-02,
     |   8.6877070310575d-03, 4.4872111079843d-03, 2.1095664269281d-03,
     |   8.9990168212011d-04, 3.4679377230688d-04, 1.2004263743022d-04,
     |   3.7056463833991d-05, 1.0111022256200d-05, 2.4120351596147d-06,
     |   4.9635915242278d-07, 8.6661114534358d-08, 1.2574303467349d-08,
     |   1.4772005515729d-09, 1.3588246880247d-10, 9.3684148828525d-12,
     |   4.5639311973157d-13, 1.4331812802489d-14, 6.9194754221181d-17,
     |  -1.4092124399083d-16,-4.9031279679387d-17,-4.3886135641983d-17,
     |   8.8387977701449d-17, 7.1030519321349d-17, 1.2121932007780d-16/
      data (zmn(lat,29,30), lat = 1,72)/
     |  -2.9381331297343d-17,-9.3089871276507d-17,-1.4853109504219d-16,
     |  -1.8784558015072d-16,-2.3035976708850d-16,-2.5119539841575d-16,
     |  -2.3218068859219d-16, 7.0508089055258d-16, 3.3173524485757d-14,
     |   7.7452360286716d-13, 1.2603002949612d-11, 1.5257476123835d-10,
     |   1.4381996696887d-09, 1.0929136301510d-08, 6.8800865965103d-08,
     |   3.6663829008400d-07, 1.6830357411811d-06, 6.7505318820021d-06,
     |   2.3936074406142d-05, 7.5760555282200d-05, 2.1577445314115d-04,
     |   5.5670046137037d-04, 1.3082803559714d-03, 2.8131209451981d-03,
     |   5.5543488110938d-03, 1.0097200472153d-02, 1.6930494771258d-02,
     |   2.6205445689128d-02, 3.7428950827836d-02, 4.9235315559060d-02,
     |   5.9393616796449d-02, 6.5166486585550d-02, 6.4009011136896d-02,
     |   5.4424709578683d-02, 3.6664290722072d-02, 1.2948589137485d-02,
     |  -1.2948589137485d-02,-3.6664290722072d-02,-5.4424709578682d-02,
     |  -6.4009011136896d-02,-6.5166486585550d-02,-5.9393616796449d-02,
     |  -4.9235315559060d-02,-3.7428950827836d-02,-2.6205445689128d-02,
     |  -1.6930494771258d-02,-1.0097200472153d-02,-5.5543488110938d-03,
     |  -2.8131209451981d-03,-1.3082803559714d-03,-5.5670046137037d-04,
     |  -2.1577445314115d-04,-7.5760555282208d-05,-2.3936074406135d-05,
     |  -6.7505318820124d-06,-1.6830357411837d-06,-3.6663829008528d-07,
     |  -6.8800865999510d-08,-1.0929136333084d-08,-1.4381997427702d-09,
     |  -1.5257479021977d-10,-1.2603068486144d-11,-7.7454074161043d-13,
     |  -3.3180636676535d-14,-7.1256933209133d-16, 2.0106002827732d-16,
     |   2.3707844653687d-16, 2.0172771895714d-16, 2.1404090770422d-16,
     |   1.4531234237252d-16, 9.2163711011712d-17, 3.9124198331798d-17/
      data (zmn(lat,30,30), lat = 1,72)/
     |   3.8972846524973d-17, 3.2392534666859d-17, 1.0303054607806d-17,
     |  -1.8480219140713d-17,-3.8778088347092d-17,-7.1999343123673d-17,
     |  -9.5734492874891d-17,-5.1871970567555d-17, 1.5706603487393d-15,
     |   4.3893479483559d-14, 8.0225905126560d-13, 1.0806208654241d-11,
     |   1.1266769163375d-10, 9.4276349501558d-10, 6.5126643802376d-09,
     |   3.7988587946729d-08, 1.9054855116969d-07, 8.3427010241305d-07,
     |   3.2279960035306d-06, 1.1152688861003d-05, 3.4708307863484d-05,
     |   9.8017931023094d-05, 2.5277412073642d-04, 5.9848951400665d-04,
     |   1.3070338924329d-03, 2.6433236666570d-03, 4.9674208296206d-03,
     |   8.6996490525744d-03, 1.4234780232995d-02, 2.1807312364457d-02,
     |   3.1335233915971d-02, 4.2294792191069d-02, 5.3689002246042d-02,
     |   6.4155772344462d-02, 7.2216806613437d-02, 7.6610894722413d-02,
     |   7.6610894722413d-02, 7.2216806613437d-02, 6.4155772344462d-02,
     |   5.3689002246042d-02, 4.2294792191069d-02, 3.1335233915971d-02,
     |   2.1807312364457d-02, 1.4234780232995d-02, 8.6996490525744d-03,
     |   4.9674208296206d-03, 2.6433236666570d-03, 1.3070338924329d-03,
     |   5.9848951400665d-04, 2.5277412073642d-04, 9.8017931023082d-05,
     |   3.4708307863458d-05, 1.1152688860989d-05, 3.2279960035355d-06,
     |   8.3427010239798d-07, 1.9054855118933d-07, 3.7988587944217d-08,
     |   6.5126643861718d-09, 9.4276350411591d-10, 1.1266770714189d-10,
     |   1.0806219938057d-11, 8.0224322051618d-13, 4.3891036104514d-14,
     |   1.5883911223908d-15,-6.2286883804101d-17,-6.6410112982732d-17,
     |  -5.1674609556911d-17,-2.4928175370557d-17,-1.7950178515261d-17,
     |   6.8878328933438d-18, 1.4222463796745d-17, 2.0445500183201d-17/
      data (zmn(lat, 0,31), lat = 1,72)/
     |   3.9564839334599d-03, 3.4996703979248d-03,-1.0220817317275d-02,
     |  -8.6021171234093d-03, 9.3023598573014d-03, 1.5247208685498d-02,
     |  -5.2471946814909d-03,-1.9526284630840d-02,-2.3775821334826d-03,
     |   2.1177430845942d-02, 1.0981708432651d-02,-1.8462905841542d-02,
     |  -1.9561522892840d-02, 1.2168111021488d-02, 2.5585687446038d-02,
     |  -2.4981513942400d-03,-2.8178730094593d-02,-8.4578242222234d-03,
     |   2.5982135886713d-02, 1.9284177976644d-02,-1.9479514316638d-02,
     |  -2.7561275933482d-02, 9.0842028121360d-03, 3.2087822320082d-02,
     |   3.2183507946962d-03,-3.1483313704494d-02,-1.5796217433211d-02,
     |   2.5990334357938d-02, 2.6171406972147d-02,-1.6001263913812d-02,
     |  -3.2884344117956d-02, 3.3942939151828d-03, 3.4398329804487d-02,
     |   1.0131326976406d-02,-3.0705778755358d-02,-2.2042923003155d-02,
     |   2.2042923003155d-02, 3.0705778755358d-02,-1.0131326976406d-02,
     |  -3.4398329804487d-02,-3.3942939151829d-03, 3.2884344117956d-02,
     |   1.6001263913812d-02,-2.6171406972147d-02,-2.5990334357938d-02,
     |   1.5796217433210d-02, 3.1483313704494d-02,-3.2183507946958d-03,
     |  -3.2087822320082d-02,-9.0842028121360d-03, 2.7561275933482d-02,
     |   1.9479514316639d-02,-1.9284177976644d-02,-2.5982135886713d-02,
     |   8.4578242222232d-03, 2.8178730094593d-02, 2.4981513942402d-03,
     |  -2.5585687446038d-02,-1.2168111021488d-02, 1.9561522892840d-02,
     |   1.8462905841542d-02,-1.0981708432651d-02,-2.1177430845943d-02,
     |   2.3775821334825d-03, 1.9526284630840d-02, 5.2471946814907d-03,
     |  -1.5247208685498d-02,-9.3023598573015d-03, 8.6021171234092d-03,
     |   1.0220817317275d-02,-3.4996703979247d-03,-3.9564839334601d-03/
      data (zmn(lat, 1,31), lat = 1,72)/
     |   2.0347270296183d-03, 9.0526550375784d-03, 4.4407108865307d-03,
     |  -1.1239803263170d-02,-1.1322519112968d-02, 8.7284392548809d-03,
     |   1.7443789356275d-02,-2.6322704061843d-03,-2.0934788805718d-02,
     |  -5.8525432325765d-03, 2.0700272310800d-02, 1.4918187138368d-02,
     |  -1.6292738046967d-02,-2.2680340538460d-02, 8.1921757843496d-03,
     |   2.7379140587827d-02, 2.3916908897322d-03,-2.7818653061980d-02,
     |  -1.3653963415609d-02, 2.3540188603866d-02, 2.3587047109634d-02,
     |  -1.4982924114571d-02,-3.0311752993133d-02, 3.3865937735959d-03,
     |   3.2469652174073d-02, 9.3871544989583d-03,-2.9462589390744d-02,
     |  -2.1206432688675d-02, 2.1602405944832d-02, 3.0033816487819d-02,
     |  -1.0057544821761d-02,-3.4310994315895d-02,-3.3298819082181d-03,
     |   3.3235392103806d-02, 1.6372998747002d-02,-2.6919443336750d-02,
     |  -2.6919443336750d-02, 1.6372998747002d-02, 3.3235392103806d-02,
     |  -3.3298819082179d-03,-3.4310994315895d-02,-1.0057544821761d-02,
     |   3.0033816487819d-02, 2.1602405944832d-02,-2.1206432688675d-02,
     |  -2.9462589390744d-02, 9.3871544989580d-03, 3.2469652174073d-02,
     |   3.3865937735959d-03,-3.0311752993133d-02,-1.4982924114571d-02,
     |   2.3587047109634d-02, 2.3540188603866d-02,-1.3653963415609d-02,
     |  -2.7818653061980d-02, 2.3916908897323d-03, 2.7379140587827d-02,
     |   8.1921757843495d-03,-2.2680340538460d-02,-1.6292738046967d-02,
     |   1.4918187138368d-02, 2.0700272310800d-02,-5.8525432325766d-03,
     |  -2.0934788805718d-02,-2.6322704061843d-03, 1.7443789356275d-02,
     |   8.7284392548811d-03,-1.1322519112968d-02,-1.1239803263170d-02,
     |   4.4407108865308d-03, 9.0526550375785d-03, 2.0347270296181d-03/
      data (zmn(lat, 2,31), lat = 1,72)/
     |   3.5111106636533d-04, 5.8150146291563d-03, 1.2484753362670d-02,
     |   4.2006609207260d-03,-1.3110636622185d-02,-1.2846959082491d-02,
     |   8.9306496829759d-03, 1.9162752143981d-02,-1.1391662124406d-03,
     |  -2.1956753772102d-02,-8.4043206299885d-03, 2.0283282279400d-02,
     |   1.7806654180264d-02,-1.4274543171637d-02,-2.4960944239520d-02,
     |   4.7253965665622d-03, 2.8327072106413d-02, 6.6701770561420d-03,
     |  -2.6887999026369d-02,-1.7944533668928d-02, 2.0657292409731d-02,
     |   2.6934497789787d-02,-1.0423174225986d-02,-3.1948361136779d-02,
     |  -2.1295063338939d-03, 3.1848653461941d-02, 1.4949619342741d-02,
     |  -2.6502951019010d-02,-2.5768935081558d-02, 1.6610578081117d-02,
     |   3.2724820196878d-02,-3.7956000000468d-03,-3.4501299034005d-02,
     |  -9.8747314265260d-03, 3.0769668728919d-02, 2.2063097272328d-02,
     |  -2.2063097272328d-02,-3.0769668728919d-02, 9.8747314265258d-03,
     |   3.4501299034005d-02, 3.7956000000470d-03,-3.2724820196878d-02,
     |  -1.6610578081117d-02, 2.5768935081558d-02, 2.6502951019010d-02,
     |  -1.4949619342740d-02,-3.1848653461941d-02, 2.1295063338934d-03,
     |   3.1948361136779d-02, 1.0423174225986d-02,-2.6934497789786d-02,
     |  -2.0657292409732d-02, 1.7944533668928d-02, 2.6887999026369d-02,
     |  -6.6701770561418d-03,-2.8327072106413d-02,-4.7253965665624d-03,
     |   2.4960944239520d-02, 1.4274543171637d-02,-1.7806654180264d-02,
     |  -2.0283282279400d-02, 8.4043206299883d-03, 2.1956753772102d-02,
     |   1.1391662124407d-03,-1.9162752143981d-02,-8.9306496829758d-03,
     |   1.2846959082491d-02, 1.3110636622185d-02,-4.2006609207259d-03,
     |  -1.2484753362670d-02,-5.8150146291565d-03,-3.5111106636517d-04/
      data (zmn(lat, 3,31), lat = 1,72)/
     |   1.0941755075749d-05, 2.2306800373887d-03, 1.0071966733903d-02,
     |   1.4739213198768d-02, 2.9492478778480d-03,-1.5434039903060d-02,
     |  -1.3576072852221d-02, 9.8287510911865d-03, 2.0604050456433d-02,
     |  -4.9222254507658d-04,-2.2913164775126d-02,-1.0238761539409d-02,
     |   2.0063824425983d-02, 2.0004906336236d-02,-1.2545303597138d-02,
     |  -2.6684607080583d-02, 1.7181353181112d-03, 2.8762617698489d-02,
     |   1.0402760052773d-02,-2.5592553398213d-02,-2.1522881616642d-02,
     |   1.7529054142711d-02, 2.9485990196144d-02,-5.8630546770015d-03,
     |  -3.2684270249807d-02,-7.4054500958607d-03, 3.0360234252621d-02,
     |   1.9936509332640d-02,-2.2760472515004d-02,-2.9477930915991d-02,
     |   1.1097994952596d-02, 3.4284344865395d-02, 2.6601771538144d-03,
     |  -3.3440501139084d-02,-1.6149270385356d-02, 2.7035317356353d-02,
     |   2.7035317356353d-02,-1.6149270385356d-02,-3.3440501139084d-02,
     |   2.6601771538142d-03, 3.4284344865395d-02, 1.1097994952596d-02,
     |  -2.9477930915991d-02,-2.2760472515004d-02, 1.9936509332640d-02,
     |   3.0360234252622d-02,-7.4054500958605d-03,-3.2684270249807d-02,
     |  -5.8630546770015d-03, 2.9485990196144d-02, 1.7529054142711d-02,
     |  -2.1522881616642d-02,-2.5592553398213d-02, 1.0402760052773d-02,
     |   2.8762617698489d-02, 1.7181353181112d-03,-2.6684607080583d-02,
     |  -1.2545303597138d-02, 2.0004906336236d-02, 2.0063824425984d-02,
     |  -1.0238761539410d-02,-2.2913164775126d-02,-4.9222254507655d-04,
     |   2.0604050456433d-02, 9.8287510911865d-03,-1.3576072852221d-02,
     |  -1.5434039903060d-02, 2.9492478778479d-03, 1.4739213198768d-02,
     |   1.0071966733903d-02, 2.2306800373888d-03, 1.0941755075901d-05/
      data (zmn(lat, 4,31), lat = 1,72)/
     |   1.0705030356246d-06, 6.0442311132983d-04, 5.1551803777331d-03,
     |   1.4103693061693d-02, 1.6021225743872d-02, 7.7373013684311d-04,
     |  -1.7865062232651d-02,-1.3689257259434d-02, 1.1313048272148d-02,
     |   2.1795531590032d-02,-4.6260244036748d-04,-2.3933909080667d-02,
     |  -1.1513093035379d-02, 2.0046362537808d-02, 2.1767441905582d-02,
     |  -1.1121275997955d-02,-2.8029649500603d-02,-9.4000530023077d-04,
     |   2.8886620354248d-02, 1.3690224430860d-02,-2.4024014082624d-02,
     |  -2.4560368076433d-02, 1.4237906138540d-02, 3.1357555024096d-02,
     |  -1.2943343296234d-03,-3.2652201402808d-02,-1.2428793400633d-02,
     |   2.8063880744968d-02, 2.4372808362629d-02,-1.8313966829484d-02,
     |  -3.2298578408172d-02, 5.1085429656516d-03, 3.4690904296249d-02,
     |   9.1973378060771d-03,-3.1060967489259d-02,-2.2023080796290d-02,
     |   2.2023080796290d-02, 3.1060967489259d-02,-9.1973378060769d-03,
     |  -3.4690904296249d-02,-5.1085429656518d-03, 3.2298578408172d-02,
     |   1.8313966829484d-02,-2.4372808362629d-02,-2.8063880744968d-02,
     |   1.2428793400632d-02, 3.2652201402808d-02, 1.2943343296239d-03,
     |  -3.1357555024096d-02,-1.4237906138540d-02, 2.4560368076433d-02,
     |   2.4024014082624d-02,-1.3690224430860d-02,-2.8886620354248d-02,
     |   9.4000530023062d-04, 2.8029649500603d-02, 1.1121275997955d-02,
     |  -2.1767441905582d-02,-2.0046362537808d-02, 1.1513093035378d-02,
     |   2.3933909080667d-02, 4.6260244036760d-04,-2.1795531590032d-02,
     |  -1.1313048272148d-02, 1.3689257259434d-02, 1.7865062232651d-02,
     |  -7.7373013684277d-04,-1.6021225743872d-02,-1.4103693061693d-02,
     |  -5.1551803777331d-03,-6.0442311132980d-04,-1.0705030357065d-06/
      data (zmn(lat, 5,31), lat = 1,72)/
     |   1.6022291871665d-06, 1.2645210318696d-04, 1.9652520786016d-03,
     |   8.7133370503169d-03, 1.7706276360050d-02, 1.6308787246471d-02,
     |  -2.0957721710468d-03,-2.0217093293611d-02,-1.3223796107614d-02,
     |   1.3204703458548d-02, 2.2766556831503d-02,-9.1356407756896d-04,
     |  -2.5014693944900d-02,-1.2388673430569d-02, 2.0214523837840d-02,
     |   2.3238532885686d-02,-9.9265647214002d-03,-2.9132706352520d-02,
     |  -3.3497386570150d-03, 2.8778398945651d-02, 1.6663685250012d-02,
     |  -2.2222001723843d-02,-2.7165926879849d-02, 1.0769779511207d-02,
     |   3.2636287045390d-02, 3.3040148076121d-03,-3.1888212193941d-02,
     |  -1.7217992818436d-02, 2.4976914258080d-02, 2.8229250388840d-02,
     |  -1.3171588553253d-02,-3.4164398767671d-02,-1.3010007889646d-03,
     |   3.3836300565713d-02, 1.5693194451674d-02,-2.7269653810694d-02,
     |  -2.7269653810694d-02, 1.5693194451674d-02, 3.3836300565713d-02,
     |  -1.3010007889644d-03,-3.4164398767671d-02,-1.3171588553253d-02,
     |   2.8229250388840d-02, 2.4976914258080d-02,-1.7217992818436d-02,
     |  -3.1888212193941d-02, 3.3040148076119d-03, 3.2636287045390d-02,
     |   1.0769779511207d-02,-2.7165926879849d-02,-2.2222001723843d-02,
     |   1.6663685250011d-02, 2.8778398945651d-02,-3.3497386570149d-03,
     |  -2.9132706352520d-02,-9.9265647214001d-03, 2.3238532885686d-02,
     |   2.0214523837840d-02,-1.2388673430569d-02,-2.5014693944900d-02,
     |  -9.1356407756884d-04, 2.2766556831503d-02, 1.3204703458548d-02,
     |  -1.3223796107614d-02,-2.0217093293611d-02,-2.0957721710466d-03,
     |   1.6308787246471d-02, 1.7706276360050d-02, 8.7133370503168d-03,
     |   1.9652520786017d-03, 1.2645210318699d-04, 1.6022291871324d-06/
      data (zmn(lat, 6,31), lat = 1,72)/
     |   8.6245715269327d-08, 2.1979209910994d-05, 5.9915137314916d-04,
     |   4.0786879546512d-03, 1.2592938781313d-02, 2.0712667831822d-02,
     |   1.5637685291064d-02,-5.4404015119390d-03,-2.2336682037155d-02,
     |  -1.2231698606936d-02, 1.5348409362702d-02, 2.3522120692762d-02,
     |  -1.7189781900390d-03,-2.6127245725619d-02,-1.2992471468698d-02,
     |   2.0515055598381d-02, 2.4524795157481d-02,-8.8662181420300d-03,
     |  -3.0070924618314d-02,-5.6234914286175d-03, 2.8459884039291d-02,
     |   1.9434952934354d-02,-2.0164647445478d-02,-2.9412487031297d-02,
     |   7.0732491609548d-03, 3.3347346883431d-02, 7.9688645107404d-03,
     |  -3.0367622818807d-02,-2.1766092746342d-02, 2.1062257435203d-02,
     |   3.1426352265436d-02,-7.3255538063257d-03,-3.4935802174619d-02,
     |  -8.0497649844540d-03, 3.1553127034871d-02, 2.1945897090739d-02,
     |  -2.1945897090739d-02,-3.1553127034871d-02, 8.0497649844538d-03,
     |   3.4935802174619d-02, 7.3255538063260d-03,-3.1426352265436d-02,
     |  -2.1062257435203d-02, 2.1766092746342d-02, 3.0367622818807d-02,
     |  -7.9688645107402d-03,-3.3347346883431d-02,-7.0732491609552d-03,
     |   2.9412487031297d-02, 2.0164647445478d-02,-1.9434952934354d-02,
     |  -2.8459884039292d-02, 5.6234914286174d-03, 3.0070924618314d-02,
     |   8.8662181420302d-03,-2.4524795157481d-02,-2.0515055598381d-02,
     |   1.2992471468698d-02, 2.6127245725619d-02, 1.7189781900393d-03,
     |  -2.3522120692762d-02,-1.5348409362702d-02, 1.2231698606936d-02,
     |   2.2336682037155d-02, 5.4404015119390d-03,-1.5637685291064d-02,
     |  -2.0712667831822d-02,-1.2592938781313d-02,-4.0786879546511d-03,
     |  -5.9915137314922d-04,-2.1979209911010d-05,-8.6245715205775d-08/
      data (zmn(lat, 7,31), lat = 1,72)/
     |  -7.3451212456064d-08, 3.3093520827855d-06, 1.5233375980100d-04,
     |   1.5489545026810d-03, 6.8304193513341d-03, 1.6543757846217d-02,
     |   2.2996779375446d-02, 1.4104601565326d-02,-9.0556305852667d-03,
     |  -2.4110727372126d-02,-1.0792540044954d-02, 1.7611964106377d-02,
     |   2.4069292205790d-02,-2.7570372930527d-03,-2.7240549957714d-02,
     |  -1.3433052441787d-02, 2.0876780842691d-02, 2.5710226118012d-02,
     |  -7.8367176945008d-03,-3.0879640769297d-02,-7.8756968673565d-03,
     |   2.7909999040238d-02, 2.2091272233216d-02,-1.7786347534676d-02,
     |  -3.1330956822008d-02, 3.0777739211916d-03, 3.3454124964230d-02,
     |   1.2728656534838d-02,-2.8010779447099d-02,-2.6016841029379d-02,
     |   1.6248467035375d-02, 3.3812185155314d-02,-7.8429541115460d-04,
     |  -3.4392564602506d-02,-1.4986821569868d-02, 2.7627778427025d-02,
     |   2.7627778427025d-02,-1.4986821569868d-02,-3.4392564602506d-02,
     |  -7.8429541115468d-04, 3.3812185155314d-02, 1.6248467035375d-02,
     |  -2.6016841029379d-02,-2.8010779447100d-02, 1.2728656534839d-02,
     |   3.3454124964230d-02, 3.0777739211918d-03,-3.1330956822008d-02,
     |  -1.7786347534676d-02, 2.2091272233216d-02, 2.7909999040238d-02,
     |  -7.8756968673561d-03,-3.0879640769297d-02,-7.8367176945009d-03,
     |   2.5710226118012d-02, 2.0876780842691d-02,-1.3433052441787d-02,
     |  -2.7240549957714d-02,-2.7570372930527d-03, 2.4069292205790d-02,
     |   1.7611964106377d-02,-1.0792540044954d-02,-2.4110727372126d-02,
     |  -9.0556305852668d-03, 1.4104601565326d-02, 2.2996779375446d-02,
     |   1.6543757846217d-02, 6.8304193513343d-03, 1.5489545026810d-03,
     |   1.5233375980090d-04, 3.3093520828077d-06,-7.3451212399279d-08/
      data (zmn(lat, 8,31), lat = 1,72)/
     |  -2.9113076073967d-09, 4.2010306429697d-07, 3.3214473048836d-05,
     |   4.9589055544137d-04, 3.0270144189007d-03, 1.0070915032010d-02,
     |   2.0350164116435d-02, 2.4494659883444d-02, 1.1847197682038d-02,
     |  -1.2752045321914d-02,-2.5477407380185d-02,-9.0072710036200d-03,
     |   1.9882713977580d-02, 2.4433686812571d-02,-3.9113145492882d-03,
     |  -2.8326998951316d-02,-1.3814016030155d-02, 2.1222222659081d-02,
     |   2.6862069289495d-02,-6.7269092561298d-03,-3.1564367614411d-02,
     |  -1.0215179991152d-02, 2.7069593272137d-02, 2.4692661519803d-02,
     |  -1.4991557504774d-02,-3.2901305983166d-02,-1.2921887352579d-03,
     |   3.2858947495628d-02, 1.7577231620636d-02,-2.4689339694305d-02,
     |  -2.9841046468527d-02, 1.0457791321195d-02, 3.5140900786188d-02,
     |   6.3860954393159d-03,-3.2237689230696d-02,-2.1833586355460d-02,
     |   2.1833586355460d-02, 3.2237689230696d-02,-6.3860954393157d-03,
     |  -3.5140900786188d-02,-1.0457791321195d-02, 2.9841046468527d-02,
     |   2.4689339694305d-02,-1.7577231620636d-02,-3.2858947495629d-02,
     |   1.2921887352578d-03, 3.2901305983166d-02, 1.4991557504775d-02,
     |  -2.4692661519802d-02,-2.7069593272137d-02, 1.0215179991152d-02,
     |   3.1564367614411d-02, 6.7269092561299d-03,-2.6862069289494d-02,
     |  -2.1222222659081d-02, 1.3814016030155d-02, 2.8326998951316d-02,
     |   3.9113145492882d-03,-2.4433686812571d-02,-1.9882713977581d-02,
     |   9.0072710036200d-03, 2.5477407380185d-02, 1.2752045321914d-02,
     |  -1.1847197682038d-02,-2.4494659883443d-02,-2.0350164116435d-02,
     |  -1.0070915032010d-02,-3.0270144189006d-03,-4.9589055544151d-04,
     |  -3.3214473048776d-05,-4.2010306430143d-07, 2.9113075571023d-09/
      data (zmn(lat, 9,31), lat = 1,72)/
     |   3.7057696706165d-09, 4.3052321786831d-08, 6.3284084611452d-06,
     |   1.3717577809585d-04, 1.1379132166218d-03, 5.0232019901684d-03,
     |   1.3633543254924d-02, 2.3837435805879d-02, 2.5204466326772d-02,
     |   9.0317577185015d-03,-1.6366512713957d-02,-2.6425064305740d-02,
     |  -6.9936387698314d-03, 2.2070475457194d-02, 2.4662505038040d-02,
     |  -5.0687555542839d-03,-2.9366714033207d-02,-1.4238572923684d-02,
     |   2.1469258504136d-02, 2.8035073700780d-02,-5.4194263756797d-03,
     |  -3.2102698485745d-02,-1.2741399639533d-02, 2.5844404347364d-02,
     |   2.7263686644484d-02,-1.1663248170253d-02,-3.4043703145926d-02,
     |  -6.0983355314405d-03, 3.1400744054810d-02, 2.2446026750670d-02,
     |  -2.0241016394397d-02,-3.3007630625865d-02, 3.6441999320605d-03,
     |   3.5059273200303d-02, 1.4001979208185d-02,-2.8118293086084d-02,
     |  -2.8118293086084d-02, 1.4001979208185d-02, 3.5059273200303d-02,
     |   3.6441999320607d-03,-3.3007630625865d-02,-2.0241016394397d-02,
     |   2.2446026750670d-02, 3.1400744054810d-02,-6.0983355314404d-03,
     |  -3.4043703145926d-02,-1.1663248170253d-02, 2.7263686644484d-02,
     |   2.5844404347364d-02,-1.2741399639533d-02,-3.2102698485745d-02,
     |  -5.4194263756801d-03, 2.8035073700780d-02, 2.1469258504136d-02,
     |  -1.4238572923683d-02,-2.9366714033206d-02,-5.0687555542840d-03,
     |   2.4662505038040d-02, 2.2070475457194d-02,-6.9936387698311d-03,
     |  -2.6425064305740d-02,-1.6366512713957d-02, 9.0317577185013d-03,
     |   2.5204466326771d-02, 2.3837435805880d-02, 1.3633543254924d-02,
     |   5.0232019901684d-03, 1.1379132166216d-03, 1.3717577809582d-04,
     |   6.3284084612561d-06, 4.3052321860781d-08, 3.7057696600227d-09/
      data (zmn(lat,10,31), lat = 1,72)/
     |   1.1572470244187d-10, 4.2922149640140d-09, 1.0669059453940d-06,
     |   3.3355006948434d-05, 3.7151824453916d-04, 2.1323217570736d-03,
     |   7.4813898973191d-03, 1.7349106556076d-02, 2.6879940334540d-02,
     |   2.5180737269298d-02, 5.8396413686312d-03,-1.9771156768078d-02,
     |  -2.6987550021345d-02,-4.8797769683443d-03, 2.4109005704771d-02,
     |   2.4823128550878d-02,-6.1183390574806d-03,-3.0347310043136d-02,
     |  -1.4811045995955d-02, 2.1528997071603d-02, 2.9270917913919d-02,
     |  -3.7909324658571d-03,-3.2440809920599d-02,-1.5538596965958d-02,
     |   2.4104866586418d-02, 2.9780792010787d-02,-7.6727671697340d-03,
     |  -3.4606515806489d-02,-1.1363374737578d-02, 2.8855568892377d-02,
     |   2.7168851465676d-02,-1.4496625351826d-02,-3.5153636601834d-02,
     |  -4.1482842987344d-03, 3.3107792216448d-02, 2.1682646599847d-02,
     |  -2.1682646599846d-02,-3.3107792216448d-02, 4.1482842987341d-03,
     |   3.5153636601834d-02, 1.4496625351826d-02,-2.7168851465676d-02,
     |  -2.8855568892377d-02, 1.1363374737578d-02, 3.4606515806489d-02,
     |   7.6727671697340d-03,-2.9780792010787d-02,-2.4104866586419d-02,
     |   1.5538596965958d-02, 3.2440809920599d-02, 3.7909324658572d-03,
     |  -2.9270917913919d-02,-2.1528997071603d-02, 1.4811045995955d-02,
     |   3.0347310043136d-02, 6.1183390574806d-03,-2.4823128550878d-02,
     |  -2.4109005704771d-02, 4.8797769683445d-03, 2.6987550021345d-02,
     |   1.9771156768078d-02,-5.8396413686313d-03,-2.5180737269298d-02,
     |  -2.6879940334540d-02,-1.7349106556076d-02,-7.4813898973191d-03,
     |  -2.1323217570737d-03,-3.7151824453927d-04,-3.3355006948356d-05,
     |  -1.0669059454179d-06,-4.2922148078254d-09,-1.1572463401379d-10/
      data (zmn(lat,11,31), lat = 1,72)/
     |  -1.7592669749011d-10, 5.6322653715448d-10, 1.6074521015218d-07,
     |   7.2184109276612d-06, 1.0706475386139d-04, 7.8853143376175d-04,
     |   3.4981320577699d-03, 1.0312283070809d-02, 2.1060312320984d-02,
     |   2.9405471551214d-02, 2.4525596482850d-02, 2.4536967333927d-03,
     |  -2.2877933650163d-02,-2.7237469850014d-02,-2.7976538122932d-03,
     |   2.5954558949210d-02, 2.4999497494664d-02,-6.9496046961973d-03,
     |  -3.1259602851885d-02,-1.5636411210501d-02, 2.1301128621990d-02,
     |   3.0592736389450d-02,-1.7125000559212d-03,-3.2485636247434d-02,
     |  -1.8665303464038d-02, 2.1684986143168d-02, 3.2153939628318d-02,
     |  -2.8958220992354d-03,-3.4352437768795d-02,-1.7035076525354d-02,
     |   2.4946334328637d-02, 3.1437879985440d-02,-7.3290152245982d-03,
     |  -3.5760491388596d-02,-1.2698488334734d-02, 2.8753921117275d-02,
     |   2.8753921117275d-02,-1.2698488334734d-02,-3.5760491388596d-02,
     |  -7.3290152245983d-03, 3.1437879985440d-02, 2.4946334328637d-02,
     |  -1.7035076525354d-02,-3.4352437768796d-02,-2.8958220992354d-03,
     |   3.2153939628318d-02, 2.1684986143169d-02,-1.8665303464037d-02,
     |  -3.2485636247434d-02,-1.7125000559210d-03, 3.0592736389450d-02,
     |   2.1301128621991d-02,-1.5636411210501d-02,-3.1259602851885d-02,
     |  -6.9496046961976d-03, 2.4999497494664d-02, 2.5954558949210d-02,
     |  -2.7976538122933d-03,-2.7237469850013d-02,-2.2877933650163d-02,
     |   2.4536967333926d-03, 2.4525596482850d-02, 2.9405471551214d-02,
     |   2.1060312320984d-02, 1.0312283070808d-02, 3.4981320577698d-03,
     |   7.8853143376185d-04, 1.0706475386151d-04, 7.2184109276895d-06,
     |   1.6074521010217d-07, 5.6322649933266d-10,-1.7592669745328d-10/
      data (zmn(lat,12,31), lat = 1,72)/
     |  -4.4837576116153d-12, 4.4732630917152d-11, 2.1868292317392d-08,
     |   1.4033342091563d-06, 2.7552922488860d-05, 2.5804694891650d-04,
     |   1.4270087893868d-03, 5.2205285294264d-03, 1.3406289526946d-02,
     |   2.4633930027629d-02, 3.1395516864766d-02, 2.3377687010753d-02,
     |  -9.5299638817955d-04,-2.5638916352152d-02,-2.7277807287619d-02,
     |  -8.7832985525397d-04, 2.7581474288755d-02, 2.5286876371593d-02,
     |  -7.4499248525279d-03,-3.2089859839241d-02,-1.6817663848700d-02,
     |   2.0667103197677d-02, 3.1994716701328d-02, 9.4769543116837d-04,
     |  -3.2093323887134d-02,-2.2136842858203d-02, 1.8384083178661d-02,
     |   3.4201551004561d-02, 2.7597319530876d-03,-3.2947237337326d-02,
     |  -2.2934735696503d-02, 1.9372125347742d-02, 3.4754185792009d-02,
     |   1.2629415848074d-03,-3.4152978140978d-02,-2.1487550411188d-02,
     |   2.1487550411188d-02, 3.4152978140978d-02,-1.2629415848071d-03,
     |  -3.4754185792009d-02,-1.9372125347742d-02, 2.2934735696503d-02,
     |   3.2947237337326d-02,-2.7597319530873d-03,-3.4201551004561d-02,
     |  -1.8384083178661d-02, 2.2136842858203d-02, 3.2093323887134d-02,
     |  -9.4769543116824d-04,-3.1994716701328d-02,-2.0667103197677d-02,
     |   1.6817663848700d-02, 3.2089859839241d-02, 7.4499248525281d-03,
     |  -2.5286876371593d-02,-2.7581474288755d-02, 8.7832985525377d-04,
     |   2.7277807287619d-02, 2.5638916352152d-02, 9.5299638817971d-04,
     |  -2.3377687010753d-02,-3.1395516864765d-02,-2.4633930027629d-02,
     |  -1.3406289526946d-02,-5.2205285294264d-03,-1.4270087893869d-03,
     |  -2.5804694891647d-04,-2.7552922488798d-05,-1.4033342092566d-06,
     |  -2.1868292299539d-08,-4.4732860194152d-11, 4.4837486579616d-12/
      data (zmn(lat,13,31), lat = 1,72)/
     |   7.8686820621612d-12,-4.7494531889452d-12, 2.7079216180908d-09,
     |   2.4684689666651d-07, 6.3871037857107d-06, 7.5567704799503d-05,
     |   5.1584327428850d-04, 2.3063435423809d-03, 7.2551024521932d-03,
     |   1.6646075746465d-02, 2.7969466561399d-02, 3.2881650210165d-02,
     |   2.1900405086713d-02,-4.2247494274776d-03,-2.8042461481674d-02,
     |  -2.7232871417486d-02, 7.5003535579541d-04, 2.8974632019773d-02,
     |   2.5785367511897d-02,-7.5002479477703d-03,-3.2808507000778d-02,
     |  -1.8450280167514d-02, 1.9482028211735d-02, 3.3425983600890d-02,
     |   4.3165104851520d-03,-3.1055524280616d-02,-2.5897721822011d-02,
     |   1.3977069961094d-02, 3.5619645918377d-02, 9.3066256814602d-03,
     |  -2.9960241972426d-02,-2.8687442447055d-02, 1.1873598899724d-02,
     |   3.6384976846044d-02, 1.1021386452144d-02,-2.9552917088124d-02,
     |  -2.9552917088125d-02, 1.1021386452144d-02, 3.6384976846044d-02,
     |   1.1873598899724d-02,-2.8687442447055d-02,-2.9960241972426d-02,
     |   9.3066256814601d-03, 3.5619645918377d-02, 1.3977069961094d-02,
     |  -2.5897721822011d-02,-3.1055524280617d-02, 4.3165104851517d-03,
     |   3.3425983600890d-02, 1.9482028211735d-02,-1.8450280167514d-02,
     |  -3.2808507000778d-02,-7.5002479477704d-03, 2.5785367511897d-02,
     |   2.8974632019774d-02, 7.5003535579552d-04,-2.7232871417486d-02,
     |  -2.8042461481674d-02,-4.2247494274776d-03, 2.1900405086712d-02,
     |   3.2881650210165d-02, 2.7969466561399d-02, 1.6646075746465d-02,
     |   7.2551024521931d-03, 2.3063435423812d-03, 5.1584327428846d-04,
     |   7.5567704799470d-05, 6.3871037856453d-06, 2.4684689661650d-07,
     |   2.7079215350133d-09,-4.7494018793987d-12, 7.8686758327977d-12/
      data (zmn(lat,14,31), lat = 1,72)/
     |   1.6733411361811d-13,-2.9582395520125d-13, 3.0484280270433d-10,
     |   3.9506295179621d-08, 1.3424429082108d-06, 1.9965590625003d-05,
     |   1.6704472849397d-04, 9.0323024180217d-04, 3.4238026184225d-03,
     |   9.5343028896979d-03, 1.9917736270101d-02, 3.1003816373655d-02,
     |   3.3938763169839d-02, 2.0270995128795d-02,-7.2265428490542d-03,
     |  -3.0105659247615d-02,-2.7239331318135d-02, 1.9610837065506d-03,
     |   3.0118647393429d-02, 2.6591922443564d-02,-6.9697157388490d-03,
     |  -3.3354918513733d-02,-2.0612082622350d-02, 1.7567037652348d-02,
     |   3.4767721100058d-02, 8.4984496108511d-03,-2.9086919567549d-02,
     |  -2.9780649996003d-02, 8.2422409169826d-03, 3.5949961951146d-02,
     |   1.6602499391616d-02,-2.4893541055215d-02,-3.3638036705666d-02,
     |   2.3572534714663d-03, 3.5356710795018d-02, 2.1240590557650d-02,
     |  -2.1240590557650d-02,-3.5356710795019d-02,-2.3572534714665d-03,
     |   3.3638036705666d-02, 2.4893541055215d-02,-1.6602499391616d-02,
     |  -3.5949961951145d-02,-8.2422409169829d-03, 2.9780649996003d-02,
     |   2.9086919567549d-02,-8.4984496108509d-03,-3.4767721100058d-02,
     |  -1.7567037652348d-02, 2.0612082622350d-02, 3.3354918513733d-02,
     |   6.9697157388494d-03,-2.6591922443564d-02,-3.0118647393429d-02,
     |  -1.9610837065507d-03, 2.7239331318134d-02, 3.0105659247615d-02,
     |   7.2265428490540d-03,-2.0270995128795d-02,-3.3938763169839d-02,
     |  -3.1003816373655d-02,-1.9917736270101d-02,-9.5343028896979d-03,
     |  -3.4238026184225d-03,-9.0323024180210d-04,-1.6704472849385d-04,
     |  -1.9965590625021d-05,-1.3424429082481d-06,-3.9506295021869d-08,
     |  -3.0484284290966d-10, 2.9596529297054d-13,-1.6730818285465d-13/
      data (zmn(lat,15,31), lat = 1,72)/
     |  -3.2770042552876d-13, 3.1450235255826d-13, 3.1081827928199d-11,
     |   5.7772575919834d-09, 2.5709579572563d-07, 4.7882249620456d-06,
     |   4.8839801431466d-05, 3.1696046452874d-04, 1.4316984372032d-03,
     |   4.7545763672232d-03, 1.1974994340575d-02, 2.3119568283667d-02,
     |   3.3711790223352d-02, 3.4676177494241d-02, 1.8671729091060d-02,
     |  -9.8426825992238d-03,-3.1863543392966d-02,-2.7437604667412d-02,
     |   2.6262406313123d-03, 3.0983635224247d-02, 2.7789769023775d-02,
     |  -5.7104057648366d-03,-3.3617897905625d-02,-2.3345576793893d-02,
     |   1.4705492443668d-02, 3.5802943303504d-02, 1.3542379427629d-02,
     |  -2.5820959648419d-02,-3.3450290184135d-02, 1.0200742056484d-03,
     |   3.4559694966794d-02, 2.4238550412671d-02,-1.7268305748875d-02,
     |  -3.6772150355584d-02,-8.8966021744416d-03, 3.0541407999210d-02,
     |   3.0541407999210d-02,-8.8966021744417d-03,-3.6772150355584d-02,
     |  -1.7268305748875d-02, 2.4238550412671d-02, 3.4559694966793d-02,
     |   1.0200742056485d-03,-3.3450290184135d-02,-2.5820959648419d-02,
     |   1.3542379427629d-02, 3.5802943303504d-02, 1.4705492443668d-02,
     |  -2.3345576793893d-02,-3.3617897905625d-02,-5.7104057648366d-03,
     |   2.7789769023775d-02, 3.0983635224247d-02, 2.6262406313124d-03,
     |  -2.7437604667412d-02,-3.1863543392966d-02,-9.8426825992239d-03,
     |   1.8671729091060d-02, 3.4676177494241d-02, 3.3711790223352d-02,
     |   2.3119568283667d-02, 1.1974994340575d-02, 4.7545763672232d-03,
     |   1.4316984372032d-03, 3.1696046452854d-04, 4.8839801431576d-05,
     |   4.7882249619916d-06, 2.5709579575640d-07, 5.7772576663614d-09,
     |   3.1082003088511d-11, 3.1447411175696d-13,-3.2768012536983d-13/
      data (zmn(lat,16,31), lat = 1,72)/
     |  -5.8850707756320d-15, 1.7003106350543d-14, 2.9417442233027d-12,
     |   7.7431280608534d-10, 4.5030706153509d-08, 1.0470460041578d-06,
     |   1.2966316967226d-05, 1.0042420243507d-04, 5.3620248633973d-04,
     |   2.0985651076668d-03, 6.2540263222274d-03, 1.4485975433788d-02,
     |   2.6167699248890d-02, 3.6102809740595d-02, 3.5227697448134d-02,
     |   1.7283933749497d-02,-1.1970935978048d-02,-3.3355353587702d-02,
     |  -2.7963172911501d-02, 2.6085785602566d-03, 3.1507290083464d-02,
     |   2.9433164134554d-02,-3.5547713931551d-03,-3.3411928754206d-02,
     |  -2.6628471439906d-02, 1.0649196526003d-02, 3.6180277838628d-02,
     |   1.9383898976074d-02,-2.0827095628771d-02,-3.6334767068990d-02,
     |  -7.6789002465509d-03, 3.0659725406029d-02, 3.1394795919190d-02,
     |  -6.8095254883240d-03,-3.6692986968270d-02,-2.0931078625932d-02,
     |   2.0931078625932d-02, 3.6692986968270d-02, 6.8095254883241d-03,
     |  -3.1394795919190d-02,-3.0659725406029d-02, 7.6789002465509d-03,
     |   3.6334767068990d-02, 2.0827095628772d-02,-1.9383898976073d-02,
     |  -3.6180277838628d-02,-1.0649196526003d-02, 2.6628471439906d-02,
     |   3.3411928754206d-02, 3.5547713931549d-03,-2.9433164134554d-02,
     |  -3.1507290083464d-02,-2.6085785602567d-03, 2.7963172911501d-02,
     |   3.3355353587702d-02, 1.1970935978048d-02,-1.7283933749497d-02,
     |  -3.5227697448134d-02,-3.6102809740595d-02,-2.6167699248890d-02,
     |  -1.4485975433788d-02,-6.2540263222273d-03,-2.0985651076668d-03,
     |  -5.3620248633970d-04,-1.0042420243526d-04,-1.2966316967371d-05,
     |  -1.0470460042014d-06,-4.5030706195831d-08,-7.7431288122839d-10,
     |  -2.9416622382491d-12,-1.7004380147705d-14, 5.9196985829007d-15/
      data (zmn(lat,17,31), lat = 1,72)/
     |   1.2462848353842d-14,-1.1899716376756d-14, 2.6868147822011d-13,
     |   9.5322839627993d-11, 7.2325175059753d-09, 2.0944120102183d-07,
     |   3.1386249613182d-06, 2.8882517497328d-05, 1.8119742396890d-04,
     |   8.2869911974585d-04, 2.8858487076360d-03, 7.8613885854719d-03,
     |   1.6974421372527d-02, 2.8998147796966d-02, 3.8214284203372d-02,
     |   3.5741416879862d-02, 1.6285067998065d-02,-1.3512546080132d-02,
     |  -3.4607760456487d-02,-2.8936479469286d-02, 1.7562274749392d-03,
     |   3.1573112917868d-02, 3.1524223189943d-02,-3.2044907054029d-04,
     |  -3.2450834327894d-02,-3.0327013691296d-02, 5.1453042573864d-03,
     |   3.5378093988488d-02, 2.5754265528674d-02,-1.3672546005355d-02,
     |  -3.7560195517493d-02,-1.7498326275563d-02, 2.3410515151550d-02,
     |   3.6691050180929d-02, 6.2240427735646d-03,-3.1757395642532d-02,
     |  -3.1757395642532d-02, 6.2240427735646d-03, 3.6691050180929d-02,
     |   2.3410515151550d-02,-1.7498326275563d-02,-3.7560195517493d-02,
     |  -1.3672546005356d-02, 2.5754265528674d-02, 3.5378093988488d-02,
     |   5.1453042573865d-03,-3.0327013691295d-02,-3.2450834327894d-02,
     |  -3.2044907054037d-04, 3.1524223189943d-02, 3.1573112917868d-02,
     |   1.7562274749398d-03,-2.8936479469286d-02,-3.4607760456487d-02,
     |  -1.3512546080132d-02, 1.6285067998065d-02, 3.5741416879862d-02,
     |   3.8214284203372d-02, 2.8998147796966d-02, 1.6974421372527d-02,
     |   7.8613885854718d-03, 2.8858487076360d-03, 8.2869911974592d-04,
     |   1.8119742396901d-04, 2.8882517497463d-05, 3.1386249612730d-06,
     |   2.0944120116618d-07, 7.2325175532862d-09, 9.5322704661340d-11,
     |   2.6855390303472d-13,-1.1838336807162d-14, 1.2491173880197d-14/
      data (zmn(lat,18,31), lat = 1,72)/
     |   2.6459584415640d-16,-5.9181145232532d-16, 2.1374396690841d-14,
     |   1.0796895618472d-11, 1.0670622768232d-09, 3.8406883565074d-08,
     |   6.9464154975972d-07, 7.5684977692813d-06, 5.5530135136974d-05,
     |   2.9489978276117d-04, 1.1893973539198d-03, 3.7607758812475d-03,
     |   9.5041263212963d-03, 1.9350439043133d-02, 3.1565222714728d-02,
     |   4.0102220806128d-02, 3.6369635071712d-02, 1.5848393250885d-02,
     |  -1.4358798310271d-02,-3.5614480794380d-02,-3.0448904369284d-02,
     |  -1.0164657923707d-04, 3.0985281474792d-02, 3.3977483554601d-02,
     |   4.1696647078797d-03,-3.0324196736281d-02,-3.4127089451081d-02,
     |  -1.9991059297275d-03, 3.2685708295327d-02, 3.2051031915467d-02,
     |  -4.0640817794224d-03,-3.5928627497554d-02,-2.7485955341817d-02,
     |   1.2192524383451d-02, 3.8120856822843d-02, 2.0543971358417d-02,
     |  -2.0543971358417d-02,-3.8120856822843d-02,-1.2192524383451d-02,
     |   2.7485955341817d-02, 3.5928627497554d-02, 4.0640817794224d-03,
     |  -3.2051031915467d-02,-3.2685708295327d-02, 1.9991059297273d-03,
     |   3.4127089451081d-02, 3.0324196736281d-02,-4.1696647078794d-03,
     |  -3.3977483554601d-02,-3.0985281474792d-02, 1.0164657923710d-04,
     |   3.0448904369284d-02, 3.5614480794380d-02, 1.4358798310271d-02,
     |  -1.5848393250885d-02,-3.6369635071712d-02,-4.0102220806128d-02,
     |  -3.1565222714728d-02,-1.9350439043133d-02,-9.5041263212963d-03,
     |  -3.7607758812475d-03,-1.1893973539199d-03,-2.9489978276126d-04,
     |  -5.5530135136985d-05,-7.5684977690132d-06,-6.9464154960149d-07,
     |  -3.8406883443778d-08,-1.0670621544101d-09,-1.0796877727785d-11,
     |  -2.1477311183863d-14, 5.8819068566263d-16,-2.2339309408201d-16/
      data (zmn(lat,19,31), lat = 1,72)/
     |  -5.2755822633112d-16, 1.8976769648245d-16, 9.6707836053119d-16,
     |   1.1261925570259d-12, 1.4474212724432d-10, 6.4645640193663d-09,
     |   1.4080526618070d-07, 1.8113020228834d-06, 1.5484837506800d-05,
     |   9.5023338979228d-05, 4.4094488283405d-04, 1.6033378169381d-03,
     |   4.6776079914795d-03, 1.1102185071020d-02, 2.1529230620496d-02,
     |   3.3836425947976d-02, 4.1829466266090d-02, 3.7258588051161d-02,
     |   1.6143988110825d-02,-1.4375213285230d-02,-3.6311305196914d-02,
     |  -3.2540902767427d-02,-3.1510600633383d-03, 2.9442626222153d-02,
     |   3.6567475587834d-02, 1.0039595331101d-02,-2.6489398319442d-02,
     |  -3.7442323819544d-02,-1.0790880890234d-02, 2.7237343842257d-02,
     |   3.7182073811445d-02, 7.8850395115941d-03,-3.0023679648854d-02,
     |  -3.5807928207170d-02,-2.8660028666625d-03, 3.3257955317222d-02,
     |   3.3257955317222d-02,-2.8660028666625d-03,-3.5807928207170d-02,
     |  -3.0023679648854d-02, 7.8850395115940d-03, 3.7182073811445d-02,
     |   2.7237343842257d-02,-1.0790880890233d-02,-3.7442323819544d-02,
     |  -2.6489398319442d-02, 1.0039595331100d-02, 3.6567475587834d-02,
     |   2.9442626222153d-02,-3.1510600633383d-03,-3.2540902767427d-02,
     |  -3.6311305196915d-02,-1.4375213285230d-02, 1.6143988110825d-02,
     |   3.7258588051161d-02, 4.1829466266090d-02, 3.3836425947976d-02,
     |   2.1529230620495d-02, 1.1102185071020d-02, 4.6776079914794d-03,
     |   1.6033378169382d-03, 4.4094488283408d-04, 9.5023338979228d-05,
     |   1.5484837506711d-05, 1.8113020228271d-06, 1.4080526612426d-07,
     |   6.4645638632948d-09, 1.4474212225413d-10, 1.1262632738246d-12,
     |   1.0431376547437d-15, 2.1388849820021d-16,-5.0057551930123d-16/
      data (zmn(lat,20,31), lat = 1,72)/
     |   5.4277469268603d-17,-2.4844474333479d-17,-7.9846924588234d-17,
     |   1.0790382423758d-13, 1.8052145353669d-11, 9.9906067046430d-10,
     |   2.6158411036034d-08, 3.9636430055221d-07, 3.9364802509287d-06,
     |   2.7805333000297d-05, 1.4769666346770d-04, 6.1335688423250d-04,
     |   2.0459023662910d-03, 5.5803908936323d-03, 1.2571586060843d-02,
     |   2.3430714345487d-02, 3.5784210078175d-02, 4.3451678634780d-02,
     |   3.8536898220876d-02, 1.7338837960614d-02,-1.3385239799090d-02,
     |  -3.6545576789971d-02,-3.5166884389603d-02,-7.5728814061060d-03,
     |   2.6518640976063d-02, 3.8856455197475d-02, 1.7266925055445d-02,
     |  -2.0305587351664d-02,-3.9311779696589d-02,-2.0836382658200d-02,
     |   1.8164026272283d-02, 3.9436465430516d-02, 2.1228166431488d-02,
     |  -1.8589168221024d-02,-3.9575070652971d-02,-2.0057465372844d-02,
     |   2.0057465372844d-02, 3.9575070652971d-02, 1.8589168221024d-02,
     |  -2.1228166431488d-02,-3.9436465430516d-02,-1.8164026272283d-02,
     |   2.0836382658200d-02, 3.9311779696589d-02, 2.0305587351664d-02,
     |  -1.7266925055445d-02,-3.8856455197475d-02,-2.6518640976064d-02,
     |   7.5728814061059d-03, 3.5166884389603d-02, 3.6545576789971d-02,
     |   1.3385239799090d-02,-1.7338837960613d-02,-3.8536898220876d-02,
     |  -4.3451678634780d-02,-3.5784210078175d-02,-2.3430714345487d-02,
     |  -1.2571586060843d-02,-5.5803908936324d-03,-2.0459023662911d-03,
     |  -6.1335688423242d-04,-1.4769666346773d-04,-2.7805333000241d-05,
     |  -3.9364802509095d-06,-3.9636430074348d-07,-2.6158411099200d-08,
     |  -9.9906078558163d-10,-1.8052319736560d-11,-1.0799912583340d-13,
     |   5.0962434483027d-17,-4.8884293890920d-17,-9.0000696046146d-17/
      data (zmn(lat,21,31), lat = 1,72)/
     |   8.4237206238030d-19,-5.5690171942007d-17,-4.9727292282451d-17,
     |   9.4274937206228d-15, 2.0683749067997d-12, 1.4167930496680d-10,
     |   4.4524777553400d-09, 7.9314447757807d-08, 9.1284023393407d-07,
     |   7.3986288938813d-06, 4.4805607405679d-05, 2.1138909212075d-04,
     |   8.0045416304383d-04, 2.4841788330257d-03, 6.4062597271968d-03,
     |   1.3827079829111d-02, 2.4976834702632d-02, 3.7375086636966d-02,
     |   4.5000773585797d-02, 4.0300728876266d-02, 1.9592332969750d-02,
     |  -1.1156954698421d-02,-3.6040254269703d-02,-3.8140322253522d-02,
     |  -1.3492112581678d-02, 2.1663244567751d-02, 4.0106864133846d-02,
     |   2.5522753961428d-02,-1.1156739143308d-02,-3.8331023283374d-02,
     |  -3.1026474673113d-02, 4.9635530590205d-03, 3.6520273563697d-02,
     |   3.3633880281340d-02,-1.3737153052818d-03,-3.5133144028833d-02,
     |  -3.5133144028833d-02,-1.3737153052819d-03, 3.3633880281340d-02,
     |   3.6520273563697d-02, 4.9635530590206d-03,-3.1026474673113d-02,
     |  -3.8331023283374d-02,-1.1156739143308d-02, 2.5522753961428d-02,
     |   4.0106864133846d-02, 2.1663244567751d-02,-1.3492112581678d-02,
     |  -3.8140322253522d-02,-3.6040254269703d-02,-1.1156954698421d-02,
     |   1.9592332969750d-02, 4.0300728876266d-02, 4.5000773585797d-02,
     |   3.7375086636966d-02, 2.4976834702632d-02, 1.3827079829111d-02,
     |   6.4062597271968d-03, 2.4841788330256d-03, 8.0045416304384d-04,
     |   2.1138909212072d-04, 4.4805607405640d-05, 7.3986288938613d-06,
     |   9.1284023395849d-07, 7.9314447752300d-08, 4.4524777406438d-09,
     |   1.4167938242023d-10, 2.0682965512396d-12, 9.4131050276034d-15,
     |  -4.3989138261731d-17,-6.4138338407346d-17, 8.4823231257399d-18/
      data (zmn(lat,22,31), lat = 1,72)/
     |   9.6866914967957d-17, 9.9083455023116d-18,-1.1676053551449d-16,
     |   6.1131204678709d-16, 2.1725738810501d-13, 1.8407268941227d-11,
     |   6.9341802987859d-10, 1.4497759404787d-08, 1.9296577382603d-07,
     |   1.7900050731571d-06, 1.2318557842154d-05, 6.5751672775584d-05,
     |   2.8111063357141d-04, 9.8539898617289d-04, 2.8793188184100d-03,
     |   7.0890662937407d-03, 1.4783958041047d-02, 2.6087225749210d-02,
     |   3.8556788966040d-02, 4.6465342526809d-02, 4.2592708230533d-02,
     |   2.3041585386692d-02,-7.3993674074476d-03,-3.4356059132714d-02,
     |  -4.1053335411198d-02,-2.0876789470930d-02, 1.4257304747721d-02,
     |   3.9202085193785d-02, 3.3930488817005d-02, 1.2635830930647d-03,
     |  -3.2720817413225d-02,-3.9168038607242d-02,-1.1798487245097d-02,
     |   2.6031738157125d-02, 4.0948984962056d-02, 1.9438473586938d-02,
     |  -1.9438473586937d-02,-4.0948984962056d-02,-2.6031738157125d-02,
     |   1.1798487245097d-02, 3.9168038607242d-02, 3.2720817413225d-02,
     |  -1.2635830930646d-03,-3.3930488817004d-02,-3.9202085193785d-02,
     |  -1.4257304747721d-02, 2.0876789470930d-02, 4.1053335411198d-02,
     |   3.4356059132714d-02, 7.3993674074476d-03,-2.3041585386692d-02,
     |  -4.2592708230533d-02,-4.6465342526809d-02,-3.8556788966040d-02,
     |  -2.6087225749211d-02,-1.4783958041047d-02,-7.0890662937408d-03,
     |  -2.8793188184099d-03,-9.8539898617292d-04,-2.8111063357138d-04,
     |  -6.5751672775754d-05,-1.2318557842168d-05,-1.7900050732284d-06,
     |  -1.9296577373540d-07,-1.4497759283474d-08,-6.9341801235607d-10,
     |  -1.8407240939518d-11,-2.1714223764909d-13,-5.7729489180437d-16,
     |   1.6854170837234d-16, 4.3205134926278d-17,-1.0156394359188d-16/
      data (zmn(lat,23,31), lat = 1,72)/
     |   3.1061658748320d-17, 6.5402435012557d-17, 1.9746546531699d-17,
     |  -1.1398458966477d-17, 2.0739222448427d-14, 2.1848291037716d-12,
     |   9.8554360945491d-11, 2.4150720100300d-09, 3.7110171507324d-08,
     |   3.9314287117546d-07, 3.0663202744830d-06, 1.8454386482045d-05,
     |   8.8699865915581d-05, 3.4923716605667d-04, 1.1476413819131d-03,
     |   3.1897633265281d-03, 7.5633214929651d-03, 1.5359572456758d-02,
     |   2.6674426269225d-02, 3.9244638867682d-02, 4.7767688578208d-02,
     |   4.5371042077327d-02, 2.7768531407833d-02,-1.7802190378494d-03,
     |  -3.0862845390805d-02,-4.3170816292738d-02,-2.9362184399151d-02,
     |   3.7738378584036d-03, 3.4639086181005d-02, 4.0763667290015d-02,
     |   1.6420056147783d-02,-2.0733292838502d-02,-4.1762081594864d-02,
     |  -2.9433284516811d-02, 6.7913729451889d-03, 3.7535630276853d-02,
     |   3.7535630276853d-02, 6.7913729451891d-03,-2.9433284516810d-02,
     |  -4.1762081594864d-02,-2.0733292838502d-02, 1.6420056147783d-02,
     |   4.0763667290015d-02, 3.4639086181005d-02, 3.7738378584037d-03,
     |  -2.9362184399151d-02,-4.3170816292738d-02,-3.0862845390805d-02,
     |  -1.7802190378495d-03, 2.7768531407833d-02, 4.5371042077327d-02,
     |   4.7767688578208d-02, 3.9244638867682d-02, 2.6674426269225d-02,
     |   1.5359572456758d-02, 7.5633214929651d-03, 3.1897633265281d-03,
     |   1.1476413819131d-03, 3.4923716605671d-04, 8.8699865915541d-05,
     |   1.8454386481912d-05, 3.0663202744636d-06, 3.9314287124012d-07,
     |   3.7110171560544d-08, 2.4150720723412d-09, 9.8554445744374d-11,
     |   2.1848080286162d-12, 2.0750713932286d-14,-4.2067673668159d-18,
     |   2.0583220960625d-17, 5.6874180579856d-17, 2.5602957907641d-17/
      data (zmn(lat,24,31), lat = 1,72)/
     |   2.3510321799483d-16, 7.4507661767114d-17,-1.4738136263020d-16,
     |  -3.0445464279646d-16, 1.5463445589102d-15, 2.3589360777048d-13,
     |   1.2732177656946d-11, 3.6523985939469d-10, 6.4696553989193d-09,
     |   7.8132677768486d-08, 6.8911325290308d-07, 4.6634420470256d-06,
     |   2.5111955059691d-05, 1.1056895464210d-04, 4.0630706905809d-04,
     |   1.2652128805744d-03, 3.3752632759080d-03, 7.7687242015842d-03,
     |   1.5475624401991d-02, 2.6640570046866d-02, 3.9309215100967d-02,
     |   4.8738165320305d-02, 4.8465537336244d-02, 3.3738331510409d-02,
     |   6.0148435934789d-03,-2.4746131439152d-02,-4.3316421916968d-02,
     |  -3.7982037846252d-02,-9.8743319257103d-03, 2.4727764714675d-02,
     |   4.3199960669190d-02, 3.2120552560179d-02,-1.6960335096537d-03,
     |  -3.4427620037104d-02,-4.2060146837636d-02,-1.8633217999357d-02,
     |   1.8633217999357d-02, 4.2060146837636d-02, 3.4427620037104d-02,
     |   1.6960335096537d-03,-3.2120552560178d-02,-4.3199960669190d-02,
     |  -2.4727764714675d-02, 9.8743319257101d-03, 3.7982037846251d-02,
     |   4.3316421916968d-02, 2.4746131439152d-02,-6.0148435934786d-03,
     |  -3.3738331510409d-02,-4.8465537336244d-02,-4.8738165320305d-02,
     |  -3.9309215100968d-02,-2.6640570046866d-02,-1.5475624401991d-02,
     |  -7.7687242015842d-03,-3.3752632759080d-03,-1.2652128805744d-03,
     |  -4.0630706905812d-04,-1.1056895464205d-04,-2.5111955059743d-05,
     |  -4.6634420470248d-06,-6.8911325286368d-07,-7.8132677633578d-08,
     |  -6.4696554491049d-09,-3.6523987670147d-10,-1.2732122437110d-11,
     |  -2.3583826073380d-13,-1.6127028960201d-15, 2.8872730169930d-16,
     |   1.8235853796486d-16,-7.9037862235919d-17,-2.4525435449555d-16/
      data (zmn(lat,25,31), lat = 1,72)/
     |   1.6909359555249d-17, 2.1961329566647d-17,-1.2338968374598d-17,
     |  -9.1508671865970d-17,-7.9182303833264d-18, 2.2882108889339d-14,
     |   1.4861623830223d-12, 4.9859341722417d-11, 1.0168013163036d-09,
     |   1.3976794574352d-08, 1.3913480190177d-07, 1.0562901811671d-06,
     |   6.3543914411023d-06, 3.1177846528018d-05, 1.2754446443913d-04,
     |   4.4240861628988d-04, 1.3177660242871d-03, 3.4016896232586d-03,
     |   7.6558204519871d-03, 1.5062831536520d-02, 2.5878470666741d-02,
     |   3.8569212969856d-02, 4.9090228346001d-02, 5.1519923930173d-02,
     |   4.0697914842292d-02, 1.6152010317786d-02,-1.5099676928902d-02,
     |  -3.9807092074703d-02,-4.4824813816032d-02,-2.5713764555032d-02,
     |   8.2315424906705d-03, 3.7455730399622d-02, 4.3612259122548d-02,
     |   2.2042376012758d-02,-1.3878581213210d-02,-4.0753078056775d-02,
     |  -4.0753078056775d-02,-1.3878581213210d-02, 2.2042376012758d-02,
     |   4.3612259122548d-02, 3.7455730399622d-02, 8.2315424906705d-03,
     |  -2.5713764555032d-02,-4.4824813816032d-02,-3.9807092074703d-02,
     |  -1.5099676928902d-02, 1.6152010317786d-02, 4.0697914842292d-02,
     |   5.1519923930173d-02, 4.9090228346001d-02, 3.8569212969856d-02,
     |   2.5878470666741d-02, 1.5062831536520d-02, 7.6558204519872d-03,
     |   3.4016896232587d-03, 1.3177660242871d-03, 4.4240861628985d-04,
     |   1.2754446443918d-04, 3.1177846528066d-05, 6.3543914411495d-06,
     |   1.0562901812122d-06, 1.3913480192954d-07, 1.3976794598394d-08,
     |   1.0168013068829d-09, 4.9859335329798d-11, 1.4861616065721d-12,
     |   2.2934981668044d-14, 8.3034330459528d-17,-1.3537109549077d-16,
     |   5.4108430680674d-18, 3.9789750372741d-17, 7.2674680990491d-18/
      data (zmn(lat,26,31), lat = 1,72)/
     |   1.3606808502098d-16, 7.8062544815192d-17,-1.6183043849284d-17,
     |  -9.5200754767349d-17,-1.3900743268035d-16, 1.8608573353176d-15,
     |   1.5533747417967d-13, 6.0923030461240d-12, 1.4288260848586d-10,
     |   2.2324906772510d-09, 2.5043044276418d-08, 2.1287214670305d-07,
     |   1.4272406260371d-06, 7.7808761572990d-06, 3.5308330363506d-05,
     |   1.3580899265065d-04, 4.4905078091368d-04, 1.2901834702539d-03,
     |   3.2466429681660d-03, 7.1934958477687d-03, 1.4070041112527d-02,
     |   2.4281270311047d-02, 3.6796328751905d-02, 4.8405140674956d-02,
     |   5.3927494436835d-02, 4.8029053305459d-02, 2.8411489750482d-02,
     |  -1.1896557426418d-03,-3.0567755483666d-02,-4.6737543748216d-02,
     |  -4.0804273356044d-02,-1.4244884398759d-02, 1.9964492163476d-02,
     |   4.3385239826970d-02, 4.2570464786091d-02, 1.7544632141381d-02,
     |  -1.7544632141381d-02,-4.2570464786091d-02,-4.3385239826970d-02,
     |  -1.9964492163476d-02, 1.4244884398759d-02, 4.0804273356044d-02,
     |   4.6737543748216d-02, 3.0567755483666d-02, 1.1896557426420d-03,
     |  -2.8411489750482d-02,-4.8029053305459d-02,-5.3927494436835d-02,
     |  -4.8405140674956d-02,-3.6796328751905d-02,-2.4281270311047d-02,
     |  -1.4070041112527d-02,-7.1934958477687d-03,-3.2466429681660d-03,
     |  -1.2901834702539d-03,-4.4905078091368d-04,-1.3580899265064d-04,
     |  -3.5308330363525d-05,-7.7808761572552d-06,-1.4272406260126d-06,
     |  -2.1287214661374d-07,-2.5043044323689d-08,-2.2324907307437d-09,
     |  -1.4288263036936d-10,-6.0922890632898d-12,-1.5542362803299d-13,
     |  -1.9336963561307d-15, 1.7795933826406d-16, 7.2076783292537d-17,
     |  -7.4249560625270d-17,-1.2174776677329d-16,-1.2415951558473d-16/
      data (zmn(lat,27,31), lat = 1,72)/
     |   4.2277952506994d-17, 1.0748304792679d-16, 1.1230042881964d-16,
     |   5.1344213873940d-17,-4.9647076314873d-17, 3.4472150676952d-17,
     |   1.4217576910389d-14, 6.5799706476052d-13, 1.7733590847040d-11,
     |   3.1458851175404d-10, 3.9710468535939d-09, 3.7730882341622d-08,
     |   2.8137999947070d-07, 1.7003285495924d-06, 8.5336400011752d-06,
     |   3.6265797639498d-05, 1.3250838722712d-04, 4.2129403034344d-04,
     |   1.1764518905650d-03, 2.9057295629552d-03, 6.3788602530664d-03,
     |   1.2479952808068d-02, 2.1765999191389d-02, 3.3743054973282d-02,
     |   4.6144746263498d-02, 5.4783710806394d-02, 5.4571104532920d-02,
     |   4.1816264993145d-02, 1.6993312323703d-02,-1.3673553026883d-02,
     |  -3.9427991453083d-02,-4.9327616400747d-02,-3.7978170675338d-02,
     |  -9.4283640816318d-03, 2.3591641391037d-02, 4.5425209735614d-02,
     |   4.5425209735614d-02, 2.3591641391037d-02,-9.4283640816317d-03,
     |  -3.7978170675338d-02,-4.9327616400747d-02,-3.9427991453083d-02,
     |  -1.3673553026883d-02, 1.6993312323703d-02, 4.1816264993145d-02,
     |   5.4571104532920d-02, 5.4783710806394d-02, 4.6144746263499d-02,
     |   3.3743054973282d-02, 2.1765999191389d-02, 1.2479952808068d-02,
     |   6.3788602530665d-03, 2.9057295629552d-03, 1.1764518905649d-03,
     |   4.2129403034337d-04, 1.3250838722708d-04, 3.6265797639457d-05,
     |   8.5336400011582d-06, 1.7003285495779d-06, 2.8137999946078d-07,
     |   3.7730882389011d-08, 3.9710468641324d-09, 3.1458845727820d-10,
     |   1.7733579171021d-11, 6.5797791085846d-13, 1.4172931418040d-14,
     |  -6.9119624805649d-17,-9.3009369360817d-17, 6.5307303589570d-17,
     |   1.0915985863572d-16, 5.1054704964149d-17, 4.0639533231433d-17/
      data (zmn(lat,28,31), lat = 1,72)/
     |   1.6151231276007d-16, 1.0086592580024d-16, 2.3123086141899d-17,
     |  -7.3270572467404d-17,-1.5519008281243d-16,-2.0986286899298d-16,
     |   9.1788224245655d-16, 6.1495861247208d-14, 1.9077887968452d-12,
     |   3.8387592393226d-11, 5.4461827644909d-10, 5.7759010421119d-09,
     |   4.7828925009078d-08, 3.1970588228119d-07, 1.7702624747531d-06,
     |   8.2874062091772d-06, 3.3339494463654d-05, 1.1676639652409d-04,
     |   3.5976906337872d-04, 9.8325353061292d-04, 2.3989240578295d-03,
     |   5.2493201366204d-03, 1.0332715551164d-02, 1.8316455672940d-02,
     |   2.9208213868628d-02, 4.1724039706580d-02, 5.2909440013214d-02,
     |   5.8479409598937d-02, 5.4161616428586d-02, 3.7800084608307d-02,
     |   1.1318718791755d-02,-1.8699000699900d-02,-4.2678178988438d-02,
     |  -5.1722947525041d-02,-4.1754831159346d-02,-1.5964448592860d-02,
     |   1.5964448592859d-02, 4.1754831159345d-02, 5.1722947525041d-02,
     |   4.2678178988438d-02, 1.8699000699900d-02,-1.1318718791755d-02,
     |  -3.7800084608307d-02,-5.4161616428586d-02,-5.8479409598937d-02,
     |  -5.2909440013214d-02,-4.1724039706580d-02,-2.9208213868628d-02,
     |  -1.8316455672940d-02,-1.0332715551164d-02,-5.2493201366204d-03,
     |  -2.3989240578295d-03,-9.8325353061294d-04,-3.5976906337874d-04,
     |  -1.1676639652411d-04,-3.3339494463665d-05,-8.2874062092278d-06,
     |  -1.7702624747212d-06,-3.1970588230580d-07,-4.7828925058798d-08,
     |  -5.7759011223011d-09,-5.4461822852010d-10,-3.8387654651779d-11,
     |  -1.9078050370370d-12,-6.1520754999032d-14,-9.1506645330198d-16,
     |   1.7087413987283d-16, 1.6230165468193d-16, 1.0098602259376d-16,
     |  -3.4179685093370d-17, 2.5291973319999d-18,-1.1631671173013d-16/
      data (zmn(lat,29,31), lat = 1,72)/
     |   2.8316842705964d-17, 6.0176145754791d-17, 7.9244136379205d-17,
     |   4.9629642434627d-17, 1.0305943573320d-17,-5.7481184268657d-17,
     |  -3.9472130387701d-17, 4.7166063469713d-15, 1.7237732805429d-13,
     |   3.9338053594186d-12, 6.2662586917793d-11, 7.4084757266962d-10,
     |   6.8019431466398d-09, 5.0205872416857d-08, 3.0607327994769d-07,
     |   1.5745136003608d-06, 6.9531534057202d-06, 2.6728568050238d-05,
     |   9.0458231007304d-05, 2.7202414229979d-04, 7.3232236166754d-04,
     |   1.7755222119546d-03, 3.8947805715830d-03, 7.7556117100953d-03,
     |   1.4047332976120d-02, 2.3154763284139d-02, 3.4687570161135d-02,
     |   4.7041255628654d-02, 5.7282523511541d-02, 6.1644624351272d-02,
     |   5.6707129511852d-02, 4.0956963118875d-02, 1.6068304553292d-02,
     |  -1.2848105832986d-02,-3.8436519343638d-02,-5.3467565152401d-02,
     |  -5.3467565152401d-02,-3.8436519343638d-02,-1.2848105832986d-02,
     |   1.6068304553292d-02, 4.0956963118875d-02, 5.6707129511852d-02,
     |   6.1644624351272d-02, 5.7282523511541d-02, 4.7041255628655d-02,
     |   3.4687570161135d-02, 2.3154763284139d-02, 1.4047332976121d-02,
     |   7.7556117100953d-03, 3.8947805715830d-03, 1.7755222119546d-03,
     |   7.3232236166756d-04, 2.7202414229980d-04, 9.0458231007283d-05,
     |   2.6728568050194d-05, 6.9531534057495d-06, 1.5745136003479d-06,
     |   3.0607327990975d-07, 5.0205872383401d-08, 6.8019431260025d-09,
     |   7.4084754385477d-10, 6.2662612558789d-11, 3.9337665076082d-12,
     |   1.7233509941052d-13, 4.7093637378249d-15, 1.7325125314584d-17,
     |   2.9138680961747d-17, 1.9979517029826d-17, 3.8603132352839d-17,
     |   2.6109133987531d-17, 1.5469950615117d-16, 6.2281476564350d-17/
      data (zmn(lat,30,31), lat = 1,72)/
     |   1.3976427816909d-16, 1.2182561182815d-16, 8.0679646805543d-17,
     |   3.0542122005504d-17,-3.8055944690430d-17,-1.1545608260157d-16,
     |  -1.8550494914410d-16, 6.4843083423523d-17, 1.2117836107243d-14,
     |   3.1941707956660d-13, 5.7116059803216d-12, 7.5198851959906d-11,
     |   7.6452436024616d-10, 6.2218487941356d-09, 4.1687276086639d-08,
     |   2.3515472318959d-07, 1.1371067626427d-06, 4.7833595460310d-06,
     |   1.7717549187170d-05, 5.8366427953867d-05, 1.7243481429847d-04,
     |   4.6003489056931d-04, 1.1146585501076d-03, 2.4643614201426d-03,
     |   4.9899024994489d-03, 9.2795401089622d-03, 1.5879367817326d-02,
     |   2.5026826288206d-02, 3.6317859007003d-02, 4.8435653242966d-02,
     |   5.9116215145320d-02, 6.5492700113849d-02, 6.4826353316757d-02,
     |   5.5437261469957d-02, 3.7489278539242d-02, 1.3265198028732d-02,
     |  -1.3265198028732d-02,-3.7489278539242d-02,-5.5437261469957d-02,
     |  -6.4826353316757d-02,-6.5492700113849d-02,-5.9116215145319d-02,
     |  -4.8435653242966d-02,-3.6317859007003d-02,-2.5026826288206d-02,
     |  -1.5879367817326d-02,-9.2795401089622d-03,-4.9899024994489d-03,
     |  -2.4643614201426d-03,-1.1146585501076d-03,-4.6003489056930d-04,
     |  -1.7243481429847d-04,-5.8366427953894d-05,-1.7717549187192d-05,
     |  -4.7833595460414d-06,-1.1371067626242d-06,-2.3515472318944d-07,
     |  -4.1687276129596d-08,-6.2218488317190d-09,-7.6452431415471d-10,
     |  -7.5198835848273d-11,-5.7116196766616d-12,-3.1940967131788d-13,
     |  -1.2170598496731d-14,-9.1507861464666d-17, 1.6032797785744d-16,
     |   1.4658880654674d-16,-3.3230038672440d-17,-3.5887120246512d-17,
     |  -5.8146405292029d-17,-1.9343251356548d-16,-1.6363286672883d-16/
      data (zmn(lat,31,31), lat = 1,72)/
     |  -1.1696563165295d-17,-3.3865591030448d-17,-5.7834030901317d-17,
     |  -9.3145740147636d-17,-1.1348218421279d-16,-1.3597209612074d-16,
     |  -1.5738146423179d-16,-1.5655740985653d-16, 4.3060068076842d-16,
     |   1.7686196817823d-14, 3.5756893847239d-13, 5.2393342791374d-12,
     |   5.8918401834947d-11, 5.2797835927567d-10, 3.8819334814996d-09,
     |   2.3968939461910d-08, 1.2664654167022d-07, 5.8154254689128d-07,
     |   2.3505175042787d-06, 8.4523862104228d-06, 2.7285891665581d-05,
     |   7.9680949679007d-05, 2.1186217186816d-04, 5.1576554107893d-04,
     |   1.1551158410836d-03, 2.3897672169968d-03, 4.5832578720230d-03,
     |   8.1732680567765d-03, 1.3587611838215d-02, 2.1104271264012d-02,
     |   3.0681710648232d-02, 4.1815304606821d-02, 5.3490368221419d-02,
     |   6.4286704957096d-02, 7.2641006915526d-02, 7.7207875402862d-02,
     |   7.7207875402862d-02, 7.2641006915526d-02, 6.4286704957096d-02,
     |   5.3490368221419d-02, 4.1815304606821d-02, 3.0681710648232d-02,
     |   2.1104271264012d-02, 1.3587611838215d-02, 8.1732680567765d-03,
     |   4.5832578720231d-03, 2.3897672169968d-03, 1.1551158410836d-03,
     |   5.1576554107890d-04, 2.1186217186814d-04, 7.9680949679001d-05,
     |   2.7285891665567d-05, 8.4523862104263d-06, 2.3505175042794d-06,
     |   5.8154254691753d-07, 1.2664654163768d-07, 2.3968939474125d-08,
     |   3.8819334671196d-09, 5.2797834167454d-10, 5.8918388516411d-11,
     |   5.2393172042440d-12, 3.5753644772067d-13, 1.7702225731174d-14,
     |   4.4081319270759d-16,-1.6136892705070d-16,-1.8213171213319d-16,
     |  -1.5022705817637d-16,-1.3416161159944d-16,-6.9651198545170d-17,
     |  -5.8811287179029d-17,-6.8713733759903d-17,-4.0768413724331d-17/
      data (zmn(lat, 0,32), lat = 1,72)/
     |   3.9734619099944d-03, 2.9552505312538d-03,-1.0803405553531d-02,
     |  -6.9264866844329d-03, 1.1475671464434d-02, 1.2969389690014d-02,
     |  -9.9969727497422d-03,-1.7935320963959d-02, 5.3348578509737d-03,
     |   2.2045731062480d-02, 8.5108458611398d-04,-2.3615552016544d-02,
     |  -8.5366143657537d-03, 2.2874150279800d-02, 1.6115484618416d-02,
     |  -1.9111948711726d-02,-2.3096107836268d-02, 1.3026342182989d-02,
     |   2.8110632848973d-02,-4.7788711532394d-03,-3.0775317024037d-02,
     |  -4.4740125653433d-03, 3.0323446417916d-02, 1.4013945718305d-02,
     |  -2.6887581771736d-02,-2.2561008566879d-02, 2.0498689645647d-02,
     |   2.9327899196030d-02,-1.1905883132254d-02,-3.3374944888971d-02,
     |   1.8276520177387d-03, 3.4315993770312d-02, 8.6055123866834d-03,
     |  -3.1909320729497d-02,-1.8373772337369d-02, 2.6417924594052d-02,
     |   2.6417924594052d-02,-1.8373772337369d-02,-3.1909320729497d-02,
     |   8.6055123866834d-03, 3.4315993770312d-02, 1.8276520177386d-03,
     |  -3.3374944888971d-02,-1.1905883132254d-02, 2.9327899196030d-02,
     |   2.0498689645647d-02,-2.2561008566879d-02,-2.6887581771736d-02,
     |   1.4013945718305d-02, 3.0323446417916d-02,-4.4740125653433d-03,
     |  -3.0775317024037d-02,-4.7788711532395d-03, 2.8110632848973d-02,
     |   1.3026342182989d-02,-2.3096107836268d-02,-1.9111948711727d-02,
     |   1.6115484618417d-02, 2.2874150279800d-02,-8.5366143657535d-03,
     |  -2.3615552016544d-02, 8.5108458611395d-04, 2.2045731062480d-02,
     |   5.3348578509737d-03,-1.7935320963959d-02,-9.9969727497421d-03,
     |   1.2969389690014d-02, 1.1475671464435d-02,-6.9264866844329d-03,
     |  -1.0803405553531d-02, 2.9552505312536d-03, 3.9734619099944d-03/
      data (zmn(lat, 1,32), lat = 1,72)/
     |   2.1507735020600d-03, 9.0603343904026d-03, 3.2946199769350d-03,
     |  -1.2307316006655d-02,-9.0557039379773d-03, 1.1909944393961d-02,
     |   1.5080208981859d-02,-8.7936938367984d-03,-2.0008898679816d-02,
     |   3.1956336587113d-03, 2.3197524593715d-02, 3.9319439501893d-03,
     |  -2.3801465875165d-02,-1.1865371803183d-02, 2.1698510669129d-02,
     |   1.9395555663980d-02,-1.6751965438831d-02,-2.5695327007200d-02,
     |   9.5393992815065d-03, 2.9720699630840d-02,-5.9900137893651d-04,
     |  -3.1015858017264d-02,-8.9622647747436d-03, 2.9106722412704d-02,
     |   1.8259321900245d-02,-2.4217643814512d-02,-2.6082072093833d-02,
     |   1.6600475791893d-02, 3.1686359073644d-02,-7.1534982969464d-03,
     |  -3.4241326188493d-02,-3.3217888479339d-03, 3.3569221183283d-02,
     |   1.3573882112820d-02,-2.9531413796991d-02,-2.2682867377419d-02,
     |   2.2682867377419d-02, 2.9531413796991d-02,-1.3573882112820d-02,
     |  -3.3569221183283d-02, 3.3217888479337d-03, 3.4241326188493d-02,
     |   7.1534982969466d-03,-3.1686359073644d-02,-1.6600475791893d-02,
     |   2.6082072093833d-02, 2.4217643814512d-02,-1.8259321900245d-02,
     |  -2.9106722412704d-02, 8.9622647747437d-03, 3.1015858017264d-02,
     |   5.9900137893711d-04,-2.9720699630841d-02,-9.5393992815065d-03,
     |   2.5695327007200d-02, 1.6751965438831d-02,-1.9395555663980d-02,
     |  -2.1698510669129d-02, 1.1865371803183d-02, 2.3801465875165d-02,
     |  -3.9319439501893d-03,-2.3197524593715d-02,-3.1956336587114d-03,
     |   2.0008898679816d-02, 8.7936938367985d-03,-1.5080208981859d-02,
     |  -1.1909944393961d-02, 9.0557039379772d-03, 1.2307316006655d-02,
     |  -3.2946199769349d-03,-9.0603343904026d-03,-2.1507735020600d-03/
      data (zmn(lat, 2,32), lat = 1,72)/
     |   3.7934430473778d-04, 6.1288873232827d-03, 1.2325061687821d-02,
     |   2.2502961252992d-03,-1.4479350771264d-02,-9.8303110408410d-03,
     |   1.3065281401458d-02, 1.6466733044068d-02,-8.6058865476264d-03,
     |  -2.1534150449589d-02, 1.9700490525405d-03, 2.4147699197527d-02,
     |   6.0666825643979d-03,-2.3933768216285d-02,-1.4358770490185d-02,
     |   2.0665464011452d-02, 2.1898564054450d-02,-1.4653147800611d-02,
     |  -2.7610559517253d-02, 6.4219046069979d-03, 3.0744840313236d-02,
     |   3.1047179511144d-03,-3.0746126067019d-02,-1.2916442849292d-02,
     |   2.7509655241797d-02, 2.1865137978834d-02,-2.1241593575722d-02,
     |  -2.8943463624682d-02, 1.2567084070509d-02, 3.3289058491638d-02,
     |  -2.3547141396528d-03,-3.4381794386225d-02,-8.3011390930397d-03,
     |   3.2035260308287d-02, 1.8269502462717d-02,-2.6472650766992d-02,
     |  -2.6472650766992d-02, 1.8269502462716d-02, 3.2035260308287d-02,
     |  -8.3011390930396d-03,-3.4381794386225d-02,-2.3547141396526d-03,
     |   3.3289058491638d-02, 1.2567084070509d-02,-2.8943463624682d-02,
     |  -2.1241593575722d-02, 2.1865137978834d-02, 2.7509655241798d-02,
     |  -1.2916442849291d-02,-3.0746126067019d-02, 3.1047179511143d-03,
     |   3.0744840313236d-02, 6.4219046069980d-03,-2.7610559517253d-02,
     |  -1.4653147800611d-02, 2.1898564054450d-02, 2.0665464011453d-02,
     |  -1.4358770490186d-02,-2.3933768216285d-02, 6.0666825643976d-03,
     |   2.4147699197527d-02, 1.9700490525405d-03,-2.1534150449588d-02,
     |  -8.6058865476264d-03, 1.6466733044068d-02, 1.3065281401458d-02,
     |  -9.8303110408410d-03,-1.4479350771265d-02, 2.2502961252991d-03,
     |   1.2325061687821d-02, 6.1288873232828d-03, 3.7934430473777d-04/
      data (zmn(lat, 3,32), lat = 1,72)/
     |   9.3476788868432d-06, 2.4472447713467d-03, 1.0609417873349d-02,
     |   1.4117368412387d-02, 1.0537164817702d-04,-1.6909841889978d-02,
     |  -9.5574437039003d-03, 1.4780411761119d-02, 1.7333338312613d-02,
     |  -9.2611596378223d-03,-2.2730381350865d-02, 1.4758078076995d-03,
     |   2.5099037647790d-02, 7.4481561434605d-03,-2.4139016300661d-02,
     |  -1.6272134259968d-02, 1.9884422579047d-02, 2.3836551686533d-02,
     |  -1.2802160036367d-02,-2.9100195131380d-02, 3.6642819792432d-03,
     |   3.1337743412068d-02, 6.4614751308007d-03,-3.0147791473934d-02,
     |  -1.6412882604832d-02, 2.5576623057525d-02, 2.4996095176874d-02,
     |  -1.8039624704010d-02,-3.1201906097049d-02, 8.3467097891306d-03,
     |   3.4253508971861d-02, 2.4657397434874d-03,-3.3772670229314d-02,
     |  -1.3184772597562d-02, 2.9753576886742d-02, 2.2636576672293d-02,
     |  -2.2636576672293d-02,-2.9753576886742d-02, 1.3184772597562d-02,
     |   3.3772670229315d-02,-2.4657397434872d-03,-3.4253508971861d-02,
     |  -8.3467097891308d-03, 3.1201906097049d-02, 1.8039624704010d-02,
     |  -2.4996095176874d-02,-2.5576623057525d-02, 1.6412882604832d-02,
     |   3.0147791473934d-02,-6.4614751308008d-03,-3.1337743412069d-02,
     |  -3.6642819792438d-03, 2.9100195131380d-02, 1.2802160036367d-02,
     |  -2.3836551686533d-02,-1.9884422579047d-02, 1.6272134259968d-02,
     |   2.4139016300661d-02,-7.4481561434606d-03,-2.5099037647790d-02,
     |  -1.4758078076995d-03, 2.2730381350865d-02, 9.2611596378224d-03,
     |  -1.7333338312612d-02,-1.4780411761119d-02, 9.5574437039004d-03,
     |   1.6909841889979d-02,-1.0537164817688d-04,-1.4117368412387d-02,
     |  -1.0609417873349d-02,-2.4472447713468d-03,-9.3476788868707d-06/
      data (zmn(lat, 4,32), lat = 1,72)/
     |   1.1977964796600d-06, 6.8640524925332d-04, 5.6887899442602d-03,
     |   1.4732772492297d-02, 1.4652405714162d-02,-3.0008611249967d-03,
     |  -1.9169126921171d-02,-8.4479123981725d-03, 1.6924455463168d-02,
     |   1.7672522805320d-02,-1.0521526905894d-02,-2.3729475904266d-02,
     |   1.6074899969070d-03, 2.6062517451640d-02, 8.2955992955632d-03,
     |  -2.4497884829018d-02,-1.7743458686005d-02, 1.9312120225194d-02,
     |   2.5420325384235d-02,-1.1185092017413d-02,-3.0281659932480d-02,
     |   1.1484076171889d-03, 3.1640479354171d-02, 9.5523716726704d-03,
     |  -2.9257054587786d-02,-1.9588955021316d-02, 2.3347824023129d-02,
     |   2.7721257255249d-02,-1.4567721609905d-02,-3.2934733076409d-02,
     |   3.9195412993707d-03, 3.4570217265887d-02, 7.3607082762897d-03,
     |  -3.2396043666332d-02,-1.7959359576926d-02, 2.6640189637474d-02,
     |   2.6640189637474d-02,-1.7959359576926d-02,-3.2396043666332d-02,
     |   7.3607082762896d-03, 3.4570217265887d-02, 3.9195412993705d-03,
     |  -3.2934733076409d-02,-1.4567721609905d-02, 2.7721257255249d-02,
     |   2.3347824023129d-02,-1.9588955021316d-02,-2.9257054587786d-02,
     |   9.5523716726702d-03, 3.1640479354171d-02, 1.1484076171890d-03,
     |  -3.0281659932480d-02,-1.1185092017414d-02, 2.5420325384235d-02,
     |   1.9312120225194d-02,-1.7743458686005d-02,-2.4497884829018d-02,
     |   8.2955992955633d-03, 2.6062517451640d-02, 1.6074899969073d-03,
     |  -2.3729475904266d-02,-1.0521526905894d-02, 1.7672522805320d-02,
     |   1.6924455463168d-02,-8.4479123981724d-03,-1.9169126921171d-02,
     |  -3.0008611249968d-03, 1.4652405714162d-02, 1.4732772492297d-02,
     |   5.6887899442602d-03, 6.8640524925335d-04, 1.1977964796690d-06/
      data (zmn(lat, 5,32), lat = 1,72)/
     |   2.1374257163821d-06, 1.4837031065022d-04, 2.2581402162732d-03,
     |   9.6214469669974d-03, 1.8200789032569d-02, 1.3929058974937d-02,
     |  -6.7539236085411d-03,-2.1020795488542d-02,-6.5851619680655d-03,
     |   1.9281615098858d-02, 1.7512946664256d-02,-1.2229845416591d-02,
     |  -2.4539462791613d-02, 2.2199536058151d-03, 2.7041928999943d-02,
     |   8.7503532766438d-03,-2.4991926188011d-02,-1.8912153109582d-02,
     |   1.8897702127431d-02, 2.6776435815722d-02,-9.7211345814491d-03,
     |  -3.1247094061523d-02,-1.2338239815371d-03, 3.1706804350364d-02,
     |   1.2484573284467d-02,-2.8074085242496d-02,-2.2541137986169d-02,
     |   2.0790662512067d-02, 3.0090934307390d-02,-1.0762712074126d-02,
     |  -3.4149246587092d-02,-7.6399324593681d-04, 3.4182278387954d-02,
     |   1.2355869872873d-02,-3.0162927729066d-02,-2.2577207121675d-02,
     |   2.2577207121675d-02, 3.0162927729066d-02,-1.2355869872873d-02,
     |  -3.4182278387954d-02, 7.6399324593670d-04, 3.4149246587092d-02,
     |   1.0762712074126d-02,-3.0090934307390d-02,-2.0790662512067d-02,
     |   2.2541137986169d-02, 2.8074085242496d-02,-1.2484573284466d-02,
     |  -3.1706804350364d-02, 1.2338239815372d-03, 3.1247094061523d-02,
     |   9.7211345814497d-03,-2.6776435815722d-02,-1.8897702127431d-02,
     |   1.8912153109582d-02, 2.4991926188011d-02,-8.7503532766436d-03,
     |  -2.7041928999943d-02,-2.2199536058150d-03, 2.4539462791613d-02,
     |   1.2229845416591d-02,-1.7512946664256d-02,-1.9281615098858d-02,
     |   6.5851619680653d-03, 2.1020795488542d-02, 6.7539236085410d-03,
     |  -1.3929058974937d-02,-1.8200789032570d-02,-9.6214469669974d-03,
     |  -2.2581402162732d-03,-1.4837031065021d-04,-2.1374257163397d-06/
      data (zmn(lat, 6,32), lat = 1,72)/
     |   1.0747882597001d-07, 2.6716675619993d-05, 7.1485511374153d-04,
     |   4.7155626885131d-03, 1.3839500804407d-02, 2.0789265397550d-02,
     |   1.2026042627689d-02,-1.0841912126615d-02,-2.2295001717573d-02,
     |  -4.0763381858117d-03, 2.1658292280985d-02, 1.6886523255513d-02,
     |  -1.4241466321392d-02,-2.5151027811285d-02, 3.1771301976963d-03,
     |   2.8021552343808d-02, 8.9321020695208d-03,-2.5573034800974d-02,
     |  -1.9896712937136d-02, 1.8571092443144d-02, 2.7992602398519d-02,
     |  -8.3063271691440d-03,-3.2052103994764d-02,-3.5917354181577d-03,
     |   3.1537246853628d-02, 1.5362280505231d-02,-2.6558068213571d-02,
     |  -2.5331661877999d-02, 1.7827242734898d-02, 3.2115660241865d-02,
     |  -6.5475395318109d-03,-3.4785596150968d-02,-5.7540825243628d-03,
     |   3.2976065087482d-02, 1.7429422076481d-02,-2.6923485138124d-02,
     |  -2.6923485138124d-02, 1.7429422076480d-02, 3.2976065087482d-02,
     |  -5.7540825243627d-03,-3.4785596150968d-02,-6.5475395318107d-03,
     |   3.2115660241865d-02, 1.7827242734898d-02,-2.5331661877999d-02,
     |  -2.6558068213571d-02, 1.5362280505231d-02, 3.1537246853628d-02,
     |  -3.5917354181576d-03,-3.2052103994764d-02,-8.3063271691441d-03,
     |   2.7992602398519d-02, 1.8571092443145d-02,-1.9896712937136d-02,
     |  -2.5573034800974d-02, 8.9321020695206d-03, 2.8021552343808d-02,
     |   3.1771301976961d-03,-2.5151027811285d-02,-1.4241466321393d-02,
     |   1.6886523255513d-02, 2.1658292280985d-02,-4.0763381858115d-03,
     |  -2.2295001717573d-02,-1.0841912126615d-02, 1.2026042627689d-02,
     |   2.0789265397550d-02, 1.3839500804408d-02, 4.7155626885132d-03,
     |   7.1485511374151d-04, 2.6716675619917d-05, 1.0747882597361d-07/
      data (zmn(lat, 7,32), lat = 1,72)/
     |  -1.1017006720960d-07, 4.1792119504678d-06, 1.8849683983501d-04,
     |   1.8671819180649d-03, 7.9113032172782d-03, 1.8004810391851d-02,
     |   2.2342366164273d-02, 9.1084988560590d-03,-1.4980869012277d-02,
     |  -2.2886712778849d-02,-1.0655717604709d-03, 2.3901116335480d-02,
     |   1.5840178745553d-02,-1.6418106371510d-02,-2.5568396415612d-02,
     |   4.3550388668837d-03, 2.8977759705718d-02, 8.9565429159512d-03,
     |  -2.6186753496578d-02,-2.0797148275798d-02, 1.8245026094593d-02,
     |   2.9136107202709d-02,-6.8294167210104d-03,-3.2715390159755d-02,
     |  -6.0379085720125d-03, 3.1094445447615d-02, 1.8270567319015d-02,
     |  -2.4625781019589d-02,-2.7987792271791d-02, 1.4353615613840d-02,
     |   3.3747132361774d-02,-1.8391781551750d-03,-3.4717509727499d-02,
     |  -1.1067988585007d-02, 3.0771566766621d-02, 2.2488837652621d-02,
     |  -2.2488837652621d-02,-3.0771566766621d-02, 1.1067988585007d-02,
     |   3.4717509727499d-02, 1.8391781551752d-03,-3.3747132361774d-02,
     |  -1.4353615613840d-02, 2.7987792271791d-02, 2.4625781019589d-02,
     |  -1.8270567319015d-02,-3.1094445447615d-02, 6.0379085720121d-03,
     |   3.2715390159755d-02, 6.8294167210103d-03,-2.9136107202709d-02,
     |  -1.8245026094593d-02, 2.0797148275798d-02, 2.6186753496578d-02,
     |  -8.9565429159511d-03,-2.8977759705718d-02,-4.3550388668839d-03,
     |   2.5568396415613d-02, 1.6418106371510d-02,-1.5840178745553d-02,
     |  -2.3901116335480d-02, 1.0655717604708d-03, 2.2886712778849d-02,
     |   1.4980869012277d-02,-9.1084988560588d-03,-2.2342366164273d-02,
     |  -1.8004810391851d-02,-7.9113032172782d-03,-1.8671819180649d-03,
     |  -1.8849683983496d-04,-4.1792119504075d-06, 1.1017006722432d-07/
      data (zmn(lat, 8,32), lat = 1,72)/
     |  -3.8971510746765d-09, 5.4691282064791d-07, 4.2611066460078d-05,
     |   6.2195612574099d-04, 3.6723883666920d-03, 1.1640578708603d-02,
     |   2.1826054765112d-02, 2.2796766061838d-02, 5.3956898598103d-03,
     |  -1.8922927132318d-02,-2.2765881649143d-02, 2.2830714271748d-03,
     |   2.5897542080733d-02, 1.4448159740862d-02,-1.8637225502868d-02,
     |  -2.5814774703597d-02, 5.6343208300289d-03, 2.9893504427452d-02,
     |   8.9373173643616d-03,-2.6775259674270d-02,-2.1705015753247d-02,
     |   1.7822246684690d-02, 3.0255477097178d-02,-5.1721782391089d-03,
     |  -3.3223722998443d-02,-8.6807797024232d-03, 3.0302475161338d-02,
     |   2.1268675516881d-02,-2.2157666344629d-02,-3.0487501562796d-02,
     |   1.0249140727170d-02, 3.4866276653259d-02, 3.4285448073042d-03,
     |  -3.3742738917437d-02,-1.6658091982894d-02, 2.7328539145698d-02,
     |   2.7328539145698d-02,-1.6658091982894d-02,-3.3742738917437d-02,
     |   3.4285448073041d-03, 3.4866276653259d-02, 1.0249140727169d-02,
     |  -3.0487501562796d-02,-2.2157666344629d-02, 2.1268675516881d-02,
     |   3.0302475161338d-02,-8.6807797024231d-03,-3.3223722998443d-02,
     |  -5.1721782391091d-03, 3.0255477097178d-02, 1.7822246684690d-02,
     |  -2.1705015753247d-02,-2.6775259674270d-02, 8.9373173643614d-03,
     |   2.9893504427451d-02, 5.6343208300291d-03,-2.5814774703597d-02,
     |  -1.8637225502868d-02, 1.4448159740862d-02, 2.5897542080733d-02,
     |   2.2830714271747d-03,-2.2765881649143d-02,-1.8922927132318d-02,
     |   5.3956898598102d-03, 2.2796766061838d-02, 2.1826054765112d-02,
     |   1.1640578708603d-02, 3.6723883666921d-03, 6.2195612574085d-04,
     |   4.2611066460045d-05, 5.4691282073422d-07,-3.8971510669348d-09/
      data (zmn(lat, 9,32), lat = 1,72)/
     |   6.1554951623752d-09, 5.6848875602224d-08, 8.4171392027686d-06,
     |   1.7882680943915d-04, 1.4415507999880d-03, 6.1136031371844d-03,
     |   1.5671021552004d-02, 2.5072006869156d-02, 2.2179257945380d-02,
     |   1.1365399752443d-03,-2.2472613948670d-02,-2.1972021856545d-02,
     |   5.7998564926013d-03, 2.7580221062882d-02, 1.2810693751394d-02,
     |  -2.0796179818935d-02,-2.5935417885311d-02, 6.8987161971207d-03,
     |   3.0762672959132d-02, 8.9886727504680d-03,-2.7278103992252d-02,
     |  -2.2706631081307d-02, 1.7196135778794d-02, 3.1379454673232d-02,
     |  -3.2101839838228d-03,-3.3529727626820d-02,-1.1617666907611d-02,
     |   2.9043881847441d-02, 2.4377970119200d-02,-1.9002383798687d-02,
     |  -3.2741198971054d-02, 5.3915301130735d-03, 3.5267775127602d-02,
     |   9.2727266338107d-03,-3.1577646938546d-02,-2.2366767542108d-02,
     |   2.2366767542108d-02, 3.1577646938546d-02,-9.2727266338105d-03,
     |  -3.5267775127602d-02,-5.3915301130736d-03, 3.2741198971054d-02,
     |   1.9002383798687d-02,-2.4377970119200d-02,-2.9043881847441d-02,
     |   1.1617666907611d-02, 3.3529727626820d-02, 3.2101839838231d-03,
     |  -3.1379454673232d-02,-1.7196135778794d-02, 2.2706631081307d-02,
     |   2.7278103992253d-02,-8.9886727504680d-03,-3.0762672959131d-02,
     |  -6.8987161971209d-03, 2.5935417885311d-02, 2.0796179818935d-02,
     |  -1.2810693751394d-02,-2.7580221062882d-02,-5.7998564926015d-03,
     |   2.1972021856545d-02, 2.2472613948670d-02,-1.1365399752442d-03,
     |  -2.2179257945380d-02,-2.5072006869156d-02,-1.5671021552004d-02,
     |  -6.1136031371845d-03,-1.4415507999881d-03,-1.7882680943918d-04,
     |  -8.4171392028646d-06,-5.6848875615893d-08,-6.1554951803998d-09/
      data (zmn(lat,10,32), lat = 1,72)/
     |   1.6618489413353d-10, 5.9744930478297d-09, 1.4710921353228d-06,
     |   4.5177818453020d-05, 4.9066338347729d-04, 2.7208660370356d-03,
     |   9.1089191968304d-03, 1.9767006092716d-02, 2.7584885134943d-02,
     |   2.0594332690440d-02,-3.4144059756500d-03,-2.5498645276723d-02,
     |  -2.0602367568596d-02, 9.3228760809122d-03, 2.8928558551734d-02,
     |   1.1047778498849d-02,-2.2813890158412d-02,-2.5997154082914d-02,
     |   8.0348200632526d-03, 3.1588850753813d-02, 9.2271810338272d-03,
     |  -2.7629744171742d-02,-2.3881684949564d-02, 1.6247861891140d-02,
     |   3.2511866833831d-02,-8.1482166186907d-04,-3.3544000829895d-02,
     |  -1.4924784658396d-02, 2.7155657050883d-02, 2.7562557056220d-02,
     |  -1.4984101604696d-02,-3.4568523101900d-02,-3.1663315935498d-04,
     |   3.4643795499026d-02, 1.5613923107308d-02,-2.7864624018890d-02,
     |  -2.7864624018890d-02, 1.5613923107308d-02, 3.4643795499026d-02,
     |  -3.1663315935485d-04,-3.4568523101900d-02,-1.4984101604695d-02,
     |   2.7562557056220d-02, 2.7155657050883d-02,-1.4924784658396d-02,
     |  -3.3544000829895d-02,-8.1482166186920d-04, 3.2511866833831d-02,
     |   1.6247861891140d-02,-2.3881684949564d-02,-2.7629744171742d-02,
     |   9.2271810338267d-03, 3.1588850753813d-02, 8.0348200632528d-03,
     |  -2.5997154082914d-02,-2.2813890158413d-02, 1.1047778498848d-02,
     |   2.8928558551734d-02, 9.3228760809122d-03,-2.0602367568596d-02,
     |  -2.5498645276723d-02,-3.4144059756501d-03, 2.0594332690440d-02,
     |   2.7584885134943d-02, 1.9767006092716d-02, 9.1089191968304d-03,
     |   2.7208660370357d-03, 4.9066338347725d-04, 4.5177818453156d-05,
     |   1.4710921353602d-06, 5.9744929855024d-09, 1.6618489189684d-10/
      data (zmn(lat,11,32), lat = 1,72)/
     |  -3.2502661515545d-10, 8.8346672399400d-10, 2.2982287490660d-07,
     |   1.0158206267476d-05, 1.4729857854191d-04, 1.0524757519046d-03,
     |   4.4855291982230d-03, 1.2529878492813d-02, 2.3713051102998d-02,
     |   2.9286211666899d-02, 1.8206728631873d-02,-8.0194644261939d-03,
     |  -2.7938111923873d-02,-1.8797434154870d-02, 1.2709523676286d-02,
     |   2.9965797353904d-02, 9.2922153383777d-03,-2.4630253378008d-02,
     |  -2.6084604787187d-02, 8.9306410297621d-03, 3.2380482535727d-02,
     |   9.7718861512188d-03,-2.7753248511829d-02,-2.5298263508123d-02,
     |   1.4842313097551d-02, 3.3621020224002d-02, 2.1422402026339d-03,
     |  -3.3123336470091d-02,-1.8640188717992d-02, 2.4426199758354d-02,
     |   3.0701271089337d-02,-9.9194561785277d-03,-3.5670323661684d-02,
     |  -6.9030904037633d-03, 3.2575169734497d-02, 2.2206604082315d-02,
     |  -2.2206604082315d-02,-3.2575169734497d-02, 6.9030904037632d-03,
     |   3.5670323661684d-02, 9.9194561785278d-03,-3.0701271089337d-02,
     |  -2.4426199758354d-02, 1.8640188717991d-02, 3.3123336470091d-02,
     |  -2.1422402026338d-03,-3.3621020224002d-02,-1.4842313097552d-02,
     |   2.5298263508123d-02, 2.7753248511829d-02,-9.7718861512188d-03,
     |  -3.2380482535727d-02,-8.9306410297621d-03, 2.6084604787187d-02,
     |   2.4630253378008d-02,-9.2922153383775d-03,-2.9965797353904d-02,
     |  -1.2709523676285d-02, 1.8797434154870d-02, 2.7938111923873d-02,
     |   8.0194644261938d-03,-1.8206728631873d-02,-2.9286211666899d-02,
     |  -2.3713051102998d-02,-1.2529878492813d-02,-4.4855291982230d-03,
     |  -1.0524757519046d-03,-1.4729857854182d-04,-1.0158206267405d-05,
     |  -2.2982287475563d-07,-8.8346674450303d-10, 3.2502660899162d-10/
      data (zmn(lat,12,32), lat = 1,72)/
     |  -6.9235411444245d-12, 6.7557401403908d-11, 3.2459064577328d-08,
     |   2.0524786460608d-06, 3.9479947307378d-05, 3.5984960162784d-04,
     |   1.9211316094307d-03, 6.7138784912638d-03, 1.6221299129046d-02,
     |   2.7333066962385d-02, 3.0175255020963d-02, 1.5221006000289d-02,
     |  -1.2475536521074d-02,-2.9793909030251d-02,-1.6725779009010d-02,
     |   1.5843727907886d-02, 3.0752520915342d-02, 7.6834689211141d-03,
     |  -2.6202286408250d-02,-2.6294338601923d-02, 9.4724128156929d-03,
     |   3.3142412271237d-02, 1.0743064096559d-02,-2.7550652061680d-02,
     |  -2.7003330356519d-02, 1.2824225634707d-02, 3.4623194941732d-02,
     |   5.7788601905174d-03,-3.2056538973091d-02,-2.2735973116934d-02,
     |   2.0598621333957d-02, 3.3549605486631d-02,-3.6531258253226d-03,
     |  -3.5600956389598d-02,-1.4253445401292d-02, 2.8545085772836d-02,
     |   2.8545085772836d-02,-1.4253445401292d-02,-3.5600956389598d-02,
     |  -3.6531258253227d-03, 3.3549605486631d-02, 2.0598621333956d-02,
     |  -2.2735973116934d-02,-3.2056538973091d-02, 5.7788601905173d-03,
     |   3.4623194941732d-02, 1.2824225634707d-02,-2.7003330356519d-02,
     |  -2.7550652061680d-02, 1.0743064096560d-02, 3.3142412271237d-02,
     |   9.4724128156934d-03,-2.6294338601923d-02,-2.6202286408250d-02,
     |   7.6834689211140d-03, 3.0752520915342d-02, 1.5843727907887d-02,
     |  -1.6725779009010d-02,-2.9793909030251d-02,-1.2475536521075d-02,
     |   1.5221006000289d-02, 3.0175255020963d-02, 2.7333066962385d-02,
     |   1.6221299129046d-02, 6.7138784912639d-03, 1.9211316094308d-03,
     |   3.5984960162791d-04, 3.9479947307388d-05, 2.0524786459309d-06,
     |   3.2459064534865d-08, 6.7557399357679d-11,-6.9235194915451d-12/
      data (zmn(lat,13,32), lat = 1,72)/
     |   1.6226728772954d-11,-1.1322171291452d-11, 4.1789981621247d-09,
     |   3.7543566843346d-07, 9.5335812293737d-06, 1.1005077861721d-04,
     |   7.2794033729018d-04, 3.1269142774674d-03, 9.3432562133858d-03,
     |   2.0021170633917d-02, 3.0503603346799d-02, 3.0321071479830d-02,
     |   1.1860930884213d-02,-1.6625371057178d-02,-3.1126736569449d-02,
     |  -1.4570011894887d-02, 1.8637927053076d-02, 3.1377501250272d-02,
     |   6.3635253106961d-03,-2.7496545611832d-02,-2.6727449818256d-02,
     |   9.5394969881302d-03, 3.3863485913286d-02, 1.2258837646149d-02,
     |  -2.6890536119196d-02,-2.9006984523110d-02, 1.0017040769327d-02,
     |   3.5359895991978d-02, 1.0181706390180d-02,-3.0051285086293d-02,
     |  -2.7075567760797d-02, 1.5389590649706d-02, 3.5692982932786d-02,
     |   3.8753750378591d-03,-3.3754023930422d-02,-2.2002459255599d-02,
     |   2.2002459255599d-02, 3.3754023930422d-02,-3.8753750378590d-03,
     |  -3.5692982932786d-02,-1.5389590649706d-02, 2.7075567760797d-02,
     |   3.0051285086293d-02,-1.0181706390180d-02,-3.5359895991978d-02,
     |  -1.0017040769327d-02, 2.9006984523110d-02, 2.6890536119196d-02,
     |  -1.2258837646149d-02,-3.3863485913287d-02,-9.5394969881302d-03,
     |   2.6727449818256d-02, 2.7496545611832d-02,-6.3635253106960d-03,
     |  -3.1377501250272d-02,-1.8637927053076d-02, 1.4570011894887d-02,
     |   3.1126736569449d-02, 1.6625371057177d-02,-1.1860930884212d-02,
     |  -3.0321071479829d-02,-3.0503603346799d-02,-2.0021170633917d-02,
     |  -9.3432562133858d-03,-3.1269142774674d-03,-7.2794033729013d-04,
     |  -1.1005077861710d-04,-9.5335812295136d-06,-3.7543566843569d-07,
     |  -4.1789983515111d-09, 1.1322214702813d-11,-1.6226665896835d-11/
      data (zmn(lat,14,32), lat = 1,72)/
     |   2.7879423221048d-13,-4.9965617826399d-13, 4.8871730985949d-10,
     |   6.2535656953350d-08, 2.0884449237445d-06, 3.0367333788874d-05,
     |   2.4691787305620d-04, 1.2882460129049d-03, 4.6692982196549d-03,
     |   1.2280310577163d-02, 2.3778560279091d-02, 3.3160434875470d-02,
     |   2.9849909576647d-02, 8.3513476863859d-03,-2.0361801916341d-02,
     |  -3.2043311793500d-02,-1.2515811458095d-02, 2.1029567644521d-02,
     |   3.1946636407650d-02, 5.4753598702753d-03,-2.8477678428133d-02,
     |  -2.7480229066336d-02, 8.9978000922123d-03, 3.4499631313716d-02,
     |   1.4427623745588d-02,-2.5593999508759d-02,-3.1258086516147d-02,
     |   6.2290577851134d-03, 3.5569479349552d-02, 1.5368322778814d-02,
     |  -2.6729513150773d-02,-3.1352775182517d-02, 8.5385497273902d-03,
     |   3.6499873415973d-02, 1.2518214310767d-02,-2.9388784051881d-02,
     |  -2.9388784051881d-02, 1.2518214310767d-02, 3.6499873415973d-02,
     |   8.5385497273903d-03,-3.1352775182517d-02,-2.6729513150772d-02,
     |   1.5368322778814d-02, 3.5569479349552d-02, 6.2290577851135d-03,
     |  -3.1258086516147d-02,-2.5593999508759d-02, 1.4427623745587d-02,
     |   3.4499631313716d-02, 8.9978000922121d-03,-2.7480229066336d-02,
     |  -2.8477678428134d-02, 5.4753598702752d-03, 3.1946636407650d-02,
     |   2.1029567644521d-02,-1.2515811458095d-02,-3.2043311793500d-02,
     |  -2.0361801916341d-02, 8.3513476863861d-03, 2.9849909576647d-02,
     |   3.3160434875470d-02, 2.3778560279091d-02, 1.2280310577163d-02,
     |   4.6692982196549d-03, 1.2882460129049d-03, 2.4691787305603d-04,
     |   3.0367333788806d-05, 2.0884449237372d-06, 6.2535657095963d-08,
     |   4.8871732937872d-10,-4.9954929923107d-13, 2.7874260325162d-13/
      data (zmn(lat,15,32), lat = 1,72)/
     |  -7.5770074296498d-13, 7.3344419629034d-13, 5.1662876046266d-11,
     |   9.5279359099619d-09, 4.1721550060956d-07, 7.6099670142430d-06,
     |   7.5616040891624d-05, 4.7510385567833d-04, 2.0621198723942d-03,
     |   6.5172038956403d-03, 1.5413394280896d-02, 2.7367766881366d-02,
     |   3.5298710123485d-02, 2.8930228284370d-02, 4.9045857447540d-03,
     |  -2.3625167018121d-02,-3.2682491185713d-02,-1.0745031380665d-02,
     |   2.2972330091831d-02, 3.2570330376414d-02, 5.1638321060365d-03,
     |  -2.9093033887449d-02,-2.8631669399330d-02, 7.6931265966410d-03,
     |   3.4951618940309d-02, 1.7332825681471d-02,-2.3421772797972d-02,
     |  -3.3608387556128d-02, 1.2745317003613d-03, 3.4856733477826d-02,
     |   2.1223539055401d-02,-2.1645776118669d-02,-3.5013703170003d-02,
     |  -9.0861327944995d-05, 3.5097904287663d-02, 2.1746281701297d-02,
     |  -2.1746281701297d-02,-3.5097904287663d-02, 9.0861327944873d-05,
     |   3.5013703170003d-02, 2.1645776118669d-02,-2.1223539055401d-02,
     |  -3.4856733477826d-02,-1.2745317003616d-03, 3.3608387556128d-02,
     |   2.3421772797972d-02,-1.7332825681471d-02,-3.4951618940309d-02,
     |  -7.6931265966411d-03, 2.8631669399331d-02, 2.9093033887449d-02,
     |  -5.1638321060359d-03,-3.2570330376414d-02,-2.2972330091831d-02,
     |   1.0745031380665d-02, 3.2682491185713d-02, 2.3625167018122d-02,
     |  -4.9045857447542d-03,-2.8930228284370d-02,-3.5298710123485d-02,
     |  -2.7367766881366d-02,-1.5413394280896d-02,-6.5172038956403d-03,
     |  -2.0621198723942d-03,-4.7510385567833d-04,-7.5616040891711d-05,
     |  -7.6099670144385d-06,-4.1721550047763d-07,-9.5279358653112d-09,
     |  -5.1662661349824d-11,-7.3347025823322d-13, 7.5768839178178d-13/
      data (zmn(lat,16,32), lat = 1,72)/
     |  -1.0602077236656d-14, 3.0554020039216d-14, 5.1158565698111d-12,
     |   1.3321545461576d-09, 7.6313852838004d-08, 1.7403479796040d-06,
     |   2.1036890388513d-05, 1.5817211053999d-04, 8.1462680648576d-04,
     |   3.0511434671440d-03, 8.6128800229233d-03, 1.8625073642195d-02,
     |   3.0697548647093d-02, 3.6967619354139d-02, 2.7757587938828d-02,
     |   1.7126777370939d-03,-2.6394624201035d-02,-3.3200635728054d-02,
     |  -9.4331876567108d-03, 2.4422482504359d-02, 3.3348944854280d-02,
     |   5.5778500234503d-03,-2.9253350004576d-02,-3.0225391914155d-02,
     |   5.4474548981516d-03, 3.5037010329578d-02, 2.1004214486989d-02,
     |  -2.0068340929689d-02,-3.5763060054850d-02,-4.9783427440649d-03,
     |   3.2670555804804d-02, 2.7402113283080d-02,-1.4353804282637d-02,
     |  -3.7175221511477d-02,-1.0330308201112d-02, 3.0422473396959d-02,
     |   3.0422473396959d-02,-1.0330308201112d-02,-3.7175221511477d-02,
     |  -1.4353804282637d-02, 2.7402113283080d-02, 3.2670555804804d-02,
     |  -4.9783427440648d-03,-3.5763060054850d-02,-2.0068340929689d-02,
     |   2.1004214486989d-02, 3.5037010329578d-02, 5.4474548981519d-03,
     |  -3.0225391914154d-02,-2.9253350004576d-02, 5.5778500234502d-03,
     |   3.3348944854279d-02, 2.4422482504359d-02,-9.4331876567107d-03,
     |  -3.3200635728054d-02,-2.6394624201035d-02, 1.7126777370937d-03,
     |   2.7757587938828d-02, 3.6967619354138d-02, 3.0697548647094d-02,
     |   1.8625073642195d-02, 8.6128800229234d-03, 3.0511434671442d-03,
     |   8.1462680648581d-04, 1.5817211054000d-04, 2.1036890388639d-05,
     |   1.7403479795540d-06, 7.6313852928250d-08, 1.3321544128604d-09,
     |   5.1159151885585d-12, 3.0322755885340d-14,-1.0628830443853d-14/
      data (zmn(lat,17,32), lat = 1,72)/
     |   3.2573921808819d-14,-3.1358695949792d-14, 4.9777499237859d-13,
     |   1.7134097237148d-10, 1.2818463932050d-08, 3.6452683513044d-07,
     |   5.3411235082040d-06, 4.7822845140955d-05, 2.9028476861847d-04,
     |   1.2759804123262d-03, 4.2354130828426d-03, 1.0878180336133d-02,
     |   2.1802963451620d-02, 3.3714923220924d-02, 3.8260976855082d-02,
     |   2.6541293892074d-02,-1.0541047008502d-03,-2.8674259966950d-02,
     |  -3.3756821766318d-02,-8.7507349546392d-03, 2.5320818038664d-02,
     |   3.4354944294882d-02, 6.8713299026667d-03,-2.8809951066285d-02,
     |  -3.2242268050540d-02, 2.0636567170557d-03, 3.4457359806302d-02,
     |   2.5368383794721d-02,-1.5174480183452d-02,-3.7219329150183d-02,
     |  -1.2515844572415d-02, 2.8312387818252d-02, 3.3196251563866d-02,
     |  -4.5602730854991d-03,-3.6580834976439d-02,-2.1426992643947d-02,
     |   2.1426992643947d-02, 3.6580834976439d-02, 4.5602730854992d-03,
     |  -3.3196251563866d-02,-2.8312387818252d-02, 1.2515844572415d-02,
     |   3.7219329150183d-02, 1.5174480183452d-02,-2.5368383794721d-02,
     |  -3.4457359806303d-02,-2.0636567170559d-03, 3.2242268050540d-02,
     |   2.8809951066285d-02,-6.8713299026668d-03,-3.4354944294882d-02,
     |  -2.5320818038665d-02, 8.7507349546391d-03, 3.3756821766318d-02,
     |   2.8674259966949d-02, 1.0541047008502d-03,-2.6541293892074d-02,
     |  -3.8260976855082d-02,-3.3714923220924d-02,-2.1802963451619d-02,
     |  -1.0878180336133d-02,-4.2354130828425d-03,-1.2759804123263d-03,
     |  -2.9028476861850d-04,-4.7822845140950d-05,-5.3411235081999d-06,
     |  -3.6452683499665d-07,-1.2818463954339d-08,-1.7134104756913d-10,
     |  -4.9785630082717d-13, 3.1361840496058d-14,-3.2629689028744d-14/
      data (zmn(lat,18,32), lat = 1,72)/
     |   4.2895443947702d-16,-1.0739394191071d-15, 4.0844457360970d-14,
     |   2.0316769718874d-11, 1.9813198861939d-09, 7.0108508798382d-08,
     |   1.2415870569820d-06, 1.3187476159886d-05, 9.3853900345608d-05,
     |   4.8068531648834d-04, 1.8568041291100d-03, 5.5743656243098d-03,
     |   1.3221820894046d-02, 2.4847503309491d-02, 3.6403639931925d-02,
     |   3.9305194947343d-02, 2.5494012708408d-02,-3.2425895713954d-03,
     |  -3.0474737354298d-02,-3.4497462600554d-02,-8.8664920931779d-03,
     |   2.5570725905177d-02, 3.5609166204193d-02, 9.1985446352433d-03,
     |  -2.7530179358188d-02,-3.4558922529226d-02,-2.6518376674465d-03,
     |   3.2765902407728d-02, 3.0169663264273d-02,-8.3784585773693d-03,
     |  -3.7205121818721d-02,-2.1024582795614d-02, 2.1018883856998d-02,
     |   3.7388474507945d-02, 7.5851925572786d-03,-3.1684857856469d-02,
     |  -3.1684857856469d-02, 7.5851925572785d-03, 3.7388474507945d-02,
     |   2.1018883856998d-02,-2.1024582795614d-02,-3.7205121818721d-02,
     |  -8.3784585773695d-03, 3.0169663264273d-02, 3.2765902407728d-02,
     |  -2.6518376674464d-03,-3.4558922529226d-02,-2.7530179358189d-02,
     |   9.1985446352432d-03, 3.5609166204193d-02, 2.5570725905177d-02,
     |  -8.8664920931774d-03,-3.4497462600554d-02,-3.0474737354298d-02,
     |  -3.2425895713955d-03, 2.5494012708408d-02, 3.9305194947343d-02,
     |   3.6403639931925d-02, 2.4847503309491d-02, 1.3221820894046d-02,
     |   5.5743656243097d-03, 1.8568041291101d-03, 4.8068531648821d-04,
     |   9.3853900345694d-05, 1.3187476159865d-05, 1.2415870568687d-06,
     |   7.0108508812997d-08, 1.9813197197752d-09, 2.0316887644157d-11,
     |   4.0837879960293d-14,-9.5111630100876d-16, 4.2765776241243d-16/
      data (zmn(lat,19,32), lat = 1,72)/
     |  -1.3264603778878d-15, 1.1165446244202d-15, 1.7942868545226d-15,
     |   2.2237983279833d-12, 2.8216944615765d-10, 1.2401398929287d-08,
     |   2.6482120189591d-07, 3.3263746488067d-06, 2.7642935828293d-05,
     |   1.6405564783961d-04, 7.3188670955956d-04, 2.5401553435546d-03,
     |   7.0095700558518d-03, 1.5546246210516d-02, 2.7675795759541d-02,
     |   3.8777837982163d-02, 4.0245850185917d-02, 2.4824719633145d-02,
     |  -4.7067147301019d-03,-3.1790837011378d-02,-3.5538605427593d-02,
     |  -9.9501797054777d-03, 2.5013459563037d-02, 3.7047509945694d-02,
     |   1.2696569722441d-02,-2.5075925580307d-02,-3.6887390029138d-02,
     |  -8.8332437786443d-03, 2.9349975763407d-02, 3.4855937408763d-02,
     |   5.6193145550905d-04,-3.4651702192829d-02,-2.9664279020939d-02,
     |   1.0190480166244d-02, 3.8161507134231d-02, 2.1029072333365d-02,
     |  -2.1029072333365d-02,-3.8161507134231d-02,-1.0190480166244d-02,
     |   2.9664279020939d-02, 3.4651702192829d-02,-5.6193145550920d-04,
     |  -3.4855937408763d-02,-2.9349975763407d-02, 8.8332437786442d-03,
     |   3.6887390029138d-02, 2.5075925580307d-02,-1.2696569722441d-02,
     |  -3.7047509945695d-02,-2.5013459563037d-02, 9.9501797054777d-03,
     |   3.5538605427593d-02, 3.1790837011378d-02, 4.7067147301019d-03,
     |  -2.4824719633145d-02,-4.0245850185917d-02,-3.8777837982163d-02,
     |  -2.7675795759541d-02,-1.5546246210516d-02,-7.0095700558519d-03,
     |  -2.5401553435547d-03,-7.3188670955957d-04,-1.6405564783961d-04,
     |  -2.7642935828315d-05,-3.3263746487768d-06,-2.6482120183084d-07,
     |  -1.2401399018901d-08,-2.8216937651282d-10,-2.2236726869369d-12,
     |  -1.8705357583003d-15,-1.1702646528729d-15, 1.3254783147797d-15/
      data (zmn(lat,20,32), lat = 1,72)/
     |   1.7074860180878d-17, 2.4871791194772d-17, 1.1149581218133d-16,
     |   2.2439940152221d-13, 3.7044657688411d-11, 2.0191758246371d-09,
     |   5.1889311110696d-08, 7.6882126400616d-07, 7.4358078161131d-06,
     |   5.0916053031962d-05, 2.6081871883677d-04, 1.0381576744268d-03,
     |   3.2944762834172d-03, 8.4687012619345d-03, 1.7752971909720d-02,
     |   3.0221139062571d-02, 4.0871569654580d-02, 4.1233448241251d-02,
     |   2.4734312966474d-02,-5.2936132965107d-03,-3.2574799661862d-02,
     |  -3.6942657633916d-02,-1.2168968667086d-02, 2.3403269282709d-02,
     |   3.8473836018622d-02, 1.7443474908229d-02,-2.0996644458025d-02,
     |  -3.8694720101077d-02,-1.6444764044989d-02, 2.3459344133973d-02,
     |   3.8437498432119d-02, 1.1533555309981d-02,-2.8274621892388d-02,
     |  -3.6793832995852d-02,-4.1398165915385d-03, 3.3233869002659d-02,
     |   3.3233869002659d-02,-4.1398165915384d-03,-3.6793832995852d-02,
     |  -2.8274621892388d-02, 1.1533555309980d-02, 3.8437498432119d-02,
     |   2.3459344133973d-02,-1.6444764044989d-02,-3.8694720101077d-02,
     |  -2.0996644458025d-02, 1.7443474908229d-02, 3.8473836018622d-02,
     |   2.3403269282709d-02,-1.2168968667086d-02,-3.6942657633916d-02,
     |  -3.2574799661862d-02,-5.2936132965109d-03, 2.4734312966473d-02,
     |   4.1233448241251d-02, 4.0871569654580d-02, 3.0221139062571d-02,
     |   1.7752971909720d-02, 8.4687012619345d-03, 3.2944762834173d-03,
     |   1.0381576744268d-03, 2.6081871883665d-04, 5.0916053032083d-05,
     |   7.4358078160699d-06, 7.6882126401902d-07, 5.1889311225273d-08,
     |   2.0191759284219d-09, 3.7044839378865d-11, 2.2427925140389d-13,
     |  -2.5857312287877d-17, 3.4685686879606d-17, 2.8551705196021d-18/
      data (zmn(lat,21,32), lat = 1,72)/
     |   4.4659215433705d-17,-5.9826645230708d-17,-1.9622799072210d-17,
     |   2.0736178631452d-14, 4.4820880799485d-12, 3.0259904729900d-10,
     |   9.3427502690144d-09, 1.6294178689372d-07, 1.8291572872424d-06,
     |   1.4400804438040d-05, 8.4319910627996d-05, 3.8258488364453d-04,
     |   1.3845227054347d-03, 4.0750909323833d-03, 9.8698940142211d-03,
     |   1.9745658790481d-02, 3.2428339980023d-02, 4.2724788491261d-02,
     |   4.2408145078073d-02, 2.5412021269067d-02,-4.8280143502883d-03,
     |  -3.2705226087247d-02,-3.8684729019020d-02,-1.5669793734689d-02,
     |   2.0388878715073d-02, 3.9496382212502d-02, 2.3376081873310d-02,
     |  -1.4760189236479d-02,-3.9112875067246d-02,-2.5089906344753d-02,
     |   1.4338912867779d-02, 3.9363548806441d-02, 2.3680363042958d-02,
     |  -1.6897379125160d-02,-3.9773626797298d-02,-2.0530093448129d-02,
     |   2.0530093448129d-02, 3.9773626797298d-02, 1.6897379125160d-02,
     |  -2.3680363042958d-02,-3.9363548806441d-02,-1.4338912867779d-02,
     |   2.5089906344753d-02, 3.9112875067246d-02, 1.4760189236479d-02,
     |  -2.3376081873310d-02,-3.9496382212502d-02,-2.0388878715073d-02,
     |   1.5669793734689d-02, 3.8684729019020d-02, 3.2705226087247d-02,
     |   4.8280143502887d-03,-2.5412021269067d-02,-4.2408145078073d-02,
     |  -4.2724788491262d-02,-3.2428339980023d-02,-1.9745658790481d-02,
     |  -9.8698940142210d-03,-4.0750909323834d-03,-1.3845227054347d-03,
     |  -3.8258488364444d-04,-8.4319910627894d-05,-1.4400804438059d-05,
     |  -1.8291572871787d-06,-1.6294178690398d-07,-9.3427502892671d-09,
     |  -3.0259899616610d-10,-4.4821541232807d-12,-2.0873762412437d-14,
     |   9.4914422139558d-17, 5.9201254936630d-17,-7.3024634308605d-18/
      data (zmn(lat,22,32), lat = 1,72)/
     |   7.7221115291266d-17,-5.0014204821160d-17,-1.8116095755265d-16,
     |   1.5724944300894d-15, 4.9913448254167d-13, 4.1702729922433d-11,
     |   1.5447720643735d-09, 3.1656198881881d-08, 4.1154445351707d-07,
     |   3.7147101136803d-06, 2.4771115807254d-05, 1.2751401521402d-04,
     |   5.2291838834167d-04, 1.7469666544925d-03, 4.8269194211492d-03,
     |   1.1125840748916d-02, 2.1430659159504d-02, 3.4245269226292d-02,
     |   4.4366152448461d-02, 4.3882162405623d-02, 2.7029240348821d-02,
     |  -3.0986686108857d-03,-3.1952060018831d-02,-4.0602626583225d-02,
     |  -2.0534652066174d-02, 1.5515503171733d-02, 3.9451461194698d-02,
     |   3.0147851748384d-02,-5.8638396485655d-03,-3.6876974106055d-02,
     |  -3.3726700126225d-02, 1.5587675782674d-03, 3.5538097402146d-02,
     |   3.4883368427949d-02,-2.0874879330133d-04,-3.5160713140171d-02,
     |  -3.5160713140171d-02,-2.0874879330148d-04, 3.4883368427948d-02,
     |   3.5538097402146d-02, 1.5587675782675d-03,-3.3726700126225d-02,
     |  -3.6876974106055d-02,-5.8638396485658d-03, 3.0147851748384d-02,
     |   3.9451461194698d-02, 1.5515503171733d-02,-2.0534652066174d-02,
     |  -4.0602626583225d-02,-3.1952060018831d-02,-3.0986686108858d-03,
     |   2.7029240348820d-02, 4.3882162405623d-02, 4.4366152448461d-02,
     |   3.4245269226292d-02, 2.1430659159504d-02, 1.1125840748916d-02,
     |   4.8269194211492d-03, 1.7469666544925d-03, 5.2291838834158d-04,
     |   1.2751401521397d-04, 2.4771115807365d-05, 3.7147101136080d-06,
     |   4.1154445345547d-07, 3.1656198876618d-08, 1.5447720541000d-09,
     |   4.1702670302159d-11, 4.9912584983028d-13, 1.6257068613571d-15,
     |  -6.7372935485688d-17,-6.3048940837250d-17, 7.9387061269759d-17/
      data (zmn(lat,23,32), lat = 1,72)/
     |   7.5381357217034d-18,-5.1649815624228d-18,-6.9983989325526d-17,
     |   1.8027199101020d-18, 5.0939408120608d-14, 5.2754525246640d-12,
     |   2.3417174499886d-10, 5.6299829906538d-09, 8.4602280471796d-08,
     |   8.7344307912045d-07, 6.6136137771808d-06, 3.8478503487480d-05,
     |   1.7793466539867d-04, 6.7031628046971d-04, 2.0938721018984d-03,
     |   5.4880841041994d-03, 1.2147325121602d-02, 2.2715335127358d-02,
     |   3.5611481173252d-02, 4.5792730627809d-02, 4.5717580980955d-02,
     |   2.9725547140431d-02, 1.4679207107842d-04,-2.9940980836002d-02,
     |  -4.2325063344862d-02,-2.6690546651403d-02, 8.2753435175096d-03,
     |   3.7335146611722d-02, 3.6912773057491d-02, 5.9079260509651d-03,
     |  -3.0385193878534d-02,-4.0326079247619d-02,-1.4347032513905d-02,
     |   2.4727883762080d-02, 4.1308295518316d-02, 1.9896086368644d-02,
     |  -1.9896086368644d-02,-4.1308295518316d-02,-2.4727883762080d-02,
     |   1.4347032513905d-02, 4.0326079247619d-02, 3.0385193878534d-02,
     |  -5.9079260509649d-03,-3.6912773057491d-02,-3.7335146611722d-02,
     |  -8.2753435175097d-03, 2.6690546651403d-02, 4.2325063344862d-02,
     |   2.9940980836002d-02,-1.4679207107845d-04,-2.9725547140431d-02,
     |  -4.5717580980955d-02,-4.5792730627809d-02,-3.5611481173252d-02,
     |  -2.2715335127358d-02,-1.2147325121602d-02,-5.4880841041995d-03,
     |  -2.0938721018984d-03,-6.7031628046959d-04,-1.7793466539868d-04,
     |  -3.8478503487508d-05,-6.6136137772798d-06,-8.7344307904624d-07,
     |  -8.4602280530490d-08,-5.6299829674283d-09,-2.3417176403764d-10,
     |  -5.2754094445065d-12,-5.0934055060131d-14, 5.9614144131391d-17,
     |   3.2150398583668d-17, 4.1216206471689d-17,-2.9992256912576d-17/
      data (zmn(lat,24,32), lat = 1,72)/
     |   1.5016424869053d-16, 2.6672076224944d-17,-1.1352608296455d-16,
     |  -1.8046150487150d-16, 4.6147637137544d-15, 6.1070167879474d-13,
     |   3.2454267064190d-11, 9.1423348761343d-10, 1.5854363935920d-08,
     |   1.8684429251613d-07, 1.6024812579516d-06, 1.0504951914547d-05,
     |   5.4562737096470d-05, 2.3060921046439d-04, 8.0891254262576d-04,
     |   2.3886213134888d-03, 5.9942016989922d-03, 1.2846342999375d-02,
     |   2.3505093136654d-02, 3.6445205243832d-02, 4.6946712032940d-02,
     |   4.7896384937220d-02, 3.3579328821036d-02, 5.1874904483508d-03,
     |  -2.6127221452189d-02,-4.3177727085637d-02,-3.3751612222790d-02,
     |  -1.7444564112904d-03, 3.1800004858138d-02, 4.2051501149693d-02,
     |   1.9997447618356d-02,-1.8064129925488d-02,-4.1649117014829d-02,
     |  -3.0891519562606d-02, 5.7657191901770d-03, 3.7619780877190d-02,
     |   3.7619780877190d-02, 5.7657191901771d-03,-3.0891519562606d-02,
     |  -4.1649117014829d-02,-1.8064129925488d-02, 1.9997447618356d-02,
     |   4.2051501149693d-02, 3.1800004858138d-02,-1.7444564112904d-03,
     |  -3.3751612222790d-02,-4.3177727085637d-02,-2.6127221452189d-02,
     |   5.1874904483508d-03, 3.3579328821036d-02, 4.7896384937220d-02,
     |   4.6946712032940d-02, 3.6445205243832d-02, 2.3505093136654d-02,
     |   1.2846342999375d-02, 5.9942016989921d-03, 2.3886213134889d-03,
     |   8.0891254262579d-04, 2.3060921046443d-04, 5.4562737096557d-05,
     |   1.0504951914556d-05, 1.6024812579236d-06, 1.8684429249244d-07,
     |   1.5854363936372d-08, 9.1423346721419d-10, 3.2454188431302d-11,
     |   6.1071753049255d-13, 4.6667409213335d-15,-1.2548297850638d-16,
     |  -2.3325103166700d-17,-3.1008775704852d-18, 1.2668359122966d-16/
      data (zmn(lat,25,32), lat = 1,72)/
     |   1.2174905813893d-18,-9.4482987139864d-18,-6.1724475619835d-17,
     |  -1.4452412864080d-16, 2.1724183007971d-16, 6.4257397854580d-14,
     |   4.0948318128195d-12, 1.3500662370120d-10, 2.6981219454835d-09,
     |   3.6235447268636d-08, 3.5127796812366d-07, 2.5879591933253d-06,
     |   1.5049709313550d-05, 7.1074141681340d-05, 2.7849979310176d-04,
     |   9.2012626378200d-04, 2.5932621572223d-03, 6.2833813925666d-03,
     |   1.3139519013201d-02, 2.3700862735208d-02, 3.6630873628683d-02,
     |   4.7689969791062d-02, 5.0279675307229d-02, 3.8553149289106d-02,
     |   1.2277181630693d-02,-1.9802133013593d-02,-4.2082304306254d-02,
     |  -4.0775869481258d-02,-1.4542678841730d-02, 2.1340030044383d-02,
     |   4.2943697495490d-02, 3.4318641849849d-02, 6.7388726733712d-04,
     |  -3.3601507572952d-02,-4.2578571742198d-02,-1.9071904677275d-02,
     |   1.9071904677274d-02, 4.2578571742198d-02, 3.3601507572952d-02,
     |  -6.7388726733698d-04,-3.4318641849849d-02,-4.2943697495490d-02,
     |  -2.1340030044383d-02, 1.4542678841730d-02, 4.0775869481258d-02,
     |   4.2082304306254d-02, 1.9802133013593d-02,-1.2277181630693d-02,
     |  -3.8553149289105d-02,-5.0279675307229d-02,-4.7689969791062d-02,
     |  -3.6630873628683d-02,-2.3700862735208d-02,-1.3139519013201d-02,
     |  -6.2833813925667d-03,-2.5932621572223d-03,-9.2012626378196d-04,
     |  -2.7849979310179d-04,-7.1074141681420d-05,-1.5049709313532d-05,
     |  -2.5879591933043d-06,-3.5127796808233d-07,-3.6235447330294d-08,
     |  -2.6981219808487d-09,-1.3500662961696d-10,-4.0948261262253d-12,
     |  -6.4302717009891d-14,-2.4964356485461d-16, 1.1229554083807d-16,
     |   8.5088348699520d-17,-4.5879193871106d-17, 4.1437917564334d-17/
      data (zmn(lat,26,32), lat = 1,72)/
     |  -3.7045497909754d-17,-3.6953457837464d-17,-6.1427544889230d-17,
     |  -1.0842665312519d-16,-1.1355922894927d-16, 6.0081145996173d-15,
     |   4.6744208860106d-13, 1.8022921600656d-11, 4.1459617696775d-10,
     |   6.3358402831816d-09, 6.9303513658328d-08, 5.7256912540856d-07,
     |   3.7180405632481d-06, 1.9555545785171d-05, 8.5245268232849d-05,
     |   3.1344217640789d-04, 9.8520429602295d-04, 2.6731496383543d-03,
     |   6.3022200298821d-03, 1.2953129229115d-02, 2.3199738495202d-02,
     |   3.6010909925951d-02, 4.7779587169350d-02, 5.2555142636914d-02,
     |   4.4403185686432d-02, 2.1527017100900d-02,-1.0178725869361d-02,
     |  -3.7499402588764d-02,-4.5951198484718d-02,-2.9130919335595d-02,
     |   4.8827243763103d-03, 3.6083598934394d-02, 4.4396655537846d-02,
     |   2.3606816110303d-02,-1.3035568221071d-02,-4.0901689666025d-02,
     |  -4.0901689666025d-02,-1.3035568221071d-02, 2.3606816110303d-02,
     |   4.4396655537846d-02, 3.6083598934394d-02, 4.8827243763102d-03,
     |  -2.9130919335595d-02,-4.5951198484718d-02,-3.7499402588764d-02,
     |  -1.0178725869361d-02, 2.1527017100900d-02, 4.4403185686432d-02,
     |   5.2555142636914d-02, 4.7779587169350d-02, 3.6010909925951d-02,
     |   2.3199738495202d-02, 1.2953129229115d-02, 6.3022200298821d-03,
     |   2.6731496383542d-03, 9.8520429602303d-04, 3.1344217640787d-04,
     |   8.5245268232899d-05, 1.9555545785252d-05, 3.7180405631621d-06,
     |   5.7256912539583d-07, 6.9303513605328d-08, 6.3358403264796d-09,
     |   4.1459618946950d-10, 1.8022944086434d-11, 4.6750288982265d-13,
     |   6.0674044395324d-15,-1.4475660491487d-16,-7.0143955648485d-17,
     |  -9.6579209002613d-17,-9.5593772093513d-18,-3.2411189842751d-17/
      data (zmn(lat,27,32), lat = 1,72)/
     |   2.1428204542276d-17, 2.7162791903885d-17,-1.6492283376422d-17,
     |  -9.3005547729454d-17,-1.6772342727223d-16, 3.1614025306716d-16,
     |   4.7700798688309d-14, 2.1563745167132d-12, 5.7041167230391d-11,
     |   9.9066042591196d-10, 1.2208071130716d-08, 1.1289802783276d-07,
     |   8.1680547257792d-07, 4.7715797896707d-06, 2.3061430816256d-05,
     |   9.3973141927248d-05, 3.2764188868600d-04, 9.8850535509493d-04,
     |   2.6024770743884d-03, 6.0132965949504d-03, 1.2231579738918d-02,
     |   2.1902703006777d-02, 3.4388097180691d-02, 4.6852271361333d-02,
     |   5.4178563070982d-02, 5.0546744649181d-02, 3.2689013275892d-02,
     |   3.3648650226652d-03,-2.7535976285840d-02,-4.6320547576872d-02,
     |  -4.2687588534276d-02,-1.6916009524990d-02, 1.8163971702338d-02,
     |   4.3130243715055d-02, 4.3237347653628d-02, 1.7958086051101d-02,
     |  -1.7958086051101d-02,-4.3237347653628d-02,-4.3130243715055d-02,
     |  -1.8163971702338d-02, 1.6916009524989d-02, 4.2687588534276d-02,
     |   4.6320547576872d-02, 2.7535976285840d-02,-3.3648650226652d-03,
     |  -3.2689013275892d-02,-5.0546744649181d-02,-5.4178563070982d-02,
     |  -4.6852271361333d-02,-3.4388097180691d-02,-2.1902703006777d-02,
     |  -1.2231579738918d-02,-6.0132965949504d-03,-2.6024770743884d-03,
     |  -9.8850535509499d-04,-3.2764188868594d-04,-9.3973141927296d-05,
     |  -2.3061430816276d-05,-4.7715797896535d-06,-8.1680547260849d-07,
     |  -1.1289802784185d-07,-1.2208071128767d-08,-9.9066043763787d-10,
     |  -5.7041167638566d-11,-2.1563729906494d-12,-4.7745072203544d-14,
     |  -3.6093476897859d-16, 1.6811128510369d-16, 7.6298952153791d-17,
     |   3.2564759424419d-18,-5.3910716118238d-17,-3.5406252895364d-17/
      data (zmn(lat,28,32), lat = 1,72)/
     |   1.4661039814619d-16, 1.0494888431856d-16, 3.1200227033402d-17,
     |  -6.5027984124982d-17,-1.5568979251364d-16,-1.6000878830434d-16,
     |   4.1456741015217d-15, 2.2827191197048d-13, 6.9402604691603d-12,
     |   1.3683308333998d-10, 1.8971850507073d-09, 1.9607765613380d-08,
     |   1.5775445231563d-07, 1.0212164316350d-06, 5.4570163586112d-06,
     |   2.4559238259238d-05, 9.4576105472908d-05, 3.1556364252713d-04,
     |   9.2123438608905d-04, 2.3705069722346d-03, 5.4046381078432d-03,
     |   1.0951410422663d-02, 1.9734501723709d-02, 3.1548516004118d-02,
     |   4.4434114185859d-02, 5.4330044249498d-02, 5.5900272947683d-02,
     |   4.4814353359685d-02, 2.0774078902371d-02,-1.0448323815247d-02,
     |  -3.7870111942884d-02,-4.9687240574599d-02,-3.9510974144038d-02,
     |  -1.0917057321891d-02, 2.2995556891016d-02, 4.5652265174069d-02,
     |   4.5652265174070d-02, 2.2995556891016d-02,-1.0917057321891d-02,
     |  -3.9510974144038d-02,-4.9687240574599d-02,-3.7870111942884d-02,
     |  -1.0448323815247d-02, 2.0774078902370d-02, 4.4814353359684d-02,
     |   5.5900272947683d-02, 5.4330044249498d-02, 4.4434114185859d-02,
     |   3.1548516004118d-02, 1.9734501723709d-02, 1.0951410422664d-02,
     |   5.4046381078432d-03, 2.3705069722347d-03, 9.2123438608905d-04,
     |   3.1556364252722d-04, 9.4576105472834d-05, 2.4559238259185d-05,
     |   5.4570163585247d-06, 1.0212164315202d-06, 1.5775445235734d-07,
     |   1.9607765620721d-08, 1.8971850468383d-09, 1.3683305392515d-10,
     |   6.9403043297402d-12, 2.2827667024319d-13, 4.1641608621281d-15,
     |  -1.5561163102764d-16,-1.8172924691391d-16,-2.3367888739873d-17,
     |  -3.3537420152452d-17, 1.0956433302261d-16, 9.5461509840916d-17/
      data (zmn(lat,29,32), lat = 1,72)/
     |   5.1257370036412d-17, 1.3500634325393d-16, 1.4961171777961d-16,
     |   1.1067830651560d-16, 3.8040726005169d-17,-5.8412014774333d-17,
     |   2.1515065758037d-16, 2.0860460511580d-14, 7.3267643098181d-13,
     |   1.6385706915250d-11, 2.5531785700616d-10, 2.9449809564539d-09,
     |   2.6305595314364d-08, 1.8833481933284d-07, 1.1101085952199d-06,
     |   5.5022140021623d-06, 2.3322255098242d-05, 8.5691343695897d-05,
     |   2.7589507008133d-04, 7.8511329311523d-04, 1.9879609098953d-03,
     |   4.5010604031418d-03, 9.1422393635874d-03, 1.6680963895999d-02,
     |   2.7318818721438d-02, 4.0004548178787d-02, 5.1933382844776d-02,
     |   5.8746544916379d-02, 5.5813879902794d-02, 4.0443811593342d-02,
     |   1.4111732313050d-02,-1.6675324329763d-02,-4.1942524076547d-02,
     |  -5.2110499223043d-02,-4.2539559220991d-02,-1.6341318828439d-02,
     |   1.6341318828439d-02, 4.2539559220991d-02, 5.2110499223043d-02,
     |   4.1942524076547d-02, 1.6675324329763d-02,-1.4111732313050d-02,
     |  -4.0443811593342d-02,-5.5813879902794d-02,-5.8746544916379d-02,
     |  -5.1933382844776d-02,-4.0004548178787d-02,-2.7318818721439d-02,
     |  -1.6680963895999d-02,-9.1422393635874d-03,-4.5010604031418d-03,
     |  -1.9879609098953d-03,-7.8511329311521d-04,-2.7589507008135d-04,
     |  -8.5691343695847d-05,-2.3322255098308d-05,-5.5022140021697d-06,
     |  -1.1101085951893d-06,-1.8833481932771d-07,-2.6305595263853d-08,
     |  -2.9449809737469d-09,-2.5531785492435d-10,-1.6385678369852d-11,
     |  -7.3263007252481d-13,-2.0852099782451d-14,-1.4606926353167d-16,
     |   9.1269923073793d-17,-8.2748756644114d-18,-1.1627590684302d-16,
     |  -1.7044523830639d-16,-1.0242633797915d-16,-8.6199984292356d-17/
      data (zmn(lat,30,32), lat = 1,72)/
     |   6.4831278125811d-17, 5.8011582458601d-17, 5.3384260910847d-17,
     |   3.3733946397117d-17,-1.2770396649226d-17,-6.7396367397806d-17,
     |  -9.8328739791431d-17, 1.4574875502393d-15, 6.4915229531760d-14,
     |   1.6494990827818d-12, 2.8857950217731d-11, 3.7104813496923d-10,
     |   3.6744554499134d-09, 2.9046540581784d-08, 1.8847899014542d-07,
     |   1.0263974802798d-06, 4.7749942167400d-06, 1.9252593004419d-05,
     |   6.8070589194238d-05, 2.1307813712312d-04, 5.9511437930766d-04,
     |   1.4922601086779d-03, 3.3757339708476d-03, 6.9134842288099d-03,
     |   1.2846195221451d-02, 2.1671881410809d-02, 3.3155554265251d-02,
     |   4.5827500012349d-02, 5.6780410094574d-02, 6.2099862433332d-02,
     |   5.8059862706732d-02, 4.2803189184746d-02, 1.7799878426643d-02,
     |  -1.1766797913511d-02,-3.8195495127369d-02,-5.3804252494235d-02,
     |  -5.3804252494235d-02,-3.8195495127369d-02,-1.1766797913511d-02,
     |   1.7799878426643d-02, 4.2803189184746d-02, 5.8059862706732d-02,
     |   6.2099862433332d-02, 5.6780410094574d-02, 4.5827500012349d-02,
     |   3.3155554265251d-02, 2.1671881410809d-02, 1.2846195221451d-02,
     |   6.9134842288098d-03, 3.3757339708476d-03, 1.4922601086779d-03,
     |   5.9511437930769d-04, 2.1307813712313d-04, 6.8070589194256d-05,
     |   1.9252593004432d-05, 4.7749942167274d-06, 1.0263974803381d-06,
     |   1.8847899019381d-07, 2.9046540650363d-08, 3.6744554694346d-09,
     |   3.7104816455654d-10, 2.8858042754164d-11, 1.6495410483907d-12,
     |   6.4859001997938d-14, 1.4583000629532d-15,-1.2818895109787d-16,
     |  -7.4496138370706d-17, 1.2922465104952d-17,-1.4869143972546d-17,
     |   7.9864322607784d-17, 2.1074682661442d-17, 4.9088606974618d-17/
      data (zmn(lat,31,32), lat = 1,72)/
     |   1.2385184494966d-19,-6.5704458846241d-18,-2.6650217940907d-17,
     |  -4.8080448741257d-17,-6.8986495079289d-17,-9.0354874722798d-17,
     |  -1.1974969265468d-16,-5.3371712917673d-17, 4.4239035936281d-15,
     |   1.3165860133051d-13, 2.5865157464697d-12, 3.7034492848862d-11,
     |   4.0609692952202d-10, 3.5393152714032d-09, 2.5239416872500d-08,
     |   1.5070781643550d-07, 7.6767134507484d-07, 3.3868365961531d-06,
     |   1.3104502923715d-05, 4.4931329066170d-05, 1.3769433303923d-04,
     |   3.7986225787498d-04, 9.4896253523394d-04, 2.1571809790105d-03,
     |   4.4793722355452d-03, 8.5215404848845d-03, 1.4882056569394d-02,
     |   2.3882852256473d-02, 3.5212674082689d-02, 4.7612367932336d-02,
     |   5.8794899651868d-02, 6.5769973773596d-02, 6.5603687300475d-02,
     |   5.6425264151920d-02, 3.8303376698782d-02, 1.3579106943344d-02,
     |  -1.3579106943344d-02,-3.8303376698782d-02,-5.6425264151920d-02,
     |  -6.5603687300475d-02,-6.5769973773596d-02,-5.8794899651868d-02,
     |  -4.7612367932336d-02,-3.5212674082689d-02,-2.3882852256473d-02,
     |  -1.4882056569394d-02,-8.5215404848845d-03,-4.4793722355453d-03,
     |  -2.1571809790105d-03,-9.4896253523392d-04,-3.7986225787501d-04,
     |  -1.3769433303926d-04,-4.4931329066187d-05,-1.3104502923709d-05,
     |  -3.3868365961612d-06,-7.6767134507353d-07,-1.5070781644807d-07,
     |  -2.5239416926904d-08,-3.5393153166655d-09,-4.0609701148726d-10,
     |  -3.7034532742149d-11,-2.5865870754456d-12,-1.3168421464557d-13,
     |  -4.4351592801311d-15, 4.6556229938640d-17, 7.7219792261313d-17,
     |   7.1790799625350d-17, 1.9465794974177d-17, 3.7415061869732d-17,
     |  -3.7623627603171d-18,-2.3008798563103d-17, 8.1627759901248d-19/
      data (zmn(lat,32,32), lat = 1,72)/
     |   8.3542683007063d-17, 7.1802929472578d-17, 5.4820184490652d-17,
     |   2.4901972992619d-17,-1.2216289827505d-17,-5.5686285955239d-17,
     |  -9.1809869567933d-17,-1.1056362581705d-16, 8.1899816268139d-17,
     |   7.1034590219335d-15, 1.5931133379521d-13, 2.5396067468189d-12,
     |   3.0803097137977d-11, 2.9561175557711d-10, 2.3132881673909d-09,
     |   1.5119476224564d-08, 8.4153712519469d-08, 4.0527383812983d-07,
     |   1.7111427928225d-06, 6.4042951780387d-06, 2.1445447909969d-05,
     |   6.4758343846501d-05, 1.7752784984805d-04, 4.4436552895120d-04,
     |   1.0206021796774d-03, 2.1599968374095d-03, 4.2277557934892d-03,
     |   7.6768315866339d-03, 1.2966649100454d-02, 2.0418829270928d-02,
     |   3.0034365398903d-02, 4.1330998318510d-02, 5.3279250068430d-02,
     |   6.4401926139556d-02, 7.3049574766052d-02, 7.7790207592799d-02,
     |   7.7790207592799d-02, 7.3049574766052d-02, 6.4401926139556d-02,
     |   5.3279250068430d-02, 4.1330998318510d-02, 3.0034365398903d-02,
     |   2.0418829270928d-02, 1.2966649100454d-02, 7.6768315866340d-03,
     |   4.2277557934892d-03, 2.1599968374095d-03, 1.0206021796774d-03,
     |   4.4436552895119d-04, 1.7752784984804d-04, 6.4758343846484d-05,
     |   2.1445447909942d-05, 6.4042951780149d-06, 1.7111427928228d-06,
     |   4.0527383812819d-07, 8.4153712538000d-08, 1.5119476194243d-08,
     |   2.3132881535119d-09, 2.9561173892322d-10, 3.0803096650111d-11,
     |   2.5396005450209d-12, 1.5929270327968d-13, 7.1147672380575d-15,
     |   1.3790939565369d-16,-9.8719482906506d-17,-6.8111387907188d-17,
     |  -4.6346584613124d-17,-7.8398088651546d-18, 2.1747930185486d-17,
     |   5.2230734327545d-17, 7.2109496657508d-17, 7.6208274413073d-17/
      data (zmn(lat, 0,33), lat = 1,72)/
     |   3.9857318772491d-03, 2.4030977505793d-03,-1.1264392383328d-02,
     |  -5.0749120902015d-03, 1.3188550576549d-02, 9.9656558192724d-03,
     |  -1.3969812453331d-02,-1.4409022874668d-02, 1.2289548513764d-02,
     |   1.9209838411183d-02,-9.4933698954630d-03,-2.2899615471408d-02,
     |   4.9226223090795d-03, 2.5913532724686d-02, 3.5278300886961d-04,
     |  -2.7254805660502d-02,-6.6029259858506d-03, 2.7334713618969d-02,
     |   1.2828830358500d-02,-2.5520796854424d-02,-1.9108975274715d-02,
     |   2.2340382052096d-02, 2.4533968101554d-02,-1.7476085178840d-02,
     |  -2.9156050378777d-02, 1.1606004163972d-02, 3.2227282316191d-02,
     |  -4.6537221190319d-03,-3.3906193269400d-02,-2.5924701753935d-03,
     |   3.3669766139140d-02, 1.0077925102253d-02,-3.1865677390209d-02,
     |  -1.6992853874467d-02, 2.8217061546441d-02, 2.3281535440045d-02,
     |  -2.3281535440045d-02,-2.8217061546442d-02, 1.6992853874467d-02,
     |   3.1865677390209d-02,-1.0077925102253d-02,-3.3669766139140d-02,
     |   2.5924701753932d-03, 3.3906193269400d-02, 4.6537221190321d-03,
     |  -3.2227282316191d-02,-1.1606004163972d-02, 2.9156050378777d-02,
     |   1.7476085178840d-02,-2.4533968101554d-02,-2.2340382052096d-02,
     |   1.9108975274714d-02, 2.5520796854424d-02,-1.2828830358500d-02,
     |  -2.7334713618969d-02, 6.6029259858503d-03, 2.7254805660502d-02,
     |  -3.5278300886996d-04,-2.5913532724686d-02,-4.9226223090797d-03,
     |   2.2899615471408d-02, 9.4933698954630d-03,-1.9209838411183d-02,
     |  -1.2289548513765d-02, 1.4409022874668d-02, 1.3969812453331d-02,
     |  -9.9656558192724d-03,-1.3188550576549d-02, 5.0749120902016d-03,
     |   1.1264392383328d-02,-2.4030977505792d-03,-3.9857318772491d-03/
      data (zmn(lat, 1,33), lat = 1,72)/
     |   2.2285009571635d-03, 9.0743932936467d-03, 2.0731189166248d-03,
     |  -1.3058602103204d-02,-6.4853373696824d-03, 1.4454703477956d-02,
     |   1.1484795779753d-02,-1.3990783252460d-02,-1.6411615182169d-02,
     |   1.1739974049474d-02, 2.0890148432219d-02,-7.9869595410472d-03,
     |  -2.4451151480293d-02, 2.9739392961643d-03, 2.6786042440385d-02,
     |   2.9147535202977d-03,-2.7619102862776d-02,-9.2894548176757d-03,
     |   2.6824597187832d-02, 1.5691873639543d-02,-2.4360952704979d-02,
     |  -2.1687035010463d-02, 2.0327749429517d-02, 2.6843610403531d-02,
     |  -1.4916508334909d-02,-3.0799536784589d-02, 8.4301292349224d-03,
     |   3.3257477037561d-02,-1.2369025514749d-03,-3.4027185549428d-02,
     |  -6.2348745668240d-03, 3.3021274673356d-02, 1.3540748721465d-02,
     |  -3.0273926614354d-02,-2.0239405054892d-02, 2.5929711997997d-02,
     |   2.5929711997997d-02,-2.0239405054891d-02,-3.0273926614354d-02,
     |   1.3540748721465d-02, 3.3021274673356d-02,-6.2348745668242d-03,
     |  -3.4027185549428d-02,-1.2369025514754d-03, 3.3257477037561d-02,
     |   8.4301292349225d-03,-3.0799536784589d-02,-1.4916508334909d-02,
     |   2.6843610403531d-02, 2.0327749429517d-02,-2.1687035010463d-02,
     |  -2.4360952704979d-02, 1.5691873639543d-02, 2.6824597187832d-02,
     |  -9.2894548176756d-03,-2.7619102862776d-02, 2.9147535202975d-03,
     |   2.6786042440385d-02, 2.9739392961642d-03,-2.4451151480293d-02,
     |  -7.9869595410472d-03, 2.0890148432219d-02, 1.1739974049474d-02,
     |  -1.6411615182169d-02,-1.3990783252460d-02, 1.1484795779753d-02,
     |   1.4454703477957d-02,-6.4853373696821d-03,-1.3058602103204d-02,
     |   2.0731189166247d-03, 9.0743932936467d-03, 2.2285009571636d-03/
      data (zmn(lat, 2,33), lat = 1,72)/
     |   4.0904254606606d-04, 6.4373809110177d-03, 1.2064020374705d-02,
     |   2.5361887021325d-04,-1.5339450744453d-02,-6.2878535202280d-03,
     |   1.6204102843432d-02, 1.2074505991396d-02,-1.4925223784613d-02,
     |  -1.7540120638246d-02, 1.1949295546448d-02, 2.2127363040050d-02,
     |  -7.4067606327738d-03,-2.5603718495957d-02, 1.7671728062543d-03,
     |   2.7555593872936d-02, 4.6703032320437d-03,-2.7885235509031d-02,
     |  -1.1357162143279d-02, 2.6415449749272d-02, 1.7909893485987d-02,
     |  -2.3264496363761d-02,-2.3788887162983d-02, 1.8508652410806d-02,
     |   2.8650586849395d-02,-1.2482582739979d-02,-3.2075007337189d-02,
     |   5.4706887224557d-03, 3.3872078688299d-02, 2.0408142821602d-03,
     |  -3.3829285963789d-02,-9.6564594869090d-03, 3.1981030586170d-02,
     |   1.6847298259545d-02,-2.8358798708196d-02,-2.3231294464025d-02,
     |   2.3231294464025d-02, 2.8358798708196d-02,-1.6847298259545d-02,
     |  -3.1981030586170d-02, 9.6564594869090d-03, 3.3829285963789d-02,
     |  -2.0408142821600d-03,-3.3872078688299d-02,-5.4706887224559d-03,
     |   3.2075007337189d-02, 1.2482582739979d-02,-2.8650586849395d-02,
     |  -1.8508652410806d-02, 2.3788887162983d-02, 2.3264496363761d-02,
     |  -1.7909893485986d-02,-2.6415449749273d-02, 1.1357162143278d-02,
     |   2.7885235509031d-02,-4.6703032320434d-03,-2.7555593872936d-02,
     |  -1.7671728062540d-03, 2.5603718495957d-02, 7.4067606327740d-03,
     |  -2.2127363040050d-02,-1.1949295546448d-02, 1.7540120638246d-02,
     |   1.4925223784613d-02,-1.2074505991395d-02,-1.6204102843432d-02,
     |   6.2878535202279d-03, 1.5339450744452d-02,-2.5361887021340d-04,
     |  -1.2064020374705d-02,-6.4373809110178d-03,-4.0904254606614d-04/
      data (zmn(lat, 3,33), lat = 1,72)/
     |   1.2114711622099d-05, 2.6693696673959d-03, 1.1112877673523d-02,
     |   1.3279284688697d-02,-2.7367538887102d-03,-1.7557383637305d-02,
     |  -4.8487369394416d-03, 1.8274915933194d-02, 1.1845481501486d-02,
     |  -1.6534060168078d-02,-1.8026235456106d-02, 1.2830590254963d-02,
     |   2.3033427682182d-02,-7.5674220186748d-03,-2.6545422990854d-02,
     |   1.1910203296299d-03, 2.8306209113052d-02, 5.8182369009849d-03,
     |  -2.8174420246116d-02,-1.2946178444455d-02, 2.6125694067200d-02,
     |   1.9683366329063d-02,-2.2267391107578d-02,-2.5546870404653d-02,
     |   1.6825270566927d-02, 3.0117616055527d-02,-1.0135110729618d-02,
     |  -3.3062292597206d-02, 2.6158543069239d-03, 3.4159336276125d-02,
     |   5.2548595491638d-03,-3.3310388937944d-02,-1.2975606650729d-02,
     |   3.0549056444269d-02, 2.0053084975128d-02,-2.6036835105404d-02,
     |  -2.6036835105404d-02, 2.0053084975128d-02, 3.0549056444269d-02,
     |  -1.2975606650729d-02,-3.3310388937943d-02, 5.2548595491640d-03,
     |   3.4159336276125d-02, 2.6158543069244d-03,-3.3062292597206d-02,
     |  -1.0135110729618d-02, 3.0117616055527d-02, 1.6825270566927d-02,
     |  -2.5546870404653d-02,-2.2267391107578d-02, 1.9683366329063d-02,
     |   2.6125694067200d-02,-1.2946178444455d-02,-2.8174420246116d-02,
     |   5.8182369009849d-03, 2.8306209113052d-02, 1.1910203296301d-03,
     |  -2.6545422990854d-02,-7.5674220186748d-03, 2.3033427682182d-02,
     |   1.2830590254963d-02,-1.8026235456106d-02,-1.6534060168078d-02,
     |   1.1845481501486d-02, 1.8274915933194d-02,-4.8487369394417d-03,
     |  -1.7557383637305d-02,-2.7367538887105d-03, 1.3279284688697d-02,
     |   1.1112877673523d-02, 2.6693696673960d-03, 1.21147