
;  write_density.pro
;  run this after read_density.pro

;  from slinker's big-writeUNVN.pro

; z(*,*,32,*) is about 85km
; z(*,*,96,*) is bogus so ignore

; max(z(*,*,27,*)) is 78km (min(76))

;
; zp -10 is about 78 km
; At single-res, zp -10 is k=
;
jalt0 = 13         ; for double-res vertical
jalt1 = JALT - 2

z = reform(z_data(*,*,jalt0:jalt1,*))
un = reform(un_data(*,*,jalt0:jalt1,*))
vn = reform(vn_data(*,*,jalt0:jalt1,*))

n2 = reform(n2_density(*,*,jalt0:jalt1,*))
o2 = reform(o2_density(*,*,jalt0:jalt1,*))
o1 = reform(o1_density(*,*,jalt0:jalt1,*))
n4s = reform(n_density(*,*,jalt0:jalt1,*))
no = reform(no_density(*,*,jalt0:jalt1,*))
h = reform(h_density(*,*,jalt0:jalt1,*))
tn = reform(tn_data(*,*,jalt0:jalt1,*))

; convert to single precision
z=float(z)
un=float(un)
vn=float(vn)
glat=float(lats)
glon=float(lons)
n2=float(n2)
o2=float(o2)
o1=float(o1)
n4s=float(n4s)
no=float(no)
h=float(h)
tn=float(tn)

;openw,11,'TIMEGCM.inp',/f77_unformatted
openw,11,'TIMEGCM.dat',/f77_unformatted

;n0=72L & n1=36L & nn2=69L & n3=2L

sizevec = size(z)
n0=sizevec(1) & n1=sizevec(2) & nn2=sizevec(3)
if (sizevec(0) gt 3) then n3 = sizevec(4) else n3 = 1
print,'write_density: n0,n1,nn2,n3=',n0,n1,nn2,n3

writeu,11,n0,n1,nn2,n3
writeu,11,glat
writeu,11,glon
writeu,11,z
writeu,11,un
writeu,11,vn
writeu,11,tn
writeu,11,n2
writeu,11,o2
writeu,11,o1
writeu,11,n4s
writeu,11,no
writeu,11,h
close,11

;print,n0,n1,nn2,n3

end
