!
      module proc
      implicit none
!
! Processor version descriptor:
      character(len=8),parameter :: proc_version = '2.4     '
!
! Global constants and variables for tgcmproc:
!
      integer, parameter :: ispval=-9999	! integer special value
      real, parameter :: spval=1.e36		! real special value
!
! p0 is not a parameter, as it must be changed for mtgcm (see getflds)
! (for tgcm, p0=5.e-4, for mtgcm p0=1.2e-3)
!
      real :: p0=5.e-4				! standard pressure (mb)
      real :: pi				! pi will be calculated
!
! Geographic grid for 5.0 degree ("regular") resolution:
!     integer, parameter :: nlat=36	! number of latitudes
!     real, parameter :: dlat=5.	! delta latitude
!     real, parameter :: glat1=-87.5	! first latitude
!     integer, parameter :: nlon=73	! number of longitudes
!     real, parameter :: dlon=5.	! delta longitude
!
! Geographic grid for 2.5 degree ("double") resolution:
      integer, parameter :: nlat=72	! number of latitudes 2.5 deg
      real, parameter :: dlat=2.5	! delta latitude 2.5 deg
      real, parameter :: glat1=-88.75	! first latitude
      integer, parameter :: nlon=145	! number of longitudes 2.5 deg
      real, parameter :: dlon=2.5	! delta longitude 2.5 deg
!
! Grid arrays (glon1=-180 for both resolutions):
      real, parameter :: glon1=-180.	! first longitude
      real :: gcmlat(nlat)		! geographic latitude array
      real :: gcmlon(nlon)		! geographic longitude array
!
! Special value flags:
      real, parameter :: zmflag=999.	  ! zonal mean flag
      real, parameter :: sltflag=9999.	  ! slt (local time) flag
      real, parameter :: vintegflag=888.  ! vertical integration flag
      real, parameter :: hmf2flag=99999.  ! hmf2 height flag
      real, parameter :: gmflag=99999.    ! global mean flag
      integer, parameter :: mtimeflag=999 ! mtime special value
!
! Vertical pressure grid:
! npress, zpb, zpt are read from history (see rdhist and tgcmtype)
!
      integer :: npress			! number of pressure levels
      real :: zpb,zpt			! bottom and top levels (midpoints)
      real :: zpib,zpit			! bottom and top levels (interfaces)
      real :: dlev			! delta pressure level
      real,allocatable :: gcmlev(:)	! log pressure level array (midpoints)
      real,allocatable :: gcmilev(:)	! log pressure level array (interfaces)
!
! Parameters for input dimensions:
!
      integer,parameter :: 
     +  mxhvols=400,	! max number of history volumes
     +  lenhvol=1024,	! max length of volume path
     +  mxtms=10000,	! max number of model times (721 = 30days @ 1hr)
     +  mxslice=100,	! max number of selected slices
     +  mxzpht=100,	! max number of selected zp and/or ht for maps
     +  mxperimlat=nlat,! max number of perimeter lats for polar maps
     +  mxloc=2000,	! max number of locations (for ipltxyloc, etc)
     +  mxfproc=100	! max number of fields to process per run
!
! Global variables derived from inputs:
!
      integer :: 
     +  ntimes,		! number of model times
     +  nvols,		! number of history volumes
     +  nvols_cntr,	! number of control history volumes
     +  mxdiskvols,	! max number of hist vols allowed on disk
     +  iohglb		! if > 0, find oh globally, otherwise only at reqlocs
      logical :: diffs	! true if doing difference fields
      real(kind=8) :: reqlocs(2,mxloc)=spval	! all requested locations
!
! Local disk file names for output files:
! These files are built on the disk by the processor, and rcp'd at the
!   end of the run (by rcpfile) to the users requested machine:path
!   (sendcgm, sendps, etc).
! (flnm_cdf (netcdf output file name) is declared in main tgcmproc, 
!  and defined by mkcdf))
! (flnm_v5d (vis5d output file name) is declared in main tgcmproc, 
!  and defined by mkv5d))
!
! Other global runtime variables:
!
      integer :: iframe=1	! current graphics frame number
      integer :: iframe_dat=1	! current ascii data frame number
      integer :: iframe_xdr=1	! current xdr data frame number
      integer :: nppf=0		! current number of plots per frame
      integer :: iwrdat,iwrxdr	! flags for output data files
      integer :: ludat ,luxdr 	! lu's for output data files
! 4/29/04 btf: iplot is now namelist input
!     integer :: iplot		! turned off if sendcgm,sendps not given
      integer,parameter :: mxwave=4	! max wave number for amplitudes/phases
      integer :: iwrdat_bf      ! flags for output data files in Bougher format
      integer :: ludat_bf       ! lu's for output data files in Bougher format
!
! 6/22/04: cwd (execution directory). Getcwd (util.F) is called by main 
!          tgcmproc.F.  Cwd is used when verifying tmpdir (see input.F)
      character(len=240) :: cwd
!
      end module proc
