import argparse,sys,os
from subprocess import check_output,call
#-----------------------------------------------------------------------
def get_args():
  parser = argparse.ArgumentParser(description='Make plots using tgcmproc_f90')

  parser.add_argument('-executable', help='Path to tgcmproc executable')
  parser.add_argument('-singleut'  , help='Make single-ut plots (maps,slices) (0/1)')
  parser.add_argument('-multiut'   , help='Make multiple-ut plots (ut vs lats, ut vs levs) (0/1)')
  parser.add_argument('-cfields'   , help='List of fields to plot (must be 4d fields on history files)')
  parser.add_argument('-nlfile'    , help='Namelist input file')
  parser.add_argument('-mtimes'    , help='model time(s) (day,hour,min)')
  parser.add_argument('-flnm_ps'   , help='Postscript output file name.')

  parser.add_argument('-pltmaps'   , help='Make horizontal map plots at selected levels.')
  parser.add_argument('-fmap_zpht' , help='Log pressure or height level(s) to plot.') 
  parser.add_argument('-pltlon'    , help='Make latitude vs level slice plots at selected longitudes or slt.')
  parser.add_argument('-flons'     , help='Longitides at which to make latitude vs level slices ("zm")')
  parser.add_argument('-fslts'     , help='Local times at which to make longitude slices.')
  parser.add_argument('-pltlat'    , help='Make longitude vs level slice plots at selected latitudes.')
  parser.add_argument('-flats'     , help='Latitudes at which to make longitude vs level slice plots.')
  parser.add_argument('-pltxyloc'  , help='Make field vs level line plots at selected locations.')
  parser.add_argument('-xylocs'    , help='Lat,lon locations at which to make field vs level line plots.')
  parser.add_argument('-xyloc_zprange', help='Range of levels for y-axis of field vs levels line plots.')

  parser.add_argument('-pltutvert'  ,help='Make UT vs levels plots at selected locations.')
  parser.add_argument('-utvert_locs',help='Locations at which to make ut vs levels plots' \
                                          +"(can be 'lat,lon','sltxxx',and/or 'zm,zm')")
  parser.add_argument('-utvert_zprange' ,help='Range of levels for utvert plots (-999,999) means bottom to top of the model')
  parser.add_argument('-pltutlat'     ,help='Make UT vs latitude plots at selected levels and longitudes.')
  parser.add_argument('-utlat_zphtlon',help='Level,longitude pairs at which to make ut vs latitude plots.')

  parser.add_argument('-stdout'    , help='Output (stdout) file for tgcmproc')
  parser.add_argument('-submit'    , help='Execute the processor without prompting? (yes/no)')
  parser.add_argument('ncfiles'    , nargs='+', help='History files(s)') # required positional arg

  args = parser.parse_args()
# print 'get_args: args=',args
  return args
#-----------------------------------------------------------------------
def mtime_to_string(mtime):
#
# Convert 3-int mtime to string:
#
  mtime_str = ''
  for i in xrange(3):
    if i == 0:
      mtime_str = str(mtime[i])
    else:
      mtime_str = mtime_str+','+str(mtime[i])
  return mtime_str
#-----------------------------------------------------------------------
def find_dtime(mtime0,mtime1):
#
# Given two integer model times (day,hr,min), find delta time in mins
#
  mins0 = mtime0[0]*24*60 + mtime0[1]*60 + mtime0[2] 
  mins1 = mtime1[0]*24*60 + mtime1[1]*60 + mtime1[2] 
  print 'find_dtime: mtime0=',mtime0,' mtime1=',mtime1
  print 'find_dtime: mins0=',mins0,' mins1=',mins1,' dt=',mins1-mins0
  return mins1-mins0
#-----------------------------------------------------------------------
def get_options(arg,option,proc):
#
# Namelist input file:
#
  if arg == 'nlfile':
    if option:
      return option
    else:
      if proc.singleut=='1' and proc.multiut=='0':
        return 'tgcmproc_singleut.inp'
      elif proc.singleut=='0' and proc.multiut=='1':
        return 'tgcmproc_multiut.inp'
      else:
        return 'tgcmproc.inp'
#
# Executable:
#
  elif arg == 'executable':
    if option:
      if not os.path.isfile(option):
        print '>>> Cannot find executable ',option
        sys.exit()
      executable = option
    else:
      if proc.res == '5.0':
        executable = check_output(['which','tgcmproc_f90'])
      else:
        executable = check_output(['which','tgcmproc_dres_f90'])
      executable = executable.rstrip('\n')
#   print 'getoptions: executable=',executable
    return executable
#
# Make single-ut plots:
#
  elif arg == 'singleut':
    if option:
      return option
    else:
      return '0'
#
# Make multi-ut plots:
#
  elif arg == 'multiut':
    if option:
      return option
    else:
      return '0'
#
# Model times: a string with either multiples of 3 ints,
#     E.g., '330,0,0', or "'329,0,0','330,0,0'"
#   or the short-cut form:
#     "3-ints,'to',3-ints,'by',delta_min
#     E.g.: mtimes = "10,0,0,'to',11,0,0,'by',60"
#
  elif arg == 'mtimes':
    if option:
      mtime_str = option
      if '-999' in mtime_str:
        file,mtime = proc.find_mtime([-999,0,0])
        mtime_str = mtime_str.replace('-999',str(mtime[0]))
      if '999' in mtime_str:
        file,mtime = proc.find_mtime([999,0,0])
        mtime_str = mtime_str.replace('999',str(mtime[0]))
#     print 'getoptions mtimes: returning ',mtime_str
      return mtime_str
    else:
      if proc.singleut=='1' and proc.multiut=='0': # return last mtime on last file
        file,mtime = proc.find_mtime([999,0,0])
        return mtime_to_string(mtime)
      elif proc.multiut=='1': # return 5-element string
        file,mtime0 = proc.find_mtime([-999,0,0])
        file,mtime1 = proc.find_mtime([999,0,0])
        dhist = proc.find_dhist() # delta time between histories (global file attribute)
        dhist = str(dhist)
        if dhist=='0': print '>>> WARNING: dhist=',dhist
        mtime0 = mtime_to_string(mtime0)
        mtime1 = mtime_to_string(mtime1)
        return mtime0+",'to',"+mtime1+",'by',"+dhist
#
# Fields to plot:
#
  elif arg == 'cfields':
    if option:
      return option
    else:
      return "'TN','UN','VN','WN','O2','O1','N2','NO','N4S','HE','NE','TE','TI','TEC',\n"+ \
             "'O2P','OP','POTEN','UI_ExB','VI_ExB','WI_ExB','DEN','QJOULE','HMF2','NMF2','Z'"
#
# ps output file:
#
  elif arg == 'flnm_ps':
    if option:
      return option
    else:
      if proc.singleut=='1' and proc.multiut=='0':
        return 'tgcmproc_singleut.ps'
      elif proc.singleut=='0' and proc.multiut=='1':
        return 'tgcmproc_multiut.ps'
      else:
        return 'tgcmproc.ps'
#
# pltmaps flag:
#
  elif arg == 'pltmaps':
    if option: 
      return option
    else:
      pltmaps = '0'
      if proc.singleut: pltmaps = '1'
      return pltmaps
#
# fmap_zpht:
# Convert list of floats to a string.
#
  elif arg == 'fmap_zpht':
    if option:
      return option
    else:
      return '-7.,-4.,0.,2.,4.' 
#
# pltlon flag:
#
  elif arg == 'pltlon':
    if option: 
      return option
    else: 
      pltlon = '0'
      if proc.singleut: pltlon = '1'
      return pltlon
#
# flons (set to 'zm' for now)
#
  elif arg == 'flons':
    if option:
      return option
    else:
      return 'zm'
#
# fslts: Local times for lon slices 
#
  elif arg == 'fslts':
    if option:
      return option
    else:
      return '0. 12.'
#
# pltlat flag:
#
  elif arg == 'pltlat':
    if option: 
      return option
    else:
      pltlat = '0'
      if proc.singleut: pltlat = '1'
      return pltlat
#
# flats:
#
  elif arg == 'flats':
    if option:
      return option
    else:
      return '-60., -40., 0., 40., 60.'
#
# pltxyloc flag:
#
  elif arg == 'pltxyloc':
    if option: 
      return option
    else:
      pltxyloc = '0'
      if proc.singleut: pltxyloc = '1'
      return pltxyloc
#
# xylocs:
#
  elif arg == 'xylocs':
    if option: 
      return option
    else:
      return \
        "\n-60.,'slt0.', -60.,'slt12.', -60.,'zm',\n"+ \
          "-40.,'slt0.', -40.,'slt12.', -40.,'zm',\n"+ \
          " 40.,'slt0.',  40.,'slt12.',  40.,'zm',\n"+ \
          " 60.,'slt0.',  60.,'slt12.',  60.,'zm','zm','zm'"
#
# xyloc_zprange:
#
  elif arg == 'xyloc_zprange':
    if option:
      return option
    else:
      return '-99.,99.'
#
# pltutvert (make ut vs vertical plots) (multiut only):
#
  elif arg == 'pltutvert':
    if option: 
      return option
    else:
      pltutvert = '0'
      if proc.multiut: pltutvert = '1' 
      return pltutvert
#
# Locations at which to make pltutvert plots:
# ('lat,lon' and/or 'zm','zm' (global mean), and/or 'slt12.' (a local time)) 
#
  elif arg == 'utvert_locs':
    if option:
      return option
    else: # default is local midnight, local noon, and global means
      return \
        "\n-60.,'slt0.',-60.,'slt12.',-60.,'zm',\n"+ \
          "-40.,'slt0.',-40.,'slt12.',-40.,'zm',\n"+ \
          "  0.,'slt0.',  0.,'slt12.',  0.,'zm',\n"+ \
          " 40.,'slt0.', 40.,'slt12.', 40.,'zm',\n"+ \
          " 60.,'slt0.', 60.,'slt12.', 60.,'zm'"
#
# zprange (range of log-pressure in which to make ut vs vertical plots:
# -999.,999. means bottom to top of the model
#
  elif arg == 'utvert_zprange':
    if option:
      return option
    else: 
      return '-999.,999.'
#
# pltutlat plots (ut vs latitude at selected levs,lons)
#
  elif arg == 'pltutlat':
    if option:
      return option
    else:
      pltutlat = '0'
      if proc.multiut: pltutlat = '1' 
      return pltutlat
#
# levs,lons pairs at which to make ut vs latitude plots:
#
  elif arg == 'utlat_zphtlon':
    if option:
      return option
    else:
#     return \
#       "\n-4.,'slt0.', -4.,'slt12.', -4.,'zm',\n"+ \
#         " 0.,'slt0.',  0.,'slt12.',  0.,'zm',\n"+ \
#         " 2.,'slt0.',  2.,'slt12.',  2.,'zm',\n"+ \
#         " 5.,'slt0.',  5.,'slt12.',  5.,'zm'"
      return \
        "\n-4.,'slt0.', -4.,'slt12.', -4.,'zm',\n"+ \
          " 0.,'slt0.',  0.,'slt12.',  0.,'zm',\n"+ \
          " 4.,'slt0.',  4.,'slt12.',  4.,'zm'"
#
# stdout file:
# def dir_from_filename(filename):
#
  elif arg == 'stdout':
    if option:
      dirname = os.path.dirname(option)
      if not os.path.isdir(dirname):
        os.makedirs(dirname)
#       print 'Made directory ',dirname,' for stdout'
      return option
    else:
      return '' # default is cwd
#
# Submit flag (yes/no):
#
  elif arg == 'submit':
    if option:
      if option != 'yes' and option != 'no':
        print "\n>>> Oooops, bad value for -submit: ",option," (must be 'yes' or 'no')"
        sys.exit()
      return option
